/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportTableHeadItemInfo;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class ReportTableHeadInfo
implements Serializable,
Cloneable {
    private static final Logger logger = Logger.getLogger(ReportTableHeadInfo.class);
    private String[][] titles = null;
    private boolean[][] titleNeedResource = null;
    private int[] widths = null;
    private int[] alignments = null;
    private String[] columnNames = null;
    private boolean[] merges = null;
    private boolean[] freezes = null;
    private boolean[] visibles = null;
    private int columnCount = -1;
    private boolean headMerge = false;
    private boolean[] needKilobits = null;
    private int[] numberScales = null;
    private int[] numberStyleTypes = null;

    public ReportTableHeadInfo() {
    }

    public ReportTableHeadInfo(ReportTableHeadItemInfo[] items) {
        if (items != null && items.length > 0) {
            int j;
            int i;
            this.columnCount = items.length;
            this.columnNames = new String[this.columnCount];
            this.widths = new int[this.columnCount];
            this.alignments = new int[this.columnCount];
            this.merges = new boolean[this.columnCount];
            this.freezes = new boolean[this.columnCount];
            this.visibles = new boolean[this.columnCount];
            this.numberStyleTypes = new int[this.columnCount];
            this.numberScales = new int[this.columnCount];
            this.needKilobits = new boolean[this.columnCount];
            int maxHeadLineCount = 0;
            for (i = 0; i < items.length; ++i) {
                maxHeadLineCount = items[i].getTitles().length > maxHeadLineCount ? items[i].getTitles().length : maxHeadLineCount;
            }
            this.titles = new String[maxHeadLineCount][];
            this.titleNeedResource = new boolean[maxHeadLineCount][];
            for (i = 0; i < this.titles.length; ++i) {
                this.titles[i] = new String[this.columnCount];
                this.titleNeedResource[i] = new boolean[this.columnCount];
                for (j = 0; j < this.titleNeedResource[i].length; ++j) {
                    this.titleNeedResource[i][j] = true;
                }
            }
            for (i = 0; i < this.columnCount; ++i) {
                this.columnNames[i] = items[i].getColumnName();
                this.widths[i] = items[i].getWidth();
                this.alignments[i] = items[i].getAlignment();
                this.merges[i] = items[i].isMerge();
                this.freezes[i] = items[i].isFreeze();
                this.visibles[i] = items[i].isVisible();
                this.numberStyleTypes[i] = items[i].getNumberStyleType();
                this.numberScales[i] = items[i].getNumberScale();
                this.needKilobits[i] = items[i].isNeedKilobit();
                for (j = 0; j < items[i].getTitles().length; ++j) {
                    this.titles[j][i] = items[i].getTitles()[j];
                    if (items[i].getTitleNeedResource() == null) continue;
                    this.titleNeedResource[j][i] = items[i].getTitleNeedResource()[j];
                }
            }
            if (maxHeadLineCount > 1) {
                for (i = 0; i < items.length; ++i) {
                    for (j = 1; j < maxHeadLineCount; ++j) {
                        this.titleNeedResource[j][i] = this.titles[j][i] == null ? this.titleNeedResource[j - 1][i] : this.titleNeedResource[j][i];
                        this.titles[j][i] = this.titles[j][i] == null ? this.titles[j - 1][i] : this.titles[j][i];
                    }
                }
            }
        }
    }

    public String[][] getTitles() {
        return this.titles;
    }

    public void setTitles(String[][] titles) {
        this.titles = titles;
    }

    public int[] getWidths() {
        return this.widths;
    }

    public void setWidths(int[] widths) {
        this.widths = widths;
    }

    public int[] getAlignments() {
        return this.alignments;
    }

    public void setAlignments(int[] alignments) {
        this.alignments = alignments;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
        if (columnNames != null) {
            this.columnCount = columnNames.length;
        }
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public boolean[] getMerges() {
        return this.merges;
    }

    public void setMerges(boolean[] merges) {
        this.merges = merges;
    }

    public boolean[] getFreezes() {
        return this.freezes;
    }

    public void setFreezes(boolean[] freezes) {
        this.freezes = freezes;
    }

    public boolean check() throws ReportException {
        if (this.getColumnCount() <= 0) {
            return false;
        }
        String[][] titles = this.getTitles();
        if (titles == null || titles.length == 0 || titles[0] == null || titles[0].length != this.getColumnCount()) {
            return false;
        }
        int[] widths = this.getWidths();
        if (widths == null || widths.length != this.getColumnCount()) {
            return false;
        }
        int[] alignments = this.getAlignments();
        if (alignments != null && alignments.length != this.getColumnCount()) {
            return false;
        }
        boolean[] merges = this.getMerges();
        if (merges != null && merges.length != this.getColumnCount()) {
            return false;
        }
        boolean[] freezes = this.getFreezes();
        if (freezes != null && freezes.length != this.getColumnCount()) {
            return false;
        }
        boolean[] visibles = this.getVisibles();
        if (visibles != null && visibles.length != this.getColumnCount()) {
            return false;
        }
        int[] numberFormatStyles = this.getNumberStyleTypes();
        if (numberFormatStyles != null) {
            if (numberFormatStyles.length != this.getColumnCount()) {
                return false;
            }
            boolean needScale = false;
            boolean needKilobit = false;
            for (int i = 0; i < numberFormatStyles.length; ++i) {
                if (numberFormatStyles[i] == 1) {
                    needScale = true;
                    needKilobit = true;
                    continue;
                }
                if (numberFormatStyles[i] != 2) continue;
                needKilobit = true;
            }
            if (needScale && (this.getNumberScales() == null || this.getNumberScales().length != this.getColumnCount())) {
                return false;
            }
            if (needKilobit && this.getNeedKilobits() == null) {
                return false;
            }
        }
        return true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            logger.error((Object)("clone err:" + e.getLocalizedMessage()));
            return null;
        }
    }

    public boolean isHeadMerge() {
        return this.headMerge;
    }

    public void setHeadMerge(boolean merge) {
        this.headMerge = merge;
    }

    public boolean[] getVisibles() {
        return this.visibles;
    }

    public void setVisibles(boolean[] bs) {
        this.visibles = bs;
    }

    public boolean[][] getTitleNeedResource() {
        return this.titleNeedResource;
    }

    public void setTitleNeedResource(boolean[][] bs) {
        this.titleNeedResource = bs;
    }

    public int[] getNumberStyleTypes() {
        return this.numberStyleTypes;
    }

    public void setNumberStyleTypes(int[] is) {
        this.numberStyleTypes = is;
    }

    public boolean[] getNeedKilobits() {
        return this.needKilobits;
    }

    public void setNeedKilobits(boolean[] bs) {
        this.needKilobits = bs;
    }

    public int[] getNumberScales() {
        return this.numberScales;
    }

    public void setNumberScales(int[] is) {
        this.numberScales = is;
    }
}

