/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class RunningBusinessMethod {
    private static Hashtable htInstance = new Hashtable();
    private static final Logger logger = Logger.getLogger(RunningBusinessMethod.class);

    private static Class[] changeToNeedType(Class[] argsType) {
        if (argsType == null) {
            return null;
        }
        Class[] changedType = new Class[argsType.length];
        for (int i = 0; i < argsType.length; ++i) {
            changedType[i] = argsType[i].equals(Boolean.class) ? Boolean.TYPE : (argsType[i].equals(Integer.class) ? Integer.TYPE : (argsType[i].equals(Double.class) ? Double.TYPE : (argsType[i].equals(Byte.class) ? Byte.TYPE : (argsType[i].equals(Short.class) ? Short.TYPE : argsType[i]))));
        }
        return changedType;
    }

    public static Object runMethod(Object instance, Class c, String methodName, Class[] argsType, Object[] args) throws BOSException {
        Object o = null;
        Method method = null;
        try {
            method = instance.getClass().getMethod(methodName, argsType);
        }
        catch (NoSuchMethodException e) {
            logger.fatal((Object)("Fatal error: method " + methodName + " in controller class " + c.getName() + " not found"));
            throw new BOSException(GLResUtil.getRes("method_not_exists"), (Throwable)e);
        }
        try {
            o = method.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            logger.fatal((Object)"Fatal error??Controller method invoke failure");
            throw new BOSException(GLResUtil.getRes("program_inner_error"), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.fatal((Object)("Fatal error: server part throw unknown exception:" + e.getTargetException()));
            BOSException se = new BOSException(e.getTargetException().getMessage(), (Throwable)e);
            throw se;
        }
        return o;
    }

    public static Object getInstanceByName(String className) throws BOSException {
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new BOSException(e.toString(), (Throwable)e);
        }
    }

    public static Object getImplRemoteInstance(String strImplClassName) throws BOSException {
        Object implInstance = null;
        Class<?> c = null;
        try {
            c = Class.forName(strImplClassName);
        }
        catch (ClassNotFoundException e) {
            logger.fatal((Object)("Fatal error: persistence factory class " + strImplClassName + " not found"));
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        Class[] getterArgsType = new Class[]{};
        Object[] getterArgs = new Object[]{};
        Method method = null;
        try {
            method = c.getMethod("getRemoteInstance", getterArgsType);
        }
        catch (NoSuchMethodException e) {
            logger.fatal((Object)"Fatal error: persistence factory method getRemoteInstance not found");
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        try {
            implInstance = method.invoke(null, getterArgs);
        }
        catch (Exception e) {
            logger.fatal((Object)"Fatal error: method invoke error");
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return implInstance;
    }

    public static Object runImplMethod(String strCtrlName, String strImplName, String methodName, Class[] argsType, Object[] args) throws BOSException {
        Class<?> c = null;
        try {
            c = Class.forName(strImplName);
        }
        catch (ClassNotFoundException e) {
            logger.fatal((Object)("Fatal error: controller class " + strCtrlName + " not found"));
            throw new BOSException(GLResUtil.getRes("no_class_founded"), (Throwable)e);
        }
        Object impl = RunningBusinessMethod.getImplRemoteInstance(strCtrlName);
        Class[] realType = RunningBusinessMethod.changeToNeedType(argsType);
        return RunningBusinessMethod.runMethod(impl, c, methodName, realType, args);
    }

    public static Object runLocalMethod(Context ctx, String strCtrlName, String strLocalName, String methodName, Class[] argsType, Object[] args) throws BOSException {
        Class<?> c = null;
        try {
            c = Class.forName(strLocalName);
        }
        catch (ClassNotFoundException e) {
            logger.fatal((Object)("Fatal error: controller class " + strCtrlName + " not found"));
            throw new BOSException(GLResUtil.getRes("no_class_founded"), (Throwable)e);
        }
        Object local = RunningBusinessMethod.getLocalInstance(ctx, strCtrlName);
        Class[] realType = RunningBusinessMethod.changeToNeedType(argsType);
        return RunningBusinessMethod.runMethod(local, c, methodName, realType, args);
    }

    public static Object getLocalInstance(Context ctx, String strClassName) throws BOSException {
        Object localInstance = null;
        Class<?> c = null;
        try {
            c = Class.forName(strClassName);
        }
        catch (ClassNotFoundException e) {
            logger.fatal((Object)("Fatal error: persistence factory class " + strClassName + " not found"));
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        Class[] getterArgsType = new Class[]{Context.class};
        Object[] getterArgs = new Object[]{ctx};
        Method method = null;
        try {
            method = c.getMethod("getLocalInstance", getterArgsType);
        }
        catch (NoSuchMethodException e) {
            logger.fatal((Object)"Fatal error: persistence factory method getRemoteInstance not found");
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        try {
            localInstance = method.invoke(null, getterArgs);
        }
        catch (Exception e) {
            logger.fatal((Object)"Fatal error: method invoke error");
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return localInstance;
    }

    public static Object runImplMethod(String strCtrlName, String strImplName, String methodName, Class[] argsType, Object[] args, BOSObjectType bosType) throws BOSException {
        Class<?> c = null;
        try {
            c = Class.forName(strImplName);
        }
        catch (ClassNotFoundException e) {
            logger.fatal((Object)("Fatal error: controller class " + strCtrlName + " not found"));
            throw new BOSException(GLResUtil.getRes("no_class_founded"), (Throwable)e);
        }
        Object impl = RunningBusinessMethod.getImplRemoteInstance(strCtrlName);
        Class[] bosTypeClass = new Class[]{bosType.getClass()};
        Object[] bosTypeArgs = new Object[]{bosType};
        RunningBusinessMethod.runMethod(impl, c, "setType", bosTypeClass, bosTypeArgs);
        Class[] realType = RunningBusinessMethod.changeToNeedType(argsType);
        return RunningBusinessMethod.runMethod(impl, c, methodName, realType, args);
    }

    public static Object runLocalMethod(Context ctx, String strCtrlName, String strLocalName, String methodName, Class[] argsType, Object[] args, BOSObjectType bosType) throws BOSException {
        Class<?> c = null;
        try {
            c = Class.forName(strLocalName);
        }
        catch (ClassNotFoundException e) {
            logger.fatal((Object)("Fatal error: controller class " + strCtrlName + " not found"));
            throw new BOSException(GLResUtil.getRes("no_class_founded"), (Throwable)e);
        }
        Object local = RunningBusinessMethod.getLocalInstance(ctx, strCtrlName);
        Class[] bosTypeClass = new Class[]{bosType.getClass()};
        Object[] bosTypeArgs = new Object[]{bosType};
        RunningBusinessMethod.runMethod(local, c, "setType", bosTypeClass, bosTypeArgs);
        Class[] realType = RunningBusinessMethod.changeToNeedType(argsType);
        return RunningBusinessMethod.runMethod(local, c, methodName, realType, args);
    }
}

