/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.FeeTypeEnum;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.ImpVoucherStructure;
import com.kingdee.eas.fi.gl.TemplateCashflowRecordCollection;
import com.kingdee.eas.fi.gl.TemplateCashflowRecordInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherAsstRecordCollection;
import com.kingdee.eas.fi.gl.TemplateVoucherAsstRecordInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherCollection;
import com.kingdee.eas.fi.gl.TemplateVoucherEntryCollection;
import com.kingdee.eas.fi.gl.TemplateVoucherEntryInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherIOSparser;
import com.kingdee.eas.fi.gl.TemplateVoucherInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherXLSCols;
import com.kingdee.eas.fi.gl.VoucherExpImpException;
import com.kingdee.eas.fi.gl.VoucherIMPColInfo;
import com.kingdee.eas.fi.gl.VoucherIOSparser;
import com.kingdee.eas.fi.gl.VoucherImpExpParam;
import com.kingdee.eas.fi.gl.VoucherImportUtils;
import com.kingdee.eas.fi.gl.WSVoucherCollection;
import com.kingdee.eas.fi.gl.WSVoucherInfo;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TemplateVoucherXLSXSparser
extends TemplateVoucherIOSparser {
    public static final String EXP_RES_NAME1 = "com.kingdee.eas.fi.gl.VoucherExpWizardByAssistUnitUI";
    public static final String EXP_RES_NAME2 = "com.kingdee.eas.fi.gl.VoucherExpWizardUI";
    private int voucherRows = 0;
    private int cashflowRows = 0;
    private boolean isUnit = false;
    private String[] typeAlias = new String[]{EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1040_VoucherXLSSparser"), EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1041_VoucherXLSSparser"), EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1042_VoucherXLSSparser"), EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1043_VoucherXLSSparser")};

    public TemplateVoucherXLSXSparser() {
        this.setCashflowRows(1);
        this.setVoucherRows(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map expVoucher(String strFullName, String strFilePath, String strFileName, boolean overide, VoucherImpExpParam filterParam) throws Exception {
        this.info("Export start");
        if (filterParam.isUnitByAsst()) {
            if (!VoucherIOSparser.EXP_RES_NAME.equals(EXP_RES_NAME1)) {
                VoucherIOSparser.EXP_RES_NAME = EXP_RES_NAME1;
            }
            this.isUnit = filterParam.isUnitByAsst();
        } else {
            VoucherIOSparser.EXP_RES_NAME = EXP_RES_NAME2;
        }
        Map<String, StringBuffer> map = new HashMap();
        StringBuffer areaInfo = new StringBuffer();
        String strPeriodInfoMidTitle = this.getResx(EXP_RES_NAME, "PeriodInfoMid");
        String strPeriodNumberTitle = this.getResx(EXP_RES_NAME, "PeriodNumber");
        String strVoucherTitle = this.getResx(EXP_RES_NAME, "Voucher");
        String strExpOKTitle = this.getResx(EXP_RES_NAME, "ExpOK");
        String strExpNotOKTitle = this.getResx(EXP_RES_NAME, "ExpNotOK");
        String expResult_before = this.getResx(EXP_RES_NAME, "ExpResult_before");
        String expResult_after = this.getResx(EXP_RES_NAME, "ExpResult_after");
        int expCount = 0;
        IGLGeneralFacade facade = GLGeneralFacadeFactory.getRemoteInstance();
        Calendar start = Calendar.getInstance();
        FilterInfo filter = this.getFilterInfo(filterParam);
        this.info("Get voucher pks ...");
        IObjectPK[] pkList = this.getVoucherPkList(filter);
        int size = pkList.length;
        Calendar end = Calendar.getInstance();
        logger.debug((Object)("1 " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
        SXSSFWorkbook wb = this.getWorkbook(strFullName, overide, this.isUnit);
        for (int cu = 0; cu < size; cu += 100) {
            this.info("Get vouchers " + cu + "/" + size + " ...");
            TemplateVoucherCollection voucherCollection = this.getVoucherPkList(cu, size, pkList, filter);
            this.info("Build excel " + cu + "/" + size + " ...");
            end = Calendar.getInstance();
            logger.debug((Object)("2." + (cu + 1) + " " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
            if (cu > 0) {
                overide = false;
            }
            if (voucherCollection == null || voucherCollection.size() <= 0) continue;
            CellStyle cellStyle = wb.createCellStyle();
            DataFormat fmt = wb.createDataFormat();
            cellStyle.setDataFormat(fmt.getFormat("m/d/yy"));
            try {
                for (int i = 0; i < voucherCollection.size(); ++i) {
                    TemplateVoucherInfo tmpVoucher = voucherCollection.get(i);
                    end = Calendar.getInstance();
                    logger.debug((Object)("3." + (i + 1) + " " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
                    String strVoucherTypeInfo = null;
                    if (tmpVoucher.getVoucherType() != null && tmpVoucher.getVoucherType().getName() != null) {
                        strVoucherTypeInfo = tmpVoucher.getVoucherType().getName().trim();
                    }
                    String strVoucherNumber = "";
                    if (tmpVoucher.getNumber() != null) {
                        strVoucherNumber = tmpVoucher.getNumber().trim();
                    }
                    String strVoucher = strVoucherTitle + GLResUtil.getRes("sign_colon") + strPeriodInfoMidTitle + strPeriodNumberTitle + strVoucherTypeInfo + strVoucherNumber;
                    try {
                        this.saveSingleVoucher(wb, tmpVoucher, i, facade, filterParam, cellStyle);
                        ++expCount;
                        areaInfo.append(this.getMessageBuffer(strVoucher, strExpOKTitle));
                        continue;
                    }
                    catch (Exception _ex) {
                        logger.error((Object)_ex);
                        areaInfo.append(this.getMessageBuffer(strVoucher, strExpNotOKTitle));
                        this.core.handUIException((Throwable)_ex);
                        logger.debug((Object)("ex: " + _ex.toString()));
                    }
                }
            }
            finally {
                map.put("areainfo", areaInfo);
            }
            end = Calendar.getInstance();
            logger.debug((Object)("4 " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
            StringBuffer resultInfo = new StringBuffer(expResult_before);
            resultInfo.append(expCount).append(expResult_after);
            map.put("resultinfo", resultInfo);
            end = Calendar.getInstance();
            logger.debug((Object)("5 " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
        }
        this.info("Save excel ...");
        this.saveWorkbook(wb, strFullName, overide);
        if (size == 0) {
            map = this.haveNoVoucher(expResult_before, expResult_after);
        }
        this.info("Export end");
        return map;
    }

    @Override
    protected TemplateVoucherCollection getVoucherPkList(int i, int size, IObjectPK[] pkList, FilterInfo filter) throws Exception {
        int j = 0;
        StringBuffer strFilter = new StringBuffer("");
        while (100 - j++ > 0 && i < size) {
            String id = pkList[i].toString();
            if (j > 1) {
                strFilter.append(",");
            }
            strFilter.append(id);
            ++i;
        }
        TemplateVoucherCollection voucherCollection = this.getVoucherCollection(strFilter.toString(), filter);
        TemplateCashflowRecordCollection cashflowCollection = this.getCashflowCollection(strFilter.toString());
        if (cashflowCollection.size() > 0) {
            this.mergeVoucherAndCashflow(voucherCollection, cashflowCollection);
        }
        return voucherCollection;
    }

    @Override
    public void checkFileValidate(String strFilePath, String strFileName) throws EASBizException {
        FileInputStream fis = null;
        Object fs = null;
        XSSFWorkbook wb = null;
        try {
            fis = new FileInputStream(strFilePath + "\\" + strFileName);
            wb = new XSSFWorkbook((InputStream)fis);
        }
        catch (IOException e) {
            this.core.handUIException((Throwable)e);
            throw new VoucherExpImpException(VoucherExpImpException.FIEL_NOT_EXIST);
        }
        XSSFSheet sheet1 = wb.getSheetAt(0);
        XSSFRow hssfRow = sheet1.getRow(2);
        if (hssfRow == null) {
            throw new VoucherExpImpException(VoucherExpImpException.FILE_STRUCTURE_ERROR);
        }
        for (int i = 0; i < 58; i = (int)((short)(i + 1))) {
            XSSFCell cell = hssfRow.getCell(9);
            if (cell != null) continue;
            throw new VoucherExpImpException(VoucherExpImpException.FILE_STRUCTURE_ERROR);
        }
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException e1) {
            logger.error((Object)e1);
            this.core.handUIException((Throwable)e1);
            throw new VoucherExpImpException(VoucherExpImpException.FILE_EXIST);
        }
    }

    @Override
    public void setExtraData(String strFilePath, String strFileName, KDSpinner spnVoucherNumberBegin, KDSpinner spnVoucherNumberEnd) throws EASBizException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(strFilePath + "\\" + strFileName);
            XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);
            XSSFSheet sheet1 = wb.getSheetAt(0);
            int size = sheet1.getLastRowNum();
            logger.debug((Object)("size:" + size));
            if (size < 3) {
                MsgBox.showError((String)GLResUtil.getRes("no_data_for_import"));
                SysUtil.abort();
            }
        }
        catch (IOException e) {
            this.core.handUIException((Throwable)e);
            throw new VoucherExpImpException(VoucherExpImpException.FIEL_NOT_EXIST);
        }
        finally {
            try {
                if (null != fis) {
                    fis.close();
                }
            }
            catch (IOException e1) {
                this.core.handUIException((Throwable)e1);
                throw new VoucherExpImpException(VoucherExpImpException.FILE_EXIST);
            }
        }
    }

    private WSVoucherCollection getCashFlowMap(XSSFSheet sheetCash, VoucherImpExpParam filterParam) throws Exception {
        if (!filterParam.isSelectCash()) {
            return null;
        }
        WSVoucherCollection cashs = new WSVoucherCollection();
        WSVoucherInfo wsvoucher = null;
        int cashflowSize = sheetCash.getLastRowNum();
        if (sheetCash.getRow(0) == null) {
            throw new VoucherExpImpException(VoucherExpImpException.CASH_NOTITLE);
        }
        Object objCol1 = this.getCellValue(sheetCash.getRow(0), 0, TemplateVoucherXLSCols.getCompany());
        boolean isMulTiCompany = VoucherImportUtils.isMultiCompany((String)objCol1);
        TemplateVoucherXLSCols cols = new TemplateVoucherXLSCols(isMulTiCompany, false);
        for (int i = 1; i <= cashflowSize; ++i) {
            BigDecimal rptAmount;
            BigDecimal localAmount;
            XSSFRow hssfRow = sheetCash.getRow(i);
            if (!this.checkCashRowCell(hssfRow, isMulTiCompany, i)) continue;
            wsvoucher = new WSVoucherInfo();
            wsvoucher.put("lineNum", new Integer(i + 1));
            wsvoucher.setItemFlag(1);
            cashs.add(wsvoucher);
            String companyNumber = isMulTiCompany ? (String)this.getCellValue(hssfRow, i, 0, 3) : this.getCompany().getNumber();
            wsvoucher.setCompanyNumber(companyNumber);
            String vouchernumber = (String)this.getCellValue(hssfRow, i, cols.getCashVoucherNumber());
            if (vouchernumber != null && vouchernumber.indexOf(46) > 0) {
                vouchernumber = vouchernumber.substring(0, vouchernumber.indexOf(46));
            }
            wsvoucher.put("cashVoucherNumber", vouchernumber);
            String cashVoucherName = (String)this.getCellValue(hssfRow, i, cols.getCashVoucherName());
            if (StringUtils.isEmpty((String)cashVoucherName)) {
                cashVoucherName = vouchernumber;
            }
            wsvoucher.put("cashVoucherName", cashVoucherName);
            String voucherGroupType = (String)this.getCellValue(hssfRow, i, cols.getCashVoucherGroupType());
            if (StringUtils.isEmpty((String)voucherGroupType)) {
                voucherGroupType = "PresetFinance";
            }
            wsvoucher.put("cashVoucherGroupType", voucherGroupType);
            int iSeq = this.getCellIntValue(hssfRow, i, cols.getCashEntrySeq());
            wsvoucher.setEntrySeq(iSeq);
            int iOppSeq = this.getCellIntValue(hssfRow, i, cols.getCashOppEntrySeq());
            wsvoucher.put("cashOppEntrySeq", iOppSeq);
            String primarynumber = (String)this.getCellValue(hssfRow, i, cols.getCashPrimaryCashFlowItem());
            wsvoucher.setPrimaryItem(primarynumber);
            String subnumber = (String)this.getCellValue(hssfRow, i, cols.getCashSubCashFlowItem());
            wsvoucher.setSupplyItem(subnumber);
            BigDecimal originalAmount = (BigDecimal)this.getCellValue(hssfRow, i, cols.getCashOriginalAmount());
            if (originalAmount != null) {
                wsvoucher.setCashflowAmountOriginal(originalAmount.doubleValue());
            }
            if ((localAmount = (BigDecimal)this.getCellValue(hssfRow, i, cols.getCashLocalAmount())) != null) {
                wsvoucher.setCashflowAmountLocal(localAmount.doubleValue());
            }
            if ((rptAmount = (BigDecimal)this.getCellValue(hssfRow, i, cols.getCashRptAmount())) != null) {
                wsvoucher.setCashflowAmountRpt(rptAmount.doubleValue());
            }
            int primarycoef = this.getCellIntValue(hssfRow, i, cols.getCashPrimaryCoefficient());
            wsvoucher.setPrimaryCoef(primarycoef);
            int supplycoef = this.getCellIntValue(hssfRow, i, cols.getCashSupCoefficient());
            wsvoucher.setSupplyCoef(supplycoef);
            String type = (String)this.getCellValue(hssfRow, i, cols.getCashType());
            wsvoucher.setType(type);
            int assistCount = 0;
            for (int k = 0; k < 8; ++k) {
                Object atype = this.getCellValue(hssfRow, i, cols.getCashAsstActTypeX(k));
                Object anumber = this.getCellValue(hssfRow, i, cols.getCashAsstActNumberX(k));
                Object aname = this.getCellValue(hssfRow, i, cols.getCashAsstActNameX(k));
                if (!(atype != null && !"".equals(atype) || anumber != null && !"".equals(anumber) || aname != null && !"".equals(aname))) continue;
                String strAsstActTypeName = null;
                if (atype != null) {
                    strAsstActTypeName = String.valueOf(atype);
                    wsvoucher.put("asstActType" + assistCount, strAsstActTypeName);
                }
                String strAsstActID = null;
                if (anumber != null) {
                    if (anumber instanceof BigDecimal) {
                        strAsstActID = String.valueOf(anumber);
                        if (strAsstActID.indexOf(46) > 0) {
                            strAsstActID = strAsstActID.substring(0, strAsstActID.lastIndexOf(46));
                        }
                    } else {
                        strAsstActID = (String)anumber;
                    }
                    this.putAsstInfo(atype + "_number", strAsstActID);
                    wsvoucher.put("asstActNumber" + assistCount, strAsstActID);
                }
                String strAsstActName = null;
                if (aname != null) {
                    if (aname instanceof BigDecimal) {
                        strAsstActName = String.valueOf(aname);
                        if (strAsstActName.indexOf(46) > 0) {
                            strAsstActName = strAsstActName.substring(0, strAsstActName.lastIndexOf(46));
                        }
                    } else {
                        strAsstActName = (String)aname;
                    }
                    this.putAsstInfo(atype + "_name", strAsstActName);
                    wsvoucher.put("asstActName" + assistCount, strAsstActName);
                }
                ++assistCount;
            }
            wsvoucher.put("assistCount", new Integer(assistCount));
        }
        return cashs;
    }

    private void putAsstInfo(String atype, String val) {
        if (!this.asstMap.containsKey(atype)) {
            this.asstMap.put(atype, new StringBuilder());
        }
        ((StringBuilder)this.asstMap.get(atype)).append(val);
    }

    private boolean checkCashRowCell(XSSFRow hssfRow, boolean isMulTiCompany, int row) throws Exception {
        if (hssfRow == null) {
            return false;
        }
        boolean isNullRow = true;
        int count = hssfRow.getLastCellNum();
        for (int col = 1; col <= count; ++col) {
            if (this.getCellValueold(hssfRow, col) == null || this.getCellValueold(hssfRow, col).toString().trim().length() == 0) continue;
            isNullRow = false;
            break;
        }
        return !isNullRow;
    }

    private boolean checkRowCell(XSSFRow hssfRow, boolean isMulTiCompany, int row) throws Exception {
        if (hssfRow == null) {
            return false;
        }
        boolean isNullRow = true;
        int count = hssfRow.getLastCellNum();
        for (int col = 1; col <= count; ++col) {
            if (this.getCellValueold(hssfRow, col) == null || this.getCellValueold(hssfRow, col).toString().trim().length() == 0) continue;
            isNullRow = false;
            break;
        }
        if (isNullRow) {
            return false;
        }
        boolean isBlank = true;
        for (int j = 0; j < 58; ++j) {
            if (this.getCellValue(hssfRow, row, j, 2) == null) continue;
            isBlank = false;
            break;
        }
        return !isBlank;
    }

    @Override
    public IObjectCollection getImpVoucherList(String strFullName, String strFilePath, String strFileName, VoucherImpExpParam filterParam) throws Exception {
        long s = System.currentTimeMillis();
        FileInputStream fis = null;
        Object fs = null;
        XSSFWorkbook wb = null;
        XSSFSheet sheetCash = null;
        try {
            fis = new FileInputStream(strFilePath + "\\" + strFileName);
            wb = new XSSFWorkbook((InputStream)fis);
            long e = System.currentTimeMillis();
            logger.error((Object)("loadfile>>>>>: " + (e - s)));
            XSSFSheet vchSheet = wb.getSheetAt(1);
            WSVoucherCollection vchs = this.getVchList(vchSheet, filterParam);
            e = System.currentTimeMillis();
            logger.error((Object)("getVchList>>>>>: " + (e - s)));
            if (filterParam.isSelectCash()) {
                sheetCash = wb.getSheetAt(2);
                WSVoucherCollection cashs = this.getCashFlowMap(sheetCash, filterParam);
                vchs.addCollection(cashs);
            }
            logger.error((Object)("getCashFlowMap>>>>>: " + (e - s)));
            WSVoucherCollection wSVoucherCollection = vchs;
            return wSVoucherCollection;
        }
        catch (IOException e) {
            logger.error((Object)"read excel error:", (Throwable)e);
            this.core.handUIException((Throwable)e);
            throw new VoucherExpImpException(VoucherExpImpException.FIEL_NOT_EXIST);
        }
        catch (VoucherExpImpException e) {
            logger.error((Object)"read excel error:", (Throwable)((Object)e));
            throw e;
        }
        catch (Exception ex) {
            logger.error((Object)"read excel error:", (Throwable)ex);
            throw new VoucherExpImpException(VoucherExpImpException.CASHFLOW_NOT_PAGE);
        }
        finally {
            try {
                if (null != fis) {
                    fis.close();
                }
            }
            catch (IOException e1) {
                logger.error((Object)"read excel error:", (Throwable)e1);
                this.core.handUIException((Throwable)e1);
                throw new VoucherExpImpException(VoucherExpImpException.FILE_EXIST);
            }
        }
    }

    private WSVoucherCollection getVchList(XSSFSheet sheet1, VoucherImpExpParam filterParam) throws Exception, VoucherExpImpException {
        WSVoucherCollection vchs = new WSVoucherCollection();
        boolean isSupAsstUnit = false;
        boolean isSupProfitCenter = filterParam.isCommonVoucherProcess();
        VoucherIOSparser.EXP_RES_NAME = EXP_RES_NAME2;
        TemplateVoucherXLSCols cols = new TemplateVoucherXLSCols(true, false, isSupProfitCenter);
        int size = sheet1.getLastRowNum();
        WSVoucherInfo wsvoucher = null;
        Object obj = null;
        logger.error((Object)("sheet.size>>>>>: " + size));
        Object cate = null;
        for (int i = 3; i <= size; ++i) {
            Object objSupplier;
            Object objCompanyOrgUnit;
            Object objMaterial;
            Object objHandler;
            Object objFeeType;
            Object objCustomer;
            Object strTicketNumber;
            BigDecimal cAmount;
            BigDecimal dAmount;
            BigDecimal price;
            BigDecimal qty;
            BigDecimal quantity;
            XSSFRow hssfRow = sheet1.getRow(i);
            if (!this.checkRowCell(hssfRow, true, i)) continue;
            wsvoucher = new WSVoucherInfo();
            wsvoucher.put("lineNum", new Integer(i + 1));
            String companyNumber = (String)this.getCellValue(hssfRow, i, 0, 3);
            wsvoucher.setCompanyNumber(companyNumber);
            String strVoucherTypeInfoName = (String)this.getCellValue(hssfRow, i, cols.getVoucherType());
            wsvoucher.setVoucherType(strVoucherTypeInfoName);
            String vouchernumber = (String)this.getCellValue(hssfRow, i, cols.getVoucherNumber());
            if (vouchernumber != null && vouchernumber.indexOf(46) > 0) {
                vouchernumber = vouchernumber.substring(0, vouchernumber.indexOf(46));
            }
            if (vouchernumber == null || "".equals(vouchernumber)) {
                vouchernumber = "tempModelVCHCode" + System.currentTimeMillis() + "#" + i;
            }
            wsvoucher.setVoucherNumber(vouchernumber);
            String voucherName = (String)this.getCellValue(hssfRow, i, cols.getVoucherName());
            if (StringUtils.isEmpty((String)voucherName)) {
                voucherName = vouchernumber;
            }
            wsvoucher.put("voucherName", voucherName);
            String voucherGroupType = (String)this.getCellValue(hssfRow, i, cols.getVoucherGroupType());
            if (StringUtils.isEmpty((String)voucherGroupType)) {
                voucherGroupType = "PresetFinance";
            }
            wsvoucher.put("voucherGroupType", voucherGroupType);
            int iSeq = this.getCellIntValue(hssfRow, i, cols.getEntrySeq());
            wsvoucher.setEntrySeq(iSeq);
            String voucherAbstract = (String)this.getCellValue(hssfRow, i, cols.getVoucherAbstract());
            wsvoucher.setVoucherAbstract(voucherAbstract);
            if (isSupProfitCenter) {
                String profitCenterNumber = (String)this.getCellValue(hssfRow, i, cols.getProfitCenterNumber());
                wsvoucher.setProfitCenterNumber(profitCenterNumber);
            }
            String strAccountView = null;
            obj = this.getCellValue(hssfRow, i, cols.getAccountNumber());
            if (obj != null) {
                if (obj instanceof BigDecimal) {
                    strAccountView = String.valueOf(obj);
                    if (strAccountView.indexOf(46) > 0) {
                        strAccountView = strAccountView.substring(0, strAccountView.lastIndexOf(46));
                    }
                } else {
                    strAccountView = String.valueOf(obj);
                }
            }
            wsvoucher.setAccountNumber(strAccountView);
            String strCurrenyISOcode = (String)this.getCellValue(hssfRow, i, cols.getCurrencyNumber());
            wsvoucher.setCurrencyNumber(strCurrenyISOcode);
            BigDecimal exchangeRate = (BigDecimal)this.getCellValue(hssfRow, i, cols.getLocalRate());
            if (exchangeRate != null) {
                exchangeRate = exchangeRate.setScale(10, 4);
                wsvoucher.setLocalRate(exchangeRate.doubleValue());
            }
            int asstDC = this.getCellIntValue(hssfRow, i, cols.getEntryDC());
            wsvoucher.setEntryDC(asstDC);
            BigDecimal originalAmount = (BigDecimal)this.getCellValue(hssfRow, i, cols.getOriginalAmount());
            if (originalAmount != null) {
                wsvoucher.setOriginalAmount(originalAmount.doubleValue());
            }
            if ((quantity = (BigDecimal)this.getCellValue(hssfRow, i, cols.getQty())) != null) {
                wsvoucher.setQty(quantity.doubleValue());
            }
            if (isSupAsstUnit && (qty = (BigDecimal)this.getCellValue(hssfRow, i, cols.getAsstQty())) != null) {
                wsvoucher.put("assistQty", qty);
            }
            if ((price = (BigDecimal)this.getCellValue(hssfRow, i, cols.getPrice())) != null) {
                wsvoucher.setPrice(price.doubleValue());
            }
            if ((dAmount = (BigDecimal)this.getCellValue(hssfRow, i, cols.getDebitAmount())) != null) {
                wsvoucher.setDebitAmount(dAmount.doubleValue());
            }
            if ((cAmount = (BigDecimal)this.getCellValue(hssfRow, i, cols.getCreditAmount())) != null) {
                wsvoucher.setCreditAmount(cAmount.doubleValue());
            }
            String strCreator = (String)this.getCellValue(hssfRow, i, cols.getCreator());
            wsvoucher.setCreator(strCreator);
            int iAttachments = 0;
            BigDecimal attachBig = (BigDecimal)this.getCellValue(hssfRow, i, cols.getAttaches());
            if (attachBig != null && attachBig.intValue() > 0) {
                iAttachments = attachBig.intValue();
            }
            wsvoucher.setAttaches(iAttachments);
            String strUnitName = (String)this.getCellValue(hssfRow, i, cols.getMeasurement());
            wsvoucher.setMeasurement(strUnitName);
            if (isSupAsstUnit) {
                String strAssistUnitName = (String)this.getCellValue(hssfRow, i, cols.getAssistUnit());
                wsvoucher.put("assistUnit", strAssistUnitName);
            }
            String description = (String)this.getCellValue(hssfRow, i, cols.getDescription());
            wsvoucher.setDescription(description);
            wsvoucher.put("cashflowFlag", null);
            int itemFlag = 0;
            wsvoucher.setItemFlag(itemFlag);
            String bizNumber = (String)this.getCellValue(hssfRow, i, cols.getBizNumber());
            wsvoucher.setBizNumber(bizNumber);
            String objSettleCode = (String)this.getCellValue(hssfRow, i, cols.getSettlementType());
            wsvoucher.setSettlementType(objSettleCode);
            String strSettleNumber = (String)this.getCellValue(hssfRow, i, cols.getSettlementNumber());
            wsvoucher.setSettlementNumber(strSettleNumber);
            String des = (String)this.getCellValue(hssfRow, i, cols.getAsstAbstract());
            wsvoucher.put("asstAbstract", des);
            int assistCount = 0;
            for (int k = 0; k < 8; ++k) {
                ++assistCount;
                Object atype = this.getCellValue(hssfRow, i, cols.getAsstActTypeX(k));
                Object anumber = this.getCellValue(hssfRow, i, cols.getAsstActNumberX(k));
                Object aname = this.getCellValue(hssfRow, i, cols.getAsstActNameX(k));
                if (!(atype != null && !"".equals(atype) || anumber != null && !"".equals(anumber) || aname != null && !"".equals(aname))) continue;
                String strAsstActTypeName = null;
                if (atype != null) {
                    strAsstActTypeName = String.valueOf(atype);
                    wsvoucher.put("asstActType" + assistCount, strAsstActTypeName);
                }
                String strAsstActID = null;
                if (anumber != null) {
                    if (anumber instanceof BigDecimal) {
                        strAsstActID = String.valueOf(anumber);
                        if (strAsstActID.indexOf(46) > 0) {
                            strAsstActID = strAsstActID.substring(0, strAsstActID.lastIndexOf(46));
                        }
                    } else {
                        strAsstActID = (String)anumber;
                    }
                    this.putAsstInfo(atype + "_number", strAsstActID);
                    wsvoucher.put("asstActNumber" + assistCount, strAsstActID);
                }
                String strAsstActName = null;
                if (aname == null) continue;
                if (aname instanceof BigDecimal) {
                    strAsstActName = String.valueOf(aname);
                    if (strAsstActName.indexOf(46) > 0) {
                        strAsstActName = strAsstActName.substring(0, strAsstActName.lastIndexOf(46));
                    }
                } else {
                    strAsstActName = (String)aname;
                }
                this.putAsstInfo(atype + "_name", strAsstActName);
                wsvoucher.put("asstActName" + assistCount, strAsstActName);
            }
            wsvoucher.put("assistCount", new Integer(assistCount));
            Object strInvoiceNumber = this.getCellValue(hssfRow, i, cols.getInvoiceNumber());
            if (strInvoiceNumber != null) {
                wsvoucher.setInvoiceNumber(strInvoiceNumber.toString());
            }
            if ((strTicketNumber = this.getCellValue(hssfRow, i, cols.getTicketNumber())) != null) {
                wsvoucher.put("ticketNumber", strTicketNumber.toString());
            }
            if ((objCustomer = this.getCellValue(hssfRow, i, cols.getCustomer())) != null) {
                wsvoucher.put("customer", objCustomer.toString());
            }
            if ((objFeeType = this.getCellValue(hssfRow, i, cols.getFeeType())) != null) {
                wsvoucher.put("feeType", objFeeType.toString());
            }
            if ((objHandler = this.getCellValue(hssfRow, i, cols.getHandler())) != null) {
                wsvoucher.put("handler", objHandler.toString());
            }
            if ((objMaterial = this.getCellValue(hssfRow, i, cols.getMaterial())) != null) {
                wsvoucher.put("material", objMaterial.toString());
            }
            if ((objCompanyOrgUnit = this.getCellValue(hssfRow, i, cols.getOrgUnit())) != null) {
                wsvoucher.put("orgUnit", objCompanyOrgUnit.toString());
            }
            if ((objSupplier = this.getCellValue(hssfRow, i, cols.getSupplier())) != null) {
                wsvoucher.put("supplier", objSupplier.toString());
            }
            vchs.add(wsvoucher);
        }
        return vchs;
    }

    private java.util.Date getCellDate(XSSFCell cell, int i) throws VoucherExpImpException {
        java.util.Date bizDate = new java.util.Date();
        if (cell != null) {
            if (cell.getCellType().getCode() == 1) {
                String period = cell.getStringCellValue();
                SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    bizDate = s.parse(period);
                }
                catch (ParseException e) {
                    logger.error((Object)e);
                    throw new VoucherExpImpException(VoucherExpImpException.DATATYPENOTVALID, new Object[]{new Integer(i + 1), new Integer(2), ""});
                }
            } else {
                bizDate = cell.getDateCellValue();
            }
            return bizDate;
        }
        return null;
    }

    private java.util.Date getCellDate(XSSFRow hssfRow, int row, int col) throws VoucherExpImpException {
        XSSFCell cell = hssfRow.getCell((int)((short)col));
        return this.getCellDate(cell, row);
    }

    private void dealWithError(ImpVoucherStructure impVoucher, String INDEX, int iSeq, String error, StringBuffer areaInfo) {
        impVoucher.setBreak(true);
        impVoucher.setBNoWrong(false);
        StringBuffer sb = new StringBuffer(impVoucher.getVoucherInfo().getCompany().getNumber());
        sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1003_VoucherIOSparser"));
        sb.append(INDEX).append(iSeq).append(error);
        String message = sb.toString();
        impVoucher.getLstErrorInfo().add(message);
        areaInfo.append(message);
        areaInfo.append("\r\n");
    }

    @Override
    public Map getExtraData(String strFilePath, String strFileName, VoucherImpExpParam filterParam) throws Exception {
        HashMap extraDataMap = new HashMap();
        boolean isPost = filterParam.isIncludePost();
        boolean isNoPost = filterParam.isIncludeNoPost();
        VoucherTypeInfo filteVoucherTypeInfo = filterParam.getVoucherTypeInfo();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(strFilePath + "\\" + strFileName);
        }
        catch (FileNotFoundException e2) {
            this.core.handUIException((Throwable)e2);
            logger.error((Object)e2);
            throw new VoucherExpImpException(VoucherExpImpException.FILE_EXIST);
        }
        XSSFWorkbook wb = null;
        try {
            wb = new XSSFWorkbook((InputStream)fis);
        }
        catch (IOException e) {
            this.core.handUIException((Throwable)e);
            logger.error((Object)e);
            throw new VoucherExpImpException(VoucherExpImpException.FIEL_NOT_EXIST);
        }
        ArrayList<String> list = new ArrayList<String>();
        XSSFSheet sheet1 = wb.getSheetAt(0);
        short AllcellCount = sheet1.getRow(0).getLastCellNum();
        int a = 0;
        int b = 0;
        if (AllcellCount >= 68) {
            a = 1;
            b = 2;
            if (!VoucherIOSparser.EXP_RES_NAME.equals(EXP_RES_NAME1)) {
                VoucherIOSparser.EXP_RES_NAME = EXP_RES_NAME1;
            }
        } else {
            VoucherIOSparser.EXP_RES_NAME = EXP_RES_NAME2;
        }
        int size = sheet1.getLastRowNum();
        logger.debug((Object)("size:" + size));
        String description = null;
        String companyNumber = null;
        String voucherType = null;
        boolean isMulTiCompany = true;
        for (int i = 1; i <= size; ++i) {
            String value3;
            XSSFRow hssfRow = sheet1.getRow(i);
            if (hssfRow == null || this.getCellValue(hssfRow, i, 0, 2) == null) continue;
            if (isMulTiCompany) {
                companyNumber = (String)this.getCellValue(hssfRow, i, 0, 3);
                description = String.valueOf(this.getCellValue(hssfRow, i, 24 + a, 3));
                try {
                    value3 = String.valueOf(this.getCellValue(hssfRow, i, 5, 3));
                    if (value3.indexOf(46) > 0) {
                        value3 = value3.substring(0, value3.indexOf(46));
                    }
                }
                catch (NumberFormatException value2) {
                    // empty catch block
                }
                voucherType = String.valueOf(this.getCellValue(hssfRow, i, 4, 3));
            } else {
                companyNumber = this.getCompany().getNumber();
                description = String.valueOf(this.getCellValue(hssfRow, i, 23 + a, 3));
                try {
                    value3 = String.valueOf(this.getCellValue(hssfRow, i, 4, 3));
                    if (value3.indexOf(46) > 0) {
                        value3 = value3.substring(0, value3.indexOf(46));
                    }
                }
                catch (NumberFormatException value3) {
                    // empty catch block
                }
                voucherType = String.valueOf(this.getCellValue(hssfRow, i, 3, 3));
            }
            if (filteVoucherTypeInfo != null && !voucherType.equals(filteVoucherTypeInfo.getName())) continue;
            XSSFCell cell = hssfRow.getCell(4);
            if (cell != null) {
                // empty if block
            }
            if (description == null) continue;
            boolean posted = false;
            posted = (Boolean)this.getCellValue(hssfRow, i, 20 + a, 1);
            if (!(isPost && isNoPost || isPost && !isNoPost && !posted) && (isPost || !isNoPost || !posted)) continue;
            list.add(companyNumber + "&" + description);
        }
        logger.debug((Object)("list........." + list));
        extraDataMap.put("fserialnoList", list);
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException e1) {
            this.core.handUIException((Throwable)e1);
            logger.error((Object)e1);
            throw new VoucherExpImpException(VoucherExpImpException.FILE_EXIST);
        }
        return extraDataMap;
    }

    public void setCashflowRows(int i) {
        this.cashflowRows = i;
    }

    public void setVoucherRows(int i) {
        this.voucherRows = i;
    }

    private void saveSingleVoucher(SXSSFWorkbook wb, TemplateVoucherInfo tmpVoucher, int count, IGLGeneralFacade facade, VoucherImpExpParam filterParam, CellStyle cellStyle) throws BOSException, EASBizException {
        if (filterParam.isUnitByAsst()) {
            if (!VoucherIOSparser.EXP_RES_NAME.equals(EXP_RES_NAME1)) {
                VoucherIOSparser.EXP_RES_NAME = EXP_RES_NAME1;
            }
            this.isUnit = filterParam.isUnitByAsst();
        } else {
            VoucherIOSparser.EXP_RES_NAME = EXP_RES_NAME2;
        }
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        HashMap<String, Object> valueCashMap = new HashMap<String, Object>();
        HashMap<String, Map> asstItemMap = new HashMap<String, Map>();
        TemplateVoucherEntryCollection voucherLines = tmpVoucher.getEntries();
        if (voucherLines == null || voucherLines.size() == 0) {
            return;
        }
        Date voucherBizDate = (Date)tmpVoucher.getBizDate();
        valueMap.put("HSSFCellValue1", voucherBizDate);
        VoucherTypeInfo voucherTypeInfo = tmpVoucher.getVoucherType();
        String strVoucherTypeInfo = "";
        if (voucherTypeInfo != null) {
            strVoucherTypeInfo = voucherTypeInfo.getName().trim();
            valueMap.put("HSSFCellValue3", strVoucherTypeInfo);
            valueCashMap.put("HSSFCellValueCash2", strVoucherTypeInfo);
        }
        String strNumber = tmpVoucher.getNumber();
        logger.debug((Object)strNumber);
        String vchNumber = strNumber;
        if (!filterParam.isRetainOrgNumber()) {
            vchNumber = String.valueOf(count);
        }
        valueMap.put("HSSFCellValue4", vchNumber);
        valueCashMap.put("HSSFCellValueCash3", vchNumber);
        UserInfo userPrepare = tmpVoucher.getCreator();
        String strPrepare = null;
        if (userPrepare != null) {
            strPrepare = userPrepare.getNumber().trim();
            if (this.isUnit) {
                valueMap.put("HSSFCellValue17", strPrepare);
            } else {
                valueMap.put("HSSFCellValue16", strPrepare);
            }
        }
        UserInfo userCheck = tmpVoucher.getAuditor();
        String strChecker = null;
        if (userCheck != null) {
            strChecker = userCheck.getNumber().trim();
            if (this.isUnit) {
                valueMap.put("HSSFCellValue19", strChecker);
            } else {
                valueMap.put("HSSFCellValue18", strChecker);
            }
        }
        int iAttachement = tmpVoucher.getAttachments();
        if (this.isUnit) {
            valueMap.put("HSSFCellValue20", new Integer(iAttachement));
        } else {
            valueMap.put("HSSFCellValue19", new Integer(iAttachement));
        }
        String strModule = "";
        boolean isDeleted = false;
        if (this.isUnit) {
            valueMap.put("HSSFCellValue23", isDeleted);
        } else {
            valueMap.put("HSSFCellValue22", isDeleted);
        }
        CashflowFlag flag = tmpVoucher.getCashflowFlag();
        if (flag != null) {
            int caflag = flag.getValue();
            if (this.isUnit) {
                valueMap.put("HSSFCellValue29", new Integer(caflag));
            } else {
                valueMap.put("HSSFCellValue27", new Integer(caflag));
            }
        }
        String description = tmpVoucher.getDescription();
        String strRefrence = null;
        if (description != null) {
            strRefrence = tmpVoucher.getDescription().trim();
            if (this.isUnit) {
                valueMap.put("HSSFCellValue27", strRefrence);
            } else {
                valueMap.put("HSSFCellValue25", strRefrence);
            }
        }
        logger.debug((Object)(GLResUtil.getRes("request_export_voucher") + "sheet.." + GLResUtil.getRes("row_voucherEntry") + voucherLines.size()));
        TemplateVoucherEntryInfo voucherEntryInfo = null;
        for (int i = 0; i < voucherLines.size(); ++i) {
            String strMeasureUnitInfo;
            MeasureUnitInfo measureUnitInfo;
            voucherEntryInfo = voucherLines.get(i);
            int iEntryNumber = voucherEntryInfo.getSeq();
            valueMap.put("HSSFCellValue5", String.valueOf(iEntryNumber));
            valueCashMap.put("HSSFCellValueCash5", String.valueOf(iEntryNumber));
            String entryDes = voucherEntryInfo.getDescription();
            valueMap.put("HSSFCellValue6", entryDes);
            AccountViewInfo accountViewInfo = voucherEntryInfo.getAccount();
            String strAccountViewInfo = accountViewInfo.getNumber();
            valueMap.put("HSSFCellValue7", strAccountViewInfo);
            CurrencyInfo currencyInfo = voucherEntryInfo.getCurrency();
            String strCurrencyInfo = currencyInfo.getNumber();
            valueMap.put("HSSFCellValue8", strCurrencyInfo);
            valueCashMap.put("HSSFCellValueCash4", strCurrencyInfo);
            BigDecimal exchangeRate = voucherEntryInfo.getLocalExchangeRate();
            valueMap.put("HSSFCellValue9", exchangeRate);
            EntryDC dc = voucherEntryInfo.getEntryDC();
            int iDC = 0;
            if (dc.getValue() == EntryDC.DEBIT.getValue()) {
                iDC = 1;
            }
            valueMap.put("HSSFCellValue10", String.valueOf(iDC));
            BigDecimal originalAmount = voucherEntryInfo.getOriginalAmount();
            valueMap.put("HSSFCellValue11", originalAmount);
            BigDecimal qty = voucherEntryInfo.getQuantity();
            valueMap.put("HSSFCellValue12", qty);
            BigDecimal price = voucherEntryInfo.getPrice();
            if (this.isUnit) {
                valueMap.put("HSSFCellValue14", price);
            } else {
                valueMap.put("HSSFCellValue13", price);
            }
            BigDecimal localDebit = SysConstant.BIGZERO;
            BigDecimal localCredit = SysConstant.BIGZERO;
            if (dc.getValue() == EntryDC.DEBIT.getValue()) {
                localDebit = voucherEntryInfo.getLocalAmount();
                if (this.isUnit) {
                    valueMap.put("HSSFCellValue15", localDebit);
                    valueMap.put("HSSFCellValue16", null);
                } else {
                    valueMap.put("HSSFCellValue14", localDebit);
                    valueMap.put("HSSFCellValue15", null);
                }
            } else {
                localCredit = voucherEntryInfo.getLocalAmount();
                if (this.isUnit) {
                    valueMap.put("HSSFCellValue16", localCredit);
                    valueMap.put("HSSFCellValue15", null);
                } else {
                    valueMap.put("HSSFCellValue15", localCredit);
                    valueMap.put("HSSFCellValue14", null);
                }
            }
            if (!filterParam.isQtyByAsst() || accountViewInfo.getCAA() == null) {
                measureUnitInfo = voucherEntryInfo.getMeasureUnit();
                strMeasureUnitInfo = null;
                if (measureUnitInfo != null) {
                    strMeasureUnitInfo = measureUnitInfo.getNumber().trim();
                    if (this.isUnit) {
                        valueMap.put("HSSFCellValue25", strMeasureUnitInfo);
                    } else {
                        valueMap.put("HSSFCellValue24", strMeasureUnitInfo);
                    }
                } else if (this.isUnit) {
                    valueMap.put("HSSFCellValue25", null);
                } else {
                    valueMap.put("HSSFCellValue24", null);
                }
            }
            TemplateCashflowRecordCollection cashFlowRecordCollection = voucherEntryInfo.getCashflowRecords();
            TemplateVoucherAsstRecordCollection assitRecordCollection = voucherEntryInfo.getAssistRecords();
            String[] asstTypes = new String[8];
            String[] asstItemNumbers = new String[8];
            String[] asstItemNames = new String[8];
            if (this.isUnit) {
                valueMap.put("HSSFCellValue30", null);
                valueMap.put("HSSFCellValue31", null);
                valueMap.put("HSSFCellValue32", null);
                valueMap.put("HSSFCellValue33", null);
            } else {
                valueMap.put("HSSFCellValue28", null);
                valueMap.put("HSSFCellValue29", null);
                valueMap.put("HSSFCellValue30", null);
                valueMap.put("HSSFCellValue31", null);
            }
            valueMap.put("HSSFCellValue56", null);
            valueMap.put("HSSFCellValue57", null);
            valueMap.put("HSSFCellValue58", null);
            valueMap.put("HSSFCellValue59", null);
            valueMap.put("HSSFCellValue60", null);
            valueMap.put("HSSFCellValue61", null);
            valueMap.put("HSSFCellValue62", null);
            valueMap.put("HSSFCellValue63", null);
            valueMap.put("HSSFCellValue64", null);
            valueMap.put("HSSFCellValue65", null);
            if (assitRecordCollection != null && assitRecordCollection.size() > 0) {
                for (int j = 0; j < assitRecordCollection.size(); ++j) {
                    FeeTypeEnum feeType;
                    String strTicketNumber;
                    BigDecimal assQty;
                    String strSettleCode;
                    String strDescripton;
                    if (this.isUnit) {
                        valueMap.put("HSSFCellValue30", null);
                        valueMap.put("HSSFCellValue31", null);
                        valueMap.put("HSSFCellValue32", null);
                        valueMap.put("HSSFCellValue33", null);
                    } else {
                        valueMap.put("HSSFCellValue28", null);
                        valueMap.put("HSSFCellValue29", null);
                        valueMap.put("HSSFCellValue30", null);
                        valueMap.put("HSSFCellValue31", null);
                    }
                    TemplateVoucherAsstRecordInfo tmpAssistRecordInfo = assitRecordCollection.get(j);
                    originalAmount = tmpAssistRecordInfo.getOriginalAmount();
                    valueMap.put("HSSFCellValue11", originalAmount);
                    String strBizNumber = tmpAssistRecordInfo.getBizNumber();
                    if (strBizNumber != null) {
                        strBizNumber = strBizNumber.trim();
                        if (this.isUnit) {
                            valueMap.put("HSSFCellValue30", strBizNumber);
                        } else {
                            valueMap.put("HSSFCellValue28", strBizNumber);
                        }
                    }
                    if ((strDescripton = tmpAssistRecordInfo.getDescription()) != null) {
                        strDescripton = strDescripton.trim();
                        if (this.isUnit) {
                            valueMap.put("HSSFCellValue33", strDescripton);
                        } else {
                            valueMap.put("HSSFCellValue31", strDescripton);
                        }
                    }
                    SettlementTypeInfo settlementTypeInfo = tmpAssistRecordInfo.getSettlementType();
                    String strSettleTypeInfo = null;
                    if (settlementTypeInfo != null) {
                        strSettleTypeInfo = settlementTypeInfo.getName().trim();
                        if (this.isUnit) {
                            valueMap.put("HSSFCellValue31", strSettleTypeInfo);
                        } else {
                            valueMap.put("HSSFCellValue29", strSettleTypeInfo);
                        }
                    }
                    if ((strSettleCode = tmpAssistRecordInfo.getSettlementCode()) != null) {
                        strSettleCode = strSettleCode.trim();
                        if (this.isUnit) {
                            valueMap.put("HSSFCellValue32", strSettleCode);
                        } else {
                            valueMap.put("HSSFCellValue30", strSettleCode);
                        }
                    }
                    BigDecimal assLocalDebit = SysConstant.BIGZERO;
                    BigDecimal assLocalCredit = SysConstant.BIGZERO;
                    if (dc.getValue() == EntryDC.DEBIT.getValue()) {
                        assLocalDebit = tmpAssistRecordInfo.getLocalAmount();
                        if (this.isUnit) {
                            valueMap.put("HSSFCellValue15", assLocalDebit);
                        } else {
                            valueMap.put("HSSFCellValue14", assLocalDebit);
                        }
                    } else {
                        assLocalCredit = tmpAssistRecordInfo.getLocalAmount();
                        if (this.isUnit) {
                            valueMap.put("HSSFCellValue16", assLocalCredit);
                        } else {
                            valueMap.put("HSSFCellValue15", assLocalCredit);
                        }
                    }
                    if (filterParam.isQtyByAsst()) {
                        measureUnitInfo = tmpAssistRecordInfo.getMeasureUnitID();
                        strMeasureUnitInfo = null;
                        if (measureUnitInfo != null) {
                            strMeasureUnitInfo = measureUnitInfo.getNumber().trim();
                            if (this.isUnit) {
                                valueMap.put("HSSFCellValue25", strMeasureUnitInfo);
                            } else {
                                valueMap.put("HSSFCellValue24", strMeasureUnitInfo);
                            }
                        } else if (this.isUnit) {
                            valueMap.put("HSSFCellValue25", strMeasureUnitInfo);
                        } else {
                            valueMap.put("HSSFCellValue24", strMeasureUnitInfo);
                        }
                        BigDecimal assPrice = tmpAssistRecordInfo.getPrice();
                        if (assPrice != null) {
                            if (this.isUnit) {
                                valueMap.put("HSSFCellValue14", assPrice);
                            } else {
                                valueMap.put("HSSFCellValue13", assPrice);
                            }
                        }
                    }
                    if ((assQty = tmpAssistRecordInfo.getQuantity()) != null) {
                        valueMap.put("HSSFCellValue12", assQty);
                    }
                    if (filterParam.isUnitByAsst() && filterParam.isQtyByAsst()) {
                        measureUnitInfo = tmpAssistRecordInfo.getMeasureUnitID();
                        strMeasureUnitInfo = null;
                        if (measureUnitInfo != null) {
                            strMeasureUnitInfo = measureUnitInfo.getNumber().trim();
                            valueMap.put("HSSFCellValue26", strMeasureUnitInfo);
                        } else {
                            valueMap.put("HSSFCellValue26", null);
                        }
                        BigDecimal assUnitQty = tmpAssistRecordInfo.getQuantity();
                        if (assUnitQty != null) {
                            valueMap.put("HSSFCellValue13", assUnitQty);
                        }
                    }
                    if (tmpAssistRecordInfo.getAssGrp() != null) {
                        String assGrpId = tmpAssistRecordInfo.getAssGrp().getId().toString();
                        Map result = null;
                        if (asstItemMap.containsKey(assGrpId)) {
                            result = (Map)asstItemMap.get(assGrpId);
                        } else {
                            HashMap<String, String> key = new HashMap<String, String>();
                            key.put("key", assGrpId);
                            result = facade.dealTask("getAsstItem", key);
                            asstItemMap.put(assGrpId, result);
                        }
                        if (result != null) {
                            AsstActTypeCollection col = (AsstActTypeCollection)result.get("value");
                            int count2 = 0;
                            if (col != null) {
                                count2 = col.size();
                            }
                            for (int k = 0; k < count2; ++k) {
                                AsstActTypeInfo data = col.get(k);
                                asstTypes[k] = (String)data.get("asstTypes");
                                asstItemNumbers[k] = (String)data.get("asstItemNumbers");
                                asstItemNames[k] = (String)data.get("asstItemNames");
                            }
                        }
                    }
                    valueMap.put("HSSFCellValueASST1", asstTypes);
                    valueMap.put("HSSFCellValueASST2", asstItemNumbers);
                    valueMap.put("HSSFCellValueASST3", asstItemNames);
                    valueMap.put("HSSFCellValue56", null);
                    valueMap.put("HSSFCellValue57", null);
                    valueMap.put("HSSFCellValue58", null);
                    valueMap.put("HSSFCellValue59", null);
                    valueMap.put("HSSFCellValue60", null);
                    valueMap.put("HSSFCellValue61", null);
                    valueMap.put("HSSFCellValue62", null);
                    valueMap.put("HSSFCellValue63", null);
                    String strInvoiceNumber = tmpAssistRecordInfo.getInvoiceNumber();
                    if (strInvoiceNumber != null) {
                        strInvoiceNumber = strInvoiceNumber.trim();
                        valueMap.put("HSSFCellValue56", strInvoiceNumber);
                    }
                    if ((strTicketNumber = tmpAssistRecordInfo.getTicketNumber()) != null) {
                        strTicketNumber = strTicketNumber.trim();
                        valueMap.put("HSSFCellValue57", strTicketNumber);
                    }
                    CustomerInfo customerInfo = tmpAssistRecordInfo.getCustomer();
                    String strCustomerInfo = null;
                    if (customerInfo != null) {
                        strCustomerInfo = customerInfo.getName().trim();
                        valueMap.put("HSSFCellValue58", strCustomerInfo);
                    }
                    if ((feeType = tmpAssistRecordInfo.getFeeType()) != null) {
                        valueMap.put("HSSFCellValue59", String.valueOf(feeType.getValue()));
                    }
                    UserInfo handlerInfo = tmpAssistRecordInfo.getHandler();
                    String strHandlerInfo = null;
                    if (handlerInfo != null) {
                        strHandlerInfo = handlerInfo.getNumber().trim();
                        valueMap.put("HSSFCellValue60", strHandlerInfo);
                    }
                    MaterialInfo materialInfo = tmpAssistRecordInfo.getMaterial();
                    String strMaterialInfo = null;
                    if (materialInfo != null) {
                        strMaterialInfo = materialInfo.getName().trim();
                        valueMap.put("HSSFCellValue61", strMaterialInfo);
                    }
                    CompanyOrgUnitInfo companyOrgUnitInfo = tmpAssistRecordInfo.getOrgUnit();
                    String strCompanyOrgUnitInfo = null;
                    if (companyOrgUnitInfo != null) {
                        strCompanyOrgUnitInfo = companyOrgUnitInfo.getName().trim();
                        valueMap.put("HSSFCellValue62", strCompanyOrgUnitInfo);
                    }
                    SupplierInfo supplierInfo = tmpAssistRecordInfo.getSupplier();
                    String strSupplierInfo = null;
                    if (supplierInfo != null) {
                        strSupplierInfo = supplierInfo.getName().trim();
                        valueMap.put("HSSFCellValue63", strSupplierInfo);
                    }
                    valueMap.put("HSSFCellValue64", null);
                    valueMap.put("HSSFCellValue65", null);
                    this.insertVocherRow(wb, valueMap, cellStyle);
                }
            } else {
                valueMap.put("HSSFCellValueASST1", asstTypes);
                valueMap.put("HSSFCellValueASST2", asstItemNumbers);
                valueMap.put("HSSFCellValueASST3", asstItemNames);
                this.insertVocherRow(wb, valueMap, cellStyle);
            }
            SXSSFSheet cashSheet = wb.getSheet(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1039_VoucherXLSSparser"));
            String[] cashAsstTypes = new String[8];
            String[] cashAsstItemNumbers = new String[8];
            String[] cashAsstItemNames = new String[8];
            if (cashFlowRecordCollection == null || cashFlowRecordCollection.size() <= 0) continue;
            for (int l = 0; l < cashFlowRecordCollection.size(); ++l) {
                TemplateCashflowRecordInfo cashFlowRecordInfo = cashFlowRecordCollection.get(l);
                valueCashMap.put("HSSFCellValueASST1", cashAsstTypes);
                valueCashMap.put("HSSFCellValueASST2", cashAsstItemNumbers);
                valueCashMap.put("HSSFCellValueASST3", cashAsstItemNames);
                Row voucherCashRow = cashSheet.createRow(this.cashflowRows++);
                Cell[] cashCell = this.getHSSFCells(voucherCashRow, "HSSFCellValueNumber2", false);
                this.setHSSFCellsValue(wb, cashCell, valueCashMap, "HSSFCellValue", "ASST", cellStyle);
                valueCashMap.put("HSSFCellValueCash6", String.valueOf(cashFlowRecordInfo.getOpposingAccountEntry().getSeq()));
                valueCashMap.put("HSSFCellValueCash5", String.valueOf(cashFlowRecordInfo.getEntry().getSeq()));
                CashFlowItemInfo primaryCashFlowItemInfo = cashFlowRecordInfo.getPrimaryItem();
                String strPrimaryCashFlowItemInfo = null;
                if (primaryCashFlowItemInfo != null) {
                    strPrimaryCashFlowItemInfo = primaryCashFlowItemInfo.getNumber();
                }
                valueCashMap.put("HSSFCellValueCash7", strPrimaryCashFlowItemInfo);
                CashFlowItemInfo subCashFlowItemInfo = cashFlowRecordInfo.getSupplementaryItem();
                String strSubCashFlowItemInfo = null;
                if (subCashFlowItemInfo != null) {
                    strSubCashFlowItemInfo = subCashFlowItemInfo.getNumber();
                }
                valueCashMap.put("HSSFCellValueCash8", strSubCashFlowItemInfo);
                BigDecimal cashFlowAmountFor = cashFlowRecordInfo.getOriginalAmount();
                valueCashMap.put("HSSFCellValueCash9", cashFlowAmountFor);
                BigDecimal cashFlowAmountLocal = cashFlowRecordInfo.getLocalAmount();
                valueCashMap.put("HSSFCellValueCash10", cashFlowAmountLocal);
                valueCashMap.put("HSSFCellValueCash11", cashFlowRecordInfo.getReportingAmount());
                valueCashMap.put("HSSFCellValueCash12", String.valueOf(cashFlowRecordInfo.getPrimaryCoefficient()));
                valueCashMap.put("HSSFCellValueCash13", String.valueOf(cashFlowRecordInfo.getSupplementaryCoefficient()));
                this.setHSSFCellsValue(wb, cashCell, valueCashMap, "HSSFCellValue", "Cash", cellStyle);
            }
        }
    }

    private void insertVocherRow(SXSSFWorkbook wb, Map valueMap, CellStyle cellStyle) {
        SXSSFSheet voucherSheet = wb.getSheet(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI"));
        Row voucherRow = voucherSheet.createRow(this.voucherRows++);
        Cell[] csCell = this.getHSSFCells(voucherRow, "HSSFCellValueNumber1", true);
        this.setHSSFCellsValue(wb, csCell, valueMap, "HSSFCellValue", "ASST", cellStyle);
    }

    private Cell[] getHSSFCells(Row voucherRow, String strCellValueNumber, boolean isMainSheet) {
        int cellValueNumber = 33;
        if (this.isUnit) {
            cellValueNumber = 35;
        }
        cellValueNumber = isMainSheet ? cellValueNumber + 24 + 10 : 40;
        Cell[] cells = new Cell[cellValueNumber];
        for (int i = 0; i < cellValueNumber; i = (int)((short)(i + 1))) {
            cells[i] = voucherRow.createCell(i);
        }
        return cells;
    }

    private void setHSSFCellsValue(SXSSFWorkbook wb, Cell[] cells, Map valueMap, String cellValue, String dix, CellStyle cellStyle) {
        String key;
        logger.debug((Object)("....HSSFCell" + cells.length));
        int size = cells.length;
        if ("Cash".equals(dix)) {
            cellValue = cellValue + dix;
        }
        cells[0].setCellValue(this.getCompany().getNumber());
        for (int i = 1; i < size; ++i) {
            key = "";
            key = cellValue + (i - 1);
            Object value = valueMap.get(key);
            if (value == null) continue;
            if (value instanceof String) {
                if (i >= 59 && this.isUnit) {
                    cells[i + 2].setCellValue((String)value);
                } else {
                    cells[i].setCellValue((String)value);
                }
            }
            if (value instanceof Date) {
                if (i >= 65 && this.isUnit) {
                    cells[i + 2].setCellValue((java.util.Date)((Date)value));
                    cells[i + 2].setCellStyle(cellStyle);
                    continue;
                }
                cells[i].setCellValue((java.util.Date)((Date)value));
                cells[i].setCellStyle(cellStyle);
                continue;
            }
            if (value instanceof Boolean) {
                cells[i].setCellValue(((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                cells[i].setCellValue((double)((Integer)value).intValue());
                continue;
            }
            if (value instanceof Double) {
                cells[i].setCellValue(((Double)value).doubleValue());
                continue;
            }
            if (!(value instanceof BigDecimal)) continue;
            cells[i].setCellValue(((BigDecimal)value).doubleValue());
        }
        int cellValueNumber = 33;
        if ("ASST".equals(dix)) {
            int i;
            String[] value;
            int k;
            key = cellValue + dix;
            logger.debug((Object)("....key" + key));
            int asstValue = 67;
            if (this.isUnit) {
                asstValue = 69;
                cellValueNumber = 35;
            }
            if (size == asstValue) {
                for (k = 1; k <= 3; ++k) {
                    value = (String[])valueMap.get(key + k);
                    for (i = 0; i < 8; ++i) {
                        cells[cellValueNumber + i * 3 + k - 1].setCellValue(value[i]);
                    }
                }
            }
            if (size == 40) {
                for (k = 1; k <= 3; ++k) {
                    value = (String[])valueMap.get(key + k);
                    for (i = 0; i < 8; ++i) {
                        cells[16 + i * 3 + k - 1].setCellValue(value[i]);
                    }
                }
            }
        }
    }

    private Object getCellValue(XSSFRow hssfRow, int row, VoucherIMPColInfo col) throws Exception {
        return this.getCellValue(hssfRow, row, col.getIndex(), col.getType());
    }

    private Object getCellValue(XSSFRow hssfRow, int row, int col, int type) throws Exception {
        Object obj = this.getCellValueold(hssfRow, col);
        if (obj == null) {
            return null;
        }
        try {
            if (type == 0) {
                obj = new BigDecimal(obj.toString());
            } else if (type == 1) {
                obj = Boolean.valueOf(obj.toString());
            } else if (type != 2 && type == 3 && obj != null) {
                obj = obj.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new VoucherExpImpException(VoucherExpImpException.DATATYPENOTVALID, new Object[]{new Integer(row + 1), new Integer(col + 1), "(" + obj + ") " + this.typeAlias[type]});
        }
        return obj;
    }

    private int getCellIntValue(XSSFRow hssfRow, int row, int col, int type) throws Exception {
        int value;
        String _strV = String.valueOf(this.getCellValue(hssfRow, row, col, 0));
        if (_strV.indexOf(46) > 0) {
            _strV = _strV.substring(0, _strV.indexOf(46));
        }
        try {
            value = Integer.parseInt(_strV);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e);
            String typeAlia = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1040_VoucherXLSSparser");
            throw new VoucherExpImpException(VoucherExpImpException.DATATYPENOTVALID, new Object[]{new Integer(row + 1), new Integer(col + 1), "(" + _strV + ") " + typeAlia});
        }
        return value;
    }

    private int getCellIntValue(XSSFRow hssfRow, int row, VoucherIMPColInfo col) throws Exception {
        return this.getCellIntValue(hssfRow, row, col.getIndex(), col.getType());
    }

    private Object getCellValueold(XSSFRow hssfRow, int row) throws VoucherExpImpException {
        XSSFCell cell = hssfRow.getCell((int)((short)row));
        Object obj = null;
        if (cell != null) {
            CellType type = cell.getCellType();
            switch (type) {
                case BOOLEAN: {
                    obj = cell.getBooleanCellValue();
                    break;
                }
                case NUMERIC: {
                    double nueric = cell.getNumericCellValue();
                    obj = new BigDecimal(nueric);
                    break;
                }
                case STRING: {
                    obj = cell.getStringCellValue();
                    if (obj == null) break;
                    obj = ((String)obj).trim();
                    break;
                }
                case FORMULA: {
                    try {
                        obj = cell.getDateCellValue();
                        break;
                    }
                    catch (IllegalStateException e) {
                        throw new VoucherExpImpException(VoucherExpImpException.DATATYPENOTVALID, new Object[]{new Integer(hssfRow.getRowNum() + 1), new Integer(row + 1), "(" + cell.getCellFormula() + ") "});
                    }
                }
            }
        }
        return obj;
    }

    private SXSSFWorkbook getWorkbook(String fullName, boolean oeveride, boolean isUnitByAsst) throws EASBizException {
        int i;
        String cellValue;
        int i2;
        int i3;
        SXSSFWorkbook wb = null;
        wb = new SXSSFWorkbook(100);
        SXSSFSheet sheet1 = wb.createSheet(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI"));
        Row row1 = sheet1.createRow(0);
        int clos = 0;
        int cellValueNumber1 = Integer.parseInt(this.getResx(EXP_RES_NAME, "HSSFCellValueNumber1")) + 1;
        Cell[] csCell = new Cell[cellValueNumber1 + 24 + 10];
        CellStyle style = this.getStyle(wb);
        int cellCount = cellValueNumber1 + 24 + 10;
        for (i3 = 0; i3 < cellCount; ++i3) {
            int n = clos;
            clos = (short)(clos + 1);
            csCell[i3] = row1.createCell(n);
            csCell[i3].setCellStyle(style);
        }
        csCell[0].setCellValue(VoucherImportUtils.companyRes);
        for (i3 = 0; i3 < cellValueNumber1 + 1; ++i3) {
            String cellValue2 = this.getResx(EXP_RES_NAME, "HSSFCellValue" + i3);
            csCell[i3 + 1].setCellValue(cellValue2);
        }
        for (i3 = 0; i3 < 8; ++i3) {
            String cellValue0 = this.getResx(EXP_RES_NAME, "HSSFCellValueASST1");
            String cellValue1 = this.getResx(EXP_RES_NAME, "HSSFCellValueASST2");
            String cellValue2 = this.getResx(EXP_RES_NAME, "HSSFCellValueASST3");
            csCell[cellValueNumber1 + i3 * 3].setCellValue(cellValue0 + (i3 + 1));
            csCell[cellValueNumber1 + i3 * 3 + 1].setCellValue(cellValue1 + (i3 + 1));
            csCell[cellValueNumber1 + i3 * 3 + 2].setCellValue(cellValue2 + (i3 + 1));
        }
        int customCount = cellValueNumber1 + 34;
        int customCount1 = cellValueNumber1 + 24;
        if (isUnitByAsst) {
            customCount = cellValueNumber1 + 34;
            for (i2 = customCount1; i2 < customCount; ++i2) {
                cellValue = this.getResx(EXP_RES_NAME, "HSSFCellValue" + (i2 - 3));
                csCell[i2].setCellValue(cellValue);
            }
        } else {
            for (i2 = customCount1; i2 < customCount; ++i2) {
                cellValue = this.getResx(EXP_RES_NAME, "HSSFCellValue" + (i2 - 1));
                csCell[i2].setCellValue(cellValue);
            }
        }
        SXSSFSheet sheet2 = wb.createSheet(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1039_VoucherXLSSparser"));
        Row row2 = sheet2.createRow(0);
        int cellValueNumber2 = Integer.parseInt(this.getResx(EXP_RES_NAME, "HSSFCellValueNumber2")) + 1 + 1;
        Cell[] csCell2 = new Cell[cellValueNumber2 + 24];
        csCell2[0] = row2.createCell(0);
        csCell2[0].setCellValue(VoucherImportUtils.companyRes);
        for (i = 1; i < cellValueNumber2; ++i) {
            csCell2[i] = row2.createCell((int)((short)i));
            String cellValue3 = this.getResx(EXP_RES_NAME, "HSSFCellValueCash" + (i - 1));
            csCell2[i].setCellValue(cellValue3);
        }
        for (i = 0; i < 8; ++i) {
            String cellValue0 = this.getResx(EXP_RES_NAME, "HSSFCellValueASST1");
            String cellValue1 = this.getResx(EXP_RES_NAME, "HSSFCellValueASST2");
            String cellValue2 = this.getResx(EXP_RES_NAME, "HSSFCellValueASST3");
            csCell2[cellValueNumber2 + i * 3] = row2.createCell((int)((short)(cellValueNumber2 + i * 3)));
            csCell2[cellValueNumber2 + i * 3].setCellValue(cellValue0 + (i + 1));
            csCell2[cellValueNumber2 + i * 3 + 1] = row2.createCell((int)((short)(cellValueNumber2 + i * 3 + 1)));
            csCell2[cellValueNumber2 + i * 3 + 1].setCellValue(cellValue1 + (i + 1));
            csCell2[cellValueNumber2 + i * 3 + 2] = row2.createCell((int)((short)(cellValueNumber2 + i * 3 + 2)));
            csCell2[cellValueNumber2 + i * 3 + 2].setCellValue(cellValue2 + (i + 1));
        }
        return wb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveWorkbook(SXSSFWorkbook wb, String srtFileFullname, boolean overide) {
        File file;
        if (overide && (file = new File(srtFileFullname)).exists()) {
            file.delete();
        }
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(srtFileFullname);
            return;
        }
        catch (FileNotFoundException e) {
            this.core.handUIException((Throwable)e);
            return;
        }
        finally {
            if (fileOut != null) {
                try {
                    wb.write((OutputStream)fileOut);
                }
                catch (IOException e2) {
                    this.core.handUIException((Throwable)e2);
                }
                finally {
                    try {
                        fileOut.close();
                    }
                    catch (IOException e3) {
                        this.core.handUIException((Throwable)e3);
                    }
                }
            }
        }
    }

    private POIFSFileSystem openWorkbookFile(FileInputStream fis) throws EASBizException {
        POIFSFileSystem fs = null;
        try {
            fs = new POIFSFileSystem((InputStream)fis);
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new VoucherExpImpException(VoucherExpImpException.FILE_SPARSER_NOTCORRECT);
        }
        return fs;
    }

    private CellStyle getStyle(SXSSFWorkbook wb) {
        CellStyle structStyle = wb.createCellStyle();
        structStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        structStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_CORNFLOWER_BLUE.getIndex());
        structStyle.setAlignment(HorizontalAlignment.LEFT);
        structStyle.setHidden(false);
        structStyle.setLocked(false);
        BorderStyle borderstyle = BorderStyle.DOTTED;
        structStyle.setBorderLeft(borderstyle);
        structStyle.setBorderRight(borderstyle);
        structStyle.setBorderTop(borderstyle);
        structStyle.setBorderBottom(borderstyle);
        short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
        structStyle.setBottomBorderColor(backColorIndex);
        structStyle.setTopBorderColor(backColorIndex);
        structStyle.setLeftBorderColor(backColorIndex);
        structStyle.setRightBorderColor(backColorIndex);
        structStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        Font defaultFont = wb.createFont();
        defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"265_TableMonitorFrame"));
        short size = 12;
        defaultFont.setFontHeightInPoints(size);
        structStyle.setFont(defaultFont);
        return structStyle;
    }
}

