/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.ICrossPrintDataProvider;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.gl.BaseVoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.BaseVoucherEntryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IBaseVoucherAssistRecord;
import com.kingdee.eas.fi.gl.UserSettingFactory;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherPrintDataProvider;
import com.kingdee.eas.fi.gl.VoucherPrintSettingInfo;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class VoucherCrossDuoCurrency
implements ICrossPrintDataProvider {
    private static final Logger logger = Logger.getLogger(VoucherCrossDuoCurrency.class);
    private Locale locale;
    private DateFormat df;
    private DateFormat adf;
    private DateFormat dft;
    private VoucherCollection vchCol;
    private boolean isNext = false;
    private int index = 0;
    private VoucherPrintSettingInfo settingInfo;
    private VoucherPrintDataProvider provider;

    public VoucherCrossDuoCurrency(Locale locale, VoucherCollection vchCol, VoucherPrintSettingInfo settingInfo, boolean isNext) throws EASBizException, BOSException {
        this.locale = locale;
        this.vchCol = vchCol;
        this.settingInfo = settingInfo;
        this.provider = new VoucherPrintDataProvider(settingInfo);
        this.df = DateFormat.getDateInstance(1, locale);
        this.adf = DateFormat.getDateInstance(2, locale);
        this.dft = DateFormat.getDateTimeInstance(2, 2, locale);
        this.isNext = isNext;
    }

    public boolean hasNext() {
        if (this.vchCol == null) {
            return false;
        }
        int size = this.vchCol.size();
        if (this.index < size) {
            VoucherInfo vch = this.vchCol.get(this.index);
            if (this.settingInfo.isAutoMachMulCurrencyTemplate() && !this.isNext && this.isHasVoucherDouCurrency(vch)) {
                this.getIndex();
                return false;
            }
            if (this.isNext && !this.isHasVoucherDouCurrency(vch)) {
                this.getIndex();
                return false;
            }
            return true;
        }
        return false;
    }

    protected VoucherInfo getVoucherInfo(int index) {
        return this.vchCol.get(index);
    }

    private synchronized int getIndex() {
        int count = this.index++;
        return count;
    }

    private boolean isHasVoucherDouCurrency(VoucherInfo vch) {
        for (VoucherEntryInfo e : vch.getEntries()) {
            if (e.getCurrency().getId().equals((Object)vch.getCompany().getBaseCurrency().getId())) continue;
            return true;
        }
        return false;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = null;
        for (int i = 4; i <= 30; ++i) {
            if (("dsStandard" + i).equalsIgnoreCase(ds.getID())) {
                rs = this.getRowSet(i, 1);
                continue;
            }
            if (("flowStandard" + i).equalsIgnoreCase(ds.getID())) {
                rs = this.getRowSet(i, 1);
                continue;
            }
            if (("ds1_Standard" + i).equalsIgnoreCase(ds.getID())) {
                rs = this.getRowSet(i, 1);
                continue;
            }
            if (("flow1_Standard" + i).equalsIgnoreCase(ds.getID())) {
                rs = this.getRowSet(i, 1);
                continue;
            }
            if (("ds2_subtotal" + i).equalsIgnoreCase(ds.getID())) {
                rs = this.getRowSet(i, 2);
                continue;
            }
            if (("ds" + i).equalsIgnoreCase(ds.getID())) {
                rs = this.getRowSet(i, 1);
                continue;
            }
            if (("voucher_ds" + i).equalsIgnoreCase(ds.getID())) {
                rs = this.getRowSet(i, 4);
                continue;
            }
            if (("vchFlow_ds" + i).equalsIgnoreCase(ds.getID())) {
                rs = this.getRowSet(i, 6);
                continue;
            }
            if (!("vchFlow" + i).equalsIgnoreCase(ds.getID())) continue;
            rs = this.getRowSet(i, 6);
        }
        return rs;
    }

    private IRowSet getRowSet(int rowCount, int num) {
        int count = this.getIndex();
        if (count > this.vchCol.size()) {
            return null;
        }
        VoucherInfo vch = this.getVoucherInfo(count);
        return this.getRowSet(vch, rowCount, num);
    }

    private IRowSet getRowSet(VoucherInfo voucherInfo, int rowCount, int type) {
        switch (type) {
            case 1: {
                return this.getRowSet(rowCount, voucherInfo);
            }
            case 2: {
                return this.getRowSet2(rowCount, voucherInfo);
            }
            case 3: {
                return null;
            }
            case 4: {
                return this.getRowSet4(rowCount, voucherInfo);
            }
            case 5: {
                return null;
            }
            case 6: {
                return this.getRowSet6(rowCount, voucherInfo);
            }
        }
        return null;
    }

    private Map getCFResult() {
        int colCount;
        HashMap<String, Object> result = new HashMap<String, Object>();
        int realColCount = colCount = VoucherPrintDataProvider.col.length;
        String[] cfInfoArr = null;
        String cfInfo = null;
        try {
            cfInfo = UserSettingFactory.getRemoteInstance().getValueCF();
            if (!StringUtils.isEmpty((String)cfInfo) && (cfInfoArr = cfInfo.split(",")) != null && cfInfoArr.length > 0) {
                realColCount += cfInfoArr.length;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        result.put("colCount", colCount);
        result.put("realColCount", realColCount);
        result.put("cfInfoArr", cfInfoArr);
        return result;
    }

    private IRowSet getRowSet(int rowLineCount, VoucherInfo vch) {
        Map cfResult = this.getCFResult();
        int colCount = (Integer)cfResult.get("colCount");
        int realColCount = (Integer)cfResult.get("realColCount");
        String[] cfInfoArr = (String[])cfResult.get("cfInfoArr");
        DynamicRowSet drs = null;
        IAssistantHG assistantHG = null;
        IBaseVoucherAssistRecord asstre = null;
        try {
            VoucherEntryInfo e;
            drs = new DynamicRowSet(realColCount);
            for (int i = 0; i < realColCount; ++i) {
                String obj;
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = colCount > i ? VoucherPrintDataProvider.col[i] : (obj = cfInfoArr[i - colCount]);
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            int size = 1;
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            HashSet<String> voucherCFSet = new HashSet<String>();
            HashSet<String> entryCFSet = new HashSet<String>();
            HashSet<String> asstCFSet = new HashSet<String>();
            for (int i = 0; cfInfoArr != null && i < cfInfoArr.length; ++i) {
                String item = cfInfoArr[i];
                if (item.startsWith("v#")) {
                    voucherCFSet.add(item);
                    continue;
                }
                if (item.startsWith("e#")) {
                    entryCFSet.add(item);
                    continue;
                }
                if (!item.startsWith("r#")) continue;
                asstCFSet.add(item);
            }
            int vchCount = 0;
            String vchId = Integer.toString(++vchCount);
            CompanyOrgUnitInfo com = vch.getCompany();
            CurrencyInfo localCurrency = com.getBaseCurrency();
            int lcpre = localCurrency.getPrecision();
            CurrencyInfo reportingCurrency = com.getReportCurrency();
            int rcpre = reportingCurrency == null ? lcpre : reportingCurrency.getPrecision();
            allDeit = vch.getLocalDebitAmount();
            allCret = vch.getLocalCreditAmount();
            Iterator itr = vch.getEntries().iterator();
            int entrySize = 0;
            while (itr.hasNext()) {
                VoucherEntryInfo e2 = (VoucherEntryInfo)itr.next();
                VoucherAssistRecordCollection assitCollection = e2.getAssistRecords();
                if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                    entrySize += assitCollection.size();
                    continue;
                }
                ++entrySize;
            }
            Iterator itrEntry = vch.getEntries().iterator();
            int voucherCount = 0;
            voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
            CashflowRecordCollection cashFlows = (CashflowRecordCollection)vch.getCashflowRecords();
            if (cashFlows == null || cashFlows != null && cashFlows.size() == 0) {
                CashflowRecordCollection cashFlow = null;
                while (itrEntry.hasNext()) {
                    e = (VoucherEntryInfo)itrEntry.next();
                    if (!this.settingInfo.isPrintCashFlow() || !this.settingInfo.isPrintCashflowMeOrOther()) continue;
                    cashFlow = e.getCashflowEntry();
                    if (cashFlows != null && cashFlows.size() > 0 && cashFlow != null && cashFlow.size() > 0) {
                        cashFlows.addCollection(cashFlow);
                        continue;
                    }
                    if (cashFlow == null || cashFlow.size() <= 0) continue;
                    cashFlows = cashFlow;
                }
            }
            itrEntry = vch.getEntries().iterator();
            int entryCount = 0;
            while (itrEntry.hasNext()) {
                e = (VoucherEntryInfo)itrEntry.next();
                VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                EntryDC dc = e.getEntryDC();
                int asstCount = 0;
                if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                    for (VoucherAssistRecordInfo r : assitCollection) {
                        drs.moveToInsertRow();
                        this.provider.clearRow((IRowSet)drs);
                        this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                        this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                        this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                        this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                        if (this.settingInfo.isPrintAssistant()) {
                            this.provider.fillVoucherASSTData((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.adf, lcpre, dc, assistantHG, asstre, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                            this.provider.fillVoucherASSTDataCF((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, asstCFSet);
                        }
                        if (++asstCount > 1) {
                            drs.updateString("e_seq", " ");
                        }
                        int page = 0;
                        page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                        drs.updateString("pageCount", page + "/" + voucherCount);
                        drs.updateString("pageCurrent", page + "");
                        drs.updateString("pageTotal", "" + voucherCount);
                        drs.updateString("bizStatus", vch.getBizStatus().toString());
                        drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                        drs.updateString("attachmentsChinese", GlUtils.getChineseBig(vch.getAttachments(), this.locale));
                        if (page == voucherCount) {
                            drs.updateString("debitTotal", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                            drs.updateString("localAmountDebit", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                            drs.updateString("localAmountCredit", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                            drs.updateString("reportingAmountDebit", GlUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                            drs.updateString("reportingAmountCredit", GlUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                            drs.updateString("amountTotalChinese", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                            drs.updateString("amountTotal", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                        }
                        if (this.settingInfo.isPrintCashFlow()) {
                            this.provider.printCashflow(drs, e, null, lcpre);
                        }
                        drs.insertRow();
                    }
                    continue;
                }
                drs.moveToInsertRow();
                this.provider.clearRow((IRowSet)drs);
                this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                if (EntryDC.DEBIT.equals((Object)dc)) {
                    drs.updateString("e_originalAmountDebit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                    drs.updateString("e_localAmountDebit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                    drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                } else {
                    drs.updateString("e_originalAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                    drs.updateString("e_localAmountCredit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                    drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                }
                int page = 0;
                page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                drs.updateString("pageCount", page + "/" + voucherCount);
                drs.updateString("pageCurrent", page + "");
                drs.updateString("pageTotal", "" + voucherCount);
                drs.updateString("bizStatus", vch.getBizStatus().toString());
                drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                drs.updateString("attachmentsChinese", GlUtils.getChineseBig(vch.getAttachments(), this.locale));
                if (page == voucherCount) {
                    drs.updateString("debitTotal", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                    drs.updateString("creditTotal", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                    drs.updateString("localAmountDebit", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                    drs.updateString("localAmountCredit", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                    drs.updateString("reportingAmountDebit", GlUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                    drs.updateString("reportingAmountCredit", GlUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                    drs.updateString("amountTotalChinese", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                    drs.updateString("amountTotal", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                }
                if (this.settingInfo.isPrintCashFlow()) {
                    this.provider.printCashflow(drs, e, null, lcpre);
                }
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
        return drs;
    }

    private IRowSet getRowSet2(int rowLineCount, VoucherInfo vch) {
        Map cfResult = this.getCFResult();
        int colCount = (Integer)cfResult.get("colCount");
        int realColCount = (Integer)cfResult.get("realColCount");
        String[] cfInfoArr = (String[])cfResult.get("cfInfoArr");
        DynamicRowSet drs = null;
        IAssistantHG assistantHG = null;
        IBaseVoucherAssistRecord asstre = null;
        try {
            drs = new DynamicRowSet(realColCount);
            for (int i = 0; i < realColCount; ++i) {
                String obj;
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = colCount > i ? VoucherPrintDataProvider.col[i] : (obj = cfInfoArr[i - colCount]);
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            HashSet<String> voucherCFSet = new HashSet<String>();
            HashSet<String> entryCFSet = new HashSet<String>();
            HashSet<String> asstCFSet = new HashSet<String>();
            for (int i = 0; cfInfoArr != null && i < cfInfoArr.length; ++i) {
                String item = cfInfoArr[i];
                if (item.startsWith("v#")) {
                    voucherCFSet.add(item);
                    continue;
                }
                if (item.startsWith("e#")) {
                    entryCFSet.add(item);
                    continue;
                }
                if (!item.startsWith("r#")) continue;
                asstCFSet.add(item);
            }
            int vchCount = 0;
            String vchId = Integer.toString(++vchCount);
            CompanyOrgUnitInfo com = vch.getCompany();
            CurrencyInfo localCurrency = com.getBaseCurrency();
            int lcpre = localCurrency.getPrecision();
            CurrencyInfo reportingCurrency = com.getReportCurrency();
            int rcpre = reportingCurrency == null ? lcpre : reportingCurrency.getPrecision();
            allDeit = vch.getLocalDebitAmount();
            allCret = vch.getLocalCreditAmount();
            Iterator itr = vch.getEntries().iterator();
            int entrySize = 0;
            int seq = 0;
            while (itr.hasNext()) {
                VoucherEntryInfo e = (VoucherEntryInfo)itr.next();
                seq = e.getSeq();
                VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                if (assitCollection != null && assitCollection.size() > 0) {
                    entrySize += assitCollection.size();
                    continue;
                }
                ++entrySize;
            }
            Iterator itrEntry = vch.getEntries().iterator();
            int voucherCount = 0;
            voucherCount = (entrySize + seq) % rowLineCount == 0 ? (entrySize + seq) / rowLineCount : (entrySize + seq) / rowLineCount + 1;
            int entryCount = 1;
            while (itrEntry.hasNext()) {
                int page;
                VoucherEntryInfo e = (VoucherEntryInfo)itrEntry.next();
                VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                EntryDC dc = e.getEntryDC();
                int asstCount = 0;
                if (assitCollection != null && assitCollection.size() > 0) {
                    for (VoucherAssistRecordInfo r : assitCollection) {
                        drs.moveToInsertRow();
                        this.provider.clearRow((IRowSet)drs);
                        this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                        this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                        this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                        this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                        if (this.settingInfo.isPrintAssistant()) {
                            this.provider.fillVoucherASSTData((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.adf, lcpre, dc, assistantHG, asstre, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                            this.provider.fillVoucherASSTDataCF((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, asstCFSet);
                        }
                        if (++asstCount > 1) {
                            drs.updateString("e_seq", " ");
                            drs.updateString("e_account", null);
                        }
                        int page2 = 0;
                        page2 = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                        drs.updateString("pageCount", page2 + "/" + voucherCount);
                        drs.updateString("pageCurrent", page2 + "");
                        drs.updateString("pageTotal", "" + voucherCount);
                        drs.updateString("bizStatus", vch.getBizStatus().toString());
                        drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                        drs.updateString("attachmentsChinese", GlUtils.getChineseBig(vch.getAttachments(), this.locale));
                        if (page2 == voucherCount) {
                            drs.updateString("debitTotal", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                            drs.updateString("localAmountDebit", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                            drs.updateString("localAmountCredit", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                            drs.updateString("reportingAmountDebit", GlUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                            drs.updateString("reportingAmountCredit", GlUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                            drs.updateString("amountTotalChinese", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                            drs.updateString("amountTotal", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                            drs.updateString("sum", "");
                        }
                        drs.insertRow();
                    }
                } else {
                    drs.moveToInsertRow();
                    this.provider.clearRow((IRowSet)drs);
                    this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                    this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                    this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                    this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        drs.updateString("e_originalAmountDebit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_localAmountDebit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                    } else {
                        drs.updateString("e_originalAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_localAmountCredit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                    }
                    page = 0;
                    page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                    drs.updateString("pageCount", page + "/" + voucherCount);
                    drs.updateString("pageCurrent", page + "");
                    drs.updateString("pageTotal", "" + voucherCount);
                    drs.updateString("bizStatus", vch.getBizStatus().toString());
                    drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                    drs.updateString("attachmentsChinese", GlUtils.getChineseBig(vch.getAttachments(), this.locale));
                    if (page == voucherCount) {
                        drs.updateString("debitTotal", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("creditTotal", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("localAmountDebit", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("localAmountCredit", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("reportingAmountDebit", GlUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                        drs.updateString("reportingAmountCredit", GlUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                        drs.updateString("amountTotalChinese", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                        drs.updateString("amountTotal", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                        drs.updateString("sum", "");
                    }
                    drs.insertRow();
                }
                drs.moveToInsertRow();
                drs.updateString("e_seq", "");
                drs.updateString("e_description", "");
                drs.updateString("e_account", "");
                drs.updateString("zc_account", "");
                drs.updateString("e_currency", "");
                drs.updateString("e_measureUnitName", "");
                drs.updateString("e_measureUnitNumber", "");
                drs.updateString("periodYear", "");
                drs.updateString("periodNumber", "");
                drs.updateString("bizDate", "");
                drs.updateString("bookedDate", "");
                drs.updateString("bookedDateYear", "");
                drs.updateString("bookedDateMonth", "");
                drs.updateString("r_description", "");
                drs.updateString("r_settlementType", "");
                drs.updateString("r_settlementCode", "");
                drs.updateString("r_bizNumber", "");
                drs.updateString("r_originalAmount", "");
                drs.updateString("r_originalAmount", "");
                drs.updateString("r_originalAmountDebit", "");
                drs.updateString("r_reportingAmount", "");
                drs.updateString("r_localAmount", "");
                drs.updateString("r_localAmountDebit", "");
                drs.updateString("r_localAmountCredit", "");
                drs.updateString("r_quantity", "");
                drs.updateString("r_bizDate", "");
                drs.updateString("r_invoice", "");
                drs.updateString("r_endDate", "");
                drs.updateString("r_assGrp", "");
                drs.updateString("r_longName", "");
                drs.updateString("r_accountAsst", "");
                drs.updateString("r_AsstHeadNumber", "");
                drs.updateString("r_AsstNumber", "");
                drs.updateString("r_AsstHeadName", "");
                drs.updateString("r_AsstName", "");
                drs.updateString("r_AsstLevelName", "");
                drs.updateString("zc_assGrp", "");
                drs.updateString("c_item", "");
                drs.updateString("c_itemEbb", "");
                drs.updateString("c_primItem", "");
                drs.updateString("c_suppItem", "");
                drs.updateString("c_oppAccount", "");
                drs.updateString("c_originalAmount", "");
                drs.updateString("c_localAmount", "");
                drs.updateString("c_reportingAmount", "");
                drs.updateString("customer.number", "");
                drs.updateString("customer.name", "");
                drs.updateString("cusNumberName", "");
                drs.updateString("vchId", vchId);
                drs.updateString("e_isoCode", GLResUtil.getRes("subtotal", this.locale));
                if (EntryDC.DEBIT.equals((Object)dc)) {
                    drs.updateString("e_originalAmountDebit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                    drs.updateString("e_localAmountDebit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                    drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                } else {
                    drs.updateString("e_originalAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                    drs.updateString("e_localAmountCredit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                    drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                }
                page = 0;
                page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                drs.updateString("pageCount", page + "/" + voucherCount);
                drs.updateString("pageCurrent", page + "");
                drs.updateString("pageTotal", "" + voucherCount);
                drs.updateString("bizStatus", vch.getBizStatus().toString());
                drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                drs.updateString("attachmentsChinese", GlUtils.getChineseBig(vch.getAttachments(), this.locale));
                if (page == voucherCount) {
                    drs.updateString("debitTotal", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                    drs.updateString("creditTotal", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                    drs.updateString("localAmountDebit", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                    drs.updateString("localAmountCredit", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                    drs.updateString("reportingAmountDebit", GlUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                    drs.updateString("reportingAmountCredit", GlUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                    drs.updateString("amountTotalChinese", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                    drs.updateString("amountTotal", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                }
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
        return drs;
    }

    private IRowSet getRowSet4(int rowLineCount, VoucherInfo vch) {
        Map cfResult = this.getCFResult();
        int colCount = (Integer)cfResult.get("colCount");
        int realColCount = (Integer)cfResult.get("realColCount");
        String[] cfInfoArr = (String[])cfResult.get("cfInfoArr");
        DynamicRowSet drs = null;
        IAssistantHG assistantHG = null;
        IBaseVoucherAssistRecord asstre = null;
        try {
            drs = new DynamicRowSet(realColCount);
            for (int i = 0; i < realColCount; ++i) {
                String obj;
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = colCount > i ? VoucherPrintDataProvider.col[i] : (obj = cfInfoArr[i - colCount]);
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            HashSet<String> voucherCFSet = new HashSet<String>();
            HashSet<String> entryCFSet = new HashSet<String>();
            HashSet<String> asstCFSet = new HashSet<String>();
            for (int i = 0; cfInfoArr != null && i < cfInfoArr.length; ++i) {
                String item = cfInfoArr[i];
                if (item.startsWith("v#")) {
                    voucherCFSet.add(item);
                    continue;
                }
                if (item.startsWith("e#")) {
                    entryCFSet.add(item);
                    continue;
                }
                if (!item.startsWith("r#")) continue;
                asstCFSet.add(item);
            }
            int vchCount = 0;
            String vchId = Integer.toString(++vchCount);
            CompanyOrgUnitInfo com = vch.getCompany();
            CurrencyInfo localCurrency = com.getBaseCurrency();
            int lcpre = localCurrency.getPrecision();
            CurrencyInfo reportingCurrency = com.getReportCurrency();
            int rcpre = reportingCurrency == null ? lcpre : reportingCurrency.getPrecision();
            allDeit = vch.getLocalDebitAmount();
            allCret = vch.getLocalCreditAmount();
            Iterator itr = vch.getEntries().iterator();
            int entrySize = 0;
            while (itr.hasNext()) {
                VoucherEntryInfo e = (VoucherEntryInfo)itr.next();
                VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                if (assitCollection != null && assitCollection.size() > 0) {
                    entrySize += assitCollection.size();
                    continue;
                }
                ++entrySize;
            }
            Iterator itrEntry = vch.getEntries().iterator();
            int voucherCount = 0;
            voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
            int entryCount = 0;
            BigDecimal creditTotal = GlUtils.zero;
            BigDecimal debitTotal = GlUtils.zero;
            HashMap<String, BigDecimal> creditmap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> debitmap = new HashMap<String, BigDecimal>();
            for (VoucherEntryInfo e : vch.getEntries()) {
                EntryDC dc = e.getEntryDC();
                VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                if (assitCollection != null && assitCollection.size() > 0) {
                    for (VoucherAssistRecordInfo r : assitCollection) {
                        int page = 0;
                        page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                        if (entryCount % rowLineCount == 1) {
                            creditTotal = GlUtils.zero;
                            debitTotal = GlUtils.zero;
                        }
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            debitTotal = debitTotal.add(r.getLocalAmount());
                        } else {
                            creditTotal = creditTotal.add(r.getLocalAmount());
                        }
                        if (entryCount % rowLineCount != 0) continue;
                        creditmap.put(String.valueOf(page), creditTotal);
                        debitmap.put(String.valueOf(page), debitTotal);
                    }
                    continue;
                }
                int page = 0;
                page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                if (entryCount % rowLineCount == 1) {
                    creditTotal = GlUtils.zero;
                    debitTotal = GlUtils.zero;
                }
                if (EntryDC.DEBIT.equals((Object)dc)) {
                    debitTotal = debitTotal.add(e.getLocalAmount());
                } else {
                    creditTotal = creditTotal.add(e.getLocalAmount());
                }
                if (entryCount % rowLineCount != 0) continue;
                creditmap.put(String.valueOf(page), creditTotal);
                debitmap.put(String.valueOf(page), debitTotal);
            }
            entryCount = 0;
            while (itrEntry.hasNext()) {
                VoucherEntryInfo e;
                e = (VoucherEntryInfo)itrEntry.next();
                VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                EntryDC dc = e.getEntryDC();
                int asstCount = 0;
                if (assitCollection != null && assitCollection.size() > 0) {
                    for (VoucherAssistRecordInfo r : assitCollection) {
                        drs.moveToInsertRow();
                        this.provider.clearRow((IRowSet)drs);
                        this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                        this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                        this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                        this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                        if (this.settingInfo.isPrintAssistant()) {
                            this.provider.fillVoucherASSTData((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.adf, lcpre, dc, assistantHG, asstre, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                            this.provider.fillVoucherASSTDataCF((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, asstCFSet);
                        }
                        if (++asstCount > 1) {
                            drs.updateString("e_seq", " ");
                        }
                        int page = 0;
                        if (++entryCount % rowLineCount == 0) {
                            page = entryCount / rowLineCount;
                        } else {
                            page = entryCount / rowLineCount + 1;
                            if (entryCount % rowLineCount == 1) {
                                creditTotal = GlUtils.zero;
                                debitTotal = GlUtils.zero;
                            }
                        }
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            debitTotal = debitTotal.add(r.getLocalAmount());
                        } else {
                            creditTotal = creditTotal.add(r.getLocalAmount());
                        }
                        drs.updateString("pageCount", page + "/" + voucherCount);
                        drs.updateString("pageCurrent", page + "");
                        drs.updateString("pageTotal", "" + voucherCount);
                        drs.updateString("bizStatus", vch.getBizStatus().toString());
                        drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                        drs.updateString("attachmentsChinese", GlUtils.getChineseBig(vch.getAttachments(), this.locale));
                        if (page == voucherCount) {
                            drs.updateString("debitTotal", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                            drs.updateString("localAmountDebit", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                            drs.updateString("localAmountCredit", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                            drs.updateString("reportingAmountDebit", GlUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                            drs.updateString("reportingAmountCredit", GlUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                            drs.updateString("amountTotalChinese", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                            drs.updateString("amountTotal", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                            drs.updateString("sum", "");
                        } else {
                            drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)debitmap.get(String.valueOf(page)), lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)creditmap.get(String.valueOf(page)), lcpre));
                            drs.updateString("sum", GLResUtil.getRes("subtotal", this.locale));
                        }
                        drs.insertRow();
                    }
                    continue;
                }
                drs.moveToInsertRow();
                this.provider.clearRow((IRowSet)drs);
                this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                if (EntryDC.DEBIT.equals((Object)dc)) {
                    drs.updateString("e_originalAmountDebit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                    drs.updateString("e_localAmountDebit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                    drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                } else {
                    drs.updateString("e_originalAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                    drs.updateString("e_localAmountCredit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                    drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                }
                int page = 0;
                if (++entryCount % rowLineCount == 0) {
                    page = entryCount / rowLineCount;
                } else {
                    page = entryCount / rowLineCount + 1;
                    if (entryCount % rowLineCount == 1) {
                        creditTotal = GlUtils.zero;
                        debitTotal = GlUtils.zero;
                    }
                }
                if (EntryDC.DEBIT.equals((Object)dc)) {
                    debitTotal = debitTotal.add(e.getLocalAmount());
                } else {
                    creditTotal = creditTotal.add(e.getLocalAmount());
                }
                drs.updateString("pageCount", page + "/" + voucherCount);
                drs.updateString("pageCurrent", page + "");
                drs.updateString("pageTotal", "" + voucherCount);
                drs.updateString("bizStatus", vch.getBizStatus().toString());
                drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                drs.updateString("attachmentsChinese", GlUtils.getChineseBig(vch.getAttachments(), this.locale));
                if (page == voucherCount) {
                    drs.updateString("debitTotal", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                    drs.updateString("creditTotal", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                    drs.updateString("localAmountDebit", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                    drs.updateString("localAmountCredit", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                    drs.updateString("reportingAmountDebit", GlUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                    drs.updateString("reportingAmountCredit", GlUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                    drs.updateString("amountTotalChinese", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                    drs.updateString("amountTotal", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                    drs.updateString("sum", "");
                } else {
                    drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)debitmap.get(String.valueOf(page)), lcpre));
                    drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)creditmap.get(String.valueOf(page)), lcpre));
                    drs.updateString("sum", GLResUtil.getRes("subtotal", this.locale));
                }
                String acctname = GlUtils.getNumberAndLongName((IObjectValue)e, "account");
                String zc_listacctname = null;
                zc_listacctname = acctname.indexOf("_", 0) != -1 ? acctname.substring(acctname.indexOf("_", 0) + 1, acctname.length()) : acctname.substring(acctname.indexOf("-", 0) + 1, acctname.length());
                drs.updateString("zc_assGrp", zc_listacctname);
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
        return drs;
    }

    private IRowSet getRowSet6(int rowLineCount, VoucherInfo vch) {
        Map cfResult = this.getCFResult();
        int colCount = (Integer)cfResult.get("colCount");
        int realColCount = (Integer)cfResult.get("realColCount");
        String[] cfInfoArr = (String[])cfResult.get("cfInfoArr");
        DynamicRowSet drs = null;
        IAssistantHG assistantHG = null;
        IBaseVoucherAssistRecord asstre = null;
        try {
            VoucherAssistRecordCollection assitCollection;
            drs = new DynamicRowSet(realColCount);
            for (int i = 0; i < realColCount; ++i) {
                String obj;
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = colCount > i ? VoucherPrintDataProvider.col[i] : (obj = cfInfoArr[i - colCount]);
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            HashSet<String> voucherCFSet = new HashSet<String>();
            HashSet<String> entryCFSet = new HashSet<String>();
            HashSet<String> asstCFSet = new HashSet<String>();
            for (int i = 0; cfInfoArr != null && i < cfInfoArr.length; ++i) {
                String item = cfInfoArr[i];
                if (item.startsWith("v#")) {
                    voucherCFSet.add(item);
                    continue;
                }
                if (item.startsWith("e#")) {
                    entryCFSet.add(item);
                    continue;
                }
                if (!item.startsWith("r#")) continue;
                asstCFSet.add(item);
            }
            int vchCount = 0;
            String vchId = Integer.toString(++vchCount);
            CompanyOrgUnitInfo com = vch.getCompany();
            CurrencyInfo localCurrency = com.getBaseCurrency();
            int lcpre = localCurrency.getPrecision();
            CurrencyInfo reportingCurrency = com.getReportCurrency();
            int rcpre = reportingCurrency == null ? lcpre : reportingCurrency.getPrecision();
            allDeit = vch.getLocalDebitAmount();
            allCret = vch.getLocalCreditAmount();
            Iterator itr = vch.getEntries().iterator();
            int entrySize = 0;
            while (itr.hasNext()) {
                VoucherEntryInfo e = (VoucherEntryInfo)itr.next();
                VoucherAssistRecordCollection assitCollection2 = e.getAssistRecords();
                if (assitCollection2 != null && assitCollection2.size() > 0) {
                    entrySize += assitCollection2.size();
                    continue;
                }
                ++entrySize;
            }
            Iterator itrEntry = vch.getEntries().iterator();
            int voucherCount = 0;
            voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
            int entryCount = 0;
            BigDecimal creditTotal = GlUtils.zero;
            BigDecimal debitTotal = GlUtils.zero;
            HashMap<String, BigDecimal> creditmap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> debitmap = new HashMap<String, BigDecimal>();
            for (VoucherEntryInfo e : vch.getEntries()) {
                EntryDC dc = e.getEntryDC();
                assitCollection = e.getAssistRecords();
                if (assitCollection != null && assitCollection.size() > 0) {
                    for (VoucherAssistRecordInfo r : assitCollection) {
                        int page = 0;
                        page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                        if (entryCount % rowLineCount == 1) {
                            creditTotal = GlUtils.zero;
                            debitTotal = GlUtils.zero;
                        }
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            debitTotal = debitTotal.add(r.getLocalAmount());
                        } else {
                            creditTotal = creditTotal.add(r.getLocalAmount());
                        }
                        if (entryCount % rowLineCount != 0) continue;
                        creditmap.put(String.valueOf(page), creditTotal);
                        debitmap.put(String.valueOf(page), debitTotal);
                    }
                    continue;
                }
                int page = 0;
                page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                if (entryCount % rowLineCount == 1) {
                    creditTotal = GlUtils.zero;
                    debitTotal = GlUtils.zero;
                }
                if (EntryDC.DEBIT.equals((Object)dc)) {
                    debitTotal = debitTotal.add(e.getLocalAmount());
                } else {
                    creditTotal = creditTotal.add(e.getLocalAmount());
                }
                if (entryCount % rowLineCount != 0) continue;
                creditmap.put(String.valueOf(page), creditTotal);
                debitmap.put(String.valueOf(page), debitTotal);
            }
            CashflowRecordCollection cashFlows = (CashflowRecordCollection)vch.getCashflowRecords();
            if (cashFlows == null || cashFlows != null && cashFlows.size() == 0) {
                CashflowRecordCollection cashFlow = null;
                while (itrEntry.hasNext()) {
                    VoucherEntryInfo e = (VoucherEntryInfo)itrEntry.next();
                    if (!this.settingInfo.isPrintCashFlow() || !this.settingInfo.isPrintCashflowMeOrOther()) continue;
                    cashFlow = e.getCashflowEntry();
                    if (cashFlows != null && cashFlows.size() > 0 && cashFlow != null && cashFlow.size() > 0) {
                        cashFlows.addCollection(cashFlow);
                        continue;
                    }
                    if (cashFlow == null || cashFlow.size() <= 0) continue;
                    cashFlows = cashFlow;
                }
            }
            itrEntry = vch.getEntries().iterator();
            entryCount = 0;
            while (itrEntry.hasNext()) {
                VoucherEntryInfo e = (VoucherEntryInfo)itrEntry.next();
                assitCollection = e.getAssistRecords();
                EntryDC dc = e.getEntryDC();
                int asstCount = 0;
                if (assitCollection != null && assitCollection.size() > 0) {
                    for (VoucherAssistRecordInfo r : assitCollection) {
                        drs.moveToInsertRow();
                        this.provider.clearRow((IRowSet)drs);
                        this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                        this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                        this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                        this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                        if (this.settingInfo.isPrintAssistant()) {
                            this.provider.fillVoucherASSTData((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.adf, lcpre, dc, assistantHG, asstre, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                            this.provider.fillVoucherASSTDataCF((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, asstCFSet);
                        }
                        if (++asstCount > 1) {
                            drs.updateString("e_seq", " ");
                        }
                        int page = 0;
                        if (++entryCount % rowLineCount == 0) {
                            page = entryCount / rowLineCount;
                        } else {
                            page = entryCount / rowLineCount + 1;
                            if (entryCount % rowLineCount == 1) {
                                creditTotal = GlUtils.zero;
                                debitTotal = GlUtils.zero;
                            }
                        }
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            debitTotal = debitTotal.add(r.getLocalAmount());
                        } else {
                            creditTotal = creditTotal.add(r.getLocalAmount());
                        }
                        drs.updateString("pageCount", page + "/" + voucherCount);
                        drs.updateString("pageCurrent", page + "");
                        drs.updateString("pageTotal", "" + voucherCount);
                        drs.updateString("bizStatus", vch.getBizStatus().toString());
                        drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                        drs.updateString("attachmentsChinese", GlUtils.getChineseBig(vch.getAttachments(), this.locale));
                        if (page == voucherCount) {
                            drs.updateString("debitTotal", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                            drs.updateString("localAmountDebit", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                            drs.updateString("localAmountCredit", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                            drs.updateString("reportingAmountDebit", GlUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                            drs.updateString("reportingAmountCredit", GlUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                            drs.updateString("amountTotalChinese", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                            drs.updateString("amountTotal", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                            drs.updateString("sum", "");
                        } else {
                            drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)debitmap.get(String.valueOf(page)), lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)creditmap.get(String.valueOf(page)), lcpre));
                            drs.updateString("sum", GLResUtil.getRes("subtotal", this.locale));
                        }
                        if (this.settingInfo.isPrintCashFlow()) {
                            this.provider.printCashflow(drs, e, r, lcpre);
                        }
                        drs.insertRow();
                    }
                    continue;
                }
                drs.moveToInsertRow();
                this.provider.clearRow((IRowSet)drs);
                this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                if (EntryDC.DEBIT.equals((Object)dc)) {
                    drs.updateString("e_originalAmountDebit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                    drs.updateString("e_localAmountDebit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                    drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                } else {
                    drs.updateString("e_originalAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                    drs.updateString("e_localAmountCredit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                    drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                }
                int page = 0;
                if (++entryCount % rowLineCount == 0) {
                    page = entryCount / rowLineCount;
                } else {
                    page = entryCount / rowLineCount + 1;
                    if (entryCount % rowLineCount == 1) {
                        creditTotal = GlUtils.zero;
                        debitTotal = GlUtils.zero;
                    }
                }
                if (EntryDC.DEBIT.equals((Object)dc)) {
                    debitTotal = debitTotal.add(e.getLocalAmount());
                } else {
                    creditTotal = creditTotal.add(e.getLocalAmount());
                }
                drs.updateString("pageCount", page + "/" + voucherCount);
                drs.updateString("pageCurrent", page + "");
                drs.updateString("pageTotal", "" + voucherCount);
                drs.updateString("bizStatus", vch.getBizStatus().toString());
                drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                drs.updateString("attachmentsChinese", GlUtils.getChineseBig(vch.getAttachments(), this.locale));
                if (page == voucherCount) {
                    drs.updateString("debitTotal", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                    drs.updateString("creditTotal", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                    drs.updateString("localAmountDebit", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                    drs.updateString("localAmountCredit", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                    drs.updateString("reportingAmountDebit", GlUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                    drs.updateString("reportingAmountCredit", GlUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                    drs.updateString("amountTotalChinese", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                    drs.updateString("amountTotal", GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale));
                    drs.updateString("sum", "");
                } else {
                    drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)debitmap.get(String.valueOf(page)), lcpre));
                    drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)creditmap.get(String.valueOf(page)), lcpre));
                    drs.updateString("sum", GLResUtil.getRes("subtotal", this.locale));
                }
                String acctname = GlUtils.getNumberAndLongName((IObjectValue)e, "account");
                String zc_listacctname = null;
                zc_listacctname = acctname.indexOf("_", 0) != -1 ? acctname.substring(acctname.indexOf("_", 0) + 1, acctname.length()) : acctname.substring(acctname.indexOf("-", 0) + 1, acctname.length());
                drs.updateString("zc_assGrp", zc_listacctname);
                if (this.settingInfo.isPrintCashFlow()) {
                    this.provider.printCashflow(drs, e, null, lcpre);
                }
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
        return drs;
    }

    protected VoucherPrintSettingInfo getPrintSettingInfo() {
        return this.settingInfo;
    }
}

