/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.codingrule.CodingRuleEntryCollection;
import com.kingdee.eas.base.codingrule.CodingRuleEntryInfo;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class VoucherNumberOperator {
    private static final Logger logger = Logger.getLogger(VoucherNumberOperator.class);
    private Context ctx;
    private ICodingRuleManager codingRuleManagerCtrl = null;
    private static final int DEFAULT_NO_NUMBER_COUNT = -1;
    private static final int DEFAULT_GET_NUMBER_COUNT = 1000;
    private static final int DEFAULT_MAX_GET_NUMBER_COUNT = 100000;
    private static final String BINDING_PROPERTY = "bizStatus";
    private static final String CUSTOM_STRING = "";

    public static VoucherNumberOperator build() {
        return VoucherNumberOperator.build(null);
    }

    public static VoucherNumberOperator build(Context ctx) {
        return new VoucherNumberOperator(ctx);
    }

    protected VoucherNumberOperator() {
        this(null);
    }

    private VoucherNumberOperator(Context ctx) {
        this.ctx = ctx;
    }

    public String readNextNumber(BaseVoucherInfo voucher, VoucherStatusEnum status) throws EASBizException, BOSException {
        VoucherStatusEnum oldStatus = voucher.getBizStatus();
        voucher.setBizStatus(status);
        String nextNumber = this.getCodingRuleManagerCtrl().readNumber((IObjectValue)voucher, this.getOrgId(voucher), BINDING_PROPERTY, CUSTOM_STRING);
        voucher.setBizStatus(oldStatus);
        return nextNumber;
    }

    public boolean recycleNumber(BaseVoucherInfo voucher, String number) throws BOSException, EASBizException {
        return this.recycleNumber(voucher, voucher.getBizStatus(), number);
    }

    public boolean recycleNumber(BaseVoucherInfo voucher, VoucherStatusEnum status, String number) throws BOSException, EASBizException {
        if (number == null) {
            return false;
        }
        VoucherStatusEnum oldStatus = voucher.getBizStatus();
        voucher.setBizStatus(status);
        boolean success = this.getCodingRuleManagerCtrl().recycleNumber((IObjectValue)voucher, this.getOrgId(voucher), BINDING_PROPERTY, CUSTOM_STRING, number);
        voucher.setBizStatus(oldStatus);
        return success;
    }

    public boolean existsVoucherCodingRule(BaseVoucherInfo voucher, VoucherStatusEnum status) throws EASBizException, BOSException {
        VoucherStatusEnum oldStatus = voucher.getBizStatus();
        voucher.setBizStatus(status);
        boolean isExistCodingRule = this.getCodingRuleManagerCtrl().isExist((IObjectValue)voucher, this.getOrgId(voucher), BINDING_PROPERTY);
        voucher.setBizStatus(oldStatus);
        return isExistCodingRule;
    }

    public CodingRuleInfo getCodingRuleInfo(BaseVoucherInfo voucher, VoucherStatusEnum status) throws EASBizException, BOSException {
        VoucherStatusEnum oldStatus = voucher.getBizStatus();
        voucher.setBizStatus(status);
        CodingRuleInfo codingRule = this.getCodingRuleManagerCtrl().getCodingRule((IObjectValue)voucher, this.getOrgId(voucher), BINDING_PROPERTY);
        voucher.setBizStatus(oldStatus);
        return codingRule;
    }

    public String getNextValidNumber(BaseVoucherInfo voucher, VoucherStatusEnum status, boolean isHandNumber) throws EASBizException, BOSException {
        VoucherStatusEnum oldStatus = voucher.getBizStatus();
        int MAX_GET_COUNT = this.getNumberMaxCount(voucher, status);
        if (-1 == MAX_GET_COUNT) {
            throw new VoucherException(VoucherException.CODING_RULE_NOT_EXIST);
        }
        for (int i = 0; i < MAX_GET_COUNT; ++i) {
            String nextNumber = this.getNextNumber(voucher, status);
            if (!this.checkNumberValid(voucher, status, nextNumber, isHandNumber)) continue;
            voucher.setBizStatus(oldStatus);
            return nextNumber;
        }
        voucher.setBizStatus(oldStatus);
        throw new VoucherException(VoucherException.CODING_RULE_SN_OUT);
    }

    public boolean checkNumberValid(BaseVoucherInfo voucher, VoucherStatusEnum status, String number, boolean isHandNumber) throws BOSException, EASBizException {
        String vchid = null;
        if (voucher.getId() != null) {
            vchid = voucher.getId().toString();
        }
        Map param = new HashMap<String, Object>();
        param.put("voucherid", vchid);
        if (voucher.getNumber() == null) {
            return false;
        }
        param.put("vouchernumber", number.trim());
        param.put("vouchertypeid", voucher.getVoucherType().getId().toString());
        param.put("companyid", this.getOrgId(voucher));
        param.put("period", voucher.getPeriod());
        param.put("voucherstatus", status);
        param.put("isUseHandNumber", isHandNumber);
        IGLGeneralFacade facade = this.ctx != null ? GLGeneralFacadeFactory.getLocalInstance(this.ctx) : GLGeneralFacadeFactory.getRemoteInstance();
        param = facade.dealTask("CheckNumberValid", param);
        return param.get("IsNotValid") == null;
    }

    public int getNumberMaxCount(BaseVoucherInfo voucherInfo, VoucherStatusEnum status) throws BOSException, EASBizException {
        int maxGetNumberCount = -1;
        if (this.existsVoucherCodingRule(voucherInfo, status)) {
            CodingRuleInfo codingRule = this.getCodingRuleInfo(voucherInfo, status);
            CodingRuleEntryInfo snEntry = null;
            CodingRuleEntryCollection entries = codingRule.getCodingRuleEntrys();
            for (int i = 0; i < entries.size() && snEntry == null; ++i) {
                if (!"sn".equals(entries.get(i).getCodeAttribute().trim())) continue;
                snEntry = entries.get(i);
            }
            if (snEntry == null || snEntry.getStep() == 0) {
                return 1000;
            }
            BigDecimal step = BigDecimal.valueOf(snEntry.getStep());
            BigDecimal total = BigDecimal.valueOf(10L).pow(snEntry.getLength());
            BigDecimal calculatedCount = total.divide(step, 0);
            maxGetNumberCount = calculatedCount.compareTo(BigDecimal.valueOf(100000L)) > 0 ? 100000 : calculatedCount.intValue();
        }
        return maxGetNumberCount;
    }

    private String getNextNumber(BaseVoucherInfo voucher, VoucherStatusEnum status) throws EASBizException, BOSException {
        VoucherStatusEnum oldStatus = voucher.getBizStatus();
        voucher.setBizStatus(status);
        String number = this.getCodingRuleManagerCtrl().getNumber((IObjectValue)voucher, this.getOrgId(voucher), BINDING_PROPERTY, CUSTOM_STRING);
        voucher.setBizStatus(oldStatus);
        return number;
    }

    private ICodingRuleManager getCodingRuleManagerCtrl() throws BOSException {
        if (this.codingRuleManagerCtrl != null) {
            return this.codingRuleManagerCtrl;
        }
        this.codingRuleManagerCtrl = this.ctx == null ? CodingRuleManagerFactory.getRemoteInstance() : CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
        return this.codingRuleManagerCtrl;
    }

    protected String getOrgId(BaseVoucherInfo voucher) {
        return voucher.getCompany().getId().toString();
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }
}

