/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.BaseVoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.BaseVoucherEntryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IBaseVoucherAssistRecord;
import com.kingdee.eas.fi.gl.UserSettingFactory;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordFactory;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherPrintDataProvider;
import com.kingdee.eas.fi.gl.VoucherPrintSettingInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherRowSetProvider
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger(VoucherRowSetProvider.class);
    private Locale locale;
    private DateFormat df;
    private DateFormat dft;
    private Map<String, String> enumStr = new HashMap<String, String>();
    private VoucherCollection vchCol;
    private VoucherPrintSettingInfo settingInfo;
    private VoucherPrintDataProvider provider;

    public VoucherRowSetProvider(Locale locale, VoucherCollection vc, VoucherPrintSettingInfo settingInfo) throws EASBizException, BOSException {
        this.locale = locale;
        if (this.locale == null) {
            this.locale = SysContext.getSysContext().getLocale();
        }
        this.df = new SimpleDateFormat(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"20_RptAsstactXBalanceUI", (Locale)this.locale));
        this.dft = DateFormat.getDateTimeInstance(2, 2, this.locale);
        this.vchCol = vc;
        this.settingInfo = settingInfo;
        this.provider = new VoucherPrintDataProvider(settingInfo);
    }

    public VoucherRowSetProvider(VoucherCollection vc, VoucherPrintSettingInfo settingInfo) throws EASBizException, BOSException {
        this(null, vc, settingInfo);
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        return this.getRowSet(ds.getID());
    }

    public IRowSet getRowSet(String dsId) {
        IRowSet rs = null;
        for (int i = 4; i <= 30; ++i) {
            if (("dsStandard" + i).equalsIgnoreCase(dsId)) {
                rs = this.getRowSet(false, i);
                break;
            }
            if (("flowStandard" + i).equalsIgnoreCase(dsId)) {
                rs = this.getRowSetFlow(false, i);
                break;
            }
            if (("ds1_Standard" + i).equalsIgnoreCase(dsId)) {
                rs = this.getRowSet(true, i);
                break;
            }
            if (("flow1_Standard" + i).equalsIgnoreCase(dsId)) {
                rs = this.getRowSetFlow(true, i);
                break;
            }
            if (("ds2_subtotal" + i).equalsIgnoreCase(dsId)) {
                rs = this.getRowSet2(i);
                break;
            }
            if (("ds" + i).equalsIgnoreCase(dsId)) {
                rs = this.getRowSet3(i);
                break;
            }
            if (("voucher_ds" + i).equalsIgnoreCase(dsId)) {
                rs = this.getRowSet4(i);
                break;
            }
            if (!("vchFlow" + i).equalsIgnoreCase(dsId)) continue;
            rs = this.getRowSet5(i);
            if (null != rs) break;
            rs = this.getRowSetFlow(false, i);
            break;
        }
        return rs;
    }

    private IRowSet getRowSet(boolean pltype, int rowLineCount) {
        Map cfResult = this.getCFResult();
        int colCount = (Integer)cfResult.get("colCount");
        int realColCount = (Integer)cfResult.get("realColCount");
        String[] cfInfoArr = (String[])cfResult.get("cfInfoArr");
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(realColCount);
            for (int i = 0; i < realColCount; ++i) {
                String obj;
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = colCount > i ? VoucherPrintDataProvider.col[i] : (obj = cfInfoArr[i - colCount]);
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            Iterator itrVch = this.vchCol.iterator();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            int vchCount = 0;
            HashSet<String> voucherCFSet = new HashSet<String>();
            HashSet<String> entryCFSet = new HashSet<String>();
            HashSet<String> asstCFSet = new HashSet<String>();
            for (int i = 0; cfInfoArr != null && i < cfInfoArr.length; ++i) {
                String item = cfInfoArr[i];
                if (item.startsWith("v#")) {
                    voucherCFSet.add(item);
                    continue;
                }
                if (item.startsWith("e#")) {
                    entryCFSet.add(item);
                    continue;
                }
                if (!item.startsWith("r#")) continue;
                asstCFSet.add(item);
            }
            String serverTime = GlUtils.formatDate(this.dft, SysUtil.getAppServerTime(null));
            while (itrVch.hasNext()) {
                int lcpre;
                VoucherInfo vch = (VoucherInfo)itrVch.next();
                boolean totalVoucher = vch.containsKey("totalVoucher") ? vch.getBoolean("totalVoucher") : false;
                String attachmentsChinese = GlUtils.getChineseBig(vch.getAttachments(), this.locale);
                BigDecimal[][] total = this.getAmountForFinAndOrg(vch);
                String amountTotalChineseOrg = GlUtils.getChineseFormat(total[1][1], false, this.locale);
                String amountTotalOrg = GlUtils.getChineseFormat(total[1][1], false, this.locale);
                String amountTotalChinese = GlUtils.getChineseFormat(total[0][1], false, this.locale);
                String amountTotal = GlUtils.getChineseFormat(total[0][1], false, this.locale);
                if (pltype && this.computerVoucherType(vch)) {
                    vch = this.changeVoucher(vch);
                }
                ++vchCount;
                String vchId = vch.getId().toString();
                CompanyOrgUnitInfo com = vch.getCompany();
                CurrencyInfo localCurrency = com.getBaseCurrency();
                int rcpre = lcpre = localCurrency.getPrecision();
                CurrencyInfo reportingCurrency = com.getReportCurrency();
                if (reportingCurrency != null) {
                    rcpre = reportingCurrency.getPrecision();
                }
                allDeit = vch.getLocalDebitAmount();
                allCret = vch.getLocalCreditAmount();
                Iterator itrEntry = vch.getEntries().iterator();
                int entrySize = vch.getEntries().size();
                int voucherCount = 0;
                voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
                int entryCount = 1;
                while (itrEntry.hasNext()) {
                    VoucherEntryInfo e = (VoucherEntryInfo)itrEntry.next();
                    if (e.get("_v") != null && "false".equals(e.get("_v").toString())) continue;
                    drs.moveToInsertRow();
                    this.provider.clearRow((IRowSet)drs);
                    this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                    this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                    drs.updateString("sysDateNow", serverTime);
                    this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                    if (!totalVoucher) {
                        this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                    }
                    int page = 0;
                    page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                    drs.updateString("pageCount", page + "/" + voucherCount);
                    drs.updateString("pageCurrent", page + "");
                    drs.updateString("pageTotal", "" + voucherCount);
                    drs.updateString("bizStatus", this.getBizStatusString(vch.getBizStatus()));
                    drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                    drs.updateString("attachmentsChinese", attachmentsChinese);
                    if (page == voucherCount) {
                        drs.updateString("debitTotal", GlUtils.formatNumber(total[0][0], lcpre));
                        drs.updateString("creditTotal", GlUtils.formatNumber(total[0][1], lcpre));
                        drs.updateString("localAmountDebit", GlUtils.formatNumber(total[0][0], lcpre));
                        drs.updateString("localAmountCredit", GlUtils.formatNumber(total[0][1], lcpre));
                        drs.updateString("reportingAmountDebit", GlUtils.formatNumber(total[0][2], lcpre));
                        drs.updateString("reportingAmountCredit", GlUtils.formatNumber(total[0][3], lcpre));
                        drs.updateString("amountTotalChinese", amountTotalChinese);
                        drs.updateString("amountTotal", amountTotal);
                        drs.updateString("debitTotal_org", GlUtils.formatNumber(total[1][0], lcpre));
                        drs.updateString("creditTotal_org", GlUtils.formatNumber(total[1][1], lcpre));
                        drs.updateString("localAmountDebit_org", GlUtils.formatNumber(total[1][0], lcpre));
                        drs.updateString("localAmountCredit_org", GlUtils.formatNumber(total[1][1], lcpre));
                        drs.updateString("reportingAmountDebit_org", GlUtils.formatNumber(total[1][2], lcpre));
                        drs.updateString("reportingAmountCredit_org", GlUtils.formatNumber(total[1][3], lcpre));
                        drs.updateString("amountTotalChinese_org", amountTotalChineseOrg);
                        drs.updateString("amountTotal_org", amountTotalOrg);
                    }
                    drs.insertRow();
                }
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)"Get rowset error!", (Throwable)ex);
            return null;
        }
        return drs;
    }

    private IRowSet getRowSetFlow(boolean pltype, int rowLineCount) {
        Map cfResult = this.getCFResult();
        int colCount = (Integer)cfResult.get("colCount");
        int realColCount = (Integer)cfResult.get("realColCount");
        String[] cfInfoArr = (String[])cfResult.get("cfInfoArr");
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(realColCount);
            for (int i = 0; i < realColCount; ++i) {
                String obj;
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = colCount > i ? VoucherPrintDataProvider.col[i] : (obj = cfInfoArr[i - colCount]);
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            Iterator itrVch = this.vchCol.iterator();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            int vchCount = 0;
            HashSet<String> voucherCFSet = new HashSet<String>();
            HashSet<String> entryCFSet = new HashSet<String>();
            HashSet<String> asstCFSet = new HashSet<String>();
            for (int i = 0; cfInfoArr != null && i < cfInfoArr.length; ++i) {
                String item = cfInfoArr[i];
                if (item.startsWith("v#")) {
                    voucherCFSet.add(item);
                    continue;
                }
                if (item.startsWith("e#")) {
                    entryCFSet.add(item);
                    continue;
                }
                if (!item.startsWith("r#")) continue;
                asstCFSet.add(item);
            }
            String serverTime = GlUtils.formatDate(this.dft, SysUtil.getAppServerTime(null));
            while (itrVch.hasNext()) {
                VoucherEntryInfo e;
                int lcpre;
                VoucherInfo vch = (VoucherInfo)itrVch.next();
                boolean totalVoucher = vch.containsKey("totalVoucher") ? vch.getBoolean("totalVoucher") : false;
                String attachmentsChinese = GlUtils.getChineseBig(vch.getAttachments(), this.locale);
                BigDecimal[][] total = this.getAmountForFinAndOrg(vch);
                String amountTotalChineseOrg = GlUtils.getChineseFormat(total[1][1], false, this.locale);
                String amountTotalOrg = GlUtils.getChineseFormat(total[1][1], false, this.locale);
                String amountTotalChinese = GlUtils.getChineseFormat(total[0][1], false, this.locale);
                String amountTotal = GlUtils.getChineseFormat(total[0][1], false, this.locale);
                if (pltype && this.computerVoucherType(vch)) {
                    vch = this.changeVoucher(vch);
                }
                ++vchCount;
                String vchId = vch.getId().toString();
                CompanyOrgUnitInfo com = vch.getCompany();
                CurrencyInfo localCurrency = com.getBaseCurrency();
                int rcpre = lcpre = localCurrency.getPrecision();
                CurrencyInfo reportingCurrency = com.getReportCurrency();
                if (reportingCurrency != null) {
                    rcpre = reportingCurrency.getPrecision();
                }
                allDeit = vch.getLocalDebitAmount();
                allCret = vch.getLocalCreditAmount();
                Iterator itrEntry = vch.getEntries().iterator();
                int entrySize = vch.getEntries().size();
                int voucherCount = 0;
                voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
                CashflowRecordCollection cashFlows = (CashflowRecordCollection)vch.getCashflowRecords();
                if (cashFlows == null || cashFlows != null && cashFlows.size() == 0) {
                    CashflowRecordCollection cashFlow = null;
                    while (itrEntry.hasNext()) {
                        e = (VoucherEntryInfo)itrEntry.next();
                        if (!this.settingInfo.isPrintCashFlow() || !this.settingInfo.isPrintCashflowMeOrOther()) continue;
                        cashFlow = e.getCashflowEntry();
                        if (cashFlows != null && cashFlows.size() > 0 && cashFlow != null && cashFlow.size() > 0) {
                            cashFlows.addCollection(cashFlow);
                            continue;
                        }
                        if (cashFlow == null || cashFlow.size() <= 0) continue;
                        cashFlows = cashFlow;
                    }
                }
                itrEntry = vch.getEntries().iterator();
                int entryCount = 1;
                while (itrEntry.hasNext()) {
                    e = (VoucherEntryInfo)itrEntry.next();
                    EntryDC dc = e.getEntryDC();
                    drs.moveToInsertRow();
                    this.provider.clearRow((IRowSet)drs);
                    this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                    this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                    drs.updateString("sysDateNow", serverTime);
                    this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                    if (!totalVoucher) {
                        this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                    }
                    int page = 0;
                    page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                    drs.updateString("pageCount", page + "/" + voucherCount);
                    drs.updateString("pageCurrent", page + "");
                    drs.updateString("pageTotal", "" + voucherCount);
                    drs.updateString("bizStatus", this.getBizStatusString(vch.getBizStatus()));
                    drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                    drs.updateString("attachmentsChinese", attachmentsChinese);
                    if (page == voucherCount) {
                        drs.updateString("debitTotal", GlUtils.formatNumber(total[0][0], lcpre));
                        drs.updateString("creditTotal", GlUtils.formatNumber(total[0][1], lcpre));
                        drs.updateString("localAmountDebit", GlUtils.formatNumber(total[0][0], lcpre));
                        drs.updateString("localAmountCredit", GlUtils.formatNumber(total[0][1], lcpre));
                        drs.updateString("reportingAmountDebit", GlUtils.formatNumber(total[0][2], lcpre));
                        drs.updateString("reportingAmountCredit", GlUtils.formatNumber(total[0][3], lcpre));
                        drs.updateString("amountTotalChinese", amountTotalChinese);
                        drs.updateString("amountTotal", amountTotal);
                        drs.updateString("debitTotal_org", GlUtils.formatNumber(total[1][0], lcpre));
                        drs.updateString("creditTotal_org", GlUtils.formatNumber(total[1][1], lcpre));
                        drs.updateString("localAmountDebit_org", GlUtils.formatNumber(total[1][0], lcpre));
                        drs.updateString("localAmountCredit_org", GlUtils.formatNumber(total[1][1], lcpre));
                        drs.updateString("reportingAmountDebit_org", GlUtils.formatNumber(total[1][2], lcpre));
                        drs.updateString("reportingAmountCredit_org", GlUtils.formatNumber(total[1][3], lcpre));
                        drs.updateString("amountTotalChinese_org", amountTotalChineseOrg);
                        drs.updateString("amountTotal_org", amountTotalOrg);
                    }
                    if (this.settingInfo.isPrintCashFlow()) {
                        this.provider.printCashflow(drs, e, null, lcpre);
                    }
                    drs.insertRow();
                }
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)"Get rowset error!", (Throwable)ex);
            return null;
        }
        return drs;
    }

    private IRowSet getRowSet2(int rowLineCount) {
        Map cfResult = this.getCFResult();
        int colCount = (Integer)cfResult.get("colCount");
        int realColCount = (Integer)cfResult.get("realColCount");
        String[] cfInfoArr = (String[])cfResult.get("cfInfoArr");
        DynamicRowSet drs = null;
        IAssistantHG assistantHG = null;
        IBaseVoucherAssistRecord asstre = null;
        try {
            drs = new DynamicRowSet(realColCount);
            for (int i = 0; i < realColCount; ++i) {
                String obj;
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = colCount > i ? VoucherPrintDataProvider.col[i] : (obj = cfInfoArr[i - colCount]);
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            Iterator itrVch = this.vchCol.iterator();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            int vchCount = 0;
            Map<String, Set<String>> hGs = this.getAssistantHGs();
            Map<String, IObjectValue> asstHGMap = this.getAsstValue(hGs, assistantHG, asstre);
            HashSet<String> voucherCFSet = new HashSet<String>();
            HashSet<String> entryCFSet = new HashSet<String>();
            HashSet<String> asstCFSet = new HashSet<String>();
            for (int i = 0; cfInfoArr != null && i < cfInfoArr.length; ++i) {
                String item = cfInfoArr[i];
                if (item.startsWith("v#")) {
                    voucherCFSet.add(item);
                    continue;
                }
                if (item.startsWith("e#")) {
                    entryCFSet.add(item);
                    continue;
                }
                if (!item.startsWith("r#")) continue;
                asstCFSet.add(item);
            }
            String serverTime = GlUtils.formatDate(this.dft, SysUtil.getAppServerTime(null));
            String subtotal = GLResUtil.getRes("subtotal", this.locale);
            while (itrVch.hasNext()) {
                int lcpre;
                VoucherInfo vch = (VoucherInfo)itrVch.next();
                boolean totalVoucher = vch.containsKey("totalVoucher") ? vch.getBoolean("totalVoucher") : false;
                String attachmentsChinese = GlUtils.getChineseBig(vch.getAttachments(), this.locale);
                BigDecimal[][] total = this.getAmountForFinAndOrg(vch);
                String amountTotalChineseOrg = GlUtils.getChineseFormat(total[1][1], false, this.locale);
                String amountTotalOrg = GlUtils.getChineseFormat(total[1][1], false, this.locale);
                String amountTotalChinese = GlUtils.getChineseFormat(total[0][1], false, this.locale);
                String amountTotal = GlUtils.getChineseFormat(total[0][1], false, this.locale);
                String amountTotalChinese1 = GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale);
                String amountTotal1 = GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale);
                ++vchCount;
                String vchId = "";
                if (vch.getId() != null) {
                    vchId = vch.getId().toString();
                }
                CompanyOrgUnitInfo com = vch.getCompany();
                CurrencyInfo localCurrency = com.getBaseCurrency();
                int rcpre = lcpre = localCurrency.getPrecision();
                CurrencyInfo reportingCurrency = com.getReportCurrency();
                if (reportingCurrency != null) {
                    rcpre = reportingCurrency.getPrecision();
                }
                allDeit = vch.getLocalDebitAmount();
                allCret = vch.getLocalCreditAmount();
                Iterator itr = vch.getEntries().iterator();
                int entrySize = 0;
                int seq = 0;
                while (itr.hasNext()) {
                    VoucherEntryInfo e = (VoucherEntryInfo)itr.next();
                    seq = e.getSeq();
                    VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        entrySize += assitCollection.size();
                        continue;
                    }
                    ++entrySize;
                }
                Iterator itrEntry = vch.getEntries().iterator();
                int voucherCount = 0;
                voucherCount = (entrySize + seq) % rowLineCount == 0 ? (entrySize + seq) / rowLineCount : (entrySize + seq) / rowLineCount + 1;
                int entryCount = 1;
                while (itrEntry.hasNext()) {
                    int page;
                    VoucherEntryInfo e = (VoucherEntryInfo)itrEntry.next();
                    VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    EntryDC dc = e.getEntryDC();
                    int asstCount = 0;
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        for (VoucherAssistRecordInfo r : assitCollection) {
                            drs.moveToInsertRow();
                            this.provider.clearRow((IRowSet)drs);
                            this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                            this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                            drs.updateString("sysDateNow", serverTime);
                            this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                            if (!totalVoucher) {
                                this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                            }
                            if (this.settingInfo.isPrintAssistant()) {
                                this.provider.fillVoucherASSTData_new((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.df, lcpre, dc, asstHGMap, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                                if (!totalVoucher) {
                                    this.provider.fillVoucherASSTDataCF((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, asstCFSet);
                                }
                            }
                            if (++asstCount > 1) {
                                drs.updateString("e_seq", " ");
                                drs.updateString("e_account", null);
                            }
                            int page2 = 0;
                            page2 = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                            drs.updateString("pageCount", page2 + "/" + voucherCount);
                            drs.updateString("pageCurrent", page2 + "");
                            drs.updateString("pageTotal", "" + voucherCount);
                            drs.updateString("bizStatus", this.getBizStatusString(vch.getBizStatus()));
                            drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                            drs.updateString("attachmentsChinese", attachmentsChinese);
                            if (page2 == voucherCount) {
                                drs.updateString("debitTotal", GlUtils.formatNumber(total[0][0], lcpre));
                                drs.updateString("creditTotal", GlUtils.formatNumber(total[0][1], lcpre));
                                drs.updateString("localAmountDebit", GlUtils.formatNumber(total[0][0], lcpre));
                                drs.updateString("localAmountCredit", GlUtils.formatNumber(total[0][1], lcpre));
                                drs.updateString("reportingAmountDebit", GlUtils.formatNumber(total[0][2], lcpre));
                                drs.updateString("reportingAmountCredit", GlUtils.formatNumber(total[0][3], lcpre));
                                drs.updateString("amountTotalChinese", amountTotalChinese);
                                drs.updateString("amountTotal", amountTotal);
                                drs.updateString("debitTotal_org", GlUtils.formatNumber(total[1][0], lcpre));
                                drs.updateString("creditTotal_org", GlUtils.formatNumber(total[1][1], lcpre));
                                drs.updateString("localAmountDebit_org", GlUtils.formatNumber(total[1][0], lcpre));
                                drs.updateString("localAmountCredit_org", GlUtils.formatNumber(total[1][1], lcpre));
                                drs.updateString("reportingAmountDebit_org", GlUtils.formatNumber(total[1][2], lcpre));
                                drs.updateString("reportingAmountCredit_org", GlUtils.formatNumber(total[1][3], lcpre));
                                drs.updateString("amountTotalChinese_org", amountTotalChineseOrg);
                                drs.updateString("amountTotal_org", amountTotalOrg);
                                drs.updateString("sum", "");
                            }
                            drs.insertRow();
                        }
                    } else {
                        drs.moveToInsertRow();
                        this.provider.clearRow((IRowSet)drs);
                        this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                        this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                        drs.updateString("sysDateNow", serverTime);
                        this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                        if (!totalVoucher) {
                            this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                        }
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            drs.updateString("e_originalAmountDebit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                            drs.updateString("e_localAmountDebit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                            drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                            drs.updateString("r_originalAmountDebit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                            drs.updateString("r_localAmountDebit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                            drs.updateString("r_reportingAmountDebit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                        } else {
                            drs.updateString("e_localAmountCredit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                            drs.updateString("e_originalAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                            drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                            drs.updateString("r_originalAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                            drs.updateString("r_localAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                            drs.updateString("r_reportingAmountCredit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                        }
                        page = 0;
                        page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                        drs.updateString("pageCount", page + "/" + voucherCount);
                        drs.updateString("pageCurrent", page + "");
                        drs.updateString("pageTotal", "" + voucherCount);
                        drs.updateString("bizStatus", this.getBizStatusString(vch.getBizStatus()));
                        drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                        drs.updateString("attachmentsChinese", attachmentsChinese);
                        if (page == voucherCount) {
                            drs.updateString("debitTotal", GlUtils.formatNumber(total[0][0], lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber(total[0][1], lcpre));
                            drs.updateString("localAmountDebit", GlUtils.formatNumber(total[0][0], lcpre));
                            drs.updateString("localAmountCredit", GlUtils.formatNumber(total[0][1], lcpre));
                            drs.updateString("reportingAmountDebit", GlUtils.formatNumber(total[0][2], lcpre));
                            drs.updateString("reportingAmountCredit", GlUtils.formatNumber(total[0][3], lcpre));
                            drs.updateString("amountTotalChinese", amountTotalChinese);
                            drs.updateString("amountTotal", amountTotal);
                            drs.updateString("debitTotal_org", GlUtils.formatNumber(total[1][0], lcpre));
                            drs.updateString("creditTotal_org", GlUtils.formatNumber(total[1][1], lcpre));
                            drs.updateString("localAmountDebit_org", GlUtils.formatNumber(total[1][0], lcpre));
                            drs.updateString("localAmountCredit_org", GlUtils.formatNumber(total[1][1], lcpre));
                            drs.updateString("reportingAmountDebit_org", GlUtils.formatNumber(total[1][2], lcpre));
                            drs.updateString("reportingAmountCredit_org", GlUtils.formatNumber(total[1][3], lcpre));
                            drs.updateString("amountTotalChinese_org", amountTotalChineseOrg);
                            drs.updateString("amountTotal_org", amountTotalOrg);
                            drs.updateString("sum", "");
                        }
                        drs.insertRow();
                    }
                    drs.moveToInsertRow();
                    drs.updateString("e_seq", "");
                    drs.updateString("e_description", "");
                    drs.updateString("e_account", "");
                    drs.updateString("zc_account", "");
                    drs.updateString("e_currency", "");
                    drs.updateString("e_measureUnitName", "");
                    drs.updateString("e_measureUnitNumber", "");
                    drs.updateString("periodYear", "");
                    drs.updateString("periodNumber", "");
                    drs.updateString("bizDate", "");
                    drs.updateString("bookedDate", "");
                    drs.updateString("bookedDateYear", "");
                    drs.updateString("bookedDateMonth", "");
                    drs.updateString("r_description", "");
                    drs.updateString("r_settlementType", "");
                    drs.updateString("r_settlementCode", "");
                    drs.updateString("r_bizNumber", "");
                    drs.updateString("r_originalAmount", "");
                    drs.updateString("r_originalAmount", "");
                    drs.updateString("r_originalAmountDebit", "");
                    drs.updateString("r_localAmount", "");
                    drs.updateString("r_localAmountDebit", "");
                    drs.updateString("r_localAmountCredit", "");
                    drs.updateString("r_reportingAmount", "");
                    drs.updateString("r_reportingAmountDebit", "");
                    drs.updateString("r_reportingAmountCredit", "");
                    drs.updateString("r_measureUnitName", "");
                    drs.updateString("r_measureUnitNumber", "");
                    drs.updateString("r_price", "");
                    drs.updateString("r_quantity", "");
                    drs.updateString("r_bizDate", "");
                    drs.updateString("r_invoice", "");
                    drs.updateString("r_endDate", "");
                    drs.updateString("r_assGrp", "");
                    drs.updateString("r_longName", "");
                    drs.updateString("r_accountAsst", "");
                    drs.updateString("r_accountAsstPrimItem", "");
                    drs.updateString("r_AsstHeadNumber", "");
                    drs.updateString("r_AsstNumber", "");
                    drs.updateString("r_AsstHeadName", "");
                    drs.updateString("r_AsstName", "");
                    drs.updateString("r_AsstLevelName", "");
                    drs.updateString("zc_assGrp", "");
                    drs.updateString("c_item", "");
                    drs.updateString("c_itemEbb", "");
                    drs.updateString("c_primItem", "");
                    drs.updateString("c_suppItem", "");
                    drs.updateString("c_oppAccount", "");
                    drs.updateString("c_originalAmount", "");
                    drs.updateString("c_localAmount", "");
                    drs.updateString("c_reportingAmount", "");
                    drs.updateString("c_primItemName", "");
                    drs.updateString("c_suppItemName", "");
                    drs.updateString("customer.number", "");
                    drs.updateString("customer.name", "");
                    drs.updateString("cusNumberName", "");
                    drs.updateString("vchId", vchId);
                    drs.updateString("e_isoCode", subtotal);
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        drs.updateString("e_originalAmountDebit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_localAmountDebit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                        drs.updateString("r_originalAmountDebit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_localAmountDebit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("r_reportingAmountDebit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                    } else {
                        drs.updateString("e_localAmountCredit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_originalAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                        drs.updateString("r_originalAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_localAmountCredit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("r_reportingAmountCredit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                    }
                    page = 0;
                    page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                    drs.updateString("pageCount", page + "/" + voucherCount);
                    drs.updateString("pageCurrent", page + "");
                    drs.updateString("pageTotal", "" + voucherCount);
                    drs.updateString("bizStatus", this.getBizStatusString(vch.getBizStatus()));
                    drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                    drs.updateString("attachmentsChinese", attachmentsChinese);
                    if (page == voucherCount) {
                        drs.updateString("debitTotal", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("creditTotal", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("localAmountDebit", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("localAmountCredit", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("reportingAmountDebit", GlUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                        drs.updateString("reportingAmountCredit", GlUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                        drs.updateString("amountTotalChinese", amountTotalChinese1);
                        drs.updateString("amountTotal", amountTotal1);
                    }
                    drs.insertRow();
                }
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)"Get rowset error!", (Throwable)ex);
            return null;
        }
        return drs;
    }

    protected Map<String, Set<String>> getAssistantHGs() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        if (!this.settingInfo.isPrintAssistant()) {
            return result;
        }
        VoucherEntryInfo e2 = null;
        for (VoucherInfo vch : this.vchCol) {
            for (VoucherEntryInfo e2 : vch.getEntries()) {
                VoucherAssistRecordCollection assitCollection;
                HashSet<String> assGrpIds = (HashSet<String>)result.get(e2.getId().toString());
                if (assGrpIds == null) {
                    assGrpIds = new HashSet<String>();
                    result.put(e2.getId().toString(), assGrpIds);
                }
                if ((assitCollection = e2.getAssistRecords()) == null || assitCollection.size() <= 0 || !this.settingInfo.isPrintAssistant()) continue;
                for (VoucherAssistRecordInfo r : assitCollection) {
                    if (r.getAssGrp() == null) continue;
                    assGrpIds.add(r.getAssGrp().getId().toString());
                }
            }
        }
        return result;
    }

    private Map<String, IObjectValue> getAsstValue(Map<String, Set<String>> hGs, IAssistantHG assistantHG, IBaseVoucherAssistRecord asstre) throws EASBizException, BOSException {
        HashMap<String, IObjectValue> result = new HashMap<String, IObjectValue>();
        String[] assGrpIds = null;
        if (assistantHG == null) {
            assistantHG = AssistantHGFactory.getRemoteInstance();
        }
        if (asstre == null) {
            asstre = VoucherAssistRecordFactory.getRemoteInstance();
        }
        Object objectUUidPK = null;
        AssistantHGInfo info = null;
        Map asstGrpMap = null;
        IObjectValue value = null;
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        HashMap<String, Set<String>> assistHGMap = new HashMap<String, Set<String>>();
        HashMap<String, String> entryToAssist = new HashMap<String, String>();
        HashSet<String> idSet = new HashSet<String>();
        for (String entryId : hGs.keySet()) {
            String[] tempIds = hGs.get(entryId).toArray(new String[0]);
            if (tempIds.length == 0) continue;
            String id = tempIds[0];
            idSet.add(id);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("longNameGroup"));
        view.getSelector().add(new SelectorItemInfo("asstAccount.id"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        AssistantHGCollection coll = assistantHG.getAssistantHGCollection(view);
        for (String entryId : hGs.keySet()) {
            assGrpIds = hGs.get(entryId).toArray(new String[0]);
            if (assGrpIds.length == 0) continue;
            String id = assGrpIds[0];
            info = coll.get((Object)BOSUuid.read((String)id));
            String asstAccountId = info.getAsstAccount().getId().toString();
            Integer count = info.getLongNameGroup().split(";").length;
            countMap.put(asstAccountId, count);
            Set<String> assGrpIdSet = (Set<String>)assistHGMap.get(asstAccountId);
            if (assGrpIdSet == null) {
                assGrpIdSet = hGs.get(entryId);
            } else {
                assGrpIdSet.addAll((Collection<String>)hGs.get(entryId));
            }
            assistHGMap.put(asstAccountId, assGrpIdSet);
            entryToAssist.put(entryId, asstAccountId);
        }
        for (String asstAccountId : assistHGMap.keySet()) {
            Integer count = (Integer)countMap.get(asstAccountId);
            String[] asstGrpids = ((Set)assistHGMap.get(asstAccountId)).toArray(new String[0]);
            asstGrpMap = asstre.getDefaultAssitInfos(asstAccountId, count, asstGrpids);
            for (Object assGrpId : asstGrpMap.keySet()) {
                value = (IObjectValue)asstGrpMap.get(assGrpId);
                if (value == null) continue;
                result.put(assGrpId.toString(), value);
            }
        }
        return result;
    }

    private Map getCFResult() {
        int colCount;
        HashMap<String, Object> result = new HashMap<String, Object>();
        int realColCount = colCount = VoucherPrintDataProvider.col.length;
        String[] cfInfoArr = null;
        String cfInfo = null;
        try {
            cfInfo = UserSettingFactory.getRemoteInstance().getValueCF();
            if (!StringUtils.isEmpty((String)cfInfo) && (cfInfoArr = cfInfo.split(",")) != null && cfInfoArr.length > 0) {
                realColCount += cfInfoArr.length;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        result.put("colCount", colCount);
        result.put("realColCount", realColCount);
        result.put("cfInfoArr", cfInfoArr);
        return result;
    }

    private IRowSet getRowSet3(int rowLineCount) {
        Map cfResult = this.getCFResult();
        int colCount = (Integer)cfResult.get("colCount");
        int realColCount = (Integer)cfResult.get("realColCount");
        String[] cfInfoArr = (String[])cfResult.get("cfInfoArr");
        DynamicRowSet drs = null;
        IAssistantHG assistantHG = null;
        IBaseVoucherAssistRecord asstre = null;
        VoucherEntryInfo e = null;
        try {
            drs = new DynamicRowSet(realColCount);
            for (int i = 0; i < realColCount; ++i) {
                String obj;
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = colCount > i ? VoucherPrintDataProvider.col[i] : (obj = cfInfoArr[i - colCount]);
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            Iterator itrVch = this.vchCol.iterator();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            int vchCount = 0;
            Map<String, Set<String>> hGs = this.getAssistantHGs();
            Map<String, IObjectValue> asstHGMap = this.getAsstValue(hGs, assistantHG, asstre);
            HashSet<String> voucherCFSet = new HashSet<String>();
            HashSet<String> entryCFSet = new HashSet<String>();
            HashSet<String> asstCFSet = new HashSet<String>();
            for (int i = 0; cfInfoArr != null && i < cfInfoArr.length; ++i) {
                String item = cfInfoArr[i];
                if (item.startsWith("v#")) {
                    voucherCFSet.add(item);
                    continue;
                }
                if (item.startsWith("e#")) {
                    entryCFSet.add(item);
                    continue;
                }
                if (!item.startsWith("r#")) continue;
                asstCFSet.add(item);
            }
            String serverTime = GlUtils.formatDate(this.dft, SysUtil.getAppServerTime(null));
            while (itrVch.hasNext()) {
                int lcpre;
                VoucherInfo vch = (VoucherInfo)itrVch.next();
                boolean totalVoucher = vch.containsKey("totalVoucher") ? vch.getBoolean("totalVoucher") : false;
                BigDecimal[][] total = this.getAmountForFinAndOrg(vch);
                String attachmentsChinese = GlUtils.getChineseBig(vch.getAttachments(), this.locale);
                String amountTotalChineseOrg = GlUtils.getChineseFormat(total[1][1], false, this.locale);
                String amountTotalOrg = GlUtils.getChineseFormat(total[1][1], false, this.locale);
                String amountTotalChinese = GlUtils.getChineseFormat(total[0][1], false, this.locale);
                String amountTotal = GlUtils.getChineseFormat(total[0][1], false, this.locale);
                ++vchCount;
                String vchId = "";
                if (vch.getId() != null) {
                    vchId = vch.getId().toString();
                }
                CompanyOrgUnitInfo com = vch.getCompany();
                CurrencyInfo localCurrency = com.getBaseCurrency();
                int rcpre = lcpre = localCurrency.getPrecision();
                CurrencyInfo reportingCurrency = com.getReportCurrency();
                if (reportingCurrency != null) {
                    rcpre = reportingCurrency.getPrecision();
                }
                allDeit = vch.getLocalDebitAmount();
                allCret = vch.getLocalCreditAmount();
                Iterator itr = vch.getEntries().iterator();
                int entrySize = 0;
                while (itr.hasNext()) {
                    e = (VoucherEntryInfo)itr.next();
                    VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        entrySize += assitCollection.size();
                        continue;
                    }
                    ++entrySize;
                }
                Iterator itrEntry = vch.getEntries().iterator();
                int voucherCount = 0;
                voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
                int entryCount = 0;
                while (itrEntry.hasNext()) {
                    e = (VoucherEntryInfo)itrEntry.next();
                    VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    EntryDC dc = e.getEntryDC();
                    int asstCount = 0;
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        for (VoucherAssistRecordInfo r : assitCollection) {
                            drs.moveToInsertRow();
                            this.provider.clearRow((IRowSet)drs);
                            this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                            this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                            drs.updateString("sysDateNow", serverTime);
                            this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                            if (!totalVoucher) {
                                this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                            }
                            if (this.settingInfo.isPrintAssistant()) {
                                this.provider.fillVoucherASSTData_new((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.df, lcpre, dc, asstHGMap, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                                if (!totalVoucher) {
                                    this.provider.fillVoucherASSTDataCF((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, asstCFSet);
                                }
                            }
                            if (++asstCount > 1) {
                                drs.updateString("e_seq", " ");
                            }
                            int page = 0;
                            page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                            drs.updateString("pageCount", page + "/" + voucherCount);
                            drs.updateString("pageCurrent", page + "");
                            drs.updateString("pageTotal", "" + voucherCount);
                            drs.updateString("bizStatus", this.getBizStatusString(vch.getBizStatus()));
                            drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                            drs.updateString("attachmentsChinese", attachmentsChinese);
                            if (page == voucherCount) {
                                drs.updateString("debitTotal", GlUtils.formatNumber(total[0][0], lcpre));
                                drs.updateString("creditTotal", GlUtils.formatNumber(total[0][1], lcpre));
                                drs.updateString("localAmountDebit", GlUtils.formatNumber(total[0][0], lcpre));
                                drs.updateString("localAmountCredit", GlUtils.formatNumber(total[0][1], lcpre));
                                drs.updateString("reportingAmountDebit", GlUtils.formatNumber(total[0][2], lcpre));
                                drs.updateString("reportingAmountCredit", GlUtils.formatNumber(total[0][3], lcpre));
                                drs.updateString("amountTotalChinese", amountTotalChinese);
                                drs.updateString("amountTotal", amountTotal);
                                drs.updateString("debitTotal_org", GlUtils.formatNumber(total[1][0], lcpre));
                                drs.updateString("creditTotal_org", GlUtils.formatNumber(total[1][1], lcpre));
                                drs.updateString("localAmountDebit_org", GlUtils.formatNumber(total[1][0], lcpre));
                                drs.updateString("localAmountCredit_org", GlUtils.formatNumber(total[1][1], lcpre));
                                drs.updateString("reportingAmountDebit_org", GlUtils.formatNumber(total[1][2], lcpre));
                                drs.updateString("reportingAmountCredit_org", GlUtils.formatNumber(total[1][3], lcpre));
                                drs.updateString("amountTotalChinese_org", amountTotalChineseOrg);
                                drs.updateString("amountTotal_org", amountTotalOrg);
                            }
                            drs.insertRow();
                        }
                        continue;
                    }
                    drs.moveToInsertRow();
                    this.provider.clearRow((IRowSet)drs);
                    this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                    this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                    drs.updateString("sysDateNow", serverTime);
                    this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                    this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        drs.updateString("e_originalAmountDebit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_localAmountDebit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                        drs.updateString("r_originalAmountDebit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_localAmountDebit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("r_reportingAmountDebit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                    } else {
                        drs.updateString("e_localAmountCredit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_originalAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                        drs.updateString("r_originalAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_localAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_reportingAmountCredit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                    }
                    int page = 0;
                    page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                    drs.updateString("pageCount", page + "/" + voucherCount);
                    drs.updateString("pageCurrent", page + "");
                    drs.updateString("pageTotal", "" + voucherCount);
                    drs.updateString("bizStatus", this.getBizStatusString(vch.getBizStatus()));
                    drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                    drs.updateString("attachmentsChinese", attachmentsChinese);
                    if (page == voucherCount) {
                        drs.updateString("debitTotal", GlUtils.formatNumber(total[0][0], lcpre));
                        drs.updateString("creditTotal", GlUtils.formatNumber(total[0][1], lcpre));
                        drs.updateString("localAmountDebit", GlUtils.formatNumber(total[0][0], lcpre));
                        drs.updateString("localAmountCredit", GlUtils.formatNumber(total[0][1], lcpre));
                        drs.updateString("reportingAmountDebit", GlUtils.formatNumber(total[0][2], lcpre));
                        drs.updateString("reportingAmountCredit", GlUtils.formatNumber(total[0][3], lcpre));
                        drs.updateString("amountTotalChinese", amountTotalChinese);
                        drs.updateString("amountTotal", amountTotal);
                        drs.updateString("debitTotal_org", GlUtils.formatNumber(total[1][0], lcpre));
                        drs.updateString("creditTotal_org", GlUtils.formatNumber(total[1][1], lcpre));
                        drs.updateString("localAmountDebit_org", GlUtils.formatNumber(total[1][0], lcpre));
                        drs.updateString("localAmountCredit_org", GlUtils.formatNumber(total[1][1], lcpre));
                        drs.updateString("reportingAmountDebit_org", GlUtils.formatNumber(total[1][2], lcpre));
                        drs.updateString("reportingAmountCredit_org", GlUtils.formatNumber(total[1][3], lcpre));
                        drs.updateString("amountTotalChinese_org", amountTotalChineseOrg);
                        drs.updateString("amountTotal_org", amountTotalOrg);
                    }
                    drs.insertRow();
                }
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)"Get rowset error!", (Throwable)ex);
            return null;
        }
        return drs;
    }

    private BigDecimal[][] getAmountForFinAndOrg(VoucherInfo vch) {
        BigDecimal finLocalDebit = new BigDecimal("0");
        BigDecimal finLocalCredit = new BigDecimal("0");
        BigDecimal finReportingDebit = new BigDecimal("0");
        BigDecimal finReportingCredit = new BigDecimal("0");
        BigDecimal orgLocalDebit = new BigDecimal("0");
        BigDecimal orgLocalCredit = new BigDecimal("0");
        BigDecimal orgReportingDebit = new BigDecimal("0");
        BigDecimal orgReportingCredit = new BigDecimal("0");
        for (VoucherEntryInfo entryInfo : vch.getEntries()) {
            if (null != entryInfo.getAccount() && null != entryInfo.getAccount().getCategory() && entryInfo.getAccount().getCategory().getValue() == 2) {
                if (EntryDC.DEBIT.equals((Object)entryInfo.getEntryDC())) {
                    orgLocalDebit = orgLocalDebit.add(entryInfo.getLocalAmount());
                    orgReportingDebit = orgReportingDebit.add(entryInfo.getReportingAmount());
                    continue;
                }
                orgLocalCredit = orgLocalCredit.add(entryInfo.getLocalAmount());
                orgReportingCredit = orgReportingCredit.add(entryInfo.getReportingAmount());
                continue;
            }
            if (EntryDC.DEBIT.equals((Object)entryInfo.getEntryDC())) {
                finLocalDebit = finLocalDebit.add(entryInfo.getLocalAmount());
                finReportingDebit = finReportingDebit.add(entryInfo.getReportingAmount());
                continue;
            }
            finLocalCredit = finLocalCredit.add(entryInfo.getLocalAmount());
            finReportingCredit = finReportingCredit.add(entryInfo.getReportingAmount());
        }
        return new BigDecimal[][]{{finLocalDebit, finLocalCredit, finReportingDebit, finReportingCredit}, {orgLocalDebit, orgLocalCredit, orgReportingDebit, orgReportingCredit}};
    }

    private IRowSet getRowSet4(int rowLineCount) {
        Map cfResult = this.getCFResult();
        int colCount = (Integer)cfResult.get("colCount");
        int realColCount = (Integer)cfResult.get("realColCount");
        String[] cfInfoArr = (String[])cfResult.get("cfInfoArr");
        DynamicRowSet drs = null;
        IAssistantHG assistantHG = null;
        IBaseVoucherAssistRecord asstre = null;
        try {
            drs = new DynamicRowSet(realColCount);
            for (int i = 0; i < realColCount; ++i) {
                String obj;
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = colCount > i ? VoucherPrintDataProvider.col[i] : (obj = cfInfoArr[i - colCount]);
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            Iterator itrVch = this.vchCol.iterator();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            HashSet<String> voucherCFSet = new HashSet<String>();
            HashSet<String> entryCFSet = new HashSet<String>();
            HashSet<String> asstCFSet = new HashSet<String>();
            for (int i = 0; cfInfoArr != null && i < cfInfoArr.length; ++i) {
                String item = cfInfoArr[i];
                if (item.startsWith("v#")) {
                    voucherCFSet.add(item);
                    continue;
                }
                if (item.startsWith("e#")) {
                    entryCFSet.add(item);
                    continue;
                }
                if (!item.startsWith("r#")) continue;
                asstCFSet.add(item);
            }
            int vchCount = 0;
            Map<String, Set<String>> hGs = this.getAssistantHGs();
            Map<String, IObjectValue> asstHGMap = this.getAsstValue(hGs, assistantHG, asstre);
            String serverTime = GlUtils.formatDate(this.dft, SysUtil.getAppServerTime(null));
            String subtotal = GLResUtil.getRes("subtotal");
            while (itrVch.hasNext()) {
                int lcpre;
                VoucherInfo vch = (VoucherInfo)itrVch.next();
                boolean totalVoucher = vch.containsKey("totalVoucher") ? vch.getBoolean("totalVoucher") : false;
                String attachmentsChinese = GlUtils.getChineseBig(vch.getAttachments(), this.locale);
                String amountTotalChinese = GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale);
                String amountTotal = GlUtils.getChineseFormat(vch.getLocalCreditAmount(), false, this.locale);
                ++vchCount;
                String vchId = vch.getId().toString();
                CompanyOrgUnitInfo com = vch.getCompany();
                CurrencyInfo localCurrency = com.getBaseCurrency();
                int rcpre = lcpre = localCurrency.getPrecision();
                CurrencyInfo reportingCurrency = com.getReportCurrency();
                if (reportingCurrency != null) {
                    rcpre = reportingCurrency.getPrecision();
                }
                allDeit = vch.getLocalDebitAmount();
                allCret = vch.getLocalCreditAmount();
                Iterator itr = vch.getEntries().iterator();
                int entrySize = 0;
                while (itr.hasNext()) {
                    VoucherEntryInfo e = (VoucherEntryInfo)itr.next();
                    VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        entrySize += assitCollection.size();
                        continue;
                    }
                    ++entrySize;
                }
                Iterator itrEntry = vch.getEntries().iterator();
                int voucherCount = 0;
                voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
                int entryCount = 0;
                BigDecimal creditTotal = GlUtils.zero;
                BigDecimal debitTotal = GlUtils.zero;
                HashMap<String, BigDecimal> creditmap = new HashMap<String, BigDecimal>();
                HashMap<String, BigDecimal> debitmap = new HashMap<String, BigDecimal>();
                for (VoucherEntryInfo e : vch.getEntries()) {
                    EntryDC dc = e.getEntryDC();
                    VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        for (VoucherAssistRecordInfo r : assitCollection) {
                            int page = 0;
                            page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                            if (entryCount % rowLineCount == 1) {
                                creditTotal = GlUtils.zero;
                                debitTotal = GlUtils.zero;
                            }
                            if (EntryDC.DEBIT.equals((Object)dc)) {
                                debitTotal = debitTotal.add(r.getLocalAmount());
                            } else {
                                creditTotal = creditTotal.add(r.getLocalAmount());
                            }
                            if (entryCount % rowLineCount != 0) continue;
                            creditmap.put(String.valueOf(page), creditTotal);
                            debitmap.put(String.valueOf(page), debitTotal);
                        }
                        continue;
                    }
                    int page = 0;
                    page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                    if (entryCount % rowLineCount == 1) {
                        creditTotal = GlUtils.zero;
                        debitTotal = GlUtils.zero;
                    }
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        debitTotal = debitTotal.add(e.getLocalAmount());
                    } else {
                        creditTotal = creditTotal.add(e.getLocalAmount());
                    }
                    if (entryCount % rowLineCount != 0) continue;
                    creditmap.put(String.valueOf(page), creditTotal);
                    debitmap.put(String.valueOf(page), debitTotal);
                }
                entryCount = 0;
                while (itrEntry.hasNext()) {
                    VoucherEntryInfo e;
                    e = (VoucherEntryInfo)itrEntry.next();
                    VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    EntryDC dc = e.getEntryDC();
                    int asstCount = 0;
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        for (VoucherAssistRecordInfo r : assitCollection) {
                            drs.moveToInsertRow();
                            this.provider.clearRow((IRowSet)drs);
                            this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                            this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                            this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                            if (!totalVoucher) {
                                this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                            }
                            if (this.settingInfo.isPrintAssistant()) {
                                this.provider.fillVoucherASSTData_new((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.df, lcpre, dc, asstHGMap, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                                if (!totalVoucher) {
                                    this.provider.fillVoucherASSTDataCF((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, asstCFSet);
                                }
                            }
                            if (++asstCount > 1) {
                                drs.updateString("e_seq", " ");
                            }
                            int page = 0;
                            if (++entryCount % rowLineCount == 0) {
                                page = entryCount / rowLineCount;
                            } else {
                                page = entryCount / rowLineCount + 1;
                                if (entryCount % rowLineCount == 1) {
                                    creditTotal = GlUtils.zero;
                                    debitTotal = GlUtils.zero;
                                }
                            }
                            if (EntryDC.DEBIT.equals((Object)dc)) {
                                debitTotal = debitTotal.add(r.getLocalAmount());
                            } else {
                                creditTotal = creditTotal.add(r.getLocalAmount());
                            }
                            drs.updateString("pageCount", page + "/" + voucherCount);
                            drs.updateString("pageCurrent", page + "");
                            drs.updateString("pageTotal", "" + voucherCount);
                            drs.updateString("bizStatus", this.getBizStatusString(vch.getBizStatus()));
                            drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                            drs.updateString("attachmentsChinese", attachmentsChinese);
                            if (page == voucherCount) {
                                drs.updateString("debitTotal", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                                drs.updateString("creditTotal", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                                drs.updateString("localAmountDebit", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                                drs.updateString("localAmountCredit", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                                drs.updateString("reportingAmountDebit", GlUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                                drs.updateString("reportingAmountCredit", GlUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                                drs.updateString("amountTotalChinese", amountTotalChinese);
                                drs.updateString("amountTotal", amountTotal);
                                drs.updateString("sum", "");
                            } else {
                                drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)debitmap.get(String.valueOf(page)), lcpre));
                                drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)creditmap.get(String.valueOf(page)), lcpre));
                                drs.updateString("sum", subtotal);
                            }
                            drs.insertRow();
                        }
                        continue;
                    }
                    drs.moveToInsertRow();
                    this.provider.clearRow((IRowSet)drs);
                    this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                    this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                    drs.updateString("sysDateNow", serverTime);
                    this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                    if (!totalVoucher) {
                        this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                    }
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        drs.updateString("e_originalAmountDebit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_localAmountDebit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                        drs.updateString("r_originalAmountDebit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_localAmountDebit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("r_reportingAmountDebit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                    } else {
                        drs.updateString("e_localAmountCredit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_originalAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                        drs.updateString("r_originalAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_localAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_reportingAmountCredit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                    }
                    int page = 0;
                    if (++entryCount % rowLineCount == 0) {
                        page = entryCount / rowLineCount;
                    } else {
                        page = entryCount / rowLineCount + 1;
                        if (entryCount % rowLineCount == 1) {
                            creditTotal = GlUtils.zero;
                            debitTotal = GlUtils.zero;
                        }
                    }
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        debitTotal = debitTotal.add(e.getLocalAmount());
                    } else {
                        creditTotal = creditTotal.add(e.getLocalAmount());
                    }
                    drs.updateString("pageCount", page + "/" + voucherCount);
                    drs.updateString("pageCurrent", page + "");
                    drs.updateString("pageTotal", "" + voucherCount);
                    drs.updateString("bizStatus", this.getBizStatusString(vch.getBizStatus()));
                    drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                    drs.updateString("attachmentsChinese", attachmentsChinese);
                    if (page == voucherCount) {
                        drs.updateString("debitTotal", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("creditTotal", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("localAmountDebit", GlUtils.formatNumber(vch.getLocalDebitAmount(), lcpre));
                        drs.updateString("localAmountCredit", GlUtils.formatNumber(vch.getLocalCreditAmount(), lcpre));
                        drs.updateString("reportingAmountDebit", GlUtils.formatNumber(vch.getReportingDebitAmount(), lcpre));
                        drs.updateString("reportingAmountCredit", GlUtils.formatNumber(vch.getReportingCreditAmount(), lcpre));
                        drs.updateString("amountTotalChinese", amountTotalChinese);
                        drs.updateString("amountTotal", amountTotal);
                        drs.updateString("sum", "");
                    } else {
                        drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)debitmap.get(String.valueOf(page)), lcpre));
                        drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)creditmap.get(String.valueOf(page)), lcpre));
                        drs.updateString("sum", subtotal);
                    }
                    drs.insertRow();
                }
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)"Get rowset error!", (Throwable)ex);
            return null;
        }
        return drs;
    }

    private IRowSet getRowSet5(int rowLineCount) {
        Map cfResult = this.getCFResult();
        int colCount = (Integer)cfResult.get("colCount");
        int realColCount = (Integer)cfResult.get("realColCount");
        String[] cfInfoArr = (String[])cfResult.get("cfInfoArr");
        DynamicRowSet drs = null;
        IAssistantHG assistantHG = null;
        IBaseVoucherAssistRecord asstre = null;
        try {
            drs = new DynamicRowSet(realColCount);
            for (int i = 0; i < realColCount; ++i) {
                String obj;
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = colCount > i ? VoucherPrintDataProvider.col[i] : (obj = cfInfoArr[i - colCount]);
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            Iterator itrVch = this.vchCol.iterator();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            int vchCount = 0;
            Map<String, Set<String>> hGs = this.getAssistantHGs();
            Map<String, IObjectValue> asstHGMap = this.getAsstValue(hGs, assistantHG, asstre);
            HashSet<String> voucherCFSet = new HashSet<String>();
            HashSet<String> entryCFSet = new HashSet<String>();
            HashSet<String> asstCFSet = new HashSet<String>();
            for (int i = 0; cfInfoArr != null && i < cfInfoArr.length; ++i) {
                String item = cfInfoArr[i];
                if (item.startsWith("v#")) {
                    voucherCFSet.add(item);
                    continue;
                }
                if (item.startsWith("e#")) {
                    entryCFSet.add(item);
                    continue;
                }
                if (!item.startsWith("r#")) continue;
                asstCFSet.add(item);
            }
            String serverTime = GlUtils.formatDate(this.dft, SysUtil.getAppServerTime(null));
            String subtotal = GLResUtil.getRes("subtotal");
            while (itrVch.hasNext()) {
                int lcpre;
                VoucherInfo vch = (VoucherInfo)itrVch.next();
                boolean totalVoucher = vch.containsKey("totalVoucher") ? vch.getBoolean("totalVoucher") : false;
                String attachmentsChinese = GlUtils.getChineseBig(vch.getAttachments(), this.locale);
                BigDecimal[][] total = this.getAmountForFinAndOrg(vch);
                String amountTotalChineseOrg = GlUtils.getChineseFormat(total[1][1], false, this.locale);
                String amountTotalOrg = GlUtils.getChineseFormat(total[1][1], false, this.locale);
                String amountTotalChinese = GlUtils.getChineseFormat(total[0][1], false, this.locale);
                String amountTotal = GlUtils.getChineseFormat(total[0][1], false, this.locale);
                ++vchCount;
                String vchId = vch.getId().toString();
                CompanyOrgUnitInfo com = vch.getCompany();
                CurrencyInfo localCurrency = com.getBaseCurrency();
                int rcpre = lcpre = localCurrency.getPrecision();
                CurrencyInfo reportingCurrency = com.getReportCurrency();
                if (reportingCurrency != null) {
                    rcpre = reportingCurrency.getPrecision();
                }
                allDeit = vch.getLocalDebitAmount();
                allCret = vch.getLocalCreditAmount();
                Iterator itr = vch.getEntries().iterator();
                int entrySize = 0;
                while (itr.hasNext()) {
                    VoucherEntryInfo e = (VoucherEntryInfo)itr.next();
                    VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        entrySize += assitCollection.size();
                        continue;
                    }
                    ++entrySize;
                }
                Iterator itrEntry = vch.getEntries().iterator();
                int voucherCount = 0;
                voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
                int entryCount = 0;
                BigDecimal creditTotal = GlUtils.zero;
                BigDecimal debitTotal = GlUtils.zero;
                HashMap<String, BigDecimal> creditmap = new HashMap<String, BigDecimal>();
                HashMap<String, BigDecimal> debitmap = new HashMap<String, BigDecimal>();
                for (VoucherEntryInfo e : vch.getEntries()) {
                    EntryDC dc = e.getEntryDC();
                    VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        for (VoucherAssistRecordInfo r : assitCollection) {
                            int page = 0;
                            page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                            if (entryCount % rowLineCount == 1) {
                                creditTotal = GlUtils.zero;
                                debitTotal = GlUtils.zero;
                            }
                            if (EntryDC.DEBIT.equals((Object)dc)) {
                                debitTotal = debitTotal.add(r.getLocalAmount());
                            } else {
                                creditTotal = creditTotal.add(r.getLocalAmount());
                            }
                            if (entryCount % rowLineCount != 0) continue;
                            creditmap.put(String.valueOf(page), creditTotal);
                            debitmap.put(String.valueOf(page), debitTotal);
                        }
                        continue;
                    }
                    int page = 0;
                    page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                    if (entryCount % rowLineCount == 1) {
                        creditTotal = GlUtils.zero;
                        debitTotal = GlUtils.zero;
                    }
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        debitTotal = debitTotal.add(e.getLocalAmount());
                    } else {
                        creditTotal = creditTotal.add(e.getLocalAmount());
                    }
                    if (entryCount % rowLineCount != 0) continue;
                    creditmap.put(String.valueOf(page), creditTotal);
                    debitmap.put(String.valueOf(page), debitTotal);
                }
                entryCount = 0;
                while (itrEntry.hasNext()) {
                    VoucherEntryInfo e;
                    e = (VoucherEntryInfo)itrEntry.next();
                    VoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                    EntryDC dc = e.getEntryDC();
                    int asstCount = 0;
                    if (assitCollection != null && assitCollection.size() > 0 && this.settingInfo.isPrintAssistant()) {
                        for (VoucherAssistRecordInfo r : assitCollection) {
                            drs.moveToInsertRow();
                            this.provider.clearRow((IRowSet)drs);
                            this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                            this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                            drs.updateString("sysDateNow", serverTime);
                            this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                            if (!totalVoucher) {
                                this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                            }
                            if (this.settingInfo.isPrintAssistant()) {
                                this.provider.fillVoucherASSTData_new((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.df, lcpre, dc, asstHGMap, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                                if (!totalVoucher) {
                                    this.provider.fillVoucherASSTDataCF((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, asstCFSet);
                                }
                            }
                            if (++asstCount > 1) {
                                drs.updateString("e_seq", " ");
                            }
                            int page = 0;
                            if (++entryCount % rowLineCount == 0) {
                                page = entryCount / rowLineCount;
                            } else {
                                page = entryCount / rowLineCount + 1;
                                if (entryCount % rowLineCount == 1) {
                                    creditTotal = GlUtils.zero;
                                    debitTotal = GlUtils.zero;
                                }
                            }
                            if (EntryDC.DEBIT.equals((Object)dc)) {
                                debitTotal = debitTotal.add(r.getLocalAmount());
                            } else {
                                creditTotal = creditTotal.add(r.getLocalAmount());
                            }
                            drs.updateString("pageCount", page + "/" + voucherCount);
                            drs.updateString("pageCurrent", page + "");
                            drs.updateString("pageTotal", "" + voucherCount);
                            drs.updateString("bizStatus", this.getBizStatusString(vch.getBizStatus()));
                            drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                            drs.updateString("attachmentsChinese", attachmentsChinese);
                            if (page == voucherCount) {
                                drs.updateString("debitTotal", GlUtils.formatNumber(total[0][0], lcpre));
                                drs.updateString("creditTotal", GlUtils.formatNumber(total[0][1], lcpre));
                                drs.updateString("localAmountDebit", GlUtils.formatNumber(total[0][0], lcpre));
                                drs.updateString("localAmountCredit", GlUtils.formatNumber(total[0][1], lcpre));
                                drs.updateString("reportingAmountDebit", GlUtils.formatNumber(total[0][2], lcpre));
                                drs.updateString("reportingAmountCredit", GlUtils.formatNumber(total[0][3], lcpre));
                                drs.updateString("amountTotalChinese", amountTotalChinese);
                                drs.updateString("amountTotal", amountTotal);
                                drs.updateString("debitTotal_org", GlUtils.formatNumber(total[1][0], lcpre));
                                drs.updateString("creditTotal_org", GlUtils.formatNumber(total[1][1], lcpre));
                                drs.updateString("localAmountDebit_org", GlUtils.formatNumber(total[1][0], lcpre));
                                drs.updateString("localAmountCredit_org", GlUtils.formatNumber(total[1][1], lcpre));
                                drs.updateString("reportingAmountDebit_org", GlUtils.formatNumber(total[1][2], lcpre));
                                drs.updateString("reportingAmountCredit_org", GlUtils.formatNumber(total[1][3], lcpre));
                                drs.updateString("amountTotalChinese_org", amountTotalChineseOrg);
                                drs.updateString("amountTotal_org", amountTotalOrg);
                                drs.updateString("sum", "");
                            } else {
                                drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)debitmap.get(String.valueOf(page)), lcpre));
                                drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)creditmap.get(String.valueOf(page)), lcpre));
                                drs.updateString("sum", subtotal);
                            }
                            if (this.settingInfo.isPrintCashFlow()) {
                                this.provider.printCashflow(drs, e, r, lcpre);
                            }
                            drs.insertRow();
                        }
                        continue;
                    }
                    drs.moveToInsertRow();
                    this.provider.clearRow((IRowSet)drs);
                    this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                    this.provider.fillVoucherHeaderDataCF((BaseVoucherInfo)vch, (IRowSet)drs, voucherCFSet);
                    drs.updateString("sysDateNow", serverTime);
                    this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                    if (!totalVoucher) {
                        this.provider.fillVoucherEntryDataCF((BaseVoucherEntryInfo)e, (IRowSet)drs, entryCFSet);
                    }
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        drs.updateString("e_originalAmountDebit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_localAmountDebit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                        drs.updateString("r_originalAmountDebit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_localAmountDebit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("r_reportingAmountDebit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                    } else {
                        drs.updateString("e_localAmountCredit", GlUtils.formatNumber(e.getLocalAmount(), lcpre));
                        drs.updateString("e_originalAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                        drs.updateString("r_originalAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_localAmountCredit", GlUtils.formatNumber(e.getOriginalAmount(), lcpre));
                        drs.updateString("r_reportingAmountCredit", GlUtils.formatNumber(e.getReportingAmount(), lcpre));
                    }
                    int page = 0;
                    if (++entryCount % rowLineCount == 0) {
                        page = entryCount / rowLineCount;
                    } else {
                        page = entryCount / rowLineCount + 1;
                        if (entryCount % rowLineCount == 1) {
                            creditTotal = GlUtils.zero;
                            debitTotal = GlUtils.zero;
                        }
                    }
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        debitTotal = debitTotal.add(e.getLocalAmount());
                    } else {
                        creditTotal = creditTotal.add(e.getLocalAmount());
                    }
                    drs.updateString("pageCount", page + "/" + voucherCount);
                    drs.updateString("pageCurrent", page + "");
                    drs.updateString("pageTotal", "" + voucherCount);
                    drs.updateString("bizStatus", this.getBizStatusString(vch.getBizStatus()));
                    drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                    drs.updateString("attachmentsChinese", attachmentsChinese);
                    if (page == voucherCount) {
                        drs.updateString("debitTotal", GlUtils.formatNumber(total[0][0], lcpre));
                        drs.updateString("creditTotal", GlUtils.formatNumber(total[0][1], lcpre));
                        drs.updateString("localAmountDebit", GlUtils.formatNumber(total[0][0], lcpre));
                        drs.updateString("localAmountCredit", GlUtils.formatNumber(total[0][1], lcpre));
                        drs.updateString("reportingAmountDebit", GlUtils.formatNumber(total[0][2], lcpre));
                        drs.updateString("reportingAmountCredit", GlUtils.formatNumber(total[0][3], lcpre));
                        drs.updateString("amountTotalChinese", amountTotalChinese);
                        drs.updateString("amountTotal", amountTotal);
                        drs.updateString("debitTotal_org", GlUtils.formatNumber(total[1][0], lcpre));
                        drs.updateString("creditTotal_org", GlUtils.formatNumber(total[1][1], lcpre));
                        drs.updateString("localAmountDebit_org", GlUtils.formatNumber(total[1][0], lcpre));
                        drs.updateString("localAmountCredit_org", GlUtils.formatNumber(total[1][1], lcpre));
                        drs.updateString("reportingAmountDebit_org", GlUtils.formatNumber(total[1][2], lcpre));
                        drs.updateString("reportingAmountCredit_org", GlUtils.formatNumber(total[1][3], lcpre));
                        drs.updateString("amountTotalChinese_org", amountTotalChineseOrg);
                        drs.updateString("amountTotal_org", amountTotalOrg);
                        drs.updateString("sum", "");
                    } else {
                        drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)debitmap.get(String.valueOf(page)), lcpre));
                        drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)creditmap.get(String.valueOf(page)), lcpre));
                        drs.updateString("sum", subtotal);
                    }
                    if (this.settingInfo.isPrintCashFlow()) {
                        this.provider.printCashflow(drs, e, null, lcpre);
                    }
                    drs.insertRow();
                }
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)"Get rowset error!", (Throwable)ex);
            return null;
        }
        return drs;
    }

    private boolean computerVoucherType(VoucherInfo vch) {
        boolean pnlAccExist = false;
        int count = vch.getEntryCount();
        for (int i = 0; i < count; ++i) {
            AccountViewInfo acc = vch.getEntries().get(i).getAccount();
            if (!AccountProperty.SUNYI.equals((Object)acc.getAccountTypeID().getProperty())) continue;
            pnlAccExist = true;
        }
        return pnlAccExist;
    }

    private VoucherInfo changeVoucher(VoucherInfo vch) {
        VoucherInfo info = new VoucherInfo();
        info.setId(vch.getId());
        info.setNumber(vch.getNumber());
        info.setAttachments(vch.getAttachments());
        info.setBizOU(vch.getBizOU());
        info.setPeriod(vch.getPeriod());
        info.setBizDate(vch.getBizDate());
        info.setBookedDate(vch.getBookedDate());
        info.setCompany(vch.getCompany());
        info.setCreateTime(vch.getCreateTime());
        info.setCreator(vch.getCreator());
        info.setCU(vch.getCU());
        info.setCurrency(vch.getCurrency());
        info.setDescription(vch.getDescription());
        info.setDisplayFormat(vch.getDisplayFormat());
        info.setLocalCreditAmount(vch.getLocalCreditAmount());
        info.setLocalDebitAmount(vch.getLocalDebitAmount());
        info.setReportingCreditAmount(vch.getReportingCreditAmount());
        info.setReportingDebitAmount(vch.getReportingDebitAmount());
        info.setHandler(vch.getHandler());
        info.setAuditor(vch.getAuditor());
        info.setCashier(vch.getCashier());
        info.setCanceller(vch.getCanceller());
        info.setPoster(vch.getPoster());
        info.setHasCashAccount(vch.isHasCashAccount());
        info.setHasEffected(vch.isHasEffected());
        info.setLastUpdateTime(vch.getLastUpdateTime());
        info.setLastUpdateUser(vch.getLastUpdateUser());
        info.setVoucherType(vch.getVoucherType());
        info.setVoucherTypeDetail(vch.getVoucherTypeDetail());
        int infoCount = 0;
        HashMap<String, VoucherEntryInfo> acctMap = new HashMap<String, VoucherEntryInfo>();
        int count = vch.getEntryCount();
        VoucherEntryCollection vchEntryCol = vch.getEntries();
        VoucherEntryCollection infoEntryCol = info.getEntries();
        for (int i = 0; i < count; ++i) {
            VoucherEntryInfo vchEntryInfo = vchEntryCol.get(i);
            VoucherEntryInfo entry = new VoucherEntryInfo();
            entry.setAccount(vchEntryInfo.getAccount());
            entry.setBill(info);
            entry.setId(vchEntryInfo.getId());
            entry.setCurrency(vchEntryInfo.getCurrency());
            entry.setDescription(vchEntryInfo.getDescription());
            entry.setDisplayFormat(vchEntryInfo.getDisplayFormat());
            entry.setEntryDC(vchEntryInfo.getEntryDC());
            entry.setMeasureUnit(vchEntryInfo.getMeasureUnit());
            entry.setOriginalAmount(vchEntryInfo.getOriginalAmount());
            entry.setLocalAmount(vchEntryInfo.getLocalAmount());
            entry.setReportingAmount(vchEntryInfo.getReportingAmount());
            entry.setLocalExchangeRate(vchEntryInfo.getLocalExchangeRate());
            entry.setReportingExchangeRate(vchEntryInfo.getReportingExchangeRate());
            entry.setPrice(vchEntryInfo.getPrice());
            entry.setQuantity(vchEntryInfo.getQuantity());
            entry.setStandardQuantity(vchEntryInfo.getStandardQuantity());
            AccountViewInfo acc = entry.getAccount();
            if (AccountProperty.SUNYI.equals((Object)acc.getAccountTypeID().getProperty())) {
                AccountViewInfo accInfo = null;
                try {
                    BOSUuid accID = acc.getId();
                    ObjectUuidPK objectUUidPK = new ObjectUuidPK(accID);
                    accInfo = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)objectUUidPK);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                String flongnumber = accInfo.getLongNumber();
                String flongname = accInfo.getLongName();
                String fnumber = flongnumber;
                String fname = flongname;
                int index = flongnumber.indexOf("!");
                if (index != -1) {
                    fnumber = flongnumber.substring(0, flongnumber.indexOf("!"));
                    fname = flongname.substring(0, flongname.indexOf("_"));
                }
                acc.setName(fname);
                acc.setNumber(fnumber);
                acc.setLongName(fname);
                acc.setLongNumber(fnumber);
                if (acctMap.containsKey(fnumber)) {
                    VoucherEntryInfo entryInfo = (VoucherEntryInfo)acctMap.get(fnumber);
                    entryInfo.setOriginalAmount(entryInfo.getOriginalAmount().add(entry.getOriginalAmount()));
                    entryInfo.setLocalAmount(entryInfo.getLocalAmount().add(entry.getLocalAmount()));
                    entryInfo.setReportingAmount(entryInfo.getReportingAmount().add(entry.getReportingAmount()));
                    entryInfo.setQuantity(entryInfo.getQuantity().add(entry.getQuantity()));
                    entryInfo.setStandardQuantity(entryInfo.getStandardQuantity().add(entry.getStandardQuantity()));
                    continue;
                }
                entry.setSeq(++infoCount);
                acctMap.put(fnumber, entry);
                continue;
            }
            entry.setSeq(++infoCount);
            infoEntryCol.add(entry);
        }
        info.setEntryCount(infoCount);
        Set set = acctMap.keySet();
        for (String fnumber : set) {
            VoucherEntryInfo entryInfo = (VoucherEntryInfo)acctMap.get(fnumber);
            infoEntryCol.add(entryInfo);
        }
        return info;
    }

    private String getBizStatusString(VoucherStatusEnum item) {
        if (item == null) {
            return "";
        }
        String key = "BizStatus." + item.getValue();
        if (this.enumStr.containsKey(key)) {
            return this.enumStr.get(key);
        }
        String str = item.toString();
        this.enumStr.put(key, str);
        return str;
    }
}

