/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.FeeTypeEnum;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherExpImpException;
import com.kingdee.eas.fi.gl.VoucherIOSparser;
import com.kingdee.eas.fi.gl.VoucherImpExpParam;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.WSVoucherCollection;
import com.kingdee.eas.fi.gl.WSVoucherInfo;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class VoucherTXTSparser
extends VoucherIOSparser {
    private static final String RES_GLAUTOGENERATERESOURCE = "com.kingdee.eas.fi.gl.GLAutoGenerateResource";
    int counts = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map expVoucher(String strFullName, String strFilePath, String strFileName, boolean overide, VoucherImpExpParam filterParam) throws Exception {
        this.info("Export start");
        Map<String, StringBuffer> map = new HashMap();
        StringBuffer areaInfo = new StringBuffer();
        String strPeriodInfoMidTitle = this.getResx(EXP_RES_NAME, "PeriodInfoMid");
        String strPeriodNumberTitle = this.getResx(EXP_RES_NAME, "PeriodNumber");
        String strVoucherTitle = this.getResx(EXP_RES_NAME, "Voucher");
        String strExpOKTitle = this.getResx(EXP_RES_NAME, "ExpOK");
        String strExpNotOKTitle = this.getResx(EXP_RES_NAME, "ExpNotOK");
        String expResult_before = this.getResx(EXP_RES_NAME, "ExpResult_before");
        String expResult_after = this.getResx(EXP_RES_NAME, "ExpResult_after");
        int expCount = 0;
        IGLGeneralFacade facade = GLGeneralFacadeFactory.getRemoteInstance();
        this.info("Get voucher pks ...");
        FilterInfo filter = this.getFilterInfo(filterParam);
        IObjectPK[] pkList = this.getVoucherPkList(filter);
        int size = pkList.length;
        for (int cu = 0; cu < size; cu += 100) {
            this.info("Get vouchers " + cu + "/" + size + " ...");
            VoucherCollection voucherCollection = this.getVoucherPkList(cu, size, pkList, filter);
            this.info("Build txt " + cu + "/" + size + " ...");
            if (cu > 0) {
                overide = false;
            }
            if (voucherCollection == null || voucherCollection.size() <= 0) continue;
            PrintWriter out1 = null;
            PrintWriter out2 = null;
            try {
                out1 = this.getTxtFileOut(overide, strFullName);
                logger.debug((Object)("strFileName...." + strFileName));
                String path = strFilePath + "tempinCF.txt";
                logger.debug((Object)(path + "\t\t" + strFileName));
                out2 = this.getTxtFileOut(overide, path);
                for (int i = 0; i < voucherCollection.size(); ++i) {
                    VoucherInfo tmpVoucher = voucherCollection.get(i);
                    int iPeriodYear = tmpVoucher.getPeriod().getPeriodYear();
                    int iPeriodNumber = tmpVoucher.getPeriod().getPeriodNumber();
                    String strVoucherTypeInfo = null;
                    if (tmpVoucher.getVoucherType() != null && tmpVoucher.getVoucherType().getName() != null) {
                        strVoucherTypeInfo = tmpVoucher.getVoucherType().getName().trim();
                    }
                    String strVoucherNumber = "";
                    if (tmpVoucher.getNumber() != null) {
                        strVoucherNumber = tmpVoucher.getNumber().trim();
                    }
                    String strVoucher = strVoucherTitle + GLResUtil.getRes("sign_colon") + iPeriodYear + strPeriodInfoMidTitle + iPeriodNumber + strPeriodNumberTitle + strVoucherTypeInfo + strVoucherNumber;
                    try {
                        this.chechVoucherAssit(tmpVoucher, filterParam);
                        this.saveSingleVoucher(out1, out2, tmpVoucher, i, facade, filterParam);
                        ++expCount;
                        areaInfo.append(this.getMessageBuffer(strVoucher, strExpOKTitle));
                        continue;
                    }
                    catch (Exception _ex) {
                        logger.error((Object)_ex.getMessage(), (Throwable)_ex);
                        areaInfo.append(this.getMessageBuffer(strVoucher, strExpNotOKTitle));
                        this.info(GlUtils.printStackTrace(_ex));
                        this.core.handUIException((Throwable)_ex);
                    }
                }
            }
            finally {
                map.put("areainfo", areaInfo);
                if (out1 != null) {
                    out1.close();
                }
                if (out2 != null) {
                    out2.close();
                }
            }
            StringBuffer resultInfo = new StringBuffer(expResult_before + expCount + expResult_after);
            map.put("resultinfo", resultInfo);
        }
        if (size == 0) {
            map = this.haveNoVoucher(expResult_before, expResult_after);
        }
        this.info("Export end");
        return map;
    }

    @Override
    public void checkFileValidate(String strFilePath, String strFileName) throws EASBizException {
        BufferedReader in = this.getTxtFileIn(strFilePath + "\\" + strFileName);
        String s = this.readLine(in);
        while (s != null) {
            StringTokenizer st = new StringTokenizer(s, this.token);
            int count = 1;
            while (st.hasMoreElements()) {
                Object str = st.nextElement();
                logger.debug((Object)("count......" + count + "  ..." + str));
                ++count;
            }
            if (count != 69 && count != 67) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.VoucherImpWizardUI.DATE_SIGN_NO_CO"));
                SysUtil.abort();
            }
            this.counts = count - 1;
            s = this.readLine(in);
        }
        try {
            in.close();
        }
        catch (IOException e1) {
            logger.error((Object)e1);
            this.core.handUIException((Throwable)e1);
        }
    }

    @Override
    public void setExtraData(String strFilePath, String strFileName, KDTextField tfVoucherNumberBegin, KDTextField tfVoucherNumberEnd) throws EASBizException {
        BufferedReader in = this.getTxtFileIn(strFilePath + "\\" + strFileName);
        logger.debug((Object)("token......" + this.token));
        String s = this.readLine(in);
        if (s == null) {
            MsgBox.showError((String)GLResUtil.getRes("no_data_for_import"));
            SysUtil.abort();
        }
        String min = null;
        String max = null;
        String[] cols = null;
        while (s != null) {
            cols = this.counts == 68 ? this.getColumns(s, 68) : this.getColumns(s, 66);
            String value = cols[4];
            if (value != null) {
                if (min == null || max == null) {
                    min = value;
                    max = value;
                    continue;
                }
                if (value.compareTo(min) < 0) {
                    min = value;
                }
                if (value.compareTo(max) > 0) {
                    max = value;
                }
            }
            s = this.readLine(in);
        }
        try {
            in.close();
        }
        catch (IOException e) {
            logger.error((Object)e);
            this.core.handUIException((Throwable)e);
        }
        tfVoucherNumberBegin.setText(min == null ? "" : min);
        tfVoucherNumberEnd.setText(max == null ? "" : max);
    }

    @Override
    public Map getExtraData(String strFilePath, String strFileName, VoucherImpExpParam filterParam) throws EASBizException {
        HashMap extraDataMap = new HashMap();
        BufferedReader in = this.getTxtFileIn(strFilePath + "\\" + strFileName);
        boolean isPost = filterParam.isIncludePost();
        boolean isNoPost = filterParam.isIncludeNoPost();
        String numberBegin = filterParam.getINumberBegin();
        String numberEnd = filterParam.getINumberEnd();
        ArrayList<String> list = new ArrayList<String>();
        try {
            String s = in.readLine();
            while (s != null) {
                StringTokenizer st = new StringTokenizer(s, this.token);
                int count = 0;
                String description = null;
                while (st.hasMoreElements()) {
                    description = this.getValue(st.nextElement());
                    if (count == 4 && (numberBegin != null && numberBegin.trim().length() > 0 && description.compareTo(numberBegin.trim()) < 0 || numberEnd != null && numberEnd.trim().length() > 0 && description.compareTo(numberEnd.trim()) > 0)) break;
                    if (count == 20 && description != null) {
                        boolean posted = description.equalsIgnoreCase("true");
                        if (!(isPost && isNoPost || isPost && !isNoPost && !posted) && (isPost || !isNoPost || !posted)) break;
                    }
                    if (count == 23) {
                        list.add(this.getCompany().getNumber() + "&" + description);
                        break;
                    }
                    ++count;
                }
                s = in.readLine();
            }
        }
        catch (IOException e) {
            this.core.handUIException((Throwable)e);
            throw new VoucherExpImpException(VoucherExpImpException.FILE_STRUCTURE_ERROR);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        logger.debug((Object)("list........." + list));
        extraDataMap.put("fserialnoList", list);
        return extraDataMap;
    }

    private WSVoucherCollection getCashFlowMap(boolean isSelectCash, String strPath) throws BOSException, VoucherExpImpException {
        if (!isSelectCash) {
            return null;
        }
        WSVoucherCollection cashs = new WSVoucherCollection();
        WSVoucherInfo wsvoucher = null;
        BufferedReader in = this.getTxtFileIn(strPath);
        String s = this.readLine(in);
        int rows = 0;
        while (s != null) {
            BigDecimal reportamount;
            BigDecimal localamount;
            String[] cols = this.getColumns(s, 14);
            wsvoucher = new WSVoucherInfo();
            wsvoucher.put("lineNum", new Integer(rows + 1));
            wsvoucher.setItemFlag(1);
            String companyNumber = this.getCompany().getNumber();
            wsvoucher.setCompanyNumber(companyNumber);
            java.util.Date voucherDate = this.getColumnOfDateValue(cols[0], rows, 0, true);
            wsvoucher.setBookedDate(voucherDate);
            int periodNum = this.getColumnOfIntValue(cols[1], rows, 1, true);
            wsvoucher.setPeriodNumber(periodNum);
            if (voucherDate != null) {
                wsvoucher.setPeriodYear(voucherDate.getYear() + 1900);
            }
            String voucherTypeNum = cols[2];
            wsvoucher.setVoucherType(voucherTypeNum);
            String vouchernumber = cols[3];
            wsvoucher.setVoucherNumber(vouchernumber);
            String curNumber = cols[4];
            wsvoucher.setCurrencyNumber(curNumber);
            String entryesq = cols[5];
            wsvoucher.setEntrySeq(this.getColumnOfIntValue(entryesq, rows, 5, true));
            String entryoppesq = cols[6];
            wsvoucher.put("cashOppEntrySeq", this.getColumnOfIntValue(entryoppesq, rows, 6, true));
            String primarynumber = cols[7];
            wsvoucher.setPrimaryItem(primarynumber);
            String supplynumber = cols[8];
            wsvoucher.setSupplyItem(supplynumber);
            BigDecimal originalAmount = this.getColumnOfBigDecimalValue(cols[9], rows, 9, false);
            if (originalAmount != null) {
                wsvoucher.setCashflowAmountOriginal(originalAmount.doubleValue());
            }
            if ((localamount = this.getColumnOfBigDecimalValue(cols[10], rows, 10, false)) != null) {
                wsvoucher.setCashflowAmountLocal(localamount.doubleValue());
            }
            if ((reportamount = this.getColumnOfBigDecimalValue(cols[11], rows, 11, false)) != null) {
                wsvoucher.setCashflowAmountRpt(reportamount.doubleValue());
            }
            int primarycoef = this.getColumnOfIntValue(cols[12], rows, 12, false);
            wsvoucher.setPrimaryCoef(primarycoef);
            int supplycoef = this.getColumnOfIntValue(cols[13], rows, 13, false);
            wsvoucher.setSupplyCoef(supplycoef);
            String type = null;
            wsvoucher.setType(type);
            int assistCount = 0;
            for (int k = 0; k < 8; ++k) {
                wsvoucher.put("asstActType" + k, null);
                wsvoucher.put("asstActNumber" + k, null);
                wsvoucher.put("asstActType" + k, null);
            }
            wsvoucher.put("assistCount", new Integer(assistCount));
            cashs.add(wsvoucher);
            ++rows;
            s = this.readLine(in);
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        return cashs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WSVoucherCollection getVchList(String strFullName, VoucherImpExpParam filterParam) throws BOSException, VoucherExpImpException {
        WSVoucherCollection vchs = new WSVoucherCollection();
        WSVoucherInfo wsvoucher = null;
        boolean isPost = filterParam.isIncludePost();
        boolean isNoPost = filterParam.isIncludeNoPost();
        Date begin = filterParam.getDateBegin();
        Date end = filterParam.getDateEnd();
        String numberBegin = filterParam.getINumberBegin();
        String numberEnd = filterParam.getINumberEnd();
        VoucherTypeInfo filteVoucherTypeInfo = filterParam.getVoucherTypeInfo();
        BufferedReader in = null;
        try {
            in = this.getTxtFileIn(strFullName);
            String s = this.readLine(in);
            int i = 0;
            int j = 0;
            boolean isSupAsstUnit = false;
            if (this.counts == 68) {
                i = 1;
                j = 2;
                isSupAsstUnit = true;
            }
            int rows = 0;
            while (s != null) {
                java.util.Date endDate;
                java.util.Date asstBizDate;
                String objSupplier;
                String objCompanyOrgUnit;
                String objMaterial;
                String objHandler;
                String objFeeType;
                String objCustomer;
                String strTicketNumber;
                BigDecimal cAmount;
                BigDecimal dAmount;
                BigDecimal price;
                BigDecimal qty;
                BigDecimal quantity;
                String[] cols = null;
                cols = this.counts == 68 ? this.getColumns(s, 68) : this.getColumns(s, 66);
                boolean posted = cols[20 + i].equalsIgnoreCase("true");
                if (isPost && !isNoPost && !posted || !isPost && isNoPost && posted) {
                    ++rows;
                    s = this.readLine(in);
                    continue;
                }
                wsvoucher = new WSVoucherInfo();
                wsvoucher.put("lineNum", new Integer(i + 1));
                String companyNumber = this.getCompany().getNumber();
                wsvoucher.setCompanyNumber(companyNumber);
                java.util.Date voucherDate = this.getColumnOfDateValue(cols[0], rows, 0, true);
                wsvoucher.setBookedDate(voucherDate);
                if (voucherDate != null && (voucherDate.before(begin) || voucherDate.after(end))) continue;
                java.util.Date bizDate = this.getColumnOfDateValue(cols[1], rows, 0, false);
                if (bizDate == null) {
                    bizDate = voucherDate;
                }
                wsvoucher.setBizDate(bizDate);
                int periodNum = this.getColumnOfIntValue(cols[2], rows, 2, true);
                wsvoucher.setPeriodNumber(periodNum);
                if (voucherDate != null) {
                    wsvoucher.setPeriodYear(voucherDate.getYear() + 1900);
                } else if (bizDate != null) {
                    wsvoucher.setPeriodYear(bizDate.getYear() + 1900);
                }
                String strVoucherTypeInfoName = cols[3];
                wsvoucher.setVoucherType(strVoucherTypeInfoName);
                String vouchernumber = cols[4];
                wsvoucher.setVoucherNumber(vouchernumber);
                if ((numberBegin != null && numberBegin.trim().length() > 0 || numberEnd != null && numberEnd.trim().length() > 0) && (filteVoucherTypeInfo != null && !strVoucherTypeInfoName.equals(filteVoucherTypeInfo.getName()) || numberBegin != null && numberBegin.trim().length() > 0 && vouchernumber.compareTo(numberBegin.trim()) < 0 || numberEnd != null && numberEnd.trim().length() > 0 && vouchernumber.compareTo(numberEnd.trim()) > 0) || filteVoucherTypeInfo != null && !strVoucherTypeInfoName.equals(filteVoucherTypeInfo.getName())) continue;
                int iSeq = this.getColumnOfIntValue(cols[5], rows, 5, true);
                wsvoucher.setEntrySeq(iSeq);
                String voucherAbstract = cols[6];
                wsvoucher.setVoucherAbstract(voucherAbstract);
                String strAccountView = cols[7];
                wsvoucher.setAccountNumber(strAccountView);
                String strCurrenyISOcode = cols[8];
                wsvoucher.setCurrencyNumber(strCurrenyISOcode);
                BigDecimal exchangeRate = this.getColumnOfBigDecimalValue(cols[9], rows, 9, false);
                if (exchangeRate != null) {
                    exchangeRate = exchangeRate.setScale(10, 4);
                    wsvoucher.setLocalRate(exchangeRate.doubleValue());
                }
                int asstDC = this.getColumnOfIntValue(cols[10], rows, 10, true);
                wsvoucher.setEntryDC(asstDC);
                BigDecimal originalAmount = this.getColumnOfBigDecimalValue(cols[11], rows, 11, false);
                if (originalAmount != null) {
                    wsvoucher.setOriginalAmount(originalAmount.doubleValue());
                }
                if ((quantity = this.getColumnOfBigDecimalValue(cols[12], rows, 12, false)) != null) {
                    wsvoucher.setQty(quantity.doubleValue());
                }
                if (isSupAsstUnit && (qty = this.getColumnOfBigDecimalValue(cols[13], rows, 13, false)) != null) {
                    wsvoucher.put("assistQty", qty);
                }
                if ((price = this.getColumnOfBigDecimalValue(cols[13 + i], rows, 13 + i, false)) != null) {
                    wsvoucher.setPrice(price.doubleValue());
                }
                if ((dAmount = this.getColumnOfBigDecimalValue(cols[14 + i], rows, 14 + i, false)) != null) {
                    wsvoucher.setDebitAmount(dAmount.doubleValue());
                }
                if ((cAmount = this.getColumnOfBigDecimalValue(cols[15 + i], rows, 15 + i, false)) != null) {
                    wsvoucher.setCreditAmount(cAmount.doubleValue());
                }
                String strCreator = cols[16 + i];
                wsvoucher.setCreator(strCreator);
                int iAttachments = this.getColumnOfIntValue(cols[19 + i], rows, 19 + i, false);
                wsvoucher.setAttaches(iAttachments);
                wsvoucher.put("module", null);
                wsvoucher.put("deleted", null);
                wsvoucher.put("pingzhengxuhao", cols[23 + i]);
                String strUnitName = cols[24 + i];
                wsvoucher.setMeasurement(strUnitName);
                if (isSupAsstUnit) {
                    String strAssistUnitName = cols[26];
                    wsvoucher.put("assistUnit", strAssistUnitName);
                }
                String description = cols[25 + j];
                wsvoucher.setDescription(description);
                wsvoucher.put("cashflowFlag", null);
                int itemFlag = 0;
                wsvoucher.setItemFlag(itemFlag);
                String bizNumber = cols[28 + j];
                wsvoucher.setBizNumber(bizNumber);
                String objSettleCode = cols[29 + j];
                wsvoucher.setSettlementType(objSettleCode);
                String strSettleNumber = cols[30 + j];
                wsvoucher.setSettlementNumber(strSettleNumber);
                String des = cols[31 + j];
                wsvoucher.put("asstAbstract", des);
                int assistCount = 0;
                int ASSTRow = 31 + j;
                for (int k = 0; k < 8; ++k) {
                    String obj1 = cols[ASSTRow + k * 3 + 1];
                    String obj2 = cols[ASSTRow + k * 3 + 2];
                    String obj3 = cols[ASSTRow + k * 3 + 3];
                    if (!(obj1 != null && !"".equals(obj1) || obj2 != null && !"".equals(obj2) || obj3 != null && !"".equals(obj3))) continue;
                    String strAsstActTypeName = null;
                    if (obj1 != null) {
                        strAsstActTypeName = String.valueOf(obj1);
                        wsvoucher.put("asstActType" + assistCount, strAsstActTypeName);
                    }
                    String strAsstActID = null;
                    if (obj2 != null) {
                        if (obj2 instanceof BigDecimal) {
                            strAsstActID = String.valueOf(obj2);
                            if (strAsstActID.indexOf(46) > 0) {
                                strAsstActID = strAsstActID.substring(0, strAsstActID.lastIndexOf(46));
                            }
                        } else {
                            strAsstActID = obj2;
                        }
                        wsvoucher.put("asstActNumber" + assistCount, strAsstActID);
                    }
                    String strAsstActName = null;
                    if (obj3 != null) {
                        if (obj3 instanceof BigDecimal) {
                            strAsstActName = String.valueOf(obj3);
                            if (strAsstActName.indexOf(46) > 0) {
                                strAsstActName = strAsstActName.substring(0, strAsstActName.lastIndexOf(46));
                            }
                        } else {
                            strAsstActName = obj3;
                        }
                        wsvoucher.put("asstActName" + assistCount, strAsstActName);
                    }
                    ++assistCount;
                }
                wsvoucher.put("assistCount", new Integer(assistCount));
                String strInvoiceNumber = cols[56 + j];
                if (strInvoiceNumber != null) {
                    wsvoucher.setInvoiceNumber(strInvoiceNumber);
                }
                if ((strTicketNumber = cols[57 + j]) != null) {
                    wsvoucher.put("ticketNumber", strTicketNumber.toString());
                }
                if ((objCustomer = cols[58 + j]) != null) {
                    wsvoucher.put("customer", objCustomer);
                }
                if ((objFeeType = cols[59 + j]) != null) {
                    wsvoucher.put("feeType", objFeeType);
                }
                if ((objHandler = cols[60 + j]) != null) {
                    wsvoucher.put("handler", objHandler);
                }
                if ((objMaterial = cols[61 + j]) != null) {
                    wsvoucher.put("material", objMaterial);
                }
                if ((objCompanyOrgUnit = cols[62 + j]) != null) {
                    wsvoucher.put("orgUnit", objCompanyOrgUnit);
                }
                if ((objSupplier = cols[63 + j]) != null) {
                    wsvoucher.put("supplier", objSupplier);
                }
                if ((asstBizDate = this.getColumnOfDateValue(cols[64 + j], rows, 64 + j, false)) != null) {
                    wsvoucher.setAssistBizDate(asstBizDate);
                }
                if ((endDate = this.getColumnOfDateValue(cols[65 + j], rows, 65 + j, false)) == null) {
                    endDate = wsvoucher.getBizDate();
                }
                wsvoucher.setAssistEndDate(endDate);
                vchs.add(wsvoucher);
                ++rows;
                s = this.readLine(in);
            }
            WSVoucherCollection wSVoucherCollection = vchs;
            return wSVoucherCollection;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public IObjectCollection getImpVoucherList(String strFullName, String strPath, String strFileName, VoucherImpExpParam filterParam) throws EASBizException, BOSException {
        WSVoucherCollection vchs = this.getVchList(strFullName, filterParam);
        if (filterParam.isSelectCash()) {
            WSVoucherCollection cashs = this.getCashFlowMap(filterParam.isSelectCash(), filterParam.getCfFilePath());
            vchs.addCollection(cashs);
        }
        return vchs;
    }

    private PrintWriter getTxtFileOut(boolean overide, String srtFileFullname) {
        FileWriter fw;
        block5: {
            File file = new File(srtFileFullname);
            if (overide && file.exists()) {
                file.delete();
            }
            fw = null;
            try {
                fw = new FileWriter(file, !overide);
            }
            catch (IOException e) {
                if (!file.exists()) break block5;
                file.delete();
                try {
                    fw = new FileWriter(file, !overide);
                }
                catch (IOException e1) {
                    logger.error((Object)e1);
                }
            }
        }
        PrintWriter out = new PrintWriter(fw);
        return out;
    }

    private BufferedReader getTxtFileIn(String srtFileFullname) {
        FileReader fr = null;
        try {
            fr = new FileReader(srtFileFullname);
        }
        catch (IOException e) {
            MsgBox.showDetailAndOK((Component)this.core, (String)EASResource.getString((String)RES_GLAUTOGENERATERESOURCE, (String)"1073_VoucherTXTSparser"), (String)e.toString(), (int)0);
            SysUtil.abort();
        }
        BufferedReader in = new BufferedReader(fr);
        return in;
    }

    private void insertVocherRow(PrintWriter out, String[] voucherStr) {
        int len = voucherStr.length;
        StringBuffer voucher = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (voucherStr[i] == null || voucherStr[i].trim().length() == 0) {
                voucherStr[i] = "-";
            }
            voucher.append(voucherStr[i]);
            voucher.append("\t");
            if (i <= 32) continue;
            voucherStr[i] = "-";
        }
        out.println(voucher.toString());
    }

    private void saveSingleVoucher(PrintWriter voucherOut, PrintWriter cashflowOut, VoucherInfo tmpVoucher, int count, IGLGeneralFacade facade, VoucherImpExpParam filterParam) throws EASBizException, BOSException {
        VoucherEntryCollection voucherLines = tmpVoucher.getEntries();
        if (voucherLines == null || voucherLines.size() == 0) {
            return;
        }
        String[] voucherStr = new String[68];
        String[] cashflowStr = new String[14];
        java.util.Date voucherBookDate = tmpVoucher.getBookedDate();
        Calendar now = Calendar.getInstance();
        now.setTime(voucherBookDate);
        String datre = now.get(1) + "-" + (now.get(2) + 1) + "-" + now.get(5);
        voucherStr[0] = String.valueOf(datre);
        cashflowStr[0] = String.valueOf(datre);
        java.util.Date voucherBizDate = tmpVoucher.getBizDate();
        Calendar bizDate = Calendar.getInstance();
        bizDate.setTime(voucherBizDate);
        String bizDateStr = bizDate.get(1) + "-" + (bizDate.get(2) + 1) + "-" + bizDate.get(5);
        voucherStr[1] = String.valueOf(bizDateStr);
        PeriodInfo periodInfo = tmpVoucher.getPeriod();
        int iPeriodNumber = periodInfo.getPeriodNumber();
        voucherStr[2] = String.valueOf(iPeriodNumber);
        cashflowStr[1] = String.valueOf(iPeriodNumber);
        VoucherTypeInfo voucherTypeInfo = tmpVoucher.getVoucherType();
        String strVoucherTypeInfo = "";
        if (voucherTypeInfo != null) {
            voucherStr[3] = strVoucherTypeInfo = voucherTypeInfo.getName().trim();
            cashflowStr[2] = strVoucherTypeInfo;
        }
        String strNumber = tmpVoucher.getNumber();
        logger.debug((Object)strNumber);
        String vchNumber = strNumber;
        if (!filterParam.isRetainOrgNumber()) {
            vchNumber = String.valueOf(count);
        }
        voucherStr[4] = vchNumber;
        cashflowStr[3] = vchNumber;
        UserInfo userPrepare = tmpVoucher.getCreator();
        String strPrepare = null;
        if (userPrepare != null) {
            strPrepare = userPrepare.getNumber().trim();
            voucherStr[17] = String.valueOf(strPrepare);
        }
        UserInfo userPost = tmpVoucher.getPoster();
        String strPoster = null;
        if (userPost != null) {
            strPoster = userPost.getNumber().trim();
            voucherStr[18] = String.valueOf(strPoster);
        }
        UserInfo userCheck = tmpVoucher.getAuditor();
        String strChecker = null;
        if (userCheck != null) {
            strChecker = userCheck.getNumber().trim();
            voucherStr[19] = String.valueOf(strChecker);
        }
        int iAttachement = tmpVoucher.getAttachments();
        voucherStr[20] = String.valueOf(iAttachement);
        VoucherStatusEnum status = tmpVoucher.getBizStatus();
        boolean isPosted = false;
        if (status.getValue() == VoucherStatusEnum.POSTED.getValue()) {
            isPosted = true;
        }
        voucherStr[21] = String.valueOf(isPosted);
        String strModule = "";
        SystemEnum systemEnum = tmpVoucher.getSourceSys();
        SourceType sourceType = tmpVoucher.getSourceType();
        if (sourceType.getValue() != 0 && systemEnum.getValue() != 6 && (strModule = systemEnum.getName()) != null) {
            strModule = strModule.trim();
            voucherStr[22] = String.valueOf(strModule);
        }
        boolean isDeleted = false;
        voucherStr[23] = String.valueOf(isDeleted);
        CashflowFlag flag = tmpVoucher.getCashflowFlag();
        if (flag != null) {
            int caflag = flag.getValue();
            if (caflag == 1) {
                // empty if block
            }
            voucherStr[29] = String.valueOf(caflag);
        }
        String description = tmpVoucher.getDescription();
        String strRefrence = null;
        if (description != null) {
            strRefrence = tmpVoucher.getDescription().trim();
            voucherStr[27] = String.valueOf(strRefrence);
        }
        voucherStr[24] = String.valueOf(System.currentTimeMillis()) + "--" + String.valueOf(count);
        logger.debug((Object)(GLResUtil.getRes("request_export_voucher") + "sheet.." + GLResUtil.getRes("row_voucherEntry") + voucherLines.size()));
        for (int i = 0; i < voucherLines.size(); ++i) {
            String strMeasureUnitInfo;
            MeasureUnitInfo measureUnitInfo;
            String entryDes;
            VoucherEntryInfo voucherEntryInfo = voucherLines.get(i);
            int iEntryNumber = voucherEntryInfo.getSeq();
            voucherStr[5] = String.valueOf(iEntryNumber);
            cashflowStr[5] = String.valueOf(iEntryNumber);
            voucherStr[6] = entryDes = voucherEntryInfo.getDescription();
            AccountViewInfo accountViewInfo = voucherEntryInfo.getAccount();
            String strAccountViewInfo = accountViewInfo.getNumber();
            voucherStr[7] = String.valueOf(strAccountViewInfo);
            CurrencyInfo currencyInfo = voucherEntryInfo.getCurrency();
            String strCurrencyInfo = currencyInfo.getNumber();
            voucherStr[8] = String.valueOf(strCurrencyInfo);
            cashflowStr[4] = String.valueOf(strCurrencyInfo);
            BigDecimal exchangeRate = voucherEntryInfo.getLocalExchangeRate();
            voucherStr[9] = String.valueOf(exchangeRate);
            EntryDC dc = voucherEntryInfo.getEntryDC();
            int iDC = 0;
            if (dc.getValue() == EntryDC.DEBIT.getValue()) {
                iDC = 1;
            }
            voucherStr[10] = String.valueOf(iDC);
            BigDecimal originalAmount = voucherEntryInfo.getOriginalAmount();
            voucherStr[11] = String.valueOf(originalAmount);
            BigDecimal qty = voucherEntryInfo.getQuantity();
            voucherStr[12] = String.valueOf(qty);
            BigDecimal price = voucherEntryInfo.getPrice();
            voucherStr[14] = String.valueOf(price);
            BigDecimal localDebit = SysConstant.BIGZERO;
            BigDecimal localCredit = SysConstant.BIGZERO;
            if (dc.getValue() == EntryDC.DEBIT.getValue()) {
                localDebit = voucherEntryInfo.getLocalAmount();
                voucherStr[15] = String.valueOf(localDebit);
                voucherStr[16] = null;
            } else {
                localCredit = voucherEntryInfo.getLocalAmount();
                voucherStr[16] = String.valueOf(localCredit);
                voucherStr[15] = null;
            }
            if (!filterParam.isQtyByAsst()) {
                measureUnitInfo = voucherEntryInfo.getMeasureUnit();
                strMeasureUnitInfo = null;
                if (measureUnitInfo != null) {
                    strMeasureUnitInfo = measureUnitInfo.getNumber().trim();
                    voucherStr[25] = String.valueOf(strMeasureUnitInfo);
                } else {
                    voucherStr[25] = null;
                }
            }
            CashflowRecordCollection cashFlowRecordCollection = voucherEntryInfo.getCashflowRecords();
            VoucherAssistRecordCollection assitRecordCollection = voucherEntryInfo.getAssistRecords();
            logger.debug((Object)(GLResUtil.getRes("request_row_asstVoucherRecord") + assitRecordCollection.size()));
            voucherStr[30] = null;
            voucherStr[31] = null;
            voucherStr[32] = null;
            voucherStr[33] = null;
            voucherStr[58] = null;
            voucherStr[59] = null;
            voucherStr[60] = null;
            voucherStr[61] = null;
            voucherStr[62] = null;
            voucherStr[63] = null;
            voucherStr[64] = null;
            voucherStr[65] = null;
            voucherStr[66] = null;
            voucherStr[67] = null;
            voucherStr[13] = "0";
            voucherStr[26] = null;
            if (assitRecordCollection != null && assitRecordCollection.size() > 0) {
                for (int j = 0; j < assitRecordCollection.size(); ++j) {
                    FeeTypeEnum feeType;
                    String strTicketNumber;
                    String strInvoiceNumber;
                    String strSettleCode;
                    String strDescripton;
                    voucherStr[30] = null;
                    voucherStr[31] = null;
                    voucherStr[32] = null;
                    voucherStr[33] = null;
                    voucherStr[58] = null;
                    voucherStr[59] = null;
                    voucherStr[60] = null;
                    voucherStr[61] = null;
                    voucherStr[62] = null;
                    voucherStr[63] = null;
                    voucherStr[64] = null;
                    voucherStr[65] = null;
                    voucherStr[66] = null;
                    voucherStr[67] = null;
                    voucherStr[13] = "0";
                    voucherStr[26] = null;
                    VoucherAssistRecordInfo tmpAssistRecordInfo = assitRecordCollection.get(j);
                    originalAmount = tmpAssistRecordInfo.getOriginalAmount();
                    voucherStr[11] = String.valueOf(originalAmount);
                    String strBizNumber = tmpAssistRecordInfo.getBizNumber();
                    if (strBizNumber != null) {
                        voucherStr[30] = strBizNumber = strBizNumber.trim();
                    }
                    if ((strDescripton = tmpAssistRecordInfo.getDescription()) != null) {
                        voucherStr[33] = strDescripton = strDescripton.trim();
                    }
                    SettlementTypeInfo settlementTypeInfo = tmpAssistRecordInfo.getSettlementType();
                    String strSettleTypeInfo = null;
                    if (settlementTypeInfo != null && settlementTypeInfo.getName() != null) {
                        strSettleTypeInfo = settlementTypeInfo.getName().trim();
                        voucherStr[31] = String.valueOf(strSettleTypeInfo);
                    }
                    if ((strSettleCode = tmpAssistRecordInfo.getSettlementCode()) != null) {
                        strSettleCode = strSettleCode.trim();
                        voucherStr[32] = String.valueOf(strSettleCode);
                    }
                    if ((strInvoiceNumber = tmpAssistRecordInfo.getInvoiceNumber()) != null) {
                        voucherStr[58] = strInvoiceNumber = strInvoiceNumber.trim();
                    }
                    if ((strTicketNumber = tmpAssistRecordInfo.getTicketNumber()) != null) {
                        voucherStr[59] = strTicketNumber = strTicketNumber.trim();
                    }
                    CustomerInfo customerInfo = tmpAssistRecordInfo.getCustomer();
                    String strCustomerInfo = null;
                    if (customerInfo != null) {
                        voucherStr[60] = strCustomerInfo = customerInfo.getName().trim();
                    }
                    if ((feeType = tmpAssistRecordInfo.getFeeType()) != null) {
                        voucherStr[61] = String.valueOf(feeType.getValue());
                    }
                    UserInfo handlerInfo = tmpAssistRecordInfo.getHandler();
                    String strHandlerInfo = null;
                    if (handlerInfo != null) {
                        voucherStr[62] = strHandlerInfo = handlerInfo.getNumber().trim();
                    }
                    MaterialInfo materialInfo = tmpAssistRecordInfo.getMaterial();
                    String strMaterialInfo = null;
                    if (materialInfo != null) {
                        voucherStr[63] = strMaterialInfo = materialInfo.getName().trim();
                    }
                    CompanyOrgUnitInfo companyOrgUnitInfo = tmpAssistRecordInfo.getOrgUnit();
                    String strCompanyOrgUnitInfo = null;
                    if (companyOrgUnitInfo != null) {
                        voucherStr[64] = strCompanyOrgUnitInfo = companyOrgUnitInfo.getName().trim();
                    }
                    SupplierInfo supplierInfo = tmpAssistRecordInfo.getSupplier();
                    String strSupplierInfo = null;
                    if (supplierInfo != null) {
                        voucherStr[65] = strSupplierInfo = supplierInfo.getName().trim();
                    }
                    java.util.Date asstBizDate = tmpAssistRecordInfo.getBizDate();
                    voucherStr[66] = this.getDateString(asstBizDate);
                    java.util.Date endDate = tmpAssistRecordInfo.getEndDate();
                    if (endDate == null) {
                        endDate = new java.util.Date();
                    }
                    voucherStr[67] = this.getDateString(endDate);
                    if (filterParam.isQtyByAsst()) {
                        measureUnitInfo = tmpAssistRecordInfo.getMeasureUnit();
                        strMeasureUnitInfo = null;
                        if (measureUnitInfo != null) {
                            strMeasureUnitInfo = measureUnitInfo.getNumber().trim();
                            voucherStr[25] = String.valueOf(strMeasureUnitInfo);
                        } else {
                            voucherStr[25] = null;
                        }
                    }
                    String strAsstMeasureUnitInfo = null;
                    BigDecimal asstQty = new BigDecimal(0);
                    if (filterParam.isQtyByAsst() && accountViewInfo.isIsQty() && filterParam.isUnitByAsst()) {
                        measureUnitInfo = tmpAssistRecordInfo.getAssistUnit();
                        if (measureUnitInfo != null) {
                            strAsstMeasureUnitInfo = measureUnitInfo.getNumber().trim();
                            voucherStr[26] = String.valueOf(strAsstMeasureUnitInfo);
                        } else {
                            voucherStr[26] = null;
                        }
                        if (tmpAssistRecordInfo.getAssistQty() != null) {
                            asstQty = tmpAssistRecordInfo.getAssistQty();
                            voucherStr[13] = String.valueOf(asstQty);
                        } else {
                            voucherStr[13] = String.valueOf(0);
                        }
                    }
                    BigDecimal assLocalDebit = SysConstant.BIGZERO;
                    BigDecimal assLocalCredit = SysConstant.BIGZERO;
                    if (dc.getValue() == EntryDC.DEBIT.getValue()) {
                        assLocalDebit = tmpAssistRecordInfo.getLocalAmount();
                        voucherStr[15] = String.valueOf(assLocalDebit);
                    } else {
                        assLocalCredit = tmpAssistRecordInfo.getLocalAmount();
                        voucherStr[16] = String.valueOf(assLocalCredit);
                    }
                    if (tmpAssistRecordInfo.getAssGrp() != null) {
                        BOSUuid assGrpId = tmpAssistRecordInfo.getAssGrp().getId();
                        HashMap<String, String> key = new HashMap<String, String>();
                        key.put("key", assGrpId.toString());
                        Map result = facade.dealTask("getAsstItem", key);
                        if (result != null) {
                            AsstActTypeCollection col = (AsstActTypeCollection)result.get("value");
                            int count2 = col.size();
                            for (int k = 0; k < count2; ++k) {
                                AsstActTypeInfo data = col.get(k);
                                voucherStr[34 + k * 3] = (String)data.get("asstTypes");
                                voucherStr[35 + k * 3] = (String)data.get("asstItemNumbers");
                                voucherStr[36 + k * 3] = (String)data.get("asstItemNames");
                            }
                        }
                    }
                    this.insertVocherRow(voucherOut, voucherStr);
                }
            } else {
                this.insertVocherRow(voucherOut, voucherStr);
            }
            if (cashFlowRecordCollection == null || cashFlowRecordCollection.size() <= 0) continue;
            for (int l = 0; l < cashFlowRecordCollection.size(); ++l) {
                CashflowRecordInfo cashFlowRecordInfo = cashFlowRecordCollection.get(l);
                cashflowStr[5] = String.valueOf(cashFlowRecordInfo.getEntry().getSeq());
                cashflowStr[6] = String.valueOf(cashFlowRecordInfo.getOpposingAccountEntry().getSeq());
                CashFlowItemInfo primaryCashFlowItemInfo = cashFlowRecordInfo.getPrimaryItem();
                String strPrimaryCashFlowItemInfo = null;
                if (primaryCashFlowItemInfo != null) {
                    strPrimaryCashFlowItemInfo = primaryCashFlowItemInfo.getNumber();
                    cashflowStr[7] = String.valueOf(strPrimaryCashFlowItemInfo);
                }
                CashFlowItemInfo subCashFlowItemInfo = cashFlowRecordInfo.getSupplementaryItem();
                String strSubCashFlowItemInfo = null;
                if (subCashFlowItemInfo != null) {
                    strSubCashFlowItemInfo = subCashFlowItemInfo.getNumber();
                }
                cashflowStr[8] = strSubCashFlowItemInfo;
                BigDecimal cashFlowAmountFor = cashFlowRecordInfo.getOriginalAmount();
                cashflowStr[9] = String.valueOf(cashFlowAmountFor);
                BigDecimal cashFlowAmountLocal = cashFlowRecordInfo.getLocalAmount();
                cashflowStr[10] = String.valueOf(cashFlowAmountLocal);
                cashflowStr[11] = String.valueOf(cashFlowRecordInfo.getReportingAmount());
                cashflowStr[12] = String.valueOf(cashFlowRecordInfo.getPrimaryCoefficient());
                cashflowStr[13] = String.valueOf(cashFlowRecordInfo.getSupplementaryCoefficient());
                this.insertVocherRow(cashflowOut, cashflowStr);
            }
        }
    }

    private String getDateString(java.util.Date voucherBizDate) {
        Calendar bizDate = Calendar.getInstance();
        bizDate.setTime(voucherBizDate);
        String bizDateStr = bizDate.get(1) + "-" + (bizDate.get(2) + 1) + "-" + bizDate.get(5);
        return bizDateStr;
    }

    private String getLineSelectRow(String s, int cols) {
        String strCols = null;
        if (this.token == null) {
            this.token = "\t";
        }
        StringTokenizer st = new StringTokenizer(s, this.token);
        int count = 0;
        while (st.hasMoreElements()) {
            Object obj = st.nextElement();
            if (count == cols) {
                strCols = (String)obj;
                if (!strCols.equals("-")) break;
                strCols = null;
                break;
            }
            ++count;
        }
        logger.debug((Object)("strCols..." + strCols + ";"));
        return strCols;
    }

    private String[] getColumns(String s, int length) {
        String[] cols = new String[length];
        if (this.token == null) {
            this.token = "\t";
        }
        StringTokenizer st = new StringTokenizer(s, this.token);
        int count = 0;
        while (st.hasMoreElements()) {
            String elment = (String)st.nextElement();
            if (!"-".equals(elment.trim())) {
                cols[count] = elment;
            }
            ++count;
        }
        return cols;
    }

    private int getColumnOfIntValue(String s) {
        int colValue = 0;
        if (s != null) {
            colValue = Integer.parseInt(s);
        }
        return colValue;
    }

    private int getColumnOfIntValue(String s, int row, int col, boolean isnull) throws VoucherExpImpException {
        int colValue = 0;
        if (isnull && s == null) {
            s = "";
        }
        if (s != null) {
            try {
                colValue = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                logger.error((Object)"number error:", (Throwable)e);
                String typeAlia = EASResource.getString((String)RES_GLAUTOGENERATERESOURCE, (String)"1040_VoucherXLSSparser");
                throw new VoucherExpImpException(VoucherExpImpException.DATATYPENOTVALID, new Object[]{new Integer(row + 1), new Integer(col + 1), "(" + s + ") " + typeAlia});
            }
        }
        return colValue;
    }

    private BigDecimal getColumnOfBigDecimalValue(String s, int row, int col, boolean isnull) throws VoucherExpImpException {
        BigDecimal colValue = GlUtils.zero;
        if (isnull && s == null) {
            s = "";
        }
        if (s != null) {
            try {
                colValue = new BigDecimal(s);
            }
            catch (Exception e) {
                logger.error((Object)"number error:", (Throwable)e);
                String typeAlia = EASResource.getString((String)RES_GLAUTOGENERATERESOURCE, (String)"1040_VoucherXLSSparser");
                throw new VoucherExpImpException(VoucherExpImpException.DATATYPENOTVALID, new Object[]{new Integer(row + 1), new Integer(col + 1), "(" + s + ") " + typeAlia});
            }
        }
        return colValue;
    }

    private java.util.Date getColumnOfDateValue(String s, int row, int col, boolean isnull) throws VoucherExpImpException {
        java.util.Date colValue = new java.util.Date();
        if (isnull && s == null) {
            s = "";
        }
        if (s != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                colValue = format.parse(s);
            }
            catch (Exception e) {
                logger.error((Object)"number error:", (Throwable)e);
                String typeAlia = EASResource.getString((String)RES_GLAUTOGENERATERESOURCE, (String)"1042_VoucherXLSSparser");
                throw new VoucherExpImpException(VoucherExpImpException.DATATYPENOTVALID, new Object[]{new Integer(row + 1), new Integer(col + 1), "(" + s + ") " + typeAlia});
            }
        }
        return colValue;
    }

    private String readLine(BufferedReader in) throws VoucherExpImpException {
        String s = null;
        try {
            s = in.readLine();
        }
        catch (IOException e) {
            logger.error((Object)"import voucher txt file error:", (Throwable)e);
            this.core.handUIException((Throwable)e);
            throw new VoucherExpImpException(VoucherExpImpException.FILE_STRUCTURE_ERROR);
        }
        return s;
    }

    private String getValue(Object obj) {
        if ("-".equals(obj)) {
            return null;
        }
        return (String)obj;
    }
}

