/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.FeeTypeEnum;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.ImpVoucherStructure;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherExpImpException;
import com.kingdee.eas.fi.gl.VoucherIMPColInfo;
import com.kingdee.eas.fi.gl.VoucherIOSparser;
import com.kingdee.eas.fi.gl.VoucherImpExpParam;
import com.kingdee.eas.fi.gl.VoucherImportUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.VoucherXLSCols;
import com.kingdee.eas.fi.gl.VoucherXLSXParserByEventModel;
import com.kingdee.eas.fi.gl.WSVoucherCollection;
import com.kingdee.eas.fi.gl.WSVoucherInfo;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class VoucherXLSXSparser
extends VoucherIOSparser {
    public static final String EXP_RES_NAME1 = "com.kingdee.eas.fi.gl.VoucherExpWizardByAssistUnitUI";
    public static final String EXP_RES_NAME2 = "com.kingdee.eas.fi.gl.VoucherExpWizardUI";
    private int voucherRows = 0;
    private int cashflowRows = 0;
    private boolean isUnit = false;
    private boolean isCommonVoucher = false;
    private Map<String, AsstActTypeCollection> asstActTypess = new HashMap<String, AsstActTypeCollection>();

    public VoucherXLSXSparser() {
        this.setCashflowRows(1);
        this.setVoucherRows(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map expVoucher(String strFullName, String strFilePath, String strFileName, boolean overide, VoucherImpExpParam filterParam) throws Exception {
        this.info("Export start");
        if (filterParam.isUnitByAsst()) {
            if (!VoucherIOSparser.EXP_RES_NAME.equals(EXP_RES_NAME1)) {
                VoucherIOSparser.EXP_RES_NAME = EXP_RES_NAME1;
            }
            this.isUnit = filterParam.isUnitByAsst();
        } else {
            VoucherIOSparser.EXP_RES_NAME = EXP_RES_NAME2;
        }
        this.isCommonVoucher = filterParam.isCommonVoucher();
        Map<String, StringBuffer> map = new HashMap();
        StringBuffer areaInfo = new StringBuffer();
        String strPeriodInfoMidTitle = this.getResx(EXP_RES_NAME, "PeriodInfoMid");
        String strPeriodNumberTitle = this.getResx(EXP_RES_NAME, "PeriodNumber");
        String strVoucherTitle = this.getResx(EXP_RES_NAME, "Voucher");
        String strExpOKTitle = this.getResx(EXP_RES_NAME, "ExpOK");
        String strExpNotOKTitle = this.getResx(EXP_RES_NAME, "ExpNotOK");
        String expResult_before = this.getResx(EXP_RES_NAME, "ExpResult_before");
        String expResult_after = this.getResx(EXP_RES_NAME, "ExpResult_after");
        int expCount = 0;
        IGLGeneralFacade facade = GLGeneralFacadeFactory.getRemoteInstance();
        Calendar start = Calendar.getInstance();
        FilterInfo filter = this.getFilterInfo(filterParam);
        this.info("Get voucher pks ...");
        IObjectPK[] pkList = this.getVoucherPkList(filter);
        int size = pkList.length;
        Calendar end = Calendar.getInstance();
        logger.debug((Object)("1 " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
        SXSSFWorkbook wb = this.getWorkbook(strFullName, overide, this.isUnit);
        for (int cu = 0; cu < size; cu += 100) {
            this.info("Get vouchers " + cu + "/" + size + " ...");
            VoucherCollection voucherCollection = this.getVoucherPkList(cu, size, pkList, filter);
            this.info("Build excel " + cu + "/" + size + " ...");
            end = Calendar.getInstance();
            logger.debug((Object)("2." + (cu + 1) + " " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
            if (cu > 0) {
                overide = false;
            }
            if (voucherCollection == null || voucherCollection.size() <= 0) continue;
            CellStyle cellStyle = wb.createCellStyle();
            DataFormat fmt = wb.createDataFormat();
            cellStyle.setDataFormat(fmt.getFormat("m/d/yy"));
            CellStyle textCellStyle = wb.createCellStyle();
            DataFormat df = wb.createDataFormat();
            textCellStyle.setDataFormat(df.getFormat("@"));
            try {
                for (int i = 0; i < voucherCollection.size(); ++i) {
                    VoucherInfo tmpVoucher = voucherCollection.get(i);
                    CompanyOrgUnitInfo tmpCompany = GlUtils.getCompanyById(tmpVoucher.getCompany().getId().toString());
                    String companyName = " " + tmpCompany.getName() + " ";
                    end = Calendar.getInstance();
                    logger.debug((Object)("3." + (i + 1) + " " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
                    int iPeriodYear = tmpVoucher.getPeriod().getPeriodYear();
                    int iPeriodNumber = tmpVoucher.getPeriod().getPeriodNumber();
                    String strVoucherTypeInfo = null;
                    if (tmpVoucher.getVoucherType() != null && tmpVoucher.getVoucherType().getName() != null) {
                        strVoucherTypeInfo = tmpVoucher.getVoucherType().getName().trim();
                    }
                    String strVoucherNumber = "";
                    if (tmpVoucher.getNumber() != null) {
                        strVoucherNumber = tmpVoucher.getNumber().trim();
                    }
                    String strVoucher = strVoucherTitle + GLResUtil.getRes("sign_colon") + companyName + iPeriodYear + strPeriodInfoMidTitle + iPeriodNumber + strPeriodNumberTitle + strVoucherTypeInfo + strVoucherNumber;
                    try {
                        this.saveSingleVoucher(wb, tmpVoucher, i, facade, filterParam, cellStyle, textCellStyle);
                        ++expCount;
                        areaInfo.append(this.getMessageBuffer(strVoucher, strExpOKTitle));
                        continue;
                    }
                    catch (Exception _ex) {
                        logger.error((Object)_ex.getMessage(), (Throwable)_ex);
                        areaInfo.append(this.getMessageBuffer(strVoucher, strExpNotOKTitle));
                        this.info(GlUtils.printStackTrace(_ex));
                        this.core.handUIException((Throwable)_ex);
                    }
                }
            }
            finally {
                map.put("areainfo", areaInfo);
            }
            end = Calendar.getInstance();
            logger.debug((Object)("4 " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
            StringBuffer resultInfo = new StringBuffer(expResult_before);
            resultInfo.append(expCount).append(expResult_after);
            map.put("resultinfo", resultInfo);
            end = Calendar.getInstance();
            logger.debug((Object)("5 " + GLResUtil.getRes("use_time") + (end.getTimeInMillis() - start.getTimeInMillis())));
        }
        this.info("Save excel ...");
        this.saveWorkbook(wb, strFullName, overide);
        if (size == 0) {
            map = this.haveNoVoucher(expResult_before, expResult_after);
        }
        this.info("Export end");
        return map;
    }

    @Override
    public void checkFileValidate(String strFilePath, String strFileName) throws EASBizException {
        this.checkByEventModel(strFilePath, strFileName);
    }

    private void checkByEventModel(String strFilePath, String strFileName) throws VoucherExpImpException {
        this.info("Check file ...");
        String fileName = strFilePath + File.separatorChar + strFileName;
        if (!new File(fileName).exists()) {
            throw new VoucherExpImpException(VoucherExpImpException.FILE_EXIST);
        }
        VoucherXLSXParserByEventModel vchEventModel = new VoucherXLSXParserByEventModel(fileName, true, false, "CheckFirstRow");
        vchEventModel.checkTheFirstRow();
        vchEventModel.close();
        this.info("Check file end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkByUserModel(String strFilePath, String strFileName) throws VoucherExpImpException {
        this.info("Check file ...");
        FileInputStream fis = null;
        Object fs = null;
        XSSFWorkbook wb = null;
        try {
            try {
                fis = new FileInputStream(strFilePath + File.separatorChar + strFileName);
                wb = new XSSFWorkbook((InputStream)fis);
            }
            catch (IOException e) {
                this.core.handUIException((Throwable)e);
                throw new VoucherExpImpException(VoucherExpImpException.FIEL_NOT_EXIST);
            }
            XSSFSheet sheet1 = wb.getSheetAt(0);
            XSSFRow hssfRow = sheet1.getRow(0);
            if (hssfRow == null) {
                throw new VoucherExpImpException(VoucherExpImpException.FILE_STRUCTURE_ERROR);
            }
            for (int i = 0; i < 55; i = (int)((short)(i + 1))) {
                XSSFCell cell = hssfRow.getCell(i);
                if (cell != null) continue;
                throw new VoucherExpImpException(VoucherExpImpException.FILE_STRUCTURE_ERROR);
            }
            this.info("Check file end");
        }
        finally {
            try {
                if (wb != null) {
                    wb.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e1) {
                logger.error((Object)e1);
                this.core.handUIException((Throwable)e1);
                throw new VoucherExpImpException(VoucherExpImpException.FILE_EXIST);
            }
        }
    }

    @Override
    public void setExtraData(String strFilePath, String strFileName, KDTextField tfVoucherNumberBegin, KDTextField tfVoucherNumberEnd) throws EASBizException {
        this.setExtraDataByEventModel(strFilePath, strFileName, tfVoucherNumberBegin, tfVoucherNumberEnd);
    }

    private void setExtraDataByEventModel(String strFilePath, String strFileName, KDTextField tfVoucherNumberBegin, KDTextField tfVoucherNumberEnd) throws VoucherExpImpException {
        String fileName = strFilePath + File.separatorChar + strFileName;
        VoucherXLSXParserByEventModel vchEventModel = new VoucherXLSXParserByEventModel(fileName, false, true, "SetExtraData");
        vchEventModel.setExtraData(tfVoucherNumberBegin, tfVoucherNumberEnd);
        vchEventModel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtraDataByUserModel(String strFilePath, String strFileName, KDSpinner spnVoucherNumberBegin, KDSpinner spnVoucherNumberEnd) throws EASBizException {
        FileInputStream fis = null;
        Object fs = null;
        XSSFWorkbook wb = null;
        try {
            Object objCol1;
            try {
                fis = new FileInputStream(strFilePath + File.separatorChar + strFileName);
                wb = new XSSFWorkbook((InputStream)fis);
            }
            catch (IOException e) {
                this.core.handUIException((Throwable)e);
                throw new VoucherExpImpException(VoucherExpImpException.FIEL_NOT_EXIST);
            }
            XSSFSheet sheet1 = wb.getSheetAt(0);
            int size = sheet1.getLastRowNum();
            logger.debug((Object)("size:" + size));
            if (size == 0) {
                MsgBox.showError((String)GLResUtil.getRes("no_data_for_import"));
                SysUtil.abort();
            }
            try {
                objCol1 = this.getCellValue(sheet1.getRow(0), 0, 0, 3);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new VoucherExpImpException(VoucherExpImpException.FILE_STRUCTURE_ERROR);
            }
            boolean isMulTiCompany = VoucherImportUtils.isMultiCompany(objCol1.toString());
            int min = 0;
            int max = 0;
            int i = 1;
            try {
                for (i = 1; i <= size; ++i) {
                    String value;
                    XSSFRow hssfRow = sheet1.getRow(i);
                    if (hssfRow == null || (value = isMulTiCompany ? String.valueOf(this.getCellValue(hssfRow, i, 5, 3)) : String.valueOf(this.getCellValue(hssfRow, i, 4, 3))) == null || value.equalsIgnoreCase("null")) continue;
                    if (value.indexOf(46) > 0) {
                        value = value.substring(0, value.indexOf(46));
                    }
                    int fnum = Integer.parseInt(value);
                    if (i == 1) {
                        min = fnum;
                    }
                    if (fnum < min) {
                        min = fnum;
                    }
                    if (fnum <= max) continue;
                    max = fnum;
                }
            }
            catch (Exception e1) {
                logger.error((Object)e1);
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e12) {
                    this.core.handUIException((Throwable)e12);
                    throw new VoucherExpImpException(VoucherExpImpException.FILE_EXIST);
                }
                return;
            }
            SpinnerNumberModel yearNumberBegin = new SpinnerNumberModel(min, min, max, 1);
            spnVoucherNumberBegin.setModel((SpinnerModel)yearNumberBegin);
            SpinnerNumberModel yearNumberEnd = new SpinnerNumberModel(max, min, max, 1);
            spnVoucherNumberEnd.setModel((SpinnerModel)yearNumberEnd);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e1) {
                this.core.handUIException((Throwable)e1);
                throw new VoucherExpImpException(VoucherExpImpException.FILE_EXIST);
            }
        }
    }

    private WSVoucherCollection getCashFlowMap(XSSFSheet sheetCash, VoucherImpExpParam filterParam) throws Exception {
        if (!filterParam.isSelectCash()) {
            return null;
        }
        WSVoucherCollection cashs = new WSVoucherCollection();
        WSVoucherInfo wsvoucher = null;
        int cashflowSize = sheetCash.getLastRowNum();
        if (sheetCash.getRow(0) == null) {
            throw new VoucherExpImpException(VoucherExpImpException.CASH_NOTITLE);
        }
        Object objCol1 = this.getCellValue(sheetCash.getRow(0), 0, VoucherXLSCols.getCompany());
        boolean isMulTiCompany = VoucherImportUtils.isMultiCompany((String)objCol1);
        VoucherXLSCols cols = new VoucherXLSCols(isMulTiCompany, false, this.isCommonVoucher, 0, 0);
        for (int i = 1; i <= cashflowSize; ++i) {
            BigDecimal rptAmount;
            BigDecimal localAmount;
            XSSFRow hssfRow = sheetCash.getRow(i);
            if (!this.checkCashRowCell(hssfRow, isMulTiCompany, i)) continue;
            wsvoucher = new WSVoucherInfo();
            wsvoucher.put("lineNum", new Integer(i + 1));
            wsvoucher.setItemFlag(1);
            cashs.add(wsvoucher);
            String companyNumber = isMulTiCompany ? (String)this.getCellValue(hssfRow, i, 0, 3) : this.getCompany().getNumber();
            wsvoucher.setCompanyNumber(companyNumber);
            Date voucherDate = this.getCellDate(hssfRow, i, cols.getCashBookedDate().getIndex());
            wsvoucher.setBookedDate(voucherDate);
            int periodNum = 0;
            BigDecimal pNumBig = (BigDecimal)this.getCellValue(hssfRow, i, cols.getCashPeriodNumber());
            if (pNumBig != null) {
                periodNum = pNumBig.intValue();
            }
            wsvoucher.setPeriodNumber(periodNum);
            if (voucherDate != null) {
                wsvoucher.setPeriodYear(voucherDate.getYear() + 1900);
            }
            String strVoucherTypeInfoName = (String)this.getCellValue(hssfRow, i, cols.getCashVoucherType());
            wsvoucher.setVoucherType(strVoucherTypeInfoName);
            String vouchernumber = (String)this.getCellValue(hssfRow, i, cols.getCashVoucherNumber());
            if (vouchernumber != null && vouchernumber.indexOf(46) > 0) {
                vouchernumber = vouchernumber.substring(0, vouchernumber.indexOf(46));
            }
            wsvoucher.setVoucherNumber(vouchernumber);
            String strCurrenyISOcode = (String)this.getCellValue(hssfRow, i, cols.getCashCurrencyNumber());
            wsvoucher.setCurrencyNumber(strCurrenyISOcode);
            int iSeq = this.getCellIntValue(hssfRow, i, cols.getCashEntrySeq());
            wsvoucher.setEntrySeq(iSeq);
            int iOppSeq = this.getCellIntValue(hssfRow, i, cols.getCashOppEntrySeq());
            wsvoucher.put("cashOppEntrySeq", iOppSeq);
            String primarynumber = (String)this.getCellValue(hssfRow, i, cols.getCashPrimaryCashFlowItem());
            wsvoucher.setPrimaryItem(primarynumber);
            String subnumber = (String)this.getCellValue(hssfRow, i, cols.getCashSubCashFlowItem());
            wsvoucher.setSupplyItem(subnumber);
            BigDecimal originalAmount = (BigDecimal)this.getCellValue(hssfRow, i, cols.getCashOriginalAmount());
            if (originalAmount != null) {
                wsvoucher.setCashflowAmountOriginal(originalAmount.doubleValue());
            }
            if ((localAmount = (BigDecimal)this.getCellValue(hssfRow, i, cols.getCashLocalAmount())) != null) {
                wsvoucher.setCashflowAmountLocal(localAmount.doubleValue());
            }
            if ((rptAmount = (BigDecimal)this.getCellValue(hssfRow, i, cols.getCashRptAmount())) != null) {
                wsvoucher.setCashflowAmountRpt(rptAmount.doubleValue());
            }
            int primarycoef = this.getCellIntValue(hssfRow, i, cols.getCashPrimaryCoefficient());
            wsvoucher.setPrimaryCoef(primarycoef);
            int supplycoef = this.getCellIntValue(hssfRow, i, cols.getCashSupCoefficient());
            wsvoucher.setSupplyCoef(supplycoef);
            String type = (String)this.getCellValue(hssfRow, i, cols.getCashType());
            wsvoucher.setType(type);
            int assistCount = 0;
            for (int k = 0; k < 8; ++k) {
                Object obj1 = this.getCellValue(hssfRow, i, cols.getCashAsstActTypeX(k));
                Object obj2 = this.getCellValue(hssfRow, i, cols.getCashAsstActNumberX(k));
                Object obj3 = this.getCellValue(hssfRow, i, cols.getCashAsstActNameX(k));
                if (!(obj1 != null && !"".equals(obj1) || obj2 != null && !"".equals(obj2) || obj3 != null && !"".equals(obj3))) continue;
                String strAsstActTypeName = null;
                if (obj1 != null) {
                    strAsstActTypeName = String.valueOf(obj1);
                    wsvoucher.put("asstActType" + assistCount, strAsstActTypeName);
                }
                String strAsstActID = null;
                if (obj2 != null) {
                    if (obj2 instanceof BigDecimal) {
                        strAsstActID = String.valueOf(obj2);
                        if (strAsstActID.indexOf(46) > 0) {
                            strAsstActID = strAsstActID.substring(0, strAsstActID.lastIndexOf(46));
                        }
                    } else {
                        strAsstActID = (String)obj2;
                    }
                    wsvoucher.put("asstActNumber" + assistCount, strAsstActID);
                }
                String strAsstActName = null;
                if (obj3 != null) {
                    if (obj3 instanceof BigDecimal) {
                        strAsstActName = String.valueOf(obj3);
                        if (strAsstActName.indexOf(46) > 0) {
                            strAsstActName = strAsstActName.substring(0, strAsstActName.lastIndexOf(46));
                        }
                    } else {
                        strAsstActName = (String)obj3;
                    }
                    wsvoucher.put("asstActName" + assistCount, strAsstActName);
                }
                ++assistCount;
            }
            wsvoucher.put("assistCount", new Integer(assistCount));
        }
        return cashs;
    }

    private boolean checkCashRowCell(XSSFRow hssfRow, boolean isMulTiCompany, int row) throws Exception {
        if (hssfRow == null) {
            return false;
        }
        boolean isNullRow = true;
        int count = hssfRow.getLastCellNum();
        for (int col = 1; col <= count; ++col) {
            if (this.getCellValueold(hssfRow, col) == null || this.getCellValueold(hssfRow, col).toString().trim().length() == 0) continue;
            isNullRow = false;
            break;
        }
        return !isNullRow;
    }

    private boolean checkRowCell(XSSFRow hssfRow, boolean isMulTiCompany, int row) throws Exception {
        if (hssfRow == null) {
            return false;
        }
        boolean isNullRow = true;
        int count = hssfRow.getLastCellNum();
        for (int col = 1; col <= count; ++col) {
            if (this.getCellValueold(hssfRow, col) == null || this.getCellValueold(hssfRow, col).toString().trim().length() == 0) continue;
            isNullRow = false;
            break;
        }
        if (isNullRow) {
            return false;
        }
        boolean isBlank = true;
        int countOne = -1;
        countOne = isMulTiCompany ? 51 : 50;
        for (int j = 0; j < countOne; ++j) {
            if (this.getCellValue(hssfRow, row, j, 2) == null) continue;
            isBlank = false;
            break;
        }
        return !isBlank;
    }

    @Override
    public IObjectCollection getImpVoucherList(String strFullName, String strFilePath, String strFileName, VoucherImpExpParam filterParam) throws Exception {
        return this.getVchListByEventModel(strFilePath, strFileName, filterParam);
    }

    private IObjectCollection getVchListByEventModel(String strFilePath, String strFileName, VoucherImpExpParam filterParam) throws Exception {
        String file = strFilePath + File.separatorChar + strFileName;
        this.info("Read file ...");
        VoucherXLSXParserByEventModel vchEventModel = new VoucherXLSXParserByEventModel(this, filterParam, file, false, "GetVoucherInfo");
        WSVoucherCollection vchs = vchEventModel.getVchList();
        vchEventModel.close();
        if (filterParam.isSelectCash()) {
            this.info("Parse file cash ...");
            vchEventModel = new VoucherXLSXParserByEventModel(this, filterParam, file, false, "GetVoucherCashFlowInfo");
            WSVoucherCollection cashs = vchEventModel.getCashFlowList();
            vchEventModel.close();
            vchs.addCollection(cashs);
        }
        this.info("Read file end...");
        return vchs;
    }

    private IObjectCollection getImpVoucherListByUserModel(String strFilePath, String strFileName, VoucherImpExpParam filterParam) throws VoucherExpImpException {
        FileInputStream fis = null;
        Object fs = null;
        XSSFWorkbook wb = null;
        XSSFSheet sheetCash = null;
        try {
            this.info("Read file ...");
            fis = new FileInputStream(strFilePath + File.separatorChar + strFileName);
            wb = new XSSFWorkbook((InputStream)fis);
            sheetCash = wb.getSheetAt(1);
            XSSFSheet vchSheet = wb.getSheetAt(0);
            WSVoucherCollection vchs = this.getVchList(vchSheet, filterParam);
            if (filterParam.isSelectCash()) {
                this.info("Parse file cash ...");
                WSVoucherCollection cashs = this.getCashFlowMap(sheetCash, filterParam);
                vchs.addCollection(cashs);
            }
            WSVoucherCollection wSVoucherCollection = vchs;
            return wSVoucherCollection;
        }
        catch (IOException e) {
            logger.error((Object)"read excel error:", (Throwable)e);
            this.core.handUIException((Throwable)e);
            throw new VoucherExpImpException(VoucherExpImpException.FIEL_NOT_EXIST);
        }
        catch (VoucherExpImpException e) {
            logger.error((Object)"read excel error:", (Throwable)((Object)e));
            throw e;
        }
        catch (Exception ex) {
            logger.error((Object)"read excel error:", (Throwable)ex);
            throw new VoucherExpImpException(VoucherExpImpException.CASHFLOW_NOT_PAGE);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e1) {
                logger.error((Object)"read excel error:", (Throwable)e1);
                this.core.handUIException((Throwable)e1);
                throw new VoucherExpImpException(VoucherExpImpException.FILE_EXIST);
            }
        }
    }

    private WSVoucherCollection getVchList(XSSFSheet sheet1, VoucherImpExpParam filterParam) throws Exception, VoucherExpImpException {
        boolean isSupAsstUnit;
        WSVoucherCollection vchs = new WSVoucherCollection();
        java.sql.Date begin = filterParam.getDateBegin();
        java.sql.Date end = filterParam.getDateEnd();
        boolean isPost = filterParam.isIncludePost();
        boolean isNoPost = filterParam.isIncludeNoPost();
        boolean isChkHalfInivableSaveVoucher = filterParam.isChkHalfInviableSaveVoucher();
        boolean isMulTiCompany = false;
        boolean commonVoucherProcess = this.isCommonVoucher;
        Object objCol1 = this.getCellValue(sheet1.getRow(0), 0, VoucherXLSCols.getCompany());
        if (objCol1 != null) {
            isMulTiCompany = VoucherImportUtils.isMultiCompany(objCol1.toString());
        }
        int index = 0;
        if (commonVoucherProcess) {
            index = 1;
        }
        XSSFRow hssfRow0 = sheet1.getRow(0);
        int next = VoucherXLSXSparser.profitCenterNext(hssfRow0, isMulTiCompany, commonVoucherProcess);
        boolean xlsHasProfitCenter = VoucherXLSXSparser.xlsHasProfitCenter(hssfRow0, isMulTiCompany);
        int allCellCount = sheet1.getRow(0).getPhysicalNumberOfCells();
        if (allCellCount >= 68 + (index += next)) {
            isSupAsstUnit = true;
            VoucherIOSparser.EXP_RES_NAME = EXP_RES_NAME1;
        } else {
            isSupAsstUnit = false;
            VoucherIOSparser.EXP_RES_NAME = EXP_RES_NAME2;
        }
        VoucherXLSCols cols = new VoucherXLSCols(isMulTiCompany, isSupAsstUnit, commonVoucherProcess, next, 0);
        int size = sheet1.getLastRowNum();
        WSVoucherInfo wsvoucher = null;
        boolean errorNumberCount = false;
        for (int i = 1; i <= size; ++i) {
            Date asstBizDate;
            Object objSupplier;
            Object objCompanyOrgUnit;
            Object objMaterial;
            Object objHandler;
            Object objFeeType;
            Object objCustomer;
            Object strTicketNumber;
            BigDecimal cAmount;
            BigDecimal dAmount;
            BigDecimal price;
            BigDecimal qty;
            BigDecimal quantity;
            XSSFRow hssfRow;
            if ((i - 1) % 500 == 0) {
                this.info("Parse file row " + i + "/" + size + "...");
            }
            if (!this.checkRowCell(hssfRow = sheet1.getRow(i), isMulTiCompany, i)) continue;
            boolean posted = false;
            VoucherIMPColInfo col = cols.getPosted();
            Object obj = this.getCellValue(hssfRow, i, col.getIndex(), 1);
            if (obj instanceof String) {
                if (obj != null) {
                    posted = Boolean.valueOf((String)obj);
                }
            } else {
                Boolean postedB = (Boolean)this.getCellValue(hssfRow, i, col);
                if (postedB != null) {
                    posted = postedB;
                }
            }
            if (isPost && !isNoPost && !posted || !isPost && isNoPost && posted) continue;
            wsvoucher = new WSVoucherInfo();
            wsvoucher.put("lineNum", new Integer(i + 1));
            String companyNumber = isMulTiCompany ? (String)this.getCellValue(hssfRow, i, 0, 3) : this.getCompany().getNumber();
            wsvoucher.setCompanyNumber(companyNumber);
            Date voucherDate = this.getCellDate(hssfRow, i, cols.getBookedDate().getIndex());
            wsvoucher.setBookedDate(voucherDate);
            if (voucherDate != null && (voucherDate.before(begin) || voucherDate.after(end))) continue;
            Date bizDate = this.getCellDate(hssfRow, i, cols.getBizDate().getIndex());
            if (bizDate == null && isChkHalfInivableSaveVoucher) {
                bizDate = voucherDate;
            }
            wsvoucher.setBizDate(bizDate);
            int periodNum = 0;
            BigDecimal pNumBig = (BigDecimal)this.getCellValue(hssfRow, i, cols.getPeriodNumber());
            if (pNumBig != null) {
                periodNum = pNumBig.intValue();
            }
            wsvoucher.setPeriodNumber(periodNum);
            if (voucherDate != null) {
                wsvoucher.setPeriodYear(voucherDate.getYear() + 1900);
            } else if (bizDate != null) {
                wsvoucher.setPeriodYear(bizDate.getYear() + 1900);
            }
            String strVoucherTypeInfoName = (String)this.getCellValue(hssfRow, i, cols.getVoucherType());
            wsvoucher.setVoucherType(strVoucherTypeInfoName);
            String vouchernumber = (String)this.getCellValue(hssfRow, i, cols.getVoucherNumber());
            if (vouchernumber != null && vouchernumber.indexOf(46) > 0) {
                vouchernumber = vouchernumber.substring(0, vouchernumber.indexOf(46));
            }
            wsvoucher.setVoucherNumber(vouchernumber);
            String numberBegin = filterParam.getINumberBegin();
            String numberEnd = filterParam.getINumberEnd();
            VoucherTypeInfo filteVoucherTypeInfo = filterParam.getVoucherTypeInfo();
            if ((numberBegin != null && numberBegin.trim().length() > 0 || numberEnd != null && numberEnd.trim().length() > 0) && (filteVoucherTypeInfo != null && !strVoucherTypeInfoName.equals(filteVoucherTypeInfo.getName()) || numberBegin != null && numberBegin.trim().length() > 0 && vouchernumber.compareTo(numberBegin.trim()) < 0 || numberEnd != null && numberEnd.trim().length() > 0 && vouchernumber.compareTo(numberEnd.trim()) > 0) || filteVoucherTypeInfo != null && !strVoucherTypeInfoName.equals(filteVoucherTypeInfo.getName())) continue;
            int iSeq = this.getCellIntValue(hssfRow, i, cols.getEntrySeq());
            wsvoucher.setEntrySeq(iSeq);
            String voucherAbstract = (String)this.getCellValue(hssfRow, i, cols.getVoucherAbstract());
            wsvoucher.setVoucherAbstract(voucherAbstract);
            if (commonVoucherProcess && xlsHasProfitCenter) {
                String profitCenterNumber = (String)this.getCellValue(hssfRow, i, cols.getProfitCenterNumber());
                wsvoucher.setProfitCenterNumber(profitCenterNumber);
            }
            String strAccountView = null;
            obj = this.getCellValue(hssfRow, i, cols.getAccountNumber());
            if (obj != null) {
                if (obj instanceof BigDecimal) {
                    strAccountView = String.valueOf(obj);
                    if (strAccountView.indexOf(46) > 0) {
                        strAccountView = strAccountView.substring(0, strAccountView.lastIndexOf(46));
                    }
                } else {
                    strAccountView = String.valueOf(obj);
                }
            }
            wsvoucher.setAccountNumber(strAccountView);
            String strCurrenyISOcode = (String)this.getCellValue(hssfRow, i, cols.getCurrencyNumber());
            wsvoucher.setCurrencyNumber(strCurrenyISOcode);
            BigDecimal exchangeRate = (BigDecimal)this.getCellValue(hssfRow, i, cols.getLocalRate());
            if (exchangeRate != null) {
                exchangeRate = exchangeRate.setScale(10, 4);
                wsvoucher.setLocalRate(exchangeRate.doubleValue());
            }
            int asstDC = this.getCellIntValue(hssfRow, i, cols.getEntryDC());
            wsvoucher.setEntryDC(asstDC);
            BigDecimal originalAmount = (BigDecimal)this.getCellValue(hssfRow, i, cols.getOriginalAmount());
            if (originalAmount != null) {
                wsvoucher.setOriginalAmount(originalAmount.doubleValue());
            }
            if ((quantity = (BigDecimal)this.getCellValue(hssfRow, i, cols.getQty())) != null) {
                wsvoucher.setQty(quantity.doubleValue());
            } else {
                wsvoucher.setQty(GlUtils.zero.doubleValue());
            }
            if (isSupAsstUnit && (qty = (BigDecimal)this.getCellValue(hssfRow, i, cols.getAsstQty())) != null) {
                wsvoucher.put("assistQty", qty);
            }
            if ((price = (BigDecimal)this.getCellValue(hssfRow, i, cols.getPrice())) != null) {
                wsvoucher.setPrice(price.doubleValue());
            }
            if ((dAmount = (BigDecimal)this.getCellValue(hssfRow, i, cols.getDebitAmount())) != null) {
                wsvoucher.setDebitAmount(dAmount.doubleValue());
            }
            if ((cAmount = (BigDecimal)this.getCellValue(hssfRow, i, cols.getCreditAmount())) != null) {
                wsvoucher.setCreditAmount(cAmount.doubleValue());
            }
            String strCreator = (String)this.getCellValue(hssfRow, i, cols.getCreator());
            wsvoucher.setCreator(strCreator);
            String strPoster = (String)this.getCellValue(hssfRow, i, cols.getPoster());
            wsvoucher.put("poster", strPoster);
            String strAuditer = (String)this.getCellValue(hssfRow, i, cols.getAuditer());
            wsvoucher.put("auditer", strAuditer);
            int iAttachments = 0;
            BigDecimal attachBig = (BigDecimal)this.getCellValue(hssfRow, i, cols.getAttaches());
            if (attachBig != null && attachBig.intValue() > 0) {
                iAttachments = attachBig.intValue();
            }
            wsvoucher.setAttaches(iAttachments);
            String strModle = (String)this.getCellValue(hssfRow, i, cols.getModule());
            wsvoucher.put("module", strModle);
            wsvoucher.put("deleted", null);
            String strVno = (String)this.getCellValue(hssfRow, i, cols.getPingzhengxuhao());
            wsvoucher.put("pingzhengxuhao", strVno);
            String strUnitName = (String)this.getCellValue(hssfRow, i, cols.getMeasurement());
            wsvoucher.setMeasurement(strUnitName);
            if (isSupAsstUnit) {
                String strAssistUnitName = (String)this.getCellValue(hssfRow, i, cols.getAssistUnit());
                wsvoucher.put("assistUnit", strAssistUnitName);
            }
            String description = (String)this.getCellValue(hssfRow, i, cols.getDescription());
            wsvoucher.setDescription(description);
            wsvoucher.put("cashflowFlag", null);
            int itemFlag = 0;
            wsvoucher.setItemFlag(itemFlag);
            String bizNumber = (String)this.getCellValue(hssfRow, i, cols.getBizNumber());
            wsvoucher.setBizNumber(bizNumber);
            String objSettleCode = (String)this.getCellValue(hssfRow, i, cols.getSettlementType());
            wsvoucher.setSettlementType(objSettleCode);
            String strSettleNumber = (String)this.getCellValue(hssfRow, i, cols.getSettlementNumber());
            wsvoucher.setSettlementNumber(strSettleNumber);
            String des = (String)this.getCellValue(hssfRow, i, cols.getAsstAbstract());
            wsvoucher.put("asstAbstract", des);
            int assistCount = 0;
            for (int k = 0; k < 8; ++k) {
                Object obj1 = this.getCellValue(hssfRow, i, cols.getAsstActTypeX(k));
                Object obj2 = this.getCellValue(hssfRow, i, cols.getAsstActNumberX(k));
                Object obj3 = this.getCellValue(hssfRow, i, cols.getAsstActNameX(k));
                if (!(obj1 != null && !"".equals(obj1) || obj2 != null && !"".equals(obj2) || obj3 != null && !"".equals(obj3))) continue;
                String strAsstActTypeName = null;
                if (obj1 != null) {
                    strAsstActTypeName = String.valueOf(obj1);
                    wsvoucher.put("asstActType" + assistCount, strAsstActTypeName);
                }
                String strAsstActID = null;
                if (obj2 != null) {
                    if (obj2 instanceof BigDecimal) {
                        strAsstActID = String.valueOf(obj2);
                        if (strAsstActID.indexOf(46) > 0) {
                            strAsstActID = strAsstActID.substring(0, strAsstActID.lastIndexOf(46));
                        }
                    } else {
                        strAsstActID = (String)obj2;
                    }
                    wsvoucher.put("asstActNumber" + assistCount, strAsstActID);
                }
                String strAsstActName = null;
                if (obj3 != null) {
                    if (obj3 instanceof BigDecimal) {
                        strAsstActName = String.valueOf(obj3);
                        if (strAsstActName.indexOf(46) > 0) {
                            strAsstActName = strAsstActName.substring(0, strAsstActName.lastIndexOf(46));
                        }
                    } else {
                        strAsstActName = (String)obj3;
                    }
                    wsvoucher.put("asstActName" + assistCount, strAsstActName);
                }
                ++assistCount;
            }
            wsvoucher.put("assistCount", new Integer(assistCount));
            Object strInvoiceNumber = this.getCellValue(hssfRow, i, cols.getInvoiceNumber());
            if (strInvoiceNumber != null) {
                wsvoucher.setInvoiceNumber(strInvoiceNumber.toString());
            }
            if ((strTicketNumber = this.getCellValue(hssfRow, i, cols.getTicketNumber())) != null) {
                wsvoucher.put("ticketNumber", strTicketNumber.toString());
            }
            if ((objCustomer = this.getCellValue(hssfRow, i, cols.getCustomer())) != null) {
                wsvoucher.put("customer", objCustomer.toString());
            }
            if ((objFeeType = this.getCellValue(hssfRow, i, cols.getFeeType())) != null) {
                wsvoucher.put("feeType", objFeeType.toString());
            }
            if ((objHandler = this.getCellValue(hssfRow, i, cols.getHandler())) != null) {
                wsvoucher.put("handler", objHandler.toString());
            }
            if ((objMaterial = this.getCellValue(hssfRow, i, cols.getMaterial())) != null) {
                wsvoucher.put("material", objMaterial.toString());
            }
            if ((objCompanyOrgUnit = this.getCellValue(hssfRow, i, cols.getOrgUnit())) != null) {
                wsvoucher.put("orgUnit", objCompanyOrgUnit.toString());
            }
            if ((objSupplier = this.getCellValue(hssfRow, i, cols.getSupplier())) != null) {
                wsvoucher.put("supplier", objSupplier.toString());
            }
            if ((asstBizDate = this.getCellDate(hssfRow, i, cols.getAsstBizDate().getIndex())) != null) {
                wsvoucher.setAssistBizDate(asstBizDate);
            }
            Date endDate = null;
            XSSFCell cell = hssfRow.getCell((int)((short)cols.getEndDate().getIndex()));
            if (cell != null && cell.getCellType().getCode() == 1) {
                String period = cell.getStringCellValue();
                endDate = period.length() > 0 ? this.getCellDate(hssfRow, i, cols.getEndDate().getIndex()) : null;
            } else if (cell != null) {
                endDate = cell.getDateCellValue();
            }
            if (endDate == null) {
                endDate = wsvoucher.getBizDate();
            }
            wsvoucher.setAssistEndDate(endDate);
            vchs.add(wsvoucher);
        }
        return vchs;
    }

    private Date getCellDate(XSSFRow hssfRow, int row, int col) throws VoucherExpImpException {
        XSSFCell cell = hssfRow.getCell((int)((short)col));
        Date bizDate = new Date();
        if (cell != null) {
            if (cell.getCellType().getCode() == 1) {
                String period = cell.getStringCellValue();
                period = period.replace("/", "-");
                SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    bizDate = s.parse(period);
                }
                catch (ParseException e) {
                    logger.error((Object)e);
                    throw new VoucherExpImpException(VoucherExpImpException.DATATYPENOTVALID, new Object[]{new Integer(row + 1), col + 1, ""});
                }
            } else {
                bizDate = cell.getDateCellValue();
            }
            return bizDate;
        }
        return null;
    }

    private void dealWithError(ImpVoucherStructure impVoucher, String INDEX, int iSeq, String error, StringBuffer areaInfo) {
        impVoucher.setBreak(true);
        impVoucher.setBNoWrong(false);
        StringBuffer sb = new StringBuffer(impVoucher.getVoucherInfo().getCompany().getNumber());
        sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1003_VoucherIOSparser"));
        sb.append(INDEX).append(iSeq).append(error);
        String message = sb.toString();
        impVoucher.getLstErrorInfo().add(message);
        areaInfo.append(message);
        areaInfo.append("\r\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getExtraData(String strFilePath, String strFileName, VoucherImpExpParam filterParam) throws Exception {
        HashMap extraDataMap = new HashMap();
        boolean isPost = filterParam.isIncludePost();
        boolean isNoPost = filterParam.isIncludeNoPost();
        String numberBegin = filterParam.getINumberBegin();
        String numberEnd = filterParam.getINumberEnd();
        VoucherTypeInfo filteVoucherTypeInfo = filterParam.getVoucherTypeInfo();
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(strFilePath + File.separatorChar + strFileName);
            }
            catch (FileNotFoundException e2) {
                this.core.handUIException((Throwable)e2);
                logger.error((Object)e2);
                throw new VoucherExpImpException(VoucherExpImpException.FILE_EXIST);
            }
            XSSFWorkbook wb = null;
            try {
                wb = new XSSFWorkbook((InputStream)fis);
            }
            catch (IOException e) {
                this.core.handUIException((Throwable)e);
                logger.error((Object)e);
                throw new VoucherExpImpException(VoucherExpImpException.FIEL_NOT_EXIST);
            }
            ArrayList<String> list = new ArrayList<String>();
            XSSFSheet sheet1 = wb.getSheetAt(0);
            short AllcellCount = sheet1.getRow(0).getLastCellNum();
            int a = 0;
            int b = 0;
            if (AllcellCount >= 69) {
                a = 1;
                b = 2;
                if (!VoucherIOSparser.EXP_RES_NAME.equals(EXP_RES_NAME1)) {
                    VoucherIOSparser.EXP_RES_NAME = EXP_RES_NAME1;
                }
            } else {
                VoucherIOSparser.EXP_RES_NAME = EXP_RES_NAME2;
            }
            int size = sheet1.getLastRowNum();
            logger.debug((Object)("size:" + size));
            String description = null;
            String companyNumber = null;
            String voucherNumber = "";
            String voucherType = null;
            boolean isMulTiCompany = false;
            Object objCol1 = this.getCellValue(sheet1.getRow(0), 0, 0, 3);
            isMulTiCompany = VoucherImportUtils.isMultiCompany(objCol1.toString());
            for (int i = 1; i <= size; ++i) {
                String value3;
                XSSFRow hssfRow = sheet1.getRow(i);
                if (hssfRow == null || this.getCellValue(hssfRow, i, 0, 2) == null) continue;
                if (isMulTiCompany) {
                    companyNumber = (String)this.getCellValue(hssfRow, i, 0, 3);
                    description = String.valueOf(this.getCellValue(hssfRow, i, 24 + a, 3));
                    try {
                        value3 = String.valueOf(this.getCellValue(hssfRow, i, 5, 3));
                        if (value3.indexOf(46) > 0) {
                            value3 = value3.substring(0, value3.indexOf(46));
                        }
                        voucherNumber = value3;
                    }
                    catch (NumberFormatException value2) {
                        // empty catch block
                    }
                    voucherType = String.valueOf(this.getCellValue(hssfRow, i, 4, 3));
                } else {
                    companyNumber = this.getCompany().getNumber();
                    description = String.valueOf(this.getCellValue(hssfRow, i, 23 + a, 3));
                    try {
                        value3 = String.valueOf(this.getCellValue(hssfRow, i, 4, 3));
                        if (value3.indexOf(46) > 0) {
                            value3 = value3.substring(0, value3.indexOf(46));
                        }
                        voucherNumber = value3;
                    }
                    catch (NumberFormatException value3) {
                        // empty catch block
                    }
                    voucherType = String.valueOf(this.getCellValue(hssfRow, i, 3, 3));
                }
                if ((numberBegin != null && numberBegin.trim().length() > 0 || numberEnd != null && numberEnd.trim().length() > 0) && (filteVoucherTypeInfo != null && !voucherType.equals(filteVoucherTypeInfo.getName()) || numberBegin != null && numberBegin.trim().length() > 0 && voucherNumber.compareTo(numberBegin.trim()) < 0 || numberEnd != null && numberEnd.trim().length() > 0 && voucherNumber.compareTo(numberEnd.trim()) > 0) || filteVoucherTypeInfo != null && !voucherType.equals(filteVoucherTypeInfo.getName())) continue;
                XSSFCell cell = hssfRow.getCell(4);
                if (cell != null) {
                    // empty if block
                }
                if (description == null) continue;
                boolean posted = false;
                posted = (Boolean)this.getCellValue(hssfRow, i, 20 + a, 1);
                if (!(isPost && isNoPost || isPost && !isNoPost && !posted) && (isPost || !isNoPost || !posted)) continue;
                list.add(companyNumber + "&" + description);
            }
            logger.debug((Object)("list........." + list));
            extraDataMap.put("fserialnoList", list);
            HashMap hashMap = extraDataMap;
            return hashMap;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e1) {
                this.core.handUIException((Throwable)e1);
                logger.error((Object)e1);
                throw new VoucherExpImpException(VoucherExpImpException.FILE_EXIST);
            }
        }
    }

    public void setCashflowRows(int i) {
        this.cashflowRows = i;
    }

    public void setVoucherRows(int i) {
        this.voucherRows = i;
    }

    private void saveSingleVoucher(SXSSFWorkbook wb, VoucherInfo tmpVoucher, int count, IGLGeneralFacade facade, VoucherImpExpParam filterParam, CellStyle cellStyle, CellStyle textCellStyle) throws BOSException, EASBizException {
        VoucherEntryCollection voucherLines;
        if (filterParam.isUnitByAsst()) {
            if (!VoucherIOSparser.EXP_RES_NAME.equals(EXP_RES_NAME1)) {
                VoucherIOSparser.EXP_RES_NAME = EXP_RES_NAME1;
            }
            this.isUnit = filterParam.isUnitByAsst();
        } else {
            VoucherIOSparser.EXP_RES_NAME = EXP_RES_NAME2;
        }
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        HashMap<String, Object> valueCashMap = new HashMap<String, Object>();
        HashMap<String, Map> asstItemMap = new HashMap<String, Map>();
        int index = 0;
        if (this.isCommonVoucher) {
            index = 1;
        }
        if ((voucherLines = tmpVoucher.getEntries()) == null || voucherLines.size() == 0) {
            return;
        }
        CompanyOrgUnitInfo tmpCompany = GlUtils.getCompanyById(tmpVoucher.getCompany().getId().toString());
        String companyNumber = tmpCompany.getNumber();
        valueMap.put("HSSFCellValue00", companyNumber);
        valueCashMap.put("HSSFCellValueCash00", companyNumber);
        java.sql.Date voucherBookDate = (java.sql.Date)tmpVoucher.getBookedDate();
        valueMap.put("HSSFCellValue0", voucherBookDate);
        valueCashMap.put("HSSFCellValueCash0", voucherBookDate);
        java.sql.Date voucherBizDate = (java.sql.Date)tmpVoucher.getBizDate();
        valueMap.put("HSSFCellValue1", voucherBizDate);
        PeriodInfo periodInfo = tmpVoucher.getPeriod();
        int iPeriodNumber = periodInfo.getPeriodNumber();
        valueMap.put("HSSFCellValue2", new Integer(iPeriodNumber));
        valueCashMap.put("HSSFCellValueCash1", new Integer(iPeriodNumber));
        VoucherTypeInfo voucherTypeInfo = tmpVoucher.getVoucherType();
        String strVoucherTypeInfo = "";
        if (voucherTypeInfo != null) {
            strVoucherTypeInfo = voucherTypeInfo.getName().trim();
            valueMap.put("HSSFCellValue3", strVoucherTypeInfo);
            valueCashMap.put("HSSFCellValueCash2", strVoucherTypeInfo);
        }
        String strNumber = tmpVoucher.getNumber();
        logger.debug((Object)strNumber);
        String vchNumber = strNumber;
        if (!filterParam.isRetainOrgNumber()) {
            vchNumber = String.valueOf(count);
        }
        valueMap.put("HSSFCellValue4", vchNumber);
        valueCashMap.put("HSSFCellValueCash3", vchNumber);
        UserInfo userPrepare = tmpVoucher.getCreator();
        String strPrepare = null;
        if (userPrepare != null) {
            strPrepare = userPrepare.getNumber().trim();
            if (this.isUnit) {
                valueMap.put("HSSFCellValue" + (18 + index), strPrepare);
            } else {
                valueMap.put("HSSFCellValue" + (17 + index), strPrepare);
            }
        }
        UserInfo userPost = tmpVoucher.getPoster();
        String strPoster = null;
        if (userPost != null && userPost.getNumber() != null) {
            strPoster = userPost.getNumber().trim();
            if (this.isUnit) {
                valueMap.put("HSSFCellValue" + (19 + index), strPoster);
            } else {
                valueMap.put("HSSFCellValue" + (18 + index), strPoster);
            }
        }
        UserInfo userCheck = tmpVoucher.getAuditor();
        String strChecker = null;
        if (userCheck != null) {
            strChecker = userCheck.getNumber().trim();
            if (this.isUnit) {
                valueMap.put("HSSFCellValue" + (20 + index), strChecker);
            } else {
                valueMap.put("HSSFCellValue" + (19 + index), strChecker);
            }
        }
        int iAttachement = tmpVoucher.getAttachments();
        if (this.isUnit) {
            valueMap.put("HSSFCellValue" + (21 + index), new Integer(iAttachement));
        } else {
            valueMap.put("HSSFCellValue" + (20 + index), new Integer(iAttachement));
        }
        VoucherStatusEnum status = tmpVoucher.getBizStatus();
        boolean isPosted = false;
        if (status.getValue() == VoucherStatusEnum.POSTED.getValue()) {
            isPosted = true;
        }
        if (this.isUnit) {
            valueMap.put("HSSFCellValue" + (22 + index), isPosted);
        } else {
            valueMap.put("HSSFCellValue" + (21 + index), isPosted);
        }
        String strModule = "";
        SystemEnum systemEnum = tmpVoucher.getSourceSys();
        SourceType sourceType = tmpVoucher.getSourceType();
        if (sourceType.getValue() != 0 && systemEnum.getValue() != 6 && (strModule = systemEnum.getName()) != null) {
            strModule = strModule.trim();
            if (this.isUnit) {
                valueMap.put("HSSFCellValue" + (23 + index), strModule);
            } else {
                valueMap.put("HSSFCellValue" + (22 + index), strModule);
            }
        }
        boolean isDeleted = false;
        if (this.isUnit) {
            valueMap.put("HSSFCellValue" + (24 + index), isDeleted);
        } else {
            valueMap.put("HSSFCellValue" + (23 + index), isDeleted);
        }
        CashflowFlag flag = tmpVoucher.getCashflowFlag();
        if (flag != null) {
            int caflag = flag.getValue();
            if (this.isUnit) {
                valueMap.put("HSSFCellValue" + (30 + index), new Integer(caflag));
            } else {
                valueMap.put("HSSFCellValue" + (28 + index), new Integer(caflag));
            }
        }
        String description = tmpVoucher.getDescription();
        String strRefrence = null;
        if (description != null) {
            strRefrence = tmpVoucher.getDescription().trim();
            if (this.isUnit) {
                valueMap.put("HSSFCellValue" + (28 + index), strRefrence);
            } else {
                valueMap.put("HSSFCellValue" + (26 + index), strRefrence);
            }
        }
        String pingzhengxuhao = String.valueOf(System.currentTimeMillis()) + "--" + count;
        if (this.isUnit) {
            valueMap.put("HSSFCellValue" + (25 + index), pingzhengxuhao);
        } else {
            valueMap.put("HSSFCellValue" + (24 + index), pingzhengxuhao);
        }
        logger.debug((Object)(GLResUtil.getRes("request_export_voucher") + "sheet.." + GLResUtil.getRes("row_voucherEntry") + voucherLines.size()));
        for (int i = 0; i < voucherLines.size(); ++i) {
            String strMeasureUnitInfo;
            MeasureUnitInfo measureUnitInfo;
            VoucherEntryInfo voucherEntryInfo = voucherLines.get(i);
            int iEntryNumber = voucherEntryInfo.getSeq();
            valueMap.put("HSSFCellValue5", String.valueOf(iEntryNumber));
            valueCashMap.put("HSSFCellValueCash5", String.valueOf(iEntryNumber));
            String entryDes = voucherEntryInfo.getDescription();
            valueMap.put("HSSFCellValue6", entryDes);
            ProfitCenterOrgUnitInfo profitCenterOrgUnitInfo = voucherEntryInfo.getProfitCenter();
            String profitCenterNumber = "";
            if (profitCenterOrgUnitInfo != null) {
                profitCenterNumber = profitCenterOrgUnitInfo.getNumber();
            }
            valueMap.put("HSSFCellValue7", profitCenterNumber);
            AccountViewInfo accountViewInfo = voucherEntryInfo.getAccount();
            if (accountViewInfo == null) {
                accountViewInfo = new AccountViewInfo();
            }
            String strAccountViewInfo = "";
            if (accountViewInfo != null) {
                strAccountViewInfo = accountViewInfo.getNumber();
            }
            valueMap.put("HSSFCellValue" + (7 + index), strAccountViewInfo);
            String accountName = accountViewInfo.getName();
            valueMap.put("HSSFCellValue7#2", accountName);
            CurrencyInfo currencyInfo = voucherEntryInfo.getCurrency();
            String strCurrencyInfo = currencyInfo.getNumber();
            valueMap.put("HSSFCellValue" + (9 + index), strCurrencyInfo);
            valueCashMap.put("HSSFCellValueCash4", strCurrencyInfo);
            BigDecimal exchangeRate = voucherEntryInfo.getLocalExchangeRate();
            valueMap.put("HSSFCellValue" + (10 + index), exchangeRate);
            EntryDC dc = voucherEntryInfo.getEntryDC();
            int iDC = 0;
            if (dc.getValue() == EntryDC.DEBIT.getValue()) {
                iDC = 1;
            }
            valueMap.put("HSSFCellValue" + (11 + index), String.valueOf(iDC));
            BigDecimal originalAmount = voucherEntryInfo.getOriginalAmount();
            valueMap.put("HSSFCellValue" + (12 + index), originalAmount);
            BigDecimal qty = voucherEntryInfo.getQuantity();
            valueMap.put("HSSFCellValue" + (13 + index), qty);
            BigDecimal price = voucherEntryInfo.getPrice();
            if (this.isUnit) {
                valueMap.put("HSSFCellValue" + (15 + index), price);
            } else {
                valueMap.put("HSSFCellValue" + (14 + index), price);
            }
            BigDecimal localDebit = SysConstant.BIGZERO;
            BigDecimal localCredit = SysConstant.BIGZERO;
            if (dc.getValue() == EntryDC.DEBIT.getValue()) {
                localDebit = voucherEntryInfo.getLocalAmount();
                if (this.isUnit) {
                    valueMap.put("HSSFCellValue" + (16 + index), localDebit);
                    valueMap.put("HSSFCellValue" + (17 + index), null);
                } else {
                    valueMap.put("HSSFCellValue" + (15 + index), localDebit);
                    valueMap.put("HSSFCellValue" + (16 + index), null);
                }
            } else {
                localCredit = voucherEntryInfo.getLocalAmount();
                if (this.isUnit) {
                    valueMap.put("HSSFCellValue" + (17 + index), localCredit);
                    valueMap.put("HSSFCellValue" + (16 + index), null);
                } else {
                    valueMap.put("HSSFCellValue" + (16 + index), localCredit);
                    valueMap.put("HSSFCellValue" + (15 + index), null);
                }
            }
            if (!filterParam.isQtyByAsst() || accountViewInfo != null && accountViewInfo.getCAA() == null) {
                measureUnitInfo = voucherEntryInfo.getMeasureUnit();
                strMeasureUnitInfo = null;
                if (measureUnitInfo != null) {
                    strMeasureUnitInfo = measureUnitInfo.getNumber().trim();
                    if (this.isUnit) {
                        valueMap.put("HSSFCellValue" + (26 + index), strMeasureUnitInfo);
                    } else {
                        valueMap.put("HSSFCellValue" + (25 + index), strMeasureUnitInfo);
                    }
                } else if (this.isUnit) {
                    valueMap.put("HSSFCellValue" + (26 + index), null);
                } else {
                    valueMap.put("HSSFCellValue" + (25 + index), null);
                }
            }
            CashflowRecordCollection cashFlowRecordCollection = voucherEntryInfo.getCashflowRecords();
            VoucherAssistRecordCollection assitRecordCollection = voucherEntryInfo.getAssistRecords();
            String[] asstTypes = new String[8];
            String[] asstItemNumbers = new String[8];
            String[] asstItemNames = new String[8];
            if (this.isUnit) {
                valueMap.put("HSSFCellValue" + (31 + index), null);
                valueMap.put("HSSFCellValue" + (32 + index), null);
                valueMap.put("HSSFCellValue" + (33 + index), null);
                valueMap.put("HSSFCellValue" + (34 + index), null);
            } else {
                valueMap.put("HSSFCellValue" + (29 + index), null);
                valueMap.put("HSSFCellValue" + (30 + index), null);
                valueMap.put("HSSFCellValue" + (31 + index), null);
                valueMap.put("HSSFCellValue" + (32 + index), null);
            }
            valueMap.put("HSSFCellValue" + (57 + index), null);
            valueMap.put("HSSFCellValue" + (58 + index), null);
            valueMap.put("HSSFCellValue" + (59 + index), null);
            valueMap.put("HSSFCellValue" + (60 + index), null);
            valueMap.put("HSSFCellValue" + (61 + index), null);
            valueMap.put("HSSFCellValue" + (62 + index), null);
            valueMap.put("HSSFCellValue" + (63 + index), null);
            valueMap.put("HSSFCellValue" + (64 + index), null);
            valueMap.put("HSSFCellValue" + (65 + index), null);
            valueMap.put("HSSFCellValue" + (66 + index), null);
            if (assitRecordCollection != null && assitRecordCollection.size() > 0) {
                for (int j = 0; j < assitRecordCollection.size(); ++j) {
                    FeeTypeEnum feeType;
                    String strTicketNumber;
                    BigDecimal assQty;
                    String strSettleCode;
                    String strDescripton;
                    if (j > 0) {
                        asstTypes = new String[8];
                        asstItemNumbers = new String[8];
                        asstItemNames = new String[8];
                    }
                    if (this.isUnit) {
                        valueMap.put("HSSFCellValue" + (31 + index), null);
                        valueMap.put("HSSFCellValue" + (32 + index), null);
                        valueMap.put("HSSFCellValue" + (33 + index), null);
                        valueMap.put("HSSFCellValue" + (34 + index), null);
                    } else {
                        valueMap.put("HSSFCellValue" + (29 + index), null);
                        valueMap.put("HSSFCellValue" + (30 + index), null);
                        valueMap.put("HSSFCellValue" + (31 + index), null);
                        valueMap.put("HSSFCellValue" + (32 + index), null);
                    }
                    VoucherAssistRecordInfo tmpAssistRecordInfo = assitRecordCollection.get(j);
                    originalAmount = tmpAssistRecordInfo.getOriginalAmount();
                    valueMap.put("HSSFCellValue" + (12 + index), originalAmount);
                    String strBizNumber = tmpAssistRecordInfo.getBizNumber();
                    if (strBizNumber != null) {
                        strBizNumber = strBizNumber.trim();
                        if (this.isUnit) {
                            valueMap.put("HSSFCellValue" + (31 + index), strBizNumber);
                        } else {
                            valueMap.put("HSSFCellValue" + (29 + index), strBizNumber);
                        }
                    }
                    if ((strDescripton = tmpAssistRecordInfo.getDescription()) != null) {
                        strDescripton = strDescripton.trim();
                        if (this.isUnit) {
                            valueMap.put("HSSFCellValue" + (34 + index), strDescripton);
                        } else {
                            valueMap.put("HSSFCellValue" + (32 + index), strDescripton);
                        }
                    }
                    SettlementTypeInfo settlementTypeInfo = tmpAssistRecordInfo.getSettlementType();
                    String strSettleTypeInfo = null;
                    if (settlementTypeInfo != null && settlementTypeInfo.getName() != null) {
                        strSettleTypeInfo = settlementTypeInfo.getName().trim();
                        if (this.isUnit) {
                            valueMap.put("HSSFCellValue" + (32 + index), strSettleTypeInfo);
                        } else {
                            valueMap.put("HSSFCellValue" + (30 + index), strSettleTypeInfo);
                        }
                    }
                    if ((strSettleCode = tmpAssistRecordInfo.getSettlementCode()) != null) {
                        strSettleCode = strSettleCode.trim();
                        if (this.isUnit) {
                            valueMap.put("HSSFCellValue" + (33 + index), strSettleCode);
                        } else {
                            valueMap.put("HSSFCellValue" + (31 + index), strSettleCode);
                        }
                    }
                    BigDecimal assLocalDebit = SysConstant.BIGZERO;
                    BigDecimal assLocalCredit = SysConstant.BIGZERO;
                    if (dc.getValue() == EntryDC.DEBIT.getValue()) {
                        assLocalDebit = tmpAssistRecordInfo.getLocalAmount();
                        if (this.isUnit) {
                            valueMap.put("HSSFCellValue" + (16 + index), assLocalDebit);
                        } else {
                            valueMap.put("HSSFCellValue" + (15 + index), assLocalDebit);
                        }
                    } else {
                        assLocalCredit = tmpAssistRecordInfo.getLocalAmount();
                        if (this.isUnit) {
                            valueMap.put("HSSFCellValue" + (17 + index), assLocalCredit);
                        } else {
                            valueMap.put("HSSFCellValue" + (16 + index), assLocalCredit);
                        }
                    }
                    if (filterParam.isQtyByAsst()) {
                        measureUnitInfo = tmpAssistRecordInfo.getMeasureUnit();
                        strMeasureUnitInfo = null;
                        if (measureUnitInfo != null) {
                            strMeasureUnitInfo = measureUnitInfo.getNumber().trim();
                            if (this.isUnit) {
                                valueMap.put("HSSFCellValue" + (26 + index), strMeasureUnitInfo);
                            } else {
                                valueMap.put("HSSFCellValue" + (25 + index), strMeasureUnitInfo);
                            }
                        } else if (this.isUnit) {
                            valueMap.put("HSSFCellValue" + (26 + index), strMeasureUnitInfo);
                        } else {
                            valueMap.put("HSSFCellValue" + (25 + index), strMeasureUnitInfo);
                        }
                        BigDecimal assPrice = tmpAssistRecordInfo.getPrice();
                        if (assPrice != null) {
                            if (this.isUnit) {
                                valueMap.put("HSSFCellValue" + (15 + index), assPrice);
                            } else {
                                valueMap.put("HSSFCellValue" + (14 + index), assPrice);
                            }
                        }
                    }
                    if ((assQty = tmpAssistRecordInfo.getQuantity()) != null) {
                        valueMap.put("HSSFCellValue" + (13 + index), assQty);
                    }
                    if (filterParam.isUnitByAsst() && filterParam.isQtyByAsst()) {
                        measureUnitInfo = tmpAssistRecordInfo.getAssistUnit();
                        strMeasureUnitInfo = null;
                        if (measureUnitInfo != null) {
                            strMeasureUnitInfo = measureUnitInfo.getNumber().trim();
                            valueMap.put("HSSFCellValue" + (27 + index), strMeasureUnitInfo);
                        } else {
                            valueMap.put("HSSFCellValue" + (27 + index), null);
                        }
                        BigDecimal assUnitQty = tmpAssistRecordInfo.getAssistQty();
                        if (assUnitQty != null) {
                            valueMap.put("HSSFCellValue" + (14 + index), assUnitQty);
                        }
                    }
                    if (tmpAssistRecordInfo.getAssGrp() != null) {
                        String assGrpId = tmpAssistRecordInfo.getAssGrp().getId().toString();
                        Map result = null;
                        if (asstItemMap.containsKey(assGrpId)) {
                            result = (Map)asstItemMap.get(assGrpId);
                        } else {
                            HashMap<String, String> key = new HashMap<String, String>();
                            key.put("key", assGrpId);
                            result = facade.dealTask("getAsstItem", key);
                            asstItemMap.put(assGrpId, result);
                        }
                        if (result != null) {
                            AsstActTypeCollection col = (AsstActTypeCollection)result.get("value");
                            int count2 = 0;
                            if (col != null) {
                                count2 = col.size();
                            }
                            for (int k = 0; k < count2; ++k) {
                                AsstActTypeInfo data = col.get(k);
                                asstTypes[k] = (String)data.get("asstTypes");
                                asstItemNumbers[k] = (String)data.get("asstItemNumbers");
                                asstItemNames[k] = (String)data.get("asstItemNames");
                            }
                        }
                    } else if (voucherEntryInfo.getCAA() != null) {
                        AsstActTypeCollection aats = this.getAsstActTypes(voucherEntryInfo.getCAA().getId().toString());
                        int count2 = 0;
                        if (aats != null) {
                            count2 = aats.size();
                        }
                        for (int k = 0; k < count2; ++k) {
                            AsstActTypeInfo data = aats.get(k);
                            asstTypes[k] = data.getName();
                        }
                    }
                    valueMap.put("HSSFCellValueASST1", asstTypes);
                    valueMap.put("HSSFCellValueASST2", asstItemNumbers);
                    valueMap.put("HSSFCellValueASST3", asstItemNames);
                    valueMap.put("HSSFCellValue" + (57 + index), null);
                    valueMap.put("HSSFCellValue" + (58 + index), null);
                    valueMap.put("HSSFCellValue" + (59 + index), null);
                    valueMap.put("HSSFCellValue" + (60 + index), null);
                    valueMap.put("HSSFCellValue" + (61 + index), null);
                    valueMap.put("HSSFCellValue" + (62 + index), null);
                    valueMap.put("HSSFCellValue" + (63 + index), null);
                    valueMap.put("HSSFCellValue" + (64 + index), null);
                    String strInvoiceNumber = tmpAssistRecordInfo.getInvoiceNumber();
                    if (strInvoiceNumber != null) {
                        strInvoiceNumber = strInvoiceNumber.trim();
                        valueMap.put("HSSFCellValue" + (57 + index), strInvoiceNumber);
                    }
                    if ((strTicketNumber = tmpAssistRecordInfo.getTicketNumber()) != null) {
                        strTicketNumber = strTicketNumber.trim();
                        valueMap.put("HSSFCellValue" + (58 + index), strTicketNumber);
                    }
                    CustomerInfo customerInfo = tmpAssistRecordInfo.getCustomer();
                    String strCustomerInfo = null;
                    if (customerInfo != null) {
                        strCustomerInfo = customerInfo.getName().trim();
                        valueMap.put("HSSFCellValue" + (59 + index), strCustomerInfo);
                    }
                    if ((feeType = tmpAssistRecordInfo.getFeeType()) != null) {
                        valueMap.put("HSSFCellValue" + (60 + index), String.valueOf(feeType.getValue()));
                    }
                    UserInfo handlerInfo = tmpAssistRecordInfo.getHandler();
                    String strHandlerInfo = null;
                    if (handlerInfo != null) {
                        strHandlerInfo = handlerInfo.getNumber().trim();
                        valueMap.put("HSSFCellValue" + (61 + index), strHandlerInfo);
                    }
                    MaterialInfo materialInfo = tmpAssistRecordInfo.getMaterial();
                    String strMaterialInfo = null;
                    if (materialInfo != null) {
                        strMaterialInfo = materialInfo.getName().trim();
                        valueMap.put("HSSFCellValue" + (62 + index), strMaterialInfo);
                    }
                    CompanyOrgUnitInfo companyOrgUnitInfo = tmpAssistRecordInfo.getOrgUnit();
                    String strCompanyOrgUnitInfo = null;
                    if (companyOrgUnitInfo != null) {
                        strCompanyOrgUnitInfo = companyOrgUnitInfo.getName().trim();
                        valueMap.put("HSSFCellValue" + (63 + index), strCompanyOrgUnitInfo);
                    }
                    SupplierInfo supplierInfo = tmpAssistRecordInfo.getSupplier();
                    String strSupplierInfo = null;
                    if (supplierInfo != null) {
                        strSupplierInfo = supplierInfo.getName().trim();
                        valueMap.put("HSSFCellValue" + (64 + index), strSupplierInfo);
                    }
                    valueMap.put("HSSFCellValue" + (65 + index), null);
                    valueMap.put("HSSFCellValue" + (66 + index), null);
                    java.sql.Date bizDate = (java.sql.Date)tmpAssistRecordInfo.getBizDate();
                    valueMap.put("HSSFCellValue" + (65 + index), bizDate);
                    if (accountViewInfo != null && accountViewInfo.isAC()) {
                        java.sql.Date endDate = (java.sql.Date)tmpAssistRecordInfo.getEndDate();
                        valueMap.put("HSSFCellValue" + (66 + index), endDate);
                    }
                    this.insertVocherRow(wb, valueMap, cellStyle, textCellStyle);
                }
            } else {
                valueMap.put("HSSFCellValueASST1", asstTypes);
                valueMap.put("HSSFCellValueASST2", asstItemNumbers);
                valueMap.put("HSSFCellValueASST3", asstItemNames);
                this.insertVocherRow(wb, valueMap, cellStyle, textCellStyle);
            }
            SXSSFSheet cashSheet = wb.getSheet(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1039_VoucherXLSSparser"));
            String[] cashAsstTypes = new String[8];
            String[] cashAsstItemNumbers = new String[8];
            String[] cashAsstItemNames = new String[8];
            if (cashFlowRecordCollection == null || cashFlowRecordCollection.size() <= 0) continue;
            for (int l = 0; l < cashFlowRecordCollection.size(); ++l) {
                CashflowRecordInfo cashFlowRecordInfo = cashFlowRecordCollection.get(l);
                if (cashFlowRecordInfo.getAssGrp() != null) {
                    String assGrpId = cashFlowRecordInfo.getAssGrp().getId().toString();
                    Map result = null;
                    if (asstItemMap.containsKey(assGrpId)) {
                        result = (Map)asstItemMap.get(assGrpId);
                    } else {
                        HashMap<String, String> key = new HashMap<String, String>();
                        key.put("key", assGrpId);
                        result = facade.dealTask("getAsstItem", key);
                        asstItemMap.put(assGrpId, result);
                    }
                    if (result != null) {
                        AsstActTypeCollection col = (AsstActTypeCollection)result.get("value");
                        int count2 = 0;
                        if (col != null) {
                            count2 = col.size();
                        }
                        for (int k = 0; k < count2; ++k) {
                            AsstActTypeInfo data = col.get(k);
                            cashAsstTypes[k] = (String)data.get("asstTypes");
                            cashAsstItemNumbers[k] = (String)data.get("asstItemNumbers");
                            cashAsstItemNames[k] = (String)data.get("asstItemNames");
                        }
                    }
                } else {
                    cashAsstTypes = new String[8];
                    cashAsstItemNumbers = new String[8];
                    cashAsstItemNames = new String[8];
                }
                valueCashMap.put("HSSFCellValueASST1", cashAsstTypes);
                valueCashMap.put("HSSFCellValueASST2", cashAsstItemNumbers);
                valueCashMap.put("HSSFCellValueASST3", cashAsstItemNames);
                Row voucherCashRow = cashSheet.createRow(this.cashflowRows++);
                Cell[] cashCell = this.getHSSFCells(voucherCashRow, "HSSFCellValueNumber2", false);
                this.setHSSFCellsValue(wb, cashCell, valueCashMap, "HSSFCellValue", "ASST", cellStyle, textCellStyle);
                valueCashMap.put("HSSFCellValueCash6", String.valueOf(cashFlowRecordInfo.getOpposingAccountEntry().getSeq()));
                valueCashMap.put("HSSFCellValueCash5", String.valueOf(cashFlowRecordInfo.getEntry().getSeq()));
                CashFlowItemInfo primaryCashFlowItemInfo = cashFlowRecordInfo.getPrimaryItem();
                String strPrimaryCashFlowItemInfo = null;
                if (primaryCashFlowItemInfo != null) {
                    strPrimaryCashFlowItemInfo = primaryCashFlowItemInfo.getNumber();
                }
                valueCashMap.put("HSSFCellValueCash7", strPrimaryCashFlowItemInfo);
                CashFlowItemInfo subCashFlowItemInfo = cashFlowRecordInfo.getSupplementaryItem();
                String strSubCashFlowItemInfo = null;
                if (subCashFlowItemInfo != null) {
                    strSubCashFlowItemInfo = subCashFlowItemInfo.getNumber();
                }
                valueCashMap.put("HSSFCellValueCash8", strSubCashFlowItemInfo);
                BigDecimal cashFlowAmountFor = cashFlowRecordInfo.getOriginalAmount();
                valueCashMap.put("HSSFCellValueCash9", cashFlowAmountFor);
                BigDecimal cashFlowAmountLocal = cashFlowRecordInfo.getLocalAmount();
                valueCashMap.put("HSSFCellValueCash10", cashFlowAmountLocal);
                valueCashMap.put("HSSFCellValueCash11", cashFlowRecordInfo.getReportingAmount());
                valueCashMap.put("HSSFCellValueCash12", String.valueOf(cashFlowRecordInfo.getPrimaryCoefficient()));
                valueCashMap.put("HSSFCellValueCash13", String.valueOf(cashFlowRecordInfo.getSupplementaryCoefficient()));
                valueCashMap.put("HSSFCellValueCash14", String.valueOf(cashFlowRecordInfo.getType().toString()));
                this.setHSSFCellsValue(wb, cashCell, valueCashMap, "HSSFCellValue", "Cash", cellStyle, textCellStyle);
            }
        }
    }

    private void insertVocherRow(SXSSFWorkbook wb, Map valueMap, CellStyle cellStyle, CellStyle textCellStyle) throws EASBizException, BOSException {
        SXSSFSheet voucherSheet = wb.getSheet(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI"));
        Row voucherRow = voucherSheet.createRow(this.voucherRows++);
        Cell[] csCell = this.getHSSFCells(voucherRow, "HSSFCellValueNumber1", true);
        this.setHSSFCellsValue(wb, csCell, valueMap, "HSSFCellValue", "ASST", cellStyle, textCellStyle);
    }

    private Cell[] getHSSFCells(Row voucherRow, String strCellValueNumber, boolean isMainSheet) throws EASBizException, BOSException {
        int cellValueNumber = 34;
        if (this.isUnit) {
            cellValueNumber += 2;
        }
        if (this.isCommonVoucher) {
            ++cellValueNumber;
        }
        cellValueNumber = isMainSheet ? (cellValueNumber += 34) : 40;
        Cell[] cells = new Cell[cellValueNumber];
        for (int i = 0; i < cellValueNumber; i = (int)((short)(i + 1))) {
            cells[i] = voucherRow.createCell(i);
        }
        return cells;
    }

    private void setHSSFCellsValue(SXSSFWorkbook wb, Cell[] cells, Map valueMap, String cellValue, String dix, CellStyle cellStyle, CellStyle textCellStyle) throws EASBizException, BOSException {
        String key;
        logger.debug((Object)("....HSSFCell" + cells.length));
        int size = cells.length;
        if ("Cash".equals(dix)) {
            cellValue = cellValue + dix;
        }
        int index = 0;
        if (this.isCommonVoucher) {
            index = 1;
        }
        cells[0].setCellValue((String)valueMap.get(cellValue + "00"));
        for (int i = 1; i < size; ++i) {
            key = "";
            key = i == 9 + index && !"Cash".equals(dix) ? "HSSFCellValue7#2" : cellValue + (i - 1);
            Object value = valueMap.get(key);
            if (value == null) continue;
            if (value instanceof String) {
                if (i >= 56 + index && this.isUnit) {
                    cells[i + 2].setCellValue((String)value);
                } else {
                    cells[i].setCellStyle(textCellStyle);
                    cells[i].setCellValue((String)value);
                }
            }
            if (value instanceof java.sql.Date) {
                if (i >= 64 + index && this.isUnit) {
                    cells[i + 2].setCellValue((Date)((java.sql.Date)value));
                    cells[i + 2].setCellStyle(cellStyle);
                    continue;
                }
                cells[i].setCellValue((Date)((java.sql.Date)value));
                cells[i].setCellStyle(cellStyle);
                continue;
            }
            if (value instanceof Boolean) {
                cells[i].setCellValue(((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                cells[i].setCellValue((double)((Integer)value).intValue());
                continue;
            }
            if (value instanceof Double) {
                cells[i].setCellValue(((Double)value).doubleValue());
                continue;
            }
            if (!(value instanceof BigDecimal)) continue;
            cells[i].setCellValue(((BigDecimal)value).doubleValue());
        }
        int cellValueNumber = 34;
        if (this.isCommonVoucher) {
            ++cellValueNumber;
        }
        if ("ASST".equals(dix)) {
            int i;
            String[] value;
            int k;
            key = cellValue + dix;
            logger.debug((Object)("....key" + key));
            int asstValue = 68;
            if (this.isCommonVoucher) {
                ++asstValue;
            }
            if (this.isUnit) {
                asstValue = 70;
                cellValueNumber = 36;
                if (this.isCommonVoucher) {
                    ++asstValue;
                    ++cellValueNumber;
                }
            }
            if (size == asstValue) {
                for (k = 1; k <= 3; ++k) {
                    value = (String[])valueMap.get(key + k);
                    for (i = 0; i < 8; ++i) {
                        cells[cellValueNumber + i * 3 + k - 1].setCellValue(value[i]);
                    }
                }
            }
            if (size == 40) {
                for (k = 1; k <= 3; ++k) {
                    value = (String[])valueMap.get(key + k);
                    for (i = 0; i < 8; ++i) {
                        cells[16 + i * 3 + k - 1].setCellValue(value[i]);
                    }
                }
            }
        }
    }

    private Object getCellValue(XSSFRow hssfRow, int row, VoucherIMPColInfo col) throws Exception {
        return this.getCellValue(hssfRow, row, col.getIndex(), col.getType());
    }

    private Object getCellValue(XSSFRow hssfRow, int row, int col, int type) throws Exception {
        Object obj = this.getCellValueold(hssfRow, col);
        String typeAlia = "";
        try {
            if (type == 0) {
                if (obj == null || "".equals(obj)) {
                    return null;
                }
                typeAlia = "1040_VoucherXLSSparser";
                obj = new BigDecimal(obj.toString());
            } else if (type == 1) {
                typeAlia = "1041_VoucherXLSSparser";
                if (obj == null || "".equals(obj)) {
                    return null;
                }
                obj = Boolean.valueOf(obj.toString());
            } else if (type == 2) {
                if (obj == null) {
                    return null;
                }
                typeAlia = "1042_VoucherXLSSparser";
            } else if (type == 3) {
                if (obj == null) {
                    return null;
                }
                typeAlia = "1043_VoucherXLSSparser";
                if (obj != null) {
                    obj = obj.toString();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new VoucherExpImpException(VoucherExpImpException.DATATYPENOTVALID, new Object[]{new Integer(row + 1), new Integer(col + 1), "(" + obj + ") " + EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)typeAlia)});
        }
        return obj;
    }

    private int getCellIntValue(XSSFRow hssfRow, int row, int col, int type) throws Exception {
        int value;
        String _strV = String.valueOf(this.getCellValue(hssfRow, row, col, 0));
        if (_strV.indexOf(46) > 0) {
            _strV = _strV.substring(0, _strV.indexOf(46));
        }
        try {
            value = Integer.parseInt(_strV);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e);
            String typeAlia = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1040_VoucherXLSSparser");
            String tip = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"voucherOrCashflowTip");
            throw new VoucherExpImpException(VoucherExpImpException.DATATYPENOTVALID, new Object[]{new Integer(row + 1), new Integer(col + 1), "(" + _strV + ") " + typeAlia, "(" + tip + ")"});
        }
        return value;
    }

    private int getCellIntValue(XSSFRow hssfRow, int row, VoucherIMPColInfo col) throws Exception {
        return this.getCellIntValue(hssfRow, row, col.getIndex(), col.getType());
    }

    private Object getCellValueold(XSSFRow hssfRow, int row) throws VoucherExpImpException {
        XSSFCell cell = hssfRow.getCell((int)((short)row));
        Object obj = null;
        if (cell != null) {
            CellType type = cell.getCellType();
            switch (type) {
                case BOOLEAN: {
                    obj = cell.getBooleanCellValue();
                    break;
                }
                case NUMERIC: {
                    double nueric = cell.getNumericCellValue();
                    obj = new BigDecimal(String.valueOf(nueric));
                    break;
                }
                case STRING: {
                    obj = cell.getStringCellValue();
                    if (obj == null) break;
                    obj = ((String)obj).trim();
                    break;
                }
                case FORMULA: {
                    try {
                        obj = cell.getDateCellValue();
                        break;
                    }
                    catch (IllegalStateException e) {
                        throw new VoucherExpImpException(VoucherExpImpException.DATATYPENOTVALID, new Object[]{new Integer(hssfRow.getRowNum() + 1), new Integer(row + 1), "(" + cell.getCellFormula() + ") "});
                    }
                }
            }
        }
        return obj;
    }

    private SXSSFWorkbook getWorkbook(String fullName, boolean oeveride, boolean isUnitByAsst) throws EASBizException, BOSException {
        int i;
        String cellValue;
        int i2;
        int i3;
        SXSSFWorkbook wb = null;
        wb = new SXSSFWorkbook(100);
        SXSSFSheet sheet1 = wb.createSheet(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI"));
        Row row1 = sheet1.createRow(0);
        int clos = 0;
        int cellValueNumber1 = Integer.parseInt(this.getResx(EXP_RES_NAME, "HSSFCellValueNumber1")) + 2;
        int index = 0;
        if (this.isCommonVoucher) {
            index = 1;
        }
        Cell[] csCell = new Cell[(cellValueNumber1 += index) + 24 + 10];
        CellStyle style = this.getStyle(wb);
        int cellCount = cellValueNumber1 + 24 + 10;
        for (i3 = 0; i3 < cellCount; ++i3) {
            int n = clos;
            clos = (short)(clos + 1);
            csCell[i3] = row1.createCell(n);
            csCell[i3].setCellStyle(style);
        }
        csCell[0].setCellValue(VoucherImportUtils.companyRes);
        for (i3 = 1; i3 < cellValueNumber1; ++i3) {
            String cellValue2 = "";
            cellValue2 = this.isCommonVoucher && i3 == 8 ? this.getResx(EXP_RES_NAME, "HSSFCellValue7#1") : (this.isCommonVoucher && i3 > 8 ? (i3 == 10 ? this.getResx(EXP_RES_NAME, "HSSFCellValue7#2") : (i3 == 9 ? this.getResx(EXP_RES_NAME, "HSSFCellValue" + (i3 - 2)) : this.getResx(EXP_RES_NAME, "HSSFCellValue" + (i3 - 3)))) : (i3 > 8 ? (i3 == 9 ? this.getResx(EXP_RES_NAME, "HSSFCellValue7#2") : this.getResx(EXP_RES_NAME, "HSSFCellValue" + (i3 - 2))) : this.getResx(EXP_RES_NAME, "HSSFCellValue" + (i3 - 1))));
            csCell[i3].setCellValue(cellValue2);
        }
        int assCellValueNumber = cellValueNumber1;
        for (int i4 = 0; i4 < 8; ++i4) {
            String cellValue0 = this.getResx(EXP_RES_NAME, "HSSFCellValueASST1");
            String cellValue1 = this.getResx(EXP_RES_NAME, "HSSFCellValueASST2");
            String cellValue2 = this.getResx(EXP_RES_NAME, "HSSFCellValueASST3");
            csCell[assCellValueNumber + i4 * 3].setCellValue(cellValue0 + (i4 + 1));
            csCell[assCellValueNumber + i4 * 3 + 1].setCellValue(cellValue1 + (i4 + 1));
            csCell[assCellValueNumber + i4 * 3 + 2].setCellValue(cellValue2 + (i4 + 1));
        }
        int customCount = cellValueNumber1 + 34;
        int customCount1 = cellValueNumber1 + 24;
        if (isUnitByAsst) {
            customCount = cellValueNumber1 + 34;
            for (i2 = customCount1; i2 < customCount; ++i2) {
                cellValue = this.getResx(EXP_RES_NAME, "HSSFCellValue" + (i2 - 4 - index));
                csCell[i2].setCellValue(cellValue);
            }
        } else {
            for (i2 = customCount1; i2 < customCount; ++i2) {
                cellValue = this.getResx(EXP_RES_NAME, "HSSFCellValue" + (i2 - 2 - index));
                csCell[i2].setCellValue(cellValue);
            }
        }
        SXSSFSheet sheet2 = wb.createSheet(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1039_VoucherXLSSparser"));
        Row row2 = sheet2.createRow(0);
        int cellValueNumber2 = Integer.parseInt(this.getResx(EXP_RES_NAME, "HSSFCellValueNumber2")) + 1 + 1;
        Cell[] csCell2 = new Cell[cellValueNumber2 + 24];
        csCell2[0] = row2.createCell(0);
        csCell2[0].setCellValue(VoucherImportUtils.companyRes);
        for (i = 1; i < cellValueNumber2; ++i) {
            csCell2[i] = row2.createCell((int)((short)i));
            String cellValue3 = this.getResx(EXP_RES_NAME, "HSSFCellValueCash" + (i - 1));
            csCell2[i].setCellValue(cellValue3);
        }
        for (i = 0; i < 8; ++i) {
            String cellValue0 = this.getResx(EXP_RES_NAME, "HSSFCellValueASST1");
            String cellValue1 = this.getResx(EXP_RES_NAME, "HSSFCellValueASST2");
            String cellValue2 = this.getResx(EXP_RES_NAME, "HSSFCellValueASST3");
            csCell2[cellValueNumber2 + i * 3] = row2.createCell((int)((short)(cellValueNumber2 + i * 3)));
            csCell2[cellValueNumber2 + i * 3].setCellValue(cellValue0 + (i + 1));
            csCell2[cellValueNumber2 + i * 3 + 1] = row2.createCell((int)((short)(cellValueNumber2 + i * 3 + 1)));
            csCell2[cellValueNumber2 + i * 3 + 1].setCellValue(cellValue1 + (i + 1));
            csCell2[cellValueNumber2 + i * 3 + 2] = row2.createCell((int)((short)(cellValueNumber2 + i * 3 + 2)));
            csCell2[cellValueNumber2 + i * 3 + 2].setCellValue(cellValue2 + (i + 1));
        }
        return wb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveWorkbook(SXSSFWorkbook wb, String srtFileFullname, boolean overide) {
        File file;
        if (overide && (file = new File(srtFileFullname)).exists()) {
            file.delete();
        }
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(srtFileFullname);
            return;
        }
        catch (FileNotFoundException e) {
            this.core.handUIException((Throwable)e);
            return;
        }
        finally {
            if (fileOut != null) {
                try {
                    wb.write((OutputStream)fileOut);
                }
                catch (IOException e2) {
                    this.core.handUIException((Throwable)e2);
                }
                finally {
                    try {
                        fileOut.close();
                        wb.close();
                        wb.dispose();
                    }
                    catch (Exception e3) {
                        this.core.handUIException((Throwable)e3);
                    }
                }
            }
        }
    }

    private POIFSFileSystem openWorkbookFile(FileInputStream fis) throws EASBizException {
        POIFSFileSystem fs = null;
        try {
            fs = new POIFSFileSystem((InputStream)fis);
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new VoucherExpImpException(VoucherExpImpException.FILE_SPARSER_NOTCORRECT);
        }
        return fs;
    }

    private CellStyle getStyle(SXSSFWorkbook wb) {
        CellStyle structStyle = wb.createCellStyle();
        structStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        structStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_CORNFLOWER_BLUE.getIndex());
        structStyle.setAlignment(HorizontalAlignment.LEFT);
        structStyle.setHidden(false);
        structStyle.setLocked(false);
        BorderStyle borderstyle = BorderStyle.DOTTED;
        structStyle.setBorderLeft(borderstyle);
        structStyle.setBorderRight(borderstyle);
        structStyle.setBorderTop(borderstyle);
        structStyle.setBorderBottom(borderstyle);
        short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
        structStyle.setBottomBorderColor(backColorIndex);
        structStyle.setTopBorderColor(backColorIndex);
        structStyle.setLeftBorderColor(backColorIndex);
        structStyle.setRightBorderColor(backColorIndex);
        structStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        Font defaultFont = wb.createFont();
        defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"265_TableMonitorFrame"));
        short size = 12;
        defaultFont.setFontHeightInPoints(size);
        structStyle.setFont(defaultFont);
        return structStyle;
    }

    public static int profitCenterNext(XSSFRow hssfRow, boolean isMulTiCompany, boolean commonVoucherProcess) {
        boolean hasProfitCenter = VoucherXLSXSparser.xlsHasProfitCenter(hssfRow, isMulTiCompany);
        int next = 0;
        if (hasProfitCenter) {
            if (!commonVoucherProcess) {
                next = 1;
            }
        } else if (commonVoucherProcess) {
            next = -1;
        }
        return next;
    }

    public static boolean xlsHasProfitCenter(XSSFRow hssfRow, boolean isMulTiCompany) {
        String resName;
        XSSFCell cell;
        String name;
        boolean hasProfitCenter = false;
        int profitCenterIndex = 7;
        if (isMulTiCompany) {
            profitCenterIndex = (short)(profitCenterIndex + 1);
        }
        if ((name = (cell = hssfRow.getCell(profitCenterIndex)).getStringCellValue()).equals(resName = EASResource.getString((String)EXP_RES_NAME2, (String)"HSSFCellValue7#1"))) {
            hasProfitCenter = true;
        }
        return hasProfitCenter;
    }

    private AsstActTypeCollection getAsstActTypes(String caaId) throws BOSException {
        if (this.asstActTypess.containsKey(caaId)) {
            return this.asstActTypess.get(caaId);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)caaId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        AsstActGroupDetailCollection asstcol = AsstActGroupDetailFactory.getRemoteInstance().getAsstActGroupDetailCollection(view);
        AsstActTypeCollection asstActTypes = new AsstActTypeCollection();
        for (int i = 0; i < asstcol.size(); ++i) {
            asstActTypes.add(asstcol.get(i).getAsstActType());
        }
        this.asstActTypess.put(caaId, asstActTypes);
        return asstActTypes;
    }
}

