/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.AbstractAccountBalanceAntithesControllerBean;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.IGLRptAccountBalanceFacade;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class AccountBalanceAntithesControllerBean
extends AbstractAccountBalanceAntithesControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.AccountBalanceAntithesControllerBean");

    @Override
    protected HashMap _initData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> initData = new HashMap<String, Object>();
        PeriodInfo current = GlUtils.getCurrentPeriod(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        AccountRefContrastInfo accountRef = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), ContextUtil.getCurrentFIUnit((Context)ctx).getAccountTable().getId().toString(), current.getPeriodYear(), current.getPeriodNumber());
        if (accountRef != null) {
            AccountTableInfo oldtable;
            AccountTableInfo newtable = accountRef.getEnabledAcctTable();
            if (newtable != null) {
                newtable = AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableInfo((IObjectPK)new ObjectUuidPK(accountRef.getEnabledAcctTable().getId().toString()));
                accountRef.setEnabledAcctTable(newtable);
            }
            if ((oldtable = accountRef.getDisabledAcctTable()) != null) {
                oldtable = AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableInfo((IObjectPK)new ObjectUuidPK(accountRef.getDisabledAcctTable().getId().toString()));
                accountRef.setDisabledAcctTable(oldtable);
            }
        }
        initData.put("accountRef", accountRef);
        PeriodInfo ADJPeriod = accountRef.getEnabledPeriod();
        if (ADJPeriod == null) {
            return initData;
        }
        initData.put("ADJPeriod", ADJPeriod);
        PeriodInfo reportOldPeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)ADJPeriod);
        initData.put("reportOldPeriod", reportOldPeriod);
        PeriodInfo reportNewPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)ADJPeriod);
        initData.put("reportNewPeriod", reportNewPeriod);
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("Number", (Object)"GLC");
        filterInfo.getFilterItems().add(filterItemInfo);
        entity.setFilter(filterInfo);
        CurrencyCollection currencyColl = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(entity);
        if (currencyColl != null && currencyColl.size() > 0) {
            initData.put("currency", currencyColl.get(0));
        }
        return initData;
    }

    @Override
    protected ArrayList _accountOpposite(Context ctx, String oldAcctTabId, String newAcctTabId, String cuId, String ouID, String newPeriodId, String currencyId, int BalType, ArrayList oldAccountIds) throws BOSException, EASBizException {
        throw new UnsupportedOperationException("method accountOpposite has been deleted.");
    }

    @Override
    protected ArrayList _getOldAccount(Context ctx, String ouId, String periodID, int balType, String currencyId, String oldAccoutTableId) throws BOSException, EASBizException {
        throw new UnsupportedOperationException("method getOldAccount has been deleted.");
    }

    @Override
    protected void _delAdjAntithes(Context ctx, String newAccountTableID, String oldAccountTableID) throws BOSException, EASBizException {
        StringBuffer _sql = new StringBuffer("delete T_GL_AccountBalanceAntithes where  fnewaccountid = ? and foldaccountid =?");
        Object[] params = new Object[]{newAccountTableID, oldAccountTableID};
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
    }

    private String getCreateSql() {
        StringBuffer createSql = new StringBuffer();
        createSql.append("KSQL_SEQ INT IDENTITY (1, 1),");
        createSql.append("fendBalance NUMERIC(29,10),");
        createSql.append("faccountid varchar(40),");
        createSql.append("foldAcctid varchar(40),");
        createSql.append("fnumber nvarchar(80),");
        createSql.append("faccountName nvarchar(400),");
        createSql.append("flongname nvarchar(640),");
        createSql.append("facctTypeid varchar(40),");
        createSql.append("fTypeName nvarchar(80),");
        createSql.append("fparentid varchar(40),");
        createSql.append("flevel int,");
        createSql.append("fisleaf int");
        return createSql.toString();
    }

    private String createTempTable(Context ctx, String struct) throws BOSException {
        String name = "data";
        String csName = this.getClass().getName();
        name = csName.substring(csName.lastIndexOf(".") + 1) + name;
        String createTableSql = "create table " + name + " (" + struct + ")";
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
        }
        catch (Exception e) {
            throw new BOSException("create tempTable error!", (Throwable)e);
        }
    }

    private void insertDate(Context ctx, String tableName, String ouId, String periodID, int balType, String currencyId, String oldAccoutTableId) throws BOSException, EASBizException {
        ArrayList data = new ArrayList();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        TreeSet companyIdSet = new TreeSet();
        sql.append("insert into ");
        sql.append(tableName);
        sql.append(" (");
        sql.append("KSQL_SEQ,fendBalance,faccountid,foldAcctid,fnumber,faccountName,flongname,facctTypeid,fTypename,fparentid,flevel,fisleaf ) ");
        sql.append("select distinct tb.fendBalance,ta.* from (");
        sql.append("select distinct account.fid faccountid,account.fid foldAcctid,account.fnumber fnumber,account.fname_" + loc + " faccountName,");
        sql.append("account.flongname_" + loc + " flongname,acctType.Fid facctTypeid, acctType.Fname_" + loc + " fTypename ,");
        sql.append("account.fparentid fparentid,account.flevel flevel,account.fisleaf");
        sql.append(" from t_gl_voucher voucher ");
        sql.append(" inner join t_gl_voucherentry entry on entry.fbillid= voucher.fid ");
        sql.append(" inner join t_bd_accountview account on account.fid = entry.faccountid");
        sql.append(" left join t_bd_accounttype acctType on acctType.Fid = account.faccounttypeid ");
        sql.append(" where");
        sql.append(" account.faccounttableid = ?");
        sql.append(" and voucher.fcompanyid = ? ");
        sql.append(" and account.fcompanyid = ? ");
        sql.append(" and voucher.fperiodid = ? ");
        sql.append(" and voucher.fsourceType = ?");
        sql.append(" ) ta");
        sql.append(" inner join (");
        sql.append("select account.fid faccountid,sum(entry.FLocalAmount) fendBalance");
        sql.append(" from t_gl_voucher voucher ");
        sql.append(" inner join t_gl_voucherentry entry on entry.fbillid= voucher.fid ");
        sql.append(" inner join t_bd_accountview account on account.fid = entry.faccountid");
        sql.append(" left join t_bd_accounttype acctType on acctType.Fid = account.faccounttypeid ");
        sql.append(" where");
        sql.append(" account.faccounttableid = ?");
        sql.append(" and voucher.fcompanyid = ? ");
        sql.append(" and account.fcompanyid = ? ");
        sql.append(" and voucher.fperiodid = ? ");
        sql.append(" and voucher.fsourceType = ?");
        sql.append("group by account.fid");
        sql.append(") tb on ta.faccountid = tb.faccountid");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(oldAccoutTableId);
        params.add(ouId);
        params.add(ouId);
        params.add(periodID);
        params.add(7);
        params.add(oldAccoutTableId);
        params.add(ouId);
        params.add(ouId);
        params.add(periodID);
        params.add(7);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
    }

    private void insertParentAccount(Context ctx, String tempTableName, Set companyIdSet, String accountTableId) throws BOSException, EASBizException {
        IGLRptAccountBalanceFacade glRptBaseFacade = GLRptAccountBalanceFacadeFactory.getLocalInstance(ctx);
        int maxLevel = glRptBaseFacade.getAccountMaxLevel(companyIdSet, accountTableId);
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        for (int i = maxLevel; i > 0; --i) {
            StringBuffer sql = new StringBuffer();
            sql.append("insert into ");
            sql.append(tempTableName);
            sql.append("(");
            sql.append("KSQL_SEQ,fendBalance,faccountid,foldAcctid,fnumber,faccountName,flongname,facctTypeid,fTypename,fparentid,flevel,fisleaf) ");
            sql.append("select t.* from (");
            sql.append("select tmp.fendBalance fendBalance,account.fid faccountid,account.fid foldAcctid,account.fnumber fnumber,account.fname_" + loc + " faccountName,");
            sql.append("account.flongname_" + loc + " flongname,acctType.Fid facctTypeid, acctType.Fname_" + loc + " fTypename, ");
            sql.append("account.fparentid fparentid,account.flevel flevel,account.fisleaf");
            sql.append(" from t_bd_accountview account");
            sql.append(" inner join (");
            sql.append(" select tmp.fparentid fparentid, sum(tmp.fendBalance) fendBalance from ");
            sql.append(tempTableName).append(" tmp");
            sql.append(" where");
            sql.append(" tmp.flevel = " + i);
            sql.append(" group by tmp.fparentid ) tmp ");
            sql.append(" on account.fid = tmp.fparentid ");
            sql.append(" left join t_bd_accounttype acctType on acctType.Fid = account.faccounttypeid ");
            sql.append(") t");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private ArrayList getAccountData(Context ctx, String tempTableName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        sql.append("KSQL_SEQ,fendBalance,faccountid,fnumber,faccountName,flongname,facctTypeid,fTypename,fparentid,flevel,fisleaf ");
        sql.append(" from ");
        sql.append(tempTableName);
        sql.append(" order by fnumber");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList data = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, Object> rang = new HashMap<String, Object>();
                rang.put("endBalance", rowSet.getBigDecimal(2));
                rang.put("oldAcctId", rowSet.getString(3));
                rang.put("oldAcctNumber", rowSet.getString(4));
                rang.put("oldAcctName", rowSet.getString(5));
                rang.put("oldAcctLongName", rowSet.getString(6));
                rang.put("oldAcctTypeId", rowSet.getString(7));
                rang.put("oldAcctTypeName", rowSet.getString(8));
                rang.put("oldLevel", rowSet.getInt(10));
                rang.put("oldIsLeaf", rowSet.getInt(11));
                data.add(rang);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return data;
    }

    @Override
    protected ArrayList _accountOppositeNew(Context ctx, String oldAcctTabId, String newAcctTabId, String cuId, String ouID, String newPeriodId, String currencyId, int BalType, ArrayList oldAccountIds) throws BOSException, EASBizException {
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        ArrayList data = new ArrayList();
        if (oldAccountIds == null || oldAccountIds.size() == 0) {
            return data;
        }
        TreeSet<String> companyIdSet = new TreeSet<String>();
        companyIdSet.add(ouID);
        String tempTableName = this.createTempTable(ctx, this.getCreateSql());
        this.insertDate(ctx, tempTableName, ouID, newPeriodId, BalType, currencyId, oldAcctTabId);
        this.updateAccountInfo(ctx, tempTableName);
        this.insertParentAccount(ctx, tempTableName, companyIdSet, oldAcctTabId);
        return this.getNewAccountData(ctx, tempTableName);
    }

    @Override
    protected ArrayList _getOldAccountNew(Context ctx, String ouId, String periodID, int balType, String currencyId, String oldAccoutTableId) throws BOSException, EASBizException {
        TreeSet<String> companyIdSet = new TreeSet<String>();
        companyIdSet.add(ouId);
        String tempTableName = this.createTempTable(ctx, this.getCreateSql());
        this.insertDate(ctx, tempTableName, ouId, periodID, balType, currencyId, oldAccoutTableId);
        this.insertParentAccount(ctx, tempTableName, companyIdSet, oldAccoutTableId);
        return this.getAccountData(ctx, tempTableName);
    }

    private ArrayList getNewAccountData(Context ctx, String tempTableName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        sql.append("temp.fendBalance,temp.faccountid,temp.foldacctid,temp.fnumber,temp.faccountName,temp.fisleaf ");
        sql.append(" from ");
        sql.append(tempTableName).append(" temp ");
        sql.append(" union all select ");
        sql.append("temp.fendBalance,temp.faccountid,ref.foldacctid,temp.fnumber,temp.faccountName,temp.fisleaf ");
        sql.append(" from ");
        sql.append(tempTableName).append(" temp ");
        sql.append(" inner join t_bd_acctrefcontrastentry ref on ref.fnewacctid =temp.faccountid ");
        sql.append(" where temp.fisleaf = 0");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList data = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, Object> rang = new HashMap<String, Object>();
                rang.put("begbal", rowSet.getBigDecimal(1));
                rang.put("newacctId", rowSet.getString(2));
                rang.put("oldacctId", rowSet.getString(3));
                rang.put("newacctNumber", rowSet.getString(4));
                rang.put("newacctName", rowSet.getString(5));
                rang.put("newIsLeaf", rowSet.getInt(6));
                data.add(rang);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return data;
    }

    private void updateAccountInfo(Context ctx, String tempTableName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append("update ");
        sql.append(tempTableName);
        sql.append(" set (faccountid,fnumber,faccountName,flongname,facctTypeid,fTypeName,fparentid,flevel,fisleaf) = ");
        sql.append("(select distinct account.fid faccountid,account.fnumber fnumber,account.fname_" + loc + " faccountName,");
        sql.append("account.flongname_" + loc + " flongname,acctType.Fid facctTypeid, acctType.Fname_" + loc + " fTypename ,");
        sql.append("account.fparentid fparentid,account.flevel flevel,account.fisleaf ");
        sql.append(" from t_bd_accountview account left join t_bd_accounttype acctType on acctType.Fid = account.faccounttypeid \r\n");
        sql.append(" inner join t_bd_acctrefcontrastentry ref on ref.fnewacctid = account.fid \r\n");
        sql.append(" where ref.foldacctid = ");
        sql.append(tempTableName).append(".faccountid)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

