/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.util.StringUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.app.AbstractAcctCussentCheckFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.AccountAgeFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.app.GLTransactionUtils;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.AssistViewFilterInfo;
import com.kingdee.eas.fi.gl.rpt.GLRptCache;
import com.kingdee.eas.fi.gl.rpt.GLRptException;
import com.kingdee.eas.fi.gl.rpt.GLRptQueryResult;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.IGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.AcctCussentCheckDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.AcctCussentCheckTreeDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AcctCussentCheckFacadeControllerBean
extends AbstractAcctCussentCheckFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)AccountAgeFacadeControllerBean.class.getClass().getName());
    private boolean includeInitData = false;

    protected IGLRptDao getGLRptDao(Context ctx, ReportConditionBase condition, String method) throws BOSException, EASBizException {
        if (method.indexOf("Tree") > -1) {
            return new AcctCussentCheckTreeDao(ctx);
        }
        return new AcctCussentCheckDao(ctx);
    }

    protected IGLRptDao getGLRptDao(Context ctx, String queryId) throws BOSException, EASBizException {
        GLRptCache cache = GLRptCache.getGLRptCache(ctx, queryId);
        if (cache == null) {
            throw new GLRptException(GLRptException.SESSION_INVALID);
        }
        return cache.getDao();
    }

    @Override
    protected ArrayList _getAsstItemType(Context ctx, String accountId, String companyId) throws BOSException, EASBizException {
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        ArrayList result = new ArrayList();
        StringBuffer sql = new StringBuffer();
        if (accountId == null) {
            sql.append("select distinct item.fid id,item.fisforcompany fisforcompany,item.fnumber fnumber,").append("item.FGlAsstActTypeGrpID glgroup,item.fdefaultqueryname queryname,item.frealtiondataobject tablename, ").append("item.fassthgattribute propname, item.fmappingfieldname fieldname,item.fname_").append(loc);
            sql.append(" fname,item.FUseLongNumber useLongNUmber ");
            sql.append(" from T_BD_AsstAccount book INNER JOIN T_BD_AsstActGroupDetail rel ON book.fid = rel.fasstaccountid ").append(" inner join T_BD_AsstActType item on item.fid = rel.fasstacttypeid ").append(" INNER JOIN t_bd_accountview D ON book.fid = D.FCAA").append(" WHERE D.FAC = 1 AND D.fcompanyid = ? ORDER BY item.fnumber");
        } else {
            if (accountId.contains("!_")) {
                String accs = accountId.replaceAll("!_", "");
                String[] asstTypes = accs.split(", ");
                return this.getAsstItembyAsstTypes(ctx, asstTypes);
            }
            sql.append("select distinct item.fid id,item.fisforcompany fisforcompany,item.fnumber fnumber,item.FGlAsstActTypeGrpID glgroup,item.fdefaultqueryname queryname,item.frealtiondataobject tablename, item.fassthgattribute propname, item.fmappingfieldname fieldname,item.fname_");
            sql.append(loc);
            sql.append(" fname,item.FUseLongNumber useLongNUmber, rel.fseq from t_BD_AccountView account").append(" inner join T_BD_AsstAccount book on account.fcaa = book.fid ").append(" inner join T_BD_AsstActGroupDetail rel on book.fid = rel.fasstaccountid ").append(" inner join T_BD_AsstActType item on item.fid = rel.fasstacttypeid ").append(" and account.fid in (?) order by rel.fseq asc ");
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql.toString());
            if (accountId == null) {
                ps.setString(1, companyId);
            } else {
                ps.setString(1, accountId);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                String id = rs.getString("id");
                item.put("id", id);
                item.put("isforcompany", rs.getBoolean("fisforcompany"));
                item.put("number", rs.getString("fnumber"));
                item.put("name", rs.getString("fname"));
                item.put("queryname", rs.getString("queryname"));
                item.put("propname", rs.getString("propname"));
                item.put("fieldname", rs.getString("fieldname"));
                item.put("tablename", rs.getString("tablename"));
                item.put("glgroup", rs.getString("glgroup"));
                item.put("useLongNUmber", rs.getBoolean("useLongNUmber"));
                result.add(item);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    private ArrayList getAsstItembyAsstTypes(Context ctx, String[] asstTypes) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer sql = new StringBuffer("select count(t.fid) counts,de.FAsstActTypeID,tp.FAsstHGAttribute from t_bd_asstaccount t inner join T_BD_AsstActGroupDetail de on de.FAsstAccountID =t.fid").append(" inner join T_BD_AsstActType tp on tp.FID = de.FAsstActTypeID ").append(" where t.fid in ").append(CSSPUtils.getIdsSql((String[])asstTypes)).append(" group by de.FAsstActTypeID ,tp.FAsstHGAttribute ");
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int counts = rs.getInt("counts");
                if (counts != asstTypes.length) continue;
                result.add(rs.getString("FAsstHGAttribute"));
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        if (result.size() > 0) {
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected HashMap _queryCheckAccount(Context ctx, HashMap condition, int start, int count, String companyid) throws BOSException, EASBizException {
        ResultSet rs;
        Statement ps;
        Connection con;
        ArrayList<HashMap> datas;
        String tablename;
        HashMap<String, Object> result;
        block27: {
            result = new HashMap<String, Object>();
            Boolean newquery = (Boolean)condition.get("newquery");
            tablename = (String)condition.get("tablename");
            datas = new ArrayList<HashMap>();
            String TITLE_PERIOD_START = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"strBalancePeriodStart", (Locale)ctx.getLocale());
            String TITLE_TOTAL = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Total", (Locale)ctx.getLocale());
            con = null;
            ps = null;
            rs = null;
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            TempTablePool iPool = null;
            String tempTableVerify = null;
            String tempTableVerified = null;
            String tempTableHappen = null;
            try {
                con = this.getConnection(ctx);
                iPool = TempTablePool.getInstance((Context)ctx);
                StringBuffer sql = new StringBuffer();
                if (newquery.booleanValue()) {
                    tablename = this.createTempTable4Result(iPool, con);
                    condition.put("tablename", tablename);
                    try {
                        sql.setLength(0);
                        sql.append("create index I").append(tablename);
                        sql.append(" on ").append(tablename);
                        sql.append(" (FCurrencyID)");
                        ps = con.prepareStatement(sql.toString());
                        ps.execute();
                        ps.close();
                    }
                    catch (SQLException sQLException) {
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    this.insertIntoTable(ctx, iPool, con, condition, companyid, loc);
                    tempTableVerify = (String)condition.get("tempTableVerify");
                    tempTableVerified = (String)condition.get("tempTableVerified");
                    tempTableHappen = (String)condition.get("tempTableHappen");
                }
                sql.setLength(0);
                sql.append("select t.*,cy.fname_").append(loc).append(" fcurrencyName,");
                sql.append(" cy.fprecision ");
                sql.append(" from ").append(tablename).append(" t ");
                sql.append(" inner join t_bd_currency cy on cy.fid = t.fcurrencyid ");
                sql.append(" order by fcurrencyid,flinetype,fdate,fisinit,fvouchernumber");
                ps = con.prepareStatement(sql.toString());
                rs = ps.executeQuery();
                BigDecimal bal = new BigDecimal("0");
                BigDecimal beginBalance = new BigDecimal("0");
                String preCurrencyId = "";
                String curCurrencyId = "";
                HashMap<String, HashMap> existMap = new HashMap<String, HashMap>();
                while (rs.next()) {
                    HashMap map = new HashMap();
                    int linetype = rs.getInt("flinetype");
                    map.put("linetype", new Integer(linetype));
                    map.put("bizdate", rs.getDate("fbizdate"));
                    map.put("date", rs.getDate("fdate"));
                    map.put("currency", rs.getString("fcurrencyName"));
                    map.put("precision", new Integer(rs.getInt("fprecision")));
                    curCurrencyId = rs.getString("fcurrencyid");
                    if (!curCurrencyId.equalsIgnoreCase(preCurrencyId)) {
                        bal = new BigDecimal("0");
                    }
                    if (linetype != -3) {
                        map.put("debit", InitHelp.nvl(rs.getBigDecimal("fdebit")));
                        map.put("credit", InitHelp.nvl(rs.getBigDecimal("fcredit")));
                    }
                    if (linetype == -3) {
                        if (existMap.get(-3 + curCurrencyId) != null) {
                            map = (HashMap)existMap.get(-3 + curCurrencyId);
                            beginBalance = bal = ((BigDecimal)map.get("balance")).add(InitHelp.nvl(rs.getBigDecimal("fbalance")));
                            map.put("balance", bal);
                            preCurrencyId = curCurrencyId;
                            continue;
                        }
                        map.put("remark", TITLE_PERIOD_START);
                        beginBalance = bal = bal.add(InitHelp.nvl(rs.getBigDecimal("fbalance")));
                        map.put("balance", bal);
                        existMap.put(-3 + curCurrencyId, map);
                    } else if (linetype == 0 || -6 == linetype) {
                        map.put("bizNumber", rs.getString("FBizNumber"));
                        map.put("invoiceNumber", rs.getString("FInvoiceNumber"));
                        map.put("remark", rs.getString("fdescription"));
                        map.put("voucherid", rs.getString("fvoucherid"));
                        map.put("vouchernumber", rs.getString("fvouchernumber"));
                        map.put("vouchertype", rs.getString("fvouchertype"));
                        BigDecimal fbalance = rs.getBigDecimal("fbalance");
                        bal = bal.add(fbalance);
                        map.put("balance", bal);
                    } else {
                        map.put("remark", TITLE_TOTAL);
                        map.put("balance", beginBalance.add(InitHelp.nvl(rs.getBigDecimal("fbalance"))));
                    }
                    datas.add(map);
                    preCurrencyId = curCurrencyId;
                }
                if (iPool == null) break block27;
            }
            catch (SQLException e) {
                try {
                    throw new SQLAccessException(e);
                }
                catch (Throwable throwable) {
                    if (iPool != null) {
                        if (!StringUtils.isEmpty(tempTableVerify)) {
                            iPool.releaseTable(tempTableVerify);
                        }
                        if (!StringUtils.isEmpty(tempTableVerified)) {
                            iPool.releaseTable(tempTableVerified);
                        }
                        if (!StringUtils.isEmpty(tempTableHappen)) {
                            iPool.releaseTable(tempTableHappen);
                        }
                    }
                    SQLUtils.cleanup(rs, ps, (Connection)con);
                    throw throwable;
                }
            }
            if (!StringUtils.isEmpty((String)tempTableVerify)) {
                iPool.releaseTable(tempTableVerify);
            }
            if (!StringUtils.isEmpty((String)tempTableVerified)) {
                iPool.releaseTable(tempTableVerified);
            }
            if (!StringUtils.isEmpty((String)tempTableHappen)) {
                iPool.releaseTable(tempTableHappen);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        result.put("tablename", tablename);
        result.put("datas", datas);
        return result;
    }

    private void insertIntoTable(Context ctx, TempTablePool iPool, Connection con, HashMap condition, String companyid, String loc) throws BOSException, EASBizException {
        int verifyMode = GlUtils.getVerifyMode(ctx, companyid);
        boolean isInTimeVerify = verifyMode == 0;
        String tablename = (String)condition.get("tablename");
        boolean sumGroupByCury = condition.get("sumGroupByCurrency") == null ? false : (Boolean)condition.get("sumGroupByCurrency");
        PreparedStatement ps = null;
        Statement ps2 = null;
        ResultSet rs = null;
        String accountid = (String)condition.get("accountid");
        String currencyid = (String)condition.get("currencyid");
        boolean isAllCurrency = "AllCurrency".equals(currencyid);
        Date bizdatefrom = DateTimeUtils.truncateDate((Date)((Date)condition.get("bizdatefrom")));
        Date bizdateto = DateTimeUtils.truncateDate((Date)((Date)condition.get("bizdateto")));
        java.sql.Date begin = new java.sql.Date(bizdatefrom.getTime());
        Calendar cal = Calendar.getInstance();
        cal.setTime(bizdateto);
        cal.add(5, 1);
        cal.add(14, -1);
        java.sql.Date end = new java.sql.Date(cal.getTimeInMillis());
        boolean includeUnPosted = (Boolean)condition.get("includeUnPosted");
        boolean includeFinished = (Boolean)condition.get("includeFinished") == false;
        this.includeInitData = (Boolean)condition.get("includeInitData");
        if (verifyMode == 2) {
            includeUnPosted = true;
        }
        EntityViewInfo mainQuery = (EntityViewInfo)condition.get("mainQuery");
        StringBuffer whereSelfDefine = this.transWhereSelfDefineToSQL(mainQuery, loc);
        StringBuffer whereSelfDefine_Assist = this.transWhereSelfDefineToSQL_Assist(mainQuery, loc);
        String tempTableVerify = null;
        String tempTableVerified = null;
        String tempTableHappen = null;
        try {
            boolean isDbTypeOracleDB2 = this.checkDbTypeIsOracleDB2(ctx);
            if (!includeFinished && !isInTimeVerify) {
                tempTableVerify = this.createTempTable4Verify(iPool, con);
                tempTableVerified = this.createTempTable4Verified(iPool, con);
                condition.put("tempTableVerify", tempTableVerify);
                condition.put("tempTableVerified", tempTableVerified);
            }
            tempTableHappen = this.createTempTable4Happen(iPool, con);
            condition.put("tempTableHappen", tempTableHappen);
            ArrayList items = (ArrayList)condition.get("items");
            Iterator itemkeyit = items.iterator();
            ArrayList<Object> ids = new ArrayList<Object>();
            int index = 1;
            StringBuffer selectHG = new StringBuffer();
            itemkeyit = items.iterator();
            if (condition.containsKey("selectHeaderList")) {
                StringBuffer hgConditionSql = new StringBuffer();
                StringBuffer hgConditionSqlInner = new StringBuffer();
                ArrayList selectHeaderList = (ArrayList)condition.get("selectHeaderList");
                int size = selectHeaderList.size();
                for (int i = 0; i < size; ++i) {
                    ArrayList itemDetailList = (ArrayList)selectHeaderList.get(i);
                    int jSize = itemDetailList.size();
                    for (int j = 0; j < jSize; ++j) {
                        HashMap itemDetailMap = (HashMap)itemDetailList.get(j);
                        HashMap itemMap = (HashMap)items.get(j);
                        if (hgConditionSqlInner.length() == 0) {
                            hgConditionSqlInner.append("hg.").append(itemMap.get("fieldname")).append("=?");
                        } else {
                            hgConditionSqlInner.append(" and hg.").append(itemMap.get("fieldname")).append("=?");
                        }
                        ids.add(itemDetailMap.get("id"));
                    }
                    if (hgConditionSql.length() == 0) {
                        hgConditionSql.append(" (").append(hgConditionSqlInner).append(")");
                    } else {
                        hgConditionSql.append(" or (").append(hgConditionSqlInner).append(")");
                    }
                    hgConditionSqlInner.setLength(0);
                }
                if (hgConditionSql.length() > 0) {
                    selectHG.append(" and (").append(hgConditionSql).append(")");
                }
            } else {
                while (itemkeyit.hasNext()) {
                    HashMap item = (HashMap)itemkeyit.next();
                    String field = (String)item.get("fieldname");
                    String id = (String)item.get("id");
                    selectHG.append(" and hg.").append(field).append("=?");
                    ids.add(id);
                }
            }
            if (selectHG.length() > 0) {
                selectHG.append("  \r\n");
            }
            StringBuffer insert = new StringBuffer();
            StringBuffer select = new StringBuffer();
            StringBuffer selectVeri = new StringBuffer();
            int accountDC = this.getAccountDC(con, accountid);
            if (this.includeInitData) {
                this.insertInitData(con, tablename, includeFinished, isInTimeVerify, includeUnPosted, isAllCurrency, selectHG, accountid, companyid, currencyid, ids, begin, end);
            } else {
                this.calAcBeginBal(ctx, iPool, con, tablename, isInTimeVerify, includeFinished, includeUnPosted, isAllCurrency, selectHG, whereSelfDefine_Assist, accountid, companyid, currencyid, begin, end, ids, tempTableHappen);
            }
            if (includeFinished) {
                insert = this.getInsertAcSql(tablename, includeFinished);
                select = this.getSelectAcVeriSql(ctx, tablename, loc, isInTimeVerify, includeUnPosted, includeFinished, selectHG, currencyid);
                select.append(whereSelfDefine_Assist);
                ps = con.prepareStatement(insert.toString() + select.toString());
                index = 1;
                this.setParams_SelectAcSql(ps, index, accountid, companyid, currencyid, begin, end, ids);
                ps.executeUpdate();
                SQLUtils.cleanup((Statement)ps);
            } else {
                insert = this.getInsertAcSql(tablename, includeFinished);
                select = this.getSelectOnlyAcSql(ctx, tablename, loc, isInTimeVerify, includeUnPosted, includeFinished, selectHG, currencyid);
                select.append(whereSelfDefine);
                ps = con.prepareStatement(insert.toString() + select.toString());
                index = 1;
                this.setParams_SelectOnlyAcSql(isDbTypeOracleDB2, ps, index, accountid, companyid, currencyid, begin, end, ids);
                ps.executeUpdate();
                SQLUtils.cleanup((Statement)ps);
                this.returnBackFutureVerify(ctx, con, accountDC, tablename, companyid, accountid, currencyid, isInTimeVerify, includeUnPosted, begin, end);
                select.setLength(0);
                select.append("update ").append(tablename);
                select.append(" set FBalance = FDebit - FCredit ");
                select.append(" where (flinetype = ").append(0).append(" or FLineType = ").append(-6).append(")");
                select.append(" and facctcussentid is not null ");
                ps = con.prepareStatement(select.toString());
                ps.executeUpdate();
                SQLUtils.cleanup((Statement)ps);
                if (!isInTimeVerify) {
                    if (whereSelfDefine_Assist.indexOf("FBizDate") != -1) {
                        String where = whereSelfDefine_Assist.toString();
                        where = where.replaceAll("FBizDate", "FVarBizDate");
                        selectHG.append(where);
                    }
                    this.prepareVerifyData_New(ctx, iPool, con, accountDC, tablename, tempTableVerify, tempTableVerified, loc, isInTimeVerify, includeUnPosted, includeFinished, companyid, accountid, currencyid, selectHG, begin, end, ids);
                }
                select.setLength(0);
                select.append("delete from ").append(tablename);
                select.append(" where (flinetype = ").append(0).append(" or FLineType = ").append(-6).append(")");
                select.append(" and facctcussentid is not null and FBalance = 0");
                ps = con.prepareStatement(select.toString());
                ps.executeUpdate();
                SQLUtils.cleanup((Statement)ps);
            }
            insert = new StringBuffer();
            insert.append("INSERT ");
            insert.append(tablename);
            insert.append("\t(FCurrencyID, FDebit, FCredit,");
            insert.append("\tFBalance,FAssGrpId,FLineType)");
            select = new StringBuffer();
            select.append(" select FCurrencyID, sum(fdebit) fdebit,sum(fcredit) fcredit,sum(fbalance) fbalance,");
            if (sumGroupByCury) {
                select.append("'' FAssGrpId,");
            } else {
                select.append("FAssGrpId,");
            }
            select.append(9);
            select.append(" from ").append(tablename).append(" where FLineType<>").append(-3);
            if (sumGroupByCury) {
                select.append(" group by FCurrencyID");
            } else {
                select.append(" group by FAssGrpId,FCurrencyID");
            }
            ps = con.prepareStatement(insert.toString() + select.toString());
            ps.executeUpdate();
            SQLUtils.cleanup((Statement)ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps2);
                SQLUtils.cleanup(rs, ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup(ps2);
        SQLUtils.cleanup(rs, (Statement)ps);
    }

    private void insertAcctCussentInitDataAfterAcPeriod(Context ctx, Connection con, String companyid, boolean isInTimeVerify, String tablename, String accountid, String currencyid, java.sql.Date begin, java.sql.Date end, boolean includeUnPosted, boolean includeFinished, ArrayList ids, StringBuffer selectHG) throws BOSException {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("insert into ").append(tablename);
        insertSql.append("( FCurrencyID, FDescription, FAssGrpId, FAcctCussentID, FBizNumber, FDebit, FCredit, FBalance, FDC, FLineType, FIsInit,FBizDate,FDate ) \r\n");
        String amountField = "";
        amountField = includeFinished ? "act.foriginalamount" : (isInTimeVerify && includeUnPosted ? "act.funholdedAmtFor" : "act.funverifiedamtfor");
        StringBuffer select = new StringBuffer();
        select.append("select act.FCurrencyId, act.FDescription, act.FAssGrpID, act.FID, FBizNumber,").append(" (case when account.FDC = 1 then ").append(amountField).append(" else 0 end),").append(" (case when account.FDC = -1 then ").append(amountField).append(" else 0 end),").append(" account.FDC * ").append(amountField).append(",").append(" account.FDC, ").append(0).append(", 1, \r\n");
        if (SQLUtil.isPG(ctx)) {
            select.append(" to_date(act.FBizDate), ");
            select.append(" to_date(act.FBookedDate)");
        } else {
            select.append(" act.FBookedDate,");
            select.append(" act.FBizDate ");
        }
        select.append("from t_gl_acctCussent act \r\n").append(" inner join t_bd_assistantHG hg on hg.fid = act.FAssGrpID \r\n").append(" inner join t_bd_accountView account on account.FID = act.FAccountID \r\n");
        select.append("where act.FAccountID = ? and act.FCompanyID = ? and act.FIsInit = 1 and act.FIsInitClosed = 1 ");
        select.append("and act.FBookedDate>=? and act.FBookedDate<=?  \r\n");
        if (!"AllCurrency".equals(currencyid)) {
            select.append(" and act.FCurrencyID = ? ");
        }
        select.append(selectHG);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(insertSql.toString() + select.toString());
            int index = 1;
            this.setParams_SelectAcSql(ps, index, accountid, companyid, currencyid, begin, end, ids);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"sql exception.", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
    }

    private void sumInitData(Context ctx, String tablename, int accountDC) throws SQLException, EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        try {
            sql.append("insert into ").append(tablename);
            sql.append(" ( FCurrencyID,FDebit,FCredit,FBalance,FLineType,FAssGrpId, FIsInit ) ");
            sql.append(" select t.FCurrencyID, sum(t.FDebit) FDebit, sum(t.FCredit) FCredit,                  \r\n").append("  sum(t.FBalance) FBalance,          \r\n").append("  -3 as FLineType ,t.FASSGRPID as FAssGrpId, 0          \r\n");
            sql.append(" from ").append(tablename).append(" t    \r\n");
            sql.append(" where t.fisinit = 1 and t.FLineType = - 3  \r\n");
            sql.append(" group by t.FCurrencyID, t.FASSGRPID  \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            String field = accountDC == 1 ? "FDebit" : "FCredit";
            sql.setLength(0);
            sql.append("update ").append(tablename).append(" set FBalance = FBalance +  ").append(field).append(" where flinetype = -3 and fisinit = 0 ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("delete from ").append(tablename).append(" where flinetype = -3 and fisinit = 1 ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("update ").append(tablename).append(" set fisinit = 1 ").append(" where flinetype = -3 and fisinit = 0 ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String createTempTable4Result(TempTablePool iPool, Connection con) throws BOSException, EASBizException {
        String tempateTable = null;
        StringBuffer sql = new StringBuffer();
        sql.append("( \r\n");
        sql.append("\tFBizDate DateTime, \r\n");
        sql.append("\tFDate DateTime, \r\n");
        sql.append("\tFAcctCussentID varChar(44), \r\n");
        sql.append("    FDC Int default 0, \r\n");
        sql.append("\tFVoucherID varChar(44), \r\n");
        sql.append("\tFVoucherNumber NVarchar(100), \r\n");
        sql.append("\tFVoucherType NVarchar(100),\r\n");
        sql.append("\tFDescription NVarchar(255), \r\n");
        sql.append("\tFCurrencyID varChar(44), \r\n");
        sql.append("\tFDebit Decimal(28,10), \r\n");
        sql.append("\tFCredit Decimal(28,10), \r\n");
        sql.append("\tFBalance Decimal(28,10), \r\n");
        sql.append("\tFLineType Int, \r\n");
        sql.append("    FVoucherAsstID varChar(44), \r\n");
        sql.append("    FAssGrpID varChar(44), \r\n");
        sql.append("    FBizNumber nvarChar(80), \r\n");
        sql.append("    FInvoiceNumber nvarChar(160), \r\n");
        sql.append("    FIsInit Int default 0 ) \r\n");
        tempateTable = this.createTempTableByDDL(iPool, con, "AcctCussentCheckResult", sql);
        return tempateTable;
    }

    private String createTempTable4VerifyDDL(TempTablePool iPool, Connection con) throws BOSException, EASBizException {
        String tempateTable = null;
        StringBuffer sql = new StringBuffer();
        sql.append("(   ");
        sql.append("\tFBizDate DateTime, ");
        sql.append("\tFDate DateTime, ");
        sql.append("\tFAcctCussentID varChar(44), ");
        sql.append("    FDC Int default 0, ");
        sql.append("\tFVoucherID varChar(44), ");
        sql.append("\tFVoucherNumber NVarchar(100), ");
        sql.append("\tFVoucherType NVarchar(100),");
        sql.append("\tFDescription NVarchar(255), ");
        sql.append("\tFCurrencyID varChar(44), ");
        sql.append("\tFDebit Decimal(28,10), ");
        sql.append("\tFCredit Decimal(28,10), ");
        sql.append("\tFBalance Decimal(28,10), ");
        sql.append("\tFLineType Int, ");
        sql.append("    FVoucherAsstID varChar(44), ");
        sql.append("    FAssGrpId varChar(44),");
        sql.append("    FBizNumber nvarChar(80), ");
        sql.append("    FInvoiceNumber nvarChar(160), ");
        sql.append("    FIsInit Int default 0) ");
        tempateTable = this.createTempTableByDDL(iPool, con, "AcctCussentCheckVerify", sql);
        return tempateTable;
    }

    private String createTempTable4Happen(TempTablePool iPool, Connection con) throws BOSException, EASBizException, SQLException {
        String tempateTable = null;
        StringBuffer sql = new StringBuffer();
        sql.append("(                   \r\n");
        sql.append("\tFCurrencyID varChar(44), \r\n");
        sql.append("\tFBalance Decimal(28,10) default(0) not null,  \r\n");
        sql.append("\tFAssGrpID varChar(44)    \r\n");
        sql.append(")                   \r\n");
        tempateTable = this.createTempTableByDDL(iPool, con, "AcctCussentCheckHappen", sql);
        try {
            sql.setLength(0);
            sql.append("create index I").append(tempateTable);
            sql.append(" on ").append(tempateTable);
            sql.append(" (FCurrencyID)");
            PreparedStatement ps = null;
            ps = con.prepareStatement(sql.toString());
            ps.execute();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return tempateTable;
    }

    @Override
    protected ArrayList _getAsstItemData(Context ctx, HashMap condition, String companyid) throws BOSException, EASBizException {
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        ArrayList result = new ArrayList();
        String accountid = (String)condition.get("accountid");
        String currencyid = (String)condition.get("currencyid");
        boolean isAllCurrency = "AllCurrency".equals(currencyid);
        ArrayList items = (ArrayList)condition.get("items");
        Date bizdatefrom = InitHelp.beginDay((Date)condition.get("bizdatefrom"));
        Date bizdateto = InitHelp.endDay((Date)condition.get("bizdateto"));
        int verifyMode = GlUtils.getVerifyMode(ctx, companyid);
        boolean isInTimeVerify = verifyMode == 0;
        boolean includeFinished = (Boolean)condition.get("includeFinished") == false;
        boolean hideNotHappened = (Boolean)condition.get("hideNotHappened");
        boolean includeUnPosted = (Boolean)condition.get("includeUnPosted");
        if (verifyMode == 2) {
            includeUnPosted = true;
        }
        StringBuffer select = new StringBuffer();
        select.append("select ");
        StringBuffer selectOut = new StringBuffer();
        selectOut.append("select ");
        StringBuffer join = new StringBuffer();
        StringBuffer joinInit = new StringBuffer();
        StringBuffer groupby = new StringBuffer();
        StringBuffer orderby = new StringBuffer();
        StringBuffer orderbyOut = new StringBuffer();
        String amountField_AC = "";
        amountField_AC = includeUnPosted && isInTimeVerify ? "cussent.funholdedAmtFor" : "cussent.funVerifiedAmtFor";
        StringBuffer from = new StringBuffer();
        StringBuffer fromInit = new StringBuffer();
        StringBuffer fromOther = new StringBuffer();
        StringBuffer where = new StringBuffer();
        StringBuffer whereInit = new StringBuffer();
        if (isInTimeVerify) {
            from.append(" from t_gl_acctcussent cussent  \r\n");
            from.append(" inner join t_gl_voucherassistrecord assist on cussent.fvchassistrecordid=assist.fid  \r\n");
            from.append(" inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid  \r\n");
            fromInit.append(from);
            from.append(" left join t_gl_voucher voucher on assist.fbillid=voucher.fid  \r\n");
            from.append(" left join t_bd_voucherTypes voucherType on voucherType.fid=voucher.fvouchertypeid  \r\n");
            fromOther.append(" from t_gl_acctcussent cussent  \r\n");
            fromOther.append(" inner join t_gl_voucherassistrecord assist on assist.fverifiedcussentid=cussent.fid  \r\n");
            fromOther.append(" inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid  \r\n");
            fromOther.append(" left join t_gl_voucher voucher on assist.fbillid=voucher.fid  \r\n");
            fromOther.append(" left join t_bd_voucherTypes voucherType on voucherType.fid=voucher.fvouchertypeid  \r\n");
            where.append(" where cussent.faccountid=? and cussent.fcompanyid=?   \r\n");
            whereInit.append(" where cussent.faccountid=? and cussent.fcompanyid=?  and (cussent.fisinit=1 and cussent.fisinitclosed=1)  \r\n");
            if (!isAllCurrency) {
                where.append(" and cussent.fcurrencyid=?  \r\n");
                whereInit.append(" and cussent.fcurrencyid=?  \r\n");
            }
        } else {
            from.append(" from t_gl_voucherassistrecord assist  \r\n");
            from.append(" inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid  \r\n");
            from.append(" inner join t_gl_acctcussent cussent on cussent.FVchAssistRecordID = assist.fid  \r\n");
            fromInit.append(from);
            from.append(" inner join t_gl_voucher voucher on assist.fbillid=voucher.fid  \r\n");
            from.append(" inner join t_gl_voucherEntry entry on entry.fbillid=voucher.fid  \r\n");
            from.append(" inner join t_bd_voucherTypes voucherType on voucherType.fid=voucher.fvouchertypeid  \r\n");
            where.append(" where cussent.faccountid=? and cussent.fcompanyid=?  and cussent.fisinit=0\r\n");
            whereInit.append(" where cussent.faccountid=? and cussent.fcompanyid=?  \r\n");
            whereInit.append("  and cussent.fisinit=1 and cussent.fisinitclosed=1  \r\n");
            if (!isAllCurrency) {
                where.append(" and cussent.fcurrencyid=?  \r\n");
                whereInit.append(" and cussent.fcurrencyid=?  \r\n");
            }
        }
        if (hideNotHappened) {
            where.append(" and voucher.FBookedDate>=? and voucher.FBookedDate<=?  \r\n");
            whereInit.append(" and assist.fbizdate>=? and assist.fbizdate<=?  \r\n");
        } else {
            where.append(" and voucher.FBookedDate<=?  \r\n");
            whereInit.append(" and assist.fbizdate<=?  \r\n");
        }
        if (includeUnPosted) {
            where.append(" and (voucher.fbizstatus<>? and voucher.fbizstatus<>?)  \r\n");
        } else {
            where.append(" and (voucher.fbizstatus=?)  \r\n");
        }
        EntityViewInfo mainQuery = (EntityViewInfo)condition.get("mainQuery");
        StringBuffer whereSelfDefine = this.transWhereSelfDefineToSQL(mainQuery, loc);
        StringBuffer whereSelfDefine_Assit = this.transWhereSelfDefineToSQL_Assist(mainQuery, loc);
        if (isInTimeVerify) {
            where.append(whereSelfDefine);
        } else {
            where.append(whereSelfDefine_Assit);
        }
        ArrayList<String> alNumbers = new ArrayList<String>();
        ArrayList<String> alTables = new ArrayList<String>();
        ArrayList<String> alFields = new ArrayList<String>();
        int gi = 0;
        int tablei = 0;
        HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
        hmParamIn.put("GL_064", null);
        HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hmParamIn);
        Object isShowLongNumberObj = hmAllParam.get("GL_064");
        boolean isShowLongNumber = false;
        if (isShowLongNumberObj != null) {
            isShowLongNumber = Boolean.valueOf(isShowLongNumberObj.toString());
        }
        for (HashMap item : items) {
            String table = (String)item.get("tablename");
            String field = (String)item.get("fieldname");
            String numberfrom = (String)item.get("numberfrom");
            String numberto = (String)item.get("numberto");
            Object dist = item.get("dist");
            boolean useLongNumber = (Boolean)item.get("useLongNUmber");
            alTables.add(table);
            alFields.add(field);
            join.append(" inner join ").append(table).append(" as ").append("T").append(tablei).append(" on hg.").append(field).append("=").append("T").append(tablei).append(".fid  \r\n");
            if (dist != null) {
                Object[] assists = null;
                assists = dist instanceof List ? ((List)dist).toArray() : ((Set)dist).toArray();
                if (assists != null && assists.length > 0) {
                    String fStr = "fnumber";
                    if (useLongNumber) {
                        fStr = "flongnumber";
                    }
                    join.append(" and ").append("T").append(tablei).append(".").append(fStr).append(" in (");
                    Object obj = null;
                    String number = null;
                    for (int i = 0; i < assists.length; ++i) {
                        obj = assists[i];
                        number = obj instanceof AssistViewFilterInfo ? ((AssistViewFilterInfo)obj).getNumber() : (obj instanceof Map ? (String)((Map)obj).get("number") : (String)obj);
                        if (useLongNumber) {
                            alNumbers.add(number.replace('.', '!'));
                        } else {
                            alNumbers.add(number);
                        }
                        join.append("?,");
                    }
                    join.deleteCharAt(join.lastIndexOf(",")).append(")");
                }
            } else {
                if (numberfrom != null) {
                    if (useLongNumber) {
                        alNumbers.add(numberfrom.replace('.', '!'));
                        join.append(" and ").append("T").append(tablei).append(".flongnumber>=?  \r\n");
                    } else {
                        alNumbers.add(numberfrom);
                        join.append(" and ").append("T").append(tablei).append(".fnumber>=?  \r\n");
                    }
                }
                if (numberto != null) {
                    if (useLongNumber) {
                        alNumbers.add(numberto.replace('.', '!'));
                        join.append(" and ").append("T").append(tablei).append(".flongnumber<=?  \r\n");
                    } else {
                        alNumbers.add(numberto);
                        join.append(" and ").append("T").append(tablei).append(".fnumber<=?  \r\n");
                    }
                }
            }
            if (gi == 0) {
                groupby.append(" group by ");
                orderby.append(" order by ");
                orderbyOut.append(" order by ");
            } else {
                groupby.append(" ,");
                orderby.append(" ,");
                orderbyOut.append(" ,");
            }
            groupby.append("T").append(tablei).append(".fid,").append(useLongNumber ? "replace(T" + tablei + ".FLongNumber,'!','.')," : "T" + tablei + ".Fnumber,").append("T").append(tablei).append(".fname_").append(loc);
            orderby.append(useLongNumber ? "replace(T" + tablei + ".FLongNumber,'!','.')" : "T" + tablei + ".Fnumber");
            orderbyOut.append("tout.T" + tablei + "Fnumber");
            select.append("T").append(tablei).append(".fid as ").append("T").append(tablei).append("fid,").append(useLongNumber ? "replace(T" + tablei + ".FLongNumber,'!','.')" : "T" + tablei + ".Fnumber").append(" as T").append(tablei).append("fnumber,").append("T").append(tablei).append(".fname_").append(loc).append(" as ").append("T").append(tablei).append("fname,");
            selectOut.append("T").append(tablei).append("fid,").append(" T").append(tablei).append("fnumber,").append("T").append(tablei).append("fname,");
            ++gi;
            ++tablei;
        }
        select.deleteCharAt(select.length() - 1);
        selectOut.deleteCharAt(selectOut.length() - 1);
        select.append("  \r\n");
        selectOut.append("  \r\n");
        StringBuffer sql = new StringBuffer();
        if (isInTimeVerify) {
            sql.append(selectOut).append(" from (  \r\n");
            sql.append(select).append(from).append(join).append(where).append(" and (cussent.fisinit=0) ").append(groupby);
            sql.append(" union  \r\n");
            sql.append(select).append(fromInit).append(join).append(whereInit).append(groupby);
            sql.append(" union  \r\n");
            sql.append(select).append(fromOther).append(join).append(where).append(groupby);
            sql.append(") tout  \r\n");
            sql.append(orderbyOut);
        } else {
            sql.append(select).append(from).append(join).append(where);
            sql.append(" union  \r\n").append(select).append(fromInit).append(join).append(whereInit);
            sql.append(groupby);
            sql.append(" order by ");
            for (int m = 0; m < items.size(); ++m) {
                if (m != 0) {
                    sql.append(",");
                }
                sql.append("T").append(m).append("fnumber ");
            }
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Calendar cal;
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql.toString());
            int index = 1;
            int count = alNumbers.size();
            for (int i = 0; i < count; ++i) {
                String number = (String)alNumbers.get(i);
                ps.setString(index++, number);
            }
            ps.setString(index++, accountid);
            ps.setString(index++, companyid);
            if (!isAllCurrency) {
                ps.setString(index++, currencyid);
            }
            if (hideNotHappened) {
                cal = Calendar.getInstance();
                cal.setTime(bizdatefrom);
                cal.add(13, 1);
                ps.setDate(index++, new java.sql.Date(cal.getTimeInMillis()));
                cal.setTime(bizdateto);
                ps.setDate(index++, new java.sql.Date(cal.getTimeInMillis()));
            } else {
                cal = Calendar.getInstance();
                cal.setTime(bizdateto);
                ps.setDate(index++, new java.sql.Date(cal.getTimeInMillis()));
            }
            if (includeUnPosted) {
                ps.setInt(index++, 0);
                ps.setInt(index++, 2);
            } else {
                ps.setInt(index++, 5);
            }
            if (isInTimeVerify) {
                for (int kk = 0; kk < 2; ++kk) {
                    Calendar cal2;
                    int count2 = alNumbers.size();
                    for (int i = 0; i < count2; ++i) {
                        String number = (String)alNumbers.get(i);
                        ps.setString(index++, number);
                    }
                    ps.setString(index++, accountid);
                    ps.setString(index++, companyid);
                    if (!isAllCurrency) {
                        ps.setString(index++, currencyid);
                    }
                    if (hideNotHappened) {
                        cal2 = Calendar.getInstance();
                        cal2.setTime(bizdatefrom);
                        cal2.add(13, 1);
                        ps.setDate(index++, new java.sql.Date(cal2.getTimeInMillis()));
                        cal2.setTime(bizdateto);
                        ps.setDate(index++, new java.sql.Date(cal2.getTimeInMillis()));
                    } else {
                        cal2 = Calendar.getInstance();
                        cal2.setTime(bizdateto);
                        ps.setDate(index++, new java.sql.Date(cal2.getTimeInMillis()));
                    }
                    if (kk != 1) continue;
                    if (includeUnPosted) {
                        ps.setInt(index++, 0);
                        ps.setInt(index++, 2);
                        continue;
                    }
                    ps.setInt(index++, 5);
                }
            } else {
                count = alNumbers.size();
                for (int i = 0; i < count; ++i) {
                    String number = (String)alNumbers.get(i);
                    ps.setString(index++, number);
                }
                ps.setString(index++, accountid);
                ps.setString(index++, companyid);
                if (!isAllCurrency) {
                    ps.setString(index++, currencyid);
                }
                if (hideNotHappened) {
                    Calendar cal3 = Calendar.getInstance();
                    cal3.setTime(bizdatefrom);
                    cal3.add(13, 1);
                    ps.setDate(index++, new java.sql.Date(cal3.getTimeInMillis()));
                    cal3.setTime(bizdateto);
                    ps.setDate(index++, new java.sql.Date(cal3.getTimeInMillis()));
                } else {
                    Calendar cal4 = Calendar.getInstance();
                    cal4.setTime(bizdateto);
                    ps.setDate(index++, new java.sql.Date(cal4.getTimeInMillis()));
                }
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ArrayList line = new ArrayList();
                int count3 = alTables.size();
                for (int i = 0; i < count3; ++i) {
                    String table = "T" + i;
                    String idkey = table + "fid";
                    String numkey = table + "fnumber";
                    String namekey = table + "fname";
                    HashMap<String, String> hm = new HashMap<String, String>();
                    hm.put("id", rs.getString(idkey));
                    hm.put("name", rs.getString(namekey));
                    hm.put("number", rs.getString(numkey));
                    line.add(hm);
                }
                result.add(line);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return result;
    }

    @Override
    protected HashMap _findInitData(Context ctx, String companyid) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CompanyOrgUnitInfo company = null;
        ICompanyOrgUnit ctrl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        company = ctrl.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyid)));
        PeriodInfo startPeriod = InitHelp.getStartPeriod(ctx, company);
        PeriodInfo currentPeriod = InitHelp.getCurrentPeriod(ctx, company);
        HashMap periodRange = InitHelp.getPeriodRange(ctx, startPeriod, currentPeriod, company);
        result.put("currentPeriod", currentPeriod);
        result.put("periodRange", periodRange);
        return result;
    }

    @Override
    protected void _cleanup(Context ctx, String tablename) throws BOSException {
        InitHelp.dropTempTable(ctx, tablename);
    }

    private StringBuffer getInsertAcSql(String tablename, boolean includeFinished) {
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT ");
        insert.append(tablename);
        insert.append("\r\n\t(FBizDate, FDate,FVoucherID,FVoucherNumber,FVoucherType, FDescription, FCurrencyID, FDebit, FCredit,  \r\n");
        insert.append("\tFBalance,FLineType,FVoucherAsstID,FAssGrpId,FBizNumber,FInvoiceNumber  \r\n");
        if (!includeFinished) {
            insert.append(",FAcctCussentID,FDC");
        }
        insert.append(")  \r\n");
        return insert;
    }

    private String getAsstItemSql(Context ctx, Map condition, String companyid, List params) throws EASBizException, BOSException {
        Calendar cal;
        String number;
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        ArrayList result = new ArrayList();
        String accountid = (String)condition.get("accountid");
        String currencyid = (String)condition.get("currencyid");
        boolean isAllCurrency = "AllCurrency".equals(currencyid);
        ArrayList items = (ArrayList)condition.get("items");
        Date bizdatefrom = InitHelp.beginDay((Date)condition.get("bizdatefrom"));
        Date bizdateto = InitHelp.endDay((Date)condition.get("bizdateto"));
        int verifyMode = GlUtils.getVerifyMode(ctx, companyid);
        boolean isInTimeVerify = verifyMode == 0;
        boolean includeFinished = (Boolean)condition.get("includeFinished") == false;
        boolean hideNotHappened = (Boolean)condition.get("hideNotHappened");
        boolean includeUnPosted = (Boolean)condition.get("includeUnPosted");
        if (verifyMode == 2) {
            includeUnPosted = true;
        }
        StringBuffer select = new StringBuffer();
        select.append("select ");
        StringBuffer selectOut = new StringBuffer();
        selectOut.append("select ");
        StringBuffer join = new StringBuffer();
        StringBuffer joinInit = new StringBuffer();
        StringBuffer groupby = new StringBuffer();
        StringBuffer orderby = new StringBuffer();
        StringBuffer orderbyOut = new StringBuffer();
        String amountField_AC = "";
        amountField_AC = includeUnPosted && isInTimeVerify ? "cussent.funholdedAmtFor" : "cussent.funVerifiedAmtFor";
        StringBuffer from = new StringBuffer();
        StringBuffer fromInit = new StringBuffer();
        StringBuffer fromOther = new StringBuffer();
        StringBuffer where = new StringBuffer();
        StringBuffer whereInit = new StringBuffer();
        if (isInTimeVerify) {
            from.append(" from t_gl_acctcussent cussent  \r\n");
            from.append(" inner join t_gl_voucherassistrecord assist on cussent.fvchassistrecordid=assist.fid  \r\n");
            from.append(" inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid  \r\n");
            fromInit.append(from);
            from.append(" left join t_gl_voucher voucher on assist.fbillid=voucher.fid  \r\n");
            from.append(" left join t_bd_voucherTypes voucherType on voucherType.fid=voucher.fvouchertypeid  \r\n");
            fromOther.append(" from t_gl_acctcussent cussent  \r\n");
            fromOther.append(" inner join t_gl_voucherassistrecord assist on assist.fverifiedcussentid=cussent.fid  \r\n");
            fromOther.append(" inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid  \r\n");
            fromOther.append(" left join t_gl_voucher voucher on assist.fbillid=voucher.fid  \r\n");
            fromOther.append(" left join t_bd_voucherTypes voucherType on voucherType.fid=voucher.fvouchertypeid  \r\n");
            where.append(" where cussent.faccountid=? and cussent.fcompanyid=?   \r\n");
            whereInit.append(" where cussent.faccountid=? and cussent.fcompanyid=?  and (cussent.fisinit=1 and cussent.fisinitclosed=1)  \r\n");
            if (!isAllCurrency) {
                where.append(" and cussent.fcurrencyid=?  \r\n");
                whereInit.append(" and cussent.fcurrencyid=?  \r\n");
            }
        } else {
            from.append(" from t_gl_voucherassistrecord assist  \r\n");
            from.append(" left outer join t_bd_assistanthg hg on assist.fassgrpid=hg.fid  \r\n");
            from.append(" left outer join t_gl_acctcussent cussent on cussent.FVchAssistRecordID = assist.fid  \r\n");
            fromInit.append(from);
            from.append(" left join t_gl_voucher voucher on assist.fbillid=voucher.fid  \r\n");
            from.append(" left join t_gl_voucherEntry entry on entry.fbillid=voucher.fid  \r\n");
            from.append(" left join t_bd_voucherTypes voucherType on voucherType.fid=voucher.fvouchertypeid  \r\n");
            where.append(" where assist.FBillID is not null and entry.faccountid=? and voucher.fcompanyid=?  \r\n");
            whereInit.append(" where assist.FBillID is null and cussent.faccountid=? and cussent.fcompanyid=?  \r\n");
            whereInit.append("  and cussent.fisinit=1 and cussent.fisinitclosed=1  \r\n");
            if (!isAllCurrency) {
                where.append(" and entry.fcurrencyid=?  \r\n");
                whereInit.append(" and cussent.fcurrencyid=?  \r\n");
            }
        }
        if (hideNotHappened) {
            where.append(" and voucher.FBookedDate>=? and voucher.FBookedDate<=?  \r\n");
            whereInit.append(" and assist.fbizdate>=? and assist.fbizdate<=?  \r\n");
        } else {
            where.append(" and voucher.FBookedDate<=?  \r\n");
            whereInit.append(" and assist.fbizdate<=?  \r\n");
        }
        if (includeUnPosted) {
            where.append(" and (voucher.fbizstatus<>? and voucher.fbizstatus<>?)  \r\n");
        } else {
            where.append(" and (voucher.fbizstatus=?)  \r\n");
        }
        EntityViewInfo mainQuery = (EntityViewInfo)condition.get("mainQuery");
        StringBuffer whereSelfDefine = this.transWhereSelfDefineToSQL(mainQuery, loc);
        StringBuffer whereSelfDefine_Assit = this.transWhereSelfDefineToSQL_Assist(mainQuery, loc);
        if (isInTimeVerify) {
            where.append(whereSelfDefine);
        } else {
            where.append(whereSelfDefine_Assit);
        }
        ArrayList<String> alNumbers = new ArrayList<String>();
        ArrayList<String> alTables = new ArrayList<String>();
        ArrayList<String> alFields = new ArrayList<String>();
        int gi = 0;
        int tablei = 0;
        HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
        hmParamIn.put("GL_064", null);
        HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hmParamIn);
        Object isShowLongNumberObj = hmAllParam.get("GL_064");
        boolean isShowLongNumber = false;
        if (isShowLongNumberObj != null) {
            isShowLongNumber = Boolean.valueOf(isShowLongNumberObj.toString());
        }
        for (HashMap item : items) {
            String table = (String)item.get("tablename");
            String field = (String)item.get("fieldname");
            String numberfrom = (String)item.get("numberfrom");
            String numberto = (String)item.get("numberto");
            Object dist = item.get("dist");
            boolean useLongNumber = (Boolean)item.get("useLongNUmber");
            alTables.add(table);
            alFields.add(field);
            join.append(" inner join ").append(table).append(" as ").append("T").append(tablei).append(" on hg.").append(field).append("=").append("T").append(tablei).append(".fid  \r\n");
            if (dist != null) {
                Object[] assists = null;
                assists = dist instanceof List ? ((List)dist).toArray() : ((Set)dist).toArray();
                if (assists != null && assists.length > 0) {
                    String fStr = "fnumber";
                    if (useLongNumber) {
                        fStr = "flongnumber";
                    }
                    join.append(" and ").append("T").append(tablei).append(".").append(fStr).append(" in (");
                    Object obj = null;
                    String number2 = null;
                    for (int i = 0; i < assists.length; ++i) {
                        obj = assists[i];
                        number2 = obj instanceof AssistViewFilterInfo ? ((AssistViewFilterInfo)obj).getNumber() : (obj instanceof Map ? (String)((Map)obj).get("number") : (String)obj);
                        if (useLongNumber) {
                            alNumbers.add(number2.replace('.', '!'));
                        } else {
                            alNumbers.add(number2);
                        }
                        join.append("?,");
                    }
                    join.deleteCharAt(join.lastIndexOf(",")).append(")");
                }
            } else {
                if (numberfrom != null) {
                    if (useLongNumber) {
                        alNumbers.add(numberfrom.replace('.', '!'));
                        join.append(" and ").append("T").append(tablei).append(".flongnumber>=?  \r\n");
                    } else {
                        alNumbers.add(numberfrom);
                        join.append(" and ").append("T").append(tablei).append(".fnumber>=?  \r\n");
                    }
                }
                if (numberto != null) {
                    if (useLongNumber) {
                        alNumbers.add(numberto.replace('.', '!'));
                        join.append(" and ").append("T").append(tablei).append(".flongnumber<=?  \r\n");
                    } else {
                        alNumbers.add(numberto);
                        join.append(" and ").append("T").append(tablei).append(".fnumber<=?  \r\n");
                    }
                }
            }
            if (gi == 0) {
                groupby.append(" group by ");
                orderby.append(" order by ");
                orderbyOut.append(" order by ");
            } else {
                groupby.append(" ,");
                orderby.append(" ,");
                orderbyOut.append(" ,");
            }
            groupby.append("T").append(tablei).append(".fid,").append(useLongNumber ? "replace(T" + tablei + ".FLongNumber,'!','.')," : "T" + tablei + ".Fnumber,").append("T").append(tablei).append(".fname_").append(loc);
            orderby.append(useLongNumber ? "replace(T" + tablei + ".FLongNumber,'!','.')" : "T" + tablei + ".Fnumber");
            orderbyOut.append("tout.T" + tablei + "Fnumber");
            select.append("T").append(tablei).append(".fid as ").append("T").append(tablei).append("fid,").append(useLongNumber ? "replace(T" + tablei + ".FLongNumber,'!','.')" : "T" + tablei + ".Fnumber").append(" as T").append(tablei).append("fnumber,").append("T").append(tablei).append(".fname_").append(loc).append(" as ").append("T").append(tablei).append("fname,");
            selectOut.append("T").append(tablei).append("fid,").append(" T").append(tablei).append("fnumber,").append("T").append(tablei).append("fname,");
            ++gi;
            ++tablei;
        }
        select.deleteCharAt(select.length() - 1);
        selectOut.deleteCharAt(selectOut.length() - 1);
        select.append("  \r\n");
        selectOut.append("  \r\n");
        StringBuffer sql = new StringBuffer();
        if (isInTimeVerify) {
            sql.append(selectOut).append(" from (  \r\n");
            sql.append(select).append(from).append(join).append(where).append(" and (cussent.fisinit=0) ").append(groupby);
            sql.append(" union  \r\n");
            sql.append(select).append(fromInit).append(join).append(whereInit).append(groupby);
            sql.append(" union  \r\n");
            sql.append(select).append(fromOther).append(join).append(where).append(groupby);
            sql.append(") tout  \r\n");
            sql.append(orderbyOut);
        } else {
            sql.append(select).append(from).append(join).append(where);
            sql.append(" union  \r\n").append(select).append(fromInit).append(join).append(whereInit);
            sql.append(groupby);
            sql.append(" order by ");
            for (int m = 0; m < items.size(); ++m) {
                if (m != 0) {
                    sql.append(",");
                }
                sql.append("T").append(m).append("fnumber ");
            }
        }
        int count = alNumbers.size();
        for (int i = 0; i < count; ++i) {
            number = (String)alNumbers.get(i);
            params.add(number);
        }
        params.add(accountid);
        params.add(companyid);
        if (!isAllCurrency) {
            params.add(currencyid);
        }
        if (hideNotHappened) {
            cal = Calendar.getInstance();
            cal.setTime(bizdatefrom);
            cal.add(13, 1);
            params.add(new java.sql.Date(cal.getTimeInMillis()));
            cal.setTime(bizdateto);
            params.add(new java.sql.Date(cal.getTimeInMillis()));
        } else {
            cal = Calendar.getInstance();
            cal.setTime(bizdateto);
            params.add(new java.sql.Date(cal.getTimeInMillis()));
        }
        if (includeUnPosted) {
            params.add(0);
            params.add(2);
        } else {
            params.add(5);
        }
        if (isInTimeVerify) {
            for (int kk = 0; kk < 2; ++kk) {
                Calendar cal2;
                int count2 = alNumbers.size();
                for (int i = 0; i < count2; ++i) {
                    String number3 = (String)alNumbers.get(i);
                    params.add(number3);
                }
                params.add(accountid);
                params.add(companyid);
                if (!isAllCurrency) {
                    params.add(currencyid);
                }
                if (hideNotHappened) {
                    cal2 = Calendar.getInstance();
                    cal2.setTime(bizdatefrom);
                    cal2.add(13, 1);
                    params.add(new java.sql.Date(cal2.getTimeInMillis()));
                    cal2.setTime(bizdateto);
                    params.add(new java.sql.Date(cal2.getTimeInMillis()));
                } else {
                    cal2 = Calendar.getInstance();
                    cal2.setTime(bizdateto);
                    params.add(new java.sql.Date(cal2.getTimeInMillis()));
                }
                if (kk != 1) continue;
                if (includeUnPosted) {
                    params.add(0);
                    params.add(2);
                    continue;
                }
                params.add(5);
            }
        } else {
            count = alNumbers.size();
            for (int i = 0; i < count; ++i) {
                number = (String)alNumbers.get(i);
                params.add(number);
            }
            params.add(accountid);
            params.add(companyid);
            if (!isAllCurrency) {
                params.add(currencyid);
            }
            if (hideNotHappened) {
                Calendar cal3 = Calendar.getInstance();
                cal3.setTime(bizdatefrom);
                cal3.add(13, 1);
                params.add(new java.sql.Date(cal3.getTimeInMillis()));
                cal3.setTime(bizdateto);
                params.add(new java.sql.Date(cal3.getTimeInMillis()));
            } else {
                Calendar cal4 = Calendar.getInstance();
                cal4.setTime(bizdateto);
                params.add(new java.sql.Date(cal4.getTimeInMillis()));
            }
        }
        return sql.toString();
    }

    private StringBuffer getSelectInitAcSql(String tablename, String loc, boolean isInTimeVerify, boolean includeUnPosted, boolean includeFinished, StringBuffer selectHG, String currencyid) {
        StringBuffer select = new StringBuffer();
        String amountField = "";
        amountField = includeFinished ? "cussent.foriginalamount" : (isInTimeVerify && includeUnPosted ? "cussent.funholdedAmtFor" : "cussent.funverifiedamtfor");
        select.append("select /*+ leading (hg) */ cussent.FVarBizDate,-1 as fisinit,cussent.fdescription,cussent.fcurrencyid,  \r\n");
        select.append("(case when account.fdc=1 then " + amountField + " else 0 end),  \r\n");
        select.append("(case when account.fdc=-1 then " + amountField + " else 0 end),   \r\n");
        select.append("account.fdc * ").append(amountField).append(",").append(0);
        select.append(",cussent.fid facctcussentid,account.fdc  \r\n");
        select.append("from t_gl_acctcussent cussent,t_bd_assistanthg hg,t_bd_accountview account  \r\n");
        select.append("where cussent.fisinit=1 and cussent.fisinitclosed=1 and cussent.fperiodid = ? and cussent.faccountid=account.fid  \r\n");
        select.append("and cussent.fassgrpid=hg.fid and cussent.faccountid=?  \r\n");
        select.append("and cussent.fcompanyid=? ").append(" and cussent.FVarBizDate>=? and cussent.FVarBizDate<=?  \r\n");
        if (!"AllCurrency".equals(currencyid)) {
            select.append("and cussent.fcurrencyid=?  \r\n");
        }
        select.append(selectHG);
        return select;
    }

    private StringBuffer getSelectAcVeriSql(Context ctx, String tablename, String loc, boolean isInTimeVerify, boolean includeUnPosted, boolean includeFinished, StringBuffer selectHG, String currencyid) {
        String amountField = "assist.foriginalamount";
        StringBuffer select = new StringBuffer();
        select.append(" select /*+ leading (hg) */ ");
        if (SQLUtil.isPG(ctx)) {
            select.append(" to_date(assist.FBizDate), ");
        } else {
            select.append(" assist.FBizDate, ");
        }
        if (SQLUtil.isPG(ctx)) {
            select.append(" to_date(voucher.FBookedDate) ");
        } else {
            select.append(" voucher.FBookedDate ");
        }
        select.append(",voucher.fid,voucher.fnumber,vouchertype.fname_").append(loc).append("  \r\n");
        select.append(",assist.fdescription,entry.fcurrencyid,  \r\n");
        select.append("(case when entry.fentrydc=1 then ").append(amountField).append(" else 0 end),  \r\n");
        select.append("(case when entry.fentrydc=0 then ").append(amountField).append(" else 0 end),  \r\n");
        select.append("(entry.fentrydc*2-1)*").append(amountField).append(",  \r\n");
        select.append(0);
        select.append(" ,assist.fid,assist.fassgrpid,assist.FBizNumber,assist.FInvoiceNumber  \r\n");
        select.append(" from t_gl_voucherassistrecord assist  \r\n");
        select.append(" inner join t_gl_voucherentry entry on assist.fentryid=entry.fid  \r\n");
        select.append(" inner join t_gl_voucher voucher on voucher.fid = entry.fbillid  \r\n");
        select.append(" inner join v_gl_acperiod acperiod on acperiod.fperiodid = voucher.fperiodid and acperiod.fcompanyid=voucher.fcompanyid  \r\n");
        select.append(" inner join t_bd_vouchertypes vouchertype on voucher.fvouchertypeid=vouchertype.fid  \r\n");
        select.append(" inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid  \r\n");
        select.append(" inner join t_bd_accountview account on entry.faccountid = account.fid  \r\n");
        this.addPeriodControl(select);
        select.append("where entry.faccountid=? and voucher.fcompanyid=?  \r\n");
        select.append("and voucher.FBookedDate>=? and voucher.FBookedDate<=?  \r\n");
        if (isInTimeVerify) {
            if (!includeUnPosted) {
                select.append(" and voucher.fbizstatus=5 ");
            } else {
                select.append(" and (entry.fentrydc*2-1 = account.fdc   \r\n");
                select.append("   and voucher.fbizstatus=5 ");
                select.append("   or entry.fentrydc*2-1 <> account.fdc   \r\n");
                select.append("   and voucher.fbizstatus<>0 and voucher.fbizstatus<>2 ");
                select.append("   )                                      \r\n");
            }
        } else if (!includeUnPosted) {
            select.append("   and voucher.fbizstatus=5 ");
        } else {
            select.append("   and voucher.fbizstatus<>0 and voucher.fbizstatus<>2 ");
        }
        if (!"AllCurrency".equals(currencyid)) {
            select.append("\r\n and entry.fcurrencyid=?   \r\n");
        }
        select.append(selectHG);
        return select;
    }

    private StringBuffer getSelectOnlyAcSql(Context ctx, String tablename, String loc, boolean isInTimeVerify, boolean includeUnPosted, boolean includeFinished, StringBuffer selectHG, String currencyid) {
        StringBuffer select = new StringBuffer();
        String amountField = "";
        amountField = includeFinished ? "cussent.foriginalamount" : (isInTimeVerify && includeUnPosted ? "cussent.funholdedAmtFor" : "cussent.funverifiedamtfor");
        select.append(" select /*+ leading (hg) */ ");
        if (SQLUtil.isPG(ctx)) {
            select.append(" to_date(cussent.FVarBizDate) as FBizDate,");
        } else {
            select.append(" cussent.FVarBizDate as FBizDate,");
        }
        if (SQLUtil.isPG(ctx)) {
            select.append(" to_date(cussent.FBookedDate)");
        } else {
            select.append(" cussent.FBookedDate");
        }
        select.append(",cussent.fvoucherid,cussent.fvchnumber,vouchertype.fname_").append(loc);
        select.append(",cussent.fdescription,cussent.fcurrencyid,(case when cussent.fentrydc=1 then " + amountField + " else 0 end),");
        select.append("(case when cussent.fentrydc=0 then ").append(amountField).append(" else 0 end),");
        select.append("(cussent.fentrydc*2-1)*").append(amountField).append(",").append(0);
        select.append(" ,cussent.fvchassistrecordid,cussent.fassgrpid,cussent.FBizNumber,cussent.FInvoiceNumber");
        if (!includeFinished) {
            select.append(",cussent.fid facctcussentid,account.fdc  \r\n");
        }
        select.append(" from t_gl_acctcussent cussent  \r\n");
        select.append(" inner join v_gl_acperiod acperiod on acperiod.fperiodid = cussent.fperiodid and acperiod.fcompanyid=cussent.fcompanyid  \r\n");
        select.append(" inner join t_bd_vouchertypes vouchertype on cussent.fvouchertypeid=vouchertype.fid  \r\n");
        select.append(" inner join t_bd_assistanthg hg on cussent.fassgrpid=hg.fid  \r\n");
        select.append(" inner join t_bd_accountview account on cussent.faccountid = account.fid  \r\n");
        select.append("where cussent.fcompanyid=? and cussent.faccountid=?  \r\n");
        select.append("and cussent.FBookedDate>=? and cussent.FBookedDate<=?  \r\n");
        if (!includeUnPosted) {
            select.append(" and cussent.fisPost = 1  \r\n");
        } else {
            select.append(" and cussent.fisPost > -1  \r\n");
        }
        if (!(includeFinished || isInTimeVerify && includeUnPosted)) {
            select.append(" and cussent.funverifiedamtfor<>0 ");
        }
        if (!"AllCurrency".equals(currencyid)) {
            select.append(" and cussent.fcurrencyid=?  \r\n");
        }
        select.append(selectHG);
        return select;
    }

    private StringBuffer getVeriSql_InTime(String tablename, String loc, boolean isInTimeVerify, boolean includeUnPosted, boolean includeFinished, StringBuffer selectHG, String currencyid) {
        StringBuffer selectVeri = new StringBuffer();
        StringBuffer select = this.getVeriSql_Select(loc, includeFinished);
        StringBuffer from = this.getVeriSql_From();
        from.append(" left join ").append(tablename).append("  \r\n");
        from.append(" tmp on tmp.FAcctCussentID = assist.fverifiedcussentid \r\n");
        StringBuffer where = this.getVeriSql_Where(isInTimeVerify, includeUnPosted, includeFinished, selectHG, currencyid);
        where.append(" and tmp.FAcctCussentID is null  \r\n");
        selectVeri.append(select).append(from).append(where);
        return selectVeri;
    }

    private void prepareVerifyData(Context ctx, TempTablePool iPool, Connection con, int accountDC, String tablename, String tempTableVerify, String tempTableVerified, String loc, boolean isInTimeVerify, boolean includeUnPosted, boolean includeFinished, String companyid, String accountid, String currencyid, StringBuffer selectHG, java.sql.Date beginDate, java.sql.Date endDate, ArrayList ids) throws SQLException, EASBizException, BOSException {
        StringBuffer selectVeri = new StringBuffer();
        StringBuffer sqlSumVeri = this.getVeriSql_NotInTime(tempTableVerify, loc, isInTimeVerify, includeUnPosted, includeFinished, selectHG, currencyid);
        this.insertIntoTempTable_Veri_Verify(con, tempTableVerify, sqlSumVeri, companyid, accountid, currencyid, includeFinished, beginDate, endDate, ids);
        StringBuffer sqlHistorySql4Verified = this.getHistorySql4Verified(tempTableVerify);
        this.insertIntoTempTable_Veri_Verified(con, tempTableVerified, sqlHistorySql4Verified, beginDate, endDate);
        this.updateTempTable_Veri_VerifyFromVerified(con, accountDC, tempTableVerify, tempTableVerified);
        this.insertIntoTempTable_Ac_FromVerify(ctx, con, tablename, tempTableVerify, includeFinished);
    }

    private void prepareVerifyData_New(Context ctx, TempTablePool iPool, Connection con, int accountDC, String tablename, String tempTableVerify, String tempTableVerified, String loc, boolean isInTimeVerify, boolean includeUnPosted, boolean includeFinished, String companyid, String accountid, String currencyid, StringBuffer selectHG, java.sql.Date beginDate, java.sql.Date endDate, ArrayList ids) throws SQLException, EASBizException, BOSException {
        StringBuffer selectVeri = new StringBuffer();
        StringBuffer sqlSumVeri = this.getVeriSql(ctx, currencyid, selectHG, loc, isInTimeVerify, includeFinished, includeUnPosted);
        this.insertIntoTempTable_Veri_Verify(con, tempTableVerify, sqlSumVeri, companyid, accountid, currencyid, includeFinished, beginDate, endDate, ids);
        StringBuffer sqlHistorySql4Verified = this.getHistorySql4Verified_New(tempTableVerify);
        this.insertIntoTempTable_Veri_Verified(con, tempTableVerified, sqlHistorySql4Verified, beginDate, endDate);
        this.updateTempTable_Veri_VerifyFromVerified_New(con, accountDC, tempTableVerify, tempTableVerified);
        this.insertIntoTempTable_Ac_FromVerify(ctx, con, tablename, tempTableVerify, includeFinished);
    }

    private StringBuffer getVeriSql(Context ctx, String currencyid, StringBuffer selectHG, String loc, boolean isInTimeVerify, boolean includeFinished, boolean includeUnPosted) {
        StringBuffer selectVeri = new StringBuffer();
        String amountField = includeFinished ? "assist.foriginalamount" : "assist.funverifiedamtfor";
        selectVeri.append(" select /*+ leading (hg) */");
        if (SQLUtil.isPG(ctx)) {
            selectVeri.append(" to_date(assist.FVarBizDate) as FBizDate,");
        } else {
            selectVeri.append(" assist.FVarBizDate as FBizDate,");
        }
        if (SQLUtil.isPG(ctx)) {
            selectVeri.append(" to_date(assist.FBookedDate)");
        } else {
            selectVeri.append(" assist.FBookedDate");
        }
        selectVeri.append(",assist.fvoucherid,assist.fvchnumber,vouchertype.fname_").append(loc).append("  \r\n");
        selectVeri.append(",assist.fdescription,assist.fcurrencyid,  \r\n");
        selectVeri.append("(case when assist.fentrydc=1 then ").append(amountField).append(" else 0 end),  \r\n");
        selectVeri.append("(case when assist.fentrydc=0 then ").append(amountField).append(" else 0 end),  \r\n");
        selectVeri.append("(assist.fentrydc*2-1)* ").append(amountField).append(" ,  \r\n");
        selectVeri.append(0);
        selectVeri.append(",assist.fvchassistrecordid,assist.fassgrpid,assist.FBizNumber,assist.FInvoiceNumber  \r\n");
        if (!includeFinished) {
            selectVeri.append(",null,account.fdc  \r\n");
        }
        selectVeri.append(" from t_gl_acctverify assist  \r\n");
        selectVeri.append(" inner join v_gl_acperiod acperiod on acperiod.fperiodid = assist.fperiodid and acperiod.fcompanyid=assist.fcompanyid  \r\n");
        selectVeri.append(" inner join t_bd_vouchertypes vouchertype on assist.fvouchertypeid=vouchertype.fid  \r\n");
        selectVeri.append(" inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid  \r\n");
        selectVeri.append(" inner join t_bd_accountview account on assist.faccountid = account.fid  \r\n");
        selectVeri.append("where assist.faccountid=? and assist.fcompanyid=?  \r\n");
        selectVeri.append("and assist.FBookedDate>=? and assist.FBookedDate<=?  \r\n");
        if (isInTimeVerify && !includeUnPosted) {
            selectVeri.append(" and assist.fisPost = 1  \r\n");
        } else {
            selectVeri.append(" and assist.fisPost > -1  \r\n");
        }
        if (!"AllCurrency".equals(currencyid)) {
            selectVeri.append(" and assist.fcurrencyid=?  \r\n");
        }
        if (!includeFinished) {
            selectVeri.append(" and assist.funverifiedamtfor<>0 \r\n");
        }
        selectVeri.append(selectHG);
        return selectVeri;
    }

    private StringBuffer getHistorySql4Verified_New(String tempTableVerify) throws BOSException, EASBizException {
        StringBuffer historySql = new StringBuffer();
        historySql.append("select FVoucherAsstIDID, sum(FSumVeri) FSumVeri");
        historySql.append(" from ( \r\n");
        historySql.append(" select khis.FVOUCHERASSTIDID,isnull(sum(khis.FOroginalAmount),0) FSumVeri ");
        historySql.append(" from t_gl_acctcussenthistory khis        \r\n");
        historySql.append(" INNER JOIN ").append(tempTableVerify).append(" veri on khis.FVOUCHERASSTIDID = veri.FVOUCHERASSTID    \r\n");
        if (this.includeInitData) {
            historySql.append(" where khis.fdc IN (0, 2) AND khis.fvchdate > ?  \r\n");
        } else {
            historySql.append(" where khis.fdc IN (0, 2) AND (khis.fvchdate < ? or khis.fvchdate > ?)  \r\n");
        }
        historySql.append(" group by khis.FVOUCHERASSTIDID  \r\n");
        historySql.append(" UNION ALL  \r\n");
        historySql.append(" select khis.FCUSSENTIDID,isnull(sum(khis.FOroginalAmount),0) FSumVeri ");
        historySql.append(" from t_gl_acctcussenthistory khis        \r\n");
        historySql.append(" INNER JOIN ").append(tempTableVerify).append(" veri on khis.FCUSSENTIDID = veri.FVOUCHERASSTID    \r\n");
        if (this.includeInitData) {
            historySql.append(" where khis.fdc = 3 AND khis.FVerVchDate > ?  \r\n");
        } else {
            historySql.append(" where khis.fdc = 3 AND (khis.FVerVchDate < ? or khis.FVerVchDate > ?)  \r\n");
        }
        historySql.append(" group by khis.FCUSSENTIDID \r\n");
        historySql.append(" )t  \r\n");
        historySql.append("group by FVOUCHERASSTIDID  \r\n");
        return historySql;
    }

    private int getAccountDC(Connection con, String accountid) throws SQLException {
        int dc = 1;
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select fdc from t_bd_accountview where fid = ?");
        ps = con.prepareStatement(sql.toString());
        ps.setString(1, accountid);
        rs = ps.executeQuery();
        if (rs.next()) {
            dc = rs.getInt("fdc");
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        return dc;
    }

    private StringBuffer getVeriSql_NotInTime(String tablename, String loc, boolean isInTimeVerify, boolean includeUnPosted, boolean includeFinished, StringBuffer selectHG, String currencyid) {
        StringBuffer selectVeri = new StringBuffer();
        StringBuffer select = this.getVeriSql_Select(loc, includeFinished);
        StringBuffer from = this.getVeriSql_From();
        StringBuffer where = this.getVeriSql_Where(isInTimeVerify, includeUnPosted, includeFinished, selectHG, currencyid);
        selectVeri.append(select).append(from).append(where);
        return selectVeri;
    }

    private StringBuffer getVeriSql_Select(String loc, boolean includeFinished) {
        StringBuffer selectVeri = new StringBuffer();
        String amountField = "assist.foriginalamount";
        selectVeri.append(" select /*+ leading (hg) */ voucher.FBookedDate,voucher.fid,voucher.fnumber,vouchertype.fname_").append(loc).append("  \r\n");
        selectVeri.append(",assist.fdescription,entry.fcurrencyid,  \r\n");
        selectVeri.append("(case when entry.fentrydc=1 then ").append(amountField).append(" else 0 end),  \r\n");
        selectVeri.append("(case when entry.fentrydc=0 then ").append(amountField).append(" else 0 end),  \r\n");
        selectVeri.append("(entry.fentrydc*2-1)*").append(amountField).append(",  \r\n");
        selectVeri.append(0);
        selectVeri.append(",assist.fid,assist.fassgrpid,assist.FBizNumber,assist.FInvoiceNumber  \r\n");
        if (!includeFinished) {
            selectVeri.append(",null,account.fdc  \r\n");
        }
        return selectVeri;
    }

    private StringBuffer getVeriSql_From() {
        StringBuffer selectVeri = new StringBuffer();
        selectVeri.append(" from t_gl_voucherassistrecord assist  \r\n");
        selectVeri.append(" inner join t_gl_voucherentry entry on assist.fentryid=entry.fid  \r\n");
        selectVeri.append(" inner join t_gl_voucher voucher on voucher.fid = entry.fbillid  \r\n");
        selectVeri.append(" inner join v_gl_acperiod acperiod on acperiod.fperiodid = voucher.fperiodid and acperiod.fcompanyid=voucher.fcompanyid  \r\n");
        selectVeri.append(" inner join t_bd_vouchertypes vouchertype on voucher.fvouchertypeid=vouchertype.fid  \r\n");
        selectVeri.append(" inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid  \r\n");
        selectVeri.append(" inner join t_bd_accountview account on entry.faccountid = account.fid  \r\n");
        this.addPeriodControl(selectVeri);
        return selectVeri;
    }

    private void addPeriodControl(StringBuffer selectVeri) {
        selectVeri.append(" inner join t_gl_flag flag on flag.fname = 'cussentinit' and flag.forgunitid = voucher.fcompanyid and flag.fkey = account.fid  \r\n");
        selectVeri.append(" inner join t_bd_period pflag on pflag.fid = flag.finitperiodid  \r\n");
        selectVeri.append(" inner join t_bd_period pvch on pvch.fid = voucher.fperiodid and pvch.fnumber >= pflag.fnumber \r\n");
    }

    private StringBuffer getVeriSql_Where(boolean isInTimeVerify, boolean includeUnPosted, boolean includeFinished, StringBuffer selectHG, String currencyid) {
        StringBuffer selectVeri = new StringBuffer();
        selectVeri.append("where entry.faccountid=? and voucher.fcompanyid=?  \r\n");
        selectVeri.append("and voucher.FBookedDate>=? and voucher.FBookedDate<=?  \r\n");
        if (isInTimeVerify && !includeUnPosted) {
            selectVeri.append(" and voucher.fbizstatus=5  \r\n");
        } else {
            selectVeri.append(" and voucher.fbizstatus<>0 and voucher.fbizstatus<>2  \r\n");
        }
        if (!"AllCurrency".equals(currencyid)) {
            selectVeri.append(" and entry.fcurrencyid=?  \r\n");
        }
        selectVeri.append(" and entry.fentrydc*2-1 <> account.fdc  \r\n");
        selectVeri.append(selectHG);
        return selectVeri;
    }

    private String createTempTableByDDL(TempTablePool iPool, Connection con, String keyDesc, StringBuffer strFields) throws BOSException, EASBizException {
        StringBuffer createTable = new StringBuffer();
        createTable.append("CREATE TABLE ").append(keyDesc).append(strFields);
        String tempateTable = "";
        try {
            tempateTable = iPool.createTempTable(createTable.toString());
            InitHelp.truncate(con, tempateTable);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return tempateTable;
    }

    private String createTempTable4Verify(TempTablePool iPool, Connection con) throws BOSException, EASBizException, SQLException {
        String tempateTable = null;
        tempateTable = this.createTempTable4VerifyDDL(iPool, con);
        StringBuffer sql = new StringBuffer();
        try {
            sql.setLength(0);
            sql.append("create index I").append(tempateTable);
            sql.append(" on ").append(tempateTable);
            sql.append(" (FVoucherAsstID)");
            PreparedStatement ps = null;
            ps = con.prepareStatement(sql.toString());
            ps.execute();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return tempateTable;
    }

    private String createTempTable4Verified(TempTablePool iPool, Connection con) throws BOSException, EASBizException, SQLException {
        String tempateTable = null;
        StringBuffer sql = new StringBuffer();
        sql.append("(                            \r\n");
        sql.append("    FVoucherAsstID varChar(44), \r\n");
        sql.append("\tFSumVeri Decimal(28,10) \r\n");
        sql.append(")                            \r\n");
        tempateTable = this.createTempTableByDDL(iPool, con, "AcctCussentCheckVerified", sql);
        try {
            sql.setLength(0);
            sql.append("create index I").append(tempateTable);
            sql.append(" on ").append(tempateTable);
            sql.append(" (FVoucherAsstID)");
            PreparedStatement ps = null;
            ps = con.prepareStatement(sql.toString());
            ps.execute();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return tempateTable;
    }

    private void returnBackFutureVerify(Context ctx, Connection con, int accountDC, String acTempateTable, String companyid, String accountid, String currencyid, boolean isInTimeVerify, boolean includeUnPosted, java.sql.Date beginDate, java.sql.Date endDate) throws BOSException, EASBizException {
        PreparedStatement ps = null;
        Object rs = null;
        try {
            Calendar _cal = Calendar.getInstance();
            java.sql.Date _day1 = null;
            java.sql.Date _day2 = null;
            StringBuffer totalSql = new StringBuffer();
            if (isInTimeVerify) {
                totalSql.append("ISNULL( (select ISNULL( SUM(R.Foriginalamount),0) ").append(" FROM t_gl_voucherassistrecord R ").append(" INNER JOIN t_gl_voucher V ON v.fid = r.fbillid ").append(" WHERE R.Fverifiedcussentid  = tmp.facctcussentid ").append(" AND (v.FBookedDate < ? or v.FBookedDate > ? )  ");
                if (!includeUnPosted) {
                    totalSql.append(" AND v.fbizstatus = 5 ");
                } else {
                    totalSql.append(" AND v.fbizstatus <> 0 AND v.fbizstatus <> 2 ");
                }
                totalSql.append(" GROUP BY R.Fverifiedcussentid) ,0) ");
            } else {
                totalSql.append("ISNULL( (select ISNULL(SUM(k.foroginalamount),0) FROM t_gl_acctcussenthistory k \r\n").append(" WHERE k.fcussentidid = tmp.facctcussentid AND k.fdc IN (0, 2)  ").append(" \tAND (k.FVerVchDate < ? or k.FVerVchDate > ? )  GROUP BY k.fcussentidid)  ").append(" ,0) + ISNULL( (SELECT ISNULL(SUM(k.foroginalamount),0) FROM t_gl_acctcussenthistory k ").append(" WHERE k.fcussentidid = tmp.facctcussentid AND k.fdc = 1 ");
                if (this.includeInitData) {
                    totalSql.append(" AND k.FVeriVchID IS NOT NULL ");
                }
                totalSql.append(" AND (k.FVerVchDate < ? or k.FVerVchDate > ? ) GROUP BY k.fcussentidid) ,0) ");
            }
            int paramCount = 1;
            if (!isInTimeVerify) {
                paramCount = 2;
            }
            _cal = Calendar.getInstance();
            _cal.setTime(DateTimeUtils.truncateDate((Date)beginDate));
            _day1 = new java.sql.Date(_cal.getTime().getTime());
            _cal.setTime(DateTimeUtils.truncateDate((Date)endDate));
            _day2 = new java.sql.Date(_cal.getTime().getTime());
            ArrayList<java.sql.Date> lstDates = new ArrayList<java.sql.Date>();
            lstDates.clear();
            lstDates.add(_day1);
            lstDates.add(_day2);
            String sql = "";
            sql = accountDC == 1 ? "UPDATE " + acTempateTable + " tmp SET FDebit = FDebit +                 \r\n" + totalSql.toString() + "where tmp.FDC = 1" : "UPDATE " + acTempateTable + " tmp SET FCredit = FCredit +                 \r\n" + totalSql.toString() + "where tmp.FDC = -1";
            ps = con.prepareStatement(sql);
            this.setParams_getHistorySql_update(ps, lstDates, paramCount);
            ps.execute();
            ps.close();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
    }

    private String createTempTable4QueryHistory(TempTablePool iPool, Connection con) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("( FCUSSENTID varchar (44) NOT NULL,fdc int");
        sql.append(",sumVeri numeric(28,10) not null default 0");
        sql.append(")");
        String tempateTable = this.createTempTableByDDL(iPool, con, "AcctCussentCheckHistory", sql);
        return tempateTable;
    }

    private boolean checkDbTypeIsOracleDB2(Context ctx) {
        boolean isOracleDB2 = false;
        String strDbType = ContextUtil.getDbType((Context)ctx);
        if (strDbType.compareToIgnoreCase("oracle") == 0 || strDbType.compareToIgnoreCase("db2") == 0) {
            isOracleDB2 = true;
        }
        return isOracleDB2;
    }

    private void setParams_getHistorySql_update(PreparedStatement ps, List lstDates, int paramCount) throws SQLException {
        int index = 1;
        Iterator it = null;
        for (int iparam = 0; iparam < paramCount; ++iparam) {
            it = lstDates.iterator();
            while (it.hasNext()) {
                ps.setDate(index++, (java.sql.Date)it.next());
            }
        }
    }

    private void setParams_SelectOnlyAcSql(boolean isDbTypeOracleDB2, PreparedStatement ps, int index, String accountid, String companyid, String currencyid, java.sql.Date begin, java.sql.Date end, ArrayList ids) throws SQLException {
        ps.setString(index++, companyid);
        ps.setString(index++, accountid);
        ps.setDate(index++, begin);
        ps.setDate(index++, end);
        if (!"AllCurrency".equals(currencyid)) {
            ps.setString(index++, currencyid);
        }
        for (int i = 0; i < ids.size(); ++i) {
            ps.setString(index++, (String)ids.get(i));
        }
    }

    private void setParams_SelectAcSql(PreparedStatement ps, int index, String accountid, String companyid, String currencyid, java.sql.Date begin, java.sql.Date end, ArrayList ids) throws SQLException {
        ps.setString(index++, accountid);
        ps.setString(index++, companyid);
        ps.setDate(index++, begin);
        ps.setDate(index++, end);
        if (!"AllCurrency".equals(currencyid)) {
            ps.setString(index++, currencyid);
        }
        for (int i = 0; i < ids.size(); ++i) {
            ps.setString(index++, (String)ids.get(i));
        }
    }

    private void setParams_SelectInitAcSql(boolean isDbTypeOracleDB2, PreparedStatement ps, int index, String accountid, String companyid, String currencyid, java.sql.Date begin, java.sql.Date end, ArrayList ids) throws SQLException {
        ps.setString(index++, "AAAAAAAAAAAAAAAAAAAAAII4jEw=");
        ps.setString(index++, accountid);
        ps.setString(index++, companyid);
        ps.setDate(index++, begin);
        ps.setDate(index++, end);
        if (!"AllCurrency".equals(currencyid)) {
            ps.setString(index++, currencyid);
        }
        for (int i = 0; i < ids.size(); ++i) {
            ps.setString(index++, (String)ids.get(i));
        }
    }

    private StringBuffer transWhereSelfDefineToSQL(EntityViewInfo mainQuery, String loc) {
        StringBuffer where = new StringBuffer();
        String preTable = "cussent.";
        String preTableVch = "voucher.";
        String preTableDC = "cussent.";
        if (mainQuery == null) {
            return where;
        }
        FilterInfo filterInfo = mainQuery.getFilter();
        String filter = filterInfo.toString();
        if (StringUtils.isEmpty((String)filter)) {
            return where;
        }
        if (filter.indexOf("VARBizDate") != -1) {
            filter = filter.replaceAll("VARBizDate", preTable + "FVarBizDate");
        }
        if (filter.indexOf("bizNumber") != -1) {
            filter = filter.replaceAll("bizNumber", preTable + "fbizNumber");
        }
        if (filter.indexOf("invoiceNumber") != -1) {
            filter = filter.replaceAll("invoiceNumber", preTable + "finvoiceNumber");
        }
        if (filter.indexOf("entrydc") != -1) {
            filter = filter.replaceAll("entrydc", preTableDC + "fentrydc");
        }
        if (filter.indexOf("originalAmount") != -1) {
            filter = filter.replaceAll("originalAmount", preTable + "foriginalAmount");
        }
        if (filter.indexOf("voucherType.name") != -1) {
            filter = filter.replaceAll("voucherType.name", "voucherType.fname_" + loc);
        }
        if (filter.indexOf("voucher.number") != -1) {
            filter = filter.replaceAll("voucher.number", preTableVch + "fnumber");
        }
        if (filter.indexOf("description") != -1) {
            filter = filter.replaceAll("description", preTable + "fdescription");
        }
        if (filter.indexOf("debitAmount") != -1) {
            filter = filter.replaceAll("debitAmount", "(case " + preTableDC + "fentrydc when 1 then " + preTable + "foriginalAmount else 0 end)");
        }
        if (filter.indexOf("creditAmount") != -1) {
            filter = filter.replaceAll("creditAmount", "(case " + preTableDC + "fentrydc when 0 then " + preTable + "foriginalAmount else 0 end)");
        }
        where.append(" and ").append(filter).append("  \r\n");
        return where;
    }

    private StringBuffer transWhereSelfDefineToSQL_Assist(EntityViewInfo mainQuery, String loc) {
        StringBuffer where = new StringBuffer();
        String preTable = "assist.";
        String preTableVch = "voucher.";
        String preTableDC = "entry.";
        if (mainQuery == null) {
            return where;
        }
        FilterInfo filterInfo = mainQuery.getFilter();
        String filter = filterInfo.toString();
        if (StringUtils.isEmpty((String)filter)) {
            return where;
        }
        if (filter.indexOf("VARBizDate") != -1) {
            filter = filter.replaceAll("VARBizDate", preTable + "FBizDate");
        }
        if (filter.indexOf("bizNumber") != -1) {
            filter = filter.replaceAll("bizNumber", preTable + "fbizNumber");
        }
        if (filter.indexOf("invoiceNumber") != -1) {
            filter = filter.replaceAll("invoiceNumber", preTable + "finvoiceNumber");
        }
        if (filter.indexOf("entrydc") != -1) {
            filter = filter.replaceAll("entrydc", preTableDC + "fentrydc");
        }
        if (filter.indexOf("originalAmount") != -1) {
            filter = filter.replaceAll("originalAmount", preTable + "foriginalAmount");
        }
        if (filter.indexOf("voucherType.name") != -1) {
            filter = filter.replaceAll("voucherType.name", "voucherType.fname_" + loc);
        }
        if (filter.indexOf("voucher.number") != -1) {
            filter = filter.replaceAll("voucher.number", preTableVch + "fnumber");
        }
        if (filter.indexOf("description") != -1) {
            filter = filter.replaceAll("description", preTable + "fdescription");
        }
        if (filter.indexOf("debitAmount") != -1) {
            filter = filter.replaceAll("debitAmount", "(case " + preTableDC + "fentrydc when 1 then " + preTable + "foriginalAmount else 0 end)");
        }
        if (filter.indexOf("creditAmount") != -1) {
            filter = filter.replaceAll("creditAmount", "(case " + preTableDC + "fentrydc when 0 then " + preTable + "foriginalAmount else 0 end)");
        }
        where.append(" and ").append(filter).append("  \r\n");
        return where;
    }

    private void calAcBeginBal_Init(Context ctx, Connection con, String tablename, boolean isInTimeVerify, boolean includeFinished, boolean includeUnPosted, boolean isAllCurrency, StringBuffer selectHG, StringBuffer whereSelfDefine_Assist, String accountid, String companyid, String currencyid, ArrayList ids, String tempTableHappen) throws SQLException, EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tablename);
        if (!includeFinished) {
            sql.append(" ( FCurrencyID,FDebit,FCredit,FBalance,FLineType,FAssGrpId, FIsInit, FVoucherAsstID, FAcctCussentID, FDC ) ");
        } else {
            sql.append(" ( FCurrencyID,FDebit,FCredit,FBalance,FLineType,FAssGrpId, FIsInit ) ");
        }
        String amountField = isInTimeVerify && includeUnPosted ? "act.FUnHoldedAmtFor" : "act.FUnverifiedAmtFor";
        sql.append(" select act.fcurrencyid, 0 FDebit, 0 FCredit,                  \r\n").append("  ").append(amountField).append(" FBalance,          \r\n").append("  -3 as FLineType ,act.FASSGRPID as FAssGrpId, 1          \r\n");
        if (!includeFinished) {
            sql.append(",act.fvchassistrecordid  ,act.fid facctcussentid, v.fdc  \r\n");
        }
        sql.append(" from t_gl_acctcussent act                                   \r\n").append(" inner join t_bd_accountview v on v.fid = act.faccountid  \r\n").append(" inner join t_bd_assistanthg hg on act.FASSGRPID = hg.fid  \r\n").append(" where act.faccountid = ? and act.fcompanyid = ? \r\n").append("  and act.fisinit = 1 and act.fisinitclosed = 1  \r\n");
        if (!isAllCurrency) {
            sql.append(" and act.fcurrencyid=?  \r\n");
        }
        sql.append(selectHG);
        PreparedStatement ps = con.prepareStatement(sql.toString());
        int index = 1;
        ps.setString(index++, accountid);
        ps.setString(index++, companyid);
        if (!isAllCurrency) {
            ps.setString(index++, currencyid);
        }
        for (int i = 0; i < ids.size(); ++i) {
            ps.setString(index++, (String)ids.get(i));
        }
        ps.executeUpdate();
        SQLUtils.cleanup((Statement)ps);
    }

    private void insertInitData(Connection con, String tableName, boolean includeFinished, boolean isInTimeVerify, boolean includeUnPosted, boolean isAllCurrency, StringBuffer selectHG, String accountId, String companyId, String currencyId, ArrayList ids, java.sql.Date beginDate, java.sql.Date endDate) throws SQLException {
        String amountField;
        String string = amountField = isInTimeVerify && includeUnPosted ? "act.FUnHoldedAmtFor" : "act.FUnverifiedAmtFor";
        if (includeFinished) {
            amountField = "act.FOriginalAmount";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(tableName);
        sql.append("( FCurrencyID, FDescription, FAssGrpId, FAcctCussentID, FBizNumber, FDebit, FCredit, FBalance, FDC, FLineType, FIsInit ) \r\n");
        sql.append("select act.FCurrencyId, act.FDescription, act.FAssGrpID, act.FID, FBizNumber,").append(" (case when account.FDC = 1 then ").append(amountField).append(" else 0 end),").append(" (case when account.FDC = -1 then ").append(amountField).append(" else 0 end),").append(" account.FDC * ").append(amountField).append(",").append(" account.FDC, ").append(-6).append(", 1 \r\n");
        sql.append("from t_gl_acctCussent act \r\n").append(" inner join t_bd_assistantHG hg on hg.fid = act.FAssGrpID \r\n").append(" inner join t_bd_accountView account on account.FID = act.FAccountID \r\n").append(" inner join t_gl_flag flag on flag.Fkey = account.fid \r\n").append(" inner join t_bd_period bp on flag.finitperiodid = bp.fid \r\n");
        sql.append("where act.FAccountID = ? and act.FCompanyID = ? and act.FIsInit = 1 and act.FIsInitClosed = 1 ");
        if (!isAllCurrency) {
            sql.append(" and act.FCurrencyID = ? ");
        }
        sql.append(" and bp.FBEGINDATE>= ? and bp.FBEGINDATE<=? ");
        sql.append(selectHG);
        PreparedStatement ps = con.prepareStatement(sql.toString());
        int index = 1;
        ps.setString(index++, accountId);
        ps.setString(index++, companyId);
        if (!isAllCurrency) {
            ps.setString(index++, currencyId);
        }
        ps.setDate(index++, beginDate);
        ps.setDate(index++, endDate);
        for (Object id : ids) {
            ps.setString(index++, (String)id);
        }
        ps.executeUpdate();
        SQLUtils.cleanup((Statement)ps);
    }

    private void calAcBeginBal(Context ctx, TempTablePool iPools, Connection con, String tablename, boolean isInTimeVerify, boolean includeFinished, boolean includeUnPosted, boolean isAllCurrency, StringBuffer selectHG, StringBuffer whereSelfDefine_Assist, String accountid, String companyid, String currencyid, java.sql.Date beginDate, java.sql.Date endDate, ArrayList ids, String tempTableHappen) throws SQLException, EASBizException, BOSException {
        int i;
        String sql;
        IRowSet result;
        PreparedStatement ps = null;
        int index = 1;
        StringBuffer sql_AcBegin = new StringBuffer();
        ObjectUuidPK comPK = new ObjectUuidPK(companyid);
        PeriodInfo beginPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)beginDate, (IObjectPK)comPK);
        if (beginPeriodInfo == null || beginPeriodInfo.getBeginDate() == null) {
            throw new GLPeriodEndException(GLPeriodEndException.NO_EQUAL_PERIOD, new Object[]{beginDate + ""});
        }
        java.sql.Date periodBeginDate = new java.sql.Date(beginPeriodInfo.getBeginDate().getTime());
        PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)comPK);
        PeriodInfo currtPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)comPK);
        PeriodInfo minPeriodInfo = beginPeriodInfo;
        java.sql.Date minBeginDate = null;
        if (currtPeriodInfo == null) {
            throw new GLPeriodEndException(GLPeriodEndException.GL_INIT_NOT_CLOSED);
        }
        if (currtPeriodInfo.getNumber() < beginPeriodInfo.getNumber()) {
            minPeriodInfo = currtPeriodInfo;
        }
        if ((result = DbUtil.executeQuery((Context)ctx, (String)(sql = "select bp.fid,bp.fnumber,bp.FBeginDate,bp.FEndDate from t_gl_flag flag inner join t_bd_period bp on flag.finitperiodid = bp.fid where flag.fkey = ? and flag.fname='cussentinit' and flag.fvalue='true'"), (Object[])new String[]{accountid})).next()) {
            java.sql.Date initBeginDate = result.getDate(3);
            if (endDate.compareTo(initBeginDate) < 0) {
                return;
            }
            int periodNumber = result.getInt(2);
            if (minPeriodInfo.getNumber() < periodNumber) {
                PeriodInfo initPeriod = new PeriodInfo();
                initPeriod.setId(BOSUuid.read((String)result.getString(1)));
                initPeriod.setNumber(periodNumber);
                initPeriod.setBeginDate((Date)result.getDate(3));
                initPeriod.setEndDate(result.getTimestamp(4));
                minPeriodInfo = initPeriod;
            }
        }
        minBeginDate = new java.sql.Date(minPeriodInfo.getBeginDate().getTime());
        sql_AcBegin = this.getSql_AstBeginBal(con, tablename, isAllCurrency, selectHG);
        ps = con.prepareStatement(sql_AcBegin.toString());
        index = 1;
        ps.setString(index++, accountid);
        ps.setString(index++, companyid);
        ps.setInt(index++, minPeriodInfo.getNumber());
        if (!isAllCurrency) {
            ps.setString(index++, currencyid);
        }
        for (i = 0; i < ids.size(); ++i) {
            ps.setString(index++, (String)ids.get(i));
        }
        ps.executeUpdate();
        SQLUtils.cleanup((Statement)ps);
        if (minBeginDate.before(beginDate)) {
            sql_AcBegin = this.getSql_AcBeginBalHappen(con, tempTableHappen, isInTimeVerify, includeFinished, includeUnPosted, isAllCurrency, selectHG, whereSelfDefine_Assist);
            ps = con.prepareStatement(sql_AcBegin.toString());
            index = 1;
            ps.setString(index++, accountid);
            ps.setString(index++, companyid);
            ps.setDate(index++, minBeginDate);
            ps.setDate(index++, beginDate);
            if (!isAllCurrency) {
                ps.setString(index++, currencyid);
            }
            for (i = 0; i < ids.size(); ++i) {
                ps.setString(index++, (String)ids.get(i));
            }
            ps.executeUpdate();
            SQLUtils.cleanup((Statement)ps);
            this.insertIntoTempTable_AcBeginBal_Preline(con, tablename, tempTableHappen);
            String[] selectHGArray = null;
            if (selectHG != null && selectHG.length() != 0 && selectHG.indexOf(" or ") != -1) {
                selectHGArray = selectHG.toString().replace("(", "").replace(")", "").split("or");
            }
            if (selectHGArray == null) {
                sql_AcBegin = this.getSql_AcBeginBalUpdate(tablename, tempTableHappen, null);
                ps = con.prepareStatement(sql_AcBegin.toString());
                ps.executeUpdate();
            } else {
                int i2;
                for (int i3 = 0; i3 < selectHGArray.length; ++i3) {
                    if (!selectHGArray[i3].startsWith(" and")) continue;
                    selectHGArray[i3] = selectHGArray[i3].substring(4);
                }
                sql_AcBegin = this.getSql_AcBeginBalUpdateWithOneStatement(tablename, tempTableHappen, selectHGArray);
                ps = con.prepareStatement(sql_AcBegin.toString());
                int totalParamCount = 0;
                int[] selectHGParamCountArray = new int[selectHGArray.length];
                for (i2 = 0; i2 < selectHGArray.length; ++i2) {
                    selectHGParamCountArray[i2] = selectHGArray[i2].split("and").length;
                    totalParamCount += selectHGParamCountArray[i2];
                }
                for (i2 = 0; i2 < selectHGArray.length; ++i2) {
                    int k = selectHGParamCountArray[i2];
                    for (int j = 1; j <= k; ++j) {
                        ps.setString(i2 * k + j, ids.get(i2 * k + j - 1).toString());
                        ps.setString(i2 * k + j + totalParamCount, ids.get(i2 * k + j - 1).toString());
                    }
                }
                ps.executeUpdate();
            }
            SQLUtils.cleanup((Statement)ps);
        }
    }

    private StringBuffer getSql_AstBeginBal(Connection con, String tablename, boolean isAllCurrency, StringBuffer selectHG) throws SQLException {
        Object ps = null;
        boolean index = true;
        StringBuffer sql_AcBegin = new StringBuffer();
        StringBuffer select = new StringBuffer();
        StringBuffer selectVeri = new StringBuffer();
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT ");
        insert.append(tablename);
        insert.append(" ( FCurrencyID,FDebit,FCredit,FBalance,FLineType,FAssGrpId ) ");
        select.append(" select bal.fcurrencyid, 0 FDebit, 0 FCredit,                  \r\n");
        select.append("  sum(bal.fbeginbalancefor) FBalance, -3 as FLineType          \r\n");
        select.append("  ,bal.fassistgrpid as FAssGrpId          \r\n");
        select.append(" from " + GLBalanceUtils.getAssistBalanceTable(1) + " bal                                   \r\n");
        select.append("  inner join t_bd_assistanthg hg on bal.fassistgrpid = hg.fid  \r\n");
        select.append(" where bal.faccountid = ?                                      \r\n");
        select.append("  and bal.forgunitid = ?                                       \r\n");
        select.append("  and bal.fperiod = ?                                        \r\n");
        if (!isAllCurrency) {
            select.append(" and bal.fcurrencyid=?  \r\n");
        }
        select.append(selectHG);
        select.append(" group by bal.fassistgrpid,bal.fcurrencyid  \r\n");
        sql_AcBegin.append(insert);
        sql_AcBegin.append(select);
        return sql_AcBegin;
    }

    private StringBuffer getSql_AcBeginBalHappen(Connection con, String tablename, boolean isInTimeVerify, boolean includeFinished, boolean includeUnPosted, boolean isAllCurrency, StringBuffer selectHG, StringBuffer whereSelfDefine_Assist) throws SQLException {
        Object ps = null;
        boolean index = true;
        StringBuffer sql_AcBegin = new StringBuffer();
        StringBuffer select = new StringBuffer();
        StringBuffer selectVeri = new StringBuffer();
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT ");
        insert.append(tablename);
        insert.append(" (FCurrencyID,FBalance,FAssGrpID)  \r\n");
        String amountField = "assist.foriginalamount";
        String amountField_AC = "";
        select.append("select /*+ leading (hg) */ ");
        select.append("entry.fcurrencyid,  \r\n");
        select.append("sum((entry.fentrydc * 2 - 1) * " + amountField + ") fbalance  \r\n,assist.fassgrpid");
        select.append(" from t_gl_voucherassistrecord assist  \r\n");
        select.append(" inner join t_gl_voucherentry entry on assist.fentryid=entry.fid  \r\n");
        select.append(" inner join t_gl_voucher voucher on voucher.fid = entry.fbillid  \r\n");
        select.append("                                 and voucher.fid = assist.fbillid  \r\n");
        select.append(" inner join v_gl_acperiod acperiod on acperiod.fperiodid = voucher.fperiodid  \r\n");
        select.append("                                 and acperiod.fcompanyid=voucher.fcompanyid  \r\n");
        select.append(" left outer join t_bd_vouchertypes vouchertype on voucher.fvouchertypeid=vouchertype.fid  \r\n");
        select.append(" inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid  \r\n");
        select.append(" where entry.faccountid = ? and voucher.fcompanyid = ?  \r\n");
        select.append("  and voucher.fbookeddate >= ? and voucher.fbookeddate < ?  \r\n");
        if (!includeUnPosted) {
            select.append(" and voucher.fbizstatus=").append(5);
        } else {
            select.append(" and voucher.fbizstatus<>").append(2);
            select.append(" and voucher.fbizstatus<>").append(0);
        }
        if (!isAllCurrency) {
            select.append("\r\n and entry.fcurrencyid=?  \r\n");
        }
        select.append(selectHG);
        select.append("\r\n group by assist.fassgrpid,entry.fcurrencyid  \r\n");
        sql_AcBegin.append(insert);
        sql_AcBegin.append(select);
        return sql_AcBegin;
    }

    private void insertIntoTempTable_AcBeginBal_Preline(Connection con, String tempTableBal, String tempTableHappend) throws SQLException {
        StringBuffer sql = new StringBuffer();
        PreparedStatement ps = null;
        sql.append("INSERT ");
        sql.append(tempTableBal);
        sql.append(" ( FCurrencyID,FDebit,FCredit,FBalance,FLineType,FAssgrpID ) ");
        sql.append(" select bal.fcurrencyid, 0 FDebit, 0 FCredit,        \r\n");
        sql.append("  0 FBalance, -3 as FLineType,                        \r\n");
        sql.append("  bal.FAssgrpID                        \r\n");
        sql.append(" from ").append(tempTableHappend).append(" bal \r\n");
        sql.append(" left outer join ").append(tempTableBal).append(" tmp \r\n");
        sql.append("   on tmp.fcurrencyid = bal.fcurrencyid      \r\n");
        sql.append(" where tmp.fcurrencyid is null               \r\n");
        ps = con.prepareStatement(sql.toString());
        ps.execute();
        ps.close();
    }

    private StringBuffer getSql_AcBeginBalUpdate(String tempTableBal, String tempTableHappend, String selectHG) {
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(tempTableBal).append(" tmp    \r\n");
        sql.append(" set (fbalance) =                               \r\n");
        sql.append(" (                                              \r\n");
        sql.append(" select tmp.fbalance + bal.fbalance            \r\n");
        sql.append(" from ").append(tempTableHappend).append(" bal \r\n");
        sql.append(" where tmp.fcurrencyid = bal.fcurrencyid      \r\n");
        if (!StringUtil.isEmpty((String)selectHG)) {
            sql.append(" and bal.fassgrpid in(select hg.fid from t_bd_assistanthg hg  \r\n");
            sql.append(" where ").append(selectHG).append(")");
        } else {
            sql.append(" and tmp.FASSGRPID = bal.FASSGRPID      \r\n");
        }
        sql.append(" )                                              \r\n");
        if (!StringUtil.isEmpty((String)selectHG)) {
            sql.append(" where tmp.fassgrpid in(select hg.fid from t_bd_assistanthg hg  \r\n");
            sql.append(" where ").append(selectHG).append(")");
        }
        return sql;
    }

    private StringBuffer getSql_AcBeginBalUpdateWithOneStatement(String tempTableBal, String tempTableHappend, String[] selectHGArray) {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tempTableBal).append(" tmp\r\n");
        sql.append("set (fbalance) = \r\n");
        sql.append("  ( \r\n");
        sql.append("    select tmp.fbalance + bal.fbalance \r\n");
        sql.append("    from ").append(tempTableHappend).append(" bal \r\n");
        sql.append("    where tmp.fcurrencyid = bal.fcurrencyid \r\n");
        if (selectHGArray.length == 0) {
            sql.append("      and tmp.FASSGRPID = bal.FASSGRPID \r\n)");
        } else {
            int i;
            sql.append("      and tmp.FASSGRPID = bal.FASSGRPID \r\n");
            sql.append("      and bal.fassgrpid in ( \r\n").append("        select hg.fid from t_bd_assistanthg hg  \r\n");
            sql.append("        where ");
            for (i = 0; i < selectHGArray.length; ++i) {
                if (i != 0) {
                    sql.append(" or ");
                }
                sql.append("(").append(selectHGArray[i]).append(")");
            }
            sql.append("\r\n        ) \r\n");
            sql.append("      ) \r\n");
            sql.append("where tmp.fassgrpid in ( \r\n");
            sql.append("  select hg.fid from t_bd_assistanthg hg  \r\n");
            sql.append("  where ");
            for (i = 0; i < selectHGArray.length; ++i) {
                if (i != 0) {
                    sql.append(" or ");
                }
                sql.append("(").append(selectHGArray[i]).append(")");
            }
            sql.append(") \r\n");
        }
        return sql;
    }

    private StringBuffer getHistorySql4Verified(String tempTableVerify) throws BOSException, EASBizException {
        StringBuffer historySql = new StringBuffer();
        StringBuffer fromSumVeri = new StringBuffer();
        StringBuffer whereSumVeri = new StringBuffer();
        String amountField = null;
        amountField = "khis.FOroginalAmount";
        String sum = "\r\n isnull(sum(" + amountField + "),0) FSumVeri  \r\n";
        String strSumTotal = "\r\n sum(FSumVeri) FSumVeri  \r\n";
        historySql.append("select FVoucherAsstIDID,").append(strSumTotal).append(" from ( \r\n");
        historySql.append(" select ").append("khis.FVOUCHERASSTIDID,").append(sum);
        historySql.append(" from t_gl_acctcussenthistory khis        \r\n");
        historySql.append(" INNER JOIN ").append(tempTableVerify).append(" veri on khis.FVOUCHERASSTIDID = veri.FVOUCHERASSTID    \r\n");
        historySql.append(" where khis.fdc IN (0, 2) AND khis.fvchdate >= ?  AND khis.fvchdate <= ?  \r\n");
        historySql.append(" group by khis.FVOUCHERASSTIDID  \r\n");
        historySql.append(" UNION ALL  \r\n");
        historySql.append(" select ").append("khis.FCUSSENTIDID,").append(sum);
        historySql.append(" from t_gl_acctcussenthistory khis        \r\n");
        historySql.append(" INNER JOIN ").append(tempTableVerify).append(" veri on khis.FCUSSENTIDID = veri.FVOUCHERASSTID    \r\n");
        historySql.append(" inner join t_gl_voucher voucher on khis.fverivchid=voucher.fid     \r\n");
        historySql.append(" where khis.fdc IN (3) AND voucher.fbookeddate >= ?  AND voucher.fbookeddate <= ?  \r\n");
        historySql.append(" group by khis.FCUSSENTIDID \r\n");
        historySql.append(" )t  \r\n");
        historySql.append("group by FVOUCHERASSTIDID  \r\n");
        return historySql;
    }

    private void insertIntoTempTable_Veri_Verify(Connection con, String tempTable, StringBuffer sqlSumVeri, String companyid, String accountid, String currencyid, boolean includeFinished, java.sql.Date beginDate, java.sql.Date endDate, ArrayList ids) throws SQLException {
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        sql = this.getInsertAcSql(tempTable, includeFinished);
        sql.append(sqlSumVeri);
        ps = con.prepareStatement(sql.toString());
        int index = 1;
        this.setParams_SelectAcSql(ps, index, accountid, companyid, currencyid, beginDate, endDate, ids);
        ps.execute();
        ps.close();
    }

    private void insertIntoTempTable_Veri_Verified(Connection con, String tempTable, StringBuffer sqlSumVeri, java.sql.Date beginDate, java.sql.Date endDate) throws SQLException {
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into ").append(tempTable).append("\r\n (FVoucherAsstID,FSumVeri) \r\n");
        sql.append(sqlSumVeri);
        ps = con.prepareStatement(sql.toString());
        int index = 1;
        this.setParams_insertTemp_Verified(ps, index, beginDate, endDate);
        ps.execute();
        ps.close();
    }

    private void setParams_insertTemp_Verified(PreparedStatement ps, int index, java.sql.Date begin, java.sql.Date end) throws SQLException {
        if (!this.includeInitData) {
            ps.setDate(index++, begin);
        }
        ps.setDate(index++, end);
        if (!this.includeInitData) {
            ps.setDate(index++, begin);
        }
        ps.setDate(index++, end);
    }

    private void updateTempTable_Veri_VerifyFromVerified(Connection con, int accountDC, String tempTableVerify, String tempTableVerified) throws SQLException {
        PreparedStatement ps = null;
        StringBuffer sqlUpdate = new StringBuffer();
        if (accountDC == -1) {
            sqlUpdate.append("update ").append(tempTableVerify).append(" tmp \r\n");
            sqlUpdate.append(" set (FDebit)    \r\n");
            sqlUpdate.append(" =                \r\n");
            sqlUpdate.append("(select tmp.FDebit - bal.FSumVeri                \r\n");
            sqlUpdate.append(" from ").append(tempTableVerified).append(" bal \r\n");
            sqlUpdate.append(" where tmp.FVoucherAsstID = bal.FVoucherAsstID  \r\n");
            sqlUpdate.append(")");
        } else {
            sqlUpdate.setLength(0);
            sqlUpdate.append("update ").append(tempTableVerify).append(" tmp \r\n");
            sqlUpdate.append(" set (FCredit)    \r\n");
            sqlUpdate.append(" =                \r\n");
            sqlUpdate.append("(select tmp.FCredit - bal.FSumVeri                \r\n");
            sqlUpdate.append(" from ").append(tempTableVerified).append(" bal \r\n");
            sqlUpdate.append(" where tmp.FVoucherAsstID = bal.FVoucherAsstID  \r\n");
            sqlUpdate.append(")");
        }
        ps = con.prepareStatement(sqlUpdate.toString());
        ps.executeUpdate();
        ps.close();
        sqlUpdate.setLength(0);
        sqlUpdate.append("update ").append(tempTableVerify);
        sqlUpdate.append(" set FBalance = FDebit - FCredit ");
        ps = con.prepareStatement(sqlUpdate.toString());
        ps.executeUpdate();
        ps.close();
        sqlUpdate.setLength(0);
        sqlUpdate.append("delete from ").append(tempTableVerify);
        sqlUpdate.append(" where FBalance = 0");
        ps = con.prepareStatement(sqlUpdate.toString());
        ps.executeUpdate();
        ps.close();
    }

    private void updateTempTable_Veri_VerifyFromVerified_New(Connection con, int accountDC, String tempTableVerify, String tempTableVerified) throws SQLException {
        PreparedStatement ps = null;
        StringBuffer sqlUpdate = new StringBuffer();
        if (accountDC == -1) {
            sqlUpdate.append("update ").append(tempTableVerify).append(" tmp \r\n");
            sqlUpdate.append(" set (FDebit)    \r\n");
            sqlUpdate.append(" =                \r\n");
            sqlUpdate.append("(select tmp.FDebit + bal.FSumVeri                \r\n");
            sqlUpdate.append(" from ").append(tempTableVerified).append(" bal \r\n");
            sqlUpdate.append(" where tmp.FVoucherAsstID = bal.FVoucherAsstID  \r\n");
            sqlUpdate.append(")");
        } else {
            sqlUpdate.setLength(0);
            sqlUpdate.append("update ").append(tempTableVerify).append(" tmp \r\n");
            sqlUpdate.append(" set (FCredit)    \r\n");
            sqlUpdate.append(" =                \r\n");
            sqlUpdate.append("(select tmp.FCredit + bal.FSumVeri                \r\n");
            sqlUpdate.append(" from ").append(tempTableVerified).append(" bal \r\n");
            sqlUpdate.append(" where tmp.FVoucherAsstID = bal.FVoucherAsstID  \r\n");
            sqlUpdate.append(")");
        }
        ps = con.prepareStatement(sqlUpdate.toString());
        ps.executeUpdate();
        ps.close();
        sqlUpdate.setLength(0);
        sqlUpdate.append("update ").append(tempTableVerify);
        sqlUpdate.append(" set FBalance = FDebit - FCredit ");
        ps = con.prepareStatement(sqlUpdate.toString());
        ps.executeUpdate();
        ps.close();
        sqlUpdate.setLength(0);
        sqlUpdate.append("delete from ").append(tempTableVerify);
        sqlUpdate.append(" where FBalance = 0");
        ps = con.prepareStatement(sqlUpdate.toString());
        ps.executeUpdate();
        ps.close();
    }

    private void insertIntoTempTable_Ac_FromVerify(Context ctx, Connection con, String tablename, String tempTableVerify, boolean includeFinished) throws SQLException {
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer select = new StringBuffer();
        StringBuffer insert = this.getInsertAcSql(tablename, includeFinished);
        if (SQLUtil.isPG(ctx)) {
            select.append("\tSelect to_date(FBizDate)");
        } else {
            select.append("\tSelect FBizDate");
        }
        if (SQLUtil.isPG(ctx)) {
            select.append(",to_date(FDate)");
        } else {
            select.append(",FDate");
        }
        select.append(",FVoucherID,FVoucherNumber,FVoucherType, FDescription, FCurrencyID,  \r\n");
        select.append("\tFDebit, FCredit,FBalance,FLineType,FVoucherAsstID,FAssGrpId,FBizNumber,FInvoiceNumber  \r\n");
        if (!includeFinished) {
            select.append(",FAcctCussentID,FDC  \r\n");
        }
        select.append(" from ").append(tempTableVerify);
        sql.append(insert).append(select);
        ps = con.prepareStatement(sql.toString());
        ps.execute();
        ps.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HashMap _queryCheckResults(Context ctx, HashMap condition, int start, int count, String companyId) throws BOSException, EASBizException {
        HashMap<String, Serializable> hashMap;
        ResultSet rs;
        Statement ps;
        Connection con;
        block30: {
            HashMap<String, Serializable> result = new HashMap<String, Serializable>();
            Boolean newquery = (Boolean)condition.get("newquery");
            String tablename = (String)condition.get("tablename");
            ArrayList datas = new ArrayList();
            String TITLE_PERIOD_START = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"strBalancePeriodStart", (Locale)ctx.getLocale());
            String TITLE_TOTAL = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Total", (Locale)ctx.getLocale());
            con = null;
            ps = null;
            rs = null;
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            TempTablePool iPool = null;
            String tempTableVerify = null;
            String tempTableVerified = null;
            String tempTableHappen = null;
            CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
            ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)company.getId().toString()));
            HashMap<String, ObjectUuidPK> hmNumAndOrgId = new HashMap<String, ObjectUuidPK>();
            hmNumAndOrgId.put("GL_004", comPK);
            hmNumAndOrgId.put("GL_028", comPK);
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            HashMap hmAllParam = pc.getParamHashMap(hmNumAndOrgId);
            boolean showNumber = Boolean.valueOf((String)hmAllParam.get("GL_004"));
            try {
                HashMap item;
                int i;
                con = this.getConnection(ctx);
                iPool = TempTablePool.getInstance((Context)ctx);
                StringBuffer sql = new StringBuffer();
                if (newquery.booleanValue()) {
                    tablename = this.createTempTable4Result(iPool, con);
                    condition.put("tablename", tablename);
                    try {
                        sql.setLength(0);
                        sql.append("create index I").append(tablename);
                        sql.append(" on ").append(tablename);
                        sql.append(" (FCurrencyID)");
                        ps = con.prepareStatement(sql.toString());
                        ps.execute();
                        ps.close();
                    }
                    catch (SQLException sQLException) {
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    this.insertIntoTable(ctx, iPool, con, condition, companyId, loc);
                    tempTableVerify = (String)condition.get("tempTableVerify");
                    tempTableVerified = (String)condition.get("tempTableVerified");
                    tempTableHappen = (String)condition.get("tempTableHappen");
                }
                sql.setLength(0);
                ArrayList itemTypes = (ArrayList)condition.get("itemtypes");
                sql.append("select");
                int size = itemTypes.size();
                for (i = 0; i < size; ++i) {
                    item = (HashMap)itemTypes.get(i);
                    sql.append(" asstTemp" + i + ".fname_l2 as fname_l2" + i + ",");
                    if (((Boolean)item.get("useLongNUmber")).booleanValue()) {
                        sql.append(" asstTemp" + i + ".flongnumber as fnumber" + i + ",");
                        continue;
                    }
                    sql.append(" asstTemp" + i + ".fnumber as fnumber" + i + ",");
                }
                sql.append(" t.*,cy.fname_").append(loc).append(" fcurrencyName,");
                sql.append(" cy.fprecision ");
                sql.append(" from ").append(tablename).append(" t ");
                sql.append(" inner join t_bd_currency cy on cy.fid = t.fcurrencyid ");
                sql.append(" left outer join T_BD_AssistantHG assthg");
                sql.append(" on assthg.fid=t.fassgrpid");
                size = itemTypes.size();
                for (i = 0; i < size; ++i) {
                    item = (HashMap)itemTypes.get(i);
                    sql.append(" left outer join " + item.get("tablename").toString() + " asstTemp" + i);
                    sql.append(" on assthg." + item.get("fieldname").toString() + "=asstTemp" + i + ".fid");
                }
                sql.append(" order by t.fassgrpid,t.fcurrencyid,t.flinetype,t.fdate,t.fisinit,t.fvouchernumber");
                ps = con.prepareStatement(sql.toString());
                rs = ps.executeQuery();
                JdbcRowSet rowset = new JdbcRowSet();
                rowset.populate(rs);
                ResultSetMetaData md = rs.getMetaData();
                GLRptTableHeadInfo headInfo = this.getTableHeadInfo(itemTypes, Boolean.valueOf(condition.get("showBizNum").toString()), ctx.getLocale());
                GLRptRowSet glRptrowSet = new GLRptRowSet(headInfo.getColNames(), rowset.size());
                try {
                    int rowIndex = -1;
                    BigDecimal bal = new BigDecimal("0");
                    BigDecimal beginBalance = new BigDecimal("0");
                    String preCurrencyId = "";
                    String curCurrencyId = "";
                    while (rowset.next()) {
                        int linetype = rowset.getInt("FLineType");
                        curCurrencyId = rowset.getString("fcurrencyid");
                        if (!curCurrencyId.equalsIgnoreCase(preCurrencyId)) {
                            bal = new BigDecimal("0");
                        }
                        if (linetype == -3) {
                            bal = new BigDecimal("0");
                            beginBalance = new BigDecimal("0");
                            beginBalance = bal = bal.add(InitHelp.nvl(rowset.getBigDecimal("fbalance")));
                        } else if (linetype == 0 || -6 == linetype) {
                            BigDecimal fbalance = rowset.getBigDecimal("fbalance");
                            bal = bal.add(fbalance);
                        } else {
                            beginBalance.add(InitHelp.nvl(rowset.getBigDecimal("fbalance")));
                        }
                        glRptrowSet.insertRow(++rowIndex);
                        glRptrowSet.setRowIndex(rowIndex + start);
                        this.toGLRptRowData((IRowSet)rowset, glRptrowSet, bal, showNumber, ctx.getLocale());
                        preCurrencyId = curCurrencyId;
                        if (linetype != 9) continue;
                        bal = new BigDecimal("0");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException("SQL ERROR!", (Throwable)e);
                }
                result.put("GLRptRowSet", glRptrowSet);
                result.put("GLRptTableHeadInfo", headInfo);
                hashMap = result;
                if (iPool == null) break block30;
            }
            catch (SQLException e) {
                try {
                    throw new SQLAccessException(e);
                }
                catch (Throwable throwable) {
                    if (iPool != null) {
                        if (!StringUtils.isEmpty(tempTableVerify)) {
                            iPool.releaseTable(tempTableVerify);
                        }
                        if (!StringUtils.isEmpty(tempTableVerified)) {
                            iPool.releaseTable(tempTableVerified);
                        }
                        if (!StringUtils.isEmpty(tempTableHappen)) {
                            iPool.releaseTable(tempTableHappen);
                        }
                    }
                    SQLUtils.cleanup(rs, ps, (Connection)con);
                    throw throwable;
                }
            }
            if (!StringUtils.isEmpty((String)tempTableVerify)) {
                iPool.releaseTable(tempTableVerify);
            }
            if (!StringUtils.isEmpty((String)tempTableVerified)) {
                iPool.releaseTable(tempTableVerified);
            }
            if (!StringUtils.isEmpty((String)tempTableHappen)) {
                iPool.releaseTable(tempTableHappen);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return hashMap;
    }

    private void toGLRptRowData(IRowSet rs, GLRptRowSet rowData, BigDecimal balance, boolean showNumber, Locale locale) throws BOSException, EASBizException, SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int count = md.getColumnCount();
        String[] colNameArray = new String[count];
        BigDecimal zero = new BigDecimal("0");
        int precision = 2;
        for (int i = 1; i <= count; ++i) {
            String colName;
            colNameArray[i - 1] = colName = md.getColumnName(i);
            Object value = null;
            if (md.getColumnType(i) == 91 || md.getColumnType(i) == 93) {
                java.sql.Date date = rs.getDate(i);
                if (date != null) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    value = df.format(date);
                }
            } else {
                value = rs.getObject(i);
                if ("fdebit".equalsIgnoreCase(colName) || "fcredit".equalsIgnoreCase(colName) || "fbalance".equalsIgnoreCase(colName)) {
                    if ("fbalance".equalsIgnoreCase(colName)) {
                        value = balance;
                    }
                    precision = 2;
                    if ("0E-10".equals(value.toString())) {
                        value = null;
                    }
                    if (rs.getObject("fprecision") != null) {
                        precision = rs.getInt("fprecision");
                    }
                    if (value != null && zero.compareTo((BigDecimal)value) != 0) {
                        value = this.getScaleBigDecimal(value, precision);
                    }
                    if ("fbalance".equalsIgnoreCase(colName) && value != null) {
                        value = ((BigDecimal)value).abs();
                    }
                } else if ("fdc".equalsIgnoreCase(colName)) {
                    value = balance != null && zero.compareTo(balance) != 0 ? (balance.compareTo(zero) > 0 ? ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"FlagDebit", (Locale)locale) : ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"FlagCredit", (Locale)locale)) : ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"FlagBalance", (Locale)locale);
                } else if ("fdescription".equalsIgnoreCase(colName)) {
                    int FLineType = rs.getInt("FLineType");
                    if (FLineType == 9) {
                        value = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Total", (Locale)locale);
                    } else if (FLineType == -3) {
                        value = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"strBalancePeriodStart", (Locale)locale);
                    }
                } else if ("fvouchernumber".equalsIgnoreCase(colName)) {
                    if (value != null) {
                        value = rs.getString("FVoucherType") + "-" + value.toString();
                    }
                } else if (showNumber && colName.toUpperCase().startsWith("fname_l2".toUpperCase())) {
                    String index = colName.substring(8);
                    String number = rs.getString("fnumber" + index);
                    if (number.contains("!")) {
                        number = number.replaceAll("!", ".");
                    }
                    value = number + "-" + value;
                }
            }
            rowData.updateObject(colName, value);
        }
    }

    public GLRptTableHeadInfo getTableHeadInfo(ArrayList itemTypes, boolean showBizNum, Locale locale) throws SQLException {
        int i;
        GLRptTableHeadInfo headInfo = new GLRptTableHeadInfo();
        int colSize = itemTypes.size() + 12;
        String[][] titleTemp = new String[2][colSize];
        for (int i2 = 0; i2 < itemTypes.size(); ++i2) {
            HashMap item = (HashMap)itemTypes.get(i2);
            titleTemp[0][i2] = item.get("name").toString();
            titleTemp[1][i2] = item.get("name").toString();
        }
        titleTemp[0][itemTypes.size()] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Date_jz", (Locale)locale);
        titleTemp[0][itemTypes.size() + 1] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"BizDate", (Locale)locale);
        titleTemp[0][itemTypes.size() + 2] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"voucherTNumber", (Locale)locale);
        titleTemp[0][itemTypes.size() + 3] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Description", (Locale)locale);
        titleTemp[0][itemTypes.size() + 4] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"CurrencyType", (Locale)locale);
        titleTemp[0][itemTypes.size() + 5] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"BizNumber", (Locale)locale);
        titleTemp[0][itemTypes.size() + 6] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"invoiceNumber2", (Locale)locale);
        titleTemp[0][itemTypes.size() + 7] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Debit", (Locale)locale);
        titleTemp[0][itemTypes.size() + 8] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Credit", (Locale)locale);
        titleTemp[0][itemTypes.size() + 9] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Balance", (Locale)locale);
        titleTemp[0][itemTypes.size() + 10] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Balance", (Locale)locale);
        titleTemp[0][itemTypes.size() + 11] = "FLineType";
        titleTemp[1][itemTypes.size()] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Date_jz", (Locale)locale);
        titleTemp[1][itemTypes.size() + 1] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"BizDate", (Locale)locale);
        titleTemp[1][itemTypes.size() + 2] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"voucherTNumber", (Locale)locale);
        titleTemp[1][itemTypes.size() + 3] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Description", (Locale)locale);
        titleTemp[1][itemTypes.size() + 4] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"CurrencyType", (Locale)locale);
        titleTemp[1][itemTypes.size() + 5] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"BizNumber", (Locale)locale);
        titleTemp[1][itemTypes.size() + 6] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"invoiceNumber2", (Locale)locale);
        titleTemp[1][itemTypes.size() + 7] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Debit", (Locale)locale);
        titleTemp[1][itemTypes.size() + 8] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Credit", (Locale)locale);
        titleTemp[1][itemTypes.size() + 9] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"DC", (Locale)locale);
        titleTemp[1][itemTypes.size() + 10] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Amount", (Locale)locale);
        titleTemp[1][itemTypes.size() + 11] = "FLineType";
        String[] field = new String[itemTypes.size() + 11];
        for (i = 0; i < itemTypes.size(); ++i) {
            field[i] = "fname_l2" + i;
        }
        field[itemTypes.size()] = "FDate";
        field[itemTypes.size() + 1] = "FBizDate";
        field[itemTypes.size() + 2] = "FVoucherNumber";
        field[itemTypes.size() + 3] = "FDescription";
        field[itemTypes.size() + 4] = "FCURRENCYNAME";
        field[itemTypes.size() + 5] = "FBizNumber";
        field[itemTypes.size() + 6] = "FInvoiceNumber";
        field[itemTypes.size() + 7] = "FDebit";
        field[itemTypes.size() + 8] = "FCredit";
        field[itemTypes.size() + 9] = "FDC";
        field[itemTypes.size() + 10] = "FBalance";
        for (i = 0; i < field.length; ++i) {
            GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
            colInfo.setColName(field[i]);
            colInfo.setWidth(110);
        }
        if (!showBizNum) {
            headInfo.getTableColumnInfo("FBizNumber").setHide(true);
            headInfo.getTableColumnInfo("FInvoiceNumber").setHide(true);
        }
        GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
        colInfo.setColName("FLineType");
        colInfo.setWidth(110);
        colInfo.setHide(true);
        headInfo.setHeadTitle(titleTemp);
        return headInfo;
    }

    private BigDecimal getScaleBigDecimal(Object obj, int precision) {
        BigDecimal rtnObj = (BigDecimal)obj;
        if (rtnObj != null) {
            rtnObj = rtnObj.setScale(precision, 4);
        }
        return rtnObj;
    }

    @Override
    protected HashMap _getInitData(Context ctx, Set companyIds, String periodTypeId) throws BOSException, EASBizException {
        Map params = this.getGlobalParams(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection sic = filter.getFilterItems();
        sic.add(new FilterItemInfo("id", (Object)companyIds.toString(), CompareType.INCLUDE));
        HashMap<String, Object> map = new HashMap<String, Object>();
        CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        map.put("periods", this.getPeriodList(ctx, companys));
        CompanyOrgUnitInfo company = GlUtils.getCompanyById(companyIds.toArray()[0].toString());
        PeriodInfo startPeriod = InitHelp.getStartPeriod(ctx, company);
        map.put("startPeriod", startPeriod);
        Object useRptCurrency = params.get("G001");
        boolean isUseRptCurrency = useRptCurrency != null && Boolean.valueOf(useRptCurrency.toString()) != false;
        AccountTableCollection tables = this.getAccountTableCollection(ctx, null, false);
        map.put("currencys", this.getCurrencys(ctx, isUseRptCurrency));
        map.put("per", this.getCurrencys(ctx, isUseRptCurrency));
        map.put("accountTables", tables);
        return map;
    }

    private AccountTableCollection getAccountTableCollection(Context ctx, CompanyOrgUnitInfo company, boolean isSupportUnion) throws ReportBizException, BOSException {
        if (company == null) {
            company = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        if (!company.isIsBizUnit() && isSupportUnion) {
            return AccountTools.getAllAccountTableByCompany((Context)ctx, (CompanyOrgUnitInfo)company);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableCollection(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Map<String, Object> getPeriodList(Context ctx, CompanyOrgUnitCollection companys) {
        block10: {
            Connection con = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT distinct  t.FPERIODYEAR year , min(FPeriodNumber) min,max(FPeriodNumber) max ");
            sql.append("FROM  t_bd_period t WHERE t.FTYPEID IN (");
            Iterator it = companys.iterator();
            ArrayList<String> periodTypeIds = new ArrayList<String>();
            while (it.hasNext()) {
                sql.append("?,");
                periodTypeIds.add(((CompanyOrgUnitInfo)it.next()).getAccountPeriodType().getId().toString());
            }
            sql.deleteCharAt(sql.lastIndexOf(","));
            sql.append(") group by  t.FPERIODYEAR  order by t.FPERIODYEAR ");
            try {
                con = this.getConnection(ctx);
                ps = con.prepareStatement(sql.toString());
                int i = 1;
                for (String id : periodTypeIds) {
                    ps.setString(i++, id);
                }
                rs = ps.executeQuery();
                ArrayList<int[]> periods = new ArrayList<int[]>();
                String[] periodRange = new String[2];
                while (rs.next()) {
                    periods.add(new int[]{rs.getInt(1), rs.getInt(2), rs.getInt(3)});
                }
                int[] min = (int[])periods.get(0);
                int[] max = (int[])periods.get(periods.size() - 1);
                periodRange[0] = min[0] + "-" + min[1];
                periodRange[1] = max[0] + "-" + max[2];
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("range", periodRange);
                map.put("periods", periods);
                HashMap<String, Object> hashMap = map;
                SQLUtils.cleanup((Statement)ps, (Connection)con);
                return hashMap;
            }
            catch (SQLDataException e) {
                e.printStackTrace();
            }
            catch (SQLException e2) {
                e2.printStackTrace();
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                SQLUtils.cleanup(ps, (Connection)con);
            }
        }
        return null;
    }

    private Map getGlobalParams(Context ctx) throws EASBizException, BOSException {
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("G001", null);
        items.put("G010", null);
        items.put("GL_053", null);
        items.put("GL_008", ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        return ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(items);
    }

    private Vector getCurrencys(Context ctx, boolean isUseReportCurrency) throws BOSException, EASBizException {
        CurrencyCollection currencyCollection = this.getAllCurrencyCollection(ctx);
        Vector<Object> currencys = new Vector<Object>();
        for (int i = 0; i < currencyCollection.size(); ++i) {
            CurrencyInfo currency = currencyCollection.get(i);
            if (currency == null || currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) continue;
            currencys.add(currencyCollection.get(i));
        }
        currencys.add(GLResUtil.getRes("all_currency", ctx.getLocale()));
        return currencys;
    }

    private CurrencyCollection getAllCurrencyCollection(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        CurrencyCollection currencyCollection = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
        return currencyCollection;
    }

    private boolean isForeignCurrency(Context ctx) throws EASBizException, BOSException {
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("GL_008", ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        HashMap param = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(items);
        return Boolean.valueOf(param.get("GL_008").toString());
    }

    @Override
    protected GLRptRowSet _getData(Context ctx, String queryId, int rowIndex, int size) throws BOSException {
        try {
            return this.getGLRptDao(ctx, queryId).getData(rowIndex, size);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected Map _getQueryItem(Context ctx, Map condition, String companyid) throws BOSException {
        ArrayList params = new ArrayList();
        try {
            String sql = this.getAsstItemSql(ctx, condition, companyid, params);
            StringBuffer insertSql = new StringBuffer(" select rownum as KSQL_SEQ, ");
            List asstList = (List)condition.get("asstList");
            AsstactTypeEntity at = null;
            StringBuffer struct = new StringBuffer("KSQL_SEQ int IDENTITY(1, 1), ");
            for (int i = 0; i < asstList.size(); ++i) {
                at = (AsstactTypeEntity)asstList.get(i);
                boolean isShowNumber = false;
                boolean isShowLongName = false;
                boolean isShowLongNumber = false;
                GLRptField id = GLRptField.genAsstDataBaseID(at);
                GLRptField number = GLRptField.genAsstDataBaseNumber(at, isShowLongNumber);
                GLRptField name = GLRptField.genAsstDataBaseName(at, ctx.getLocale(), isShowNumber, isShowLongNumber, isShowLongName);
                insertSql.append("t.T").append(i).append("fid as ").append(id).append(",");
                insertSql.append("t.T").append(i).append("fnumber as ").append(number).append(",");
                insertSql.append("t.T").append(i).append("fname as ").append(name).append(",");
                struct.append(id).append(" ").append(id.getType()).append(", ");
                struct.append(number).append(" ").append(number.getType()).append(", ");
                struct.append(name).append(" ").append(name.getType()).append(", ");
            }
            insertSql.deleteCharAt(insertSql.lastIndexOf(","));
            struct.deleteCharAt(struct.lastIndexOf(","));
            insertSql.append(" from (").append(sql).append(") t ");
            String temp = GLTempTableUtil.createTempTable(ctx, struct.toString());
            DbUtil.execute((Context)ctx, (String)("insert into " + temp + insertSql.toString()), (Object[])params.toArray());
            String selectSql = "select count(1) from " + temp;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("count", count);
            map.put("queryId", temp);
            return map;
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    protected GLRptQueryResult _query(Context ctx, EntityViewInfo ev) throws BOSException, EASBizException {
        if (ev == null) {
            return null;
        }
        ReportConditionBase condition = (ReportConditionBase)ev.get("GLFixCondition");
        if (condition == null) {
            return null;
        }
        String qMethod = (String)ev.get("method");
        IGLRptDao dao = this.getGLRptDao(ctx, condition, qMethod);
        String queryId = null;
        boolean isRequired = true;
        GLTempTableUtil.setTransactionRequired(isRequired);
        queryId = isRequired ? (String)GLTransactionUtils.invoke(dao, "createDataSourceTable", new Class[]{EntityViewInfo.class}, new Object[]{ev}, 0) : dao.createDataSourceTable(ev);
        if (queryId == null) {
            return null;
        }
        GLRptCache cache = GLRptCache.createGLRptCache(ctx, queryId);
        cache.setDao(dao);
        int length = 100;
        Object pageRowCount = ev.get("PAGE_ROW_COUNT");
        if (pageRowCount instanceof Integer) {
            length = (Integer)pageRowCount;
        }
        return new GLRptQueryResult(queryId, dao, length);
    }

    @Override
    protected HashMap _getAcAccountData(Context ctx, String companyid, String accounttableid) throws BOSException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select count(1) from t_bd_accountview v ").append("\tinner join t_org_company o on v.fcompanyid = o.fid ").append("\tinner join t_bd_accounttable t on v.faccounttableid = t.fid ").append(" where v.fisleaf = 1 and v.fac = 1 ").append("\tand t.fid = '").append(accounttableid).append("' ").append("\tand o.fid = '").append(companyid).append("' ");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            row.beforeFirst();
            int count = 0;
            while (row.next()) {
                count = row.getInt(1);
            }
            map.put("count", count);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }
}

