/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentFactory;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedDataTypeEnum;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.AbstractAcctCussentControllerBean;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLUtil;
import com.kingdee.eas.framework.report.RptException;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AcctCussentControllerBean
extends AbstractAcctCussentControllerBean {
    private static final long serialVersionUID = -2196837151674677855L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.AcctCussentControllerBean");
    private static final String REC = "com.kingdee.eas.fi.gl.GLRes";

    @Override
    public Object[] _fetchInitFilterData(Context ctx, Object[] param) throws BOSException, EASBizException {
        if (param.length == 21 && "AcctCussentListUI".equals(param[18])) {
            return this.getAcctCussentListInitData(ctx, param);
        }
        return this.getOtherSourceInitData(ctx, param);
    }

    private Object[] getOtherSourceInitData(Context ctx, Object[] param) throws BOSException, EASBizException, GLException {
        Object[] result = new Object[21];
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longnumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        String curComId = (String)param[0];
        CompanyOrgUnitInfo com = GlUtils.getCurrentCompany(ctx, curComId, sic, true);
        result[0] = com;
        ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)curComId));
        PeriodTypeInfo prdType = com.getAccountPeriodType();
        if (prdType == null) {
            throw new GLException(GLException.NOPERIODTYPE);
        }
        result[1] = GlUtils.getAccountPeriodInfo(ctx, curComId, prdType.getId().toString());
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection curCol = curCtrl.getCurrencyCollection(true);
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        result[2] = curCol;
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        hmParamIn.put("G001", null);
        hmParamIn.put("GL_008", comPK);
        hmParamIn.put("GL_028", comPK);
        hmParamIn.put("GL_004", comPK);
        hmParamIn.put("GL_052", comPK);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        Boolean foreignCurrencySU = null;
        try {
            foreignCurrencySU = Boolean.valueOf(hmAllParam.get("GL_008").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_008"});
        }
        result[4] = foreignCurrencySU;
        Boolean useReportingCurrency = null;
        try {
            useReportingCurrency = Boolean.valueOf(hmAllParam.get("G001").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"G001"});
        }
        result[3] = useReportingCurrency;
        if (!foreignCurrencySU.booleanValue() && com.getBaseCurrency() == null) {
            throw new GLException(GLException.NOLOCALCUR);
        }
        if (useReportingCurrency.booleanValue() && com.getReportCurrency() == null) {
            throw new GLException(GLException.NOREPORTINGCUR);
        }
        boolean allowCussent = false;
        try {
            allowCussent = Boolean.valueOf(hmAllParam.get("GL_028").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_028"});
        }
        if (!allowCussent) {
            throw new GLException(GLException.CUSSENTNOTALLOW);
        }
        try {
            result[5] = Boolean.valueOf(hmAllParam.get("GL_004").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_004"});
        }
        result[6] = hmAllParam;
        result[7] = this.findAllAsstData(ctx, null);
        if (param[1] != null) {
            result[8] = this._fetchAsstactData(ctx, param[1].toString());
        }
        PeriodEntity pe = AcctCussentFactory.getLocalInstance(ctx).requestPeriodEntity(com);
        result[10] = pe;
        IAccountRefContrast iArc = AccountRefContrastFactory.getLocalInstance((Context)ctx);
        AccountRefContrastInfo info = iArc.getLastAcctInfo(com.getId().toString(), com.getAccountTable().getId().toString());
        result[12] = info;
        result[13] = RptServerUtil.queryCussentAsstAct(com.getId().toString(), com.getCU().getId().toString(), ctx);
        EntityViewInfo view = new EntityViewInfo();
        sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        AccountTableCollection coll = AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableCollection(view);
        result[20] = coll;
        return result;
    }

    private Object[] getAcctCussentListInitData(Context ctx, Object[] param) throws BOSException, EASBizException, GLException {
        Object[] result = new Object[21];
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longnumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        String curComId = (String)param[0];
        CompanyOrgUnitInfo com = GlUtils.getCurrentCompany(ctx, curComId, sic, true);
        result[0] = com;
        ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)curComId));
        PeriodTypeInfo prdType = com.getAccountPeriodType();
        if (prdType == null) {
            throw new GLException(GLException.NOPERIODTYPE);
        }
        result[1] = GlUtils.getAccountPeriodInfo(ctx, curComId, prdType.getId().toString());
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection curCol = curCtrl.getCurrencyCollection(true);
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        result[2] = curCol;
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        hmParamIn.put("G001", null);
        hmParamIn.put("GL_008", comPK);
        hmParamIn.put("GL_004", comPK);
        hmParamIn.put("GL_052", comPK);
        hmParamIn.put("GL_064", comPK);
        hmParamIn.put("GL_002", comPK);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        Boolean foreignCurrencySU = null;
        try {
            foreignCurrencySU = Boolean.valueOf(hmAllParam.get("GL_008").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_008"});
        }
        result[4] = foreignCurrencySU;
        Boolean useReportingCurrency = null;
        try {
            useReportingCurrency = Boolean.valueOf(hmAllParam.get("G001").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"G001"});
        }
        result[3] = useReportingCurrency;
        if (!foreignCurrencySU.booleanValue() && com.getBaseCurrency() == null) {
            throw new GLException(GLException.NOLOCALCUR);
        }
        if (useReportingCurrency.booleanValue() && com.getReportCurrency() == null) {
            throw new GLException(GLException.NOREPORTINGCUR);
        }
        try {
            result[5] = Boolean.valueOf(hmAllParam.get("GL_004").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_004"});
        }
        try {
            Integer qtyscale = new Integer(hmAllParam.get("GL_002").toString());
            hmAllParam.put("GL_002", qtyscale);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_002"});
        }
        result[6] = hmAllParam;
        result[7] = this.findAllAsstData(ctx, curComId);
        if (param[1] != null) {
            result[8] = this._fetchAsstactData(ctx, param[1].toString());
        }
        PeriodEntity pe = AcctCussentFactory.getLocalInstance(ctx).requestPeriodEntity(com);
        result[10] = pe;
        Object[] params = new Object[21];
        params[0] = com.getId().toString();
        params[1] = param[17];
        Object[] listData = this._fetchListData(ctx, params);
        result[14] = listData[0];
        result[9] = listData[9];
        result[11] = listData[5];
        IAccountRefContrast iArc = AccountRefContrastFactory.getLocalInstance((Context)ctx);
        AccountRefContrastInfo info = iArc.getLastAcctInfo(com.getId().toString(), com.getAccountTable().getId().toString());
        result[12] = info;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        MetaDataPK mainQueryPK2 = new MetaDataPK("com.kingdee.eas.fi.gl.app", "AcctCussentQueryForFilter");
        QueryInfo queryInfo = loader.getQuery((IMetaDataPK)mainQueryPK2);
        result[15] = queryInfo;
        if (queryInfo != null) {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getLocalInstance((Context)ctx);
            IObjectValue ev = iQuery.getDefaultFilterInfo(String.valueOf(param[16]), queryInfo.getFullName(), com.getId().toString(), ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            result[16] = ev;
        }
        result[13] = RptServerUtil.queryCussentAsstAct(com.getId().toString(), com.getCU().getId().toString(), ctx);
        EntityViewInfo view = new EntityViewInfo();
        sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        AccountTableCollection coll = AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableCollection(view);
        result[20] = coll;
        return result;
    }

    private Map findAllAsstData(Context ctx, String curComId) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (curComId == null) {
            curComId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        String sql = "select fassthgattribute from t_bd_asstacttype a inner join  T_BD_AsstActTypeDefault b on a.fid=b.fasstacttypeid where fisaccountcussent=1 and b.fcompanyid=?  ";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{curComId});
        try {
            int index = 0;
            if (rowset != null) {
                while (rowset.next()) {
                    String fassthgattribute = rowset.getString("fassthgattribute");
                    result.put(fassthgattribute, fassthgattribute);
                    ++index;
                }
            }
            if (index == 0) {
                result.put("customer", "customer");
                result.put("provider", "provider");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    @Override
    public Object[] _fetchListData(Context ctx, Object[] param) throws BOSException, EASBizException {
        String propName;
        Object[] sqlCPParam;
        String sqlCP;
        Object[] sqlAIParam;
        String sqlAI;
        Object[] result = new Object[21];
        String paramComId = (String)param[0];
        int helperType = (Integer)param[1];
        String curComId = null;
        String[] comids = paramComId.split(",");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < comids.length; ++i) {
            if (i == 0) {
                sb.append("'");
            } else {
                sb.append(",'");
            }
            sb.append(comids[i]);
            sb.append("'");
        }
        curComId = sb.toString();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String accFrom = (String)param[2];
        String accTo = (String)param[3];
        String[] disAccountNumber = (String[])param[5];
        if (helperType == 1) {
            sqlAI = "select distinct item.fnumber num, item.fassthgattribute mappingPropName, item.fname_" + loc + " fname,item.FuseLongNumber  from T_BD_AsstActGroupDetail rel inner join T_BD_AsstActType item on item.fid = rel.fasstacttypeid where rel.fasstaccountid = ? order by item.fnumber";
            sqlAIParam = new Object[]{param[4]};
            sqlCP = "select distinct type1.fnumber num, type1.fmappingpropname mappingPropName, type1.fdatatype dataType, type1.fname_" + loc + " fname from T_GL_AssistCustomizedProperty prop inner join T_GL_AssistCustomizedType type1 on prop.fcustomizedtypeid = type1.fid inner join T_BD_AccountView---\r\n account on prop.faccountid = account.fid where account.fnumber = ? and account.fcompanyid = ( " + curComId + ") and prop.Fdeletedstatus=1  order by type1.fnumber";
            sqlCPParam = new Object[]{accFrom};
        } else {
            StringBuffer sqlAIBuffer = new StringBuffer("select distinct item.fnumber num, item.fassthgattribute mappingPropName, item.fname_");
            sqlAIBuffer.append(loc);
            sqlAIBuffer.append(" fname,item.FuseLongNumber  from T_BD_AccountView account inner join T_BD_AsstAccount book on account.fcaa = book.fid inner join T_BD_AsstActGroupDetail rel on book.fid = rel.fasstaccountid inner join T_BD_AsstActType item on item.fid = rel.fasstacttypeid");
            StringBuffer sqlCPBuffer = new StringBuffer("select distinct type1.fnumber num, type1.fmappingpropname mappingPropName, type1.fdatatype dataType, type1.fname_");
            sqlCPBuffer.append(loc);
            sqlCPBuffer.append(" fname from T_GL_AssistCustomizedProperty prop inner join T_GL_AssistCustomizedType type1 on prop.fcustomizedtypeid = type1.fid inner join T_BD_AccountView---\r\n account on prop.faccountid = account.fid");
            StringBuffer sqlWhereBuffer = new StringBuffer(" where ");
            if (accFrom != null && accTo != null) {
                sqlWhereBuffer.append(" account.fnumber >= ? and account.fnumber <= ? and account.fcompanyid in ( " + curComId + ")");
                sqlCPParam = new Object[]{accFrom, accTo};
                sqlAIParam = sqlCPParam;
            } else if (accFrom != null) {
                sqlWhereBuffer.append(" account.fnumber >= ? and account.fcompanyid in ( " + curComId + ")");
                sqlCPParam = new Object[]{accFrom};
                sqlAIParam = sqlCPParam;
            } else if (accTo != null) {
                sqlWhereBuffer.append(" account.fnumber <= ? and account.fcompanyid in ( " + curComId + ")");
                sqlCPParam = new Object[]{accTo};
                sqlAIParam = sqlCPParam;
            } else {
                sqlWhereBuffer.append(" account.fcompanyid in ( " + curComId + ")");
                sqlCPParam = new Object[]{};
                sqlAIParam = sqlCPParam;
            }
            if (disAccountNumber != null) {
                sqlWhereBuffer.append(" and account.fnumber in ").append(GLRptSQLUtil.getIdsSql(disAccountNumber)).append(" ");
            }
            sqlWhereBuffer.append(" and account.FAC = 1 ");
            sqlAIBuffer.append(sqlWhereBuffer);
            sqlAIBuffer.append(" order by item.fnumber");
            sqlAI = sqlAIBuffer.toString();
            sqlCPBuffer.append(sqlWhereBuffer);
            sqlCPBuffer.append(" and prop.Fdeletedstatus=1   ");
            sqlCPBuffer.append(" order by type1.fnumber");
            sqlCP = sqlCPBuffer.toString();
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sqlAI);
            for (int i = 0; i < sqlAIParam.length; ++i) {
                ps.setString(i + 1, (String)sqlAIParam[i]);
            }
            rs = ps.executeQuery();
            Vector<AcctCussentInfo.AcctCussentListColumnInfo> colInfo_ai = new Vector<AcctCussentInfo.AcctCussentListColumnInfo>();
            Vector<AcctCussentInfo.AcctCussentListColumnInfo> colInfo_ai_num = new Vector<AcctCussentInfo.AcctCussentListColumnInfo>();
            while (rs.next()) {
                propName = rs.getString("mappingPropName");
                boolean useLongNumber = rs.getBoolean("FuseLongNumber");
                String colKey = "assGrp." + propName + ".name";
                String colKey_num = null;
                colKey_num = !useLongNumber ? "assGrp." + propName + ".number" : "assGrp." + propName + ".longNumber";
                AcctCussentInfo.AcctCussentListColumnInfo colInfo = new AcctCussentInfo.AcctCussentListColumnInfo(0, AssistCustomizedDataTypeEnum.BUSINESSOBJECT, propName, colKey, rs.getString("fname"), ResourceBase.getString((String)REC, (String)"acct_name", (Locale)ctx.getLocale()));
                AcctCussentInfo.AcctCussentListColumnInfo colInfo_num = new AcctCussentInfo.AcctCussentListColumnInfo(0, AssistCustomizedDataTypeEnum.BUSINESSOBJECT, propName, colKey_num, rs.getString("fname"), ResourceBase.getString((String)REC, (String)"coding_number", (Locale)ctx.getLocale()));
                colInfo_ai.add(colInfo);
                colInfo_ai_num.add(colInfo_num);
                colInfo_ai_num.add(colInfo);
            }
            result[0] = colInfo_ai;
            result[5] = colInfo_ai_num;
        }
        catch (SQLException ex) {
            SQLUtils.cleanup(rs, ps, (Connection)conn);
            throw new SQLDataException(ex);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        try {
            ps = conn.prepareStatement(sqlCP);
            for (int i = 0; i < sqlCPParam.length; ++i) {
                ps.setString(i + 1, (String)sqlCPParam[i]);
            }
            rs = ps.executeQuery();
            Vector<AcctCussentInfo.AcctCussentListColumnInfo> colInfo_cp = new Vector<AcctCussentInfo.AcctCussentListColumnInfo>();
            while (rs.next()) {
                AssistCustomizedDataTypeEnum dataType = AssistCustomizedDataTypeEnum.getEnum((int)rs.getInt("dataType"));
                propName = rs.getString("mappingPropName");
                String colKey = "" + propName;
                if (AssistCustomizedDataTypeEnum.BUSINESSOBJECT.equals((Object)dataType)) {
                    colKey = colKey + ".name";
                }
                AcctCussentInfo.AcctCussentListColumnInfo colInfo = new AcctCussentInfo.AcctCussentListColumnInfo(1, dataType, propName, colKey, rs.getString("fname"));
                colInfo_cp.add(colInfo);
            }
            result[1] = colInfo_cp;
            String sql = "select fperiodid from v_gl_acperiod where fcompanyid  in (" + curComId + ")";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            HashSet<String> periodSet = new HashSet<String>();
            while (rs.next()) {
                periodSet.add(rs.getString(1));
            }
            result[9] = periodSet;
        }
        catch (SQLException ex) {
            throw new SQLDataException(ex);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        }
        return result;
    }

    @Override
    public IRowSet _fetchAsstactData(Context ctx, String cu) throws BOSException {
        StringBuffer strSQL = new StringBuffer();
        String fnameloc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        if (ContextUtil.getCurrentFIUnit((Context)ctx).getAccountTable() == null) {
            return null;
        }
        String accounttable = ContextUtil.getCurrentFIUnit((Context)ctx).getAccountTable().getId().toString();
        strSQL.append("Select distinct  a.FName_" + fnameloc + ",a.fnumber,a.frealdataobjalias_" + fnameloc + " ,   a.Fassthgattribute,a.FuseLongNumber\t\t\t\t\t\t\r\n");
        strSQL.append("From T_BD_AsstActType  a,t_bd_asstactgroupdetail b, t_bd_asstaccount c ,t_bd_accountview d\t\t\r\n");
        strSQL.append("Where a.fid=b.fasstacttypeid and b.fasstaccountid=c.fid and c.fid=d.fcaa and d.fcompanyid = '" + ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() + "'                                  \r\n");
        strSQL.append("  and d.faccounttableid = '" + accounttable + "' ORDER BY a.fnumber \t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return rs;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return super._getValue(ctx, pk, AcctCussentInfo.getDefaultListSelector());
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        return super._getValue(ctx, pk, selector == null ? AcctCussentInfo.getDefaultListSelector() : selector);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AcctCussentInfo info = (AcctCussentInfo)super._getValue(ctx, pk);
        return info.getLogInfo();
    }

    @Override
    protected PeriodEntity _requestPeriodEntity(Context ctx, IObjectValue _company) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)_company;
        SystemStatusCtrolCollection ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection("select currentPeriod.*,acPeriod.* where systemStatus.name=6 and company.id='" + company.getId() + "'");
        if (ctrols.size() > 0 && ctrols.get(0).getAcPeriod() != null && ctrols.get(0).getCurrentPeriod() != null) {
            return new PeriodEntity(this._getPeriodRangeNormal(ctx, 3, ctrols.get(0).getAcPeriod(), ctrols.get(0).getCurrentPeriod(), company));
        }
        return PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)company, (Context)ctx);
    }

    private Map _getPeriodRangeNormal(Context ctx, int type, PeriodInfo startPeriod, PeriodInfo currentPeriod, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        HashMap<String, Object> hashMap;
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TP.FPeriodYear, \r\n");
        sql.append("    Min(TP.FPeriodNumber) MinNumber, \r\n");
        sql.append("    Max(TP.FPeriodNumber) MaxNumber \r\n");
        sql.append("FROM T_BD_Period TP \r\n");
        sql.append("WHERE TP.FTypeID = ? \r\n");
        if ((type == 1 || type == 3) && startPeriod != null) {
            sql.append(" AND (TP.FPeriodYear>? or (TP.FPeriodYear=?  and TP.FPeriodNumber >= ?)) \r\n");
        }
        if ((type == 2 || type == 3) && currentPeriod != null) {
            sql.append(" AND (TP.FPeriodYear<? or(TP.FPeriodYear=? and TP.FPeriodNumber <= ?)) \r\n");
        }
        sql.append("GROUP BY TP.FPeriodYear \r\n");
        sql.append("ORDER BY TP.FPeriodYear \r\n");
        SqlParams parameter = new SqlParams();
        parameter.addString(company.getAccountPeriodType().getId().toString());
        if ((type == 1 || type == 3) && startPeriod != null) {
            parameter.addInt(startPeriod.getPeriodYear());
            parameter.addInt(startPeriod.getPeriodYear());
            parameter.addInt(startPeriod.getPeriodNumber());
        }
        if ((type == 2 || type == 3) && currentPeriod != null) {
            parameter.addInt(currentPeriod.getPeriodYear());
            parameter.addInt(currentPeriod.getPeriodYear());
            parameter.addInt(currentPeriod.getPeriodNumber());
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(parameter.getSqlWithParams(sql.toString()));
            stmt.setFetchSize(100);
            rs = stmt.executeQuery();
            int[] yearRange = new int[]{-1, -1};
            while (rs.next()) {
                int year = rs.getInt("FPeriodYear");
                yearRange[0] = yearRange[0] == -1 ? year : yearRange[0];
                yearRange[1] = year;
                int[] periodRange = new int[]{rs.getInt("MinNumber"), rs.getInt("MaxNumber")};
                if (periodRange[0] <= 0 || periodRange[1] <= 0) {
                    throw new RptException(RptException.PERIOD_ERROR);
                }
                map.put(new Integer(year), periodRange);
            }
            if (yearRange[0] <= 0 || yearRange[1] <= 0 || yearRange[0] < startPeriod.getPeriodYear() || yearRange[1] > currentPeriod.getPeriodYear() || map.size() <= 0) {
                throw new RptException(RptException.PERIOD_ERROR);
            }
            int maxYear = 0;
            int maxPeriod = 0;
            for (Object key : map.keySet()) {
                if (!(key instanceof Integer)) continue;
                int buf = (Integer)key;
                maxYear = maxYear < buf ? buf : maxYear;
            }
            int[] value = (int[])map.get(new Integer(maxYear));
            int n = value.length;
            for (int i = 0; i < n; ++i) {
                maxPeriod = maxPeriod < value[i] ? value[i] : maxPeriod;
            }
            HashMap<String, Object> allMap = new HashMap<String, Object>();
            HashMap<Integer, int[]> map2 = new HashMap<Integer, int[]>();
            map2.putAll(map);
            allMap.put("usedPeriod", map);
            allMap.put("queryPeriod", map2);
            allMap.put("currentPeriod", new int[]{maxYear, maxPeriod});
            String periodType = company.getAccountPeriodType().getId().toString();
            StringBuffer sb = new StringBuffer();
            sb.append("select A.c, A.FPeriodYear, B.FPeriodNumber from").append("\n (select count(1) c, FPeriodYear from t_bd_period where FTypeID=? and FPeriodYear*100+FPeriodNumber>? group by FPeriodYear) A").append("\n inner join t_bd_period B on B.FPeriodYear=A.FPeriodYear and B.FPeriodYear*100+B.FPeriodNumber>?").append("\n order by A.FPeriodYear, B.FPeriodNumber");
            RptRowSet rs2 = DBUtil.executeQuery((String)sb.toString(), (SqlParams)new SqlParams().addString(periodType).addInt(maxYear * 100 + maxPeriod).addInt(maxYear * 100 + maxPeriod), (Connection)con);
            int i = 0;
            while (rs2.next()) {
                int n2 = rs2.getInt("c");
                if (n2 == 0) continue;
                int year = rs2.getInt("FPeriodYear");
                int[] p = new int[n2];
                p[0] = rs2.getInt("FPeriodNumber");
                i = 0;
                while (i++ < n2 - 1) {
                    rs2.next();
                    p[i] = rs2.getInt("FPeriodNumber");
                }
                Integer kk = new Integer(year);
                if (map2.containsKey(kk)) {
                    int[] op = (int[])map2.get(kk);
                    int[] np = new int[op.length + p.length];
                    System.arraycopy(op, 0, np, 0, op.length);
                    System.arraycopy(p, 0, np, op.length, p.length);
                    p = np;
                }
                int max = 0;
                int min = Integer.MAX_VALUE;
                for (int m = 0; m < p.length; ++m) {
                    max = max < p[m] ? p[m] : max;
                    min = min > p[m] ? p[m] : min;
                }
                map2.put(kk, new int[]{min, max});
            }
            hashMap = allMap;
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return hashMap;
    }

    @Override
    protected List _fetchAsstactData(Context ctx, String[] companyIds, String[] cuIds) throws BOSException, EASBizException {
        return RptServerUtil.queryCussentAsstAct(companyIds, cuIds, ctx);
    }

    @Override
    protected Map _getPeriodRange(Context ctx, Set companyIdSet, String periodTypeId) throws BOSException, EASBizException {
        return GlUtils.getAcctCussentPeriodRange(ctx, companyIdSet, periodTypeId);
    }
}

