/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountCurrencyFactory;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.account.IAccountCurrency;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFactory;
import com.kingdee.eas.fi.gl.AcctCussentHistoryInfo;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.BaseVoucherCollection;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.GLVerifyTypeEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAcctCussentHistory;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.VerifyManualAutoEnum;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.AbstractAcctCussentHistoryControllerBean;
import com.kingdee.eas.fi.gl.app.GLAcctAgeNewUtils;
import com.kingdee.eas.fi.gl.app.voucher.AutoVerifyService;
import com.kingdee.eas.fi.gl.common.ACAuditCancelFilterHelper;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctCussentHistoryControllerBean
extends AbstractAcctCussentHistoryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.AcctCussentHistoryControllerBean");
    private final BigDecimal ZERO = new BigDecimal("0");
    int count = 0;
    int BATCH_COUNT = 200;
    PreparedStatement sqlInsert;
    int length = 0;
    public static final int INTIME_VERIFY_BALTYPE_VALUE = 6;
    public static final int NOT_INTIME_VERIFY_BALTYPE_VALUE = 5;
    private boolean fromVch = false;

    @Override
    protected void _autoVerifyOneAcct(Context ctx, HashMap param) throws BOSException, EASBizException {
        AccountViewInfo acct = (AccountViewInfo)param.get("account");
        List listCurrencyID = this.getCurrencyListFromParam(ctx, param, acct);
        CurrencyInfo cyInfo = null;
        Iterator it = listCurrencyID.iterator();
        AutoVerifyService autoVerify = new AutoVerifyService();
        while (it.hasNext()) {
            cyInfo = (CurrencyInfo)it.next();
            param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.CURRENCY, cyInfo);
            autoVerify.autoVerify(ctx, param);
        }
    }

    public List getCurrencyListFromParam(Context ctx, HashMap param, AccountViewInfo acct) throws EASBizException, BOSException {
        ArrayList<Object> listCurrencyID = new ArrayList<Object>();
        boolean isAllCurrency = false;
        if (param.get("currency") instanceof CurrencyInfo && ((CurrencyInfo)param.get("currency")).getNumber().compareToIgnoreCase("all") == 0) {
            AccountingCurrencyEnum acctCy = AccountingCurrencyEnum.ALLCURRENCY;
            if (acct != null) {
                acctCy = acct.getAccountingcurrency();
            }
            if (acctCy == AccountingCurrencyEnum.NOCURRENCY) {
                listCurrencyID.add(param.get("LOCALCURRENCY"));
            } else if (acctCy == AccountingCurrencyEnum.ONECURRENCY) {
                CurrencyCollection cyColl = this.getAcctCyColl(ctx, acct);
                Iterator it = cyColl.iterator();
                while (it.hasNext()) {
                    listCurrencyID.add((CurrencyInfo)it.next());
                }
            } else if (acctCy == AccountingCurrencyEnum.ALLCURRENCY) {
                CurrencyCollection cyColl = this.getAllCyColl(ctx);
                Iterator it = cyColl.iterator();
                while (it.hasNext()) {
                    listCurrencyID.add((CurrencyInfo)it.next());
                }
            }
            isAllCurrency = true;
        } else {
            listCurrencyID.add(param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.CURRENCY));
        }
        return listCurrencyID;
    }

    private CurrencyCollection getAcctCyColl(Context ctx, AccountViewInfo acct) throws BOSException, EASBizException {
        CurrencyCollection CyColl = new CurrencyCollection();
        IAccountCurrency iac = AccountCurrencyFactory.getLocalInstance((Context)ctx);
        AccountCurrencyCollection acColl = iac.getAccountCurrencyCollection("select currency.id where accountView.id = '" + acct.getId().toString() + "'");
        AccountCurrencyInfo acInfo = null;
        CurrencyInfo cyInfo = null;
        for (int i = 0; i < acColl.size(); ++i) {
            acInfo = acColl.get(i);
            cyInfo = new CurrencyInfo();
            cyInfo.setId(acInfo.getCurrency().getId());
            CyColl.add(cyInfo);
        }
        return CyColl;
    }

    private CurrencyCollection getAllCyColl(Context ctx) throws BOSException, EASBizException {
        CurrencyCollection CyColl = new CurrencyCollection();
        ICurrency icy = CurrencyFactory.getLocalInstance((Context)ctx);
        CyColl = icy.getCurrencyCollection(true);
        return CyColl;
    }

    protected int _autoVerifyProcess(Context ctx, HashMap param, AccountViewInfo acct, ArrayList verifySrcData, ArrayList verifyDesData) throws BOSException, EASBizException {
        HashMap pair = new HashMap();
        HashMap dateMap = new HashMap();
        ArrayList<String> verifyAsstIds = new ArrayList<String>();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        boolean isVerifyAmtBySame = false;
        boolean isAmtMustSame = false;
        BigDecimal willAmt = null;
        BigDecimal amount = null;
        if (company == null) {
            company = ContextUtil.getCurrentFIUnit((Context)ctx);
            param.put("company", company);
        }
        if (param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYSAMEBYAMT) != null) {
            isVerifyAmtBySame = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYSAMEBYAMT);
        }
        if (param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYAMTMUSTSAME) != null) {
            isAmtMustSame = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYAMTMUSTSAME);
        }
        for (int i = 0; i < verifyDesData.size(); ++i) {
            HashMap item = (HashMap)verifyDesData.get(i);
            String assgrp = (String)item.get("FAssGrpID");
            String upid = (String)item.get("voucherAssistRecordId");
            String bizNumber = item.get("FBizNumber") == null ? "" : (String)item.get("FBizNumber");
            willAmt = GlUtils.zero;
            if (item.get("FUnverifiedAmtFor") != null) {
                willAmt = (BigDecimal)item.get("FUnverifiedAmtFor");
            }
            ArrayList<String> sbDown = new ArrayList<String>();
            ArrayList<String> sbDownByAmt = new ArrayList<String>();
            for (int j = 0; j < verifySrcData.size(); ++j) {
                HashMap item2 = (HashMap)verifySrcData.get(j);
                String assgrp2 = (String)item2.get("FAssGrpID");
                String upid2 = (String)item2.get("acctCussentId");
                String bizNumber2 = item2.get("FBizNumber") == null ? "" : (String)item2.get("FBizNumber");
                amount = GlUtils.zero;
                if (item2.get("FUnverifiedAmtFor") != null) {
                    amount = (BigDecimal)item2.get("FUnverifiedAmtFor");
                }
                if (!this.checkCanVerify(param, bizNumber, bizNumber2, assgrp, assgrp2)) continue;
                if ((isVerifyAmtBySame || isAmtMustSame) && willAmt.compareTo(amount) == 0) {
                    sbDownByAmt.add(upid2);
                } else {
                    sbDown.add(upid2);
                }
                dateMap.put(upid2, item2.get("FLastUpdateTime"));
            }
            if (isAmtMustSame && sbDownByAmt.size() == 0 || sbDown.size() <= 0) continue;
            verifyAsstIds.add(upid);
            sbDownByAmt.addAll(sbDown);
            pair.put(upid, sbDownByAmt);
            dateMap.put(upid, item.get("FLastUpdateTime"));
        }
        int pairSize = pair.size();
        if (pair.size() > 0) {
            this._verify(ctx, verifyAsstIds.toArray(new String[0]), pair, dateMap, company, VerifyManualAutoEnum.Auto);
        }
        return pairSize;
    }

    private boolean checkCanVerify(HashMap param, String bizNumber, String bizNumber2, String assgrp, String assgrp2) {
        boolean checkBizNum = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.UNCHECKBIZNUM) == false;
        boolean checkNullBizNumIsNotSame = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.NULLBIZNUMISNOTSAME);
        return (!checkBizNum || (checkNullBizNumIsNotSame || bizNumber.equals(bizNumber2)) && (!checkNullBizNumIsNotSame || bizNumber.equals(bizNumber2) && !StringUtils.isEmpty((String)bizNumber) && !StringUtils.isEmpty((String)bizNumber2))) && assgrp.equals(assgrp2);
    }

    private Map getVerifyVchIds(Context ctx, String[] verifyAsstIds) throws BOSException {
        HashMap<String, String[]> verifyVchIds = new HashMap<String, String[]>();
        String[] strIds = null;
        try {
            String sql = "select vst.fid,vst.fbillid,vst.fentryid,pd.fnumber from t_gl_voucherassistrecord vst inner join t_gl_voucher v on v.fid = vst.fbillid inner join t_bd_period pd on pd.fid = v.fperiodid where vst.fid in " + SQLUtil.arrayToInList(verifyAsstIds);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                strIds = new String[]{rs.getString("fbillid"), rs.getString("fentryid"), rs.getString("fnumber")};
                verifyVchIds.put(rs.getString("fid"), strIds);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return verifyVchIds;
    }

    @Override
    protected void _verify(Context ctx, String[] verifyAsstIds, Map pair, Map dateMap, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        this._verify(ctx, verifyAsstIds, pair, dateMap, company, VerifyManualAutoEnum.Manual);
    }

    @Override
    protected void _verify(Context ctx, Map verifyAsstIds, Map pair, Map dataMap, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        Set acts = verifyAsstIds.keySet();
        int i = 0;
        for (String actNumber : acts) {
            ArrayList verifyAsstId = (ArrayList)verifyAsstIds.get(actNumber);
            try {
                pair.put("actNumber", actNumber);
                this._verify(ctx, verifyAsstId.toArray(new String[0]), pair, dataMap, company, VerifyManualAutoEnum.Manual);
            }
            catch (Exception e) {
                ++i;
            }
        }
        if (i == acts.size()) {
            throw new GLException(GLException.CUSSENT_VERIFY_NO_MATCH_RECORD);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _verify(Context ctx, String[] verifyAsstIds, Map pair, Map dateMap, CompanyOrgUnitInfo company, VerifyManualAutoEnum verifyManualAuto) throws BOSException, EASBizException {
        PreparedStatement sqlInsert;
        Connection con;
        block9: {
            HashSet cussSet = new HashSet();
            String companyId = company.getId().toString();
            String accountid = (String)pair.get("actNumber");
            con = null;
            sqlInsert = null;
            Uuid requestId = null;
            try {
                boolean isFromVchUI;
                List cussentVchIds;
                requestId = GLMutexUtils.setAcExclusiveMutex(ctx, companyId, accountid, GLMutexUtils.GL_Verify, logger);
                for (int i = 0; i < verifyAsstIds.length; ++i) {
                    List cussentVchIds2 = (List)pair.get(verifyAsstIds[i]);
                    if (dateMap == null || dateMap.size() <= 0) continue;
                    cussSet.addAll(cussentVchIds2);
                }
                this.checkBeforeVerify(ctx, cussSet.toArray(new String[0]), false, dateMap);
                this.checkBeforeVerify(ctx, verifyAsstIds, true, dateMap);
                Map mapVeriVchEntryIds = this.getVerifyVchIds(ctx, verifyAsstIds);
                con = this.getConnection(ctx);
                sqlInsert = con.prepareStatement(this.getInsertSQL());
                Counter counterInsert = new Counter();
                ArrayList verifiedSrc = new ArrayList();
                GLVerifyTypeEnum glVerifyType = GLVerifyTypeEnum.COMMON_VERIFY;
                int verifyCnt = 0;
                for (int i = 0; i < verifyAsstIds.length; verifyCnt += this.commonVerify(ctx, cussentVchIds.toArray(new String[0]), new String[]{verifyAsstIds[i]}, false, glVerifyType, verifiedSrc, sqlInsert, counterInsert, company, mapVeriVchEntryIds, verifyManualAuto), ++i) {
                    cussentVchIds = (List)pair.get(verifyAsstIds[i]);
                    cussentVchIds.removeAll(verifiedSrc);
                }
                if (counterInsert.getValue() > 0) {
                    sqlInsert.executeBatch();
                    sqlInsert.clearBatch();
                    counterInsert.clear();
                }
                boolean bl = isFromVchUI = dateMap == null || dateMap.size() == 0;
                if (!isFromVchUI && verifyCnt == 0) {
                    throw new GLException(GLException.CUSSENT_VERIFY_NO_MATCH_RECORD);
                }
                if (requestId == null) break block9;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (requestId != null) {
                        GLMutexUtils.releaseMutex(ctx, requestId);
                    }
                    SQLUtils.cleanup(sqlInsert, con);
                    throw throwable;
                }
            }
            GLMutexUtils.releaseMutex(ctx, requestId);
        }
        SQLUtils.cleanup((Statement)sqlInsert, (Connection)con);
    }

    private void checkBeforeVerify(Context ctx, String[] ids, boolean isAsst, Map dateMap) throws SQLDataException, GLException, BOSException {
        if (ids.length == 0 || dateMap == null) {
            return;
        }
        String sqlSelect = null;
        sqlSelect = isAsst ? "select a.FVCHASSISTRECORDID,a.flastupdatetime from t_gl_acctverify a where a.FVCHASSISTRECORDID in ({0}) " : "select fid,flastupdatetime from t_gl_acctcussent where fid in ({0}) ";
        try {
            int count = 0;
            StringBuffer sqlVars = new StringBuffer();
            ArrayList<String> params = new ArrayList<String>();
            HashMap<String, Timestamp> selectResult = new HashMap<String, Timestamp>();
            for (int i = 0; i < ids.length; ++i) {
                sqlVars.append(",?");
                params.add(ids[i]);
                if (++count % 500 != 0) continue;
                sqlVars.deleteCharAt(0);
                String sql = MessageFormat.format(sqlSelect, sqlVars.toString());
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params.toArray());
                while (rs.next()) {
                    selectResult.put(rs.getString(1), rs.getTimestamp(2));
                }
                this.compareDate(selectResult, dateMap, params);
                count = 0;
                sqlVars.delete(0, sqlVars.length());
                params.clear();
                selectResult.clear();
            }
            if (count > 0) {
                sqlVars.deleteCharAt(0);
                String sql = MessageFormat.format(sqlSelect, sqlVars.toString());
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params.toArray());
                while (rs.next()) {
                    selectResult.put(rs.getString(1), rs.getTimestamp(2));
                }
                this.compareDate(selectResult, dateMap, params);
                count = 0;
                sqlVars.delete(0, sqlVars.length());
                params.clear();
                selectResult.clear();
            }
        }
        catch (SQLException e) {
            new SQLDataException(e);
        }
    }

    private void compareDate(Map selectResult, Map dateMap, List params) throws GLException {
        Iterator it = params.iterator();
        String key = null;
        while (it.hasNext()) {
            key = (String)it.next();
            Date oldDate = (Date)dateMap.get(key);
            Timestamp newDate = (Timestamp)selectResult.get(key);
            if (oldDate == null && newDate == null) continue;
            if (oldDate == null) {
                throw new GLException(GLException.DATA_HAS_MODIFIED);
            }
            Timestamp ts = new Timestamp(oldDate.getTime());
            if (newDate == null) {
                throw new GLException(GLException.DATA_HAS_MODIFIED);
            }
            if (ts.compareTo(newDate) == 0) continue;
            throw new GLException(GLException.DATA_HAS_MODIFIED);
        }
    }

    @Override
    protected void _sameVerify(Context ctx, Map pairs, Map dateMap) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        this.sameVerifyByCompany(ctx, pairs, dateMap, company);
    }

    private void sameVerifyByCompany(Context ctx, Map pairs, Map dateMap, CompanyOrgUnitInfo company) throws SQLDataException, GLException, BOSException, EASBizException {
        Set actSet = pairs.keySet();
        int i = 0;
        for (String key : actSet) {
            PreparedStatement sqlInsert;
            Connection con;
            Uuid requestId;
            block8: {
                List ids = (List)pairs.get(key);
                this.checkBeforeVerify(ctx, ids.toArray(new String[0]), false, dateMap);
                requestId = GLMutexUtils.setAcExclusiveMutex(ctx, company.getId().toString(), key, GLMutexUtils.GL_Verify, logger);
                con = null;
                sqlInsert = null;
                try {
                    boolean isFromVchUI;
                    con = this.getConnection(ctx);
                    sqlInsert = con.prepareStatement(this.getInsertSQL());
                    ArrayList<Map> positiveCuss = new ArrayList<Map>();
                    ArrayList<Map> negativeCuss = new ArrayList<Map>();
                    HashMap<String, Map> positiveCussMap = new HashMap<String, Map>();
                    HashMap<String, Map> negativeCussMap = new HashMap<String, Map>();
                    Counter counter = new Counter();
                    String tableName = null;
                    if (ids.size() > 500) {
                        tableName = this.initIdsTmpTable(ctx, ids);
                    }
                    this.initVerifyData(ctx, ids, positiveCussMap, negativeCussMap, tableName);
                    this.setPositAndNegatList(ids, positiveCuss, negativeCuss, positiveCussMap, negativeCussMap);
                    int verifyCnt = this.sameVerify_New(ctx, positiveCuss, negativeCuss, sqlInsert, counter, company);
                    if (counter.getValue() > 0) {
                        sqlInsert.executeBatch();
                        sqlInsert.clearBatch();
                        counter.clear();
                    }
                    boolean bl = isFromVchUI = dateMap == null || dateMap.size() == 0;
                    if (isFromVchUI || verifyCnt != 0) break block8;
                    ++i;
                }
                catch (SQLException e) {
                    try {
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        GLMutexUtils.releaseMutex(ctx, requestId);
                        SQLUtils.cleanup(sqlInsert, (Connection)con);
                        throw throwable;
                    }
                }
            }
            GLMutexUtils.releaseMutex(ctx, requestId);
            SQLUtils.cleanup((Statement)sqlInsert, (Connection)con);
        }
        if (i == actSet.size()) {
            throw new GLException(GLException.CUSSENT_VERIFY_NO_MATCH_RECORD);
        }
    }

    private void setPositAndNegatList(List<String> ids, List positiveCuss, List negativeCuss, Map<String, Map> positiveCussMap, Map<String, Map> negativeCussMap) {
        for (String id : ids) {
            if (positiveCussMap.containsKey(id)) {
                positiveCuss.add(positiveCussMap.get(id));
                continue;
            }
            if (!negativeCussMap.containsKey(id)) continue;
            negativeCuss.add(negativeCussMap.get(id));
        }
    }

    private String getInsertSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into T_GL_AcctCussentHistory (\t\t\t\t\t\t\t\t\r\n");
        sql.append("FID,FOroginalAmount,FLocalAmount,FReportAmount,FQty,\t\t\t\r\n");
        sql.append("ForiginalBalance,FlocalBalance,FreportBanlance,FqtyBalance,\t\r\n");
        sql.append("FCussentidID,FVoucherAsstIDID,FDC,FVerifyDate,FAccountID,\t\t\r\n");
        sql.append("FAssGrpID,FCurrencyID,FCreatorID,FCompanyId,\t\t\t\t\t\t\r\n");
        sql.append("FNumber,FSeq,FBalType,FVchNumber,FVchDate,FVerVchDate,FBizDate,FbizNumber,FDescription, \r\n");
        sql.append("FVerifyManualAuto,FVeriVchID,FVeriEntryID,                                 \r\n");
        sql.append(" FCussVchID,FCussEntryID,         \r\n");
        sql.append(" FCussPeriod,FVeriPeriod,         \r\n");
        sql.append(" FCussOriginalAmount,             \r\n");
        sql.append(" FCussLocalAmount,                \r\n");
        sql.append(" FCussReportAmount,               \r\n");
        sql.append(" FCussQty )                        \r\n");
        sql.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,");
        sql.append(" ?,?,?,?,?,?,?,?)                   \r\n");
        return sql.toString();
    }

    private int commonVerify(Context ctx, String[] srcIDs, String[] objIDs, boolean isNegative, GLVerifyTypeEnum verifyType, List verifiedSrc, PreparedStatement sqlInsert, Counter counter, CompanyOrgUnitInfo company, Map mapVeriVchEntryIds) throws BOSException, EASBizException, SQLException {
        return this.commonVerify(ctx, srcIDs, objIDs, isNegative, verifyType, verifiedSrc, sqlInsert, counter, company, mapVeriVchEntryIds, VerifyManualAutoEnum.Manual);
    }

    private int commonVerify(Context ctx, String[] srcIDs, String[] objIDs, boolean isNegative, GLVerifyTypeEnum verifyType, List verifiedSrc, PreparedStatement sqlInsert, Counter counter, CompanyOrgUnitInfo company, Map mapVeriVchEntryIds, VerifyManualAutoEnum verifyManualAuto) throws BOSException, EASBizException, SQLException {
        int verifyCnt = 0;
        BigDecimal originalAmount = null;
        BigDecimal localAmount = null;
        BigDecimal reportingAmount = null;
        BigDecimal qty = null;
        BigDecimal unverifiedAmtFor = null;
        BigDecimal unverifiedAmtLocal = null;
        BigDecimal unverifiedAmtRpt = null;
        BigDecimal unverifiedAmtQty = null;
        boolean flag = false;
        Date verifyDate = DateTimeUtils.truncateDate((Date)new Date());
        String verifyNumber = this.getAcctcussentHistoryNumber(ctx, verifyDate, company);
        int Seq = 1;
        ArrayList<IObjectPK> logPKs = new ArrayList<IObjectPK>();
        block0: for (int i = 0; i < objIDs.length && !flag; ++i) {
            Map amountHxMap = this.getVerifyAmount(ctx, objIDs[i]);
            BigDecimal tempO = (BigDecimal)amountHxMap.get("FUnverifiedAmtFor");
            BigDecimal tempL = (BigDecimal)amountHxMap.get("FUnverifiedAmtLocal");
            BigDecimal tempR = (BigDecimal)amountHxMap.get("FUnverifiedAmtRpt");
            BigDecimal tempQ = (BigDecimal)amountHxMap.get("FUnverifiedAmtQty");
            if (tempO.compareTo(this.ZERO) == 0) continue;
            if (originalAmount == null || originalAmount.compareTo(this.ZERO) <= 0 && !isNegative || originalAmount.compareTo(this.ZERO) >= 0 && isNegative) {
                originalAmount = tempO;
                localAmount = tempL;
                reportingAmount = tempR;
                qty = tempQ;
                if (originalAmount.compareTo(this.ZERO) < 0 && !isNegative || originalAmount.compareTo(this.ZERO) > 0 && isNegative) continue;
            }
            for (int j = 0; !(j >= srcIDs.length || originalAmount.compareTo(this.ZERO) <= 0 && !isNegative || originalAmount.compareTo(this.ZERO) >= 0 && isNegative); ++j) {
                if (verifiedSrc.contains(srcIDs[j])) continue;
                Map amountGzMap = this.getUnverifiedAmt(ctx, srcIDs[j]);
                BigDecimal tempU = (BigDecimal)amountGzMap.get("FUnverifiedAmtFor");
                BigDecimal tempUL = (BigDecimal)amountGzMap.get("FUnverifiedAmtLocal");
                BigDecimal tempUR = (BigDecimal)amountGzMap.get("FUnverifiedAmtRpt");
                BigDecimal tempUQ = (BigDecimal)amountGzMap.get("FUnverifiedQty");
                if (tempU.compareTo(this.ZERO) == 0) {
                    verifiedSrc.add(srcIDs[j]);
                    continue;
                }
                if (unverifiedAmtFor == null || unverifiedAmtFor.compareTo(this.ZERO) <= 0 && !isNegative || unverifiedAmtFor.compareTo(this.ZERO) >= 0 && isNegative) {
                    unverifiedAmtFor = tempU;
                    unverifiedAmtLocal = tempUL;
                    unverifiedAmtRpt = tempUR;
                    unverifiedAmtQty = tempUQ;
                    if (tempU.compareTo(this.ZERO) < 0 && !isNegative || tempU.compareTo(this.ZERO) > 0 && isNegative) {
                        verifiedSrc.add(srcIDs[j]);
                        continue;
                    }
                }
                amountGzMap.put("FNumber", verifyNumber);
                amountGzMap.put("FVerifyDate", verifyDate);
                amountGzMap.put("FSeq", new Integer(Seq++));
                AcctCussentHistoryInfo acctCussentHistoryInfo = this.createAcctCussentHistoryInfo(ctx, amountGzMap, srcIDs[j], objIDs[i], verifyType, company, amountHxMap);
                if (originalAmount.compareTo(unverifiedAmtFor) > 0 && !isNegative || originalAmount.compareTo(unverifiedAmtFor) < 0 && isNegative) {
                    acctCussentHistoryInfo.setOroginalAmount(unverifiedAmtFor);
                    acctCussentHistoryInfo.setOriginalBalance(GlUtils.zero);
                    originalAmount = originalAmount.subtract(unverifiedAmtFor);
                    if (unverifiedAmtLocal.compareTo(localAmount) <= 0) {
                        acctCussentHistoryInfo.setLocalAmount(unverifiedAmtLocal);
                        acctCussentHistoryInfo.setLocalBalance(GlUtils.zero);
                        localAmount = localAmount.subtract(unverifiedAmtLocal);
                    } else {
                        acctCussentHistoryInfo.setLocalAmount(localAmount);
                        acctCussentHistoryInfo.setLocalBalance(unverifiedAmtLocal.subtract(localAmount));
                        localAmount = GlUtils.zero;
                    }
                    if (unverifiedAmtRpt.compareTo(reportingAmount) <= 0) {
                        acctCussentHistoryInfo.setReportAmount(unverifiedAmtRpt);
                        acctCussentHistoryInfo.setReportBanlance(GlUtils.zero);
                        reportingAmount = reportingAmount.subtract(unverifiedAmtRpt);
                    } else {
                        acctCussentHistoryInfo.setReportAmount(reportingAmount);
                        acctCussentHistoryInfo.setReportBanlance(unverifiedAmtRpt.subtract(reportingAmount));
                        reportingAmount = GlUtils.zero;
                    }
                    if (unverifiedAmtQty.compareTo(qty) <= 0) {
                        acctCussentHistoryInfo.setQty(unverifiedAmtQty);
                        acctCussentHistoryInfo.setQtyBalance(GlUtils.zero);
                        qty = qty.subtract(unverifiedAmtQty);
                    } else {
                        acctCussentHistoryInfo.setQty(qty);
                        acctCussentHistoryInfo.setQtyBalance(unverifiedAmtQty.subtract(qty));
                        qty = GlUtils.zero;
                    }
                    this.addBeginLog(ctx, acctCussentHistoryInfo, logPKs);
                    this.insertHistory(ctx, acctCussentHistoryInfo, verifyType, sqlInsert, counter);
                    ++verifyCnt;
                    this.updateUnverifiedAmtFor(ctx, srcIDs[j], acctCussentHistoryInfo);
                    unverifiedAmtFor = GlUtils.zero;
                    unverifiedAmtLocal = GlUtils.zero;
                    unverifiedAmtRpt = GlUtils.zero;
                    unverifiedAmtQty = GlUtils.zero;
                    verifiedSrc.add(srcIDs[j]);
                    this.updateUnverifiedAmtFor(ctx, objIDs[i], new BigDecimal[]{originalAmount, localAmount, reportingAmount, qty});
                    if (j + 1 < srcIDs.length) continue;
                    flag = true;
                    continue block0;
                }
                if (originalAmount.compareTo(unverifiedAmtFor) < 0 && !isNegative || originalAmount.compareTo(unverifiedAmtFor) > 0 && isNegative) {
                    acctCussentHistoryInfo.setOroginalAmount(originalAmount);
                    acctCussentHistoryInfo.setLocalAmount(localAmount);
                    acctCussentHistoryInfo.setReportAmount(reportingAmount);
                    acctCussentHistoryInfo.setQty(qty);
                    acctCussentHistoryInfo.setOriginalBalance(unverifiedAmtFor.subtract(originalAmount));
                    acctCussentHistoryInfo.setLocalBalance(unverifiedAmtLocal.subtract(localAmount));
                    acctCussentHistoryInfo.setReportBanlance(unverifiedAmtRpt.subtract(reportingAmount));
                    acctCussentHistoryInfo.setQtyBalance(unverifiedAmtQty.subtract(qty));
                    this.addBeginLog(ctx, acctCussentHistoryInfo, logPKs);
                    this.insertHistory(ctx, acctCussentHistoryInfo, verifyType, sqlInsert, counter);
                    ++verifyCnt;
                    this.changeVerifiedStatus(ctx, objIDs[i]);
                    this.updateUnverifiedAmtFor(ctx, srcIDs[j], acctCussentHistoryInfo);
                    unverifiedAmtFor = unverifiedAmtFor.subtract(originalAmount);
                    unverifiedAmtLocal = unverifiedAmtLocal.subtract(localAmount);
                    unverifiedAmtRpt = unverifiedAmtRpt.subtract(reportingAmount);
                    unverifiedAmtQty = unverifiedAmtQty.subtract(qty);
                    originalAmount = GlUtils.zero;
                    localAmount = GlUtils.zero;
                    reportingAmount = GlUtils.zero;
                    qty = GlUtils.zero;
                    this.updateUnverifiedAmtFor(ctx, objIDs[i], new BigDecimal[]{originalAmount, localAmount, reportingAmount, qty});
                    if (i + 1 < objIDs.length) {
                        if (j + 1 >= srcIDs.length) continue block0;
                        continue;
                    }
                    flag = true;
                    continue block0;
                }
                acctCussentHistoryInfo.setOroginalAmount(originalAmount);
                acctCussentHistoryInfo.setLocalAmount(localAmount);
                acctCussentHistoryInfo.setReportAmount(reportingAmount);
                acctCussentHistoryInfo.setQty(qty);
                acctCussentHistoryInfo.setOriginalBalance(GlUtils.zero);
                acctCussentHistoryInfo.setLocalBalance(unverifiedAmtLocal.subtract(localAmount));
                acctCussentHistoryInfo.setReportBanlance(unverifiedAmtRpt.subtract(reportingAmount));
                acctCussentHistoryInfo.setQtyBalance(unverifiedAmtQty.subtract(qty));
                this.addBeginLog(ctx, acctCussentHistoryInfo, logPKs);
                this.insertHistory(ctx, acctCussentHistoryInfo, verifyType, sqlInsert, counter);
                ++verifyCnt;
                this.changeVerifiedStatus(ctx, objIDs[i]);
                this.updateUnverifiedAmtFor(ctx, srcIDs[j], acctCussentHistoryInfo);
                unverifiedAmtFor = GlUtils.zero;
                unverifiedAmtLocal = GlUtils.zero;
                unverifiedAmtRpt = GlUtils.zero;
                unverifiedAmtQty = GlUtils.zero;
                originalAmount = GlUtils.zero;
                localAmount = GlUtils.zero;
                reportingAmount = GlUtils.zero;
                qty = GlUtils.zero;
                verifiedSrc.add(srcIDs[j]);
                this.updateUnverifiedAmtFor(ctx, objIDs[i], new BigDecimal[]{originalAmount, localAmount, reportingAmount, qty});
                if (i + 1 < objIDs.length) {
                    if (j + 1 < srcIDs.length) continue;
                    flag = true;
                    continue block0;
                }
                flag = true;
                continue block0;
            }
        }
        this.excuteAfterLog(ctx, logPKs);
        return verifyCnt;
    }

    private void updateUnverifiedAmtFor(Context ctx, String srcID, BigDecimal[] vals) throws BOSException {
        String sql = "update T_GL_AcctVerify set FUnverifiedAmtFor = ? , FUnverifiedAmtLocal=? , FUnverifiedAmtRpt=? , FUnverifiedQty=? where FVchAssistRecordID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{vals[0], vals[1], vals[2], vals[3], srcID});
    }

    private void excuteAfterLog(Context ctx, ArrayList<IObjectPK> logPKs) {
        if (null == logPKs || logPKs.size() == 0) {
            return;
        }
        for (int i = 0; i < logPKs.size(); ++i) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPKs.get(i));
        }
    }

    private void addBeginLog(Context ctx, AcctCussentHistoryInfo acctCussentHistoryInfo, ArrayList<IObjectPK> logPKs) {
        HashSet<String> hisIdSet = new HashSet<String>();
        String number = null;
        if (acctCussentHistoryInfo.getCussVch() == null) {
            number = "initData";
        } else {
            hisIdSet.add(acctCussentHistoryInfo.getCussVch().getId().toString());
        }
        if (acctCussentHistoryInfo.getVeriVch() != null) {
            hisIdSet.add(acctCussentHistoryInfo.getVeriVch().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", hisIdSet, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("number"));
        try {
            BaseVoucherCollection baseVoucherCollection = VoucherFactory.getLocalInstance((Context)ctx).getBaseVoucherCollection(view);
            if (baseVoucherCollection.size() > 0) {
                if (number == null) {
                    number = baseVoucherCollection.get(hisIdSet.size() - 1).getNumber();
                }
                IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"unverfyVoucher", (BOSObjectType)baseVoucherCollection.get(0).getBOSType(), null, (String)(acctCussentHistoryInfo.getNumber() + ";" + number + ";" + baseVoucherCollection.get(0).getNumber()), (String)"gl_AcctCussentHistory");
                logPKs.add(logPK);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void clear4AmountZero(BigDecimal originalAmount, BigDecimal localAmount, BigDecimal reportingAmount, BigDecimal qty) {
        originalAmount = GlUtils.zero;
        localAmount = GlUtils.zero;
        reportingAmount = GlUtils.zero;
        qty = GlUtils.zero;
    }

    private int sameVerify(Context ctx, String[] srcIDs, List verifiedSrc, List positiveCuss, List negativeCuss, PreparedStatement sqlInsert, Counter counter, CompanyOrgUnitInfo company) throws BOSException, EASBizException, SQLException {
        int verifyCnt = 0;
        BigDecimal unverifiedAmtForI = null;
        BigDecimal unverifiedAmtLocalI = null;
        BigDecimal unverifiedAmtRptI = null;
        BigDecimal unverifiedAmtQtyI = null;
        BigDecimal unverifiedAmtForJ = null;
        BigDecimal unverifiedAmtLocalJ = null;
        BigDecimal unverifiedAmtRptJ = null;
        BigDecimal unverifiedAmtQtyJ = null;
        BigDecimal zeroBigDecimal = new BigDecimal("0");
        Date verifyDate = DateTimeUtils.truncateDate((Date)new Date());
        String number = this.getAcctcussentHistoryNumber(ctx, verifyDate, company);
        int Seq = 1;
        block0: for (int i = 0; i < srcIDs.length; ++i) {
            if (verifiedSrc.contains(srcIDs[i]) || negativeCuss.contains(srcIDs[i])) continue;
            Map amountGzMap = this.getUnverifiedAmt(ctx, srcIDs[i]);
            BigDecimal tempO = (BigDecimal)amountGzMap.get("FUnverifiedAmtFor");
            BigDecimal tempL = (BigDecimal)amountGzMap.get("FUnverifiedAmtLocal");
            BigDecimal tempR = (BigDecimal)amountGzMap.get("FUnverifiedAmtRpt");
            BigDecimal tempQ = (BigDecimal)amountGzMap.get("FUnverifiedQty");
            if (tempO.compareTo(this.ZERO) == 0) continue;
            if (unverifiedAmtForI == null || unverifiedAmtForI.compareTo(this.ZERO) == 0) {
                unverifiedAmtForI = tempO;
                unverifiedAmtLocalI = tempL;
                unverifiedAmtRptI = tempR;
                unverifiedAmtQtyI = tempQ;
            }
            for (int j = i + 1; j < srcIDs.length; ++j) {
                if (verifiedSrc.contains(srcIDs[j]) || positiveCuss.contains(srcIDs[j])) continue;
                Map amountGzMap2 = this.getUnverifiedAmt(ctx, srcIDs[j]);
                unverifiedAmtForJ = (BigDecimal)amountGzMap2.get("FUnverifiedAmtFor");
                unverifiedAmtLocalJ = (BigDecimal)amountGzMap2.get("FUnverifiedAmtLocal");
                unverifiedAmtRptJ = (BigDecimal)amountGzMap2.get("FUnverifiedAmtRpt");
                unverifiedAmtQtyJ = (BigDecimal)amountGzMap2.get("FUnverifiedQty");
                if (unverifiedAmtForJ.compareTo(this.ZERO) == 0 || !this.isGoOn(unverifiedAmtForI, unverifiedAmtForJ)) continue;
                Map amountGzMapi = this.getUnverifiedAmt(ctx, srcIDs[i]);
                amountGzMapi.put("FNumber", number);
                amountGzMapi.put("FVerifyDate", verifyDate);
                amountGzMapi.put("FSeq", new Integer(Seq++));
                Map amountGzMapj = this.getUnverifiedAmt(ctx, srcIDs[j]);
                amountGzMapj.put("FNumber", number);
                amountGzMapj.put("FVerifyDate", verifyDate);
                amountGzMapj.put("FSeq", new Integer(Seq++));
                AcctCussentHistoryInfo acctCussentHistoryInfoI = this.createAcctCussentHistoryInfo(ctx, amountGzMapi, srcIDs[i], srcIDs[j], GLVerifyTypeEnum.SAME_VERIFY, company, amountGzMapj);
                AcctCussentHistoryInfo acctCussentHistoryInfoJ = this.createAcctCussentHistoryInfo(ctx, amountGzMapj, srcIDs[j], srcIDs[i], GLVerifyTypeEnum.SAME_VERIFY, company, amountGzMapi);
                if (unverifiedAmtForI.abs().compareTo(unverifiedAmtForJ.abs()) > 0) {
                    acctCussentHistoryInfoI.setOroginalAmount(unverifiedAmtForI.subtract(unverifiedAmtForI.add(unverifiedAmtForJ)));
                    acctCussentHistoryInfoI.setLocalAmount(unverifiedAmtLocalI.subtract(unverifiedAmtLocalI.add(unverifiedAmtLocalJ)));
                    acctCussentHistoryInfoI.setReportAmount(unverifiedAmtRptI.subtract(unverifiedAmtRptI.add(unverifiedAmtRptJ)));
                    acctCussentHistoryInfoI.setQty(unverifiedAmtQtyI.subtract(unverifiedAmtQtyI.add(unverifiedAmtQtyJ)));
                    acctCussentHistoryInfoI.setOriginalBalance(unverifiedAmtForI.add(unverifiedAmtForJ));
                    acctCussentHistoryInfoI.setLocalBalance(unverifiedAmtLocalI.add(unverifiedAmtLocalJ));
                    acctCussentHistoryInfoI.setReportBanlance(unverifiedAmtRptI.add(unverifiedAmtRptJ));
                    acctCussentHistoryInfoI.setQtyBalance(unverifiedAmtQtyI.add(unverifiedAmtQtyJ));
                    acctCussentHistoryInfoJ.setOroginalAmount(unverifiedAmtForJ);
                    acctCussentHistoryInfoJ.setLocalAmount(unverifiedAmtLocalJ);
                    acctCussentHistoryInfoJ.setReportAmount(unverifiedAmtRptJ);
                    acctCussentHistoryInfoJ.setQty(unverifiedAmtQtyJ);
                    acctCussentHistoryInfoJ.setOriginalBalance(GlUtils.zero);
                    acctCussentHistoryInfoJ.setLocalBalance(GlUtils.zero);
                    acctCussentHistoryInfoJ.setReportBanlance(GlUtils.zero);
                    acctCussentHistoryInfoJ.setQtyBalance(GlUtils.zero);
                    this.insertHistory(ctx, acctCussentHistoryInfoI, GLVerifyTypeEnum.SAME_VERIFY, sqlInsert, counter);
                    this.insertHistory(ctx, acctCussentHistoryInfoJ, GLVerifyTypeEnum.SAME_VERIFY, sqlInsert, counter);
                    ++verifyCnt;
                    unverifiedAmtForI = unverifiedAmtForI.add(unverifiedAmtForJ);
                    unverifiedAmtLocalI = unverifiedAmtLocalI.add(unverifiedAmtLocalJ);
                    unverifiedAmtRptI = unverifiedAmtRptI.add(unverifiedAmtRptJ);
                    unverifiedAmtQtyI = unverifiedAmtQtyI.add(unverifiedAmtQtyJ);
                    unverifiedAmtForJ = zeroBigDecimal;
                    this.updateUnverifiedAmtFor(ctx, srcIDs[i], acctCussentHistoryInfoI);
                    this.updateUnverifiedAmtFor(ctx, srcIDs[j], acctCussentHistoryInfoJ);
                    verifiedSrc.add(srcIDs[j]);
                    continue;
                }
                if (unverifiedAmtForI.abs().compareTo(unverifiedAmtForJ.abs()) < 0) {
                    acctCussentHistoryInfoI.setOroginalAmount(unverifiedAmtForI);
                    acctCussentHistoryInfoI.setLocalAmount(unverifiedAmtLocalI);
                    acctCussentHistoryInfoI.setReportAmount(unverifiedAmtRptI);
                    acctCussentHistoryInfoI.setQty(unverifiedAmtQtyI);
                    acctCussentHistoryInfoI.setOriginalBalance(GlUtils.zero);
                    acctCussentHistoryInfoI.setLocalBalance(GlUtils.zero);
                    acctCussentHistoryInfoI.setReportBanlance(GlUtils.zero);
                    acctCussentHistoryInfoI.setQtyBalance(GlUtils.zero);
                    acctCussentHistoryInfoJ.setOroginalAmount(unverifiedAmtForJ.subtract(unverifiedAmtForJ.add(unverifiedAmtForI)));
                    acctCussentHistoryInfoJ.setLocalAmount(unverifiedAmtLocalJ.subtract(unverifiedAmtLocalJ.add(unverifiedAmtLocalI)));
                    acctCussentHistoryInfoJ.setReportAmount(unverifiedAmtRptJ.subtract(unverifiedAmtRptJ.add(unverifiedAmtRptI)));
                    acctCussentHistoryInfoJ.setQty(unverifiedAmtQtyJ.subtract(unverifiedAmtQtyJ.add(unverifiedAmtQtyI)));
                    acctCussentHistoryInfoJ.setOriginalBalance(unverifiedAmtForJ.add(unverifiedAmtForI));
                    acctCussentHistoryInfoJ.setLocalBalance(unverifiedAmtLocalJ.add(unverifiedAmtLocalI));
                    acctCussentHistoryInfoJ.setReportBanlance(unverifiedAmtRptJ.add(unverifiedAmtRptI));
                    acctCussentHistoryInfoJ.setQtyBalance(unverifiedAmtQtyJ.add(unverifiedAmtQtyI));
                    this.insertHistory(ctx, acctCussentHistoryInfoI, GLVerifyTypeEnum.SAME_VERIFY, sqlInsert, counter);
                    this.insertHistory(ctx, acctCussentHistoryInfoJ, GLVerifyTypeEnum.SAME_VERIFY, sqlInsert, counter);
                    ++verifyCnt;
                    unverifiedAmtForJ = unverifiedAmtForI.add(unverifiedAmtForJ);
                    unverifiedAmtLocalJ = unverifiedAmtLocalJ.add(unverifiedAmtLocalI);
                    unverifiedAmtRptJ = unverifiedAmtRptJ.add(unverifiedAmtRptI);
                    unverifiedAmtQtyJ = unverifiedAmtQtyJ.add(unverifiedAmtQtyI);
                    unverifiedAmtForI = zeroBigDecimal;
                    this.updateUnverifiedAmtFor(ctx, srcIDs[i], acctCussentHistoryInfoI);
                    this.updateUnverifiedAmtFor(ctx, srcIDs[j], acctCussentHistoryInfoJ);
                    verifiedSrc.add(srcIDs[i]);
                    continue block0;
                }
                acctCussentHistoryInfoI.setOroginalAmount(unverifiedAmtForI);
                acctCussentHistoryInfoI.setLocalAmount(unverifiedAmtLocalI);
                acctCussentHistoryInfoI.setReportAmount(unverifiedAmtRptI);
                acctCussentHistoryInfoI.setQty(unverifiedAmtQtyI);
                acctCussentHistoryInfoI.setOriginalBalance(GlUtils.zero);
                acctCussentHistoryInfoI.setLocalBalance(GlUtils.zero);
                acctCussentHistoryInfoI.setReportBanlance(GlUtils.zero);
                acctCussentHistoryInfoI.setQtyBalance(GlUtils.zero);
                acctCussentHistoryInfoJ.setOroginalAmount(unverifiedAmtForJ);
                acctCussentHistoryInfoJ.setLocalAmount(unverifiedAmtLocalJ);
                acctCussentHistoryInfoJ.setReportAmount(unverifiedAmtRptJ);
                acctCussentHistoryInfoJ.setQty(unverifiedAmtQtyJ);
                acctCussentHistoryInfoJ.setOriginalBalance(GlUtils.zero);
                acctCussentHistoryInfoJ.setLocalBalance(GlUtils.zero);
                acctCussentHistoryInfoJ.setReportBanlance(GlUtils.zero);
                acctCussentHistoryInfoJ.setQtyBalance(GlUtils.zero);
                this.insertHistory(ctx, acctCussentHistoryInfoI, GLVerifyTypeEnum.SAME_VERIFY, sqlInsert, counter);
                this.insertHistory(ctx, acctCussentHistoryInfoJ, GLVerifyTypeEnum.SAME_VERIFY, sqlInsert, counter);
                ++verifyCnt;
                unverifiedAmtForI = zeroBigDecimal;
                unverifiedAmtForJ = zeroBigDecimal;
                this.updateUnverifiedAmtFor(ctx, srcIDs[i], acctCussentHistoryInfoI);
                this.updateUnverifiedAmtFor(ctx, srcIDs[j], acctCussentHistoryInfoJ);
                verifiedSrc.add(srcIDs[i]);
                verifiedSrc.add(srcIDs[j]);
                continue block0;
            }
        }
        return verifyCnt;
    }

    private int sameVerify_New(Context ctx, List<Map> positiveCuss, List<Map> negativeCuss, PreparedStatement sqlInsert, Counter counter, CompanyOrgUnitInfo company) throws BOSException, EASBizException, SQLException {
        int verifyCnt = 0;
        BigDecimal unverifiedAmtForI = null;
        BigDecimal unverifiedAmtLocalI = null;
        BigDecimal unverifiedAmtRptI = null;
        BigDecimal unverifiedAmtQtyI = null;
        BigDecimal unverifiedAmtForJ = null;
        BigDecimal unverifiedAmtLocalJ = null;
        BigDecimal unverifiedAmtRptJ = null;
        BigDecimal unverifiedAmtQtyJ = null;
        BigDecimal zeroBigDecimal = new BigDecimal("0");
        Date verifyDate = DateTimeUtils.truncateDate((Date)new Date());
        String number = this.getAcctcussentHistoryNumber(ctx, verifyDate, company);
        int Seq = 1;
        Map amountGzMapi = null;
        Map amountGzMapj = null;
        block0: for (int i = 0; i < positiveCuss.size(); ++i) {
            amountGzMapi = positiveCuss.get(i);
            if (amountGzMapi == null) continue;
            String srcId = (String)amountGzMapi.get("FId");
            BigDecimal tempO = (BigDecimal)amountGzMapi.get("FUnverifiedAmtFor");
            BigDecimal tempL = (BigDecimal)amountGzMapi.get("FUnverifiedAmtLocal");
            BigDecimal tempR = (BigDecimal)amountGzMapi.get("FUnverifiedAmtRpt");
            BigDecimal tempQ = (BigDecimal)amountGzMapi.get("FUnverifiedQty");
            if (tempO.compareTo(this.ZERO) == 0) continue;
            if (unverifiedAmtForI == null || unverifiedAmtForI.compareTo(this.ZERO) == 0) {
                unverifiedAmtForI = tempO;
                unverifiedAmtLocalI = tempL;
                unverifiedAmtRptI = tempR;
                unverifiedAmtQtyI = tempQ;
            }
            for (int j = 0; j < negativeCuss.size(); ++j) {
                amountGzMapj = negativeCuss.get(j);
                if (amountGzMapj == null) continue;
                String desId = (String)amountGzMapj.get("FId");
                unverifiedAmtForJ = (BigDecimal)amountGzMapj.get("FUnverifiedAmtFor");
                unverifiedAmtLocalJ = (BigDecimal)amountGzMapj.get("FUnverifiedAmtLocal");
                unverifiedAmtRptJ = (BigDecimal)amountGzMapj.get("FUnverifiedAmtRpt");
                unverifiedAmtQtyJ = (BigDecimal)amountGzMapj.get("FUnverifiedQty");
                if (unverifiedAmtForJ.compareTo(this.ZERO) == 0 || !this.isGoOn(unverifiedAmtForI, unverifiedAmtForJ)) continue;
                amountGzMapi.put("FNumber", number);
                amountGzMapi.put("FVerifyDate", verifyDate);
                amountGzMapi.put("FSeq", new Integer(Seq++));
                amountGzMapj.put("FNumber", number);
                amountGzMapj.put("FVerifyDate", verifyDate);
                amountGzMapj.put("FSeq", new Integer(Seq++));
                AcctCussentHistoryInfo acctCussentHistoryInfoI = this.createAcctCussentHistoryInfo(ctx, amountGzMapi, srcId, desId, GLVerifyTypeEnum.SAME_VERIFY, company, amountGzMapj);
                AcctCussentHistoryInfo acctCussentHistoryInfoJ = this.createAcctCussentHistoryInfo(ctx, amountGzMapj, desId, srcId, GLVerifyTypeEnum.SAME_VERIFY, company, amountGzMapi);
                if (unverifiedAmtForI.abs().compareTo(unverifiedAmtForJ.abs()) > 0) {
                    acctCussentHistoryInfoI.setOroginalAmount(unverifiedAmtForI.subtract(unverifiedAmtForI.add(unverifiedAmtForJ)));
                    acctCussentHistoryInfoI.setLocalAmount(unverifiedAmtLocalI.subtract(unverifiedAmtLocalI.add(unverifiedAmtLocalJ)));
                    acctCussentHistoryInfoI.setReportAmount(unverifiedAmtRptI.subtract(unverifiedAmtRptI.add(unverifiedAmtRptJ)));
                    acctCussentHistoryInfoI.setQty(unverifiedAmtQtyI.subtract(unverifiedAmtQtyI.add(unverifiedAmtQtyJ)));
                    acctCussentHistoryInfoI.setOriginalBalance(unverifiedAmtForI.add(unverifiedAmtForJ));
                    acctCussentHistoryInfoI.setLocalBalance(unverifiedAmtLocalI.add(unverifiedAmtLocalJ));
                    acctCussentHistoryInfoI.setReportBanlance(unverifiedAmtRptI.add(unverifiedAmtRptJ));
                    acctCussentHistoryInfoI.setQtyBalance(unverifiedAmtQtyI.add(unverifiedAmtQtyJ));
                    acctCussentHistoryInfoJ.setOroginalAmount(unverifiedAmtForJ);
                    acctCussentHistoryInfoJ.setLocalAmount(unverifiedAmtLocalJ);
                    acctCussentHistoryInfoJ.setReportAmount(unverifiedAmtRptJ);
                    acctCussentHistoryInfoJ.setQty(unverifiedAmtQtyJ);
                    acctCussentHistoryInfoJ.setOriginalBalance(GlUtils.zero);
                    acctCussentHistoryInfoJ.setLocalBalance(GlUtils.zero);
                    acctCussentHistoryInfoJ.setReportBanlance(GlUtils.zero);
                    acctCussentHistoryInfoJ.setQtyBalance(GlUtils.zero);
                    this.insertHistory(ctx, acctCussentHistoryInfoI, GLVerifyTypeEnum.SAME_VERIFY, sqlInsert, counter);
                    this.insertHistory(ctx, acctCussentHistoryInfoJ, GLVerifyTypeEnum.SAME_VERIFY, sqlInsert, counter);
                    ++verifyCnt;
                    unverifiedAmtForI = unverifiedAmtForI.add(unverifiedAmtForJ);
                    unverifiedAmtForJ = zeroBigDecimal;
                    this.updateUnverifiedAmtFor(ctx, srcId, acctCussentHistoryInfoI);
                    this.updateUnverifiedAmtFor(ctx, desId, acctCussentHistoryInfoJ);
                    amountGzMapi.put("FUnverifiedAmtFor", acctCussentHistoryInfoI.getOriginalBalance());
                    amountGzMapi.put("FUnverifiedAmtLocal", acctCussentHistoryInfoI.getLocalBalance());
                    amountGzMapi.put("FUnverifiedAmtRpt", acctCussentHistoryInfoI.getReportBanlance());
                    amountGzMapi.put("FUnverifiedQty", acctCussentHistoryInfoI.getQtyBalance());
                    negativeCuss.set(j, null);
                    continue;
                }
                if (unverifiedAmtForI.abs().compareTo(unverifiedAmtForJ.abs()) < 0) {
                    acctCussentHistoryInfoI.setOroginalAmount(unverifiedAmtForI);
                    acctCussentHistoryInfoI.setLocalAmount(unverifiedAmtLocalI);
                    acctCussentHistoryInfoI.setReportAmount(unverifiedAmtRptI);
                    acctCussentHistoryInfoI.setQty(unverifiedAmtQtyI);
                    acctCussentHistoryInfoI.setOriginalBalance(GlUtils.zero);
                    acctCussentHistoryInfoI.setLocalBalance(GlUtils.zero);
                    acctCussentHistoryInfoI.setReportBanlance(GlUtils.zero);
                    acctCussentHistoryInfoI.setQtyBalance(GlUtils.zero);
                    acctCussentHistoryInfoJ.setOroginalAmount(unverifiedAmtForJ.subtract(unverifiedAmtForJ.add(unverifiedAmtForI)));
                    acctCussentHistoryInfoJ.setLocalAmount(unverifiedAmtLocalJ.subtract(unverifiedAmtLocalJ.add(unverifiedAmtLocalI)));
                    acctCussentHistoryInfoJ.setReportAmount(unverifiedAmtRptJ.subtract(unverifiedAmtRptJ.add(unverifiedAmtRptI)));
                    acctCussentHistoryInfoJ.setQty(unverifiedAmtQtyJ.subtract(unverifiedAmtQtyJ.add(unverifiedAmtQtyI)));
                    acctCussentHistoryInfoJ.setOriginalBalance(unverifiedAmtForJ.add(unverifiedAmtForI));
                    acctCussentHistoryInfoJ.setLocalBalance(unverifiedAmtLocalJ.add(unverifiedAmtLocalI));
                    acctCussentHistoryInfoJ.setReportBanlance(unverifiedAmtRptJ.add(unverifiedAmtRptI));
                    acctCussentHistoryInfoJ.setQtyBalance(unverifiedAmtQtyJ.add(unverifiedAmtQtyI));
                    this.insertHistory(ctx, acctCussentHistoryInfoI, GLVerifyTypeEnum.SAME_VERIFY, sqlInsert, counter);
                    this.insertHistory(ctx, acctCussentHistoryInfoJ, GLVerifyTypeEnum.SAME_VERIFY, sqlInsert, counter);
                    ++verifyCnt;
                    unverifiedAmtForJ = unverifiedAmtForI.add(unverifiedAmtForJ);
                    unverifiedAmtForI = zeroBigDecimal;
                    --j;
                    this.updateUnverifiedAmtFor(ctx, srcId, acctCussentHistoryInfoI);
                    this.updateUnverifiedAmtFor(ctx, desId, acctCussentHistoryInfoJ);
                    amountGzMapj.put("FUnverifiedAmtFor", acctCussentHistoryInfoJ.getOriginalBalance());
                    amountGzMapj.put("FUnverifiedAmtLocal", acctCussentHistoryInfoJ.getLocalBalance());
                    amountGzMapj.put("FUnverifiedAmtRpt", acctCussentHistoryInfoJ.getReportBanlance());
                    amountGzMapj.put("FUnverifiedQty", acctCussentHistoryInfoJ.getQtyBalance());
                    positiveCuss.set(i, null);
                    continue block0;
                }
                acctCussentHistoryInfoI.setOroginalAmount(unverifiedAmtForI);
                acctCussentHistoryInfoI.setLocalAmount(unverifiedAmtLocalI);
                acctCussentHistoryInfoI.setReportAmount(unverifiedAmtRptI);
                acctCussentHistoryInfoI.setQty(unverifiedAmtQtyI);
                acctCussentHistoryInfoI.setOriginalBalance(GlUtils.zero);
                acctCussentHistoryInfoI.setLocalBalance(GlUtils.zero);
                acctCussentHistoryInfoI.setReportBanlance(GlUtils.zero);
                acctCussentHistoryInfoI.setQtyBalance(GlUtils.zero);
                acctCussentHistoryInfoJ.setOroginalAmount(unverifiedAmtForJ);
                acctCussentHistoryInfoJ.setLocalAmount(unverifiedAmtLocalJ);
                acctCussentHistoryInfoJ.setReportAmount(unverifiedAmtRptJ);
                acctCussentHistoryInfoJ.setQty(unverifiedAmtQtyJ);
                acctCussentHistoryInfoJ.setOriginalBalance(GlUtils.zero);
                acctCussentHistoryInfoJ.setLocalBalance(GlUtils.zero);
                acctCussentHistoryInfoJ.setReportBanlance(GlUtils.zero);
                acctCussentHistoryInfoJ.setQtyBalance(GlUtils.zero);
                this.insertHistory(ctx, acctCussentHistoryInfoI, GLVerifyTypeEnum.SAME_VERIFY, sqlInsert, counter);
                this.insertHistory(ctx, acctCussentHistoryInfoJ, GLVerifyTypeEnum.SAME_VERIFY, sqlInsert, counter);
                ++verifyCnt;
                unverifiedAmtForI = zeroBigDecimal;
                unverifiedAmtForJ = zeroBigDecimal;
                this.updateUnverifiedAmtFor(ctx, srcId, acctCussentHistoryInfoI);
                this.updateUnverifiedAmtFor(ctx, desId, acctCussentHistoryInfoJ);
                positiveCuss.set(i, null);
                negativeCuss.set(j, null);
                continue block0;
            }
        }
        return verifyCnt;
    }

    private String getAcctcussentHistoryNumber(Context ctx, Date date, CompanyOrgUnitInfo company) throws BOSException {
        String number = null;
        String sql = "select max(TO_INTEGER(fnumber)) FNumber from T_GL_AcctCussentHistory where  FcompanyID=? and  FVerifyDate = ?";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{company.getId().toString(), new java.sql.Date(DateTimeUtils.truncateDate((Date)new Date()).getTime())});
        try {
            if (row != null && row.next()) {
                number = row.getString("FNumber");
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        if (number == null) {
            number = "1";
        } else {
            int value = new BigDecimal(number).intValue();
            number = String.valueOf(value + 1);
        }
        return StringUtils.fixNumber((int)Integer.parseInt(number), (int)8);
    }

    private boolean isGoOn(BigDecimal bigDecimalI, BigDecimal bigDecimalJ) {
        return !this.isFlag(bigDecimalI) || !this.isFlag(bigDecimalJ);
    }

    private boolean isFlag(BigDecimal bigDecimal) {
        return bigDecimal.compareTo(this.ZERO) > 0;
    }

    private AcctCussentHistoryInfo createAcctCussentHistoryInfo(Context ctx, Map temp, String srcID, String objID, GLVerifyTypeEnum verifyType, CompanyOrgUnitInfo company, String[] strVeriVchEntryIds) throws BOSException, EASBizException {
        AcctCussentHistoryInfo acctCussentHistoryInfo = new AcctCussentHistoryInfo();
        acctCussentHistoryInfo.setNumber((String)temp.get("FNumber"));
        acctCussentHistoryInfo.setSeq((Integer)temp.get("FSeq"));
        acctCussentHistoryInfo.setVerifyDate((Date)temp.get("FVerifyDate"));
        AcctCussentInfo acctCussentInfo = new AcctCussentInfo();
        acctCussentInfo.setId(BOSUuid.read((String)srcID));
        acctCussentHistoryInfo.setCussentid(acctCussentInfo);
        acctCussentHistoryInfo.setId(BOSUuid.create((BOSObjectType)acctCussentHistoryInfo.getBOSType()));
        acctCussentHistoryInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        acctCussentHistoryInfo.setCompany(company);
        AccountViewInfo account = new AccountViewInfo();
        account.setId(BOSUuid.read((String)((String)temp.get("FAccountID"))));
        acctCussentHistoryInfo.setAccount(account);
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(BOSUuid.read((String)((String)temp.get("FCurrencyID"))));
        acctCussentHistoryInfo.setCurrency(currency);
        AssistantHGInfo assgrp = new AssistantHGInfo();
        assgrp.setId(BOSUuid.read((String)((String)temp.get("FAssGrpID"))));
        acctCussentHistoryInfo.setAssgrp(assgrp);
        acctCussentHistoryInfo.setVchNumber((String)temp.get("FVchNumber"));
        acctCussentHistoryInfo.setVchDate((Date)temp.get("FBookedDate"));
        acctCussentHistoryInfo.setBizDate((Date)temp.get("FBizDate"));
        acctCussentHistoryInfo.setBizNumber((String)temp.get("FBizNumber"));
        acctCussentHistoryInfo.setDescription((String)temp.get("FDescription"));
        acctCussentHistoryInfo.setCussOriginalAmount((BigDecimal)temp.get("FOriginalAmount"));
        acctCussentHistoryInfo.setCussLocalAmount((BigDecimal)temp.get("FLocalAmount"));
        acctCussentHistoryInfo.setCussReportAmount((BigDecimal)temp.get("FReportingAmount"));
        acctCussentHistoryInfo.setCussQty((BigDecimal)temp.get("FQuantity"));
        VoucherInfo cussVchInfo = null;
        VoucherEntryInfo cussEntryInfo = null;
        if (temp.get("FCussVchID") != null) {
            cussVchInfo = new VoucherInfo();
            cussVchInfo.setId(BOSUuid.read((String)temp.get("FCussVchID").toString()));
            cussEntryInfo = new VoucherEntryInfo();
            cussEntryInfo.setId(BOSUuid.read((String)temp.get("FCussEntryID").toString()));
        }
        acctCussentHistoryInfo.setCussVch(cussVchInfo);
        acctCussentHistoryInfo.setCussEntry(cussEntryInfo);
        if (objID != null) {
            VoucherAssistRecordInfo voucherAssistRecordInfo = new VoucherAssistRecordInfo();
            voucherAssistRecordInfo.setId(BOSUuid.read((String)objID));
            acctCussentHistoryInfo.setVoucherAsstID(voucherAssistRecordInfo);
        }
        if (temp.get("FPeriodNumber") != null) {
            acctCussentHistoryInfo.setCussPeriod((Integer)temp.get("FPeriodNumber"));
        }
        acctCussentHistoryInfo.setDc(verifyType);
        if (!(strVeriVchEntryIds == null || strVeriVchEntryIds.length <= 2 || StringUtils.isEmpty((String)strVeriVchEntryIds[0]) || StringUtils.isEmpty((String)strVeriVchEntryIds[1]) || StringUtils.isEmpty((String)strVeriVchEntryIds[2]))) {
            VoucherInfo veriVchInfo = new VoucherInfo();
            veriVchInfo.setId(BOSUuid.read((String)strVeriVchEntryIds[0]));
            acctCussentHistoryInfo.setVeriVch(veriVchInfo);
            VoucherEntryInfo veriEntryInfo = new VoucherEntryInfo();
            veriEntryInfo.setId(BOSUuid.read((String)strVeriVchEntryIds[1]));
            acctCussentHistoryInfo.setVeriEntry(veriEntryInfo);
            acctCussentHistoryInfo.setVeriPeriod(new Integer(strVeriVchEntryIds[2]));
        }
        acctCussentHistoryInfo.setVerifyManualAuto(VerifyManualAutoEnum.Manual);
        return acctCussentHistoryInfo;
    }

    private AcctCussentHistoryInfo createAcctCussentHistoryInfo(Context ctx, Map temp, String srcID, String objID, GLVerifyTypeEnum verifyType, CompanyOrgUnitInfo company, Map mapVeriVch) throws BOSException, EASBizException {
        AcctCussentHistoryInfo acctCussentHistoryInfo = this.createAcctCussentHistoryInfo(ctx, temp, srcID, objID, verifyType, company, new String[0]);
        VoucherInfo cussVchInfo = null;
        VoucherEntryInfo cussEntryInfo = null;
        if (mapVeriVch.get("FCussVchID") != null) {
            cussVchInfo = new VoucherInfo();
            cussVchInfo.setId(BOSUuid.read((String)mapVeriVch.get("FCussVchID").toString()));
            cussEntryInfo = new VoucherEntryInfo();
            cussEntryInfo.setId(BOSUuid.read((String)mapVeriVch.get("FCussEntryID").toString()));
        }
        acctCussentHistoryInfo.setVeriVch(cussVchInfo);
        acctCussentHistoryInfo.setVeriEntry(cussEntryInfo);
        if (mapVeriVch.get("FBookedDate") != null) {
            acctCussentHistoryInfo.setVerVchDate((Date)mapVeriVch.get("FBookedDate"));
        }
        if (mapVeriVch.get("FPeriodNumber") != null) {
            acctCussentHistoryInfo.setVeriPeriod((Integer)mapVeriVch.get("FPeriodNumber"));
        }
        return acctCussentHistoryInfo;
    }

    private AcctCussentHistoryInfo createAcctCussentHistoryInfo(Context ctx, Map temp, String srcID, String objID, GLVerifyTypeEnum verifyType, CompanyOrgUnitInfo company, String[] strVeriVchEntryIds, VerifyManualAutoEnum verifyManualAuto) throws BOSException, EASBizException {
        AcctCussentHistoryInfo acctCussentHistoryInfo = this.createAcctCussentHistoryInfo(ctx, temp, srcID, objID, verifyType, company, strVeriVchEntryIds);
        acctCussentHistoryInfo.setVerifyManualAuto(verifyManualAuto);
        return acctCussentHistoryInfo;
    }

    private void insertHistory(Context ctx, AcctCussentHistoryInfo info, GLVerifyTypeEnum verifyType, PreparedStatement sqlInsert, Counter counter) throws BOSException, EASBizException, SQLException {
        if (verifyType.equals((Object)GLVerifyTypeEnum.INTIME_VERIFY)) {
            this._deleteAcctCussHistory(ctx, info.getVoucherAsstID().getId().toString());
        }
        int index = 1;
        sqlInsert.setString(index++, info.getId().toString());
        sqlInsert.setBigDecimal(index++, info.getOroginalAmount());
        sqlInsert.setBigDecimal(index++, info.getLocalAmount());
        sqlInsert.setBigDecimal(index++, info.getReportAmount());
        sqlInsert.setBigDecimal(index++, info.getQty());
        sqlInsert.setBigDecimal(index++, info.getOriginalBalance());
        sqlInsert.setBigDecimal(index++, info.getLocalBalance());
        sqlInsert.setBigDecimal(index++, info.getReportBanlance());
        sqlInsert.setBigDecimal(index++, info.getQtyBalance());
        sqlInsert.setString(index++, info.getCussentid().getId().toString());
        sqlInsert.setString(index++, info.getVoucherAsstID().getId().toString());
        if (verifyType.equals((Object)GLVerifyTypeEnum.INTIME_VERIFY)) {
            if (info.getDc() == null) {
                if (info.getOroginalAmount().signum() < 0) {
                    sqlInsert.setInt(index++, 2);
                } else {
                    sqlInsert.setInt(index++, 0);
                }
            } else {
                sqlInsert.setInt(index++, info.getDc().getValue());
            }
        } else {
            sqlInsert.setInt(index++, verifyType.getValue());
        }
        sqlInsert.setDate(index++, new java.sql.Date(info.getVerifyDate().getTime()));
        sqlInsert.setString(index++, info.getAccount().getId().toString());
        sqlInsert.setString(index++, info.getAssgrp().getId().toString());
        sqlInsert.setString(index++, info.getCurrency().getId().toString());
        sqlInsert.setString(index++, info.getCreator().getId().toString());
        sqlInsert.setString(index++, info.getCompany().getId().toString());
        sqlInsert.setString(index++, info.getNumber());
        sqlInsert.setInt(index++, info.getSeq());
        sqlInsert.setInt(index++, 5);
        if (info.getVchNumber() != null) {
            sqlInsert.setString(index++, info.getVchNumber());
        } else {
            sqlInsert.setString(index++, null);
        }
        if (info.getVchDate() != null) {
            sqlInsert.setDate(index++, new java.sql.Date(info.getVchDate().getTime()));
        } else {
            sqlInsert.setDate(index++, null);
        }
        if (info.getVerVchDate() != null) {
            sqlInsert.setDate(index++, new java.sql.Date(info.getVerVchDate().getTime()));
        } else {
            sqlInsert.setDate(index++, null);
        }
        if (info.getBizDate() != null) {
            sqlInsert.setDate(index++, new java.sql.Date(info.getBizDate().getTime()));
        } else {
            sqlInsert.setDate(index++, null);
        }
        if (info.getBizNumber() != null) {
            sqlInsert.setString(index++, info.getBizNumber());
        } else {
            sqlInsert.setString(index++, null);
        }
        if (info.getDescription() != null) {
            sqlInsert.setString(index++, info.getDescription());
        } else {
            sqlInsert.setString(index++, null);
        }
        if (info.getVerifyManualAuto() == null) {
            info.setVerifyManualAuto(VerifyManualAutoEnum.Manual);
        }
        sqlInsert.setInt(index++, info.getVerifyManualAuto().getValue());
        if (info.getVeriVch() != null) {
            sqlInsert.setString(index++, info.getVeriVch().getId().toString());
            sqlInsert.setString(index++, info.getVeriEntry().getId().toString());
        } else {
            sqlInsert.setString(index++, null);
            sqlInsert.setString(index++, null);
        }
        if (info.getCussVch() != null) {
            sqlInsert.setString(index++, info.getCussVch().getId().toString());
            sqlInsert.setString(index++, info.getCussEntry().getId().toString());
        } else {
            sqlInsert.setString(index++, null);
            sqlInsert.setString(index++, null);
        }
        sqlInsert.setInt(index++, info.getCussPeriod());
        sqlInsert.setInt(index++, info.getVeriPeriod());
        sqlInsert.setBigDecimal(index++, info.getCussOriginalAmount());
        sqlInsert.setBigDecimal(index++, info.getCussLocalAmount());
        sqlInsert.setBigDecimal(index++, info.getCussReportAmount());
        sqlInsert.setBigDecimal(index++, info.getCussQty() == null ? new BigDecimal(0) : info.getCussQty());
        sqlInsert.addBatch();
        counter.add();
        if (counter.getValue() % 2000 == 0) {
            sqlInsert.executeBatch();
            sqlInsert.clearBatch();
            counter.clear();
        }
    }

    private void changeVerifiedStatus(Context ctx, String objID) throws BOSException {
        String sql = "update T_GL_VoucherAssistRecord set FIsVierified = 1 where fid = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{objID});
        sql = "update t_gl_acctcussent set FIsVierified = 1 where fvchassistrecordid = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{objID});
    }

    private void updateUnverifiedAmtFor(Context ctx, String srcID, AcctCussentHistoryInfo acctCussentHistoryInfo) throws BOSException {
        String sql = "update T_GL_AcctCussent set FUnverifiedAmtFor = ? , FUnverifiedAmtLocal=? , FUnverifiedAmtRpt=? , FUnverifiedQty=? where fid = ? ";
        BigDecimal unverifiedAmtFor = acctCussentHistoryInfo.getOriginalBalance();
        BigDecimal unverifiedAmtLocal = acctCussentHistoryInfo.getLocalBalance();
        BigDecimal unverifiedAmtRpt = acctCussentHistoryInfo.getReportBanlance();
        BigDecimal unverifiedAmtQty = acctCussentHistoryInfo.getQtyBalance();
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{unverifiedAmtFor, unverifiedAmtLocal, unverifiedAmtRpt, unverifiedAmtQty, srcID});
    }

    private Map getVerifyAmount(Context ctx, String objID) throws BOSException {
        try {
            HashMap<String, Object> amountMap = new HashMap<String, Object>();
            BigDecimal unVerifyAmtFor = new BigDecimal("0");
            BigDecimal unVerifyAmtLocal = new BigDecimal("0");
            BigDecimal unVerifyAmtRpt = new BigDecimal("0");
            BigDecimal unVerifyAmtQty = new BigDecimal("0");
            Object[] param = null;
            String sql = "";
            if (this.fromVch) {
                sql = "select a.FOriginalAmount-(case when t.FVerifiedAmtFor is null then 0 else t.FVerifiedAmtFor end) ,a.FLocalAmount-(case when t.FVerifiedAmtLocal is null then 0 else t.FVerifiedAmtLocal end), a.FReportingAmount-(case when t.FVerifiedAmtRpt is null then 0 else t.FVerifiedAmtRpt end),a.FQuantity-(case when t.FVerifiedQty is null then 0 else t.FVerifiedQty end), b.fcompanyid,e.faccountid,e.fcurrencyid,a.fassgrpid,a.fbizdate,a.fdescription,a.fbiznumber,b.fnumber,b.fbookeddate,b.fid FCussVchID, e.fid  FCussEntryID   from T_GL_VoucherAssistRecord a inner join t_gl_voucher b on a.fbillid = b.fid inner join t_gl_voucherentry e on a.fentryid = e.fid                                                       left join (select sum(FOroginalAmount) FVerifiedAmtFor,sum(FLocalAmount) FVerifiedAmtLocal,sum(FReportAmount) FVerifiedAmtRpt,sum(FQty) FVerifiedQty,FVoucherAsstIDID                                 from t_gl_acctcussenthistory where FVoucherAsstIDID = ? group by FVoucherAsstIDID) t on t.FVoucherAsstIDID = a.fid                               where a.fid = ? ";
                param = new Object[]{objID, objID};
            } else {
                sql = "select a.FUNVERIFIEDAMTFOR ,a.FUNVERIFIEDAMTLOCAL ,a.FUNVERIFIEDAMTRPT ,a.FUNVERIFIEDQTY, a.fcompanyid,a.faccountid,a.fcurrencyid,a.fassgrpid,a.fvarbizdate,a.fdescription,a.fbiznumber,a.fvchnumber,a.fbookeddate,a.fvoucherid FCussVchID,a.fentryid FCussEntryID  from t_gl_acctverify a where a.FVchAssistRecordID = ? ";
                param = new Object[]{objID};
            }
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
            while (rowset.next()) {
                unVerifyAmtFor = unVerifyAmtFor.add(rowset.getBigDecimal(1));
                unVerifyAmtLocal = unVerifyAmtLocal.add(rowset.getBigDecimal(2));
                unVerifyAmtRpt = unVerifyAmtRpt.add(rowset.getBigDecimal(3));
                unVerifyAmtQty = unVerifyAmtQty.add(rowset.getBigDecimal(4));
                amountMap.put("FCompanyID", rowset.getString(5));
                amountMap.put("FAccountID", rowset.getString(6));
                amountMap.put("FCurrencyID", rowset.getString(7));
                amountMap.put("FAssGrpID", rowset.getString(8));
                amountMap.put("FBizDate", rowset.getDate(9));
                amountMap.put("FDescription", rowset.getString(10));
                amountMap.put("FBizNumber", rowset.getString(11));
                amountMap.put("FVchNumber", rowset.getString(12));
                amountMap.put("FBookedDate", rowset.getDate(13));
                amountMap.put("FCussVchID", rowset.getString(14));
                amountMap.put("FCussEntryID", rowset.getString(15));
            }
            amountMap.put("FUnverifiedAmtFor", unVerifyAmtFor);
            amountMap.put("FUnverifiedAmtLocal", unVerifyAmtLocal);
            amountMap.put("FUnverifiedAmtRpt", unVerifyAmtRpt);
            amountMap.put("FUnverifiedAmtQty", unVerifyAmtQty);
            return amountMap;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Map getVerifyAmountAsAC(Context ctx, String objID) throws BOSException {
        try {
            HashMap<String, Object> amountMap = new HashMap<String, Object>();
            BigDecimal unVerifyAmtFor = new BigDecimal("0");
            BigDecimal unVerifyAmtLocal = new BigDecimal("0");
            BigDecimal unVerifyAmtRpt = new BigDecimal("0");
            BigDecimal unVerifyAmtQty = new BigDecimal("0");
            String sql = "select a.FUNVERIFIEDAMTFOR ,a.FUNVERIFIEDAMTLOCAL ,a.FUNVERIFIEDAMTRPT ,a.FUNVERIFIEDQTY,  a.fcompanyid,a.faccountid,a.fcurrencyid,a.fassgrpid,a.fvarbizdate,a.fdescription,a.fbiznumber,a.fvchnumber,a.fbookeddate, a.FOriginalAmount,a.FLocalAmount,a.FReportingAmount,a.FQuantity,\ta.fvoucherid fcussvchid,a.FEntryID fcussentryid, \tpd.fnumber FPeriodNumber  from t_gl_acctverify a   left join t_bd_period pd on pd.fid = a.fperiodid  where a.FVchAssistRecordID = ? ";
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{objID});
            while (rowset.next()) {
                int index = 1;
                unVerifyAmtFor = unVerifyAmtFor.add(rowset.getBigDecimal(index++));
                unVerifyAmtLocal = unVerifyAmtLocal.add(rowset.getBigDecimal(index++));
                unVerifyAmtRpt = unVerifyAmtRpt.add(rowset.getBigDecimal(index++));
                unVerifyAmtQty = unVerifyAmtQty.add(rowset.getBigDecimal(index++));
                amountMap.put("FCompanyID", rowset.getString(index++));
                amountMap.put("FAccountID", rowset.getString(index++));
                amountMap.put("FCurrencyID", rowset.getString(index++));
                amountMap.put("FAssGrpID", rowset.getString(index++));
                amountMap.put("FBizDate", rowset.getDate(index++));
                amountMap.put("FDescription", rowset.getString(index++));
                amountMap.put("FBizNumber", rowset.getString(index++));
                amountMap.put("FVchNumber", rowset.getString(index++));
                amountMap.put("FBookedDate", rowset.getDate(index++));
                amountMap.put("FOriginalAmount", rowset.getBigDecimal(index++));
                amountMap.put("FLocalAmount", rowset.getBigDecimal(index++));
                amountMap.put("FReportingAmount", rowset.getBigDecimal(index++));
                amountMap.put("FQuantity", rowset.getBigDecimal(index++));
                amountMap.put("FCussVchID", rowset.getString(index++));
                amountMap.put("FCussEntryID", rowset.getString(index++));
                amountMap.put("FPeriodNumber", new Integer(rowset.getInt(index++)));
            }
            amountMap.put("FUnverifiedAmtFor", unVerifyAmtFor);
            amountMap.put("FUnverifiedAmtLocal", unVerifyAmtLocal);
            amountMap.put("FUnverifiedAmtRpt", unVerifyAmtRpt);
            amountMap.put("FUnverifiedAmtQty", unVerifyAmtQty);
            return amountMap;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Map getUnverifiedAmt(Context ctx, String srcID) throws BOSException {
        String sql = "select a.FUnverifiedAmtFor,a.FUnverifiedAmtLocal,a.FUnverifiedAmtRpt,a.FUnverifiedQty ,\r\n\ta.fcompanyid,a.faccountid,a.fcurrencyid,a.fassgrpid,\r\n\ta.FVarBizDate FBizdate,a.Fdescription,a.fbizNumber,\r\n\ta.FVchNumber FVchNumber,a.fbookeddate,\r\n a.FOriginalAmount,a.FLocalAmount,a.FReportingAmount,a.FQuantity,\r\n a.fvoucherid fcussvchid,a.FEntryID fcussentryid, \r\n\tisnull(pd.fnumber,0) FPeriodNumber  \r\n\tfrom T_GL_AcctCussent a             \r\n left join t_bd_period pd on pd.fid = a.fperiodid \r\n\twhere a.fid = ? \r\n";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{srcID});
        HashMap<String, Object> amountMap = new HashMap<String, Object>();
        try {
            if (rowset.next()) {
                int index = 1;
                amountMap.put("FUnverifiedAmtFor", rowset.getBigDecimal(index++));
                amountMap.put("FUnverifiedAmtLocal", rowset.getBigDecimal(index++));
                amountMap.put("FUnverifiedAmtRpt", rowset.getBigDecimal(index++));
                amountMap.put("FUnverifiedQty", rowset.getBigDecimal(index++));
                amountMap.put("FCompanyID", rowset.getString(index++));
                amountMap.put("FAccountID", rowset.getString(index++));
                amountMap.put("FCurrencyID", rowset.getString(index++));
                amountMap.put("FAssGrpID", rowset.getString(index++));
                amountMap.put("FBizDate", rowset.getDate(index++));
                amountMap.put("FDescription", rowset.getString(index++));
                amountMap.put("FBizNumber", rowset.getString(index++));
                amountMap.put("FVchNumber", rowset.getString(index++));
                amountMap.put("FBookedDate", rowset.getDate(index++));
                amountMap.put("FOriginalAmount", rowset.getBigDecimal(index++));
                amountMap.put("FLocalAmount", rowset.getBigDecimal(index++));
                amountMap.put("FReportingAmount", rowset.getBigDecimal(index++));
                amountMap.put("FQuantity", rowset.getBigDecimal(index++));
                amountMap.put("FCussVchID", rowset.getString(index++));
                amountMap.put("FCussEntryID", rowset.getString(index++));
                amountMap.put("FPeriodNumber", new Integer(rowset.getInt(index++)));
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        return amountMap;
    }

    private Map getUnverifiedAmtForVerify(Context ctx, String srcID) throws BOSException {
        String sql = "select a.FUnverifiedAmtFor,a.FUnverifiedAmtLocal,a.FUnverifiedAmtRpt,a.FUnverifiedQty ,\r\n\ta.fcompanyid,a.faccountid,a.fcurrencyid,a.fassgrpid,\r\n\ta.FVarBizDate FBizdate,a.Fdescription,a.fbizNumber,\r\n\ta.FVchNumber FVchNumber,a.fbookeddate,\r\n a.FOriginalAmount,a.FLocalAmount,a.FReportingAmount,a.FQuantity,\r\n a.fvoucherid fcussvchid,a.FEntryID fcussentryid, \r\n\tisnull(pd.fnumber,0) FPeriodNumber  \r\n\tfrom t_gl_acctverify a             \r\n left join t_bd_period pd on pd.fid = a.fperiodid \r\n\twhere a.fvchassistrecordid = ? \r\n";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{srcID});
        HashMap<String, Object> amountMap = new HashMap<String, Object>();
        try {
            if (rowset.next()) {
                int index = 1;
                amountMap.put("FUnverifiedAmtFor", rowset.getBigDecimal(index++));
                amountMap.put("FUnverifiedAmtLocal", rowset.getBigDecimal(index++));
                amountMap.put("FUnverifiedAmtRpt", rowset.getBigDecimal(index++));
                amountMap.put("FUnverifiedQty", rowset.getBigDecimal(index++));
                amountMap.put("FCompanyID", rowset.getString(index++));
                amountMap.put("FAccountID", rowset.getString(index++));
                amountMap.put("FCurrencyID", rowset.getString(index++));
                amountMap.put("FAssGrpID", rowset.getString(index++));
                amountMap.put("FBizDate", rowset.getDate(index++));
                amountMap.put("FDescription", rowset.getString(index++));
                amountMap.put("FBizNumber", rowset.getString(index++));
                amountMap.put("FVchNumber", rowset.getString(index++));
                amountMap.put("FBookedDate", rowset.getDate(index++));
                amountMap.put("FOriginalAmount", rowset.getBigDecimal(index++));
                amountMap.put("FLocalAmount", rowset.getBigDecimal(index++));
                amountMap.put("FReportingAmount", rowset.getBigDecimal(index++));
                amountMap.put("FQuantity", rowset.getBigDecimal(index++));
                amountMap.put("FCussVchID", rowset.getString(index++));
                amountMap.put("FCussEntryID", rowset.getString(index++));
                amountMap.put("FPeriodNumber", new Integer(rowset.getInt(index++)));
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        return amountMap;
    }

    @Override
    protected ArrayList _getVerifyObjData(Context ctx, HashMap param) throws BOSException, EASBizException {
        Date bizDateTo;
        Date bizDateFrom;
        ArrayList returnAL = new ArrayList();
        String[] accountIDs = null;
        String[] acctCAAIds = null;
        if (param.get("account") instanceof AccountViewInfo) {
            AccountViewInfo acct = (AccountViewInfo)param.get("account");
            accountIDs = new String[1];
            acctCAAIds = new String[1];
            accountIDs[0] = acct.getId().toString();
            acctCAAIds[0] = acct.getCAA().getId().toString();
        } else {
            Object[] accountViewInfos = (Object[])param.get("account");
            if (accountViewInfos != null && accountViewInfos.length > 0) {
                accountIDs = new String[accountViewInfos.length];
                acctCAAIds = new String[accountViewInfos.length];
                for (int i = 0; i < accountViewInfos.length; ++i) {
                    AccountViewInfo acct = (AccountViewInfo)accountViewInfos[i];
                    accountIDs[i] = acct.getId().toString();
                    acctCAAIds[i] = acct.getCAA().getId().toString();
                }
            }
        }
        if (param.get("currency") == null) {
            return returnAL;
        }
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String accountTableId = null;
        if (param.get("COMPANYID") != null) {
            companyID = param.get("COMPANYID").toString();
        }
        if (param.get("COMPANY") != null) {
            companyID = ((CompanyOrgUnitInfo)param.get("COMPANY")).getId().toString();
        }
        if (param.get("ACCOUNTTABLEID") != null) {
            accountTableId = param.get("ACCOUNTTABLEID") instanceof AccountTableInfo ? ((AccountTableInfo)param.get("ACCOUNTTABLEID")).getId().toString() : param.get("ACCOUNTTABLEID").toString();
        }
        String currencyID = ((CurrencyInfo)param.get("currency")).getId().toString();
        boolean exclueUnpostVch = true;
        Object objUnpostVch = param.get("notIncludeUnpostVch");
        exclueUnpostVch = Boolean.TRUE.equals(objUnpostVch);
        boolean includeReversed = true;
        if (param.get("includeReversed") != null) {
            includeReversed = (Boolean)param.get("includeReversed");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(companyID);
        list.add(companyID);
        list.add(currencyID);
        if (accountTableId != null && !"".equals(accountTableId)) {
            list.add(accountTableId);
        }
        if ((bizDateFrom = (Date)param.get("bizDateFrom")) != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(bizDateFrom);
            bizDateFrom = cal.getTime();
            java.sql.Date begin = new java.sql.Date(bizDateFrom.getTime());
            list.add(begin);
        }
        if ((bizDateTo = (Date)param.get("bizDateTo")) != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(bizDateTo);
            bizDateTo = cal.getTime();
            java.sql.Date end = new java.sql.Date(bizDateTo.getTime());
            list.add(end);
        }
        EntityViewInfo mainQuery = (EntityViewInfo)param.get("mainQuery");
        StringBuffer sortSelfDefine = this.transSortSelfDefineToSQL(mainQuery, loc, false);
        StringBuffer filterSelfDefine = this.transFilterSelfDefineToSQL(mainQuery, loc, AcctDataType.ACCTVERIFY);
        String bizNumber = (String)param.get("bizNumber");
        if (bizNumber != null) {
            list.add(bizNumber);
        }
        boolean accountShowLongName = false;
        if (param.get("accountShowLongName") != null) {
            accountShowLongName = (Boolean)param.get("accountShowLongName");
        }
        String accountNameField = accountShowLongName ? "flongname_" : "fname_";
        StringBuffer sql = new StringBuffer();
        sql.append(" select c.fid fid,c.FVoucherID fvoucherid,c.FEntryID fentryid,c.FVchNumber FNumber,  \r\n \t  ");
        sql.append(" c.FVarBizDate FBizDate,c.FBizNumber FBizNumber,c.FBookedDate FBookedDate,c.FEndDate FEndDate, \r\n \t  ");
        sql.append(" c.FDescription FDescription,c.FEntrydc FEntryDC,v.FCAA FCAA,v.fnumber Factnumber,v.").append(accountNameField).append(loc).append(" Factname, \r\n");
        sql.append(" c.FAssGrpID FAssGrpID, c.FVchAssistRecordID voucherAssistRecordID,  \r\n");
        sql.append(" c.FAccountID FAccountID, c.FCurrencyID FCurrencyID,  p.FPeriodYear FPeriodYear,p.fperiodnumber FPeriodNumber,p.fnumber fpnumber,\r\n");
        sql.append(" vts.fname_l2 FvoucherType, \r\n");
        sql.append(" isnull(c.FOriginalAmount, 0) FOriginalAmount,  \r\n");
        sql.append(" isnull(c.FLocalAmount,0) FLocalAmount, \r\n");
        sql.append(" isnull(c.FReportingAmount, 0) FReportingAmount, \r\n");
        sql.append(" isnull(c.FQuantity, 0) FQuantity, \r\n");
        sql.append(" isnull(c.FUnVerifiedAmtFor, 0) FUnVerifiedAmtFor,  \r\n");
        sql.append(" isnull(c.FUnverifiedAmtLocal, 0) FUnverifiedAmtLocal, \r\n");
        sql.append(" isnull(c.FUnverifiedAmtRpt, 0) FUnverifiedAmtRpt, \r\n");
        sql.append(" isnull(c.FUnverifiedQty, 0) FUnverifiedQty, \r\n");
        sql.append(" c.FLastUpdateTime FLastUpdateTime \r\n");
        sql.append(" from T_GL_AcctVerify c  \r\n");
        sql.append(" inner join t_bd_period p on p.fid = c.fperiodid   \r\n");
        sql.append(" inner join v_gl_acperiod acp  on acp.fperiodid=c.fperiodid\t \r\n");
        if (!includeReversed) {
            sql.append(" left join t_gl_Voucher rev on c.FVSOURCEBILLID = rev.fid  \r\n");
        }
        sql.append(" inner join t_bd_accountview v  on v.fid=c.FAccountID \r\n");
        sql.append(" inner join t_bd_vouchertypes vts on vts.fid = c.fvouchertypeid  \r\n");
        sql.append(" inner join T_bd_assistanthg hg on c.FassgrpId =hg.fid     \t\t\r\n  ");
        StringBuilder sqlAssistJoin = new StringBuilder();
        this.structureHgSql(param, sqlAssistJoin);
        sql.append((CharSequence)sqlAssistJoin);
        sql.append(" where c.FUnVerifiedAmtFor <> 0   \r\n ");
        if (exclueUnpostVch) {
            sql.append(" and c.FIsPost = 1 \r\n");
        } else {
            sql.append(" and c.FIsPost > -1 \r\n");
        }
        sql.append(" and acp.fcompanyid = ? \r\n");
        sql.append(" and c.FCompanyID = ? and c.FCurrencyID = ? \r\n");
        if (accountTableId != null && !"".equals(accountTableId)) {
            sql.append(" and v.FACCOUNTTABLEID = ? \r\n");
        }
        if (accountIDs != null) {
            sql.append(" and c.Faccountid in ").append(CSSPUtils.getIdsSql((String[])accountIDs));
        }
        if (!includeReversed) {
            sql.append(" and ( c.FIsReverseVoucher = 0 AND c.FHasReversed = 0 OR c.FIsReverseVoucher = 1 AND rev.FHasReversed = 0) \r\n");
        }
        if (bizDateFrom != null) {
            sql.append(" and c.FVarBizDate >= ?  ");
        }
        if (bizDateTo != null) {
            sql.append(" and c.FVarBizDate <= ?  ");
        }
        if (bizNumber != null) {
            sql.append(" and c.FBizNumber like ?   \r\n");
        }
        boolean isFromVoucherUI = false;
        if (param.get("isFromVoucherUI") != null) {
            isFromVoucherUI = (Boolean)param.get("isFromVoucherUI");
        }
        if (isFromVoucherUI) {
            sql.append(" and c.FOriginalAmount < 0 ");
        } else {
            sql.append(" and c.FOriginalAmount <> 0 ");
        }
        String voucherId = (String)param.get("voucherId");
        if (isFromVoucherUI && voucherId != null) {
            sql.append(" and c.fvoucherId not in (?)");
            list.add(voucherId);
        }
        if (filterSelfDefine.length() > 0) {
            sql.append(" and ").append(filterSelfDefine.toString()).append(" ");
        }
        if (!StringUtils.isEmpty((String)sortSelfDefine.toString())) {
            sql.append(sortSelfDefine);
        } else {
            sql.append("order by FBizDate,FBizNumber,fnumber");
        }
        Object[] params = list.toArray();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        ArrayList result = new ArrayList();
        HashMap<String, AssistantHGInfo> cacheAssGrp = new HashMap<String, AssistantHGInfo>();
        HashMap cacheAccount = new HashMap();
        try {
            while (rs.next()) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                String id = rs.getString("voucherAssistRecordID");
                item.put("voucherAssistRecordId", id);
                item.put("FNumber", rs.getString("FNumber"));
                item.put("FactNumber", rs.getString("FactNumber"));
                item.put("FactName", rs.getString("FactName"));
                item.put("FPeriodYear", rs.getString("FPeriodYear"));
                item.put("FPeriodNumber", rs.getString("FPeriodNumber"));
                item.put("fvoucherid", rs.getString("fvoucherid"));
                item.put("FvoucherType", rs.getString("FvoucherType"));
                item.put("FBizDate", rs.getDate("FBizDate"));
                item.put("FBookedDate", rs.getDate("FBookedDate"));
                item.put("FEndDate", rs.getDate("FEndDate"));
                item.put("FDescription", rs.getString("FDescription"));
                item.put("FEntryDC", new Integer(rs.getInt("FEntryDC")));
                item.put("FOriginalAmount", rs.getBigDecimal("FOriginalAmount"));
                item.put("FVerifiedAmtFor", rs.getBigDecimal("FOriginalAmount").subtract(rs.getBigDecimal("FUnVerifiedAmtFor")));
                item.put("FUnverifiedAmtFor", rs.getBigDecimal("FUnVerifiedAmtFor"));
                AssistantHGInfo hgInfo = null;
                if (cacheAssGrp.containsKey(rs.getString("FAssGrpID"))) {
                    hgInfo = (AssistantHGInfo)cacheAssGrp.get(rs.getString("FAssGrpID"));
                } else {
                    String actFcaa = rs.getString("FCAA");
                    hgInfo = this.getHgInfo(ctx, rs.getString("FAssGrpID"), actFcaa);
                    cacheAssGrp.put(rs.getString("FAssGrpID"), hgInfo);
                }
                item.put("FAssGrpID", rs.getString("FAssGrpID"));
                item.put("hg", hgInfo);
                item.put("FBizNumber", rs.getString("FBizNumber"));
                item.put("FLastUpdateTime", rs.getTimestamp("FLastUpdateTime"));
                result.add(item);
            }
            returnAL.add(result);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return returnAL;
    }

    private AssistantHGInfo getHgInfo(Context ctx, String FAssGrpID, String caa) throws BOSException, EASBizException {
        AssistantHGInfo info = new AssistantHGInfo();
        info.setId(BOSUuid.read((String)FAssGrpID));
        StringBuffer sql = new StringBuffer();
        sql.append("  select c.fassthgattribute from t_bd_asstaccount a  ");
        sql.append("  inner join t_bd_asstactgroupdetail b on a.fid=b.fasstaccountid ");
        sql.append("  inner join t_bd_asstacttype c on b.fasstacttypeid=c.fid ");
        sql.append("  where a.fid=? ");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{caa});
        IGLGeneralFacade geFacade = GLGeneralFacadeFactory.getLocalInstance(ctx);
        if (set != null) {
            try {
                while (set.next()) {
                    String assgrp = set.getString("fassthgattribute");
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("id", FAssGrpID);
                    param.put("asstribute", assgrp);
                    Map result = geFacade.dealTask("GetDataBaseInfo", param);
                    if (result == null) continue;
                    DataBaseInfo dabaseInfo = (DataBaseInfo)result.get("DataBaseInfo");
                    info.put(assgrp, (Object)dabaseInfo);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        return info;
    }

    private void structureHgSql(Map param, StringBuilder sqlAssistJoin) {
        if (param.get("items") != null) {
            ArrayList items = (ArrayList)param.get("items");
            for (int i = 0; i < items.size(); ++i) {
                Map item = (Map)items.get(i);
                String tablename = (String)item.get("tablename");
                String field = (String)item.get("fieldname");
                String id = (String)item.get("itemId");
                boolean useLongNumber = item.containsKey("useLongNumber") && (Boolean)item.get("useLongNumber") != false;
                String itemKey = " item" + i;
                sqlAssistJoin.append(" inner join ").append(tablename).append(itemKey).append(" on ").append(itemKey).append(".fid =hg.").append(field);
                if (id != null) {
                    sqlAssistJoin.append(" and").append(itemKey).append(".fid in('").append(id).append("')\t\t\t\r\n");
                    continue;
                }
                String numberfrom = (String)item.get("numberfrom");
                String numberto = (String)item.get("numberto");
                String dist = (String)item.get("distNumber");
                if (!StringUtils.isEmpty((String)dist)) {
                    dist = SQLUtil.collection2InList(Arrays.asList(dist.split(",")));
                }
                if (numberfrom != null) {
                    if (useLongNumber) {
                        sqlAssistJoin.append(" and").append(itemKey).append(".flongNumber >='").append(numberfrom.replace(".", "!")).append("' \r\n");
                    } else {
                        sqlAssistJoin.append(" and").append(itemKey).append(".fnumber >='").append(numberfrom).append("' \r\n");
                    }
                }
                if (numberto != null) {
                    if (useLongNumber) {
                        sqlAssistJoin.append(" and").append(itemKey).append(".flongNumber <='").append(numberto.replace(".", "!")).append("' \r\n");
                    } else {
                        sqlAssistJoin.append(" and").append(itemKey).append(".fnumber <='").append(numberto).append("' \r\n");
                    }
                }
                if (StringUtils.isEmpty((String)dist)) continue;
                if (useLongNumber) {
                    sqlAssistJoin.append(" and").append(itemKey).append(".flongNumber in ").append(dist.replace(".", "!")).append(" \r\n");
                    continue;
                }
                sqlAssistJoin.append(" and").append(itemKey).append(".fnumber in ").append(dist).append(" \r\n");
            }
        }
    }

    @Override
    protected ArrayList _getVerifySrcData(Context ctx, HashMap param) throws BOSException, EASBizException {
        ArrayList returnAL = new ArrayList();
        String[] accountIDs = null;
        if (param.get("account") instanceof AccountViewInfo) {
            AccountViewInfo acct = (AccountViewInfo)param.get("account");
            accountIDs = new String[]{acct.getId().toString()};
        } else {
            Object[] accountViewInfos = (Object[])param.get("account");
            if (accountViewInfos != null && accountViewInfos.length > 0) {
                accountIDs = new String[accountViewInfos.length];
                for (int i = 0; i < accountViewInfos.length; ++i) {
                    AccountViewInfo acct = (AccountViewInfo)accountViewInfos[i];
                    accountIDs[i] = acct.getId().toString();
                }
            }
        }
        if (param.get("currency") == null) {
            return returnAL;
        }
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String accountTableId = null;
        if (param.get("COMPANYID") != null) {
            companyID = param.get("COMPANYID").toString();
        }
        if (param.get("COMPANY") != null) {
            companyID = ((CompanyOrgUnitInfo)param.get("COMPANY")).getId().toString();
        }
        if (param.get("ACCOUNTTABLEID") != null) {
            accountTableId = param.get("ACCOUNTTABLEID") instanceof AccountTableInfo ? ((AccountTableInfo)param.get("ACCOUNTTABLEID")).getId().toString() : param.get("ACCOUNTTABLEID").toString();
        }
        int verifyMode = GlUtils.getVerifyMode(ctx, companyID);
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        boolean includeReversed = true;
        if (param.get("includeReversed") != null) {
            includeReversed = (Boolean)param.get("includeReversed");
        }
        String currencyID = null;
        boolean isAllCurrency = false;
        if (param.get("currency") instanceof String && ((String)param.get("currency")).compareToIgnoreCase("all") == 0) {
            isAllCurrency = true;
        } else {
            currencyID = ((CurrencyInfo)param.get("currency")).getId().toString();
        }
        EntityViewInfo mainQuery = (EntityViewInfo)param.get("mainQuery");
        StringBuffer sortSelfDefine = this.transSortSelfDefineToSQL(mainQuery, loc, true);
        StringBuffer initFilterSelfDefine = this.transFilterSelfDefineToSQL(mainQuery, loc, AcctDataType.INIT);
        StringBuffer acctFilterSelfDefine = this.transFilterSelfDefineToSQL(mainQuery, loc, AcctDataType.ACCTCUSSENT);
        Date bizDateFrom = (Date)param.get("bizDateFrom");
        java.sql.Date begin = null;
        if (bizDateFrom != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(bizDateFrom);
            bizDateFrom = cal.getTime();
            begin = new java.sql.Date(bizDateFrom.getTime());
        }
        Date bizDateTo = (Date)param.get("bizDateTo");
        java.sql.Date end = null;
        if (bizDateTo != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(bizDateTo);
            bizDateTo = cal.getTime();
            end = new java.sql.Date(bizDateTo.getTime());
        }
        String bizNumber = (String)param.get("bizNumber");
        boolean accountShowLongName = false;
        if (param.get("accountShowLongName") != null) {
            accountShowLongName = (Boolean)param.get("accountShowLongName");
        }
        String accountNameField = accountShowLongName ? "flongname_" : "fname_";
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fid fid,' ' fvoucherid,isNull(vchType.fname_").append(loc).append(",N' ') FvoucherType,isNull(fvchnumber,N' ') FNumber,v.FCAA FCAA,v.fnumber Factnumber,v.").append(accountNameField).append(loc).append(" Factname, a.fvarbizdate FBizDate,a.FBizNumber FBizNumber,a.FendDate FBookedDate,\t\r\n");
        sql.append(" a.FDescription FDescription,a.FENTRYDC FDC,  \r\n");
        sql.append(" a.FOriginalAmount FOriginalAmount,a.FAssGrpID FAssGrpID,a.fvchassistrecordid voucherAssistRecordID,\t \r\n");
        sql.append(" a.FUnverifiedAmtFor FUnverifiedAmtFor,  \r\n");
        sql.append(" a.FLastUpdateTime as FLastUpdateTime, \r\n");
        sql.append(" p.fperiodyear fperiodyear, p.fperiodnumber fperiodnumber, p.fnumber fpnumber  \r\n");
        sql.append(" from T_GL_AcctCussent a  \r\n");
        sql.append(" left join T_BD_VOUCHERTYPES vchType on vchType.fid = a.fvoucherTypeid \r\n");
        sql.append(" left join t_bd_period p on p.fid = a.fperiodid \r\n");
        sql.append(" inner join t_bd_accountview v on  a.FAccountID = v.fid \r\n");
        sql.append(" inner join T_bd_assistanthg hg on a.FassgrpId =hg.fid  \r\n");
        StringBuilder sqlAssistJoin = new StringBuilder();
        this.structureHgSql(param, sqlAssistJoin);
        sql.append((CharSequence)sqlAssistJoin);
        sql.append(" \r\n where  a.FUnverifiedAmtFor <> 0 and a.FIsInit=1 \r\n");
        if (accountTableId != null && !"".equals(accountTableId)) {
            sql.append(" and v.FACCOUNTTABLEID = ? \r\n");
            params.add(accountTableId);
        }
        if (accountIDs != null) {
            sql.append(" and a.FCompanyID = ? and a.FCurrencyID = ? and a.FAccountID in ").append(CSSPUtils.getIdsSql((String[])accountIDs));
            params.add(companyID);
            params.add(currencyID);
        } else {
            sql.append(" and a.FCompanyID = ? and a.FCurrencyID = ?  \r\n");
            params.add(companyID);
            params.add(currencyID);
        }
        if (bizDateFrom != null) {
            sql.append(" and a.fvarbizdate >= ?  ");
            params.add(begin);
        }
        if (bizDateTo != null) {
            sql.append(" and a.fvarbizdate <= ?  ");
            params.add(end);
        }
        if (bizNumber != null) {
            sql.append(" and a.FBizNumber like ?  ");
            params.add(bizNumber);
        }
        if (initFilterSelfDefine.length() > 0) {
            sql.append(" and ").append(initFilterSelfDefine.toString());
        }
        sql.append(" \r\n");
        sql.append(" union all \r\n");
        sql.append("select a.fid fid,a.fvoucherid,vts.fname_l2 FvoucherType,d.fnumber FNumber,v.FCAA FCAA,v.fnumber Factnumber,v.").append(accountNameField).append(loc).append(" Factname, \r\n");
        sql.append(" a.fvarbizdate FBizDate,a.FBizNumber FBizNumber, \r\n");
        sql.append(" a.FendDate FBookedDate, a.FDescription FDescription,a.FENTRYDC FDC, \r\n");
        sql.append(" a.FOriginalAmount FOriginalAmount,a.FAssGrpID FAssGrpID,a.fvchassistrecordid voucherAssistRecordID, \r\n");
        sql.append(" a.FUnverifiedAmtFor FUnverifiedAmtFor,   \r\n");
        sql.append(" a.FLastUpdateTime as FLastUpdateTime, \r\n");
        sql.append(" p.fperiodyear fperiodyear, p.fperiodnumber fperiodnumber, p.fnumber fpnumber  \r\n");
        sql.append(" from T_GL_AcctCussent a   \r\n");
        sql.append(" left join t_bd_period p on p.fid = a.fperiodid \r\n");
        if (!includeReversed) {
            sql.append(" inner join T_GL_Voucher d on a.FVoucherID =d.fid and d.FIsAC = 1 \r\n");
            sql.append(" left join t_gl_Voucher rev on d.FSourceBillID = rev.fid  \r\n");
        } else {
            sql.append(" inner join T_GL_Voucher d on a.FVoucherID =d.fid \r\n");
        }
        sql.append(" inner join T_bd_VoucherTypes vts on vts.fid = a.FVoucherTypeID \r\n");
        sql.append(" inner join t_bd_accountview v on  a.FAccountID = v.fid  \r\n");
        sql.append(" inner join v_gl_acperiod acp on acp.fperiodid=a.fperiodid \r\n");
        sql.append(" inner join T_bd_assistanthg hg on a.FassgrpId = hg.fid  \r\n");
        sql.append((CharSequence)sqlAssistJoin);
        sql.append(" \r\n where a.FUnverifiedAmtFor <> 0 and a.FIsInit=0 \r\n");
        if (accountTableId != null && !"".equals(accountTableId)) {
            sql.append(" and v.FACCOUNTTABLEID = ? \r\n");
            params.add(accountTableId);
        }
        if (accountIDs != null) {
            sql.append(" and a.FCompanyID = ?  and a.FCurrencyID = ? and a.FAccountID in ").append(CSSPUtils.getIdsSql((String[])accountIDs));
            params.add(companyID);
            params.add(currencyID);
        } else {
            sql.append(" and a.FCompanyID = ?  and a.FCurrencyID = ?  \r\n");
            params.add(companyID);
            params.add(currencyID);
        }
        if (verifyMode == 0) {
            sql.append(" and a.fispost = 1 ");
        } else {
            sql.append(" and a.fispost > -1 ");
        }
        if (verifyMode == 1) {
            sql.append(" and d.fbizstatus = 5 ");
        }
        if (!includeReversed) {
            sql.append(" and ( d.FIsReverseVoucher = 0 AND d.FHasReversed = 0 OR d.FIsReverseVoucher = 1 AND rev.FHasReversed = 0) \r\n");
        }
        sql.append(" and acp.fcompanyid = ? \r\n");
        params.add(companyID);
        if (bizDateFrom != null) {
            sql.append(" and a.fvarbizdate >= ?  ");
            params.add(begin);
        }
        if (bizDateTo != null) {
            sql.append(" and a.fvarbizdate <= ?  ");
            params.add(end);
        }
        if (bizNumber != null) {
            sql.append(" and a.FBizNumber like ?  ");
            params.add(bizNumber);
        }
        boolean isFromVoucherUI = param.get("isFromVoucherUI") != null ? (Boolean)param.get("isFromVoucherUI") : false;
        String voucherId = (String)param.get("voucherId");
        if (isFromVoucherUI && voucherId != null) {
            sql.append(" and a.fvoucherId not in (?)");
            params.add(voucherId);
        }
        if (acctFilterSelfDefine.length() > 0) {
            sql.append(" and ").append(acctFilterSelfDefine.toString());
        }
        sql.append(" \r\n");
        if (!StringUtils.isEmpty((String)sortSelfDefine.toString())) {
            sql.append(sortSelfDefine);
        } else {
            sql.append("order by FBizDate,FBizNumber,fnumber");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            ArrayList result = new ArrayList();
            HashMap<String, AssistantHGInfo> cacheAssGrp = new HashMap<String, AssistantHGInfo>();
            while (rs.next()) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                String id = rs.getString("fid");
                item.put("voucherAssistRecordId", rs.getString("voucherAssistRecordID"));
                item.put("acctCussentId", id);
                item.put("FvoucherType", rs.getString("FvoucherType"));
                item.put("fvoucherid", rs.getString("fvoucherid"));
                item.put("FNumber", rs.getString("FNumber"));
                item.put("FactNumber", rs.getString("FactNumber"));
                item.put("FactName", rs.getString("FactName"));
                item.put("FPeriodYear", rs.getString("FPeriodYear"));
                item.put("FPeriodNumber", rs.getString("FPeriodNumber"));
                item.put("FBizDate", rs.getDate("FBizDate"));
                item.put("FBookedDate", rs.getDate("FBookedDate"));
                item.put("FDescription", rs.getString("FDescription"));
                item.put("FDC", new Integer(rs.getInt("FDC")));
                item.put("FOriginalAmount", rs.getBigDecimal("FOriginalAmount"));
                item.put("FUnverifiedAmtFor", rs.getBigDecimal("FUnverifiedAmtFor"));
                item.put("FVerifiedAmtFor", rs.getBigDecimal("FOriginalAmount").subtract(rs.getBigDecimal("FUnverifiedAmtFor")));
                AssistantHGInfo hgInfo = null;
                if (cacheAssGrp.containsKey(rs.getString("FAssGrpID"))) {
                    hgInfo = (AssistantHGInfo)cacheAssGrp.get(rs.getString("FAssGrpID"));
                } else {
                    String actFcaa = rs.getString("FCAA");
                    hgInfo = this.getHgInfo(ctx, rs.getString("FAssGrpID"), actFcaa);
                    cacheAssGrp.put(rs.getString("FAssGrpID"), hgInfo);
                }
                item.put("FAssGrpID", rs.getString("FAssGrpID"));
                item.put("hg", hgInfo);
                item.put("FBizNumber", rs.getString("FBizNumber"));
                item.put("FLastUpdateTime", rs.getTimestamp("FLastUpdateTime"));
                result.add(item);
            }
            returnAL.add(result);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return returnAL;
    }

    @Override
    protected void _verifyVoucher(Context ctx, String asstID, String cussentID, Date verifyDate, int verifyMode, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        try {
            String sqlSelect;
            IRowSet rsCussent;
            boolean isCommonVerify;
            block21: {
                block20: {
                    PreparedStatement sqlInsert;
                    Connection con;
                    block18: {
                        String cussentBostype = new AcctCussentInfo().getBOSType().toString();
                        isCommonVerify = BOSUuid.read((String)cussentID).getType().toString().equals(cussentBostype);
                        if (verifyMode != 0) break block20;
                        con = null;
                        sqlInsert = null;
                        try {
                            con = this.getConnection(ctx);
                            sqlInsert = con.prepareStatement(this.getInsertSQL());
                            Counter counter = new Counter();
                            this.inTimeVerify(ctx, asstID, cussentID, verifyDate, sqlInsert, counter, company);
                            if (counter.getValue() <= 0) break block18;
                            sqlInsert.executeBatch();
                            sqlInsert.clearBatch();
                            counter.clear();
                        }
                        catch (SQLException e) {
                            try {
                                throw new BOSException((Throwable)e);
                            }
                            catch (Throwable throwable) {
                                SQLUtils.cleanup(sqlInsert, (Connection)con);
                                throw throwable;
                            }
                        }
                    }
                    SQLUtils.cleanup((Statement)sqlInsert, (Connection)con);
                    break block21;
                }
                Map amountHxMap = this.getHSInfo(ctx, asstID);
                BigDecimal originalAmount = (BigDecimal)amountHxMap.get("originalAmount");
                Map amountGZMap = this.getUnverifiedAmt(ctx, cussentID);
                BigDecimal unverifiedAmtFor = (BigDecimal)amountGZMap.get("FUnverifiedAmtFor");
                if (unverifiedAmtFor == null) {
                    amountGZMap = this.getUnverifiedAmtForVerify(ctx, cussentID);
                    unverifiedAmtFor = (BigDecimal)amountGZMap.get("FUnverifiedAmtFor");
                }
                if (originalAmount.abs().compareTo(unverifiedAmtFor.abs()) > 0) {
                    throw new GLException(GLException.VERIFYGREATERGZ);
                }
                if (isCommonVerify) {
                    boolean flag;
                    String selectSql;
                    IRowSet rs;
                    if (verifyMode == 1 && !(rs = DbUtil.executeQuery((Context)ctx, (String)(selectSql = "select 1 from t_gl_acctcussent c inner join t_gl_voucherassistrecord a on c.FVchAssistRecordID=a.fid left outer join t_gl_voucher v on v.fid=a.fbillid where c.fid = ? and (v.fid is null and c.FIsInit=1 and c.FIsInitClosed=1 or v.fbizstatus=5) "), (Object[])new Object[]{cussentID})).next()) {
                        throw new GLException(GLException.DATA_HAS_MODIFIED);
                    }
                    selectSql = "select 1 assGrpId from t_gl_voucherassistrecord s where fid=? and FAssGrpID not in (select vs.FAssGrpID from t_gl_acctcussent c inner join t_gl_voucherassistrecord vs on vs.fid=c.FVchAssistRecordID where c.fid=?)";
                    rs = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{asstID, cussentID});
                    if (rs.next() && !(flag = this.checkAsstValue(ctx, asstID, cussentID))) {
                        throw new GLException(GLException.ASSGRP_NOT_EQUAL_CANNOT_VERIFY);
                    }
                    HashMap<String, List<String>> pair = new HashMap<String, List<String>>();
                    pair.put(asstID, Arrays.asList(cussentID));
                    this.fromVch = true;
                    Map result = this.getVerifyAmount(ctx, asstID);
                    BigDecimal tempO = (BigDecimal)result.get("FUnverifiedAmtFor");
                    if (tempO.compareTo(new BigDecimal("0")) > 0) {
                        this._verify(ctx, new String[]{asstID}, pair, null, company);
                    } else {
                        this._negativeVerify(ctx, new String[]{asstID}, pair, null, company);
                    }
                } else {
                    HashMap pair = new HashMap();
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(asstID);
                    list.add(cussentID);
                    pair.put(list, list);
                    this._innerNegVerify(ctx, pair, null, company);
                }
            }
            if (isCommonVerify && !(rsCussent = DbUtil.executeQuery((Context)ctx, (String)(sqlSelect = "select fid from t_gl_acctcussent where fid=?"), (Object[])new Object[]{cussentID})).next()) {
                throw new GLException(GLException.ACCTCUSSENTNOTEXIST);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.fromVch = false;
        }
    }

    private boolean checkAsstValue(Context ctx, String asstID, String cussentID) throws BOSException, SQLException, EASBizException {
        String sql1 = "select FAssGrpID  from t_gl_voucherassistrecord where fid=? ";
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new Object[]{asstID});
        String vssAsstHgId = "";
        if (rs1.next()) {
            vssAsstHgId = rs1.getString(1);
        }
        String sql2 = "select FAssGrpID  from t_gl_acctcussent where fid=?";
        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new Object[]{cussentID});
        String acctAsstHgId = "";
        if (rs2.next()) {
            acctAsstHgId = rs2.getString(1);
        }
        if (!StringUtils.isEmpty((String)vssAsstHgId) && !StringUtils.isEmpty((String)acctAsstHgId)) {
            AssistantHGInfo oldAssistantHGInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(vssAsstHgId));
            AssistantHGInfo newAssistantHGInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(acctAsstHgId));
            List<String> vssHgInfoList = this.getHgInfoList(oldAssistantHGInfo);
            List<String> acctHgInfoList = this.getHgInfoList(newAssistantHGInfo);
            for (int i = 0; i < vssHgInfoList.size(); ++i) {
                if (vssHgInfoList.get(i).startsWith("asstaccount$") || vssHgInfoList.get(i).startsWith("cu$")) continue;
                for (int k = 0; k < acctHgInfoList.size(); ++k) {
                    if (!vssHgInfoList.get(i).equals(acctHgInfoList.get(k))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private List<String> getHgInfoList(AssistantHGInfo hgInfo) {
        Enumeration enumration = hgInfo.keys();
        ArrayList<String> info = new ArrayList<String>();
        while (enumration.hasMoreElements()) {
            String key = (String)enumration.nextElement();
            Object value = hgInfo.get(key);
            if (value == null || !(value instanceof DataBaseInfo)) continue;
            info.add(key + "$" + ((DataBaseInfo)value).getId());
        }
        return info;
    }

    private void inTimeVerify(Context ctx, String asstID, String cussentID, Date verifyDate, PreparedStatement sqlInsert, Counter counter, CompanyOrgUnitInfo company) throws BOSException, EASBizException, SQLException {
        BigDecimal originalAmount = null;
        BigDecimal localAmount = null;
        BigDecimal reportingAmount = null;
        BigDecimal qty = null;
        BigDecimal unverifiedAmtFor = null;
        BigDecimal unverifiedAmtLocal = null;
        BigDecimal unverifiedAmtRpt = null;
        BigDecimal unverifiedAmtQty = null;
        String number = this.getAcctcussentHistoryNumber(ctx, verifyDate, company);
        int Seq = 1;
        Map amountHxMap = this.getHSInfo(ctx, asstID);
        originalAmount = (BigDecimal)amountHxMap.get("originalAmount");
        localAmount = (BigDecimal)amountHxMap.get("localAmount");
        reportingAmount = (BigDecimal)amountHxMap.get("reportingAmount");
        qty = (BigDecimal)amountHxMap.get("qty");
        Map amountGZMap = this.getUnverifiedAmt(ctx, cussentID);
        unverifiedAmtFor = (BigDecimal)amountGZMap.get("FUnverifiedAmtFor");
        unverifiedAmtLocal = (BigDecimal)amountGZMap.get("FUnverifiedAmtLocal");
        unverifiedAmtRpt = (BigDecimal)amountGZMap.get("FUnverifiedAmtRpt");
        unverifiedAmtQty = (BigDecimal)amountGZMap.get("FUnverifiedQty");
        amountGZMap.put("FNumber", number);
        amountGZMap.put("FVerifyDate", verifyDate);
        amountGZMap.put("FSeq", new Integer(Seq++));
        GLVerifyTypeEnum type = GLVerifyTypeEnum.COMMON_VERIFY;
        String cussentIdHx = null;
        if (((Boolean)amountHxMap.get("FIsReverseVoucher")).booleanValue()) {
            type = GLVerifyTypeEnum.SAME_VERIFY;
            amountHxMap.put("FNumber", number);
            amountHxMap.put("FVerifyDate", verifyDate);
            amountHxMap.put("FSeq", new Integer(Seq++));
            amountHxMap.put("FOriginalAmount", originalAmount);
            amountHxMap.put("FLocalAmount", localAmount);
            amountHxMap.put("FReportingAmount", reportingAmount);
            amountHxMap.put("FQuantity", qty);
            String sql = "SELECT fid FROM T_GL_ACCTCUSSENT where FVCHASSISTRECORDID = ? ";
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{asstID});
            if (result.next()) {
                cussentIdHx = result.getString(1);
            }
        } else if (originalAmount.signum() < 0) {
            type = GLVerifyTypeEnum.NEGATIVE_VERIFY;
        }
        Map mapVeriVchEntryIds = this.getVerifyVchIds(ctx, new String[]{asstID});
        AcctCussentHistoryInfo acctCussentHistoryInfo = null;
        AcctCussentHistoryInfo acctCussentHistoryInfo2 = null;
        if (type == GLVerifyTypeEnum.SAME_VERIFY && cussentIdHx != null) {
            acctCussentHistoryInfo = this.createAcctCussentHistoryInfo(ctx, amountGZMap, cussentID, cussentIdHx, type, company, amountHxMap);
            acctCussentHistoryInfo2 = this.createAcctCussentHistoryInfo(ctx, amountHxMap, cussentIdHx, cussentID, type, company, amountGZMap);
        } else {
            acctCussentHistoryInfo = this.createAcctCussentHistoryInfo(ctx, amountGZMap, cussentID, asstID, type, company, amountHxMap);
        }
        if (originalAmount.abs().compareTo(unverifiedAmtFor.abs()) > 0) {
            throw new GLException(GLException.VERIFYGREATERGZ);
        }
        if (originalAmount.abs().compareTo(unverifiedAmtFor.abs()) < 0) {
            if (type == GLVerifyTypeEnum.SAME_VERIFY && acctCussentHistoryInfo2 != null) {
                acctCussentHistoryInfo.setOroginalAmount(unverifiedAmtFor.subtract(unverifiedAmtFor.add(originalAmount)));
                acctCussentHistoryInfo.setLocalAmount(unverifiedAmtLocal.subtract(unverifiedAmtLocal.add(localAmount)));
                acctCussentHistoryInfo.setReportAmount(unverifiedAmtRpt.subtract(unverifiedAmtRpt.add(reportingAmount)));
                acctCussentHistoryInfo.setQty(unverifiedAmtQty.subtract(unverifiedAmtQty.add(qty)));
                acctCussentHistoryInfo.setOriginalBalance(unverifiedAmtFor.add(originalAmount));
                acctCussentHistoryInfo.setLocalBalance(unverifiedAmtLocal.add(localAmount));
                acctCussentHistoryInfo.setReportBanlance(unverifiedAmtRpt.add(reportingAmount));
                acctCussentHistoryInfo.setQtyBalance(unverifiedAmtQty.add(qty));
                acctCussentHistoryInfo2.setOroginalAmount(originalAmount);
                acctCussentHistoryInfo2.setLocalAmount(localAmount);
                acctCussentHistoryInfo2.setReportAmount(reportingAmount);
                acctCussentHistoryInfo2.setQty(qty);
                acctCussentHistoryInfo2.setOriginalBalance(GlUtils.zero);
                acctCussentHistoryInfo2.setLocalBalance(GlUtils.zero);
                acctCussentHistoryInfo2.setReportBanlance(GlUtils.zero);
                acctCussentHistoryInfo2.setQtyBalance(GlUtils.zero);
                this.insertHistory(ctx, acctCussentHistoryInfo, GLVerifyTypeEnum.SAME_VERIFY, sqlInsert, counter);
                this.insertHistory(ctx, acctCussentHistoryInfo2, GLVerifyTypeEnum.SAME_VERIFY, sqlInsert, counter);
            } else {
                acctCussentHistoryInfo.setOroginalAmount(originalAmount);
                acctCussentHistoryInfo.setLocalAmount(localAmount);
                acctCussentHistoryInfo.setReportAmount(reportingAmount);
                acctCussentHistoryInfo.setQty(qty);
                acctCussentHistoryInfo.setOriginalBalance(unverifiedAmtFor.subtract(originalAmount));
                acctCussentHistoryInfo.setLocalBalance(unverifiedAmtLocal.subtract(localAmount));
                acctCussentHistoryInfo.setReportBanlance(unverifiedAmtRpt.subtract(reportingAmount));
                acctCussentHistoryInfo.setQtyBalance(unverifiedAmtQty.subtract(qty));
                this.insertHistory(ctx, acctCussentHistoryInfo, GLVerifyTypeEnum.INTIME_VERIFY, sqlInsert, counter);
            }
        } else if (type == GLVerifyTypeEnum.SAME_VERIFY && acctCussentHistoryInfo2 != null) {
            acctCussentHistoryInfo.setOroginalAmount(unverifiedAmtFor);
            acctCussentHistoryInfo.setLocalAmount(unverifiedAmtLocal);
            acctCussentHistoryInfo.setReportAmount(unverifiedAmtRpt);
            acctCussentHistoryInfo.setQty(unverifiedAmtQty);
            acctCussentHistoryInfo.setOriginalBalance(GlUtils.zero);
            acctCussentHistoryInfo.setLocalBalance(GlUtils.zero);
            acctCussentHistoryInfo.setReportBanlance(GlUtils.zero);
            acctCussentHistoryInfo.setQtyBalance(GlUtils.zero);
            acctCussentHistoryInfo2.setOroginalAmount(originalAmount);
            acctCussentHistoryInfo2.setLocalAmount(localAmount);
            acctCussentHistoryInfo2.setReportAmount(reportingAmount);
            acctCussentHistoryInfo2.setQty(qty);
            acctCussentHistoryInfo2.setOriginalBalance(GlUtils.zero);
            acctCussentHistoryInfo2.setLocalBalance(GlUtils.zero);
            acctCussentHistoryInfo2.setReportBanlance(GlUtils.zero);
            acctCussentHistoryInfo2.setQtyBalance(GlUtils.zero);
            this.insertHistory(ctx, acctCussentHistoryInfo, GLVerifyTypeEnum.SAME_VERIFY, sqlInsert, counter);
            this.insertHistory(ctx, acctCussentHistoryInfo2, GLVerifyTypeEnum.SAME_VERIFY, sqlInsert, counter);
        } else {
            acctCussentHistoryInfo.setOroginalAmount(originalAmount);
            acctCussentHistoryInfo.setLocalAmount(localAmount);
            acctCussentHistoryInfo.setReportAmount(reportingAmount);
            acctCussentHistoryInfo.setQty(qty);
            acctCussentHistoryInfo.setOriginalBalance(GlUtils.zero);
            acctCussentHistoryInfo.setLocalBalance(GlUtils.zero);
            acctCussentHistoryInfo.setReportBanlance(GlUtils.zero);
            acctCussentHistoryInfo.setQtyBalance(GlUtils.zero);
            this.insertHistory(ctx, acctCussentHistoryInfo, GLVerifyTypeEnum.INTIME_VERIFY, sqlInsert, counter);
        }
    }

    private Map getHSInfo(Context ctx, String asstID) throws BOSException {
        try {
            HashMap<String, Object> amountMap = new HashMap<String, Object>();
            BigDecimal originalAmount = new BigDecimal("0");
            BigDecimal localAmount = new BigDecimal("0");
            BigDecimal reportingAmout = new BigDecimal("0");
            BigDecimal qty = new BigDecimal("0");
            String sql = "select a.FOriginalAmount ,a.FLocalAmount, a.FReportingAmount,a.FQuantity, b.fcompanyid,e.faccountid,e.fcurrencyid,a.fassgrpid,a.fbizdate,a.fdescription,a.fbiznumber,b.fnumber,b.fbookeddate,b.fid FCussVchID, e.fid FCussEntryID, p.fnumber FPeriodNumber,b.FIsReverseVoucher   from T_GL_VoucherAssistRecord a inner join t_gl_voucher b on a.fbillid = b.fid inner join t_gl_voucherentry e on a.fentryid = e.fid inner join t_bd_period p on p.fid = a.FPERIODID   where a.fid = ?                                                                                                                                            ";
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{asstID});
            while (rowset.next()) {
                originalAmount = originalAmount.add(rowset.getBigDecimal(1));
                localAmount = localAmount.add(rowset.getBigDecimal(2));
                reportingAmout = reportingAmout.add(rowset.getBigDecimal(3));
                qty = qty.add(rowset.getBigDecimal(4));
                amountMap.put("FCompanyID", rowset.getString(5));
                amountMap.put("FAccountID", rowset.getString(6));
                amountMap.put("FCurrencyID", rowset.getString(7));
                amountMap.put("FAssGrpID", rowset.getString(8));
                amountMap.put("FBizDate", rowset.getDate(9));
                amountMap.put("FDescription", rowset.getString(10));
                amountMap.put("FBizNumber", rowset.getString(11));
                amountMap.put("FVchNumber", rowset.getString(12));
                amountMap.put("FBookedDate", rowset.getDate(13));
                amountMap.put("FCussVchID", rowset.getString(14));
                amountMap.put("FCussEntryID", rowset.getString(15));
                amountMap.put("FPeriodNumber", rowset.getInt(16));
                amountMap.put("FIsReverseVoucher", rowset.getBoolean(17));
            }
            amountMap.put("originalAmount", originalAmount);
            amountMap.put("localAmount", localAmount);
            amountMap.put("reportingAmount", reportingAmout);
            amountMap.put("qty", qty);
            return amountMap;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _negativeVerify(Context ctx, String[] verifyAsstIds, Map pair, Map dateMap, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PreparedStatement sqlInsert;
        Connection con;
        block9: {
            HashSet cussSet = new HashSet();
            for (int i = 0; i < verifyAsstIds.length; ++i) {
                List cussentVchIds = (List)pair.get(verifyAsstIds[i]);
                if (dateMap == null || dateMap.size() <= 0) continue;
                cussSet.addAll(cussentVchIds);
            }
            this.checkBeforeVerify(ctx, cussSet.toArray(new String[0]), false, dateMap);
            this.checkBeforeVerify(ctx, verifyAsstIds, true, dateMap);
            String accountid = (String)pair.get("actNumber");
            Uuid requestId = GLMutexUtils.setAcExclusiveMutex(ctx, company.getId().toString(), accountid, GLMutexUtils.GL_Verify, logger);
            con = null;
            sqlInsert = null;
            try {
                boolean isFromVchUI;
                List cussentVchIds;
                con = this.getConnection(ctx);
                sqlInsert = con.prepareStatement(this.getInsertSQL());
                Map mapVeriVchEntryIds = this.getVerifyVchIds(ctx, verifyAsstIds);
                Counter counterInsert = new Counter();
                ArrayList verifiedSrc = new ArrayList();
                int verifyCnt = 0;
                for (int i = 0; i < verifyAsstIds.length; verifyCnt += this.commonVerify(ctx, cussentVchIds.toArray(new String[0]), new String[]{verifyAsstIds[i]}, true, GLVerifyTypeEnum.NEGATIVE_VERIFY, verifiedSrc, sqlInsert, counterInsert, company, mapVeriVchEntryIds), ++i) {
                    cussentVchIds = (List)pair.get(verifyAsstIds[i]);
                }
                if (counterInsert.getValue() > 0) {
                    sqlInsert.executeBatch();
                    sqlInsert.clearBatch();
                    counterInsert.clear();
                }
                boolean bl = isFromVchUI = dateMap == null || dateMap.size() == 0;
                if (!isFromVchUI && verifyCnt == 0) {
                    throw new GLException(GLException.CUSSENT_VERIFY_NO_MATCH_RECORD);
                }
                if (requestId == null) break block9;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (requestId != null) {
                        GLMutexUtils.releaseMutex(ctx, requestId);
                    }
                    SQLUtils.cleanup(sqlInsert, (Connection)con);
                    throw throwable;
                }
            }
            GLMutexUtils.releaseMutex(ctx, requestId);
        }
        SQLUtils.cleanup((Statement)sqlInsert, (Connection)con);
    }

    @Override
    protected void _negativeVerify(Context ctx, Map verifyAsstIds, Map pair, Map dateMap, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        Set acts = verifyAsstIds.keySet();
        Iterator it = acts.iterator();
        int i = 0;
        while (it.hasNext()) {
            String actNumber = (String)it.next();
            ArrayList verifyAsstId = (ArrayList)verifyAsstIds.get(actNumber);
            try {
                pair.put("actNumber", actNumber);
                this._negativeVerify(ctx, verifyAsstId.toArray(new String[0]), pair, dateMap, company);
            }
            catch (Exception e) {
                ++i;
            }
        }
        if (i == acts.size()) {
            throw new GLException(GLException.CUSSENT_VERIFY_NO_MATCH_RECORD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _innerNegVerify(Context ctx, Map pairs, Map dateMap, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        int i = 0;
        if (dateMap != null) {
            Set actSet = pairs.keySet();
            for (String key : actSet) {
                ArrayList pair = (ArrayList)pairs.get(key);
                Collection values = pairs.values();
                Uuid requestId = GLMutexUtils.setAcExclusiveMutex(ctx, company.getId().toString(), key, GLMutexUtils.GL_Verify, logger);
                try {
                    this.commInnerNegVerify(ctx, values, dateMap, company);
                }
                catch (Exception e) {
                    ++i;
                }
                finally {
                    if (requestId == null) continue;
                    GLMutexUtils.releaseMutex(ctx, requestId);
                }
            }
            if (i == actSet.size()) {
                throw new GLException(GLException.CUSSENT_VERIFY_NO_MATCH_RECORD);
            }
        } else {
            Collection values = pairs.values();
            this.commInnerNegVerify(ctx, values, dateMap, company);
        }
    }

    private void commInnerNegVerify(Context ctx, Collection values, Map dateMap, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        HashSet asstSet = new HashSet();
        for (List list : values) {
            asstSet.addAll(list);
        }
        this.checkBeforeVerify(ctx, asstSet.toArray(new String[0]), true, dateMap);
        ArrayList<String> positiveAsst = new ArrayList<String>();
        ArrayList<String> negativeAsst = new ArrayList<String>();
        Connection con = null;
        PreparedStatement sqlInsert = null;
        try {
            boolean isFromVchUI;
            IRowSet rs;
            String sql;
            String sqlSelect = "select fid,foriginalAmount from t_gl_voucherassistrecord where fid in ({0}) ";
            int count = 0;
            StringBuffer sqlVars = new StringBuffer();
            ArrayList<String> params = new ArrayList<String>();
            Iterator it = asstSet.iterator();
            String assistId = null;
            while (it.hasNext()) {
                assistId = (String)it.next();
                sqlVars.append(",?");
                params.add(assistId);
                if (++count % 500 != 0) continue;
                sqlVars.deleteCharAt(0);
                sql = MessageFormat.format(sqlSelect, sqlVars.toString());
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params.toArray());
                while (rs.next()) {
                    if (rs.getBigDecimal(2).compareTo(this.ZERO) > 0) {
                        positiveAsst.add(rs.getString(1));
                        continue;
                    }
                    negativeAsst.add(rs.getString(1));
                }
                count = 0;
                sqlVars.delete(0, sqlVars.length());
                params.clear();
            }
            if (count > 0) {
                sqlVars.deleteCharAt(0);
                sql = MessageFormat.format(sqlSelect, sqlVars.toString());
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params.toArray());
                while (rs.next()) {
                    if (rs.getBigDecimal(2).compareTo(this.ZERO) > 0) {
                        positiveAsst.add(rs.getString(1));
                        continue;
                    }
                    negativeAsst.add(rs.getString(1));
                }
                count = 0;
                sqlVars.delete(0, sqlVars.length());
                params.clear();
            }
            con = this.getConnection(ctx);
            sqlInsert = con.prepareStatement(this.getInsertSQL());
            Counter counter = new Counter();
            ArrayList verifiedSrc = new ArrayList();
            int verifyCnt = 0;
            for (List list : values) {
                verifyCnt += this.innerNegVerify(ctx, list.toArray(new String[0]), verifiedSrc, positiveAsst, negativeAsst, sqlInsert, counter, company, null);
            }
            if (counter.getValue() > 0) {
                sqlInsert.executeBatch();
                sqlInsert.clearBatch();
                counter.clear();
            }
            boolean bl = isFromVchUI = dateMap == null || dateMap.size() == 0;
            if (!isFromVchUI && verifyCnt == 0) {
                throw new GLException(GLException.CUSSENT_VERIFY_NO_MATCH_RECORD);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sqlInsert, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sqlInsert, (Connection)con);
    }

    private int innerNegVerify(Context ctx, String[] srcIDs, List verifiedSrc, List positiveAsst, List negativeAsst, PreparedStatement sqlInsert, Counter counter, CompanyOrgUnitInfo company, Map mapVeriVchEntryIds) throws BOSException, EASBizException, SQLException {
        int verifyCnt = 0;
        BigDecimal unverifiedAmtForI = null;
        BigDecimal unverifiedAmtLocalI = null;
        BigDecimal unverifiedAmtRptI = null;
        BigDecimal unverifiedAmtQtyI = null;
        BigDecimal unverifiedAmtForJ = null;
        BigDecimal unverifiedAmtLocalJ = null;
        BigDecimal unverifiedAmtRptJ = null;
        BigDecimal unverifiedAmtQtyJ = null;
        BigDecimal zeroBigDecimal = new BigDecimal("0");
        Date verifyDate = DateTimeUtils.truncateDate((Date)new Date());
        String number = this.getAcctcussentHistoryNumber(ctx, verifyDate, company);
        int Seq = 1;
        block0: for (int i = 0; i < srcIDs.length; ++i) {
            if (verifiedSrc.contains(srcIDs[i]) || negativeAsst.contains(srcIDs[i])) continue;
            Map amountGzMap = this.getVerifyAmountAsAC(ctx, srcIDs[i]);
            BigDecimal tempO = (BigDecimal)amountGzMap.get("FUnverifiedAmtFor");
            BigDecimal tempL = (BigDecimal)amountGzMap.get("FUnverifiedAmtLocal");
            BigDecimal tempR = (BigDecimal)amountGzMap.get("FUnverifiedAmtRpt");
            BigDecimal tempQ = (BigDecimal)amountGzMap.get("FUnverifiedAmtQty");
            if (tempO.compareTo(this.ZERO) == 0) {
                verifiedSrc.add(srcIDs[i]);
                continue;
            }
            if (unverifiedAmtForI == null || unverifiedAmtForI.compareTo(this.ZERO) == 0) {
                unverifiedAmtForI = tempO;
                unverifiedAmtLocalI = tempL;
                unverifiedAmtRptI = tempR;
                unverifiedAmtQtyI = tempQ;
            }
            for (int j = i + 1; j < srcIDs.length; ++j) {
                if (verifiedSrc.contains(srcIDs[j]) || positiveAsst.contains(srcIDs[j])) continue;
                Map amountGzMap2 = this.getVerifyAmount(ctx, srcIDs[j]);
                unverifiedAmtForJ = (BigDecimal)amountGzMap2.get("FUnverifiedAmtFor");
                unverifiedAmtLocalJ = (BigDecimal)amountGzMap2.get("FUnverifiedAmtLocal");
                unverifiedAmtRptJ = (BigDecimal)amountGzMap2.get("FUnverifiedAmtRpt");
                unverifiedAmtQtyJ = (BigDecimal)amountGzMap2.get("FUnverifiedAmtQty");
                if (unverifiedAmtForJ.compareTo(this.ZERO) == 0) {
                    verifiedSrc.add(srcIDs[j]);
                    continue;
                }
                if (!this.isGoOn(unverifiedAmtForI, unverifiedAmtForJ)) continue;
                Map amountGzMapi = this.getVerifyAmountAsAC(ctx, srcIDs[i]);
                amountGzMapi.put("FNumber", number);
                amountGzMapi.put("FVerifyDate", verifyDate);
                amountGzMapi.put("FSeq", new Integer(Seq++));
                Map amountGzMapj = this.getVerifyAmountAsAC(ctx, srcIDs[j]);
                amountGzMapj.put("FNumber", number);
                amountGzMapj.put("FVerifyDate", verifyDate);
                amountGzMapj.put("FSeq", new Integer(Seq++));
                AcctCussentHistoryInfo acctCussentHistoryInfoI = this.createAcctCussentHistoryInfo(ctx, amountGzMapi, srcIDs[i], srcIDs[j], GLVerifyTypeEnum.INNER_NEGATIVE_VERIFY, company, amountGzMapj);
                AcctCussentHistoryInfo acctCussentHistoryInfoJ = this.createAcctCussentHistoryInfo(ctx, amountGzMapj, srcIDs[j], srcIDs[i], GLVerifyTypeEnum.INNER_NEGATIVE_VERIFY, company, amountGzMapi);
                if (unverifiedAmtForI.abs().compareTo(unverifiedAmtForJ.abs()) > 0) {
                    acctCussentHistoryInfoI.setOroginalAmount(unverifiedAmtForI.subtract(unverifiedAmtForI.add(unverifiedAmtForJ)));
                    acctCussentHistoryInfoI.setLocalAmount(unverifiedAmtLocalI.subtract(unverifiedAmtLocalI.add(unverifiedAmtLocalJ)));
                    acctCussentHistoryInfoI.setReportAmount(unverifiedAmtRptI.subtract(unverifiedAmtRptI.add(unverifiedAmtRptJ)));
                    acctCussentHistoryInfoI.setQty(unverifiedAmtQtyI.subtract(unverifiedAmtQtyI.add(unverifiedAmtQtyJ)));
                    acctCussentHistoryInfoI.setOriginalBalance(unverifiedAmtForI.add(unverifiedAmtForJ));
                    acctCussentHistoryInfoI.setLocalBalance(unverifiedAmtLocalI.add(unverifiedAmtLocalJ));
                    acctCussentHistoryInfoI.setReportBanlance(unverifiedAmtRptI.add(unverifiedAmtRptJ));
                    acctCussentHistoryInfoI.setQtyBalance(unverifiedAmtQtyI.add(unverifiedAmtQtyJ));
                    acctCussentHistoryInfoJ.setOroginalAmount(unverifiedAmtForJ);
                    acctCussentHistoryInfoJ.setLocalAmount(unverifiedAmtLocalJ);
                    acctCussentHistoryInfoJ.setReportAmount(unverifiedAmtRptJ);
                    acctCussentHistoryInfoJ.setQty(unverifiedAmtQtyJ);
                    acctCussentHistoryInfoJ.setOriginalBalance(GlUtils.zero);
                    acctCussentHistoryInfoJ.setLocalBalance(GlUtils.zero);
                    acctCussentHistoryInfoJ.setReportBanlance(GlUtils.zero);
                    acctCussentHistoryInfoJ.setQtyBalance(GlUtils.zero);
                    this.insertHistory(ctx, acctCussentHistoryInfoI, GLVerifyTypeEnum.INNER_NEGATIVE_VERIFY, sqlInsert, counter);
                    this.insertHistory(ctx, acctCussentHistoryInfoJ, GLVerifyTypeEnum.INNER_NEGATIVE_VERIFY, sqlInsert, counter);
                    ++verifyCnt;
                    unverifiedAmtForI = unverifiedAmtForI.add(unverifiedAmtForJ);
                    unverifiedAmtLocalI = unverifiedAmtLocalI.add(unverifiedAmtLocalJ);
                    unverifiedAmtRptI = unverifiedAmtRptI.add(unverifiedAmtRptJ);
                    unverifiedAmtQtyI = unverifiedAmtQtyI.add(unverifiedAmtQtyJ);
                    unverifiedAmtForJ = zeroBigDecimal;
                    this.changeVerifiedStatus(ctx, srcIDs[j]);
                    this.updateUnverifiedAmtFor(ctx, srcIDs[j], new BigDecimal[]{GlUtils.zero, GlUtils.zero, GlUtils.zero, GlUtils.zero});
                    this.updateUnverifiedAmtFor(ctx, srcIDs[i], new BigDecimal[]{unverifiedAmtForI, unverifiedAmtLocalI, unverifiedAmtRptI, unverifiedAmtQtyI});
                    verifiedSrc.add(srcIDs[j]);
                    continue;
                }
                if (unverifiedAmtForI.abs().compareTo(unverifiedAmtForJ.abs()) < 0) {
                    acctCussentHistoryInfoI.setOroginalAmount(unverifiedAmtForI);
                    acctCussentHistoryInfoI.setLocalAmount(unverifiedAmtLocalI);
                    acctCussentHistoryInfoI.setReportAmount(unverifiedAmtRptI);
                    acctCussentHistoryInfoI.setQty(unverifiedAmtQtyI);
                    acctCussentHistoryInfoI.setOriginalBalance(GlUtils.zero);
                    acctCussentHistoryInfoI.setLocalBalance(GlUtils.zero);
                    acctCussentHistoryInfoI.setReportBanlance(GlUtils.zero);
                    acctCussentHistoryInfoI.setQtyBalance(GlUtils.zero);
                    acctCussentHistoryInfoJ.setOroginalAmount(unverifiedAmtForJ.subtract(unverifiedAmtForJ.add(unverifiedAmtForI)));
                    acctCussentHistoryInfoJ.setLocalAmount(unverifiedAmtLocalJ.subtract(unverifiedAmtLocalJ.add(unverifiedAmtLocalI)));
                    acctCussentHistoryInfoJ.setReportAmount(unverifiedAmtRptJ.subtract(unverifiedAmtRptJ.add(unverifiedAmtRptI)));
                    acctCussentHistoryInfoJ.setQty(unverifiedAmtQtyJ.subtract(unverifiedAmtQtyJ.add(unverifiedAmtQtyI)));
                    acctCussentHistoryInfoJ.setOriginalBalance(unverifiedAmtForJ.add(unverifiedAmtForI));
                    acctCussentHistoryInfoJ.setLocalBalance(unverifiedAmtLocalJ.add(unverifiedAmtLocalI));
                    acctCussentHistoryInfoJ.setReportBanlance(unverifiedAmtRptJ.add(unverifiedAmtRptI));
                    acctCussentHistoryInfoJ.setQtyBalance(unverifiedAmtQtyJ.add(unverifiedAmtQtyI));
                    this.insertHistory(ctx, acctCussentHistoryInfoI, GLVerifyTypeEnum.INNER_NEGATIVE_VERIFY, sqlInsert, counter);
                    this.insertHistory(ctx, acctCussentHistoryInfoJ, GLVerifyTypeEnum.INNER_NEGATIVE_VERIFY, sqlInsert, counter);
                    ++verifyCnt;
                    unverifiedAmtForJ = unverifiedAmtForI.add(unverifiedAmtForJ);
                    unverifiedAmtLocalJ = unverifiedAmtLocalI.add(unverifiedAmtLocalJ);
                    unverifiedAmtRptJ = unverifiedAmtRptI.add(unverifiedAmtRptJ);
                    unverifiedAmtQtyJ = unverifiedAmtQtyI.add(unverifiedAmtQtyJ);
                    unverifiedAmtForI = zeroBigDecimal;
                    this.changeVerifiedStatus(ctx, srcIDs[i]);
                    this.updateUnverifiedAmtFor(ctx, srcIDs[i], new BigDecimal[]{GlUtils.zero, GlUtils.zero, GlUtils.zero, GlUtils.zero});
                    this.updateUnverifiedAmtFor(ctx, srcIDs[j], new BigDecimal[]{unverifiedAmtForJ, unverifiedAmtLocalJ, unverifiedAmtRptJ, unverifiedAmtQtyJ});
                    verifiedSrc.add(srcIDs[i]);
                    continue block0;
                }
                acctCussentHistoryInfoI.setOroginalAmount(unverifiedAmtForI);
                acctCussentHistoryInfoI.setLocalAmount(unverifiedAmtLocalI);
                acctCussentHistoryInfoI.setReportAmount(unverifiedAmtRptI);
                acctCussentHistoryInfoI.setQty(unverifiedAmtQtyI);
                acctCussentHistoryInfoI.setOriginalBalance(GlUtils.zero);
                acctCussentHistoryInfoI.setLocalBalance(GlUtils.zero);
                acctCussentHistoryInfoI.setReportBanlance(GlUtils.zero);
                acctCussentHistoryInfoI.setQtyBalance(GlUtils.zero);
                acctCussentHistoryInfoJ.setOroginalAmount(unverifiedAmtForJ);
                acctCussentHistoryInfoJ.setLocalAmount(unverifiedAmtLocalJ);
                acctCussentHistoryInfoJ.setReportAmount(unverifiedAmtRptJ);
                acctCussentHistoryInfoJ.setQty(unverifiedAmtQtyJ);
                acctCussentHistoryInfoJ.setOriginalBalance(GlUtils.zero);
                acctCussentHistoryInfoJ.setLocalBalance(GlUtils.zero);
                acctCussentHistoryInfoJ.setReportBanlance(GlUtils.zero);
                acctCussentHistoryInfoJ.setQtyBalance(GlUtils.zero);
                this.insertHistory(ctx, acctCussentHistoryInfoI, GLVerifyTypeEnum.INNER_NEGATIVE_VERIFY, sqlInsert, counter);
                this.insertHistory(ctx, acctCussentHistoryInfoJ, GLVerifyTypeEnum.INNER_NEGATIVE_VERIFY, sqlInsert, counter);
                ++verifyCnt;
                unverifiedAmtForI = zeroBigDecimal;
                unverifiedAmtForJ = zeroBigDecimal;
                this.changeVerifiedStatus(ctx, srcIDs[i]);
                this.changeVerifiedStatus(ctx, srcIDs[j]);
                this.updateUnverifiedAmtFor(ctx, srcIDs[i], new BigDecimal[]{GlUtils.zero, GlUtils.zero, GlUtils.zero, GlUtils.zero});
                this.updateUnverifiedAmtFor(ctx, srcIDs[j], new BigDecimal[]{GlUtils.zero, GlUtils.zero, GlUtils.zero, GlUtils.zero});
                verifiedSrc.add(srcIDs[i]);
                verifiedSrc.add(srcIDs[j]);
                continue block0;
            }
        }
        return verifyCnt;
    }

    @Override
    protected void _deleteAcctCussHistory(Context ctx, String asstID) throws BOSException {
        String sql = "delete from T_GL_AcctCussentHistory where FVoucherAsstIDID=? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{asstID});
    }

    @Override
    protected void _restoreData(Context ctx, Date startDate, Date stopDate) throws BOSException {
        this._restoreData(ctx, startDate, stopDate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreData(Context ctx, String accountId) throws BOSException {
        int rowLength = this.length;
        int coluLength = 19;
        if (rowLength == 0) {
            return;
        }
        String[][] assist_cussent_Table = new String[rowLength][coluLength];
        if ((assist_cussent_Table = this.getAssistTable(ctx, assist_cussent_Table, accountId)) == null) {
            return;
        }
        for (int i = 0; i < rowLength - 1; ++i) {
            for (int j = i + 1; j < rowLength && assist_cussent_Table[i][0] != null && assist_cussent_Table[i][0].equals(assist_cussent_Table[j][0]); ++j) {
                if (assist_cussent_Table[i][1].equals(assist_cussent_Table[j][1])) {
                    if (assist_cussent_Table[i][2].compareTo(assist_cussent_Table[j][2]) >= 0) continue;
                    assist_cussent_Table[i][12] = new BigDecimal(assist_cussent_Table[i][12]).add(new BigDecimal(assist_cussent_Table[j][4])).toString();
                    assist_cussent_Table[i][13] = new BigDecimal(assist_cussent_Table[i][13]).add(new BigDecimal(assist_cussent_Table[j][5])).toString();
                    assist_cussent_Table[i][14] = new BigDecimal(assist_cussent_Table[i][14]).add(new BigDecimal(assist_cussent_Table[j][6])).toString();
                    assist_cussent_Table[i][15] = new BigDecimal(assist_cussent_Table[i][15]).add(new BigDecimal(assist_cussent_Table[j][7])).toString();
                    continue;
                }
                assist_cussent_Table[i][12] = new BigDecimal(assist_cussent_Table[i][12]).add(new BigDecimal(assist_cussent_Table[j][4])).toString();
                assist_cussent_Table[i][13] = new BigDecimal(assist_cussent_Table[i][13]).add(new BigDecimal(assist_cussent_Table[j][5])).toString();
                assist_cussent_Table[i][14] = new BigDecimal(assist_cussent_Table[i][14]).add(new BigDecimal(assist_cussent_Table[j][6])).toString();
                assist_cussent_Table[i][15] = new BigDecimal(assist_cussent_Table[i][15]).add(new BigDecimal(assist_cussent_Table[j][7])).toString();
            }
        }
        BigDecimal originalAmount = null;
        BigDecimal localAmount = null;
        BigDecimal reportingAmount = null;
        BigDecimal qty = null;
        BigDecimal unverifiedAmtFor = null;
        BigDecimal unverifiedAmtLocal = null;
        BigDecimal unverifiedAmtRpt = null;
        BigDecimal unverifiedAmtQty = null;
        Connection con = null;
        con = this.getConnection(ctx);
        StringBuffer sql = new StringBuffer();
        StringBuffer value = new StringBuffer();
        Counter counter = new Counter();
        sql.append(this.getInsertSQL());
        try {
            this.sqlInsert = con.prepareStatement(sql.toString());
        }
        catch (SQLException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        for (int i = 0; i < rowLength; ++i) {
            if (assist_cussent_Table[i][0] == null) continue;
            originalAmount = new BigDecimal(assist_cussent_Table[i][4]);
            localAmount = new BigDecimal(assist_cussent_Table[i][5]);
            reportingAmount = new BigDecimal(assist_cussent_Table[i][6]);
            qty = new BigDecimal(assist_cussent_Table[i][7]);
            unverifiedAmtFor = new BigDecimal(assist_cussent_Table[i][12]).add(new BigDecimal(assist_cussent_Table[i][8]));
            unverifiedAmtLocal = new BigDecimal(assist_cussent_Table[i][13]).add(new BigDecimal(assist_cussent_Table[i][9]));
            unverifiedAmtRpt = new BigDecimal(assist_cussent_Table[i][14]).add(new BigDecimal(assist_cussent_Table[i][10]));
            unverifiedAmtQty = new BigDecimal(assist_cussent_Table[i][15]).add(new BigDecimal(assist_cussent_Table[i][11]));
            Map amountGZMap = this.getUnverifiedAmt(ctx, assist_cussent_Table[i][0]);
            int Seq = 1;
            String fnumber = "001";
            Date verifyDate = new Date();
            amountGZMap.put("FNumber", fnumber);
            amountGZMap.put("FVerifyDate", verifyDate);
            amountGZMap.put("FSeq", new Integer(Seq++));
            try {
                boolean isExit = this.checkHistoryExit(ctx, assist_cussent_Table[i][3]);
                if (isExit) continue;
                GLVerifyTypeEnum type = GLVerifyTypeEnum.COMMON_VERIFY;
                if (originalAmount.signum() < 0) {
                    type = GLVerifyTypeEnum.NEGATIVE_VERIFY;
                }
                CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
                String[] strVeriVchIds = new String[]{assist_cussent_Table[i][16], assist_cussent_Table[i][17], assist_cussent_Table[i][18]};
                AcctCussentHistoryInfo acctCussentHistoryInfo = this.createAcctCussentHistoryInfo(ctx, amountGZMap, assist_cussent_Table[i][0], assist_cussent_Table[i][3], type, company, strVeriVchIds);
                acctCussentHistoryInfo.setOroginalAmount(originalAmount);
                acctCussentHistoryInfo.setLocalAmount(localAmount);
                acctCussentHistoryInfo.setReportAmount(reportingAmount);
                acctCussentHistoryInfo.setQty(qty);
                acctCussentHistoryInfo.setOriginalBalance(unverifiedAmtFor.subtract(originalAmount));
                acctCussentHistoryInfo.setLocalBalance(unverifiedAmtLocal.subtract(localAmount));
                acctCussentHistoryInfo.setReportBanlance(unverifiedAmtRpt.subtract(reportingAmount));
                acctCussentHistoryInfo.setQtyBalance(unverifiedAmtQty.subtract(qty));
                this.insertHistory(ctx, acctCussentHistoryInfo, type, this.sqlInsert, counter);
                if (counter.getValue() <= 0) continue;
                this.sqlInsert.executeBatch();
                this.sqlInsert.clearBatch();
                counter.clear();
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            finally {
                SQLUtils.cleanup((Statement)this.sqlInsert, (Connection)con);
            }
        }
    }

    private Map getAccountList(Context ctx, String companyID) {
        HashMap<String, Integer> accountList = new HashMap<String, Integer>();
        StringBuffer countSql = new StringBuffer();
        countSql.append("select account.FID as accountID,count(assist.fid) as length");
        countSql.append(" \r\n from");
        countSql.append(" \r\n T_BD_AccountView account");
        countSql.append("\r\n inner join T_GL_VoucherEntry  ve on ve.faccountid = account.fid\r\n inner join t_gl_voucherAssistRecord  assist on assist.fentryid = ve.fid\r\n inner join t_gl_voucher v on v.fid = ve.fbillid and assist.fbillid = v.fid ");
        countSql.append(" \r\n where ");
        if (companyID != null) {
            countSql.append(" \r\n  account.fcompanyid ='").append(companyID).append("' and v.fcompanyid = '").append(companyID).append("' and ");
        }
        countSql.append(" \r\n  account.FAC =1 and v.FBizstatus<>0 and v.FBizstatus<>2  and ve.FIsVerify = 1 and assist.FverifiedCussentID is not null ");
        countSql.append("\r\n group by account.fid");
        try {
            IRowSet countRowSet = DbUtil.executeQuery((Context)ctx, (String)new String(countSql));
            try {
                while (countRowSet.next()) {
                    accountList.put(countRowSet.getString("accountID"), new Integer(countRowSet.getInt("length")));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        return accountList;
    }

    private boolean checkHistoryExit(Context ctx, String assistID) throws BOSException {
        boolean isExit = false;
        StringBuffer sql = new StringBuffer();
        sql.append("select Fvoucherasstidid from");
        sql.append(" \r\n T_gl_Acctcussenthistory ");
        sql.append(" \r\n where Fvoucherasstidid= ?");
        Object[] params = new Object[]{assistID};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)new String(sql), (Object[])params);
        try {
            isExit = rowSet.next();
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return isExit;
    }

    private String[][] getAssistTable(Context ctx, String[][] assistTable, String accountId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select verifiedCussentID,BookedDate ,fnumber,assistid,OriginalAmount,LocalAmount,ReportingAmount,Quantity,FUnverifiedAmtFor,FUnverifiedAmtLocal,FUnverifiedAmtRpt,FUnverifiedQty,FVeriVchID,FVeriEntryID,FVeriPeriod from");
        sql.append("\r\n ( ");
        sql.append("select verifiedCussentID,BookedDate ,fnumber,assistid,OriginalAmount,LocalAmount,ReportingAmount,Quantity,FUnverifiedAmtFor,FUnverifiedAmtLocal,FUnverifiedAmtRpt,FUnverifiedQty,FVeriVchID,FVeriEntryID,FVeriPeriod from");
        sql.append("\r\n ( ");
        sql.append("\r\n select assist.FverifiedCussentID as verifiedCussentID,assist.FID as assistid,voucher.Fnumber as fnumber,");
        sql.append("\r\n voucher.FBookedDate as BookedDate, assist.FOriginalAmount as OriginalAmount ,");
        sql.append("\r\n assist.FLocalAmount as LocalAmount , assist.FReportingAmount as ReportingAmount, ");
        sql.append("\r\n assist.FQuantity as Quantity ");
        sql.append("\r\n ,assist.FBillID as FVeriVchID, assist.FEntryID as FVeriEntryID");
        sql.append("\r\n ,prd.FNumber FVeriPeriod");
        sql.append(" \r\n from");
        sql.append(" \r\n t_gl_voucherAssistRecord assist");
        sql.append(" \r\n join t_gl_voucher voucher on  assist.FBillID=voucher.FID");
        sql.append(" \r\n join T_GL_VoucherEntry entry on  assist.FEntryID=entry.FID");
        sql.append(" \r\n join T_BD_Period prd on  prd.FID=voucher.FPeriodID");
        sql.append(" \r\n where ");
        sql.append(" \r\n  assist.FverifiedCussentID is not null");
        sql.append(" \r\n  and voucher.FBizstatus=5");
        sql.append(" \r\n  and entry.FAccountID=?");
        sql.append(" \r\n  and entry.FIsVerify=1");
        sql.append(" \r\n  )t ");
        sql.append(" \r\n   inner join  ");
        sql.append(" \r\n  (select FID, FUnverifiedAmtFor,FUnverifiedAmtLocal,FUnverifiedAmtRpt,FUnverifiedQty from T_GL_AcctCussent) b");
        sql.append(" \r\n  on t.verifiedCussentID=b.FID");
        sql.append(" \r\n   ) as temp");
        sql.append("\r\n union all ");
        sql.append("\r\n (select verifiedCussentID,BookedDate ,fnumber,assistid,OriginalAmount,LocalAmount,ReportingAmount,Quantity,FUnHoldedAmtFor as FUnverifiedAmtFor,FUnHoldedAmtLocal as FUnverifiedAmtLocal,FUnHoldedAmtRpt as FUnverifiedAmtRpt,FUnHoldedQty as FUnverifiedQty,FVeriVchID,FVeriEntryID,FVeriPeriod from");
        sql.append("\r\n ( ");
        sql.append("\r\n select assist.FverifiedCussentID as verifiedCussentID,assist.FID as assistid,voucher.Fnumber as fnumber,");
        sql.append("\r\n voucher.FBookedDate as BookedDate, assist.FOriginalAmount as OriginalAmount ,");
        sql.append("\r\n assist.FLocalAmount as LocalAmount , assist.FReportingAmount as ReportingAmount, ");
        sql.append("\r\n assist.FQuantity as Quantity ");
        sql.append("\r\n ,assist.FBillID as FVeriVchID, assist.FEntryID as FVeriEntryID");
        sql.append("\r\n ,prd.FNumber FVeriPeriod");
        sql.append(" \r\n from");
        sql.append(" \r\n t_gl_voucherAssistRecord assist");
        sql.append(" \r\n join t_gl_voucher voucher on  assist.FBillID=voucher.FID");
        sql.append(" \r\n join T_GL_VoucherEntry entry on  assist.FEntryID=entry.FID");
        sql.append(" \r\n join T_BD_Period prd on  prd.FID=voucher.FPeriodID");
        sql.append(" \r\n where ");
        sql.append(" \r\n  assist.FverifiedCussentID is not null");
        sql.append(" \r\n  and voucher.FBizstatus<>0 and voucher.FBizstatus<>5 and voucher.FBizstatus<>2");
        sql.append(" \r\n  and entry.FAccountID=?");
        sql.append(" \r\n  and entry.FIsVerify=1");
        sql.append(" \r\n  )t ");
        sql.append(" \r\n   inner join  ");
        sql.append(" \r\n  (select FID, FUnHoldedAmtFor,FUnHoldedAmtLocal,FUnHoldedAmtRpt,FUnHoldedQty from T_GL_AcctCussent) b");
        sql.append(" \r\n  on t.verifiedCussentID=b.FID");
        sql.append(" \r\n  )");
        Object[] params = new Object[]{accountId, accountId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)new String(sql), (Object[])params);
        try {
            int i = 0;
            while (rowSet.next()) {
                assistTable[i][0] = rowSet.getString("verifiedCussentID");
                assistTable[i][1] = rowSet.getString("BookedDate");
                assistTable[i][2] = rowSet.getString("fnumber");
                assistTable[i][3] = rowSet.getString("assistid");
                assistTable[i][4] = rowSet.getString("OriginalAmount");
                assistTable[i][5] = rowSet.getString("LocalAmount");
                assistTable[i][6] = rowSet.getString("ReportingAmount");
                assistTable[i][7] = rowSet.getString("Quantity");
                assistTable[i][8] = rowSet.getString("FUnverifiedAmtFor");
                assistTable[i][9] = rowSet.getString("FUnverifiedAmtLocal");
                assistTable[i][10] = rowSet.getString("FUnverifiedAmtRpt");
                assistTable[i][11] = rowSet.getString("FUnverifiedQty");
                assistTable[i][12] = assistTable[i][4];
                assistTable[i][13] = assistTable[i][5];
                assistTable[i][14] = assistTable[i][6];
                assistTable[i][15] = assistTable[i][7];
                assistTable[i][16] = rowSet.getString("FVeriVchID");
                assistTable[i][17] = rowSet.getString("FVeriEntryID");
                assistTable[i][18] = rowSet.getString("FVeriPeriod");
                ++i;
            }
            if (i == 0) {
                assistTable = null;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return assistTable;
    }

    @Override
    protected void _restoreData(Context ctx, String accountID) throws BOSException {
        this.restoreData(ctx, accountID);
    }

    @Override
    protected void _restoreData(Context ctx, Date startDate, Date stopDate, String companyID) throws BOSException {
        Map accountList = new HashMap();
        accountList = this.getAccountList(ctx, companyID);
        Iterator it = accountList.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String accountId = (String)it.next();
            this.length = (Integer)accountList.get(accountId);
            this._restoreData(ctx, accountId);
            ++i;
        }
    }

    @Override
    protected void _changeVerifyMode(Context ctx, String companyID, int fromModel, int toModel, PeriodInfo startPeriod, PeriodInfo currentPeriod) throws BOSException, EASBizException {
        if (fromModel == 0 && (toModel == 1 || toModel == 2)) {
            IAcctCussentHistory factory = AcctCussentHistoryFactory.getLocalInstance(ctx);
            Date startDate = null;
            Date stopDate = null;
            factory.restoreData(startDate, stopDate, companyID);
            IRowSet rs = null;
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1 1 from t_gl_voucher v\n inner join t_gl_voucherentry ve on ve.fbillid = v.fid");
            sql.append("\r\ninner join t_bd_accountview av on ve.faccountid = av.fid");
            sql.append("\r\nwhere av.fac = 1 and av.fcompanyid = ? and ve.FIsVerify = 0 and v.fbizstatus <>5 and v.fbizstatus <>2 ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
            try {
                if (rs.next()) {
                    throw new EASBizException(new NumericExceptionSubItem("9991", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"888_AcctCussentHistoryControllerBean", (Locale)ctx.getLocale())));
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage());
            }
            sql.setLength(0);
            sql.append("select top 1 1 from t_gl_voucher v\n inner join t_gl_voucherentry ve on ve.fbillid = v.fid");
            sql.append("\r\ninner join t_bd_accountview av on ve.faccountid = av.fid");
            sql.append("\r\nwhere av.fac = 1 and av.fcompanyid = ? and ve.FIsVerify = 1 and v.fbizstatus <>5 and v.fbizstatus <>2 ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
            try {
                if (rs.next()) {
                    throw new EASBizException(new NumericExceptionSubItem("9991", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"890_AcctCussentHistoryControllerBean", (Locale)ctx.getLocale())));
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage());
            }
            sql.setLength(0);
            sql.append(" update   t_GL_AcctCussent as ac set  (FUnHoldedAmtFor,FUnHoldedAmtLocal,FUnHoldedAmtRpt,FUnHoldedQty)=(select  foriginalamount,flocalamount, freportingamount,fquantity from t_gl_voucherassistrecord va where ac.fcompanyid = ? and va.fid=ac.FVchAssistRecordID )  \r\n");
            sql.append(" where ac.fcompanyid=?                                                                \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, companyID});
            sql.setLength(0);
            sql.append(" update   t_GL_AcctCussentHistory set  fdc = 0 where fdc = 4  and FOroginalAmount > 0 and fcompanyid = ?");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
            sql.setLength(0);
            sql.append(" update   t_GL_AcctCussentHistory set  fdc = 2 where fdc = 4  and FOroginalAmount < 0 and fcompanyid = ?");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
            sql.setLength(0);
            sql.append("update t_gl_voucherassistrecord as vast set FIsVierified = 1 where exists (select ve.fid from t_gl_voucherentry ve inner join t_bd_accountview av on ve.faccountid = av.fid and av.fac = 1 inner join T_GL_VOUCHER vch on vch.fid = ve.fbillid where ve.fisverify = 1 -- Verify Voucher\r\nand av.fcompanyid = ? and ve.fid = vast.fentryid and vch.fbizstatus <>2)");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
            sql.setLength(0);
            sql.setLength(0);
            sql.append("update t_gl_acctcussent cuss set FIsVierified = 1 where exists (select ve.fid from t_gl_voucherentry ve inner join t_bd_accountview av on ve.faccountid = av.fid and av.fac = 1 inner join T_GL_VOUCHER vch on vch.fid = ve.fbillid where ve.fisverify = 1-- Verify Voucher\r\n and av.fcompanyid = ? and ve.fid = cuss.fentryid and vch.fbizstatus <>2)");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
            sql.setLength(0);
        } else if (toModel == 0 && (fromModel == 1 || fromModel == 2)) {
            IRowSet rs = null;
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1 1 from t_gl_voucher v ");
            sql.append("\r\n where v.fcompanyid = ? and v.fbizstatus <>5 and v.fbizstatus <>2 ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
            try {
                if (rs.next()) {
                    throw new EASBizException(new NumericExceptionSubItem("9991", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"899_AcctCussentHistoryControllerBean", (Locale)ctx.getLocale())));
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            PeriodInfo acPeriodInfo = null;
            if (startPeriod != null && currentPeriod != null) {
                acPeriodInfo = GLAcctAgeNewUtils.getAcPeriodInfo(ctx, companyID);
            }
            sql.setLength(0);
            sql.append("select top 1 1 from t_gl_voucher v\n inner join t_gl_voucherentry ve on ve.fbillid = v.fid");
            sql.append("\r\n inner join t_gl_voucherassistrecord vss on vss.fentryid = ve.fid ");
            sql.append("\r\n inner join t_bd_accountview av on ve.faccountid = av.fid");
            if (acPeriodInfo != null) {
                sql.append("\r\n inner join t_bd_period bp on v.FPeriodID = bp.fid");
            }
            sql.append("\r\n where av.fac = 1 and v.fbizstatus <>2 and av.fcompanyid = ? and ve.FIsVerify = 1 and  vss.FIsVierified=0  ");
            if (acPeriodInfo != null) {
                sql.append(" and bp.fnumber >= ?");
            }
            Object[] params = null;
            params = acPeriodInfo != null ? new Object[]{companyID, acPeriodInfo.getNumber()} : new Object[]{companyID};
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            try {
                if (rs.next()) {
                    throw new EASBizException(new NumericExceptionSubItem("9991", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"892_AcctCussentHistoryControllerBean", (Locale)ctx.getLocale())));
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            sql.setLength(0);
            sql.append("select 1 from t_gl_acctverify accv");
            if (acPeriodInfo != null) {
                sql.append("\r\n inner join t_bd_period bp on accv.FPeriodID = bp.fid");
            }
            sql.append("\r\n inner join t_gl_voucherassistrecord vss on vss.fid = accv.fvchassistrecordid ");
            sql.append("\r\n where accv.fcompanyid=? and accv.funverifiedamtfor<>0");
            if (acPeriodInfo != null) {
                sql.append(" and bp.fnumber >= ?");
            }
            params = acPeriodInfo != null ? new Object[]{companyID, acPeriodInfo.getNumber()} : new Object[]{companyID};
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            try {
                if (rs.next()) {
                    throw new EASBizException(new NumericExceptionSubItem("9991", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"892_AcctCussentHistoryControllerBean", (Locale)ctx.getLocale())));
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            sql.setLength(0);
            sql.append("SELECT 1 FROM T_GL_ACCTCUSSENTHISTORY where FCOMPANYID = ? group by FVOUCHERASSTIDID having count(FVOUCHERASSTIDID)>1");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
            try {
                if (rs.next()) {
                    throw new EASBizException(new NumericExceptionSubItem("9991", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"893-1_AcctCussentHistoryControllerBean", (Locale)ctx.getLocale())));
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            sql.setLength(0);
            sql.append(" update   t_GL_AcctCussent set  FUnHoldedAmtFor=FUnVerifiedAmtFor,FUnHoldedAmtLocal=FUnVerifiedAmtLocal,FUnHoldedAmtRpt=FUnVerifiedAmtRpt,FUnHoldedQty=FUnVerifiedQty ");
            sql.append(" where fcompanyid=?                                                                \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
            sql.setLength(0);
            sql.append(" update t_GL_voucherassistrecord vast set  FVerifiedCussentID = null");
            sql.append(" where vast.FISVIERIFIED = 0 and vast.FCOMPANYID = ? ");
            sql.append(" and vast.FACCOUNTID in (select av.fid from t_bd_accountview av where av.fac = 1 and av.fcompanyid = ?)");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, companyID});
        } else if (toModel == 1 && fromModel == 2) {
            IRowSet rs = null;
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1 1 from t_gl_voucher v\n inner join t_gl_voucherentry ve on ve.fbillid = v.fid");
            sql.append("\r\n inner join t_bd_accountview av on ve.faccountid = av.fid");
            sql.append("\r\n where av.fac = 1 and av.fcompanyid = ? and ve.FIsVerify = 0 and v.fbizstatus <>5 and v.fbizstatus <>2 ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
            try {
                if (rs.next()) {
                    throw new EASBizException(new NumericExceptionSubItem("9991", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"893_AcctCussentHistoryControllerBean", (Locale)ctx.getLocale())));
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private StringBuffer transSortSelfDefineToSQL(EntityViewInfo mainQuery, String loc, boolean isSrc) {
        StringBuffer orderby = new StringBuffer();
        String strOrder = "";
        if (mainQuery == null) {
            return orderby;
        }
        strOrder = mainQuery.toString();
        if (strOrder.toUpperCase().indexOf("ORDER BY") == -1) {
            return orderby;
        }
        int whereIndex = strOrder.toUpperCase().indexOf("WHERE");
        if (whereIndex > -1) {
            int orderIndex = strOrder.toUpperCase().indexOf("ORDER BY");
            strOrder = strOrder.substring(orderIndex, strOrder.length());
        }
        if (strOrder.indexOf("VARBizDate") != -1) {
            strOrder = strOrder.replaceAll("VARBizDate", "FBizDate");
        }
        if (strOrder.indexOf("endDate") != -1) {
            strOrder = strOrder.replaceAll("endDate", "FBookedDate");
        }
        if (strOrder.indexOf("bizNumber") != -1) {
            strOrder = strOrder.replaceAll("bizNumber", "fbizNumber");
        }
        if (strOrder.indexOf("originalAmount") != -1) {
            strOrder = strOrder.replaceAll("originalAmount", "foriginalAmount");
        }
        if (strOrder.indexOf("unVerifiedAmtFor") != -1) {
            if (isSrc) {
                strOrder = strOrder.replaceAll("unVerifiedAmtFor", "FUnverifiedAmtFor");
            } else {
                if (strOrder.indexOf("unVerifiedAmtFor ASC") != -1) {
                    strOrder = strOrder.replaceAll("unVerifiedAmtFor ASC,", "");
                }
                if (strOrder.indexOf("unVerifiedAmtFor DESC") != -1) {
                    strOrder = strOrder.replaceAll("unVerifiedAmtFor DESC,", "");
                }
                if (strOrder.indexOf("unVerifiedAmtFor ASC") != -1) {
                    strOrder = strOrder.replaceAll("unVerifiedAmtFor ASC", "");
                }
                if (strOrder.indexOf("unVerifiedAmtFor DESC") != -1) {
                    strOrder = strOrder.replaceAll("unVerifiedAmtFor DESC", "");
                }
            }
        }
        if (strOrder.indexOf("voucherType.name") != -1) {
            strOrder = strOrder.replaceAll("voucherType.name", "FvoucherType");
        }
        if (strOrder.indexOf("voucher.number") != -1) {
            strOrder = strOrder.replaceAll("voucher.number", "FNumber");
        }
        if ((strOrder = strOrder.trim()).endsWith(",")) {
            strOrder = strOrder.substring(0, strOrder.length() - 1);
        }
        if (!(strOrder = strOrder.trim()).equalsIgnoreCase("order by")) {
            orderby.append(strOrder).append("  \r\n");
        }
        return orderby;
    }

    protected Map<String, String> getInitFieldMap(String loc) {
        HashMap<String, String> initFieldMap = new HashMap<String, String>();
        initFieldMap.put("period.number", "p.fnumber");
        initFieldMap.put("entrydc", "a.FENTRYDC");
        initFieldMap.put("VARBizDate", "a.FVARBIZDATE");
        initFieldMap.put("endDate", "a.FENDDATE");
        initFieldMap.put("bizNumber", "a.FBizNumber");
        initFieldMap.put("description", "a.FDescription");
        initFieldMap.put("voucherType.name", "a.FVOUCHERTYPEID");
        initFieldMap.put("voucher.number", "a.FVCHNUMBER");
        return initFieldMap;
    }

    protected Map<String, String> getAcctFieldMap(String loc) {
        HashMap<String, String> acctFieldMap = new HashMap<String, String>();
        acctFieldMap.put("period.number", "p.fnumber");
        acctFieldMap.put("entrydc", "a.FENTRYDC");
        acctFieldMap.put("VARBizDate", "a.FVARBIZDATE");
        acctFieldMap.put("endDate", "a.FENDDATE");
        acctFieldMap.put("bizNumber", "a.FBizNumber");
        acctFieldMap.put("description", "a.FDescription");
        acctFieldMap.put("voucherType.name", "vts.fname_" + loc);
        acctFieldMap.put("voucher.number", "d.FNUMBER");
        return acctFieldMap;
    }

    protected Map<String, String> getVerifyFieldMap(String loc) {
        HashMap<String, String> verifyFieldMap = new HashMap<String, String>();
        verifyFieldMap.put("period.number", "p.fnumber");
        verifyFieldMap.put("entrydc", "c.FENTRYDC");
        verifyFieldMap.put("VARBizDate", "c.FVARBIZDATE");
        verifyFieldMap.put("endDate", "c.FENDDATE");
        verifyFieldMap.put("bizNumber", "c.FBizNumber");
        verifyFieldMap.put("description", "c.FDescription");
        verifyFieldMap.put("voucherType.name", "vts.fname_" + loc);
        verifyFieldMap.put("voucher.number", "c.FVCHNUMBER");
        return verifyFieldMap;
    }

    private StringBuffer transFilterSelfDefineToSQL(EntityViewInfo mainQuery, String loc, AcctDataType acctDataType) {
        StringBuffer filter = new StringBuffer();
        if (mainQuery == null) {
            return filter;
        }
        FilterInfo filterInfo = mainQuery.getFilter();
        if (filterInfo.getFilterItems().size() <= 0) {
            return filter;
        }
        try {
            filterInfo = new FilterInfo(filterInfo.toSql());
        }
        catch (ParserException e) {
            logger.error((Object)"parser selfFilter sql exception.", (Throwable)e);
            return filter;
        }
        Map<String, String> fieldMap = null;
        if (acctDataType == AcctDataType.INIT) {
            fieldMap = this.getInitFieldMap(loc);
        } else if (acctDataType == AcctDataType.ACCTCUSSENT) {
            fieldMap = this.getAcctFieldMap(loc);
        } else if (acctDataType == AcctDataType.ACCTVERIFY) {
            fieldMap = this.getVerifyFieldMap(loc);
        } else {
            return filter;
        }
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        for (int i = 0; i < filterItems.size(); ++i) {
            FilterItemInfo filterItemInfo = filterItems.get(i);
            String propertyName = filterItemInfo.getPropertyName();
            String filterFieldName = fieldMap.get(propertyName);
            if (StringUtils.isEmpty((String)filterFieldName)) continue;
            if ("period.number".equalsIgnoreCase(propertyName) && filterItemInfo.getCompareValue() instanceof Integer) {
                this.dealPeriodNumber(filterItemInfo);
            }
            filterItemInfo.setPropertyName(filterFieldName);
        }
        filter.append(filterInfo.toString().trim());
        return filter;
    }

    private void dealPeriodNumber(FilterItemInfo filterItemInfo) {
        String periodNumber = String.valueOf(filterItemInfo.getCompareValue());
        if (periodNumber.length() == 5) {
            periodNumber = periodNumber.substring(0, 4) + "0" + periodNumber.charAt(4);
            filterItemInfo.setCompareValue((Object)Integer.valueOf(periodNumber));
        }
    }

    @Override
    protected void _sameVerify(Context ctx, Map pair, Map dateMap, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        this.sameVerifyByCompany(ctx, pair, dateMap, company);
    }

    private String initIdsTmpTable(Context ctx, List<String> ids) {
        String tableName = null;
        return tableName;
    }

    private void initVerifyData(Context ctx, List<String> ids, List positiveCuss, List negativeCuss) throws BOSException {
        HashMap<String, Map> positiveCussMap = new HashMap<String, Map>();
        HashMap<String, Map> negativeCussMap = new HashMap<String, Map>();
        this.initVerifyData(ctx, ids, positiveCussMap, negativeCussMap, null);
        this.setPositAndNegatList(ids, positiveCuss, negativeCuss, positiveCussMap, negativeCussMap);
    }

    private void initVerifyData(Context ctx, List<String> ids, Map<String, Map> positiveCussMap, Map<String, Map> negativeCussMap, String tableName) throws BOSException {
        StringBuffer sql = this.getSelectSql();
        StringBuffer where = new StringBuffer();
        if (tableName != null) {
            where.append("where a.fid in(select id from ").append(tableName).append(")");
        } else {
            where.append("where a.fid in(");
            for (String id : ids) {
                where.append("?,");
            }
            where.deleteCharAt(where.lastIndexOf(","));
            where.append(")");
        }
        sql.append(where);
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])ids.toArray());
        try {
            BigDecimal omt = null;
            while (rowset.next()) {
                HashMap<String, Object> amountMap = new HashMap<String, Object>();
                int index = 1;
                amountMap.put("FId", rowset.getString(index++));
                amountMap.put("FUnverifiedAmtFor", rowset.getBigDecimal(index++));
                amountMap.put("FUnverifiedAmtLocal", rowset.getBigDecimal(index++));
                amountMap.put("FUnverifiedAmtRpt", rowset.getBigDecimal(index++));
                amountMap.put("FUnverifiedQty", rowset.getBigDecimal(index++));
                amountMap.put("FCompanyID", rowset.getString(index++));
                amountMap.put("FAccountID", rowset.getString(index++));
                amountMap.put("FCurrencyID", rowset.getString(index++));
                amountMap.put("FAssGrpID", rowset.getString(index++));
                amountMap.put("FBizDate", rowset.getDate(index++));
                amountMap.put("FDescription", rowset.getString(index++));
                amountMap.put("FBizNumber", rowset.getString(index++));
                amountMap.put("FVchNumber", rowset.getString(index++));
                amountMap.put("FBookedDate", rowset.getDate(index++));
                amountMap.put("FOriginalAmount", rowset.getBigDecimal(index++));
                amountMap.put("FLocalAmount", rowset.getBigDecimal(index++));
                amountMap.put("FReportingAmount", rowset.getBigDecimal(index++));
                amountMap.put("FQuantity", rowset.getBigDecimal(index++));
                amountMap.put("FCussVchID", rowset.getString(index++));
                amountMap.put("FCussEntryID", rowset.getString(index++));
                amountMap.put("FPeriodNumber", new Integer(rowset.getInt(index++)));
                omt = (BigDecimal)amountMap.get("FOriginalAmount");
                if (GlUtils.zero.compareTo(omt) <= 0) {
                    positiveCussMap.put(amountMap.get("FId").toString(), amountMap);
                    continue;
                }
                negativeCussMap.put(amountMap.get("FId").toString(), amountMap);
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
    }

    private StringBuffer getSelectSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fid FId, a.FUnverifiedAmtFor,a.FUnverifiedAmtLocal,a.FUnverifiedAmtRpt,a.FUnverifiedQty ,\r\n");
        sql.append("\ta.fcompanyid,a.faccountid,a.fcurrencyid,a.fassgrpid, a.FVarBizDate FBizdate,a.Fdescription,a.fbizNumber, \r\n");
        sql.append("\ta.FVchNumber FVchNumber, a.fbookeddate, a.FOriginalAmount,a.FLocalAmount,a.FReportingAmount,a.FQuantity,\r\n");
        sql.append("    a.fvoucherid fcussvchid,a.FEntryID fcussentryid, isnull(pd.fnumber,0) FPeriodNumber \r\n");
        sql.append("from T_GL_AcctCussent a             \r\n");
        sql.append("left join t_bd_period pd on pd.fid = a.fperiodid \r\n");
        return sql;
    }

    @Override
    protected void _insertHistory(Context ctx, Map verifyRel, String vchID, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        Map<String, Map> actData = this.getActDataMap(ctx, vchID);
        Iterator it = verifyRel.keySet().iterator();
        String cusId = null;
        String verId = null;
        Connection con = null;
        Counter counter = new Counter();
        Date verifyDate = new Date();
        String number = this.getAcctcussentHistoryNumber(ctx, verifyDate, company);
        int seq = 0;
        try {
            con = this.getConnection(ctx);
            this.sqlInsert = con.prepareStatement(this.getInsertSQL());
            while (it.hasNext()) {
                cusId = (String)it.next();
                verId = (String)verifyRel.get(cusId);
                if (!actData.containsKey(cusId)) continue;
                Map cusMap = actData.get(cusId);
                Map verMap = actData.get(verId);
                cusMap.put("FNumber", number);
                cusMap.put("FVerifyDate", verifyDate);
                cusMap.put("FSeq", new Integer(seq++));
                verMap.put("FNumber", number);
                verMap.put("FVerifyDate", verifyDate);
                verMap.put("FSeq", new Integer(seq++));
                cusId = (String)cusMap.get("FID");
                verId = (String)verMap.get("FID");
                AcctCussentHistoryInfo historyInfoAct = this.createAcctCussentHistoryInfo(ctx, cusMap, cusId, verId, GLVerifyTypeEnum.SAME_VERIFY, company, verMap);
                BigDecimal omt = (BigDecimal)cusMap.get("FOriginalAmount");
                BigDecimal lmt = (BigDecimal)cusMap.get("FLocalAmount");
                BigDecimal rmt = (BigDecimal)cusMap.get("FReportingAmount");
                BigDecimal qty = (BigDecimal)cusMap.get("FQuantity");
                historyInfoAct.setOroginalAmount(omt);
                historyInfoAct.setOriginalBalance(GlUtils.zero);
                historyInfoAct.setLocalAmount(lmt);
                historyInfoAct.setLocalBalance(GlUtils.zero);
                historyInfoAct.setReportAmount(rmt);
                historyInfoAct.setReportBanlance(GlUtils.zero);
                historyInfoAct.setQty(qty);
                historyInfoAct.setQtyBalance(GlUtils.zero);
                this.insertHistory(ctx, historyInfoAct, GLVerifyTypeEnum.SAME_VERIFY, this.sqlInsert, counter);
                AcctCussentHistoryInfo historyInfoVer = this.createAcctCussentHistoryInfo(ctx, verMap, verId, cusId, GLVerifyTypeEnum.SAME_VERIFY, company, cusMap);
                omt = (BigDecimal)verMap.get("FOriginalAmount");
                lmt = (BigDecimal)verMap.get("FLocalAmount");
                rmt = (BigDecimal)verMap.get("FReportingAmount");
                qty = (BigDecimal)verMap.get("FQuantity");
                historyInfoVer.setOroginalAmount(omt);
                historyInfoVer.setOriginalBalance(GlUtils.zero);
                historyInfoVer.setLocalAmount(lmt);
                historyInfoVer.setLocalBalance(GlUtils.zero);
                historyInfoVer.setReportAmount(rmt);
                historyInfoVer.setReportBanlance(GlUtils.zero);
                historyInfoVer.setQty(qty);
                historyInfoVer.setQtyBalance(GlUtils.zero);
                this.insertHistory(ctx, historyInfoVer, GLVerifyTypeEnum.SAME_VERIFY, this.sqlInsert, counter);
                if (counter.getValue() <= 0) continue;
                this.sqlInsert.executeBatch();
                this.sqlInsert.clearBatch();
                counter.clear();
            }
        }
        catch (Throwable e) {
            logger.error((Object)e);
            throw new BOSException(e);
        }
    }

    private Map<String, Map> getActDataMap(Context ctx, String vchID) throws BOSException {
        String sql = "select a.FUnverifiedAmtFor,a.FUnverifiedAmtLocal,a.FUnverifiedAmtRpt,a.FUnverifiedQty ,\r\n\ta.fcompanyid,a.faccountid,a.fcurrencyid,a.fassgrpid,\r\n\ta.FVarBizDate FBizdate,a.Fdescription,a.fbizNumber,\r\n\ta.FVchNumber FVchNumber,a.fbookeddate,\r\n a.FOriginalAmount,a.FLocalAmount,a.FReportingAmount,a.FQuantity,\r\n a.fvoucherid fcussvchid,a.FEntryID fcussentryid,  \r\n\tisnull(pd.fnumber,0) FPeriodNumber, a.fid, a.fvchassistrecordid Fvsstid  \r\n\tfrom T_GL_AcctCussent a             \r\n left join t_bd_period pd on pd.fid = a.fperiodid \r\n\twhere a.fvoucherid = ? \r\n";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{vchID});
        HashMap<String, Map> result = new HashMap<String, Map>();
        try {
            while (rowset.next()) {
                int index = 1;
                HashMap<String, Object> amountMap = new HashMap<String, Object>();
                amountMap.put("FUnverifiedAmtFor", rowset.getBigDecimal(index++));
                amountMap.put("FUnverifiedAmtLocal", rowset.getBigDecimal(index++));
                amountMap.put("FUnverifiedAmtRpt", rowset.getBigDecimal(index++));
                amountMap.put("FUnverifiedQty", rowset.getBigDecimal(index++));
                amountMap.put("FCompanyID", rowset.getString(index++));
                amountMap.put("FAccountID", rowset.getString(index++));
                amountMap.put("FCurrencyID", rowset.getString(index++));
                amountMap.put("FAssGrpID", rowset.getString(index++));
                amountMap.put("FBizDate", rowset.getDate(index++));
                amountMap.put("FDescription", rowset.getString(index++));
                amountMap.put("FBizNumber", rowset.getString(index++));
                amountMap.put("FVchNumber", rowset.getString(index++));
                amountMap.put("FBookedDate", rowset.getDate(index++));
                amountMap.put("FOriginalAmount", rowset.getBigDecimal(index++));
                amountMap.put("FLocalAmount", rowset.getBigDecimal(index++));
                amountMap.put("FReportingAmount", rowset.getBigDecimal(index++));
                amountMap.put("FQuantity", rowset.getBigDecimal(index++));
                amountMap.put("FCussVchID", rowset.getString(index++));
                amountMap.put("FCussEntryID", rowset.getString(index++));
                amountMap.put("FPeriodNumber", new Integer(rowset.getInt(index++)));
                amountMap.put("FID", rowset.getString(index++));
                String vsstid = rowset.getString("Fvsstid");
                result.put(vsstid, amountMap);
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        return result;
    }

    public static enum AcctDataType {
        INIT,
        ACCTCUSSENT,
        ACCTVERIFY;

    }

    static class Counter {
        private int counter = 0;

        Counter() {
        }

        public void add() {
            ++this.counter;
        }

        public void clear() {
            this.counter = 0;
        }

        public int getValue() {
            return this.counter;
        }
    }
}

