/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeCollection;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeFactory;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentCancelResult;
import com.kingdee.eas.fi.gl.AcctCussentHistoryCollection;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFactory;
import com.kingdee.eas.fi.gl.AcctCussentHistoryInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordFactory;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.AbstractAcctCussentHistoryFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.AcctCussentVerifyService;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.app.PsSql;
import com.kingdee.eas.fi.gl.app.voucher.AutoVerifyService;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctCussentHistoryFacadeControllerBean
extends AbstractAcctCussentHistoryFacadeControllerBean {
    private static final long serialVersionUID = 1493642080659009560L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.AcctCussentHistoryFacadeControllerBean");
    private String UP_TABLE = "upTable";
    private String resource = "com.kingdee.eas.fi.gl.GLRes";
    private static final String REPAIR_INITDATA = "repairInitData";
    private static final String REPLENISH_ACCTDATA = "replenishAcctData";
    private static final String sqlInChar = "#sql_in";
    private static final String bosType = "CE2D850A";
    private static final int limitNum = 1000;
    private static String sourceUrl = "com.kingdee.eas.fi.gl.GLResource";
    private boolean dealByGroup = false;
    private int org_limit = 10;

    @Override
    protected IObjectCollection _getUnverfyCollection(Context ctx, String voucherId, IObjectCollection asstAttrTypes) throws BOSException {
        try {
            AcctCussentHistoryCollection histories = this.getHistories(ctx, voucherId);
            if (histories.size() == 0) {
                return new VoucherAssistRecordCollection();
            }
            HashSet<String> assistIdSet = new HashSet<String>();
            HashMap assistHistoryInfoMap = new HashMap();
            for (int i = 0; i < histories.size(); ++i) {
                AcctCussentHistoryInfo history = histories.get(i);
                ArrayList<AcctCussentHistoryInfo> historyList = new ArrayList<AcctCussentHistoryInfo>();
                if (history.getDc().getValue() != 1 && history.getVoucherAsstID() != null) {
                    String assistId = history.getVoucherAsstID().getId().toString();
                    assistIdSet.add(assistId);
                    historyList = assistHistoryInfoMap.containsKey(assistId) ? (List)assistHistoryInfoMap.get(assistId) : new ArrayList();
                    historyList.add(history);
                    assistHistoryInfoMap.put(assistId, historyList);
                }
                if (history.getDc().getValue() == 3 || history.getCussentid() == null) continue;
                String cussentAssistId = history.getCussentid().getVchAssistRecord().getId().toString();
                assistIdSet.add(cussentAssistId);
                historyList = assistHistoryInfoMap.containsKey(cussentAssistId) ? (List)assistHistoryInfoMap.get(cussentAssistId) : new ArrayList();
                historyList.add(history);
                assistHistoryInfoMap.put(cussentAssistId, historyList);
            }
            if (assistIdSet.size() == 0) {
                return new VoucherAssistRecordCollection();
            }
            VoucherAssistRecordCollection result = new VoucherAssistRecordCollection();
            AsstActTypeCollection tcol = (AsstActTypeCollection)asstAttrTypes;
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = view.getSelector();
            selector.add(new SelectorItemInfo("bill.number"));
            selector.add(new SelectorItemInfo("bill.isReverseVoucher"));
            selector.add(new SelectorItemInfo("entry.entryDC"));
            selector.add(new SelectorItemInfo("entry.account.DC"));
            selector.add(new SelectorItemInfo("entry.isVerify"));
            int count = tcol.size();
            for (int i = 0; i < count; ++i) {
                String asstTypeAttr = tcol.get(i).getAsstHGAttribute();
                selector.add(new SelectorItemInfo("assGrp." + asstTypeAttr + ".id"));
                selector.add(new SelectorItemInfo("assGrp." + asstTypeAttr + ".name"));
                selector.add(new SelectorItemInfo("assGrp." + asstTypeAttr + ".number"));
            }
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("bill.voucherType.name"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", assistIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            view.getSorter().add(new SorterItemInfo("entry.id"));
            view.getSorter().add(new SorterItemInfo("id"));
            view.getSorter().add(new SorterItemInfo("seq"));
            result = VoucherAssistRecordFactory.getLocalInstance(ctx).getVoucherAssistRecordCollection(view);
            VoucherAssistRecordCollection newResult = new VoucherAssistRecordCollection();
            for (int i = 0; i < result.size(); ++i) {
                VoucherAssistRecordInfo assist = result.get(i);
                boolean asstActIsNotNull = true;
                int count2 = tcol.size();
                for (int j = 0; j < count2; ++j) {
                    String asstTypeAttr = tcol.get(j).getAsstHGAttribute();
                    Object asstActValue = assist.getAssGrp().get(asstTypeAttr);
                    if (asstActValue != null) continue;
                    asstActIsNotNull = false;
                    break;
                }
                if (asstActIsNotNull) {
                    newResult.add(assist);
                }
                assist.put("HISTORY_INFO", assistHistoryInfoMap.get(assist.getId().toString()));
                if (assist.getEntry() != null && assist.getBill() != null) continue;
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select acct.FDC from t_gl_acctcussent cuss inner join t_bd_accountview acct on acct.fid = cuss.FAccountID where cuss.FVchAssistRecordID = ?", (Object[])new Object[]{assist.getId().toString()});
                rs.next();
                assist.put("INITDATA_ENTRY_DC", (Object)new Integer(rs.getInt(1) == -1 ? 0 : 1));
            }
            return newResult;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private AcctCussentHistoryCollection getHistories(Context ctx, String voucherId) throws BOSException {
        try {
            String sql = "select his.fid from t_gl_voucherassistrecord assist inner join t_gl_acctcussenthistory his on his.FVoucherAsstIDID = assist.fid where assist.fbillid = ? ";
            sql = sql + " union select his.fid from t_gl_voucherassistrecord assist inner join t_gl_acctcussent cuss on assist.fid = cuss.FVchAssistRecordID inner join t_gl_acctcussenthistory his on cuss.fid = his.FCussentidID where assist.fbillid = ? and his.fdc!=3";
            sql = sql + " union select his.fid from t_gl_voucherassistrecord assist inner join t_gl_acctcussent cuss on assist.fid = cuss.FVchAssistRecordID inner join t_gl_acctcussenthistory his on cuss.fid = his.FVoucherAsstIDID where assist.fbillid = ? and his.fdc!=3";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{voucherId, voucherId, voucherId});
            HashSet<String> hisIdSet = new HashSet<String>();
            while (rs.next()) {
                hisIdSet.add(rs.getString(1));
            }
            if (hisIdSet.size() == 0) {
                return new AcctCussentHistoryCollection();
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", hisIdSet, CompareType.INCLUDE));
            view.getSelector().add(new SelectorItemInfo("*"));
            view.getSelector().add(new SelectorItemInfo("cussentid.vchAssistRecord.id"));
            view.getSelector().add(new SelectorItemInfo("veriVch.number"));
            view.getSelector().add(new SelectorItemInfo("cussVch.number"));
            return AcctCussentHistoryFactory.getLocalInstance(ctx).getAcctCussentHistoryCollection(view);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected IObjectValue _getUnVerifyVoucher(Context ctx, Map param) throws BOSException, EASBizException {
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        boolean hasBizDate = param.get("bizDate") != null;
        boolean hasAccount = param.get("account") != null;
        try {
            String accountId;
            String accountId2;
            Date bizDate;
            StringBuffer sql = new StringBuffer("select voucher.fid from t_gl_voucher voucher ");
            sql.append("inner join t_gl_voucherentry entry on voucher.fid = entry.fbillid ");
            sql.append("inner join t_bd_period period on period.fid = voucher.fperiodid ");
            sql.append("inner join t_gl_voucherassistrecord assist on assist.fentryid = entry.fid ");
            sql.append("inner join t_gl_acctcussenthistory accthistory on assist.fid=accthistory.fvoucherasstidid ");
            sql.append("where entry.fcurrencyid = ? and " + (hasAccount ? "entry.faccountid = ? and " : " ") + " voucher.fnumber = ? and voucher.fvouchertypeid = ? ");
            sql.append("and period.fperiodyear = ? and period.fperiodnumber = ? and voucher.fcompanyid = ? ");
            sql.append(hasBizDate ? "and assist.fbizdate = ? " : "");
            String currencyId = ((CurrencyInfo)param.get("currency")).getId().toString();
            String voucherNumber = null;
            voucherNumber = param.get("voucherNumber") instanceof VoucherInfo ? ((VoucherInfo)param.get("voucherNumber")).getNumber() : param.get("voucherNumber").toString();
            String voucherTypeId = ((VoucherTypeInfo)param.get("voucherType")).getId().toString();
            Integer year = new Integer(param.get("spnYear").toString());
            Integer quarter = new Integer(param.get("spnPeriod").toString());
            String companyId = (String)param.get("companyId");
            if (companyId == null) {
                companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            }
            if (!iVoucher.exists("where number = '" + voucherNumber + "' and company.id ='" + companyId + "' and voucherType.id ='" + voucherTypeId + "'")) {
                throw new VoucherException(VoucherException.VOUCHER_NOT_EXIST);
            }
            IRowSet rs = null;
            if (hasBizDate) {
                bizDate = new Date(((java.util.Date)param.get("bizDate")).getTime());
                if (hasAccount) {
                    accountId2 = ((AccountViewInfo)param.get("account")).getId().toString();
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currencyId, accountId2, voucherNumber, voucherTypeId, year, quarter, companyId, bizDate});
                } else {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currencyId, voucherNumber, voucherTypeId, year, quarter, companyId, bizDate});
                }
            } else if (hasAccount) {
                accountId = ((AccountViewInfo)param.get("account")).getId().toString();
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currencyId, accountId, voucherNumber, voucherTypeId, year, quarter, companyId});
            } else {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currencyId, voucherNumber, voucherTypeId, year, quarter, companyId});
            }
            if (rs.next()) {
                return VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(rs.getString(1)));
            }
            sql = new StringBuffer("select voucher.fid from t_gl_voucher voucher ");
            sql.append("inner join t_gl_voucherentry entry on voucher.fid = entry.fbillid ");
            sql.append("inner join t_bd_period period on period.fid = voucher.fperiodid ");
            sql.append("inner join t_gl_voucherassistrecord assist on assist.fentryid = entry.fid ");
            sql.append("inner join t_gl_acctcussent cussent on cussent.FVchAssistRecordID = assist.fid ");
            sql.append("inner join t_gl_acctcussenthistory accthistory on (cussent.fid=accthistory.FCussentidID and accthistory.fdc!=3) ");
            sql.append("where entry.fcurrencyid = ? and " + (hasAccount ? "entry.faccountid = ? and " : " ") + " voucher.fnumber = ? and voucher.fvouchertypeid = ? ");
            sql.append("and period.fperiodyear = ? and period.fperiodnumber = ? and voucher.fcompanyid = ? ");
            sql.append(hasBizDate ? "and assist.fbizdate = ? " : "");
            if (hasBizDate) {
                bizDate = new Date(((java.util.Date)param.get("bizDate")).getTime());
                if (hasAccount) {
                    accountId2 = ((AccountViewInfo)param.get("account")).getId().toString();
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currencyId, accountId2, voucherNumber, voucherTypeId, year, quarter, companyId, bizDate});
                } else {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currencyId, voucherNumber, voucherTypeId, year, quarter, companyId, bizDate});
                }
            } else if (hasAccount) {
                accountId = ((AccountViewInfo)param.get("account")).getId().toString();
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currencyId, accountId, voucherNumber, voucherTypeId, year, quarter, companyId});
            } else {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currencyId, voucherNumber, voucherTypeId, year, quarter, companyId});
            }
            if (rs.next()) {
                return VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(rs.getString(1)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    @Override
    protected void _unverfyVoucher(Context ctx, String voucherId) throws BOSException, EASBizException {
        AcctCussentHistoryCollection histories = this.getHistories(ctx, voucherId);
        BillBaseInfo baseInfo = VoucherFactory.getLocalInstance((Context)ctx).getBillBaseInfo((IObjectPK)new ObjectUuidPK(voucherId));
        this.unVerifyHistory(ctx, histories, baseInfo.getBOSType());
    }

    private void excuteAfterLog(Context ctx, ArrayList<IObjectPK> logPKs) {
        if (null == logPKs || logPKs.size() == 0) {
            return;
        }
        for (int i = 0; i < logPKs.size(); ++i) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPKs.get(i));
        }
    }

    private void verifyAcctTable(Context ctx, Object[] ids, String companyId) throws EASBizException, BOSException {
        if (ids.length == 0) {
            return;
        }
        StringBuffer vids = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            vids.append("'" + ids[i] + "',");
        }
        String cuId = companyId == null ? ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() : null;
        companyId = companyId == null ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : companyId;
        CompanyOrgUnitInfo comp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select accountTable.id,CU.id where id='" + companyId + "'");
        if (comp == null || comp.getAccountTable() == null) {
            return;
        }
        cuId = cuId == null ? comp.getCU().getId().toString() : cuId;
        String newTableId = comp.getAccountTable().getId().toString();
        String sql = "select ac.FAccountTableID from t_gl_acctcussenthistory h inner join t_gl_acctcussent c on c.fid=h.FCussentidID inner join t_bd_accountview ac on ac.fid=c.faccountid where h.fid in (" + vids.substring(0, vids.length() - 1) + ") and c.fcontrolunitid = ac.fcontrolunitid  and ac.fcontrolunitid = '" + cuId + "' group by ac.FAccountTableID ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String tableId = rs.getString(1);
                if (tableId.equals(newTableId)) continue;
                throw new VoucherException(VoucherException.ACCOUNTTABLE_DIFF_CANNOT_UNVERIFY);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected IObjectCollection _getUnverifiedAccts(Context ctx, String voucherId) throws BOSException {
        try {
            String sql = "select distinct FAccountID from T_GL_AcctCussent where fid in (select his.FCussentidID from T_GL_AcctCussentHistory his inner join T_GL_VoucherAssistRecord asst on his.FVoucherAsstIDID = asst.fid inner join T_GL_Voucher voucher on voucher.fid = asst.FBillID where voucher.fid = ? )";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{voucherId});
            HashSet<String> set = new HashSet<String>();
            while (rs.next()) {
                set.add(rs.getString(1));
            }
            if (set.size() == 0) {
                return new AccountViewCollection();
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            view.setFilter(filter);
            return AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected BigDecimal _getVerifiedAmount(Context ctx, String assistRecordId) throws BOSException {
        try {
            Integer innerNegVerify = new Integer(3);
            String sql = "select FOroginalAmount from (select sum(FOroginalAmount) FOroginalAmount from t_gl_acctcussenthistory where FVoucherAsstIDID = ? ";
            sql = sql + " union select sum(FOroginalAmount) FOroginalAmount from t_gl_acctcussenthistory where FCussentidID in (select fid from t_gl_acctcussent where FVchAssistRecordID=?) and fdc !=?) as s1";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{assistRecordId, assistRecordId, innerNegVerify});
            BigDecimal result = new BigDecimal("0");
            while (rs.next()) {
                if (rs.getBigDecimal(1) == null) continue;
                result = result.add(rs.getBigDecimal(1));
            }
            return result;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected EntityViewInfo _getVoucherIdEntityView(Context ctx, Map params) throws BOSException {
        try {
            HashSet<String> voucherIdSet = new HashSet<String>();
            StringBuffer select = new StringBuffer();
            select.append("select distinct asst.FBillID from t_gl_acctcussenthistory his inner join t_gl_voucherassistrecord asst on his.FVoucherAsstIDID=asst.fid ");
            select.append("inner join t_gl_voucher voucher on voucher.fid = asst.fbillid inner join t_gl_voucherentry entry on entry.fid = asst.FEntryID ");
            select.append("inner join t_bd_period period on period.fid = voucher.fperiodid ");
            StringBuffer whereClause = new StringBuffer();
            whereClause.append("where asst.fbillid is not null and ");
            whereClause.append("his.fcompanyid = '" + params.get("company.id") + "' and period.fperiodyear = " + params.get("period.periodYear") + " and period.fperiodNumber = " + params.get("period.periodNumber") + " ");
            if (params.get("entries.currency.id") != null) {
                whereClause.append("and entry.fcurrencyid = '" + params.get("entries.currency.id") + "' ");
            }
            if (params.get("voucherType.id") != null) {
                whereClause.append("and voucher.fvouchertypeid = '" + params.get("voucherType.id") + "' ");
            }
            if (params.get("bizDate") != null) {
                java.util.Date bizDate = (java.util.Date)params.get("bizDate");
                whereClause.append("and asst.fbizdate = TO_DATE('" + new SimpleDateFormat("yyyy-MM-dd").format(bizDate) + "') ");
            }
            if (params.get("account.id") != null) {
                whereClause.append("and entry.faccountid = '" + ((AccountViewInfo)params.get("account.id")).getId() + "' ");
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)(select.toString() + whereClause));
            while (rs.next()) {
                voucherIdSet.add(rs.getString(1));
            }
            select = new StringBuffer();
            select.append("select distinct asst.fbillid from t_gl_acctcussenthistory his inner join t_gl_acctcussent cuss on (his.FCussentidID = cuss.fid and his.fdc!=3) ");
            select.append("inner join t_gl_voucherassistrecord asst on cuss.FVchAssistRecordID = asst.fid ");
            select.append("inner join t_gl_voucher voucher on voucher.fid = asst.fbillid inner join t_gl_voucherentry entry on entry.fid = asst.FEntryID ");
            select.append("inner join t_bd_period period on period.fid = voucher.fperiodid ");
            rs = DbUtil.executeQuery((Context)ctx, (String)(select.toString() + whereClause));
            while (rs.next()) {
                voucherIdSet.add(rs.getString(1));
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            viewInfo.setFilter(filter);
            if (voucherIdSet.size() == 0) {
                filter.getFilterItems().add(new FilterItemInfo("id", null));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("id", voucherIdSet, CompareType.INCLUDE));
            }
            return viewInfo;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void unVerifyHistory(Context ctx, AcctCussentHistoryCollection histories, BOSObjectType bosType) throws BOSException {
        StringBuffer sql = new StringBuffer("update t_gl_acctcussent set (funverifiedamtfor,funverifiedamtlocal,funverifiedamtrpt,funverifiedqty) = (");
        sql.append("select t_gl_acctcussent.funverifiedamtfor+accthistory.foroginalamount,t_gl_acctcussent.funverifiedamtlocal+accthistory.flocalamount,");
        sql.append("t_gl_acctcussent.funverifiedamtrpt+accthistory.freportamount,t_gl_acctcussent.funverifiedqty+accthistory.fqty ");
        sql.append("from t_gl_acctcussenthistory accthistory where accthistory.fcussentidid = t_gl_acctcussent.fid and accthistory.fid = ? and accthistory.fdc!=3)");
        sql.append("where t_gl_acctcussent.fid = ?");
        StringBuffer versql = new StringBuffer("update t_gl_acctverify set (funverifiedamtfor,funverifiedamtlocal,funverifiedamtrpt,funverifiedqty) = (");
        versql.append("select t_gl_acctverify.funverifiedamtfor+accthistory.foroginalamount,t_gl_acctverify.funverifiedamtlocal+accthistory.flocalamount,");
        versql.append("t_gl_acctverify.funverifiedamtrpt+accthistory.freportamount,t_gl_acctverify.funverifiedqty+accthistory.fqty ");
        versql.append("from t_gl_acctcussenthistory accthistory where  accthistory.fid = ? )");
        versql.append("where t_gl_acctverify.FVchAssistRecordID = ? ");
        StringBuffer assistIds = new StringBuffer();
        StringBuffer historyIds = new StringBuffer();
        ArrayList<IObjectPK> logPKs = new ArrayList<IObjectPK>();
        String number1 = null;
        String number2 = null;
        try {
            for (int i = 0; i < histories.size(); ++i) {
                AcctCussentHistoryInfo history = (AcctCussentHistoryInfo)histories.getObject(i);
                number1 = history.getCussVch() == null ? "initData" : history.getCussVch().getNumber();
                number2 = history.getVeriVch() == null ? "initData" : history.getVeriVch().getNumber();
                IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"unverfyVoucher", (BOSObjectType)bosType, null, (String)(history.getNumber() + ";" + number1 + ";" + number2), (String)"gl_AcctCussentHistoryFacade");
                logPKs.add(logPK);
                int _dc = history.getDc().getValue();
                if (_dc != 3) {
                    String execSql = sql.toString().replaceFirst("\\?", "'" + history.getId() + "'").replaceFirst("\\?", "'" + history.getCussentid().getId() + "'");
                    DbUtil.execute((Context)ctx, (String)execSql);
                    if (_dc == 0 || _dc == 2) {
                        assistIds.append("'" + history.getVoucherAsstID().getId() + "',");
                        historyIds.append("'" + history.getId() + "',");
                        DbUtil.execute((Context)ctx, (String)versql.toString(), (Object[])new Object[]{history.getId().toString(), history.getVoucherAsstID().getId().toString()});
                        continue;
                    }
                    if (_dc != 1) continue;
                    DbUtil.execute((Context)ctx, (String)"delete from t_gl_acctcussenthistory where fid = ? ", (Object[])new Object[]{history.getId().toString()});
                    String execSql2 = "select fid from t_gl_acctcussenthistory where FVoucherAsstIDID = ? and FCussentidID = ? and FDC = 1";
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)execSql2, (Object[])new Object[]{history.getCussentid().getId().toString(), history.getVoucherAsstID().getId().toString()});
                    if (!rs.next()) continue;
                    execSql = sql.toString().replaceFirst("\\?", "'" + rs.getString(1) + "'").replaceFirst("\\?", "'" + history.getVoucherAsstID().getId() + "'");
                    DbUtil.execute((Context)ctx, (String)execSql);
                    DbUtil.execute((Context)ctx, (String)"delete from t_gl_acctcussenthistory where fid = ? ", (Object[])new Object[]{rs.getString(1)});
                    continue;
                }
                DbUtil.execute((Context)ctx, (String)versql.toString(), (Object[])new Object[]{history.getId().toString(), history.getCussentid().getId().toString()});
                DbUtil.execute((Context)ctx, (String)"delete from t_gl_acctcussenthistory where fid = ? ", (Object[])new Object[]{history.getId().toString()});
                String queryAnotherHis = "select fid from t_gl_acctcussenthistory where FCussentidID=? and FVoucherAsstIDID=?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryAnotherHis, (Object[])new Object[]{history.getVoucherAsstID().getId().toString(), history.getCussentid().getId().toString()});
                if (!rs.next()) continue;
                DbUtil.execute((Context)ctx, (String)versql.toString(), (Object[])new Object[]{rs.getString(1), history.getVoucherAsstID().getId().toString()});
                DbUtil.execute((Context)ctx, (String)"delete from t_gl_acctcussenthistory where fid = ? ", (Object[])new Object[]{rs.getString(1)});
            }
            if (assistIds.length() > 0) {
                DbUtil.execute((Context)ctx, (String)("update t_gl_voucherassistrecord set fisvierified = 0,FVERIFIEDCUSSENTID=null where fid in (" + assistIds.substring(0, assistIds.length() - 1) + ")"));
                DbUtil.execute((Context)ctx, (String)("update t_gl_acctcussent set fisvierified = 0 where fvchassistrecordid in (" + assistIds.substring(0, assistIds.length() - 1) + ")"));
            }
            if (historyIds.length() > 0) {
                DbUtil.execute((Context)ctx, (String)("delete from t_gl_acctcussenthistory where fid in (" + historyIds.substring(0, historyIds.length() - 1) + ")"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.excuteAfterLog(ctx, logPKs);
        }
    }

    private String initHistoryIdTmpTable(Context ctx, Set historyIdSet) throws BOSException {
        String tmpTable = GLTempTableUtil.createDBSysTempTable(ctx, "id varchar(44)");
        StringBuffer sql = new StringBuffer();
        return tmpTable;
    }

    private void unVerifyHistory_New(Context ctx, Set historyIdSet, BOSObjectType bosType) throws BOSException {
        String tmpTable = null;
        StringBuffer where = new StringBuffer();
        SqlParams sp = new SqlParams();
        if (historyIdSet.size() > 100) {
            tmpTable = this.initHistoryIdTmpTable(ctx, historyIdSet);
            where.append(" where h.fid in(select id from ").append(tmpTable).append(") ");
        } else {
            where.append(" where h.fid in(");
            Iterator it = historyIdSet.iterator();
            while (it.hasNext()) {
                where.append("?,");
                sp.addString((String)it.next());
            }
            where.deleteCharAt(where.lastIndexOf(","));
            where.append(") ");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT h.FCUSSENTIDID vsid, sum(h.FOROGINALAMOUNT) omt, sum(FlocalAmount) lmt, sum(FreportAmount) rmt, sum(fqty) qty ");
        sql.append(" into act_tmp ");
        sql.append(" FROM t_gl_acctcussenthistory h inner join T_GL_ACCTCUSSENT v on h.FCUSSENTIDID = v.fid where h.FDC <> 3 ");
        sql.append(where);
        sql.append(" group by h.FCUSSENTIDID ");
        try {
            tmpTable = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)this.getConnection(ctx)).getTempTable();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sql = new StringBuffer();
        sql.append("update t_gl_acctcussent t set (funverifiedamtfor,funverifiedamtlocal,funverifiedamtrpt,funverifiedqty) = (");
        sql.append(" select t.funverifiedamtfor + h.omt, t.funverifiedamtlocal + h.lmt,");
        sql.append(" t.funverifiedamtrpt + h.freportamount, t.funverifiedqty + h.qty ");
        sql.append(" from ").append(tmpTable).append(" h where h.vsid = t.fid )");
        sql.append("where fid in(select vsid from ").append(tmpTable).append(") ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" SELECT vsid, sum(omt) omt, sum(lmt), sum(rmt) rmt, sum(fqty) qty into act_tmp FROM (");
        sql.append(" SELECT h.FVOUCHERASSTIDID vsid, h.FOROGINALAMOUNT omt, FlocalAmount lmt, FreportAmount rmt, fqty ");
        sql.append(" FROM t_gl_acctcussenthistory h inner join t_gl_acctverify v on h.FVOUCHERASSTIDID = v.FVCHASSISTRECORDID where h.FDC in(0,2) ");
        sql.append(where);
        sql.append(" union all ");
        sql.append(" SELECT h.FCUSSENTIDID vsid, h.FOROGINALAMOUNT omt, FlocalAmount lmt, FreportAmount rmt, fqty ");
        sql.append(" FROM t_gl_acctcussenthistory h inner join t_gl_acctverify v on h.FCUSSENTIDID = v.FVCHASSISTRECORDID where h.FDC = 3 ");
        sql.append(where);
        sql.append(") group by vsid ");
        try {
            tmpTable = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)this.getConnection(ctx)).getTempTable();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sql = new StringBuffer();
        sql.append("update t_gl_acctverify t set (funverifiedamtfor,funverifiedamtlocal,funverifiedamtrpt,funverifiedqty) = (");
        sql.append(" select t.funverifiedamtfor + h.omt, t.funverifiedamtlocal + h.lmt,");
        sql.append(" t.funverifiedamtrpt + h.freportamount, t.funverifiedqty + h.qty ");
        sql.append(" from ").append(tmpTable).append(" h where h.vsid = t.FVCHASSISTRECORDID )");
        sql.append("where fid in(select vsid from ").append(tmpTable).append(") ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void sumAmount(Map<String, BigDecimal[]> map, String key, AcctCussentHistoryInfo history) {
        BigDecimal[] amounts = null;
        amounts = map.containsKey(key) ? map.get(key) : new BigDecimal[]{GlUtils.zero, GlUtils.zero, GlUtils.zero};
        amounts[0] = amounts[0].add(history.getOroginalAmount());
        amounts[1] = amounts[1].add(history.getLocalAmount());
        amounts[2] = amounts[2].add(history.getReportAmount());
    }

    @Override
    protected void _unverify(Context ctx, Set historyIdSet) throws BOSException, EASBizException {
        this.verifyAcctTable(ctx, historyIdSet.toArray(), null);
        AcctCussentHistoryCollection histories = this.getHistoryColls(ctx, historyIdSet);
        this.unVerifyHistory(ctx, histories, new BOSObjectType("8DC75C7E"));
    }

    private AcctCussentHistoryCollection getHistoryColls(Context ctx, Set historyIdSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)historyIdSet, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("cussentid.vchAssistRecord.id"));
        view.getSelector().add(new SelectorItemInfo("veriVch.number"));
        view.getSelector().add(new SelectorItemInfo("cussVch.number"));
        AcctCussentHistoryCollection histories = AcctCussentHistoryFactory.getLocalInstance(ctx).getAcctCussentHistoryCollection(view);
        return histories;
    }

    @Override
    protected boolean _hasVerify(Context ctx, String voucherId) throws BOSException {
        if (voucherId == null || voucherId.trim().length() == 0) {
            return false;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 fid from t_gl_acctcussent cussent where cussent.FVoucherId = ? and cussent.FUnVerifiedAmtFor <> cussent.ForiginalAmount  ");
        sql.append(" union ");
        sql.append("select top 1 fid from t_gl_acctverify cussent where cussent.FVoucherId = ? and cussent.FUnVerifiedAmtFor <> cussent.ForiginalAmount ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherId, voucherId});
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected void _insertCussent(Context ctx, String vchID) throws BOSException {
        this._insertCussent(ctx, vchID, false);
    }

    @Override
    protected void _insertCussent(Context ctx, String vchID, boolean isVerified) throws BOSException {
        boolean isAsstQty = false;
        try {
            String curCompanyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            isAsstQty = GlUtils.getDefaultGLParam(ctx, curCompanyID, "G010");
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        Timestamp date = new Timestamp(System.currentTimeMillis());
        String curUserID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into t_GL_AcctCussent                                                       \r\n");
        sql.append("(                                                                                  \r\n");
        sql.append("    FID,                                                                           \r\n");
        sql.append("    FCompanyID,                                                                    \r\n");
        sql.append("    FControlUnitID,                                                                \r\n");
        sql.append("    FPeriodID,                                                                     \r\n");
        sql.append("    FAccountID,                                                                    \r\n");
        sql.append("    FCurrencyID,                                                                   \r\n");
        sql.append("    FIsInit,                                                                       \r\n");
        sql.append("    FVchAssistRecordID,                                                            \r\n");
        sql.append("                                                                                   \r\n");
        sql.append("    FCreatorID,                                                                    \r\n");
        sql.append("    FCreateTime,                                                                   \r\n");
        sql.append("    FLastUpdateUserID,                                                             \r\n");
        sql.append("    FLastUpdateTime,                                                               \r\n");
        sql.append("                                                                                   \r\n");
        sql.append("    FUnVerifiedAmtFor,                                                             \r\n");
        sql.append("    FUnHoldedAmtFor,                                                               \r\n");
        sql.append("    FUnVerifiedAmtLocal,                                                           \r\n");
        sql.append("    FUnHoldedAmtLocal,                                                             \r\n");
        sql.append("    FUnVerifiedAmtRpt,                                                             \r\n");
        sql.append("    FUnHoldedAmtRpt,                                                               \r\n");
        sql.append("                                                                                   \r\n");
        sql.append("    FUnVerifiedQty,                                                                \r\n");
        sql.append("    FUnHoldedQty,                                                                  \r\n");
        sql.append("    FUnVerifiedStdQty,                                                             \r\n");
        sql.append("    FUnHoldedStdQty,                                                               \r\n");
        sql.append("    Fquantity,ForiginalAmount,FlocalAmount,FreportingAmount, \r\n");
        sql.append("                                                                                   \r\n");
        sql.append("    FMeasureUnitID,                                                                \r\n");
        sql.append("    FVoucherID,FAssGrpID,FVARBizDate,FendDate, \r\n");
        sql.append("\tFsettlementTypeID,FsettlementCode,FbizNumber,\r\n");
        sql.append("\tFcustomerID,FsupplierID,ForgUnitID,FmaterialID,\r\n");
        sql.append("\tFticketNumber,FinvoiceNumber,FfeeType,FDescription, \r\n  ");
        sql.append("    FEntryId,FIsVierified,FEntryDC,FIsPost,FBookedDate,FVchNumber,FVoucherTypeID   \r\n");
        sql.append(")                                                                                  \r\n");
        sql.append("                                                                                   \r\n");
        sql.append("Select                                                                             \r\n");
        sql.append("    newBosID('CE2D850A'),                                                          \r\n");
        sql.append("    vch.FCompanyID,                                                                \r\n");
        sql.append("    vch.FControlUnitID,                                                            \r\n");
        sql.append("    vch.FPeriodID,                                                                 \r\n");
        sql.append("    ve.FAccountID,                                                                 \r\n");
        sql.append("    ve.FCurrencyID,                                                                \r\n");
        sql.append("    0,                                                                             \r\n");
        sql.append("    vast.FID,                                                                      \r\n");
        sql.append("                                                                                   \r\n");
        sql.append("    ?,");
        sql.append("    ?,");
        sql.append("    ?,");
        sql.append("    ?,");
        if (isVerified) {
            sql.append(" 0,0,0,0,0,0,0,0,0,0,  \r\n");
            sql.append("\tisnull(vast.Fquantity,0),isnull(vast.ForiginalAmount,0), \r\n");
            sql.append("\tisnull(vast.FlocalAmount,0),isnull(vast.FreportingAmount,0), \r\n");
        } else {
            sql.append("    vast.FOriginalAmount,                                                          \r\n");
            sql.append("    vast.FOriginalAmount,                                                          \r\n");
            sql.append("    vast.FLocalAmount,                                                             \r\n");
            sql.append("    vast.FLocalAmount,                                                             \r\n");
            sql.append("    vast.FReportingAmount,                                                         \r\n");
            sql.append("    vast.FReportingAmount,                                                         \r\n");
            sql.append("    vast.FQuantity,                                                                \r\n");
            sql.append("    vast.FQuantity,                                                                \r\n");
            sql.append("    vast.FStandardQuantity,                                                        \r\n");
            sql.append("    vast.FStandardQuantity,                                                        \r\n");
            sql.append("\tisnull(vast.Fquantity,0),isnull(vast.ForiginalAmount,0), \r\n");
            sql.append("\tisnull(vast.FlocalAmount,0),isnull(vast.FreportingAmount,0), \r\n");
        }
        sql.append("                                                                                   \r\n");
        if (isAsstQty) {
            sql.append("\tvast.FMeasureUnitID,                                                             \r\n");
        } else {
            sql.append("\tve.FMeasureUnitID,                                                             \r\n");
        }
        sql.append("\tvast.FBillID,vast.FAssGrpID,vast.FBizDate,vast.FendDate, \r\n");
        sql.append("\tvast.FsettlementTypeID,vast.FsettlementCode,vast.FbizNumber, \r\n");
        sql.append("\tvast.FcustomerID,vast.FsupplierID,vast.ForgUnitID,vast.FmaterialID, \r\n");
        sql.append("\tvast.FticketNumber,vast.FinvoiceNumber,vast.FfeeType,vast.FDescription, \r\n");
        sql.append("    vast.FEntryId,vast.FIsVierified,ve.FEntryDC ,case when vch.FBizStatus = 5 then 1 else 0 end, \r\n");
        sql.append("    vch.FBookedDate,vch.FNumber,vch.FVoucherTypeId  \r\n");
        sql.append("From                                                                               \r\n");
        sql.append("T_GL_Voucher vch                                                             \r\n");
        sql.append("inner join T_GL_VoucherEntry ve on vch.fid = ve.fbillid                            \r\n");
        sql.append("inner join T_GL_VoucherAssistRecord vast on vast.FEntryID = ve.FID                 \r\n");
        sql.append("inner join t_bd_accountview acct on acct.FID = ve.FAccountID                       \r\n");
        sql.append("left join t_gl_acctcussent cussent on vast.FID = cussent.FVCHASSISTRECORDID        \r\n");
        sql.append(" inner join T_GL_FLAG f on f.FOrgUnitId = vch.FCompanyID and f.FKey = acct.fid \r\n");
        sql.append(" inner join\tT_BD_PERIOD pv on vch.FPeriodID = pv.FID\t\t\r\n");
        sql.append(" inner join\tT_BD_PERIOD pi on f.FInitPeriodID = pi.FID\t\r\n");
        sql.append("Where                                                                              \r\n");
        sql.append("    vch.FID = ?                                                                    \r\n");
        sql.append("    and vast.FBillId = ?                                                           \r\n");
        sql.append("    and vast.FAssGrpID is not null                                                 \r\n");
        sql.append("    and ve.FIsVerify = 0                                                           \r\n");
        sql.append("    and (acct.FCAA is not null)                                                    \r\n");
        sql.append("    and acct.FAC = 1                                                               \r\n");
        sql.append("    and (vch.FSourceType = 0 or vast.FOriginalAmount <> 0)                         \r\n");
        sql.append("    and (cussent.fid is null) \r\n");
        sql.append("\tand f.FName = 'cussentinit' \t\r\n");
        sql.append("  \tand pv.FNumber >= pi.FNumber \t\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curUserID, date, curUserID, date, vchID, vchID});
    }

    @Override
    protected void _insertVerify(Context ctx, String vchID, boolean isInTimeVerify) throws BOSException {
        boolean isAsstQty = false;
        try {
            String curCompanyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            isAsstQty = GlUtils.getDefaultGLParam(ctx, curCompanyID, "G010");
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        java.util.Date date = new java.util.Date();
        String curUserID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into t_GL_AcctVerify                                                       \r\n");
        sql.append("(                                                                                  \r\n");
        sql.append("    FID,                                                                           \r\n");
        sql.append("    FCompanyID,                                                                    \r\n");
        sql.append("    FControlUnitID,                                                                    \r\n");
        sql.append("    FPeriodID,                                                                     \r\n");
        sql.append("    FAccountID,                                                                    \r\n");
        sql.append("    FCurrencyID,                                                                   \r\n");
        sql.append("    FIsInit,                                                                       \r\n");
        sql.append("    FVchAssistRecordID,                                                            \r\n");
        sql.append("    FCreatorID,                                                                    \r\n");
        sql.append("    FCreateTime,                                                                   \r\n");
        sql.append("    FLastUpdateUserID,                                                             \r\n");
        sql.append("    FLastUpdateTime,                                                               \r\n");
        sql.append("    FMeasureUnitID,                                                                \r\n");
        sql.append("    FUnVerifiedAmtFor,                                                             \r\n");
        sql.append("    FUnHoldedAmtFor,                                                               \r\n");
        sql.append("    FUnVerifiedAmtLocal,                                                           \r\n");
        sql.append("    FUnHoldedAmtLocal,                                                             \r\n");
        sql.append("    FUnVerifiedAmtRpt,                                                             \r\n");
        sql.append("    FUnHoldedAmtRpt,                                                               \r\n");
        sql.append("    FUnVerifiedQty,                                                                \r\n");
        sql.append("    FUnHoldedQty,                                                                  \r\n");
        sql.append("    FUnVerifiedStdQty,                                                             \r\n");
        sql.append("    FUnHoldedStdQty,                                                               \r\n");
        sql.append("    Fquantity,ForiginalAmount,FlocalAmount,FreportingAmount,                       \r\n");
        sql.append("    FVoucherID,FAssGrpID,FVARBizDate,FendDate, \r\n");
        sql.append("\tFsettlementTypeID,FsettlementCode,FbizNumber,\r\n");
        sql.append("\tFcustomerID,FsupplierID,ForgUnitID,FmaterialID,\r\n");
        sql.append("\tFticketNumber,FinvoiceNumber,FfeeType,FDescription, \r\n  ");
        sql.append("    FEntryId,FIsVierified,FEntryDC,FIsPost,FBookedDate,FVchNumber,FVoucherTypeID   \r\n");
        sql.append("    ,FVSOURCEBILLID, FISREVERSEVOUCHER, FHASREVERSED, FVERIFIEDCUSSENTID   \r\n");
        sql.append(")                                                                                  \r\n");
        sql.append("                                                                                   \r\n");
        sql.append("Select                                                                             \r\n");
        sql.append("    newBosID('CE2D850A'),                                                          \r\n");
        sql.append("    vch.FCompanyID,                                                                \r\n");
        sql.append("    vch.FControlUnitID,                                                            \r\n");
        sql.append("    vch.FPeriodID,                                                                 \r\n");
        sql.append("    ve.FAccountID,                                                                 \r\n");
        sql.append("    ve.FCurrencyID,                                                                \r\n");
        sql.append("    0,                                                                             \r\n");
        sql.append("    vast.FID,                                                                      \r\n");
        sql.append("                                                                                   \r\n");
        sql.append("    ").append(GlUtils.toSqlString(curUserID)).append(",");
        sql.append("    ").append(KSqlUtil.buildKSqlDateString((java.util.Date)date)).append(",");
        sql.append("    ").append(GlUtils.toSqlString(curUserID)).append(",");
        sql.append("    ").append(KSqlUtil.buildKSqlDateString((java.util.Date)date)).append(",");
        if (isAsstQty) {
            sql.append("\tvast.FMeasureUnitID,                                                             \r\n");
        } else {
            sql.append("\tve.FMeasureUnitID,                                                             \r\n");
        }
        if (isInTimeVerify) {
            sql.append(" 0,0,0,0,0,0,0,0,0,0,  \r\n");
            sql.append("\tisnull(vast.Fquantity,0),isnull(vast.ForiginalAmount,0), \r\n");
            sql.append("\tisnull(vast.FlocalAmount,0),isnull(vast.FreportingAmount,0), \r\n");
        } else {
            sql.append("    case when vast.FIsVierified = 1 then 0 else vast.FOriginalAmount end FOriginalAmount,    \r\n");
            sql.append("    case when vast.FIsVierified = 1 then 0 else vast.FOriginalAmount end FOriginalAmount,    \r\n");
            sql.append("    case when vast.FIsVierified = 1 then 0 else vast.FLocalAmount end FLocalAmount,          \r\n");
            sql.append("    case when vast.FIsVierified = 1 then 0 else vast.FLocalAmount end FLocalAmount,          \r\n");
            sql.append("    case when vast.FIsVierified = 1 then 0 else vast.FReportingAmount end FReportingAmount,  \r\n");
            sql.append("    case when vast.FIsVierified = 1 then 0 else vast.FReportingAmount end FReportingAmount,  \r\n");
            sql.append("                                                                                   \r\n");
            sql.append("    case when vast.FIsVierified = 1 then 0 else vast.FQuantity end FQuantity,                \r\n");
            sql.append("    case when vast.FIsVierified = 1 then 0 else vast.FQuantity end FQuantity,                \r\n");
            sql.append("    case when vast.FIsVierified = 1 then 0 else vast.FStandardQuantity end FStandardQuantity,  \r\n");
            sql.append("    case when vast.FIsVierified = 1 then 0 else vast.FStandardQuantity end FStandardQuantity,  \r\n");
            sql.append("\tisnull(vast.Fquantity,0),isnull(vast.ForiginalAmount,0), \r\n");
            sql.append("\tisnull(vast.FlocalAmount,0),isnull(vast.FreportingAmount,0), \r\n");
        }
        sql.append("\tvast.FBillID,vast.FAssGrpID,vast.FBizDate,vast.FendDate, \r\n");
        sql.append("\tvast.FsettlementTypeID,vast.FsettlementCode,vast.FbizNumber, \r\n");
        sql.append("\tvast.FcustomerID,vast.FsupplierID,vast.ForgUnitID,vast.FmaterialID, \r\n");
        sql.append("\tvast.FticketNumber,vast.FinvoiceNumber,vast.FfeeType,vast.FDescription, \r\n");
        sql.append("    vast.FEntryId,vast.FIsVierified,ve.FEntryDC,case when vch.FBizStatus = 5 then 1 else 0 end, \r\n");
        sql.append("    vch.FBookedDate,vch.FNumber,vch.FVoucherTypeId,  \r\n");
        sql.append("    vch.FSOURCEBILLID FVSOURCEBILLID,vch.FISREVERSEVOUCHER ,vch.FHASREVERSED,vast.FVERIFIEDCUSSENTID  \r\n");
        sql.append("From                                                                               \r\n");
        sql.append("T_GL_Voucher vch                                                             \r\n");
        sql.append("inner join T_GL_VoucherEntry ve on vch.fid = ve.fbillid                            \r\n");
        sql.append("inner join T_GL_VoucherAssistRecord vast on vast.FEntryID = ve.FID                 \r\n");
        sql.append("inner join t_bd_accountview acct on acct.FID = ve.FAccountID                       \r\n");
        sql.append("left join t_gl_acctverify cussent on vast.FID = cussent.FVCHASSISTRECORDID        \r\n");
        sql.append(" inner join T_GL_FLAG f on f.FOrgUnitId = vch.FCompanyID and f.FKey = acct.fid \r\n");
        sql.append(" inner join\tT_BD_PERIOD pv on vch.FPeriodID = pv.FID\t\t\r\n");
        sql.append(" inner join\tT_BD_PERIOD pi on f.FInitPeriodID = pi.FID\t\r\n");
        sql.append("Where                                                                              \r\n");
        sql.append("    vch.FID = ?                                                                    \r\n");
        sql.append("    and vast.FBillId = ?                                                           \r\n");
        sql.append("    and ve.FBillID = vch.FID                                                       \r\n");
        sql.append("    and vast.FEntryID = ve.FID                                                     \r\n");
        sql.append("    and vast.FAssGrpID is not null                                                 \r\n");
        sql.append("    and ve.FIsVerify = 1                                                           \r\n");
        sql.append("    and acct.FID = ve.FAccountID                                                   \r\n");
        sql.append("    and (acct.FCAA is not null)                                                    \r\n");
        sql.append("    and acct.FAC = 1                                                               \r\n");
        sql.append("    and (vch.FSourceType = 0 or vast.FOriginalAmount <> 0)                         \r\n");
        sql.append("    and (cussent.fid is null)                         \r\n");
        sql.append("\tand f.FName = 'cussentinit' \t\r\n");
        sql.append("  \tand pv.FNumber >= pi.FNumber \t\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{vchID, vchID});
    }

    @Override
    protected HashMap _getVerifyAsstAmt(Context ctx, String acctCussentId) throws BOSException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select acctVerify.FVCHASSISTRECORDID vchAsstId,his.fid,acctVerify.FOriginalAmount as oriAmt, his.foroginalAmount as verifyAmt, ");
            sql.append(" acctVerify.FUNVERIFIEDAMTFOR as unverifyAmt ");
            sql.append("from t_gl_acctcussenthistory his ");
            sql.append("inner join t_gl_acctverify acctVerify on acctVerify.FVCHASSISTRECORDID = his.FVoucherAsstIDID ");
            sql.append("where his.FCussentidID = ? ");
            HashMap result = new HashMap();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{acctCussentId});
            while (rs.next()) {
                ArrayList<BigDecimal> amts = new ArrayList<BigDecimal>(3);
                amts.add(rs.getBigDecimal(3));
                amts.add(rs.getBigDecimal(4));
                amts.add(rs.getBigDecimal(3).subtract(rs.getBigDecimal(5)));
                result.put(rs.getString(1) + rs.getString(2), amts);
            }
            String companyid = null;
            String accountid = null;
            String currencyid = null;
            String assgrpid = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)"select fcompanyid,faccountid,fcurrencyid,fassgrpid from t_gl_acctcussent where fid = ?", (Object[])new Object[]{acctCussentId});
            if (rs.next()) {
                companyid = rs.getString("fcompanyid");
                accountid = rs.getString("faccountid");
                currencyid = rs.getString("fcurrencyid");
                assgrpid = rs.getString("fassgrpid");
            }
            sql = new StringBuffer();
            sql.append(" select r.fid,r.FOriginalAmount,sum(CASE  WHEN (his.FOroginalAmount IS NULL) THEN 0 ELSE his.FOroginalAmount END)");
            sql.append(" from ( ");
            sql.append(" SELECT s.fid, s.FOriginalAmount");
            sql.append(" FROM t_gl_voucherassistrecord s");
            sql.append(" INNER JOIN t_gl_voucherentry e ON e.fid = s.FEntryID");
            sql.append(" WHERE s.fcompanyid = ? and s.faccountid = ? and s.fassgrpid = ? and e.fcurrencyid = ?");
            sql.append(" and e.FIsVerify = 1 and s.FIsVierified = 0 and s.FOriginalAmount < 0");
            sql.append(" ) r ");
            sql.append(" inner join t_gl_acctcussenthistory his on his.fvoucherasstidid = r.fid");
            sql.append("  group by r.fid, r.FOriginalAmount");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyid, accountid, assgrpid, currencyid});
            while (rs.next()) {
                ArrayList<BigDecimal> amts = new ArrayList<BigDecimal>(3);
                amts.add(rs.getBigDecimal(2));
                amts.add(rs.getBigDecimal(3));
                amts.add(rs.getBigDecimal(3));
                result.put(rs.getString(1), amts);
            }
            return result;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected AcctCussentCancelResult _getVerifyData(Context ctx, Map queryCondition, int start, int rows) throws BOSException, EASBizException {
        String tempTableName = (String)queryCondition.get("tempTableName");
        boolean isFirstTime = (Boolean)queryCondition.get("isFirstTime");
        if (isFirstTime) {
            if (tempTableName != null) {
                GLTempTableUtil.dropDBSysTempTable(ctx, tempTableName);
            }
            tempTableName = this.insertTempTableData(ctx, queryCondition);
        }
        try {
            AcctCussentCancelResult result = new AcctCussentCancelResult();
            List records = this.getAcctCussentData(ctx, queryCondition, start, rows, tempTableName);
            result.setData(records);
            StringBuffer countSql = new StringBuffer();
            countSql.append(" select count(1) count from ").append(tempTableName);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)countSql.toString());
            if (rs.next()) {
                result.setResultCount(rs.getLong("count"));
            }
            result.setTempTableName(tempTableName);
            return result;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private List getAcctCussentData(Context ctx, Map queryCondition, int start, int rows, String tempTableName) throws BOSException, SQLException, EASBizException {
        String tableType = (String)queryCondition.get("tableType");
        String loc = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        List records = null;
        if (this.UP_TABLE.equals(tableType)) {
            StringBuffer sql = new StringBuffer();
            this.getVerifySrcSelect(loc, sql);
            sql.append(" ,tem.KSQL_SEQ  \r\n");
            this.getVerifySrcFrom(sql);
            sql.append(" inner join ").append(tempTableName).append(" tem on tem.id = a.fid  \r\n");
            sql.append(" where tem.KSQL_SEQ >= ? and tem.KSQL_SEQ <= ? ");
            sql.append(" order by tem.KSQL_SEQ ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{start + 1, start + rows});
            records = this.dealVerifySrcData(ctx, rows, rs);
        } else {
            StringBuffer sql = new StringBuffer();
            String verifyAmtSql = " ( SELECT isnull(sum(FOroginalAmount),0) VERIFIEDAMTFOR  \r\n  FROM t_gl_acctcussenthistory his  \r\n  where FVoucherAsstIDID = c.fid )  \r\n";
            this.getVerifyObjSelect(loc, verifyAmtSql, sql);
            sql = new StringBuffer(sql.toString().replace("a.FLastUpdateTime", "acv.FLastUpdateTime"));
            this.getVerifyObjFrom(sql);
            sql.append(" inner join t_gl_acctverify acv on acv.FVCHASSISTRECORDID = c.fid \r\n");
            sql.append(" inner join ").append(tempTableName).append(" tem on tem.id = c.fid  \r\n");
            sql.append(" where tem.KSQL_SEQ >= ? and tem.KSQL_SEQ <= ? ");
            sql.append(" order by tem.KSQL_SEQ ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{start + 1, start + rows});
            records = this.dealVerifyObjData(ctx, rows, rs);
        }
        return records;
    }

    private List dealVerifyObjData(Context ctx, int rows, IRowSet rs) throws SQLException, BOSException, EASBizException {
        ArrayList records = new ArrayList(rows);
        HashMap<String, Map> cacheAssGrp = new HashMap<String, Map>();
        while (rs.next()) {
            HashMap<String, Object> record = new HashMap<String, Object>();
            int precision = rs.getInt("fprecision");
            record.put("querySeq_No", rs.getString("KSQL_SEQ"));
            record.put("id", rs.getString("id"));
            record.put("voucherid", rs.getString("voucherid"));
            record.put("voucherType", rs.getString("voucherType"));
            record.put("number", rs.getString("number"));
            record.put("bizDate", rs.getDate("bizDate"));
            record.put("bizNumber", rs.getString("bizNumber"));
            record.put("bookedDate", rs.getDate("bookedDate"));
            record.put("description", rs.getString("description"));
            record.put("accountTrueNumber", rs.getString("accountNumber"));
            record.put("accountNumber", rs.getString("accountNumber") + " " + rs.getString("accountName"));
            record.put("accountName", rs.getString("accountName"));
            record.put("currency", rs.getString("currency"));
            record.put("entryDC", EntryDC.getEnum((int)rs.getInt("entryDC")).getAlias());
            BigDecimal orgAmt = rs.getBigDecimal("originalAmount");
            if (GlUtils.zero.compareTo(orgAmt) == 0) {
                record.put("originalAmount", "");
            } else {
                record.put("originalAmount", GlUtils.formatDecimal(orgAmt, precision));
            }
            record.put("localAmount", rs.getBigDecimal("localAmount"));
            record.put("reportingAmount", rs.getBigDecimal("reportingAmount"));
            record.put("assGrpID", rs.getString("assGrpID"));
            record.put("voucherAssistRecordID", rs.getString("voucherAssistRecordID"));
            BigDecimal verifiedAmtFor = rs.getBigDecimal("verifiedAmtfor");
            if (GlUtils.zero.compareTo(verifiedAmtFor) == 0) {
                record.put("verifiedAmtFor", "");
            } else {
                record.put("verifiedAmtFor", GlUtils.formatDecimal(verifiedAmtFor, precision));
            }
            record.put("lastUpdateTime", rs.getDate("lastUpdateTime"));
            Map hgInfo = null;
            if (cacheAssGrp.containsKey(rs.getString("assGrpID"))) {
                hgInfo = (Map)cacheAssGrp.get(rs.getString("assGrpID"));
            } else {
                hgInfo = this.getHgInfo(ctx, rs.getString("assGrpID"), rs.getString("accountCAA"));
                cacheAssGrp.put(rs.getString("assGrpID"), hgInfo);
            }
            record.put("assGrp", hgInfo);
            BigDecimal unVerifiedAmtFor = orgAmt.subtract(rs.getBigDecimal("verifiedAmtFor"));
            if (GlUtils.zero.compareTo(unVerifiedAmtFor) == 0) {
                record.put("unVerifiedAmtFor", "");
            } else {
                record.put("unVerifiedAmtFor", GlUtils.formatDecimal(unVerifiedAmtFor, precision));
            }
            records.add(record);
        }
        return records;
    }

    private List dealVerifySrcData(Context ctx, int rows, IRowSet rs) throws SQLException, BOSException, EASBizException {
        HashMap<String, Map> cacheAssGrp = new HashMap<String, Map>();
        ArrayList records = new ArrayList(rows);
        while (rs.next()) {
            HashMap<String, Object> record = new HashMap<String, Object>();
            record.put("querySeq_No", rs.getString("KSQL_SEQ"));
            record.put("id", rs.getString("id"));
            record.put("voucherid", rs.getString("voucherid"));
            record.put("voucherType", rs.getString("voucherType"));
            record.put("accountTrueNumber", rs.getString("accountNumber"));
            record.put("accountNumber", rs.getString("accountNumber") + " " + rs.getString("accountName"));
            record.put("currency", rs.getString("currency"));
            record.put("number", rs.getString("number"));
            record.put("bizDate", rs.getDate("bizDate"));
            record.put("bizNumber", rs.getString("bizNumber"));
            record.put("bookedDate", rs.getDate("bookedDate"));
            record.put("description", rs.getString("description"));
            record.put("dc", BalanceDirectionEnum.getEnum((int)rs.getInt("dc")).getAlias());
            record.put("unHoldedQty", rs.getBigDecimal("UNVERIFIEDQTY"));
            record.put("measureUnit.name", rs.getString("mName"));
            int precision = rs.getInt("fprecision");
            BigDecimal orgAmt = rs.getBigDecimal("originalAmount");
            if (GlUtils.zero.compareTo(orgAmt) == 0) {
                record.put("originalAmount", "");
            } else {
                record.put("originalAmount", GlUtils.formatDecimal(orgAmt, precision));
            }
            record.put("originalAmount", GlUtils.formatDecimal(orgAmt, precision));
            record.put("assGrpID", rs.getString("assGrpID"));
            record.put("period", rs.getString("period"));
            record.put("voucherAssistRecordID", rs.getString("voucherAssistRecordID"));
            BigDecimal unverifiedAmtFor = rs.getBigDecimal("unverifiedAmtFor");
            if (GlUtils.zero.compareTo(unverifiedAmtFor) == 0) {
                record.put("unVerifiedAmtFor", "");
            } else {
                record.put("unVerifiedAmtFor", GlUtils.formatDecimal(unverifiedAmtFor, precision));
            }
            BigDecimal verifiedAmtFor = orgAmt.subtract(unverifiedAmtFor);
            if (GlUtils.zero.compareTo(verifiedAmtFor) == 0) {
                record.put("verifiedAmtFor", "");
            } else {
                record.put("verifiedAmtFor", GlUtils.formatDecimal(verifiedAmtFor, precision));
            }
            record.put("lastUpdateTime", rs.getDate("lastUpdateTime"));
            Map hgInfo = null;
            if (cacheAssGrp.containsKey(rs.getString("assGrpID"))) {
                hgInfo = (Map)cacheAssGrp.get(rs.getString("assGrpID"));
            } else {
                hgInfo = this.getHgInfo(ctx, rs.getString("assGrpID"), rs.getString("accountCAA"));
                cacheAssGrp.put(rs.getString("assGrpID"), hgInfo);
            }
            record.put("assGrp", hgInfo);
            records.add(record);
        }
        return records;
    }

    private void getVerifyObjFrom(StringBuffer sql) {
        sql.append(" ,tem.KSQL_SEQ  \r\n");
        sql.append(" from t_gl_Voucher a  \r\n");
        sql.append(" inner join t_bd_vouchertypes vts on vts.fid = a.fvouchertypeid  \r\n");
        sql.append(" inner join t_gl_Voucherentry b on b.FBillID = a.fid    \t\t\t\t\t\t\t\t\t\t\t\r\n  ");
        sql.append(" inner join T_GL_VoucherAssistRecord c on c.FBillID = a.fid  and  c.FEntryID = b.fid  \r\n");
        sql.append(" inner join T_bd_assistanthg hg on c.FassgrpId =hg.fid     \t\t\t\t\t\t\t\t\t\t\t\r\n  ");
        sql.append(" inner join t_bd_accountview v  on v.fid=b.FAccountID \r\n");
        sql.append(" inner join T_bd_Currency cur on cur.fid = b.FCurrencyID  \r\n");
    }

    private void getVerifySrcFrom(StringBuffer sql) {
        sql.append(" from T_GL_AcctCussent a  \r\n");
        sql.append(" left outer join T_GL_Voucher d on a.FVoucherID =d.fid and d.FIsAC = 1 \r\n");
        sql.append(" left outer join T_bd_VoucherTypes vts on vts.fid = d.FVoucherTypeID \r\n");
        sql.append(" inner join t_bd_accountview v on  a.FAccountID = v.fid  \r\n");
        sql.append(" inner join T_bd_Currency cur on cur.fid = a.FCurrencyID  \r\n");
        sql.append(" inner join T_bd_assistanthg hg on a.FassgrpId = hg.fid  \r\n");
        sql.append(" left outer join T_bd_period p on d.FPeriodId = p.fid  \r\n");
        sql.append(" left outer join T_BD_MeasureUnit m on a.FMEASUREUNITID = m.fid  \r\n");
    }

    private Map getHgInfo(Context ctx, String FAssGrpID, String caa) throws BOSException, EASBizException {
        return this.getHgInfos(ctx, FAssGrpID, caa);
    }

    private Map getHgInfos(Context ctx, String FAssGrpID, String caa) throws BOSException, EASBizException {
        HashMap info = new HashMap();
        StringBuffer sql = new StringBuffer();
        sql.append("  select c.fassthgattribute from t_bd_asstaccount a  ");
        sql.append("  inner join t_bd_asstactgroupdetail b on a.fid=b.fasstaccountid ");
        sql.append("  inner join t_bd_asstacttype c on b.fasstacttypeid=c.fid ");
        sql.append("  where a.fid=? ");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{caa});
        IGLGeneralFacade geFacade = GLGeneralFacadeFactory.getLocalInstance(ctx);
        if (set != null) {
            try {
                HashMap<String, String> entry = null;
                while (set.next()) {
                    entry = new HashMap<String, String>();
                    String assgrp = set.getString("fassthgattribute");
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("id", FAssGrpID);
                    param.put("asstribute", assgrp);
                    Map result = geFacade.dealTask("GetDataBaseInfo", param);
                    if (result != null) {
                        DataBaseInfo dabaseInfo = (DataBaseInfo)result.get("DataBaseInfo");
                        entry.put("number", dabaseInfo.getNumber());
                        entry.put("name", dabaseInfo.getName());
                        entry.put("id", (String)dabaseInfo.getId());
                    }
                    info.put(assgrp, entry);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        return info;
    }

    private String getOrderBySql(Map queryCondition, String loc) {
        boolean isSrc;
        String sorterItems = (String)queryCondition.get("sorterItems");
        StringBuffer orderBy = null;
        if (!GlUtils.isEmpty(sorterItems)) {
            String tableType = (String)queryCondition.get("tableType");
            isSrc = false;
            if (this.UP_TABLE.equals(tableType)) {
                isSrc = true;
            }
        } else {
            return null;
        }
        orderBy = this.transSortToSQL(sorterItems, isSrc, loc);
        return orderBy.toString();
    }

    private StringBuffer transSortToSQL(String sorterItems, boolean isSrc, String loc) {
        StringBuffer orderby = new StringBuffer();
        String strOrder = "";
        strOrder = sorterItems;
        if (strOrder.indexOf("bizDate") != -1) {
            strOrder = strOrder.replaceAll("bizDate", "tt.bizDate");
        }
        if (strOrder.indexOf("VARBizDate") != -1) {
            strOrder = strOrder.replaceAll("VARBizDate", "tt.bizDate");
        }
        if (strOrder.indexOf("accountNumber") != -1) {
            strOrder = strOrder.replaceAll("accountNumber", "tt.ACCOUNTNUMBER");
        }
        if (strOrder.indexOf("endDate") != -1) {
            strOrder = strOrder.replaceAll("endDate", "tt.BOOKEDDATE");
        }
        if (strOrder.indexOf("bizNumber") != -1) {
            strOrder = strOrder.replaceAll("bizNumber", "tt.bizNumber");
        }
        if (strOrder.indexOf("originalAmount") != -1) {
            strOrder = strOrder.replaceAll("originalAmount", "tt.originalAmount");
        }
        if (strOrder.indexOf("unVerifiedAmtFor") != -1) {
            if (isSrc) {
                strOrder = strOrder.replaceAll("unVerifiedAmtFor", "tt.unVerifiedAmtFor");
            } else {
                if (strOrder.indexOf("unVerifiedAmtFor ASC") != -1) {
                    strOrder = strOrder.replaceAll("unVerifiedAmtFor ASC,", "");
                }
                if (strOrder.indexOf("unVerifiedAmtFor DESC") != -1) {
                    strOrder = strOrder.replaceAll("unVerifiedAmtFor DESC,", "");
                }
                if (strOrder.indexOf("unVerifiedAmtFor ASC") != -1) {
                    strOrder = strOrder.replaceAll("unVerifiedAmtFor ASC", "");
                }
                if (strOrder.indexOf("unVerifiedAmtFor DESC") != -1) {
                    strOrder = strOrder.replaceAll("unVerifiedAmtFor DESC", "");
                }
            }
        }
        if (strOrder.indexOf("voucherType.name") != -1) {
            strOrder = strOrder.replaceAll("voucherType.name", "tt.VOUCHERTYPE");
        }
        if (strOrder.indexOf("voucher.number") != -1) {
            strOrder = strOrder.replaceAll("voucher.number", "tt.NUMBER");
        }
        if (strOrder.indexOf("id") != -1) {
            strOrder = strOrder.replaceAll("id", "tt.id");
        }
        if ((strOrder = strOrder.trim()).endsWith(",")) {
            strOrder = strOrder.substring(0, strOrder.length() - 1);
        }
        if (!(strOrder = strOrder.trim()).equalsIgnoreCase(" order by")) {
            orderby.append(strOrder).append("  \r\n");
        }
        return orderby;
    }

    private String insertTempTableData(Context ctx, Map queryCondition) throws BOSException, EASBizException {
        String tableType = (String)queryCondition.get("tableType");
        String sql = null;
        String tempTableName = null;
        try {
            String loc = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            if (this.UP_TABLE.equals(tableType)) {
                tempTableName = GLTempTableUtil.createDBSysTempTable(ctx, this.getVerifySrcStruct());
                sql = this.getInsertVerifySrcSql(ctx, queryCondition, tempTableName, loc);
            } else {
                tempTableName = GLTempTableUtil.createDBSysTempTable(ctx, this.getVerifyObjStruct());
                sql = this.getInsertVerifyObjSql(ctx, queryCondition, tempTableName, loc);
            }
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SqlTranslateException e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    private String getVerifySrcStruct() {
        StringBuffer struct = new StringBuffer();
        struct.append("KSQL_SEQ INT IDENTITY (1, 1),");
        struct.append("id varchar(44)");
        return struct.toString();
    }

    private String getInsertVerifySrcSql(Context ctx, Map queryCondition, String tempTableName, String loc) throws BOSException, SQLException, EASBizException, SqlTranslateException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(tempTableName).append(" \r\n");
        insertSql.append("(KSQL_SEQ ,");
        insertSql.append("id )");
        String selectSql = this.getVerifySrcSql(ctx, queryCondition, loc);
        selectSql = KSqlUtil.optimize((String)selectSql);
        insertSql.append(" select tt.id from (").append(selectSql).append(") tt ");
        String orderBySql = this.getOrderBySql(queryCondition, loc);
        if (orderBySql != null) {
            insertSql.append("order by  ").append(orderBySql);
        }
        return insertSql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVerifySrcSql(Context ctx, Map queryCondition, String loc) throws EASBizException, BOSException, SQLException {
        ArrayList returnAL = new ArrayList();
        LinkedTreeMap linkedTreeMap = (LinkedTreeMap)queryCondition.get("customFilter");
        String companyID = "";
        if (linkedTreeMap.get((Object)"selectCompanyId") != null) {
            companyID = linkedTreeMap.get((Object)"selectCompanyId").toString();
        }
        if (linkedTreeMap.get((Object)"COMPANY") != null) {
            companyID = ((CompanyOrgUnitInfo)linkedTreeMap.get((Object)"COMPANY")).getId().toString();
        }
        int verifyMode = GlUtils.getVerifyMode(null, companyID);
        boolean includeReversed = true;
        if (linkedTreeMap.get((Object)"includeReversed") != null) {
            includeReversed = (Boolean)linkedTreeMap.get((Object)"includeReversed");
        }
        String currencyID = null;
        boolean isAllCurrency = false;
        currencyID = ((LinkedTreeMap)linkedTreeMap.get((Object)"currency")).get((Object)"value").toString();
        if (EASResource.getString((String)this.resource, (String)"all_currency").equals(currencyID)) {
            isAllCurrency = true;
        }
        Map<String, String> acctCondMap = this.getAccountId(linkedTreeMap, companyID);
        String accountID = acctCondMap.get("accountId").toString();
        String bizDateFrom = (String)linkedTreeMap.get((Object)"bizDateFrom");
        String begin = null;
        if (!GlUtils.isEmpty(bizDateFrom)) {
            begin = "{ts'" + bizDateFrom + " 00:00:00'}";
        }
        String bizDateTo = (String)linkedTreeMap.get((Object)"bizDateTo");
        String end = null;
        if (!GlUtils.isEmpty(bizDateTo)) {
            end = "{ts'" + bizDateTo + " 00:00:00'}";
        }
        String bizNumber = (String)linkedTreeMap.get((Object)"bizNumber");
        StringBuffer sqlAssistJoin = this.getAssistJoin(linkedTreeMap);
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fid id,' ' voucherid, N' ' voucherType,N' ' Number, a.fvarbizdate bizDate,a.FBizNumber bizNumber,a.FendDate bookedDate,\t\r\n");
        sql.append(" a.FDescription description,v.FDC dc,  \r\n");
        sql.append(" a.FOriginalAmount originalAmount,a.FAssGrpID assGrpID,a.fvchassistrecordid voucherAssistRecordID,\t \r\n");
        sql.append(" a.FUnverifiedAmtFor unverifiedAmtFor,  \r\n");
        sql.append(" a.FUNVERIFIEDQTY UNVERIFIEDQTY,   \r\n");
        sql.append(" m.FName").append(loc).append(" mName,   \r\n");
        sql.append(" v.FNumber accountNumber, \r\n");
        sql.append(" v.FName").append(loc).append(" accountName, \r\n");
        sql.append(" cur.FName").append(loc).append(" currency, \r\n");
        sql.append(" cur.FPrecision").append(" fprecision, \r\n");
        sql.append(" v.FCAA").append(" accountCAA, \r\n");
        sql.append("  null period, \r\n");
        sql.append(" a.FLastUpdateTime as lastUpdateTime \r\n");
        sql.append(" from T_GL_AcctCussent a  \r\n");
        sql.append(" inner join t_bd_accountview v on  a.FAccountID = v.fid \r\n");
        sql.append(" inner join T_bd_Currency cur on cur.fid = a.FCurrencyID  \r\n");
        sql.append(" left outer join T_BD_MeasureUnit m on m.fid=a.FMEASUREUNITID \r\n");
        sql.append(" inner join T_bd_assistanthg hg on a.FassgrpId =hg.fid  \r\n");
        sql.append(sqlAssistJoin);
        sql.append(" \r\n where  a.FUnverifiedAmtFor <> 0 and a.FIsInit=1 \r\n");
        sql.append(" and a.FCompanyID = ? and a.FCurrencyID = ? and a.FAccountID in (").append(accountID).append(") \r\n");
        params.add(companyID);
        params.add(currencyID);
        if (!GlUtils.isEmpty(bizDateFrom)) {
            sql.append(" and a.fvarbizdate >=   ").append(begin);
        }
        if (!GlUtils.isEmpty(bizDateTo)) {
            sql.append(" and a.fvarbizdate <=   ").append(end);
        }
        if (!GlUtils.isEmpty(bizNumber)) {
            sql.append(" and a.FBizNumber like ?  ");
            params.add(bizNumber);
        }
        sql.append(" \r\n");
        sql.append(" union all \r\n");
        this.getVerifySrcSelect(loc, sql);
        sql.append(" from T_GL_AcctCussent a   \r\n");
        sql.append(" inner join T_GL_Voucher d on a.FVoucherID =d.fid and d.FIsAC = 1 \r\n");
        if (!includeReversed) {
            sql.append(" left join t_gl_Voucher rev on d.FSourceBillID = rev.fid  \r\n");
        }
        sql.append(" inner join T_bd_VoucherTypes vts on vts.fid = d.FVoucherTypeID \r\n");
        sql.append(" inner join t_bd_accountview v on  a.FAccountID = v.fid  \r\n");
        sql.append(" inner join T_bd_Currency cur on cur.fid = a.FCurrencyID  \r\n");
        sql.append(" inner join v_gl_acperiod acp on acp.fperiodid=d.fperiodid \r\n");
        sql.append(" inner join t_bd_period p on p.fid=d.fperiodid \r\n");
        sql.append(" left outer join T_BD_MeasureUnit m on m.fid=a.FMEASUREUNITID \r\n");
        sql.append(" inner join T_bd_assistanthg hg on a.FassgrpId = hg.fid  \r\n");
        sql.append(sqlAssistJoin);
        sql.append(" \r\n where a.FUnverifiedAmtFor <> 0 and a.FIsInit=0 \r\n");
        sql.append(" and d.FIsAC = 1 \r\n");
        sql.append(" and a.FCompanyID = ?  and a.FCurrencyID = ? and a.FAccountID  in (").append(accountID).append(") \r\n");
        params.add(companyID);
        params.add(currencyID);
        if (verifyMode == 1) {
            sql.append("and d.fbizstatus = 5");
        } else {
            sql.append("and d.fbizstatus <> 0 and d.fbizstatus <> 2");
        }
        if (!includeReversed) {
            sql.append("and ( d.FIsReverseVoucher = 0 AND d.FHasReversed = 0 OR d.FIsReverseVoucher = 1 AND rev.FHasReversed = 0) \r\n");
        }
        sql.append(" and acp.fcompanyid = ? \r\n");
        params.add(companyID);
        if (!GlUtils.isEmpty(bizDateFrom)) {
            sql.append(" and a.fvarbizdate >=   ").append(begin);
        }
        if (!GlUtils.isEmpty(bizDateTo)) {
            sql.append(" and a.fvarbizdate <=   ").append(end);
        }
        if (!GlUtils.isEmpty(bizNumber)) {
            sql.append(" and a.FBizNumber like ?  ");
            params.add(bizNumber);
        }
        sql.append(" \r\n");
        int dbType = 8;
        try (Connection conn = null;){
            conn = EJBFactory.getConnection((Context)ctx);
            dbType = KSqlUtil.getDbType((Connection)conn);
        }
        return PsSql.getSqlWithParams(sql, params.toArray(), dbType, false);
    }

    private StringBuffer getAssistJoin(LinkedTreeMap linkedTreeMap) {
        StringBuffer sqlAssistJoin = new StringBuffer();
        if (linkedTreeMap.get((Object)"asstActList") != null) {
            ArrayList items = (ArrayList)linkedTreeMap.get((Object)"asstActList");
            for (int i = 0; i < items.size(); ++i) {
                Map item = (Map)items.get(i);
                String tablename = (String)item.get("tableName");
                String field = (String)item.get("hgField");
                String numberfrom = item.get("from") != null ? (String)((Map)item.get("from")).get("number") : null;
                String numberto = item.get("to") != null ? (String)((Map)item.get("to")).get("number") : null;
                Object dist = item.get("dist") != null ? item.get("dist") : null;
                String id = (String)item.get("itemId");
                if (numberfrom != null && numberfrom.equals(numberto) && id == null) {
                    id = (String)((Map)item.get("from")).get("id");
                }
                sqlAssistJoin.append(" inner join ").append(tablename).append(" item").append(i).append(" on ").append(" item").append(i).append(".fid =hg.").append(field);
                if (id != null) {
                    sqlAssistJoin.append(" and").append(" item").append(i).append(".fid='").append(id).append("'\t\t\t\r\n");
                    continue;
                }
                if (numberfrom != null) {
                    sqlAssistJoin.append(" and").append(" item").append(i).append(".fnumber>='").append(numberfrom).append("'\t\t\t\r\n");
                }
                if (numberto != null) {
                    sqlAssistJoin.append(" and").append(" item").append(i).append(".fnumber<='").append(numberto).append("'\t\t\t\r\n");
                }
                if (dist == null) continue;
                StringBuffer nums = new StringBuffer();
                List assists = dist;
                if (assists.size() <= 0) continue;
                sqlAssistJoin.append(" and").append(" item").append(i).append(".fnumber in(");
                for (LinkedTreeMap assist : assists) {
                    nums.append("'").append(assist.get((Object)"number")).append("',");
                }
                nums.deleteCharAt(nums.length() - 1);
                nums.append(") ");
                sqlAssistJoin.append(nums);
            }
        }
        return sqlAssistJoin;
    }

    private Map<String, String> getAccountId(LinkedTreeMap linkedTreeMap, String companyID) throws BOSException {
        HashMap<String, String> accountCondMap = new HashMap<String, String>();
        LinkedTreeMap accountStartMap = (LinkedTreeMap)linkedTreeMap.get((Object)"accountStart");
        LinkedTreeMap accountEndMap = (LinkedTreeMap)linkedTreeMap.get((Object)"accountEnd");
        List discreteAccount = (List)linkedTreeMap.get((Object)"discreteAccount");
        EntityViewInfo accountEV = new EntityViewInfo();
        FilterInfo accountFilter = new FilterInfo();
        accountFilter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyID));
        if (discreteAccount != null && discreteAccount.size() > 0) {
            HashSet idSet = new HashSet();
            for (int i = 0; i < discreteAccount.size(); ++i) {
                Map accountMap = (Map)discreteAccount.get(i);
                idSet.add(accountMap.get("id"));
            }
            accountFilter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        } else if (accountStartMap != null && accountStartMap.get((Object)"number") != null || accountEndMap != null && accountEndMap.get((Object)"number") != null) {
            String accountStart = accountStartMap.get((Object)"number").toString();
            String accountEnd = accountEndMap.get((Object)"number").toString();
            accountFilter.getFilterItems().add(new FilterItemInfo("AC", (Object)1));
            accountFilter.getFilterItems().add(new FilterItemInfo("number", (Object)accountStart, CompareType.GREATER_EQUALS));
            accountFilter.getFilterItems().add(new FilterItemInfo("number", (Object)accountEnd, CompareType.LESS_EQUALS));
        } else {
            accountFilter.getFilterItems().add(new FilterItemInfo("AC", (Object)1));
        }
        accountEV.setFilter(accountFilter);
        AccountViewCollection accountColl = AccountViewFactory.getRemoteInstance().getAccountViewCollection(accountEV);
        StringBuffer accountIdSb = new StringBuffer();
        StringBuffer caaSb = new StringBuffer();
        for (int i = 0; i < accountColl.size(); ++i) {
            if (accountColl.get(i).getCAA() == null) continue;
            if (i == 0) {
                accountIdSb.append("'");
                caaSb.append("'");
            } else {
                accountIdSb.append(",'");
                caaSb.append(",'");
            }
            accountIdSb.append(accountColl.get(i).getId().toString()).append("'");
            caaSb.append(accountColl.get(i).getCAA().getId().toString()).append("'");
        }
        if (accountColl.size() == 0 || accountIdSb.length() == 0) {
            accountIdSb.append("''");
            caaSb.append("''");
        }
        accountCondMap.put("accountId", accountIdSb.toString());
        accountCondMap.put("caaId", caaSb.toString());
        return accountCondMap;
    }

    private String getVerifyObjStruct() {
        StringBuffer struct = new StringBuffer();
        struct.append("KSQL_SEQ INT IDENTITY (1, 1),");
        struct.append("id varchar(44)");
        return struct.toString();
    }

    private String getInsertVerifyObjSql(Context ctx, Map queryCondition, String tempTableName, String loc) throws BOSException, SQLException, SqlTranslateException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(tempTableName).append(" \r\n");
        insertSql.append("(KSQL_SEQ ,");
        insertSql.append("id )");
        String selectSql = this.getVerifyObjSql(ctx, queryCondition, loc);
        selectSql = KSqlUtil.optimize((String)selectSql);
        insertSql.append(" select tt.id from (").append(selectSql).append(") tt ");
        String orderBySql = this.getOrderBySql(queryCondition, loc);
        if (orderBySql != null) {
            insertSql.append("order by  ").append(orderBySql);
        }
        return insertSql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVerifyObjSql(Context ctx, Map queryCondition, String loc) throws SQLException, BOSException {
        ArrayList returnAL = new ArrayList();
        String companyID = "";
        LinkedTreeMap linkedTreeMap = (LinkedTreeMap)queryCondition.get("customFilter");
        if (linkedTreeMap.get((Object)"selectCompanyId") != null) {
            companyID = linkedTreeMap.get((Object)"selectCompanyId").toString();
        }
        if (linkedTreeMap.get((Object)"COMPANY") != null) {
            companyID = ((CompanyOrgUnitInfo)linkedTreeMap.get((Object)"COMPANY")).getId().toString();
        }
        String currencyID = ((LinkedTreeMap)linkedTreeMap.get((Object)"currency")).get((Object)"value").toString();
        Map<String, String> acctCondMap = this.getAccountId(linkedTreeMap, companyID);
        String accountID = acctCondMap.get("accountId");
        String acctCAAId = acctCondMap.get("caaId");
        boolean exclueUnpostVch = true;
        Object objUnpostVch = linkedTreeMap.get((Object)"notIncludeUnpostVch");
        exclueUnpostVch = Boolean.TRUE.equals(objUnpostVch);
        boolean includeReversed = true;
        if (linkedTreeMap.get((Object)"includeReversed") != null) {
            includeReversed = (Boolean)linkedTreeMap.get((Object)"includeReversed");
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        list.add(companyID);
        list.add(currencyID);
        list.add(companyID);
        list.add(companyID);
        list.add(currencyID);
        String bizDateFrom = (String)linkedTreeMap.get((Object)"bizDateFrom");
        String begin = null;
        if (!GlUtils.isEmpty(bizDateFrom)) {
            begin = "{ts'" + bizDateFrom + " 00:00:00'}";
        }
        String bizDateTo = (String)linkedTreeMap.get((Object)"bizDateTo");
        String end = null;
        if (!GlUtils.isEmpty(bizDateTo)) {
            end = "{ts'" + bizDateTo + " 00:00:00'}";
        }
        EntityViewInfo mainQuery = (EntityViewInfo)linkedTreeMap.get((Object)"mainQuery");
        String bizNumber = (String)linkedTreeMap.get((Object)"bizNumber");
        if (!GlUtils.isEmpty(bizNumber)) {
            list.add(bizNumber);
        }
        String verifyAmtSql = " ( SELECT isnull(sum(FOroginalAmount),0) VERIFIEDAMTFOR  \r\n  FROM t_gl_acctcussenthistory his  \r\n  where FCompanyID = ? AND Faccountid  in (" + accountID + ") AND FCurrencyID = ? AND FVoucherAsstIDID = c.fid )  \r\n";
        this.getVerifyObjSelect(loc, verifyAmtSql, sql);
        sql.append(" from t_gl_Voucher a  \r\n");
        if (!includeReversed) {
            sql.append(" left join t_gl_Voucher rev on a.FSourceBillID = rev.fid  \r\n");
        }
        sql.append(" inner join t_bd_vouchertypes vts on vts.fid = a.fvouchertypeid  \r\n");
        sql.append(" inner join t_gl_Voucherentry b on b.FBillID = a.fid    \t\t\t\t\t\t\t\t\t\t\t\r\n  ");
        sql.append(" inner join T_GL_VoucherAssistRecord c on c.FBillID = a.fid  and  c.FEntryID = b.fid  \r\n");
        sql.append(" inner join t_gl_acctverify acv on acv.FVCHASSISTRECORDID = c.fid \r\n");
        sql.append(" inner join T_bd_assistanthg hg on c.FassgrpId =hg.fid     \t\t\t\t\t\t\t\t\t\t\t\r\n  ");
        StringBuffer sqlAssistJoin = this.getAssistJoin(linkedTreeMap);
        sql.append(sqlAssistJoin);
        sql.append(" inner join t_bd_accountview v  on v.fid=b.FAccountID \r\n");
        sql.append(" inner join T_bd_Currency cur on cur.fid = b.FCurrencyID  \r\n");
        sql.append(" inner join v_gl_acperiod acp  on acp.fperiodid=a.fperiodid\t \r\n");
        sql.append(" where a.FIsAC = 1 and b.FIsVerify = 1 and acv.FUnVerifiedAmtFor <> 0 and acv.FIsPost > -1 \r\n ");
        if (exclueUnpostVch) {
            sql.append("and a.fbizstatus = 5 \r\n");
        } else {
            sql.append("and a.fbizstatus <> 0 and a.fbizstatus <> 2 \r\n");
        }
        sql.append("and acp.fcompanyid = ? \r\n");
        sql.append("and a.FCompanyID = ? and b.Faccountid in (").append(accountID).append(") and b.FCurrencyID = ? \r\n");
        if (!includeReversed) {
            sql.append("and ( a.FIsReverseVoucher = 0 AND a.FHasReversed = 0 OR a.FIsReverseVoucher = 1 AND rev.FHasReversed = 0) \r\n");
        }
        if (!GlUtils.isEmpty(bizDateFrom)) {
            sql.append(" and c.FBizDate >=   ").append(begin);
        }
        if (!GlUtils.isEmpty(bizDateTo)) {
            sql.append(" and c.FBizDate <=   ").append(end);
        }
        if (!GlUtils.isEmpty(bizNumber)) {
            sql.append(" and c.FBizNumber like ?   \r\n");
        }
        boolean isFromVoucherUI = false;
        if (linkedTreeMap.get((Object)"isFromVoucherUI") != null) {
            isFromVoucherUI = (Boolean)linkedTreeMap.get((Object)"isFromVoucherUI");
        }
        if (isFromVoucherUI) {
            sql.append(" and c.FOriginalAmount < 0 ");
        } else {
            sql.append(" and c.FOriginalAmount <> 0 ");
        }
        sql.append(" and hg.fasstaccountid in (").append(acctCAAId).append(")  \r\n");
        int dbType = 8;
        try (Connection conn = null;){
            conn = EJBFactory.getConnection((Context)ctx);
            dbType = KSqlUtil.getDbType((Connection)conn);
        }
        return PsSql.getSqlWithParams(sql, list.toArray(), dbType, false);
    }

    private void getVerifyObjSelect(String loc, String verifyAmtSql, StringBuffer sql) {
        sql.append(" select a.fid voucherid,c.fid id,vts.fname_l2 voucherType,a.FNumber Number, c.FBizDate bizDate,c.FBizNumber bizNumber,c.FendDate bookedDate,\t\t \t \r\n \t  ");
        sql.append(" c.FDescription description,b.FEntryDC entryDC,c.FOriginalAmount originalAmount,       \t\t\t \r\n \t  ");
        sql.append(" c.FLocalAmount localAmount,c.FReportingAmount reportingAmount,c.FQuantity quantity,\t\t\t\t \r\n \t  ");
        sql.append(" c.FAssGrpID assGrpID, c.fid voucherAssistRecordID,  \t\t\t\t\t\t\t\t\t\t\t\r\n \t  ");
        sql.append(" a.FLastUpdateTime as lastUpdateTime,  \r\n");
        sql.append(" v.FNumber accountNumber, \r\n");
        sql.append(" v.FName").append(loc).append(" accountName, \r\n");
        sql.append(" cur.FName").append(loc).append(" currency, \r\n");
        sql.append(" cur.FPrecision").append(" fprecision, \r\n");
        sql.append(" v.FCAA").append(" accountCAA, \r\n");
        sql.append(" ").append(verifyAmtSql).append("    VERIFIEDAMTFOR  \r\n");
    }

    private void getVerifySrcSelect(String loc, StringBuffer sql) {
        sql.append("select a.fid id,d.fid voucherid,vts.fname").append(loc).append(" voucherType,d.FNumber number,  \r\n");
        sql.append(" a.fvarbizdate bizDate,a.FBizNumber bizNumber, \r\n");
        sql.append(" a.FendDate bookedDate, a.FDescription description,v.FDC dc, \r\n");
        sql.append(" a.FOriginalAmount originalAmount,a.FAssGrpID assGrpID,a.fvchassistrecordid voucherAssistRecordID, \r\n");
        sql.append(" a.FUnverifiedAmtFor unverifiedAmtFor,   \r\n");
        sql.append(" a.FUNVERIFIEDQTY UNVERIFIEDQTY,   \r\n");
        sql.append(" m.FName").append(loc).append(" mName,   \r\n");
        sql.append(" v.FNumber accountNumber, \r\n");
        sql.append(" v.FName").append(loc).append(" accountName, \r\n");
        sql.append(" cur.FName").append(loc).append(" currency, \r\n");
        sql.append(" cur.FPrecision").append(" fprecision, \r\n");
        sql.append(" v.FCAA").append(" accountCAA, \r\n");
        sql.append(" p.fnumber").append(" period, \r\n");
        sql.append(" a.FLastUpdateTime as lastUpdateTime \r\n");
    }

    @Override
    protected void _releaseTempTable(Context ctx, String tableName) throws BOSException, EASBizException {
        GLTempTableUtil.dropDBSysTempTable(ctx, tableName);
    }

    @Override
    protected List _getAcctCussentDataById(Context ctx, String[] ids, String tableName, String tableType) throws BOSException, EASBizException {
        String loc = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        List records = null;
        if (ids == null) {
            return records;
        }
        int rows = ids.length;
        if (this.UP_TABLE.equals(tableType)) {
            StringBuffer sql = new StringBuffer();
            this.getVerifySrcSelect(loc, sql);
            sql.append(" ,tem.KSQL_SEQ  \r\n");
            this.getVerifySrcFrom(sql);
            sql.append(" inner join ").append(tableName).append(" tem on tem.id = a.fid  \r\n");
            sql.append(" where a.fid in ").append(AcctCussentHistoryFacadeControllerBean.getIdsSql(ids));
            sql.append(" order by tem.KSQL_SEQ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                records = this.dealVerifySrcData(ctx, rows, rs);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        StringBuffer sql = new StringBuffer();
        String verifyAmtSql = " ( SELECT isnull(sum(FOroginalAmount),0) VERIFIEDAMTFOR  \r\n  FROM t_gl_acctcussenthistory his  \r\n  where FVoucherAsstIDID = c.fid )  \r\n";
        this.getVerifyObjSelect(loc, verifyAmtSql, sql);
        sql = new StringBuffer(sql.toString().replace("a.FLastUpdateTime", "acv.FLastUpdateTime"));
        sql.append(" ,tem.KSQL_SEQ  \r\n");
        this.getVerifyObjFrom(sql);
        sql.append(" inner join t_gl_acctverify acv on acv.FVCHASSISTRECORDID = c.fid \r\n");
        sql.append(" inner join ").append(tableName).append(" tem on tem.id = c.fid  \r\n");
        sql.append(" where c.fid in ").append(AcctCussentHistoryFacadeControllerBean.getIdsSql(ids));
        sql.append(" order by tem.KSQL_SEQ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            records = this.dealVerifyObjData(ctx, rows, rs);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return records;
    }

    public static String getIdsSql(String[] ids) {
        if (ids == null) {
            return null;
        }
        if (ids.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            BOSUuid.read((String)ids[i]);
            sb.append("'").append(ids[i]).append("'").append(",");
        }
        if (sb.length() > 0) {
            sb.insert(0, "(");
            sb.setCharAt(sb.length() - 1, ')');
        }
        return sb.toString();
    }

    @Override
    protected Map _sumVerifyAmount(Context ctx, Map queryCondition) throws BOSException {
        String tableType = (String)queryCondition.get("tableType");
        String loc = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String tempTableName = (String)queryCondition.get("tempTableName");
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        if (this.UP_TABLE.equals(tableType)) {
            StringBuffer sql = new StringBuffer();
            sql.append("select sum(FORIGINALAMOUNT) originalAmt,sum(a.FUnverifiedAmtFor) unverifiedAmtFor");
            sql.append(" from T_GL_AcctCussent a  \r\n");
            sql.append(" inner join ").append(tempTableName).append(" tem on tem.id = a.fid  \r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) {
                    BigDecimal originalAmt;
                    BigDecimal unverifiedAmtFor = rs.getBigDecimal("unverifiedAmtFor");
                    if (unverifiedAmtFor == null) {
                        unverifiedAmtFor = BigDecimal.ZERO;
                    }
                    if ((originalAmt = rs.getBigDecimal("originalAmt")) == null) {
                        originalAmt = BigDecimal.ZERO;
                    }
                    resultMap.put("originalAmt", originalAmt);
                    resultMap.put("unverifiedAmtFor", unverifiedAmtFor);
                }
            }
            catch (SQLException e) {
                new BOSException((Throwable)e);
            }
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("select sum(FORIGINALAMOUNT) originalAmt,sum(a.FUnverifiedAmtFor) unverifiedAmtFor");
            sql.append(" from t_gl_acctverify a  \r\n");
            sql.append(" inner join ").append(tempTableName).append(" tem on tem.id = a.FVCHASSISTRECORDID  \r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) {
                    BigDecimal originalAmt;
                    BigDecimal unverifiedAmtFor = rs.getBigDecimal("unverifiedAmtFor");
                    if (unverifiedAmtFor == null) {
                        unverifiedAmtFor = BigDecimal.ZERO;
                    }
                    if ((originalAmt = rs.getBigDecimal("originalAmt")) == null) {
                        originalAmt = BigDecimal.ZERO;
                    }
                    resultMap.put("originalAmt", originalAmt);
                    resultMap.put("unverifiedAmtFor", unverifiedAmtFor);
                }
            }
            catch (SQLException e) {
                new BOSException((Throwable)e);
            }
        }
        return resultMap;
    }

    @Override
    protected void _autoVerifyForTransaction(Context ctx, String companyNumbers, boolean uncheckBizNumber, boolean nullBizNumIsNotSame, boolean notIncludeUnpostVch, boolean amtMustSame, boolean negativeVerify, int dayInterval) throws BOSException, EASBizException {
        this._autoVerifyForTransactionNew(ctx, companyNumbers, uncheckBizNumber, nullBizNumIsNotSame, notIncludeUnpostVch, amtMustSame, false, negativeVerify, dayInterval);
    }

    @Override
    protected void _autoVerifyForTransactionNew(Context ctx, String companyNumbers, boolean uncheckBizNumber, boolean nullBizNumIsNotSame, boolean notIncludeUnpostVch, boolean amtMustSame, boolean verifySameByAmt, boolean negativeVerify, int dayInterval) throws BOSException, EASBizException {
        AcctCussentVerifyService verifyService = new AcctCussentVerifyService();
        verifyService.autoVerifyForTransaction(ctx, companyNumbers, uncheckBizNumber, nullBizNumIsNotSame, notIncludeUnpostVch, amtMustSame, verifySameByAmt, negativeVerify, dayInterval);
    }

    @Override
    protected void _updateCussents(Context ctx, String vchID, int flg) throws BOSException {
        String updateSql = "update t_gl_acctcussent set FisPost = ? where fvoucherid = ?";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{flg, vchID});
        updateSql = "update t_gl_acctverify set FisPost = ? where fvoucherid = ?";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{flg, vchID});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _verifyDetail(Context ctx, Map param) throws BOSException, EASBizException {
        Map map;
        block3: {
            Uuid requestUuid = null;
            try {
                String companyid = (String)param.get("companyid");
                String accountid = (String)param.get("actNumber");
                requestUuid = GLMutexUtils.setAcExclusiveMutex(ctx, companyid, accountid, GLMutexUtils.GL_Verify, logger);
                AutoVerifyService verifyService = new AutoVerifyService();
                map = verifyService.autoVerify(ctx, param);
                if (requestUuid == null) break block3;
            }
            catch (Throwable throwable) {
                if (requestUuid != null) {
                    GLMutexUtils.releaseMutex(ctx, requestUuid);
                }
                throw throwable;
            }
            GLMutexUtils.releaseMutex(ctx, requestUuid);
        }
        return map;
    }

    @Override
    protected Map _checkAcctData(Context ctx, Map param) throws BOSException {
        boolean syncAcctData = param.containsKey("syncAcctData");
        this.dealByGroup = param.containsKey("dealByGroup");
        boolean replenishAcctData = param.containsKey(REPLENISH_ACCTDATA);
        String bookedDate = GlUtils.formatDate((java.util.Date)param.get("bookedDate"));
        this.initScriptParam(ctx);
        ArrayList<String> companyidList = new ArrayList<String>();
        StringBuilder companyFilter = new StringBuilder();
        HashMap<String, String> p = new HashMap<String, String>();
        if (!this.dealByGroup) {
            List allCompanyIds = (List)param.get("companyidList");
            if (!allCompanyIds.isEmpty()) {
                for (int i = 0; i < allCompanyIds.size() && i < this.org_limit; ++i) {
                    companyFilter.append("?,");
                    companyidList.add((String)allCompanyIds.get(i));
                }
                companyFilter.deleteCharAt(companyFilter.lastIndexOf(","));
            }
            p.put("filter", companyFilter.toString());
        }
        String accountid = null;
        AccountViewInfo account = (AccountViewInfo)param.get("account");
        if (account != null && companyidList.size() == 1) {
            accountid = account.getId().toString();
            p.put("account", account.getId().toString());
        }
        ArrayList<String> tempTables = new ArrayList<String>();
        try {
            StringBuilder sqlIn;
            List<String> compayIds;
            String date;
            Map<String, Object> repeatData;
            List<String> glg01OrgList = this.getStartGlG01Orgs(ctx, companyidList, companyFilter);
            if (glg01OrgList.size() > 0) {
                this.clearCslReqDirtyData(ctx, bookedDate, glg01OrgList, accountid);
            }
            if (param.containsKey("checkRepeatData") && (repeatData = this.checkRepeatAcctOrVerifyData(ctx, companyidList, companyFilter, bookedDate)).containsKey("hasRepeat")) {
                repeatData.put("success", false);
                Map<String, Object> map = repeatData;
                return map;
            }
            Map<String, List<String>> periodAndCompanyInfo = this.getAcDateAndCompanyInfo(ctx, companyidList, companyFilter);
            if (param.containsKey("delAcctData")) {
                IObjectPK dealAcctDataLog = LogUtil.beginLog((Context)ctx, (String)"_checkAcctData", (BOSObjectType)BOSObjectType.create((String)bosType), null, (String)EASResource.getString((String)this.resource, (String)"dealAcctDataBeforeAcctPeriod"), (String)"delAcctDataBeforeAcctPeriod");
                for (Map.Entry<String, List<String>> entry : periodAndCompanyInfo.entrySet()) {
                    date = entry.getKey();
                    compayIds = entry.getValue();
                    sqlIn = this.getSqlIn(compayIds);
                    this.delAcctDate(ctx, compayIds, sqlIn, date, accountid);
                }
                LogUtil.afterLog((Context)ctx, (IObjectPK)dealAcctDataLog);
            }
            IObjectPK repairAcctDataLog = null;
            if (replenishAcctData) {
                boolean clearRubbishHistory;
                repairAcctDataLog = LogUtil.beginLog((Context)ctx, (String)"_checkAcctData", (BOSObjectType)BOSObjectType.create((String)bosType), null, (String)EASResource.getString((String)this.resource, (String)REPLENISH_ACCTDATA), (String)REPLENISH_ACCTDATA);
                this.repairSystemStatusAcPeriod(ctx, companyidList, companyFilter);
                this.repairEntryDc(ctx, companyidList, companyFilter);
                for (Map.Entry<String, List<String>> entry : periodAndCompanyInfo.entrySet()) {
                    date = entry.getKey();
                    compayIds = entry.getValue();
                    sqlIn = this.getSqlIn(compayIds);
                    this.replenishAcctData(ctx, compayIds, sqlIn, date, bookedDate);
                }
                if (syncAcctData) {
                    this.deleteAcctData(ctx, companyidList, companyFilter, bookedDate);
                    this.syncAcctDataAbountVch(ctx, companyidList, companyFilter, bookedDate);
                }
                if (clearRubbishHistory = param.containsKey("clearRubbishHistory")) {
                    this.deleteHistoryData(ctx, companyidList, companyFilter, bookedDate);
                }
            } else if (syncAcctData) {
                this.deleteAcctData(ctx, companyidList, companyFilter, bookedDate);
                this.syncAcctDataAbountVch(ctx, companyidList, companyFilter, bookedDate);
            }
            if (param.containsKey("syncHistoryData")) {
                this.syncHistoryData(ctx, p, companyidList, companyFilter, bookedDate);
            }
            if (repairAcctDataLog != null) {
                LogUtil.afterLog((Context)ctx, repairAcctDataLog);
            }
            Map<String, Boolean> result = new HashMap();
            boolean success = true;
            if (param.containsKey("checkHistoryDate")) {
                result = this.checkErrorHistory(ctx, p, companyidList, accountid, bookedDate);
                boolean bl = success = result.containsKey("success") || ((List)result.get("verifyList")).size() <= 0 && ((List)result.get("acctList")).size() <= 0;
            }
            if (param.containsKey("checkInitData")) {
                this.checkInitData(ctx, result, companyidList, companyFilter, accountid);
                if (result.containsKey("initActData") && ((List)result.get("initActData")).size() > 0) {
                    success = false;
                }
            }
            if (param.containsKey("repairInitDataPeriod")) {
                String repairTempTable1 = GLTempTableUtil.createTempTable(ctx, "FKEY VARCHAR(128)");
                tempTables.add(repairTempTable1);
                String repairSql1 = "SELECT flag.FKEY FROM t_gl_flag flag inner join t_bd_period bp on flag.finitperiodid = bp.fid\ninner join\n(\nselect t1.*,bp1.fnumber acPeriodNum from\n(\nSELECT isnull(ssc.FACPERIODID ,ssc.FSTARTPERIODID) acPeriod,ssc.FCOMPANYID  FROM t_bd_systemstatusctrol ssc inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = 6\n where  ssc.FISSTART =1 and ssc.FCOMPANYID  in\n( SELECT item.FORGUNITID  FROM t_bas_paramitem item inner join t_bas_param param on item.FKEYID = param.FID where param.FNUMBER ='GL_028' and item.FVALUE_L2 ='true')\n) t1 inner join t_bd_period bp1 on bp1.FID =t1.acPeriod\n) t\n on flag.forgunitid = t.fcompanyid\n where flag.FNAME ='cussentinit' and bp.FNUMBER=t.acPeriodNum";
                String insertSql1 = "insert into " + repairTempTable1 + " " + repairSql1;
                DbUtil.execute((Context)ctx, (String)insertSql1);
                String repairSql1_1 = "UPDATE T_gl_acctcussent SET FPERIODID ='AAAAAAAAAAAAAAAAAAAAAII4jEw=',fbookeddate=to_date('1970-01-01') WHERE  FISINIT =1 and FACCOUNTID in (select fkey from " + repairTempTable1 + ") and FSOURCEBILLID <> '11111111'";
                DbUtil.execute((Context)ctx, (String)repairSql1_1);
                String repairTempTable2 = GLTempTableUtil.createTempTable(ctx, "FKEY VARCHAR(128),\n  FORGUNITID VARCHAR(128),\n  finitperiodid VARCHAR(128),\n  FBEGINDATE DateTime");
                tempTables.add(repairTempTable2);
                String repairSql2 = "SELECT flag.FKEY,flag.FORGUNITID,flag.finitperiodid,bp.FBEGINDATE FROM t_gl_flag flag inner join t_bd_period bp on flag.finitperiodid = bp.fid\ninner join\n(\nselect t1.*,bp1.fnumber acPeriodNum from\n(\nSELECT isnull(ssc.FACPERIODID ,ssc.FSTARTPERIODID) acPeriod,ssc.FCOMPANYID  FROM t_bd_systemstatusctrol ssc inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = 6\n where  ssc.FISSTART =1 and ssc.FCOMPANYID  in\n( SELECT item.FORGUNITID  FROM t_bas_paramitem item inner join t_bas_param param on item.FKEYID = param.FID where param.FNUMBER ='GL_028' and item.FVALUE_L2 ='true')\n) t1 inner join t_bd_period bp1 on bp1.FID =t1.acPeriod\n) t\n on flag.forgunitid = t.fcompanyid\n where flag.FNAME ='cussentinit' and bp.FNUMBER>t.acPeriodNum";
                String insertSq2 = "insert into " + repairTempTable2 + " " + repairSql2;
                DbUtil.execute((Context)ctx, (String)insertSq2);
                String repairSql2_1 = " UPDATE T_gl_acctcussent a SET (FPERIODID,fbookeddate) =(SELECT b.finitperiodid,b.FBEGINDATE FROM " + repairTempTable2 + " b where a.faccountid = b.fkey) WHERE a.fisinit = 1 and a.FSOURCEBILLID <> '11111111'";
                DbUtil.execute((Context)ctx, (String)repairSql2_1);
            }
            result.put("success", success);
            Map<String, Boolean> map = result;
            return map;
        }
        catch (Exception e) {
            logger.error((Object)"repair acct data error.", (Throwable)e);
            throw new BOSException("repair acct data error.", (Throwable)e);
        }
        finally {
            for (String tempTable : tempTables) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            }
        }
    }

    private void repairSystemStatusAcPeriod(Context ctx, List<String> companyidList, StringBuilder companyFilter) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("update t_bd_systemstatusctrol set FACPERIODID = null where FSTARTPERIODID = FACPERIODID and FID in\n(SELECT ssc.FID  FROM t_bd_systemstatus ss inner join T_BD_SYSTEMSTATUSCTROL ssc on ss.FID = ssc.FSYSTEMSTATUSID where ss.FISCANSTART =1 and ss.FNAME =6 and ssc.FISSTART =1");
        if (companyFilter.length() > 0) {
            sql.append(" and fcompanyid in(").append((CharSequence)companyFilter).append(")");
        }
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
    }

    private void delAcctDate(Context ctx, List<String> compayIds, StringBuilder sqlIn, String date, String accountId) throws BOSException {
        StringBuilder sb = new StringBuilder();
        sb.append("delete FROM T_GL_ACCTCUSSENT acct where not exists (select 1 from T_GL_ACCTCUSSENTHISTORY where acct.fid = FCUSSENTIDID)");
        sb.append(" and acct.fcompanyid in(").append((CharSequence)sqlIn).append(")");
        sb.append(" and acct.fbookeddate<to_date('").append(date).append("')");
        sb.append(" and acct.FISINIT = 0");
        if (!StringUtils.isEmpty((String)accountId)) {
            sb.append(" and acct.FACCOUNTID='").append(accountId).append("'");
        }
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])compayIds.toArray());
        sb.setLength(0);
        sb.append("delete FROM T_GL_Acctverify acct where not exists (select 1 from T_GL_ACCTCUSSENTHISTORY where acct.FVCHASSISTRECORDID  = FVOUCHERASSTIDID)");
        sb.append(" and acct.fcompanyid in(").append((CharSequence)sqlIn).append(")");
        sb.append(" and acct.FBOOKEDDATE<to_date('").append(date).append("')");
        sb.append(" and acct.FISINIT = 0 ");
        if (!StringUtils.isEmpty((String)accountId)) {
            sb.append(" and acct.FACCOUNTID='").append(accountId).append("'");
        }
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])compayIds.toArray());
    }

    private Map<String, Object> checkRepeatAcctOrVerifyData(Context ctx, List<String> companyidList, StringBuilder companyFilter, String bookedDate) throws BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT FVCHASSISTRECORDID fvsid FROM T_GL_ACCTCUSSENT where 1=1");
        if (companyFilter.length() > 0) {
            sql.append(" and fcompanyid in(").append((CharSequence)companyFilter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            sql.append(" and fbookeddate<=to_date('").append(bookedDate).append("')");
        }
        sql.append(" group by FVCHASSISTRECORDID having count(1)>1");
        StringBuilder querySql = new StringBuilder();
        querySql.append("select acct.fid id,com.FNUMBER||' '||com.fname_l2 company, av.fnumber||' '||av.fname_l2 account,TO_CHAR(acct.fbookedDate,'YYYY-MM-DD') bookedDate,acct.FVchNumber vchnumber,acct.FOriginalAmount oriamt,acct.FUnVerifiedAmtFor unveriamt,av.fid accountid,com.fid companyid,acct.FVCHASSISTRECORDID vsid from T_GL_ACCTCUSSENT acct  inner join t_bd_accountview av on av.fid = acct.FACCOUNTID  inner join t_org_company com on av.fcompanyid = com.fid ");
        querySql.append(" where acct.FVCHASSISTRECORDID in(").append(sqlInChar).append(")");
        try {
            String type1 = EASResource.getString((String)sourceUrl, (String)"TYPE_CUSSENT", (Locale)ctx.getLocale());
            String type2 = EASResource.getString((String)sourceUrl, (String)"TYPE_VERIFY", (Locale)ctx.getLocale());
            String cause1 = EASResource.getString((String)sourceUrl, (String)"repeatAcctData", (Locale)ctx.getLocale());
            String cause2 = EASResource.getString((String)sourceUrl, (String)"repeatVerifyData", (Locale)ctx.getLocale());
            String[] keys = new String[]{"company", "account", "bookedDate", "vchnumber", "oriamt", "unveriamt", "type", "cause", "vsid", "id"};
            result.put("repeatDataKeys", keys);
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
            ArrayList<String> repeatAsstVchIds = new ArrayList<String>();
            while (rs1.next()) {
                String vsid = rs1.getString("fvsid");
                repeatAsstVchIds.add(vsid);
            }
            IRowSet rs = null;
            if (repeatAsstVchIds.size() > 0) {
                StringBuilder sqlIn = this.getSqlIn(repeatAsstVchIds);
                String eSql = querySql.toString().replace(sqlInChar, sqlIn.toString());
                rs = DbUtil.executeQuery((Context)ctx, (String)eSql, (Object[])repeatAsstVchIds.toArray());
            }
            ArrayList cussentList = new ArrayList();
            this.putDataToList(rs, cussentList, keys, type1, cause1);
            result.put("repeatAcctList", cussentList);
            IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString().replace("T_GL_ACCTCUSSENT", "T_GL_ACCTVERIFY"), (Object[])companyidList.toArray());
            repeatAsstVchIds.clear();
            while (rs2.next()) {
                String vsid = rs2.getString("fvsid");
                repeatAsstVchIds.add(vsid);
            }
            if (repeatAsstVchIds.size() > 0) {
                StringBuilder sqlIn = this.getSqlIn(repeatAsstVchIds);
                String eSql = querySql.toString().replace("T_GL_ACCTCUSSENT", "T_GL_ACCTVERIFY").replace(sqlInChar, sqlIn);
                rs = DbUtil.executeQuery((Context)ctx, (String)eSql, (Object[])repeatAsstVchIds.toArray());
            }
            ArrayList verifyList = new ArrayList();
            this.putDataToList(rs, verifyList, keys, type2, cause2);
            result.put("repeatVerifyList", verifyList);
            if (cussentList.size() > 0 || verifyList.size() > 0) {
                result.put("hasRepeat", true);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"excute sql error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private List<String> getStartGlG01Orgs(Context ctx, List<String> companyidList, StringBuilder companyFilter) throws BOSException, SQLException {
        ArrayList<String> glg01OrgList = new ArrayList<String>();
        StringBuilder sql = new StringBuilder("SELECT paramItem.FORGUNITID FROM T_BAS_PARAM param inner join T_BAS_PARAMITEM paramItem on param.FID = paramItem.FKEYID where FNUMBER ='GLG01' and paramItem.FVALUE_L2 ='true'");
        if (companyFilter.length() > 0) {
            sql.append(" and paramItem.FORGUNITID in(").append((CharSequence)companyFilter).append(")");
        }
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
        while (result.next()) {
            glg01OrgList.add(result.getString(1));
        }
        return glg01OrgList;
    }

    private void clearCslReqDirtyData(Context ctx, String bookedDate, List<String> companyidList, String accountid) throws BOSException, SQLException {
        StringBuilder companyFilter = this.getSqlIn(companyidList);
        StringBuilder clearReqSql = new StringBuilder();
        clearReqSql.append("SELECT req.FID reqId,reqe.FID reqeId FROM T_CSL_REQUISITION req inner join T_CSL_REQUISITIONENTRY reqe on req.FID = reqe.FREQUISITIONID left join T_GL_VOUCHERASSISTRECORD vchAsst on reqe.FASSISTRECORDID = vchAsst.FID \nwhere vchAsst.FID is null");
        if (companyFilter.length() > 0) {
            clearReqSql.append(" and req.FSRCCOMPANYID in(").append((CharSequence)companyFilter).append(")");
        }
        if (!StringUtils.isEmpty((String)accountid)) {
            clearReqSql.append(" and reqe.faccountid ='").append(accountid).append("'");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            clearReqSql.append(" and req.FCREATETIME<=to_date('").append(bookedDate).append("')");
        }
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)clearReqSql.toString(), (Object[])companyidList.toArray());
        ArrayList<String> reqIds = new ArrayList<String>();
        ArrayList<String> reqeIds = new ArrayList<String>();
        while (result.next()) {
            String reqId = result.getString("reqId");
            String reqeId = result.getString("reqeId");
            reqIds.add(reqId);
            reqeIds.add(reqeId);
        }
        if (reqeIds.size() > 0) {
            clearReqSql.setLength(0);
            StringBuilder reqeIdSqlIn = this.getSqlIn(reqeIds);
            clearReqSql.append("DELETE FROM T_CSL_REQUISITIONENTRY WHERE fid in(").append((CharSequence)reqeIdSqlIn).append(")");
            DbUtil.execute((Context)ctx, (String)clearReqSql.toString(), (Object[])reqeIds.toArray());
        }
        if (reqIds.size() > 0) {
            clearReqSql.setLength(0);
            StringBuilder reqIdSqlIn = this.getSqlIn(reqIds);
            clearReqSql.append("DELETE FROM T_CSL_REQUISITION WHERE fid in(").append((CharSequence)reqIdSqlIn).append(")");
            DbUtil.execute((Context)ctx, (String)clearReqSql.toString(), (Object[])reqIds.toArray());
        }
    }

    private void initScriptParam(Context ctx) throws BOSException {
        String sql = "select FSQLTEXT from T_GL_REPAIR where FFUNCTION = 'org_limit' and FISIGNORE = 0";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                sql = rs.getString("FSQLTEXT");
                this.org_limit = new Integer(sql);
            }
            this.org_limit = this.org_limit <= 0 ? 10 : (this.org_limit > 100 ? 100 : this.org_limit);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkInitData(Context ctx, Map result, List<String> companyidList, StringBuilder filter, String accountid) throws BOSException {
        ArrayList list;
        String acctInitBalTmp;
        String assistBalTmp;
        String accountIdTempTable;
        block31: {
            Connection cn = null;
            StringBuilder sql = new StringBuilder();
            ArrayList<String> companyIds = new ArrayList<String>();
            HashSet<String> periodIdSet = new HashSet<String>();
            try {
                HashMap<String, Date> acctRefMap = new HashMap<String, Date>();
                sql.append("SELECT fcompanyid companyid,max(bp.FBEGINDATE) beginDate  FROM T_BD_AcctRefContrast arc inner join T_BD_PERIOD bp on bp.FID = arc.FENABLEDPERIODID  where FISENABLED =1 ");
                if (filter.length() > 0) {
                    sql.append(" and fcompanyid in(").append((CharSequence)filter).append(")");
                }
                sql.append(" group by fcompanyid");
                IRowSet queryResult1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
                while (queryResult1.next()) {
                    String company = queryResult1.getString("companyid");
                    Date beginDate = queryResult1.getDate("beginDate");
                    acctRefMap.put(company, beginDate);
                }
                sql.setLength(0);
                sql.append("SELECT a.company companyid,bp.FBEGINDATE beginDate,bp.fid periodId FROM T_BD_PERIOD bp inner join \n(SELECT case when ssc.FACPERIODID is null then ssc.FSTARTPERIODID else ssc.FACPERIODID end period,ssc.FCOMPANYID company  FROM T_BD_SYSTEMSTATUS ss inner join T_BD_SYSTEMSTATUSCTROL ssc on ss.FID = ssc.FSYSTEMSTATUSID where ss.FNAME =6 and ssc.FISSTART =1 ");
                if (filter.length() > 0) {
                    sql.append(" and ssc.FCOMPANYID in(").append((CharSequence)filter).append(")");
                }
                sql.append(") a on a.period = bp.fid ");
                IRowSet queryResult2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
                while (queryResult2.next()) {
                    String company = queryResult2.getString("companyid");
                    Date beginDate = queryResult2.getDate("beginDate");
                    if (acctRefMap.containsKey(company) && ((java.util.Date)acctRefMap.get(company)).compareTo(beginDate) > 0) continue;
                    companyIds.add(company);
                    periodIdSet.add(queryResult2.getString("periodId"));
                }
                sql.setLength(0);
            }
            catch (SQLException e1) {
                logger.error((Object)"execute sql error.", (Throwable)e1);
                throw new BOSException((Throwable)e1);
            }
            StringBuilder sqlFilter = new StringBuilder();
            accountIdTempTable = null;
            if (companyIds.size() <= 0) return;
            for (String id : companyIds) {
                sqlFilter.append("?,");
            }
            sqlFilter.deleteCharAt(sqlFilter.length() - 1);
            filter = sqlFilter;
            if (periodIdSet.size() > 0) {
                accountIdTempTable = this.getChangeAsstAccountInACPeriod(ctx, companyIds, periodIdSet);
            }
            sql.append("select bal.FORGUNITID, bal.FACCOUNTID , bal.FCURRENCYID,bal.FASSISTGRPID fasstgrpid,av.FDC,sum(bal.FBEGINBALANCEFOR)*av.fdc amt  into TMP_BAL from T_GL_ASSISTBALANCE  bal  \n inner join T_BD_ACCOUNTVIEW av on av.fid = bal.faccountid \n inner join T_GL_FLAG f on f.FORGUNITID = bal.FORGUNITID and f.FKEY = bal.FACCOUNTID and f.finitperiodid = bal.FPERIODID \n where f.FNAME = 'cussentinit' and f.FVALUE = 'true'\n and bal.FCURRENCYID <> '11111111-1111-1111-1111-111111111111DEB58FDC'\n and bal.FCURRENCYID <> '22222222-2222-2222-2222-222222222222DEB58FDC'\n and av.FCAA is not null and av.FAC = 1 and av.fid=f.fkey\n and bal.fbaltype = 1\n");
            if (filter.length() > 0) {
                sql.append(" and bal.FORGUNITID in(").append((CharSequence)filter).append(")");
            }
            if (accountIdTempTable != null) {
                sql.append(" and av.fid not in (select fid from ").append(accountIdTempTable).append(")");
            }
            if (!StringUtils.isEmpty((String)accountid)) {
                sql.append(" and av.fid ='").append(accountid).append("'");
            }
            sql.append(" group by bal.FORGUNITID, bal.FACCOUNTID, bal.FCURRENCYID ,bal.FASSISTGRPID,av.FDC having sum(bal.FBEGINBALANCEFOR) <> 0");
            assistBalTmp = null;
            acctInitBalTmp = null;
            list = new ArrayList();
            try {
                cn = EJBFactory.getConnection((Context)ctx);
                SqlParams sqlParams = new SqlParams();
                for (int j = 0; j < companyIds.size(); ++j) {
                    sqlParams.addObject(companyIds.get(j));
                }
                assistBalTmp = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sqlParams, (Connection)cn).getTempTable();
                sql.setLength(0);
                sql.append("SELECT acct.FCOMPANYID, acct.FACCOUNTID, acct.FCURRENCYID, acct.FASSGRPID,sum(acct.FORIGINALAMOUNT) amt,av.fdc INTO TMP_ACCT\nFROM t_GL_AcctCussent acct\n inner join t_bd_accountview av on av.fid = acct.faccountid \n where acct.FISINIT = 1 and acct.FISINITCLOSED = 1 ");
                if (filter.length() > 0) {
                    sql.append(" and acct.FCOMPANYID in(").append((CharSequence)filter).append(")");
                }
                if (!StringUtils.isEmpty((String)accountid)) {
                    sql.append(" and acct.FACCOUNTID ='").append(accountid).append("'");
                }
                if (accountIdTempTable != null) {
                    sql.append(" and av.fid not in (select fid from ").append(accountIdTempTable).append(")");
                }
                sql.append(" and (acct.fsourcebillid is null or acct.fsourcebillid <>'11111111')");
                sql.append(" group by acct.FCOMPANYID, acct.FACCOUNTID, acct.FCURRENCYID,acct.FASSGRPID,av.FDC ");
                acctInitBalTmp = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sqlParams, (Connection)cn).getTempTable();
                sql.setLength(0);
                sql.append("select t.FORGUNITID companyid,o.fname_l2 company, t.FACCOUNTID accountid, acv.fnumber||' '||acv.fname_l2 account,t.fdc dc,t.FCURRENCYID currencyid,t.fasstgrpid asstgrpid, c.fnumber || ' ' || c.fname_l2 curName, t.amt bal, a.amt amt,1 type ");
                sql.append(",hg.FLONGNAMEGROUP_").append(ctx.getLocale()).append(" asstgrpname");
                sql.append(" from ").append(assistBalTmp).append(" t left join ").append(acctInitBalTmp).append(" a on t.FORGUNITID = a.FCOMPANYID and t.FACCOUNTID = a.FACCOUNTID and t.FCURRENCYID = a.FCURRENCYID  and t.fasstgrpid = a.FASSGRPID \ninner join T_ORG_COMPANY o on o.fid = t.FORGUNITID \ninner join T_BD_CURRENCY C on C.fid = t.FCURRENCYID \ninner join t_bd_accountview acv on acv.fid = t.FACCOUNTID \ninner join t_bd_assistanthg hg on hg.fid = t.fasstgrpid \nwhere t.amt <> 0 and t.amt <> a.amt\n UNION \n");
                sql.append("select t.FCOMPANYID companyid,o.fname_l2 company, t.FACCOUNTID accountid, acv.fnumber||' '||acv.fname_l2 account,t.fdc dc,t.FCURRENCYID currencyid,t.FASSGRPID asstgrpid, c.fnumber || ' ' || c.fname_l2 curName, a.amt bal, t.amt amt,1 type ");
                sql.append(",hg.FLONGNAMEGROUP_").append(ctx.getLocale()).append(" asstgrpname");
                sql.append(" from ").append(acctInitBalTmp).append(" t left join ").append(assistBalTmp).append(" a on a.FORGUNITID = t.FCOMPANYID and t.FACCOUNTID = a.FACCOUNTID and t.FCURRENCYID = a.FCURRENCYID  and a.fasstgrpid = t.FASSGRPID \ninner join T_ORG_COMPANY o on o.fid = t.FCOMPANYID \ninner join T_BD_CURRENCY C on C.fid = t.FCURRENCYID \ninner join t_bd_accountview acv on acv.fid = t.FACCOUNTID \ninner join t_bd_assistanthg hg on hg.fid = t.FASSGRPID \nwhere t.amt <> 0 and a.amt IS NULL\n UNION \n");
                sql.append("select t.FORGUNITID companyid,o.fname_l2 company, t.FACCOUNTID accountid,acv.fnumber||' '||acv.fname_l2 account,t.fdc dc, t.FCURRENCYID currencyid,t.fasstgrpid asstgrpid,c.fnumber || ' ' || c.fname_l2 curName, t.amt bal, a.amt amt, 2 type \n");
                sql.append(",hg.FLONGNAMEGROUP_").append(ctx.getLocale()).append(" asstgrpname");
                sql.append(" from ").append(assistBalTmp).append(" t left join ").append(acctInitBalTmp).append(" a on t.FORGUNITID = a.FCOMPANYID and t.FACCOUNTID = a.FACCOUNTID and t.FCURRENCYID = a.FCURRENCYID and t.fasstgrpid = a.FASSGRPID \ninner join T_ORG_COMPANY o on o.fid = t.FORGUNITID \ninner join T_BD_CURRENCY C on C.fid = t.FCURRENCYID \ninner join t_bd_accountview acv on acv.fid = t.FACCOUNTID \ninner join t_bd_assistanthg hg on hg.fid = t.fasstgrpid \nwhere t.amt <> 0 and a.amt IS NULL");
                IRowSet result3 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                String cause1 = EASResource.getString((String)sourceUrl, (String)"ACCT_INIT_DATA_ERROR1", (Locale)ctx.getLocale());
                String cause2 = EASResource.getString((String)sourceUrl, (String)"ACCT_INIT_DATA_ERROR2", (Locale)ctx.getLocale());
                while (result3.next()) {
                    HashMap<String, Object> item = new HashMap<String, Object>();
                    item.put("companyid", result3.getString("companyid"));
                    item.put("company", result3.getString("company"));
                    item.put("accountid", result3.getString("accountid"));
                    item.put("account", result3.getString("account"));
                    item.put("currencyid", result3.getString("currencyid"));
                    item.put("currency", result3.getString("curName"));
                    item.put("asstgrpid", result3.getString("asstgrpid"));
                    item.put("asstgrpname", result3.getString("asstgrpname"));
                    BigDecimal bal = result3.getBigDecimal("bal") == null ? BigDecimal.ZERO : result3.getBigDecimal("bal");
                    BigDecimal amt = result3.getBigDecimal("amt") == null ? BigDecimal.ZERO : result3.getBigDecimal("amt");
                    item.put("bal", bal);
                    item.put("amt", amt);
                    item.put("adjamt", bal.subtract(amt));
                    item.put("omt", bal.subtract(amt));
                    item.put("type", result3.getInt("type"));
                    item.put("cause", result3.getInt("type") == 2 ? cause2 : cause1);
                    list.add(item);
                }
                sql.setLength(0);
                if (cn == null) break block31;
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (cn != null) {
                        try {
                            cn.close();
                        }
                        catch (SQLException e2) {
                            logger.error((Object)"close connection error.", (Throwable)e2);
                        }
                    }
                    TempTablePool iPool2 = TempTablePool.getInstance((Context)ctx);
                    if (assistBalTmp != null) {
                        iPool2.releaseTable(assistBalTmp);
                    }
                    if (acctInitBalTmp != null) {
                        iPool2.releaseTable(acctInitBalTmp);
                    }
                    if (accountIdTempTable != null) {
                        iPool2.releaseTable(accountIdTempTable);
                    }
                    throw throwable;
                }
            }
            try {
                cn.close();
            }
            catch (SQLException e) {
                logger.error((Object)"close connection error.", (Throwable)e);
            }
        }
        TempTablePool iPool = TempTablePool.getInstance((Context)ctx);
        if (assistBalTmp != null) {
            iPool.releaseTable(assistBalTmp);
        }
        if (acctInitBalTmp != null) {
            iPool.releaseTable(acctInitBalTmp);
        }
        if (accountIdTempTable != null) {
            iPool.releaseTable(accountIdTempTable);
        }
        String[] keys = new String[]{"companyid", "company", "accountid", "account", "currencyid", "currency", "asstgrpid", "asstgrpname", "bal", "amt", "adjamt", "omt", "type", "cause"};
        result.put("initActDataKeys", keys);
        result.put("initActData", list);
    }

    private String getChangeAsstAccountInACPeriod(Context ctx, List<String> companyIds, Set<String> periodIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("period.id", periodIdSet, CompareType.INCLUDE));
        filter1.getFilterItems().add(new FilterItemInfo("account.companyID.id", new HashSet<String>(companyIds), CompareType.INCLUDE));
        view.setFilter(filter1);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("account.id");
        view.setSelector(selector);
        ArrayList<String> accountIds = new ArrayList<String>();
        AsstAccountChangeCollection changess = AsstAccountChangeFactory.getLocalInstance((Context)ctx).getAsstAccountChangeCollection(view);
        String accountIdTempTable = null;
        if (changess != null && changess.size() > 0) {
            for (int i = 0; i < changess.size(); ++i) {
                accountIds.add(changess.get(i).getAccount().getId().toString());
            }
            String createTableSql = "create table ac_temp_table (fid varchar(44))";
            try {
                accountIdTempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
                String insertSql = "insert into " + accountIdTempTable + " values(?)";
                ArrayList<String[]> paramsList = new ArrayList<String[]>();
                for (Object e : accountIds) {
                    paramsList.add(new String[]{e.toString()});
                }
                DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
            }
            catch (Exception e) {
                logger.error((Object)"create tempTable error.", (Throwable)e);
            }
        }
        return accountIdTempTable;
    }

    private void checkInitData1(Context ctx, Map result, List<String> companyidList, StringBuilder filter) throws BOSException {
        String filterStr = "";
        if (companyidList.size() > 0) {
            filterStr = " and FORGUNITID in(" + filter + ")";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select t.FORGUNITID,o.fname_l2 company, t.FACCOUNTID,av.fnumber || ' ' || av.fname_l2 account, t.FCURRENCYID, c.fnumber || ' ' || c.fname_l2 curName, t.amt bal, a.amt omt  ");
        sql.append("from ( ");
        sql.append("\tselect FORGUNITID, FACCOUNTID, FCURRENCYID, sum(FBEGINBALANCEFOR) amt   ");
        sql.append("\tfrom T_GL_InitAssistBalance where 1 = 1 ").append(filterStr).append(" group by FORGUNITID, FACCOUNTID, FCURRENCYID ");
        sql.append(") t left join ( ");
        sql.append("\tSELECT FCOMPANYID, FACCOUNTID, FCURRENCYID, sum(FORIGINALAMOUNT) amt  ");
        if (companyidList.size() > 0) {
            filterStr = " and FCOMPANYID in(" + filter + ")";
        }
        sql.append("\tFROM t_GL_AcctCussent where FISINIT = 1 and FISINITCLOSED = 1 ").append(filterStr).append(" group by FCOMPANYID, FACCOUNTID, FCURRENCYID   ");
        sql.append(") a on t.FORGUNITID = a.FCOMPANYID and t.FACCOUNTID = a.FACCOUNTID and t.FCURRENCYID = a.FCURRENCYID ");
        sql.append("inner join T_BD_ACCOUNTVIEW av on av.fid = t.faccountid ");
        sql.append("inner join T_ORG_COMPANY o on o.fid = t.FORGUNITID ");
        sql.append("inner join T_BD_CURRENCY C on C.fid = t.FCURRENCYID ");
        sql.append(" where t.amt <> a.amt and av.FCAA is not null and av.FAC = 1 ");
        String[] keys = new String[]{"company", "account", "currency", "cause"};
        ArrayList<String> param = new ArrayList<String>();
        param.addAll(companyidList);
        param.addAll(companyidList);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        ArrayList list = new ArrayList();
        try {
            String cause = EASResource.getString((String)sourceUrl, (String)"ACCT_INIT_DATA_WARN", (Locale)ctx.getLocale());
            while (rs.next()) {
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("company", rs.getString("company"));
                item.put("account", rs.getString("account"));
                item.put("currency", rs.getString("curName"));
                item.put("cause", cause);
                list.add(item);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        result.put("initActDataKeys", keys);
        result.put("initActData", list);
    }

    private void syncData(Context ctx, List<String> companyidList, String filter) throws BOSException {
        String sql = "select * from T_GL_REPAIR where FFUNCTION = 'sync_voucher' and FISIGNORE = 0 order by fseq ";
        int seq = 0;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            String paramStr = null;
            String[] params = null;
            while (rs.next()) {
                seq = rs.getInt("FSEQ");
                sql = rs.getString("FSQLTEXT");
                paramStr = rs.getString("FPARAMS");
                if (!StringUtils.isEmpty((String)paramStr)) {
                    params = paramStr.split(",");
                    for (int i = 0; i < params.length; ++i) {
                        sql.replace("@param" + i, params[i]);
                    }
                }
                if (filter != null) {
                    sql = sql + "AND FCOMPANYID IN(" + filter + ")";
                }
                DbUtil.execute((Context)ctx, (String)sql, (Object[])companyidList.toArray());
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql.seq:" + seq + "  " + e.getMessage());
        }
    }

    private void syncAcctDataAbountVch(Context ctx, List<String> companyidList, StringBuilder filter, String bookedDate) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE T_GL_ACCTCUSSENT SET FASSGRPID =  (SELECT t.FASSGRPID FROM T_GL_VOUCHERASSISTRECORD t where t.FID = FVCHASSISTRECORDID) WHERE FID IN( SELECT t.FID FROM T_GL_ACCTCUSSENT t inner join T_GL_VOUCHERASSISTRECORD s ON T.FVCHASSISTRECORDID = S.FID where t.FASSGRPID <> s.FASSGRPID ");
        if (filter.length() > 0) {
            sql.append(" and t.fcompanyid in(").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            sql.append(" and t.fbookeddate<=to_date('").append(bookedDate).append("')");
        }
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
        sql.setLength(0);
        sql.append("UPDATE T_GL_ACCTVERIFY SET FASSGRPID =  (SELECT t.FASSGRPID FROM T_GL_VOUCHERASSISTRECORD t where t.FID = FVCHASSISTRECORDID) WHERE FID IN( SELECT t.FID FROM T_GL_ACCTVERIFY t inner join T_GL_VOUCHERASSISTRECORD s ON T.FVCHASSISTRECORDID = S.FID  where t.FASSGRPID <> s.FASSGRPID ");
        if (filter.length() > 0) {
            sql.append("and t.fcompanyid in(").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            sql.append(" and t.fbookeddate<=to_date('").append(bookedDate).append("')");
        }
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
        sql.setLength(0);
        sql.append("UPDATE T_GL_ACCTCUSSENT SET FORIGINALAMOUNT =  (SELECT t.FORIGINALAMOUNT FROM T_GL_VOUCHERASSISTRECORD t where t.FID = FVCHASSISTRECORDID)  WHERE FID IN( SELECT t.FID FROM T_GL_ACCTCUSSENT t inner join T_GL_VOUCHERASSISTRECORD s ON T.FVCHASSISTRECORDID = S.FID  where t.FORIGINALAMOUNT <> s.FORIGINALAMOUNT ");
        if (filter.length() > 0) {
            sql.append("and t.fcompanyid in(").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            sql.append(" and t.fbookeddate<=to_date('").append(bookedDate).append("')");
        }
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
        sql.setLength(0);
        sql.append("UPDATE T_GL_ACCTVERIFY SET FORIGINALAMOUNT =  (SELECT t.FORIGINALAMOUNT FROM T_GL_VOUCHERASSISTRECORD t where t.FID = FVCHASSISTRECORDID)  WHERE FID IN( SELECT t.FID FROM T_GL_ACCTVERIFY t inner join T_GL_VOUCHERASSISTRECORD s ON T.FVCHASSISTRECORDID = S.FID  where t.FORIGINALAMOUNT <> s.FORIGINALAMOUNT ");
        if (filter.length() > 0) {
            sql.append("and t.fcompanyid in(").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            sql.append(" and t.fbookeddate<=to_date('").append(bookedDate).append("')");
        }
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
        sql.setLength(0);
        sql.append("UPDATE T_GL_ACCTCUSSENT SET FBOOKEDDATE = (SELECT t.FBOOKEDDATE FROM T_GL_VOUCHER t where t.FID = FVOUCHERID)  WHERE FID IN(SELECT t.FID FROM T_GL_ACCTCUSSENT t inner join T_GL_VOUCHER s ON T.FVOUCHERID = S.FID where t.FBOOKEDDATE <> s.FBOOKEDDATE and t.FISINIT = 0 ");
        if (filter.length() > 0) {
            sql.append("and t.fcompanyid in(").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            sql.append(" and t.fbookeddate<=to_date('").append(bookedDate).append("')");
        }
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
        sql.setLength(0);
        sql.append("UPDATE T_GL_ACCTVERIFY SET FBOOKEDDATE = (SELECT t.FBOOKEDDATE FROM T_GL_VOUCHER t where t.FID = FVOUCHERID) WHERE FID IN(SELECT t.FID FROM T_GL_ACCTVERIFY t inner join T_GL_VOUCHER s ON T.FVOUCHERID = S.FID where t.FBOOKEDDATE <> s.FBOOKEDDATE ");
        if (filter.length() > 0) {
            sql.append(" and t.fcompanyid in(").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            sql.append(" and t.fbookeddate<=to_date('").append(bookedDate).append("')");
        }
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
        sql.setLength(0);
        sql.append("update t_gl_acctcussent set fispost =  (SELECT case when t.fbizstatus=5 then 1 else 0 end  FROM T_GL_VOUCHER t where t.FID = FVOUCHERID)  where fisinit = 0 ");
        if (filter.length() > 0) {
            sql.append("and FCOMPANYID in(").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            sql.append(" and fbookeddate<=to_date('").append(bookedDate).append("')");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
        sql.setLength(0);
        sql.append("update t_gl_acctverify set fispost =  (SELECT case when t.fbizstatus=5 then 1 else 0 end  FROM T_GL_VOUCHER t where t.FID = FVOUCHERID)  where fisinit = 0 ");
        if (filter.length() > 0) {
            sql.append("and FCOMPANYID in(").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            sql.append(" and fbookeddate<=to_date('").append(bookedDate).append("')");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
        sql.setLength(0);
        this.repairVchTypeAndVchNumber(ctx, companyidList, filter, bookedDate, new String[]{"t_gl_acctcussent", "t_gl_acctverify"}, sql);
        boolean executeConfigSql = false;
        String configSql = "select * from T_GL_REPAIR where FFUNCTION = 'sync_voucher' and FISIGNORE = 0 order by fseq ";
        int seq = 0;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)configSql);
        try {
            String paramStr = null;
            while (rs.next() && executeConfigSql) {
                seq = rs.getInt("FSEQ");
                configSql = rs.getString("FSQLTEXT");
                if (filter.length() == 0) {
                    configSql = configSql.replace("@param", "");
                    DbUtil.execute((Context)ctx, (String)configSql);
                    continue;
                }
                paramStr = rs.getString("FPARAMS");
                if (!StringUtils.isEmpty((String)paramStr)) {
                    paramStr = paramStr.replace("@value", filter);
                    configSql = configSql.replace("@param", paramStr);
                    DbUtil.execute((Context)ctx, (String)configSql, (Object[])companyidList.toArray());
                    continue;
                }
                DbUtil.execute((Context)ctx, (String)configSql);
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql.seq:" + seq + "  " + e.getMessage());
        }
    }

    private void repairVchTypeAndVchNumber(Context ctx, List<String> companyidList, StringBuilder filter, String bookedDate, String[] tableNames, StringBuilder sql) throws BOSException {
        sql.setLength(0);
        for (String tableName : tableNames) {
            sql.append("update ").append(tableName).append(" set fvouchertypeid =  (SELECT t.FVoucherTypeId FROM T_GL_VOUCHER t where t.FID = FVOUCHERID)  where FVoucherTypeId is null ");
            if (filter.length() > 0) {
                sql.append("and FCOMPANYID in(").append((CharSequence)filter).append(")");
            }
            if (!StringUtils.isEmpty((String)bookedDate)) {
                sql.append(" and fbookeddate<=to_date('").append(bookedDate).append("')");
            }
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
            sql.setLength(0);
            sql.append("update ").append(tableName).append(" set fvchnumber =  (SELECT t.fnumber FROM T_GL_VOUCHER t where t.FID = FVOUCHERID)  where fvchnumber is null ");
            if (filter.length() > 0) {
                sql.append("and FCOMPANYID in(").append((CharSequence)filter).append(")");
            }
            if (!StringUtils.isEmpty((String)bookedDate)) {
                sql.append(" and fbookeddate<=to_date('").append(bookedDate).append("')");
            }
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
            sql.setLength(0);
        }
    }

    private void replenishAcctData(Context ctx, List<String> companyidList, StringBuilder filter, String date, String bookedDate) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append("Insert Into t_GL_AcctCussent ");
        sql.append("(FID,FNumber,FCompanyID, FPeriodID, FAccountID, FCurrencyID, FIsInit, FVchAssistRecordID, ");
        sql.append("\tFCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, ");
        sql.append("    FUnVerifiedAmtFor, FUnHoldedAmtFor, FUnVerifiedAmtLocal, FUnHoldedAmtLocal, ");
        sql.append("FUnVerifiedAmtRpt, FUnHoldedAmtRpt, FMeasureUnitID, FUnVerifiedQty, ");
        sql.append("FUnHoldedQty, FUnVerifiedStdQty, FUnHoldedStdQty, ");
        sql.append("FVoucherID,FAssGrpID,FVARBizDate,FendDate,  ");
        sql.append("   Fquantity,ForiginalAmount,FlocalAmount,FreportingAmount,  ");
        sql.append("\tFsettlementTypeID,FsettlementCode,FbizNumber, ");
        sql.append("\tFcustomerID,FsupplierID,ForgUnitID,FmaterialID, ");
        sql.append("\tFticketNumber,FinvoiceNumber,FfeeType,FDescription,  ");
        sql.append("    FEntryId,FIsVierified,FEntryDC,FIsPost,FBookedDate,FVchNumber,FVoucherTypeID    ");
        sql.append(") ");
        sql.append("Select newBosID('CE2D850A'),'").append(REPLENISH_ACCTDATA).append("',vch.FCompanyID, vch.FPeriodID, ve.FAccountID, ve.FCurrencyID, 0, vast.FID, ");
        sql.append("vch.FCreatorID, vch.FLastUpdateTime, vch.FCreatorID, vch.FLastUpdateTime, ");
        sql.append("vast.FOriginalAmount, vast.FOriginalAmount, vast.FLocalAmount,  vast.FLocalAmount, ");
        sql.append("vast.FReportingAmount, vast.FReportingAmount, vast.FMeasureUnitID, vast.FQuantity, ");
        sql.append("vast.FQuantity, vast.FStandardQuantity, vast.FStandardQuantity, ");
        sql.append("vast.FBillID,vast.FAssGrpID,vast.FBizDate,vast.FendDate,  ");
        sql.append("isnull(vast.Fquantity,0),isnull(vast.ForiginalAmount,0),  ");
        sql.append("isnull(vast.FlocalAmount,0),isnull(vast.FreportingAmount,0),  ");
        sql.append("vast.FsettlementTypeID,vast.FsettlementCode,vast.FbizNumber,  ");
        sql.append("vast.FcustomerID,vast.FsupplierID,vast.ForgUnitID,vast.FmaterialID,  ");
        sql.append("vast.FticketNumber,vast.FinvoiceNumber,vast.FfeeType,vast.FDescription,  ");
        sql.append("vast.FEntryId,vast.FIsVierified,ve.FEntryDC ,1,  ");
        sql.append("vch.FBookedDate,vch.FNumber,vch.FVoucherTypeId   ");
        sql.append("From T_GL_Voucher vch ");
        sql.append("inner join T_GL_VoucherEntry ve on ve.FBillID = vch.FID ");
        sql.append("inner join T_GL_VoucherAssistRecord vast on vast.FEntryID = ve.FID ");
        sql.append("inner join T_ORG_COMPANY C ON C.FID = VCH.FCompanyID ");
        sql.append("inner join t_bd_accountview acct on acct.FID = ve.FAccountID ");
        sql.append(" inner join T_GL_FLAG f on f.FOrgUnitId = vch.FCompanyID and f.FKey = acct.fid \r\n");
        sql.append(" inner join\tT_BD_PERIOD pv on vch.FPeriodID = pv.FID\t\t\r\n");
        sql.append(" inner join\tT_BD_PERIOD pi on f.FInitPeriodID = pi.FID\t\r\n");
        sql.append("Where vch.fisac = 1 and vch.fbizstatus = 5 ");
        sql.append("\tand vch.FISREVERSEVOUCHER=0 ");
        sql.append("\tand vast.FAssGrpID is not null ");
        sql.append("\tand c.FISASSISTANTORG = 0 ");
        sql.append("    and ve.FIsVerify = 0  and (acct.FCAA is not null) and acct.FAC = 1 ");
        sql.append("    and (vch.FSourceType = 0 or vast.FOriginalAmount <> 0) ");
        sql.append("\tand not exists(select 1 from t_gl_acctcussent c where  vast.fid = c.fvchassistrecordid) ");
        sql.append("\tand f.FName = 'cussentinit' \t\r\n");
        sql.append("  \tand pv.FNumber >= pi.FNumber \t\r\n");
        if (filter.length() > 0) {
            sql.append(" and vch.fcompanyid in( ").append((CharSequence)filter).append(") ");
        }
        sql.append(" and vch.fbookeddate >= to_date('").append(date).append("')");
        if (!StringUtils.isEmpty((String)bookedDate)) {
            sql.append(" and vch.fbookeddate<=to_date('").append(bookedDate).append("')");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
        sql.setLength(0);
        sql.append("Insert Into t_GL_AcctVerify  ");
        sql.append("(FID, FNumber,FCompanyID, FPeriodID, FAccountID, FCurrencyID, FIsInit, FVchAssistRecordID,  ");
        sql.append("    FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FMeasureUnitID, ");
        sql.append("    FUnVerifiedAmtFor, FUnHoldedAmtFor, FUnVerifiedAmtLocal, FUnHoldedAmtLocal, ");
        sql.append("    FUnVerifiedAmtRpt, FUnHoldedAmtRpt, FUnVerifiedQty, FUnHoldedQty, ");
        sql.append("    FUnVerifiedStdQty, FUnHoldedStdQty,  ");
        sql.append("    Fquantity,ForiginalAmount,FlocalAmount,FreportingAmount, ");
        sql.append("    FVoucherID,FAssGrpID,FVARBizDate,FendDate,  ");
        sql.append("\tFsettlementTypeID,FsettlementCode,FbizNumber, ");
        sql.append("\tFcustomerID,FsupplierID,ForgUnitID,FmaterialID, ");
        sql.append("\tFticketNumber,FinvoiceNumber,FfeeType,FDescription,  ");
        sql.append("      FEntryId,FIsVierified,FEntryDC,FIsPost,FBookedDate,FVchNumber,FVoucherTypeID    ");
        sql.append("    ,FVSOURCEBILLID, FISREVERSEVOUCHER, FHASREVERSED    ");
        sql.append(") ");
        sql.append("Select newBosID('DFD26AFC'),'").append(REPLENISH_ACCTDATA).append("',vch.FCompanyID, vch.FPeriodID, ve.FAccountID, ve.FCurrencyID, 0, vast.FID,  ");
        sql.append("    vch.FCreatorID, vch.FLastUpdateTime, vch.FCreatorID, vch.FLastUpdateTime, vast.FMeasureUnitID, ");
        sql.append("    vast.FOriginalAmount  FOriginalAmount,     ");
        sql.append("    vast.FOriginalAmount  FOriginalAmount,     ");
        sql.append("    vast.FLocalAmount  FLocalAmount,           ");
        sql.append("    vast.FLocalAmount  FLocalAmount,           ");
        sql.append("    vast.FReportingAmount  FReportingAmount,   ");
        sql.append("    vast.FReportingAmount  FReportingAmount,  ");
        sql.append("    vast.FQuantity  FQuantity,                 ");
        sql.append("    vast.FQuantity  FQuantity,                 ");
        sql.append("    vast.FStandardQuantity  FStandardQuantity,   ");
        sql.append("    vast.FStandardQuantity  FStandardQuantity,   ");
        sql.append("\tisnull(vast.Fquantity,0),isnull(vast.ForiginalAmount,0),  ");
        sql.append("\tisnull(vast.FlocalAmount,0),isnull(vast.FreportingAmount,0),  ");
        sql.append("\tvast.FBillID,vast.FAssGrpID,vast.FBizDate,vast.FendDate,  ");
        sql.append("\tvast.FsettlementTypeID,vast.FsettlementCode,vast.FbizNumber,  ");
        sql.append("\tvast.FcustomerID,vast.FsupplierID,vast.ForgUnitID,vast.FmaterialID,  ");
        sql.append("\tvast.FticketNumber,vast.FinvoiceNumber,vast.FfeeType,vast.FDescription,  ");
        sql.append("    vast.FEntryId,vast.FIsVierified,ve.FEntryDC,1,  ");
        sql.append("    vch.FBookedDate,vch.FNumber,vch.FVoucherTypeId,   ");
        sql.append("    vch.FSOURCEBILLID FVSOURCEBILLID,vch.FISREVERSEVOUCHER ,vch.FHASREVERSED   ");
        sql.append("From T_GL_Voucher vch ");
        sql.append("inner join T_GL_VoucherEntry ve on ve.FBillID = vch.FID ");
        sql.append("inner join T_GL_VoucherAssistRecord vast on vast.FEntryID = ve.FID ");
        sql.append("inner join T_ORG_COMPANY C ON C.FID = VCH.FCompanyID ");
        sql.append("inner join t_bd_accountview acct on acct.FID = ve.FAccountID ");
        sql.append(" inner join T_GL_FLAG f on f.FOrgUnitId = vch.FCompanyID and f.FKey = acct.fid \r\n");
        sql.append(" inner join\tT_BD_PERIOD pv on vch.FPeriodID = pv.FID\t\t\r\n");
        sql.append(" inner join\tT_BD_PERIOD pi on f.FInitPeriodID = pi.FID\t\r\n");
        sql.append("Where vch.fisac = 1 and vch.fbizstatus = 5    ");
        sql.append("\tand vch.FISREVERSEVOUCHER=0 ");
        sql.append("\tand vast.FAssGrpID is not null ");
        sql.append("\tand c.FISASSISTANTORG = 0  ");
        sql.append("    and ve.FIsVerify = 1  and (acct.FCAA is not null) and acct.FAC = 1 ");
        sql.append("    and (vch.FSourceType = 0 or vast.FOriginalAmount <> 0) ");
        sql.append("\tand not exists(select 1 from t_GL_AcctVerify c where  vast.fid = c.fvchassistrecordid) ");
        sql.append("\tand f.FName = 'cussentinit' \t\r\n");
        sql.append("  \tand pv.FNumber >= pi.FNumber \t\r\n");
        if (filter.length() > 0) {
            sql.append(" and vch.fcompanyid in( ").append((CharSequence)filter).append(") ");
        }
        sql.append(" and vch.fbookeddate >= to_date('").append(date).append("')");
        if (!StringUtils.isEmpty((String)bookedDate)) {
            sql.append(" and vch.fbookeddate<=to_date('").append(bookedDate).append("')");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
    }

    private void repairEntryDc(Context ctx, List<String> companyidList, StringBuilder companyFilter) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("update T_GL_VoucherEntry set FISVERIFY = 0 where fid in(");
        sql.append("SELECT ve.FID FROM T_GL_VoucherEntry ve inner join t_gl_voucher vch on ve.FBILLID = vch.fid  inner join t_bd_accountview av ON ve.FACCOUNTID = AV.FID ");
        sql.append(" where av.FAC = 1 and (ve.FENTRYDC * 2 - 1) = av.FDC and ve.FISVERIFY  = 1");
        if (companyFilter.length() > 0) {
            sql.append(" and av.FCOMPANYID in (").append((CharSequence)companyFilter).append(")");
        }
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
        sql.setLength(0);
        sql.append("update T_GL_VoucherEntry set FISVERIFY = 1 where fid in (");
        sql.append("SELECT ve.FID FROM T_GL_VoucherEntry ve inner join t_gl_voucher vch on ve.FBILLID = vch.fid  inner join t_bd_accountview av ON ve.FACCOUNTID = AV.FID ");
        sql.append(" where av.FAC = 1 and (ve.FENTRYDC * 2 - 1) <> av.FDC and ve.FISVERIFY  = 0");
        if (companyFilter.length() > 0) {
            sql.append(" and av.FCOMPANYID in (").append((CharSequence)companyFilter).append(")");
        }
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
    }

    private Map<String, List<String>> getAcDateAndCompanyInfo(Context ctx, List<String> companyidList, StringBuilder filter) throws BOSException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT bp.FBEGINDATE begindate,a.company FROM T_BD_PERIOD bp inner join ");
        sb.append("(SELECT case when stc.FACPERIODID is null then stc.FSTARTPERIODID else stc.FACPERIODID end period,stc.FCOMPANYID company FROM T_BD_SYSTEMSTATUS st inner join T_BD_SYSTEMSTATUSCTROL stc on st.FID = stc.FSYSTEMSTATUSID\n inner join T_ORG_Company c on c.FID = stc.FCompanyID\n inner join T_BAS_PARAMITEM tpv on c.FID = tpv.FORGUNITID\n inner join T_BAS_PARAM tp on tp.FID  = tpv.FKEYID  \n where st.FISCANSTART =1 and st.FNAME =6 and stc.FISSTART =1 \n and c.FIsBizUnit = 1 and c.FIsSealup = 0 and tp.FNUMBER ='GL_028' and tpv.FVALUE_").append(ctx.getLocale());
        sb.append("='true'");
        if (filter.length() > 0) {
            sb.append(" and stc.fcompanyid in(").append((CharSequence)filter).append(") ");
        }
        sb.append(") a ");
        sb.append(" on bp.FID =a.period ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])companyidList.toArray());
        HashMap<String, List<String>> dateComMap = new HashMap<String, List<String>>();
        try {
            while (result.next()) {
                String dateStr = GlUtils.formatDate(result.getDate("begindate"));
                String company = result.getString("company");
                if (dateComMap.containsKey(dateStr)) {
                    ((List)dateComMap.get(dateStr)).add(company);
                    continue;
                }
                ArrayList<String> companys = new ArrayList<String>();
                companys.add(company);
                dateComMap.put(dateStr, companys);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return dateComMap;
    }

    private void deleteHistoryData(Context ctx, List<String> companyidList, StringBuilder filter, String bookedDate) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from t_gl_acctcussenthistory where fid in( ");
        sql.append("select h.fid from t_gl_acctcussenthistory h left join T_GL_ACCTCUSSENT t ON h.FCUSSENTIDID = T.FID where h.FDC <> 3  and t.fid is null  #filter# ");
        sql.append("union ");
        sql.append("select h.fid from t_gl_acctcussenthistory h left join T_GL_ACCTCUSSENT t ON h.FVOUCHERASSTIDID = T.FID where h.FDC = 1 and t.fid is null   #filter# ");
        sql.append("union ");
        sql.append("select h.fid from t_gl_acctcussenthistory h left join T_GL_ACCTVERIFY t ON h.FCUSSENTIDID = T.FVCHASSISTRECORDID  where h.FDC = 3  and T.FVCHASSISTRECORDID is null   #filter# ");
        sql.append("union ");
        sql.append("select h.fid from t_gl_acctcussenthistory h left join T_GL_ACCTVERIFY t ON h.FVOUCHERASSTIDID  = T.FVCHASSISTRECORDID  where h.FDC in(0,2)  and t.fid is null   #filter# ");
        sql.append(")  ");
        String delSql = null;
        StringBuilder filterSb = new StringBuilder();
        if (!StringUtils.isEmpty((String)bookedDate)) {
            filterSb.append(" and (h.FVERVCHDATE<=to_date('").append(bookedDate).append("')").append(" or h.FVCHDATE<=to_date('").append(bookedDate).append("'))");
        }
        if (filter.length() > 0) {
            filterSb.append(" and h.fcompanyid in(").append((CharSequence)filter).append(")");
        }
        delSql = sql.toString().replace("#filter#", filterSb.toString());
        ArrayList<String> ids = new ArrayList<String>();
        ids.addAll(companyidList);
        ids.addAll(companyidList);
        ids.addAll(companyidList);
        ids.addAll(companyidList);
        DbUtil.execute((Context)ctx, (String)delSql, (Object[])ids.toArray());
    }

    private void deleteAcctData(Context ctx, List<String> companyidList, StringBuilder filter, String bookedDate) throws BOSException {
        String filterStr = "";
        if (filter.length() > 0) {
            filterStr = "and t.fcompanyid in (" + filter + ")";
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            filterStr = filterStr + " and t.fbookeddate<=to_date('" + bookedDate + "')";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("delete from T_GL_ACCTCUSSENT where fid in( ");
        sql.append("select t.fid from T_GL_ACCTCUSSENT t left join T_GL_VoucherAssistRecord c ON t.FVCHASSISTRECORDID = c.FID where c.fid is null ").append(filterStr);
        sql.append(") ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
        sql.setLength(0);
        sql.append("delete from T_GL_ACCTCUSSENT where fid in( ");
        sql.append("select t.fid from T_GL_ACCTCUSSENT t left join t_gl_voucher c ON t.FVOUCHERID  = c.FID where c.fid is null and t.FISINIT =0 and  t.fisinitclosed = 0 ").append(filterStr);
        sql.append(") ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
        sql.setLength(0);
        sql.append("delete from T_GL_ACCTVERIFY where fid in( ");
        sql.append("select t.fid from T_GL_ACCTVERIFY t left join T_GL_VoucherAssistRecord c ON t.FVCHASSISTRECORDID = c.FID where c.fid is null ").append(filterStr);
        sql.append(")  ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
        sql.setLength(0);
        sql.append("delete from T_GL_ACCTVERIFY where fid in( ");
        sql.append("select t.fid from T_GL_ACCTVERIFY t left join t_gl_voucher c ON t.FVOUCHERID  = c.FID where c.fid is null and t.FISINIT =0 and  t.fisinitclosed = 0 ").append(filterStr);
        sql.append(") ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
        sql.setLength(0);
        sql.append("delete from T_GL_ACCTCUSSENT where fid in( ");
        sql.append("SELECT t.fid FROM T_GL_ACCTCUSSENT t inner join T_GL_VOUCHERENTRY e on t.fentryid = e.fid inner join t_gl_voucher vch on vch.fid = e.fbillid where e.fisverify = 1 and vch.FISREVERSEVOUCHER=0 ");
        sql.append(filterStr);
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
        sql.setLength(0);
        sql.append("delete from T_GL_ACCTVERIFY where fid in( ");
        sql.append("SELECT t.fid FROM T_GL_ACCTVERIFY t inner join T_GL_VOUCHERENTRY e on t.fentryid = e.fid inner join t_gl_voucher vch on vch.fid = e.fbillid where e.fisverify = 0 and vch.FISREVERSEVOUCHER=0 ");
        sql.append(filterStr);
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyidList.toArray());
    }

    private void syncHistoryData(Context ctx, Map param, List<String> companyidList, StringBuilder filter, String bookedDate) throws BOSException {
        StringBuilder historySql = new StringBuilder();
        historySql.append("update t_gl_acctcussenthistory set FCUSSENTIDID = FVOUCHERASSTIDID , FVOUCHERASSTIDID = FCUSSENTIDID  where fid in( SELECT h.fid FROM t_gl_acctcussenthistory h inner join t_gl_acctverify v on h.FCUSSENTIDID = v.FVCHASSISTRECORDID  where h.FOROGINALAMOUNT <0 and v.FORIGINALAMOUNT >0 and h.FDC = 3");
        if (filter.length() > 0) {
            historySql.append(" and h.fcompanyid in (").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            historySql.append(" and (h.FVERVCHDATE<=to_date('").append(bookedDate).append("')").append(" or h.FVCHDATE<=to_date('").append(bookedDate).append("'))");
        }
        historySql.append(")");
        DbUtil.execute((Context)ctx, (String)historySql.toString(), (Object[])companyidList.toArray());
        historySql.setLength(0);
        historySql.append("update t_gl_acctcussenthistory set FCUSSENTIDID = FVOUCHERASSTIDID , FVOUCHERASSTIDID = FCUSSENTIDID  where fid in( SELECT h.fid FROM t_gl_acctcussenthistory h inner join t_gl_acctverify v on h.FCUSSENTIDID = v.FVCHASSISTRECORDID  where h.FOROGINALAMOUNT > 0 and v.FORIGINALAMOUNT < 0 and h.FDC = 3");
        if (filter.length() > 0) {
            historySql.append(" and h.fcompanyid in (").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            historySql.append(" and (h.FVERVCHDATE<=to_date('").append(bookedDate).append("')").append(" or h.FVCHDATE<=to_date('").append(bookedDate).append("'))");
        }
        historySql.append(")");
        DbUtil.execute((Context)ctx, (String)historySql.toString(), (Object[])companyidList.toArray());
        historySql.setLength(0);
        historySql.append("update t_gl_acctcussenthistory set FCUSSENTIDID = FVOUCHERASSTIDID , FVOUCHERASSTIDID = FCUSSENTIDID where fid in( SELECT h.fid FROM t_gl_acctcussenthistory h inner join T_GL_ACCTCUSSENT v on h.FCUSSENTIDID = v.FVCHASSISTRECORDID  where h.FOROGINALAMOUNT <0 and v.FORIGINALAMOUNT >0 and h.FDC = 1 ");
        if (filter.length() > 0) {
            historySql.append(" and h.fcompanyid in (").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            historySql.append(" and (h.FVERVCHDATE<=to_date('").append(bookedDate).append("')").append(" or h.FVCHDATE<=to_date('").append(bookedDate).append("'))");
        }
        historySql.append(")");
        DbUtil.execute((Context)ctx, (String)historySql.toString(), (Object[])companyidList.toArray());
        historySql.setLength(0);
        historySql.append("update t_gl_acctcussenthistory set FCUSSENTIDID = FVOUCHERASSTIDID , FVOUCHERASSTIDID = FCUSSENTIDID  where fid in( SELECT h.fid FROM t_gl_acctcussenthistory h inner join T_GL_ACCTCUSSENT v on h.FCUSSENTIDID = v.FVCHASSISTRECORDID  where h.FOROGINALAMOUNT > 0 and v.FORIGINALAMOUNT < 0 and h.FDC = 1 ");
        if (filter.length() > 0) {
            historySql.append(" and h.fcompanyid in (").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            historySql.append(" and (h.FVERVCHDATE<=to_date('").append(bookedDate).append("')").append(" or h.FVCHDATE<=to_date('").append(bookedDate).append("'))");
        }
        historySql.append(")");
        DbUtil.execute((Context)ctx, (String)historySql.toString(), (Object[])companyidList.toArray());
        historySql.setLength(0);
        historySql.append("update t_gl_acctcussenthistory set FVCHDATE = (select t.fbookeddate from t_gl_acctcussent t where t.FID = FCUSSENTIDID) where  FVCHDATE is null  and fdc <> 3 ");
        if (filter.length() > 0) {
            historySql.append(" and fcompanyid in (").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            historySql.append(" and (FVERVCHDATE<=to_date('").append(bookedDate).append("')").append(" or FVCHDATE<=to_date('").append(bookedDate).append("'))");
        }
        DbUtil.execute((Context)ctx, (String)historySql.toString(), (Object[])companyidList.toArray());
        historySql.setLength(0);
        historySql.append("update t_gl_acctcussenthistory set FVCHDATE = (select t.fbookeddate from t_gl_acctverify t where t.FVCHASSISTRECORDID = FCUSSENTIDID) where  FVCHDATE is null and fdc = 3 ");
        if (filter.length() > 0) {
            historySql.append(" and fcompanyid in (").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            historySql.append(" and (FVERVCHDATE<=to_date('").append(bookedDate).append("')").append(" or FVCHDATE<=to_date('").append(bookedDate).append("'))");
        }
        DbUtil.execute((Context)ctx, (String)historySql.toString(), (Object[])companyidList.toArray());
        historySql.setLength(0);
        historySql.append("update t_gl_acctcussenthistory set FVCHDATE = (select t.fbookeddate from t_gl_acctcussent t where t.FID = FCUSSENTIDID) where fid in( select h.fid from t_gl_acctcussenthistory h inner join t_gl_acctcussent t on h.FCUSSENTIDID = t.fid where h.fdc <> 3 and h.FVCHDATE <> t.fbookeddate ");
        if (filter.length() > 0) {
            historySql.append(" and h.fcompanyid in (").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            historySql.append(" and (h.FVERVCHDATE<=to_date('").append(bookedDate).append("')").append(" or h.FVCHDATE<=to_date('").append(bookedDate).append("'))");
        }
        historySql.append(")");
        DbUtil.execute((Context)ctx, (String)historySql.toString(), (Object[])companyidList.toArray());
        historySql.setLength(0);
        historySql.append("update t_gl_acctcussenthistory set FVCHDATE = (select t.fbookeddate from t_gl_acctverify t where t.FVCHASSISTRECORDID = FCUSSENTIDID) where  fid in(select h.fid from t_gl_acctcussenthistory h inner join t_gl_acctverify t on h.FCUSSENTIDID = t.FVCHASSISTRECORDID where h.fdc = 3 and h.FVCHDATE <> t.fbookeddate");
        if (filter.length() > 0) {
            historySql.append(" and h.fcompanyid in (").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            historySql.append(" and (h.FVERVCHDATE<=to_date('").append(bookedDate).append("')").append(" or h.FVCHDATE<=to_date('").append(bookedDate).append("'))");
        }
        historySql.append(")");
        DbUtil.execute((Context)ctx, (String)historySql.toString(), (Object[])companyidList.toArray());
        historySql.setLength(0);
        historySql.append("update t_gl_acctcussenthistory set FVERVCHDATE = (select t.fbookeddate from t_gl_acctcussent t where t.FID = FVOUCHERASSTIDID) where  FVERVCHDATE is null and fdc = 1");
        if (filter.length() > 0) {
            historySql.append(" and fcompanyid in (").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            historySql.append(" and (FVERVCHDATE<=to_date('").append(bookedDate).append("')").append(" or FVCHDATE<=to_date('").append(bookedDate).append("'))");
        }
        DbUtil.execute((Context)ctx, (String)historySql.toString(), (Object[])companyidList.toArray());
        historySql.setLength(0);
        historySql.append("update t_gl_acctcussenthistory set FVERVCHDATE = (select t.fbookeddate from t_gl_acctverify t where t.FVCHASSISTRECORDID = FVOUCHERASSTIDID) where  FVERVCHDATE is null and fdc <> 1");
        if (filter.length() > 0) {
            historySql.append(" and fcompanyid in (").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            historySql.append(" and (FVERVCHDATE<=to_date('").append(bookedDate).append("')").append(" or FVCHDATE<=to_date('").append(bookedDate).append("'))");
        }
        DbUtil.execute((Context)ctx, (String)historySql.toString(), (Object[])companyidList.toArray());
        historySql.setLength(0);
        historySql.append("update t_gl_acctcussenthistory set FVERVCHDATE = (select t.fbookeddate from t_gl_acctcussent t where t.FID = FVOUCHERASSTIDID) where fid in( select h.fid from t_gl_acctcussenthistory h inner join t_gl_acctcussent t on h.FVOUCHERASSTIDID = t.fid where h.fdc = 1 and h.FVERVCHDATE <> t.fbookeddate");
        if (filter.length() > 0) {
            historySql.append(" and h.fcompanyid in (").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            historySql.append(" and (h.FVERVCHDATE<=to_date('").append(bookedDate).append("')").append(" or h.FVCHDATE<=to_date('").append(bookedDate).append("'))");
        }
        historySql.append(")");
        DbUtil.execute((Context)ctx, (String)historySql.toString(), (Object[])companyidList.toArray());
        historySql.setLength(0);
        historySql.append("update t_gl_acctcussenthistory set FVERVCHDATE = (select t.fbookeddate from t_gl_acctverify t where t.FVCHASSISTRECORDID = FVOUCHERASSTIDID)  where fid in( select h.fid from t_gl_acctcussenthistory h inner join t_gl_acctverify t on h.FVOUCHERASSTIDID = t.FVCHASSISTRECORDID  where h.fdc <> 1 and h.FVERVCHDATE <> t.fbookeddate");
        if (filter.length() > 0) {
            historySql.append(" and h.fcompanyid in (").append((CharSequence)filter).append(")");
        }
        if (!StringUtils.isEmpty((String)bookedDate)) {
            historySql.append(" and (h.FVERVCHDATE<=to_date('").append(bookedDate).append("')").append(" or h.FVCHDATE<=to_date('").append(bookedDate).append("'))");
        }
        historySql.append(")");
        DbUtil.execute((Context)ctx, (String)historySql.toString(), (Object[])companyidList.toArray());
        historySql.setLength(0);
        boolean executeConfigSql = false;
        String sql = "select * from T_GL_REPAIR where FFUNCTION = 'sync_history' and FISIGNORE = 0 order by fseq ";
        int seq = 0;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            String paramStr = null;
            while (rs.next() && executeConfigSql) {
                seq = rs.getInt("FSEQ");
                sql = rs.getString("FSQLTEXT");
                if (filter.length() == 0) {
                    sql = sql.replace("@param", "");
                    DbUtil.execute((Context)ctx, (String)sql);
                    continue;
                }
                paramStr = rs.getString("FPARAMS");
                if (!StringUtils.isEmpty((String)paramStr)) {
                    paramStr = paramStr.replace("@value", filter);
                    sql = sql.replace("@param", paramStr);
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])companyidList.toArray());
                    continue;
                }
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql.seq:" + seq + "  " + e.getMessage());
        }
    }

    private void repairData(Context ctx, Map param) throws BOSException {
        String sql = "select * from T_GL_REPAIR where FFUNCTION = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            String paramStr = "";
            String[] paramKeys = null;
            ArrayList pm = new ArrayList();
            while (rs.next()) {
                paramStr = rs.getString("FPARAMSKEY");
                paramKeys = paramStr.split(",");
                for (int i = 0; i < paramKeys.length; ++i) {
                    pm.add(param.get(paramKeys[i]));
                }
                sql = rs.getString("FSQLTEXT");
                DbUtil.execute((Context)ctx, (String)sql, (Object[])pm.toArray());
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
    }

    private Map checkErrorHistory(Context ctx, Map param, List<String> companyid, String accountid, String bookedDate) throws BOSException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        String[] tabs = new String[2];
        try {
            tabs = this.statisticsErrorHistory(ctx, param, companyid, accountid, bookedDate);
            if (this.existsErrorAcctData(ctx, tabs[0]) && this.existsErrorAcctData(ctx, tabs[1])) {
                SqlParams sp = new SqlParams();
                for (String comid : companyid) {
                    sp.addString(comid);
                }
                if (!StringUtils.isEmpty((String)accountid)) {
                    sp.addString(accountid);
                }
                String comfilter = "";
                if (!this.dealByGroup) {
                    String filter = this.getSqlIn(companyid).toString();
                    String string = comfilter = companyid.size() == 1 ? " and fcompanyid = ? " : " and fcompanyid in(#filter) ";
                    if (!StringUtils.isEmpty((String)accountid)) {
                        comfilter = comfilter + "and faccountid = ? ";
                    }
                    if (companyid.size() > 1) {
                        comfilter = comfilter.replace("#filter", filter);
                    }
                }
                this.repairAcctData(ctx, tabs[0], tabs[1], comfilter, sp);
                result.put("success", true);
            } else {
                String filter = null;
                this.queryErrorAcctData(ctx, result, tabs[0], tabs[1], filter, bookedDate);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tabs[0] != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tabs[0]);
            }
            if (tabs[1] != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tabs[1]);
            }
        }
        return result;
    }

    private String[] statisticsErrorHistory(Context ctx, Map param, List<String> companyid, String accountid, String bookedDate) throws BOSException {
        String tmpAcTable = null;
        String tmpVerTable = null;
        String[] result = new String[2];
        try {
            String comfilter;
            String filter = (String)param.get("filter");
            String string = comfilter = companyid.size() == 0 ? " " : "and h.fcompanyid in(#filter) ";
            if (!StringUtils.isEmpty((String)accountid)) {
                comfilter = comfilter + "and h.faccountid = ? ";
            }
            if (!StringUtils.isEmpty((String)bookedDate)) {
                comfilter = comfilter + " and (h.FVERVCHDATE<=to_date('" + bookedDate + "') or h.FVCHDATE<=to_date('" + bookedDate + "'))";
            }
            if (companyid.size() > 0) {
                comfilter = comfilter.replace("#filter", filter);
            }
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT h.FCUSSENTIDID vsid, v.FORIGINALAMOUNT amt, sum(h.FOROGINALAMOUNT) omt  into act_tmp  ");
            sql.append(" FROM t_gl_acctcussenthistory h inner join T_GL_ACCTCUSSENT v on h.FCUSSENTIDID = v.fid where h.FDC <> 3 ").append(comfilter);
            sql.append(" group by h.FCUSSENTIDID, v.FORIGINALAMOUNT ");
            SqlParams sp = new SqlParams();
            if (!this.dealByGroup) {
                for (String cmid : companyid) {
                    sp.addString(cmid);
                }
                if (!StringUtils.isEmpty((String)accountid)) {
                    sp.addString(accountid);
                }
            }
            result[0] = tmpAcTable = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)this.getConnection(ctx)).getTempTable();
            sql.setLength(0);
            sql.append(" SELECT t.vsid,t.amt,sum(t.omt) omt into act_tmp FROM ( ");
            sql.append(" SELECT h.FVOUCHERASSTIDID vsid, v.FORIGINALAMOUNT amt,FOROGINALAMOUNT  omt FROM t_gl_acctcussenthistory h  ");
            sql.append(" inner join t_gl_acctverify v on h.FVOUCHERASSTIDID = v.FVCHASSISTRECORDID where h.FDC in(0,2) ").append(comfilter);
            sql.append(" union all ");
            sql.append(" SELECT h.FCUSSENTIDID vsid, v.FORIGINALAMOUNT amt, h.FOROGINALAMOUNT omt FROM t_gl_acctcussenthistory h  ");
            sql.append(" inner join t_gl_acctverify v on h.FCUSSENTIDID = v.FVCHASSISTRECORDID where h.FDC = 3 ").append(comfilter);
            sql.append(" ) t group by t.vsid, t.amt ");
            sp.clear();
            if (!this.dealByGroup) {
                if (!StringUtils.isEmpty((String)accountid)) {
                    for (String cmid : companyid) {
                        sp.addString(cmid);
                    }
                    sp.addString(accountid);
                    for (String cmid : companyid) {
                        sp.addString(cmid);
                    }
                    sp.addString(accountid);
                } else {
                    for (String cmid : companyid) {
                        sp.addString(cmid);
                    }
                    for (String cmid : companyid) {
                        sp.addString(cmid);
                    }
                }
            }
            result[1] = tmpVerTable = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)this.getConnection(ctx)).getTempTable();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private void putDataToList(IRowSet rs, List list, String[] keys, String type, String cause) throws SQLException {
        while (rs != null && rs.next()) {
            HashMap<String, String> rm = new HashMap<String, String>();
            for (String key : keys) {
                if ("type".equals(key)) {
                    rm.put(key, type);
                    continue;
                }
                if ("cause".equals(key)) {
                    rm.put(key, cause);
                    continue;
                }
                rm.put(key, rs.getString(key));
            }
            list.add(rm);
        }
    }

    private void queryErrorAcctData(Context ctx, Map result, String tmpAcTable, String tmpVerTable, String filter, String bookedDate) throws BOSException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT c.FNUMBER||' '||c.fname_l2 company, av.fnumber||' '||av.fname_l2 account,v.FVCHNUMBER vchnumber,TO_CHAR(v.fbookedDate,'YYYY-MM-DD') bookedDate, tmp.vsid, tmp.amt oriamt, v.FUNVERIFIEDAMTFOR unveriamt, tmp.omt oroamt ");
        sql.append(" FROM T_GL_ACCTVERIFY v inner join T_ORG_COMPANY c on v.fcompanyid = c.fid  ");
        sql.append(" inner join T_BD_ACCOUNTVIEW av on v.faccountid = av.FID   ");
        sql.append(" inner join ").append(tmpVerTable).append(" tmp on tmp.vsid = v.FVCHASSISTRECORDID  ");
        sql.append(" WHERE v.FVCHASSISTRECORDID IN( ");
        sql.append("SELECT vsid FROM ").append(tmpVerTable).append(" where omt > amt and amt > 0 ");
        sql.append("union ");
        sql.append("SELECT vsid FROM ").append(tmpVerTable).append(" where omt < amt and amt < 0 ");
        sql.append("union ");
        sql.append("SELECT vsid FROM ").append(tmpVerTable).append(" where omt > 0 and amt < 0 ");
        sql.append("union  ");
        sql.append("SELECT vsid FROM ").append(tmpVerTable).append(" where omt < 0 and amt > 0 ");
        sql.append(" ) ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String type = EASResource.getString((String)sourceUrl, (String)"TYPE_VERIFY", (Locale)ctx.getLocale());
        String cause = EASResource.getString((String)sourceUrl, (String)"historyAmtError", (Locale)ctx.getLocale());
        ArrayList verifyList = new ArrayList();
        String[] keys = new String[]{"company", "account", "vchnumber", "bookedDate", "vsid", "oriamt", "unveriamt", "oroamt", "type", "cause"};
        result.put("hisKeys", keys);
        this.putDataToList(rs, verifyList, keys, type, cause);
        result.put("verifyList", verifyList);
        sql.setLength(0);
        sql.append("SELECT c.FNUMBER||' '||c.fname_l2 company, av.fnumber||' '||av.fname_l2 account,v.FVCHNUMBER vchnumber,TO_CHAR(v.fbookedDate,'YYYY-MM-DD') bookedDate, tmp.vsid, tmp.amt oriamt, v.FUNVERIFIEDAMTFOR unveriamt, tmp.omt oroamt ");
        sql.append(" FROM T_GL_ACCTCUSSENT v inner join T_ORG_COMPANY c on v.fcompanyid = c.fid  ");
        sql.append(" inner join T_BD_ACCOUNTVIEW av on v.faccountid = av.FID   ");
        sql.append(" inner join ").append(tmpAcTable).append(" tmp on tmp.vsid = v.FID  ");
        sql.append(" WHERE v.FID IN( ");
        sql.append("SELECT vsid FROM ").append(tmpAcTable).append(" where omt > amt and amt > 0 ");
        sql.append("union ");
        sql.append("SELECT vsid FROM ").append(tmpAcTable).append(" where omt < amt and amt < 0 ");
        sql.append("union ");
        sql.append("SELECT vsid FROM ").append(tmpAcTable).append(" where omt > 0 and amt < 0 ");
        sql.append("union  ");
        sql.append("SELECT vsid FROM ").append(tmpAcTable).append(" where omt < 0 and amt > 0 ");
        sql.append(" ) ");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        type = EASResource.getString((String)sourceUrl, (String)"TYPE_CUSSENT", (Locale)ctx.getLocale());
        ArrayList acctList = new ArrayList();
        this.putDataToList(rs, acctList, keys, type, cause);
        result.put("acctList", acctList);
        result.put("rowCount", verifyList.size() + acctList.size());
    }

    private boolean existsErrorAcctData(Context ctx, String tmpTable) throws BOSException, SQLException {
        boolean flg = true;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT vsid FROM ").append(tmpTable).append(" where omt > amt and amt > 0 ");
        sql.append("union ");
        sql.append("SELECT vsid FROM ").append(tmpTable).append(" where omt < amt and amt < 0 ");
        sql.append("union ");
        sql.append("SELECT vsid FROM ").append(tmpTable).append(" where omt > 0 and amt < 0 ");
        sql.append("union  ");
        sql.append("SELECT vsid FROM ").append(tmpTable).append(" where omt < 0 and amt > 0 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            flg = false;
        }
        return flg;
    }

    private void repairAcctData(Context ctx, String tmpAcTable, String tmpVerTable, String filter, SqlParams sp) throws SQLDataException, Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE T_GL_ACCTCUSSENT SET FUNVERIFIEDAMTFOR=0 WHERE  fid in (select vsid from ").append(tmpAcTable).append(" where amt = omt)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("UPDATE T_GL_ACCTCUSSENT SET FUNVERIFIEDAMTFOR=(select t.amt-t.omt from ").append(tmpAcTable).append(" t where t.vsid = fid) WHERE  fid in (select vsid from ").append(tmpAcTable).append(" where amt <> omt)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("UPDATE t_gl_acctverify SET FUNVERIFIEDAMTFOR=0 WHERE  FVCHASSISTRECORDID in (select vsid from ").append(tmpVerTable).append(" where amt = omt)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("UPDATE t_gl_acctverify SET FUNVERIFIEDAMTFOR=(select t.amt-t.omt from ").append(tmpVerTable).append(" t where t.vsid = FVCHASSISTRECORDID) WHERE FVCHASSISTRECORDID in (select vsid from ").append(tmpVerTable).append(" where amt <> omt)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("SELECT distinct h.FVOUCHERASSTIDID vsid into his_tmp  FROM t_gl_acctcussenthistory h where h.FDC <> 1 ").append(filter);
        tmpAcTable = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)this.getConnection(ctx)).getTempTable();
        sql.setLength(0);
        sql.append("update t_gl_acctverify set FUNVERIFIEDAMTFOR = FORIGINALAMOUNT, FUNVERIFIEDQTY = isnull(FQUANTITY,0)  where not exists(select 1 from ").append(tmpAcTable).append(" t where t.vsid = FVCHASSISTRECORDID) and FUNVERIFIEDAMTFOR <>  FORIGINALAMOUNT ").append(filter);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])sp.getParams());
        sql.setLength(0);
        sql.append("SELECT distinct h.FCUSSENTIDID vsid into his_tmp  FROM t_gl_acctcussenthistory h where h.FDC <> 3 ").append(filter);
        tmpAcTable = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql.toString(), (SqlParams)sp, (Connection)this.getConnection(ctx)).getTempTable();
        sql.setLength(0);
        sql.append("update T_GL_ACCTCUSSENT set FUNVERIFIEDAMTFOR = FORIGINALAMOUNT, FUNVERIFIEDQTY = isnull(FQUANTITY,0) where not exists(select 1 from ").append(tmpAcTable).append(" t where t.vsid = fid) and FUNVERIFIEDAMTFOR <>  FORIGINALAMOUNT ").append(filter);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])sp.getParams());
    }

    @Override
    protected Map _repairAcctData(Context ctx, Map param) throws BOSException {
        if (param.containsKey(REPAIR_INITDATA)) {
            return this.repairAcctInitData(ctx, param);
        }
        return this.repairAcct(ctx, param);
    }

    private Map repairAcctInitData(Context ctx, Map param) throws BOSException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        List data = (List)param.get("data");
        if (data.size() <= 0) {
            return result;
        }
        IObjectPK repairAcctInitDataLog = LogUtil.beginLog((Context)ctx, (String)"repairAcctInitData", (BOSObjectType)BOSObjectType.create((String)bosType), null, (String)EASResource.getString((String)this.resource, (String)"repairAcctInitData"), (String)"repairAcctInitData");
        ArrayList<String> acctCussentId = new ArrayList<String>(data.size());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        String currenctUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        for (Map initData : data) {
            Object[] params = new Object[21];
            BOSUuid bosUuid = BOSUuid.create((String)bosType);
            acctCussentId.add(bosUuid.toString());
            params[0] = bosUuid.toString();
            params[1] = initData.get("companyid");
            params[2] = "AAAAAAAAAAAAAAAAAAAAAII4jEw=";
            params[3] = initData.get("accountid");
            params[4] = initData.get("currencyid");
            params[5] = currenctUserId;
            params[6] = currenctUserId;
            params[7] = initData.get("omt");
            params[8] = initData.get("lmt");
            params[9] = initData.get("rmt");
            params[10] = initData.get("omt");
            params[11] = initData.get("lmt");
            params[12] = initData.get("rmt");
            params[13] = initData.get("asstgrpid");
            params[14] = new Date(((java.util.Date)initData.get("bizDate")).getTime());
            params[15] = new Date(((java.util.Date)initData.get("endDate")).getTime());
            params[16] = initData.get("omt");
            params[17] = initData.get("lmt");
            params[18] = initData.get("rmt");
            params[19] = initData.get("biznumber");
            params[20] = REPAIR_INITDATA;
            paramsList.add(params);
        }
        String insertSql = "Insert Into t_GL_AcctCussent \n(FID, FCompanyID, FPeriodID, FAccountID, FCurrencyID, FIsInit, FISINITCLOSED, FVchAssistRecordID, \n\tFCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FUnVerifiedAmtFor, FUnHoldedAmtFor, FUnVerifiedAmtLocal, FUnHoldedAmtLocal, \n\tFUnVerifiedAmtRpt, FUnHoldedAmtRpt, \n\tFAssGrpID,FVARBizDate,FendDate,ForiginalAmount,FlocalAmount,FreportingAmount,FbizNumber, \n\tFIsVierified,FEntryDC,FIsPost,FBookedDate,fnumber \n) values (?,?,?,?,?,1,1,newBosID('0FFFBCAA'),?,getDate(),?,getDate(),?,?,?,?,?,?,?,?,?,?,?,?,?,0,1,1,to_date('1990-01-01'),?)";
        DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
        StringBuilder sqlIn = this.getSqlIn(acctCussentId);
        String insertVchAsstSql = "insert into T_GL_VOUCHERASSISTRECORD (FID,fnumber,FSEQ, FASSGRPID, FBIZDATE , FORIGINALAMOUNT ,FLOCALAMOUNT ,FREPORTINGAMOUNT , \n FENDDATE , FISFULLPROP , FREQSTATUS , FREQCHECKSTATUS , FISVIERIFIED , \nFHASEFFECTED , FMACTRLAMOUNT , FPRICE , FMAHOLDAMOUNT , FFEETYPE,FCREATETIME,FCREATORID,FLastUpdateUserID,FLASTUPDATETIME )\nSELECT FVCHASSISTRECORDID, fnumber,0, FASSGRPID , FVARBIZDATE , FORIGINALAMOUNT , FLOCALAMOUNT , FREPORTINGAMOUNT, FENDDATE, 0, 0, 1, 0, 0, 0, 0, 0,0,FCREATETIME,FCREATORID,FLastUpdateUserID,FLASTUPDATETIME\n FROM t_GL_AcctCussent\nwhere fid in (" + sqlIn.toString() + ")";
        DbUtil.execute((Context)ctx, (String)insertVchAsstSql, (Object[])acctCussentId.toArray());
        result.put("success", true);
        LogUtil.afterLog((Context)ctx, (IObjectPK)repairAcctInitDataLog);
        return result;
    }

    private Map repairAcct(Context ctx, Map param) throws BOSException {
        this.dealByGroup = param.containsKey("dealByGroup");
        String bookedDate = GlUtils.formatDate((java.util.Date)param.get("bookedDate"));
        Object company = null;
        StringBuilder filter = new StringBuilder();
        List<String> companyidList = new ArrayList();
        HashMap<String, String> p = new HashMap<String, String>();
        if (!this.dealByGroup) {
            companyidList = (List)param.get("companyidList");
            if (!companyidList.isEmpty()) {
                for (int i = 0; i < companyidList.size() && i < this.org_limit; ++i) {
                    filter.append("?,");
                }
                filter.deleteCharAt(filter.lastIndexOf(","));
            }
            p.put("filter", filter.toString());
        }
        String accountid = null;
        AccountViewInfo account = (AccountViewInfo)param.get("account");
        if (account != null && companyidList.size() == 1) {
            accountid = account.getId().toString();
            p.put("account", account.getId().toString());
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] tabs = new String[2];
        try {
            tabs = this.statisticsErrorHistory(ctx, p, companyidList, accountid, bookedDate);
            if (this.existsErrorAcctData(ctx, tabs[0]) && this.existsErrorAcctData(ctx, tabs[1])) {
                SqlParams sp = new SqlParams();
                for (String comid : companyidList) {
                    sp.addString(comid);
                }
                if (!StringUtils.isEmpty((String)accountid)) {
                    sp.addString(accountid);
                }
                String comfilter = "";
                if (!this.dealByGroup) {
                    String string = comfilter = companyidList.size() == 1 ? " and fcompanyid = ? " : " and fcompanyid in(#filter) ";
                    if (!StringUtils.isEmpty((String)accountid)) {
                        comfilter = comfilter + "and faccountid = ? ";
                    }
                    if (companyidList.size() > 1) {
                        comfilter = comfilter.replace("#filter", filter);
                    }
                }
                this.repairAcctData(ctx, tabs[0], tabs[1], comfilter, sp);
                result.put("success", true);
            } else {
                result.put("success", false);
                result.put("msg", EASResource.getString((String)this.resource, (String)"exsit_error_verifylog"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tabs[0] != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tabs[0]);
            }
            if (tabs[1] != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tabs[1]);
            }
        }
        return result;
    }

    @Override
    protected Map _clearErrorAcctData(Context ctx, Map param) throws BOSException {
        return null;
    }

    private Set getHistoryIds(Context ctx, List<String> vsids) throws BOSException {
        HashSet<String> historySet = new HashSet<String>();
        StringBuilder sqlIn = this.getSqlIn(vsids);
        vsids.addAll(vsids);
        try {
            StringBuilder historySql = new StringBuilder();
            historySql.append("select fid from t_gl_acctcussenthistory where FCUSSENTIDID in(").append((CharSequence)sqlIn).append(") or FVOUCHERASSTIDID in(").append((CharSequence)sqlIn).append(")");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)historySql.toString(), (Object[])vsids.toArray());
            while (rowSet.next()) {
                String id = rowSet.getString(1);
                historySet.add(id);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"query acct history tabel error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return historySet;
    }

    private void clearErrorAcctData(Context ctx, List<String> vsids) throws BOSException {
        StringBuffer filter = new StringBuffer();
        for (int i = 0; i < vsids.size(); ++i) {
            filter.append("?,");
        }
        filter.deleteCharAt(filter.lastIndexOf(","));
        StringBuffer sql = new StringBuffer();
        sql.append("delete from t_gl_acctcussenthistory where FCUSSENTIDID in(").append(filter).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])vsids.toArray());
        sql.setLength(0);
        sql.append("delete from t_gl_acctcussenthistory where FVOUCHERASSTIDID in(").append(filter).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])vsids.toArray());
    }

    @Override
    protected void _unverify(Context ctx, Set historyIds, String companyId) throws BOSException, EASBizException {
        if (companyId == null || "".equals(companyId)) {
            this._unverify(ctx, historyIds);
        } else {
            this.verifyAcctTable(ctx, historyIds.toArray(), companyId);
            this.unVerifyHistory(ctx, this.getHistoryColls(ctx, historyIds), new BOSObjectType("8DC75C7E"));
        }
    }

    private StringBuilder getSqlIn(List companyidList) {
        StringBuilder filter = new StringBuilder();
        if (!companyidList.isEmpty()) {
            for (int i = 0; i < companyidList.size(); ++i) {
                filter.append("?,");
            }
            filter.deleteCharAt(filter.lastIndexOf(","));
        }
        return filter;
    }

    @Override
    protected Map<String, Boolean> _hasVerifyAboutAsstBatch(Context ctx, List<String> vchAsstRecordIds) throws BOSException {
        if (vchAsstRecordIds == null || vchAsstRecordIds.size() <= 0) {
            return new HashMap<String, Boolean>();
        }
        HashMap<String, Boolean> hasVerifyMap = new HashMap<String, Boolean>();
        if (vchAsstRecordIds.size() > 1000) {
            String createTableSql = "create table ac_temp_table (fid varchar(44))";
            String tempTable = null;
            try {
                tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
                String sql = "insert into " + tempTable + " values(?)";
                ArrayList<String[]> paramsList = new ArrayList<String[]>();
                for (String id : vchAsstRecordIds) {
                    paramsList.add(new String[]{id.toString()});
                }
                DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
                StringBuilder selectSql = new StringBuilder();
                selectSql.append("select FVchAssistRecordID from t_gl_acctcussent cussent ");
                selectSql.append(" inner join ").append(tempTable).append(" temp1 on cussent.FVCHASSISTRECORDID = temp1.fid");
                selectSql.append(" where cussent.FUnVerifiedAmtFor <> cussent.ForiginalAmount ");
                selectSql.append(" union ");
                selectSql.append("select FVCHASSISTRECORDID from t_gl_acctverify cussent ");
                selectSql.append(" inner join ").append(tempTable).append(" temp2 on cussent.FVCHASSISTRECORDID = temp2.fid");
                selectSql.append(" where cussent.FUnVerifiedAmtFor <> cussent.ForiginalAmount ");
                IRowSet result = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
                while (result.next()) {
                    String vchAsstId = result.getString(1);
                    hasVerifyMap.put(vchAsstId, Boolean.TRUE);
                }
            }
            catch (Exception e) {
                logger.error((Object)"query acct history error.", (Throwable)e);
                throw new BOSException("query acct history error.", (Throwable)e);
            }
            finally {
                if (!StringUtils.isEmpty(tempTable)) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                }
            }
        }
        StringBuilder sqlIn = this.getSqlIn(vchAsstRecordIds);
        StringBuilder sql = new StringBuilder();
        sql.append("select FVchAssistRecordID from t_gl_acctcussent cussent where cussent.FVchAssistRecordID in(").append((CharSequence)sqlIn).append(") and cussent.FUnVerifiedAmtFor <> cussent.ForiginalAmount ");
        sql.append(" union ");
        sql.append("select FVCHASSISTRECORDID from t_gl_acctverify cussent where cussent.FVCHASSISTRECORDID in(").append((CharSequence)sqlIn).append(") and cussent.FUnVerifiedAmtFor <> cussent.ForiginalAmount ");
        ArrayList<String> params = new ArrayList<String>(vchAsstRecordIds);
        params.addAll(params);
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (result.next()) {
                String vchAsstId = result.getString(1);
                hasVerifyMap.put(vchAsstId, Boolean.TRUE);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"query acct history error.", (Throwable)e);
            throw new BOSException("query acct history error.", (Throwable)e);
        }
        return hasVerifyMap;
    }

    @Override
    protected boolean _hasVerifyAboutAsst(Context ctx, String vchAsstId) throws BOSException {
        if (StringUtils.isEmpty((String)vchAsstId)) {
            return false;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select FVchAssistRecordID from t_gl_acctcussent cussent where cussent.FVchAssistRecordID = ? and cussent.FUnVerifiedAmtFor <> cussent.ForiginalAmount ");
        sql.append(" union ");
        sql.append("select FVCHASSISTRECORDID from t_gl_acctverify cussent where cussent.FVCHASSISTRECORDID = ? and cussent.FUnVerifiedAmtFor <> cussent.ForiginalAmount ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{vchAsstId, vchAsstId});
        try {
            if (result.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"query acct history error.", (Throwable)e);
            throw new BOSException("query acct history error.", (Throwable)e);
        }
        return false;
    }

    @Override
    protected void _delAcctData(Context ctx, List<String> idList, int type) throws BOSException, EASBizException {
        if (idList == null || idList.size() <= 0) {
            return;
        }
        if (1 != type && 2 != type) {
            return;
        }
        StringBuilder sqlIn = this.getSqlIn(idList);
        String sql = null;
        try {
            IObjectPK dealAcctLog = LogUtil.beginLog((Context)ctx, (String)"_delAcctData", (BOSObjectType)BOSObjectType.create((String)bosType), null, (String)EASResource.getString((String)this.resource, (String)"delRepeatAcctData"), (String)"delRepeatAcctData");
            if (type == 1) {
                sql = "delete from t_gl_acctcussent where fid in (" + sqlIn.toString() + ") and FUnVerifiedAmtFor = ForiginalAmount";
            } else if (type == 2) {
                sql = "delete from t_gl_acctverify where fid in (" + sqlIn.toString() + ") and FUnVerifiedAmtFor = ForiginalAmount";
            }
            DbUtil.execute((Context)ctx, sql, (Object[])idList.toArray());
            LogUtil.afterLog((Context)ctx, (IObjectPK)dealAcctLog);
        }
        catch (Exception e) {
            logger.error((Object)"del acct data exception.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }
}

