/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountCussentCollection;
import com.kingdee.eas.basedata.assistant.AccountCussentFactory;
import com.kingdee.eas.basedata.assistant.AccountCussentInfo;
import com.kingdee.eas.basedata.assistant.AreaCollection;
import com.kingdee.eas.basedata.assistant.AreaFactory;
import com.kingdee.eas.basedata.assistant.AreaInfo;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemCollection;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CityCollection;
import com.kingdee.eas.basedata.assistant.CityFactory;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CountryCollection;
import com.kingdee.eas.basedata.assistant.CountryFactory;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.ProjectCollection;
import com.kingdee.eas.basedata.assistant.ProjectFactory;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.assistant.ProjectStatus;
import com.kingdee.eas.basedata.assistant.ProvinceCollection;
import com.kingdee.eas.basedata.assistant.ProvinceFactory;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.assistant.RegionCollection;
import com.kingdee.eas.basedata.assistant.RegionFactory;
import com.kingdee.eas.basedata.assistant.RegionInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AuxAccountUtils;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.ShareTacticEnum;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.UsingStatusEnum;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitExtInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FeeTypeCollection;
import com.kingdee.eas.fi.cas.FeeTypeFactory;
import com.kingdee.eas.fi.cas.FeeTypeInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.RunningBusinessMethod;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.nt.NTTypeCollection;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AsstActFinder {
    private static final String RESOURCE = "com.kingdee.eas.fi.gl.AsstActFinder";
    private Map<String, CompanyOrgUnitInfo> companys = new HashMap<String, CompanyOrgUnitInfo>();
    private Map<String, FilterInfo> gFilters = new HashMap<String, FilterInfo>();
    private Map<String, EntityObjectInfo> entityObjects = null;
    private Map<String, Object> gl043s = new HashMap<String, Object>();
    private Map<String, Object> gl069s = new HashMap<String, Object>();
    private Map<String, Set<String>> relationss = new HashMap<String, Set<String>>();
    private Map<String, Map> authOrgss = new HashMap<String, Map>();
    private Map<String, Set<String>> permOrgss = new HashMap<String, Set<String>>();
    private Map<String, AsstActTypeInfo> asstActTypes = new HashMap<String, AsstActTypeInfo>();
    private Map<String, Object> asstActs = new HashMap<String, Object>();
    private int SPLIT_SIZE = 100;
    private boolean ignoreFilter = false;

    private CompanyOrgUnitInfo getCompany(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (this.companys.containsKey(company.getId().toString())) {
            return this.companys.get(company.getId().toString());
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("longNumber");
        selector.add("isAssistantOrg");
        selector.add("mainOrg.id");
        selector.add("CU.id");
        selector.add("CU.number");
        selector.add("CU.name");
        selector.add("CU.longNumber");
        CompanyOrgUnitInfo c = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selector);
        this.companys.put(company.getId().toString(), c);
        return c;
    }

    private AsstActTypeInfo getAsstActType(Context ctx, AsstActTypeInfo asstActType) throws EASBizException, BOSException {
        if (this.asstActTypes.containsKey(asstActType.getId().toString())) {
            return this.asstActTypes.get(asstActType.getId().toString());
        }
        AsstActTypeInfo type = VoucherProcessCache.findAsstActType(ctx, asstActType.getId().toString());
        this.asstActTypes.put(asstActType.getId().toString(), type);
        return type;
    }

    private EntityObjectInfo getEntityObject(Context ctx, String asstHGAttribute) throws BOSException {
        if (this.entityObjects == null) {
            this.entityObjects = new HashMap<String, EntityObjectInfo>();
            IAssistantHG iAssistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
            BOSObjectType type = iAssistantHG.getType();
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo entityObject = loader.getEntity(type);
            PropertyCollection props = entityObject.getInheritedNoDuplicatedProperties();
            for (PropertyInfo p : props) {
                if (!(p instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo prop = (LinkPropertyInfo)p;
                EntityObjectInfo pEntityObject = prop.getRelationship().getSupplierObject();
                this.entityObjects.put(p.getName().toLowerCase(), pEntityObject);
            }
        }
        return this.entityObjects.get(asstHGAttribute.toLowerCase());
    }

    private void initParam(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        if (this.gl043s.containsKey(company.getId().toString())) {
            return;
        }
        HashMap<String, String> in = new HashMap<String, String>();
        in.put("GL_043", company.getId().toString());
        in.put("GL_069", company.getId().toString());
        HashMap out = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(in);
        this.gl043s.put(company.getId().toString(), out.get("GL_043"));
        this.gl069s.put(company.getId().toString(), out.get("GL_069"));
    }

    private FilterInfo getGFilter(Context ctx, AsstActTypeInfo asstActType, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        String key = company.getId() + "_" + asstActType.getId();
        if (this.gFilters.containsKey(key)) {
            return this.gFilters.get(key);
        }
        FilterInfo gFilter = AuxAccountUtils.getFilterForGeneral((Context)ctx, (String)asstActType.getGlAsstActTypeGrp().getId().toString(), (CompanyOrgUnitInfo[])new CompanyOrgUnitInfo[]{company});
        this.gFilters.put(key, gFilter);
        return gFilter;
    }

    private Set<String> getRelations(Context ctx, CompanyOrgUnitInfo company, OrgType fromOrg) throws BOSException {
        String key = company.getId() + "_" + fromOrg.getValue();
        if (this.relationss.containsKey(key)) {
            return this.relationss.get(key);
        }
        boolean isTransferOrg = company.isIsAssistantOrg();
        HashSet<String> companyIdSet = new HashSet<String>();
        companyIdSet.add(company.getId().toString());
        if (isTransferOrg && company.getMainOrg() != null && company.getMainOrg().getId() != null) {
            companyIdSet.add(company.getMainOrg().getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("toUnit.id", companyIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)new Integer(fromOrg.getValue())));
        OrgUnitRelationCollection orColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getOrgUnitRelationCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null));
        HashSet<String> relations = new HashSet<String>();
        relations.add(company.getId().toString());
        int j = orColl.size();
        for (int i = 0; i < j; ++i) {
            relations.add(orColl.get(i).getFromUnit().getId().toString());
        }
        this.relationss.put(key, relations);
        return relations;
    }

    private Set<String> getLegalPerson(Context ctx, CompanyOrgUnitInfo company, String userId, Set<String> existAsstActIds, boolean gl_069, boolean gl_043) throws BOSException, SQLException {
        HashSet<String> personIds = new HashSet<String>();
        if (existAsstActIds == null || existAsstActIds.isEmpty()) {
            return personIds;
        }
        StringBuilder sql = new StringBuilder();
        ArrayList param = new ArrayList();
        sql.append("SELECT PERSON.FID id").append("\n").append("FROM T_BD_Person AS PERSON").append("\n").append("LEFT OUTER JOIN T_ORG_PositionMember AS PM ON PERSON.FID = PM.FPersonID").append("\n").append("LEFT OUTER JOIN T_ORG_Position AS POSITION ON PM.FPositionID = POSITION.FID").append("\n");
        if (gl_069) {
            sql.append("LEFT OUTER JOIN T_ORG_UnitRelation AS ORGUNITRELATION ON POSITION.FAdminOrgUnitID = ORGUNITRELATION.FFromUnitID").append("\n").append("LEFT OUTER JOIN T_ORG_TypeRelation AS TYPERELATION ON ORGUNITRELATION.FTypeRelationID = TYPERELATION.FID").append("\n");
        }
        sql.append("WHERE 1= 1").append("\n");
        if (gl_069) {
            int i;
            boolean isTransfer = company.isIsAssistantOrg();
            HashSet<String> companyIdSet = new HashSet<String>();
            companyIdSet.add(company.getId().toString());
            if (isTransfer && company.getMainOrg() != null && company.getMainOrg().getId() != null) {
                companyIdSet.add(company.getMainOrg().getId().toString());
            }
            sql.append("and (ORGUNITRELATION.FToUnitID in ( ").append("\n");
            for (i = 0; i < companyIdSet.size(); ++i) {
                sql.append("?");
                if (i == companyIdSet.size() - 1) continue;
                sql.append(",");
            }
            sql.append(") ");
            param.addAll(companyIdSet);
            sql.append("AND TYPERELATION.FfromType = 0 and TYPERELATION.FtoType = 1").append("\n");
            sql.append("OR (PM.FPositionID IS NULL and PERSON.FGKAdmin IN (SELECT a.FFromUnitID FROM T_ORG_UnitRelation a INNER JOIN T_ORG_TypeRelation b ON a.FTypeRelationID = b.FID ");
            sql.append("WHERE a.FToUnitID in ( ").append("\n");
            for (i = 0; i < companyIdSet.size(); ++i) {
                sql.append("?");
                if (i == companyIdSet.size() - 1) continue;
                sql.append(",");
            }
            sql.append(") ");
            param.addAll(companyIdSet);
            sql.append("AND b.FToType = 1 AND b.FFromType = 0)))").append("\n");
        } else if (gl_043) {
            sql.append("and (POSITION.FAdminOrgUnitID IN (select org.FId from T_ORG_Admin org INNER JOIN T_PM_OrgRange orgRange ON org.FID = orgRange.FOrgID WHERE orgRange.FType = 20 and orgRange.FUserID= ?)").append("\n");
            param.add(userId);
            sql.append("or  PERSON.FGKAdmin IN (select org.FId from T_ORG_Admin org INNER JOIN T_PM_OrgRange orgRange ON org.FID = orgRange.FOrgID WHERE orgRange.FType = 20 and orgRange.FUserID= ?))").append("\n");
            param.add(userId);
        }
        sql.append("and PERSON.FID in ( ").append("\n");
        for (int i = 0; i < existAsstActIds.size(); ++i) {
            sql.append("?");
            if (i == existAsstActIds.size() - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        param.addAll(existAsstActIds);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        while (rs.next()) {
            personIds.add(rs.getString("id"));
        }
        return personIds;
    }

    private Map getAuthOrgs(Context ctx, String userId, OrgType fromOrg) throws BOSException, EASBizException {
        String key = userId + "_" + fromOrg.getValue();
        if (this.authOrgss.containsKey(key)) {
            return this.authOrgss.get(key);
        }
        HashMap authOrgs = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrgs((IObjectPK)new ObjectUuidPK(userId), fromOrg, null, null, null);
        if (authOrgs == null) {
            authOrgs = new HashMap();
        }
        this.authOrgss.put(key, authOrgs);
        return authOrgs;
    }

    private Set<String> getPermOrgs(Context ctx, String userId, String permItemName) throws EASBizException, BOSException {
        String key = userId + "_" + permItemName;
        if (this.permOrgss.containsKey(key)) {
            return this.permOrgss.get(key);
        }
        String rule = PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"), permItemName);
        String sql = "select id where id in (" + rule + ") and id in (select forgid from t_pm_orgrange where fuserid = '" + userId + "' and ftype = " + 10 + ")";
        IObjectPK[] pks = FullOrgUnitFactory.getLocalInstance((Context)ctx).getPKList(sql);
        HashSet<String> permOrgs = new HashSet<String>();
        if (pks != null) {
            for (IObjectPK pk : pks) {
                permOrgs.add(pk.toString());
            }
        }
        this.permOrgss.put(key, permOrgs);
        return permOrgs;
    }

    private String getCompanyPKey(AsstActTypeInfo asstActType, CompanyOrgUnitInfo company, String cuId, String userId) {
        String asstHGAttribute = asstActType.getAsstHGAttribute();
        if ("material".equalsIgnoreCase(asstHGAttribute) || "customer".equalsIgnoreCase(asstHGAttribute) || "provider".equalsIgnoreCase(asstHGAttribute) || "bankAccount".equalsIgnoreCase(asstHGAttribute) || "costObject".equalsIgnoreCase(asstHGAttribute) || "adminOrg".equalsIgnoreCase(asstHGAttribute) || "saleOrg".equalsIgnoreCase(asstHGAttribute) || "profitOrg".equalsIgnoreCase(asstHGAttribute) || "purchaseOrg".equalsIgnoreCase(asstHGAttribute) || "storeageOrg".equalsIgnoreCase(asstHGAttribute) || "companyOrg".equalsIgnoreCase(asstHGAttribute) || "costOrg".equalsIgnoreCase(asstHGAttribute) || asstHGAttribute.startsWith("generalAssActType")) {
            return company.getId() + "_";
        }
        return "";
    }

    private String getCuPKey(AsstActTypeInfo asstActType, CompanyOrgUnitInfo company, String cuId, String userId) {
        String asstHGAttribute = asstActType.getAsstHGAttribute();
        if (asstHGAttribute.startsWith("generalAssActType")) {
            return cuId + "_";
        }
        return "";
    }

    private String getUserPKey(AsstActTypeInfo asstActType, CompanyOrgUnitInfo company, String cuId, String userId) {
        String asstHGAttribute = asstActType.getAsstHGAttribute();
        if ("adminOrg".equalsIgnoreCase(asstHGAttribute) || "saleOrg".equalsIgnoreCase(asstHGAttribute) || "profitOrg".equalsIgnoreCase(asstHGAttribute) || "purchaseOrg".equalsIgnoreCase(asstHGAttribute) || "storeageOrg".equalsIgnoreCase(asstHGAttribute) || "companyOrg".equalsIgnoreCase(asstHGAttribute) || "costOrg".equalsIgnoreCase(asstHGAttribute)) {
            return userId + "_";
        }
        return "";
    }

    protected String getAsstActName(DataBaseInfo asstAct) {
        return "[" + asstAct.getNumber() + "," + asstAct.getName() + "] ";
    }

    protected String getResource(Context ctx, String key) {
        return ResourceBase.getString((String)RESOURCE, (String)key, (Locale)ctx.getLocale());
    }

    private List<Set<String>> split(Set<String> set, int size) {
        ArrayList<Set<String>> list = new ArrayList<Set<String>>();
        if (set.size() <= size) {
            HashSet<String> part = new HashSet<String>();
            part.addAll(set);
            list.add(part);
        } else {
            HashSet<String> part = new HashSet<String>();
            for (String str : set) {
                part.add(str);
                if (part.size() < size) continue;
                list.add(part);
                part = new HashSet();
            }
            if (part.size() > 0) {
                list.add(part);
            }
        }
        return list;
    }

    public Map<String, Object> findAsstActByIds(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId) throws Exception {
        Object param = asstActType.get("ignoreFilter");
        if (param != null && param instanceof Boolean) {
            this.ignoreFilter = (Boolean)param;
        }
        if (asstActIds.size() <= this.SPLIT_SIZE) {
            return this.doFindAsstActByIds(ctx, asstActType, asstActIds, company, cuId, userId);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Set<String>> parts = this.split(asstActIds, this.SPLIT_SIZE);
        for (Set<String> part : parts) {
            result.putAll(this.doFindAsstActByIds(ctx, asstActType, part, company, cuId, userId));
        }
        return result;
    }

    public Map<String, Object> doFindAsstActByIds(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        asstActType = this.getAsstActType(ctx, asstActType);
        Set relatedCompanys = company.get("relatedcompanys") != null ? (Set)company.get("relatedcompanys") : null;
        company = this.getCompany(ctx, company);
        if (relatedCompanys != null) {
            company.put("relatedcompanys", (Object)relatedCompanys);
        }
        if (cuId == null || cuId.length() == 0) {
            cuId = company.getCU().getId().toString();
        }
        if (userId == null) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        String asstHGAttribute = asstActType.getAsstHGAttribute();
        String pKey = this.getCompanyPKey(asstActType, company, cuId, userId) + this.getCuPKey(asstActType, company, cuId, userId) + this.getUserPKey(asstActType, company, cuId, userId) + asstHGAttribute + "_";
        HashSet<String> newAsstActIds = new HashSet<String>();
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            if (this.asstActs.containsKey(key)) {
                result.put(asstActId, this.asstActs.get(key));
                continue;
            }
            newAsstActIds.add(asstActId);
        }
        if (newAsstActIds.size() <= 0) {
            return result;
        }
        if ("material".equalsIgnoreCase(asstHGAttribute)) {
            this.findMaterial(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("customer".equalsIgnoreCase(asstHGAttribute)) {
            this.findCustomer(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("provider".equalsIgnoreCase(asstHGAttribute)) {
            this.findProvider(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("project".equalsIgnoreCase(asstHGAttribute)) {
            this.findProject(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("bankAccount".equalsIgnoreCase(asstHGAttribute)) {
            this.findBankAccount(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("industry".equalsIgnoreCase(asstHGAttribute)) {
            this.findIndustry(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("region".equalsIgnoreCase(asstHGAttribute)) {
            this.findRegion(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("cashFlowItem".equalsIgnoreCase(asstHGAttribute)) {
            this.findCashFlowItem(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("country".equalsIgnoreCase(asstHGAttribute)) {
            this.findCountry(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("province".equalsIgnoreCase(asstHGAttribute)) {
            this.findProvince(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("city".equalsIgnoreCase(asstHGAttribute)) {
            this.findCity(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("accountCussent".equalsIgnoreCase(asstHGAttribute)) {
            this.findAccountCussent(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("costObject".equalsIgnoreCase(asstHGAttribute)) {
            this.findCostObject(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("adminOrg".equalsIgnoreCase(asstHGAttribute)) {
            this.findAdminOrg(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("saleOrg".equalsIgnoreCase(asstHGAttribute) || "profitOrg".equalsIgnoreCase(asstHGAttribute) || "purchaseOrg".equalsIgnoreCase(asstHGAttribute) || "storeageOrg".equalsIgnoreCase(asstHGAttribute) || "companyOrg".equalsIgnoreCase(asstHGAttribute) || "costOrg".equalsIgnoreCase(asstHGAttribute)) {
            this.findOrg(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("person".equalsIgnoreCase(asstHGAttribute)) {
            this.findPerson(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if (asstHGAttribute.startsWith("generalAssActType")) {
            this.findGeneral(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("innerAccount".equalsIgnoreCase(asstHGAttribute)) {
            this.findInnerAccount(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("fpItem".equalsIgnoreCase(asstHGAttribute)) {
            this.findFpItem(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("ntType".equalsIgnoreCase(asstHGAttribute)) {
            this.findNtType(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("feeType".equalsIgnoreCase(asstHGAttribute)) {
            this.findFeeType(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("costItem".equalsIgnoreCase(asstHGAttribute)) {
            this.findCostItem(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("nation".equalsIgnoreCase(asstHGAttribute)) {
            this.findNation(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("area".equalsIgnoreCase(asstHGAttribute)) {
            this.findArea(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else if ("village".equalsIgnoreCase(asstHGAttribute)) {
            this.findVillage(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        } else {
            this.findOther(ctx, asstActType, newAsstActIds, company, cuId, userId, pKey);
        }
        for (String asstActId : newAsstActIds) {
            result.put(asstActId, this.asstActs.get(pKey + asstActId));
        }
        return result;
    }

    public Map<String, Object> findAsstActByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws Exception {
        Object param = asstActType.get("ignoreFilter");
        if (param != null && param instanceof Boolean) {
            this.ignoreFilter = (Boolean)param;
        }
        if (asstActNumbers.size() <= this.SPLIT_SIZE) {
            return this.doFindAsstActByNumbers(ctx, asstActType, asstActNumbers, company, cuId, userId);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Set<String>> parts = this.split(asstActNumbers, this.SPLIT_SIZE);
        for (Set<String> part : parts) {
            result.putAll(this.doFindAsstActByNumbers(ctx, asstActType, part, company, cuId, userId));
        }
        return result;
    }

    public Map<String, Object> doFindAsstActByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        asstActType = this.getAsstActType(ctx, asstActType);
        company = this.getCompany(ctx, company);
        if (cuId == null || cuId.length() == 0) {
            cuId = company.getCU().getId().toString();
        }
        if (userId == null) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        String asstHGAttribute = asstActType.getAsstHGAttribute();
        String pKey = company.getId() + "_" + cuId + "_" + userId + "_" + asstHGAttribute + "_";
        HashSet<String> newAsstActNumbers = new HashSet<String>();
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            if (this.asstActs.containsKey(key)) {
                result.put(asstActNumber, this.asstActs.get(key));
                continue;
            }
            newAsstActNumbers.add(asstActNumber);
        }
        if (newAsstActNumbers.size() <= 0) {
            return result;
        }
        if ("material".equalsIgnoreCase(asstHGAttribute)) {
            this.findMaterialByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("customer".equalsIgnoreCase(asstHGAttribute)) {
            this.findCustomerByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("provider".equalsIgnoreCase(asstHGAttribute)) {
            this.findProviderByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("project".equalsIgnoreCase(asstHGAttribute)) {
            this.findProjectByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("bankAccount".equalsIgnoreCase(asstHGAttribute)) {
            this.findBankAccountByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("industry".equalsIgnoreCase(asstHGAttribute)) {
            this.findIndustryByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("region".equalsIgnoreCase(asstHGAttribute)) {
            this.findRegionByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("cashFlowItem".equalsIgnoreCase(asstHGAttribute)) {
            this.findCashFlowItemByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("country".equalsIgnoreCase(asstHGAttribute)) {
            this.findCountryByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("province".equalsIgnoreCase(asstHGAttribute)) {
            this.findProvinceByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("city".equalsIgnoreCase(asstHGAttribute)) {
            this.findCityByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("accountCussent".equalsIgnoreCase(asstHGAttribute)) {
            this.findAccountCussentByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("costObject".equalsIgnoreCase(asstHGAttribute)) {
            this.findCostObjectByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("adminOrg".equalsIgnoreCase(asstHGAttribute)) {
            this.findAdminOrgByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("saleOrg".equalsIgnoreCase(asstHGAttribute) || "profitOrg".equalsIgnoreCase(asstHGAttribute) || "purchaseOrg".equalsIgnoreCase(asstHGAttribute) || "storeageOrg".equalsIgnoreCase(asstHGAttribute) || "companyOrg".equalsIgnoreCase(asstHGAttribute) || "costOrg".equalsIgnoreCase(asstHGAttribute)) {
            this.findOrgByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("person".equalsIgnoreCase(asstHGAttribute)) {
            this.findPersonByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if (asstHGAttribute.startsWith("generalAssActType")) {
            this.findGeneralByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("innerAccount".equalsIgnoreCase(asstHGAttribute)) {
            this.findInnerAccountByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("fpItem".equalsIgnoreCase(asstHGAttribute)) {
            this.findFpItemByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("ntType".equalsIgnoreCase(asstHGAttribute)) {
            this.findNtTypeByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("feeType".equalsIgnoreCase(asstHGAttribute)) {
            this.findFeeTypeByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("costItem".equalsIgnoreCase(asstHGAttribute)) {
            this.findCostItemByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("nation".equalsIgnoreCase(asstHGAttribute)) {
            this.findNationByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("area".equalsIgnoreCase(asstHGAttribute)) {
            this.findAreaByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else if ("village".equalsIgnoreCase(asstHGAttribute)) {
            this.findVillageByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        } else {
            this.findOtherByNumbers(ctx, asstActType, newAsstActNumbers, company, cuId, userId, pKey);
        }
        for (String asstActNumber : newAsstActNumbers) {
            result.put(asstActNumber, this.asstActs.get(pKey + asstActNumber));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void findMaterial(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("status");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        MaterialCollection coll = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
        HashMap<String, MaterialInfo> aas = new HashMap<String, MaterialInfo>();
        for (MaterialInfo materialInfo : coll) {
            aas.put(materialInfo.getId().toString(), materialInfo);
        }
        if (this.ignoreFilter) {
            for (String string : asstActIds) {
                String key = pKey + string;
                MaterialInfo aa = (MaterialInfo)aas.get(string);
                if (aa == null) {
                    this.asstActs.put(key, "[" + string + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        HashSet<String> existAsstActIds = new HashSet<String>();
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            MaterialInfo aa = (MaterialInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (UsedStatusEnum.FREEZED.equals((Object)aa.getStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "FREEZED"));
                continue;
            }
            if (!UsedStatusEnum.APPROVED.equals((Object)aa.getStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + aa.getStatus().toString());
                continue;
            }
            existAsstActIds.add(asstActId);
        }
        if (existAsstActIds.size() > 0) {
            void var14_20;
            view = new EntityViewInfo();
            selector = new SelectorItemCollection();
            view.setSelector(selector);
            selector.add("id");
            selector.add("status");
            selector.add("mateial.id");
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("mateial.id", existAsstActIds, CompareType.INCLUDE));
            Object var14_18 = null;
            if (company.get("relatedcompanys") != null) {
                Set set = (Set)company.get("relatedcompanys");
            }
            if (var14_20 != null && var14_20.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)var14_20, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
            }
            MaterialCompanyInfoCollection cColl = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(view);
            HashMap<String, MaterialCompanyInfoInfo> aacs = new HashMap<String, MaterialCompanyInfoInfo>();
            for (MaterialCompanyInfoInfo aac : cColl) {
                aacs.put(aac.getMateial().getId().toString(), aac);
            }
            for (String asstActId : existAsstActIds) {
                String key = pKey + asstActId;
                MaterialInfo aa = (MaterialInfo)aas.get(asstActId);
                MaterialCompanyInfoInfo aac = (MaterialCompanyInfoInfo)aacs.get(asstActId);
                if (aac == null) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_ASSIGN"));
                    continue;
                }
                if (UsedStatusEnum.FREEZED.equals((Object)aac.getStatus())) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "COMPANY_INFO_FREEZED"));
                    continue;
                }
                if (!UsedStatusEnum.APPROVED.equals((Object)aac.getStatus())) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "COMPANY_INFO") + aac.getStatus().toString());
                    continue;
                }
                this.asstActs.put(key, aa);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void findMaterialByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("status");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        MaterialCollection coll = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
        HashMap<String, MaterialInfo> aas = new HashMap<String, MaterialInfo>();
        for (MaterialInfo materialInfo : coll) {
            aas.put(materialInfo.getNumber(), materialInfo);
        }
        if (this.ignoreFilter) {
            for (String string : asstActNumbers) {
                String key = pKey + string;
                MaterialInfo aa = (MaterialInfo)aas.get(string);
                if (aa == null) {
                    this.asstActs.put(key, "[" + string + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        HashMap<String, String> existAsstActNumbers = new HashMap<String, String>();
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            MaterialInfo aa = (MaterialInfo)aas.get(asstActNumber);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (UsedStatusEnum.FREEZED.equals((Object)aa.getStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "FREEZED"));
                continue;
            }
            if (!UsedStatusEnum.APPROVED.equals((Object)aa.getStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + aa.getStatus().toString());
                continue;
            }
            existAsstActNumbers.put(aa.getNumber(), aa.getId().toString());
        }
        if (existAsstActNumbers.size() > 0) {
            void var14_20;
            view = new EntityViewInfo();
            selector = new SelectorItemCollection();
            view.setSelector(selector);
            selector.add("id");
            selector.add("status");
            selector.add("mateial.id");
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("mateial.id", new HashSet(existAsstActNumbers.values()), CompareType.INCLUDE));
            Object var14_18 = null;
            if (company.get("relatedcompanys") != null) {
                Set set = (Set)company.get("relatedcompanys");
            }
            if (var14_20 != null && var14_20.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)var14_20, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
            }
            MaterialCompanyInfoCollection cColl = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(view);
            HashMap<String, MaterialCompanyInfoInfo> aacs = new HashMap<String, MaterialCompanyInfoInfo>();
            for (MaterialCompanyInfoInfo aac : cColl) {
                aacs.put(aac.getMateial().getId().toString(), aac);
            }
            for (String asstActNumber : existAsstActNumbers.keySet()) {
                String key = pKey + asstActNumber;
                MaterialInfo aa = (MaterialInfo)aas.get(asstActNumber);
                MaterialCompanyInfoInfo aac = (MaterialCompanyInfoInfo)aacs.get(existAsstActNumbers.get(asstActNumber));
                if (aac == null) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_ASSIGN"));
                    continue;
                }
                if (UsedStatusEnum.FREEZED.equals((Object)aac.getStatus())) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "COMPANY_INFO_FREEZED"));
                    continue;
                }
                if (!UsedStatusEnum.APPROVED.equals((Object)aac.getStatus())) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "COMPANY_INFO") + aac.getStatus().toString());
                    continue;
                }
                this.asstActs.put(key, aa);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void findCustomer(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("usedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        CustomerCollection coll = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollection(view);
        HashMap<String, CustomerInfo> aas = new HashMap<String, CustomerInfo>();
        for (CustomerInfo customerInfo : coll) {
            aas.put(customerInfo.getId().toString(), customerInfo);
        }
        if (this.ignoreFilter) {
            for (String string : asstActIds) {
                String key = pKey + string;
                CustomerInfo aa = (CustomerInfo)aas.get(string);
                if (aa == null) {
                    this.asstActs.put(key, "[" + string + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        HashSet<String> existAsstActIds = new HashSet<String>();
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            CustomerInfo aa = (CustomerInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (com.kingdee.eas.basedata.master.cssp.UsedStatusEnum.FREEZED.equals((Object)aa.getUsedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "FREEZED"));
                continue;
            }
            if (!com.kingdee.eas.basedata.master.cssp.UsedStatusEnum.APPROVED.equals((Object)aa.getUsedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + aa.getUsedStatus().toString());
                continue;
            }
            existAsstActIds.add(asstActId);
        }
        if (existAsstActIds.size() > 0) {
            void var14_20;
            view = new EntityViewInfo();
            selector = new SelectorItemCollection();
            view.setSelector(selector);
            selector.add("id");
            selector.add("usingStatus");
            selector.add("effectedStatus");
            selector.add("customer.id");
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("customer.id", existAsstActIds, CompareType.INCLUDE));
            Object var14_18 = null;
            if (company.get("relatedcompanys") != null) {
                Set set = (Set)company.get("relatedcompanys");
            }
            if (var14_20 != null && var14_20.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)var14_20, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
            }
            CustomerCompanyInfoCollection cColl = CustomerCompanyInfoFactory.getLocalInstance((Context)ctx).getCustomerCompanyInfoCollection(view);
            HashMap<String, CustomerCompanyInfoInfo> aacs = new HashMap<String, CustomerCompanyInfoInfo>();
            for (CustomerCompanyInfoInfo aac : cColl) {
                aacs.put(aac.getCustomer().getId().toString(), aac);
            }
            for (String asstActId : existAsstActIds) {
                String key = pKey + asstActId;
                CustomerInfo aa = (CustomerInfo)aas.get(asstActId);
                CustomerCompanyInfoInfo aac = (CustomerCompanyInfoInfo)aacs.get(asstActId);
                if (aac == null) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_ASSIGN"));
                    continue;
                }
                if (UsingStatusEnum.FREEZED.equals((Object)aac.getUsingStatus())) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "COMPANY_INFO_FREEZED"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void findCustomerByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("usedStatus");
        selector.add("isInternalCompany");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        CustomerCollection coll = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollection(view);
        HashMap<String, CustomerInfo> aas = new HashMap<String, CustomerInfo>();
        for (CustomerInfo customerInfo : coll) {
            aas.put(customerInfo.getNumber(), customerInfo);
        }
        if (this.ignoreFilter) {
            for (String string : asstActNumbers) {
                String key = pKey + string;
                CustomerInfo aa = (CustomerInfo)aas.get(string);
                if (aa == null) {
                    this.asstActs.put(key, "[" + string + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        HashMap<String, String> existAsstActNumbers = new HashMap<String, String>();
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            CustomerInfo aa = (CustomerInfo)aas.get(asstActNumber);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (com.kingdee.eas.basedata.master.cssp.UsedStatusEnum.FREEZED.equals((Object)aa.getUsedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "FREEZED"));
                continue;
            }
            if (!com.kingdee.eas.basedata.master.cssp.UsedStatusEnum.APPROVED.equals((Object)aa.getUsedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + aa.getUsedStatus().toString());
                continue;
            }
            existAsstActNumbers.put(asstActNumber, aa.getId().toString());
        }
        if (existAsstActNumbers.size() > 0) {
            void var14_20;
            view = new EntityViewInfo();
            selector = new SelectorItemCollection();
            view.setSelector(selector);
            selector.add("id");
            selector.add("usingStatus");
            selector.add("effectedStatus");
            selector.add("customer.id");
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("customer.id", new HashSet(existAsstActNumbers.values()), CompareType.INCLUDE));
            Object var14_18 = null;
            if (company.get("relatedcompanys") != null) {
                Set set = (Set)company.get("relatedcompanys");
            }
            if (var14_20 != null && var14_20.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)var14_20, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
            }
            CustomerCompanyInfoCollection cColl = CustomerCompanyInfoFactory.getLocalInstance((Context)ctx).getCustomerCompanyInfoCollection(view);
            HashMap<String, CustomerCompanyInfoInfo> aacs = new HashMap<String, CustomerCompanyInfoInfo>();
            for (CustomerCompanyInfoInfo aac : cColl) {
                aacs.put(aac.getCustomer().getId().toString(), aac);
            }
            for (String asstActNumber : existAsstActNumbers.keySet()) {
                String key = pKey + asstActNumber;
                CustomerInfo aa = (CustomerInfo)aas.get(asstActNumber);
                CustomerCompanyInfoInfo aac = (CustomerCompanyInfoInfo)aacs.get(existAsstActNumbers.get(asstActNumber));
                if (aac == null) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_ASSIGN"));
                    continue;
                }
                if (UsingStatusEnum.FREEZED.equals((Object)aac.getUsingStatus())) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "COMPANY_INFO_FREEZED"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void findProvider(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("usedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        SupplierCollection coll = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(view);
        HashMap<String, SupplierInfo> aas = new HashMap<String, SupplierInfo>();
        for (SupplierInfo supplierInfo : coll) {
            aas.put(supplierInfo.getId().toString(), supplierInfo);
        }
        if (this.ignoreFilter) {
            for (String string : asstActIds) {
                String key = pKey + string;
                SupplierInfo aa = (SupplierInfo)aas.get(string);
                if (aa == null) {
                    this.asstActs.put(key, "[" + string + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        HashSet<String> existAsstActIds = new HashSet<String>();
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            SupplierInfo aa = (SupplierInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (com.kingdee.eas.basedata.master.cssp.UsedStatusEnum.FREEZED.equals((Object)aa.getUsedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "FREEZED"));
                continue;
            }
            if (!com.kingdee.eas.basedata.master.cssp.UsedStatusEnum.APPROVED.equals((Object)aa.getUsedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + aa.getUsedStatus().toString());
                continue;
            }
            existAsstActIds.add(asstActId);
        }
        if (existAsstActIds.size() > 0) {
            void var14_20;
            view = new EntityViewInfo();
            selector = new SelectorItemCollection();
            view.setSelector(selector);
            selector.add("id");
            selector.add("usingStatus");
            selector.add("effectedStatus");
            selector.add("supplier.id");
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", existAsstActIds, CompareType.INCLUDE));
            Object var14_18 = null;
            if (company.get("relatedcompanys") != null) {
                Set set = (Set)company.get("relatedcompanys");
            }
            if (var14_20 != null && var14_20.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)var14_20, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
            }
            SupplierCompanyInfoCollection cColl = SupplierCompanyInfoFactory.getLocalInstance((Context)ctx).getSupplierCompanyInfoCollection(view);
            HashMap<String, SupplierCompanyInfoInfo> aacs = new HashMap<String, SupplierCompanyInfoInfo>();
            for (SupplierCompanyInfoInfo aac : cColl) {
                aacs.put(aac.getSupplier().getId().toString(), aac);
            }
            for (String asstActId : existAsstActIds) {
                String key = pKey + asstActId;
                SupplierInfo aa = (SupplierInfo)aas.get(asstActId);
                SupplierCompanyInfoInfo aac = (SupplierCompanyInfoInfo)aacs.get(asstActId);
                if (aac == null) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_ASSIGN"));
                    continue;
                }
                if (UsingStatusEnum.FREEZED.equals((Object)aac.getUsingStatus())) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "COMPANY_INFO_FREEZED"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void findProviderByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("usedStatus");
        selector.add("isInternalCompany");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        SupplierCollection coll = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(view);
        HashMap<String, SupplierInfo> aas = new HashMap<String, SupplierInfo>();
        for (SupplierInfo supplierInfo : coll) {
            aas.put(supplierInfo.getNumber(), supplierInfo);
        }
        if (this.ignoreFilter) {
            for (String string : asstActNumbers) {
                String key = pKey + string;
                SupplierInfo aa = (SupplierInfo)aas.get(string);
                if (aa == null) {
                    this.asstActs.put(key, "[" + string + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        HashMap<String, String> existAsstActNumbers = new HashMap<String, String>();
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            SupplierInfo aa = (SupplierInfo)aas.get(asstActNumber);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (com.kingdee.eas.basedata.master.cssp.UsedStatusEnum.FREEZED.equals((Object)aa.getUsedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "FREEZED"));
                continue;
            }
            if (!com.kingdee.eas.basedata.master.cssp.UsedStatusEnum.APPROVED.equals((Object)aa.getUsedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + aa.getUsedStatus().toString());
                continue;
            }
            existAsstActNumbers.put(asstActNumber, aa.getId().toString());
        }
        if (existAsstActNumbers.size() > 0) {
            void var14_20;
            view = new EntityViewInfo();
            selector = new SelectorItemCollection();
            view.setSelector(selector);
            selector.add("id");
            selector.add("usingStatus");
            selector.add("effectedStatus");
            selector.add("supplier.id");
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", new HashSet(existAsstActNumbers.values()), CompareType.INCLUDE));
            Object var14_18 = null;
            if (company.get("relatedcompanys") != null) {
                Set set = (Set)company.get("relatedcompanys");
            }
            if (var14_20 != null && var14_20.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)var14_20, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
            }
            SupplierCompanyInfoCollection cColl = SupplierCompanyInfoFactory.getLocalInstance((Context)ctx).getSupplierCompanyInfoCollection(view);
            HashMap<String, SupplierCompanyInfoInfo> aacs = new HashMap<String, SupplierCompanyInfoInfo>();
            for (SupplierCompanyInfoInfo aac : cColl) {
                aacs.put(aac.getSupplier().getId().toString(), aac);
            }
            for (String asstActNumber : existAsstActNumbers.keySet()) {
                String key = pKey + asstActNumber;
                SupplierInfo aa = (SupplierInfo)aas.get(asstActNumber);
                SupplierCompanyInfoInfo aac = (SupplierCompanyInfoInfo)aacs.get(existAsstActNumbers.get(asstActNumber));
                if (aac == null) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_ASSIGN"));
                    continue;
                }
                if (UsingStatusEnum.FREEZED.equals((Object)aac.getUsingStatus())) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "COMPANY_INFO_FREEZED"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
        }
    }

    private void findProject(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("longNumber");
        selector.add("status");
        selector.add("isLeaf");
        selector.add("company.id");
        selector.add("company.number");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        ProjectCollection coll = ProjectFactory.getLocalInstance((Context)ctx).getProjectCollection(view);
        HashMap<String, ProjectInfo> aas = new HashMap<String, ProjectInfo>();
        for (ProjectInfo aa : coll) {
            aas.put(aa.getId().toString(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActId : asstActIds) {
                String key = pKey + asstActId;
                ProjectInfo aa = (ProjectInfo)aas.get(asstActId);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        String projectIsolate = GlUtils.getProjectIsolateParam(ctx);
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            ProjectInfo aa = (ProjectInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (!aa.isIsLeaf()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_LEAF"));
                continue;
            }
            if (ProjectStatus.CLOSE.equals((Object)aa.getStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "CLOSED"));
                continue;
            }
            if ("1".equals(projectIsolate)) {
                String companyId = company != null && company.getId() != null ? company.getId().toString() : null;
                if (companyId == null || aa.getCompany() == null || aa.getCompany().getId() == null) continue;
                if (company.isIsAssistantOrg()) {
                    String masterCompanyId;
                    String string = masterCompanyId = company.getMainOrg() != null && company.getMainOrg().getId() != null ? company.getMainOrg().getId().toString() : null;
                    if (masterCompanyId == null) {
                        HashSet<String> companyIdSet = new HashSet<String>();
                        companyIdSet.add(companyId);
                        Set masterIdSet = GlUtils.getMasterCompanyIdSet(companyIdSet);
                        String[] masterIdArr = (String[])masterIdSet.toArray();
                        masterCompanyId = masterIdArr[0];
                    }
                    if (!companyId.equals(aa.getCompany().getId().toString()) && !masterCompanyId.equals(aa.getCompany().getId().toString())) {
                        this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_FOUND"));
                        continue;
                    }
                    this.asstActs.put(key, aa);
                    continue;
                }
                if (!companyId.equals(aa.getCompany().getId().toString())) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
                continue;
            }
            if ("2".equals(projectIsolate)) {
                CompanyOrgUnitInfo[] masterCompanys;
                String longNumber = company != null && company.getLongNumber() != null ? company.getLongNumber() : null;
                if (longNumber == null) continue;
                String[] numberArr = longNumber.split("!");
                HashSet<String> numberSet = new HashSet<String>();
                numberSet.addAll(Arrays.asList(numberArr));
                if (company.isIsAssistantOrg() && (masterCompanys = GlUtils.getMasterCompanys(ctx, new CompanyOrgUnitInfo[]{company})) != null && masterCompanys.length > 0) {
                    for (int i = 0; i < masterCompanys.length; ++i) {
                        String[] maNumberArr = masterCompanys[i].getLongNumber().split("!");
                        numberSet.addAll(Arrays.asList(maNumberArr));
                    }
                }
                if (numberSet != null && !numberSet.isEmpty() && aa.getCompany() != null && aa.getCompany().getNumber() != null && !numberSet.contains(aa.getCompany().getNumber())) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findProjectByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("longNumber");
        selector.add("status");
        selector.add("isLeaf");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        HashMap<String, String> transforms = new HashMap<String, String>();
        if (asstActType.isUseLongNumber()) {
            HashSet asstActLongNumbers = new HashSet();
            for (String asstActNumber : asstActNumbers) {
                String asstActLongNumber = asstActNumber;
                if (asstActLongNumber.indexOf(46) >= 0) {
                    asstActLongNumber = asstActNumber.replace('.', '!');
                }
                asstActLongNumbers.add(asstActLongNumber);
                transforms.put(asstActNumber, asstActLongNumber);
            }
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)asstActLongNumbers, CompareType.INCLUDE));
        } else {
            for (String asstActNumber : asstActNumbers) {
                transforms.put(asstActNumber, asstActNumber);
            }
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        String projectIsolate = GlUtils.getProjectIsolateParam(ctx);
        if ("1".equals(projectIsolate)) {
            String companyId;
            String string = companyId = company != null && company.getId() != null ? company.getId().toString() : null;
            if (companyId != null) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
            }
        } else if ("2".equals(projectIsolate)) {
            String longNumber;
            String string = longNumber = company != null && company.getLongNumber() != null ? company.getLongNumber() : null;
            if (longNumber != null) {
                String[] numberArr = longNumber.split("!");
                HashSet<String> numberSet = new HashSet<String>();
                numberSet.addAll(Arrays.asList(numberArr));
                if (numberSet != null && numberSet.size() > 0) {
                    filter.getFilterItems().add(new FilterItemInfo("company.number", numberSet, CompareType.INCLUDE));
                }
            }
        }
        ProjectCollection coll = ProjectFactory.getLocalInstance((Context)ctx).getProjectCollection(view);
        HashMap<String, ProjectInfo> aas = new HashMap<String, ProjectInfo>();
        for (ProjectInfo aa : coll) {
            if (asstActType.isUseLongNumber()) {
                aas.put(aa.getLongNumber(), aa);
                continue;
            }
            aas.put(aa.getNumber(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActNumber : asstActNumbers) {
                String key = pKey + asstActNumber;
                ProjectInfo aa = (ProjectInfo)aas.get(transforms.get(asstActNumber));
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            ProjectInfo aa = (ProjectInfo)aas.get(transforms.get(asstActNumber));
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (!aa.isIsLeaf()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_LEAF"));
                continue;
            }
            if (ProjectStatus.CLOSE.equals((Object)aa.getStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "CLOSED"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findBankAccount(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        AccountBankInfo aa;
        String key;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("bank.id");
        selector.add("bank.name");
        selector.add("account.id");
        selector.add("bankAccountNumber");
        selector.add("isByCurrency");
        selector.add("currency.id");
        selector.add("company.id");
        selector.add("isClosed");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        HashMap<String, AccountBankInfo> aas = new HashMap<String, AccountBankInfo>();
        for (AccountBankInfo aa2 : coll) {
            aas.put(aa2.getId().toString(), aa2);
        }
        if (this.ignoreFilter) {
            for (String asstActId : asstActIds) {
                key = pKey + asstActId;
                aa = (AccountBankInfo)aas.get(asstActId);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
        }
        for (String asstActId : asstActIds) {
            key = pKey + asstActId;
            aa = (AccountBankInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (aa.isIsClosed()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "ACCOUNT_CLOSED"));
                continue;
            }
            HashSet<String> orgIds = new HashSet<String>();
            orgIds.add(company.getId().toString());
            if (company.isIsAssistantOrg()) {
                orgIds.add(company.getMainOrg().getId().toString());
            }
            if (company.get("relatedcompanys") != null) {
                Set relatedCompanys = (Set)company.get("relatedcompanys");
                orgIds.addAll(relatedCompanys);
            }
            if (orgIds.contains(aa.getCompany().getId().toString())) {
                this.asstActs.put(key, aa);
                continue;
            }
            this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "ACCOUNT_NOT_MATCH"));
        }
    }

    private void findBankAccountByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        String key;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("bank.id");
        selector.add("bank.name");
        selector.add("account.id");
        selector.add("bankAccountNumber");
        selector.add("isByCurrency");
        selector.add("currency.id");
        selector.add("company.id");
        selector.add("isClosed");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        HashMap<String, AccountBankInfo> aas = new HashMap<String, AccountBankInfo>();
        for (AccountBankInfo aa : coll) {
            if (aas.containsKey(aa.getNumber())) {
                if (aa.getCompany().getId().toString().equals(company.getId().toString())) {
                    aas.put(aa.getNumber(), aa);
                    continue;
                }
                AccountBankInfo a = (AccountBankInfo)aas.get(aa.getNumber());
                if (a.getCompany().getId().toString().equals(company.getId().toString()) || !company.isIsAssistantOrg() || !aa.getCompany().getId().toString().equals(company.getMainOrg().getId().toString())) continue;
                aas.put(aa.getNumber(), aa);
                continue;
            }
            aas.put(aa.getNumber(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActNumber : asstActNumbers) {
                key = pKey + asstActNumber;
                AccountBankInfo aa = (AccountBankInfo)aas.get(asstActNumber);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActNumber : asstActNumbers) {
            key = pKey + asstActNumber;
            AccountBankInfo aa = (AccountBankInfo)aas.get(asstActNumber);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (aa.isIsClosed()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "ACCOUNT_CLOSED"));
                continue;
            }
            HashSet<String> orgIds = new HashSet<String>();
            orgIds.add(company.getId().toString());
            if (company.isIsAssistantOrg()) {
                orgIds.add(company.getMainOrg().getId().toString());
            }
            if (company.get("relatedcompanys") != null) {
                Set relatedCompanys = (Set)company.get("relatedcompanys");
                orgIds.addAll(relatedCompanys);
            }
            if (orgIds.contains(aa.getCompany().getId().toString())) {
                this.asstActs.put(key, aa);
                continue;
            }
            this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "ACCOUNT_NOT_MATCH"));
        }
    }

    private void findIndustry(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        this.findOther(ctx, asstActType, asstActIds, company, cuId, userId, pKey);
    }

    private void findIndustryByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        this.findOtherByNumbers(ctx, asstActType, asstActNumbers, company, cuId, userId, pKey);
    }

    private void findRegion(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("deletedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        BankCollection coll = BankFactory.getLocalInstance((Context)ctx).getBankCollection(view);
        HashMap<String, BankInfo> aas = new HashMap<String, BankInfo>();
        for (BankInfo aa : coll) {
            aas.put(aa.getId().toString(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActId : asstActIds) {
                String key = pKey + asstActId;
                BankInfo aa = (BankInfo)aas.get(asstActId);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            BankInfo aa = (BankInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (DeletedStatusEnum.DELETED.equals((Object)aa.getDeletedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "INVALID"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findRegionByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("deletedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        BankCollection coll = BankFactory.getLocalInstance((Context)ctx).getBankCollection(view);
        HashMap<String, BankInfo> aas = new HashMap<String, BankInfo>();
        for (BankInfo aa : coll) {
            aas.put(aa.getNumber(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActNumber : asstActNumbers) {
                String key = pKey + asstActNumber;
                BankInfo aa = (BankInfo)aas.get(asstActNumber);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            BankInfo aa = (BankInfo)aas.get(asstActNumber);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (DeletedStatusEnum.DELETED.equals((Object)aa.getDeletedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "INVALID"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findCashFlowItem(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("longNumber");
        selector.add("isLeaf");
        selector.add("isFreeze");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        CashFlowItemCollection coll = CashFlowItemFactory.getLocalInstance((Context)ctx).getCashFlowItemCollection(view);
        HashMap<String, CashFlowItemInfo> aas = new HashMap<String, CashFlowItemInfo>();
        for (CashFlowItemInfo aa : coll) {
            aas.put(aa.getId().toString(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActId : asstActIds) {
                String key = pKey + asstActId;
                CashFlowItemInfo aa = (CashFlowItemInfo)aas.get(asstActId);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            CashFlowItemInfo aa = (CashFlowItemInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (!aa.isIsLeaf()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_LEAF"));
                continue;
            }
            if (aa.isIsFreeze()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "FREEZED"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findCashFlowItemByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("longNumber");
        selector.add("isLeaf");
        selector.add("isFreeze");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        HashMap<String, String> transforms = new HashMap<String, String>();
        if (asstActType.isUseLongNumber()) {
            HashSet asstActLongNumbers = new HashSet();
            for (String asstActNumber : asstActNumbers) {
                String asstActLongNumber = asstActNumber;
                if (asstActLongNumber.indexOf(46) >= 0) {
                    asstActLongNumber = asstActNumber.replace('.', '!');
                }
                asstActLongNumbers.add(asstActLongNumber);
                transforms.put(asstActNumber, asstActLongNumber);
            }
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)asstActLongNumbers, CompareType.INCLUDE));
        } else {
            for (String asstActNumber : asstActNumbers) {
                transforms.put(asstActNumber, asstActNumber);
            }
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        CashFlowItemCollection coll = CashFlowItemFactory.getLocalInstance((Context)ctx).getCashFlowItemCollection(view);
        HashMap<String, CashFlowItemInfo> aas = new HashMap<String, CashFlowItemInfo>();
        for (CashFlowItemInfo aa : coll) {
            if (asstActType.isUseLongNumber()) {
                aas.put(aa.getLongNumber(), aa);
                continue;
            }
            aas.put(aa.getNumber(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActNumber : asstActNumbers) {
                String key = pKey + asstActNumber;
                CashFlowItemInfo aa = (CashFlowItemInfo)aas.get(transforms.get(asstActNumber));
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            CashFlowItemInfo aa = (CashFlowItemInfo)aas.get(transforms.get(asstActNumber));
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (!aa.isIsLeaf()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_LEAF"));
                continue;
            }
            if (aa.isIsFreeze()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "FREEZED"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findCountry(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        this.findOther(ctx, asstActType, asstActIds, company, cuId, userId, pKey);
    }

    private void findCountryByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        this.findOtherByNumbers(ctx, asstActType, asstActNumbers, company, cuId, userId, pKey);
    }

    private void findProvince(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("deletedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        ProvinceCollection coll = ProvinceFactory.getLocalInstance((Context)ctx).getProvinceCollection(view);
        HashMap<String, ProvinceInfo> aas = new HashMap<String, ProvinceInfo>();
        for (ProvinceInfo aa : coll) {
            aas.put(aa.getId().toString(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActId : asstActIds) {
                String key = pKey + asstActId;
                ProvinceInfo aa = (ProvinceInfo)aas.get(asstActId);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            ProvinceInfo aa = (ProvinceInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (DeletedStatusEnum.DELETED.equals((Object)aa.getDeletedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "INVALID"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findProvinceByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("deletedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        ProvinceCollection coll = ProvinceFactory.getLocalInstance((Context)ctx).getProvinceCollection(view);
        HashMap<String, ProvinceInfo> aas = new HashMap<String, ProvinceInfo>();
        for (ProvinceInfo aa : coll) {
            aas.put(aa.getNumber(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActNumber : asstActNumbers) {
                String key = pKey + asstActNumber;
                ProvinceInfo aa = (ProvinceInfo)aas.get(asstActNumber);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            ProvinceInfo aa = (ProvinceInfo)aas.get(asstActNumber);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (DeletedStatusEnum.DELETED.equals((Object)aa.getDeletedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "INVALID"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findCity(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("deletedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        CityCollection coll = CityFactory.getLocalInstance((Context)ctx).getCityCollection(view);
        HashMap<String, CityInfo> aas = new HashMap<String, CityInfo>();
        for (CityInfo aa : coll) {
            aas.put(aa.getId().toString(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActId : asstActIds) {
                String key = pKey + asstActId;
                CityInfo aa = (CityInfo)aas.get(asstActId);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            CityInfo aa = (CityInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (DeletedStatusEnum.DELETED.equals((Object)aa.getDeletedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "INVALID"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findCityByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("deletedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        CityCollection coll = CityFactory.getLocalInstance((Context)ctx).getCityCollection(view);
        HashMap<String, CityInfo> aas = new HashMap<String, CityInfo>();
        for (CityInfo aa : coll) {
            aas.put(aa.getNumber(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActNumber : asstActNumbers) {
                String key = pKey + asstActNumber;
                CityInfo aa = (CityInfo)aas.get(asstActNumber);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            CityInfo aa = (CityInfo)aas.get(asstActNumber);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (DeletedStatusEnum.DELETED.equals((Object)aa.getDeletedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "INVALID"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findAccountCussent(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("isDisabled");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        AccountCussentCollection coll = AccountCussentFactory.getLocalInstance((Context)ctx).getAccountCussentCollection(view);
        HashMap<String, AccountCussentInfo> aas = new HashMap<String, AccountCussentInfo>();
        for (AccountCussentInfo aa : coll) {
            aas.put(aa.getId().toString(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActId : asstActIds) {
                String key = pKey + asstActId;
                AccountCussentInfo aa = (AccountCussentInfo)aas.get(asstActId);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            AccountCussentInfo aa = (AccountCussentInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (aa.isIsDisabled()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "FREEZED"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findAccountCussentByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("isDisabled");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        AccountCussentCollection coll = AccountCussentFactory.getLocalInstance((Context)ctx).getAccountCussentCollection(view);
        HashMap<String, AccountCussentInfo> aas = new HashMap<String, AccountCussentInfo>();
        for (AccountCussentInfo aa : coll) {
            aas.put(aa.getNumber(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActNumber : asstActNumbers) {
                String key = pKey + asstActNumber;
                AccountCussentInfo aa = (AccountCussentInfo)aas.get(asstActNumber);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            AccountCussentInfo aa = (AccountCussentInfo)aas.get(asstActNumber);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (aa.isIsDisabled()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "FREEZED"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findCostObject(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("isForbiden");
        selector.add("company.id");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        CostObjectCollection coll = CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(view);
        HashMap<String, CostObjectInfo> aas = new HashMap<String, CostObjectInfo>();
        for (CostObjectInfo aa : coll) {
            aas.put(aa.getId().toString(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActId : asstActIds) {
                String key = pKey + asstActId;
                CostObjectInfo aa = (CostObjectInfo)aas.get(asstActId);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            CostObjectInfo aa = (CostObjectInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (aa.isIsForbiden()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "FREEZED"));
                continue;
            }
            if (aa.getCompany() == null || !aa.getCompany().getId().equals((Object)company.getId())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_MY_ORG"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findCostObjectByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        String key;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("isForbiden");
        selector.add("company.id");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        if (!this.ignoreFilter) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        }
        CostObjectCollection coll = CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(view);
        HashMap<String, CostObjectInfo> aas = new HashMap<String, CostObjectInfo>();
        for (CostObjectInfo aa : coll) {
            CostObjectInfo co = (CostObjectInfo)aas.get(aa.getNumber());
            if (co == null) {
                aas.put(aa.getNumber(), aa);
                continue;
            }
            if (aa.getCompany() == null || !aa.getCompany().getId().equals((Object)company.getId())) continue;
            aas.put(aa.getNumber(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActNumber : asstActNumbers) {
                key = pKey + asstActNumber;
                CostObjectInfo aa = (CostObjectInfo)aas.get(asstActNumber);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActNumber : asstActNumbers) {
            key = pKey + asstActNumber;
            CostObjectInfo aa = (CostObjectInfo)aas.get(asstActNumber);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (aa.isIsForbiden()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "FREEZED"));
                continue;
            }
            if (aa.getCompany() == null || !aa.getCompany().getId().equals((Object)company.getId())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_MY_ORG"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findAdminOrg(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        block17: {
            String key;
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            view.setSelector(selector);
            selector.add("id");
            selector.add("number");
            selector.add("longNumber");
            selector.add("name");
            selector.add("isLeaf");
            selector.add("isSealUp");
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
            AdminOrgUnitCollection coll = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view);
            HashMap<String, AdminOrgUnitInfo> aas = new HashMap<String, AdminOrgUnitInfo>();
            for (AdminOrgUnitInfo adminOrgUnitInfo : coll) {
                aas.put(adminOrgUnitInfo.getId().toString(), adminOrgUnitInfo);
            }
            if (this.ignoreFilter) {
                for (String string : asstActIds) {
                    String string2 = pKey + string;
                    AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)aas.get(string);
                    if (adminOrgUnitInfo == null) {
                        this.asstActs.put(string2, "[" + string + "] " + this.getResource(ctx, "NOT_FOUND"));
                        continue;
                    }
                    this.asstActs.put(string2, adminOrgUnitInfo);
                }
                return;
            }
            HashSet<String> existAsstActIds = new HashSet<String>();
            for (String string : asstActIds) {
                String string3 = pKey + string;
                AdminOrgUnitInfo aa = (AdminOrgUnitInfo)aas.get(string);
                if (aa == null) {
                    this.asstActs.put(string3, "[" + string + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                if (!aa.isIsLeaf()) {
                    this.asstActs.put(string3, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_LEAF"));
                    continue;
                }
                if (aa.isIsSealUp()) {
                    this.asstActs.put(string3, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "SEALUP"));
                    continue;
                }
                existAsstActIds.add(string);
            }
            if (existAsstActIds.size() <= 0) break block17;
            this.initParam(ctx, company);
            if ("true".equals(this.gl069s.get(company.getId().toString()))) {
                Set<String> set = this.getRelations(ctx, company, OrgType.Admin);
                for (String string : existAsstActIds) {
                    key = pKey + string;
                    AdminOrgUnitInfo aa = (AdminOrgUnitInfo)aas.get(string);
                    if (set.contains(string)) {
                        this.asstActs.put(key, aa);
                        continue;
                    }
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NO_ACCOUNT_ENTRUST"));
                }
            } else if ("true".equals(this.gl043s.get(company.getId().toString()))) {
                Map map = this.getAuthOrgs(ctx, userId, OrgType.Admin);
                for (String string : existAsstActIds) {
                    key = pKey + string;
                    AdminOrgUnitInfo aa = (AdminOrgUnitInfo)aas.get(string);
                    if (!map.containsKey(string)) {
                        this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NO_ORG_PERMISSION"));
                        continue;
                    }
                    this.asstActs.put(key, aa);
                }
            } else {
                for (String string : existAsstActIds) {
                    String string4 = pKey + string;
                    this.asstActs.put(string4, aas.get(string));
                }
            }
        }
    }

    private void findAdminOrgByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        block17: {
            String key;
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            view.setSelector(selector);
            selector.add("id");
            selector.add("number");
            selector.add("longNumber");
            selector.add("name");
            selector.add("isLeaf");
            selector.add("isSealUp");
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
            AdminOrgUnitCollection coll = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view);
            HashMap<String, AdminOrgUnitInfo> aas = new HashMap<String, AdminOrgUnitInfo>();
            for (AdminOrgUnitInfo adminOrgUnitInfo : coll) {
                aas.put(adminOrgUnitInfo.getNumber(), adminOrgUnitInfo);
            }
            if (this.ignoreFilter) {
                for (String string : asstActNumbers) {
                    String string2 = pKey + string;
                    AdminOrgUnitInfo aa = (AdminOrgUnitInfo)aas.get(string);
                    if (aa == null) {
                        this.asstActs.put(string2, "[" + string + "] " + this.getResource(ctx, "NOT_FOUND"));
                        continue;
                    }
                    this.asstActs.put(string2, aa);
                }
                return;
            }
            HashMap<String, String> existAsstActNumbers = new HashMap<String, String>();
            for (String string : asstActNumbers) {
                String key2 = pKey + string;
                AdminOrgUnitInfo aa = (AdminOrgUnitInfo)aas.get(string);
                if (aa == null) {
                    this.asstActs.put(key2, "[" + string + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                if (!aa.isIsLeaf()) {
                    this.asstActs.put(key2, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_LEAF"));
                    continue;
                }
                if (aa.isIsSealUp()) {
                    this.asstActs.put(key2, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "SEALUP"));
                    continue;
                }
                existAsstActNumbers.put(string, aa.getId().toString());
            }
            if (existAsstActNumbers.size() <= 0) break block17;
            this.initParam(ctx, company);
            if ("true".equals(this.gl069s.get(company.getId().toString()))) {
                Set<String> set = this.getRelations(ctx, company, OrgType.Admin);
                for (String asstActNumber : existAsstActNumbers.keySet()) {
                    key = pKey + asstActNumber;
                    AdminOrgUnitInfo aa = (AdminOrgUnitInfo)aas.get(asstActNumber);
                    if (set.contains(existAsstActNumbers.get(asstActNumber))) {
                        this.asstActs.put(key, aa);
                        continue;
                    }
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NO_ACCOUNT_ENTRUST"));
                }
            } else if ("true".equals(this.gl043s.get(company.getId().toString()))) {
                Map map = this.getAuthOrgs(ctx, userId, OrgType.Admin);
                for (String asstActNumber : existAsstActNumbers.keySet()) {
                    key = pKey + asstActNumber;
                    AdminOrgUnitInfo aa = (AdminOrgUnitInfo)aas.get(asstActNumber);
                    if (!map.containsKey(existAsstActNumbers.get(asstActNumber))) {
                        this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NO_ORG_PERMISSION"));
                        continue;
                    }
                    this.asstActs.put(key, aa);
                }
            } else {
                for (String string : existAsstActNumbers.keySet()) {
                    String key2 = pKey + string;
                    this.asstActs.put(key2, aas.get(string));
                }
            }
        }
    }

    private void findOrg(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        block30: {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            view.setSelector(selector);
            selector.add("id");
            selector.add("number");
            selector.add("longNumber");
            selector.add("name");
            selector.add("isBizUnit");
            selector.add("isSealUp");
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
            String asstHGAttribute = asstActType.getAsstHGAttribute();
            ICostCenterOrgUnit iOrgUnit = null;
            OrgType fromOrg = null;
            String permItemName = null;
            if (asstHGAttribute.equals("costOrg")) {
                iOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
                fromOrg = OrgType.CostCenter;
                permItemName = "CostCenter_View";
            } else if (asstHGAttribute.equals("saleOrg")) {
                iOrgUnit = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                fromOrg = OrgType.Sale;
                permItemName = "Sale_View";
            } else if (asstHGAttribute.equals("profitOrg")) {
                iOrgUnit = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
                fromOrg = OrgType.ProfitCenter;
                permItemName = "ProfitCenter_View";
            } else if (asstHGAttribute.equals("purchaseOrg")) {
                iOrgUnit = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                fromOrg = OrgType.Purchase;
                permItemName = "Purchase_View";
            } else if (asstHGAttribute.equals("storeageOrg")) {
                iOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                fromOrg = OrgType.Storage;
                permItemName = "Storage_View";
            } else if (asstHGAttribute.equals("companyOrg")) {
                iOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                fromOrg = OrgType.Company;
                permItemName = "Company_View";
            } else {
                return;
            }
            OrgUnitCollection coll = iOrgUnit.getOrgUnitCollection(view);
            HashMap<String, OrgUnitExtInfo> aas = new HashMap<String, OrgUnitExtInfo>();
            for (OrgUnitExtInfo orgUnitExtInfo : coll) {
                aas.put(orgUnitExtInfo.getId().toString(), orgUnitExtInfo);
            }
            if (this.ignoreFilter) {
                for (String string : asstActIds) {
                    String string2 = pKey + string;
                    OrgUnitExtInfo orgUnitExtInfo = (OrgUnitExtInfo)aas.get(string);
                    if (orgUnitExtInfo == null) {
                        this.asstActs.put(string2, "[" + string + "] " + this.getResource(ctx, "NOT_FOUND"));
                        continue;
                    }
                    this.asstActs.put(string2, orgUnitExtInfo);
                }
                return;
            }
            HashSet<String> existAsstActIds = new HashSet<String>();
            for (String string : asstActIds) {
                String string3 = pKey + string;
                OrgUnitExtInfo aa = (OrgUnitExtInfo)aas.get(string);
                if (aa == null) {
                    this.asstActs.put(string3, "[" + string + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                if (!aa.isIsBizUnit()) {
                    this.asstActs.put(string3, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_BIZ"));
                    continue;
                }
                if (aa.isIsSealUp()) {
                    this.asstActs.put(string3, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "SEALUP"));
                    continue;
                }
                existAsstActIds.add(string);
            }
            if (existAsstActIds.size() <= 0) break block30;
            this.initParam(ctx, company);
            if ("true".equals(this.gl069s.get(company.getId().toString())) && !asstHGAttribute.equals("companyOrg") && !asstHGAttribute.equals("profitOrg")) {
                Set<String> set = this.getRelations(ctx, company, fromOrg);
                for (String string : existAsstActIds) {
                    String key3 = pKey + string;
                    OrgUnitExtInfo aa = (OrgUnitExtInfo)aas.get(string);
                    if (set.contains(string)) {
                        this.asstActs.put(key3, aa);
                        continue;
                    }
                    this.asstActs.put(key3, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NO_ACCOUNT_ENTRUST"));
                }
            } else if ("true".equals(this.gl043s.get(company.getId().toString())) && !asstHGAttribute.equals("companyOrg")) {
                Map map = this.getAuthOrgs(ctx, userId, fromOrg);
                Set<String> set = this.getPermOrgs(ctx, userId, permItemName);
                for (String asstActId : existAsstActIds) {
                    String key4 = pKey + asstActId;
                    OrgUnitExtInfo aa = (OrgUnitExtInfo)aas.get(asstActId);
                    if (!map.containsKey(asstActId)) {
                        this.asstActs.put(key4, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NO_ORG_PERMISSION"));
                        continue;
                    }
                    if (!set.contains(asstActId)) {
                        this.asstActs.put(key4, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NO_DATA_PERMISSION"));
                        continue;
                    }
                    this.asstActs.put(key4, aa);
                }
            } else {
                for (String string : existAsstActIds) {
                    String string4 = pKey + string;
                    this.asstActs.put(string4, aas.get(string));
                }
            }
        }
    }

    private void findOrgByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        block30: {
            String key;
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            view.setSelector(selector);
            selector.add("id");
            selector.add("number");
            selector.add("longNumber");
            selector.add("name");
            selector.add("isBizUnit");
            selector.add("isSealUp");
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
            String asstHGAttribute = asstActType.getAsstHGAttribute();
            ICostCenterOrgUnit iOrgUnit = null;
            OrgType fromOrg = null;
            String permItemName = null;
            if (asstHGAttribute.equals("costOrg")) {
                iOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
                fromOrg = OrgType.CostCenter;
                permItemName = "CostCenter_View";
            } else if (asstHGAttribute.equals("saleOrg")) {
                iOrgUnit = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                fromOrg = OrgType.Sale;
                permItemName = "Sale_View";
            } else if (asstHGAttribute.equals("profitOrg")) {
                iOrgUnit = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
                fromOrg = OrgType.ProfitCenter;
                permItemName = "ProfitCenter_View";
            } else if (asstHGAttribute.equals("purchaseOrg")) {
                iOrgUnit = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                fromOrg = OrgType.Purchase;
                permItemName = "Purchase_View";
            } else if (asstHGAttribute.equals("storeageOrg")) {
                iOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                fromOrg = OrgType.Storage;
                permItemName = "Storage_View";
            } else if (asstHGAttribute.equals("companyOrg")) {
                iOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                fromOrg = OrgType.Company;
                permItemName = "Company_View";
            } else {
                return;
            }
            OrgUnitCollection coll = iOrgUnit.getOrgUnitCollection(view);
            HashMap<String, OrgUnitExtInfo> aas = new HashMap<String, OrgUnitExtInfo>();
            for (OrgUnitExtInfo orgUnitExtInfo : coll) {
                aas.put(orgUnitExtInfo.getNumber(), orgUnitExtInfo);
            }
            if (this.ignoreFilter) {
                for (String string : asstActNumbers) {
                    String string2 = pKey + string;
                    OrgUnitExtInfo aa = (OrgUnitExtInfo)aas.get(string);
                    if (aa == null) {
                        this.asstActs.put(string2, "[" + string + "] " + this.getResource(ctx, "NOT_FOUND"));
                        continue;
                    }
                    this.asstActs.put(string2, aa);
                }
                return;
            }
            HashMap<String, String> existAsstActNumbers = new HashMap<String, String>();
            for (String string : asstActNumbers) {
                key = pKey + string;
                OrgUnitExtInfo aa = (OrgUnitExtInfo)aas.get(string);
                if (aa == null) {
                    this.asstActs.put(key, "[" + string + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                if (!aa.isIsBizUnit()) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_BIZ"));
                    continue;
                }
                if (aa.isIsSealUp()) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "SEALUP"));
                    continue;
                }
                existAsstActNumbers.put(string, aa.getId().toString());
            }
            if (existAsstActNumbers.size() <= 0) break block30;
            this.initParam(ctx, company);
            if ("true".equals(this.gl069s.get(company.getId().toString())) && !asstHGAttribute.equals("companyOrg") && !asstHGAttribute.equals("profitOrg")) {
                Set<String> set = this.getRelations(ctx, company, fromOrg);
                for (Object asstActNumber : existAsstActNumbers.keySet()) {
                    String key3 = pKey + (String)asstActNumber;
                    OrgUnitExtInfo aa = (OrgUnitExtInfo)aas.get(asstActNumber);
                    if (set.contains(existAsstActNumbers.get(asstActNumber))) {
                        this.asstActs.put(key3, aa);
                        continue;
                    }
                    this.asstActs.put(key3, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NO_ACCOUNT_ENTRUST"));
                }
            } else if ("true".equals(this.gl043s.get(company.getId().toString())) && !asstHGAttribute.equals("companyOrg")) {
                Map map = this.getAuthOrgs(ctx, userId, fromOrg);
                Set<String> set = this.getPermOrgs(ctx, userId, permItemName);
                for (String asstActNumber : existAsstActNumbers.keySet()) {
                    String key4 = pKey + asstActNumber;
                    OrgUnitExtInfo aa = (OrgUnitExtInfo)aas.get(asstActNumber);
                    if (!map.containsKey(existAsstActNumbers.get(asstActNumber))) {
                        this.asstActs.put(key4, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NO_ORG_PERMISSION"));
                        continue;
                    }
                    if (!set.contains(existAsstActNumbers.get(asstActNumber))) {
                        this.asstActs.put(key4, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NO_DATA_PERMISSION"));
                        continue;
                    }
                    this.asstActs.put(key4, aa);
                }
            } else {
                for (String string : existAsstActNumbers.keySet()) {
                    key = pKey + string;
                    this.asstActs.put(key, aas.get(string));
                }
            }
        }
    }

    private void findPerson(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("deletedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        PersonCollection coll = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(view);
        HashMap<String, PersonInfo> aas = new HashMap<String, PersonInfo>();
        for (PersonInfo personInfo : coll) {
            aas.put(personInfo.getId().toString(), personInfo);
        }
        if (this.ignoreFilter) {
            for (String string : asstActIds) {
                String key = pKey + string;
                PersonInfo aa = (PersonInfo)aas.get(string);
                if (aa == null) {
                    this.asstActs.put(key, "[" + string + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        HashSet<String> existAsstActIds = new HashSet<String>();
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            PersonInfo aa = (PersonInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (DeletedStatusEnum.DELETED.equals((Object)aa.getDeletedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "INVALID"));
                continue;
            }
            this.asstActs.put(key, aa);
            existAsstActIds.add(aa.getId().toString());
        }
        if (!existAsstActIds.isEmpty()) {
            this.initParam(ctx, company);
            boolean bl = "true".equals(this.gl069s.get(company.getId().toString()));
            boolean gl_043 = "true".equals(this.gl043s.get(company.getId().toString()));
            if (!bl && !gl_043) {
                return;
            }
            Set<String> persons = this.getLegalPerson(ctx, company, userId, existAsstActIds, bl, gl_043);
            for (String asstActId : existAsstActIds) {
                String key = pKey + asstActId;
                PersonInfo aa = (PersonInfo)aas.get(asstActId);
                if (persons.contains(asstActId)) {
                    this.asstActs.put(key, aa);
                    continue;
                }
                if (bl) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_THIS_COMPANY_ASSTACT"));
                    continue;
                }
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NO_ORG_PERMISSION"));
            }
        }
    }

    private void findPersonByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("deletedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        PersonCollection coll = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(view);
        HashMap<String, PersonInfo> aas = new HashMap<String, PersonInfo>();
        for (PersonInfo aa : coll) {
            aas.put(aa.getNumber(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActNumber : asstActNumbers) {
                String key = pKey + asstActNumber;
                PersonInfo aa = (PersonInfo)aas.get(asstActNumber);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        HashSet<String> existAsstActIds = new HashSet<String>();
        HashSet<String> existAsstActNumbers = new HashSet<String>();
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            PersonInfo aa = (PersonInfo)aas.get(asstActNumber);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (DeletedStatusEnum.DELETED.equals((Object)aa.getDeletedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "INVALID"));
                continue;
            }
            this.asstActs.put(key, aa);
            existAsstActIds.add(aa.getId().toString());
            existAsstActNumbers.add(asstActNumber);
        }
        if (!existAsstActIds.isEmpty()) {
            this.initParam(ctx, company);
            boolean gl_069 = "true".equals(this.gl069s.get(company.getId().toString()));
            boolean gl_043 = "true".equals(this.gl043s.get(company.getId().toString()));
            if (!gl_069 && !gl_043) {
                return;
            }
            Set<String> persons = this.getLegalPerson(ctx, company, userId, existAsstActIds, gl_069, gl_043);
            for (String asstActNumber : existAsstActNumbers) {
                String key = pKey + asstActNumber;
                PersonInfo aa = (PersonInfo)aas.get(asstActNumber);
                if (persons.contains(aa.getId().toString())) {
                    this.asstActs.put(key, aa);
                    continue;
                }
                if (gl_069) {
                    this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_THIS_COMPANY_ASSTACT"));
                    continue;
                }
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NO_ORG_PERMISSION"));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void findGeneral(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        void var14_21;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("isLeaf");
        selector.add("isEnabled");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)asstActType.getGlAsstActTypeGrp().getId().toString()));
        GeneralAsstActTypeCollection coll = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeCollection(view);
        HashMap<String, GeneralAsstActTypeInfo> aas = new HashMap<String, GeneralAsstActTypeInfo>();
        for (GeneralAsstActTypeInfo generalAsstActTypeInfo : coll) {
            aas.put(generalAsstActTypeInfo.getId().toString(), generalAsstActTypeInfo);
        }
        if (this.ignoreFilter) {
            for (String string : asstActIds) {
                String key = pKey + string;
                GeneralAsstActTypeInfo aa = (GeneralAsstActTypeInfo)aas.get(string);
                if (aa == null) {
                    this.asstActs.put(key, "[" + string + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        HashSet<String> existAsstActIds = new HashSet<String>();
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            GeneralAsstActTypeInfo aa = (GeneralAsstActTypeInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (!aa.isIsEnabled()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "FREEZED"));
                continue;
            }
            existAsstActIds.add(asstActId);
        }
        if (existAsstActIds.size() <= 0) {
            return;
        }
        if (!asstActType.isIsMultilevel()) {
            for (String asstActId : existAsstActIds) {
                this.asstActs.put(pKey + asstActId, aas.get(asstActId));
            }
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        FilterInfo gFilter = this.getGFilter(ctx, asstActType, company);
        if (gFilter != null && gFilter.getFilterItems().size() > 0) {
            view = new EntityViewInfo();
            selector = new SelectorItemCollection();
            view.setSelector(selector);
            selector.add("id");
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", existAsstActIds, CompareType.INCLUDE));
            filter.mergeFilter(gFilter, "and");
            view.setFilter(filter);
            GeneralAsstActTypeCollection coll2 = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeCollection(view);
            HashSet<String> aas2 = new HashSet<String>();
            for (GeneralAsstActTypeInfo aa : coll2) {
                aas2.add(aa.getId().toString());
            }
            for (String asstActId : existAsstActIds) {
                String key = pKey + asstActId;
                GeneralAsstActTypeInfo aa = (GeneralAsstActTypeInfo)aas.get(asstActId);
                if (aas2.contains(asstActId)) {
                    hashSet.add(asstActId);
                    continue;
                }
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NO_CONDITION"));
            }
        } else {
            HashSet<String> hashSet2 = existAsstActIds;
        }
        if (var14_21.size() <= 0) {
            return;
        }
        String groupID = asstActType.getGlAsstActTypeGrp().getId().toString();
        view = new EntityViewInfo();
        selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)var14_21, CompareType.INCLUDE));
        if (asstActType.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.S2) || asstActType.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.B1)) {
            StringBuffer sql = new StringBuffer();
            sql.append("select A.fparentid \n");
            sql.append("from T_BD_Generalasstacttype A \n");
            sql.append("inner join T_ORG_CtrlUnit D on D.FID='" + cuId + "' \n");
            sql.append("inner join T_ORG_CtrlUnit E on E.FID=A.FControlUnitID ");
            sql.append("and (CHARINDEX(E.FLongNumber||'!',D.FLongNumber)=1 or d.fid=e.fid) \n");
            sql.append("where A.fparentid is not null and FgroupID='" + groupID + "' ");
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
        }
        String defaultSql = this.oqlToSql(gFilter);
        StringBuffer sql = new StringBuffer();
        sql.append(" select cg.fparentid from T_BD_GeneralAsstActType cg ");
        sql.append(" inner JOIN T_ORG_CtrlUnit AS CU ON cg.FControlUnitID = CU.FID ");
        sql.append(" inner join T_ORG_Company AS creatorCompany ON cg.FCreatorCompanyID = creatorCompany.FID ");
        sql.append(" where ");
        sql.append(" cg.fparentid is not null  ");
        if (groupID != null) {
            sql.append(" and cg.fgroupid='").append(groupID).append("'");
        }
        if (defaultSql != null) {
            sql.append(" and ( ").append(defaultSql);
            sql.append(" ) ");
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
        view.setFilter(filter);
        GeneralAsstActTypeCollection coll2 = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeCollection(view);
        HashSet<String> aas2 = new HashSet<String>();
        for (GeneralAsstActTypeInfo aa : coll2) {
            aas2.add(aa.getId().toString());
        }
        for (String asstActId : var14_21) {
            String key = pKey + asstActId;
            GeneralAsstActTypeInfo aa = (GeneralAsstActTypeInfo)aas.get(asstActId);
            if (aas2.contains(asstActId)) {
                this.asstActs.put(key, aa);
                continue;
            }
            this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_LEAF"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void findGeneralByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        void var15_26;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("longNumber");
        selector.add("isLeaf");
        selector.add("isEnabled");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)asstActType.getGlAsstActTypeGrp().getId().toString()));
        HashMap<String, Object> transforms = new HashMap<String, Object>();
        if (asstActType.isUseLongNumber()) {
            HashSet asstActLongNumbers = new HashSet();
            for (String asstActNumber : asstActNumbers) {
                void var15_15;
                String string = asstActNumber;
                if (string.indexOf(46) >= 0) {
                    String string2 = asstActNumber.replace('.', '!');
                }
                asstActLongNumbers.add(var15_15);
                transforms.put(asstActNumber, var15_15);
            }
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)asstActLongNumbers, CompareType.INCLUDE));
        } else {
            for (String asstActNumber : asstActNumbers) {
                transforms.put(asstActNumber, asstActNumber);
            }
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        GeneralAsstActTypeCollection coll = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeCollection(view);
        HashMap<String, GeneralAsstActTypeInfo> aas = new HashMap<String, GeneralAsstActTypeInfo>();
        for (GeneralAsstActTypeInfo generalAsstActTypeInfo : coll) {
            if (asstActType.isUseLongNumber()) {
                aas.put(generalAsstActTypeInfo.getLongNumber(), generalAsstActTypeInfo);
                continue;
            }
            aas.put(generalAsstActTypeInfo.getNumber(), generalAsstActTypeInfo);
        }
        if (this.ignoreFilter) {
            for (String string : asstActNumbers) {
                String key = pKey + string;
                GeneralAsstActTypeInfo aa = (GeneralAsstActTypeInfo)aas.get(transforms.get(string));
                if (aa == null) {
                    this.asstActs.put(key, "[" + string + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        HashMap<String, String> existAsstActNumbers = new HashMap<String, String>();
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            GeneralAsstActTypeInfo aa = (GeneralAsstActTypeInfo)aas.get(transforms.get(asstActNumber));
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (!aa.isIsEnabled()) {
                this.asstActs.put(key, "[" + asstActNumber + "," + aa.getName() + "] " + this.getResource(ctx, "FREEZED"));
                continue;
            }
            existAsstActNumbers.put(asstActNumber, aa.getId().toString());
        }
        if (existAsstActNumbers.size() <= 0) {
            return;
        }
        if (!asstActType.isIsMultilevel()) {
            for (String asstActNumber : existAsstActNumbers.keySet()) {
                this.asstActs.put(pKey + asstActNumber, aas.get(transforms.get(asstActNumber)));
            }
            return;
        }
        HashMap hashMap = new HashMap();
        FilterInfo gFilter = this.getGFilter(ctx, asstActType, company);
        if (gFilter != null && gFilter.getFilterItems().size() > 0) {
            view = new EntityViewInfo();
            selector = new SelectorItemCollection();
            view.setSelector(selector);
            selector.add("id");
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(existAsstActNumbers.values()), CompareType.INCLUDE));
            filter.mergeFilter(gFilter, "and");
            view.setFilter(filter);
            GeneralAsstActTypeCollection coll2 = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeCollection(view);
            HashSet<String> aas2 = new HashSet<String>();
            for (GeneralAsstActTypeInfo aa : coll2) {
                aas2.add(aa.getId().toString());
            }
            for (String asstActNumber : existAsstActNumbers.keySet()) {
                String key = pKey + asstActNumber;
                GeneralAsstActTypeInfo aa = (GeneralAsstActTypeInfo)aas.get(transforms.get(asstActNumber));
                if (aas2.contains(existAsstActNumbers.get(asstActNumber))) {
                    hashMap.put(asstActNumber, existAsstActNumbers.get(asstActNumber));
                    continue;
                }
                this.asstActs.put(key, "[" + asstActNumber + "," + aa.getName() + "] " + this.getResource(ctx, "NO_CONDITION"));
            }
        } else {
            HashMap<String, String> hashMap2 = existAsstActNumbers;
        }
        if (var15_26.size() <= 0) {
            return;
        }
        String groupID = asstActType.getGlAsstActTypeGrp().getId().toString();
        view = new EntityViewInfo();
        selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(var15_26.values()), CompareType.INCLUDE));
        if (asstActType.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.S2) || asstActType.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.B1)) {
            StringBuffer sql = new StringBuffer();
            sql.append("select A.fparentid \n");
            sql.append("from T_BD_Generalasstacttype A \n");
            sql.append("inner join T_ORG_CtrlUnit D on D.FID='" + cuId + "' \n");
            sql.append("inner join T_ORG_CtrlUnit E on E.FID=A.FControlUnitID ");
            sql.append("and (CHARINDEX(E.FLongNumber||'!',D.FLongNumber)=1 or d.fid=e.fid) \n");
            sql.append("where A.fparentid is not null and FgroupID='" + groupID + "' ");
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
        }
        String defaultSql = this.oqlToSql(gFilter);
        StringBuffer sql = new StringBuffer();
        sql.append(" select cg.fparentid from T_BD_GeneralAsstActType cg ");
        sql.append(" inner JOIN T_ORG_CtrlUnit AS CU ON cg.FControlUnitID = CU.FID ");
        sql.append(" inner join T_ORG_Company AS creatorCompany ON cg.FCreatorCompanyID = creatorCompany.FID ");
        sql.append(" where ");
        sql.append(" cg.fparentid is not null  ");
        if (groupID != null) {
            sql.append(" and cg.fgroupid='").append(groupID).append("'");
        }
        if (defaultSql != null) {
            sql.append(" and ( ").append(defaultSql);
            sql.append(" ) ");
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
        view.setFilter(filter);
        GeneralAsstActTypeCollection coll2 = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeCollection(view);
        HashSet<String> aas2 = new HashSet<String>();
        for (GeneralAsstActTypeInfo aa : coll2) {
            aas2.add(aa.getId().toString());
        }
        for (String asstActNumber : var15_26.keySet()) {
            String key = pKey + asstActNumber;
            GeneralAsstActTypeInfo aa = (GeneralAsstActTypeInfo)aas.get(transforms.get(asstActNumber));
            if (aas2.contains(var15_26.get(asstActNumber))) {
                this.asstActs.put(key, aa);
                continue;
            }
            this.asstActs.put(key, "[" + asstActNumber + "," + aa.getName() + "] " + this.getResource(ctx, "NOT_LEAF"));
        }
    }

    private String oqlToSql(FilterInfo defaultFilter) {
        String sql = null;
        if (defaultFilter != null && defaultFilter.getFilterItems().size() > 0) {
            sql = defaultFilter.toSql();
            sql = sql.replaceAll("\\.id", ".fid");
            sql = sql.replaceAll("\\.longNumber", ".flongNumber");
        }
        return sql;
    }

    private void findInnerAccount(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("isUsed");
        selector.add("closed");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        if (!this.ignoreFilter) {
            FilterInfo innerAccountFilter = AsstActFinder.getInnnerAccountFilter(ctx, company);
            filter.mergeFilter(innerAccountFilter, "and");
        }
        InnerAccountCollection coll = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountCollection(view);
        HashMap<String, InnerAccountInfo> aas = new HashMap<String, InnerAccountInfo>();
        for (InnerAccountInfo aa : coll) {
            aas.put(aa.getId().toString(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActId : asstActIds) {
                String key = pKey + asstActId;
                InnerAccountInfo aa = (InnerAccountInfo)aas.get(asstActId);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            InnerAccountInfo aa = (InnerAccountInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (!aa.isIsUsed()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_ENABLE"));
                continue;
            }
            if (aa.isClosed()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "ACCOUNT_CLOSED"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findInnerAccountByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("isUsed");
        selector.add("closed");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        if (!this.ignoreFilter) {
            FilterInfo innerAccountFilter = AsstActFinder.getInnnerAccountFilter(ctx, company);
            filter.mergeFilter(innerAccountFilter, "and");
        }
        InnerAccountCollection coll = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountCollection(view);
        HashMap<String, InnerAccountInfo> aas = new HashMap<String, InnerAccountInfo>();
        for (InnerAccountInfo aa : coll) {
            aas.put(aa.getNumber(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActNumber : asstActNumbers) {
                String key = pKey + asstActNumber;
                InnerAccountInfo aa = (InnerAccountInfo)aas.get(asstActNumber);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            InnerAccountInfo aa = (InnerAccountInfo)aas.get(asstActNumber);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (!aa.isIsUsed()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_ENABLE"));
                continue;
            }
            if (aa.isClosed()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "ACCOUNT_CLOSED"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    public static FilterInfo getInnnerAccountFilter(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        Map resultMap = BankFactory.getLocalInstance((Context)ctx).isClearinghouseCompany(new CompanyOrgUnitInfo[]{company});
        Set clearinghouseSet = (Set)resultMap.get("clearinghouseSet");
        Set noClearinghouseSet = (Set)resultMap.get("noClearinghouseSet");
        if (!clearinghouseSet.isEmpty() && !noClearinghouseSet.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)clearinghouseSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)noClearinghouseSet, CompareType.INCLUDE));
            filter.setMaskString("(#0 or #1)");
        } else if (!clearinghouseSet.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)clearinghouseSet, CompareType.INCLUDE));
        } else if (!noClearinghouseSet.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)noClearinghouseSet, CompareType.INCLUDE));
        }
        return filter;
    }

    private void findFpItem(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        this.findOther(ctx, asstActType, asstActIds, company, cuId, userId, pKey);
    }

    private void findFpItemByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        this.findOtherByNumbers(ctx, asstActType, asstActNumbers, company, cuId, userId, pKey);
    }

    private void findNtType(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("isUsed");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        NTTypeCollection coll = NTTypeFactory.getLocalInstance((Context)ctx).getNTTypeCollection(view);
        HashMap<String, NTTypeInfo> aas = new HashMap<String, NTTypeInfo>();
        for (NTTypeInfo aa : coll) {
            aas.put(aa.getId().toString(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActId : asstActIds) {
                String key = pKey + asstActId;
                NTTypeInfo aa = (NTTypeInfo)aas.get(asstActId);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            NTTypeInfo aa = (NTTypeInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (!aa.isIsUsed()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_ENABLE"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findNtTypeByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("isUsed");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        NTTypeCollection coll = NTTypeFactory.getLocalInstance((Context)ctx).getNTTypeCollection(view);
        HashMap<String, NTTypeInfo> aas = new HashMap<String, NTTypeInfo>();
        for (NTTypeInfo aa : coll) {
            aas.put(aa.getNumber(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActNumber : asstActNumbers) {
                String key = pKey + asstActNumber;
                NTTypeInfo aa = (NTTypeInfo)aas.get(asstActNumber);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            NTTypeInfo aa = (NTTypeInfo)aas.get(asstActNumber);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (!aa.isIsUsed()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_ENABLE"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findFeeType(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("longNumber");
        selector.add("enable");
        selector.add("isLeaf");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        FeeTypeCollection coll = FeeTypeFactory.getLocalInstance((Context)ctx).getFeeTypeCollection(view);
        HashMap<String, FeeTypeInfo> aas = new HashMap<String, FeeTypeInfo>();
        for (FeeTypeInfo aa : coll) {
            aas.put(aa.getId().toString(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActId : asstActIds) {
                String key = pKey + asstActId;
                FeeTypeInfo aa = (FeeTypeInfo)aas.get(asstActId);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            FeeTypeInfo aa = (FeeTypeInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (!aa.isEnable()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_ENABLE"));
                continue;
            }
            if (!aa.isIsLeaf()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_LEAF"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findFeeTypeByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("longNumber");
        selector.add("enable");
        selector.add("isLeaf");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        HashMap<String, String> transforms = new HashMap<String, String>();
        if (asstActType.isUseLongNumber()) {
            HashSet asstActLongNumbers = new HashSet();
            for (String asstActNumber : asstActNumbers) {
                String asstActLongNumber = asstActNumber;
                if (asstActLongNumber.indexOf(46) >= 0) {
                    asstActLongNumber = asstActNumber.replace('.', '!');
                }
                asstActLongNumbers.add(asstActLongNumber);
                transforms.put(asstActNumber, asstActLongNumber);
            }
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)asstActLongNumbers, CompareType.INCLUDE));
        } else {
            for (String asstActNumber : asstActNumbers) {
                transforms.put(asstActNumber, asstActNumber);
            }
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        FeeTypeCollection coll = FeeTypeFactory.getLocalInstance((Context)ctx).getFeeTypeCollection(view);
        HashMap<String, FeeTypeInfo> aas = new HashMap<String, FeeTypeInfo>();
        for (FeeTypeInfo aa : coll) {
            if (asstActType.isUseLongNumber()) {
                aas.put(aa.getLongNumber(), aa);
                continue;
            }
            aas.put(aa.getNumber(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActNumber : asstActNumbers) {
                String key = pKey + asstActNumber;
                FeeTypeInfo aa = (FeeTypeInfo)aas.get(transforms.get(asstActNumber));
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            FeeTypeInfo aa = (FeeTypeInfo)aas.get(transforms.get(asstActNumber));
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (!aa.isEnable()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_ENABLE"));
                continue;
            }
            if (!aa.isIsLeaf()) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "NOT_LEAF"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findCostItem(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        this.findOther(ctx, asstActType, asstActIds, company, cuId, userId, pKey);
    }

    private void findCostItemByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        this.findOtherByNumbers(ctx, asstActType, asstActNumbers, company, cuId, userId, pKey);
    }

    private void findNation(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("deletedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        CountryCollection coll = CountryFactory.getLocalInstance((Context)ctx).getCountryCollection(view);
        HashMap<String, CountryInfo> aas = new HashMap<String, CountryInfo>();
        for (CountryInfo aa : coll) {
            aas.put(aa.getId().toString(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActId : asstActIds) {
                String key = pKey + asstActId;
                CountryInfo aa = (CountryInfo)aas.get(asstActId);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            CountryInfo aa = (CountryInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (DeletedStatusEnum.DELETED.equals((Object)aa.getDeletedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "INVALID"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findNationByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("deletedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        CountryCollection coll = CountryFactory.getLocalInstance((Context)ctx).getCountryCollection(view);
        HashMap<String, CountryInfo> aas = new HashMap<String, CountryInfo>();
        for (CountryInfo aa : coll) {
            aas.put(aa.getNumber(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActNumber : asstActNumbers) {
                String key = pKey + asstActNumber;
                CountryInfo aa = (CountryInfo)aas.get(asstActNumber);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            CountryInfo aa = (CountryInfo)aas.get(asstActNumber);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (DeletedStatusEnum.DELETED.equals((Object)aa.getDeletedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "INVALID"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findArea(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("deletedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        AreaCollection coll = AreaFactory.getLocalInstance((Context)ctx).getAreaCollection(view);
        HashMap<String, AreaInfo> aas = new HashMap<String, AreaInfo>();
        for (AreaInfo aa : coll) {
            aas.put(aa.getId().toString(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActId : asstActIds) {
                String key = pKey + asstActId;
                AreaInfo aa = (AreaInfo)aas.get(asstActId);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            AreaInfo aa = (AreaInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (DeletedStatusEnum.DELETED.equals((Object)aa.getDeletedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "INVALID"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findAreaByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("deletedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        AreaCollection coll = AreaFactory.getLocalInstance((Context)ctx).getAreaCollection(view);
        HashMap<String, AreaInfo> aas = new HashMap<String, AreaInfo>();
        for (AreaInfo aa : coll) {
            aas.put(aa.getNumber(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActNumber : asstActNumbers) {
                String key = pKey + asstActNumber;
                AreaInfo aa = (AreaInfo)aas.get(asstActNumber);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            AreaInfo aa = (AreaInfo)aas.get(asstActNumber);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (DeletedStatusEnum.DELETED.equals((Object)aa.getDeletedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "INVALID"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findVillage(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("deletedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        RegionCollection coll = RegionFactory.getLocalInstance((Context)ctx).getRegionCollection(view);
        HashMap<String, RegionInfo> aas = new HashMap<String, RegionInfo>();
        for (RegionInfo aa : coll) {
            aas.put(aa.getId().toString(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActId : asstActIds) {
                String key = pKey + asstActId;
                RegionInfo aa = (RegionInfo)aas.get(asstActId);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActId : asstActIds) {
            String key = pKey + asstActId;
            RegionInfo aa = (RegionInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (DeletedStatusEnum.DELETED.equals((Object)aa.getDeletedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "INVALID"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findVillageByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("deletedStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        RegionCollection coll = RegionFactory.getLocalInstance((Context)ctx).getRegionCollection(view);
        HashMap<String, RegionInfo> aas = new HashMap<String, RegionInfo>();
        for (RegionInfo aa : coll) {
            aas.put(aa.getNumber(), aa);
        }
        if (this.ignoreFilter) {
            for (String asstActNumber : asstActNumbers) {
                String key = pKey + asstActNumber;
                RegionInfo aa = (RegionInfo)aas.get(asstActNumber);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActNumber : asstActNumbers) {
            String key = pKey + asstActNumber;
            RegionInfo aa = (RegionInfo)aas.get(asstActNumber);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (DeletedStatusEnum.DELETED.equals((Object)aa.getDeletedStatus())) {
                this.asstActs.put(key, this.getAsstActName((DataBaseInfo)aa) + this.getResource(ctx, "INVALID"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findOther(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActIds, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        String key;
        String asstHGAttribute = asstActType.getAsstHGAttribute();
        EntityObjectInfo entityObject = this.getEntityObject(ctx, asstHGAttribute);
        if (entityObject == null) {
            for (String asstActId : asstActIds) {
                this.asstActs.put(pKey + asstActId, "[" + asstActId + "] " + this.getResource(ctx, "NOT_SUPPORT_AAT"));
            }
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        if (asstActType.isIsMultilevel() && asstActType.getGroupTableName() == null) {
            selector.add("longNumber");
            selector.add("isLeaf");
        }
        if ("country".equalsIgnoreCase(asstHGAttribute)) {
            selector.add("whState");
        }
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
        String strFacotry = entityObject.getBusinessImplFactory();
        String strLocal = entityObject.getBusinessImplName();
        String strMethod = "getDataBaseCollection";
        Class[] argTypes = new Class[]{view.getClass()};
        Object[] args = new Object[]{view};
        Object result = null;
        try {
            result = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strLocal, strMethod, argTypes, args);
        }
        catch (Exception e) {
            strMethod = "getDataBaseCollection";
            result = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strLocal, strMethod, argTypes, args, entityObject.getType());
        }
        HashMap<String, DataBaseInfo> aas = new HashMap<String, DataBaseInfo>();
        if (result != null) {
            DataBaseCollection coll = (DataBaseCollection)result;
            for (DataBaseInfo aa : coll) {
                aas.put(aa.getId().toString(), aa);
            }
        }
        if (this.ignoreFilter) {
            for (String asstActId : asstActIds) {
                key = pKey + asstActId;
                DataBaseInfo aa = (DataBaseInfo)aas.get(asstActId);
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActId : asstActIds) {
            key = pKey + asstActId;
            DataBaseInfo aa = (DataBaseInfo)aas.get(asstActId);
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActId + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (asstActType.isIsMultilevel() && asstActType.getGroupTableName() == null && !aa.getBoolean("isLeaf")) {
                this.asstActs.put(key, this.getAsstActName(aa) + this.getResource(ctx, "NOT_LEAF"));
                continue;
            }
            if ("country".equalsIgnoreCase(asstHGAttribute) && !"1".equals(aa.get("whState"))) {
                this.asstActs.put(key, this.getAsstActName(aa) + this.getResource(ctx, "NOT_ENABLE"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    private void findOtherByNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> asstActNumbers, CompanyOrgUnitInfo company, String cuId, String userId, String pKey) throws BOSException, Exception {
        String key;
        String asstHGAttribute = asstActType.getAsstHGAttribute();
        EntityObjectInfo entityObject = this.getEntityObject(ctx, asstHGAttribute);
        if (entityObject == null) {
            for (String asstActNumber : asstActNumbers) {
                this.asstActs.put(pKey + asstActNumber, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_SUPPORT_AAT"));
            }
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        if (asstActType.isIsMultilevel() && asstActType.getGroupTableName() == null) {
            selector.add("longNumber");
            selector.add("isLeaf");
        }
        if ("country".equalsIgnoreCase(asstHGAttribute)) {
            selector.add("whState");
        }
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        HashMap<String, String> transforms = new HashMap<String, String>();
        if (asstActType.isIsMultilevel() && asstActType.getGroupTableName() == null && asstActType.isUseLongNumber()) {
            HashSet asstActLongNumbers = new HashSet();
            for (String asstActNumber : asstActNumbers) {
                String asstActLongNumber = asstActNumber;
                if (asstActLongNumber.indexOf(46) >= 0) {
                    asstActLongNumber = asstActNumber.replace('.', '!');
                }
                asstActLongNumbers.add(asstActLongNumber);
                transforms.put(asstActNumber, asstActLongNumber);
            }
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)asstActLongNumbers, CompareType.INCLUDE));
        } else {
            for (String asstActNumber : asstActNumbers) {
                transforms.put(asstActNumber, asstActNumber);
            }
            filter.getFilterItems().add(new FilterItemInfo("number", asstActNumbers, CompareType.INCLUDE));
        }
        String strFacotry = entityObject.getBusinessImplFactory();
        String strLocal = entityObject.getBusinessImplName();
        String strMethod = "getDataBaseCollection";
        Class[] argTypes = new Class[]{view.getClass()};
        Object[] args = new Object[]{view};
        Object result = null;
        try {
            result = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strLocal, strMethod, argTypes, args);
        }
        catch (Exception e) {
            strMethod = "getDataBaseCollection";
            result = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strLocal, strMethod, argTypes, args, entityObject.getType());
        }
        HashMap<String, DataBaseInfo> aas = new HashMap<String, DataBaseInfo>();
        if (result != null) {
            DataBaseCollection coll = (DataBaseCollection)result;
            for (DataBaseInfo aa : coll) {
                if (asstActType.isIsMultilevel() && asstActType.getGroupTableName() == null && asstActType.isUseLongNumber()) {
                    aas.put(aa.getString("longNumber"), aa);
                    continue;
                }
                aas.put(aa.getNumber(), aa);
            }
        }
        if (this.ignoreFilter) {
            for (String asstActNumber : asstActNumbers) {
                key = pKey + asstActNumber;
                DataBaseInfo aa = (DataBaseInfo)aas.get(transforms.get(asstActNumber));
                if (aa == null) {
                    this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                    continue;
                }
                this.asstActs.put(key, aa);
            }
            return;
        }
        for (String asstActNumber : asstActNumbers) {
            key = pKey + asstActNumber;
            DataBaseInfo aa = (DataBaseInfo)aas.get(transforms.get(asstActNumber));
            if (aa == null) {
                this.asstActs.put(key, "[" + asstActNumber + "] " + this.getResource(ctx, "NOT_FOUND"));
                continue;
            }
            if (asstActType.isIsMultilevel() && asstActType.getGroupTableName() == null && !aa.getBoolean("isLeaf")) {
                this.asstActs.put(key, this.getAsstActName(aa) + this.getResource(ctx, "NOT_LEAF"));
                continue;
            }
            if ("country".equalsIgnoreCase(asstHGAttribute) && !"1".equals(aa.get("whState"))) {
                this.asstActs.put(key, this.getAsstActName(aa) + this.getResource(ctx, "NOT_ENABLE"));
                continue;
            }
            this.asstActs.put(key, aa);
        }
    }

    public Map<String, Object> findUserPropertiesByIds(Context ctx, String userPropertyType, Set<String> userPropertyIds, CompanyOrgUnitInfo company, String cuId, String userId) throws Exception {
        if (userPropertyIds.size() <= this.SPLIT_SIZE) {
            return this.doFindUserPropertiesByIds(ctx, userPropertyType, userPropertyIds, company, cuId, userId);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Set<String>> parts = this.split(userPropertyIds, this.SPLIT_SIZE);
        for (Set<String> part : parts) {
            result.putAll(this.doFindUserPropertiesByIds(ctx, userPropertyType, part, company, cuId, userId));
        }
        return result;
    }

    public Map<String, Object> doFindUserPropertiesByIds(Context ctx, String userPropertyType, Set<String> userPropertyIds, CompanyOrgUnitInfo company, String cuId, String userId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        company = this.getCompany(ctx, company);
        if (cuId == null || cuId.length() == 0) {
            cuId = company.getCU().getId().toString();
        }
        if (userId == null) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        String asstHGAttribute = "supplier".equals(userPropertyType) ? "provider" : userPropertyType;
        String pKey = company.getId().toString() + "_" + asstHGAttribute + "_";
        HashSet<String> newAsstActIds = new HashSet<String>();
        for (String asstActId : userPropertyIds) {
            String key = pKey + asstActId;
            if (this.asstActs.containsKey(key)) {
                result.put(asstActId, this.asstActs.get(key));
                continue;
            }
            newAsstActIds.add(asstActId);
        }
        if (newAsstActIds.size() <= 0) {
            return result;
        }
        if ("material".equalsIgnoreCase(asstHGAttribute)) {
            this.findMaterial(ctx, null, newAsstActIds, company, cuId, userId, pKey);
        } else if ("customer".equalsIgnoreCase(asstHGAttribute)) {
            this.findCustomer(ctx, null, newAsstActIds, company, cuId, userId, pKey);
        } else if ("provider".equalsIgnoreCase(asstHGAttribute)) {
            this.findProvider(ctx, null, newAsstActIds, company, cuId, userId, pKey);
        }
        for (String asstActId : newAsstActIds) {
            result.put(asstActId, this.asstActs.get(pKey + asstActId));
        }
        return result;
    }
}

