/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.app.AssistUtil;
import com.kingdee.eas.basedata.master.auxacct.app.GLDatabaseCashe;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLBaseDataCheckException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IVoucherAssistRecord;
import com.kingdee.eas.fi.gl.VoucherAssistRecordFactory;
import com.kingdee.eas.fi.gl.app.AbstractAutoAssistantHGUpdateFacadeControllerBean;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ma.pca.common.PCABalanceUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoAssistantHGUpdateFacadeControllerBean
extends AbstractAutoAssistantHGUpdateFacadeControllerBean {
    private static final long serialVersionUID = 2442201242008844755L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.AutoAssistantHGUpdateFacadeControllerBean");
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.AutoAssistantHGUpdateResource";

    @Override
    protected void _update(Context ctx) throws BOSException, EASBizException {
        String sqlSelect = "select fid from t_org_company a where a.fisbizunit=1 and exists (select top 1 faccountid from " + GLBalanceUtils.getAssistBalanceTable(1) + " b where b.forgunitid = a.fid)";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sqlSelect);
        if (set == null) {
            return;
        }
        try {
            while (set.next()) {
                this.updateByOrg(ctx, set.getString("fid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new SQLAccessException(e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _check(Context ctx, String id) throws BOSException {
        StringBuffer sql = new StringBuffer();
        try {
            String value = "";
            sql = new StringBuffer();
            sql.append("SELECT top 1 fassistgrpid FROM t_gl_initassistbalance where fassistgrpid=? \r\n");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
            if (rowset != null && rowset.next()) {
                value = value + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"AssistInit", (Locale)ctx.getLocale()) + ";";
            }
            sql = new StringBuffer();
            sql.append("SELECT top 1 fassgrpid FROM t_gl_voucherassistrecord where fassgrpid=? \r\n");
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
            if (rowset != null && rowset.next()) {
                value = value + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"AcctInit", (Locale)ctx.getLocale()) + ";";
                value = value + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"Voucher", (Locale)ctx.getLocale()) + ";";
            }
            sql = new StringBuffer();
            sql.append("SELECT top 1 fassgrpid FROM t_gl_templatevoucherasstrecord where fassgrpid=?  \r\n");
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
            if (rowset != null && rowset.next()) {
                value = value + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"882_AutoAssistantHGUpdateFacadeControllerBean", (Locale)ctx.getLocale());
            }
            sql = new StringBuffer();
            sql.append("SELECT top 1 fassgrpid FROM t_gl_cashflowrecord where fassgrpid=? and fvoucherid is not null \r\n");
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
            if (rowset != null && rowset.next()) {
                value = value + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"cashflowRecord", (Locale)ctx.getLocale()) + ";";
            }
            sql = new StringBuffer();
            sql.append(" select 1 FROM t_bd_assistanthg WHERE fid  in ( \r\n");
            sql.append("SELECT fassistgrpid FROM T_PCA_INITPCASSISTBALANCE where fassistgrpid=? \r\n");
            sql.append(")");
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
            if (rowset != null && rowset.next()) {
                value = value + this.getResource("ProfitCenterAsstInitBalance", ctx);
            }
            sql = new StringBuffer();
            sql.append(" select 1 FROM t_bd_assistanthg WHERE fid  in ( \r\n");
            sql.append("SELECT fassgrpid FROM T_PCA_pcvoucherassistrecord where fassgrpid=? and fentryid is not null \r\n");
            sql.append(")");
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
            if (rowset != null && rowset.next()) {
                value = value + this.getResource("ProfitCenterVoucher", ctx);
            }
            return value;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _modify(Context ctx, String id) throws BOSException, EASBizException {
        GLDatabaseCashe.setValue((Context)ctx, (String)"assistant", (String)id, null);
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String dispalyname = "fDisplayNameGroup_" + loc;
        String longname = "flongNameGroup_" + loc;
        String longnumber = "fnumberGroup_" + loc;
        String sqlSelect = "select a.fid,a.fasstaccountid,a." + dispalyname + ",a." + longname + ",a." + longnumber + ",b.fcount from t_bd_assistanthg a,t_bd_asstaccount b where a.fid=? and fasstaccountid=b.fid ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sqlSelect, (Object[])new Object[]{id});
        if (set == null) {
            return null;
        }
        String sqlUpdate = "update t_bd_assistanthg set  " + dispalyname + "=? , " + longnumber + "=?, " + longname + "=? ,fcount=? where fid=? ";
        LowTimer low = new LowTimer();
        low.reset();
        IVoucherAssistRecord iasst = VoucherAssistRecordFactory.getLocalInstance(ctx);
        try {
            if (set.next()) {
                String accountid = set.getString("fasstaccountid");
                String asstGrpid = set.getString("fid");
                String displayname_old = set.getString(dispalyname);
                String longname_old = set.getString(longname);
                String longnumber_old = set.getString(longnumber);
                int count = set.getInt("fcount");
                AsstActTypeInfo info = (AsstActTypeInfo)iasst.getDefaultAssitInfo(accountid, asstGrpid);
                String displayname_new = info.getString("longName");
                String longname_new = info.getString("assGrp");
                String longnumber_new = info.getString("longnumber");
                logger.debug((Object)("longname_old:" + longname_old));
                logger.debug((Object)("longname_new:" + longname_new));
                if (!(longname_old != null && longname_old.contains("\\u003b") || displayname_old != null && displayname_old.equals(displayname_new) && longname_old != null && longname_old.equals(longname_new) && longnumber_old != null && longnumber_old.equals(longnumber_new))) {
                    DbUtil.execute((Context)ctx, (String)sqlUpdate, (Object[])new Object[]{displayname_new, longnumber_new, longname_new, new Integer(count), asstGrpid});
                    return longnumber_new != null ? longnumber_new.replaceAll("_!", " ") : "";
                }
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        return null;
    }

    @Override
    protected boolean _delete(Context ctx, String id) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String biz = this._check(ctx, id);
        if (biz != null && biz.length() > 0) {
            throw new GLBaseDataCheckException(GLBaseDataCheckException.HAS_BIZREF_INFO, new String[]{biz.substring(0, biz.length() - 1)});
        }
        this.doDelete(ctx, 1, null, id);
        this.doDelete(ctx, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", id);
        this.doDelete(ctx, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", id);
        this.doDelete(ctx, 5, null, id);
        this.doDelete(ctx, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", id);
        this.doDelete(ctx, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", id);
        this.doDeletePca(ctx, 1, null, id);
        this.doDeletePca(ctx, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", id);
        this.doDeletePca(ctx, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", id);
        this.doDeletePca(ctx, 5, null, id);
        this.doDeletePca(ctx, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", id);
        this.doDeletePca(ctx, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", id);
        sql = new StringBuffer(" delete FROM t_bd_assistanthg WHERE fid=? \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        return true;
    }

    private void doDeletePca(Context ctx, int baltype, String currencyId, String id) throws BOSException {
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" delete FROM " + PCABalanceUtils.getAssistBalanceTable((int)baltype, (String)currencyId) + " where fassistgrpid=? \r\n");
        if (isForCurrency) {
            sql.append(" and fbeginbalancefor=0 and fyeardebitfor=0 and fyearcreditfor=0 and fdebitfor=0 and fcreditfor=0 and fendbalancefor=0 ");
            sql.append(" and fyearpnlfor=0 and fmonthpnlfor=0 ");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append(" and fbeginbalancelocal=0 and fyeardebitlocal=0 and fyearcreditlocal=0 and fdebitlocal=0 and fcreditlocal=0 and fendbalancelocal=0 ");
            sql.append(" and fyearpnllocal=0 and fmonthpnllocal=0 ");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" and fbeginbalancerpt=0 and fyeardebitrpt=0 and fyearcreditrpt=0 and fdebitrpt=0 and fcreditrpt=0 and fendbalancerpt=0");
            sql.append(" and fyearpnlrpt=0 and fmonthpnlrpt=0");
        }
        sql.append(" and fbeginqty=0 and fyeardebitqty=0 and fyearcreditqty=0 and fdebitqty=0 and fcreditqty=0 and fendqty=0");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
    }

    private void doDelete(Context ctx, int baltype, String currencyId, String id) throws BOSException {
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" delete FROM " + GLBalanceUtils.getAssistBalanceTable(baltype, currencyId) + " where fassistgrpid=? \r\n");
        if (isForCurrency) {
            sql.append(" and fbeginbalancefor=0 and fyeardebitfor=0 and fyearcreditfor=0 and fdebitfor=0 and fcreditfor=0 and fendbalancefor=0 ");
            sql.append(" and fyearpnlfor=0 and fmonthpnlfor=0 ");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append(" and fbeginbalancelocal=0 and fyeardebitlocal=0 and fyearcreditlocal=0 and fdebitlocal=0 and fcreditlocal=0 and fendbalancelocal=0 ");
            sql.append(" and fyearpnllocal=0 and fmonthpnllocal=0 ");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" and fbeginbalancerpt=0 and fyeardebitrpt=0 and fyearcreditrpt=0 and fdebitrpt=0 and fcreditrpt=0 and fendbalancerpt=0");
            sql.append(" and fyearpnlrpt=0 and fmonthpnlrpt=0");
        }
        sql.append(" and fbeginqty=0 and fyeardebitqty=0 and fyearcreditqty=0 and fdebitqty=0 and fcreditqty=0 and fendqty=0");
        sql.append(" and isNull(fyearpnlqty,0)=0 and isNull(fmonthpnlqty,0)=0");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
    }

    @Override
    protected List _getData(Context ctx, RptParams params) throws BOSException {
        String like;
        boolean isShowRepeatedHG = false;
        Object showRepeatedHG = params.getObjectElement("pkShowRepeatedHG.value");
        if (showRepeatedHG != null && Boolean.TRUE.equals(showRepeatedHG)) {
            isShowRepeatedHG = true;
        }
        boolean isShowReference = false;
        Object showReference = params.getObjectElement("pkShowReference.value");
        if (showReference != null && Boolean.TRUE.equals(showReference)) {
            isShowReference = true;
        }
        boolean isShowNoReference = false;
        Object showNoReference = params.getObjectElement("pkShowNoReference.value");
        if (showNoReference != null && Boolean.TRUE.equals(showNoReference)) {
            isShowNoReference = true;
        }
        int top = 0;
        Object max = params.getObjectElement("spMaxRecords.value");
        if (max != null && max instanceof Integer) {
            top = (Integer)max;
        }
        AsstAccountInfo jebAcct = (AsstAccountInfo)params.getObjectElement("jebAcct.value");
        List tlist = (List)params.getObject("tableData");
        String asstAccount = jebAcct.getId().toString();
        String fname = "fname_" + ctx.getLocale().getLanguage();
        String flongname = "fnumbergroup_" + ctx.getLocale().getLanguage();
        StringBuffer selectSQL = new StringBuffer();
        StringBuffer fromSQL = new StringBuffer();
        StringBuffer whereSQL = new StringBuffer();
        StringBuffer orderSQL = new StringBuffer();
        selectSQL.append("select" + (top > 0 ? " top " + top : "") + " a.fid,b.").append(fname).append(" asstname,");
        selectSQL.append("a.").append(flongname).append(" longname ,b.fid asstAccountId \n");
        fromSQL.append(" from t_bd_assistanthg a \n");
        fromSQL.append(" inner join t_bd_asstaccount b on a.fasstaccountid=b.fid and a.fasstaccountid='" + asstAccount + "' ");
        for (int i = 0; i < tlist.size(); ++i) {
            String tag = "T_" + i;
            AsstactTypeEntity at = (AsstactTypeEntity)tlist.get(i);
            selectSQL.append(",'").append(at.getName()).append("' baseDataType").append(i);
            selectSQL.append(",").append(tag).append(".fnumber baseDataNumber").append(i);
            selectSQL.append(",").append(tag).append(".").append(fname).append(" baseDataName").append(i);
            fromSQL.append(" left outer  join ").append(at.getTableName()).append(" ").append(tag).append(" on ").append(tag).append(".fid=a." + at.getHgField());
            if (at.getFrom() != null) {
                if (whereSQL.length() == 0) {
                    whereSQL.append(" where ");
                } else {
                    whereSQL.append(" and ");
                }
                if (((DataBaseInfo)at.getFrom()).get("longnumber") != null) {
                    whereSQL.append(tag).append(".flongnumber >= '").append(((DataBaseInfo)at.getFrom()).get("longnumber")).append("' ");
                } else {
                    whereSQL.append(tag).append(".fnumber >= '").append(((DataBaseInfo)at.getFrom()).getNumber()).append("' ");
                }
            }
            if (at.getTo() != null) {
                if (whereSQL.length() == 0) {
                    whereSQL.append(" where ");
                } else {
                    whereSQL.append(" and ");
                }
                if (((DataBaseInfo)at.getTo()).get("longnumber") != null) {
                    whereSQL.append(tag).append(".flongnumber <= '").append(((DataBaseInfo)at.getTo()).get("longnumber")).append("' ");
                } else {
                    whereSQL.append(tag).append(".fnumber <= '").append(((DataBaseInfo)at.getTo()).getNumber()).append("' ");
                }
            }
            orderSQL.append(",").append(tag).append(".fnumber");
        }
        if (isShowRepeatedHG) {
            fromSQL.append(" inner join ( select fasstaccountid ");
            StringBuffer onSQL = new StringBuffer();
            StringBuffer sSQL = new StringBuffer();
            StringBuffer fSQL = new StringBuffer();
            StringBuffer wSQL = new StringBuffer();
            String[] gSQL = new StringBuffer();
            sSQL.append(" select hg.fasstaccountid ");
            fSQL.append(" from t_bd_assistanthg hg ");
            for (int i = 0; i < tlist.size(); ++i) {
                String tag = "B_" + i;
                AsstactTypeEntity at = (AsstactTypeEntity)tlist.get(i);
                fromSQL.append(",").append(at.getHgField());
                sSQL.append(",hg.").append(at.getHgField());
                gSQL.append(",hg.").append(at.getHgField());
                onSQL.append(" and a.").append(at.getHgField()).append(" = t.").append(at.getHgField());
                if (at.getFrom() == null && at.getTo() == null) continue;
                fSQL.append(" left outer join ").append(at.getTableName()).append(" ").append(tag).append(" on ").append(tag).append(".fid=hg." + at.getHgField());
                if (at.getFrom() != null) {
                    if (wSQL.length() == 0) {
                        wSQL.append(" where ");
                    } else {
                        wSQL.append(" and ");
                    }
                    if (((DataBaseInfo)at.getFrom()).get("longnumber") != null) {
                        wSQL.append(tag).append(".flongnumber >= '").append(((DataBaseInfo)at.getFrom()).get("longnumber")).append("' ");
                    } else {
                        wSQL.append(tag).append(".fnumber >= '").append(((DataBaseInfo)at.getFrom()).getNumber()).append("' ");
                    }
                }
                if (at.getTo() == null) continue;
                if (wSQL.length() == 0) {
                    wSQL.append(" where ");
                } else {
                    wSQL.append(" and ");
                }
                if (((DataBaseInfo)at.getTo()).get("longnumber") != null) {
                    wSQL.append(tag).append(".flongnumber <= '").append(((DataBaseInfo)at.getTo()).get("longnumber")).append("' ");
                    continue;
                }
                wSQL.append(tag).append(".fnumber <= '").append(((DataBaseInfo)at.getTo()).getNumber()).append("' ");
            }
            sSQL.append(", count(hg.fid) idCount  ");
            fSQL.append(wSQL).append(" group by hg.fasstaccountid ").append((StringBuffer)gSQL);
            fromSQL.append(" from (").append(sSQL).append(fSQL).append(" ) ss where idCount > 1 ");
            fromSQL.append(" ) t on a.fasstaccountid = t.fasstaccountid ");
            fromSQL.append(onSQL);
        }
        if (isShowReference && !isShowNoReference) {
            if (whereSQL.length() == 0) {
                whereSQL.append(" where ");
            } else {
                whereSQL.append(" and ");
            }
            whereSQL.append(" ( exists (select 1 from t_gl_voucherassistrecord r where r.fassgrpid = a.fid) ");
            whereSQL.append(" or exists (select 1 from t_gl_templatevoucherasstrecord tr where tr.fassgrpid = a.fid) ");
            whereSQL.append(" or exists (select 1 from T_GL_initAssistBalance ib where ib.FAssistGrpID = a.fid) ");
            whereSQL.append(" or exists (select 1 from T_GL_cashflowRecord c where c.FASSGRPID = a.fid) ");
            whereSQL.append(" or exists (select 1 from " + GLBalanceUtils.getAssistBalanceTable(1) + " ab where ab.FAssistGrpID = a.fid) ");
            whereSQL.append(" or exists (select 1 from T_PCA_pcvoucherassistrecord pr where pr.fassgrpid = a.fid) ");
            whereSQL.append(" or exists (select 1 from T_PCA_INITPCASSISTBALANCE pib where pib.FAssistGrpID = a.fid) )");
        } else if (!isShowReference && isShowNoReference) {
            if (whereSQL.length() == 0) {
                whereSQL.append(" where ");
            } else {
                whereSQL.append(" and ");
            }
            whereSQL.append(" not exists (select 1 from t_gl_voucherassistrecord r where r.fassgrpid = a.fid) ");
            whereSQL.append(" and not exists (select 1 from t_gl_templatevoucherasstrecord tr where tr.fassgrpid = a.fid) ");
            whereSQL.append(" and not exists (select 1 from T_GL_initAssistBalance ib where ib.FAssistGrpID = a.fid) ");
            whereSQL.append(" and not exists (select 1 from T_GL_cashflowRecord c where c.FASSGRPID = a.fid) ");
            whereSQL.append(" and not exists (select 1 from " + GLBalanceUtils.getAssistBalanceTable(1) + " ab where ab.FAssistGrpID = a.fid) ");
            whereSQL.append(" and not exists (select 1 from T_PCA_pcvoucherassistrecord pr where pr.fassgrpid = a.fid) ");
            whereSQL.append(" and not exists (select 1 from T_PCA_INITPCASSISTBALANCE pib where pib.FAssistGrpID = a.fid) ");
        }
        Object likeObj = params.getObjectElement("txtLike.value");
        if (likeObj != null && likeObj.toString() != null && (like = likeObj.toString().trim()).length() > 0) {
            String[] strs = like.contains(";") ? like.split(";") : like.split(" ");
            ArrayList<String> list = new ArrayList<String>();
            for (String str : strs) {
                if (str.trim().length() <= 0) continue;
                list.add(str.trim());
            }
            if (list.size() > 0) {
                if (whereSQL.length() == 0) {
                    whereSQL.append(" where ");
                } else {
                    whereSQL.append(" and ");
                }
                for (int i = 0; i < list.size() && i < 8; ++i) {
                    if (i > 0) {
                        whereSQL.append(" and ");
                    }
                    whereSQL.append(" a." + flongname + " like '%" + (String)list.get(i) + "%' ");
                }
            }
        }
        boolean isGroupNameLoss = false;
        Object groupNameLoss = params.getObjectElement("pkGroupNameLoss.value");
        if (groupNameLoss != null && Boolean.TRUE.equals(groupNameLoss)) {
            isGroupNameLoss = true;
        }
        boolean isItemNameError = false;
        Object itemNameError = params.getObjectElement("pkItemNameError.value");
        if (itemNameError != null && Boolean.TRUE.equals(itemNameError)) {
            isItemNameError = true;
        }
        String longNameGroup = "FLongNameGroup_" + ctx.getLocale().getLanguage();
        String displayNameGroup = "FDisplayNameGroup_" + ctx.getLocale().getLanguage();
        String numberGroup = "FNumberGroup_" + ctx.getLocale().getLanguage();
        if (isGroupNameLoss) {
            if (whereSQL.length() == 0) {
                whereSQL.append(" where ");
            } else {
                whereSQL.append(" and ");
            }
            whereSQL.append(" ( ");
            whereSQL.append(" length(replace(isnull(" + longNameGroup + ", ''), ';', ''))+" + tlist.size() + " > length(isnull(" + longNameGroup + ", '')) ");
            whereSQL.append(" or length(replace(isnull(" + displayNameGroup + ", ''), ';', ''))+" + tlist.size() + " > length(isnull(" + displayNameGroup + ", '')) ");
            whereSQL.append(" or length(replace(isnull(" + numberGroup + ", ''), ';', ''))+" + tlist.size() + " > length(isnull(" + numberGroup + ", '')) ");
            whereSQL.append(" ) ");
        } else if (isItemNameError) {
            if (whereSQL.length() == 0) {
                whereSQL.append(" where ");
            } else {
                whereSQL.append(" and ");
            }
            whereSQL.append(" ( ");
            whereSQL.append(" length(replace(isnull(" + longNameGroup + ", ''), ';', ''))+" + tlist.size() + " < length(isnull(" + longNameGroup + ", '')) ");
            whereSQL.append(" or length(replace(isnull(" + displayNameGroup + ", ''), ';', ''))+" + tlist.size() + " < length(isnull(" + displayNameGroup + ", '')) ");
            whereSQL.append(" or length(replace(isnull(" + numberGroup + ", ''), ';', ''))+" + tlist.size() + " < length(isnull(" + numberGroup + ", '')) ");
            whereSQL.append(" ) ");
        }
        String sql = selectSQL.append(fromSQL).append(whereSQL).toString();
        sql = sql + "  order by b.fnumber" + orderSQL.toString() + ",a.fid";
        ArrayList list = new ArrayList();
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowset != null && rowset.next()) {
                HashMap<String, String> value = new HashMap<String, String>();
                value.put("id", rowset.getString("fid"));
                value.put("asstName", rowset.getString("asstname"));
                value.put("displayname", rowset.getString("longname") != null ? rowset.getString("longname").replaceAll("_!", " ") : "");
                value.put("asstAccountId", rowset.getString("asstAccountId"));
                String baseData = "";
                for (int i = 0; i < tlist.size(); ++i) {
                    baseData = baseData + rowset.getString("baseDataType" + i) + ":" + rowset.getString("baseDataNumber" + i) + " " + rowset.getString("baseDataName" + i) + ";";
                }
                value.put("baseData", baseData);
                list.add(value);
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        return list;
    }

    @Override
    protected String _unite(Context ctx, String[] ids, IObjectValue asstactType, String asstId, String projectId) throws BOSException, EASBizException {
        if (ids.length < 2) {
            return null;
        }
        String grpid = null;
        String idin = null;
        ArrayList<String> removes = new ArrayList<String>(ids.length);
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select t.FMappingFieldName \n");
            sql.append("from t_bd_asstactgroupdetail d \n");
            sql.append("join t_bd_asstacttype t on t.FID = d.fasstacttypeid \n");
            sql.append("where d.FAsstAccountID = ? \n");
            sql.append("order by d.FSeq \n");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{asstId});
            String field = null;
            while (rowSet != null && rowSet.next()) {
                if (field == null) {
                    field = rowSet.getString("fMappingFieldName");
                    continue;
                }
                field = field + "," + rowSet.getString("fMappingFieldName");
            }
            if (field == null) {
                return null;
            }
            sql.setLength(0);
            sql.append("'" + ids[0] + "'");
            for (int i = 1; i < ids.length; ++i) {
                sql.append(",'" + ids[i] + "'");
            }
            idin = sql.toString();
            sql.setLength(0);
            sql.append("select distinct " + field + "  from t_bd_assistanthg a where fasstaccountid=? and a.fid in (" + idin + ") ");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{asstId});
            int count = 0;
            while (rowSet != null && rowSet.next()) {
                ++count;
            }
            if (count != 1) {
                return null;
            }
            sql.setLength(0);
            sql.append("select FID from t_bd_assistanthg where fasstaccountid=? and fid in (" + idin + ") order by FCreateTime");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{asstId});
            sql.setLength(0);
            count = 0;
            while (rowSet != null && rowSet.next()) {
                String id = rowSet.getString("FID");
                if (count == 0) {
                    grpid = id;
                } else {
                    if (count > 1) {
                        sql.append(",");
                    }
                    sql.append("'").append(id).append("'");
                    removes.add(id);
                }
                ++count;
            }
            if (count < 2) {
                return null;
            }
            idin = sql.toString();
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        this.unitVoucherAssistRecord(ctx, grpid, idin);
        this.unitInitAssistBalance(ctx, true, grpid, idin);
        this.unitAssistBalance(ctx, true, grpid, idin);
        this.pcaUnitInitAssistBalance(ctx, true, grpid, idin);
        this.pcaUnitAssistBalance(ctx, true, grpid, idin);
        this.unitCashflowAssistRecord(ctx, grpid, idin);
        for (String id : removes) {
            this._delete(ctx, id);
        }
        return grpid;
    }

    private void unitVoucherAssistRecord(Context ctx, String grpid, String idin) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_gl_voucher set flastupdateuserid = ?, flastupdatetime = ? \n");
        sql.append("where FID in ( \n");
        sql.append("    select FBillID from t_gl_voucherassistrecord where fassgrpid in (" + idin + ") \n");
        sql.append(") \n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), GlUtils.getTime()});
        String updateSql = "update t_gl_voucherassistrecord set fassgrpid=? where fassgrpid in (" + idin + ")";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{grpid});
        sql.setLength(0);
        sql.append("update T_pca_pcvoucher set flastupdateuserid = ?, flastupdatetime = ? \n");
        sql.append("where FID in ( \n");
        sql.append("    select FBillID from T_pca_pcvoucherassistrecord where fassgrpid in (" + idin + ") \n");
        sql.append(") \n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), GlUtils.getTime()});
        updateSql = updateSql.replace("t_gl_voucherassistrecord", "T_pca_pcvoucherassistrecord");
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{grpid});
        updateSql = "update t_gl_acctcussent set fassgrpid=? where fassgrpid in (" + idin + ")";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{grpid});
        updateSql = "update t_gl_acctverify set fassgrpid=? where fassgrpid in (" + idin + ")";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{grpid});
        updateSql = "update t_gl_templatevoucherasstrecord set FAssGrpID=? where fassgrpid in (" + idin + ")";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{grpid});
        updateSql = updateSql.replace("t_gl_templatevoucherasstrecord", "t_pca_templatepcvoucherasst");
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{grpid});
        updateSql = "update t_gl_acctcussenthistory set fassgrpid=? where fassgrpid in (" + idin + ")";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{grpid});
    }

    private void unitCashflowAssistRecord(Context ctx, String grpid, String idin) throws BOSException {
        String updateSql = "update t_gl_cashflowrecord set fassgrpid=? where fassgrpid in (" + idin + ")";
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{grpid});
        updateSql = updateSql.replace("t_gl_cashflowrecord", "T_pca_pcCashflowRecord");
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{grpid});
    }

    protected void unitInitAssistBalance(Context ctx, boolean checkExist, String grpid, String idin) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String tmpId = BOSUuid.create((String)"ABCD1234").toString();
        if (checkExist) {
            sql.append("select top 1 1 from T_GL_InitAssistBalance \n");
            sql.append("where FAssistGrpID in (" + idin + ") \n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (!rs.next()) {
                    return;
                }
            }
            catch (SQLException e) {
                throw new BOSException();
            }
        }
        idin = "'" + grpid + "'," + idin;
        sql.setLength(0);
        sql.append("insert into T_GL_InitAssistBalance ( \n");
        sql.append("  FOrgUnitID, \n");
        sql.append("  FAccountID, \n");
        sql.append("  FCurrencyID, \n");
        sql.append("  FAssistGrpID, \n");
        sql.append("  FMeasureUnitID, \n");
        sql.append("  FBeginBalanceFor, \n");
        sql.append("  FDebitFor, \n");
        sql.append("  FCreditFor, \n");
        sql.append("  FYearDebitFor, \n");
        sql.append("  FYearCreditFor, \n");
        sql.append("  FMonthPnlFor, \n");
        sql.append("  FYearPnlFor, \n");
        sql.append("  FEndBalanceFor, \n");
        sql.append("  FBeginBalanceLocal, \n");
        sql.append("  FDebitLocal, \n");
        sql.append("  FCreditLocal, \n");
        sql.append("  FYearDebitLocal, \n");
        sql.append("  FYearCreditLocal, \n");
        sql.append("  FMonthPnlLocal, \n");
        sql.append("  FYearPnlLocal, \n");
        sql.append("  FEndBalanceLocal, \n");
        sql.append("  FBeginBalanceRpt, \n");
        sql.append("  FDebitRpt, \n");
        sql.append("  FCreditRpt, \n");
        sql.append("  FYearDebitRpt, \n");
        sql.append("  FYearCreditRpt, \n");
        sql.append("  FMonthPnlRpt, \n");
        sql.append("  FYearPnlRpt, \n");
        sql.append("  FEndBalanceRpt, \n");
        sql.append("  FBeginQty, \n");
        sql.append("  FDebitQty, \n");
        sql.append("  FCreditQty, \n");
        sql.append("  FYearDebitQty, \n");
        sql.append("  FYearCreditQty, \n");
        sql.append("  FMonthPnlQty, \n");
        sql.append("  FYearPnlQty, \n");
        sql.append("  FEndQty, \n");
        sql.append("  FStandardBeginQty, \n");
        sql.append("  FStandardDebitQty, \n");
        sql.append("  FStandardCreditQty, \n");
        sql.append("  FStandardYearDebitQty, \n");
        sql.append("  FStandardYearCreditQty, \n");
        sql.append("  FStandardMonthPnlQty, \n");
        sql.append("  FStandardYearPnlQty, \n");
        sql.append("  FStandardEndQty, \n");
        sql.append("  FSeq \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  FOrgUnitID, \n");
        sql.append("  FAccountID, \n");
        sql.append("  FCurrencyID, \n");
        sql.append("  '" + tmpId + "' FAssistGrpID, \n");
        sql.append("  max(FMeasureUnitID), \n");
        sql.append("  sum(FBeginBalanceFor), \n");
        sql.append("  sum(FDebitFor), \n");
        sql.append("  sum(FCreditFor), \n");
        sql.append("  sum(FYearDebitFor), \n");
        sql.append("  sum(FYearCreditFor), \n");
        sql.append("  sum(FMonthPnlFor), \n");
        sql.append("  sum(FYearPnlFor), \n");
        sql.append("  sum(FEndBalanceFor), \n");
        sql.append("  sum(FBeginBalanceLocal), \n");
        sql.append("  sum(FDebitLocal), \n");
        sql.append("  sum(FCreditLocal), \n");
        sql.append("  sum(FYearDebitLocal), \n");
        sql.append("  sum(FYearCreditLocal), \n");
        sql.append("  sum(FMonthPnlLocal), \n");
        sql.append("  sum(FYearPnlLocal), \n");
        sql.append("  sum(FEndBalanceLocal), \n");
        sql.append("  sum(FBeginBalanceRpt), \n");
        sql.append("  sum(FDebitRpt), \n");
        sql.append("  sum(FCreditRpt), \n");
        sql.append("  sum(FYearDebitRpt), \n");
        sql.append("  sum(FYearCreditRpt), \n");
        sql.append("  sum(FMonthPnlRpt), \n");
        sql.append("  sum(FYearPnlRpt), \n");
        sql.append("  sum(FEndBalanceRpt), \n");
        sql.append("  sum(FBeginQty), \n");
        sql.append("  sum(FDebitQty), \n");
        sql.append("  sum(FCreditQty), \n");
        sql.append("  sum(FYearDebitQty), \n");
        sql.append("  sum(FYearCreditQty), \n");
        sql.append("  sum(FMonthPnlQty), \n");
        sql.append("  sum(FYearPnlQty), \n");
        sql.append("  sum(FEndQty), \n");
        sql.append("  sum(FStandardBeginQty), \n");
        sql.append("  sum(FStandardDebitQty), \n");
        sql.append("  sum(FStandardCreditQty), \n");
        sql.append("  sum(FStandardYearDebitQty), \n");
        sql.append("  sum(FStandardYearCreditQty), \n");
        sql.append("  sum(FStandardMonthPnlQty), \n");
        sql.append("  sum(FStandardYearPnlQty), \n");
        sql.append("  sum(FStandardEndQty), \n");
        sql.append("  min(Fseq) \n");
        sql.append("from T_GL_InitAssistBalance where FAssistGrpID in (" + idin + ") \n");
        sql.append("group by FOrgUnitID, FAccountID, FCurrencyID \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("delete from T_GL_InitAssistBalance \n");
        sql.append("where FAssistGrpID in (" + idin + ") \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update T_GL_InitAssistBalance \n");
        sql.append("set FAssistGrpID = ? \n");
        sql.append("where FAssistGrpID = ? \n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{grpid, tmpId});
    }

    protected void pcaUnitInitAssistBalance(Context ctx, boolean checkExist, String grpid, String idin) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String tmpId = BOSUuid.create((String)"ABCD1234").toString();
        if (checkExist) {
            sql.append("select top 1 1 from T_PCA_InitPcAssistBalance \n");
            sql.append("where FAssistGrpID in (" + idin + ") \n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (!rs.next()) {
                    return;
                }
            }
            catch (SQLException e) {
                throw new BOSException();
            }
        }
        idin = "'" + grpid + "'," + idin;
        sql.setLength(0);
        sql.append("insert into T_PCA_InitPcAssistBalance ( \n");
        sql.append("  FProfitCenterID, \n");
        sql.append("  FOrgUnitID, \n");
        sql.append("  FAccountID, \n");
        sql.append("  FCurrencyID, \n");
        sql.append("  FAssistGrpID, \n");
        sql.append("  FMeasureUnitID, \n");
        sql.append("  FBeginBalanceFor, \n");
        sql.append("  FDebitFor, \n");
        sql.append("  FCreditFor, \n");
        sql.append("  FYearDebitFor, \n");
        sql.append("  FYearCreditFor, \n");
        sql.append("  FMonthPnlFor, \n");
        sql.append("  FYearPnlFor, \n");
        sql.append("  FEndBalanceFor, \n");
        sql.append("  FBeginBalanceLocal, \n");
        sql.append("  FDebitLocal, \n");
        sql.append("  FCreditLocal, \n");
        sql.append("  FYearDebitLocal, \n");
        sql.append("  FYearCreditLocal, \n");
        sql.append("  FMonthPnlLocal, \n");
        sql.append("  FYearPnlLocal, \n");
        sql.append("  FEndBalanceLocal, \n");
        sql.append("  FBeginBalanceRpt, \n");
        sql.append("  FDebitRpt, \n");
        sql.append("  FCreditRpt, \n");
        sql.append("  FYearDebitRpt, \n");
        sql.append("  FYearCreditRpt, \n");
        sql.append("  FMonthPnlRpt, \n");
        sql.append("  FYearPnlRpt, \n");
        sql.append("  FEndBalanceRpt, \n");
        sql.append("  FBeginQty, \n");
        sql.append("  FDebitQty, \n");
        sql.append("  FCreditQty, \n");
        sql.append("  FYearDebitQty, \n");
        sql.append("  FYearCreditQty, \n");
        sql.append("  FMonthPnlQty, \n");
        sql.append("  FYearPnlQty, \n");
        sql.append("  FEndQty, \n");
        sql.append("  FStandardBeginQty, \n");
        sql.append("  FStandardDebitQty, \n");
        sql.append("  FStandardCreditQty, \n");
        sql.append("  FStandardYearDebitQty, \n");
        sql.append("  FStandardYearCreditQty, \n");
        sql.append("  FStandardMonthPnlQty, \n");
        sql.append("  FStandardYearPnlQty, \n");
        sql.append("  FStandardEndQty, \n");
        sql.append("  FSeq \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  FProfitCenterID, \n");
        sql.append("  FOrgUnitID, \n");
        sql.append("  FAccountID, \n");
        sql.append("  FCurrencyID, \n");
        sql.append("  '" + tmpId + "' FAssistGrpID, \n");
        sql.append("  max(FMeasureUnitID), \n");
        sql.append("  sum(FBeginBalanceFor), \n");
        sql.append("  sum(FDebitFor), \n");
        sql.append("  sum(FCreditFor), \n");
        sql.append("  sum(FYearDebitFor), \n");
        sql.append("  sum(FYearCreditFor), \n");
        sql.append("  sum(FMonthPnlFor), \n");
        sql.append("  sum(FYearPnlFor), \n");
        sql.append("  sum(FEndBalanceFor), \n");
        sql.append("  sum(FBeginBalanceLocal), \n");
        sql.append("  sum(FDebitLocal), \n");
        sql.append("  sum(FCreditLocal), \n");
        sql.append("  sum(FYearDebitLocal), \n");
        sql.append("  sum(FYearCreditLocal), \n");
        sql.append("  sum(FMonthPnlLocal), \n");
        sql.append("  sum(FYearPnlLocal), \n");
        sql.append("  sum(FEndBalanceLocal), \n");
        sql.append("  sum(FBeginBalanceRpt), \n");
        sql.append("  sum(FDebitRpt), \n");
        sql.append("  sum(FCreditRpt), \n");
        sql.append("  sum(FYearDebitRpt), \n");
        sql.append("  sum(FYearCreditRpt), \n");
        sql.append("  sum(FMonthPnlRpt), \n");
        sql.append("  sum(FYearPnlRpt), \n");
        sql.append("  sum(FEndBalanceRpt), \n");
        sql.append("  sum(FBeginQty), \n");
        sql.append("  sum(FDebitQty), \n");
        sql.append("  sum(FCreditQty), \n");
        sql.append("  sum(FYearDebitQty), \n");
        sql.append("  sum(FYearCreditQty), \n");
        sql.append("  sum(FMonthPnlQty), \n");
        sql.append("  sum(FYearPnlQty), \n");
        sql.append("  sum(FEndQty), \n");
        sql.append("  sum(FStandardBeginQty), \n");
        sql.append("  sum(FStandardDebitQty), \n");
        sql.append("  sum(FStandardCreditQty), \n");
        sql.append("  sum(FStandardYearDebitQty), \n");
        sql.append("  sum(FStandardYearCreditQty), \n");
        sql.append("  sum(FStandardMonthPnlQty), \n");
        sql.append("  sum(FStandardYearPnlQty), \n");
        sql.append("  sum(FStandardEndQty), \n");
        sql.append("  min(Fseq) \n");
        sql.append("from T_PCA_InitPcAssistBalance where FAssistGrpID in (" + idin + ") \n");
        sql.append("group by FProfitCenterID, FOrgUnitID, FAccountID, FCurrencyID \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("delete from T_PCA_InitPcAssistBalance \n");
        sql.append("where FAssistGrpID in (" + idin + ") \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update T_PCA_InitPcAssistBalance \n");
        sql.append("set FAssistGrpID = ? \n");
        sql.append("where FAssistGrpID = ? \n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{grpid, tmpId});
    }

    @Override
    protected void _clearCashe(Context ctx) throws BOSException {
        logger.info((Object)"GLDatabaseCashe.clearCashe()");
        GLDatabaseCashe.clearCashe();
    }

    @Override
    protected void _updateByOrg(Context ctx, String org) throws BOSException, EASBizException {
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String dispalyname = "fDisplayNameGroup_" + loc;
        String longname = "flongNameGroup_" + loc;
        String longnumber = "fnumberGroup_" + loc;
        String sqlSelect = "select distinct a.fid,ac.fcount,a.fasstaccountid," + dispalyname + ",a." + longname + ",a." + longnumber + " from " + GLBalanceUtils.getAssistBalanceTable(1) + " b inner join t_bd_accountview v on b.forgunitid = v.fcompanyid and b.faccountid = v.fid and v.fcompanyid = ? inner join t_bd_asstaccount ac on v.fcaa = ac.fid inner join t_bd_assistanthg a on a.fid = b.fassistgrpid and a.fasstaccountid = v.fcaa where b.forgunitid = ? ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sqlSelect, (Object[])new Object[]{org, org});
        if (set == null) {
            return;
        }
        String sqlUpdate = "update t_bd_assistanthg set  " + dispalyname + "=? ," + longnumber + "=?, " + longname + "=? where fid=? ";
        LowTimer low = new LowTimer();
        low.reset();
        IVoucherAssistRecord iasst = VoucherAssistRecordFactory.getLocalInstance(ctx);
        HashMap<String, Object> asstaccountMap = new HashMap<String, Object>();
        HashMap<String, String[]> asstGrpOldMap = new HashMap<String, String[]>();
        HashMap asstGrpNewMap = new HashMap();
        try {
            while (set.next()) {
                String[] tmp;
                String accountid = set.getString("fasstaccountid");
                String asstGrpid = set.getString("fid");
                int count = set.getInt("fcount");
                String displayname_old = set.getString(dispalyname);
                String longname_old = set.getString(longname);
                String longnumber_old = set.getString(longnumber);
                if (asstaccountMap.get(accountid) != null) {
                    tmp = (String[])asstaccountMap.get(accountid);
                    tmp = (String)tmp + "," + asstGrpid;
                    asstaccountMap.put(accountid, tmp);
                } else {
                    asstaccountMap.put(accountid, count + "_" + asstGrpid);
                }
                if (asstGrpOldMap.get(asstGrpid) == null) {
                    tmp = new String[]{displayname_old, longname_old, longnumber_old};
                    asstGrpOldMap.put(asstGrpid, tmp);
                }
                GLDatabaseCashe.setValue((Context)ctx, (String)"assistant", (String)asstGrpid, null);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new SQLAccessException(e);
        }
        for (Map.Entry entry : asstaccountMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String[] countAndIds = value.split("_");
            int count = Integer.parseInt(countAndIds[0]);
            String[] ids = countAndIds[1].split(",");
            asstGrpNewMap.putAll(iasst.getDefaultAssitInfos(key, count, ids));
        }
        Iterator it = asstGrpOldMap.entrySet().iterator();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            String[] value = (String[])entry.getValue();
            String displayname_old = value[0];
            String longname_old = value[1];
            String longnumber_old = value[2];
            if (asstGrpNewMap.get(key) == null) continue;
            AsstActTypeInfo info = (AsstActTypeInfo)asstGrpNewMap.get(key);
            String displayname_new = info.getString("longName");
            String longname_new = info.getString("assGrp");
            String longnumber_new = info.getString("longnumber");
            logger.debug((Object)("longname_old:" + longname_old));
            logger.debug((Object)("longname_new:" + longname_new));
            if (displayname_old != null && displayname_old.equals(displayname_new) && longname_old != null && longname_old.equals(longname_new) && longnumber_old != null && longnumber_old.equals(longnumber_new)) continue;
            params.add(new Object[]{displayname_new, longnumber_new, longname_new, key});
            GLDatabaseCashe.setValue((Context)ctx, (String)"assistant", (String)key, null);
        }
        DbUtil.executeBatch((Context)ctx, (String)sqlUpdate, params);
        logger.info((Object)("all time:  " + low.msValue()));
        low.reset();
    }

    @Override
    protected Object _unite(Context ctx, Map params) throws BOSException, EASBizException {
        Boolean isEffect;
        Boolean isNew = (Boolean)params.get("isNew");
        if (isNew != null && isNew.booleanValue()) {
            return this.uniteByNew(ctx, params);
        }
        AsstActTypeInfo asstActType = (AsstActTypeInfo)params.get("asstActType");
        Object targetAsstAct = params.get("targetAsstAct");
        List sourceAsstActs = (List)params.get("sourceAsstActs");
        AsstAccountInfo asstAccount = (AsstAccountInfo)params.get("asstAccount");
        Boolean isDetail = (Boolean)params.get("isDetail");
        if (isDetail == null) {
            isDetail = false;
        }
        if ((isEffect = (Boolean)params.get("isEffect")) == null) {
            isEffect = false;
        }
        String targetAsstActId = ((DataBaseInfo)targetAsstAct).getId().toString();
        HashSet<String> sourceAsstActIds = new HashSet<String>();
        for (Object obj : sourceAsstActs) {
            sourceAsstActIds.add(((DataBaseInfo)obj).getId().toString());
        }
        String asstAccountId = asstAccount.getId().toString();
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Map> uGroups = new ArrayList<Map>();
        result.put("groups", uGroups);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            Object field;
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select t.FMappingFieldName \n");
            sql.append("from t_bd_asstactgroupdetail d \n");
            sql.append("join t_bd_asstacttype t on t.FID = d.fasstacttypeid \n");
            sql.append("where d.FAsstAccountID = ? \n");
            sql.append("order by d.FSeq \n");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{asstAccountId});
            ArrayList<String> fields = new ArrayList<String>();
            boolean found = false;
            while (rowSet.next()) {
                field = rowSet.getString("FMappingFieldName");
                fields.add((String)field);
                if (!asstActType.getMappingFieldName().equalsIgnoreCase((String)field)) continue;
                found = true;
            }
            if (!found) {
                result.put("msg", MessageFormat.format(this.getResource("not_include_asstAcyType", ctx), asstAccount.getName(), asstActType.getName()));
                field = result;
                return field;
            }
            StringBuffer fkey = new StringBuffer();
            if (fields.size() == 0) {
                result.put("msg", MessageFormat.format(this.getResource("accountasst_not_define_this_asstacttype", ctx), asstAccount.getName()));
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            if (isEffect.booleanValue()) {
                for (String field2 : fields) {
                    if (fkey.length() > 0) {
                        fkey.append(" || ");
                    }
                    fkey.append("isnull(" + field2 + ", '@')");
                }
            } else if (fields.size() == 1) {
                fkey.append("'@'");
            } else {
                for (String field2 : fields) {
                    if (asstActType.getMappingFieldName().equalsIgnoreCase(field2)) continue;
                    if (fkey.length() > 0) {
                        fkey.append(" || ");
                    }
                    fkey.append("isnull(" + field2 + ", '@')");
                }
            }
            sql.setLength(0);
            ArrayList<String> ps = new ArrayList<String>();
            if (isEffect.booleanValue() && sourceAsstActIds.size() > 0) {
                ps.add(targetAsstActId);
                ps.add(asstAccountId);
                ps.addAll(sourceAsstActIds);
                sql.append("update T_BD_AssistantHG set " + asstActType.getMappingFieldName() + " = ? \n");
                sql.append("where FAsstAccountID = ? and " + asstActType.getMappingFieldName() + " in " + SQLUtil.buildMarkSQL(sourceAsstActIds.size()));
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])ps.toArray());
            }
            sql.setLength(0);
            ps.clear();
            ps.add(asstAccountId);
            ps.add(targetAsstActId);
            if (!isEffect.booleanValue()) {
                ps.addAll(sourceAsstActIds);
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String sqlName = "";
            if (isDetail.booleanValue()) {
                sqlName = "hg.FLongNameGroup_" + loc + " FName, ";
            }
            sql.append("select hg.FID, " + sqlName + fkey + " FKey \n");
            sql.append("from t_bd_assistanthg hg \n");
            sql.append("where FAsstAccountID = ? \n");
            if (isEffect.booleanValue()) {
                sql.append("and " + asstActType.getMappingFieldName() + " = ? \n");
            } else {
                sql.append("and " + asstActType.getMappingFieldName() + " in " + SQLUtil.buildMarkSQL(sourceAsstActIds.size() + 1) + " \n");
            }
            sql.append("order by FKey, FCreateTime");
            HashMap groups = new HashMap();
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < ps.size(); ++i) {
                pstmt.setString(i + 1, (String)ps.get(i));
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String key = rs.getString("FKey");
                HashMap group = (HashMap)groups.get(key);
                if (group == null) {
                    group = new HashMap();
                    group.put("sourceIds", new ArrayList());
                    if (isDetail.booleanValue()) {
                        group.put("sourceNames", new ArrayList());
                    }
                    groups.put(key, group);
                }
                ((List)group.get("sourceIds")).add(rs.getString("FID"));
                if (!isDetail.booleanValue()) continue;
                String name = rs.getString("FName");
                if (name == null) {
                    name = "";
                }
                ((List)group.get("sourceNames")).add(name);
            }
            for (String key : groups.keySet()) {
                Map group = (Map)groups.get(key);
                List sourceIds = (List)group.get("sourceIds");
                if (sourceIds.size() <= 0) continue;
                String targetId = (String)sourceIds.remove(0);
                String targetName = (String)((List)group.get("sourceNames")).remove(0);
                group.put("targetId", targetId);
                group.put("targetName", targetName);
                AssistUtil._modify((Context)ctx, (String)targetId);
                group.put("action", "modify");
                if (sourceIds.size() > 0) {
                    if (isEffect.booleanValue()) {
                        this.doUniteByNew(ctx, false, targetId, sourceIds);
                        for (String sourceId : sourceIds) {
                            this._delete(ctx, sourceId);
                        }
                    }
                    group.put("action", "modify, unite");
                }
                group.put("key", key);
                uGroups.add(group);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
        }
        return result;
    }

    protected Object uniteByNew(Context ctx, Map params) throws BOSException, EASBizException {
        Object value;
        Boolean isEffect;
        AsstActTypeInfo asstActType = (AsstActTypeInfo)params.get("asstActType");
        Object targetAsstAct = params.get("targetAsstAct");
        List sourceAsstActs = (List)params.get("sourceAsstActs");
        AsstAccountInfo asstAccount = (AsstAccountInfo)params.get("asstAccount");
        Boolean isDetail = (Boolean)params.get("isDetail");
        if (isDetail == null) {
            isDetail = false;
        }
        if ((isEffect = (Boolean)params.get("isEffect")) == null) {
            isEffect = false;
        }
        String targetAsstActId = ((DataBaseInfo)targetAsstAct).getId().toString();
        HashSet<String> sourceAsstActIds = new HashSet<String>();
        for (Object obj : sourceAsstActs) {
            sourceAsstActIds.add(((DataBaseInfo)obj).getId().toString());
        }
        String asstAccountId = asstAccount.getId().toString();
        boolean retain = false;
        HashMap<String, Object> in = new HashMap<String, Object>();
        in.put("GL_MERGE_RETAIN", null);
        HashMap out = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(in);
        if (out != null && (value = out.get("GL_MERGE_RETAIN")) != null && "true".equalsIgnoreCase(value.toString())) {
            retain = true;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Map> uGroups = new ArrayList<Map>();
        result.put("groups", uGroups);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            Object field;
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select t.FMappingFieldName \n");
            sql.append("from t_bd_asstactgroupdetail d \n");
            sql.append("join t_bd_asstacttype t on t.FID = d.fasstacttypeid \n");
            sql.append("where d.FAsstAccountID = ? \n");
            sql.append("order by d.FSeq \n");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{asstAccountId});
            ArrayList<String> fields = new ArrayList<String>();
            boolean found = false;
            while (rowSet.next()) {
                field = rowSet.getString("FMappingFieldName");
                fields.add((String)field);
                if (!asstActType.getMappingFieldName().equalsIgnoreCase((String)field)) continue;
                found = true;
            }
            if (!found) {
                result.put("msg", MessageFormat.format(this.getResource("not_include_asstAcyType", ctx), asstAccount.getName(), asstActType.getName()));
                field = result;
                return field;
            }
            StringBuffer fkey = new StringBuffer();
            if (fields.size() == 0) {
                result.put("msg", MessageFormat.format(this.getResource("accountasst_not_define_this_asstacttype", ctx), asstAccount.getName()));
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            if (fields.size() == 1) {
                fkey.append("'@'");
            } else {
                for (String field2 : fields) {
                    if (asstActType.getMappingFieldName().equalsIgnoreCase(field2)) continue;
                    if (fkey.length() > 0) {
                        fkey.append(" || ");
                    }
                    fkey.append("isnull(" + field2 + ", '@')");
                }
            }
            sql.setLength(0);
            ArrayList<String> ps = new ArrayList<String>();
            ps.add(asstAccountId);
            ps.add(targetAsstActId);
            ps.addAll(sourceAsstActIds);
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String sqlName = "";
            if (isDetail.booleanValue()) {
                sqlName = "hg.FLongNameGroup_" + loc + " FName, ";
            }
            sql.append("select hg.FID, " + sqlName + "hg." + asstActType.getMappingFieldName() + ", " + fkey + " FKey \n");
            sql.append("from t_bd_assistanthg hg \n");
            sql.append("where FAsstAccountID = ? \n");
            sql.append("and " + asstActType.getMappingFieldName() + " in " + SQLUtil.buildMarkSQL(sourceAsstActIds.size() + 1) + " \n");
            sql.append("order by FKey, FCreateTime");
            HashMap groups = new HashMap();
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < ps.size(); ++i) {
                pstmt.setString(i + 1, (String)ps.get(i));
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String name;
                String id = rs.getString("FID");
                String asstActId = rs.getString(asstActType.getMappingFieldName());
                String key = rs.getString("FKey");
                HashMap<String, Object> group = (HashMap<String, Object>)groups.get(key);
                if (group == null) {
                    group = new HashMap<String, Object>();
                    group.put("sourceIds", new ArrayList());
                    if (isDetail.booleanValue()) {
                        group.put("sourceNames", new ArrayList());
                    }
                    groups.put(key, group);
                }
                if (asstActId.equals(targetAsstActId)) {
                    if (group.get("targetId") == null) {
                        group.put("targetId", id);
                        if (!isDetail.booleanValue()) continue;
                        name = rs.getString("FName");
                        if (name == null) {
                            name = "";
                        }
                        group.put("targetName", name);
                        continue;
                    }
                    ((List)group.get("sourceIds")).add(id);
                    if (isDetail.booleanValue()) {
                        name = rs.getString("FName");
                        if (name == null) {
                            name = "";
                        }
                        ((List)group.get("sourceNames")).add(name);
                    }
                    group.put("repeat", true);
                    continue;
                }
                ((List)group.get("sourceIds")).add(id);
                if (!isDetail.booleanValue()) continue;
                name = rs.getString("FName");
                if (name == null) {
                    name = "";
                }
                ((List)group.get("sourceNames")).add(name);
            }
            for (String key : groups.keySet()) {
                Map group = (Map)groups.get(key);
                String targetId = (String)group.get("targetId");
                List sourceIds = (List)group.get("sourceIds");
                if (targetId == null) {
                    if (sourceIds.size() <= 0) continue;
                    if (retain) {
                        String hgId = (String)sourceIds.get(0);
                        group.put("targetId", "NewIdWillBeCreated");
                        if (isDetail.booleanValue()) {
                            group.put("targetName", "NewNameWillBeCreated");
                        }
                        if (isEffect.booleanValue()) {
                            targetId = this.getNewAssistantHg(ctx, asstAccount, fields, asstActType, targetAsstActId, hgId);
                            AssistUtil._modify((Context)ctx, (String)targetId);
                            group.put("targetId", targetId);
                            IRowSet rsName = DbUtil.executeQuery((Context)ctx, (String)("select FLongNameGroup_" + loc + " FName from T_BD_AssistantHG where fid = ?"), (Object[])new String[]{targetId});
                            if (rsName.next()) {
                                group.put("targetName", rsName.getString("FName"));
                            } else {
                                group.put("targetName", "unknownerror");
                            }
                            this.doUniteByNew(ctx, true, targetId, sourceIds);
                        }
                        group.put("key", key);
                        group.put("action", "nUnite");
                        uGroups.add(group);
                        continue;
                    }
                    targetId = (String)sourceIds.remove(0);
                    group.put("targetId", targetId);
                    if (isDetail.booleanValue()) {
                        String targetName = (String)((List)group.get("sourceNames")).remove(0);
                        group.put("targetName", targetName);
                    }
                    if (isEffect.booleanValue()) {
                        DbUtil.execute((Context)ctx, (String)("update T_BD_AssistantHG set " + asstActType.getMappingFieldName() + " = ? where FID = ?"), (Object[])new Object[]{targetAsstActId, targetId});
                        AssistUtil._modify((Context)ctx, (String)targetId);
                    }
                    String action = "modify";
                    if (sourceIds.size() > 0) {
                        if (isEffect.booleanValue()) {
                            this.doUniteByNew(ctx, true, targetId, sourceIds);
                            for (String sourceId : sourceIds) {
                                this._delete(ctx, sourceId);
                            }
                        }
                        action = action + ", unite";
                    }
                    group.put("key", key);
                    group.put("action", action);
                    uGroups.add(group);
                    continue;
                }
                if (sourceIds.size() <= 0) continue;
                if (isEffect.booleanValue()) {
                    this.doUniteByNew(ctx, true, targetId, sourceIds);
                    if (!retain) {
                        for (String sourceId : sourceIds) {
                            this._delete(ctx, sourceId);
                        }
                    }
                }
                group.put("key", key);
                group.put("action", group.get("repeat") != null ? "rUnite" : "unite");
                uGroups.add(group);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
        }
        return result;
    }

    private String getNewAssistantHg(Context ctx, AsstAccountInfo asstAccount, List<String> fields, AsstActTypeInfo asstActType, String targetAsstActId, String hgId) throws BOSException {
        String id = BOSUuid.create((BOSObjectType)new AssistantHGInfo().getBOSType()).toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Timestamp time = GlUtils.getTime();
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_BD_AssistantHG ( \n");
        sql.append("  FID, FAsstAccountID, FCount, \n");
        for (String field : fields) {
            sql.append("  " + field + ", \n");
        }
        sql.append("  FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  ?, FAsstAccountID, FCount, \n");
        for (String field : fields) {
            if (asstActType.getMappingFieldName().equalsIgnoreCase(field)) {
                sql.append("  ?, \n");
                continue;
            }
            sql.append("  " + field + ", \n");
        }
        sql.append("  ?, ?, ?, ? \n");
        sql.append("from T_BD_AssistantHG \n");
        sql.append("where FID = ? \n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id, targetAsstActId, userId, time, userId, time, hgId});
        return id;
    }

    protected void doUniteByNew(Context ctx, boolean checkExist, String id, List<String> ids) throws BOSException, EASBizException {
        StringBuffer idin = new StringBuffer();
        for (int i = 0; i < ids.size(); ++i) {
            if (i > 0) {
                idin.append(",");
            }
            idin.append("'").append(ids.get(i)).append("'");
        }
        this.unitVoucherAssistRecord(ctx, id, idin.toString());
        this.unitInitAssistBalance(ctx, checkExist, id, idin.toString());
        this.unitAssistBalance(ctx, checkExist, id, idin.toString());
        this.pcaUnitInitAssistBalance(ctx, checkExist, id, idin.toString());
        this.pcaUnitAssistBalance(ctx, checkExist, id, idin.toString());
        this.unitCashflowAssistRecord(ctx, id, idin.toString());
    }

    protected void unitAssistBalance(Context ctx, boolean checkExist, String grpid, String idin) throws BOSException {
        this.doUnitAssistBalance(ctx, checkExist, 2, 1, null, grpid, idin);
        this.doUnitAssistBalance(ctx, checkExist, 2, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", grpid, idin);
        this.doUnitAssistBalance(ctx, checkExist, 2, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", grpid, idin);
        this.doUnitAssistBalance(ctx, checkExist, 2, 5, null, grpid, idin);
        this.doUnitAssistBalance(ctx, checkExist, 2, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", grpid, idin);
        this.doUnitAssistBalance(ctx, checkExist, 2, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", grpid, idin);
        this.doUnitAssistBalance(ctx, checkExist, 3, 1, null, grpid, idin);
        this.doUnitAssistBalance(ctx, checkExist, 3, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", grpid, idin);
        this.doUnitAssistBalance(ctx, checkExist, 3, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", grpid, idin);
        this.doUnitAssistBalance(ctx, checkExist, 3, 5, null, grpid, idin);
        this.doUnitAssistBalance(ctx, checkExist, 3, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", grpid, idin);
        this.doUnitAssistBalance(ctx, checkExist, 3, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", grpid, idin);
    }

    protected void doUnitAssistBalance(Context ctx, boolean checkExist, int balanceType, int balType, String currencyId, String grpid, String idin) throws BOSException {
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        String tmpId = BOSUuid.create((String)"ABCD1234").toString();
        if (checkExist) {
            sql.append("select top 1 1 from " + GLBalanceUtils.getBalanceTable(balanceType, balType, currencyId) + " \n");
            sql.append("where FAssistGrpID in (" + idin + ") \n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (!rs.next()) {
                    return;
                }
            }
            catch (SQLException e) {
                throw new BOSException();
            }
        }
        idin = "'" + grpid + "'," + idin;
        sql.setLength(0);
        sql.append("insert into " + GLBalanceUtils.getBalanceTable(balanceType, balType, currencyId) + " ( \n");
        sql.append("  FOrgUnitID, \n");
        sql.append("  FAccountID, \n");
        if (isForCurrency) {
            sql.append("  FCurrencyID, \n");
        }
        sql.append("  FAssistGrpID, \n");
        if (balanceType == 3) {
            sql.append("  FMeasureUnitID, \n");
        }
        sql.append("  FPeriod, \n");
        if (isForCurrency) {
            sql.append("  FBeginBalanceFor, \n");
            sql.append("  FDebitFor, \n");
            sql.append("  FCreditFor, \n");
            sql.append("  FYearDebitFor, \n");
            sql.append("  FYearCreditFor, \n");
            sql.append("  FMonthPnlFor, \n");
            sql.append("  FYearPnlFor, \n");
            sql.append("  FEndBalanceFor, \n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("  FBeginBalanceLocal, \n");
            sql.append("  FDebitLocal, \n");
            sql.append("  FCreditLocal, \n");
            sql.append("  FYearDebitLocal, \n");
            sql.append("  FYearCreditLocal, \n");
            sql.append("  FMonthPnlLocal, \n");
            sql.append("  FYearPnlLocal, \n");
            sql.append("  FEndBalanceLocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  FBeginBalanceRpt, \n");
            sql.append("  FDebitRpt, \n");
            sql.append("  FCreditRpt, \n");
            sql.append("  FYearDebitRpt, \n");
            sql.append("  FYearCreditRpt, \n");
            sql.append("  FMonthPnlRpt, \n");
            sql.append("  FYearPnlRpt, \n");
            sql.append("  FEndBalanceRpt, \n");
        }
        sql.append("  FBeginQty, \n");
        sql.append("  FDebitQty, \n");
        sql.append("  FCreditQty, \n");
        sql.append("  FYearDebitQty, \n");
        sql.append("  FYearCreditQty, \n");
        sql.append("  FMonthPnlQty, \n");
        sql.append("  FYearPnlQty, \n");
        sql.append("  FEndQty, \n");
        sql.append("  FDetailCount \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  FOrgUnitID, \n");
        sql.append("  FAccountID, \n");
        if (isForCurrency) {
            sql.append("  FCurrencyID, \n");
        }
        sql.append("  '" + tmpId + "' FAssistGrpID, \n");
        if (balanceType == 3) {
            sql.append("  FMeasureUnitID, \n");
        }
        sql.append("  FPeriod, \n");
        if (isForCurrency) {
            sql.append("  sum(FBeginBalanceFor), \n");
            sql.append("  sum(FDebitFor), \n");
            sql.append("  sum(FCreditFor), \n");
            sql.append("  sum(FYearDebitFor), \n");
            sql.append("  sum(FYearCreditFor), \n");
            sql.append("  sum(FMonthPnlFor), \n");
            sql.append("  sum(FYearPnlFor), \n");
            sql.append("  sum(FEndBalanceFor), \n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("  sum(FBeginBalanceLocal), \n");
            sql.append("  sum(FDebitLocal), \n");
            sql.append("  sum(FCreditLocal), \n");
            sql.append("  sum(FYearDebitLocal), \n");
            sql.append("  sum(FYearCreditLocal), \n");
            sql.append("  sum(FMonthPnlLocal), \n");
            sql.append("  sum(FYearPnlLocal), \n");
            sql.append("  sum(FEndBalanceLocal), \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  sum(FBeginBalanceRpt), \n");
            sql.append("  sum(FDebitRpt), \n");
            sql.append("  sum(FCreditRpt), \n");
            sql.append("  sum(FYearDebitRpt), \n");
            sql.append("  sum(FYearCreditRpt), \n");
            sql.append("  sum(FMonthPnlRpt), \n");
            sql.append("  sum(FYearPnlRpt), \n");
            sql.append("  sum(FEndBalanceRpt), \n");
        }
        sql.append("  sum(FBeginQty), \n");
        sql.append("  sum(FDebitQty), \n");
        sql.append("  sum(FCreditQty), \n");
        sql.append("  sum(FYearDebitQty), \n");
        sql.append("  sum(FYearCreditQty), \n");
        sql.append("  sum(isnull(FMonthPnlQty, 0)), \n");
        sql.append("  sum(isnull(FYearPnlQty, 0)), \n");
        sql.append("  sum(FEndQty), \n");
        sql.append("  sum(isnull(FDetailCount, 0)) \n");
        sql.append("from " + GLBalanceUtils.getBalanceTable(balanceType, balType, currencyId) + " \n");
        sql.append("where FAssistGrpID in (" + idin + ") \n");
        sql.append("group by FOrgUnitID, FAccountID, ");
        if (isForCurrency) {
            sql.append("FCurrencyID, ");
        }
        if (balanceType == 3) {
            sql.append("FMeasureUnitID, ");
        }
        sql.append("FPeriod \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("delete from " + GLBalanceUtils.getBalanceTable(balanceType, balType, currencyId) + " \n");
        sql.append("where FAssistGrpID in (" + idin + ") \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update " + GLBalanceUtils.getBalanceTable(balanceType, balType, currencyId) + " \n");
        sql.append("set FAssistGrpID = ? \n");
        sql.append("where FAssistGrpID = ? \n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{grpid, tmpId});
    }

    protected void pcaUnitAssistBalance(Context ctx, boolean checkExist, String grpid, String idin) throws BOSException {
        this.doPcaUnitAssistBalance(ctx, checkExist, 2, 1, null, grpid, idin);
        this.doPcaUnitAssistBalance(ctx, checkExist, 2, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", grpid, idin);
        this.doPcaUnitAssistBalance(ctx, checkExist, 2, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", grpid, idin);
        this.doPcaUnitAssistBalance(ctx, checkExist, 2, 5, null, grpid, idin);
        this.doPcaUnitAssistBalance(ctx, checkExist, 2, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", grpid, idin);
        this.doPcaUnitAssistBalance(ctx, checkExist, 2, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", grpid, idin);
        this.doPcaUnitAssistBalance(ctx, checkExist, 3, 1, null, grpid, idin);
        this.doPcaUnitAssistBalance(ctx, checkExist, 3, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", grpid, idin);
        this.doPcaUnitAssistBalance(ctx, checkExist, 3, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", grpid, idin);
        this.doPcaUnitAssistBalance(ctx, checkExist, 3, 5, null, grpid, idin);
        this.doPcaUnitAssistBalance(ctx, checkExist, 3, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", grpid, idin);
        this.doPcaUnitAssistBalance(ctx, checkExist, 3, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", grpid, idin);
    }

    protected void doPcaUnitAssistBalance(Context ctx, boolean checkExist, int balanceType, int balType, String currencyId, String grpid, String idin) throws BOSException {
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        String tmpId = BOSUuid.create((String)"ABCD1234").toString();
        if (checkExist) {
            sql.append("select top 1 1 from " + PCABalanceUtils.getBalanceTable((int)balanceType, (int)balType, (String)currencyId) + " \n");
            sql.append("where FAssistGrpID in (" + idin + ") \n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (!rs.next()) {
                    return;
                }
            }
            catch (SQLException e) {
                throw new BOSException();
            }
        }
        idin = "'" + grpid + "'," + idin;
        sql.setLength(0);
        sql.append("insert into " + PCABalanceUtils.getBalanceTable((int)balanceType, (int)balType, (String)currencyId) + " ( \n");
        sql.append("  FProfitCenterID, \n");
        sql.append("  FOrgUnitID, \n");
        sql.append("  FAccountID, \n");
        if (isForCurrency) {
            sql.append("  FCurrencyID, \n");
        }
        sql.append("  FAssistGrpID, \n");
        if (balanceType == 3) {
            sql.append("  FMeasureUnitID, \n");
        }
        sql.append("  FPeriod, \n");
        if (isForCurrency) {
            sql.append("  FBeginBalanceFor, \n");
            sql.append("  FDebitFor, \n");
            sql.append("  FCreditFor, \n");
            sql.append("  FYearDebitFor, \n");
            sql.append("  FYearCreditFor, \n");
            sql.append("  FMonthPnlFor, \n");
            sql.append("  FYearPnlFor, \n");
            sql.append("  FEndBalanceFor, \n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("  FBeginBalanceLocal, \n");
            sql.append("  FDebitLocal, \n");
            sql.append("  FCreditLocal, \n");
            sql.append("  FYearDebitLocal, \n");
            sql.append("  FYearCreditLocal, \n");
            sql.append("  FMonthPnlLocal, \n");
            sql.append("  FYearPnlLocal, \n");
            sql.append("  FEndBalanceLocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  FBeginBalanceRpt, \n");
            sql.append("  FDebitRpt, \n");
            sql.append("  FCreditRpt, \n");
            sql.append("  FYearDebitRpt, \n");
            sql.append("  FYearCreditRpt, \n");
            sql.append("  FMonthPnlRpt, \n");
            sql.append("  FYearPnlRpt, \n");
            sql.append("  FEndBalanceRpt, \n");
        }
        sql.append("  FBeginQty, \n");
        sql.append("  FDebitQty, \n");
        sql.append("  FCreditQty, \n");
        sql.append("  FYearDebitQty, \n");
        sql.append("  FYearCreditQty, \n");
        sql.append("  FMonthPnlQty, \n");
        sql.append("  FYearPnlQty, \n");
        sql.append("  FEndQty, \n");
        sql.append("  FDetailCount \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  FProfitCenterID, \n");
        sql.append("  FOrgUnitID, \n");
        sql.append("  FAccountID, \n");
        if (isForCurrency) {
            sql.append("  FCurrencyID, \n");
        }
        sql.append("  '" + tmpId + "' FAssistGrpID, \n");
        if (balanceType == 3) {
            sql.append("  FMeasureUnitID, \n");
        }
        sql.append("  FPeriod, \n");
        if (isForCurrency) {
            sql.append("  sum(FBeginBalanceFor), \n");
            sql.append("  sum(FDebitFor), \n");
            sql.append("  sum(FCreditFor), \n");
            sql.append("  sum(FYearDebitFor), \n");
            sql.append("  sum(FYearCreditFor), \n");
            sql.append("  sum(FMonthPnlFor), \n");
            sql.append("  sum(FYearPnlFor), \n");
            sql.append("  sum(FEndBalanceFor), \n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("  sum(FBeginBalanceLocal), \n");
            sql.append("  sum(FDebitLocal), \n");
            sql.append("  sum(FCreditLocal), \n");
            sql.append("  sum(FYearDebitLocal), \n");
            sql.append("  sum(FYearCreditLocal), \n");
            sql.append("  sum(FMonthPnlLocal), \n");
            sql.append("  sum(FYearPnlLocal), \n");
            sql.append("  sum(FEndBalanceLocal), \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  sum(FBeginBalanceRpt), \n");
            sql.append("  sum(FDebitRpt), \n");
            sql.append("  sum(FCreditRpt), \n");
            sql.append("  sum(FYearDebitRpt), \n");
            sql.append("  sum(FYearCreditRpt), \n");
            sql.append("  sum(FMonthPnlRpt), \n");
            sql.append("  sum(FYearPnlRpt), \n");
            sql.append("  sum(FEndBalanceRpt), \n");
        }
        sql.append("  sum(FBeginQty), \n");
        sql.append("  sum(FDebitQty), \n");
        sql.append("  sum(FCreditQty), \n");
        sql.append("  sum(FYearDebitQty), \n");
        sql.append("  sum(FYearCreditQty), \n");
        sql.append("  sum(isnull(FMonthPnlQty, 0)), \n");
        sql.append("  sum(isnull(FYearPnlQty, 0)), \n");
        sql.append("  sum(FEndQty), \n");
        sql.append("  sum(isnull(FDetailCount, 0)) \n");
        sql.append("from " + PCABalanceUtils.getBalanceTable((int)balanceType, (int)balType, (String)currencyId) + " \n");
        sql.append("where FAssistGrpID in (" + idin + ") \n");
        sql.append("group by FProfitCenterID, FOrgUnitID, FAccountID, ");
        if (isForCurrency) {
            sql.append("FCurrencyID, ");
        }
        if (balanceType == 3) {
            sql.append("FMeasureUnitID, ");
        }
        sql.append("FPeriod \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("delete from " + PCABalanceUtils.getBalanceTable((int)balanceType, (int)balType, (String)currencyId) + " \n");
        sql.append("where FAssistGrpID in (" + idin + ")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update " + PCABalanceUtils.getBalanceTable((int)balanceType, (int)balType, (String)currencyId) + " \n");
        sql.append("set FAssistGrpID = ? \n");
        sql.append("where FAssistGrpID = ? \n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{grpid, tmpId});
    }

    public String getResource(String resName, Context ctx) {
        return ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)ctx.getLocale());
    }

    @Override
    protected Map _repair(Context ctx, Map params) throws BOSException, EASBizException {
        String str;
        String name;
        String number;
        String number2;
        AsstActTypeInfo asstActType2;
        String number3;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList hgs = new ArrayList();
        result.put("hgs", hgs);
        AsstAccountInfo asstAccount = null;
        Object param = params.get("asstAccount");
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("count");
        view.setSelector(selector);
        if (param instanceof AsstAccountInfo) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)((AsstAccountInfo)param).getId().toString()));
            view.setFilter(filter);
            AsstAccountCollection coll = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstAccountCollection(view);
            if (coll.size() > 0) {
                asstAccount = coll.get(0);
            }
        } else if (param instanceof String && (number3 = ((String)param).trim()).length() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number3));
            view.setFilter(filter);
            AsstAccountCollection coll = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstAccountCollection(view);
            if (coll.size() > 0) {
                asstAccount = coll.get(0);
            } else {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)number3));
                view.setFilter(filter);
                coll = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstAccountCollection(view);
                if (coll.size() > 0) {
                    asstAccount = coll.get(0);
                }
            }
        }
        if (asstAccount == null) {
            result.put("msg", this.getResource("AsstAccount_CanNot_Empty", ctx));
            return result;
        }
        HashMap<String, AsstActTypeInfo> asstActTypes = new HashMap<String, AsstActTypeInfo>();
        AsstActTypeCollection col = this.getAsstActTypes(ctx, asstAccount.getId().toString());
        for (AsstActTypeInfo asstActType2 : col) {
            asstActTypes.put(asstActType2.getId().toString(), asstActType2);
        }
        if (asstAccount.getCount() != asstActTypes.size()) {
            result.put("msg", MessageFormat.format(this.getResource("AsstAccont_AsstActType_CountError", ctx), asstAccount.getName()));
            return result;
        }
        int count = asstAccount.getCount();
        asstActType2 = null;
        param = params.get("asstActType");
        if (param instanceof AsstActTypeInfo) {
            asstActType2 = (AsstActTypeInfo)param;
        } else if (param instanceof String && (number2 = ((String)param).trim()).length() > 0) {
            view = new EntityViewInfo();
            selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number2));
            view.setFilter(filter);
            AsstActTypeCollection coll = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(view);
            if (coll.size() > 0) {
                asstActType2 = coll.get(0);
            } else {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)number2));
                view.setFilter(filter);
                coll = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(view);
                if (coll.size() > 0) {
                    asstActType2 = coll.get(0);
                }
            }
        }
        if (asstActType2 == null) {
            result.put("msg", this.getResource("AsstActType_CanNot_Empty", ctx));
            return result;
        }
        if (asstActTypes.get(asstActType2.getId().toString()) == null) {
            result.put("msg", MessageFormat.format(this.getResource("AsstAccount_No_AsstActType", ctx), asstAccount.getName(), asstActType2.getName()));
            return result;
        }
        asstActType2 = (AsstActTypeInfo)asstActTypes.get(asstActType2.getId().toString());
        DataBaseInfo asstAct = null;
        String asstActNumber = null;
        param = params.get("asstAct");
        if (param instanceof DataBaseInfo) {
            asstAct = (DataBaseInfo)param;
        } else if (param instanceof String && (number = ((String)param).trim()).length() > 0) {
            asstActNumber = number;
        }
        String hgName = null;
        param = params.get("hg");
        if (param instanceof String && (name = ((String)param).trim()).length() > 0) {
            hgName = name;
        }
        boolean isDetail = params.get("isDetail") != null && Boolean.parseBoolean(params.get("isDetail").toString());
        boolean isEffect = params.get("isEffect") != null && Boolean.parseBoolean(params.get("isEffect").toString());
        Context newCtx = null;
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        if (params.get("loc") != null && ("l1".equalsIgnoreCase(str = params.get("loc").toString().trim()) || "l3".equalsIgnoreCase(str))) {
            loc = str;
            newCtx = new Context(ctx.getCaller(), ctx.getSolution(), ctx.getAIS(), ctx.getLocale());
            newCtx.setReadAIS(ctx.getReadAIS());
            newCtx.setClientHostIP(ctx.getClientHostIP());
            newCtx.setClientHostName(ctx.getClientHostName());
            newCtx.setUserName(ctx.getUserName());
            ContextUtil.setCurrentUserInfo((Context)newCtx, (UserInfo)ContextUtil.getCurrentUserInfo((Context)ctx));
            ContextUtil.setCurrentFIUnit((Context)newCtx, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
            if ("l1".equalsIgnoreCase(loc)) {
                newCtx.setLocale(LocaleUtils.locale_l1);
            } else {
                newCtx.setLocale(LocaleUtils.locale_l3);
            }
        }
        String dispalyname = "fDisplayNameGroup_" + loc;
        String longname = "flongNameGroup_" + loc;
        String longnumber = "fnumberGroup_" + loc;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet set = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select \n");
            sql.append("    hg.FID, hg." + dispalyname + ", hg." + longname + ", hg." + longnumber + " \n");
            sql.append("from T_BD_AssistantHG hg \n");
            sql.append("join " + asstActType2.getRealtionDataObject() + " aat on aat.FID = hg." + asstActType2.getMappingFieldName() + " \n");
            sql.append("where hg.FAsstAccountID = ? \n");
            if (asstAct != null) {
                sql.append("and aat.FID = ? \n");
            }
            if (asstActNumber != null) {
                sql.append("and (aat.FNumber like ? or aat.FName_" + loc + " like ?) \n");
            }
            if (hgName != null) {
                sql.append("and hg.FLongNameGroup_" + loc + " like ? \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, asstAccount.getId().toString());
            if (asstAct != null) {
                pstmt.setString(index++, asstAct.getId().toString());
            }
            if (asstActNumber != null) {
                pstmt.setString(index++, "%" + asstActNumber + "%");
                pstmt.setString(index++, "%" + asstActNumber + "%");
            }
            if (hgName != null) {
                pstmt.setString(index++, "%" + hgName + "%");
            }
            String sqlUpdate = "update t_bd_assistanthg set  " + dispalyname + "=? , " + longnumber + "=?, " + longname + "=? ,fcount=? where fid=? ";
            IVoucherAssistRecord iasst = VoucherAssistRecordFactory.getLocalInstance(newCtx == null ? ctx : newCtx);
            int total = 0;
            int cnt = 0;
            set = pstmt.executeQuery();
            while (set.next()) {
                ++total;
                String asstGrpid = set.getString("fid");
                String displayname_old = set.getString(dispalyname);
                String longname_old = set.getString(longname);
                String longnumber_old = set.getString(longnumber);
                AsstActTypeInfo info = (AsstActTypeInfo)iasst.getDefaultAssitInfo(asstAccount.getId().toString(), asstGrpid);
                String displayname_new = info.getString("longName");
                String longname_new = info.getString("assGrp");
                String longnumber_new = info.getString("longnumber");
                if (displayname_old != null && displayname_old.equals(displayname_new) && longname_old != null && longname_old.equals(longname_new) && longnumber_old != null && longnumber_old.equals(longnumber_new)) continue;
                ++cnt;
                if (isEffect) {
                    DbUtil.execute((Context)ctx, (String)sqlUpdate, (Object[])new Object[]{displayname_new, longnumber_new, longname_new, new Integer(count), asstGrpid});
                }
                if (!isDetail || hgs.size() >= 100) continue;
                HashMap<String, String> one = new HashMap<String, String>();
                one.put("id", asstGrpid);
                one.put("displayname_old", displayname_old);
                one.put("displayname_new", displayname_new);
                one.put("longname_old", longname_old);
                one.put("longname_new", longname_new);
                one.put("longnumber_old", longnumber_old);
                one.put("longnumber_new", longnumber_new);
                hgs.add(one);
            }
            result.put("total", total);
            result.put("count", cnt);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(set, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)set, (Statement)pstmt, (Connection)conn);
        return result;
    }

    private AsstActTypeCollection getAsstActTypes(Context ctx, String asstAccountId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        AsstActGroupDetailCollection asstcol = AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(view);
        AsstActTypeCollection asstActTypes = new AsstActTypeCollection();
        for (int i = 0; i < asstcol.size(); ++i) {
            asstActTypes.add(asstcol.get(i).getAsstActType());
        }
        return asstActTypes;
    }
}

