/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowSplitRecordCollection;
import com.kingdee.eas.fi.gl.CashflowSplitRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.CashFlowUtils;
import com.kingdee.eas.fi.gl.app.ITAccountSplitStrategy;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;

public class ByOppoSiteSplitStrategy
implements ITAccountSplitStrategy {
    private static final ITAccountSplitStrategy instance = new ByOppoSiteSplitStrategy();

    public static ITAccountSplitStrategy getInstance() {
        return instance;
    }

    @Override
    public CashflowSplitRecordCollection split(Context ctx, VoucherInfo voucherInfo, Map<String, Object> params) throws EASBizException, BOSException {
        CashflowFlag cashflowFlag = com.kingdee.eas.fi.gl.CashFlowUtils.computeCashflowFlag(voucherInfo);
        if (CashflowFlag.BOTHNONE.equals((Object)cashflowFlag)) {
            return new CashflowSplitRecordCollection();
        }
        String companyID = voucherInfo.getCompany().getId().toString();
        CompanyOrgUnitInfo company = GlUtils.getCompanyById(ctx, companyID);
        voucherInfo.getCompany().setBaseCurrency(company.getBaseCurrency());
        voucherInfo.getCompany().setReportCurrency(company.getReportCurrency());
        VoucherEntryCollection[] ownAndOppEntries = this.getOwnAndOppEntries(ctx, voucherInfo, cashflowFlag);
        VoucherEntryCollection ownEntries = ownAndOppEntries[0];
        VoucherEntryCollection oppEntries = ownAndOppEntries[1];
        VoucherEntryInfo targetEntry = this.findTargetEntry(ctx, ownEntries, cashflowFlag);
        CashflowSplitRecordCollection splitResult = new CashflowSplitRecordCollection();
        if (targetEntry == null) {
            return splitResult;
        }
        ownEntries.remove(targetEntry);
        targetEntry = (VoucherEntryInfo)targetEntry.clone();
        CashflowSplitRecordCollection diposeSplitRecordCollection = this.creatDiposeSplitRecordCollection(voucherInfo, targetEntry, ownEntries);
        CashflowSplitRecordCollection cashflowSplitRecordCollection = this.creatSplitRecordCollection(voucherInfo, targetEntry, oppEntries, cashflowFlag);
        splitResult.addCollection(diposeSplitRecordCollection);
        splitResult.addCollection(cashflowSplitRecordCollection);
        return splitResult;
    }

    private CashflowSplitRecordCollection creatSplitRecordCollection(VoucherInfo voucherInfo, VoucherEntryInfo ownEntry, VoucherEntryCollection oppEntries, CashflowFlag cashflowFlag) {
        CashflowSplitRecordCollection cashflowSplitRecordCollection = new CashflowSplitRecordCollection();
        if (oppEntries.size() == 0) {
            return cashflowSplitRecordCollection;
        }
        ItemFlag itemFlag = ItemFlag.PRIMARY;
        if (cashflowFlag == CashflowFlag.ONLY_PNLACCOUNT) {
            itemFlag = ItemFlag.SUPPLEMENTARY;
        }
        for (int i = 0; i < oppEntries.size(); ++i) {
            VoucherEntryInfo oppEntry = oppEntries.get(i);
            boolean isSameDC = ownEntry.getEntryDC() == oppEntry.getEntryDC();
            VoucherAssistRecordCollection assistRecords = oppEntry.getAssistRecords();
            if (assistRecords != null && assistRecords.size() > 0) {
                for (int j = 0; j < assistRecords.size(); ++j) {
                    VoucherAssistRecordInfo oppAssistRecord = assistRecords.get(j);
                    CashflowSplitRecordInfo splitRecordInfo = new CashflowSplitRecordInfo();
                    splitRecordInfo.setItemFlag(itemFlag);
                    splitRecordInfo.setEntry(ownEntry);
                    splitRecordInfo.setAccount(ownEntry.getAccount());
                    splitRecordInfo.setEntryDC(ownEntry.getEntryDC());
                    splitRecordInfo.setCurrency(ownEntry.getCurrency());
                    splitRecordInfo.setOpposingAccountEntry(oppEntry);
                    splitRecordInfo.setOppVoucherAssistRecord(oppAssistRecord);
                    splitRecordInfo.setOppAssGrp(oppAssistRecord.getAssGrp());
                    splitRecordInfo.setOppAccount(oppEntry.getAccount());
                    splitRecordInfo.setOppEntryDC(oppEntry.getEntryDC());
                    splitRecordInfo.setIsSupItem(false);
                    splitRecordInfo.setVoucher(voucherInfo);
                    splitRecordInfo.setLocalAmount(isSameDC ? oppAssistRecord.getLocalAmount().negate() : oppAssistRecord.getLocalAmount());
                    splitRecordInfo.setReportingAmount(isSameDC ? oppAssistRecord.getReportingAmount().negate() : oppAssistRecord.getReportingAmount());
                    this.setCashflowAmount(splitRecordInfo, voucherInfo, ownEntry);
                    cashflowSplitRecordCollection.add(splitRecordInfo);
                }
                continue;
            }
            CashflowSplitRecordInfo splitRecordInfo = new CashflowSplitRecordInfo();
            splitRecordInfo.setItemFlag(itemFlag);
            splitRecordInfo.setEntry(ownEntry);
            splitRecordInfo.setAccount(ownEntry.getAccount());
            splitRecordInfo.setEntryDC(ownEntry.getEntryDC());
            splitRecordInfo.setCurrency(ownEntry.getCurrency());
            splitRecordInfo.setOpposingAccountEntry(oppEntry);
            splitRecordInfo.setOppAccount(oppEntry.getAccount());
            splitRecordInfo.setOppEntryDC(oppEntry.getEntryDC());
            splitRecordInfo.setIsSupItem(false);
            splitRecordInfo.setVoucher(voucherInfo);
            splitRecordInfo.setLocalAmount(isSameDC ? oppEntry.getLocalAmount().negate() : oppEntry.getLocalAmount());
            splitRecordInfo.setReportingAmount(isSameDC ? oppEntry.getReportingAmount().negate() : oppEntry.getReportingAmount());
            this.setCashflowAmount(splitRecordInfo, voucherInfo, ownEntry);
            cashflowSplitRecordCollection.add(splitRecordInfo);
        }
        return cashflowSplitRecordCollection;
    }

    private CashflowSplitRecordCollection creatDiposeSplitRecordCollection(VoucherInfo voucherInfo, VoucherEntryInfo targetEntry, VoucherEntryCollection ownEntries) {
        CashflowSplitRecordInfo splitRecordInfo;
        CashflowSplitRecordCollection diposeSplitRecordCollection = new CashflowSplitRecordCollection();
        if (targetEntry.getLocalAmount().signum() == 0) {
            return diposeSplitRecordCollection;
        }
        BigDecimal disposedDebitLocalAmount = GlUtils.zero;
        BigDecimal disposedCreditLocalAmount = GlUtils.zero;
        BigDecimal disposedDebitReportAmount = GlUtils.zero;
        BigDecimal disposedCreditReportAmount = GlUtils.zero;
        for (int i = 0; i < ownEntries.size(); ++i) {
            VoucherEntryInfo entry = ownEntries.get(i);
            if (entry.getLocalAmount().signum() == 0) continue;
            splitRecordInfo = new CashflowSplitRecordInfo();
            splitRecordInfo.setItemFlag(ItemFlag.DISPOSE);
            splitRecordInfo.setEntry(entry);
            splitRecordInfo.setAccount(entry.getAccount());
            splitRecordInfo.setEntryDC(entry.getEntryDC());
            if (entry.getEntryDC() == EntryDC.DEBIT) {
                disposedDebitLocalAmount = disposedDebitLocalAmount.add(entry.getLocalAmount());
                disposedDebitReportAmount = disposedDebitReportAmount.add(entry.getReportingAmount());
            } else {
                disposedCreditLocalAmount = disposedCreditLocalAmount.add(entry.getLocalAmount());
                disposedCreditReportAmount = disposedCreditReportAmount.add(entry.getReportingAmount());
            }
            splitRecordInfo.setCurrency(entry.getCurrency());
            splitRecordInfo.setOpposingAccountEntry(targetEntry);
            splitRecordInfo.setOppAccount(targetEntry.getAccount());
            splitRecordInfo.setOppEntryDC(targetEntry.getEntryDC());
            splitRecordInfo.setVoucher(voucherInfo);
            splitRecordInfo.setLocalAmount(entry.getLocalAmount());
            splitRecordInfo.setReportingAmount(entry.getReportingAmount());
            this.setCashflowAmount(splitRecordInfo, voucherInfo, targetEntry);
            diposeSplitRecordCollection.add(splitRecordInfo);
        }
        BigDecimal restDisposedLocalAmount = disposedCreditLocalAmount.subtract(disposedDebitLocalAmount);
        BigDecimal restDisposedReportAmount = disposedCreditReportAmount.subtract(disposedDebitReportAmount);
        if (restDisposedLocalAmount.signum() != 0) {
            splitRecordInfo = new CashflowSplitRecordInfo();
            splitRecordInfo.setItemFlag(ItemFlag.DISPOSE);
            splitRecordInfo.setVoucher(voucherInfo);
            splitRecordInfo.setEntry(targetEntry);
            splitRecordInfo.setAccount(targetEntry.getAccount());
            splitRecordInfo.setCurrency(targetEntry.getCurrency());
            splitRecordInfo.setEntryDC(targetEntry.getEntryDC());
            for (int i = 0; i < ownEntries.size(); ++i) {
                VoucherEntryInfo oppEntry = ownEntries.get(i);
                if (oppEntry.getLocalAmount().signum() == 0) continue;
                splitRecordInfo.setOppEntryDC(oppEntry.getEntryDC());
                splitRecordInfo.setOpposingAccountEntry(oppEntry);
                splitRecordInfo.setOppAccount(oppEntry.getAccount());
                break;
            }
            if (targetEntry.getEntryDC() == EntryDC.DEBIT) {
                splitRecordInfo.setLocalAmount(restDisposedLocalAmount);
                splitRecordInfo.setReportingAmount(restDisposedReportAmount);
            } else {
                splitRecordInfo.setLocalAmount(restDisposedLocalAmount.negate());
                splitRecordInfo.setReportingAmount(restDisposedReportAmount.negate());
            }
            this.setCashflowAmount(splitRecordInfo, voucherInfo, targetEntry);
            diposeSplitRecordCollection.add(splitRecordInfo);
        }
        return diposeSplitRecordCollection;
    }

    private VoucherEntryCollection[] getOwnAndOppEntries(Context ctx, VoucherInfo voucherInfo, CashflowFlag cashflowFlag) throws EASBizException, BOSException {
        HashSet<String> acctDif = new HashSet<String>();
        Map allDif = VoucherProcessCache.getDifference(ctx, voucherInfo.getCompany().getId().toString());
        CashFlowAccountDiffCollection acctDifCol = (CashFlowAccountDiffCollection)allDif.get("CashFlowAccountDiffCollection");
        if (acctDifCol != null) {
            int size = acctDifCol.size();
            for (int i = 0; i < size; ++i) {
                acctDif.add(acctDifCol.get(i).getDiffAccount().getId().toString());
            }
        }
        VoucherEntryCollection ownEntries = new VoucherEntryCollection();
        VoucherEntryCollection oppEntries = new VoucherEntryCollection();
        VoucherEntryCollection entries = voucherInfo.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            VoucherEntryInfo entry = entries.get(i);
            AccountViewInfo account = entry.getAccount();
            if (account.isBudget()) continue;
            if (CashflowFlag.NONE == cashflowFlag) {
                ownEntries.add(entry);
                continue;
            }
            if (CashflowFlag.ONLY_PNLACCOUNT == cashflowFlag) {
                if (CashFlowUtils.isPL(account, acctDif)) {
                    ownEntries.add(entry);
                    continue;
                }
                oppEntries.add(entry);
                continue;
            }
            if (CashFlowUtils.isCashAccount(account)) {
                ownEntries.add(entry);
                continue;
            }
            oppEntries.add(entry);
        }
        return new VoucherEntryCollection[]{ownEntries, oppEntries};
    }

    private VoucherEntryInfo findTargetEntry(Context ctx, VoucherEntryCollection ownEntries, CashflowFlag cashflowFlag) throws EASBizException, BOSException {
        return CashflowFlag.NONE == cashflowFlag ? ownEntries.get(0) : (CashflowFlag.ONLY_PNLACCOUNT == cashflowFlag ? this.findOnePLEntry(ctx, ownEntries) : this.findOneCashEntry(ownEntries));
    }

    private VoucherEntryInfo findOneCashEntry(VoucherEntryCollection cashEntries) {
        VoucherEntryInfo entry;
        int i;
        BigDecimal totalAmount = GlUtils.zero;
        for (int i2 = 0; i2 < cashEntries.size(); ++i2) {
            VoucherEntryInfo entry2 = cashEntries.get(i2);
            totalAmount = totalAmount.add(entry2.getEntryDC() == EntryDC.DEBIT ? entry2.getLocalAmount() : entry2.getLocalAmount().negate());
        }
        VoucherEntryInfo targetEntry = null;
        boolean isPositive = false;
        if (totalAmount.compareTo(GlUtils.zero) >= 0) {
            isPositive = true;
        }
        for (i = 0; i < cashEntries.size(); ++i) {
            entry = cashEntries.get(i);
            if (isPositive) {
                if (!EntryDC.DEBIT.equals((Object)entry.getEntryDC()) || entry.getLocalAmount().compareTo(GlUtils.zero) < 0) continue;
                targetEntry = entry;
                break;
            }
            if (!EntryDC.CREDIT.equals((Object)entry.getEntryDC()) || entry.getLocalAmount().compareTo(GlUtils.zero) < 0) continue;
            targetEntry = entry;
            break;
        }
        if (targetEntry == null) {
            for (i = 0; i < cashEntries.size(); ++i) {
                entry = cashEntries.get(i);
                if (isPositive) {
                    if (!EntryDC.CREDIT.equals((Object)entry.getEntryDC()) || entry.getLocalAmount().compareTo(GlUtils.zero) >= 0) continue;
                    targetEntry = entry;
                    break;
                }
                if (!EntryDC.DEBIT.equals((Object)entry.getEntryDC()) || entry.getLocalAmount().compareTo(GlUtils.zero) >= 0) continue;
                targetEntry = entry;
                break;
            }
        }
        return targetEntry;
    }

    private VoucherEntryInfo findOnePLEntry(Context ctx, VoucherEntryCollection sunYiEntries) throws EASBizException, BOSException {
        VoucherEntryInfo entry;
        int i;
        BigDecimal totalAmount = GlUtils.zero;
        for (int i2 = 0; i2 < sunYiEntries.size(); ++i2) {
            VoucherEntryInfo entry2 = sunYiEntries.get(i2);
            totalAmount = totalAmount.add(entry2.getEntryDC() == EntryDC.CREDIT ? entry2.getLocalAmount() : entry2.getLocalAmount().negate());
        }
        VoucherEntryInfo targetEntry = null;
        boolean isPositive = false;
        if (totalAmount.compareTo(GlUtils.zero) >= 0) {
            isPositive = true;
        }
        for (i = 0; i < sunYiEntries.size(); ++i) {
            entry = sunYiEntries.get(i);
            if (isPositive) {
                if (!EntryDC.CREDIT.equals((Object)entry.getEntryDC()) || entry.getLocalAmount().compareTo(GlUtils.zero) == 0) continue;
                targetEntry = entry;
                break;
            }
            if (!EntryDC.DEBIT.equals((Object)entry.getEntryDC()) || entry.getLocalAmount().compareTo(GlUtils.zero) == 0) continue;
            targetEntry = entry;
            break;
        }
        if (targetEntry == null) {
            for (i = 0; i < sunYiEntries.size(); ++i) {
                entry = sunYiEntries.get(i);
                if (isPositive) {
                    if (!EntryDC.DEBIT.equals((Object)entry.getEntryDC()) || entry.getLocalAmount().compareTo(GlUtils.zero) == 0) continue;
                    targetEntry = entry;
                    break;
                }
                if (!EntryDC.CREDIT.equals((Object)entry.getEntryDC()) || entry.getLocalAmount().compareTo(GlUtils.zero) == 0) continue;
                targetEntry = entry;
                break;
            }
        }
        return targetEntry;
    }

    private void setCashflowAmount(CashflowSplitRecordInfo splitRecordInfo, VoucherInfo voucher, VoucherEntryInfo targetEntry) {
        BigDecimal originalAmount;
        int scale;
        CurrencyInfo localCur = voucher.getCompany().getBaseCurrency();
        CurrencyInfo reportCur = voucher.getCompany().getReportCurrency();
        int n = scale = targetEntry.getCurrency().getPrecision() > 0 ? targetEntry.getCurrency().getPrecision() : targetEntry.getOriginalAmount().scale();
        if (targetEntry.getCurrency().getId().toString().equals(localCur.getId().toString())) {
            splitRecordInfo.setOriginalAmount(splitRecordInfo.getLocalAmount());
        } else if (targetEntry.getOriginalAmount().signum() != 0 && targetEntry.getLocalAmount().signum() != 0) {
            BigDecimal originalAmount2 = targetEntry.getOriginalAmount().multiply(splitRecordInfo.getLocalAmount()).divide(targetEntry.getLocalAmount(), scale, 4);
            splitRecordInfo.setOriginalAmount(originalAmount2);
        } else if (splitRecordInfo.getOppVoucherAssistRecord() != null && splitRecordInfo.getOppVoucherAssistRecord().getLocalAmount().signum() != 0) {
            VoucherAssistRecordInfo oppVoucherAssistRecord = splitRecordInfo.getOppVoucherAssistRecord();
            originalAmount = oppVoucherAssistRecord.getOriginalAmount().multiply(splitRecordInfo.getLocalAmount()).divide(oppVoucherAssistRecord.getLocalAmount(), scale, 4);
            splitRecordInfo.setOriginalAmount(originalAmount);
        } else {
            VoucherEntryInfo opposingAccountEntry = splitRecordInfo.getOpposingAccountEntry();
            if (opposingAccountEntry.getLocalAmount().signum() != 0) {
                originalAmount = opposingAccountEntry.getOriginalAmount().multiply(splitRecordInfo.getLocalAmount()).divide(opposingAccountEntry.getLocalAmount(), scale, 4);
                splitRecordInfo.setOriginalAmount(originalAmount);
            } else {
                splitRecordInfo.setOriginalAmount(BigDecimal.ZERO);
            }
        }
        if (splitRecordInfo.getReportingAmount() != null) {
            return;
        }
        if (reportCur == null) {
            splitRecordInfo.setReportingAmount(GlUtils.zero);
        } else if (reportCur.getId().toString().equals(localCur.getId().toString())) {
            splitRecordInfo.setReportingAmount(splitRecordInfo.getLocalAmount());
        } else {
            VoucherEntryInfo oppEntry = splitRecordInfo.getOpposingAccountEntry();
            if (oppEntry.getReportingAmount() != null && oppEntry.getLocalAmount().signum() != 0) {
                scale = oppEntry.getReportingAmount().scale() == 0 ? 4 : oppEntry.getReportingAmount().scale();
                BigDecimal reportAmount = oppEntry.getReportingAmount().multiply(splitRecordInfo.getLocalAmount()).divide(oppEntry.getLocalAmount(), scale, 4);
                splitRecordInfo.setReportingAmount(reportAmount);
            } else {
                splitRecordInfo.setReportingAmount(BigDecimal.ZERO);
            }
        }
    }
}

