/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountCategoryEnum;
import com.kingdee.eas.basedata.master.account.AccountPLType;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashflowAttachedListInfo;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowQueryParam;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowSplitRecordCollection;
import com.kingdee.eas.fi.gl.CashflowSplitRecordFactory;
import com.kingdee.eas.fi.gl.CashflowSplitRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.CashFlowAttachedListSQLFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CashFlowAttachedListDao {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.CashFlowAttachedListDao");
    private static final int VOUCHER_NUM = 100;
    private static final int NUM_LIMIT = 10000;
    private Context ctx;
    private CashflowQueryParam condition;

    public CashFlowAttachedListDao(Context ctx, CashflowQueryParam condition) {
        this.ctx = ctx;
        this.condition = condition;
    }

    protected VoucherCollection getVoucherCollection(List idList) throws BOSException {
        VoucherCollection i2;
        if (idList == null || idList.isEmpty()) {
            return null;
        }
        List segment = idList;
        if (idList.size() > 100) {
            segment = idList.subList(0, 100);
        }
        String sql = CashFlowAttachedListSQLFactory.getVoucherQuerySQL(segment.size());
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            for (int i2 = 0; i2 < segment.size(); ++i2) {
                ps.setObject(i2 + 1, segment.get(i2));
            }
            rs = ps.executeQuery();
            i2 = this.toVoucherCollection(idList, rs);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"sql error!", (Throwable)e);
                throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return i2;
    }

    protected VoucherInfo getVoucherInfo(String voucherId) throws BOSException {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block4: {
            VoucherInfo voucherInfo;
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(voucherId);
            String sql = CashFlowAttachedListSQLFactory.getVoucherQuerySQL(1);
            conn = null;
            ps = null;
            rs = null;
            try {
                conn = this.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setObject(1, voucherId);
                rs = ps.executeQuery();
                VoucherCollection voucherColl = this.toVoucherCollection(idList, rs);
                if (voucherColl.size() <= 0) break block4;
                voucherInfo = voucherColl.get(0);
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"sql error!", (Throwable)e);
                    throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
            return voucherInfo;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return null;
    }

    protected List getNoSplitPLVoucherIdSet() throws BOSException {
        ArrayList<String> arrayList;
        ArrayList sp = new ArrayList();
        String sql = CashFlowAttachedListSQLFactory.getNoSplitPLVoucherSQL(this.condition, sp);
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < sp.size(); ++i) {
                ps.setObject(i + 1, sp.get(i));
            }
            rs = ps.executeQuery();
            ArrayList<String> idList = new ArrayList<String>();
            while (rs.next()) {
                idList.add(rs.getString("fid"));
            }
            arrayList = idList;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"sql error!", (Throwable)e);
                throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return arrayList;
    }

    protected void applyCashflowItem(CashflowAttachedListInfo info, CashFlowItemInfo cfItem) throws BOSException, EASBizException {
        boolean notAllowModify = this.notModifyAfterAudit();
        this.applyApplySuppItemToCFRec(info, cfItem, notAllowModify);
        this.applyAppliySuppItemToSplitRec(info, cfItem, notAllowModify);
    }

    protected void removeCashflowItem(CashflowAttachedListInfo info) throws BOSException, EASBizException {
        boolean notAllowModify = this.notModifyAfterAudit();
        this.cancelSuppItemFromCFRec(info, notAllowModify);
        this.cancelSuppItemToSplitRec(info, notAllowModify);
    }

    protected List getVoucherIdList(CashflowAttachedListInfo info) throws BOSException, EASBizException {
        ArrayList sp = new ArrayList();
        String sql = CashFlowAttachedListSQLFactory.getVoucherIdListSQL(this.condition, info, sp);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])sp.toArray());
        ArrayList<String> idList = new ArrayList<String>();
        try {
            while (rs.next()) {
                idList.add(rs.getString("fvoucherid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return idList;
    }

    protected List getSumAll(CashflowAttachedListInfo parent) throws BOSException, EASBizException {
        ArrayList sp = new ArrayList();
        String sql = CashFlowAttachedListSQLFactory.getSumAllSQL(this.condition, parent, sp);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])sp.toArray());
        CashflowAttachedListInfo atInfo = new CashflowAttachedListInfo();
        try {
            if (rs.next()) {
                atInfo.setType(0);
                atInfo.setAmount(rs.getBigDecimal("amount"));
                atInfo.setRootName(EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI", (String)"AllAccount", (Locale)this.ctx.getOriginLocale()));
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        ArrayList<CashflowAttachedListInfo> result = new ArrayList<CashflowAttachedListInfo>();
        result.add(atInfo);
        return result;
    }

    protected List getSumChildrenAccount(CashflowAttachedListInfo parent) throws BOSException, EASBizException {
        ArrayList sp = new ArrayList();
        String sql = CashFlowAttachedListSQLFactory.getSumChildrenAccountSQL(this.condition, parent, sp, this.ctx.getLocale().toString());
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])sp.toArray());
        ArrayList<CashflowAttachedListInfo> result = new ArrayList<CashflowAttachedListInfo>();
        try {
            while (rs.next()) {
                result.add(this.createOppAccountExtendInfo(parent, rs));
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return result;
    }

    protected List getSumOppAccount(CashflowAttachedListInfo parent) throws BOSException, EASBizException {
        ArrayList sp = new ArrayList();
        String sql = CashFlowAttachedListSQLFactory.getSumOppAccountSQL(this.condition, parent, sp, this.ctx.getLocale().toString());
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])sp.toArray());
        ArrayList<CashflowAttachedListInfo> result = new ArrayList<CashflowAttachedListInfo>();
        try {
            while (rs.next()) {
                result.add(this.createChildAccountExtendInfo(parent, rs));
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return result;
    }

    protected List getSumSuppItem(CashflowAttachedListInfo parent) throws BOSException, EASBizException {
        ArrayList sp = new ArrayList();
        String sql = CashFlowAttachedListSQLFactory.getSumSuppItemSQL(this.condition, parent, sp, this.ctx.getLocale().toString());
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])sp.toArray());
        ArrayList<CashflowAttachedListInfo> result = new ArrayList<CashflowAttachedListInfo>();
        try {
            CashflowAttachedListInfo notCFInfo = null;
            CashflowAttachedListInfo info = null;
            while (rs.next()) {
                info = this.createAttachedListExtendInfo(parent, rs);
                if (info.getCfItem() == null) {
                    notCFInfo = info;
                    continue;
                }
                result.add(info);
            }
            if (notCFInfo != null) {
                result.add(notCFInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return result;
    }

    protected void applyDefaultCashflowItem(boolean isCover) throws BOSException, EASBizException {
        boolean notAllowModify = this.notModifyAfterAudit();
        this.applyDefCFItemToCFRecord(isCover, notAllowModify);
        this.applyDefCFItemToCFSplitRecord(isCover, notAllowModify);
    }

    private void applyDefCFItemToCFRecord(boolean isCover, boolean notAllowModify) throws BOSException {
        ArrayList sp = new ArrayList();
        String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        String sql = CashFlowAttachedListSQLFactory.applyDefCFItemToCFRecordSQL(this.condition, isCover, sp, userId, notAllowModify);
        DbUtil.execute((Context)this.ctx, (String)sql, (Object[])sp.toArray());
    }

    private void applyDefCFItemToCFSplitRecord(boolean isCover, boolean notAllowModify) throws BOSException {
        String tmpTableName = null;
        try {
            tmpTableName = TempTablePool.getInstance((Context)this.ctx).createTempTable("create table T_GL_applyDefCashflowItem (fvoucherid VARCHAR(44))");
            ArrayList sp = new ArrayList();
            String sql = CashFlowAttachedListSQLFactory.insertSplitRecToTemptableSQL(this.condition, sp, tmpTableName, notAllowModify);
            DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])sp.toArray());
            sp = new ArrayList();
            String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
            String cuId = ContextUtil.getCurrentCtrlUnit((Context)this.ctx).getId().toString();
            sql = CashFlowAttachedListSQLFactory.applyDefCFItemToCFSplitRecordSQL(this.condition, isCover, sp, tmpTableName, userId, cuId);
            DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])sp.toArray());
            DbUtil.execute((Context)this.ctx, (String)CashFlowAttachedListSQLFactory.deleteCashflowsplitrecordSQL(tmpTableName));
        }
        catch (Exception e) {
            throw new BOSException("Apply Default CashflowItem error!", (Throwable)e);
        }
        finally {
            if (tmpTableName != null) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(tmpTableName);
            }
        }
    }

    private void applyApplySuppItemToCFRec(CashflowAttachedListInfo info, CashFlowItemInfo cfItem, boolean notAllowModify) throws BOSException {
        ArrayList sp = new ArrayList();
        String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        String sql = CashFlowAttachedListSQLFactory.getApplySuppItemToCFRecSQL(this.condition, info, cfItem, userId, sp, notAllowModify);
        DbUtil.execute((Context)this.ctx, (String)sql, (Object[])sp.toArray());
    }

    private void applyAppliySuppItemToSplitRec(CashflowAttachedListInfo info, CashFlowItemInfo cfItem, boolean notAllowModify) throws BOSException, EASBizException {
        String tempTable;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block14: {
            HashSet<String> idSet;
            String sql;
            block13: {
                ArrayList sp = new ArrayList();
                sql = CashFlowAttachedListSQLFactory.getSuppItemSplitRecSQL(this.condition, info, sp, notAllowModify);
                conn = null;
                ps = null;
                rs = null;
                tempTable = "";
                conn = this.getConnection();
                ps = conn.prepareStatement(sql);
                for (int i = 0; i < sp.size(); ++i) {
                    ps.setObject(i + 1, sp.get(i));
                }
                rs = ps.executeQuery();
                idSet = new HashSet<String>();
                while (rs.next()) {
                    idSet.add(rs.getString("fid"));
                }
                if (idSet.size() != 0) break block13;
                if (!StringUtils.isEmpty((String)tempTable)) {
                    TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
                return;
            }
            try {
                FilterInfo filter = new FilterInfo();
                if (idSet.size() <= 5000) {
                    filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                } else {
                    String createTableSql = "create table gl_temp_table (id varchar(44))";
                    ArrayList<String[]> paramsList = new ArrayList<String[]>();
                    tempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(createTableSql);
                    for (String id : idSet) {
                        paramsList.add(new String[]{id});
                    }
                    String insertSql = "insert into " + tempTable + " values(?)";
                    DbUtil.executeBatch((Context)this.ctx, (String)insertSql, paramsList);
                    filter.getFilterItems().add(new FilterItemInfo("id in (select id from " + tempTable + ")"));
                }
                CashflowSplitRecordCollection splitColl = this.getCashflowSplitRecordCollection(filter);
                if (splitColl == null) break block14;
                CashflowRecordCollection records = this.toCashflowCollection(splitColl, cfItem);
                CashflowRecordFactory.getLocalInstance(this.ctx).addNewBatch(records);
                CashflowSplitRecordFactory.getLocalInstance(this.ctx).delete(filter);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"sql error!", (Throwable)e);
                    throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (!StringUtils.isEmpty((String)tempTable)) {
                        TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
                    }
                    SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                    throw throwable;
                }
            }
        }
        if (!StringUtils.isEmpty((String)tempTable)) {
            TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
    }

    private void cancelSuppItemFromCFRec(CashflowAttachedListInfo info, boolean notAllowModify) throws BOSException, EASBizException {
        ArrayList sp = new ArrayList();
        String sql = CashFlowAttachedListSQLFactory.getCancelSuppItemFromCFRecSQL(this.condition, info, sp, notAllowModify);
        DbUtil.execute((Context)this.ctx, (String)sql, (Object[])sp.toArray());
    }

    private void cancelSuppItemToSplitRec(CashflowAttachedListInfo info, boolean notAllowModify) throws BOSException, EASBizException {
        ArrayList sp = new ArrayList();
        String sql = CashFlowAttachedListSQLFactory.getSuppItemCFRecSQL(this.condition, info, sp, notAllowModify);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])sp.toArray());
        String tempTable = "";
        try {
            HashSet<String> idSet = new HashSet<String>();
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
            }
            if (idSet.size() == 0) {
                return;
            }
            FilterInfo filter = new FilterInfo();
            if (idSet.size() <= 5000) {
                filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            } else {
                String createTableSql = "create table gl_temp_table (id varchar(44))";
                ArrayList<String[]> paramsList = new ArrayList<String[]>();
                tempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(createTableSql);
                for (String id : idSet) {
                    paramsList.add(new String[]{id});
                }
                String insertSql = "insert into " + tempTable + " values(?)";
                DbUtil.executeBatch((Context)this.ctx, (String)insertSql, paramsList);
                filter.getFilterItems().add(new FilterItemInfo("id in (select id from " + tempTable + ")"));
            }
            CashflowRecordCollection recordColl = this.getCashflowRecordCollection(filter);
            if (recordColl != null) {
                CashflowSplitRecordCollection splitColl = this.toCashflowSplitCollection(recordColl);
                CashflowSplitRecordFactory.getLocalInstance(this.ctx).addBatch((IObjectCollection)splitColl);
                CashflowRecordFactory.getLocalInstance(this.ctx).delete(filter);
            }
        }
        catch (Exception e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        finally {
            if (!StringUtils.isEmpty((String)tempTable)) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
            }
        }
    }

    private FilterInfo getIDFilter(ResultSet rs) throws SQLException {
        FilterInfo filter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        while (rs.next()) {
            idSet.add(rs.getString("fid"));
        }
        if (idSet.size() == 0) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        return filter;
    }

    private CashflowRecordCollection getCashflowRecordCollection(FilterInfo filter) throws BOSException {
        if (filter == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("isSupItem"));
        view.getSelector().add(new SelectorItemInfo("supplementaryCoefficient"));
        view.getSelector().add(new SelectorItemInfo("voucher.id"));
        view.getSelector().add(new SelectorItemInfo("entry.id"));
        view.getSelector().add(new SelectorItemInfo("account.id"));
        view.getSelector().add(new SelectorItemInfo("currency.id"));
        view.getSelector().add(new SelectorItemInfo("entryDC"));
        view.getSelector().add(new SelectorItemInfo("opposingAccountEntry.id"));
        view.getSelector().add(new SelectorItemInfo("oppAccount.id"));
        view.getSelector().add(new SelectorItemInfo("oppEntryDC"));
        view.getSelector().add(new SelectorItemInfo("originalAmount"));
        view.getSelector().add(new SelectorItemInfo("localAmount"));
        view.getSelector().add(new SelectorItemInfo("reportingAmount"));
        view.setFilter(filter);
        return CashflowRecordFactory.getLocalInstance(this.ctx).getCashflowRecordCollection(view);
    }

    private CashflowSplitRecordCollection getCashflowSplitRecordCollection(FilterInfo filter) throws BOSException {
        if (filter == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("isSupItem"));
        view.getSelector().add(new SelectorItemInfo("voucher.id"));
        view.getSelector().add(new SelectorItemInfo("entry.id"));
        view.getSelector().add(new SelectorItemInfo("account.id"));
        view.getSelector().add(new SelectorItemInfo("currency.id"));
        view.getSelector().add(new SelectorItemInfo("entryDC"));
        view.getSelector().add(new SelectorItemInfo("opposingAccountEntry.id"));
        view.getSelector().add(new SelectorItemInfo("opposingAccountEntry.seq"));
        view.getSelector().add(new SelectorItemInfo("oppAccount.id"));
        view.getSelector().add(new SelectorItemInfo("oppEntryDC"));
        view.getSelector().add(new SelectorItemInfo("originalAmount"));
        view.getSelector().add(new SelectorItemInfo("localAmount"));
        view.getSelector().add(new SelectorItemInfo("reportingAmount"));
        view.setFilter(filter);
        return CashflowSplitRecordFactory.getLocalInstance(this.ctx).getCashflowSplitRecordCollection(view);
    }

    private VoucherCollection toVoucherCollection(List idList, ResultSet rs) throws BOSException {
        VoucherCollection voucherColl = new VoucherCollection();
        VoucherInfo voucher = null;
        int index = 0;
        try {
            while (rs.next()) {
                if (voucher == null || !voucher.getId().toString().equals(rs.getString("fid"))) {
                    if (index >= 10000) break;
                    voucher = this.toVoucherInfo(rs);
                    idList.remove(voucher.getId().toString());
                    voucherColl.add(voucher);
                }
                VoucherEntryInfo ve = this.toVoucherEntryInfo(rs);
                ve.setBill(voucher);
                voucher.getEntries().add(ve);
                ++index;
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return voucherColl;
    }

    private VoucherEntryInfo toVoucherEntryInfo(ResultSet rs) throws SQLException {
        VoucherEntryInfo ve = new VoucherEntryInfo();
        ve.setId(BOSUuid.read((String)rs.getString("veid")));
        ve.setSeq(rs.getInt("fseq"));
        ve.setOriginalAmount(rs.getBigDecimal("foriginalAmount"));
        ve.setLocalAmount(rs.getBigDecimal("flocalAmount"));
        ve.setReportingAmount(rs.getBigDecimal("freportingAmount"));
        ve.setEntryDC(EntryDC.getEnum((int)rs.getInt("fentryDC")));
        ve.setAccount(this.toAccountViewInfo(rs));
        ve.setCurrency(this.toCurrencyInfo(rs));
        ve.setLocalExchangeRate(rs.getBigDecimal("flocalExchangeRate"));
        return ve;
    }

    private CurrencyInfo toCurrencyInfo(ResultSet rs) throws SQLException {
        CurrencyInfo cy = new CurrencyInfo();
        cy.setId(BOSUuid.read((String)rs.getString("fcurrencyid")));
        return cy;
    }

    private AccountViewInfo toAccountViewInfo(ResultSet rs) throws SQLException {
        AccountViewInfo av = new AccountViewInfo();
        av.setId(BOSUuid.read((String)rs.getString("avid")));
        av.setIsCash(rs.getInt("fisCash") == 1);
        av.setIsBank(rs.getInt("fisBank") == 1);
        av.setIsCashEquivalent(rs.getInt("fisCashEquivalent") == 1);
        av.setPLType(AccountPLType.getEnum((int)rs.getInt("fPLType")));
        av.setCategory(AccountCategoryEnum.getEnum((int)rs.getInt("FCategory")));
        return av;
    }

    private VoucherInfo toVoucherInfo(ResultSet rs) throws SQLException {
        VoucherInfo voucher = new VoucherInfo();
        voucher.setId(BOSUuid.read((String)rs.getString("fid")));
        voucher.setNumber(rs.getString("fnumber"));
        voucher.setEntryCount(rs.getInt("fentrycount"));
        voucher.setSourceType(SourceType.getEnum((int)rs.getInt("fsourceType")));
        voucher.setCashflowFlag(CashflowFlag.getEnum((int)rs.getInt("fcashflowFlag")));
        voucher.setHasCashAccount(rs.getInt("fhasCashAccount") == 1);
        voucher.setLastUpdateTime(rs.getTimestamp("flastupdatetime"));
        voucher.setEntries((AbstractObjectCollection)new VoucherEntryCollection());
        voucher.setCompany(this.toCompanyInfo(rs));
        return voucher;
    }

    private CompanyOrgUnitInfo toCompanyInfo(ResultSet rs) throws SQLException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)rs.getString("fcompanyid")));
        return company;
    }

    private CashflowRecordCollection toCashflowCollection(CashflowSplitRecordCollection splitColl, CashFlowItemInfo cfItem) {
        CashflowRecordCollection coll = new CashflowRecordCollection();
        Iterator it = splitColl.iterator();
        CashflowSplitRecordInfo splitInfo = null;
        CashflowRecordInfo record = null;
        while (it.hasNext()) {
            splitInfo = (CashflowSplitRecordInfo)it.next();
            record = new CashflowRecordInfo();
            record.setVoucher(splitInfo.getVoucher());
            record.setEntry(splitInfo.getEntry());
            record.setAccount(splitInfo.getAccount());
            record.setCurrency(splitInfo.getCurrency());
            record.setEntryDC(splitInfo.getEntryDC());
            record.setOpposingAccountEntry(splitInfo.getOpposingAccountEntry());
            record.setOppAccount(splitInfo.getOppAccount());
            record.setOppEntryDC(splitInfo.getOppEntryDC());
            record.setOriginalAmount(splitInfo.getOriginalAmount());
            record.setLocalAmount(splitInfo.getLocalAmount());
            record.setReportingAmount(splitInfo.getReportingAmount());
            record.setPrimaryCoefficient(0);
            record.setSeq(splitInfo.getOpposingAccountEntry().getSeq());
            record.setSupplementaryItem(cfItem);
            record.setSupplementaryCoefficient(splitInfo.getOppEntryDC() == EntryDC.DEBIT ? -1 : 1);
            if (splitInfo.getEntryDC().equals((Object)splitInfo.getOppEntryDC())) {
                record.setSupplementaryCoefficient(record.getSupplementaryCoefficient() * -1);
            }
            record.setItemFlag(ItemFlag.SUPPLEMENTARY);
            record.setIsSupItem(splitInfo.isIsSupItem());
            Timestamp nowTime = new Timestamp(System.currentTimeMillis());
            record.setCreator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
            record.setCreateTime(nowTime);
            record.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)this.ctx));
            record.setLastUpdateTime(nowTime);
            coll.add(record);
        }
        return coll;
    }

    private CashflowSplitRecordCollection toCashflowSplitCollection(CashflowRecordCollection recordColl) {
        if (recordColl == null) {
            return null;
        }
        CashflowSplitRecordCollection coll = new CashflowSplitRecordCollection();
        Iterator it = recordColl.iterator();
        CashflowRecordInfo record = null;
        CashflowSplitRecordInfo splitInfo = null;
        while (it.hasNext()) {
            record = (CashflowRecordInfo)it.next();
            splitInfo = new CashflowSplitRecordInfo();
            splitInfo.setVoucher(record.getVoucher());
            splitInfo.setEntry(record.getEntry());
            splitInfo.setAccount(record.getAccount());
            splitInfo.setCurrency(record.getCurrency());
            splitInfo.setEntryDC(record.getEntryDC());
            splitInfo.setOpposingAccountEntry(record.getOpposingAccountEntry());
            splitInfo.setOppAccount(record.getOppAccount());
            splitInfo.setOppEntryDC(record.getOppEntryDC());
            splitInfo.setOriginalAmount(record.getOriginalAmount());
            splitInfo.setLocalAmount(record.getLocalAmount());
            splitInfo.setReportingAmount(record.getReportingAmount());
            splitInfo.setItemFlag(ItemFlag.SUPPLEMENTARY);
            splitInfo.setIsSupItem(record.isIsSupItem());
            Timestamp nowTime = new Timestamp(System.currentTimeMillis());
            splitInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
            splitInfo.setCreateTime(nowTime);
            splitInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)this.ctx));
            splitInfo.setLastUpdateTime(nowTime);
            coll.add(splitInfo);
        }
        return coll;
    }

    private CashflowAttachedListInfo createOppAccountExtendInfo(CashflowAttachedListInfo parent, IRowSet rs) throws SQLException {
        CashflowAttachedListInfo atInfo = new CashflowAttachedListInfo();
        AccountViewInfo account = new AccountViewInfo();
        account.setId(BOSUuid.read((String)rs.getString("fid")));
        account.setName(rs.getString("fname"));
        account.setLongName(rs.getString("flongname"));
        account.setNumber(rs.getString("fnumber"));
        account.setLevel(rs.getInt("flevel"));
        account.setIsLeaf(rs.getInt("fisleaf") == 1);
        atInfo.setAccount(account);
        if (parent != null) {
            atInfo.setOppAccount(parent.getOppAccount());
            atInfo.setCfItem(parent.getCfItem());
        }
        atInfo.setType(1);
        atInfo.setLastExtendOppAccount(false);
        atInfo.setAmount(rs.getBigDecimal("amount"));
        return atInfo;
    }

    private CashflowAttachedListInfo createChildAccountExtendInfo(CashflowAttachedListInfo parent, IRowSet rs) throws SQLException {
        CashflowAttachedListInfo atInfo = new CashflowAttachedListInfo();
        AccountViewInfo oppAccount = new AccountViewInfo();
        oppAccount.setId(BOSUuid.read((String)rs.getString("fid")));
        oppAccount.setName(rs.getString("fname"));
        oppAccount.setLongName(rs.getString("flongname"));
        oppAccount.setNumber(rs.getString("fnumber"));
        oppAccount.setLevel(rs.getInt("flevel"));
        oppAccount.setIsLeaf(rs.getInt("fisleaf") == 1);
        atInfo.setOppAccount(oppAccount);
        if (parent != null) {
            atInfo.setAccount(parent.getAccount());
            atInfo.setCfItem(parent.getCfItem());
        }
        atInfo.setType(2);
        atInfo.setLastExtendOppAccount(true);
        atInfo.setAmount(rs.getBigDecimal("amount"));
        return atInfo;
    }

    private CashflowAttachedListInfo createAttachedListExtendInfo(CashflowAttachedListInfo parent, IRowSet rs) throws SQLException {
        CashflowAttachedListInfo atInfo = new CashflowAttachedListInfo();
        CashFlowItemInfo cfItem = new CashFlowItemInfo();
        if (rs.getString("fid") != null) {
            cfItem.setId(BOSUuid.read((String)rs.getString("fid")));
            cfItem.setNumber(rs.getString("fnumber"));
            cfItem.setName(rs.getString("fname"));
        }
        atInfo.setCfItem(cfItem);
        if (parent != null) {
            atInfo.setAccount(parent.getAccount());
            atInfo.setOppAccount(parent.getOppAccount());
        }
        atInfo.setType(3);
        if (cfItem.getName() == null) {
            cfItem.setName(EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI", (String)"NotDealCashflow", (Locale)this.ctx.getOriginLocale()));
        }
        atInfo.setLastExtendOppAccount(parent.isLastExtendOppAccount());
        atInfo.setAmount(rs.getBigDecimal("amount"));
        return atInfo;
    }

    protected void setVoucherSplited(String voucherId) throws BOSException {
        DbUtil.execute((Context)this.ctx, (String)"update t_gl_voucher set fplsplited = 1,flastupdatetime = ? where fid = ? ", (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), voucherId});
    }

    protected boolean isUpdated(String voucherId, Timestamp lastUpdateTime) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)"select flastupdatetime from t_gl_voucher where fid = ? ", (Object[])new Object[]{voucherId});
        try {
            return !rs.next() || !lastUpdateTime.equals(rs.getTimestamp("flastupdatetime"));
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
    }

    private boolean notModifyAfterAudit() throws BOSException, EASBizException {
        Object obj = GlUtils.getParamByKey(this.ctx, ContextUtil.getCurrentFIUnit((Context)this.ctx).getId().toString(), "GL_014");
        boolean notAllowModify = false;
        if (obj != null) {
            notAllowModify = Integer.parseInt(obj.toString()) == 1;
        }
        return notAllowModify;
    }

    private Connection getConnection() throws BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        return conn;
    }
}

