/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemCollection;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CFRequisitionFactory;
import com.kingdee.eas.fi.gl.CashFlowException;
import com.kingdee.eas.fi.gl.CashFlowUtils;
import com.kingdee.eas.fi.gl.CashflowQueryParam;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowSplitRecordCollection;
import com.kingdee.eas.fi.gl.CashflowSplitRecordFactory;
import com.kingdee.eas.fi.gl.CashflowSplitRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICFRequisition;
import com.kingdee.eas.fi.gl.ICashflowRecord;
import com.kingdee.eas.fi.gl.ICashflowSplitRecord;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.TAccountCashflowInfo;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.AbstractCashFlowDirectControllerBean;
import com.kingdee.eas.fi.gl.app.ITAccountSplitStrategy;
import com.kingdee.eas.fi.gl.app.TAccountSplitStrategyFactory;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CashFlowDirectControllerBean
extends AbstractCashFlowDirectControllerBean {
    private static final long serialVersionUID = -3925251335925840841L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.CashFlowDirectControllerBean");

    @Override
    protected IObjectCollection _getVoucher(Context ctx, CashflowQueryParam param) throws BOSException, EASBizException {
        throw new BOSException("Method getVoucher is not supported");
    }

    @Override
    protected Map _fetchInitData(Context ctx, Map initParam) throws BOSException, EASBizException {
        HashMap<String, Object> initData = new HashMap<String, Object>();
        SelectorItemCollection sicCompany = new SelectorItemCollection();
        sicCompany.add(new SelectorItemInfo("baseCurrency.precision"));
        sicCompany.add(new SelectorItemInfo("reportCurrency.precision"));
        sicCompany.add(new SelectorItemInfo("accountTable.id"));
        sicCompany.add(new SelectorItemInfo("number"));
        CompanyOrgUnitInfo company = GlUtils.getCurrentCompany(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), sicCompany, false);
        SelectorItemCollection sicAccount = new SelectorItemCollection();
        sicAccount.add(new SelectorItemInfo("number"));
        sicAccount.add(new SelectorItemInfo("name"));
        sicAccount.add(new SelectorItemInfo("longNumber"));
        sicAccount.add(new SelectorItemInfo("longName"));
        sicAccount.add(new SelectorItemInfo("level"));
        sicAccount.add(new SelectorItemInfo("isCash"));
        sicAccount.add(new SelectorItemInfo("isBank"));
        sicAccount.add(new SelectorItemInfo("isCashEquivalent"));
        String acctTableID = this.getAccountTableId(ctx, company, (Integer)initParam.get("EndYear"), (Integer)initParam.get("EndPeriod"));
        Map accounts = this.queryAccountByCompany(ctx, company, sicAccount, acctTableID);
        initData.put("account", accounts);
        ObjectUuidPK comPK = new ObjectUuidPK(company.getId());
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        hmParamIn.put("GL_014", comPK);
        hmParamIn.put("GL_070", comPK);
        hmParamIn.put("GL_0152", comPK);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        Object obj = hmAllParam.get("GL_014");
        boolean notAllowModify = false;
        if (obj != null) {
            notAllowModify = Integer.parseInt(obj.toString()) == 1;
        }
        initData.put("GL_014", notAllowModify);
        obj = hmAllParam.get("GL_070");
        if (obj != null) {
            initData.put("GL_070", Boolean.valueOf(obj.toString()));
        } else {
            initData.put("GL_070", Boolean.FALSE);
        }
        if (hmAllParam.get("GL_0152") != null) {
            initData.put("GL_0152", Integer.valueOf(hmAllParam.get("GL_0152").toString()));
        } else {
            initData.put("GL_0152", "1");
        }
        SelectorItemCollection sicCFI = new SelectorItemCollection();
        sicCFI.add(new SelectorItemInfo("number"));
        sicCFI.add(new SelectorItemInfo("name"));
        sicCFI.add(new SelectorItemInfo("longNumber"));
        sicCFI.add(new SelectorItemInfo("direction"));
        Map cfItems = this.queryCashflowItem(ctx, sicCFI);
        initData.put("cfItems", cfItems);
        return initData;
    }

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        RptParams rp = new RptParams();
        rp.setObject("getAllCurrency", (Object)RptServerUtil.getAllCurrency(company.getId().toString(), ctx));
        company.setDescription(null);
        rp.setObject("pe", (Object)new PeriodEntity(RptServerUtil.getPeriodRange(ctx, company)));
        rp.setObject("currentPeriod", (Object)this.getCurrentPeriodInfo(ctx, company));
        return rp;
    }

    protected PeriodInfo getCurrentPeriodInfo(Context ctx, CompanyOrgUnitInfo company) throws BOSException, ReportBizException, EASBizException {
        PeriodInfo currentPeriod = null;
        ISystemStatusCtrol ictrol = null;
        ictrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.GENERALLEDGER.getValue())));
        fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("currentPeriod.id"));
        sic.add(new SelectorItemInfo("currentPeriod.type.id"));
        sic.add(new SelectorItemInfo("currentPeriod.periodYear"));
        sic.add(new SelectorItemInfo("currentPeriod.periodNumber"));
        sic.add(new SelectorItemInfo("currentPeriod.beginDate"));
        sic.add(new SelectorItemInfo("currentPeriod.endDate"));
        SystemStatusCtrolCollection col = ictrol.getSystemStatusCtrolCollection(view);
        currentPeriod = col.size() > 0 ? col.get(0).getCurrentPeriod() : null;
        return currentPeriod;
    }

    @Override
    protected Map _getTAccountMap(Context ctx, CashflowQueryParam param) throws BOSException, EASBizException {
        Set searchResult = this.searchUnsplitVoucher(ctx, param);
        if (searchResult.size() > 0) {
            this.updateFinishedVoucher(ctx, param);
            Set unFinished = this.queryUnfinishAssignVoucher(ctx, param);
            this.deleteCashflowRecordOfUnFinishedVoucher(ctx, param, unFinished);
            this.deleteCashflowSplitRecordOfUnFinishedVoucher(ctx, param, unFinished);
            this.splitUnfinishedVoucher(ctx, unFinished);
        }
        SelectorItemCollection sicCompany = new SelectorItemCollection();
        sicCompany.add(new SelectorItemInfo("baseCurrency.precision"));
        sicCompany.add(new SelectorItemInfo("reportCurrency.precision"));
        sicCompany.add(new SelectorItemInfo("accountTable.id"));
        sicCompany.add(new SelectorItemInfo("number"));
        CompanyOrgUnitInfo company = GlUtils.getCurrentCompany(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), sicCompany, false);
        SelectorItemCollection sicAccount = new SelectorItemCollection();
        sicAccount.add(new SelectorItemInfo("number"));
        sicAccount.add(new SelectorItemInfo("name"));
        sicAccount.add(new SelectorItemInfo("level"));
        sicAccount.add(new SelectorItemInfo("isCash"));
        sicAccount.add(new SelectorItemInfo("isBank"));
        sicAccount.add(new SelectorItemInfo("isCashEquivalent"));
        String acctTableID = this.getAccountTableId(ctx, company, new Integer(param.getEndYear()), new Integer(param.getEndPeriod()));
        Map accounts = this.queryAccountByCompany(ctx, company, sicAccount, acctTableID);
        return this.createDataModel(ctx, accounts, param, acctTableID);
    }

    private Map queryAccountByCompany(Context ctx, CompanyOrgUnitInfo company, SelectorItemCollection sic, String accountTableID) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableID));
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        filter.setMaskString("#0 and #1");
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        view.setFilter(filter);
        AccountViewCollection accountCol = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        AccountViewInfo account = null;
        HashMap<String, AccountViewInfo> accountMap = new HashMap<String, AccountViewInfo>();
        for (int i = 0; i < accountCol.size(); ++i) {
            account = accountCol.get(i);
            accountMap.put(account.getNumber(), account);
        }
        return accountMap;
    }

    private Map queryCashflowItem(Context ctx, SelectorItemCollection sic) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        CashFlowItemCollection items = CashFlowItemFactory.getLocalInstance((Context)ctx).getCashFlowItemCollection(view);
        CashFlowItemInfo item = null;
        HashMap<String, CashFlowItemInfo> itemsMap = new HashMap<String, CashFlowItemInfo>();
        for (int i = 0; i < items.size(); ++i) {
            item = items.get(i);
            itemsMap.put(item.getId().toString(), item);
        }
        return itemsMap;
    }

    private Map createDataModel(Context ctx, Map accounts, CashflowQueryParam param, String acctTableID) throws BOSException {
        HashMap result = new HashMap();
        int amountSource = 1;
        amountSource = param.getCurrency().getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC") ? 2 : (param.getCurrency().getId().toString().equals("22222222-2222-2222-2222-222222222222DEB58FDC") ? 3 : 1);
        ArrayList sqlParams = new ArrayList();
        String selectSQL = this.getQueryCashflowRecordSQL(ctx, param, sqlParams, acctTableID);
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(selectSQL);
            int size = sqlParams.size();
            for (int i = 0; i < size; ++i) {
                ps.setObject(i + 1, sqlParams.get(i));
            }
            rs = ps.executeQuery();
            AccountViewInfo oav = null;
            TAccountCashflowInfo info = null;
            ArrayList<TAccountCashflowInfo> records = new ArrayList<TAccountCashflowInfo>();
            while (rs.next()) {
                info = new TAccountCashflowInfo();
                info.setId(rs.getString("fcfid"));
                info.setVoucherId(rs.getString("fvoucherid"));
                info.setItemFlag(rs.getInt("fitemflag"));
                info.setOriginalAmount(rs.getBigDecimal("foriginalamount"));
                info.setLocalAmount(rs.getBigDecimal("flocalamount"));
                info.setReportingAmount(rs.getBigDecimal("freportingamount"));
                if (amountSource == 1) {
                    info.setAmount(info.getOriginalAmount());
                } else if (amountSource == 2) {
                    info.setAmount(info.getLocalAmount());
                } else {
                    info.setAmount(info.getReportingAmount());
                }
                info.setEntryId(rs.getString("fsveid"));
                info.setEntryAccountNumber(rs.getString("fsavnumber"));
                info.setOpposingEntryId(rs.getString("foveid"));
                info.setOpposingEntryAccountNumber(rs.getString("foavnumber"));
                info.setOpposingEntryDescription(rs.getString("fovedescription"));
                info.setOpposingEntrySeq(rs.getInt("foveseq"));
                info.setOpposingEntryAssitRecordId(rs.getString("fovastid"));
                info.setOpposingEntryDebit(rs.getInt("fovedc") == 1);
                info.setEntryDebit(rs.getInt("fsvedc") == 1);
                info.setEntryAccountCash(true);
                oav = (AccountViewInfo)accounts.get(rs.getString("foavnumber"));
                info.setOpposingEntryAccountCash(CashFlowUtils.isCashAccount(oav));
                info.setDirection(rs.getInt("fcfidirection") == 1 ? CashFlowDirection.IN : CashFlowDirection.OUT);
                info.setCashflowItemId(rs.getString("fcfiid"));
                info.setCfiAssistId(rs.getString("fcfiassistid"));
                info.setCfiAssistDisplayNameGroup(rs.getString("fcfiassistdisplayname"));
                info.setAccountAssistId(rs.getString("faccountassistid"));
                info.setAccountAssistDisplayNameGroup(rs.getString("faccountassistdisplayname"));
                info.setAccountAssistLongNameGroup(rs.getString("faccountassistlongname"));
                info.setAccountAssistNumberGroup(rs.getString("faccountassistnumbergroup"));
                info.setAccountAssistTypeId(rs.getString("faccountassttypeid"));
                info.setSourceType(rs.getInt("fsourcetype"));
                info.setVoucherStatus(rs.getInt("fbizstatus"));
                info.setVoucherNumber(rs.getString("fvouchernumber"));
                info.setVoucherTypeName(rs.getString("fvouchertypename"));
                info.setVoucherBookedDate(rs.getDate("fbookeddate"));
                info.setVoucherPeriodYear(rs.getInt("fperiodyear"));
                info.setVoucherPeriodNumber(rs.getInt("fperiodnumber"));
                info.setVoucherCashflowFlag(rs.getInt("fcashflowflag"));
                records.add(info);
            }
            result.put("data", records);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return result;
    }

    private String getQueryCashflowRecordSQL(Context ctx, CashflowQueryParam param, List params, String acctTableID) throws BOSException {
        String locale = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("select cf.fid fcfid,cf.fvoucherid fvoucherid,sve.fid fsveid,ove.fid foveid, \r\n");
        sql.append("cf.foppvoucherassistrecordid fovastid, \r\n");
        sql.append("v.fbizstatus fbizstatus,vt.fname_").append(locale).append(" fvouchertypename,");
        sql.append("p.fperiodyear fperiodyear,p.fperiodnumber fperiodnumber,v.fnumber fvouchernumber,v.fbookeddate fbookeddate, \r\n");
        sql.append("v.fcashflowflag, \r\n");
        sql.append("sav.fnumber fsavnumber, \r\n");
        sql.append("oav.fnumber foavnumber, \r\n");
        sql.append("cfi.fid fcfiid,cfi.fname_").append(locale).append(" fcfiname,cfi.fnumber fcfinumber,cfi.flongnumber fcfilongnumber, \r\n");
        sql.append("cfi.fdirection fcfidirection, \r\n");
        sql.append("cf.foriginalamount foriginalamount,cf.flocalamount flocalamount,cf.freportingamount freportingamount,");
        sql.append(1).append(" fsourcetype, \r\n");
        sql.append("sve.fentrydc fsvedc,ove.fentrydc fovedc,cf.fitemflag fitemflag,ove.fseq foveseq,ove.fdescription fovedescription, \r\n");
        sql.append("cfihg.fid fcfiassistid,cfihg.fdisplayNameGroup_").append(locale).append(" fcfiassistdisplayname, \r\n");
        sql.append("assisthg.fid faccountassistid,assisthg.fdisplayNameGroup_").append(locale).append(" faccountassistdisplayname, \r\n");
        sql.append("assisthg.flongNameGroup_").append(locale).append(" faccountassistlongname, \r\n");
        sql.append("assisthg.fnumberGroup_").append(locale).append(" faccountassistnumbergroup, \r\n");
        sql.append("assisthg.FAsstAccountID faccountassttypeid \r\n");
        sql.append("from t_gl_cashflowrecord cf \r\n");
        sql.append("inner join t_gl_voucher v on v.fid=cf.fvoucherid \r\n");
        sql.append("inner join t_gl_voucherentry sve on sve.fid=cf.fentryid \r\n");
        sql.append("inner join t_gl_voucherentry ove on ove.fid=cf.fopposingaccountentryid \r\n");
        sql.append("inner join t_bd_period p on p.fid=v.fperiodid \r\n");
        sql.append("inner join t_bd_vouchertypes vt on vt.fid=v.fvouchertypeid \r\n");
        sql.append("inner join t_bd_accountview sav on sav.fid=sve.faccountid and sav.fcompanyid=v.fcompanyid \r\n");
        sql.append("inner join t_bd_accountview oav on oav.fid=ove.faccountid and oav.fcompanyid=v.fcompanyid\r\n");
        sql.append("left join t_bd_cashflowitem cfi on cfi.fid=cf.fprimaryitemid \r\n");
        sql.append("left join t_bd_assistanthg cfihg on cfihg.fid=cf.fassgrpid \r\n");
        sql.append("left join t_gl_voucherassistrecord assist on assist.fid=cf.foppvoucherassistrecordid \r\n");
        sql.append("left join t_bd_assistanthg assisthg on assisthg.fid=assist.fassgrpid \r\n");
        if (!param.isCashFilt()) {
            sql.append("left join ( \r\n");
            sql.append("  select distinct v.fid fid from t_gl_voucher v\t\r\n");
            sql.append("  inner join t_gl_voucherentry ve on v.fid = ve.fbillid   \r\n");
            sql.append("  inner join T_BD_AccountView av on ve.faccountid = av.fid and v.fcompanyid = av.fcompanyid\t\r\n");
            sql.append("  inner join t_bd_period p on v.fperiodid = p.fid \t\r\n");
            sql.append("  where v.fcompanyid=? and v.fhascashaccount = 1 \r\n");
            sql.append("   and av.fcompanyid = ? \r\n");
            params.add(param.getCompanyId());
            params.add(param.getCompanyId());
            if (param.isPeriod()) {
                sql.append("and p.fnumber >= ? and p.fnumber <= ? \r\n");
                params.add(new Integer(param.getStartYear() * 100 + param.getStartPeriod()));
                params.add(new Integer(param.getEndYear() * 100 + param.getEndPeriod()));
            } else {
                sql.append("and v.fbookeddate >= ? and v.fbookeddate <= ? \r\n");
                params.add(param.getStartDate());
                params.add(param.getEndDate());
            }
            if (!param.isIndcludeNoPosted()) {
                sql.append("  and v.fbizstatus=5 ");
            } else {
                sql.append("  and v.fbizstatus<>0  and v.fbizstatus<>2 ");
            }
            sql.append("  and av.fnumber like '" + param.getAccount().getNumber() + "%' \r\n");
            sql.append(") t on cf.fvoucherid=t.fid \r\n");
        }
        sql.append("where v.fcompanyid=? \r\n");
        sql.append("and oav.fcompanyid=? \r\n");
        sql.append("and sav.fcompanyid=? \r\n");
        params.add(param.getCompanyId());
        params.add(param.getCompanyId());
        params.add(param.getCompanyId());
        sql.append("and sav.faccounttableid=? and oav.faccounttableid=? \r\n");
        params.add(acctTableID);
        params.add(acctTableID);
        if (param.isPeriod()) {
            sql.append("and p.fnumber >= ? and p.fnumber <= ? \r\n");
            params.add(new Integer(param.getStartYear() * 100 + param.getStartPeriod()));
            params.add(new Integer(param.getEndYear() * 100 + param.getEndPeriod()));
        } else {
            sql.append("and v.fbookeddate >= ? and v.fbookeddate <= ? \r\n");
            params.add(param.getStartDate());
            params.add(param.getEndDate());
        }
        sql.append("and (sav.fisCash=1 or sav.fisBank=1 or sav.fisCashEquivalent=1) \r\n");
        if (!param.isIndcludeNoPosted()) {
            sql.append("  and v.fbizstatus = 5 ");
        } else {
            sql.append("  and v.fbizstatus <> 0  and v.fbizstatus <> 2 ");
        }
        if (!param.getCurrency().getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !param.getCurrency().getId().toString().equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            sql.append("  and sve.fcurrencyid=?");
            params.add(param.getCurrency().getId().toString());
        }
        if (!param.isCashFilt()) {
            sql.append(" and t.fid is not null \r\n");
        }
        sql.append("\r\n union all \r\n");
        sql.append("select cfs.fid fcfid,cfs.fvoucherid fvoucherid,sve.fid fsveid,ove.fid foveid, \r\n");
        sql.append("cfs.foppvoucherassistrecordid fovastid, \r\n");
        sql.append("v.fbizstatus fbizstatus,vt.fname_").append(locale).append(" fvouchertypename,");
        sql.append("p.fperiodyear fperiodyear,p.fperiodnumber fperiodnumber,v.fnumber fvouchernumber,v.fbookeddate fbookeddate, \r\n");
        sql.append("v.fcashflowflag, \r\n");
        sql.append("sav.fnumber fsavnumber, \r\n");
        sql.append("oav.fnumber foavnumber, \r\n");
        sql.append("'' fcfiid,N'' fcfiname,N'' fcfinumber,N'' fcfilongnumber, \r\n");
        sql.append(1).append(" fcfidirection, \r\n");
        sql.append("cfs.foriginalamount foriginalamount,cfs.flocalamount flocalamount,cfs.freportingamount freportingamount,");
        sql.append(2).append(" fsourcetype, \r\n");
        sql.append("sve.fentrydc fsvedc,ove.fentrydc fovedc,1 fitemflag,ove.fseq foveseq,ove.fdescription fovedescription, \r\n");
        sql.append("'' fcfiassistid,N'' fcfiassistdisplayname, \r\n");
        sql.append("assisthg.fid faccountassistid,assisthg.fdisplayNameGroup_").append(locale).append(" faccountassistdisplayname, \r\n");
        sql.append("assisthg.flongNameGroup_").append(locale).append(" faccountassistlongname, \r\n");
        sql.append("assisthg.fnumberGroup_").append(locale).append(" faccountassistnumbergroup, \r\n");
        sql.append("assisthg.FAsstAccountID faccountassttypeid \r\n");
        sql.append("from t_gl_cashflowsplitrecord cfs \r\n");
        sql.append("inner join t_gl_voucher v on v.fid=cfs.fvoucherid \r\n");
        sql.append("inner join t_gl_voucherentry sve on sve.fid=cfs.fentryid \r\n");
        sql.append("inner join t_gl_voucherentry ove on ove.fid=cfs.fopposingaccountentryid \r\n");
        sql.append("inner join t_bd_period p on p.fid=v.fperiodid \r\n");
        sql.append("inner join t_bd_vouchertypes vt on vt.fid=v.fvouchertypeid \r\n");
        sql.append("inner join t_bd_accountview sav on sav.fid=sve.faccountid and sav.fcompanyid=v.fcompanyid\r\n");
        sql.append("inner join t_bd_accountview oav on oav.fid=ove.faccountid and oav.fcompanyid=v.fcompanyid\r\n");
        sql.append("left join t_gl_voucherassistrecord assist on assist.fid=cfs.foppvoucherassistrecordid \r\n");
        sql.append("left join t_bd_assistanthg assisthg on assisthg.fid=assist.fassgrpid \r\n");
        if (!param.isCashFilt()) {
            sql.append("left join ( \r\n");
            sql.append("  select distinct v.fid fid from t_gl_voucher v\t\r\n");
            sql.append("  inner join t_gl_voucherentry ve on v.fid = ve.fbillid   \r\n");
            sql.append("  inner join T_BD_AccountView av on ve.faccountid = av.fid and av.fcompanyid=v.fcompanyid\t\r\n");
            sql.append("  inner join t_bd_period p on v.fperiodid = p.fid \t\r\n");
            sql.append("  where v.fcompanyid=? and v.fhascashaccount = 1 \r\n");
            sql.append("   and av.fcompanyid = ? \r\n");
            params.add(param.getCompanyId());
            params.add(param.getCompanyId());
            if (param.isPeriod()) {
                sql.append("and p.fnumber >= ? and p.fnumber <= ? \r\n");
                params.add(new Integer(param.getStartYear() * 100 + param.getStartPeriod()));
                params.add(new Integer(param.getEndYear() * 100 + param.getEndPeriod()));
            } else {
                sql.append("and v.fbookeddate >= ? and v.fbookeddate <= ? \r\n");
                params.add(param.getStartDate());
                params.add(param.getEndDate());
            }
            if (!param.isIndcludeNoPosted()) {
                sql.append("  and v.fbizstatus=5 ");
            } else {
                sql.append("  and v.fbizstatus<>0  and v.fbizstatus<>2 ");
            }
            sql.append("  and av.fnumber like '" + param.getAccount().getNumber() + "%' \r\n");
            sql.append(") t on cfs.fvoucherid=t.fid \r\n");
        }
        sql.append("where v.fcompanyid=? \r\n");
        sql.append("and oav.fcompanyid=? \r\n");
        sql.append("and sav.fcompanyid=? \r\n");
        params.add(param.getCompanyId());
        params.add(param.getCompanyId());
        params.add(param.getCompanyId());
        sql.append("and sav.faccounttableid=? and oav.faccounttableid=? \r\n");
        params.add(acctTableID);
        params.add(acctTableID);
        if (param.isPeriod()) {
            sql.append("and p.fnumber >= ? and p.fnumber <= ? \r\n");
            params.add(new Integer(param.getStartYear() * 100 + param.getStartPeriod()));
            params.add(new Integer(param.getEndYear() * 100 + param.getEndPeriod()));
        } else {
            sql.append("and v.fbookeddate >= ? and v.fbookeddate <= ? \r\n");
            params.add(param.getStartDate());
            params.add(param.getEndDate());
        }
        sql.append("and cfs.fitemflag=").append(1);
        if (!param.isIndcludeNoPosted()) {
            sql.append("  and v.fbizstatus = 5 ");
        } else {
            sql.append("  and v.fbizstatus <> 0  and v.fbizstatus <> 2 ");
        }
        if (!param.getCurrency().getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !param.getCurrency().getId().toString().equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            sql.append("  and sve.fcurrencyid=?");
            params.add(param.getCurrency().getId().toString());
        }
        if (!param.isCashFilt()) {
            sql.append(" and t.fid is not null \r\n");
        }
        return sql.toString();
    }

    private void splitUnfinishedVoucher(Context ctx, Set unFinished) throws BOSException, EASBizException {
        HashSet idSet = new HashSet();
        int currentSize = 0;
        Iterator it = unFinished.iterator();
        while (it.hasNext()) {
            idSet.add(it.next());
            if (++currentSize != 100) continue;
            this.splitVoucherCollection(ctx, idSet);
            idSet.clear();
            currentSize = 0;
        }
        if (!idSet.isEmpty()) {
            this.splitVoucherCollection(ctx, idSet);
        }
    }

    private void splitVoucherCollection(Context ctx, Set unFinished) throws BOSException, EASBizException {
        VoucherCollection voucherCol = this.getVoucherCollection(unFinished, ctx);
        ITAccountSplitStrategy strategy = TAccountSplitStrategyFactory.getSplitStrategy("default");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("number"));
        CompanyOrgUnitInfo curCompany = GlUtils.getCurrentCompany(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), sic, false);
        HashMap<String, Object> splitParams = new HashMap<String, Object>();
        splitParams.put("CurrentCompany", curCompany);
        CashflowSplitRecordCollection splitResult = new CashflowSplitRecordCollection();
        int size = voucherCol.size();
        for (int i = 0; i < size; ++i) {
            CashflowSplitRecordCollection result = strategy.split(ctx, voucherCol.get(i), splitParams);
            splitResult.addCollection(result);
        }
        ICashflowSplitRecord cfSplit = CashflowSplitRecordFactory.getLocalInstance(ctx);
        cfSplit.addBatch((IObjectCollection)splitResult);
        String sqlUpdate = "update t_gl_voucher set fcashflowflag = 6 where fid in (%s)";
        ArrayList<String> params = new ArrayList<String>();
        int updateSize = 200;
        int currentSize = 0;
        StringBuffer sqlCondition = new StringBuffer();
        for (String voucherId : unFinished) {
            sqlCondition.append("?");
            params.add(voucherId);
            if (++currentSize % updateSize == 0) {
                DbUtil.execute((Context)ctx, (String)sqlUpdate.replaceFirst("%s", sqlCondition.toString()), (Object[])params.toArray());
                params.clear();
                sqlCondition.delete(0, sqlCondition.length());
                continue;
            }
            sqlCondition.append(",");
        }
        if (params.size() > 0) {
            sqlCondition.deleteCharAt(sqlCondition.length() - 1);
            DbUtil.execute((Context)ctx, (String)sqlUpdate.replaceFirst("%s", sqlCondition.toString()), (Object[])params.toArray());
        }
    }

    private void deleteCashflowRecordOfUnFinishedVoucher(Context ctx, CashflowQueryParam param, Set unFinished) throws BOSException {
        String sqlDelete = "delete from t_gl_cashflowrecord where fvoucherid in (%s)";
        ArrayList<String> params = new ArrayList<String>();
        int deleteSize = 200;
        int currentSize = 0;
        StringBuffer sqlCondition = new StringBuffer();
        for (String voucherId : unFinished) {
            sqlCondition.append("?");
            params.add(voucherId);
            if (++currentSize % deleteSize == 0) {
                DbUtil.execute((Context)ctx, (String)sqlDelete.replaceFirst("%s", sqlCondition.toString()), (Object[])params.toArray());
                params.clear();
                sqlCondition.delete(0, sqlCondition.length());
                continue;
            }
            sqlCondition.append(",");
        }
        if (params.size() > 0) {
            sqlCondition.deleteCharAt(sqlCondition.length() - 1);
            DbUtil.execute((Context)ctx, (String)sqlDelete.replaceFirst("%s", sqlCondition.toString()), (Object[])params.toArray());
        }
    }

    private void deleteCashflowSplitRecordOfUnFinishedVoucher(Context ctx, CashflowQueryParam param, Set unFinished) throws BOSException {
        String sqlDelete = "delete from t_gl_cashflowsplitrecord where fvoucherid in (%s)";
        ArrayList<String> params = new ArrayList<String>();
        int deleteSize = 200;
        int currentSize = 0;
        StringBuffer sqlCondition = new StringBuffer();
        for (String voucherId : unFinished) {
            sqlCondition.append("?");
            params.add(voucherId);
            if (++currentSize % deleteSize == 0) {
                DbUtil.execute((Context)ctx, (String)sqlDelete.replaceFirst("%s", sqlCondition.toString()), (Object[])params.toArray());
                params.clear();
                sqlCondition.delete(0, sqlCondition.length());
                continue;
            }
            sqlCondition.append(",");
        }
        if (params.size() > 0) {
            sqlCondition.deleteCharAt(sqlCondition.length() - 1);
            DbUtil.execute((Context)ctx, (String)sqlDelete.replaceFirst("%s", sqlCondition.toString()), (Object[])params.toArray());
        }
    }

    private Set searchUnsplitVoucher(Context ctx, CashflowQueryParam param) throws BOSException {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append("select v.fid from t_gl_voucher v \r\n");
        sql.append("inner join t_bd_period p on v.fperiodid=p.fid \r\n");
        sql.append("where v.fcompanyid=? \r\n");
        params.add(param.getCompanyId());
        if (param.isPeriod()) {
            sql.append("and p.fnumber >= ? and p.fnumber <= ? \r\n");
            params.add(new Integer(param.getStartYear() * 100 + param.getStartPeriod()));
            params.add(new Integer(param.getEndYear() * 100 + param.getEndPeriod()));
        } else {
            sql.append("and v.fbookeddate >= ? and v.fbookeddate <= ? \r\n");
            params.add(param.getStartDate());
            params.add(param.getEndDate());
        }
        sql.append("and v.fhascashaccount = 1 and v.fcashflowflag <> ").append(4);
        sql.append(" and v.fcashflowflag <> ").append(6);
        sql.append(" and v.fcashflowflag <> ").append(0).append(" \r\n");
        if (!param.isIndcludeNoPosted()) {
            sql.append("  and v.fbizstatus = 5 ");
        } else {
            sql.append("  and v.fbizstatus <> 0  and v.fbizstatus <> 2 ");
        }
        IRowSet rsUnsplit = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        HashSet<String> unsplitVoucher = new HashSet<String>();
        try {
            while (rsUnsplit.next()) {
                unsplitVoucher.add(rsUnsplit.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return unsplitVoucher;
    }

    private void updateFinishedVoucher(Context ctx, CashflowQueryParam param) throws BOSException {
        ArrayList params = new ArrayList();
        String sqlFinished = null;
        sqlFinished = param.isPeriod() ? CashFlowUtils.getPrimaryItemVocuherSql(param.getCompanyId(), param.isIndcludeNoPosted(), true, new Integer(param.getStartYear() * 100 + param.getStartPeriod()), new Integer(param.getEndYear() * 100 + param.getEndPeriod()), null, null, params, 1) : CashFlowUtils.getPrimaryItemVocuherSql(param.getCompanyId(), param.isIndcludeNoPosted(), false, null, null, param.getStartDate(), param.getEndDate(), params, 1);
        StringBuffer sqlUpdate = new StringBuffer();
        sqlUpdate.append("update t_gl_voucher set fcashflowflag = 6 where fid in (\r\n");
        sqlUpdate.append(sqlFinished);
        sqlUpdate.append(") and fcashflowflag <> ").append(0).append(" \r\n");
        DbUtil.execute((Context)ctx, (String)sqlUpdate.toString(), (Object[])params.toArray());
    }

    private Set queryUnfinishAssignVoucher(Context ctx, CashflowQueryParam param) throws BOSException {
        ArrayList params = new ArrayList();
        String sql = null;
        sql = param.isPeriod() ? CashFlowUtils.getPrimaryItemVocuherSql(param.getCompanyId(), param.isIndcludeNoPosted(), true, new Integer(param.getStartYear() * 100 + param.getStartPeriod()), new Integer(param.getEndYear() * 100 + param.getEndPeriod()), null, null, params, 2) : CashFlowUtils.getPrimaryItemVocuherSql(param.getCompanyId(), param.isIndcludeNoPosted(), false, null, null, param.getStartDate(), param.getEndDate(), params, 2);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params.toArray());
        HashSet<String> ids = new HashSet<String>();
        try {
            while (rs.next()) {
                ids.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sqlSelect = new StringBuffer();
        ArrayList<Object> selectParams = new ArrayList<Object>();
        sqlSelect.append("select v.fid from t_gl_voucher v \r\n");
        sqlSelect.append("inner join t_bd_period p on v.fperiodid=p.fid \r\n");
        sqlSelect.append("where v.fcompanyid=? \r\n");
        selectParams.add(param.getCompanyId());
        if (param.isPeriod()) {
            sqlSelect.append("and p.fnumber >= ? and p.fnumber <= ? \r\n");
            selectParams.add(new Integer(param.getStartYear() * 100 + param.getStartPeriod()));
            selectParams.add(new Integer(param.getEndYear() * 100 + param.getEndPeriod()));
        } else {
            sqlSelect.append("and v.fbookeddate >= ? and v.fbookeddate <= ? \r\n");
            selectParams.add(param.getStartDate());
            selectParams.add(param.getEndDate());
        }
        sqlSelect.append("and v.fhascashaccount = 1 and v.fcashflowflag =").append(0).append(" \r\n");
        if (!param.isIndcludeNoPosted()) {
            sqlSelect.append("  and v.fbizstatus = 5 ");
        } else {
            sqlSelect.append("  and v.fbizstatus <> 0  and v.fbizstatus <> 2 ");
        }
        IRowSet rsUnsplit = DbUtil.executeQuery((Context)ctx, (String)sqlSelect.toString(), (Object[])selectParams.toArray());
        try {
            while (rsUnsplit.next()) {
                ids.add(rsUnsplit.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ids;
    }

    private VoucherCollection getVoucherCollection(Set voucherIds, Context ctx) throws BOSException, EASBizException {
        if (voucherIds.size() == 0) {
            return new VoucherCollection();
        }
        EntityViewInfo v = new EntityViewInfo();
        v.getSelector().addObjectCollection((IObjectCollection)VoucherInfo.getCashflowSelector());
        SorterItemCollection sorters = v.getSorter();
        SorterItemInfo sort = new SorterItemInfo("entries.seq");
        sorters.add(sort);
        VoucherCollection vchCol = new VoucherCollection();
        int length = 0;
        Iterator iter = voucherIds.iterator();
        HashSet<String> tempIdSet = new HashSet<String>();
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        while (iter.hasNext()) {
            String id = (String)iter.next();
            tempIdSet.add(id);
            if (++length != 100) continue;
            FilterInfo filter = new FilterInfo();
            v.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("id", tempIdSet, CompareType.INCLUDE));
            vchCol.addCollection(iVoucher.getVoucherCollection(v));
            length = 0;
            tempIdSet.clear();
        }
        if (tempIdSet.size() > 0) {
            FilterInfo filter = new FilterInfo();
            v.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("id", tempIdSet, CompareType.INCLUDE));
            vchCol.addCollection(iVoucher.getVoucherCollection(v));
        }
        return vchCol;
    }

    @Override
    protected Map _saveCashflowItem(Context ctx, Map saveParam) throws BOSException, EASBizException {
        Map cashflowRecords = (Map)saveParam.get("CashflowRecords");
        Object obj = GlUtils.getParamByKey(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), "GL_014");
        boolean notAllowModify = Integer.parseInt(obj.toString()) == 1;
        return this.saveCashflowRecords(ctx, cashflowRecords, notAllowModify);
    }

    private boolean isEnableCFRequisition(Context ctx) throws BOSException, EASBizException {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("GL_0152");
        keys.add("GL_070");
        Map params = GlUtils.getParamsByKeys(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), keys);
        int paramAsst = Integer.parseInt(params.get("GL_0152").toString());
        boolean paramCashflow = Boolean.valueOf(String.valueOf(params.get("GL_070")));
        if (paramAsst != 0) {
            return false;
        }
        return paramCashflow;
    }

    private Map saveCashflowRecords(Context ctx, Map cashflowRecords, boolean notAllowModify) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        Iterator itCashflowRecords = cashflowRecords.values().iterator();
        ArrayList<ObjectUuidPK> deletePKs = new ArrayList<ObjectUuidPK>();
        HashSet<String> saveIdSet = new HashSet<String>();
        HashSet<String> updateIdSet = new HashSet<String>();
        HashMap<String, String> retResult = new HashMap<String, String>();
        HashMap<String, CashFlowItemInfo> createdCFItems = new HashMap<String, CashFlowItemInfo>();
        CashflowRecordCollection saveCashflowRecords = new CashflowRecordCollection();
        CashflowRecordCollection updateCashflowRecords = new CashflowRecordCollection();
        Timestamp nowTime = new Timestamp(System.currentTimeMillis());
        TAccountCashflowInfo info = null;
        CashflowRecordInfo record = null;
        int seq = 1;
        CashFlowItemInfo cfItem = null;
        boolean iscfReq = this.isEnableCFRequisition(ctx);
        HashMap result = new HashMap();
        while (itCashflowRecords.hasNext()) {
            info = (TAccountCashflowInfo)itCashflowRecords.next();
            cfItem = (CashFlowItemInfo)createdCFItems.get(info.getCashflowItemId());
            if (cfItem == null) {
                cfItem = new CashFlowItemInfo();
                cfItem.setId(BOSUuid.read((String)info.getCashflowItemId()));
                createdCFItems.put(info.getCashflowItemId(), cfItem);
            }
            if (info.getSourceType() == 1) {
                if (info.getVoucherStatus() >= 3 && notAllowModify) continue;
                record = new CashflowRecordInfo();
                record.setId(BOSUuid.read((String)info.getId()));
                record.setPrimaryItem(cfItem);
                record.setPrimaryCoefficient(info.getPrimaryCoefficient());
                record.setSupplementaryItem(null);
                record.setSupplementaryCoefficient(0);
                if (info.getCfiAssistId() != null && info.getCfiAssistId().trim().length() != 0) {
                    AssistantHGInfo hgInfo = new AssistantHGInfo();
                    hgInfo.setId(BOSUuid.read((String)info.getCfiAssistId()));
                    record.setAssGrp(hgInfo);
                    record.setType(info.getCfType());
                } else {
                    record.setType(CashflowTypeEnum.OUT);
                    record.setAssGrp(null);
                }
                record.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                record.setLastUpdateTime(nowTime);
                updateCashflowRecords.add(record);
                updateIdSet.add(record.getId().toString());
                retResult.put(info.getId(), info.getId());
                continue;
            }
            deletePKs.add(new ObjectUuidPK(info.getId()));
            record = new CashflowRecordInfo();
            record.setId(BOSUuid.create((BOSObjectType)record.getBOSType()));
            record.setSeq(seq++);
            VoucherInfo voucherInfo = new VoucherInfo();
            voucherInfo.setId(BOSUuid.read((String)info.getVoucherId()));
            record.setVoucher(voucherInfo);
            VoucherEntryInfo entryInfo = new VoucherEntryInfo();
            entryInfo.setId(BOSUuid.read((String)info.getEntryId()));
            record.setEntry(entryInfo);
            AccountViewInfo account = new AccountViewInfo();
            account.setId(BOSUuid.read((String)info.getEntryAccountId()));
            record.setAccount(account);
            record.setEntryDC(info.isEntryDebit() ? EntryDC.DEBIT : EntryDC.CREDIT);
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)info.getCurrencyId()));
            record.setCurrency(currency);
            VoucherEntryInfo oppEntryInfo = new VoucherEntryInfo();
            oppEntryInfo.setId(BOSUuid.read((String)info.getOpposingEntryId()));
            record.setOpposingAccountEntry(oppEntryInfo);
            AccountViewInfo oppAccount = new AccountViewInfo();
            oppAccount.setId(BOSUuid.read((String)info.getOpposingEntryAccountId()));
            record.setOppAccount(oppAccount);
            record.setOppEntryDC(info.isOpposingEntryDebit() ? EntryDC.DEBIT : EntryDC.CREDIT);
            if (!StringUtils.isEmpty((String)info.getOpposingEntryAssitRecordId()) && !StringUtils.isEmpty((String)info.getAccountAssistId())) {
                VoucherAssistRecordInfo assistRecordInfo = new VoucherAssistRecordInfo();
                assistRecordInfo.setId(BOSUuid.read((String)info.getOpposingEntryAssitRecordId()));
                record.setOppVoucherAssistRecord(assistRecordInfo);
                AssistantHGInfo hg = new AssistantHGInfo();
                hg.setId(BOSUuid.read((String)info.getAccountAssistId()));
                record.setOppAssGrp(hg);
            }
            record.setOriginalAmount(info.getOriginalAmount());
            record.setLocalAmount(info.getLocalAmount());
            record.setReportingAmount(info.getReportingAmount());
            record.setPrimaryItem(cfItem);
            record.setPrimaryCoefficient(info.getPrimaryCoefficient());
            record.setSupplementaryItem(null);
            record.setSupplementaryCoefficient(0);
            record.setItemFlag(ItemFlag.PRIMARY);
            record.setType(CashflowTypeEnum.OUT);
            if (info.getCfiAssistId() != null && info.getCfiAssistId().trim().length() != 0) {
                AssistantHGInfo hgInfo = new AssistantHGInfo();
                hgInfo.setId(BOSUuid.read((String)info.getCfiAssistId()));
                record.setAssGrp(hgInfo);
                record.setType(info.getCfType());
            }
            record.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            record.setCreateTime(nowTime);
            record.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            record.setLastUpdateTime(nowTime);
            saveCashflowRecords.add(record);
            saveIdSet.add(record.getId().toString());
            retResult.put(info.getId(), record.getId().toString());
        }
        this.deleteRecordWithDataDirtyCheck(ctx, deletePKs, "t_gl_cashflowsplitrecord");
        ICashflowRecord cfr = CashflowRecordFactory.getLocalInstance(ctx);
        cfr.addNewBatch(saveCashflowRecords);
        ICFRequisition cFRequisition = CFRequisitionFactory.getLocalInstance(ctx);
        int sendSuccCount = 0;
        if (iscfReq) {
            Set checkedIds;
            sendSuccCount = cFRequisition.sendRequisition(saveIdSet, company.getId().toString(), false);
            FilterInfo checkCFFilter = new FilterInfo();
            checkCFFilter.getFilterItems().add(new FilterItemInfo("cfRecord", updateIdSet, CompareType.INCLUDE));
            Map checkResult = CFRequisitionFactory.getLocalInstance(ctx).checkReqCorrelation(checkCFFilter);
            if (checkResult != null && (checkedIds = (Set)checkResult.get("idSet")) != null && checkedIds.size() > 0) {
                for (String cfrID : checkedIds) {
                    BOSUuid bosUuid = BOSUuid.read((String)cfrID);
                    updateIdSet.remove(cfrID);
                    updateCashflowRecords.removeObject((Object)bosUuid);
                }
                result.put("coverFailureDetail", checkResult.get("detail"));
                result.put("coverFailureCount", checkedIds.size());
            }
        }
        this.updateRecordWithDataDirtyCheck(ctx, updateCashflowRecords);
        if (iscfReq) {
            sendSuccCount += cFRequisition.sendRequisition(updateIdSet, company.getId().toString(), true);
        }
        result.put("result", retResult);
        result.put("sendSuccCount", sendSuccCount);
        return result;
    }

    @Override
    protected Map _cacelCashflowItem(Context ctx, Map cancelMap) throws BOSException, EASBizException {
        Map cashflowRecords = (Map)cancelMap.get("CashflowRecords");
        Iterator itCashflowRecords = cashflowRecords.values().iterator();
        ArrayList<ObjectUuidPK> deletePKs = new ArrayList<ObjectUuidPK>();
        HashMap<String, String> retResult = new HashMap<String, String>();
        Object obj = GlUtils.getParamByKey(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), "GL_014");
        boolean notAllowModify = false;
        if (obj != null) {
            notAllowModify = Integer.parseInt(obj.toString()) == 1;
        }
        Timestamp nowTime = new Timestamp(System.currentTimeMillis());
        CashflowSplitRecordCollection saveRecords = new CashflowSplitRecordCollection();
        TAccountCashflowInfo info = null;
        CashflowSplitRecordInfo record = null;
        VoucherInfo voucherInfo = null;
        VoucherEntryInfo entryInfo = null;
        VoucherEntryInfo oppEntryInfo = null;
        while (itCashflowRecords.hasNext()) {
            info = (TAccountCashflowInfo)itCashflowRecords.next();
            if (info.getVoucherStatus() >= 3 && notAllowModify || info.getVoucherCashflowFlag() == 4) continue;
            deletePKs.add(new ObjectUuidPK(info.getId()));
            record = new CashflowSplitRecordInfo();
            record.setId(BOSUuid.create((BOSObjectType)record.getBOSType()));
            voucherInfo = new VoucherInfo();
            voucherInfo.setId(BOSUuid.read((String)info.getVoucherId()));
            record.setVoucher(voucherInfo);
            entryInfo = new VoucherEntryInfo();
            entryInfo.setId(BOSUuid.read((String)info.getEntryId()));
            record.setEntry(entryInfo);
            oppEntryInfo = new VoucherEntryInfo();
            oppEntryInfo.setId(BOSUuid.read((String)info.getOpposingEntryId()));
            record.setOpposingAccountEntry(oppEntryInfo);
            if (!StringUtils.isEmpty((String)info.getOpposingEntryAssitRecordId())) {
                VoucherAssistRecordInfo assistRecordInfo = new VoucherAssistRecordInfo();
                assistRecordInfo.setId(BOSUuid.read((String)info.getOpposingEntryAssitRecordId()));
                record.setOppVoucherAssistRecord(assistRecordInfo);
            }
            record.setOriginalAmount(info.getOriginalAmount());
            record.setLocalAmount(info.getLocalAmount());
            record.setReportingAmount(info.getReportingAmount());
            record.setItemFlag(ItemFlag.PRIMARY);
            record.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            record.setCreateTime(nowTime);
            record.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            record.setLastUpdateTime(nowTime);
            saveRecords.add(record);
            retResult.put(info.getId(), record.getId().toString());
        }
        this.deleteRecordWithDataDirtyCheck(ctx, deletePKs, "t_gl_cashflowrecord");
        ICashflowSplitRecord cfsr = CashflowSplitRecordFactory.getLocalInstance(ctx);
        cfsr.addBatch((IObjectCollection)saveRecords);
        HashMap<String, HashMap<String, String>> result = new HashMap<String, HashMap<String, String>>();
        result.put("result", retResult);
        return result;
    }

    @Override
    protected Map _saveCashflowItem(Context ctx, Map param, boolean isCover) throws BOSException, EASBizException {
        HashMap hmDynamicColumnInfo = new HashMap();
        HashMap hmDynamicDatabaseInfo = new HashMap();
        CashflowQueryParam queryParam = (CashflowQueryParam)param.get("queryParam");
        SelectorItemCollection sicCompany = new SelectorItemCollection();
        sicCompany.add(new SelectorItemInfo("accountTable.id"));
        sicCompany.add(new SelectorItemInfo("number"));
        CompanyOrgUnitInfo company = GlUtils.getCurrentCompany(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), sicCompany, false);
        SelectorItemCollection sicAccount = new SelectorItemCollection();
        sicAccount.add(new SelectorItemInfo("number"));
        sicAccount.add(new SelectorItemInfo("name"));
        sicAccount.add(new SelectorItemInfo("level"));
        sicAccount.add(new SelectorItemInfo("isCash"));
        sicAccount.add(new SelectorItemInfo("isBank"));
        sicAccount.add(new SelectorItemInfo("isCashEquivalent"));
        sicAccount.add(new SelectorItemInfo("borrowerMainCashFlowItem.id"));
        sicAccount.add(new SelectorItemInfo("borrowerMainCashFlowItem.direction"));
        sicAccount.add(new SelectorItemInfo("borrowerMainCashFlowItem.asstAccount.id"));
        sicAccount.add(new SelectorItemInfo("borrowerMainCashFlowItem.asstAccount.isEnable"));
        sicAccount.add(new SelectorItemInfo("lenderMainCashFlowItem.id"));
        sicAccount.add(new SelectorItemInfo("lenderMainCashFlowItem.direction"));
        sicAccount.add(new SelectorItemInfo("lenderMainCashFlowItem.asstAccount.id"));
        sicAccount.add(new SelectorItemInfo("lenderMainCashFlowItem.asstAccount.isEnable"));
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("GL_0152");
        keys.add("GL_014");
        Map params = GlUtils.getParamsByKeys(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), keys);
        Object obj = params.get("GL_0152");
        boolean isSimpleMode = Integer.parseInt(obj.toString()) == 0;
        obj = params.get("GL_014");
        boolean notAllowModify = Integer.parseInt(obj.toString()) == 1;
        String acctTableID = this.getAccountTableId(ctx, company, new Integer(queryParam.getEndYear()), new Integer(queryParam.getEndPeriod()));
        Map accounts = this.queryAccountByCompany(ctx, company, sicAccount, acctTableID);
        List dataModel = (List)this.createDataModel(ctx, accounts, queryParam, acctTableID).get("data");
        HashMap<String, TAccountCashflowInfo> cashflowRecords = new HashMap<String, TAccountCashflowInfo>();
        TAccountCashflowInfo needRemoveInfo2 = null;
        for (TAccountCashflowInfo needRemoveInfo2 : dataModel) {
            Object[] asstInfo;
            AccountViewInfo oav;
            if (!isCover && 1 == needRemoveInfo2.getSourceType() || (oav = (AccountViewInfo)accounts.get(needRemoveInfo2.getOpposingEntryAccountNumber())) == null) continue;
            CashFlowItemInfo item = null;
            item = needRemoveInfo2.isOpposingEntryDebit() ? oav.getBorrowerMainCashFlowItem() : oav.getLenderMainCashFlowItem();
            if (item == null) continue;
            needRemoveInfo2.setCashflowItemId(item.getId().toString());
            needRemoveInfo2.setCfiAssistId(null);
            if (item.getAsstAccount() != null && item.getAsstAccount().getId() != null && item.isIsEnable() && (asstInfo = this.getCachedColumnInfo(ctx, hmDynamicColumnInfo, needRemoveInfo2.getAccountAssistTypeId())) != null) {
                VoucherInfo.DynamicColumnInfo[] asstItemCols = (VoucherInfo.DynamicColumnInfo[])asstInfo[0];
                Object[] cfiInfo = this.getCachedColumnInfo(ctx, hmDynamicColumnInfo, item.getAsstAccount().getId().toString());
                VoucherInfo.DynamicColumnInfo[] cfiItemCols = (VoucherInfo.DynamicColumnInfo[])cfiInfo[0];
                CashFlowDirectControllerBean.autoSetActTypeValue(ctx, hmDynamicDatabaseInfo, needRemoveInfo2, needRemoveInfo2.getAccountAssistId(), asstItemCols, item.getAsstAccount(), cfiItemCols, isSimpleMode);
            }
            needRemoveInfo2.setDirection(item.getDirection());
            int coef = 1;
            if (needRemoveInfo2.isEntryDebit() && CashFlowDirection.OUT.equals((Object)item.getDirection()) || !needRemoveInfo2.isEntryDebit() && CashFlowDirection.IN.equals((Object)item.getDirection())) {
                coef = -1;
            }
            needRemoveInfo2.setPrimaryCoefficient(coef);
            cashflowRecords.put(needRemoveInfo2.getId().toString(), needRemoveInfo2);
        }
        this.saveCashflowRecords(ctx, cashflowRecords, notAllowModify);
        return new HashMap();
    }

    private String getAccountTableId(Context ctx, CompanyOrgUnitInfo company, Integer year, Integer period) throws EASBizException, BOSException {
        AccountRefContrastInfo ar = null;
        if (year != null && period != null) {
            ar = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(company.getId().toString(), company.getAccountTable().getId().toString(), year.intValue(), period.intValue());
        }
        return ar == null ? company.getAccountTable().getId().toString() : ar.getEnabledAcctTable().getId().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRecordWithDataDirtyCheck(Context ctx, List ids, String tableName) throws BOSException, EASBizException {
        block17: {
            String sqlDelete = "delete from " + tableName + " where fid in ({0})";
            StringBuffer sbIDs = new StringBuffer();
            int batchSize = 200;
            int count = 0;
            Connection cn = null;
            try {
                cn = EJBFactory.getConnection((Context)ctx);
                int size = ids.size();
                for (int i = 0; i < size; ++i) {
                    sbIDs.append(",'").append(ids.get(i)).append("'");
                    if (++count % batchSize != 0) continue;
                    try (Statement stmt = null;){
                        String strDel = MessageFormat.format(sqlDelete, sbIDs.deleteCharAt(0));
                        stmt = cn.prepareStatement(strDel);
                        int updateCount = stmt.executeUpdate();
                        if (updateCount != count) {
                            throw new CashFlowException(CashFlowException.DATADIRTY);
                        }
                    }
                    count = 0;
                    sbIDs.setLength(0);
                }
                if (count <= 0) break block17;
                try (Statement stmt = null;){
                    String strDel = MessageFormat.format(sqlDelete, sbIDs.deleteCharAt(0));
                    stmt = cn.prepareStatement(strDel);
                    int updateCount = stmt.executeUpdate();
                    if (updateCount != count) {
                        throw new CashFlowException(CashFlowException.DATADIRTY);
                    }
                }
                count = 0;
                sbIDs.setLength(0);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)cn);
            }
        }
    }

    private void updateRecordWithDataDirtyCheck(Context ctx, CashflowRecordCollection updateRecords) throws BOSException, EASBizException {
        StringBuffer sqlUpdate = new StringBuffer("update t_gl_cashflowrecord set fprimaryitemid=?,");
        sqlUpdate.append("FPrimaryCoeffient=?,fassgrpid=?,flastupdatetime=?,flastupdateuserid=?,ftype=? where fid=?");
        int batchSize = 200;
        int count = 0;
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.prepareStatement(sqlUpdate.toString());
            int size = updateRecords.size();
            for (int i = 0; i < size; ++i) {
                ++count;
                CashflowRecordInfo info = updateRecords.get(i);
                stmt.setString(1, info.getPrimaryItem().getId().toString());
                stmt.setInt(2, info.getPrimaryCoefficient());
                if (info.getAssGrp() == null || info.getAssGrp().getId() == null) {
                    stmt.setNull(3, 12);
                } else {
                    stmt.setString(3, info.getAssGrp().getId().toString());
                }
                stmt.setTimestamp(4, info.getLastUpdateTime());
                stmt.setString(5, info.getLastUpdateUser().getId().toString());
                stmt.setInt(6, info.getType().getValue());
                stmt.setString(7, info.getId().toString());
                stmt.addBatch();
                if (count % batchSize != 0) continue;
                stmt.executeBatch();
                stmt.clearBatch();
                count = 0;
            }
            if (count > 0) {
                stmt.executeBatch();
                stmt.clearBatch();
                count = 0;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        ArrayList<String> ids = new ArrayList<String>();
        int size = updateRecords.size();
        for (int i = 0; i < size; ++i) {
            ids.add(updateRecords.get(i).getId().toString());
        }
        this.checkRecordExist(ctx, ids, "t_gl_cashflowrecord");
    }

    private void checkRecordExist(Context ctx, List ids, String tableName) throws BOSException, EASBizException {
        String sqlExist = "select count(*) from " + tableName + " where fid in ({0})";
        StringBuffer sbIDs = new StringBuffer();
        int batchSize = 200;
        int count = 0;
        try {
            int size = ids.size();
            for (int i = 0; i < size; ++i) {
                sbIDs.append(",'").append(ids.get(i)).append("'");
                if (++count % batchSize != 0) continue;
                String strExist = MessageFormat.format(sqlExist, sbIDs.deleteCharAt(0));
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strExist);
                rs.next();
                if (rs.getInt(1) != count) {
                    throw new CashFlowException(CashFlowException.DATADIRTY);
                }
                count = 0;
                sbIDs.setLength(0);
            }
            if (count > 0) {
                String strExist = MessageFormat.format(sqlExist, sbIDs.deleteCharAt(0));
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strExist);
                rs.next();
                if (rs.getInt(1) != count) {
                    throw new CashFlowException(CashFlowException.DATADIRTY);
                }
                count = 0;
                sbIDs.setLength(0);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void autoSetActTypeValue(Context ctx, Map dynamicDatabaseInfo, TAccountCashflowInfo info, String hgId, VoucherInfo.DynamicColumnInfo[] acctActTypeCols, AsstAccountInfo cfiTypeGroup, VoucherInfo.DynamicColumnInfo[] cfiActTypeCols, boolean isSimpleMode) {
        if (StringUtils.isEmpty((String)hgId) || acctActTypeCols == null || acctActTypeCols.length == 0 || cfiActTypeCols == null || cfiActTypeCols.length == 0) {
            return;
        }
        AssistantHGInfo assGrp = null;
        try {
            assGrp = GlUtils.dynamicLoadAssistangHG(ctx, dynamicDatabaseInfo, hgId, acctActTypeCols);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (assGrp == null) {
            return;
        }
        boolean isAllNull = true;
        AssistantHGInfo group = new AssistantHGInfo();
        group.setAsstAccount(cfiTypeGroup);
        for (int i = 0; i < cfiActTypeCols.length; ++i) {
            VoucherInfo.DynamicColumnInfo colInfo = cfiActTypeCols[i];
            String key = colInfo.getMappingPropName();
            Object value = assGrp.get(key);
            if ("companyOrg".equals(key)) {
                SupplierInfo supplier;
                Object objSupplier;
                CustomerInfo customer;
                Object objCustomer;
                if (value == null && (objCustomer = assGrp.get("customer")) instanceof CustomerInfo && (customer = (CustomerInfo)objCustomer).getInternalCompany() != null) {
                    value = customer.getInternalCompany();
                }
                if (value == null && (objSupplier = assGrp.get("provider")) instanceof SupplierInfo && (supplier = (SupplierInfo)objSupplier).getInternalCompany() != null) {
                    value = supplier.getInternalCompany();
                }
                if (value != null) {
                    info.setCfType(CashflowTypeEnum.IN);
                } else {
                    info.setCfType(CashflowTypeEnum.OUT);
                }
            } else if ("customer".equals(key)) {
                if (value instanceof CustomerInfo) {
                    CustomerInfo customer = (CustomerInfo)value;
                    if (customer.getInternalCompany() != null) {
                        info.setCfType(CashflowTypeEnum.IN);
                    } else {
                        info.setCfType(CashflowTypeEnum.OUT);
                    }
                } else {
                    info.setCfType(CashflowTypeEnum.OUT);
                }
            } else if ("provider".equals(colInfo.getMappingPropName())) {
                if (value instanceof SupplierInfo) {
                    SupplierInfo supplier = (SupplierInfo)value;
                    if (supplier.getInternalCompany() != null) {
                        info.setCfType(CashflowTypeEnum.IN);
                    } else {
                        info.setCfType(CashflowTypeEnum.OUT);
                    }
                } else {
                    info.setCfType(CashflowTypeEnum.OUT);
                }
            } else if (!CashflowTypeEnum.IN.equals((Object)info.getCfType())) {
                info.setCfType(CashflowTypeEnum.OUT);
            }
            group.put(key, value);
            if (value == null) continue;
            isAllNull = false;
        }
        if (isAllNull) {
            info.setCfiAssistId(null);
            info.setCfiAssistDisplayNameGroup(null);
            info.setCfType(CashflowTypeEnum.OUT);
        } else if (!CashflowTypeEnum.IN.equals((Object)info.getCfType()) && isSimpleMode) {
            info.setCfiAssistId(null);
            info.setCfiAssistDisplayNameGroup(null);
            info.setCfType(CashflowTypeEnum.OUT);
        } else {
            try {
                group = VoucherFacadeFactory.getLocalInstance((Context)ctx).confirmAssGrp(group, cfiTypeGroup.getId().toString(), cfiActTypeCols);
                if (group != null) {
                    info.setCfiAssistId(group.getId().toString());
                    info.setCfiAssistDisplayNameGroup(group.getDisplayNameGroup());
                } else {
                    info.setCfType(CashflowTypeEnum.OUT);
                }
            }
            catch (Exception e) {
                info.setCfType(CashflowTypeEnum.OUT);
                logger.error((Object)"Appliy cashflowItem error!", (Throwable)e);
            }
        }
    }

    private Object[] getCachedColumnInfo(Context ctx, Map hmDynamicColumnInfo, String typeGroupId) {
        if (typeGroupId == null) {
            return null;
        }
        Object[] colInfo = (Object[])hmDynamicColumnInfo.get(typeGroupId);
        try {
            if (colInfo == null) {
                colInfo = VoucherFacadeFactory.getLocalInstance((Context)ctx).fetchAssColumnInfo(null, typeGroupId, null);
                hmDynamicColumnInfo.put(typeGroupId, colInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return colInfo;
    }
}

