/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemCollection;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemType;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ICashFlowItem;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AuxAccountUtils;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.ShareTacticEnum;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.AbstractWSVoucherInfo;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.RunningBusinessMethod;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.WSVoucherCollection;
import com.kingdee.eas.fi.gl.WSVoucherInfo;
import com.kingdee.eas.fi.gl.app.AbstractCashFlowImpFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.voucher.SubmitVoucherServiceHelper;
import com.kingdee.eas.fi.gl.common.GLOrgUtil;
import com.kingdee.eas.fi.gl.validator.AssistCuSuStatusValidator;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CashFlowImpFacadeControllerBean
extends AbstractCashFlowImpFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.CashFlowImpFacadeControllerBean");
    private static final String RES_GLVOUCHERIMPRESOURCE = "com.kingdee.eas.fi.gl.GLVoucherImpResource";
    private Map vchCashsMap = new HashMap();
    private Map preCashFlowItemMap = new HashMap();
    private Map supCashFlowItemMap = new HashMap();
    private static final int FITCHCOUNT = 100;
    private Map asstActTypeInfoMap = new HashMap();
    private Map hgAsstActTypeMap = new HashMap();
    private Map cashOutAsstParamMap = new HashMap();
    boolean isSettleByLocal = true;
    private VoucherInfo.ExchangeRateWithValue localToRpt = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
    private VoucherInfo.ExchangeRateWithValue reportRate = null;
    private SubmitVoucherServiceHelper helper = new SubmitVoucherServiceHelper();

    private void init(Context ctx, IObjectCollection wsVoucherCol, List errList) throws BOSException, EASBizException {
        HashSet voucherSet = new HashSet();
        HashSet<String> asstNumbers = new HashSet<String>();
        HashSet preCashFlowItemNums = new HashSet();
        HashSet supCashFlowItemNums = new HashSet();
        int count = wsVoucherCol.size();
        for (int i = 0; i < count; ++i) {
            AbstractWSVoucherInfo wsVoucher = null;
            if (wsVoucherCol.getObject(i) instanceof WSVoucherInfo) {
                wsVoucher = (WSVoucherInfo)wsVoucherCol.getObject(i);
            }
            if (wsVoucher == null || wsVoucher.getItemFlag() != 1) continue;
            String key = wsVoucher.getVoucherId();
            WSVoucherCollection cashList = (WSVoucherCollection)((Object)this.vchCashsMap.get(key));
            if (cashList == null) {
                cashList = new WSVoucherCollection();
                cashList.add((WSVoucherInfo)wsVoucher);
                this.vchCashsMap.put(key, cashList);
            } else {
                cashList.add((WSVoucherInfo)wsVoucher);
            }
            this.addSet(preCashFlowItemNums, wsVoucher.getPrimaryItem());
            if (preCashFlowItemNums.size() >= 100) {
                this.addPreCashFlowItemMap(ctx, preCashFlowItemNums);
                preCashFlowItemNums = new HashSet();
            }
            this.addSet(supCashFlowItemNums, wsVoucher.getSupplyItem());
            if (supCashFlowItemNums.size() >= 100) {
                this.addSupCashFlowItemMap(ctx, supCashFlowItemNums);
                supCashFlowItemNums = new HashSet();
            }
            int assistCount = wsVoucher.get("assistCount") == null ? 0 : (Integer)wsVoucher.get("assistCount");
            for (int j = 1; j <= assistCount + 1; ++j) {
                asstNumbers.add((String)wsVoucher.get("asstActType" + j) + "_" + (String)wsVoucher.get("asstActNumber" + j));
            }
        }
        this.addPreCashFlowItemMap(ctx, preCashFlowItemNums);
        this.addSupCashFlowItemMap(ctx, supCashFlowItemNums);
    }

    @Override
    protected List _importCashFlow(Context ctx, IObjectCollection wsVoucherCol, Map param) throws BOSException, EASBizException {
        logger.error((Object)("yjc_log:wsVoucherCol:  size " + wsVoucherCol.size()));
        int count = wsVoucherCol.size();
        for (int i = 0; i < count; ++i) {
            WSVoucherInfo wsVoucher = null;
            if (wsVoucherCol.getObject(i) instanceof WSVoucherInfo) {
                wsVoucher = (WSVoucherInfo)wsVoucherCol.getObject(i);
            }
            logger.error((Object)("\t wsVoucher.id:" + (wsVoucher != null ? wsVoucher.getVoucherId() : "wsVoucher is null")));
        }
        logger.error((Object)"\n");
        ArrayList errorList = new ArrayList();
        this.init(ctx, wsVoucherCol, errorList);
        Set keySet = this.vchCashsMap.keySet();
        Iterator itr = keySet.iterator();
        IVoucher voucherFactory = VoucherFactory.getLocalInstance((Context)ctx);
        VoucherCollection voucherCollection = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = VoucherInfo.getCashflowSelector();
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("period.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.account.accountTypeID.property"));
        view.setSelector(sic);
        FilterInfo filter = null;
        String key = null;
        boolean hashError = false;
        while (itr.hasNext()) {
            key = (String)itr.next();
            if (key == null) continue;
            view = new EntityViewInfo();
            sic = VoucherInfo.getCashflowSelector();
            sic.add(new SelectorItemInfo("company.*"));
            sic.add(new SelectorItemInfo("period.*"));
            sic.add(new SelectorItemInfo("entries.*"));
            sic.add(new SelectorItemInfo("entries.account.accountTypeID.property"));
            view.setSelector(sic);
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)key));
            view.setFilter(filter);
            logger.error((Object)("yjc_log:voucherid " + key + " sql " + view.toString()));
            voucherCollection = voucherFactory.getVoucherCollection(view);
            if (voucherCollection != null && voucherCollection.size() > 0) {
                VoucherInfo info = voucherCollection.get(0);
                logger.error((Object)("yjc_log:voucherid " + key + " voucherNumber" + info.getNumber()));
            } else {
                logger.error((Object)("yjc_log:voucherid " + key + " can't get voucher  sql " + view.toString()));
            }
            hashError = this.contructHeadCashFlow(ctx, key, voucherCollection, errorList);
            if (hashError) continue;
            try {
                this.saveCashFlow(ctx, voucherCollection.get(0));
            }
            catch (Exception e) {
                WSVoucherCollection cashs = (WSVoucherCollection)((Object)this.vchCashsMap.get(key));
                this.contructErrMsg(ctx, cashs.get(0), errorList, e.getMessage());
                logger.error((Object)e.getMessage());
            }
        }
        if (errorList == null || errorList.size() == 0) {
            return null;
        }
        return errorList;
    }

    private void saveCashFlow(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        GlParam sysParam = this.getGlParam(ctx, voucherInfo.getCompany().getId().toString());
        if (voucherInfo.getBizStatus() == VoucherStatusEnum.TEMP) {
            this.dealSaveCashflow(ctx, voucherInfo, sysParam);
        } else {
            this.helper.clearCashflow(ctx, voucherInfo, sysParam);
        }
    }

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])GlUtils.getDefaultGLParamList(), (String)companyid);
        return glParam;
    }

    private boolean contructHeadCashFlow(Context ctx, String key, VoucherCollection voucherCollection, List errList) throws BOSException, EASBizException {
        boolean hasError = false;
        WSVoucherCollection cashs = (WSVoucherCollection)((Object)this.vchCashsMap.get(key));
        if (voucherCollection == null) {
            WSVoucherInfo wsCash = null;
            if (cashs.get(0) instanceof WSVoucherInfo) {
                wsCash = cashs.get(0);
            }
            String msg = ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"voucher_not_exist", (Locale)ctx.getLocale());
            this.contructErrMsg(ctx, wsCash, errList, msg.toString());
            return true;
        }
        VoucherInfo voucherInfo = voucherCollection.get(0);
        CompanyOrgUnitInfo companyOrgUnitInfo = voucherInfo.getCompany();
        this.addComParaMap(ctx, companyOrgUnitInfo);
        VoucherInfo.ExchangeRateWithValue reportRate = null;
        boolean bl = this.isSettleByLocal = 3 == companyOrgUnitInfo.getReportConvertMode().getValue();
        if (companyOrgUnitInfo.getReportCurrency() != null && this.isSettleByLocal && companyOrgUnitInfo.getReportExchangeTable() != null && companyOrgUnitInfo.getBaseExchangeTable() != null) {
            this.localToRpt = GlUtils.getLocalToReportingExchangeRate(companyOrgUnitInfo.getReportCurrency(), companyOrgUnitInfo.getReportExchangeTable().getId().toString(), companyOrgUnitInfo.getBaseCurrency(), companyOrgUnitInfo.getBaseExchangeTable().getId().toString(), voucherInfo.getBookedDate(), voucherInfo.getPeriod(), false, ctx);
            if (this.localToRpt == null) {
                this.localToRpt = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
            }
        }
        if (cashs != null) {
            CashflowRecordCollection cos = new CashflowRecordCollection();
            boolean subFlag = false;
            boolean hasPrimaryRecord = false;
            HashMap<Integer, VoucherEntryInfo> entryMap = new HashMap<Integer, VoucherEntryInfo>();
            VoucherEntryInfo entryInfo = null;
            for (int i = 0; i < voucherInfo.getEntries().size(); ++i) {
                entryInfo = voucherInfo.getEntries().get(i);
                entryMap.put(entryInfo.getSeq(), entryInfo);
            }
            int n = cashs.size();
            for (int ca = 0; ca < n; ++ca) {
                String supplynumber;
                WSVoucherInfo wsCash = null;
                if (cashs.get(ca) instanceof WSVoucherInfo) {
                    wsCash = cashs.get(ca);
                }
                CashflowRecordInfo record = new CashflowRecordInfo();
                String primarynumber = wsCash.getPrimaryItem();
                String type = wsCash.getType();
                if (primarynumber != null && !"".equals(primarynumber.trim()) && !"null".equalsIgnoreCase(primarynumber)) {
                    CharSequence msg;
                    CashFlowItemInfo pitem = (CashFlowItemInfo)this.preCashFlowItemMap.get(primarynumber);
                    if (pitem == null) {
                        msg = this.getCashNumNotMatchMsg(ctx, "primaryNum", primarynumber, "primary");
                        this.contructErrMsg(ctx, wsCash, errList, (String)msg);
                        logger.info((Object)msg);
                        subFlag = true;
                        break;
                    }
                    if (type == null) {
                        type = CashflowTypeEnum.OUT.getAlias(ctx.getLocale());
                    }
                    if (pitem.getAsstAccount() == null) {
                        if (!CashflowTypeEnum.OUT.getAlias().equals(type)) {
                            msg = new StringBuffer(this.getCashLineErrorMsg(ctx));
                            ((StringBuffer)msg).append(this.getRes(ctx, "primaryNum")).append("[").append(primarynumber).append("]");
                            ((StringBuffer)msg).append(this.getRes(ctx, "outtype")).append("[").append(type).append("]");
                            ((StringBuffer)msg).append(this.getRes(ctx, "mustouttype"));
                            this.contructErrMsg(ctx, wsCash, errList, ((StringBuffer)msg).toString());
                            logger.info((Object)((StringBuffer)msg).toString());
                            subFlag = true;
                            break;
                        }
                    } else {
                        if (!CashflowTypeEnum.OUT.getAlias().equals(type) && !CashflowTypeEnum.IN.getAlias().equals(type)) {
                            msg = new StringBuffer(this.getCashLineErrorMsg(ctx));
                            ((StringBuffer)msg).append(this.getRes(ctx, "primaryNum")).append("[").append(primarynumber).append("]");
                            ((StringBuffer)msg).append(this.getRes(ctx, "notothertype")).append("[").append(type).append("]");
                            ((StringBuffer)msg).append(this.getRes(ctx, "mustnotothertype"));
                            this.contructErrMsg(ctx, wsCash, errList, ((StringBuffer)msg).toString());
                            logger.info((Object)((StringBuffer)msg).toString());
                            subFlag = true;
                            break;
                        }
                        if (wsCash.getCashAssGrp() != null && pitem.isIsEnable() && pitem.getAsstAccount() != null) {
                            IAssistantHG igCtrl = AssistantHGFactory.getLocalInstance((Context)ctx);
                            AssistantHGInfo hg = igCtrl.getAssistantHGInfo((IObjectPK)new ObjectUuidPK(wsCash.getCashAssGrp()));
                            if (hg != null && hg.getAsstAccount().getId().equals((Object)pitem.getAsstAccount().getId())) {
                                record.setAssGrp(hg);
                            } else {
                                String msg2 = ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"primaryitem_not_exist_asst", (Locale)ctx.getLocale());
                                this.contructErrMsg(ctx, wsCash, errList, msg2.toString());
                            }
                        } else {
                            String[] asstactType = this.getCashAsstactArray(wsCash, 1);
                            String[] asstactTypeNumber = this.getCashAsstactArray(wsCash, 2);
                            String[] asstactTypeName = this.getCashAsstactArray(wsCash, 3);
                            AssistantHGInfo assistantHGInfo = new AssistantHGInfo();
                            AsstActTypeCollection arrayAsstActTypeInfo = new AsstActTypeCollection();
                            boolean assistSubFlag = false;
                            int asstCount = pitem.getAsstAccount().getCount();
                            for (int k = 0; k < asstCount; ++k) {
                                boolean hasResult = false;
                                boolean isAssit = false;
                                String atype = asstactType[k];
                                String anumber = asstactTypeNumber[k];
                                String aname = asstactTypeName[k];
                                if (atype != null && atype.trim().length() > 0) {
                                    isAssit = true;
                                    atype = atype.trim();
                                }
                                if (!StringUtil.isEmptyString((String)anumber)) {
                                    isAssit = true;
                                    anumber = anumber.trim();
                                }
                                if (!StringUtil.isEmptyString((String)aname)) {
                                    isAssit = true;
                                    aname = aname.trim();
                                }
                                if (!isAssit) continue;
                                AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)this.asstActTypeInfoMap.get(atype);
                                if (asstActTypeInfo == null) {
                                    String msg3 = this.getCashNumNotMatchMsg(ctx, "asstActTypeName", atype, "asstActType");
                                    this.contructErrMsg(ctx, wsCash, errList, msg3);
                                    logger.info((Object)msg3);
                                    assistSubFlag = true;
                                    break;
                                }
                                arrayAsstActTypeInfo.add(asstActTypeInfo);
                                String asstHGAttribute = asstActTypeInfo.getAsstHGAttribute();
                                DataBaseInfo dataInfo = this.findAsstActObject(ctx, voucherInfo, asstActTypeInfo, anumber, aname, voucherInfo.getCompany().getCU().getId().toString());
                                if (dataInfo == null) {
                                    String msg4 = this.getAsstMsg(ctx, "cashflow", atype, anumber, aname);
                                    this.contructErrMsg(ctx, wsCash, errList, msg4);
                                    logger.info((Object)msg4);
                                    assistSubFlag = true;
                                    break;
                                }
                                assistantHGInfo.put(asstHGAttribute, (Object)dataInfo);
                            }
                            if (assistSubFlag) {
                                subFlag = true;
                                break;
                            }
                            int cashOutAsst = (Integer)this.cashOutAsstParamMap.get(companyOrgUnitInfo.getNumber());
                            if (arrayAsstActTypeInfo.size() != 0 || !CashflowTypeEnum.OUT.getAlias().equals(type) || cashOutAsst == 0) {
                                AssistantHGInfo actualAssistantHGInfo = null;
                                try {
                                    IAssistantHG igCtrl = AssistantHGFactory.getLocalInstance((Context)ctx);
                                    actualAssistantHGInfo = igCtrl.getAssistantHG(assistantHGInfo, pitem.getAsstAccount().getId().toString(), arrayAsstActTypeInfo);
                                    record.setAssGrp(actualAssistantHGInfo);
                                }
                                catch (Exception e) {
                                    StringBuffer msg5 = new StringBuffer(this.getCashLineErrorMsg(ctx));
                                    msg5.append(":").append(e.getMessage());
                                    this.contructErrMsg(ctx, wsCash, errList, msg5.toString());
                                    logger.error((Object)msg5.toString(), (Throwable)e);
                                    subFlag = true;
                                    break;
                                }
                            }
                        }
                    }
                    record.setPrimaryItem(pitem);
                    record.setType(this.getCashflowTypeEnum(ctx, type));
                }
                if ((supplynumber = wsCash.getSupplyItem()) != null && !"".equals(supplynumber.trim()) && !"null".equalsIgnoreCase(supplynumber)) {
                    CashFlowItemInfo supitem = (CashFlowItemInfo)this.supCashFlowItemMap.get(supplynumber);
                    if (supitem == null) {
                        String msg = this.getCashNumNotMatchMsg(ctx, "supplyNum", supplynumber, "supply");
                        this.contructErrMsg(ctx, wsCash, errList, msg);
                        logger.info((Object)msg);
                        subFlag = true;
                        break;
                    }
                    record.setSupplementaryItem(supitem);
                }
                BigDecimal originalAmount = new BigDecimal(String.valueOf(wsCash.getCashflowAmountOriginal()));
                BigDecimal localamount = new BigDecimal(String.valueOf(wsCash.getCashflowAmountLocal()));
                BigDecimal reportamount = new BigDecimal(String.valueOf(wsCash.getCashflowAmountRpt()));
                int primarycoef = (int)wsCash.getPrimaryCoef();
                int supplycoef = (int)wsCash.getSupplyCoef();
                record.setOriginalAmount(originalAmount);
                record.setLocalAmount(localamount);
                record.setReportingAmount(reportamount);
                record.setPrimaryCoefficient(primarycoef);
                record.setSupplementaryCoefficient(supplycoef);
                record.setVoucher(voucherInfo);
                cos.add(record);
                record.setSeq(ca + 1);
                record.put("seqnumber", (Object)String.valueOf(wsCash.getEntrySeq()));
                record.put("oppseqnumber", (Object)String.valueOf(wsCash.get("cashOppEntrySeq")));
                entryInfo = (VoucherEntryInfo)entryMap.get(wsCash.getEntrySeq());
                if (entryInfo == null) {
                    String msg = ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"ownEntry_not_exist", (Locale)ctx.getLocale());
                    this.contructErrMsg(ctx, wsCash, errList, msg.toString());
                    subFlag = true;
                    break;
                }
                record.setEntry(entryInfo);
                record.setAccount(entryInfo.getAccount());
                record.setEntryDC(entryInfo.getEntryDC());
                record.setCurrency(entryInfo.getCurrency());
                int pc = 1;
                if (record.getPrimaryItem() != null) {
                    CashFlowDirection direct = record.getPrimaryItem().getDirection();
                    if (EntryDC.DEBIT.equals((Object)entryInfo.getEntryDC()) && CashFlowDirection.OUT.equals((Object)direct) || EntryDC.CREDIT.equals((Object)entryInfo.getEntryDC()) && CashFlowDirection.IN.equals((Object)direct)) {
                        pc = -1;
                    }
                } else {
                    pc = 0;
                }
                record.setPrimaryCoefficient(pc);
                VoucherEntryInfo oppEntryInfo = (VoucherEntryInfo)entryMap.get(wsCash.getOppAccountSeq());
                if (oppEntryInfo == null) {
                    String msg = ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"ownEntry_not_exist", (Locale)ctx.getLocale());
                    this.contructErrMsg(ctx, wsCash, errList, msg.toString());
                    subFlag = true;
                    break;
                }
                record.setOpposingAccountEntry(oppEntryInfo);
                record.setOppAccount(oppEntryInfo.getAccount());
                record.setOppEntryDC(oppEntryInfo.getEntryDC());
                if (record.getSupplementaryItem() != null) {
                    int sc;
                    boolean isPnL = AccountProperty.SUNYI.equals((Object)oppEntryInfo.getAccount().getAccountTypeID().getProperty());
                    EntryDC entryDC = entryInfo.getEntryDC();
                    if (isPnL) {
                        sc = -1;
                        if (EntryDC.DEBIT.equals((Object)oppEntryInfo.getEntryDC())) {
                            sc = 1;
                            if (EntryDC.DEBIT.equals((Object)entryDC)) {
                                sc = -1;
                            }
                        } else if (EntryDC.CREDIT.equals((Object)entryDC)) {
                            sc = 1;
                        }
                        record.setSupplementaryCoefficient(sc);
                    } else {
                        sc = -1;
                        if (EntryDC.DEBIT.equals((Object)entryDC)) {
                            sc = 1;
                        }
                        record.setSupplementaryCoefficient(sc);
                    }
                }
                if (oppEntryInfo.getAssistRecords() != null && oppEntryInfo.getAssistRecords().size() > 0) {
                    record.setOppVoucherAssistRecord(oppEntryInfo.getAssistRecords().get(0));
                    record.setOppAssGrp(oppEntryInfo.getAssistRecords().get(0).getAssGrp());
                }
                if (oppEntryInfo.getAccount().getAccountTypeID().getProperty().getValue() == 4 && (record.getPrimaryItem() == null || record.getPrimaryItem().isIsDealActivity())) {
                    record.setSupplementaryItem(null);
                }
                if (record.getPrimaryItem() != null && record.getSupplementaryItem() != null) {
                    record.setItemFlag(ItemFlag.BOTH);
                    hasPrimaryRecord = true;
                } else if (record.getPrimaryItem() != null) {
                    record.setItemFlag(ItemFlag.PRIMARY);
                    hasPrimaryRecord = true;
                } else if (record.getSupplementaryItem() != null) {
                    record.setItemFlag(ItemFlag.SUPPLEMENTARY);
                } else {
                    StringBuffer msg = new StringBuffer(this.getCashNumNotMatchMsg(ctx, "primaryNum", primarynumber, "primary"));
                    msg.append(",").append(this.getCashNumNotMatchMsg(ctx, "supplyNum", supplynumber, "supply"));
                    this.contructErrMsg(ctx, wsCash, errList, msg.toString());
                    logger.info((Object)msg.toString());
                    subFlag = true;
                    break;
                }
                if (this.isSettleByLocal) {
                    reportRate = this.localToRpt;
                } else if (companyOrgUnitInfo.getReportExchangeTable() != null && companyOrgUnitInfo.getBaseExchangeTable() != null) {
                    Object[] exs = GlWebServiceUtil.getExchangeRate(ctx, companyOrgUnitInfo, entryInfo.getCurrency(), voucherInfo.getPeriod());
                    reportRate = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
                    if (exs != null && (reportRate = (VoucherInfo.ExchangeRateWithValue)exs[1]) == null) {
                        reportRate = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
                    }
                }
                if (this.isSettleByLocal) {
                    if (this.localToRpt.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                        record.setReportingAmount(record.getLocalAmount().multiply(this.localToRpt.getValue()));
                        continue;
                    }
                    record.setReportingAmount(record.getLocalAmount().divide(this.localToRpt.getValue(), 6));
                    continue;
                }
                if (reportRate == null || reportRate.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                    record.setReportingAmount(record.getOriginalAmount().multiply(entryInfo.getReportingExchangeRate()));
                    continue;
                }
                record.setReportingAmount(record.getOriginalAmount().divide(entryInfo.getReportingExchangeRate(), 6));
            }
            if (subFlag) {
                hasError = true;
            }
            voucherInfo.setCashflowRecords((AbstractObjectCollection)cos);
            if (cos.size() > 0) {
                voucherInfo.setCashflowFlag(CashflowFlag.FINISHED);
                if (hasPrimaryRecord) {
                    for (CashflowRecordInfo cf : cos) {
                        if (cf.getItemFlag() == ItemFlag.SUPPLEMENTARY) {
                            cf.setIsSupItem(true);
                            continue;
                        }
                        cf.setIsSupItem(false);
                    }
                }
            }
        }
        return hasError;
    }

    private void contructErrMsg(Context ctx, WSVoucherInfo wsCash, List errList, String msg) {
        String[] arrMsg = new String[]{wsCash.getSourceBillId(), wsCash.getVoucherId(), msg};
        errList.add(arrMsg);
    }

    private String getCashNumNotMatchMsg(Context ctx, String resNum, String number, String res) {
        return this.getMsg(ctx, "cashflow", resNum, number, res);
    }

    private String getMsg(Context ctx, String resType, String resNum, String number, String res) {
        StringBuffer msg = new StringBuffer();
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)resType, (Locale)ctx.getLocale()));
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"input", (Locale)ctx.getLocale()));
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)resNum, (Locale)ctx.getLocale()));
        msg.append("[").append(number).append("]");
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"nofind", (Locale)ctx.getLocale()));
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)res, (Locale)ctx.getLocale()));
        return msg.toString();
    }

    private String getCashLineErrorMsg(Context ctx) {
        StringBuffer msg = new StringBuffer();
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"cashflow", (Locale)ctx.getLocale()));
        return msg.toString();
    }

    private void addSet(Set set, Object value) {
        if (value == null || "".equals(value.toString().trim())) {
            return;
        }
        set.add(value);
    }

    private String getAsstMsg(Context ctx, String type, String atype, String anumber, String aname) {
        StringBuffer msg = new StringBuffer();
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)type, (Locale)ctx.getLocale()));
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"input", (Locale)ctx.getLocale()));
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"asstActType", (Locale)ctx.getLocale()));
        msg.append("[").append(atype).append("]");
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"number", (Locale)ctx.getLocale()));
        msg.append("[").append(anumber).append("]");
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"name", (Locale)ctx.getLocale()));
        msg.append("[").append(aname).append("]");
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"nofind", (Locale)ctx.getLocale()));
        msg.append(ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)"asstActType", (Locale)ctx.getLocale()));
        msg.append("[").append(atype).append("]");
        return msg.toString();
    }

    private String getRes(Context ctx, String resName) {
        return ResourceBase.getString((String)RES_GLVOUCHERIMPRESOURCE, (String)resName, (Locale)ctx.getLocale());
    }

    private String[] getCashAsstactArray(WSVoucherInfo wsVoucher, int type) {
        String[] asstact = new String[8];
        switch (type) {
            case 1: {
                asstact[0] = this.getValue(wsVoucher.getCashAsstActType1(), (String)wsVoucher.get("asstActType0"));
                asstact[1] = this.getValue(wsVoucher.getCashAsstActType2(), (String)wsVoucher.get("asstActType1"));
                asstact[2] = this.getValue(wsVoucher.getCashAsstActType3(), (String)wsVoucher.get("asstActType2"));
                asstact[3] = this.getValue(wsVoucher.getCashAsstActType4(), (String)wsVoucher.get("asstActType3"));
                asstact[4] = this.getValue(wsVoucher.getCashAsstActType5(), (String)wsVoucher.get("asstActType4"));
                asstact[5] = this.getValue(wsVoucher.getCashAsstActType6(), (String)wsVoucher.get("asstActType5"));
                asstact[6] = this.getValue(wsVoucher.getCashAsstActType7(), (String)wsVoucher.get("asstActType6"));
                asstact[7] = this.getValue(wsVoucher.getCashAsstActType8(), (String)wsVoucher.get("asstActType7"));
                break;
            }
            case 2: {
                asstact[0] = this.getValue(wsVoucher.getCashAsstActNumber1(), (String)wsVoucher.get("asstActNumber0"));
                asstact[1] = this.getValue(wsVoucher.getCashAsstActNumber2(), (String)wsVoucher.get("asstActNumber1"));
                asstact[2] = this.getValue(wsVoucher.getCashAsstActNumber3(), (String)wsVoucher.get("asstActNumber2"));
                asstact[3] = this.getValue(wsVoucher.getCashAsstActNumber4(), (String)wsVoucher.get("asstActNumber3"));
                asstact[4] = this.getValue(wsVoucher.getCashAsstActNumber5(), (String)wsVoucher.get("asstActNumber4"));
                asstact[5] = this.getValue(wsVoucher.getCashAsstActNumber6(), (String)wsVoucher.get("asstActNumber5"));
                asstact[6] = this.getValue(wsVoucher.getCashAsstActNumber7(), (String)wsVoucher.get("asstActNumber6"));
                asstact[7] = this.getValue(wsVoucher.getCashAsstActNumber8(), (String)wsVoucher.get("asstActNumber7"));
                break;
            }
            case 3: {
                asstact[0] = this.getValue(wsVoucher.getCashAsstActName1(), (String)wsVoucher.get("asstActName0"));
                asstact[1] = this.getValue(wsVoucher.getCashAsstActName2(), (String)wsVoucher.get("asstActName1"));
                asstact[2] = this.getValue(wsVoucher.getCashAsstActName3(), (String)wsVoucher.get("asstActName2"));
                asstact[3] = this.getValue(wsVoucher.getCashAsstActName4(), (String)wsVoucher.get("asstActName3"));
                asstact[4] = this.getValue(wsVoucher.getCashAsstActName5(), (String)wsVoucher.get("asstActName4"));
                asstact[5] = this.getValue(wsVoucher.getCashAsstActName6(), (String)wsVoucher.get("asstActName5"));
                asstact[6] = this.getValue(wsVoucher.getCashAsstActName7(), (String)wsVoucher.get("asstActName6"));
                asstact[7] = this.getValue(wsVoucher.getCashAsstActName8(), (String)wsVoucher.get("asstActName7"));
            }
        }
        return asstact;
    }

    private String getValue(String s1, String s2) {
        if (s1 != null && !"".equals(s1.trim())) {
            return s1;
        }
        return s2;
    }

    protected CashflowTypeEnum getCashflowTypeEnum(Context ctx, String key) {
        if (CashflowTypeEnum.IN.getAlias(ctx.getLocale()).equals(key)) {
            return CashflowTypeEnum.IN;
        }
        if (CashflowTypeEnum.OUT.getAlias(ctx.getLocale()).equals(key)) {
            return CashflowTypeEnum.OUT;
        }
        return CashflowTypeEnum.NONE;
    }

    private void addPreCashFlowItemMap(Context ctx, Set cfNumbers) throws BOSException {
        if (cfNumbers == null || cfNumbers.size() < 1) {
            return;
        }
        CashFlowItemCollection cfCollection = null;
        ICashFlowItem icf = CashFlowItemFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isDealActivity"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("items.type"));
        sic.add(new SelectorItemInfo("direction"));
        sic.add(new SelectorItemInfo("items.account.id"));
        sic.add(new SelectorItemInfo("asstAccount.id"));
        sic.add(new SelectorItemInfo("asstAccount.count"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)cfNumbers, CompareType.INCLUDE));
        fic.add(new FilterItemInfo("type", (Object)new Integer(CashFlowItemType.MASTER_TABLE_ITEM.getValue())));
        fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isProfit", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("level", (Object)new Integer(3), CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("direction", (Object)new Integer(0), CompareType.NOTEQUALS));
        cfCollection = icf.getCashFlowItemCollection(view);
        CashFlowItemInfo cfInfo = null;
        int size = cfCollection.size();
        for (int i = 0; i < size; ++i) {
            cfInfo = cfCollection.get(i);
            this.preCashFlowItemMap.put(cfInfo.getNumber(), cfInfo);
        }
    }

    private void addSupCashFlowItemMap(Context ctx, Set cfNumbers) throws BOSException {
        if (cfNumbers == null || cfNumbers.size() < 1) {
            return;
        }
        CashFlowItemCollection cfCollection = null;
        ICashFlowItem icf = CashFlowItemFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isDealActivity"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("items.type"));
        sic.add(new SelectorItemInfo("direction"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)cfNumbers, CompareType.INCLUDE));
        fic.add(new FilterItemInfo("type", (Object)new Integer(CashFlowItemType.SECONDARY_TABLE_ITEM.getValue())));
        fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("level", (Object)new Integer(3), CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("isProfit", (Object)new Integer(0)));
        cfCollection = icf.getCashFlowItemCollection(view);
        CashFlowItemInfo cfInfo = null;
        int size = cfCollection.size();
        for (int i = 0; i < size; ++i) {
            cfInfo = cfCollection.get(i);
            this.supCashFlowItemMap.put(cfInfo.getNumber(), cfInfo);
        }
    }

    private DataBaseInfo findAsstActObject(Context ctx, VoucherInfo voucherinfo, AsstActTypeInfo asstActTypeInfo, String number, String name, String cuid) throws EASBizException, BOSException {
        Map<String, DataBaseInfo> assist;
        AssistCuSuStatusValidator cusuValidator;
        int result;
        String strAsstActIDKey;
        String userId;
        String asstHGAttribute;
        CompanyOrgUnitInfo info;
        DataBaseInfo data;
        block69: {
            Map assist2;
            data = null;
            info = voucherinfo.getCompany();
            asstHGAttribute = asstActTypeInfo.getAsstHGAttribute();
            AsstActTypeInfo typeInfo = asstActTypeInfo;
            String strAsstName = name;
            String strAsstActID = number;
            userId = null;
            if (voucherinfo.getCreator() != null) {
                userId = voucherinfo.getCreator().getId().toString();
            }
            strAsstActIDKey = strAsstActID + "_" + info.getId().toString();
            if (this.hgAsstActTypeMap.get(asstHGAttribute) != null && (assist2 = (Map)this.hgAsstActTypeMap.get(asstHGAttribute)) != null) {
                data = (DataBaseInfo)assist2.get(strAsstActIDKey);
            }
            if (data != null) {
                return data;
            }
            IAssistantHG iAssistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
            BOSObjectType type = iAssistantHG.getType();
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo eo = loader.getEntity(type);
            PropertyCollection props = eo.getInheritedNoDuplicatedProperties();
            Iterator itr = props.iterator();
            LinkPropertyInfo pi = null;
            try {
                FilterInfo Dfilter;
                while (itr.hasNext()) {
                    PropertyInfo p = (PropertyInfo)itr.next();
                    if (!asstHGAttribute.equalsIgnoreCase(p.getName()) || !(p instanceof LinkPropertyInfo)) continue;
                    pi = (LinkPropertyInfo)p;
                    break;
                }
                if (pi == null) break block69;
                CtrlUnitInfo cu = info.getCU();
                ObjectUuidPK pk = new ObjectUuidPK(info.getId());
                info = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk);
                EntityObjectInfo eobj = pi.getRelationship().getSupplierObject();
                String strFacotry = eobj.getBusinessImplFactory();
                String strImpl = eobj.getBusinessImplName();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic = filter.getFilterItems();
                if ("customer".equalsIgnoreCase(asstHGAttribute)) {
                    if (asstActTypeInfo.isUseLongNumber() && strAsstActID != null) {
                        fic.add(new FilterItemInfo("customer.longNumber", (Object)strAsstActID.replace('.', '!')));
                    } else {
                        fic.add(new FilterItemInfo("customer.number", (Object)strAsstActID));
                    }
                } else if ("provider".equalsIgnoreCase(asstHGAttribute)) {
                    if (asstActTypeInfo.isUseLongNumber() && strAsstActID != null) {
                        fic.add(new FilterItemInfo("supplier.longNumber", (Object)strAsstActID.replace('.', '!')));
                    } else {
                        fic.add(new FilterItemInfo("supplier.number", (Object)strAsstActID));
                    }
                } else if ("material".equalsIgnoreCase(asstHGAttribute)) {
                    if (asstActTypeInfo.isUseLongNumber() && strAsstActID != null) {
                        fic.add(new FilterItemInfo("mateial.longNumber", (Object)strAsstActID.replace('.', '!')));
                    } else {
                        fic.add(new FilterItemInfo("mateial.number", (Object)strAsstActID));
                    }
                } else if (asstActTypeInfo.isUseLongNumber() && strAsstActID != null) {
                    fic.add(new FilterItemInfo("longNumber", (Object)strAsstActID.replace('.', '!')));
                } else {
                    fic.add(new FilterItemInfo("number", (Object)strAsstActID));
                }
                if ("customer".equalsIgnoreCase(asstHGAttribute)) {
                    strFacotry = CustomerCompanyInfoFactory.class.getName();
                    strImpl = CustomerCompanyInfo.class.getName();
                    SelectorItemCollection sic = view.getSelector();
                    sic.add(new SelectorItemInfo("customer.*"));
                    fic.add(new FilterItemInfo("customer.usedStatus", (Object)new Integer(1)));
                    if (info != null) {
                        fic.add(new FilterItemInfo("companyOrgUnit.id", (Object)info.getId().toString()));
                    }
                    if ((Dfilter = GlWebServiceUtil.getDFilterInfoForStandImp((IDataBaseD)CustomerFactory.getLocalInstance((Context)ctx), cuid)) != null) {
                        filter.mergeFilter(Dfilter, "and");
                    }
                } else if ("provider".equalsIgnoreCase(asstHGAttribute)) {
                    strFacotry = SupplierCompanyInfoFactory.class.getName();
                    strImpl = SupplierCompanyInfo.class.getName();
                    SelectorItemCollection sic = view.getSelector();
                    sic.add(new SelectorItemInfo("supplier.*"));
                    fic.add(new FilterItemInfo("supplier.usedStatus", (Object)new Integer(1)));
                    if (info != null) {
                        fic.add(new FilterItemInfo("companyOrgUnit.id", (Object)info.getId().toString()));
                    }
                    if ((Dfilter = GlWebServiceUtil.getDFilterInfoForStandImp((IDataBaseD)SupplierFactory.getLocalInstance((Context)ctx), cuid)) != null) {
                        filter.mergeFilter(Dfilter, "and");
                    }
                } else if ("material".equalsIgnoreCase(asstHGAttribute)) {
                    strFacotry = MaterialCompanyInfoFactory.class.getName();
                    strImpl = MaterialCompanyInfo.class.getName();
                    SelectorItemCollection sic = view.getSelector();
                    sic.add(new SelectorItemInfo("mateial.*"));
                    fic.add(new FilterItemInfo("mateial.status", (Object)new Integer(1)));
                    fic.add(new FilterItemInfo("mateial.status", (Object)new Integer(1)));
                    if (info != null) {
                        fic.add(new FilterItemInfo("company.id", (Object)info.getId().toString()));
                    }
                } else if (!"person".equalsIgnoreCase(asstHGAttribute)) {
                    if ("bankAccount".equalsIgnoreCase(asstHGAttribute)) {
                        fic.add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
                        if (info != null) {
                            boolean unMaster;
                            boolean bl = unMaster = !BooksUtil.isMasterBook((Context)ctx);
                            if (!unMaster) {
                                fic.add(new FilterItemInfo("company.id", (Object)info.getId().toString()));
                            } else {
                                String mastercompanyid = BooksUtil.getCurrentMasterCompanyID((Context)ctx);
                                FilterInfo filter1 = new FilterInfo();
                                filter1.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getId().toString()));
                                filter1.getFilterItems().add(new FilterItemInfo("company.id", (Object)mastercompanyid));
                                filter1.setMaskString(" (#0 or #1) ");
                                filter.mergeFilter(filter1, "and");
                            }
                        }
                    } else if ("project".equalsIgnoreCase(asstHGAttribute)) {
                        fic.add(new FilterItemInfo("status", (Object)new Integer(2), CompareType.NOTEQUALS));
                    } else if ("CostObject".equalsIgnoreCase(asstHGAttribute)) {
                        if (info != null) {
                            info = ContextUtil.getCurrentFIUnit((Context)ctx);
                        }
                        fic.add(new FilterItemInfo("company.id", (Object)info.getId().toString()));
                    } else if (asstActTypeInfo.isIsMultilevel()) {
                        String groupID;
                        FilterInfo filter1 = new FilterInfo();
                        if (asstHGAttribute.equals("saleOrg") || asstHGAttribute.equals("profitOrg") || asstHGAttribute.equals("purchaseOrg") || asstHGAttribute.equals("storeageOrg") || asstHGAttribute.equals("companyOrg") || asstHGAttribute.equals("costOrg")) {
                            fic.add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
                            fic.add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
                        } else if (asstActTypeInfo.getGroupTableName() == null && (asstActTypeInfo.getGlAsstActTypeGrp() == null || asstActTypeInfo.getGlAsstActTypeGrp().getShareTactic() == null || !asstActTypeInfo.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.S2) && !asstActTypeInfo.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.B1))) {
                            fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                        } else if (asstActTypeInfo.getGlAsstActTypeGrp() != null) {
                            filter1.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                            groupID = asstActTypeInfo.getGlAsstActTypeGrp().getId().toString();
                            String idCol = GlUtils.getGeneralCollection(ctx, groupID);
                            if (idCol.length() != 0) {
                                filter1.getFilterItems().add(new FilterItemInfo("id", (Object)idCol, CompareType.NOTINCLUDE));
                                filter1.setMaskString("#0 or #1");
                            }
                        }
                        if (asstActTypeInfo.getGlAsstActTypeGrp() != null) {
                            groupID = asstActTypeInfo.getGlAsstActTypeGrp().getId().toString();
                            fic.add(new FilterItemInfo("group.id", (Object)groupID));
                            filter.mergeFilter(AuxAccountUtils.getFilterForGeneral((Context)ctx, (String)groupID, (CompanyOrgUnitInfo)info), "and");
                        }
                        if (filter1.getFilterItems().size() > 0) {
                            filter.mergeFilter(filter1, "and");
                        }
                    }
                }
                String strMethod = "getDataBaseCollection";
                if ("material".equalsIgnoreCase(asstHGAttribute)) {
                    strMethod = "getMaterialCompanyInfoCollection";
                }
                Class[] argTypes = new Class[]{view.getClass()};
                Object[] args = new Object[]{view};
                Object result2 = null;
                try {
                    result2 = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strImpl, strMethod, argTypes, args);
                }
                catch (Exception e) {
                    result2 = RunningBusinessMethod.runLocalMethod(ctx, strFacotry, strImpl, strMethod, argTypes, args, eobj.getType());
                }
                if (result2 != null) {
                    if (!"material".equalsIgnoreCase(asstHGAttribute)) {
                        DataBaseCollection collection = (DataBaseCollection)result2;
                        if (collection.size() != 0) {
                            data = collection.get(0);
                            if ("customer".equalsIgnoreCase(asstHGAttribute) && data instanceof CustomerCompanyInfoInfo) {
                                data = ((CustomerCompanyInfoInfo)data).getCustomer();
                            }
                            if ("provider".equalsIgnoreCase(asstHGAttribute) && data instanceof SupplierCompanyInfoInfo) {
                                data = ((SupplierCompanyInfoInfo)data).getSupplier();
                            }
                        }
                    } else {
                        MaterialCompanyInfoCollection collection = (MaterialCompanyInfoCollection)result2;
                        if (collection.size() != 0) {
                            data = collection.get(0).getMateial();
                        }
                    }
                }
                if (data == null) {
                    logger.error((Object)("find asstact:" + name + "," + number + ",error filter sql\uff1a" + filter.toSql() + "--;--Filter:" + filter.toString()));
                }
            }
            catch (Exception e) {
                logger.error((Object)"find assittype error:", (Throwable)e);
            }
        }
        if (data != null && ("customer".equalsIgnoreCase(asstHGAttribute) ? (result = (cusuValidator = new AssistCuSuStatusValidator(ctx)).customerValidator(data.getString("id"), info.getId().toString())) == 1 : "provider".equalsIgnoreCase(asstHGAttribute) && (result = (cusuValidator = new AssistCuSuStatusValidator(ctx)).supplierValidator(data.getString("id"), info.getId().toString())) == 1)) {
            return null;
        }
        if (data != null && userId != null && (asstHGAttribute.equals("saleOrg") || asstHGAttribute.equals("profitOrg") || asstHGAttribute.equals("purchaseOrg") || asstHGAttribute.equals("storeageOrg") || asstHGAttribute.equals("adminOrg") || asstHGAttribute.equals("costOrg"))) {
            String fid2 = "";
            if (data != null && data.getId() != null) {
                fid2 = data.getId().toString();
            }
            if (!GLOrgUtil.isOrgValid(ctx, asstHGAttribute, fid2, info.getId().toString(), userId)) {
                return null;
            }
        }
        if (this.hgAsstActTypeMap.get(asstHGAttribute) != null) {
            assist = (Map)this.hgAsstActTypeMap.get(asstHGAttribute);
            if (assist != null) {
                assist.put(strAsstActIDKey, data);
            }
        } else {
            assist = new HashMap<String, DataBaseInfo>();
            assist.put(strAsstActIDKey, data);
            this.hgAsstActTypeMap.put(asstHGAttribute, assist);
        }
        return data;
    }

    private void dealSaveCashflow(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws BOSException, EASBizException {
        if (voucherInfo.getSourceType() == SourceType.ACCOUNTADJUST) {
            return;
        }
        CashflowRecordCollection cashflowRecordColl = (CashflowRecordCollection)voucherInfo.getCashflowRecords();
        if (cashflowRecordColl == null || cashflowRecordColl.size() == 0) {
            return;
        }
        VoucherEntryCollection entryColl = voucherInfo.getEntries();
        if (entryColl == null) {
            return;
        }
        HashMap<BOSUuid, VoucherEntryInfo> voucherEntryMap = new HashMap<BOSUuid, VoucherEntryInfo>();
        Iterator itEntry = entryColl.iterator();
        VoucherEntryInfo voucherEntryInfo = null;
        while (itEntry.hasNext()) {
            voucherEntryInfo = (VoucherEntryInfo)itEntry.next();
            voucherEntryMap.put(voucherEntryInfo.getId(), voucherEntryInfo);
        }
        Iterator iteratorCF = cashflowRecordColl.iterator();
        boolean hasPrimaryRecord = false;
        while (iteratorCF.hasNext()) {
            CashflowRecordInfo cashflowRecordInfo = (CashflowRecordInfo)iteratorCF.next();
            if (cashflowRecordInfo.getEntry() == null || cashflowRecordInfo.getEntry().getId() == null || cashflowRecordInfo.getOpposingAccountEntry() == null || cashflowRecordInfo.getOpposingAccountEntry().getId() == null) {
                iteratorCF.remove();
                continue;
            }
            if (!voucherEntryMap.containsKey(cashflowRecordInfo.getEntry().getId()) || !voucherEntryMap.containsKey(cashflowRecordInfo.getOpposingAccountEntry().getId())) {
                iteratorCF.remove();
                continue;
            }
            if (hasPrimaryRecord || cashflowRecordInfo.getItemFlag() != ItemFlag.PRIMARY && cashflowRecordInfo.getItemFlag() != ItemFlag.BOTH) continue;
            hasPrimaryRecord = true;
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            IORMappingDAO iCashflowRecord = ORMappingDAO.getInstance((BOSObjectType)new CashflowRecordInfo().getBOSType(), (Context)ctx, (Connection)conn);
            for (CashflowRecordInfo r : cashflowRecordColl) {
                if (hasPrimaryRecord && r.getItemFlag() == ItemFlag.SUPPLEMENTARY) {
                    r.setIsSupItem(true);
                } else {
                    r.setIsSupItem(false);
                }
                r.setVoucher(voucherInfo);
                r.setId(null);
                logger.error((Object)("yjc_log:cashflow-itemflag " + r.getItemFlag().getValue()));
                logger.error((Object)("yjc_log:voucherid:" + voucherInfo.getId().toString()));
                iCashflowRecord.addNewBatch((IObjectValue)r);
            }
            iCashflowRecord.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void addComParaMap(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        String key = company.getNumber();
        if (this.cashOutAsstParamMap.get(key) != null) {
            return;
        }
        HashMap<String, ObjectUuidPK> hmNumAndOrgId = new HashMap<String, ObjectUuidPK>();
        ObjectUuidPK comPk = new ObjectUuidPK(company.getId().toString());
        hmNumAndOrgId.put("GL_102", comPk);
        HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hmNumAndOrgId);
        try {
            this.cashOutAsstParamMap.put(key, Integer.parseInt(hmAllParam.get("GL_102").toString()));
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.cashOutAsstParamMap.put(key, 1);
        }
    }
}

