/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.ICashFlowItem;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountPLType;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.gl.CashEntryInfo;
import com.kingdee.eas.fi.gl.CashflowQueryParam;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICashflowRecord;
import com.kingdee.eas.fi.gl.IVoucherEntry;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.TAccountInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryFactory;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.AbstractCashFlowIndirectControllerBean;
import com.kingdee.eas.fi.gl.app.CashFlowUtils;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CashFlowIndirectControllerBean
extends AbstractCashFlowIndirectControllerBean {
    private static final long serialVersionUID = -5756288786549460372L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.CashFlowIndirectControllerBean");
    private static final int scale = 4;
    private Map allAccountMap = null;

    @Override
    protected IObjectCollection _getVoucher(Context ctx, CashflowQueryParam param) throws BOSException, EASBizException {
        VoucherCollection voucherCollection;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("  select distinct A.fid from t_gl_voucher A\t\r\n");
        sqlBuffer.append("  inner join t_gl_voucherentry B on A.fid = B.fbillid \t\r\n");
        sqlBuffer.append("  inner join T_BD_AccountView C on B.faccountid = C.fid \t\r\n");
        sqlBuffer.append("  inner join t_BD_AccountType actype on actype.FID = C.FAccountTypeID \t\r\n");
        sqlBuffer.append("  LEFT OUTER JOIN t_bd_cashflowaccountdiff ACCFF ON C.FID = ACCFF.FDIFFACCOUNTID \t\r\n");
        sqlBuffer.append("  where A.fcompanyid=? ");
        sqlBuffer.append("  and C.fcompanyid=? ");
        sqlBuffer.append("  and A.fbookeddate>=? and A.fbookeddate<=?");
        if (!param.getCurrency().getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !param.getCurrency().getId().toString().equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            sqlBuffer.append("  and B.fCurrencyID=?");
        }
        if (!param.isIndcludeNoPosted()) {
            sqlBuffer.append("  and A.fbizstatus=5 ");
        } else {
            sqlBuffer.append("  and A.fbizstatus<>0  and A.fbizstatus<>2 ");
        }
        sqlBuffer.append("  and (actype.FProperty = ").append(4).append(" and ACCFF.FID IS NULL )");
        sqlBuffer.append("  and A.fsourceType != 1 ");
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Object> params = new ArrayList<Object>();
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(sqlBuffer.toString());
            int index = 1;
            stmt.setString(index++, param.getCompanyId());
            stmt.setString(index++, param.getCompanyId());
            stmt.setDate(index++, param.getStartDate());
            stmt.setDate(index++, param.getEndDate());
            params.add(param.getCompanyId());
            params.add(param.getStartDate());
            params.add(param.getEndDate());
            if (!param.getCurrency().getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !param.getCurrency().getId().toString().equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
                stmt.setString(index++, param.getCurrency().getId().toString());
                params.add(param.getCurrency().getId().toString());
            }
            rs = stmt.executeQuery();
            voucherCollection = this.getVoucherCollection(rs, ctx);
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return voucherCollection;
    }

    protected Set getAssignedPrimaryItemVoucherIds(Context ctx, CashflowQueryParam param) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("  select voucher.fid voucherId \r\n");
        sqlBuffer.append("  from t_gl_cashflowrecord cfRecord \r\n");
        sqlBuffer.append("  inner join t_bd_cashflowitem cfitem on cfrecord.fprimaryitemid=cfitem.fid \t\r\n");
        sqlBuffer.append("  inner join t_gl_voucherentry entry on cfRecord.fentryid=entry.Fid \r\n");
        sqlBuffer.append("  inner join t_gl_voucher voucher on entry.fbillid=voucher.fid \r\n");
        sqlBuffer.append("  where voucher.fcompanyid=? ");
        sqlBuffer.append("  and voucher.fbookeddate>=? and voucher.fbookeddate<=?");
        String currencyId = param.getCurrency().getId().toString();
        if (!currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            sqlBuffer.append("  and entry.fCurrencyID=?");
        }
        if (!param.isIndcludeNoPosted()) {
            sqlBuffer.append("  and voucher.fbizstatus=5 ");
        } else {
            sqlBuffer.append("  and voucher.fbizstatus<>0  and voucher.fbizstatus<>2 ");
        }
        HashSet<String> voucherIds = new HashSet<String>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Object> params = new ArrayList<Object>();
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(sqlBuffer.toString());
            int index = 1;
            stmt.setString(index++, param.getCompanyId());
            stmt.setDate(index++, param.getStartDate());
            stmt.setDate(index++, param.getEndDate());
            params.add(param.getCompanyId());
            params.add(param.getStartDate());
            params.add(param.getEndDate());
            if (!currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
                stmt.setString(index++, currencyId);
                params.add(currencyId);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                String voucherId = rs.getString(1);
                voucherIds.add(voucherId);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return voucherIds;
    }

    @Override
    public boolean _getNoSelectCFItemVoucher(Context ctx, CashflowQueryParam param) throws BOSException, EASBizException {
        Set result = this.getUnfinishAssignVoucher(ctx, param);
        return result.size() > 0;
    }

    private Set getUnfinishAssignVoucher(Context ctx, CashflowQueryParam param) throws BOSException {
        try {
            ArrayList sqlParams = new ArrayList();
            String sql = CashFlowUtils.getPrimaryItemVocuherSql(param.getCompanyId(), param.isIndcludeNoPosted(), false, null, null, param.getStartDate(), param.getEndDate(), sqlParams, 2);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])sqlParams.toArray());
            HashSet<String> voucherIds = new HashSet<String>();
            while (rs.next()) {
                voucherIds.add(rs.getString("fid"));
            }
            return voucherIds;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _fetchInitData(Context ctx, Map initParam) throws BOSException, EASBizException {
        IPeriod period = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo type = (PeriodInfo)initParam.get("PeriodTypeInfo");
        CashflowQueryParam param = (CashflowQueryParam)initParam.get("CashflowQueryParam");
        HashMap<String, java.util.Date> dateMap = null;
        try {
            BOSUuid periodid = type.getId();
            ObjectUuidPK pk = new ObjectUuidPK(periodid);
            PeriodInfo typeInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)pk);
            PeriodInfo start = period.getPeriodInfo(param.getStartYear(), param.getStartPeriod(), typeInfo.getPeriodType());
            PeriodInfo end = period.getPeriodInfo(param.getEndYear(), param.getEndPeriod(), typeInfo.getPeriodType());
            dateMap = new HashMap<String, java.util.Date>();
            dateMap.put("BeginDate", start.getBeginDate());
            dateMap.put("EndDate", end.getEndDate());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        return dateMap;
    }

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        RptParams rp = new RptParams();
        rp.setObject("getAllCurrency", (Object)RptServerUtil.getAllCurrency(company.getId().toString(), ctx));
        company.setDescription(null);
        rp.setObject("pe", (Object)new PeriodEntity(RptServerUtil.getPeriodRange(ctx, company)));
        rp.setObject("currentPeriod", (Object)this.getCurrentPeriodInfo(ctx, company));
        return rp;
    }

    protected PeriodInfo getCurrentPeriodInfo(Context ctx, CompanyOrgUnitInfo company) throws BOSException, ReportBizException, EASBizException {
        PeriodInfo currentPeriod = null;
        ISystemStatusCtrol ictrol = null;
        ictrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.GENERALLEDGER.getValue())));
        fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("currentPeriod.id"));
        sic.add(new SelectorItemInfo("currentPeriod.type.id"));
        sic.add(new SelectorItemInfo("currentPeriod.periodYear"));
        sic.add(new SelectorItemInfo("currentPeriod.periodNumber"));
        sic.add(new SelectorItemInfo("currentPeriod.beginDate"));
        sic.add(new SelectorItemInfo("currentPeriod.endDate"));
        SystemStatusCtrolCollection col = ictrol.getSystemStatusCtrolCollection(view);
        currentPeriod = col.size() > 0 ? col.get(0).getCurrentPeriod() : null;
        return currentPeriod;
    }

    @Override
    protected Map _getTAccountMap(Context ctx, CashflowQueryParam param) throws BOSException, EASBizException {
        Map suppMap = this.splitAndCollectCashAll(ctx, param);
        return suppMap;
    }

    private VoucherCollection getVoucherCollection(ResultSet rs, Context ctx) throws SQLException, BOSException {
        VoucherCollection col;
        if (!rs.next()) {
            return null;
        }
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        v.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        StringBuffer filterStr = new StringBuffer("");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("entryCount"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("cashflowFlag"));
        sic.add(new SelectorItemInfo("hasCashAccount"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.account.number"));
        sic.add(new SelectorItemInfo("entries.account.name"));
        sic.add(new SelectorItemInfo("entries.account.longName"));
        sic.add(new SelectorItemInfo("entries.account.level"));
        sic.add(new SelectorItemInfo("entries.account.DC"));
        sic.add(new SelectorItemInfo("entries.account.isCash"));
        sic.add(new SelectorItemInfo("entries.account.isBank"));
        sic.add(new SelectorItemInfo("entries.account.isCashEquivalent"));
        sic.add(new SelectorItemInfo("entries.account.parent"));
        sic.add(new SelectorItemInfo("entries.account.PLType"));
        sic.add(new SelectorItemInfo("entries.account.accountTypeID.*"));
        sic.add(new SelectorItemInfo("entries.currency.id"));
        sic.add(new SelectorItemInfo("entries.localExchangeRate"));
        sic.add(new SelectorItemInfo("entries.originalAmount"));
        sic.add(new SelectorItemInfo("entries.localAmount"));
        sic.add(new SelectorItemInfo("entries.reportingAmount"));
        sic.add(new SelectorItemInfo("entries.entryDC"));
        sic.add(new SelectorItemInfo("entries.currency.*"));
        sic.add(new SelectorItemInfo("entries.cashflowRecords.*"));
        sic.add(new SelectorItemInfo("entries.cashflowRecords.entry.currency"));
        sic.add(new SelectorItemInfo("entries.cashflowRecords.entry.entryDC"));
        sic.add(new SelectorItemInfo("entries.cashflowRecords.entry.account.*"));
        sic.add(new SelectorItemInfo("entries.cashflowRecords.opposingAccountEntry.currency"));
        sic.add(new SelectorItemInfo("entries.cashflowRecords.opposingAccountEntry.entryDC"));
        sic.add(new SelectorItemInfo("entries.cashflowRecords.opposingAccountEntry.account.*"));
        v.getSelector().addObjectCollection((IObjectCollection)sic);
        SorterItemInfo sorter = new SorterItemInfo("entries.entryDC");
        sorter.setSortType(SortType.DESCEND);
        SorterItemInfo sorter1 = new SorterItemInfo("entries.account.isCash");
        sorter1.setSortType(SortType.DESCEND);
        SorterItemInfo sorter2 = new SorterItemInfo("entries.account.isBank");
        sorter2.setSortType(SortType.DESCEND);
        SorterItemInfo sorter3 = new SorterItemInfo("entries.account.isCashEquivalent");
        sorter3.setSortType(SortType.DESCEND);
        SorterItemInfo sorter4 = new SorterItemInfo("entries.account.PLType");
        sorter4.setSortType(SortType.DESCEND);
        SorterItemInfo sorter5 = new SorterItemInfo("entries.seq");
        v.getSorter().add(sorter);
        v.getSorter().add(sorter1);
        v.getSorter().add(sorter2);
        v.getSorter().add(sorter3);
        v.getSorter().add(sorter4);
        v.getSorter().add(sorter5);
        VoucherCollection vouchers = new VoucherCollection();
        int count = 0;
        filterStr.append(rs.getString("Fid"));
        ++count;
        while (rs.next()) {
            filterStr.append(",");
            filterStr.append(rs.getString("Fid"));
            if (++count % 200 != 0) continue;
            fic.clear();
            if (filterStr.toString().startsWith(",")) {
                filterStr.deleteCharAt(0);
                fic.add(new FilterItemInfo("id", (Object)filterStr.toString(), CompareType.INCLUDE));
            } else {
                fic.add(new FilterItemInfo("id", (Object)filterStr.toString(), CompareType.INCLUDE));
            }
            filter.setMaskString(" #0 ");
            col = VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(v);
            vouchers.addCollection(col);
            count = 0;
            filterStr.delete(0, filterStr.length());
        }
        if (count > 0) {
            fic.clear();
            if (filterStr.toString().startsWith(",")) {
                filterStr.deleteCharAt(0);
                fic.add(new FilterItemInfo("id", (Object)filterStr.toString(), CompareType.INCLUDE));
            } else {
                fic.add(new FilterItemInfo("id", (Object)filterStr.toString(), CompareType.INCLUDE));
            }
            filter.setMaskString(" #0 ");
            col = VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(v);
            vouchers.addCollection(col);
        }
        return vouchers;
    }

    private Map splitAndCollectCashAll(Context ctx, CashflowQueryParam param) throws EASBizException, BOSException {
        HashMap scMap = new HashMap();
        TAccountInfo ownerType = new TAccountInfo(0);
        TAccountInfo optiType = new TAccountInfo(0);
        ownerType.setStatus(88);
        optiType.setStatus(99);
        String currencyId = param.getCurrency().getId().toString();
        HashMap difference = CashFlowUtils.getDifference(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        if (difference == null) {
            difference = new HashMap();
        }
        this.fetchAccount(ctx, param);
        Set unFinishVoucherIds = this.getUnfinishAssignVoucher(ctx, param);
        Set primaryVoucherIds = this.dealAssignedPrimaryItemVoucher(ctx, param, scMap, ownerType, optiType, currencyId, difference, unFinishVoucherIds);
        Set supVoucherIds = this.handleAssignedSupItemVoucher(ctx, param, ownerType, optiType);
        if (GlUtils.isEmpty(param.getSupplementary())) {
            this.splitAndCollectVoucher(ctx, param, scMap, ownerType, optiType, currencyId, difference, primaryVoucherIds, supVoucherIds, unFinishVoucherIds);
        }
        return scMap;
    }

    private void splitAndCollectVoucher(Context ctx, CashflowQueryParam param, Map scMap, TAccountInfo ownerType, TAccountInfo optiType, String currencyId, Map difference, Set primaryVoucherIds, Set supVoucherIds, Set unFinishVoucherIds) throws BOSException, EASBizException {
        VoucherCollection col = (VoucherCollection)this._getVoucher(ctx, param);
        if (col == null) {
            return;
        }
        IAccountView iacct = AccountViewFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        CompanyOrgUnitInfo company = GlUtils.getCurrentCompany(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), sic, false);
        boolean hasCashAccount = false;
        Set assignedPrimaryVoucherIds = this.getAssignedPrimaryItemVoucherIds(ctx, param);
        ICashflowRecord cfr = CashflowRecordFactory.getLocalInstance(ctx);
        int count = col.size();
        for (int i = 0; i < count; ++i) {
            VoucherInfo voucher = col.get(i);
            if (unFinishVoucherIds.contains(voucher.getId().toString())) continue;
            hasCashAccount = voucher.isHasCashAccount();
            boolean needSync = false;
            if (supVoucherIds.contains(voucher.getId().toString())) {
                boolean needSplit = this.recalculateVoucherEntry(voucher, difference);
                if (!needSplit) continue;
                needSync = true;
            } else {
                boolean cashExists = false;
                boolean plExists = false;
                boolean otherExists = false;
                VoucherEntryCollection entries = voucher.getEntries();
                VoucherEntryInfo entryTemp = null;
                int size = entries.size();
                for (int j = 0; j < size; ++j) {
                    entryTemp = entries.get(j);
                    if (this.isCashAccount(entryTemp.getAccount())) {
                        cashExists = true;
                        continue;
                    }
                    if (this.isPL(entryTemp.getAccount(), difference)) {
                        plExists = true;
                        continue;
                    }
                    otherExists = true;
                }
                if (cashExists && plExists && !otherExists) continue;
                if (cashExists && plExists && otherExists) {
                    BigDecimal amount = new BigDecimal("0");
                    int cnt = entries.size();
                    for (int k = 0; k < cnt; ++k) {
                        entryTemp = entries.get(k);
                        if (!this.isCashAccount(entryTemp.getAccount())) continue;
                        amount = EntryDC.DEBIT.equals((Object)entryTemp.getEntryDC()) ? amount.add(entryTemp.getLocalAmount()) : amount.subtract(entryTemp.getLocalAmount());
                    }
                    if (amount.signum() != 0 && !assignedPrimaryVoucherIds.contains(voucher.getId().toString())) continue;
                    this.removeCashEntry(voucher);
                    needSync = true;
                }
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)voucher.getId()));
            filter.getFilterItems().add(new FilterItemInfo("entry.account.PLType", (Object)new Integer(0), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("itemFlag", (Object)new Integer(5)));
            cfr.delete(filter);
            Map voucherMap = CashFlowUtils.getVoucherOrder(ctx, voucher, difference);
            VoucherEntryCollection enCol = (VoucherEntryCollection)voucherMap.get("col");
            if (needSync) {
                this.syncVoucherEntry(voucher, (IObjectCollection)enCol);
            }
            boolean creditIsEmpty = true;
            int eSize = enCol.size();
            for (int idx = 0; idx < eSize; ++idx) {
                if (0 != enCol.get(idx).getEntryDC().getValue()) continue;
                creditIsEmpty = false;
                break;
            }
            boolean isDebitSingle = false;
            VoucherEntryInfo debitEntry = null;
            int curEntryIdx = 0;
            int enCount = enCol.size();
            block4: for (int j = 0; j < enCount; ++j) {
                VoucherEntryInfo entry;
                int enCount2;
                debitEntry = (VoucherEntryInfo)enCol.getObject(j);
                if (this.isCashAccount(debitEntry.getAccount()) || debitEntry.getLocalAmount().signum() == 0) continue;
                if (creditIsEmpty || isDebitSingle) {
                    enCount2 = enCol.size();
                    for (curEntryIdx = j + 1; curEntryIdx < enCount2; ++curEntryIdx) {
                        entry = (VoucherEntryInfo)enCol.getObject(curEntryIdx);
                        if (entry.getId().equals((Object)debitEntry.getId()) || entry.getLocalAmount().signum() == 0) continue;
                        this.dealSingleVoucher(ctx, company, entry, debitEntry, currencyId, voucher.getId().toString(), ownerType, optiType, iacct, hasCashAccount, difference);
                        if (debitEntry.getLocalAmount().signum() == 0) continue block4;
                    }
                    continue;
                }
                if (debitEntry.getEntryDC() == EntryDC.DEBIT) {
                    enCount2 = enCol.size();
                    while (curEntryIdx < enCount2) {
                        entry = (VoucherEntryInfo)enCol.getObject(curEntryIdx);
                        if (!(debitEntry.getEntryDC().getValue() == entry.getEntryDC().getValue() || this.isCashAccount(entry.getAccount()) || entry.getId().equals((Object)debitEntry.getId()) || entry.getLocalAmount().signum() == 0 || !this.isPL(debitEntry.getAccount(), difference) && !this.isPL(entry.getAccount(), difference) || this.isQUANYI(entry.getAccount()) && this.isQUANYI(debitEntry.getAccount()))) {
                            if (this.isPL(debitEntry.getAccount(), difference)) {
                                this.collect(ctx, company, false, entry, debitEntry, ownerType, optiType, iacct, param, voucher, debitEntry.getLocalAmount().signum(), hasCashAccount, difference);
                            } else {
                                this.collect(ctx, company, false, debitEntry, entry, ownerType, optiType, iacct, param, voucher, debitEntry.getLocalAmount().signum(), hasCashAccount, difference);
                            }
                            if (debitEntry.getLocalAmount().signum() == 0) break;
                            if (curEntryIdx == enCol.size() - 1) {
                                --j;
                                isDebitSingle = true;
                            }
                        }
                        ++curEntryIdx;
                    }
                    if (isDebitSingle || debitEntry.getLocalAmount().signum() == 0 || !this.isPL(debitEntry.getAccount(), difference)) continue;
                    --j;
                    isDebitSingle = true;
                    continue;
                }
                enCount2 = enCol.size();
                while (curEntryIdx < enCount2) {
                    entry = (VoucherEntryInfo)enCol.getObject(curEntryIdx);
                    if (!entry.getId().equals((Object)debitEntry.getId()) && entry.getLocalAmount().signum() != 0) {
                        this.dealSingleVoucher(ctx, company, entry, debitEntry, currencyId, voucher.getId().toString(), ownerType, optiType, iacct, hasCashAccount, difference);
                        if (debitEntry.getLocalAmount().signum() == 0) continue block4;
                    }
                    ++curEntryIdx;
                }
            }
        }
    }

    private void syncVoucherEntry(VoucherInfo voucher, IObjectCollection enCol) {
        VoucherEntryCollection voucherEntries = voucher.getEntries();
        for (int i = enCol.size() - 1; i >= 0; --i) {
            boolean found = false;
            VoucherEntryInfo compareEntryInfo = (VoucherEntryInfo)enCol.getObject(i);
            int size = voucherEntries.size();
            for (int j = 0; j < size; ++j) {
                VoucherEntryInfo entryInfo = voucherEntries.get(j);
                if (entryInfo == null || compareEntryInfo == null || !entryInfo.getId().toString().equals(compareEntryInfo.getId().toString())) continue;
                compareEntryInfo.setOriginalAmount(entryInfo.getOriginalAmount());
                compareEntryInfo.setLocalAmount(entryInfo.getLocalAmount());
                compareEntryInfo.setReportingAmount(entryInfo.getReportingAmount());
                found = true;
                break;
            }
            if (found) continue;
            enCol.removeObject(i);
        }
    }

    private boolean recalculateVoucherEntry(VoucherInfo voucher, Map difference) {
        int i;
        VoucherEntryInfo oppEntry;
        VoucherEntryInfo selfEntry;
        VoucherEntryInfo entryInfo;
        int i2;
        VoucherEntryCollection colEntry = voucher.getEntries();
        CashflowRecordCollection cashflows = new CashflowRecordCollection();
        int size = colEntry.size();
        for (i2 = 0; i2 < size; ++i2) {
            entryInfo = colEntry.get(i2);
            if (entryInfo.getCashflowRecords() == null) continue;
            cashflows.addCollection(entryInfo.getCashflowRecords());
        }
        if (cashflows.size() == 0) {
            return false;
        }
        ArrayList<VoucherEntryInfo> plAccountEntries = new ArrayList<VoucherEntryInfo>();
        for (i2 = colEntry.size() - 1; i2 >= 0; --i2) {
            entryInfo = colEntry.get(i2);
            if (this.isCashAccount(entryInfo.getAccount())) {
                colEntry.removeObject(i2);
                continue;
            }
            if (!this.isPL(entryInfo.getAccount(), difference)) continue;
            plAccountEntries.add(entryInfo);
        }
        boolean finished = true;
        int size2 = plAccountEntries.size();
        for (int i3 = 0; i3 < size2; ++i3) {
            VoucherEntryInfo entryInfo2 = (VoucherEntryInfo)plAccountEntries.get(i3);
            BigDecimal cashflowAmount = GlUtils.zero;
            selfEntry = null;
            oppEntry = null;
            CashflowRecordInfo cashflow = null;
            int cSize = cashflows.size();
            for (int j = 0; j < cSize; ++j) {
                cashflow = cashflows.get(j);
                selfEntry = cashflow.getEntry();
                oppEntry = cashflow.getOpposingAccountEntry();
                if (entryInfo2.getId().toString().equals(selfEntry.getId().toString())) {
                    cashflowAmount = cashflowAmount.add(cashflow.getLocalAmount());
                    continue;
                }
                if (!entryInfo2.getId().toString().equals(oppEntry.getId().toString())) continue;
                cashflowAmount = cashflowAmount.add(cashflow.getLocalAmount());
            }
            if (entryInfo2.getLocalAmount().compareTo(cashflowAmount) == 0) continue;
            finished = false;
            break;
        }
        if (finished) {
            return false;
        }
        HashMap<String, BigDecimal[]> entriesAmount = new HashMap<String, BigDecimal[]>();
        int entrySize = colEntry.size();
        for (int i4 = 0; i4 < entrySize; ++i4) {
            VoucherEntryInfo entryInfo3 = colEntry.get(i4);
            entriesAmount.put(entryInfo3.getId().toString(), new BigDecimal[]{entryInfo3.getOriginalAmount(), entryInfo3.getLocalAmount(), entryInfo3.getReportingAmount()});
        }
        BigDecimal oamount = null;
        BigDecimal cfLocalAmount = null;
        BigDecimal cfReportAmount = null;
        selfEntry = null;
        oppEntry = null;
        VoucherEntryInfo entryInfo4 = null;
        CashflowRecordInfo cashflow = null;
        int size3 = cashflows.size();
        for (i = 0; i < size3; ++i) {
            cashflow = cashflows.get(i);
            selfEntry = cashflow.getEntry();
            oppEntry = cashflow.getOpposingAccountEntry();
            cfLocalAmount = cashflow.getLocalAmount();
            cfReportAmount = cashflow.getReportingAmount();
            if (5 == cashflow.getItemFlag().getValue()) continue;
            int entrySize2 = colEntry.size();
            for (int j = 0; j < entrySize2; ++j) {
                BigDecimal[] entryAmount;
                entryInfo4 = colEntry.get(j);
                if (selfEntry.getId().toString().equals(entryInfo4.getId().toString())) {
                    entryAmount = (BigDecimal[])entriesAmount.get(entryInfo4.getId().toString());
                    if (entryAmount == null) continue;
                    entryAmount[0] = entryAmount[0].subtract(cashflow.getOriginalAmount());
                    entryAmount[1] = entryAmount[1].subtract(cfLocalAmount);
                    entryAmount[2] = entryAmount[2].subtract(cfReportAmount);
                    continue;
                }
                if (!oppEntry.getId().toString().equals(entryInfo4.getId().toString()) || (entryAmount = (BigDecimal[])entriesAmount.get(entryInfo4.getId().toString())) == null) continue;
                oamount = entryInfo4.getOriginalAmount();
                oamount = !selfEntry.getCurrency().getId().toString().equals(oppEntry.getCurrency().getId().toString()) && entryInfo4.getLocalAmount().signum() != 0 ? oamount.multiply(cfLocalAmount).divide(entryInfo4.getLocalAmount(), 4, 4) : cashflow.getOriginalAmount();
                entryAmount[0] = entryAmount[0].subtract(cashflow.getOriginalAmount());
                entryAmount[1] = entryAmount[1].subtract(cfLocalAmount);
                entryAmount[2] = entryAmount[2].subtract(cfReportAmount);
            }
        }
        int entrySize3 = colEntry.size();
        for (i = 0; i < entrySize3; ++i) {
            VoucherEntryInfo entry = colEntry.get(i);
            BigDecimal[] entryAmount = (BigDecimal[])entriesAmount.get(entry.getId().toString());
            if (entryAmount == null) continue;
            entry.setOriginalAmount(entryAmount[0]);
            entry.setLocalAmount(entryAmount[1]);
            entry.setReportingAmount(entryAmount[2]);
        }
        boolean hasPL = false;
        for (i = colEntry.size() - 1; i >= 0; --i) {
            if (colEntry.get(i).getLocalAmount().signum() == 0) {
                colEntry.removeObject(i);
                continue;
            }
            if (!this.isPL(colEntry.get(i).getAccount(), difference)) continue;
            hasPL = true;
        }
        return hasPL;
    }

    private void removeCashEntry(VoucherInfo voucher) {
        VoucherEntryInfo entryInfo;
        VoucherEntryInfo entryInfo2;
        int i;
        VoucherEntryCollection colEntry = voucher.getEntries();
        CashflowRecordCollection cashflows = new CashflowRecordCollection();
        int size = colEntry.size();
        for (i = 0; i < size; ++i) {
            entryInfo2 = colEntry.get(i);
            if (entryInfo2.getCashflowRecords() == null) continue;
            cashflows.addCollection(entryInfo2.getCashflowRecords());
        }
        if (cashflows.size() == 0) {
            return;
        }
        HashMap<String, BigDecimal[]> entriesAmount = new HashMap<String, BigDecimal[]>();
        for (i = colEntry.size() - 1; i >= 0; --i) {
            entryInfo2 = colEntry.get(i);
            if (this.isCashAccount(entryInfo2.getAccount())) {
                colEntry.removeObject(i);
                continue;
            }
            entriesAmount.put(entryInfo2.getId().toString(), new BigDecimal[]{entryInfo2.getOriginalAmount(), entryInfo2.getLocalAmount(), entryInfo2.getReportingAmount()});
        }
        CashflowRecordInfo cashflow = null;
        VoucherEntryInfo oppEntry = null;
        VoucherEntryInfo selfEntry = null;
        BigDecimal oamount = null;
        BigDecimal cfLocalAmount = null;
        BigDecimal cfReportAmount = null;
        int size2 = cashflows.size();
        block2: for (int i2 = 0; i2 < size2; ++i2) {
            cashflow = cashflows.get(i2);
            if (5 == cashflow.getItemFlag().getValue()) continue;
            selfEntry = cashflow.getEntry();
            oppEntry = cashflow.getOpposingAccountEntry();
            cfLocalAmount = cashflow.getLocalAmount();
            cfReportAmount = cashflow.getReportingAmount();
            entryInfo = null;
            int entrySize = colEntry.size();
            for (int j = 0; j < entrySize; ++j) {
                BigDecimal[] entryAmount;
                entryInfo = colEntry.get(j);
                if (!oppEntry.getId().toString().equals(entryInfo.getId().toString()) || (entryAmount = (BigDecimal[])entriesAmount.get(entryInfo.getId().toString())) == null) continue;
                oamount = entryInfo.getOriginalAmount();
                oamount = !selfEntry.getCurrency().getId().toString().equals(oppEntry.getCurrency().getId().toString()) && entryInfo.getLocalAmount().signum() != 0 ? oamount.multiply(cfLocalAmount).divide(entryInfo.getLocalAmount(), 4, 4) : cashflow.getOriginalAmount();
                entryAmount[0] = entryAmount[0].subtract(cashflow.getOriginalAmount());
                entryAmount[1] = entryAmount[1].subtract(cfLocalAmount);
                entryAmount[2] = entryAmount[2].subtract(cfReportAmount);
                continue block2;
            }
        }
        int entrySize = colEntry.size();
        for (int j = 0; j < entrySize; ++j) {
            entryInfo = colEntry.get(j);
            BigDecimal[] entryAmount = (BigDecimal[])entriesAmount.get(entryInfo.getId().toString());
            if (entryAmount == null) continue;
            entryInfo.setOriginalAmount(entryAmount[0]);
            entryInfo.setLocalAmount(entryAmount[1]);
            entryInfo.setReportingAmount(entryAmount[2]);
        }
    }

    private Set dealAssignedPrimaryItemVoucher(Context ctx, CashflowQueryParam param, Map scMap, TAccountInfo ownerType, TAccountInfo optiType, String currencyId, Map difference, Set unFinishVoucherIds) throws SQLDataException, BOSException, EASBizException, SQLAccessException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("  select av.fid  accountid, \t\t\t\t\t\t\r\n");
        sqlBuffer.append("  cfrecord.foriginalamount  amount, \t\t\t\t\r\n");
        sqlBuffer.append("  cfRecord.flocalamount  lamount, \t\t\t\t\r\n");
        sqlBuffer.append("  cfRecord.freportingamount  ramount, \t\t\t\t\r\n");
        sqlBuffer.append("  voucher.fid voucherId, \t\t\t\t\t\t\t\r\n");
        sqlBuffer.append("  cfRecord.fentryid  entryId, \t\t\t\t\t\r\n");
        sqlBuffer.append("  cfrecord.fopposingaccountentryid  optientryid,\t\r\n");
        sqlBuffer.append("  cfrecord.fprimaryitemid  primaryitemid,\t\t\t\r\n");
        sqlBuffer.append("  kc.fid  cashflownoactivity,\t   \t\t\t\t\t\r\n");
        sqlBuffer.append("  cfRecord.fprimarycoeffient  primarycoef,\t   \t\r\n");
        sqlBuffer.append("  cfRecord.fsupplementarycoeffient  suppmentcoe,\t\r\n");
        sqlBuffer.append("  sve.fcurrencyid  svecurrencyid,\t\r\n");
        sqlBuffer.append("  ove.fcurrencyid  ovecurrencyid,\t\r\n");
        sqlBuffer.append("  ove.foriginalamount  oveamount,\t\r\n");
        sqlBuffer.append("  sve.flocalamount  svelamount,\t\r\n");
        sqlBuffer.append("  cfRecord.fsupplementaryitemid  supplementaryitemid,\t\r\n");
        sqlBuffer.append("  cfRecord.fid cfrecordid,\t\r\n");
        sqlBuffer.append("  sve.faccountid  saccountid, \t\t\t\t\t\r\n");
        sqlBuffer.append("  sve.fentrydc  entrydc, \t\t\t\t\t\r\n");
        sqlBuffer.append("  ove.fentrydc  oppEntrydc \t\t\t\t\t\r\n");
        sqlBuffer.append("  from t_gl_cashflowrecord cfrecord\t\t\t\t\t\t\r\n");
        sqlBuffer.append("  inner join t_bd_cashflowitem cfitem on cfrecord.fprimaryitemid=cfitem.fid \t\r\n");
        sqlBuffer.append("  inner join t_gl_voucherentry sve on cfrecord.fentryid=sve.fid \t\r\n");
        sqlBuffer.append("  inner join t_gl_voucherentry ove on cfrecord.fopposingaccountentryid=ove.fid \t\r\n");
        sqlBuffer.append("  inner join t_gl_voucher voucher on ove.fbillid=voucher.fid \t\r\n");
        sqlBuffer.append("  inner join t_bd_accountview av on av.fid= ove.faccountid \t\r\n");
        sqlBuffer.append("  inner join t_bd_accounttype actype on actype.fid = av.faccounttypeid \t\r\n");
        if (!GlUtils.isEmpty(param.getSupplementary())) {
            sqlBuffer.append("  inner join t_bd_cashflowitem supitem on cfrecord.FSupplementaryItemID=supitem.fid \t\r\n");
        }
        sqlBuffer.append("  LEFT OUTER JOIN t_bd_cashflowkeepactivity KC ON CFITEM.FID =KC.FCONCASHFLOWITEMID and voucher.fcontrolunitid = kc.fcontrolunitid\t\r\n");
        sqlBuffer.append("  LEFT OUTER JOIN t_bd_cashflowaccountdiff ACCFF ON AV.FID =ACCFF.FDIFFACCOUNTID and voucher.fcontrolunitid = accff.fcontrolunitid\t\r\n");
        sqlBuffer.append("  where voucher.fhascashaccount=1 \t\r\n");
        sqlBuffer.append("  and voucher.fcompanyid=? ");
        sqlBuffer.append("  and voucher.fbookeddate>=? and voucher.fbookeddate<=?");
        if (!currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            sqlBuffer.append("  and sve.fcurrencyid=?");
        }
        if (!param.isIndcludeNoPosted()) {
            sqlBuffer.append("  and voucher.fbizstatus=5 ");
        } else {
            sqlBuffer.append("  and voucher.fbizstatus<>0  and voucher.fbizstatus<>2 ");
        }
        if (!GlUtils.isEmpty(param.getSupplementary())) {
            sqlBuffer.append("  and supitem.fnumber=? ");
        }
        sqlBuffer.append("  and ((cfItem.Fisdealactivity =1 and (actype.FProperty <> ").append(4).append(" or (actype.FProperty = ").append(4).append(" and ACCFF.FID IS NOT NULL)) )");
        sqlBuffer.append("  or ((cfItem.Fisdealactivity =0 OR (cfItem.Fisdealactivity = 1 AND KC.FID IS NOT NULL)) and actype.FProperty = ").append(4).append("))");
        HashSet<String> handledVoucherIds = new HashSet<String>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(sqlBuffer.toString());
            int index = 1;
            stmt.setString(index++, param.getCompanyId());
            stmt.setDate(index++, param.getStartDate());
            stmt.setDate(index++, param.getEndDate());
            if (!param.getCurrency().getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !param.getCurrency().getId().toString().equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
                stmt.setString(index++, param.getCurrency().getId().toString());
            }
            if (!GlUtils.isEmpty(param.getSupplementary())) {
                stmt.setString(index++, param.getSupplementary());
            }
            rs = stmt.executeQuery();
            AccountViewInfo account = null;
            AccountViewInfo optiAccount = null;
            BigDecimal[] amount = null;
            String voucherId = null;
            String entryId = null;
            String opposingAccountEntryid = null;
            IAccountView iacct = AccountViewFactory.getLocalInstance((Context)ctx);
            String coe = null;
            while (rs.next()) {
                voucherId = rs.getString(5);
                handledVoucherIds.add(voucherId);
                if (unFinishVoucherIds.contains(voucherId)) continue;
                amount = new BigDecimal[]{rs.getBigDecimal(2), rs.getBigDecimal(3), rs.getBigDecimal(4)};
                coe = String.valueOf(rs.getInt(11));
                entryId = rs.getString(6);
                opposingAccountEntryid = rs.getString(7);
                account = (AccountViewInfo)this.allAccountMap.get(rs.getString("saccountid"));
                if (account == null) {
                    account = iacct.getAccountViewInfo((IObjectPK)new ObjectUuidPK(rs.getString("saccountid")));
                    this.allAccountMap.put(account.getId().toString(), account);
                }
                if ((optiAccount = (AccountViewInfo)this.allAccountMap.get(rs.getString("accountid"))) == null) {
                    optiAccount = iacct.getAccountViewInfo((IObjectPK)new ObjectUuidPK(rs.getString("accountid")));
                    this.allAccountMap.put(optiAccount.getId().toString(), optiAccount);
                }
                EntryDC dc = EntryDC.getEnum((int)rs.getInt("entrydc"));
                EntryDC dc_pl = EntryDC.getEnum((int)rs.getInt("oppEntrydc"));
                String coef_virtual = "-1";
                if (!coe.equals("0")) {
                    coef_virtual = coe;
                } else if (this.isCashAccount(account) && !this.isCashAccount(optiAccount) && !this.isPL(optiAccount, difference)) {
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        coef_virtual = "1";
                    }
                } else if (this.isCashAccount(account) && this.isPL(optiAccount, difference)) {
                    coef_virtual = EntryDC.CREDIT.equals((Object)dc) ? "1" : "-1";
                }
                amount[0] = amount[0].multiply(new BigDecimal(coef_virtual));
                amount[1] = amount[1].multiply(new BigDecimal(coef_virtual));
                amount[2] = amount[2].multiply(new BigDecimal(coef_virtual));
                String supItemId = rs.getString(16);
                String cfRecordId = rs.getString(17);
                if (supItemId == null || supItemId.trim().length() == 0) {
                    this.dealAccount(ownerType, account, amount, voucherId, entryId, opposingAccountEntryid, currencyId, iacct, false, false, cfRecordId, param.getCompanyId());
                    this.dealOptiAccount(optiType, optiAccount, amount, voucherId, entryId, opposingAccountEntryid, currencyId, iacct, account, false, false, cfRecordId, param.getCompanyId());
                    continue;
                }
                this.dealAccount(ownerType, account, amount, voucherId, entryId, opposingAccountEntryid, currencyId, iacct, false, true, cfRecordId, param.getCompanyId());
                this.dealOptiAccount(optiType, optiAccount, amount, voucherId, entryId, opposingAccountEntryid, currencyId, iacct, account, false, true, cfRecordId, param.getCompanyId());
            }
            scMap.put("ownerType", ownerType);
            scMap.put("optiType", optiType);
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return handledVoucherIds;
    }

    private Set handleAssignedSupItemVoucher(Context ctx, CashflowQueryParam param, TAccountInfo ownerType, TAccountInfo opposingType) throws BOSException, EASBizException {
        HashSet<String> hashSet;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("  select av.fid  accountId, \t\t\t\t\t\t\r\n");
        sqlBuffer.append("  cfRecord.FOriginalAmount  amount, \t\t\t\t\r\n");
        sqlBuffer.append("  cfRecord.flocalamount  lamount, \t\t\t\t\r\n");
        sqlBuffer.append("  cfRecord.freportingamount  ramount, \t\t    \r\n");
        sqlBuffer.append("  voucher.fid voucherId, \t\t\t\t\t\t\t\r\n");
        sqlBuffer.append("  cfRecord.fentryid  entryId, \t\t\t\t\t\r\n");
        sqlBuffer.append("  cfRecord.FOpposingAccountEntryID  optiEntryId,\t\r\n");
        sqlBuffer.append("  cfRecord.fsupplementarycoeffient  suppmentcoe,voucher.fhascashaccount,  \r\n");
        sqlBuffer.append("  sve.faccountid  saccountid, \t\t\t\t\t\r\n");
        sqlBuffer.append("  ove.faccountid  oaccountid \t\t\t\t\t\r\n");
        sqlBuffer.append("  from t_gl_cashflowrecord cfRecord\t\t\t    \r\n");
        sqlBuffer.append("  inner join t_bd_cashflowitem cfItem on cfRecord.fsupplementaryitemid=cfItem.Fid \t\r\n");
        sqlBuffer.append("  inner join t_gl_voucherentry sve on cfrecord.fentryid=sve.fid \t\r\n");
        sqlBuffer.append("  inner join t_gl_voucherentry ove on cfRecord.FOpposingAccountEntryID=ove.Fid \t\r\n");
        sqlBuffer.append("  inner join t_gl_voucher voucher on ove.fbillid=voucher.fid \t\r\n");
        sqlBuffer.append("  inner join t_bd_accountview AV on av.fid= ove.faccountid \t\r\n");
        if (!GlUtils.isEmpty(param.getSupplementary())) {
            sqlBuffer.append("  inner join t_bd_cashflowitem supitem on cfrecord.FSupplementaryItemID=supitem.fid \t\r\n");
        }
        sqlBuffer.append(" where voucher.fcompanyid=? ");
        sqlBuffer.append("  and voucher.fbookeddate>=? and voucher.fbookeddate<=?");
        if (!param.getCurrency().getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !param.getCurrency().getId().toString().equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            sqlBuffer.append("  and sve.fCurrencyID=?");
        }
        if (!param.isIndcludeNoPosted()) {
            sqlBuffer.append("  and voucher.fbizstatus=5 ");
        } else {
            sqlBuffer.append("  and voucher.fbizstatus<>0  and voucher.fbizstatus<>2 ");
        }
        if (!GlUtils.isEmpty(param.getSupplementary())) {
            sqlBuffer.append("  and supitem.fnumber=? ");
        }
        sqlBuffer.append(" and cfRecord.fitemflag=").append(2);
        String currencyId = param.getCurrency().getId().toString();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(sqlBuffer.toString());
            int index = 1;
            stmt.setString(index++, param.getCompanyId());
            stmt.setDate(index++, param.getStartDate());
            stmt.setDate(index++, param.getEndDate());
            if (!currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
                stmt.setString(index++, currencyId);
            }
            if (!GlUtils.isEmpty(param.getSupplementary())) {
                stmt.setString(index++, param.getSupplementary());
            }
            rs = stmt.executeQuery();
            AccountViewInfo selfAccount = null;
            AccountViewInfo opposingAccount = null;
            BigDecimal[] amount = null;
            String voucherId = null;
            String entryId = null;
            String opposingAccountEntryid = null;
            String coe = null;
            IAccountView iacct = AccountViewFactory.getLocalInstance((Context)ctx);
            HashSet<String> voucherIds = new HashSet<String>();
            while (rs.next()) {
                amount = new BigDecimal[]{rs.getBigDecimal(2), rs.getBigDecimal(3), rs.getBigDecimal(4)};
                coe = String.valueOf(rs.getInt(8));
                voucherId = rs.getString(5);
                voucherIds.add(voucherId);
                entryId = rs.getString(6);
                opposingAccountEntryid = rs.getString(7);
                selfAccount = (AccountViewInfo)this.allAccountMap.get(rs.getString("saccountid"));
                if (selfAccount == null) {
                    selfAccount = iacct.getAccountViewInfo((IObjectPK)new ObjectUuidPK(rs.getString("saccountid")));
                    this.allAccountMap.put(selfAccount.getId().toString(), selfAccount);
                }
                if ((opposingAccount = (AccountViewInfo)this.allAccountMap.get(rs.getString("oaccountid"))) == null) {
                    opposingAccount = iacct.getAccountViewInfo((IObjectPK)new ObjectUuidPK(rs.getString("oaccountid")));
                    this.allAccountMap.put(opposingAccount.getId().toString(), opposingAccount);
                }
                amount[0] = amount[0].multiply(new BigDecimal(coe));
                amount[1] = amount[1].multiply(new BigDecimal(coe));
                amount[2] = amount[2].multiply(new BigDecimal(coe));
                if (rs.getInt(9) == 1) {
                    this.dealAccount(ownerType, selfAccount, amount, voucherId, entryId, opposingAccountEntryid, currencyId, iacct, true, true, null, param.getCompanyId());
                    this.dealOptiAccount(opposingType, opposingAccount, amount, voucherId, entryId, opposingAccountEntryid, currencyId, iacct, selfAccount, true, true, null, param.getCompanyId());
                    continue;
                }
                this.dealAccount(ownerType, selfAccount, amount, voucherId, entryId, opposingAccountEntryid, currencyId, iacct, false, true, null, param.getCompanyId());
                this.dealOptiAccount(opposingType, opposingAccount, amount, voucherId, entryId, opposingAccountEntryid, currencyId, iacct, selfAccount, false, true, null, param.getCompanyId());
            }
            hashSet = voucherIds;
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return hashSet;
    }

    private boolean isPL(AccountViewInfo account, Map difference) {
        return account.getPLType() != AccountPLType.NONE && !difference.containsKey(account.getId().toString());
    }

    private boolean isQUANYI(AccountViewInfo account) {
        return account.getAccountTypeID().getProperty() == AccountProperty.QUANYI;
    }

    private void dealSingleVoucher(Context ctx, CompanyOrgUnitInfo company, VoucherEntryInfo entry, VoucherEntryInfo debitEntry, String currencyId, String voucherID, TAccountInfo ownerType, TAccountInfo optiType, IAccountView iacct, boolean hasCashAccount, Map difference) throws EASBizException, BOSException {
        BigDecimal[] tempArray;
        String debitEntryID = debitEntry.getId().toString();
        BigDecimal debitLocal = debitEntry.getLocalAmount();
        BigDecimal local = entry.getLocalAmount();
        if (debitLocal.signum() == 0 || local.signum() == 0) {
            return;
        }
        if (debitLocal.signum() == entry.getLocalAmount().signum()) {
            return;
        }
        VoucherEntryInfo minEntry = null;
        VoucherEntryInfo maxEntry = null;
        BigDecimal minOrigAmount = null;
        BigDecimal maxOrigAmount = null;
        String entryID = entry.getId().toString();
        if (debitLocal.abs().compareTo(local.abs()) > 0) {
            minEntry = entry;
            maxEntry = debitEntry;
        } else {
            minEntry = debitEntry;
            maxEntry = entry;
        }
        BigDecimal minLocalAmount = minEntry.getLocalAmount();
        BigDecimal minReportAmount = minEntry.getReportingAmount();
        BigDecimal maxLocalAmount = maxEntry.getLocalAmount();
        minOrigAmount = minEntry.getOriginalAmount();
        maxOrigAmount = maxEntry.getOriginalAmount();
        if (!debitEntry.getCurrency().getId().toString().equals(entry.getCurrency().getId().toString()) && debitEntry == maxEntry) {
            minOrigAmount = maxOrigAmount.abs().multiply(minLocalAmount.divide(maxLocalAmount, 4, 4).abs()).multiply(new BigDecimal(String.valueOf(minLocalAmount.signum())));
        }
        minOrigAmount = minOrigAmount.setScale(entry.getCurrency().getPrecision(), 4);
        if (this.isPL(entry.getAccount(), difference) && this.isPL(debitEntry.getAccount(), difference)) {
            tempArray = null;
            BigDecimal localSignum = new BigDecimal(String.valueOf(local.signum()));
            BigDecimal debitLocalSignum = new BigDecimal(String.valueOf(debitEntry.getLocalAmount().signum()));
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId) || entry.getCurrency().getId().toString().equals(currencyId)) {
                tempArray = new BigDecimal[]{minOrigAmount.multiply(localSignum), minLocalAmount.multiply(localSignum), minReportAmount.multiply(localSignum)};
                entry.setLocalAmount(entry.getLocalAmount().add(tempArray[1]));
                entry.setReportingAmount(entry.getReportingAmount().add(tempArray[2]));
                entry.setOriginalAmount(entry.getOriginalAmount().add(tempArray[0]));
            }
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId) || debitEntry.getCurrency().getId().toString().equals(currencyId)) {
                tempArray = new BigDecimal[]{minOrigAmount.multiply(debitLocalSignum), minLocalAmount.multiply(debitLocalSignum), minReportAmount.multiply(debitLocalSignum)};
                debitEntry.setLocalAmount(debitEntry.getLocalAmount().add(tempArray[1]));
                debitEntry.setReportingAmount(debitEntry.getReportingAmount().add(tempArray[2]));
                debitEntry.setOriginalAmount(debitEntry.getOriginalAmount().add(tempArray[0]));
            }
            tempArray = new BigDecimal[]{minOrigAmount.abs().multiply(localSignum), minLocalAmount.abs().multiply(localSignum), minReportAmount.abs().multiply(localSignum)};
            this.cashCounteract(ctx, company, entry, debitEntry, tempArray, -1, hasCashAccount);
            tempArray = new BigDecimal[]{minOrigAmount.abs().multiply(debitLocalSignum), minLocalAmount.abs().multiply(debitLocalSignum), minReportAmount.abs().multiply(debitLocalSignum)};
            this.cashCounteract(ctx, company, debitEntry, entry, tempArray, -1, hasCashAccount);
        } else if (!(this.isCashAccount(debitEntry.getAccount()) || this.isCashAccount(entry.getAccount()) || this.isQUANYI(entry.getAccount()) && this.isQUANYI(debitEntry.getAccount()) || !this.isPL(debitEntry.getAccount(), difference) && !this.isPL(entry.getAccount(), difference) || !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId) && !debitEntry.getCurrency().getId().toString().equals(currencyId))) {
            tempArray = null;
            BigDecimal debitSignum = new BigDecimal(String.valueOf(debitEntry.getLocalAmount().signum()));
            tempArray = new BigDecimal[]{minOrigAmount.abs().multiply(debitSignum), minLocalAmount.abs().multiply(debitSignum), minReportAmount.abs().multiply(debitSignum)};
            if (debitEntry.getEntryDC().getValue() == 0) {
                tempArray[0] = tempArray[0].negate();
                tempArray[1] = tempArray[1].negate();
                tempArray[2] = tempArray[2].negate();
            }
            this.dealAccount(ownerType, debitEntry.getAccount(), tempArray, voucherID, debitEntryID, entryID, currencyId, iacct, hasCashAccount, false, null, company.getId().toString());
            this.dealOptiAccount(optiType, entry.getAccount(), tempArray, voucherID, debitEntryID, entryID, currencyId, iacct, debitEntry.getAccount(), hasCashAccount, false, null, company.getId().toString());
        }
        BigDecimal tempLocalAmount = maxEntry.getLocalAmount().abs().subtract(minEntry.getLocalAmount().abs());
        BigDecimal tempReportAmount = maxEntry.getReportingAmount().abs().subtract(minEntry.getReportingAmount().abs());
        BigDecimal tempOriginalAmount = null;
        tempOriginalAmount = debitEntry.getCurrency().getId().toString().equals(entry.getCurrency().getId().toString()) ? maxEntry.getOriginalAmount().abs().subtract(minEntry.getOriginalAmount().abs()) : maxEntry.getOriginalAmount().abs().subtract(maxEntry.getOriginalAmount().multiply(minLocalAmount.divide(maxLocalAmount, 4, 4)).abs());
        tempOriginalAmount = tempOriginalAmount.setScale(entry.getCurrency().getPrecision(), 4);
        BigDecimal signum = new BigDecimal(String.valueOf(maxEntry.getLocalAmount().signum()));
        maxEntry.setOriginalAmount(tempOriginalAmount.abs().multiply(signum));
        maxEntry.setLocalAmount(tempLocalAmount.abs().multiply(signum));
        maxEntry.setReportingAmount(tempReportAmount.abs().multiply(signum));
        minEntry.setOriginalAmount(GlUtils.zero);
        minEntry.setLocalAmount(GlUtils.zero);
        minEntry.setReportingAmount(GlUtils.zero);
    }

    private void collect(Context ctx, CompanyOrgUnitInfo company, boolean isCashAccount, VoucherEntryInfo entry, VoucherEntryInfo debitEntry, TAccountInfo ownerType, TAccountInfo optiType, IAccountView iacct, CashflowQueryParam param, VoucherInfo voucher, int initAmountSignum, boolean hasCashAccount, Map difference) throws EASBizException, BOSException {
        String currencyid = param.getCurrency().getId().toString();
        AccountViewInfo account = entry.getAccount();
        AccountViewInfo cashEntryAccount = debitEntry.getAccount();
        boolean isDoublePLAccount = false;
        if (this.isPL(account, difference) && this.isPL(cashEntryAccount, difference)) {
            isDoublePLAccount = true;
        }
        VoucherEntryInfo minEntry = null;
        VoucherEntryInfo maxEntry = null;
        if (debitEntry.getLocalAmount().abs().compareTo(entry.getLocalAmount().abs()) > 0) {
            minEntry = entry;
            maxEntry = debitEntry;
        } else {
            minEntry = debitEntry;
            maxEntry = entry;
        }
        BigDecimal minOrigAmount = minEntry.getOriginalAmount();
        BigDecimal minLocalAmount = minEntry.getLocalAmount();
        BigDecimal minReportAmount = minEntry.getReportingAmount();
        BigDecimal maxOrigAmount = maxEntry.getOriginalAmount();
        BigDecimal maxLocalAmount = maxEntry.getLocalAmount();
        BigDecimal maxReportAmount = maxEntry.getReportingAmount();
        if (!debitEntry.getCurrency().getId().toString().equals(entry.getCurrency().getId().toString()) && debitEntry == maxEntry) {
            minOrigAmount = maxOrigAmount.abs().multiply(minLocalAmount.divide(maxLocalAmount, 4, 4).abs()).multiply(new BigDecimal(String.valueOf(minLocalAmount.signum())));
        }
        minOrigAmount = minOrigAmount.setScale(entry.getCurrency().getPrecision(), 4);
        if (isDoublePLAccount) {
            BigDecimal[] tempArray_forDispose = new BigDecimal[]{minOrigAmount, minLocalAmount, minReportAmount};
            this.cashCounteract(ctx, company, entry, debitEntry, tempArray_forDispose, 1, hasCashAccount);
            this.cashCounteract(ctx, company, debitEntry, entry, tempArray_forDispose, 1, hasCashAccount);
        } else if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyid) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyid) || debitEntry.getCurrency().getId().toString().equals(currencyid)) {
            if (debitEntry.getEntryDC().getValue() == 0) {
                minOrigAmount = minOrigAmount.negate();
                minLocalAmount = minLocalAmount.negate();
                minReportAmount = minReportAmount.negate();
            }
            BigDecimal[] tempArray = new BigDecimal[]{minOrigAmount, minLocalAmount, minReportAmount};
            String voucherid = entry.getBill().getId().toString();
            String entryid = entry.getId().toString();
            String debitEntryid = debitEntry.getId().toString();
            this.dealAccount(ownerType, cashEntryAccount, tempArray, voucherid, debitEntryid, entryid, currencyid, iacct, hasCashAccount, false, null, company.getId().toString());
            this.dealOptiAccount(optiType, account, tempArray, voucherid, debitEntryid, entryid, currencyid, iacct, cashEntryAccount, hasCashAccount, false, null, company.getId().toString());
        }
        BigDecimal tempOriginalAmount = null;
        tempOriginalAmount = debitEntry.getCurrency().getId().toString().equals(entry.getCurrency().getId().toString()) ? maxEntry.getOriginalAmount().subtract(minEntry.getOriginalAmount()) : maxEntry.getOriginalAmount().subtract(maxEntry.getOriginalAmount().multiply(minLocalAmount.divide(maxLocalAmount, 4, 4)));
        tempOriginalAmount = tempOriginalAmount.setScale(entry.getCurrency().getPrecision(), 4);
        maxEntry.setOriginalAmount(tempOriginalAmount);
        maxEntry.setLocalAmount(maxLocalAmount.subtract(minEntry.getLocalAmount()));
        maxEntry.setReportingAmount(maxReportAmount.subtract(minEntry.getReportingAmount()));
        minEntry.setOriginalAmount(GlUtils.zero);
        minEntry.setLocalAmount(GlUtils.zero);
        minEntry.setReportingAmount(GlUtils.zero);
    }

    private void fetchAccount(Context ctx, CashflowQueryParam param) throws EASBizException, BOSException {
        if (this.allAccountMap == null) {
            IAccountView iacct = AccountViewFactory.getLocalInstance((Context)ctx);
            this.allAccountMap = new HashMap();
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("level"));
            sic.add(new SelectorItemInfo("isCash"));
            sic.add(new SelectorItemInfo("isBank"));
            sic.add(new SelectorItemInfo("isCashEquivalent"));
            sic.add(new SelectorItemInfo("parent.id"));
            sic.add(new SelectorItemInfo("parent.name"));
            sic.add(new SelectorItemInfo("parent.number"));
            CompanyOrgUnitInfo company = GlUtils.getCurrentCompany(ctx, param.getCompanyId(), null, false);
            String acctTableId = this.getAccountTableId(ctx, company, param.getEndDate());
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)acctTableId));
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)param.getCompanyId()));
            filter.setMaskString("#0 and #1");
            CoreBaseCollection cols = iacct.getCollection(view);
            for (int i = 0; i < cols.size(); ++i) {
                AccountViewInfo ac = (AccountViewInfo)cols.get(i);
                this.allAccountMap.put(ac.getId().toString(), ac);
            }
        }
    }

    private void dealAccount(TAccountInfo accountInfo, AccountViewInfo account, BigDecimal[] amount, String voucherid, String entryid, String opposingAccountEntryid, String currencyId, IAccountView iacct, boolean hasCashAccount, boolean isSupplementaryAssigned, String cfRecordId, String companyId) throws EASBizException, BOSException {
        if (accountInfo.getAmount() == null) {
            accountInfo.setAmount(SysConstant.BIGZERO);
        }
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            accountInfo.setAmount(accountInfo.getAmount().add(amount[1]));
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            accountInfo.setAmount(accountInfo.getAmount().add(amount[2]));
        } else {
            accountInfo.setAmount(accountInfo.getAmount().add(amount[0]));
        }
        ArrayList list = accountInfo.getEntrys();
        if (!list.contains(voucherid)) {
            list.add(voucherid);
        }
        TAccountInfo info = null;
        while (account != null) {
            String accountId = account.getId().toString();
            AccountViewInfo parent = account.getParent();
            String parentNumber = null;
            if (parent != null) {
                ObjectUuidPK pk = new ObjectUuidPK(parent.getId().toString());
                if ((parent = (AccountViewInfo)this.allAccountMap.get(parent.getId().toString())) == null) {
                    parent = iacct.getAccountViewInfo((IObjectPK)pk);
                    this.allAccountMap.put(parent.getId().toString(), parent);
                }
                parentNumber = parent.getNumber();
            } else {
                parentNumber = "0";
            }
            Map infoMap = accountInfo.getInfoList();
            if (infoMap.containsKey(accountId)) {
                info = (TAccountInfo)infoMap.get(accountId);
            } else {
                info = new TAccountInfo(account.getLevel());
                info.setName(account.getNumber() + "_" + account.getName());
                info.setNumber(account.getNumber());
                info.setCash(account.isIsBank() || account.isIsCash() || account.isIsCashEquivalent());
                info.setDebit(accountInfo.isDebit());
                info.setStatus(5);
                info.setId(accountId);
                info.setParent(parentNumber);
                infoMap.put(accountId, info);
            }
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
                info.setAmount(info.getAmount().add(amount[1]));
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
                info.setAmount(info.getAmount().add(amount[2]));
            } else {
                info.setAmount(info.getAmount().add(amount[0]));
            }
            list = info.getEntrys();
            if (!list.contains(voucherid)) {
                list.add(voucherid);
            }
            List opposingAccountEntry = null;
            opposingAccountEntry = info.getCashitems().get(entryid) != null ? (List)info.getCashitems().get(entryid) : new ArrayList();
            if (StringUtils.isEmpty((String)cfRecordId)) {
                if (hasCashAccount) {
                    opposingAccountEntry.add(new Object[]{opposingAccountEntryid, amount, "1", isSupplementaryAssigned});
                } else {
                    opposingAccountEntry.add(new Object[]{opposingAccountEntryid, amount, isSupplementaryAssigned});
                }
            } else {
                opposingAccountEntry.add(new Object[]{opposingAccountEntryid, amount, isSupplementaryAssigned, cfRecordId});
                opposingAccountEntry.add(new Object[]{opposingAccountEntryid, amount, isSupplementaryAssigned, cfRecordId});
            }
            info.getCashitems().put(entryid, opposingAccountEntry);
            account = parent;
        }
    }

    private void dealOptiAccount(TAccountInfo accountInfo, AccountViewInfo account, BigDecimal[] amount, String voucherid, String entryid, String opposingAccountEntryid, String currencyId, IAccountView iacct, AccountViewInfo ownerAccount, boolean hasCashAccount, boolean isSupplementaryAssigned, String cfRecordId, String companyId) throws EASBizException, BOSException {
        if (accountInfo.getAmount() == null) {
            accountInfo.setAmount(SysConstant.BIGZERO);
        }
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            accountInfo.setAmount(accountInfo.getAmount().add(amount[1]));
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            accountInfo.setAmount(accountInfo.getAmount().add(amount[2]));
        } else {
            accountInfo.setAmount(accountInfo.getAmount().add(amount[0]));
        }
        ArrayList list = accountInfo.getEntrys();
        if (!list.contains(voucherid)) {
            list.add(voucherid);
        }
        TAccountInfo info = null;
        String accountId = account.getId().toString();
        AccountViewInfo parent = account.getParent();
        String parentNumber = null;
        if (parent != null) {
            ObjectUuidPK pk = new ObjectUuidPK(parent.getId().toString());
            if ((parent = (AccountViewInfo)this.allAccountMap.get(parent.getId().toString())) == null) {
                parent = iacct.getAccountViewInfo((IObjectPK)pk);
                this.allAccountMap.put(parent.getId().toString(), parent);
            }
            parentNumber = parent.getNumber();
        } else {
            parentNumber = "0";
        }
        Map infoMap = accountInfo.getInfoList();
        if (infoMap.containsKey(ownerAccount.getId() + accountId)) {
            info = (TAccountInfo)infoMap.get(ownerAccount.getId() + accountId);
        } else {
            info = new TAccountInfo(account.getLevel());
            info.setName(account.getNumber() + "_" + account.getName());
            info.setNumber(account.getNumber());
            info.setCash(account.isIsBank() || account.isIsCash() || account.isIsCashEquivalent());
            info.setDebit(accountInfo.isDebit());
            info.setStatus(5);
            info.setId(accountId);
            info.setParent(parentNumber);
            info.setOwnerAccountNumber(ownerAccount.getNumber().toString());
            infoMap.put(ownerAccount.getId() + accountId, info);
        }
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            info.setAmount(info.getAmount().add(amount[1]));
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            info.setAmount(info.getAmount().add(amount[2]));
        } else {
            info.setAmount(info.getAmount().add(amount[0]));
        }
        list = info.getEntrys();
        if (!list.contains(voucherid)) {
            list.add(voucherid);
        }
        List opposingAccountEntry = null;
        opposingAccountEntry = info.getCashitems().get(entryid) != null ? (List)info.getCashitems().get(entryid) : new ArrayList();
        if (StringUtils.isEmpty((String)cfRecordId)) {
            if (hasCashAccount) {
                opposingAccountEntry.add(new Object[]{opposingAccountEntryid, amount, "1", isSupplementaryAssigned});
            } else {
                opposingAccountEntry.add(new Object[]{opposingAccountEntryid, amount, isSupplementaryAssigned});
            }
        } else {
            opposingAccountEntry.add(new Object[]{opposingAccountEntryid, amount, isSupplementaryAssigned, cfRecordId});
            opposingAccountEntry.add(new Object[]{opposingAccountEntryid, amount, isSupplementaryAssigned, cfRecordId});
        }
        info.getCashitems().put(entryid, opposingAccountEntry);
    }

    private boolean isCashAccount(AccountViewInfo acct) {
        return CashFlowUtils.isCashAccount(acct);
    }

    @Override
    protected Map _queryItem(Context ctx, Map queryMap) throws BOSException, EASBizException {
        HashMap<String, Object> retult = new HashMap<String, Object>();
        String currencyid = (String)queryMap.get("currencyid");
        TAccountInfo accountInfo = (TAccountInfo)queryMap.get("accountInfo");
        String methos = (String)queryMap.get("method");
        if ("SupplementaryItem".equals(methos)) {
            String acctableid = (String)queryMap.get("acctableid");
            String cuid = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            List items = this.querySupplementaryItems(ctx, accountInfo, cuid, acctableid, currencyid);
            retult.put("SupplementaryItem", items);
        } else if ("AcctBySupplementaryItem".equals(methos)) {
            Map accItems = this.queryAccountItems(ctx, accountInfo, currencyid);
            retult.put("AcctBySupplementaryItem", accItems);
        }
        return retult;
    }

    private List querySupplementaryItems(Context ctx, TAccountInfo accountInfo, String cuid, String acctabid, String currencyid) throws BOSException, EASBizException {
        String fnameloc = "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        int level = accountInfo.getLevel() + 1;
        ArrayList list = accountInfo.getEntrys();
        int size = list.size();
        if (size == 0) {
            return new ArrayList();
        }
        String accountId = accountInfo.getId();
        String accountNumber = accountInfo.getNumber();
        String accountOwnerNumberExpandByOpti = accountInfo.getOwnerAccountNumber();
        boolean isByOptiAccount = accountInfo.getStatus() == 9;
        boolean isByAccount = accountInfo.getStatus() == 5;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" from t_gl_cashflowrecord a  ");
        sqlBuffer.append(" inner join t_gl_voucher voucher on a.fvoucherid=voucher.fid");
        sqlBuffer.append("\tinner join t_gl_voucherentry b on a.fopposingAccountentryid=b.fid ");
        sqlBuffer.append("\tinner join t_gl_voucherentry bb on a.fentryid=bb.fid ");
        sqlBuffer.append("\tinner join t_bd_accountview c on c.fid = bb.faccountid  ");
        sqlBuffer.append("\tinner join t_bd_cashflowitem d on d.fid = a.fsupplementaryItemid ");
        if (isByOptiAccount) {
            sqlBuffer.append("\tinner join t_bd_accountview cc on cc.fid = b.faccountid ");
            sqlBuffer.append("\twhere cc.fid = '" + accountId + "' ");
            sqlBuffer.append(" and c.fnumber like '" + accountOwnerNumberExpandByOpti + "%' ");
        } else if (isByAccount) {
            sqlBuffer.append(" where c.fnumber like '" + accountNumber + "%' ");
        } else {
            sqlBuffer.append(" where 1=1 ");
        }
        sqlBuffer.append(" and (((c.fisCash=1 or c.fisBank=1 or c.fisCashEquivalent=1) and a.fprimaryitemid is not null) ");
        sqlBuffer.append(" or (c.fisCash<>1 and c.fisBank<>1 and c.fisCashEquivalent<>1 and a.fprimaryitemid is null)) ");
        if (!GlUtils.isEmpty(accountInfo.getSupplementary())) {
            sqlBuffer.append(" and d.fnumber = '" + accountInfo.getSupplementary() + "'");
        }
        if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyid) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyid)) {
            sqlBuffer.append("and bb.fcurrencyid=? ");
        }
        sqlBuffer.append("and a.fvoucherid in ('");
        for (int i = 0; i < size - 1; ++i) {
            String voucherid = (String)list.get(i);
            sqlBuffer.append(voucherid);
            sqlBuffer.append("','");
        }
        sqlBuffer.append(list.get(size - 1));
        StringBuffer sqlBuffer2 = new StringBuffer();
        sqlBuffer2.append("select a.fid,a.fVoucherID,a.FEntryID,a.FOpposingAccountEntryID,voucher.FHasCashAccount, ");
        sqlBuffer2.append("(case when a.Fsupplementarycoeffient>=0 then 1 else -1 END ) * a.foriginalamount as foriginalamount, ");
        sqlBuffer2.append("(case when a.Fsupplementarycoeffient>=0 then 1 else -1 END ) * a.flocalamount as flocalamount, ");
        sqlBuffer2.append("(case when a.Fsupplementarycoeffient>=0 then 1 else -1 END ) * a.freportingamount as freportingamount, ");
        sqlBuffer2.append("bb.fcurrencyid  svecurrencyid,\t\r\n");
        sqlBuffer2.append("b.fcurrencyid  ovecurrencyid,\t\r\n");
        sqlBuffer2.append("b.foriginalamount  oveamount,\t\r\n");
        sqlBuffer2.append("bb.flocalamount  svelamount,\t\r\n");
        sqlBuffer2.append("d.fnumber,d." + fnameloc + ",d.flevel ,d.fdirection  \t\r\n");
        sqlBuffer2.append(sqlBuffer);
        sqlBuffer2.append("') ");
        HashMap<String, TAccountInfo> taccounts = new HashMap<String, TAccountInfo>();
        Connection con = null;
        PreparedStatement stmt2 = null;
        ResultSet rs2 = null;
        try {
            String number;
            con = this.getConnection(ctx);
            stmt2 = con.prepareStatement(sqlBuffer2.toString());
            ArrayList<String> param = new ArrayList<String>();
            if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyid) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyid)) {
                stmt2.setString(1, currencyid);
                param.add(currencyid);
            }
            rs2 = stmt2.executeQuery();
            HashMap recordMap = new HashMap();
            Map cashMap = new HashMap();
            HashMap cashflowItemToEntries = new HashMap();
            ArrayList<String> voucherList = null;
            ArrayList<Object[]> opposingAccountEntryList = null;
            BigDecimal[] arrAmount = null;
            boolean isDebit = accountInfo.isDebit();
            while (rs2.next()) {
                String voucherId = rs2.getString("fvoucherid");
                number = rs2.getString("fnumber");
                Object obj = recordMap.get(number);
                voucherList = obj != null ? (ArrayList<String>)obj : new ArrayList<String>();
                voucherList.add(voucherId);
                recordMap.put(number, voucherList);
                cashMap = (Map)cashflowItemToEntries.get(number);
                if (cashMap == null) {
                    cashMap = new HashMap();
                }
                cashflowItemToEntries.put(number, cashMap);
                String entryID = rs2.getString("FEntryID");
                String opposingAccountEntryID = rs2.getString("FOpposingAccountEntryID");
                Object cashRecords = cashMap.get(entryID);
                opposingAccountEntryList = cashRecords != null ? (ArrayList<Object[]>)cashRecords : new ArrayList<Object[]>();
                arrAmount = new BigDecimal[]{rs2.getBigDecimal("foriginalamount"), rs2.getBigDecimal("flocalamount"), rs2.getBigDecimal("freportingamount")};
                String cfRecordId = rs2.getString("fid");
                if (rs2.getInt("FHasCashAccount") == 1) {
                    opposingAccountEntryList.add(new Object[]{opposingAccountEntryID, arrAmount, "1", Boolean.TRUE, cfRecordId});
                } else {
                    opposingAccountEntryList.add(new Object[]{opposingAccountEntryID, arrAmount, Boolean.TRUE, cfRecordId});
                }
                cashMap.put(entryID, opposingAccountEntryList);
                TAccountInfo info = (TAccountInfo)taccounts.get(number);
                String name = rs2.getString(fnameloc);
                if (info == null) {
                    info = new TAccountInfo();
                    taccounts.put(number, info);
                    if (rs2.getInt("fdirection") == 1) {
                        info.setDirection(1);
                    } else {
                        info.setDirection(-1);
                    }
                    info.setName(number + "_" + name);
                    info.setNumber(number);
                    info.setLevel(level);
                    info.setCash(true);
                    info.setDebit(isDebit);
                    info.setParent(accountInfo.getNumber());
                    info.setStatus(6);
                }
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyid)) {
                    info.setAmount(info.getAmount().add(arrAmount[1]));
                    continue;
                }
                if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyid)) {
                    info.setAmount(info.getAmount().add(arrAmount[2]));
                    continue;
                }
                info.setAmount(info.getAmount().add(arrAmount[0]));
            }
            Iterator ie = taccounts.keySet().iterator();
            number = null;
            TAccountInfo info = null;
            while (ie.hasNext()) {
                number = (String)ie.next();
                info = (TAccountInfo)taccounts.get(number);
                info.getEntrys().addAll((List)recordMap.get(number));
                info.getCashitems().putAll((Map)cashflowItemToEntries.get(number));
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs2, stmt2, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs2, (Statement)stmt2, (Connection)con);
        return new ArrayList(taccounts.values());
    }

    private Map queryAccountItems(Context ctx, TAccountInfo accountInfo, String currencyId) throws BOSException, EASBizException {
        String number = accountInfo.getNumber();
        ArrayList list = accountInfo.getEntrys();
        HashMap<String, TAccountInfo> accountmap = new HashMap<String, TAccountInfo>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("  from t_gl_cashflowrecord a  ");
        sqlBuffer.append("\tinner join t_gl_voucherentry b on a.fentryid=b.fid ");
        sqlBuffer.append("\tinner join t_bd_accountview c on c.fid = b.faccountid  ");
        sqlBuffer.append("\tinner join t_bd_cashflowitem d on d.fid = a.fsupplementaryItemid ");
        sqlBuffer.append("\tinner join t_gl_voucherentry ove on a.fopposingAccountentryid=ove.fid ");
        sqlBuffer.append("\twhere  d.fnumber=? ");
        if (!"0".equals(accountInfo.getParent())) {
            sqlBuffer.append(" and c.fnumber like '" + accountInfo.getParent() + "%' ");
        }
        if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sqlBuffer.append("and b.fcurrencyid=? ");
        }
        sqlBuffer.append(" and (((c.fisCash=1 or c.fisBank=1 or c.fisCashEquivalent=1) and a.fprimaryitemid is not null) ");
        sqlBuffer.append(" or (c.fisCash<>1 and c.fisBank<>1 and c.fisCashEquivalent<>1 and a.fprimaryitemid is null)) ");
        sqlBuffer.append("\tand a.fvoucherid in ('");
        int size = list.size();
        for (int i = 0; i < size - 1; ++i) {
            String cashflowrecordid = (String)list.get(i);
            sqlBuffer.append(cashflowrecordid);
            sqlBuffer.append("','");
        }
        sqlBuffer.append(list.get(size - 1));
        sqlBuffer.append("') ");
        StringBuffer sqlBuffer1 = new StringBuffer();
        sqlBuffer1.append("select a.fvoucherid,b.fentrydc, ");
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sqlBuffer1.append("sum((case when a.Fsupplementarycoeffient>=0 then 1 else -1 END ) * a.flocalamount) as famount");
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sqlBuffer1.append("sum((case when a.Fsupplementarycoeffient>=0 then 1 else -1 END ) * a.freportingamount) as famount");
        } else {
            sqlBuffer1.append("sum((case when a.Fsupplementarycoeffient>=0 then 1 else -1 END ) * a.foriginalamount) as famount");
        }
        sqlBuffer1.append(",c.fnumber,c.fid,c.flevel");
        sqlBuffer1.append(sqlBuffer);
        sqlBuffer1.append(" group by c.fnumber,c.fid,c.flevel,a.fvoucherid,b.fentrydc");
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        IAccountView iacct = AccountViewFactory.getLocalInstance((Context)ctx);
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(sqlBuffer1.toString());
            stmt.setString(1, number);
            if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
                stmt.setString(2, currencyId);
            }
            rs = stmt.executeQuery();
            TAccountInfo info = null;
            while (rs.next()) {
                String acctnumber = rs.getString("fnumber");
                String id = rs.getString("fid");
                String voucherId = rs.getString("fvoucherid");
                int acctlevel = rs.getInt("flevel");
                int entrydc = rs.getInt("fentrydc");
                BigDecimal amount = rs.getBigDecimal("famount");
                AccountViewInfo accountView = (AccountViewInfo)iacct.getValue((IObjectPK)new ObjectUuidPK(id));
                info = (TAccountInfo)accountmap.get(id);
                if (info == null) {
                    info = new TAccountInfo();
                    info.setName(acctnumber + "_" + accountView.getName());
                    info.setNumber(acctnumber);
                    info.setLevel(acctlevel + 1);
                    info.setAmount(amount);
                    if (1 != entrydc) {
                        info.setDebit(true);
                    } else {
                        info.setDebit(false);
                    }
                    info.setSupplementary(number);
                    info.setCash(false);
                    info.setParent(number);
                    info.setStatus(5);
                } else {
                    info.setAmount(info.getAmount().add(amount));
                }
                ArrayList idlist = info.getEntrys();
                idlist.add(voucherId);
                info.setEntrys(idlist);
                accountmap.put(id, info);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return accountmap;
    }

    private void cashCounteract(Context ctx, CompanyOrgUnitInfo company, VoucherEntryInfo cashentry, VoucherEntryInfo opposingAccountEntry, BigDecimal[] amount, int coef, boolean hasCashAccount) throws EASBizException, BOSException {
        CashFlowUtils.cashCounteract(ctx, company, new CashEntryInfo(cashentry), new CashEntryInfo(opposingAccountEntry), amount, coef, hasCashAccount);
    }

    @Override
    protected void _saveCashflowItem(Context ctx, Map saveParam) throws BOSException, EASBizException {
        CashFlowItemInfo item = (CashFlowItemInfo)saveParam.get("SupplementaryItemInfo");
        if (item == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        CompanyOrgUnitInfo company = GlUtils.getCurrentCompany(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), sic, false);
        List SupplementaryItemList = (List)saveParam.get("accountInfo.SupplementaryItems");
        TAccountInfo accountInfo = (TAccountInfo)saveParam.get("accountInfo");
        ICashflowRecord cfr = CashflowRecordFactory.getLocalInstance(ctx);
        IVoucherEntry ientry = VoucherEntryFactory.getLocalInstance(ctx);
        IAccountView iaccount = AccountViewFactory.getLocalInstance((Context)ctx);
        Map difference = CashFlowUtils.getDifferenceMap(ctx, company.getId().toString());
        AccountViewInfo av_opti = null;
        SelectorItemCollection updateSelector = new SelectorItemCollection();
        updateSelector.add(new SelectorItemInfo("supplementaryItem"));
        updateSelector.add(new SelectorItemInfo("supplementaryCoefficient"));
        updateSelector.add(new SelectorItemInfo("itemFlag"));
        for (int j = 0; j < SupplementaryItemList.size(); ++j) {
            Map SupplementaryItems = (Map)SupplementaryItemList.get(j);
            if (SupplementaryItems.size() <= 0) continue;
            Set keyset = SupplementaryItems.keySet();
            Iterator it = keyset.iterator();
            ICashFlowItem icashflow = CashFlowItemFactory.getLocalInstance((Context)ctx);
            while (it.hasNext()) {
                String entryid = (String)it.next();
                List opposingAccountEntryList = (List)SupplementaryItems.get(entryid);
                VoucherEntryInfo entryInfo = (VoucherEntryInfo)ientry.getValue((IObjectPK)new ObjectUuidPK(entryid));
                int count = opposingAccountEntryList.size();
                for (int k = 0; k < count; ++k) {
                    String coef;
                    Object[] cashflows = (Object[])opposingAccountEntryList.get(k);
                    String opposingAccountEntryid = (String)cashflows[0];
                    VoucherEntryInfo opposingAccountEntryInfo = (VoucherEntryInfo)ientry.getValue((IObjectPK)new ObjectUuidPK(opposingAccountEntryid));
                    av_opti = (AccountViewInfo)iaccount.getValue((IObjectPK)new ObjectUuidPK(opposingAccountEntryInfo.getAccount().getId().toString()));
                    int seq = opposingAccountEntryInfo.getSeq();
                    BigDecimal[] amount = (BigDecimal[])cashflows[1];
                    if (company.getBaseCurrency() != null) {
                        amount[1] = amount[1].setScale(company.getBaseCurrency().getPrecision(), 4);
                    }
                    if (company.getReportCurrency() != null) {
                        amount[2] = amount[2].setScale(company.getReportCurrency().getPrecision(), 4);
                    }
                    if (cashflows[cashflows.length - 1] instanceof String) {
                        ObjectUuidPK pk = new ObjectUuidPK(cashflows[cashflows.length - 1].toString());
                        CashflowRecordInfo cfRecord = (CashflowRecordInfo)cfr.getObjectBaseInfo((IObjectPK)pk);
                        if (cfRecord == null) continue;
                        coef = "-1";
                        if (cfRecord.getPrimaryItem() != null) {
                            if (!this.isPL(av_opti, difference)) {
                                if (EntryDC.DEBIT.equals((Object)entryInfo.getEntryDC())) {
                                    coef = "1";
                                }
                            } else if (this.isPL(av_opti, difference)) {
                                coef = EntryDC.CREDIT.equals((Object)entryInfo.getEntryDC()) ? "1" : "-1";
                            }
                        } else {
                            coef = entryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) ? "1" : "-1";
                        }
                        cfRecord.setSupplementaryItem(item);
                        cfRecord.setSupplementaryCoefficient(Integer.valueOf(coef).intValue());
                        if (cfRecord.getPrimaryItem() != null) {
                            cfRecord.setItemFlag(ItemFlag.BOTH);
                        } else {
                            cfRecord.setItemFlag(ItemFlag.SUPPLEMENTARY);
                        }
                        cfr.updatePartial((CoreBaseInfo)cfRecord, updateSelector);
                        continue;
                    }
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("entry.id", (Object)entryid));
                    filter.getFilterItems().add(new FilterItemInfo("opposingAccountEntry.id", (Object)opposingAccountEntryid));
                    EntityViewInfo view = new EntityViewInfo();
                    view.setFilter(filter);
                    if (!cfr.exists(filter)) {
                        coef = "1";
                        coef = entryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) ? "1" : "-1";
                        amount[0] = amount[0].multiply(new BigDecimal(coef));
                        amount[1] = amount[1].multiply(new BigDecimal(coef));
                        amount[2] = amount[2].multiply(new BigDecimal(coef));
                        CashflowRecordInfo record = new CashflowRecordInfo();
                        record.setOriginalAmount(amount[0]);
                        record.setLocalAmount(amount[1]);
                        record.setReportingAmount(amount[2]);
                        record.setSupplementaryCoefficient(Integer.valueOf(coef).intValue());
                        record.setSupplementaryItem(item);
                        record.setSeq(seq);
                        record.setVoucher(opposingAccountEntryInfo.getBill());
                        record.setEntry(entryInfo);
                        record.setOpposingAccountEntry(opposingAccountEntryInfo);
                        record.setItemFlag(ItemFlag.SUPPLEMENTARY);
                        if (cashflows.length > 2 && cashflows[2] instanceof String && "1".equals(cashflows[2])) {
                            record.setIsSupItem(true);
                        }
                        cfr.addnew((CoreBaseInfo)record);
                        continue;
                    }
                    CoreBaseCollection recordCollection = cfr.getCollection(view);
                    for (int i = 0; i < recordCollection.size(); ++i) {
                        CashFlowItemInfo supItem;
                        CashflowRecordInfo record = (CashflowRecordInfo)recordCollection.get(i);
                        if (accountInfo.getStatus() == 6 && record.getSupplementaryItem() != null && (supItem = (CashFlowItemInfo)icashflow.getValue((IObjectPK)new ObjectUuidPK(record.getSupplementaryItem().getId().toString()))) != null && !accountInfo.getNumber().equals(supItem.getNumber())) continue;
                        String coef2 = "-1";
                        coef2 = entryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) ? "1" : "-1";
                        record.setSupplementaryItem(item);
                        record.setSupplementaryCoefficient(Integer.valueOf(coef2).intValue());
                        record.setItemFlag(ItemFlag.SUPPLEMENTARY);
                        cfr.updatePartial((CoreBaseInfo)record, updateSelector);
                    }
                }
            }
        }
    }

    @Override
    protected void _saveCashflowItem(Context ctx, Map saveParam, boolean isCover) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        CompanyOrgUnitInfo company = GlUtils.getCurrentCompany(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), sic, false);
        List SupplementaryItemList = (List)saveParam.get("accountInfo.SupplementaryItems");
        ICashflowRecord cfr = CashflowRecordFactory.getLocalInstance(ctx);
        IVoucherEntry ientry = VoucherEntryFactory.getLocalInstance(ctx);
        IAccountView iaccount = AccountViewFactory.getLocalInstance((Context)ctx);
        Map difference = CashFlowUtils.getDifferenceMap(ctx, company.getId().toString());
        AccountViewInfo av_opti = null;
        SelectorItemCollection updateSelector = new SelectorItemCollection();
        updateSelector.add(new SelectorItemInfo("supplementaryItem"));
        updateSelector.add(new SelectorItemInfo("supplementaryCoefficient"));
        updateSelector.add(new SelectorItemInfo("itemFlag"));
        for (int j = 0; j < SupplementaryItemList.size(); ++j) {
            Map SupplementaryItems = (Map)SupplementaryItemList.get(j);
            if (SupplementaryItems.size() <= 0) continue;
            Set keyset = SupplementaryItems.keySet();
            for (String entryid : keyset) {
                List opposingAccountEntryList = (List)SupplementaryItems.get(entryid);
                VoucherEntryInfo entryInfo = (VoucherEntryInfo)ientry.getValue((IObjectPK)new ObjectUuidPK(entryid));
                int count = opposingAccountEntryList.size();
                for (int k = 0; k < count; ++k) {
                    String coef;
                    Object[] cashflows = (Object[])opposingAccountEntryList.get(k);
                    String opposingAccountEntryid = (String)cashflows[0];
                    VoucherEntryInfo opposingAccountEntryInfo = (VoucherEntryInfo)ientry.getValue((IObjectPK)new ObjectUuidPK(opposingAccountEntryid));
                    av_opti = (AccountViewInfo)iaccount.getValue((IObjectPK)new ObjectUuidPK(opposingAccountEntryInfo.getAccount().getId().toString()));
                    CashFlowItemInfo attCashFlowItem = null;
                    attCashFlowItem = opposingAccountEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) ? av_opti.getBorrowerAttCashFlowItem() : av_opti.getLenderAttCashFlowItem();
                    if (attCashFlowItem == null) continue;
                    int seq = opposingAccountEntryInfo.getSeq();
                    BigDecimal[] amount = (BigDecimal[])cashflows[1];
                    if (company.getBaseCurrency() != null) {
                        amount[1] = amount[1].setScale(company.getBaseCurrency().getPrecision(), 4);
                    }
                    if (company.getReportCurrency() != null) {
                        amount[2] = amount[2].setScale(company.getReportCurrency().getPrecision(), 4);
                    }
                    if (cashflows[cashflows.length - 1] instanceof String) {
                        ObjectUuidPK pk = new ObjectUuidPK(cashflows[cashflows.length - 1].toString());
                        CashflowRecordInfo cfRecord = (CashflowRecordInfo)cfr.getObjectBaseInfo((IObjectPK)pk);
                        if (cfRecord == null) continue;
                        coef = "-1";
                        if (cfRecord.getPrimaryItem() != null) {
                            if (!this.isPL(av_opti, difference)) {
                                if (EntryDC.DEBIT.equals((Object)entryInfo.getEntryDC())) {
                                    coef = "1";
                                }
                            } else if (this.isPL(av_opti, difference)) {
                                coef = EntryDC.CREDIT.equals((Object)entryInfo.getEntryDC()) ? "1" : "-1";
                            }
                        } else {
                            coef = entryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) ? "1" : "-1";
                        }
                        if (isCover || !isCover && cfRecord.getSupplementaryItem() == null) {
                            if (opposingAccountEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                                cfRecord.setSupplementaryItem(av_opti.getBorrowerAttCashFlowItem());
                            } else {
                                cfRecord.setSupplementaryItem(av_opti.getLenderAttCashFlowItem());
                            }
                        }
                        cfRecord.setSupplementaryCoefficient(Integer.valueOf(coef).intValue());
                        if (cfRecord.getPrimaryItem() != null) {
                            cfRecord.setItemFlag(ItemFlag.BOTH);
                        } else {
                            cfRecord.setItemFlag(ItemFlag.SUPPLEMENTARY);
                        }
                        cfr.updatePartial((CoreBaseInfo)cfRecord, updateSelector);
                        continue;
                    }
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("entry.id", (Object)entryid));
                    filter.getFilterItems().add(new FilterItemInfo("opposingAccountEntry.id", (Object)opposingAccountEntryid));
                    EntityViewInfo view = new EntityViewInfo();
                    view.setFilter(filter);
                    if (!cfr.exists(filter)) {
                        coef = "1";
                        coef = entryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) ? "1" : "-1";
                        amount[0] = amount[0].multiply(new BigDecimal(coef));
                        amount[1] = amount[1].multiply(new BigDecimal(coef));
                        amount[2] = amount[2].multiply(new BigDecimal(coef));
                        CashflowRecordInfo record = new CashflowRecordInfo();
                        record.setOriginalAmount(amount[0]);
                        record.setLocalAmount(amount[1]);
                        record.setReportingAmount(amount[2]);
                        record.setSupplementaryCoefficient(Integer.valueOf(coef).intValue());
                        if (opposingAccountEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                            record.setSupplementaryItem(av_opti.getBorrowerAttCashFlowItem());
                        } else {
                            record.setSupplementaryItem(av_opti.getLenderAttCashFlowItem());
                        }
                        record.setSeq(seq);
                        record.setVoucher(opposingAccountEntryInfo.getBill());
                        record.setEntry(entryInfo);
                        record.setOpposingAccountEntry(opposingAccountEntryInfo);
                        record.setItemFlag(ItemFlag.SUPPLEMENTARY);
                        if (cashflows.length > 2 && cashflows[2] instanceof String && "1".equals(cashflows[2])) {
                            record.setIsSupItem(true);
                        }
                        cfr.addnew((CoreBaseInfo)record);
                        continue;
                    }
                    CoreBaseCollection recordCollection = cfr.getCollection(view);
                    for (int i = 0; i < recordCollection.size(); ++i) {
                        CashflowRecordInfo record = (CashflowRecordInfo)recordCollection.get(i);
                        String coef2 = "-1";
                        coef2 = entryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) ? "1" : "-1";
                        if (isCover || !isCover && record.getSupplementaryItem() == null) {
                            if (opposingAccountEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                                record.setSupplementaryItem(av_opti.getBorrowerAttCashFlowItem());
                            } else {
                                record.setSupplementaryItem(av_opti.getLenderAttCashFlowItem());
                            }
                        }
                        record.setSupplementaryCoefficient(Integer.valueOf(coef2).intValue());
                        record.setItemFlag(ItemFlag.SUPPLEMENTARY);
                        cfr.updatePartial((CoreBaseInfo)record, updateSelector);
                    }
                }
            }
        }
    }

    @Override
    protected void _cacelCashflowItem(Context ctx, Map cancelMap) throws BOSException, EASBizException {
        List cashitemList = (List)cancelMap.get("accountInfo.SupplementaryItems");
        TAccountInfo accountInfo = (TAccountInfo)cancelMap.get("accountInfo");
        HashSet<String> voucherIds = new HashSet<String>();
        ICashflowRecord cfr = CashflowRecordFactory.getLocalInstance(ctx);
        for (int j = 0; j < cashitemList.size(); ++j) {
            Map cashitems = (Map)cashitemList.get(j);
            Set keyset = cashitems.keySet();
            for (String entryid : keyset) {
                List cashEntry = (List)cashitems.get(entryid);
                int size = cashEntry.size();
                for (int i = 0; i < size; ++i) {
                    Object[] cashflows = (Object[])cashEntry.get(i);
                    String oppEntryId = (String)cashflows[0];
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("entry.id", (Object)entryid));
                    filter.getFilterItems().add(new FilterItemInfo("opposingAccountEntry.id", (Object)oppEntryId));
                    if (accountInfo.getStatus() == 6) {
                        filter.getFilterItems().add(new FilterItemInfo("supplementaryItem.number", (Object)accountInfo.getNumber()));
                    }
                    EntityViewInfo view = new EntityViewInfo();
                    view.setFilter(filter);
                    CoreBaseCollection records = cfr.getCollection(view);
                    int rSize = records.size();
                    for (int k = 0; k < rSize; ++k) {
                        ObjectUuidPK pk;
                        CashflowRecordInfo record = (CashflowRecordInfo)records.get(k);
                        if (record == null) continue;
                        if (2 == record.getItemFlag().getValue()) {
                            pk = new ObjectUuidPK(record.getId());
                            cfr.delete((IObjectPK)pk);
                            if (record.getVoucher() == null) continue;
                            voucherIds.add(record.getVoucher().getId().toString());
                            continue;
                        }
                        if (record.getPrimaryItem() == null) continue;
                        pk = new ObjectUuidPK(record.getId());
                        record.setSupplementaryCoefficient(0);
                        record.setSupplementaryItem(null);
                        cfr.update((IObjectPK)pk, (CoreBaseInfo)record);
                    }
                }
            }
        }
        if (voucherIds.size() > 0) {
            StringBuffer sqlDelete = new StringBuffer();
            sqlDelete.append("delete from t_gl_cashflowrecord where fitemflag=7 and fvoucherid in(");
            Iterator it = voucherIds.iterator();
            while (it.hasNext()) {
                sqlDelete.append("'").append(it.next()).append("',");
            }
            sqlDelete.setLength(sqlDelete.length() - 1);
            sqlDelete.append(")");
            DbUtil.execute((Context)ctx, (String)sqlDelete.toString());
        }
    }

    private String getAccountTableId(Context ctx, CompanyOrgUnitInfo company, Date endDate) throws EASBizException, BOSException {
        PeriodInfo endPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)endDate, (CompanyOrgUnitInfo)company);
        if (endPeriod == null) {
            return company.getAccountTable().getId().toString();
        }
        AccountRefContrastInfo ar = null;
        ar = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(company.getId().toString(), company.getAccountTable().getId().toString(), endPeriod.getPeriodYear(), endPeriod.getPeriodNumber());
        return ar == null ? company.getAccountTable().getId().toString() : ar.getEnabledAcctTable().getId().toString();
    }
}

