/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashFlowTAccountFacadeFactory;
import com.kingdee.eas.fi.gl.CashflowQueryParam;
import com.kingdee.eas.fi.gl.CashflowTAccountInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.ICashFlowTAccountFacade;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.app.AbstractCashFlowTAccountFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.CashFlowTAccountDao;
import com.kingdee.eas.fi.gl.app.GLCashflowRepair;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CashFlowTAccountFacadeControllerBean
extends AbstractCashFlowTAccountFacadeControllerBean {
    private static final long serialVersionUID = -6348619947387287756L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.CashFlowTAccountFacadeControllerBean");

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        RptParams rp = new RptParams();
        rp.setObject("getAllCurrency", (Object)RptServerUtil.getAllCurrency(company.getId().toString(), ctx));
        company.setDescription(null);
        rp.setObject("pe", (Object)new PeriodEntity(RptServerUtil.getPeriodRange(ctx, company)));
        rp.setObject("currentPeriod", (Object)this.getCurrentPeriodInfo(ctx, company));
        return rp;
    }

    @Override
    protected List[] _queryCashflowTAccountInfo(Context ctx, CashflowQueryParam condition) throws BOSException, EASBizException {
        return this.getDao(ctx, condition).getCashflowTAccount();
    }

    @Override
    protected List _expand(Context ctx, int action, CashflowQueryParam condition, CashflowTAccountInfo parent) throws BOSException, EASBizException {
        switch (action) {
            case 1: {
                return this.getDao(ctx, condition).expandChildren(parent);
            }
            case 4: {
                return this.getDao(ctx, condition).expandCashflowItem(parent);
            }
            case 2: {
                return this.getDao(ctx, condition).expandAssistantHG(parent);
            }
            case 3: {
                return this.getDao(ctx, condition).expandOppAssistantHG(parent);
            }
        }
        return null;
    }

    @Override
    protected Map _applyDefaultCashflowItem(Context ctx, CashflowQueryParam condition, boolean isCover) throws BOSException, EASBizException {
        return this.getDao(ctx, condition).applyDefaultCashflowItem(isCover);
    }

    @Override
    protected Map _applyCashflowItem(Context ctx, CashflowQueryParam condition, CashflowTAccountInfo info, CashFlowItemInfo cfItem) throws BOSException, EASBizException {
        return this.getDao(ctx, condition).applyCashflowItem(info, cfItem);
    }

    @Override
    protected Map _removeCashflowItem(Context ctx, CashflowQueryParam condition, CashflowTAccountInfo info) throws BOSException, EASBizException {
        return this.getDao(ctx, condition).cancelCFItemToSplitRec(info);
    }

    @Override
    protected void _splitTAccountVoucher(Context ctx, CashflowQueryParam condition) throws BOSException, EASBizException {
        this.getDao(ctx, condition).splitTAccountVoucher();
    }

    @Override
    protected Set _getUnAssignedCFIVoucherIds(Context ctx, CashflowQueryParam condition, CashflowTAccountInfo info) throws BOSException, EASBizException {
        return this.getDao(ctx, condition).getUnAssignedCFIVoucherIds(info);
    }

    @Override
    protected Set _getVoucherIds(Context ctx, CashflowQueryParam condition, CashflowTAccountInfo info) throws BOSException, EASBizException {
        return this.getDao(ctx, condition).getVoucherIds(info);
    }

    @Override
    protected Map _getTAccountCashflowInfos(Context ctx, CashflowQueryParam condition, CashflowTAccountInfo info, boolean includeAssigned) throws BOSException, EASBizException {
        return this.getDao(ctx, condition).getTAccountCashflowInfos(info, includeAssigned);
    }

    protected CashFlowTAccountDao getDao(Context ctx, CashflowQueryParam conditon) {
        return new CashFlowTAccountDao(ctx, conditon);
    }

    protected PeriodInfo getCurrentPeriodInfo(Context ctx, CompanyOrgUnitInfo company) throws BOSException, ReportBizException, EASBizException {
        PeriodInfo currentPeriod = null;
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.GENERALLEDGER.getValue())));
        fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("currentPeriod.id"));
        sic.add(new SelectorItemInfo("currentPeriod.type.id"));
        sic.add(new SelectorItemInfo("currentPeriod.periodYear"));
        sic.add(new SelectorItemInfo("currentPeriod.periodNumber"));
        sic.add(new SelectorItemInfo("currentPeriod.beginDate"));
        sic.add(new SelectorItemInfo("currentPeriod.endDate"));
        SystemStatusCtrolCollection col = ictrol.getSystemStatusCtrolCollection(view);
        currentPeriod = col.size() > 0 ? col.get(0).getCurrentPeriod() : null;
        return currentPeriod;
    }

    @Override
    protected Map _getVoucherIdsTemp(Context ctx, CashflowQueryParam condition, CashflowTAccountInfo info) throws BOSException, EASBizException {
        return this.getDao(ctx, condition).getVoucherIdsTemp(info);
    }

    @Override
    protected void _smartAccountApplyDefaultCashflowItem(Context ctx, String companyNumbers, int startPeriod, int endPeriod, boolean IncludeNoPosted, boolean isCover) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)companyNumbers)) {
            logger.error((Object)"companyNumbers\u4e3a\u7a7a\uff01\uff01");
            throw new GLException(GLException.CANNOT_FIND_COMPANY, new Object[]{""});
        }
        String[] companyNumberArr = companyNumbers.split(";");
        try {
            int startPeriodYear = startPeriod / 100;
            int startPeriodNumber = startPeriod % 100;
            int endPeriodYear = endPeriod / 100;
            int endPeriodNumber = endPeriod % 100;
            ArrayList<CompanyOrgUnitInfo> companys = new ArrayList<CompanyOrgUnitInfo>();
            for (int i = 0; i < companyNumberArr.length; ++i) {
                CompanyOrgUnitInfo company = GlWebServiceUtil.getCompany(ctx, companyNumberArr[i].trim());
                if (company == null) {
                    throw new GLException(GLException.CANNOT_FIND_COMPANY, new Object[]{companyNumberArr[i]});
                }
                companys.add(company);
            }
            ICashFlowTAccountFacade icahsflowTaccount = CashFlowTAccountFacadeFactory.getLocalInstance(ctx);
            for (CompanyOrgUnitInfo company : companys) {
                icahsflowTaccount.repairSplitRecordsNewTrans(company.getId().toString(), startPeriod, endPeriod);
            }
            for (CompanyOrgUnitInfo company : companys) {
                CashflowQueryParam condition = new CashflowQueryParam();
                condition.setCashFilt(true);
                condition.setCurrency(null);
                condition.setPeriod(true);
                condition.setStartYear(startPeriodYear);
                condition.setStartPeriod(startPeriodNumber);
                condition.setEndYear(endPeriodYear);
                condition.setEndPeriod(endPeriodNumber);
                condition.setIndcludeNoPosted(IncludeNoPosted);
                condition.setCompanyId(company.getId().toString());
                icahsflowTaccount.applyDefaultCashflowItem(condition, isCover);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _repairSplitRecordsBatch(Context ctx, String companyNumbers, int startPeriod, int endPeriod) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)companyNumbers)) {
            logger.error((Object)"companyNumbers\u4e3a\u7a7a\uff01\uff01");
            throw new GLException(GLException.CANNOT_FIND_COMPANY, new Object[]{""});
        }
        String[] companyNumberArr = companyNumbers.split(";");
        try {
            for (int i = 0; i < companyNumberArr.length; ++i) {
                CompanyOrgUnitInfo company = GlWebServiceUtil.getCompany(ctx, companyNumberArr[i].trim());
                if (company == null) {
                    throw new GLException(GLException.CANNOT_FIND_COMPANY, new Object[]{companyNumberArr[i]});
                }
                CashFlowTAccountFacadeFactory.getLocalInstance(ctx).repairSplitRecordsNewTrans(company.getId().toString(), startPeriod, endPeriod);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _repairSplitRecordsNewTrans(Context ctx, String companyID, int startPeriod, int endPeriod) throws BOSException, EASBizException {
        GLCashflowRepair repair = new GLCashflowRepair(ctx, companyID);
        try {
            repair.repairSplitRecord(startPeriod, endPeriod);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }
}

