/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashFlowException;
import com.kingdee.eas.fi.gl.CashFlowFilterPara;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLFlagCollection;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.CashFlowUtils;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAccountBalQueryHelper;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class CashFlowUnionDao {
    static final Logger log = Logger.getLogger(CashFlowUnionDao.class);
    private static final long serialVersionUID = 5002459146621338427L;
    private static final String resClassName = "com.kingdee.eas.fi.gl.app.CashFlowDispayResource";
    private int lineIndex = 1;
    private static final int ITEM_ARRAY_LETH = 12;
    CompanyOrgUnitInfo curCompany = null;
    private int maxCompanyLevel = 0;
    private String initAmountTempName = null;

    private String getResource(Context ctx, String name) {
        return ResourceBase.getString((String)resClassName, (String)name, (Locale)ctx.getLocale());
    }

    protected Object[] _genCashFlow(Context ctx, CashFlowFilterPara cashFlowFilterPara) throws BOSException, EASBizException {
        this.curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        this.maxCompanyLevel = this.getMaxCompanyLevel(ctx, cashFlowFilterPara.getCompanyIds());
        if (this.maxCompanyLevel == -1) {
            this.maxCompanyLevel = this.curCompany.getLevel();
        }
        short yearTo = cashFlowFilterPara.getYearTo();
        int startPeriod = this.getMinStartPeriod(ctx, cashFlowFilterPara.getCompanyIds());
        int yearFrom = startPeriod / 100;
        if (yearFrom != yearTo) {
            startPeriod = yearTo * 100 + 1;
        }
        if (cashFlowFilterPara.isIsWeb()) {
            if (cashFlowFilterPara.getCompanyTreeNode() instanceof CompanyOrgUnitInfo) {
                this.curCompany = (CompanyOrgUnitInfo)cashFlowFilterPara.getCompanyTreeNode();
            } else {
                SimpleCompanyUserObject obj = (SimpleCompanyUserObject)((DefaultMutableTreeNode)cashFlowFilterPara.getCompanyTreeNode()).getUserObject();
                this.curCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(obj.getCompanyId()));
            }
        }
        if (cashFlowFilterPara.getUseCompany() != null) {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(cashFlowFilterPara.getUseCompany().getCompanyId()));
            cashFlowFilterPara.getUseCompany().setLevel(company.getLevel());
            cashFlowFilterPara.getUseCompany().setLongNumber(company.getLongNumber());
        }
        Map cashBalance = null;
        Map sumCashBalance = null;
        if (cashFlowFilterPara.isTermOrDate() || cashFlowFilterPara.isDisplayCashBalanceForBeginAndEnd()) {
            cashBalance = this.getCashBalance(ctx, cashFlowFilterPara);
            sumCashBalance = this.getSumCashBalance(ctx, cashFlowFilterPara, startPeriod);
        }
        Object[] arrayReturn = new Object[5];
        this.lineIndex = 0;
        HashSet<String> ids = new HashSet<String>();
        Collections.addAll(ids, cashFlowFilterPara.getCompanyIds().replaceAll("'", "").split(","));
        Map<String, Boolean> initStatus = this.getInitStatusByNameAndIds(ctx, "cashflowInit", ids);
        StringBuffer companyIds = new StringBuffer();
        for (String id : ids) {
            if (!initStatus.get(id).booleanValue()) continue;
            if (companyIds.length() > 0) {
                companyIds.append(",");
            }
            companyIds.append("'" + id + "'");
        }
        Map initMap = null;
        if (yearFrom == yearTo) {
            initMap = this.getInitAmountMap(ctx, cashFlowFilterPara, companyIds.toString());
        }
        if (cashFlowFilterPara.getType() == -1 || cashFlowFilterPara.getType() == 0) {
            Vector vecPrimaryItem = this.selectDataFromDB(ctx, cashFlowFilterPara, 0);
            if (vecPrimaryItem == null) {
                return null;
            }
            vecPrimaryItem = this.sortCashFlowRecord(vecPrimaryItem, cashFlowFilterPara.getLevel());
            Map primaryMap = this.getSumAmountMap(ctx, cashFlowFilterPara, 0, startPeriod);
            this.combineSumMap(vecPrimaryItem, primaryMap, cashFlowFilterPara);
            this.combineInitMap(vecPrimaryItem, initMap, cashFlowFilterPara);
            vecPrimaryItem = this.combinDataForPrimaryItem(ctx, vecPrimaryItem, cashFlowFilterPara, cashBalance, sumCashBalance);
            arrayReturn[0] = vecPrimaryItem;
        }
        if (cashFlowFilterPara.getType() == -1 || cashFlowFilterPara.getType() == 15 || cashFlowFilterPara.getType() == 1) {
            Vector vecSecondary = this.selectDataFromDB(ctx, cashFlowFilterPara, 1);
            Map secondaryMap = this.getSumAmountMap(ctx, cashFlowFilterPara, 1, startPeriod);
            this.combineSumMap(vecSecondary, secondaryMap, cashFlowFilterPara);
            this.combineInitMap(vecSecondary, initMap, cashFlowFilterPara);
            vecSecondary = this.combinDataForSecondaryItem(ctx, cashFlowFilterPara, vecSecondary, companyIds.toString());
            arrayReturn[1] = vecSecondary;
        }
        if (cashFlowFilterPara.getType() == -1 || cashFlowFilterPara.getType() == 2) {
            Vector vecSupplement = this.selectDataFromDB(ctx, cashFlowFilterPara, 2);
            Map supplementMap = this.getSumAmountMap(ctx, cashFlowFilterPara, 2, startPeriod);
            this.combineSumMap(vecSupplement, supplementMap, cashFlowFilterPara);
            this.combineInitMap(vecSupplement, initMap, cashFlowFilterPara);
            vecSupplement = this.combinDataForSupplementaryItem(ctx, cashFlowFilterPara, vecSupplement);
            arrayReturn[2] = vecSupplement;
        }
        if (cashFlowFilterPara.getType() == 7 || cashFlowFilterPara.getType() == 8 || cashFlowFilterPara.getType() == 9) {
            Map cashSumMap = this.getSumCashAmount(ctx, cashFlowFilterPara, startPeriod);
            arrayReturn[0] = this.getPeriodAccountBalance(ctx, cashFlowFilterPara, cashBalance, sumCashBalance, cashSumMap);
        }
        if (cashBalance != null) {
            Vector vecCash = this.getAdditionOfCash(ctx, cashFlowFilterPara, cashBalance, sumCashBalance);
            arrayReturn[3] = vecCash;
        }
        arrayReturn[4] = cashFlowFilterPara;
        return arrayReturn;
    }

    private int getMinStartPeriod(Context ctx, String companyIds) throws BOSException {
        if (companyIds == null) {
            throw new BOSException("param 'companyIds' is null.");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select min(p.FNUMBER) from T_BD_SystemStatusCtrol sysStaCtr  \n");
        sql.append(" inner join T_BD_SystemStatus sysSta on sysStaCtr.FSystemStatusID = sysSta.FID \n");
        sql.append(" left join T_BD_PERIOD p on p.fid = sysStaCtr.FStartPeriodID \n");
        sql.append(" where sysStaCtr.FCompanyID in (" + companyIds + ") \n");
        sql.append(" and sysSta.FName = 6 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int startPeriod = 0;
        try {
            while (rs.next()) {
                startPeriod = rs.getInt(1);
            }
        }
        catch (SQLException throwables) {
            throw new BOSException("query exception, result is null.");
        }
        return startPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getInitAmountMap(Context ctx, CashFlowFilterPara cashFlowFilterPara, String companyIds) throws BOSException, EASBizException {
        if (companyIds.length() == 0) {
            return Collections.EMPTY_MAP;
        }
        StringBuffer sql = new StringBuffer(512);
        Connection conn = null;
        IRowSet rs = null;
        HashMap<String, MapParam> map = new HashMap<String, MapParam>();
        try {
            if (this.initAmountTempName == null) {
                String itemFilterSql = cashFlowFilterPara.getItemFilterSql();
                String amountField = null;
                String currencyId = cashFlowFilterPara.getCurrencyId();
                boolean isGlCurrency = currencyId.equals(this.getGeneralLocalCurrency());
                boolean isGLRptCurrency = currencyId.equals(this.getGeneralReportCurrency());
                amountField = isGlCurrency ? "FLocalAmount" : (isGLRptCurrency ? "FReportingAmount" : "FOriginalAmount");
                sql.append(" select FID,FLongnumber,FName,FAsstID,FCashType,FCashItemId,sum(FAmount) as FAmount,FCompanyID,FParentID,FCompanyLevel,FItemLevel from ( \n");
                sql.append(" select cfi2.fid as FID, cfi2.flongnumber, null as fname, null as FAsstID, 1 as FCashType,cfin.FCashflowItemID as FCashItemId, \n");
                sql.append(" cfin.FAmount as FAmount, cfin.FCompanyID, cfin.FParentID, cfin.FCompanyLevel, cfi2.flevel as FItemLevel from ");
                sql.append(" T_BD_CashFlowItem cfi1 ");
                sql.append(" inner join T_BD_CashFlowItem cfi2 ");
                sql.append(" on (charindex(cfi2.FLongNumber||'!',cfi1.FLongNumber) = 1 ");
                sql.append(" or cfi2.FLongNumber=cfi1.FLongNumber) ");
                sql.append(" left outer join (");
                sql.append("select cfin.FCashflowItemID,cfin.FCompanyID,cp.FParentID,cp.FLEVEL FCompanyLevel,cfin.");
                sql.append(amountField);
                sql.append(" as FAmount");
                sql.append(" from T_GL_CashflowInit cfin \n");
                sql.append(" left join T_ORG_COMPANY cp on cp.FID = cfin.FCompanyID \n");
                sql.append(" where cfin.FCompanyID in (" + companyIds + ") \n");
                if (itemFilterSql != null) {
                    sql.append(" and cfin.FCashflowItemID in ( ").append(itemFilterSql).append(" ) ");
                }
                if (!isGlCurrency && !isGLRptCurrency) {
                    sql.append(" and cfin.FCurrencyID = '" + currencyId + "' \r\n");
                }
                sql.append(" )as cfin");
                sql.append(" on cfin.FCashflowItemID = cfi1.FID");
                boolean isAsst = cashFlowFilterPara.isDisplayAsst();
                if (isAsst) {
                    HashSet<String> ids = new HashSet<String>();
                    Collections.addAll(ids, companyIds.replaceAll("'", "").split(","));
                    Map<String, Boolean> initStatus = this.getInitStatusByNameAndIds(ctx, "cashflowGrpAsst", ids);
                    StringBuffer asstCompanyIds = new StringBuffer();
                    for (String id : ids) {
                        if (!initStatus.get(id).booleanValue()) continue;
                        if (asstCompanyIds.length() > 0) {
                            asstCompanyIds.append(", ");
                        }
                        asstCompanyIds.append("'" + id + "'");
                    }
                    if (asstCompanyIds.length() > 0) {
                        StringBuffer asstSql = new StringBuffer();
                        asstSql.append(" union all \n");
                        asstSql.append(" select init.FCashflowItemID as FID, cfi.flongnumber, \n");
                        asstSql.append(" hg.FLongNameGroup_l2 as FName, asst.FAssistGrpID as FAsstID, asst.FType as FCashType,init.FCashflowItemID, \n");
                        asstSql.append(" asst." + amountField);
                        asstSql.append(" as\u3000FAmount, \n");
                        asstSql.append(" cp.fid as FCompanyID, cp.FParentID, cp.FLEVEL as FCompanyLevel, cfi.FLEVEL as FItemLevel \n");
                        asstSql.append(" from T_GL_CashflowGrpAsst as asst \n");
                        asstSql.append(" left outer join T_GL_CashflowInit as init \n");
                        asstSql.append(" on init.FID = asst.FCflowInitID \n");
                        asstSql.append(" left outer join t_bd_assistanthg hg \n");
                        asstSql.append(" on asst.FAssistGrpID = hg.fid \n");
                        asstSql.append(" left outer join T_BD_CashFlowItem cfi \n");
                        asstSql.append(" on cfi.fid = init.FCASHFLOWITEMID \n");
                        asstSql.append(" left outer join T_ORG_COMPANY cp  \n");
                        asstSql.append(" on cp.fid = init.FCOMPANYID \n");
                        asstSql.append(" where init.FCompanyID in (" + asstCompanyIds + ") \n");
                        if (itemFilterSql != null) {
                            asstSql.append(" and init.FCashflowItemID in ( ").append(itemFilterSql).append(" ) ");
                        }
                        sql.append(asstSql);
                    }
                }
                sql.append(" ) as A where FCashItemId=FID group by FID,FLongnumber,FCompanyID,FParentID,FCompanyLevel,FName,FAsstID,FCashType,FCashItemId,FItemLevel having sum(FAmount)<>0");
                SqlParams sp = new SqlParams();
                conn = this.getConnection(ctx);
                this.initAmountTempName = TempTablePool.getInstance((Context)ctx).createTempTable(" create table query_init_amount (FID varchar(80), FLongnumber varchar(400),FName varchar(400),FAsstID varchar(80),FCashType int,FCashItemId varchar(80),FAMOUNT decimal(28, 10),FCompanyID varchar(80),FParentID varchar(80),FCompanyLevel int,FItemLevel int) ");
                DbUtil.execute((Context)ctx, (String)("insert into " + this.initAmountTempName + sp.getSqlWithParams(sql.toString())));
                sql.setLength(0);
                sql.append(" insert into " + this.initAmountTempName + " (FID,FLongnumber,FCashType,FCashItemId,FAmount,FCompanyID,FParentID,FCompanyLevel,FItemLevel ) \n");
                sql.append(" select t.fid, t.FLongnumber, 1 FCashType, t.FCashItemId, sum(t.FAmount) FAmount, cp.fid FCompanyID, cp.FParentID, cp.FLevel FCompanyLevel, t.FItemLevel \n");
                sql.append(" from " + this.initAmountTempName + " t \n");
                sql.append(" inner join t_org_company cp on cp.fid = t.fparentid \n");
                sql.append(" where t.fcompanyLevel = ? \n");
                sql.append(" and t.fcashtype = 1 \n");
                sql.append(" group by t.fid, t.FLongnumber, t.FCashItemId, cp.fid, cp.FParentID, cp.FLevel, t.FItemLevel \n");
                PreparedStatement ps = conn.prepareStatement(sql.toString());
                for (int i = this.maxCompanyLevel; i > this.curCompany.getLevel(); --i) {
                    ps.setInt(1, i);
                    ps.addBatch();
                }
                ps.executeBatch();
                ps.clearBatch();
                SQLUtils.cleanup((Statement)ps);
            }
            sql.setLength(0);
            sql.append(" select FLongnumber, FName, FAsstID, FCashType, FAmount, FCompanyID, FCompanyLevel \n");
            sql.append(" from " + this.initAmountTempName + " \n");
            if (cashFlowFilterPara.getUseCompany() != null) {
                sql.append(" where FCompanyLevel > " + cashFlowFilterPara.getUseCompany().getLevel());
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String FLongNumber = rs.getString(1);
                String FName = rs.getString(2);
                String FAsstID = rs.getString(3);
                CashflowTypeEnum FCashType = CashflowTypeEnum.getEnum((int)rs.getInt(4));
                BigDecimal FAmount = rs.getBigDecimal(5);
                String FCompanyID = rs.getString(6);
                int FCompanyLevel = rs.getInt(7);
                if (FLongNumber == null || FAmount == null) continue;
                MapParam m = new MapParam();
                m.FLongNumber = FLongNumber;
                m.FName = FName;
                m.FAsstID = FAsstID;
                m.FCashType = FCashType;
                m.FAmount = FAmount;
                m.FCompanyID = FCompanyID;
                m.FCompanyLevel = FCompanyLevel;
                String key = FCompanyID + FLongNumber + (StringUtils.isEmpty((String)FAsstID) ? "" : FAsstID) + FCashType;
                map.put(key, m);
            }
            if (cashFlowFilterPara.getTotalType() == 2) {
                sql.setLength(0);
                sql.append(" select FCompanyID, sum(FAmount) from " + this.initAmountTempName);
                sql.append(" where FItemLevel = 1 and fcompanyLevel > " + cashFlowFilterPara.getUseCompany().getLevel());
                sql.append(" group by FCompanyID ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    String companyID = rs.getString(1);
                    BigDecimal amount = rs.getBigDecimal(2);
                    MapParam m = new MapParam();
                    m.FCompanyID = companyID;
                    m.FAmount = amount;
                    String key = companyID + "null";
                    map.put(key, m);
                }
            }
            SQLUtils.cleanup((ResultSet)rs, null, conn);
            return map;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
            catch (Exception e2) {
                e2.printStackTrace();
                return map;
            }
        }
        finally {
            SQLUtils.cleanup(rs, null, conn);
        }
    }

    private Map<String, Boolean> getInitStatusByNameAndIds(Context ctx, String name, Set<String> companyIds) throws BOSException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)name, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", companyIds, CompareType.INCLUDE));
        view.setFilter(filter);
        GLFlagCollection col = GLFlagFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < col.size(); ++i) {
            result.put(col.get(i).getOrgUnit().getId().toString(), "true".equals(col.get(i).getValue()));
        }
        if (col.size() != companyIds.size()) {
            for (String id : companyIds) {
                if (result.containsKey(id)) continue;
                result.put(id, false);
            }
        }
        return result;
    }

    private Vector selectDataFromDB(Context ctx, CashFlowFilterPara cashFlowFilterPara, int itemType) throws BOSException, EASBizException {
        String tempTable = cashFlowFilterPara.getTempTableName();
        if (tempTable == null) {
            tempTable = this.createUnionCashTable(ctx, cashFlowFilterPara);
        }
        Vector vec = new Vector();
        StringBuffer sql = new StringBuffer();
        if (cashFlowFilterPara.getTotalType() == -1) {
            SimpleCompanyUserObject useCompany;
            sql.append("select * from ").append(tempTable).append(" \r\n");
            if (cashFlowFilterPara.getUseCompany() == null) {
                if (cashFlowFilterPara.getExpandCompanyLevel() > 1) {
                    sql.append(" where companyLevel >= ").append(this.curCompany.getLevel());
                    sql.append(" and companyLevel <=").append(this.curCompany.getLevel() + cashFlowFilterPara.getExpandCompanyLevel() - 1);
                } else {
                    sql.append(" where companyLevel = ");
                    sql.append(this.curCompany.getLevel());
                }
            } else if (!cashFlowFilterPara.isExpandAll()) {
                sql.append(" where companyLevel = ");
                if (cashFlowFilterPara.isDisplayAsst() && cashFlowFilterPara.getUseCompany().isHasAsstItem()) {
                    sql.append(cashFlowFilterPara.getUseCompany().getLevel());
                } else {
                    sql.append(cashFlowFilterPara.getUseCompany().getLevel() + 1);
                }
            }
            if (cashFlowFilterPara.getUseCompany() != null && cashFlowFilterPara.isExpandAll()) {
                sql.append(" where FLevel <= ");
            } else {
                sql.append(" and FLevel <= ");
            }
            if (cashFlowFilterPara.getLevel() == 1) {
                sql.append(2);
            } else {
                sql.append(cashFlowFilterPara.getLevel());
            }
            sql.append(" and ftype = ").append(itemType);
            if (cashFlowFilterPara.getCashItem() != null) {
                sql.append(" and fid = '").append(cashFlowFilterPara.getCashItem().getId().toString()).append("'");
            }
            if ((useCompany = cashFlowFilterPara.getUseCompany()) != null) {
                if (cashFlowFilterPara.isDisplayAsst() && useCompany.isHasAsstItem()) {
                    sql.append(" and companyLongnumber = '").append(useCompany.getLongNumber()).append("'");
                } else {
                    sql.append(" and companyLongnumber like '").append(useCompany.getLongNumber());
                    sql.append("!%'");
                }
            }
            if (cashFlowFilterPara.isDisplayAsst()) {
                if (!(cashFlowFilterPara.getExpandCompanyLevel() >= 2 || useCompany != null && useCompany.getLevel() + 1 == this.maxCompanyLevel || cashFlowFilterPara.isExpandAll())) {
                    sql.append(" and fcashtype in (0, 1)");
                }
                sql.append("\r\n order by FType,FLongNumber,companyLongnumber,fcashtype");
            } else {
                sql.append("\r\n order by FType,FLongNumber,fcashtype,companyLongnumber");
            }
            RptRowSet rs = null;
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
                rs = DBUtil.executeQuery((String)sql.toString(), (Connection)conn);
                while (rs.next()) {
                    Object[] obj = new Object[15];
                    obj[0] = rs.getString("FLongNumber");
                    obj[1] = rs.getString("FName");
                    obj[2] = new Integer(rs.getInt("FLevel"));
                    obj[3] = new Integer(rs.getInt("FDirection"));
                    BigDecimal amount = rs.getBigDecimal("FAmount");
                    obj[4] = amount == null ? new BigDecimal("0") : amount;
                    obj[5] = new Integer(rs.getInt("FisLeaf"));
                    obj[6] = new Boolean(rs.getInt("FIsProfit") == 1);
                    CashFlowItemInfo info = new CashFlowItemInfo();
                    info.setId(BOSUuid.read((String)rs.getString("Fid")));
                    info.setName(rs.getString("FName"));
                    info.setNumber(rs.getString("FNumber"));
                    if (obj[3] != null) {
                        info.setDirection(CashFlowDirection.getEnum((int)rs.getInt("FDirection")));
                    }
                    info.setLongNumber(rs.getString("FLongNumber"));
                    info.setIsLeaf(rs.getInt("FisLeaf") == 1);
                    info.setType(CashFlowItemType.getEnum((int)rs.getInt("FType")));
                    info.setIsExChange(new Boolean(rs.getInt("FIsExChange") == 1).booleanValue());
                    info.setIsProfit(((Boolean)obj[6]).booleanValue());
                    obj[7] = info;
                    obj[8] = new Boolean(rs.getInt("FIsExChange") == 1);
                    obj[11] = rs.getString("FCompanyID");
                    if (cashFlowFilterPara.isDisplayAsst()) {
                        obj[9] = CashflowTypeEnum.getEnum((int)rs.getInt("fcashType"));
                        obj[10] = rs.getString("flongnamegroup");
                        if (obj[10] != null && !((String)obj[10]).equals(" ")) {
                            obj[10] = ((String)obj[10]).replaceAll("_!", " ");
                            obj[10] = VoucherUtil.decodeSplitFlag((String)obj[10]);
                        }
                        obj[12] = rs.getString("FAsstID");
                        obj[13] = rs.getInt("FHasAsstItem") == 1;
                    }
                    obj[14] = BigDecimal.ZERO;
                    vec.addElement(obj);
                }
            }
            catch (SQLException se) {
                throw new BOSException((Throwable)se);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        } else if (cashFlowFilterPara.getTotalType() != 2) {
            CashFlowItemInfo cashItem = cashFlowFilterPara.getCashItem();
            sql.append(" select '").append(cashItem.getId().toString()).append("' fid,");
            sql.append("N'").append(cashItem.getName()).append("' fname,");
            sql.append("N'").append(cashItem.getNumber()).append("' fnumber,");
            sql.append("N'").append(cashItem.getLongNumber()).append("' flongnumber,");
            sql.append(cashItem.isIsLeaf() ? 1 : 0).append(" fisleaf,");
            sql.append(cashItem.getLevel()).append(" flevel,");
            sql.append(cashItem.getType().getValue()).append(" FType,");
            sql.append("0 FIsExChange,0 FDirection,sum(FAmount) FAmount,");
            sql.append(cashItem.isIsProfit() ? 1 : 0).append("FIsProfit, ");
            sql.append(" FCompanyID");
            sql.append(" from ").append(tempTable).append(" \r\n");
            if (cashFlowFilterPara.getUseCompany() == null) {
                if (cashFlowFilterPara.getExpandCompanyLevel() > 1) {
                    sql.append(" where companyLevel >= ").append(this.curCompany.getLevel());
                    sql.append(" and companyLevel <=").append(this.curCompany.getLevel() + cashFlowFilterPara.getExpandCompanyLevel() - 1);
                } else {
                    sql.append(" where companyLevel = ");
                    sql.append(this.curCompany.getLevel());
                }
            } else if (!cashFlowFilterPara.isExpandAll()) {
                sql.append(" where companyLevel = ");
                sql.append(cashFlowFilterPara.getUseCompany().getLevel() + 1);
            }
            if (cashFlowFilterPara.getCashItem() != null) {
                if (cashFlowFilterPara.getUseCompany() != null && cashFlowFilterPara.isExpandAll()) {
                    sql.append(" where ");
                } else {
                    sql.append(" and ");
                }
                if (cashFlowFilterPara.getTotalType() == 0 || cashFlowFilterPara.getTotalType() == 1) {
                    if (cashFlowFilterPara.getCashItem().isIsLeaf()) {
                        sql.append(" fid = '").append(cashFlowFilterPara.getCashItem().getId().toString()).append("'");
                    } else {
                        sql.append(" fisleaf = 1 and flongnumber like '").append(cashFlowFilterPara.getCashItem().getLongNumber()).append("%'");
                    }
                    sql.append(" and FDirection = ").append(cashFlowFilterPara.getCashFlowDirection());
                } else {
                    sql.append(" fid = '").append(cashFlowFilterPara.getCashItem().getId().toString()).append("'");
                }
            }
            if (cashFlowFilterPara.getUseCompany() != null && cashFlowFilterPara.getCashItem() == null && cashFlowFilterPara.isExpandAll()) {
                sql.append(" where ftype = ").append(itemType);
            } else {
                sql.append(" and ftype = ").append(itemType);
            }
            SimpleCompanyUserObject useCompany = cashFlowFilterPara.getUseCompany();
            if (useCompany != null) {
                sql.append(" and companyLongnumber like '").append(useCompany.getLongNumber());
                if (cashFlowFilterPara.isDisplayAsst() && useCompany.isHasAsstItem()) {
                    sql.append("%'");
                } else {
                    sql.append("!%'");
                }
            }
            if (useCompany == null || !useCompany.isHasAsstItem()) {
                sql.append(" and fcashtype in (0, 1)");
            } else {
                sql.append(" and fcashtype not in (0, 1)");
            }
            sql.append(" group by FCompanyID, companyLongnumber");
            sql.append(" order by companyLongnumber");
            RptRowSet rs = null;
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
                rs = DBUtil.executeQuery((String)sql.toString(), (Connection)conn);
                while (rs.next()) {
                    Object[] obj = new Object[15];
                    obj[0] = rs.getString("FLongNumber");
                    obj[1] = rs.getString("FName");
                    obj[2] = new Integer(rs.getInt("FLevel"));
                    obj[3] = new Integer(rs.getInt("FDirection"));
                    BigDecimal amount = rs.getBigDecimal("FAmount");
                    obj[4] = amount == null ? new BigDecimal("0") : amount;
                    obj[5] = new Integer(rs.getInt("FisLeaf"));
                    obj[6] = new Boolean(rs.getInt("FIsProfit") == 1);
                    CashFlowItemInfo info = new CashFlowItemInfo();
                    info.setId(BOSUuid.read((String)rs.getString("Fid")));
                    info.setName(rs.getString("FName"));
                    info.setNumber(rs.getString("FNumber"));
                    info.setLongNumber(rs.getString("FLongNumber"));
                    info.setIsLeaf(rs.getInt("FisLeaf") == 1);
                    info.setType(CashFlowItemType.getEnum((int)rs.getInt("FType")));
                    info.setIsProfit(((Boolean)obj[6]).booleanValue());
                    obj[7] = info;
                    obj[8] = new Boolean(rs.getInt("FIsExChange") == 1);
                    obj[11] = rs.getString("FCompanyID");
                    obj[10] = " ";
                    obj[14] = BigDecimal.ZERO;
                    vec.addElement(obj);
                }
            }
            catch (SQLException se) {
                throw new BOSException((Throwable)se);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        } else {
            vec = this.getCashAmount(ctx, cashFlowFilterPara, itemType);
        }
        return vec;
    }

    private Vector getCashAmount(Context ctx, CashFlowFilterPara cashFlowFilterPara, int itemType) throws BOSException, EASBizException, SQLDataException {
        SimpleCompanyUserObject useCompany;
        String tempTable = cashFlowFilterPara.getTempTableName();
        Vector<Object[]> vec = new Vector<Object[]>();
        if (itemType == 1) {
            SimpleCompanyUserObject useCompany2;
            StringBuffer sql = new StringBuffer();
            sql.append(" select sum(FAmount) FAmount,FCompanyID,companyLongnumber from ").append(tempTable).append(" \r\n");
            if (cashFlowFilterPara.getUseCompany() == null) {
                if (cashFlowFilterPara.getExpandCompanyLevel() > 1) {
                    sql.append(" where companyLevel >= ").append(this.curCompany.getLevel());
                    sql.append(" where companyLevel <= ").append(this.curCompany.getLevel() + cashFlowFilterPara.getExpandCompanyLevel() - 1);
                } else {
                    sql.append(" where companyLevel = ");
                    sql.append(this.curCompany.getLevel());
                }
            } else if (!cashFlowFilterPara.isExpandAll()) {
                sql.append(" where companyLevel = ");
                sql.append(cashFlowFilterPara.getUseCompany().getLevel() + 1);
            }
            if (cashFlowFilterPara.getUseCompany() != null && cashFlowFilterPara.isExpandAll()) {
                sql.append(" where ");
            } else {
                sql.append(" and ");
            }
            if (cashFlowFilterPara.getCashItem() == null) {
                sql.append(" fisleaf = 1 ");
            } else if (cashFlowFilterPara.getCashItem().isIsLeaf()) {
                sql.append(" fid = '").append(cashFlowFilterPara.getCashItem().getId().toString()).append("'");
            } else {
                sql.append(" fisleaf = 1 and flongnumber like '").append(cashFlowFilterPara.getCashItem().getLongNumber()).append("%'");
            }
            if (itemType != -1) {
                sql.append(" and ftype = ").append(itemType);
            }
            if ((useCompany2 = cashFlowFilterPara.getUseCompany()) != null) {
                sql.append(" and companyLongnumber like '").append(useCompany2.getLongNumber()).append("!%'");
            }
            sql.append(" group by FCompanyID,companyLongnumber");
            sql.append(" order by companyLongnumber");
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
                RptRowSet rs = DBUtil.executeQuery((String)sql.toString(), (Connection)conn);
                while (rs.next()) {
                    Object[] obj = new Object[15];
                    BigDecimal amount = rs.getBigDecimal("FAmount");
                    obj[4] = amount == null ? BigDecimal.ZERO : amount;
                    obj[10] = " ";
                    obj[11] = rs.getString("FCompanyID");
                    obj[14] = BigDecimal.ZERO;
                    vec.addElement(obj);
                }
            }
            catch (SQLException se) {
                throw new BOSException((Throwable)se);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        StringBuffer inSql = new StringBuffer();
        inSql.append(" select sum(FAmount) FAmount, ");
        inSql.append(" FCompanyID,companyLongnumber");
        inSql.append(" from ").append(tempTable).append(" \r\n");
        if (cashFlowFilterPara.getUseCompany() == null) {
            if (cashFlowFilterPara.getExpandCompanyLevel() > 1) {
                inSql.append(" where companyLevel >= ").append(this.curCompany.getLevel());
                inSql.append(" and companyLevel <= ").append(this.curCompany.getLevel() + cashFlowFilterPara.getExpandCompanyLevel() - 1);
            } else {
                inSql.append(" where companyLevel = ");
                inSql.append(this.curCompany.getLevel());
            }
        } else if (!cashFlowFilterPara.isExpandAll()) {
            inSql.append(" where companyLevel = ");
            inSql.append(cashFlowFilterPara.getUseCompany().getLevel() + 1);
        } else {
            inSql.append(" where 1=1");
        }
        if (cashFlowFilterPara.getCashItem() == null) {
            inSql.append(" and fisleaf = 1 ");
        } else if (cashFlowFilterPara.getCashItem().isIsLeaf()) {
            inSql.append(" and fid = '").append(cashFlowFilterPara.getCashItem().getId().toString()).append("'");
        } else {
            inSql.append(" and fisleaf = 1 and flongnumber like '").append(cashFlowFilterPara.getCashItem().getLongNumber()).append("%'");
        }
        inSql.append(" and FDirection = ").append(1);
        if (itemType != -1) {
            inSql.append(" and ftype = ").append(itemType);
        }
        if ((useCompany = cashFlowFilterPara.getUseCompany()) != null) {
            inSql.append(" and companyLongnumber like '").append(useCompany.getLongNumber()).append("!%'");
        }
        if (cashFlowFilterPara.isDisplayAsst()) {
            inSql.append(" and FasstID is null ");
            inSql.append(" and fcashtype not in (2, 3) ");
        }
        inSql.append(" group by FCompanyID, companyLongnumber");
        inSql.append(" order by companyLongnumber");
        StringBuffer outSql = new StringBuffer();
        outSql.append(" select sum(FAmount) FAmount, ");
        outSql.append(" FCompanyID,companyLongnumber");
        outSql.append(" from ").append(tempTable).append(" \r\n");
        if (cashFlowFilterPara.getUseCompany() == null) {
            if (cashFlowFilterPara.getExpandCompanyLevel() > 1) {
                outSql.append(" where companyLevel >= ").append(this.curCompany.getLevel());
                outSql.append(" and companyLevel <= ").append(this.curCompany.getLevel() + cashFlowFilterPara.getExpandCompanyLevel() - 1);
            } else {
                outSql.append(" where companyLevel = ");
                outSql.append(this.curCompany.getLevel());
            }
        } else if (!cashFlowFilterPara.isExpandAll()) {
            outSql.append(" where companyLevel = ");
            outSql.append(cashFlowFilterPara.getUseCompany().getLevel() + 1);
        } else {
            outSql.append(" where 1=1");
        }
        if (cashFlowFilterPara.getCashItem() == null) {
            outSql.append(" and fisleaf = 1 ");
        } else if (cashFlowFilterPara.getCashItem().isIsLeaf()) {
            outSql.append(" and fid = '").append(cashFlowFilterPara.getCashItem().getId().toString()).append("'");
        } else {
            outSql.append(" and fisleaf = 1 and flongnumber like '").append(cashFlowFilterPara.getCashItem().getLongNumber()).append("%'");
        }
        outSql.append(" and FDirection = ").append(2);
        if (itemType != -1) {
            outSql.append(" and ftype = ").append(itemType);
        }
        if (useCompany != null) {
            outSql.append(" and companyLongnumber like '").append(useCompany.getLongNumber()).append("!%'");
        }
        if (cashFlowFilterPara.isDisplayAsst()) {
            outSql.append(" and FasstId is null ");
            outSql.append(" and fcashtype not in (2, 3)");
        }
        outSql.append(" group by FCompanyID, companyLongnumber");
        outSql.append(" order by companyLongnumber");
        RptRowSet inRs = null;
        RptRowSet outRs = null;
        Connection conn = null;
        try {
            CompanyOrgUnitInfo companyOrgUnitInfo;
            int i;
            int index;
            CompanyOrgUnitInfo comp;
            String companyId;
            String longNumber;
            conn = this.getConnection(ctx);
            ArrayList<CompanyOrgUnitInfo> companyList = new ArrayList<CompanyOrgUnitInfo>();
            inRs = DBUtil.executeQuery((String)inSql.toString(), (Connection)conn);
            block11: while (inRs.next()) {
                longNumber = inRs.getString("companyLongnumber");
                companyId = inRs.getString("FCompanyID");
                comp = new CompanyOrgUnitInfo();
                comp.setId(BOSUuid.read((String)companyId));
                comp.setLongNumber(longNumber);
                index = companyList.size();
                for (i = 0; i < companyList.size(); ++i) {
                    companyOrgUnitInfo = (CompanyOrgUnitInfo)companyList.get(i);
                    if (longNumber.equals(companyOrgUnitInfo.getLongNumber())) continue block11;
                    if (longNumber.compareTo(companyOrgUnitInfo.getLongNumber()) >= 0) continue;
                    index = i;
                    break;
                }
                if (index == companyList.size()) {
                    companyList.add(comp);
                    continue;
                }
                companyList.add(index, comp);
            }
            outRs = DBUtil.executeQuery((String)outSql.toString(), (Connection)conn);
            block13: while (outRs.next()) {
                longNumber = outRs.getString("companyLongnumber");
                companyId = outRs.getString("FCompanyID");
                comp = new CompanyOrgUnitInfo();
                comp.setId(BOSUuid.read((String)companyId));
                comp.setLongNumber(longNumber);
                index = companyList.size();
                for (i = 0; i < companyList.size(); ++i) {
                    companyOrgUnitInfo = (CompanyOrgUnitInfo)companyList.get(i);
                    if (longNumber.equals(companyOrgUnitInfo.getLongNumber())) continue block13;
                    if (longNumber.compareTo(companyOrgUnitInfo.getLongNumber()) >= 0) continue;
                    index = i;
                    break;
                }
                if (index == companyList.size()) {
                    companyList.add(comp);
                    continue;
                }
                companyList.add(index, comp);
            }
            for (int i2 = 0; i2 < companyList.size(); ++i2) {
                inRs.reset();
                outRs.reset();
                CompanyOrgUnitInfo companyOrgUnitInfo2 = (CompanyOrgUnitInfo)companyList.get(i2);
                BigDecimal inAmount = GlUtils.zero;
                BigDecimal outAmount = GlUtils.zero;
                while (inRs.next()) {
                    if (!inRs.getString("companyLongnumber").equals(companyOrgUnitInfo2.getLongNumber())) continue;
                    if (inRs.getBigDecimal("FAmount") == null) break;
                    inAmount = inRs.getBigDecimal("FAmount");
                    break;
                }
                while (outRs.next()) {
                    if (!outRs.getString("companyLongnumber").equals(companyOrgUnitInfo2.getLongNumber())) continue;
                    if (outRs.getBigDecimal("FAmount") == null) break;
                    outAmount = outRs.getBigDecimal("FAmount");
                    break;
                }
                CashFlowItemInfo cashItem = cashFlowFilterPara.getCashItem();
                Object[] obj = new Object[15];
                if (cashItem != null) {
                    obj[0] = cashItem.getLongNumber();
                    obj[1] = cashItem.getName();
                    obj[2] = new Integer(cashItem.getLevel());
                    obj[5] = new Integer(cashItem.isIsLeaf() ? 1 : 0);
                    obj[6] = new Boolean(cashItem.isIsProfit());
                    obj[7] = cashItem;
                }
                obj[3] = new Integer(0);
                obj[4] = cashItem != null && CashFlowDirection.IN == cashItem.getDirection() ? inAmount : (cashItem != null && CashFlowDirection.OUT == cashItem.getDirection() ? outAmount : inAmount.subtract(outAmount));
                if (cashItem != null && cashFlowFilterPara.getCashFlowDirection() == -1) {
                    obj[4] = inAmount.subtract(outAmount);
                }
                obj[8] = Boolean.FALSE;
                obj[10] = " ";
                obj[11] = companyOrgUnitInfo2.getId().toString();
                obj[14] = BigDecimal.ZERO;
                vec.addElement(obj);
            }
        }
        catch (SQLException se) {
            throw new BOSException((Throwable)se);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return vec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getSumCashAmount(Context ctx, CashFlowFilterPara cashFlowFilterPara, int startPeriod) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> map;
        block18: {
            String itemFilterSql = cashFlowFilterPara.getItemFilterSql();
            List<String> periodIdList = com.kingdee.eas.fi.gl.CashFlowUtils.getPeriodIdByNumberRange(ctx, cashFlowFilterPara.getCompanyIds(), startPeriod, cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo());
            String periodIdsStr = null;
            if (periodIdList != null && periodIdList.size() > 0) {
                periodIdsStr = com.kingdee.eas.fi.gl.CashFlowUtils.buildIn(periodIdList);
            }
            if (!cashFlowFilterPara.isTermOrDate()) {
                return Collections.EMPTY_MAP;
            }
            String idFiled = null;
            idFiled = "cfr.FPrimaryItemID";
            String amountField = null;
            String currencyId = cashFlowFilterPara.getCurrencyId();
            boolean isGlCurrency = currencyId.equals(this.getGeneralLocalCurrency());
            boolean isGLRptCurrency = currencyId.equals(this.getGeneralReportCurrency());
            amountField = isGlCurrency ? "cfr.FLocalAmount" : (isGLRptCurrency ? "cfr.FReportingAmount" : "cfr.FOriginalAmount");
            String rateField = null;
            rateField = "cfr.FPrimaryCoeffient";
            StringBuffer sql = new StringBuffer(512);
            sql.append(" select FLongnumber, sum(FAmount) as FAmount, FCompanyID, FParentID, FCompanyLevel from ( \n");
            sql.append(" select cfi2.flongnumber as flongnumber, cfr.FAmount*(case when cfi1.FDirection=2 then -1 else 1 end) as FAmount, ");
            sql.append(" cp.fid as FCompanyID, cp.fparentid as FParentID, cp.flevel as FCompanyLevel from ");
            sql.append(" T_BD_CashFlowItem cfi1 ");
            sql.append(" inner join T_BD_CashFlowItem cfi2 ");
            sql.append(" on (charindex(cfi2.FLongNumber||'!',cfi1.FLongNumber) = 1 ");
            sql.append(" or cfi2.FLongNumber=cfi1.FLongNumber) ");
            sql.append(" left outer join (");
            sql.append(" select ");
            sql.append(" voucher.FCompanyID,");
            sql.append(idFiled);
            sql.append(",(");
            sql.append(amountField);
            sql.append("*");
            sql.append(rateField);
            sql.append(") as FAmount");
            sql.append(" from T_GL_CashflowRecord cfr \n");
            sql.append(" join T_GL_Voucher voucher on cfr.FVoucherID = voucher.FID \n");
            sql.append(" INNER JOIN t_bd_accountview av ON av.fid = cfr.faccountid \n");
            sql.append(" AND av.fcompanyid = voucher.FCompanyID \n");
            if (!isGlCurrency && !isGLRptCurrency && cashFlowFilterPara.isOldVersion()) {
                sql.append(" join T_GL_VoucherEntry ve on cfr.FEntryID = ve.FID \n");
            }
            sql.append(" where voucher.FCompanyID in ( " + cashFlowFilterPara.getCompanyIds() + " ) \n");
            sql.append(" AND av.faccounttableid = '" + cashFlowFilterPara.getAccountTabel().getId().toString() + "' \n");
            if (itemFilterSql != null) {
                sql.append(" and " + idFiled + " in ( ").append(itemFilterSql).append(" ) ");
            }
            sql.append(" AND ");
            if (periodIdsStr != null) {
                sql.append(" voucher.FPeriodID in " + periodIdsStr + "\r\n");
            } else {
                int[] periodRange = new int[]{startPeriod, cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo()};
                sql.append(SQLUtil.getPeriodCondition(" period.FNumber", periodRange));
            }
            if (!isGlCurrency && !isGLRptCurrency) {
                if (cashFlowFilterPara.isOldVersion()) {
                    sql.append(" and ve.FCurrencyID = ");
                } else {
                    sql.append(" and cfr.FCurrencyID = ");
                }
                sql.append("'" + currencyId + "' \r\n");
            }
            sql.append(" and voucher.FBizStatus in(");
            sql.append(5);
            if (cashFlowFilterPara.isAllVoucher()) {
                sql.append(",");
                sql.append(3);
                sql.append(",");
                sql.append(1);
            }
            sql.append(") )as cfr");
            sql.append(" on ");
            sql.append(idFiled);
            sql.append(" = cfi1.FID ");
            sql.append(" left outer join T_ORG_COMPANY cp on cp.fid = cfr.FCompanyID \n");
            sql.append(" where ");
            sql.append(" cfi2.FType = 0 \n");
            sql.append(" and cfi2.FLevel <= 1 \n");
            sql.append("and (cfr.FAmount is not null or cfr.FAmount <> 0)  \n");
            sql.append(" ) as A group by flongnumber, FCompanyID, FParentID, FCompanyLevel \r\n");
            sql.append(" having sum(FAmount) <> 0 \r\n");
            map = new HashMap<String, BigDecimal>();
            SqlParams sp = new SqlParams();
            Connection conn = null;
            IRowSet rs = null;
            String tempTable = "cash_year_total";
            conn = this.getConnection(ctx);
            try {
                tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(" create table " + tempTable + "  (FLongnumber varchar(400),FAMOUNT decimal(28, 10),FCompanyID varchar(80),FParentID varchar(80),FCompanyLevel int) ");
                DbUtil.execute((Context)ctx, (String)("insert into " + tempTable + sql.toString()));
                SimpleCompanyUserObject expandCompany = cashFlowFilterPara.getUseCompany();
                if (expandCompany == null || expandCompany.getLevel() + 1 < this.maxCompanyLevel) {
                    sql.setLength(0);
                    sql.append(" insert into " + tempTable + " (FLongnumber, FAmount, FCompanyID, FParentID, FCompanyLevel ) \n");
                    sql.append(" select t.FLongnumber, sum(t.FAmount) FAmount, cp.fid FCompanyID, cp.FParentID, cp.FLevel FCompanyLevel \n");
                    sql.append(" from " + tempTable + " t \n");
                    sql.append(" inner join t_org_company cp on cp.fid = t.fparentid \n");
                    sql.append(" where t.fcompanyLevel = ? \n");
                    sql.append(" group by t.FLongnumber, cp.fid, cp.FParentID, cp.FLevel \n");
                    PreparedStatement ps = conn.prepareStatement(sql.toString());
                    int level = expandCompany == null ? this.curCompany.getLevel() : expandCompany.getLevel() + 1;
                    for (int i = this.maxCompanyLevel; i > level; --i) {
                        ps.setInt(1, i);
                        ps.addBatch();
                    }
                    ps.executeBatch();
                    ps.clearBatch();
                    SQLUtils.cleanup((Statement)ps);
                }
                sql.setLength(0);
                sql.append(" select sum(FAmount) as famount, FCompanyID from " + tempTable + " \n");
                int limitCompanyLevel = this.curCompany.getLevel();
                limitCompanyLevel = expandCompany == null ? (limitCompanyLevel += cashFlowFilterPara.getExpandCompanyLevel() - 1) : (cashFlowFilterPara.isExpandAll() ? this.maxCompanyLevel : expandCompany.getLevel() + 1);
                sql.append(" where FCompanyLevel <= " + limitCompanyLevel);
                sql.append(" group by FCompanyID ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    BigDecimal FAmount = rs.getBigDecimal(1);
                    String FCompanyID = rs.getString(2);
                    if (FAmount == null) continue;
                    map.put(FCompanyID, FAmount);
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block18;
            }
            finally {
                SQLUtils.cleanup(rs);
                this._releaseTempTable(ctx, tempTable);
            }
            this._releaseTempTable(ctx, tempTable);
        }
        return map;
    }

    private String createUnionCashTable(Context ctx, CashFlowFilterPara cashFlowFilterPara) throws BOSException, EASBizException {
        SqlParams sp = new SqlParams();
        ObjectUuidPK comPk = new ObjectUuidPK(ContextUtil.getCurrentFIUnit((Context)ctx).getId());
        RptParams pp = new RptParams();
        pp.setObject("GL_004", (Object)comPk);
        HashMap allParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(new HashMap(pp.toMap()));
        boolean isShowNumber = allParam.get("GL_004") != null && Boolean.valueOf(allParam.get("GL_004").toString()) != false;
        StringBuffer sql = this.buildUnionCashSql(ctx, sp, cashFlowFilterPara, isShowNumber);
        String tempTable = "query_cash";
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            String struct = "FID varchar(80), FParentID varchar(80), FNumber varchar(200),FType int, FIsProfit int, FLongNumber varchar(200),FName varchar(400),FLevel int, FDirection int, FisLeaf int, FAmount decimal(28, 10), FIsExChange int, FCashType int,flongnamegroup varchar(400), FCompanyID varchar(80),parentCompanyID varchar(80), isBizUnit int,CompanyLevel int, CompanyLongNumber varchar(400)";
            if (cashFlowFilterPara.isDisplayAsst()) {
                struct = struct + ", FAsstID varchar(80), FHasAsstItem int";
            }
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(" create table " + tempTable + "  (" + struct + ") ");
            DbUtil.execute((Context)ctx, (String)("insert into " + tempTable + sp.getSqlWithParams(sql.toString())));
            if (!this.curCompany.isIsBizUnit()) {
                String itemFilterSql;
                sql = new StringBuffer();
                sql.append(" select max(flevel) companyLevel from t_org_company where fid in (").append(cashFlowFilterPara.getCompanyIds()).append(")");
                RptRowSet rs = DBUtil.executeQuery((String)sql.toString(), (Connection)conn);
                int maxCompanyLevel = this.curCompany.getLevel();
                if (rs.next()) {
                    maxCompanyLevel = rs.getInt("companyLevel");
                }
                sql = new StringBuffer();
                sql.append("insert into " + tempTable + " select t.fid,t.fparentid,t.fnumber,t.ftype,t.FIsProfit,t.FLongNumber,t.FName,t.FLevel,t.FDirection,t.FisLeaf,sum(t.FAmount) FAmount ,");
                sql.append(" t.FIsExChange,t.fcashtype,t.flongnamegroup,cp.fid FCompanyID,cp.fparentid,cp.fisBizUnit, cp.flevel companyLevel, cp.flongnumber companyLongNumber ");
                if (cashFlowFilterPara.isDisplayAsst()) {
                    sql.append(",t.FAsstID");
                    sql.append(",t.FHasAsstItem");
                }
                sql.append(" from ").append(tempTable).append(" t ");
                sql.append(" inner join t_org_company cp on cp.fid = t.parentCompanyID");
                sql.append(" where t.companyLevel = ?  ");
                if (cashFlowFilterPara.isDisplayAsst()) {
                    sql.append(" and t.Fcashtype in (0, 1) ");
                }
                sql.append(" group by t.fid,t.fparentid,t.fnumber,t.ftype,t.FIsProfit,t.FLongNumber,t.FName,t.FLevel,t.FDirection,t.FisLeaf,");
                sql.append(" t.FIsExChange,t.fcashtype,t.flongnamegroup");
                if (cashFlowFilterPara.isDisplayAsst()) {
                    sql.append(",t.FAsstID ");
                    sql.append(",t.FHasAsstItem");
                }
                sql.append(",cp.FID,cp.fparentid,cp.fisBizUnit, cp.flevel, cp.flongnumber");
                PreparedStatement ps = conn.prepareStatement(sql.toString());
                for (int i = maxCompanyLevel; i > this.curCompany.getLevel(); --i) {
                    ps.setInt(1, i);
                    ps.addBatch();
                }
                ps.executeBatch();
                ps.clearBatch();
                SQLUtils.cleanup((Statement)ps);
                sql = new StringBuffer();
                sql.append(" select max(flevel) maxLevel from ").append(tempTable);
                rs = DBUtil.executeQuery((String)sql.toString(), (Connection)conn);
                int maxLevel = 1;
                if (rs.next()) {
                    maxLevel = rs.getInt("maxLevel");
                }
                sql = new StringBuffer();
                sql.append("insert into " + tempTable + " select cf.fid,cf.fparentid,cf.fnumber,cf.ftype,cf.FIsProfit,cf.FLongNumber,cf.FName_");
                sql.append(ctx.getLocale()).append(" FName ");
                sql.append(",cf.FLevel,cf.FDirection,cf.FisLeaf,sum(t.FAmount*(case t.FDirection when 2 then -1 else 1 end) * (case cf.FDirection  when 2 then -1 else 1 end)) FAmount ,");
                sql.append(" cf.FIsExChange,t.fcashtype,n' ' flongnamegroup,t.FCompanyID,t.parentCompanyID,t.isBizUnit, t.companyLevel, t.companyLongNumber");
                if (cashFlowFilterPara.isDisplayAsst()) {
                    sql.append(",t.FAsstID ");
                    sql.append(",t.FHasAsstItem");
                }
                sql.append(" from ").append(tempTable).append(" t ");
                sql.append(" inner join T_BD_CashFlowItem cf on cf.fid = t.fparentid");
                sql.append(" where t.fLevel = ?");
                if (cashFlowFilterPara.isDisplayAsst()) {
                    sql.append(" and t.Fcashtype in (0, 1) ");
                }
                if ((itemFilterSql = cashFlowFilterPara.getItemFilterSql()) != null) {
                    sql.append(" and cf.fid in ( ").append(itemFilterSql).append(" ) ");
                }
                sql.append("  group by cf.fid,cf.fparentid,cf.fnumber,cf.ftype,cf.FIsProfit,cf.FLongNumber,cf.FName_");
                sql.append(ctx.getLocale()).append(",cf.FLevel,cf.FDirection,cf.FisLeaf,");
                sql.append(" cf.FIsExChange,t.fcashtype,t.FCompanyID,t.parentCompanyID,t.isBizUnit, t.companyLevel, t.companyLongnumber");
                if (cashFlowFilterPara.isDisplayAsst()) {
                    sql.append(",t.FAsstID ");
                    sql.append(",t.FHasAsstItem");
                }
                ps = conn.prepareStatement(sql.toString());
                for (int i = maxLevel; i > 1; --i) {
                    ps.setInt(1, i);
                    ps.addBatch();
                }
                ps.executeBatch();
                ps.clearBatch();
                SQLUtils.cleanup((Statement)ps);
            }
            cashFlowFilterPara.setTempTableName(tempTable);
            if (cashFlowFilterPara.isDisplayAsst()) {
                this.updateCompanyWithAsstItem(ctx, cashFlowFilterPara);
            }
        }
        catch (Exception e) {
            this._releaseTempTable(ctx, cashFlowFilterPara.getAsstItemTempTable());
            this._releaseTempTable(ctx, tempTable);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return tempTable;
    }

    private StringBuffer buildUnionCashSql(Context ctx, SqlParams sp, CashFlowFilterPara cashFlowFilterPara, boolean isShowNumber) throws EASBizException, BOSException {
        boolean isAsst = cashFlowFilterPara.isDisplayAsst();
        String ssistItemName = isShowNumber ? "fdisplaynamegroup_l2" : "flongnamegroup_l2";
        StringBuffer sbFName = new StringBuffer("cfi2.FName_");
        String strLocal = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sbFName.append(strLocal);
        StringBuffer sbSql = new StringBuffer();
        sbSql.append(" select cf.fid,cf.fparentid,cf.fnumber,cf.ftype,cf.FIsProfit,cf.FLongNumber,cf.FName,cf.FLevel,cf.FDirection,cf.FisLeaf");
        if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
            sbSql.append(",sum(cfr.FLocalAmount");
        } else if (cashFlowFilterPara.getCurrencyId().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
            sbSql.append(",sum(cfr.FReportingAmount");
        } else {
            sbSql.append(",sum(cfr.FOriginalAmount");
        }
        sbSql.append(" * case cf.ftype when ").append(0).append(" then cfr.FPrimaryCoeffient ");
        sbSql.append(" when ").append(1).append(" then cfr.FSupplementaryCoeffient ");
        sbSql.append(" else 1 end");
        sbSql.append(") FAmount");
        sbSql.append(" , cf.FIsExChange FIsExChange,0  fcashType,n' ' flongnamegroup");
        sbSql.append(",cf.FCompanyID, cf.parentCompanyID, cf.isBizUnit, cf.companyLevel, cf.companyLongNumber ");
        if (cashFlowFilterPara.isDisplayAsst()) {
            sbSql.append(",NULL AS FAsstID");
            sbSql.append(",0 FHasAsstItem ");
        }
        sbSql.append(" from (");
        sbSql.append(" select cfi2.fid,cfi2.fparentid,cfi2.fnumber,cfi2.ftype,cfi2.FIsProfit,cfi2.FLongNumber FLongNumber,");
        sbSql.append(sbFName).append(" FName,cfi2.FLevel FLevel,cfi2.FDirection FDirection,cfi2.FisLeaf FisLeaf,cfi2.FIsExChange,");
        sbSql.append("cop.fid fcompanyid,cop.fparentid parentCompanyID,cop.fisbizunit isBizUnit,cop.flevel companyLevel,cop.flongnumber companyLongNumber\r\n");
        sbSql.append(" from T_BD_CashFlowItem cfi2 \r\n");
        sbSql.append(" inner join t_org_company cop on 1=1 \r\n");
        sbSql.append(" and cop.fid in (").append(this.curCompany.isIsBizUnit() ? "'" + this.curCompany.getId().toString() + "'" : cashFlowFilterPara.getCompanyIds()).append(") ");
        sbSql.append(" and cfi2.fisleaf = 1");
        String itemFilterSql = cashFlowFilterPara.getItemFilterSql();
        if (itemFilterSql != null) {
            sbSql.append(" and cfi2.fid in ( ").append(itemFilterSql).append(" ) ");
        }
        sbSql.append(") cf ");
        sbSql.append(" left outer join \r\n");
        sbSql.append(" (");
        sbSql.append(" select cfr.FPrimaryItemID, cfr.FSupplementaryItemID, cfr.FfullInfoItemID,");
        if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
            sbSql.append("cfr.FLocalAmount,");
        } else if (cashFlowFilterPara.getCurrencyId().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
            sbSql.append("cfr.FReportingAmount,");
        } else {
            sbSql.append("cfr.FOriginalAmount,");
        }
        sbSql.append("cfr.FPrimaryCoeffient,cfr.FSupplementaryCoeffient,voucher.FCompanyID \r\n");
        sbSql.append(" from T_GL_CashflowRecord cfr ");
        sbSql.append(" inner join T_GL_Voucher voucher on cfr.FVoucherID = voucher.FID ");
        if (cashFlowFilterPara.isTermOrDate()) {
            sbSql.append(" inner join T_BD_Period period on voucher.FPeriodID = period.FID \r\n");
        }
        sbSql.append(" inner join t_bd_accountview av on av.fid=cfr.faccountid  \r\n");
        sbSql.append(" inner join t_org_company comp on comp.fid = av.fcompanyid \r\n");
        sbSql.append(" where voucher.FCompanyID ");
        sbSql.append("in (").append(this.curCompany.isIsBizUnit() ? "'" + this.curCompany.getId().toString() + "'" : cashFlowFilterPara.getCompanyIds()).append(") ");
        if (cashFlowFilterPara.isTermOrDate()) {
            sbSql.append(" and period.fnumber >= ? and period.fnumber <= ? ");
            sp.addInt(cashFlowFilterPara.getYearFrom() * 100 + cashFlowFilterPara.getMonthFrom());
            sp.addInt(cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo());
        } else {
            sbSql.append(" and voucher.FBookedDate >= ? \r\n");
            sbSql.append(" and voucher.FBookedDate <= ? \r\n");
            sp.addDate(new Date(cashFlowFilterPara.getDateFrom().getTime()));
            sp.addDate(new Date(cashFlowFilterPara.getDateTo().getTime()));
        }
        sbSql.append(" and av.faccounttableid=? \r\n");
        sp.addString(cashFlowFilterPara.getAccountTabel().getId().toString());
        if (!cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency()) && !cashFlowFilterPara.getCurrencyId().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
            sbSql.append(" and cfr.FCurrencyID = ? \r\n");
            sp.addString(cashFlowFilterPara.getCurrencyId());
        }
        sbSql.append(" and voucher.FBizStatus in(");
        sbSql.append(5);
        if (cashFlowFilterPara.isAllVoucher()) {
            sbSql.append(",");
            sbSql.append(3);
            sbSql.append(",");
            sbSql.append(1);
        }
        sbSql.append(")");
        sbSql.append(" )cfr \r\n on case cf.ftype when ").append(0).append(" then cfr.FPrimaryItemID ");
        sbSql.append(" when ").append(1).append(" then cfr.FSupplementaryItemID ");
        sbSql.append(" else FfullInfoItemID end = cf.FID \r\n");
        sbSql.append("  and cfr.fcompanyid = cf.fcompanyid ");
        sbSql.append(" group by cf.fid,cf.fparentid,cf.fnumber,cf.ftype,cf.FLongNumber,cf.FName,cf.FLevel,cf.FDirection,cf.FisLeaf,cf.FIsProfit,cf.FIsExchange,");
        sbSql.append("cf.FCompanyID,cf.parentCompanyID,cf.companyLevel,cf.isBizUnit,cf.companyLongNumber");
        if (isAsst) {
            SqlParams asstSp = new SqlParams();
            String union = " union ";
            StringBuffer asstSql = new StringBuffer();
            asstSql.append(" select cf.fid,cf.fparentid,cf.fnumber,cf.ftype,cf.FIsProfit,cf.FLongNumber FLongNumber,");
            asstSql.append("cf.Fname FName,cf.FLevel FLevel,cf.FDirection FDirection,cf.FisLeaf FisLeaf,sum(");
            if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
                asstSql.append("cfr1.FLocalAmount");
            } else if (cashFlowFilterPara.getCurrencyId().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                asstSql.append("cfr1.FReportingAmount");
            } else {
                asstSql.append("cfr1.FOriginalAmount");
            }
            asstSql.append(" * cfr1.FPrimaryCoeffient) FAmount , cf.FIsExChange FIsExChange,(case when cfr1.ftype=3 then 3 else 2 end) fcashtype,hg." + ssistItemName + " flongnamegroup");
            asstSql.append(",cfr1.FCompanyID, cfr1.parentCompanyID, cfr1.isBizUnit, cfr1.companyLevel, cfr1.companyLongNumber,hg.fid hgId,0 FHasAsstItem ");
            asstSql.append("\n from (");
            asstSql.append(" select cfi2.fid,cfi2.fparentid,cfi2.fnumber,cfi2.ftype,cfi2.FIsProfit,cfi2.FLongNumber FLongNumber,");
            asstSql.append(sbFName).append(" FName,cfi2.FLevel FLevel,cfi2.FDirection FDirection,cfi2.FisLeaf FisLeaf,cfi2.FIsExChange,cfi2.FIsEnable");
            asstSql.append(" from T_BD_CashFlowItem cfi2 ");
            if (itemFilterSql != null) {
                asstSql.append(" where cfi2.fid in ( ").append(itemFilterSql).append(" ) ");
            }
            asstSql.append(") cf ");
            asstSql.append("\n left outer join");
            asstSql.append(" ( select cfr.FPrimaryItemID,cfr.FLocalAmount,cfr.FOriginalAmount,cfr.FReportingAmount,cfr.FPrimaryCoeffient,cfr.ftype,cfr.fassgrpid,voucher.FCompanyID FCompanyID");
            asstSql.append(",company.fparentid  parentCompanyID,company.fisbizunit  isBizUnit,company.flevel  companyLevel,company.flongnumber  companyLongNumber \r\n");
            asstSql.append(" from T_GL_CashflowRecord cfr ");
            asstSql.append(" inner join T_GL_Voucher voucher on cfr.FVoucherID = voucher.FID ");
            asstSql.append(" join T_BD_Period period on voucher.FPeriodID = period.FID ");
            asstSql.append(" inner join t_bd_accountview av on av.fid=cfr.faccountid and av.fcompanyid = voucher.FCompanyID \r\n");
            asstSql.append(" inner join t_org_company company on voucher.fcompanyId = company.fid \r\n");
            asstSql.append(" where voucher.FCompanyID ");
            asstSql.append("in (").append(this.curCompany.isIsBizUnit() ? "'" + this.curCompany.getId().toString() + "'" : cashFlowFilterPara.getCompanyIds()).append(") ");
            if (cashFlowFilterPara.isTermOrDate()) {
                asstSql.append(" and period.fnumber >= ? and period.fnumber <= ? ");
                sp.addInt(cashFlowFilterPara.getYearFrom() * 100 + cashFlowFilterPara.getMonthFrom());
                sp.addInt(cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo());
                asstSp.addInt(cashFlowFilterPara.getYearFrom() * 100 + cashFlowFilterPara.getMonthFrom());
                asstSp.addInt(cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo());
            } else {
                asstSql.append(" and voucher.FBookedDate >= ? \r\n");
                asstSql.append(" and voucher.FBookedDate <= ? \r\n");
                sp.addDate(new Date(cashFlowFilterPara.getDateFrom().getTime()));
                sp.addDate(new Date(cashFlowFilterPara.getDateTo().getTime()));
                asstSp.addDate(new Date(cashFlowFilterPara.getDateFrom().getTime()));
                asstSp.addDate(new Date(cashFlowFilterPara.getDateTo().getTime()));
            }
            asstSql.append(" and av.faccounttableid=? \r\n");
            sp.addString(cashFlowFilterPara.getAccountTabel().getId().toString());
            asstSp.addString(cashFlowFilterPara.getAccountTabel().getId().toString());
            if (!cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency()) && !cashFlowFilterPara.getCurrencyId().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                asstSql.append(" and cfr.FCurrencyID = ? \r\n");
                sp.addString(cashFlowFilterPara.getCurrencyId());
                asstSp.addString(cashFlowFilterPara.getCurrencyId());
            }
            asstSql.append(" and voucher.FBizStatus in(");
            asstSql.append(5);
            if (cashFlowFilterPara.isAllVoucher()) {
                asstSql.append(",");
                asstSql.append(3);
                asstSql.append(",");
                asstSql.append(1);
            }
            asstSql.append(")");
            asstSql.append(")cfr1 ");
            asstSql.append(" on cfr1.FPrimaryItemID = cf.FID ");
            asstSql.append("left join t_bd_assistanthg hg on cfr1.fassgrpid=hg.fid \n");
            asstSql.append("where ");
            if (!cashFlowFilterPara.isCfImportAssist()) {
                asstSql.append(" cf.fisenable=1 and ");
            }
            asstSql.append(" cf.fisleaf=1 and cf.flevel>1 and cf.FLevel <= ? \r\n");
            if (cashFlowFilterPara.getLevel() == 1) {
                sp.addInt(2);
                asstSp.addInt(2);
            } else {
                sp.addInt((int)cashFlowFilterPara.getLevel());
                asstSp.addInt((int)cashFlowFilterPara.getLevel());
            }
            asstSql.append("group by cf.fid,cf.fparentid,cf.fnumber,cf.ftype,cf.FLongNumber,cf.FName,cf.FLevel,cf.FDirection,cf.FisLeaf,cf.FIsProfit,cf.FIsExchange ");
            asstSql.append(",cfr1.ftype,hg." + ssistItemName + ",cfr1.FCompanyID,cfr1.parentCompanyID,cfr1.companyLevel,cfr1.isBizUnit,cfr1.companyLongNumber,hg.fid");
            asstSql.append(" HAVING sum(cfr1.FOriginalAmount * cfr1.FPrimaryCoeffient) <> 0 ");
            sbSql.append(union).append(asstSql);
            String asstItemTempTable = "asstItem_TempTable";
            try {
                String struct = "FID varchar(80), FParentID varchar(80), FNumber varchar(200),FType int, FIsProfit int, FLongNumber varchar(200),FName varchar(400),FLevel int, FDirection int, FisLeaf int, FAmount decimal(28, 10), FIsExChange int, FCashType int,flongnamegroup varchar(400), FCompanyID varchar(80),parentCompanyID varchar(80), isBizUnit int,CompanyLevel int, companyLongNumber varchar(400)";
                if (cashFlowFilterPara.isDisplayAsst()) {
                    struct = struct + ", FAsstID varchar(80), FHasAsstItem int";
                }
                asstItemTempTable = TempTablePool.getInstance((Context)ctx).createTempTable(" create table " + asstItemTempTable + "  (" + struct + ") ");
                DbUtil.execute((Context)ctx, (String)("insert into " + asstItemTempTable + asstSp.getSqlWithParams(asstSql.toString())));
                cashFlowFilterPara.setAsstItemTempTable(asstItemTempTable);
            }
            catch (Exception e) {
                this._releaseTempTable(ctx, asstItemTempTable);
                throw new BOSException((Throwable)e);
            }
        }
        return sbSql;
    }

    private Vector sortCashFlowRecord(Vector vec, short level) {
        Vector<Object[]> vecInAndOut = new Vector<Object[]>();
        Vector<Object[]> vecIn = new Vector<Object[]>();
        Vector<Object[]> vecOut = new Vector<Object[]>();
        Vector<int[]> vecIndex = new Vector<int[]>();
        int[] firstIndex = new int[]{0, vec.size() - 1};
        vecIndex.addElement(firstIndex);
        for (int i = 0; i < level; ++i) {
            int indexSize = vecIndex.size();
            Vector<int[]> tmpIndex = new Vector<int[]>();
            for (int j = 0; j < indexSize; ++j) {
                int[] index = (int[])vecIndex.elementAt(j);
                int begin = index[0];
                int end = index[1];
                int iDirection = 0;
                vecInAndOut.removeAllElements();
                vecIn.removeAllElements();
                vecOut.removeAllElements();
                block7: for (int k = begin; k <= end; ++k) {
                    Object[] arrayObj = (Object[])vec.elementAt(k);
                    int thisLevel = (Integer)arrayObj[2];
                    if (thisLevel == i) {
                        iDirection = (Integer)arrayObj[3];
                    }
                    switch (iDirection) {
                        case 0: {
                            vecInAndOut.addElement(arrayObj);
                            if (thisLevel != level && k != end) continue block7;
                            int[] thisIndex = new int[2];
                            thisIndex[0] = k + 1;
                            if (k != begin && k != end) {
                                if (!tmpIndex.isEmpty()) {
                                    ((int[])tmpIndex.lastElement())[1] = k - 1;
                                }
                            } else if (k == end && !tmpIndex.isEmpty()) {
                                ((int[])tmpIndex.lastElement())[1] = k;
                            }
                            if (k == end) continue block7;
                            tmpIndex.addElement(thisIndex);
                            continue block7;
                        }
                        case 1: {
                            vecIn.addElement(arrayObj);
                            continue block7;
                        }
                        case 2: {
                            vecOut.addElement(arrayObj);
                        }
                    }
                }
                int seq = begin;
                int sizeInAndOut = vecInAndOut.size();
                for (i = 0; i < sizeInAndOut; ++i) {
                    vec.setElementAt(vecInAndOut.elementAt(i), seq++);
                }
                int sizeIn = vecIn.size();
                for (i = 0; i < sizeIn; ++i) {
                    vec.setElementAt(vecIn.elementAt(i), seq++);
                }
                int sizeOut = vecOut.size();
                for (i = 0; i < sizeOut; ++i) {
                    vec.setElementAt(vecOut.elementAt(i), seq++);
                }
            }
            vecIndex = tmpIndex;
        }
        return vec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getSumAmountMap(Context ctx, CashFlowFilterPara cashFlowFilterPara, int itemType, int startPeriod) throws BOSException, EASBizException {
        HashMap<String, MapParam> map;
        block27: {
            if (!cashFlowFilterPara.isTermOrDate()) {
                return Collections.EMPTY_MAP;
            }
            String itemFilterSql = cashFlowFilterPara.getItemFilterSql();
            List<String> periodIdList = com.kingdee.eas.fi.gl.CashFlowUtils.getPeriodIdByNumberRange(ctx, cashFlowFilterPara.getCompanyIds(), startPeriod, cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo());
            String periodIdsStr = null;
            if (periodIdList != null && periodIdList.size() > 0) {
                periodIdsStr = com.kingdee.eas.fi.gl.CashFlowUtils.buildIn(periodIdList);
            }
            String idFiled = null;
            idFiled = itemType == 0 ? "cfr.FPrimaryItemID" : (itemType == 1 ? "cfr.FSupplementaryItemID" : "cfr.FfullInfoItemID");
            String amountField = null;
            String currencyId = cashFlowFilterPara.getCurrencyId();
            boolean isGlCurrency = currencyId.equals(this.getGeneralLocalCurrency());
            boolean isGLRptCurrency = currencyId.equals(this.getGeneralReportCurrency());
            amountField = isGlCurrency ? "cfr.FLocalAmount" : (isGLRptCurrency ? "cfr.FReportingAmount" : "cfr.FOriginalAmount");
            String rateField = null;
            rateField = itemType == 0 ? "cfr.FPrimaryCoeffient" : (itemType == 1 ? "cfr.FSupplementaryCoeffient" : "1");
            StringBuffer sql = new StringBuffer(512);
            sql.append(" select FLongnumber,FName,FAsstID,FCashType,sum(FAmount) as FAmount,FIsEnable,FCompanyID,FParentID,FisBizUnit,FCompanyLevel,FItemLevel from ( \n");
            sql.append(" select cfi2.flongnumber as flongnumber, to_char(null) as FName, to_char(null) as FAsstID, to_char('1') as FCashType, ");
            sql.append(" cfr.FAmount*(case when cfi1.FDirection=2 then -1 else 1 end) as FAmount,cfi2.fisenable, ");
            sql.append(" cp.fid as FCompanyID, cp.fparentid as FParentID, cp.fisbizunit as FIsBizUnit, cp.flevel as FCompanyLevel, cfi2.flevel as FItemLevel from ");
            sql.append(" T_BD_CashFlowItem cfi1 ");
            sql.append(" inner join T_BD_CashFlowItem cfi2 ");
            sql.append(" on (charindex(cfi2.FLongNumber||'!',cfi1.FLongNumber) = 1 ");
            sql.append(" or cfi2.FLongNumber=cfi1.FLongNumber) ");
            sql.append(" left outer join (");
            sql.append(" select ");
            sql.append(" voucher.FCompanyID,");
            sql.append(idFiled);
            sql.append(",(");
            sql.append(amountField);
            sql.append("*");
            sql.append(rateField);
            sql.append(") as FAmount");
            sql.append(" from T_GL_CashflowRecord cfr \n");
            sql.append(" join T_GL_Voucher voucher on cfr.FVoucherID = voucher.FID \n");
            sql.append(" INNER JOIN t_bd_accountview av ON av.fid = cfr.faccountid \n");
            sql.append(" AND av.fcompanyid = voucher.FCompanyID \n");
            if (!isGlCurrency && !isGLRptCurrency && cashFlowFilterPara.isOldVersion()) {
                sql.append(" join T_GL_VoucherEntry ve on cfr.FEntryID = ve.FID \n");
            }
            sql.append(" where voucher.FCompanyID in ( " + cashFlowFilterPara.getCompanyIds() + " ) \n");
            sql.append(" AND av.faccounttableid = '" + cashFlowFilterPara.getAccountTabel().getId().toString() + "' \n");
            if (itemFilterSql != null) {
                sql.append(" and " + idFiled + " in ( ").append(itemFilterSql).append(" ) ");
            }
            sql.append(" AND ");
            if (periodIdsStr != null) {
                sql.append(" voucher.FPeriodID in " + periodIdsStr + "\r\n");
            } else {
                int[] periodRange = new int[]{startPeriod, cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo()};
                sql.append(SQLUtil.getPeriodCondition(" period.FNumber", periodRange));
            }
            if (!isGlCurrency && !isGLRptCurrency) {
                if (cashFlowFilterPara.isOldVersion()) {
                    sql.append(" and ve.FCurrencyID = ");
                } else {
                    sql.append(" and cfr.FCurrencyID = ");
                }
                sql.append("'" + currencyId + "' \r\n");
            }
            sql.append(" and voucher.FBizStatus in(");
            sql.append(5);
            if (cashFlowFilterPara.isAllVoucher()) {
                sql.append(",");
                sql.append(3);
                sql.append(",");
                sql.append(1);
            }
            sql.append(") )as cfr");
            sql.append(" on ");
            sql.append(idFiled);
            sql.append(" = cfi1.FID ");
            sql.append(" left outer join T_ORG_COMPANY cp on cp.fid = cfr.FCompanyID \n");
            sql.append(" where ");
            sql.append(" cfi2.FType = " + itemType + " \n");
            sql.append(" and cfi2.FLevel <= ");
            int level = cashFlowFilterPara.getLevel();
            int lv = level == 1 ? 2 : (int)level;
            sql.append(lv + " \n");
            sql.append("and (cfr.FAmount is not null or cfr.FAmount <> 0)  \n");
            if (cashFlowFilterPara.isDisplayAsst()) {
                ObjectUuidPK comPk = new ObjectUuidPK(this.curCompany.getId().toString());
                RptParams pp = new RptParams();
                pp.setObject("GL_004", (Object)comPk);
                IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
                HashMap allParam = pc.getParamHashMap(new HashMap(pp.toMap()));
                String ssistItemName = "flongnamegroup_" + ctx.getLocale().toString();
                if (allParam.get("GL_004") != null && Boolean.valueOf(allParam.get("GL_004").toString()).booleanValue()) {
                    ssistItemName = "fdisplaynamegroup_" + ctx.getLocale().toString();
                }
                StringBuffer asstSql = new StringBuffer(512);
                asstSql.append(" union all \n");
                asstSql.append(" select cfi2.flongnumber,replace(hg." + ssistItemName + ",'_!',' ') as FName,\n");
                asstSql.append(" hg.fid FAsstID, \n");
                asstSql.append(" to_char((case when cfr.FType =3 then 3 else 2 end)) as FCashType, \n");
                asstSql.append(" case when cfr.FAmount is null then 0 else cfr.FAmount*(case when cfi2.FDirection=2 then -1 else 1 end) end as FAmount, \n");
                asstSql.append(" cfi2.fisenable, cp.fid as FCompanyID, cp.fparentid as FParentID, cp.fisbizunit as FIsBizUnit, cp.flevel as FCompanyLevel, cfi2.flevel as FItemLevel from \n");
                asstSql.append(" T_BD_CashFlowItem cfi2 ");
                asstSql.append(" left outer join (");
                asstSql.append(" select voucher.FCompanyID,cfr.FAssgrpID,cfr.FType, \n");
                asstSql.append(idFiled);
                asstSql.append(",(");
                asstSql.append(amountField);
                asstSql.append("*");
                asstSql.append(rateField);
                asstSql.append(") as FAmount");
                asstSql.append(" from T_GL_CashflowRecord cfr \n");
                asstSql.append(" join T_GL_Voucher voucher on cfr.FVoucherID = voucher.FID \n");
                asstSql.append(" join T_BD_Period period on voucher.FPeriodID = period.FID \n");
                asstSql.append(" join T_GL_VoucherEntry ve on cfr.FEntryID = ve.FID \n");
                asstSql.append(" INNER JOIN t_bd_accountview av ON av.fid = cfr.faccountid \n");
                asstSql.append(" AND av.fcompanyid = voucher.FCompanyID \n");
                asstSql.append(" where voucher.FCompanyID in ( " + cashFlowFilterPara.getCompanyIds() + " ) \n");
                asstSql.append(" AND av.faccounttableid = '" + cashFlowFilterPara.getAccountTabel().getId().toString() + "' \n");
                if (itemFilterSql != null) {
                    asstSql.append(" and " + idFiled + " in ( ").append(itemFilterSql).append(" ) ");
                }
                asstSql.append(" and ");
                if (periodIdsStr != null) {
                    asstSql.append(" voucher.FPeriodID in " + periodIdsStr + "\r\n");
                } else {
                    int[] periodRange = new int[]{startPeriod, cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo()};
                    asstSql.append(SQLUtil.getPeriodCondition(" period.FNumber", periodRange));
                }
                if (!isGlCurrency && !isGLRptCurrency) {
                    asstSql.append(" and ve.FCurrencyID = '" + currencyId + "' \r\n");
                }
                asstSql.append(" and voucher.FBizStatus in(");
                asstSql.append(5);
                if (cashFlowFilterPara.isAllVoucher()) {
                    asstSql.append(",");
                    asstSql.append(3);
                    asstSql.append(",");
                    asstSql.append(1);
                }
                asstSql.append("  ))cfr ");
                asstSql.append(" on " + idFiled + " = cfi2.FID ");
                asstSql.append(" left join t_bd_assistanthg hg on cfr.fassgrpid=hg.fid \n");
                asstSql.append(" left join T_ORG_COMPANY cp on cp.fid = cfr.FCompanyID \n");
                asstSql.append(" where ");
                asstSql.append(" cfi2.fisenable=1 and ");
                asstSql.append(" cfi2.fisleaf=1 and cfi2.flevel>1  and cfi2.FType = " + itemType + " \r\n");
                asstSql.append(" and cfi2.FLevel <= " + lv + " \r\n");
                sql.append(asstSql);
            }
            sql.append(" ) as A group by flongnumber,FName,FAsstID,FCashType,FIsEnable,FCompanyID,FParentID,FISBizUnit, FCompanyLevel, FItemLevel \r\n");
            sql.append(" having sum(FAmount) <> 0 \r\n");
            map = new HashMap<String, MapParam>();
            SqlParams sp = new SqlParams();
            Connection conn = null;
            IRowSet rs = null;
            String tempTable = "query_year_total";
            conn = this.getConnection(ctx);
            try {
                tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(" create table " + tempTable + "  (FLongnumber varchar(400),FName varchar(400),FAsstID varchar(80),FCashType int,FAMOUNT decimal(28, 10),FIsEnable int,FCompanyID varchar(80),FParentID varchar(80),FisBizUnit int,FCompanyLevel int,FItemLevel int) ");
                DbUtil.execute((Context)ctx, (String)("insert into " + tempTable + sql.toString()));
                SimpleCompanyUserObject expandCompany = cashFlowFilterPara.getUseCompany();
                if (expandCompany == null || expandCompany.getLevel() + 1 < this.maxCompanyLevel) {
                    sql.setLength(0);
                    sql.append(" insert into " + tempTable + " (FLongnumber, FCashType, FAmount, FIsEnable, FCompanyID, FParentID, FIsbizUnit, FCompanyLevel, fitemLevel) \n");
                    sql.append(" select t.FLongnumber, 1 FCashType, sum(t.FAmount) FAmount, t.FIsEnable, cp.fid FCompanyID, cp.FParentID, cp.FIsbizUnit, cp.FLevel FCompanyLevel, t.fitemLevel \n");
                    sql.append(" from " + tempTable + " t \n");
                    sql.append(" inner join t_org_company cp on cp.fid = t.fparentid \n");
                    sql.append(" where t.fcompanyLevel = ? \n");
                    sql.append(" and t.fcashtype = '1' \n");
                    sql.append(" group by t.FLongnumber, t.FIsEnable, cp.fid, cp.FParentID, cp.FIsbizUnit, cp.FLevel, t.fitemLevel \n");
                    PreparedStatement ps = conn.prepareStatement(sql.toString());
                    level = expandCompany == null ? this.curCompany.getLevel() : expandCompany.getLevel() + 1;
                    for (int i = this.maxCompanyLevel; i > level; --i) {
                        ps.setInt(1, i);
                        ps.addBatch();
                    }
                    ps.executeBatch();
                    ps.clearBatch();
                    SQLUtils.cleanup((Statement)ps);
                }
                sql.setLength(0);
                sql.append(" select FLongnumber, FName, FAsstID, FCashType, FAmount, FIsEnable, FCompanyID, FParentID, FIsbizUnit, FCompanyLevel \n");
                sql.append(" from " + tempTable + " \n");
                int limitCompanyLevel = this.curCompany.getLevel();
                limitCompanyLevel = expandCompany == null ? (limitCompanyLevel += cashFlowFilterPara.getExpandCompanyLevel() - 1) : (cashFlowFilterPara.isExpandAll() ? this.maxCompanyLevel : expandCompany.getLevel() + 1);
                sql.append(" where FCompanyLevel <= " + limitCompanyLevel);
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    String FLongNumber = rs.getString(1);
                    String FName = rs.getString(2);
                    String FAsstID = rs.getString(3);
                    CashflowTypeEnum FCashType = CashflowTypeEnum.getEnum((int)rs.getInt(4));
                    BigDecimal FAmount = rs.getBigDecimal(5);
                    Integer FIsEnable = rs.getInt(6);
                    String FCompanyID = rs.getString(7);
                    Integer FCompanyLevel = rs.getInt(10);
                    if (FLongNumber == null || FAmount == null) continue;
                    MapParam m = new MapParam();
                    m.FLongNumber = FLongNumber;
                    m.FName = FName;
                    m.FAsstID = FAsstID;
                    m.FCashType = FCashType;
                    m.FAmount = FAmount;
                    m.FIsEnable = FIsEnable;
                    m.FCompanyID = FCompanyID;
                    m.FCompanyLevel = FCompanyLevel;
                    String key = FCompanyID + FLongNumber + (StringUtils.isEmpty((String)FAsstID) ? "" : FAsstID) + FCashType;
                    map.put(key, m);
                }
                if (cashFlowFilterPara.getTotalType() == 2) {
                    sql.setLength(0);
                    sql.append(" select sum(FAmount), FCompanyID from " + tempTable);
                    sql.append(" where FItemLevel = 1 group by FCompanyID");
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    while (rs.next()) {
                        BigDecimal amount = rs.getBigDecimal(1);
                        String companyID = rs.getString(2);
                        MapParam m = new MapParam();
                        m.FAmount = amount;
                        m.FCompanyID = companyID;
                        String key = companyID + "null";
                        map.put(key, m);
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, null, (Connection)conn);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block27;
            }
            finally {
                SQLUtils.cleanup(rs, null, (Connection)conn);
                this._releaseTempTable(ctx, tempTable);
            }
            this._releaseTempTable(ctx, tempTable);
        }
        return map;
    }

    private void combineInitMap(Vector vec, Map map, CashFlowFilterPara cashFlowFilterPara) {
        boolean flag;
        if (vec == null || vec.size() < 1 || map == null || map.size() < 1) {
            return;
        }
        boolean bl = flag = cashFlowFilterPara.getType() == -1 || cashFlowFilterPara.getType() == 0;
        if (cashFlowFilterPara.isDisplayAsst() && flag) {
            this.combineAsstMap(vec, map, cashFlowFilterPara);
        }
        int l = vec.size();
        for (int i = 0; i < l; ++i) {
            Object[] obj = (Object[])vec.elementAt(i);
            String key = (String)obj[11] + (String)obj[0] + (StringUtils.isEmpty((String)((String)obj[12])) ? "" : obj[12].toString()) + (obj[9] == null ? "" : CashflowTypeEnum.getEnum((int)((CashflowTypeEnum)obj[9]).getValue()));
            if (map.get(key) == null) continue;
            BigDecimal init = ((MapParam)map.get((Object)key)).FAmount;
            obj[14] = ((BigDecimal)obj[14]).add(init);
        }
    }

    private void combineSumMap(Vector vec, Map map, CashFlowFilterPara cashFlowFilterPara) {
        boolean flag;
        if (vec == null || vec.size() < 1 || map == null || map.size() < 1) {
            return;
        }
        boolean bl = flag = cashFlowFilterPara.getTotalType() == -1 || cashFlowFilterPara.getTotalType() == 0;
        if (cashFlowFilterPara.isDisplayAsst() && flag) {
            this.combineAsstMap(vec, map, cashFlowFilterPara);
        }
        int l = vec.size();
        for (int i = 0; i < l; ++i) {
            Object[] obj = (Object[])vec.elementAt(i);
            String key = (String)obj[11] + (String)obj[0] + (StringUtils.isEmpty((String)((String)obj[12])) ? "" : obj[12].toString()) + (obj[9] == null ? "" : CashflowTypeEnum.getEnum((int)((CashflowTypeEnum)obj[9]).getValue()));
            if (map.get(key) == null) continue;
            obj[14] = ((MapParam)map.get((Object)key)).FAmount;
            if ((obj[3] == null || (Integer)obj[3] != 2) && cashFlowFilterPara.getCashFlowDirection() != 2) continue;
            obj[14] = ((BigDecimal)obj[14]).multiply(new BigDecimal(-1));
        }
    }

    private void combineAsstMap(Vector vec, Map map, CashFlowFilterPara cashFlowFilterPara) {
        Object[] obj;
        String key = null;
        HashMap candidateMap = new HashMap();
        Collection coll = map.values();
        Iterator it = coll.iterator();
        boolean isCandidate = false;
        while (it.hasNext()) {
            List<MapParam> list;
            MapParam mp = (MapParam)it.next();
            isCandidate = mp.FIsEnable != null ? mp.FIsEnable == 1 && !CashflowTypeEnum.NONE.equals((Object)mp.FCashType) : !CashflowTypeEnum.NONE.equals((Object)mp.FCashType);
            key = mp.FCompanyID + mp.FLongNumber;
            if (isCandidate && candidateMap.containsKey(key)) {
                list = (List)candidateMap.get(key);
                list.add(mp);
                continue;
            }
            if (!isCandidate) continue;
            list = new ArrayList<MapParam>();
            list.add(mp);
            candidateMap.put(key, list);
        }
        HashMap<String, Integer> excludeMap = new HashMap<String, Integer>();
        HashMap<String, Object[]> acceptMap = new HashMap<String, Object[]>();
        int l = vec.size();
        for (int i = 0; i < l; ++i) {
            obj = (Object[])vec.elementAt(i);
            key = (String)obj[11] + (String)obj[0] + (obj[12] == null ? "" : obj[12].toString()) + (obj[9] == null ? "" : CashflowTypeEnum.getEnum((int)((CashflowTypeEnum)obj[9]).getValue()));
            if (obj[9] != null && !CashflowTypeEnum.NONE.equals((Object)((CashflowTypeEnum)obj[9]))) {
                excludeMap.put(key, new Integer(i));
                continue;
            }
            acceptMap.put(key, obj);
        }
        Vector vecClone = (Vector)vec.clone();
        int l2 = vecClone.size();
        for (int i = 0; i < l2; ++i) {
            obj = (Object[])vecClone.elementAt(i);
            key = (String)obj[11] + (String)obj[0];
            List list = (List)candidateMap.get(key);
            if (list == null) continue;
            for (int j = 0; j < list.size(); ++j) {
                MapParam mp = (MapParam)list.get(j);
                key = mp.FCompanyID + mp.FLongNumber + (mp.FAsstID == null ? "" : mp.FAsstID) + mp.FCashType;
                if (excludeMap.containsKey(key)) continue;
                Object[] ps = (Object[])acceptMap.get(mp.FCompanyID + mp.FLongNumber);
                int index = vec.indexOf(ps);
                Object[] pi = (Object[])ps.clone();
                pi[4] = BigDecimal.ZERO;
                pi[9] = mp.FCashType;
                pi[10] = mp.FName;
                pi[12] = mp.FAsstID;
                vec.insertElementAt(pi, index + 1);
                excludeMap.put(key, 1);
                ps[13] = true;
            }
        }
    }

    private Vector combinDataForPrimaryItem(Context ctx, Vector vec, CashFlowFilterPara cashFlowFilterPara, Map cashBalance, Map sumCashBalance) throws EASBizException, BOSException {
        boolean isAsst = cashFlowFilterPara.isDisplayAsst();
        Vector<Object[]> vecReturn = new Vector<Object[]>();
        int firstLevelSeq = 1;
        int sizeVec = vec == null ? 0 : vec.size();
        short maxLevel = cashFlowFilterPara.getLevel();
        String sumName = null;
        Object cashItme = null;
        Object cashItmeForLevel2 = null;
        BigDecimal bdTotal = BigDecimal.ZERO;
        BigDecimal bdYearTotal = BigDecimal.ZERO;
        BigDecimal bdInSum = BigDecimal.ZERO;
        BigDecimal bdInYearSum = BigDecimal.ZERO;
        BigDecimal bdOutSum = BigDecimal.ZERO;
        BigDecimal bdOutYearSum = BigDecimal.ZERO;
        BigDecimal bdCashSum = BigDecimal.ZERO;
        BigDecimal bdCashYearSum = BigDecimal.ZERO;
        HashMap<Object, Object> mapItemName = new HashMap<Object, Object>();
        LinkedHashMap<Object, Object[]> mapTotal = new LinkedHashMap<Object, Object[]>();
        LinkedHashMap<Object, Object[]> mapNetAmount = new LinkedHashMap<Object, Object[]>();
        LinkedHashMap mapInTotal = new LinkedHashMap();
        LinkedHashMap mapOutTotal = new LinkedHashMap();
        LinkedHashMap mapYearInTotal = new LinkedHashMap();
        LinkedHashMap mapYearOutTotal = new LinkedHashMap();
        HashMap mapYearSum = new HashMap();
        for (int i = 0; i < sizeVec; ++i) {
            Object[] objSum;
            Object companyId;
            Map.Entry entry;
            Iterator it;
            Object[] arrayObj = (Object[])vec.elementAt(i);
            int thisLevel = (Integer)arrayObj[2];
            int thisDirection = (Integer)arrayObj[3];
            int thisIsLeaf = (Integer)arrayObj[5];
            boolean thisIsExchange = (Boolean)arrayObj[8];
            BigDecimal thisAmount = (BigDecimal)arrayObj[4];
            BigDecimal thisYearAmount = (BigDecimal)arrayObj[14];
            Object[] arrayData = null;
            arrayData = new Object[12];
            if (thisLevel == 2) {
                cashItmeForLevel2 = arrayObj[7];
            }
            if (cashFlowFilterPara.getType() == -1 && thisLevel == 1 && (cashFlowFilterPara.isDisplayExchangeSubsidiary() || !thisIsExchange)) {
                if (!mapItemName.containsKey(arrayObj[0])) {
                    arrayData[0] = ResourceBase.getString((String)resClassName, (String)String.valueOf(firstLevelSeq++), (Locale)ctx.getLocale()) + (String)arrayObj[1];
                    mapItemName.put(arrayObj[0], arrayData[0]);
                    sumName = (String)arrayObj[1];
                    cashItme = arrayObj[7];
                    vecReturn.addElement(arrayData);
                }
                if (thisIsExchange) {
                    bdCashSum = (BigDecimal)arrayObj[4];
                    bdCashYearSum = (BigDecimal)arrayObj[14];
                }
            } else if (cashFlowFilterPara.getType() == -1 && maxLevel != 1 && (cashFlowFilterPara.isDisplayExchangeSubsidiary() || !thisIsExchange)) {
                arrayData[0] = this.getBlankString(thisLevel) + arrayObj[1];
                if (!(i <= 0 || arrayObj[1].toString().equals(" ") || ((Object[])vec.elementAt(i - 1))[1].toString().equals(" ") || ((Object[])vec.elementAt(i - 1))[1].toString().equals(arrayObj[1].toString()))) {
                    ++this.lineIndex;
                }
                arrayData[1] = new Integer(this.lineIndex);
                arrayData[2] = arrayObj[4];
                arrayData[5] = arrayObj[7];
                if (isAsst) {
                    arrayData[6] = arrayObj[9];
                    arrayData[7] = arrayObj[10];
                    arrayData[9] = arrayObj[12];
                    arrayData[10] = arrayObj[13];
                }
                arrayData[8] = arrayObj[11];
                arrayData[11] = arrayObj[14];
                vecReturn.addElement(arrayData);
            } else if (thisLevel == 1) {
                sumName = (String)arrayObj[1];
                cashItme = arrayObj[7];
                if (thisIsExchange) {
                    bdCashSum = (BigDecimal)arrayObj[4];
                    bdCashYearSum = (BigDecimal)arrayObj[14];
                }
            }
            if (cashFlowFilterPara.getType() == -1 && thisDirection != 0) {
                if ((thisIsLeaf == 1 || maxLevel == 1 && thisLevel == 2 || maxLevel > 1 && thisLevel == maxLevel) && (!isAsst || isAsst && arrayObj[9] == null)) {
                    if (cashFlowFilterPara.getExpandCompanyLevel() == 1) {
                        if (thisDirection == 1) {
                            bdInSum = bdInSum.add(thisAmount);
                            bdInYearSum = bdInYearSum.add(thisYearAmount);
                        } else if (thisDirection == 2) {
                            bdOutSum = bdOutSum.add(thisAmount);
                            bdOutYearSum = bdOutYearSum.add(thisYearAmount);
                        }
                    }
                    bdTotal = bdTotal.add(thisAmount);
                    bdYearTotal = bdYearTotal.add(thisYearAmount);
                    if (i + 1 == sizeVec || cashFlowFilterPara.getExpandCompanyLevel() == 1 || i < sizeVec - 1 && arrayObj[11] != null && vec.elementAt(i + 1) != null && ((Object[])vec.elementAt(i + 1))[11] != null && !arrayObj[11].toString().equals(((Object[])vec.elementAt(i + 1))[11]) || isAsst && ((Boolean)arrayObj[13]).booleanValue()) {
                        Object[] objtotal;
                        if (!mapTotal.containsKey(arrayObj[11].toString())) {
                            objtotal = new Object[12];
                            objtotal[0] = thisDirection == 1 ? this.getBlankString(2) + this.getResource(ctx, "strInTotal") : this.getBlankString(2) + this.getResource(ctx, "strOutTotal");
                            objtotal[2] = bdTotal;
                            objtotal[4] = Boolean.TRUE;
                            if (maxLevel != 1 && (cashFlowFilterPara.isDisplayExchangeSubsidiary() || !thisIsExchange)) {
                                objtotal[5] = cashItmeForLevel2;
                                objtotal[8] = arrayObj[11];
                                mapTotal.put(arrayObj[11], objtotal);
                            }
                            objtotal[11] = bdYearTotal;
                        } else {
                            objtotal = (Object[])mapTotal.get(arrayObj[11].toString());
                            objtotal[2] = ((BigDecimal)objtotal[2]).add(bdTotal);
                            objtotal[11] = ((BigDecimal)objtotal[11]).add(bdYearTotal);
                        }
                        bdTotal = BigDecimal.ZERO;
                        bdYearTotal = BigDecimal.ZERO;
                    }
                }
                if (i + 1 == sizeVec || (Integer)((Object[])vec.elementAt(i + 1))[3] != thisDirection) {
                    it = mapTotal.entrySet().iterator();
                    if (it.hasNext()) {
                        ++this.lineIndex;
                        while (it.hasNext()) {
                            entry = it.next();
                            Object[] objTotal = (Object[])entry.getValue();
                            objTotal[1] = new Integer(this.lineIndex);
                            vecReturn.addElement(objTotal);
                            companyId = entry.getKey();
                            if (1 == thisDirection) {
                                if (mapInTotal.containsKey(companyId)) {
                                    mapInTotal.put(companyId, ((BigDecimal)mapInTotal.get(companyId)).add((BigDecimal)objTotal[2]));
                                } else {
                                    mapInTotal.put(companyId, objTotal[2]);
                                }
                                if (mapYearInTotal.containsKey(companyId)) {
                                    mapYearInTotal.put(companyId, ((BigDecimal)mapYearInTotal.get(companyId)).add((BigDecimal)objTotal[2]));
                                    continue;
                                }
                                mapYearInTotal.put(companyId, objTotal[11]);
                                continue;
                            }
                            if (2 != thisDirection) continue;
                            if (mapOutTotal.containsKey(companyId)) {
                                mapOutTotal.put(companyId, ((BigDecimal)mapOutTotal.get(companyId)).add((BigDecimal)objTotal[2]));
                            } else {
                                mapOutTotal.put(companyId, objTotal[2]);
                            }
                            if (mapYearOutTotal.containsKey(companyId)) {
                                mapYearOutTotal.put(companyId, ((BigDecimal)mapYearOutTotal.get(companyId)).add((BigDecimal)objTotal[2]));
                                continue;
                            }
                            mapYearOutTotal.put(companyId, objTotal[11]);
                        }
                    }
                    mapTotal.clear();
                }
            }
            if (cashFlowFilterPara.getType() == -1 && thisLevel == 2 && (!isAsst || isAsst && arrayObj[9] == null)) {
                if (thisDirection == 1) {
                    bdInSum = bdInSum.add(thisAmount);
                    bdInYearSum = bdInYearSum.add(thisYearAmount);
                } else if (thisDirection == 2) {
                    bdOutSum = bdOutSum.add(thisAmount);
                    bdOutYearSum = bdOutYearSum.add(thisYearAmount);
                }
                if (i + 1 == sizeVec || cashFlowFilterPara.getExpandCompanyLevel() == 1 || i < sizeVec - 1 && arrayObj[11] != null && vec.elementAt(i + 1) != null && ((Object[])vec.elementAt(i + 1))[11] != null && !arrayObj[11].toString().equals(((Object[])vec.elementAt(i + 1))[11]) || isAsst && ((Object[])vec.elementAt(i + 1))[9] != null && arrayObj[0].equals(((Object[])vec.elementAt(i + 1))[0]) && arrayObj[11] != null && arrayObj[11].toString().equals(((Object[])vec.elementAt(i + 1))[11])) {
                    if (!mapNetAmount.containsKey(arrayObj[11].toString())) {
                        objSum = new Object[12];
                        if (cashFlowFilterPara.isDisplayExchangeSubsidiary() || !thisIsExchange) {
                            objSum[0] = this.getBlankString(2) + this.getSumString(ctx, sumName);
                        } else if (!mapItemName.containsKey(arrayObj[0])) {
                            objSum[0] = ResourceBase.getString((String)resClassName, (String)String.valueOf(firstLevelSeq++), (Locale)ctx.getLocale()) + sumName;
                            mapItemName.put(arrayObj[0], objSum[0]);
                        } else {
                            objSum[0] = mapItemName.get(arrayObj[0].toString());
                        }
                        if (cashFlowFilterPara.getExpandCompanyLevel() == 1 && thisIsExchange) {
                            objSum[2] = bdCashSum;
                            objSum[11] = bdCashYearSum;
                            bdCashSum = BigDecimal.ZERO;
                            bdCashYearSum = BigDecimal.ZERO;
                        } else {
                            objSum[2] = bdInSum.subtract(bdOutSum);
                            objSum[11] = bdInYearSum.subtract(bdOutYearSum);
                        }
                        objSum[4] = Boolean.TRUE;
                        objSum[5] = cashItme;
                        objSum[8] = arrayObj[11];
                        mapNetAmount.put(arrayObj[11], objSum);
                    } else {
                        objSum = (Object[])mapNetAmount.get(arrayObj[11].toString());
                        if (thisDirection == 1) {
                            objSum[2] = ((BigDecimal)objSum[2]).add(thisAmount);
                            objSum[11] = ((BigDecimal)objSum[11]).add(thisYearAmount);
                        } else if (thisDirection == 2) {
                            objSum[2] = ((BigDecimal)objSum[2]).subtract(thisAmount);
                            objSum[11] = ((BigDecimal)objSum[11]).subtract(thisYearAmount);
                        }
                    }
                    bdInSum = BigDecimal.ZERO;
                    bdInYearSum = BigDecimal.ZERO;
                    bdOutSum = BigDecimal.ZERO;
                    bdOutYearSum = BigDecimal.ZERO;
                }
            }
            if (cashFlowFilterPara.getType() == -1 && (i + 1 == sizeVec || (Integer)((Object[])vec.elementAt(i + 1))[2] == 1)) {
                it = mapNetAmount.entrySet().iterator();
                if (it.hasNext()) {
                    ++this.lineIndex;
                    while (it.hasNext()) {
                        entry = it.next();
                        Object[] objOutSum = (Object[])entry.getValue();
                        objOutSum[1] = new Integer(this.lineIndex);
                        vecReturn.addElement(objOutSum);
                        companyId = entry.getKey().toString();
                        if (mapInTotal.containsKey(companyId) || mapOutTotal.containsKey(companyId)) {
                            BigDecimal inSum = mapInTotal.containsKey(companyId) ? (BigDecimal)mapInTotal.get(companyId) : new BigDecimal("0");
                            BigDecimal outSum = mapOutTotal.containsKey(companyId) ? (BigDecimal)mapOutTotal.get(companyId) : new BigDecimal("0");
                            objOutSum[2] = inSum.subtract(outSum);
                        }
                        if (mapYearInTotal.containsKey(companyId) || mapYearOutTotal.containsKey(companyId)) {
                            BigDecimal yearInSum = mapYearInTotal.containsKey(companyId) ? (BigDecimal)mapYearInTotal.get(companyId) : new BigDecimal("0");
                            BigDecimal yearOutSum = mapYearOutTotal.containsKey(companyId) ? (BigDecimal)mapYearOutTotal.get(companyId) : new BigDecimal("0");
                            objOutSum[11] = yearInSum.subtract(yearOutSum);
                        }
                        if (mapYearSum.containsKey(companyId)) {
                            mapYearSum.put(companyId, ((BigDecimal)mapYearSum.get(companyId)).add((BigDecimal)objOutSum[11]));
                            continue;
                        }
                        mapYearSum.put(companyId, (BigDecimal)objOutSum[11]);
                    }
                }
                bdInSum = new BigDecimal("0");
                bdOutSum = new BigDecimal("0");
                mapNetAmount.clear();
                mapInTotal.clear();
                mapOutTotal.clear();
                mapYearInTotal.clear();
                mapYearOutTotal.clear();
            }
            if (cashFlowFilterPara.getType() == -1) continue;
            objSum = new Object[12];
            objSum[0] = cashFlowFilterPara.getCashName();
            objSum[1] = cashFlowFilterPara.getRowNum();
            objSum[2] = arrayObj[4];
            objSum[4] = cashFlowFilterPara.isSum();
            objSum[5] = arrayObj[7];
            objSum[6] = arrayObj[9];
            objSum[7] = arrayObj[10];
            objSum[8] = arrayObj[11];
            if (cashFlowFilterPara.isDisplayAsst()) {
                objSum[9] = arrayObj[12];
                objSum[10] = arrayObj[13];
            }
            objSum[11] = arrayObj[14];
            vecReturn.addElement(objSum);
        }
        if (cashFlowFilterPara.getType() == -1) {
            Object yearSumObj;
            Object[] objCashSum;
            Integer seven = new Integer(7);
            Integer eight = new Integer(8);
            Integer nine = new Integer(9);
            Vector diffAmount = this.getCashAmount(ctx, cashFlowFilterPara, 0);
            HashMap<Object, Object> daMap = new HashMap<Object, Object>();
            for (int i = 0; i < diffAmount.size(); ++i) {
                Object[] daObj = (Object[])diffAmount.get(i);
                if (daObj == null) continue;
                daMap.put(daObj[11], daObj[4]);
            }
            int curLevelSeq = firstLevelSeq++;
            int curLineIndex = this.lineIndex++;
            ++curLineIndex;
            for (int i = 0; i < diffAmount.size(); ++i) {
                objCashSum = new Object[12];
                objCashSum[0] = ResourceBase.getString((String)resClassName, (String)String.valueOf(curLevelSeq), (Locale)ctx.getLocale()) + this.getResource(ctx, "strCashSum");
                objCashSum[1] = new Integer(curLineIndex);
                objCashSum[2] = ((Object[])diffAmount.get(i))[4];
                objCashSum[4] = Boolean.TRUE;
                objCashSum[5] = seven;
                objCashSum[8] = ((Object[])diffAmount.get(i))[11];
                yearSumObj = mapYearSum.get(objCashSum[8]);
                if (yearSumObj != null) {
                    objCashSum[11] = yearSumObj;
                }
                vecReturn.addElement(objCashSum);
            }
            if (cashFlowFilterPara.isDisplayCashBalanceForBeginAndEnd() && cashBalance != null) {
                Object[] sumObj;
                Iterator it = cashBalance.values().iterator();
                curLineIndex = this.lineIndex++;
                ++curLineIndex;
                while (it.hasNext()) {
                    Object[] obj = (Object[])it.next();
                    objCashSum = new Object[12];
                    objCashSum[0] = this.getBlankString(2) + this.getResource(ctx, "strAddCashAndXjdjwBegin");
                    objCashSum[1] = new Integer(curLineIndex);
                    objCashSum[2] = ((BigDecimal)obj[0]).add((BigDecimal)obj[1]);
                    objCashSum[4] = Boolean.FALSE;
                    objCashSum[5] = eight;
                    objCashSum[8] = obj[4];
                    sumObj = (Object[])sumCashBalance.get(objCashSum[8]);
                    if (sumObj != null) {
                        objCashSum[11] = ((BigDecimal)sumObj[0]).add((BigDecimal)sumObj[1]);
                    }
                    vecReturn.addElement(objCashSum);
                }
                it = cashBalance.values().iterator();
                curLevelSeq = firstLevelSeq++;
                curLineIndex = this.lineIndex++;
                ++curLineIndex;
                while (it.hasNext()) {
                    Object[] obj = (Object[])it.next();
                    objCashSum = new Object[12];
                    objCashSum[0] = ResourceBase.getString((String)resClassName, (String)String.valueOf(curLevelSeq), (Locale)ctx.getLocale()) + this.getResource(ctx, "strCashAndXjdjwEndBanlance");
                    objCashSum[1] = new Integer(curLineIndex);
                    objCashSum[2] = ((BigDecimal)obj[0]).add((BigDecimal)obj[1]).add(daMap.containsKey(obj[4]) ? (BigDecimal)daMap.get(obj[4]) : BigDecimal.ZERO);
                    objCashSum[4] = Boolean.TRUE;
                    objCashSum[5] = nine;
                    objCashSum[8] = obj[4];
                    sumObj = (Object[])sumCashBalance.get(objCashSum[8]);
                    yearSumObj = mapYearSum.get(objCashSum[8]);
                    if (sumObj != null) {
                        objCashSum[11] = ((BigDecimal)sumObj[0]).add((BigDecimal)sumObj[1]).add(yearSumObj == null ? BigDecimal.ZERO : (BigDecimal)yearSumObj);
                    }
                    vecReturn.addElement(objCashSum);
                }
            }
        }
        return vecReturn;
    }

    private Vector getPeriodAccountBalance(Context ctx, CashFlowFilterPara cashFlowFilterPara, Map cashBalance, Map sumCashBalance, Map<String, BigDecimal> cashSumMap) throws EASBizException, BOSException {
        Vector<Object[]> vecReturn = new Vector<Object[]>();
        if (cashBalance == null) {
            return vecReturn;
        }
        Object[] obj2 = null;
        Object[] sumObj = null;
        Vector diffAmount = this.getCashAmount(ctx, cashFlowFilterPara, -1);
        HashMap<Object, Object> daMap = new HashMap<Object, Object>();
        for (int i = 0; i < diffAmount.size(); ++i) {
            Object[] daObj = (Object[])diffAmount.get(i);
            if (daObj == null) continue;
            daMap.put(daObj[11], daObj[4]);
        }
        for (Object[] obj2 : cashBalance.values()) {
            Object[] objCashSum = new Object[14];
            objCashSum[0] = cashFlowFilterPara.getCashName();
            objCashSum[1] = cashFlowFilterPara.getRowNum();
            objCashSum[4] = cashFlowFilterPara.getType() != 8;
            objCashSum[5] = cashFlowFilterPara.getType();
            objCashSum[7] = " ";
            objCashSum[8] = obj2[4];
            sumObj = (Object[])sumCashBalance.get(objCashSum[8]);
            if (cashFlowFilterPara.getType() == 7) {
                objCashSum[2] = daMap.get(objCashSum[8]);
                if (cashSumMap.containsKey(objCashSum[8])) {
                    objCashSum[11] = cashSumMap.get(objCashSum[8]);
                }
            } else if (cashFlowFilterPara.getType() == 8) {
                objCashSum[2] = ((BigDecimal)obj2[0]).add((BigDecimal)obj2[1]);
                if (sumObj != null) {
                    objCashSum[11] = ((BigDecimal)sumObj[0]).add((BigDecimal)sumObj[1]);
                }
            } else if (cashFlowFilterPara.getType() == 9) {
                objCashSum[2] = ((BigDecimal)obj2[0]).add((BigDecimal)obj2[1]).add(daMap.containsKey(objCashSum[8]) ? (BigDecimal)daMap.get(objCashSum[8]) : BigDecimal.ZERO);
                if (sumObj != null) {
                    objCashSum[11] = ((BigDecimal)sumObj[0]).add((BigDecimal)sumObj[1]).add(cashSumMap.containsKey(objCashSum[8]) ? cashSumMap.get(objCashSum[8]) : BigDecimal.ZERO);
                }
            }
            vecReturn.addElement(objCashSum);
        }
        return vecReturn;
    }

    private Vector combinDataForSecondaryItem(Context ctx, CashFlowFilterPara cashFlowFilterPara, Vector vec, String companyIds) throws BOSException, EASBizException {
        Vector<Object[]> vecReturn;
        block31: {
            Object[] value;
            Object[] array5;
            Integer fifteen;
            ArrayList<String> sumTotalList;
            LinkedHashMap<Object, Object> bdYearTotal;
            LinkedHashMap<Object, Object> bdTotal;
            Map<String, BigDecimal> sumAmounts;
            Vector values;
            block32: {
                int i;
                vecReturn = new Vector<Object[]>();
                values = this.getRetainedProfits(ctx, cashFlowFilterPara);
                sumAmounts = this.getSumRetainedProfits(ctx, cashFlowFilterPara, companyIds);
                bdTotal = new LinkedHashMap<Object, Object>();
                bdYearTotal = new LinkedHashMap<Object, Object>();
                ArrayList<String> itemList = new ArrayList<String>();
                ArrayList<String> itemNameList = new ArrayList<String>();
                sumTotalList = new ArrayList<String>();
                int sizeVec = vec.size();
                short maxLevel = cashFlowFilterPara.getLevel();
                if (cashFlowFilterPara.getType() == -1 || cashFlowFilterPara.getType() == 1) {
                    int level = -1;
                    for (i = 0; i < sizeVec; ++i) {
                        BigDecimal yearSum;
                        BigDecimal newValue;
                        Object[] arrayObj = (Object[])vec.elementAt(i);
                        Object[] arrayData = new Object[14];
                        int thisLevel = (Integer)arrayObj[2];
                        arrayData[5] = arrayObj[7];
                        if (thisLevel <= 2) {
                            if (maxLevel == 1 && thisLevel > 1) continue;
                            arrayData[0] = this.getBlankString(thisLevel + 1) + arrayObj[1];
                            if (cashFlowFilterPara.getType() == -1 && !itemList.contains(arrayData[0].toString())) {
                                itemList.add(arrayData[0].toString());
                                vecReturn.addElement(arrayData);
                            }
                            if (arrayObj[11] == null || itemList.contains(arrayData[0].toString())) continue;
                            if (((HashMap)bdTotal).get(arrayObj[11]) == null) {
                                level = thisLevel;
                                bdTotal.put(arrayObj[11], arrayObj[4]);
                                bdYearTotal.put(arrayObj[11], arrayObj[14]);
                                continue;
                            }
                            if (level != -1 && thisLevel > level) continue;
                            if (arrayObj[4] == null) {
                                arrayObj[4] = BigDecimal.ZERO;
                            }
                            newValue = ((BigDecimal)((HashMap)bdTotal).get(arrayObj[11])).add((BigDecimal)arrayObj[4]);
                            bdTotal.put(arrayObj[11], newValue);
                            if (bdYearTotal.containsKey(arrayObj[11])) {
                                yearSum = ((BigDecimal)((HashMap)bdYearTotal).get(arrayObj[11])).add((BigDecimal)arrayObj[14]);
                                bdYearTotal.put(arrayObj[11], yearSum);
                            }
                            level = thisLevel;
                            continue;
                        }
                        if (cashFlowFilterPara.getType() == -1) {
                            if (!itemNameList.contains(arrayObj[1].toString())) {
                                ++this.lineIndex;
                                itemNameList.add(arrayObj[1].toString());
                            }
                            arrayData[1] = new Integer(this.lineIndex);
                            arrayData[0] = this.getBlankString(thisLevel + 1) + arrayObj[1];
                        } else {
                            arrayData[1] = cashFlowFilterPara.getRowNum();
                            arrayData[0] = cashFlowFilterPara.getCashName();
                        }
                        if (((Boolean)arrayObj[6]).booleanValue()) {
                            for (int j = 0; j < values.size(); ++j) {
                                Object[] value2 = (Object[])values.get(j);
                                if (!value2[1].equals(arrayObj[11])) continue;
                                arrayData[2] = value2[0];
                                break;
                            }
                            if (sumAmounts.containsKey(arrayObj[11])) {
                                arrayObj[14] = ((BigDecimal)arrayObj[14]).add(sumAmounts.get(arrayObj[11]));
                            }
                        } else {
                            arrayData[2] = arrayObj[4];
                            if (arrayObj[11] != null) {
                                if (((HashMap)bdTotal).get(arrayObj[11]) == null) {
                                    level = thisLevel;
                                    bdTotal.put(arrayObj[11], arrayObj[4]);
                                    bdYearTotal.put(arrayObj[11], arrayObj[14]);
                                } else if (level == -1 || thisLevel <= level) {
                                    if (arrayObj[4] == null) {
                                        arrayObj[4] = GlUtils.zero;
                                    }
                                    newValue = ((BigDecimal)((HashMap)bdTotal).get(arrayObj[11])).add((BigDecimal)arrayObj[4]);
                                    bdTotal.put(arrayObj[11], newValue);
                                    if (bdYearTotal.containsKey(arrayObj[11])) {
                                        yearSum = ((BigDecimal)((HashMap)bdYearTotal).get(arrayObj[11])).add((BigDecimal)arrayObj[14]);
                                        bdYearTotal.put(arrayObj[11], yearSum);
                                    }
                                    level = thisLevel;
                                }
                            }
                        }
                        arrayData[7] = arrayObj[10];
                        arrayData[8] = (String)arrayObj[11];
                        arrayData[10] = arrayObj[13];
                        arrayData[11] = arrayObj[14];
                        vecReturn.addElement(arrayData);
                    }
                }
                if (cashFlowFilterPara.getType() != -1 && cashFlowFilterPara.getType() != 15) break block31;
                fifteen = new Integer(15);
                if (cashFlowFilterPara.getType() != 15) break block32;
                for (i = 0; i < sizeVec; ++i) {
                    array5 = new Object[14];
                    Object[] arrayObj = (Object[])vec.elementAt(i);
                    if (arrayObj[4] == null) {
                        arrayObj[4] = GlUtils.zero;
                    }
                    array5[0] = cashFlowFilterPara.getCashName();
                    for (int j = 0; j < values.size(); ++j) {
                        value = (Object[])values.get(j);
                        if (value[0] == null) {
                            value[0] = GlUtils.zero;
                        }
                        if (!value[1].equals(arrayObj[11])) continue;
                        arrayObj[4] = ((BigDecimal)arrayObj[4]).add((BigDecimal)value[0]);
                        break;
                    }
                    if (sumAmounts.containsKey(arrayObj[11])) {
                        arrayObj[14] = ((BigDecimal)arrayObj[14]).add(sumAmounts.get(arrayObj[11]));
                    }
                    array5[1] = cashFlowFilterPara.getRowNum();
                    array5[2] = arrayObj[4];
                    array5[4] = Boolean.TRUE;
                    array5[5] = fifteen;
                    array5[7] = arrayObj[10];
                    array5[8] = arrayObj[11];
                    array5[10] = arrayObj[13];
                    array5[11] = arrayObj[14];
                    vecReturn.addElement(array5);
                }
                break block31;
            }
            Iterator itemTotal = ((HashMap)bdTotal).keySet().iterator();
            while (itemTotal.hasNext()) {
                String companyID;
                block34: {
                    block33: {
                        array5 = new Object[14];
                        companyID = (String)itemTotal.next();
                        if (values.size() != 0) break block33;
                        if (!bdTotal.containsKey(companyID)) break block34;
                        array5[2] = ((HashMap)bdTotal).get(companyID);
                        break block34;
                    }
                    for (int j = 0; j < values.size(); ++j) {
                        value = (Object[])values.get(j);
                        if (!companyID.equals(value[1])) continue;
                        if (bdTotal.containsKey(companyID)) {
                            array5[2] = ((BigDecimal)((HashMap)bdTotal).get(companyID)).add((BigDecimal)value[0]);
                            break;
                        }
                        array5[2] = value[0];
                        break;
                    }
                }
                BigDecimal sumAmount = sumAmounts.containsKey(companyID) ? sumAmounts.get(companyID) : BigDecimal.ZERO;
                array5[11] = bdYearTotal.containsKey(companyID) ? ((BigDecimal)((HashMap)bdYearTotal).get(companyID)).add(sumAmount) : sumAmount;
                array5[0] = this.getBlankString(2) + this.getResource(ctx, "strWork");
                if (cashFlowFilterPara.getType() == -1) {
                    if (!sumTotalList.contains(array5[0].toString())) {
                        ++this.lineIndex;
                        sumTotalList.add(array5[0].toString());
                    }
                    array5[1] = new Integer(this.lineIndex);
                } else {
                    array5[1] = cashFlowFilterPara.getRowNum();
                }
                array5[4] = Boolean.TRUE;
                array5[5] = fifteen;
                array5[7] = " ";
                array5[8] = companyID;
                vecReturn.addElement(array5);
            }
        }
        return vecReturn;
    }

    private Vector combinDataForSupplementaryItem(Context ctx, CashFlowFilterPara cashFlowFilterPara, Vector vec) throws BOSException {
        Vector<Object[]> vecReturn = new Vector<Object[]>();
        int sizeVec = vec.size();
        short maxLevel = cashFlowFilterPara.getLevel();
        ArrayList<String> itemNameList = new ArrayList<String>();
        ArrayList<String> itemList = new ArrayList<String>();
        for (int i = 0; i < sizeVec; ++i) {
            Object[] arrayObj = (Object[])vec.elementAt(i);
            int thisLevel = (Integer)arrayObj[2];
            Object[] arrayData = new Object[14];
            if (thisLevel <= 1) {
                arrayData[0] = this.getBlankString(thisLevel + 1) + arrayObj[1];
                if (itemList.contains(arrayData[0].toString())) continue;
                itemList.add(arrayData[0].toString());
                if (cashFlowFilterPara.getType() != -1) {
                    arrayData[1] = cashFlowFilterPara.getRowNum();
                }
                arrayData[5] = arrayObj[7];
                vecReturn.addElement(arrayData);
                continue;
            }
            if (maxLevel == 1) continue;
            arrayData[0] = this.getBlankString(thisLevel + 1) + arrayObj[1];
            if (!itemNameList.contains(arrayData[0].toString())) {
                ++this.lineIndex;
                itemNameList.add(arrayData[0].toString());
            }
            arrayData[1] = cashFlowFilterPara.getType() == -1 ? new Integer(this.lineIndex) : cashFlowFilterPara.getRowNum();
            arrayData[2] = arrayObj[4];
            arrayData[5] = arrayObj[7];
            arrayData[7] = arrayObj[10];
            arrayData[8] = arrayObj[11];
            vecReturn.addElement(arrayData);
        }
        return vecReturn;
    }

    private Vector getAdditionOfCash(Context ctx, CashFlowFilterPara cashFlowFilterPara, Map cashBalance, Map sumCashBalance) throws BOSException, EASBizException {
        Object[] sumObj;
        Object[] obj;
        Iterator it;
        Vector<Object[]> vecReturn = new Vector<Object[]>();
        Integer ten = new Integer(10);
        Integer eleven = new Integer(11);
        Integer twelve = new Integer(12);
        Integer thirteen = new Integer(13);
        Integer fourteen = new Integer(14);
        ArrayList<String> itemNameList = new ArrayList<String>();
        if (cashFlowFilterPara.getType() == -1) {
            Object[] array1 = new Object[14];
            array1[0] = this.getResource(ctx, "strAdd");
            vecReturn.addElement(array1);
        }
        if (cashFlowFilterPara.getType() == -1 || cashFlowFilterPara.getType() == 10) {
            it = cashBalance.values().iterator();
            obj = null;
            sumObj = null;
            while (it.hasNext()) {
                obj = (Object[])it.next();
                Object[] array2 = new Object[14];
                Object object = array2[0] = cashFlowFilterPara.getType() == -1 ? this.getBlankString(2) + this.getResource(ctx, "strCashEnd") : cashFlowFilterPara.getCashName();
                if (!itemNameList.contains(array2[0].toString())) {
                    ++this.lineIndex;
                    itemNameList.add(array2[0].toString());
                }
                array2[1] = cashFlowFilterPara.getType() == -1 ? new Integer(this.lineIndex) : cashFlowFilterPara.getRowNum();
                array2[2] = ((BigDecimal)obj[0]).add((BigDecimal)obj[2]);
                array2[5] = ten;
                array2[7] = " ";
                array2[8] = obj[4];
                sumObj = (Object[])sumCashBalance.get(obj[4]);
                if (sumObj != null) {
                    array2[11] = ((BigDecimal)sumObj[0]).add((BigDecimal)sumObj[2]);
                }
                vecReturn.addElement(array2);
            }
        }
        if (cashFlowFilterPara.getType() == -1 || cashFlowFilterPara.getType() == 11) {
            it = cashBalance.values().iterator();
            obj = null;
            sumObj = null;
            itemNameList.clear();
            while (it.hasNext()) {
                obj = (Object[])it.next();
                Object[] array3 = new Object[14];
                Object object = array3[0] = cashFlowFilterPara.getType() == -1 ? this.getBlankString(2) + this.getResource(ctx, "strJCahsBegin") : cashFlowFilterPara.getCashName();
                if (!itemNameList.contains(array3[0].toString())) {
                    ++this.lineIndex;
                    itemNameList.add(array3[0].toString());
                }
                array3[1] = cashFlowFilterPara.getType() == -1 ? new Integer(this.lineIndex) : cashFlowFilterPara.getRowNum();
                array3[2] = obj[0];
                array3[5] = eleven;
                array3[7] = " ";
                array3[8] = obj[4];
                sumObj = (Object[])sumCashBalance.get(obj[4]);
                if (sumObj != null) {
                    array3[11] = sumObj[0];
                }
                vecReturn.addElement(array3);
            }
        }
        if (cashFlowFilterPara.getType() == -1 || cashFlowFilterPara.getType() == 12) {
            it = cashBalance.values().iterator();
            obj = null;
            sumObj = null;
            itemNameList.clear();
            while (it.hasNext()) {
                obj = (Object[])it.next();
                Object[] array4 = new Object[14];
                Object object = array4[0] = cashFlowFilterPara.getType() == -1 ? this.getBlankString(2) + this.getResource(ctx, "strAddSjdjwEnd") : cashFlowFilterPara.getCashName();
                if (!itemNameList.contains(array4[0].toString())) {
                    ++this.lineIndex;
                    itemNameList.add(array4[0].toString());
                }
                array4[1] = cashFlowFilterPara.getType() == -1 ? new Integer(this.lineIndex) : cashFlowFilterPara.getRowNum();
                array4[2] = ((BigDecimal)obj[1]).add((BigDecimal)obj[3]);
                array4[5] = twelve;
                array4[7] = " ";
                array4[8] = obj[4];
                sumObj = (Object[])sumCashBalance.get(obj[4]);
                if (sumObj != null) {
                    array4[11] = ((BigDecimal)sumObj[1]).add((BigDecimal)sumObj[3]);
                }
                vecReturn.addElement(array4);
            }
        }
        if (cashFlowFilterPara.getType() == -1 || cashFlowFilterPara.getType() == 13) {
            it = cashBalance.values().iterator();
            obj = null;
            sumObj = null;
            itemNameList.clear();
            while (it.hasNext()) {
                obj = (Object[])it.next();
                Object[] array5 = new Object[14];
                Object object = array5[0] = cashFlowFilterPara.getType() == -1 ? this.getBlankString(2) + this.getResource(ctx, "strJSjdjwEnd") : cashFlowFilterPara.getCashName();
                if (!itemNameList.contains(array5[0].toString())) {
                    ++this.lineIndex;
                    itemNameList.add(array5[0].toString());
                }
                array5[1] = cashFlowFilterPara.getType() == -1 ? new Integer(this.lineIndex) : cashFlowFilterPara.getRowNum();
                array5[2] = obj[1];
                array5[5] = thirteen;
                array5[7] = " ";
                array5[8] = obj[4];
                sumObj = (Object[])sumCashBalance.get(obj[4]);
                if (sumObj != null) {
                    array5[11] = sumObj[1];
                }
                vecReturn.addElement(array5);
            }
        }
        if (cashFlowFilterPara.getType() == -1 || cashFlowFilterPara.getType() == 14) {
            it = cashBalance.values().iterator();
            obj = null;
            sumObj = null;
            itemNameList.clear();
            while (it.hasNext()) {
                obj = (Object[])it.next();
                Object[] array6 = new Object[14];
                Object object = array6[0] = cashFlowFilterPara.getType() == -1 ? this.getBlankString(2) + this.getResource(ctx, "strCashAndXjdjw") : cashFlowFilterPara.getCashName();
                if (!itemNameList.contains(array6[0].toString())) {
                    ++this.lineIndex;
                    itemNameList.add(array6[0].toString());
                }
                array6[1] = cashFlowFilterPara.getType() == -1 ? new Integer(this.lineIndex) : cashFlowFilterPara.getRowNum();
                array6[2] = ((BigDecimal)obj[2]).add((BigDecimal)obj[3]);
                array6[5] = fourteen;
                array6[7] = " ";
                array6[8] = obj[4];
                sumObj = (Object[])sumCashBalance.get(obj[4]);
                if (sumObj != null) {
                    array6[11] = ((BigDecimal)sumObj[2]).add((BigDecimal)sumObj[3]);
                }
                vecReturn.addElement(array6);
            }
        }
        return vecReturn;
    }

    private Vector getRetainedProfits(Context ctx, CashFlowFilterPara cashFlowFilterPara) throws BOSException, EASBizException {
        Vector<Object[]> bdReturn = new Vector<Object[]>();
        ArrayList sp = new ArrayList();
        String sbSql = cashFlowFilterPara.isTermOrDate() ? this.getRetainedProfitsSqlByPeriod(ctx, cashFlowFilterPara, sp) : this.getRetainedProfitsSqlByDate(ctx, cashFlowFilterPara, sp);
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sbSql);
            for (int i = 0; i < sp.size(); ++i) {
                ps.setObject(i + 1, sp.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Object[] values = new Object[]{rs.getBigDecimal("FAmount"), rs.getString("FCompany")};
                bdReturn.add(values);
            }
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bdReturn;
    }

    private String getRetainedProfitsSqlByPeriod(Context ctx, CashFlowFilterPara cashFlowFilterPara, List sp) {
        StringBuffer sbSql = new StringBuffer("select ");
        if (this.curCompany.isIsBizUnit()) {
            sbSql.append(" b.forgunitid FCompany,");
        } else {
            sbSql.append(" cp.fid FCompany,");
        }
        boolean isForCurrency = false;
        if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
            sbSql.append(" sum(-1 * b.fmonthpnllocal) FAmount");
        } else if (cashFlowFilterPara.getCurrencyId().equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
            sbSql.append(" sum(-1 * b.fmonthpnlrpt) FAmount");
        } else {
            isForCurrency = true;
            sbSql.append(" sum(-1 * b.fmonthpnlfor) FAmount");
        }
        int baltype = cashFlowFilterPara.isAllVoucher() ? 1 : 5;
        sbSql.append(" from " + GLBalanceUtils.getAccountBalanceTable(baltype, cashFlowFilterPara.getCurrencyId()) + " b ");
        sbSql.append(" inner join T_BD_AccountView account on b.FAccountID = account.FID and b.forgunitid = account.fcompanyid ");
        sbSql.append(" left join t_bd_cashflowaccountdiff on fdiffaccountid=account.FID");
        sbSql.append(" inner join t_org_company cop on cop.fid = b.forgunitid ");
        sbSql.append(" inner join t_org_company cp on charindex(cp.flongnumber||'!', cop.flongnumber) = 1 or cop.fid = cp.fid");
        sbSql.append(" where b.forgunitid in (").append(cashFlowFilterPara.getCompanyIds()).append(")");
        if (cashFlowFilterPara.getUseCompany() != null && !cashFlowFilterPara.getUseCompany().getCompanyId().equals(this.curCompany.getId().toString())) {
            String longNumber = cashFlowFilterPara.getUseCompany().getLongNumber() + "!%";
            sbSql.append(" and cp.flongnumber like '").append(longNumber).append("'");
        }
        if (cashFlowFilterPara.getUseCompany() != null) {
            if (!cashFlowFilterPara.isExpandAll()) {
                sbSql.append(" and cp.flevel = ? ");
                sp.add(new Integer(cashFlowFilterPara.getUseCompany().getLevel() + 1));
            }
        } else if (cashFlowFilterPara.getExpandCompanyLevel() > 1) {
            sbSql.append(" and cp.flevel >= ? and cp.flevel <= ? ");
            sp.add(new Integer(this.curCompany.getLevel()));
            sp.add(new Integer(this.curCompany.getLevel() + cashFlowFilterPara.getExpandCompanyLevel() - 1));
        } else {
            sbSql.append(" and cp.flevel = ? ");
            sp.add(new Integer(this.curCompany.getLevel()));
        }
        sbSql.append(" and fdiffaccountid is null");
        sbSql.append(" and account.FPLType <> ").append(0);
        sbSql.append(" and account.flevel = 1 ");
        if (cashFlowFilterPara.getAccountTabel() != null) {
            sbSql.append(" and account.faccounttableid = ? \r\n");
            sp.add(cashFlowFilterPara.getAccountTabel().getId().toString());
        }
        sbSql.append(" and b.FPeriod >= ? and b.FPeriod <= ?");
        sp.add(new Integer(cashFlowFilterPara.getYearFrom() * 100 + cashFlowFilterPara.getMonthFrom()));
        sp.add(new Integer(cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo()));
        if (isForCurrency) {
            sbSql.append(" and b.FCurrencyID = ?");
            sp.add(cashFlowFilterPara.getCurrencyId());
        }
        if (this.curCompany.isIsBizUnit()) {
            sbSql.append(" group by b.forgunitid");
        } else {
            sbSql.append(" group by cp.fid,cp.flongnumber");
            sbSql.append(" order by cp.flongnumber");
        }
        return sbSql.toString();
    }

    private String getRetainedProfitsSqlByDate(Context ctx, CashFlowFilterPara cashFlowFilterPara, List sp) {
        StringBuffer sbSql = new StringBuffer("select ");
        if (this.curCompany.isIsBizUnit()) {
            sbSql.append(" voucher.FCompanyID FCompany,");
        } else {
            sbSql.append(" cp.fid FCompany,");
        }
        if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FLocalAmount else (-1) * FLocalAmount end) FAmount");
        } else {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FOriginalAmount else (-1) * FOriginalAmount end) FAmount");
        }
        sbSql.append(" from T_GL_Voucher voucher ");
        sbSql.append(" inner join T_GL_VoucherEntry ve on voucher.FID = ve.FBillID ");
        sbSql.append(" inner join T_BD_AccountView account on ve.FAccountID = account.FID ");
        sbSql.append(" left join t_bd_cashflowaccountdiff on fdiffaccountid=account.FID ");
        sbSql.append(" inner join t_org_company cop on cop.fid = voucher.FCompanyID ");
        sbSql.append(" inner join t_org_company cp on charindex(cp.flongnumber||'!', cop.flongnumber) = 1 or cop.fid = cp.fid");
        sbSql.append(" where voucher.FCompanyID");
        sbSql.append(" in (" + cashFlowFilterPara.getCompanyIds() + ")");
        if (cashFlowFilterPara.getUseCompany() != null && !cashFlowFilterPara.getUseCompany().getCompanyId().equals(this.curCompany.getId().toString())) {
            String longNumber = cashFlowFilterPara.getUseCompany().getLongNumber() + "!%";
            sbSql.append(" and cp.flongnumber like '").append(longNumber).append("'");
        }
        if (cashFlowFilterPara.getUseCompany() != null) {
            if (!cashFlowFilterPara.isExpandAll() && !cashFlowFilterPara.getUseCompany().getCompanyId().equals(this.curCompany.getId().toString())) {
                sbSql.append(" and cp.flevel = ? ");
                sp.add(new Integer(cashFlowFilterPara.getUseCompany().getLevel() + 1));
            }
        } else if (cashFlowFilterPara.getExpandCompanyLevel() > 1) {
            sbSql.append(" and cp.flevel >= ? and cp.flevel <= ? ");
            sp.add(new Integer(this.curCompany.getLevel()));
            sp.add(new Integer(this.curCompany.getLevel() + cashFlowFilterPara.getExpandCompanyLevel() - 1));
        } else {
            sbSql.append(" and cp.flevel = ? ");
            sp.add(new Integer(this.curCompany.getLevel()));
        }
        sbSql.append(" and fdiffaccountid is null");
        sbSql.append(" and account.FPLType <> ").append(0);
        if (cashFlowFilterPara.getAccountTabel() != null) {
            sbSql.append(" and account.faccounttableid = ? \r\n");
            sp.add(cashFlowFilterPara.getAccountTabel().getId().toString());
        }
        sbSql.append(" and voucher.FBookedDate >= ? and voucher.FBookedDate <= ?");
        sp.add(new Date(cashFlowFilterPara.getDateFrom().getTime()));
        sp.add(new Date(cashFlowFilterPara.getDateTo().getTime()));
        if (!cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
            sbSql.append(" and ve.FCurrencyID = ?");
            sp.add(cashFlowFilterPara.getCurrencyId());
        }
        sbSql.append(" and voucher.FSourceType<>1 ");
        sbSql.append(" and voucher.FBizStatus in(");
        sbSql.append(5);
        if (cashFlowFilterPara.isAllVoucher()) {
            sbSql.append(",");
            sbSql.append(1);
            sbSql.append(",");
            sbSql.append(3);
        }
        sbSql.append(")");
        if (this.curCompany.isIsBizUnit()) {
            sbSql.append(" group by voucher.FCompanyID");
        } else {
            sbSql.append(" group by cp.fid,cp.flongnumber");
            sbSql.append(" order by cp.flongnumber");
        }
        return sbSql.toString();
    }

    private Map<String, BigDecimal> getSumRetainedProfits(Context ctx, CashFlowFilterPara cashFlowFilterPara, String companyIds) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> bdReturn = new HashMap<String, BigDecimal>();
        if (!cashFlowFilterPara.isTermOrDate()) {
            return bdReturn;
        }
        boolean needComineInitValue = false;
        int minStartPeriod = this.getMinStartPeriod(ctx, cashFlowFilterPara.getCompanyIds());
        int yearFrom = minStartPeriod / 100;
        int monthFrom = minStartPeriod % 100;
        short yearTo = cashFlowFilterPara.getYearTo();
        short monthTo = cashFlowFilterPara.getMonthTo();
        if (yearFrom != yearTo) {
            yearFrom = yearTo;
            monthFrom = 1;
        } else {
            boolean bl = needComineInitValue = companyIds.length() > 0;
        }
        if (needComineInitValue && minStartPeriod % 100 == 1) {
            needComineInitValue = false;
        }
        String currencyId = cashFlowFilterPara.getCurrencyId();
        boolean isLocalCurrency = this.getGeneralLocalCurrency().equals(currencyId);
        boolean isRptCurrency = this.getGeneralReportCurrency().equals(currencyId);
        StringBuffer sbSql = new StringBuffer("select cp.FID FCompanyID, ");
        ArrayList param = new ArrayList();
        if (isLocalCurrency) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FLocalAmount else (-1) * FLocalAmount end) FAmount ");
        } else if (isRptCurrency) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FReportingAmount else (-1) * FReportingAmount end) FAmount ");
        } else {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FOriginalAmount else (-1) * FOriginalAmount end) FAmount ");
        }
        sbSql.append(" from T_GL_Voucher voucher join T_GL_VoucherEntry ve on voucher.FID = ve.FBillID join T_BD_AccountView account on ve.FAccountID = account.FID ");
        sbSql.append(" join T_BD_Period period on voucher.FPeriodID = period.FID ");
        sbSql.append(" left join t_bd_cashflowaccountdiff on fdiffaccountid=account.FID ");
        sbSql.append(" inner join t_org_company cop on cop.fid = voucher.FCompanyID ");
        sbSql.append(" inner join t_org_company cp on charindex(cp.flongnumber||'!', cop.flongnumber) = 1 or cop.fid = cp.fid");
        sbSql.append(" where voucher.FCompanyID in (");
        sbSql.append(cashFlowFilterPara.getCompanyIds() + ") ");
        sbSql.append(" and account.FCompanyID in (");
        sbSql.append(cashFlowFilterPara.getCompanyIds() + ") ");
        if (cashFlowFilterPara.getUseCompany() != null && !cashFlowFilterPara.getUseCompany().getCompanyId().equals(this.curCompany.getId().toString())) {
            String longNumber = cashFlowFilterPara.getUseCompany().getLongNumber() + "!%";
            sbSql.append(" and cp.flongnumber like '").append(longNumber).append("'");
        }
        if (cashFlowFilterPara.getUseCompany() != null) {
            if (!cashFlowFilterPara.isExpandAll()) {
                sbSql.append(" and cp.flevel = " + (cashFlowFilterPara.getUseCompany().getLevel() + 1));
            }
        } else if (cashFlowFilterPara.getExpandCompanyLevel() > 1) {
            sbSql.append(" and cp.flevel >= " + this.curCompany.getLevel());
            sbSql.append(" and cp.flevel <= " + (this.curCompany.getLevel() + cashFlowFilterPara.getExpandCompanyLevel() - 1));
        } else {
            sbSql.append(" and cp.flevel = " + this.curCompany.getLevel());
        }
        sbSql.append(" and fdiffaccountid is null");
        sbSql.append(" and account.FPLType <> " + new Integer(0));
        sbSql.append(" and account.FCategory = 1");
        sbSql.append(" and period.FPeriodYear >= " + yearFrom);
        sbSql.append(" and period.FPeriodNumber >= " + monthFrom);
        sbSql.append(" and period.FPeriodYear <= " + yearTo);
        sbSql.append(" and period.FPeriodNumber <= " + monthTo);
        if (!this.getGeneralLocalCurrency().equals(currencyId) && !this.getGeneralReportCurrency().equals(currencyId)) {
            sbSql.append(" and ve.FCurrencyID = '" + currencyId + "' ");
        }
        sbSql.append(" and voucher.FSourceType<>1 ");
        sbSql.append(" and voucher.FBizStatus in (");
        sbSql.append(5);
        if (cashFlowFilterPara.isAllVoucher()) {
            sbSql.append(",");
            sbSql.append(1);
            sbSql.append(",");
            sbSql.append(3);
        }
        sbSql.append(") ");
        sbSql.append(" group by cp.FID");
        if (needComineInitValue) {
            String diffAccountSet = CashFlowUtils.getDiff(ctx);
            String amountField = isRptCurrency ? "FYearPnLLocal" : (isRptCurrency ? "FYearPnLRpt" : "FYearPnLFor");
            StringBuffer sql = new StringBuffer();
            sql.append(" select FCompanyID, sum(FAmount) FAmount from ( ");
            sql.append(sbSql);
            sql.append(" union all ");
            sql.append("select balance.FOrgUnitId FCompanyID, sum((-1) * account.FDC * ").append(amountField).append(") FAmount ");
            sql.append(" from T_GL_InitAccountBalance balance join T_BD_AccountView account ");
            sql.append(" on balance.FAccountID = account.FID ");
            sbSql.append(" inner join t_org_company cop on cop.fid = balance.FOrgUnitId ");
            sbSql.append(" inner join t_org_company cp on charindex(cp.flongnumber||'!', cop.flongnumber) = 1 or cop.fid = cp.fid");
            sql.append(" where account.FIsLeaf = 1 and account.FPLType > 0 ");
            if (cashFlowFilterPara.getUseCompany() != null && !cashFlowFilterPara.getUseCompany().getCompanyId().equals(this.curCompany.getId().toString())) {
                String longNumber = cashFlowFilterPara.getUseCompany().getLongNumber() + "!%";
                sbSql.append(" and cp.flongnumber like '").append(longNumber).append("'");
            }
            if (cashFlowFilterPara.getUseCompany() != null) {
                if (!cashFlowFilterPara.isExpandAll()) {
                    sbSql.append(" and cp.flevel = " + (cashFlowFilterPara.getUseCompany().getLevel() + 1));
                }
            } else if (cashFlowFilterPara.getExpandCompanyLevel() > 1) {
                sbSql.append(" and cp.flevel >= " + this.curCompany.getLevel());
                sbSql.append(" and cp.flevel <= " + (this.curCompany.getLevel() + cashFlowFilterPara.getExpandCompanyLevel() - 1));
            } else {
                sbSql.append(" and cp.flevel = " + this.curCompany.getLevel());
            }
            sql.append(" and balance.FOrgUnitId in (");
            sql.append(cashFlowFilterPara.getCompanyIds() + ") ");
            sql.append(" and balance.FCurrencyID = '" + currencyId + "' ");
            if (diffAccountSet != null && diffAccountSet.length() > 0) {
                sbSql.append(" and account.FID not in (" + diffAccountSet + ") ");
            }
            sql.append(" group by balance.FOrgUnitId ");
            sql.append(" ) as A ");
            sql.append(" group by FCompanyID ");
            sbSql = sql;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
        try {
            BigDecimal fAmount = null;
            while (rs.next()) {
                String companyId = rs.getString("FCompanyID");
                fAmount = rs.getBigDecimal("FAmount");
                bdReturn.put(companyId, fAmount);
            }
        }
        catch (SQLException e) {
            throw new BOSException(this.getResource(ctx, "get_year_profit_failure"));
        }
        return bdReturn;
    }

    protected void _releaseTempTable(Context ctx, String tableName) throws BOSException {
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getBlankString(int level) {
        StringBuffer sbBlank = new StringBuffer();
        for (int i = 1; i < level; ++i) {
            sbBlank.append("    ");
        }
        return sbBlank.toString();
    }

    private PeriodInfo getPeriodByYearAndNumber(Context ctx, CashFlowFilterPara cashFlowFilterPara, int PeriodYear, int PeriodNumber) throws BOSException, EASBizException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(PeriodYear)));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(PeriodNumber)));
        fic.add(new FilterItemInfo("periodType.id", (Object)cashFlowFilterPara.getPeriodType().getId().toString()));
        view.setFilter(filter);
        PeriodCollection periodCollection = iPeriod.getPeriodCollection(view);
        PeriodInfo periodInfo = periodCollection == null || periodCollection.size() == 0 ? null : periodCollection.get(0);
        return periodInfo;
    }

    private String getSumString(Context ctx, String sumName) {
        StringBuffer sbReturn = new StringBuffer(this.getResource(ctx, "strSum"));
        int pos = sbReturn.indexOf("@");
        if (null != sumName) {
            sbReturn.replace(pos, pos + 1, sumName);
        }
        return sbReturn.toString();
    }

    private String getGeneralLocalCurrency() {
        return CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
    }

    private String getGeneralReportCurrency() {
        return CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    private PeriodInfo getPeriodByDate(Context ctx, Date tsDate) throws BOSException, EASBizException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("beginDate", (Object)tsDate, CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("endDate", (Object)tsDate, CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("periodType.id", (Object)this.curCompany.getAccountPeriodType().getId().toString()));
        view.setFilter(filter);
        PeriodCollection periodCollection = iPeriod.getPeriodCollection(view);
        PeriodInfo periodInfo = periodCollection == null || periodCollection.size() == 0 ? null : periodCollection.get(0);
        return periodInfo;
    }

    private Map getCashBalance(Context ctx, CashFlowFilterPara cashFlowFilterPara) throws BOSException, EASBizException {
        if (cashFlowFilterPara.isTermOrDate()) {
            PeriodInfo periodBegin = this.getPeriodByYearAndNumber(ctx, cashFlowFilterPara, cashFlowFilterPara.getYearFrom(), cashFlowFilterPara.getMonthFrom());
            PeriodInfo periodEnd = this.getPeriodByYearAndNumber(ctx, cashFlowFilterPara, cashFlowFilterPara.getYearTo(), cashFlowFilterPara.getMonthTo());
            if (periodBegin == null || periodEnd == null) {
                throw new CashFlowException(CashFlowException.CANT_FIND_PERIOD_BY_PERIODTYPE);
            }
            try {
                Map result = this.getAmountBalanceByPeriod(ctx, cashFlowFilterPara, periodBegin, periodEnd);
                return result;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        PeriodInfo periodBegin = this.getPeriodByDate(ctx, new Date(cashFlowFilterPara.getDateFrom().getTime()));
        if (periodBegin == null) {
            throw new CashFlowException(CashFlowException.START_DATE_BEYOND);
        }
        try {
            Map result = this.getAmountBalanceByDate(ctx, cashFlowFilterPara, periodBegin);
            return result;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Map getSumCashBalance(Context ctx, CashFlowFilterPara cashFlowFilterPara, int startPeriod) throws BOSException, EASBizException {
        Map result = new LinkedHashMap();
        PeriodInfo periodBegin = null;
        PeriodInfo periodEnd = null;
        if (cashFlowFilterPara.isTermOrDate()) {
            int yearFrom = startPeriod / 100;
            short yearTo = cashFlowFilterPara.getYearTo();
            int monthFrom = startPeriod % 100;
            short monthTo = cashFlowFilterPara.getMonthTo();
            periodBegin = this.getPeriodByYearAndNumber(ctx, cashFlowFilterPara, yearFrom, monthFrom);
            periodEnd = this.getPeriodByYearAndNumber(ctx, cashFlowFilterPara, yearTo, monthTo);
            if (periodBegin == null || periodEnd == null) {
                throw new CashFlowException(CashFlowException.CANT_FIND_PERIOD_BY_PERIODTYPE);
            }
            try {
                result = this.getAmountBalanceByPeriod(ctx, cashFlowFilterPara, periodBegin, periodEnd);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getAmountBalanceByPeriod(Context ctx, CashFlowFilterPara cashFlowFilterPara, PeriodInfo periodBegin, PeriodInfo periodEnd) throws EASBizException, BOSException, SQLException {
        try {
            int baltype = cashFlowFilterPara.isAllVoucher() ? 1 : 5;
            String currencyId = cashFlowFilterPara.getCurrencyId();
            boolean isForCurrency = false;
            String fieldSuffix = null;
            if (!this.getGeneralLocalCurrency().equals(currencyId)) {
                fieldSuffix = "for";
                isForCurrency = true;
            } else {
                fieldSuffix = "local";
            }
            if (this.getGeneralReportCurrency().equals(currencyId)) {
                isForCurrency = false;
                fieldSuffix = "rpt";
            }
            StringBuffer t_balance = new StringBuffer();
            GLRptAccountBalanceCondition cond = new GLRptAccountBalanceCondition();
            cond.setCtx(ctx);
            cond.setCompanyDisplayMode(CompanyDisplayModeEnum.merger);
            String[] strs = cashFlowFilterPara.getCompanyIds().split(",");
            ArrayList<CompanyOrgUnitInfo> companys = new ArrayList<CompanyOrgUnitInfo>();
            for (String str : strs) {
                if ((str = str.trim()).length() <= 2 || !str.startsWith("'") || !str.endsWith("'")) continue;
                str = str.substring(1, str.length() - 1);
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)str));
                companys.add(company);
            }
            cond.setCompanys(companys.toArray(new CompanyOrgUnitInfo[companys.size()]));
            cond.setPeriodYearStart(periodBegin.getPeriodYear());
            cond.setPeriodNumberStart(periodBegin.getPeriodNumber());
            cond.setPeriodYearEnd(periodEnd.getPeriodYear());
            cond.setPeriodNumberEnd(periodEnd.getPeriodNumber());
            cond.setShowQty(false);
            cond.setCurrencyID(currencyId);
            if (cond.getCurrPeriod() == null) {
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                return linkedHashMap;
            }
            GLRptAccountBalQueryHelper gLRptAccountBalQueryHelper = new GLRptAccountBalQueryHelper(cond);
            t_balance.append(" ( \n");
            t_balance.append(" select b.forgunitid, b.FPeriod tpfnumber, b.FAccountID, \n");
            if (isForCurrency) {
                t_balance.append(" b.FCurrencyID \n");
            } else {
                t_balance.append(" '" + currencyId + "' FCurrencyID \n");
            }
            String selectSQL = gLRptAccountBalQueryHelper.getAmountSelectSQL();
            t_balance.append(selectSQL);
            t_balance.append(" from " + GLBalanceUtils.getAccountBalanceTable(baltype, currencyId) + " b \n");
            GLTempTableUtil.setTransactionRequired(false);
            String sysStatusTmpTable = GLRptDaoUtil.createSysStatusTmpTable(ctx, cond);
            t_balance.append(" join " + sysStatusTmpTable + " ssc on ssc.fcompanyid = b.forgunitid \n");
            t_balance.append(" join T_BD_ACCOUNTVIEW account on account.fid = b.FACCOUNTID \r\n");
            t_balance.append(" where b.FOrgUnitId in (").append(cashFlowFilterPara.getCompanyIds()).append(") \n");
            t_balance.append(" and b.FPeriod in " + SQLUtil.buildPeriodNumbersInSql(periodBegin.getPeriodYear(), periodBegin.getPeriodNumber(), periodEnd.getPeriodYear(), periodEnd.getPeriodNumber()) + " \n");
            t_balance.append(" and (account.FIsCash = 1 or account.FIsBank = 1 or account.FIsCashEquivalent = 1) \n");
            if (cashFlowFilterPara.getAccountTabel() != null) {
                t_balance.append(" and account.faccounttableid = '" + cashFlowFilterPara.getAccountTabel().getId().toString() + "' \n");
            }
            if (isForCurrency) {
                t_balance.append(" and b.FCurrencyID = '" + currencyId + "' \n");
            }
            t_balance.append(" ");
            t_balance.append(" group by b.forgunitid, b.FPeriod, b.FAccountID \n");
            if (isForCurrency) {
                t_balance.append(" ,b.FCurrencyID \n");
            }
            t_balance.append(" ) ");
            StringBuffer sql = new StringBuffer();
            sql.append("select t1.fcompany,t1.flongnumber,t2.fcashbeginbalance,t2.fcasheqbeginbalance,t2.fcashamount,t2.fcasheqamount from \r\n");
            sql.append("( \r\n");
            sql.append(" select cp.fid FCompany,cp.flongnumber from t_org_company cop \r\n");
            sql.append(" inner join t_org_company cp on charindex(cp.flongnumber||'!', cop.flongnumber) = 1 or cop.fid = cp.fid \r\n");
            sql.append(" where cop.fid in (").append(cashFlowFilterPara.getCompanyIds()).append(")");
            String longNumber = this.curCompany.getLongNumber();
            if (cashFlowFilterPara.getUseCompany() != null) {
                longNumber = cashFlowFilterPara.getUseCompany().getLongNumber() + "!";
            }
            sql.append(" and cp.flongnumber like '").append(longNumber).append("%'");
            if (cashFlowFilterPara.getUseCompany() == null) {
                if (cashFlowFilterPara.getExpandCompanyLevel() > 1) {
                    sql.append(" and cp.flevel >= ").append(this.curCompany.getLevel());
                    sql.append(" and cp.flevel <= ").append(this.curCompany.getLevel() + cashFlowFilterPara.getExpandCompanyLevel() - 1);
                } else {
                    sql.append(" and cp.flevel = ");
                    sql.append(this.curCompany.getLevel());
                }
            } else if (!cashFlowFilterPara.isExpandAll()) {
                sql.append(" and cp.flevel = ");
                sql.append(cashFlowFilterPara.getUseCompany().getLevel() + 1);
            }
            sql.append(" group by cp.fid,cp.flongnumber \r\n");
            sql.append(") t1 \r\n");
            sql.append("left join \r\n");
            sql.append("( \r\n");
            sql.append("SELECT cp.fid FCompany, \r\n");
            sql.append("SUM(case when (account.FIsCash = 1 OR account.FIsBank = 1) then FBeginBalance").append(fieldSuffix).append(" else 0 end) fcashbeginbalance, \r\n");
            sql.append("SUM(case when (account.FIsCashEquivalent = 1) then FBeginBalance").append(fieldSuffix).append(" else 0 end) fcasheqbeginbalance, \r\n");
            sql.append("SUM(case when (account.FIsCash = 1 OR account.FIsBank = 1) then (FDebit").append(fieldSuffix).append("-FCredit").append(fieldSuffix).append(") else 0 end) fcashamount, \r\n");
            sql.append("SUM(case when (account.FIsCashEquivalent = 1) then (FDebit").append(fieldSuffix).append("-FCredit").append(fieldSuffix).append(") else 0 end) fcasheqamount \r\n");
            sql.append("from " + t_balance + " balance \r\n");
            sql.append("inner join T_BD_AccountView account on balance.FAccountID = account.FID \r\n");
            sql.append(" inner join t_org_company cop on cop.fid = balance.FOrgUnitId");
            sql.append(" inner join t_org_company cp on charindex(cp.flongnumber||'!', cop.flongnumber) = 1 or cop.fid = cp.fid");
            sql.append(" where account.FIsLeaf = 1 \r\n");
            sql.append(" and balance.FOrgUnitId in (").append(cashFlowFilterPara.getCompanyIds()).append(") \r\n");
            sql.append(" and cp.flongnumber like '").append(longNumber).append("%'");
            if (cashFlowFilterPara.getUseCompany() == null) {
                if (cashFlowFilterPara.getExpandCompanyLevel() > 1) {
                    sql.append(" and cp.flevel >= ").append(this.curCompany.getLevel());
                    sql.append(" and cp.flevel <= ").append(this.curCompany.getLevel() + cashFlowFilterPara.getExpandCompanyLevel() - 1);
                } else {
                    sql.append(" and cp.flevel = ");
                    sql.append(this.curCompany.getLevel());
                }
            } else if (!cashFlowFilterPara.isExpandAll()) {
                sql.append(" and cp.flevel = ");
                sql.append(cashFlowFilterPara.getUseCompany().getLevel() + 1);
            }
            sql.append(" and balance.tpfnumber >= " + periodBegin.getNumber());
            sql.append(" and balance.tpfnumber <= " + periodEnd.getNumber() + " \r\n");
            sql.append(" and balance.FCurrencyID = '");
            sql.append(cashFlowFilterPara.getCurrencyId() + "' \r\n");
            sql.append(" and (account.FIsCash = 1 or account.FIsBank = 1 or account.FIsCashEquivalent = 1) \r\n");
            if (cashFlowFilterPara.getAccountTabel() != null) {
                sql.append(" and account.faccounttableid = '");
                sql.append(cashFlowFilterPara.getAccountTabel().getId().toString() + "' \r\n");
            }
            sql.append(" group by cp.fid \r\n");
            sql.append(") t2 on t2.fcompany=t1.fcompany \r\n");
            sql.append(" order by flongnumber");
            LinkedHashMap<String, Object[]> result = new LinkedHashMap<String, Object[]>();
            Object[] obj = null;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String companyID = null;
            while (rs.next()) {
                companyID = rs.getString("fcompany");
                obj = new Object[]{rs.getBigDecimal("fcashbeginbalance") == null ? GlUtils.zero : rs.getBigDecimal("fcashbeginbalance"), rs.getBigDecimal("fcasheqbeginbalance") == null ? GlUtils.zero : rs.getBigDecimal("fcasheqbeginbalance"), rs.getBigDecimal("fcashamount") == null ? GlUtils.zero : rs.getBigDecimal("fcashamount"), rs.getBigDecimal("fcasheqamount") == null ? GlUtils.zero : rs.getBigDecimal("fcasheqamount"), companyID};
                result.put(companyID, obj);
            }
            LinkedHashMap<String, Object[]> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            GLTempTableUtil.dropDBSysTempTable(ctx);
        }
    }

    private Map getAmountBalanceByDate(Context ctx, CashFlowFilterPara cashFlowFilterPara, PeriodInfo periodBegin) throws EASBizException, BOSException, SQLException {
        ArrayList<Object> params = new ArrayList<Object>();
        String fieldSuffix = null;
        String currencyId = cashFlowFilterPara.getCurrencyId();
        fieldSuffix = !currencyId.equals(this.getGeneralLocalCurrency()) ? "for" : "local";
        if (currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
            fieldSuffix = "rpt";
        }
        GregorianCalendar gcStart = new GregorianCalendar();
        gcStart.setTime(cashFlowFilterPara.getDateFrom());
        gcStart.add(5, -1);
        Date startDate = new Date(gcStart.getTime().getTime());
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.fcompany,t1.flongnumber,t2.fcashbeginbalance,t2.fcasheqbeginbalance, \r\n");
        sql.append("t3.fcashamount1,t3.fcasheqamount1,t3.fcashamount2,t3.fcasheqamount2 from \r\n");
        sql.append("( \r\n");
        sql.append(" select cp.fid FCompany,cp.flongnumber from t_org_company cop \r\n");
        sql.append(" inner join t_org_company cp on charindex(cp.flongnumber||'!', cop.flongnumber) = 1 or cop.fid = cp.fid \r\n");
        sql.append(" where cop.fid in (").append(cashFlowFilterPara.getCompanyIds()).append(")");
        String longNumber = this.curCompany.getLongNumber();
        if (cashFlowFilterPara.getUseCompany() != null) {
            longNumber = cashFlowFilterPara.getUseCompany().getLongNumber() + "!";
        }
        sql.append(" and cp.flongnumber like '").append(longNumber).append("%'");
        if (cashFlowFilterPara.getUseCompany() == null) {
            if (cashFlowFilterPara.getExpandCompanyLevel() > 1) {
                sql.append(" and cp.flevel >= ").append(this.curCompany.getLevel());
                sql.append(" and cp.flevel <= ").append(this.curCompany.getLevel() + cashFlowFilterPara.getExpandCompanyLevel() - 1);
            } else {
                sql.append(" and cp.flevel = ");
                sql.append(this.curCompany.getLevel());
            }
        } else if (!cashFlowFilterPara.isExpandAll()) {
            sql.append(" and cp.flevel = ");
            sql.append(cashFlowFilterPara.getUseCompany().getLevel() + 1);
        }
        sql.append(" group by cp.fid,cp.flongnumber \r\n");
        sql.append(") t1 \r\n");
        sql.append("left join \r\n");
        sql.append("( \r\n");
        sql.append("select cp.fid FCompany, \r\n");
        sql.append("SUM(CASE account.FDC WHEN 1 THEN 1ELSE -1 END *  \r\n");
        sql.append("case when (account.FIsCash = 1 OR account.FIsBank = 1) then FBeginBalance").append(fieldSuffix).append(" else 0 end) fcashbeginbalance, \r\n");
        sql.append("SUM(CASE account.FDC WHEN 1 THEN 1 ELSE -1 END *  \r\n");
        sql.append("case when (account.FIsCashEquivalent = 1) then FBeginBalance").append(fieldSuffix).append(" else 0 end) fcasheqbeginbalance \r\n");
        sql.append("from T_GL_AccountBalance balance \r\n");
        sql.append("inner join T_BD_AccountView account on balance.FAccountID = account.FID \r\n");
        sql.append(" inner join t_org_company cop on cop.fid = balance.FOrgUnitId");
        sql.append(" inner join t_org_company cp on charindex(cp.flongnumber||'!', cop.flongnumber) = 1 or cop.fid = cp.fid");
        sql.append(" where account.FIsLeaf = 1 \r\n");
        sql.append(" and balance.FOrgUnitId in (").append(cashFlowFilterPara.getCompanyIds()).append(") \r\n");
        sql.append(" and cp.flongnumber like '").append(longNumber).append("%'");
        if (cashFlowFilterPara.getUseCompany() == null) {
            if (cashFlowFilterPara.getExpandCompanyLevel() > 1) {
                sql.append(" and cp.flevel >= ").append(this.curCompany.getLevel());
                sql.append(" and cp.flevel <= ").append(this.curCompany.getLevel() + cashFlowFilterPara.getExpandCompanyLevel() - 1);
            } else {
                sql.append(" and cp.flevel = ");
                sql.append(this.curCompany.getLevel());
            }
        } else if (!cashFlowFilterPara.isExpandAll()) {
            sql.append(" and cp.flevel = ");
            sql.append(cashFlowFilterPara.getUseCompany().getLevel() + 1);
        }
        sql.append(" and balance.fperiod = ? \r\n");
        params.add(new Integer(periodBegin.getNumber()));
        sql.append(" and balance.FCurrencyID = ? \r\n");
        params.add(currencyId);
        sql.append(" and (account.FIsCash = 1 or account.FIsBank = 1 or account.FIsCashEquivalent = 1) \r\n");
        if (cashFlowFilterPara.getAccountTabel() != null) {
            sql.append(" and account.faccounttableid = ? \r\n");
            params.add(cashFlowFilterPara.getAccountTabel().getId().toString());
        }
        sql.append(" and balance.FBalType = ? \r\n");
        params.add(cashFlowFilterPara.isAllVoucher() ? new Integer(1) : new Integer(5));
        sql.append(" group by cp.fid \r\n");
        sql.append(") t2 on t2.fcompany=t1.fcompany \r\n");
        sql.append(" left join \r\n");
        sql.append("( \r\n");
        sql.append("select cp.fid FCompany,");
        if (currencyId.equals(this.getGeneralLocalCurrency())) {
            sql.append("sum(case when voucher.fbookeddate <= ? and (account.FIsCash = 1 or account.FIsBank = 1) then FLocalAmount else 0 end * case ve.FEntryDC when 1 then 1 else -1 end) fcashamount1,");
            sql.append("sum(case when voucher.fbookeddate <= ? and account.FIsCashEquivalent=1 then FLocalAmount else 0 end * case ve.FEntryDC when 1 then 1 else -1 end) fcasheqamount1,");
            params.add(startDate);
            params.add(startDate);
            sql.append("sum(case when voucher.fbookeddate > ? and (account.FIsCash = 1 or account.FIsBank = 1) then FLocalAmount else 0 end * case ve.FEntryDC when 1 then 1 else -1 end) fcashamount2,");
            sql.append("sum(case when voucher.fbookeddate > ? and account.FIsCashEquivalent=1 then FLocalAmount else 0 end * case ve.FEntryDC when 1 then 1 else -1 end) fcasheqamount2");
            params.add(startDate);
            params.add(startDate);
        } else {
            sql.append("sum(case when voucher.fbookeddate <= ? and (account.FIsCash = 1 or account.FIsBank = 1) then FOriginalAmount else 0 end * case ve.FEntryDC when 1 then 1 else -1 end) fcashamount1,");
            sql.append("sum(case when voucher.fbookeddate <= ? and account.FIsCashEquivalent=1 then FOriginalAmount else 0 end * case ve.FEntryDC when 1 then 1 else -1 end) fcasheqamount1,");
            params.add(startDate);
            params.add(startDate);
            sql.append("sum(case when voucher.fbookeddate > ? and (account.FIsCash = 1 or account.FIsBank = 1) then FOriginalAmount else 0 end * case ve.FEntryDC when 1 then 1 else -1 end) fcashamount2,");
            sql.append("sum(case when voucher.fbookeddate > ? and account.FIsCashEquivalent=1 then FOriginalAmount else 0 end * case ve.FEntryDC when 1 then 1 else -1 end) fcasheqamount2");
            params.add(startDate);
            params.add(startDate);
        }
        sql.append(" from T_GL_Voucher voucher \r\n");
        sql.append(" inner join T_GL_VoucherEntry ve on voucher.FID = ve.FBillID \r\n");
        sql.append(" inner join T_BD_AccountView account on ve.FAccountID = account.FID \r\n");
        sql.append(" inner join t_org_company cop on cop.fid = voucher.FCompanyID \r\n");
        sql.append(" inner join t_org_company cp on charindex(cp.flongnumber||'!', cop.flongnumber) = 1 or cop.fid = cp.fid \r\n");
        sql.append(" where voucher.FBookedDate >= ? \r\n");
        sql.append(" and voucher.FBookedDate <= ? \r\n");
        params.add(periodBegin.getBeginDate());
        params.add(cashFlowFilterPara.getDateTo());
        if (!currencyId.equals(this.getGeneralLocalCurrency())) {
            sql.append(" and ve.FCurrencyID = ? \r\n");
            params.add(currencyId);
        }
        sql.append(" and voucher.FCompanyID in (").append(cashFlowFilterPara.getCompanyIds()).append(") \r\n");
        if (cashFlowFilterPara.getUseCompany() != null) {
            longNumber = cashFlowFilterPara.getUseCompany().getLongNumber() + "!";
        }
        sql.append(" and cp.flongnumber like '").append(longNumber).append("%'");
        if (cashFlowFilterPara.getUseCompany() == null) {
            if (cashFlowFilterPara.getExpandCompanyLevel() > 1) {
                sql.append(" and cp.flevel >= ").append(this.curCompany.getLevel());
                sql.append(" and cp.flevel <= ").append(this.curCompany.getLevel() + cashFlowFilterPara.getExpandCompanyLevel() - 1);
            } else {
                sql.append(" and cp.flevel = ");
                sql.append(this.curCompany.getLevel());
            }
        } else if (!cashFlowFilterPara.isExpandAll()) {
            sql.append(" and cp.flevel = ");
            sql.append(cashFlowFilterPara.getUseCompany().getLevel() + 1);
        }
        sql.append(" and (account.FIsCash = 1 or account.FIsBank = 1 or account.FIsCashEquivalent = 1) \r\n");
        if (cashFlowFilterPara.getAccountTabel() != null) {
            sql.append(" and account.faccounttableid = ? \r\n");
            params.add(cashFlowFilterPara.getAccountTabel().getId().toString());
        }
        sql.append(" and voucher.FBizStatus in(");
        sql.append(5);
        if (cashFlowFilterPara.isAllVoucher()) {
            sql.append(",");
            sql.append(3);
            sql.append(",");
            sql.append(1);
        }
        sql.append(") group by cp.fid \r\n");
        sql.append(") t3 on t3.fcompany=t1.fcompany");
        sql.append(" order by flongnumber");
        LinkedHashMap<String, Object[]> result = new LinkedHashMap<String, Object[]>();
        Object[] obj = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        String companyID = null;
        BigDecimal cashBegin = null;
        BigDecimal cashEqBegin = null;
        while (rs.next()) {
            companyID = rs.getString("fcompany");
            cashBegin = rs.getBigDecimal("fcashbeginbalance") == null ? GlUtils.zero : rs.getBigDecimal("fcashbeginbalance");
            cashBegin = GlUtils.add(cashBegin, rs.getBigDecimal("fcashamount1"));
            cashEqBegin = rs.getBigDecimal("fcasheqbeginbalance") == null ? GlUtils.zero : rs.getBigDecimal("fcasheqbeginbalance");
            cashEqBegin = GlUtils.add(cashEqBegin, rs.getBigDecimal("fcasheqamount1"));
            obj = new Object[]{cashBegin, cashEqBegin, rs.getBigDecimal("fcashamount2") == null ? GlUtils.zero : rs.getBigDecimal("fcashamount2"), rs.getBigDecimal("fcasheqamount2") == null ? GlUtils.zero : rs.getBigDecimal("fcasheqamount2"), companyID};
            result.put(companyID, obj);
        }
        return result;
    }

    private void updateCompanyWithAsstItem(Context ctx, CashFlowFilterPara cashFlowFilterPara) throws BOSException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select distinct FcompanyId from " + cashFlowFilterPara.getAsstItemTempTable());
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            ArrayList<String> companyIds = new ArrayList<String>();
            if (rs.size() != 0) {
                int i;
                while (rs.next()) {
                    companyIds.add(rs.getString("FcompanyId"));
                }
                sqlBuffer = new StringBuffer();
                sqlBuffer.append("select distinct flongnumber from " + cashFlowFilterPara.getAsstItemTempTable());
                rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
                ArrayList<String> flongNumbers = new ArrayList<String>();
                while (rs.next()) {
                    flongNumbers.add(rs.getString("flongnumber"));
                }
                sqlBuffer = new StringBuffer();
                sqlBuffer.append("update ").append(cashFlowFilterPara.getTempTableName()).append(" set fhasAsstItem = 1 where ").append(" FCompanyID in (");
                int size = companyIds.size();
                for (i = 0; i < size; ++i) {
                    sqlBuffer.append("'").append(companyIds.get(i)).append("',");
                }
                sqlBuffer = new StringBuffer(sqlBuffer.substring(0, sqlBuffer.length() - 1));
                sqlBuffer.append(") and flongnumber in (");
                size = flongNumbers.size();
                for (i = 0; i < size; ++i) {
                    sqlBuffer.append("'").append(flongNumbers.get(i)).append("',");
                }
                sqlBuffer = new StringBuffer(sqlBuffer.substring(0, sqlBuffer.length() - 1));
                sqlBuffer.append(") and famount is not null and fasstid is null ");
                DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
            }
        }
        catch (Exception e) {
            this._releaseTempTable(ctx, cashFlowFilterPara.getAsstItemTempTable());
            this._releaseTempTable(ctx, cashFlowFilterPara.getTempTableName());
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMaxCompanyLevel(Context ctx, String companyIds) {
        int maxLevel = -1;
        Connection conn = null;
        try {
            String sql = "select max(flevel) companyLevel from t_org_company where fid in (" + companyIds + ") ";
            conn = this.getConnection(ctx);
            RptRowSet rrs = DBUtil.executeQuery((String)sql.toString(), (Connection)conn);
            if (rrs.next()) {
                maxLevel = rrs.getInt("companyLevel");
            }
            SQLUtils.cleanup((Connection)conn);
        }
        catch (Exception e) {
            log.error((Object)"Error in querying company level");
        }
        finally {
            SQLUtils.cleanup(conn);
        }
        return maxLevel;
    }

    class MapParam {
        String FLongNumber;
        String FAsstID;
        String FName;
        BigDecimal FAmount;
        CashflowTypeEnum FCashType;
        Integer FIsEnable;
        String FCompanyID;
        Integer FCompanyLevel;

        MapParam() {
        }
    }

    class DBParam {
        String FLongNumber;
        String FName;
        Integer FLevel;
        Integer FDirection;
        BigDecimal FAmount;
        Integer FIsLeaf;
        Boolean FIsProfit;
        CashFlowItemInfo itemInfo;
        Boolean FIsExchange;
        CashflowTypeEnum FCashType;
        String FLongNameGroup;
        String FCompanyID;
        String FAsstID;
        Boolean FIsEnable;
        BigDecimal FSum;

        DBParam() {
        }

        void copy(DBParam p) {
            this.FLongNumber = p.FLongNumber;
            this.FName = p.FName;
            this.FLevel = p.FLevel;
            this.FDirection = p.FDirection;
            this.FAmount = p.FAmount;
            this.FIsLeaf = p.FIsLeaf;
            this.FIsProfit = p.FIsProfit;
            this.itemInfo = p.itemInfo;
            this.FIsExchange = p.FIsExchange;
            this.FCashType = p.FCashType;
            this.FLongNameGroup = p.FLongNameGroup;
            this.FSum = p.FSum;
            this.FAsstID = p.FAsstID;
            this.FIsEnable = p.FIsEnable;
        }
    }
}

