/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffCollection;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffFactory;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.ICashFlowAccountDiff;
import com.kingdee.eas.basedata.master.account.AccountPLType;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashEntryInfo;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICashflowRecord;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CashFlowUtils {
    public static final int ASSIGNED_FINISHED = 1;
    public static final int ASSIGNED_UNFINISHED = 2;

    public static Map getVoucherOrder(Context ctx, VoucherInfo voucher, Map difference) throws BOSException {
        VoucherEntryCollection entries = new VoucherEntryCollection();
        int size = voucher.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entries.add(voucher.getEntries().get(i));
        }
        HashMap<String, VoucherEntryCollection> map = new HashMap<String, VoucherEntryCollection>();
        map.put("col", entries);
        return map;
    }

    public static Map getVoucherByNear(Context ctx, VoucherInfo voucher) throws BOSException {
        VoucherEntryCollection enColcl = voucher.getEntries();
        ArrayList<CashEntryInfo> enCol = new ArrayList<CashEntryInfo>();
        int d = 0;
        int c = 0;
        int a = 0;
        int b = 0;
        int enCount = enColcl.size();
        for (int j = 0; j < enCount; ++j) {
            VoucherEntryInfo entryInfo = (VoucherEntryInfo)enColcl.getObject(j);
            VoucherAssistRecordCollection assistCol = entryInfo.getAssistRecords();
            CashEntryInfo cashEntry = new CashEntryInfo(entryInfo);
            if (entryInfo.getAccount().getCAA() != null && !CashFlowUtils.isCashAccount(entryInfo.getAccount()) && assistCol != null && assistCol.size() != 0) {
                ArrayList<CashEntryInfo> cashEntryCol = new ArrayList<CashEntryInfo>();
                for (int i = 0; i < assistCol.size(); ++i) {
                    VoucherAssistRecordInfo asst = assistCol.get(i);
                    CashEntryInfo assistCashEntry = new CashEntryInfo(entryInfo, asst);
                    cashEntryCol.add(assistCashEntry);
                }
                cashEntry.setAssistCol(cashEntryCol);
            }
            enCol.add(cashEntry);
            if (entryInfo.getEntryDC() == EntryDC.DEBIT) {
                ++d;
                if (!CashFlowUtils.isCashAccount(entryInfo.getAccount())) continue;
                ++a;
                continue;
            }
            ++c;
            if (!CashFlowUtils.isCashAccount(entryInfo.getAccount())) continue;
            ++b;
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("col", enCol);
        map.put("isOneDebit", Boolean.valueOf(d == 1 && a == 1 && b == 0));
        map.put("isOneCredit", Boolean.valueOf(c == 1 && b == 1 && a == 0));
        return map;
    }

    public static boolean isCashAccount(AccountViewInfo acct) {
        return acct.isIsCash() || acct.isIsBank() || acct.isIsCashEquivalent();
    }

    public static boolean isPL(AccountViewInfo account) {
        return account.getPLType() != AccountPLType.NONE;
    }

    public static Map getDifferenceMap(Context ctx, String companyId) throws BOSException {
        Map diff = null;
        try {
            diff = VoucherProcessCache.getDifference(ctx, companyId);
        }
        catch (EASBizException e) {
            throw new BOSException("Get CashFlowAccountDiff error!", (Throwable)e);
        }
        HashMap<String, String> difference = new HashMap<String, String>();
        if (diff != null) {
            CashFlowAccountDiffCollection col_diff = (CashFlowAccountDiffCollection)diff.get("CashFlowAccountDiffCollection");
            int size = col_diff.size();
            for (int i = 0; i < size; ++i) {
                difference.put(col_diff.get(i).getDiffAccount().getId().toString(), "");
            }
        }
        return difference;
    }

    public static void cashCounteract(Context ctx, CompanyOrgUnitInfo company, CashEntryInfo cashentry, CashEntryInfo opposingAccountEntry, BigDecimal[] amount, int coef, boolean hasCashAccount) throws EASBizException, BOSException {
        CashflowRecordInfo record = new CashflowRecordInfo();
        ICashflowRecord cfr = CashflowRecordFactory.getLocalInstance(ctx);
        record.setOriginalAmount(amount[0]);
        if (company.getBaseCurrency() != null) {
            amount[1] = amount[1].setScale(company.getBaseCurrency().getPrecision(), 4);
        }
        if (company.getReportCurrency() != null) {
            amount[2] = amount[2].setScale(company.getReportCurrency().getPrecision(), 4);
        }
        record.setLocalAmount(amount[1]);
        record.setReportingAmount(amount[2]);
        if (CashFlowUtils.isCashAccount(cashentry.getAccount())) {
            record.setPrimaryCoefficient(coef);
        } else {
            record.setSupplementaryCoefficient(coef);
            if (hasCashAccount) {
                record.setIsSupItem(true);
            }
        }
        VoucherInfo voucher = new VoucherInfo();
        voucher.setId(cashentry.getBill().getId());
        record.setVoucher(voucher);
        VoucherEntryInfo entry = new VoucherEntryInfo();
        entry.setId(cashentry.getVoucherEntry().getId());
        record.setEntry(entry);
        entry = new VoucherEntryInfo();
        entry.setId(opposingAccountEntry.getVoucherEntry().getId());
        record.setOpposingAccountEntry(entry);
        record.setItemFlag(ItemFlag.DISPOSE);
        cfr.addnew((CoreBaseInfo)record);
    }

    protected static Map getDifference(Context ctx, String companyId) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("CU.id"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
        HashMap<String, CashFlowAccountDiffCollection> difference = new HashMap<String, CashFlowAccountDiffCollection>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)CashflowRecordInfo.getAccountSelector());
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("diffAccount.number"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("CU.id", (Object)company.getCU().getId().toString()));
        ICashFlowAccountDiff activity = CashFlowAccountDiffFactory.getLocalInstance((Context)ctx);
        CashFlowAccountDiffCollection col = activity.getCashFlowAccountDiffCollection(view);
        if (col != null) {
            difference.put("CashFlowAccountDiffCollection", col);
        }
        return difference;
    }

    public static void sortByAmount(List enCol) {
        Collections.sort(enCol, new Comparator(){

            public int compare(Object o1, Object o2) {
                CashEntryInfo entry = (CashEntryInfo)o1;
                CashEntryInfo entry1 = (CashEntryInfo)o2;
                return entry1.getLocalAmount().abs().compareTo(entry.getLocalAmount().abs());
            }
        });
    }

    public static String getPrimaryItemVocuherSql(String companyId, boolean includeNoPostedVoucher, boolean queryByPeriod, Integer startPeriod, Integer endPeriod, Date startDate, Date endDate, List params, int type) {
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.fid fid from \r\n");
        sql.append("( \r\n");
        sql.append("\t\tselect v.fid,sum(case when ve.fentrydc=0 then -1 else 1 end * ve.flocalamount) vamount \r\n");
        sql.append("\t\tfrom t_gl_voucher v \r\n");
        sql.append("\t\tinner join t_gl_voucherentry ve on ve.fbillid=v.fid \r\n");
        sql.append("\t\tinner join t_bd_accountview av on av.fid=ve.faccountid \r\n");
        sql.append("\t\tinner join t_bd_period p on v.fperiodid=p.fid \r\n");
        sql.append("\t\twhere v.fcompanyid=? \r\n");
        params.add(companyId);
        if (includeNoPostedVoucher) {
            sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
        } else {
            sql.append("\t\t      and v.fbizstatus =5 \r\n");
        }
        if (queryByPeriod) {
            sql.append("\t\t      and p.fnumber >= ? and p.fnumber <= ? \r\n");
            params.add(startPeriod);
            params.add(endPeriod);
        } else {
            sql.append("              and v.FBookedDate >= ? \r\n");
            sql.append("              and v.FBookedDate <= ? \r\n");
            params.add(startDate);
            params.add(endDate);
        }
        sql.append("\t\t      and (av.fisCash=1 or av.fisBank=1 or av.fisCashEquivalent=1) \r\n");
        sql.append("\t\tgroup by v.fid \r\n");
        sql.append(") t1 \r\n");
        sql.append("left join \r\n");
        sql.append("( \r\n");
        sql.append("\t\tselect v.fid,sum(case when cfi.fdirection=1 then 1 else -1 end * cf.flocalamount * cf.fprimarycoeffient) cfamount \r\n");
        sql.append("\t\tfrom t_gl_cashflowrecord cf \r\n");
        sql.append("\t\tinner join t_gl_voucher v on v.fid=cf.fvoucherid \r\n");
        sql.append("\t\tinner join t_bd_period p on p.fid=v.fperiodid \r\n");
        sql.append("\t\tinner join t_bd_cashflowitem cfi on cfi.fid=cf.fprimaryitemid \r\n");
        sql.append("\t\twhere v.fcompanyid=? \r\n");
        params.add(companyId);
        if (includeNoPostedVoucher) {
            sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
        } else {
            sql.append("\t\t      and v.fbizstatus =5 \r\n");
        }
        if (queryByPeriod) {
            sql.append("\t\t      and p.fnumber >= ? and p.fnumber <= ? \r\n");
            params.add(startPeriod);
            params.add(endPeriod);
        } else {
            sql.append("              and v.FBookedDate >= ? \r\n");
            sql.append("              and v.FBookedDate <= ? \r\n");
            params.add(startDate);
            params.add(endDate);
        }
        sql.append("\t\t      and (cf.fitemflag=1 or cf.fitemflag=3) \r\n");
        sql.append("\t\tgroup by v.fid \r\n");
        sql.append(") t2 on t1.fid=t2.fid \r\n");
        if (1 == type) {
            sql.append("where vamount = cfamount \r\n");
        } else {
            sql.append("where vamount <> isnull(cfamount,0) \r\n");
        }
        return sql.toString();
    }

    public static String getSupplementaryVoucher(String companyId, boolean includeNoPostedVoucher, boolean queryByPeriod, Integer startPeriod, Integer endPeriod, Date startDate, Date endDate, List params, int type) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.fid fid \r\n");
        sql.append("from ( \r\n");
        sql.append("\tselect v.fid,sum(case when actype.fproperty=4 and avdiff.fid is null then \r\n");
        sql.append("\tcase when ve.fentrydc=0 then 1 else -1 end \r\n");
        sql.append("\telse 0 end * isnull(ve.flocalamount,0)) netprofit \r\n");
        sql.append("\tfrom t_gl_voucher v \r\n");
        sql.append("\tinner join t_bd_period p on p.fid=v.fperiodid \r\n");
        sql.append("\tleft join t_gl_voucherentry ve on ve.fbillid=v.fid \r\n");
        sql.append("\tleft join t_bd_accountview av on av.fid=ve.faccountid \r\n");
        sql.append("\tleft join t_bd_accounttype actype on actype.fid = av.faccounttypeid \r\n");
        sql.append("\tleft join t_bd_cashflowaccountdiff avdiff on av.fid = avdiff.fdiffaccountid \r\n");
        sql.append("\twhere v.fcompanyid=? \r\n");
        params.add(companyId);
        if (includeNoPostedVoucher) {
            sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
        } else {
            sql.append("\t\t      and v.fbizstatus =5 \r\n");
        }
        if (queryByPeriod) {
            sql.append("\t\t      and p.fnumber >= ? and p.fnumber <= ? \r\n");
            params.add(startPeriod);
            params.add(endPeriod);
        } else {
            sql.append("              and v.FBookedDate >= ? \r\n");
            sql.append("              and v.FBookedDate <= ? \r\n");
            params.add(startDate);
            params.add(endDate);
        }
        sql.append("\t      and v.fsourceType <> 1 \r\n");
        sql.append("\tgroup by v.fid \r\n");
        sql.append(") t1 \r\n");
        sql.append("left join \r\n");
        sql.append("( \r\n");
        sql.append("\tselect v.fid,sum(cf.flocalamount * cf.fsupplementarycoeffient) supamount \r\n");
        sql.append("\tfrom t_gl_cashflowrecord cf \r\n");
        sql.append("\tinner join t_gl_voucher v on v.fid=cf.fvoucherid \r\n");
        sql.append("\tinner join t_bd_period p on p.fid=v.fperiodid \r\n");
        sql.append("\tinner join t_bd_cashflowitem cfi on cfi.fid=cf.fsupplementaryitemid \r\n");
        sql.append("where v.fcompanyid=? \r\n");
        params.add(companyId);
        if (includeNoPostedVoucher) {
            sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
        } else {
            sql.append("\t\t      and v.fbizstatus =5 \r\n");
        }
        if (queryByPeriod) {
            sql.append("\t\t      and p.fnumber >= ? and p.fnumber <= ? \r\n");
            params.add(startPeriod);
            params.add(endPeriod);
        } else {
            sql.append("              and v.FBookedDate >= ? \r\n");
            sql.append("              and v.FBookedDate <= ? \r\n");
            params.add(startDate);
            params.add(endDate);
        }
        sql.append("      and v.fsourceType <> 1 \r\n");
        sql.append("group by v.fid \r\n");
        sql.append(") t2 on t1.fid=t2.fid \r\n");
        sql.append("left join \r\n");
        sql.append("( \r\n");
        sql.append("\tselect v.fid,sum(case when cfi.fdirection=1 then 1 else -1 end * cf.flocalamount * cf.fprimarycoeffient) pamount \r\n");
        sql.append("\tfrom t_gl_cashflowrecord cf \r\n");
        sql.append("\tinner join t_gl_voucher v on v.fid=cf.fvoucherid \r\n");
        sql.append("\tinner join t_bd_period p on p.fid=v.fperiodid \r\n");
        sql.append("\tinner join t_bd_cashflowitem cfi on cfi.fid=cf.fprimaryitemid \r\n");
        sql.append("\tleft  join t_bd_cashflowkeepactivity kc on cfi.fid =kc.fconcashflowitemid \r\n");
        sql.append("where v.fcompanyid=? \r\n");
        params.add(companyId);
        if (includeNoPostedVoucher) {
            sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
        } else {
            sql.append("\t\t      and v.fbizstatus =5 \r\n");
        }
        if (queryByPeriod) {
            sql.append("\t\t      and p.fnumber >= ? and p.fnumber <= ? \r\n");
            params.add(startPeriod);
            params.add(endPeriod);
        } else {
            sql.append("              and v.FBookedDate >= ? \r\n");
            sql.append("              and v.FBookedDate <= ? \r\n");
            params.add(startDate);
            params.add(endDate);
        }
        sql.append("      and (cf.fitemflag=1 or cf.fitemflag=3) \r\n");
        sql.append("      and cfi.fisdealactivity =1 and kc.fid is null and v.fsourceType <> 1 \r\n");
        sql.append("group by v.fid \r\n");
        sql.append(") t3 on t1.fid=t3.fid \r\n");
        if (1 == type) {
            sql.append("where netprofit+isnull(supamount,0) = isnull(pamount,0) \r\n");
        } else {
            sql.append("where netprofit+isnull(supamount,0)<>isnull(pamount,0) \r\n");
        }
        return sql.toString();
    }

    public static String getSupplementaryVoucherExcludeAdjust(String companyId, boolean includeNoPostedVoucher, boolean queryByPeriod, Integer startPeriod, Integer endPeriod, Date startDate, Date endDate, List params, int type) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.fid fid \r\n");
        sql.append("from ( \r\n");
        sql.append("\tselect v.fid,sum(case when actype.fproperty=4 and avdiff.fid is null then \r\n");
        sql.append("\tcase when ve.fentrydc=0 then 1 else -1 end \r\n");
        sql.append("\telse 0 end * isnull(ve.flocalamount,0)) netprofit \r\n");
        sql.append("\tfrom t_gl_voucher v \r\n");
        sql.append("\tinner join t_bd_period p on p.fid=v.fperiodid \r\n");
        sql.append("\tleft join t_gl_voucherentry ve on ve.fbillid=v.fid \r\n");
        sql.append("\tleft join t_bd_accountview av on av.fid=ve.faccountid \r\n");
        sql.append("\tleft join t_bd_accounttype actype on actype.fid = av.faccounttypeid \r\n");
        sql.append("\tleft join t_bd_cashflowaccountdiff avdiff on av.fid = avdiff.fdiffaccountid \r\n");
        sql.append("\twhere v.fcompanyid=? \r\n");
        params.add(companyId);
        if (includeNoPostedVoucher) {
            sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
        } else {
            sql.append("\t\t      and v.fbizstatus =5 \r\n");
        }
        if (queryByPeriod) {
            sql.append("\t\t      and p.fnumber >= ? and p.fnumber <= ? \r\n");
            params.add(startPeriod);
            params.add(endPeriod);
        } else {
            sql.append("              and v.FBookedDate >= ? \r\n");
            sql.append("              and v.FBookedDate <= ? \r\n");
            params.add(startDate);
            params.add(endDate);
        }
        sql.append("\t      and v.fsourceType <> 1 \r\n");
        sql.append("\tgroup by v.fid \r\n");
        sql.append(") t1 \r\n");
        sql.append("left join \r\n");
        sql.append("( \r\n");
        sql.append("\tselect v.fid,sum(cf.flocalamount * cf.fsupplementarycoeffient) supamount \r\n");
        sql.append("\tfrom t_gl_cashflowrecord cf \r\n");
        sql.append("\tinner join t_gl_voucher v on v.fid=cf.fvoucherid \r\n");
        sql.append("\tinner join t_bd_period p on p.fid=v.fperiodid \r\n");
        sql.append("\tinner join t_bd_cashflowitem cfi on cfi.fid=cf.fsupplementaryitemid \r\n");
        sql.append("where v.fcompanyid=? and cf.fitemflag <> 7 \r\n");
        params.add(companyId);
        if (includeNoPostedVoucher) {
            sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
        } else {
            sql.append("\t\t      and v.fbizstatus =5 \r\n");
        }
        if (queryByPeriod) {
            sql.append("\t\t      and p.fnumber >= ? and p.fnumber <= ? \r\n");
            params.add(startPeriod);
            params.add(endPeriod);
        } else {
            sql.append("              and v.FBookedDate >= ? \r\n");
            sql.append("              and v.FBookedDate <= ? \r\n");
            params.add(startDate);
            params.add(endDate);
        }
        sql.append("      and v.fsourceType <> 1 \r\n");
        sql.append("group by v.fid \r\n");
        sql.append(") t2 on t1.fid=t2.fid \r\n");
        sql.append("left join \r\n");
        sql.append("( \r\n");
        sql.append("\tselect v.fid,sum(case when cfi.fdirection=1 then 1 else -1 end * cf.flocalamount * cf.fprimarycoeffient) pamount \r\n");
        sql.append("\tfrom t_gl_cashflowrecord cf \r\n");
        sql.append("\tinner join t_gl_voucher v on v.fid=cf.fvoucherid \r\n");
        sql.append("\tinner join t_bd_period p on p.fid=v.fperiodid \r\n");
        sql.append("\tinner join t_bd_cashflowitem cfi on cfi.fid=cf.fprimaryitemid \r\n");
        sql.append("\tleft  join t_bd_cashflowkeepactivity kc on cfi.fid =kc.fconcashflowitemid \r\n");
        sql.append("where v.fcompanyid=? \r\n");
        params.add(companyId);
        if (includeNoPostedVoucher) {
            sql.append("\t\t      and v.fbizstatus <> 0 and v.fbizstatus <> 2 \r\n");
        } else {
            sql.append("\t\t      and v.fbizstatus =5 \r\n");
        }
        if (queryByPeriod) {
            sql.append("\t\t      and p.fnumber >= ? and p.fnumber <= ? \r\n");
            params.add(startPeriod);
            params.add(endPeriod);
        } else {
            sql.append("              and v.FBookedDate >= ? \r\n");
            sql.append("              and v.FBookedDate <= ? \r\n");
            params.add(startDate);
            params.add(endDate);
        }
        sql.append("      and (cf.fitemflag=1 or cf.fitemflag=3) \r\n");
        sql.append("      and cfi.fisdealactivity =1 and kc.fid is null and v.fsourceType <> 1 \r\n");
        sql.append("group by v.fid \r\n");
        sql.append(") t3 on t1.fid=t3.fid \r\n");
        if (1 == type) {
            sql.append("where netprofit+isnull(supamount,0) = isnull(pamount,0) \r\n");
        } else {
            sql.append("where netprofit+isnull(supamount,0)<>isnull(pamount,0) \r\n");
        }
        return sql.toString();
    }

    public static boolean isPL(AccountViewInfo account, Map difference) {
        return account.getPLType() != AccountPLType.NONE && !difference.containsKey(account.getId().toString());
    }

    public static boolean isPL(AccountViewInfo account, Set<String> difference) {
        return account.getPLType() != AccountPLType.NONE && !difference.contains(account.getId().toString());
    }

    public static boolean isDealActivity(CashFlowItemInfo item, Map difference) {
        return item.isIsDealActivity() && !difference.containsKey(item.getId().toString());
    }

    public static String getDiff(Context ctx) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)CashflowRecordInfo.getAccountSelector());
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("diffAccount.number"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
        CompanyOrgUnitInfo com = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (com.getAccountTable() == null) {
            com = GlUtils.getCurrentCompany(ctx, com.getId().toString(), null, true);
        }
        fic.add(new FilterItemInfo("accountTable.id", (Object)com.getAccountTable().getId().toString()));
        ICashFlowAccountDiff activity = CashFlowAccountDiffFactory.getLocalInstance((Context)ctx);
        CashFlowAccountDiffCollection col = activity.getCashFlowAccountDiffCollection(view);
        StringBuffer sb = new StringBuffer();
        CashFlowAccountDiffInfo diffInfo = null;
        AccountViewInfo account = null;
        for (int i = 0; i < col.size(); ++i) {
            diffInfo = col.get(i);
            account = diffInfo.getDiffAccount();
            sb.append("'").append(account.getId().toString()).append("'").append(",");
        }
        if (col.size() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return null;
    }
}

