/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffCollection;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemType;
import com.kingdee.eas.basedata.assistant.CashFlowKeepActivityCollection;
import com.kingdee.eas.basedata.assistant.CashFlowKeepActivityFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICashFlowAccountDiff;
import com.kingdee.eas.basedata.assistant.ICashFlowKeepActivity;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CFRequisitionFactory;
import com.kingdee.eas.fi.gl.CashFlowDisplayRowInfo;
import com.kingdee.eas.fi.gl.CashFlowFilterPara;
import com.kingdee.eas.fi.gl.CashFlowUtils;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowSplitRecordCollection;
import com.kingdee.eas.fi.gl.CashflowSplitRecordFactory;
import com.kingdee.eas.fi.gl.CashflowSplitRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICFRequisition;
import com.kingdee.eas.fi.gl.ICashflowSplitRecord;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.AbstractCashflowRecordControllerBean;
import com.kingdee.eas.fi.gl.app.CashFlowUnionDao;
import com.kingdee.eas.fi.gl.app.ITAccountSplitStrategy;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.app.TAccountSplitStrategyFactory;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class CashflowRecordControllerBean
extends AbstractCashflowRecordControllerBean {
    private static final long serialVersionUID = 5002459146621338427L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.CashflowRecordControllerBean");
    private static final String resClassName = "com.kingdee.eas.fi.gl.app.CashFlowDispayResource";
    private int lineIndex = 1;
    CompanyOrgUnitInfo curCompany = null;

    private String getResource(Context ctx, String name) {
        return ResourceBase.getString((String)resClassName, (String)name, (Locale)ctx.getLocale());
    }

    @Override
    protected Object[] _genCashFlow(Context ctx, CashFlowFilterPara cashFlowFilterPara) throws BOSException, EASBizException {
        boolean needCombineValue;
        String[] companyIds;
        Object companyTreeNode = cashFlowFilterPara.getCompanyTreeNode();
        this.curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (cashFlowFilterPara.isIsWeb()) {
            if (companyTreeNode instanceof CompanyOrgUnitInfo) {
                this.curCompany = (CompanyOrgUnitInfo)cashFlowFilterPara.getCompanyTreeNode();
            } else if (companyTreeNode instanceof DefaultMutableTreeNode) {
                SimpleCompanyUserObject obj = (SimpleCompanyUserObject)((DefaultMutableTreeNode)cashFlowFilterPara.getCompanyTreeNode()).getUserObject();
                this.curCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(obj.getCompanyId()));
            }
            String companyId = cashFlowFilterPara.getCompanyIds();
            if (companyId.indexOf(",") > 0) {
                companyIds = companyId.split(",");
                for (int i = 0; i < companyIds.length; ++i) {
                    companyIds[i] = companyIds[i].substring(1, companyIds[i].length() - 1);
                }
            } else {
                companyIds = new String[]{companyId.substring(1, companyId.length() - 1)};
            }
        } else {
            companyIds = this.curCompany.isIsBizUnit() ? new String[]{this.curCompany.getId().toString()} : GLRptDaoUtil.set2StringArray(GLRptDaoUtil.getCompanyIds((DefaultMutableTreeNode)cashFlowFilterPara.getCompanyTreeNode()));
        }
        GLBalanceFacadeFactory.getLocalInstance(ctx).updateVoucherBalance(companyIds);
        if (!cashFlowFilterPara.isIsWeb() && !this.curCompany.isIsBizUnit() || cashFlowFilterPara.isIsWeb() && !this.curCompany.isIsBizUnit()) {
            CashFlowUnionDao dao = new CashFlowUnionDao();
            return dao._genCashFlow(ctx, cashFlowFilterPara);
        }
        Object[] arrayReturn = new Object[4];
        this.lineIndex = 1;
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.curCompany);
        int yearFrom = startPeriod.getPeriodYear();
        int monthFrom = startPeriod.getPeriodNumber();
        short yearTo = cashFlowFilterPara.getYearTo();
        if (yearFrom != yearTo) {
            monthFrom = PeriodUtils.getMinPeriodNumber((Context)ctx, (int)yearTo, (String)this.curCompany.getId().toString());
            yearFrom = yearTo;
        } else {
            yearFrom = startPeriod.getPeriodYear();
            monthFrom = startPeriod.getPeriodNumber();
        }
        Map initMap = this.getInitAmountMap(ctx, cashFlowFilterPara);
        Vector vecPrimaryItem = this.selectDataFromDB(ctx, cashFlowFilterPara, 0);
        vecPrimaryItem = this.sortCashFlowRecord(vecPrimaryItem, cashFlowFilterPara.getLevel());
        Map primaryMap = this.getSumAmountMap(ctx, cashFlowFilterPara, 0, yearFrom, monthFrom);
        this.combineSumMap(vecPrimaryItem, primaryMap, cashFlowFilterPara);
        boolean bl = needCombineValue = startPeriod.getPeriodYear() == yearTo;
        if (needCombineValue) {
            this.combineInitMap(vecPrimaryItem, initMap, cashFlowFilterPara);
        }
        vecPrimaryItem = this.combinDataForPrimaryItem(ctx, vecPrimaryItem, cashFlowFilterPara);
        arrayReturn[0] = vecPrimaryItem;
        Vector vecSecondary = this.selectDataFromDB(ctx, cashFlowFilterPara, 1);
        Map secondaryMap = this.getSumAmountMap(ctx, cashFlowFilterPara, 1, yearFrom, monthFrom);
        this.combineSumMap(vecSecondary, secondaryMap, cashFlowFilterPara);
        if (needCombineValue) {
            this.combineInitMap(vecSecondary, initMap, cashFlowFilterPara);
        }
        vecSecondary = this.combinDataForSecondaryItem(ctx, cashFlowFilterPara, vecSecondary, startPeriod);
        arrayReturn[1] = vecSecondary;
        Vector vecSupplement = this.selectDataFromDB(ctx, cashFlowFilterPara, 2);
        Map supplementMap = this.getSumAmountMap(ctx, cashFlowFilterPara, 2, yearFrom, monthFrom);
        this.combineSumMap(vecSupplement, supplementMap, cashFlowFilterPara);
        if (needCombineValue) {
            this.combineInitMap(vecSupplement, initMap, cashFlowFilterPara);
        }
        vecSupplement = this.combinDataForSupplementaryItem(ctx, cashFlowFilterPara, vecSupplement);
        arrayReturn[2] = vecSupplement;
        Vector vecCash = this.getAdditionOfCash(ctx, cashFlowFilterPara);
        arrayReturn[3] = vecCash;
        return arrayReturn;
    }

    private Vector selectDataFromDB(Context ctx, CashFlowFilterPara cashFlowFilterPara, int itemType) throws BOSException, EASBizException {
        boolean isAsst = cashFlowFilterPara.isDisplayAsst();
        ObjectUuidPK comPk = new ObjectUuidPK(ContextUtil.getCurrentFIUnit((Context)ctx).getId());
        RptParams pp = new RptParams();
        pp.setObject("GL_004", (Object)comPk);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap allParam = pc.getParamHashMap(new HashMap(pp.toMap()));
        String ssistItemName = "flongnamegroup_l2";
        if (allParam.get("GL_004") != null && Boolean.valueOf(allParam.get("GL_004").toString()).booleanValue()) {
            ssistItemName = "fdisplaynamegroup_l2";
        }
        Vector<DBParam> vec = new Vector<DBParam>();
        StringBuffer sbFName = new StringBuffer("cfi2.FName_");
        String strLocal = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sbFName.append(strLocal);
        StringBuffer sbSql = new StringBuffer("select cfi2.fid,cfi2.fid as FKey,null as FAsstID,cfi2.fnumber,cfi2.ftype,cfi2.FIsProfit,cfi2.FLongNumber FLongNumber,");
        sbSql.append(sbFName);
        sbSql.append(" FName,cfi2.FLevel FLevel,cfi2.FDirection FDirection,cfi2.fisenable fisenable,cfi2.FisLeaf FisLeaf");
        if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
            sbSql.append(",sum(cfr.FLocalAmount");
        } else if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralReportCurrency())) {
            sbSql.append(",sum(cfr.FReportingAmount *(case cfi1.FDirection when 2 then -1 else 1 end) * (case cfi2.FDirection when 2 then -1 else 1 end)");
        } else {
            sbSql.append(",sum(cfr.FOriginalAmount * (case cfi1.FDirection when 2 then -1 else 1 end) * (case cfi2.FDirection when 2 then -1 else 1 end)");
        }
        if (itemType == 0) {
            sbSql.append(" * cfr.FPrimaryCoeffient");
        } else if (itemType == 1) {
            sbSql.append(" * cfr.FSupplementaryCoeffient ");
        }
        sbSql.append(") FAmount");
        sbSql.append(" , cfi2.FIsExChange FIsExChange");
        sbSql.append(",1  fcashType,n'' flongnamegroup");
        sbSql.append(" from T_BD_CashFlowItem cfi1 \r\n");
        sbSql.append(" inner join T_BD_CashFlowItem cfi2 \r\n ");
        sbSql.append(" on (charindex(cfi2.FLongNumber||'!',cfi1.FLongNumber) = 1 ");
        sbSql.append("  or cfi2.FLongNumber=cfi1.FLongNumber) \r\n");
        sbSql.append(" left outer join \r\n");
        sbSql.append(" (");
        if (itemType == 0) {
            sbSql.append(" select cfr.FPrimaryItemID,");
        } else if (itemType == 1) {
            sbSql.append(" select cfr.FSupplementaryItemID, ");
        } else {
            sbSql.append(" select cfr.FfullInfoItemID, ");
        }
        if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
            sbSql.append("cfr.FLocalAmount,");
        } else if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralReportCurrency())) {
            sbSql.append("cfr.FReportingAmount,");
        } else {
            sbSql.append("cfr.FOriginalAmount,");
        }
        if (itemType == 0) {
            sbSql.append("cfr.FPrimaryCoeffient \r\n");
        } else {
            sbSql.append("cfr.FPrimaryCoeffient,cfr.FSupplementaryCoeffient \r\n");
        }
        sbSql.append(" from T_GL_CashflowRecord cfr join T_GL_Voucher voucher on cfr.FVoucherID = voucher.FID ");
        if (cashFlowFilterPara.isTermOrDate()) {
            sbSql.append(" join T_BD_Period period on voucher.FPeriodID = period.FID \r\n");
        }
        sbSql.append(" where voucher.FCompanyID = ? \r\n");
        if (cashFlowFilterPara.isTermOrDate()) {
            int[] periodRange = new int[]{cashFlowFilterPara.getYearFrom(), cashFlowFilterPara.getMonthFrom(), cashFlowFilterPara.getYearTo(), cashFlowFilterPara.getMonthTo()};
            sbSql.append(" AND ");
            sbSql.append(SQLUtil.getPeriodCondition("period.FPeriodYear", "period.FPeriodNumber", periodRange));
        } else {
            sbSql.append(" and voucher.FBookedDate >= ? \r\n");
            sbSql.append(" and voucher.FBookedDate <= ? \r\n");
        }
        if (this.isLocalOrReportCurrency(cashFlowFilterPara.getCurrencyId())) {
            sbSql.append(" and cfr.FCurrencyID = ? \r\n");
        }
        sbSql.append(" and voucher.FBizStatus in(");
        sbSql.append(5);
        if (cashFlowFilterPara.isAllVoucher()) {
            sbSql.append(",");
            sbSql.append(3);
            sbSql.append(",");
            sbSql.append(1);
        }
        sbSql.append(")");
        if (itemType == 0) {
            sbSql.append(" )cfr \r\n on cfr.FPrimaryItemID = cfi1.FID \r\n");
        } else if (itemType == 1) {
            sbSql.append(" )cfr \r\n on cfr.FSupplementaryItemID = cfi1.FID \r\n");
        } else {
            sbSql.append(" )cfr \r\n on cfr.FfullInfoItemID = cfi1.FID \r\n");
        }
        sbSql.append("where cfi2.FType = ? \r\n");
        sbSql.append(" and cfi2.FLevel <= ? \r\n");
        sbSql.append(" group by cfi2.FLongNumber,cfi2.FName_");
        sbSql.append(strLocal);
        sbSql.append(",cfi2.FLevel,cfi2.FDirection,cfi2.fisenable,cfi2.FisLeaf,cfi2.FIsProfit,cfi2.fid,cfi2.fnumber,cfi2.ftype,cfi2.FIsExchange \r\n");
        if (isAsst) {
            StringBuffer asstSql = new StringBuffer();
            String amountField = null;
            amountField = cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency()) ? "cfr.FLocalAmount" : (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralReportCurrency()) ? "cfr.FReportingAmount" : "cfr.FOriginalAmount");
            asstSql.append("union all (select cfi2.fid, cfi2.fid || hg.fid  as FKey,");
            asstSql.append(" hg.fid as FAsstID,cfi2.fnumber,cfi2.ftype,cfi2.FIsProfit,cfi2.FLongNumber FLongNumber,n' ' FName,");
            asstSql.append("\n   cfi2.FLevel FLevel,cfi2.FDirection FDirection,cfi2.fisenable fisenable,cfi2.FisLeaf FisLeaf,sum(");
            asstSql.append(amountField);
            asstSql.append(" * cfr.FPrimaryCoeffient) FAmount , cfi2.FIsExChange FIsExChange,cfr.ftype fcashtype,");
            asstSql.append("hg.").append(ssistItemName).append(" flongnamegroup");
            asstSql.append("\n from  T_BD_CashFlowItem cfi2 ");
            asstSql.append("\n inner join");
            asstSql.append(" ( select cfr.FPrimaryItemID,cfr.FLocalAmount,cfr.FOriginalAmount,cfr.FReportingAmount,cfr.FPrimaryCoeffient,cfr.ftype,cfr.fassgrpid  from T_GL_CashflowRecord cfr join T_GL_Voucher voucher on cfr.FVoucherID = voucher.FID    join T_BD_Period period on voucher.FPeriodID = period.FID ");
            asstSql.append(" join T_GL_VoucherEntry ve on cfr.FEntryID = ve.FID ");
            asstSql.append(" where voucher.FCompanyID = ? \r\n");
            if (cashFlowFilterPara.isTermOrDate()) {
                int[] periodRange = new int[]{cashFlowFilterPara.getYearFrom(), cashFlowFilterPara.getMonthFrom(), cashFlowFilterPara.getYearTo(), cashFlowFilterPara.getMonthTo()};
                asstSql.append(" AND ");
                asstSql.append(SQLUtil.getPeriodCondition("period.FPeriodYear", "period.FPeriodNumber", periodRange));
            } else {
                asstSql.append(" and voucher.FBookedDate >= ? \r\n");
                asstSql.append(" and voucher.FBookedDate <= ? \r\n");
            }
            if (this.isLocalOrReportCurrency(cashFlowFilterPara.getCurrencyId())) {
                asstSql.append(" and ve.FCurrencyID = ? \r\n");
            }
            asstSql.append(" and voucher.FBizStatus in(");
            asstSql.append(5);
            if (cashFlowFilterPara.isAllVoucher()) {
                asstSql.append(",");
                asstSql.append(3);
                asstSql.append(",");
                asstSql.append(1);
            }
            asstSql.append("  ))cfr ");
            asstSql.append(" on cfr.FPrimaryItemID = cfi2.FID ");
            asstSql.append("left join t_bd_assistanthg hg on cfr.fassgrpid=hg.fid \n");
            asstSql.append("where ");
            if (!cashFlowFilterPara.isCfImportAssist()) {
                asstSql.append(" cfi2.fisenable=1 and ");
            }
            asstSql.append(" cfi2.fisleaf=1 and cfi2.flevel>1  and cfi2.FType = ? \r\n");
            asstSql.append(" and cfi2.FLevel <= ? \r\n");
            asstSql.append("group by cfi2.FLongNumber,cfi2.FName_l2,cfi2.FLevel,cfi2.FDirection,cfi2.fisenable,cfi2.FisLeaf,cfi2.FIsProfit,cfi2.fid,hg.fid,cfi2.fnumber,cfi2.ftype,cfi2.FIsExchange ");
            asstSql.append(",cfr.ftype,hg.").append(ssistItemName);
            asstSql.append(" having sum(" + amountField + " * cfr.FPrimaryCoeffient) <> 0 ");
            asstSql.append(")");
            sbSql.append(asstSql);
        }
        sbSql.append("\r\n order by FLongNumber,fcashtype \r\n");
        ArrayList<String> param = new ArrayList<String>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sbSql.toString());
            int index = 1;
            ps.setString(index++, this.curCompany.getId().toString());
            param.add(this.curCompany.getId().toString());
            if (!cashFlowFilterPara.isTermOrDate()) {
                ps.setDate(index++, new Date(cashFlowFilterPara.getDateFrom().getTime()));
                ps.setDate(index++, new Date(cashFlowFilterPara.getDateTo().getTime()));
            }
            if (this.isLocalOrReportCurrency(cashFlowFilterPara.getCurrencyId())) {
                ps.setString(index++, cashFlowFilterPara.getCurrencyId());
            }
            ps.setInt(index++, itemType);
            short level = cashFlowFilterPara.getLevel();
            if (level == 1) {
                ps.setShort(index++, (short)2);
            } else {
                ps.setShort(index++, level);
            }
            if (isAsst) {
                ps.setString(index++, this.curCompany.getId().toString());
                if (!cashFlowFilterPara.isTermOrDate()) {
                    ps.setDate(index++, new Date(cashFlowFilterPara.getDateFrom().getTime()));
                    ps.setDate(index++, new Date(cashFlowFilterPara.getDateTo().getTime()));
                }
                if (!cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency()) && !cashFlowFilterPara.getCurrencyId().equals(this.getGeneralReportCurrency())) {
                    ps.setString(index++, cashFlowFilterPara.getCurrencyId());
                }
                ps.setInt(index++, itemType);
                if (level == 1) {
                    ps.setShort(index++, (short)2);
                } else {
                    ps.setShort(index++, level);
                }
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                DBParam p = new DBParam();
                p.FID = rs.getString("FKey");
                p.FLevel = new Integer(rs.getInt("FLevel"));
                p.FLOngNumber = rs.getString("FLongNumber");
                p.FName = rs.getString("FName");
                p.FDirection = new Integer(rs.getInt("FDirection"));
                BigDecimal amount = rs.getBigDecimal("FAmount");
                p.FAmount = amount == null ? GlUtils.zero : amount;
                p.FIsEnable = new Integer(rs.getInt("FIsEnable"));
                p.FIsLeaf = new Integer(rs.getInt("FisLeaf"));
                p.FIsProfit = new Boolean(rs.getBoolean("FIsProfit"));
                CashFlowItemInfo info = new CashFlowItemInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setName(p.FName);
                info.setNumber(rs.getString("FNumber"));
                info.setType(CashFlowItemType.getEnum((int)rs.getInt("FType")));
                info.setIsProfit(p.FIsProfit.booleanValue());
                info.setLongNumber(p.FLOngNumber);
                p.itemInfo = info;
                p.FIsExchange = new Boolean(rs.getBoolean("FIsExChange"));
                if (isAsst) {
                    p.FCashType = CashflowTypeEnum.getEnum((int)rs.getInt("fcashType"));
                    p.FLongNameGroup = rs.getString("flongnamegroup");
                    if (p.FLongNameGroup != null) {
                        p.FLongNameGroup = p.FLongNameGroup.replaceAll("_!", " ");
                        p.FLongNameGroup = VoucherUtil.decodeSplitFlag(p.FLongNameGroup);
                    }
                    p.FAsstID = rs.getString("FAsstID");
                    p.FID = p.FID + p.FCashType;
                }
                vec.addElement(p);
            }
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return vec;
    }

    private boolean isLocalOrReportCurrency(String currencyId) {
        return !currencyId.equals(this.getGeneralLocalCurrency()) && !currencyId.equals(this.getGeneralReportCurrency());
    }

    private Map getSumAmountMap(Context ctx, CashFlowFilterPara cashFlowFilterPara, int itemType, int startYear, int startPeriod) throws BOSException, EASBizException {
        if (!cashFlowFilterPara.isTermOrDate()) {
            return Collections.EMPTY_MAP;
        }
        String idFiled = null;
        idFiled = itemType == 0 ? "cfr.FPrimaryItemID" : (itemType == 1 ? "cfr.FSupplementaryItemID" : "cfr.FfullInfoItemID");
        String amountField = null;
        String currencyId = cashFlowFilterPara.getCurrencyId();
        boolean isGlCurrency = currencyId.equals(this.getGeneralLocalCurrency());
        boolean isGLRptCurrency = currencyId.equals(this.getGeneralReportCurrency());
        amountField = isGlCurrency ? "cfr.FLocalAmount" : (isGLRptCurrency ? "cfr.FReportingAmount" : "cfr.FOriginalAmount");
        String rateField = null;
        rateField = itemType == 0 ? "cfr.FPrimaryCoeffient" : (itemType == 1 ? "cfr.FSupplementaryCoeffient" : "1");
        StringBuffer sql = new StringBuffer(512);
        ArrayList<Object> param = new ArrayList<Object>();
        sql.append(" select FID,FName,FAsstID,FCashType,sum(FAmount) as FAmount,FIsEnable from ( \n");
        sql.append(" select cfi2.FID as FID,null as FName,null as FAsstID,1 as FCashType,cfr.FAmount as FAmount,cfi2.fisenable from ");
        sql.append(" T_BD_CashFlowItem cfi1 ");
        sql.append(" inner join T_BD_CashFlowItem cfi2 ");
        sql.append(" on (charindex(cfi2.FLongNumber||'!',cfi1.FLongNumber) = 1 ");
        sql.append(" or cfi2.FLongNumber=cfi1.FLongNumber) ");
        sql.append(" left outer join (");
        sql.append(" select ");
        sql.append(idFiled);
        sql.append(",(");
        sql.append(amountField);
        sql.append("*");
        sql.append(rateField);
        sql.append(") as FAmount");
        sql.append(" from T_GL_CashflowRecord cfr \n");
        sql.append(" join T_GL_Voucher voucher on cfr.FVoucherID = voucher.FID \n");
        sql.append(" join T_BD_Period period on voucher.FPeriodID = period.FID \n");
        sql.append(" where voucher.FCompanyID = ? \n");
        param.add(this.curCompany.getId().toString());
        int[] periodRange = new int[]{startYear * 100 + startPeriod, cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo()};
        sql.append(" AND ");
        sql.append(SQLUtil.getPeriodCondition("period.FNumber", periodRange));
        if (!isGlCurrency && !isGLRptCurrency) {
            sql.append(" and cfr.FCurrencyID = ? \r\n");
            param.add(currencyId);
        }
        sql.append(" and voucher.FBizStatus in(");
        sql.append(5);
        if (cashFlowFilterPara.isAllVoucher()) {
            sql.append(",");
            sql.append(3);
            sql.append(",");
            sql.append(1);
        }
        sql.append(") )as cfr");
        sql.append(" on ");
        sql.append(idFiled);
        sql.append(" = cfi1.FID ");
        sql.append(" where ");
        sql.append(" cfi2.FType = ? \n");
        param.add(new Integer(itemType));
        sql.append(" and cfi2.FLevel <= ? \n");
        short level = cashFlowFilterPara.getLevel();
        int lv = level == 1 ? 2 : (int)level;
        param.add(new Integer(lv));
        boolean isAsst = cashFlowFilterPara.isDisplayAsst();
        if (isAsst) {
            ObjectUuidPK comPk = new ObjectUuidPK(ContextUtil.getCurrentFIUnit((Context)ctx).getId());
            RptParams pp = new RptParams();
            pp.setObject("GL_004", (Object)comPk);
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            HashMap allParam = pc.getParamHashMap(new HashMap(pp.toMap()));
            String ssistItemName = "flongnamegroup_" + ctx.getLocale().toString();
            if (allParam.get("GL_004") != null && Boolean.valueOf(allParam.get("GL_004").toString()).booleanValue()) {
                ssistItemName = "fdisplaynamegroup_" + ctx.getLocale().toString();
            }
            StringBuffer asstSql = new StringBuffer(512);
            asstSql.append(" union all \n");
            asstSql.append(" select cfi2.fid as FID,replace(hg." + ssistItemName + ",'_!',' ') as FName,\n");
            asstSql.append(" hg.fid FAsstID, \n");
            asstSql.append(" (case when cfr.FType =3 then 3 else 2 end) as FCashType,cfr.FAmount as FAmount,cfi2.fisenable from \n");
            asstSql.append(" T_BD_CashFlowItem cfi2 ");
            asstSql.append(" left outer join (");
            asstSql.append(" select cfr.FAssgrpID,cfr.FType, \n");
            asstSql.append(idFiled);
            asstSql.append(",(");
            asstSql.append(amountField);
            asstSql.append("*");
            asstSql.append(rateField);
            asstSql.append(") as FAmount");
            asstSql.append(" from T_GL_CashflowRecord cfr \n");
            asstSql.append(" join T_GL_Voucher voucher on cfr.FVoucherID = voucher.FID \n");
            asstSql.append(" join T_BD_Period period on voucher.FPeriodID = period.FID \n");
            asstSql.append(" join T_GL_VoucherEntry ve on cfr.FEntryID = ve.FID \n");
            asstSql.append(" where voucher.FCompanyID = ? \n");
            param.add(this.curCompany.getId().toString());
            asstSql.append(" and ");
            asstSql.append(SQLUtil.getPeriodCondition("period.FNumber", periodRange));
            if (!isGlCurrency && !isGLRptCurrency) {
                asstSql.append(" and ve.FCurrencyID = ? \r\n");
                param.add(currencyId);
            }
            asstSql.append(" and voucher.FBizStatus in(");
            asstSql.append(5);
            if (cashFlowFilterPara.isAllVoucher()) {
                asstSql.append(",");
                asstSql.append(3);
                asstSql.append(",");
                asstSql.append(1);
            }
            asstSql.append("  ))cfr ");
            asstSql.append(" on " + idFiled + " = cfi2.FID ");
            asstSql.append(" left join t_bd_assistanthg hg on cfr.fassgrpid=hg.fid \n");
            asstSql.append(" where ");
            asstSql.append(" cfi2.fisenable=1 and ");
            asstSql.append(" cfi2.fisleaf=1 and cfi2.flevel>1  and cfi2.FType = ? \r\n");
            param.add(new Integer(itemType));
            asstSql.append(" and cfi2.FLevel <= ? \r\n");
            param.add(new Integer(lv));
            sql.append(asstSql);
        }
        sql.append(" ) as A group by FID,FName,FAsstID,FCashType,FIsEnable \r\n");
        sql.append(" having sum(FAmount) <> 0 \r\n");
        HashMap<String, MapParam> map = new HashMap<String, MapParam>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        try {
            while (rs.next()) {
                String FID = rs.getString(1);
                String FName = rs.getString(2);
                String FAsstID = rs.getString(3);
                CashflowTypeEnum FCashType = CashflowTypeEnum.getEnum((int)rs.getInt(4));
                BigDecimal FAmount = rs.getBigDecimal(5);
                if (FID == null || FAmount == null) continue;
                MapParam m = new MapParam();
                m.FID = FID;
                m.FName = FName;
                m.FAsstID = FAsstID;
                m.FCashType = FCashType;
                m.FAmount = FAmount;
                m.FIsEnable = new Integer(rs.getInt(6));
                String key = FAsstID == null ? FID + FCashType : FID + FAsstID + FCashType;
                map.put(key, m);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return map;
    }

    private Map getInitAmountMap(Context ctx, CashFlowFilterPara cashFlowFilterPara) throws BOSException, EASBizException {
        boolean isClose = GLFlagFactory.getLocalInstance(ctx).getCashflowInitClosed(this.curCompany.getId().toString());
        if (!isClose) {
            return Collections.EMPTY_MAP;
        }
        String amountField = null;
        String currencyId = cashFlowFilterPara.getCurrencyId();
        boolean isGlCurrency = currencyId.equals(this.getGeneralLocalCurrency());
        boolean isGLRptCurrency = currencyId.equals(this.getGeneralReportCurrency());
        amountField = isGlCurrency ? "FLocalAmount" : (isGLRptCurrency ? "FReportingAmount" : "FOriginalAmount");
        StringBuffer sql = new StringBuffer(512);
        ArrayList<String> param = new ArrayList<String>();
        sql.append(" select FID,FName,FAsstID,FCashType,sum(FSum) as FSum from ( \n");
        sql.append(" select cfi2.fid as FID, null as FName,null as FAsstID, 1 as FCashType,\n");
        sql.append(" cfin.FSum as FSum from ");
        sql.append(" T_BD_CashFlowItem cfi1 ");
        sql.append(" inner join T_BD_CashFlowItem cfi2 ");
        sql.append(" on (charindex(cfi2.FLongNumber||'!',cfi1.FLongNumber) = 1 ");
        sql.append(" or cfi2.FLongNumber=cfi1.FLongNumber) ");
        sql.append(" left outer join (");
        sql.append("select cfin.FCashflowItemID,cfin.");
        sql.append(amountField);
        sql.append(" as FSum");
        sql.append(" from T_GL_CashflowInit cfin \n");
        sql.append(" where cfin.FCompanyID = ? \n");
        param.add(this.curCompany.getId().toString());
        if (!isGlCurrency && !isGLRptCurrency) {
            sql.append(" and cfin.FCurrencyID = ? \r\n");
            param.add(currencyId);
        }
        sql.append(" )as cfin");
        sql.append(" on cfin.FCashflowItemID = cfi1.FID");
        boolean isAsst = cashFlowFilterPara.isDisplayAsst();
        if (isAsst) {
            boolean isAstClosed = GLFlagFactory.getLocalInstance(ctx).getCashflowGrpAsstClosed(this.curCompany.getId().toString());
            String amount = isAstClosed ? "asst." + amountField : "0";
            StringBuffer asstSql = new StringBuffer();
            asstSql.append(" union all \n");
            asstSql.append(" select init.FCashflowItemID as FID, \n");
            asstSql.append(" hg.FLongNameGroup_l2 as FName, asst.FAssistGrpID as FAsstID, asst.FType as FCashType, \n");
            asstSql.append(amount);
            asstSql.append(" as\u3000FSum \n");
            asstSql.append(" from T_GL_CashflowGrpAsst as asst \n");
            asstSql.append(" left outer join T_GL_CashflowInit as init \n");
            asstSql.append(" on init.FID = asst.FCflowInitID \n");
            asstSql.append(" left outer join t_bd_assistanthg hg \n");
            asstSql.append(" on asst.FAssistGrpID = hg.fid \n");
            asstSql.append(" where init.FCompanyID = ? \n");
            param.add(this.curCompany.getId().toString());
            sql.append(asstSql);
        }
        sql.append(" ) as A group by FID,FName,FAsstID,FCashType ");
        HashMap<String, MapParam> map = new HashMap<String, MapParam>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        try {
            while (rs.next()) {
                String FID = rs.getString(1);
                String FName = rs.getString(2);
                String FAsstID = rs.getString(3);
                CashflowTypeEnum FCashType = CashflowTypeEnum.getEnum((int)rs.getInt(4));
                BigDecimal FAmount = rs.getBigDecimal(5);
                if (FID == null || FAmount == null) continue;
                MapParam m = new MapParam();
                m.FID = FID;
                m.FName = FName;
                m.FAsstID = FAsstID;
                m.FCashType = FCashType;
                m.FAmount = FAmount;
                String key = FAsstID == null ? FID : FID + FAsstID + FCashType;
                map.put(key, m);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return map;
    }

    private void combineSumMap(Vector vec, Map map, CashFlowFilterPara cashFlowFilterPara) {
        if (vec == null || vec.size() < 1 || map == null || map.size() < 1) {
            return;
        }
        if (cashFlowFilterPara.isDisplayAsst()) {
            this.combineAsstMap(vec, map, cashFlowFilterPara);
        }
        int l = vec.size();
        for (int i = 0; i < l; ++i) {
            DBParam p = (DBParam)vec.elementAt(i);
            if (map.get(p.FID) == null) continue;
            p.FSum = ((MapParam)map.get((Object)p.FID)).FAmount;
        }
    }

    private void combineInitMap(Vector vec, Map map, CashFlowFilterPara cashFlowFilterPara) {
        if (vec == null || vec.size() < 1 || map == null || map.size() < 1) {
            return;
        }
        if (cashFlowFilterPara.isDisplayAsst()) {
            this.combineAsstMap(vec, map, cashFlowFilterPara);
        }
        int l = vec.size();
        for (int i = 0; i < l; ++i) {
            DBParam p = (DBParam)vec.elementAt(i);
            if (map.get(p.FID) == null) continue;
            BigDecimal init = ((MapParam)map.get((Object)p.FID)).FAmount;
            p.FSum = p.FSum != null ? p.FSum.add(init) : init;
        }
    }

    private void combineAsstMap(Vector vec, Map map, CashFlowFilterPara cashFlowFilterPara) {
        boolean isAsst = cashFlowFilterPara.isDisplayAsst();
        if (isAsst) {
            DBParam p;
            int i;
            HashMap candidateMap = new HashMap();
            Collection coll = map.values();
            Iterator it = coll.iterator();
            boolean isCandidate = false;
            while (it.hasNext()) {
                List<MapParam> list;
                MapParam mp = (MapParam)it.next();
                if (mp.FIsEnable != null) {
                    isCandidate = mp.FIsEnable == 1 && !CashflowTypeEnum.NONE.equals((Object)mp.FCashType);
                } else {
                    boolean bl = isCandidate = !CashflowTypeEnum.NONE.equals((Object)mp.FCashType);
                }
                if (isCandidate && candidateMap.containsKey(mp.FID)) {
                    list = (List)candidateMap.get(mp.FID);
                    list.add(mp);
                    continue;
                }
                if (!isCandidate) continue;
                list = new ArrayList<MapParam>();
                list.add(mp);
                candidateMap.put(mp.FID, list);
            }
            HashMap<String, Integer> excludeMap = new HashMap<String, Integer>();
            HashMap<String, DBParam> acceptMap = new HashMap<String, DBParam>();
            int l = vec.size();
            for (i = 0; i < l; ++i) {
                p = (DBParam)vec.elementAt(i);
                if (p.FIsEnable == 1 && !CashflowTypeEnum.NONE.equals((Object)p.FCashType)) {
                    excludeMap.put(p.FID, new Integer(i));
                    continue;
                }
                acceptMap.put(p.FID, p);
            }
            l = vec.size();
            for (i = 0; i < l; ++i) {
                p = (DBParam)vec.elementAt(i);
                List list = (List)candidateMap.get(p.FID);
                if (list == null) continue;
                String key = null;
                for (int j = 0; j < list.size(); ++j) {
                    MapParam mp = (MapParam)list.get(j);
                    String string = key = mp.FAsstID == null ? mp.FID + mp.FCashType : mp.FID + mp.FAsstID + mp.FCashType;
                    if (excludeMap.containsKey(key)) continue;
                    DBParam ps = (DBParam)acceptMap.get(mp.FID);
                    int index = vec.indexOf(ps);
                    DBParam pi = new DBParam();
                    pi.copy(ps);
                    pi.FID = key;
                    pi.FAsstID = mp.FAsstID;
                    pi.FAmount = InitHelp.zero;
                    pi.FSum = InitHelp.zero;
                    pi.FName = "";
                    pi.FLongNameGroup = mp.FName;
                    pi.FCashType = mp.FCashType;
                    vec.insertElementAt(pi, index + 1);
                }
            }
        }
    }

    private Vector sortCashFlowRecord(Vector vec, short level) {
        Vector<DBParam> vecInAndOut = new Vector<DBParam>();
        Vector<DBParam> vecIn = new Vector<DBParam>();
        Vector<DBParam> vecOut = new Vector<DBParam>();
        Vector<int[]> vecIndex = new Vector<int[]>();
        int[] firstIndex = new int[]{0, vec.size() - 1};
        vecIndex.addElement(firstIndex);
        for (short i = 0; i < level; i = (short)(i + 1)) {
            int indexSize = vecIndex.size();
            Vector<int[]> tmpIndex = new Vector<int[]>();
            for (int j = 0; j < indexSize; ++j) {
                int[] index = (int[])vecIndex.elementAt(j);
                int begin = index[0];
                int end = index[1];
                int iDirection = 0;
                vecInAndOut.removeAllElements();
                vecIn.removeAllElements();
                vecOut.removeAllElements();
                block7: for (int k = begin; k <= end; ++k) {
                    DBParam p = (DBParam)vec.elementAt(k);
                    int thisLevel = p.FLevel;
                    if (thisLevel == i) {
                        iDirection = p.FDirection;
                    }
                    switch (iDirection) {
                        case 0: {
                            vecInAndOut.addElement(p);
                            if (thisLevel != level && k != end) continue block7;
                            int[] thisIndex = new int[2];
                            thisIndex[0] = k + 1;
                            if (k != begin && k != end) {
                                if (!tmpIndex.isEmpty()) {
                                    ((int[])tmpIndex.lastElement())[1] = k - 1;
                                }
                            } else if (k == end && !tmpIndex.isEmpty()) {
                                ((int[])tmpIndex.lastElement())[1] = k;
                            }
                            if (k == end) continue block7;
                            tmpIndex.addElement(thisIndex);
                            continue block7;
                        }
                        case 1: {
                            vecIn.addElement(p);
                            continue block7;
                        }
                        case 2: {
                            vecOut.addElement(p);
                        }
                    }
                }
                int seq = begin;
                int sizeInAndOut = vecInAndOut.size();
                for (i = 0; i < sizeInAndOut; i = (short)(i + 1)) {
                    vec.setElementAt(vecInAndOut.elementAt(i), seq++);
                }
                int sizeIn = vecIn.size();
                for (i = 0; i < sizeIn; i = (short)(i + 1)) {
                    vec.setElementAt(vecIn.elementAt(i), seq++);
                }
                int sizeOut = vecOut.size();
                for (i = 0; i < sizeOut; i = (short)(i + 1)) {
                    vec.setElementAt(vecOut.elementAt(i), seq++);
                }
            }
            vecIndex = tmpIndex;
        }
        return vec;
    }

    private Vector combinDataForPrimaryItem(Context ctx, Vector vec, CashFlowFilterPara cashFlowFilterPara) throws EASBizException, BOSException {
        boolean isAsst = cashFlowFilterPara.isDisplayAsst();
        Vector<CashFlowDisplayRowInfo> vecReturn = new Vector<CashFlowDisplayRowInfo>();
        int firstLevelSeq = 1;
        int sizeVec = vec == null ? 0 : vec.size();
        short maxLevel = cashFlowFilterPara.getLevel();
        String sumName = null;
        BigDecimal bdTotal = new BigDecimal(0);
        BigDecimal bdSumTotal = new BigDecimal(0);
        BigDecimal bdInSum = new BigDecimal(0);
        BigDecimal bdInTotal = new BigDecimal(0);
        BigDecimal bdOutSum = new BigDecimal(0);
        BigDecimal bdOutTotal = new BigDecimal(0);
        BigDecimal bdCashSum = new BigDecimal(0);
        BigDecimal bdCashSumTotal = new BigDecimal(0);
        for (int i = 0; i < sizeVec; ++i) {
            DBParam p = (DBParam)vec.elementAt(i);
            DBParam pNext = null;
            if (i + 1 < sizeVec) {
                pNext = (DBParam)vec.elementAt(i + 1);
            }
            int thisLevel = p.FLevel;
            int thisDirection = p.FDirection;
            int thisIsLeaf = p.FIsLeaf;
            boolean thisIsExchange = p.FIsExchange;
            BigDecimal thisAmount = p.FAmount;
            BigDecimal thisSum = p.FSum == null ? new BigDecimal(0) : p.FSum;
            CashFlowDisplayRowInfo row = new CashFlowDisplayRowInfo();
            if (thisLevel == 1 && (cashFlowFilterPara.isDisplayExchangeSubsidiary() || !thisIsExchange)) {
                row.name = ResourceBase.getString((String)resClassName, (String)String.valueOf(firstLevelSeq), (Locale)ctx.getLocale()) + p.FName;
                sumName = p.FName;
                ++firstLevelSeq;
                vecReturn.addElement(row);
            } else if (maxLevel != 1 && (cashFlowFilterPara.isDisplayExchangeSubsidiary() || !thisIsExchange)) {
                row.name = this.getBlankString(thisLevel) + p.FName;
                row.seq = new Integer(this.lineIndex++);
                row.amount = p.FAmount;
                row.sum = p.FSum;
                row.itemInfo = p.itemInfo;
                if (isAsst) {
                    row.cashType = p.FCashType;
                    row.longNameGroup = p.FLongNameGroup;
                    row.assGrpid = p.FAsstID;
                }
                vecReturn.addElement(row);
            } else if (thisLevel == 1) {
                sumName = p.FName;
            }
            if (null == sumName) {
                sumName = "";
            }
            boolean flag = true;
            if (thisIsLeaf != 1 && thisLevel >= 3 && pNext != null && pNext.FLOngNumber.indexOf(p.FLOngNumber) == -1) {
                bdTotal = bdTotal.add(thisAmount);
                bdSumTotal = bdSumTotal.add(thisSum);
                flag = false;
            }
            if (thisDirection != 0) {
                if ((thisIsLeaf == 1 || maxLevel == 1 && thisLevel == 2 || maxLevel > 1 && thisLevel == maxLevel) && (!isAsst || isAsst && p.FCashType.equals((Object)CashflowTypeEnum.NONE)) && flag) {
                    bdTotal = bdTotal.add(thisAmount);
                    bdSumTotal = bdSumTotal.add(thisSum);
                }
                if (pNext == null || pNext.FLevel == 2 || pNext.FDirection != thisDirection && pNext.FAsstID == null) {
                    CashFlowDisplayRowInfo rowInOut = new CashFlowDisplayRowInfo();
                    if (thisDirection == 1) {
                        rowInOut.name = this.getBlankString(2) + this.getResource(ctx, "strInTotal");
                        bdInSum = bdInSum.add(bdTotal);
                        bdInTotal = bdInTotal.add(bdSumTotal);
                    } else {
                        rowInOut.name = this.getBlankString(2) + this.getResource(ctx, "strOutTotal");
                        bdOutSum = bdOutSum.add(bdTotal);
                        bdOutTotal = bdOutTotal.add(bdSumTotal);
                    }
                    rowInOut.amount = bdTotal;
                    rowInOut.sum = bdSumTotal;
                    rowInOut.isSumRow = Boolean.TRUE;
                    if (maxLevel != 1 && (cashFlowFilterPara.isDisplayExchangeSubsidiary() || !thisIsExchange)) {
                        rowInOut.seq = new Integer(this.lineIndex++);
                        vecReturn.addElement(rowInOut);
                    }
                    bdTotal = new BigDecimal(0);
                    bdSumTotal = new BigDecimal(0);
                }
            }
            if (pNext != null && pNext.FLevel != 1) continue;
            CashFlowDisplayRowInfo rowSum = new CashFlowDisplayRowInfo();
            rowSum.name = cashFlowFilterPara.isDisplayExchangeSubsidiary() || !thisIsExchange ? this.getBlankString(2) + this.getSumString(ctx, sumName) : ResourceBase.getString((String)resClassName, (String)String.valueOf(firstLevelSeq++), (Locale)ctx.getLocale()) + sumName;
            rowSum.seq = new Integer(this.lineIndex++);
            rowSum.amount = bdInSum.subtract(bdOutSum);
            rowSum.sum = bdInTotal.subtract(bdOutTotal);
            rowSum.isSumRow = Boolean.TRUE;
            bdCashSum = bdCashSum.add(bdInSum.subtract(bdOutSum));
            bdCashSumTotal = bdCashSumTotal.add(bdInTotal.subtract(bdOutTotal));
            vecReturn.addElement(rowSum);
            bdInSum = new BigDecimal(0);
            bdInTotal = new BigDecimal(0);
            bdOutSum = new BigDecimal(0);
            bdOutTotal = new BigDecimal(0);
        }
        if (!cashFlowFilterPara.isDisplayCashBalanceForBeginAndEnd()) {
            CashFlowDisplayRowInfo rowCashBalance = new CashFlowDisplayRowInfo();
            rowCashBalance.name = this.getResource(ctx, "strCashSum");
            rowCashBalance.seq = new Integer(this.lineIndex++);
            rowCashBalance.amount = bdCashSum;
            rowCashBalance.sum = bdCashSumTotal;
            rowCashBalance.isSumRow = Boolean.TRUE;
            vecReturn.addElement(rowCashBalance);
        } else {
            CashFlowDisplayRowInfo rowCashBalance = new CashFlowDisplayRowInfo();
            rowCashBalance.name = ResourceBase.getString((String)resClassName, (String)String.valueOf(firstLevelSeq++), (Locale)ctx.getLocale()) + this.getResource(ctx, "strCashSum");
            rowCashBalance.seq = new Integer(this.lineIndex++);
            rowCashBalance.amount = bdCashSum;
            rowCashBalance.sum = bdCashSumTotal;
            rowCashBalance.isSumRow = Boolean.TRUE;
            vecReturn.addElement(rowCashBalance);
            BigDecimal[] bdArray = this.getCashBalance(ctx, cashFlowFilterPara);
            BigDecimal[] bdSumArray = this.getSumCashBalance(ctx, cashFlowFilterPara);
            BigDecimal bdCashBeginSum = bdArray[0].add(bdArray[2]);
            BigDecimal bdCashBeginSumTotal = bdSumArray[0].add(bdSumArray[2]);
            rowCashBalance = new CashFlowDisplayRowInfo();
            rowCashBalance.name = this.getBlankString(2) + this.getResource(ctx, "strAddCashAndXjdjwBegin");
            rowCashBalance.seq = new Integer(this.lineIndex++);
            rowCashBalance.amount = bdCashBeginSum;
            rowCashBalance.sum = bdCashBeginSumTotal;
            rowCashBalance.isSumRow = Boolean.FALSE;
            vecReturn.addElement(rowCashBalance);
            rowCashBalance = new CashFlowDisplayRowInfo();
            rowCashBalance.name = ResourceBase.getString((String)resClassName, (String)String.valueOf(firstLevelSeq++), (Locale)ctx.getLocale()) + this.getResource(ctx, "strCashAndXjdjwEndBanlance");
            rowCashBalance.seq = new Integer(this.lineIndex++);
            rowCashBalance.amount = bdCashBeginSum.add(bdCashSum);
            rowCashBalance.sum = bdCashBeginSumTotal.add(bdCashSumTotal);
            rowCashBalance.isSumRow = Boolean.TRUE;
            vecReturn.addElement(rowCashBalance);
        }
        return vecReturn;
    }

    private Vector combinDataForSecondaryItem(Context ctx, CashFlowFilterPara cashFlowFilterPara, Vector vec, PeriodInfo startPeriod) throws BOSException, EASBizException {
        Vector<CashFlowDisplayRowInfo> vecReturn = new Vector<CashFlowDisplayRowInfo>();
        BigDecimal amount = this.getRetainedProfits(ctx, cashFlowFilterPara);
        BigDecimal sumAmount = this.getSumRetainedProfits(ctx, cashFlowFilterPara, startPeriod);
        BigDecimal bdTotal = new BigDecimal(0);
        BigDecimal bdSumTotal = new BigDecimal(0);
        int sizeVec = vec.size();
        short maxLevel = cashFlowFilterPara.getLevel();
        for (int i = 0; i < sizeVec; ++i) {
            DBParam p = (DBParam)vec.elementAt(i);
            DBParam pNext = null;
            if (i + 1 < sizeVec) {
                pNext = (DBParam)vec.elementAt(i + 1);
            }
            int thisLevel = p.FLevel;
            CashFlowDisplayRowInfo row = new CashFlowDisplayRowInfo();
            if (thisLevel <= 2) {
                if (maxLevel <= 2 && thisLevel == maxLevel) {
                    bdTotal = bdTotal.add(p.FAmount);
                    if (p.FSum != null) {
                        bdSumTotal = bdSumTotal.add(p.FSum);
                    }
                }
                if (maxLevel == 1 && thisLevel > 1) continue;
                row.name = this.getBlankString(thisLevel + 1) + p.FName;
                vecReturn.addElement(row);
            } else {
                row.name = this.getBlankString(thisLevel + 1) + p.FName;
                row.seq = new Integer(this.lineIndex++);
                row.sum = p.FSum;
                if (p.FIsProfit.booleanValue()) {
                    row.amount = amount;
                    row.sum = row.sum != null ? row.sum.add(sumAmount) : sumAmount;
                } else {
                    row.amount = p.FAmount;
                    if (p.FIsLeaf != null && p.FIsLeaf == 1) {
                        bdTotal = bdTotal.add(p.FAmount);
                        if (p.FSum != null) {
                            bdSumTotal = bdSumTotal.add(p.FSum);
                        }
                    } else if (pNext != null && pNext.FLOngNumber.indexOf(p.FLOngNumber) == -1) {
                        bdTotal = bdTotal.add(p.FAmount);
                        if (p.FSum != null) {
                            sumAmount = sumAmount.add(p.FSum);
                        }
                    }
                }
                vecReturn.addElement(row);
            }
            row.itemInfo = p.itemInfo;
        }
        CashFlowDisplayRowInfo rowSum = new CashFlowDisplayRowInfo();
        rowSum.name = this.getBlankString(2) + this.getResource(ctx, "strWork");
        rowSum.seq = new Integer(this.lineIndex++);
        rowSum.amount = amount.add(bdTotal);
        rowSum.sum = sumAmount.add(bdSumTotal);
        rowSum.isSumRow = Boolean.TRUE;
        vecReturn.addElement(rowSum);
        return vecReturn;
    }

    private Vector combinDataForSupplementaryItem(Context ctx, CashFlowFilterPara cashFlowFilterPara, Vector vec) throws BOSException {
        Vector<CashFlowDisplayRowInfo> vecReturn = new Vector<CashFlowDisplayRowInfo>();
        int sizeVec = vec.size();
        short maxLevel = cashFlowFilterPara.getLevel();
        for (int i = 0; i < sizeVec; ++i) {
            DBParam p = (DBParam)vec.elementAt(i);
            int thisLevel = p.FLevel;
            CashFlowDisplayRowInfo row = new CashFlowDisplayRowInfo();
            if (thisLevel <= 1) {
                row.name = this.getBlankString(thisLevel + 1) + p.FName;
                row.amount = p.FAmount;
                vecReturn.addElement(row);
            } else {
                if (maxLevel == 1) continue;
                row.name = this.getBlankString(thisLevel + 1) + p.FName;
                row.seq = new Integer(this.lineIndex++);
                row.amount = p.FAmount;
                vecReturn.addElement(row);
            }
            row.sum = p.FSum;
        }
        return vecReturn;
    }

    private Vector getAdditionOfCash(Context ctx, CashFlowFilterPara cashFlowFilterPara) throws BOSException, EASBizException {
        Vector<CashFlowDisplayRowInfo> vecReturn = new Vector<CashFlowDisplayRowInfo>();
        BigDecimal[] bdArray = this.getCashBalance(ctx, cashFlowFilterPara);
        BigDecimal[] bdSumArray = this.getSumCashBalance(ctx, cashFlowFilterPara);
        CashFlowDisplayRowInfo row = new CashFlowDisplayRowInfo();
        row.name = this.getResource(ctx, "strAdd");
        vecReturn.addElement(row);
        row = new CashFlowDisplayRowInfo();
        row.name = this.getBlankString(2) + this.getResource(ctx, "strCashEnd");
        row.seq = new Integer(this.lineIndex++);
        row.amount = bdArray[1];
        row.sum = bdSumArray[1];
        vecReturn.addElement(row);
        row = new CashFlowDisplayRowInfo();
        row.name = this.getBlankString(2) + this.getResource(ctx, "strJCahsBegin");
        row.seq = new Integer(this.lineIndex++);
        row.amount = bdArray[0];
        row.sum = bdSumArray[0];
        vecReturn.addElement(row);
        row = new CashFlowDisplayRowInfo();
        row.name = this.getBlankString(2) + this.getResource(ctx, "strAddSjdjwEnd");
        row.seq = new Integer(this.lineIndex++);
        row.amount = bdArray[3];
        row.sum = bdSumArray[3];
        vecReturn.addElement(row);
        row = new CashFlowDisplayRowInfo();
        row.name = this.getBlankString(2) + this.getResource(ctx, "strJSjdjwEnd");
        row.seq = new Integer(this.lineIndex++);
        row.amount = bdArray[2];
        row.sum = bdSumArray[2];
        vecReturn.addElement(row);
        row = new CashFlowDisplayRowInfo();
        row.name = this.getBlankString(2) + this.getResource(ctx, "strCashAndXjdjw");
        row.seq = new Integer(this.lineIndex++);
        row.amount = bdArray[1].subtract(bdArray[0]).add(bdArray[3]).subtract(bdArray[2]);
        row.sum = bdSumArray[1].subtract(bdSumArray[0]).add(bdSumArray[3].subtract(bdSumArray[2]));
        vecReturn.addElement(row);
        return vecReturn;
    }

    private BigDecimal getRetainedProfits(Context ctx, CashFlowFilterPara cashFlowFilterPara) throws BOSException, EASBizException {
        BigDecimal bdReturn = null;
        StringBuffer sbSql = new StringBuffer("select ");
        if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FLocalAmount else (-1) * FLocalAmount end) FAmount");
        } else if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralReportCurrency())) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FReportingAmount else (-1) * FReportingAmount end) FAmount");
        } else {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FOriginalAmount else (-1) * FOriginalAmount end) FAmount");
        }
        sbSql.append(" from T_GL_Voucher voucher join T_GL_VoucherEntry ve on voucher.FID = ve.FBillID join T_BD_AccountView account on ve.FAccountID = account.FID left join t_bd_cashflowaccountdiff on fdiffaccountid=account.FID");
        if (cashFlowFilterPara.isTermOrDate()) {
            sbSql.append(" ,T_BD_Period period");
        }
        sbSql.append(" where voucher.FCompanyID = ?");
        sbSql.append(" and account.fcompanyid = ?");
        sbSql.append(" and fdiffaccountid is null");
        sbSql.append(" and account.FPLType <> ?");
        if (cashFlowFilterPara.isTermOrDate()) {
            sbSql.append(" and voucher.FPeriodID = period.FID");
            sbSql.append(" and period.FNumber >= ?");
            sbSql.append(" and period.FNumber <= ?");
        } else {
            sbSql.append(" and voucher.FBookedDate >= ?");
            sbSql.append(" and voucher.FBookedDate <= ?");
        }
        if (this.isLocalOrReportCurrency(cashFlowFilterPara.getCurrencyId())) {
            sbSql.append(" and ve.FCurrencyID = ?");
        }
        sbSql.append(" and voucher.FSourceType<>1 ");
        sbSql.append(" and voucher.FBizStatus in(");
        sbSql.append(5);
        if (cashFlowFilterPara.isAllVoucher()) {
            sbSql.append(",");
            sbSql.append(1);
            sbSql.append(",");
            sbSql.append(3);
        }
        sbSql.append(")");
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sbSql.toString());
            int index = 1;
            ps.setString(index++, this.curCompany.getId().toString());
            ps.setString(index++, this.curCompany.getId().toString());
            ps.setInt(index++, 0);
            if (cashFlowFilterPara.isTermOrDate()) {
                ps.setInt(index++, cashFlowFilterPara.getYearFrom() * 100 + cashFlowFilterPara.getMonthFrom());
                ps.setInt(index++, cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo());
            } else {
                ps.setDate(index++, new Date(cashFlowFilterPara.getDateFrom().getTime()));
                ps.setDate(index++, new Date(cashFlowFilterPara.getDateTo().getTime()));
            }
            if (this.isLocalOrReportCurrency(cashFlowFilterPara.getCurrencyId())) {
                ps.setString(index++, cashFlowFilterPara.getCurrencyId());
            }
            rs = ps.executeQuery();
            rs.next();
            bdReturn = rs.getBigDecimal("FAmount");
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bdReturn == null ? GlUtils.zero : bdReturn;
    }

    private BigDecimal getSumRetainedProfits(Context ctx, CashFlowFilterPara cashFlowFilterPara, PeriodInfo startPeriod) throws BOSException, EASBizException {
        BigDecimal bdReturn = new BigDecimal(0);
        if (!cashFlowFilterPara.isTermOrDate()) {
            return bdReturn;
        }
        int yearFrom = startPeriod.getPeriodYear();
        int monthFrom = startPeriod.getPeriodNumber();
        short yearTo = cashFlowFilterPara.getYearTo();
        short monthTo = cashFlowFilterPara.getMonthTo();
        boolean needComineInitValue = false;
        if (yearFrom != yearTo) {
            monthFrom = PeriodUtils.getMinPeriodNumber((Context)ctx, (int)yearTo, (String)this.curCompany.getId().toString());
            yearFrom = yearTo;
        } else {
            yearFrom = startPeriod.getPeriodYear();
            monthFrom = startPeriod.getPeriodNumber();
            needComineInitValue = GLFlagFactory.getLocalInstance(ctx).getCashflowInitClosed(this.curCompany.getId().toString());
        }
        PeriodInfo minPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.curCompany);
        if (needComineInitValue && minPeriod.getPeriodNumber() == 1) {
            needComineInitValue = false;
        }
        StringBuffer sbSql = new StringBuffer("select ");
        ArrayList<Object> param = new ArrayList<Object>();
        if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FLocalAmount else (-1) * FLocalAmount end) FAmount");
        } else if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralReportCurrency())) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FReportingAmount else (-1) * FReportingAmount end) FAmount");
        } else {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FOriginalAmount else (-1) * FOriginalAmount end) FAmount");
        }
        sbSql.append(" from T_GL_Voucher voucher join T_GL_VoucherEntry ve on voucher.FID = ve.FBillID join T_BD_AccountView account on ve.FAccountID = account.FID left join t_bd_cashflowaccountdiff on fdiffaccountid=account.FID");
        sbSql.append(" ,T_BD_Period period");
        sbSql.append(" where voucher.FCompanyID = ?");
        param.add(this.curCompany.getId().toString());
        sbSql.append(" and account.FCompanyID = ?");
        param.add(this.curCompany.getId().toString());
        sbSql.append(" and fdiffaccountid is null");
        sbSql.append(" and account.FPLType <> ?");
        param.add(new Integer(0));
        sbSql.append(" and voucher.FPeriodID = period.FID");
        sbSql.append(" and period.FPeriodYear >= ?");
        param.add(new Integer(yearFrom));
        sbSql.append(" and period.FPeriodNumber >= ?");
        param.add(new Integer(monthFrom));
        sbSql.append(" and period.FPeriodYear <= ?");
        param.add(new Integer(yearTo));
        sbSql.append(" and period.FPeriodNumber <= ?");
        param.add(new Integer(monthTo));
        if (this.isLocalOrReportCurrency(cashFlowFilterPara.getCurrencyId())) {
            sbSql.append(" and ve.FCurrencyID = ?");
            param.add(cashFlowFilterPara.getCurrencyId().toString());
        }
        sbSql.append(" and voucher.FSourceType<>1 ");
        sbSql.append(" and voucher.FBizStatus in(");
        sbSql.append(5);
        if (cashFlowFilterPara.isAllVoucher()) {
            sbSql.append(",");
            sbSql.append(1);
            sbSql.append(",");
            sbSql.append(3);
        }
        sbSql.append(")");
        if (needComineInitValue) {
            String diffAccountSet = com.kingdee.eas.fi.gl.app.CashFlowUtils.getDiff(ctx);
            String currencyId = cashFlowFilterPara.getCurrencyId();
            boolean isGlCurrency = currencyId.equals(this.getGeneralLocalCurrency());
            boolean isGLRptCurrency = currencyId.equals(this.getGeneralReportCurrency());
            String amountField = isGlCurrency ? "FYearPnLLocal" : (isGLRptCurrency ? "FYearPnLRpt" : "FYearPnLFor");
            StringBuffer sql = new StringBuffer();
            sql.append(" select sum(FAmount) FAmount from (");
            sql.append(sbSql);
            sql.append(" union all ");
            sql.append("select sum((-1) * account.FDC * ").append(amountField).append(") FAmount ");
            sql.append(" from T_GL_InitAccountBalance balance join T_BD_AccountView account");
            sql.append(" on balance.FAccountID = account.FID ");
            sql.append(" where account.FIsLeaf = 1 and account.FPLType>0");
            sql.append(" and balance.FOrgUnitId = ?");
            param.add(this.curCompany.getId().toString());
            sql.append(" and balance.FCurrencyID = ?");
            if (diffAccountSet != null && diffAccountSet.length() > 0) {
                sbSql.append(" and account.FID not in (" + diffAccountSet + ")");
            }
            param.add(cashFlowFilterPara.getCurrencyId());
            sql.append(" ) as A");
            sbSql = sql;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])param.toArray());
        try {
            if (rs.next()) {
                bdReturn = rs.getBigDecimal("FAmount");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return bdReturn == null ? new BigDecimal(0) : bdReturn;
    }

    private BigDecimal[] getCashBalance(Context ctx, CashFlowFilterPara cashFlowFilterPara) throws BOSException, EASBizException {
        BigDecimal equEnd;
        BigDecimal equBegin;
        BigDecimal cashEnd;
        BigDecimal cashBegin;
        BigDecimal[] arrayReturn = new BigDecimal[4];
        PeriodInfo periodBegin = null;
        PeriodInfo periodEnd = null;
        if (cashFlowFilterPara.isTermOrDate()) {
            periodBegin = this.getPeriodByYearAndNumber(ctx, cashFlowFilterPara.getYearFrom(), cashFlowFilterPara.getMonthFrom());
            periodEnd = this.getPeriodByYearAndNumber(ctx, cashFlowFilterPara.getYearTo(), cashFlowFilterPara.getMonthTo());
        } else {
            periodBegin = this.getPeriodByDate(ctx, new Date(cashFlowFilterPara.getDateFrom().getTime()));
            PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.curCompany);
            if (periodBegin == null || currentPeriod.getPeriodYear() * 100 + currentPeriod.getPeriodNumber() < periodBegin.getPeriodYear() * 100 + periodBegin.getPeriodNumber()) {
                periodBegin = currentPeriod;
            }
            periodEnd = this.getPeriodByDate(ctx, new Date(cashFlowFilterPara.getDateTo().getTime()));
        }
        if (cashFlowFilterPara.isTermOrDate()) {
            cashBegin = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodBegin, true, true);
            cashEnd = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodEnd, true, false);
            equBegin = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodBegin, false, true);
            equEnd = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodEnd, false, false);
        } else {
            cashEnd = cashBegin = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodBegin, true, true);
            equEnd = equBegin = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodBegin, false, true);
            GregorianCalendar gcStart = new GregorianCalendar();
            gcStart.setTime(cashFlowFilterPara.getDateFrom());
            gcStart.add(5, -1);
            Date startDate = new Date(gcStart.getTime().getTime());
            GregorianCalendar gcEnd = new GregorianCalendar();
            gcEnd.setTime(cashFlowFilterPara.getDateTo());
            gcEnd.add(5, 1);
            cashBegin = cashBegin.add(this.getAmountFromVoucher(ctx, cashFlowFilterPara, new Date(periodBegin.getBeginDate().getTime()), startDate, true));
            cashEnd = cashEnd.add(this.getAmountFromVoucher(ctx, cashFlowFilterPara, new Date(periodBegin.getBeginDate().getTime()), new Date(cashFlowFilterPara.getDateTo().getTime()), true));
            equBegin = equBegin.add(this.getAmountFromVoucher(ctx, cashFlowFilterPara, new Date(periodBegin.getBeginDate().getTime()), startDate, false));
            equEnd = equEnd.add(this.getAmountFromVoucher(ctx, cashFlowFilterPara, new Date(periodBegin.getBeginDate().getTime()), new Date(cashFlowFilterPara.getDateTo().getTime()), false));
        }
        arrayReturn[0] = cashBegin;
        arrayReturn[1] = cashEnd;
        arrayReturn[2] = equBegin;
        arrayReturn[3] = equEnd;
        return arrayReturn;
    }

    private BigDecimal[] getSumCashBalance(Context ctx, CashFlowFilterPara cashFlowFilterPara) throws BOSException, EASBizException {
        BigDecimal[] arrayReturn = new BigDecimal[4];
        BigDecimal cashBegin = new BigDecimal(0);
        BigDecimal cashEnd = new BigDecimal(0);
        BigDecimal equBegin = new BigDecimal(0);
        BigDecimal equEnd = new BigDecimal(0);
        PeriodInfo periodBegin = null;
        PeriodInfo periodEnd = null;
        if (cashFlowFilterPara.isTermOrDate()) {
            short yearFrom = cashFlowFilterPara.getYearFrom();
            short yearTo = cashFlowFilterPara.getYearTo();
            int monthFrom = cashFlowFilterPara.getMonthFrom();
            short monthTo = cashFlowFilterPara.getMonthTo();
            if (yearFrom != yearTo) {
                yearFrom = yearTo;
            }
            monthFrom = PeriodUtils.getMinPeriodNumber((Context)ctx, (int)yearFrom, (String)this.curCompany.getId().toString());
            periodBegin = this.getPeriodByYearAndNumber(ctx, yearFrom, monthFrom);
            periodEnd = this.getPeriodByYearAndNumber(ctx, yearTo, monthTo);
            cashBegin = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodBegin, true, true);
            cashEnd = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodEnd, true, false);
            equBegin = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodBegin, false, true);
            equEnd = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodEnd, false, false);
        }
        arrayReturn[0] = cashBegin;
        arrayReturn[1] = cashEnd;
        arrayReturn[2] = equBegin;
        arrayReturn[3] = equEnd;
        return arrayReturn;
    }

    private BigDecimal getAmountFromBalance(Context ctx, CashFlowFilterPara cashFlowFilterPara, PeriodInfo periodBegin, PeriodInfo periodEnd, boolean isCash, boolean isBegin) throws BOSException, EASBizException {
        BigDecimal bdReturn = GlUtils.zero;
        if (periodBegin == null || periodBegin.getId() == null) {
            return bdReturn;
        }
        StringBuffer sbSql = new StringBuffer("Select ");
        boolean isForCurrency = false;
        if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
            if (isBegin) {
                sbSql.append(" sum(FBeginBalanceLocal) FAmount ");
            } else {
                sbSql.append(" sum(FDebitLocal-FCreditLocal+FBeginBalanceLocal) FAmount ");
            }
        } else if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralReportCurrency())) {
            if (isBegin) {
                sbSql.append(" sum(FBeginBalanceRpt) FAmount ");
            } else {
                sbSql.append(" sum(FDebitRpt-FCreditRpt+FBeginBalanceRpt) FAmount ");
            }
        } else {
            isForCurrency = true;
            if (isBegin) {
                sbSql.append(" sum(FBeginBalanceFor) FAmount ");
            } else {
                sbSql.append(" sum(FDebitFor-FCreditFor+FBeginBalanceFor) FAmount ");
            }
        }
        int balType = cashFlowFilterPara.isAllVoucher() ? 1 : 5;
        sbSql.append(" from " + GLBalanceUtils.getAccountBalanceTable(balType, cashFlowFilterPara.getCurrencyId()) + " balance join T_BD_AccountView account");
        sbSql.append(" on balance.FAccountID = account.FID ");
        sbSql.append(" where account.FIsLeaf = 1");
        sbSql.append(" and balance.FOrgUnitId = ?");
        sbSql.append(" AND ");
        if (periodEnd == null) {
            sbSql.append("balance.FPeriod >= " + (periodBegin.getPeriodYear() * 100 + periodBegin.getPeriodNumber()));
        } else {
            sbSql.append("balance.FPeriod in " + SQLUtil.buildPeriodNumbersInSql(periodBegin.getPeriodYear(), periodBegin.getPeriodNumber(), periodEnd.getPeriodYear(), periodEnd.getPeriodNumber()));
        }
        if (isForCurrency) {
            sbSql.append(" and balance.FCurrencyID = ?");
        }
        if (isCash) {
            sbSql.append(" and (account.FIsCash = 1 or account.FIsBank = 1) ");
        } else {
            sbSql.append(" and account.FIsCashEquivalent = 1");
        }
        if (!isBegin) {
            sbSql.append(" GROUP BY balance.FPeriod ORDER BY balance.FPeriod DESC");
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sbSql.toString());
            int index = 1;
            ps.setString(index++, this.curCompany.getId().toString());
            if (isForCurrency) {
                ps.setString(index++, cashFlowFilterPara.getCurrencyId());
            }
            if ((rs = ps.executeQuery()).next()) {
                bdReturn = rs.getBigDecimal("FAmount");
            }
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bdReturn == null ? GlUtils.zero : bdReturn;
    }

    private BigDecimal getAmountFromVoucher(Context ctx, CashFlowFilterPara cashFlowFilterPara, Date begin, Date end, boolean isCash) throws BOSException, EASBizException {
        BigDecimal bdReturn = null;
        StringBuffer sbSql = new StringBuffer("Select");
        if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
            sbSql.append(" sum(case ve.FEntryDC when 1 then ve.FLocalAmount else (-1) * FLocalAmount end) FAmount");
        } else if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralReportCurrency())) {
            sbSql.append(" sum(case ve.FEntryDC when 1 then ve.FReportingAmount else (-1) * FReportingAmount end) FAmount");
        } else {
            sbSql.append(" sum(case ve.FEntryDC when 1 then ve.FOriginalAmount else (-1) * FOriginalAmount end) FAmount");
        }
        sbSql.append(" from T_GL_Voucher voucher,T_GL_VoucherEntry ve,T_BD_AccountView account");
        sbSql.append(" where voucher.FID = ve.FBillID");
        sbSql.append(" and ve.FAccountID = account.FID ");
        sbSql.append(" and voucher.FCompanyID = ?");
        sbSql.append(" and voucher.FBookedDate >= ?");
        sbSql.append(" and voucher.FBookedDate <= ?");
        if (this.isLocalOrReportCurrency(cashFlowFilterPara.getCurrencyId())) {
            sbSql.append(" and ve.FCurrencyID = ?");
        }
        if (isCash) {
            sbSql.append(" and (account.FIsCash = 1 or account.FIsBank = 1) ");
        } else {
            sbSql.append(" and account.FIsCashEquivalent = 1");
        }
        sbSql.append(" and voucher.FBizStatus in(");
        sbSql.append(5);
        if (cashFlowFilterPara.isAllVoucher()) {
            sbSql.append(",");
            sbSql.append(3);
            sbSql.append(",");
            sbSql.append(1);
        }
        sbSql.append(")");
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sbSql.toString());
            int index = 1;
            ps.setString(index++, this.curCompany.getId().toString());
            ps.setDate(index++, begin);
            ps.setDate(index++, end);
            if (this.isLocalOrReportCurrency(cashFlowFilterPara.getCurrencyId())) {
                ps.setString(index++, cashFlowFilterPara.getCurrencyId());
            }
            rs = ps.executeQuery();
            rs.next();
            bdReturn = rs.getBigDecimal("FAmount");
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bdReturn == null ? GlUtils.zero : bdReturn;
    }

    private String getSumString(Context ctx, String sumName) {
        StringBuffer sbReturn = new StringBuffer(this.getResource(ctx, "strSum"));
        int pos = sbReturn.indexOf("@");
        sbReturn.replace(pos, pos + 1, sumName);
        return sbReturn.toString();
    }

    private String getBlankString(int level) {
        StringBuffer sbBlank = new StringBuffer();
        for (int i = 1; i < level; ++i) {
            sbBlank.append("    ");
        }
        return sbBlank.toString();
    }

    private String getGeneralLocalCurrency() {
        return CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
    }

    private String getGeneralReportCurrency() {
        return CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
    }

    private PeriodInfo getPeriodByDate(Context ctx, Date tsDate) throws BOSException, EASBizException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("beginDate", (Object)tsDate, CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("endDate", (Object)tsDate, CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("periodType.id", (Object)this.curCompany.getAccountPeriodType().getId().toString()));
        view.setFilter(filter);
        PeriodCollection periodCollection = iPeriod.getPeriodCollection(view);
        PeriodInfo periodInfo = periodCollection == null || periodCollection.size() == 0 ? null : periodCollection.get(0);
        return periodInfo;
    }

    private PeriodInfo getPeriodByYearAndNumber(Context ctx, int PeriodYear, int PeriodNumber) throws BOSException, EASBizException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(PeriodYear)));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(PeriodNumber)));
        fic.add(new FilterItemInfo("periodType.id", (Object)this.curCompany.getAccountPeriodType().getId().toString()));
        view.setFilter(filter);
        PeriodCollection periodCollection = iPeriod.getPeriodCollection(view);
        PeriodInfo periodInfo = periodCollection == null || periodCollection.size() == 0 ? null : periodCollection.get(0);
        return periodInfo;
    }

    @Override
    protected void _saveCashflowCols(Context ctx, IObjectCollection cashflowCols, Map mapParam) throws EASBizException, BOSException {
        if (cashflowCols == null || cashflowCols.isEmpty()) {
            return;
        }
        String vchId = (String)mapParam.get("vchid");
        ICFRequisition iCFReq = CFRequisitionFactory.getLocalInstance(ctx);
        ObjectUuidPK voucherPK = new ObjectUuidPK(vchId);
        boolean isEnableSendCFReq = false;
        VoucherInfo cfVch = (VoucherInfo)mapParam.get("vch");
        IObjectPK logPK = null;
        if (cfVch != null) {
            logPK = LogUtil.beginLogWithDescription((Context)ctx, (String)"saveCashflowCols", (BOSObjectType)cfVch.getBOSType(), (IObjectPK)new ObjectUuidPK(vchId), (String)this.getLogDetail(ctx, (BaseVoucherInfo)cfVch), (String)"saveCashlow");
        }
        String sql = "update t_gl_voucher set fcashflowflag = ? where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{4, vchId});
        BaseVoucherInfo sVoucher = this.getStatusVoucher(ctx, new ObjectUuidPK(vchId));
        this.versionCheck((BaseVoucherInfo)cfVch, sVoucher);
        if ("true".equals(mapParam.get("cfReq"))) {
            isEnableSendCFReq = iCFReq.isEnableCFRequisition(cfVch.getCompany().getId().toString());
            iCFReq.clearRequisition((IObjectPK)voucherPK);
        }
        sql = "delete from t_gl_cashflowrecord where fvoucherid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{vchId});
        int size = cashflowCols.size();
        for (int i = 0; i < size; ++i) {
            CashflowRecordInfo info = (CashflowRecordInfo)cashflowCols.getObject(i);
            if (info.getItemFlag().equals((Object)ItemFlag.SUPPLEMENTARY)) {
                info.setType(CashflowTypeEnum.NONE);
            }
            this.save(ctx, (CoreBaseInfo)info);
        }
        sql = "delete from t_gl_cashflowsplitrecord where fvoucherid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{vchId});
        if ("true".equals(mapParam.get("cfReq"))) {
            ITAccountSplitStrategy plSplitStrategy = TAccountSplitStrategyFactory.getSplitStrategy("pl");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("cashflowRecords", cashflowCols);
            CashflowSplitRecordCollection splitColl = plSplitStrategy.split(ctx, cfVch, params);
            if (cashflowCols.size() > 0) {
                for (int i = 0; i < splitColl.size(); ++i) {
                    CashflowSplitRecordInfo record = splitColl.get(i);
                    record.setIsSupItem(true);
                }
            }
            if (splitColl.size() > 0) {
                CashflowSplitRecordFactory.getLocalInstance(ctx).addBatch((IObjectCollection)splitColl);
            }
            if (isEnableSendCFReq) {
                iCFReq.sendRequisition((IObjectPK)voucherPK);
            }
        }
        if (null != cfVch && logPK != null) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
    }

    private void versionCheck(BaseVoucherInfo voucherInfo, BaseVoucherInfo vch) throws BOSException, EASBizException, VoucherException {
        if (!vch.getLastUpdateTime().equals(voucherInfo.getLastUpdateTime())) {
            throw new VoucherException(VoucherException.EDIT_CONFLICT);
        }
    }

    protected BaseVoucherInfo getStatusVoucher(Context ctx, ObjectUuidPK pk) throws EASBizException, BOSException {
        String table = null;
        BOSUuid id = BOSUuid.read((String)pk.toString());
        if ("2652E01E".equals(id.getType().toString())) {
            table = "T_GL_Voucher";
        } else if ("D6952559".equals(id.getType().toString())) {
            table = "T_PCA_PCVoucher";
        } else {
            return null;
        }
        String sql = "select FBizStatus, FLastUpdateTime, FSourceSys, FSourceType, FNumber from " + table + " where FID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{pk.toString()});
        try {
            if (rs.next()) {
                BaseVoucherInfo voucher = new BaseVoucherInfo();
                voucher.setId(id);
                voucher.setBizStatus(VoucherStatusEnum.getEnum((int)rs.getInt("FBizStatus")));
                voucher.setLastUpdateTime(rs.getTimestamp("FLastUpdateTime"));
                voucher.setSourceSys(SystemEnum.getEnum((int)rs.getInt("FSourceSys")));
                voucher.setSourceType(SourceType.getEnum((int)rs.getInt("FSourceType")));
                voucher.setNumber(rs.getString("FNumber"));
                return voucher;
            }
            return null;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected String getLogDetail(Context ctx, BaseVoucherInfo voucherInfo) {
        String LogDetail = voucherInfo.getVoucherType() != null ? voucherInfo.getVoucherType().getName(ctx.getLocale()) : "?";
        LogDetail = LogDetail + "-";
        LogDetail = voucherInfo.getPeriod() != null ? (voucherInfo.getPeriod().getNumber() > 0 ? LogDetail + voucherInfo.getPeriod().getNumber() : (voucherInfo.getPeriod().getPeriodNumber() < 10 ? LogDetail + voucherInfo.getPeriod().getPeriodYear() + "0" + voucherInfo.getPeriod().getPeriodNumber() : LogDetail + voucherInfo.getPeriod().getPeriodYear() + "" + voucherInfo.getPeriod().getPeriodNumber())) : LogDetail + "?";
        LogDetail = LogDetail + "-";
        LogDetail = LogDetail + (voucherInfo.getNumber() != null ? voucherInfo.getNumber() : "?");
        return LogDetail;
    }

    @Override
    protected Map _getDifference(Context ctx, String companyID) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("accountTable.id"));
        selector.add(new SelectorItemInfo("CU.id"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), selector);
        String cuId = company.getCU().getId().toString();
        HashMap<String, Object> difference = new HashMap<String, Object>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)CashflowRecordInfo.getActivitySelector());
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("conCashFlowItem.number"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("CU.id", (Object)cuId));
        ICashFlowKeepActivity activity = CashFlowKeepActivityFactory.getLocalInstance((Context)ctx);
        CashFlowKeepActivityCollection col = activity.getCashFlowKeepActivityCollection(view);
        if (col != null) {
            difference.put("CashFlowKeepActivityCollection", col);
        }
        EntityViewInfo view2 = new EntityViewInfo();
        SelectorItemCollection sic2 = view2.getSelector();
        sic2.addObjectCollection((IObjectCollection)CashflowRecordInfo.getAccountSelector());
        SorterItemCollection sorters2 = view2.getSorter();
        sorters2.add(new SorterItemInfo("diffAccount.number"));
        FilterInfo filter2 = new FilterInfo();
        view2.setFilter(filter2);
        FilterItemCollection fic2 = filter2.getFilterItems();
        fic2.add(new FilterItemInfo("CU.id", (Object)cuId));
        if (company.getAccountTable() == null) {
            throw new GLException(GLException.NO_ACCOUNTTABLE);
        }
        fic2.add(new FilterItemInfo("accountTable.id", (Object)company.getAccountTable().getId().toString()));
        ICashFlowAccountDiff activity2 = CashFlowAccountDiffFactory.getLocalInstance((Context)ctx);
        CashFlowAccountDiffCollection col2 = activity2.getCashFlowAccountDiffCollection(view2);
        if (col != null) {
            difference.put("CashFlowAccountDiffCollection", col2);
        }
        return difference;
    }

    @Override
    protected Map _getColAndDifference(Context ctx, String vchId) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("company.id");
        VoucherInfo voucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)vchId)), selector);
        CompanyOrgUnitInfo company = voucher.getCompany() == null ? ContextUtil.getCurrentFIUnit((Context)ctx) : voucher.getCompany();
        Map difference = VoucherProcessCache.getDifference(ctx, company.getId().toString());
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)CashflowRecordInfo.getDefaultSelector());
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("opposingAccountEntry.seq"));
        sorters.add(new SorterItemInfo("seq"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("voucher.id", (Object)vchId));
        filter.getFilterItems().add(new FilterItemInfo("itemFlag", (Object)new Integer(7), CompareType.NOTEQUALS));
        CashflowRecordCollection cfCol = this.getCashflowRecordCollection(ctx, view);
        if (cfCol != null) {
            difference.put("CashflowRecordCollection", cfCol);
        }
        return difference;
    }

    @Override
    protected boolean _hasExchangeItem(Context ctx) throws BOSException {
        String sql = " select top 1 * from  t_bd_cashflowitem  where fisexchange = 1  ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (set != null && set.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected IObjectCollection _lazyLoad(Context ctx, Map saveParam) throws BOSException, EASBizException {
        throw new BOSException("Method lazyLoad is not supported");
    }

    @Override
    protected Map _saveUn(Context ctx, IObjectCollection cfCol) throws BOSException, EASBizException {
        HashMap<String, IObjectPK> pkMap = new HashMap<String, IObjectPK>();
        int size = cfCol.size();
        IObjectPK pk = null;
        for (int i = 0; i < size; ++i) {
            IObjectValue info = cfCol.getObject(i);
            pk = this.save(ctx, (CoreBaseInfo)info);
            pkMap.put(String.valueOf(info.getInt("seq")), pk);
        }
        return pkMap;
    }

    @Override
    protected boolean _clear(Context ctx, String voucherId) throws BOSException, EASBizException {
        ICFRequisition iCFReq = CFRequisitionFactory.getLocalInstance(ctx);
        iCFReq.clearRequisition((IObjectPK)new ObjectUuidPK(voucherId));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("voucher.ID", (Object)voucherId));
        filter.getFilterItems().add(new FilterItemInfo("itemFlag", (Object)new Integer(7), CompareType.NOTEQUALS));
        super._delete(ctx, filter);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().addObjectCollection((IObjectCollection)VoucherInfo.getCashflowSelector());
        FilterInfo filterVch = new FilterInfo();
        filterVch.getFilterItems().add(new FilterItemInfo("id", (Object)voucherId, CompareType.EQUALS));
        view.setFilter(filterVch);
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        VoucherCollection vouchers = iVoucher.getVoucherCollection(view);
        VoucherInfo voucher = vouchers.get(0);
        if (voucher.isHasCashAccount()) {
            ITAccountSplitStrategy strategy = TAccountSplitStrategyFactory.getSplitStrategy("default");
            CashflowSplitRecordCollection splitResult = strategy.split(ctx, voucher, new HashMap<String, Object>());
            ICashflowSplitRecord cfSplit = CashflowSplitRecordFactory.getLocalInstance(ctx);
            cfSplit.delete(filter);
            cfSplit.addBatch((IObjectCollection)splitResult);
            if (!CashflowFlag.NONE.equals((Object)voucher.getCashflowFlag())) {
                voucher.setCashflowFlag(CashflowFlag.SPLITTED);
            }
        } else {
            voucher.setCashflowFlag(CashFlowUtils.computeCashflowFlag(voucher));
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("cashflowFlag"));
        iVoucher.updatePartial((CoreBaseInfo)voucher, sic);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _addNewBatch(Context ctx, IObjectCollection records) throws BOSException, EASBizException {
        Connection cn = this.getConnection(ctx);
        try {
            IORMappingDAO iCashflowRecord = ORMappingDAO.getInstance((BOSObjectType)new CashflowRecordInfo().getBOSType(), (Context)ctx, (Connection)cn);
            CashflowRecordInfo record = null;
            int size = records.size();
            for (int i = 0; i < size; ++i) {
                record = (CashflowRecordInfo)records.getObject(i);
                iCashflowRecord.addNewBatch((IObjectValue)record);
            }
            iCashflowRecord.executeBatch();
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _deleteBatch(Context ctx, List pks) throws BOSException, EASBizException {
        if (pks == null || pks.size() == 0) {
            return;
        }
        Connection cn = this.getConnection(ctx);
        try {
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)new CashflowRecordInfo().getBOSType(), (Context)ctx, (Connection)cn);
            Iterator it = pks.iterator();
            IObjectPK pk = null;
            while (it.hasNext()) {
                pk = (IObjectPK)it.next();
                dao.deleteBatch(pk);
            }
            dao.executeBatch();
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, EntityViewInfo view) throws BOSException {
        if (view != null) {
            view.setFilter(this.prepareFilterInfo(view.getFilter()));
        }
        return super._getCollection(ctx, svcCtx, view);
    }

    protected FilterInfo prepareFilterInfo(FilterInfo filter) {
        if (filter == null || filter.getFilterItems() == null) {
            return filter;
        }
        FilterItemCollection items = filter.getFilterItems();
        for (int i = 0; i < items.size(); ++i) {
            FilterItemInfo item = items.get(i);
            String propertyName = (String)item.get("propertyName");
            if (!propertyName.equalsIgnoreCase("entry.bill.id") && !propertyName.equalsIgnoreCase("opposingAccountEntry.bill.id")) continue;
            item.put("propertyName", (Object)"voucher.id");
        }
        return filter;
    }

    class MapParam {
        String FID;
        String FAsstID;
        String FName;
        BigDecimal FAmount;
        CashflowTypeEnum FCashType;
        Integer FIsEnable;

        MapParam() {
        }
    }

    class DBParam {
        String FID;
        String FLOngNumber;
        String FName;
        Integer FLevel;
        Integer FDirection;
        BigDecimal FAmount;
        Integer FIsLeaf;
        Boolean FIsProfit;
        CashFlowItemInfo itemInfo;
        Boolean FIsExchange;
        CashflowTypeEnum FCashType;
        String FLongNameGroup;
        BigDecimal FSum;
        String FAsstID;
        Integer FIsEnable;

        DBParam() {
        }

        void copy(DBParam p) {
            this.FID = p.FID;
            this.FLOngNumber = p.FLOngNumber;
            this.FName = p.FName;
            this.FLevel = p.FLevel;
            this.FDirection = p.FDirection;
            this.FAmount = p.FAmount;
            this.FIsLeaf = p.FIsLeaf;
            this.FIsProfit = p.FIsProfit;
            this.itemInfo = p.itemInfo;
            this.FIsExchange = p.FIsExchange;
            this.FCashType = p.FCashType;
            this.FLongNameGroup = p.FLongNameGroup;
            this.FSum = p.FSum;
            this.FAsstID = p.FAsstID;
            this.FIsEnable = p.FIsEnable;
        }
    }
}

