/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashFlowDisplayRowInfo;
import com.kingdee.eas.fi.gl.CashFlowFilterPara;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.CashFlowUtils;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.utils.task.BigDecimalSumTask;
import com.kingdee.eas.fi.gl.utils.task.SumTask;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class CashflowSingleDao {
    private static final long serialVersionUID = 2504541403682823946L;
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.CashflowSingleDao");
    private static final String resClassName = "com.kingdee.eas.fi.gl.app.CashFlowDispayResource";
    protected Context ctx;
    CompanyOrgUnitInfo curCompany = null;
    CompanyOrgUnitInfo selectedCompany = null;
    protected volatile ExecutorService executor;

    public Object[] _genCashFlow(Context ctx, CashFlowFilterPara cashFlowFilterPara) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        String selectedCompanyId = cashFlowFilterPara.getSelectedCompanyId();
        try {
            if (selectedCompanyId.contains("'")) {
                selectedCompanyId = selectedCompanyId.replaceAll("'", "");
            }
            this.selectedCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(selectedCompanyId));
            Object[] arrayReturn = new Object[4];
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.selectedCompany);
            int yearFrom = startPeriod.getPeriodYear();
            int monthFrom = startPeriod.getPeriodNumber();
            short yearTo = cashFlowFilterPara.getYearTo();
            if (yearFrom != yearTo) {
                monthFrom = PeriodUtils.getMinPeriodNumber((Context)ctx, (int)yearTo, (String)this.selectedCompany.getId().toString());
                yearFrom = yearTo;
            } else {
                yearFrom = startPeriod.getPeriodYear();
                monthFrom = startPeriod.getPeriodNumber();
            }
            boolean needCombineValue = startPeriod.getPeriodYear() == yearTo;
            Map initMap = this.getInitAmountMap(ctx, cashFlowFilterPara);
            List<Future<Vector>> futureList = this.selectCashflowAsync(ctx, cashFlowFilterPara, initMap, startPeriod, yearFrom, monthFrom, needCombineValue);
            for (int i = 0; i < futureList.size(); ++i) {
                Future<Vector> future = futureList.get(i);
                arrayReturn[i] = future.get();
            }
            this.resetRowNum(arrayReturn);
            Object[] objectArray = arrayReturn;
            return objectArray;
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException(e.getMessage());
        }
        catch (ExecutionException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException(e.getMessage());
        }
        finally {
            this.closeExecutor();
        }
    }

    private void resetRowNum(Object[] arrayReturn) {
        int lineIndex = 0;
        int preMaxIndex = 0;
        for (Object obj : arrayReturn) {
            Vector vector = (Vector)obj;
            for (int i = 0; i < vector.size(); ++i) {
                CashFlowDisplayRowInfo row = (CashFlowDisplayRowInfo)vector.get(i);
                if (row.seq == null) continue;
                row.seq = row.seq + preMaxIndex;
                lineIndex = row.seq;
            }
            preMaxIndex = lineIndex;
        }
    }

    private List<Future<Vector>> selectCashflowAsync(Context ctx, CashFlowFilterPara cashFlowFilterPara, Map initMap, PeriodInfo startPeriod, int yearFrom, int monthFrom, boolean needCombineValue) {
        if (this.isSupportForkJoinPool()) {
            return this.doSelectCashflowAsyncByJDK8(ctx, cashFlowFilterPara, initMap, startPeriod, yearFrom, monthFrom, needCombineValue);
        }
        return this.doSelectCashflowAsyncByOldJDK(ctx, cashFlowFilterPara, initMap, startPeriod, yearFrom, monthFrom, needCombineValue);
    }

    private List<Future<Vector>> doSelectCashflowAsyncByOldJDK(final Context ctx, final CashFlowFilterPara cashFlowFilterPara, final Map initMap, final PeriodInfo startPeriod, final int yearFrom, final int monthFrom, final boolean needCombineValue) {
        List<Integer> cashFlowItemTypes = Arrays.asList(0, 1, 2);
        ArrayList<Future<Vector>> futureList = new ArrayList<Future<Vector>>();
        ExecutorService executorService = this.getExecutorService(false);
        try {
            for (final int cashFlowItemType : cashFlowItemTypes) {
                Future<Vector> vectorFuture = executorService.submit(new Callable<Vector>(){

                    @Override
                    public Vector call() throws Exception {
                        try {
                            Vector vectorItem = CashflowSingleDao.this.selectDataFromDB(ctx, cashFlowFilterPara, cashFlowItemType);
                            if (cashFlowItemType == 0) {
                                CashflowSingleDao.this.sortCashFlowRecord(vectorItem, cashFlowFilterPara.getLevel());
                            }
                            return vectorItem;
                        }
                        catch (BOSException e) {
                            throw new RuntimeException(e);
                        }
                        catch (EASBizException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                Future<Map> sumMapFuture = executorService.submit(new Callable<Map>(){

                    @Override
                    public Map call() throws Exception {
                        try {
                            return CashflowSingleDao.this.getSumAmountMap2(ctx, cashFlowFilterPara, cashFlowItemType, yearFrom, monthFrom);
                        }
                        catch (BOSException e) {
                            throw new RuntimeException(e);
                        }
                        catch (EASBizException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                final Vector vectorItem = vectorFuture.get();
                final Map sumMap = sumMapFuture.get();
                Future<Vector> future = executorService.submit(new Callable<Vector>(){

                    @Override
                    public Vector call() throws Exception {
                        CashflowSingleDao.this.combineSumMap(vectorItem, sumMap, cashFlowFilterPara);
                        if (needCombineValue) {
                            CashflowSingleDao.this.combineInitMap(vectorItem, initMap, cashFlowFilterPara);
                        }
                        switch (cashFlowItemType) {
                            case 0: {
                                return CashflowSingleDao.this.combinDataForPrimaryItem(ctx, vectorItem, cashFlowFilterPara);
                            }
                            case 1: {
                                return CashflowSingleDao.this.combinDataForSecondaryItem(ctx, cashFlowFilterPara, vectorItem, startPeriod);
                            }
                            case 2: {
                                return CashflowSingleDao.this.combinDataForSupplementaryItem(ctx, cashFlowFilterPara, vectorItem);
                            }
                        }
                        return vectorItem;
                    }
                });
                futureList.add(future);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        Future<Vector> future = executorService.submit(new Callable<Vector>(){

            @Override
            public Vector call() throws Exception {
                try {
                    return CashflowSingleDao.this.getAdditionOfCash(ctx, cashFlowFilterPara);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                    throw new RuntimeException(e);
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                    throw new RuntimeException(e);
                }
            }
        });
        futureList.add(future);
        return futureList;
    }

    private List<Future<Vector>> doSelectCashflowAsyncByJDK8(Context ctx, CashFlowFilterPara cashFlowFilterPara, Map initMap, PeriodInfo startPeriod, int yearFrom, int monthFrom, boolean needCombineValue) {
        List<Integer> cashFlowItemTypes = Arrays.asList(0, 1, 2);
        ArrayList<Future<Vector>> futureList = new ArrayList<Future<Vector>>();
        ExecutorService executorService = this.getExecutorService(true);
        for (int cashFlowItemType : cashFlowItemTypes) {
            CompletionStage future = CompletableFuture.supplyAsync(() -> {
                try {
                    Vector vectorItem = this.selectDataFromDB(ctx, cashFlowFilterPara, cashFlowItemType);
                    if (cashFlowItemType == 0) {
                        this.sortCashFlowRecord(vectorItem, cashFlowFilterPara.getLevel());
                    }
                    return vectorItem;
                }
                catch (BOSException | EASBizException e) {
                    logger.error((Object)e);
                    throw new RuntimeException(e);
                }
            }, executorService).thenCombineAsync(CompletableFuture.supplyAsync(() -> {
                try {
                    return this.getSumAmountMap2(ctx, cashFlowFilterPara, cashFlowItemType, yearFrom, monthFrom);
                }
                catch (BOSException | EASBizException e) {
                    logger.error((Object)e);
                    throw new RuntimeException(e);
                }
            }, executorService), (vectorItem, sumMap) -> {
                this.combineSumMap((Vector)vectorItem, (Map)sumMap, cashFlowFilterPara);
                if (needCombineValue) {
                    this.combineInitMap((Vector)vectorItem, initMap, cashFlowFilterPara);
                }
                try {
                    switch (cashFlowItemType) {
                        case 0: {
                            return this.combinDataForPrimaryItem(ctx, (Vector)vectorItem, cashFlowFilterPara);
                        }
                        case 1: {
                            return this.combinDataForSecondaryItem(ctx, cashFlowFilterPara, (Vector)vectorItem, startPeriod);
                        }
                        case 2: {
                            return this.combinDataForSupplementaryItem(ctx, cashFlowFilterPara, (Vector)vectorItem);
                        }
                    }
                    return vectorItem;
                }
                catch (BOSException | EASBizException e) {
                    logger.error((Object)e);
                    throw new RuntimeException(e);
                }
            }, (Executor)executorService);
            futureList.add((Future<Vector>)((Object)future));
        }
        CompletableFuture<Vector> future = CompletableFuture.supplyAsync(() -> {
            try {
                return this.getAdditionOfCash(ctx, cashFlowFilterPara);
            }
            catch (BOSException | EASBizException e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
        }, executorService);
        futureList.add(future);
        return futureList;
    }

    private Map getInitAmountMap(Context ctx, CashFlowFilterPara cashFlowFilterPara) throws BOSException, EASBizException {
        String itemFilterSql = cashFlowFilterPara.getItemFilterSql();
        boolean isClose = GLFlagFactory.getLocalInstance(ctx).getCashflowInitClosed(this.selectedCompany.getId().toString());
        if (!isClose) {
            return Collections.EMPTY_MAP;
        }
        String amountField = null;
        String currencyId = cashFlowFilterPara.getCurrencyId();
        boolean isGlCurrency = currencyId.equals(this.getGeneralLocalCurrency());
        boolean isGLRptCurrency = currencyId.equals(this.getGeneralReportCurrency());
        amountField = isGlCurrency ? "FLocalAmount" : (isGLRptCurrency ? "FReportingAmount" : "FOriginalAmount");
        StringBuffer sql = new StringBuffer(512);
        ArrayList<String> param = new ArrayList<String>();
        sql.append(" select FID,FName,FAsstID,FCashType,FCashItemId,sum(FSum) as FSum from ( \n");
        sql.append(" select cfi2.fid as FID, null as FName,null as FAsstID, 1 as FCashType,cfin.FCashflowItemID as FCashItemId,\n");
        sql.append(" cfin.FSum as FSum from ");
        sql.append(" T_BD_CashFlowItem cfi1 ");
        sql.append(" inner join T_BD_CashFlowItem cfi2 ");
        sql.append(" on (charindex(cfi2.FLongNumber||'!',cfi1.FLongNumber) = 1 ");
        sql.append(" or cfi2.FLongNumber=cfi1.FLongNumber) ");
        sql.append(" left outer join (");
        sql.append("select cfin.FCashflowItemID,cfin.");
        sql.append(amountField);
        sql.append(" as FSum");
        sql.append(" from T_GL_CashflowInit cfin \n");
        sql.append(" where cfin.FCompanyID = ? \n");
        param.add(this.selectedCompany.getId().toString());
        if (itemFilterSql != null) {
            sql.append(" and cfin.FCashflowItemID in ( ").append(itemFilterSql).append(" ) ");
        }
        if (!isGlCurrency && !isGLRptCurrency) {
            sql.append(" and cfin.FCurrencyID = ? \r\n");
            param.add(currencyId);
        }
        sql.append(" )as cfin");
        sql.append(" on cfin.FCashflowItemID = cfi1.FID");
        boolean isAsst = cashFlowFilterPara.isDisplayAsst();
        if (isAsst) {
            boolean isAstClosed = GLFlagFactory.getLocalInstance(ctx).getCashflowGrpAsstClosed(this.selectedCompany.getId().toString());
            String amount = isAstClosed ? "asst." + amountField : "0";
            StringBuffer asstSql = new StringBuffer();
            asstSql.append(" union all \n");
            asstSql.append(" select init.FCashflowItemID as FID, \n");
            asstSql.append(" hg.FLongNameGroup_l2 as FName, asst.FAssistGrpID as FAsstID, asst.FType as FCashType,init.FCashflowItemID, \n");
            asstSql.append(amount);
            asstSql.append(" as FSum \n");
            asstSql.append(" from T_GL_CashflowGrpAsst as asst \n");
            asstSql.append(" left outer join T_GL_CashflowInit as init \n");
            asstSql.append(" on init.FID = asst.FCflowInitID \n");
            asstSql.append(" left outer join t_bd_assistanthg hg \n");
            asstSql.append(" on asst.FAssistGrpID = hg.fid \n");
            asstSql.append(" where init.FCompanyID = ? \n");
            if (itemFilterSql != null) {
                asstSql.append(" and init.FCashflowItemID in ( ").append(itemFilterSql).append(" ) ");
            }
            param.add(this.selectedCompany.getId().toString());
            sql.append(asstSql);
        }
        sql.append(" ) as A where FCashItemId=FID group by FID,FName,FAsstID,FCashType,FCashItemId having sum(FSum)<>0");
        HashMap<String, MapParam> map = new HashMap<String, MapParam>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        try {
            while (rs.next()) {
                String FID = rs.getString(1);
                String FName = rs.getString(2);
                String FAsstID = rs.getString(3);
                CashflowTypeEnum FCashType = CashflowTypeEnum.getEnum((int)rs.getInt(4));
                BigDecimal FAmount = rs.getBigDecimal(6);
                if (FID == null || FAmount == null) continue;
                MapParam m = new MapParam();
                m.FID = FID;
                m.FName = FName;
                m.FAsstID = FAsstID;
                m.FCashType = FCashType;
                m.FAmount = FAmount;
                String key = FAsstID == null ? FID : FID + FAsstID + FCashType;
                map.put(key, m);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return map;
    }

    private Vector selectDataFromDB(Context ctx, CashFlowFilterPara cashFlowFilterPara, int itemType) throws BOSException, EASBizException {
        boolean isAsst = cashFlowFilterPara.isDisplayAsst();
        ObjectUuidPK comPk = new ObjectUuidPK(this.selectedCompany.getId());
        RptParams pp = new RptParams();
        pp.setObject("GL_004", (Object)comPk);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap allParam = pc.getParamHashMap(new HashMap(pp.toMap()));
        String ssistItemName = "flongnamegroup_l2";
        List<String> periodIdList = com.kingdee.eas.fi.gl.CashFlowUtils.getPeriodIdByNumberRange(ctx, this.selectedCompany.getId().toString(), cashFlowFilterPara.getYearFrom() * 100 + cashFlowFilterPara.getMonthFrom(), cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo());
        String periodIdsStr = null;
        if (periodIdList != null && periodIdList.size() > 0) {
            periodIdsStr = com.kingdee.eas.fi.gl.CashFlowUtils.buildIn(periodIdList);
        }
        if (allParam.get("GL_004") != null && Boolean.valueOf(allParam.get("GL_004").toString()).booleanValue()) {
            ssistItemName = "fdisplaynamegroup_l2";
        }
        Vector<DBParam> vec = new Vector<DBParam>();
        StringBuffer sbFName = new StringBuffer("cfi2.FName_");
        String strLocal = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sbFName.append(strLocal);
        StringBuffer sbSql = new StringBuffer("select cfi2.fid,cfi2.fid as FKey,null as FAsstID,cfi2.fnumber,cfi2.ftype,cfi2.FIsProfit,cfi2.FLongNumber FLongNumber,");
        sbSql.append(sbFName);
        sbSql.append(" FName,cfi2.FLevel FLevel,cfi2.FDirection FDirection,cfi2.fisenable fisenable,cfi2.FisLeaf FisLeaf");
        if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
            sbSql.append(",sum(cfr.FLocalAmount");
        } else if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralReportCurrency())) {
            sbSql.append(",sum(cfr.FReportingAmount *(case cfi1.FDirection when 2 then -1 else 1 end) * (case cfi2.FDirection when 2 then -1 else 1 end)");
        } else {
            sbSql.append(",sum(cfr.FOriginalAmount * (case cfi1.FDirection when 2 then -1 else 1 end) * (case cfi2.FDirection when 2 then -1 else 1 end)");
        }
        if (itemType == 0) {
            sbSql.append(" * cfr.FPrimaryCoeffient");
        } else if (itemType == 1) {
            sbSql.append(" * cfr.FSupplementaryCoeffient ");
        }
        sbSql.append(") FAmount");
        sbSql.append(" , cfi2.FIsExChange FIsExChange");
        sbSql.append(",1  fcashType,n'' flongnamegroup");
        sbSql.append(" from T_BD_CashFlowItem cfi1 \r\n");
        sbSql.append(" inner join T_BD_CashFlowItem cfi2 \r\n ");
        sbSql.append(" on (charindex(cfi2.FLongNumber||'!',cfi1.FLongNumber) = 1 ");
        sbSql.append("  or cfi2.FLongNumber=cfi1.FLongNumber) \r\n");
        sbSql.append(" left outer join \r\n");
        sbSql.append(" (");
        if (itemType == 0) {
            sbSql.append(" select cfr.FPrimaryItemID,");
        } else if (itemType == 1) {
            sbSql.append(" select cfr.FSupplementaryItemID, ");
        } else {
            sbSql.append(" select cfr.FfullInfoItemID, ");
        }
        if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
            sbSql.append("cfr.FLocalAmount,");
        } else if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralReportCurrency())) {
            sbSql.append("cfr.FReportingAmount,");
        } else {
            sbSql.append("cfr.FOriginalAmount,");
        }
        if (itemType == 0) {
            sbSql.append("cfr.FPrimaryCoeffient \r\n");
        } else {
            sbSql.append("cfr.FPrimaryCoeffient,cfr.FSupplementaryCoeffient \r\n");
        }
        sbSql.append(" from T_GL_CashflowRecord cfr join T_GL_Voucher voucher on cfr.FVoucherID = voucher.FID ");
        if (cashFlowFilterPara.isOldVersion()) {
            sbSql.append(" join T_GL_VoucherEntry ve on cfr.FEntryID = ve.FID ");
        }
        sbSql.append("\r\n");
        sbSql.append(" INNER JOIN t_bd_accountview av ON av.fid = cfr.faccountid ");
        sbSql.append(" where voucher.FCompanyID = ? \r\n");
        if (cashFlowFilterPara.isTermOrDate()) {
            sbSql.append(" AND ");
            if (periodIdsStr != null) {
                sbSql.append(" voucher.FPeriodID in " + periodIdsStr + "\r\n");
            } else {
                sbSql.append(" 1=1  \r\n");
            }
        } else {
            sbSql.append(" and voucher.FBookedDate >= ? \r\n");
            sbSql.append(" and voucher.FBookedDate <= ? \r\n");
        }
        if (this.isLocalOrReportCurrency(cashFlowFilterPara.getCurrencyId())) {
            if (cashFlowFilterPara.isOldVersion()) {
                sbSql.append(" and ve.FCurrencyID = ? \r\n");
            } else {
                sbSql.append(" and cfr.FCurrencyID = ? \r\n");
            }
        }
        sbSql.append(" AND av.faccounttableid = ? \r\n");
        sbSql.append(" and voucher.FBizStatus in(");
        sbSql.append(5);
        if (cashFlowFilterPara.isAllVoucher()) {
            sbSql.append(",");
            sbSql.append(3);
            sbSql.append(",");
            sbSql.append(1);
        }
        sbSql.append(")");
        String itemFilterSql = cashFlowFilterPara.getItemFilterSql();
        if (itemType == 0) {
            if (!cashFlowFilterPara.isOldVersion()) {
                sbSql.append(" and cfr.FPrimaryItemID is not null ");
            }
            if (itemFilterSql != null) {
                sbSql.append(" and cfr.FPrimaryItemID in ( ").append(itemFilterSql).append(" ) ");
            }
            sbSql.append(" )cfr \r\n on cfr.FPrimaryItemID = cfi1.FID \r\n");
        } else if (itemType == 1) {
            if (!cashFlowFilterPara.isOldVersion()) {
                sbSql.append(" and cfr.FSupplementaryItemID is not null ");
            }
            if (itemFilterSql != null) {
                sbSql.append(" and cfr.FSupplementaryItemID in ( ").append(itemFilterSql).append(" ) ");
            }
            sbSql.append(" )cfr \r\n on cfr.FSupplementaryItemID = cfi1.FID \r\n");
        } else {
            if (!cashFlowFilterPara.isOldVersion()) {
                sbSql.append(" and cfr.FfullInfoItemID is not null ");
            }
            if (itemFilterSql != null) {
                sbSql.append(" and cfr.FfullInfoItemID in ( ").append(itemFilterSql).append(" ) ");
            }
            sbSql.append(" )cfr \r\n on cfr.FfullInfoItemID = cfi1.FID \r\n");
        }
        sbSql.append("where cfi2.FType = ? \r\n");
        sbSql.append(" and cfi2.FLevel <= ? \r\n");
        if (itemFilterSql != null) {
            sbSql.append(" and cfi2.fid in ( ").append(itemFilterSql).append(" ) ");
        }
        sbSql.append(" group by cfi2.FLongNumber,cfi2.FName_");
        sbSql.append(strLocal);
        sbSql.append(",cfi2.FLevel,cfi2.FDirection,cfi2.fisenable,cfi2.FisLeaf,cfi2.FIsProfit,cfi2.fid,cfi2.fnumber,cfi2.ftype,cfi2.FIsExchange \r\n");
        if (isAsst) {
            StringBuffer asstSql = new StringBuffer();
            String amountField = null;
            amountField = cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency()) ? "cfr.FLocalAmount" : (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralReportCurrency()) ? "cfr.FReportingAmount" : "cfr.FOriginalAmount");
            asstSql.append("union all (select cfi2.fid, cfi2.fid || hg.fid  as FKey,");
            asstSql.append(" hg.fid as FAsstID,cfi2.fnumber,cfi2.ftype,cfi2.FIsProfit,cfi2.FLongNumber FLongNumber,n' ' FName,");
            asstSql.append("\n   cfi2.FLevel FLevel,cfi2.FDirection FDirection,cfi2.fisenable fisenable,cfi2.FisLeaf FisLeaf,sum(");
            asstSql.append(amountField);
            asstSql.append(" * cfr.FPrimaryCoeffient) FAmount , cfi2.FIsExChange FIsExChange,cfr.ftype fcashtype,");
            asstSql.append("hg.").append(ssistItemName).append(" flongnamegroup");
            asstSql.append("\n from  T_BD_CashFlowItem cfi2 ");
            asstSql.append("\n inner join");
            asstSql.append(" ( select cfr.FPrimaryItemID,cfr.FLocalAmount,cfr.FOriginalAmount,cfr.FReportingAmount,cfr.FPrimaryCoeffient,cfr.ftype,cfr.fassgrpid  from T_GL_CashflowRecord cfr join T_GL_Voucher voucher on cfr.FVoucherID = voucher.FID    join T_BD_Period period on voucher.FPeriodID = period.FID ");
            asstSql.append(" join T_GL_VoucherEntry ve on cfr.FEntryID = ve.FID ");
            asstSql.append(" INNER JOIN t_bd_accountview av ON av.fid = cfr.faccountid ");
            asstSql.append(" where voucher.FCompanyID = ? \r\n");
            asstSql.append(" AND av.faccounttableid = ? \r\n");
            if (cashFlowFilterPara.isTermOrDate()) {
                asstSql.append(" AND ");
                if (periodIdsStr != null) {
                    asstSql.append(" voucher.FPeriodID in " + periodIdsStr + "\r\n");
                } else {
                    asstSql.append(" 1=1  \r\n");
                }
            } else {
                asstSql.append(" and voucher.FBookedDate >= ? \r\n");
                asstSql.append(" and voucher.FBookedDate <= ? \r\n");
            }
            if (this.isLocalOrReportCurrency(cashFlowFilterPara.getCurrencyId())) {
                asstSql.append(" and ve.FCurrencyID = ? \r\n");
            }
            if (itemFilterSql != null) {
                asstSql.append(" and cfr.FPrimaryItemID in ( ").append(itemFilterSql).append(" ) ");
            }
            asstSql.append(" and voucher.FBizStatus in(");
            asstSql.append(5);
            if (cashFlowFilterPara.isAllVoucher()) {
                asstSql.append(",");
                asstSql.append(3);
                asstSql.append(",");
                asstSql.append(1);
            }
            asstSql.append("  ))cfr ");
            asstSql.append(" on cfr.FPrimaryItemID = cfi2.FID ");
            asstSql.append("left join t_bd_assistanthg hg on cfr.fassgrpid=hg.fid \n");
            asstSql.append("where ");
            if (!cashFlowFilterPara.isCfImportAssist()) {
                asstSql.append(" cfi2.fisenable=1 and ");
            }
            asstSql.append(" cfi2.fisleaf=1 and cfi2.flevel>1  and cfi2.FType = ? \r\n");
            asstSql.append(" and cfi2.FLevel <= ? \r\n");
            if (itemFilterSql != null) {
                asstSql.append(" and cfi2.fid in ( ").append(itemFilterSql).append(" ) ");
            }
            asstSql.append("group by cfi2.FLongNumber,cfi2.FName_l2,cfi2.FLevel,cfi2.FDirection,cfi2.fisenable,cfi2.FisLeaf,cfi2.FIsProfit,cfi2.fid,hg.fid,cfi2.fnumber,cfi2.ftype,cfi2.FIsExchange ");
            asstSql.append(",cfr.ftype,hg.").append(ssistItemName);
            asstSql.append(" having sum(" + amountField + " * cfr.FPrimaryCoeffient) <> 0 ");
            asstSql.append(")");
            sbSql.append(asstSql);
        }
        sbSql.append("\r\n order by FLongNumber,fcashtype \r\n");
        ArrayList<String> param = new ArrayList<String>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sbSql.toString());
            int index = 1;
            ps.setString(index++, this.selectedCompany.getId().toString());
            param.add(this.selectedCompany.getId().toString());
            if (!cashFlowFilterPara.isTermOrDate()) {
                ps.setDate(index++, new Date(cashFlowFilterPara.getDateFrom().getTime()));
                ps.setDate(index++, new Date(cashFlowFilterPara.getDateTo().getTime()));
            }
            if (this.isLocalOrReportCurrency(cashFlowFilterPara.getCurrencyId())) {
                ps.setString(index++, cashFlowFilterPara.getCurrencyId());
            }
            ps.setString(index++, cashFlowFilterPara.getAccountTabel().getId().toString());
            ps.setInt(index++, itemType);
            short level = cashFlowFilterPara.getLevel();
            if (level == 1) {
                ps.setShort(index++, (short)2);
            } else {
                ps.setShort(index++, level);
            }
            if (isAsst) {
                ps.setString(index++, this.selectedCompany.getId().toString());
                ps.setString(index++, cashFlowFilterPara.getAccountTabel().getId().toString());
                if (!cashFlowFilterPara.isTermOrDate()) {
                    ps.setDate(index++, new Date(cashFlowFilterPara.getDateFrom().getTime()));
                    ps.setDate(index++, new Date(cashFlowFilterPara.getDateTo().getTime()));
                }
                if (!cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency()) && !cashFlowFilterPara.getCurrencyId().equals(this.getGeneralReportCurrency())) {
                    ps.setString(index++, cashFlowFilterPara.getCurrencyId());
                }
                ps.setInt(index++, itemType);
                if (level == 1) {
                    ps.setShort(index++, (short)2);
                } else {
                    ps.setShort(index++, level);
                }
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                DBParam p = new DBParam();
                p.FID = rs.getString("FKey");
                p.FLevel = new Integer(rs.getInt("FLevel"));
                p.FLOngNumber = rs.getString("FLongNumber");
                p.FName = rs.getString("FName");
                p.FDirection = new Integer(rs.getInt("FDirection"));
                BigDecimal amount = rs.getBigDecimal("FAmount");
                if (rs.getInt("FType") == 2 && rs.getInt("FLevel") == 1 && rs.getInt("FisLeaf") == 0) {
                    amount = null;
                }
                p.FAmount = amount == null ? GlUtils.zero : amount;
                p.FIsEnable = new Integer(rs.getInt("FIsEnable"));
                p.FIsLeaf = new Integer(rs.getInt("FisLeaf"));
                p.FIsProfit = new Boolean(rs.getBoolean("FIsProfit"));
                CashFlowItemInfo info = new CashFlowItemInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setName(p.FName);
                info.setNumber(rs.getString("FNumber"));
                info.setType(CashFlowItemType.getEnum((int)rs.getInt("FType")));
                info.setIsProfit(p.FIsProfit.booleanValue());
                info.setLongNumber(p.FLOngNumber);
                p.itemInfo = info;
                p.FIsExchange = new Boolean(rs.getBoolean("FIsExChange"));
                if (isAsst) {
                    p.FCashType = CashflowTypeEnum.getEnum((int)rs.getInt("fcashType"));
                    p.FLongNameGroup = rs.getString("flongnamegroup");
                    if (p.FLongNameGroup != null) {
                        p.FLongNameGroup = p.FLongNameGroup.replaceAll("_!", " ");
                        p.FLongNameGroup = VoucherUtil.decodeSplitFlag(p.FLongNameGroup);
                    }
                    p.FAsstID = rs.getString("FAsstID");
                    p.FID = (p.FID == null ? rs.getString("FID") : p.FID) + p.FCashType;
                }
                vec.addElement(p);
            }
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return vec;
    }

    private Vector sortCashFlowRecord(Vector vec, short level) {
        Vector<DBParam> vecInAndOut = new Vector<DBParam>();
        Vector<DBParam> vecIn = new Vector<DBParam>();
        Vector<DBParam> vecOut = new Vector<DBParam>();
        Vector<int[]> vecIndex = new Vector<int[]>();
        int[] firstIndex = new int[]{0, vec.size() - 1};
        vecIndex.addElement(firstIndex);
        for (short i = 0; i < level; i = (short)(i + 1)) {
            int indexSize = vecIndex.size();
            Vector<int[]> tmpIndex = new Vector<int[]>();
            for (int j = 0; j < indexSize; ++j) {
                int[] index = (int[])vecIndex.elementAt(j);
                int begin = index[0];
                int end = index[1];
                int iDirection = 0;
                vecInAndOut.removeAllElements();
                vecIn.removeAllElements();
                vecOut.removeAllElements();
                block7: for (int k = begin; k <= end; ++k) {
                    DBParam p = (DBParam)vec.elementAt(k);
                    int thisLevel = p.FLevel;
                    if (thisLevel == i) {
                        iDirection = p.FDirection;
                    }
                    switch (iDirection) {
                        case 0: {
                            vecInAndOut.addElement(p);
                            if (thisLevel != level && k != end) continue block7;
                            int[] thisIndex = new int[2];
                            thisIndex[0] = k + 1;
                            if (k != begin && k != end) {
                                if (!tmpIndex.isEmpty()) {
                                    ((int[])tmpIndex.lastElement())[1] = k - 1;
                                }
                            } else if (k == end && !tmpIndex.isEmpty()) {
                                ((int[])tmpIndex.lastElement())[1] = k;
                            }
                            if (k == end) continue block7;
                            tmpIndex.addElement(thisIndex);
                            continue block7;
                        }
                        case 1: {
                            vecIn.addElement(p);
                            continue block7;
                        }
                        case 2: {
                            vecOut.addElement(p);
                        }
                    }
                }
                int seq = begin;
                int sizeInAndOut = vecInAndOut.size();
                for (i = 0; i < sizeInAndOut; i = (short)(i + 1)) {
                    vec.setElementAt(vecInAndOut.elementAt(i), seq++);
                }
                int sizeIn = vecIn.size();
                for (i = 0; i < sizeIn; i = (short)(i + 1)) {
                    vec.setElementAt(vecIn.elementAt(i), seq++);
                }
                int sizeOut = vecOut.size();
                for (i = 0; i < sizeOut; i = (short)(i + 1)) {
                    vec.setElementAt(vecOut.elementAt(i), seq++);
                }
            }
            vecIndex = tmpIndex;
        }
        return vec;
    }

    private void combineSumMap(Vector vec, Map map, CashFlowFilterPara cashFlowFilterPara) {
        if (vec == null || vec.size() < 1 || map == null || map.size() < 1) {
            return;
        }
        if (cashFlowFilterPara.isDisplayAsst()) {
            this.combineAsstMap(vec, map, cashFlowFilterPara);
        }
        int l = vec.size();
        for (int i = 0; i < l; ++i) {
            DBParam p = (DBParam)vec.elementAt(i);
            if (map.get(p.FID) == null) continue;
            p.FSum = ((MapParam)map.get((Object)p.FID)).FAmount;
            if (p.FDirection != 2) continue;
            p.FSum = p.FSum.multiply(new BigDecimal(-1));
        }
    }

    private void combineAsstMap(Vector vec, Map map, CashFlowFilterPara cashFlowFilterPara) {
        boolean isAsst = cashFlowFilterPara.isDisplayAsst();
        if (isAsst) {
            HashMap candidateMap = new HashMap();
            Collection coll = map.values();
            Iterator it = coll.iterator();
            boolean isCandidate = false;
            while (it.hasNext()) {
                List<MapParam> list;
                MapParam mp = (MapParam)it.next();
                if (mp.FIsEnable != null) {
                    isCandidate = mp.FIsEnable == 1 && !CashflowTypeEnum.NONE.equals((Object)mp.FCashType);
                } else {
                    boolean bl = isCandidate = !CashflowTypeEnum.NONE.equals((Object)mp.FCashType);
                }
                if (isCandidate && candidateMap.containsKey(mp.FID)) {
                    list = (List)candidateMap.get(mp.FID);
                    list.add(mp);
                    continue;
                }
                if (!isCandidate) continue;
                list = new ArrayList<MapParam>();
                list.add(mp);
                candidateMap.put(mp.FID, list);
            }
            HashMap<String, Integer> excludeMap = new HashMap<String, Integer>();
            HashMap<String, DBParam> acceptMap = new HashMap<String, DBParam>();
            int l = vec.size();
            for (int i = 0; i < l; ++i) {
                DBParam p = (DBParam)vec.elementAt(i);
                if (p.FIsEnable == 1 && !CashflowTypeEnum.NONE.equals((Object)p.FCashType)) {
                    excludeMap.put(p.FID, new Integer(i));
                    continue;
                }
                acceptMap.put(p.FID, p);
            }
            Vector vecClone = (Vector)vec.clone();
            int l2 = vecClone.size();
            for (int i = 0; i < l2; ++i) {
                DBParam p = (DBParam)vecClone.elementAt(i);
                List list = (List)candidateMap.get(p.FID);
                if (list == null) continue;
                String key = null;
                for (int j = 0; j < list.size(); ++j) {
                    MapParam mp = (MapParam)list.get(j);
                    String string = key = mp.FAsstID == null ? mp.FID + mp.FCashType : mp.FID + mp.FAsstID + mp.FCashType;
                    if (excludeMap.containsKey(key)) continue;
                    DBParam ps = (DBParam)acceptMap.get(mp.FID);
                    int index = vec.indexOf(ps);
                    DBParam pi = new DBParam();
                    pi.copy(ps);
                    pi.FID = key;
                    pi.FAsstID = mp.FAsstID;
                    pi.FAmount = InitHelp.zero;
                    pi.FSum = InitHelp.zero;
                    pi.FName = "";
                    pi.FLongNameGroup = mp.FName;
                    pi.FCashType = mp.FCashType;
                    vec.insertElementAt(pi, index + 1);
                }
            }
        }
    }

    private Map getSumAmountMap(Context ctx, CashFlowFilterPara cashFlowFilterPara, int itemType, int startYear, int startPeriod) throws BOSException, EASBizException {
        String itemFilterSql = cashFlowFilterPara.getItemFilterSql();
        List<String> periodIdList = com.kingdee.eas.fi.gl.CashFlowUtils.getPeriodIdByNumberRange(ctx, this.selectedCompany.getId().toString(), startYear * 100 + startPeriod, cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo());
        String periodIdsStr = null;
        if (periodIdList != null && periodIdList.size() > 0) {
            periodIdsStr = com.kingdee.eas.fi.gl.CashFlowUtils.buildIn(periodIdList);
        }
        if (!cashFlowFilterPara.isTermOrDate()) {
            return Collections.EMPTY_MAP;
        }
        String idFiled = null;
        idFiled = itemType == 0 ? "cfr.FPrimaryItemID" : (itemType == 1 ? "cfr.FSupplementaryItemID" : "cfr.FfullInfoItemID");
        String amountField = null;
        String currencyId = cashFlowFilterPara.getCurrencyId();
        boolean isGlCurrency = currencyId.equals(this.getGeneralLocalCurrency());
        boolean isGLRptCurrency = currencyId.equals(this.getGeneralReportCurrency());
        amountField = isGlCurrency ? "cfr.FLocalAmount" : (isGLRptCurrency ? "cfr.FReportingAmount" : "cfr.FOriginalAmount");
        String rateField = null;
        rateField = itemType == 0 ? "cfr.FPrimaryCoeffient" : (itemType == 1 ? "cfr.FSupplementaryCoeffient" : "1");
        StringBuffer sql = new StringBuffer(512);
        ArrayList<Object> param = new ArrayList<Object>();
        sql.append(" select FID,FName,FAsstID,FCashType,sum(FAmount) as FAmount,FIsEnable from ( \n");
        sql.append(" select cfi2.FID as FID, to_char(null) as FName, to_char(null) as FAsstID, to_char('1') as FCashType, ");
        sql.append(" case when cfr.FAmount is null then 0 else cfr.FAmount*(case when cfi1.FDirection=2 then -1 else 1 end) end as FAmount,cfi2.fisenable from ");
        sql.append(" T_BD_CashFlowItem cfi1 ");
        sql.append(" inner join T_BD_CashFlowItem cfi2 ");
        sql.append(" on (charindex(cfi2.FLongNumber||'!',cfi1.FLongNumber) = 1 ");
        sql.append(" or cfi2.FLongNumber=cfi1.FLongNumber) ");
        sql.append(" left outer join (");
        sql.append(" select ");
        sql.append(idFiled);
        sql.append(",(");
        sql.append(amountField);
        sql.append("*");
        sql.append(rateField);
        sql.append(") as FAmount");
        sql.append(" from T_GL_CashflowRecord cfr \n");
        sql.append(" join T_GL_Voucher voucher on cfr.FVoucherID = voucher.FID \n");
        if (periodIdsStr == null) {
            sql.append(" join T_BD_Period period on voucher.FPeriodID = period.FID \n");
        }
        sql.append(" INNER JOIN t_bd_accountview av ON av.fid = cfr.faccountid \n");
        if (!isGlCurrency && !isGLRptCurrency && cashFlowFilterPara.isOldVersion()) {
            sql.append(" join T_GL_VoucherEntry ve on cfr.FEntryID = ve.FID \n");
        }
        sql.append(" where voucher.FCompanyID = ? \n");
        param.add(this.selectedCompany.getId().toString());
        sql.append(" AND av.faccounttableid = ? \n");
        param.add(cashFlowFilterPara.getAccountTabel().getId().toString());
        if (itemFilterSql != null) {
            sql.append(" and " + idFiled + " in ( ").append(itemFilterSql).append(" ) ");
        }
        sql.append(" AND ");
        if (periodIdsStr != null) {
            sql.append(" voucher.FPeriodID in " + periodIdsStr + "\r\n");
        } else {
            int[] periodRange = new int[]{startYear * 100 + startPeriod, cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo()};
            sql.append(SQLUtil.getPeriodCondition(" period.FNumber", periodRange));
        }
        if (!isGlCurrency && !isGLRptCurrency) {
            if (cashFlowFilterPara.isOldVersion()) {
                sql.append(" and ve.FCurrencyID = ? \r\n");
            } else {
                sql.append(" and cfr.FCurrencyID = ? \r\n");
            }
            param.add(currencyId);
        }
        sql.append(" and voucher.FBizStatus in(");
        sql.append(5);
        if (cashFlowFilterPara.isAllVoucher()) {
            sql.append(",");
            sql.append(3);
            sql.append(",");
            sql.append(1);
        }
        sql.append(") )as cfr");
        sql.append(" on ");
        sql.append(idFiled);
        sql.append(" = cfi1.FID ");
        sql.append(" where ");
        sql.append(" cfi2.FType = ? \n");
        param.add(new Integer(itemType));
        sql.append(" and cfi2.FLevel <= ? \n");
        short level = cashFlowFilterPara.getLevel();
        int lv = level == 1 ? 2 : (int)level;
        param.add(new Integer(lv));
        boolean isAsst = cashFlowFilterPara.isDisplayAsst();
        if (isAsst) {
            ObjectUuidPK comPk = new ObjectUuidPK(this.selectedCompany.getId());
            RptParams pp = new RptParams();
            pp.setObject("GL_004", (Object)comPk);
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            HashMap allParam = pc.getParamHashMap(new HashMap(pp.toMap()));
            String ssistItemName = "flongnamegroup_" + ctx.getLocale().toString();
            if (allParam.get("GL_004") != null && Boolean.valueOf(allParam.get("GL_004").toString()).booleanValue()) {
                ssistItemName = "fdisplaynamegroup_" + ctx.getLocale().toString();
            }
            StringBuffer asstSql = new StringBuffer(512);
            asstSql.append(" union all \n");
            asstSql.append(" select cfi2.fid as FID,replace(hg." + ssistItemName + ",'_!',' ') as FName,\n");
            asstSql.append(" hg.fid FAsstID, \n");
            asstSql.append(" to_char((case when cfr.FType =3 then 3 else 2 end)) as FCashType, \n");
            asstSql.append(" case when cfr.FAmount is null then 0 else cfr.FAmount*(case when cfi2.FDirection=2 then -1 else 1 end) end as FAmount, \n");
            asstSql.append(" cfi2.fisenable from \n");
            asstSql.append(" T_BD_CashFlowItem cfi2 ");
            asstSql.append(" left outer join (");
            asstSql.append(" select cfr.FAssgrpID,cfr.FType, \n");
            asstSql.append(idFiled);
            asstSql.append(",(");
            asstSql.append(amountField);
            asstSql.append("*");
            asstSql.append(rateField);
            asstSql.append(") as FAmount");
            asstSql.append(" from T_GL_CashflowRecord cfr \n");
            asstSql.append(" join T_GL_Voucher voucher on cfr.FVoucherID = voucher.FID \n");
            asstSql.append(" join T_BD_Period period on voucher.FPeriodID = period.FID \n");
            asstSql.append(" join T_GL_VoucherEntry ve on cfr.FEntryID = ve.FID \n");
            asstSql.append(" INNER JOIN t_bd_accountview av ON av.fid = cfr.faccountid \n");
            asstSql.append(" where voucher.FCompanyID = ? \n");
            param.add(this.selectedCompany.getId().toString());
            asstSql.append(" AND av.faccounttableid = ? \n");
            param.add(cashFlowFilterPara.getAccountTabel().getId().toString());
            if (itemFilterSql != null) {
                asstSql.append(" and " + idFiled + " in ( ").append(itemFilterSql).append(" ) ");
            }
            asstSql.append(" and ");
            if (periodIdsStr != null) {
                asstSql.append(" voucher.FPeriodID in " + periodIdsStr + "\r\n");
            } else {
                int[] periodRange = new int[]{startYear * 100 + startPeriod, cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo()};
                asstSql.append(SQLUtil.getPeriodCondition(" period.FNumber", periodRange));
            }
            if (!isGlCurrency && !isGLRptCurrency) {
                asstSql.append(" and ve.FCurrencyID = ? \r\n");
                param.add(currencyId);
            }
            asstSql.append(" and voucher.FBizStatus in(");
            asstSql.append(5);
            if (cashFlowFilterPara.isAllVoucher()) {
                asstSql.append(",");
                asstSql.append(3);
                asstSql.append(",");
                asstSql.append(1);
            }
            asstSql.append("  ))cfr ");
            asstSql.append(" on " + idFiled + " = cfi2.FID ");
            asstSql.append(" left join t_bd_assistanthg hg on cfr.fassgrpid=hg.fid \n");
            asstSql.append(" where ");
            asstSql.append(" cfi2.fisenable=1 and ");
            asstSql.append(" cfi2.fisleaf=1 and cfi2.flevel>1  and cfi2.FType = ? \r\n");
            param.add(new Integer(itemType));
            asstSql.append(" and cfi2.FLevel <= ? \r\n");
            param.add(new Integer(lv));
            sql.append(asstSql);
        }
        sql.append(" ) as A group by FID,FName,FAsstID,FCashType,FIsEnable \r\n");
        sql.append(" having sum(FAmount) <> 0 \r\n");
        HashMap<String, MapParam> map = new HashMap<String, MapParam>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        try {
            while (rs.next()) {
                String FID = rs.getString(1);
                String FName = rs.getString(2);
                String FAsstID = rs.getString(3);
                CashflowTypeEnum FCashType = CashflowTypeEnum.getEnum((int)rs.getInt(4));
                BigDecimal FAmount = rs.getBigDecimal(5);
                if (FID == null || FAmount == null) continue;
                MapParam m = new MapParam();
                m.FID = FID;
                m.FName = FName;
                m.FAsstID = FAsstID;
                m.FCashType = FCashType;
                m.FAmount = FAmount;
                m.FIsEnable = new Integer(rs.getInt(6));
                String key = FAsstID == null ? FID + FCashType : FID + FAsstID + FCashType;
                map.put(key, m);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return map;
    }

    private Map getSumAmountMap2(Context ctx, final CashFlowFilterPara cashFlowFilterPara, final int itemType, int startYear, int startPeriod) throws BOSException, EASBizException {
        if (!cashFlowFilterPara.isTermOrDate()) {
            return Collections.EMPTY_MAP;
        }
        List<String> periodIdList = com.kingdee.eas.fi.gl.CashFlowUtils.getPeriodIdByNumberRange(ctx, this.selectedCompany.getId().toString(), startYear * 100 + startPeriod, cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo());
        if (periodIdList == null || periodIdList.size() < 4) {
            return this.getSumAmountMap(ctx, cashFlowFilterPara, itemType, startYear, startPeriod);
        }
        Map<String, MapParam> results = new HashMap();
        final boolean isGL004 = this.isGL004();
        if (this.isSupportForkJoinPool()) {
            ForkJoinPool forkJoinPool = (ForkJoinPool)this.getExecutorService(true);
            ArrayDeque<String> periodQueue = new ArrayDeque<String>(periodIdList);
            HashMap<String, Serializable> paramMap = new HashMap<String, Serializable>();
            paramMap.put("cashFlowFilterPara", cashFlowFilterPara);
            paramMap.put("itemType", Integer.valueOf(itemType));
            paramMap.put("isGL004", Boolean.valueOf(isGL004));
            ForkJoinTask submit = forkJoinPool.submit(new AmountMapSumTask(periodQueue, 3, paramMap));
            try {
                results = (Map)submit.get();
            }
            catch (InterruptedException interruptedException) {
                logger.error((Object)interruptedException);
                throw new RuntimeException(interruptedException);
            }
            catch (ExecutionException executionException) {
                logger.error((Object)executionException);
                throw new RuntimeException(executionException);
            }
        } else {
            List<String> periodGroup = this.getPeriodGroup(periodIdList, 3);
            ArrayList<Future<Map>> futures = new ArrayList<Future<Map>>();
            ExecutorService executorService = this.getExecutorService(false);
            for (final String string : periodGroup) {
                Future<Map> future = executorService.submit(new Callable<Map>(){

                    @Override
                    public Map call() throws Exception {
                        return CashflowSingleDao.this.doGetSubSumAmountMap(string, itemType, cashFlowFilterPara, isGL004);
                    }
                });
                futures.add(future);
            }
            for (Future future : futures) {
                try {
                    Map map = (Map)future.get();
                    for (String key : map.keySet()) {
                        MapParam m = (MapParam)map.get(key);
                        if (results.containsKey(key)) {
                            MapParam newMap = (MapParam)results.get(key);
                            newMap.FAmount = newMap.FAmount.add(m.FAmount);
                            continue;
                        }
                        results.put(key, m);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
        return results;
    }

    private boolean isSupportForkJoinPool() {
        String jdkVersion = System.getProperty("java.vm.specification.version");
        int versionCode = Integer.parseInt(jdkVersion.substring(jdkVersion.indexOf(".") + 1));
        return versionCode >= 7;
    }

    private boolean isGL004() throws BOSException, EASBizException {
        ObjectUuidPK comPk = new ObjectUuidPK(this.selectedCompany.getId());
        RptParams pp = new RptParams();
        pp.setObject("GL_004", (Object)comPk);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)this.ctx);
        HashMap allParam = pc.getParamHashMap(new HashMap(pp.toMap()));
        return allParam.get("GL_004") != null && Boolean.valueOf(allParam.get("GL_004").toString()) != false;
    }

    private Map doGetSubSumAmountMap(String periodIdsStr, int itemType, CashFlowFilterPara cashFlowFilterPara, boolean isGL004) throws BOSException {
        String idFiled = null;
        idFiled = itemType == 0 ? "cfr.FPrimaryItemID" : (itemType == 1 ? "cfr.FSupplementaryItemID" : "cfr.FfullInfoItemID");
        String amountField = null;
        boolean isGlCurrency = cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency());
        boolean isGLRptCurrency = cashFlowFilterPara.getCurrencyId().equals(this.getGeneralReportCurrency());
        amountField = isGlCurrency ? "cfr.FLocalAmount" : (isGLRptCurrency ? "cfr.FReportingAmount" : "cfr.FOriginalAmount");
        String rateField = null;
        rateField = itemType == 0 ? "cfr.FPrimaryCoeffient" : (itemType == 1 ? "cfr.FSupplementaryCoeffient" : "1");
        StringBuffer sql = new StringBuffer(512);
        ArrayList<Object> param = new ArrayList<Object>();
        sql.append(" select FID,FName,FAsstID,FCashType,sum(FAmount) as FAmount,FIsEnable from ( \n");
        sql.append(" select cfi2.FID as FID, to_char(null) as FName, to_char(null) as FAsstID, to_char('1') as FCashType, ");
        sql.append(" case when cfr.FAmount is null then 0 else cfr.FAmount *  (case cfi1.FDirection when 2 then -1 else 1 end) end as FAmount,cfi2.fisenable from ");
        sql.append(" T_BD_CashFlowItem cfi1 ");
        sql.append(" inner join T_BD_CashFlowItem cfi2 ");
        sql.append(" on (charindex(cfi2.FLongNumber||'!',cfi1.FLongNumber) = 1 ");
        sql.append(" or cfi2.FLongNumber=cfi1.FLongNumber) ");
        sql.append(" left outer join (");
        sql.append(" select ");
        sql.append(idFiled);
        sql.append(",(");
        sql.append(amountField);
        sql.append("*");
        sql.append(rateField);
        sql.append(") as FAmount");
        sql.append(" from T_GL_CashflowRecord cfr \n");
        sql.append(" join T_GL_Voucher voucher on cfr.FVoucherID = voucher.FID \n");
        sql.append(" INNER JOIN t_bd_accountview av ON av.fid = cfr.faccountid \n");
        if (!isGlCurrency && !isGLRptCurrency) {
            sql.append(" join T_GL_VoucherEntry ve on cfr.FEntryID = ve.FID \n");
        }
        sql.append(" where voucher.FCompanyID = ? \n");
        param.add(this.selectedCompany.getId().toString());
        if (cashFlowFilterPara.getItemFilterSql() != null) {
            sql.append(" and " + idFiled + " in ( ").append(cashFlowFilterPara.getItemFilterSql()).append(" ) ");
        }
        sql.append(" AND av.faccounttableid = ? \n");
        param.add(cashFlowFilterPara.getAccountTabel().getId().toString());
        sql.append(" AND ");
        sql.append(" voucher.FPeriodID in " + periodIdsStr + "\r\n");
        if (!isGlCurrency && !isGLRptCurrency) {
            if (cashFlowFilterPara.isOldVersion()) {
                sql.append(" and ve.FCurrencyID = ? \r\n");
            } else {
                sql.append(" and cfr.FCurrencyID = ? \r\n");
            }
            param.add(cashFlowFilterPara.getCurrencyId());
        }
        sql.append(" and voucher.FBizStatus in(");
        sql.append(5);
        if (cashFlowFilterPara.isAllVoucher()) {
            sql.append(",");
            sql.append(3);
            sql.append(",");
            sql.append(1);
        }
        sql.append(") )as cfr");
        sql.append(" on ");
        sql.append(idFiled);
        sql.append(" = cfi1.FID ");
        sql.append(" where ");
        sql.append(" cfi2.FType = ? \n");
        param.add(new Integer(itemType));
        sql.append(" and cfi2.FLevel <= ? \n");
        int lv = cashFlowFilterPara.getLevel() == 1 ? 2 : (int)cashFlowFilterPara.getLevel();
        param.add(new Integer(lv));
        if (cashFlowFilterPara.isDisplayAsst()) {
            String ssistItemName = "flongnamegroup_" + this.ctx.getLocale().toString();
            if (isGL004) {
                ssistItemName = "fdisplaynamegroup_" + this.ctx.getLocale().toString();
            }
            StringBuffer asstSql = new StringBuffer(512);
            asstSql.append(" union all \n");
            asstSql.append(" select cfi2.fid as FID,replace(hg." + ssistItemName + ",'_!',' ') as FName,\n");
            asstSql.append(" hg.fid FAsstID, \n");
            asstSql.append(" to_char((case when cfr.FType =3 then 3 else 2 end)) as FCashType, \n");
            asstSql.append(" case when cfr.FAmount is null then 0 else cfr.FAmount*(case when cfi2.FDirection=2 then -1 else 1 end) end as FAmount,cfi2.fisenable from \n");
            asstSql.append(" T_BD_CashFlowItem cfi2 ");
            asstSql.append(" left outer join (");
            asstSql.append(" select cfr.FAssgrpID,cfr.FType, \n");
            asstSql.append(idFiled);
            asstSql.append(",(");
            asstSql.append(amountField);
            asstSql.append("*");
            asstSql.append(rateField);
            asstSql.append(") as FAmount");
            asstSql.append(" from T_GL_CashflowRecord cfr \n");
            asstSql.append(" join T_GL_Voucher voucher on cfr.FVoucherID = voucher.FID \n");
            asstSql.append(" join T_BD_Period period on voucher.FPeriodID = period.FID \n");
            asstSql.append(" INNER JOIN t_bd_accountview av ON av.fid = cfr.faccountid \n");
            asstSql.append(" where voucher.FCompanyID = ? \n");
            param.add(this.selectedCompany.getId().toString());
            if (cashFlowFilterPara.getItemFilterSql() != null) {
                asstSql.append(" and " + idFiled + " in ( ").append(cashFlowFilterPara.getItemFilterSql()).append(" ) ");
            }
            asstSql.append(" AND av.faccounttableid = ? \n");
            param.add(cashFlowFilterPara.getAccountTabel().getId().toString());
            asstSql.append(" and ");
            asstSql.append(" voucher.FPeriodID in " + periodIdsStr + "\r\n");
            if (!isGlCurrency && !isGLRptCurrency) {
                asstSql.append(" and cfr.FCurrencyID = ? \r\n");
                param.add(cashFlowFilterPara.getCurrencyId());
            }
            asstSql.append(" and voucher.FBizStatus in(");
            asstSql.append(5);
            if (cashFlowFilterPara.isAllVoucher()) {
                asstSql.append(",");
                asstSql.append(3);
                asstSql.append(",");
                asstSql.append(1);
            }
            asstSql.append("  ))cfr ");
            asstSql.append(" on " + idFiled + " = cfi2.FID ");
            asstSql.append(" left join t_bd_assistanthg hg on cfr.fassgrpid=hg.fid \n");
            asstSql.append(" where ");
            asstSql.append(" cfi2.fisenable=1 and ");
            asstSql.append(" cfi2.fisleaf=1 and cfi2.flevel>1  and cfi2.FType = ? \r\n");
            param.add(new Integer(itemType));
            asstSql.append(" and cfi2.FLevel <= ? \r\n");
            param.add(new Integer(lv));
            sql.append(asstSql);
        }
        sql.append(" ) as A group by FID,FName,FAsstID,FCashType,FIsEnable \r\n");
        sql.append(" having sum(FAmount) <> 0 \r\n");
        HashMap<String, MapParam> map = new HashMap<String, MapParam>();
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])param.toArray());
        try {
            while (rs.next()) {
                String FID = rs.getString(1);
                String FName = rs.getString(2);
                String FAsstID = rs.getString(3);
                CashflowTypeEnum FCashType = CashflowTypeEnum.getEnum((int)rs.getInt(4));
                BigDecimal FAmount = rs.getBigDecimal(5);
                if (FID == null || FAmount == null) continue;
                MapParam m = new MapParam();
                m.FID = FID;
                m.FName = FName;
                m.FAsstID = FAsstID;
                m.FCashType = FCashType;
                m.FAmount = FAmount;
                m.FIsEnable = new Integer(rs.getInt(6));
                String key = FAsstID == null ? FID + FCashType : FID + FAsstID + FCashType;
                map.put(key, m);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return map;
    }

    private void combineInitMap(Vector vec, Map map, CashFlowFilterPara cashFlowFilterPara) {
        if (vec == null || vec.size() < 1 || map == null || map.size() < 1) {
            return;
        }
        if (cashFlowFilterPara.isDisplayAsst()) {
            this.combineAsstMap(vec, map, cashFlowFilterPara);
        }
        int l = vec.size();
        for (int i = 0; i < l; ++i) {
            DBParam p = (DBParam)vec.elementAt(i);
            if (map.get(p.FID) == null) continue;
            BigDecimal init = ((MapParam)map.get((Object)p.FID)).FAmount;
            p.FSum = p.FSum != null ? p.FSum.add(init) : init;
        }
    }

    private Vector combinDataForPrimaryItem(Context ctx, Vector vec, CashFlowFilterPara cashFlowFilterPara) throws EASBizException, BOSException {
        boolean isAsst = cashFlowFilterPara.isDisplayAsst();
        int lineIndex = 1;
        Vector<CashFlowDisplayRowInfo> vecReturn = new Vector<CashFlowDisplayRowInfo>();
        int firstLevelSeq = 1;
        int sizeVec = vec == null ? 0 : vec.size();
        short maxLevel = cashFlowFilterPara.getLevel();
        String sumName = null;
        BigDecimal bdTotal = new BigDecimal(0);
        BigDecimal bdSumTotal = new BigDecimal(0);
        BigDecimal bdInSum = new BigDecimal(0);
        BigDecimal bdInTotal = new BigDecimal(0);
        BigDecimal bdOutSum = new BigDecimal(0);
        BigDecimal bdOutTotal = new BigDecimal(0);
        BigDecimal bdCashSum = new BigDecimal(0);
        BigDecimal bdCashSumTotal = new BigDecimal(0);
        for (int i = 0; i < sizeVec; ++i) {
            DBParam p = (DBParam)vec.elementAt(i);
            DBParam pNext = null;
            if (i + 1 < sizeVec) {
                pNext = (DBParam)vec.elementAt(i + 1);
            }
            int thisLevel = p.FLevel;
            int thisDirection = p.FDirection;
            int thisIsLeaf = p.FIsLeaf;
            boolean thisIsExchange = p.FIsExchange;
            BigDecimal thisAmount = p.FAmount;
            BigDecimal thisSum = p.FSum == null ? new BigDecimal(0) : p.FSum;
            CashFlowDisplayRowInfo row = new CashFlowDisplayRowInfo();
            if (thisLevel == 1 && (cashFlowFilterPara.isDisplayExchangeSubsidiary() || !thisIsExchange)) {
                row.name = ResourceBase.getString((String)resClassName, (String)String.valueOf(firstLevelSeq), (Locale)ctx.getLocale()) + p.FName;
                sumName = p.FName;
                ++firstLevelSeq;
                vecReturn.addElement(row);
            } else if (maxLevel != 1 && (cashFlowFilterPara.isDisplayExchangeSubsidiary() || !thisIsExchange)) {
                row.name = this.getBlankString(thisLevel) + p.FName;
                row.seq = new Integer(lineIndex++);
                row.amount = p.FAmount;
                row.sum = p.FSum;
                row.itemInfo = p.itemInfo;
                if (isAsst) {
                    row.cashType = p.FCashType;
                    row.longNameGroup = p.FLongNameGroup;
                    row.assGrpid = p.FAsstID;
                }
                vecReturn.addElement(row);
            } else if (thisLevel == 1) {
                sumName = p.FName;
            }
            if (null == sumName) {
                sumName = "";
            }
            boolean flag = true;
            if (thisIsLeaf != 1 && thisLevel >= 3 && pNext != null && pNext.FLOngNumber.indexOf(p.FLOngNumber) == -1) {
                bdTotal = bdTotal.add(thisAmount);
                bdSumTotal = bdSumTotal.add(thisSum);
                flag = false;
            }
            if (thisDirection != 0) {
                if ((thisIsLeaf == 1 || maxLevel == 1 && thisLevel == 2 || maxLevel > 1 && thisLevel == maxLevel) && (!isAsst || isAsst && p.FCashType.equals((Object)CashflowTypeEnum.NONE)) && flag) {
                    bdTotal = bdTotal.add(thisAmount);
                    bdSumTotal = bdSumTotal.add(thisSum);
                }
                if (pNext == null || pNext.FLevel == 2 || pNext.FDirection != thisDirection && pNext.FAsstID == null) {
                    CashFlowDisplayRowInfo rowInOut = new CashFlowDisplayRowInfo();
                    rowInOut.name = thisDirection == 1 ? this.getBlankString(2) + this.getResource(ctx, "strInTotal") : this.getBlankString(2) + this.getResource(ctx, "strOutTotal");
                    rowInOut.amount = bdTotal;
                    rowInOut.sum = bdSumTotal;
                    rowInOut.isSumRow = Boolean.TRUE;
                    if (maxLevel != 1 && (cashFlowFilterPara.isDisplayExchangeSubsidiary() || !thisIsExchange)) {
                        rowInOut.seq = new Integer(lineIndex++);
                        vecReturn.addElement(rowInOut);
                    }
                    bdTotal = new BigDecimal(0);
                    bdSumTotal = new BigDecimal(0);
                }
            }
            if ((thisIsLeaf == 1 || maxLevel == 1 && thisLevel == 2 || maxLevel > 1 && thisLevel == maxLevel) && (!isAsst || isAsst && p.FCashType.equals((Object)CashflowTypeEnum.NONE))) {
                if (thisDirection == 1) {
                    bdInSum = bdInSum.add(thisAmount);
                    bdInTotal = bdInTotal.add(thisSum);
                } else if (thisDirection == 2) {
                    bdOutSum = bdOutSum.add(thisAmount);
                    bdOutTotal = bdOutTotal.add(thisSum);
                }
            }
            if (pNext != null && pNext.FLevel != 1) continue;
            CashFlowDisplayRowInfo rowSum = new CashFlowDisplayRowInfo();
            rowSum.name = cashFlowFilterPara.isDisplayExchangeSubsidiary() || !thisIsExchange ? this.getBlankString(2) + this.getSumString(ctx, sumName) : ResourceBase.getString((String)resClassName, (String)String.valueOf(firstLevelSeq++), (Locale)ctx.getLocale()) + sumName;
            rowSum.seq = new Integer(lineIndex++);
            rowSum.amount = bdInSum.subtract(bdOutSum);
            rowSum.sum = bdInTotal.subtract(bdOutTotal);
            rowSum.isSumRow = Boolean.TRUE;
            bdCashSum = bdCashSum.add(bdInSum.subtract(bdOutSum));
            bdCashSumTotal = bdCashSumTotal.add(bdInTotal.subtract(bdOutTotal));
            vecReturn.addElement(rowSum);
            bdInSum = new BigDecimal(0);
            bdInTotal = new BigDecimal(0);
            bdOutSum = new BigDecimal(0);
            bdOutTotal = new BigDecimal(0);
        }
        if (!cashFlowFilterPara.isDisplayCashBalanceForBeginAndEnd()) {
            CashFlowDisplayRowInfo rowCashBalance = new CashFlowDisplayRowInfo();
            rowCashBalance.name = this.getResource(ctx, "strCashSum");
            rowCashBalance.seq = new Integer(lineIndex++);
            rowCashBalance.amount = bdCashSum;
            rowCashBalance.sum = bdCashSumTotal;
            rowCashBalance.isSumRow = Boolean.TRUE;
            vecReturn.addElement(rowCashBalance);
        } else {
            CashFlowDisplayRowInfo rowCashBalance = new CashFlowDisplayRowInfo();
            rowCashBalance.name = ResourceBase.getString((String)resClassName, (String)String.valueOf(firstLevelSeq++), (Locale)ctx.getLocale()) + this.getResource(ctx, "strCashSum");
            rowCashBalance.seq = new Integer(lineIndex++);
            rowCashBalance.amount = bdCashSum;
            rowCashBalance.sum = bdCashSumTotal;
            rowCashBalance.isSumRow = Boolean.TRUE;
            vecReturn.addElement(rowCashBalance);
            BigDecimal[] bdArray = this.getCashBalance(ctx, cashFlowFilterPara);
            BigDecimal[] bdSumArray = this.getSumCashBalance(ctx, cashFlowFilterPara);
            BigDecimal bdCashBeginSum = bdArray[0].add(bdArray[2]);
            BigDecimal bdCashBeginSumTotal = bdSumArray[0].add(bdSumArray[2]);
            rowCashBalance = new CashFlowDisplayRowInfo();
            rowCashBalance.name = this.getBlankString(2) + this.getResource(ctx, "strAddCashAndXjdjwBegin");
            rowCashBalance.seq = new Integer(lineIndex++);
            rowCashBalance.amount = bdCashBeginSum;
            rowCashBalance.sum = bdCashBeginSumTotal;
            rowCashBalance.isSumRow = Boolean.FALSE;
            vecReturn.addElement(rowCashBalance);
            rowCashBalance = new CashFlowDisplayRowInfo();
            rowCashBalance.name = ResourceBase.getString((String)resClassName, (String)String.valueOf(firstLevelSeq++), (Locale)ctx.getLocale()) + this.getResource(ctx, "strCashAndXjdjwEndBanlance");
            rowCashBalance.seq = new Integer(lineIndex++);
            rowCashBalance.amount = bdCashBeginSum.add(bdCashSum);
            rowCashBalance.sum = bdCashBeginSumTotal.add(bdCashSumTotal);
            rowCashBalance.isSumRow = Boolean.TRUE;
            vecReturn.addElement(rowCashBalance);
        }
        return vecReturn;
    }

    private Vector combinDataForSecondaryItem(Context ctx, CashFlowFilterPara cashFlowFilterPara, Vector vec, PeriodInfo startPeriod) throws BOSException, EASBizException {
        Vector<CashFlowDisplayRowInfo> vecReturn = new Vector<CashFlowDisplayRowInfo>();
        int lineIndex = 1;
        BigDecimal amount = this.getRetainedProfits(ctx, cashFlowFilterPara);
        BigDecimal sumAmount = this.getSumRetainedProfits2(ctx, cashFlowFilterPara, startPeriod);
        BigDecimal bdTotal = new BigDecimal(0);
        BigDecimal bdSumTotal = new BigDecimal(0);
        int sizeVec = vec.size();
        short maxLevel = cashFlowFilterPara.getLevel();
        for (int i = 0; i < sizeVec; ++i) {
            DBParam p = (DBParam)vec.elementAt(i);
            int thisLevel = p.FLevel;
            CashFlowDisplayRowInfo row = new CashFlowDisplayRowInfo();
            if (thisLevel <= 2) {
                if (maxLevel <= 2 && thisLevel == maxLevel) {
                    bdTotal = bdTotal.add(p.FAmount);
                    if (p.FSum != null) {
                        bdSumTotal = bdSumTotal.add(p.FSum);
                    }
                }
                if (maxLevel == 1 && thisLevel > 1) continue;
                row.name = this.getBlankString(thisLevel + 1) + p.FName;
                vecReturn.addElement(row);
            } else {
                row.name = this.getBlankString(thisLevel + 1) + p.FName;
                row.seq = new Integer(lineIndex++);
                row.sum = p.FSum;
                if (p.FIsProfit.booleanValue()) {
                    row.amount = amount;
                    row.sum = row.sum != null ? row.sum.add(sumAmount) : sumAmount;
                } else {
                    row.amount = p.FAmount;
                    if (p.FIsLeaf != null && p.FIsLeaf == 1) {
                        bdTotal = bdTotal.add(p.FAmount);
                        if (p.FSum != null) {
                            bdSumTotal = bdSumTotal.add(p.FSum);
                        }
                    }
                }
                vecReturn.addElement(row);
            }
            row.itemInfo = p.itemInfo;
        }
        CashFlowDisplayRowInfo rowSum = new CashFlowDisplayRowInfo();
        rowSum.name = this.getBlankString(2) + this.getResource(ctx, "strWork");
        rowSum.seq = new Integer(lineIndex++);
        rowSum.amount = amount.add(bdTotal);
        rowSum.sum = sumAmount.add(bdSumTotal);
        rowSum.isSumRow = Boolean.TRUE;
        vecReturn.addElement(rowSum);
        return vecReturn;
    }

    private Vector combinDataForSupplementaryItem(Context ctx, CashFlowFilterPara cashFlowFilterPara, Vector vec) throws BOSException {
        Vector<CashFlowDisplayRowInfo> vecReturn = new Vector<CashFlowDisplayRowInfo>();
        int lineIndex = 1;
        int sizeVec = vec.size();
        short maxLevel = cashFlowFilterPara.getLevel();
        for (int i = 0; i < sizeVec; ++i) {
            DBParam p = (DBParam)vec.elementAt(i);
            int thisLevel = p.FLevel;
            CashFlowDisplayRowInfo row = new CashFlowDisplayRowInfo();
            if (thisLevel <= 1) {
                row.name = this.getBlankString(thisLevel + 1) + p.FName;
                row.amount = p.FAmount;
                vecReturn.addElement(row);
            } else {
                if (maxLevel == 1) continue;
                row.name = this.getBlankString(thisLevel + 1) + p.FName;
                row.seq = new Integer(lineIndex++);
                row.amount = p.FAmount;
                vecReturn.addElement(row);
            }
            row.sum = p.FSum;
        }
        return vecReturn;
    }

    private Vector getAdditionOfCash(Context ctx, CashFlowFilterPara cashFlowFilterPara) throws BOSException, EASBizException {
        Vector<CashFlowDisplayRowInfo> vecReturn = new Vector<CashFlowDisplayRowInfo>();
        int lineIndex = 1;
        BigDecimal[] bdArray = this.getCashBalance(ctx, cashFlowFilterPara);
        BigDecimal[] bdSumArray = this.getSumCashBalance(ctx, cashFlowFilterPara);
        CashFlowDisplayRowInfo row = new CashFlowDisplayRowInfo();
        row.name = this.getResource(ctx, "strAdd");
        vecReturn.addElement(row);
        row = new CashFlowDisplayRowInfo();
        row.name = this.getBlankString(2) + this.getResource(ctx, "strCashEnd");
        row.seq = new Integer(lineIndex++);
        row.amount = bdArray[1];
        row.sum = bdSumArray[1];
        vecReturn.addElement(row);
        row = new CashFlowDisplayRowInfo();
        row.name = this.getBlankString(2) + this.getResource(ctx, "strJCahsBegin");
        row.seq = new Integer(lineIndex++);
        row.amount = bdArray[0];
        row.sum = bdSumArray[0];
        vecReturn.addElement(row);
        row = new CashFlowDisplayRowInfo();
        row.name = this.getBlankString(2) + this.getResource(ctx, "strAddSjdjwEnd");
        row.seq = new Integer(lineIndex++);
        row.amount = bdArray[3];
        row.sum = bdSumArray[3];
        vecReturn.addElement(row);
        row = new CashFlowDisplayRowInfo();
        row.name = this.getBlankString(2) + this.getResource(ctx, "strJSjdjwEnd");
        row.seq = new Integer(lineIndex++);
        row.amount = bdArray[2];
        row.sum = bdSumArray[2];
        vecReturn.addElement(row);
        row = new CashFlowDisplayRowInfo();
        row.name = this.getBlankString(2) + this.getResource(ctx, "strCashAndXjdjw");
        row.seq = new Integer(lineIndex++);
        row.amount = bdArray[1].subtract(bdArray[0]).add(bdArray[3]).subtract(bdArray[2]);
        row.sum = bdSumArray[1].subtract(bdSumArray[0]).add(bdSumArray[3].subtract(bdSumArray[2]));
        vecReturn.addElement(row);
        return vecReturn;
    }

    private String getGeneralLocalCurrency() {
        return CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
    }

    private String getGeneralReportCurrency() {
        return CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
    }

    private boolean isLocalOrReportCurrency(String currencyId) {
        return !currencyId.equals(this.getGeneralLocalCurrency()) && !currencyId.equals(this.getGeneralReportCurrency());
    }

    private String getBlankString(int level) {
        StringBuffer sbBlank = new StringBuffer();
        for (int i = 1; i < level; ++i) {
            sbBlank.append("    ");
        }
        return sbBlank.toString();
    }

    private String getResource(Context ctx, String name) {
        return ResourceBase.getString((String)resClassName, (String)name, (Locale)ctx.getLocale());
    }

    private String getSumString(Context ctx, String sumName) {
        StringBuffer sbReturn = new StringBuffer(this.getResource(ctx, "strSum"));
        int pos = sbReturn.indexOf("@");
        sbReturn.replace(pos, pos + 1, sumName);
        return sbReturn.toString();
    }

    private BigDecimal[] getCashBalance(Context ctx, CashFlowFilterPara cashFlowFilterPara) throws BOSException, EASBizException {
        BigDecimal equEnd;
        BigDecimal equBegin;
        BigDecimal cashEnd;
        BigDecimal cashBegin;
        BigDecimal[] arrayReturn = new BigDecimal[4];
        PeriodInfo periodBegin = null;
        PeriodInfo periodEnd = null;
        if (cashFlowFilterPara.isTermOrDate()) {
            periodBegin = this.getPeriodByYearAndNumber(ctx, cashFlowFilterPara.getYearFrom(), cashFlowFilterPara.getMonthFrom());
            periodEnd = this.getPeriodByYearAndNumber(ctx, cashFlowFilterPara.getYearTo(), cashFlowFilterPara.getMonthTo());
        } else {
            periodBegin = this.getPeriodByDate(ctx, new Date(cashFlowFilterPara.getDateFrom().getTime()));
            PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.curCompany);
            if (periodBegin == null || currentPeriod.getPeriodYear() * 100 + currentPeriod.getPeriodNumber() < periodBegin.getPeriodYear() * 100 + periodBegin.getPeriodNumber()) {
                periodBegin = currentPeriod;
            }
            periodEnd = this.getPeriodByDate(ctx, new Date(cashFlowFilterPara.getDateTo().getTime()));
        }
        if (cashFlowFilterPara.isTermOrDate()) {
            cashBegin = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodBegin, true, true);
            cashEnd = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodEnd, true, false);
            equBegin = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodBegin, false, true);
            equEnd = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodEnd, false, false);
        } else {
            cashEnd = cashBegin = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodBegin, true, true);
            equEnd = equBegin = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodBegin, false, true);
            GregorianCalendar gcStart = new GregorianCalendar();
            gcStart.setTime(cashFlowFilterPara.getDateFrom());
            gcStart.add(5, -1);
            Date startDate = new Date(gcStart.getTime().getTime());
            GregorianCalendar gcEnd = new GregorianCalendar();
            gcEnd.setTime(cashFlowFilterPara.getDateTo());
            gcEnd.add(5, 1);
            cashBegin = cashBegin.add(this.getAmountFromVoucher(ctx, cashFlowFilterPara, new Date(periodBegin.getBeginDate().getTime()), startDate, true, periodBegin));
            cashEnd = cashEnd.add(this.getAmountFromVoucher(ctx, cashFlowFilterPara, new Date(periodBegin.getBeginDate().getTime()), new Date(cashFlowFilterPara.getDateTo().getTime()), true, periodBegin));
            equBegin = equBegin.add(this.getAmountFromVoucher(ctx, cashFlowFilterPara, new Date(periodBegin.getBeginDate().getTime()), startDate, false, periodBegin));
            equEnd = equEnd.add(this.getAmountFromVoucher(ctx, cashFlowFilterPara, new Date(periodBegin.getBeginDate().getTime()), new Date(cashFlowFilterPara.getDateTo().getTime()), false, periodBegin));
        }
        arrayReturn[0] = cashBegin;
        arrayReturn[1] = cashEnd;
        arrayReturn[2] = equBegin;
        arrayReturn[3] = equEnd;
        return arrayReturn;
    }

    private BigDecimal[] getSumCashBalance(Context ctx, CashFlowFilterPara cashFlowFilterPara) throws BOSException, EASBizException {
        BigDecimal[] arrayReturn = new BigDecimal[4];
        BigDecimal cashBegin = new BigDecimal(0);
        BigDecimal cashEnd = new BigDecimal(0);
        BigDecimal equBegin = new BigDecimal(0);
        BigDecimal equEnd = new BigDecimal(0);
        PeriodInfo periodBegin = null;
        PeriodInfo periodEnd = null;
        if (cashFlowFilterPara.isTermOrDate()) {
            short yearFrom = cashFlowFilterPara.getYearFrom();
            short yearTo = cashFlowFilterPara.getYearTo();
            int monthFrom = cashFlowFilterPara.getMonthFrom();
            short monthTo = cashFlowFilterPara.getMonthTo();
            if (yearFrom != yearTo) {
                yearFrom = yearTo;
            }
            monthFrom = PeriodUtils.getMinPeriodNumber((Context)ctx, (int)yearFrom, (String)this.curCompany.getId().toString());
            periodBegin = this.getPeriodByYearAndNumber(ctx, yearFrom, monthFrom);
            periodEnd = this.getPeriodByYearAndNumber(ctx, yearTo, monthTo);
            cashBegin = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodBegin, true, true);
            cashEnd = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodEnd, true, false);
            equBegin = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodBegin, false, true);
            equEnd = this.getAmountFromBalance(ctx, cashFlowFilterPara, periodBegin, periodEnd, false, false);
        }
        arrayReturn[0] = cashBegin;
        arrayReturn[1] = cashEnd;
        arrayReturn[2] = equBegin;
        arrayReturn[3] = equEnd;
        return arrayReturn;
    }

    private BigDecimal getRetainedProfits(Context ctx, CashFlowFilterPara cashFlowFilterPara) throws BOSException, EASBizException {
        BigDecimal bdReturn = null;
        String periodIdsStr = null;
        StringBuffer sbSql = new StringBuffer("select ");
        if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FLocalAmount else (-1) * FLocalAmount end) FAmount");
        } else if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralReportCurrency())) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FReportingAmount else (-1) * FReportingAmount end) FAmount");
        } else {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FOriginalAmount else (-1) * FOriginalAmount end) FAmount");
        }
        sbSql.append(" from T_GL_Voucher voucher join T_GL_VoucherEntry ve on voucher.FID = ve.FBillID join T_BD_AccountView account on ve.FAccountID = account.FID ");
        if (cashFlowFilterPara.isTermOrDate()) {
            List<String> periodIdList = com.kingdee.eas.fi.gl.CashFlowUtils.getPeriodIdByNumberRange(ctx, this.selectedCompany.getId().toString(), cashFlowFilterPara.getYearFrom() * 100 + cashFlowFilterPara.getMonthFrom(), cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo());
            if (periodIdList != null && periodIdList.size() > 0) {
                periodIdsStr = com.kingdee.eas.fi.gl.CashFlowUtils.buildIn(periodIdList);
            }
            if (periodIdsStr == null) {
                sbSql.append(" join T_BD_Period period on voucher.FPeriodID = period.FID ");
            }
        }
        sbSql.append(" left join t_bd_cashflowaccountdiff on fdiffaccountid=account.FID ");
        sbSql.append(" where voucher.FCompanyID = ?");
        sbSql.append(" and account.fcompanyid = ?");
        sbSql.append(" and fdiffaccountid is null");
        sbSql.append(" and account.FPLType <> ?");
        sbSql.append(" and account.FCategory = 1");
        if (cashFlowFilterPara.isTermOrDate()) {
            if (periodIdsStr == null) {
                sbSql.append(" and period.FNumber >= ?");
                sbSql.append(" and period.FNumber <= ?");
            } else {
                sbSql.append(" and voucher.FPeriodID in ").append(periodIdsStr);
            }
        } else {
            sbSql.append(" and voucher.FBookedDate >= ?");
            sbSql.append(" and voucher.FBookedDate <= ?");
        }
        if (this.isLocalOrReportCurrency(cashFlowFilterPara.getCurrencyId())) {
            sbSql.append(" and ve.FCurrencyID = ?");
        }
        sbSql.append(" and voucher.FSourceType<>1 ");
        sbSql.append(" and voucher.FBizStatus in(");
        sbSql.append(5);
        if (cashFlowFilterPara.isAllVoucher()) {
            sbSql.append(",");
            sbSql.append(1);
            sbSql.append(",");
            sbSql.append(3);
        }
        sbSql.append(")");
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sbSql.toString());
            int index = 1;
            ps.setString(index++, this.selectedCompany.getId().toString());
            ps.setString(index++, this.selectedCompany.getId().toString());
            ps.setInt(index++, 0);
            if (cashFlowFilterPara.isTermOrDate()) {
                if (periodIdsStr == null) {
                    ps.setInt(index++, cashFlowFilterPara.getYearFrom() * 100 + cashFlowFilterPara.getMonthFrom());
                    ps.setInt(index++, cashFlowFilterPara.getYearTo() * 100 + cashFlowFilterPara.getMonthTo());
                }
            } else {
                ps.setDate(index++, new Date(cashFlowFilterPara.getDateFrom().getTime()));
                ps.setDate(index++, new Date(cashFlowFilterPara.getDateTo().getTime()));
            }
            if (this.isLocalOrReportCurrency(cashFlowFilterPara.getCurrencyId())) {
                ps.setString(index++, cashFlowFilterPara.getCurrencyId());
            }
            rs = ps.executeQuery();
            rs.next();
            bdReturn = rs.getBigDecimal("FAmount");
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bdReturn == null ? GlUtils.zero : bdReturn;
    }

    private BigDecimal getSumRetainedProfits(Context ctx, CashFlowFilterPara cashFlowFilterPara, PeriodInfo startPeriod) throws BOSException, EASBizException {
        BigDecimal bdReturn = new BigDecimal(0);
        if (!cashFlowFilterPara.isTermOrDate()) {
            return bdReturn;
        }
        int yearFrom = startPeriod.getPeriodYear();
        int monthFrom = startPeriod.getPeriodNumber();
        short yearTo = cashFlowFilterPara.getYearTo();
        short monthTo = cashFlowFilterPara.getMonthTo();
        boolean needComineInitValue = false;
        if (yearFrom != yearTo) {
            monthFrom = PeriodUtils.getMinPeriodNumber((Context)ctx, (int)yearTo, (String)this.selectedCompany.getId().toString());
            yearFrom = yearTo;
        } else {
            yearFrom = startPeriod.getPeriodYear();
            monthFrom = startPeriod.getPeriodNumber();
            needComineInitValue = GLFlagFactory.getLocalInstance(ctx).getCashflowInitClosed(this.selectedCompany.getId().toString());
        }
        PeriodInfo minPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.selectedCompany);
        if (needComineInitValue && minPeriod.getPeriodNumber() == 1) {
            needComineInitValue = false;
        }
        StringBuffer sbSql = new StringBuffer("select ");
        ArrayList<Object> param = new ArrayList<Object>();
        if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FLocalAmount else (-1) * FLocalAmount end) FAmount");
        } else if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralReportCurrency())) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FReportingAmount else (-1) * FReportingAmount end) FAmount");
        } else {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FOriginalAmount else (-1) * FOriginalAmount end) FAmount");
        }
        sbSql.append(" from T_GL_Voucher voucher join T_GL_VoucherEntry ve on voucher.FID = ve.FBillID join T_BD_AccountView account on ve.FAccountID = account.FID ");
        List<String> periodIdList = com.kingdee.eas.fi.gl.CashFlowUtils.getPeriodIdByNumberRange(ctx, this.selectedCompany.getId().toString(), yearFrom * 100 + monthFrom, yearTo * 100 + monthTo);
        String periodIdsStr = null;
        if (periodIdList != null && periodIdList.size() > 0) {
            periodIdsStr = com.kingdee.eas.fi.gl.CashFlowUtils.buildIn(periodIdList);
        }
        if (periodIdsStr == null) {
            sbSql.append(" join T_BD_Period period on voucher.FPeriodID = period.FID ");
        }
        sbSql.append(" left join t_bd_cashflowaccountdiff on fdiffaccountid=account.FID ");
        sbSql.append(" where voucher.FCompanyID = ?");
        param.add(this.selectedCompany.getId().toString());
        sbSql.append(" and account.FCompanyID = ?");
        param.add(this.selectedCompany.getId().toString());
        sbSql.append(" and fdiffaccountid is null");
        sbSql.append(" and account.FPLType <> ?");
        param.add(new Integer(0));
        sbSql.append(" and account.FCategory = 1");
        if (periodIdsStr == null) {
            sbSql.append(" and period.FPeriodYear >= ?");
            param.add(new Integer(yearFrom));
            sbSql.append(" and period.FPeriodNumber >= ?");
            param.add(new Integer(monthFrom));
            sbSql.append(" and period.FPeriodYear <= ?");
            param.add(new Integer(yearTo));
            sbSql.append(" and period.FPeriodNumber <= ?");
            param.add(new Integer(monthTo));
        } else {
            sbSql.append(" and voucher.FPeriodID in ").append(periodIdsStr);
        }
        if (this.isLocalOrReportCurrency(cashFlowFilterPara.getCurrencyId())) {
            sbSql.append(" and ve.FCurrencyID = ?");
            param.add(cashFlowFilterPara.getCurrencyId().toString());
        }
        sbSql.append(" and voucher.FSourceType<>1 ");
        sbSql.append(" and voucher.FBizStatus in(");
        sbSql.append(5);
        if (cashFlowFilterPara.isAllVoucher()) {
            sbSql.append(",");
            sbSql.append(1);
            sbSql.append(",");
            sbSql.append(3);
        }
        sbSql.append(")");
        if (needComineInitValue) {
            String diffAccountSet = CashFlowUtils.getDiff(ctx);
            String currencyId = cashFlowFilterPara.getCurrencyId();
            boolean isGlCurrency = currencyId.equals(this.getGeneralLocalCurrency());
            boolean isGLRptCurrency = currencyId.equals(this.getGeneralReportCurrency());
            String amountField = isGlCurrency ? "FYearPnLLocal" : (isGLRptCurrency ? "FYearPnLRpt" : "FYearPnLFor");
            StringBuffer sql = new StringBuffer();
            sql.append(" select sum(FAmount) FAmount from (");
            sql.append(sbSql);
            sql.append(" union all ");
            sql.append("select sum((-1) * account.FDC * ").append(amountField).append(") FAmount ");
            sql.append(" from T_GL_InitAccountBalance balance join T_BD_AccountView account");
            sql.append(" on balance.FAccountID = account.FID ");
            sql.append(" where account.FIsLeaf = 1 and account.FPLType>0");
            sql.append(" and balance.FOrgUnitId = ?");
            param.add(this.selectedCompany.getId().toString());
            sql.append(" and balance.FCurrencyID = ?");
            if (diffAccountSet != null && diffAccountSet.length() > 0) {
                sbSql.append(" and account.FID not in (" + diffAccountSet + ")");
            }
            param.add(cashFlowFilterPara.getCurrencyId());
            sql.append(" ) as A");
            sbSql = sql;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])param.toArray());
        try {
            if (rs.next()) {
                bdReturn = rs.getBigDecimal("FAmount");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return bdReturn == null ? new BigDecimal(0) : bdReturn;
    }

    private BigDecimal getSumRetainedProfits2(Context ctx, CashFlowFilterPara cashFlowFilterPara, PeriodInfo startPeriod) throws BOSException, EASBizException {
        List<String> periodIdList;
        BigDecimal bdReturn = new BigDecimal(0);
        if (!cashFlowFilterPara.isTermOrDate()) {
            return bdReturn;
        }
        int yearFrom = startPeriod.getPeriodYear();
        int monthFrom = startPeriod.getPeriodNumber();
        short yearTo = cashFlowFilterPara.getYearTo();
        short monthTo = cashFlowFilterPara.getMonthTo();
        boolean needComineInitValue = false;
        if (yearFrom != yearTo) {
            monthFrom = PeriodUtils.getMinPeriodNumber((Context)ctx, (int)yearTo, (String)this.selectedCompany.getId().toString());
            yearFrom = yearTo;
        } else {
            yearFrom = startPeriod.getPeriodYear();
            monthFrom = startPeriod.getPeriodNumber();
            needComineInitValue = GLFlagFactory.getLocalInstance(ctx).getCashflowInitClosed(this.selectedCompany.getId().toString());
        }
        PeriodInfo minPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.selectedCompany);
        if (needComineInitValue && minPeriod.getPeriodNumber() == 1) {
            needComineInitValue = false;
        }
        if ((periodIdList = com.kingdee.eas.fi.gl.CashFlowUtils.getPeriodIdByNumberRange(ctx, this.selectedCompany.getId().toString(), yearFrom * 100 + monthFrom, yearTo * 100 + monthTo)) == null || periodIdList.size() < 4) {
            return this.getSumRetainedProfits(ctx, cashFlowFilterPara, startPeriod);
        }
        final String currencyId = cashFlowFilterPara.getCurrencyId();
        final boolean isAllVoucher = cashFlowFilterPara.isAllVoucher();
        final String diffAccountSet = CashFlowUtils.getDiff(ctx);
        if (this.isSupportForkJoinPool()) {
            if (needComineInitValue) {
                try {
                    BigDecimal initValue = this.getInitValueSumRetainedProfits(currencyId);
                    bdReturn = bdReturn.add(initValue);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            ForkJoinPool forkJoinPool = (ForkJoinPool)this.getExecutorService(true);
            ArrayDeque<String> periodQueue = new ArrayDeque<String>(periodIdList);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("currencyId", currencyId);
            paramMap.put("diffAccountSet", diffAccountSet);
            paramMap.put("isAllVoucher", isAllVoucher);
            ForkJoinTask submit = forkJoinPool.submit(new RetainedProfitsSumTask(periodQueue, 3, paramMap));
            try {
                bdReturn = bdReturn.add((BigDecimal)submit.get());
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
        } else {
            List<String> periodGroup = this.getPeriodGroup(periodIdList, 3);
            ExecutorService executorService = this.getExecutorService(false);
            ArrayList<Future<BigDecimal>> futures = new ArrayList<Future<BigDecimal>>();
            for (final String string : periodGroup) {
                Future<BigDecimal> future = executorService.submit(new Callable<BigDecimal>(){

                    @Override
                    public BigDecimal call() throws Exception {
                        return CashflowSingleDao.this.doGetSubSumRetainedProfits(string, currencyId, diffAccountSet, isAllVoucher);
                    }
                });
                futures.add(future);
            }
            if (needComineInitValue) {
                Future<BigDecimal> future = executorService.submit(new Callable<BigDecimal>(){

                    @Override
                    public BigDecimal call() throws Exception {
                        return CashflowSingleDao.this.getInitValueSumRetainedProfits(currencyId);
                    }
                });
                futures.add(future);
            }
            for (Future future : futures) {
                try {
                    BigDecimal singleReturn = (BigDecimal)future.get();
                    if (singleReturn == null) continue;
                    bdReturn = bdReturn.add(singleReturn);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
        return bdReturn == null ? new BigDecimal(0) : bdReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService(boolean isForkJoin) {
        if (this.executor == null) {
            CashflowSingleDao cashflowSingleDao = this;
            synchronized (cashflowSingleDao) {
                if (this.executor == null) {
                    this.executor = isForkJoin ? new ForkJoinPool() : Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                }
            }
        }
        return this.executor;
    }

    private void closeExecutor() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    private BigDecimal getInitValueSumRetainedProfits(String currencyId) throws BOSException, SQLException {
        boolean isGlCurrency = currencyId.equals(this.getGeneralLocalCurrency());
        boolean isGLRptCurrency = currencyId.equals(this.getGeneralReportCurrency());
        String amountField = isGlCurrency ? "FYearPnLLocal" : (isGLRptCurrency ? "FYearPnLRpt" : "FYearPnLFor");
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(FAmount) FAmount from (");
        sql.append("select sum((-1) * account.FDC * ").append(amountField).append(") FAmount ");
        sql.append(" from T_GL_InitAccountBalance balance join T_BD_AccountView account");
        sql.append(" on balance.FAccountID = account.FID ");
        sql.append(" where account.FIsLeaf = 1 and account.FPLType>0");
        sql.append(" and balance.FOrgUnitId = ?");
        ArrayList<String> param = new ArrayList<String>();
        param.add(this.selectedCompany.getId().toString());
        sql.append(" and balance.FCurrencyID = ?");
        param.add(currencyId);
        sql.append(" ) as A");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])param.toArray());
        BigDecimal result = BigDecimal.ZERO;
        if (rs.next()) {
            result = rs.getBigDecimal("FAmount");
        }
        return result == null ? BigDecimal.ZERO : result;
    }

    private List<String> getPeriodGroup(List<String> periodIdList, int step) {
        int curIndex = 0;
        ArrayList<String> periodIdTempList = new ArrayList<String>();
        String periodIdsStr = null;
        ArrayList<String> periodIdsStrList = new ArrayList<String>();
        while (curIndex < periodIdList.size()) {
            periodIdTempList.add(periodIdList.get(curIndex));
            if (periodIdTempList.size() != step && ++curIndex != periodIdList.size()) continue;
            periodIdsStr = com.kingdee.eas.fi.gl.CashFlowUtils.buildIn(periodIdTempList);
            periodIdsStrList.add(periodIdsStr);
            periodIdTempList = new ArrayList();
            periodIdsStr = null;
        }
        return periodIdsStrList;
    }

    private BigDecimal doGetSubSumRetainedProfits(String periodIdsStr, String currencyId, String diffAccountSet, boolean isAllVoucher) throws BOSException, SQLException {
        IRowSet rs;
        StringBuffer sbSql = new StringBuffer("select ");
        ArrayList<Object> param = new ArrayList<Object>();
        if (currencyId.equals(this.getGeneralLocalCurrency())) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FLocalAmount else (-1) * FLocalAmount end) FAmount");
        } else if (currencyId.equals(this.getGeneralReportCurrency())) {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FReportingAmount else (-1) * FReportingAmount end) FAmount");
        } else {
            sbSql.append(" sum(case ve.FEntryDC when 0 then ve.FOriginalAmount else (-1) * FOriginalAmount end) FAmount");
        }
        sbSql.append(" from T_GL_Voucher voucher join T_GL_VoucherEntry ve on voucher.FID = ve.FBillID join T_BD_AccountView account on ve.FAccountID = account.FID ");
        if (periodIdsStr == null) {
            sbSql.append(" join T_BD_Period period on voucher.FPeriodID = period.FID ");
        }
        sbSql.append(" left join t_bd_cashflowaccountdiff on fdiffaccountid=account.FID ");
        sbSql.append(" where voucher.FCompanyID = ?");
        param.add(this.selectedCompany.getId().toString());
        sbSql.append(" and account.FCompanyID = ?");
        param.add(this.selectedCompany.getId().toString());
        sbSql.append(" and fdiffaccountid is null");
        sbSql.append(" and account.FPLType <> ?");
        param.add(new Integer(0));
        sbSql.append(" and account.FCategory = 1");
        sbSql.append(" and voucher.FPeriodID in ").append(periodIdsStr);
        if (this.isLocalOrReportCurrency(currencyId)) {
            sbSql.append(" and ve.FCurrencyID = ?");
            param.add(currencyId);
        }
        sbSql.append(" and voucher.FSourceType<>1 ");
        sbSql.append(" and voucher.FBizStatus in(");
        sbSql.append(5);
        if (isAllVoucher) {
            sbSql.append(",");
            sbSql.append(1);
            sbSql.append(",");
            sbSql.append(3);
        }
        sbSql.append(")");
        if (diffAccountSet != null && diffAccountSet.length() > 0) {
            sbSql.append(" and account.FID not in (" + diffAccountSet + ")");
        }
        if ((rs = DbUtil.executeQuery((Context)this.ctx, (String)sbSql.toString(), (Object[])param.toArray())).next()) {
            BigDecimal temp = rs.getBigDecimal("FAmount");
            return temp != null ? temp : BigDecimal.ZERO;
        }
        return BigDecimal.ZERO;
    }

    private PeriodInfo getPeriodByYearAndNumber(Context ctx, int PeriodYear, int PeriodNumber) throws BOSException, EASBizException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(PeriodYear)));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(PeriodNumber)));
        fic.add(new FilterItemInfo("periodType.id", (Object)this.selectedCompany.getAccountPeriodType().getId().toString()));
        view.setFilter(filter);
        PeriodCollection periodCollection = iPeriod.getPeriodCollection(view);
        PeriodInfo periodInfo = periodCollection == null || periodCollection.size() == 0 ? null : periodCollection.get(0);
        return periodInfo;
    }

    private PeriodInfo getPeriodByDate(Context ctx, Date tsDate) throws BOSException, EASBizException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("beginDate", (Object)tsDate, CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("endDate", (Object)tsDate, CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("periodType.id", (Object)this.selectedCompany.getAccountPeriodType().getId().toString()));
        view.setFilter(filter);
        PeriodCollection periodCollection = iPeriod.getPeriodCollection(view);
        PeriodInfo periodInfo = periodCollection == null || periodCollection.size() == 0 ? null : periodCollection.get(0);
        return periodInfo;
    }

    private BigDecimal getAmountFromBalance(Context ctx, CashFlowFilterPara cashFlowFilterPara, PeriodInfo periodBegin, PeriodInfo periodEnd, boolean isCash, boolean isBegin) throws BOSException, EASBizException {
        BigDecimal bdReturn = GlUtils.zero;
        if (periodBegin == null || periodBegin.getId() == null) {
            return bdReturn;
        }
        StringBuffer sbSql = new StringBuffer("Select ");
        boolean isForCurrency = false;
        if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
            if (isBegin) {
                sbSql.append(" sum(FBeginBalanceLocal) FAmount ");
            } else {
                sbSql.append(" sum(FDebitLocal-FCreditLocal+FBeginBalanceLocal) FAmount ");
            }
        } else if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralReportCurrency())) {
            if (isBegin) {
                sbSql.append(" sum(FBeginBalanceRpt) FAmount ");
            } else {
                sbSql.append(" sum(FDebitRpt-FCreditRpt+FBeginBalanceRpt) FAmount ");
            }
        } else {
            isForCurrency = true;
            if (isBegin) {
                sbSql.append(" sum(FBeginBalanceFor) FAmount ");
            } else {
                sbSql.append(" sum(FDebitFor-FCreditFor+FBeginBalanceFor) FAmount ");
            }
        }
        int balType = cashFlowFilterPara.isAllVoucher() ? 1 : 5;
        sbSql.append(" from " + GLBalanceUtils.getAccountBalanceTable(balType, cashFlowFilterPara.getCurrencyId()) + " balance join T_BD_AccountView account");
        sbSql.append(" on balance.FAccountID = account.FID ");
        sbSql.append(" where account.FIsLeaf = 1");
        sbSql.append(" and balance.FOrgUnitId = ?");
        sbSql.append(" AND ");
        if (periodEnd == null) {
            sbSql.append("balance.FPeriod >= " + (periodBegin.getPeriodYear() * 100 + periodBegin.getPeriodNumber()));
        } else {
            sbSql.append("balance.FPeriod in " + SQLUtil.buildPeriodNumbersInSql(periodBegin.getPeriodYear(), periodBegin.getPeriodNumber(), periodEnd.getPeriodYear(), periodEnd.getPeriodNumber()));
        }
        if (isForCurrency) {
            sbSql.append(" and balance.FCurrencyID = ?");
        }
        if (isCash) {
            sbSql.append(" and (account.FIsCash = 1 or account.FIsBank = 1) ");
        } else {
            sbSql.append(" and account.FIsCashEquivalent = 1");
        }
        if (!isBegin) {
            sbSql.append(" GROUP BY balance.FPeriod ORDER BY balance.FPeriod DESC");
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sbSql.toString());
            int index = 1;
            if (this.selectedCompany != null) {
                ps.setString(index++, this.selectedCompany.getId().toString());
            } else {
                ps.setString(index++, this.curCompany.getId().toString());
            }
            if (isForCurrency) {
                ps.setString(index++, cashFlowFilterPara.getCurrencyId());
            }
            if ((rs = ps.executeQuery()).next()) {
                bdReturn = rs.getBigDecimal("FAmount");
            }
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bdReturn == null ? GlUtils.zero : bdReturn;
    }

    private BigDecimal getAmountFromVoucher(Context ctx, CashFlowFilterPara cashFlowFilterPara, Date begin, Date end, boolean isCash, PeriodInfo beginPeriod) throws BOSException, EASBizException {
        BigDecimal bdReturn = null;
        StringBuffer sbSql = new StringBuffer("Select");
        if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralLocalCurrency())) {
            sbSql.append(" sum(case ve.FEntryDC when 1 then ve.FLocalAmount else (-1) * FLocalAmount end) FAmount");
        } else if (cashFlowFilterPara.getCurrencyId().equals(this.getGeneralReportCurrency())) {
            sbSql.append(" sum(case ve.FEntryDC when 1 then ve.FReportingAmount else (-1) * FReportingAmount end) FAmount");
        } else {
            sbSql.append(" sum(case ve.FEntryDC when 1 then ve.FOriginalAmount else (-1) * FOriginalAmount end) FAmount");
        }
        sbSql.append(" from T_GL_Voucher voucher,T_GL_VoucherEntry ve,T_BD_AccountView account");
        if (beginPeriod.isIsAdjustPeriod()) {
            sbSql.append(" , T_BD_PERIOD period ");
        }
        sbSql.append(" where voucher.FID = ve.FBillID");
        sbSql.append(" and ve.FAccountID = account.FID ");
        if (beginPeriod.isIsAdjustPeriod()) {
            sbSql.append(" and voucher.FPeriodID = period.FID ");
            sbSql.append(" and period.FNUMBER >= ? ");
        }
        sbSql.append(" and voucher.FCompanyID = ?");
        sbSql.append(" and voucher.FBookedDate >= ?");
        sbSql.append(" and voucher.FBookedDate <= ?");
        if (this.isLocalOrReportCurrency(cashFlowFilterPara.getCurrencyId())) {
            sbSql.append(" and ve.FCurrencyID = ?");
        }
        if (isCash) {
            sbSql.append(" and (account.FIsCash = 1 or account.FIsBank = 1) ");
        } else {
            sbSql.append(" and account.FIsCashEquivalent = 1");
        }
        sbSql.append(" and voucher.FBizStatus in(");
        sbSql.append(5);
        if (cashFlowFilterPara.isAllVoucher()) {
            sbSql.append(",");
            sbSql.append(3);
            sbSql.append(",");
            sbSql.append(1);
        }
        sbSql.append(")");
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sbSql.toString());
            int index = 1;
            if (beginPeriod.isIsAdjustPeriod()) {
                ps.setInt(index++, beginPeriod.getNumber());
            }
            ps.setString(index++, this.curCompany.getId().toString());
            ps.setDate(index++, begin);
            ps.setDate(index++, end);
            if (this.isLocalOrReportCurrency(cashFlowFilterPara.getCurrencyId())) {
                ps.setString(index++, cashFlowFilterPara.getCurrencyId());
            }
            rs = ps.executeQuery();
            rs.next();
            bdReturn = rs.getBigDecimal("FAmount");
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bdReturn == null ? GlUtils.zero : bdReturn;
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    private class AmountMapSumTask
    extends SumTask {
        public AmountMapSumTask(Queue workQueue, int partition, Map paramMap) {
            super(workQueue, partition, paramMap);
        }

        @Override
        protected SumTask getNewInstance(Queue workQueue, int partition, Map paramMap) {
            return new AmountMapSumTask(workQueue, partition, paramMap);
        }

        @Override
        protected Map combine(Object leftResult, Object rightResult) {
            Map<String, MapParam> results = new HashMap();
            if (leftResult != null || rightResult == null) {
                // empty if block
            }
            if (leftResult != null && rightResult == null) {
                results = (Map)leftResult;
            } else if (leftResult == null && rightResult != null) {
                results = (Map)rightResult;
            } else {
                results = (Map)leftResult;
                Map rightMap = (Map)rightResult;
                for (String key : rightMap.keySet()) {
                    MapParam m = (MapParam)rightMap.get(key);
                    if (results.containsKey(key)) {
                        MapParam newMap = (MapParam)results.get(key);
                        newMap.FAmount = newMap.FAmount.add(m.FAmount);
                        continue;
                    }
                    results.put(key, m);
                }
            }
            return results;
        }

        @Override
        protected Map doSingleTask(Queue workQueue, Map paramMap) {
            Map result = new HashMap();
            String periodIdsStr = com.kingdee.eas.fi.gl.CashFlowUtils.buildIn(new ArrayList<String>(workQueue));
            int itemType = (Integer)paramMap.get("itemType");
            CashFlowFilterPara cashFlowFilterPara = (CashFlowFilterPara)paramMap.get("cashFlowFilterPara");
            boolean isGL004 = (Boolean)paramMap.get("isGL004");
            try {
                result = CashflowSingleDao.this.doGetSubSumAmountMap(periodIdsStr, itemType, cashFlowFilterPara, isGL004);
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
            return result;
        }
    }

    private class RetainedProfitsSumTask
    extends BigDecimalSumTask {
        public RetainedProfitsSumTask(Queue workQueue, int partition, Map paramMap) {
            super(workQueue, partition, paramMap);
        }

        @Override
        protected BigDecimal doSingleTask(Queue workQueue, Map paramMap) {
            BigDecimal result = BigDecimal.ZERO;
            String periodIdsStr = com.kingdee.eas.fi.gl.CashFlowUtils.buildIn(new ArrayList<String>(workQueue));
            String currencyId = (String)paramMap.get("currencyId");
            String diffAccountSet = (String)paramMap.get("diffAccountSet");
            boolean isAllVoucher = (Boolean)paramMap.get("isAllVoucher");
            try {
                result = CashflowSingleDao.this.doGetSubSumRetainedProfits(periodIdsStr, currencyId, diffAccountSet, isAllVoucher);
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new RuntimeException(e);
            }
            return result == null ? BigDecimal.ZERO : result;
        }

        @Override
        protected SumTask getNewInstance(Queue workQueue, int partition, Map paramMap) {
            return new RetainedProfitsSumTask(workQueue, partition, paramMap);
        }
    }

    class MapParam {
        String FID;
        String FAsstID;
        String FName;
        BigDecimal FAmount;
        CashflowTypeEnum FCashType;
        Integer FIsEnable;

        MapParam() {
        }
    }

    class DBParam {
        String FID;
        String FLOngNumber;
        String FName;
        Integer FLevel;
        Integer FDirection;
        BigDecimal FAmount;
        Integer FIsLeaf;
        Boolean FIsProfit;
        CashFlowItemInfo itemInfo;
        Boolean FIsExchange;
        CashflowTypeEnum FCashType;
        String FLongNameGroup;
        BigDecimal FSum;
        String FAsstID;
        Integer FIsEnable;

        DBParam() {
        }

        void copy(DBParam p) {
            this.FID = p.FID;
            this.FLOngNumber = p.FLOngNumber;
            this.FName = p.FName;
            this.FLevel = p.FLevel;
            this.FDirection = p.FDirection;
            this.FAmount = p.FAmount;
            this.FIsLeaf = p.FIsLeaf;
            this.FIsProfit = p.FIsProfit;
            this.itemInfo = p.itemInfo;
            this.FIsExchange = p.FIsExchange;
            this.FCashType = p.FCashType;
            this.FLongNameGroup = p.FLongNameGroup;
            this.FSum = p.FSum;
            this.FAsstID = p.FAsstID;
            this.FIsEnable = p.FIsEnable;
        }
    }
}

