/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashEntryInfo;
import com.kingdee.eas.fi.gl.CashFlowUtils;
import com.kingdee.eas.fi.gl.CashflowSplitRecordCollection;
import com.kingdee.eas.fi.gl.CashflowSplitRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.ITAccountSplitStrategy;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultTAccountSplitStrategy
implements ITAccountSplitStrategy {
    private static final ITAccountSplitStrategy instance = new DefaultTAccountSplitStrategy();
    private boolean isAutoDispose = false;

    private DefaultTAccountSplitStrategy() {
    }

    public static ITAccountSplitStrategy getInstance() {
        return instance;
    }

    @Override
    public CashflowSplitRecordCollection split(Context ctx, VoucherInfo voucherInfo, Map<String, Object> params) throws EASBizException, BOSException {
        Map voucherMap = CashFlowUtils.getVoucherByNear(ctx, voucherInfo);
        List entries = (List)voucherMap.get("col");
        CashflowSplitRecordCollection result = new CashflowSplitRecordCollection();
        boolean isAllCashAccount = this.isAllCashAccount(entries);
        CompanyOrgUnitInfo curCompany = null;
        Object obj = params.get("CurrentCompany");
        if (obj == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            sic.add(new SelectorItemInfo("reportCurrency.precision"));
            sic.add(new SelectorItemInfo("accountTable.id"));
            sic.add(new SelectorItemInfo("number"));
            curCompany = GlUtils.getCurrentCompany(ctx, voucherInfo.getCompany().getId().toString(), sic, false);
        } else {
            curCompany = (CompanyOrgUnitInfo)obj;
        }
        this.isAutoDispose = GlUtils.getDefaultGLParam(ctx, curCompany.getId().toString(), "GL_0151");
        boolean isOneDebit = (Boolean)voucherMap.get("isOneDebit");
        boolean isOneCredit = (Boolean)voucherMap.get("isOneCredit");
        if (isOneDebit) {
            this.splitWithOneToMany(ctx, true, entries, curCompany, result, isAllCashAccount);
        } else if (isOneCredit) {
            this.splitWithOneToMany(ctx, false, entries, curCompany, result, isAllCashAccount);
        } else {
            this.splitWithNear(ctx, voucherInfo, entries, curCompany, result, true, isAllCashAccount);
            this.splitWithNear(ctx, voucherInfo, entries, curCompany, result, false, isAllCashAccount);
            Iterator iterator = entries.iterator();
            CashEntryInfo entry = null;
            boolean isOver = true;
            while (iterator.hasNext()) {
                entry = (CashEntryInfo)iterator.next();
                if (entry.getLocalAmount().signum() == 0) continue;
                isOver = false;
                break;
            }
            if (!isOver) {
                this.splitWithAmount(ctx, voucherInfo, entries, curCompany, result, isAllCashAccount);
            }
        }
        if (this.isAutoDispose && !isOneDebit && !isOneCredit) {
            this.mergeCashEntry(ctx, result);
        }
        this.mergeCashflowSplitRecordCollection(result);
        return result;
    }

    private void mergeCashEntry(Context ctx, CashflowSplitRecordCollection result) {
        HashMap<String, CashflowSplitRecordCollection> splitMap = new HashMap<String, CashflowSplitRecordCollection>();
        for (int i = 0; i < result.size(); ++i) {
            CashflowSplitRecordInfo splitRecordInfo = result.get(i);
            if (ItemFlag.DISPOSE.equals((Object)splitRecordInfo.getItemFlag())) continue;
            String key = splitRecordInfo.getAccount().getId().toString() + splitRecordInfo.getCurrency().getId().toString();
            if (splitMap.containsKey(key)) {
                ((CashflowSplitRecordCollection)splitMap.get(key)).add(splitRecordInfo);
                continue;
            }
            CashflowSplitRecordCollection splitCol = new CashflowSplitRecordCollection();
            splitCol.add(splitRecordInfo);
            splitMap.put(key, splitCol);
        }
        CashflowSplitRecordCollection disposeCol = new CashflowSplitRecordCollection();
        for (String accCurrency : splitMap.keySet()) {
            CashflowSplitRecordCollection cashSplitCol = (CashflowSplitRecordCollection)splitMap.get(accCurrency);
            ArrayDeque<CashflowSplitRecordInfo> cashDebit = new ArrayDeque<CashflowSplitRecordInfo>();
            ArrayDeque<CashflowSplitRecordInfo> cashCredit = new ArrayDeque<CashflowSplitRecordInfo>();
            BigDecimal totalDebit = GlUtils.zero;
            BigDecimal totalCredit = GlUtils.zero;
            boolean isDebit = true;
            for (int i = 0; i < cashSplitCol.size(); ++i) {
                CashflowSplitRecordInfo cashSplitInfo = cashSplitCol.get(i);
                if (cashSplitInfo.getEntryDC().getValue() == 1) {
                    if (cashDebit.isEmpty()) {
                        cashDebit.add(cashSplitInfo);
                    } else if (cashSplitInfo.getLocalAmount().compareTo(((CashflowSplitRecordInfo)cashDebit.getFirst()).getLocalAmount()) == 1) {
                        cashDebit.addFirst(cashSplitInfo);
                    } else {
                        cashDebit.addLast(cashSplitInfo);
                    }
                    totalDebit = totalDebit.add(cashSplitInfo.getLocalAmount());
                    continue;
                }
                if (cashCredit.isEmpty()) {
                    cashCredit.add(cashSplitInfo);
                } else if (cashSplitInfo.getLocalAmount().compareTo(((CashflowSplitRecordInfo)cashCredit.getFirst()).getLocalAmount()) == 1) {
                    cashCredit.addFirst(cashSplitInfo);
                } else {
                    cashCredit.addLast(cashSplitInfo);
                }
                totalCredit = totalCredit.add(cashSplitInfo.getLocalAmount());
            }
            boolean bl = isDebit = totalDebit.compareTo(totalCredit) != -1;
            if (cashDebit.isEmpty()) {
                isDebit = false;
            }
            if (cashCredit.isEmpty()) {
                isDebit = true;
            }
            if (isDebit) {
                this.autoDispose(ctx, disposeCol, cashDebit, cashCredit);
                continue;
            }
            this.autoDispose(ctx, disposeCol, cashCredit, cashDebit);
        }
        result.addCollection(this.mergeSplitRecordCol(disposeCol));
        BigDecimal zeroAmt = GlUtils.zero;
        for (int index = result.size() - 1; index >= 0; --index) {
            CashflowSplitRecordInfo splitRecordInfo = result.get(index);
            if (splitRecordInfo.getOriginalAmount().compareTo(zeroAmt) != 0 || splitRecordInfo.getLocalAmount().compareTo(zeroAmt) != 0 || splitRecordInfo.getReportingAmount().compareTo(zeroAmt) != 0) continue;
            result.removeObject(index);
        }
    }

    private void autoDispose(Context ctx, CashflowSplitRecordCollection disposeCol, Deque<CashflowSplitRecordInfo> cashDebit, Deque<CashflowSplitRecordInfo> cashCredit) {
        CashflowSplitRecordInfo target = cashDebit.pollFirst();
        while (!cashDebit.isEmpty()) {
            CashflowSplitRecordInfo splitRecordInfo = cashDebit.pollFirst();
            disposeCol.add(this.createDisposeSplitRecord(ctx, target, splitRecordInfo, new BigDecimal[]{splitRecordInfo.getOriginalAmount().negate(), splitRecordInfo.getLocalAmount().negate(), splitRecordInfo.getReportingAmount().negate()}));
            disposeCol.add(this.createDisposeSplitRecord(ctx, splitRecordInfo, target, new BigDecimal[]{splitRecordInfo.getOriginalAmount(), splitRecordInfo.getLocalAmount(), splitRecordInfo.getReportingAmount()}));
            splitRecordInfo.setEntry(target.getEntry());
            splitRecordInfo.setEntryDC(target.getEntryDC());
            splitRecordInfo.setAccount(target.getAccount());
        }
        CashflowSplitRecordCollection modifiedCol = new CashflowSplitRecordCollection();
        while (!cashCredit.isEmpty()) {
            CashflowSplitRecordInfo splitRecordInfo = cashCredit.pollFirst();
            disposeCol.add(this.createDisposeSplitRecord(ctx, target, splitRecordInfo, new BigDecimal[]{splitRecordInfo.getOriginalAmount(), splitRecordInfo.getLocalAmount(), splitRecordInfo.getReportingAmount()}));
            disposeCol.add(this.createDisposeSplitRecord(ctx, splitRecordInfo, target, new BigDecimal[]{splitRecordInfo.getOriginalAmount(), splitRecordInfo.getLocalAmount(), splitRecordInfo.getReportingAmount()}));
            splitRecordInfo.setEntry(target.getEntry());
            splitRecordInfo.setEntryDC(target.getEntryDC());
            splitRecordInfo.setAccount(target.getAccount());
            splitRecordInfo.setOriginalAmount(splitRecordInfo.getOriginalAmount().negate());
            splitRecordInfo.setLocalAmount(splitRecordInfo.getLocalAmount().negate());
            splitRecordInfo.setReportingAmount(splitRecordInfo.getReportingAmount().negate());
            modifiedCol.add(splitRecordInfo);
        }
        if (!modifiedCol.isEmpty()) {
            this.mergeSplitRecordCol(modifiedCol);
        }
    }

    private void mergeCashEntry2(Context ctx, CashflowSplitRecordCollection result) {
        BigDecimal[] disposeAmt;
        EntryDC antiEntryDC;
        String antiCurrency;
        String antiAccId;
        CashflowSplitRecordInfo antiSplitRecordInfo;
        int j;
        EntryDC entryDC;
        String currency;
        String accId;
        CashflowSplitRecordInfo splitRecordInfo;
        int i;
        CashflowSplitRecordCollection disposeCol = new CashflowSplitRecordCollection();
        BigDecimal[] zeroAmt = new BigDecimal[]{GlUtils.zero, GlUtils.zero, GlUtils.zero};
        block0: for (i = 0; i < result.size(); ++i) {
            splitRecordInfo = result.get(i);
            if (splitRecordInfo.getItemFlag() == ItemFlag.DISPOSE || splitRecordInfo.getLocalAmount().compareTo(GlUtils.zero) == 0) continue;
            accId = splitRecordInfo.getAccount().getId().toString();
            currency = splitRecordInfo.getCurrency().getId().toString();
            entryDC = splitRecordInfo.getEntryDC();
            for (j = 0; j < result.size(); ++j) {
                if (i == j || (antiSplitRecordInfo = result.get(j)).getItemFlag() == ItemFlag.DISPOSE || antiSplitRecordInfo.getLocalAmount().compareTo(GlUtils.zero) == 0 || antiSplitRecordInfo.getEntry().getSeq() == splitRecordInfo.getEntry().getSeq()) continue;
                antiAccId = antiSplitRecordInfo.getAccount().getId().toString();
                antiCurrency = antiSplitRecordInfo.getCurrency().getId().toString();
                antiEntryDC = antiSplitRecordInfo.getEntryDC();
                if (entryDC == antiEntryDC || !(accId + currency).equals(antiAccId + antiCurrency)) continue;
                disposeAmt = zeroAmt;
                if (antiSplitRecordInfo.getLocalAmount().compareTo(splitRecordInfo.getLocalAmount()) < 0) {
                    disposeAmt = new BigDecimal[]{antiSplitRecordInfo.getOriginalAmount(), antiSplitRecordInfo.getLocalAmount(), antiSplitRecordInfo.getReportingAmount()};
                    disposeCol.add(this.createDisposeSplitRecord(ctx, splitRecordInfo, antiSplitRecordInfo, disposeAmt));
                    disposeCol.add(this.createDisposeSplitRecord(ctx, antiSplitRecordInfo, splitRecordInfo, disposeAmt));
                    antiSplitRecordInfo.setEntry(splitRecordInfo.getEntry());
                    antiSplitRecordInfo.setAccount(splitRecordInfo.getAccount());
                    antiSplitRecordInfo.setEntryDC(splitRecordInfo.getEntryDC());
                    antiSplitRecordInfo.setOriginalAmount(antiSplitRecordInfo.getOriginalAmount().negate());
                    antiSplitRecordInfo.setLocalAmount(antiSplitRecordInfo.getLocalAmount().negate());
                    antiSplitRecordInfo.setReportingAmount(antiSplitRecordInfo.getReportingAmount().negate());
                    continue block0;
                }
                disposeAmt = new BigDecimal[]{splitRecordInfo.getOriginalAmount(), splitRecordInfo.getLocalAmount(), splitRecordInfo.getReportingAmount()};
                disposeCol.add(this.createDisposeSplitRecord(ctx, splitRecordInfo, antiSplitRecordInfo, disposeAmt));
                disposeCol.add(this.createDisposeSplitRecord(ctx, antiSplitRecordInfo, splitRecordInfo, disposeAmt));
                splitRecordInfo.setEntry(antiSplitRecordInfo.getEntry());
                splitRecordInfo.setAccount(antiSplitRecordInfo.getAccount());
                splitRecordInfo.setEntryDC(antiSplitRecordInfo.getEntryDC());
                splitRecordInfo.setOriginalAmount(splitRecordInfo.getOriginalAmount().negate());
                splitRecordInfo.setLocalAmount(splitRecordInfo.getLocalAmount().negate());
                splitRecordInfo.setReportingAmount(splitRecordInfo.getReportingAmount().negate());
                continue block0;
            }
        }
        block2: for (i = 0; i < result.size(); ++i) {
            splitRecordInfo = result.get(i);
            if (splitRecordInfo.getItemFlag() == ItemFlag.DISPOSE || splitRecordInfo.getLocalAmount().compareTo(GlUtils.zero) == 0) continue;
            accId = splitRecordInfo.getAccount().getId().toString();
            currency = splitRecordInfo.getCurrency().getId().toString();
            entryDC = splitRecordInfo.getEntryDC();
            for (j = 0; j < result.size(); ++j) {
                if (i == j || (antiSplitRecordInfo = result.get(j)).getItemFlag() == ItemFlag.DISPOSE || antiSplitRecordInfo.getLocalAmount().compareTo(GlUtils.zero) == 0 || antiSplitRecordInfo.getEntry().getSeq() == splitRecordInfo.getEntry().getSeq()) continue;
                antiAccId = antiSplitRecordInfo.getAccount().getId().toString();
                antiCurrency = antiSplitRecordInfo.getCurrency().getId().toString();
                antiEntryDC = antiSplitRecordInfo.getEntryDC();
                if (entryDC != antiEntryDC || !(accId + currency).equals(antiAccId + antiCurrency)) continue;
                disposeAmt = zeroAmt;
                BigDecimal[] disposeNegateAmt = zeroAmt;
                if (antiSplitRecordInfo.getLocalAmount().compareTo(splitRecordInfo.getLocalAmount()) < 0) {
                    disposeAmt = new BigDecimal[]{antiSplitRecordInfo.getOriginalAmount(), antiSplitRecordInfo.getLocalAmount(), antiSplitRecordInfo.getReportingAmount()};
                    disposeNegateAmt = new BigDecimal[]{disposeAmt[0].negate(), disposeAmt[1].negate(), disposeAmt[2].negate()};
                    disposeCol.add(this.createDisposeSplitRecord(ctx, splitRecordInfo, antiSplitRecordInfo, disposeNegateAmt));
                    disposeCol.add(this.createDisposeSplitRecord(ctx, antiSplitRecordInfo, splitRecordInfo, disposeAmt));
                    antiSplitRecordInfo.setEntry(splitRecordInfo.getEntry());
                    antiSplitRecordInfo.setAccount(splitRecordInfo.getAccount());
                    antiSplitRecordInfo.setEntryDC(splitRecordInfo.getEntryDC());
                    continue block2;
                }
                disposeAmt = new BigDecimal[]{splitRecordInfo.getOriginalAmount(), splitRecordInfo.getLocalAmount(), splitRecordInfo.getReportingAmount()};
                disposeNegateAmt = new BigDecimal[]{disposeAmt[0].negate(), disposeAmt[1].negate(), disposeAmt[2].negate()};
                disposeCol.add(this.createDisposeSplitRecord(ctx, splitRecordInfo, antiSplitRecordInfo, disposeAmt));
                disposeCol.add(this.createDisposeSplitRecord(ctx, antiSplitRecordInfo, splitRecordInfo, disposeNegateAmt));
                splitRecordInfo.setEntry(antiSplitRecordInfo.getEntry());
                splitRecordInfo.setAccount(antiSplitRecordInfo.getAccount());
                splitRecordInfo.setEntryDC(antiSplitRecordInfo.getEntryDC());
                continue block2;
            }
        }
        result.addCollection(this.mergeSplitRecordCol(disposeCol));
        for (int index = result.size() - 1; index >= 0; --index) {
            splitRecordInfo = result.get(index);
            if (splitRecordInfo.getOriginalAmount().compareTo(zeroAmt[0]) != 0 || splitRecordInfo.getLocalAmount().compareTo(zeroAmt[1]) != 0 || splitRecordInfo.getReportingAmount().compareTo(zeroAmt[2]) != 0) continue;
            result.removeObject(index);
        }
    }

    private CashflowSplitRecordCollection mergeSplitRecordCol(CashflowSplitRecordCollection splitRecordCol) {
        CashflowSplitRecordCollection tempCol = new CashflowSplitRecordCollection();
        for (int i = 0; i < splitRecordCol.size(); ++i) {
            CashflowSplitRecordInfo record = splitRecordCol.get(i);
            boolean found = false;
            for (int j = 0; j < tempCol.size(); ++j) {
                CashflowSplitRecordInfo splitRecord = tempCol.get(j);
                if (record.getEntry() != splitRecord.getEntry()) continue;
                splitRecord.setLocalAmount(splitRecord.getLocalAmount().add(record.getLocalAmount()));
                splitRecord.setOriginalAmount(splitRecord.getOriginalAmount().add(record.getOriginalAmount()));
                splitRecord.setReportingAmount(splitRecord.getReportingAmount().add(record.getReportingAmount()));
                found = true;
                break;
            }
            if (found) continue;
            tempCol.add(record);
        }
        return tempCol;
    }

    private CashflowSplitRecordInfo createDisposeSplitRecord(Context ctx, CashflowSplitRecordInfo splitRecordInfo, CashflowSplitRecordInfo antiSplitRecordInfo, BigDecimal[] disposeAmt) {
        CashflowSplitRecordInfo splitRecord = new CashflowSplitRecordInfo();
        splitRecord.setVoucher(splitRecordInfo.getVoucher());
        splitRecord.setEntry(splitRecordInfo.getEntry());
        splitRecord.setAccount(splitRecordInfo.getAccount());
        splitRecord.setCurrency(splitRecordInfo.getCurrency());
        splitRecord.setEntryDC(splitRecordInfo.getEntryDC());
        splitRecord.setOpposingAccountEntry(antiSplitRecordInfo.getEntry());
        splitRecord.setOppAccount(antiSplitRecordInfo.getAccount());
        splitRecord.setOppEntryDC(antiSplitRecordInfo.getEntryDC());
        splitRecord.setOriginalAmount(disposeAmt[0]);
        splitRecord.setLocalAmount(disposeAmt[1]);
        splitRecord.setReportingAmount(disposeAmt[2]);
        splitRecord.setIsSupItem(false);
        splitRecord.setSourceType(1);
        splitRecord.setItemFlag(ItemFlag.DISPOSE);
        Timestamp nowTime = new Timestamp(System.currentTimeMillis());
        splitRecord.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        splitRecord.setCreateTime(nowTime);
        splitRecord.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        splitRecord.setLastUpdateTime(nowTime);
        return splitRecord;
    }

    private void splitWithOneToMany(Context ctx, boolean isDebitOneToMany, List entries, CompanyOrgUnitInfo curCompany, CashflowSplitRecordCollection resultCollector, boolean isAllCashAccount) throws EASBizException, BOSException {
        CashEntryInfo cashEntry = null;
        ArrayList<CashEntryInfo> tempEntryCol = new ArrayList<CashEntryInfo>();
        if (isDebitOneToMany) {
            CashEntryInfo entry = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = (CashEntryInfo)entries.get(i);
                if (entry.getEntryDC().getValue() == 0) {
                    tempEntryCol.add(entry);
                    continue;
                }
                cashEntry = entry;
            }
        } else {
            CashEntryInfo entry = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = (CashEntryInfo)entries.get(i);
                if (entry.getEntryDC().getValue() == 1) {
                    tempEntryCol.add(entry);
                    continue;
                }
                cashEntry = entry;
            }
        }
        this.dealOneToMany(ctx, cashEntry, tempEntryCol, curCompany, resultCollector, isAllCashAccount);
    }

    private void splitWithNear(Context ctx, VoucherInfo voucherInfo, List entries, CompanyOrgUnitInfo company, CashflowSplitRecordCollection resultCollector, boolean DToC, boolean isAllCashAccount) throws EASBizException, BOSException {
        List enCol1 = entries;
        int enCount2 = entries.size();
        boolean isAllSpit = true;
        while (isAllSpit) {
            CashEntryInfo entry;
            int j;
            ArrayList<CashEntryInfo> tempEntryCol;
            BigDecimal sum;
            boolean isCR;
            CashEntryInfo entry1;
            boolean isSpit;
            int i;
            isAllSpit = false;
            int enCount = enCol1.size();
            for (i = 0; i >= 0 && i < enCount; ++i) {
                isSpit = false;
                entry1 = (CashEntryInfo)enCol1.get(i);
                boolean bl = isCR = entry1.getEntryDC().getValue() == 0;
                if (!DToC) {
                    isCR = !isCR;
                }
                sum = GlUtils.zero;
                tempEntryCol = new ArrayList<CashEntryInfo>();
                if (entry1.getLocalAmount().signum() == 0) continue;
                int n = j = isCR ? i - 1 : i + 1;
                while (j >= 0 && j < enCount2) {
                    entry = (CashEntryInfo)entries.get(j);
                    j = isCR ? --j : ++j;
                    if (entry.getLocalAmount().signum() == 0) continue;
                    if (entry1.getEntryDC().getValue() == entry.getEntryDC().getValue()) {
                        if (entry1.getLocalAmount().compareTo(sum) != 0) break;
                        if (CashFlowUtils.isCashAccount(entry1.getAccount()) && !this.hasCashAccount(tempEntryCol)) {
                            this.dealOneToMany(ctx, entry1, tempEntryCol, company, resultCollector, isAllCashAccount);
                        } else {
                            tempEntryCol.add(entry1);
                            if (!this.splitWithAmount(ctx, voucherInfo, tempEntryCol, company, resultCollector, isAllCashAccount)) continue;
                        }
                        isSpit = true;
                        isAllSpit = true;
                        if (isCR) break;
                        i = j - 2;
                        break;
                    }
                    tempEntryCol.add(entry);
                    sum = sum.add(entry.getLocalAmount());
                }
                if (!isSpit || i != enCount - 1) continue;
                i = 1;
            }
            enCount = enCol1.size();
            for (i = 0; i >= 0 && i < enCount; ++i) {
                isSpit = false;
                entry1 = (CashEntryInfo)enCol1.get(i);
                boolean bl = isCR = entry1.getEntryDC().getValue() == 0;
                if (!DToC) {
                    isCR = !isCR;
                }
                sum = GlUtils.zero;
                tempEntryCol = new ArrayList();
                if (entry1.getLocalAmount().signum() == 0) continue;
                int n = j = isCR ? i - 1 : i + 1;
                while (j >= 0 && j < enCount2) {
                    entry = (CashEntryInfo)entries.get(j);
                    j = isCR ? --j : ++j;
                    if (entry.getLocalAmount().signum() == 0) continue;
                    if (entry1.getEntryDC().getValue() == entry.getEntryDC().getValue()) break;
                    tempEntryCol.add(entry);
                    sum = sum.add(entry.getLocalAmount());
                    if (entry1.getLocalAmount().compareTo(sum) == 0) {
                        if (CashFlowUtils.isCashAccount(entry1.getAccount()) && !this.hasCashAccount(tempEntryCol)) {
                            this.dealOneToMany(ctx, entry1, tempEntryCol, company, resultCollector, isAllCashAccount);
                        } else {
                            tempEntryCol.add(entry1);
                            if (!this.splitWithAmount(ctx, voucherInfo, tempEntryCol, company, resultCollector, isAllCashAccount)) continue;
                        }
                        isSpit = true;
                        isAllSpit = true;
                        if (isCR) break;
                        i = j;
                        break;
                    }
                    if (!(entry1.getLocalAmount().signum() > 0 ? entry1.getLocalAmount().compareTo(sum) < 0 : entry1.getLocalAmount().compareTo(sum) > 0)) continue;
                }
                if (!isSpit || i != enCount - 1) continue;
                i = 1;
            }
        }
    }

    private boolean splitWithAmount(Context ctx, VoucherInfo voucherInfo, List enCol, CompanyOrgUnitInfo company, CashflowSplitRecordCollection resultCollector, boolean isAllCashAccount) throws EASBizException, BOSException {
        CashEntryInfo entry;
        CashEntryInfo cashEntry = null;
        int enCount2 = enCol.size();
        this.sortByAmount(enCol);
        Iterator iterator = enCol.iterator();
        ArrayList<CashEntryInfo> cashEntries = new ArrayList<CashEntryInfo>();
        while (iterator.hasNext()) {
            entry = (CashEntryInfo)iterator.next();
            if (!CashFlowUtils.isCashAccount(entry.getAccount()) || entry.getLocalAmount().signum() == 0) continue;
            cashEntries.add(entry);
        }
        if (cashEntries.size() == 0) {
            int size = enCol.size();
            for (int i = 0; i < size; ++i) {
                entry = (CashEntryInfo)enCol.get(i);
                entry.setLocalAmount(GlUtils.zero);
            }
            return true;
        }
        int enCount = cashEntries.size();
        block2: for (int i = 0; i < enCount; ++i) {
            int localSignum;
            int j;
            int tempSeq;
            int j2;
            cashEntry = (CashEntryInfo)cashEntries.get(i);
            boolean isContinue = false;
            this.sortByAmount(enCol);
            BigDecimal cashLocal = cashEntry.getLocalAmount();
            int cashLocalSignum = cashLocal.signum();
            if (cashLocal.signum() == 0) continue;
            boolean isCR = cashEntry.getEntryDC().getValue() == 0;
            int seqSub = Integer.MAX_VALUE;
            CashEntryInfo tempEntry = null;
            for (j2 = 0; j2 < enCount2; ++j2) {
                entry = (CashEntryInfo)enCol.get(j2);
                if (entry.getLocalAmount().signum() == 0 || CashFlowUtils.isCashAccount(entry.getAccount()) || cashEntry.getEntryDC().getValue() == entry.getEntryDC().getValue() || cashEntry.getLocalAmount().compareTo(entry.getLocalAmount()) != 0) continue;
                tempSeq = cashEntry.getSeq() - entry.getSeq();
                if (Math.abs(tempSeq) < Math.abs(seqSub) || Math.abs(tempSeq) == Math.abs(seqSub) && (isCR ? tempSeq > 0 : tempSeq < 0)) {
                    seqSub = tempSeq;
                    tempEntry = entry;
                }
                isContinue = true;
            }
            if (isContinue) {
                this.dealNormalVoucher(ctx, cashEntry, tempEntry, company, resultCollector, isAllCashAccount);
                continue;
            }
            seqSub = Integer.MAX_VALUE;
            for (j2 = 0; j2 < enCount2; ++j2) {
                entry = (CashEntryInfo)enCol.get(j2);
                if (entry.getLocalAmount().signum() == 0 || CashFlowUtils.isCashAccount(entry.getAccount()) || cashEntry.getEntryDC().getValue() != entry.getEntryDC().getValue() || !cashEntry.getLocalAmount().equals(entry.getLocalAmount().negate())) continue;
                tempSeq = cashEntry.getSeq() - entry.getSeq();
                if (Math.abs(tempSeq) < Math.abs(seqSub) || Math.abs(tempSeq) == Math.abs(seqSub) && (isCR ? tempSeq > 0 : tempSeq < 0)) {
                    seqSub = tempSeq;
                    tempEntry = entry;
                }
                isContinue = true;
            }
            if (isContinue) {
                this.dealSingleVoucherByAdmount(ctx, cashEntry, tempEntry, company, resultCollector, isAllCashAccount);
                continue;
            }
            BigDecimal local = GlUtils.zero;
            BigDecimal subAmount = GlUtils.zero;
            seqSub = Integer.MAX_VALUE;
            for (j = 0; j < enCount2; ++j) {
                entry = (CashEntryInfo)enCol.get(j);
                local = entry.getLocalAmount();
                localSignum = local.signum();
                if (entry.getLocalAmount().signum() == 0 || CashFlowUtils.isCashAccount(entry.getAccount()) || cashEntry.getEntryDC().getValue() == entry.getEntryDC().getValue() || cashLocalSignum != localSignum) continue;
                int tempSeq2 = cashEntry.getSeq() - entry.getSeq();
                if (subAmount.signum() != 0 && subAmount.compareTo(local.subtract(cashLocal)) != 0) break;
                subAmount = local.subtract(cashLocal);
                if (Math.abs(tempSeq2) < Math.abs(seqSub) || Math.abs(tempSeq2) == Math.abs(seqSub) && (isCR ? tempSeq2 > 0 : tempSeq2 < 0)) {
                    seqSub = tempSeq2;
                    tempEntry = entry;
                }
                isContinue = true;
            }
            if (isContinue) {
                this.dealNormalVoucher(ctx, cashEntry, tempEntry, company, resultCollector, isAllCashAccount);
                if (cashEntry.getLocalAmount().signum() == 0) continue;
                --i;
                continue;
            }
            for (j = 0; j < enCount2; ++j) {
                entry = (CashEntryInfo)enCol.get(j);
                local = entry.getLocalAmount();
                localSignum = local.signum();
                if (localSignum == 0 || cashLocalSignum == 0 || CashFlowUtils.isCashAccount(entry.getAccount()) || cashEntry.getEntryDC().getValue() != entry.getEntryDC().getValue() || cashLocalSignum == localSignum) continue;
                this.dealSingleVoucherByAdmount(ctx, cashEntry, entry, company, resultCollector, isAllCashAccount);
                if (cashEntry.getLocalAmount().signum() != 0) {
                    --i;
                }
                isContinue = true;
                break;
            }
            if (isContinue) continue;
            if (!this.isAutoDispose && !isAllCashAccount) {
                if (this.isAllCashAccount(enCol)) {
                    return false;
                }
                for (j = 0; j < enCount2; ++j) {
                    entry = (CashEntryInfo)enCol.get(j);
                    local = entry.getLocalAmount();
                    if (cashLocalSignum == 0 || CashFlowUtils.isCashAccount(entry.getAccount()) || cashEntry.getEntryDC().getValue() == entry.getEntryDC().getValue()) continue;
                    entry.setLocalAmount(cashEntry.getLocalAmount());
                    entry.setOriginalAmount(cashEntry.getOriginalAmount());
                    entry.setReportingAmount(cashEntry.getReportingAmount());
                    if (entry.getAssistCol() != null && entry.getAssistCol().size() > 0) {
                        for (CashEntryInfo assistRecord : entry.getAssistCol()) {
                            if (assistRecord.getVoucherAssistEntry() == null || assistRecord.getVoucherAssistEntry().getSeq() != 1) continue;
                            assistRecord.setLocalAmount(cashEntry.getLocalAmount());
                            assistRecord.setOriginalAmount(cashEntry.getOriginalAmount());
                            assistRecord.setReportingAmount(cashEntry.getReportingAmount());
                            break;
                        }
                    }
                    this.dealNormalVoucher(ctx, cashEntry, entry, company, resultCollector, isAllCashAccount);
                    isContinue = true;
                    break;
                }
                if (isContinue) continue;
                for (j = 0; j < enCount2; ++j) {
                    entry = (CashEntryInfo)enCol.get(j);
                    local = entry.getLocalAmount();
                    if (cashLocalSignum == 0 || CashFlowUtils.isCashAccount(entry.getAccount()) || cashEntry.getEntryDC().getValue() != entry.getEntryDC().getValue() || cashEntry.getSeq() == entry.getSeq()) continue;
                    entry.setLocalAmount(cashEntry.getLocalAmount().multiply(GlUtils.negone));
                    entry.setOriginalAmount(cashEntry.getOriginalAmount().multiply(GlUtils.negone));
                    entry.setReportingAmount(cashEntry.getReportingAmount().multiply(GlUtils.negone));
                    if (entry.getAssistCol() != null && entry.getAssistCol().size() > 0) {
                        for (CashEntryInfo assistRecord : entry.getAssistCol()) {
                            if (assistRecord.getVoucherAssistEntry() == null || assistRecord.getVoucherAssistEntry().getSeq() != 1) continue;
                            assistRecord.setLocalAmount(cashEntry.getLocalAmount().multiply(GlUtils.negone));
                            assistRecord.setOriginalAmount(cashEntry.getOriginalAmount().multiply(GlUtils.negone));
                            assistRecord.setReportingAmount(cashEntry.getReportingAmount().multiply(GlUtils.negone));
                            break;
                        }
                    }
                    this.dealSingleVoucherByAdmount(ctx, cashEntry, entry, company, resultCollector, isAllCashAccount);
                    continue block2;
                }
                continue;
            }
            for (j = 0; j < enCount2; ++j) {
                entry = (CashEntryInfo)enCol.get(j);
                if (entry.getLocalAmount().signum() == 0) continue;
                local = entry.getLocalAmount();
                localSignum = local.signum();
                if (cashEntry.getEntryDC().getValue() == entry.getEntryDC().getValue() || cashLocalSignum != localSignum) continue;
                this.dealNormalVoucher(ctx, cashEntry, entry, company, resultCollector, isAllCashAccount);
                if (cashEntry.getLocalAmount().signum() != 0) {
                    --i;
                }
                isContinue = true;
                break;
            }
            if (isContinue) continue;
            for (j = 0; j < enCount2; ++j) {
                entry = (CashEntryInfo)enCol.get(j);
                local = entry.getLocalAmount();
                localSignum = local.signum();
                if (localSignum == 0 || cashLocalSignum == 0 || cashEntry.getEntryDC().getValue() != entry.getEntryDC().getValue() || cashEntry.getSeq() == entry.getSeq() || cashLocalSignum == localSignum) continue;
                this.dealSingleVoucherByAdmount(ctx, cashEntry, entry, company, resultCollector, isAllCashAccount);
                if (cashEntry.getLocalAmount().signum() == 0) continue block2;
                --i;
                continue block2;
            }
        }
        return true;
    }

    private void dealOneToMany(Context ctx, CashEntryInfo cashEntry, List entries, CompanyOrgUnitInfo company, CashflowSplitRecordCollection resultCollector, boolean isAllCashAccount) throws EASBizException, BOSException {
        if (cashEntry.getLocalAmount().abs().signum() == 0 && cashEntry.getReportingAmount().abs().signum() == 0) {
            return;
        }
        String cashEntryCurrencyId = cashEntry.getCurrency().getId().toString();
        String entryCurrencyId = null;
        BigDecimal allOppAmnt = BigDecimal.ZERO;
        BigDecimal origAmt = null;
        BigDecimal[] amt = null;
        CashEntryInfo entry = null;
        final String oriCur = cashEntry.getCurrency().getId().toString();
        Collections.sort(entries, new Comparator<CashEntryInfo>(){

            @Override
            public int compare(CashEntryInfo o1, CashEntryInfo o2) {
                String cur2;
                String cur1 = o1.getCurrency().getId().toString();
                if (cur1.equalsIgnoreCase(cur2 = o2.getCurrency().getId().toString())) {
                    return 0;
                }
                if (cur1.equalsIgnoreCase(oriCur)) {
                    return -1;
                }
                if (cur2.equalsIgnoreCase(oriCur)) {
                    return 1;
                }
                return 0;
            }
        });
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (CashEntryInfo)entries.get(i);
            entryCurrencyId = entry.getCurrency().getId().toString();
            boolean isCurrencySame = entryCurrencyId.equals(cashEntryCurrencyId);
            if (isCurrencySame) {
                origAmt = entry.getOriginalAmount();
                allOppAmnt = allOppAmnt.add(origAmt);
            } else if (allOppAmnt.compareTo(cashEntry.getOriginalAmount()) != 0) {
                origAmt = cashEntry.getLocalAmount().abs().signum() != 0 ? cashEntry.getOriginalAmount().multiply(entry.getLocalAmount().abs().divide(cashEntry.getLocalAmount().abs(), 28, 4)) : cashEntry.getOriginalAmount().multiply(entry.getReportingAmount().abs().divide(cashEntry.getReportingAmount().abs(), 28, 4));
                origAmt = origAmt.setScale(cashEntry.getCurrency().getPrecision(), 4);
            } else {
                origAmt = BigDecimal.ZERO;
            }
            amt = new BigDecimal[]{origAmt, entry.getLocalAmount(), entry.getReportingAmount()};
            this.collectByAmount(ctx, cashEntry, entry, company, amt, false, resultCollector, isAllCashAccount);
            entry.setLocalAmount(GlUtils.zero);
        }
        cashEntry.setLocalAmount(GlUtils.zero);
    }

    private void dealSingleVoucherByAdmount(Context ctx, CashEntryInfo cashEntry, CashEntryInfo entry, CompanyOrgUnitInfo company, CashflowSplitRecordCollection resultCollector, boolean isAllCashAccount) throws EASBizException, BOSException {
        BigDecimal entryLocal = entry.getLocalAmount();
        BigDecimal cashEntryLocal = cashEntry.getLocalAmount();
        BigDecimal cashEntrySignum = cashEntryLocal.signum() == 1 ? GlUtils.one : GlUtils.negone;
        BigDecimal[] amt = null;
        boolean isCurrencySame = cashEntry.getCurrency().getId().toString().equals(entry.getCurrency().getId().toString());
        boolean isCashSplit = entryLocal.abs().compareTo(cashEntryLocal.abs()) >= 0 && (this.isAutoDispose || isAllCashAccount);
        BigDecimal origAmt = null;
        if (isCashSplit) {
            amt = new BigDecimal[]{cashEntry.getOriginalAmount(), cashEntry.getLocalAmount(), cashEntry.getReportingAmount()};
        } else {
            if (!isCurrencySame) {
                origAmt = cashEntry.getOriginalAmount().multiply(entry.getLocalAmount().abs().divide(cashEntry.getLocalAmount().abs(), 28, 4));
                origAmt = origAmt.setScale(cashEntry.getCurrency().getPrecision(), 4);
            } else {
                origAmt = entry.getOriginalAmount().abs().multiply(cashEntrySignum);
            }
            amt = new BigDecimal[]{origAmt, entry.getLocalAmount().abs().multiply(cashEntrySignum), entry.getReportingAmount().abs().multiply(cashEntrySignum)};
        }
        this.collectByAmount(ctx, cashEntry, entry, company, amt, true, resultCollector, isAllCashAccount);
        if (isCashSplit) {
            if (!isCurrencySame) {
                origAmt = entry.getOriginalAmount().abs().multiply(cashEntry.getLocalAmount().abs().divide(entry.getLocalAmount().abs(), 28, 4)).multiply(cashEntrySignum);
                origAmt = origAmt.setScale(entry.getCurrency().getPrecision(), 4);
            } else {
                origAmt = cashEntry.getOriginalAmount();
            }
            entry.setOriginalAmount(entry.getOriginalAmount().add(origAmt));
            entry.setLocalAmount(entry.getLocalAmount().add(cashEntry.getLocalAmount()));
            entry.setReportingAmount(entry.getReportingAmount().add(cashEntry.getReportingAmount()));
            cashEntry.setLocalAmount(GlUtils.zero);
        } else {
            cashEntry.setOriginalAmount(cashEntry.getOriginalAmount().subtract(origAmt));
            cashEntry.setLocalAmount(cashEntry.getLocalAmount().add(entry.getLocalAmount()));
            cashEntry.setReportingAmount(cashEntry.getReportingAmount().add(entry.getReportingAmount()));
            entry.setLocalAmount(GlUtils.zero);
        }
    }

    private void dealNormalVoucher(Context ctx, CashEntryInfo cashEntry, CashEntryInfo entry, CompanyOrgUnitInfo company, CashflowSplitRecordCollection resultCollector, boolean isAllCashAccount) throws EASBizException, BOSException {
        BigDecimal entryLocalAmt = entry.getLocalAmount();
        BigDecimal cashEntryLocalAmt = cashEntry.getLocalAmount();
        BigDecimal entrySignum = entryLocalAmt.signum() == 1 ? GlUtils.one : GlUtils.negone;
        BigDecimal cashEntrySignum = cashEntryLocalAmt.signum() == 1 ? GlUtils.one : GlUtils.negone;
        BigDecimal origAmt = null;
        boolean isCashSplit = entryLocalAmt.compareTo(cashEntryLocalAmt) > 0 && (entryLocalAmt.signum() > 0 || cashEntryLocalAmt.signum() > 0) || entryLocalAmt.compareTo(cashEntryLocalAmt) < 0 && entryLocalAmt.signum() < 0 && cashEntryLocalAmt.signum() < 0;
        boolean isCurrencySame = cashEntry.getCurrency().getId().toString().equals(entry.getCurrency().getId().toString());
        BigDecimal[] amt = null;
        if (isCashSplit) {
            amt = new BigDecimal[]{cashEntry.getOriginalAmount(), cashEntry.getLocalAmount(), cashEntry.getReportingAmount()};
        } else {
            if (!isCurrencySame) {
                origAmt = cashEntry.getOriginalAmount().abs().multiply(entry.getLocalAmount().abs().divide(cashEntry.getLocalAmount().abs(), 28, 4)).multiply(entrySignum);
                origAmt = origAmt.setScale(cashEntry.getCurrency().getPrecision(), 4);
            } else {
                origAmt = entry.getOriginalAmount();
            }
            amt = new BigDecimal[]{origAmt, entry.getLocalAmount(), entry.getReportingAmount()};
        }
        this.collectByAmount(ctx, cashEntry, entry, company, amt, false, resultCollector, isAllCashAccount);
        if (isCashSplit) {
            if (!isCurrencySame) {
                origAmt = entry.getOriginalAmount().abs().multiply(cashEntry.getLocalAmount().abs().divide(entry.getLocalAmount().abs(), 28, 4)).multiply(cashEntrySignum);
                origAmt = origAmt.setScale(entry.getCurrency().getPrecision(), 4);
            } else {
                origAmt = cashEntry.getOriginalAmount();
            }
            entry.setOriginalAmount(entry.getOriginalAmount().subtract(origAmt));
            entry.setLocalAmount(entry.getLocalAmount().subtract(cashEntry.getLocalAmount()));
            entry.setReportingAmount(entry.getReportingAmount().subtract(cashEntry.getReportingAmount()));
            cashEntry.setLocalAmount(GlUtils.zero);
        } else {
            cashEntry.setOriginalAmount(cashEntry.getOriginalAmount().subtract(origAmt));
            cashEntry.setLocalAmount(cashEntry.getLocalAmount().subtract(entry.getLocalAmount()));
            cashEntry.setReportingAmount(cashEntry.getReportingAmount().subtract(entry.getReportingAmount()));
            entry.setLocalAmount(GlUtils.zero);
        }
    }

    private void sortByAmount(List enCol) {
        Collections.sort(enCol, new Comparator(){

            public int compare(Object o1, Object o2) {
                CashEntryInfo entry = (CashEntryInfo)o1;
                CashEntryInfo entry1 = (CashEntryInfo)o2;
                return entry1.getLocalAmount().abs().compareTo(entry.getLocalAmount().abs());
            }
        });
    }

    private boolean hasCashAccount(List tempEntryCol) throws BOSException {
        int enCount = tempEntryCol.size();
        for (int j = 0; j < enCount; ++j) {
            CashEntryInfo entryInfo = (CashEntryInfo)tempEntryCol.get(j);
            if (!CashFlowUtils.isCashAccount(entryInfo.getAccount())) continue;
            return true;
        }
        return false;
    }

    private void collectByAmount(Context ctx, CashEntryInfo selfEntry, CashEntryInfo oppEntry, CompanyOrgUnitInfo company, BigDecimal[] amt, boolean isSingleVoucher, CashflowSplitRecordCollection resultCollector, boolean isAllCashAccount) throws EASBizException, BOSException {
        if (amt[1].signum() == 0) {
            return;
        }
        if (CashFlowUtils.isCashAccount(oppEntry.getAccount()) && (this.isAutoDispose || isAllCashAccount)) {
            CashflowSplitRecordInfo splitRecord = this.createSplitRecord(ctx, selfEntry, oppEntry, amt, resultCollector, null, ItemFlag.DISPOSE);
            resultCollector.add(splitRecord);
            BigDecimal[] disposeAmt = new BigDecimal[3];
            boolean isCurrencySame = selfEntry.getCurrency().getId().toString().equals(oppEntry.getCurrency().getId().toString());
            if (isCurrencySame) {
                if (selfEntry.getVoucherEntry().getEntryDC() == oppEntry.getVoucherEntry().getEntryDC()) {
                    disposeAmt[0] = amt[0].negate();
                    disposeAmt[1] = amt[1].negate();
                    disposeAmt[2] = amt[2].negate();
                } else {
                    disposeAmt[0] = amt[0];
                    disposeAmt[1] = amt[1];
                    disposeAmt[2] = amt[2];
                }
            } else {
                BigDecimal origAmt = oppEntry.getOriginalAmount().multiply(amt[1].divide(oppEntry.getLocalAmount(), 28, 4));
                origAmt = origAmt.setScale(oppEntry.getCurrency().getPrecision(), 4);
                if (selfEntry.getVoucherEntry().getEntryDC() == oppEntry.getVoucherEntry().getEntryDC()) {
                    disposeAmt[0] = origAmt.negate();
                    disposeAmt[1] = amt[1].negate();
                    disposeAmt[2] = amt[2].negate();
                } else {
                    disposeAmt[0] = origAmt;
                    disposeAmt[1] = amt[1];
                    disposeAmt[2] = amt[2];
                }
            }
            CashflowSplitRecordInfo disposeRecord = this.createSplitRecord(ctx, oppEntry, selfEntry, disposeAmt, resultCollector, null, ItemFlag.DISPOSE);
            resultCollector.add(disposeRecord);
        } else {
            List assistCol = (List)oppEntry.getAssistCol();
            if (assistCol == null) {
                CashflowSplitRecordInfo splitRecord = this.createSplitRecord(ctx, selfEntry, oppEntry, amt, resultCollector, null, ItemFlag.PRIMARY);
                resultCollector.add(splitRecord);
            } else {
                boolean isCurrencySame = selfEntry.getCurrency().getId().toString().equals(oppEntry.getCurrency().getId().toString());
                if (selfEntry.getLocalAmount().compareTo(oppEntry.getLocalAmount()) == 0 && !selfEntry.getEntryDC().equals((Object)oppEntry.getEntryDC())) {
                    CashEntryInfo entry2 = null;
                    for (CashEntryInfo entry2 : assistCol) {
                        if (entry2.getLocalAmount().signum() == 0) continue;
                        BigDecimal[] assistArray = new BigDecimal[3];
                        if (isCurrencySame) {
                            assistArray[0] = entry2.getOriginalAmount();
                        } else {
                            assistArray[0] = amt[0].multiply(entry2.getLocalAmount().divide(amt[1], 28, 4));
                            assistArray[0] = assistArray[0].setScale(selfEntry.getCurrency().getPrecision(), 4);
                        }
                        assistArray[1] = entry2.getLocalAmount();
                        assistArray[2] = entry2.getReportingAmount();
                        CashflowSplitRecordInfo splitRecord = this.createSplitRecord(ctx, selfEntry, oppEntry, assistArray, resultCollector, entry2.getVoucherAssistEntry(), ItemFlag.PRIMARY);
                        resultCollector.add(splitRecord);
                    }
                } else if (selfEntry.getLocalAmount().add(oppEntry.getLocalAmount()).signum() == 0 && selfEntry.getEntryDC().equals((Object)oppEntry.getEntryDC())) {
                    CashEntryInfo entry3 = null;
                    for (CashEntryInfo entry3 : assistCol) {
                        if (entry3.getLocalAmount().signum() == 0) continue;
                        BigDecimal[] assistArray = new BigDecimal[3];
                        if (isCurrencySame) {
                            assistArray[0] = entry3.getOriginalAmount().negate();
                        } else {
                            assistArray[0] = amt[0].negate().multiply(entry3.getLocalAmount().divide(amt[1], 28, 4));
                            assistArray[0] = assistArray[0].setScale(selfEntry.getCurrency().getPrecision(), 4);
                        }
                        assistArray[1] = entry3.getLocalAmount().negate();
                        assistArray[2] = entry3.getReportingAmount().negate();
                        CashflowSplitRecordInfo splitRecord = this.createSplitRecord(ctx, selfEntry, oppEntry, assistArray, resultCollector, entry3.getVoucherAssistEntry(), ItemFlag.PRIMARY);
                        resultCollector.add(splitRecord);
                    }
                } else {
                    int i;
                    BigDecimal[] assistArray = new BigDecimal[3];
                    BigDecimal[] copyAmt = new BigDecimal[]{amt[0], amt[1], amt[2]};
                    Collections.sort(assistCol, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            CashEntryInfo entry = (CashEntryInfo)o1;
                            CashEntryInfo entry1 = (CashEntryInfo)o2;
                            if (entry1.getLocalAmount().abs().compareTo(entry.getLocalAmount().abs()) == 0) {
                                return entry.getVoucherAssistEntry().getSeq() - entry1.getVoucherAssistEntry().getSeq();
                            }
                            return entry1.getLocalAmount().abs().compareTo(entry.getLocalAmount().abs());
                        }
                    });
                    CashEntryInfo entry = null;
                    for (i = 0; i < assistCol.size(); ++i) {
                        entry = (CashEntryInfo)assistCol.get(i);
                        if (entry.getLocalAmount().compareTo(copyAmt[1]) != 0) continue;
                        assistCol.remove(i);
                        assistCol.add(0, entry);
                        break;
                    }
                    for (i = 0; i < assistCol.size(); ++i) {
                        BigDecimal origAmt;
                        CashflowSplitRecordInfo splitRecord;
                        entry = (CashEntryInfo)assistCol.get(i);
                        if (entry.getLocalAmount().signum() == 0) continue;
                        BigDecimal sub = null;
                        BigDecimal subRpt = null;
                        if ((oppEntry.getReportingAmount() == null || oppEntry.getReportingAmount().compareTo(new BigDecimal("0")) == 0) && entry.getReportingAmount() == null) {
                            entry.setReportingAmount(new BigDecimal("0"));
                        }
                        if (!isSingleVoucher) {
                            sub = copyAmt[1].subtract(entry.getLocalAmount());
                            subRpt = copyAmt[2].subtract(entry.getReportingAmount());
                            if (copyAmt[1].signum() > 0 && sub.signum() >= 0 || copyAmt[1].signum() <= 0 && sub.signum() < 0) {
                                if (isCurrencySame) {
                                    assistArray[0] = entry.getOriginalAmount();
                                } else {
                                    assistArray[0] = amt[0].multiply(entry.getLocalAmount().divide(amt[1], 28, 4));
                                    assistArray[0] = assistArray[0].setScale(selfEntry.getCurrency().getPrecision(), 4);
                                }
                                assistArray[1] = entry.getLocalAmount();
                                assistArray[2] = entry.getReportingAmount();
                                copyAmt[1] = sub;
                                copyAmt[0] = copyAmt[0].subtract(assistArray[0]);
                                copyAmt[2] = copyAmt[2].subtract(assistArray[2]);
                                if (assistArray[1].signum() != 0) {
                                    splitRecord = this.createSplitRecord(ctx, selfEntry, oppEntry, assistArray, resultCollector, entry.getVoucherAssistEntry(), ItemFlag.PRIMARY);
                                    resultCollector.add(splitRecord);
                                }
                                entry.setLocalAmount(GlUtils.zero);
                                entry.setOriginalAmount(GlUtils.zero);
                                entry.setReportingAmount(GlUtils.zero);
                            } else {
                                assistArray[0] = copyAmt[0];
                                assistArray[1] = copyAmt[1];
                                assistArray[2] = copyAmt[2];
                                if (assistArray[1].signum() != 0) {
                                    splitRecord = this.createSplitRecord(ctx, selfEntry, oppEntry, assistArray, resultCollector, entry.getVoucherAssistEntry(), ItemFlag.PRIMARY);
                                    resultCollector.add(splitRecord);
                                }
                                origAmt = null;
                                if (isCurrencySame) {
                                    origAmt = entry.getOriginalAmount().subtract(copyAmt[0]);
                                } else {
                                    origAmt = entry.getOriginalAmount().multiply(amt[1].divide(entry.getLocalAmount(), 28, 4));
                                    origAmt = origAmt.setScale(entry.getCurrency().getPrecision(), 4);
                                    origAmt = entry.getOriginalAmount().subtract(origAmt);
                                }
                                entry.setOriginalAmount(origAmt);
                                entry.setLocalAmount(sub.negate());
                                entry.setReportingAmount(subRpt.negate());
                            }
                        } else {
                            sub = copyAmt[1].add(entry.getLocalAmount());
                            subRpt = copyAmt[2].add(entry.getReportingAmount());
                            if (copyAmt[1].signum() > 0 && sub.signum() < 0 || copyAmt[1].signum() < 0 && sub.signum() > 0) {
                                assistArray[0] = copyAmt[0];
                                assistArray[1] = copyAmt[1];
                                assistArray[2] = copyAmt[2];
                                if (assistArray[1].signum() != 0) {
                                    splitRecord = this.createSplitRecord(ctx, selfEntry, oppEntry, assistArray, resultCollector, entry.getVoucherAssistEntry(), ItemFlag.PRIMARY);
                                    resultCollector.add(splitRecord);
                                }
                                origAmt = null;
                                if (isCurrencySame) {
                                    origAmt = entry.getOriginalAmount().add(copyAmt[0]);
                                } else {
                                    origAmt = entry.getOriginalAmount().multiply(amt[1].divide(entry.getLocalAmount(), 28, 4));
                                    origAmt = origAmt.setScale(entry.getCurrency().getPrecision(), 4);
                                    origAmt = entry.getOriginalAmount().add(origAmt);
                                }
                                entry.setOriginalAmount(origAmt);
                                entry.setLocalAmount(sub);
                                entry.setReportingAmount(subRpt);
                            } else {
                                if (isCurrencySame) {
                                    assistArray[0] = entry.getOriginalAmount().negate();
                                } else {
                                    assistArray[0] = amt[0].negate().multiply(entry.getLocalAmount().divide(amt[1], 28, 4));
                                    assistArray[0] = assistArray[0].setScale(selfEntry.getCurrency().getPrecision(), 4);
                                }
                                assistArray[1] = entry.getLocalAmount().negate();
                                assistArray[2] = entry.getReportingAmount().negate();
                                copyAmt[1] = sub;
                                copyAmt[0] = copyAmt[0].subtract(assistArray[0]);
                                copyAmt[2] = copyAmt[2].subtract(assistArray[2]);
                                if (assistArray[1].signum() != 0) {
                                    splitRecord = this.createSplitRecord(ctx, selfEntry, oppEntry, assistArray, resultCollector, entry.getVoucherAssistEntry(), ItemFlag.PRIMARY);
                                    resultCollector.add(splitRecord);
                                }
                                entry.setLocalAmount(GlUtils.zero);
                                entry.setOriginalAmount(GlUtils.zero);
                                entry.setReportingAmount(GlUtils.zero);
                            }
                        }
                        if (!(copyAmt[1].signum() >= 0 && sub.signum() <= 0 || copyAmt[1].signum() <= 0 && sub.signum() >= 0)) {
                            continue;
                        }
                        break;
                    }
                }
            }
        }
    }

    private CashflowSplitRecordInfo createSplitRecord(Context ctx, CashEntryInfo selfEntry, CashEntryInfo oppEntry, BigDecimal[] amt, CashflowSplitRecordCollection resultCollector, VoucherAssistRecordInfo voucherAssist, ItemFlag itemFlag) {
        CashflowSplitRecordInfo splitRecord = new CashflowSplitRecordInfo();
        splitRecord.setVoucher(selfEntry.getBill());
        splitRecord.setEntry(selfEntry.getVoucherEntry());
        splitRecord.setAccount(selfEntry.getVoucherEntry().getAccount());
        splitRecord.setCurrency(selfEntry.getVoucherEntry().getCurrency());
        splitRecord.setEntryDC(selfEntry.getVoucherEntry().getEntryDC());
        splitRecord.setOpposingAccountEntry(oppEntry.getVoucherEntry());
        splitRecord.setOppAccount(oppEntry.getAccount());
        splitRecord.setOppEntryDC(oppEntry.getEntryDC());
        splitRecord.setOriginalAmount(amt[0]);
        splitRecord.setLocalAmount(amt[1]);
        splitRecord.setReportingAmount(amt[2]);
        splitRecord.setIsSupItem(false);
        splitRecord.setSourceType(1);
        splitRecord.setItemFlag(itemFlag);
        if (voucherAssist != null) {
            splitRecord.setOppVoucherAssistRecord(voucherAssist);
            splitRecord.setOppAssGrp(voucherAssist.getAssGrp());
        }
        Timestamp nowTime = new Timestamp(System.currentTimeMillis());
        splitRecord.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        splitRecord.setCreateTime(nowTime);
        splitRecord.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        splitRecord.setLastUpdateTime(nowTime);
        return splitRecord;
    }

    private void mergeCashflowSplitRecordCollection(CashflowSplitRecordCollection resultCollector) {
        CashflowSplitRecordCollection tempCol = new CashflowSplitRecordCollection();
        for (int i = 0; i < resultCollector.size(); ++i) {
            CashflowSplitRecordInfo record = resultCollector.get(i);
            this.addSplitRecord(tempCol, record);
        }
        resultCollector.clear();
        resultCollector.addCollection(tempCol);
    }

    private void addSplitRecord(CashflowSplitRecordCollection resultCollector, CashflowSplitRecordInfo splitRecord) {
        for (int i = 0; i < resultCollector.size(); ++i) {
            CashflowSplitRecordInfo record = resultCollector.get(i);
            if (record.getEntry() != splitRecord.getEntry() || record.getOpposingAccountEntry() != splitRecord.getOpposingAccountEntry() || record.getOppVoucherAssistRecord() != splitRecord.getOppVoucherAssistRecord() || ItemFlag.DISPOSE.equals((Object)splitRecord.getItemFlag())) continue;
            record.setLocalAmount(record.getLocalAmount().add(splitRecord.getLocalAmount()));
            record.setOriginalAmount(record.getOriginalAmount().add(splitRecord.getOriginalAmount()));
            record.setReportingAmount(record.getReportingAmount().add(splitRecord.getReportingAmount()));
            return;
        }
        resultCollector.add(splitRecord);
    }

    private boolean isAllCashAccount(List entries) {
        boolean isAllCash = true;
        for (int i = 0; i < entries.size(); ++i) {
            CashEntryInfo entryInfo = (CashEntryInfo)entries.get(i);
            if (CashFlowUtils.isCashAccount(entryInfo.getAccount())) continue;
            isAllCash = false;
            break;
        }
        return isAllCash;
    }
}

