/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.account.AccountDiffType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.DiffItemDC;
import com.kingdee.eas.fi.gl.DiffItemFlag;
import com.kingdee.eas.fi.gl.DiffItemRecordCollection;
import com.kingdee.eas.fi.gl.DiffItemRecordFactory;
import com.kingdee.eas.fi.gl.DiffItemRecordInfo;
import com.kingdee.eas.fi.gl.DiffItemUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.AbstractDiffItemRecordControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DiffItemRecordControllerBean
extends AbstractDiffItemRecordControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.DiffItemRecordControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.fi.gl.DiffItemResource";

    @Override
    protected Map _saveRecords(Context ctx, IObjectCollection records) throws BOSException, EASBizException {
        HashMap<String, Timestamp> result = new HashMap<String, Timestamp>();
        if (records == null || records.size() == 0) {
            return null;
        }
        HashMap<String, CoreBaseCollection> colls = new HashMap<String, CoreBaseCollection>();
        HashMap<String, VoucherInfo> vouchers = new HashMap<String, VoucherInfo>();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        Timestamp time = GlUtils.getTime();
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        for (DiffItemRecordInfo record : records) {
            VoucherInfo voucher = record.getVoucher();
            if (voucher == null || voucher.getId() == null || voucher.getLastUpdateTime() == null) continue;
            record.setCreator(user);
            record.setCreateTime(time);
            record.setLastUpdateUser(user);
            record.setLastUpdateTime(time);
            record.setCU(cu);
            String voucherId = record.getVoucher().getId().toString();
            CoreBaseCollection coll = (CoreBaseCollection)colls.get(voucherId);
            if (coll == null) {
                coll = new CoreBaseCollection();
                colls.put(voucherId, coll);
                vouchers.put(voucherId, voucher);
            }
            coll.add((CoreBaseInfo)record);
        }
        for (String voucherId : colls.keySet()) {
            this.lockVoucher(ctx, voucherId);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("lastUpdateTime"));
            BaseVoucherInfo vch = (BaseVoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(voucherId), sic);
            if (!vch.getLastUpdateTime().equals(((VoucherInfo)vouchers.get(voucherId)).getLastUpdateTime())) {
                throw new VoucherException(VoucherException.EDIT_CONFLICT);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)voucherId));
            this.delete(ctx, filter);
            this.addnewBatchData(ctx, (CoreBaseCollection)colls.get(voucherId));
            BOSUuid auditorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
            String sql = "update t_gl_voucher set FDiffItemFlag = ?, FLastUpdateUserID = ?, FLastUpdateTime = ? where FID = ?";
            Timestamp ctime = GlUtils.getTime();
            Integer diffItemFlag = ((VoucherInfo)vouchers.get(voucherId)).getBizStatus().equals((Object)VoucherStatusEnum.TEMP) ? new Integer(0) : new Integer(1);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{diffItemFlag, auditorId.toString(), ctime, voucherId});
            result.put(voucherId, ctime);
        }
        return result;
    }

    public void lockVoucher(Context ctx, String voucherId) throws BOSException {
        String sql = "update t_gl_voucher set  FCancellerID = FCancellerID where fid = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherId});
    }

    @Override
    protected void _updateFlag(Context ctx, List vouchers, DiffItemFlag flag) throws BOSException, EASBizException {
        if (vouchers == null || vouchers.size() == 0 || flag == null || !flag.equals((Object)DiffItemFlag.NONEED) && !flag.equals((Object)DiffItemFlag.UNSPECIFIED)) {
            return;
        }
        for (Object o : vouchers) {
            VoucherInfo voucher = (VoucherInfo)o;
            if (voucher == null || voucher.getId() == null || voucher.getLastUpdateTime() == null) continue;
            this.lockVoucher(ctx, voucher.getId().toString());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("lastUpdateTime"));
            BaseVoucherInfo vch = (BaseVoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(voucher.getId()), sic);
            if (!vch.getLastUpdateTime().equals(voucher.getLastUpdateTime())) {
                throw new VoucherException(VoucherException.EDIT_CONFLICT);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)voucher.getId().toString()));
            this.delete(ctx, filter);
            BOSUuid auditorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
            String sql = "update t_gl_voucher set FDiffItemFlag = ?, FLastUpdateUserID = ?, FLastUpdateTime = ? where FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(flag.getValue()), auditorId.toString(), GlUtils.getTime(), voucher.getId().toString()});
        }
    }

    @Override
    protected Map _autoAssign(Context ctx, List ids, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> cache = new HashMap<String, Object>();
        HashMap<String, Object> errors = new HashMap<String, Object>();
        int batchSize = 10;
        if (ids.size() > batchSize) {
            ArrayList batchs = new ArrayList();
            ArrayList<String> batch = new ArrayList<String>();
            for (Object e : ids) {
                batch.add((String)e);
                if (batch.size() < batchSize) continue;
                batchs.add(batch);
                batch = new ArrayList();
            }
            if (batch.size() > 0) {
                batchs.add(batch);
            }
            for (List list : batchs) {
                this.doAutoAssign(ctx, list, params, cache, errors);
            }
            return errors;
        }
        this.doAutoAssign(ctx, ids, params, cache, errors);
        return errors;
    }

    protected void doAutoAssign(Context ctx, List ids, Map params, Map<String, Object> cache, Map<String, Object> errors) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(DiffItemUtils.getVoucherSelector());
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet();
        set.addAll(ids);
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        int range = (Integer)params.get("range");
        if (range == 1) {
            filter.getFilterItems().add(new FilterItemInfo("diffItemFlag", (Object)0));
        }
        view.setFilter(filter);
        VoucherCollection vouchers = VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(view);
        Iterator it = vouchers.iterator();
        while (it.hasNext()) {
            this.doAutoAssign(ctx, (VoucherInfo)it.next(), params, cache, errors);
        }
    }

    protected void doAutoAssign(Context ctx, VoucherInfo voucher, Map params, Map<String, Object> cache, Map<String, Object> errors) throws BOSException, EASBizException {
        int range = (Integer)params.get("range");
        if (SourceType.PROFIT_AND_LOSS.equals((Object)voucher.getSourceType())) {
            if (!DiffItemFlag.NONEED.equals((Object)voucher.getDiffItemFlag())) {
                ArrayList<VoucherInfo> vouchers = new ArrayList<VoucherInfo>(1);
                vouchers.add(voucher);
                DiffItemRecordFactory.getLocalInstance(ctx).updateFlag(vouchers, DiffItemFlag.NONEED);
                errors.put(voucher.getId().toString(), ResourceBase.getString((String)RESOURCE, (String)"Update_Flag", (Locale)ctx.getLocale()) + " [" + (Object)((Object)voucher.getDiffItemFlag()) + "] -> [" + (Object)((Object)DiffItemFlag.NONEED) + "]");
            }
            return;
        }
        Map<String, Object> analysis = DiffItemUtils.analysis(voucher);
        List diffEntries = (List)analysis.get("diffEntries");
        List checkEntries = (List)analysis.get("checkEntries");
        BigDecimal inDiffAmt = (BigDecimal)analysis.get("inDiffAmt");
        BigDecimal exDiffAmt = (BigDecimal)analysis.get("exDiffAmt");
        if (diffEntries.size() == 0 || inDiffAmt.compareTo(GlUtils.zero) == 0 && exDiffAmt.compareTo(GlUtils.zero) == 0) {
            if (!DiffItemFlag.NONEED.equals((Object)voucher.getDiffItemFlag())) {
                ArrayList<VoucherInfo> vouchers = new ArrayList<VoucherInfo>(1);
                vouchers.add(voucher);
                DiffItemRecordFactory.getLocalInstance(ctx).updateFlag(vouchers, DiffItemFlag.NONEED);
                errors.put(voucher.getId().toString(), ResourceBase.getString((String)RESOURCE, (String)"Update_Flag", (Locale)ctx.getLocale()) + " [" + (Object)((Object)voucher.getDiffItemFlag()) + "] -> [" + (Object)((Object)DiffItemFlag.NONEED) + "]");
            }
            return;
        }
        if (checkEntries.size() == 0) {
            if (!DiffItemFlag.UNSPECIFIED.equals((Object)voucher.getDiffItemFlag())) {
                ArrayList<VoucherInfo> vouchers = new ArrayList<VoucherInfo>(1);
                vouchers.add(voucher);
                DiffItemRecordFactory.getLocalInstance(ctx).updateFlag(vouchers, DiffItemFlag.UNSPECIFIED);
            }
            errors.put(voucher.getId().toString(), "e" + ResourceBase.getString((String)RESOURCE, (String)"NoCheckEntry_CanNotSet", (Locale)ctx.getLocale()));
            return;
        }
        if (range == 2 && DiffItemFlag.SPECIFIED.equals((Object)voucher.getDiffItemFlag())) {
            return;
        }
        DiffItemRecordCollection records = DiffItemUtils.assign(ctx, voucher.getId().toString(), voucher, analysis, cache, errors, false);
        if (errors.containsKey(voucher.getId().toString())) {
            return;
        }
        if (records != null && records.size() > 0) {
            BigDecimal inAssigned = GlUtils.zero;
            BigDecimal exAssigned = GlUtils.zero;
            Iterator it = records.iterator();
            while (it.hasNext()) {
                DiffItemRecordInfo record = (DiffItemRecordInfo)it.next();
                if (record.getDiffEntry().getAccount().getDiffType().equals((Object)AccountDiffType.INCOME)) {
                    if (record.getDiffItem().getDc().equals((Object)DiffItemDC.POSITIVE)) {
                        inAssigned = inAssigned.add(record.getAssignedLocalAmount());
                        continue;
                    }
                    if (!record.getDiffItem().getDc().equals((Object)DiffItemDC.NEGATIVE)) continue;
                    inAssigned = inAssigned.subtract(record.getAssignedLocalAmount());
                    continue;
                }
                if (!record.getDiffEntry().getAccount().getDiffType().equals((Object)AccountDiffType.EXPENSE)) continue;
                if (record.getDiffItem().getDc().equals((Object)DiffItemDC.POSITIVE)) {
                    exAssigned = exAssigned.add(record.getAssignedLocalAmount());
                    continue;
                }
                if (!record.getDiffItem().getDc().equals((Object)DiffItemDC.NEGATIVE)) continue;
                exAssigned = exAssigned.subtract(record.getAssignedLocalAmount());
            }
            if (inAssigned.compareTo(inDiffAmt) == 0 && exAssigned.compareTo(exDiffAmt) == 0) {
                DiffItemRecordFactory.getLocalInstance(ctx).saveRecords((IObjectCollection)records);
                if (voucher.getBizStatus().equals((Object)VoucherStatusEnum.SUBMITTED) || voucher.getBizStatus().equals((Object)VoucherStatusEnum.AUDITTED) || voucher.getBizStatus().equals((Object)VoucherStatusEnum.POSTED)) {
                    if (DiffItemFlag.SPECIFIED.equals((Object)voucher.getDiffItemFlag())) {
                        errors.put(voucher.getId().toString(), ResourceBase.getString((String)RESOURCE, (String)"Reset_Success", (Locale)ctx.getLocale()));
                    } else {
                        errors.put(voucher.getId().toString(), ResourceBase.getString((String)RESOURCE, (String)"Set_Success", (Locale)ctx.getLocale()));
                    }
                } else if (DiffItemFlag.SPECIFIED.equals((Object)voucher.getDiffItemFlag())) {
                    errors.put(voucher.getId().toString(), ResourceBase.getString((String)RESOURCE, (String)"Reset_Finish", (Locale)ctx.getLocale()));
                } else {
                    errors.put(voucher.getId().toString(), ResourceBase.getString((String)RESOURCE, (String)"Set_Finish", (Locale)ctx.getLocale()));
                }
            } else {
                errors.put(voucher.getId().toString(), "e" + ResourceBase.getString((String)RESOURCE, (String)"CanNot_AutoSet_DiffItem", (Locale)ctx.getLocale()));
            }
        } else {
            errors.put(voucher.getId().toString(), "e" + ResourceBase.getString((String)RESOURCE, (String)"CanNot_AutoSet_DiffItem", (Locale)ctx.getLocale()));
        }
    }

    @Override
    protected Map _checkRecords(Context ctx, List ids, Map params) throws BOSException, EASBizException {
        return null;
    }
}

