/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountCurrencyFactory;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.account.IAccountCurrency;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAcctCussentHistory;
import com.kingdee.eas.fi.gl.app.AbstractGLACAuditCacelFacadeControllerBean;
import com.kingdee.eas.fi.gl.common.ACAuditCancelFilterHelper;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class GLACAuditCacelFacadeControllerBean
extends AbstractGLACAuditCacelFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLACAuditCacelFacadeControllerBean");

    @Override
    protected Vector _getAllACAcct(Context ctx, String companyId, String acctTableId) throws BOSException, EASBizException {
        Connection con = null;
        StringBuffer sql = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int index = 0;
        Vector<AccountViewInfo> vec = new Vector<AccountViewInfo>();
        String loc = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        try {
            con = this.getConnection(ctx);
            sql = new StringBuffer();
            sql.append(" select av.fid,av.fnumber,av.fname").append(loc).append(" FName     \r\n");
            sql.append(" ,av.fdc,av.fac,av.fcaa,av.fgaa,av.FAcctCurrency               \r\n");
            sql.append(" from t_bd_accountview av                     \r\n");
            sql.append(" where av.fcompanyid = ?                     \r\n");
            sql.append(" and av.faccounttableid = ?                  \r\n");
            sql.append(" and av.fac = 1                               \r\n");
            sql.append(" and av.fisleaf = 1                               \r\n");
            sql.append(" and av.fisgfreeze = 0                        \r\n");
            sql.append(" and av.fiscfreeze = 0                        \r\n");
            sql.append(" order by av.fnumber                        \r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)companyId);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)acctTableId);
            rs = stmt.executeQuery();
            AccountViewInfo acct = null;
            while (rs.next()) {
                acct = new AccountViewInfo();
                acct.setId(BOSUuid.read((String)rs.getString("FID")));
                acct.setNumber(rs.getString("FNumber"));
                acct.setName(rs.getString("FName"));
                acct.setDC(BalanceDirectionEnum.getEnum((int)rs.getInt("FDC")));
                acct.setAC(true);
                AsstAccountInfo caa = null;
                if (rs.getString("FCAA") != null) {
                    caa = new AsstAccountInfo();
                    caa.setId(BOSUuid.read((String)rs.getString("FCAA")));
                }
                acct.setCAA(caa);
                AsstAccountInfo gaa = null;
                if (rs.getString("FGAA") != null) {
                    gaa = new AsstAccountInfo();
                    gaa.setId(BOSUuid.read((String)rs.getString("FGAA")));
                }
                acct.setGAA(gaa);
                acct.setAccountingcurrency(AccountingCurrencyEnum.getEnum((int)rs.getInt("FAcctCurrency")));
                vec.add(acct);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return vec;
    }

    @Override
    protected void _autoVerify(Context ctx, HashMap param) throws BOSException, EASBizException {
        IAcctCussentHistory iAcHis = AcctCussentHistoryFactory.getLocalInstance(ctx);
        ArrayList listAcct = (ArrayList)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.ACCTS);
        Iterator it = listAcct.iterator();
        AccountViewInfo acct = null;
        while (it.hasNext()) {
            acct = (AccountViewInfo)it.next();
            param.put("account", acct);
            try {
                iAcHis.autoVerifyOneAcct((HashMap)param.clone());
            }
            catch (EASBizException e) {
                if (e.getCode().equals("99-212")) continue;
                throw e;
            }
        }
    }

    @Override
    protected boolean _checkIfNeedAutoVerify(Context ctx, HashMap param) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        String tempTableDes;
        String tempTableSrc;
        block18: {
            StringBuffer sql;
            block17: {
                int i;
                ArrayList listParam;
                block16: {
                    tempTableSrc = "";
                    tempTableDes = "";
                    con = null;
                    ps = null;
                    rs = null;
                    sql = new StringBuffer();
                    con = this.getConnection(ctx);
                    tempTableSrc = this.createTempTable4SrcDesData(ctx);
                    sql.setLength(0);
                    sql.append("delete from ").append(tempTableSrc).append("  \r\n");
                    ps = con.prepareStatement(sql.toString());
                    ps.execute();
                    ps.close();
                    sql.setLength(0);
                    listParam = new ArrayList();
                    sql.append("Insert into ").append(tempTableSrc).append("  \r\n");
                    sql.append(this.getVerifySrcDataSql(ctx, param, listParam));
                    ps = con.prepareStatement(sql.toString());
                    for (i = 0; i < listParam.size(); ++i) {
                        ps.setObject(i + 1, listParam.get(i));
                    }
                    ps.execute();
                    SQLUtils.cleanup((Statement)ps);
                    sql.setLength(0);
                    sql.append("select top 1 1 from " + tempTableSrc);
                    ps = con.prepareStatement(sql.toString());
                    rs = ps.executeQuery();
                    if (rs.next()) break block16;
                    i = 0;
                    SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
                    return i != 0;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                tempTableDes = this.createTempTable4SrcDesData(ctx);
                sql.setLength(0);
                sql.append("delete from ").append(tempTableDes).append("  \r\n");
                ps = con.prepareStatement(sql.toString());
                ps.execute();
                ps.close();
                listParam = new ArrayList();
                sql.setLength(0);
                sql.append("Insert into ").append(tempTableDes).append("  \r\n");
                sql.append(this.getVerifyDesDataSql(ctx, param, listParam));
                ps = con.prepareStatement(sql.toString());
                for (i = 0; i < listParam.size(); ++i) {
                    ps.setObject(i + 1, listParam.get(i));
                }
                ps.execute();
                SQLUtils.cleanup((Statement)ps);
                sql.setLength(0);
                sql.append("select top 1 1 from " + tempTableDes);
                ps = con.prepareStatement(sql.toString());
                rs = ps.executeQuery();
                if (rs.next()) break block17;
                i = 0;
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
                return i != 0;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            boolean unChkBizNum = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.UNCHECKBIZNUM);
            boolean isAmtMustSame = false;
            if (param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYAMTMUSTSAME) != null) {
                isAmtMustSame = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYAMTMUSTSAME);
            }
            try {
                sql.setLength(0);
                sql.append("create index i").append(tempTableSrc).append(" on ").append(tempTableSrc).append("(fassgrpid,faccountid,fcurrencyid)  ;");
                ps = con.prepareStatement(sql.toString());
                ps.execute();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ps.close();
            try {
                sql.setLength(0);
                sql.append("create index i").append(tempTableDes).append(" on ").append(tempTableDes).append("(fassgrpid,faccountid,fcurrencyid)  ;");
                ps = con.prepareStatement(sql.toString());
                ps.execute();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ps.close();
            sql.setLength(0);
            sql.append(" select top 1 1                                 \r\n");
            sql.append(" from                                           \r\n");
            sql.append(tempTableSrc).append(" vac inner join            \r\n");
            sql.append(tempTableDes).append(" veri                      \r\n");
            sql.append(" on vac.faccountid = veri.faccountid            \r\n");
            sql.append(" and vac.fcurrencyid = veri.fcurrencyid         \r\n");
            sql.append(" and vac.fassgrpid = veri.fassgrpid             \r\n");
            if (!unChkBizNum) {
                sql.append(" and isnull(vac.fbiznumber,' ') = isnull(veri.fbiznumber,' ')           \r\n");
            }
            if (isAmtMustSame) {
                sql.append(" and isnull(vac.FUnverifiedAmtFor,0) = isnull(veri.FVerifiedAmtFor,0)           \r\n");
            }
            if ((rs = (ps = con.prepareStatement(sql.toString())).executeQuery()).next()) break block18;
            boolean bl = false;
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
            return bl;
        }
        try {
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        param.put("tempTableSrc", tempTableSrc);
        param.put("tempTableDes", tempTableDes);
        return true;
    }

    protected StringBuffer getVerifySrcDataSql(Context ctx, HashMap param, List listParam) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        List listAcct = (List)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.ACCTS);
        List listCurrency = this.getCurrencyListFromParam(ctx, param, null);
        if (listAcct.size() <= 0 || listCurrency.size() <= 0) {
            return sql;
        }
        boolean excludeUnPostVch = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.EXCLUDEUNPOSTVCH);
        boolean nullBizNumIsNotSame = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.NULLBIZNUMISNOTSAME);
        int verifyMode = GlUtils.getVerifyMode(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        String currencyID = SQLUtil.listObjectToInString(listCurrency);
        String accountID = SQLUtil.listObjectToInString(listAcct);
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        java.util.Date bizDateFrom = (java.util.Date)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.BIZDATEFROM);
        Date begin = null;
        if (bizDateFrom != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(bizDateFrom);
            bizDateFrom = cal.getTime();
            begin = new Date(bizDateFrom.getTime());
        }
        java.util.Date bizDateTo = (java.util.Date)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.BIZDATETO);
        Date end = null;
        if (bizDateTo != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(bizDateTo);
            bizDateTo = cal.getTime();
            end = new Date(bizDateTo.getTime());
        }
        String bizNumber = (String)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.BIZNUMBER);
        StringBuffer sqlAssistJoin = new StringBuffer();
        if (param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.ITEMS) != null) {
            ArrayList items = (ArrayList)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.ITEMS);
            for (int i = 0; i < items.size(); ++i) {
                Map item = (Map)items.get(i);
                String tablename = (String)item.get("tablename");
                String field = (String)item.get("fieldname");
                String numberfrom = (String)item.get("numberfrom");
                String id = (String)item.get("itemId");
                if (id != null) {
                    sqlAssistJoin.append(" inner join ").append(tablename).append(" item").append(i).append(" on ").append(" item").append(i).append(".fid =hg.").append(field).append(" and").append(" item").append(i).append(".fid='").append(id).append("'\t\t\t\r\n");
                    continue;
                }
                if (numberfrom == null) continue;
                sqlAssistJoin.append(" inner join ").append(tablename).append(" item").append(i).append(" on ").append(" item").append(i).append(".fid =hg.").append(field).append(" and").append(" item").append(i).append(".fnumber='").append(numberfrom).append("'\t\t\t\r\n");
            }
        }
        sql.append("select a.fid fid,N' ' FNumber, b.FBizDate FBizDate,b.FBizNumber FBizNumber,b.FendDate FBookedDate,\t\r\n");
        sql.append(" b.FDescription FDescription,v.FDC FDC,  \r\n");
        sql.append(" b.FOriginalAmount FOriginalAmount,b.FAssGrpID FAssGrpID,b.fid voucherAssistRecordID,\t \r\n");
        sql.append(" a.FUnverifiedAmtFor FUnverifiedAmtFor,  \r\n");
        sql.append(" (b.FOriginalAmount-a.FUnverifiedAmtFor) FVerifiedAmtFor,a.FLastUpdateTime as FLastUpdateTime \r\n");
        sql.append("  ,a.FCurrencyID,a.FAccountID    \r\n");
        sql.append(" from T_GL_AcctCussent a        \r\n");
        sql.append(" inner join T_GL_VoucherAssistRecord b on a.FVchAssistRecordID = b.fid  \r\n");
        sql.append(" inner join t_bd_accountview v on  a.FAccountID = v.fid \r\n");
        sql.append(" inner join T_bd_assistanthg hg on b.FassgrpId =hg.fid  \r\n");
        sql.append(sqlAssistJoin);
        sql.append(" \r\n where  b.FIsVierified = 0 and a.FUnverifiedAmtFor > 0 and a.FIsInit=1 \r\n");
        sql.append(" and a.FCompanyID = ? \r\n");
        sql.append(" and a.FCurrencyID in ").append(currencyID).append(" \r\n ");
        sql.append(" and a.FAccountID in ").append(accountID).append(" \r\n ");
        listParam.add(companyID);
        if (bizDateFrom != null) {
            sql.append(" and b.FBizDate >= ?  ");
            listParam.add(begin);
        }
        if (bizDateTo != null) {
            sql.append(" and b.FBizDate <= ?  ");
            listParam.add(end);
        }
        if (!StringUtils.isEmpty((String)bizNumber)) {
            sql.append(" and b.FBizNumber like ?  ");
            listParam.add(bizNumber);
        }
        if (nullBizNumIsNotSame) {
            sql.append(" and b.FBizNumber is not null ");
        }
        sql.append(" \r\n");
        sql.append(" union all \r\n");
        sql.append("select a.fid fid,d.FNumber FNumber, b.FBizDate FBizDate,b.FBizNumber FBizNumber, \r\n");
        sql.append(" b.FendDate FBookedDate, b.FDescription FDescription,v.FDC FDC, \r\n");
        sql.append(" b.FOriginalAmount FOriginalAmount,b.FAssGrpID FAssGrpID,b.fid voucherAssistRecordID, \r\n");
        sql.append(" a.FUnverifiedAmtFor FUnverifiedAmtFor,   \r\n");
        sql.append(" (b.FOriginalAmount-a.FUnverifiedAmtFor) FVerifiedAmtFor,a.FLastUpdateTime as FLastUpdateTime \r\n");
        sql.append("  ,a.FCurrencyID,a.FAccountID    \r\n");
        sql.append(" from T_GL_AcctCussent a   \r\n");
        sql.append(" inner join T_GL_VoucherAssistRecord b on a.FVchAssistRecordID = b.fid \r\n");
        sql.append(" inner join T_GL_VoucherEntry c on b.FEntryID = c.fid and c.FIsVerify = 0 \r\n");
        sql.append(" inner join T_GL_Voucher d on c.FBillID =d.fid and d.FIsAC = 1 \r\n");
        sql.append(" inner join t_bd_accountview v on  a.FAccountID = v.fid  \r\n");
        sql.append(" inner join v_gl_acperiod acp on acp.fperiodid=d.fperiodid \r\n");
        sql.append(" inner join T_bd_assistanthg hg on b.FassgrpId = hg.fid  \r\n");
        sql.append(sqlAssistJoin);
        sql.append(" \r\n where b.FIsVierified = 0 and a.FUnverifiedAmtFor > 0 and a.FIsInit=0 \r\n");
        sql.append(" and c.FIsVerify = 0 and d.FIsAC = 1 \r\n");
        sql.append(" and a.FCompanyID = ? \r\n");
        sql.append(" and a.FCurrencyID in ").append(currencyID).append(" \r\n ");
        sql.append(" and a.FAccountID in ").append(accountID).append(" \r\n ");
        listParam.add(companyID);
        if (verifyMode == 1 && excludeUnPostVch) {
            sql.append("and d.fbizstatus = 5");
        } else {
            sql.append("and d.fbizstatus <> 0 and d.fbizstatus <> 2");
        }
        sql.append(" and acp.fcompanyid = ? \r\n");
        listParam.add(companyID);
        if (bizDateFrom != null) {
            sql.append(" and b.FBizDate >= ?  ");
            listParam.add(begin);
        }
        if (bizDateTo != null) {
            sql.append(" and b.FBizDate <= ?  ");
            listParam.add(end);
        }
        if (!StringUtils.isEmpty((String)bizNumber)) {
            sql.append(" and b.FBizNumber like ?  ");
            listParam.add(bizNumber);
        }
        if (nullBizNumIsNotSame) {
            sql.append(" and b.FBizNumber is not null ");
        }
        sql.append(" \r\n");
        return sql;
    }

    protected StringBuffer getVerifyDesDataSql(Context ctx, HashMap param, List listParam) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        List listAcct = (List)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.ACCTS);
        List listCurrency = this.getCurrencyListFromParam(ctx, param, null);
        if (listAcct.size() <= 0 || listCurrency.size() <= 0) {
            return sql;
        }
        boolean excludeUnPostVch = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.EXCLUDEUNPOSTVCH);
        boolean nullBizNumIsNotSame = (Boolean)param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.NULLBIZNUMISNOTSAME);
        int verifyMode = GlUtils.getVerifyMode(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        String currencyID = SQLUtil.listObjectToInString(listCurrency);
        String accountID = SQLUtil.listObjectToInString(listAcct);
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        java.util.Date bizDateFrom = (java.util.Date)param.get("bizDateFrom");
        Date begin = null;
        if (bizDateFrom != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(bizDateFrom);
            bizDateFrom = cal.getTime();
            begin = new Date(bizDateFrom.getTime());
        }
        java.util.Date bizDateTo = (java.util.Date)param.get("bizDateTo");
        Date end = null;
        if (bizDateTo != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(bizDateTo);
            bizDateTo = cal.getTime();
            end = new Date(bizDateTo.getTime());
        }
        String bizNumber = (String)param.get("bizNumber");
        StringBuffer verifyAmtSql = new StringBuffer();
        verifyAmtSql.append(" select a.fid,(case when t.FVerifiedAmtFor is null then 0 else t.FVerifiedAmtFor end) FVerifiedAmtFor   \r\n").append(" from T_GL_VoucherAssistRecord a inner join t_gl_voucher b on a.fbillid = b.fid \r\n").append(" inner join t_gl_voucherentry e on a.fentryid = e.fid  \r\n").append(" left join (select sum(FOroginalAmount) FVerifiedAmtFor,FVoucherAsstIDID    \r\n").append("       from t_gl_acctcussenthistory where FCompanyID = ? \r\n");
        verifyAmtSql.append("         AND Faccountid in ").append(accountID).append(" \r\n ");
        verifyAmtSql.append("\t\tgroup by FVoucherAsstIDID) t on t.FVoucherAsstIDID = a.fid  \r\n");
        verifyAmtSql.append(" where b.FIsAC = 1 AND e.FIsVerify = 1 \r\n");
        if (verifyMode == 1 && excludeUnPostVch) {
            verifyAmtSql.append("and b.fbizstatus = 5");
        } else {
            verifyAmtSql.append("and b.fbizstatus <> 0 and b.fbizstatus <> 2");
        }
        verifyAmtSql.append(" and b.FCompanyID =?  \r\n");
        verifyAmtSql.append(" and e.FCurrencyID in ").append(currencyID).append(" \r\n ");
        verifyAmtSql.append(" and e.FAccountID in ").append(accountID).append(" \r\n ");
        sql.setLength(0);
        sql.append(" select c.fid fid,a.FNumber FNumber, c.FBizDate FBizDate,c.FBizNumber FBizNumber,c.FendDate FBookedDate,  \r\n \t  ");
        sql.append(" c.FDescription FDescription,b.FEntryDC FEntryDC,c.FOriginalAmount FOriginalAmount,       \t\t\t \r\n \t  ");
        sql.append(" c.FAssGrpID FAssGrpID,    c.fid voucherAssistRecordID,  \t\t\t\t\t\t\t\t\t\t\t\r\n \t  ");
        sql.append(" m.FVerifiedAmtFor as FVerifiedAmtFor,    \t\t\r\n \t   ");
        sql.append(" (c.FOriginalAmount-m.FVerifiedAmtFor) FUnverifiedAmtFor ,   \r\n");
        sql.append(" a.FLastUpdateTime as FLastUpdateTime \r\n ");
        sql.append("  ,b.FCurrencyID,b.FAccountID    \r\n");
        sql.append(" from t_gl_Voucher a                    \r\n ");
        sql.append(" inner join t_gl_Voucherentry b on b.FBillID = a.fid    \t\t\t\t\t\t\t\t\t\t\t\r\n  ");
        sql.append(" inner join T_GL_VoucherAssistRecord c on c.FBillID = a.fid  and  c.FEntryID = b.fid \r\n");
        sql.append(" left outer join (" + verifyAmtSql + ") m on m.fid=c.fid \r\n");
        sql.append(" inner join T_bd_assistanthg hg on c.FassgrpId =hg.fid     \t\t\t\t\t\t\t\t\t\t\t\r\n  ");
        if (param.get("items") != null) {
            ArrayList items = (ArrayList)param.get("items");
            for (int i = 0; i < items.size(); ++i) {
                Map item = (Map)items.get(i);
                String tablename = (String)item.get("tablename");
                String field = (String)item.get("fieldname");
                String numberfrom = (String)item.get("numberfrom");
                String id = (String)item.get("itemId");
                if (id != null) {
                    sql.append(" inner join ").append(tablename).append(" item").append(i).append(" on ").append(" item").append(i).append(".fid =hg.").append(field).append(" and").append(" item").append(i).append(".fid='").append(id).append("'\t\t\t\r\n");
                    continue;
                }
                if (numberfrom == null) continue;
                sql.append(" inner join ").append(tablename).append(" item").append(i).append(" on ").append(" item").append(i).append(".fid =hg.").append(field).append(" and").append(" item").append(i).append(".fnumber='").append(numberfrom).append("'\t\t\t\r\n");
            }
        }
        sql.append(" inner join t_bd_accountview v  on v.fid=b.FAccountID \r\n");
        sql.append(" inner join v_gl_acperiod acp  on acp.fperiodid=a.fperiodid\t \r\n");
        sql.append(" where a.FIsAC = 1 and b.FIsVerify = 1 and  c.fIsVierified = 0  \r\n ");
        if (excludeUnPostVch) {
            sql.append("and a.fbizstatus = 5 \r\n");
        } else {
            sql.append("and a.fbizstatus <> 0 and a.fbizstatus <> 2 \r\n");
        }
        sql.append(" and acp.fcompanyid = ? \r\n");
        sql.append(" and a.FCompanyID = ? \r\n");
        sql.append(" and b.FCurrencyID in ").append(currencyID).append(" \r\n ");
        sql.append(" and b.FAccountID in ").append(accountID).append(" \r\n ");
        listParam.add(companyID);
        listParam.add(companyID);
        listParam.add(companyID);
        listParam.add(companyID);
        if (bizDateFrom != null) {
            sql.append(" and c.FBizDate >= ?  ");
            listParam.add(begin);
        }
        if (bizDateTo != null) {
            sql.append(" and c.FBizDate <= ?  ");
            listParam.add(end);
        }
        if (bizNumber != null) {
            sql.append(" and c.FBizNumber like ?  ");
            listParam.add(bizNumber);
        }
        if (nullBizNumIsNotSame) {
            sql.append(" and c.FBizNumber is not null ");
        }
        boolean isFromVoucherUI = false;
        if (param.get("isFromVoucherUI") != null) {
            isFromVoucherUI = (Boolean)param.get("isFromVoucherUI");
        }
        if (isFromVoucherUI) {
            sql.append(" and c.FOriginalAmount < 0 ");
        } else {
            sql.append(" and c.FOriginalAmount > 0 ");
        }
        return sql;
    }

    public List getCurrencyListFromParam(Context ctx, HashMap param, AccountViewInfo acct) throws EASBizException, BOSException {
        ArrayList<Object> listCurrencyID = new ArrayList<Object>();
        boolean isAllCurrency = false;
        if (((CurrencyInfo)param.get("currency")).getNumber().compareToIgnoreCase("all") == 0) {
            AccountingCurrencyEnum acctCy = AccountingCurrencyEnum.ALLCURRENCY;
            if (acct != null) {
                acctCy = acct.getAccountingcurrency();
            }
            if (acctCy == AccountingCurrencyEnum.NOCURRENCY) {
                listCurrencyID.add(param.get("LOCALCURRENCY"));
            } else if (acctCy == AccountingCurrencyEnum.ONECURRENCY) {
                CurrencyCollection cyColl = this.getAcctCyColl(ctx, acct);
                Iterator it = cyColl.iterator();
                while (it.hasNext()) {
                    listCurrencyID.add((CurrencyInfo)it.next());
                }
            } else if (acctCy == AccountingCurrencyEnum.ALLCURRENCY) {
                CurrencyCollection cyColl = this.getAllCyColl(ctx);
                Iterator it = cyColl.iterator();
                while (it.hasNext()) {
                    listCurrencyID.add((CurrencyInfo)it.next());
                }
            }
            isAllCurrency = true;
        } else {
            listCurrencyID.add(param.get(ACAuditCancelFilterHelper.ACAuditCancelParamKey.CURRENCY));
        }
        return listCurrencyID;
    }

    private CurrencyCollection getAcctCyColl(Context ctx, AccountViewInfo acct) throws BOSException, EASBizException {
        CurrencyCollection CyColl = new CurrencyCollection();
        IAccountCurrency iac = AccountCurrencyFactory.getLocalInstance((Context)ctx);
        AccountCurrencyCollection acColl = iac.getAccountCurrencyCollection("select currency.id where accountView.id = '" + acct.getId().toString() + "'");
        AccountCurrencyInfo acInfo = null;
        CurrencyInfo cyInfo = null;
        for (int i = 0; i < acColl.size(); ++i) {
            acInfo = acColl.get(i);
            cyInfo = new CurrencyInfo();
            cyInfo.setId(acInfo.getCurrency().getId());
            CyColl.add(cyInfo);
        }
        return CyColl;
    }

    private CurrencyCollection getAllCyColl(Context ctx) throws BOSException, EASBizException {
        CurrencyCollection CyColl = new CurrencyCollection();
        ICurrency icy = CurrencyFactory.getLocalInstance((Context)ctx);
        CyColl = icy.getCurrencyCollection(true);
        return CyColl;
    }

    private String createTempTable4SrcDesData(Context ctx) throws BOSException {
        String tempateTable = "GLACAuditCacelFacadeControllerBean";
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ").append(tempateTable);
        sql.append(" (FID varchar(44) NOT NULL,    \r\n");
        sql.append(" FNumber varchar(200), FBizDate datetime, FBizNumber varchar(200),FBookedDate datetime,\t\r\n");
        sql.append(" FDescription nvarchar(255),FDC int,  \r\n");
        sql.append(" FOriginalAmount numeric(28,10) default(0) not null,FAssGrpID varchar(44),voucherAssistRecordID varchar(44),\t \r\n");
        sql.append(" FUnverifiedAmtFor numeric(28,10) default(0) not null,  \r\n");
        sql.append(" FVerifiedAmtFor  numeric(28,10) default(0) not null,FLastUpdateTime datetime \r\n");
        sql.append("  ,FCurrencyID varchar(44) NOT NULL, FAccountID varchar(44) NOT NULL   \r\n");
        sql.append(" )      \r\n");
        try {
            tempateTable = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempateTable;
    }
}

