/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.BizBalanceException;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.BizHasDealException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.IBatchBizCheckBalance;
import com.kingdee.eas.common.app.IBatchBizHasDeal;
import com.kingdee.eas.common.app.IBizCheckBalance;
import com.kingdee.eas.common.app.IBizHasDeal;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLBaseDataCheckException;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class GLAccountHasDeal
implements IBizHasDeal,
IBizCheckBalance,
IBatchBizCheckBalance,
IBatchBizHasDeal {
    private static final Logger logger = Logger.getLogger((String)GLAccountHasDeal.class.getName());

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BizCheckResult checkHasDeal(Context ctx, BOSUuid id) throws BizHasDealException {
        int index;
        StringBuffer sql;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block8: {
            String strAcct;
            block7: {
                con = null;
                stmt = null;
                rs = null;
                sql = new StringBuffer();
                strAcct = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"Account", (Locale)ctx.getLocale());
                SelectorItemCollection selec = new SelectorItemCollection();
                selec.add("id");
                selec.add("companyid.id");
                con = GlUtils.getConnection(ctx);
                sql = new StringBuffer();
                sql.append("select 1 where exists                                                                                                      \t\t\t\t\t\r\n");
                sql.append("( select 1                                                                                                                  \t\t\t\t\t\r\n");
                sql.append("from t_gl_VoucherEntry                                                                                                                         \t\r\n");
                sql.append(" where \tFAccountID = ? \t\r\n");
                sql.append(") \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                stmt = con.prepareStatement(sql.toString());
                index = 1;
                stmt.setString(index++, id.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block7;
                BizCheckResult bizCheckResult = new BizCheckResult(true, (EASBizException)new GLBaseDataCheckException(GLBaseDataCheckException.REF_BY_VOUCHER, new Object[]{strAcct}));
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
                return bizCheckResult;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql = new StringBuffer();
            sql.append("select 1 where exists                                                   \r\n");
            sql.append("( select 1                                                          \t\r\n");
            sql.append("from t_gl_InitAccountBalance bal                                        \r\n");
            sql.append("where bal.FAccountID = ?                                                \r\n");
            sql.append(" \tand (fbeginbalancefor<>0 or fyeardebitfor<>0 or fyearcreditfor<>0  or fdebitfor<>0  or fcreditfor<>0\t").append(" or fendbalancefor<>0  or fbeginbalancelocal<>0  or fyeardebitlocal<>0  or fyearcreditlocal<>0 \t\t\t\t\t").append(" or fdebitlocal<>0  or fcreditlocal<>0  or fendbalancelocal<>0  or fbeginbalancerpt<>0 \t\t\t\t\t\t").append(" or fyeardebitrpt<>0  or fyearcreditrpt<>0  or fdebitrpt<>0  or fcreditrpt<>0  or fendbalancerpt<>0\t\t\t\t").append(" or fyearpnlfor<>0  or fmonthpnlfor<>0  or fyearpnllocal<>0  or fmonthpnllocal<>0  or fyearpnlrpt<>0  or fmonthpnlrpt<>0\t").append(" or fbeginqty<>0  or fyeardebitqty<>0  or fyearcreditqty<>0  or fdebitqty<>0  or fcreditqty<>0  or fendqty<>0\t\t\t\t").append("))");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            stmt.setString(index++, id.toString());
            rs = stmt.executeQuery();
            if (!rs.next()) break block8;
            BizCheckResult bizCheckResult = new BizCheckResult(true, (EASBizException)new GLBaseDataCheckException(GLBaseDataCheckException.REF_BY_INITACCTBAL, new Object[]{strAcct}));
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
            return bizCheckResult;
        }
        try {
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql = new StringBuffer();
            sql.append("delete from T_BD_VoucherTypeCtrlItems where fid in                                   \r\n");
            sql.append("(                                                                                    \r\n");
            sql.append("select vtc.fid from T_BD_VoucherTypeCtrlItems vtc inner join T_BD_VoucherTypes vt    \r\n");
            sql.append("on vtc.FVoucherTypeID = vt.FID                                                       \r\n");
            sql.append("where vtc.FAccountID = ?                                                             \r\n");
            sql.append(")                                                                                    \r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            stmt.setString(index++, id.toString());
            stmt.execute();
            SQLUtils.cleanup((Statement)stmt);
        }
        catch (SQLDataException sqle) {
            try {
                logger.error((Object)sqle);
                throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)sqle);
                catch (SQLException sqle2) {
                    logger.error((Object)sqle2);
                    throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)sqle2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return new BizCheckResult(false);
    }

    public BizCheckResult checkHasBalance(Context ctx, BOSUuid id) throws BizBalanceException {
        return this.checkHasBalance(ctx, id.toString(), false);
    }

    public BizCheckResult checkHasBalance(Context ctx, List ids, String orgPK) throws BizBalanceException {
        if (ids == null || ids.size() != 1 || ids.get(0) == null) {
            throw new IllegalArgumentException("Account ID list should have one element!");
        }
        this.checkAcctQty(ctx, ids.get(0).toString(), orgPK);
        return this.checkHasBalance(ctx, ids.get(0).toString(), true);
    }

    private BizCheckResult checkHasBalance(Context ctx, String id, boolean isCheckSubAccount) throws BizBalanceException {
        StringBuffer sql = new StringBuffer();
        String fname = "fname_" + ctx.getLocale().getLanguage();
        String companyLongNumber = ContextUtil.getCurrentFIUnit((Context)ctx).getLongNumber();
        String strAcct = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"Account", (Locale)ctx.getLocale());
        try {
            Object[] params;
            String accountFilter;
            String companyFilter;
            sql.append("select fid,fnumber,flongnumber,faccounttableid from t_bd_accountview where fid=?");
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id.toString()});
            String flongnumber = null;
            String faccounttableid = null;
            String fnumber = null;
            if (set != null && set.next()) {
                fnumber = set.getString("fnumber");
                flongnumber = set.getString("flongnumber");
                faccounttableid = set.getString("faccounttableid");
                strAcct = strAcct + fnumber;
            }
            sql = new StringBuffer();
            sql.append(" select top 1 fid from t_bd_accountview where fupperid=?");
            set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id.toString()});
            boolean hasAssigned = false;
            if (set != null && set.next()) {
                hasAssigned = true;
            }
            if (hasAssigned) {
                if (isCheckSubAccount) {
                    companyFilter = " or com.FLongNumber like ?";
                    accountFilter = " or av.flongnumber like ?";
                    params = new Object[]{faccounttableid, flongnumber, flongnumber + "!%", faccounttableid, companyLongNumber, companyLongNumber + "!%"};
                } else {
                    companyFilter = " or com.FLongNumber like ?";
                    accountFilter = "";
                    params = new Object[]{faccounttableid, flongnumber, faccounttableid, companyLongNumber, companyLongNumber + "!%"};
                }
            } else if (isCheckSubAccount) {
                companyFilter = "";
                accountFilter = " or av.flongnumber like ?";
                params = new Object[]{faccounttableid, flongnumber, flongnumber + "!%", faccounttableid, companyLongNumber};
            } else {
                companyFilter = "";
                accountFilter = "";
                params = new Object[]{faccounttableid, flongnumber, faccounttableid, companyLongNumber};
            }
            sql = new StringBuffer();
            sql.append(" select  com.fnumber, com.").append(fname).append(" from t_org_company com \r\n").append(" inner join t_bd_accountview av on av.fcompanyid=com.fid and av.faccounttableid=? and (av.flongnumber=? ").append(accountFilter).append(" ) \r\n").append(" inner join t_bd_systemstatusctrol ssc on ssc.fcompanyid=com.fid \r\n").append(" inner join t_bd_systemstatus ss on ss.fid=ssc.fsystemstatusid and ss.fname=6 \r\n").append(" inner join t_bd_period p on p.fid = ssc.fCurrentPeriodid \r\n").append(" where com.faccounttableid = ? and com.fisbizunit=1 and (com.FLongNumber = ? ").append(companyFilter).append(" ) \r\n").append(" and exists ( \r\n").append(" select 1 from " + GLBalanceUtils.getAccountBalanceTable(1, null) + " bal \r\n").append(" where bal.forgunitid=com.fid \r\n").append(" and bal.FAccountID = av.fid \r\n").append(" and bal.FPeriod = p.fnumber \r\n").append(" and FEndBalanceFor <> 0  \r\n").append(" union  \r\n").append("select 1 from " + GLBalanceUtils.getAccountBalanceTable(5, null) + " bal \r\n").append(" where bal.forgunitid=com.fid \r\n").append(" and bal.FAccountID = av.fid \r\n").append(" and bal.FPeriod = p.fnumber \r\n").append(" and FEndBalanceFor <> 0  \r\n").append(" union  \r\n").append("select 1 from T_GL_AssistBalance_1F bal \r\n").append(" where bal.forgunitid=com.fid \r\n").append(" and bal.FAccountID = av.fid \r\n").append(" and bal.FPeriod = p.fnumber \r\n").append(" and FEndBalanceFor <> 0  \r\n").append(" union  \r\n").append("select 1 from T_GL_AssistBalance_5F bal \r\n").append(" where bal.forgunitid=com.fid \r\n").append(" and bal.FAccountID = av.fid \r\n").append(" and bal.FPeriod = p.fnumber \r\n").append(" and FEndBalanceFor <> 0  \r\n").append(") \r\n");
            set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            StringBuffer msg = new StringBuffer();
            while (set.next()) {
                String companynumber = set.getString("fnumber");
                String name = set.getString(fname);
                msg.append(companynumber + name + ";");
            }
            if (!StringUtils.isEmpty((String)msg.toString())) {
                msg.setLength(msg.length() - 1);
                throw new GLBaseDataCheckException(GLBaseDataCheckException.HAS_ACCTBAL2, new Object[]{msg.toString(), strAcct});
            }
        }
        catch (SQLDataException sqle) {
            logger.error((Object)sqle);
            throw new BizBalanceException(BizBalanceException.SQL_ERR, (Throwable)sqle);
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            throw new BizBalanceException(BizBalanceException.SQL_ERR, (Throwable)sqle);
        }
        catch (GLBaseDataCheckException e) {
            logger.error((Object)e);
            throw new BizBalanceException(new NumericExceptionSubItem(e.getCode(), e.getMessage()), (Throwable)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BizBalanceException(BizBalanceException.SQL_ERR, (Throwable)e);
        }
        return new BizCheckResult(false);
    }

    private void checkAcctQty(Context ctx, String acctId, String pkOrg) throws BizBalanceException {
        if (StringUtils.isEmpty((String)pkOrg) || StringUtils.isEmpty((String)acctId)) {
            return;
        }
        String sqlPeriod = "select ctrol.FcurrentPeriodID periodId from t_bd_systemstatusctrol ctrol inner join t_bd_systemstatus stat on stat.fid = ctrol.fsystemstatusid where ctrol.fcompanyid = ? and stat.FNAME = 6";
        String curPeriodId = "";
        try {
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(pkOrg));
            if (GlUtils.isCompanyUnion(companyInfo)) {
                String accSql = "select fnumber from T_BD_AccountView where fid = ? ";
                String accNumber = "";
                IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)accSql, (Object[])new Object[]{acctId});
                while (rows.next()) {
                    accNumber = rows.getString("fnumber");
                }
                if (StringUtils.isEmpty((String)accNumber)) {
                    return;
                }
                String sql = "select fid from T_ORG_BaseUnit  where FPARENTID = ?";
                String bizUnitAcctSql = "select fid from T_BD_AccountView where fnumber = ? and FCOMPANYID = ? and FACCOUNTTABLEID = ?";
                rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pkOrg});
                while (rows.next()) {
                    String orgId = rows.getString("fid");
                    CompanyOrgUnitInfo bizCompanyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                    String accountTable = bizCompanyInfo.getAccountTable() == null ? "" : bizCompanyInfo.getAccountTable().getId().toString();
                    String trueAccountId = "";
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)bizUnitAcctSql, (Object[])new Object[]{accNumber, orgId, accountTable});
                    if (rs.next()) {
                        trueAccountId = rs.getString("fid");
                    }
                    if ((rs = DbUtil.executeQuery((Context)ctx, (String)sqlPeriod, (Object[])new Object[]{orgId})).next()) {
                        curPeriodId = rs.getString("periodId");
                    }
                    if (StringUtils.isEmpty((String)curPeriodId)) continue;
                    PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(curPeriodId));
                    this.checkAcctQtyBalance(ctx, trueAccountId, orgId, period.getNumber());
                }
            } else {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlPeriod, (Object[])new Object[]{pkOrg});
                if (rs.next()) {
                    curPeriodId = rs.getString("periodId");
                }
                if (!StringUtils.isEmpty((String)curPeriodId)) {
                    PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(curPeriodId));
                    this.checkAcctQtyBalance(ctx, acctId, pkOrg, period.getNumber());
                }
            }
        }
        catch (BizBalanceException e) {
            logger.error((Object)e);
            throw new BizBalanceException(new NumericExceptionSubItem(e.getCode(), e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void checkAcctQtyBalance(Context ctx, String acctId, String curCompanyID, int curPeriodNumber) throws BizBalanceException {
        try {
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCompanyID));
            BigDecimal minQtyByPrecision = GlUtils.getMinQtyByPrecision(ctx, curCompanyID);
            String strQtyBalNotZero = "abs(bal.FEndQty) >= " + minQtyByPrecision.toPlainString();
            StringBuffer sql = new StringBuffer();
            sql.append("Select 1 where exists (Select 1                                                               \t\t\t\r\n");
            sql.append("From " + GLBalanceUtils.getAccountBalanceTable(5) + " bal,                                                             \r\n");
            sql.append("\tt_bd_accountview acct                                                              \r\n");
            sql.append("Where bal.FOrgUnitID = ?                                                                  \r\n");
            sql.append("\tand bal.FPeriod = ?                                                                   \r\n");
            sql.append("\tand acct.FCompanyID = ?                                                                 \r\n");
            sql.append("\tand ( ").append(strQtyBalNotZero).append(") \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("\tand bal.FAccountID = acct.FID                                                         \r\n");
            sql.append("\tand bal.FOrgUnitID = acct.FCompanyId                                                         \r\n");
            sql.append("\tand acct.FIsLeaf = 1                                                               \r\n");
            sql.append("\tand acct.fid = ?                                                                   \r\n");
            sql.append("\tand acct.FCAA is null                                                               \r\n");
            sql.append("    and acct.fbw = 0                            \r\n");
            sql.append(" union  \r\n");
            sql.append("Select 1                                                               \t\t\t\r\n");
            sql.append("From " + GLBalanceUtils.getAccountBalanceTable(1) + " bal,                                                             \r\n");
            sql.append("\tt_bd_accountview acct                                                              \r\n");
            sql.append("Where bal.FOrgUnitID = ?                                                                  \r\n");
            sql.append("\tand bal.FPeriod = ?                                                                   \r\n");
            sql.append("\tand acct.FCompanyID = ?                                                                 \r\n");
            sql.append("\tand ( ").append(strQtyBalNotZero).append(") \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("\tand bal.FAccountID = acct.FID                                                         \r\n");
            sql.append("\tand bal.FOrgUnitID = acct.FCompanyId                                                         \r\n");
            sql.append("\tand acct.FIsLeaf = 1                                                               \r\n");
            sql.append("\tand acct.fid = ?                                                                   \r\n");
            sql.append("\tand acct.FCAA is null                                                               \r\n");
            sql.append("    and acct.fbw = 0                            \r\n");
            sql.append(")                                               \t\t\t\t\t\t\r\n");
            sql.append("; \r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCompanyID, curPeriodNumber, curCompanyID, acctId, curCompanyID, curPeriodNumber, curCompanyID, acctId});
            if (rs.next()) {
                throw new GLBaseDataCheckException(GLBaseDataCheckException.ACCOUNT_QTY_NOT_ZERO, new Object[]{companyInfo.getName()});
            }
            boolean isAsstQty = GlUtils.getDefaultGLParam(ctx, null, "G010");
            sql = new StringBuffer();
            if (isAsstQty) {
                sql.append("Select 1 where exists (Select 1                                                                \t\t\t\r\n");
                sql.append("From " + GLBalanceUtils.getAssistMeasureBalanceTable(5) + " bal,                                                             \r\n");
                sql.append("\tt_bd_accountview acct,                                                                \r\n");
                sql.append("    T_BD_AsstAccount asst \r\n");
                sql.append("Where bal.FOrgUnitID = ?                                                                  \r\n");
                sql.append("\tand bal.FPeriod = ?                                                                   \r\n");
                sql.append("\tand acct.FCompanyID = ?                                                                 \r\n");
                sql.append("\tand ( ").append(strQtyBalNotZero).append(" ) \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("\tand bal.FAccountID = acct.FID                                                         \r\n");
                sql.append("\tand acct.FIsLeaf = 1                                                               \r\n");
                sql.append("\tand (acct.FCAA is not null)                                                        \r\n");
                sql.append("    and acct.fbw = 0                            \r\n");
                sql.append(" and acct.fisqty=1 and  asst.fisqty=1  \r\n");
                sql.append(" and acct.fnumber in(  \r\n");
                sql.append(" select acct.fnumber  \r\n");
                sql.append("  from " + GLBalanceUtils.getAssistBalanceTable(5) + " bal  \r\n");
                sql.append("  \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID  \r\n");
                sql.append("  \tleft join T_BD_AsstAccount asst on asst.FID = acct.FCAA  \r\n");
                sql.append("  \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID  \r\n");
                sql.append("  where  \r\n");
                sql.append("  \tbal.FOrgUnitID = ?  \r\n");
                sql.append("  \tand bal.FPeriod = ?  \r\n");
                sql.append("\tand acct.FCompanyID = ?                                                                 \r\n");
                sql.append("  \tand (acct.FCAA is not null)  \r\n");
                sql.append("  \tand acct.FIsLeaf = 1  \r\n");
                sql.append("\tand acct.fid = ?                                                                   \r\n");
                sql.append("  \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0  \r\n");
                sql.append("  \t or bal.FEndBalanceRpt <> 0\t or ").append(strQtyBalNotZero).append(" )  \r\n");
                sql.append("  )  \r\n");
                sql.append(" union  \r\n");
                sql.append("Select 1                                                                \t\t\t\r\n");
                sql.append("From " + GLBalanceUtils.getAssistMeasureBalanceTable(1) + " bal,                                                             \r\n");
                sql.append("\tt_bd_accountview acct,                                                                \r\n");
                sql.append("    T_BD_AsstAccount asst \r\n");
                sql.append("Where bal.FOrgUnitID = ?                                                                  \r\n");
                sql.append("\tand bal.FPeriod = ?                                                                   \r\n");
                sql.append("\tand acct.FCompanyID = ?                                                                 \r\n");
                sql.append("\tand ( ").append(strQtyBalNotZero).append(" ) \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("\tand bal.FAccountID = acct.FID                                                         \r\n");
                sql.append("\tand acct.FIsLeaf = 1                                                               \r\n");
                sql.append("\tand (acct.FCAA is not null)                                                        \r\n");
                sql.append("    and acct.fbw = 0                            \r\n");
                sql.append(" and acct.fisqty=1 and  asst.fisqty=1  \r\n");
                sql.append(" and acct.fnumber in(  \r\n");
                sql.append(" select acct.fnumber  \r\n");
                sql.append("  from " + GLBalanceUtils.getAssistBalanceTable(1) + " bal  \r\n");
                sql.append("  \tinner join t_bd_accountview acct on acct.FID = bal.FAccountID  \r\n");
                sql.append("  \tleft join T_BD_AsstAccount asst on asst.FID = acct.FCAA  \r\n");
                sql.append("  \tleft join t_BD_MeasureUnitGroup mugrp on mugrp.FID = asst.FMeasureUnitGroupID  \r\n");
                sql.append("  where  \r\n");
                sql.append("  \tbal.FOrgUnitID = ?  \r\n");
                sql.append("  \tand bal.FPeriod = ?  \r\n");
                sql.append("\tand acct.FCompanyID = ?                                                                 \r\n");
                sql.append("  \tand (acct.FCAA is not null)  \r\n");
                sql.append("  \tand acct.FIsLeaf = 1  \r\n");
                sql.append("\tand acct.fid = ?                                                                   \r\n");
                sql.append("  \tand (bal.FEndBalanceFor <> 0 or bal.FEndBalanceLocal <> 0  \r\n");
                sql.append("  \t or bal.FEndBalanceRpt <> 0\t or ").append(strQtyBalNotZero).append(" )  \r\n");
                sql.append("  )  \r\n");
                sql.append(")                                               \t\t\t\t\t\t\r\n");
                sql.append("; \r\n");
            } else {
                sql.append("Select 1 where exists (Select 1                                                                \t\t\t\r\n");
                sql.append("From " + GLBalanceUtils.getAssistBalanceTable(5) + " bal,                                                             \r\n");
                sql.append("\tt_bd_accountview acct                                                                \r\n");
                sql.append("Where bal.FOrgUnitID = ?                                                                  \r\n");
                sql.append("\tand bal.FPeriod = ?                                                                   \r\n");
                sql.append("\tand acct.FCompanyID = ?                                                                 \r\n");
                sql.append("\tand ( ").append(strQtyBalNotZero).append(" ) \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("\tand bal.FAccountID = acct.FID                                                         \r\n");
                sql.append("\tand acct.fid = ?                                                                   \r\n");
                sql.append("\tand acct.FIsLeaf = 1                                                               \r\n");
                sql.append("\tand (acct.FCAA is not null)                                                        \r\n");
                sql.append("    and acct.fbw = 0                            \r\n");
                sql.append(" union  \r\n");
                sql.append("Select 1                                                                \t\t\t\r\n");
                sql.append("From " + GLBalanceUtils.getAssistBalanceTable(1) + " bal,                                                             \r\n");
                sql.append("\tt_bd_accountview acct                                                                \r\n");
                sql.append("Where bal.FOrgUnitID = ?                                                                  \r\n");
                sql.append("\tand bal.FPeriod = ?                                                                   \r\n");
                sql.append("\tand acct.FCompanyID = ?                                                                 \r\n");
                sql.append("\tand ( ").append(strQtyBalNotZero).append(" ) \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
                sql.append("\tand bal.FAccountID = acct.FID                                                         \r\n");
                sql.append("\tand acct.fid = ?                                                                   \r\n");
                sql.append("\tand acct.FIsLeaf = 1                                                               \r\n");
                sql.append("\tand (acct.FCAA is not null)                                                        \r\n");
                sql.append("    and acct.fbw = 0                            \r\n");
                sql.append(")                                               \t\t\t\t\t\t\r\n");
                sql.append("; \r\n");
            }
            if (isAsstQty) {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCompanyID, curPeriodNumber, curCompanyID, curCompanyID, curPeriodNumber, curCompanyID, acctId, curCompanyID, curPeriodNumber, curCompanyID, curCompanyID, curPeriodNumber, curCompanyID, acctId});
                if (rs.next()) {
                    throw new GLBaseDataCheckException(GLBaseDataCheckException.MEASURE_QTY_NOT_ZERO, new Object[]{companyInfo.getName()});
                }
            } else {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curCompanyID, curPeriodNumber, curCompanyID, acctId, curCompanyID, curPeriodNumber, curCompanyID, acctId});
                if (rs.next()) {
                    throw new GLBaseDataCheckException(GLBaseDataCheckException.ASSIST_QTY_NOT_ZERO, new Object[]{companyInfo.getName()});
                }
            }
        }
        catch (GLBaseDataCheckException e) {
            logger.error((Object)e);
            throw new BizBalanceException(new NumericExceptionSubItem(e.getCode(), e.getMessage()), (Throwable)((Object)e));
        }
        catch (GLPeriodEndException e) {
            logger.error((Object)e);
            throw new BizBalanceException(new NumericExceptionSubItem(e.getCode(), e.getMessage()), (Throwable)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BizCheckResult checkHasDeal(Context ctx, List ids, String orgPK) throws BizHasDealException {
        StringBuffer sql;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        StringBuffer idSet;
        block21: {
            StringBuffer clearZero;
            String strAcct;
            block20: {
                block19: {
                    BizCheckResult checkResult;
                    block18: {
                        BizCheckResult checkResult2;
                        if (ids == null) return new BizCheckResult(false);
                        if (ids.size() == 0) {
                            return new BizCheckResult(false);
                        }
                        String lastAccountID = null;
                        String companyID = null;
                        idSet = new StringBuffer();
                        idSet.append("''");
                        Iterator iterator = ids.iterator();
                        while (iterator != null && iterator.hasNext()) {
                            Object id = iterator.next();
                            if (!iterator.hasNext()) {
                                lastAccountID = id.toString();
                            }
                            idSet.append(",'").append(id.toString()).append("'");
                        }
                        AccountViewInfo accInfo = new AccountViewInfo();
                        try {
                            IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
                            if (lastAccountID != null && lastAccountID.length() > 0) {
                                accInfo = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK(lastAccountID));
                            }
                            if (accInfo != null) {
                                companyID = accInfo.getCompanyID().getId().toString();
                            }
                            if (companyID == null) {
                                companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
                            }
                            String[] companyIds = new String[]{companyID};
                            GLBalanceFacadeFactory.getLocalInstance(ctx).updateVoucherBalance(companyIds);
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                        con = null;
                        stmt = null;
                        rs = null;
                        sql = new StringBuffer();
                        strAcct = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"Account", (Locale)ctx.getLocale());
                        con = GlUtils.getConnection(ctx);
                        sql = new StringBuffer();
                        sql.append("select top 1 FAccountID                                                                                                                  \t\t\t\t\t\r\n");
                        sql.append("from t_gl_VoucherEntry                                                                                                                         \t\r\n");
                        sql.append(" where \tFAccountID in (").append(idSet.toString()).append("); \t\r\n");
                        stmt = con.prepareStatement(sql.toString());
                        rs = stmt.executeQuery();
                        if (!rs.next()) break block18;
                        String accountID = rs.getString("FAccountID");
                        HashMap<String, String> detailMap = new HashMap<String, String>();
                        detailMap.put("FAccountID", accountID);
                        BizCheckResult bizCheckResult = checkResult2 = new BizCheckResult(true, (EASBizException)new GLBaseDataCheckException(GLBaseDataCheckException.REF_BY_VOUCHER, new Object[]{strAcct}), detailMap);
                        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
                        return bizCheckResult;
                    }
                    SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                    sql = new StringBuffer();
                    sql.append("select top 1 FAccountID                                                                                                                  \t\t\t\t\t\r\n");
                    sql.append("from t_gl_templatevoucherentry                                                                                                                         \t\r\n");
                    sql.append(" where \tFAccountID in (").append(idSet.toString()).append("); \t\r\n");
                    stmt = con.prepareStatement(sql.toString());
                    rs = stmt.executeQuery();
                    if (!rs.next()) break block19;
                    String accountID = rs.getString("FAccountID");
                    HashMap<String, String> detailMap = new HashMap<String, String>();
                    detailMap.put("FAccountID", accountID);
                    BizCheckResult bizCheckResult = checkResult = new BizCheckResult(true, (EASBizException)new GLBaseDataCheckException(GLBaseDataCheckException.REF_BY_TEMPLATEVOUCHER, new Object[]{strAcct}), detailMap);
                    SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
                    return bizCheckResult;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                clearZero = new StringBuffer();
                clearZero.append("delete from t_gl_initaccountbalance").append(" where fbeginbalancefor=0 and fyeardebitfor=0 and fyearcreditfor=0 and fdebitfor=0 and fcreditfor=0").append(" and fendbalancefor=0 and fbeginbalancelocal=0 and fyeardebitlocal=0 and fyearcreditlocal=0 ").append(" and fdebitlocal=0 and fcreditlocal=0 and fendbalancelocal=0 and fbeginbalancerpt=0 ").append(" and fyeardebitrpt=0 and fyearcreditrpt=0 and fdebitrpt=0 and fcreditrpt=0 and fendbalancerpt=0").append(" and fyearpnlfor=0 and fmonthpnlfor=0 and fyearpnllocal=0 and fmonthpnllocal=0 and fyearpnlrpt=0 and fmonthpnlrpt=0").append(" and fbeginqty=0 and fyeardebitqty=0 and fyearcreditqty=0 and fdebitqty=0 and fcreditqty=0 and fendqty=0").append(" and FAccountID in (").append(idSet.toString()).append(")");
                DbUtil.execute((Context)ctx, (String)clearZero.toString());
                sql = new StringBuffer();
                sql.append(" select top 1 bal.FAccountID                                                          \t\r\n");
                sql.append("from t_gl_InitAccountBalance bal                                        \r\n");
                sql.append("where bal.FAccountID in (").append(idSet.toString()).append(")                                                \r\n");
                sql.append(" \tand (fbeginbalancefor<>0 or fyeardebitfor<>0 or fyearcreditfor<>0  or fdebitfor<>0  or fcreditfor<>0\t").append(" or fendbalancefor<>0  or fbeginbalancelocal<>0  or fyeardebitlocal<>0  or fyearcreditlocal<>0 \t\t\t\t\t").append(" or fdebitlocal<>0  or fcreditlocal<>0  or fendbalancelocal<>0  or fbeginbalancerpt<>0 \t\t\t\t\t\t").append(" or fyeardebitrpt<>0  or fyearcreditrpt<>0  or fdebitrpt<>0  or fcreditrpt<>0  or fendbalancerpt<>0\t\t\t\t").append(" or fyearpnlfor<>0  or fmonthpnlfor<>0  or fyearpnllocal<>0  or fmonthpnllocal<>0  or fyearpnlrpt<>0  or fmonthpnlrpt<>0\t").append(" or fbeginqty<>0  or fyeardebitqty<>0  or fyearcreditqty<>0  or fdebitqty<>0  or fcreditqty<>0  or fendqty<>0\t\t\t\t").append(");");
                stmt = con.prepareStatement(sql.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block20;
                String accountID = rs.getString("FAccountID");
                HashMap<String, String> detailMap = new HashMap<String, String>();
                detailMap.put("FAccountID", accountID);
                BizCheckResult bizCheckResult = new BizCheckResult(true, (EASBizException)new GLBaseDataCheckException(GLBaseDataCheckException.REF_BY_INITACCTBAL, new Object[]{strAcct}), detailMap);
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
                return bizCheckResult;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            clearZero = new StringBuffer();
            clearZero.append("delete from t_gl_InitAssistBalance").append(" where fbeginbalancefor=0 and fyeardebitfor=0 and fyearcreditfor=0 and fdebitfor=0 and fcreditfor=0").append(" and fendbalancefor=0 and fbeginbalancelocal=0 and fyeardebitlocal=0 and fyearcreditlocal=0 ").append(" and fdebitlocal=0 and fcreditlocal=0 and fendbalancelocal=0 and fbeginbalancerpt=0 ").append(" and fyeardebitrpt=0 and fyearcreditrpt=0 and fdebitrpt=0 and fcreditrpt=0 and fendbalancerpt=0").append(" and fyearpnlfor=0 and fmonthpnlfor=0 and fyearpnllocal=0 and fmonthpnllocal=0 and fyearpnlrpt=0 and fmonthpnlrpt=0").append(" and fbeginqty=0 and fyeardebitqty=0 and fyearcreditqty=0 and fdebitqty=0 and fcreditqty=0 and fendqty=0").append(" and FAccountID in (").append(idSet.toString()).append(")");
            DbUtil.execute((Context)ctx, (String)clearZero.toString());
            sql = new StringBuffer();
            sql.append(" select top 1 bal.FAccountID                                                                                                             \t\t\t\t\t\r\n");
            sql.append("from t_gl_InitAssistBalance bal                                                                                                                        \r\n");
            sql.append("where bal.FAccountID in (").append(idSet.toString()).append(")                                                                                                                                \r\n");
            sql.append(" \tand (fbeginbalancefor<>0 or fyeardebitfor<>0 or fyearcreditfor<>0  or fdebitfor<>0  or fcreditfor<>0\t").append(" or fendbalancefor<>0  or fbeginbalancelocal<>0  or fyeardebitlocal<>0  or fyearcreditlocal<>0 \t\t\t\t\t").append(" or fdebitlocal<>0  or fcreditlocal<>0  or fendbalancelocal<>0  or fbeginbalancerpt<>0 \t\t\t\t\t\t").append(" or fyeardebitrpt<>0  or fyearcreditrpt<>0  or fdebitrpt<>0  or fcreditrpt<>0  or fendbalancerpt<>0\t\t\t\t").append(" or fyearpnlfor<>0  or fmonthpnlfor<>0  or fyearpnllocal<>0  or fmonthpnllocal<>0  or fyearpnlrpt<>0  or fmonthpnlrpt<>0\t").append(" or fbeginqty<>0  or fyeardebitqty<>0  or fyearcreditqty<>0  or fdebitqty<>0  or fcreditqty<>0  or fendqty<>0 \t\t\t").append(");");
            stmt = con.prepareStatement(sql.toString());
            rs = stmt.executeQuery();
            if (!rs.next()) break block21;
            String accountID = rs.getString("FAccountID");
            HashMap<String, String> detailMap = new HashMap<String, String>();
            detailMap.put("FAccountID", accountID);
            BizCheckResult bizCheckResult = new BizCheckResult(true, (EASBizException)new GLBaseDataCheckException(GLBaseDataCheckException.REF_BY_INITASSTBAL, new Object[]{strAcct}), detailMap);
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
            return bizCheckResult;
        }
        try {
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            this.clearZeroBalance(ctx, 1, 1, null, idSet);
            this.clearZeroBalance(ctx, 1, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", idSet);
            this.clearZeroBalance(ctx, 1, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", idSet);
            this.clearZeroBalance(ctx, 1, 5, null, idSet);
            this.clearZeroBalance(ctx, 1, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", idSet);
            this.clearZeroBalance(ctx, 1, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", idSet);
            this.clearZeroBalance(ctx, 2, 1, null, idSet);
            this.clearZeroBalance(ctx, 2, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", idSet);
            this.clearZeroBalance(ctx, 2, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", idSet);
            this.clearZeroBalance(ctx, 2, 5, null, idSet);
            this.clearZeroBalance(ctx, 2, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", idSet);
            this.clearZeroBalance(ctx, 2, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", idSet);
            this.clearZeroBalance(ctx, 3, 1, null, idSet);
            this.clearZeroBalance(ctx, 3, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", idSet);
            this.clearZeroBalance(ctx, 3, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", idSet);
            this.clearZeroBalance(ctx, 3, 5, null, idSet);
            this.clearZeroBalance(ctx, 3, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", idSet);
            this.clearZeroBalance(ctx, 3, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", idSet);
            sql = new StringBuffer();
            sql.append("delete from T_BD_VoucherTypeCtrlItems where fid in                                   \r\n");
            sql.append("(                                                                                    \r\n");
            sql.append("select vtc.fid from T_BD_VoucherTypeCtrlItems vtc inner join T_BD_VoucherTypes vt    \r\n");
            sql.append("on vtc.FVoucherTypeID = vt.FID                                                       \r\n");
            sql.append("where vtc.FAccountID in (").append(idSet.toString()).append(")                       \r\n");
            sql.append(")                                                                                    \r\n");
            stmt = con.prepareStatement(sql.toString());
            stmt.execute();
            SQLUtils.cleanup((Statement)stmt);
        }
        catch (SQLDataException sqle) {
            try {
                logger.error((Object)sqle);
                throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)sqle);
                catch (SQLException sqle2) {
                    logger.error((Object)sqle2);
                    throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)sqle2);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                    throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return new BizCheckResult(false);
    }

    private void clearZeroBalance(Context ctx, int balanceType, int balType, String currencyId, StringBuffer idSet) throws BOSException {
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer clearZero = new StringBuffer();
        clearZero.append("delete from " + GLBalanceUtils.getBalanceTable(balanceType, balType, currencyId));
        clearZero.append(" where FAccountID in (").append(idSet.toString()).append(")");
        if (isForCurrency) {
            clearZero.append(" and fbeginbalancefor=0 and fyeardebitfor=0 and fyearcreditfor=0 and fdebitfor=0 and fcreditfor=0 and fendbalancefor=0 ");
            clearZero.append(" and fyearpnlfor=0 and fmonthpnlfor=0 ");
        }
        if (isLocalCurrency || isForCurrency) {
            clearZero.append(" and fbeginbalancelocal=0 and fyeardebitlocal=0 and fyearcreditlocal=0 and fdebitlocal=0 and fcreditlocal=0 and fendbalancelocal=0 ");
            clearZero.append(" and fyearpnllocal=0 and fmonthpnllocal=0 ");
        }
        if (isRptCurrency || isForCurrency) {
            clearZero.append(" and fbeginbalancerpt=0 and fyeardebitrpt=0 and fyearcreditrpt=0 and fdebitrpt=0 and fcreditrpt=0 and fendbalancerpt=0 ");
            clearZero.append(" and fyearpnlrpt=0 and fmonthpnlrpt=0 ");
        }
        clearZero.append(" and fbeginqty=0 and fyeardebitqty=0 and fyearcreditqty=0 and fdebitqty=0 and fcreditqty=0 and fendqty=0");
        DbUtil.execute((Context)ctx, (String)clearZero.toString());
    }
}

