/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.AbstractGLAcctAgeSubFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.AccountAgeParam;
import com.kingdee.eas.fi.gl.app.GLAcctAgeNewUtils;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.app.voucher.AutoVerifyService;
import com.kingdee.eas.fi.gl.common.ACAuditCancelFilterHelper;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLAcctAgeSubFacadeControllerBean
extends AbstractGLAcctAgeSubFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLAcctAgeSubFacadeControllerBean");
    private final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.ReportAccountAgeResource";
    private final int showVerifyAge_AcZero = 0;
    private final int showVerifyAge = 1;
    private final int showCussentAge = 2;
    private Map<String, String> tempTableFieldType = null;

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return null;
    }

    protected RptParams _query(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        String querySql = params.getString("querySql");
        int from = params.getInt("from");
        int length = params.getInt("length");
        RptRowSet prs = this.executeQuery(ctx, querySql.toString(), null, from, length);
        RptParams rp = new RptParams();
        rp.setObject("prs", (Object)prs);
        return rp;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        AccountAgeParam paramAge = new AccountAgeParam();
        paramAge.setParams(new HashMap());
        this.dropTempTable(params.getString("tempTable"), ctx);
        String tempTable = "gl_acctage_sub_table";
        HashMap param = (HashMap)params.getObject("mapParam");
        String accountid = (String)param.get("accountid");
        String currencyid = (String)param.get("currencyid");
        int[] days = (int[])param.get("days");
        HashMap hmItems = (HashMap)param.get("hmItems");
        java.util.Date endDate = (java.util.Date)param.get("endDate");
        int[] undays = (int[])param.get("undays");
        boolean isShowUmexpired = (Boolean)param.get("isShowUmexpired");
        java.util.Date historyDate = (java.util.Date)param.get("historyDate");
        boolean isIncludeUnPosted = (Boolean)param.get("includeUnPosted");
        boolean isIncludeInit = (Boolean)param.get("includeInit");
        boolean isIncludeVerifyVch = param.get("includeVerifyVch") == null ? false : (Boolean)param.get("includeVerifyVch");
        boolean isBizCode = param.get("isBizCode") != null && (Boolean)param.get("isBizCode") != false;
        String companyid = (String)param.get("companyid");
        int dateType = (Integer)param.get("dateType");
        int indexType = (Integer)param.get("indexType");
        Object accountFrom = param.get("accountFrom");
        Object accountTo = param.get("accountTo");
        String curCompanyid = (String)param.get("curCompanyid");
        CompanyOrgUnitInfo _company = GlUtils.getCurrentCompany(ctx, curCompanyid, null, true);
        boolean isIsOnlyUnion = GlUtils.isCompanyUnion(_company);
        boolean isUnion = param.get("isUnion") != null ? (Boolean)param.get("isUnion") : false;
        this.tempTableFieldType = GLTempTableUtil.getDataTypes(ctx, "AccountAgeFacadeControllerBean", "acTable");
        int companyLevel = 0;
        HashMap otherInfo = null;
        boolean isfirstload = true;
        String accountViewNumber = null;
        String acctTableId = null;
        if (!isBizCode || indexType != 1) {
            String string = accountid = accountid != null && accountid.indexOf("'") == -1 ? "'" + accountid + "'" : accountid;
        }
        if ((indexType == 0 || isUnion) && param.get("accountViewNumber") != null && (isIsOnlyUnion || isUnion)) {
            accountViewNumber = (String)param.get("accountViewNumber");
            accountid = null;
        }
        if (param.get("hgid") != null) {
            paramAge.setHgid((String)param.get("hgid"));
        }
        int displayMode = 0;
        boolean isDisplayLeafCompany = false;
        if (isIsOnlyUnion) {
            displayMode = (Integer)param.get("displayMode");
            isDisplayLeafCompany = param.get("isDisplayLeafCompany").toString().equals("true");
        }
        GLAcctAgeNewUtils.prepareAccountAgeParam(paramAge, ctx, _company, isIsOnlyUnion, accountid, currencyid, days, undays, isShowUmexpired, hmItems, endDate, isIncludeUnPosted, isIncludeInit, companyid, dateType, indexType, accountFrom, accountTo, companyLevel, curCompanyid, accountViewNumber, otherInfo, acctTableId, isfirstload, isIncludeVerifyVch, isBizCode, historyDate, displayMode, isDisplayLeafCompany, null);
        paramAge.setAryAmountAge((BigDecimal[])param.get("aryAmountAge"));
        this.queryAgeSubByAcct(paramAge);
        tempTable = paramAge.getTempTableAcSum();
        StringBuffer rsOrder = new StringBuffer();
        StringBuffer orderAstFields = new StringBuffer();
        StringBuffer selectAstFields = new StringBuffer();
        if (!paramAge.isBizCode()) {
            for (int i = 0; i < paramAge.getAlAstFields().size(); ++i) {
                orderAstFields.append("T" + i + "fnumber ");
                orderAstFields.append(",");
                selectAstFields.append("T" + i + "fnumber ");
                selectAstFields.append(",");
                selectAstFields.append("T" + i + "fname ");
                selectAstFields.append(",");
            }
        } else if (hmItems.size() > 0) {
            orderAstFields.append("T0fnumber ");
            orderAstFields.append(",");
            selectAstFields.append("T0fnumber ");
            selectAstFields.append(",");
            selectAstFields.append("T0fname ");
            selectAstFields.append(",");
        }
        rsOrder.append(" \n order by ");
        if (!paramAge.isGeneralCy()) {
            rsOrder.append(" fcurrname,");
        }
        rsOrder.append(" FRange,");
        rsOrder.append(" FDataType,");
        rsOrder.append(" FDays,");
        rsOrder.append(" FPeriodNumber,FVoucherType,FVoucherNumber,");
        rsOrder.append(orderAstFields);
        rsOrder.append(paramAge.getStrDateType());
        Object[] aryAccount = (Object[])accountFrom;
        AccountViewInfo account = (AccountViewInfo)aryAccount[0];
        int accountDC = account.getDC().getValue();
        StringBuffer sql = new StringBuffer();
        sql.append("select case  when fdatatype = 1  then isnull(prd.FNumber,");
        sql.append("0) else prd.FNumber end FPeriodNumber,t.FBizDate,\r\n");
        sql.append("vchType.fname_").append(paramAge.getCtx().getLocale()).append(" FVoucherType, \r\n");
        sql.append("t.FVoucherNumber, t.FDescription,").append(selectAstFields);
        sql.append("t.FDays,t.FRange,t.FEndDate,t.fcurrname,t.FOriginalAmt, \r\n");
        if (paramAge.isGeneralCy()) {
            sql.append("t.FExchgRate,t.FLocalAmt,");
        }
        sql.append("t.FCurrID,t.FVoucherID,t.FDataType,t.FBizNumber  \r\n");
        if (paramAge.isGeneralCy()) {
            sql.append(",t.FExchgRatePRECISION  \r\n");
        }
        sql.append("from ").append(tempTable).append(" t \r\n").append(" left join t_bd_vouchertypes vchType on vchType.fid = t.fvouchertypeid \r\n").append(" left join t_bd_period prd on prd.fid = t.fperiodid       \r\n").append(rsOrder);
        int count = 0;
        try {
            String countSql = "select count(*) from " + tempTable;
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)countSql);
            if (result.next()) {
                count = result.getInt(1);
            }
            logger.error((Object)("zzz:query count:" + count));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        int limitCount = 10000;
        RptParams rp = new RptParams();
        if (count > limitCount) {
            rp.setBoolean("batchQuery", true);
            rp.setString("querySql", sql.toString());
            rp.setString("tempTable", tempTable);
            rp.setInt("totalCount", count);
            rp.setObject("header", (Object)this.getRptTableHeader(paramAge));
            rp.setInt("assSize", paramAge.getAlAstFields().size());
        } else {
            RptRowSet prs = this.executeQuery(sql.toString(), null, ctx);
            rp.setBoolean("batchQuery", false);
            rp.setString("tempTable", tempTable);
            rp.setObject("header", (Object)this.getRptTableHeader(paramAge));
            rp.setObject("prs", (Object)prs);
            rp.setInt("assSize", paramAge.getAlAstFields().size());
        }
        return rp;
    }

    protected void queryAgeSubByAcct(AccountAgeParam paramAge) throws BOSException, EASBizException {
        GLAcctAgeNewUtils.cachePeriodData(paramAge.getCtx(), paramAge.getCompanyId());
        GLAcctAgeNewUtils.dealwith_Param(paramAge);
        paramAge.setQueryAgeSub(true);
        Connection con = this.getConnection(paramAge.getCtx());
        try {
            GLAcctAgeNewUtils.prepareTempTableCompanyVerifyMode(paramAge);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        GLAcctAgeNewUtils.getSql_ByAcctBal_AmountField(paramAge);
        GLAcctAgeNewUtils.getSql_ByAcctBal_Param_AlDates(paramAge);
        GLAcctAgeNewUtils.prepareTempTableAdjExch(paramAge);
        GLAcctAgeNewUtils.getSql_ByAcctBal_SelectHgJoin(paramAge);
        StringBuffer sqlBizCodeHgid = new StringBuffer();
        if (paramAge.isBizCode() && paramAge.isAccountList()) {
            sqlBizCodeHgid = GLAcctAgeNewUtils.queryBizCodeHgid(paramAge);
        } else if (paramAge.isAccountBC() && (!paramAge.isAccountBCNoType() || paramAge.isIncludeVerifyVch())) {
            sqlBizCodeHgid = GLAcctAgeNewUtils.queryBizCodeHgid(paramAge);
        }
        paramAge.setSqlBizCodeHgid(sqlBizCodeHgid);
        String acTable = this.createAcTable(paramAge);
        paramAge.setTempTableAcSum(acTable);
        Map acMap = this.getAcRecordsSqlAndParams(paramAge);
        Map param = this.createParam(paramAge);
        param.put("tempTable", acTable);
        param.put("selector", this.initSelector(paramAge, null, null));
        param.put("acMap", acMap);
        param.put("isAgeVerify", true);
        param.put("isDetail", true);
        param.put("verifyField", paramAge.getStrDateType());
        param.put("amountField", "FOriginalAmt");
        if (paramAge.isIncludeVerifyVch()) {
            param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.QUERYBYBAL, true);
        }
        if (paramAge.isAccountList()) {
            param.put("isAccountList", true);
        }
        AutoVerifyService autoVerifyService = new AutoVerifyService();
        autoVerifyService.autoVerify(paramAge.getCtx(), param);
        try {
            this.deleteBalZeroAcFromTempTable(con, null, paramAge.getTempTableAcSum());
            if (!paramAge.isGeneralCy()) {
                this.insertTotalSumLines(con, paramAge);
            } else {
                this.calculateLocalAmt4GeneralCy(con, paramAge);
                this.insertTotalSumLines(con, paramAge);
                int iAdjust = this.calculateLocalAmt4Deviation(con, paramAge);
                this.insertTotalSumLines4GeneralCy(con, paramAge);
            }
        }
        catch (SQLException e1) {
            logger.error((Object)e1);
            throw new SQLAccessException(e1);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new SQLAccessException(e);
                }
            }
        }
    }

    private String createAcTable(AccountAgeParam paramAge) throws EASBizException, BOSException {
        StringBuffer createSql = new StringBuffer();
        createSql.append("(FActId VARCHAR(44), ");
        createSql.append(paramAge.getSqlCreateHgTbl());
        createSql.append("FVoucherId VARCHAR(44), ");
        createSql.append("FVoucherNumber VARCHAR(80), ");
        createSql.append("FPeriodID VARCHAR(44), \r\n");
        createSql.append("FPeriodNumber VARCHAR(80), ");
        createSql.append("FVoucherTypeID VARCHAR(44), ");
        createSql.append("FvoucherType VARCHAR(40), ");
        createSql.append("FNumber VARCHAR(40), ");
        createSql.append("FBizDate datetime, ");
        String bizNumberField = GLTempTableUtil.getDataType("FBizNumber", this.tempTableFieldType, "NVARCHAR(200)");
        createSql.append(bizNumberField).append(",");
        createSql.append("FDataType int DEFAULT 9 NOT NULL, ");
        createSql.append("FBookedDate datetime, FEndDate DateTime, ");
        createSql.append("FDescription NVARCHAR(255), FRangeDesc VARCHAR(40),  ");
        createSql.append("FDC int, FDays int ,FRange int, ");
        createSql.append("FOriginalAmt numeric(28,10), ");
        createSql.append("FExchgRate numeric(28, 10),  \r\n");
        createSql.append("FExchgRatePrecision numeric(28, 10),  \r\n");
        createSql.append("voucherAssistRecordID VARCHAR(44), ");
        createSql.append("FLocalAmt numeric(28,10)) ");
        return GLAcctAgeNewUtils.createTempTableByDDL(paramAge.getCtx(), "gl_act_datas", createSql);
    }

    private String initSelector(AccountAgeParam paramAge, String prefix, String amountField) {
        String selector = paramAge.getSqlSelectorHgTbl() + "FActId,FEndDate,FBizNumber,FDescription,FVoucherId,FVoucherNumber,FPeriodID,FVoucherTypeID,FDataType,fbizDate,FOriginalAmt";
        if (StringUtils.isEmpty((String)prefix)) {
            return selector;
        }
        String key = "," + prefix + ".";
        selector = selector.replace(",", key);
        if (!StringUtils.isEmpty((String)amountField)) {
            selector = selector.replace(key + "FOriginalAmt", amountField);
        }
        selector = "distinct " + selector;
        return selector;
    }

    private Map createParam(AccountAgeParam paramAge) {
        HashMap<String, Boolean> param = new HashMap<String, Boolean>();
        param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.EXCLUDEUNPOSTVCH, paramAge.isIncludeUnPosted());
        param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.NEGATIVEVERIFY, true);
        param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.UNCHECKBIZNUM, true);
        param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.NULLBIZNUMISNOTSAME, false);
        param.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYAMTMUSTSAME, false);
        return param;
    }

    private Map getAcRecordsSqlAndParams(AccountAgeParam paramAge) throws EASBizException, BOSException {
        StringBuffer hisSql = new StringBuffer();
        Object con = null;
        ArrayList params = new ArrayList();
        String selector = this.initSelector(paramAge, null, null);
        StringBuilder sql = new StringBuilder();
        Object ps = null;
        try {
            StringBuffer notInitSql = this.getSql_ByAcctBal_AcNotInit(paramAge);
            StringBuffer initSql = this.getSql_ByAcctBal_AcInit(paramAge);
            if (paramAge.isIncludeInit()) {
                notInitSql.append(" union all \r\n").append(initSql);
            }
            sql.append(notInitSql);
            int index = 1;
            index = GLAcctAgeNewUtils.setupParams_ByAcctBal_InsertSub(false, null, paramAge, paramAge.getHistoryDate(), new ArrayList(), params, index, null, paramAge.getLastPhaseBeginDate());
            if (paramAge.isIncludeInit()) {
                index = GLAcctAgeNewUtils.setupParams_ByAcctBal_InsertSub(true, null, paramAge, paramAge.getHistoryDate(), new ArrayList(), params, index, null, null);
            }
            hisSql = GLAcctAgeNewUtils.getHistorySqlUnAcVerify(paramAge);
            params.addAll(GLAcctAgeNewUtils.getUnVerifyParam(paramAge, true));
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new SQLAccessException(e);
        }
        selector = this.initSelector(paramAge, null, null);
        HashMap<String, Object> acMap = new HashMap<String, Object>();
        acMap.put("srcSql", sql.toString());
        acMap.put("acSelector", selector);
        acMap.put("hisSql", hisSql.toString());
        acMap.put("hisSelector", selector);
        acMap.put("srcParams", params);
        if (paramAge.isIncludeVerifyVch()) {
            StringBuffer sql6VeriSum = this.getSql_ByBal_AcVeriSum(paramAge);
            StringBuffer sql7HistorySql4Verified = GLAcctAgeNewUtils.getHistorySqlUnVerify(paramAge);
            List veriParam = GLAcctAgeNewUtils.getUnVerifyParam(paramAge, false);
            acMap.put("desSql", sql6VeriSum.toString());
            acMap.put("desParams", veriParam);
            acMap.put("desSelector", selector);
            acMap.put("hisDesSql", sql7HistorySql4Verified.toString());
            veriParam = GLAcctAgeNewUtils.getUnVerifyParam(paramAge, true);
            if (paramAge.isIncludeInit()) {
                veriParam.addAll(GLAcctAgeNewUtils.getUnVerifyParam(paramAge, true));
            }
            acMap.put("initParams", veriParam);
        }
        return acMap;
    }

    private void createTempTable_ByAcctBal_AcSub(AccountAgeParam paramAge) throws BOSException, EASBizException {
        String tempTableAcSub = null;
        StringBuffer createTable = new StringBuffer();
        createTable.append(" (--\u4e1a\u52a1\u65b9\u5411\uff08\u6302\u8d26\u3001\u6838\u9500\uff09                                   \r\n");
        createTable.append(" FDataType int DEFAULT 9 NOT NULL,                                   \r\n");
        createTable.append(" FCUSSENTID VARCHAR (44) NULL, fdc int,        \r\n");
        createTable.append(" FVchAstRcdID VARCHAR (44) NULL,                 \r\n");
        createTable.append(" FVoucherID VARCHAR (44) NULL,                 \r\n");
        createTable.append(" FPeriodNumber NVARCHAR(10),FVoucherType NVARCHAR(40),    \r\n");
        createTable.append(" FVoucherNumber VARCHAR(80),FDescription NVARCHAR(255),   \r\n");
        createTable.append(" --\u4e1a\u52a1\u65e5\u671f\u3001\u5230\u671f\u65e5\u3001\u8d26\u9f84\u3001\u533a\u95f4                             \r\n");
        createTable.append(" FBizDate DateTime,FEndDate DateTime,               \r\n");
        createTable.append(" FDays int ,FRange int , FRangeDesc VARCHAR(40), \r\n");
        createTable.append(" FOriginalAmt numeric(28, 10) ,           \r\n");
        createTable.append(" FExchgRate numeric(28, 10) ,              \r\n");
        createTable.append(" FExchgRatePRECISION numeric(28, 10) ,              \r\n");
        createTable.append(" FLocalAmt numeric(28, 10) DEFAULT 0 NOT NULL,              \r\n");
        createTable.append(paramAge.getSqlCreateHgTbl().length() > 0 ? paramAge.getSqlCreateHgTbl().substring(0, paramAge.getSqlCreateHgTbl().length() - 1) : "");
        createTable.append("\r\n )");
        tempTableAcSub = GLAcctAgeNewUtils.createTempTableByDDL(paramAge.getCtx(), "gl_act_ageSub", createTable);
        paramAge.setTempTableAcSum(tempTableAcSub);
    }

    private StringBuffer getSql_InsertAcTemp(AccountAgeParam paramAge, boolean isInclude3SumOverDue, boolean isUseHgOutSideReal) {
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert Into ").append(paramAge.getTempTableAcSum());
        sql.append("( ");
        sql.append(paramAge.getSqlSelecthgoutside());
        sql.append("\r\n ,FDataType,FCUSSENTID,fdc,FVchAstRcdID,FVoucherID,  \r\n");
        sql.append("FPeriodNumber,FVoucherType,FVoucherNumber,  \r\n");
        sql.append("FDescription,FBizDate,FEndDate,FOriginalAmt,FLocalAmt  \r\n");
        sql.append(")   \r\n");
        return sql;
    }

    private StringBuffer getSql_ByAcctBal_AcNotInit(AccountAgeParam paramAge) {
        StringBuffer sql = new StringBuffer();
        this.getSql_ByAcctBal_AcNotInit_Select(paramAge);
        GLAcctAgeNewUtils.getSql_ByAcctBal_AcNotInit_From(paramAge);
        GLAcctAgeNewUtils.getSql_ByAcctBal_AcNotInit_Where(paramAge);
        sql.append("select ").append(paramAge.getSqlSelecthg()).append(paramAge.getSqlSelectNotInit()).append(paramAge.getSqlFromTable()).append(paramAge.getSqlInnerJoin()).append(paramAge.getSqlWhereNotInitBalNotZero());
        return sql;
    }

    private void getSql_ByAcctBal_AcNotInit_Select(AccountAgeParam paramAge) {
        StringBuffer sqlSelect = paramAge.getSqlSelectNotInit();
        sqlSelect.append(this.getSelectorByBal(paramAge, true, false)).append("  \r\n");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("selector", this.getSelectorByBal(paramAge, true, true));
        paramAge.setParams(param);
    }

    private StringBuffer getSql_ByAcctBal_AcInit(AccountAgeParam paramAge) {
        StringBuffer sql = new StringBuffer();
        this.getSql_ByAcctBal_AcInit_Select(paramAge);
        GLAcctAgeNewUtils.getSql_ByAcctBal_AcInit_From(paramAge);
        GLAcctAgeNewUtils.getSql_ByAcctBal_AcInit_Where(paramAge);
        sql.append("select ").append(paramAge.getSqlSelecthg()).append(paramAge.getSqlSelectInit()).append(paramAge.getSqlFromInit()).append(paramAge.getSqlInnerJoin()).append(paramAge.getSqlWhereInitBalNotZero());
        return sql;
    }

    private void getSql_ByAcctBal_AcInit_Select(AccountAgeParam paramAge) {
        StringBuffer sqlSelect = paramAge.getSqlSelectInit();
        String selector = this.getSelectorByBal(paramAge, true, false);
        selector = selector.replace("voucher.fid", "null");
        selector = selector.replace("voucher.fnumber", "N''");
        selector = selector.replace("voucher.fperiodId", "null");
        selector = selector.replace("voucher.fvouchertypeid", "null");
        sqlSelect.append(selector).append("  \r\n");
    }

    private void returnBackAc4InTime(Connection con, AccountAgeParam paramAge) throws BOSException, EASBizException {
        String tempTableAcSub = paramAge.getTempTableAcSum();
        StringBuffer hisAgeTableSql = new StringBuffer();
        String amountField = null;
        amountField = "his.FOroginalAmount";
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean isDbTypeOracleDB2 = GLAcctAgeNewUtils.checkDbTypeIsOracleDB2(paramAge.getCtx());
        try {
            Calendar _cal = Calendar.getInstance();
            _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)paramAge.getHistoryDate()));
            Date _dayIndex = new Date(_cal.getTimeInMillis());
            Object _day1 = null;
            Date _day2 = new Date(_cal.getTime().getTime());
            hisAgeTableSql.append("update ").append(tempTableAcSub).append(" tmp \r\n");
            hisAgeTableSql.append("set (FOriginalAmt) = \r\n");
            hisAgeTableSql.append("(select FOriginalAmt + sumhis.sumoro from \r\n");
            hisAgeTableSql.append("(select his.FCussentIDID,isnull(sum( \r\n");
            hisAgeTableSql.append(amountField);
            hisAgeTableSql.append("),0) as sumoro \r\n");
            hisAgeTableSql.append("from t_gl_acctcussenthistory his  \r\n");
            hisAgeTableSql.append("inner join t_gl_voucher voucher on his.FVeriVchID=voucher.FID  \r\n");
            hisAgeTableSql.append("where 1=1  \r\n");
            hisAgeTableSql.append(" and his.fcompanyid = ?  \r\n");
            hisAgeTableSql.append(" and voucher.FBookedDate>? ");
            if (!paramAge.isIncludeUnPosted()) {
                hisAgeTableSql.append(" and voucher.FBizStatus=5 ");
            } else {
                hisAgeTableSql.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2 ");
            }
            hisAgeTableSql.append("\r\n group by his.fcussentidid  \r\n");
            hisAgeTableSql.append(") sumhis ");
            hisAgeTableSql.append("where sumhis.FCussentIDID=tmp.fcussentid  \r\n");
            hisAgeTableSql.append(")  \r\n");
            ps = con.prepareStatement(hisAgeTableSql.toString());
            int index = 1;
            ps.setString(index++, paramAge.getCompanyId());
            ps.setDate(index++, _dayIndex);
            ps.execute();
            ps.close();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)ps);
    }

    private void returnBackAc4NotInTime(Connection con, AccountAgeParam paramAge) throws BOSException, EASBizException {
        StringBuffer historySql = new StringBuffer();
        String tempTableAcSub = paramAge.getTempTableAcSum();
        String selectHgString = paramAge.getSqlSelecthg().substring(0, paramAge.getSqlSelecthg().length() - 1);
        String sql = "";
        String amountField = null;
        amountField = "khis.FOroginalAmount";
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean isDbTypeOracleDB2 = GLAcctAgeNewUtils.checkDbTypeIsOracleDB2(paramAge.getCtx());
        try {
            Calendar _cal = Calendar.getInstance();
            _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)paramAge.getHistoryDate()));
            Date _dayIndex = new Date(_cal.getTimeInMillis());
            _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)paramAge.getEndDate()));
            Date _day1 = new Date(_cal.getTime().getTime());
            Date _day2 = new Date(_cal.getTime().getTime());
            String sqlSelectSumOnePhase = "ISNULL(                                                                                                           \r\n       (select isnull( SUM (" + amountField + ") ,0) --*tmp.fdc                                                       \r\n               FROM t_gl_acctcussenthistory khis                                                                  \r\n              WHERE khis.fcussentidid = tmp.fcussentid                                                            \r\n                AND ( khis.fdc IN (0, 2) AND (khis.fvchdate <= ? or khis.fvchdate is null)                       \r\n";
            if (paramAge.getHgid() != null) {
                sqlSelectSumOnePhase = sqlSelectSumOnePhase + " and khis.fassgrpid ='" + paramAge.getHgid() + "'                             \r\n";
            }
            sqlSelectSumOnePhase = sqlSelectSumOnePhase + "                     AND EXISTS (SELECT 1 FROM t_gl_voucher voucher                          \r\n                             WHERE khis.fverivchid = voucher.fid AND voucher.fbookeddate > ? \r\n                             " + paramAge.getSqlWhereHistoryVeriVchBizstas() + ")            \r\n                    )                                                                                                           \r\n                    GROUP BY khis.fcussentidid)                                                                                    \r\n       ,0)                                                                                                                      \r\n+                                                                                                                               \r\nISNULL(                                                                                                                         \r\n    (SELECT isnull( SUM(" + amountField + "),0)  --*tmp.fdc                                                               \r\n                  FROM t_gl_acctcussenthistory khis                                                               \r\n                 WHERE khis.fcussentidid = tmp.fcussentid                                                         \r\n                   AND ( khis.fdc = 1 AND (khis.fvchdate <= ? or khis.fvchdate is null)                          \r\n";
            if (paramAge.getHgid() != null) {
                sqlSelectSumOnePhase = sqlSelectSumOnePhase + " and khis.fassgrpid ='" + paramAge.getHgid() + "'                             \r\n";
            }
            sqlSelectSumOnePhase = sqlSelectSumOnePhase + "                        AND EXISTS (SELECT 1 FROM t_gl_acctcussenthistory k2                                                    \r\n                                WHERE k2.fvoucherasstidid = khis.fcussentidid AND k2.fcussentidid = khis.fvoucherasstidid             \r\n                                  AND k2.fvchdate > ?)                                                  \r\n                       )                                                                                                        \r\n              GROUP BY khis.fcussentidid)                                                                                          \r\n     ,0)                                                                                                                        \r\n";
            ArrayList<Date> lstDates = new ArrayList<Date>();
            lstDates.add(_dayIndex);
            lstDates.add(_dayIndex);
            sql = "UPDATE " + tempTableAcSub + " tmp SET FOriginalAmt = FOriginalAmt +                      \r\n" + sqlSelectSumOnePhase;
            ps = con.prepareStatement(sql);
            this.setParams_getHistorySql_update(ps, lstDates, paramAge.getCompanyId());
            ps.execute();
            ps.close();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)ps);
    }

    private StringBuffer getHistorySql4Verified(AccountAgeParam paramAge) throws BOSException, EASBizException {
        StringBuffer historySql = new StringBuffer();
        GLAcctAgeNewUtils.getSql_ByBal_VerifiedSum_NotInit_From(paramAge);
        GLAcctAgeNewUtils.getSql_ByBal_VerifiedSum_Init_From(paramAge);
        GLAcctAgeNewUtils.getSql_ByBal_VerifiedSum_NotInit_Where(paramAge);
        GLAcctAgeNewUtils.getSql_ByBal_VerifiedSum_Init_Where(paramAge);
        String amountField = "khis.FOroginalAmount";
        String vchAstRcdField = "khis.fvoucherasstidid";
        String sum = "\r\n isnull(sum(" + amountField + "),0) SumVeri  \r\n";
        String sumstr = "\r\n sum(SumVeri) SumVeri  \r\n";
        historySql.append("select ").append("fvoucherasstidid,").append(sumstr).append(" from ( \r\n");
        historySql.append("select ").append(vchAstRcdField).append(",").append(sum).append(paramAge.getSqlFromVerifiedSum_NotInit()).append(" \r\n").append("  inner join ").append(paramAge.getTempTableSumVeri()).append("  veri on veri.fvchastrcdid = khis.fvoucherasstidid  \r\n").append(paramAge.getSqlInnerJoin()).append(" \r\n").append(paramAge.getSqlWhereVerifiedSum_NotInit());
        historySql.append(" group by ").append(vchAstRcdField).append(" \r\n");
        if (paramAge.isIncludeInit()) {
            historySql.append("\r\n UNION ALL \r\n");
            historySql.append("select ").append(vchAstRcdField).append(",").append(sum).append(paramAge.getSqlFromVerifiedSum_Init()).append(" \r\n").append("  inner join ").append(paramAge.getTempTableSumVeri()).append("  veri on veri.fvchastrcdid = khis.fvoucherasstidid  \r\n").append(paramAge.getSqlInnerJoin()).append(" \r\n").append(paramAge.getSqlWhereVerifiedSum_Init()).append(" \r\n");
            historySql.append(" group by ").append(vchAstRcdField);
        }
        historySql.append("\r\n )t  \r\n");
        historySql.append("group by fvoucherasstidid \r\n");
        return historySql;
    }

    private String createTempTable4SumVerify(AccountAgeParam paramAge) throws BOSException, EASBizException {
        String tempateTable = TableManagerFacadeFactory.getLocalInstance((Context)paramAge.getCtx()).getTableName("gl_temp");
        StringBuffer createTable = new StringBuffer();
        createTable.append("CREATE TABLE ").append(tempateTable);
        createTable.append(" (--\u4e1a\u52a1\u65b9\u5411\uff08\u6302\u8d26\u3001\u6838\u9500\uff09                                   \r\n");
        createTable.append(" FDataType int DEFAULT 9 NOT NULL,              \r\n");
        createTable.append(" FVchAstRcdID VARCHAR (44) NULL, fdc int,        \r\n");
        createTable.append(" FVoucherID VARCHAR (44) NULL,                 \r\n");
        createTable.append(" FPeriodNumber NVARCHAR(10),FVoucherType NVARCHAR(40),    \r\n");
        createTable.append(" FVoucherNumber VARCHAR(80),FDescription NVARCHAR(255),   \r\n");
        createTable.append(" --\u4e1a\u52a1\u65e5\u671f\u3001\u5230\u671f\u65e5\u3001\u8d26\u9f84\u3001\u533a\u95f4                             \r\n");
        createTable.append(" FBizDate DateTime,FEndDate DateTime,               \r\n");
        createTable.append(" FOriginalAmt numeric(28, 10) DEFAULT 0 NOT NULL,           \r\n");
        createTable.append((paramAge.getSqlCreateHgTbl().length() > 0 ? paramAge.getSqlCreateHgTbl().substring(0, paramAge.getSqlCreateHgTbl().length() - 1) : "") + ")");
        ITableManagerFacade tableManagerFacade = TableManagerFacadeFactory.getLocalInstance((Context)paramAge.getCtx());
        tableManagerFacade.createTable(createTable.toString());
        paramAge.setTempTableSumVeri(tempateTable);
        return tempateTable;
    }

    private void createTempTable4SumVerified(AccountAgeParam paramAge) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("(  \r\n");
        sql.append("FVchAstRcdID VARCHAR (44),                 \r\n");
        sql.append("SumVeri numeric(28,10) not null default 0  \r\n");
        sql.append(")");
        String tempTable = GLAcctAgeNewUtils.createTempTableByDDL(paramAge.getCtx(), "gl_act_age", sql);
        paramAge.setTempTableSumVerified(tempTable);
    }

    private void setParams_getHistorySql_update(PreparedStatement ps, List lstDates, String companyid) throws SQLException {
        int index = 1;
        Iterator it = null;
        it = lstDates.iterator();
        while (it.hasNext()) {
            ps.setDate(index++, (Date)it.next());
        }
        it = lstDates.iterator();
        while (it.hasNext()) {
            ps.setDate(index++, (Date)it.next());
        }
    }

    private StringBuffer getSql_ByBal_AcVeriSum(AccountAgeParam paramAge) {
        StringBuffer sql = new StringBuffer();
        StringBuffer select_veri = new StringBuffer();
        select_veri.append(this.getSelectorByBal(paramAge, false, false));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("selector", this.getSelectorByBal(paramAge, false, true));
        paramAge.setParams(param);
        GLAcctAgeNewUtils.getSql_ByBal_AcVeriSum_From_New(paramAge);
        GLAcctAgeNewUtils.getSql_ByBal_AcVeriSum_Where_New(paramAge);
        sql.append("select ").append(paramAge.getSqlSelecthg()).append(select_veri).append(paramAge.getSqlFromVeriSum()).append(paramAge.getSqlInnerJoin()).append(paramAge.getSqlWhereVeriSum());
        return sql;
    }

    private void insertIntoTempTable_ByBal_SumVeri(AccountAgeParam paramAge, Connection con, StringBuffer sqlSumVeri) throws SQLException {
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into ").append(paramAge.getTempTableSumVeri()).append("\r\n (").append(paramAge.getSqlSelecthgoutside()).append(",FvoucherID,FPeriodNumber,FVoucherType,FVoucherNumber  \r\n").append(",FDescription,FBizDate,FEndDate,FOriginalAmt,FVchAstRcdID,FDataType  \r\n").append(")");
        sql.append(sqlSumVeri);
        ps = con.prepareStatement(sql.toString());
        int index = 1;
        index = GLAcctAgeNewUtils.setupParams_ByBal_InsertSumVeri(paramAge, ps, index, false);
        ps.execute();
        ps.close();
    }

    private void insertIntoTempTable_ByBal_SumVerified(AccountAgeParam paramAge, Connection con, StringBuffer sqlSumVeri) throws SQLException {
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into ").append(paramAge.getTempTableSumVerified()).append("\r\n (FVchAstRcdID,SumVeri) \r\n");
        sql.append(sqlSumVeri);
        ps = con.prepareStatement(sql.toString());
        int index = 1;
        index = GLAcctAgeNewUtils.setupParams_ByBal_InsertSumVeri(paramAge, ps, index, false);
        Calendar cal = Calendar.getInstance();
        cal.setTime(paramAge.getHistoryDate());
        ps.setDate(index++, new Date(cal.getTimeInMillis()));
        if (paramAge.isIncludeInit()) {
            index = GLAcctAgeNewUtils.setupParams_ByBal_InsertSumVeri(paramAge, ps, index, true);
            cal.setTime(paramAge.getHistoryDate());
            ps.setDate(index++, new Date(cal.getTimeInMillis()));
        }
        ps.execute();
        ps.close();
    }

    private void updateTempTable_ByBal_SumVeriFromSumVerified(AccountAgeParam paramAge, Connection con) throws SQLException {
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlUpdate = new StringBuffer();
        StringBuffer sqlWhereUpdate = new StringBuffer();
        sqlWhereUpdate.append(" AND bal.FVchAstRcdID = tmp.FVchAstRcdID ");
        sqlUpdate.setLength(0);
        sqlUpdate.append("update ").append(paramAge.getTempTableSumVeri()).append(" tmp \r\n");
        sqlUpdate.append(" set (FOriginalAmt)    \r\n");
        sqlUpdate.append(" =                \r\n");
        sqlUpdate.append("(select tmp.FOriginalAmt - bal.SumVeri                \r\n");
        sqlUpdate.append(" from ").append(paramAge.getTempTableSumVerified()).append(" bal \r\n");
        sqlUpdate.append(" where 1=1               \r\n");
        sqlUpdate.append(sqlWhereUpdate).append(" )                \r\n");
        ps = con.prepareStatement(sqlUpdate.toString());
        ps.execute();
        ps.close();
    }

    private void updateTempTable_ByBal_AcSumFromBal_InsertLine(AccountAgeParam paramAge, Connection con) throws SQLException {
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlInsertFields = new StringBuffer();
        StringBuffer sqlSelectFields = new StringBuffer();
        StringBuffer sqlWhereUpdate = new StringBuffer();
        sqlInsertFields.append(",FCUSSENTID,fdc,FDataType,FDays,FVchAstRcdID,FVoucherID,  \r\n");
        sqlInsertFields.append("FPeriodNumber,FVoucherType,FVoucherNumber,  \r\n");
        sqlInsertFields.append("FDescription,FBizDate,FEndDate,FOriginalAmt  \r\n");
        sqlSelectFields.append(",null,-1,FDataType,0,FVchAstRcdID,FVoucherID,  \r\n");
        sqlSelectFields.append("FPeriodNumber,FVoucherType,FVoucherNumber,  \r\n");
        sqlSelectFields.append("FDescription,FBizDate,FEndDate,(-1)*FOriginalAmt  \r\n");
        sql.setLength(0);
        sql.append(" Insert Into ").append(paramAge.getTempTableAcSum());
        sql.append("( ");
        sql.append(paramAge.getSqlSelecthgoutside());
        sql.append(sqlInsertFields);
        sql.append(") \r\n");
        sql.append(" select ");
        sql.append(paramAge.getSqlSelecthgoutside());
        sql.append(sqlSelectFields);
        sql.append("\r\n from ").append(paramAge.getTempTableSumVeri());
        sql.append("\r\n where FOriginalAmt<>0");
        ps = con.prepareStatement(sql.toString());
        ps.execute();
        ps.close();
    }

    private void calculateLocalAmt4GeneralCy(Connection con, AccountAgeParam paramAge) throws SQLException {
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        int generalCyScale = paramAge.getGeneralCurrency().getPrecision();
        sql.append("Update ").append(paramAge.getTempTableAcSum());
        sql.append(" tmp set (FExchgRate,FExchgRatePRECISION,FLocalAmt) =");
        sql.append(" ( select isnull(tmpExch.FCONVERTRATEA,1),tmpExch.FPRECISION, round(FOriginalAmt* isnull(tmpExch.FCONVERTRATEA,1),").append(generalCyScale).append(")  \r\n");
        sql.append(" from " + paramAge.getTempTableExchRate() + " tmpExch where tmpExch.fid = tmp.fcurrid \r\n");
        sql.append(" )");
        ps = con.prepareStatement(sql.toString());
        ps.execute();
        ps.close();
        sql.setLength(0);
        sql.append("Update ").append(paramAge.getTempTableAcSum());
        sql.append(" tmp set FExchgRate=1,FLocalAmt = round(FOriginalAmt");
        sql.append(" ,").append(generalCyScale).append("),FExchgRatePRECISION =1  \r\n");
        sql.append(" where FExchgRate is null or FExchgRate = 0 ");
        ps = con.prepareStatement(sql.toString());
        ps.execute();
        ps.close();
    }

    private int calculateLocalAmt4Deviation(Connection con, AccountAgeParam paramAge) throws SQLException {
        int i;
        int iAdjust = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        int index = 1;
        StringBuffer sql = new StringBuffer();
        StringBuffer totalSum = new StringBuffer();
        int generalCyScale = paramAge.getGeneralCurrency().getPrecision();
        String tempTableAcSum = paramAge.getTempTableAcSum();
        if (!UUTN.isTempTable((String)tempTableAcSum) && !UUTN.isGlobalTempTable((String)tempTableAcSum)) {
            logger.error((Object)("illegal temptable name:" + tempTableAcSum));
            return iAdjust;
        }
        int daylen = paramAge.getDaylen();
        BigDecimal[] aryAmountAge = paramAge.getAryAmountAge();
        BigDecimal[] sum = null;
        BigDecimal sumunoverdue = GlUtils.zero;
        BigDecimal leftamount = GlUtils.zero;
        BigDecimal sumall = GlUtils.zero;
        BigDecimal sumoverdue = GlUtils.zero;
        BigDecimal sumallAdd = GlUtils.zero;
        BigDecimal delta = GlUtils.zero;
        String strFieldNameMaxAmount = "";
        String sumStr = "";
        String sumStrRound = "";
        sum = paramAge.isShowUmexpired() ? new BigDecimal[daylen + paramAge.getUndaylen() + 3] : new BigDecimal[daylen + 2];
        for (i = 0; i < sum.length; ++i) {
            sum[i] = GlUtils.zero;
        }
        sql.setLength(0);
        sql.append("select frange,flocalamt from  ").append(tempTableAcSum);
        sql.append(" where fdatatype = 9 ");
        sql.append(" order by frange");
        ps = con.prepareStatement(sql.toString());
        rs = ps.executeQuery();
        index = 0;
        while (rs.next()) {
            index = rs.getInt("frange");
            sum[index] = rs.getBigDecimal("flocalamt");
        }
        rs.close();
        ps.close();
        if (index == 0) {
            return iAdjust;
        }
        for (i = 0; i < sum.length; ++i) {
            if (sum[i].compareTo(aryAmountAge[i]) == 0) continue;
            iAdjust = -1;
            delta = aryAmountAge[i].subtract(sum[i]);
            if (delta.abs().compareTo(GlUtils.one) >= 0) continue;
            strFieldNameMaxAmount = "flocalamt";
            String updateFilterRow = this.findMaxRowInTempTable(con, paramAge, strFieldNameMaxAmount, i);
            if (updateFilterRow.length() > 0) {
                sql.setLength(0);
                sql.append("Update ").append(tempTableAcSum);
                sql.append(" set ");
                sql.append(strFieldNameMaxAmount);
                sql.append(" = ");
                sql.append(strFieldNameMaxAmount);
                sql.append(" + ? ");
                sql.append(" where FActId = ?");
                ps = con.prepareStatement(sql.toString());
                index = 1;
                ps.setBigDecimal(index++, delta);
                ps.setString(index++, updateFilterRow);
                ps.executeUpdate();
                ps.close();
            }
            sql.setLength(0);
            sql.append("Update ").append(tempTableAcSum);
            sql.append(" set ");
            sql.append(strFieldNameMaxAmount);
            sql.append(" = ");
            sql.append(strFieldNameMaxAmount);
            sql.append(" + ? ");
            sql.append(" where fdatatype = 9 and frange = ?      \r\n");
            ps = con.prepareStatement(sql.toString());
            index = 1;
            ps.setBigDecimal(index++, delta);
            ps.setInt(index++, i);
            ps.executeUpdate();
        }
        rs.close();
        ps.close();
        return iAdjust;
    }

    private String findMaxRowInTempTable(Connection con, AccountAgeParam paramAge, String filedName, int intRange) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        int index = 1;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlWhere = new StringBuffer();
        String tempTableAcSum = paramAge.getTempTableAcSum();
        String keyValue = "";
        sql.append(" select top 1 FActId,FLocalAmt from ").append(tempTableAcSum).append(" tmp   \r\n");
        sql.append(" where abs(tmp.").append(filedName).append(") =                               \r\n");
        sql.append(" (                                              \r\n");
        sql.append("  select max(abs(tmp2.").append(filedName).append("))                    \r\n");
        sql.append("  from ").append(tempTableAcSum).append(" tmp2          \r\n");
        sql.append("  where tmp2.fdatatype <> 9 and tmp2.frange = ?  \r\n");
        sql.append(" )                                               \r\n");
        sql.append(" and tmp.fdatatype <> 9 and tmp.frange = ?      \r\n");
        ps = con.prepareStatement(sql.toString());
        ps.setInt(index++, intRange);
        ps.setInt(index++, intRange);
        rs = ps.executeQuery();
        if (rs.next()) {
            keyValue = rs.getString("FActId");
        }
        rs.close();
        ps.close();
        return keyValue;
    }

    private void deleteBalZeroAcFromTempTable(Connection con, PreparedStatement ps, String tempTableAcSum) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from ").append(tempTableAcSum);
        sql.append(" where foriginalAmt = 0");
        ps = con.prepareStatement(sql.toString());
        ps.execute();
        ps.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertTotalSumLines(Connection con, AccountAgeParam paramAge) throws SQLException {
        int i;
        PreparedStatement ps = null;
        StringBuffer totalSum = new StringBuffer();
        boolean index = true;
        String strSumText = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"InnerTotal", (Locale)paramAge.getCtx().getLocale());
        String strTotalText = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"Total", (Locale)paramAge.getCtx().getLocale());
        String strNotOverText = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"NotOver", (Locale)paramAge.getCtx().getLocale());
        Calendar _cal = Calendar.getInstance();
        _cal.setTime(paramAge.getEndDate());
        StringBuffer strDate = new StringBuffer();
        boolean isDbTypeOracle = GLAcctAgeNewUtils.checkDbTypeIsOracle(paramAge.getCtx());
        if (isDbTypeOracle) {
            strDate.append("to_date('");
            strDate.append(_cal.get(1)).append("-");
            strDate.append(_cal.get(2) + 1).append("-");
            strDate.append(_cal.get(5)).append("'");
            strDate.append(",'yyyy-mm-dd')");
            totalSum.append("/*dialect*/ update ").append(paramAge.getTempTableAcSum());
            totalSum.append(" set FDays = to_number(SUBSTR(TO_CHAR(").append(strDate).append(" - ").append(paramAge.getStrDateType()).append("),1,10))  \r\n");
        } else {
            strDate.append("convert(DATETIME,'");
            strDate.append(_cal.get(1)).append("-");
            strDate.append(_cal.get(2) + 1).append("-");
            strDate.append(_cal.get(5)).append("'");
            strDate.append(")");
            totalSum.append(" update ").append(paramAge.getTempTableAcSum());
            System.out.println("====================================strDate" + strDate);
            totalSum.append("\r\n set FDays = ceiling(datediff(DAY, ").append(paramAge.getStrDateType()).append(",").append(strDate).append("))  \r\n");
            PreparedStatement ps1 = null;
            ResultSet rs1 = null;
            try {
                ps1 = con.prepareStatement(" select " + paramAge.getStrDateType() + " from " + paramAge.getTempTableAcSum());
                rs1 = ps1.executeQuery();
                while (rs1.next()) {
                    System.out.println("=======================================" + paramAge.getStrDateType() + " : " + rs1.getDate(paramAge.getStrDateType()));
                }
                SQLUtils.cleanup((ResultSet)rs1, (Statement)ps1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                SQLUtils.cleanup(rs1, ps1);
            }
        }
        ps = con.prepareStatement(totalSum.toString());
        ps.executeUpdate();
        ps.close();
        int[] days = paramAge.getDays();
        totalSum.setLength(0);
        totalSum.append(" update ").append(paramAge.getTempTableAcSum());
        totalSum.append(" set FRange =   \r\n");
        int ide = 0;
        if (paramAge.isShowUmexpired()) {
            int[] undays = paramAge.getUndays();
            totalSum.append(" case when FDays >= ").append(undays[0]).append(" and FDays <= 0 then 0  \r\n");
            for (i = 0; i < paramAge.getUndaylen(); ++i) {
                if (i < paramAge.getUndaylen() - 1) {
                    totalSum.append("  when FDays >= ").append(undays[i + 1]).append(" and FDays < ").append(undays[i]).append(" then ").append(i + 1).append("\r\n");
                    continue;
                }
                totalSum.append("  when FDays <  ").append(undays[i]).append(" then ").append(i + 1).append("  \r\n");
            }
            ide = paramAge.getUndaylen();
        } else {
            totalSum.append(" case when FDays <= 0 then 0  \r\n");
        }
        totalSum.append(" \t   when FDays > 0");
        totalSum.append(" and FDays <= ").append(days[0]);
        totalSum.append(" then ").append(ide + 1).append("  \r\n");
        for (int i2 = 0; i2 < paramAge.getDaylen(); ++i2) {
            if (i2 < paramAge.getDaylen() - 1) {
                totalSum.append(" \t   when FDays > ").append(days[i2]);
                totalSum.append(" and FDays <= ").append(days[i2 + 1]);
                totalSum.append(" then ").append(ide + i2 + 2).append("  \r\n");
                continue;
            }
            totalSum.append("      else ").append(ide + i2 + 2).append("  \r\n");
        }
        totalSum.append(" \t  end,  \r\n");
        totalSum.append(" FRangeDesc =   \r\n");
        if (paramAge.isShowUmexpired()) {
            int[] undays = paramAge.getUndays();
            totalSum.append(" case when FDays >= ").append(undays[0]).append(" and FDays <= 0 then N'").append("-1").append("- ").append(undays[0]).append("'\r\n");
            for (i = 0; i < paramAge.getUndaylen(); ++i) {
                if (i < paramAge.getUndaylen() - 1) {
                    totalSum.append("  when FDays >= ").append(undays[i + 1]).append(" and FDays < ").append(undays[i]).append(" then N'").append(undays[i] - 1).append("- ").append(undays[i + 1]).append("'\r\n");
                    continue;
                }
                totalSum.append("  when FDays < ").append(undays[i]).append(" then N'").append(undays[i] - 1).append("- ").append("' \r\n");
            }
            ide = paramAge.getUndaylen();
        } else {
            totalSum.append(" case when FDays<=0 then N'").append(strNotOverText).append("'  \r\n");
        }
        totalSum.append(" \t   when FDays>0");
        totalSum.append(" and FDays<=").append(days[0]);
        totalSum.append(" then N'1").append("- ").append(days[0]).append("'  \r\n");
        for (int i3 = 0; i3 < paramAge.getDaylen(); ++i3) {
            if (i3 < paramAge.getDaylen() - 1) {
                totalSum.append(" \t   when FDays>").append(days[i3]);
                totalSum.append(" and FDays<=").append(days[i3 + 1]);
                totalSum.append(" then N'").append(days[i3] + 1).append("- ").append(days[i3 + 1]).append("'  \r\n");
                continue;
            }
            totalSum.append("      else N'").append(days[i3] + 1).append("- '  \r\n");
        }
        totalSum.append(" \t  end  \r\n");
        ps = con.prepareStatement(totalSum.toString());
        ps.executeUpdate();
        ps.close();
        totalSum.setLength(0);
        totalSum.append(" update ").append(paramAge.getTempTableAcSum());
        totalSum.append(" set FDataType = 1  \r\n");
        totalSum.append(" where FDataType = 2  \r\n");
        ps = con.prepareStatement(totalSum.toString());
        ps.executeUpdate();
        ps.close();
        if (!paramAge.isGeneralCy()) {
            totalSum.setLength(0);
            totalSum.append(" --\u6309\u5e01\u522b\u3001\u533a\u95f4\u5c0f\u8ba1                                            \r\n");
            totalSum.append(" Insert Into ").append(paramAge.getTempTableAcSum());
            totalSum.append(" (                                    \r\n");
            totalSum.append("   fdatatype,fcurrid, fcurrname,               \r\n");
            totalSum.append("   FRange,FDescription,                                   \r\n");
            totalSum.append("   FOriginalAmt,FLocalAmt)                                     \r\n");
            totalSum.append(" select   \r\n");
            totalSum.append(" 9 fdatatype,fcurrid, fcurrname,FRange,FRangeDesc||'").append(strSumText).append("',               \r\n");
            totalSum.append(" sum(FOriginalAmt) FOriginalAmt,sum(FLocalAmt) FLocalAmt       \r\n");
            totalSum.append(" from ").append(paramAge.getTempTableAcSum()).append("         \r\n");
            totalSum.append(" group by fcurrid, fcurrname,FRange,FRangeDesc                            \r\n");
            ps = con.prepareStatement(totalSum.toString());
            ps.execute();
            ps.close();
            totalSum.setLength(0);
            totalSum.append(" --\u6309\u5e01\u522b\u5408\u8ba1                                            \r\n");
            totalSum.append(" Insert Into ").append(paramAge.getTempTableAcSum());
            totalSum.append(" (                                    \r\n");
            totalSum.append("   fdatatype,fcurrid, fcurrname,               \r\n");
            totalSum.append("   FRange,FDescription,                                   \r\n");
            totalSum.append("   FOriginalAmt,FLocalAmt)                                     \r\n");
            totalSum.append(" select   \r\n");
            totalSum.append(" 99 fdatatype,fcurrid, fcurrname,99 FRange,N'").append(strTotalText).append("',               \r\n");
            totalSum.append(" sum(FOriginalAmt) FOriginalAmt,sum(FLocalAmt) FLocalAmt       \r\n");
            totalSum.append(" from ").append(paramAge.getTempTableAcSum()).append("         \r\n");
            totalSum.append(" where fdatatype = 9 ");
            totalSum.append(" group by fcurrid, fcurrname                             \r\n");
            ps = con.prepareStatement(totalSum.toString());
            ps.execute();
            ps.close();
        } else {
            totalSum.setLength(0);
            totalSum.append(" --\u6309\u533a\u95f4\u5c0f\u8ba1                                            \r\n");
            totalSum.append(" Insert Into ").append(paramAge.getTempTableAcSum());
            totalSum.append(" (                                    \r\n");
            totalSum.append("   fdatatype,               \r\n");
            totalSum.append("   fcurrid, fcurrname,               \r\n");
            totalSum.append("   FRange,FDescription,                                   \r\n");
            totalSum.append("   FLocalAmt)                                     \r\n");
            totalSum.append(" select   \r\n");
            totalSum.append(" 9 fdatatype,                \r\n");
            totalSum.append("'").append(paramAge.getMaxChar()).append("' fcurrid,");
            totalSum.append("N'").append(paramAge.getCurrency().getName()).append("' fcurrname,  \r\n");
            totalSum.append(" FRange,FRangeDesc||N'").append(strSumText).append("',            \r\n");
            totalSum.append(" sum(FLocalAmt) FLocalAmt       \r\n");
            totalSum.append(" from ").append(paramAge.getTempTableAcSum()).append("         \r\n");
            totalSum.append(" group by FRange,FRangeDesc                            \r\n");
            ps = con.prepareStatement(totalSum.toString());
            ps.execute();
            ps.close();
        }
    }

    private void insertTotalSumLines4GeneralCy(Connection con, AccountAgeParam paramAge) throws SQLException {
        String strTotalText = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"Total", (Locale)paramAge.getCtx().getLocale());
        PreparedStatement ps = null;
        StringBuffer totalSum = new StringBuffer();
        boolean index = true;
        totalSum.setLength(0);
        totalSum.append(" --\u5408\u8ba1\uff0c\u53ea\u6709\u4e00\u4e2a\u7efc\u5408\u5e01\u522b                                            \r\n");
        totalSum.append(" Insert Into ").append(paramAge.getTempTableAcSum());
        totalSum.append(" (                                    \r\n");
        totalSum.append("   fdatatype,               \r\n");
        totalSum.append("   fcurrid, fcurrname,               \r\n");
        totalSum.append("   FRange,FDescription,                                   \r\n");
        totalSum.append("   FLocalAmt)                                     \r\n");
        totalSum.append(" select   \r\n");
        totalSum.append(" 99 fdatatype,               \r\n");
        totalSum.append("'").append(paramAge.getMaxChar()).append("' fcurrid,");
        totalSum.append("N'").append(paramAge.getCurrency().getName()).append("' fcurrname,  \r\n");
        totalSum.append(" 99 FRange,N'").append(strTotalText).append("',                        \r\n");
        totalSum.append(" isnull(sum(FLocalAmt),0) FLocalAmt       \r\n");
        totalSum.append(" from ").append(paramAge.getTempTableAcSum()).append("         \r\n");
        totalSum.append(" where fdatatype = 9 ");
        ps = con.prepareStatement(totalSum.toString());
        ps.execute();
        ps.close();
    }

    private RptTableHeader getRptTableHeader(AccountAgeParam paramAge) {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        ArrayList<String> fields = new ArrayList<String>();
        String dateFormat = "%{yyyy-MM-dd}t";
        col = new RptTableColumn("FPeriodNumber");
        col.setWidth(70);
        col.setHided(false);
        header.addColumn(col);
        fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FPeriodNumber", (Locale)paramAge.getCtx().getLocale()));
        col = new RptTableColumn("FBizDate");
        col.setWidth(80);
        col.setHided(false);
        col.setFormatPattern(dateFormat);
        header.addColumn(col);
        fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FBizDate", (Locale)paramAge.getCtx().getLocale()));
        col = new RptTableColumn("FVoucherType");
        col.setWidth(70);
        col.setHided(false);
        header.addColumn(col);
        fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FVoucherType", (Locale)paramAge.getCtx().getLocale()));
        col = new RptTableColumn("FVoucherNumber");
        col.setWidth(150);
        col.setHided(false);
        header.addColumn(col);
        fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FVoucherNumber", (Locale)paramAge.getCtx().getLocale()));
        col = new RptTableColumn("FDescription");
        col.setWidth(100);
        col.setHided(false);
        header.addColumn(col);
        fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FDescription", (Locale)paramAge.getCtx().getLocale()));
        if (!paramAge.isBizCode()) {
            for (int i = 0; i < paramAge.getAlAstFields().size(); ++i) {
                col = new RptTableColumn("T" + i + "fnumber");
                col.setWidth(-1);
                col.setHided(true);
                header.addColumn(col);
                fields.add("T" + i + "fnumber");
                col = new RptTableColumn("T" + i + "fname");
                col.setWidth(150);
                col.setHided(false);
                header.addColumn(col);
                fields.add((String)paramAge.getAlAstAlias().get(i));
            }
        } else if (paramAge.getHmItems().size() > 0) {
            col = new RptTableColumn("T0fnumber");
            col.setWidth(-1);
            col.setHided(true);
            header.addColumn(col);
            fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"AnalyzeCode", (Locale)paramAge.getCtx().getLocale()));
            col = new RptTableColumn("T0fname");
            col.setWidth(100);
            col.setHided(false);
            header.addColumn(col);
            fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"AnalyzeName", (Locale)paramAge.getCtx().getLocale()));
        }
        col = new RptTableColumn("FDays");
        col.setWidth(70);
        col.setHided(false);
        col.setAligment(2);
        col.setFormatPattern("%R{#}d");
        header.addColumn(col);
        fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FDays", (Locale)paramAge.getCtx().getLocale()));
        col = new RptTableColumn("FRange");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FRange", (Locale)paramAge.getCtx().getLocale()));
        col = new RptTableColumn("FEndDate");
        col.setWidth(80);
        col.setHided(false);
        col.setFormatPattern(dateFormat);
        header.addColumn(col);
        fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FEndDate", (Locale)paramAge.getCtx().getLocale()));
        col = new RptTableColumn("FCurrName");
        col.setWidth(100);
        col.setHided(false);
        header.addColumn(col);
        fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FCurrName", (Locale)paramAge.getCtx().getLocale()));
        col = new RptTableColumn("FOriginalAmt");
        col.setWidth(100);
        col.setHided(false);
        col.setAligment(2);
        int precision = 2;
        if (!paramAge.isGeneralCy() && !paramAge.isAllCurr()) {
            precision = paramAge.getCurrency().getPrecision();
        }
        col.setFormatPattern(RptClientUtil.getDecimalFormat(precision));
        header.addColumn(col);
        fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FOriginalAmt", (Locale)paramAge.getCtx().getLocale()));
        if (paramAge.isGeneralCy()) {
            col = new RptTableColumn("FExchgRate");
            col.setWidth(100);
            col.setHided(false);
            col.setAligment(2);
            header.addColumn(col);
            fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FExchgRate", (Locale)paramAge.getCtx().getLocale()));
            col = new RptTableColumn("FLocalAmt");
            col.setWidth(100);
            col.setHided(false);
            col.setAligment(2);
            precision = paramAge.getCurrency().getPrecision();
            col.setFormatPattern(RptClientUtil.getDecimalFormat(precision));
            header.addColumn(col);
            if (paramAge.getLocalOrRpt() == 1) {
                fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FLocalAmt", (Locale)paramAge.getCtx().getLocale()));
            } else {
                fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FRptAmt", (Locale)paramAge.getCtx().getLocale()));
            }
        }
        col = new RptTableColumn("FCurrID");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FCurrID", (Locale)paramAge.getCtx().getLocale()));
        col = new RptTableColumn("FVoucherID");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FVoucherID", (Locale)paramAge.getCtx().getLocale()));
        col = new RptTableColumn("FDataType");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FDataType", (Locale)paramAge.getCtx().getLocale()));
        col = new RptTableColumn("FBizNumber");
        col.setWidth(100);
        col.setHided(false);
        header.addColumn(col);
        fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FBizNumber", (Locale)paramAge.getCtx().getLocale()));
        if (paramAge.isGeneralCy()) {
            col = new RptTableColumn("FExchgRatePRECISION");
            col.setWidth(100);
            col.setHided(true);
            col.setAligment(2);
            header.addColumn(col);
            fields.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FExchgRate", (Locale)paramAge.getCtx().getLocale()));
        }
        int itemCount = fields.size();
        Object[][] hh = new Object[1][itemCount];
        for (int i = 0; i < itemCount; ++i) {
            hh[0][i] = fields.get(i);
        }
        header.setLabels(hh);
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTempTable_ByBal_AcSumFromSumVeri(AccountAgeParam paramAge, Connection con) throws SQLException, BOSException {
        Object rsAc = null;
        Statement psAc = null;
        StringBuffer sql = new StringBuffer();
        String sqlIndexField = "FCUSSENTID";
        try {
            sql.setLength(0);
            sql.append("create index C").append(paramAge.getTempTableAcSum()).append(" on ").append(paramAge.getTempTableAcSum()).append("(").append(sqlIndexField).append(") ");
            psAc = con.prepareStatement(sql.toString());
            psAc.execute();
            psAc.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            psAc.close();
        }
        List<HashMap> typeList = this.isShowVerifyAge(paramAge, con);
        int type = 0;
        String fcurrID = null;
        String fhgID = null;
        for (Map map : typeList) {
            type = (Integer)map.get("type");
            fcurrID = (String)map.get("fCurrID");
            fhgID = (String)map.get("FHgID");
            this.updateTempTable_ByBal_AcSimulVeri(paramAge, con, paramAge.getTempTableAcSum(), 1, fcurrID, fhgID);
            if (type == 1) {
                this.updateTempTable_ByBal_AcSimulVeri(paramAge, con, paramAge.getTempTableSumVeri(), 2, fcurrID, fhgID);
            } else {
                this.updateTempTable_ByBal_VeriSimulVeri(paramAge, con, paramAge.getTempTableSumVeri(), fcurrID, fhgID);
            }
            if (type == 0) {
                this.simulVeri_showVerifyAge_AcZero(paramAge, con, fcurrID, fhgID);
                continue;
            }
            if (type == 1) {
                BigDecimal leftAmount = (BigDecimal)map.get("leftAmount");
                this.simulVeri_showVerifyAge(paramAge, con, leftAmount, fcurrID, fhgID);
                continue;
            }
            if (type != 2) continue;
            this.simulVeri_showCussentAge(paramAge, con, fcurrID, fhgID);
        }
    }

    private int updateTempTable_ByBal_AcVeriSub(int iCountPsUpdate, PreparedStatement psUpdate, String billid, BigDecimal amount) throws SQLException {
        int index = 1;
        psUpdate.setBigDecimal(index++, amount);
        psUpdate.setString(index++, billid);
        psUpdate.addBatch();
        if (++iCountPsUpdate >= 2000) {
            psUpdate.executeBatch();
            psUpdate.clearBatch();
            iCountPsUpdate = 0;
        }
        return iCountPsUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTempTable_ByBal_AcSimulVeri(AccountAgeParam paramAge, Connection con, String tempTableName, int isAcOrVeri, String fcurrID, String fhgID) throws BOSException {
        PreparedStatement psAc = null;
        Statement psUpdateAc = null;
        ResultSet rsAc = null;
        StringBuffer acSumSql = GLAcctAgeNewUtils.getPhaseSql(paramAge, paramAge.getStrDateType()).append(" from ").append(tempTableName).append(" temp where foriginalAmt <>0.0 ").append(" and fcurrID = '").append(fcurrID).append("' and hgID = '").append(fhgID).append("'");
        try {
            int index = 1;
            psAc = con.prepareStatement(acSumSql.toString());
            ArrayList allPhaseDates = paramAge.getAlDates();
            for (Date date : allPhaseDates) {
                psAc.setDate(index++, date);
            }
            rsAc = psAc.executeQuery();
            ArrayList allPhaseDates1 = GLAcctAgeNewUtils.getAllPhaseDates(paramAge);
            BigDecimal sum = null;
            String more = null;
            String less = null;
            while (rsAc.next()) {
                int j;
                Date startDate = null;
                Date endDate = null;
                if (paramAge.isShowUmexpired()) {
                    for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                        startDate = (Date)allPhaseDates1.get(j * 2);
                        endDate = (Date)allPhaseDates1.get(j * 2 + 1);
                        BigDecimal bigDecimal = sum = rsAc.getBigDecimal("sum" + j) == null ? GlUtils.zero : rsAc.getBigDecimal("sum" + j);
                        if (j == 0) {
                            more = ">=";
                            less = "<=";
                        } else {
                            more = ">";
                            less = "<=";
                        }
                        this.dealSimulVeri(paramAge, con, sum, isAcOrVeri, tempTableName, more, less, startDate, endDate, fcurrID, fhgID);
                    }
                } else {
                    java.util.Date tempStartDate = paramAge.getEndDate();
                    startDate = new Date(tempStartDate.getTime());
                    Calendar _cal = Calendar.getInstance();
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)tempStartDate));
                    _cal.add(1, 100);
                    endDate = new Date(_cal.getTime().getTime());
                    more = ">=";
                    less = "<=";
                    sum = rsAc.getBigDecimal("sumUnOverDue") == null ? GlUtils.zero : rsAc.getBigDecimal("sumUnOverDue");
                    this.dealSimulVeri(paramAge, con, sum, isAcOrVeri, tempTableName, more, less, startDate, endDate, fcurrID, fhgID);
                }
                index = 0;
                for (int i = 0; i <= paramAge.getDaylen(); ++i) {
                    index = i + j;
                    startDate = (Date)allPhaseDates1.get(index * 2);
                    endDate = (Date)allPhaseDates1.get(index * 2 + 1);
                    more = ">=";
                    less = "<";
                    sum = rsAc.getBigDecimal("sum" + index) == null ? GlUtils.zero : rsAc.getBigDecimal("sum" + index);
                    this.dealSimulVeri(paramAge, con, sum, isAcOrVeri, tempTableName, more, less, startDate, endDate, fcurrID, fhgID);
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rsAc, psAc);
                SQLUtils.cleanup(psUpdateAc);
                throw throwable;
            }
            SQLUtils.cleanup(rsAc, (Statement)psAc);
            SQLUtils.cleanup(psUpdateAc);
        }
        SQLUtils.cleanup((ResultSet)rsAc, (Statement)psAc);
        SQLUtils.cleanup(psUpdateAc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTempTable_ByBal_VeriSimulVeri(AccountAgeParam paramAge, Connection con, String tempTableName, String fcurrID, String fhgID) throws BOSException {
        ResultSet rsVeri;
        PreparedStatement psVeri;
        block4: {
            StringBuffer veriSumSql = new StringBuffer(" select sum(foriginalamt) as sum from ").append(paramAge.getTempTableSumVeri()).append(" temp where foriginalamt<>0.0 ").append(" and fcurrID = '").append(fcurrID).append("' and hgID = '").append(fhgID).append("' ");
            psVeri = null;
            Object psUpdateVeri = null;
            rsVeri = null;
            try {
                psVeri = con.prepareStatement(veriSumSql.toString());
                rsVeri = psVeri.executeQuery();
                if (!rsVeri.next()) break block4;
                BigDecimal sum = rsVeri.getBigDecimal("sum") == null ? GlUtils.zero : rsVeri.getBigDecimal("sum");
                this.dealSimulVeri(paramAge, con, sum, 2, tempTableName, null, null, null, null, fcurrID, fhgID);
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rsVeri, (Statement)psVeri);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rsVeri, (Statement)psVeri);
            }
        }
        SQLUtils.cleanup((ResultSet)rsVeri, (Statement)psVeri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dealSimulVeri(AccountAgeParam paramAge, Connection con, BigDecimal sum, int isAcOrVeri, String tempTableName, String more, String less, Date startDate, Date endDate, String fcurrID, String fhgID) throws BOSException {
        BigDecimal Veriedsum;
        ResultSet sumRs;
        ResultSet detailRs;
        PreparedStatement sumPs;
        PreparedStatement detailPs;
        block24: {
            block25: {
                int i;
                if (!UUTN.isTempTable((String)tempTableName) && !UUTN.isGlobalTempTable((String)tempTableName)) {
                    logger.error((Object)("illegal temptable name:" + tempTableName));
                    throw new BOSException("illegal temptable name:" + tempTableName);
                }
                detailPs = null;
                sumPs = null;
                detailRs = null;
                sumRs = null;
                String billID = null;
                if (sum.compareTo(GlUtils.zero) == 0) {
                    PreparedStatement updatePs = null;
                    try {
                        ArrayList<String> paramList = new ArrayList<String>();
                        StringBuffer updateSql = new StringBuffer();
                        updateSql.append(" update ").append(tempTableName).append(" set FOriginalAmt = 0.0 where 1=1 and  foriginalAmt<>0.0").append(" and fcurrID = ? ").append(" and hgID = ? ");
                        paramList.add(fcurrID);
                        paramList.add(fhgID);
                        if (startDate != null) {
                            updateSql.append(" and ").append(paramAge.getStrDateType()).append(more).append("to_date(?)");
                            paramList.add(startDate.toString());
                        }
                        if (endDate != null) {
                            updateSql.append(" and ").append(paramAge.getStrDateType()).append(less).append("to_date(?) ");
                            paramList.add(endDate.toString());
                        }
                        updatePs = con.prepareStatement(updateSql.toString());
                        for (int i2 = 0; i2 < paramList.size(); ++i2) {
                            updatePs.setString(i2 + 1, (String)paramList.get(i2));
                        }
                        updatePs.execute();
                        SQLUtils.cleanup((Statement)updatePs);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    finally {
                        SQLUtils.cleanup(updatePs);
                    }
                    return;
                }
                billID = isAcOrVeri == 1 ? "FCUSSENTID" : "FVchAstRcdID";
                ArrayList<String> sumSideSqlParamList = new ArrayList<String>();
                StringBuffer sumSideSql = new StringBuffer();
                sumSideSql.append("select sum(FOriginalAmt) from ");
                sumSideSql.append(tempTableName);
                sumSideSql.append(" where 1=1 ").append(" and fcurrID = ? ").append(" and hgID = ? ");
                sumSideSqlParamList.add(fcurrID);
                sumSideSqlParamList.add(fhgID);
                if (startDate != null) {
                    sumSideSql.append(" and ").append(paramAge.getStrDateType()).append(more).append("to_date(?)");
                    sumSideSqlParamList.add(startDate.toString());
                }
                if (endDate != null) {
                    sumSideSql.append(" and ").append(paramAge.getStrDateType()).append(less).append("to_date(?) ");
                    sumSideSqlParamList.add(endDate.toString());
                }
                ArrayList<String> detailSideSqlParamList = new ArrayList<String>();
                StringBuffer detailSideSql = new StringBuffer();
                detailSideSql.append("select ").append(billID).append(" FBillID,FOriginalAmt FROM ");
                detailSideSql.append(tempTableName);
                detailSideSql.append(" where 1=1 ").append(" and fcurrID = ? ").append(" and hgID = ? ");
                detailSideSqlParamList.add(fcurrID);
                detailSideSqlParamList.add(fhgID);
                if (startDate != null) {
                    detailSideSql.append(" and ").append(paramAge.getStrDateType()).append(more).append("to_date(?)");
                    detailSideSqlParamList.add(startDate.toString());
                }
                if (endDate != null) {
                    detailSideSql.append(" and ").append(paramAge.getStrDateType()).append(less).append("to_date(?) ");
                    detailSideSqlParamList.add(endDate.toString());
                }
                if (sum.compareTo(GlUtils.zero) > 0) {
                    detailSideSql.append(" and foriginalAmt>0.0");
                    sumSideSql.append("  and foriginalAmt<0.0 ");
                } else {
                    detailSideSql.append(" and foriginalAmt<0.0");
                    sumSideSql.append("  and foriginalAmt>0.0 ");
                }
                detailSideSql.append(" order by ").append(paramAge.getStrDateType());
                Veriedsum = null;
                detailPs = con.prepareStatement(detailSideSql.toString());
                for (i = 0; i < detailSideSqlParamList.size(); ++i) {
                    detailPs.setString(i + 1, (String)detailSideSqlParamList.get(i));
                }
                detailRs = detailPs.executeQuery();
                sumPs = con.prepareStatement(sumSideSql.toString());
                for (i = 0; i < sumSideSqlParamList.size(); ++i) {
                    sumPs.setString(i + 1, (String)sumSideSqlParamList.get(i));
                }
                sumRs = sumPs.executeQuery();
                if (!sumRs.next()) break block24;
                if (sumRs.getBigDecimal(1) == null) break block25;
                Veriedsum = sumRs.getBigDecimal(1);
                break block24;
            }
            SQLUtils.cleanup((Statement)detailPs);
            SQLUtils.cleanup((Statement)sumPs);
            SQLUtils.cleanup((ResultSet)detailRs);
            SQLUtils.cleanup((ResultSet)sumRs);
            return;
        }
        try {
            this.simulVeri(paramAge, con, detailRs, Veriedsum, isAcOrVeri, tempTableName, more, less, startDate, endDate, fcurrID, fhgID);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(detailPs);
                SQLUtils.cleanup(sumPs);
                SQLUtils.cleanup(detailRs);
                SQLUtils.cleanup(sumRs);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)detailPs);
            SQLUtils.cleanup(sumPs);
            SQLUtils.cleanup((ResultSet)detailRs);
            SQLUtils.cleanup(sumRs);
        }
        SQLUtils.cleanup((Statement)detailPs);
        SQLUtils.cleanup((Statement)sumPs);
        SQLUtils.cleanup((ResultSet)detailRs);
        SQLUtils.cleanup((ResultSet)sumRs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulVeri(AccountAgeParam paramAge, Connection con, ResultSet veriRs, BigDecimal Veriedsum, int isAcOrVeri, String tempTableName, String more, String less, Date startDate, Date endDate, String fcurrID, String fhgID) throws BOSException {
        PreparedStatement psUpdateSum;
        PreparedStatement psUpdateDetail;
        block13: {
            int count = 0;
            String billID = null;
            BigDecimal billAmount = null;
            String billIdField = null;
            psUpdateDetail = null;
            psUpdateSum = null;
            billIdField = isAcOrVeri == 1 ? "FCUSSENTID" : "FVchAstRcdID";
            int positiveOrNagetive_old = Veriedsum.signum();
            int positiveOrNagetive_new = 0;
            if (!UUTN.isTempTable((String)tempTableName) && !UUTN.isGlobalTempTable((String)tempTableName)) {
                logger.error((Object)("illegal temptable name:" + tempTableName));
                throw new BOSException("illegal temptable name:" + tempTableName);
            }
            StringBuffer detailSideSql = new StringBuffer();
            detailSideSql.append(" update ").append(tempTableName).append("  set foriginalAmt = ? where ").append(billIdField).append(" = ?").append(" and fcurrID = ? ").append(" and hgID = ? ");
            ArrayList<String> paramList = new ArrayList<String>();
            StringBuffer sumSideSql = new StringBuffer();
            sumSideSql.append(" update ").append(tempTableName).append("  set foriginalAmt = 0.0 where 1=1 ").append(" and fcurrID = ? ").append(" and hgID = ? ");
            paramList.add(fcurrID);
            paramList.add(fhgID);
            if (positiveOrNagetive_old > 0) {
                sumSideSql.append(" and foriginalAmt>0.0 ");
            } else {
                sumSideSql.append(" and foriginalAmt<0.0 ");
            }
            if (startDate != null) {
                sumSideSql.append(" and ").append(paramAge.getStrDateType()).append(more).append("to_date(?)");
                paramList.add(startDate.toString());
            }
            if (endDate != null) {
                sumSideSql.append(" and ").append(paramAge.getStrDateType()).append(less).append("to_date(?) ");
                paramList.add(endDate.toString());
            }
            try {
                psUpdateDetail = con.prepareStatement(detailSideSql.toString());
                psUpdateSum = con.prepareStatement(sumSideSql.toString());
                for (int i = 0; i < paramList.size(); ++i) {
                    psUpdateSum.setString(i + 1, (String)paramList.get(i));
                }
                boolean isOver = false;
                BigDecimal amountUpdate = null;
                while (veriRs.next()) {
                    billID = veriRs.getString("FBillID");
                    billAmount = veriRs.getBigDecimal("FOriginalAmt");
                    Veriedsum = billAmount.add(Veriedsum);
                    positiveOrNagetive_new = Veriedsum.signum();
                    if (positiveOrNagetive_new != positiveOrNagetive_old) {
                        amountUpdate = Veriedsum;
                        isOver = true;
                    } else {
                        amountUpdate = GlUtils.zero;
                    }
                    psUpdateDetail.setBigDecimal(1, amountUpdate);
                    psUpdateDetail.setString(2, billID);
                    psUpdateDetail.setString(3, fcurrID);
                    psUpdateDetail.setString(4, fhgID);
                    psUpdateDetail.addBatch();
                    ++count;
                    if (!isOver) continue;
                }
                if (count <= 0) break block13;
                psUpdateDetail.executeBatch();
                psUpdateDetail.clearBatch();
                psUpdateSum.execute();
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(psUpdateDetail);
                    SQLUtils.cleanup(psUpdateSum);
                    throw throwable;
                }
                SQLUtils.cleanup((Statement)psUpdateDetail);
                SQLUtils.cleanup((Statement)psUpdateSum);
            }
        }
        SQLUtils.cleanup((Statement)psUpdateDetail);
        SQLUtils.cleanup((Statement)psUpdateSum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HashMap> isShowVerifyAge(AccountAgeParam paramAge, Connection con) {
        ArrayList<HashMap> list;
        block29: {
            PreparedStatement psAcSum = null;
            PreparedStatement psVeriSum = null;
            ResultSet rsAcSum = null;
            ResultSet rsVeriSum = null;
            StringBuffer countAcSql = new StringBuffer();
            StringBuffer countVeriSql = new StringBuffer();
            int acCount = 0;
            int veriCount = 0;
            list = new ArrayList<HashMap>();
            try {
                countAcSql.append("select count(*) from (").append(" select distinct FCURRID,HGID from ").append(paramAge.getTempTableAcSum()).append(" GROUP BY FCURRID,HGID ) temp");
                psAcSum = con.prepareStatement(countAcSql.toString());
                rsAcSum = psAcSum.executeQuery();
                if (rsAcSum.next()) {
                    acCount = rsAcSum.getInt(1);
                }
                SQLUtils.cleanup((ResultSet)rsAcSum, (Statement)psAcSum);
                countVeriSql.append("select count(*) from (").append(" select distinct FCURRID,HGID from ").append(paramAge.getTempTableSumVeri()).append(" GROUP BY FCURRID,HGID ) temp");
                psVeriSum = con.prepareStatement(countVeriSql.toString());
                rsVeriSum = psVeriSum.executeQuery();
                if (rsVeriSum.next()) {
                    veriCount = rsVeriSum.getInt(1);
                }
                SQLUtils.cleanup((ResultSet)rsVeriSum, (Statement)psVeriSum);
                StringBuffer acSumSql = new StringBuffer();
                StringBuffer veriSumSql = new StringBuffer();
                HashMap<String, Object> map = null;
                BigDecimal acSumTotal = null;
                BigDecimal veriSumTotal = null;
                String fCurrID = null;
                String FHgID = null;
                if (acCount >= veriCount) {
                    acSumSql.append(" select sum(foriginalAmt),FCURRID,HGID from ").append(paramAge.getTempTableAcSum()).append(" GROUP BY FCURRID,HGID ");
                    veriSumSql.append(" select sum(foriginalAmt) from ").append(paramAge.getTempTableSumVeri()).append(" where FCURRID = ? and HGID = ?");
                    psAcSum = con.prepareStatement(acSumSql.toString());
                    rsAcSum = psAcSum.executeQuery();
                    while (rsAcSum.next()) {
                        try {
                            psVeriSum = con.prepareStatement(veriSumSql.toString());
                            fCurrID = rsAcSum.getString(2);
                            FHgID = rsAcSum.getString(3);
                            psVeriSum.setString(1, fCurrID);
                            psVeriSum.setString(2, FHgID);
                            rsVeriSum = psVeriSum.executeQuery();
                            if (!rsVeriSum.next()) continue;
                            acSumTotal = rsAcSum.getBigDecimal(1);
                            veriSumTotal = rsVeriSum.getBigDecimal(1);
                            map = new HashMap<String, Object>();
                            if (null == acSumTotal) {
                                map.put("type", 0);
                            } else if (acSumTotal.compareTo(GlUtils.zero) > 0 && veriSumTotal.compareTo(GlUtils.zero) > 0 && acSumTotal.compareTo(veriSumTotal) < 0 || acSumTotal.compareTo(GlUtils.zero) < 0 && veriSumTotal.compareTo(GlUtils.zero) < 0 && acSumTotal.compareTo(veriSumTotal) > 0) {
                                map.put("type", 1);
                                map.put("leftAmount", veriSumTotal.subtract(acSumTotal));
                            } else {
                                map.put("type", 2);
                            }
                            map.put("fCurrID", fCurrID);
                            map.put("FHgID", FHgID);
                            list.add(map);
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                        finally {
                            SQLUtils.cleanup((ResultSet)rsVeriSum, (Statement)psVeriSum);
                        }
                    }
                } else {
                    veriSumSql.append(" select sum(foriginalAmt),FCURRID,HGID from ").append(paramAge.getTempTableSumVeri()).append(" GROUP BY FCURRID,HGID ");
                    acSumSql.append(" select sum(foriginalAmt) from ").append(paramAge.getTempTableAcSum()).append(" where FCURRID = ? and HGID = ?");
                    psVeriSum = con.prepareStatement(veriSumSql.toString());
                    rsVeriSum = psVeriSum.executeQuery();
                    while (rsVeriSum.next()) {
                        try {
                            psAcSum = con.prepareStatement(acSumSql.toString());
                            fCurrID = rsVeriSum.getString(2);
                            FHgID = rsVeriSum.getString(3);
                            psAcSum.setString(1, fCurrID);
                            psAcSum.setString(2, FHgID);
                            rsAcSum = psAcSum.executeQuery();
                            if (!rsAcSum.next()) continue;
                            acSumTotal = rsAcSum.getBigDecimal(1);
                            veriSumTotal = rsVeriSum.getBigDecimal(1);
                            map = new HashMap();
                            if (null == acSumTotal) {
                                map.put("type", 0);
                            } else if (acSumTotal.compareTo(GlUtils.zero) > 0 && veriSumTotal.compareTo(GlUtils.zero) > 0 && acSumTotal.compareTo(veriSumTotal) < 0 || acSumTotal.compareTo(GlUtils.zero) < 0 && veriSumTotal.compareTo(GlUtils.zero) < 0 && acSumTotal.compareTo(veriSumTotal) > 0) {
                                map.put("type", 1);
                                map.put("leftAmount", veriSumTotal.subtract(acSumTotal));
                            } else {
                                map.put("type", 2);
                            }
                            map.put("fCurrID", fCurrID);
                            map.put("FHgID", FHgID);
                            list.add(map);
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                        finally {
                            SQLUtils.cleanup((ResultSet)rsAcSum, (Statement)psAcSum);
                        }
                    }
                }
                SQLUtils.cleanup((ResultSet)rsAcSum, (Statement)psAcSum);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                break block29;
            }
            finally {
                SQLUtils.cleanup(rsAcSum, psAcSum);
                SQLUtils.cleanup(rsVeriSum, psVeriSum);
            }
            SQLUtils.cleanup((ResultSet)rsVeriSum, (Statement)psVeriSum);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simulVeri_showVerifyAge(AccountAgeParam paramAge, Connection con, BigDecimal leftAmount, String fcurrID, String fhgID) {
        block16: {
            PreparedStatement psSelect = null;
            PreparedStatement psUpate = null;
            ResultSet rsSelect = null;
            ResultSet rsUpate = null;
            BigDecimal nagetiveOne = new BigDecimal(-1);
            StringBuffer selectSql = new StringBuffer();
            selectSql.append(" select FVchAstRcdID,foriginalAmt from ").append(paramAge.getTempTableSumVeri()).append(" where foriginalAmt<>0.0 ").append(" and fcurrID = '").append(fcurrID).append("' and hgID = '").append(fhgID).append("' ").append(" order by ").append(paramAge.getStrDateType()).append(" desc ");
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update ").append(paramAge.getTempTableAcSum()).append(" set foriginalAmt = 0.0 ").append(" where 1=1 ").append(" and fcurrID = '").append(fcurrID).append("' and hgID = '").append(fhgID).append("' ");
            try {
                psUpate = con.prepareStatement(updateSql.toString());
                psUpate.execute();
                psUpate.close();
                psSelect = con.prepareStatement(selectSql.toString());
                rsSelect = psSelect.executeQuery();
                updateSql.append(" update ").append(paramAge.getTempTableSumVeri()).append(" set foriginalAmt = ?").append(" where FVchAstRcdID = ? ").append(" and fcurrID = '").append(fcurrID).append("' and hgID = '").append(fhgID).append("' ");
                psUpate = con.prepareStatement(updateSql.toString());
                BigDecimal updateToAmount = null;
                BigDecimal originalAmount = null;
                String fBillID = null;
                int count = 0;
                if (leftAmount.compareTo(GlUtils.zero) > 0) {
                    while (rsSelect.next()) {
                        fBillID = rsSelect.getString(1);
                        originalAmount = rsSelect.getBigDecimal(2);
                        if (originalAmount.compareTo(GlUtils.zero) > 0 && originalAmount.compareTo(leftAmount) >= 0) {
                            updateToAmount = leftAmount;
                            psUpate.setBigDecimal(1, updateToAmount);
                            psUpate.setString(2, fBillID);
                            psUpate.addBatch();
                            ++count;
                            while (rsSelect.next()) {
                                fBillID = rsSelect.getString(1);
                                updateToAmount = GlUtils.zero;
                                psUpate.setBigDecimal(1, updateToAmount);
                                psUpate.setString(2, fBillID);
                                psUpate.addBatch();
                                ++count;
                            }
                            continue;
                        }
                        if (originalAmount.compareTo(GlUtils.zero) > 0 && originalAmount.compareTo(leftAmount) < 0) {
                            updateToAmount = originalAmount;
                            leftAmount = leftAmount.subtract(originalAmount);
                            psUpate.setBigDecimal(1, updateToAmount);
                            psUpate.setString(2, fBillID);
                            psUpate.addBatch();
                            ++count;
                            continue;
                        }
                        if (originalAmount.compareTo(GlUtils.zero) > 0) continue;
                        fBillID = rsSelect.getString(1);
                        updateToAmount = GlUtils.zero;
                        psUpate.setBigDecimal(1, updateToAmount);
                        psUpate.setString(2, fBillID);
                        psUpate.addBatch();
                        ++count;
                    }
                } else {
                    while (rsSelect.next()) {
                        fBillID = rsSelect.getString(1);
                        originalAmount = rsSelect.getBigDecimal(2);
                        if (originalAmount.compareTo(GlUtils.zero) < 0 && originalAmount.compareTo(leftAmount) <= 0) {
                            updateToAmount = leftAmount;
                            psUpate.setBigDecimal(1, updateToAmount);
                            psUpate.setString(2, fBillID);
                            psUpate.addBatch();
                            ++count;
                            while (rsSelect.next()) {
                                fBillID = rsSelect.getString(1);
                                updateToAmount = GlUtils.zero;
                                psUpate.setBigDecimal(1, updateToAmount);
                                psUpate.setString(2, fBillID);
                                psUpate.addBatch();
                                ++count;
                            }
                            continue;
                        }
                        if (originalAmount.compareTo(GlUtils.zero) < 0 && originalAmount.compareTo(leftAmount) > 0) {
                            updateToAmount = originalAmount;
                            leftAmount = leftAmount.subtract(originalAmount);
                            psUpate.setBigDecimal(1, updateToAmount);
                            psUpate.setString(2, fBillID);
                            psUpate.addBatch();
                            ++count;
                            continue;
                        }
                        if (originalAmount.compareTo(GlUtils.zero) < 0) continue;
                        fBillID = rsSelect.getString(1);
                        updateToAmount = GlUtils.zero;
                        psUpate.setBigDecimal(1, updateToAmount);
                        psUpate.setString(2, fBillID);
                        psUpate.addBatch();
                        ++count;
                    }
                }
                if (count > 0) {
                    psUpate.executeBatch();
                    psUpate.clearBatch();
                }
                SQLUtils.cleanup((ResultSet)rsSelect, (Statement)psSelect);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                break block16;
            }
            finally {
                SQLUtils.cleanup(rsSelect, psSelect);
                SQLUtils.cleanup(rsUpate, (Statement)psUpate);
            }
            SQLUtils.cleanup(rsUpate, (Statement)psUpate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simulVeri_showVerifyAge_AcZero(AccountAgeParam paramAge, Connection con, String fcurrID, String fhgID) throws BOSException {
        ResultSet rsUpate;
        ResultSet rsSelect;
        PreparedStatement psUpate;
        PreparedStatement psSelect;
        block5: {
            StringBuffer selectSql = new StringBuffer();
            selectSql.append(" select FVchAstRcdID,foriginalAmt from ").append(paramAge.getTempTableSumVeri()).append(" where foriginalAmt<>0.0").append(" and fcurrID = '").append(fcurrID).append("' and hgID = '").append(fhgID).append("' ");
            StringBuffer updateSql = new StringBuffer();
            updateSql.append(" update ").append(paramAge.getTempTableSumVeri()).append(" set foriginalAmt = ?").append(" where FVchAstRcdID = ? ").append(" and fcurrID = '").append(fcurrID).append("' and hgID = '").append(fhgID).append("' ");
            psSelect = null;
            psUpate = null;
            rsSelect = null;
            rsUpate = null;
            BigDecimal nagetiveOne = new BigDecimal(-1);
            try {
                psSelect = con.prepareStatement(selectSql.toString());
                psUpate = con.prepareStatement(updateSql.toString());
                rsSelect = psSelect.executeQuery();
                int count = 0;
                while (rsSelect.next()) {
                    psUpate.setBigDecimal(1, rsSelect.getBigDecimal(2));
                    psUpate.setString(2, rsSelect.getString(1));
                    psUpate.addBatch();
                    ++count;
                }
                if (count == 0) break block5;
                psUpate.executeBatch();
                psUpate.clearBatch();
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rsSelect, (Statement)psSelect);
                    SQLUtils.cleanup(rsUpate, psUpate);
                    throw throwable;
                }
                SQLUtils.cleanup(rsSelect, (Statement)psSelect);
                SQLUtils.cleanup(rsUpate, (Statement)psUpate);
            }
        }
        SQLUtils.cleanup((ResultSet)rsSelect, (Statement)psSelect);
        SQLUtils.cleanup(rsUpate, (Statement)psUpate);
    }

    private void simulVeri_showCussentAge(AccountAgeParam paramAge, Connection con, String fcurrID, String fhgID) throws SQLException {
        PreparedStatement psAc = null;
        PreparedStatement psVeri = null;
        PreparedStatement psUpdateAc = null;
        PreparedStatement psUpdateVeri = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlUpdate = new StringBuffer();
        StringBuffer sqlWhere = new StringBuffer();
        ResultSet rsAc = null;
        ResultSet rsVeri = null;
        ArrayList lstParam = new ArrayList();
        boolean index = true;
        String billidAc = "";
        String billidVeri = "";
        BigDecimal amountAc = GlUtils.zero;
        BigDecimal amountVeri = GlUtils.zero;
        String hgidAc = "";
        String hgidVeri = "";
        String curridAc = "";
        String curridVeri = "";
        boolean isVeriOverAc = true;
        boolean isVeriOverVeri = true;
        boolean isHasNextRsAc = true;
        boolean isHasNextRsVeri = true;
        boolean isHasVerifiedAc = false;
        boolean isHasVerifiedVeri = false;
        int iCountPsUpdateAc = 0;
        int iCountPsUpdateVeri = 0;
        sql.setLength(0);
        sql.append(" select FCUSSENTID FBillID,FCurrid,Hgid,FOriginalAmt  \r\n");
        sql.append(" from ").append(paramAge.getTempTableAcSum()).append(" ac  \r\n");
        sql.append(" where ac.FOriginalAmt <> 0.0  \r\n");
        sql.append(" and exists (                         \r\n");
        sql.append("   select 1 from ").append(paramAge.getTempTableSumVeri()).append(" veri  \r\n");
        sql.append("   where ac.Hgid = veri.Hgid and ac.FCurrid = veri.FCurrid  \r\n");
        sql.append(" )                                     \r\n");
        sql.append(" and fcurrID = '").append(fcurrID).append("' and hgID = '").append(fhgID).append("' ");
        sql.append(" order by FCurrid,Hgid,").append(paramAge.getStrDateType()).append("   \r\n");
        psAc = con.prepareStatement(sql.toString());
        rsAc = psAc.executeQuery();
        if (!rsAc.next()) {
            SQLUtils.cleanup((ResultSet)rsAc, (Statement)psAc);
            return;
        }
        sql.setLength(0);
        sql.append(" select FVchAstRcdID FBillID,FCurrid,Hgid,FOriginalAmt  \r\n");
        sql.append(" from ").append(paramAge.getTempTableSumVeri()).append(" veri  \r\n");
        sql.append(" where veri.FOriginalAmt <> 0.0  \r\n");
        sql.append(" and exists (                         \r\n");
        sql.append("   select 1 from ").append(paramAge.getTempTableAcSum()).append(" ac  \r\n");
        sql.append("   where ac.Hgid = veri.Hgid and ac.FCurrid = veri.FCurrid  \r\n");
        sql.append(" )                                     \r\n");
        sql.append(" and fcurrID = '").append(fcurrID).append("' and hgID = '").append(fhgID).append("' ");
        sql.append(" order by FCurrid,Hgid,").append(paramAge.getStrDateType()).append("   \r\n");
        psVeri = con.prepareStatement(sql.toString());
        rsVeri = psVeri.executeQuery();
        if (!rsVeri.next()) {
            SQLUtils.cleanup((ResultSet)rsVeri, (Statement)psVeri);
            return;
        }
        sqlUpdate.setLength(0);
        sqlUpdate.append("update ").append(paramAge.getTempTableAcSum());
        sqlUpdate.append(" set FOriginalAmt = ? ");
        sqlUpdate.append(" Where FCUSSENTID = ? ");
        psUpdateAc = con.prepareStatement(sqlUpdate.toString());
        sqlUpdate.setLength(0);
        sqlUpdate.append("update ").append(paramAge.getTempTableSumVeri());
        sqlUpdate.append(" set FOriginalAmt = ? ");
        sqlUpdate.append(" Where FVchAstRcdID = ? ");
        psUpdateVeri = con.prepareStatement(sqlUpdate.toString());
        boolean isFirstTime = true;
        try {
            while (true) {
                if (isVeriOverVeri && !isFirstTime) {
                    isHasNextRsVeri = rsVeri.next();
                }
                if (isVeriOverAc && !isFirstTime) {
                    isHasNextRsAc = rsAc.next();
                }
                if (isFirstTime) {
                    isFirstTime = false;
                }
                if (isVeriOverAc && !isHasNextRsAc && isVeriOverVeri && !isHasNextRsVeri) break;
                if (!isVeriOverAc || !isVeriOverVeri) {
                    if (!isVeriOverVeri && isVeriOverAc && !isHasNextRsAc) {
                        iCountPsUpdateVeri = this.updateTempTable_ByBal_AcVeriSub(iCountPsUpdateVeri, psUpdateVeri, billidVeri, amountVeri);
                        break;
                    }
                    if (!isVeriOverAc && isVeriOverVeri && !isHasNextRsVeri) {
                        iCountPsUpdateAc = this.updateTempTable_ByBal_AcVeriSub(iCountPsUpdateAc, psUpdateAc, billidAc, amountAc);
                        break;
                    }
                } else if (!isHasNextRsAc || !isHasNextRsVeri) break;
                if (isHasNextRsAc && isVeriOverAc) {
                    billidAc = rsAc.getString("FBillID");
                    curridAc = rsAc.getString("FCurrid");
                    hgidAc = rsAc.getString("hgid");
                    amountAc = rsAc.getBigDecimal("FOriginalAmt");
                }
                if (isVeriOverVeri && isVeriOverVeri) {
                    billidVeri = rsVeri.getString("FBillID");
                    curridVeri = rsVeri.getString("FCurrid");
                    hgidVeri = rsVeri.getString("hgid");
                    amountVeri = rsVeri.getBigDecimal("FOriginalAmt");
                }
                if (amountVeri.compareTo(GlUtils.zero) == 0 || amountAc.compareTo(GlUtils.zero) == 0) {
                    isVeriOverAc = amountAc.compareTo(GlUtils.zero) == 0;
                    isVeriOverVeri = amountVeri.compareTo(GlUtils.zero) == 0;
                    continue;
                }
                if (curridAc.compareTo(curridVeri) != 0 || hgidAc.compareToIgnoreCase(hgidVeri) != 0) {
                    if (!isVeriOverAc && isHasVerifiedAc) {
                        iCountPsUpdateAc = this.updateTempTable_ByBal_AcVeriSub(iCountPsUpdateAc, psUpdateAc, billidAc, amountAc);
                        isVeriOverAc = true;
                        isHasVerifiedAc = false;
                        isVeriOverVeri = false;
                        continue;
                    }
                    if (!isVeriOverVeri && isHasVerifiedVeri) {
                        iCountPsUpdateVeri = this.updateTempTable_ByBal_AcVeriSub(iCountPsUpdateVeri, psUpdateVeri, billidVeri, amountVeri);
                        isVeriOverVeri = true;
                        isHasVerifiedVeri = false;
                        isVeriOverAc = false;
                        continue;
                    }
                    if (curridAc.compareTo(curridVeri) > 0 || curridAc.compareTo(curridVeri) == 0 && hgidAc.compareTo(hgidVeri) > 0) {
                        isVeriOverAc = false;
                        isVeriOverVeri = true;
                        isHasVerifiedVeri = false;
                        continue;
                    }
                    isVeriOverAc = true;
                    isVeriOverVeri = false;
                    isHasVerifiedAc = false;
                    continue;
                }
                isVeriOverAc = false;
                isVeriOverVeri = false;
                isHasVerifiedAc = true;
                isHasVerifiedVeri = true;
                if (amountAc.compareTo(GlUtils.zero) > 0 && amountVeri.compareTo(GlUtils.zero) > 0) {
                    if (amountAc.compareTo(amountVeri) >= 0) {
                        amountAc = amountAc.subtract(amountVeri);
                        amountVeri = GlUtils.zero;
                    } else {
                        amountVeri = amountVeri.subtract(amountAc);
                        amountAc = GlUtils.zero;
                    }
                } else if (amountAc.compareTo(GlUtils.zero) < 0 && amountVeri.compareTo(GlUtils.zero) < 0) {
                    if (amountAc.compareTo(amountVeri) <= 0) {
                        amountAc = amountAc.subtract(amountVeri);
                        amountVeri = GlUtils.zero;
                    } else {
                        amountVeri = amountVeri.subtract(amountAc);
                        amountAc = GlUtils.zero;
                    }
                } else {
                    amountAc = amountAc.subtract(amountVeri);
                    amountVeri = GlUtils.zero;
                }
                isVeriOverAc = amountAc.compareTo(GlUtils.zero) == 0;
                boolean bl = isVeriOverVeri = amountVeri.compareTo(GlUtils.zero) == 0;
                if (isVeriOverAc) {
                    iCountPsUpdateAc = this.updateTempTable_ByBal_AcVeriSub(iCountPsUpdateAc, psUpdateAc, billidAc, amountAc);
                    isHasVerifiedAc = false;
                }
                if (!isVeriOverVeri) continue;
                iCountPsUpdateVeri = this.updateTempTable_ByBal_AcVeriSub(iCountPsUpdateVeri, psUpdateVeri, billidVeri, amountVeri);
                isHasVerifiedVeri = false;
            }
            if (iCountPsUpdateAc > 0) {
                iCountPsUpdateAc = 0;
                psUpdateAc.executeBatch();
                psUpdateAc.clearBatch();
            }
            if (iCountPsUpdateVeri > 0) {
                iCountPsUpdateVeri = 0;
                psUpdateVeri.executeBatch();
                psUpdateVeri.clearBatch();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            SQLUtils.cleanup((ResultSet)rsVeri, (Statement)psVeri);
            SQLUtils.cleanup((ResultSet)rsAc, (Statement)psAc);
            SQLUtils.cleanup((Statement)psUpdateAc);
            SQLUtils.cleanup((Statement)psUpdateVeri);
        }
    }

    private String getSelectorByBal(AccountAgeParam paramAge, boolean isAc, boolean isHis) {
        StringBuilder selector = new StringBuilder();
        selector.append("cussent.fid FActId, cussent.FEndDate FEndDate,cussent.fbizNumber FBizNumber,cussent.FDescription FDescription,");
        if (isAc) {
            selector.append("cussent.fvoucherid FVoucherId,cussent.fvchnumber FVoucherNumber,cussent.fperiodId FPeriodID,cussent.fvouchertypeid FVoucherTypeID,");
            selector.append("1 FDataType,");
            selector.append("cussent.fvarbizdate fbizDate,");
            if (isHis) {
                selector.append("khis.FOROGINALAMOUNT FOriginalAmt ");
            } else {
                selector.append(paramAge.getAmountField()).append(" FOriginalAmt ");
            }
        } else {
            selector.append("cussent.FVoucherID FVoucherId,cussent.FVchNumber FVoucherNumber,cussent.fperiodId FPeriodID,cussent.FVoucherTypeID FVoucherTypeID,");
            selector.append("2 FDataType,");
            selector.append("cussent.fvarbizdate fbizDate,");
            if (isHis) {
                selector.append("khis.FOROGINALAMOUNT FOriginalAmt ");
            } else {
                selector.append("cussent.funVerifiedAmtFor FOriginalAmt ");
            }
        }
        return selector.toString();
    }
}

