/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public abstract class GLActionListener {
    private static Logger logger = Logger.getLogger(GLActionListener.class);
    private static Map<String, Map<String, List<String>>> classNamesss = new Hashtable<String, Map<String, List<String>>>();
    private static Map<String, List<GLActionListener>> listenerss = new ConcurrentHashMap<String, List<GLActionListener>>();
    private String actionName;
    private String pointCut;

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getPointCut() {
        return this.pointCut;
    }

    public void setPointCut(String pointCut) {
        this.pointCut = pointCut;
    }

    public abstract Object actionPerformed(Context var1, Object var2) throws EASBizException, BOSException;

    public static List<GLActionListener> getListeners(Context ctx, String actionName, String pointCut) throws BOSException {
        String ais = ctx.getAIS();
        String key = ais + "_" + actionName + "_" + pointCut;
        List<GLActionListener> listeners = listenerss.get(key);
        if (listeners != null) {
            return listeners;
        }
        List<String> classNames = GLActionListener.getClassNames(ctx, actionName, pointCut);
        listeners = new ArrayList<GLActionListener>(classNames.size());
        try {
            for (String className : classNames) {
                GLActionListener listener = (GLActionListener)Class.forName(className).newInstance();
                listener.setActionName(actionName);
                listener.setPointCut(pointCut);
                listeners.add(listener);
            }
        }
        catch (Exception e) {
            throw new BOSException();
        }
        listenerss.put(key, listeners);
        return listeners;
    }

    private static List<String> getClassNames(Context ctx, String actionName, String pointCut) throws BOSException {
        String key = actionName + "_" + pointCut;
        List<String> classNames = GLActionListener.getClassNamess(ctx).get(key);
        if (classNames == null) {
            classNames = new ArrayList<String>();
        }
        return classNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, List<String>> getClassNamess(Context ctx) throws BOSException {
        Map<String, List<String>> classNamess = classNamesss.get(ctx.getAIS());
        if (classNamess != null) {
            return classNamess;
        }
        Map<String, Map<String, List<String>>> map = classNamesss;
        synchronized (map) {
            classNamess = classNamesss.get(ctx.getAIS());
            if (classNamess != null) {
                return classNamess;
            }
            classNamess = new HashMap<String, List<String>>();
            String sql = "select FActionName, FPointCut, FClassName from T_GL_ActionListener where FIsEnable = 1";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                while (rs.next()) {
                    String actionName = rs.getString("FActionName");
                    String pointCut = rs.getString("FPointCut");
                    String className = rs.getString("FClassName");
                    String key = actionName + "_" + pointCut;
                    List<String> classNames = classNamess.get(key);
                    if (classNames == null) {
                        classNames = new ArrayList<String>();
                        classNamess.put(key, classNames);
                    }
                    classNames.add(className);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            classNamesss.put(ctx.getAIS(), classNamess);
            return classNamess;
        }
    }
}

