/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeEntryInfo;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeInfo;
import com.kingdee.eas.basedata.master.account.IAsstAccountChangeProcess;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.gl.GLBalanceRepairFacadeFactory;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.AsstActFinder;
import com.kingdee.eas.fi.gl.app.GLAsstAccountChangeTransfer;
import com.kingdee.eas.fi.gl.app.GLBalanceFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.MockVoucherControllerBean;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLAsstAccountChangeProcess
implements IAsstAccountChangeProcess {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLAsstAccountChangeProcess");
    private static final String RESOURCE = "com.kingdee.eas.fi.gl.GLAsstAccountChangeResource";
    private Map<String, AsstAccountInfo> caas = new HashMap<String, AsstAccountInfo>();
    private Map<String, AsstActTypeCollection> asstActTypess = new HashMap<String, AsstActTypeCollection>();
    private Map<String, AssistantHGInfo> idToHGs = new HashMap<String, AssistantHGInfo>();
    private Map<String, AssistantHGInfo> atToHgs = new HashMap<String, AssistantHGInfo>();
    private Context ctx;
    private AsstAccountChangeInfo change = null;
    private CompanyOrgUnitInfo company = null;
    private PeriodInfo period = null;
    private PeriodInfo start = null;
    private PeriodInfo acStart = null;
    private AccountViewInfo account;
    private String oldCaa = null;
    private String newCaa = null;
    private Map defaultVal;
    private boolean isNeedFixBank = false;
    private Map<String, BankInfo> banks = new HashMap<String, BankInfo>();
    private Uuid requestId = null;
    public static final String UPDATE_MODEL = "GL_AAC_OneByOne";
    private boolean oneByOne = true;

    public void init(Context ctx, AsstAccountChangeInfo change, Map defaultVal) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.change = change;
        this.defaultVal = defaultVal;
        this.company = change.getAccount().getCompanyID();
        this.period = change.getPeriod();
        this.account = change.getAccount();
        if (change.getAfter() != null) {
            this.newCaa = change.getAfter().getId().toString();
        }
        if (change.getBefore() != null) {
            this.oldCaa = change.getBefore().getId().toString();
        }
    }

    public void check() throws BOSException, EASBizException {
        if (this.period == null) {
            return;
        }
        if (!this.account.isIsLeaf()) {
            return;
        }
        if (!this.company.isIsBizUnit()) {
            return;
        }
        this.start = SystemStatusCtrolUtils.getStartPeriod((Context)this.ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.company);
        HashMap<String, Object> inParams = new HashMap<String, Object>();
        inParams.put(UPDATE_MODEL, null);
        HashMap outParams = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamHashMap(inParams);
        if ("false".equals(outParams.get(UPDATE_MODEL))) {
            this.oneByOne = false;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append(" p.FID, p.FNumber, p.FPeriodYear, p.FPeriodNumber \n");
        sql.append(" from t_gl_flag f \n");
        sql.append(" inner join t_bd_period p on f.finitperiodid = p.fid \n");
        sql.append(" where f.fkey = ? and f.fname='cussentinit'");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.account.getId().toString()});
        try {
            String id;
            if (rs.next() && (id = rs.getString("FID")) != null) {
                this.acStart = new PeriodInfo();
                this.acStart.setId(BOSUuid.read((String)id));
                this.acStart.setNumber(rs.getInt("FNumber"));
                this.acStart.setPeriodYear(rs.getInt("FPeriodYear"));
                this.acStart.setPeriodNumber(rs.getInt("FPeriodNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (this.acStart == null) {
            this.acStart = this.start;
        }
        AsstActTypeInfo oldBankType = null;
        AsstActTypeInfo oldAccountBankType = null;
        AsstActTypeCollection oldTypes = new AsstActTypeCollection();
        if (this.oldCaa != null) {
            oldTypes = this.getAsstActTypes(this.oldCaa);
        }
        for (AsstActTypeInfo type : oldTypes) {
            if ("region".equalsIgnoreCase(type.getAsstHGAttribute())) {
                oldBankType = type;
                continue;
            }
            if (!"bankAccount".equalsIgnoreCase(type.getAsstHGAttribute())) continue;
            oldAccountBankType = type;
        }
        AsstActTypeInfo newBankType = null;
        AsstActTypeInfo newBankAccount = null;
        AsstActTypeCollection newTypes = new AsstActTypeCollection();
        if (this.newCaa != null) {
            newTypes = this.getAsstActTypes(this.newCaa);
        }
        for (AsstActTypeInfo type : newTypes) {
            if ("region".equalsIgnoreCase(type.getAsstHGAttribute())) {
                newBankType = type;
                continue;
            }
            if (!"bankAccount".equalsIgnoreCase(type.getAsstHGAttribute())) continue;
            newBankAccount = type;
        }
        if (oldBankType == null && oldAccountBankType == null && newBankType != null && newBankAccount != null) {
            BankInfo bank = null;
            AccountBankInfo bankAccount = null;
            for (Object obj : this.defaultVal.values()) {
                if (obj instanceof BankInfo) {
                    bank = (BankInfo)obj;
                    continue;
                }
                if (!(obj instanceof AccountBankInfo)) continue;
                bankAccount = (AccountBankInfo)obj;
            }
            if (bank != null && bankAccount != null) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                view.setSelector(selector);
                selector.add("id");
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)bankAccount.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)bank.getId().toString()));
                AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankCollection(view);
                if (coll.size() <= 0) {
                    throw new EASBizException(new NumericExceptionSubItem("101", MessageFormat.format(ResourceBase.getString((String)RESOURCE, (String)"Mismatch", (Locale)this.ctx.getOriginLocale()), newBankType.getName(), newBankAccount.getName())));
                }
            }
        } else if (oldBankType == null && oldAccountBankType != null && newBankType != null && newBankAccount != null) {
            this.isNeedFixBank = true;
        } else if (oldBankType != null && oldAccountBankType == null && newBankType != null && newBankAccount != null) {
            throw new EASBizException(new NumericExceptionSubItem("101", MessageFormat.format(ResourceBase.getString((String)RESOURCE, (String)"NotAllowChange", (Locale)this.ctx.getOriginLocale()), oldBankType.getName(), newBankType.getName(), newBankAccount.getName())));
        }
        if (!this.account.containsKey("AC")) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("AC");
            AccountViewInfo temp = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(this.account.getId()), selector);
            this.account.setAC(temp.isAC());
        }
        if (this.account.isAC() && this.oldCaa != null) {
            HashMap<String, AsstActTypeInfo> newMap = new HashMap<String, AsstActTypeInfo>();
            for (AsstActTypeInfo type : newTypes) {
                newMap.put(type.getId().toString(), type);
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("asstActType.id");
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isAccountCussent", (Object)1));
            view.setFilter(filter);
            AsstActTypeDefaultCollection coll = AsstActTypeDefaultFactory.getLocalInstance((Context)this.ctx).getAsstActTypeDefaultCollection(view);
            HashSet<String> acIds = new HashSet<String>();
            for (AsstActTypeDefaultInfo def : coll) {
                acIds.add(def.getAsstActType().getId().toString());
            }
            for (AsstActTypeInfo type : oldTypes) {
                if (!acIds.contains(type.getId().toString()) || newMap.containsKey(type.getId().toString())) continue;
                throw new EASBizException(new NumericExceptionSubItem("101", ResourceBase.getString((String)RESOURCE, (String)"AcAccountLossAcAAT", (Locale)this.ctx.getOriginLocale())));
            }
        }
        if (this.newCaa != null && this.defaultVal.size() > 0) {
            AsstActTypeCollection coll = this.getAsstActTypes(this.newCaa);
            HashMap<String, AsstActTypeInfo> aats = new HashMap<String, AsstActTypeInfo>();
            for (AsstActTypeInfo aat : coll) {
                aats.put(aat.getAsstHGAttribute().toLowerCase(), aat);
            }
            for (AsstActTypeInfo aat : this.defaultVal.keySet()) {
                String asstHGAttribute = aat.getAsstHGAttribute();
                Object val = this.defaultVal.get(aat);
                if (asstHGAttribute == null || val == null || (aat = (AsstActTypeInfo)aats.get(asstHGAttribute.toLowerCase())) == null || !(val instanceof DataBaseInfo)) continue;
                AsstActFinder finder = new AsstActFinder();
                DataBaseInfo db = (DataBaseInfo)val;
                HashSet<String> asstActIds = new HashSet<String>();
                asstActIds.add(db.getId().toString());
                try {
                    Map<String, Object> result = finder.findAsstActByIds(this.ctx, aat, asstActIds, this.account.getCompanyID(), null, null);
                    Object asstAct = result.get(db.getId().toString());
                    if (asstAct == null || !(asstAct instanceof String)) continue;
                    throw new EASBizException(new NumericExceptionSubItem("101", (String)asstAct));
                }
                catch (EASBizException e) {
                    throw e;
                }
                catch (BOSException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    public void change() throws BOSException, EASBizException {
        if (this.start == null || this.period == null) {
            return;
        }
        if (!this.account.isIsLeaf()) {
            return;
        }
        if (!this.company.isIsBizUnit()) {
            return;
        }
        AsstAccountChangeInfo last = (AsstAccountChangeInfo)this.change.get("last");
        String tOldCaa = this.oldCaa;
        boolean useLast = false;
        if (last != null && this.period.getNumber() == last.getPeriod().getNumber()) {
            this.deleteChangeVoucher();
            useLast = true;
            tOldCaa = last.getBefore() != null ? last.getBefore().getId().toString() : null;
        }
        this.dealAssInitData();
        this.dealVoucherData();
        this.dealCussentData();
        this.dealCusHisData();
        this.dealCusVerData();
        if (this.period.getNumber() != this.start.getNumber() && (this.newCaa == null && tOldCaa != null || this.newCaa != null && tOldCaa == null || this.newCaa != null && tOldCaa != null && !this.newCaa.equals(tOldCaa))) {
            if (useLast) {
                this.fixAsstAccountChange(this.ctx, this.change, last, this.defaultVal);
            }
            PeriodInfo current = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.company);
            if (this.period.getNumber() <= current.getNumber()) {
                GLAsstAccountChangeTransfer.process(this.ctx, this.change, this.defaultVal);
            }
        }
        this.dealAssBalData();
    }

    private void fixAsstAccountChange(Context ctx, AsstAccountChangeInfo change, AsstAccountChangeInfo last, Map defaultVal) throws BOSException {
        change.setBefore(last.getBefore());
        if (change.getAfter() == null) {
            return;
        }
        if (defaultVal == null) {
            return;
        }
        HashMap<String, String> asstActs = new HashMap<String, String>();
        for (int i = 0; i < last.getEntries().size(); ++i) {
            AsstAccountChangeEntryInfo entry = last.getEntries().get(i);
            if (entry.getAsstActType() == null) continue;
            asstActs.put(entry.getAsstActType().getId().toString(), entry.getAsstAct());
        }
        for (Object obj : defaultVal.keySet()) {
            String asstAct;
            AsstActTypeInfo asstActType;
            if (!(obj instanceof AsstActTypeInfo) || defaultVal.get(asstActType = (AsstActTypeInfo)obj) != null || (asstAct = (String)asstActs.get(asstActType.getId().toString())) == null) continue;
            ObjectBaseInfo value = GlWebServiceUtil.findAsstActObject(ctx, asstActType.getAsstHGAttribute(), asstAct);
            defaultVal.put(asstActType, value);
        }
    }

    private void deleteChangeVoucher() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FBizStatus from t_gl_voucher v \n");
        sql.append("where v.fcompanyid=? and v.fperiodid = ? and FSourceType=11 \n");
        sql.append("and exists ( \n");
        sql.append("  select 1 from t_gl_voucherentry ve where ve.FBILLID = v.FID and ve.FACCOUNTID = ? \n");
        sql.append(") \n");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new String[]{this.company.getId().toString(), this.period.getId().toString(), this.account.getId().toString()});
        HashMap<String, Integer> listPK = new HashMap<String, Integer>();
        boolean foundPosted = false;
        try {
            while (rs.next()) {
                listPK.put(rs.getString("FID"), rs.getInt("FBizStatus"));
                if (rs.getInt("FBizStatus") != 5) continue;
                foundPosted = true;
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append("delete from T_GL_AcctCussentHistory where FVOUCHERASSTIDID in ( \n");
        sql.append("  select FID from T_GL_AcctCussent where FVchAssistRecordID in ( \n");
        sql.append("    select FID from T_GL_VoucherAssistRecord where FBILLID = ? \n");
        sql.append("  ) \n");
        sql.append(") \n");
        for (String id : listPK.keySet()) {
            DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new String[]{id});
        }
        MockVoucherControllerBean voucher = new MockVoucherControllerBean();
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        try {
            if (foundPosted) {
                VoucherProcessCache.initCache(this.ctx, cacheId);
                VoucherProcessCache cache = VoucherProcessCache.getCache(this.ctx);
                cache.getDatasFromCache(this.ctx, "aac").put("aac", Boolean.TRUE);
            }
            for (String id : listPK.keySet()) {
                if ((Integer)listPK.get(id) != 5) continue;
                voucher.antiPostVoucher(this.ctx, (IObjectPK)new ObjectUuidPK(id), VoucherStatusEnum.POSTED);
            }
            boolean association = VoucherUtil.isAssociationCashManagement(this.ctx, this.company);
            if (association) {
                IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getLocalInstance((Context)this.ctx);
                for (String id : listPK.keySet()) {
                    if (!this.isBookByEntry(this.ctx, id)) {
                        bookNotifyFacade.antiBook(id);
                        continue;
                    }
                    bookNotifyFacade.batchAntiBook(this.getEntryIds(this.ctx, id));
                }
            }
            ArrayList<String> ids = new ArrayList<String>();
            ids.addAll(listPK.keySet());
            this.antiAuditCheckVoucher(this.ctx, ids);
            for (String id : listPK.keySet()) {
                voucher.delete(this.ctx, (IObjectPK)new ObjectUuidPK(id));
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            VoucherProcessCache.clearCache(this.ctx, cacheId);
        }
    }

    private boolean isBookByEntry(Context ctx, String vid) throws BOSException, EASBizException {
        String sql = "select fid from t_cas_journal where FBillID= ?";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{vid});
        return rowset == null || rowset.size() == 0;
    }

    private Set<String> getEntryIds(Context ctx, String vid) throws BOSException {
        String sql = "select FID from t_gl_voucherentry where FBillID = ?";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{vid});
        HashSet<String> ids = new HashSet<String>();
        try {
            while (rowset.next()) {
                ids.add(rowset.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ids;
    }

    private void antiAuditCheckVoucher(Context ctx, List<String> pkList) throws BOSException {
        String voStr = ToolUtils.aryToStr(pkList, (boolean)true);
        String updateSql = "update t_gl_voucher set fischeck =0 , FBizStatus=1, fauditorid=null,  fcashierid=null where\u3000fid in (" + voStr + ") ";
        DbUtil.execute((Context)ctx, (String)updateSql);
        String dpdatesql2 = "update T_GL_VoucherEntry set fischeck =0 , fcashierid= null  where FBillID in (" + voStr + ")";
        DbUtil.execute((Context)ctx, (String)dpdatesql2);
    }

    private void dealAssInitData() throws BOSException, EASBizException {
        if (this.period.getNumber() != this.start.getNumber()) {
            return;
        }
        if (this.newCaa == null) {
            String initSql = "delete from t_gl_initassistbalance where forgunitid = ? and faccountid = ? ";
            DbUtil.execute((Context)this.ctx, (String)initSql, (Object[])new Object[]{this.company.getId().toString(), this.account.getId().toString()});
            initSql = "delete from t_gl_flag where FName = 'astinit' and forgunitid = ? and fkey = ? ";
            DbUtil.execute((Context)this.ctx, (String)initSql, (Object[])new Object[]{this.company.getId().toString(), this.account.getId().toString()});
        } else if (this.oldCaa == null) {
            this.insertAssInitData();
        } else {
            StringBuffer selectSql = new StringBuffer();
            selectSql.append("select distinct fassistgrpid FOldHgID \n");
            selectSql.append("from t_gl_initassistbalance where forgunitid = ? and faccountid = ?");
            Object[] selectParams = new String[]{this.company.getId().toString(), this.account.getId().toString()};
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update t_gl_initassistbalance set (fassistgrpid) = ( \n");
            updateSql.append("    select Fnewhgid from T_TMP_ToNewHg \n");
            updateSql.append("    where t_gl_initassistbalance.forgunitid = ? \n");
            updateSql.append("        and t_gl_initassistbalance.faccountid = ? \n");
            updateSql.append("        and t_gl_initassistbalance.fassistgrpid = T_TMP_ToNewHg.FTargetID \n");
            updateSql.append(") \n");
            Object[] updateParams = selectParams;
            StringBuffer oboSql = new StringBuffer();
            oboSql.append("update t_gl_initassistbalance set fassistgrpid = ? \n");
            oboSql.append("where forgunitid = '" + this.company.getId().toString() + "' \n");
            oboSql.append("    and faccountid = '" + this.account.getId().toString() + "' \n");
            oboSql.append("    and fassistgrpid = ? \n");
            this.selectAndUpdate("assInit", selectSql.toString(), selectParams, updateSql.toString(), updateParams, oboSql.toString());
        }
    }

    private void insertAssInitData() throws EASBizException, BOSException {
        AssistantHGInfo hg = this.getNewAssistantHg(this.account, this.newCaa, null, null, this.defaultVal);
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_GL_InitAssistBalance                              \r\n");
        sql.append("(\t                                                            \r\n");
        sql.append("\tFOrgUnitID,                                                 \r\n");
        sql.append("\tFAccountID,                                                 \r\n");
        sql.append("\tFAssistGrpID,                                               \r\n");
        sql.append("\tFCurrencyID,                                                \r\n");
        sql.append("                                                                \r\n");
        sql.append("\tFBeginBalanceFor ,                                          \r\n");
        sql.append("\tFDebitFor ,                                                 \r\n");
        sql.append("\tFCreditFor ,                                                \r\n");
        sql.append("\tFYearDebitFor ,                                             \r\n");
        sql.append("\tFYearCreditFor ,                                            \r\n");
        sql.append("\tFEndBalanceFor ,                                            \r\n");
        sql.append("                                                                \r\n");
        sql.append("\tFBeginBalanceLocal ,                                        \r\n");
        sql.append("\tFDebitLocal ,                                               \r\n");
        sql.append("\tFCreditLocal ,                                              \r\n");
        sql.append("\tFYearDebitLocal ,                                           \r\n");
        sql.append("\tFYearCreditLocal ,                                          \r\n");
        sql.append("\tFEndBalanceLocal ,                                          \r\n");
        sql.append("                                                                \r\n");
        sql.append("\tFBeginBalanceRpt ,                                          \r\n");
        sql.append("\tFDebitRpt ,                                                 \r\n");
        sql.append("\tFCreditRpt ,                                                \r\n");
        sql.append("\tFYearDebitRpt ,                                             \r\n");
        sql.append("\tFYearCreditRpt ,                                            \r\n");
        sql.append("\tFEndBalanceRpt ,                                            \r\n");
        sql.append("\t                                                            \r\n");
        sql.append("\tFYearPnLFor,                                                \r\n");
        sql.append("\tFYearPnLLocal,                                              \r\n");
        sql.append("\tFYearPnLRpt,                                                \r\n");
        sql.append("\tFmonthPnLFor,                                               \r\n");
        sql.append("\tFmonthPnLLocal,                                             \r\n");
        sql.append("\tFmonthPnLRpt,                                               \r\n");
        sql.append("                                                                \r\n");
        sql.append("\tFBeginQty,                                                  \r\n");
        sql.append("\tFDebitQty,                                                  \r\n");
        sql.append("\tFCreditQty,                                                 \r\n");
        sql.append("\tFYearDebitQty,                                              \r\n");
        sql.append("\tFYearCreditQty,                                             \r\n");
        sql.append("\tFEndQty                                                     \r\n");
        sql.append(")                                                               \r\n");
        sql.append("                                                                \r\n");
        sql.append("select                                                          \r\n");
        sql.append("\tFOrgUnitID,                                                 \r\n");
        sql.append("\tFAccountID,                                                 \r\n");
        sql.append("\t?,                                                          \r\n");
        sql.append("\tFCurrencyID,                                                \r\n");
        sql.append("                                                                \r\n");
        sql.append("\tFBeginBalanceFor ,                                          \r\n");
        sql.append("\tFDebitFor ,                                                 \r\n");
        sql.append("\tFCreditFor ,                                                \r\n");
        sql.append("\tFYearDebitFor ,                                             \r\n");
        sql.append("\tFYearCreditFor ,                                            \r\n");
        sql.append("\tFEndBalanceFor ,                                            \r\n");
        sql.append("                                                                \r\n");
        sql.append("\tFBeginBalanceLocal ,                                        \r\n");
        sql.append("\tFDebitLocal ,                                               \r\n");
        sql.append("\tFCreditLocal ,                                              \r\n");
        sql.append("\tFYearDebitLocal ,                                           \r\n");
        sql.append("\tFYearCreditLocal ,                                          \r\n");
        sql.append("\tFEndBalanceLocal ,                                          \r\n");
        sql.append("                                                                \r\n");
        sql.append("\tFBeginBalanceRpt ,                                          \r\n");
        sql.append("\tFDebitRpt ,                                                 \r\n");
        sql.append("\tFCreditRpt ,                                                \r\n");
        sql.append("\tFYearDebitRpt ,                                             \r\n");
        sql.append("\tFYearCreditRpt ,                                            \r\n");
        sql.append("\tFEndBalanceRpt ,                                            \r\n");
        sql.append("\t                                                            \r\n");
        sql.append("\tFYearPnLFor,                                                \r\n");
        sql.append("\tFYearPnLLocal,                                              \r\n");
        sql.append("\tFYearPnLRpt,                                                \r\n");
        sql.append("\tFmonthPnLFor,                                               \r\n");
        sql.append("\tFmonthPnLLocal,                                             \r\n");
        sql.append("\tFmonthPnLRpt,                                               \r\n");
        sql.append("                                                                \r\n");
        sql.append("\tFBeginQty,                                                  \r\n");
        sql.append("\tFDebitQty,                                                  \r\n");
        sql.append("\tFCreditQty,                                                 \r\n");
        sql.append("\tFYearDebitQty,                                              \r\n");
        sql.append("\tFYearCreditQty,                                             \r\n");
        sql.append("\tFEndQty                                                     \r\n");
        sql.append("from T_GL_InitAccountBalance                                    \r\n");
        sql.append("where FOrgUnitID = ? and FAccountID = ?                         \r\n");
        DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{hg.getId().toString(), this.company.getId().toString(), this.account.getId().toString()});
        sql.setLength(0);
        sql.append("delete from t_gl_flag where fname = 'astinit' and forgUnitid = ? and fkey = ?");
        DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.company.getId().toString(), this.account.getId().toString()});
        sql.setLength(0);
        sql.append("insert into t_gl_flag (fid, fname, fvalue, forgunitid, fkey) \n");
        sql.append("select newbosid('E5A15661'), 'astinit', t.fvalue, t.forgUnitid, ? \n");
        sql.append("from t_gl_flag t where t.fname = 'glinit' and t.forgUnitid = ? \n");
        DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.account.getId().toString(), this.company.getId().toString()});
    }

    private void unionAssInitData(String T_TMP_ToNewHg) throws BOSException {
        String initAssistBalanceTemp = this.createinitAssistBalanceTempTable();
        StringBuffer insertTempSql = new StringBuffer();
        insertTempSql.append(" insert into ").append(initAssistBalanceTemp);
        insertTempSql.append(" (FOrgUnitID, FAccountID, FCurrencyID,FAssistGrpID, ");
        insertTempSql.append(" FBeginBalanceFor,FDebitFor, FYearDebitFor, FCreditFor, FYearCreditFor, FEndBalanceFor, ");
        insertTempSql.append(" FBeginBalanceLocal,FDebitLocal, FYearDebitLocal, FCreditLocal, FYearCreditLocal, ");
        insertTempSql.append(" FEndBalanceLocal, FBeginBalanceRpt,FDebitRpt, FYearDebitRpt, FCreditRpt, FYearCreditRpt, ");
        insertTempSql.append(" FEndBalanceRpt, FBeginQty, FDebitQty, FYearDebitQty, FCreditQty, FYearCreditQty, FEndQty, ");
        insertTempSql.append(" FMonthPnLFor, FYearPnLFor, FMonthPnLLocal, FYearPnLLocal, FMonthPnLRpt, FYearPnLRpt) ");
        insertTempSql.append(" select balance.forgunitid, balance.faccountid, balance.fcurrencyid, hg.Fnewhgid, ");
        insertTempSql.append(" sum(balance.fbeginbalancefor) fbeginbalancefor,sum(balance.fdebitfor) fdebitfor, sum(balance.fyeardebitfor) fyeardebitfor,");
        insertTempSql.append(" sum(balance.fcreditfor) fcreditfor, sum(balance.fyearcreditfor) fyearcreditfor, ");
        insertTempSql.append(" sum(balance.fendbalancefor) fendbalancefor, ");
        insertTempSql.append(" sum(balance.fbeginbalanceLocal) fbeginbalanceLocal,sum(balance.fdebitlocal) fdebitlocal, sum(balance.fyeardebitLocal) fyeardebitLocal,");
        insertTempSql.append(" sum(balance.fcreditlocal) fcreditlocal, sum(balance.fyearcreditLocal) fyearcreditLocal, ");
        insertTempSql.append(" sum(balance.fendbalancelocal) fendbalancelocal, ");
        insertTempSql.append(" sum(balance.fbeginbalancerpt) fbeginbalancerpt,sum(balance.fdebitrpt) fdebitrpt,sum(balance.fyeardebitrpt) fyeardebitrpt, ");
        insertTempSql.append(" sum(balance.fcreditrpt) fcreditrpt,sum(balance.fyearcreditrpt) fyearcreditrpt, ");
        insertTempSql.append(" sum(balance.fendbalancerpt) fendbalancerpt,");
        insertTempSql.append(" sum(balance.fbeginqty) fbeginqty,sum(balance.fdebitqty) fdebitqty,sum(balance.fyeardebitqty) fyeardebitqty, ");
        insertTempSql.append(" sum(balance.fcreditqty) fcreditqty,sum(balance.fyearcreditqty) fyearcreditqty, ");
        insertTempSql.append(" sum(balance.fendqty) fendqty, ");
        insertTempSql.append(" sum(balance.fmonthpnlfor) fmonthpnlfor,sum(balance.fyearpnlfor) fyearpnlfor, ");
        insertTempSql.append(" sum(balance.fmonthpnllocal) fmonthpnllocal,sum(balance.fyearpnllocal) fyearpnllocal, ");
        insertTempSql.append(" sum(balance.fmonthpnlrpt) fmonthpnlrpt,sum(balance.fyearpnlrpt) fyearpnlrpt ");
        insertTempSql.append(" from T_GL_initAssistBalance balance ");
        insertTempSql.append(" inner join ").append(T_TMP_ToNewHg).append(" hg ");
        insertTempSql.append("   on hg.FTargetID = balance.FAssistGrpID ");
        insertTempSql.append(" where balance.forgunitid = ? and balance.FAccountID = ? ");
        insertTempSql.append(" group by balance.forgunitid, balance.faccountid,balance.fcurrencyid,hg.Fnewhgid ");
        insertTempSql.append(" having count(hg.Fnewhgid) > 1              ");
        DbUtil.execute((Context)this.ctx, (String)insertTempSql.toString(), (Object[])new Object[]{this.company.getId().toString(), this.account.getId().toString()});
        StringBuffer deleteSql = new StringBuffer();
        deleteSql.append(" delete from t_gl_initassistbalance        ");
        deleteSql.append(" where exists(                             ");
        deleteSql.append(" select 1 from ").append(T_TMP_ToNewHg).append(" hg ");
        deleteSql.append(" where t_gl_initassistbalance.FOrgUnitID = ? ");
        deleteSql.append("     and t_gl_initassistbalance.FAccountID = ? ");
        deleteSql.append("     and hg.FTargetID = t_gl_initassistbalance.FAssistGrpID and hg.FRepeat = 1 ");
        deleteSql.append(" )                                         ");
        DbUtil.execute((Context)this.ctx, (String)deleteSql.toString(), (Object[])new Object[]{this.company.getId().toString(), this.account.getId().toString()});
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" insert into t_gl_initassistbalance ");
        insertSql.append(" (FOrgUnitID, FAccountID, FCurrencyID,FAssistGrpID, ");
        insertSql.append(" FBeginBalanceFor,FDebitFor, FYearDebitFor, FCreditFor, FYearCreditFor, FEndBalanceFor, ");
        insertSql.append(" FBeginBalanceLocal,FDebitLocal, FYearDebitLocal, FCreditLocal, FYearCreditLocal, ");
        insertSql.append(" FEndBalanceLocal, FBeginBalanceRpt,FDebitRpt, FYearDebitRpt, FCreditRpt, FYearCreditRpt, ");
        insertSql.append(" FEndBalanceRpt, FBeginQty, FDebitQty, FYearDebitQty, FCreditQty, FYearCreditQty, FEndQty, ");
        insertSql.append(" FMonthPnLFor, FYearPnLFor, FMonthPnLLocal, FYearPnLLocal, FMonthPnLRpt, FYearPnLRpt) ");
        insertSql.append(" select FOrgUnitID, FAccountID, FCurrencyID,FAssistGrpID, ");
        insertSql.append(" FBeginBalanceFor,FDebitFor, FYearDebitFor, FCreditFor, FYearCreditFor, FEndBalanceFor, ");
        insertSql.append(" FBeginBalanceLocal,FDebitLocal, FYearDebitLocal, FCreditLocal, FYearCreditLocal, ");
        insertSql.append(" FEndBalanceLocal, FBeginBalanceRpt,FDebitRpt, FYearDebitRpt, FCreditRpt, FYearCreditRpt, ");
        insertSql.append(" FEndBalanceRpt, FBeginQty, FDebitQty, FYearDebitQty, FCreditQty, FYearCreditQty, FEndQty, ");
        insertSql.append(" FMonthPnLFor, FYearPnLFor, FMonthPnLLocal, FYearPnLLocal, FMonthPnLRpt, FYearPnLRpt ");
        insertSql.append(" from ").append(initAssistBalanceTemp);
        DbUtil.execute((Context)this.ctx, (String)insertSql.toString());
        try {
            TempTablePool.getInstance((Context)this.ctx).releaseTable(initAssistBalanceTemp);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String createinitAssistBalanceTempTable() throws BOSException {
        String initAssistBalanceTemp = null;
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append(" create table initAssistBalanceTemp ");
        createTableSql.append(" (FOrgUnitID VARCHAR(44) NOT NULL ,");
        createTableSql.append(" FAccountID VARCHAR(44) NOT NULL ,");
        createTableSql.append(" FCurrencyID VARCHAR(44) NOT NULL ,");
        createTableSql.append(" FAssistGrpID VARCHAR(44) NOT NULL ,");
        createTableSql.append(" FBeginBalanceFor NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FDebitFor NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearDebitFor NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FCreditFor NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearCreditFor NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FEndBalanceFor NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FBeginBalanceLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FDebitLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearDebitLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FCreditLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearCreditLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FEndBalanceLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FBeginBalanceRpt NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FDebitRpt NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearDebitRpt NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FCreditRpt NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearCreditRpt NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FEndBalanceRpt NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FBeginQty NUMERIC(28,10) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FDebitQty NUMERIC(28,10) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearDebitQty NUMERIC(28,10) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FCreditQty NUMERIC(28,10) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearCreditQty NUMERIC(28,10) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FEndQty NUMERIC(28,10) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FMonthPnLFor NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearPnLFor NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FMonthPnLLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearPnLLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FMonthPnLRpt NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        createTableSql.append(" FYearPnLRpt NUMERIC(19,4) DEFAULT 0 NOT NULL ");
        createTableSql.append(" )");
        try {
            initAssistBalanceTemp = TempTablePool.getInstance((Context)this.ctx).createTempTable(createTableSql.toString());
            String columns = "FOrgUnitID,FAccountID,FCurrencyID,FAssistGrpID";
            TempTablePool.getInstance((Context)this.ctx).createIndex(initAssistBalanceTemp, columns, true, false);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return initAssistBalanceTemp;
    }

    private void dealVoucherData() throws BOSException, EASBizException {
        StringBuffer sql;
        if (this.newCaa == null) {
            sql = new StringBuffer();
            if (this.acStart != null && this.period.getNumber() <= this.acStart.getNumber()) {
                sql.append("delete from t_gl_voucherassistrecord where fid in ( \n");
                sql.append("    select fvchassistrecordid from t_gl_acctcussent \n");
                sql.append("    where fcompanyid = ? and faccountid = ? and fisinit = 1 \n");
                sql.append(") \n");
                DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.company.getId().toString(), this.account.getId().toString()});
            }
            sql.setLength(0);
            sql.append("update t_gl_voucherentry set fcaa = null \n");
            sql.append("where fcompanyid = ? and faccountid = ? \n");
            sql.append("and exists ( \n");
            sql.append("    select 1 from t_bd_period p \n");
            sql.append("    where p.fid = t_gl_voucherentry.fperiodid and p.fnumber >= ? \n");
            sql.append(") \n");
            DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.company.getId().toString(), this.account.getId().toString(), this.period.getNumber()});
            sql.setLength(0);
            if (this.account.isHasUserProperty()) {
                sql.append("update t_gl_voucherassistrecord set fassgrpid = null \n");
                sql.append("where fcompanyid = ? and faccountid = ? and fbillid is not null \n");
                if (this.period.getNumber() != this.start.getNumber()) {
                    sql.append("and exists ( \n");
                    sql.append("    select 1 from t_bd_period p \n");
                    sql.append("    where p.fid = t_gl_voucherassistrecord.fperiodid and p.fnumber >= ? \n");
                    sql.append(") \n");
                }
            } else {
                sql.append("delete from t_gl_voucherassistrecord \n");
                sql.append("where fcompanyid = ? and faccountid = ? and fbillid is not null \n");
                if (this.period.getNumber() != this.start.getNumber()) {
                    sql.append("and exists ( \n");
                    sql.append("    select 1 from t_bd_period p \n");
                    sql.append("    where p.fid = t_gl_voucherassistrecord.fperiodid and p.fnumber >= ? \n");
                    sql.append(") \n");
                }
            }
            if (this.period.getNumber() != this.start.getNumber()) {
                DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.company.getId().toString(), this.account.getId().toString(), this.period.getNumber()});
            } else {
                DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.company.getId().toString(), this.account.getId().toString()});
            }
            if (this.account.isHasUserProperty()) {
                this.clearCFColumns(false);
            } else {
                this.clearCFColumns(true);
            }
        } else if (this.oldCaa == null) {
            this.insertVoucherData();
        } else {
            StringBuffer selectSql = new StringBuffer();
            StringBuffer updateSql = new StringBuffer();
            StringBuffer oboSql = new StringBuffer();
            Object[] selectParams = null;
            Object[] updateParams = null;
            if (this.acStart != null && this.period.getNumber() <= this.acStart.getNumber()) {
                selectSql.append("select r.FID FTargetID, r.fassgrpid FOldHgID \n");
                selectSql.append("from t_gl_acctcussent a \n");
                selectSql.append("join t_gl_voucherassistrecord r on r.fid = a.fvchassistrecordid \n");
                selectSql.append("where a.fcompanyid = ? and a.faccountid = ? and a.fisinit = 1 \n");
                selectParams = new String[]{this.company.getId().toString(), this.account.getId().toString()};
                updateSql.append("update t_gl_voucherassistrecord set (fassgrpid) = ( \n");
                updateSql.append("    select Fnewhgid from T_TMP_ToNewHg \n");
                updateSql.append("    where t_gl_voucherassistrecord.fid = T_TMP_ToNewHg.FTargetID \n");
                updateSql.append(") \n");
                updateParams = new String[]{};
                oboSql.append("update t_gl_voucherassistrecord set fassgrpid = ? \n");
                oboSql.append("where fid = ? \n");
                this.selectAndUpdate("varCus", selectSql.toString(), selectParams, updateSql.toString(), updateParams, oboSql.toString());
            }
            StringBuffer sql2 = new StringBuffer();
            sql2.append("update t_gl_voucherentry set fcaa = ? \n");
            sql2.append("where fcompanyid = ? and faccountid = ? \n");
            sql2.append("and exists ( \n");
            sql2.append("    select 1 from t_bd_period p \n");
            sql2.append("    where p.fid = t_gl_voucherentry.fperiodid and p.fnumber >= ? \n");
            sql2.append(") \n");
            DbUtil.execute((Context)this.ctx, (String)sql2.toString(), (Object[])new Object[]{this.newCaa, this.company.getId().toString(), this.account.getId().toString(), this.period.getNumber()});
            selectSql.setLength(0);
            selectSql.append("select r.FID FTargetID, fassgrpid FOldHgID \n");
            selectSql.append("from t_gl_voucherassistrecord r \n");
            selectSql.append("join t_bd_period p on p.fid = r.fperiodid \n");
            selectSql.append("where r.fcompanyid = ? and r.faccountid = ? \n");
            selectSql.append("and p.fnumber >= ? \n");
            selectParams = new Object[]{this.company.getId().toString(), this.account.getId().toString(), this.period.getNumber()};
            updateSql.setLength(0);
            updateSql.append("update t_gl_voucherassistrecord set (fassgrpid) = ( \n");
            updateSql.append("    select Fnewhgid from T_TMP_ToNewHg \n");
            updateSql.append("    where t_gl_voucherassistrecord.fid = T_TMP_ToNewHg.FTargetID \n");
            updateSql.append(") \n");
            updateParams = new String[]{};
            oboSql.setLength(0);
            oboSql.append("update t_gl_voucherassistrecord set fassgrpid = ? \n");
            oboSql.append("where fid = ? \n");
            this.selectAndUpdate("var", selectSql.toString(), selectParams, updateSql.toString(), updateParams, oboSql.toString());
        }
        sql = new StringBuffer();
        sql.append("update t_gl_voucher set flastupdateuserid = ?, flastupdatetime = ? \n");
        sql.append("where fcompanyid = ? \n");
        sql.append("and exists ( \n");
        sql.append("    select 1 from t_bd_period p \n");
        sql.append("    where p.fid = t_gl_voucher.fperiodid and p.fnumber >= ? \n");
        sql.append(") \n");
        sql.append("and exists ( \n");
        sql.append("    select 1 from t_gl_voucherentry ve \n");
        sql.append("    where ve.FBillID = t_gl_voucher.FID and ve.FAccountID = ? \n");
        sql.append(") \n");
        DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString(), GlUtils.getTime(), this.company.getId().toString(), this.period.getNumber(), this.account.getId().toString()});
    }

    private void insertVoucherData() throws BOSException, EASBizException {
        AssistantHGInfo hg = this.getNewAssistantHg(this.account, this.newCaa, null, null, this.defaultVal);
        StringBuffer sql = new StringBuffer();
        sql.append("update t_gl_voucherentry set fcaa = ? \n");
        sql.append("where fcompanyid = ? and faccountid = ? \n");
        sql.append("and exists ( \n");
        sql.append("    select 1 from t_bd_period p \n");
        sql.append("    where p.fid = t_gl_voucherentry.fperiodid and p.fnumber >= ? \n");
        sql.append(") \n");
        DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.newCaa, this.company.getId().toString(), this.account.getId().toString(), this.period.getNumber()});
        if (this.account.isHasUserProperty()) {
            sql.setLength(0);
            sql.append("update t_gl_voucherassistrecord set fassgrpid = ? \n");
            sql.append("where fcompanyid = ? and faccountid = ? and fbillid is not null \n");
            sql.append("and exists ( \n");
            sql.append("    select 1 from t_bd_period p \n");
            sql.append("    where p.fid = t_gl_voucherassistrecord.fperiodid and p.fnumber >= ? \n");
            sql.append(") \n");
            DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{hg.getId().toString(), this.company.getId().toString(), this.account.getId().toString(), this.period.getNumber()});
            sql.setLength(0);
            sql.append("update T_GL_CashflowRecord set FOPPASSGRPID = ?\n");
            sql.append("where foppaccountid =? \n");
            sql.append("and exists ( \n");
            sql.append("    select 1 FROM T_GL_VOUCHERASSISTRECORD r\n");
            sql.append("    inner join t_gl_voucher v on r.fbillid = v.fid\n");
            sql.append(" \tinner JOIN T_BD_Period p on p.FID = v.FPeriodID\n");
            sql.append("\tWHERE  p.FNumber >= ? and v.fcompanyid = ?\n");
            sql.append("\tand v.fid = T_GL_CashflowRecord.fvoucherid and r.FID = T_GL_CashflowRecord.FOPPVOUCHERASSISTRECORDID \n");
            sql.append(") \n");
            DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{hg.getId().toString(), this.account.getId().toString(), this.period.getNumber(), this.company.getId().toString()});
            sql.setLength(0);
            sql.append("update T_GL_CashflowSplitRecord set FOPPASSGRPID = ?\n");
            sql.append("where foppaccountid =? \n");
            sql.append("and exists ( \n");
            sql.append("    select 1 FROM T_GL_VOUCHERASSISTRECORD r\n");
            sql.append("    inner join t_gl_voucher v on r.fbillid = v.fid\n");
            sql.append(" \tinner JOIN T_BD_Period p on p.FID = v.FPeriodID\n");
            sql.append("\tWHERE  p.FNumber >= ? and v.fcompanyid = ?\n");
            sql.append("\tand v.fid = T_GL_CashflowSplitRecord.fvoucherid and r.FID = T_GL_CashflowSplitRecord.FOPPVOUCHERASSISTRECORDID \n");
            sql.append(") \n");
            DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{hg.getId().toString(), this.account.getId().toString(), this.period.getNumber(), this.company.getId().toString()});
        } else {
            sql.setLength(0);
            sql.append("insert into t_gl_voucherassistrecord ( \n");
            sql.append("    fid,fentryid,fassgrpid,fseq,fcompanyid,fperiodid,faccountid,fbizdate,foriginalamount,flocalamount, \n");
            sql.append("    freportingamount,fquantity,fstandardquantity,fmeasureunitid,fprice,fdescription,fbillid,fmactrlamount,fmaholdamount \n");
            sql.append(") \n");
            sql.append("select \n");
            sql.append("    newBosID('0FFFBCAA'),ve.fid, ?, 1, v.fcompanyid,v.fperiodid,ve.faccountid,v.fbizdate,ve.foriginalamount,ve.flocalamount, \n");
            sql.append("    ve.freportingamount,ve.fquantity,ve.fstandardquantity,ve.fmeasureunitid,ve.fprice,ve.fdescription,ve.fbillid,ve.fmactrlamount,ve.fmaholdamount \n");
            sql.append("from t_gl_voucherentry ve \n");
            sql.append("join t_gl_voucher v on v.fid = ve.fbillid \n");
            sql.append("join t_bd_period p on p.fid = ve.fperiodid \n");
            sql.append("where ve.fcompanyid = ? and ve.faccountid=? \n");
            sql.append("and p.fnumber >= ? \n");
            DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{hg.getId().toString(), this.company.getId().toString(), this.account.getId().toString(), this.period.getNumber()});
            String cashflowSql = this.getCashFlowUpdateSql("T_GL_CashflowRecord");
            DbUtil.execute((Context)this.ctx, (String)cashflowSql, (Object[])new Object[]{this.company.getId().toString(), this.account.getId().toString(), this.period.getNumber()});
            cashflowSql = this.getCashFlowUpdateSql("T_GL_CashflowSplitRecord");
            DbUtil.execute((Context)this.ctx, (String)cashflowSql, (Object[])new Object[]{this.company.getId().toString(), this.account.getId().toString(), this.period.getNumber()});
        }
    }

    private String getCashFlowUpdateSql(String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + tableName + " \n");
        sql.append("    SET (FOPPVOUCHERASSISTRECORDID, FOPPASSGRPID) = \n");
        sql.append("    (SELECT r.FID, r.FASSGRPID \n");
        sql.append("\tFROM T_GL_VOUCHERASSISTRECORD r \n");
        sql.append("\tJOIN T_GL_VoucherEntry ve on ve.FID = r.FENTRYID\n");
        sql.append(" \tJOIN T_GL_Voucher v  on v.FID = ve.FBillID\n");
        sql.append(" \tJOIN T_BD_Period p on p.FID = v.FPeriodID\n");
        sql.append("\tWHERE v.FCompanyID = ? and ve.FAccountID = ? and p.FNumber >= ?\n");
        sql.append("\tand v.FID = " + tableName + ".fvoucherid and ve.FID = " + tableName + ".FOPPOSINGACCOUNTENTRYID)\n");
        return sql.toString();
    }

    private void clearCFColumns(boolean bothColumn) throws BOSException {
        ArrayList<Object> param = new ArrayList<Object>();
        StringBuffer cfSql = new StringBuffer();
        if (bothColumn) {
            cfSql.append("update  T_GL_CashflowRecord set FOPPVOUCHERASSISTRECORDID=null,FOPPASSGRPID = null \n");
        } else {
            cfSql.append("update  T_GL_CashflowRecord set FOPPASSGRPID = null \n");
        }
        cfSql.append("where foppaccountid = ? \n");
        param.add(this.account.getId().toString());
        if (this.period.getNumber() != this.start.getNumber()) {
            cfSql.append("and exists ( \n");
            cfSql.append("    select 1 from t_gl_voucher v \n");
            cfSql.append("    join t_bd_period p on p.FID = v.FPeriodID \n");
            cfSql.append("    where v.FCompanyID = ? and p.fnumber >= ? \n");
            cfSql.append("    and v.FID = T_GL_CashflowRecord.FVoucherID \n");
            cfSql.append(") \n");
            param.add(this.company.getId().toString());
            param.add(this.period.getNumber());
        }
        DbUtil.execute((Context)this.ctx, (String)cfSql.toString(), (Object[])param.toArray());
        StringBuffer cfsSql = new StringBuffer();
        if (bothColumn) {
            cfsSql.append("update  T_GL_CashflowSplitRecord set FOPPVOUCHERASSISTRECORDID=null,FOPPASSGRPID = null \n");
        } else {
            cfsSql.append("update  T_GL_CashflowSplitRecord set FOPPASSGRPID = null \n");
        }
        cfsSql.append("where foppaccountid = ? \n");
        if (this.period.getNumber() != this.start.getNumber()) {
            cfsSql.append("and exists ( \n");
            cfsSql.append("    select 1 from t_gl_voucher v \n");
            cfsSql.append("    join t_bd_period p on p.FID = v.FPeriodID \n");
            cfsSql.append("    where v.FCompanyID = ? and p.fnumber >= ? \n");
            cfsSql.append("    and v.FID = T_GL_CashflowSplitRecord.FVoucherID \n");
            cfsSql.append(") \n");
        }
        DbUtil.execute((Context)this.ctx, (String)cfsSql.toString(), (Object[])param.toArray());
    }

    private void dealCussentData() throws BOSException, EASBizException {
        if (this.newCaa == null) {
            StringBuffer sql;
            if (this.acStart != null && this.period.getNumber() <= this.acStart.getNumber()) {
                sql = new StringBuffer();
                sql.append("delete from t_gl_acctcussent \n");
                sql.append("where fcompanyid = ? and faccountid = ? and fisinit = 1 \n");
                DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.company.getId().toString(), this.account.getId().toString()});
            }
            sql = new StringBuffer();
            sql.append("delete from t_gl_acctcussent \n");
            sql.append("where fcompanyid = ? and faccountid = ? and fisinit = 0 \n");
            Object[] params = new Object[]{this.company.getId().toString(), this.account.getId().toString()};
            if (this.period.getNumber() != this.start.getNumber()) {
                sql.append("and exists ( \n");
                sql.append("    select 1 from t_bd_period p \n");
                sql.append("    where p.fid = t_gl_acctcussent.fperiodid and p.fnumber >= ? \n");
                sql.append(") \n");
                params = new Object[]{this.company.getId().toString(), this.account.getId().toString(), this.period.getNumber()};
            }
            DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])params);
        } else if (this.oldCaa != null) {
            StringBuffer oboSql;
            Object[] updateParams;
            StringBuffer updateSql;
            Object[] selectParams;
            StringBuffer selectSql;
            if (this.acStart != null && this.period.getNumber() <= this.acStart.getNumber()) {
                selectSql = new StringBuffer();
                selectSql.append("select a.FID FTargetID, a.fassgrpid FOldHgID \n");
                selectSql.append("from t_gl_acctcussent a \n");
                selectSql.append("where a.fcompanyid = ? and a.faccountid = ? and fisinit = 1 \n");
                selectParams = new Object[]{this.company.getId().toString(), this.account.getId().toString()};
                updateSql = new StringBuffer();
                updateSql.append("update t_gl_acctcussent set (fassgrpid) = ( \n");
                updateSql.append("    select Fnewhgid from T_TMP_ToNewHg \n");
                updateSql.append("    where t_gl_acctcussent.FID = T_TMP_ToNewHg.FTargetID \n");
                updateSql.append(") \n");
                updateParams = new String[]{};
                oboSql = new StringBuffer();
                oboSql.append("update t_gl_acctcussent set fassgrpid = ? \n");
                oboSql.append("where fid = ? \n");
                this.selectAndUpdate("cussent", selectSql.toString(), selectParams, updateSql.toString(), updateParams, oboSql.toString());
            }
            selectSql = new StringBuffer();
            selectSql.append("select a.FID FTargetID, a.fassgrpid FOldHgID \n");
            selectSql.append("from t_gl_acctcussent a \n");
            if (this.period.getNumber() != this.start.getNumber()) {
                selectSql.append("join t_bd_period p on p.FID = a.FPeriodID \n");
            }
            selectSql.append("where a.fcompanyid = ? and a.faccountid = ? and fisinit = 0 \n");
            if (this.period.getNumber() != this.start.getNumber()) {
                selectSql.append("    and p.fnumber >= ? \n");
            }
            selectParams = new Object[]{this.company.getId().toString(), this.account.getId().toString()};
            if (this.period.getNumber() != this.start.getNumber()) {
                selectParams = new Object[]{this.company.getId().toString(), this.account.getId().toString(), this.period.getNumber()};
            }
            updateSql = new StringBuffer();
            updateSql.append("update t_gl_acctcussent set (fassgrpid) = ( \n");
            updateSql.append("    select Fnewhgid from T_TMP_ToNewHg \n");
            updateSql.append("    where t_gl_acctcussent.FID = T_TMP_ToNewHg.FTargetID \n");
            updateSql.append(") \n");
            updateParams = new String[]{};
            oboSql = new StringBuffer();
            oboSql.append("update t_gl_acctcussent set fassgrpid = ? \n");
            oboSql.append("where fid = ? \n");
            this.selectAndUpdate("cussent", selectSql.toString(), selectParams, updateSql.toString(), updateParams, oboSql.toString());
        }
    }

    private void dealCusHisData() throws BOSException, EASBizException {
        if (this.newCaa != null && this.oldCaa != null) {
            Object[] selectParams;
            StringBuffer selectSql = new StringBuffer();
            if (this.period.getNumber() == this.start.getNumber()) {
                selectSql.append("select FID FTargetID, fassgrpid FOldHgID \n");
                selectSql.append("from T_GL_AcctCussentHistory \n");
                selectSql.append("where FCompanyID = ? and FAccountID = ? \n");
                selectParams = new Object[]{this.company.getId().toString(), this.account.getId().toString()};
            } else {
                selectSql.append("select a.FID FTargetID, a.fassgrpid FOldHgID \n");
                selectSql.append("from T_GL_AcctCussentHistory a \n");
                selectSql.append("join T_GL_Voucher v on v.fid = a.FVeriVchID \n");
                selectSql.append("join T_BD_Period p on p.fid = v.FPeriodID \n");
                selectSql.append("where a.FCompanyID = ? and a.FAccountID = ? \n");
                selectSql.append("    and p.fnumber >= ? \n");
                selectParams = new Object[]{this.company.getId().toString(), this.account.getId().toString(), this.period.getNumber()};
            }
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update T_GL_AcctCussentHistory set (fassgrpid) = ( \n");
            updateSql.append("    select Fnewhgid from T_TMP_ToNewHg \n");
            updateSql.append("    where T_GL_AcctCussentHistory.FID = T_TMP_ToNewHg.FTargetID \n");
            updateSql.append(") \n");
            Object[] updateParams = new String[]{};
            StringBuffer oboSql = new StringBuffer();
            oboSql.append("update T_GL_AcctCussentHistory set fassgrpid = ? \n");
            oboSql.append("where fid = ? \n");
            this.selectAndUpdate("cusHis", selectSql.toString(), selectParams, updateSql.toString(), updateParams, oboSql.toString());
        }
    }

    private void dealCusVerData() throws BOSException, EASBizException {
        if (this.newCaa != null && this.oldCaa != null) {
            Object[] selectParams;
            StringBuffer selectSql = new StringBuffer();
            if (this.period.getNumber() == this.start.getNumber()) {
                selectSql.append("select FID FTargetID, fassgrpid FOldHgID \n");
                selectSql.append("from T_GL_ACCTVERIFY \n");
                selectSql.append("where FCompanyID = ? and FAccountID = ? \n");
                selectParams = new Object[]{this.company.getId().toString(), this.account.getId().toString()};
            } else {
                selectSql.append("select a.FID FTargetID, a.fassgrpid FOldHgID \n");
                selectSql.append("from T_GL_ACCTVERIFY a \n");
                selectSql.append("join T_BD_Period p on p.fid = a.FPeriodID \n");
                selectSql.append("where a.FCompanyID = ? and a.FAccountID = ? \n");
                selectSql.append("    and p.fnumber >= ? \n");
                selectParams = new Object[]{this.company.getId().toString(), this.account.getId().toString(), this.period.getNumber()};
            }
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update T_GL_ACCTVERIFY set (fassgrpid) = ( \n");
            updateSql.append("    select Fnewhgid from T_TMP_ToNewHg \n");
            updateSql.append("    where T_GL_ACCTVERIFY.FID = T_TMP_ToNewHg.FTargetID \n");
            updateSql.append(") \n");
            Object[] updateParams = new String[]{};
            StringBuffer oboSql = new StringBuffer();
            oboSql.append("update T_GL_ACCTVERIFY set fassgrpid = ? \n");
            oboSql.append("where fid = ? \n");
            this.selectAndUpdate("cusVer", selectSql.toString(), selectParams, updateSql.toString(), updateParams, oboSql.toString());
        }
    }

    private void dealAssBalData() throws BOSException, EASBizException {
        String[] companyIds = new String[]{this.company.getId().toString()};
        GLBalanceFacadeControllerBean b = new GLBalanceFacadeControllerBean();
        b.updateVoucherBalance(this.ctx, companyIds);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("companyId", this.company.getId().toString());
        PeriodInfo periodfrom = this.period;
        params.put("periodfrom", periodfrom);
        PeriodInfo periodto = periodfrom;
        int maxPeriod = periodto.getNumber();
        try {
            int i;
            StringBuffer sql = new StringBuffer();
            sql.append("select max(p.FNumber) FPeriod \n");
            sql.append("from t_gl_voucherentry ve \n");
            sql.append("join t_bd_period p on p.fid = ve.fperiodid \n");
            sql.append("where ve.fcompanyid = ? and ve.faccountid = ? \n");
            sql.append("    and p.fnumber > ? \n");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.company.getId().toString(), this.account.getId().toString(), maxPeriod});
            if (rs.next() && (i = rs.getInt("FPeriod")) > maxPeriod) {
                maxPeriod = i;
            }
            sql.setLength(0);
            sql.append("select max(b.FPeriod) FPeriod \n");
            sql.append("from t_gl_accountbalance_1f b \n");
            sql.append("where b.forgunitid = ? and b.faccountid = ? \n");
            sql.append("    and FPeriod > ? \n");
            rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.company.getId().toString(), this.account.getId().toString(), maxPeriod});
            if (rs.next() && (i = rs.getInt("FPeriod")) > maxPeriod) {
                maxPeriod = i;
            }
            if (maxPeriod > periodto.getNumber()) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("periodYear");
                selector.add("periodNumber");
                view.setSelector(selector);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)maxPeriod));
                filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.start.getPeriodType().getId().toString()));
                view.setFilter(filter);
                PeriodCollection coll = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodCollection(view);
                if (coll.size() > 0) {
                    periodto = coll.get(0);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        params.put("periodto", periodto);
        HashSet<String> accountNumbers = new HashSet<String>();
        accountNumbers.add(this.account.getNumber());
        params.put("accountNumbers", accountNumbers);
        params.put("repairAccount", true);
        params.put("repairAssist", true);
        params.put("repairMeasure", true);
        params.put("onlyClean", false);
        GLBalanceRepairFacadeFactory.getLocalInstance(this.ctx).repairCompany(params);
    }

    /*
     * Loose catch block
     */
    private void selectAndUpdate(String type, String selectSql, Object[] selectParams, String updateSql, Object[] updateParams, String oboSql) throws BOSException, EASBizException {
        block46: {
            String T_TMP_ToNewHg;
            PreparedStatement stmt;
            Connection conn;
            block45: {
                String oldHgId;
                AssistantHGInfo newHgInfo;
                HashMap repeats;
                boolean isRepeat;
                HashMap<String, AssistantHGInfo> oldToNewHgs;
                HashMap<String, String> targetIdToOldHgIds;
                boolean isAssInit;
                PreparedStatement stmtCFS;
                PreparedStatement stmtCF;
                block44: {
                    Map<String, AssistantHGInfo> oldHgs;
                    HashSet<String> oldhgIds;
                    block43: {
                        conn = null;
                        stmt = null;
                        stmtCF = null;
                        stmtCFS = null;
                        T_TMP_ToNewHg = null;
                        isAssInit = type.equals("assInit");
                        conn = EJBFactory.getConnection((Context)this.ctx);
                        oldhgIds = new HashSet<String>();
                        targetIdToOldHgIds = new HashMap<String, String>();
                        stmt = conn.prepareStatement(selectSql);
                        for (int i = 0; i < selectParams.length; ++i) {
                            stmt.setObject(i + 1, selectParams[i]);
                        }
                        ResultSet rowSet = stmt.executeQuery();
                        while (rowSet.next()) {
                            String oldHgId22 = rowSet.getString("FOldHgID");
                            if (StringUtils.isEmpty((String)oldHgId22)) continue;
                            oldhgIds.add(oldHgId22);
                            if (isAssInit) continue;
                            String targetId = rowSet.getString("FTargetID");
                            targetIdToOldHgIds.put(targetId, oldHgId22);
                        }
                        SQLUtils.cleanup((ResultSet)rowSet, (Statement)stmt);
                        oldHgs = this.getAssistantHgs(this.oldCaa, oldhgIds);
                        if (oldHgs.size() > 0) break block43;
                        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
                        try {
                            if (T_TMP_ToNewHg != null) {
                                TempTablePool.getInstance((Context)this.ctx).releaseTable(T_TMP_ToNewHg);
                            }
                        }
                        catch (Exception targetId) {
                            // empty catch block
                        }
                        return;
                    }
                    oldToNewHgs = new HashMap<String, AssistantHGInfo>();
                    isRepeat = false;
                    repeats = new HashMap();
                    for (String oldHgId3 : oldhgIds) {
                        AssistantHGInfo oldHgInfo = oldHgs.get(oldHgId3);
                        AssistantHGInfo newHgInfo2 = this.getNewAssistantHg(this.account, this.newCaa, this.oldCaa, oldHgInfo, this.defaultVal);
                        if (newHgInfo2 == null) continue;
                        oldToNewHgs.put(oldHgId3, newHgInfo2);
                        if (!isAssInit) continue;
                        String newHgId = newHgInfo2.getId().toString();
                        if (repeats.containsKey(newHgId)) {
                            isRepeat = true;
                            ((Set)repeats.get(newHgId)).add(oldHgId3);
                            continue;
                        }
                        HashSet<String> set = new HashSet<String>();
                        set.add(oldHgId3);
                        repeats.put(newHgId, set);
                    }
                    if (oldToNewHgs.size() > 0) break block44;
                    SQLUtils.cleanup((Statement)stmt, (Connection)conn);
                    try {
                        if (T_TMP_ToNewHg != null) {
                            TempTablePool.getInstance((Context)this.ctx).releaseTable(T_TMP_ToNewHg);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                String oboCFSql = null;
                String oboCFSSql = null;
                if ("var".equals(type)) {
                    oboCFSql = "update   T_GL_CashflowRecord  set FOPPASSGRPID = ? where FOPPVOUCHERASSISTRECORDID = ? ";
                    oboCFSSql = "update   T_GL_CashflowSplitRecord  set FOPPASSGRPID = ? where FOPPVOUCHERASSISTRECORDID = ? ";
                    stmtCF = conn.prepareStatement(oboCFSql);
                    stmtCFS = conn.prepareStatement(oboCFSSql);
                }
                if (this.oneByOne) {
                    if (isAssInit && isRepeat) {
                        T_TMP_ToNewHg = this.createToNewHgTmpTable();
                        stmt = conn.prepareStatement("insert into " + T_TMP_ToNewHg + " (FNewhgid, FTargetID, FRepeat) values(?, ?, ?)");
                        int index2 = 0;
                        for (String oldHgId4 : oldToNewHgs.keySet()) {
                            newHgInfo = (AssistantHGInfo)oldToNewHgs.get(oldHgId4);
                            if (newHgInfo == null) continue;
                            String newHgId = newHgInfo.getId().toString();
                            Set set = (Set)repeats.get(newHgId);
                            stmt.setString(1, newHgId);
                            stmt.setString(2, oldHgId4);
                            stmt.setInt(3, set != null && set.size() > 1 ? 1 : 0);
                            stmt.addBatch();
                            if (++index2 % 500 != 0) continue;
                            stmt.executeBatch();
                            stmt.clearBatch();
                        }
                        stmt.executeBatch();
                        SQLUtils.cleanup((Statement)stmt);
                        this.unionAssInitData(T_TMP_ToNewHg);
                    }
                    stmt = conn.prepareStatement(oboSql);
                    int index3 = 0;
                    if (isAssInit) {
                        for (String oldHgId4 : oldToNewHgs.keySet()) {
                            newHgInfo = (AssistantHGInfo)oldToNewHgs.get(oldHgId4);
                            if (newHgInfo == null) continue;
                            stmt.setString(1, newHgInfo.getId().toString());
                            stmt.setString(2, oldHgId4);
                            stmt.addBatch();
                            if (++index3 % 500 != 0) continue;
                            stmt.executeBatch();
                            stmt.clearBatch();
                        }
                        stmt.executeBatch();
                        SQLUtils.cleanup((Statement)stmt);
                    } else {
                        for (String targetId : targetIdToOldHgIds.keySet()) {
                            oldHgId = (String)targetIdToOldHgIds.get(targetId);
                            AssistantHGInfo newHgInfo3 = (AssistantHGInfo)oldToNewHgs.get(oldHgId);
                            if (newHgInfo3 == null) continue;
                            String newHgId = newHgInfo3.getId().toString();
                            stmt.setString(1, newHgId);
                            stmt.setString(2, targetId);
                            stmt.addBatch();
                            if ("var".equals(type) && stmtCF != null && stmtCFS != null) {
                                stmtCF.setString(1, newHgId);
                                stmtCF.setString(2, targetId);
                                stmtCF.addBatch();
                                stmtCFS.setString(1, newHgId);
                                stmtCFS.setString(2, targetId);
                                stmtCFS.addBatch();
                            }
                            if (++index3 % 500 == 0) {
                                stmt.executeBatch();
                                stmt.clearBatch();
                            }
                            if (!"var".equals(type) || stmtCF == null || stmtCFS == null) continue;
                            if (index3 % 500 == 0) {
                                stmtCF.executeBatch();
                                stmtCF.clearBatch();
                            }
                            if (index3 % 500 != 0) continue;
                            stmtCFS.executeBatch();
                            stmtCFS.clearBatch();
                        }
                        stmt.executeBatch();
                        SQLUtils.cleanup((Statement)stmt);
                        if ("var".equals(type) && stmtCF != null && stmtCFS != null) {
                            stmtCF.executeBatch();
                            stmtCFS.executeBatch();
                            SQLUtils.cleanup((Statement)stmtCF);
                            SQLUtils.cleanup((Statement)stmtCFS);
                        }
                    }
                    break block45;
                }
                T_TMP_ToNewHg = this.createToNewHgTmpTable();
                stmt = conn.prepareStatement("insert into " + T_TMP_ToNewHg + " (FNewhgid, FTargetID, FRepeat) values(?, ?, ?)");
                int index = 0;
                if (isAssInit) {
                    for (String oldHgId4 : oldToNewHgs.keySet()) {
                        newHgInfo = (AssistantHGInfo)oldToNewHgs.get(oldHgId4);
                        if (newHgInfo == null) continue;
                        String newHgId = newHgInfo.getId().toString();
                        Set set = (Set)repeats.get(newHgId);
                        stmt.setString(1, newHgId);
                        stmt.setString(2, oldHgId4);
                        stmt.setInt(3, set != null && set.size() > 1 ? 1 : 0);
                        stmt.addBatch();
                        if (++index % 500 != 0) continue;
                        stmt.executeBatch();
                        stmt.clearBatch();
                    }
                    stmt.executeBatch();
                    SQLUtils.cleanup((Statement)stmt);
                } else {
                    for (String targetId : targetIdToOldHgIds.keySet()) {
                        oldHgId = (String)targetIdToOldHgIds.get(targetId);
                        AssistantHGInfo newHgInfo4 = (AssistantHGInfo)oldToNewHgs.get(oldHgId);
                        if (newHgInfo4 == null) continue;
                        String newHgId = newHgInfo4.getId().toString();
                        stmt.setString(1, newHgId);
                        stmt.setString(2, targetId);
                        stmt.setInt(3, 0);
                        stmt.addBatch();
                        if ("var".equals(type) && stmtCF != null && stmtCFS != null) {
                            stmtCF.setString(1, newHgId);
                            stmtCF.setString(2, targetId);
                            stmtCF.addBatch();
                            stmtCFS.setString(1, newHgId);
                            stmtCFS.setString(2, targetId);
                            stmtCFS.addBatch();
                        }
                        if (++index % 500 == 0) {
                            stmt.executeBatch();
                            stmt.clearBatch();
                        }
                        if (!"var".equals(type) || stmtCF == null || stmtCFS == null) continue;
                        if (index % 500 == 0) {
                            stmtCF.executeBatch();
                            stmtCF.clearBatch();
                        }
                        if (index % 500 != 0) continue;
                        stmtCFS.executeBatch();
                        stmtCFS.clearBatch();
                    }
                    stmt.executeBatch();
                    SQLUtils.cleanup((Statement)stmt);
                    if ("var".equals(type) && stmtCF != null && stmtCFS != null) {
                        stmtCF.executeBatch();
                        stmtCFS.executeBatch();
                        SQLUtils.cleanup((Statement)stmtCF);
                        SQLUtils.cleanup((Statement)stmtCFS);
                    }
                }
                if (isAssInit && isRepeat) {
                    this.unionAssInitData(T_TMP_ToNewHg);
                }
                updateSql = updateSql.replaceAll("T_TMP_ToNewHg", T_TMP_ToNewHg);
                DbUtil.execute((Context)this.ctx, (String)updateSql, (Object[])updateParams);
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            try {
                if (T_TMP_ToNewHg != null) {
                    TempTablePool.getInstance((Context)this.ctx).releaseTable(T_TMP_ToNewHg);
                }
                break block46;
            }
            catch (Exception oldhgIds) {}
            break block46;
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)conn);
                    try {
                        if (T_TMP_ToNewHg != null) {
                            TempTablePool.getInstance((Context)this.ctx).releaseTable(T_TMP_ToNewHg);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    private String createToNewHgTmpTable() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_TMP_ToNewHg ( \n");
        sql.append("    FTargetID varchar(44), FNewHgID varchar(44), FRepeat int DEFAULT 0 \n");
        sql.append(") \n");
        try {
            String T_TMP_ToNewHg = TempTablePool.getInstance((Context)this.ctx).createTempTable(sql.toString());
            String columns = "FTargetID";
            TempTablePool.getInstance((Context)this.ctx).createIndex(T_TMP_ToNewHg, columns, true, false);
            return T_TMP_ToNewHg;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public AssistantHGInfo getNewAssistantHg(AccountViewInfo account, String newCaaId, String oldCaaId, AssistantHGInfo oldHgInfo, Map<AsstActTypeInfo, Object> defaultVal) throws EASBizException, BOSException {
        String key = newCaaId;
        HashMap<String, Object> defs = new HashMap<String, Object>();
        for (AsstActTypeInfo aat : defaultVal.keySet()) {
            Object val = defaultVal.get(aat);
            if (val == null) continue;
            defs.put(aat.getAsstHGAttribute(), val);
        }
        AsstActTypeCollection asstActTypes = this.getAsstActTypes(newCaaId);
        AssistantHGInfo hgInfo = new AssistantHGInfo();
        for (int i = 0; i < asstActTypes.size(); ++i) {
            Object temp;
            AccountBankInfo ab;
            String asstHGAttribute = asstActTypes.get(i).getAsstHGAttribute();
            Object value = defs.get(asstHGAttribute);
            if (this.isNeedFixBank && value instanceof BankInfo && oldHgInfo != null && (ab = oldHgInfo.getBankAccount()) != null) {
                value = this.getBank(ab.getId().toString());
            }
            if (oldHgInfo != null && (temp = oldHgInfo.get(asstHGAttribute)) != null) {
                value = temp;
            }
            if (value == null) continue;
            hgInfo.put(asstHGAttribute, value);
            key = value instanceof CoreBaseInfo ? key + "_" + ((CoreBaseInfo)value).getId().toString() : key + "_" + value.hashCode();
        }
        if (this.atToHgs.containsKey(key)) {
            return this.atToHgs.get(key);
        }
        hgInfo.setId(null);
        hgInfo.setAsstAccount(this.queryCaa(newCaaId));
        hgInfo.put("aatok", (Object)Boolean.TRUE);
        hgInfo = AssistantHGFactory.getLocalInstance((Context)this.ctx).getAssistantHG(hgInfo, newCaaId, asstActTypes);
        this.atToHgs.put(key, hgInfo);
        return hgInfo;
    }

    private BankInfo getBank(String accountBankId) throws BOSException {
        if (this.banks.containsKey(accountBankId)) {
            return this.banks.get(accountBankId);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("bank.id");
        selector.add("bank.number");
        selector.add("bank.name");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)accountBankId));
        AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankCollection(view);
        BankInfo info = null;
        if (coll.size() > 0) {
            info = coll.get(0).getBank();
        }
        this.banks.put(accountBankId, info);
        return info;
    }

    private AsstActTypeCollection getAsstActTypes(String caaId) throws BOSException {
        if (this.asstActTypess.containsKey(caaId)) {
            return this.asstActTypess.get(caaId);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("asstActType.groupTableName"));
        sic.add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.id"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)caaId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        AsstActGroupDetailCollection asstcol = AsstActGroupDetailFactory.getLocalInstance((Context)this.ctx).getAsstActGroupDetailCollection(view);
        AsstActTypeCollection asstActTypes = new AsstActTypeCollection();
        for (int i = 0; i < asstcol.size(); ++i) {
            asstActTypes.add(asstcol.get(i).getAsstActType());
        }
        this.asstActTypess.put(caaId, asstActTypes);
        return asstActTypes;
    }

    private AsstAccountInfo queryCaa(String caa) throws BOSException, EASBizException {
        if (this.caas.containsKey(caa)) {
            return this.caas.get(caa);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("measureUnit.id");
        selector.add("measureUnit.coefficient");
        selector.add("measureUnit.qtyPrecision");
        selector.add("measureUnitGroup.id");
        AsstAccountInfo asstAccount = AsstAccountFactory.getLocalInstance((Context)this.ctx).getAsstAccountInfo((IObjectPK)new ObjectUuidPK(caa), selector);
        this.caas.put(caa, asstAccount);
        return asstAccount;
    }

    private Map<String, AssistantHGInfo> getAssistantHgs(String caa, Set<String> hgIds) throws BOSException {
        HashMap<String, AssistantHGInfo> hgs = new HashMap<String, AssistantHGInfo>();
        HashSet<String> newIds = new HashSet<String>();
        for (String id : hgIds) {
            if (this.idToHGs.containsKey(id)) {
                hgs.put(id, this.idToHGs.get(id));
                continue;
            }
            newIds.add(id);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = view.getSelector();
        selectors.add(new SelectorItemInfo("asstAccount.id"));
        AsstActTypeCollection asstActTypeList = this.getAsstActTypes(caa);
        if (asstActTypeList != null && asstActTypeList.size() > 0) {
            for (int i = 0; i < asstActTypeList.size(); ++i) {
                AsstActTypeInfo asstActType = asstActTypeList.get(i);
                String attr = asstActType.getAsstHGAttribute();
                selectors.add(attr + ".id");
                selectors.add(attr + ".name");
                if ("provider".equals(attr) || "customer".equals(attr)) {
                    selectors.add(attr + ".browseGroup.displayName");
                } else if ("material".equals(asstActType.getAsstHGAttribute())) {
                    selectors.add(attr + ".materialGroup.displayName");
                } else if (asstActType.isIsMultilevel()) {
                    selectors.add(attr + ".displayName");
                }
                selectors.add(attr + ".number");
            }
        }
        IAssistantHG assistanthg = AssistantHGFactory.getLocalInstance((Context)this.ctx);
        List sets = GlUtils.split(newIds, 300);
        for (Set set : sets) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            view.setFilter(filter);
            AssistantHGCollection coll = assistanthg.getAssistantHGCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                AssistantHGInfo hg = coll.get(i);
                hgs.put(hg.getId().toString(), hg);
            }
        }
        for (String id : newIds) {
            this.idToHGs.put(id, (AssistantHGInfo)hgs.get(id));
        }
        return hgs;
    }

    public String requestMutex() throws BOSException, EASBizException {
        String companyId = this.company.getId().toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        MutexParameter mp = GLMutexUtils.buildModifyBalanceParameter(this.ctx, companyId, userId, "GL_AsstAccountChange", this.account.getNumber());
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)this.ctx);
        MutexParameter current = mutex.requestMutex3(mp);
        if (current == null) {
            this.requestId = mp.getRequestId();
            return null;
        }
        return GLMutexUtils.getMutexMessage(this.ctx, current, mp);
    }

    public void releaseMutex() {
        if (this.requestId == null) {
            return;
        }
        try {
            MutexServiceControlFactory.getLocalInstance((Context)this.ctx).releaseMutex(this.requestId);
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
        }
    }
}

