/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IVoucherType;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeCollection;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeEntryInfo;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeFactory;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFactory;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLAsstAccountChangeTransfer {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLAsstAccountChangeTransfer");
    private static final String RESOURCE = "com.kingdee.eas.fi.gl.GLAsstAccountChangeResource";
    private Map<String, AsstAccountInfo> caas = new HashMap<String, AsstAccountInfo>();
    private Map<String, AsstActTypeCollection> asstActTypess = new HashMap<String, AsstActTypeCollection>();
    private Map<String, MeasureUnitInfo> defaultUnits = new HashMap<String, MeasureUnitInfo>();
    private Map<String, MeasureUnitInfo> measureUnits = new HashMap<String, MeasureUnitInfo>();
    private Map<String, Map<AsstActTypeInfo, Object>> defaultVals = new HashMap<String, Map<AsstActTypeInfo, Object>>();
    private Map<String, CurrencyInfo> currencys = new HashMap<String, CurrencyInfo>();
    private static final BigDecimal zero = new BigDecimal(0);
    private static final BigDecimal one = new BigDecimal(1);
    private static final BigDecimal negativeOne = new BigDecimal("-1");
    private Context ctx;
    private CompanyOrgUnitInfo company;
    private String companyId;
    private PeriodInfo period;
    private int allowCussent = -1;
    private boolean isNeedFixBank = false;
    private Map<String, BankInfo> banks = new HashMap<String, BankInfo>();

    private GLAsstAccountChangeTransfer(Context ctx, String companyId, String periodId) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.companyId = companyId;
        this.company = this.queryCompany(companyId);
        this.period = periodId != null ? PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId)) : GlUtils.getCurrentPeriod(ctx, companyId);
    }

    public static Map<String, Object> process(Context ctx, String companyId, String periodId) throws EASBizException, BOSException {
        try {
            GLAsstAccountChangeTransfer transfer = new GLAsstAccountChangeTransfer(ctx, companyId, periodId);
            return transfer.buildCompany();
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static Map process(Context ctx, AsstAccountChangeInfo change, Map defaultVal) throws EASBizException, BOSException {
        try {
            String companyId = change.getAccount().getCompanyID().getId().toString();
            String periodId = change.getPeriod().getId().toString();
            GLAsstAccountChangeTransfer transfer = new GLAsstAccountChangeTransfer(ctx, companyId, periodId);
            return transfer.buildVoucher(change, defaultVal);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private Map<String, Object> buildCompany() throws EASBizException, BOSException, SQLException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("account.id");
        selector.add("period.id");
        selector.add("before.id");
        selector.add("after.id");
        selector.add("entries.id");
        selector.add("entries.asstActType.id");
        selector.add("entries.asstAct");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("account.companyID.id", (Object)this.companyId));
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)this.period.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("account.isLeaf", (Object)1));
        view.setFilter(filter);
        AsstAccountChangeCollection changes = AsstAccountChangeFactory.getLocalInstance((Context)this.ctx).getAsstAccountChangeCollection(view);
        for (int i = 0; i < changes.size(); ++i) {
            Map<String, Object> subResult = this.buildVoucher(changes.get(i), null);
            result.putAll(subResult);
        }
        return result;
    }

    private Map<String, Object> buildVoucher(AsstAccountChangeInfo change, Map<AsstActTypeInfo, Object> defaultVal) throws BOSException, EASBizException, SQLException {
        IObjectPK vPK;
        CurrencyInfo currencyInfo;
        String accountId = change.getAccount().getId().toString();
        HashMap<String, Object> result = new HashMap<String, Object>();
        String oldCaaId = null;
        String newCaaId = null;
        if (change.getBefore() != null) {
            oldCaaId = change.getBefore().getId().toString();
        }
        if (change.getAfter() != null) {
            newCaaId = change.getAfter().getId().toString();
        }
        HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
        hmParamIn.put("G001", null);
        hmParamIn.put("G010", null);
        HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamHashMap(hmParamIn);
        Boolean isUseRpt = false;
        Boolean isQtyAsst = null;
        try {
            isUseRpt = Boolean.valueOf(hmAllParam.get("G001").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"G001"});
        }
        try {
            isQtyAsst = Boolean.valueOf(hmAllParam.get("G010").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"G010"});
        }
        VoucherInfo voucher = new VoucherInfo();
        VoucherEntryCollection entries = voucher.getEntries();
        AccountViewInfo account = this.queryAccount(accountId);
        AccountViewInfo oldAccount = (AccountViewInfo)account.clone();
        AsstAccountInfo oldAsstacc = null;
        if (oldCaaId != null) {
            oldAsstacc = this.queryCaa(oldCaaId);
        }
        oldAccount.setCAA(oldAsstacc);
        AccountViewInfo newAccount = (AccountViewInfo)account.clone();
        AsstAccountInfo newAsstacc = null;
        if (newCaaId != null) {
            newAsstacc = this.queryCaa(newCaaId);
        }
        newAccount.setCAA(newAsstacc);
        MeasureUnitInfo entryUnit = this.getEntryUnit(newAccount);
        if (defaultVal == null) {
            defaultVal = this.getDefaultVal(account, change);
        }
        this.isNeedFixBank = false;
        if (oldCaaId != null && newCaaId != null) {
            AsstActTypeInfo oldBankType = null;
            AsstActTypeInfo oldAccountBankType = null;
            AsstActTypeCollection oldTypes = this.getAsstActTypes(oldCaaId);
            for (AsstActTypeInfo type : oldTypes) {
                if ("region".equalsIgnoreCase(type.getAsstHGAttribute())) {
                    oldBankType = type;
                    continue;
                }
                if (!"bankAccount".equalsIgnoreCase(type.getAsstHGAttribute())) continue;
                oldAccountBankType = type;
            }
            AsstActTypeInfo newBankType = null;
            AsstActTypeInfo newBankAccount = null;
            AsstActTypeCollection newTypes = this.getAsstActTypes(newCaaId);
            for (AsstActTypeInfo type : newTypes) {
                if ("region".equalsIgnoreCase(type.getAsstHGAttribute())) {
                    newBankType = type;
                    continue;
                }
                if (!"bankAccount".equalsIgnoreCase(type.getAsstHGAttribute())) continue;
                newBankAccount = type;
            }
            if (oldBankType == null && oldAccountBankType != null && newBankType != null && newBankAccount != null) {
                this.isNeedFixBank = true;
            }
        }
        EntryDC entryDC = BalanceDirectionEnum.CREDIT.equals((Object)account.getDC()) ? EntryDC.CREDIT : EntryDC.DEBIT;
        int entrySeq = 1;
        ArrayList<VoucherAssistRecordInfo> oldRecords = new ArrayList<VoucherAssistRecordInfo>();
        ArrayList<VoucherAssistRecordInfo> newRecords = new ArrayList<VoucherAssistRecordInfo>();
        if (oldCaaId == null && newCaaId != null) {
            IRowSet accrs = this.queryDiffAccountBalance(accountId, isUseRpt, change.get("isTotal") != null);
            if (accrs.size() == 0) {
                return result;
            }
            while (accrs.next()) {
                String currencyId = accrs.getString("FCurrencyID");
                BigDecimal endFor = this.getBigDecimal(accrs, "FDiffFor");
                BigDecimal endLocal = this.getBigDecimal(accrs, "FDiffLocal");
                BigDecimal endRpt = this.getBigDecimal(accrs, "FDiffRpt");
                BigDecimal endQty = this.getBigDecimal(accrs, "FDiffQty");
                if (EntryDC.DEBIT.equals((Object)entryDC)) {
                    endFor = endFor.multiply(negativeOne);
                    endLocal = endLocal.multiply(negativeOne);
                    endRpt = endRpt.multiply(negativeOne);
                    endQty = endQty.multiply(negativeOne);
                }
                currencyInfo = new CurrencyInfo();
                currencyInfo.setId(BOSUuid.read((String)currencyId));
                currencyInfo.setPrecision(accrs.getInt("FPrecision"));
                voucher.setCurrency(currencyInfo);
                BigDecimal qty = endQty;
                if (endQty.compareTo(zero) != 0 && entryUnit != null && entryUnit.getCoefficient().compareTo(one) != 0) {
                    qty = endQty.divide(entryUnit.getCoefficient(), entryUnit.getQtyPrecision());
                }
                BigDecimal price = qty.compareTo(zero) == 0 ? zero : endFor.divide(qty, 2, 4);
                VoucherEntryInfo oldEntry = new VoucherEntryInfo();
                oldEntry.put("isOutEntry", (Object)true);
                oldEntry.setBill(voucher);
                entries.add(oldEntry);
                oldEntry.setSeq(entrySeq++);
                oldEntry.setAccount(oldAccount);
                oldEntry.setCAA(oldAsstacc);
                oldEntry.setEntryDC(entryDC);
                oldEntry.setCurrency(currencyInfo);
                oldEntry.setDescription(ResourceBase.getString((String)RESOURCE, (String)"AsstAccountChange_TransferOut", (Locale)this.ctx.getOriginLocale()));
                oldEntry.setOprStatus(1);
                oldEntry.setMeasureUnit(entryUnit);
                oldEntry.setOriginalAmount(endFor);
                oldEntry.setLocalAmount(endLocal);
                oldEntry.setReportingAmount(endRpt);
                if (endFor.doubleValue() != 0.0) {
                    oldEntry.setLocalExchangeRate(endLocal.divide(endFor, 10, 4));
                    oldEntry.setReportingExchangeRate(endRpt.divide(endFor, 10, 4));
                }
                oldEntry.setStandardQuantity(endQty);
                oldEntry.setQuantity(qty);
                oldEntry.setPrice(price);
                oldEntry.setAssistRecords((AbstractObjectCollection)new VoucherAssistRecordCollection());
                if (oldAccount.isHasUserProperty()) {
                    VoucherAssistRecordCollection oldAssists = oldEntry.getAssistRecords();
                    VoucherAssistRecordInfo oldAssist = new VoucherAssistRecordInfo();
                    oldAssist.setEntry(oldEntry);
                    oldAssists.add(oldAssist);
                    oldAssist.setSeq(oldAssists.size() + 1);
                    oldAssist.setDescription(ResourceBase.getString((String)RESOURCE, (String)"AsstAccountChange_TransferOut", (Locale)this.ctx.getOriginLocale()));
                    oldAssist.setAssGrp(null);
                    oldAssist.setMeasureUnit(null);
                    oldAssist.setOriginalAmount(endFor);
                    oldAssist.setLocalAmount(endLocal);
                    oldAssist.setReportingAmount(endRpt);
                    oldAssist.setStandardQuantity(endQty);
                    oldAssist.setQuantity(qty);
                    oldAssist.setPrice(price);
                }
                VoucherEntryInfo newEntry = new VoucherEntryInfo();
                newEntry.setBill(voucher);
                entries.add(newEntry);
                newEntry.setSeq(entrySeq++);
                newEntry.setAccount(newAccount);
                newEntry.setCAA(newAsstacc);
                newEntry.setEntryDC(entryDC);
                newEntry.setCurrency(currencyInfo);
                newEntry.setDescription(ResourceBase.getString((String)RESOURCE, (String)"AsstAccountChange_TransferIn", (Locale)this.ctx.getOriginLocale()));
                newEntry.setOprStatus(1);
                newEntry.setMeasureUnit(entryUnit);
                newEntry.setOriginalAmount(endFor.multiply(negativeOne));
                newEntry.setLocalAmount(endLocal.multiply(negativeOne));
                newEntry.setReportingAmount(endRpt.multiply(negativeOne));
                if (endFor.doubleValue() != 0.0) {
                    newEntry.setLocalExchangeRate(endLocal.divide(endFor, 10, 4));
                    newEntry.setReportingExchangeRate(endRpt.divide(endFor, 10, 4));
                }
                newEntry.setStandardQuantity(endQty.multiply(negativeOne));
                newEntry.setQuantity(qty.multiply(negativeOne));
                newEntry.setPrice(price);
                newEntry.setAssistRecords((AbstractObjectCollection)new VoucherAssistRecordCollection());
                VoucherAssistRecordCollection newAssists = newEntry.getAssistRecords();
                MeasureUnitInfo assUnit = this.getAssistUnit(newCaaId);
                VoucherAssistRecordInfo newAssist = new VoucherAssistRecordInfo();
                newAssist.setEntry(newEntry);
                newAssists.add(newAssist);
                newAssist.setSeq(newAssists.size() + 1);
                newAssist.setDescription(ResourceBase.getString((String)RESOURCE, (String)"AsstAccountChange_TransferIn", (Locale)this.ctx.getOriginLocale()));
                newAssist.setAssGrp(this.getNewAssistantHg(newAccount, newCaaId, null, null, defaultVal));
                newAssist.setMeasureUnit(assUnit == null ? entryUnit : assUnit);
                newAssist.setOriginalAmount(endFor.multiply(negativeOne));
                newAssist.setLocalAmount(endLocal.multiply(negativeOne));
                newAssist.setReportingAmount(endRpt.multiply(negativeOne));
                newAssist.setStandardQuantity(endQty.multiply(negativeOne));
                qty = endQty;
                if (endQty.compareTo(zero) != 0 && account.isIsQty()) {
                    if (isQtyAsst.booleanValue() && newAsstacc.isIsQty()) {
                        if (newAssist.getMeasureUnit() != null && newAssist.getMeasureUnit().getCoefficient().compareTo(one) != 0) {
                            qty = endQty.divide(newAssist.getMeasureUnit().getCoefficient(), newAssist.getMeasureUnit().getQtyPrecision());
                        }
                    } else if (entryUnit != null && entryUnit.getCoefficient().compareTo(one) != 0) {
                        qty = endQty.divide(entryUnit.getCoefficient(), entryUnit.getQtyPrecision());
                    }
                }
                newAssist.setQuantity(qty.multiply(negativeOne));
                newAssist.setPrice(price);
            }
        } else if (oldCaaId != null) {
            boolean isQtyOld = account.isIsQty() && oldAsstacc.isIsQty() && isQtyAsst != false;
            IRowSet assrs = this.queryDiffAssistBalance(accountId, oldCaaId, isUseRpt, isQtyOld, change.get("isTotal") != null);
            if (assrs.size() == 0) {
                return result;
            }
            Map<String, AssistantHGInfo> oldHgs = this.getOldAssistantHgs(assrs, oldCaaId);
            HashMap<String, VoucherEntryInfo> mapEntryies = new HashMap<String, VoucherEntryInfo>();
            HashMap<Object, HashMap<String, BigDecimal>> totals = new HashMap<Object, HashMap<String, BigDecimal>>();
            assrs.beforeFirst();
            while (assrs.next()) {
                VoucherAssistRecordCollection newAssists;
                VoucherEntryInfo newEntry;
                HashMap<String, BigDecimal> total;
                String currencyId = assrs.getString("FCurrencyId");
                currencyInfo = new CurrencyInfo();
                currencyInfo.setId(BOSUuid.read((String)currencyId));
                currencyInfo.setPrecision(assrs.getInt("FPrecision"));
                String assistGrpId = assrs.getString("FAssistGrpId");
                if (assistGrpId == null || !oldHgs.containsKey(assistGrpId)) continue;
                BigDecimal endFor = this.getBigDecimal(assrs, "FDiffFor");
                BigDecimal endLocal = this.getBigDecimal(assrs, "FDiffLocal");
                BigDecimal endRpt = this.getBigDecimal(assrs, "FDiffRpt");
                BigDecimal endQty = this.getBigDecimal(assrs, "FDiffQty");
                if (EntryDC.DEBIT.equals((Object)entryDC)) {
                    endFor = endFor.multiply(negativeOne);
                    endLocal = endLocal.multiply(negativeOne);
                    endRpt = endRpt.multiply(negativeOne);
                    endQty = endQty.multiply(negativeOne);
                }
                if ((total = (HashMap<String, BigDecimal>)totals.get(currencyId)) == null) {
                    total = new HashMap<String, BigDecimal>();
                    total.put("for", endFor);
                    total.put("local", endLocal);
                    total.put("rpt", endRpt);
                    total.put("qty", endQty);
                    totals.put(currencyId, total);
                } else {
                    total.put("for", endFor.add((BigDecimal)total.get("for")));
                    total.put("local", endLocal.add((BigDecimal)total.get("local")));
                    total.put("rpt", endRpt.add((BigDecimal)total.get("rpt")));
                    total.put("qty", endQty.add((BigDecimal)total.get("qty")));
                }
                VoucherEntryInfo oldEntry = (VoucherEntryInfo)mapEntryies.get((String)currencyId + "_old");
                if (oldEntry == null) {
                    oldEntry = new VoucherEntryInfo();
                    oldEntry.put("isOutEntry", (Object)true);
                    oldEntry.setBill(voucher);
                    entries.add(oldEntry);
                    oldEntry.setSeq(entrySeq++);
                    oldEntry.setAccount(oldAccount);
                    oldEntry.setCAA(oldAsstacc);
                    oldEntry.setEntryDC(entryDC);
                    oldEntry.setCurrency(currencyInfo);
                    oldEntry.setDescription(ResourceBase.getString((String)RESOURCE, (String)"AsstAccountChange_TransferOut", (Locale)this.ctx.getOriginLocale()));
                    oldEntry.setOprStatus(1);
                    oldEntry.setMeasureUnit(entryUnit);
                    mapEntryies.put((String)currencyId + "_old", oldEntry);
                }
                if ((newEntry = (VoucherEntryInfo)mapEntryies.get((String)currencyId + "_new")) == null) {
                    newEntry = new VoucherEntryInfo();
                    newEntry.setBill(voucher);
                    entries.add(newEntry);
                    newEntry.setSeq(entrySeq++);
                    newEntry.setAccount(newAccount);
                    newEntry.setCAA(newAsstacc);
                    newEntry.setEntryDC(entryDC);
                    newEntry.setCurrency(currencyInfo);
                    newEntry.setDescription(ResourceBase.getString((String)RESOURCE, (String)"AsstAccountChange_TransferIn", (Locale)this.ctx.getOriginLocale()));
                    newEntry.setOprStatus(1);
                    newEntry.setMeasureUnit(entryUnit);
                    mapEntryies.put((String)currencyId + "_new", newEntry);
                }
                VoucherAssistRecordCollection oldAssists = oldEntry.getAssistRecords();
                MeasureUnitInfo oldUnit = null;
                if (isQtyOld) {
                    oldUnit = this.getMeasureUnit(assrs.getString("FMeasureUnitID"));
                }
                AssistantHGInfo oldHg = oldHgs.get(assistGrpId);
                VoucherAssistRecordInfo oldAssist = new VoucherAssistRecordInfo();
                oldAssist.setEntry(oldEntry);
                oldAssists.add(oldAssist);
                oldAssist.setSeq(oldAssists.size() + 1);
                oldAssist.setDescription(ResourceBase.getString((String)RESOURCE, (String)"AsstAccountChange_TransferOut", (Locale)this.ctx.getOriginLocale()));
                oldAssist.setAssGrp(oldHg);
                oldAssist.setMeasureUnit(oldUnit == null ? entryUnit : oldUnit);
                oldAssist.setOriginalAmount(endFor);
                oldAssist.setLocalAmount(endLocal);
                oldAssist.setReportingAmount(endRpt);
                if (oldAccount.isIsQty()) {
                    if (isQtyAsst.booleanValue() && oldAsstacc.isIsQty()) {
                        oldAssist.setQuantity(endQty);
                        BigDecimal stdQty = endQty;
                        if (oldAssist.getMeasureUnit() != null) {
                            stdQty = stdQty.multiply(oldAssist.getMeasureUnit().getCoefficient());
                        }
                        oldAssist.setStandardQuantity(stdQty);
                    } else {
                        BigDecimal qty = endQty;
                        if (entryUnit != null && entryUnit.getCoefficient().compareTo(one) != 0) {
                            qty = endQty.divide(entryUnit.getCoefficient(), entryUnit.getQtyPrecision());
                        }
                        oldAssist.setQuantity(qty);
                        oldAssist.setStandardQuantity(endQty);
                    }
                } else {
                    oldAssist.setQuantity(endQty);
                    oldAssist.setStandardQuantity(endQty);
                }
                BigDecimal price = oldAssist.getQuantity().compareTo(zero) == 0 ? zero : oldAssist.getOriginalAmount().divide(oldAssist.getQuantity(), 2);
                oldAssist.setPrice(price);
                if (newCaaId != null) {
                    BigDecimal stdQty;
                    newAssists = newEntry.getAssistRecords();
                    boolean isQtyNew = account.isIsQty() && newAsstacc.isIsQty() && isQtyAsst != false;
                    MeasureUnitInfo newUnit = oldUnit;
                    if (isQtyNew && newUnit == null) {
                        newUnit = this.getAssistUnit(newCaaId);
                    }
                    VoucherAssistRecordInfo newAssist = new VoucherAssistRecordInfo();
                    newAssist.setEntry(newEntry);
                    newAssists.add(newAssist);
                    newAssist.setSeq(newAssists.size() + 1);
                    newAssist.setDescription(ResourceBase.getString((String)RESOURCE, (String)"AsstAccountChange_TransferIn", (Locale)this.ctx.getOriginLocale()));
                    newAssist.setAssGrp(this.getNewAssistantHg(newAccount, newCaaId, oldCaaId, oldHg, defaultVal));
                    newAssist.setMeasureUnit(newUnit == null ? entryUnit : newUnit);
                    newAssist.setOriginalAmount(endFor.multiply(negativeOne));
                    newAssist.setLocalAmount(endLocal.multiply(negativeOne));
                    newAssist.setReportingAmount(endRpt.multiply(negativeOne));
                    if (oldAccount.isIsQty()) {
                        if (isQtyAsst.booleanValue() && newAsstacc.isIsQty()) {
                            newAssist.setQuantity(endQty.multiply(negativeOne));
                            stdQty = newAssist.getQuantity();
                            if (newAssist.getMeasureUnit() != null) {
                                stdQty = stdQty.multiply(newAssist.getMeasureUnit().getCoefficient());
                            }
                            newAssist.setStandardQuantity(stdQty);
                        } else {
                            newAssist.setStandardQuantity(endQty.multiply(negativeOne));
                            BigDecimal qty = newAssist.getStandardQuantity();
                            if (entryUnit != null && entryUnit.getCoefficient().compareTo(zero) != 0) {
                                qty = qty.divide(entryUnit.getCoefficient(), entryUnit.getQtyPrecision());
                            }
                            newAssist.setQuantity(qty);
                        }
                    } else {
                        newAssist.setQuantity(endQty.multiply(negativeOne));
                        stdQty = newAssist.getQuantity();
                        newAssist.setStandardQuantity(stdQty);
                    }
                    price = newAssist.getQuantity().compareTo(zero) == 0 ? zero : newAssist.getOriginalAmount().divide(newAssist.getQuantity(), 2);
                    newAssist.setPrice(price);
                    oldRecords.add(oldAssist);
                    newRecords.add(newAssist);
                    continue;
                }
                if (!newAccount.isHasUserProperty()) continue;
                newAssists = newEntry.getAssistRecords();
                BigDecimal iOriginalAmount = endFor.multiply(negativeOne);
                BigDecimal iLocalAmount = endLocal.multiply(negativeOne);
                BigDecimal iReportingAmount = endRpt.multiply(negativeOne);
                BigDecimal iQty = null;
                BigDecimal iStdQty = null;
                if (newAccount.isIsQty()) {
                    iQty = iStdQty = endQty.multiply(negativeOne);
                    if (entryUnit != null && entryUnit.getCoefficient().compareTo(zero) != 0) {
                        iQty = iQty.divide(entryUnit.getCoefficient(), entryUnit.getQtyPrecision());
                    }
                } else {
                    iStdQty = iQty = endQty.multiply(negativeOne);
                }
                VoucherAssistRecordInfo newAssist = null;
                if (newAssists.size() > 0) {
                    newAssist = newAssists.get(0);
                    newAssist.setOriginalAmount(newAssist.getOriginalAmount().add(iOriginalAmount));
                    newAssist.setLocalAmount(newAssist.getLocalAmount().add(iLocalAmount));
                    newAssist.setReportingAmount(newAssist.getReportingAmount().add(iReportingAmount));
                    newAssist.setQuantity(newAssist.getQuantity().add(iQty));
                    newAssist.setStandardQuantity(newAssist.getStandardQuantity().add(iStdQty));
                } else {
                    newAssist = new VoucherAssistRecordInfo();
                    newAssist.setEntry(newEntry);
                    newAssists.add(newAssist);
                    newAssist.setSeq(newAssists.size() + 1);
                    newAssist.setDescription(ResourceBase.getString((String)RESOURCE, (String)"AsstAccountChange_TransferIn", (Locale)this.ctx.getOriginLocale()));
                    newAssist.setAssGrp(null);
                    newAssist.setMeasureUnit(null);
                    newAssist.setOriginalAmount(iOriginalAmount);
                    newAssist.setLocalAmount(iLocalAmount);
                    newAssist.setReportingAmount(iReportingAmount);
                    newAssist.setQuantity(iQty);
                    newAssist.setStandardQuantity(iStdQty);
                }
                price = newAssist.getQuantity().compareTo(zero) == 0 ? zero : newAssist.getOriginalAmount().divide(newAssist.getQuantity(), 2);
                newAssist.setPrice(price);
            }
            for (String currencyId : totals.keySet()) {
                BigDecimal endQty;
                Map total = (Map)totals.get(currencyId);
                VoucherEntryInfo oldEntry = (VoucherEntryInfo)mapEntryies.get(currencyId + "_old");
                VoucherEntryInfo newEntry = (VoucherEntryInfo)mapEntryies.get(currencyId + "_new");
                if (oldEntry == null || newEntry == null) continue;
                BigDecimal endFor = (BigDecimal)total.get("for");
                BigDecimal endLocal = (BigDecimal)total.get("local");
                BigDecimal endRpt = (BigDecimal)total.get("rpt");
                BigDecimal qty = endQty = (BigDecimal)total.get("qty");
                if (endQty.compareTo(zero) != 0 && entryUnit != null && entryUnit.getCoefficient().compareTo(one) != 0) {
                    qty = endQty.divide(entryUnit.getCoefficient(), entryUnit.getQtyPrecision());
                }
                BigDecimal price = qty.compareTo(zero) == 0 ? zero : endFor.divide(qty, 2, 4);
                oldEntry.setOriginalAmount(endFor);
                oldEntry.setLocalAmount(endLocal);
                oldEntry.setReportingAmount(endRpt);
                if (endFor.doubleValue() != 0.0) {
                    oldEntry.setLocalExchangeRate(endLocal.divide(endFor, 10, 4));
                    oldEntry.setReportingExchangeRate(endRpt.divide(endFor, 10, 4));
                }
                oldEntry.setStandardQuantity(endQty);
                oldEntry.setQuantity(qty);
                oldEntry.setPrice(price);
                newEntry.setOriginalAmount(endFor.multiply(negativeOne));
                newEntry.setLocalAmount(endLocal.multiply(negativeOne));
                newEntry.setReportingAmount(endRpt.multiply(negativeOne));
                if (endFor.doubleValue() != 0.0) {
                    newEntry.setLocalExchangeRate(endLocal.divide(endFor, 10, 4));
                    newEntry.setReportingExchangeRate(endRpt.divide(endFor, 10, 4));
                }
                newEntry.setStandardQuantity(endQty.multiply(negativeOne));
                newEntry.setQuantity(qty.multiply(negativeOne));
                newEntry.setPrice(price);
            }
        }
        if (entries.size() == 0) {
            return result;
        }
        voucher.setVoucherAbstract(ResourceBase.getString((String)RESOURCE, (String)"AsstAccountChange_Voucher", (Locale)this.ctx.getOriginLocale()));
        voucher.setEntries((AbstractObjectCollection)entries);
        voucher.setEntryCount(entries.size());
        voucher.setCreator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
        voucher.setCreateTime(new Timestamp(System.currentTimeMillis()));
        voucher.setCompany(account.getCompanyID());
        voucher.setPeriod(this.period);
        IVoucherType voucherType = VoucherTypeFactory.getLocalInstance((Context)this.ctx);
        ObjectUuidPK typePK = new ObjectUuidPK(BOSUuid.read((String)this.getVoucherType(this.company.getCU())));
        voucher.setVoucherType(voucherType.getVoucherTypeInfo((IObjectPK)typePK));
        voucher.setBizStatus(VoucherStatusEnum.SUBMITTED);
        Date serviceDate = this.getServcieByPeriod(voucher.getPeriod());
        voucher.setBookedDate(serviceDate);
        voucher.setBizDate(voucher.getPeriod().getBeginDate());
        this.updateAsstEndDateByBizDate(voucher);
        voucher.setSourceType(SourceType.ASST_ACCOUNT_CHANGE);
        voucher.setSourceSys(SystemEnum.GENERALLEDGER);
        boolean isAC = false;
        if (account.isAC() && oldCaaId != null && newCaaId != null) {
            isAC = true;
        }
        voucher.setIsAC(isAC);
        voucher.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        voucher.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)this.ctx));
        voucher.setCalSubmitBal(0);
        voucher.setHasCashAccount(account.isIsCash() || account.isIsCashEquivalent() || account.isIsBank());
        if (change.get("isTry") != null) {
            ArrayList outEntries = new ArrayList();
            block9: for (VoucherEntryInfo entry : voucher.getEntries()) {
                if (entry.get("isOutEntry") == null) continue;
                HashMap<String, Object> outEntry = new HashMap<String, Object>();
                CurrencyInfo cy = this.queryCurrency(entry.getCurrency().getId().toString());
                outEntry.put("currency", cy.getName());
                outEntry.put("amount", "Origin" + entry.getOriginalAmount() + ", Local" + entry.getLocalAmount() + ", Report" + entry.getReportingAmount());
                outEntries.add(outEntry);
                if (entry.getAssistRecords() == null) continue;
                ArrayList outRecords = new ArrayList();
                outEntry.put("records", outRecords);
                int count = 0;
                for (VoucherAssistRecordInfo record : entry.getAssistRecords()) {
                    HashMap<String, String> outRecord = new HashMap<String, String>();
                    StringBuffer assist = new StringBuffer();
                    if (record.getAssGrp() != null && record.getAssGrp().getId() != null) {
                        assist.append("ID[").append(record.getAssGrp().getId().toString()).append("],  ");
                        AsstAccountInfo aa = record.getAssGrp().getAsstAccount();
                        aa = this.queryCaa(aa.getId().toString());
                        assist.append("Type[" + aa.getName() + "," + aa.getId().toString() + "],  (");
                        AsstActTypeCollection aats = this.getAsstActTypes(aa.getId().toString());
                        for (int i = 0; i < aats.size(); ++i) {
                            AsstActTypeInfo aat = aats.get(i);
                            if (i > 0) {
                                assist.append("; ");
                            }
                            assist.append(aat.getName()).append("[");
                            DataBaseInfo db = (DataBaseInfo)record.getAssGrp().get(aat.getAsstHGAttribute());
                            if (db != null) {
                                if (db.getName() != null) {
                                    assist.append(db.getName());
                                } else if (db.getNumber() != null) {
                                    assist.append(db.getNumber());
                                }
                                assist.append("," + db.getId());
                            }
                            assist.append("]");
                        }
                        assist.append(")");
                        outRecord.put("assist", assist.toString());
                    } else {
                        outRecord.put("assist", (String)record.getAssGrp());
                    }
                    outRecord.put("amount", "Origin" + record.getOriginalAmount() + ", Local" + record.getLocalAmount() + ", Report" + record.getReportingAmount());
                    outRecords.add(outRecord);
                    if (++count < 11) continue;
                    continue block9;
                }
            }
            result.put("entries", outEntries);
            return result;
        }
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)this.ctx);
        PeriodInfo current = GlUtils.getCurrentPeriod(this.ctx, this.companyId);
        if (current.getNumber() > this.period.getNumber()) {
            vPK = iVoucher.submitAccountAdjustVoucher((BaseVoucherInfo)voucher);
            ArrayList<IObjectPK> pkList = new ArrayList<IObjectPK>();
            pkList.add(vPK);
            this.auditCheckVoucher(this.ctx, pkList);
            iVoucher.post(vPK, null);
        } else {
            vPK = iVoucher.submit((CoreBaseInfo)voucher);
        }
        if (voucher.isIsAC() && this.isAllowCussent() && oldRecords.size() > 0) {
            AcctCussentHistoryFacadeFactory.getLocalInstance(this.ctx).insertCussent(vPK.toString(), true);
            HashMap<String, String> relMap = new HashMap<String, String>();
            for (int i = 0; i < oldRecords.size(); ++i) {
                VoucherAssistRecordInfo oldAssist = (VoucherAssistRecordInfo)oldRecords.get(i);
                VoucherAssistRecordInfo newAssist = (VoucherAssistRecordInfo)newRecords.get(i);
                if (oldAssist == null || oldAssist.getId() == null || newAssist == null || newAssist.getId() == null) continue;
                relMap.put(oldAssist.getId().toString(), newAssist.getId().toString());
            }
            if (relMap.size() > 0) {
                AcctCussentHistoryFactory.getLocalInstance(this.ctx).insertHistory(relMap, vPK.toString(), this.company);
            }
        }
        result.put("id", vPK.toString());
        result.put("number", voucher.getNumber());
        return result;
    }

    private void updateAsstEndDateByBizDate(VoucherInfo voucher) {
        VoucherEntryCollection entryCollection = voucher.getEntries();
        VoucherAssistRecordCollection assistRecords = null;
        for (int i = 0; i < entryCollection.size(); ++i) {
            assistRecords = entryCollection.get(i).getAssistRecords();
            if (null == assistRecords || assistRecords.size() <= 0) continue;
            for (int j = 0; j < assistRecords.size(); ++j) {
                if (null != assistRecords.get(j).getEndDate()) continue;
                assistRecords.get(j).setEndDate(voucher.getBizDate());
            }
        }
    }

    private Date getServcieByPeriod(PeriodInfo servicePeriod) {
        Date newDate = new Date();
        Date beginDate = servicePeriod.getBeginDate();
        Timestamp endDate = servicePeriod.getEndDate();
        if (newDate.compareTo(beginDate) >= 0 && newDate.compareTo(endDate) <= 0) {
            return newDate;
        }
        return beginDate;
    }

    private IRowSet queryDiffAccountBalance(String accountId, boolean isUseRpt, boolean isTotal) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("    b.FCurrencyID, \n");
        sql.append("    cy.FPrecision, \n");
        sql.append("    b.FBeginBalanceFor + isnull(vch.FTransferFor, 0) FDiffFor, \n");
        sql.append("    b.FBeginBalanceLocal + isnull(vch.FTransferLocal, 0) FDiffLocal, \n");
        if (isUseRpt) {
            sql.append("    b.FBeginBalanceRpt + isnull(vch.FTransferRpt, 0) FDiffRpt, \n");
        } else {
            sql.append("    0 FDiffRpt, \n");
        }
        sql.append("    b.FBeginQty + isnull(vch.FTransferQty, 0) FDiffQty \n");
        sql.append("from " + GLBalanceUtils.getAccountBalanceTable(1) + " b \n");
        sql.append("join T_BD_Currency cy on cy.fid = b.FCurrencyID \n");
        sql.append("left join ( \n");
        sql.append("    select  \n");
        sql.append("        ve.FCurrencyID, \n");
        sql.append("        sum((ve.fentrydc+ve.fentrydc-1)*ve.foriginalamount) FTransferFor, \n");
        sql.append("        sum((ve.fentrydc+ve.fentrydc-1)*ve.flocalamount) FTransferLocal, \n");
        if (isUseRpt) {
            sql.append("        sum((ve.fentrydc+ve.fentrydc-1)*ve.freportingamount) FTransferRpt, \n");
        } else {
            sql.append("        0 FTransferRpt, \n");
        }
        sql.append("        sum((ve.fentrydc+ve.fentrydc-1)*ve.fquantity) FTransferQty \n");
        sql.append("    from T_GL_Voucher v \n");
        sql.append("    join T_GL_VoucherEntry ve on ve.FBillID = v.FID \n");
        sql.append("    WHERE v.FCompanyID = ? \n");
        sql.append("        and v.FPeriodID = ? \n");
        sql.append("        and ve.FAccountID = ? \n");
        sql.append("        and v.FSourceType = 11 \n");
        sql.append("        AND ve.FCaa is null \n");
        if (isTotal) {
            sql.append("        AND v.FID = 'tryid' \n");
        }
        sql.append("    group by ve.FCurrencyID \n");
        sql.append(") vch on vch.FCurrencyID = b.FCurrencyID \n");
        sql.append("WHERE b.FOrgunitID = ? \n");
        sql.append("    and b.FPeriod = ? \n");
        sql.append("    AND b.FAccountID = ? \n");
        sql.append("    AND ( \n");
        sql.append("        b.FBeginBalanceFor + isnull(vch.FTransferFor, 0) <> 0 or \n");
        sql.append("        b.FBeginBalanceLocal + isnull(vch.FTransferLocal, 0) <> 0 or \n");
        if (isUseRpt) {
            sql.append("        b.FBeginBalanceRpt + isnull(vch.FTransferRpt, 0) <> 0 or \n");
        }
        sql.append("        b.FBeginQty + isnull(vch.FTransferQty, 0) <> 0 \n");
        sql.append("    ) \n");
        Object[] params = new Object[]{this.companyId, this.period.getId().toString(), accountId, this.companyId, this.period.getNumber(), accountId};
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])params);
        return rs;
    }

    private IRowSet queryDiffAssistBalance(String accountId, String caaId, boolean isUseRpt, boolean isQty, boolean isTotal) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("    b.FCurrencyID, \n");
        sql.append("    cy.FPrecision, \n");
        sql.append("    b.FAssistGrpID, \n");
        if (isQty) {
            sql.append("    b.FMeasureUnitID, \n");
        }
        sql.append("    b.FBeginBalanceFor + isnull(vch.FTransferFor, 0) FDiffFor, \n");
        sql.append("    b.FBeginBalanceLocal + isnull(vch.FTransferLocal, 0) FDiffLocal, \n");
        if (isUseRpt) {
            sql.append("    b.FBeginBalanceRpt + isnull(vch.FTransferRpt, 0) FDiffRpt, \n");
        } else {
            sql.append("    0 FDiffRpt, \n");
        }
        sql.append("    b.FBeginQty + isnull(vch.FTransferQty, 0) FDiffQty \n");
        if (isQty) {
            sql.append("from " + GLBalanceUtils.getAssistMeasureBalanceTable(1) + " b \n");
        } else {
            sql.append("from " + GLBalanceUtils.getAssistBalanceTable(1) + " b \n");
        }
        sql.append("join T_BD_Currency cy on cy.fid = b.FCurrencyID \n");
        sql.append("join t_bd_assistanthg hg ON hg.FID = b.FAssistGrpID \n");
        sql.append("left join ( \n");
        sql.append("    select  \n");
        sql.append("        ve.FCurrencyID, \n");
        sql.append("        r.FASSGRPID FAssistGrpID, \n");
        if (isQty) {
            sql.append("        case when r.FMeasureUnitID is null then '00000000-0000-0000-0000-0000000000005B825C57' else r.FMeasureUnitID end FMeasureUnitID, \n");
        }
        sql.append("        sum((ve.fentrydc+ve.fentrydc-1)*r.foriginalamount) FTransferFor, \n");
        sql.append("        sum((ve.fentrydc+ve.fentrydc-1)*r.flocalamount) FTransferLocal, \n");
        if (isUseRpt) {
            sql.append("        sum((ve.fentrydc+ve.fentrydc-1)*r.freportingamount) FTransferRpt, \n");
        } else {
            sql.append("        0 FTransferRpt, \n");
        }
        sql.append("        sum((ve.fentrydc+ve.fentrydc-1)*r.fquantity) FTransferQty \n");
        sql.append("    from T_GL_Voucher v \n");
        sql.append("    join T_GL_VoucherEntry ve on ve.FBillID = v.FID \n");
        sql.append("    join T_GL_VoucherAssistRecord r on r.FEntryID = ve.FID \n");
        sql.append("    join t_bd_assistanthg vhg ON vhg.FID = r.FASSGRPID \n");
        sql.append("    WHERE v.FCompanyID = ? \n");
        sql.append("        and v.FPeriodID = ? \n");
        sql.append("        and ve.FAccountID = ? \n");
        sql.append("        and v.FSourceType = 11 \n");
        sql.append("        AND vhg.FAsstAccountID = ? \n");
        if (isTotal) {
            sql.append("        AND v.FID = 'tryid' \n");
        }
        sql.append("    group by ve.FCurrencyID, r.FASSGRPID, r.FMeasureUnitID \n");
        sql.append(") vch on vch.FCurrencyID = b.FCurrencyID \n");
        sql.append("    and vch.FAssistGrpID = b.FAssistGrpID \n");
        if (isQty) {
            sql.append("    and vch.FMeasureUnitID = b.FMeasureUnitID \n");
        }
        sql.append("WHERE b.FOrgunitID = ? \n");
        sql.append("    and b.FPeriod = ? \n");
        sql.append("    AND b.FAccountID = ? \n");
        sql.append("    AND hg.FAsstAccountID = ? \n");
        sql.append("    AND ( \n");
        sql.append("        b.FBeginBalanceFor + isnull(vch.FTransferFor, 0) <> 0  or \n");
        sql.append("        b.FBeginBalanceLocal + isnull(vch.FTransferLocal, 0) <> 0 or \n");
        if (isUseRpt) {
            sql.append("        b.FBeginBalanceRpt + isnull(vch.FTransferRpt, 0) <> 0 or \n");
        }
        sql.append("        b.FBeginQty + isnull(vch.FTransferQty, 0) <> 0 \n");
        sql.append("    ) \n");
        Object[] params = new Object[]{this.companyId, this.period.getId().toString(), accountId, caaId, this.companyId, this.period.getNumber(), accountId, caaId};
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])params);
        return rs;
    }

    private CompanyOrgUnitInfo queryCompany(String companyId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("baseCurrency.*");
        selector.add("reportCurrency.*");
        selector.add("CU.id");
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
        return company;
    }

    private AccountViewInfo queryAccount(String accountId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("DC");
        selector.add("AC");
        selector.add("isQty");
        selector.add("measureUnitID.id");
        selector.add("measureUnitID.coefficient");
        selector.add("measureUnitID.qtyPrecision");
        selector.add("measureUnitGroupID.id");
        selector.add("isCash");
        selector.add("isCashEquivalent");
        selector.add("isBank");
        selector.add("hasUserProperty");
        AccountViewInfo account = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId), selector);
        account.setCompanyID(this.company);
        return account;
    }

    private AsstAccountInfo queryCaa(String caa) throws BOSException, EASBizException {
        if (this.caas.containsKey(caa)) {
            return this.caas.get(caa);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("isQty");
        selector.add("measureUnit.id");
        selector.add("measureUnit.coefficient");
        selector.add("measureUnit.qtyPrecision");
        selector.add("measureUnitGroup.id");
        AsstAccountInfo asstAccount = AsstAccountFactory.getLocalInstance((Context)this.ctx).getAsstAccountInfo((IObjectPK)new ObjectUuidPK(caa), selector);
        this.caas.put(caa, asstAccount);
        return asstAccount;
    }

    private BigDecimal getBigDecimal(IRowSet rs, String field) throws SQLException {
        BigDecimal b = rs.getBigDecimal(field);
        if (b == null) {
            b = new BigDecimal("0");
        }
        return b;
    }

    private MeasureUnitInfo getEntryUnit(AccountViewInfo account) throws EASBizException, BOSException {
        if (account.getMeasureUnitID() != null) {
            return account.getMeasureUnitID();
        }
        if (account.getMeasureUnitGroupID() != null) {
            return this.queryDefaultUnit(account.getMeasureUnitGroupID().getId().toString());
        }
        return null;
    }

    public MeasureUnitInfo getMeasureUnit(String id) throws EASBizException, BOSException {
        if (id == null || id.equals("00000000-0000-0000-0000-0000000000005B825C57")) {
            return null;
        }
        if (this.measureUnits.containsKey(id)) {
            return this.measureUnits.get(id);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("coefficient");
        selector.add("qtyPrecision");
        MeasureUnitInfo mu = MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(id), selector);
        this.measureUnits.put(id, mu);
        return mu;
    }

    public MeasureUnitInfo getAssistUnit(String caaId) throws EASBizException, BOSException {
        if (caaId == null) {
            return null;
        }
        AsstAccountInfo caa = this.queryCaa(caaId);
        if (caa.getMeasureUnit() != null) {
            return caa.getMeasureUnit();
        }
        if (caa.getMeasureUnitGroup() != null) {
            return this.queryDefaultUnit(caa.getMeasureUnitGroup().getId().toString());
        }
        return null;
    }

    private MeasureUnitInfo queryDefaultUnit(String muGroupId) throws EASBizException, BOSException {
        if (this.defaultUnits.containsKey(muGroupId)) {
            return this.defaultUnits.get(muGroupId);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("defaultUnit.id");
        selector.add("defaultUnit.coefficient");
        selector.add("defaultUnit.qtyPrecision");
        MeasureUnitGroupInfo mug = MeasureUnitGroupFactory.getLocalInstance((Context)this.ctx).getMeasureUnitGroupInfo((IObjectPK)new ObjectUuidPK(muGroupId), selector);
        MeasureUnitInfo mu = mug.getDefaultUnit();
        this.defaultUnits.put(muGroupId, mu);
        return mu;
    }

    private CurrencyInfo queryCurrency(String id) throws EASBizException, BOSException {
        if (this.currencys.containsKey(id)) {
            return this.currencys.get(id);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        CurrencyInfo cy = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(id), selector);
        this.currencys.put(id, cy);
        return cy;
    }

    private Map<AsstActTypeInfo, Object> getDefaultVal(AccountViewInfo account, AsstAccountChangeInfo change) throws BOSException, SQLException, EASBizException {
        int i;
        String oldCaaId = null;
        String newCaaId = null;
        if (change.getBefore() != null) {
            oldCaaId = change.getBefore().getId().toString();
        }
        if (change.getAfter() != null) {
            newCaaId = change.getAfter().getId().toString();
        }
        HashMap<AsstActTypeInfo, Object> defaultVal = new HashMap<AsstActTypeInfo, Object>();
        if (newCaaId == null) {
            return defaultVal;
        }
        String key = account.getId().toString() + oldCaaId;
        if (this.defaultVals.containsKey(key)) {
            return this.defaultVals.get(key);
        }
        AsstActTypeCollection asstActTypes = this.getAsstActTypes(newCaaId);
        HashSet<String> oldAsstActTypeIds = new HashSet<String>();
        if (oldCaaId != null) {
            AsstActTypeCollection oldAsstActTypes = this.getAsstActTypes(oldCaaId);
            for (i = 0; i < oldAsstActTypes.size(); ++i) {
                oldAsstActTypeIds.add(oldAsstActTypes.get(i).getId().toString());
            }
            boolean isAllInclude = true;
            for (int i2 = 0; i2 < asstActTypes.size(); ++i2) {
                if (oldAsstActTypeIds.contains(asstActTypes.get(i2).getId().toString())) continue;
                isAllInclude = false;
            }
            if (isAllInclude) {
                this.defaultVals.put(key, defaultVal);
                return defaultVal;
            }
        }
        HashMap<String, String> defaultIds = new HashMap<String, String>();
        for (i = 0; i < change.getEntries().size(); ++i) {
            AsstAccountChangeEntryInfo entry = change.getEntries().get(i);
            defaultIds.put(entry.getAsstActType().getId().toString(), entry.getAsstAct());
        }
        for (i = 0; i < asstActTypes.size(); ++i) {
            AsstActTypeInfo aat = asstActTypes.get(i);
            ObjectBaseInfo value = null;
            if (!oldAsstActTypeIds.contains(aat.getId().toString())) {
                if (defaultIds.get(aat.getId().toString()) != null) {
                    value = GlWebServiceUtil.findAsstActObject(this.ctx, aat.getAsstHGAttribute(), (String)defaultIds.get(aat.getId().toString()));
                }
                if (value == null) {
                    String msg = MessageFormat.format(ResourceBase.getString((String)RESOURCE, (String)"LossDefault", (Locale)this.ctx.getOriginLocale()), account.getName(), account.getNumber(), this.period.getNumber(), aat.getName(), aat.getNumber());
                    throw new EASBizException(new NumericExceptionSubItem("101", msg));
                }
            }
            defaultVal.put(aat, value);
        }
        return defaultVal;
    }

    private AsstActTypeCollection getAsstActTypes(String caaId) throws BOSException {
        if (this.asstActTypess.containsKey(caaId)) {
            return this.asstActTypess.get(caaId);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("asstActType.groupTableName"));
        sic.add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.id"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)caaId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        AsstActGroupDetailCollection asstcol = AsstActGroupDetailFactory.getLocalInstance((Context)this.ctx).getAsstActGroupDetailCollection(view);
        AsstActTypeCollection asstActTypes = new AsstActTypeCollection();
        for (int i = 0; i < asstcol.size(); ++i) {
            asstActTypes.add(asstcol.get(i).getAsstActType());
        }
        this.asstActTypess.put(caaId, asstActTypes);
        return asstActTypes;
    }

    private Map<String, AssistantHGInfo> getOldAssistantHgs(IRowSet assrs, String oldCaaId) throws BOSException, SQLException {
        HashSet<String> assistGrpIds = new HashSet<String>();
        while (assrs.next()) {
            assistGrpIds.add(assrs.getString("FAssistGrpId"));
        }
        return this.getOldAssistantHgs(oldCaaId, assistGrpIds);
    }

    private Map<String, AssistantHGInfo> getOldAssistantHgs(String caa, Set<String> assistGrpIds) throws BOSException {
        HashMap<String, AssistantHGInfo> hgs = new HashMap<String, AssistantHGInfo>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = view.getSelector();
        selectors.add(new SelectorItemInfo("asstAccount.id"));
        AsstActTypeCollection asstActTypeList = this.getAsstActTypes(caa);
        if (asstActTypeList != null && asstActTypeList.size() > 0) {
            for (int i = 0; i < asstActTypeList.size(); ++i) {
                AsstActTypeInfo asstActType = asstActTypeList.get(i);
                String attr = asstActType.getAsstHGAttribute();
                selectors.add(attr + ".id");
                selectors.add(attr + ".name");
                if ("provider".equals(attr) || "customer".equals(attr)) {
                    selectors.add(attr + ".browseGroup.displayName");
                } else if ("material".equals(asstActType.getAsstHGAttribute())) {
                    selectors.add(attr + ".materialGroup.displayName");
                } else if (asstActType.isIsMultilevel()) {
                    selectors.add(attr + ".displayName");
                }
                selectors.add(attr + ".number");
            }
        }
        IAssistantHG assistanthg = AssistantHGFactory.getLocalInstance((Context)this.ctx);
        List<Set<String>> sets = GlUtils.split(assistGrpIds, 300);
        for (Set<String> set : sets) {
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            AssistantHGCollection assistantHgColl = assistanthg.getAssistantHGCollection(view);
            for (int i = 0; i < assistantHgColl.size(); ++i) {
                AssistantHGInfo hg = assistantHgColl.get(i);
                String hgFid = hg.getId().toString();
                hgs.put(hgFid, hg);
            }
        }
        return hgs;
    }

    public AssistantHGInfo getNewAssistantHg(AccountViewInfo account, String newCaaId, String oldCaaId, AssistantHGInfo oldHgInfo, Map<AsstActTypeInfo, Object> defaultVal) throws EASBizException, BOSException, SQLException {
        AsstActTypeCollection asstActTypes = this.getAsstActTypes(newCaaId);
        AssistantHGInfo hgInfo = new AssistantHGInfo();
        hgInfo.setId(null);
        hgInfo.setAsstAccount(this.queryCaa(newCaaId));
        hgInfo.put("aatok", (Object)Boolean.TRUE);
        HashMap<String, Object> defs = new HashMap<String, Object>();
        for (AsstActTypeInfo aat : defaultVal.keySet()) {
            Object val = defaultVal.get(aat);
            if (val == null) continue;
            defs.put(aat.getAsstHGAttribute(), val);
        }
        for (int i = 0; i < asstActTypes.size(); ++i) {
            Object temp;
            AccountBankInfo ab;
            String asstHGAttribute = asstActTypes.get(i).getAsstHGAttribute();
            Object value = defs.get(asstHGAttribute);
            if (this.isNeedFixBank && value instanceof BankInfo && oldHgInfo != null && (ab = oldHgInfo.getBankAccount()) != null) {
                value = this.getBank(ab.getId().toString());
            }
            if (oldHgInfo != null && (temp = oldHgInfo.get(asstHGAttribute)) != null) {
                value = temp;
            }
            if (value == null) continue;
            hgInfo.put(asstHGAttribute, value);
        }
        hgInfo = AssistantHGFactory.getLocalInstance((Context)this.ctx).getAssistantHG(hgInfo, newCaaId, asstActTypes);
        return hgInfo;
    }

    private BankInfo getBank(String accountBankId) throws BOSException {
        if (this.banks.containsKey(accountBankId)) {
            return this.banks.get(accountBankId);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("bank.id");
        selector.add("bank.number");
        selector.add("bank.name");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)accountBankId));
        AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankCollection(view);
        BankInfo info = null;
        if (coll.size() > 0) {
            info = coll.get(0).getBank();
        }
        this.banks.put(accountBankId, info);
        return info;
    }

    public String getVoucherType(CtrlUnitInfo cu) throws BOSException, EASBizException {
        VoucherTypeInfo info;
        int i;
        String ctrlUnit;
        ObjectUuidPK ctrlUnitPK;
        IVoucherType v = VoucherTypeFactory.getLocalInstance((Context)this.ctx);
        FilterInfo filter = v.getDatabaseDFilter((IObjectPK)(ctrlUnitPK = new ObjectUuidPK(ctrlUnit = cu != null ? cu.getId().toString() : ContextUtil.getCurrentCtrlUnit((Context)this.ctx).getId().toString())), "id", "adminCU.id");
        VoucherTypeCollection coll = GlUtils.getVoucherTypeCollection(this.ctx, filter, ctrlUnit);
        if (coll.size() == 0) {
            String msg = ResourceBase.getString((String)RESOURCE, (String)"noVoucherType", (Locale)this.ctx.getOriginLocale());
            throw new EASBizException(new NumericExceptionSubItem("", msg));
        }
        Object param = VoucherProcessCache.getParam(this.ctx, this.companyId, "GL_AAC_VoucherType");
        if (param != null && param.toString().trim().length() > 0) {
            String id = param.toString().trim();
            for (i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                if (!info.getId().toString().equals(id)) continue;
                return id;
            }
        }
        String msg = ResourceBase.getString((String)RESOURCE, (String)"turn", (Locale)this.ctx.getOriginLocale());
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!msg.equals(info.getName())) continue;
            return info.getId().toString();
        }
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!info.isPretermit()) continue;
            return info.getId().toString();
        }
        return coll.get(0).getId().toString();
    }

    private boolean isAllowCussent() throws EASBizException, BOSException {
        if (this.allowCussent >= 0) {
            return this.allowCussent > 0;
        }
        this.allowCussent = GlUtils.getDefaultGLParam(this.ctx, this.companyId, "GL_028") ? 1 : 0;
        return this.isAllowCussent();
    }

    private void auditCheckVoucher(Context ctx, ArrayList pkList) throws BOSException {
        String voStr = ToolUtils.aryToStr((List)pkList, (boolean)true);
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String updateSql = "update t_gl_voucher set fischeck =1 , FBizStatus=3, fauditorid='" + userID + "',  fcashierid='" + userID + "' where\u3000fid in (" + voStr + ") ";
        DbUtil.execute((Context)ctx, (String)updateSql);
        String dpdatesql2 = "update T_GL_VoucherEntry set fischeck =1 , fcashierid= '" + userID + "' where FBillID in (" + voStr + ")";
        DbUtil.execute((Context)ctx, (String)dpdatesql2);
    }
}

