/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.AbstractGLBalanceAnaFacadeControllerBean;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLBalanceAnaFacadeControllerBean
extends AbstractGLBalanceAnaFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLBalanceAnaFacadeControllerBean");
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.app.GLBalanceRepairResource";
    private static final String AnaPosted = "AnaBal_Posted";
    private static final String AnaUnPost = "AnaBal_UnPost";
    private static final String AnaBegin = "AnaBal_Begin";
    private static final String AnaCurrent = "AnaBal_Current";
    private static final String AnaCurrency = "AnaBal_Currency";
    private static final String AnaAccount = "AnaBal_Account";
    private static final String AnaAssist = "AnaBal_Assist";
    private static final String AnaAmt = "AnaBal_CompareAmt";
    private static final String AnaQty = "AnaBal_CompareQty";
    private static final String AnaPNL = "AnaBal_ComparePNL";
    private static final String MaxSize = "AnaBal_MaxSize";

    private List<PeriodInfo> getAnaHistorys(Context ctx, PeriodInfo target, PeriodInfo min, int count) throws BOSException, EASBizException {
        ArrayList<PeriodInfo> periods = new ArrayList<PeriodInfo>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select \n");
            sql.append("    FID, FNumber, FPeriodYear, FPeriodNumber, FIsAdjustPeriod \n");
            sql.append("from T_BD_Period \n");
            sql.append("where FTypeID = ? \n");
            sql.append("    and FNumber < ? \n");
            sql.append("    and FNumber >= ? \n");
            sql.append("order by FNumber desc \n");
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, target.getPeriodType().getId().toString());
            pstmt.setInt(index++, target.getNumber());
            pstmt.setInt(index++, min.getNumber());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                PeriodInfo period = new PeriodInfo();
                period.setId(BOSUuid.read((String)rs.getString("FID")));
                period.setNumber(rs.getInt("FNumber"));
                period.setPeriodYear(rs.getInt("FPeriodYear"));
                period.setPeriodNumber(rs.getInt("FPeriodNumber"));
                period.setIsAdjustPeriod(rs.getBoolean("FIsAdjustPeriod"));
                periods.add(period);
                if (periods.size() < count) continue;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return periods;
    }

    private List<PeriodInfo> getAnaFutures(Context ctx, PeriodInfo target, int count) throws BOSException, EASBizException {
        ArrayList<PeriodInfo> periods = new ArrayList<PeriodInfo>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select \n");
            sql.append("    FID, FNumber, FPeriodYear, FPeriodNumber, FIsAdjustPeriod \n");
            sql.append("from T_BD_Period \n");
            sql.append("where FTypeID = ? \n");
            sql.append("    and FNumber > ? \n");
            sql.append("order by FNumber asc \n");
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, target.getPeriodType().getId().toString());
            pstmt.setInt(index++, target.getNumber());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                PeriodInfo period = new PeriodInfo();
                period.setId(BOSUuid.read((String)rs.getString("FID")));
                period.setNumber(rs.getInt("FNumber"));
                period.setPeriodYear(rs.getInt("FPeriodYear"));
                period.setPeriodNumber(rs.getInt("FPeriodNumber"));
                period.setIsAdjustPeriod(rs.getBoolean("FIsAdjustPeriod"));
                periods.add(period);
                if (periods.size() < count) continue;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return periods;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object _analysis(Context ctx, String companyId, Map params) throws BOSException, EASBizException {
        int iPeriod;
        boolean isUseRpt;
        try {
            Object value = GlUtils.getParamByKey(ctx, null, "G001");
            isUseRpt = Boolean.valueOf(value.toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"G001"});
        }
        params.put("isUseRpt", isUseRpt);
        if (this.isForRepair(params)) {
            params.put("AnaBal_ShowName", false);
        }
        GLBalanceFacadeFactory.getLocalInstance(ctx).updateVoucherBalance(new String[]{companyId});
        HashMap<String, Object> result = new HashMap<String, Object>();
        LinkedList errors = new LinkedList();
        result.put("errors", errors);
        PeriodInfo current = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo start = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
        if (current == null) return result;
        if (start == null) {
            return result;
        }
        int cyType = (Integer)params.get(AnaCurrency);
        boolean local = (cyType & 2) != 0;
        boolean report = (cyType & 4) != 0 && isUseRpt;
        Boolean showName = (Boolean)params.get("AnaBal_ShowName");
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("accountTable.id");
        selector.add("accountTable.number");
        if (showName.booleanValue()) {
            selector.add("name");
            selector.add("accountTable.name");
        }
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
        params.put("company", company);
        List<Object> periods = new ArrayList<PeriodInfo>();
        Integer iHistory = (Integer)params.get("AnaBal_Historys");
        if (iHistory != null) {
            int iTemp;
            if (current.getId().equals((Object)start.getId())) {
                periods.add(current);
                iPeriod = 1;
            } else if (iHistory == 0) {
                periods.add(current);
                PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)current);
                if (prePeriod != null && prePeriod.getNumber() >= start.getNumber()) {
                    periods.add(prePeriod);
                }
                iPeriod = 1;
            } else {
                if (iHistory < 0) {
                    iHistory = 12000;
                }
                iPeriod = (periods = this.getAnaHistorys(ctx, current, start, iHistory + 1)).size() > iHistory ? periods.size() - 1 : periods.size();
                periods.add(0, current);
                ++iPeriod;
            }
            int iFuture = 0;
            if (params.get("AnaBal_Futures") != null && (iTemp = ((Integer)params.get("AnaBal_Futures")).intValue()) > 0) {
                iFuture = iTemp;
            }
            if (iFuture > 0) {
                List<PeriodInfo> futures = this.getAnaFutures(ctx, current, iFuture);
                for (PeriodInfo p : futures) {
                    periods.add(0, p);
                }
                iPeriod += futures.size();
            }
        } else {
            PeriodInfo periodFrom = (PeriodInfo)params.get("periodFrom");
            PeriodInfo periodTo = (PeriodInfo)params.get("periodTo");
            periodFrom.setPeriodType(current.getPeriodType());
            periodTo.setPeriodType(current.getPeriodType());
            if (start.getNumber() > periodFrom.getNumber()) {
                periodFrom = start;
            }
            if (periodFrom.getNumber() != periodTo.getNumber()) {
                periods = this.getAnaHistorys(ctx, periodTo, periodFrom, 12000);
            }
            iPeriod = periods.size();
            periods.add(0, periodTo);
            ++iPeriod;
            PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)periodFrom);
            if (prePeriod != null && prePeriod.getNumber() >= start.getNumber()) {
                periods.add(prePeriod);
            }
        }
        String T_TMP_Account = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            Set accountNumbers = (Set)params.get("accountNumbers");
            Set<Object> accountIds = new HashSet();
            Set<Object> leafAccountIds = new HashSet();
            if (accountNumbers != null && accountNumbers.size() > 0) {
                Set<String> tableIds = GLBalanceAnaFacadeControllerBean.getAccountTableIds(ctx, company, params);
                Map<String, Set<String>> map = GLBalanceAnaFacadeControllerBean.getAccountIds(ctx, companyId, tableIds, (Set<String>)accountNumbers);
                accountIds = map.get("accountIds");
                leafAccountIds = map.get("leafAccountIds");
                if (accountIds.size() == 0 || leafAccountIds.size() == 0) {
                    result.put("message", this.getResource(ctx, "accountView_error"));
                    HashMap<String, Object> hashMap = result;
                    return hashMap;
                }
                if (accountIds.size() > 200) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("create table T_TMP_Account ( ");
                    sql.append("  FID                VARCHAR(44), ");
                    sql.append("  FIsLeaf            int DEFAULT 0 ");
                    sql.append(") ");
                    T_TMP_Account = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
                    params.put("T_TMP_Account", T_TMP_Account);
                    sql.setLength(0);
                    sql.append("insert into " + T_TMP_Account + " (FID, FIsLeaf) values (?, ?)");
                    conn = EJBFactory.getConnection((Context)ctx);
                    pstmt = conn.prepareStatement(sql.toString());
                    for (String string : accountIds) {
                        pstmt.setString(1, string);
                        pstmt.setInt(2, leafAccountIds.contains(string) ? 1 : 0);
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                    pstmt.close();
                    conn.close();
                    TempTablePool.getInstance((Context)ctx).createIndex(T_TMP_Account, "FID, FIsLeaf", true, false);
                    accountIds.clear();
                    leafAccountIds.clear();
                }
            }
            params.put("accountIds", accountIds);
            params.put("leafAccountIds", leafAccountIds);
            Integer maxSize = (Integer)params.get(MaxSize);
            for (int i = 0; i < iPeriod; ++i) {
                PeriodInfo period = (PeriodInfo)periods.get(i);
                PeriodInfo prePeriod = null;
                if (i + 1 < periods.size()) {
                    prePeriod = (PeriodInfo)periods.get(i + 1);
                }
                params.put("AnaBal_SubSize", maxSize - errors.size());
                params.put("AnaBal_Future", period.getNumber() > current.getNumber());
                int n = 3;
                if (period.getNumber() < current.getNumber()) {
                    n = 1;
                    if (period.getNumber() == start.getNumber()) {
                        n = 11;
                    }
                } else if (period.getNumber() == current.getNumber()) {
                    n = 2;
                    if (period.getNumber() == start.getNumber()) {
                        n = 21;
                    }
                }
                period.put("anaPt", (Object)n);
                List sub = (List)this.analysisPeriod(ctx, companyId, period, prePeriod, params);
                errors.addAll(sub);
                if (errors.size() >= maxSize) break;
            }
            String companyInfo = company.getNumber();
            if (showName.booleanValue()) {
                companyInfo = companyInfo + "-" + company.getName();
            }
            String accountTableInfo = "";
            if (company.getAccountTable() != null) {
                accountTableInfo = company.getAccountTable().getNumber();
                if (showName.booleanValue()) {
                    accountTableInfo = accountTableInfo + "-" + company.getAccountTable().getName();
                }
            }
            result.put("company", companyInfo);
            result.put("startPeriod", start.getNumber());
            result.put("currentPeriod", current.getNumber());
            result.put("currentAccountTable", accountTableInfo);
            if (showName.booleanValue() && (local || report)) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
                selectorItemCollection.add("id");
                selectorItemCollection.add("number");
                selectorItemCollection.add("name");
                view.setSelector(selectorItemCollection);
                FilterInfo filter = new FilterInfo();
                HashSet ids = new HashSet();
                ids.add("11111111-1111-1111-1111-111111111111DEB58FDC");
                ids.add("22222222-2222-2222-2222-222222222222DEB58FDC");
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
                view.setFilter(filter);
                CurrencyCollection cys = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
                String localInfo = "GLC";
                String reportInfo = "GRC";
                for (int i = 0; i < cys.size(); ++i) {
                    if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cys.get(i).getId().toString())) {
                        localInfo = localInfo + "-" + cys.get(i).getName();
                        continue;
                    }
                    if (!"22222222-2222-2222-2222-222222222222DEB58FDC".equals(cys.get(i).getId().toString())) continue;
                    reportInfo = reportInfo + "-" + cys.get(i).getName();
                }
                for (Map item : errors) {
                    if ("GLC".equals(item.get("currency"))) {
                        item.put("currency", localInfo);
                        continue;
                    }
                    if (!"GRC".equals(item.get("currency"))) continue;
                    item.put("currency", reportInfo);
                }
            }
            if (this.isForRepair(params) && errors.size() > 0) {
                int n;
                HashSet<String> accNumbers = new HashSet<String>();
                int n2 = 999913;
                int iperiodto = 0;
                for (Map row : errors) {
                    String account;
                    int period = (Integer)row.get("period");
                    if (period > iperiodto) {
                        iperiodto = period;
                    }
                    if (period < n) {
                        n = period;
                    }
                    if ((account = (String)row.get("account")) == null || account.length() == 0) {
                        result.put("message", "\u79d1\u76ee\u6216\u5176\u7f16\u7801\u4e22\u5931\uff0c\u65e0\u6cd5\u4fee\u590d\u3002");
                        HashMap<String, Object> hashMap = result;
                        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
                        if (T_TMP_Account == null) return hashMap;
                        TempTablePool.getInstance((Context)ctx).releaseTable(T_TMP_Account);
                        return hashMap;
                    }
                    accNumbers.add(account);
                }
                if (iperiodto < current.getNumber()) {
                    iperiodto = current.getNumber();
                }
                HashMap<String, Object> rparams = new HashMap<String, Object>();
                rparams.put("companyId", company.getId().toString());
                rparams.put("accountNumbers", accNumbers);
                PeriodInfo periodfrom = new PeriodInfo();
                periodfrom.setNumber(n);
                rparams.put("periodfrom", periodfrom);
                PeriodInfo periodto = new PeriodInfo();
                periodto.setNumber(iperiodto);
                rparams.put("periodto", periodto);
                rparams.put("repairAccount", true);
                rparams.put("repairAssist", true);
                rparams.put("repairMeasure", true);
                rparams.put("onlyClean", false);
                rparams.put("isNeedRepair", true);
                HashMap<String, Object> hashMap = rparams;
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
                if (T_TMP_Account == null) return hashMap;
                TempTablePool.getInstance((Context)ctx).releaseTable(T_TMP_Account);
                return hashMap;
            }
            SQLUtils.cleanup(pstmt, conn);
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (T_TMP_Account == null) return result;
        TempTablePool.getInstance((Context)ctx).releaseTable(T_TMP_Account);
        return result;
        finally {
            SQLUtils.cleanup(pstmt, conn);
            if (T_TMP_Account != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(T_TMP_Account);
            }
        }
    }

    private static List<Map<String, Object>> getAccountRefConstrasts(Context ctx, String companyId, PeriodInfo startPeriod) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("  p.FNumber FPeriodNumber, c.FDisabledAcctTableID \n");
        sql.append("from T_bd_AcctRefContrast c \n");
        sql.append("join T_bd_Period p on p.FID = c.FEnabledPeriodID \n");
        sql.append("where c.FCompanyID = ? \n");
        sql.append("  and FRefType = 1 \n");
        sql.append("  and FIsEnabled = 1 \n");
        sql.append("  and p.FNumber >= ? \n");
        sql.append("order by p.FNumber \n");
        ArrayList<Map<String, Object>> constrasts = new ArrayList<Map<String, Object>>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, startPeriod.getNumber()});
        try {
            while (rs.next()) {
                HashMap<String, Object> constrast = new HashMap<String, Object>();
                constrast.put("periodNumber", rs.getInt("FPeriodNumber"));
                constrast.put("disableAcctTableID", rs.getString("FDisabledAcctTableID"));
                constrasts.add(constrast);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return constrasts;
    }

    private static Set<String> getAccountTableIds(Context ctx, CompanyOrgUnitInfo company, Map params) throws BOSException {
        HashSet<String> ids = new HashSet<String>();
        ids.add(company.getAccountTable().getId().toString());
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("  c.FDisabledAcctTableID \n");
        sql.append("from T_bd_AcctRefContrast c \n");
        sql.append("where c.FCompanyID = ? \n");
        sql.append("  and FRefType = 1 \n");
        sql.append("  and FIsEnabled = 1 \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{company.getId().toString()});
        try {
            while (rs.next()) {
                ids.add(rs.getString("FDisabledAcctTableID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ids;
    }

    private static Map<String, Set<String>> getAccountIds(Context ctx, String companyId, String tableId, Set<String> accountNumbers) throws BOSException {
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("  rav.FID, rav.FNumber, rav.FIsLeaf \n");
        sql.append("from T_BD_AccountView av \n");
        sql.append("JOIN T_BD_AccountView rav \n");
        sql.append("  on rav.FCompanyID = av.FCompanyID and rav.FAccountTableID = av.FAccountTableID \n");
        if (SQLUtil.isOracle(ctx) || SQLUtil.isMSSQLSERVER(ctx) || SQLUtil.isPG(ctx)) {
            sql.append("  and (rav.fid = av.fid or av.flongnumber like concat(rav.flongnumber,'!%') or rav.flongnumber like concat(av.flongnumber,'!%')) \n");
        } else {
            sql.append("  and (rav.fid = av.fid or charindex(rav.flongnumber||'!',av.flongnumber) = 1 or charindex(av.flongnumber||'!',rav.flongnumber) = 1) \n");
        }
        sql.append("where av.FCompanyID = ? \n");
        sql.append("  and av.FAccountTableID = ? \n");
        params.add(companyId);
        params.add(tableId);
        if (accountNumbers.size() == 1) {
            sql.append("  and av.FNumber = ? \n");
        } else {
            sql.append("  and av.FNumber in " + SQLUtil.buildMarkSQL(accountNumbers.size()) + " \n");
        }
        params.addAll(accountNumbers);
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        HashSet<String> accountIds = new HashSet<String>();
        HashSet<String> leafAccountIds = new HashSet<String>();
        result.put("accountIds", accountIds);
        result.put("leafAccountIds", leafAccountIds);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                accountIds.add(rs.getString("FID"));
                if (rs.getInt("FIsLeaf") != 1) continue;
                leafAccountIds.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private static Map<String, Set<String>> getAccountIds(Context ctx, String companyId, Set<String> tableIds, Set<String> accountNumbers) throws BOSException {
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("  rav.FID, rav.FNumber, rav.FIsLeaf \n");
        sql.append("from T_BD_AccountView av \n");
        sql.append("JOIN T_BD_AccountView rav \n");
        sql.append("  on rav.FCompanyID = av.FCompanyID and rav.FAccountTableID = av.FAccountTableID \n");
        if (SQLUtil.isOracle(ctx) || SQLUtil.isMSSQLSERVER(ctx) || SQLUtil.isPG(ctx)) {
            sql.append("  and (rav.fid = av.fid or av.flongnumber like concat(rav.flongnumber,'!%') or rav.flongnumber like concat(av.flongnumber,'!%')) \n");
        } else {
            sql.append("  and (rav.fid = av.fid or charindex(rav.flongnumber||'!',av.flongnumber) = 1 or charindex(av.flongnumber||'!',rav.flongnumber) = 1) \n");
        }
        sql.append("where av.FCompanyID = ? \n");
        params.add(companyId);
        if (tableIds.size() == 1) {
            sql.append("  and av.FAccountTableID = ? \n");
        } else {
            sql.append("  and av.FAccountTableID in " + SQLUtil.buildMarkSQL(tableIds.size()) + " \n");
        }
        params.addAll(tableIds);
        if (accountNumbers.size() == 1) {
            sql.append("  and av.FNumber = ? \n");
        } else {
            sql.append("  and av.FNumber in " + SQLUtil.buildMarkSQL(accountNumbers.size()) + " \n");
        }
        params.addAll(accountNumbers);
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        HashSet<String> accountIds = new HashSet<String>();
        HashSet<String> leafAccountIds = new HashSet<String>();
        result.put("accountIds", accountIds);
        result.put("leafAccountIds", leafAccountIds);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                accountIds.add(rs.getString("FID"));
                if (rs.getInt("FIsLeaf") != 1) continue;
                leafAccountIds.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private static Map<String, Set<String>> getAccountIds(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, Set<String> accountNumbers, List<Map<String, Object>> constrasts, Map<String, Map<String, Set<String>>> cache) throws BOSException {
        HashSet accountIds = new HashSet();
        HashSet leafAccountIds = new HashSet();
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        result.put("accountIds", accountIds);
        result.put("leafAccountIds", leafAccountIds);
        if (accountNumbers == null || accountNumbers.size() == 0) {
            return result;
        }
        if (constrasts == null || constrasts.size() == 0) {
            Map<String, Set<String>> iResult = cache.get(company.getAccountTable().getId().toString());
            if (iResult == null) {
                iResult = GLBalanceAnaFacadeControllerBean.getAccountIds(ctx, company.getId().toString(), company.getAccountTable().getId().toString(), accountNumbers);
                cache.put(company.getAccountTable().getId().toString(), iResult);
            }
            return iResult;
        }
        for (int cIndex = 0; cIndex < constrasts.size(); ++cIndex) {
            Map<String, Object> constrast = constrasts.get(cIndex);
            int periodNumber = (Integer)constrast.get("periodNumber");
            if (periodNumber < period.getNumber()) continue;
            String disableAcctTableID = (String)constrast.get("disableAcctTableID");
            Map<String, Set<String>> iResult = cache.get(disableAcctTableID);
            if (iResult == null) {
                iResult = GLBalanceAnaFacadeControllerBean.getAccountIds(ctx, company.getId().toString(), disableAcctTableID, accountNumbers);
                cache.put(disableAcctTableID, iResult);
            }
            if (periodNumber > period.getNumber()) {
                return iResult;
            }
            accountIds.addAll(iResult.get("accountIds"));
            leafAccountIds.addAll(iResult.get("leafAccountIds"));
            if (cIndex + 1 >= constrasts.size()) break;
            constrast = constrasts.get(cIndex + 1);
            disableAcctTableID = (String)constrast.get("disableAcctTableID");
            Map<String, Set<String>> iiResult = cache.get(disableAcctTableID);
            if (iiResult == null) {
                iiResult = GLBalanceAnaFacadeControllerBean.getAccountIds(ctx, company.getId().toString(), disableAcctTableID, accountNumbers);
                cache.put(disableAcctTableID, iiResult);
            }
            accountIds.addAll(iiResult.get("accountIds"));
            leafAccountIds.addAll(iiResult.get("leafAccountIds"));
            break;
        }
        return result;
    }

    private static String toInSql(Set ids) {
        StringBuffer sql = new StringBuffer();
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            Object o;
            if (sql.length() > 0) {
                sql.append(",");
            }
            if ((o = it.next()) instanceof String) {
                sql.append("'").append(o).append("'");
                continue;
            }
            sql.append(o);
        }
        return "(" + sql.toString() + ")";
    }

    protected Object analysisPeriod(Context ctx, String companyId, PeriodInfo period, PeriodInfo prePeriod, Map params) throws BOSException, EASBizException {
        Set accountIds = (Set)params.get("accountIds");
        Set leafAccountIds = (Set)params.get("leafAccountIds");
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        try {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.get("company");
            Boolean anaPosted = (Boolean)params.get(AnaPosted);
            Boolean anaUnPost = (Boolean)params.get(AnaUnPost);
            Boolean anaBegin = (Boolean)params.get(AnaBegin);
            Boolean future = (Boolean)params.get("AnaBal_Future");
            if (future != null && future.booleanValue()) {
                anaBegin = false;
            }
            Boolean anaCurrent = (Boolean)params.get(AnaCurrent);
            boolean isUseRpt = (Boolean)params.get("isUseRpt");
            int cyType = (Integer)params.get(AnaCurrency);
            boolean origin = (cyType & 1) != 0;
            boolean local = (cyType & 2) != 0;
            boolean report = (cyType & 4) != 0 && isUseRpt;
            Boolean showName = (Boolean)params.get("AnaBal_ShowName");
            Boolean anaAccount = (Boolean)params.get(AnaAccount);
            Boolean anaAssist = (Boolean)params.get(AnaAssist);
            Boolean compareAmt = (Boolean)params.get(AnaAmt);
            Boolean compareQty = (Boolean)params.get(AnaQty);
            Boolean comparePNL = (Boolean)params.get(AnaPNL);
            int compareType = 3;
            if (((Boolean)params.get("AnaBal_CompareFwd")).booleanValue()) {
                compareType = 1;
            } else if (((Boolean)params.get("AnaBal_CompareRev")).booleanValue()) {
                compareType = 2;
            }
            Integer maxSize = (Integer)params.get("AnaBal_SubSize");
            boolean isForRepair = this.isForRepair(params);
            if (anaPosted.booleanValue()) {
                if (anaAccount.booleanValue()) {
                    if (anaBegin.booleanValue()) {
                        if (origin) {
                            if (compareType == 3) {
                                this.fullAnalysisAccountBegin(ctx, params, company, period, prePeriod, accountIds, 5, null, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountBegin(ctx, params, company, period, prePeriod, accountIds, 5, null, compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (local) {
                            if (compareType == 3) {
                                this.fullAnalysisAccountBegin(ctx, params, company, period, prePeriod, accountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountBegin(ctx, params, company, period, prePeriod, accountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (report) {
                            if (compareType == 3) {
                                this.fullAnalysisAccountBegin(ctx, params, company, period, prePeriod, accountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountBegin(ctx, params, company, period, prePeriod, accountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                    }
                    if (anaCurrent.booleanValue()) {
                        if (origin) {
                            if (compareType == 3) {
                                this.fullAnalysisAccountCurrent(ctx, params, company, period, leafAccountIds, 5, null, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                                this.analysisParentAccountCurrent(ctx, params, company, period, accountIds, 5, null, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountCurrent(ctx, params, company, period, leafAccountIds, 5, null, compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (local) {
                            if (compareType == 3) {
                                this.fullAnalysisAccountCurrent(ctx, params, company, period, leafAccountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                                this.analysisParentAccountCurrent(ctx, params, company, period, accountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountCurrent(ctx, params, company, period, leafAccountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (report) {
                            if (compareType == 3) {
                                this.fullAnalysisAccountCurrent(ctx, params, company, period, leafAccountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                                this.analysisParentAccountCurrent(ctx, params, company, period, accountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountCurrent(ctx, params, company, period, leafAccountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                    }
                }
                if (anaAssist.booleanValue()) {
                    if (anaBegin.booleanValue()) {
                        if (origin) {
                            if (compareType == 3) {
                                this.fullAnalysisAssistBegin(ctx, params, company, period, prePeriod, accountIds, 5, null, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistBegin(ctx, params, company, period, prePeriod, accountIds, 5, null, compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (local) {
                            if (compareType == 3) {
                                this.fullAnalysisAssistBegin(ctx, params, company, period, prePeriod, accountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistBegin(ctx, params, company, period, prePeriod, accountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (report) {
                            if (compareType == 3) {
                                this.fullAnalysisAssistBegin(ctx, params, company, period, prePeriod, accountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistBegin(ctx, params, company, period, prePeriod, accountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                    }
                    if (anaCurrent.booleanValue()) {
                        if (origin) {
                            if (compareType == 3) {
                                this.fullAnalysisAssistCurrent(ctx, params, company, period, accountIds, 5, null, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistCurrent(ctx, params, company, period, accountIds, 5, null, compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (local) {
                            if (compareType == 3) {
                                this.fullAnalysisAssistCurrent(ctx, params, company, period, accountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistCurrent(ctx, params, company, period, accountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (report) {
                            if (compareType == 3) {
                                this.fullAnalysisAssistCurrent(ctx, params, company, period, accountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistCurrent(ctx, params, company, period, accountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                    }
                }
            }
            if (anaUnPost.booleanValue()) {
                if (anaAccount.booleanValue()) {
                    if (anaBegin.booleanValue()) {
                        if (origin) {
                            if (compareType == 3) {
                                this.fullAnalysisAccountBegin(ctx, params, company, period, prePeriod, accountIds, 1, null, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountBegin(ctx, params, company, period, prePeriod, accountIds, 1, null, compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (local) {
                            if (compareType == 3) {
                                this.fullAnalysisAccountBegin(ctx, params, company, period, prePeriod, accountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountBegin(ctx, params, company, period, prePeriod, accountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (report) {
                            if (compareType == 3) {
                                this.fullAnalysisAccountBegin(ctx, params, company, period, prePeriod, accountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountBegin(ctx, params, company, period, prePeriod, accountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                    }
                    if (anaCurrent.booleanValue()) {
                        if (origin) {
                            if (compareType == 3) {
                                this.fullAnalysisAccountCurrent(ctx, params, company, period, leafAccountIds, 1, null, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                                this.analysisParentAccountCurrent(ctx, params, company, period, accountIds, 1, null, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountCurrent(ctx, params, company, period, leafAccountIds, 1, null, compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (local) {
                            if (compareType == 3) {
                                this.fullAnalysisAccountCurrent(ctx, params, company, period, leafAccountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                                this.analysisParentAccountCurrent(ctx, params, company, period, accountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountCurrent(ctx, params, company, period, leafAccountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (report) {
                            if (compareType == 3) {
                                this.fullAnalysisAccountCurrent(ctx, params, company, period, leafAccountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                                this.analysisParentAccountCurrent(ctx, params, company, period, accountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAccountCurrent(ctx, params, company, period, leafAccountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                    }
                }
                if (anaAssist.booleanValue()) {
                    if (anaBegin.booleanValue()) {
                        if (origin) {
                            if (compareType == 3) {
                                this.fullAnalysisAssistBegin(ctx, params, company, period, prePeriod, accountIds, 1, null, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistBegin(ctx, params, company, period, prePeriod, accountIds, 1, null, compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (local) {
                            if (compareType == 3) {
                                this.fullAnalysisAssistBegin(ctx, params, company, period, prePeriod, accountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistBegin(ctx, params, company, period, prePeriod, accountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (report) {
                            if (compareType == 3) {
                                this.fullAnalysisAssistBegin(ctx, params, company, period, prePeriod, accountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistBegin(ctx, params, company, period, prePeriod, accountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                    }
                    if (anaCurrent.booleanValue()) {
                        if (origin) {
                            if (compareType == 3) {
                                this.fullAnalysisAssistCurrent(ctx, params, company, period, accountIds, 1, null, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistCurrent(ctx, params, company, period, accountIds, 1, null, compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (local) {
                            if (compareType == 3) {
                                this.fullAnalysisAssistCurrent(ctx, params, company, period, accountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistCurrent(ctx, params, company, period, accountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                        if (report) {
                            if (compareType == 3) {
                                this.fullAnalysisAssistCurrent(ctx, params, company, period, accountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            } else {
                                this.analysisAssistCurrent(ctx, params, company, period, accountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", compareType, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
                            }
                            if (result.size() >= maxSize) {
                                return result;
                            }
                        }
                    }
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAccountBegin(Context ctx, Map params, CompanyOrgUnitInfo company, PeriodInfo period, PeriodInfo prePeriod, Set<String> accountIds, int balType, String cyId, int compareType, boolean compareAmt, boolean compareQty, boolean showName, List<Map<String, Object>> result, int maxSize, boolean isForRepair) throws BOSException, SQLException {
        if (prePeriod == null) {
            this.analysisAccountStart(ctx, params, company, period, accountIds, balType, cyId, compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
            return;
        }
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cyName = "";
            String avName = "";
            String atName = "";
            if (showName) {
                cyName = "|| '-' || cy.FName_" + loc;
                avName = "|| '-' || av.FName_" + loc;
                atName = "|| '-' || at.FName_" + loc;
            }
            boolean isOracle = SQLUtil.isOracle(ctx);
            sql.append("select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    cy.FNumber " + cyName + " currency, \n");
                }
                sql.append("    at.FNumber " + atName + " accountTable, \n");
                sql.append("    isnull(cur.FBeginBalance" + suffix + ", 0) curBegAmount, isnull(pre.FEndBalance" + suffix + ", 0) preEndAmount, \n");
                sql.append("    isnull(cur.FBeginQty, 0) curBegQty, isnull(pre.FEndQty, 0) preEndQty, \n");
            }
            sql.append("    av.FNumber " + avName + " account \n");
            if (compareType == 1) {
                sql.append("from " + GLBalanceUtils.getAccountBalanceTable(balType, cyId) + " cur \n");
                sql.append("join T_BD_AccountView av on av.FID = cur.FAccountID \n");
                if (T_TMP_Account != null) {
                    sql.append("join " + T_TMP_Account + " tav on tav.FID = cur.FAccountID \n");
                }
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = cur.FCurrencyID \n");
                    }
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join " + GLBalanceUtils.getAccountBalanceTable(balType, cyId) + " pre \n");
                sql.append("    on cur.FOrgUnitID = pre.FOrgUnitID \n");
                sql.append("    and pre.FPeriod = ? \n");
                sql.append("    and cur.FAccountID = pre.FAccountID \n");
                if (cyId == null) {
                    sql.append("    and cur.FCurrencyID = pre.FCurrencyID \n");
                }
                sql.append("where cur.FOrgUnitID = ? \n");
                sql.append("    and cur.FPeriod = ? \n");
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and cur.FAccountID = ? \n");
                    } else {
                        sql.append("  and cur.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            } else {
                sql.append("from " + GLBalanceUtils.getAccountBalanceTable(balType, cyId) + " pre \n");
                sql.append("join T_BD_AccountView av on av.FID = pre.FAccountID \n");
                if (T_TMP_Account != null) {
                    sql.append("join " + T_TMP_Account + " tav on tav.FID = pre.FAccountID \n");
                }
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = pre.FCurrencyID \n");
                    }
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join " + GLBalanceUtils.getAccountBalanceTable(balType, cyId) + " cur \n");
                sql.append("    on cur.FOrgUnitID = pre.FOrgUnitID \n");
                sql.append("    and cur.FPeriod = ? \n");
                sql.append("    and cur.FAccountID = pre.FAccountID \n");
                if (cyId == null) {
                    sql.append("    and cur.FCurrencyID = pre.FCurrencyID \n");
                }
                sql.append("where pre.FOrgUnitID = ? \n");
                sql.append("    and pre.FPeriod = ? \n");
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and pre.FAccountID = ? \n");
                    } else {
                        sql.append("  and pre.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            }
            if (compareAmt && compareQty) {
                sql.append("    and ( \n");
                sql.append("        isnull(cur.FBeginBalance" + suffix + ", 0) <> isnull(pre.FEndBalance" + suffix + ", 0) \n");
                sql.append("        or \n");
                sql.append("        isnull(cur.FBeginQty, 0) <> isnull(pre.FEndQty, 0) \n");
                sql.append("    ) \n");
            } else if (compareAmt) {
                sql.append("    and isnull(cur.FBeginBalance" + suffix + ", 0) <> isnull(pre.FEndBalance" + suffix + ", 0) \n");
            } else if (compareQty) {
                sql.append("    and isnull(cur.FBeginQty, 0) <> isnull(pre.FEndQty, 0) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            if (compareType == 1) {
                pstmt.setInt(index++, prePeriod.getNumber());
                pstmt.setString(index++, company.getId().toString());
                pstmt.setInt(index++, period.getNumber());
            } else {
                pstmt.setInt(index++, period.getNumber());
                pstmt.setString(index++, company.getId().toString());
                pstmt.setInt(index++, prePeriod.getNumber());
            }
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 1);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("curBegAmount", rs.getString("curBegAmount"));
                item.put("preEndAmount", rs.getString("preEndAmount"));
                item.put("curBegQty", rs.getString("curBegQty"));
                item.put("preEndQty", rs.getString("preEndQty"));
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullAnalysisAccountBegin(Context ctx, Map params, CompanyOrgUnitInfo company, PeriodInfo period, PeriodInfo prePeriod, Set<String> accountIds, int balType, String cyId, boolean compareAmt, boolean compareQty, boolean showName, List<Map<String, Object>> result, int maxSize, boolean isForRepair) throws BOSException, SQLException {
        if (prePeriod == null) {
            this.fullAnalysisAccountStart(ctx, params, company, period, accountIds, balType, cyId, compareAmt, compareQty, showName, result, maxSize, isForRepair);
            return;
        }
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cy1Name = "";
            String av1Name = "";
            String at1Name = "";
            String cy2Name = "";
            String av2Name = "";
            String at2Name = "";
            if (showName) {
                cy1Name = "|| '-' || cy1.FName_" + loc;
                av1Name = "|| '-' || av1.FName_" + loc;
                at1Name = "|| '-' || at1.FName_" + loc;
                cy2Name = "|| '-' || cy2.FName_" + loc;
                av2Name = "|| '-' || av2.FName_" + loc;
                at2Name = "|| '-' || at2.FName_" + loc;
            }
            boolean isOracle = SQLUtil.isOracle(ctx);
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    case when cy1.FID is not null then cy1.FNumber " + cy1Name + " else cy2.FNumber " + cy2Name + " end currency, \n");
                }
                sql.append("    case when at1.FID is not null then at1.FNumber " + at1Name + " else at2.FNumber " + at2Name + " end accountTable, \n");
                sql.append("    isnull(cur.FBeginBalance" + suffix + ", 0) curBegAmount, isnull(pre.FEndBalance" + suffix + ", 0) preEndAmount, \n");
                sql.append("    isnull(cur.FBeginQty, 0) curBegQty, isnull(pre.FEndQty, 0) preEndQty, \n");
            }
            sql.append("    case when av1.FID is not null then av1.FNumber " + av1Name + " else av2.FNumber " + av2Name + " end account \n");
            sql.append("from ( \n");
            sql.append("    select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            sql.append("        b.FAccountID, \n");
            if (cyId == null) {
                sql.append("        b.FCurrencyID, \n");
            }
            sql.append("        b.FBeginBalance" + suffix + ", b.FBeginQty \n");
            sql.append("    from " + GLBalanceUtils.getAccountBalanceTable(balType, cyId) + " b \n");
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = b.FAccountID \n");
            }
            sql.append("    where b.FOrgUnitID = ? and b.FPeriod = ? \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("        and b.FAccountID = ? \n");
                } else {
                    sql.append("        and b.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") cur \n");
            sql.append("full join ( \n");
            sql.append("    select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            sql.append("        b.FAccountID, \n");
            if (cyId == null) {
                sql.append("        b.FCurrencyID, \n");
            }
            sql.append("        b.FEndBalance" + suffix + ", b.FEndQty \n");
            sql.append("    from " + GLBalanceUtils.getAccountBalanceTable(balType, cyId) + " b \n");
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = b.FAccountID \n");
            }
            sql.append("    where b.FOrgUnitID = ? and b.FPeriod = ? \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("        and b.FAccountID = ? \n");
                } else {
                    sql.append("        and b.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") pre on cur.FAccountID = pre.FAccountID \n");
            if (cyId == null) {
                sql.append("    and cur.FCurrencyID = pre.FCurrencyID \n");
            }
            sql.append("left join T_BD_AccountView av1 on av1.FID = cur.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at1 on at1.fid = av1.FACCOUNTTABLEID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy1 on cy1.FID = cur.FCurrencyID \n");
                }
            }
            sql.append("left join T_BD_AccountView av2 on av2.FID = pre.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at2 on at2.fid = av2.FACCOUNTTABLEID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy2 on cy2.FID = pre.FCurrencyID \n");
                }
            }
            if (compareAmt && compareQty) {
                sql.append("where ( \n");
                sql.append("    isnull(cur.FBeginBalance" + suffix + ", 0) <> isnull(pre.FEndBalance" + suffix + ", 0) \n");
                sql.append("    or \n");
                sql.append("    isnull(cur.FBeginQty, 0) <> isnull(pre.FEndQty, 0) \n");
                sql.append(") \n");
            } else if (compareAmt) {
                sql.append("where isnull(cur.FBeginBalance" + suffix + ", 0) <> isnull(pre.FEndBalance" + suffix + ", 0) \n");
            } else if (compareQty) {
                sql.append("where isnull(cur.FBeginQty, 0) <> isnull(pre.FEndQty, 0) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, company.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, company.getId().toString());
            pstmt.setInt(index++, prePeriod.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 1);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("curBegAmount", rs.getString("curBegAmount"));
                item.put("preEndAmount", rs.getString("preEndAmount"));
                item.put("curBegQty", rs.getString("curBegQty"));
                item.put("preEndQty", rs.getString("preEndQty"));
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAccountStart(Context ctx, Map params, CompanyOrgUnitInfo company, PeriodInfo period, Set<String> accountIds, int balType, String cyId, int compareType, boolean compareAmt, boolean compareQty, boolean showName, List<Map<String, Object>> result, int maxSize, boolean isForRepair) throws BOSException, SQLException {
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cyName = "";
            String avName = "";
            String atName = "";
            if (showName) {
                cyName = "|| '-' || cy.FName_" + loc;
                avName = "|| '-' || av.FName_" + loc;
                atName = "|| '-' || at.FName_" + loc;
            }
            boolean isOracle = SQLUtil.isOracle(ctx);
            sql.append("select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    cy.FNumber " + cyName + " currency, \n");
                }
                sql.append("    at.FNumber " + atName + " accountTable, \n");
                sql.append("    isnull(b.FBeginBalance" + suffix + ", 0) curBegAmount, isnull(ib.FBeginBalance" + suffix + "*av.fdc, 0) preEndAmount, \n");
                sql.append("    isnull(b.FBeginQty, 0) curBegQty, isnull(ib.FBeginQty*av.fdc, 0) preEndQty, \n");
            }
            sql.append("    av.FNumber " + avName + " account \n");
            if (compareType == 1) {
                sql.append("from " + GLBalanceUtils.getAccountBalanceTable(balType, cyId) + " b \n");
                sql.append("join T_BD_AccountView av on av.FID = b.FAccountID \n");
                if (T_TMP_Account != null) {
                    sql.append("join " + T_TMP_Account + " tav on tav.FID = b.FAccountID \n");
                }
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = b.FCurrencyID \n");
                    }
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join T_GL_FLAG f \n");
                sql.append("    on f.FOrgUnitID = b.FOrgUnitID and f.FName = 'glinit' \n");
                sql.append("left join T_GL_InitAccountBalance ib \n");
                sql.append("    on ib.FOrgUnitID = b.FOrgUnitID \n");
                sql.append("    and ib.FAccountID = b.FAccountID \n");
                if (cyId == null) {
                    sql.append("    and ib.FCurrencyID = b.FCurrencyID \n");
                } else {
                    sql.append("    and ib.FCurrencyID = '" + cyId + "' \n");
                }
                sql.append("    and f.FValue = 'true' \n");
                sql.append("where b.FOrgUnitID = ? \n");
                sql.append("    and b.FPeriod = ? \n");
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and b.FAccountID = ? \n");
                    } else {
                        sql.append("  and b.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            } else {
                sql.append("from T_GL_InitAccountBalance ib \n");
                sql.append("join T_BD_AccountView av on av.FID = ib.FAccountID \n");
                if (T_TMP_Account != null) {
                    sql.append("join " + T_TMP_Account + " tav on tav.FID = ib.FAccountID \n");
                }
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = ib.FCurrencyID \n");
                    }
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("join T_GL_FLAG f \n");
                sql.append("    on f.FOrgUnitID = ib.FOrgUnitID and f.FName = 'glinit' and f.FValue = 'true' \n");
                sql.append("left join " + GLBalanceUtils.getAccountBalanceTable(balType, cyId) + " b \n");
                sql.append("    on b.FOrgUnitID = ib.FOrgUnitID \n");
                sql.append("    and b.FPeriod = ? \n");
                sql.append("    and b.FAccountID = ib.FAccountID \n");
                if (cyId == null) {
                    sql.append("    and b.FCurrencyID = ib.FCurrencyID \n");
                }
                sql.append("where ib.FOrgUnitID = ? \n");
                if (cyId == null) {
                    sql.append("    and ib.FCurrencyID <> '11111111-1111-1111-1111-111111111111DEB58FDC' \n");
                    sql.append("    and ib.FCurrencyID <> '22222222-2222-2222-2222-222222222222DEB58FDC' \n");
                } else {
                    sql.append("    and ib.FCurrencyID = '" + cyId + "' \n");
                }
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and ib.FAccountID = ? \n");
                    } else {
                        sql.append("  and ib.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            }
            if (compareAmt && compareQty) {
                sql.append("    and ( \n");
                sql.append("        isnull(b.FBeginBalance" + suffix + ", 0) <> isnull(ib.FBeginBalance" + suffix + "*av.fdc, 0) \n");
                sql.append("        or \n");
                sql.append("        isnull(b.FBeginQty, 0) <> isnull(ib.FBeginQty*av.fdc, 0) \n");
                sql.append("    ) \n");
            } else if (compareAmt) {
                sql.append("    and isnull(b.FBeginBalance" + suffix + ", 0) <> isnull(ib.FBeginBalance" + suffix + "*av.fdc, 0) \n");
            } else if (compareQty) {
                sql.append("    and isnull(b.FBeginQty, 0) <> isnull(ib.FBeginQty*av.fdc, 0) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            if (compareType == 1) {
                pstmt.setString(index++, company.getId().toString());
                pstmt.setInt(index++, period.getNumber());
            } else {
                pstmt.setInt(index++, period.getNumber());
                pstmt.setString(index++, company.getId().toString());
            }
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 1);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("curBegAmount", rs.getString("curBegAmount"));
                item.put("preEndAmount", rs.getString("preEndAmount"));
                item.put("curBegQty", rs.getString("curBegQty"));
                item.put("preEndQty", rs.getString("preEndQty"));
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullAnalysisAccountStart(Context ctx, Map params, CompanyOrgUnitInfo company, PeriodInfo period, Set<String> accountIds, int balType, String cyId, boolean compareAmt, boolean compareQty, boolean showName, List<Map<String, Object>> result, int maxSize, boolean isForRepair) throws BOSException, SQLException {
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cy1Name = "";
            String av1Name = "";
            String at1Name = "";
            String cy2Name = "";
            String av2Name = "";
            String at2Name = "";
            if (showName) {
                cy1Name = "|| '-' || cy1.FName_" + loc;
                av1Name = "|| '-' || av1.FName_" + loc;
                at1Name = "|| '-' || at1.FName_" + loc;
                cy2Name = "|| '-' || cy2.FName_" + loc;
                av2Name = "|| '-' || av2.FName_" + loc;
                at2Name = "|| '-' || at2.FName_" + loc;
            }
            boolean isOracle = SQLUtil.isOracle(ctx);
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    case when cy1.FID is not null then cy1.FNumber " + cy1Name + " else cy2.FNumber " + cy2Name + " end currency, \n");
                }
                sql.append("    case when at1.FID is not null then at1.FNumber " + at1Name + " else at2.FNumber " + at2Name + " end accountTable, \n");
                sql.append("    isnull(b.FBeginBalance" + suffix + ", 0) curBegAmount, isnull(ib.FBeginBalance" + suffix + "*av2.fdc, 0) preEndAmount, \n");
                sql.append("    isnull(b.FBeginQty, 0) curBegQty, isnull(ib.FBeginQty*av2.fdc, 0) preEndQty, \n");
            }
            sql.append("    case when av1.FID is not null then av1.FNumber " + av1Name + " else av2.FNumber " + av2Name + " end account \n");
            sql.append("from ( \n");
            sql.append("    select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            sql.append("        b.FAccountID, \n");
            if (cyId == null) {
                sql.append("        b.FCurrencyID, \n");
            }
            sql.append("        b.FBeginBalance" + suffix + ", b.FBeginQty \n");
            sql.append("    from " + GLBalanceUtils.getAccountBalanceTable(balType, cyId) + " b \n");
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = b.FAccountID \n");
            }
            sql.append("    where b.FOrgUnitID = ? and b.FPeriod = ? \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("      and b.FAccountID = ? \n");
                } else {
                    sql.append("      and b.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") b \n");
            sql.append("full join ( \n");
            sql.append("    select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            sql.append("        t.FAccountID, \n");
            if (cyId == null) {
                sql.append("        t.FCurrencyID, \n");
            }
            sql.append("        t.FBeginBalance" + suffix + ", t.FBeginQty \n");
            sql.append("    from T_GL_InitAccountBalance t \n");
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = t.FAccountID \n");
            }
            sql.append("    join T_GL_FLAG f \n");
            sql.append("        on f.FOrgUnitID = t.FOrgUnitID and f.FName = 'glinit' and f.FValue = 'true' \n");
            sql.append("    where t.FOrgUnitID = ? \n");
            if (cyId == null) {
                sql.append("        and t.FCurrencyID <> '11111111-1111-1111-1111-111111111111DEB58FDC' \n");
                sql.append("        and t.FCurrencyID <> '22222222-2222-2222-2222-222222222222DEB58FDC' \n");
            } else {
                sql.append("        and t.FCurrencyID = '" + cyId + "' \n");
            }
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("      and t.FAccountID = ? \n");
                } else {
                    sql.append("      and t.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") ib on ib.FAccountID = b.FAccountID \n");
            if (cyId == null) {
                sql.append("    and ib.FCurrencyID = b.FCurrencyID \n");
            }
            sql.append("left join T_BD_AccountView av1 on av1.FID = b.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at1 on at1.fid = av1.FACCOUNTTABLEID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy1 on cy1.FID = b.FCurrencyID \n");
                }
            }
            sql.append("left join T_BD_AccountView av2 on av2.FID = ib.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at2 on at2.fid = av2.FACCOUNTTABLEID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy2 on cy2.FID = ib.FCurrencyID \n");
                }
            }
            if (compareAmt && compareQty) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FBeginBalance" + suffix + ", 0) <> isnull(ib.FBeginBalance" + suffix + "*av2.fdc, 0) \n");
                sql.append("    or \n");
                sql.append("    isnull(b.FBeginQty, 0) <> isnull(ib.FBeginQty*av2.fdc, 0) \n");
                sql.append(") \n");
            } else if (compareAmt) {
                sql.append("where isnull(b.FBeginBalance" + suffix + ", 0) <> isnull(ib.FBeginBalance" + suffix + "*av2.fdc, 0) \n");
            } else if (compareQty) {
                sql.append("where isnull(b.FBeginQty, 0) <> isnull(ib.FBeginQty*av2.fdc, 0) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, company.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, company.getId().toString());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 1);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("curBegAmount", rs.getString("curBegAmount"));
                item.put("preEndAmount", rs.getString("preEndAmount"));
                item.put("curBegQty", rs.getString("curBegQty"));
                item.put("preEndQty", rs.getString("preEndQty"));
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAssistBegin(Context ctx, Map params, CompanyOrgUnitInfo company, PeriodInfo period, PeriodInfo prePeriod, Set<String> accountIds, int balType, String cyId, int compareType, boolean compareAmt, boolean compareQty, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        if (prePeriod == null) {
            this.analysisAssistStart(ctx, params, company, period, accountIds, balType, cyId, compareType, compareAmt, compareQty, showName, result, maxSize, isForRepair);
            return;
        }
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cyName = "";
            String avName = "";
            String atName = "";
            if (showName) {
                cyName = "|| '-' || cy.FName_" + loc;
                avName = "|| '-' || av.FName_" + loc;
                atName = "|| '-' || at.FName_" + loc;
            }
            boolean isOracle = SQLUtil.isOracle(ctx);
            sql.append("select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    cy.FNumber " + cyName + " currency, \n");
                }
                sql.append("    at.FNumber " + atName + " accountTable, hg.FNumberGroup_l2 assist, \n");
                sql.append("    isnull(cur.FBeginBalance" + suffix + ", 0) curBegAmount, isnull(pre.FEndBalance" + suffix + ", 0) preEndAmount, \n");
                sql.append("    isnull(cur.FBeginQty, 0) curBegQty, isnull(pre.FEndQty, 0) preEndQty, \n");
            }
            sql.append("    av.FNumber " + avName + " account \n");
            if (compareType == 1) {
                sql.append("from " + GLBalanceUtils.getAssistBalanceTable(balType, cyId) + " cur \n");
                sql.append("join T_BD_AccountView av on av.FID = cur.FAccountID \n");
                if (T_TMP_Account != null) {
                    sql.append("join " + T_TMP_Account + " tav on tav.FID = cur.FAccountID \n");
                }
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = cur.FCurrencyID \n");
                    }
                    sql.append("join T_BD_AssistantHG hg on hg.FID = cur.FAssistGrpID \n");
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join " + GLBalanceUtils.getAssistBalanceTable(balType, cyId) + " pre \n");
                sql.append("    on cur.FOrgUnitID = pre.FOrgUnitID \n");
                sql.append("    and pre.FPeriod = ? \n");
                sql.append("    and cur.FAccountID = pre.FAccountID \n");
                sql.append("    and cur.FAssistGrpID = pre.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("    and cur.FCurrencyID = pre.FCurrencyID \n");
                }
                sql.append("where cur.FOrgUnitID = ? \n");
                sql.append("    and cur.FPeriod = ? \n");
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and cur.FAccountID = ? \n");
                    } else {
                        sql.append("  and cur.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            } else {
                sql.append("from " + GLBalanceUtils.getAssistBalanceTable(balType, cyId) + " pre \n");
                sql.append("join T_BD_AccountView av on av.FID = pre.FAccountID \n");
                if (T_TMP_Account != null) {
                    sql.append("join " + T_TMP_Account + " tav on tav.FID = pre.FAccountID \n");
                }
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = pre.FCurrencyID \n");
                    }
                    sql.append("join T_BD_AssistantHG hg on hg.FID = pre.FAssistGrpID \n");
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join " + GLBalanceUtils.getAssistBalanceTable(balType, cyId) + " cur \n");
                sql.append("    on cur.FOrgUnitID = pre.FOrgUnitID \n");
                sql.append("    and cur.FPeriod = ? \n");
                sql.append("    and cur.FAccountID = pre.FAccountID \n");
                sql.append("    and cur.FAssistGrpID = pre.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("    and cur.FCurrencyID = pre.FCurrencyID \n");
                }
                sql.append("where pre.FOrgUnitID = ? \n");
                sql.append("    and pre.FPeriod = ? \n");
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and pre.FAccountID = ? \n");
                    } else {
                        sql.append("  and pre.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            }
            if (compareAmt && compareQty) {
                sql.append("    and ( \n");
                sql.append("        isnull(cur.FBeginBalance" + suffix + ", 0) <> isnull(pre.FEndBalance" + suffix + ", 0) \n");
                sql.append("        or \n");
                sql.append("        isnull(cur.FBeginQty, 0) <> isnull(pre.FEndQty, 0) \n");
                sql.append("    ) \n");
            } else if (compareAmt) {
                sql.append("    and isnull(cur.FBeginBalance" + suffix + ", 0) <> isnull(pre.FEndBalance" + suffix + ", 0) \n");
            } else if (compareQty) {
                sql.append("    and isnull(cur.FBeginQty, 0) <> isnull(pre.FEndQty, 0) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            if (compareType == 1) {
                pstmt.setInt(index++, prePeriod.getNumber());
                pstmt.setString(index++, company.getId().toString());
                pstmt.setInt(index++, period.getNumber());
            } else {
                pstmt.setInt(index++, period.getNumber());
                pstmt.setString(index++, company.getId().toString());
                pstmt.setInt(index++, prePeriod.getNumber());
            }
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 1);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("assist", rs.getString("assist"));
                item.put("curBegAmount", rs.getString("curBegAmount"));
                item.put("preEndAmount", rs.getString("preEndAmount"));
                item.put("curBegQty", rs.getString("curBegQty"));
                item.put("preEndQty", rs.getString("preEndQty"));
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullAnalysisAssistBegin(Context ctx, Map params, CompanyOrgUnitInfo company, PeriodInfo period, PeriodInfo prePeriod, Set<String> accountIds, int balType, String cyId, boolean compareAmt, boolean compareQty, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        if (prePeriod == null) {
            this.fullAnalysisAssistStart(ctx, params, company, period, accountIds, balType, cyId, compareAmt, compareQty, showName, result, maxSize, isForRepair);
            return;
        }
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cy1Name = "";
            String av1Name = "";
            String at1Name = "";
            String cy2Name = "";
            String av2Name = "";
            String at2Name = "";
            if (showName) {
                cy1Name = "|| '-' || cy1.FName_" + loc;
                av1Name = "|| '-' || av1.FName_" + loc;
                at1Name = "|| '-' || at1.FName_" + loc;
                cy2Name = "|| '-' || cy2.FName_" + loc;
                av2Name = "|| '-' || av2.FName_" + loc;
                at2Name = "|| '-' || at2.FName_" + loc;
            }
            boolean isOracle = SQLUtil.isOracle(ctx);
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    case when cy1.FID is not null then cy1.FNumber " + cy1Name + " else cy2.FNumber " + cy2Name + " end currency, \n");
                }
                sql.append("    case when at1.FID is not null then at1.FNumber " + at1Name + " else at2.FNumber " + at2Name + " end accountTable, \n");
                sql.append("    case when hg1.FID is not null then hg1.FNumberGroup_" + loc + " else hg2.FNumberGroup_" + loc + " end assist, \n");
                sql.append("    isnull(cur.FBeginBalance" + suffix + ", 0) curBegAmount, isnull(pre.FEndBalance" + suffix + ", 0) preEndAmount, \n");
                sql.append("    isnull(cur.FBeginQty, 0) curBegQty, isnull(pre.FEndQty, 0) preEndQty, \n");
            }
            sql.append("    case when av1.FID is not null then av1.FNumber " + av1Name + " else av2.FNumber " + av2Name + " end account \n");
            sql.append("from ( \n");
            sql.append("    select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            sql.append("        b.FAccountID, b.FAssistGrpID, \n");
            if (cyId == null) {
                sql.append("        b.FCurrencyID, \n");
            }
            sql.append("        b.FBeginBalance" + suffix + ", b.FBeginQty \n");
            sql.append("    from " + GLBalanceUtils.getAssistBalanceTable(balType, cyId) + " b \n");
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = b.FAccountID \n");
            }
            sql.append("    where b.FOrgUnitID = ? and b.FPeriod = ? \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("        and b.FAccountID = ? \n");
                } else {
                    sql.append("        and b.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") cur \n");
            sql.append("full join ( \n");
            sql.append("    select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            sql.append("        b.FAccountID, b.FAssistGrpID, \n");
            if (cyId == null) {
                sql.append("        b.FCurrencyID, \n");
            }
            sql.append("        b.FEndBalance" + suffix + ", b.FEndQty \n");
            sql.append("    from " + GLBalanceUtils.getAssistBalanceTable(balType, cyId) + " b \n");
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = b.FAccountID \n");
            }
            sql.append("    where b.FOrgUnitID = ? and b.FPeriod = ? \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("        and b.FAccountID = ? \n");
                } else {
                    sql.append("        and b.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") pre on cur.FAccountID = pre.FAccountID \n");
            sql.append("    and cur.FAssistGrpID = pre.FAssistGrpID \n");
            if (cyId == null) {
                sql.append("    and cur.FCurrencyID = pre.FCurrencyID \n");
            }
            sql.append("left join T_BD_AccountView av1 on av1.FID = cur.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at1 on at1.fid = av1.FACCOUNTTABLEID \n");
                sql.append("left join T_BD_AssistantHG hg1 on hg1.FID = cur.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy1 on cy1.FID = cur.FCurrencyID \n");
                }
            }
            sql.append("left join T_BD_AccountView av2 on av2.FID = pre.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at2 on at2.fid = av2.FACCOUNTTABLEID \n");
                sql.append("left join T_BD_AssistantHG hg2 on hg2.FID = pre.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy2 on cy2.FID = pre.FCurrencyID \n");
                }
            }
            if (compareAmt && compareQty) {
                sql.append("where ( \n");
                sql.append("    isnull(cur.FBeginBalance" + suffix + ", 0) <> isnull(pre.FEndBalance" + suffix + ", 0) \n");
                sql.append("    or \n");
                sql.append("    isnull(cur.FBeginQty, 0) <> isnull(pre.FEndQty, 0) \n");
                sql.append(") \n");
            } else if (compareAmt) {
                sql.append("where isnull(cur.FBeginBalance" + suffix + ", 0) <> isnull(pre.FEndBalance" + suffix + ", 0) \n");
            } else if (compareQty) {
                sql.append("where isnull(cur.FBeginQty, 0) <> isnull(pre.FEndQty, 0) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, company.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, company.getId().toString());
            pstmt.setInt(index++, prePeriod.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 1);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("assist", rs.getString("assist"));
                item.put("curBegAmount", rs.getString("curBegAmount"));
                item.put("preEndAmount", rs.getString("preEndAmount"));
                item.put("curBegQty", rs.getString("curBegQty"));
                item.put("preEndQty", rs.getString("preEndQty"));
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAssistStart(Context ctx, Map params, CompanyOrgUnitInfo company, PeriodInfo period, Set<String> accountIds, int balType, String cyId, int compareType, boolean compareAmt, boolean compareQty, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cyName = "";
            String avName = "";
            String atName = "";
            if (showName) {
                cyName = "|| '-' || cy.FName_" + loc;
                avName = "|| '-' || av.FName_" + loc;
                atName = "|| '-' || at.FName_" + loc;
            }
            boolean isOracle = SQLUtil.isOracle(ctx);
            sql.append("select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    cy.FNumber " + cyName + " currency, \n");
                }
                sql.append("    at.FNumber " + atName + " accountTable, hg.FNumberGroup_l2 assist, \n");
                sql.append("    isnull(b.FBeginBalance" + suffix + ", 0) curBegAmount, isnull(ib.FBeginBalance" + suffix + "*av.fdc, 0) preEndAmount, \n");
                sql.append("    isnull(b.FBeginQty, 0) curBegQty, isnull(ib.FStandardBeginQty*av.fdc, 0) preEndQty, \n");
            }
            sql.append("    av.FNumber " + avName + " account \n");
            if (compareType == 1) {
                sql.append("from " + GLBalanceUtils.getAssistBalanceTable(balType, cyId) + " b \n");
                sql.append("join T_BD_AccountView av on av.FID = b.FAccountID \n");
                if (T_TMP_Account != null) {
                    sql.append("join " + T_TMP_Account + " tav on tav.FID = b.FAccountID \n");
                }
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = b.FCurrencyID \n");
                    }
                    sql.append("join T_BD_AssistantHG hg on hg.FID = b.FAssistGrpID \n");
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join T_GL_FLAG f \n");
                sql.append("    on f.FOrgUnitID = b.FOrgUnitID and f.FName = 'astinit' and f.FKey = b.FAccountID \n");
                sql.append("left join T_GL_InitAssistBalance ib \n");
                sql.append("    on ib.FOrgUnitID = b.FOrgUnitID \n");
                sql.append("    and ib.FAccountID = b.FAccountID \n");
                if (cyId == null) {
                    sql.append("    and ib.FCurrencyID = b.FCurrencyID \n");
                } else {
                    sql.append("    and ib.FCurrencyID = '" + cyId + "' \n");
                }
                sql.append("    and ib.FAssistGrpID = b.FAssistGrpID \n");
                sql.append("    and f.FValue = 'true' \n");
                sql.append("where b.FOrgUnitID = ? \n");
                sql.append("    and b.FPeriod = ? \n");
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and b.FAccountID = ? \n");
                    } else {
                        sql.append("  and b.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            } else {
                sql.append("from T_GL_InitAssistBalance ib \n");
                sql.append("join T_BD_AccountView av on av.FID = ib.FAccountID \n");
                if (T_TMP_Account != null) {
                    sql.append("join " + T_TMP_Account + " tav on tav.FID = ib.FAccountID \n");
                }
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = ib.FCurrencyID \n");
                    }
                    sql.append("join T_BD_AssistantHG hg on hg.FID = ib.FAssistGrpID \n");
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("join T_GL_FLAG f \n");
                sql.append("    on f.FOrgUnitID = ib.FOrgUnitID and f.FName = 'astinit' and f.FKey = ib.FAccountID and f.FValue = 'true' \n");
                sql.append("left join " + GLBalanceUtils.getAssistBalanceTable(balType, cyId) + " b \n");
                sql.append("    on b.FOrgUnitID = ib.FOrgUnitID \n");
                sql.append("    and b.FPeriod = ? \n");
                sql.append("    and b.FAccountID = ib.FAccountID \n");
                if (cyId == null) {
                    sql.append("    and b.FCurrencyID = ib.FCurrencyID \n");
                }
                sql.append("    and b.FAssistGrpID = ib.FAssistGrpID \n");
                sql.append("where ib.FOrgUnitID = ? \n");
                if (cyId == null) {
                    sql.append("    and ib.FCurrencyID <> '11111111-1111-1111-1111-111111111111DEB58FDC' \n");
                    sql.append("    and ib.FCurrencyID <> '22222222-2222-2222-2222-222222222222DEB58FDC' \n");
                } else {
                    sql.append("    and ib.FCurrencyID = '" + cyId + "' \n");
                }
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and ib.FAccountID = ? \n");
                    } else {
                        sql.append("  and ib.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            }
            if (compareAmt && compareQty) {
                sql.append("    and ( \n");
                sql.append("        isnull(b.FBeginBalance" + suffix + ", 0) <> isnull(ib.FBeginBalance" + suffix + "*av.fdc, 0) \n");
                sql.append("        or \n");
                sql.append("        isnull(b.FBeginQty, 0) <> isnull(ib.FStandardBeginQty*av.fdc, 0) \n");
                sql.append("    ) \n");
            } else if (compareAmt) {
                sql.append("    and isnull(b.FBeginBalance" + suffix + ", 0) <> isnull(ib.FBeginBalance" + suffix + "*av.fdc, 0) \n");
            } else if (compareQty) {
                sql.append("    and isnull(b.FBeginQty, 0) <> isnull(ib.FStandardBeginQty*av.fdc, 0) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            if (compareType == 1) {
                pstmt.setString(index++, company.getId().toString());
                pstmt.setInt(index++, period.getNumber());
            } else {
                pstmt.setInt(index++, period.getNumber());
                pstmt.setString(index++, company.getId().toString());
            }
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 1);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("assist", rs.getString("assist"));
                item.put("curBegAmount", rs.getString("curBegAmount"));
                item.put("preEndAmount", rs.getString("preEndAmount"));
                item.put("curBegQty", rs.getString("curBegQty"));
                item.put("preEndQty", rs.getString("preEndQty"));
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullAnalysisAssistStart(Context ctx, Map params, CompanyOrgUnitInfo company, PeriodInfo period, Set<String> accountIds, int balType, String cyId, boolean compareAmt, boolean compareQty, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cy1Name = "";
            String av1Name = "";
            String at1Name = "";
            String cy2Name = "";
            String av2Name = "";
            String at2Name = "";
            if (showName) {
                cy1Name = "|| '-' || cy1.FName_" + loc;
                av1Name = "|| '-' || av1.FName_" + loc;
                at1Name = "|| '-' || at1.FName_" + loc;
                cy2Name = "|| '-' || cy2.FName_" + loc;
                av2Name = "|| '-' || av2.FName_" + loc;
                at2Name = "|| '-' || at2.FName_" + loc;
            }
            boolean isOracle = SQLUtil.isOracle(ctx);
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    case when cy1.FID is not null then cy1.FNumber " + cy1Name + " else cy2.FNumber " + cy2Name + " end currency, \n");
                }
                sql.append("    case when at1.FID is not null then at1.FNumber " + at1Name + " else at2.FNumber " + at2Name + " end accountTable, \n");
                sql.append("    case when hg1.FID is not null then hg1.FNumberGroup_" + loc + " else hg2.FNumberGroup_" + loc + " end assist, \n");
                sql.append("    isnull(b.FBeginBalance" + suffix + ", 0) curBegAmount, isnull(ib.FBeginBalance" + suffix + "*av2.fdc, 0) preEndAmount, \n");
                sql.append("    isnull(b.FBeginQty, 0) curBegQty, isnull(ib.FStandardBeginQty*av2.fdc, 0) preEndQty, \n");
            }
            sql.append("    case when av1.FID is not null then av1.FNumber " + av1Name + " else av2.FNumber " + av2Name + " end account \n");
            sql.append("from ( \n");
            sql.append("    select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            sql.append("        b.FAccountID, b.FAssistGrpID, \n");
            if (cyId == null) {
                sql.append("        b.FCurrencyID, \n");
            }
            sql.append("        b.FBeginBalance" + suffix + ", b.FBeginQty \n");
            sql.append("    from " + GLBalanceUtils.getAssistBalanceTable(balType, cyId) + " b \n");
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = b.FAccountID \n");
            }
            sql.append("    where b.FOrgUnitID = ? and b.FPeriod = ? \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("      and b.FAccountID = ? \n");
                } else {
                    sql.append("      and b.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") b \n");
            sql.append("full join ( \n");
            sql.append("    select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            sql.append("        t.FAccountID, t.FAssistGrpID, \n");
            if (cyId == null) {
                sql.append("        t.FCurrencyID, \n");
            }
            sql.append("        t.FBeginBalance" + suffix + ", t.FStandardBeginQty \n");
            sql.append("    from T_GL_InitAssistBalance t \n");
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = t.FAccountID \n");
            }
            sql.append("    join T_GL_FLAG f \n");
            sql.append("        on f.FOrgUnitID = t.FOrgUnitID and f.FName = 'astinit' and f.FKey = t.FAccountID and f.FValue = 'true' \n");
            sql.append("    where t.FOrgUnitID = ? \n");
            if (cyId == null) {
                sql.append("        and t.FCurrencyID <> '11111111-1111-1111-1111-111111111111DEB58FDC' \n");
                sql.append("        and t.FCurrencyID <> '22222222-2222-2222-2222-222222222222DEB58FDC' \n");
            } else {
                sql.append("        and t.FCurrencyID = '" + cyId + "' \n");
            }
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("      and t.FAccountID = ? \n");
                } else {
                    sql.append("      and t.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") ib on ib.FAccountID = b.FAccountID and ib.FAssistGrpID = b.FAssistGrpID \n");
            if (cyId == null) {
                sql.append("    and ib.FCurrencyID = b.FCurrencyID \n");
            }
            sql.append("left join T_BD_AccountView av1 on av1.FID = b.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at1 on at1.fid = av1.FACCOUNTTABLEID \n");
                sql.append("left join T_BD_AssistantHG hg1 on hg1.FID = b.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy1 on cy1.FID = b.FCurrencyID \n");
                }
            }
            sql.append("left join T_BD_AccountView av2 on av2.FID = ib.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at2 on at2.fid = av2.FACCOUNTTABLEID \n");
                sql.append("left join T_BD_AssistantHG hg2 on hg2.FID = ib.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy2 on cy2.FID = ib.FCurrencyID \n");
                }
            }
            if (compareAmt && compareQty) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FBeginBalance" + suffix + ", 0) <> isnull(ib.FBeginBalance" + suffix + "*av2.fdc, 0) \n");
                sql.append("    or \n");
                sql.append("    isnull(b.FBeginQty, 0) <> isnull(ib.FStandardBeginQty*av2.fdc, 0) \n");
                sql.append(") \n");
            } else if (compareAmt) {
                sql.append("where isnull(b.FBeginBalance" + suffix + ", 0) <> isnull(ib.FBeginBalance" + suffix + "*av2.fdc, 0) \n");
            } else if (compareQty) {
                sql.append("where isnull(b.FBeginQty, 0) <> isnull(ib.FStandardBeginQty*av2.fdc, 0) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, company.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, company.getId().toString());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 1);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("assist", rs.getString("assist"));
                item.put("curBegAmount", rs.getString("curBegAmount"));
                item.put("preEndAmount", rs.getString("preEndAmount"));
                item.put("curBegQty", rs.getString("curBegQty"));
                item.put("preEndQty", rs.getString("preEndQty"));
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAccountCurrent(Context ctx, Map params, CompanyOrgUnitInfo company, PeriodInfo period, Set<String> accountIds, int balType, String cyId, int compareType, boolean compareAmt, boolean compareQty, boolean comparePNL, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String prefix = "Original";
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                prefix = "Local";
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                prefix = "Reporting";
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cyName = "";
            String avName = "";
            String atName = "";
            if (showName) {
                cyName = "|| '-' || cy.FName_" + loc;
                avName = "|| '-' || av.FName_" + loc;
                atName = "|| '-' || at.FName_" + loc;
            }
            boolean isOracle = SQLUtil.isOracle(ctx);
            sql.append("select \n");
            if (compareType == 1 && isOracle && T_TMP_Account != null) {
                sql.append("    /*+ LEADING(tav) */ \n");
            }
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    cy.FNumber " + cyName + " currency, \n");
                }
                sql.append("    at.FNumber " + atName + " accountTable, \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) balDebitAmount, isnull(a.FDebit" + suffix + ", 0) vchDebitAmount, \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) balCreditAmount, isnull(a.FCredit" + suffix + ", 0) vchCreditAmount, \n");
                sql.append("    isnull(b.FDebitQty, 0) balDebitQty, isnull(a.FDebitQty, 0) vchDebitQty, \n");
                sql.append("    isnull(b.FCreditQty, 0) balCreditQty, isnull(a.FCreditQty, 0) vchCreditQty, \n");
                if (comparePNL) {
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) balMonthPnlAmount, isnull(a.FMonthPnl" + suffix + ", 0) vchMonthPnlAmount, \n");
                    sql.append("    isnull(b.FMonthPnlQty, 0) balMonthPnlQty, isnull(a.FMonthPnlQty, 0) vchMonthPnlQty, \n");
                }
            }
            sql.append("    av.FNumber " + avName + " account \n");
            if (compareType == 1) {
                sql.append("from " + GLBalanceUtils.getAccountBalanceTable(balType, cyId) + " b \n");
                sql.append("join T_BD_AccountView av on av.FID = b.FAccountID \n");
                if (T_TMP_Account != null) {
                    sql.append("    join " + T_TMP_Account + " tav on tav.fid = b.faccountid and tav.FIsLeaf = 1 \n");
                }
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = b.FCurrencyID \n");
                    }
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join ( \n");
                sql.append("    select \n");
                if (isOracle && T_TMP_Account != null) {
                    sql.append("        /*+ LEADING(tav) */ \n");
                }
                sql.append("        ve.FAccountID, \n");
                if (cyId == null) {
                    sql.append("        ve.FCurrencyID, \n");
                }
                sql.append("        sum(ve.F" + prefix + "Amount * ve.FEntryDC) FDebit" + suffix + ", \n");
                sql.append("        sum(ve.F" + prefix + "Amount * (1 - ve.FEntryDC)) FCredit" + suffix + ", \n");
                sql.append("        sum(ve.FStandardQuantity * ve.FEntryDC) FDebitQty, \n");
                sql.append("        sum(ve.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty \n");
                if (comparePNL) {
                    sql.append("        ,sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.f" + prefix + "Amount else 0 end) FMonthPnl" + suffix + ", \n");
                    sql.append("        sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.FSTANDARDQUANTITY else 0 end) FMonthPnlQty \n");
                }
                sql.append("    from T_GL_Voucher v \n");
                sql.append("    inner join T_GL_VoucherEntry ve on ve.FBillID = v.FID \n");
                if (comparePNL) {
                    sql.append("    inner join t_bd_accountview ac on ac.fid = ve.faccountid \n");
                    sql.append("    inner join t_bd_accounttype acctType on ac.faccounttypeid = acctType.fid \n");
                }
                if (T_TMP_Account != null) {
                    sql.append("    join " + T_TMP_Account + " tav on tav.fid = ve.faccountid and tav.FIsLeaf = 1 \n");
                }
                sql.append("    where v.Fcompanyid = ? and v.fperiodid = ? \n");
                sql.append("        and ve.Fcompanyid = ? and ve.fperiodid = ? \n");
                if (balType == 1) {
                    sql.append("        and v.FbizStatus <> 0 and v.FbizStatus <> 2 \n");
                } else {
                    sql.append("        and v.FbizStatus = 5 \n");
                }
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and ve.FAccountID = ? \n");
                    } else {
                        sql.append("  and ve.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
                sql.append("    group by ve.FAccountID \n");
                if (cyId == null) {
                    sql.append("    , ve.FCurrencyID \n");
                }
                sql.append(") a on a.FAccountID = b.FAccountID \n");
                if (cyId == null) {
                    sql.append(" and a.FCurrencyID = b.FCurrencyID \n");
                }
                sql.append("where b.FOrgUnitID = ? and b.FPeriod = ? \n");
                sql.append("    and av.FIsLeaf = 1 \n");
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and b.FAccountID = ? \n");
                    } else {
                        sql.append("  and b.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            } else {
                sql.append("from ( \n");
                sql.append("    select \n");
                if (isOracle && T_TMP_Account != null) {
                    sql.append("        /*+ LEADING(tav) */ \n");
                }
                sql.append("        ve.FAccountID, \n");
                if (cyId == null) {
                    sql.append("        ve.FCurrencyID, \n");
                }
                sql.append("        sum(ve.F" + prefix + "Amount * ve.FEntryDC) FDebit" + suffix + ", \n");
                sql.append("        sum(ve.F" + prefix + "Amount * (1 - ve.FEntryDC)) FCredit" + suffix + ", \n");
                sql.append("        sum(ve.FStandardQuantity * ve.FEntryDC) FDebitQty, \n");
                sql.append("        sum(ve.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty \n");
                if (comparePNL) {
                    sql.append("        ,sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.f" + prefix + "Amount else 0 end) FMonthPnl" + suffix + ", \n");
                    sql.append("        sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.FSTANDARDQUANTITY else 0 end) FMonthPnlQty \n");
                }
                sql.append("    from T_GL_Voucher v \n");
                sql.append("    inner join T_GL_VoucherEntry ve on ve.FBillID = v.FID \n");
                if (comparePNL) {
                    sql.append("    inner join t_bd_accountview ac on ac.fid = ve.faccountid \n");
                    sql.append("    inner join t_bd_accounttype acctType on ac.faccounttypeid = acctType.fid \n");
                }
                if (T_TMP_Account != null) {
                    sql.append("    join " + T_TMP_Account + " tav on tav.fid = ve.faccountid and tav.FIsLeaf = 1 \n");
                }
                sql.append("    where v.Fcompanyid = ? and v.fperiodid = ? \n");
                sql.append("        and ve.Fcompanyid = ? and ve.fperiodid = ? \n");
                if (balType == 1) {
                    sql.append("        and v.FbizStatus <> 0 and v.FbizStatus <> 2 \n");
                } else {
                    sql.append("        and v.FbizStatus = 5 \n");
                }
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and ve.FAccountID = ? \n");
                    } else {
                        sql.append("  and ve.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
                sql.append("    group by ve.FAccountID \n");
                if (cyId == null) {
                    sql.append("    , ve.FCurrencyID \n");
                }
                sql.append(") a \n");
                sql.append("join T_BD_AccountView av on av.FID = a.FAccountID \n");
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = a.FCurrencyID \n");
                    }
                    sql.append("join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join " + GLBalanceUtils.getAccountBalanceTable(balType, cyId) + " b \n");
                sql.append("    on b.FOrgUnitID = ? and b.FPeriod = ? \n");
                sql.append("    and a.FAccountID = b.FAccountID \n");
                if (cyId == null) {
                    sql.append(" and a.FCurrencyID = b.FCurrencyID \n");
                }
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and b.FAccountID = ? \n");
                    } else {
                        sql.append("  and b.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
                sql.append("where av.FIsLeaf = 1 \n");
            }
            if (compareAmt && compareQty) {
                sql.append("    and ( \n");
                sql.append("        isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("        or  \n");
                    sql.append("        isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                    sql.append("        or  \n");
                    sql.append("        isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append("    ) \n");
            } else if (compareAmt) {
                sql.append("    and ( \n");
                sql.append("        isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                if (comparePNL) {
                    sql.append("        or  \n");
                    sql.append("        isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                }
                sql.append("    ) \n");
            } else if (compareQty) {
                sql.append("    and ( \n");
                sql.append("        isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("        or  \n");
                    sql.append("        isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append("    ) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, company.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            pstmt.setString(index++, company.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, company.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 2);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("balDebitAmount", rs.getBigDecimal("balDebitAmount"));
                item.put("vchDebitAmount", rs.getBigDecimal("vchDebitAmount"));
                item.put("balDebitQty", rs.getBigDecimal("balDebitQty"));
                item.put("vchDebitQty", rs.getBigDecimal("vchDebitQty"));
                item.put("balCreditAmount", rs.getBigDecimal("balCreditAmount"));
                item.put("vchCreditAmount", rs.getBigDecimal("vchCreditAmount"));
                item.put("balCreditQty", rs.getBigDecimal("balCreditQty"));
                item.put("vchCreditQty", rs.getBigDecimal("vchCreditQty"));
                if (comparePNL) {
                    item.put("balMonthPnlAmount", rs.getBigDecimal("balMonthPnlAmount"));
                    item.put("vchMonthPnlAmount", rs.getBigDecimal("vchMonthPnlAmount"));
                    item.put("balMonthPnlQty", rs.getBigDecimal("balMonthPnlQty"));
                    item.put("vchMonthPnlQty", rs.getBigDecimal("vchMonthPnlQty"));
                }
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullAnalysisAccountCurrent(Context ctx, Map params, CompanyOrgUnitInfo company, PeriodInfo period, Set<String> accountIds, int balType, String cyId, boolean compareAmt, boolean compareQty, boolean comparePNL, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        boolean isOracle;
        String at2Name;
        String av2Name;
        String cy2Name;
        String at1Name;
        String av1Name;
        String cy1Name;
        String suffix;
        String prefix;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        StringBuffer sql;
        String T_TMP_Account;
        block51: {
            T_TMP_Account = (String)params.get("T_TMP_Account");
            sql = new StringBuffer();
            conn = null;
            pstmt = null;
            rs = null;
            conn = EJBFactory.getConnection((Context)ctx);
            prefix = "Original";
            suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                prefix = "Local";
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                prefix = "Reporting";
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            cy1Name = "";
            av1Name = "";
            at1Name = "";
            cy2Name = "";
            av2Name = "";
            at2Name = "";
            if (showName) {
                cy1Name = "|| '-' || cy1.FName_" + loc;
                av1Name = "|| '-' || av1.FName_" + loc;
                at1Name = "|| '-' || at1.FName_" + loc;
                cy2Name = "|| '-' || cy2.FName_" + loc;
                av2Name = "|| '-' || av2.FName_" + loc;
                at2Name = "|| '-' || at2.FName_" + loc;
            }
            if (!(isOracle = SQLUtil.isOracle(ctx))) break block51;
            boolean isDialect = true;
            for (Object key : params.keySet()) {
                Object value;
                if (key == null || !key.toString().equalsIgnoreCase("dialect") || (value = params.get(key)) == null || !"false".equalsIgnoreCase(value.toString())) continue;
                isDialect = false;
            }
            if (!isDialect) break block51;
            this.fullAnalysisAccountCurrentForOracle(ctx, params, company, period, accountIds, balType, cyId, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            return;
        }
        try {
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    case when cy1.FID is not null then cy1.FNumber " + cy1Name + " else cy2.FNumber " + cy2Name + " end currency, \n");
                }
                sql.append("    case when at1.FID is not null then at1.FNumber " + at1Name + " else at2.FNumber " + at2Name + " end accountTable, \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) balDebitAmount, isnull(a.FDebit" + suffix + ", 0) vchDebitAmount, \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) balCreditAmount, isnull(a.FCredit" + suffix + ", 0) vchCreditAmount, \n");
                sql.append("    isnull(b.FDebitQty, 0) balDebitQty, isnull(a.FDebitQty, 0) vchDebitQty, \n");
                sql.append("    isnull(b.FCreditQty, 0) balCreditQty, isnull(a.FCreditQty, 0) vchCreditQty, \n");
                if (comparePNL) {
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) balMonthPnlAmount, isnull(a.FMonthPnl" + suffix + ", 0) vchMonthPnlAmount, \n");
                    sql.append("    isnull(b.FMonthPnlQty, 0) balMonthPnlQty, isnull(a.FMonthPnlQty, 0) vchMonthPnlQty, \n");
                }
            }
            sql.append("    case when av1.FID is not null then av1.FNumber " + av1Name + " else av2.FNumber " + av2Name + " end account \n");
            sql.append("from ( \n");
            sql.append("    select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            sql.append("        t.FAccountID, \n");
            if (cyId == null) {
                sql.append("        t.FCurrencyID, \n");
            }
            sql.append("        t.FDebit" + suffix + ", t.FCredit" + suffix + ", t.FDebitQty, t.FCreditQty \n");
            if (comparePNL) {
                sql.append("    ,t.FMonthPnl" + suffix + ", t.FMonthPnlQty \n");
            }
            sql.append("    from " + GLBalanceUtils.getAccountBalanceTable(balType, cyId) + " t \n");
            sql.append("    join t_bd_accountview ac on ac.fid = t.faccountid \n");
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = t.FAccountID and tav.FIsLeaf = 1 \n");
            }
            sql.append("    where t.FOrgUnitID = ? and t.FPeriod = ? and ac.FIsLeaf = 1 \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("      and t.FAccountID = ? \n");
                } else {
                    sql.append("      and t.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") b \n");
            sql.append("full join ( \n");
            sql.append("    select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            sql.append("        ve.FAccountID, \n");
            if (cyId == null) {
                sql.append("        ve.FCurrencyID, \n");
            }
            sql.append("        sum(ve.F" + prefix + "Amount * ve.FEntryDC) FDebit" + suffix + ", \n");
            sql.append("        sum(ve.F" + prefix + "Amount * (1 - ve.FEntryDC)) FCredit" + suffix + ", \n");
            sql.append("        sum(ve.FStandardQuantity * ve.FEntryDC) FDebitQty, \n");
            sql.append("        sum(ve.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty \n");
            if (comparePNL) {
                sql.append("        ,sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.f" + prefix + "Amount else 0 end) FMonthPnl" + suffix + ", \n");
                sql.append("        sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.FSTANDARDQUANTITY else 0 end) FMonthPnlQty \n");
            }
            sql.append("    from T_GL_Voucher v \n");
            sql.append("    inner join T_GL_VoucherEntry ve on ve.FBillID = v.FID \n");
            if (comparePNL) {
                sql.append("    inner join t_bd_accountview ac on ac.fid = ve.faccountid \n");
                sql.append("    inner join t_bd_accounttype acctType on ac.faccounttypeid = acctType.fid \n");
            }
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = ve.FAccountID and tav.FIsLeaf = 1 \n");
            }
            sql.append("    where v.Fcompanyid = ? and v.fperiodid = ? \n");
            sql.append("        and ve.Fcompanyid = ? and ve.fperiodid = ? \n");
            if (balType == 1) {
                sql.append("        and v.FbizStatus <> 0 and v.FbizStatus <> 2 \n");
            } else {
                sql.append("        and v.FbizStatus = 5 \n");
            }
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("  and ve.FAccountID = ? \n");
                } else {
                    sql.append("  and ve.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append("    group by ve.FAccountID \n");
            if (cyId == null) {
                sql.append("    , ve.FCurrencyID \n");
            }
            sql.append(") a on a.FAccountID = b.FAccountID \n");
            if (cyId == null) {
                sql.append(" and a.FCurrencyID = b.FCurrencyID \n");
            }
            sql.append("left join T_BD_AccountView av1 on av1.FID = b.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at1 on at1.fid = av1.FACCOUNTTABLEID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy1 on cy1.FID = b.FCurrencyID \n");
                }
            }
            sql.append("left join T_BD_AccountView av2 on av2.FID = a.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at2 on at2.fid = av2.FACCOUNTTABLEID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy2 on cy2.FID = a.FCurrencyID \n");
                }
            }
            if (compareAmt && compareQty) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append(") \n");
            } else if (compareAmt) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                }
                sql.append(") \n");
            } else if (compareQty) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append(") \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, company.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, company.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            pstmt.setString(index++, company.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 2);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("balDebitAmount", rs.getBigDecimal("balDebitAmount"));
                item.put("vchDebitAmount", rs.getBigDecimal("vchDebitAmount"));
                item.put("balDebitQty", rs.getBigDecimal("balDebitQty"));
                item.put("vchDebitQty", rs.getBigDecimal("vchDebitQty"));
                item.put("balCreditAmount", rs.getBigDecimal("balCreditAmount"));
                item.put("vchCreditAmount", rs.getBigDecimal("vchCreditAmount"));
                item.put("balCreditQty", rs.getBigDecimal("balCreditQty"));
                item.put("vchCreditQty", rs.getBigDecimal("vchCreditQty"));
                if (comparePNL) {
                    item.put("balMonthPnlAmount", rs.getBigDecimal("balMonthPnlAmount"));
                    item.put("vchMonthPnlAmount", rs.getBigDecimal("vchMonthPnlAmount"));
                    item.put("balMonthPnlQty", rs.getBigDecimal("balMonthPnlQty"));
                    item.put("vchMonthPnlQty", rs.getBigDecimal("vchMonthPnlQty"));
                }
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullAnalysisAccountCurrentForOracle(Context ctx, Map params, CompanyOrgUnitInfo company, PeriodInfo period, Set<String> accountIds, int balType, String cyId, boolean compareAmt, boolean compareQty, boolean comparePNL, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String prefix = "Original";
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                prefix = "Local";
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                prefix = "Reporting";
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cy1Name = "";
            String av1Name = "";
            String at1Name = "";
            String cy2Name = "";
            String av2Name = "";
            String at2Name = "";
            if (showName) {
                cy1Name = "|| '-' || cy1.FName_" + loc;
                av1Name = "|| '-' || av1.FName_" + loc;
                at1Name = "|| '-' || at1.FName_" + loc;
                cy2Name = "|| '-' || cy2.FName_" + loc;
                av2Name = "|| '-' || av2.FName_" + loc;
                at2Name = "|| '-' || at2.FName_" + loc;
            }
            boolean isUseHash = true;
            for (Object key : params.keySet()) {
                Object value;
                if (key == null || !key.toString().equalsIgnoreCase("VoucherAccountQuery_USE_HASH") || (value = params.get(key)) == null || !"false".equalsIgnoreCase(value.toString())) continue;
                isUseHash = false;
            }
            String voucherQueryHint = "";
            if (isUseHash) {
                voucherQueryHint = T_TMP_Account != null ? "/*+ LEADING(tav,v,ve) USE_HASH(v,ve) */" : "/*+ LEADING(v,ve) USE_HASH(v,ve) */";
            } else if (T_TMP_Account != null) {
                voucherQueryHint = "/*+ LEADING(tav) */";
            }
            sql.append("/*dialect*/ with b as ( \n");
            sql.append("    select \n");
            if (T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            sql.append("        t.FAccountID, \n");
            if (cyId == null) {
                sql.append("        t.FCurrencyID, \n");
            }
            sql.append("        t.FDebit" + suffix + ", t.FCredit" + suffix + ", t.FDebitQty, t.FCreditQty \n");
            if (comparePNL) {
                sql.append("    ,t.FMonthPnl" + suffix + ", t.FMonthPnlQty \n");
            }
            sql.append("    from " + GLBalanceUtils.getAccountBalanceTable(balType, cyId) + " t \n");
            sql.append("    join t_bd_accountview ac on ac.fid = t.faccountid \n");
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = t.FAccountID and tav.FIsLeaf = 1 \n");
            }
            sql.append("    where t.FOrgUnitID = ? and t.FPeriod = ? and ac.FIsLeaf = 1 \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("      and t.FAccountID = ? \n");
                } else {
                    sql.append("      and t.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append("), \n");
            sql.append("a as ( \n");
            sql.append("    select " + voucherQueryHint + " \n");
            sql.append("        ve.FAccountID, \n");
            if (cyId == null) {
                sql.append("        ve.FCurrencyID, \n");
            }
            sql.append("        sum(ve.F" + prefix + "Amount * ve.FEntryDC) FDebit" + suffix + ", \n");
            sql.append("        sum(ve.F" + prefix + "Amount * (1 - ve.FEntryDC)) FCredit" + suffix + ", \n");
            sql.append("        sum(ve.FStandardQuantity * ve.FEntryDC) FDebitQty, \n");
            sql.append("        sum(ve.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty \n");
            if (comparePNL) {
                sql.append("        ,sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.f" + prefix + "Amount else 0 end) FMonthPnl" + suffix + ", \n");
                sql.append("        sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.FSTANDARDQUANTITY else 0 end) FMonthPnlQty \n");
            }
            sql.append("    from T_GL_Voucher v \n");
            sql.append("    inner join T_GL_VoucherEntry ve on ve.FBillID = v.FID \n");
            if (comparePNL) {
                sql.append("    inner join t_bd_accountview ac on ac.fid = ve.faccountid \n");
                sql.append("    inner join t_bd_accounttype acctType on ac.faccounttypeid = acctType.fid \n");
            }
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = ve.FAccountID and tav.FIsLeaf = 1 \n");
            }
            sql.append("    where v.Fcompanyid = ? and v.fperiodid = ? \n");
            sql.append("        and ve.Fcompanyid = ? and ve.fperiodid = ? \n");
            if (balType == 1) {
                sql.append("        and v.FbizStatus <> 0 and v.FbizStatus <> 2 \n");
            } else {
                sql.append("        and v.FbizStatus = 5 \n");
            }
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("  and ve.FAccountID = ? \n");
                } else {
                    sql.append("  and ve.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append("    group by ve.FAccountID \n");
            if (cyId == null) {
                sql.append("    , ve.FCurrencyID \n");
            }
            sql.append(") \n");
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    case when cy1.FID is not null then cy1.FNumber " + cy1Name + " else cy2.FNumber " + cy2Name + " end currency, \n");
                }
                sql.append("    case when at1.FID is not null then at1.FNumber " + at1Name + " else at2.FNumber " + at2Name + " end accountTable, \n");
                sql.append("    nvl(b.FDebit" + suffix + ", 0) balDebitAmount, nvl(a.FDebit" + suffix + ", 0) vchDebitAmount, \n");
                sql.append("    nvl(b.FCredit" + suffix + ", 0) balCreditAmount, nvl(a.FCredit" + suffix + ", 0) vchCreditAmount, \n");
                sql.append("    nvl(b.FDebitQty, 0) balDebitQty, nvl(a.FDebitQty, 0) vchDebitQty, \n");
                sql.append("    nvl(b.FCreditQty, 0) balCreditQty, nvl(a.FCreditQty, 0) vchCreditQty, \n");
                if (comparePNL) {
                    sql.append("    nvl(b.FMonthPnl" + suffix + ", 0) balMonthPnlAmount, nvl(a.FMonthPnl" + suffix + ", 0) vchMonthPnlAmount, \n");
                    sql.append("    nvl(b.FMonthPnlQty, 0) balMonthPnlQty, nvl(a.FMonthPnlQty, 0) vchMonthPnlQty, \n");
                }
            }
            sql.append("    case when av1.FID is not null then av1.FNumber " + av1Name + " else av2.FNumber " + av2Name + " end account \n");
            sql.append("from b \n");
            sql.append("full join a on a.FAccountID = b.FAccountID \n");
            if (cyId == null) {
                sql.append(" and a.FCurrencyID = b.FCurrencyID \n");
            }
            sql.append("left join T_BD_AccountView av1 on av1.FID = b.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at1 on at1.fid = av1.FACCOUNTTABLEID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy1 on cy1.FID = b.FCurrencyID \n");
                }
            }
            sql.append("left join T_BD_AccountView av2 on av2.FID = a.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at2 on at2.fid = av2.FACCOUNTTABLEID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy2 on cy2.FID = a.FCurrencyID \n");
                }
            }
            if (compareAmt && compareQty) {
                sql.append("where ( \n");
                sql.append("    nvl(b.FDebit" + suffix + ", 0) <> nvl(a.FDebit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    nvl(b.FCredit" + suffix + ", 0) <> nvl(a.FCredit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    nvl(b.FDebitQty, 0) <> nvl(a.FDebitQty, 0) \n");
                sql.append("    or  \n");
                sql.append("    nvl(b.FCreditQty, 0) <> nvl(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    nvl(b.FMonthPnl" + suffix + ", 0) <> nvl(a.FMonthPnl" + suffix + ", 0) \n");
                    sql.append("    or  \n");
                    sql.append("    nvl(b.FMonthPnlQty, 0) <> nvl(a.FMonthPnlQty, 0) \n");
                }
                sql.append(") \n");
            } else if (compareAmt) {
                sql.append("where ( \n");
                sql.append("    nvl(b.FDebit" + suffix + ", 0) <> nvl(a.FDebit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    nvl(b.FCredit" + suffix + ", 0) <> nvl(a.FCredit" + suffix + ", 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    nvl(b.FMonthPnl" + suffix + ", 0) <> nvl(a.FMonthPnl" + suffix + ", 0) \n");
                }
                sql.append(") \n");
            } else if (compareQty) {
                sql.append("where ( \n");
                sql.append("    nvl(b.FDebitQty, 0) <> nvl(a.FDebitQty, 0) \n");
                sql.append("    or  \n");
                sql.append("    nvl(b.FCreditQty, 0) <> nvl(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    nvl(b.FMonthPnlQty, 0) <> nvl(a.FMonthPnlQty, 0) \n");
                }
                sql.append(") \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, company.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, company.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            pstmt.setString(index++, company.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 2);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("balDebitAmount", rs.getBigDecimal("balDebitAmount"));
                item.put("vchDebitAmount", rs.getBigDecimal("vchDebitAmount"));
                item.put("balDebitQty", rs.getBigDecimal("balDebitQty"));
                item.put("vchDebitQty", rs.getBigDecimal("vchDebitQty"));
                item.put("balCreditAmount", rs.getBigDecimal("balCreditAmount"));
                item.put("vchCreditAmount", rs.getBigDecimal("vchCreditAmount"));
                item.put("balCreditQty", rs.getBigDecimal("balCreditQty"));
                item.put("vchCreditQty", rs.getBigDecimal("vchCreditQty"));
                if (comparePNL) {
                    item.put("balMonthPnlAmount", rs.getBigDecimal("balMonthPnlAmount"));
                    item.put("vchMonthPnlAmount", rs.getBigDecimal("vchMonthPnlAmount"));
                    item.put("balMonthPnlQty", rs.getBigDecimal("balMonthPnlQty"));
                    item.put("vchMonthPnlQty", rs.getBigDecimal("vchMonthPnlQty"));
                }
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    private void analysisParentAccountCurrent(Context ctx, Map params, CompanyOrgUnitInfo company, PeriodInfo period, Set<String> accountIds, int balType, String cyId, boolean compareAmt, boolean compareQty, boolean comparePNL, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        String T_AccountBalance = GLBalanceUtils.getAccountBalanceTable(balType, cyId);
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> ps = new ArrayList<Object>();
        sql.append("select \n");
        if (SQLUtil.isOracle(ctx) && T_TMP_Account != null) {
            sql.append("    /*+ LEADING(tav) */ \n");
        }
        sql.append("    max(av.FLevel) \n");
        sql.append("from " + T_AccountBalance + " t \n");
        sql.append("join T_BD_AccountView av on av.FID = t.FAccountID \n");
        if (T_TMP_Account != null) {
            sql.append("join " + T_TMP_Account + " tav on tav.FID = t.FAccountID \n");
        }
        sql.append("where t.FOrgUnitID = ? and t.FPeriod = ? \n");
        ps.add(company.getId().toString());
        ps.add(period.getNumber());
        if (accountIds.size() > 0) {
            if (accountIds.size() == 1) {
                sql.append("      and t.FAccountID = ? \n");
                ps.add(accountIds.iterator().next());
            } else {
                sql.append("      and t.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
            }
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])ps.toArray());
        int maxLevel = 0;
        try {
            if (rs.next()) {
                maxLevel = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (maxLevel <= 1) {
            return;
        }
        for (int level = maxLevel; level > 1; --level) {
            this.doAnalysisParentAccountCurrent(ctx, params, company, period, accountIds, balType, cyId, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair, level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAnalysisParentAccountCurrent(Context ctx, Map params, CompanyOrgUnitInfo company, PeriodInfo period, Set<String> accountIds, int balType, String cyId, boolean compareAmt, boolean compareQty, boolean comparePNL, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair, int level) throws BOSException, SQLException {
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String prefix = "Original";
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                prefix = "Local";
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                prefix = "Reporting";
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cy1Name = "";
            String av1Name = "";
            String at1Name = "";
            String cy2Name = "";
            String av2Name = "";
            String at2Name = "";
            if (showName) {
                cy1Name = "|| '-' || cy1.FName_" + loc;
                av1Name = "|| '-' || av1.FName_" + loc;
                at1Name = "|| '-' || at1.FName_" + loc;
                cy2Name = "|| '-' || cy2.FName_" + loc;
                av2Name = "|| '-' || av2.FName_" + loc;
                at2Name = "|| '-' || at2.FName_" + loc;
            }
            boolean isOracle = SQLUtil.isOracle(ctx);
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    case when cy1.FID is not null then cy1.FNumber " + cy1Name + " else cy2.FNumber " + cy2Name + " end currency, \n");
                }
                sql.append("    case when at1.FID is not null then at1.FNumber " + at1Name + " else at2.FNumber " + at2Name + " end accountTable, \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) balDebitAmount, isnull(a.FDebit" + suffix + ", 0) vchDebitAmount, \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) balCreditAmount, isnull(a.FCredit" + suffix + ", 0) vchCreditAmount, \n");
                sql.append("    isnull(b.FDebitQty, 0) balDebitQty, isnull(a.FDebitQty, 0) vchDebitQty, \n");
                sql.append("    isnull(b.FCreditQty, 0) balCreditQty, isnull(a.FCreditQty, 0) vchCreditQty, \n");
                if (comparePNL) {
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) balMonthPnlAmount, isnull(a.FMonthPnl" + suffix + ", 0) vchMonthPnlAmount, \n");
                    sql.append("    isnull(b.FMonthPnlQty, 0) balMonthPnlQty, isnull(a.FMonthPnlQty, 0) vchMonthPnlQty, \n");
                }
            }
            sql.append("    case when av1.FID is not null then av1.FNumber " + av1Name + " else av2.FNumber " + av2Name + " end account \n");
            sql.append("from ( \n");
            sql.append("    select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            sql.append("        t.FAccountID, \n");
            if (cyId == null) {
                sql.append("        t.FCurrencyID, \n");
            }
            sql.append("        t.FDebit" + suffix + ", t.FCredit" + suffix + ", t.FDebitQty, t.FCreditQty \n");
            if (comparePNL) {
                sql.append("    ,t.FMonthPnl" + suffix + ", t.FMonthPnlQty \n");
            }
            sql.append("    from " + GLBalanceUtils.getAccountBalanceTable(balType, cyId) + " t \n");
            sql.append("    join t_bd_accountview ac on ac.fid = t.faccountid \n");
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = t.FAccountID and tav.FIsLeaf = 0 \n");
            }
            sql.append("    where t.FOrgUnitID = ? and t.FPeriod = ? and ac.FIsLeaf = 0 \n");
            sql.append("    and ac.FLevel = ? \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("      and t.FAccountID = ? \n");
                } else {
                    sql.append("      and t.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") b \n");
            sql.append("full join ( \n");
            sql.append("    select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            sql.append("        ac.FParentID FAccountID, \n");
            if (cyId == null) {
                sql.append("        t.FCurrencyID, \n");
            }
            sql.append("        sum(t.FDebit" + suffix + ") FDebit" + suffix + ", sum(t.FCredit" + suffix + ") FCredit" + suffix + ", \n");
            sql.append("        sum(t.FDebitQty) FDebitQty, sum(t.FCreditQty) FCreditQty \n");
            if (comparePNL) {
                sql.append("    ,sum(t.FMonthPnl" + suffix + ") FMonthPnl" + suffix + ", sum(t.FMonthPnlQty) FMonthPnlQty \n");
            }
            sql.append("    from " + GLBalanceUtils.getAccountBalanceTable(balType, cyId) + " t \n");
            sql.append("    join t_bd_accountview ac on ac.fid = t.faccountid \n");
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = ac.FParentID \n");
            }
            sql.append("    where t.FOrgUnitID = ? and t.FPeriod = ? \n");
            sql.append("    and ac.FLevel = ? \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("      and ac.FParentID = ? \n");
                } else {
                    sql.append("      and ac.FParentID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append("    group by ac.FParentID \n");
            if (cyId == null) {
                sql.append("        ,t.FCurrencyID \n");
            }
            sql.append(") a on a.FAccountID = b.FAccountID \n");
            if (cyId == null) {
                sql.append(" and a.FCurrencyID = b.FCurrencyID \n");
            }
            sql.append("left join T_BD_AccountView av1 on av1.FID = b.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at1 on at1.fid = av1.FACCOUNTTABLEID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy1 on cy1.FID = b.FCurrencyID \n");
                }
            }
            sql.append("left join T_BD_AccountView av2 on av2.FID = a.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at2 on at2.fid = av2.FACCOUNTTABLEID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy2 on cy2.FID = a.FCurrencyID \n");
                }
            }
            if (compareAmt && compareQty) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    av1.FIsQty = 1 and isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("    or  \n");
                sql.append("    av1.FIsQty = 1 and isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                    sql.append("    or  \n");
                    sql.append("    av1.FIsQty = 1 and isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append(") \n");
            } else if (compareAmt) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                }
                sql.append(") \n");
            } else if (compareQty) {
                sql.append("where ( \n");
                sql.append("    av1.FIsQty = 1 and isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("    or  \n");
                sql.append("    av1.FIsQty = 1 and isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    av1.FIsQty = 1 and isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append(") \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, company.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            pstmt.setInt(index++, level - 1);
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, company.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            pstmt.setInt(index++, level);
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 2);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("balDebitAmount", rs.getBigDecimal("balDebitAmount"));
                item.put("vchDebitAmount", rs.getBigDecimal("vchDebitAmount"));
                item.put("balDebitQty", rs.getBigDecimal("balDebitQty"));
                item.put("vchDebitQty", rs.getBigDecimal("vchDebitQty"));
                item.put("balCreditAmount", rs.getBigDecimal("balCreditAmount"));
                item.put("vchCreditAmount", rs.getBigDecimal("vchCreditAmount"));
                item.put("balCreditQty", rs.getBigDecimal("balCreditQty"));
                item.put("vchCreditQty", rs.getBigDecimal("vchCreditQty"));
                if (comparePNL) {
                    item.put("balMonthPnlAmount", rs.getBigDecimal("balMonthPnlAmount"));
                    item.put("vchMonthPnlAmount", rs.getBigDecimal("vchMonthPnlAmount"));
                    item.put("balMonthPnlQty", rs.getBigDecimal("balMonthPnlQty"));
                    item.put("vchMonthPnlQty", rs.getBigDecimal("vchMonthPnlQty"));
                }
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysisAssistCurrent(Context ctx, Map params, CompanyOrgUnitInfo company, PeriodInfo period, Set<String> accountIds, int balType, String cyId, int compareType, boolean compareAmt, boolean compareQty, boolean comparePNL, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String prefix = "Original";
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                prefix = "Local";
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                prefix = "Reporting";
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cyName = "";
            String avName = "";
            String atName = "";
            if (showName) {
                cyName = "|| '-' || cy.FName_" + loc;
                avName = "|| '-' || av.FName_" + loc;
                atName = "|| '-' || at.FName_" + loc;
            }
            boolean isOracle = SQLUtil.isOracle(ctx);
            sql.append("select \n");
            if (compareType == 1 && isOracle && T_TMP_Account != null) {
                sql.append("    /*+ LEADING(tav) */ \n");
            }
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    cy.FNumber " + cyName + " currency, \n");
                }
                sql.append("    at.FNumber " + atName + " accountTable, hg.FNumberGroup_l2 assist, \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) balDebitAmount, isnull(a.FDebit" + suffix + ", 0) vchDebitAmount, \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) balCreditAmount, isnull(a.FCredit" + suffix + ", 0) vchCreditAmount, \n");
                sql.append("    isnull(b.FDebitQty, 0) balDebitQty, isnull(a.FDebitQty, 0) vchDebitQty, \n");
                sql.append("    isnull(b.FCreditQty, 0) balCreditQty, isnull(a.FCreditQty, 0) vchCreditQty, \n");
                if (comparePNL) {
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) balMonthPnlAmount, isnull(a.FMonthPnl" + suffix + ", 0) vchMonthPnlAmount, \n");
                    sql.append("    isnull(b.FMonthPnlQty, 0) balMonthPnlQty, isnull(a.FMonthPnlQty, 0) vchMonthPnlQty, \n");
                }
            }
            sql.append("    av.FNumber " + avName + " account \n");
            if (compareType == 1) {
                sql.append("from " + GLBalanceUtils.getAssistBalanceTable(balType, cyId) + " b \n");
                sql.append("left join T_BD_AccountView av on av.FID = b.FAccountID \n");
                if (T_TMP_Account != null) {
                    sql.append("    join " + T_TMP_Account + " tav on tav.fid = b.faccountid \n");
                }
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = b.FCurrencyID \n");
                    }
                    sql.append("join T_BD_AssistantHG hg on hg.FID = b.FAssistGrpID \n");
                    sql.append("left join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join ( \n");
                sql.append("    select \n");
                if (isOracle && T_TMP_Account != null) {
                    sql.append("        /*+ LEADING(tav) */ \n");
                }
                sql.append("        ve.FAccountID, r.FAssGrpID FAssistGrpID, \n");
                if (cyId == null) {
                    sql.append("        ve.FCurrencyID, \n");
                }
                sql.append("        sum(r.F" + prefix + "Amount * ve.FEntryDC) FDebit" + suffix + ", \n");
                sql.append("        sum(r.F" + prefix + "Amount * (1 - ve.FEntryDC)) FCredit" + suffix + ", \n");
                sql.append("        sum(r.FStandardQuantity * ve.FEntryDC) FDebitQty, \n");
                sql.append("        sum(r.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty \n");
                if (comparePNL) {
                    sql.append("        ,sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.f" + prefix + "Amount else 0 end) FMonthPnl" + suffix + ", \n");
                    sql.append("        sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.FSTANDARDQUANTITY else 0 end) FMonthPnlQty \n");
                }
                sql.append("    from T_GL_Voucher v \n");
                sql.append("    inner join T_GL_VoucherEntry ve on v.FID = ve.FBillID \n");
                if (comparePNL) {
                    sql.append("    inner join t_bd_accountview ac on ac.fid = ve.faccountid \n");
                    sql.append("    inner join t_bd_accounttype acctType on ac.faccounttypeid = acctType.fid \n");
                }
                if (T_TMP_Account != null) {
                    sql.append("    join " + T_TMP_Account + " tav on tav.fid = ve.faccountid \n");
                }
                sql.append("    inner join T_GL_VoucherAssistRecord r on r.FENTRYID = ve.FID \n");
                sql.append("    where v.Fcompanyid = ? and v.fperiodid = ? and r.FAssGrpID is not null \n");
                sql.append("        and ve.Fcompanyid = ? and ve.fperiodid = ? \n");
                sql.append("        and r.Fcompanyid = ? and r.fperiodid = ? \n");
                if (balType == 1) {
                    sql.append("        and v.FbizStatus <> 0 and v.FbizStatus <> 2 \n");
                } else {
                    sql.append("        and v.FbizStatus = 5 \n");
                }
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and ve.FAccountID = ? \n");
                    } else {
                        sql.append("  and ve.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
                sql.append("    group by ve.FAccountID, r.FAssGrpID \n");
                if (cyId == null) {
                    sql.append("    , ve.FCurrencyID \n");
                }
                sql.append(") a on a.FAccountID = b.FAccountID and a.FAssistGrpID = b.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("    and a.FCurrencyID = b.FCurrencyID \n");
                }
                sql.append("where b.FOrgUnitID = ? and b.FPeriod = ? \n");
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and b.FAccountID = ? \n");
                    } else {
                        sql.append("  and b.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
            } else {
                sql.append("from ( \n");
                sql.append("    select \n");
                if (isOracle && T_TMP_Account != null) {
                    sql.append("        /*+ LEADING(tav) */ \n");
                }
                sql.append("        ve.FAccountID, r.FAssGrpID FAssistGrpID, \n");
                if (cyId == null) {
                    sql.append("        ve.FCurrencyID, \n");
                }
                sql.append("        sum(r.F" + prefix + "Amount * ve.FEntryDC) FDebit" + suffix + ", \n");
                sql.append("        sum(r.F" + prefix + "Amount * (1 - ve.FEntryDC)) FCredit" + suffix + ", \n");
                sql.append("        sum(r.FStandardQuantity * ve.FEntryDC) FDebitQty, \n");
                sql.append("        sum(r.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty \n");
                if (comparePNL) {
                    sql.append("        ,sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.f" + prefix + "Amount else 0 end) FMonthPnl" + suffix + ", \n");
                    sql.append("        sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.FSTANDARDQUANTITY else 0 end) FMonthPnlQty \n");
                }
                sql.append("    from T_GL_Voucher v \n");
                sql.append("    inner join T_GL_VoucherEntry ve on v.FID = ve.FBillID \n");
                if (comparePNL) {
                    sql.append("    inner join t_bd_accountview ac on ac.fid = ve.faccountid \n");
                    sql.append("    inner join t_bd_accounttype acctType on ac.faccounttypeid = acctType.fid \n");
                }
                if (T_TMP_Account != null) {
                    sql.append("    join " + T_TMP_Account + " tav on tav.fid = ve.faccountid \n");
                }
                sql.append("    inner join T_GL_VoucherAssistRecord r on r.FENTRYID = ve.FID \n");
                sql.append("    where v.Fcompanyid = ? and v.fperiodid = ? and r.FAssGrpID is not null \n");
                sql.append("        and ve.Fcompanyid = ? and ve.fperiodid = ? \n");
                sql.append("        and r.Fcompanyid = ? and r.fperiodid = ? \n");
                if (balType == 1) {
                    sql.append("        and v.FbizStatus <> 0 and v.FbizStatus <> 2 \n");
                } else {
                    sql.append("        and v.FbizStatus = 5 \n");
                }
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and ve.FAccountID = ? \n");
                    } else {
                        sql.append("  and ve.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
                sql.append("    group by ve.FAccountID, r.FAssGrpID \n");
                if (cyId == null) {
                    sql.append("    , ve.FCurrencyID \n");
                }
                sql.append(") a \n");
                sql.append("left join T_BD_AccountView av on av.FID = a.FAccountID \n");
                if (!isForRepair) {
                    if (cyId == null) {
                        sql.append("join T_BD_Currency cy on cy.FID = a.FCurrencyID \n");
                    }
                    sql.append("join T_BD_AssistantHG hg on hg.FID = a.FAssistGrpID \n");
                    sql.append("left join t_bd_accounttable at on at.fid = av.FACCOUNTTABLEID \n");
                }
                sql.append("left join " + GLBalanceUtils.getAssistBalanceTable(balType, cyId) + " b \n");
                sql.append("    on b.FOrgUnitID = ? and b.FPeriod = ? \n");
                sql.append("    and a.FAccountID = b.FAccountID and a.FAssistGrpID = b.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("    and a.FCurrencyID = b.FCurrencyID \n");
                }
                if (accountIds.size() > 0) {
                    if (accountIds.size() == 1) {
                        sql.append("  and b.FAccountID = ? \n");
                    } else {
                        sql.append("  and b.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    }
                }
                sql.append("where 1=1 \n");
            }
            if (compareAmt && compareQty) {
                sql.append("    and ( \n");
                sql.append("        isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("        or  \n");
                    sql.append("        isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                    sql.append("        or  \n");
                    sql.append("        isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append("    ) \n");
            } else if (compareAmt) {
                sql.append("    and ( \n");
                sql.append("        isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                if (comparePNL) {
                    sql.append("        or  \n");
                    sql.append("        isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                }
                sql.append("    ) \n");
            } else if (compareQty) {
                sql.append("    and ( \n");
                sql.append("        isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("        or  \n");
                sql.append("        isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("        or  \n");
                    sql.append("        isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append("    ) \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, company.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            pstmt.setString(index++, company.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            pstmt.setString(index++, company.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, company.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 2);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("assist", rs.getString("assist"));
                item.put("balDebitAmount", rs.getBigDecimal("balDebitAmount"));
                item.put("vchDebitAmount", rs.getBigDecimal("vchDebitAmount"));
                item.put("balDebitQty", rs.getBigDecimal("balDebitQty"));
                item.put("vchDebitQty", rs.getBigDecimal("vchDebitQty"));
                item.put("balCreditAmount", rs.getBigDecimal("balCreditAmount"));
                item.put("vchCreditAmount", rs.getBigDecimal("vchCreditAmount"));
                item.put("balCreditQty", rs.getBigDecimal("balCreditQty"));
                item.put("vchCreditQty", rs.getBigDecimal("vchCreditQty"));
                if (comparePNL) {
                    item.put("balMonthPnlAmount", rs.getBigDecimal("balMonthPnlAmount"));
                    item.put("vchMonthPnlAmount", rs.getBigDecimal("vchMonthPnlAmount"));
                    item.put("balMonthPnlQty", rs.getBigDecimal("balMonthPnlQty"));
                    item.put("vchMonthPnlQty", rs.getBigDecimal("vchMonthPnlQty"));
                }
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullAnalysisAssistCurrent(Context ctx, Map params, CompanyOrgUnitInfo company, PeriodInfo period, Set<String> accountIds, int balType, String cyId, boolean compareAmt, boolean compareQty, boolean comparePNL, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        boolean isOracle;
        String at2Name;
        String av2Name;
        String cy2Name;
        String at1Name;
        String av1Name;
        String cy1Name;
        String loc;
        String suffix;
        String prefix;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        StringBuffer sql;
        String T_TMP_Account;
        block51: {
            T_TMP_Account = (String)params.get("T_TMP_Account");
            sql = new StringBuffer();
            conn = null;
            pstmt = null;
            rs = null;
            conn = EJBFactory.getConnection((Context)ctx);
            prefix = "Original";
            suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                prefix = "Local";
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                prefix = "Reporting";
                suffix = "Rpt";
            }
            loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            cy1Name = "";
            av1Name = "";
            at1Name = "";
            cy2Name = "";
            av2Name = "";
            at2Name = "";
            if (showName) {
                cy1Name = "|| '-' || cy1.FName_" + loc;
                av1Name = "|| '-' || av1.FName_" + loc;
                at1Name = "|| '-' || at1.FName_" + loc;
                cy2Name = "|| '-' || cy2.FName_" + loc;
                av2Name = "|| '-' || av2.FName_" + loc;
                at2Name = "|| '-' || at2.FName_" + loc;
            }
            if (!(isOracle = SQLUtil.isOracle(ctx))) break block51;
            boolean isDialect = true;
            for (Object key : params.keySet()) {
                Object value;
                if (key == null || !key.toString().equalsIgnoreCase("dialect") || (value = params.get(key)) == null || !"false".equalsIgnoreCase(value.toString())) continue;
                isDialect = false;
            }
            if (!isDialect) break block51;
            this.fullAnalysisAssistCurrentForOracle(ctx, params, company, period, accountIds, balType, cyId, compareAmt, compareQty, comparePNL, showName, result, maxSize, isForRepair);
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            return;
        }
        try {
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    case when cy1.FID is not null then cy1.FNumber " + cy1Name + " else cy2.FNumber " + cy2Name + " end currency, \n");
                }
                sql.append("    case when at1.FID is not null then at1.FNumber " + at1Name + " else at2.FNumber " + at2Name + " end accountTable, \n");
                sql.append("    case when hg1.FID is not null then hg1.FNumberGroup_" + loc + " else hg2.FNumberGroup_" + loc + " end assist, \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) balDebitAmount, isnull(a.FDebit" + suffix + ", 0) vchDebitAmount, \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) balCreditAmount, isnull(a.FCredit" + suffix + ", 0) vchCreditAmount, \n");
                sql.append("    isnull(b.FDebitQty, 0) balDebitQty, isnull(a.FDebitQty, 0) vchDebitQty, \n");
                sql.append("    isnull(b.FCreditQty, 0) balCreditQty, isnull(a.FCreditQty, 0) vchCreditQty, \n");
                if (comparePNL) {
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) balMonthPnlAmount, isnull(a.FMonthPnl" + suffix + ", 0) vchMonthPnlAmount, \n");
                    sql.append("    isnull(b.FMonthPnlQty, 0) balMonthPnlQty, isnull(a.FMonthPnlQty, 0) vchMonthPnlQty, \n");
                }
            }
            sql.append("    case when av1.FID is not null then av1.FNumber " + av1Name + " else av2.FNumber " + av2Name + " end account \n");
            sql.append("from ( \n");
            sql.append("    select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            sql.append("        t.FAccountID, FAssistGrpID, \n");
            if (cyId == null) {
                sql.append("        t.FCurrencyID, \n");
            }
            sql.append("        t.FDebit" + suffix + ", t.FCredit" + suffix + ", t.FDebitQty, t.FCreditQty \n");
            if (comparePNL) {
                sql.append("    ,t.FMonthPnl" + suffix + ", t.FMonthPnlQty \n");
            }
            sql.append("    from " + GLBalanceUtils.getAssistBalanceTable(balType, cyId) + " t \n");
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = t.FAccountID \n");
            }
            sql.append("    where t.FOrgUnitID = ? and t.FPeriod = ? \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("      and t.FAccountID = ? \n");
                } else {
                    sql.append("      and t.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append(") b \n");
            sql.append("full join ( \n");
            sql.append("    select \n");
            if (isOracle && T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            sql.append("        ve.FAccountID, r.FAssGrpID FAssistGrpID, \n");
            if (cyId == null) {
                sql.append("        ve.FCurrencyID, \n");
            }
            sql.append("        sum(r.F" + prefix + "Amount * ve.FEntryDC) FDebit" + suffix + ", \n");
            sql.append("        sum(r.F" + prefix + "Amount * (1 - ve.FEntryDC)) FCredit" + suffix + ", \n");
            sql.append("        sum(r.FStandardQuantity * ve.FEntryDC) FDebitQty, \n");
            sql.append("        sum(r.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty \n");
            if (comparePNL) {
                sql.append("        ,sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.f" + prefix + "Amount else 0 end) FMonthPnl" + suffix + ", \n");
                sql.append("        sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.FSTANDARDQUANTITY else 0 end) FMonthPnlQty \n");
            }
            sql.append("    from T_GL_Voucher v \n");
            sql.append("    inner join T_GL_VoucherEntry ve on v.FID = ve.FBillID \n");
            if (comparePNL) {
                sql.append("    inner join t_bd_accountview ac on ac.fid = ve.faccountid \n");
                sql.append("    inner join t_bd_accounttype acctType on ac.faccounttypeid = acctType.fid \n");
            }
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = ve.FAccountID \n");
            }
            sql.append("    inner join T_GL_VoucherAssistRecord r on r.FENTRYID = ve.FID \n");
            sql.append("    where v.Fcompanyid = ? and v.fperiodid = ? and r.FAssGrpID is not null \n");
            sql.append("        and ve.Fcompanyid = ? and ve.fperiodid = ? \n");
            sql.append("        and r.Fcompanyid = ? and r.fperiodid = ? \n");
            if (balType == 1) {
                sql.append("        and v.FbizStatus <> 0 and v.FbizStatus <> 2 \n");
            } else {
                sql.append("        and v.FbizStatus = 5 \n");
            }
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("  and ve.FAccountID = ? \n");
                } else {
                    sql.append("  and ve.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append("    group by ve.FAccountID, r.FAssGrpID \n");
            if (cyId == null) {
                sql.append("    , ve.FCurrencyID \n");
            }
            sql.append(") a on a.FAccountID = b.FAccountID and a.FAssistGrpID = b.FAssistGrpID \n");
            if (cyId == null) {
                sql.append("    and a.FCurrencyID = b.FCurrencyID \n");
            }
            sql.append("left join T_BD_AccountView av1 on av1.FID = b.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at1 on at1.fid = av1.FACCOUNTTABLEID \n");
                sql.append("left join T_BD_AssistantHG hg1 on hg1.FID = b.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy1 on cy1.FID = b.FCurrencyID \n");
                }
            }
            sql.append("left join T_BD_AccountView av2 on av2.FID = a.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at2 on at2.fid = av2.FACCOUNTTABLEID \n");
                sql.append("left join T_BD_AssistantHG hg2 on hg2.FID = a.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy2 on cy2.FID = a.FCurrencyID \n");
                }
            }
            if (compareAmt && compareQty) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append(") \n");
            } else if (compareAmt) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FDebit" + suffix + ", 0) <> isnull(a.FDebit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCredit" + suffix + ", 0) <> isnull(a.FCredit" + suffix + ", 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnl" + suffix + ", 0) <> isnull(a.FMonthPnl" + suffix + ", 0) \n");
                }
                sql.append(") \n");
            } else if (compareQty) {
                sql.append("where ( \n");
                sql.append("    isnull(b.FDebitQty, 0) <> isnull(a.FDebitQty, 0) \n");
                sql.append("    or  \n");
                sql.append("    isnull(b.FCreditQty, 0) <> isnull(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    isnull(b.FMonthPnlQty, 0) <> isnull(a.FMonthPnlQty, 0) \n");
                }
                sql.append(") \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, company.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, company.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            pstmt.setString(index++, company.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            pstmt.setString(index++, company.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 2);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("assist", rs.getString("assist"));
                item.put("balDebitAmount", rs.getBigDecimal("balDebitAmount"));
                item.put("vchDebitAmount", rs.getBigDecimal("vchDebitAmount"));
                item.put("balDebitQty", rs.getBigDecimal("balDebitQty"));
                item.put("vchDebitQty", rs.getBigDecimal("vchDebitQty"));
                item.put("balCreditAmount", rs.getBigDecimal("balCreditAmount"));
                item.put("vchCreditAmount", rs.getBigDecimal("vchCreditAmount"));
                item.put("balCreditQty", rs.getBigDecimal("balCreditQty"));
                item.put("vchCreditQty", rs.getBigDecimal("vchCreditQty"));
                if (comparePNL) {
                    item.put("balMonthPnlAmount", rs.getBigDecimal("balMonthPnlAmount"));
                    item.put("vchMonthPnlAmount", rs.getBigDecimal("vchMonthPnlAmount"));
                    item.put("balMonthPnlQty", rs.getBigDecimal("balMonthPnlQty"));
                    item.put("vchMonthPnlQty", rs.getBigDecimal("vchMonthPnlQty"));
                }
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullAnalysisAssistCurrentForOracle(Context ctx, Map params, CompanyOrgUnitInfo company, PeriodInfo period, Set<String> accountIds, int balType, String cyId, boolean compareAmt, boolean compareQty, boolean comparePNL, boolean showName, List<Map<String, Object>> result, Integer maxSize, boolean isForRepair) throws BOSException, SQLException {
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String prefix = "Original";
            String suffix = "For";
            if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                prefix = "Local";
                suffix = "Local";
            } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                prefix = "Reporting";
                suffix = "Rpt";
            }
            String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String cy1Name = "";
            String av1Name = "";
            String at1Name = "";
            String cy2Name = "";
            String av2Name = "";
            String at2Name = "";
            if (showName) {
                cy1Name = "|| '-' || cy1.FName_" + loc;
                av1Name = "|| '-' || av1.FName_" + loc;
                at1Name = "|| '-' || at1.FName_" + loc;
                cy2Name = "|| '-' || cy2.FName_" + loc;
                av2Name = "|| '-' || av2.FName_" + loc;
                at2Name = "|| '-' || at2.FName_" + loc;
            }
            boolean isUseHash = true;
            for (Object key : params.keySet()) {
                Object value;
                if (key == null || !key.toString().equalsIgnoreCase("VoucherAssistQuery_USE_HASH") || (value = params.get(key)) == null || !"false".equalsIgnoreCase(value.toString())) continue;
                isUseHash = false;
            }
            String voucherQueryHint = "";
            if (isUseHash) {
                voucherQueryHint = T_TMP_Account != null ? "/*+ LEADING(tav,v,ve,r) USE_HASH(v,ve,r) */" : "/*+ LEADING(v,ve,r) USE_HASH(v,ve,r) */";
            } else if (T_TMP_Account != null) {
                voucherQueryHint = "/*+ LEADING(tav) */";
            }
            sql.append("/*dialect*/ with b as ( \n");
            sql.append("    select \n");
            if (T_TMP_Account != null) {
                sql.append("        /*+ LEADING(tav) */ \n");
            }
            sql.append("        t.FAccountID, FAssistGrpID, \n");
            if (cyId == null) {
                sql.append("        t.FCurrencyID, \n");
            }
            sql.append("        t.FDebit" + suffix + ", t.FCredit" + suffix + ", t.FDebitQty, t.FCreditQty \n");
            if (comparePNL) {
                sql.append("    ,t.FMonthPnl" + suffix + ", t.FMonthPnlQty \n");
            }
            sql.append("    from " + GLBalanceUtils.getAssistBalanceTable(balType, cyId) + " t \n");
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = t.FAccountID \n");
            }
            sql.append("    where t.FOrgUnitID = ? and t.FPeriod = ? \n");
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("      and t.FAccountID = ? \n");
                } else {
                    sql.append("      and t.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append("), \n");
            sql.append("a as ( \n");
            sql.append("    select " + voucherQueryHint + " \n");
            sql.append("        ve.FAccountID, r.FAssGrpID FAssistGrpID, \n");
            if (cyId == null) {
                sql.append("        ve.FCurrencyID, \n");
            }
            sql.append("        sum(r.F" + prefix + "Amount * ve.FEntryDC) FDebit" + suffix + ", \n");
            sql.append("        sum(r.F" + prefix + "Amount * (1 - ve.FEntryDC)) FCredit" + suffix + ", \n");
            sql.append("        sum(r.FStandardQuantity * ve.FEntryDC) FDebitQty, \n");
            sql.append("        sum(r.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty \n");
            if (comparePNL) {
                sql.append("        ,sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.f" + prefix + "Amount else 0 end) FMonthPnl" + suffix + ", \n");
                sql.append("        sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and ac.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.FSTANDARDQUANTITY else 0 end) FMonthPnlQty \n");
            }
            sql.append("    from T_GL_Voucher v \n");
            sql.append("    inner join T_GL_VoucherEntry ve on v.FID = ve.FBillID \n");
            if (comparePNL) {
                sql.append("    inner join t_bd_accountview ac on ac.fid = ve.faccountid \n");
                sql.append("    inner join t_bd_accounttype acctType on ac.faccounttypeid = acctType.fid \n");
            }
            if (T_TMP_Account != null) {
                sql.append("    join " + T_TMP_Account + " tav on tav.FID = ve.FAccountID \n");
            }
            sql.append("    inner join T_GL_VoucherAssistRecord r on r.FENTRYID = ve.FID \n");
            if (T_TMP_Account != null) {
                sql.append("    and r.FAccountID = tav.FID \n");
            }
            sql.append("    where v.Fcompanyid = ? and v.fperiodid = ? and r.FAssGrpID is not null \n");
            sql.append("        and ve.Fcompanyid = ? and ve.fperiodid = ? \n");
            sql.append("        and r.Fcompanyid = ? and r.fperiodid = ? \n");
            if (balType == 1) {
                sql.append("        and v.FbizStatus <> 0 and v.FbizStatus <> 2 \n");
            } else {
                sql.append("        and v.FbizStatus = 5 \n");
            }
            if (accountIds.size() > 0) {
                if (accountIds.size() == 1) {
                    sql.append("  and ve.FAccountID = ? \n");
                    sql.append("  and r.FAccountID = ? \n");
                } else {
                    sql.append("  and ve.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                    sql.append("  and r.FAccountID in " + GLBalanceAnaFacadeControllerBean.toInSql(accountIds) + " \n");
                }
            }
            sql.append("    group by ve.FAccountID, r.FAssGrpID \n");
            if (cyId == null) {
                sql.append("    , ve.FCurrencyID \n");
            }
            sql.append(") \n");
            sql.append("select \n");
            if (!isForRepair) {
                if (cyId == null) {
                    sql.append("    case when cy1.FID is not null then cy1.FNumber " + cy1Name + " else cy2.FNumber " + cy2Name + " end currency, \n");
                }
                sql.append("    case when at1.FID is not null then at1.FNumber " + at1Name + " else at2.FNumber " + at2Name + " end accountTable, \n");
                sql.append("    case when hg1.FID is not null then hg1.FNumberGroup_" + loc + " else hg2.FNumberGroup_" + loc + " end assist, \n");
                sql.append("    nvl(b.FDebit" + suffix + ", 0) balDebitAmount, nvl(a.FDebit" + suffix + ", 0) vchDebitAmount, \n");
                sql.append("    nvl(b.FCredit" + suffix + ", 0) balCreditAmount, nvl(a.FCredit" + suffix + ", 0) vchCreditAmount, \n");
                sql.append("    nvl(b.FDebitQty, 0) balDebitQty, nvl(a.FDebitQty, 0) vchDebitQty, \n");
                sql.append("    nvl(b.FCreditQty, 0) balCreditQty, nvl(a.FCreditQty, 0) vchCreditQty, \n");
                if (comparePNL) {
                    sql.append("    nvl(b.FMonthPnl" + suffix + ", 0) balMonthPnlAmount, nvl(a.FMonthPnl" + suffix + ", 0) vchMonthPnlAmount, \n");
                    sql.append("    nvl(b.FMonthPnlQty, 0) balMonthPnlQty, nvl(a.FMonthPnlQty, 0) vchMonthPnlQty, \n");
                }
            }
            sql.append("    case when av1.FID is not null then av1.FNumber " + av1Name + " else av2.FNumber " + av2Name + " end account \n");
            sql.append("from  b \n");
            sql.append("full join a on a.FAccountID = b.FAccountID and a.FAssistGrpID = b.FAssistGrpID \n");
            if (cyId == null) {
                sql.append("    and a.FCurrencyID = b.FCurrencyID \n");
            }
            sql.append("left join T_BD_AccountView av1 on av1.FID = b.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at1 on at1.fid = av1.FACCOUNTTABLEID \n");
                sql.append("left join T_BD_AssistantHG hg1 on hg1.FID = b.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy1 on cy1.FID = b.FCurrencyID \n");
                }
            }
            sql.append("left join T_BD_AccountView av2 on av2.FID = a.FAccountID \n");
            if (!isForRepair) {
                sql.append("left join t_bd_accounttable at2 on at2.fid = av2.FACCOUNTTABLEID \n");
                sql.append("left join T_BD_AssistantHG hg2 on hg2.FID = a.FAssistGrpID \n");
                if (cyId == null) {
                    sql.append("left join T_BD_Currency cy2 on cy2.FID = a.FCurrencyID \n");
                }
            }
            if (compareAmt && compareQty) {
                sql.append("where ( \n");
                sql.append("    nvl(b.FDebit" + suffix + ", 0) <> nvl(a.FDebit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    nvl(b.FCredit" + suffix + ", 0) <> nvl(a.FCredit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    nvl(b.FDebitQty, 0) <> nvl(a.FDebitQty, 0) \n");
                sql.append("    or  \n");
                sql.append("    nvl(b.FCreditQty, 0) <> nvl(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    nvl(b.FMonthPnl" + suffix + ", 0) <> nvl(a.FMonthPnl" + suffix + ", 0) \n");
                    sql.append("    or  \n");
                    sql.append("    nvl(b.FMonthPnlQty, 0) <> nvl(a.FMonthPnlQty, 0) \n");
                }
                sql.append(") \n");
            } else if (compareAmt) {
                sql.append("where ( \n");
                sql.append("    nvl(b.FDebit" + suffix + ", 0) <> nvl(a.FDebit" + suffix + ", 0) \n");
                sql.append("    or  \n");
                sql.append("    nvl(b.FCredit" + suffix + ", 0) <> nvl(a.FCredit" + suffix + ", 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    nvl(b.FMonthPnl" + suffix + ", 0) <> nvl(a.FMonthPnl" + suffix + ", 0) \n");
                }
                sql.append(") \n");
            } else if (compareQty) {
                sql.append("where ( \n");
                sql.append("    nvl(b.FDebitQty, 0) <> nvl(a.FDebitQty, 0) \n");
                sql.append("    or  \n");
                sql.append("    nvl(b.FCreditQty, 0) <> nvl(a.FCreditQty, 0) \n");
                if (comparePNL) {
                    sql.append("    or  \n");
                    sql.append("    nvl(b.FMonthPnlQty, 0) <> nvl(a.FMonthPnlQty, 0) \n");
                }
                sql.append(") \n");
            }
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            pstmt.setString(index++, company.getId().toString());
            pstmt.setInt(index++, period.getNumber());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
            }
            pstmt.setString(index++, company.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            pstmt.setString(index++, company.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            pstmt.setString(index++, company.getId().toString());
            pstmt.setString(index++, period.getId().toString());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next());
                pstmt.setString(index++, accountIds.iterator().next());
            }
            rs = pstmt.executeQuery();
            while (rs.next() && result.size() < maxSize) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("account", rs.getString("account"));
                item.put("period", period.getNumber());
                if (isForRepair) {
                    result.add(item);
                    continue;
                }
                item.put("balType", balType);
                item.put("sourceType", 2);
                if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cyId)) {
                    item.put("currency", "GLC");
                } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cyId)) {
                    item.put("currency", "GRC");
                } else {
                    item.put("currency", rs.getString("currency"));
                }
                item.put("accountTable", rs.getString("accountTable"));
                item.put("assist", rs.getString("assist"));
                item.put("balDebitAmount", rs.getBigDecimal("balDebitAmount"));
                item.put("vchDebitAmount", rs.getBigDecimal("vchDebitAmount"));
                item.put("balDebitQty", rs.getBigDecimal("balDebitQty"));
                item.put("vchDebitQty", rs.getBigDecimal("vchDebitQty"));
                item.put("balCreditAmount", rs.getBigDecimal("balCreditAmount"));
                item.put("vchCreditAmount", rs.getBigDecimal("vchCreditAmount"));
                item.put("balCreditQty", rs.getBigDecimal("balCreditQty"));
                item.put("vchCreditQty", rs.getBigDecimal("vchCreditQty"));
                if (comparePNL) {
                    item.put("balMonthPnlAmount", rs.getBigDecimal("balMonthPnlAmount"));
                    item.put("vchMonthPnlAmount", rs.getBigDecimal("vchMonthPnlAmount"));
                    item.put("balMonthPnlQty", rs.getBigDecimal("balMonthPnlQty"));
                    item.put("vchMonthPnlQty", rs.getBigDecimal("vchMonthPnlQty"));
                }
                item.put("anaPt", period.get("anaPt"));
                result.add(item);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    private boolean isForRepair(Map<String, Object> params) {
        return params != null && params.get("AnaBal_Repair") != null && (Boolean)params.get("AnaBal_Repair") != false;
    }

    public String getResource(Context ctx, String resName) {
        return ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)ctx.getLocale());
    }
}

