/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.Context;
import com.kingdee.eas.fi.gl.app.BalanceCalJob;
import com.kingdee.eas.fi.gl.app.BalanceRepairJob;
import com.kingdee.eas.fi.gl.app.CheckVoucherNumberJob;
import com.kingdee.eas.fi.gl.app.DeleteVoucherLogJob;
import com.kingdee.eas.fi.gl.app.DeleteVoucherNumberLogJob;
import com.kingdee.eas.fi.gl.app.RefreshDSJob;
import com.kingdee.eas.fi.gl.app.SmartAccountCleanReportJob;
import com.kingdee.eas.fi.gl.app.SmartAccountRepairJob;
import com.kingdee.eas.fi.gl.app.TempFileDeleteJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class GLBalanceCalService
implements ServletContextListener {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLBalaneceCalService");
    private static final String EAS_INSTANCE_CONFIG_PATH = "EAS_INSTANCE_CONFIG_PATH";
    private static final String GLBALANCE_CAL_PERIOD = "GLBALANCE_CAL_PERIOD";
    private static final String CHECK_VOUCHER_NUMBER_MINUTE = "CHECK_VOUCHER_NUMBER_MINUTE";
    private static final String VOUCHERLOG_CLEAR_TIME = "VOUCHERLOG_CLEAR_TIME";
    private static final String SMARTACCOUNT_DETAILREPORT_REMAIN_DAY = "SMARTACCOUNT_DETAILREPORT_REMAIN_DAY";
    private static final String SMARTACCOUNT_REPORT_CLEAN_TIME = "SMARTACCOUNT_REPORT_CLEAN_TIME";
    private Scheduler scheduler = null;
    private Vector<Context> ctxs = new Vector();

    public void contextInitialized(ServletContextEvent event) {
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
        }
        catch (Exception ex) {
            logger.error((Object)"Get default scheduler fail!", (Throwable)ex);
            return;
        }
        this.scheduleRefreshContext();
        Properties prop = this.getBalanceCalConfig();
        this.scheduleBalanceCal(this.getBalCalPeriod(prop));
        this.scheduleDelVoucherLog(this.getStartHour(prop));
        this.scheduleDelVoucherNumberLog(this.getStartHour(prop));
        this.scheduleCheckVchNumber(this.getCheckVoucherNumberHour(prop));
        this.scheduleBalanceRepair();
        this.scheduleSmartAccountRepair();
        this.scheduleSmartAccountCleanDetailRpt(this.getSmartAccountCleanRptStartHour(prop), this.getSmartAccountRemainDays(prop));
        this.scheduleTempFileDelete();
        try {
            this.scheduler.start();
        }
        catch (SchedulerException ex) {
            logger.error((Object)"scheduler start fail!", (Throwable)ex);
        }
    }

    private void scheduleSmartAccountCleanDetailRpt(int startHour, int smartAccountRemainDays) {
        if (smartAccountRemainDays <= 0) {
            return;
        }
        JobDetail jobDetail = JobBuilder.newJob(SmartAccountCleanReportJob.class).withIdentity("SmartAccountCleanDetailRpt", "DEFAULT").build();
        jobDetail.getJobDataMap().put("ctxs", this.ctxs);
        jobDetail.getJobDataMap().put("remainDays", smartAccountRemainDays);
        try {
            String cron = "0 0 " + startHour + " * * ?";
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("SmartAccountCleanDetailRpt", "DEFAULT").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (Exception ex) {
            logger.error((Object)"Balance repair schedule error!", (Throwable)ex);
        }
    }

    private void scheduleRefreshContext() {
        JobDetail jobDetail = JobBuilder.newJob(RefreshDSJob.class).withIdentity("GLRefreshDS", "DEFAULT").build();
        jobDetail.getJobDataMap().put("ctxs", this.ctxs);
        SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity("refreshDSTrigger", "DEFAULT").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(10).withRepeatCount(-1)).startNow().build();
        try {
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException ex) {
            logger.error((Object)"Refresh DS schedule error!", (Throwable)ex);
        }
    }

    private void scheduleBalanceCal(int period) {
        JobDetail jobDetail = JobBuilder.newJob(BalanceCalJob.class).withIdentity("GLBalanceCal", "DEFAULT").build();
        jobDetail.getJobDataMap().put("ctxs", this.ctxs);
        SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity("GLBalanceCalTrigger", "DEFAULT").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(period).withRepeatCount(-1)).startNow().build();
        try {
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException ex) {
            logger.error((Object)"Balance calculate schedule error!", (Throwable)ex);
        }
    }

    private void scheduleCheckVchNumber(int min) {
        JobDetail jobDetail = JobBuilder.newJob(CheckVoucherNumberJob.class).withIdentity("GLCheckVchNumber", "DEFAULT").build();
        jobDetail.getJobDataMap().put("ctxs", this.ctxs);
        SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity("GLCheckVoucherNumberTrigger", "DEFAULT").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(min).withRepeatCount(-1)).startNow().build();
        try {
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException ex) {
            logger.error((Object)"CheckVchNumber schedule error!", (Throwable)ex);
        }
    }

    private void scheduleDelVoucherLog(int startHour) {
        JobDetail jobDetail = JobBuilder.newJob(DeleteVoucherLogJob.class).withIdentity("GLDeleteVoucherLog", "DEFAULT").build();
        jobDetail.getJobDataMap().put("ctxs", this.ctxs);
        try {
            String cron = "0 0 " + startHour + " * * ?";
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("GLDeleteVoucherTrigger", "DEFAULT").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (Exception ex) {
            logger.error((Object)"Delete VoucherLog schedule error!", (Throwable)ex);
        }
    }

    private void scheduleDelVoucherNumberLog(int startHour) {
        JobDetail jobDetail = JobBuilder.newJob(DeleteVoucherNumberLogJob.class).withIdentity("GLDeleteVoucherNumberLog", "DEFAULT").build();
        jobDetail.getJobDataMap().put("ctxs", this.ctxs);
        try {
            String cron = "0 0 " + startHour + " * * ?";
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("GLDeleteVoucherNumberLogTrigger", "DEFAULT").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (Exception ex) {
            logger.error((Object)"Delete VoucherNumberLog schedule error!", (Throwable)ex);
        }
    }

    private void scheduleBalanceRepair() {
        JobDetail jobDetail = JobBuilder.newJob(BalanceRepairJob.class).withIdentity("GLBalanceRepair", "DEFAULT").build();
        jobDetail.getJobDataMap().put("ctxs", this.ctxs);
        try {
            String cron = "0 0,30 * * * ?";
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("GLBalanceRepairTrigger", "DEFAULT").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (Exception ex) {
            logger.error((Object)"Balance repair schedule error!", (Throwable)ex);
        }
    }

    private void scheduleSmartAccountRepair() {
        JobDetail jobDetail = JobBuilder.newJob(SmartAccountRepairJob.class).withIdentity("SmartAccountRepair", "DEFAULT").build();
        jobDetail.getJobDataMap().put("ctxs", this.ctxs);
        jobDetail.getJobDataMap().put("nowDate", (Object)new Date());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(13, 10);
        SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity("SmartAccountRepair", "DEFAULT").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(3L).withRepeatCount(0)).startAt(calendar.getTime()).build();
        try {
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (Exception ex) {
            logger.error((Object)"Balance repair schedule error!", (Throwable)ex);
        }
    }

    private void scheduleTempFileDelete() {
        JobDetail jobDetail = JobBuilder.newJob(TempFileDeleteJob.class).withIdentity("GLTempFileDelete", "DEFAULT").build();
        jobDetail.getJobDataMap().put("ctxs", this.ctxs);
        try {
            String cron = "0 0 6 * * ?";
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("GLTempFileDeleteTrigger", "DEFAULT").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (Exception ex) {
            logger.error((Object)"GL temporary file delete error!", (Throwable)ex);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        try {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
        catch (SchedulerException e) {
            logger.error((Object)"Balance calculate scheduler shutdow error!", (Throwable)e);
        }
    }

    private int getBalCalPeriod(Properties prop) {
        int calPeriod = 1;
        if (prop == null) {
            return calPeriod;
        }
        String calPeriodStr = prop.getProperty(GLBALANCE_CAL_PERIOD);
        if (calPeriodStr != null && calPeriodStr.trim().length() > 0) {
            int index = calPeriodStr.indexOf(35);
            if (index != -1) {
                calPeriodStr = calPeriodStr.substring(0, index);
            }
            try {
                int period = Integer.parseInt(calPeriodStr.trim());
                if (period > 0) {
                    calPeriod = period;
                }
            }
            catch (Exception ex) {
                logger.error((Object)("BalanceCal Config error! the GLBALANCE_CAL_PERIOD is " + calPeriodStr + "."), (Throwable)ex);
            }
        }
        return calPeriod;
    }

    private int getCheckVoucherNumberHour(Properties prop) {
        int min = 10;
        if (prop == null) {
            return min;
        }
        String minStr = prop.getProperty(CHECK_VOUCHER_NUMBER_MINUTE);
        if (minStr != null && minStr.trim().length() > 0) {
            try {
                int period = Integer.parseInt(minStr.trim());
                if (period > 0) {
                    min = period;
                }
            }
            catch (Exception ex) {
                logger.error((Object)("CheckVoucherNumberMinute Config error! the CHECK_VOUCHER_NUMBER_MINUTE is " + minStr + "."), (Throwable)ex);
            }
        }
        return min;
    }

    private int getStartHour(Properties prop) {
        int clearTime = 2;
        if (prop == null) {
            return clearTime;
        }
        String clearTimeStr = prop.getProperty(VOUCHERLOG_CLEAR_TIME);
        if (clearTimeStr != null && clearTimeStr.trim().length() > 0) {
            try {
                int time = Integer.parseInt(clearTimeStr.trim());
                if (time >= 0 && time <= 23) {
                    clearTime = time;
                }
            }
            catch (Exception ex) {
                logger.error((Object)("BalanceCal Config error! the VOUCHERLOG_CLEAR_TIME is " + clearTimeStr + "."), (Throwable)ex);
            }
        }
        return clearTime;
    }

    private int getSmartAccountRemainDays(Properties prop) {
        String remainDays;
        if (prop != null && (remainDays = prop.getProperty(SMARTACCOUNT_DETAILREPORT_REMAIN_DAY)) != null && remainDays.trim().length() > 0) {
            try {
                return Integer.parseInt(remainDays);
            }
            catch (Exception e) {
                logger.error((Object)"get smartAccount config property error", (Throwable)e);
            }
        }
        return -1;
    }

    private int getSmartAccountCleanRptStartHour(Properties prop) {
        String startHourStr;
        int startHour = 1;
        if (prop != null && (startHourStr = prop.getProperty(SMARTACCOUNT_REPORT_CLEAN_TIME)) != null && startHourStr.trim().length() > 0) {
            try {
                int hour = Integer.parseInt(startHourStr);
                startHour = hour >= 0 && hour <= 23 ? hour : startHour;
            }
            catch (Exception e) {
                logger.error((Object)"get smartAccount config property error", (Throwable)e);
            }
        }
        return startHour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getBalanceCalConfig() {
        String path = System.getProperty(EAS_INSTANCE_CONFIG_PATH) + "/GLBalanceCal.properties";
        File cf = new File(path);
        if (!cf.exists() || !cf.isFile()) {
            this.createNewConfig(cf);
        }
        FileInputStream fis = null;
        Properties prop = null;
        try {
            fis = new FileInputStream(cf);
            prop = new Properties();
            prop.load(fis);
        }
        catch (Exception e) {
            logger.error((Object)"Load BalanceCal Config fail!", (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Close FileInputStream fail!", (Throwable)e);
                }
            }
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewConfig(File cf) {
        BufferedWriter output = null;
        try {
            cf.createNewFile();
            output = new BufferedWriter(new FileWriter(cf));
            output.write("# What time cleaning voucher log");
            output.newLine();
            output.write("VOUCHERLOG_CLEAR_TIME=2");
            output.newLine();
            output.write("# How many minutes to perform a calculate of balance");
            output.newLine();
            output.write("GLBALANCE_CAL_PERIOD=1");
            output.newLine();
            output.write("# What time cleaning voucher log");
            output.newLine();
            output.write("VOUCHERLOG_CLEAR_TIME=2");
            output.newLine();
            output.write("# How many minutes to check voucher number");
            output.newLine();
            output.write("CHECK_VOUCHER_NUMBER_MINUTE=10");
            output.newLine();
            output.write("SMARTACCOUNT_DETAILREPORT_REMAIN_DAY=-1");
            output.newLine();
            output.write("SMARTACCOUNT_REPORT_CLEAN_TIME=1");
        }
        catch (Exception e) {
            logger.error((Object)"Load BalanceCal Config fail!", (Throwable)e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Close BufferedWriter fail!", (Throwable)e);
                }
            }
        }
    }
}

