/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.TransactionFacadeFactory;
import com.kingdee.eas.fi.gl.app.AbstractGLBalanceFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.GLAsstAccountChangeTransfer;
import com.kingdee.eas.fi.gl.app.TransactionInvoker;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.pcc.FIClosingCenterFacadeFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class GLBalanceFacadeControllerBean
extends AbstractGLBalanceFacadeControllerBean {
    private static final String T_GL_INITASSISTBALANCE = "t_gl_initassistbalance";
    private static final String T_GL_INITACCOUNTBALANCE = "t_gl_initaccountbalance";
    private static final String T_GL_VOUCHERASSISTRECORD = "t_gl_voucherassistrecord";
    private static final String T_GL_VOUCHERENTRY = "t_gl_voucherentry";
    private static final String T_GL_VOUCHER = "t_gl_voucher";
    protected static final String STRING = "";
    private static final String T_ORG_COMPANY = "t_org_company";
    private static final String ORGUNITID = "orgunitid";
    private static final String FORGUNITID = "forgunitid";
    private static final String FCOMPANYID = "fcompanyid";
    private static final String T_GL_VOUCHERLOG = "t_gl_voucher_log";
    private static final long serialVersionUID = 7783447274525442696L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLBalanceFacadeControllerBean");
    private static final int ACCOUNT_BALANCE = 1;
    private static final int ASSIST_BALANCE = 2;
    private static final int MEASURE_BALANCE = 3;
    protected static final short WAIT_PERIOD = 500;
    protected static final int MAX_TIMECOUNT = 10000;
    protected static final int TIME_OUT = 300000;
    protected static final Integer NO_UPDATE = new Integer(0);
    protected static final Integer UPDATED = new Integer(1);
    protected static final String BalUpdateCt = "balance_update_conflict";
    private static final Map<String, Integer> vlGroupSums = new HashMap<String, Integer>();

    @Override
    protected void _scheduleUpdateVoucherBalance(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select top 1 ").append(this.getOrgColumnName()).append(" from (");
        sql.append(" select count(1) logNum, lg.").append(this.getOrgColumnName()).append(" from " + this.getVoucherLogTable() + " lg");
        sql.append(" where lg.fisupdating = 0");
        sql.append(" and not exists (select 1 from t_bas_transaction tr where lg.").append(this.getOrgColumnName()).append(" = tr.fid");
        sql.append(" and tr.fisupdating = 1 and tr.fnumber = 'updatebalance' and tr.fsystype = " + this.getSystemTypeValue());
        sql.append(" ) ");
        sql.append(" group by lg.").append(this.getOrgColumnName()).append(") c order by c.logNum desc");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                String[] companyIds = new String[]{rs.getString(this.getOrgColumnName())};
                this._updateVoucherBalance(ctx, companyIds);
            }
        }
        catch (SQLException se) {
            logger.error((Object)("sql error!" + se.getMessage()));
        }
    }

    @Override
    protected void _updateVoucherBalance(Context ctx, String[] companyIds) throws BOSException {
        if (companyIds == null || companyIds.length == 0) {
            companyIds = new String[]{ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()};
        }
        String[] cpIds = this.distinctId(companyIds);
        boolean isSerial = false;
        if (6 == this.getSystemTypeValue()) {
            try {
                HashMap<String, Object> ins = new HashMap<String, Object>();
                ins.put("GL_BalUpd_Serial", null);
                HashMap result = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(ins);
                Object param = result.get("GL_BalUpd_Serial");
                if (param != null) {
                    isSerial = Boolean.valueOf(param.toString());
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Get param GL_BalUpd_Serial error!", (Throwable)ex);
            }
        }
        Map<String, Object> params = null;
        if (isSerial) {
            params = this.getCalcParams(ctx);
        }
        if (!this.isNeedUpdate(ctx, cpIds)) {
            return;
        }
        String[] calCpIds = null;
        try {
            GLBalanceFacadeFactory.getLocalInstance(ctx).fillTransaction(cpIds);
            calCpIds = this.getNeedUpdateCompanys(ctx, cpIds);
            if (calCpIds == null || calCpIds.length == 0) {
                return;
            }
            if (!this.isNeedUpdate(ctx, calCpIds)) {
                return;
            }
            if (isSerial) {
                HashSet<String> orgUnitIds = new HashSet<String>();
                for (String orgUnitId : calCpIds) {
                    orgUnitIds.add(orgUnitId);
                }
                this._calc(ctx, orgUnitIds, params);
            } else {
                GLBalanceFacadeFactory.getLocalInstance(ctx).doUpdateVoucherBalance(calCpIds);
            }
        }
        catch (Throwable e) {
            throw new BOSException("Update voucher balance error!", e);
        }
        finally {
            if (calCpIds != null && calCpIds.length > 0) {
                GLBalanceFacadeFactory.getLocalInstance(ctx).unLockCalBalance(calCpIds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isNeedUpdate(Context ctx, String[] companyIds) throws BOSException {
        String sql4;
        if (companyIds.length <= 50) {
            boolean isMSSQLSERVER = SQLUtil.isMSSQLSERVER(ctx);
            StringBuffer sql2 = new StringBuffer();
            if (isMSSQLSERVER) {
                sql2.append("/*dialect*/ ");
            }
            sql2.append("select top 1 1 from ").append(this.getVoucherLogTable()).append(" ");
            if (isMSSQLSERVER) {
                sql2.append("with(readpast) ");
            }
            sql2.append("where fisupdating = 0 ");
            if (companyIds.length > 0) {
                sql2.append("and ").append(this.getOrgColumnName()).append(" in ").append(SQLUtil.buildMarkSQL(companyIds.length));
            }
            IRowSet rs = companyIds.length > 0 ? DbUtil.executeQuery((Context)ctx, (String)sql2.toString(), (Object[])companyIds) : DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
            try {
                if (rs.next()) {
                    return true;
                }
            }
            catch (SQLException e) {
                throw new BOSException("SQL ERROR!", (Throwable)e);
            }
            return false;
        }
        String tableName = this.getTempTableName(ctx, "ac", "ORGID VARCHAR(44)");
        GLBalanceFacadeControllerBean.insertTempTable(ctx, companyIds, tableName);
        IRowSet rs = null;
        if (SQLUtil.isMSSQLSERVER(ctx)) {
            try {
                sql4 = "/*dialect*/ select top 1 * from " + tableName + " with(readpast) INNER join " + this.getVoucherLogTable() + " on " + this.getVoucherLogTable() + ".fisupdating = 0 and " + this.getVoucherLogTable() + "." + this.getOrgColumnName() + "= " + tableName + ".ORGID ";
                rs = DbUtil.executeQuery((Context)ctx, (String)sql4);
            }
            catch (BOSException e) {
                logger.error((Object)"The dbType is SQLServer in context, Is it right?", (Throwable)e);
                String sql3 = "select top 1 * from " + tableName + " INNER join " + this.getVoucherLogTable() + " on " + this.getVoucherLogTable() + ".fisupdating = 0 and " + this.getVoucherLogTable() + "." + this.getOrgColumnName() + "= " + tableName + ".ORGID ";
                rs = DbUtil.executeQuery((Context)ctx, (String)sql3);
            }
            finally {
                this.releaseTempTableName(ctx, tableName);
            }
        } else {
            sql4 = "select top 1 * from " + tableName + " INNER join " + this.getVoucherLogTable() + " on " + this.getVoucherLogTable() + ".fisupdating = 0 and " + this.getVoucherLogTable() + "." + this.getOrgColumnName() + "= " + tableName + ".ORGID ";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql4);
        }
        try {
            if (rs.next()) {
                boolean sql4 = true;
                return sql4;
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        finally {
            this.releaseTempTableName(ctx, tableName);
        }
        return false;
    }

    protected String listId2StrId(String[] companyIds) {
        if (companyIds != null) {
            StringBuffer cpIds = new StringBuffer();
            for (int i = 0; i < companyIds.length; ++i) {
                if (i > 0) {
                    cpIds.append(",");
                }
                cpIds.append("'").append(companyIds[i]).append("'");
            }
            return cpIds.toString();
        }
        return null;
    }

    protected String[] distinctId(String[] companyIds) {
        if (companyIds == null) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < companyIds.length; ++i) {
            idSet.add(companyIds[i]);
        }
        String[] cpIds = new String[idSet.size()];
        Iterator it = idSet.iterator();
        int i = 0;
        while (it.hasNext()) {
            cpIds[i++] = (String)it.next();
        }
        return cpIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isGroupSumVoucherLog(Context ctx) throws BOSException {
        Integer vlGroupSum = vlGroupSums.get(ctx.getAIS());
        if (vlGroupSum != null) {
            return vlGroupSum == 1;
        }
        Map<String, Integer> map = vlGroupSums;
        synchronized (map) {
            vlGroupSum = vlGroupSums.get(ctx.getAIS());
            if (vlGroupSum != null) {
                return vlGroupSum == 1;
            }
            String sql = "select fdefaultval_l2 val from t_bas_param where fnumber = 'GL_VOUCHER_LOG_GROUPSUM'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            vlGroupSum = 0;
            try {
                if (rs.next() && "true".equalsIgnoreCase(rs.getString("val"))) {
                    vlGroupSum = 1;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            vlGroupSums.put(ctx.getAIS(), vlGroupSum);
            return vlGroupSum == 1;
        }
    }

    private static boolean isArchiveVoucherLog(Context ctx) throws BOSException {
        String sql = "select fdefaultval_l2 val from t_bas_param where fnumber = 'GL_VOUCHER_LOG'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        Integer vlArchive = 0;
        try {
            if (rs.next() && "true".equalsIgnoreCase(rs.getString("val"))) {
                vlArchive = 1;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return vlArchive == 1;
    }

    @Override
    protected void _insertVoucherLog(Context ctx, String[] voucherIds, int action, boolean isDeduct, boolean isPost) throws BOSException {
        if (6 == this.getSystemTypeValue() && this.existOracleVoucherLogTrigger(ctx)) {
            return;
        }
        if (6 == this.getSystemTypeValue() && GLBalanceFacadeControllerBean.isGroupSumVoucherLog(ctx)) {
            this._groupSumInsertVoucherLog(ctx, voucherIds, action, isDeduct, isPost);
            return;
        }
        boolean single = false;
        if (voucherIds.length == 1) {
            single = true;
        }
        StringBuffer strVoucherids = new StringBuffer();
        for (int i = 0; i < voucherIds.length; ++i) {
            if (i > 0) {
                strVoucherids.append(",");
            }
            strVoucherids.append("'").append(voucherIds[i]).append("'");
        }
        int coef = isDeduct ? -1 : 1;
        String actionId = null;
        String insertId = null;
        String fieldEx = STRING;
        String eMarkEx = STRING;
        String rMarkEx = STRING;
        if (6 == this.getSystemTypeValue()) {
            VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
            if (cache != null && (actionId = cache.getCacheId()).length() > 44) {
                actionId = actionId.substring(actionId.length() - 44);
            }
            insertId = BOSUuid.create((String)"ABCD1234").toString();
            fieldEx = "FEntryID, FAssistID, FActionID, FInsertID, ";
            eMarkEx = "ve.FID, null, ?, ?, ";
            rMarkEx = "ve.FID, r.FID, ?, ?, ";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(this.getVoucherLogTable()).append("(" + fieldEx + "fisassist,fvoucherid,fcreatetime,faction,fbaltype,").append(this.getOrgSelector()).append("fcompanyid,fperiodid,faccountid,fcurrencyid,");
        sql.append(" fdebitfor,fdebitlocal,fdebitrpt,fstandarddebitqty,fcreditfor,fcreditlocal,fcreditrpt,fstandardcreditqty,");
        sql.append(" fmonthpnlfor,fmonthpnllocal,fmonthpnlrpt,FMONTHPNLQTY,FSTANDARDMONTHPNLQTY,fisupdating,fvecount) ");
        sql.append(" select " + eMarkEx + "0, v.fid,getdate(),");
        if (single) {
            sql.append("?,?,");
        } else {
            sql.append(action).append(",").append(isPost ? 5 : 1).append(",");
        }
        sql.append(this.getOrgSelector("v")).append("v.fcompanyid,v.fperiodid,ve.faccountid,ve.fcurrencyid,");
        sql.append(coef).append("*ve.fentrydc*ve.foriginalamount,");
        sql.append(coef).append("*ve.fentrydc*ve.flocalamount,");
        sql.append(coef).append("*ve.fentrydc*ve.freportingamount,");
        sql.append(coef).append("*ve.fentrydc*isNull(ve.fstandardquantity,0),");
        sql.append(coef).append("*(1-ve.fentrydc)*ve.foriginalamount,");
        sql.append(coef).append("*(1-ve.fentrydc)*ve.flocalamount,");
        sql.append(coef).append("*(1-ve.fentrydc)*ve.freportingamount,");
        sql.append(coef).append("*(1-ve.fentrydc)*isNull(ve.fstandardquantity,0),");
        sql.append(" case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.foriginalamount*").append(coef).append(" else 0 end,");
        sql.append(" case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.flocalamount*").append(coef).append(" else 0 end,");
        sql.append(" case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.freportingamount*").append(coef).append(" else 0 end, ");
        sql.append(" case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*isNull(ve.FQUANTITY,0)*").append(coef).append(" else 0 end, ");
        sql.append(" case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*isNull(ve.FSTANDARDQUANTITY,0)*").append(coef).append(" else 0 end, ");
        sql.append(" 0 ,");
        sql.append(coef);
        sql.append(" from ").append(this.getVoucherTable()).append(" v ");
        sql.append(" inner join ").append(this.getVoucherEntryTable()).append(" ve on ve.fbillid = v.fid ");
        sql.append(" inner join t_bd_accountview av on av.fid = ve.faccountid ");
        sql.append(" inner join t_bd_accounttype acctType on av.faccounttypeid = acctType.fid ");
        if (single) {
            sql.append(" where v.fid = ? ");
            if (fieldEx.length() > 0) {
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{actionId, insertId, action, isPost ? 5 : 1, voucherIds[0]});
            } else {
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{action, isPost ? 5 : 1, voucherIds[0]});
            }
        } else {
            sql.append(" where v.fid in (").append(strVoucherids).append(")");
            if (fieldEx.length() > 0) {
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{actionId, insertId});
            } else {
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        sql = new StringBuffer();
        sql.append(" insert into ").append(this.getVoucherLogTable()).append(" (" + fieldEx + "fisassist,fvoucherid,fcreatetime,faction,fbaltype,").append(this.getOrgSelector()).append("fcompanyid,fperiodid,faccountid,fcurrencyid,FASSISTGRPID,FMEASUREUNITID,");
        sql.append(" fdebitfor,fdebitlocal,fdebitrpt,FDEBITQTY,fstandarddebitqty,fcreditfor,fcreditlocal,fcreditrpt,FCREDITQTY,fstandardcreditqty,");
        sql.append(" fmonthpnlfor,fmonthpnllocal,fmonthpnlrpt,FMONTHPNLQTY,FSTANDARDMONTHPNLQTY,fisupdating,fvecount) ");
        sql.append(" select " + rMarkEx + "1, v.fid,getdate(),");
        if (single) {
            sql.append("?,?,");
        } else {
            sql.append(action).append(",").append(isPost ? 5 : 1).append(",");
        }
        sql.append(this.getOrgSelector("v")).append("v.fcompanyid,v.fperiodid,ve.faccountid,ve.fcurrencyid,");
        sql.append("r.fassgrpid,r.fmeasureunitid,");
        sql.append(coef).append("*ve.fentrydc*r.foriginalamount,");
        sql.append(coef).append("*ve.fentrydc*r.flocalamount,");
        sql.append(coef).append("*ve.fentrydc*r.freportingamount,");
        sql.append(coef).append("*ve.fentrydc*isNull(r.fquantity,0),");
        sql.append(coef).append("*ve.fentrydc*isNull(r.fstandardquantity,0),");
        sql.append(coef).append("*(1-ve.fentrydc)*r.foriginalamount,");
        sql.append(coef).append("*(1-ve.fentrydc)*r.flocalamount,");
        sql.append(coef).append("*(1-ve.fentrydc)*r.freportingamount,");
        sql.append(coef).append("*(1-ve.fentrydc)*isNull(r.fquantity,0),");
        sql.append(coef).append("*(1-ve.fentrydc)*isNull(r.fstandardquantity,0),");
        sql.append("case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.foriginalamount*").append(coef).append(" else 0 end,");
        sql.append("case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.flocalamount*").append(coef).append(" else 0 end,");
        sql.append("case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.freportingamount*").append(coef).append(" else 0 end, ");
        sql.append("case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*isNull(r.FQUANTITY,0)*").append(coef).append(" else 0 end, ");
        sql.append("case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*isNull(r.FSTANDARDQUANTITY,0)*").append(coef).append(" else 0 end, ");
        sql.append(" 0 ,");
        sql.append(coef);
        sql.append(" from ").append(this.getVoucherTable()).append(" v ");
        sql.append(" inner join ").append(this.getVoucherEntryTable()).append(" ve on ve.fbillid = v.fid ");
        sql.append(" inner join t_bd_accountview av on av.fid = ve.faccountid ");
        sql.append(" inner join t_bd_accounttype acctType on av.faccounttypeid = acctType.fid ");
        sql.append(" inner join ").append(this.getVoucherAssRecTable()).append(" r on r.fbillid = v.fid and r.fentryid = ve.fid and r.fassgrpid is not null ");
        if (single) {
            sql.append(" where v.fid = ? ");
            if (fieldEx.length() > 0) {
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{actionId, insertId, action, isPost ? 5 : 1, voucherIds[0]});
            } else {
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{action, isPost ? 5 : 1, voucherIds[0]});
            }
        } else {
            sql.append(" where v.fid in (").append(strVoucherids).append(")");
            if (fieldEx.length() > 0) {
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{actionId, insertId});
            } else {
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
    }

    protected void _groupSumInsertVoucherLog(Context ctx, String[] voucherIds, int action, boolean isDeduct, boolean isPost) throws BOSException {
        boolean single = false;
        if (voucherIds.length == 1) {
            single = true;
        }
        StringBuffer strVoucherids = new StringBuffer();
        for (int i = 0; i < voucherIds.length; ++i) {
            if (i > 0) {
                strVoucherids.append(",");
            }
            strVoucherids.append("'").append(voucherIds[i]).append("'");
        }
        int coef = isDeduct ? -1 : 1;
        String vid = voucherIds[0];
        if (voucherIds.length > 1) {
            vid = "GroupSumNoID";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(this.getVoucherLogTable()).append("(fisassist,fvoucherid,fcreatetime,faction,fbaltype,").append(this.getOrgSelector()).append("fcompanyid,fperiodid,faccountid,fcurrencyid,");
        sql.append(" fdebitfor,fdebitlocal,fdebitrpt,fstandarddebitqty,fcreditfor,fcreditlocal,fcreditrpt,fstandardcreditqty,");
        sql.append(" fmonthpnlfor,fmonthpnllocal,fmonthpnlrpt,FMONTHPNLQTY,FSTANDARDMONTHPNLQTY,fisupdating,fvecount) ");
        sql.append(" select 0, '" + vid + "',getdate(),");
        if (single) {
            sql.append("?,?,");
        } else {
            sql.append(action).append(",").append(isPost ? 5 : 1).append(",");
        }
        sql.append(this.getOrgSelector("v")).append("v.fcompanyid,v.fperiodid,ve.faccountid,ve.fcurrencyid,");
        sql.append("sum(").append(coef).append("*ve.fentrydc*ve.foriginalamount),");
        sql.append("sum(").append(coef).append("*ve.fentrydc*ve.flocalamount),");
        sql.append("sum(").append(coef).append("*ve.fentrydc*ve.freportingamount),");
        sql.append("sum(").append(coef).append("*ve.fentrydc*isNull(ve.fstandardquantity,0)),");
        sql.append("sum(").append(coef).append("*(1-ve.fentrydc)*ve.foriginalamount),");
        sql.append("sum(").append(coef).append("*(1-ve.fentrydc)*ve.flocalamount),");
        sql.append("sum(").append(coef).append("*(1-ve.fentrydc)*ve.freportingamount),");
        sql.append("sum(").append(coef).append("*(1-ve.fentrydc)*isNull(ve.fstandardquantity,0)),");
        sql.append("sum(").append(" case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.foriginalamount*").append(coef).append(" else 0 end),");
        sql.append("sum(").append(" case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.flocalamount*").append(coef).append(" else 0 end),");
        sql.append("sum(").append(" case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.freportingamount*").append(coef).append(" else 0 end), ");
        sql.append("sum(").append(" case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*isNull(ve.FQUANTITY,0)*").append(coef).append(" else 0 end), ");
        sql.append("sum(").append(" case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*isNull(ve.FSTANDARDQUANTITY,0)*").append(coef).append(" else 0 end), ");
        sql.append(" 0 ,");
        sql.append(coef);
        sql.append(" from ").append(this.getVoucherTable()).append(" v ");
        sql.append(" inner join ").append(this.getVoucherEntryTable()).append(" ve on ve.fbillid = v.fid ");
        sql.append(" inner join t_bd_accountview av on av.fid = ve.faccountid ");
        sql.append(" inner join t_bd_accounttype acctType on av.faccounttypeid = acctType.fid ");
        if (single) {
            sql.append(" where v.fid = ? ");
        } else {
            sql.append(" where v.fid in (").append(strVoucherids).append(")");
        }
        sql.append(" group by " + this.getOrgSelector("v") + "v.fcompanyid,v.fperiodid,ve.faccountid,ve.fcurrencyid ");
        if (single) {
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{action, isPost ? 5 : 1, voucherIds[0]});
        } else {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        sql = new StringBuffer();
        sql.append(" insert into ").append(this.getVoucherLogTable()).append(" (fisassist,fvoucherid,fcreatetime,faction,fbaltype,").append(this.getOrgSelector()).append("fcompanyid,fperiodid,faccountid,fcurrencyid,FASSISTGRPID,FMEASUREUNITID,");
        sql.append(" fdebitfor,fdebitlocal,fdebitrpt,FDEBITQTY,fstandarddebitqty,fcreditfor,fcreditlocal,fcreditrpt,FCREDITQTY,fstandardcreditqty,");
        sql.append(" fmonthpnlfor,fmonthpnllocal,fmonthpnlrpt,FMONTHPNLQTY,FSTANDARDMONTHPNLQTY,fisupdating,fvecount) ");
        sql.append(" select 1, '" + vid + "',getdate(),");
        if (single) {
            sql.append("?,?,");
        } else {
            sql.append(action).append(",").append(isPost ? 5 : 1).append(",");
        }
        sql.append(this.getOrgSelector("v")).append("v.fcompanyid,v.fperiodid,ve.faccountid,ve.fcurrencyid,").append("r.fassgrpid,r.fmeasureunitid,");
        sql.append("sum(").append(coef).append("*ve.fentrydc*r.foriginalamount),");
        sql.append("sum(").append(coef).append("*ve.fentrydc*r.flocalamount),");
        sql.append("sum(").append(coef).append("*ve.fentrydc*r.freportingamount),");
        sql.append("sum(").append(coef).append("*ve.fentrydc*isNull(r.fquantity,0)),");
        sql.append("sum(").append(coef).append("*ve.fentrydc*isNull(r.fstandardquantity,0)),");
        sql.append("sum(").append(coef).append("*(1-ve.fentrydc)*r.foriginalamount),");
        sql.append("sum(").append(coef).append("*(1-ve.fentrydc)*r.flocalamount),");
        sql.append("sum(").append(coef).append("*(1-ve.fentrydc)*r.freportingamount),");
        sql.append("sum(").append(coef).append("*(1-ve.fentrydc)*isNull(r.fquantity,0)),");
        sql.append("sum(").append(coef).append("*(1-ve.fentrydc)*isNull(r.fstandardquantity,0)),");
        sql.append("sum(").append("case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.foriginalamount*").append(coef).append(" else 0 end),");
        sql.append("sum(").append("case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.flocalamount*").append(coef).append(" else 0 end),");
        sql.append("sum(").append("case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.freportingamount*").append(coef).append(" else 0 end), ");
        sql.append("sum(").append("case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*isNull(r.FQUANTITY,0)*").append(coef).append(" else 0 end), ");
        sql.append("sum(").append("case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*isNull(r.FSTANDARDQUANTITY,0)*").append(coef).append(" else 0 end), ");
        sql.append(" 0 ,");
        sql.append(coef);
        sql.append(" from ").append(this.getVoucherTable()).append(" v ");
        sql.append(" inner join ").append(this.getVoucherEntryTable()).append(" ve on ve.fbillid = v.fid ");
        sql.append(" inner join t_bd_accountview av on av.fid = ve.faccountid ");
        sql.append(" inner join t_bd_accounttype acctType on av.faccounttypeid = acctType.fid ");
        sql.append(" inner join ").append(this.getVoucherAssRecTable()).append(" r on r.fbillid = v.fid and r.fentryid = ve.fid and r.fassgrpid is not null ");
        if (single) {
            sql.append(" where v.fid = ? ");
        } else {
            sql.append(" where v.fid in (").append(strVoucherids).append(")");
        }
        sql.append(" group by " + this.getOrgSelector("v") + "v.fcompanyid,v.fperiodid,ve.faccountid,ve.fcurrencyid,r.fassgrpid,r.fmeasureunitid ");
        if (single) {
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{action, isPost ? 5 : 1, voucherIds[0]});
        } else {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private boolean existOracleVoucherLogTrigger(Context ctx) throws BOSException {
        if (!SQLUtil.isOracle(ctx)) {
            return false;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"/*dialect*/select count(1) ct from user_triggers where status='ENABLED' and trigger_name in ('VOUCHERLOGTRIGGER','VOUCHERENLOGTRIGGER','VOUCHERASSLOGTRIGGER')");
        try {
            if (rs.next()) {
                int count = rs.getInt("ct");
                if (count == 0) {
                    return false;
                }
                if (count == 3) {
                    return true;
                }
                rs = DbUtil.executeQuery((Context)ctx, (String)"/*dialect*/select 1 from user_triggers where trigger_name ='VOUCHERLOGTRIGGER' and table_name='T_GL_VOUCHER'");
                if (rs.next()) {
                    DbUtil.execute((Context)ctx, (String)"/*dialect*/drop trigger voucherlogtrigger");
                }
                if ((rs = DbUtil.executeQuery((Context)ctx, (String)"/*dialect*/select 1 from user_triggers where trigger_name ='VOUCHERENLOGTRIGGER' and table_name='T_GL_VOUCHERENTRY'")).next()) {
                    DbUtil.execute((Context)ctx, (String)"/*dialect*/drop trigger voucherenlogtrigger");
                }
                if ((rs = DbUtil.executeQuery((Context)ctx, (String)"/*dialect*/select 1 from user_triggers where trigger_name ='VOUCHERASSLOGTRIGGER' and table_name='T_GL_VOUCHERASSISTRECORD'")).next()) {
                    DbUtil.execute((Context)ctx, (String)"/*dialect*/drop trigger voucherasslogtrigger");
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isOracle(Context ctx) {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            int dbType = KSqlUtil.getDbType((Connection)conn);
            boolean bl = 2 == dbType || 8 == dbType || 7 == dbType;
            return bl;
        }
        catch (SQLException e) {
            logger.error((Object)"Query database type error!", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return false;
    }

    private void disableVoucherLog(Context ctx, String[] companyIds, String calculateId) throws BOSException {
        String sql = "update " + this.getVoucherLogTable() + " set fisupdating = 2 where fisupdating = 1";
        if (companyIds != null && companyIds.length > 0) {
            sql = companyIds.length == 1 ? sql + " and " + this.getOrgColumnName() + " = ?" : sql + " and " + this.getOrgColumnName() + " in " + SQLUtil.buildMarkSQL(companyIds.length);
        }
        if (6 == this.getSystemTypeValue()) {
            sql = sql + " and FCalculateID = ?";
        }
        if (6 == this.getSystemTypeValue()) {
            if (companyIds != null && companyIds.length > 0) {
                Object[] ps = new String[companyIds.length + 1];
                for (int i = 0; i < companyIds.length; ++i) {
                    ps[i] = companyIds[i];
                }
                ps[ps.length - 1] = calculateId;
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])ps);
            } else {
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{calculateId});
            }
        } else if (companyIds != null && companyIds.length > 0) {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])companyIds);
        } else {
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _doUpdateVoucherBalance(Context ctx, String[] companyIds) throws BOSException {
        HashMap params;
        String tempTable;
        String cpIdsStr;
        block28: {
            cpIdsStr = this.listId2StrId(companyIds);
            tempTable = null;
            params = new HashMap();
            params.put("G001", null);
            params.put("G010", null);
            params = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(params);
            tempTable = this.createVoucherBalanceTempTable(ctx);
            if (tempTable != null) break block28;
            try {
                if (tempTable == null) return;
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                return;
            }
            catch (Exception e) {
                logger.error((Object)"Update voucher balance release temptable error!", (Throwable)e);
            }
            return;
        }
        String calculateId = BOSUuid.create((String)"ABCD1234").toString();
        StringBuffer sql = new StringBuffer();
        boolean isMSSQLSERVER = SQLUtil.isMSSQLSERVER(ctx);
        if (isMSSQLSERVER) {
            sql.append("/*dialect*/ ");
        }
        sql.append("update " + this.getVoucherLogTable());
        if (isMSSQLSERVER) {
            sql.append(" with(readpast)");
        }
        sql.append(" set fisupdating = 1");
        if (6 == this.getSystemTypeValue()) {
            sql.append(", FCalculateID = ?");
        }
        sql.append(" where fisupdating = 0 ");
        if (companyIds.length > 0) {
            if (companyIds.length == 1) {
                sql.append(" and ").append(this.getOrgColumnName()).append(" = ?");
            } else {
                sql.append(" and ").append(this.getOrgColumnName()).append(" in ").append(SQLUtil.buildMarkSQL(companyIds.length));
            }
        }
        if (6 == this.getSystemTypeValue()) {
            if (companyIds.length > 0) {
                if (companyIds.length == 1) {
                    params.put("orgUnitId", companyIds[0]);
                }
                Object[] ps = new String[1 + companyIds.length];
                ps[0] = calculateId;
                for (int i = 0; i < companyIds.length; ++i) {
                    ps[i + 1] = companyIds[i];
                }
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])ps);
            } else {
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{calculateId});
            }
        } else if (companyIds.length > 0) {
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])companyIds);
        } else {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        this.insertVoucherBalance(ctx, tempTable, params, cpIdsStr);
        if (6 == this.getSystemTypeValue() && GLBalanceFacadeControllerBean.isArchiveVoucherLog(ctx)) {
            this.archiveCalData(ctx, tempTable, calculateId);
        }
        this.updateBalanceRecord(ctx, tempTable, params, 1);
        this.updateBalanceRecord(ctx, tempTable, params, 2);
        boolean isAsstQty = Boolean.valueOf(params.get("G010").toString());
        if (isAsstQty) {
            this.updateBalanceRecord(ctx, tempTable, params, 3);
        }
        this.disableVoucherLog(ctx, companyIds, calculateId);
        try {
            if (tempTable == null) return;
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            return;
        }
        catch (Exception e) {
            logger.error((Object)"Update voucher balance release temptable error!", (Throwable)e);
            return;
        }
        catch (BOSException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (tempTable == null) throw throwable;
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                    throw throwable;
                }
                catch (Exception e3) {
                    logger.error((Object)"Update voucher balance release temptable error!", (Throwable)e3);
                }
                throw throwable;
            }
        }
    }

    protected void archiveCalData(Context ctx, String tempTable, String calculateId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_GL_VoucherLogSumData ( \n");
        sql.append("    FCalculateID, FCreateTime, \n");
        sql.append("    FORGUNITID, FPERIOD, FACCOUNTID, FCURRENCYID, FBALTYPE, FASSISTGRPID, FMEASUREUNITID, \n");
        sql.append("    FDEBITFOR, FCREDITFOR, FDEBITLOCAL, FCREDITLOCAL, FDEBITRPT, FCREDITRPT, \n");
        sql.append("    FDEBITQTY, FCREDITQTY, FMONTHPNLFOR, FMONTHPNLLOCAL, FMONTHPNLRPT, FMONTHPNLQTY, \n");
        sql.append("    FBALANCETYPE, FLOGCOUNT \n");
        sql.append(") \n");
        sql.append("select /*+ LEADING(t) */ ?, getdate(), \n");
        sql.append("    ORGUNITID, PERIOD, ACCOUNTID, CURRENCYID, BALTYPE, ASSISTGRPID, MEASUREUNITID, \n");
        sql.append("    DEBITFOR, CREDITFOR, DEBITLOCAL, CREDITLOCAL, DEBITRPT, CREDITRPT, \n");
        sql.append("    DEBITQTY, CREDITQTY, MONTHPNLFOR, MONTHPNLLOCAL, MONTHPNLRPT, MONTHPNLQTY, \n");
        sql.append("    BALANCETYPE, FLOGCOUNT \n");
        sql.append("from " + tempTable + " t \n");
        sql.append("join T_GL_ObjectLabel ol \n");
        sql.append("    on ol.FObjectID = t.OrgUnitID and ol.FLabel = 'VoucherLogBackup' and ol.FIsEnable = 1 \n");
        sql.append("where t.CURRENCYID not in ('11111111-1111-1111-1111-111111111111DEB58FDC', '22222222-2222-2222-2222-222222222222DEB58FDC') \n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{calculateId});
    }

    protected void insertVoucherBalance(Context ctx, String tmpTableName, Map sysParams, String companyIds) throws BOSException {
        this.insertCurrencyBalance(ctx, tmpTableName, sysParams, companyIds, 1);
        this.insertCurrencyBalance(ctx, tmpTableName, sysParams, companyIds, 2);
        boolean isAsstQty = Boolean.valueOf(sysParams.get("G010").toString());
        if (isAsstQty) {
            this.insertCurrencyBalance(ctx, tmpTableName, sysParams, companyIds, 3);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select ").append(this.getOrgSelectorV("t")).append("t.orgunitid, t.period, t.accountid, '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' currencyid, t.baltype, t.assistgrpid, t.measureunitid, ");
        sql.append(" sum(t.DebitLocal) DebitFor, sum(t.CreditLocal) CreditFor, ");
        sql.append(" sum(t.DebitLocal) DebitLocal, sum(t.CreditLocal) CreditLocal, ");
        sql.append(" sum(t.DebitLocal) DebitRpt, sum(t.CreditLocal) CreditRpt, ");
        sql.append(" sum(t.DebitQty) DebitQty, sum(t.CreditQty) CreditQty, ");
        sql.append(" sum(t.MonthPnLLocal) MonthPnLFor, sum(t.MonthPnLLocal) MonthPnLLocal, sum(t.MonthPnLLocal) MonthPnLRpt, sum(t.MonthPnlQty) MonthPnlQty, ");
        sql.append(" t.balanceType, sum(t.FLogCount) FLogCount ");
        sql.append(" from ").append(tmpTableName).append(" t ");
        sql.append(" group by ").append(this.getOrgSelectorV("t")).append("t.orgunitid, t.period, t.accountid, t.baltype, t.balanceType, t.assistgrpid, t.measureunitid");
        sql.append(" union all ");
        sql.append(" select ").append(this.getOrgSelectorV("t")).append("t.orgunitid, t.period, t.accountid, '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' currencyid, t.baltype, t.assistgrpid, t.measureunitid, ");
        sql.append(" sum(t.DebitRpt) DebitFor, sum(t.CreditRpt) CreditFor,");
        sql.append(" sum(t.DebitRpt) DebitLocal, sum(t.CreditRpt) CreditLocal, ");
        sql.append(" sum(t.DebitRpt) DebitRpt, sum(t.CreditRpt) CreditRpt, ");
        sql.append(" sum(t.DebitQty) DebitQty, sum(t.CreditQty) CreditQty, ");
        sql.append(" sum(t.MonthPnLRpt) MonthPnLFor, sum(t.MonthPnLRpt) MonthPnLLocal, sum(t.MonthPnLRpt) MonthPnLRpt, sum(t.MonthPnlQty) MonthPnlQty, ");
        sql.append(" t.balanceType, sum(t.FLogCount) FLogCount ");
        sql.append(" from ").append(tmpTableName).append(" t ");
        sql.append(" group by ").append(this.getOrgSelectorV("t")).append("t.orgunitid, t.period, t.accountid, t.baltype, t.balanceType, t.assistgrpid, t.measureunitid");
        DbUtil.execute((Context)ctx, (String)("insert into " + tmpTableName + sql.toString()));
    }

    private void insertCurrencyBalance(Context ctx, String tmpTableName, Map params, String companyIds, int balType) throws BOSException {
        String orgUnitId = (String)params.get("orgUnitId");
        String accountId = balType == 1 ? "pacct.fid" : "log.FAccountID";
        String assistgrpId = balType == 1 ? "to_char(null)" : "log.fassistgrpid";
        String unitId = balType == 3 ? "case when log.FMeasureUnitId is null then '00000000-0000-0000-0000-0000000000005B825C57' else log.FMeasureUnitId end FMeasureUnitId" : "to_char(null)";
        int isAssist = balType == 1 ? 0 : 1;
        String group = this.getOrgSelector("log") + "log.fcompanyid, p.FNumber, " + accountId + ", log.fcurrencyid, log.fbaltype ";
        if (balType == 2 || balType == 3) {
            group = group + ", log.fassistgrpid ";
        }
        if (balType == 3) {
            group = group + ", log.fmeasureunitid ";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select ").append(this.getOrgSelector("log")).append("log.fcompanyid, p.FNumber, ").append(accountId).append(", log.fcurrencyid, log.fbaltype, ");
        sql.append(assistgrpId).append(", ").append(unitId).append(", ");
        sql.append(" sum(log.FDebitFor) FDebitForV, sum(log.FCreditFor) FCreditForV, ");
        sql.append(" sum(log.FDebitLocal) FDebitLocalV, sum(log.FCreditLocal) FCreditLocalV, ");
        sql.append(" sum(log.FDebitRpt) FDebitRptV, sum(log.FCreditRpt) FCreditRptV, ");
        if (balType == 1) {
            sql.append(" sum(case when pacct.fid = acct.fid or pacct.FIsQty = 1 then log.FStandardDebitQty else 0 end) FDebitQtyV, ");
            sql.append(" sum(case when pacct.fid = acct.fid or pacct.FIsQty = 1 then log.FStandardCreditQty else 0 end) FCreditQtyV, ");
        } else if (balType == 2) {
            sql.append(" sum(log.FStandardDebitQty) FDebitQtyV, sum(log.FStandardCreditQty) FCreditQtyV, ");
        } else {
            sql.append(" sum(log.FDebitQty) FDebitQtyV, sum(log.FCreditQty) FCreditQtyV, ");
        }
        sql.append(" sum(log.FMonthPnLFor) FMonthPnLForV,sum(log.FMonthPnLLocal) FMonthPnLLocalV,sum(log.FMonthPnLRpt) FMonthPnLRptV, ");
        if (balType == 1) {
            sql.append(" sum(case when pacct.fid = acct.fid or pacct.FIsQty = 1 then isNull(log.FSTANDARDMONTHPNLQTY,0) else 0 end) FSTANDARDMONTHPNLQTYV, ");
        } else if (balType == 2) {
            sql.append(" sum(isNull(log.FSTANDARDMONTHPNLQTY,0)) FSTANDARDMONTHPNLQTYV, ");
        } else {
            sql.append(" sum(isNull(log.FMONTHPNLQTY,0)) FMONTHPNLQTYV, ");
        }
        sql.append(balType).append(", sum(log.FVeCount) FLogCount ");
        sql.append(" from " + this.getVoucherLogTable() + " log ");
        sql.append(" join T_BD_Period p on p.FID = log.fperiodid ");
        if (balType == 1 || balType == 3) {
            if (this.isPca()) {
                sql.append(" inner join t_BD_AccountView acct on log.FAccountID = acct.FID  ");
            } else {
                sql.append(" inner join t_BD_AccountView acct on log.FAccountID = acct.FID and acct.fcompanyid = log.fcompanyid ");
            }
            if (balType == 3) {
                sql.append(" inner join t_bd_asstaccount ac on ac.fid = acct.fcaa ");
            }
        }
        if (balType == 1) {
            sql.append(" inner join t_BD_AccountView pacct on pacct.Fcompanyid = acct.Fcompanyid and pacct.faccounttableid = acct.faccounttableid ");
            sql.append(" and (charindex(pacct.FLongNumber||'!', acct.FLongNumber) = 1 or pacct.fid = acct.fid) ");
        }
        sql.append(" where log.fisassist = ").append(isAssist).append(" and log.fisupdating = 1 ");
        if (balType == 3) {
            sql.append(" and acct.fisqty=1 and ac.fisqty = 1 ");
        }
        if (orgUnitId != null) {
            sql.append(" and log.").append(this.getOrgColumnName()).append(" = ? ");
            sql.append(" group by ").append(group);
            DbUtil.execute((Context)ctx, (String)("insert into " + tmpTableName + sql.toString()), (Object[])new String[]{orgUnitId});
        } else {
            if (companyIds.length() > 0) {
                sql.append(" and log.").append(this.getOrgColumnName()).append(" in (").append(companyIds).append(")");
            }
            sql.append(" group by ").append(group);
            DbUtil.execute((Context)ctx, (String)("insert into " + tmpTableName + sql.toString()));
        }
    }

    private void doInsertEmptyBalanceRecord(Context ctx, String tempTableName, Map sysParams, int balanceType, int baltype, String currencyId) throws BOSException {
        String balanceTableName = this.getBalanceTable(balanceType, baltype, currencyId);
        if (balanceTableName == null) {
            return;
        }
        boolean isForCurrency = !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId);
        boolean useRpt = Boolean.valueOf(sysParams.get("G001").toString());
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(balanceTableName);
        sql.append("(").append(this.getOrgSelector()).append("forgunitid, ");
        if (isForCurrency) {
            sql.append("fcurrencyid, ");
        }
        sql.append("faccountid, fperiod");
        if (balanceType == 2) {
            sql.append(", fassistgrpid ");
        } else if (balanceType == 3) {
            sql.append(", fassistgrpid ");
            sql.append(", fmeasureunitid ");
        }
        sql.append(") ");
        sql.append(" select distinct ").append(this.getOrgSelectorV("t")).append("t.orgunitid, ");
        if (isForCurrency) {
            sql.append("t.currencyid, ");
        }
        sql.append("t.accountid, t.period");
        if (balanceType == 2) {
            sql.append(", t.assistgrpid ");
        } else if (balanceType == 3) {
            sql.append(", t.assistgrpid ");
            sql.append(", t.measureunitid ");
        }
        sql.append(" from ").append(tempTableName).append(" t ");
        sql.append(" where t.balancetype = ").append(balanceType);
        sql.append(" and t.baltype = ").append(baltype);
        if (isForCurrency) {
            sql.append(" and t.currencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
            sql.append(" and t.currencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
        } else {
            sql.append(" and t.currencyid = '").append(currencyId).append("' \n");
        }
        sql.append(" and not exists ( ");
        sql.append(" select 1 from ").append(balanceTableName).append(" b ");
        sql.append(" where b.").append(this.getOrgColumnNameB()).append(" = t.").append(this.getOrgColumnNameBV()).append(" ");
        sql.append(" and b.fperiod = t.period ");
        if (isForCurrency) {
            sql.append(" and b.fcurrencyid = t.currencyid ");
        }
        sql.append(" and b.faccountid = t.accountid ");
        if (balanceType == 2) {
            sql.append(" and b.fassistgrpid = t.assistgrpid ");
        } else if (balanceType == 3) {
            sql.append(" and b.fassistgrpid = t.assistgrpid ");
            sql.append(" and b.fmeasureunitid = t.measureunitid ");
        }
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void updateBalanceRecord(Context ctx, String tempTableName, Map sysParams, int balanceType) throws BOSException {
        if (SQLUtil.isOracle(ctx)) {
            this.doOracleUpdateBalance(ctx, tempTableName, sysParams, balanceType);
        } else {
            this.doOtherUpdateBalance(ctx, tempTableName, sysParams, balanceType);
        }
    }

    private void doOtherUpdateBalance(Context ctx, String tempTableName, Map sysParams, int balanceType) throws BOSException {
        this.doInsertEmptyBalanceRecord(ctx, tempTableName, sysParams, balanceType, 1, null);
        this.doInsertEmptyBalanceRecord(ctx, tempTableName, sysParams, balanceType, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doInsertEmptyBalanceRecord(ctx, tempTableName, sysParams, balanceType, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
        this.doInsertEmptyBalanceRecord(ctx, tempTableName, sysParams, balanceType, 5, null);
        this.doInsertEmptyBalanceRecord(ctx, tempTableName, sysParams, balanceType, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doInsertEmptyBalanceRecord(ctx, tempTableName, sysParams, balanceType, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
        this.doUpdateBalanceRecord(ctx, tempTableName, sysParams, balanceType, 1, null);
        this.doUpdateBalanceRecord(ctx, tempTableName, sysParams, balanceType, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doUpdateBalanceRecord(ctx, tempTableName, sysParams, balanceType, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
        this.doUpdateBalanceRecord(ctx, tempTableName, sysParams, balanceType, 5, null);
        this.doUpdateBalanceRecord(ctx, tempTableName, sysParams, balanceType, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doUpdateBalanceRecord(ctx, tempTableName, sysParams, balanceType, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
    }

    private void doOracleUpdateBalance(Context ctx, String tempTableName, Map sysParams, int balanceType) throws BOSException {
        this.doOracleUpdateBalance(ctx, tempTableName, sysParams, balanceType, 1, null);
        this.doOracleUpdateBalance(ctx, tempTableName, sysParams, balanceType, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doOracleUpdateBalance(ctx, tempTableName, sysParams, balanceType, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
        this.doOracleUpdateBalance(ctx, tempTableName, sysParams, balanceType, 5, null);
        this.doOracleUpdateBalance(ctx, tempTableName, sysParams, balanceType, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doOracleUpdateBalance(ctx, tempTableName, sysParams, balanceType, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
    }

    private void doOracleUpdateBalance(Context ctx, String tempTableName, Map sysParams, int balanceType, int baltype, String currencyId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/MERGE INTO ").append(this.getBalanceTable(balanceType, baltype, currencyId)).append(" tin ");
        sql.append(" USING (select * from ").append(tempTableName).append(" where balancetype=").append(balanceType);
        if (StringUtils.isEmpty((String)currencyId)) {
            sql.append(" and currencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' ");
            sql.append(" and currencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' ");
        } else {
            sql.append(" and currencyid='").append(currencyId).append("' ");
        }
        sql.append(" and baltype = ").append(baltype);
        sql.append(" and ").append(this.getOrgColumnNameBV()).append(" is not null and accountid is not null ");
        if (balanceType != 1) {
            sql.append("  and assistgrpid is not null ");
        }
        sql.append(") tout ");
        sql.append(" ON (tin.").append(this.getOrgColumnNameB()).append(" = tout.").append(this.getOrgColumnNameBV()).append(" and tin.fperiod = tout.period and tin.faccountid = tout.accountid ");
        if (StringUtils.isEmpty((String)currencyId)) {
            sql.append(" and tin.fcurrencyid = tout.currencyid ");
        }
        if (balanceType == 2) {
            sql.append(" and tin.fassistgrpid = tout.assistgrpid ");
        } else if (balanceType == 3) {
            sql.append(" and tin.fassistgrpid = tout.assistgrpid ");
            sql.append(" and tin.fmeasureunitid = tout.measureunitid ");
        }
        sql.append(")");
        sql.append(" WHEN MATCHED THEN UPDATE ");
        sql.append(" SET ");
        if (StringUtils.isEmpty((String)currencyId)) {
            sql.append(" tin.fdebitfor  = tin.fdebitfor + tout.debitfor, ");
            sql.append(" tin.fcreditfor = tin.fcreditfor + tout.creditfor, ");
            sql.append(" tin.fyeardebitfor  = tin.fyeardebitfor + tout.debitfor, ");
            sql.append(" tin.fyearcreditfor = tin.fyearcreditfor + tout.creditfor, ");
            sql.append(" tin.fmonthpnlfor   = tin.fmonthpnlfor + tout.monthpnlfor, ");
            sql.append(" tin.fyearpnlfor    = tin.fyearpnlfor + tout.monthpnlfor, ");
            sql.append(" tin.fendbalancefor = tin.fendbalancefor + tout.debitfor - tout.creditfor, ");
        }
        if (StringUtils.isEmpty((String)currencyId) || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sql.append(" tin.fdebitlocal    = tin.fdebitlocal + tout.debitlocal, ");
            sql.append(" tin.fcreditlocal   = tin.fcreditlocal + tout.creditlocal, ");
            sql.append(" tin.fyeardebitlocal    = tin.fyeardebitlocal + tout.debitlocal, ");
            sql.append(" tin.fyearcreditlocal   = tin.fyearcreditlocal + tout.creditlocal, ");
            sql.append(" tin.fmonthpnllocal = tin.fmonthpnllocal + tout.monthpnllocal, ");
            sql.append(" tin.fyearpnllocal  = tin.fyearpnllocal + tout.monthpnllocal, ");
            sql.append(" tin.fendbalancelocal   = tin.fendbalancelocal + tout.debitlocal - tout.creditlocal, ");
        }
        if (StringUtils.isEmpty((String)currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append(" tin.fdebitrpt  = tin.fdebitrpt + tout.debitrpt, ");
            sql.append(" tin.fcreditrpt = tin.fcreditrpt + tout.creditrpt, ");
            sql.append(" tin.fyeardebitrpt  = tin.fyeardebitrpt + tout.debitrpt, ");
            sql.append(" tin.fyearcreditrpt = tin.fyearcreditrpt + tout.creditrpt, ");
            sql.append(" tin.fmonthpnlrpt   = tin.fmonthpnlrpt + tout.monthpnlrpt, ");
            sql.append(" tin.fyearpnlrpt    = tin.fyearpnlrpt + tout.monthpnlrpt, ");
            sql.append(" tin.fendbalancerpt = tin.fendbalancerpt + tout.debitrpt - tout.creditrpt, ");
        }
        sql.append(" tin.fdebitqty  = nvl(tin.fdebitqty,0) + nvl(tout.debitqty,0), ");
        sql.append(" tin.fcreditqty = nvl(tin.fcreditqty,0) + nvl(tout.creditqty,0), ");
        sql.append(" tin.fyeardebitqty  = nvl(tin.fyeardebitqty,0) + nvl(tout.debitqty,0), ");
        sql.append(" tin.fyearcreditqty = nvl(tin.fyearcreditqty,0) + nvl(tout.creditqty,0), ");
        sql.append(" tin.fendqty    = nvl(tin.fendqty,0) + nvl(tout.debitqty,0) - nvl(tout.creditqty,0), ");
        sql.append(" tin.fmonthpnlqty = nvl(tin.fmonthpnlqty,0) + nvl(tout.monthpnlqty,0), ");
        sql.append(" tin.fyearpnlqty  = nvl(tin.fyearpnlqty,0) + nvl(tout.monthpnlqty,0), ");
        sql.append(" tin.fdetailcount   = nvl(tin.fdetailcount,0) + nvl(tout.flogcount,0) ");
        sql.append(" WHEN NOT MATCHED THEN INSERT ");
        sql.append(" (").append(this.getOrgSelector()).append("forgunitid, fperiod, faccountid, ");
        if (StringUtils.isEmpty((String)currencyId)) {
            sql.append(" fcurrencyid, ");
        }
        if (balanceType == 2) {
            sql.append(" fassistgrpid, ");
        } else if (balanceType == 3) {
            sql.append(" fassistgrpid, ");
            sql.append(" fmeasureunitid, ");
        }
        if (StringUtils.isEmpty((String)currencyId)) {
            sql.append(" fbeginbalancefor, fdebitfor, fcreditfor, fyeardebitfor, fyearcreditfor, fmonthpnlfor, fyearpnlfor, fendbalancefor, ");
        }
        if (StringUtils.isEmpty((String)currencyId) || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sql.append(" fbeginbalancelocal, fdebitlocal, fcreditlocal, fyeardebitlocal, fyearcreditlocal, fmonthpnllocal, fyearpnllocal, fendbalancelocal, ");
        }
        if (StringUtils.isEmpty((String)currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append(" fbeginbalancerpt, fdebitrpt, fcreditrpt, fyeardebitrpt, fyearcreditrpt, fmonthpnlrpt, fyearpnlrpt, fendbalancerpt, ");
        }
        sql.append(" fbeginqty, fdebitqty, fcreditqty, fyeardebitqty, fyearcreditqty, fmonthpnlqty, fyearpnlqty, fendqty, fdetailcount) ");
        sql.append(" VALUES ");
        sql.append(" (").append(this.getOrgSelectorV("tout")).append("tout.orgunitid, tout.period, tout.accountid, ");
        if (StringUtils.isEmpty((String)currencyId)) {
            sql.append(" tout.currencyid, ");
        }
        if (balanceType == 2) {
            sql.append(" tout.assistgrpid, ");
        } else if (balanceType == 3) {
            sql.append(" tout.assistgrpid, ");
            sql.append(" tout.measureunitid, ");
        }
        if (StringUtils.isEmpty((String)currencyId)) {
            sql.append(" 0, nvl(tout.debitfor,0), nvl(tout.creditfor,0), nvl(tout.debitfor,0), nvl(tout.creditfor,0), nvl(tout.monthpnlfor,0), nvl(tout.monthpnlfor,0), nvl(tout.debitfor,0) - nvl(tout.creditfor,0), ");
        }
        if (StringUtils.isEmpty((String)currencyId) || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sql.append(" 0, nvl(tout.debitlocal,0), nvl(tout.creditlocal,0), nvl(tout.debitlocal,0), nvl(tout.creditlocal,0), nvl(tout.monthpnllocal,0), nvl(tout.monthpnllocal,0), nvl(tout.debitlocal,0) - nvl(tout.creditlocal,0), ");
        }
        if (StringUtils.isEmpty((String)currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append(" 0, nvl(tout.debitrpt,0), nvl(tout.creditrpt,0), nvl(tout.debitrpt,0), nvl(tout.creditrpt,0), nvl(tout.monthpnlrpt,0), nvl(tout.monthpnlrpt,0), nvl(tout.debitrpt,0) - nvl(tout.creditrpt,0), ");
        }
        sql.append(" 0, nvl(tout.debitqty,0),nvl(tout.creditqty,0),nvl(tout.debitqty,0),nvl(tout.creditqty,0),nvl(tout.monthpnlqty,0), nvl(tout.monthpnlqty,0), nvl(tout.debitqty,0) - nvl(tout.creditqty,0),nvl(tout.flogcount,0)) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void doUpdateBalanceRecord(Context ctx, String tempTableName, Map sysParams, int balanceType, int baltype, String currencyId) throws BOSException {
        String balanceTableName = this.getBalanceTable(balanceType, baltype, currencyId);
        if (balanceTableName == null) {
            return;
        }
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update /*+ NOT_GEN_EXISTS*/ ").append(balanceTableName).append(" set (");
        if (isForCurrency) {
            sql.append(" FDebitFor, FYearDebitFor, FCreditFor, FYearCreditFor, FEndBalanceFor,");
            sql.append(" FMonthPnLFor, FYearPnLFor, ");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append(" FDebitLocal, FYearDebitLocal, FCreditLocal, FYearCreditLocal, FEndBalanceLocal,");
            sql.append(" FMonthPnLLocal, FYearPnLLocal, ");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" FDebitRpt, FYearDebitRpt, FCreditRpt, FYearCreditRpt, FEndBalanceRpt,");
            sql.append(" FMonthPnLRpt, FYearPnLRpt, ");
        }
        sql.append(" FDebitQty, FYearDebitQty, FCreditQty, FYearCreditQty, FEndQty,");
        sql.append(" FMonthPnLQty, FYearPnLQty ");
        sql.append(" ,FDetailCount ");
        sql.append(") = (");
        sql.append(" select ");
        if (isForCurrency) {
            sql.append(" FDebitFor + t.DebitFor, FYearDebitFor + t.DebitFor,FCreditFor + t.CreditFor, FYearCreditFor + t.CreditFor,FEndBalanceFor + t.DebitFor - t.CreditFor,");
            sql.append(" FMonthPnLFor + t.MonthPnLFor, FYearPnLFor + t.MonthPnLFor, ");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append(" FDebitLocal + t.DebitLocal,  FYearDebitLocal + t.DebitLocal, FCreditLocal + t.CreditLocal, FYearCreditLocal + t.CreditLocal, FEndBalanceLocal + t.DebitLocal - t.CreditLocal, ");
            sql.append(" FMonthPnLLocal + t.MonthPnLLocal, FYearPnLLocal + t.MonthPnLLocal, ");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" FDebitRpt + t.DebitRpt, FYearDebitRpt + t.DebitRpt, FCreditRpt + t.CreditRpt, FYearCreditRpt + t.CreditRpt, FEndBalanceRpt + t.DebitRpt - t.CreditRpt, ");
            sql.append(" FMonthPnLRpt + t.MonthPnLRpt, FYearPnLRpt + t.MonthPnLRpt,");
        }
        sql.append(" FDebitQty + t.DebitQty, FYearDebitQty + t.DebitQty, FCreditQty + t.CreditQty, FYearCreditQty + t.CreditQty, FEndQty + t.DebitQty - t.CreditQty, ");
        sql.append(" isNull(FMonthPnLQty,0) + t.MonthPnLQty, isNull(FYearPnLQty,0) + t.MonthPnLQty ");
        sql.append(" ,case when isnull(FDetailCount,0)+ t.FLogCount < 0 then 0 else isnull(FDetailCount,0)+ t.FLogCount end ");
        sql.append(" from ").append(tempTableName).append(" t ");
        sql.append(" where t.").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" ");
        sql.append(" and t.period = fperiod ");
        sql.append(" and t.accountid = faccountid ");
        if (isForCurrency) {
            sql.append(" and t.currencyid = fcurrencyid ");
        } else {
            sql.append(" and t.currencyid = '").append(currencyId).append("'");
        }
        if (balanceType == 2) {
            sql.append(" and t.assistgrpid = fassistgrpid ");
        } else if (balanceType == 3) {
            sql.append(" and t.assistgrpid = fassistgrpid ");
            sql.append(" and t.measureunitid = fmeasureunitid ");
        }
        sql.append(" and t.balancetype = ").append(balanceType);
        sql.append(" and t.baltype = ").append(baltype);
        sql.append(" ) ");
        sql.append(" where exists ");
        sql.append(" (select 1 from ").append(tempTableName).append(" t ");
        sql.append(" where t.").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" ");
        sql.append(" and t.period = fperiod ");
        sql.append(" and t.accountid = faccountid ");
        if (isForCurrency) {
            sql.append(" and t.currencyid = fcurrencyid ");
        } else {
            sql.append(" and t.currencyid = '").append(currencyId).append("'");
        }
        if (balanceType == 2) {
            sql.append(" and t.assistgrpid = fassistgrpid ");
        } else if (balanceType == 3) {
            sql.append(" and t.assistgrpid = fassistgrpid ");
            sql.append(" and t.measureunitid = fmeasureunitid ");
        }
        sql.append(" and t.balancetype = ").append(balanceType);
        sql.append(" and t.baltype = ").append(baltype).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected String createVoucherBalanceTempTable(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append(" ORGUNITID         VARCHAR(44),");
        sql.append(" PERIOD            INT,");
        sql.append(" ACCOUNTID         VARCHAR(44),");
        sql.append(" CURRENCYID        VARCHAR(44),");
        sql.append(" BALTYPE           INT,");
        sql.append(" ASSISTGRPID       VARCHAR(44),");
        sql.append(" MEASUREUNITID     VARCHAR(44),");
        sql.append(" DEBITFOR          NUMERIC(19,4) DEFAULT 0,");
        sql.append(" CREDITFOR         NUMERIC(19,4) DEFAULT 0,");
        sql.append(" DEBITLOCAL        NUMERIC(19,4) DEFAULT 0,");
        sql.append(" CREDITLOCAL       NUMERIC(19,4) DEFAULT 0,");
        sql.append(" DEBITRPT          NUMERIC(19,4) DEFAULT 0,");
        sql.append(" CREDITRPT         NUMERIC(19,4) DEFAULT 0,");
        sql.append(" DEBITQTY          NUMERIC(28,10) DEFAULT 0,");
        sql.append(" CREDITQTY         NUMERIC(28,10) DEFAULT 0,");
        sql.append(" MONTHPNLFOR       NUMERIC(19,4) DEFAULT 0,");
        sql.append(" MONTHPNLLOCAL     NUMERIC(19,4) DEFAULT 0,");
        sql.append(" MONTHPNLRPT       NUMERIC(19,4) DEFAULT 0,");
        sql.append(" MONTHPNLQTY       NUMERIC(28,10) DEFAULT 0,");
        sql.append(" BALANCETYPE           INT");
        sql.append(" ,FLOGCOUNT INT");
        String tmpTableName = TempTablePool.getInstance((Context)ctx).createTempTable("create table t_tmp (" + sql.toString() + ")");
        TempTablePool.getInstance((Context)ctx).createIndex(tmpTableName, "accountid, orgunitid, period, currencyid, baltype, assistgrpid, measureunitid", false, false);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select top 1 * from " + tmpTableName));
        if (rs.next()) {
            logger.error((Object)"Get temp table error, exist data in the new temp table!");
            return null;
        }
        return tmpTableName;
    }

    @Override
    protected void _initAccountBalance(Context ctx, String companyID, String startPeriodID, String firstPeriodID, String acctIDs) throws BOSException {
        PeriodInfo startPeriod = null;
        PeriodInfo firstPeriod = null;
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            startPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(startPeriodID), selector);
            firstPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(firstPeriodID), selector);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        this.doInitAccountBalance(ctx, companyID, startPeriod, firstPeriod, acctIDs, 1, null);
        this.doInitAccountBalance(ctx, companyID, startPeriod, firstPeriod, acctIDs, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doInitAccountBalance(ctx, companyID, startPeriod, firstPeriod, acctIDs, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
        this.doInitAccountBalance(ctx, companyID, startPeriod, firstPeriod, acctIDs, 5, null);
        this.doInitAccountBalance(ctx, companyID, startPeriod, firstPeriod, acctIDs, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doInitAccountBalance(ctx, companyID, startPeriod, firstPeriod, acctIDs, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
    }

    protected void doInitAccountBalance(Context ctx, String companyID, PeriodInfo startPeriod, PeriodInfo firstPeriod, String acctIDs, int baltype, String currencyId) throws BOSException {
        String T_AccountBalance = this.getBalanceTable(1, baltype, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(T_AccountBalance).append("( \r\n");
        insertSql.append(this.getOrgSelector()).append("forgunitid, fperiod, faccountid \r\n");
        if (isForCurrency) {
            insertSql.append(", fcurrencyid \r\n");
        }
        insertSql.append(") \r\n");
        insertSql.append("select ").append(this.getOrgSelector("ab")).append("ab.forgunitid, ? fperiod, ab.faccountid \r\n");
        if (isForCurrency) {
            insertSql.append(", ab.fcurrencyid \r\n");
        }
        insertSql.append("from ").append(this.getInitAccountBalanceTable()).append(" ab \r\n");
        insertSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
        if (isForCurrency) {
            insertSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
            insertSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
        } else {
            insertSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
        }
        if (acctIDs != null && !STRING.equals(acctIDs)) {
            insertSql.append(" and ab.FAccountid in (").append(acctIDs).append(") \r\n");
        }
        insertSql.append("and not exists ( \r\n");
        insertSql.append("select 1 from ").append(T_AccountBalance).append(" ab1 \r\n");
        insertSql.append("where ab1.").append(this.getOrgColumnNameB()).append("=ab.").append(this.getOrgColumnNameB()).append(" and ab1.fperiod = ? and ab1.faccountid=ab.faccountid \r\n");
        if (isForCurrency) {
            insertSql.append("and ab1.fcurrencyid=ab.fcurrencyid \r\n");
        }
        insertSql.append(") \r\n");
        if (logger.isDebugEnabled()) {
            GLBalanceFacadeControllerBean.logSql("initAccountBalance_insertstart1", insertSql.toString(), new Object[]{startPeriod.getNumber(), companyID, startPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{startPeriod.getNumber(), companyID, startPeriod.getNumber()});
        boolean isFirstPeriod = startPeriod.getId().toString().equals(firstPeriod.getId().toString());
        if (isFirstPeriod) {
            StringBuffer updateSql = new StringBuffer().append("update ").append(T_AccountBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fendbalancefor, \r\n");
                updateSql.append("fyeardebitfor, fyearcreditfor, fyearpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fendbalancelocal, \r\n");
                updateSql.append("fyeardebitlocal, fyearcreditlocal, fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fendbalancerpt, \r\n");
                updateSql.append("fyeardebitrpt, fyearcreditrpt, fyearpnlrpt, \r\n");
            }
            updateSql.append("fyeardebitqty, fyearcreditqty, \r\n").append("fbeginqty, fendqty, fyearpnlqty) = ( select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc, beginbalancefor * fdc + fdebitfor - fcreditfor, \r\n");
                updateSql.append("fyeardebitfor + yeardebitfor, fyearcreditfor + yearcreditfor, fmonthpnlfor+0, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc, beginbalancelocal * fdc + fdebitlocal - fcreditlocal, \r\n");
                updateSql.append("fyeardebitlocal + yeardebitlocal, fyearcreditlocal + yearcreditlocal, fmonthpnllocal+0, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc, beginbalancerpt * fdc + fdebitrpt - fcreditrpt, \r\n");
                updateSql.append("fyeardebitrpt + yeardebitrpt, fyearcreditrpt + yearcreditrpt, fmonthpnlrpt+0, \r\n");
            }
            updateSql.append("fyeardebitqty + yeardebitqty, fyearcreditqty + yearcreditqty, \r\n").append("beginqty * fdc, beginqty * fdc + fdebitqty - fcreditqty, isNull(fmonthpnlqty,0) \r\n").append("from ( \r\n").append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ").append("ab.faccountid accountid, ab.fcurrencyid currencyid, ").append("ab.fbeginbalancefor beginbalancefor, ab.fbeginbalancelocal beginbalancelocal, ab.fbeginbalancerpt beginbalancerpt, ab.fbeginqty beginqty, av.fdc \r\n").append(",ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt\r\n").append(",ab.fyearpnlfor yearpnlfor, ab.fyearpnllocal yearpnllocal, ab.fyearpnlrpt yearpnlrpt \r\n").append(",ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty \r\n").append("from ").append(this.getInitAccountBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid and ab.forgunitid=av.fcompanyid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n");
            updateSql.append("and accountid = faccountid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            if (logger.isDebugEnabled()) {
                GLBalanceFacadeControllerBean.logSql("initAccountBalance_updatestart1", updateSql.toString(), new Object[]{companyID, companyID, startPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{companyID, companyID, startPeriod.getNumber()});
        } else {
            StringBuffer updateSql = new StringBuffer().append("update ").append(T_AccountBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fyeardebitfor, fyearcreditfor, fendbalancefor, \r\n");
                updateSql.append("fyearpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, \r\n");
                updateSql.append("fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, \r\n");
                updateSql.append("fyearpnlrpt, \r\n");
            }
            updateSql.append("fbeginqty, fyeardebitqty, fyearcreditqty, fendqty, fyearpnlqty) = (select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc, yeardebitfor + fdebitfor, yearcreditfor + fcreditfor, beginbalancefor * fdc + fdebitfor - fcreditfor, \r\n");
                updateSql.append("yearpnlfor * fdc + fmonthpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc, yeardebitlocal + fdebitlocal, yearcreditlocal + fcreditlocal, beginbalancelocal * fdc + fdebitlocal - fcreditlocal, \r\n");
                updateSql.append("yearpnllocal * fdc + fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc, yeardebitrpt + fdebitrpt, yearcreditrpt + fcreditrpt, beginbalancerpt * fdc + fdebitrpt - fcreditrpt, \r\n");
                updateSql.append("yearpnlrpt * fdc + fmonthpnlrpt, \r\n");
            }
            updateSql.append("beginqty * fdc, yeardebitqty + fdebitqty, yearcreditqty + fcreditqty, beginqty * fdc + fdebitqty - fcreditqty, \r\n");
            updateSql.append("isNull(yearpnlqty,0) * fdc + isNull(fmonthpnlqty,0) \r\n").append("from ( \r\n").append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ab.faccountid accountid, ab.fcurrencyid currencyid, \r\n").append("ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fbeginbalancefor beginbalancefor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fbeginbalancelocal beginbalancelocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fbeginbalancerpt beginbalancerpt, \r\n").append("ab.fyearpnlfor yearpnlfor, ab.fyearpnllocal yearpnllocal, ab.fyearpnlrpt yearpnlrpt, \r\n").append("ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty, ab.fbeginqty beginqty, ab.fyearpnlqty yearpnlqty, \r\n").append("av.fdc \r\n").append("from ").append(this.getInitAccountBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid and ab.forgunitid=av.fcompanyid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n").append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n").append("and accountid = faccountid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            if (logger.isDebugEnabled()) {
                GLBalanceFacadeControllerBean.logSql("initAccountBalance_updatestart2", updateSql.toString(), new Object[]{companyID, companyID, startPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{companyID, companyID, startPeriod.getNumber()});
            insertSql = new StringBuffer();
            insertSql.append("insert into ").append(T_AccountBalance).append("( \r\n");
            insertSql.append(this.getOrgSelector()).append("forgunitid, fperiod, faccountid \r\n");
            if (isForCurrency) {
                insertSql.append(", fcurrencyid \r\n");
            }
            insertSql.append(") \r\n");
            insertSql.append("select ").append(this.getOrgSelector("ab")).append("ab.forgunitid, ? fperiod, ab.faccountid \r\n");
            if (isForCurrency) {
                insertSql.append(", ab.fcurrencyid \r\n");
            }
            insertSql.append("from ").append(this.getInitAccountBalanceTable()).append(" ab \r\n");
            insertSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            if (isForCurrency) {
                insertSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                insertSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                insertSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                insertSql.append(" and ab.FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            insertSql.append("and not exists ( \r\n");
            insertSql.append("select 1 from ").append(T_AccountBalance).append(" ab1 \r\n");
            insertSql.append("where ab1.").append(this.getOrgColumnNameB()).append("=ab.").append(this.getOrgColumnNameB()).append(" and ab1.fperiod = ? and ab1.faccountid=ab.faccountid \r\n");
            if (isForCurrency) {
                insertSql.append("and ab1.fcurrencyid=ab.fcurrencyid \r\n");
            }
            insertSql.append(") \r\n");
            if (logger.isDebugEnabled()) {
                GLBalanceFacadeControllerBean.logSql("initAccountBalance_insertfirst1", insertSql.toString(), new Object[]{firstPeriod.getNumber(), companyID, firstPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{firstPeriod.getNumber(), companyID, firstPeriod.getNumber()});
            updateSql = new StringBuffer();
            updateSql.append("update ").append(T_AccountBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fdebitfor, fcreditfor, fyeardebitfor, fyearcreditfor, fendbalancefor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fdebitlocal, fcreditlocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fdebitrpt, fcreditrpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, \r\n");
            }
            updateSql.append("fbeginqty, fdebitqty, fcreditqty, fyeardebitqty, fyearcreditqty, fendqty\r\n ").append(") = (select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc - yeardebitfor + yearcreditfor, yeardebitfor, yearcreditfor, yeardebitfor, yearcreditfor, beginbalancefor * fdc, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc - yeardebitlocal + yearcreditlocal, yeardebitlocal, yearcreditlocal, yeardebitlocal, yearcreditlocal, beginbalancelocal * fdc, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc - yeardebitrpt + yearcreditrpt, yeardebitrpt, yearcreditrpt, yeardebitrpt, yearcreditrpt, beginbalancerpt * fdc, \r\n");
            }
            updateSql.append("beginqty * fdc - yeardebitqty + yearcreditqty, yeardebitqty, yearcreditqty, yeardebitqty, yearcreditqty, beginqty * fdc \r\n");
            updateSql.append("from ( \r\n");
            updateSql.append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ab.faccountid accountid, ab.fcurrencyid currencyid, \r\n").append("ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fbeginbalancefor beginbalancefor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fbeginbalancelocal beginbalancelocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fbeginbalancerpt beginbalancerpt, \r\n").append("ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty, ab.fbeginqty beginqty,   \r\n").append("av.fdc \r\n").append("from ").append(this.getInitAccountBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid and ab.forgunitid=av.fcompanyid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n").append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n").append("and accountid = faccountid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            if (logger.isDebugEnabled()) {
                GLBalanceFacadeControllerBean.logSql("initAccountBalance_updatefirst", updateSql.toString(), new Object[]{companyID, companyID, firstPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{companyID, companyID, firstPeriod.getNumber()});
        }
    }

    @Override
    protected void _initAssistBalance(Context ctx, String companyID, IObjectCollection accounts, String startPeriodID, String firstPeriodID, String acctIDs) throws BOSException {
        PeriodInfo startPeriod = null;
        PeriodInfo firstPeriod = null;
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            startPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(startPeriodID), selector);
            firstPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(firstPeriodID), selector);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        this.doInitAssistBalance(ctx, companyID, accounts, startPeriod, firstPeriod, acctIDs, 1, null);
        this.doInitAssistBalance(ctx, companyID, accounts, startPeriod, firstPeriod, acctIDs, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doInitAssistBalance(ctx, companyID, accounts, startPeriod, firstPeriod, acctIDs, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
        this.doInitAssistBalance(ctx, companyID, accounts, startPeriod, firstPeriod, acctIDs, 5, null);
        this.doInitAssistBalance(ctx, companyID, accounts, startPeriod, firstPeriod, acctIDs, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doInitAssistBalance(ctx, companyID, accounts, startPeriod, firstPeriod, acctIDs, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
    }

    protected void doInitAssistBalance(Context ctx, String companyID, IObjectCollection accounts, PeriodInfo startPeriod, PeriodInfo firstPeriod, String acctIDs, int baltype, String currencyId) throws BOSException {
        String T_AssistBalance = this.getBalanceTable(2, baltype, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer ids = new StringBuffer();
        if (accounts != null) {
            AccountViewCollection col = (AccountViewCollection)accounts;
            int size = accounts.size();
            for (int i = 0; i < size; ++i) {
                ids.append("'").append(col.get(i).getId().toString()).append("',");
            }
            ids.deleteCharAt(ids.length() - 1);
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(T_AssistBalance).append("( \r\n");
        insertSql.append(this.getOrgSelector()).append("forgunitid, fperiod, faccountid, fassistgrpid \r\n");
        if (isForCurrency) {
            insertSql.append(", fcurrencyid \r\n");
        }
        insertSql.append(") \r\n");
        insertSql.append("select ").append(this.getOrgSelector("ab")).append("ab.forgunitid, ? fperiod, ab.faccountid, ab.fassistgrpid \r\n");
        if (isForCurrency) {
            insertSql.append(", ab.fcurrencyid \r\n");
        }
        insertSql.append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n");
        insertSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? ");
        if (isForCurrency) {
            insertSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
            insertSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
        } else {
            insertSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
        }
        if (accounts != null) {
            insertSql.append("and ab.faccountid in (").append(ids).append(") ");
        }
        if (acctIDs != null && !STRING.equals(acctIDs)) {
            insertSql.append(" and ab.FAccountid in (").append(acctIDs).append(")       \r\n");
        }
        insertSql.append("and not exists ( \r\n");
        insertSql.append("select 1 from ").append(T_AssistBalance).append(" ab1 \r\n");
        insertSql.append("where ab1.").append(this.getOrgColumnNameB()).append("=ab.").append(this.getOrgColumnNameB()).append(" and ab1.fperiod = ? and ab1.faccountid=ab.faccountid and ab1.fassistgrpid=ab.fassistgrpid \r\n");
        if (isForCurrency) {
            insertSql.append("and ab1.fcurrencyid=ab.fcurrencyid \r\n");
        }
        insertSql.append(") \r\n");
        if (logger.isDebugEnabled()) {
            GLBalanceFacadeControllerBean.logSql("initAssistBalance_insertstart1", insertSql.toString(), new Object[]{startPeriod.getNumber(), companyID, startPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{startPeriod.getNumber(), companyID, startPeriod.getNumber()});
        boolean isFirstPeriod = startPeriod.getId().toString().equals(firstPeriod.getId().toString());
        if (isFirstPeriod) {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update ").append(T_AssistBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fendbalancefor, \r\n");
                updateSql.append("fyeardebitfor, fyearcreditfor, \r\n");
                updateSql.append("fyearpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fendbalancelocal, \r\n");
                updateSql.append("fyeardebitlocal, fyearcreditlocal, \r\n");
                updateSql.append("fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fendbalancerpt, \r\n");
                updateSql.append("fyeardebitrpt, fyearcreditrpt, \r\n");
                updateSql.append("fyearpnlrpt, \r\n");
            }
            updateSql.append("fyeardebitqty, fyearcreditqty, \r\n");
            updateSql.append("fbeginqty, fendqty, fyearpnlqty) = ( select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc, beginbalancefor * fdc + fdebitfor - fcreditfor, \r\n");
                updateSql.append("fyeardebitfor + yeardebitfor, fyearcreditfor + yearcreditfor, \r\n");
                updateSql.append("fmonthpnlfor+0, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc, beginbalancelocal * fdc + fdebitlocal - fcreditlocal, \r\n");
                updateSql.append("fyeardebitlocal + yeardebitlocal, fyearcreditlocal + yearcreditlocal, \r\n");
                updateSql.append("fmonthpnllocal+0, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc, beginbalancerpt * fdc + fdebitrpt - fcreditrpt, \r\n");
                updateSql.append("fyeardebitrpt + yeardebitrpt, fyearcreditrpt + yearcreditrpt, \r\n");
                updateSql.append("fmonthpnlrpt+0, \r\n");
            }
            updateSql.append("fyeardebitqty + yeardebitqty, fyearcreditqty + yearcreditqty, \r\n").append("standardbeginqty * fdc, standardbeginqty * fdc + fdebitqty - fcreditqty, \r\n").append("isNull(fmonthpnlqty,0) \r\n").append("from ( \r\n").append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ab.faccountid accountid, ab.fassistgrpid assistgrpid, ab.fcurrencyid currencyid, ab.fbeginbalancefor beginbalancefor, ab.fbeginbalancelocal beginbalancelocal, ab.fbeginbalancerpt beginbalancerpt, ab.fstandardbeginqty standardbeginqty, av.fdc \r\n").append(",ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt\r\n").append(",ab.fyearpnlfor yearpnlfor, ab.fyearpnllocal yearpnllocal, ab.fyearpnlrpt yearpnlrpt \r\n").append(",ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty \r\n").append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid and ab.forgunitid=av.fcompanyid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n");
            updateSql.append("and accountid = faccountid \r\n");
            updateSql.append("and assistgrpid = fassistgrpid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? ");
            if (accounts != null) {
                updateSql.append("and faccountid in (").append(ids).append(") ");
            }
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            updateSql.append("\r\n");
            if (logger.isDebugEnabled()) {
                GLBalanceFacadeControllerBean.logSql("initAssistBalance_updatestart1", updateSql.toString(), new Object[]{companyID, companyID, startPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{companyID, companyID, startPeriod.getNumber()});
        } else {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update ").append(T_AssistBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fyeardebitfor, fyearcreditfor, fendbalancefor, \r\n");
                updateSql.append("fyearpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, \r\n");
                updateSql.append("fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, \r\n");
                updateSql.append("fyearpnlrpt, \r\n");
            }
            updateSql.append("fbeginqty, fyeardebitqty, fyearcreditqty, fendqty, fyearpnlqty) = ( select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc, yeardebitfor + fdebitfor, yearcreditfor + fcreditfor, beginbalancefor * fdc + fdebitfor - fcreditfor, \r\n");
                updateSql.append("yearpnlfor * fdc + fmonthpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc, yeardebitlocal + fdebitlocal, yearcreditlocal + fcreditlocal, beginbalancelocal * fdc + fdebitlocal - fcreditlocal, \r\n");
                updateSql.append("yearpnllocal * fdc + fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc, yeardebitrpt + fdebitrpt, yearcreditrpt + fcreditrpt, beginbalancerpt * fdc + fdebitrpt - fcreditrpt, \r\n");
                updateSql.append("yearpnlrpt * fdc + fmonthpnlrpt, \r\n");
            }
            updateSql.append("standardbeginqty * fdc, standardyeardebitqty + fdebitqty, standardyearcreditqty + fcreditqty, standardbeginqty * fdc + fdebitqty - fcreditqty, \r\n").append("isNull(standardyearpnlqty,0) * fdc + isNull(fmonthpnlqty,0) \r\n").append("from ( \r\n").append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ab.faccountid accountid, ab.fassistgrpid assistgrpid, ab.fcurrencyid currencyid, \r\n").append("ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fbeginbalancefor beginbalancefor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fbeginbalancelocal beginbalancelocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fbeginbalancerpt beginbalancerpt, \r\n").append("isNull(ab.fyearpnlfor,0) yearpnlfor, isNull(ab.fyearpnllocal,0) yearpnllocal, isNull(ab.fyearpnlrpt,0) yearpnlrpt, \r\n").append("ab.fstandardyeardebitqty standardyeardebitqty, ab.fstandardyearcreditqty standardyearcreditqty, ab.fstandardbeginqty standardbeginqty, ab.fstandardyearpnlqty standardyearpnlqty, \r\n").append("av.fdc \r\n").append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid and ab.forgunitid=av.fcompanyid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n").append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n").append("and accountid = faccountid \r\n").append("and assistgrpid = fassistgrpid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? ");
            if (accounts != null) {
                updateSql.append("and faccountid in (").append(ids).append(") ");
            }
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            updateSql.append(" \r\n");
            if (logger.isDebugEnabled()) {
                GLBalanceFacadeControllerBean.logSql("initAssistBalance_updatestart2", updateSql.toString(), new Object[]{companyID, companyID, startPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{companyID, companyID, startPeriod.getNumber()});
            insertSql = new StringBuffer();
            insertSql.append("insert into ").append(T_AssistBalance).append("( \r\n");
            insertSql.append(this.getOrgSelector()).append("forgunitid, fperiod, faccountid, fassistgrpid \r\n");
            if (isForCurrency) {
                insertSql.append(", fcurrencyid \r\n");
            }
            insertSql.append(") \r\n");
            insertSql.append("select ").append(this.getOrgSelector("ab")).append("ab.forgunitid, ? fperiod, ab.faccountid, ab.fassistgrpid \r\n");
            if (isForCurrency) {
                insertSql.append(", ab.fcurrencyid \r\n");
            }
            insertSql.append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n");
            insertSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? ");
            if (isForCurrency) {
                insertSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                insertSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                insertSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            if (accounts != null) {
                insertSql.append("and ab.faccountid in (").append(ids).append(") ");
            }
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                insertSql.append(" and ab.FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            insertSql.append("and not exists ( \r\n");
            insertSql.append("select 1 from ").append(T_AssistBalance).append(" ab1 \r\n");
            insertSql.append("where ab1.").append(this.getOrgColumnNameB()).append("=ab.").append(this.getOrgColumnNameB()).append(" and ab1.fperiod = ? and ab1.faccountid=ab.faccountid and ab1.fassistgrpid=ab.fassistgrpid \r\n");
            if (isForCurrency) {
                insertSql.append("and ab1.fcurrencyid=ab.fcurrencyid \r\n");
            }
            insertSql.append(") \r\n");
            if (logger.isDebugEnabled()) {
                GLBalanceFacadeControllerBean.logSql("initAssistBalance_insertfirst1", insertSql.toString(), new Object[]{firstPeriod.getNumber(), companyID, firstPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{firstPeriod.getNumber(), companyID, firstPeriod.getNumber()});
            updateSql = new StringBuffer();
            updateSql.append("update ").append(T_AssistBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fdebitfor, fcreditfor, fyeardebitfor, fyearcreditfor, fendbalancefor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fdebitlocal, fcreditlocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fdebitrpt, fcreditrpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, \r\n");
            }
            updateSql.append("fbeginqty, fdebitqty, fcreditqty, fyeardebitqty, fyearcreditqty, fendqty\r\n").append(") = ( select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc - yeardebitfor + yearcreditfor, yeardebitfor, yearcreditfor, yeardebitfor, yearcreditfor, beginbalancefor * fdc, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc - yeardebitlocal + yearcreditlocal, yeardebitlocal, yearcreditlocal, yeardebitlocal, yearcreditlocal, beginbalancelocal * fdc, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc - yeardebitrpt + yearcreditrpt, yeardebitrpt, yearcreditrpt, yeardebitrpt, yearcreditrpt, beginbalancerpt * fdc, \r\n");
            }
            updateSql.append("standardbeginqty * fdc - standardyeardebitqty + standardyearcreditqty, standardyeardebitqty, standardyearcreditqty, standardyeardebitqty, standardyearcreditqty, standardbeginqty * fdc \r\n").append("from ( \r\n").append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ab.faccountid accountid, ab.fassistgrpid assistgrpid, ab.fcurrencyid currencyid, \r\n").append("ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fbeginbalancefor beginbalancefor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fbeginbalancelocal beginbalancelocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fbeginbalancerpt beginbalancerpt, \r\n").append("ab.fstandardyeardebitqty standardyeardebitqty, ab.fstandardyearcreditqty standardyearcreditqty, ab.fstandardbeginqty standardbeginqty, \r\n").append("av.fdc \r\n").append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid and ab.forgunitid=av.fcompanyid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n").append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n").append("and accountid = faccountid \r\n").append("and assistgrpid = fassistgrpid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? ");
            if (accounts != null) {
                updateSql.append("and faccountid in (").append(ids).append(") ");
            }
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            updateSql.append("\r\n");
            if (logger.isDebugEnabled()) {
                GLBalanceFacadeControllerBean.logSql("initAssistBalance_updatefirst", updateSql.toString(), new Object[]{companyID, companyID, firstPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{companyID, companyID, firstPeriod.getNumber()});
        }
    }

    @Override
    protected void _initAssistMeasureBalance(Context ctx, String companyID, IObjectCollection accounts, String startPeriodID, String firstPeriodID, String acctIDs) throws BOSException {
        PeriodInfo startPeriod = null;
        PeriodInfo firstPeriod = null;
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            startPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(startPeriodID), selector);
            firstPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(firstPeriodID), selector);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        this.doInitAssistMeasureBalance(ctx, companyID, accounts, startPeriod, firstPeriod, acctIDs, 1, null);
        this.doInitAssistMeasureBalance(ctx, companyID, accounts, startPeriod, firstPeriod, acctIDs, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doInitAssistMeasureBalance(ctx, companyID, accounts, startPeriod, firstPeriod, acctIDs, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
        this.doInitAssistMeasureBalance(ctx, companyID, accounts, startPeriod, firstPeriod, acctIDs, 5, null);
        this.doInitAssistMeasureBalance(ctx, companyID, accounts, startPeriod, firstPeriod, acctIDs, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
        this.doInitAssistMeasureBalance(ctx, companyID, accounts, startPeriod, firstPeriod, acctIDs, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
    }

    protected void doInitAssistMeasureBalance(Context ctx, String companyID, IObjectCollection accounts, PeriodInfo startPeriod, PeriodInfo firstPeriod, String acctIDs, int baltype, String currencyId) throws BOSException {
        String T_MeasureBalance = this.getBalanceTable(3, baltype, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer ids = new StringBuffer();
        if (accounts != null) {
            AccountViewCollection col = (AccountViewCollection)accounts;
            int size = accounts.size();
            for (int i = 0; i < size; ++i) {
                ids.append("'").append(col.get(i).getId().toString()).append("',");
            }
            ids.deleteCharAt(ids.length() - 1);
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(T_MeasureBalance).append("( \r\n");
        insertSql.append(this.getOrgSelector()).append("forgunitid, fperiod, faccountid, fassistgrpid, fmeasureunitid \r\n");
        if (isForCurrency) {
            insertSql.append(", fcurrencyid \r\n");
        }
        insertSql.append(") \r\n");
        insertSql.append("select ").append(this.getOrgSelector("ab")).append("ab.forgunitid, ? fperiod, ab.faccountid, ab.fassistgrpid, ab.fmeasureunitid \r\n");
        if (isForCurrency) {
            insertSql.append(", ab.fcurrencyid \r\n");
        }
        insertSql.append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n");
        insertSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? ");
        if (isForCurrency) {
            insertSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
            insertSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
        } else {
            insertSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
        }
        if (accounts != null) {
            insertSql.append("and ab.faccountid in (").append(ids).append(") ");
        }
        if (acctIDs != null && !STRING.equals(acctIDs)) {
            insertSql.append(" and ab.FAccountid in (").append(acctIDs).append(")       \r\n");
        }
        insertSql.append("and ab.fmeasureunitid is not null and not exists ( \r\n");
        insertSql.append("select 1 from ").append(T_MeasureBalance).append(" ab1 \r\n");
        insertSql.append("where ab1.").append(this.getOrgColumnNameB()).append("=ab.").append(this.getOrgColumnNameB()).append(" and ab1.fperiod = ? and ab1.faccountid=ab.faccountid and ab1.fassistgrpid=ab.fassistgrpid and ab1.fmeasureunitid=ab.fmeasureunitid \r\n");
        if (isForCurrency) {
            insertSql.append("and ab1.fcurrencyid=ab.fcurrencyid \r\n");
        }
        insertSql.append(") \r\n");
        if (logger.isDebugEnabled()) {
            GLBalanceFacadeControllerBean.logSql("initMeasureBalance_insertstart1", insertSql.toString(), new Object[]{startPeriod.getNumber(), companyID, startPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{startPeriod.getNumber(), companyID, startPeriod.getNumber()});
        boolean isFirstPeriod = startPeriod.getId().toString().equals(firstPeriod.getId().toString());
        if (isFirstPeriod) {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update ").append(T_MeasureBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fendbalancefor, \r\n");
                updateSql.append("fyeardebitfor, fyearcreditfor, \r\n");
                updateSql.append("fyearpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fendbalancelocal, \r\n");
                updateSql.append("fyeardebitlocal, fyearcreditlocal, \r\n");
                updateSql.append("fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fendbalancerpt, \r\n");
                updateSql.append("fyeardebitrpt, fyearcreditrpt, \r\n");
                updateSql.append("fyearpnlrpt, \r\n");
            }
            updateSql.append("fyeardebitqty, fyearcreditqty, \r\n");
            updateSql.append("fbeginqty, fendqty, fyearpnlqty) = ( select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc, beginbalancefor * fdc + fdebitfor - fcreditfor, \r\n");
                updateSql.append("fyeardebitfor + yeardebitfor, fyearcreditfor + yearcreditfor, \r\n");
                updateSql.append("fmonthpnlfor+0, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc, beginbalancelocal * fdc + fdebitlocal - fcreditlocal, \r\n");
                updateSql.append("fyeardebitlocal + yeardebitlocal, fyearcreditlocal + yearcreditlocal, \r\n");
                updateSql.append("fmonthpnllocal+0, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc, beginbalancerpt * fdc + fdebitrpt - fcreditrpt, \r\n");
                updateSql.append("fyeardebitrpt + yeardebitrpt, fyearcreditrpt + yearcreditrpt, \r\n");
                updateSql.append("fmonthpnlrpt+0, \r\n");
            }
            updateSql.append("fyeardebitqty + yeardebitqty, fyearcreditqty + yearcreditqty, \r\n").append("beginqty * fdc, beginqty * fdc + fdebitqty - fcreditqty, \r\n").append("isNull(fmonthpnlqty,0) \r\n").append("from ( \r\n").append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ab.faccountid accountid, ab.fassistgrpid assistgrpid, ab.fmeasureunitid measureunitid, ab.fcurrencyid currencyid, ab.fbeginbalancefor beginbalancefor, ab.fbeginbalancelocal beginbalancelocal, ab.fbeginbalancerpt beginbalancerpt, ab.fbeginqty beginqty, av.fdc \r\n").append(",ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt\r\n").append(",ab.fyearpnlfor yearpnlfor, ab.fyearpnllocal yearpnllocal, ab.fyearpnlrpt yearpnlrpt \r\n").append(",ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty \r\n").append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid and ab.forgunitid=av.fcompanyid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n");
            updateSql.append("and accountid = faccountid \r\n");
            updateSql.append("and assistgrpid = fassistgrpid \r\n");
            updateSql.append("and measureunitid = fmeasureunitid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? ");
            if (accounts != null) {
                updateSql.append("and faccountid in (").append(ids).append(") ");
            }
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            updateSql.append("\r\n");
            if (logger.isDebugEnabled()) {
                GLBalanceFacadeControllerBean.logSql("initMeasureBalance_updatestart1", updateSql.toString(), new Object[]{companyID, companyID, startPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{companyID, companyID, startPeriod.getNumber()});
        } else {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update ").append(T_MeasureBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fyeardebitfor, fyearcreditfor, fendbalancefor, \r\n");
                updateSql.append("fyearpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, \r\n");
                updateSql.append("fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, \r\n");
                updateSql.append("fyearpnlrpt, \r\n");
            }
            updateSql.append("fbeginqty, fyeardebitqty, fyearcreditqty, fendqty, fyearpnlqty) = ( select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc, yeardebitfor + fdebitfor, yearcreditfor + fcreditfor, beginbalancefor * fdc + fdebitfor - fcreditfor, \r\n");
                updateSql.append("yearpnlfor * fdc + fmonthpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc, yeardebitlocal + fdebitlocal, yearcreditlocal + fcreditlocal, beginbalancelocal * fdc + fdebitlocal - fcreditlocal, \r\n");
                updateSql.append("yearpnllocal * fdc + fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc, yeardebitrpt + fdebitrpt, yearcreditrpt + fcreditrpt, beginbalancerpt * fdc + fdebitrpt - fcreditrpt, \r\n");
                updateSql.append("yearpnlrpt * fdc + fmonthpnlrpt, \r\n");
            }
            updateSql.append("beginqty * fdc, yeardebitqty + fdebitqty, yearcreditqty + fcreditqty, beginqty * fdc + fdebitqty - fcreditqty, \r\n").append("isNull(yearpnlqty,0) * fdc + isNull(fmonthpnlqty,0) \r\n").append("from ( \r\n").append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ab.faccountid accountid, ab.fassistgrpid assistgrpid, ab.fmeasureunitid measureunitid, ab.fcurrencyid currencyid, \r\n").append("ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fbeginbalancefor beginbalancefor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fbeginbalancelocal beginbalancelocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fbeginbalancerpt beginbalancerpt, \r\n").append("isNull(ab.fyearpnlfor,0) yearpnlfor, isNull(ab.fyearpnllocal,0) yearpnllocal, isNull(ab.fyearpnlrpt,0) yearpnlrpt, \r\n").append("ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty, isNull(ab.fbeginqty,0) beginqty, ab.fyearpnlqty yearpnlqty, \r\n").append("av.fdc \r\n").append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid and ab.forgunitid=av.fcompanyid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n").append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n").append("and accountid = faccountid \r\n").append("and assistgrpid = fassistgrpid \r\n").append("and measureunitid = fmeasureunitid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? ");
            if (accounts != null) {
                updateSql.append("and faccountid in (").append(ids).append(") ");
            }
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            updateSql.append("\r\n");
            if (logger.isDebugEnabled()) {
                GLBalanceFacadeControllerBean.logSql("initMeasureBalance_updatestart2", updateSql.toString(), new Object[]{companyID, companyID, startPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{companyID, companyID, startPeriod.getNumber()});
            insertSql = new StringBuffer();
            insertSql.append("insert into ").append(T_MeasureBalance).append("( \r\n");
            insertSql.append(this.getOrgSelector()).append("forgunitid, fperiod, faccountid, fassistgrpid, fmeasureunitid \r\n");
            if (isForCurrency) {
                insertSql.append(", fcurrencyid \r\n");
            }
            insertSql.append(") \r\n");
            insertSql.append("select ").append(this.getOrgSelector("ab")).append("ab.forgunitid, ? fperiod, ab.faccountid, ab.fassistgrpid, ab.fmeasureunitid \r\n");
            if (isForCurrency) {
                insertSql.append(", ab.fcurrencyid \r\n");
            }
            insertSql.append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n");
            insertSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? ");
            if (isForCurrency) {
                insertSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                insertSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                insertSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            if (accounts != null) {
                insertSql.append("and ab.faccountid in (").append(ids).append(") ");
            }
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                insertSql.append(" and ab.FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            insertSql.append("and ab.fmeasureunitid is not null and not exists ( \r\n");
            insertSql.append("select 1 from ").append(T_MeasureBalance).append(" ab1 \r\n");
            insertSql.append("where ab1.").append(this.getOrgColumnNameB()).append("=ab.").append(this.getOrgColumnNameB()).append(" and ab1.fperiod = ? and ab1.faccountid=ab.faccountid and ab1.fassistgrpid=ab.fassistgrpid and ab1.fmeasureunitid=ab.fmeasureunitid \r\n");
            if (isForCurrency) {
                insertSql.append("and ab1.fcurrencyid=ab.fcurrencyid \r\n");
            }
            insertSql.append(") \r\n");
            if (logger.isDebugEnabled()) {
                GLBalanceFacadeControllerBean.logSql("initMeasureBalance_insertfirst1", insertSql.toString(), new Object[]{firstPeriod.getNumber(), companyID, firstPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{firstPeriod.getNumber(), companyID, firstPeriod.getNumber()});
            updateSql = new StringBuffer();
            updateSql.append("update ").append(T_MeasureBalance).append(" set ( \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor, fdebitfor, fcreditfor, fyeardebitfor, fyearcreditfor, fendbalancefor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal, fdebitlocal, fcreditlocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt, fdebitrpt, fcreditrpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, \r\n");
            }
            updateSql.append("fbeginqty, fdebitqty, fcreditqty, fyeardebitqty, fyearcreditqty, fendqty\r\n").append(" ) = ( select \r\n");
            if (isForCurrency) {
                updateSql.append("beginbalancefor * fdc - yeardebitfor + yearcreditfor, yeardebitfor, yearcreditfor, yeardebitfor, yearcreditfor, beginbalancefor * fdc, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("beginbalancelocal * fdc - yeardebitlocal + yearcreditlocal, yeardebitlocal, yearcreditlocal, yeardebitlocal, yearcreditlocal, beginbalancelocal * fdc, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("beginbalancerpt * fdc - yeardebitrpt + yearcreditrpt, yeardebitrpt, yearcreditrpt, yeardebitrpt, yearcreditrpt, beginbalancerpt * fdc, \r\n");
            }
            updateSql.append("beginqty * fdc - yeardebitqty + yearcreditqty, yeardebitqty, yearcreditqty, yeardebitqty, yearcreditqty, beginqty * fdc \r\n").append("from ( \r\n").append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", ab.faccountid accountid, ab.fassistgrpid assistgrpid, ab.fmeasureunitid measureunitid, ab.fcurrencyid currencyid, \r\n").append("ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fbeginbalancefor beginbalancefor, \r\n").append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fbeginbalancelocal beginbalancelocal, \r\n").append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fbeginbalancerpt beginbalancerpt, \r\n").append("ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty, isNull(ab.fbeginqty,0) beginqty,\r\n").append("av.fdc \r\n").append("from ").append(this.getInitAssistBalanceTable()).append(" ab \r\n").append("inner join t_bd_accountview av on ab.faccountid=av.fid and ab.forgunitid=av.fcompanyid \r\n");
            updateSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            if (isForCurrency) {
                updateSql.append("and ab.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
                updateSql.append("and ab.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
            } else {
                updateSql.append("and ab.fcurrencyid = '").append(currencyId).append("' \n");
            }
            updateSql.append(") t \r\n").append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n").append("and accountid = faccountid \r\n").append("and assistgrpid = fassistgrpid \r\n").append("and measureunitid = fmeasureunitid \r\n");
            if (isForCurrency) {
                updateSql.append("and currencyid = fcurrencyid \r\n");
            } else {
                updateSql.append("and currencyid = '" + currencyId + "' \r\n");
            }
            updateSql.append(" ) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? ");
            if (accounts != null) {
                updateSql.append("and faccountid in (").append(ids).append(") ");
            }
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                updateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            updateSql.append("\r\n");
            if (logger.isDebugEnabled()) {
                GLBalanceFacadeControllerBean.logSql("initMeasureBalance_updatefirst", updateSql.toString(), new Object[]{companyID, companyID, firstPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{companyID, companyID, firstPeriod.getNumber()});
        }
    }

    @Override
    protected void _antiInitBalance(Context ctx, String companyID, String startPeriodID, String firstPeriodID, String tableName) throws BOSException {
        IObjectCollection accounts = null;
        StringBuffer sb = new StringBuffer();
        if (ctx != null) {
            accounts = (IObjectCollection)ctx.get((Object)"accounts");
        }
        if (accounts != null && accounts.size() > 0) {
            for (int i = 0; i < accounts.size(); ++i) {
                AccountViewInfo accountView = (AccountViewInfo)accounts.getObject(i);
                sb.append("'" + accountView.getId() + "',");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        String accoutViewCon = sb.toString();
        PeriodInfo startPeriod = null;
        PeriodInfo firstPeriod = null;
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            startPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(startPeriodID), selector);
            firstPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(firstPeriodID), selector);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        int balanceType = this.getBalanceType(tableName);
        if (balanceType == -1) {
            return;
        }
        this.doAntiInitBalance(ctx, companyID, startPeriod, firstPeriod, balanceType, 1, null, accoutViewCon);
        this.doAntiInitBalance(ctx, companyID, startPeriod, firstPeriod, balanceType, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", accoutViewCon);
        this.doAntiInitBalance(ctx, companyID, startPeriod, firstPeriod, balanceType, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", accoutViewCon);
        this.doAntiInitBalance(ctx, companyID, startPeriod, firstPeriod, balanceType, 5, null, accoutViewCon);
        this.doAntiInitBalance(ctx, companyID, startPeriod, firstPeriod, balanceType, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", accoutViewCon);
        this.doAntiInitBalance(ctx, companyID, startPeriod, firstPeriod, balanceType, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", accoutViewCon);
    }

    protected int getBalanceType(String tableName) {
        int balanceType = 1;
        balanceType = "T_GL_AccountBalance".equalsIgnoreCase(tableName) ? 1 : ("T_GL_AssistBalance".equalsIgnoreCase(tableName) ? 2 : ("T_GL_AssistMeasureBalance".equalsIgnoreCase(tableName) ? 3 : -1));
        return balanceType;
    }

    protected void doAntiInitBalance(Context ctx, String companyID, PeriodInfo startPeriod, PeriodInfo firstPeriod, int balanceType, int baltype, String currencyId, String accoutViewCon) throws BOSException {
        boolean isFirstPeriod = startPeriod.getId().toString().equals(firstPeriod.getId().toString());
        String tableName = this.getBalanceTable(balanceType, baltype, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        if (isFirstPeriod) {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update ").append(tableName).append(" set \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor = 0.0, fendbalancefor = fdebitfor-fcreditfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal = 0.0, fendbalancelocal = fdebitlocal-fcreditlocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt = 0.0, fendbalancerpt = fdebitrpt-fcreditrpt, \r\n");
            }
            updateSql.append("fbeginqty = 0.0, fendqty = fdebitqty-fcreditqty \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
            if (accoutViewCon.length() > 0) {
                updateSql.append(" and FACCOUNTID in ( " + accoutViewCon + " )");
            }
            if (logger.isDebugEnabled()) {
                GLBalanceFacadeControllerBean.logSql("antiInitBalance1_" + tableName, updateSql.toString(), new Object[]{companyID, startPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{companyID, startPeriod.getNumber()});
        } else {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update ").append(tableName).append(" set \r\n");
            if (isForCurrency) {
                updateSql.append("fbeginbalancefor = 0.0, fyeardebitfor = fdebitfor, fyearcreditfor = fcreditfor, fendbalancefor = fdebitfor - fcreditfor, \r\n");
                updateSql.append("fyearpnlfor = fmonthpnlfor, \r\n");
            }
            if (isLocalCurrency || isForCurrency) {
                updateSql.append("fbeginbalancelocal = 0.0, fyeardebitlocal = fdebitlocal, fyearcreditlocal = fcreditlocal, fendbalancelocal = fdebitlocal - fcreditlocal, \r\n");
                updateSql.append("fyearpnllocal = fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                updateSql.append("fbeginbalancerpt = 0.0, fyeardebitrpt = fdebitrpt, fyearcreditrpt = fcreditrpt, fendbalancerpt = fdebitrpt - fcreditrpt, \r\n");
                updateSql.append("fyearpnlrpt = fmonthpnlrpt, \r\n");
            }
            updateSql.append("fbeginqty = 0.0, fyeardebitqty = fdebitqty, fyearcreditqty = fcreditqty, fendqty = fdebitqty - fcreditqty, \r\n");
            updateSql.append("fyearpnlqty = isNull(fmonthpnlqty,0) \r\n");
            updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
            if (accoutViewCon.length() > 0) {
                updateSql.append(" and FACCOUNTID in ( " + accoutViewCon + " )");
            }
            if (logger.isDebugEnabled()) {
                GLBalanceFacadeControllerBean.logSql("antiInitBalance2_" + tableName, updateSql.toString(), new Object[]{companyID, startPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{companyID, startPeriod.getNumber()});
            StringBuffer deleteSql = new StringBuffer().append("delete from ").append(tableName).append(" where ").append(this.getOrgColumnNameB()).append(" = ?").append(" and fperiod = ? ");
            if (accoutViewCon.length() > 0) {
                deleteSql.append(" and FACCOUNTID in ( " + accoutViewCon + " )");
            }
            if (logger.isDebugEnabled()) {
                GLBalanceFacadeControllerBean.logSql("antiInitBalanced_" + tableName, deleteSql.toString(), new Object[]{companyID, firstPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)deleteSql.toString(), (Object[])new Object[]{companyID, firstPeriod.getNumber()});
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _transBalanceToNextPeriod(Context ctx, String companyID, String currentPeriodID, String nextPeriodID, boolean isNextYear, String acctIDs) throws BOSException {
        if (this.isOracle10gOver(ctx)) {
            this.transBalanceToNextPeriodOracle(ctx, companyID, currentPeriodID, nextPeriodID, isNextYear, acctIDs);
            return;
        }
        String assistTmp1F = null;
        String assistTmp1L = null;
        String assistTmp1R = null;
        String assistTmp5F = null;
        String assistTmp5L = null;
        String assistTmp5R = null;
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            PeriodInfo currentPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(currentPeriodID), selector);
            PeriodInfo nextPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(nextPeriodID), selector);
            assistTmp1F = this.getAssistBalanceTempTable(ctx, isNextYear, null);
            assistTmp1L = this.getAssistBalanceTempTable(ctx, isNextYear, "11111111-1111-1111-1111-111111111111DEB58FDC");
            assistTmp1R = this.getAssistBalanceTempTable(ctx, isNextYear, "22222222-2222-2222-2222-222222222222DEB58FDC");
            assistTmp5F = this.getAssistBalanceTempTable(ctx, isNextYear, null);
            assistTmp5L = this.getAssistBalanceTempTable(ctx, isNextYear, "11111111-1111-1111-1111-111111111111DEB58FDC");
            assistTmp5R = this.getAssistBalanceTempTable(ctx, isNextYear, "22222222-2222-2222-2222-222222222222DEB58FDC");
            this.doTransBalanceToNextPeriod(ctx, companyID, currentPeriod, nextPeriod, isNextYear, acctIDs, 1, null, assistTmp1F);
            this.doTransBalanceToNextPeriod(ctx, companyID, currentPeriod, nextPeriod, isNextYear, acctIDs, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", assistTmp1L);
            this.doTransBalanceToNextPeriod(ctx, companyID, currentPeriod, nextPeriod, isNextYear, acctIDs, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", assistTmp1R);
            this.doTransBalanceToNextPeriod(ctx, companyID, currentPeriod, nextPeriod, isNextYear, acctIDs, 5, null, assistTmp5F);
            this.doTransBalanceToNextPeriod(ctx, companyID, currentPeriod, nextPeriod, isNextYear, acctIDs, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", assistTmp5L);
            this.doTransBalanceToNextPeriod(ctx, companyID, currentPeriod, nextPeriod, isNextYear, acctIDs, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", assistTmp5R);
            if (!isNextYear) {
                this.transZeroBalanceToNextPeriod(ctx, companyID, currentPeriod, nextPeriod, acctIDs);
            }
        }
        catch (BOSException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                try {
                    TempTablePool.getInstance((Context)ctx).releaseTable(assistTmp1F);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    TempTablePool.getInstance((Context)ctx).releaseTable(assistTmp1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    TempTablePool.getInstance((Context)ctx).releaseTable(assistTmp1R);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    TempTablePool.getInstance((Context)ctx).releaseTable(assistTmp5F);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    TempTablePool.getInstance((Context)ctx).releaseTable(assistTmp5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    TempTablePool.getInstance((Context)ctx).releaseTable(assistTmp5R);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(assistTmp1F);
        }
        catch (Exception selector) {
            // empty catch block
        }
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(assistTmp1L);
        }
        catch (Exception selector) {
            // empty catch block
        }
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(assistTmp1R);
        }
        catch (Exception selector) {
            // empty catch block
        }
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(assistTmp5F);
        }
        catch (Exception selector) {
            // empty catch block
        }
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(assistTmp5L);
        }
        catch (Exception selector) {
            // empty catch block
        }
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(assistTmp5R);
        }
        catch (Exception selector) {
            // empty catch block
        }
        SQLUtils.cleanup((Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOracle10gOver(Context ctx) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean isMore10Oracle = false;
        try {
            String version;
            String bigVersion;
            conn = EJBFactory.getConnection((Context)ctx);
            int dbType = KSqlUtil.getDbType((Connection)conn);
            if ((2 == dbType || 8 == dbType || 7 == dbType) && (rs = (stmt = conn.prepareStatement("select top 1 version from product_component_version")).executeQuery()).next() && Integer.parseInt(bigVersion = (version = rs.getString("version")).split("\\.")[0]) >= 10) {
                isMore10Oracle = true;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        }
        catch (SQLException e) {
            logger.error((Object)"Query oracle version error when gl period close !", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
        return isMore10Oracle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transBalanceToNextPeriodOracle(Context ctx, String companyID, String currentPeriodID, String nextPeriodID, boolean isNextYear, String acctIDs) throws BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        PeriodInfo nextPeriodInfo = null;
        PeriodInfo currPeriodInfo = null;
        try {
            IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
            nextPeriodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(nextPeriodID), selector);
            currPeriodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(currentPeriodID), selector);
        }
        catch (EASBizException e) {
            throw new BOSException("Get PeriodInfo error!", (Throwable)e);
        }
        int threadCount = 1;
        try {
            int i;
            HashMap<String, String> in = new HashMap<String, String>();
            in.put("GL_Close_ThreadCount", companyID);
            HashMap out = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(in);
            Object value = out.get("GL_Close_ThreadCount");
            if (value != null && (i = Integer.parseInt(value.toString())) >= 1 && i <= 6) {
                threadCount = i;
            }
        }
        catch (Exception e) {
            throw new BOSException("Get parameter GL_Close_ThreadCount error!", (Throwable)e);
        }
        if (threadCount <= 1) {
            Object[] params = new Object[]{companyID, currPeriodInfo.getNumber(), nextPeriodInfo.getNumber(), nextPeriodInfo.getNumber()};
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 1, 1, null, acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 1, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 1, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 1, 5, null, acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 1, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 1, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 2, 1, null, acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 2, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 2, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 2, 5, null, acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 2, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 2, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 3, 1, null, acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 3, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 3, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 3, 5, null, acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 3, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)this.getBalanceToNextPeriodOracleSQL(isNextYear, 3, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", acctIDs), (Object[])params);
            if (!isNextYear) {
                this.transZeroBalanceToNextPeriod(ctx, companyID, currPeriodInfo, nextPeriodInfo, acctIDs);
            }
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        try {
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            Future<Object> future = executor.submit(new transBalanceCallable(ctx, companyID, currPeriodInfo, nextPeriodInfo, isNextYear, acctIDs, 1, null));
            futures.add(future);
            future = executor.submit(new transBalanceCallable(ctx, companyID, currPeriodInfo, nextPeriodInfo, isNextYear, acctIDs, 1, "11111111-1111-1111-1111-111111111111DEB58FDC"));
            futures.add(future);
            future = executor.submit(new transBalanceCallable(ctx, companyID, currPeriodInfo, nextPeriodInfo, isNextYear, acctIDs, 1, "22222222-2222-2222-2222-222222222222DEB58FDC"));
            futures.add(future);
            future = executor.submit(new transBalanceCallable(ctx, companyID, currPeriodInfo, nextPeriodInfo, isNextYear, acctIDs, 5, null));
            futures.add(future);
            future = executor.submit(new transBalanceCallable(ctx, companyID, currPeriodInfo, nextPeriodInfo, isNextYear, acctIDs, 5, "11111111-1111-1111-1111-111111111111DEB58FDC"));
            futures.add(future);
            future = executor.submit(new transBalanceCallable(ctx, companyID, currPeriodInfo, nextPeriodInfo, isNextYear, acctIDs, 5, "22222222-2222-2222-2222-222222222222DEB58FDC"));
            futures.add(future);
            Exception ex = null;
            for (Future future2 : futures) {
                try {
                    future2.get();
                }
                catch (Exception e) {
                    Throwable cause = e.getCause();
                    if (cause != null && cause instanceof BOSException) {
                        e = (Exception)cause;
                    }
                    logger.error((Object)STRING, (Throwable)e);
                    if (ex != null) continue;
                    ex = e;
                }
            }
            if (ex != null) {
                if (ex instanceof BOSException) {
                    throw (BOSException)((Object)ex);
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new BOSException(ex);
            }
        }
        finally {
            executor.shutdown();
        }
    }

    protected void transZeroBalanceToNextPeriod(Context ctx, String companyID, PeriodInfo currPeriodInfo, PeriodInfo nextPeriodInfo, String acctIDs) throws BOSException {
        Object[] params = new Object[]{companyID, nextPeriodInfo.getNumber(), currPeriodInfo.getNumber()};
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(1, 1, null, acctIDs), (Object[])params);
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(1, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", acctIDs), (Object[])params);
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(1, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", acctIDs), (Object[])params);
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(1, 5, null, acctIDs), (Object[])params);
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(1, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", acctIDs), (Object[])params);
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(1, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", acctIDs), (Object[])params);
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(2, 1, null, acctIDs), (Object[])params);
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(2, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", acctIDs), (Object[])params);
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(2, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", acctIDs), (Object[])params);
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(2, 5, null, acctIDs), (Object[])params);
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(2, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", acctIDs), (Object[])params);
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(2, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", acctIDs), (Object[])params);
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(3, 1, null, acctIDs), (Object[])params);
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(3, 1, "11111111-1111-1111-1111-111111111111DEB58FDC", acctIDs), (Object[])params);
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(3, 1, "22222222-2222-2222-2222-222222222222DEB58FDC", acctIDs), (Object[])params);
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(3, 5, null, acctIDs), (Object[])params);
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(3, 5, "11111111-1111-1111-1111-111111111111DEB58FDC", acctIDs), (Object[])params);
        DbUtil.execute((Context)ctx, (String)this.getZeroBalanceToNextPeriodSQL(3, 5, "22222222-2222-2222-2222-222222222222DEB58FDC", acctIDs), (Object[])params);
    }

    protected String getZeroBalanceToNextPeriodSQL(int balTableType, int baltype, String currencyId, String acctIDs) {
        boolean isForCurency = !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId);
        StringBuffer sql = new StringBuffer();
        String balTable = this.getBalanceTable(balTableType, baltype, currencyId);
        sql.append(" UPDATE   ").append(balTable).append("    set    ");
        if (isForCurency) {
            sql.append(" fbeginbalance").append("for").append(" = 0,");
            sql.append(" fendbalance").append("for").append(" = fdebit").append("for").append(" - fcredit").append("for").append(",");
            sql.append(" fyeardebit").append("for").append(" = fdebit").append("for").append(",");
            sql.append(" fyearcredit").append("for").append(" = fcredit").append("for").append(",");
        }
        if (isForCurency || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sql.append(" fbeginbalance").append("local").append(" = 0,");
            sql.append(" fendbalance").append("local").append(" = fdebit").append("local").append(" - fcredit").append("local").append(",");
            sql.append(" fyeardebit").append("local").append(" = fdebit").append("local").append(",");
            sql.append(" fyearcredit").append("local").append(" = fcredit").append("local").append(",");
        }
        if (isForCurency || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append(" fbeginbalance").append("rpt").append(" = 0,");
            sql.append(" fendbalance").append("rpt").append(" = fdebit").append("rpt").append(" - fcredit").append("rpt").append(",");
            sql.append(" fyeardebit").append("rpt").append(" = fdebit").append("rpt").append(",");
            sql.append(" fyearcredit").append("rpt").append(" = fcredit").append("rpt").append(",");
        }
        sql.append(" fbeginqty").append(" = 0,");
        sql.append(" fyeardebitqty").append(" = fdebitqty,");
        sql.append(" fyearcreditqty").append(" = fcreditqty,");
        sql.append(" fendqty").append(" = fdebitqty").append(" - fcreditqty").append(",");
        sql = new StringBuffer(sql.substring(0, sql.length() - 1));
        sql.append(" where ").append(balTable).append(".").append(this.getOrgColumnNameB()).append(" = ? ");
        if (!StringUtils.isEmpty((String)acctIDs)) {
            sql.append(" and ").append(balTable).append(".faccountid in (").append(acctIDs).append(") ");
        }
        sql.append(" and ").append(balTable).append(".fperiod = ? ");
        sql.append(" and not exists (SELECT 1 FROM ").append(balTable).append(" tout where ");
        sql.append(" tout.").append(this.getOrgColumnNameB()).append("=").append(balTable).append(".").append(this.getOrgColumnNameB()).append("\n");
        sql.append(" and tout.").append("faccountid").append("=").append(balTable).append(".faccountid").append("\n");
        if (isForCurency) {
            sql.append(" and tout.fcurrencyid =").append(balTable).append(".fcurrencyid").append("\n");
        }
        if (2 == balTableType || 3 == balTableType) {
            sql.append(" and tout.fassistgrpid=").append(balTable).append(".fassistgrpid").append("\n");
            if (3 == balTableType) {
                sql.append(" and tout.fmeasureunitid = ").append(balTable).append(".fmeasureunitid").append("\n");
            }
        }
        sql.append(" and tout.fperiod").append("=? \n");
        sql.append(") \n");
        return sql.toString();
    }

    protected String getBalanceToNextPeriodOracleSQL(boolean isNextYear, int balTableType, int baltype, String currencyId, String acctIDs) {
        boolean isForCurency = !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId);
        StringBuffer sql = new StringBuffer();
        String balTable = this.getBalanceTable(balTableType, baltype, currencyId);
        sql.append(" /*dialect*/MERGE INTO ").append(balTable).append(" tin USING (select * from ").append(balTable).append(" where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ?");
        if (!StringUtils.isEmpty((String)acctIDs)) {
            sql.append(" and faccountid in (").append(acctIDs).append(")");
        }
        sql.append(") tout ");
        sql.append(" ON (tin.").append(this.getOrgColumnNameB()).append(" = tout.").append(this.getOrgColumnNameB()).append(" and tin.faccountid = tout.faccountid");
        if (isForCurency) {
            sql.append(" and tin.fcurrencyid = tout.fcurrencyid ");
        }
        if (2 == balTableType || 3 == balTableType) {
            sql.append(" and tin.fassistgrpid = tout.fassistgrpid ");
            if (3 == balTableType) {
                sql.append(" and tin.fmeasureunitid = tout.fmeasureunitid ");
            }
        }
        sql.append(" and tin.fperiod = ?) ");
        sql.append(" WHEN MATCHED THEN UPDATE SET ");
        if (isForCurency) {
            sql.append(this.getUpdateAmountSQL(isNextYear, "for"));
        }
        if (isForCurency || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sql.append(this.getUpdateAmountSQL(isNextYear, "local"));
        }
        if (isForCurency || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append(this.getUpdateAmountSQL(isNextYear, "rpt"));
        }
        sql.append(this.getUpdateQtySQL(isNextYear));
        StringBuffer fsql = new StringBuffer();
        if (isForCurency) {
            fsql.append(this.getEqualAmountSQL(isNextYear, "for"));
        }
        if (isForCurency || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            if (fsql.length() > 0) {
                fsql.append(" or ");
            }
            fsql.append(this.getEqualAmountSQL(isNextYear, "local"));
        }
        if (isForCurency || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            if (fsql.length() > 0) {
                fsql.append(" or ");
            }
            fsql.append(this.getEqualAmountSQL(isNextYear, "rpt"));
        }
        if (fsql.length() > 0) {
            fsql.append(" or ");
        }
        fsql.append(this.getEqualQtySQL(isNextYear));
        sql.append(" where ").append(fsql.toString());
        sql.append(" WHEN NOT MATCHED THEN ");
        sql.append(" INSERT (forgunitid, ").append(this.getOrgSelector()).append(" fperiod, faccountid, ");
        if (isForCurency) {
            sql.append(" fcurrencyid,");
        }
        if (2 == balTableType || 3 == balTableType) {
            sql.append(" fassistgrpid, ");
            if (3 == balTableType) {
                sql.append(" fmeasureunitid, ");
            }
        }
        if (isForCurency) {
            sql.append(" fbeginbalancefor,fendbalancefor,");
            if (!isNextYear) {
                sql.append(" fyeardebitfor,fyearcreditfor,fyearpnlfor,");
            }
        }
        if (isForCurency || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sql.append(" fbeginbalancelocal,fendbalancelocal,");
            if (!isNextYear) {
                sql.append(" fyeardebitlocal,fyearcreditlocal,fyearpnllocal,");
            }
        }
        if (isForCurency || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append(" fbeginbalancerpt,fendbalancerpt,");
            if (!isNextYear) {
                sql.append(" fyeardebitrpt,fyearcreditrpt,fyearpnlrpt,");
            }
        }
        sql.append(" fbeginqty,fendqty,");
        if (!isNextYear) {
            sql.append(" fyeardebitqty,fyearcreditqty,fyearpnlqty,");
        }
        sql.append(" fdetailcount)");
        sql.append(" VALUES (tout.forgunitid,").append(this.getOrgSelector("tout")).append(" ?, tout.faccountid,");
        if (isForCurency) {
            sql.append(" tout.fcurrencyid,");
        }
        if (2 == balTableType || 3 == balTableType) {
            sql.append(" tout.fassistgrpid, ");
            if (3 == balTableType) {
                sql.append(" tout.fmeasureunitid, ");
            }
        }
        if (isForCurency) {
            sql.append(" tout.fendbalancefor,tout.fendbalancefor,");
            if (!isNextYear) {
                sql.append(" tout.fyeardebitfor,tout.fyearcreditfor,tout.fyearpnlfor,");
            }
        }
        if (isForCurency || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            sql.append(" tout.fendbalancelocal,tout.fendbalancelocal,");
            if (!isNextYear) {
                sql.append(" tout.fyeardebitlocal,tout.fyearcreditlocal,tout.fyearpnllocal,");
            }
        }
        if (isForCurency || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            sql.append(" tout.fendbalancerpt,tout.fendbalancerpt,");
            if (!isNextYear) {
                sql.append(" tout.fyeardebitrpt,tout.fyearcreditrpt,tout.fyearpnlrpt,");
            }
        }
        sql.append(" tout.fendqty,tout.fendqty,");
        if (!isNextYear) {
            sql.append(" tout.fyeardebitqty,tout.fyearcreditqty,nvl(tout.fyearpnlqty,0),");
        }
        sql.append("0)");
        return sql.toString();
    }

    protected String getUpdateAmountSQL(boolean isNextYear, String suffix) {
        StringBuffer sql = new StringBuffer();
        sql.append(" tin.fbeginbalance").append(suffix).append(" = tout.fendbalance").append(suffix).append(",");
        sql.append(" tin.fendbalance").append(suffix).append(" = tout.fendbalance").append(suffix).append(" + tin.fdebit").append(suffix).append(" - tin.fcredit").append(suffix).append(",");
        if (!isNextYear) {
            sql.append(" tin.fyeardebit").append(suffix).append(" = tout.fyeardebit").append(suffix).append(" + tin.fdebit").append(suffix).append(",");
            sql.append(" tin.fyearcredit").append(suffix).append(" = tout.fyearcredit").append(suffix).append(" + tin.fcredit").append(suffix).append(",");
            sql.append(" tin.fyearpnl").append(suffix).append(" = tout.fyearpnl").append(suffix).append(" + tin.fmonthpnl").append(suffix).append(",");
        }
        return sql.toString();
    }

    protected String getUpdateQtySQL(boolean isNextYear) {
        StringBuffer sql = new StringBuffer();
        if (!isNextYear) {
            sql.append(" tin.fyeardebitqty = tout.fyeardebitqty + tin.fdebitqty,");
            sql.append(" tin.fyearcreditqty = tout.fyearcreditqty + tin.fcreditqty,");
            sql.append(" tin.fyearpnlqty = nvl(tout.fyearpnlqty,0) + nvl(tin.fmonthpnlqty,0),");
        }
        sql.append(" tin.fbeginqty = tout.fendqty,");
        sql.append(" tin.fendqty = tout.fendqty + tin.fdebitqty - tin.fcreditqty");
        return sql.toString();
    }

    protected String getEqualAmountSQL(boolean isNextYear, String suffix) {
        StringBuffer sql = new StringBuffer();
        sql.append(" tin.fbeginbalance").append(suffix).append(" <> tout.fendbalance").append(suffix);
        if (!isNextYear) {
            sql.append(" or tin.fyeardebit").append(suffix).append(" <> tout.fyeardebit").append(suffix).append(" + tin.fdebit").append(suffix);
            sql.append(" or tin.fyearcredit").append(suffix).append(" <> tout.fyearcredit").append(suffix).append(" + tin.fcredit").append(suffix);
            sql.append(" or tin.fyearpnl").append(suffix).append(" <> tout.fyearpnl").append(suffix).append(" + tin.fmonthpnl").append(suffix);
        }
        return sql.toString();
    }

    protected String getEqualQtySQL(boolean isNextYear) {
        StringBuffer sql = new StringBuffer();
        sql.append(" tin.fbeginqty <> tout.fendqty");
        if (!isNextYear) {
            sql.append(" or tin.fyeardebitqty <> tout.fyeardebitqty + tin.fdebitqty");
            sql.append(" or tin.fyearcreditqty <> tout.fyearcreditqty + tin.fcreditqty");
            sql.append(" or nvl(tin.fyearpnlqty,0) <> nvl(tout.fyearpnlqty,0) + nvl(tin.fmonthpnlqty,0)");
        }
        return sql.toString();
    }

    protected String getAmountZeroFilter(boolean isNextYear, String currencyId) {
        boolean isForCurency = !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId);
        StringBuffer sql = new StringBuffer();
        if (isForCurency) {
            sql.append("  tout.fendbalancefor<>0");
        }
        if (isForCurency || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            if (sql.length() > 0) {
                sql.append(" or ");
            }
            sql.append(" tout.fendbalancelocal<>0");
        }
        if (isForCurency || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            if (sql.length() > 0) {
                sql.append(" or ");
            }
            sql.append(" tout.fendbalancerpt<>0");
        }
        if (sql.length() > 0) {
            sql.append(" or ");
        }
        sql.append(" tout.fendqty<>0 ");
        if (!isNextYear) {
            if (isForCurency) {
                sql.append(" or tout.fyeardebitfor<>0 or tout.fyearcreditfor<>0 or tout.fyearpnlfor<>0 ");
            }
            if (isForCurency || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
                sql.append(" or tout.fyeardebitlocal<>0 or tout.fyearcreditlocal<>0 or tout.fyearpnllocal<>0 ");
            }
            if (isForCurency || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
                sql.append(" or tout.fyeardebitrpt<>0 or tout.fyearcreditrpt<>0 or tout.fyearpnlrpt<>0 ");
            }
            sql.append(" or tout.fyeardebitqty<>0 or tout.fyearcreditqty<>0 or nvl(tout.fyearpnlqty,0)<>0 ");
            sql.append(" or nvl(tout.FDetailCount,0)<>0 ");
        }
        return " where (" + sql.toString() + ")";
    }

    protected void doTransBalanceToNextPeriod(Context ctx, String companyID, PeriodInfo currentPeriod, PeriodInfo nextPeriod, boolean isNextYear, String acctIDs, int baltype, String currencyId, String assistTmp) throws BOSException {
        String T_AccountBalance = this.getBalanceTable(1, baltype, currencyId);
        String T_AssistBalance = this.getBalanceTable(2, baltype, currencyId);
        String T_AssistMeasureBalance = this.getBalanceTable(3, baltype, currencyId);
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer acctInsertSql = new StringBuffer();
        acctInsertSql.append("insert into " + T_AccountBalance + " ( \n");
        acctInsertSql.append("    forgunitid, ").append(this.getOrgSelector()).append(" faccountid, ");
        if (isForCurrency) {
            acctInsertSql.append("fcurrencyid, ");
        }
        acctInsertSql.append("fperiod \n");
        acctInsertSql.append(") \n");
        acctInsertSql.append("select ab.forgunitid, ").append(this.getOrgSelector("ab")).append("ab.faccountid, ");
        if (isForCurrency) {
            acctInsertSql.append("ab.fcurrencyid, ");
        }
        acctInsertSql.append("? \n");
        acctInsertSql.append("from ").append(T_AccountBalance).append(" ab \n");
        acctInsertSql.append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \n");
        acctInsertSql.append("    and ab.fperiod = ? \n");
        if (acctIDs != null && !STRING.equals(acctIDs)) {
            acctInsertSql.append(" and ab.FAccountid in (").append(acctIDs).append(")       \r\n");
        }
        acctInsertSql.append("    and not exists ( \n");
        acctInsertSql.append("        select 1 from ").append(T_AccountBalance).append(" ab1 \n");
        acctInsertSql.append("        where ab1.").append(this.getOrgColumnNameB()).append(" = ? \n");
        acctInsertSql.append("        and ab1.fperiod = ? \n");
        acctInsertSql.append("        and ab1.faccountid=ab.faccountid \n");
        if (isForCurrency) {
            acctInsertSql.append("        and ab1.fcurrencyid=ab.fcurrencyid \n");
        }
        acctInsertSql.append("    ) \n");
        if (logger.isDebugEnabled()) {
            GLBalanceFacadeControllerBean.logSql("transAccountBalance1", acctInsertSql.toString(), new Object[]{nextPeriod.getNumber(), companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)acctInsertSql.toString(), (Object[])new Object[]{nextPeriod.getNumber(), companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        StringBuffer acctUpdateSql = new StringBuffer();
        if (isNextYear) {
            acctUpdateSql.append("update ").append(T_AccountBalance).append(" set ( \r\n");
            if (isForCurrency) {
                acctUpdateSql.append("fbeginbalancefor, fendbalancefor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                acctUpdateSql.append("fbeginbalancelocal, fendbalancelocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                acctUpdateSql.append("fbeginbalancerpt, fendbalancerpt, \r\n");
            }
            acctUpdateSql.append("fbeginqty, fendqty \r\n");
            acctUpdateSql.append(") = ( \r\n");
            acctUpdateSql.append("select \r\n");
            if (isForCurrency) {
                acctUpdateSql.append("endbalancefor, endbalancefor + fdebitfor - fcreditfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                acctUpdateSql.append("endbalancelocal, endbalancelocal + fdebitlocal - fcreditlocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                acctUpdateSql.append("endbalancerpt, endbalancerpt + fdebitrpt - fcreditrpt, \r\n");
            }
            acctUpdateSql.append("endqty, endqty + fdebitqty - fcreditqty \r\n");
            acctUpdateSql.append("from ( \r\n");
            acctUpdateSql.append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", \r\n");
            acctUpdateSql.append("ab.fperiod period, ab.faccountid accountid, \n");
            if (isForCurrency) {
                acctUpdateSql.append("ab.fcurrencyid currencyid, \n");
            }
            if (isForCurrency) {
                acctUpdateSql.append("ab.fendbalancefor endbalancefor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                acctUpdateSql.append("ab.fendbalancelocal endbalancelocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                acctUpdateSql.append("ab.fendbalancerpt endbalancerpt, \r\n");
            }
            acctUpdateSql.append("ab.fendqty endqty \r\n");
            acctUpdateSql.append("from ").append(T_AccountBalance).append(" ab where ab.").append(this.getOrgColumnNameB()).append("=? \n");
            acctUpdateSql.append("and ab.fperiod=? ) t \r\n").append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n").append("and accountid = faccountid \r\n");
            if (isForCurrency) {
                acctUpdateSql.append("and currencyid = fcurrencyid \r\n");
            }
            acctUpdateSql.append(" ) \r\n");
            acctUpdateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                acctUpdateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
        } else {
            acctUpdateSql.append("update ").append(T_AccountBalance).append(" set ( \r\n");
            if (isForCurrency) {
                acctUpdateSql.append("    fbeginbalancefor, fyeardebitfor, fyearcreditfor, fendbalancefor, \r\n");
                acctUpdateSql.append("    fyearpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                acctUpdateSql.append("    fbeginbalancelocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, \r\n");
                acctUpdateSql.append("    fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                acctUpdateSql.append("    fbeginbalancerpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, \r\n");
                acctUpdateSql.append("    fyearpnlrpt, \r\n");
            }
            acctUpdateSql.append("    fbeginqty, fyeardebitqty, fyearcreditqty, fendqty, fyearpnlqty \r\n");
            acctUpdateSql.append(") = ( \r\n");
            acctUpdateSql.append("select \r\n");
            if (isForCurrency) {
                acctUpdateSql.append("    endbalancefor, yeardebitfor + fdebitfor, yearcreditfor + fcreditfor, endbalancefor + fdebitfor - fcreditfor, \r\n");
                acctUpdateSql.append("    yearpnlfor + fmonthpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                acctUpdateSql.append("    endbalancelocal, yeardebitlocal + fdebitlocal, yearcreditlocal + fcreditlocal, endbalancelocal + fdebitlocal - fcreditlocal, \r\n");
                acctUpdateSql.append("    yearpnllocal + fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                acctUpdateSql.append("    endbalancerpt, yeardebitrpt + fdebitrpt, yearcreditrpt + fcreditrpt, endbalancerpt + fdebitrpt - fcreditrpt, \r\n");
                acctUpdateSql.append("    yearpnlrpt + fmonthpnlrpt, \r\n");
            }
            acctUpdateSql.append("    endqty, yeardebitqty + fdebitqty, yearcreditqty + fcreditqty, endqty + fdebitqty - fcreditqty, \r\n");
            acctUpdateSql.append("    isNull(yearpnlqty,0) + isNull(fmonthpnlqty,0) \r\n");
            acctUpdateSql.append("from ( \r\n");
            acctUpdateSql.append("    select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", \r\n");
            acctUpdateSql.append("    ab.fperiod period, ab.faccountid accountid, \n");
            if (isForCurrency) {
                acctUpdateSql.append("    ab.fcurrencyid currencyid, \r\n");
            }
            if (isForCurrency) {
                acctUpdateSql.append("    ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fendbalancefor endbalancefor, \r\n");
                acctUpdateSql.append("    ab.fyearpnlfor yearpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                acctUpdateSql.append("    ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fendbalancelocal endbalancelocal, \r\n");
                acctUpdateSql.append("    ab.fyearpnllocal yearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                acctUpdateSql.append("    ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fendbalancerpt endbalancerpt, \r\n");
                acctUpdateSql.append("    ab.fyearpnlrpt yearpnlrpt, \r\n");
            }
            acctUpdateSql.append("    ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty, ab.fendqty endqty, \r\n");
            acctUpdateSql.append("    ab.fyearpnlqty yearpnlqty \r\n");
            acctUpdateSql.append("    from ").append(T_AccountBalance).append(" ab where ab.").append(this.getOrgColumnNameB()).append("=? \r\n");
            acctUpdateSql.append("    and ab.fperiod=? \n");
            acctUpdateSql.append(") t \n");
            acctUpdateSql.append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n");
            acctUpdateSql.append("and accountid = faccountid \r\n");
            if (isForCurrency) {
                acctUpdateSql.append("and currencyid = fcurrencyid \r\n");
            }
            acctUpdateSql.append(" ) \r\n");
            acctUpdateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                acctUpdateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
        }
        if (logger.isDebugEnabled()) {
            GLBalanceFacadeControllerBean.logSql("transAccountBalance2", acctUpdateSql.toString(), new Object[]{companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)acctUpdateSql.toString(), (Object[])new Object[]{companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        StringBuffer asstInsertSql = new StringBuffer();
        asstInsertSql.append(" insert into ").append(T_AssistBalance).append("( \r\n");
        asstInsertSql.append("forgunitid, ").append(this.getOrgSelector()).append("faccountid, fassistgrpid, ");
        if (isForCurrency) {
            asstInsertSql.append("fcurrencyid, ");
        }
        asstInsertSql.append("fperiod \n");
        asstInsertSql.append(") \n");
        asstInsertSql.append(" select ab.forgunitid, ").append(this.getOrgSelector("ab")).append("ab.faccountid, ab.fassistgrpid, \r\n");
        if (isForCurrency) {
            asstInsertSql.append("ab.fcurrencyid, ");
        }
        asstInsertSql.append("? \n");
        asstInsertSql.append(" from ").append(T_AssistBalance).append(" ab \r\n").append(" where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
        asstInsertSql.append("    and ab.fperiod = ? \n");
        asstInsertSql.append(" and ( \r\n");
        if (isForCurrency) {
            asstInsertSql.append(" ab.fendbalancefor<>0 or ");
        }
        if (isLocaCurrency || isForCurrency) {
            asstInsertSql.append(" ab.fendbalancelocal<>0 or ");
        }
        if (isRptCurrency || isForCurrency) {
            asstInsertSql.append(" ab.fendbalancerpt<>0 or ");
        }
        asstInsertSql.append(" ab.fendqty<>0 ");
        if (!isNextYear) {
            if (isForCurrency) {
                asstInsertSql.append(" or ab.fyeardebitfor<>0 or ab.fyearcreditfor<>0 or ab.fyearpnlfor<>0 ");
            }
            if (isLocaCurrency || isForCurrency) {
                asstInsertSql.append(" or ab.fyeardebitlocal<>0 or ab.fyearcreditlocal<>0 or ab.fyearpnllocal<>0 ");
            }
            if (isRptCurrency || isForCurrency) {
                asstInsertSql.append(" or ab.fyeardebitrpt<>0 or ab.fyearcreditrpt<>0 or ab.fyearpnlrpt<>0 ");
            }
            asstInsertSql.append(" or ab.fyeardebitqty<>0 or ab.fyearcreditqty<>0 or isNull(ab.fyearpnlqty,0)<>0 ");
            asstInsertSql.append(" or isNull(ab.FDetailCount,0) <> 0 ");
        }
        asstInsertSql.append(") \r\n");
        if (acctIDs != null && !STRING.equals(acctIDs)) {
            asstInsertSql.append(" and ab.FAccountid in (").append(acctIDs).append(")       \r\n");
        }
        asstInsertSql.append(" and not exists ( \r\n");
        asstInsertSql.append("         select 1 from ").append(T_AssistBalance).append(" ab1 \r\n");
        asstInsertSql.append("        where ab1.").append(this.getOrgColumnNameB()).append("=ab.").append(this.getOrgColumnNameB()).append(" and ab1.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
        asstInsertSql.append("        and ab1.fperiod = ? \r\n");
        asstInsertSql.append("        and ab1.faccountid=ab.faccountid and ab1.fassistgrpid=ab.fassistgrpid \r\n");
        if (isForCurrency) {
            asstInsertSql.append("        and ab1.fcurrencyid=ab.fcurrencyid \n");
        }
        asstInsertSql.append("    ) \n");
        if (logger.isDebugEnabled()) {
            GLBalanceFacadeControllerBean.logSql("transAssistBalance1", asstInsertSql.toString(), new Object[]{nextPeriod.getNumber(), companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)asstInsertSql.toString(), (Object[])new Object[]{nextPeriod.getNumber(), companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        StringBuffer insertTempTabSQL = null;
        StringBuffer asstUpdateSql = new StringBuffer();
        if (isNextYear) {
            insertTempTabSQL = new StringBuffer("insert into ").append(assistTmp);
            insertTempTabSQL.append(" select ab.faccountid accountid, ab.fassistgrpid assistgrpid, \r\n");
            if (isForCurrency) {
                insertTempTabSQL.append("ab.fcurrencyid currencyid, \r\n");
            }
            if (isForCurrency) {
                insertTempTabSQL.append("ab.fendbalancefor endbalancefor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                insertTempTabSQL.append("ab.fendbalancelocal endbalancelocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                insertTempTabSQL.append("ab.fendbalancerpt endbalancerpt, \r\n");
            }
            insertTempTabSQL.append("ab.fendqty endqty \r\n");
            insertTempTabSQL.append("from ").append(T_AssistBalance).append(" ab \r\n").append("where ").append(this.getOrgColumnNameB()).append(" = ? \r\n").append("and fperiod = ? \r\n");
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                insertTempTabSQL.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            if (logger.isDebugEnabled()) {
                GLBalanceFacadeControllerBean.logSql("transAssistBalance2", insertTempTabSQL.toString(), new Object[]{companyID, currentPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)insertTempTabSQL.toString(), (Object[])new Object[]{companyID, currentPeriod.getNumber()});
            asstUpdateSql.append("update ").append(T_AssistBalance).append(" set ( \r\n");
            if (isForCurrency) {
                asstUpdateSql.append("fbeginbalancefor, fendbalancefor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstUpdateSql.append("fbeginbalancelocal, fendbalancelocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstUpdateSql.append("fbeginbalancerpt, fendbalancerpt, \r\n");
            }
            asstUpdateSql.append("fbeginqty, fendqty \r\n");
            asstUpdateSql.append(") = ( \r\n");
            asstUpdateSql.append("select \r\n");
            if (isForCurrency) {
                asstUpdateSql.append("endbalancefor, endbalancefor + fdebitfor - fcreditfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstUpdateSql.append("endbalancelocal, endbalancelocal + fdebitlocal - fcreditlocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstUpdateSql.append("endbalancerpt, endbalancerpt + fdebitrpt - fcreditrpt, \r\n");
            }
            asstUpdateSql.append("endqty, endqty + fdebitqty - fcreditqty \r\n");
            asstUpdateSql.append("from  \r\n");
            asstUpdateSql.append(assistTmp);
            asstUpdateSql.append("  t \r\n");
            asstUpdateSql.append("where \r\n");
            asstUpdateSql.append(" accountid = faccountid \r\n");
            asstUpdateSql.append("and assistgrpid = fassistgrpid \r\n");
            if (isForCurrency) {
                asstUpdateSql.append("and currencyid = fcurrencyid \r\n");
            }
            asstUpdateSql.append(" ) \r\n").append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                asstUpdateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
        } else {
            insertTempTabSQL = new StringBuffer("insert into ").append(assistTmp);
            insertTempTabSQL.append(" select ab.faccountid accountid, ab.fassistgrpid assistgrpid, \r\n");
            if (isForCurrency) {
                insertTempTabSQL.append("ab.fcurrencyid currencyid, \r\n");
            }
            if (isForCurrency) {
                insertTempTabSQL.append("ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fendbalancefor endbalancefor, \r\n");
                insertTempTabSQL.append("ab.fyearpnlfor yearpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                insertTempTabSQL.append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fendbalancelocal endbalancelocal, \r\n");
                insertTempTabSQL.append("ab.fyearpnllocal yearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                insertTempTabSQL.append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fendbalancerpt endbalancerpt, \r\n");
                insertTempTabSQL.append("ab.fyearpnlrpt yearpnlrpt, \r\n");
            }
            insertTempTabSQL.append("ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty, ab.fendqty endqty, \r\n");
            insertTempTabSQL.append("ab.fyearpnlqty yearpnlqty \r\n");
            insertTempTabSQL.append("from ").append(T_AssistBalance).append(" ab \r\n").append("where ").append(this.getOrgColumnNameB()).append(" = ? \r\n");
            insertTempTabSQL.append("and fperiod = ? \r\n");
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                insertTempTabSQL.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
            if (logger.isDebugEnabled()) {
                GLBalanceFacadeControllerBean.logSql("transAssistBalance2", insertTempTabSQL.toString(), new Object[]{companyID, currentPeriod.getNumber()});
            }
            DbUtil.execute((Context)ctx, (String)insertTempTabSQL.toString(), (Object[])new Object[]{companyID, currentPeriod.getNumber()});
            asstUpdateSql.append("update ").append(T_AssistBalance).append(" set ( \r\n");
            if (isForCurrency) {
                asstUpdateSql.append("fbeginbalancefor, fyeardebitfor, fyearcreditfor, fendbalancefor, \r\n");
                asstUpdateSql.append("fyearpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstUpdateSql.append("fbeginbalancelocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, \r\n");
                asstUpdateSql.append("fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstUpdateSql.append("fbeginbalancerpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, \r\n");
                asstUpdateSql.append("fyearpnlrpt, \r\n");
            }
            asstUpdateSql.append("fbeginqty, fyeardebitqty, fyearcreditqty, fendqty, \r\n");
            asstUpdateSql.append("fyearpnlqty \r\n");
            asstUpdateSql.append(") = ( \r\n");
            asstUpdateSql.append("select \r\n");
            if (isForCurrency) {
                asstUpdateSql.append("endbalancefor, yeardebitfor + fdebitfor, yearcreditfor + fcreditfor, endbalancefor + fdebitfor - fcreditfor, \r\n");
                asstUpdateSql.append("yearpnlfor + fmonthpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstUpdateSql.append("endbalancelocal, yeardebitlocal + fdebitlocal, yearcreditlocal + fcreditlocal, endbalancelocal + fdebitlocal - fcreditlocal, \r\n");
                asstUpdateSql.append("yearpnllocal + fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstUpdateSql.append("endbalancerpt, yeardebitrpt + fdebitrpt, yearcreditrpt + fcreditrpt, endbalancerpt + fdebitrpt - fcreditrpt, \r\n");
                asstUpdateSql.append("yearpnlrpt + fmonthpnlrpt, \r\n");
            }
            asstUpdateSql.append("endqty, yeardebitqty + fdebitqty, yearcreditqty + fcreditqty, endqty + fdebitqty - fcreditqty, \r\n");
            asstUpdateSql.append("isNull(yearpnlqty,0) + isNull(fmonthpnlqty,0) \r\n");
            asstUpdateSql.append("from  \r\n");
            asstUpdateSql.append(assistTmp);
            asstUpdateSql.append("  t \r\n");
            asstUpdateSql.append("where \r\n");
            asstUpdateSql.append(" accountid = faccountid \r\n");
            asstUpdateSql.append("and assistgrpid = fassistgrpid \r\n");
            if (isForCurrency) {
                asstUpdateSql.append("and currencyid = fcurrencyid \r\n");
            }
            asstUpdateSql.append(" ) \r\n").append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                asstUpdateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
        }
        if (logger.isDebugEnabled()) {
            GLBalanceFacadeControllerBean.logSql("transAssistBalance2", asstUpdateSql.toString(), new Object[]{companyID, nextPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)asstUpdateSql.toString(), (Object[])new Object[]{companyID, nextPeriod.getNumber()});
        StringBuffer asstMeasureInsertSql = new StringBuffer();
        asstMeasureInsertSql.append("insert into ").append(T_AssistMeasureBalance).append("( \r\n");
        asstMeasureInsertSql.append("forgunitid, ").append(this.getOrgSelector()).append("faccountid, fassistgrpid, fmeasureunitid, \n");
        if (isForCurrency) {
            asstMeasureInsertSql.append("fcurrencyid, \n");
        }
        asstMeasureInsertSql.append("fperiod \n");
        asstMeasureInsertSql.append(") \n");
        asstMeasureInsertSql.append("select ab.forgunitid, ").append(this.getOrgSelector("ab")).append("ab.faccountid, ab.fassistgrpid, ab.fmeasureunitid, \r\n");
        if (isForCurrency) {
            asstMeasureInsertSql.append("ab.fcurrencyid, ");
        }
        asstMeasureInsertSql.append("? \n");
        asstMeasureInsertSql.append(" from ").append(T_AssistMeasureBalance).append(" ab \r\n").append("where ab.").append(this.getOrgColumnNameB()).append(" = ? \r\n");
        asstMeasureInsertSql.append("    and ab.fperiod = ? \n");
        asstMeasureInsertSql.append(" and ( ");
        if (isForCurrency) {
            asstMeasureInsertSql.append(" ab.fendbalancefor<>0 or ");
        }
        if (isLocaCurrency || isForCurrency) {
            asstMeasureInsertSql.append(" ab.fendbalancelocal<>0 or ");
        }
        if (isRptCurrency || isForCurrency) {
            asstMeasureInsertSql.append(" ab.fendbalancerpt<>0 or ");
        }
        asstMeasureInsertSql.append(" ab.fendqty<>0 ");
        if (!isNextYear) {
            if (isForCurrency) {
                asstMeasureInsertSql.append(" or ab.fyeardebitfor<>0 or ab.fyearcreditfor<>0 or ab.fyearpnlfor<>0 ");
            }
            if (isLocaCurrency || isForCurrency) {
                asstMeasureInsertSql.append(" or ab.fyeardebitlocal<>0 or ab.fyearcreditlocal<>0 or ab.fyearpnllocal<>0 ");
            }
            if (isRptCurrency || isForCurrency) {
                asstMeasureInsertSql.append(" or ab.fyeardebitrpt<>0 or ab.fyearcreditrpt<>0 or ab.fyearpnlrpt<>0 ");
            }
            asstMeasureInsertSql.append(" or ab.fyeardebitqty<>0 or ab.fyearcreditqty<>0 or isNull(ab.fyearpnlqty,0)<>0 ");
            asstMeasureInsertSql.append(" or isNull(ab.FDetailCount,0) <> 0 ");
        }
        asstMeasureInsertSql.append(") \r\n");
        if (acctIDs != null && !STRING.equals(acctIDs)) {
            asstMeasureInsertSql.append(" and ab.FAccountid in (").append(acctIDs).append(")       \r\n");
        }
        asstMeasureInsertSql.append(" and not exists ( \r\n");
        asstMeasureInsertSql.append("        select 1 from ").append(T_AssistMeasureBalance).append(" ab1 \r\n");
        asstMeasureInsertSql.append("        where ab1.").append(this.getOrgColumnNameB()).append("=ab.").append(this.getOrgColumnNameB()).append(" and ab1.").append(this.getOrgColumnNameB()).append("= ? \r\n");
        asstMeasureInsertSql.append("        and ab1.fperiod = ? \r\n");
        asstMeasureInsertSql.append("        and ab1.faccountid=ab.faccountid and ab1.fassistgrpid=ab.fassistgrpid and ab1.fmeasureunitid=ab.fmeasureunitid \r\n");
        if (isForCurrency) {
            asstMeasureInsertSql.append("        and ab1.fcurrencyid=ab.fcurrencyid \r\n");
        }
        asstMeasureInsertSql.append("    ) \n");
        if (logger.isDebugEnabled()) {
            GLBalanceFacadeControllerBean.logSql("transMeasureBalance1", asstMeasureInsertSql.toString(), new Object[]{nextPeriod.getNumber(), companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)asstMeasureInsertSql.toString(), (Object[])new Object[]{nextPeriod.getNumber(), companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        StringBuffer asstMeasureUpdateSql = new StringBuffer();
        if (isNextYear) {
            asstMeasureUpdateSql.append("update ").append(T_AssistMeasureBalance).append(" set ( \r\n");
            if (isForCurrency) {
                asstMeasureUpdateSql.append("fbeginbalancefor, fendbalancefor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("fbeginbalancelocal, fendbalancelocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("fbeginbalancerpt, fendbalancerpt, \r\n");
            }
            asstMeasureUpdateSql.append("fbeginqty, fendqty \r\n");
            asstMeasureUpdateSql.append(") = ( \r\n");
            asstMeasureUpdateSql.append("select \r\n");
            if (isForCurrency) {
                asstMeasureUpdateSql.append("endbalancefor, endbalancefor + fdebitfor - fcreditfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("endbalancelocal, endbalancelocal + fdebitlocal - fcreditlocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("endbalancerpt, endbalancerpt + fdebitrpt - fcreditrpt, \r\n");
            }
            asstMeasureUpdateSql.append("endqty, endqty + fdebitqty - fcreditqty \r\n");
            asstMeasureUpdateSql.append("from ( \r\n");
            asstMeasureUpdateSql.append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", \r\n");
            asstMeasureUpdateSql.append("ab.fperiod period, ab.faccountid accountid, ab.fassistgrpid assistgrpid, ab.fmeasureunitid measureunitid, \r\n");
            if (isForCurrency) {
                asstMeasureUpdateSql.append("ab.fcurrencyid currencyid, \r\n");
            }
            if (isForCurrency) {
                asstMeasureUpdateSql.append("ab.fendbalancefor endbalancefor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("ab.fendbalancelocal endbalancelocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("ab.fendbalancerpt endbalancerpt, \r\n");
            }
            asstMeasureUpdateSql.append("ab.fendqty endqty \r\n");
            asstMeasureUpdateSql.append("from ").append(T_AssistMeasureBalance).append(" ab where ab.").append(this.getOrgColumnNameB()).append("=? \r\n");
            asstMeasureUpdateSql.append(" and ab.fperiod=? ) t \r\n").append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n").append("and accountid = faccountid \r\n").append("and assistgrpid = fassistgrpid \r\n").append("and measureunitid = fmeasureunitid \r\n");
            if (isForCurrency) {
                asstMeasureUpdateSql.append("and currencyid = fcurrencyid \r\n");
            }
            asstMeasureUpdateSql.append(" ) \r\n").append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                asstMeasureUpdateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
        } else {
            asstMeasureUpdateSql.append("update ").append(T_AssistMeasureBalance).append(" set ( \r\n");
            if (isForCurrency) {
                asstMeasureUpdateSql.append("fbeginbalancefor, fyeardebitfor, fyearcreditfor, fendbalancefor, fyearpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("fbeginbalancelocal, fyeardebitlocal, fyearcreditlocal, fendbalancelocal, fyearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("fbeginbalancerpt, fyeardebitrpt, fyearcreditrpt, fendbalancerpt, fyearpnlrpt, \r\n");
            }
            asstMeasureUpdateSql.append("fbeginqty, fyeardebitqty, fyearcreditqty, fendqty, fyearpnlqty \r\n");
            asstMeasureUpdateSql.append(") = ( \r\n");
            asstMeasureUpdateSql.append("select \r\n");
            if (isForCurrency) {
                asstMeasureUpdateSql.append("endbalancefor, yeardebitfor + fdebitfor, yearcreditfor + fcreditfor, endbalancefor + fdebitfor - fcreditfor, yearpnlfor + fmonthpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("endbalancelocal, yeardebitlocal + fdebitlocal, yearcreditlocal + fcreditlocal, endbalancelocal + fdebitlocal - fcreditlocal, yearpnllocal + fmonthpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("endbalancerpt, yeardebitrpt + fdebitrpt, yearcreditrpt + fcreditrpt, endbalancerpt + fdebitrpt - fcreditrpt, yearpnlrpt + fmonthpnlrpt, \r\n");
            }
            asstMeasureUpdateSql.append("endqty, yeardebitqty + fdebitqty, yearcreditqty + fcreditqty, endqty + fdebitqty - fcreditqty, isNull(yearpnlqty,0) + isNull(fmonthpnlqty,0) \r\n");
            asstMeasureUpdateSql.append("from ( \r\n");
            asstMeasureUpdateSql.append("select ab.").append(this.getOrgColumnNameB()).append(" ").append(this.getOrgColumnNameBV()).append(", \r\n");
            asstMeasureUpdateSql.append("ab.fperiod period, ab.faccountid accountid, ab.fassistgrpid assistgrpid, ab.fmeasureunitid measureunitid, \r\n");
            if (isForCurrency) {
                asstMeasureUpdateSql.append("ab.fcurrencyid currencyid, \r\n");
            }
            if (isForCurrency) {
                asstMeasureUpdateSql.append("ab.fyeardebitfor yeardebitfor, ab.fyearcreditfor yearcreditfor, ab.fendbalancefor endbalancefor, ab.fyearpnlfor yearpnlfor, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("ab.fyeardebitlocal yeardebitlocal, ab.fyearcreditlocal yearcreditlocal, ab.fendbalancelocal endbalancelocal, ab.fyearpnllocal yearpnllocal, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                asstMeasureUpdateSql.append("ab.fyeardebitrpt yeardebitrpt, ab.fyearcreditrpt yearcreditrpt, ab.fendbalancerpt endbalancerpt, ab.fyearpnlrpt yearpnlrpt, \r\n");
            }
            asstMeasureUpdateSql.append("ab.fyeardebitqty yeardebitqty, ab.fyearcreditqty yearcreditqty, ab.fendqty endqty, ab.fyearpnlqty yearpnlqty \r\n");
            asstMeasureUpdateSql.append("from ").append(T_AssistMeasureBalance).append(" ab where ab.").append(this.getOrgColumnNameB()).append("=? \r\n");
            asstMeasureUpdateSql.append("and ab.fperiod=? ) t \r\n");
            asstMeasureUpdateSql.append("where ").append(this.getOrgColumnNameBV()).append(" = ").append(this.getOrgColumnNameB()).append(" \r\n");
            asstMeasureUpdateSql.append("and accountid = faccountid \r\n");
            asstMeasureUpdateSql.append("and assistgrpid = fassistgrpid \r\n");
            asstMeasureUpdateSql.append("and measureunitid = fmeasureunitid \r\n");
            if (isForCurrency) {
                asstMeasureUpdateSql.append("and currencyid = fcurrencyid \r\n");
            }
            asstMeasureUpdateSql.append(" ) \r\n");
            asstMeasureUpdateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
            if (acctIDs != null && !STRING.equals(acctIDs)) {
                asstMeasureUpdateSql.append(" and FAccountid in (").append(acctIDs).append(")       \r\n");
            }
        }
        if (logger.isDebugEnabled()) {
            GLBalanceFacadeControllerBean.logSql("transMeasureBalance2", asstMeasureUpdateSql.toString(), new Object[]{companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)asstMeasureUpdateSql.toString(), (Object[])new Object[]{companyID, currentPeriod.getNumber(), companyID, nextPeriod.getNumber()});
    }

    @Override
    protected void _antiTransBalanceToPrevPeriod(Context ctx, String companyID, String currentPeriodID) throws BOSException {
        this.afterAntiTransBalanceToPrevPeriod(ctx, companyID, currentPeriodID);
    }

    protected void doAntiTransBalanceToPrevPeriod(Context ctx, String companyID, PeriodInfo currentPeriod, int balanceType, int balType, String currencyId) throws BOSException {
        String table = this.getBalanceTable(balanceType, balType, currencyId);
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update ").append(table).append(" set \r\n");
        if (isForCurrency) {
            updateSql.append("fbeginbalancefor = 0.0, fyeardebitfor = fdebitfor, fyearcreditfor = fcreditfor, fendbalancefor = fdebitfor - fcreditfor, \r\n");
            updateSql.append("fyearpnlfor = fmonthpnlfor, \r\n");
        }
        if (isLocaCurrency || isForCurrency) {
            updateSql.append("fbeginbalancelocal = 0.0, fyeardebitlocal = fdebitlocal, fyearcreditlocal = fcreditlocal, fendbalancelocal = fdebitlocal - fcreditlocal, \r\n");
            updateSql.append("fyearpnllocal = fmonthpnllocal, \r\n");
        }
        if (isRptCurrency || isForCurrency) {
            updateSql.append("fbeginbalancerpt = 0.0, fyeardebitrpt = fdebitrpt, fyearcreditrpt = fcreditrpt, fendbalancerpt = fdebitrpt - fcreditrpt, \r\n");
            updateSql.append("fyearpnlrpt = fmonthpnlrpt, \r\n");
        }
        updateSql.append("fbeginqty = 0.0, fyeardebitqty = fdebitqty, fyearcreditqty = fcreditqty, fendqty = fdebitqty - fcreditqty, \r\n");
        updateSql.append("fyearpnlqty = isNull(fmonthpnlqty,0), \r\n");
        updateSql.append("where ").append(this.getOrgColumnNameB()).append(" = ? and fperiod = ? \r\n");
        if (logger.isDebugEnabled()) {
            GLBalanceFacadeControllerBean.logSql("antiTransBalance", updateSql.toString(), new Object[]{companyID, currentPeriod.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{companyID, currentPeriod.getNumber()});
    }

    protected void afterAntiTransBalanceToPrevPeriod(Context ctx, String companyID, String currentPeriodID) throws BOSException {
        PeriodInfo prePeriod = null;
        try {
            prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(currentPeriodID));
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        if (prePeriod != null) {
            FIClosingCenterFacadeFactory.getLocalInstance((Context)ctx).taskExecutionRecord(companyID, "YxDBp4PaQEe3UWEr9OKHjM4XzhY=", prePeriod.getId().toString(), true);
        }
    }

    @Override
    protected void _transBalanceToNextYear(Context ctx, String companyID, String fromPeriodID, String toPeriodID, String acctIDs) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select pd.fid,pd.fperiodyear from t_bd_period pd ");
        sql.append(" inner join t_bd_period fpd on pd.ftypeid = fpd.ftypeid and fpd.fid = ? ");
        sql.append(" inner join t_bd_period tpd on pd.ftypeid = tpd.ftypeid and tpd.fid = ? ");
        sql.append(" inner join t_org_company cp on cp.fid = ? and cp.faccountperiodid = pd.ftypeid ");
        sql.append(" where pd.fnumber >= fpd.fnumber and pd.fnumber <= tpd.fnumber");
        sql.append(" order by pd.fnumber");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{fromPeriodID, toPeriodID, companyID});
        if (rs.size() < 2) {
            return;
        }
        try {
            rs.next();
            String fromPeriodId = rs.getString("fid");
            int fromPeriodYear = rs.getInt("fperiodyear");
            String toPeriodId = null;
            int toPeriodYear = -1;
            while (rs.next()) {
                toPeriodId = rs.getString("fid");
                toPeriodYear = rs.getInt("fperiodyear");
                this._transBalanceToNextPeriod(ctx, companyID, fromPeriodId, toPeriodId, fromPeriodYear < toPeriodYear, acctIDs);
                GLAsstAccountChangeTransfer.process(ctx, companyID, toPeriodId);
                new GLBalanceFacadeControllerBean()._doUpdateVoucherBalance(ctx, new String[]{companyID});
                fromPeriodId = toPeriodId;
                fromPeriodYear = toPeriodYear;
            }
        }
        catch (SQLException ex) {
            throw new BOSException("SQL ERROR!", (Throwable)ex);
        }
    }

    protected static void logSql(String name, String sql, Object[] params) {
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("GLBalance: ").append(name).append("\r\n").append("sql: ").append(sql).append("\r\n");
            for (int i = 0; i < params.length; ++i) {
                sb.append("param").append(i).append(":[").append(params[i]).append("]; ");
            }
            logger.debug((Object)sb.toString());
        }
    }

    @Override
    protected void _fillTransaction(Context ctx, String[] companyIds) throws BOSException {
        String cpStrIds = null;
        if (companyIds != null && companyIds.length > 0) {
            cpStrIds = this.listId2StrId(companyIds);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select cp.fid from " + this.getOrgTable() + " cp ");
        if (cpStrIds != null) {
            sql.append(" where cp.fid in (" + cpStrIds + ") and ");
        } else {
            sql.append(" where ");
        }
        sql.append(" not exists (select 1 from t_bas_transaction t where t.fid = cp.fid and t.fnumber = 'updatebalance' and t.fsystype = " + this.getSystemTypeValue() + ")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                StringBuffer insertSql = new StringBuffer();
                insertSql.append(" insert into t_bas_transaction(fid,fsystype,fnumber,fupdatetime,ftimecount,fisupdating) ");
                insertSql.append(" select cp.fid," + this.getSystemTypeValue() + " fsystype,'updatebalance' fnumber, getDate() fupdatetime,0 ftimecount,0 fisupdating ");
                insertSql.append(" from " + this.getOrgTable() + " cp ");
                if (cpStrIds != null) {
                    insertSql.append(" where cp.fid in (" + cpStrIds + ") and ");
                } else {
                    insertSql.append(" where ");
                }
                insertSql.append(" not exists (select 1 from t_bas_transaction t where t.fid = cp.fid and t.fnumber = 'updatebalance' and t.fsystype = " + this.getSystemTypeValue() + ")");
                DbUtil.execute((Context)ctx, (String)insertSql.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
    }

    private BalanceCalInfo getUpdateStatus(Context ctx, String companyIds, Map initStatusMap, Map lastStatusMap) throws BOSException {
        HashMap statusMap = new HashMap();
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            rs = statement.executeQuery("select fid, ftimecount, fisupdating, fupdatetime, getDate() curTime from t_bas_transaction where fid in (" + companyIds + ") and fnumber = 'updatebalance' and fsystype = " + this.getSystemTypeValue());
            while (rs.next()) {
                this.setUpdateStatus(ctx, statusMap, initStatusMap, rs);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException("SQL ERROR!", (Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return this.buildBalanceCalStatus(statusMap);
    }

    protected BalanceCalInfo buildBalanceCalStatus(Map statusMap) {
        BalanceCalInfo result = new BalanceCalInfo();
        for (String companyId : statusMap.keySet()) {
            Object[] status = (Object[])statusMap.get(companyId);
            if (status[2] != null && status[2] != NO_UPDATE) continue;
            if ((Integer)status[0] == 1) {
                result.setCalStatus(1);
                return result;
            }
            result.addCompanyId(companyId);
        }
        if (result.getCompanyIds() == null || result.getCompanyIds().length == 0) {
            result.setCalStatus(2);
        } else {
            result.setCalStatus(0);
        }
        result.setStatusMap(statusMap);
        return result;
    }

    private void setUpdateStatus(Context ctx, Map statusMap, Map initStatusMap, ResultSet rs) throws SQLException, BOSException {
        Object[] initStatus = (Object[])initStatusMap.get(rs.getString("fid"));
        Object[] status = new Object[3];
        int isUpdating = rs.getInt("fisupdating");
        Timestamp lastUpdateTime = rs.getTimestamp("fupdatetime");
        Timestamp currTime = rs.getTimestamp("curTime");
        if (isUpdating == 1 && currTime.getTime() - lastUpdateTime.getTime() > 300000L) {
            GLBalanceFacadeFactory.getLocalInstance(ctx).unLockCalBalance(new String[]{rs.getString("fid")});
            isUpdating = 0;
        }
        int timecount = rs.getInt("ftimecount");
        status[0] = Integer.valueOf(isUpdating + STRING);
        status[1] = Integer.valueOf(timecount + STRING);
        if (initStatus == null) {
            status[2] = NO_UPDATE;
            initStatusMap.put(rs.getString("fid"), status);
        } else {
            int initTimeCount = (Integer)initStatus[1];
            if (timecount - initTimeCount >= 2 || timecount < initTimeCount && timecount + 10000 - initTimeCount >= 2 || timecount - initTimeCount == 1 && isUpdating == 0) {
                status[2] = UPDATED;
            }
        }
        statusMap.put(rs.getString("fid"), status);
    }

    protected String[] getNeedUpdateCompanys(Context ctx, String[] companyIds) throws BOSException {
        if (companyIds.length == 0) {
            return null;
        }
        String strCpIds = this.listId2StrId(companyIds);
        HashMap initStatusMap = new HashMap();
        Map lastStatus = null;
        while (true) {
            BalanceCalInfo info;
            if ((info = this.getUpdateStatus(ctx, strCpIds, initStatusMap, lastStatus)).getCalStatus() == 0) {
                companyIds = info.getCompanyIds();
                try {
                    GLBalanceFacadeFactory.getLocalInstance(ctx).lockCalBalance(companyIds);
                }
                catch (BOSException ex) {
                    if (BalUpdateCt.equals(ex.getMessage())) {
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new BOSException("DBLock error!", (Throwable)e);
                        }
                    }
                    throw new BOSException("SQL ERROR!", (Throwable)ex);
                }
                return companyIds;
            }
            if (info.getCalStatus() == 2) {
                return null;
            }
            lastStatus = info.getStatusMap();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new BOSException("DBFinalLock error!", (Throwable)e);
            }
        }
    }

    @Override
    protected void _lockCalBalance(Context ctx, String[] companyIds) throws BOSException {
        String strCpIds = this.listId2StrId(companyIds);
        String sql = "update t_bas_transaction set fupdateTime = getDate(), ftimecount = case when ftimecount >= 9999 then 0 else ftimecount + 1 end, fisupdating=1 where fnumber = 'updatebalance' and fsystype = " + this.getSystemTypeValue() + " and fisupdating=0 ";
        if (companyIds != null && companyIds.length > 0) {
            sql = sql + " and fid in (" + strCpIds + ")";
        }
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            int updateCount = ps.executeUpdate();
            if (updateCount != companyIds.length) {
                throw new BOSException(BalUpdateCt);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException("SQL ERROR!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    @Override
    protected void _unLockCalBalance(Context ctx, String[] companyIds) throws BOSException {
        String strCpIds = this.listId2StrId(companyIds);
        String sql = "update t_bas_transaction set fisupdating = 0 where fnumber = 'updatebalance' and fsystype = " + this.getSystemTypeValue();
        if (strCpIds != null && strCpIds.length() > 0) {
            sql = sql + " and fid in (" + strCpIds + ")";
        }
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected String getAssistBalanceTempTable(Context ctx, boolean isNextYear) throws Exception {
        StringBuffer sql = new StringBuffer();
        if (isNextYear) {
            sql.append(" create table T_GL_CurAssistBALANCETMPTABLE ");
            sql.append(" (");
            sql.append(" BALTYPE           INT,");
            sql.append(" ACCOUNTID         VARCHAR(44),");
            sql.append(" ASSISTGRPID       VARCHAR(44),");
            sql.append(" CURRENCYID        VARCHAR(44),");
            sql.append(" ENDBALANCEFOR          NUMERIC(19,4) DEFAULT 0,");
            sql.append(" ENDBALANCELOCAL         NUMERIC(19,4) DEFAULT 0,");
            sql.append(" ENDBALANCERPT        NUMERIC(19,4) DEFAULT 0,");
            sql.append(" ENDQTY       NUMERIC(19,4) DEFAULT 0");
            sql.append(")");
        } else {
            sql.append(" create table T_GL_CurAssistBALANCETMPTABLE ");
            sql.append(" (");
            sql.append(" BALTYPE           INT,");
            sql.append(" ACCOUNTID         VARCHAR(44),");
            sql.append(" ASSISTGRPID       VARCHAR(44),");
            sql.append(" CURRENCYID        VARCHAR(44),");
            sql.append(" YEARDEBITFOR          NUMERIC(19,4) DEFAULT 0,");
            sql.append(" YEARCREDITFOR         NUMERIC(19,4) DEFAULT 0,");
            sql.append(" ENDBALANCEFOR        NUMERIC(19,4) DEFAULT 0,");
            sql.append(" YEARDEBITLOCAL       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" YEARCREDITLOCAL       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" ENDBALANCELOCAL       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" YEARDEBITRPT       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" YEARCREDITRPT       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" ENDBALANCERPT       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" YEARPNLFOR       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" YEARPNLLOCAL       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" YEARPNLRPT       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" YEARDEBITQTY       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" YEARCREDITQTY       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" ENDQTY       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" YEARPNLQTY       NUMERIC(19,4) DEFAULT 0");
            sql.append(")");
        }
        String tmpTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        try {
            TempTablePool.getInstance((Context)ctx).createIndex(tmpTableName, "accountid, currencyid, assistgrpid, baltype", false, false);
        }
        catch (Exception e) {
            logger.error((Object)"Update assist temp balance create index error!", (Throwable)e);
        }
        return tmpTableName;
    }

    private String getTempTableName(Context ctx, String name, String struct) throws BOSException {
        String csName = this.getClass().getName();
        name = csName.substring(csName.lastIndexOf(".") + 1) + name;
        String createTableSql = "create table " + name + " (" + struct + ")";
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
        }
        catch (Exception e) {
            throw new BOSException("create tempTable error!", (Throwable)e);
        }
    }

    private void releaseTempTableName(Context ctx, String tableName) {
        TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
    }

    private static void insertTempTable(Context ctx, String[] cpIds, String tableName) throws BOSException {
        Connection conn = null;
        PreparedStatement stmt = null;
        String tempSql = "insert into " + tableName + "(ORGID) values(?)";
        Set<String> cpIdSet = GLBalanceFacadeControllerBean.Array2Set(cpIds);
        if (STRING.equals(tableName) || null == tableName) {
            return;
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(tempSql);
            Iterator<String> it = cpIdSet.iterator();
            while (it.hasNext()) {
                stmt.setString(1, it.next().toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                if (tableName != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
                }
                throw new BOSException("SQL error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    public static <T> Set<T> Array2Set(T[] tArray) {
        HashSet<T> tSet = new HashSet<T>(Arrays.asList(tArray));
        return tSet;
    }

    protected String getAssistBalanceTempTable(Context ctx, boolean isNextYear, String currencyId) throws BOSException {
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        if (isNextYear) {
            sql.append(" create table T_GL_CurAssistBALANCETMPTABLE ");
            sql.append(" (");
            sql.append(" ACCOUNTID         VARCHAR(44),");
            sql.append(" ASSISTGRPID       VARCHAR(44),");
            if (isForCurrency) {
                sql.append(" CURRENCYID        VARCHAR(44),");
            }
            if (isForCurrency) {
                sql.append(" ENDBALANCEFOR          NUMERIC(19,4) DEFAULT 0,");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append(" ENDBALANCELOCAL         NUMERIC(19,4) DEFAULT 0,");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append(" ENDBALANCERPT        NUMERIC(19,4) DEFAULT 0,");
            }
            sql.append(" ENDQTY       NUMERIC(19,4) DEFAULT 0");
            sql.append(")");
        } else {
            sql.append(" create table T_GL_CurAssistBALANCETMPTABLE ");
            sql.append(" (");
            sql.append(" ACCOUNTID         VARCHAR(44),");
            sql.append(" ASSISTGRPID       VARCHAR(44),");
            if (isForCurrency) {
                sql.append(" CURRENCYID        VARCHAR(44),");
            }
            if (isForCurrency) {
                sql.append(" YEARDEBITFOR          NUMERIC(19,4) DEFAULT 0,");
                sql.append(" YEARCREDITFOR         NUMERIC(19,4) DEFAULT 0,");
                sql.append(" ENDBALANCEFOR        NUMERIC(19,4) DEFAULT 0,");
                sql.append(" YEARPNLFOR       NUMERIC(19,4) DEFAULT 0,");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append(" YEARDEBITLOCAL       NUMERIC(19,4) DEFAULT 0,");
                sql.append(" YEARCREDITLOCAL       NUMERIC(19,4) DEFAULT 0,");
                sql.append(" ENDBALANCELOCAL       NUMERIC(19,4) DEFAULT 0,");
                sql.append(" YEARPNLLOCAL       NUMERIC(19,4) DEFAULT 0,");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append(" YEARDEBITRPT       NUMERIC(19,4) DEFAULT 0,");
                sql.append(" YEARCREDITRPT       NUMERIC(19,4) DEFAULT 0,");
                sql.append(" ENDBALANCERPT       NUMERIC(19,4) DEFAULT 0,");
                sql.append(" YEARPNLRPT       NUMERIC(19,4) DEFAULT 0,");
            }
            sql.append(" YEARDEBITQTY       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" YEARCREDITQTY       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" ENDQTY       NUMERIC(19,4) DEFAULT 0,");
            sql.append(" YEARPNLQTY       NUMERIC(19,4) DEFAULT 0");
            sql.append(")");
        }
        String tmpTableName = null;
        try {
            tmpTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException("Create assist temp balance error!", (Throwable)e);
        }
        try {
            String indexColumns = "accountid, assistgrpid";
            if (isForCurrency) {
                indexColumns = indexColumns + ", currencyid";
            }
            TempTablePool.getInstance((Context)ctx).createIndex(tmpTableName, indexColumns, true, false);
        }
        catch (Exception e) {
            logger.error((Object)"Update assist temp balance create index error!", (Throwable)e);
        }
        return tmpTableName;
    }

    protected String getBalanceTable(int balanceType, int balType, String currencyId) {
        return GLBalanceUtils.getBalanceTable(balanceType, balType, currencyId);
    }

    protected String getVoucherLogTable() {
        return T_GL_VOUCHERLOG;
    }

    protected String getOrgColumnName() {
        return FCOMPANYID;
    }

    protected String getOrgColumnNameB() {
        return FORGUNITID;
    }

    protected String getOrgColumnNameBV() {
        return ORGUNITID;
    }

    protected String getOrgTable() {
        return T_ORG_COMPANY;
    }

    protected String getOrgSelector() {
        return STRING;
    }

    protected String getOrgSelector(String tableAlias) {
        return STRING;
    }

    protected String getOrgSelectorV() {
        return STRING;
    }

    protected String getOrgSelectorV(String tableAlias) {
        return STRING;
    }

    protected String getVoucherTable() {
        return T_GL_VOUCHER;
    }

    protected String getVoucherEntryTable() {
        return T_GL_VOUCHERENTRY;
    }

    protected String getVoucherAssRecTable() {
        return T_GL_VOUCHERASSISTRECORD;
    }

    protected String getInitAccountBalanceTable() {
        return T_GL_INITACCOUNTBALANCE;
    }

    protected String getInitAssistBalanceTable() {
        return T_GL_INITASSISTBALANCE;
    }

    protected int getSystemTypeValue() {
        return 6;
    }

    protected boolean isPca() {
        return false;
    }

    private void _calc(Context ctx, Set orgUnitIds, Map params) throws BOSException {
        Object lockCo;
        if (6 == this.getSystemTypeValue() && (lockCo = params.get("GL_BalUpd_LockCo")) != null && "true".equalsIgnoreCase(lockCo.toString())) {
            StringBuffer sql = new StringBuffer();
            sql.append("insert into T_GL_LockBalance(FID, FUpdateTime, FTimeCount) \n");
            sql.append("select c.FID, getDate() FUpdateTime, 0 FTimeCount \n");
            sql.append("from " + this.getOrgTable() + " c \n");
            sql.append("where c.FID = ? \n");
            sql.append("and not exists ( \n");
            sql.append("  select 1 from T_GL_LockBalance t where t.FID = ? \n");
            sql.append(") \n");
            for (Object orgUnitId : orgUnitIds) {
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgUnitId, orgUnitId});
            }
        }
        for (Object orgUnitId : orgUnitIds) {
            GLBalanceFacadeFactory.getLocalInstance(ctx).doCalc((String)orgUnitId, params);
        }
    }

    private Map<String, Object> getCalcParams(Context ctx) throws BOSException {
        HashMap<String, Object> ins = new HashMap<String, Object>();
        ins.put("G001", null);
        ins.put("G010", null);
        ins.put("GL_BalUpd_LockCo", null);
        HashMap<String, Object> outs = null;
        try {
            outs = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(ins);
            if (outs == null) {
                outs = new HashMap<String, Object>();
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        if (!outs.containsKey("GL_BalUpd_LockCo")) {
            outs.put("GL_BalUpd_LockCo", "false");
        }
        outs.put("isArchiveVoucherLog", GLBalanceFacadeControllerBean.isArchiveVoucherLog(ctx));
        return outs;
    }

    @Override
    protected void _doCalc(Context ctx, String orgUnitId, Map params) throws BOSException {
        if (orgUnitId == null || orgUnitId.trim().length() == 0) {
            return;
        }
        orgUnitId = orgUnitId.trim();
        params.put("orgUnitId", orgUnitId);
        if (!(params.containsKey("G001") && params.containsKey("G010") && params.containsKey("isArchiveVoucherLog") && params.containsKey("GL_BalUpd_LockCo"))) {
            params.putAll(this.getCalcParams(ctx));
        }
        String tempTable = null;
        try {
            String calculateId = BOSUuid.create((String)"ABCD1234").toString();
            tempTable = this.createVoucherBalanceTempTable(ctx);
            if (tempTable == null) {
                return;
            }
            StringBuffer sql = new StringBuffer();
            boolean isMSSQLSERVER = SQLUtil.isMSSQLSERVER(ctx);
            if (isMSSQLSERVER) {
                sql.append("/*dialect*/ ");
            }
            sql.append("update " + this.getVoucherLogTable());
            if (isMSSQLSERVER) {
                sql.append(" with(readpast)");
            }
            sql.append(" set fisupdating = 1");
            if (6 == this.getSystemTypeValue()) {
                sql.append(", FCalculateID = ?");
            }
            sql.append(" where fisupdating = 0 ");
            sql.append(" and ").append(this.getOrgColumnName()).append(" = ?");
            Object[] ps = 6 == this.getSystemTypeValue() ? new String[]{calculateId, orgUnitId} : new String[]{orgUnitId};
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])ps);
            this.insertVoucherBalance(ctx, tempTable, params, "'" + orgUnitId + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select top 1 1 from " + tempTable));
            if (rs.next()) {
                if (6 == this.getSystemTypeValue()) {
                    Object lockCo;
                    if (((Boolean)params.get("isArchiveVoucherLog")).booleanValue()) {
                        this.archiveCalData(ctx, tempTable, calculateId);
                    }
                    if ((lockCo = params.get("GL_BalUpd_LockCo")) != null && "true".equalsIgnoreCase(lockCo.toString())) {
                        sql.setLength(0);
                        sql.append("update T_GL_LockBalance set FUpdateTime = getdate(), \n");
                        sql.append("  FTimeCount = case when ftimecount >= 9999 then 0 else ftimecount + 1 end \n");
                        sql.append("where FID = ?");
                        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{orgUnitId});
                    }
                }
                this.updateBalanceRecord(ctx, tempTable, params, 1);
                this.updateBalanceRecord(ctx, tempTable, params, 2);
                boolean isAsstQty = Boolean.valueOf(params.get("G010").toString());
                if (isAsstQty) {
                    this.updateBalanceRecord(ctx, tempTable, params, 3);
                }
            }
            this.disableVoucherLog(ctx, new String[]{orgUnitId}, calculateId);
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (tempTable != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Update voucher balance release temptable error!", (Throwable)e);
            }
        }
    }

    public class BalanceCalInfo {
        public static final int CONTINUE = 0;
        public static final int WAIT = 1;
        public static final int RETURN = 2;
        int calStatus = 0;
        Set companyIdSet = new HashSet();
        Map statusMap = null;

        public int getCalStatus() {
            return this.calStatus;
        }

        public void setCalStatus(int calStatus) {
            this.calStatus = calStatus;
        }

        public String[] getCompanyIds() {
            if (this.companyIdSet == null || this.companyIdSet.size() == 0) {
                return null;
            }
            String[] companyIds = new String[this.companyIdSet.size()];
            return this.companyIdSet.toArray(companyIds);
        }

        public Map getStatusMap() {
            return this.statusMap;
        }

        public void addCompanyId(String companyId) {
            this.companyIdSet.add(companyId);
        }

        public void setStatusMap(Map statusMap) {
            this.statusMap = statusMap;
        }
    }

    class transBalanceCallable
    implements Callable<Object>,
    TransactionInvoker {
        Context ctx;
        String companyID;
        PeriodInfo currPeriodInfo;
        PeriodInfo nextPeriodInfo;
        boolean isNextYear;
        String acctIDs;
        int baltype;
        String currencyId;

        transBalanceCallable(Context ctx, String companyID, PeriodInfo currPeriodInfo, PeriodInfo nextPeriodInfo, boolean isNextYear, String acctIDs, int baltype, String currencyId) {
            this.ctx = ctx;
            this.companyID = companyID;
            this.currPeriodInfo = currPeriodInfo;
            this.nextPeriodInfo = nextPeriodInfo;
            this.isNextYear = isNextYear;
            this.acctIDs = acctIDs;
            this.baltype = baltype;
            this.currencyId = currencyId;
        }

        @Override
        public Object call() throws Exception {
            HashMap<String, transBalanceCallable> invokeParams = new HashMap<String, transBalanceCallable>();
            invokeParams.put("invoker", this);
            return TransactionFacadeFactory.getLocalInstance(this.ctx).mRequiresNew(invokeParams);
        }

        @Override
        public Object invoke(Context ctx, Map invokeParams) throws BOSException, EASBizException {
            Object[] params = new Object[]{this.companyID, this.currPeriodInfo.getNumber(), this.nextPeriodInfo.getNumber(), this.nextPeriodInfo.getNumber()};
            DbUtil.execute((Context)ctx, (String)GLBalanceFacadeControllerBean.this.getBalanceToNextPeriodOracleSQL(this.isNextYear, 1, this.baltype, this.currencyId, this.acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)GLBalanceFacadeControllerBean.this.getBalanceToNextPeriodOracleSQL(this.isNextYear, 2, this.baltype, this.currencyId, this.acctIDs), (Object[])params);
            DbUtil.execute((Context)ctx, (String)GLBalanceFacadeControllerBean.this.getBalanceToNextPeriodOracleSQL(this.isNextYear, 3, this.baltype, this.currencyId, this.acctIDs), (Object[])params);
            if (!this.isNextYear) {
                params = new Object[]{this.companyID, this.nextPeriodInfo.getNumber(), this.currPeriodInfo.getNumber()};
                DbUtil.execute((Context)ctx, (String)GLBalanceFacadeControllerBean.this.getZeroBalanceToNextPeriodSQL(1, this.baltype, this.currencyId, this.acctIDs), (Object[])params);
                DbUtil.execute((Context)ctx, (String)GLBalanceFacadeControllerBean.this.getZeroBalanceToNextPeriodSQL(2, this.baltype, this.currencyId, this.acctIDs), (Object[])params);
                DbUtil.execute((Context)ctx, (String)GLBalanceFacadeControllerBean.this.getZeroBalanceToNextPeriodSQL(3, this.baltype, this.currencyId, this.acctIDs), (Object[])params);
            }
            return null;
        }
    }
}

