/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceAnaFacadeFactory;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GLBalanceRepairFacadeFactory;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.app.AbstractGLBalanceRepairFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.GLBalanceRepairer;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLBalanceRepairFacadeControllerBean
extends AbstractGLBalanceRepairFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLBalanceRepairFacadeControllerBean");
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.app.GLBalanceRepairResource";
    public static final String TRANSACTION = "GLBalanceRepair";
    public static final String RepEnable = "GL_BalRep_Enable";
    public static final String StartHour = "GL_BalRep_StartHour";
    public static final String EndHour = "GL_BalRep_EndHour";

    @Override
    protected void _repairContext(Context ctx) throws BOSException, EASBizException {
        UserInfo user;
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (cu == null || cu.getId() == null) {
            cu = new CtrlUnitInfo();
            cu.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
            ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)cu);
        }
        if ((user = ContextUtil.getCurrentUserInfo((Context)ctx)) == null || user.getId() == null) {
            user = new UserInfo();
            user.setId(BOSUuid.read((String)"00000000-0000-0000-0000-00000000000013B7DE7F"));
            ContextUtil.setCurrentUserInfo((Context)ctx, (UserInfo)user);
        }
        if (ctx.getCaller() == null) {
            ctx.setCaller((IObjectPK)new ObjectUuidPK(user.getId()));
        }
        List<String> companyIds = this.getNeedRepairCompanyIds(ctx);
        for (String companyId : companyIds) {
            try {
                GLBalanceRepairFacadeFactory.getLocalInstance(ctx).repairCompany(companyId, true, true);
            }
            catch (Exception e) {
                logger.error((Object)("GL balance [companyId:" + companyId + "] repair error!"), (Throwable)e);
            }
        }
    }

    protected List<String> getNeedRepairCompanyIds(Context ctx) throws BOSException {
        LinkedList<String> companyIds = new LinkedList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from T_GL_ObjectLabel \n");
        sql.append("where FLabel = 'GLBalanceRepair' \n");
        sql.append("    and FIsEnable in (0, 1) \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean found = false;
        try {
            if (rs.next()) {
                found = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (found) {
            sql.setLength(0);
            sql.append("select distinct \n");
            sql.append("    c.FID, t.FUpdateTime \n");
            sql.append("from T_BD_SystemStatusCtrol sc \n");
            sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
            sql.append("join T_GL_ObjectLabel ol on ol.FObjectID = c.FID \n");
            sql.append("join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID \n");
            sql.append("left join t_bas_transaction t on t.fid = c.fid \n");
            sql.append("    and t.fsystype = 6 and t.fnumber = 'GLBalanceRepair' \n");
            sql.append("where c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
            sql.append("    and sc.FIsStart = 1 and sc.FCurrentPeriodID is not null \n");
            sql.append("    and s.FName = 6 \n");
            sql.append("    and ol.FLabel = 'GLBalanceRepair' and ol.FIsEnable = 1 \n");
            sql.append("order by t.FUpdateTime \n");
            sql.append("\n");
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    if (rs.getTimestamp("FUpdateTime") == null) {
                        companyIds.addFirst(rs.getString("FID"));
                        continue;
                    }
                    companyIds.add(rs.getString("FID"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            return companyIds;
        }
        sql.setLength(0);
        sql.append("select distinct \n");
        sql.append("    c.FID, t.FUpdateTime \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
        sql.append("join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID \n");
        sql.append("left join t_bas_transaction t on t.fid = c.fid \n");
        sql.append("    and t.fsystype = 6 and t.fnumber = 'GLBalanceRepair' \n");
        sql.append("where c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
        sql.append("    and sc.FIsStart = 1 and sc.FCurrentPeriodID is not null \n");
        sql.append("    and s.FName = 6 \n");
        sql.append("order by t.FUpdateTime \n");
        sql.append("\n");
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getTimestamp("FUpdateTime") == null) {
                    companyIds.addFirst(rs.getString("FID"));
                    continue;
                }
                companyIds.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return companyIds;
    }

    private Map<String, Object> getRepairParams(Context ctx, String companyId) throws EASBizException, BOSException {
        String str;
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> inParams = new HashMap<String, String>();
        inParams.put(RepEnable, companyId);
        inParams.put(StartHour, companyId);
        inParams.put(EndHour, companyId);
        HashMap outParams = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(inParams);
        Boolean enable = false;
        int startHour = -1;
        int endHour = -1;
        if (outParams.get(RepEnable) != null && "true".equals(str = outParams.get(RepEnable).toString())) {
            enable = true;
        }
        if (outParams.get(StartHour) != null) {
            try {
                str = outParams.get(StartHour).toString();
                startHour = Integer.parseInt(str);
            }
            catch (Exception e) {
                logger.warn((Object)"", (Throwable)e);
            }
        }
        if (outParams.get(EndHour) != null) {
            try {
                str = outParams.get(EndHour).toString();
                endHour = Integer.parseInt(str);
            }
            catch (Exception e) {
                logger.warn((Object)"", (Throwable)e);
            }
        }
        params.put(RepEnable, enable);
        if (startHour < 0 || startHour > 23 || endHour < 0 || endHour > 23) {
            startHour = 1;
            endHour = 5;
        }
        if (startHour > endHour) {
            endHour += 24;
        }
        params.put(StartHour, startHour);
        params.put(EndHour, endHour);
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isInAllowTime(Context ctx, Map params) {
        Timestamp currTime;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        int endHour;
        int startHour;
        block6: {
            startHour = (Integer)params.get(StartHour);
            endHour = (Integer)params.get(EndHour);
            String sql = "select getDate() FCurTime";
            conn = null;
            stmt = null;
            rs = null;
            currTime = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (!rs.next()) break block6;
                currTime = rs.getTimestamp("FCurTime");
            }
            catch (Exception e) {
                try {
                    logger.warn((Object)"GL balance repair error!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        if (currTime == null) {
            currTime = new Timestamp(System.currentTimeMillis());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currTime);
        int hour = calendar.get(11);
        if (endHour >= 24) {
            hour += 24;
        }
        return hour >= startHour && hour <= endHour;
    }

    @Override
    protected Map _repairCompany(Context ctx, String companyId) throws BOSException, EASBizException {
        return this._repairCompany(ctx, companyId, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _repairCompany(Context ctx, String companyId, boolean checkTime, boolean checkMutex) throws BOSException, EASBizException {
        String userId;
        MutexParameter current;
        Map<String, Boolean> result = new HashMap<String, String>();
        if (checkTime) {
            Map<String, Object> hourParams = this.getRepairParams(ctx, companyId);
            if (!((Boolean)hourParams.get(RepEnable)).booleanValue()) {
                return result;
            }
            if (!this.isInAllowTime(ctx, hourParams)) {
                return result;
            }
            try {
                Timestamp updateTime;
                boolean hasDone = false;
                StringBuffer sql = new StringBuffer();
                sql.append("select FID, FUpdateTime, getDate() curTime \n");
                sql.append("from t_bas_transaction \n");
                sql.append("where FID = '" + companyId + "' \n");
                sql.append("    and fsystype = 6 and fnumber = 'GLBalanceRepair' \n");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rs.next() && (updateTime = rs.getTimestamp("FUpdateTime")) != null) {
                    Timestamp curTime = rs.getTimestamp("curTime");
                    SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                    String uTime = format.format(updateTime);
                    String cTime = format.format(curTime);
                    hasDone = uTime.equals(cTime);
                }
                if (hasDone) {
                    return result;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        PeriodInfo period = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo start = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
        if (period == null || period.getId() == null || start == null || start.getId() == null) {
            result.put("message", (Boolean)((Object)"\u671f\u95f4\u8bbe\u7f6e\u4e0d\u6b63\u786e\uff0c\u65e0\u9700\u4fee\u590d\u3002"));
            return result;
        }
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter mp = null;
        if (checkMutex && (current = mutex.requestMutex3(mp = GLMutexUtils.buildModifyBalanceParameter(ctx, companyId, userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), "GL_BalRep"))) != null) {
            result.put("message", (Boolean)((Object)GLMutexUtils.getMutexMessage(ctx, current, mp)));
            return result;
        }
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("periodFrom", period);
            params.put("periodTo", period);
            params.put("AnaBal_Posted", true);
            params.put("AnaBal_UnPost", true);
            params.put("AnaBal_Begin", true);
            params.put("AnaBal_Current", true);
            int cyType = 0;
            params.put("AnaBal_Currency", cyType |= 1);
            params.put("AnaBal_ShowName", false);
            params.put("AnaBal_CompareFwd", false);
            params.put("AnaBal_CompareRev", false);
            params.put("AnaBal_CompareDou", true);
            params.put("AnaBal_Account", true);
            params.put("AnaBal_Assist", true);
            params.put("AnaBal_CompareAmt", true);
            params.put("AnaBal_CompareQty", false);
            params.put("AnaBal_ComparePNL", false);
            params.put("AnaBal_MaxSize", Integer.MAX_VALUE);
            params.put("AnaBal_Repair", true);
            result = (Map)GLBalanceAnaFacadeFactory.getLocalInstance(ctx).analysis(companyId, params);
            if (result.get("isNeedRepair") != null) {
                result.put("isAuto", true);
                result = GLBalanceRepairFacadeFactory.getLocalInstance(ctx).doRepairCompany(result);
            }
            this.updateRepairStatus(ctx, companyId);
            Map<String, Boolean> map = result;
            return map;
        }
        finally {
            if (mp != null) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _repairCompany(Context ctx, Map params) throws BOSException, EASBizException {
        String userId;
        String companyId;
        MutexParameter mp;
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter current = mutex.requestMutex3(mp = GLMutexUtils.buildModifyBalanceParameter(ctx, companyId = (String)params.get("companyId"), userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), "GL_BalRepMenu"));
        if (current != null) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("message", GLMutexUtils.getMutexMessage(ctx, current, mp));
            return result;
        }
        try {
            GLBalanceFacadeFactory.getLocalInstance(ctx).updateVoucherBalance(new String[]{companyId});
            Map map = GLBalanceRepairFacadeFactory.getLocalInstance(ctx).doRepairCompany(params);
            return map;
        }
        finally {
            if (mp != null) {
                mutex.releaseMutex(mp.getRequestId());
            }
        }
    }

    @Override
    protected Map _doRepairCompany(Context ctx, Map params) throws BOSException, EASBizException {
        return GLBalanceRepairer.repair(ctx, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRepairStatus(Context ctx, String companyId) {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block5: {
            StringBuffer sql = new StringBuffer();
            sql.append("select \n");
            sql.append("    fid \n");
            sql.append("from t_bas_transaction \n");
            sql.append("where FID = ? \n");
            sql.append("    and fsystype = 6 \n");
            sql.append("    and fnumber = 'GLBalanceRepair' \n");
            conn = null;
            ps = null;
            rs = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                ps = conn.prepareStatement(sql.toString());
                ps.setString(1, companyId);
                rs = ps.executeQuery();
                boolean exists = rs.next();
                rs.close();
                ps.close();
                if (exists) {
                    sql.setLength(0);
                    sql.append("update t_bas_transaction set \n");
                    sql.append("    fupdateTime = getDate() \n");
                    sql.append("where fid = ? \n");
                    sql.append("    and fsystype = 6 \n");
                    sql.append("    and fnumber = 'GLBalanceRepair' \n");
                    ps = conn.prepareStatement(sql.toString());
                    ps.setString(1, companyId);
                    ps.executeUpdate();
                    break block5;
                }
                sql.setLength(0);
                sql.append("insert into t_bas_transaction ( \n");
                sql.append("    fid,fsystype,fnumber,fupdatetime,ftimecount,fisupdating \n");
                sql.append(") \n");
                sql.append("values ( \n");
                sql.append("    ?, 6, 'GLBalanceRepair', getDate(), 0, 0 \n");
                sql.append(") \n");
                ps = conn.prepareStatement(sql.toString());
                ps.setString(1, companyId);
                ps.executeUpdate();
            }
            catch (SQLException ignore) {
                try {
                    logger.warn((Object)"", (Throwable)ignore);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
    }

    public static String getResource(Context ctx, String resName) {
        return ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)ctx.getLocale());
    }
}

