/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.AppLogInfo;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLBalanceRepairer {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLBalanceRepairer");
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.app.GLBalanceRepairResource";

    public static String getResource(Context ctx, String resName) {
        return ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)ctx.getLocale());
    }

    public static void test(Context ctx) throws EASBizException, BOSException {
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        String tableId = company.getAccountTable().getId().toString();
        HashSet accountNumbers = new HashSet();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("companyId", companyId);
        params.put("accountNumbers", accountNumbers);
        PeriodInfo periodfrom = new PeriodInfo();
        periodfrom.setNumber(201510);
        params.put("periodfrom", periodfrom);
        PeriodInfo periodto = new PeriodInfo();
        periodto.setNumber(201512);
        params.put("periodto", periodto);
        params.put("repairAccount", true);
        params.put("repairAssist", true);
        params.put("repairMeasure", true);
        GLBalanceRepairer.repair(ctx, params);
    }

    public static Map<String, Object> repair(Context ctx, Map params) throws EASBizException, BOSException {
        boolean isQtyAsst;
        boolean isUseRpt;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String companyId = (String)params.get("companyId");
        Set accountNumbers = (Set)params.get("accountNumbers");
        int startPeriod = ((PeriodInfo)params.get("periodfrom")).getNumber();
        int endPeriod = ((PeriodInfo)params.get("periodto")).getNumber();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("accountTable.id");
        selector.add("accountTable.number");
        selector.add("accountTable.name");
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
        PeriodInfo current = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo start = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
        if (current == null || start == null) {
            result.put("message", GLBalanceRepairer.getResource(ctx, "period_set_error"));
            return result;
        }
        EntityViewInfo view = new EntityViewInfo();
        selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("periodYear");
        selector.add("periodNumber");
        selector.add("isAdjustPeriod");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)current.getPeriodType().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)startPeriod, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)start.getNumber(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)endPeriod, CompareType.LESS_EQUALS));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setSelector(selector);
        view.setFilter(filter);
        view.setSorter(sorter);
        PeriodCollection periodCol = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(view);
        if (periodCol.size() <= 0) {
            result.put("message", GLBalanceRepairer.getResource(ctx, "period_set_error"));
            return result;
        }
        StringBuffer instanceDeatil = new StringBuffer();
        instanceDeatil.append(company.getNumber() + " ");
        instanceDeatil.append((Boolean)params.get("onlyClean") != false ? "clear " : "repair ");
        instanceDeatil.append("period:");
        instanceDeatil.append("periodfrom-");
        instanceDeatil.append("periodto,");
        instanceDeatil.append("account:");
        if (accountNumbers != null && accountNumbers.size() > 0) {
            int count = 0;
            for (String accountNumber : accountNumbers) {
                if (instanceDeatil.length() + accountNumber.length() > 1000) break;
                if (++count > 1) {
                    instanceDeatil.append(",");
                }
                instanceDeatil.append(accountNumber);
            }
            if (accountNumbers.size() > count) {
                instanceDeatil.append(",...");
            }
        } else {
            instanceDeatil.append("all");
        }
        String logItemName = "gl_BalanceRepair_Manu";
        if (params.get("isAuto") != null) {
            logItemName = "gl_BalanceRepair_Auto";
        }
        String beforeDetail = instanceDeatil.toString().replace("periodfrom", String.valueOf(startPeriod));
        beforeDetail = beforeDetail.replace("periodto", String.valueOf(endPeriod));
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"repairCompany", (BOSObjectType)new BOSObjectType("FAC9B7EE"), (IObjectPK)new ObjectUuidPK(companyId), (String)beforeDetail, (String)logItemName);
        boolean isMSSQLSERVER = SQLUtil.isMSSQLSERVER(ctx);
        StringBuffer sql = new StringBuffer();
        if (isMSSQLSERVER) {
            sql.append("/*dialect*/ ");
        }
        sql.append("select top 1 1 from T_GL_Voucher_Log ");
        if (isMSSQLSERVER) {
            sql.append("with(readpast) ");
        }
        sql.append("where FCompanyID = ? and FIsupdating = 0 \n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{companyId});
        try {
            if (rowSet.next()) {
                throw new BOSException("Company [" + companyId + "] exist voucher balance log, cannot repair.");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Object> ins = new HashMap<String, Object>();
        ins.put("GL_BalUpd_Serial", null);
        ins.put("GL_BalUpd_LockCo", null);
        HashMap outs = null;
        try {
            outs = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(ins);
            if (outs == null) {
                outs = new HashMap();
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        boolean isSerial = false;
        boolean isLockCo = false;
        Object param = outs.get("GL_BalUpd_Serial");
        if (param != null) {
            isSerial = Boolean.valueOf(param.toString());
        }
        if ((param = outs.get("GL_BalUpd_LockCo")) != null) {
            isLockCo = Boolean.valueOf(param.toString());
        }
        if (isSerial && isLockCo) {
            sql.setLength(0);
            sql.append("update T_GL_LockBalance set FUpdateTime = getdate(), \n");
            sql.append("  FTimeCount = case when ftimecount >= 9999 then 0 else ftimecount + 1 end \n");
            sql.append("where FID = ?");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{companyId});
        }
        int maxAfterCount = 5;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FValue from T_GL_AnaConfig where FKey = 'AnaBal_MaxRepair' ");
        try {
            int i;
            if (rs.next() && (i = Integer.parseInt(rs.getString("FValue"))) >= 0 && i <= 1200) {
                maxAfterCount = i;
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        int afterCount = 0;
        ArrayList<PeriodInfo> periods = new ArrayList<PeriodInfo>();
        for (int i = 0; i < periodCol.size(); ++i) {
            PeriodInfo period = periodCol.get(i);
            periods.add(period);
            if (period.getNumber() > current.getNumber() && ++afterCount >= maxAfterCount) break;
        }
        PeriodInfo first = null;
        if (((PeriodInfo)periods.get(0)).getNumber() == start.getNumber() && start.getPeriodNumber() != 1) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)current.getPeriodType().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)(start.getPeriodYear() * 100 + 1)));
            view.setFilter(filter);
            periodCol = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(view);
            if (periodCol.size() > 0) {
                first = periodCol.get(0);
            }
        }
        HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
        hmParamIn.put("G001", null);
        hmParamIn.put("G010", null);
        HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hmParamIn);
        try {
            isUseRpt = Boolean.valueOf(hmAllParam.get("G001").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"G001"});
        }
        try {
            isQtyAsst = Boolean.valueOf(hmAllParam.get("G010").toString());
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"G010"});
        }
        params.put("isUseRpt", isUseRpt);
        params.put("isQtyAsst", isQtyAsst);
        Set<String> parentAccountIds = new HashSet<String>();
        Set<String> leafAccountIds = new HashSet<String>();
        if (accountNumbers == null || accountNumbers.size() == 0) {
            GLBalanceRepairer.repair(ctx, params, companyId, periods, current, start, first, parentAccountIds, leafAccountIds);
        } else {
            Set<String> tableIds = GLBalanceRepairer.getAccountTableIds(ctx, company, params);
            Map<String, Set<String>> map = GLBalanceRepairer.getAccountIds(ctx, companyId, tableIds, (Set<String>)accountNumbers);
            parentAccountIds = map.get("parent");
            leafAccountIds = map.get("leaf");
            if (parentAccountIds.size() == 0 && leafAccountIds.size() == 0) {
                result.put("message", GLBalanceRepairer.getResource(ctx, "accountView_error"));
                return result;
            }
            String T_TMP_Account = null;
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                if (parentAccountIds.size() + leafAccountIds.size() > 200) {
                    sql.setLength(0);
                    sql.append("create table T_TMP_Account ( ");
                    sql.append("  FID                VARCHAR(44), ");
                    sql.append("  FIsLeaf            int DEFAULT 0 ");
                    sql.append(") ");
                    T_TMP_Account = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
                    params.put("T_TMP_Account", T_TMP_Account);
                    sql.setLength(0);
                    sql.append("insert into " + T_TMP_Account + " (FID, FIsLeaf) values (?, ?)");
                    conn = EJBFactory.getConnection((Context)ctx);
                    pstmt = conn.prepareStatement(sql.toString());
                    if (parentAccountIds.size() > 0) {
                        for (String id : parentAccountIds) {
                            pstmt.setString(1, id);
                            pstmt.setInt(2, 0);
                            pstmt.addBatch();
                        }
                        pstmt.executeBatch();
                    }
                    if (leafAccountIds.size() > 0) {
                        for (String id : leafAccountIds) {
                            pstmt.setString(1, id);
                            pstmt.setInt(2, 1);
                            pstmt.addBatch();
                        }
                        pstmt.executeBatch();
                    }
                    pstmt.close();
                    conn.close();
                    TempTablePool.getInstance((Context)ctx).createIndex(T_TMP_Account, "FID, FIsLeaf", true, false);
                    parentAccountIds.clear();
                    leafAccountIds.clear();
                }
                GLBalanceRepairer.repair(ctx, params, companyId, periods, current, start, first, parentAccountIds, leafAccountIds);
            }
            catch (BOSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup(pstmt, conn);
                if (T_TMP_Account != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(T_TMP_Account);
                }
            }
        }
        boolean onlyClean = (Boolean)params.get("onlyClean");
        result.put("status", "Success");
        String action = GLBalanceRepairer.getResource(ctx, "repaired_success");
        if (onlyClean) {
            action = GLBalanceRepairer.getResource(ctx, "clean_success");
        }
        result.put("message", action + GLBalanceRepairer.getResource(ctx, "period") + ":" + ((PeriodInfo)periods.get(0)).getNumber() + "-" + ((PeriodInfo)periods.get(periods.size() - 1)).getNumber() + "\uff0c" + GLBalanceRepairer.getResource(ctx, "accountView") + ":" + (accountNumbers.size() > 0 ? accountNumbers + "\u3002" : GLBalanceRepairer.getResource(ctx, "all_accountView")));
        if (((PeriodInfo)periods.get(0)).getNumber() == startPeriod && ((PeriodInfo)periods.get(periods.size() - 1)).getNumber() == endPeriod) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        } else {
            String afterDetail = instanceDeatil.toString().replace("periodfrom", String.valueOf(((PeriodInfo)periods.get(0)).getNumber()));
            afterDetail = afterDetail.replace("periodto", String.valueOf(((PeriodInfo)periods.get(periods.size() - 1)).getNumber()));
            GLBalanceRepairer.afterLog(ctx, logPK, (IObjectPK)new ObjectUuidPK(companyId), afterDetail);
        }
        return result;
    }

    protected static void afterLog(Context ctx, IObjectPK logPK, IObjectPK instancePK, String instanceDeatil) {
        if (logPK == null) {
            return;
        }
        try {
            AppLogInfo info = new AppLogInfo();
            info.setId(BOSUuid.read((String)logPK.toString()));
            info.setInstanceId(instancePK != null ? instancePK.toString() : null);
            info.setInstanceNo(instanceDeatil);
            GLGeneralFacadeFactory.getLocalInstance(ctx).updateAppLog(info);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err: " + e.getMessage()), (Throwable)e);
        }
    }

    private static List<Map<String, Object>> getAccountRefConstrasts(Context ctx, String companyId, PeriodInfo startPeriod) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("  p.FNumber FPeriodNumber, c.FDisabledAcctTableID \n");
        sql.append("from T_bd_AcctRefContrast c \n");
        sql.append("join T_bd_Period p on p.FID = c.FEnabledPeriodID \n");
        sql.append("where c.FCompanyID = ? \n");
        sql.append("  and FRefType = 1 \n");
        sql.append("  and FIsEnabled = 1 \n");
        sql.append("  and p.FNumber >= ? \n");
        sql.append("order by p.FNumber \n");
        ArrayList<Map<String, Object>> constrasts = new ArrayList<Map<String, Object>>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, startPeriod.getNumber()});
        try {
            while (rs.next()) {
                HashMap<String, Object> constrast = new HashMap<String, Object>();
                constrast.put("periodNumber", rs.getInt("FPeriodNumber"));
                constrast.put("disableAcctTableID", rs.getString("FDisabledAcctTableID"));
                constrasts.add(constrast);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return constrasts;
    }

    private static Set<String> getAccountTableIds(Context ctx, CompanyOrgUnitInfo company, Map params) throws BOSException {
        HashSet<String> ids = new HashSet<String>();
        ids.add(company.getAccountTable().getId().toString());
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("  c.FDisabledAcctTableID \n");
        sql.append("from T_bd_AcctRefContrast c \n");
        sql.append("where c.FCompanyID = ? \n");
        sql.append("  and FRefType = 1 \n");
        sql.append("  and FIsEnabled = 1 \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{company.getId().toString()});
        try {
            while (rs.next()) {
                ids.add(rs.getString("FDisabledAcctTableID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ids;
    }

    private static Map<String, Set<String>> getAccountIds(Context ctx, String companyId, String tableId, Set<String> accountNumbers) throws BOSException {
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("  rav.FID, rav.FNumber, rav.FIsLeaf \n");
        sql.append("from T_BD_AccountView av \n");
        sql.append("JOIN T_BD_AccountView rav \n");
        sql.append("  on rav.FCompanyID = av.FCompanyID and rav.FAccountTableID = av.FAccountTableID \n");
        if (SQLUtil.isOracle(ctx) || SQLUtil.isMSSQLSERVER(ctx) || SQLUtil.isPG(ctx)) {
            sql.append("  and (rav.fid = av.fid or av.flongnumber like concat(rav.flongnumber,'!%') or rav.flongnumber like concat(av.flongnumber,'!%')) \n");
        } else {
            sql.append("  and (rav.fid = av.fid or charindex(rav.flongnumber||'!',av.flongnumber) = 1 or charindex(av.flongnumber||'!',rav.flongnumber) = 1) \n");
        }
        sql.append("where av.FCompanyID = ? \n");
        sql.append("  and av.FAccountTableID = ? \n");
        params.add(companyId);
        params.add(tableId);
        if (accountNumbers.size() == 1) {
            sql.append("  and av.FNumber = ? \n");
        } else {
            sql.append("  and av.FNumber in " + SQLUtil.buildMarkSQL(accountNumbers.size()) + " \n");
        }
        params.addAll(accountNumbers);
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        HashSet<String> parentAccountIds = new HashSet<String>();
        HashSet<String> leafAccountIds = new HashSet<String>();
        result.put("parent", parentAccountIds);
        result.put("leaf", leafAccountIds);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                if (rs.getInt("FIsLeaf") == 1) {
                    leafAccountIds.add(rs.getString("FID"));
                    continue;
                }
                parentAccountIds.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private static Map<String, Set<String>> getAccountIds(Context ctx, String companyId, Set<String> tableIds, Set<String> accountNumbers) throws BOSException {
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("  rav.FID, rav.FNumber, rav.FIsLeaf \n");
        sql.append("from T_BD_AccountView av \n");
        sql.append("JOIN T_BD_AccountView rav \n");
        sql.append("  on rav.FCompanyID = av.FCompanyID and rav.FAccountTableID = av.FAccountTableID \n");
        if (SQLUtil.isOracle(ctx) || SQLUtil.isMSSQLSERVER(ctx) || SQLUtil.isPG(ctx)) {
            sql.append("  and (rav.fid = av.fid or av.flongnumber like concat(rav.flongnumber,'!%') or rav.flongnumber like concat(av.flongnumber,'!%')) \n");
        } else {
            sql.append("  and (rav.fid = av.fid or charindex(rav.flongnumber||'!',av.flongnumber) = 1 or charindex(av.flongnumber||'!',rav.flongnumber) = 1) \n");
        }
        sql.append("where av.FCompanyID = ? \n");
        params.add(companyId);
        if (tableIds.size() == 1) {
            sql.append("  and av.FAccountTableID = ? \n");
        } else {
            sql.append("  and av.FAccountTableID in " + SQLUtil.buildMarkSQL(tableIds.size()) + " \n");
        }
        params.addAll(tableIds);
        if (accountNumbers.size() == 1) {
            sql.append("  and av.FNumber = ? \n");
        } else {
            sql.append("  and av.FNumber in " + SQLUtil.buildMarkSQL(accountNumbers.size()) + " \n");
        }
        params.addAll(accountNumbers);
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        HashSet<String> parentAccountIds = new HashSet<String>();
        HashSet<String> leafAccountIds = new HashSet<String>();
        result.put("parent", parentAccountIds);
        result.put("leaf", leafAccountIds);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                if (rs.getInt("FIsLeaf") == 1) {
                    leafAccountIds.add(rs.getString("FID"));
                    continue;
                }
                parentAccountIds.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private static void repair(Context ctx, Map params, String companyId, List<PeriodInfo> periods, PeriodInfo current, PeriodInfo start, PeriodInfo first, Set<String> parentAccountIds, Set<String> leafAccountIds) throws BOSException {
        boolean onlyClean = (Boolean)params.get("onlyClean");
        GLBalanceRepairer.clearBalance(ctx, params, companyId, periods, current, start, first, parentAccountIds, leafAccountIds);
        if (onlyClean) {
            return;
        }
        boolean repairAccount = (Boolean)params.get("repairAccount");
        boolean repairAssist = (Boolean)params.get("repairAssist");
        boolean repairMeasure = (Boolean)params.get("repairMeasure");
        boolean isQtyAsst = (Boolean)params.get("isQtyAsst");
        String T_TMP_Table = null;
        try {
            T_TMP_Table = GLBalanceRepairer.createTempTable(ctx, 1);
            PeriodInfo period = null;
            PeriodInfo prePeriod = null;
            for (int i = 0; i < periods.size(); ++i) {
                period = periods.get(i);
                if (prePeriod == null) {
                    prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)period);
                }
                if (repairAccount) {
                    GLBalanceRepairer.doRepair(ctx, params, companyId, current, start, first, period, prePeriod, T_TMP_Table, parentAccountIds, leafAccountIds, 1);
                }
                if (repairAssist) {
                    GLBalanceRepairer.doRepair(ctx, params, companyId, current, start, first, period, prePeriod, T_TMP_Table, parentAccountIds, leafAccountIds, 2);
                }
                if (repairMeasure && isQtyAsst) {
                    GLBalanceRepairer.doRepair(ctx, params, companyId, current, start, first, period, prePeriod, T_TMP_Table, parentAccountIds, leafAccountIds, 3);
                }
                prePeriod = period;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (T_TMP_Table != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(T_TMP_Table);
            }
        }
    }

    private static void clearBalance(Context ctx, Map params, String companyId, List<PeriodInfo> periods, PeriodInfo current, PeriodInfo start, PeriodInfo first, Set<String> parentAccountIds, Set<String> leafAccountIds) throws BOSException {
        boolean repairAccount = (Boolean)params.get("repairAccount");
        boolean repairAssist = (Boolean)params.get("repairAssist");
        boolean repairMeasure = (Boolean)params.get("repairMeasure");
        boolean isUseRpt = (Boolean)params.get("isUseRpt");
        boolean isQtyAsst = (Boolean)params.get("isQtyAsst");
        HashSet<String> accountIds = new HashSet<String>();
        accountIds.addAll(parentAccountIds);
        accountIds.addAll(leafAccountIds);
        List<PeriodInfo> clears = periods;
        if (first != null) {
            clears = new ArrayList<PeriodInfo>(periods.size() + 1);
            clears.add(first);
            clears.addAll(periods);
        }
        if (repairAccount) {
            GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 1, 1, null);
            GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 1, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 1, 5, null);
            GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 1, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            if (isUseRpt) {
                GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 1, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
                GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 1, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
            }
        }
        if (repairAssist) {
            GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 2, 1, null);
            GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 2, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 2, 5, null);
            GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 2, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            if (isUseRpt) {
                GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 2, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
                GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 2, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
            }
        }
        if (repairMeasure && isQtyAsst) {
            GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 3, 1, null);
            GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 3, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 3, 5, null);
            GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 3, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            if (isUseRpt) {
                GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 3, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
                GLBalanceRepairer.doClearBalance(ctx, params, companyId, clears, accountIds, 3, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
            }
        }
    }

    private static void doClearBalance(Context ctx, Map params, String companyId, List<PeriodInfo> periods, Set<String> accountIds, int balanceType, int balType, String currencyId) throws BOSException {
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        String T_Balance = GLBalanceUtils.getBalanceTable(balanceType, balType, currencyId);
        ArrayList<Object> ps = new ArrayList<Object>();
        ps.add(companyId);
        StringBuffer sql = new StringBuffer();
        sql.append("delete from " + T_Balance + " \n");
        sql.append("where FOrgUnitID = ? \n");
        if (periods.size() == 1) {
            sql.append("  and FPeriod = ? \n");
            ps.add(periods.get(0).getNumber());
        } else {
            HashSet<Integer> periodNumbers = new HashSet<Integer>();
            for (int i = 0; i < periods.size(); ++i) {
                periodNumbers.add(periods.get(i).getNumber());
            }
            sql.append("  and FPeriod in " + GLBalanceRepairer.toInSql(periodNumbers));
        }
        if (T_TMP_Account != null) {
            sql.append("  and FAccountID in (select FID from " + T_TMP_Account + ") \n");
        }
        if (accountIds.size() > 0) {
            if (accountIds.size() == 1) {
                sql.append("  and FAccountID = ? \n");
                ps.add(accountIds.iterator().next());
            } else {
                sql.append("  and FAccountID in " + GLBalanceRepairer.toInSql(accountIds) + " \n");
            }
        }
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])ps.toArray());
    }

    private static void doRepair(Context ctx, Map params, String companyId, PeriodInfo current, PeriodInfo start, PeriodInfo first, PeriodInfo period, PeriodInfo prePeriod, String T_TMP_Table, Set<String> parentAccountIds, Set<String> leafAccountIds, int balanceType) throws Exception {
        boolean isUseRpt = (Boolean)params.get("isUseRpt");
        DbUtil.execute((Context)ctx, (String)("delete from " + T_TMP_Table));
        if (period.getId().equals((Object)start.getId())) {
            GLBalanceRepairer.insertStart(ctx, params, T_TMP_Table, companyId, current, start, leafAccountIds, balanceType);
        } else {
            GLBalanceRepairer.insertBegin(ctx, params, T_TMP_Table, companyId, period, prePeriod, leafAccountIds, balanceType, 5);
        }
        GLBalanceRepairer.insertCurrent(ctx, params, T_TMP_Table, companyId, period, leafAccountIds, balanceType, 5);
        GLBalanceRepairer.buildBalance(ctx, params, T_TMP_Table, companyId, period, leafAccountIds, balanceType, 5, null);
        GLBalanceRepairer.buildBalance(ctx, params, T_TMP_Table, companyId, period, leafAccountIds, balanceType, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
        if (isUseRpt) {
            GLBalanceRepairer.buildBalance(ctx, params, T_TMP_Table, companyId, period, leafAccountIds, balanceType, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
        }
        if (period.getNumber() < current.getNumber() && !period.isIsAdjustPeriod()) {
            GLBalanceRepairer.buildBalance(ctx, params, T_TMP_Table, companyId, period, leafAccountIds, balanceType, 1, null);
            GLBalanceRepairer.buildBalance(ctx, params, T_TMP_Table, companyId, period, leafAccountIds, balanceType, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            if (isUseRpt) {
                GLBalanceRepairer.buildBalance(ctx, params, T_TMP_Table, companyId, period, leafAccountIds, balanceType, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
            }
        } else {
            DbUtil.execute((Context)ctx, (String)("delete from " + T_TMP_Table));
            if (period.getId().equals((Object)start.getId())) {
                GLBalanceRepairer.insertStart(ctx, params, T_TMP_Table, companyId, current, start, leafAccountIds, balanceType);
            } else {
                GLBalanceRepairer.insertBegin(ctx, params, T_TMP_Table, companyId, period, prePeriod, leafAccountIds, balanceType, 1);
            }
            GLBalanceRepairer.insertCurrent(ctx, params, T_TMP_Table, companyId, period, leafAccountIds, balanceType, 1);
            GLBalanceRepairer.buildBalance(ctx, params, T_TMP_Table, companyId, period, leafAccountIds, balanceType, 1, null);
            GLBalanceRepairer.buildBalance(ctx, params, T_TMP_Table, companyId, period, leafAccountIds, balanceType, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            if (isUseRpt) {
                GLBalanceRepairer.buildBalance(ctx, params, T_TMP_Table, companyId, period, leafAccountIds, balanceType, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
            }
        }
        if (balanceType == 1 && (parentAccountIds.size() > 0 || leafAccountIds.size() == 0)) {
            GLBalanceRepairer.buildParent(ctx, params, companyId, period, parentAccountIds, 5, null);
            GLBalanceRepairer.buildParent(ctx, params, companyId, period, parentAccountIds, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            GLBalanceRepairer.buildParent(ctx, params, companyId, period, parentAccountIds, 1, null);
            GLBalanceRepairer.buildParent(ctx, params, companyId, period, parentAccountIds, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            if (isUseRpt) {
                GLBalanceRepairer.buildParent(ctx, params, companyId, period, parentAccountIds, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
                GLBalanceRepairer.buildParent(ctx, params, companyId, period, parentAccountIds, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
            }
        }
        if (period.getId().equals((Object)start.getId()) && first != null) {
            HashSet<String> accountIds = new HashSet<String>();
            accountIds.addAll(parentAccountIds);
            accountIds.addAll(leafAccountIds);
            GLBalanceRepairer.buildFirst(ctx, params, companyId, current, start, first, accountIds, balanceType, 5, null);
            GLBalanceRepairer.buildFirst(ctx, params, companyId, current, start, first, accountIds, balanceType, 5, "11111111-1111-1111-1111-111111111111DEB58FDC");
            GLBalanceRepairer.buildFirst(ctx, params, companyId, current, start, first, accountIds, balanceType, 1, null);
            GLBalanceRepairer.buildFirst(ctx, params, companyId, current, start, first, accountIds, balanceType, 1, "11111111-1111-1111-1111-111111111111DEB58FDC");
            if (isUseRpt) {
                GLBalanceRepairer.buildFirst(ctx, params, companyId, current, start, first, accountIds, balanceType, 5, "22222222-2222-2222-2222-222222222222DEB58FDC");
                GLBalanceRepairer.buildFirst(ctx, params, companyId, current, start, first, accountIds, balanceType, 1, "22222222-2222-2222-2222-222222222222DEB58FDC");
            }
        }
    }

    private static String createTempTable(Context ctx, int balanceType) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_TMP_Table ( ");
        sql.append("  FAccountID         VARCHAR(44),");
        sql.append("  FCurrencyID        VARCHAR(44),");
        sql.append("  FAssGrpID          VARCHAR(44),");
        sql.append("  FMeasureUnitID     VARCHAR(44),");
        sql.append("  FBeginBalanceFor   NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FDebitFor          NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FCreditFor         NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearDebitFor      NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearCreditFor     NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FMonthPnlFor       NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearPnlFor        NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FEndBalanceFor     NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FBeginBalanceLocal NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FDebitLocal        NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FCreditLocal       NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearDebitLocal    NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearCreditLocal   NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FMonthPnlLocal     NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearPnlLocal      NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FEndBalanceLocal   NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FBeginBalanceRpt   NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FDebitRpt          NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FCreditRpt         NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearDebitRpt      NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearCreditRpt     NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FMonthPnlRpt       NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FYearPnlRpt        NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FEndBalanceRpt     NUMERIC(19,4) DEFAULT 0,");
        sql.append("  FBeginQty          NUMERIC(28,10) DEFAULT 0,");
        sql.append("  FDebitQty          NUMERIC(28,10) DEFAULT 0,");
        sql.append("  FCreditQty         NUMERIC(28,10) DEFAULT 0,");
        sql.append("  FYearDebitQty      NUMERIC(28,10) DEFAULT 0,");
        sql.append("  FYearCreditQty     NUMERIC(28,10) DEFAULT 0,");
        sql.append("  FMonthPnlQty       NUMERIC(28,10) DEFAULT 0,");
        sql.append("  FYearPnlQty        NUMERIC(28,10) DEFAULT 0,");
        sql.append("  FEndQty            NUMERIC(28,10) DEFAULT 0,");
        sql.append("  FDetailCount       int DEFAULT 0");
        sql.append(") \n");
        String T_TMP_Table = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        return T_TMP_Table;
    }

    public static void insertStart(Context ctx, Map params, String T_TMP_Table, String companyId, PeriodInfo current, PeriodInfo start, Set<String> accountIds, int balanceType) throws BOSException {
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + T_TMP_Table + " ( \n");
        sql.append("  FAccountID, FCurrencyID, \n");
        if (balanceType == 2) {
            sql.append("  FAssGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  FAssGrpID, FMeasureUnitID, \n");
        }
        sql.append("  FBeginBalanceFor, FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor, FMonthPnlFor, FYearPnlFor, FEndBalanceFor, \n");
        sql.append("  FBeginBalanceLocal, FDebitLocal, FCreditLocal, FYearDebitLocal, FYearCreditLocal, FMonthPnlLocal, FYearPnlLocal, FEndBalanceLocal, \n");
        sql.append("  FBeginBalanceRpt, FDebitRpt, FCreditRpt, FYearDebitRpt, FYearCreditRpt, FMonthPnlRpt, FYearPnlRpt, FEndBalanceRpt, \n");
        sql.append("  FBeginQty, FDebitQty, FCreditQty, FYearDebitQty, FYearCreditQty, FMonthPnlQty, FYearPnlQty, FEndQty, \n");
        sql.append("  FDetailCount \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  b.FAccountID, b.FCurrencyID, \n");
        if (balanceType == 2) {
            sql.append("  b.FAssistGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  b.FAssistGrpID, b.FMeasureUnitID, \n");
        }
        sql.append("  b.FBeginBalanceFor * av.fdc, 0, 0, b.FYearDebitFor, b.FYearCreditFor, 0, b.FYearPnlFor * av.fdc, 0, \n");
        sql.append("  b.FBeginBalanceLocal * av.fdc, 0, 0, b.FYearDebitLocal, b.FYearCreditLocal, 0, b.FYearPnlLocal * av.fdc, 0, \n");
        sql.append("  b.FBeginBalanceRpt * av.fdc, 0, 0, b.FYearDebitRpt, b.FYearCreditRpt, 0, b.FYearPnlRpt * av.fdc, 0, \n");
        if (balanceType == 2) {
            sql.append("  b.FStandardBeginQty * av.fdc, 0, 0, b.FStandardYearDebitQty, b.FStandardYearCreditQty, 0, b.FStandardYearPnlQty * av.fdc, 0, \n");
        } else {
            sql.append("  b.FBeginQty * av.fdc, 0, 0, b.FYearDebitQty, b.FYearCreditQty, 0, b.FYearPnlQty * av.fdc, 0, \n");
        }
        sql.append("  0 \n");
        if (balanceType == 1) {
            sql.append("from T_GL_InitAccountBalance b \n");
            if (current.getId().equals((Object)start.getId())) {
                sql.append("join T_GL_FLAG f \n");
                sql.append("    on f.FOrgUnitID = b.FOrgUnitID and f.FName = 'glinit' and f.FValue = 'true' \n");
            }
        } else {
            sql.append("from T_GL_InitAssistBalance b \n");
            if (current.getId().equals((Object)start.getId())) {
                sql.append("join T_GL_FLAG f \n");
                sql.append("    on f.FOrgUnitID = b.FOrgUnitID and f.FName = 'astinit' and f.FKey = b.FAccountID and f.FValue = 'true' \n");
            }
        }
        sql.append("join T_BD_AccountView av on av.FID = b.FAccountID \n");
        if (balanceType == 3) {
            sql.append("join T_BD_AssistantHG hg on hg.FID = b.FAssistGrpID \n");
            sql.append("join T_BD_AsstAccount aa on aa.FID = hg.FAsstAccountID \n");
        }
        sql.append("where b.FOrgUnitID = ? \n");
        sql.append("  and av.FIsLeaf = 1 \n");
        if (T_TMP_Account != null) {
            sql.append("  and b.FAccountID in (select FID from " + T_TMP_Account + " where FIsLeaf = 1) \n");
        }
        if (accountIds.size() > 0) {
            if (accountIds.size() == 1) {
                sql.append("  and b.FAccountID = ? \n");
            } else {
                sql.append("  and b.FAccountID in " + GLBalanceRepairer.toInSql(accountIds) + " \n");
            }
        }
        sql.append("  and b.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
        sql.append("  and b.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
        if (balanceType == 3) {
            sql.append("  and av.FIsQty = 1 and aa.FIsQty = 1 \n");
        }
        Object[] ps = accountIds.size() == 1 ? new Object[]{companyId, accountIds.iterator().next()} : new Object[]{companyId};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])ps);
    }

    public static void insertBegin(Context ctx, Map params, String T_TMP_Table, String companyId, PeriodInfo period, PeriodInfo prePeriod, Set<String> accountIds, int balanceType, int balType) throws BOSException {
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        StringBuffer sql = new StringBuffer();
        boolean isNextYear = period.getPeriodYear() != prePeriod.getPeriodYear();
        sql.append("insert into " + T_TMP_Table + " ( \n");
        sql.append("  FAccountID, FCurrencyID, \n");
        if (balanceType == 2) {
            sql.append("  FAssGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  FAssGrpID, FMeasureUnitID, \n");
        }
        sql.append("  FBeginBalanceFor, FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor, FMonthPnlFor, FYearPnlFor, FEndBalanceFor, \n");
        sql.append("  FBeginBalanceLocal, FDebitLocal, FCreditLocal, FYearDebitLocal, FYearCreditLocal, FMonthPnlLocal, FYearPnlLocal, FEndBalanceLocal, \n");
        sql.append("  FBeginBalanceRpt, FDebitRpt, FCreditRpt, FYearDebitRpt, FYearCreditRpt, FMonthPnlRpt, FYearPnlRpt, FEndBalanceRpt, \n");
        sql.append("  FBeginQty, FDebitQty, FCreditQty, FYearDebitQty, FYearCreditQty, FMonthPnlQty, FYearPnlQty, FEndQty, \n");
        sql.append("  FDetailCount \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  b.FAccountID, b.FCurrencyID, \n");
        if (balanceType == 2) {
            sql.append("  b.FAssistGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  b.FAssistGrpID, b.FMeasureUnitID, \n");
        }
        if (isNextYear) {
            sql.append("  b.FEndBalanceFor, 0, 0, 0, 0, 0, 0, 0, \n");
            sql.append("  b.FEndBalanceLocal, 0, 0, 0, 0, 0, 0, 0, \n");
            sql.append("  b.FEndBalanceRpt, 0, 0, 0, 0, 0, 0, 0, \n");
            sql.append("  b.FEndQty, 0, 0, 0, 0, 0, 0, 0, \n");
        } else {
            sql.append("  b.FEndBalanceFor, 0, 0, b.FYearDebitFor, b.FYearCreditFor, 0, b.FYearPnlFor, 0, \n");
            sql.append("  b.FEndBalanceLocal, 0, 0, b.FYearDebitLocal, b.FYearCreditLocal, 0, b.FYearPnlLocal, 0, \n");
            sql.append("  b.FEndBalanceRpt, 0, 0, b.FYearDebitRpt, b.FYearCreditRpt, 0, b.FYearPnlRpt, 0, \n");
            sql.append("  b.FEndQty, 0, 0, b.FYearDebitQty, b.FYearCreditQty, 0, b.FYearPnlQty, 0, \n");
        }
        sql.append("  0 \n");
        sql.append("from " + GLBalanceUtils.getBalanceTable(balanceType, balType, null) + " b \n");
        sql.append("join T_BD_AccountView av on av.FID = b.FAccountID \n");
        if (balanceType == 3) {
            sql.append("join T_BD_AssistantHG hg on hg.FID = b.FAssistGrpID \n");
            sql.append("join T_BD_AsstAccount aa on aa.FID = hg.FAsstAccountID \n");
        }
        sql.append("where b.FOrgUnitID = ? \n");
        sql.append("  and b.FPeriod = ? \n");
        sql.append("  and av.FIsLeaf = 1 \n");
        if (T_TMP_Account != null) {
            sql.append("  and b.FAccountID in (select FID from " + T_TMP_Account + " where FIsLeaf = 1) \n");
        }
        if (accountIds.size() > 0) {
            if (accountIds.size() == 1) {
                sql.append("  and b.FAccountID = ? \n");
            } else {
                sql.append("  and b.FAccountID in " + GLBalanceRepairer.toInSql(accountIds) + " \n");
            }
        }
        if (balanceType == 3) {
            sql.append("  and av.FIsQty = 1 and aa.FIsQty = 1 \n");
        }
        if ((balanceType == 2 || balanceType == 3) && isNextYear) {
            sql.append("and (b.FEndBalanceFor <> 0 or b.FEndBalanceLocal <> 0 or b.FEndBalanceRpt <> 0 or b.FEndQty <> 0) \n");
        }
        Object[] ps = accountIds.size() == 1 ? new Object[]{companyId, prePeriod.getNumber(), accountIds.iterator().next()} : new Object[]{companyId, prePeriod.getNumber()};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])ps);
    }

    public static void insertCurrent(Context ctx, Map params, String T_TMP_Table, String companyId, PeriodInfo period, Set<String> accountIds, int balanceType, int balType) throws BOSException {
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        StringBuffer sql = new StringBuffer();
        ArrayList<String> ps = new ArrayList<String>();
        sql.append("insert into " + T_TMP_Table + " ( \n");
        sql.append("  FAccountID, FCurrencyID, \n");
        if (balanceType == 2) {
            sql.append("  FAssGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  FAssGrpID, FMeasureUnitID, \n");
        }
        sql.append("  FBeginBalanceFor, FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor, FMonthPnlFor, FYearPnlFor, FEndBalanceFor, \n");
        sql.append("  FBeginBalanceLocal, FDebitLocal, FCreditLocal, FYearDebitLocal, FYearCreditLocal, FMonthPnlLocal, FYearPnlLocal, FEndBalanceLocal, \n");
        sql.append("  FBeginBalanceRpt, FDebitRpt, FCreditRpt, FYearDebitRpt, FYearCreditRpt, FMonthPnlRpt, FYearPnlRpt, FEndBalanceRpt, \n");
        sql.append("  FBeginQty, FDebitQty, FCreditQty, FYearDebitQty, FYearCreditQty, FMonthPnlQty, FYearPnlQty, FEndQty, \n");
        sql.append("  FDetailCount \n");
        sql.append(") \n");
        sql.append("select \n");
        if (SQLUtil.isOracle(ctx)) {
            if (balanceType == 2 || balanceType == 3) {
                if (T_TMP_Account != null) {
                    sql.append("  /*+ LEADING(tav,v,ve,r) USE_HASH(v,ve,r) */ \n");
                } else {
                    sql.append("  /*+ LEADING(v,ve,r) USE_HASH(v,ve,r) */ \n");
                }
            } else if (T_TMP_Account != null) {
                sql.append("  /*+ LEADING(tav,v,ve) USE_HASH(v,ve) */ \n");
            } else {
                sql.append("  /*+ LEADING(v,ve) USE_HASH(v,ve) */ \n");
            }
        }
        sql.append("  ve.FAccountID, ve.FCurrencyID, \n");
        if (balanceType == 2) {
            sql.append("  r.FAssGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  r.FAssGrpID, case when r.FMeasureUnitID is null then '00000000-0000-0000-0000-0000000000005B825C57' else r.FMeasureUnitID end, \n");
        }
        if (balanceType == 1) {
            sql.append("  0, sum(ve.FOriginalAmount * ve.FEntryDC) FDebitFor, sum(ve.FOriginalAmount * (1 - ve.FEntryDC)) FCreditFor, 0, 0, \n");
            sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.fOriginalAmount else 0 end) FMonthPnlFor, 0, 0, \n");
            sql.append("  0, sum(ve.FLocalAmount * ve.FEntryDC) FDebitLocal, sum(ve.FLocalAmount * (1 - ve.FEntryDC)) FCreditLocal, 0, 0, \n");
            sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.fLocalAmount else 0 end) FMonthPnlLocal, 0, 0, \n");
            sql.append("  0, sum(ve.FReportingAmount * ve.FEntryDC) FDebitRpt, sum(ve.FReportingAmount * (1 - ve.FEntryDC)) FCreditRpt, 0, 0, \n");
            sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.fReportingAmount else 0 end) FMonthPnlRpt, 0, 0, \n");
            sql.append("  0, sum(ve.FStandardQuantity * ve.FEntryDC) FDebitQty, sum(ve.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty, 0, 0, \n");
            sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*ve.FStandardQuantity else 0 end) FMonthPnlQty, 0, 0, \n");
            sql.append("  count(ve.FID) \n");
        } else {
            sql.append("  0, sum(r.FOriginalAmount * ve.FEntryDC) FDebitFor, sum(r.FOriginalAmount * (1 - ve.FEntryDC)) FCreditFor, 0, 0, \n");
            sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.fOriginalAmount else 0 end) FMonthPnlFor, 0, 0, \n");
            sql.append("  0, sum(r.FLocalAmount * ve.FEntryDC) FDebitLocal, sum(r.FLocalAmount * (1 - ve.FEntryDC)) FCreditLocal, 0, 0, \n");
            sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.fLocalAmount else 0 end) FMonthPnlLocal, 0, 0, \n");
            sql.append("  0, sum(r.FReportingAmount * ve.FEntryDC) FDebitRpt, sum(r.FReportingAmount * (1 - ve.FEntryDC)) FCreditRpt, 0, 0, \n");
            sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.fReportingAmount else 0 end) FMonthPnlRpt, 0, 0, \n");
            if (balanceType == 2) {
                sql.append("  0, sum(r.FStandardQuantity * ve.FEntryDC) FDebitQty, sum(r.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQty, 0, 0, \n");
                sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.FStandardQuantity else 0 end) FMonthPnlQty, 0, 0, \n");
            } else {
                sql.append("  0, sum(r.FQuantity * ve.FEntryDC) FDebitQty, sum(r.FQuantity * (1 - ve.FEntryDC)) FCreditQty, 0, 0, \n");
                sql.append("  sum(case when (acctType.FProperty = 4 or (acctType.FProperty in (8, 12, 13, 14) and av.FPLType <> 0)) and v.FSourceType <> 1 then (2 * ve.FEntryDC - 1)*r.FQuantity else 0 end) FMonthPnlQty, 0, 0, \n");
            }
            sql.append("  count(r.FID) \n");
        }
        sql.append("from T_GL_Voucher v \n");
        sql.append("inner join T_GL_VoucherEntry ve on ve.FBillID = v.FID \n");
        sql.append("join T_BD_AccountView av on av.FID = ve.FAccountID \n");
        if (T_TMP_Account != null) {
            sql.append("  join " + T_TMP_Account + " tav on tav.FID = ve.FAccountID and tav.FIsLeaf = 1 \n");
        }
        sql.append("inner join t_bd_accounttype acctType on acctType.fid = av.faccounttypeid \n");
        if (balanceType == 2 || balanceType == 3) {
            sql.append("inner join T_GL_VoucherAssistRecord r on r.FEntryID = ve.FID \n");
            if (balanceType == 3) {
                sql.append("inner join T_BD_AssistantHG hg on hg.FID = r.FAssGrpID \n");
                sql.append("inner join T_BD_AsstAccount aa on aa.FID = hg.FAsstAccountID \n");
            }
        }
        sql.append("where v.FCompanyID = ? \n");
        sql.append("and v.FPeriodID = ? \n");
        sql.append("and ve.FCompanyID = ? \n");
        sql.append("and ve.FPeriodID = ? \n");
        ps.add(companyId);
        ps.add(period.getId().toString());
        ps.add(companyId);
        ps.add(period.getId().toString());
        if (balanceType == 2 || balanceType == 3) {
            sql.append("and r.FCompanyID = ? \n");
            sql.append("and r.FPeriodID = ? \n");
            ps.add(companyId);
            ps.add(period.getId().toString());
            sql.append("and r.FAssGrpID is not null \n");
            if (balanceType == 3) {
                sql.append("and av.FIsQty = 1 and aa.FIsQty = 1 \n");
            }
        }
        if (balType == 1) {
            sql.append("        and v.FbizStatus <> 0 and v.FbizStatus <> 2 \n");
        } else {
            sql.append("        and v.FbizStatus = 5 \n");
        }
        if (accountIds.size() > 0) {
            if (accountIds.size() == 1) {
                sql.append("  and ve.FAccountID = ? \n");
                ps.add(accountIds.iterator().next());
                if (balanceType == 2 || balanceType == 3) {
                    sql.append("  and r.FAccountID = ? \n");
                    ps.add(accountIds.iterator().next());
                }
            } else {
                sql.append("  and ve.FAccountID in " + GLBalanceRepairer.toInSql(accountIds) + " \n");
                if (balanceType == 2 || balanceType == 3) {
                    sql.append("  and r.FAccountID in " + GLBalanceRepairer.toInSql(accountIds) + " \n");
                }
            }
        }
        sql.append("group by ve.FAccountID, ve.FCurrencyID \n");
        if (balanceType == 2) {
            sql.append("  ,r.FAssGrpID \n");
        } else if (balanceType == 3) {
            sql.append("  ,r.FAssGrpID, r.FMeasureUnitID \n");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])ps.toArray());
    }

    private static void buildBalance(Context ctx, Map params, String T_TMP_Table, String companyId, PeriodInfo period, Set<String> accountIds, int balanceType, int balType, String currencyId) throws BOSException {
        String T_AccountBalance = GLBalanceUtils.getBalanceTable(balanceType, balType, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + T_AccountBalance + " ( \n");
        sql.append("  FOrgUnitID, FPeriod, FAccountID, \n");
        if (balanceType == 2) {
            sql.append("  FAssistGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  FAssistGrpID, FMeasureUnitID, \n");
        }
        if (isForCurrency) {
            sql.append("  FCurrencyID, \n");
            sql.append("  FBeginBalanceFor, FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor, FMonthPnlFor, FYearPnlFor, FEndBalanceFor, \n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("  FBeginBalanceLocal, FDebitLocal, FCreditLocal, FYearDebitLocal, FYearCreditLocal, FMonthPnlLocal, FYearPnlLocal, FEndBalanceLocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  FBeginBalanceRpt, FDebitRpt, FCreditRpt, FYearDebitRpt, FYearCreditRpt, FMonthPnlRpt, FYearPnlRpt, FEndBalanceRpt, \n");
        }
        sql.append("  FBeginQty, FDebitQty, FCreditQty, FYearDebitQty, FYearCreditQty, FMonthPnlQty, FYearPnlQty, FEndQty, \n");
        sql.append("  FDetailCount \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  ?, ?, FAccountID, \n");
        if (balanceType == 2) {
            sql.append("  FAssGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  FAssGrpID, FMeasureUnitID, \n");
        }
        if (isForCurrency) {
            sql.append("  FCurrencyID, \n");
            sql.append("  sum(FBeginBalanceFor), \n");
            sql.append("  sum(FDebitFor), sum(FCreditFor), \n");
            sql.append("  sum(FYearDebitFor+FDebitFor), sum(FYearCreditFor+FCreditFor), \n");
            sql.append("  sum(FMonthPnlFor), sum(FYearPnlFor+FMonthPnlFor), \n");
            sql.append("  sum(FBeginBalanceFor) + sum(FDebitFor) - sum(FCreditFor), \n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("  sum(FBeginBalanceLocal), \n");
            sql.append("  sum(FDebitLocal), sum(FCreditLocal), \n");
            sql.append("  sum(FYearDebitLocal+FDebitLocal), sum(FYearCreditLocal+FCreditLocal), \n");
            sql.append("  sum(FMonthPnlLocal), sum(FYearPnlLocal+FMonthPnlLocal), \n");
            sql.append("  sum(FBeginBalanceLocal) + sum(FDebitLocal) - sum(FCreditLocal), \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  sum(FBeginBalanceRpt), \n");
            sql.append("  sum(FDebitRpt), sum(FCreditRpt), \n");
            sql.append("  sum(FYearDebitRpt+FDebitRpt), sum(FYearCreditRpt+FCreditRpt), \n");
            sql.append("  sum(FMonthPnlRpt), sum(FYearPnlRpt+FMonthPnlRpt), \n");
            sql.append("  sum(FBeginBalanceRpt) + sum(FDebitRpt) - sum(FCreditRpt), \n");
        }
        sql.append("  sum(FBeginQty), \n");
        sql.append("  sum(FDebitQty), sum(FCreditQty), \n");
        sql.append("  sum(FYearDebitQty+FDebitQty), sum(FYearCreditQty+FCreditQty), \n");
        sql.append("  sum(FMonthPnlQty), sum(FYearPnlQty+FMonthPnlQty), \n");
        sql.append("  sum(FBeginQty) + sum(FDebitQty) - sum(FCreditQty), \n");
        sql.append("  sum(FDetailCount) \n");
        sql.append("from " + T_TMP_Table + " \n");
        if (balanceType == 3) {
            sql.append("where FMeasureUnitID is not null \n");
        }
        sql.append("group by FAccountID \n");
        if (isForCurrency) {
            sql.append("  ,FCurrencyID \n");
        }
        if (balanceType == 2) {
            sql.append("  ,FAssGrpID \n");
        } else if (balanceType == 3) {
            sql.append("  ,FAssGrpID, FMeasureUnitID \n");
        }
        Object[] ps = new Object[]{companyId, period.getNumber()};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])ps);
    }

    private static void buildParent(Context ctx, Map params, String companyId, PeriodInfo period, Set<String> accountIds, int balType, String currencyId) throws BOSException {
        if (SQLUtil.isMSSQLSERVER(ctx)) {
            GLBalanceRepairer.buildParent2(ctx, params, companyId, period, accountIds, balType, currencyId);
            return;
        }
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        String T_AccountBalance = GLBalanceUtils.getBalanceTable(1, balType, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + T_AccountBalance + " ( \n");
        sql.append("  FOrgUnitID, FPeriod, FAccountID, \n");
        if (isForCurrency) {
            sql.append("  FCurrencyID, \n");
            sql.append("  FBeginBalanceFor, FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor, FMonthPnlFor, FYearPnlFor, FEndBalanceFor, \n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("  FBeginBalanceLocal, FDebitLocal, FCreditLocal, FYearDebitLocal, FYearCreditLocal, FMonthPnlLocal, FYearPnlLocal, FEndBalanceLocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  FBeginBalanceRpt, FDebitRpt, FCreditRpt, FYearDebitRpt, FYearCreditRpt, FMonthPnlRpt, FYearPnlRpt, FEndBalanceRpt, \n");
        }
        sql.append("  FBeginQty, FDebitQty, FCreditQty, FYearDebitQty, FYearCreditQty, FMonthPnlQty, FYearPnlQty, FEndQty, \n");
        sql.append("  FDetailCount \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  t.FOrgUnitID, t.FPeriod, pav.FID FAccountID, \n");
        if (isForCurrency) {
            sql.append("  t.FCurrencyID, \n");
            sql.append("  sum(FBeginBalanceFor), \n");
            sql.append("  sum(FDebitFor), sum(FCreditFor), \n");
            sql.append("  sum(FYearDebitFor), sum(FYearCreditFor), \n");
            sql.append("  sum(FMonthPnlFor), sum(FYearPnlFor), \n");
            sql.append("  sum(FEndBalanceFor), \n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("  sum(FBeginBalanceLocal), \n");
            sql.append("  sum(FDebitLocal), sum(FCreditLocal), \n");
            sql.append("  sum(FYearDebitLocal), sum(FYearCreditLocal), \n");
            sql.append("  sum(FMonthPnlLocal), sum(FYearPnlLocal), \n");
            sql.append("  sum(FEndBalanceLocal), \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  sum(FBeginBalanceRpt), \n");
            sql.append("  sum(FDebitRpt), sum(FCreditRpt), \n");
            sql.append("  sum(FYearDebitRpt), sum(FYearCreditRpt), \n");
            sql.append("  sum(FMonthPnlRpt), sum(FYearPnlRpt), \n");
            sql.append("  sum(FEndBalanceRpt), \n");
        }
        sql.append("  sum(case when pav.FIsQty = 1 then FBeginQty else 0 end), \n");
        sql.append("  sum(case when pav.FIsQty = 1 then FDebitQty else 0 end), sum(case when pav.FIsQty = 1 then FCreditQty else 0 end), \n");
        sql.append("  sum(case when pav.FIsQty = 1 then FYearDebitQty else 0 end), sum(case when pav.FIsQty = 1 then FYearCreditQty else 0 end), \n");
        sql.append("  sum(case when pav.FIsQty = 1 then FMonthPnlQty else 0 end), sum(case when pav.FIsQty = 1 then FYearPnlQty else 0 end), \n");
        sql.append("  sum(case when pav.FIsQty = 1 then FEndQty else 0 end), \n");
        sql.append("  sum(FDetailCount) \n");
        sql.append("from " + T_AccountBalance + " t \n");
        sql.append("join t_BD_AccountView av on av.FID = t.FAccountID \n");
        sql.append("join t_BD_AccountView pav on pav.Fcompanyid = av.Fcompanyid and pav.faccounttableid = av.faccounttableid \n");
        if (SQLUtil.isOracle(ctx) || SQLUtil.isMSSQLSERVER(ctx) || SQLUtil.isPG(ctx)) {
            sql.append("  and av.FLongNumber like concat(pav.FLongNumber,'!%') \n");
        } else {
            sql.append("  and charindex(pav.FLongNumber||'!', av.FLongNumber) = 1 \n");
        }
        sql.append("where t.FOrgUnitID = ? \n");
        sql.append("  and t.FPeriod = ? \n");
        sql.append("  and av.FIsLeaf = 1 \n");
        if (T_TMP_Account != null) {
            sql.append("  and pav.FID in (select FID from " + T_TMP_Account + " where FIsLeaf = 0) \n");
        }
        if (accountIds.size() > 0) {
            if (accountIds.size() == 1) {
                sql.append("  and pav.FID = ? \n");
            } else {
                sql.append("  and pav.FID in " + GLBalanceRepairer.toInSql(accountIds) + " \n");
            }
        }
        sql.append("group by t.FOrgUnitID, t.FPeriod, pav.FID \n");
        if (isForCurrency) {
            sql.append("  ,t.FCurrencyID \n");
        }
        Object[] ps = accountIds.size() == 1 ? new Object[]{companyId, period.getNumber(), accountIds.iterator().next()} : new Object[]{companyId, period.getNumber()};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])ps);
    }

    private static void buildParent2(Context ctx, Map params, String companyId, PeriodInfo period, Set<String> accountIds, int balType, String currencyId) throws BOSException {
        String T_AccountBalance = GLBalanceUtils.getBalanceTable(1, balType, currencyId);
        StringBuffer sql = new StringBuffer();
        sql.append("select max(av.FLevel) \n");
        sql.append("from " + T_AccountBalance + " t \n");
        sql.append("join T_BD_AccountView av on av.FID = t.FAccountID \n");
        sql.append("where t.FOrgUnitID = ? and t.FPeriod = ? \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, period.getNumber()});
        int maxLevel = 0;
        try {
            if (rs.next()) {
                maxLevel = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (maxLevel <= 1) {
            return;
        }
        for (int level = maxLevel; level > 1; --level) {
            GLBalanceRepairer.doBuildParent2(ctx, params, companyId, period, accountIds, balType, currencyId, level);
        }
    }

    private static void doBuildParent2(Context ctx, Map params, String companyId, PeriodInfo period, Set<String> accountIds, int balType, String currencyId, int level) throws BOSException {
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        String T_AccountBalance = GLBalanceUtils.getBalanceTable(1, balType, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + T_AccountBalance + " ( \n");
        sql.append("  FOrgUnitID, FPeriod, FAccountID, \n");
        if (isForCurrency) {
            sql.append("  FCurrencyID, \n");
            sql.append("  FBeginBalanceFor, FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor, FMonthPnlFor, FYearPnlFor, FEndBalanceFor, \n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("  FBeginBalanceLocal, FDebitLocal, FCreditLocal, FYearDebitLocal, FYearCreditLocal, FMonthPnlLocal, FYearPnlLocal, FEndBalanceLocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  FBeginBalanceRpt, FDebitRpt, FCreditRpt, FYearDebitRpt, FYearCreditRpt, FMonthPnlRpt, FYearPnlRpt, FEndBalanceRpt, \n");
        }
        sql.append("  FBeginQty, FDebitQty, FCreditQty, FYearDebitQty, FYearCreditQty, FMonthPnlQty, FYearPnlQty, FEndQty, \n");
        sql.append("  FDetailCount \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  ?, ?, av.FParentID FAccountID, \n");
        if (isForCurrency) {
            sql.append("  t.FCurrencyID, \n");
            sql.append("  sum(FBeginBalanceFor), \n");
            sql.append("  sum(FDebitFor), sum(FCreditFor), \n");
            sql.append("  sum(FYearDebitFor), sum(FYearCreditFor), \n");
            sql.append("  sum(FMonthPnlFor), sum(FYearPnlFor), \n");
            sql.append("  sum(FEndBalanceFor), \n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("  sum(FBeginBalanceLocal), \n");
            sql.append("  sum(FDebitLocal), sum(FCreditLocal), \n");
            sql.append("  sum(FYearDebitLocal), sum(FYearCreditLocal), \n");
            sql.append("  sum(FMonthPnlLocal), sum(FYearPnlLocal), \n");
            sql.append("  sum(FEndBalanceLocal), \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  sum(FBeginBalanceRpt), \n");
            sql.append("  sum(FDebitRpt), sum(FCreditRpt), \n");
            sql.append("  sum(FYearDebitRpt), sum(FYearCreditRpt), \n");
            sql.append("  sum(FMonthPnlRpt), sum(FYearPnlRpt), \n");
            sql.append("  sum(FEndBalanceRpt), \n");
        }
        sql.append("  sum(case when pav.FIsQty = 1 then FBeginQty else 0 end), \n");
        sql.append("  sum(case when pav.FIsQty = 1 then FDebitQty else 0 end), sum(case when pav.FIsQty = 1 then FCreditQty else 0 end), \n");
        sql.append("  sum(case when pav.FIsQty = 1 then FYearDebitQty else 0 end), sum(case when pav.FIsQty = 1 then FYearCreditQty else 0 end), \n");
        sql.append("  sum(case when pav.FIsQty = 1 then FMonthPnlQty else 0 end), sum(case when pav.FIsQty = 1 then FYearPnlQty else 0 end), \n");
        sql.append("  sum(case when pav.FIsQty = 1 then FEndQty else 0 end), \n");
        sql.append("  sum(FDetailCount) \n");
        sql.append("from " + T_AccountBalance + " t \n");
        sql.append("join t_BD_AccountView av on av.FID = t.FAccountID \n");
        sql.append("join t_BD_AccountView pav on pav.FID = av.FParentID \n");
        sql.append("where t.FOrgUnitID = ? \n");
        sql.append("  and t.FPeriod = ? \n");
        sql.append("  and av.FLevel = ? \n");
        if (T_TMP_Account != null) {
            sql.append("  and av.FParentID in (select FID from " + T_TMP_Account + " where FIsLeaf = 0) \n");
        }
        if (accountIds.size() > 0) {
            if (accountIds.size() == 1) {
                sql.append("  and av.FParentID = ? \n");
            } else {
                sql.append("  and av.FParentID in " + GLBalanceRepairer.toInSql(accountIds) + " \n");
            }
        }
        sql.append("group by av.FParentID \n");
        if (isForCurrency) {
            sql.append("  ,t.FCurrencyID \n");
        }
        Object[] ps = accountIds.size() == 1 ? new Object[]{companyId, period.getNumber(), companyId, period.getNumber(), level, accountIds.iterator().next()} : new Object[]{companyId, period.getNumber(), companyId, period.getNumber(), level};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])ps);
    }

    private static void buildFirst(Context ctx, Map params, String companyId, PeriodInfo current, PeriodInfo start, PeriodInfo first, Set<String> accountIds, int balanceType, int balType, String currencyId) throws BOSException {
        String T_TMP_Account = (String)params.get("T_TMP_Account");
        String T_AccountBalance = GLBalanceUtils.getBalanceTable(balanceType, balType, currencyId);
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + T_AccountBalance + " ( \n");
        sql.append("  FOrgUnitID, FPeriod, FAccountID, \n");
        if (balanceType == 2) {
            sql.append("  FAssistGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  FAssistGrpID, FMeasureUnitID, \n");
        }
        if (isForCurrency) {
            sql.append("  FCurrencyID, \n");
            sql.append("  FBeginBalanceFor, FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor, FEndBalanceFor, \n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append("  FBeginBalanceLocal, FDebitLocal, FCreditLocal, FYearDebitLocal, FYearCreditLocal, FEndBalanceLocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("  FBeginBalanceRpt, FDebitRpt, FCreditRpt, FYearDebitRpt, FYearCreditRpt, FEndBalanceRpt, \n");
        }
        sql.append("  FBeginQty, FDebitQty, FCreditQty, FYearDebitQty, FYearCreditQty, FEndQty, \n");
        sql.append("  FDetailCount \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("  b.FOrgUnitID, ?, b.FAccountID, \n");
        if (balanceType == 2) {
            sql.append("  b.FAssistGrpID, \n");
        } else if (balanceType == 3) {
            sql.append("  b.FAssistGrpID, b.FMeasureUnitID, \n");
        }
        if (balanceType == 1) {
            if (isForCurrency) {
                sql.append("  b.FCurrencyID, \n");
                sql.append("  b.FBeginBalanceFor * av.fdc - b.FYearDebitFor + b.FYearCreditFor, \n");
                sql.append("  b.FYearDebitFor, b.FYearCreditFor, \n");
                sql.append("  b.FYearDebitFor, b.FYearCreditFor, \n");
                sql.append("  b.FBeginBalanceFor * av.fdc, \n");
            }
            if (isLocalCurrency || isForCurrency) {
                sql.append("  b.FBeginBalanceLocal * av.fdc - b.FYearDebitLocal + b.FYearCreditLocal, \n");
                sql.append("  b.FYearDebitLocal, b.FYearCreditLocal, \n");
                sql.append("  b.FYearDebitLocal, b.FYearCreditLocal, \n");
                sql.append("  b.FBeginBalanceLocal * av.fdc, \n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("  b.FBeginBalanceRpt * av.fdc - b.FYearDebitRpt + b.FYearCreditRpt, \n");
                sql.append("  b.FYearDebitRpt, b.FYearCreditRpt, \n");
                sql.append("  b.FYearDebitRpt, b.FYearCreditRpt, \n");
                sql.append("  b.FBeginBalanceRpt * av.fdc, \n");
            }
            sql.append("  b.FBeginQty * av.fdc - b.FYearDebitQty + b.FYearCreditQty, \n");
            sql.append("  b.FYearDebitQty, b.FYearCreditQty, \n");
            sql.append("  b.FYearDebitQty, b.FYearCreditQty, \n");
            sql.append("  b.FBeginQty * av.fdc, \n");
        } else {
            if (isForCurrency) {
                sql.append("  b.FCurrencyID, \n");
                sql.append("  b.FBeginBalanceFor * av.fdc - b.FYearDebitFor + b.FYearCreditFor, \n");
                sql.append("  b.FYearDebitFor, b.FYearCreditFor, \n");
                sql.append("  b.FYearDebitFor, b.FYearCreditFor, \n");
                sql.append("  b.FBeginBalanceFor * av.fdc, \n");
            }
            if (isLocalCurrency || isForCurrency) {
                sql.append("  b.FBeginBalanceLocal * av.fdc - b.FYearDebitLocal + b.FYearCreditLocal, \n");
                sql.append("  b.FYearDebitLocal, b.FYearCreditLocal, \n");
                sql.append("  b.FYearDebitLocal, b.FYearCreditLocal, \n");
                sql.append("  b.FBeginBalanceLocal * av.fdc, \n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("  b.FBeginBalanceRpt * av.fdc - b.FYearDebitRpt + b.FYearCreditRpt, \n");
                sql.append("  b.FYearDebitRpt, b.FYearCreditRpt, \n");
                sql.append("  b.FYearDebitRpt, b.FYearCreditRpt, \n");
                sql.append("  b.FBeginBalanceRpt * av.fdc, \n");
            }
            if (balanceType == 2) {
                sql.append("  b.FStandardBeginQty * av.fdc - b.FStandardYearDebitQty + b.FStandardYearCreditQty, \n");
                sql.append("  b.FStandardYearDebitQty, b.FStandardYearCreditQty, \n");
                sql.append("  b.FStandardYearDebitQty, b.FStandardYearCreditQty, \n");
                sql.append("  b.FStandardBeginQty * av.fdc, \n");
            } else {
                sql.append("  b.FBeginQty * av.fdc - b.FYearDebitQty + b.FYearCreditQty, \n");
                sql.append("  b.FYearDebitQty, b.FYearCreditQty, \n");
                sql.append("  b.FYearDebitQty, b.FYearCreditQty, \n");
                sql.append("  b.FBeginQty * av.fdc, \n");
            }
        }
        sql.append("  0 \n");
        if (balanceType == 1) {
            sql.append("from T_GL_InitAccountBalance b \n");
            if (current.getId().equals((Object)start.getId())) {
                sql.append("join T_GL_FLAG f \n");
                sql.append("    on f.FOrgUnitID = b.FOrgUnitID and f.FName = 'glinit' and f.FValue = 'true' \n");
            }
        } else {
            sql.append("from T_GL_InitAssistBalance b \n");
            if (current.getId().equals((Object)start.getId())) {
                sql.append("join T_GL_FLAG f \n");
                sql.append("    on f.FOrgUnitID = b.FOrgUnitID and f.FName = 'astinit' and f.FKey = b.FAccountID and f.FValue = 'true' \n");
            }
        }
        sql.append("join T_BD_AccountView av on av.FID = b.FAccountID \n");
        if (balanceType == 3) {
            sql.append("join T_BD_AssistantHG hg on hg.FID = b.FAssistGrpID \n");
            sql.append("join T_BD_AsstAccount aa on aa.FID = hg.FAsstAccountID \n");
        }
        sql.append("where b.FOrgUnitID = ? \n");
        if (T_TMP_Account != null) {
            sql.append("  and b.FAccountID in (select FID from " + T_TMP_Account + ") \n");
        }
        if (accountIds.size() > 0) {
            if (accountIds.size() == 1) {
                sql.append("  and b.FAccountID = ? \n");
            } else {
                sql.append("  and b.FAccountID in " + GLBalanceRepairer.toInSql(accountIds) + " \n");
            }
        }
        if (isForCurrency) {
            sql.append("  and b.fcurrencyid <> '").append("11111111-1111-1111-1111-111111111111DEB58FDC").append("' \n");
            sql.append("  and b.fcurrencyid <> '").append("22222222-2222-2222-2222-222222222222DEB58FDC").append("' \n");
        } else {
            sql.append("  and b.fcurrencyid = '").append(currencyId).append("' \n");
        }
        if (balanceType == 3) {
            sql.append("  and b.FMeasureUnitID is not null \n");
            sql.append("  and av.FIsQty = 1 and aa.FIsQty = 1 \n");
        }
        Object[] ps = accountIds.size() == 1 ? new Object[]{first.getNumber(), companyId, accountIds.iterator().next()} : new Object[]{first.getNumber(), companyId};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])ps);
    }

    private static String toInSql(Set ids) {
        StringBuffer sql = new StringBuffer();
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            Object o;
            if (sql.length() > 0) {
                sql.append(",");
            }
            if ((o = it.next()) instanceof String) {
                sql.append("'").append(o).append("'");
                continue;
            }
            sql.append(o);
        }
        return "(" + sql.toString() + ")";
    }

    public static void main(String[] args) {
        ArrayList constrasts = new ArrayList();
        HashMap<String, Object> last = new HashMap<String, Object>();
        last.put("periodNumber", 201713);
        last.put("disableAcctTableID", "table201713");
        constrasts.add(last);
        last = new HashMap();
        last.put("periodNumber", 201813);
        last.put("disableAcctTableID", "table201813");
        constrasts.add(last);
        last = new HashMap();
        last.put("periodNumber", 999912);
        last.put("disableAcctTableID", "table999912");
        constrasts.add(last);
        ArrayList<PeriodInfo> periods = new ArrayList<PeriodInfo>();
        PeriodInfo p = new PeriodInfo();
        p.setNumber(201612);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201613);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201701);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201702);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201703);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201704);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201705);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201706);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201707);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201708);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201709);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201710);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201711);
        periods.add(p);
        p = new PeriodInfo();
        p.setNumber(201712);
        periods.add(p);
        int pIndex = 0;
        for (int cIndex = 0; cIndex < constrasts.size(); ++cIndex) {
            Map constrast = (Map)constrasts.get(cIndex);
            int periodNumber = (Integer)constrast.get("periodNumber");
            String disableAcctTableID = (String)constrast.get("disableAcctTableID");
            ArrayList<PeriodInfo> disablePeriods = new ArrayList<PeriodInfo>();
            while (pIndex < periods.size()) {
                PeriodInfo period = (PeriodInfo)periods.get(pIndex);
                if (period.getNumber() < periodNumber) {
                    disablePeriods.add(period);
                } else if (period.getNumber() >= periodNumber) {
                    if (period.getNumber() != periodNumber) break;
                    disablePeriods.add(period);
                    break;
                }
                ++pIndex;
            }
            if (disablePeriods.size() <= 0) continue;
            System.out.println(disableAcctTableID + " " + disablePeriods);
        }
    }
}

