/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.BizBalanceException;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.IBizCheckBalance;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class GLBizCheckBalance
implements IBizCheckBalance {
    public BizCheckResult checkHasBalance(Context ctx, BOSUuid id) throws BizBalanceException {
        try {
            if (new CustomerInfo().getBOSType().toString().equals(id.getType().toString())) {
                return this.checkCustomer(ctx, id);
            }
            if (new SupplierInfo().getBOSType().toString().equals(id.getType().toString())) {
                return this.checkSupplier(ctx, id);
            }
            return null;
        }
        catch (Exception e) {
            throw new BizBalanceException(BizBalanceException.SQL_ERR, (Throwable)e);
        }
    }

    protected CompanyOrgUnitCollection getCompanys(Context ctx, Set<String> companyIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", companyIds, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo item = new SorterItemInfo("longNumber");
        item.setSortType(SortType.ASCEND);
        sorter.add(item);
        view.setSorter(sorter);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        if (coll == null) {
            coll = new CompanyOrgUnitCollection();
        }
        return coll;
    }

    public BizCheckResult checkCustomer(Context ctx, BOSUuid id) throws BOSException, EASBizException, SQLException {
        HashSet<String> companyIds = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT cc.FCOMORGID \n");
        sql.append("FROM T_BD_CUSTOMERCOMPANYINFO cc \n");
        sql.append("join T_ORG_Company c on c.FID = cc.FCOMORGID \n");
        sql.append("where cc.FCUSTOMERID = ? \n");
        sql.append("and c.FIsBizUnit = 1 \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{id.toString()});
        while (rs.next()) {
            String companyId = rs.getString("FCOMORGID");
            PeriodInfo current = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
            if (current == null) continue;
            ArrayList<Object> param = new ArrayList<Object>();
            sql.setLength(0);
            sql.append("select top 1 1 \n");
            sql.append("from T_GL_AssistBalance_1F b \n");
            sql.append("join T_BD_AssistantHG hg on hg.FID = b.FASSISTGRPID \n");
            sql.append("where b.FOrgUnitID = ? \n");
            sql.append("and b.FPeriod >= ? \n");
            sql.append("and hg.FCustomerID = ? \n");
            sql.append("and  \n");
            sql.append("    b.FPeriod = ? and (b.FEndBalanceFor <> 0 or b.FEndBalanceLocal <> 0 or b.FEndQty <> 0) \n");
            sql.append(" union all \n");
            sql.append("select top 1 1 \n");
            sql.append("from T_GL_AssistBalance_5F b \n");
            sql.append("join T_BD_AssistantHG hg on hg.FID = b.FASSISTGRPID \n");
            sql.append("where b.FOrgUnitID = ? \n");
            sql.append("and b.FPeriod >= ? \n");
            sql.append("and hg.FCustomerID = ? \n");
            sql.append("and  \n");
            sql.append("    b.FPeriod = ? and (b.FEndBalanceFor <> 0 or b.FEndBalanceLocal <> 0 or b.FEndQty <> 0) \n");
            sql.append(" \n");
            param.add(companyId);
            param.add(new Integer(current.getNumber()));
            param.add(id.toString());
            param.add(new Integer(current.getNumber()));
            param.add(companyId);
            param.add(new Integer(current.getNumber()));
            param.add(id.toString());
            param.add(new Integer(current.getNumber()));
            IRowSet crs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
            if (crs.next()) {
                companyIds.add(companyId);
            }
            if (companyIds.size() < 4) continue;
            break;
        }
        BizCheckResult result = null;
        if (companyIds.size() > 0) {
            HashMap<String, String> detailMap = new HashMap<String, String>();
            StringBuffer detail = new StringBuffer();
            result = new BizCheckResult(true, null, detailMap);
            CompanyOrgUnitCollection coll = this.getCompanys(ctx, companyIds);
            for (int i = 0; i < coll.size() && i < 3; ++i) {
                CompanyOrgUnitInfo company = coll.get(i);
                detail.append(company.getName() + "[" + company.getNumber() + "],");
            }
            if (coll.size() == 4) {
                detail.append("...");
            } else {
                detail.deleteCharAt(detail.lastIndexOf(","));
            }
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"BalanceAndDealNotZero", (Locale)ctx.getLocale());
            detailMap.put("bizType", detail.toString() + msg);
            return result;
        }
        return new BizCheckResult(false);
    }

    public BizCheckResult checkSupplier(Context ctx, BOSUuid id) throws BOSException, EASBizException, SQLException {
        HashSet<String> companyIds = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT sc.FCOMORGID \n");
        sql.append("FROM T_BD_SUPPLIERCOMPANYINFO sc \n");
        sql.append("join T_ORG_Company c on c.FID = sc.FCOMORGID \n");
        sql.append("where sc.FSUPPLIERID = ? \n");
        sql.append("and c.FIsBizUnit = 1 \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{id.toString()});
        while (rs.next()) {
            String companyId = rs.getString("FCOMORGID");
            PeriodInfo current = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
            if (current == null) continue;
            ArrayList<Object> param = new ArrayList<Object>();
            sql.setLength(0);
            sql.append("select top 1 1 \n");
            sql.append("from T_GL_AssistBalance_1F b \n");
            sql.append("join T_BD_AssistantHG hg on hg.FID = b.FASSISTGRPID \n");
            sql.append("where b.FOrgUnitID = ? \n");
            sql.append("and b.FPeriod >= ? \n");
            sql.append("and hg.FPROVIDERID = ? \n");
            sql.append("and  \n");
            sql.append("    b.FPeriod = ? and (b.FEndBalanceFor <> 0 or b.FEndBalanceLocal <> 0 or b.FEndQty <> 0) \n");
            sql.append(" union all \n");
            sql.append("select top 1 1 \n");
            sql.append("from T_GL_AssistBalance_5F b \n");
            sql.append("join T_BD_AssistantHG hg on hg.FID = b.FASSISTGRPID \n");
            sql.append("where b.FOrgUnitID = ? \n");
            sql.append("and b.FPeriod >= ? \n");
            sql.append("and hg.FPROVIDERID = ? \n");
            sql.append("and  \n");
            sql.append("    b.FPeriod = ? and (b.FEndBalanceFor <> 0 or b.FEndBalanceLocal <> 0 or b.FEndQty <> 0) \n");
            param.add(companyId);
            param.add(new Integer(current.getNumber()));
            param.add(id.toString());
            param.add(new Integer(current.getNumber()));
            param.add(companyId);
            param.add(new Integer(current.getNumber()));
            param.add(id.toString());
            param.add(new Integer(current.getNumber()));
            IRowSet crs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
            if (crs.next()) {
                companyIds.add(companyId);
            }
            if (companyIds.size() < 4) continue;
            break;
        }
        BizCheckResult result = null;
        if (companyIds.size() > 0) {
            HashMap<String, String> detailMap = new HashMap<String, String>();
            StringBuffer detail = new StringBuffer();
            result = new BizCheckResult(true, null, detailMap);
            CompanyOrgUnitCollection coll = this.getCompanys(ctx, companyIds);
            for (int i = 0; i < coll.size() && i < 3; ++i) {
                CompanyOrgUnitInfo company = coll.get(i);
                detail.append(company.getName() + "[" + company.getNumber() + "],");
            }
            if (coll.size() == 4) {
                detail.append("...");
            } else {
                detail.deleteCharAt(detail.lastIndexOf(","));
            }
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"BalanceAndDealNotZero", (Locale)ctx.getLocale());
            detailMap.put("bizType", detail.toString() + msg);
            return result;
        }
        return new BizCheckResult(false);
    }
}

