/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOtherDealOrgChange;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AutoAssistantHGUpdateFacadeFactory;
import com.kingdee.eas.fi.gl.GLBaseDataCheckException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class GLCostOrgHasDeal
implements IOtherDealOrgChange {
    private static Logger logger = Logger.getLogger((String)GLCostOrgHasDeal.class.getName());

    public void OrgUpdateAfter(Context ctx, FullOrgUnitInfo model) throws BOSException, EASBizException {
    }

    public void afterOrgAddNew(Context ctx, FullOrgUnitInfo model) throws BOSException, EASBizException {
    }

    private void dealCostOrgAddNew(Context ctx, FullOrgUnitInfo model) throws BOSException, EASBizException {
        try {
            if (this.isCostNeedRepairAcctData(ctx, model)) {
                this.repairAcctData(ctx, model, "fcostorgid");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new EASBizException(new NumericExceptionSubItem(null, null), (Throwable)e);
        }
    }

    private boolean isCostNeedRepairAcctData(Context ctx, FullOrgUnitInfo model) throws BOSException, EASBizException, SQLException {
        FullOrgUnitInfo parent = model.getParent();
        if (parent != null) {
            String costParentId;
            String parentAdminOrgId = parent.getId().toString();
            if (parentAdminOrgId.equals(costParentId = this.getCostCenterParentID(ctx, model.getNumber()))) {
                int count;
                String orgCountSql = "SELECT count(*) FROM T_org_baseUnit where FPARENTID = ?";
                IRowSet result = DbUtil.executeQuery((Context)ctx, (String)orgCountSql, (Object[])new String[]{parentAdminOrgId});
                if (result.next() && (count = result.getInt(1)) == 1) {
                    return true;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    private String getCostCenterParentID(Context ctx, String orgNum) {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("parent.id"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)orgNum));
        view.setFilter(filter);
        CostCenterOrgUnitInfo cost = new CostCenterOrgUnitInfo();
        try {
            CostCenterOrgUnitCollection orgColl = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(view);
            if (orgColl != null) {
                cost = orgColl.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cost != null && cost.getParent() != null) {
            return cost.getParent().getId().toString();
        }
        return null;
    }

    private boolean isNeedRepairAcctData(Context ctx, FullOrgUnitInfo model) throws BOSException, EASBizException, SQLException {
        int count;
        String parentAdminOrgId;
        String orgCountSql;
        IRowSet result;
        FullOrgUnitInfo parent = model.getParent();
        return parent != null && (result = DbUtil.executeQuery((Context)ctx, (String)(orgCountSql = "SELECT count(*) FROM T_org_baseUnit where FPARENTID = ?"), (Object[])new String[]{parentAdminOrgId = parent.getId().toString()})).next() && (count = result.getInt(1)) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairAcctData(Context ctx, FullOrgUnitInfo model, String actHgFieldName) throws EASBizException, BOSException, SQLException {
        IRowSet results;
        Connection con;
        PreparedStatement stmt;
        block5: {
            stmt = null;
            con = null;
            results = null;
            try {
                String parentBizOrgId = model.getParent().getId().toString();
                String bizOrgId = model.getId().toString();
                StringBuilder sql = new StringBuilder();
                sql.append("select fid from t_bd_assistanthg where ").append(actHgFieldName).append(" = ? ");
                results = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{parentBizOrgId});
                HashSet<String> hgIds = new HashSet<String>();
                while (results.next()) {
                    String hgId = results.getString("fid");
                    hgIds.add(hgId);
                }
                if (hgIds.isEmpty()) break block5;
                con = EJBFactory.getConnection((Context)ctx);
                sql.setLength(0);
                sql.append("update t_bd_assistanthg hg set ").append(actHgFieldName).append(" = ? where exists    \r\n");
                sql.append("(select 1 from t_gl_VoucherAssistRecord vr   \r\n");
                sql.append("where hg.fid = vr.FASSGRPID and hg.").append(actHgFieldName).append(" = ?");
                sql.append(") \t\r\n");
                stmt = con.prepareStatement(sql.toString());
                stmt.setObject(1, bizOrgId);
                stmt.setObject(2, parentBizOrgId);
                int counts = stmt.executeUpdate();
                SQLUtils.cleanup((Statement)stmt);
                sql.setLength(0);
                sql.append("update t_bd_assistanthg hg set ").append(actHgFieldName).append(" = ? where exists    \r\n");
                sql.append("(select 1  from t_gl_InitAssistBalance bal  \r\n");
                sql.append("where hg.fid = bal.FASSISTGRPID and hg.").append(actHgFieldName).append(" = ?");
                sql.append(")    \r\n");
                stmt = con.prepareStatement(sql.toString());
                stmt.setObject(1, bizOrgId);
                stmt.setObject(2, parentBizOrgId);
                counts += stmt.executeUpdate();
                SQLUtils.cleanup((Statement)stmt);
                sql.setLength(0);
                sql.append("update t_bd_assistanthg hg set ").append(actHgFieldName).append(" = ? where exists    \r\n");
                sql.append("(select 1  from T_GL_CASHFLOWGRPASST cfl  \r\n");
                sql.append("where hg.fid = cfl.FASSISTGRPID and hg.").append(actHgFieldName).append(" = ?");
                sql.append(")    \r\n");
                stmt = con.prepareStatement(sql.toString());
                stmt.setObject(1, bizOrgId);
                stmt.setObject(2, parentBizOrgId);
                if ((counts += stmt.executeUpdate()) > 0) {
                    for (String hgId : hgIds) {
                        AutoAssistantHGUpdateFacadeFactory.getLocalInstance(ctx).modify(hgId);
                    }
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(results, stmt, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)results, stmt, (Connection)con);
    }

    private void dealAdminOrgAddNew(Context ctx, FullOrgUnitInfo model) throws BOSException, EASBizException {
        try {
            if (this.isNeedRepairAcctData(ctx, model)) {
                this.repairAcctData(ctx, model, "FADMINORGID");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new EASBizException(new NumericExceptionSubItem(null, null), (Throwable)e);
        }
    }

    private void checkAdminOrgHasDeal(Context ctx, String adminOrgId) throws EASBizException, BOSException {
        StringBuilder sql = new StringBuilder();
        try {
            sql.append("select 1 from T_ORG_OUPartCostCenter where fid = ?");
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{adminOrgId});
            if (!result.next()) {
                return;
            }
            this.checkAcctGlBal(ctx, adminOrgId, "fadminOrgId", "adminOrg");
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void afterOrgDelete(Context ctx, FullOrgUnitInfo model) throws BOSException, EASBizException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkCostCenterHasDeal(Context ctx, BOSUuid id, boolean isBizUnit) throws EASBizException, BOSException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        try {
            con = GlUtils.getConnection(ctx);
            sql.append("select fisbizunit from  T_ORG_OUPartCostCenter where funitid = ? ");
            stmt = con.prepareStatement(sql.toString());
            int index = 1;
            stmt.setString(index++, id.toString());
            rs = stmt.executeQuery();
            if (!rs.next()) {
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
                return;
            }
            if (rs.getInt("fisbizunit") == 1 && isBizUnit || rs.getInt("fisbizunit") == 0 && !isBizUnit) {
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
                return;
            }
            this.checkAcctGlBal(ctx, id.toString(), "fcostorgid", "CostCenter");
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
            return;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)con);
        }
    }

    public void afterDeal(Context ctx, FullOrgUnitInfo model) throws BOSException, EASBizException {
        if (model.isIsCostOrgUnit()) {
            boolean isBizUnit = model.getPartCostCenter().isIsBizUnit();
            this.checkCostCenterHasDeal(ctx, BOSUuid.read((String)model.getId().toString()), isBizUnit);
        }
    }

    public void orgUpdateBefore(Context arg0, FullOrgUnitInfo arg1) throws BOSException, EASBizException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAcctGlBal(Context ctx, String id, String acctHgFieldName, String resourceName) throws EASBizException, BOSException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        int index = 0;
        String message = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)resourceName, (Locale)ctx.getLocale());
        try {
            con = GlUtils.getConnection(ctx);
            sql = new StringBuffer();
            sql.append("select 1                                                       \t\t\t\t\r\n");
            sql.append("from t_gl_VoucherAssistRecord vr inner join t_bd_assistanthg hg                 \r\n");
            sql.append("on vr.fassgrpid = hg.fid                                  \t                    \r\n");
            sql.append("where hg.").append(acctHgFieldName).append(" = ?                                \r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            stmt.setString(index++, id.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new GLBaseDataCheckException(GLBaseDataCheckException.REF_BY_VOUCHER, new Object[]{message});
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql.setLength(0);
            sql.append("select 1                                                       \t\t\t\t\r\n");
            sql.append("from T_GL_CASHFLOWGRPASST cfg inner join t_bd_assistanthg hg                      \r\n");
            sql.append("on cfg.fassistgrpid = hg.fid                                  \t                    \r\n");
            sql.append("where hg.").append(acctHgFieldName).append(" = ?                                \r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            stmt.setString(index++, id.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new GLBaseDataCheckException(GLBaseDataCheckException.REF_BY_CASHFLOWINIT, new Object[]{message});
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql.setLength(0);
            sql.append("select 1                                                       \t\t\t\t\r\n");
            sql.append("from T_GL_CashflowRecord cr inner join t_bd_assistanthg hg                      \r\n");
            sql.append("on cr.fassgrpid = hg.fid                                  \t                    \r\n");
            sql.append("where hg.").append(acctHgFieldName).append(" = ?                                \r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            stmt.setString(index++, id.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new GLBaseDataCheckException(GLBaseDataCheckException.REF_BY_CASHFLOW, new Object[]{message});
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql.setLength(0);
            sql.append("select 1                                             \t\t\t\t\t        \r\n");
            sql.append("from t_gl_InitAssistBalance bal inner join t_bd_assistanthg hg                  \r\n");
            sql.append("on bal.fassistgrpid = hg.fid                                                    \r\n");
            sql.append("where hg.").append(acctHgFieldName).append(" = ?                                \r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            stmt.setString(index++, id.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new GLBaseDataCheckException(GLBaseDataCheckException.REF_BY_INITASSTBAL, new Object[]{message});
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql.setLength(0);
            sql.append("select 1                                                        \t\t\t\t\r\n");
            sql.append("from t_gl_AssistBalance_1f bal inner join t_bd_assistanthg hg                      \r\n");
            sql.append("on bal.fassistgrpid = hg.fid                                                    \r\n");
            sql.append("where hg.").append(acctHgFieldName).append(" = ?                                \r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            stmt.setString(index++, id.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new GLBaseDataCheckException(GLBaseDataCheckException.REF_BY_ASSTBAL, new Object[]{message});
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql.setLength(0);
            sql.append("select 1                                                        \t\t\t\t\r\n");
            sql.append("from t_gl_AssistBalance_1l bal inner join t_bd_assistanthg hg                      \r\n");
            sql.append("on bal.fassistgrpid = hg.fid                                                    \r\n");
            sql.append("where hg.").append(acctHgFieldName).append(" = ?                                \r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            stmt.setString(index++, id.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new GLBaseDataCheckException(GLBaseDataCheckException.REF_BY_ASSTBAL, new Object[]{message});
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql.setLength(0);
            sql.append("select 1                                                        \t\t\t\t\r\n");
            sql.append("from t_gl_AssistBalance_1r bal inner join t_bd_assistanthg hg                      \r\n");
            sql.append("on bal.fassistgrpid = hg.fid                                                    \r\n");
            sql.append("where hg.").append(acctHgFieldName).append(" = ?                                \r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            stmt.setString(index++, id.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new GLBaseDataCheckException(GLBaseDataCheckException.REF_BY_ASSTBAL, new Object[]{message});
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql.setLength(0);
            sql.append("select 1                                                        \t\t\t\t\r\n");
            sql.append("from t_gl_AssistBalance_5f bal inner join t_bd_assistanthg hg                      \r\n");
            sql.append("on bal.fassistgrpid = hg.fid                                                    \r\n");
            sql.append("where hg.").append(acctHgFieldName).append(" = ?                                \r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            stmt.setString(index++, id.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new GLBaseDataCheckException(GLBaseDataCheckException.REF_BY_ASSTBAL, new Object[]{message});
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql.setLength(0);
            sql.append("select 1                                                        \t\t\t\t\r\n");
            sql.append("from t_gl_AssistBalance_5l bal inner join t_bd_assistanthg hg                      \r\n");
            sql.append("on bal.fassistgrpid = hg.fid                                                    \r\n");
            sql.append("where hg.").append(acctHgFieldName).append(" = ?                                \r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            stmt.setString(index++, id.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new GLBaseDataCheckException(GLBaseDataCheckException.REF_BY_ASSTBAL, new Object[]{message});
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql.setLength(0);
            sql.append("select 1                                                        \t\t\t\t\r\n");
            sql.append("from t_gl_AssistBalance_5r bal inner join t_bd_assistanthg hg                      \r\n");
            sql.append("on bal.fassistgrpid = hg.fid                                                    \r\n");
            sql.append("where hg.").append(acctHgFieldName).append(" = ?                                \r\n");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            stmt.setString(index++, id.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new GLBaseDataCheckException(GLBaseDataCheckException.REF_BY_ASSTBAL, new Object[]{message});
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)con);
        }
    }
}

