/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AutoAssistantHGUpdateFacadeFactory;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GLFlagCollection;
import com.kingdee.eas.fi.gl.GLFlagInfo;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAutoAssistantHGUpdateFacade;
import com.kingdee.eas.fi.gl.app.AbstractGLFlagControllerBean;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.pca.PcaFlagFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLFlagControllerBean
extends AbstractGLFlagControllerBean {
    private static final Logger log = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLFlagControllerBean");

    @Override
    protected boolean _getGLInitClosed(Context ctx, String orgUnitId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"glinit", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgUnitId, CompareType.EQUALS));
        view.setFilter(filter);
        GLFlagCollection col = this.getCollection(ctx, view);
        if (col.size() == 0) {
            return false;
        }
        GLFlagInfo flag = col.get(0);
        return flag.getValue().equals("true");
    }

    @Override
    protected void _setGLInitClosed(Context ctx, boolean flag, String orgUnitId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"glinit", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgUnitId, CompareType.EQUALS));
        view.setFilter(filter);
        GLFlagCollection col = this.getCollection(ctx, view);
        if (col.size() == 0) {
            GLFlagInfo flagInfo = new GLFlagInfo();
            flagInfo.setName("glinit");
            flagInfo.setValue(flag ? "true" : "false");
            CompanyOrgUnitInfo orgUnit = new CompanyOrgUnitInfo();
            orgUnit.put(orgUnit.getPKField(), (Object)orgUnitId);
            flagInfo.setOrgUnit(orgUnit);
            this.addnew(ctx, flagInfo);
        } else {
            GLFlagInfo flagInfo = col.get(0);
            if (flagInfo.getValue().equals("true") != flag) {
                flagInfo.setValue(flag ? "true" : "false");
                this.update(ctx, (IObjectPK)new ObjectUuidPK(flagInfo.getId().toString()), flagInfo);
            }
        }
    }

    @Override
    protected boolean[] _getAstInitClosed(Context ctx, String[] accountIds, String orgUnitId) throws BOSException {
        Map<String, AsstAccountInfo> caas;
        boolean[] flags = new boolean[accountIds.length];
        try {
            PeriodInfo start = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(orgUnitId));
            HashSet<String> accountIdSet = new HashSet<String>(Arrays.asList(accountIds));
            caas = GLAsstAccountUtils.getCAAs(ctx, accountIdSet, start.getId().toString(), null);
        }
        catch (EASBizException e) {
            log.error((Object)("getAstInitClosed error, companyId: " + orgUnitId), (Throwable)e);
            return flags;
        }
        HashSet<String> okAccountIdSet = new HashSet<String>();
        for (String id : accountIds) {
            AsstAccountInfo caa = caas.get(id);
            if (caa == null) continue;
            okAccountIdSet.add(id);
        }
        for (int i = 0; i < accountIds.length; ++i) {
            if (!okAccountIdSet.contains(accountIds[i])) {
                flags[i] = true;
                continue;
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)"astinit", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("key", (Object)accountIds[i], CompareType.EQUALS));
            view.setFilter(filter);
            GLFlagCollection col = this.getCollection(ctx, view);
            if (col.size() == 0) {
                flags[i] = false;
                continue;
            }
            GLFlagInfo flag = col.get(0);
            flags[i] = flag.getValue().equals("true");
        }
        return flags;
    }

    @Override
    protected void _setAstInitClosed(Context ctx, String[] accountIds, boolean[] flags, String orgUnitId) throws BOSException {
        for (int i = 0; i < accountIds.length; ++i) {
            GLFlagInfo flagInfo;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)"astinit", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("key", (Object)accountIds[i], CompareType.EQUALS));
            view.setFilter(filter);
            GLFlagCollection col = this.getCollection(ctx, view);
            if (col.size() == 0) {
                flagInfo = new GLFlagInfo();
                flagInfo.setName("astinit");
                flagInfo.setKey(accountIds[i]);
                flagInfo.setValue(flags[i] ? "true" : "false");
                CompanyOrgUnitInfo orgUnit = new CompanyOrgUnitInfo();
                orgUnit.setId(BOSUuid.read((String)orgUnitId));
                orgUnit.put(orgUnit.getPKField(), (Object)BOSUuid.read((String)orgUnitId));
                flagInfo.setOrgUnit(orgUnit);
                this.addnew(ctx, flagInfo);
                PcaFlagFactory.getLocalInstance((Context)ctx).setAstInitClosed(new String[]{accountIds[i]}, new boolean[]{flags[i]}, orgUnitId);
                continue;
            }
            flagInfo = col.get(0);
            if (flagInfo.getValue().equals("true") == flags[i]) continue;
            flagInfo.setValue(flags[i] ? "true" : "false");
            if (flags[i]) {
                this.update(ctx, (IObjectPK)new ObjectUuidPK(flagInfo.getId().toString()), flagInfo);
                continue;
            }
            this.delete(ctx, (IObjectPK[])new ObjectUuidPK[]{new ObjectUuidPK(flagInfo.getId().toString())});
        }
    }

    @Override
    protected boolean _getCashflowInitClosed(Context ctx, String orgUnitId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"cashflowInit", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgUnitId, CompareType.EQUALS));
        view.setFilter(filter);
        GLFlagCollection col = this.getCollection(ctx, view);
        if (col.size() == 0) {
            return false;
        }
        GLFlagInfo flag = col.get(0);
        return flag.getValue().equals("true");
    }

    @Override
    protected void _setCashflowInitClosed(Context ctx, boolean flag, String orgUnitId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"cashflowInit", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgUnitId, CompareType.EQUALS));
        view.setFilter(filter);
        GLFlagCollection col = this.getCollection(ctx, view);
        if (col.size() == 0) {
            GLFlagInfo flagInfo = new GLFlagInfo();
            flagInfo.setName("cashflowInit");
            flagInfo.setValue(flag ? "true" : "false");
            CompanyOrgUnitInfo orgUnit = new CompanyOrgUnitInfo();
            orgUnit.put(orgUnit.getPKField(), (Object)orgUnitId);
            flagInfo.setOrgUnit(orgUnit);
            this.addnew(ctx, flagInfo);
        } else {
            GLFlagInfo flagInfo = col.get(0);
            if (flagInfo.getValue().equals("true") != flag) {
                flagInfo.setValue(flag ? "true" : "false");
                this.update(ctx, (IObjectPK)new ObjectUuidPK(flagInfo.getId().toString()), flagInfo);
            }
        }
    }

    @Override
    protected boolean _getCashflowGrpAsstClosed(Context ctx, String orgUnitId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"cashflowGrpAsst", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgUnitId, CompareType.EQUALS));
        view.setFilter(filter);
        GLFlagCollection col = this.getCollection(ctx, view);
        if (col.size() == 0) {
            return false;
        }
        GLFlagInfo flag = col.get(0);
        return flag.getValue().equals("true");
    }

    @Override
    protected void _setCashflowGrpAsstClosed(Context ctx, boolean flag, String orgUnitId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"cashflowGrpAsst", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgUnitId, CompareType.EQUALS));
        view.setFilter(filter);
        GLFlagCollection col = this.getCollection(ctx, view);
        if (col.size() == 0) {
            GLFlagInfo flagInfo = new GLFlagInfo();
            flagInfo.setName("cashflowGrpAsst");
            flagInfo.setValue(flag ? "true" : "false");
            CompanyOrgUnitInfo orgUnit = new CompanyOrgUnitInfo();
            orgUnit.put(orgUnit.getPKField(), (Object)orgUnitId);
            flagInfo.setOrgUnit(orgUnit);
            this.addnew(ctx, flagInfo);
        } else {
            GLFlagInfo flagInfo = col.get(0);
            if (flagInfo.getValue().equals("true") != flag) {
                flagInfo.setValue(flag ? "true" : "false");
                this.update(ctx, (IObjectPK)new ObjectUuidPK(flagInfo.getId().toString()), flagInfo);
            }
        }
    }

    @Override
    protected String[] _getAllAstInitClosed(Context ctx, String orgUnitId) throws BOSException {
        String[] results = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"astinit", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)"true", CompareType.EQUALS));
        view.setFilter(filter);
        GLFlagCollection col = this.getCollection(ctx, view);
        int size = col.size();
        if (size > 0) {
            results = new String[size];
            for (int i = 0; i < size; ++i) {
                GLFlagInfo flag = col.get(i);
                results[i] = flag.getKey();
            }
        }
        return results;
    }

    @Override
    protected boolean[] _getCussentInitClosed(Context ctx, String[] accountIds, String orgUnitId) throws BOSException {
        boolean[] flags = new boolean[accountIds.length];
        for (int i = 0; i < accountIds.length; ++i) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)"cussentinit", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("key", (Object)accountIds[i], CompareType.EQUALS));
            view.setFilter(filter);
            GLFlagCollection col = this.getCollection(ctx, view);
            if (col.size() == 0) {
                flags[i] = false;
                continue;
            }
            GLFlagInfo flag = col.get(0);
            flags[i] = flag.getValue().equals("true");
        }
        return flags;
    }

    @Override
    protected void _setCussentInitClosed(Context ctx, String[] accountIds, boolean[] flags, String orgUnitId) throws BOSException {
        if (accountIds.length == 0) {
            return;
        }
        boolean allowCussent = false;
        try {
            allowCussent = GlUtils.getDefaultGLParam(ctx, orgUnitId, "GL_028");
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        if (!allowCussent) {
            return;
        }
        SystemStatusCtrolCollection ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection("select currentPeriod.*,acPeriod.* where systemStatus.name=6 and company.id='" + orgUnitId + "'");
        PeriodInfo currentPeriod = null;
        if (ctrols.size() > 0 && ctrols.get(0).getCurrentPeriod() != null) {
            if (ctrols.get(0).getAcPeriod() == null || ctrols.get(0).getCurrentPeriod().getNumber() >= ctrols.get(0).getAcPeriod().getNumber()) {
                currentPeriod = ctrols.get(0).getCurrentPeriod();
            } else if (ctrols.get(0).getAcPeriod() != null) {
                currentPeriod = ctrols.get(0).getAcPeriod();
            }
        }
        for (int i = 0; i < accountIds.length; ++i) {
            GLFlagInfo flagInfo;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)"cussentinit", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("key", (Object)accountIds[i], CompareType.EQUALS));
            view.setFilter(filter);
            GLFlagCollection col = this.getCollection(ctx, view);
            if (col.size() == 0) {
                flagInfo = new GLFlagInfo();
                flagInfo.setName("cussentinit");
                flagInfo.setKey(accountIds[i]);
                flagInfo.setValue(flags[i] ? "true" : "false");
                flagInfo.setInitPeriod(currentPeriod);
                CompanyOrgUnitInfo orgUnit = new CompanyOrgUnitInfo();
                orgUnit.setId(BOSUuid.read((String)orgUnitId));
                orgUnit.put(orgUnit.getPKField(), (Object)BOSUuid.read((String)orgUnitId));
                flagInfo.setOrgUnit(orgUnit);
                this.addnew(ctx, flagInfo);
                continue;
            }
            flagInfo = col.get(0);
            if (flagInfo.getValue().equals("true") == flags[i]) continue;
            flagInfo.setValue(flags[i] ? "true" : "false");
            if (flags[i] && flagInfo.getInitPeriod() == null) {
                flagInfo.setInitPeriod(currentPeriod);
            }
            this.update(ctx, (IObjectPK)new ObjectUuidPK(flagInfo.getId().toString()), flagInfo);
        }
    }

    @Override
    protected String[] _getAllCussentInitClosed(Context ctx, String orgUnitId) throws BOSException {
        String[] results = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"cussentinit", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)"true", CompareType.EQUALS));
        view.setFilter(filter);
        GLFlagCollection col = this.getCollection(ctx, view);
        int size = col.size();
        if (size > 0) {
            results = new String[size];
            for (int i = 0; i < size; ++i) {
                GLFlagInfo flag = col.get(i);
                results[i] = flag.getKey();
            }
        }
        return results;
    }

    @Override
    protected String _unclosePeriod(Context ctx, BOSUuid pk, int periodNumber, int periodYear, String companName) throws BOSException {
        return companName + " " + periodYear + "." + periodNumber;
    }

    @Override
    protected void _updateBalance(Context ctx, String pk) throws BOSException {
        try {
            if (pk != null) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = view.getSelector();
                sic.add(new SelectorItemInfo("id"));
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("number", (Object)pk.trim()));
                ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitCollection cc = companyOrgUnit.getCompanyOrgUnitCollection(view);
                if (cc.size() <= 0) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"886_GLFlagControllerBean", (Locale)ctx.getLocale()) + pk + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"887_GLFlagControllerBean", (Locale)ctx.getLocale()));
                }
                ctx.put((Object)"choseCompanyID", (Object)cc.get(0).getId());
                GLBalanceFacadeFactory.getLocalInstance(ctx).updateVoucherBalance(new String[]{cc.get(0).getId().toString()});
            }
        }
        catch (BOSException ex) {
            log.error((Object)"Update voucher balance error!", (Throwable)ex);
        }
    }

    @Override
    protected void _updateBalanceAll(Context ctx, String pk) throws BOSException, EASBizException {
        try {
            GLBalanceFacadeFactory.getLocalInstance(ctx).updateVoucherBalance(null);
        }
        catch (BOSException ex) {
            log.error((Object)"Update voucher balance error!", (Throwable)ex);
        }
    }

    @Override
    protected void _updateLongName(Context ctx, String pk) throws BOSException {
        try {
            IAutoAssistantHGUpdateFacade facade = AutoAssistantHGUpdateFacadeFactory.getLocalInstance(ctx);
            facade.update();
        }
        catch (BOSException e1) {
            log.error((Object)e1);
            log.error((Object)e1.getMessage());
        }
        catch (EASBizException e) {
            log.error((Object)e);
        }
    }

    @Override
    protected boolean _checkIfAllCussentInitClosed(Context ctx, String curCompanyId, String accountTableId) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        int index = 0;
        String loc = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(curCompanyId));
        StringBuffer errMsg = null;
        try {
            con = this.getConnection(ctx);
            sql = new StringBuffer();
            sql.append("select top 1 v1.*\t\t\t\t\t\t\t\r\n");
            sql.append("from                                \r\n");
            sql.append("(                                   \r\n");
            sql.append("select distinct acct.FID as FAccountID,     \r\n");
            sql.append("\tacct.FNumber as FAccountNumber, \t\t\r\n");
            sql.append("\tacct.FName");
            sql.append(loc);
            sql.append(" as FAccountName\t\t\t\t\t\t\t\r\n");
            sql.append("from t_bd_accountview acct          \t\t\r\n");
            sql.append("Where acct.FCAA is not null       \t\t\r\n");
            sql.append("\tand acct.Fcompanyid = ?   and acct.FaccountTableId=?  \r\n");
            sql.append("\tand acct.FIsLeaf = 1              \t\t\t\r\n");
            sql.append("    and acct.FAC = 1                \r\n");
            sql.append(")v1                                 \r\n");
            sql.append("left join                           \r\n");
            sql.append("(                                   \r\n");
            sql.append("select FKey from t_GL_Flag flag     \r\n");
            sql.append(" inner join t_bd_period bp on flag.finitPeriodId = bp.fid \r\n");
            sql.append(" where flag.FOrgUnitID = ?                \r\n");
            sql.append("    and flag.FName = 'cussentinit'       \r\n");
            sql.append("\tand (flag.FValue = 'true' or bp.fnumber>?) \r\n");
            sql.append(")v2                                 \r\n");
            sql.append("on v1.FAccountID = v2.FKey          \r\n");
            sql.append("                                    \r\n");
            sql.append("where v2.FKey is null               \r\n");
            sql.append("order by v1.FAccountNumber          \r\n");
            sql.append(";");
            stmt = con.prepareStatement(sql.toString());
            index = 1;
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyId);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)accountTableId);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyId);
            stmt.setInt(index++, currentPeriod.getNumber());
            rs = stmt.executeQuery();
            errMsg = new StringBuffer();
            while (rs.next()) {
                errMsg.append(rs.getString("FAccountNumber"));
                errMsg.append("-");
                errMsg.append(rs.getString("FAccountName"));
                errMsg.append(";");
            }
            if (errMsg.length() > 0) {
                String[] info = new String[]{errMsg.toString()};
                throw new GLPeriodEndException(GLPeriodEndException.VERIFY_CUSSENT_INIT_NOT_CLOSED);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return true;
    }

    @Override
    protected String[] _getAllCussentInitClosedByPeriod(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period) throws BOSException {
        if (company == null || period == null) {
            return new String[0];
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"cussentinit", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)company.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)"true"));
        filter.getFilterItems().add(new FilterItemInfo("initPeriod.id", (Object)period.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        GLFlagCollection col = this.getCollection(ctx, view);
        String[] results = null;
        int size = col.size();
        if (size > 0) {
            results = new String[size];
            for (int i = 0; i < size; ++i) {
                GLFlagInfo flagInfo = col.get(i);
                results[i] = flagInfo.getKey();
            }
        }
        return results;
    }

    @Override
    protected boolean _periodIsAfterAcInitPeriod(Context ctx, AccountViewInfo account, PeriodInfo period) throws BOSException, EASBizException {
        if (account == null || period == null) {
            return false;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select 1 from t_gl_flag flag inner join t_bd_period bp on flag.finitPeriodId = bp.fid ");
        sql.append("where flag.fkey = ? and fname='cussentinit' and bp.fnumber<=?");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{account.getId().toString(), period.getNumber()});
        try {
            if (result.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"query cussentinit flag exception.", (Throwable)e);
        }
        return false;
    }
}

