/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.ContextUtils;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.AccountBalanceFactory;
import com.kingdee.eas.fi.gl.AccountBalanceInfo;
import com.kingdee.eas.fi.gl.AccountBalanceInitData;
import com.kingdee.eas.fi.gl.AssistInitFacadeFactory;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAccountBalance;
import com.kingdee.eas.fi.gl.IGLBalanceFacade;
import com.kingdee.eas.fi.gl.IGLFlag;
import com.kingdee.eas.fi.gl.IGLPeriodEndFacade;
import com.kingdee.eas.fi.gl.IInitAccountBalance;
import com.kingdee.eas.fi.gl.InitAccountBalanceCollection;
import com.kingdee.eas.fi.gl.InitAccountBalanceFactory;
import com.kingdee.eas.fi.gl.InitAccountBalanceInfo;
import com.kingdee.eas.fi.gl.InitAssistBalanceCollection;
import com.kingdee.eas.fi.gl.InitAssistBalanceInfo;
import com.kingdee.eas.fi.gl.InitException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.AbstractGLInitFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLInitFacadeControllerBean
extends AbstractGLInitFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLInitFacadeControllerBean");
    BigDecimal one = new BigDecimal("1");
    BigDecimal negone = new BigDecimal("-1");
    public BigDecimal zero = new BigDecimal("0.00");
    public static final int BATCH_SIZE = 8192;

    protected PeriodInfo[] getPeriods(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return InitHelp.getPeriods(ctx, company);
    }

    protected boolean isInitClosed(Context ctx, String orgUnitId) throws BOSException {
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        return flag.getGLInitClosed(orgUnitId);
    }

    @Override
    public ArrayList _getInitData(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        if (company == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        if (company.getAccountPeriodType() == null) {
            throw new GLException(GLException.NOPERIODTYPE);
        }
        String companyid = company.getId().toString();
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection curCol = curCtrl.getCurrencyCollection(false);
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        boolean isInitClosed = this.isInitClosed(ctx, companyid);
        result.add(isInitClosed);
        Map hmParamValue = InitHelp.getInitParam(ctx, company);
        result.add((Boolean)hmParamValue.get("GL_002"));
        result.add((Boolean)hmParamValue.get("GL_008"));
        result.add((Boolean)hmParamValue.get("G001"));
        PeriodInfo[] periods = this.getPeriods(ctx, company);
        result.add((Boolean)periods[0]);
        result.add((Boolean)periods[2]);
        result.add((Boolean)periods[1]);
        otherCtx.put("STARTPERIOD", periods[0]);
        otherCtx.put("CURRENTPERIOD", periods[2]);
        otherCtx.put("FIRSTPERIOD", periods[1]);
        result.add((Boolean)curCol);
        result.add((Boolean)InitHelp.getAccountTableCollection(ctx));
        result.add((Boolean)hmParamValue.get("GL_055"));
        return result;
    }

    protected AccountBalanceInitData[] getAccountBalanceData(Context ctx, String currencyId, HashMap otherCtx, int type) throws BOSException, EASBizException {
        CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        CurrencyInfo localCur = curCompany.getBaseCurrency();
        String fname = "fname_" + ctx.getLocale().getLanguage();
        String faccountname = GlUtils.isAccountShowLongName(ctx, curCompany.getId().toString()) ? "flongname_" + ctx.getLocale().getLanguage() : fname;
        String sql = "select DISTINCT  balance.fcurrencyid,balance.fbeginbalancefor,balance.fyeardebitfor,balance.fyearcreditfor,balance.fdebitfor,balance.fcreditfor,balance.fendbalancefor  \r\n,balance.fbeginbalanceLocal,balance.fyeardebitLocal,balance.fyearcreditLocal,balance.fdebitlocal,balance.fcreditlocal,balance.fendbalancelocal  \r\n,balance.fbeginbalancerpt,balance.fyeardebitrpt,balance.fyearcreditrpt,balance.fdebitrpt,balance.fcreditrpt,balance.fendbalancerpt  \r\n,CASE WHEN account.FIsQty = 0 THEN 0 ELSE balance.fbeginqty * 1.0000 / ISNULL(account.FCoefficient, 1) END fbeginqty    \t\t\t\r\n,CASE WHEN account.FIsQty = 0 THEN 0 ELSE balance.fyeardebitqty * 1.0000 / ISNULL(account.FCoefficient, 1) END fyeardebitqty\t\t\r\n,CASE WHEN account.FIsQty = 0 THEN 0 ELSE balance.fyearcreditqty * 1.0000 / ISNULL(account.FCoefficient, 1) END fyearcreditqty\t\r\n,CASE WHEN account.FIsQty = 0 THEN 0 ELSE balance.fdebitqty * 1.0000 / ISNULL(account.FCoefficient, 1) END fdebitqty\t\t\t\t\r\n,CASE WHEN account.FIsQty = 0 THEN 0 ELSE balance.fcreditqty * 1.0000 / ISNULL(account.FCoefficient, 1) END fcreditqty\t\t\t\r\n,CASE WHEN account.FIsQty = 0 THEN 0 ELSE balance.FEndQty * 1.0000 / ISNULL(account.FCoefficient, 1) END fendqty\t\t\t\t\t\r\n,balance.fyearpnlfor,balance.fmonthpnlfor,balance.fyearpnllocal,balance.fmonthpnllocal,balance.fyearpnlrpt,balance.fmonthpnlrpt  \r\n,account.fid faccountid,account.fnumber faccountnumber,account." + faccountname + " faccountname,account.flongnumber faccountlongnumber,account.fisleaf fisleaf,account.flevel flevel  \r\n,account.fdc ,account.fisqty ,account.fparentid fparentid,account.fcurrencyid faccountcurrencyid,account.accounttypeproperty   \r\n ,account.measureunitname,account.FAcctCurrency  acctcurrency,account.FisGFreeze ,account.FisCFreeze ,account.FCAA from   \r\n(select balance.faccountid ,balance.fcurrencyid,balance.fbeginbalancefor,balance.fyeardebitfor,balance.fyearcreditfor,balance.fdebitfor,balance.fcreditfor,balance.fendbalancefor  \r\n,balance.fbeginbalanceLocal,balance.fyeardebitLocal,balance.fyearcreditLocal,balance.fdebitlocal,balance.fcreditlocal,balance.fendbalancelocal  \r\n,balance.fbeginbalancerpt,balance.fyeardebitrpt,balance.fyearcreditrpt,balance.fdebitrpt,balance.fcreditrpt,balance.fendbalancerpt  \r\n,balance.fbeginqty,balance.fyeardebitqty,balance.fyearcreditqty,balance.fdebitqty,balance.fcreditqty,balance.fendqty  \r\n,balance.fyearpnlfor,balance.fmonthpnlfor,balance.fyearpnllocal,balance.fmonthpnllocal,balance.fyearpnlrpt,balance.fmonthpnlrpt  \r\n from t_gl_initaccountbalance balance where balance.forgunitid=? and balance.fcurrencyid=?) balance   \r\n right outer join  ( select account.fid,account.fnumber,account." + faccountname + " ,account.flongnumber ,account.fisleaf,account.flevel   \r\n,account.fdc ,account.fisqty ,account.fparentid fparentid,account.fcurrencyid  \r\n ,account.FisGFreeze ,account.FisCFreeze ,account.FCAA, account.FAcctCurrency \r\n,accounttype.fproperty accounttypeproperty,measureunit." + fname + " measureunitname,measureunit.FCoefficient from t_BD_AccountView account   \r\n LEFT OUTER JOIN T_BD_MEASUREUNIT measureunit ON measureunit.FID = account.FMeasureUnitID\t\t\t\r\n left join t_bd_accounttype accounttype on accounttype.fid=account.faccounttypeid   \r\n where account.fcompanyid=? and account.faccountTableid=?  and account.fisProfitCenter <> 1  ";
        if (type != 1 && type != 2) {
            sql = sql + " and  account.fid in (select a.fid from t_bd_accountview a   \r\n  left join t_bd_accountcurrency b on  a.fid=b.faccountviewid   \r\n where ((facctcurrency=1 and b.fcurrencyid=?) or facctcurrency=2   \r\n ";
            if (currencyId.equals(localCur.getId().toString())) {
                sql = sql + " or facctcurrency=0 ";
            }
            sql = sql + " ) and fcompanyid = ?  and  account.faccountTableid=? ) \r\n";
        }
        sql = sql + ") account on balance.faccountid=account.fid order by account.fnumber";
        ArrayList al = this.getAccountBalanceData(ctx, currencyId, otherCtx, type, sql, 2);
        int count = al.size();
        return al.toArray(new AccountBalanceInitData[count]);
    }

    protected ArrayList getAccountBalanceData(Context ctx, String currencyId, HashMap otherCtx, int type, String sql, int status) throws BOSException {
        String companyId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String accounttableid = (String)otherCtx.get("ACCOUNTTABLEID");
        ArrayList<AccountBalanceInitData> al = new ArrayList<AccountBalanceInitData>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(sql);
            int index = 1;
            stmt.setString(index++, companyId);
            stmt.setString(index++, currencyId);
            stmt.setString(index++, companyId);
            stmt.setString(index++, accounttableid);
            if (type != 1 && type != 2) {
                stmt.setString(index++, currencyId);
                stmt.setString(index++, companyId);
                stmt.setString(index++, accounttableid);
            }
            rs = stmt.executeQuery();
            HashMap<String, AccountBalanceInitData> accountMap = new HashMap<String, AccountBalanceInitData>();
            while (rs.next()) {
                AccountBalanceInitData data;
                String faccountid = rs.getString("faccountid");
                if (accountMap.get(faccountid) == null) {
                    data = new AccountBalanceInitData();
                    data.setAccountId(rs.getString("faccountid"));
                    data.setAccountName(rs.getString("faccountname"));
                    data.setAccountCurrencyId(rs.getString("faccountcurrencyid"));
                    data.setAccountDC(rs.getInt("fdc"));
                    data.setAccountIsLeaf(rs.getInt("fisleaf"));
                    data.setAccountLevel(rs.getInt("flevel"));
                    data.setAccountIsQty(rs.getInt("fisqty"));
                    data.setAccountParentId(rs.getString("fparentid"));
                    data.setAccountLongNumber(rs.getString("faccountlongnumber"));
                    data.setAccountMeasureUnitName(rs.getString("measureunitname"));
                    data.setAccountNumber(rs.getString("faccountnumber"));
                    data.setAcctCurrency(rs.getInt("acctcurrency"));
                    data.setAccountIsPLType(rs.getInt("accounttypeproperty") == 4);
                    data.setAccountIsFreese(rs.getBoolean("FisCFreeze") || rs.getBoolean("FisGFreeze"));
                    String asstID = rs.getString("FCAA");
                    if (asstID != null && !"".equals(asstID)) {
                        AccountViewInfo account = new AccountViewInfo();
                        AsstAccountInfo asst = new AsstAccountInfo();
                        asst.setId(BOSUuid.read((String)asstID));
                        account.setCAA(asst);
                        data.setAccount(account);
                    }
                    if (rs.getString("fcurrencyid") == null) {
                        data.setStatus(0);
                        data.setCurrencyId(currencyId);
                    } else {
                        data.setStatus(status);
                        data.setCurrencyId(rs.getString("fcurrencyid"));
                        data.setBeginBalanceFor(rs.getBigDecimal("fbeginbalancefor"));
                        data.setBeginBalanceLocal(rs.getBigDecimal("fbeginbalancelocal"));
                        data.setBeginBalanceReport(rs.getBigDecimal("fbeginbalancerpt"));
                        data.setBeginQty(rs.getBigDecimal("fbeginqty"));
                        data.setEndBalanceFor(rs.getBigDecimal("fendbalancefor"));
                        data.setEndBalanceLocal(rs.getBigDecimal("fendbalancelocal"));
                        data.setEndBalanceReport(rs.getBigDecimal("fendbalancerpt"));
                        data.setEndQty(rs.getBigDecimal("fendqty"));
                        data.setYearCreditFor(rs.getBigDecimal("fyearcreditfor"));
                        data.setYearCreditLocal(rs.getBigDecimal("fyearcreditlocal"));
                        data.setYearCreditQty(rs.getBigDecimal("fyearcreditqty"));
                        data.setYearCreditReport(rs.getBigDecimal("fyearcreditrpt"));
                        data.setYearDebitFor(rs.getBigDecimal("fyeardebitfor"));
                        data.setYearDebitLocal(rs.getBigDecimal("fyeardebitlocal"));
                        data.setYearDebitQty(rs.getBigDecimal("fyeardebitqty"));
                        data.setYearDebitReport(rs.getBigDecimal("fyeardebitrpt"));
                        data.setYearPnLFor(rs.getBigDecimal("fyearpnlfor"));
                        data.setYearPnLLocal(rs.getBigDecimal("fyearpnllocal"));
                        data.setYearPnLReport(rs.getBigDecimal("fyearpnlrpt"));
                        data.setCreditFor(rs.getBigDecimal("fcreditfor"));
                        data.setCreditLocal(rs.getBigDecimal("fcreditlocal"));
                        data.setCreditQty(rs.getBigDecimal("fcreditqty"));
                        data.setCreditReport(rs.getBigDecimal("fcreditrpt"));
                        data.setDebitFor(rs.getBigDecimal("fdebitfor"));
                        data.setDebitLocal(rs.getBigDecimal("fdebitlocal"));
                        data.setDebitQty(rs.getBigDecimal("fdebitqty"));
                        data.setDebitReport(rs.getBigDecimal("fdebitrpt"));
                    }
                } else {
                    data = (AccountBalanceInitData)accountMap.get(faccountid);
                    data.setBeginBalanceFor(data.getBeginBalanceFor().add(rs.getBigDecimal("fbeginbalancefor")));
                    data.setBeginBalanceLocal(data.getBeginBalanceLocal().add(rs.getBigDecimal("fbeginbalancelocal")));
                    data.setBeginBalanceReport(data.getBeginBalanceReport().add(rs.getBigDecimal("fbeginbalancerpt")));
                    data.setBeginQty(data.getBeginQty().add(rs.getBigDecimal("fbeginqty")));
                    data.setEndBalanceFor(rs.getBigDecimal("fendbalancefor"));
                    data.setEndBalanceLocal(rs.getBigDecimal("fendbalancelocal"));
                    data.setEndBalanceReport(rs.getBigDecimal("fendbalancerpt"));
                    data.setEndQty(rs.getBigDecimal("fendqty"));
                    data.setYearCreditFor(rs.getBigDecimal("fyearcreditfor"));
                    data.setYearCreditLocal(rs.getBigDecimal("fyearcreditlocal"));
                    data.setYearCreditQty(rs.getBigDecimal("fyearcreditqty"));
                    data.setYearCreditReport(rs.getBigDecimal("fyearcreditrpt"));
                    data.setYearDebitFor(rs.getBigDecimal("fyeardebitfor"));
                    data.setYearDebitLocal(rs.getBigDecimal("fyeardebitlocal"));
                    data.setYearDebitQty(rs.getBigDecimal("fyeardebitqty"));
                    data.setYearDebitReport(rs.getBigDecimal("fyeardebitrpt"));
                    data.setYearPnLFor(rs.getBigDecimal("fyearpnlfor"));
                    data.setYearPnLLocal(rs.getBigDecimal("fyearpnllocal"));
                    data.setYearPnLReport(rs.getBigDecimal("fyearpnlrpt"));
                    data.setCreditFor(rs.getBigDecimal("fcreditfor"));
                    data.setCreditLocal(rs.getBigDecimal("fcreditlocal"));
                    data.setCreditQty(rs.getBigDecimal("fcreditqty"));
                    data.setCreditReport(rs.getBigDecimal("fcreditrpt"));
                    data.setDebitFor(rs.getBigDecimal("fdebitfor"));
                    data.setDebitLocal(rs.getBigDecimal("fdebitlocal"));
                    data.setDebitQty(rs.getBigDecimal("fdebitqty"));
                    data.setDebitReport(rs.getBigDecimal("fdebitrpt"));
                }
                if (accountMap.containsKey(faccountid)) continue;
                accountMap.put(faccountid, data);
                al.add(data);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return al;
    }

    @Override
    public void _saveAccountBalance(Context ctx, Object[] params, HashMap otherCtx) throws BOSException {
        if (params == null) {
            return;
        }
        AccountBalanceInitData[] datas = (AccountBalanceInitData[])params;
        if (datas == null || datas.length == 0) {
            return;
        }
        Connection con = null;
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        StringBuffer clearZero = new StringBuffer();
        clearZero.append("delete from t_gl_initaccountbalance").append(" where fbeginbalancefor=0 and fyeardebitfor=0 and fyearcreditfor=0 and fdebitfor=0 and fcreditfor=0").append(" and fendbalancefor=0 and fbeginbalancelocal=0 and fyeardebitlocal=0 and fyearcreditlocal=0 ").append(" and fdebitlocal=0 and fcreditlocal=0 and fendbalancelocal=0 and fbeginbalancerpt=0 ").append(" and fyeardebitrpt=0 and fyearcreditrpt=0 and fdebitrpt=0 and fcreditrpt=0 and fendbalancerpt=0").append(" and fyearpnlfor=0 and fmonthpnlfor=0 and fyearpnllocal=0 and fmonthpnllocal=0 and fyearpnlrpt=0 and fmonthpnlrpt=0").append(" and fbeginqty=0 and fyeardebitqty=0 and fyearcreditqty=0 and fdebitqty=0 and fcreditqty=0 and fendqty=0");
        PreparedStatement new_stmt = null;
        PreparedStatement update_stmt = null;
        PreparedStatement select_stmt = null;
        PreparedStatement delete_stmt = null;
        Object rs = null;
        try {
            con = this.getConnection(ctx);
            update_stmt = con.prepareStatement(clearZero.toString());
            update_stmt.executeUpdate();
            update_stmt.close();
            new_stmt = con.prepareStatement(this.getNewSql());
            update_stmt = con.prepareStatement(this.getUpdateSql());
            select_stmt = con.prepareStatement(this.getSelectSql());
            delete_stmt = con.prepareStatement(this.getDeleteSql());
            Boolean useRptFlag = Boolean.parseBoolean(otherCtx.get("ISUSEREPORT").toString());
            for (int i = 0; i < datas.length; ++i) {
                AccountBalanceInitData data = datas[i];
                if (data == null) continue;
                if (!useRptFlag.booleanValue()) {
                    data.setBeginBalanceReport(this.zero);
                    data.setEndBalanceReport(this.zero);
                    data.setCreditReport(this.zero);
                    data.setDebitReport(this.zero);
                }
                int index = 1;
                delete_stmt.setString(index++, orgUnitId);
                delete_stmt.setString(index++, data.getAccountId());
                delete_stmt.setString(index++, data.getCurrencyId());
                delete_stmt.executeUpdate();
                index = 1;
                new_stmt.setString(index++, orgUnitId);
                new_stmt.setString(index++, data.getAccountId());
                new_stmt.setString(index++, data.getCurrencyId());
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getBeginBalanceFor()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getBeginBalanceLocal()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getBeginBalanceReport()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getEndBalanceFor()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getEndBalanceLocal()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getEndBalanceReport()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearDebitFor()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearDebitLocal()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearDebitReport()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearCreditFor()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearCreditLocal()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearCreditReport()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getBeginQty()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getBeginQty()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearDebitQty()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearCreditQty()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearPnLFor()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearPnLLocal()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearPnLReport()));
                new_stmt.executeUpdate();
            }
            select_stmt.close();
            this.sum(ctx, con, datas, otherCtx);
            update_stmt.close();
            update_stmt = con.prepareStatement(clearZero.toString());
            update_stmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(new_stmt);
                SQLUtils.cleanup(delete_stmt);
                SQLUtils.cleanup((Statement)update_stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)new_stmt);
        SQLUtils.cleanup((Statement)delete_stmt);
        SQLUtils.cleanup((Statement)update_stmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sum(Context ctx, Connection con, AccountBalanceInitData[] datas, HashMap otherCtx) throws BOSException, SQLException {
        int index;
        String sql;
        StringBuffer insert_general_report2;
        StringBuffer insert_general_report1;
        StringBuffer insert_general_local2;
        StringBuffer insert_general_local1;
        StringBuffer delete_general;
        String accounttable;
        String companyId;
        String grc;
        String glc;
        boolean isUseReport;
        StringBuffer ids_ancestor;
        StringBuffer ids_leaf;
        ResultSet rs;
        PreparedStatement ps;
        block12: {
            ps = null;
            rs = null;
            ids_leaf = new StringBuffer();
            int count = datas.length;
            for (int i = 0; i < count; ++i) {
                ids_leaf.append("'").append(datas[i].getAccountId()).append("',");
            }
            ids_ancestor = new StringBuffer();
            ArrayList<String> alLeafIds = new ArrayList<String>();
            ArrayList<String> alAncestorIds = new ArrayList<String>();
            ArrayList<String> alAncestorNumbers = new ArrayList<String>();
            ArrayList<Integer> alAncestorDCs = new ArrayList<Integer>();
            isUseReport = (Boolean)otherCtx.get("ISUSEREPORT");
            glc = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
            grc = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
            companyId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
            accounttable = (String)otherCtx.get("ACCOUNTTABLEID");
            StringBuffer query_ancestor = new StringBuffer("select fid,fnumber,fdc from t_BD_AccountView where charindex(flongnumber || '!' ,?) = 1 and Fcompanyid = ? and faccounttableid=? ");
            StringBuffer delete_ancestor = new StringBuffer("delete from t_gl_initaccountbalance where forgunitid = ? and fcurrencyid= ? and faccountid in (");
            StringBuffer insert_ancestor = new StringBuffer();
            StringBuffer insert_ancestor_insertpart = new StringBuffer("insert into t_gl_initaccountbalance").append("(").append("FOrgUnitID,FAccountID,FCurrencyID,").append("FBeginBalanceFor,").append("FBeginBalanceLocal,").append("FBeginBalanceRpt,").append("FEndBalanceFor,").append("FEndBalanceLocal,").append("FEndBalanceRpt,").append("FYearDebitFor,").append("FYearDebitLocal,").append("FYearDebitRpt,").append("FYearCreditFor,").append("FYearCreditLocal,").append("FYearCreditRpt,").append("FYearPnLFor,").append("FYearPnLLocal,").append("FYearPnLRpt,").append("FBeginQty,").append("FEndQty,").append("FYearDebitQty,").append("FYearCreditQty").append(") ");
            StringBuffer insert_ancestor_selectpart = new StringBuffer();
            StringBuffer insert_ancestor_frompart = new StringBuffer(" from t_gl_initaccountbalance balance,t_bd_accountview account ").append(" where balance.forgunitid=? and balance.fcurrencyid=? and balance.faccountid=account.fid and account.flongnumber like ");
            delete_general = new StringBuffer("delete from t_gl_initaccountbalance where forgunitid= ? and (fcurrencyid= ? or fcurrencyid= ? ) and ").append(" faccountid in (");
            insert_general_local1 = new StringBuffer().append("insert into t_gl_initaccountbalance ").append("(").append("FOrgUnitID,").append("FAccountID,").append("FCurrencyID,").append("FBeginBalanceFor,").append("FYearDebitFor,").append("FYearCreditFor,").append("FDebitFor,").append("FCreditFor,").append("FEndBalanceFor,").append("FBeginBalanceLocal,").append("FYearDebitLocal,").append("FYearCreditLocal,").append("FDebitLocal,").append("FCreditLocal,").append("FEndBalanceLocal,").append("FBeginBalanceRpt,").append("FYearDebitRpt,").append("FYearCreditRpt,").append("FDebitRpt,").append("FCreditRpt,").append("FEndBalanceRpt,").append("FYearPnLFor,").append("FMonthPnLFor,").append("FYearPnLLocal,").append("FMonthPnLLocal,").append("FYearPnLRpt,").append("FMonthPnLRpt,").append("FBeginQty,").append("FYearDebitQty,").append("FYearCreditQty,").append("FDebitQty,").append("FCreditQty,").append("FEndQty").append(")").append(" select ").append("\tFOrgUnitID,").append("\tFAccountID,").append("'").append(glc).append("',").append("\tsum(ISNULL(FBeginBalanceLocal,0)),").append("\tsum(ISNULL(FYearDebitLocal,0)),").append("\tsum(ISNULL(FYearCreditLocal,0)),").append("\tsum(ISNULL(FDebitLocal,0)),").append("\tsum(ISNULL(FCreditLocal,0)),").append("\tsum(ISNULL(FEndBalanceLocal,0)),").append("\tsum(ISNULL(FBeginBalanceLocal,0)),").append("\tsum(ISNULL(FYearDebitLocal,0)),").append("\tsum(ISNULL(FYearCreditLocal,0)),").append("\tsum(ISNULL(FDebitLocal,0)),").append("\tsum(ISNULL(FCreditLocal,0)),").append("\tsum(ISNULL(FEndBalanceLocal,0)),").append("\tsum(ISNULL(FBeginBalanceLocal,0)),").append("\tsum(ISNULL(FYearDebitLocal,0)),").append("\tsum(ISNULL(FYearCreditLocal,0)),").append("\tsum(ISNULL(FDebitLocal,0)),").append("\tsum(ISNULL(FCreditLocal,0)),").append("\tsum(ISNULL(FEndBalanceLocal,0)),").append("\tsum(ISNULL(FYearPnLLocal,0)),").append("\t0,").append("\tsum(ISNULL(FYearPnLLocal,0)),").append("\t0,").append("\t0,").append("\t0,").append("\tsum(ISNULL(FBeginQty,0)),").append("\tsum(ISNULL(FYearDebitQty,0)),").append("\tsum(ISNULL(FYearCreditQty,0)),").append("\tsum(ISNULL(FDebitQty,0)),").append("\tsum(ISNULL(FCreditQty,0)),").append("\tsum(ISNULL(FEndQty,0))").append(" from t_gl_initaccountbalance where FOrgUnitID=? and faccountid in(");
            insert_general_local2 = new StringBuffer(") group by FOrgUnitID,FAccountID");
            insert_general_report1 = new StringBuffer().append("insert into t_gl_initaccountbalance (").append("\tFOrgUnitID,").append("\tFAccountID,").append("\tFCurrencyID,").append("\tFBeginBalanceFor,").append("\tFYearDebitFor,").append("\tFYearCreditFor,").append("\tFDebitFor,").append("\tFCreditFor,").append("\tFEndBalanceFor,").append("\tFBeginBalanceRpt,").append("\tFYearDebitRpt,").append("\tFYearCreditRpt,").append("\tFDebitRpt,").append("\tFCreditRpt,").append("\tFEndBalanceRpt,").append("\tFBeginBalanceLocal,").append("\tFYearDebitLocal,").append("\tFYearCreditLocal,").append("\tFDebitLocal,").append("\tFCreditLocal,").append("\tFEndBalanceLocal,").append("\tFYearPnLFor,").append("\tFMonthPnLFor,").append("\tFYearPnLRpt,").append("\tFMonthPnLRpt,").append("\tFYearPnLLocal,").append("\tFMonthPnLLocal,").append("\tFBeginQty,").append("\tFYearDebitQty,").append("\tFYearCreditQty,").append("\tFDebitQty,").append("\tFCreditQty,").append("\tFEndQty").append(")").append(" select ").append("\tFOrgUnitID,").append("\tFAccountID,").append("'").append(grc).append("',").append("\tsum(ISNULL(FBeginBalanceRpt,0)),").append("\tsum(ISNULL(FYearDebitRpt,0)),").append("\tsum(ISNULL(FYearCreditRpt,0)),").append("\tsum(ISNULL(FDebitRpt,0)),").append("\tsum(ISNULL(FCreditRpt,0)),").append("\tsum(ISNULL(FEndBalanceRpt,0)),").append("\tsum(ISNULL(FBeginBalanceRpt,0)),").append("\tsum(ISNULL(FYearDebitRpt,0)),").append("\tsum(ISNULL(FYearCreditRpt,0)),").append("\tsum(ISNULL(FDebitRpt,0)),").append("\tsum(ISNULL(FCreditRpt,0)),").append("\tsum(ISNULL(FEndBalanceRpt,0)),").append("\tsum(ISNULL(FBeginBalanceRpt,0)),").append("\tsum(ISNULL(FYearDebitRpt,0)),").append("\tsum(ISNULL(FYearCreditRpt,0)),").append("\tsum(ISNULL(FDebitRpt,0)),").append("\tsum(ISNULL(FCreditRpt,0)),").append("\tsum(ISNULL(FEndBalanceRpt,0)),").append("\tsum(ISNULL(FYearPnLRpt,0)),").append("\t0,").append("\tsum(ISNULL(FYearPnLRpt,0)),").append("\t0,").append("\t0,").append("\t0,").append("\tsum(ISNULL(FBeginQty,0)),").append("\tsum(ISNULL(FYearDebitQty,0)),").append("\tsum(ISNULL(FYearCreditQty,0)),").append("\tsum(ISNULL(FDebitQty,0)),").append("\tsum(ISNULL(FCreditQty,0)),").append("\tsum(ISNULL(FEndQty,0))").append("\tfrom t_gl_initaccountbalance where FOrgUnitID = ? and FCurrencyID <> ? and faccountid in(");
            insert_general_report2 = new StringBuffer(") group by FOrgUnitID,FAccountID");
            try {
                HashMap hmTemp = new HashMap();
                String currencyId = null;
                for (AccountBalanceInitData data : datas) {
                    String accountId = data.getAccountId();
                    if (currencyId == null) {
                        currencyId = data.getCurrencyId();
                    }
                    String longNumber = data.getAccountLongNumber();
                    alLeafIds.add(accountId);
                    ArrayList<String> alIds = new ArrayList<String>();
                    hmTemp.put(accountId, alIds);
                    query_ancestor = new StringBuffer("select  fid,flongnumber,fdc from t_BD_AccountView where charindex(flongnumber || '!' ,").append("'").append(longNumber).append("') = 1 and Fcompanyid = ? and faccounttableid=? ");
                    ps = con.prepareStatement(query_ancestor.toString());
                    int index2 = 1;
                    ps.setString(index2++, companyId);
                    ps.setString(index2++, accounttable);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        String tempid = rs.getString(1);
                        String templongnumber = rs.getString(2);
                        int tempdc = rs.getInt(3);
                        alIds.add(tempid);
                        if (alAncestorIds.contains(tempid)) continue;
                        alAncestorIds.add(tempid);
                        alAncestorDCs.add(new Integer(tempdc));
                        alAncestorNumbers.add(templongnumber);
                        ids_ancestor.append("'").append(tempid).append("',");
                    }
                    SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                }
                sql = null;
                if (ids_ancestor.length() > 0) {
                    sql = delete_ancestor.toString() + ids_ancestor.toString();
                    sql = sql.substring(0, sql.length() - 1) + ")";
                    ps = con.prepareStatement(sql);
                    index = 1;
                    ps.setString(index++, companyId);
                    ps.setString(index++, currencyId);
                    ps.executeUpdate();
                    SQLUtils.cleanup((Statement)ps);
                }
                int count2 = alAncestorIds.size();
                for (int i = 0; i < count2; ++i) {
                    String id = (String)alAncestorIds.get(i);
                    String longnumber = (String)alAncestorNumbers.get(i);
                    Integer dc = (Integer)alAncestorDCs.get(i);
                    insert_ancestor_selectpart = new StringBuffer().append("select ").append("'").append(companyId).append("',").append("'").append(id).append("',").append("'").append(currencyId).append("',");
                    if (dc == 1) {
                        insert_ancestor_selectpart.append("sum(ISNULL(balance.FBeginBalanceFor,0)*account.fdc),").append("sum(ISNULL(balance.FBeginBalanceLocal,0)*account.fdc),").append("sum(ISNULL(balance.FBeginBalanceRpt,0)*account.fdc),").append("sum(ISNULL(balance.FEndBalanceFor,0)*account.fdc),").append("sum(ISNULL(balance.FEndBalanceLocal,0)*account.fdc),").append("sum(ISNULL(balance.FEndBalanceRpt,0)*account.fdc),").append("sum(ISNULL(balance.FYearDebitFor,0)),").append("sum(ISNULL(balance.FYearDebitLocal,0)),").append("sum(ISNULL(balance.FYearDebitRpt,0)),").append("sum(ISNULL(balance.FYearCreditFor,0)),").append("sum(ISNULL(balance.FYearCreditLocal,0)),").append("sum(ISNULL(balance.FYearCreditRpt,0)),").append("sum(ISNULL(balance.FYearPnLFor,0)*account.fdc),").append("sum(ISNULL(balance.FYearPnLLocal,0)*account.fdc),").append("sum(ISNULL(balance.FYearPnLRpt,0)*account.fdc),").append("sum(ISNULL(balance.FBeginQty,0)*account.fdc),").append("sum(ISNULL(balance.FEndQty,0)*account.fdc),").append("sum(ISNULL(balance.FYearDebitQty,0)),").append("sum(ISNULL(balance.FYearCreditQty,0))");
                    } else {
                        insert_ancestor_selectpart.append("sum(ISNULL(balance.FBeginBalanceFor,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FBeginBalanceLocal,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FBeginBalanceRpt,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FEndBalanceFor,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FEndBalanceLocal,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FEndBalanceRpt,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FYearDebitFor,0)),").append("sum(ISNULL(balance.FYearDebitLocal,0)),").append("sum(ISNULL(balance.FYearDebitRpt,0)),").append("sum(ISNULL(balance.FYearCreditFor,0)),").append("sum(ISNULL(balance.FYearCreditLocal,0)),").append("sum(ISNULL(balance.FYearCreditRpt,0)),").append("sum(ISNULL(balance.FYearPnLFor,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FYearPnLLocal,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FYearPnLRpt,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FBeginQty,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FEndQty,0)*account.fdc)*(-1),").append("sum(ISNULL(balance.FYearDebitQty,0)),").append("sum(ISNULL(balance.FYearCreditQty,0))");
                    }
                    insert_ancestor = new StringBuffer();
                    insert_ancestor.append(insert_ancestor_insertpart).append(insert_ancestor_selectpart).append(insert_ancestor_frompart).append("'").append(longnumber).append("!%' and account.fisleaf=1");
                    ps = con.prepareStatement(insert_ancestor.toString());
                    index = 1;
                    ps.setString(index++, companyId);
                    ps.setString(index++, currencyId);
                    ps.executeUpdate();
                    SQLUtils.cleanup((Statement)ps);
                }
                Boolean isForeign = (Boolean)otherCtx.get("ISFOREIGN");
                if (!isForeign.booleanValue()) break block12;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps);
                throw throwable;
            }
            SQLUtils.cleanup(rs, ps);
            return;
        }
        sql = delete_general.toString() + ids_leaf.toString() + ids_ancestor.toString();
        sql = sql.substring(0, sql.length() - 1) + ")";
        ps = con.prepareStatement(sql);
        index = 1;
        ps.setString(index++, companyId);
        ps.setString(index++, glc);
        ps.setString(index++, grc);
        ps.executeUpdate();
        SQLUtils.cleanup((Statement)ps);
        sql = ids_leaf.toString() + ids_ancestor.toString();
        sql = sql.substring(0, sql.length() - 1);
        sql = insert_general_local1.toString() + sql + insert_general_local2;
        ps = con.prepareStatement(sql);
        index = 1;
        ps.setString(index++, companyId);
        ps.executeUpdate();
        SQLUtils.cleanup((Statement)ps);
        if (isUseReport) {
            sql = ids_leaf.toString() + ids_ancestor.toString();
            sql = sql.substring(0, sql.length() - 1);
            sql = insert_general_report1.toString() + sql + insert_general_report2;
            ps = con.prepareStatement(sql);
            index = 1;
            ps.setString(index++, companyId);
            ps.setString(index++, glc);
            ps.executeUpdate();
            SQLUtils.cleanup((Statement)ps);
        }
        sql = "update t_gl_initaccountbalance  set fbeginqty=0,fendqty=0,fyeardebitqty=0,fyearcreditqty=0,fdebitqty=0,fcreditqty=0  where forgunitid = ? and faccountid  in (select fid from t_bd_accountview where FCompanyID = ? and faccounttableid = ? and fisqty = 0)";
        index = 1;
        ps = con.prepareStatement(sql);
        ps.setString(index++, companyId);
        ps.setString(index++, companyId);
        ps.setString(index++, accounttable);
        ps.executeUpdate();
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
    }

    protected String getSelectSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 where exists                                    \t\t\t\t\t\r\n");
        sql.append("( select 1                                 \t\t\t\t\t\r\n");
        sql.append("from t_gl_InitAccountBalance bal                                                   \r\n");
        sql.append("where bal.forgunitid=? and bal.FAccountID = ? and bal.fcurrencyid=? )");
        return sql.toString();
    }

    protected String getNewSql() {
        String temp = "insert into t_gl_initaccountBalance(forgunitid,faccountid,fcurrencyid,fbeginbalancefor,fbeginbalancelocal,fbeginbalancerpt,fendbalancefor,fendbalancelocal,fendbalancerpt,fyeardebitfor,fyeardebitlocal,fyeardebitrpt,fyearcreditfor,fyearcreditlocal,fyearcreditrpt,";
        temp = temp + "fbeginqty,fendqty,fyeardebitqty,fyearcreditqty,";
        temp = temp + "fyearpnlfor,fyearpnllocal,fyearpnlrpt";
        temp = temp + ") values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,";
        temp = temp + "?,?,?,?,";
        temp = temp + "?,?,?)";
        return temp;
    }

    protected String getUpdateSql() {
        String temp = "update t_gl_initaccountBalance set fbeginbalancefor=?,fbeginbalancelocal=?,fbeginbalancerpt=?,fendbalancefor=?,fendbalancelocal=?,fendbalancerpt=?,fyeardebitfor=?,fyeardebitlocal=?,fyeardebitrpt=?,fyearcreditfor=?,fyearcreditlocal=?,fyearcreditrpt=?,";
        temp = temp + "fbeginqty=?,fendqty=?,fyeardebitqty=?,fyearcreditqty=?,";
        temp = temp + "fyearpnlfor=?,fyearpnllocal=?,fyearpnlrpt=?";
        temp = temp + " where forgunitid=? and faccountid=? and fcurrencyid=?";
        return temp;
    }

    protected String getDeleteSql() {
        String temp = "delete from  t_gl_initaccountBalance  where forgunitid=? and faccountid=? and fcurrencyid=?";
        return temp;
    }

    protected String getSelectSql(boolean acctOrAsst) {
        if (acctOrAsst) {
            return "select 1 where exists (select 1  from  t_gl_initaccountBalance  where forgunitid=? and faccountid=? and fcurrencyid=? )";
        }
        return "select 1 where exists (select 1  from  t_gl_initassistBalance  where forgunitid=? and faccountid=? and fcurrencyid=? and fassistgrpid=? )";
    }

    @Override
    public HashMap _tryBalance(Context ctx, String currencyId, HashMap otherCtx) throws BOSException {
        HashMap<String, Comparable<BigDecimal>> hashMap;
        BigDecimal zero;
        HashMap<String, Comparable<BigDecimal>> result = new HashMap<String, Comparable<BigDecimal>>();
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        PeriodInfo startPeriod = (PeriodInfo)otherCtx.get("STARTPERIOD");
        PeriodInfo firstPeriod = (PeriodInfo)otherCtx.get("FIRSTPERIOD");
        String startPeriodId = startPeriod.getId().toString();
        String firstPeriodId = firstPeriod.getId().toString();
        String accountTableid = otherCtx.get("ACCOUNTTABLEID").toString();
        boolean first = startPeriodId.equals(firstPeriodId);
        StringBuffer sql = new StringBuffer();
        sql.append("   select account.fdc fdc,sum(fbeginbalancefor) fbeginbalancefor,sum(fbeginbalancelocal) fbeginbalancelocal,sum(fbeginbalancerpt) fbeginbalancereport,");
        sql.append("   sum(fyeardebitfor) fyeardebitfor,sum(fyearcreditfor) fyearcreditfor,sum(fyeardebitlocal) fyeardebitlocal,sum(fyearcreditlocal) fyearcreditlocal, ");
        sql.append("   sum(fyeardebitrpt) fyeardebitreport,sum(fyearcreditrpt) fyearcreditreport ");
        sql.append("   from t_gl_initaccountbalance balance inner join t_BD_AccountView account on balance.faccountid=account.fid ");
        sql.append("   inner join t_bd_accounttype accounttype on account.faccounttypeid=accounttype.fid where  account.flevel=1 and accounttype.fproperty<>? and forgunitid=?  ");
        sql.append("   and balance.fcurrencyid=? ");
        sql.append("   and account.fbw=0");
        sql.append("   and account.faccounttableid = ?");
        sql.append("   group by account.fdc order by account.fdc ");
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        BigDecimal beginDebitFor = zero = new BigDecimal("0");
        BigDecimal beginCreditFor = zero;
        BigDecimal yearDebitFor = zero;
        BigDecimal yearCreditFor = zero;
        BigDecimal beginDebitLocal = zero;
        BigDecimal beginDebitReport = zero;
        BigDecimal beginCreditLocal = zero;
        BigDecimal beginCreditReport = zero;
        BigDecimal yearDebitLocal = zero;
        BigDecimal yearDebitReport = zero;
        BigDecimal yearCreditLocal = zero;
        BigDecimal yearCreditReport = zero;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(sql.toString());
            int index = 1;
            stmt.setInt(index++, 5);
            stmt.setString(index++, orgUnitId);
            stmt.setString(index++, currencyId);
            stmt.setString(index++, accountTableid);
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getInt("fdc") == 1) {
                    beginDebitFor = rs.getBigDecimal("fbeginbalancefor");
                    beginDebitLocal = rs.getBigDecimal("fbeginbalancelocal");
                    beginDebitReport = rs.getBigDecimal("fbeginbalancereport");
                    yearDebitFor = yearDebitFor.add(rs.getBigDecimal("fyeardebitfor"));
                    yearDebitLocal = yearDebitLocal.add(rs.getBigDecimal("fyeardebitlocal"));
                    yearDebitReport = yearDebitReport.add(rs.getBigDecimal("fyeardebitreport"));
                    yearCreditFor = yearCreditFor.add(rs.getBigDecimal("fyearcreditfor"));
                    yearCreditLocal = yearCreditLocal.add(rs.getBigDecimal("fyearcreditlocal"));
                    yearCreditReport = yearCreditReport.add(rs.getBigDecimal("fyearcreditreport"));
                    continue;
                }
                beginCreditFor = rs.getBigDecimal("fbeginbalancefor");
                beginCreditLocal = rs.getBigDecimal("fbeginbalancelocal");
                beginCreditReport = rs.getBigDecimal("fbeginbalancereport");
                yearDebitFor = yearDebitFor.add(rs.getBigDecimal("fyeardebitfor"));
                yearDebitLocal = yearDebitLocal.add(rs.getBigDecimal("fyeardebitlocal"));
                yearDebitReport = yearDebitReport.add(rs.getBigDecimal("fyeardebitreport"));
                yearCreditFor = yearCreditFor.add(rs.getBigDecimal("fyearcreditfor"));
                yearCreditLocal = yearCreditLocal.add(rs.getBigDecimal("fyearcreditlocal"));
                yearCreditReport = yearCreditReport.add(rs.getBigDecimal("fyearcreditreport"));
            }
            result.put("beginDebitFor", beginDebitFor);
            result.put("beginDebitLocal", beginDebitLocal);
            result.put("beginDebitReport", beginDebitReport);
            result.put("beginCreditFor", beginCreditFor);
            result.put("beginCreditLocal", beginCreditLocal);
            result.put("beginCreditReport", beginCreditReport);
            result.put("yearDebitFor", yearDebitFor);
            result.put("yearCreditFor", yearCreditFor);
            result.put("yearDebitLocal", yearDebitLocal);
            result.put("yearDebitReport", yearDebitReport);
            result.put("yearCreditLocal", yearCreditLocal);
            result.put("yearCreditReport", yearCreditReport);
            String glc = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
            String grc = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
            boolean succeed = currencyId.equals(glc) ? (first ? beginDebitLocal.compareTo(beginCreditLocal) == 0 : yearDebitLocal.compareTo(yearCreditLocal) == 0 && beginDebitLocal.compareTo(beginCreditLocal) == 0) : (currencyId.equals(grc) ? (first ? beginDebitReport.compareTo(beginCreditReport) == 0 : yearDebitReport.compareTo(yearCreditReport) == 0 && beginDebitReport.compareTo(beginCreditReport) == 0) : (first ? beginDebitFor.compareTo(beginCreditFor) == 0 : yearDebitFor.compareTo(yearCreditFor) == 0 && beginDebitFor.compareTo(beginCreditFor) == 0));
            result.put("succeed", Boolean.valueOf(succeed));
            hashMap = result;
        }
        catch (SQLException sqle) {
            try {
                try {
                    con.rollback();
                }
                catch (SQLException e) {
                    logger.error((Object)sqle);
                }
                logger.error((Object)sqle);
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return hashMap;
    }

    protected AccountViewCollection getAccountFromIds(Context ctx, String[] ids, String cuid) throws BOSException, EASBizException {
        AccountViewCollection result = new AccountViewCollection();
        FilterInfo filter = new FilterInfo();
        int size = ids.length;
        if (size == 0) {
            return result;
        }
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            str.append(",").append(ids[i]);
        }
        str.deleteCharAt(0);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)str.toString(), CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("id");
        selectorItemCollection.add("number");
        selectorItemCollection.add("name");
        selectorItemCollection.add("isQty");
        selectorItemCollection.add("isLeaf");
        selectorItemCollection.add("CAA.isQty");
        selectorItemCollection.add("accountTypeID.property");
        view.setSelector(selectorItemCollection);
        IAccountView avctl = AccountViewFactory.getLocalInstance((Context)ctx);
        result = avctl.getAccountViewCollection(view);
        return result;
    }

    protected void checkCloseInit(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        Boolean isForeign = (Boolean)otherCtx.get("ISFOREIGN");
        if (isForeign.booleanValue()) {
            String[] allCurrencyId = (String[])otherCtx.get("ALLCURRENCYID");
            for (int i = 0; i < allCurrencyId.length; ++i) {
                HashMap result = this._tryBalance(ctx, allCurrencyId[i], otherCtx);
                boolean b = (Boolean)result.get("succeed");
                if (b) continue;
                throw new InitException(InitException.TRYNOTBALANCE, new Object[]{""});
            }
        } else {
            String currencyId = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
            HashMap result = this._tryBalance(ctx, currencyId, otherCtx);
            boolean b = (Boolean)result.get("succeed");
            if (!b) {
                String RESOURCE_PATH = "com.kingdee.eas.fi.gl.GLResource";
                String local = ResourceBase.getString((String)RESOURCE_PATH, (String)"GENERALLOCAL", (Locale)ctx.getLocale());
                throw new InitException(InitException.TRYNOTBALANCE, new Object[]{local});
            }
            Boolean isUseReport = (Boolean)otherCtx.get("ISUSEREPORT");
            if (isUseReport.booleanValue() && !(b = ((Boolean)(result = this._tryBalance(ctx, currencyId = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), otherCtx)).get("succeed")).booleanValue())) {
                String RESOURCE_PATH = "com.kingdee.eas.fi.gl.GLResource";
                String report = ResourceBase.getString((String)RESOURCE_PATH, (String)"GENERALREPORT", (Locale)ctx.getLocale());
                throw new InitException(InitException.TRYNOTBALANCE, new Object[]{report});
            }
        }
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        String cuid = (String)otherCtx.get("CUID");
        String[] accounts = this.getFlagCtrl(ctx).getAllAstInitClosed(orgUnitId);
        if (accounts == null || accounts.length == 0) {
            return;
        }
        AccountViewCollection accountcol = this.getAccountFromIds(ctx, accounts, cuid);
        boolean isQty = GlUtils.getQtyAsstParam(ctx);
        otherCtx.put("G010", isQty);
        for (AccountViewInfo account : accountcol) {
            if (!account.isIsLeaf()) continue;
            this.checkAsstEqualGL(ctx, account, otherCtx);
        }
    }

    protected void checkAsstEqualGL(Context ctx, AccountViewInfo info, HashMap otherCtx) throws BOSException, EASBizException {
        InitHelp.checkAsstEqualGL(ctx, info, otherCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _closeInit(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String userId;
        MutexParameter mp;
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        PeriodInfo startPeriod = (PeriodInfo)otherCtx.get("STARTPERIOD");
        PeriodInfo firstPeriod = (PeriodInfo)otherCtx.get("FIRSTPERIOD");
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter current = mutex.requestMutex3(mp = GLMutexUtils.buildModifyBalanceParameter(ctx, orgUnitId, userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), "GL_Init"));
        if (current != null) {
            throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
        }
        try {
            this.checkCloseInit(ctx, otherCtx);
            IGLBalanceFacade updateBalance = GLBalanceFacadeFactory.getLocalInstance(ctx);
            updateBalance.initAccountBalance(orgUnitId, startPeriod.getId().toString(), firstPeriod.getId().toString(), null);
            IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
            flag.setGLInitClosed(true, orgUnitId);
            SystemStatusCtrolFactory.getLocalInstance((Context)ctx).start(SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)otherCtx.get("COMPANY"), true);
        }
        finally {
            mutex.releaseMutex(mp.getRequestId());
        }
    }

    protected void createBalance(Context ctx, HashMap otherCtx) throws BOSException {
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        PeriodInfo startPeriod = (PeriodInfo)otherCtx.get("STARTPERIOD");
        PeriodInfo firstPeriod = (PeriodInfo)otherCtx.get("FIRSTPERIOD");
        IInitAccountBalance initCtrl = InitAccountBalanceFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("account.DC"));
        InitAccountBalanceCollection initCol = initCtrl.getInitAccountBalanceCollection(view);
        if (initCol == null || initCol.size() == 0) {
            return;
        }
        IAccountBalance ctrl = AccountBalanceFactory.getLocalInstance(ctx);
        BigDecimal one = new BigDecimal("1");
        BigDecimal negOne = new BigDecimal("-1");
        int size = initCol.size();
        String startPeriodId = startPeriod.getId().toString();
        String firstPeriodId = firstPeriod.getId().toString();
        boolean first = startPeriodId.equals(firstPeriodId);
        for (int i = 0; i < size; ++i) {
            InitAccountBalanceInfo initInfo = initCol.get(i);
            AccountBalanceInfo info = new AccountBalanceInfo();
            info.setAccount(initInfo.getAccount());
            if (initInfo.getAccount() == null || initInfo.getAccount().getDC() == null) continue;
            BigDecimal dc = initInfo.getAccount().getDC().getValue() == 1 ? one : negOne;
            info.setBeginBalanceFor(initInfo.getBeginBalanceFor().multiply(dc));
            info.setBeginBalanceLocal(initInfo.getBeginBalanceLocal().multiply(dc));
            info.setBeginBalanceRpt(initInfo.getBeginBalanceRpt().multiply(dc));
            info.setBeginQty(initInfo.getBeginQty().multiply(dc));
            info.setEndBalanceFor(info.getBeginBalanceFor());
            info.setEndBalanceLocal(info.getBeginBalanceLocal());
            info.setEndBalanceRpt(info.getBeginBalanceRpt());
            info.setEndQty(info.getBeginQty());
            if (!first) {
                info.setYearCreditFor(initInfo.getYearCreditFor());
                info.setYearCreditLocal(initInfo.getYearCreditLocal());
                info.setYearCreditRpt(initInfo.getYearCreditRpt());
                info.setYearCreditQty(initInfo.getYearCreditQty());
                info.setYearDebitFor(initInfo.getYearDebitFor());
                info.setYearDebitLocal(initInfo.getYearDebitLocal());
                info.setYearDebitRpt(initInfo.getYearDebitRpt());
                info.setYearDebitQty(initInfo.getYearDebitQty());
                info.setYearPnLFor(initInfo.getYearPnLFor().multiply(dc));
                info.setYearPnLLocal(initInfo.getYearPnLLocal().multiply(dc));
                info.setYearPnLRpt(initInfo.getYearPnLRpt().multiply(dc));
            } else {
                info.setYearCreditFor(InitHelp.zero);
                info.setYearCreditLocal(InitHelp.zero);
                info.setYearCreditRpt(InitHelp.zero);
                info.setYearCreditQty(InitHelp.zero);
                info.setYearDebitFor(InitHelp.zero);
                info.setYearDebitLocal(InitHelp.zero);
                info.setYearDebitRpt(InitHelp.zero);
                info.setYearDebitQty(InitHelp.zero);
                info.setYearPnLFor(InitHelp.zero);
                info.setYearPnLLocal(InitHelp.zero);
                info.setYearPnLRpt(InitHelp.zero);
            }
            info.setDebitFor(InitHelp.zero);
            info.setDebitLocal(InitHelp.zero);
            info.setDebitRpt(InitHelp.zero);
            info.setDebitQty(InitHelp.zero);
            info.setCreditFor(InitHelp.zero);
            info.setCreditLocal(InitHelp.zero);
            info.setCreditRpt(InitHelp.zero);
            info.setCreditQty(InitHelp.zero);
            info.setOrgUnit(initInfo.getOrgUnit());
            info.setCurrency(initInfo.getCurrency());
            info.setPeriod(startPeriod);
            info.setBalType(VoucherStatusEnum.POSTED);
            ctrl.addnew(info);
            info.setBalType(VoucherStatusEnum.SUBMITTED);
            ctrl.addnew(info);
            if (first) continue;
            info.setPeriod(firstPeriod);
            info.setDebitFor(info.getYearDebitFor());
            info.setDebitLocal(info.getYearDebitLocal());
            info.setDebitRpt(info.getYearDebitRpt());
            info.setDebitQty(info.getYearDebitQty());
            info.setCreditFor(info.getYearCreditFor());
            info.setCreditLocal(info.getYearCreditLocal());
            info.setCreditRpt(info.getYearCreditRpt());
            info.setCreditQty(info.getYearCreditQty());
            info.setBeginBalanceFor(info.getEndBalanceFor().add(info.getYearCreditFor().subtract(info.getYearDebitFor())));
            info.setBeginBalanceLocal(info.getEndBalanceLocal().add(info.getYearCreditLocal().subtract(info.getYearDebitLocal())));
            info.setBeginBalanceRpt(info.getEndBalanceRpt().add(info.getYearCreditRpt().subtract(info.getYearDebitRpt())));
            info.setBeginQty(info.getEndQty().add(info.getYearCreditQty().subtract(info.getYearDebitQty())));
            info.setBalType(VoucherStatusEnum.POSTED);
            ctrl.addnew(info);
            info.setBalType(VoucherStatusEnum.SUBMITTED);
            ctrl.addnew(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _cancelInit(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String userId;
        MutexParameter mp;
        String orgUnitId = ((CompanyOrgUnitInfo)otherCtx.get("COMPANY")).getId().toString();
        PeriodInfo startPeriod = (PeriodInfo)otherCtx.get("STARTPERIOD");
        PeriodInfo firstPeriod = (PeriodInfo)otherCtx.get("FIRSTPERIOD");
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter current = mutex.requestMutex3(mp = GLMutexUtils.buildModifyBalanceParameter(ctx, orgUnitId, userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), "GL_Uninit"));
        if (current != null) {
            throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp)));
        }
        try {
            long start = System.currentTimeMillis();
            InitHelp.checkCancelInit(ctx, orgUnitId);
            System.out.println("2:" + (System.currentTimeMillis() - start));
            IGLBalanceFacade updateBalance = GLBalanceFacadeFactory.getLocalInstance(ctx);
            updateBalance.antiInitBalance(orgUnitId, startPeriod.getId().toString(), firstPeriod.getId().toString(), "T_GL_AccountBalance");
            IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
            flag.setGLInitClosed(false, orgUnitId);
            SystemStatusCtrolFactory.getLocalInstance((Context)ctx).start(SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)otherCtx.get("COMPANY"), false);
        }
        finally {
            mutex.releaseMutex(mp.getRequestId());
        }
    }

    @Override
    public Object[] _getGeneralLocal(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String localc = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
        return this.getAccountBalanceData(ctx, localc, otherCtx, 1);
    }

    @Override
    public Object[] _getGeneralReport(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String reportc = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
        return this.getAccountBalanceData(ctx, reportc, otherCtx, 2);
    }

    protected IGLFlag getFlagCtrl(Context ctx) throws BOSException {
        return GLFlagFactory.getLocalInstance(ctx);
    }

    @Override
    public Object[] _getAccountBalanceData(Context ctx, String currencyId, HashMap otherCtx) throws BOSException, EASBizException {
        return this.getAccountBalanceData(ctx, currencyId, otherCtx, 0);
    }

    @Override
    protected ArrayList _getInitDataByAssist(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String currencyId = (String)otherCtx.get("LOCALCURRENCYID");
        int type = Integer.parseInt((String)otherCtx.get("LOCALCURRENCY"));
        String fname = "fname_" + ctx.getLocale().getLanguage();
        String sql = "select balance.fcurrencyid,\t\t\t\t\t\r\n\tsum(balance.fbeginbalancefor) fbeginbalancefor,sum(balance.fyeardebitfor) fyeardebitfor, \t\t\t\t\t\r\n\tsum(balance.fyearcreditfor) fyearcreditfor,sum(balance.fdebitfor) fdebitfor, \t\t\t\t\t\t\t\t\r\n\tsum(balance.fcreditfor) fcreditfor,sum(balance.fendbalancefor) fendbalancefor, \t\t\t\t\t\t\t\t\r\n\tsum(balance.fbeginbalanceLocal) fbeginbalanceLocal,sum(balance.fyeardebitLocal) fyeardebitLocal, \t\t\t\r\n\tsum(balance.fyearcreditLocal) fyearcreditLocal,sum(balance.fdebitlocal) fdebitlocal, \t\t\t\t\t\t\r\n\tsum(balance.fcreditlocal) fcreditlocal,sum(balance.fendbalancelocal) fendbalancelocal, \t\t\t\t\t\t\r\n\tsum(balance.fbeginbalancerpt) fbeginbalancerpt,sum(balance.fyeardebitrpt) fyeardebitrpt, \t\t\t\t\t\r\n\tsum(balance.fyearcreditrpt) fyearcreditrpt,sum(balance.fdebitrpt) fdebitrpt, \t\t\t\t\t\t\t\t\r\n\tsum(balance.fcreditrpt) fcreditrpt,sum(balance.fendbalancerpt) fendbalancerpt, \t\t\t\t\t\t\t\t\r\n\tsum(balance.fbeginqty) fbeginqty,sum(balance.fyeardebitqty) fyeardebitqty, \t\t\t\t\t\t\t\t\t\r\n\tsum(balance.fyearcreditqty) fyearcreditqty,sum(balance.fdebitqty) fdebitqty, \t\t\t\t\t\t\t\t\r\n\tsum(balance.fcreditqty) fcreditqty,sum(balance.fendqty) fendqty, \t\t\t\t\t\t\t\t\t\t\t\r\n\tsum(balance.fyearpnlfor) fyearpnlfor,sum(balance.fmonthpnlfor) fmonthpnlfor, \t\t\t\t\t\t\t\t\r\n\tsum(balance.fyearpnllocal) fyearpnllocal,sum(balance.fmonthpnllocal) fmonthpnllocal,\t\t\t\t\t\t\r\n\tsum(balance.fyearpnlrpt) fyearpnlrpt,sum(balance.fmonthpnlrpt) fmonthpnlrpt, \t \t\t\t\t\t\t\t\r\n\tpaccount.fid faccountid,paccount.fnumber faccountnumber,paccount." + fname + " faccountname,paccount.flongnumber faccountlongnumber,\t\t\t\r\n\tpaccount.fisleaf fisleaf,paccount.flevel flevel,paccount.fdc ,paccount.fisqty ,paccount.fparentid fparentid,\t\t\t\t\t\t\t\r\n\tpaccount.fcurrencyid faccountcurrencyid,paccount.FAcctCurrency  acctcurrency ,paccount.FisGFreeze ,paccount.FisCFreeze ,paccount.FCAA\t\r\n   ,measureunit." + fname + "\tmeasureunitname,accounttype.fproperty\taccounttypeproperty\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n\tfrom  (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n      select balance.forgunitid,balance.faccountid,balance.fcurrencyid,\t\t\t\t\t\t\t\t\t\r\n      sum(balance.fbeginbalancefor) fbeginbalancefor,sum(balance.fyeardebitfor) fyeardebitfor,\t\t\t\t\r\n      sum(balance.fyearcreditfor) fyearcreditfor,sum(balance.fdebitfor) fdebitfor, \t\t\t\t\t\t\r\n      sum(balance.fcreditfor) fcreditfor,sum(balance.fendbalancefor) fendbalancefor, \t\t\t\t\t\t\r\n\t    sum(balance.fbeginbalanceLocal) fbeginbalanceLocal,sum(balance.fyeardebitLocal) fyeardebitLocal,\t\r\n      sum(balance.fyearcreditLocal) fyearcreditLocal,sum(balance.fdebitlocal) fdebitlocal, \t\t\t\t\r\n      sum(balance.fcreditlocal) fcreditlocal,sum(balance.fendbalancelocal) fendbalancelocal, \t\t\t\t\r\n  \t  sum(balance.fbeginbalancerpt) fbeginbalancerpt,sum(balance.fyeardebitrpt) fyeardebitrpt, \t\t\t\t\r\n    \tsum(balance.fyearcreditrpt) fyearcreditrpt,sum(balance.fdebitrpt) fdebitrpt, \t\t\t\t\t\t\r\n      sum(balance.fcreditrpt) fcreditrpt,sum(balance.fendbalancerpt) fendbalancerpt, \t\t\t\t\t\t\r\n\tsum(CASE WHEN ac.FIsQty = 0 THEN 0 ELSE balance.fstandardbeginqty * 1.0000 / ISNULL(MU.FCoefficient, 1) END) fbeginqty,\t\t\t\r\n\tsum(CASE WHEN ac.FIsQty = 0 THEN 0 ELSE balance.fstandardyeardebitqty * 1.0000 / ISNULL(MU.FCoefficient, 1) END) fyeardebitqty,\t\r\n\tsum(CASE WHEN ac.FIsQty = 0 THEN 0 ELSE balance.fstandardyearcreditqty * 1.0000 / ISNULL(MU.FCoefficient, 1) END) fyearcreditqty,\t\r\n\tsum(CASE WHEN ac.FIsQty = 0 THEN 0 ELSE balance.FStandardDebitQty * 1.0000 / ISNULL(MU.FCoefficient, 1) END) fdebitqty,\t\t\t\t\t\r\n\tsum(CASE WHEN ac.FIsQty = 0 THEN 0 ELSE balance.Fstandardcreditqty * 1.0000 / ISNULL(MU.FCoefficient, 1) END) fcreditqty,\t\t\t\t\t\r\n\tsum(CASE WHEN ac.FIsQty = 0 THEN 0 ELSE balance.Fstandardendqty * 1.0000 / ISNULL(MU.FCoefficient, 1) END) fendqty,\t\t\t\t\t\t\r\n      sum(balance.fyearpnlfor) fyearpnlfor,sum(balance.fmonthpnlfor) fmonthpnlfor,\t\t\t\t\t\t\t\r\n      sum(balance.fyearpnllocal) fyearpnllocal,sum(balance.fmonthpnllocal) fmonthpnllocal,\t\t\t\t\t\r\n      sum(balance.fyearpnlrpt) fyearpnlrpt,sum(balance.fmonthpnlrpt) fmonthpnlrpt \t \t\t\t\t\t\t\r\n      from t_gl_initassistbalance balance  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n      INNER JOIN t_BD_AccountView ac ON balance.faccountid = ac.fid\t\t\t\t\t\t\t\t\t\t\r\n      LEFT OUTER JOIN T_BD_MEASUREUNIT MU ON MU.FID = ac.FMeasureUnitID \t\t\t\t\t\t\t\t    \r\n       where balance.forgunitid=?                                                                          \r\n       and balance.fcurrencyid=?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n        \tgroup by balance.fcurrencyid ,balance.forgunitid,balance.faccountid \t) balance\t\t\t\t\r\n    inner join  t_BD_AccountView account   on balance.faccountid=account.fid\t\t\t\t\t\t\t\t\r\n    inner join  t_BD_AccountView paccount  on (charIndex(paccount.flongnumber||'!',account.flongnumber)=1  or paccount.fid = account.fid)\t\r\n          and account.Fcompanyid=paccount.Fcompanyid and account.faccountTableid=paccount.faccountTableid\t\t\r\n\tLEFT OUTER JOIN T_BD_MEASUREUNIT measureunit ON measureunit.FID = account.FMeasureUnitID   \t\t\t\t\t\r\n    left join t_bd_accounttype accounttype on accounttype.fid=account.faccounttypeid \t\t\t\t\t\t\t\t\t\r\n\t where account.fcompanyid=?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n     and  account.faccountTableid=?\t\t\t\t\t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\r\n     and  account.fid in ( \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n           select a.fid from t_bd_accountview a  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n                left join t_bd_accountcurrency b on  a.fid=b.faccountviewid   \t\t\t\t\t\t\t\t\t\r\n                where ((facctcurrency=1 and b.fcurrencyid=?)\t\t\t\t\t\t\t\t\t\t\t \t\t\r\n                  or facctcurrency=2 or facctcurrency=0  ) \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n                 and fcompanyid=?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n                 and  account.faccountTableid=?\t\t   )  \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n \tgroup by       balance.fcurrencyid,\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n\tpaccount.fid ,paccount.fnumber ,paccount.fname_" + ctx.getLocale().getLanguage() + " ,paccount.flongnumber ,paccount.fisleaf ,paccount.flevel ,\t\t\r\n\tpaccount.fdc ,paccount.fisqty ,paccount.fparentid ,paccount.fcurrencyid ,measureunit.fname_" + ctx.getLocale().getLanguage() + ",\t\t\t\t\t\t\r\n\tpaccount.FAcctCurrency   ,paccount.FisGFreeze ,paccount.FisCFreeze ,paccount.FCAA  ,accounttype.fproperty\t\t\t\r\n\torder by paccount.fnumber\t";
        ArrayList al = this.getAccountBalanceData(ctx, currencyId, otherCtx, type, sql, 1);
        return al;
    }

    @Override
    protected ArrayList _getInitDataByCussent(Context ctx, HashMap otherCtx) throws BOSException, EASBizException {
        String currencyId = (String)otherCtx.get("LOCALCURRENCYID");
        int type = Integer.parseInt((String)otherCtx.get("LOCALCURRENCY"));
        String fname = "fname_" + ctx.getLocale().getLanguage();
        String sql = "select balance.fcurrencyid,balance.fbeginbalancefor,balance.fyeardebitfor,balance.fyearcreditfor,balance.fdebitfor,balance.fcreditfor,balance.fendbalancefor,balance.fbeginbalanceLocal,balance.fyeardebitLocal,balance.fyearcreditLocal,balance.fdebitlocal,balance.fcreditlocal,balance.fendbalancelocal,balance.fbeginbalancerpt,balance.fyeardebitrpt,balance.fyearcreditrpt,balance.fdebitrpt,balance.fcreditrpt,balance.fendbalancerpt,balance.fbeginqty,balance.fyeardebitqty,balance.fyearcreditqty,balance.fdebitqty,balance.fcreditqty,balance.fendqty,balance.fyearpnlfor,balance.fmonthpnlfor,balance.fyearpnllocal,balance.fmonthpnllocal,balance.fyearpnlrpt,balance.fmonthpnlrpt,account.fid faccountid,account.fnumber faccountnumber,account." + fname + " faccountname,account.flongnumber faccountlongnumber,account.fisleaf fisleaf,account.flevel flevel,account.fdc ,account.fisqty ,account.fparentid fparentid,account.fcurrencyid faccountcurrencyid,account.accounttypeproperty  ,account.measureunitname,account.FisGFreeze ,account.FisCFreeze ,account.FCAA from (select balance.fcompanyid forgunitid,balance.faccountid,balance.fcurrencyid,\tsum(balance.funVerifiedAmtFor) fbeginbalancefor,0 fyeardebitfor,\t\tsum(0) fyearcreditfor,sum(0) fdebitfor,\t\tsum(0) fcreditfor,sum(balance.funVerifiedAmtFor) fendbalancefor,\t\tsum(balance.funVerifiedAmtLocal) fbeginbalanceLocal,sum(0) fyeardebitLocal,\t\tsum(0) fyearcreditLocal,sum(0) fdebitlocal,\t\tsum(0) fcreditlocal,sum(balance.funVerifiedAmtLocal) fendbalancelocal,\t\tsum(balance.funVerifiedAmtRpt) fbeginbalancerpt,sum(0) fyeardebitrpt,\t\tsum(0) fyearcreditrpt,sum(0) fdebitrpt,\t\tsum(0) fcreditrpt,sum(balance.funVerifiedAmtRpt) fendbalancerpt,\t\tsum(balance.funVerifiedQty) fbeginqty,sum(0) fyeardebitqty,\t\tsum(0) fyearcreditqty,sum(0) fdebitqty,\t\tsum(0) fcreditqty,sum(balance.funVerifiedQty) fendqty,\t\tsum(0) fyearpnlfor,sum(0) fmonthpnlfor,\t\tsum(0) fyearpnllocal,sum(0) fmonthpnllocal,\t\tsum(0) fyearpnlrpt,sum(0) fmonthpnlrpt\t\t from t_gl_acctcussent balance \t\t where balance.fcompanyid=?\t\t and balance.fcurrencyid=?\t\tgroup by balance.fcurrencyid ,balance.fcompanyid,balance.faccountid\t\t) balance  right outer join  ( select account.*,accounttype.fproperty accounttypeproperty,measureunit." + fname + " measureunitname from t_BD_AccountView account   left join t_bd_measureunitgroup measureunitgroup on account.fmeasureunitgroupid=measureunitgroup.fid  left join t_bd_measureunit measureunit on measureunit.fid=measureunitgroup.fdefaultunitid  left join t_bd_accounttype accounttype on accounttype.fid=account.faccounttypeid  where account.fcompanyid=? and account.fisprofitcenter <> 1";
        if (type != 1 && type != 2) {
            sql = sql + " and (account.fcurrencyid=? or (account.fcurrencyid is null)) ";
        }
        sql = sql + ") account on balance.faccountid=account.fid order by account.fnumber";
        ArrayList al = this.getAccountBalanceData(ctx, currencyId, otherCtx, type, sql, 1);
        return al;
    }

    @Override
    protected void _importBizSysBalance(Context ctx, List list, boolean isRewrite, boolean isAssist, Map bizSysMap) throws EASBizException, BOSException {
        String orgUnitId = null;
        if (bizSysMap == null) {
            bizSysMap = new HashMap<String, String>();
            orgUnitId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            bizSysMap.put("COMPANYID", orgUnitId);
        }
        orgUnitId = (String)bizSysMap.get("COMPANYID");
        CompanyOrgUnitInfo curCompany = GlUtils.getCurrentCompany(ctx, orgUnitId, null, false);
        bizSysMap.put("COMPANY", (String)curCompany);
        bizSysMap.put("ACCOUNTTABLEID", curCompany.getAccountTable().getId().toString());
        bizSysMap.put("CUID", curCompany.getCU().getId().toString());
        ArrayList otherPamra = this._getInitData(ctx, bizSysMap);
        bizSysMap.put("ISFOREIGN", (String)otherPamra.get(2));
        bizSysMap.put("ISUSEREPORT", (String)otherPamra.get(3));
        bizSysMap.put("STARTPERIOD", (String)otherPamra.get(4));
        bizSysMap.put("CURRENTPERIOD", (String)otherPamra.get(5));
        bizSysMap.put("FIRSTPERIOD", (String)otherPamra.get(6));
        if (isAssist) {
            this.checkCloseInit(ctx, true, true);
            this.importBizSysAssistBalance(ctx, list, isRewrite, bizSysMap);
        } else {
            this.checkCloseInit(ctx, true, false);
            this.importBizSysAccountBalance(ctx, list, isRewrite, bizSysMap);
        }
    }

    protected void importBizSysAccountBalance(Context ctx, List list, boolean isRewrite, Map bizSysMap) throws EASBizException, BOSException {
        Connection con = null;
        PreparedStatement select_stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            select_stmt = con.prepareStatement(this.getSelectSql(true));
            int size = list.size();
            String currencyId = (String)bizSysMap.get("ALLCURRENCYID");
            String orgUnitId = (String)bizSysMap.get("COMPANYID");
            Object[] datas = new AccountBalanceInitData[size];
            for (int i = 0; i < size; ++i) {
                InitAccountBalanceInfo data = (InitAccountBalanceInfo)list.get(i);
                AccountBalanceInitData userObject = new AccountBalanceInitData();
                datas[i] = userObject;
                AccountViewInfo account = data.getAccount();
                userObject.setAccountId(account.getId().toString());
                userObject.setAccountLongNumber(account.getLongNumber());
                userObject.setCurrencyId(currencyId);
                userObject.setAccountIsQty(account.isIsQty() ? 1 : -1);
                userObject.setAccountIsPLType(account.getAccountTypeID().getProperty().getValue() == 4);
                userObject.setAccountDC(account.getDC().getValue());
                userObject.setBeginBalanceFor(data.getBeginBalanceFor());
                userObject.setYearDebitFor(data.getYearDebitFor());
                userObject.setYearCreditFor(data.getYearCreditFor());
                userObject.setYearPnLFor(data.getYearPnLFor());
                userObject.setBeginBalanceLocal(data.getBeginBalanceLocal());
                userObject.setYearDebitLocal(data.getYearDebitLocal());
                userObject.setYearCreditLocal(data.getYearCreditLocal());
                userObject.setYearPnLLocal(data.getYearPnLLocal());
                userObject.setEndBalanceFor(data.getEndBalanceFor());
                userObject.setEndBalanceLocal(data.getEndBalanceLocal());
                userObject.setBeginBalanceReport(data.getBeginBalanceRpt());
                userObject.setYearDebitReport(data.getYearDebitRpt());
                userObject.setYearCreditReport(data.getYearCreditRpt());
                userObject.setYearPnLReport(data.getYearPnLRpt());
                userObject.setEndBalanceReport(data.getEndBalanceRpt());
                userObject.setBeginQty(data.getBeginQty());
                userObject.setYearDebitQty(data.getYearDebitQty());
                userObject.setYearCreditQty(data.getYearCreditQty());
                int index = 1;
                select_stmt.setString(index++, orgUnitId);
                select_stmt.setString(index++, data.getAccount().getId().toString());
                select_stmt.setString(index++, data.getCurrency().getId().toString());
                rs = select_stmt.executeQuery();
                boolean hasResult = false;
                if (rs.next()) {
                    hasResult = true;
                }
                if (!hasResult) {
                    userObject.setStatus(1);
                    continue;
                }
                if (isRewrite) {
                    userObject.setStatus(3);
                    continue;
                }
                datas[i] = null;
            }
            this._saveAccountBalance(ctx, datas, (HashMap)bizSysMap);
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, select_stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)select_stmt, (Connection)con);
    }

    protected void importBizSysAssistBalance(Context ctx, List list, boolean isRewrite, Map bizSysMap) throws EASBizException, BOSException {
        CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)bizSysMap.get("COMPANY");
        InitAssistBalanceCollection coll = new InitAssistBalanceCollection();
        int count = list.size();
        Connection con = null;
        PreparedStatement select_stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            select_stmt = con.prepareStatement(this.getSelectSql(false));
            for (int i = count - 1; i > -1; --i) {
                InitAssistBalanceInfo as = (InitAssistBalanceInfo)list.get(i);
                as.setOrgUnit(curCompany);
                int index = 1;
                select_stmt.setString(index++, curCompany.getId().toString());
                select_stmt.setString(index++, as.getAccount().getId().toString());
                select_stmt.setString(index++, as.getCurrency().getId().toString());
                select_stmt.setString(index++, as.getAssistGrp().getId().toString());
                rs = select_stmt.executeQuery();
                boolean hasResult = false;
                if (rs.next()) {
                    hasResult = true;
                }
                if (!hasResult) {
                    as.put("persist_status", "new");
                } else {
                    if (!isRewrite) continue;
                    as.put("persist_status", "dirty");
                }
                coll.add(as);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, select_stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)select_stmt, (Connection)con);
        AssistInitFacadeFactory.getLocalInstance(ctx).save(coll, (HashMap)bizSysMap);
    }

    protected int checkCloseInit(Context ctx, boolean isCheckAccount, boolean isCheckAssist) throws BOSException, EASBizException {
        IGLPeriodEndFacade facade = GLPeriodEndFacadeFactory.getLocalInstance(ctx);
        CompanyOrgUnitInfo company = this.getCurrentCompany(ctx);
        String curCompanyID = company.getId().toString();
        String companyid = company.getId().toString();
        String accounttableid = company.getId().toString();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        int index = 0;
        String loc = "_";
        loc = loc.concat(LocaleUtils.getLocaleString((Locale)ctx.getLocale()).trim());
        try {
            con = this.getConnection(ctx);
            if (isCheckAccount) {
                sql = new StringBuffer();
                sql.append("select 1 where exists          \t\t\r\n");
                sql.append("(select 1 from t_GL_Flag          \t\r\n");
                sql.append("where FOrgUnitID = ?                \r\n");
                sql.append("    and FName = 'glinit'            \r\n");
                sql.append("\tand FValue = 'true'            \t\r\n");
                sql.append(")\t\t\t\t\t\t\t\t\t\r\n");
                sql.append(";");
                stmt = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    throw new GLPeriodEndException(GLPeriodEndException.GL_INIT_CLOSED);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
            facade.checkAccountValid(curCompanyID);
            if (isCheckAssist) {
                sql = new StringBuffer();
                sql.append("select top 10 v1.*\t\t\t\t\t\t\t\r\n");
                sql.append("from                                \r\n");
                sql.append("(                                   \r\n");
                sql.append("select distinct acct.FID as FAccountID,     \r\n");
                sql.append("\tacct.FNumber as FAccountNumber, \t\t\r\n");
                sql.append("\tacct.FName");
                sql.append(loc);
                sql.append(" as FAccountName\t\t\t\t\t\t\t\r\n");
                sql.append("from t_bd_accountview acct,          \t\t\r\n");
                sql.append("\tt_bd_AccountType actype               \t\r\n");
                sql.append("where actype.FID = acct.FAccountTypeID    \t\r\n");
                sql.append("\tand acct.FCAA is not null       \t\t\r\n");
                sql.append("\tand acct.FcompanyId = ?   and acct.FaccountTableId=?        \t\t\r\n");
                sql.append("\tand acct.FIsLeaf = 1           \t\t\t\r\n");
                sql.append(")v1                                 \r\n");
                sql.append("left join                           \r\n");
                sql.append("(                                   \r\n");
                sql.append("select FKey from t_GL_Flag          \r\n");
                sql.append("where FOrgUnitID = ?                \r\n");
                sql.append("    and FName = 'astinit'           \r\n");
                sql.append("\tand FValue = 'true'            \t\r\n");
                sql.append(")v2                                 \r\n");
                sql.append("on v1.FAccountID = v2.FKey          \r\n");
                sql.append("                                    \r\n");
                sql.append("where v2.FKey is null               \r\n");
                sql.append("order by v1.FAccountNumber          \r\n");
                sql.append(";");
                stmt = con.prepareStatement(sql.toString());
                index = 1;
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)companyid);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)accounttableid);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index++, (String)curCompanyID);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    throw new GLPeriodEndException(GLPeriodEndException.ASST_INIT_CLOSED);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)con);
        }
        return 0;
    }

    protected CompanyOrgUnitInfo getCurrentCompany(Context ctx) throws BOSException, EASBizException {
        String curCompanyID = ContextUtils.getCurrentCompany((Context)ctx);
        SelectorItemCollection sic = GlUtils.getCompanySic();
        return GlUtils.getCurrentCompany(ctx, curCompanyID, sic, true);
    }

    @Override
    protected void _startUpdateBalance(Context ctx) throws BOSException {
        IRowSet rowset;
        boolean updateNowBalance = false;
        String sql = "select param.fnumber paramnumber, param.fdefaultval defaultval, \t\t\r\nparam.fuseredit useredit, item.fvalue itemvalue from T_BAS_Param param  \t\r\ninner join T_BAS_ParamItem item on param.fid = item.fkeyid \t\t\t\t\r\nwhere param.forgtype <> 8\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n and  (item.forgunitid is null and param.fnumber = 'GLG02') ";
        try {
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowset != null && rowset.next()) {
                updateNowBalance = "true".equalsIgnoreCase(rowset.getString("itemvalue")) ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
            }
        }
        catch (SQLException e) {
            return;
        }
        if (updateNowBalance) {
            sql = "select fnumber from t_bas_transaction where fnumber='updatebalance' and fsystype='6' ";
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rowset != null && rowset.next()) {
                    sql = "update t_bas_transaction set fupdatetime=(select top 1 fcreatetime from t_gl_voucher order by fcreatetime desc) ";
                    DbUtil.execute((Context)ctx, (String)sql);
                } else {
                    sql = "insert into T_BAS_Transaction values('7158CC40-7985-43B7-921C-1675105FEFD2BAACAADD',6,'updatebalance',CURDATE(),0) ";
                    DbUtil.execute((Context)ctx, (String)sql);
                }
            }
            catch (SQLException e1) {
                logger.error((Object)e1);
                throw new BOSException((Throwable)e1);
            }
        }
    }

    @Override
    protected boolean _isClosedInit(Context ctx, HashMap otherCtx) throws BOSException {
        IGLFlag flag = GLFlagFactory.getLocalInstance(ctx);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        String companyid = company.getId().toString();
        return flag.getGLInitClosed(companyid);
    }

    @Override
    protected Map _getPageInitData(Context ctx, Map paramMap) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)paramMap.get("COMPANY");
        if (company == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        String companyid = company.getId().toString();
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)ctx);
        EntityViewInfo currencyView = new EntityViewInfo();
        currencyView.getSorter().add(new SorterItemInfo("number"));
        CurrencyCollection curCol = curCtrl.getCurrencyCollection(currencyView, false);
        if (curCol.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        boolean isInitClosed = this.isInitClosed(ctx, companyid);
        paramMap.put("ISINITCLOSED", isInitClosed);
        Map hmParamValue = InitHelp.getInitParam(ctx, company);
        paramMap.put("GL_002", hmParamValue.get("GL_002"));
        paramMap.put("GL_008", hmParamValue.get("GL_008"));
        paramMap.put("G001", hmParamValue.get("G001"));
        PeriodInfo[] periods = this.getPeriods(ctx, company);
        paramMap.put("STARTPERIOD", periods[0]);
        paramMap.put("CURRENTPERIOD", periods[2]);
        paramMap.put("FIRSTPERIOD", periods[1]);
        CurrencyInfo generalLocalCurrency = null;
        CurrencyInfo generalReportCurrency = null;
        CurrencyInfo reportCur = company.getReportCurrency();
        CurrencyInfo localCur = company.getBaseCurrency();
        LinkedList<CurrencyInfo> removeList = new LinkedList<CurrencyInfo>();
        CurrencyInfo currency = company.getBaseCurrency();
        String bookCurrency = EASResource.getString((String)"com.kingdee.eas.fi.gl.InitResource", (String)"bookCurrency", (Locale)ctx.getOriginLocale());
        int size = curCol.size();
        for (int i = 0; i < size; ++i) {
            CurrencyInfo cur = curCol.get(i);
            if (cur.isGeneralLocalCurrency()) {
                generalLocalCurrency = cur;
                removeList.add(cur);
                continue;
            }
            if (cur.isGeneralReportCurrency()) {
                generalReportCurrency = cur;
                removeList.add(cur);
                continue;
            }
            if (!cur.getId().equals((Object)currency.getId()) || cur.getName().contains(bookCurrency)) continue;
            cur.setName(cur.getName() + bookCurrency);
        }
        for (CurrencyInfo removeInfo : removeList) {
            curCol.remove(removeInfo);
        }
        if (!Boolean.parseBoolean(hmParamValue.get("GL_008").toString())) {
            if (generalLocalCurrency != null) {
                curCol.add(generalLocalCurrency);
            }
            if (Boolean.parseBoolean(hmParamValue.get("G001").toString()) && generalReportCurrency != null) {
                curCol.add(generalReportCurrency);
            }
        }
        paramMap.put("COMPANY_CURCOLS", curCol);
        paramMap.put("COMPANY_ACCTABLE_COLS", InitHelp.getAccountTableCollection(ctx, company.getId().toString()));
        paramMap.put("GL_055", hmParamValue.get("GL_055"));
        if (periods[0] != null && periods[1] != null) {
            boolean isFirstPeriod = periods[0].getId().toString().equals(periods[1].getId().toString());
            paramMap.put("IS_FIRSTPERIOD", isFirstPeriod);
        }
        paramMap.put("IS_SETTLEBYLOCAL", 3 == company.getReportConvertMode().getValue());
        return paramMap;
    }

    public VoucherInfo.ExchangeRateWithValue getLocalExchangeRate(Context ctx, CompanyOrgUnitInfo companyInfo, String orgCurId, String localCurrencyId, PeriodInfo startPeriod) throws BOSException, EASBizException {
        if (orgCurId.equals(localCurrencyId)) {
            return VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
        }
        VoucherInfo.ExchangeRateWithValue ex = null;
        Object[] info = new Object[8];
        if (companyInfo.getBaseExchangeTable() == null) {
            throw new GLException(GLException.NOLOCALEXTABLE);
        }
        info[0] = companyInfo.getBaseExchangeTable().getId().toString();
        info[2] = orgCurId;
        info[3] = localCurrencyId;
        info[6] = startPeriod.getBeginDate();
        info[5] = startPeriod.getBeginDate();
        Object[] exes = AssistInitFacadeFactory.getLocalInstance(ctx).fetchExchangeRate(info);
        ex = (VoucherInfo.ExchangeRateWithValue)exes[0];
        return ex;
    }

    public VoucherInfo.ExchangeRateWithValue getReportingExchangeRate(Context ctx, CompanyOrgUnitInfo companyInfo, String orgCurId, String reportingCurrencyId, PeriodInfo startPeriod) throws BOSException, EASBizException {
        if (orgCurId.equals(reportingCurrencyId)) {
            return VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
        }
        VoucherInfo.ExchangeRateWithValue ex = null;
        Object[] info = new Object[8];
        if (companyInfo.getReportExchangeTable() == null) {
            throw new GLException(GLException.NOREPORTINGEXTABLE);
        }
        info[1] = companyInfo.getReportExchangeTable().getId().toString();
        info[2] = orgCurId;
        info[4] = reportingCurrencyId;
        info[6] = startPeriod.getBeginDate();
        info[5] = startPeriod.getBeginDate();
        Object[] exes = AssistInitFacadeFactory.getLocalInstance(ctx).fetchExchangeRate(info);
        ex = (VoucherInfo.ExchangeRateWithValue)exes[1];
        return ex;
    }

    @Override
    protected int _saveAccountBalanceList(Context ctx, AccountBalanceInitData[] accBalanceList, HashMap otherCtx) throws BOSException, EASBizException {
        int n;
        if (accBalanceList == null || accBalanceList.length == 0) {
            return 0;
        }
        int resCount = 0;
        Connection con = null;
        String orgUnitId = otherCtx.get("COMPANYID").toString();
        String accTableId = otherCtx.get("ACCOUNTTABLEID").toString();
        String currencyId = otherCtx.get("CURRENCY_ID").toString();
        StringBuilder sbu = new StringBuilder();
        sbu.append("delete from t_gl_initaccountbalance").append(" where forgunitid = '" + orgUnitId + "'").append(" and fcurrencyid = '" + currencyId + "'").append(" and  faccountid in (");
        for (int i = 0; i < accBalanceList.length; ++i) {
            AccountBalanceInitData aAccBalance = accBalanceList[i];
            sbu.append("'" + aAccBalance.getAccountId() + "'");
            if (i + 1 == accBalanceList.length) continue;
            sbu.append(",");
        }
        sbu.append(")");
        PreparedStatement new_stmt = null;
        PreparedStatement delete_stmt = null;
        Object rs = null;
        String insertNewSql = this.getNewSql();
        try {
            con = this.getConnection(ctx);
            delete_stmt = con.prepareStatement(sbu.toString());
            delete_stmt.executeUpdate();
            delete_stmt.close();
            new_stmt = con.prepareStatement(insertNewSql);
            int accLength = accBalanceList.length;
            for (int i = 0; i < accLength; ++i) {
                AccountBalanceInitData data = accBalanceList[i];
                data.setCurrencyId(currencyId);
                int index = 1;
                new_stmt.setString(index++, orgUnitId);
                new_stmt.setString(index++, data.getAccountId());
                new_stmt.setString(index++, currencyId);
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getBeginBalanceFor()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getBeginBalanceLocal()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getBeginBalanceReport()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getEndBalanceFor()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getEndBalanceLocal()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getEndBalanceReport()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearDebitFor()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearDebitLocal()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearDebitReport()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearCreditFor()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearCreditLocal()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearCreditReport()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getBeginQty()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getBeginQty()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearDebitQty()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearCreditQty()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearPnLFor()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearPnLLocal()));
                new_stmt.setBigDecimal(index++, InitHelp.nvl(data.getYearPnLReport()));
                new_stmt.addBatch();
                if (i != 0 && i % 8192 == 0) {
                    resCount += new_stmt.executeBatch().length;
                    new_stmt.clearParameters();
                }
                if (i + 1 != accLength || (i + 1) % 8192 <= 0) continue;
                resCount += new_stmt.executeBatch().length;
                new_stmt.clearParameters();
            }
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
            otherCtx.put("COMPANY", companyInfo);
            this.sum(ctx, con, accBalanceList, otherCtx);
            StringBuffer clearZero = new StringBuffer();
            clearZero.append("delete from t_gl_initaccountbalance").append(" where fbeginbalancefor=0 and fyeardebitfor=0 and fyearcreditfor=0 and fdebitfor=0 and fcreditfor=0").append(" and fendbalancefor=0 and fbeginbalancelocal=0 and fyeardebitlocal=0 and fyearcreditlocal=0 ").append(" and fdebitlocal=0 and fcreditlocal=0 and fendbalancelocal=0 and fbeginbalancerpt=0 ").append(" and fyeardebitrpt=0 and fyearcreditrpt=0 and fdebitrpt=0 and fcreditrpt=0 and fendbalancerpt=0").append(" and fyearpnlfor=0 and fmonthpnlfor=0 and fyearpnllocal=0 and fmonthpnllocal=0 and fyearpnlrpt=0 and fmonthpnlrpt=0").append(" and fbeginqty=0 and fyeardebitqty=0 and fyearcreditqty=0 and fdebitqty=0 and fcreditqty=0 and fendqty=0").append(" and forgunitid='" + orgUnitId + "'");
            delete_stmt = con.prepareStatement(clearZero.toString());
            delete_stmt.executeUpdate();
            delete_stmt.close();
            n = resCount;
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(new_stmt);
                SQLUtils.cleanup(delete_stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)new_stmt);
        SQLUtils.cleanup((Statement)delete_stmt, (Connection)con);
        return n;
    }

    @Override
    protected SystemStatusCtrolCollection _sysCascadeCheck(Context ctx, String companyIdStr, String periodIdStr) throws BOSException, EASBizException {
        long start = System.currentTimeMillis();
        logger.info((Object)" GLInitFacadeControllerBean _sysCascadeCheck come in");
        SystemStatusCtrolCollection col = null;
        PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodIdStr));
        Integer iYear = new Integer(period.getPeriodYear());
        Integer iMonth = new Integer(period.getPeriodNumber());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)companyIdStr));
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.GENERALLEDGER.getValue()), CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("isStart", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("isRelatedAccount", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("relatedPeriod.periodYear", (Object)iYear));
        fic.add(new FilterItemInfo("relatedPeriod.periodNumber", (Object)iMonth));
        filter.setMaskString("#0 and #1 and #2 and #3  and #4 and #5");
        ISystemStatusCtrol ctrl = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        col = ctrl.getSystemStatusCtrolCollection(view);
        logger.info((Object)(" GLInitFacadeControllerBean _sysCascadeCheck spents:" + (System.currentTimeMillis() - start)));
        return col;
    }
}

