/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLConfig;
import com.kingdee.eas.fi.gl.GLParamInfo;
import com.kingdee.eas.fi.gl.ParamException;
import com.kingdee.eas.fi.gl.app.AbstractGLParamFacadeControllerBean;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GLParamFacadeControllerBean
extends AbstractGLParamFacadeControllerBean {
    private final IMetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.fi.gl.app", "GLParamQuery");

    private HashMap innerGetGLParamInfo(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        String locala = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String sql = " select param.fid paramid,param.fnumber fnumber,param.fdefaultval_" + locala + " defaultvalue,item.fid itemid,item.fvalue_" + locala + " fvalue,item.forgunitid orgunitid,item.fiscontrolsub iscontrolsub,item.fismodify ismodify from t_bas_param param left join t_bas_paramitem item on param.fid=item.fkeyid and item.forgunitid=?where param.fsubsysid=? ";
        Connection con = null;
        HashMap<String, ParamItemInfo> prop = new HashMap<String, ParamItemInfo>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql);
            ps.setString(1, company.get(company.getPKField()).toString());
            ps.setString(2, this.getSubSysId());
            rs = ps.executeQuery();
            while (rs.next()) {
                ParamItemInfo info = new ParamItemInfo();
                String id = rs.getString("itemid");
                String value = null;
                if (id != null) {
                    info.setId(BOSUuid.read((String)id));
                    value = rs.getString("fvalue");
                } else {
                    value = rs.getString("defaultvalue");
                }
                info.setValue(value);
                ParamInfo paraminfo = new ParamInfo();
                paraminfo.setId(BOSUuid.read((String)rs.getString("paramid")));
                String number = rs.getString("fnumber");
                paraminfo.setNumber(number);
                info.setKeyID(paraminfo);
                prop.put(number, info);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return prop;
    }

    @Override
    protected GLParamInfo _getGLParamInfo(Context ctx, IObjectValue comValue) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)comValue;
        HashMap prop = new HashMap();
        prop = this.innerGetGLParamInfo(ctx, company);
        if (prop.size() == 0) {
            throw new ParamException(ParamException.NOTINIT, new Object[]{""});
        }
        return this.genParamInfoFromProp(prop);
    }

    @Override
    protected boolean _save(Context ctx, GLParamInfo paramInfo, HashMap otherCtx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)otherCtx.get("COMPANY");
        IParamItem paramItemCtrl = ParamItemFactory.getLocalInstance((Context)ctx);
        for (ParamItemInfo info : paramInfo.getProperties().values()) {
            this.checkParamUpdate(ctx, info.getKeyID(), company.getId().toString());
            if ("update".equals(info.get("status"))) {
                ParamManager.updateParamItemByNumberAndOrg((Context)ctx, (String)info.getKeyID().getNumber(), (String)company.getId().toString(), (String)info.getValue());
                continue;
            }
            info.setIsControlSub(false);
            info.setIsModify(true);
            info.setOrgUnitID((OrgUnitInfo)company);
            info.setValue(info.getValue(), LocaleUtils.getLocale((String)"l1"));
            info.setValue(info.getValue(), LocaleUtils.getLocale((String)"l2"));
            info.setValue(info.getValue(), LocaleUtils.getLocale((String)"l3"));
            paramItemCtrl.addnewNoVerify(info, info.getKeyID());
        }
        return true;
    }

    private GLParamInfo genParamInfoFromProp(HashMap prop) {
        return new GLParamInfo(prop);
    }

    private String getSubSysId() {
        return "com.kingdee.eas.fi.gl.gl";
    }

    private void checkParamUpdate(Context ctx, ParamInfo param, String orgUnitId) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String number = param.getNumber();
        try {
            con = this.getConnection(ctx);
            if (number.equals("GL_008")) {
                String sql = "select top 1 fid from t_gl_voucher where fcompanyid=?";
                ps = con.prepareStatement(sql);
                ps.setString(1, orgUnitId);
                rs = ps.executeQuery();
                if (rs.next()) {
                    throw new ParamException(ParamException.CHECK_MODIFY_FOREIGNCURRENCY);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                sql = "select top 1 faccountid from t_gl_initaccountbalance where forgunitid=?";
                ps = con.prepareStatement(sql);
                ps.setString(1, orgUnitId);
                rs = ps.executeQuery();
                if (rs.next()) {
                    throw new ParamException(ParamException.CHECK_MODIFY_FOREIGNCURRENCY);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                sql = "select top 1 faccountid from t_gl_initassistbalance where forgunitid=?";
                ps = con.prepareStatement(sql);
                ps.setString(1, orgUnitId);
                rs = ps.executeQuery();
                if (rs.next()) {
                    throw new ParamException(ParamException.CHECK_MODIFY_FOREIGNCURRENCY);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                sql = "select top 1 fid from t_gl_acctcussent where fcompanyid=?";
                ps = con.prepareStatement(sql);
                ps.setString(1, orgUnitId);
                rs = ps.executeQuery();
                if (rs.next()) {
                    throw new ParamException(ParamException.CHECK_MODIFY_FOREIGNCURRENCY);
                }
            } else if (number.equals("GL_028")) {
                String sql = "select top 1 fid from t_gl_voucher where fcompanyid=?";
                ps = con.prepareStatement(sql);
                ps.setString(1, orgUnitId);
                rs = ps.executeQuery();
                if (rs.next()) {
                    throw new ParamException(ParamException.CHECK_MODIFY_ACCTCUSSENT);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                ISystemStatusCtrol iSysStatusCtr = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
                boolean b = iSysStatusCtr.isRelatedAccount(orgUnitId, SystemEnum.ACCOUNTSPAYABLE);
                if (b) {
                    throw new ParamException(ParamException.CHECK_MODIFY_CUSSENT_PAY);
                }
                b = iSysStatusCtr.isRelatedAccount(orgUnitId, SystemEnum.ACCOUNTSRECEIVABLE);
                if (b) {
                    throw new ParamException(ParamException.CHECK_MODIFY_CUSSENT_REV);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
    }

    @Override
    protected void _dealRptCurrency(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
        StringBuffer sql = new StringBuffer();
        sql.append(" update   T_BKS_AcountScheme as ac set  FReportCurrencyID= '");
        sql.append(company.getReportCurrency().getId().toString());
        sql.append("'");
        sql.append(" where ac.FIsLock=1                  \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
        sql = new StringBuffer();
        sql.append(" update   T_BKS_AcountScheme as ac set  (FRptRateTableID)=(select  FReportExgTableID from t_org_company com where ac.FCONTROLUNITID = com.fid and ac.FIsLock=1  and ac.FIsMaster = 0 and  ac.FRptRateTableID is null )  \r\n");
        sql.append(" where ac.FIsLock=1   and  ac.FRptRateTableID is null                \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
        sql = new StringBuffer();
        sql.append(" update   T_BKS_AcountScheme as ac set  (FType)=(select  FReportConvertMode from t_org_company com where ac.FCONTROLUNITID = com.fid and ac.FIsLock=1  and ac.FIsMaster = 0 and  ac.FType = 2 )  \r\n");
        sql.append(" where ac.FIsLock=1   and  ac.FType = 2                \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
    }

    @Override
    protected Map _getSysProps(Context ctx) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("EAS_INSTANCE_CONFIG_PATH", System.getProperty("EAS_INSTANCE_CONFIG_PATH"));
        return map;
    }

    @Override
    protected List _getGLConfigs(Context ctx) throws BOSException {
        return GLConfig.getConfigs(ctx);
    }

    @Override
    protected void _saveGLConfigs(Context ctx, List configs) throws BOSException {
        GLConfig.saveConfigs(ctx, configs);
    }
}

