/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.fi.gl.app.AbstractGLPeriodFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLPeriodFacadeControllerBean
extends AbstractGLPeriodFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLPeriodFacadeControllerBean");

    @Override
    protected Set _getPeriodIds(Context ctx, Set companyIds, int from, int to) throws BOSException {
        HashSet<String> periodIds = new HashSet<String>();
        if (companyIds == null || companyIds.isEmpty()) {
            return periodIds;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT \n");
        sql.append("    distinct p.FID \n");
        sql.append("FROM T_ORG_Company c \n");
        sql.append("join T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = c.FID \n");
        sql.append("join T_BD_SystemStatus ss on ss.FID = ssc.FSystemStatusID \n");
        sql.append("join T_BD_Period sp on sp.FID = ssc.FStartPeriodID \n");
        sql.append("join T_BD_Period p on p.FTypeID = c.FACCOUNTPERIODID \n");
        sql.append("where ss.FNAME = 6 \n");
        sql.append("    and p.fnumber >= sp.FNUMBER \n");
        sql.append("    and c.FID in (" + this.toInSqlForIds(companyIds) + ") \n");
        sql.append("    and p.fnumber >= " + from + " \n");
        sql.append("    and p.fnumber <= " + to + " \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                periodIds.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return periodIds;
    }

    @Override
    protected Set _getPeriodIds(Context ctx, Set companyIds, Date from, Date to) throws BOSException {
        HashSet<String> periodIds = new HashSet<String>();
        if (companyIds == null || companyIds.isEmpty()) {
            return periodIds;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT \n");
        sql.append("    distinct p.FID \n");
        sql.append("FROM T_ORG_Company c \n");
        sql.append("join T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = c.FID \n");
        sql.append("join T_BD_SystemStatus ss on ss.FID = ssc.FSystemStatusID \n");
        sql.append("join T_BD_Period sp on sp.FID = ssc.FStartPeriodID \n");
        sql.append("join T_BD_Period p on p.FTypeID = c.FACCOUNTPERIODID \n");
        sql.append("where ss.FNAME = 6 \n");
        sql.append("    and p.fnumber >= sp.FNUMBER \n");
        sql.append("    and c.FID in (" + this.toInSqlForIds(companyIds) + ") \n");
        sql.append("    and ( \n");
        sql.append("        p.FBeginDate < {ts'" + DateTimeUtils.format((Date)from) + "'} and p.FEndDate >= {ts'" + DateTimeUtils.format((Date)from) + "'} \n");
        sql.append("        or \n");
        sql.append("        p.FBeginDate >= {ts'" + DateTimeUtils.format((Date)from) + "'} and p.FBeginDate <= {ts'" + DateTimeUtils.format((Date)to) + "'} \n");
        sql.append("    ) \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                periodIds.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return periodIds;
    }

    @Override
    protected List _getPeriodNumbers(Context ctx, Set companyIds) throws BOSException {
        ArrayList<PeriodInfo> periodInfos = new ArrayList<PeriodInfo>();
        if (companyIds == null || companyIds.isEmpty()) {
            return periodInfos;
        }
        String sql = "SELECT distinct p.FID, p.FNumber, p.FPeriodYear, p.FPeriodNumber \nFROM T_ORG_Company c \njoin T_BD_SystemStatusCtrol ssc on ssc.FCompanyID = c.FID \njoin T_BD_SystemStatus ss on ss.FID = ssc.FSystemStatusID \njoin T_BD_Period sp on sp.FID = ssc.FStartPeriodID \njoin T_BD_Period p on p.FTypeID = c.FAccountPeriodID \nwhere ss.FName = 6 \n    and p.FNumber >= sp.FNumber \n    and c.FID in (" + this.toInSqlForIds(companyIds) + ") \norder by p.FNumber ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                PeriodInfo period = new PeriodInfo();
                period.setId(BOSUuid.read((String)rs.getString("FID")));
                period.setNumber(rs.getInt("FNumber"));
                period.setPeriodYear(rs.getInt("FPeriodYear"));
                period.setPeriodNumber(rs.getInt("FPeriodNumber"));
                periodInfos.add(period);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return periodInfos;
    }

    private String toInSqlForIds(Set ids) {
        StringBuffer sql = new StringBuffer();
        for (Object id : ids) {
            sql.append("'").append(id).append("',");
        }
        if (sql.length() > 0) {
            sql.deleteCharAt(sql.length() - 1);
        }
        return sql.toString();
    }
}

