/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.ReportConditionAssistBase;
import com.kingdee.eas.fi.gl.ReportConditionBalanceListAssist;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.ReportConditionGeneralLedgerAssist;
import com.kingdee.eas.fi.gl.ReportConditionSubsidiaryLedger;
import com.kingdee.eas.fi.gl.ReportConditionSubsidiaryLedgerAssist;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.RptTreeNodeInfo;
import com.kingdee.eas.fi.gl.app.AbstractGLReportAssistTreeControllerBean;
import com.kingdee.eas.fi.gl.app.ReportPartner;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class GLReportAssistTreeControllerBean
extends AbstractGLReportAssistTreeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLReportAssistTreeControllerBean");
    private SqlParams AsstWhereSp = new SqlParams();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ReportResultInfo _findAssistTree(Context ctx, EntityViewInfo condition, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        LowTimer t = new LowTimer();
        t.reset();
        ReportPartner partner = new ReportPartner(ctx);
        partner.setCompany(company);
        partner.setCondition(condition);
        try {
            partner.setConnection(this.getConnection(ctx));
            ReportResultInfo result = new ReportResultInfo();
            result.setRowCount(0);
            AccountViewInfo accountViewInfo = this.getAccountViewInfoForAssist(partner);
            result.getExtendData().put("Account", accountViewInfo);
            result.getExtendData().put("ParmAssitemShowNumber", partner.isParmAssitemShowNumber());
            result.getExtendData().put("ParmAssitemShowLongName", partner.isParmAssitemShowLongName());
            result.getExtendData().put("AccountShowLongName", partner.isParmAccountShowLongName());
            result.getData().addAll(this.getAssistAccountTree(ctx, partner, accountViewInfo));
            result.setTime(t.msValue());
            t.reset();
            ReportResultInfo reportResultInfo = result;
            return reportResultInfo;
        }
        finally {
            SQLUtils.cleanup((Connection)partner.getConnection());
        }
    }

    protected ArrayList getAssistAccountTree(Context ctx, ReportPartner partner, AccountViewInfo accountViewInfo) throws BOSException, EASBizException {
        ArrayList<RptTreeNodeInfo> rootList = new ArrayList<RptTreeNodeInfo>();
        if (accountViewInfo == null) {
            throw new ReportException(ReportException.GET_ACCOUNT_ERROR);
        }
        ReportConditionBase condition = partner.getFixCondition();
        Set<String> caas = new HashSet<String>();
        String asstAccountId = null;
        if (condition instanceof ReportConditionSubsidiaryLedgerAssist) {
            asstAccountId = ((ReportConditionSubsidiaryLedgerAssist)condition).getAsstAccountId();
        } else if (condition instanceof ReportConditionGeneralLedgerAssist) {
            asstAccountId = ((ReportConditionGeneralLedgerAssist)condition).getAsstAccountId();
        }
        if (asstAccountId != null) {
            caas.add(asstAccountId);
        } else {
            caas = AccountFacadeFactory.getLocalInstance((Context)ctx).getCAAIdsByPeriodRange(accountViewInfo.getId().toString(), condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart(), condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd());
        }
        if (caas.size() == 0) {
            return rootList;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", caas, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        view.setSelector(selector);
        AsstAccountCollection coll = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstAccountCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            RptTreeNodeInfo root = new RptTreeNodeInfo();
            root.setId(coll.get(i).getId().toString());
            root.setName(coll.get(i).getName());
            root.setItem(false);
            rootList.add(root);
            Map typeMap = this.getAsstActType(partner, root);
            this.getAsstActItem(ctx, partner, typeMap, root);
        }
        return rootList;
    }

    protected AccountViewInfo getAccountViewInfoForAssist(ReportPartner partner) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(partner.getFixCondition().getAccountId());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("IsLeaf"));
        sic.add(new SelectorItemInfo("IsQty"));
        sic.add(new SelectorItemInfo("CAA.id"));
        sic.add(new SelectorItemInfo("CAA.number"));
        sic.add(new SelectorItemInfo("CAA.name"));
        IAccountView iAccount = AccountViewFactory.getLocalInstance((Context)partner.getContext());
        AccountViewInfo accountViewInfo = iAccount.getAccountViewInfo((IObjectPK)pk, sic);
        return accountViewInfo;
    }

    protected Map getAsstActType(ReportPartner partner, RptTreeNodeInfo root) throws BOSException, EASBizException {
        HashMap<RptTreeNodeInfo, String[]> map = new HashMap<RptTreeNodeInfo, String[]>();
        String sql = this.getAsstActTypeSql(partner);
        SqlParams parameter = this.getAsstActTypeParameters(partner, root);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = partner.getConnection().prepareStatement(sql);
            stmt.setFetchSize(100);
            parameter.putToStatement(stmt);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String[] nodeData = new String[8];
                RptTreeNodeInfo node = new RptTreeNodeInfo();
                node.setId(rs.getString("FID"));
                node.setTypeId(rs.getString("FID"));
                node.setNumber(rs.getString("FNumber"));
                node.setName(rs.getString("FName"));
                root.addChildNode(node);
                nodeData[0] = rs.getString("FRealtionDataObject");
                nodeData[1] = rs.getString("FMappingFieldName");
                nodeData[2] = rs.getString("FIsMultiLevel");
                nodeData[3] = rs.getString("FGroupTableName");
                nodeData[4] = rs.getString("FGroupMappingFieldName");
                nodeData[5] = rs.getString("fglasstacttypegrpid");
                nodeData[6] = rs.getString("FAsstHGAttribute");
                nodeData[7] = rs.getString("FUseLongNumber");
                map.put(node, nodeData);
            }
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return map;
    }

    protected void getAsstActItemTree(Context ctx, ReportPartner partner, RptTreeNodeInfo typeNode, String[] nodeData, RptTreeNodeInfo root, int style) throws BOSException, EASBizException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        SqlParams parameter = new SqlParams();
        String sql = null;
        this.getAsstActItemParameters(parameter, partner, 0);
        switch (style) {
            case 1: {
                sql = this.getAsstActItemSqlAll(partner, typeNode, nodeData);
                this.getAsstActItemParameters(parameter, partner, 1);
                break;
            }
            case 2: {
                sql = this.getAsstActItemSqlAllForGrade(ctx, partner, typeNode, nodeData, parameter);
            }
        }
        TreeMap<String, MyTree> sortedMap = new TreeMap<String, MyTree>();
        try {
            boolean useLongNumber;
            stmt = partner.getConnection().prepareStatement(sql);
            stmt.setFetchSize(100);
            if (style != 2) {
                parameter.putToStatement(stmt);
            }
            rs = stmt.executeQuery();
            boolean isGeneralType = nodeData[6] != null && nodeData[6].startsWith("generalAssActType");
            boolean bl = useLongNumber = nodeData[7] != null && "1".equals(nodeData[7]);
            while (rs.next()) {
                MyTree tree = new MyTree();
                tree.setFID(rs.getString("FID"));
                tree.setFID1(rs.getString("FID1"));
                if ((isGeneralType && partner.isRptShowLongNumberFromGeneral() || !isGeneralType && useLongNumber) && rs.getString("FLongNumber") != null && rs.getString("FLongNumber").trim().length() > 0) {
                    tree.setNumber(rs.getString("FLongNumber").replaceAll("!", "."));
                } else {
                    tree.setNumber(rs.getString("FNumber"));
                }
                tree.setLongNumber(rs.getString("FLongNumber"));
                tree.setName(rs.getString("FName"));
                tree.setParentID(rs.getString("FParentID"));
                sortedMap.put(tree.getLongNumber() + " " + tree.getFID(), tree);
            }
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        this.getTree(typeNode, sortedMap);
    }

    protected void getTree(RptTreeNodeInfo typeNode, SortedMap sortedMap) {
        Iterator iterator = sortedMap.values().iterator();
        HashMap<String, RptTreeNodeInfo> map = new HashMap<String, RptTreeNodeInfo>();
        String fID1 = null;
        StringBuffer fIDTotal = new StringBuffer();
        RptTreeNodeInfo node = null;
        HashSet<String> typeNodeSet = new HashSet<String>();
        while (iterator.hasNext()) {
            MyTree tree = (MyTree)iterator.next();
            String fID1Temp = tree.getFID1();
            typeNodeSet.add(tree.getFID());
            if (fID1Temp.equals(fID1)) {
                fIDTotal.append("','");
                fIDTotal.append(tree.getFID());
                continue;
            }
            if (node != null) {
                node.setId(fIDTotal.toString());
            }
            node = new RptTreeNodeInfo();
            node.setNumber(tree.getNumber());
            node.setName(tree.getName());
            node.setLongNumber(tree.getLongNumber());
            node.setItem(true);
            map.put(node.getLongNumber(), node);
            if (tree.getParentID() != null && tree.getParentID().length() > 0) {
                int end = node.getLongNumber().lastIndexOf(33);
                String parentLongNumber = node.getLongNumber();
                if (-1 != end) {
                    parentLongNumber = node.getLongNumber().substring(0, end);
                }
                if (map.containsKey(parentLongNumber)) {
                    RptTreeNodeInfo parentNode = (RptTreeNodeInfo)map.get(parentLongNumber);
                    parentNode.addChildNode(node);
                    parentNode.setId(parentNode.getId() + "','");
                }
            } else {
                typeNode.addChildNode(node);
            }
            fID1 = fID1Temp;
            fIDTotal = new StringBuffer(tree.getFID());
        }
        if (node != null) {
            node.setId(fIDTotal.toString());
        }
        if (typeNode.getSonNodeList() != null) {
            Iterator iterator1 = typeNodeSet.iterator();
            StringBuffer typeNodeBuf = new StringBuffer();
            while (iterator1.hasNext()) {
                typeNodeBuf.append((String)iterator1.next());
                typeNodeBuf.append("','");
            }
            typeNode.setId(typeNodeBuf.toString());
        }
    }

    protected void getAsstActItemTree(ReportPartner partner, RptTreeNodeInfo typeNode, String[] nodeData, RptTreeNodeInfo root) throws BOSException, EASBizException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = this.getAsstActItemSql(partner, typeNode, nodeData);
        SqlParams parameter = new SqlParams();
        this.getAsstActItemParameters(parameter, partner, 0);
        try {
            stmt = partner.getConnection().prepareStatement(sql);
            stmt.setFetchSize(100);
            parameter.putToStatement(stmt);
            rs = stmt.executeQuery();
            StringBuffer typeNodeID = new StringBuffer();
            while (rs.next()) {
                String fID = rs.getString("FID");
                typeNodeID.append("','");
                typeNodeID.append(fID);
                RptTreeNodeInfo node = new RptTreeNodeInfo();
                node.setId(fID);
                node.setNumber(rs.getString("FNumber"));
                node.setLongNumber(rs.getString("FNumber"));
                node.setName(rs.getString("FName"));
                node.setItem(true);
                typeNode.addChildNode(node);
            }
            if (typeNode.getSonNodeList() != null) {
                typeNode.setId(typeNodeID.toString());
            }
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    protected void getAsstActItem(Context ctx, ReportPartner partner, Map typeMap, RptTreeNodeInfo root) throws BOSException, EASBizException {
        block4: for (RptTreeNodeInfo typeNode : typeMap.keySet()) {
            String[] nodeData = (String[])typeMap.get(typeNode);
            switch (this.getIsGroup(nodeData)) {
                case 1: {
                    this.getAsstActItemTree(ctx, partner, typeNode, nodeData, root, 1);
                    continue block4;
                }
                case 2: {
                    this.getAsstActItemTree(ctx, partner, typeNode, nodeData, root, 2);
                    continue block4;
                }
            }
            this.getAsstActItemTree(partner, typeNode, nodeData, root);
        }
    }

    protected String getAsstActTypeSql(ReportPartner partner) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TAT.FID,TAT.FNumber,TAT.FName");
        sql.append(partner.getFieldNameExtend());
        sql.append(" FName,TAT.FRealtionDataObject,FMappingFieldName,TAT.FGroupTableName,TAT.FGroupMappingFieldName,TAT.FIsMultilevel,Tat.fglasstacttypegrpid,TAT.FAsstHGAttribute,TAT.FUseLongNumber \r\n");
        sql.append("\tFROM T_BD_AsstActGroupDetail TAAGD \r\n");
        sql.append("\tINNER JOIN T_BD_AsstActType TAT \r\n");
        sql.append("\tON TAAGD.FAsstActTypeID = TAT.FID \r\n");
        sql.append("WHERE TAAGD.FAsstAccountId = ? \r\n");
        this.processLinkAsstActType(partner, "TAT", sql);
        sql.append("ORDER BY TAT.FNumber ");
        return sql.toString();
    }

    protected SqlParams getAsstActTypeParameters(ReportPartner partner, RptTreeNodeInfo root) throws BOSException, EASBizException {
        SqlParams parameter = new SqlParams();
        parameter.setString(1, root.getId());
        return parameter;
    }

    private void addWhere(ReportPartner partner, StringBuffer sql) {
        ReportConditionBase fixCondition = partner.getFixCondition();
        String currencyId = fixCondition.getCurrencyID();
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer where = new StringBuffer();
        if (isForCurrency) {
            where.append("  \t\t\tand (TAB.FdebitFor !=0 OR TAB.FcreditFor!=0 OR TAB.FendBalanceFor != 0 ");
        } else if (isLocalCurrency) {
            where.append("  \t\t\tand (TAB.FdebitLocal !=0 OR TAB.FcreditLocal!=0 OR TAB.FendBalanceLocal != 0 ");
        } else if (isRptCurrency) {
            where.append("  \t\t\tand (TAB.FdebitRpt !=0 OR TAB.FcreditRpt!=0 OR TAB.FendBalanceRpt != 0 ");
        }
        where.append(" )\t\r\n");
        if (fixCondition instanceof ReportConditionBalanceListAssist) {
            ReportConditionBalanceListAssist rcbl = (ReportConditionBalanceListAssist)fixCondition;
            if (!StringUtils.isEmpty((String)rcbl.getAssistItemId())) {
                sql.append(" and THG.FID in ('" + rcbl.getAssistItemId() + "') \r\n");
            }
            if (rcbl.isOptionAmountZero()) {
                sql.append(where);
            }
        } else if (fixCondition instanceof ReportConditionSubsidiaryLedgerAssist) {
            ReportConditionSubsidiaryLedgerAssist rcba = (ReportConditionSubsidiaryLedgerAssist)fixCondition;
            String assistItemId = rcba.getAssistItemId();
            if (assistItemId != null) {
                if (new AssistantHGInfo().getBOSType().equals((Object)BOSUuid.getBOSObjectType((String)assistItemId, (boolean)true))) {
                    sql.append(" and THG.FID in ('" + assistItemId + "') \r\n");
                } else {
                    sql.append(" and TITEM.FID in ('" + assistItemId + "') \r\n");
                }
            }
            if (((ReportConditionSubsidiaryLedgerAssist)fixCondition).getOptionAmountZero() || ((ReportConditionSubsidiaryLedgerAssist)fixCondition).getOptionBalanceAndAmountZero()) {
                sql.append(where);
            }
        } else if (fixCondition instanceof ReportConditionGeneralLedgerAssist && ((ReportConditionGeneralLedgerAssist)fixCondition).isOptionNOTDisplayIfNoAmount()) {
            where = new StringBuffer();
            if (isForCurrency) {
                where.append("  \t\t\tand (TAB.fDebitFor<>0 or TAB.fDebitLocal<>0 or TAB.fDebitRpt<>0 or TAB.fCreditFor<>0 or TAB.fCreditLocal<>0 or TAB.fCreditRpt<>0 ");
            } else if (isLocalCurrency) {
                where.append("  \t\t\tand (TAB.fDebitLocal<>0 or TAB.fCreditLocal<>0 ");
            } else if (isRptCurrency) {
                where.append("  \t\t\tand (TAB.fDebitRpt<>0 or TAB.fCreditRpt<>0 ");
            }
            where.append(" )\t\r\n");
            sql.append(where);
        }
    }

    protected String getAsstActItemSqlAllForGrade(Context ctx, ReportPartner partner, RptTreeNodeInfo typeNode, String[] nodeData, SqlParams parameter) throws BOSException, EASBizException {
        if (nodeData == null || nodeData.length < 2 || nodeData[0] == null || nodeData[1] == null) {
            throw new ReportException(ReportException.ASSIST_TYPE_ERROR);
        }
        String tempTable = "";
        try {
            Connection cn = partner.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            StringBuffer sqlTmp = new StringBuffer();
            sqlTmp.setLength(0);
            sqlTmp.append(" (                               \r\n");
            sqlTmp.append(" FID varchar(44),               \r\n");
            sqlTmp.append(" FNumber varchar(500),           \r\n");
            sqlTmp.append(" FLongNumber varchar(500),      \r\n");
            sqlTmp.append(" FID1 varchar(44),              \r\n");
            sqlTmp.append(" FParentID varchar(44),         \r\n");
            sqlTmp.append(" FNAME nvarchar(500),            \r\n");
            sqlTmp.append(" FLevel int                      \r\n");
            sqlTmp.append(" )                               \r\n");
            tempTable = partner.createTempTableAsynchronism("GLASSTBAL", sqlTmp.toString());
            partner.setTempTableName(tempTable);
            sqlTmp.setLength(0);
            sqlTmp.append("insert into ").append(tempTable).append("(FID,FNumber,FLongNumber,FID1,Fparentid,FNAME,FLevel) \r\n");
            sqlTmp.append("SELECT distinct TItem.FID, TItem.FNumber, TItem.FLongNumber,TItem.FID FID1,       \r\n");
            sqlTmp.append("TItem.FParentID, TItem.FName").append(partner.getFieldNameExtend()).append(" FNAME, TItem.FLevel \r\n");
            sqlTmp.append("FROM ");
            sqlTmp.append(nodeData[0]);
            sqlTmp.append(" TITEM ");
            sqlTmp.append(this.existsClause(partner, typeNode, nodeData));
            if (nodeData[5] != null) {
                sqlTmp.append(" and TItem.fgroupID = '" + nodeData[5] + "'");
            }
            this.processLinkAsstActItem(partner, "TITEM", sqlTmp);
            stmt = cn.prepareStatement(sqlTmp.toString());
            parameter.putToStatement(stmt);
            stmt.execute();
            stmt.close();
            try {
                sqlTmp.setLength(0);
                sqlTmp.append("create index " + tempTable + "i on " + tempTable + "(FParentID,FLevel)");
                DBUtil.execute((String)sqlTmp.toString(), (Connection)cn);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            sqlTmp.setLength(0);
            sqlTmp.append("select max(FLevel) FMaxLevel from " + tempTable);
            stmt = cn.prepareStatement(sqlTmp.toString());
            rs = stmt.executeQuery();
            int iMaxLevel = 1;
            if (rs.next()) {
                iMaxLevel = rs.getInt(1);
            }
            stmt.close();
            sqlTmp.setLength(0);
            sqlTmp.append(" insert into ").append(tempTable);
            sqlTmp.append("  (FID,FNumber,FLongNumber,FID1,Fparentid,FNAME,FLevel)                            \r\n");
            sqlTmp.append(" SELECT distinct TItem.FID,                                                       \r\n");
            sqlTmp.append("        TItem1.FNumber,                                                           \r\n");
            sqlTmp.append("        TItem1.FLongNumber,                                                       \r\n");
            sqlTmp.append("        TItem1.FID FID1,                                                          \r\n");
            sqlTmp.append("        TItem1.FParentID,                                                         \r\n");
            sqlTmp.append("        TItem1.FNAME").append(partner.getFieldNameExtend()).append(" FNAME,       \r\n");
            sqlTmp.append("        TItem1.Flevel                                                             \r\n");
            sqlTmp.append("  FROM ").append(nodeData[0]).append(" TITEM1                                     \r\n");
            sqlTmp.append("  INNER JOIN ").append(tempTable).append(" TITEM ON TITEM.FParentID = TITEM1.FID  \r\n");
            sqlTmp.append("                                      AND TITEM.FLevel=?                          \r\n");
            stmt = cn.prepareStatement(sqlTmp.toString());
            for (int i = iMaxLevel; i > 1; --i) {
                stmt.setInt(1, i);
                stmt.execute();
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TItem1.FID,TItem1.FNumber,TItem1.FLongNumber,  \r\n");
        sql.append("TItem1.FID1,TItem1.FParentID,TItem1.FName             \r\n");
        sql.append("FROM ");
        sql.append(tempTable);
        sql.append(" TItem1 \r\n");
        sql.append(" order by TItem1.FLongNumber \r\n");
        return sql.toString();
    }

    protected String getAsstActItemSqlAll(ReportPartner partner, RptTreeNodeInfo typeNode, String[] nodeData) throws BOSException, EASBizException {
        if (nodeData == null || nodeData.length < 2 || nodeData[0] == null || nodeData[1] == null) {
            throw new ReportException(ReportException.ASSIST_TYPE_ERROR);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT B.FNumber,B.FlongNumber,Titem.FID,B.FID as FID1,");
        sql.append(" B.FparentID,");
        sql.append(" B.Fname");
        sql.append(partner.getFieldNameExtend());
        sql.append(" FName  \r\n");
        sql.append(" FROM ");
        sql.append(nodeData[3]);
        if (nodeData[6].equals("customer")) {
            sql.append(" B join t_bd_csspgroupstandard e on e.fid=B.fcsspgroupstandardid and (e.ftype=1 or e.ftype=0) ");
        } else if (nodeData[6].equals("provider")) {
            sql.append(" B join t_bd_csspgroupstandard e on e.fid=B.fcsspgroupstandardid and (e.ftype=2 or e.ftype=0) ");
        } else {
            sql.append(" B  ");
        }
        sql.append("inner join ");
        sql.append(nodeData[3]);
        sql.append(" A ON (CHARINDEX(B.FLongNumber||'!',A.FLongNumber)=1 OR B.FID = A.FID) JOIN\n");
        if (nodeData[6].equals("customer")) {
            sql.append("t_bd_csspgroupstandard s on s.fid=A.fcsspgroupstandardid and (s.ftype=1 or s.ftype=0) Join ");
        } else if (nodeData[6].equals("provider")) {
            sql.append("t_bd_csspgroupstandard s on s.fid=A.fcsspgroupstandardid and (s.ftype=2 or s.ftype=0) Join ");
        }
        sql.append(nodeData[0]);
        sql.append(" TItem \r\n").append("on TItem.").append(nodeData[4]).append(" = A.FID \n");
        sql.append(this.relationTable(partner, typeNode, nodeData)).append(" \n");
        this.addWhere(partner, sql);
        this.processLinkAsstActItem(partner, "TItem", sql);
        if ("T_BD_Material".equalsIgnoreCase(nodeData[0])) {
            sql.append("and a.fcontrolunitid in (select a.fid from T_ORG_CtrlUnit a where CHARINDEX(a.FLongNumber||'!','");
            sql.append(partner.getCompany().getCU().getLongNumber());
            sql.append("')=1 or flongnumber = '");
            sql.append(partner.getCompany().getCU().getLongNumber());
            sql.append("') and b.fcontrolunitid in (select a.fid from T_ORG_CtrlUnit a where CHARINDEX(a.FLongNumber||'!','");
            sql.append(partner.getCompany().getCU().getLongNumber());
            sql.append("')=1 or flongnumber = '");
            sql.append(partner.getCompany().getCU().getLongNumber());
            sql.append("')  ");
        }
        if (partner.getFixCondition() instanceof ReportConditionSubsidiaryLedger) {
            sql.append(this.filterTree(partner));
        }
        sql.append(" union SELECT Titem.FNumber,isnull(C.FlongNumber||'!','')||Titem.Fnumber FLongNumber,Titem.FID,Titem.FID FID1,C.FID FparentID,Titem.Fname");
        sql.append(partner.getFieldNameExtend());
        sql.append(" FName  \r\n");
        sql.append("FROM ").append(nodeData[0]).append(" TItem  \r\n");
        sql.append("left Join ").append(nodeData[3]).append(" C on TItem.").append(nodeData[4]).append("= C.FID \n");
        sql.append(this.relationTable(partner, typeNode, nodeData));
        this.addWhere(partner, sql);
        this.processLinkAsstActItem(partner, "TItem", sql);
        if (partner.getFixCondition() instanceof ReportConditionSubsidiaryLedger) {
            sql.append(this.filterTree(partner));
        }
        return "select * from (" + sql.toString() + ") TTT order by TTT.FlongNumber";
    }

    protected String getAsstActItemSql(ReportPartner partner, RptTreeNodeInfo typeNode, String[] nodeData) throws BOSException, EASBizException {
        if (nodeData == null || nodeData.length < 2 || nodeData[0] == null || nodeData[1] == null) {
            throw new ReportException(ReportException.ASSIST_TYPE_ERROR);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT TItem.FID, TItem.FNumber, TItem.FName");
        sql.append(partner.getFieldNameExtend());
        sql.append(" FName \r\n");
        sql.append("FROM ");
        sql.append(nodeData[0]);
        sql.append(" TItem \r\n");
        sql.append(this.existsClause(partner, typeNode, nodeData));
        this.processLinkAsstActItem(partner, "TItem", sql);
        sql.append("ORDER BY TItem.FNumber ");
        return sql.toString();
    }

    private void processLinkAsstActType(ReportPartner partner, String tableName, StringBuffer sql) {
        if (partner.getFixCondition() instanceof ReportConditionAssistBase) {
            ReportConditionAssistBase cond = (ReportConditionAssistBase)partner.getFixCondition();
            String typeId = null;
            if (!StringUtils.isEmpty((String)cond.getAssistTypeId())) {
                typeId = cond.getAssistTypeId();
            }
            if (typeId != null) {
                if (sql.indexOf("where") != -1 || sql.indexOf("WHERE") != -1) {
                    sql.append(" AND ");
                } else {
                    sql.append(" WHERE ");
                }
                sql.append(tableName).append(".FID = '").append(typeId).append("' \r\n");
            }
        }
    }

    private void processLinkAsstActItem(ReportPartner partner, String tableName, StringBuffer sql) {
        if (partner.getFixCondition() instanceof ReportConditionAssistBase) {
            Map item;
            ReportConditionAssistBase cond = (ReportConditionAssistBase)partner.getFixCondition();
            String itemId = null;
            if (!StringUtils.isEmpty((String)cond.getAssistItemId())) {
                itemId = cond.getAssistItemId();
            } else if (cond.getAssistItem() != null && !cond.getAssistItem().isEmpty() && (item = cond.getAssistItem()).get("id") != null && !StringUtils.isEmpty((String)item.get("id").toString())) {
                itemId = item.get("id").toString();
            }
            if (itemId != null) {
                if (sql.toString().toLowerCase().contains("where")) {
                    sql.append(" AND ");
                } else {
                    sql.append(" WHERE ");
                }
                if (itemId.contains(",")) {
                    sql.append(tableName).append(".FID in (").append(itemId).append(") \r\n");
                } else {
                    sql.append(tableName).append(".FID = '").append(itemId).append("' \r\n");
                }
            }
        }
    }

    private StringBuffer relationTable(ReportPartner partner, RptTreeNodeInfo typeNode, String[] nodeData) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        int balType = partner.getFixCondition().getOptionPosting() ? 1 : 5;
        String currencyId = partner.getFixCondition().getCurrencyID();
        String T_AssistBalance = GLBalanceUtils.getAssistBalanceTable(balType, currencyId);
        sql.append("\tINNER JOIN T_BD_AssistantHG THG \r\n");
        sql.append("\tON TItem.FID = THG.");
        sql.append(nodeData[1]);
        sql.append(" \r\n");
        sql.append("\tINNER JOIN " + T_AssistBalance + " TAB \r\n");
        sql.append("\tON TAB.FAssistGrpID = THG.FID \r\n");
        AccountViewInfo account = partner.getAccountViewInfo();
        if (!account.isIsLeaf() && partner.getFixCondition().getAccountIdSet().isEmpty()) {
            sql.append(" inner join t_bd_accountview av on av.fid = TAB.FAccountID ");
        }
        if (partner.getFixCondition() instanceof ReportConditionSubsidiaryLedger) {
            this.addAsstPermissionSql(partner, typeNode, sql, "THG." + nodeData[1]);
        }
        sql.append("Where TAB.FOrgUnitID=? \r\n");
        if (!account.isIsLeaf()) {
            if (partner.getFixCondition().getAccountIdSet().isEmpty()) {
                sql.append(" and av.fnumber >= '").append(account.getNumber()).append("'");
                sql.append(" and av.fnumber < '").append(account.getNumber()).append("zz'");
            } else {
                sql.append("\t\tAND TAB.FAccountID in ").append(GLRptDaoUtil.set2String(partner.getFixCondition().getAccountIdSet()));
            }
        } else {
            sql.append("\t\tAND TAB.FAccountID=? \r\n");
        }
        if (!(partner.getFixCondition().isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
            sql.append("\t\tAND TAB.FCurrencyID=? \r\n");
        }
        Context ctx = partner.getContext();
        PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)(partner.getCompany() == null ? ContextUtil.getCurrentFIUnit((Context)ctx) : partner.getCompany()), (Context)ctx);
        String periods = this.beginPeriodisAfter(partner) ? SQLUtil.buildPeriodNumbersInSql(pe.getCurrentYear(), pe.getCurrentPeriod(), partner.getFixCondition().getPeriodYearEnd(), partner.getFixCondition().getPeriodNumberEnd()) : SQLUtil.buildPeriodNumbersInSql(partner.getFixCondition().getPeriodYearStart(), partner.getFixCondition().getPeriodNumberStart(), partner.getFixCondition().getPeriodYearEnd(), partner.getFixCondition().getPeriodNumberEnd());
        sql.append("  \t\t\tAND TAB.FPeriod in " + periods + " \r\n");
        return sql;
    }

    private StringBuffer existsClause(ReportPartner partner, RptTreeNodeInfo typeNode, String[] nodeData) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        ReportConditionBase cond = partner.getFixCondition();
        int balType = cond.getOptionPosting() ? 1 : 5;
        String currencyId = cond.getCurrencyID();
        String T_AssistBalance = GLBalanceUtils.getAssistBalanceTable(balType, currencyId);
        AccountViewInfo account = partner.getAccountViewInfo();
        sql.append(" WHERE EXISTS ( SELECT 'LV' FROM T_BD_AssistantHG THG \r\n");
        sql.append("\tINNER JOIN " + T_AssistBalance + " TAB \r\n");
        sql.append("\tON TAB.FAssistGrpID = THG.FID \r\n");
        if (!account.isIsLeaf() && cond.getAccountIdSet().isEmpty()) {
            sql.append(" inner join t_bd_accountview av on av.fid = TAB.FAccountID ");
        }
        if (cond instanceof ReportConditionSubsidiaryLedger) {
            this.addAsstPermissionSql(partner, typeNode, sql, "THG." + nodeData[1]);
        }
        sql.append("Where TAB.FOrgUnitID=? \r\n");
        if (!account.isIsLeaf()) {
            if (cond.getAccountIdSet().isEmpty()) {
                sql.append(" and av.fnumber >= '").append(account.getNumber()).append("'");
                sql.append(" and av.fnumber < '").append(account.getNumber()).append("zz'");
            } else {
                sql.append("\t\tAND TAB.FAccountID in ").append(GLRptDaoUtil.set2String(cond.getAccountIdSet()));
            }
        } else {
            sql.append("\t\tAND TAB.FAccountID=? \r\n");
        }
        if (!(partner.getFixCondition().isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
            sql.append("\t\tAND TAB.FCurrencyID=? \r\n");
        }
        Context ctx = partner.getContext();
        PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)(partner.getCompany() == null ? ContextUtil.getCurrentFIUnit((Context)ctx) : partner.getCompany()), (Context)ctx);
        String periods = this.beginPeriodisAfter(partner) ? SQLUtil.buildPeriodNumbersInSql(pe.getCurrentYear(), pe.getCurrentPeriod(), partner.getFixCondition().getPeriodYearEnd(), partner.getFixCondition().getPeriodNumberEnd()) : SQLUtil.buildPeriodNumbersInSql(partner.getFixCondition().getPeriodYearStart(), partner.getFixCondition().getPeriodNumberStart(), partner.getFixCondition().getPeriodYearEnd(), partner.getFixCondition().getPeriodNumberEnd());
        sql.append("  \t\t\tAND TAB.FPeriod in " + periods + " \r\n");
        sql.append("\tAND TItem.FID = THG.");
        sql.append(nodeData[1]).append(" \r\n");
        this.addWhere(partner, sql);
        if (partner.getFixCondition() instanceof ReportConditionSubsidiaryLedger) {
            sql.append(this.filterTree(partner));
        }
        sql.append(")\r\n");
        return sql;
    }

    private int getIsGroup(String[] nodeData) {
        if (nodeData[2] != null && nodeData[2].equals("1")) {
            if (nodeData[3] != null) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    protected void getAsstActItemParameters(SqlParams parameter, ReportPartner partner, int i) throws BOSException, EASBizException {
        ReportConditionBase cond = partner.getFixCondition();
        String currencyId = cond.getCurrencyID();
        int paramCount = 1;
        if (partner.getAccountViewInfo().isIsLeaf()) {
            ++paramCount;
        }
        if (!(cond.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
            ++paramCount;
        }
        int j = 1;
        int para = paramCount * i;
        parameter.setString(para + j++, partner.getCompanyId());
        if (partner.getAccountViewInfo().isIsLeaf()) {
            parameter.setString(para + j++, cond.getAccountId());
        }
        if (!(cond.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
            parameter.setString(para + j++, currencyId);
        }
    }

    private void addAsstPermissionSql(ReportPartner partner, RptTreeNodeInfo typeNode, StringBuffer sql, String columnName) throws BOSException, EASBizException {
        ReportConditionSubsidiaryLedger rcSub = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        List tblData = rcSub.getTableData();
        if (tblData == null) {
            tblData = RptServerUtil.queryAsstAct(null, ContextUtil.getCurrentCtrlUnit((Context)partner.getContext()).getId().toString(), partner.getContext());
        }
        AsstactTypeEntity at = null;
        int size = tblData.size();
        for (int i = 0; i < size && !(at = (AsstactTypeEntity)tblData.get(i)).getId().toString().equals(typeNode.getId()); ++i) {
        }
        if (at != null && at.isEnabledPermissionLimit()) {
            Context ctx = partner.getContext();
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
            IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
            String asstRule = provider.getPermissionRule((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(cuId), at.getPermissionItem());
            if (!StringUtils.isEmpty((String)asstRule)) {
                String permSql = permission.getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(cuId), at.getPermissionItem());
                sql.append(" inner join (").append(permSql).append(") PT on PT.ID=").append(columnName).append(" ");
            }
        }
    }

    private String filterTree(ReportPartner partner) {
        Context ctx = partner.getContext();
        ReportConditionSubsidiaryLedger condition = (ReportConditionSubsidiaryLedger)partner.getFixCondition();
        if (condition.getOptionOnlyAsst()) {
            StringBuffer sqlN = new StringBuffer();
            this.AsstWhereSp.clear();
            sqlN.append(" and ");
            try {
                sqlN.append(RptServerUtil.GetAsstSql(ctx, condition.getTableData(), condition.getOptionAsstGroup(), true, "TAB.FAssistGrpID", this.AsstWhereSp));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            SqlParams parameter = new SqlParams();
            Object[] Asst = this.AsstWhereSp.getParams();
            for (int ii = 0; ii < Asst.length; ++ii) {
                parameter.addString(Asst[ii].toString());
            }
            try {
                return parameter.getSqlWithParams(sqlN.toString());
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return "";
    }

    private boolean beginPeriodisAfter(ReportPartner partner) throws EASBizException, BOSException {
        int peroidNumberBegin;
        ReportConditionBase condition;
        int peroidYeayBegin;
        Context ctx = partner.getContext();
        PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)(partner.getCompany() == null ? ContextUtil.getCurrentFIUnit((Context)ctx) : partner.getCompany()), (Context)ctx);
        int curPeriod = pe.getCurrentYear() * 100 + pe.getCurrentPeriod();
        return curPeriod < (peroidYeayBegin = (condition = partner.getFixCondition()).getPeriodYearStart()) * 100 + (peroidNumberBegin = condition.getPeriodNumberStart());
    }

    static class MyTree {
        private String longNumber = "";
        private String fID = "";
        private String fID1 = "";
        private String parentID = "";
        private String number = "";
        private String name = "";

        MyTree() {
        }

        public String getFID() {
            return this.fID;
        }

        public void setFID(String fid) {
            this.fID = fid;
        }

        public String getFID1() {
            return this.fID1;
        }

        public void setFID1(String fid1) {
            this.fID1 = fid1;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getParentID() {
            return this.parentID;
        }

        public void setParentID(String parentID) {
            this.parentID = parentID;
        }
    }
}

