/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionBalanceListAssist;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadItemInfo;
import com.kingdee.eas.fi.gl.RptTreeNodeInfo;
import com.kingdee.eas.fi.gl.app.AbstractGLReportBalanceListAssitControllerBean;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.app.ReportPartner;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.common.SqlParameter2;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLReportBalanceListAssitControllerBean
extends AbstractGLReportBalanceListAssitControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLReportBalanceListAssitControllerBean");
    private Map<String, String> dataTypes = null;

    private synchronized Map<String, String> getDataTypes(Context ctx) throws BOSException {
        if (this.dataTypes == null) {
            this.dataTypes = GLTempTableUtil.getDataTypes(ctx, "GLReportBalanceListAssitControllerBean", "dataTable");
        }
        return this.dataTypes;
    }

    @Override
    protected Object[] getLineObjects(ReportPartner partner, ResultSet rs) throws SQLException, BOSException, EASBizException {
        String maxChar = GlUtils.getMaxChar();
        String strCurrencyId = rs.getString("FCurrencyID");
        int scaleFor = this.getScale(partner, strCurrencyId);
        ReportConditionBalanceListAssist condition = (ReportConditionBalanceListAssist)partner.getFixCondition();
        boolean showLocalCurrency = this.isShowLocalCurrencyColumns(partner);
        boolean showRptCurrency = this.isShowReportingCurrencyColumns(partner);
        String strAssistItemId = condition.getAssistItemId();
        String asstItemId = rs.getString("FAsstItemId");
        String asstItemName = rs.getString("FAsstItemName");
        String strNumber = asstItemId;
        String strName = asstItemName;
        AsstActTypeInfo asstActType = partner.getAsstActTypeInfo();
        if (strAssistItemId.indexOf("','") >= 0) {
            if (asstItemId.equals(maxChar)) {
                strNumber = "";
                strName = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Total", (Locale)partner.getContext().getLocale());
            }
        } else if (strAssistItemId.length() == 44 || strAssistItemId.length() == 28 || strAssistItemId.length() == 16) {
            IObjectValue iObjectValue = this.getItemDetail(partner);
            if (partner.getAsstActTypeInfo().isUseLongNumber() || iObjectValue instanceof GeneralAsstActTypeInfo) {
                strNumber = partner.isRptShowLongNumberFromGeneral() && iObjectValue.get("longNumber") != null ? ((String)iObjectValue.get("longNumber")).replaceAll("!", ".") : (String)iObjectValue.get("number");
                strName = partner.isRptShowLongNameFromGeneral() && ((TreeBaseInfo)iObjectValue).getDisplayName() != null ? ((TreeBaseInfo)iObjectValue).getDisplayName() : (String)iObjectValue.get("name");
            } else {
                strNumber = (String)iObjectValue.get("number");
                strName = (String)iObjectValue.get("name");
            }
        }
        int index = 0;
        Object[] row = new Object[21 + (showLocalCurrency ? 8 : 0) + (showRptCurrency ? 8 : 0) + 1];
        row[index++] = strNumber;
        row[index++] = strName;
        boolean isCurSum = maxChar.equals(rs.getString("FCurrencyID"));
        if (isCurSum) {
            row[index++] = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"strSubTitle", (Locale)partner.getContext().getLocale());
            row[index++] = "AllCurrency";
        } else {
            row[index++] = rs.getString("FCurrencyName");
            row[index++] = rs.getString("FCurrencyID");
        }
        if (asstActType != null && asstActType.isIsQty() || this.useAccountMeasure(partner.getParmQtyAsst(), condition.isOptionShowQty(), partner.getAccountViewInfo()).booleanValue()) {
            row[index++] = rs.getString("FMeasureUnitName");
            row[index++] = rs.getString("FMeasureUnitID");
        } else {
            row[index++] = null;
            row[index++] = null;
        }
        BigDecimal beginDebitFor = rs.getBigDecimal("FBeginDebitFor");
        BigDecimal beginCreditFor = rs.getBigDecimal("FBeginCreditFor");
        BigDecimal debitFor = rs.getBigDecimal("FDebitFor");
        BigDecimal creditFor = rs.getBigDecimal("FCreditFor");
        BigDecimal beginDebitLocal = rs.getBigDecimal("FBeginDebitLocal");
        BigDecimal beginCreditLocal = rs.getBigDecimal("FBeginCreditLocal");
        BigDecimal debitLocal = rs.getBigDecimal("FDebitLocal");
        BigDecimal creditLocal = rs.getBigDecimal("FCreditLocal");
        BigDecimal beginDebitRpt = rs.getBigDecimal("FBeginDebitRpt");
        BigDecimal beginCreditRpt = rs.getBigDecimal("FBeginCreditRpt");
        BigDecimal debitRpt = rs.getBigDecimal("FDebitRpt");
        BigDecimal creditRpt = rs.getBigDecimal("FCreditRpt");
        row[index++] = rs.getBigDecimal("FBeginQty");
        row[index++] = beginDebitFor;
        if (showLocalCurrency) {
            row[index++] = beginDebitLocal;
        }
        if (showRptCurrency) {
            row[index++] = beginDebitRpt;
        }
        row[index++] = beginCreditFor;
        if (showLocalCurrency) {
            row[index++] = beginCreditLocal;
        }
        if (showRptCurrency) {
            row[index++] = beginCreditRpt;
        }
        row[index++] = rs.getBigDecimal("FDebitQty");
        row[index++] = debitFor;
        if (showLocalCurrency) {
            row[index++] = debitLocal;
        }
        if (showRptCurrency) {
            row[index++] = debitRpt;
        }
        row[index++] = rs.getBigDecimal("FCreditQty");
        row[index++] = creditFor;
        if (showLocalCurrency) {
            row[index++] = creditLocal;
        }
        if (showRptCurrency) {
            row[index++] = creditRpt;
        }
        row[index++] = rs.getBigDecimal("FYearDebitQty");
        row[index++] = rs.getBigDecimal("FYearDebitFor");
        if (showLocalCurrency) {
            row[index++] = rs.getBigDecimal("FYearDebitLocal");
        }
        if (showRptCurrency) {
            row[index++] = rs.getBigDecimal("FYearDebitRpt");
        }
        row[index++] = rs.getBigDecimal("FYearCreditQty");
        row[index++] = rs.getBigDecimal("FYearCreditFor");
        if (showLocalCurrency) {
            row[index++] = rs.getBigDecimal("FYearCreditLocal");
        }
        if (showRptCurrency) {
            row[index++] = rs.getBigDecimal("FYearCreditRpt");
        }
        row[index++] = rs.getBigDecimal("FEndQty");
        row[index++] = rs.getBigDecimal("FEndDebitFor");
        if (showLocalCurrency) {
            row[index++] = rs.getBigDecimal("FEndDebitLocal");
        }
        if (showRptCurrency) {
            row[index++] = rs.getBigDecimal("FEndDebitRpt");
        }
        row[index++] = rs.getBigDecimal("FEndCreditFor");
        if (showLocalCurrency) {
            row[index++] = rs.getBigDecimal("FEndCreditLocal");
        }
        if (showRptCurrency) {
            row[index++] = rs.getBigDecimal("FEndCreditRpt");
        }
        row[index++] = strAssistItemId.indexOf("','") >= 0 && asstItemId.equals(maxChar) ? ReportResultInfo.LINE_TOTAL : (isCurSum ? ReportResultInfo.LINE_YEAR_TOTAL : ReportResultInfo.LINE_NORMAL);
        row[index++] = rs.getString("FAccountID");
        for (int i = 7; !condition.isAllCurrency() && i < row.length - 2; ++i) {
            if (row[i] == null || i == 7 || i == 9 || i == 11 || i == 13 || i == 15) continue;
            row[i] = ((BigDecimal)row[i]).setScale(scaleFor, 4);
        }
        return row;
    }

    @Override
    protected String getSqlForDataSelect(ReportPartner partner) throws BOSException, EASBizException {
        boolean balanceDirSamAsAccount = partner.isParmBalanceDirSamAsAccount();
        ReportConditionBalanceListAssist cond = (ReportConditionBalanceListAssist)partner.getFixCondition();
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append("   FAsstItemId,FAsstItemName, T_Main.FAccountID   FAccountID,TA.FNumber  FAccountNumber,TA.FLevel,\r\n");
        sqlSelect.append("    TA.FName");
        sqlSelect.append(partner.getFieldNameExtend());
        sqlSelect.append(" FAccountName, \r\n");
        sqlSelect.append(" T_Main.FCurrencyID, \r\n");
        sqlSelect.append("     TC.FName");
        sqlSelect.append(partner.getFieldNameExtend());
        sqlSelect.append(" FCurrencyName, TC.FPrecision FPrecision, \r\n");
        if (cond.isOptionShowQty()) {
            sqlSelect.append(" T_Main.FMeasureUnitID FMeasureUnitID, \r\n");
            sqlSelect.append(" TM.FName").append(partner.getFieldNameExtend()).append(" FMeasureUnitName, \r\n");
        } else {
            sqlSelect.append(" NULL FMeasureUnitID, \r\n");
            sqlSelect.append(" NULL FMeasureUnitName, \r\n");
        }
        sqlSelect.append("  TA.FDC ,\r\n ");
        if (balanceDirSamAsAccount) {
            sqlSelect.append("    (CASE WHEN TA.FDC = ");
            sqlSelect.append(1);
            sqlSelect.append(" then T_Main.FBeginBalanceFor else 0.0 end ) FBeginDebitFor, \r\n");
            sqlSelect.append("    (CASE WHEN TA.FDC = ");
            sqlSelect.append(1);
            sqlSelect.append(" then 0.0 else T_Main.FBeginBalanceFor * (-1) end ) FBeginCreditFor, \r\n");
        } else {
            sqlSelect.append("    (CASE WHEN T_Main.FBeginBalanceFor > 0 ");
            sqlSelect.append(" then T_Main.FBeginBalanceFor else 0.0 end ) FBeginDebitFor, \r\n");
            sqlSelect.append("    (CASE WHEN T_Main.FBeginBalanceFor > 0 ");
            sqlSelect.append(" then 0.0 else T_Main.FBeginBalanceFor * (-1) end ) FBeginCreditFor, \r\n");
        }
        sqlSelect.append("    T_Main.FDebitFor FDebitFor, \r\n");
        sqlSelect.append("    T_Main.FCreditFor FCreditFor, \r\n");
        sqlSelect.append("    T_Main.FYearDebitFor FYearDebitFor, \r\n");
        sqlSelect.append("    T_Main.FYearCreditFor FYearCreditFor, \r\n");
        if (balanceDirSamAsAccount) {
            sqlSelect.append("    (CASE WHEN TA.FDC = ");
            sqlSelect.append(1);
            sqlSelect.append(" then T_Main.FBeginBalanceLocal else 0.0 end ) FBeginDebitLocal, \r\n");
            sqlSelect.append("    (CASE WHEN TA.FDC = ");
            sqlSelect.append(1);
            sqlSelect.append(" then 0.0 else T_Main.FBeginBalanceLocal * (-1) end ) FBeginCreditLocal, \r\n");
        } else {
            sqlSelect.append("    (CASE WHEN T_Main.FBeginBalanceLocal > 0 ");
            sqlSelect.append(" then T_Main.FBeginBalanceLocal else 0.0 end ) FBeginDebitLocal, \r\n");
            sqlSelect.append("    (CASE WHEN T_Main.FBeginBalanceLocal > 0 ");
            sqlSelect.append(" then 0.0 else T_Main.FBeginBalanceLocal * (-1) end ) FBeginCreditLocal, \r\n");
        }
        sqlSelect.append("    T_Main.FDebitLocal FDebitLocal, \r\n");
        sqlSelect.append("    T_Main.FCreditLocal FCreditLocal, \r\n");
        sqlSelect.append("    T_Main.FYearDebitLocal FYearDebitLocal, \r\n");
        sqlSelect.append("    T_Main.FYearCreditLocal FYearCreditLocal, \r\n");
        if (balanceDirSamAsAccount) {
            sqlSelect.append("    (CASE WHEN TA.FDC = ");
            sqlSelect.append(1);
            sqlSelect.append(" then T_Main.FBeginBalanceRpt else 0.0 end ) FBeginDebitRpt, \r\n");
            sqlSelect.append("    (CASE WHEN TA.FDC = ");
            sqlSelect.append(1);
            sqlSelect.append(" then 0.0 else T_Main.FBeginBalanceRpt * (-1) end ) FBeginCreditRpt, \r\n");
        } else {
            sqlSelect.append("    (CASE WHEN T_Main.FBeginBalanceRpt > 0 ");
            sqlSelect.append(" then T_Main.FBeginBalanceRpt else 0.0 end ) FBeginDebitRpt, \r\n");
            sqlSelect.append("    (CASE WHEN T_Main.FBeginBalanceRpt > 0 ");
            sqlSelect.append(" then 0.0 else T_Main.FBeginBalanceRpt * (-1) end ) FBeginCreditRpt, \r\n");
        }
        sqlSelect.append("    T_Main.FDebitRpt FDebitRpt, \r\n");
        sqlSelect.append("    T_Main.FCreditRpt FCreditRpt, \r\n");
        sqlSelect.append("    T_Main.FYearDebitRpt FYearDebitRpt, \r\n");
        sqlSelect.append("    T_Main.FYearCreditRpt FYearCreditRpt, \r\n");
        if (!partner.getParmQtyAsst() && cond.isOptionShowQty()) {
            sqlSelect.append(" (case when ta.FIsQty = 0 then 0 else TO_DECIMAL(isnull(T_Main.FBeginQty,0), 28, 10)/ISNULL(TM.FCoefficient,1) end)*TA.FDC FBeginQty, \r\n");
            sqlSelect.append(" case when ta.FIsQty = 0 then 0 else TO_DECIMAL(isnull(T_Main.FYearDebitQty,0), 28, 10)/ISNULL(TM.FCoefficient,1) end FYearDebitQty, ");
            sqlSelect.append(" case when ta.FIsQty = 0 then 0 else TO_DECIMAL(isnull(T_Main.FYearCreditQty,0), 28, 10)/ISNULL(TM.FCoefficient,1) end FYearCreditQty, ");
            sqlSelect.append(" case when ta.FIsQty = 0 then 0 else TO_DECIMAL(isnull(T_Main.FDebitQty,0), 28, 10)/ISNULL(TM.FCoefficient,1) end FDebitQty, ");
            sqlSelect.append(" case when ta.FIsQty = 0 then 0 else TO_DECIMAL(isnull(T_Main.FCreditQty,0), 28, 10)/ISNULL(TM.FCoefficient,1) end FCreditQty, ");
            sqlSelect.append(" (case when ta.FIsQty = 0 then 0 else TO_DECIMAL(isnull(T_Main.FEndQty,0), 28, 10)/ISNULL(TM.FCoefficient,1) end)*TA.FDC FEndQty, \r\n");
        } else {
            sqlSelect.append("    TO_DECIMAL(T_Main.FBeginQty,28,10)*TA.FDC FBeginQty, \r\n");
            sqlSelect.append("    T_Main.FYearDebitQty FYearDebitQty, \r\n");
            sqlSelect.append("    T_Main.FYearCreditQty FYearCreditQty, \r\n");
            sqlSelect.append("    T_Main.FDebitQty FDebitQty, \r\n");
            sqlSelect.append("    T_Main.FCreditQty FCreditQty, \r\n");
            sqlSelect.append("    TO_DECIMAL(T_Main.FEndQty,28,10)*TA.FDC FEndQty, \r\n");
        }
        if (balanceDirSamAsAccount) {
            sqlSelect.append("    (CASE WHEN TA.FDC = ");
            sqlSelect.append(1);
            sqlSelect.append(" then T_Main.FEndBalanceFor else 0.0 end ) FEndDebitFor, \r\n");
            sqlSelect.append("    (CASE WHEN TA.FDC = ");
            sqlSelect.append(1);
            sqlSelect.append(" then 0.0 else T_Main.FEndBalanceFor * (-1) end ) FEndCreditFor, \r\n");
        } else {
            sqlSelect.append("    (CASE WHEN T_Main.FEndBalanceFor > 0 ");
            sqlSelect.append(" then T_Main.FEndBalanceFor else 0.0 end ) FEndDebitFor, \r\n");
            sqlSelect.append("    (CASE WHEN T_Main.FEndBalanceFor > 0 ");
            sqlSelect.append(" then 0.0 else T_Main.FEndBalanceFor * (-1) end ) FEndCreditFor, \r\n");
        }
        if (balanceDirSamAsAccount) {
            sqlSelect.append("    (CASE WHEN TA.FDC = ");
            sqlSelect.append(1);
            sqlSelect.append(" then T_Main.FEndBalanceLocal else 0.0 end ) FEndDebitLocal, \r\n");
            sqlSelect.append("    (CASE WHEN TA.FDC = ");
            sqlSelect.append(1);
            sqlSelect.append(" then 0.0 else T_Main.FEndBalanceLocal * (-1) end ) FEndCreditLocal, \r\n");
        } else {
            sqlSelect.append("    (CASE WHEN T_Main.FEndBalanceLocal > 0 ");
            sqlSelect.append(" then T_Main.FEndBalanceLocal else 0.0 end ) FEndDebitLocal, \r\n");
            sqlSelect.append("    (CASE WHEN T_Main.FEndBalanceLocal > 0 ");
            sqlSelect.append(" then 0.0 else T_Main.FEndBalanceLocal * (-1) end ) FEndCreditLocal, \r\n");
        }
        if (balanceDirSamAsAccount) {
            sqlSelect.append("    (CASE WHEN TA.FDC = ");
            sqlSelect.append(1);
            sqlSelect.append(" then T_Main.FEndBalanceRpt else 0.0 end ) FEndDebitRpt, \r\n");
            sqlSelect.append("    (CASE WHEN TA.FDC = ");
            sqlSelect.append(1);
            sqlSelect.append(" then 0.0 else T_Main.FEndBalanceRpt * (-1) end ) FEndCreditRpt \r\n");
        } else {
            sqlSelect.append("    (CASE WHEN T_Main.FEndBalanceRpt > 0 ");
            sqlSelect.append(" then T_Main.FEndBalanceRpt else 0.0 end ) FEndDebitRpt, \r\n");
            sqlSelect.append("    (CASE WHEN T_Main.FEndBalanceRpt > 0 ");
            sqlSelect.append(" then 0.0 else T_Main.FEndBalanceRpt * (-1) end ) FEndCreditRpt \r\n");
        }
        return sqlSelect.toString();
    }

    @Override
    protected String getSqlForDataFrom(ReportPartner partner) throws BOSException, EASBizException {
        StringBuffer sqlFrom = new StringBuffer();
        ReportConditionBalanceListAssist condition = (ReportConditionBalanceListAssist)partner.getFixCondition();
        String maxChar = GlUtils.getMaxChar();
        String strAssistItemId = condition.getAssistItemId();
        sqlFrom.append(" FROM \t(SELECT '").append(maxChar).append("'  FAsstItemId,'").append(maxChar).append("' FAsstItemName,FAccountID ,FCurrencyID , FMeasureUnitID, \r\n  SUM(FBeginBalanceFor) AS FBeginBalanceFor ,\r\n  SUM(FDebitFor) AS FDebitFor, SUM(FCreditFor) AS FCreditFor ,\r\n  SUM(FYearDebitFor) AS FYearDebitFor ,SUM(FYearCreditFor) AS FYearCreditFor ,\r\n  SUM(FEndBalanceFor) AS FEndBalanceFor , \r\n  SUM(FBeginBalanceLocal) AS FBeginBalanceLocal ,\r\n  SUM(FDebitLocal) AS FDebitLocal,SUM(FCreditLocal) AS FCreditLocal,\r\n  SUM(FYearDebitLocal) AS FYearDebitLocal ,SUM(FYearCreditLocal) AS FYearCreditLocal,\r\n  SUM(FEndBalanceLocal) AS FEndBalanceLocal,\r\n  SUM(FBeginBalanceRpt) AS FBeginBalanceRpt,\r\n  SUM(FDebitRpt) AS FDebitRpt, SUM(FCreditRpt) AS FCreditRpt ,\r\n  SUM(FYearDebitRpt) AS FYearDebitRpt , SUM(FYearCreditRpt) AS FYearCreditRpt ,\r\n  SUM(FEndBalanceRpt) AS FEndBalanceRpt ,\r\n  sum(FBeginQty) FBeginQty, \r\n  sum(FYearDebitQty) FYearDebitQty, \r\n  sum(FYearCreditQty) FYearCreditQty, \r\n  sum(FDebitQty) FDebitQty, \r\n  sum(FCreditQty) FCreditQty, \r\n  sum(FEndQty) FEndQty \r\n\t FROM \r\n");
        sqlFrom.append(partner.getTempTableName());
        sqlFrom.append("\tGROUP BY FAccountID ,FCurrencyID, FMeasureUnitID \r\n");
        if (strAssistItemId.split(",").length > 1) {
            boolean isLeaf = true;
            Map map = condition.getAssistItem();
            for (RptTreeNodeInfo treeNodeInfo : map.keySet()) {
                if (treeNodeInfo.getSonNodeList() == null) continue;
                isLeaf = false;
                break;
            }
            if (isLeaf) {
                sqlFrom.append(" union SELECT FAsstItemNumber FAsstItemId, FAsstItemName,");
                sqlFrom.append(" FAccountID ,FCurrencyID , FMeasureUnitID,\r\n");
                sqlFrom.append("  SUM(FBeginBalanceFor) AS FBeginBalanceFor ,\r\n  SUM(FDebitFor) AS FDebitFor, SUM(FCreditFor) AS FCreditFor ,\r\n  SUM(FYearDebitFor) AS FYearDebitFor ,SUM(FYearCreditFor) AS FYearCreditFor ,\r\n  SUM(FEndBalanceFor) AS FEndBalanceFor , \r\n  SUM(FBeginBalanceLocal) AS FBeginBalanceLocal ,\r\n  SUM(FDebitLocal) AS FDebitLocal,SUM(FCreditLocal) AS FCreditLocal,\r\n  SUM(FYearDebitLocal) AS FYearDebitLocal ,SUM(FYearCreditLocal) AS FYearCreditLocal,\r\n  SUM(FEndBalanceLocal) AS FEndBalanceLocal,\r\n  SUM(FBeginBalanceRpt) AS FBeginBalanceRpt,\r\n  SUM(FDebitRpt) AS FDebitRpt, SUM(FCreditRpt) AS FCreditRpt ,\r\n  SUM(FYearDebitRpt) AS FYearDebitRpt , SUM(FYearCreditRpt) AS FYearCreditRpt ,\r\n  SUM(FEndBalanceRpt) AS FEndBalanceRpt ,\r\n  sum(FBeginQty) FBeginQty, \r\n  sum(FYearDebitQty) FYearDebitQty, \r\n  sum(FYearCreditQty) FYearCreditQty, \r\n  sum(FDebitQty) FDebitQty, \r\n  sum(FCreditQty) FCreditQty, \r\n  sum(FEndQty) FEndQty \r\n\t FROM \r\n");
                sqlFrom.append(partner.getTempTableName());
                sqlFrom.append(" where FAsstItemId in ('");
                sqlFrom.append(strAssistItemId);
                sqlFrom.append("') \r\n");
                sqlFrom.append("\tGROUP BY FAccountID ,FCurrencyID \r\n");
                sqlFrom.append("\t,FAsstItemNumber, FAsstItemName \r\n");
                sqlFrom.append("\t,FMeasureUnitID \r\n");
            } else {
                for (RptTreeNodeInfo treeNodeInfo : map.keySet()) {
                    sqlFrom.append(" union SELECT '" + treeNodeInfo.getNumber() + "' FAsstItemId,'");
                    sqlFrom.append(treeNodeInfo.getName());
                    sqlFrom.append("' FAsstItemName,FAccountID ,FCurrencyID , FMeasureUnitID, \r\n");
                    sqlFrom.append("  SUM(FBeginBalanceFor) AS FBeginBalanceFor ,\r\n  SUM(FDebitFor) AS FDebitFor, SUM(FCreditFor) AS FCreditFor ,\r\n  SUM(FYearDebitFor) AS FYearDebitFor ,SUM(FYearCreditFor) AS FYearCreditFor ,\r\n  SUM(FEndBalanceFor) AS FEndBalanceFor , \r\n  SUM(FBeginBalanceLocal) AS FBeginBalanceLocal ,\r\n  SUM(FDebitLocal) AS FDebitLocal,SUM(FCreditLocal) AS FCreditLocal,\r\n  SUM(FYearDebitLocal) AS FYearDebitLocal ,SUM(FYearCreditLocal) AS FYearCreditLocal,\r\n  SUM(FEndBalanceLocal) AS FEndBalanceLocal,\r\n  SUM(FBeginBalanceRpt) AS FBeginBalanceRpt,\r\n  SUM(FDebitRpt) AS FDebitRpt, SUM(FCreditRpt) AS FCreditRpt ,\r\n  SUM(FYearDebitRpt) AS FYearDebitRpt , SUM(FYearCreditRpt) AS FYearCreditRpt ,\r\n  SUM(FEndBalanceRpt) AS FEndBalanceRpt ,\r\n  sum(FBeginQty) FBeginQty, \r\n  sum(FYearDebitQty) FYearDebitQty, \r\n  sum(FYearCreditQty) FYearCreditQty, \r\n  sum(FDebitQty) FDebitQty, \r\n  sum(FCreditQty) FCreditQty, \r\n  sum(FEndQty) FEndQty \r\n\t FROM \r\n");
                    sqlFrom.append(partner.getTempTableName());
                    sqlFrom.append(" where FAsstItemId in ('");
                    sqlFrom.append(map.get(treeNodeInfo));
                    sqlFrom.append("') \r\n");
                    sqlFrom.append("\tGROUP BY FAccountID ,FCurrencyID, FMeasureUnitID \r\n");
                }
            }
        }
        sqlFrom.append(") AS T_Main \r\n");
        sqlFrom.append("    INNER JOIN T_BD_AccountView TA \r\n");
        sqlFrom.append("    ON T_Main.FAccountID = TA.FID \r\n");
        sqlFrom.append("    left JOIN t_BD_CURRENCY TC \r\n");
        sqlFrom.append("    ON T_Main.FCurrencyID = TC.FID \r\n");
        if (condition.isOptionShowQty()) {
            sqlFrom.append("    LEFT JOIN T_BD_MeasureUnit TM \r\n");
            sqlFrom.append("    ON T_Main.FMeasureUnitID = TM.FID \r\n");
        }
        return sqlFrom.toString();
    }

    @Override
    protected String getSqlForDataWhere(ReportPartner partner) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String getSqlForDataOrder(ReportPartner partner) throws BOSException, EASBizException {
        return "ORDER BY FAsstItemId,TA.FNumber,TC.fnumber ";
    }

    @Override
    protected String getReportName() {
        return "GLBalanceListAssist";
    }

    @Override
    protected String getAuthorityName() {
        return "GLBalanceListAssist";
    }

    protected String getQueryName() {
        return "com.kingdee.eas.fi.gl.app.GLReportBalanceListQuery";
    }

    @Override
    protected ReportTableHeadInfo getDefalutTableHeadInfo(ReportPartner partner) throws BOSException, EASBizException {
        ReportTableHeadInfo head = new ReportTableHeadInfo();
        String[] columnNames = new String[]{"FAsstAcctNumber", "FAsstAcctName", "FCurrencyName", "FBeginDebitFor", "FBeginCreditFor", "FDebitFor", "FCreditFor", "FYearDebitFor", "FYearCreditFor", "FEndDebitFor", "FEndCreditFor"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AsstAcctNumber", "AsstAcctName", "CurrencyName", "BalanceBegin", "BalanceBegin", "NumberTotal", "NumberTotal", "YearTotal", "YearTotal", "BalanceEnd", "BalanceEnd"}, {"AsstAcctNumber", "AsstAcctName", "CurrencyName", "Debit", "Credit", "Debit", "Credit", "Debit", "Credit", "Debit", "Credit"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = null;
        widths = new int[]{80, 216, 0, 85, 85, 85, 85, 85, 85, 85, 85};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2};
        head.setAlignments(alignments);
        int[] numberStyleTypes = new int[]{0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, true, true, true, true, true, true, true, true};
        head.setNeedKilobits(needKilobits);
        head.setNumberStyleTypes(numberStyleTypes);
        return head;
    }

    @Override
    protected void insertDataIntoTempTable(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionBalanceListAssist condition = (ReportConditionBalanceListAssist)partner.getFixCondition();
        String strStructure = this.getTempTableStructure(partner.getContext());
        String strTempTable = partner.createTempTableAsynchronism("GLBLASST", strStructure);
        partner.setTempTableName(strTempTable);
        this.insertData(partner, strTempTable);
        if (condition.isOptionAmountZero()) {
            String suffix = null;
            switch (partner.getCurrencyType()) {
                case 0: {
                    suffix = "for";
                    break;
                }
                case 1: {
                    suffix = "local";
                    break;
                }
                default: {
                    suffix = "rpt";
                }
            }
            String delSql = "delete from " + partner.getTempTableName() + " where not exists(select top 1 * from " + partner.getTempTableName() + " where (FendBalance" + suffix + "<>0 or FCredit" + suffix + "<>0 or FDebit" + suffix + "<>0))";
            DbUtil.execute((Context)partner.getContext(), (String)delSql);
        }
    }

    public String getTempTableStructure(Context ctx) throws BOSException {
        StringBuffer strBuffer = new StringBuffer();
        Map<String, String> dataTypes = this.getDataTypes(ctx);
        strBuffer.append(" (FAsstItemId VARCHAR(44),");
        strBuffer.append(GLTempTableUtil.getDataType("FAsstItemNumber", dataTypes, "VARCHAR(255)") + ",");
        strBuffer.append(GLTempTableUtil.getDataType("FAsstItemName", dataTypes, "VARCHAR(255)") + ",\r\n");
        strBuffer.append(" FAccountId VARCHAR(44),FAssistGrpID VARCHAR(44), FCurrencyID VARCHAR(44), FMeasureUnitID VARCHAR(44), \r\n");
        strBuffer.append("  FBeginBalanceFor DECIMAL(28, 10),FDebitFor DECIMAL(28, 10),\r\n");
        strBuffer.append("  FCreditFor DECIMAL(28, 10),FYearDebitFor DECIMAL(28, 10),\r\n");
        strBuffer.append("  FYearCreditFor DECIMAL(28, 10), FEndBalanceFor DECIMAL(28, 10),\r\n");
        strBuffer.append("  FBeginBalanceLocal DECIMAL(28, 10),FDebitLocal DECIMAL(28, 10),\r\n");
        strBuffer.append("  FCreditLocal DECIMAL(28, 10),FYearDebitLocal DECIMAL(28, 10),\r\n");
        strBuffer.append("  FYearCreditLocal DECIMAL(28, 10),\r\n");
        strBuffer.append("  FEndBalanceLocal DECIMAL(28, 10),\r\n");
        strBuffer.append("  FBeginBalanceRpt DECIMAL(28, 10),FDebitRpt DECIMAL(28, 10),\r\n");
        strBuffer.append("  FCreditRpt DECIMAL(28, 10),FYearDebitRpt DECIMAL(28, 10),\r\n");
        strBuffer.append("  FYearCreditRpt DECIMAL(28, 10),FEndBalanceRpt DECIMAL(28,10), ");
        strBuffer.append("  FBeginQty DECIMAL(28,10), \r\n");
        strBuffer.append("  FYearDebitQty DECIMAL(28,10), \r\n");
        strBuffer.append("  FYearCreditQty DECIMAL(28,10), \r\n");
        strBuffer.append("  FDebitQty DECIMAL(28,10), \r\n");
        strBuffer.append("  FCreditQty DECIMAL(28,10), \r\n");
        strBuffer.append("  FEndQty DECIMAL(28,10) \r\n");
        strBuffer.append(")");
        return strBuffer.toString();
    }

    private String insertTempData(ReportPartner partner, String selectDataForInsertSql) throws BOSException, EASBizException {
        Connection cn = partner.getConnection();
        try {
            return DBUtil.executeSelectIntoForTempTable((Context)partner.getContext(), (String)selectDataForInsertSql, null, (Connection)cn).getTempTable();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String selectDataForInsertSql(ReportPartner partner, String assistItemId, String mainTable) throws EASBizException, BOSException {
        AccountViewInfo account = partner.getAccountViewInfo();
        AsstActTypeInfo asstActType = partner.getAsstActTypeInfo();
        String asstActTypeInfoFieldName = asstActType.getMappingFieldName();
        String currencyId = partner.getFixCondition().getCurrencyID();
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        String asstActTypeInfoTableName = asstActType.getRealtionDataObject();
        String tableName = "hg";
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select hg.fid, hg.").append(asstActTypeInfoFieldName).append(" ,");
        if ("T_BD_GeneralAsstActType".equalsIgnoreCase(asstActTypeInfoTableName)) {
            sqlBuffer.append("replace(acttype.flongnumber,'!','.') fnumber");
        } else {
            sqlBuffer.append("acttype.fnumber");
        }
        sqlBuffer.append(",acttype.fname_").append(partner.getContext().getLocale()).append(" into ").append(tableName).append(" from T_BD_AssistantHG hg ").append(" inner join ").append(asstActTypeInfoTableName).append(" acttype on acttype.fid = hg.").append(asstActTypeInfoFieldName).append(" where ").append(asstActTypeInfoFieldName).append(" in ('").append(assistItemId).append("')");
        ReportConditionBalanceListAssist cond = (ReportConditionBalanceListAssist)partner.getFixCondition();
        String asstAccountId = cond.getAsstAccountId();
        if (account.isIsLeaf() && asstAccountId != null) {
            sqlBuffer.append(" and hg.FAsstAccountID = '" + asstAccountId + "' ");
        }
        tableName = this.insertTempData(partner, sqlBuffer.toString());
        partner.setVariable("tempTableName", tableName);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" SELECT FAsstItemId, FAsstItemNumber, FAsstItemName, t1.FAccountId, T1.FAssistGrpID, T1.FCurrencyID AS FCurrencyID ,\r\n");
        strBuffer.append(" T1.FMeasureUnitID AS FMeasureUnitID, \r\n");
        strBuffer.append("    isnull(T2.FBeginBalanceFor,0) AS FBeginBalanceFor, \r\n");
        strBuffer.append("    isnull(T1.FDebitFor,0) AS FDebitFor,\r\n");
        strBuffer.append("    isnull(T1.FCreditFor,0) AS FCreditFor,\r\n");
        strBuffer.append("    (isnull(T3.FYearDebitFor,0) ) AS FYearDebitFor,\r\n");
        strBuffer.append("    (isnull(T3.FYearCreditFor,0)) AS FYearCreditFor,\r\n");
        strBuffer.append("    isnull(T4.FEndBalanceFor,0) AS FEndBalanceFor,\r\n");
        strBuffer.append("    isnull(T2.FBeginBalanceLocal,0) AS FBeginBalanceLocal,\r\n");
        strBuffer.append("    isnull(T1.FDebitLocal,0) AS FDebitLocal,\r\n");
        strBuffer.append("    isnull(T1.FCreditLocal,0) AS FCreditLocal, \r\n");
        strBuffer.append("    isnull(T3.FYearDebitLocal,0) as FYearDebitLocal, \r\n");
        strBuffer.append("    isnull(T3.FYearCreditLocal,0) AS FYearCreditLocal,\r\n");
        strBuffer.append("    isnull(T4.FEndBalanceLocal,0) AS FEndBalance,\r\n");
        strBuffer.append("    isnull(T2.FBeginBalanceRpt,0) AS FBeginBalanceRpt,\r\n");
        strBuffer.append("    isnull(T1.FDebitRpt,0) AS FDebitRpt, ");
        strBuffer.append("\t  isnull(T1.FCreditRpt,0) AS FCreditRpt,\r\n");
        strBuffer.append("    isnull(T3.FYearDebitRpt,0) AS FYearDebitRpt,\r\n");
        strBuffer.append("    isnull(T3.FYearCreditRpt,0) AS FYearCreditRpt,\r\n");
        strBuffer.append("    isnull(T4.FEndBalanceRpt,0) AS FEndBalanceRpt, \r\n");
        strBuffer.append("\tISNULL(T2.FBeginQty,0) FBeginQty, \t\t\r\n");
        strBuffer.append("\tISNULL(T3.FYearDebitQty,0) FYearDebitQty, \t\t\r\n");
        strBuffer.append("\tISNULL(T3.FYearCreditQty,0) FYearCreditQty, \t\t\r\n");
        strBuffer.append("\tISNULL(T1.FDebitQty,0) FDebitQty, \t\t\r\n");
        strBuffer.append("\tISNULL(T1.FCreditQty,0) FCreditQty, \t\t\r\n");
        strBuffer.append("\tISNULL(T4.FEndQty,0) FEndQty \t\t\r\n");
        strBuffer.append("  FROM \r\n");
        strBuffer.append("    (SELECT TA.FAccountID AS FAccountID,TA.FAssistGrpID AS FAssistGrpID,\r\n");
        if (isForCurrency) {
            strBuffer.append("        TA.FCurrencyID FCurrencyID,\r\n");
        } else {
            strBuffer.append("        '" + currencyId + "' FCurrencyID,\r\n");
        }
        boolean isQtyAsst = partner.getParmQtyAsst();
        boolean existAssistMeasure = this.judgeExistAssistMeasureBalanceTable(isQtyAsst, cond.isOptionShowQty(), account, asstActType);
        boolean useAccountMeasure = this.useAccountMeasure(isQtyAsst, cond.isOptionShowQty(), account);
        if (existAssistMeasure) {
            strBuffer.append(" TA.FMeasureUnitID ");
        } else if (useAccountMeasure) {
            strBuffer.append(" TA1.FMeasureUnitID ");
        } else {
            strBuffer.append(" NULL ");
        }
        strBuffer.append(" FMeasureUnitID, \r\n");
        if (isForCurrency) {
            strBuffer.append("        SUM(isnull(FDebitFor,0)) AS FDebitFor,  \r\n");
            strBuffer.append("        SUM(isnull(FCreditFor,0)) AS FCreditFor,\r\n");
            strBuffer.append("        SUM(isnull(FDebitLocal,0)) AS FDebitLocal,\r\n");
            strBuffer.append("        SUM(isnull(FCreditLocal,0)) AS FCreditLocal,\r\n");
            strBuffer.append("        SUM(isnull(FDebitRpt,0)) AS FDebitRpt, ");
            strBuffer.append("        SUM(isnull(FCreditRpt,0)) AS FCreditRpt, \r\n");
        } else if (isLocalCurrency) {
            strBuffer.append("        SUM(isnull(FDebitLocal,0)) FDebitFor,  \r\n");
            strBuffer.append("        SUM(isnull(FCreditLocal,0)) FCreditFor,\r\n");
            strBuffer.append("        SUM(isnull(FDebitLocal,0)) AS FDebitLocal,\r\n");
            strBuffer.append("        SUM(isnull(FCreditLocal,0)) AS FCreditLocal,\r\n");
            strBuffer.append("        SUM(isnull(FDebitLocal,0)) AS FDebitRpt,\r\n");
            strBuffer.append("        SUM(isnull(FCreditLocal,0)) AS FCreditRpt,\r\n");
        } else if (isRptCurrency) {
            strBuffer.append("        SUM(isnull(FDebitRpt,0)) FDebitFor,  \r\n");
            strBuffer.append("        SUM(isnull(FCreditRpt,0)) FCreditFor,\r\n");
            strBuffer.append("        SUM(isnull(FDebitRpt,0)) AS FDebitLocal, ");
            strBuffer.append("        SUM(isnull(FCreditRpt,0)) AS FCreditLocal, \r\n");
            strBuffer.append("        SUM(isnull(FDebitRpt,0)) AS FDebitRpt, ");
            strBuffer.append("        SUM(isnull(FCreditRpt,0)) AS FCreditRpt, \r\n");
        }
        strBuffer.append("\tSUM(ISNULL(FBeginQty,0)) FBeginQty, \t\t\r\n");
        strBuffer.append("\tSUM(ISNULL(FDebitQty,0)) FDebitQty, \t\t\r\n");
        strBuffer.append("\tSUM(ISNULL(FCreditQty,0)) FCreditQty, \t\t\r\n");
        strBuffer.append("\tSUM(ISNULL(FEndQty,0)) FEndQty \t\t\r\n");
        strBuffer.append("\t,HG1.");
        strBuffer.append(asstActTypeInfoFieldName);
        strBuffer.append(" AS FAsstItemId");
        strBuffer.append(" , hg1.fnumber AS FAsstItemNumber, hg1.fname_").append(partner.getContext().getLocale());
        strBuffer.append(" AS FAsstItemName ");
        strBuffer.append("   FROM ");
        strBuffer.append(mainTable);
        strBuffer.append("           as TA \r\n");
        strBuffer.append("         INNER JOIN T_BD_AccountView TA1 \r\n");
        strBuffer.append("            ON TA.FAccountID = TA1.FID \r\n");
        strBuffer.append("            AND TA.FOrgUnitID = TA1.FCompanyID \r\n");
        strBuffer.append("         INNER JOIN ");
        strBuffer.append(tableName);
        strBuffer.append("         HG1 \r\n");
        strBuffer.append("            ON TA.FAssistGrpID = HG1.FID \r\n");
        strBuffer.append("      WHERE TA.FOrgUnitID = ? \r\n");
        ReportConditionBase condition = partner.getFixCondition();
        strBuffer.append(" AND TA.FPeriod in " + SQLUtil.buildPeriodNumbersInSql(condition.getPeriodYearStart(), condition.getPeriodNumberStart(), condition.getPeriodYearEnd(), condition.getPeriodNumberEnd()));
        if (!account.isIsLeaf()) {
            if (condition.getAccountIdSet().isEmpty()) {
                strBuffer.append(" and TA1.fnumber >= '").append(account.getNumber()).append("'");
                strBuffer.append(" and TA1.fnumber < '").append(account.getNumber()).append("zz'");
            } else {
                strBuffer.append(" and ta.faccountid in ").append(GLRptDaoUtil.set2String(condition.getAccountIdSet()));
            }
        } else {
            strBuffer.append("         AND TA.FAccountID = ? \r\n");
        }
        if (!(condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
            strBuffer.append("         AND TA.FCurrencyID = ? \r\n ");
        }
        strBuffer.append("      GROUP BY TA.FAccountID");
        if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            strBuffer.append("   ,TA.FCurrencyID");
        }
        strBuffer.append("  ,TA.FAssistGrpID");
        strBuffer.append("\t,HG1.");
        strBuffer.append(asstActTypeInfoFieldName);
        strBuffer.append(" , hg1.fnumber , hg1.fname_").append(partner.getContext().getLocale());
        if (existAssistMeasure) {
            strBuffer.append(", TA.FMeasureUnitID");
        } else if (useAccountMeasure) {
            strBuffer.append(", TA1.FMeasureUnitID");
        }
        strBuffer.append(") AS T1 \r\n");
        strBuffer.append("     LEFT OUTER JOIN ");
        strBuffer.append("       (SELECT  TAB2.*");
        if (useAccountMeasure) {
            strBuffer.append(", TA2.FMeasureUnitID FMeasureUnitID");
        }
        if (isLocalCurrency || isRptCurrency) {
            strBuffer.append("\t,'" + currencyId + "' FCurrencyID ");
        }
        if (isLocalCurrency) {
            strBuffer.append(" ,FBeginBalanceLocal FBeginBalanceFor \r\n");
            strBuffer.append(" ,FDebitLocal FDebitFor \r\n");
            strBuffer.append(" ,FCreditLocal FCreditFor \r\n");
            strBuffer.append(" ,FYearDebitLocal FYearDebitFor \r\n");
            strBuffer.append(" ,FYearCreditLocal FYearCreditFor \r\n");
            strBuffer.append(" ,FEndBalanceLocal FEndBalanceFor \r\n");
            strBuffer.append(" ,FBeginBalanceLocal FBeginBalanceRpt \r\n");
            strBuffer.append(" ,FDebitLocal FDebitRpt \r\n");
            strBuffer.append(" ,FCreditLocal FCreditRpt \r\n");
            strBuffer.append(" ,FYearDebitLocal FYearDebitRpt \r\n");
            strBuffer.append(" ,FYearCreditLocal FYearCreditRpt \r\n");
            strBuffer.append(" ,FEndBalanceLocal FEndBalanceRpt \r\n");
        }
        if (isRptCurrency) {
            strBuffer.append(" ,FBeginBalanceRpt FBeginBalanceFor \r\n");
            strBuffer.append(" ,FDebitRpt FDebitFor \r\n");
            strBuffer.append(" ,FCreditRpt FCreditFor \r\n");
            strBuffer.append(" ,FYearDebitRpt FYearDebitFor \r\n");
            strBuffer.append(" ,FYearCreditRpt FYearCreditFor \r\n");
            strBuffer.append(" ,FEndBalanceRpt FEndBalanceFor \r\n");
            strBuffer.append(" ,FBeginBalanceRpt FBeginBalanceLocal \r\n");
            strBuffer.append(" ,FDebitRpt FDebitLocal \r\n");
            strBuffer.append(" ,FCreditRpt FCreditLocal \r\n");
            strBuffer.append(" ,FYearDebitRpt FYearDebitLocal \r\n");
            strBuffer.append(" ,FYearCreditRpt FYearCreditLocal \r\n");
            strBuffer.append(" ,FEndBalanceRpt FEndBalanceLocal \r\n");
        }
        strBuffer.append("\t,HG.");
        strBuffer.append(asstActTypeInfoFieldName);
        strBuffer.append(" FROM ");
        strBuffer.append(mainTable);
        strBuffer.append("           AS TAB2 \r\n");
        strBuffer.append("           INNER JOIN T_BD_AccountView TA2 \r\n");
        strBuffer.append("              ON TAB2.FAccountID = TA2.FID \r\n");
        strBuffer.append("              AND TAB2.FOrgUnitID = TA2.FCompanyID \r\n");
        strBuffer.append("         INNER JOIN ");
        strBuffer.append(tableName);
        strBuffer.append(" HG \r\n");
        strBuffer.append("              ON TAB2.FAssistGrpID = HG.FID \r\n");
        strBuffer.append("        WHERE \r\n");
        strBuffer.append("           TAB2.FOrgUnitID = ? \r\n");
        strBuffer.append("           AND TAB2.FPeriod = ? \r\n");
        if (!account.isIsLeaf()) {
            if (condition.getAccountIdSet().isEmpty()) {
                strBuffer.append(" and TA2.fnumber >= '").append(account.getNumber()).append("'");
                strBuffer.append(" and TA2.fnumber < '").append(account.getNumber()).append("zz'");
            } else {
                strBuffer.append(" and TAB2.faccountid in ").append(GLRptDaoUtil.set2String(condition.getAccountIdSet()));
            }
        } else {
            strBuffer.append("           AND TAB2.FAccountID = ? \r\n");
        }
        if (!(condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
            strBuffer.append("           AND TAB2.FCurrencyID = ? \r\n");
        }
        strBuffer.append("     )AS T2 \r\n");
        strBuffer.append("         ON T1.FAccountID = T2.FAccountID AND T1.FCurrencyID = T2.FCurrencyID \r\n");
        strBuffer.append("         AND T1.FAssistGrpID = t2.FAssistGrpID \r\n");
        if (existAssistMeasure || useAccountMeasure) {
            strBuffer.append("         AND T1.FMeasureUnitID = T2.FMeasureUnitID \r\n");
        }
        strBuffer.append("     LEFT OUTER JOIN ");
        strBuffer.append("       (SELECT  TAB3.*");
        if (useAccountMeasure) {
            strBuffer.append(", TA2.FMeasureUnitID FMeasureUnitID");
        }
        if (isLocalCurrency || isRptCurrency) {
            strBuffer.append("\t,'" + currencyId + "' FCurrencyID ");
        }
        if (isLocalCurrency) {
            strBuffer.append(" ,FBeginBalanceLocal FBeginBalanceFor \r\n");
            strBuffer.append(" ,FDebitLocal FDebitFor \r\n");
            strBuffer.append(" ,FCreditLocal FCreditFor \r\n");
            strBuffer.append(" ,FYearDebitLocal FYearDebitFor \r\n");
            strBuffer.append(" ,FYearCreditLocal FYearCreditFor \r\n");
            strBuffer.append(" ,FEndBalanceLocal FEndBalanceFor \r\n");
            strBuffer.append(" ,FBeginBalanceLocal FBeginBalanceRpt \r\n");
            strBuffer.append(" ,FDebitLocal FDebitRpt \r\n");
            strBuffer.append(" ,FCreditLocal FCreditRpt \r\n");
            strBuffer.append(" ,FYearDebitLocal FYearDebitRpt \r\n");
            strBuffer.append(" ,FYearCreditLocal FYearCreditRpt \r\n");
            strBuffer.append(" ,FEndBalanceLocal FEndBalanceRpt \r\n");
        }
        if (isRptCurrency) {
            strBuffer.append(" ,FBeginBalanceRpt FBeginBalanceFor \r\n");
            strBuffer.append(" ,FDebitRpt FDebitFor \r\n");
            strBuffer.append(" ,FCreditRpt FCreditFor \r\n");
            strBuffer.append(" ,FYearDebitRpt FYearDebitFor \r\n");
            strBuffer.append(" ,FYearCreditRpt FYearCreditFor \r\n");
            strBuffer.append(" ,FEndBalanceRpt FEndBalanceFor \r\n");
            strBuffer.append(" ,FBeginBalanceRpt FBeginBalanceLocal \r\n");
            strBuffer.append(" ,FDebitRpt FDebitLocal \r\n");
            strBuffer.append(" ,FCreditRpt FCreditLocal \r\n");
            strBuffer.append(" ,FYearDebitRpt FYearDebitLocal \r\n");
            strBuffer.append(" ,FYearCreditRpt FYearCreditLocal \r\n");
            strBuffer.append(" ,FEndBalanceRpt FEndBalanceLocal \r\n");
        }
        strBuffer.append("\t,HG.");
        strBuffer.append(asstActTypeInfoFieldName);
        strBuffer.append(" FROM ");
        strBuffer.append(mainTable);
        strBuffer.append("           AS TAB3 \r\n");
        strBuffer.append("           INNER JOIN T_BD_AccountView TA2 \r\n");
        strBuffer.append("              ON TAB3.FAccountID = TA2.FID \r\n");
        strBuffer.append("              AND TAB3.FOrgUnitID = TA2.FCompanyID \r\n");
        strBuffer.append("         INNER JOIN ");
        strBuffer.append(tableName);
        strBuffer.append("         HG \r\n");
        strBuffer.append("              ON TAB3.FAssistGrpID = HG.FID \r\n");
        strBuffer.append("        WHERE \r\n");
        strBuffer.append("           TAB3.FOrgUnitID = ? \r\n");
        strBuffer.append("           AND TAB3.FPeriod = ? \r\n");
        if (!account.isIsLeaf()) {
            if (condition.getAccountIdSet().isEmpty()) {
                strBuffer.append(" and TA2.fnumber >= '").append(account.getNumber()).append("'");
                strBuffer.append(" and TA2.fnumber < '").append(account.getNumber()).append("zz'");
            } else {
                strBuffer.append(" and TAB3.faccountid in ").append(GLRptDaoUtil.set2String(condition.getAccountIdSet()));
            }
        } else {
            strBuffer.append("           AND TAB3.FAccountID = ? \r\n");
        }
        if (!(condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
            strBuffer.append("           AND TAB3.FCurrencyID = ? \r\n");
        }
        strBuffer.append("    ) AS T3 \r\n");
        strBuffer.append("         ON T3.FAccountID = T1.FAccountID AND T3.FCurrencyID = T1.FCurrencyID \r\n");
        strBuffer.append("         AND T3.FAssistGrpID = T1.FAssistGrpID \r\n");
        if (existAssistMeasure || useAccountMeasure) {
            strBuffer.append("         AND T3.FMeasureUnitID = T1.FMeasureUnitID \r\n");
        }
        strBuffer.append("     LEFT OUTER JOIN ");
        strBuffer.append("       (SELECT  T3.*");
        if (useAccountMeasure) {
            strBuffer.append(", TA2.FMeasureUnitID FMeasureUnitID");
        }
        if (isLocalCurrency || isRptCurrency) {
            strBuffer.append("\t,'" + currencyId + "' FCurrencyID ");
        }
        if (isLocalCurrency) {
            strBuffer.append(" ,FBeginBalanceLocal FBeginBalanceFor \r\n");
            strBuffer.append(" ,FDebitLocal FDebitFor \r\n");
            strBuffer.append(" ,FCreditLocal FCreditFor \r\n");
            strBuffer.append(" ,FYearDebitLocal FYearDebitFor \r\n");
            strBuffer.append(" ,FYearCreditLocal FYearCreditFor \r\n");
            strBuffer.append(" ,FEndBalanceLocal FEndBalanceFor \r\n");
            strBuffer.append(" ,FBeginBalanceLocal FBeginBalanceRpt \r\n");
            strBuffer.append(" ,FDebitLocal FDebitRpt \r\n");
            strBuffer.append(" ,FCreditLocal FCreditRpt \r\n");
            strBuffer.append(" ,FYearDebitLocal FYearDebitRpt \r\n");
            strBuffer.append(" ,FYearCreditLocal FYearCreditRpt \r\n");
            strBuffer.append(" ,FEndBalanceLocal FEndBalanceRpt \r\n");
        }
        if (isRptCurrency) {
            strBuffer.append(" ,FBeginBalanceRpt FBeginBalanceFor \r\n");
            strBuffer.append(" ,FDebitRpt FDebitFor \r\n");
            strBuffer.append(" ,FCreditRpt FCreditFor \r\n");
            strBuffer.append(" ,FYearDebitRpt FYearDebitFor \r\n");
            strBuffer.append(" ,FYearCreditRpt FYearCreditFor \r\n");
            strBuffer.append(" ,FEndBalanceRpt FEndBalanceFor \r\n");
            strBuffer.append(" ,FBeginBalanceRpt FBeginBalanceLocal \r\n");
            strBuffer.append(" ,FDebitRpt FDebitLocal \r\n");
            strBuffer.append(" ,FCreditRpt FCreditLocal \r\n");
            strBuffer.append(" ,FYearDebitRpt FYearDebitLocal \r\n");
            strBuffer.append(" ,FYearCreditRpt FYearCreditLocal \r\n");
            strBuffer.append(" ,FEndBalanceRpt FEndBalanceLocal \r\n");
        }
        strBuffer.append("\t,HG.");
        strBuffer.append(asstActTypeInfoFieldName);
        strBuffer.append(" FROM ");
        strBuffer.append(mainTable);
        strBuffer.append("           AS T3 \r\n");
        strBuffer.append("           INNER JOIN T_BD_AccountView TA2 \r\n");
        strBuffer.append("              ON T3.FAccountID = TA2.FID \r\n");
        strBuffer.append("              AND T3.FOrgUnitID = TA2.FCompanyID \r\n");
        strBuffer.append("         INNER JOIN ");
        strBuffer.append(tableName);
        strBuffer.append("         HG \r\n");
        strBuffer.append("              ON T3.FAssistGrpID = HG.FID \r\n");
        strBuffer.append("        WHERE \r\n");
        strBuffer.append("           T3.FOrgUnitID = ? \r\n");
        strBuffer.append("           AND T3.FPeriod = ? \r\n");
        if (!account.isIsLeaf()) {
            if (condition.getAccountIdSet().isEmpty()) {
                strBuffer.append(" and TA2.fnumber >= '").append(account.getNumber()).append("'");
                strBuffer.append(" and TA2.fnumber < '").append(account.getNumber()).append("zz'");
            } else {
                strBuffer.append(" and T3.faccountid in ").append(GLRptDaoUtil.set2String(condition.getAccountIdSet()));
            }
        } else {
            strBuffer.append("           AND T3.FAccountID = ? \r\n");
        }
        if (!(condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
            strBuffer.append("           AND T3.FCurrencyID = ? \r\n");
        }
        strBuffer.append("     )AS T4 \r\n");
        strBuffer.append("         ON T4.FAccountID = T1.FAccountID AND T4.FCurrencyID = T1.FCurrencyID \r\n");
        strBuffer.append("         AND T4.FAssistGrpID = t1.FAssistGrpID \r\n");
        if (existAssistMeasure || useAccountMeasure) {
            strBuffer.append("         AND T4.FMeasureUnitID = t1.FMeasureUnitID \r\n");
        }
        if (!account.isIsLeaf()) {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT t.FAsstItemId, t.FAsstItemNumber, t.FAsstItemName, '" + account.getId() + "' FAccountId, t.FAssistGrpID, t.FCurrencyID, t.FMeasureUnitID, \r\n");
            sql.append(" sum(FBeginBalanceFor), sum(FDebitFor), sum(FCreditFor), sum(FYearDebitFor), sum(FYearCreditFor), sum(FEndBalanceFor),");
            sql.append(" sum(FBeginBalanceLocal), sum(FDebitLocal), sum(FCreditLocal), sum(FYearDebitLocal), sum(FYearCreditLocal), sum(FEndBalance),");
            sql.append(" sum(FBeginBalanceRpt), sum(FDebitRpt), sum(FCreditRpt), sum(FYearDebitRpt), sum(FYearCreditRpt), sum(FEndBalanceRpt),");
            sql.append(" sum(FBeginQty), sum(FYearDebitQty), sum(FYearCreditQty), sum(FDebitQty), sum(FCreditQty), sum(FEndQty)");
            sql.append(" from (").append(strBuffer).append(") t");
            sql.append(" group by t.FAsstItemId, t.FAsstItemNumber, t.FAsstItemName, t.FAssistGrpID, t.FCurrencyID, t.FMeasureUnitID ");
            return sql.toString();
        }
        return strBuffer.toString();
    }

    private void getParameter(ReportPartner partner, SqlParameter2 parameter) throws BOSException, EASBizException {
        ReportConditionBalanceListAssist condition = (ReportConditionBalanceListAssist)partner.getFixCondition();
        Context ctx = partner.getContext();
        PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)(partner.getCompany() == null ? ContextUtil.getCurrentFIUnit((Context)ctx) : partner.getCompany()), (Context)ctx);
        String currencyId = condition.getCurrencyID();
        AccountViewInfo account = partner.getAccountViewInfo();
        if (this.isAfterPeriod(partner)) {
            if (this.beginPeriodisAfter(partner)) {
                parameter.addValueChar(partner.getCompanyId());
                if (account.isIsLeaf()) {
                    parameter.addValueChar(condition.getAccountId());
                }
                if (!(condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
                    parameter.addValueChar(condition.getCurrencyID());
                }
            } else {
                parameter.addValueChar(partner.getCompanyId());
                if (this.beginPeriodisAfter(partner)) {
                    parameter.addValue(new Integer(pe.getCurrentYear() * 100 + pe.getCurrentPeriod()));
                } else {
                    parameter.addValue(new Integer(condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart()));
                }
                if (account.isIsLeaf()) {
                    parameter.addValueChar(condition.getAccountId());
                }
                if (!(condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
                    parameter.addValueChar(condition.getCurrencyID());
                }
            }
            parameter.addValueChar(partner.getCompanyId());
            if (account.isIsLeaf()) {
                parameter.addValueChar(condition.getAccountId());
            }
            if (!(condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
                parameter.addValueChar(condition.getCurrencyID());
            }
            PeriodInfo usedPeriod = GlUtils.getStartPeriod(partner.getContext(), partner.getCompanyId());
            if (condition.getPeriodYearStart() == usedPeriod.getPeriodYear()) {
                parameter.addValueChar(partner.getCompanyId());
                parameter.addValue(new Integer(pe.getCurrentYear() * 100 + pe.getCurrentPeriod()));
                if (account.isIsLeaf()) {
                    parameter.addValueChar(condition.getAccountId());
                }
                if (!(condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
                    parameter.addValueChar(condition.getCurrencyID());
                }
            }
            parameter.addValueChar(partner.getCompanyId());
            if (account.isIsLeaf()) {
                parameter.addValueChar(condition.getAccountId());
            }
            if (!(condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
                parameter.addValueChar(condition.getCurrencyID());
            }
        } else {
            parameter.addValueChar(partner.getCompanyId());
            if (account.isIsLeaf()) {
                parameter.addValueChar(condition.getAccountId());
            }
            if (!(condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
                parameter.addValueChar(condition.getCurrencyID());
            }
            parameter.addValueChar(partner.getCompanyId());
            parameter.addValue(new Integer(condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart()));
            if (account.isIsLeaf()) {
                parameter.addValueChar(condition.getAccountId());
            }
            if (!(condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
                parameter.addValueChar(condition.getCurrencyID());
            }
            parameter.addValueChar(partner.getCompanyId());
            parameter.addValue(new Integer(condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd()));
            if (account.isIsLeaf()) {
                parameter.addValueChar(condition.getAccountId());
            }
            if (!(condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
                parameter.addValueChar(condition.getCurrencyID());
            }
            parameter.addValueChar(partner.getCompanyId());
            parameter.addValue(new Integer(condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd()));
            if (account.isIsLeaf()) {
                parameter.addValueChar(condition.getAccountId());
            }
            if (!(condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
                parameter.addValueChar(condition.getCurrencyID());
            }
        }
    }

    private void insertData(ReportPartner partner, String strTempTable) throws BOSException, EASBizException {
        ReportConditionBalanceListAssist condition = (ReportConditionBalanceListAssist)partner.getFixCondition();
        String assistItemId = condition.getAssistItemId();
        String sql = "";
        SqlParameter2 parameter = new SqlParameter2();
        String mainTable = this.getAsstBalanceListTableName(partner);
        sql = this.isAfterPeriod(partner) ? this.getInsertSqlForAfterPeriod(partner, assistItemId, mainTable) : this.selectDataForInsertSql(partner, assistItemId, mainTable);
        this.getParameter(partner, parameter);
        this.insertData1(partner, sql, parameter, strTempTable);
    }

    private void insertData1(ReportPartner partner, String selectDataForInsertSql, SqlParameter2 parameter, String strTempTable) throws BOSException, EASBizException {
        String strInsertTable = " insert into " + strTempTable + selectDataForInsertSql;
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(strInsertTable));
        try {
            TempTablePool.getInstance((Context)partner.getContext()).releaseTable(partner.getVariable("tempTableName").toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (partner.getFixCondition().isAllCurrency()) {
            StringBuffer strInsertCurr = new StringBuffer();
            strInsertCurr.append(" insert into ").append(strTempTable);
            strInsertCurr.append(" SELECT  FAsstItemId,FAsstItemNumber, FAsstItemName,FAccountID ,FAssistGrpID,'").append(GlUtils.getMaxChar()).append("' FCurrencyID , FMeasureUnitID, \r\n  TO_DECIMAL(0.0,19,4) AS FBeginBalanceFor ,\r\n  TO_DECIMAL(0.0,19,4) AS FDebitFor, TO_DECIMAL(0.0,19,4) AS FCreditFor ,\r\n  TO_DECIMAL(0.0,19,4) AS FYearDebitFor ,TO_DECIMAL(0.0,19,4) AS FYearCreditFor ,\r\n  TO_DECIMAL(0.0,19,4) AS FEndBalanceFor , \r\n  SUM(FBeginBalanceLocal) AS FBeginBalanceLocal ,\r\n  SUM(FDebitLocal) AS FDebitLocal,SUM(FCreditLocal) AS FCreditLocal,\r\n  SUM(FYearDebitLocal) AS FYearDebitLocal ,SUM(FYearCreditLocal) AS FYearCreditLocal,\r\n  SUM(FEndBalanceLocal) AS FEndBalanceLocal,\r\n  SUM(FBeginBalanceRpt) AS FBeginBalanceRpt,\r\n  SUM(FDebitRpt) AS FDebitRpt, SUM(FCreditRpt) AS FCreditRpt ,\r\n  SUM(FYearDebitRpt) AS FYearDebitRpt , SUM(FYearCreditRpt) AS FYearCreditRpt ,\r\n  SUM(FEndBalanceRpt) AS FEndBalanceRpt ,\r\n  sum(FBeginQty) FBeginQty, \r\n  sum(FYearDebitQty) FYearDebitQty, \r\n  sum(FYearCreditQty) FYearCreditQty, \r\n  sum(FDebitQty) FDebitQty, \r\n  sum(FCreditQty) FCreditQty, \r\n  sum(FEndQty) FEndQty \r\n\t FROM \r\n");
            strInsertCurr.append(partner.getTempTableName());
            strInsertCurr.append("\tGROUP BY FAsstItemId,FAsstItemNumber, FAssistGrpID,FAsstItemName,FAccountID, FMeasureUnitID  \r\n");
            try {
                cn = partner.getConnection();
                stmt = cn.prepareStatement(strInsertCurr.toString());
                parameter = new SqlParameter2();
                parameter.putToStatement(stmt);
                stmt.executeUpdate();
            }
            catch (SQLException sqle) {
                try {
                    logger.error((Object)sqle);
                    sqle.setNextException(new SQLException("The query sql is:" + strInsertTable));
                    throw new SQLDataException(sqle);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
    }

    private String getAsstBalanceListTableName(ReportPartner partner) throws EASBizException, BOSException {
        int balType = partner.getFixCondition().getOptionPosting() ? 1 : 5;
        String currencyId = partner.getFixCondition().getCurrencyID();
        ReportConditionBalanceListAssist cond = (ReportConditionBalanceListAssist)partner.getFixCondition();
        AccountViewInfo account = partner.getAccountViewInfo();
        AsstActTypeInfo asstActType = partner.getAsstActTypeInfo();
        if (this.judgeExistAssistMeasureBalanceTable(partner.getParmQtyAsst(), cond.isOptionShowQty(), account, asstActType).booleanValue()) {
            return GLBalanceUtils.getAssistMeasureBalanceTable(balType, currencyId);
        }
        return GLBalanceUtils.getAssistBalanceTable(balType, currencyId);
    }

    private Boolean judgeExistAssistMeasureBalanceTable(Boolean isQtyAsst, Boolean isOptionShowQty, AccountViewInfo account, AsstActTypeInfo asstActType) {
        return isQtyAsst != false && isOptionShowQty != false && account != null && account.isIsQty() && asstActType != null && asstActType.isIsQty();
    }

    private Boolean useAccountMeasure(Boolean isQtyAsst, Boolean isOptionShowQty, AccountViewInfo account) {
        return isQtyAsst == false && isOptionShowQty != false && account != null && account.isIsQty();
    }

    @Override
    protected void doSomethingBeforeQuery(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionBalanceListAssist condition = (ReportConditionBalanceListAssist)partner.getFixCondition();
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)partner.getContext(), (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(partner.getCompanyId()));
        if (startPeriod.getNumber() > condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart()) {
            condition.setPeriodYearStart(startPeriod.getPeriodYear());
            condition.setPeriodNumberStart(startPeriod.getPeriodNumber());
        }
        ReportTableHeadInfo head = partner.getTableHeadInfo();
        if (partner.getFixCondition().isAllCurrency()) {
            this.setTableHeadInfo(partner);
            return;
        }
        String[] columnNames = new String[]{"FAsstAcctNumber", "FAsstAcctName", "FCurrencyName", "FCurrencyID", "FMeasureUnitName", "FMeasureUnitID", "FBeginQty", "FBeginDebitFor", "FBeginCreditFor", "FDebitQty", "FDebitFor", "FCrebitQty", "FCreditFor", "FYearDebitQty", "FYearDebitFor", "FYearCrebitQty", "FYearCreditFor", "FEndQty", "FEndDebitFor", "FEndCreditFor"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AsstAcctNumber", "AsstAcctName", "CurrencyName", "FCurrencyID", "MeasureUnitName", "FMeasureUnitID", "BalanceBegin", "BalanceBegin", "BalanceBegin", "NumberTotal", "NumberTotal", "NumberTotal", "NumberTotal", "YearTotal", "YearTotal", "YearTotal", "YearTotal", "BalanceEnd", "BalanceEnd", "BalanceEnd"}, {"AsstAcctNumber", "AsstAcctName", "CurrencyName", "FCurrencyID", "MeasureUnitName", "FMeasureUnitID", "FBeginQty", "Debit", "Credit", "FDebitQty", "Debit", "FCreditQty", "Credit", "FYearDebitQty", "Debit", "FYearCreditQty", "Credit", "FEndQty", "Debit", "Credit"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = null;
        widths = new int[]{80, 216, 0, 0, 85, 0, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85};
        if (partner.getFixCondition().isAllCurrency()) {
            widths = new int[]{80, 216, 80, 0, 85, 0, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85};
        }
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        head.setAlignments(alignments);
        int[] numberStyleTypes = new int[]{0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
        head.setNeedKilobits(needKilobits);
        int scaleFor = 2;
        if (!partner.getFixCondition().isAllCurrency()) {
            scaleFor = partner.getScaleFor();
        }
        int scaleQty = partner.getParmQtyScale();
        int[] numberScales = new int[]{0, 0, 0, 0, 0, 0, scaleQty, scaleFor, scaleFor, scaleQty, scaleFor, scaleQty, scaleFor, scaleQty, scaleFor, scaleQty, scaleFor, scaleQty, scaleFor, scaleFor};
        head.setNumberScales(numberScales);
        boolean[] vv = null;
        vv = !condition.isOptionShowQty() ? new boolean[]{true, true, true, false, false, false, false, true, true, false, true, false, true, false, true, false, true, false, true, true} : new boolean[]{true, true, true, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
        head.setVisibles(vv);
    }

    private void setTableHeadInfo(ReportPartner partner) throws EASBizException, BOSException {
        ReportTableHeadItemInfo item;
        int i;
        ArrayList<ReportTableHeadItemInfo> itemList = new ArrayList<ReportTableHeadItemInfo>();
        ReportConditionBalanceListAssist condition = (ReportConditionBalanceListAssist)partner.getFixCondition();
        ReportTableHeadItemInfo item2 = new ReportTableHeadItemInfo();
        item2.setColumnName("FAsstAcctNumber");
        item2.setWidth(80);
        item2.setAlignment(0);
        item2.setFreeze(false);
        item2.setMerge(false);
        item2.setVisible(true);
        item2.setTitles(new String[]{"AsstAcctNumber"});
        itemList.add(item2);
        item2 = new ReportTableHeadItemInfo();
        item2.setColumnName("FAsstAcctName");
        item2.setWidth(157);
        item2.setAlignment(0);
        item2.setFreeze(false);
        item2.setMerge(false);
        item2.setVisible(true);
        item2.setTitles(new String[]{"AsstAcctName"});
        itemList.add(item2);
        item2 = new ReportTableHeadItemInfo();
        item2.setColumnName("FCurrencyName");
        item2.setWidth(80);
        item2.setAlignment(0);
        item2.setFreeze(false);
        item2.setMerge(false);
        item2.setVisible(true);
        item2.setTitles(new String[]{"CurrencyName"});
        itemList.add(item2);
        item2 = new ReportTableHeadItemInfo();
        item2.setColumnName("FCurrencyID");
        item2.setWidth(0);
        item2.setAlignment(0);
        item2.setFreeze(false);
        item2.setMerge(true);
        item2.setVisible(false);
        item2.setTitles(new String[]{"FCurrencyID"});
        itemList.add(item2);
        item2 = new ReportTableHeadItemInfo();
        item2.setColumnName("FMeasureUnitName");
        item2.setWidth(80);
        item2.setAlignment(0);
        item2.setFreeze(false);
        item2.setMerge(false);
        item2.setVisible(condition.isOptionShowQty());
        item2.setTitles(new String[]{"MeasureUnitName"});
        itemList.add(item2);
        item2 = new ReportTableHeadItemInfo();
        item2.setColumnName("FMeasureUnitID");
        item2.setWidth(0);
        item2.setAlignment(0);
        item2.setFreeze(false);
        item2.setMerge(true);
        item2.setVisible(condition.isOptionShowQty());
        item2.setTitles(new String[]{"FMeasureUnitID"});
        itemList.add(item2);
        boolean showLocalCurrency = this.isShowLocalCurrencyColumns(partner);
        boolean showRptCurrency = this.isShowReportingCurrencyColumns(partner);
        int scaleFor = 2;
        if (!condition.isAllCurrency()) {
            scaleFor = partner.getScaleFor();
        }
        int scaleLocal = partner.getScaleLocal();
        int scaleRpt = partner.getScaleRpt();
        String[] nameFirst = new String[]{"FYearBegin", "FBegin", "F", "FYear", "FEnd"};
        String[] titleFirst = new String[]{"BalanceYearBegin", "BalanceBegin", "NumberTotal", "YearTotal", "BalanceEnd"};
        class HeadHandler {
            List itemList;
            int scaleFor;
            int scaleLocal;
            int scaleRpt;
            boolean showLocalCurrency;
            boolean showRptCurrency;
            String[] nameFirst;
            String[] titleFirst;

            HeadHandler(String[] nameFirst, String[] titleFirst, List itemList, int scaleFor, int scaleLocal, int scaleRpt, boolean showLocalCurrency, boolean showRptCurrency) {
                this.nameFirst = nameFirst;
                this.titleFirst = titleFirst;
                this.itemList = itemList;
                this.scaleFor = scaleFor;
                this.scaleLocal = scaleLocal;
                this.scaleRpt = scaleRpt;
                this.showLocalCurrency = showLocalCurrency;
                this.showRptCurrency = showRptCurrency;
            }

            void addHeadItemInfo(int index, String[] nameSecond, String[] nameThree, String[] titleSecond, String[] titleThree) {
                for (int i = 0; i < this.nameFirst.length; ++i) {
                    if (i != index) continue;
                    for (int j = 0; j < nameSecond.length; ++j) {
                        for (int k = 0; k < nameThree.length; ++k) {
                            StringBuffer sb = new StringBuffer();
                            if (nameThree[k].endsWith("Qty")) {
                                sb.append(nameThree[k]);
                            } else {
                                sb.append(this.nameFirst[i]);
                                sb.append(nameSecond[j]);
                                sb.append(nameThree[k]);
                            }
                            ReportTableHeadItemInfo item = new ReportTableHeadItemInfo();
                            item.setColumnName(sb.toString());
                            item.setWidth(90);
                            item.setAlignment(2);
                            item.setFreeze(false);
                            item.setMerge(false);
                            item.setVisible(true);
                            String[] title = new String[this.showLocalCurrency || this.showRptCurrency ? 3 : 2];
                            title[0] = this.titleFirst[i];
                            title[1] = titleSecond[j];
                            if (this.showLocalCurrency || this.showRptCurrency) {
                                title[2] = titleThree[k];
                            }
                            item.setTitles(title);
                            item.setNumberStyleType(1);
                            item.setNumberScale(k == 0 ? this.scaleFor : (k == 1 ? this.scaleLocal : this.scaleRpt));
                            item.setNeedKilobit(true);
                            this.itemList.add(item);
                        }
                    }
                }
            }
        }
        HeadHandler hh = new HeadHandler(nameFirst, titleFirst, itemList, scaleFor, scaleLocal, scaleRpt, showLocalCurrency, showRptCurrency);
        String[] nameSecond = new String[]{"FBeginQty"};
        String[] nameThree = new String[]{"FBeginQty"};
        String[] titleSecond = new String[]{"FBeginQty"};
        String[] titleThree = new String[]{"FBeginQty"};
        hh.addHeadItemInfo(1, nameSecond, nameThree, titleSecond, titleThree);
        nameSecond = new String[]{"Debit", "Credit"};
        nameThree = new String[]{"For", "Local", "Rpt"};
        titleSecond = new String[]{"Debit", "Credit"};
        titleThree = new String[]{"LabelFor", "LabelLocal", "LabelRpt"};
        hh.addHeadItemInfo(1, nameSecond, nameThree, titleSecond, titleThree);
        if (showLocalCurrency || showRptCurrency) {
            nameSecond = new String[]{"Debit"};
            nameThree = new String[]{"FDebitQty", "For", "Local", "Rpt"};
            titleSecond = new String[]{"Debit"};
            titleThree = new String[]{"FDebitQty", "LabelFor", "LabelLocal", "LabelRpt"};
            hh.addHeadItemInfo(2, nameSecond, nameThree, titleSecond, titleThree);
            nameSecond = new String[]{"Credit"};
            nameThree = new String[]{"FCreditQty", "For", "Local", "Rpt"};
            titleSecond = new String[]{"Credit"};
            titleThree = new String[]{"FCreditQty", "LabelFor", "LabelLocal", "LabelRpt"};
            hh.addHeadItemInfo(2, nameSecond, nameThree, titleSecond, titleThree);
            nameSecond = new String[]{"Debit"};
            nameThree = new String[]{"FYearDebitQty", "For", "Local", "Rpt"};
            titleSecond = new String[]{"Debit"};
            titleThree = new String[]{"FYearDebitQty", "LabelFor", "LabelLocal", "LabelRpt"};
            hh.addHeadItemInfo(3, nameSecond, nameThree, titleSecond, titleThree);
            nameSecond = new String[]{"Credit"};
            nameThree = new String[]{"FYearCreditQty", "For", "Local", "Rpt"};
            titleSecond = new String[]{"Credit"};
            titleThree = new String[]{"FYearCreditQty", "LabelFor", "LabelLocal", "LabelRpt"};
            hh.addHeadItemInfo(3, nameSecond, nameThree, titleSecond, titleThree);
        } else {
            nameSecond = new String[]{"FDebitQty"};
            nameThree = new String[]{"FDebitQty"};
            titleSecond = new String[]{"FDebitQty"};
            titleThree = new String[]{"FDebitQty"};
            hh.addHeadItemInfo(2, nameSecond, nameThree, titleSecond, titleThree);
            nameSecond = new String[]{"Debit"};
            nameThree = new String[]{"For", "Local", "Rpt"};
            titleSecond = new String[]{"Debit"};
            titleThree = new String[]{"LabelFor", "LabelLocal", "LabelRpt"};
            hh.addHeadItemInfo(2, nameSecond, nameThree, titleSecond, titleThree);
            nameSecond = new String[]{"FCreditQty"};
            nameThree = new String[]{"FCreditQty"};
            titleSecond = new String[]{"FCreditQty"};
            titleThree = new String[]{"FCreditQty"};
            hh.addHeadItemInfo(2, nameSecond, nameThree, titleSecond, titleThree);
            nameSecond = new String[]{"Credit"};
            nameThree = new String[]{"For", "Local", "Rpt"};
            titleSecond = new String[]{"Credit"};
            titleThree = new String[]{"LabelFor", "LabelLocal", "LabelRpt"};
            hh.addHeadItemInfo(2, nameSecond, nameThree, titleSecond, titleThree);
            nameSecond = new String[]{"FYearDebitQty"};
            nameThree = new String[]{"FYearDebitQty"};
            titleSecond = new String[]{"FYearDebitQty"};
            titleThree = new String[]{"FYearDebitQty"};
            hh.addHeadItemInfo(3, nameSecond, nameThree, titleSecond, titleThree);
            nameSecond = new String[]{"Debit"};
            nameThree = new String[]{"For", "Local", "Rpt"};
            titleSecond = new String[]{"Debit"};
            titleThree = new String[]{"LabelFor", "LabelLocal", "LabelRpt"};
            hh.addHeadItemInfo(3, nameSecond, nameThree, titleSecond, titleThree);
            nameSecond = new String[]{"FYearCreditQty"};
            nameThree = new String[]{"FYearCreditQty"};
            titleSecond = new String[]{"FYearCreditQty"};
            titleThree = new String[]{"FYearCreditQty"};
            hh.addHeadItemInfo(3, nameSecond, nameThree, titleSecond, titleThree);
            nameSecond = new String[]{"Credit"};
            nameThree = new String[]{"For", "Local", "Rpt"};
            titleSecond = new String[]{"Credit"};
            titleThree = new String[]{"LabelFor", "LabelLocal", "LabelRpt"};
            hh.addHeadItemInfo(3, nameSecond, nameThree, titleSecond, titleThree);
        }
        nameSecond = new String[]{"FEndQty"};
        nameThree = new String[]{"FEndQty"};
        titleSecond = new String[]{"FEndQty"};
        titleThree = new String[]{"FEndQty"};
        hh.addHeadItemInfo(4, nameSecond, nameThree, titleSecond, titleThree);
        nameSecond = new String[]{"Debit", "Credit"};
        nameThree = new String[]{"For", "Local", "Rpt"};
        titleSecond = new String[]{"Debit", "Credit"};
        titleThree = new String[]{"LabelFor", "LabelLocal", "LabelRpt"};
        hh.addHeadItemInfo(4, nameSecond, nameThree, titleSecond, titleThree);
        for (i = 0; i < itemList.size(); ++i) {
            item = (ReportTableHeadItemInfo)itemList.get(i);
            if (!item.getColumnName().endsWith("Qty")) continue;
            item.setVisible(condition.isOptionShowQty());
        }
        if (!showLocalCurrency) {
            for (i = 0; i < itemList.size(); ++i) {
                item = (ReportTableHeadItemInfo)itemList.get(i);
                if (!item.getColumnName().endsWith("Local")) continue;
                itemList.remove(i);
                --i;
            }
        }
        if (!showRptCurrency) {
            for (i = 0; i < itemList.size(); ++i) {
                item = (ReportTableHeadItemInfo)itemList.get(i);
                if (!item.getColumnName().endsWith("Rpt")) continue;
                itemList.remove(i);
                --i;
            }
        }
        int scaleQty = partner.getParmQtyScale();
        for (int i2 = 0; i2 < itemList.size(); ++i2) {
            item = (ReportTableHeadItemInfo)itemList.get(i2);
            String colName = item.getColumnName();
            if (colName.endsWith("For")) {
                item.setNumberScale(scaleFor);
                continue;
            }
            if (colName.endsWith("Local")) {
                item.setNumberScale(scaleLocal);
                continue;
            }
            if (colName.endsWith("Rpt")) {
                item.setNumberScale(scaleRpt);
                continue;
            }
            if (!colName.endsWith("Qty")) continue;
            item.setNumberScale(scaleQty);
        }
        ReportTableHeadItemInfo[] items = new ReportTableHeadItemInfo[itemList.size()];
        for (int i3 = 0; i3 < itemList.size(); ++i3) {
            items[i3] = (ReportTableHeadItemInfo)itemList.get(i3);
        }
        ReportTableHeadInfo head = new ReportTableHeadInfo(items);
        head.setHeadMerge(true);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
        partner.setTableHeadInfo(head);
    }

    private IObjectValue getItemDetail(ReportPartner partner) throws BOSException {
        Context ctx = partner.getContext();
        ReportConditionBalanceListAssist condition = (ReportConditionBalanceListAssist)partner.getFixCondition();
        String strAsstItemid = condition.getAssistItemId();
        BOSUuid id = BOSUuid.read((String)strAsstItemid);
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectValue iObjectValue = iDynamicObject.getValue(id.getType(), (IObjectPK)new ObjectUuidPK(id));
        return iObjectValue;
    }

    private int getScale(ReportPartner partner, String strCurrencyId) throws EASBizException, BOSException {
        int iScale = 0;
        String strFind = strCurrencyId;
        if (strFind.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
            CurrencyInfo baseCurrencyInfo = partner.getCompany().getBaseCurrency();
            return baseCurrencyInfo == null ? 0 : baseCurrencyInfo.getPrecision();
        }
        if (strFind.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
            CurrencyInfo reportCurrencyInfo = partner.getCompany().getReportCurrency();
            return reportCurrencyInfo == null ? 0 : reportCurrencyInfo.getPrecision();
        }
        CurrencyCollection currencys = partner.getAllCurrency();
        boolean bFind = false;
        if (currencys != null && currencys.size() != 0) {
            for (int i = 0; i < currencys.size() && !bFind; ++i) {
                CurrencyInfo tmpCurrencyInfo = currencys.get(i);
                if (!strFind.equals(tmpCurrencyInfo.getId().toString())) continue;
                iScale = tmpCurrencyInfo.getPrecision();
                bFind = true;
            }
        }
        return iScale;
    }

    protected boolean isShowLocalCurrencyColumns(ReportPartner partner) throws BOSException, EASBizException {
        return !partner.isParmForeignCurrencySu() && partner.getCurrencyType() == 0 && !partner.isBaseCurrency() && !GlUtils.isCompanyUnion(partner.getCompany()) && partner.getFixCondition().isAllCurrency();
    }

    protected boolean isShowReportingCurrencyColumns(ReportPartner partner) throws BOSException, EASBizException {
        return !partner.isParmForeignCurrencySu() && partner.isParmUseReportCurrency() && partner.getCurrencyType() == 0 && !partner.isReportingCurrency() && !GlUtils.isCompanyUnion(partner.getCompany()) && partner.getFixCondition().isAllCurrency();
    }

    private String getInsertSqlForAfterPeriod(ReportPartner partner, String assistItemId, String mainTable) throws EASBizException, BOSException {
        Context ctx = partner.getContext();
        PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)(partner.getCompany() == null ? ContextUtil.getCurrentFIUnit((Context)ctx) : partner.getCompany()), (Context)ctx);
        int curPeriod = pe.getCurrentYear() * 100 + pe.getCurrentPeriod();
        ReportConditionBase condition = partner.getFixCondition();
        String currencyId = condition.getCurrencyID();
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        int peroidYeayBegin = condition.getPeriodYearStart();
        int peroidNumberBegin = condition.getPeriodNumberStart();
        int[] periodRange = null;
        AccountViewInfo account = partner.getAccountViewInfo();
        AsstActTypeInfo asstActType = partner.getAsstActTypeInfo();
        String asstActTypeInfoFieldName = asstActType.getMappingFieldName();
        String asstActTypeInfoTableName = asstActType.getRealtionDataObject();
        String tableName = "hg";
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select hg.fid, hg.").append(asstActTypeInfoFieldName).append(" ,");
        if ("T_BD_GeneralAsstActType".equalsIgnoreCase(asstActTypeInfoTableName)) {
            sqlBuffer.append("replace(acttype.flongnumber,'!','.') fnumber");
        } else {
            sqlBuffer.append("acttype.fnumber");
        }
        sqlBuffer.append(",acttype.fname_").append(partner.getContext().getLocale()).append(" into ").append(tableName).append(" from T_BD_AssistantHG hg ").append(" inner join ").append(asstActTypeInfoTableName).append(" acttype on acttype.fid = hg.").append(asstActTypeInfoFieldName).append(" where ").append(asstActTypeInfoFieldName).append(" in ('").append(assistItemId).append("')");
        ReportConditionBalanceListAssist cond = (ReportConditionBalanceListAssist)partner.getFixCondition();
        String asstAccountId = cond.getAsstAccountId();
        if (account.isIsLeaf() && asstAccountId != null) {
            sqlBuffer.append(" and hg.FAsstAccountID = '" + asstAccountId + "' ");
        }
        tableName = this.insertTempData(partner, sqlBuffer.toString());
        partner.setVariable("tempTableName", tableName);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" select TP.* from (");
        strBuffer.append(" select HG.");
        strBuffer.append(asstActTypeInfoFieldName);
        strBuffer.append(" AS FAsstItemId");
        strBuffer.append(" , hg.fnumber AS FAsstItemNumber, hg.fname_").append(partner.getContext().getLocale());
        strBuffer.append(" AS FAsstItemName,");
        strBuffer.append(" '").append(condition.getAccountId()).append("' FAccountId,");
        strBuffer.append("  hg.fid FAssistGrpID,\r\n");
        if (!condition.isAllCurrency()) {
            strBuffer.append("'" + condition.getCurrencyID() + "'").append(" FCurrencyID,");
        } else {
            strBuffer.append("T2.FCurrencyID FCurrencyID,");
        }
        boolean isQtyAsst = partner.getParmQtyAsst();
        boolean existAssistMeasure = this.judgeExistAssistMeasureBalanceTable(isQtyAsst, cond.isOptionShowQty(), account, asstActType);
        boolean useAccountMeasure = this.useAccountMeasure(isQtyAsst, cond.isOptionShowQty(), account);
        if (existAssistMeasure || useAccountMeasure) {
            strBuffer.append(" T2.FMeasureUnitID FMeasureUnitID,");
        } else {
            strBuffer.append(" NULL FMeasureUnitID,");
        }
        strBuffer.append("    isnull(T2.FBeginBalanceFor,0) AS FBeginBalanceFor, \r\n");
        strBuffer.append("    isnull(T1.FDebitFor,0) AS FDebitFor,\r\n");
        strBuffer.append("    isnull(T1.FCreditFor,0) AS FCreditFor,\r\n");
        PeriodInfo usedPeriod = GlUtils.getStartPeriod(partner.getContext(), partner.getCompanyId());
        if (condition.getPeriodYearStart() == usedPeriod.getPeriodYear()) {
            strBuffer.append("    isnull(T3.FYearDebitFor,0) AS FYearDebitFor,\r\n");
            strBuffer.append("    isnull(T3.FYearCreditFor,0) AS FYearCreditFor ,\r\n");
        } else {
            strBuffer.append("    isnull(T3.FDebitFor,0) AS FYearDebitFor,\r\n");
            strBuffer.append("    isnull(T3.FCreditFor,0) AS FYearCreditFor ,\r\n");
        }
        strBuffer.append("    (isnull(T2.FBeginBalanceFor,0)+ isnull(T1.FDebitFor,0)-isnull(T1.FCreditFor,0)) AS FEndBalanceFor, \r\n");
        strBuffer.append("    isnull(T2.FBeginBalanceLocal,0) AS FBeginBalanceLocal,\r\n");
        strBuffer.append("    isnull(T1.FDebitLocal,0) AS FDebitLocal,\r\n");
        strBuffer.append("    isnull(T1.FCreditLocal,0) AS FCreditLocal, \r\n");
        if (condition.getPeriodYearStart() == usedPeriod.getPeriodYear()) {
            strBuffer.append("    isnull(T3.FYearDebitLocal,0) AS FYearDebitLocal,\r\n");
            strBuffer.append("    isnull(T3.FYearCreditLocal,0) AS FYearCreditLocal ,\r\n");
        } else {
            strBuffer.append("    isnull(T3.FDebitLocal,0) AS FYearDebitLocal,\r\n");
            strBuffer.append("    isnull(T3.FCreditLocal,0) AS FYearCreditLocal ,\r\n");
        }
        strBuffer.append("    (isnull(T2.FBeginBalanceLocal,0)+ isnull(T1.FDebitLocal,0)-isnull(T1.FCreditLocal,0)) AS FEndBalance, \r\n");
        strBuffer.append("    isnull(T2.FBeginBalanceRpt,0) AS FBeginBalanceRpt,\r\n");
        strBuffer.append("    isnull(T1.FDebitRpt,0) AS FDebitRpt, ");
        strBuffer.append("\t  isnull(T1.FCreditRpt,0) AS FCreditRpt,\r\n");
        if (condition.getPeriodYearStart() == usedPeriod.getPeriodYear()) {
            strBuffer.append("    isnull(T3.FYearDebitRpt,0) AS FYearDebitRpt,\r\n");
            strBuffer.append("    isnull(T3.FYearCreditRpt,0) AS FYearCreditRpt ,\r\n");
        } else {
            strBuffer.append("    isnull(T3.FDebitRpt,0) AS FYearDebitRpt,\r\n");
            strBuffer.append("    isnull(T3.FCreditRpt,0) AS FYearCreditRpt ,\r\n");
        }
        strBuffer.append("    (isnull(T2.FBeginBalanceRpt,0)+ isnull(T1.FDebitRpt,0)-isnull(T1.FCreditRpt,0)) AS FEndBalanceRpt, \r\n");
        strBuffer.append("\tISNULL(T2.FBeginQty,0) AS FBeginQty, \t\t\r\n");
        if (condition.getPeriodYearStart() == usedPeriod.getPeriodYear()) {
            strBuffer.append("    isnull(T3.FYearDebitQty,0) AS FYearDebitQty,\r\n");
            strBuffer.append("    isnull(T3.FYearCreditQty,0) AS FYearCreditQty ,\r\n");
        } else {
            strBuffer.append("    isnull(T3.FDebitQty,0) AS FYearDebitQty,\r\n");
            strBuffer.append("    isnull(T3.FCreditQty,0) AS FYearCreditQty ,\r\n");
        }
        strBuffer.append("\tISNULL(T1.FDebitQty,0) FDebitQty, \t\t\r\n");
        strBuffer.append("\tISNULL(T1.FCreditQty,0) FCreditQty, \t\t\r\n");
        strBuffer.append("\t(ISNULL(T2.FBeginQty,0)+ ISNULL(T1.FDebitQty,0)  - ISNULL(T1.FCreditQty,0)) FEndQty \t\t\r\n");
        strBuffer.append("  FROM ").append(tableName).append(" HG left outer join \r\n");
        if (curPeriod >= peroidYeayBegin * 100 + peroidNumberBegin) {
            strBuffer.append("       (SELECT ");
            strBuffer.append("'").append(account.getId().toString()).append("' FAccountID, TAB2.FAssistGrpID");
            if (existAssistMeasure || useAccountMeasure) {
                strBuffer.append(", TA2.FMeasureUnitID FMeasureUnitID");
            }
            if (isLocalCurrency || isRptCurrency) {
                strBuffer.append(", '").append(currencyId).append("' FCurrencyID");
            } else {
                strBuffer.append(", TAB2.FCurrencyID");
            }
            String suffix = "For";
            if (isLocalCurrency) {
                suffix = "Local";
            } else if (isRptCurrency) {
                suffix = "Rpt";
            }
            if (account.isIsLeaf()) {
                strBuffer.append(" ,TAB2.FBeginBalance").append(suffix).append(" FBeginBalanceFor \r\n");
                strBuffer.append(" ,TAB2.FBeginBalance").append(suffix).append(" FBeginBalanceLocal \r\n");
                strBuffer.append(" ,TAB2.FBeginBalance").append(suffix).append(" FBeginBalanceRpt \r\n");
                strBuffer.append(", TAB2.FBeginQty");
            } else {
                strBuffer.append(" ,SUM(ISNULL(TAB2.FBeginBalance").append(suffix).append(", 0)) FBeginBalanceFor \r\n");
                strBuffer.append(" ,SUM(ISNULL(TAB2.FBeginBalance").append(suffix).append(", 0)) FBeginBalanceLocal \r\n");
                strBuffer.append(" ,SUM(ISNULL(TAB2.FBeginBalance").append(suffix).append(", 0)) FBeginBalanceRpt \r\n");
                strBuffer.append(", SUM(ISNULL(TAB2.FBeginQty, 0)) as FBeginQty");
            }
            strBuffer.append("\t,HG.");
            strBuffer.append(asstActTypeInfoFieldName);
            strBuffer.append(" AS FAsstItemId");
            strBuffer.append(" , hg.fnumber AS FAsstItemNumber, hg.fname_").append(partner.getContext().getLocale());
            strBuffer.append(" AS FAsstItemName ");
            strBuffer.append(" FROM ");
            strBuffer.append(mainTable);
            strBuffer.append("           AS TAB2 \r\n");
            strBuffer.append("           INNER JOIN T_BD_AccountView TA2 \r\n");
            strBuffer.append("              ON TAB2.FAccountID = TA2.FID \r\n");
            strBuffer.append("              AND TAB2.FOrgUnitID = TA2.FCompanyID \r\n");
            strBuffer.append("         INNER JOIN ");
            strBuffer.append(tableName);
            strBuffer.append(" HG \r\n");
            strBuffer.append("              ON TAB2.FAssistGrpID = HG.FID \r\n");
            strBuffer.append("        WHERE \r\n");
            strBuffer.append("           TAB2.FOrgUnitID = ? \r\n");
            strBuffer.append("           AND TAB2.FPeriod = ? \r\n");
            if (!account.isIsLeaf()) {
                if (condition.getAccountIdSet().isEmpty()) {
                    strBuffer.append(" and TA2.fnumber >= '").append(account.getNumber()).append("'");
                    strBuffer.append(" and TA2.fnumber < '").append(account.getNumber()).append("zz'");
                } else {
                    strBuffer.append(" and TAB2.faccountid in ").append(GLRptDaoUtil.set2String(condition.getAccountIdSet()));
                }
            } else {
                strBuffer.append("           AND TAB2.FAccountID = ? \r\n");
            }
            if (!(condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
                strBuffer.append("           AND TAB2.FCurrencyID = ? \r\n");
            }
            if (!account.isIsLeaf()) {
                strBuffer.append(" GROUP BY TAB2.FAssistGrpID ");
                if (isForCurrency || cond.isAllCurrency()) {
                    strBuffer.append(", TAB2.FCurrencyID");
                }
                if (existAssistMeasure || useAccountMeasure) {
                    strBuffer.append(", TA2.FMeasureUnitID ");
                }
                strBuffer.append(", HG.").append(asstActTypeInfoFieldName);
                strBuffer.append(", hg.fnumber, hg.fname_").append(partner.getContext().getLocale());
            }
            strBuffer.append("     )AS T2 \r\n");
        } else {
            strBuffer.append("( select tp.* from (select  temp1.FAsstItemId, temp1.FAsstItemNumber, temp1.FAsstItemName,temp1.FAccountID,temp1.FCurrencyID,temp1.FAssistGrpID FAssistGrpID,");
            if (existAssistMeasure || useAccountMeasure) {
                strBuffer.append(" temp1.FMeasureUnitID FMeasureUnitID, \r\n");
            } else {
                strBuffer.append(" NULL FMeasureUnitID, \r\n");
            }
            strBuffer.append(" (isnull(temp1.FBeginBalanceLocal,0)+isnull(temp1.FDebitLocal,0)-isnull(temp1.FCreditLocal,0)) AS FBeginBalanceLocal,\r\n");
            strBuffer.append(" (isnull(temp1.FBeginBalanceFor,0)+isnull(temp1.FDebitFor,0)-isnull(temp1.FCreditFor,0)) AS FBeginBalanceFor ,\r\n");
            strBuffer.append(" (isnull(temp1.FBeginBalanceRpt,0)+isnull(temp1.FDebitRpt,0)-isnull(temp1.FCreditRpt,0)) AS FBeginBalanceRpt ,\r\n");
            strBuffer.append(" (isnull(temp1.FYearDebitRpt,0)+isnull(temp1.FDebitRpt,0)) AS FYearDebitRpt,\r\n");
            strBuffer.append(" (isnull(temp1.FYearDebitLocal,0)+isnull(temp1.FDebitLocal,0)) AS FYearDebitLocal,\r\n");
            strBuffer.append(" (isnull(temp1.FYearDebitFor,0)+isnull(temp1.FDebitFor,0)) AS FYearDebitFor, \r\n");
            strBuffer.append(" (isnull(temp1.FYearDebitQty,0)+isnull(temp1.FDebitQty,0)) AS FYearDebitQty, \r\n");
            strBuffer.append(" (isnull(temp1.FYearCreditQty,0)+isnull(temp1.FCreditQty,0)) AS FYearCreditQty,\r\n");
            strBuffer.append(" (isnull(temp1.FYearCreditRpt,0)+isnull(temp1.FCreditRpt,0)) AS FYearCreditRpt,\r\n");
            strBuffer.append(" (isnull(temp1.FYearCreditLocal,0)+isnull(temp1.FCreditLocal,0)) AS FYearCreditLocal,\r\n");
            strBuffer.append(" (isnull(temp1.FYearCreditFor,0)+isnull(temp1.FCreditFor,0)) AS FYearCreditFor, \r\n");
            strBuffer.append(" (ISNULL(temp1.FBeginQty,0)+ ISNULL(temp1.FDebitQty,0)  - ISNULL(temp1.FCreditQty,0)) FBeginQty \r\n");
            strBuffer.append(" from  (SELECT ");
            int currenPeriod = pe.getCurrentYear() * 100 + pe.getCurrentPeriod();
            if (isForCurrency) {
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FBeginBalanceFor \r\n");
                strBuffer.append(" else 0 end) FBeginBalanceFor, \r\n");
                strBuffer.append("sum(TAB2.FDebitFor) FDebitFor,\r\n");
                strBuffer.append("sum(TAB2.FCreditFor) FCreditFor,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearDebitFor \r\n");
                strBuffer.append(" else 0 end) FYearDebitFor, \r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearCreditFor \r\n");
                strBuffer.append(" else 0 end) FYearCreditFor, \r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FBeginBalanceLocal \r\n");
                strBuffer.append(" else 0 end) FBeginBalanceLocal, \r\n");
                strBuffer.append("sum(TAB2.FDebitLocal) FDebitLocal,\r\n");
                strBuffer.append("sum(TAB2.FCreditLocal) FCreditLocal,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearDebitLocal \r\n");
                strBuffer.append(" else 0 end) FYearDebitLocal,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearCreditLocal \r\n");
                strBuffer.append(" else 0 end) FYearCreditLocal,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FBeginBalanceRpt \r\n");
                strBuffer.append(" else 0 end) FBeginBalanceRpt, \r\n");
                strBuffer.append("sum(TAB2.FDebitRpt) FDebitRpt,\r\n");
                strBuffer.append("sum(TAB2.FCreditRpt) FCreditRpt,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearDebitRpt \r\n");
                strBuffer.append(" else 0 end) FYearDebitRpt ,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearCreditRpt \r\n");
                strBuffer.append(" else 0 end) FYearCreditRpt ,\r\n");
            } else if (isLocalCurrency) {
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FBeginBalanceLocal \r\n");
                strBuffer.append(" else 0 end) FBeginBalanceFor, \r\n");
                strBuffer.append("sum(TAB2.FDebitLocal) FDebitFor,\r\n");
                strBuffer.append("sum(TAB2.FCreditLocal) FCreditFor,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearDebitLocal \r\n");
                strBuffer.append(" else 0 end) FYearDebitFor, \r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearCreditLocal \r\n");
                strBuffer.append(" else 0 end) FYearCreditFor, \r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FBeginBalanceLocal \r\n");
                strBuffer.append(" else 0 end) FBeginBalanceLocal, \r\n");
                strBuffer.append("sum(TAB2.FDebitLocal) FDebitLocal,\r\n");
                strBuffer.append("sum(TAB2.FCreditLocal) FCreditLocal,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearDebitLocal \r\n");
                strBuffer.append(" else 0 end) FYearDebitLocal,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearCreditLocal \r\n");
                strBuffer.append(" else 0 end) FYearCreditLocal,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FBeginBalanceLocal \r\n");
                strBuffer.append(" else 0 end) FBeginBalanceRpt, \r\n");
                strBuffer.append("sum(TAB2.FDebitLocal) FDebitRpt,\r\n");
                strBuffer.append("sum(TAB2.FCreditLocal) FCreditRpt,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearDebitLocal \r\n");
                strBuffer.append(" else 0 end) FYearDebitRpt ,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearCreditLocal \r\n");
                strBuffer.append(" else 0 end) FYearCreditRpt ,\r\n");
            } else if (isRptCurrency) {
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FBeginBalanceRpt \r\n");
                strBuffer.append(" else 0 end) FBeginBalanceFor, \r\n");
                strBuffer.append("sum(TAB2.FDebitRpt) FDebitFor,\r\n");
                strBuffer.append("sum(TAB2.FCreditRpt) FCreditFor,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearDebitRpt \r\n");
                strBuffer.append(" else 0 end) FYearDebitFor, \r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearCreditRpt \r\n");
                strBuffer.append(" else 0 end) FYearCreditFor, \r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FBeginBalanceRpt \r\n");
                strBuffer.append(" else 0 end) FBeginBalanceLocal, \r\n");
                strBuffer.append("sum(TAB2.FDebitRpt) FDebitLocal,\r\n");
                strBuffer.append("sum(TAB2.FCreditRpt) FCreditLocal,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearDebitRpt \r\n");
                strBuffer.append(" else 0 end) FYearDebitLocal,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearCreditRpt \r\n");
                strBuffer.append(" else 0 end) FYearCreditLocal,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FBeginBalanceRpt \r\n");
                strBuffer.append(" else 0 end) FBeginBalanceRpt, \r\n");
                strBuffer.append("sum(TAB2.FDebitRpt) FDebitRpt,\r\n");
                strBuffer.append("sum(TAB2.FCreditRpt) FCreditRpt,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearDebitRpt \r\n");
                strBuffer.append(" else 0 end) FYearDebitRpt ,\r\n");
                strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
                strBuffer.append(" then TAB2.FYearCreditRpt \r\n");
                strBuffer.append(" else 0 end) FYearCreditRpt ,\r\n");
            }
            strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
            strBuffer.append(" then TAB2.FBeginQty \r\n");
            strBuffer.append(" else 0 end) FBeginQty, \r\n");
            strBuffer.append("sum(TAB2.FDebitQty) FDebitQty,\r\n");
            strBuffer.append("sum(TAB2.FCreditQty) FCreditQty,\r\n");
            strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
            strBuffer.append(" then TAB2.FYearDebitQty \r\n");
            strBuffer.append(" else 0 end) FYearDebitQty, \r\n");
            strBuffer.append("sum(case when TAB2.FPeriod = ").append(currenPeriod);
            strBuffer.append(" then TAB2.FYearCreditQty \r\n");
            strBuffer.append(" else 0 end) FYearCreditQty, \r\n");
            strBuffer.append("HG.");
            strBuffer.append(asstActTypeInfoFieldName);
            strBuffer.append(" AS FAsstItemId,");
            strBuffer.append("'").append(account.getId()).append("'  FAccountID, ");
            if (isForCurrency) {
                strBuffer.append(" TAB2.FCurrencyID FCurrencyID, ");
            } else {
                strBuffer.append(" '" + currencyId + "' FCurrencyID, ");
            }
            strBuffer.append(" TAB2.FAssistGrpID FAssistGrpID,");
            strBuffer.append("  hg.fnumber AS FAsstItemNumber, hg.fname_").append(partner.getContext().getLocale());
            strBuffer.append(" AS FAsstItemName ");
            if (existAssistMeasure) {
                strBuffer.append(", TAB2.FMeasureUnitID FMeasureUnitID ");
            } else if (useAccountMeasure) {
                strBuffer.append(", TA1.FMeasureUnitID FMeasureUnitID ");
            }
            strBuffer.append("   FROM ");
            strBuffer.append(mainTable);
            strBuffer.append("           as TAB2 \r\n");
            strBuffer.append("         INNER JOIN T_BD_AccountView TA1 \r\n");
            strBuffer.append("            ON TAB2.FAccountID = TA1.FID \r\n");
            strBuffer.append("            AND TAB2.FOrgUnitID = TA1.FCompanyID \r\n");
            strBuffer.append("         INNER JOIN ");
            strBuffer.append(tableName);
            strBuffer.append("         HG \r\n");
            strBuffer.append("            ON TAB2.FAssistGrpID = HG.FID \r\n");
            strBuffer.append("      WHERE TAB2.FOrgUnitID = ? \r\n");
            strBuffer.append(" AND TAB2.FPeriod in " + SQLUtil.buildPeriodNumbersInSql(pe.getCurrentYear(), pe.getCurrentPeriod(), condition.getPeriodYearStart(), condition.getPeriodNumberStart() - 1));
            if (!account.isIsLeaf()) {
                if (condition.getAccountIdSet().isEmpty()) {
                    strBuffer.append(" and TA1.fnumber >= '").append(account.getNumber()).append("'");
                    strBuffer.append(" and TA1.fnumber < '").append(account.getNumber()).append("zz'");
                } else {
                    strBuffer.append(" and TAB2.faccountid in ").append(GLRptDaoUtil.set2String(condition.getAccountIdSet()));
                }
            } else {
                strBuffer.append("         AND TAB2.FAccountID = ? \r\n");
            }
            if (!(condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
                strBuffer.append("         AND TAB2.FCurrencyID = ? \r\n ");
            }
            strBuffer.append("      GROUP BY");
            if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
                strBuffer.append(" TAB2.FCurrencyID,");
            }
            strBuffer.append(" TAB2.FAssistGrpID");
            strBuffer.append(" ,HG.");
            strBuffer.append(asstActTypeInfoFieldName);
            strBuffer.append(" , hg.fnumber , hg.fname_").append(partner.getContext().getLocale());
            if (existAssistMeasure) {
                strBuffer.append(", TAB2.FMeasureUnitID");
            } else if (useAccountMeasure) {
                strBuffer.append(", TA1.FMeasureUnitID");
            }
            strBuffer.append(") AS temp1 \r\n");
            strBuffer.append(") tp where tp.FBeginBalanceRpt <> 0 OR tp.FBeginBalanceLocal <> 0 OR tp.FBeginBalanceFor <> 0 \r\n ) T2");
        }
        strBuffer.append(" on hg.fid = T2.FAssistGrpID ");
        strBuffer.append("     LEFT OUTER JOIN ");
        strBuffer.append("    ( ");
        periodRange = new int[]{condition.getPeriodYearStart(), condition.getPeriodNumberStart(), condition.getPeriodYearEnd(), condition.getPeriodNumberEnd()};
        strBuffer.append(this.getHappenedDataSql(partner, periodRange, mainTable, tableName));
        strBuffer.append(") AS T1 \r\n");
        strBuffer.append("         ON hg.fid = T1.FAssistGrpID \r\n");
        if (condition.isAllCurrency()) {
            strBuffer.append("         and T1.FCurrencyID = T2.FCurrencyID \r\n");
        }
        if (existAssistMeasure || useAccountMeasure) {
            strBuffer.append("         and T1.FMeasureUnitID = T2.FMeasureUnitID \r\n");
        }
        strBuffer.append("     LEFT OUTER JOIN ");
        strBuffer.append(" (");
        usedPeriod = GlUtils.getStartPeriod(partner.getContext(), partner.getCompanyId());
        if (condition.getPeriodYearStart() == usedPeriod.getPeriodYear()) {
            strBuffer.append("select tmp1.FAccountID,tmp1.FCurrencyID,tmp1.FassistGrpID,");
            if (existAssistMeasure || useAccountMeasure) {
                strBuffer.append(" tmp1.FMeasureUnitID FMeasureUnitID, ");
            } else {
                strBuffer.append(" NULL FMeasureUnitID, ");
            }
            strBuffer.append("(isnull(tmp1.FYearDebitRpt,0)+isnull(tmp2.FDebitRpt,0)) AS FYearDebitRpt,");
            strBuffer.append("(isnull(tmp1.FYearDebitFor,0)+isnull(tmp2.FDebitFor,0)) AS FYearDebitFor,");
            strBuffer.append("(isnull(tmp1.FYearDebitLocal,0)+isnull(tmp2.FDebitLocal,0)) AS FYearDebitLocal,");
            strBuffer.append("(isnull(tmp1.FYearDebitQty,0)+isnull(tmp2.FDebitQty,0)) AS FYearDebitQty,");
            strBuffer.append("(isnull(tmp1.FYearCreditRpt,0)+isnull(tmp2.FCreditRpt,0)) AS FYearCreditRpt,");
            strBuffer.append("(isnull(tmp1.FYearCreditFor,0)+isnull(tmp2.FCreditFor,0)) AS FYearCreditFor,");
            strBuffer.append("(isnull(tmp1.FYearCreditLocal,0)+isnull(tmp2.FCreditLocal,0)) AS FYearCreditLocal,");
            strBuffer.append("(isnull(tmp1.FYearCreditQty,0)+isnull(tmp2.FCreditQty,0)) AS FYearCreditQty");
            strBuffer.append("  from (SELECT  TAB3.*");
            if (useAccountMeasure) {
                strBuffer.append(", TA2.FMeasureUnitID FMeasureUnitID");
            }
            if (isLocalCurrency || isRptCurrency) {
                strBuffer.append("\t,'" + currencyId + "' FCurrencyID ");
            }
            if (isLocalCurrency) {
                strBuffer.append(" ,FBeginBalanceLocal FBeginBalanceFor \r\n");
                strBuffer.append(" ,FDebitLocal FDebitFor \r\n");
                strBuffer.append(" ,FCreditLocal FCreditFor \r\n");
                strBuffer.append(" ,FYearDebitLocal FYearDebitFor \r\n");
                strBuffer.append(" ,FYearCreditLocal FYearCreditFor \r\n");
                strBuffer.append(" ,FBeginBalanceLocal FBeginBalanceRpt \r\n");
                strBuffer.append(" ,FDebitLocal FDebitRpt \r\n");
                strBuffer.append(" ,FCreditLocal FCreditRpt \r\n");
                strBuffer.append(" ,FYearDebitLocal FYearDebitRpt \r\n");
                strBuffer.append(" ,FYearCreditLocal FYearCreditRpt \r\n");
            }
            if (isRptCurrency) {
                strBuffer.append(" ,FBeginBalanceRpt FBeginBalanceFor \r\n");
                strBuffer.append(" ,FDebitRpt FDebitFor \r\n");
                strBuffer.append(" ,FCreditRpt FCreditFor \r\n");
                strBuffer.append(" ,FYearDebitRpt FYearDebitFor \r\n");
                strBuffer.append(" ,FYearCreditRpt FYearCreditFor \r\n");
                strBuffer.append(" ,FBeginBalanceRpt FBeginBalanceLocal \r\n");
                strBuffer.append(" ,FDebitRpt FDebitLocal \r\n");
                strBuffer.append(" ,FCreditRpt FCreditLocal \r\n");
                strBuffer.append(" ,FYearDebitRpt FYearDebitLocal \r\n");
                strBuffer.append(" ,FYearCreditRpt FYearCreditLocal \r\n");
            }
            strBuffer.append("\t,HG.");
            strBuffer.append(asstActTypeInfoFieldName);
            strBuffer.append(" FROM ");
            strBuffer.append(mainTable);
            strBuffer.append("           AS TAB3 \r\n");
            strBuffer.append("           INNER JOIN T_BD_AccountView \r\n TA2 \r\n");
            strBuffer.append("              ON TAB3.FAccountID = TA2.FID \r\n");
            strBuffer.append("              AND TAB3.FOrgUnitID = TA2.FCompanyID \r\n");
            strBuffer.append("         INNER JOIN ");
            strBuffer.append(tableName);
            strBuffer.append("         HG \r\n");
            strBuffer.append("              ON TAB3.FAssistGrpID = HG.FID \r\n");
            strBuffer.append("        WHERE \r\n");
            strBuffer.append("           TAB3.FOrgUnitID = ? \r\n");
            strBuffer.append("           AND TAB3.FPeriod = ? \r\n");
            if (!account.isIsLeaf()) {
                if (condition.getAccountIdSet().isEmpty()) {
                    strBuffer.append(" and TA2.fnumber >= '").append(account.getNumber()).append("'");
                    strBuffer.append(" and TA2.fnumber < '").append(account.getNumber()).append("zz'");
                } else {
                    strBuffer.append(" and TAB3.faccountid in ").append(GLRptDaoUtil.set2String(condition.getAccountIdSet()));
                }
            } else {
                strBuffer.append("           AND TAB3.FAccountID = ? \r\n");
            }
            if (!(condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
                strBuffer.append("           AND TAB3.FCurrencyID = ? \r\n");
            }
            strBuffer.append(" ) tmp1 ");
            strBuffer.append(" left outer join ");
            strBuffer.append(" (");
            periodRange = new int[]{condition.getPeriodYearEnd(), pe.getCurrentPeriod() + 1, condition.getPeriodYearEnd(), condition.getPeriodNumberEnd()};
            strBuffer.append(this.getHappenedDataSql(partner, periodRange, mainTable, tableName));
            strBuffer.append(" ) tmp2  ");
            strBuffer.append("         ON tmp1.FAccountID = tmp2.FAccountID \r\n");
            if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
                strBuffer.append("         AND tmp1.FCurrencyID = tmp2.FCurrencyID \r\n");
            }
            strBuffer.append("         AND tmp1.FAssistGrpID = tmp2.FAssistGrpID \r\n");
            if (existAssistMeasure || useAccountMeasure) {
                strBuffer.append("         AND tmp1.FMeasureUnitID = tmp2.FMeasureUnitID \r\n");
            }
        } else {
            periodRange = new int[]{condition.getPeriodYearEnd(), 1, condition.getPeriodYearEnd(), condition.getPeriodNumberEnd()};
            strBuffer.append(this.getHappenedDataSql(partner, periodRange, mainTable, tableName));
        }
        strBuffer.append("    ) AS T3 \r\n");
        strBuffer.append("         ON hg.fid = T3.FAssistGrpID \r\n");
        if (condition.isAllCurrency()) {
            strBuffer.append("         and T3.FCurrencyID = T2.FCurrencyID \r\n");
        }
        if (existAssistMeasure || useAccountMeasure) {
            strBuffer.append("         and T3.FMeasureUnitID = T2.FMeasureUnitID \r\n");
        }
        strBuffer.append(") TP where  TP.FBeginBalanceFor <> 0 OR   TP.FDebitFor <> 0");
        strBuffer.append("   OR  TP.FCreditFor <> 0 OR  TP.FYearDebitFor <> 0  OR  TP.FYearCreditFor <> 0\r\n");
        strBuffer.append(" OR  TP.FEndBalanceFor <> 0  OR  TP.FBeginBalanceLocal <> 0 \r\n");
        strBuffer.append(" OR  TP.FDebitLocal <> 0   OR TP.FCreditLocal <> 0\r\n");
        strBuffer.append(" OR TP.FYearDebitLocal <> 0  OR  TP.FYearCreditLocal <> 0\r\n");
        strBuffer.append("OR  TP.FEndBalance <> 0  OR TP.FBeginBalanceRpt <> 0\r\n");
        strBuffer.append("OR TP.FDebitRpt <> 0 OR TP.FCreditRpt <> 0\r\n");
        strBuffer.append("OR TP.FYearDebitRpt <> 0 OR  TP.FYearCreditRpt <> 0\r\n");
        strBuffer.append(" OR TP.FEndBalanceRpt <> 0  OR  TP.FBeginQty <> 0  OR TP.FYearDebitQty <> 0\r\n");
        strBuffer.append(" OR TP.FYearCreditQty <> 0  OR  TP.FDebitQty <> 0 \r\n");
        strBuffer.append("OR TP.FCreditQty <> 0   OR  TP.FEndQty <> 0 \r\n");
        return strBuffer.toString();
    }

    private String getHappenedDataSql(ReportPartner partner, int[] periodRange, String mainTable, String tableName) throws EASBizException, BOSException {
        AccountViewInfo account = partner.getAccountViewInfo();
        AsstActTypeInfo asstActType = partner.getAsstActTypeInfo();
        String asstActTypeInfoFieldName = asstActType.getMappingFieldName();
        ReportConditionBase condition = partner.getFixCondition();
        ReportConditionBalanceListAssist cond = (ReportConditionBalanceListAssist)partner.getFixCondition();
        String currencyId = condition.getCurrencyID();
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("SELECT '").append(account.getId()).append("' FAccountID,TA.FAssistGrpID AS FAssistGrpID,\r\n");
        if (isForCurrency) {
            strBuffer.append("        TA.FCurrencyID FCurrencyID,\r\n");
        } else {
            strBuffer.append("        '" + currencyId + "' FCurrencyID,\r\n");
        }
        boolean isQtyAsst = partner.getParmQtyAsst();
        boolean existAssistMeasure = this.judgeExistAssistMeasureBalanceTable(isQtyAsst, cond.isOptionShowQty(), account, asstActType);
        boolean useAccountMeasure = this.useAccountMeasure(isQtyAsst, cond.isOptionShowQty(), account);
        if (existAssistMeasure) {
            strBuffer.append(" TA.FMeasureUnitID FMeasureUnitID, \r\n");
        } else if (useAccountMeasure) {
            strBuffer.append(" TA1.FMeasureUnitID FMeasureUnitID, \r\n");
        } else {
            strBuffer.append(" NULL FMeasureUnitID, \r\n");
        }
        if (isForCurrency) {
            strBuffer.append("        SUM(isnull(FDebitFor,0)) AS FDebitFor,  \r\n");
            strBuffer.append("        SUM(isnull(FCreditFor,0)) AS FCreditFor,\r\n");
            strBuffer.append("        SUM(isnull(FDebitLocal,0)) AS FDebitLocal,\r\n");
            strBuffer.append("        SUM(isnull(FCreditLocal,0)) AS FCreditLocal,\r\n");
            strBuffer.append("        SUM(isnull(FDebitRpt,0)) AS FDebitRpt, ");
            strBuffer.append("        SUM(isnull(FCreditRpt,0)) AS FCreditRpt, \r\n");
        } else if (isLocalCurrency) {
            strBuffer.append("        SUM(isnull(FDebitLocal,0)) FDebitFor,  \r\n");
            strBuffer.append("        SUM(isnull(FCreditLocal,0)) FCreditFor,\r\n");
            strBuffer.append("        SUM(isnull(FDebitLocal,0)) AS FDebitLocal,\r\n");
            strBuffer.append("        SUM(isnull(FCreditLocal,0)) AS FCreditLocal,\r\n");
            strBuffer.append("        SUM(isnull(FDebitLocal,0)) FDebitRpt, ");
            strBuffer.append("        SUM(isnull(FCreditLocal,0)) FCreditRpt, \r\n");
        } else if (isRptCurrency) {
            strBuffer.append("        SUM(isnull(FDebitRpt,0)) FDebitFor,  \r\n");
            strBuffer.append("        SUM(isnull(FCreditRpt,0)) FCreditFor,\r\n");
            strBuffer.append("        SUM(isnull(FDebitRpt,0)) FDebitLocal,\r\n");
            strBuffer.append("        SUM(isnull(FCreditRpt,0)) FCreditLocal,\r\n");
            strBuffer.append("        SUM(isnull(FDebitRpt,0)) AS FDebitRpt, ");
            strBuffer.append("        SUM(isnull(FCreditRpt,0)) AS FCreditRpt, \r\n");
        }
        strBuffer.append("\tSUM(ISNULL(FBeginQty,0)) FBeginQty, \t\t\r\n");
        strBuffer.append("\tSUM(ISNULL(FDebitQty,0)) FDebitQty, \t\t\r\n");
        strBuffer.append("\tSUM(ISNULL(FCreditQty,0)) FCreditQty, \t\t\r\n");
        strBuffer.append("\tSUM(ISNULL(FEndQty,0)) FEndQty \t\t\r\n");
        strBuffer.append("\t,HG1.");
        strBuffer.append(asstActTypeInfoFieldName);
        strBuffer.append(" AS FAsstItemId");
        strBuffer.append(" , hg1.fnumber AS FAsstItemNumber, hg1.fname_").append(partner.getContext().getLocale());
        strBuffer.append(" AS FAsstItemName ");
        strBuffer.append("   FROM ");
        strBuffer.append(mainTable);
        strBuffer.append("           as TA \r\n");
        strBuffer.append("         INNER JOIN T_BD_AccountView TA1 \r\n");
        strBuffer.append("            ON TA.FAccountID = TA1.FID \r\n");
        strBuffer.append("            AND TA.FOrgUnitID = TA1.FCompanyID \r\n");
        strBuffer.append("         INNER JOIN ");
        strBuffer.append(tableName);
        strBuffer.append("         HG1 \r\n");
        strBuffer.append("            ON TA.FAssistGrpID = HG1.FID \r\n");
        strBuffer.append("      WHERE TA.FOrgUnitID = ? \r\n");
        strBuffer.append(" AND TA.FPeriod in " + SQLUtil.buildPeriodNumbersInSql(periodRange[0], periodRange[1], periodRange[2], periodRange[3]));
        if (!account.isIsLeaf()) {
            if (condition.getAccountIdSet().isEmpty()) {
                strBuffer.append(" and TA1.fnumber >= '").append(account.getNumber()).append("'");
                strBuffer.append(" and TA1.fnumber < '").append(account.getNumber()).append("zz'");
            } else {
                strBuffer.append(" and TA.faccountid in ").append(GLRptDaoUtil.set2String(condition.getAccountIdSet()));
            }
        } else {
            strBuffer.append(" AND TA.FAccountID = ? \r\n");
        }
        if (!(condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
            strBuffer.append("         AND TA.FCurrencyID = ? \r\n ");
        }
        strBuffer.append("      GROUP BY");
        if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            strBuffer.append("  TA.FCurrencyID,");
        }
        strBuffer.append("  TA.FAssistGrpID");
        strBuffer.append("\t,HG1.");
        strBuffer.append(asstActTypeInfoFieldName);
        strBuffer.append(" , hg1.fnumber , hg1.fname_").append(partner.getContext().getLocale());
        if (existAssistMeasure) {
            strBuffer.append(", TA.FMeasureUnitID");
        } else if (useAccountMeasure) {
            strBuffer.append(", TA1.FMeasureUnitID");
        }
        return strBuffer.toString();
    }

    private boolean beginPeriodisAfter(ReportPartner partner) throws EASBizException, BOSException {
        int peroidNumberBegin;
        ReportConditionBase condition;
        int peroidYeayBegin;
        Context ctx = partner.getContext();
        PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)(partner.getCompany() == null ? ContextUtil.getCurrentFIUnit((Context)ctx) : partner.getCompany()), (Context)ctx);
        int curPeriod = pe.getCurrentYear() * 100 + pe.getCurrentPeriod();
        return curPeriod < (peroidYeayBegin = (condition = partner.getFixCondition()).getPeriodYearStart()) * 100 + (peroidNumberBegin = condition.getPeriodNumberStart());
    }
}

