/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IMCLdgScheme;
import com.kingdee.eas.fi.gl.MCLdgSchemeAcctInfo;
import com.kingdee.eas.fi.gl.MCLdgSchemeCyInfo;
import com.kingdee.eas.fi.gl.MCLdgSchemeFactory;
import com.kingdee.eas.fi.gl.MCLdgSchemeInfo;
import com.kingdee.eas.fi.gl.ReportConditionColumnarJournal;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadItemInfo;
import com.kingdee.eas.fi.gl.app.AbstractGLReportColumnarJournalControllerBean;
import com.kingdee.eas.fi.gl.app.GLReportColumnarJournalColumnInfo;
import com.kingdee.eas.fi.gl.app.ReportPartner;
import com.kingdee.eas.fi.gl.common.SqlParameter2;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GLReportColumnarJournalControllerBean
extends AbstractGLReportColumnarJournalControllerBean {
    private static final long serialVersionUID = 1363536965743611255L;
    protected static final String TYPE_QTY = "Qty";
    protected static final String TYPE_FOR = "For";
    protected static final String TYPE_LOCAL = "Local";
    protected static final String TYPE_RPT = "Rpt";
    protected static final String TITLE_DEBIT = "Debit";
    protected static final String TITLE_CREDIT = "Credit";
    protected static final String TITLE_QUANTITY = "Quantity";
    protected static final String TITLE_DATE = "Date";
    protected static final String TITLE_VOUCHER_NUMBER = "VoucherNumber";
    protected static final String TITLE_DESCRIPTION = "Description";
    protected static final String TITLE_AMOUNT = "Amount";
    protected static final String TITLE_SOURCE_CURRENCY = "SourceCurrency";
    protected static final String TITLE_LOCAL_CURRENCY = "LocalCurrency";
    protected static final String TITLE_BALANCE = "Balance";
    protected static final String TITLE_TOTAL = "Total";
    protected static final String TITLE_DC = "DC";

    @Override
    protected ReportTableHeadInfo getDefalutTableHeadInfo(ReportPartner partner) throws BOSException, EASBizException {
        ReportTableHeadInfo head = new ReportTableHeadInfo();
        String[] columnNames = new String[]{"FDate", "FVoucherNumber", "FDescription", "FDebit", "FCredit", "FDC", "FBalance"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{TITLE_DATE, TITLE_VOUCHER_NUMBER, TITLE_DESCRIPTION, TITLE_DEBIT, TITLE_CREDIT, TITLE_BALANCE, TITLE_BALANCE}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = new int[]{80, 100, 100, 80, 80, 40, 80};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 2, 2, 1, 2};
        head.setAlignments(alignments);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
        return head;
    }

    @Override
    protected Object[] getLineObjects(ReportPartner partner, ResultSet rs) throws SQLException, EASBizException, BOSException {
        return null;
    }

    protected Object[] getLineObjects(ReportPartner partner, ResultSet rs, BigDecimal[] balances) throws SQLException, EASBizException, BOSException {
        ReportConditionColumnarJournal condition = (ReportConditionColumnarJournal)partner.getFixCondition();
        MCLdgSchemeInfo scheme = this.getSchemeInfo(partner);
        boolean isMulCurrency = scheme.getCurrencyCols().size() > 1;
        ArrayList columnList = this.getBigDecimalColumns(partner);
        int index = 0;
        Object[] row = new Object[partner.getTableHeadInfo().getColumnCount() + 2];
        row[index++] = rs.getDate("FDate");
        row[index++] = rs.getString("FVoucherNumber");
        int lineType = rs.getInt("FLineType");
        row[index++] = lineType == 0 ? rs.getString("FDescription") : this.getDescription(partner, lineType);
        BigDecimal[] values = new BigDecimal[columnList.size()];
        for (int i = 0; i < columnList.size(); ++i) {
            GLReportColumnarJournalColumnInfo column = (GLReportColumnarJournalColumnInfo)columnList.get(i);
            values[i] = rs.getBigDecimal(column.getColumnName());
        }
        for (int j = 0; j < 2; ++j) {
            BigDecimal[] sumValues = new BigDecimal[]{ZERO, ZERO, ZERO, ZERO};
            for (GLReportColumnarJournalColumnInfo column : columnList) {
                if (column.getAccountId() != null || (j != 0 || column.getBalanceDC() != BalanceDirectionEnum.DEBIT) && (j != 1 || column.getBalanceDC() != BalanceDirectionEnum.CREDIT)) continue;
                BigDecimal value = values[column.getBalanceSite()];
                row[index++] = value;
                if (value == null) continue;
                int type = column.getTypeString().equals(TYPE_QTY) ? 0 : (column.getTypeString().equals(TYPE_FOR) ? 1 : (column.getTypeString().equals(TYPE_LOCAL) ? 2 : 3));
                sumValues[type] = sumValues[type].add(value);
            }
            if (isMulCurrency) {
                if (condition.getOptionShowQuantity()) {
                    row[index++] = sumValues[0];
                }
                row[index++] = sumValues[2];
            }
            if (lineType != 0) continue;
            if (j == 0) {
                for (int i = 0; i < 4; ++i) {
                    balances[i] = balances[i].add(sumValues[i]);
                }
                continue;
            }
            for (int i = 0; i < 4; ++i) {
                balances[i] = balances[i].subtract(sumValues[i]);
            }
        }
        int acctDC = this.getSchemeInfo(partner).getAccount().getDC().getValue();
        row[index++] = partner.getDCStringWithParm(balances[2], acctDC);
        if (condition.getOptionShowQuantity()) {
            row[index++] = balances[0] == null ? null : partner.getBalanceForDCWithParm(balances[0], acctDC);
        }
        row[index++] = balances[2] == null ? null : partner.getBalanceForDCWithParm(balances[2], acctDC);
        for (GLReportColumnarJournalColumnInfo column : columnList) {
            if (column.getAccountId() == null || column.getCurrencyId() == null) continue;
            row[index++] = this.getBigDecimalForDC(values[column.getBalanceSite()], column.getBalanceDC());
        }
        row[index++] = lineType == -3 ? ReportResultInfo.LINE_YEAR_BEGIN : (lineType == -2 ? ReportResultInfo.LINE_PERIOD_BEGIN : (lineType == -1 ? ReportResultInfo.LINE_DATE_BEGIN : new Integer(lineType)));
        row[index++] = rs.getString("FVoucherID");
        return row;
    }

    protected void addTableHeadInfo(ReportPartner partner) throws EASBizException, BOSException {
        ReportConditionColumnarJournal condition = (ReportConditionColumnarJournal)partner.getFixCondition();
        MCLdgSchemeInfo scheme = this.getSchemeInfo(partner);
        boolean isMulCurrency = scheme.getCurrencyCols().size() > 1;
        ArrayList listBigDecimal = this.getBigDecimalColumns(partner);
        int balanceIndex = 0;
        int titleLineCount = 3;
        if (isMulCurrency) {
            ++titleLineCount;
        }
        if (condition == null) {
            throw new ReportException(ReportException.CONDITION_EMPTY);
        }
        ArrayList<ReportTableHeadItemInfo> itemList = new ArrayList<ReportTableHeadItemInfo>();
        ReportTableHeadItemInfo item = new ReportTableHeadItemInfo("FDate", 80, 0);
        item.setTitles(new String[]{TITLE_DATE});
        item.setFreeze(false);
        item.setMerge(false);
        item.setVisible(true);
        itemList.add(item);
        item = new ReportTableHeadItemInfo("FVoucherNumber", 100, 0);
        item.setTitles(new String[]{TITLE_VOUCHER_NUMBER});
        item.setFreeze(false);
        item.setMerge(false);
        item.setVisible(true);
        itemList.add(item);
        item = new ReportTableHeadItemInfo("FDescription", 200, 0);
        item.setTitles(new String[]{TITLE_DESCRIPTION});
        item.setFreeze(false);
        item.setMerge(false);
        item.setVisible(true);
        itemList.add(item);
        int scaleQty = partner.getParmQtyScale();
        int scaleLocal = partner.getScaleLocal();
        for (int k = 0; k < 2; ++k) {
            ReportTableHeadItemInfo item2;
            String preColumnName = k == 0 ? "FDebitC" : "FCreditC";
            String topTitle = k == 0 ? TITLE_DEBIT : TITLE_CREDIT;
            BalanceDirectionEnum dc = k == 0 ? BalanceDirectionEnum.DEBIT : BalanceDirectionEnum.CREDIT;
            Iterator iterator = scheme.getCurrencyCols().iterator();
            while (iterator.hasNext()) {
                GLReportColumnarJournalColumnInfo column;
                int index;
                int i;
                boolean[] titleNeedResource;
                String[] titles;
                ReportTableHeadItemInfo item3;
                MCLdgSchemeCyInfo cyInfo = (MCLdgSchemeCyInfo)iterator.next();
                if (condition.getOptionShowQuantity()) {
                    item3 = new ReportTableHeadItemInfo(this.getColumnName(preColumnName, cyInfo.getSeq(), TYPE_QTY), 80, 2);
                    titles = new String[titleLineCount];
                    titleNeedResource = new boolean[titleLineCount];
                    for (i = 0; i < titleNeedResource.length; ++i) {
                        titleNeedResource[i] = true;
                    }
                    index = 0;
                    titles[index++] = topTitle;
                    titles[index++] = topTitle;
                    if (isMulCurrency) {
                        titleNeedResource[index] = false;
                        titles[index++] = cyInfo.getCurrencyColName();
                    }
                    titles[index++] = TITLE_QUANTITY;
                    item3.setTitles(titles);
                    item3.setTitleNeedResource(titleNeedResource);
                    item3.setNumberStyleType(1);
                    item3.setNumberScale(scaleQty);
                    item3.setNeedKilobit(true);
                    itemList.add(item3);
                    column = new GLReportColumnarJournalColumnInfo(item3.getColumnName(), partner.getParmQtyScale());
                    column.setCurrencyId(cyInfo.getCurrency().getId().toString());
                    column.setTypeString(TYPE_QTY);
                    column.setBalanceDC(dc);
                    column.setPLAccount(scheme.getAccount().getAccountTypeID().getProperty() == AccountProperty.SUNYI);
                    column.setBalanceSite(balanceIndex++);
                    listBigDecimal.add(column);
                }
                if (condition.getOptionShowSourceAmount() && !partner.isBaseCurrency(cyInfo.getCurrency().getId().toString()) && !partner.isParmForeignCurrencySu()) {
                    item3 = new ReportTableHeadItemInfo(this.getColumnName(preColumnName, cyInfo.getSeq(), TYPE_FOR), 80, 2);
                    titles = new String[titleLineCount];
                    titleNeedResource = new boolean[titleLineCount];
                    for (i = 0; i < titleNeedResource.length; ++i) {
                        titleNeedResource[i] = true;
                    }
                    index = 0;
                    titles[index++] = topTitle;
                    titles[index++] = topTitle;
                    if (isMulCurrency) {
                        titleNeedResource[index] = false;
                        titles[index++] = cyInfo.getCurrencyColName();
                    }
                    titles[index++] = TITLE_SOURCE_CURRENCY;
                    item3.setTitles(titles);
                    item3.setTitleNeedResource(titleNeedResource);
                    item3.setNumberStyleType(1);
                    item3.setNumberScale(cyInfo.getCurrency().getPrecision());
                    item3.setNeedKilobit(true);
                    itemList.add(item3);
                    column = new GLReportColumnarJournalColumnInfo(item3.getColumnName(), partner.getAmountScale(cyInfo.getCurrency().getId().toString()));
                    column.setCurrencyId(cyInfo.getCurrency().getId().toString());
                    column.setTypeString(TYPE_FOR);
                    column.setBalanceDC(dc);
                    column.setPLAccount(scheme.getAccount().getAccountTypeID().getProperty() == AccountProperty.SUNYI);
                    column.setBalanceSite(balanceIndex++);
                    listBigDecimal.add(column);
                }
                item3 = new ReportTableHeadItemInfo(this.getColumnName(preColumnName, cyInfo.getSeq(), TYPE_LOCAL), 80, 2);
                titles = new String[titleLineCount];
                titleNeedResource = new boolean[titleLineCount];
                for (i = 0; i < titleNeedResource.length; ++i) {
                    titleNeedResource[i] = true;
                }
                index = 0;
                titles[index++] = topTitle;
                titles[index++] = topTitle;
                if (isMulCurrency) {
                    titleNeedResource[index] = false;
                    titles[index++] = cyInfo.getCurrencyColName();
                }
                if (condition.getOptionShowSourceAmount() && !partner.isBaseCurrency(cyInfo.getCurrency().getId().toString()) && !partner.isParmForeignCurrencySu()) {
                    titles[index++] = TITLE_LOCAL_CURRENCY;
                } else if (condition.getOptionShowQuantity()) {
                    titles[index++] = TITLE_AMOUNT;
                }
                item3.setTitles(titles);
                item3.setTitleNeedResource(titleNeedResource);
                item3.setNumberStyleType(1);
                item3.setNumberScale(scaleLocal);
                item3.setNeedKilobit(true);
                itemList.add(item3);
                column = new GLReportColumnarJournalColumnInfo(item3.getColumnName(), partner.getScaleLocal());
                column.setCurrencyId(cyInfo.getCurrency().getId().toString());
                column.setTypeString(TYPE_LOCAL);
                column.setBalanceDC(dc);
                column.setPLAccount(scheme.getAccount().getAccountTypeID().getProperty() == AccountProperty.SUNYI);
                column.setBalanceSite(balanceIndex++);
                listBigDecimal.add(column);
            }
            if (!isMulCurrency) continue;
            if (condition.getOptionShowQuantity()) {
                item2 = new ReportTableHeadItemInfo(preColumnName + "SumQty", 80, 2);
                item2.setTitles(new String[]{topTitle, topTitle, TITLE_QUANTITY});
                item2.setNumberStyleType(1);
                item2.setNumberScale(scaleQty);
                item2.setNeedKilobit(true);
                itemList.add(item2);
            }
            item2 = new ReportTableHeadItemInfo(preColumnName + "SumLocal", 80, 2);
            String[] titles = new String[titleLineCount];
            int index = 0;
            titles[index++] = topTitle;
            titles[index++] = topTitle;
            titles[index++] = TITLE_TOTAL;
            item2.setTitles(titles);
            item2.setNumberStyleType(1);
            item2.setNumberScale(scaleLocal);
            item2.setNeedKilobit(true);
            itemList.add(item2);
        }
        ReportTableHeadItemInfo item4 = new ReportTableHeadItemInfo("FDC", 40, 1);
        String[] titles = new String[titleLineCount];
        int index = 0;
        titles[index++] = TITLE_BALANCE;
        if (isMulCurrency || condition.getOptionShowSourceAmount()) {
            titles[index++] = TITLE_BALANCE;
        }
        titles[index++] = TITLE_DC;
        item4.setTitles(titles);
        itemList.add(item4);
        if (condition.getOptionShowQuantity()) {
            item4 = new ReportTableHeadItemInfo("FBalanceQuantity", 80, 2);
            titles = new String[titleLineCount];
            index = 0;
            titles[index++] = TITLE_BALANCE;
            if (isMulCurrency || condition.getOptionShowSourceAmount()) {
                titles[index++] = TITLE_BALANCE;
            }
            titles[index++] = TITLE_QUANTITY;
            item4.setTitles(titles);
            item4.setNumberStyleType(1);
            item4.setNumberScale(scaleQty);
            item4.setNeedKilobit(true);
            itemList.add(item4);
        }
        item4 = new ReportTableHeadItemInfo("FBalanceAmountLocal", 80, 2);
        titles = new String[titleLineCount];
        index = 0;
        titles[index++] = TITLE_BALANCE;
        if (isMulCurrency || condition.getOptionShowSourceAmount()) {
            titles[index++] = TITLE_BALANCE;
        }
        titles[index++] = TITLE_AMOUNT;
        item4.setTitles(titles);
        item4.setNumberStyleType(1);
        item4.setNumberScale(scaleLocal);
        item4.setNeedKilobit(true);
        itemList.add(item4);
        ArrayList<ReportTableHeadItemInfo> listDebit = new ArrayList<ReportTableHeadItemInfo>();
        ArrayList listCredit = new ArrayList();
        ArrayList<GLReportColumnarJournalColumnInfo> listBigDecimalDebit = new ArrayList<GLReportColumnarJournalColumnInfo>();
        ArrayList listBigDecimalCredit = new ArrayList();
        Map childMap = this.getLeafAccount(partner, scheme);
        Iterator iteratorAcct = scheme.getAccountCols().iterator();
        while (iteratorAcct.hasNext()) {
            MCLdgSchemeAcctInfo acctInfo = (MCLdgSchemeAcctInfo)iteratorAcct.next();
            ArrayList listChildAccount = (ArrayList)childMap.get(acctInfo.getAccount().getId().toString());
            String title = acctInfo.getDc() == BalanceDirectionEnum.DEBIT ? TITLE_DEBIT : TITLE_CREDIT;
            BalanceDirectionEnum dc = acctInfo.getDc();
            ArrayList<ReportTableHeadItemInfo> list = acctInfo.getDc() == BalanceDirectionEnum.DEBIT ? listDebit : listCredit;
            ArrayList<GLReportColumnarJournalColumnInfo> listColumn = acctInfo.getDc() == BalanceDirectionEnum.DEBIT ? listBigDecimalDebit : listBigDecimalCredit;
            Iterator iteratorCy = scheme.getCurrencyCols().iterator();
            while (iteratorCy.hasNext()) {
                GLReportColumnarJournalColumnInfo column;
                int index2;
                int i;
                boolean[] titleNeedResource;
                String[] titles2;
                ReportTableHeadItemInfo item5;
                MCLdgSchemeCyInfo cyInfo = (MCLdgSchemeCyInfo)iteratorCy.next();
                String accountId = acctInfo.getAccount().getId().toString();
                String currencyId = cyInfo.getCurrency().getId().toString();
                if (condition.getOptionShowQuantity()) {
                    item5 = new ReportTableHeadItemInfo(this.getColumnName(acctInfo.getSeq(), cyInfo.getSeq(), TYPE_QTY), 80, 2);
                    titles2 = new String[titleLineCount];
                    titleNeedResource = new boolean[titleLineCount];
                    for (i = 0; i < titleNeedResource.length; ++i) {
                        titleNeedResource[i] = true;
                    }
                    index2 = 0;
                    titles2[index2++] = title;
                    titleNeedResource[index2] = false;
                    titles2[index2++] = acctInfo.getAccountColName();
                    titles2[index2++] = TITLE_QUANTITY;
                    item5.setTitles(titles2);
                    item5.setTitleNeedResource(titleNeedResource);
                    item5.setNumberStyleType(1);
                    item5.setNumberScale(scaleQty);
                    item5.setNeedKilobit(true);
                    list.add(item5);
                    column = new GLReportColumnarJournalColumnInfo(item5.getColumnName(), partner.getParmQtyScale());
                    column.setAccountId(accountId);
                    if (!acctInfo.getAccount().isIsLeaf()) {
                        column.setAccountLeaf(false);
                        column.setChildAccount(listChildAccount);
                    }
                    column.setCurrencyId(currencyId);
                    column.setTypeString(TYPE_QTY);
                    column.setBalanceDC(dc);
                    column.setPLAccount(acctInfo.getAccount().getAccountTypeID().getProperty() == AccountProperty.SUNYI);
                    column.setBalanceSite(balanceIndex++);
                    listColumn.add(column);
                }
                if (condition.getOptionShowSourceAmount() && !partner.isBaseCurrency(cyInfo.getCurrency().getId().toString()) && !partner.isParmForeignCurrencySu()) {
                    item5 = new ReportTableHeadItemInfo(this.getColumnName(acctInfo.getSeq(), cyInfo.getSeq(), TYPE_FOR), 80, 2);
                    titles2 = new String[titleLineCount];
                    titleNeedResource = new boolean[titleLineCount];
                    for (i = 0; i < titleNeedResource.length; ++i) {
                        titleNeedResource[i] = true;
                    }
                    index2 = 0;
                    titles2[index2++] = title;
                    titleNeedResource[index2] = false;
                    titles2[index2++] = acctInfo.getAccountColName();
                    if (isMulCurrency) {
                        titleNeedResource[index2] = false;
                        titles2[index2++] = cyInfo.getCurrencyColName();
                    }
                    titles2[index2++] = TITLE_SOURCE_CURRENCY;
                    item5.setTitles(titles2);
                    item5.setTitleNeedResource(titleNeedResource);
                    item5.setNumberStyleType(1);
                    item5.setNumberScale(cyInfo.getCurrency().getPrecision());
                    item5.setNeedKilobit(true);
                    list.add(item5);
                    column = new GLReportColumnarJournalColumnInfo(item5.getColumnName(), partner.getAmountScale(cyInfo.getCurrency().getId().toString()));
                    column.setAccountId(accountId);
                    if (!acctInfo.getAccount().isIsLeaf()) {
                        column.setAccountLeaf(false);
                        column.setChildAccount(listChildAccount);
                    }
                    column.setCurrencyId(currencyId);
                    column.setTypeString(TYPE_FOR);
                    column.setBalanceDC(dc);
                    column.setPLAccount(acctInfo.getAccount().getAccountTypeID().getProperty() == AccountProperty.SUNYI);
                    column.setBalanceSite(balanceIndex++);
                    listColumn.add(column);
                }
                item5 = new ReportTableHeadItemInfo(this.getColumnName(acctInfo.getSeq(), cyInfo.getSeq(), TYPE_LOCAL), 80, 2);
                titles2 = new String[titleLineCount];
                titleNeedResource = new boolean[titleLineCount];
                for (i = 0; i < titleNeedResource.length; ++i) {
                    titleNeedResource[i] = true;
                }
                index2 = 0;
                titles2[index2++] = title;
                titleNeedResource[index2] = false;
                titles2[index2++] = acctInfo.getAccountColName();
                if (isMulCurrency) {
                    titleNeedResource[index2] = false;
                    titles2[index2++] = cyInfo.getCurrencyColName();
                }
                if (condition.getOptionShowSourceAmount() && !partner.isBaseCurrency(cyInfo.getCurrency().getId().toString()) && !partner.isParmForeignCurrencySu()) {
                    titles2[index2++] = TITLE_LOCAL_CURRENCY;
                } else if (condition.getOptionShowQuantity()) {
                    titles2[index2++] = TITLE_AMOUNT;
                }
                item5.setTitles(titles2);
                item5.setTitleNeedResource(titleNeedResource);
                item5.setNumberStyleType(1);
                item5.setNumberScale(scaleLocal);
                item5.setNeedKilobit(true);
                list.add(item5);
                column = new GLReportColumnarJournalColumnInfo(item5.getColumnName(), partner.getScaleLocal());
                column.setAccountId(accountId);
                if (!acctInfo.getAccount().isIsLeaf()) {
                    column.setAccountLeaf(false);
                    column.setChildAccount(listChildAccount);
                }
                column.setCurrencyId(currencyId);
                column.setTypeString(TYPE_LOCAL);
                column.setBalanceDC(dc);
                column.setPLAccount(acctInfo.getAccount().getAccountTypeID().getProperty() == AccountProperty.SUNYI);
                column.setBalanceSite(balanceIndex++);
                listColumn.add(column);
            }
        }
        itemList.addAll(listDebit);
        itemList.addAll(listCredit);
        listBigDecimal.addAll(listBigDecimalDebit);
        listBigDecimal.addAll(listBigDecimalCredit);
        for (int i = 0; i < listBigDecimal.size(); ++i) {
            GLReportColumnarJournalColumnInfo column = (GLReportColumnarJournalColumnInfo)listBigDecimal.get(i);
            column.setBalanceSite(i);
            column.setPLAccount(false);
        }
        ReportTableHeadItemInfo[] items = new ReportTableHeadItemInfo[itemList.size()];
        for (int i = 0; i < itemList.size(); ++i) {
            items[i] = (ReportTableHeadItemInfo)itemList.get(i);
        }
        ReportTableHeadInfo head = new ReportTableHeadInfo(items);
        head.setHeadMerge(true);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
        partner.setTableHeadInfo(head);
    }

    protected Map getLeafAccount(ReportPartner partner, MCLdgSchemeInfo scheme) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TAP.FID FParentID,TA.FID\tFChildID\t\t\t\t\t\t\r\n");
        sql.append("FROM T_BD_AccountView---\r\n TA\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("INNER JOIN T_BD_AccountView---\r\n TAP\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("ON CHARINDEX(TAP.FLongNumber||'!',TA.FLongNumber) = 1\t\t\t\r\n");
        sql.append("\tAND TAP.FCompanyID = TA.FCompanyID\t\t\t\t\t\t\t\r\n");
        sql.append("WHERE TA.FIsLeaf = 1\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tAND (");
        SqlParameter2 parameter = new SqlParameter2();
        boolean needOr = false;
        Iterator iterator = scheme.getAccountCols().iterator();
        while (iterator.hasNext()) {
            if (needOr) {
                sql.append(" OR ");
            } else {
                needOr = true;
            }
            MCLdgSchemeAcctInfo acctInfo = (MCLdgSchemeAcctInfo)iterator.next();
            sql.append(" TAP.FID = ? ");
            parameter.addValueId((CoreBaseInfo)acctInfo.getAccount());
        }
        sql.append(")");
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = partner.getConnection().prepareStatement(parameter.getSqlWithParameters(sql.toString()));
            stmt.setFetchSize(100);
            rs = stmt.executeQuery();
            ArrayList<String> childArray = null;
            while (rs.next()) {
                String parentId = rs.getString("FParentID");
                String childId = rs.getString("FChildID");
                childArray = (ArrayList<String>)map.get(parentId);
                if (childArray == null) {
                    childArray = new ArrayList<String>();
                    map.put(parentId, childArray);
                }
                childArray.add(childId);
            }
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return map;
    }

    @Override
    protected String getReportName() {
        return "ColumnarJournal";
    }

    @Override
    protected String getAuthorityName() {
        return "GLColumnarJournal";
    }

    protected String getQueryName() {
        return "GLColumnarJournal";
    }

    protected MCLdgSchemeInfo getSchemeInfo(ReportPartner partner) throws BOSException, EASBizException {
        MCLdgSchemeInfo schemeInfo = (MCLdgSchemeInfo)partner.getVariable("MCLdgSchemeInfo");
        if (schemeInfo == null) {
            String schemeId = ((ReportConditionColumnarJournal)partner.getFixCondition()).getSchemeId();
            if (schemeId == null || schemeId.length() == 0) {
                throw new ReportException(ReportException.SCHEME_EMPTY);
            }
            IMCLdgScheme scheme = MCLdgSchemeFactory.getLocalInstance(partner.getContext());
            ObjectUuidPK pk = new ObjectUuidPK(schemeId);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("account.id"));
            sic.add(new SelectorItemInfo("account.name"));
            sic.add(new SelectorItemInfo("account.dc"));
            sic.add(new SelectorItemInfo("account.accountTypeID.id"));
            sic.add(new SelectorItemInfo("account.accountTypeID.property"));
            sic.add(new SelectorItemInfo("accountCols.id"));
            sic.add(new SelectorItemInfo("accountCols.seq"));
            sic.add(new SelectorItemInfo("accountCols.dc"));
            sic.add(new SelectorItemInfo("accountCols.accountColName"));
            sic.add(new SelectorItemInfo("accountCols.account.id"));
            sic.add(new SelectorItemInfo("accountCols.account.name"));
            sic.add(new SelectorItemInfo("accountCols.account.isLeaf"));
            sic.add(new SelectorItemInfo("accountCols.account.accountTypeID.id"));
            sic.add(new SelectorItemInfo("accountCols.account.accountTypeID.property"));
            sic.add(new SelectorItemInfo("currencyCols.id"));
            sic.add(new SelectorItemInfo("currencyCols.seq"));
            sic.add(new SelectorItemInfo("currencyCols.currencyColName"));
            sic.add(new SelectorItemInfo("currencyCols.currency.id"));
            sic.add(new SelectorItemInfo("currencyCols.currency.precision"));
            try {
                schemeInfo = (MCLdgSchemeInfo)scheme.getValue((IObjectPK)pk, sic);
            }
            catch (ObjectNotFoundException ex) {
                throw new ReportException(ReportException.SCHEME_EMPTY, ex);
            }
            if (schemeInfo == null) {
                throw new ReportException(ReportException.SCHEME_EMPTY);
            }
            partner.setVariable("MCLdgSchemeInfo", schemeInfo);
        }
        return schemeInfo;
    }

    protected ArrayList getBigDecimalColumns(ReportPartner partner) {
        ArrayList list = (ArrayList)partner.getVariable("BigDecimalColumnNameList");
        if (list == null) {
            list = new ArrayList();
            partner.setVariable("BigDecimalColumnNameList", list);
        }
        return list;
    }

    protected String getColumnName(String prefix, int index, String suffix) {
        StringBuffer sb = new StringBuffer(prefix);
        sb.append(index + 10);
        sb.append(suffix);
        return sb.toString();
    }

    protected String getColumnName(int accountIndex, int currencyIndex, String suffix) {
        StringBuffer sb = new StringBuffer(16);
        sb.append("FA");
        sb.append(accountIndex + 10);
        sb.append("C");
        sb.append(currencyIndex + 10);
        sb.append(suffix);
        return sb.toString();
    }

    protected String getDescription(ReportPartner partner, int lineType) {
        String description = null;
        switch (lineType) {
            case -3: {
                description = partner.TITLE_YEAR_START;
                break;
            }
            case -2: {
                description = partner.TITLE_PERIOD_START;
                break;
            }
            case 2: {
                description = partner.TITLE_DAY_SUM;
                break;
            }
            case 3: {
                description = partner.TITLE_PERIOD_SUM;
                break;
            }
            case 4: {
                description = partner.TITLE_YEAR_SUM;
                break;
            }
            default: {
                description = "UnKnow Line Type";
            }
        }
        return description;
    }

    protected void addBalance(BigDecimal[] values, BigDecimal[] balances, ArrayList columnList) {
        for (GLReportColumnarJournalColumnInfo column : columnList) {
            int type;
            if (column.getAccountId() != null) continue;
            int n = column.getTypeString().equals(TYPE_QTY) ? 0 : (column.getTypeString().equals(TYPE_FOR) ? 1 : (type = column.getTypeString().equals(TYPE_LOCAL) ? 2 : 3));
            BigDecimal value = values[column.getBalanceSite()];
            if (value == null) continue;
            if (column.getBalanceDC() == BalanceDirectionEnum.DEBIT) {
                balances[type] = balances[type].add(value);
                continue;
            }
            balances[type] = balances[type].subtract(value);
        }
    }

    @Override
    protected void doSomethingBeforeQuery(ReportPartner partner) throws BOSException, EASBizException {
        super.doSomethingBeforeQuery(partner);
        this.addTableHeadInfo(partner);
    }

    protected String getChildAccountIdsFromScheme(ReportPartner partner) throws BOSException, EASBizException {
        String accountIds;
        block6: {
            accountIds = (String)partner.getVariable("AccountIdsFromScheme");
            if (accountIds != null) break block6;
            StringBuffer sb = new StringBuffer();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT TA.FID \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n ");
            sql.append("FROM T_BD_AccountView---\r\n TA \t\t\t\t\t\t\t\t\t\t\r\n ");
            sql.append("\tINNER JOIN T_BD_AccountView---\r\n TAP \t\t\t\t\t\t\t\r\n ");
            sql.append("\tON ( CHARINDEX(TAP.FLongNumber || '!',TA.FLongNumber)=1 \t\r\n ");
            sql.append("\t\tOR TA.FID = TAP.FID ) \t\t\t\t\t\t\t\t\t\r\n ");
            sql.append("\tAND TA.FAccountTableID = TAP.FAccountTableID \t\t\t\t\r\n ");
            sql.append("\tAND TA.FIsLeaf = 1\t\t\t\t\t\t\t\t\t\t\t\r\n ");
            sql.append("\tAND ( 1=0 ");
            SqlParameter2 parameter = new SqlParameter2();
            Iterator iterator = this.getSchemeInfo(partner).getAccountCols().iterator();
            while (iterator.hasNext()) {
                MCLdgSchemeAcctInfo acctInfo = (MCLdgSchemeAcctInfo)iterator.next();
                sql.append("\tOR TAP.FID =  ? \t\t\t\t\t\t\t\t\t\t\r\n ");
                parameter.addValueId((CoreBaseInfo)acctInfo.getAccount());
            }
            sql.append("\t) \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n ");
            sql.append("\tAND TA.FAccountTableID = ? \t\t\t\t\t\t\t\t\t\r\n");
            sql.append("\tAND TA.FCompanyId = ? \t\t\t\t\t\t\t\t\t\t\r\n");
            parameter.addValueChar(partner.getAccountTableId());
            parameter.addValueChar(partner.getCompanyId());
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = partner.getConnection().prepareStatement(sql.toString());
                stmt.setFetchSize(100);
                parameter.putToStatement(stmt);
                rs = stmt.executeQuery();
                int indexResult = 0;
                while (rs.next()) {
                    sb.append(indexResult > 0 ? ",'" : "'");
                    sb.append(rs.getString("FID"));
                    sb.append(indexResult % 5 == 0 ? "'\r\n" : "'");
                    ++indexResult;
                }
            }
            catch (SQLException sqle) {
                try {
                    sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                    throw new SQLDataException(sqle);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            accountIds = sb.length() > 0 ? sb.toString() : null;
            partner.setVariable("AccountIdsFromScheme", accountIds);
        }
        return accountIds;
    }

    protected String getAccountIdsFromScheme(ReportPartner partner) throws BOSException, EASBizException {
        int index = 0;
        StringBuffer sb = new StringBuffer();
        Iterator iterator = this.getSchemeInfo(partner).getAccountCols().iterator();
        while (iterator.hasNext()) {
            MCLdgSchemeAcctInfo acctInfo = (MCLdgSchemeAcctInfo)iterator.next();
            sb.append(index == 0 ? "'" : ",'");
            sb.append(acctInfo.getAccount().getId().toString());
            sb.append(index % 5 == 0 ? "'\r\n" : "'");
            ++index;
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    protected String getCurrencyIdsFromScheme(ReportPartner partner) throws BOSException, EASBizException {
        int index = 0;
        StringBuffer sb = new StringBuffer();
        Iterator iterator = this.getSchemeInfo(partner).getCurrencyCols().iterator();
        while (iterator.hasNext()) {
            MCLdgSchemeCyInfo cyInfo = (MCLdgSchemeCyInfo)iterator.next();
            sb.append(index == 0 ? "'" : ",'");
            sb.append(cyInfo.getCurrency().getId().toString());
            sb.append(index % 5 == 0 ? "'\r\n" : "'");
            ++index;
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    @Override
    protected Collection getDataFromResult(ReportPartner partner, ResultSet rs) throws BOSException, SQLException, EASBizException {
        if (partner.getStartIndex() + partner.getLineCount() == 0) {
            return new ArrayList();
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(partner.getLineCount());
        ArrayList columnList = this.getBigDecimalColumns(partner);
        BigDecimal[] balances = this.getStartBalanceForReadData(partner);
        BigDecimal[] values = new BigDecimal[columnList.size()];
        int index = 0;
        while (rs.next()) {
            if (partner.getStartIndex() > index) {
                int lineType = rs.getInt("FLineType");
                if (lineType == 0) {
                    for (int i = 0; i < columnList.size(); ++i) {
                        GLReportColumnarJournalColumnInfo column = (GLReportColumnarJournalColumnInfo)columnList.get(i);
                        if (column.getAccountId() != null) continue;
                        values[i] = rs.getBigDecimal(column.getColumnName());
                    }
                    this.addBalance(values, balances, columnList);
                }
            } else {
                arrayList.add(this.getLineObjects(partner, rs, balances));
            }
            ++index;
        }
        return arrayList;
    }

    @Override
    protected String getSqlForDataSelect(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionColumnarJournal condition = (ReportConditionColumnarJournal)partner.getFixCondition();
        if (condition == null) {
            throw new ReportException(ReportException.CONDITION_EMPTY);
        }
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append("FDate,");
        sqlSelect.append("FVoucherNumber,FDescription,\r\n");
        for (GLReportColumnarJournalColumnInfo column : this.getBigDecimalColumns(partner)) {
            sqlSelect.append(column.getColumnName());
            sqlSelect.append(" , \r\n");
        }
        sqlSelect.append("\tFLineType,FVoucherID, \r\n");
        sqlSelect.append("\tFPeriodYear,FPeriodNumber ");
        return sqlSelect.toString();
    }

    @Override
    protected String getSqlForDataFrom(ReportPartner partner) throws BOSException {
        StringBuffer sqlFrom = new StringBuffer();
        sqlFrom.append("FROM ");
        sqlFrom.append(partner.getTempTableName());
        sqlFrom.append(" T \r\n");
        return sqlFrom.toString();
    }

    @Override
    protected String getSqlForDataWhere(ReportPartner partner) throws BOSException, EASBizException {
        return "";
    }

    @Override
    protected String getSqlForDataOrder(ReportPartner partner) throws BOSException, EASBizException {
        return "ORDER BY FPeriodYear,FPeriodNumber,FLineType,FDate,FVoucherNumber ";
    }

    @Override
    protected String getSqlForDataFromAndWhere(ReportPartner partner) throws BOSException, EASBizException {
        return this.getSqlForDataFrom(partner);
    }

    protected HashMap getStartBalance(ReportPartner partner) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT \r\n");
        sql.append("\tTP.FBeginDate,TP.FPeriodYear,TP.FPeriodNumber");
        for (GLReportColumnarJournalColumnInfo column : this.getBigDecimalColumns(partner)) {
            String dCString;
            sql.append(",\r\n");
            sql.append("\tSUM(CASE WHEN ");
            if (column.getAccountId() != null) {
                sql.append("TB.FAccountId = '");
                sql.append(column.getAccountId());
                sql.append("'");
            }
            if (column.getCurrencyId() != null) {
                if (column.getAccountId() != null) {
                    sql.append(" AND ");
                }
                sql.append(" TB.FCurrencyId = '");
                sql.append(column.getCurrencyId());
                sql.append("'");
            }
            sql.append(" THEN ");
            if (column.isPLAccount() && !TYPE_QTY.equals(column.getTypeString())) {
                if (column.getAccountId() == null) {
                    sql.append(" CASE WHEN FYearPnL");
                    sql.append(column.getTypeString());
                    sql.append(" > FMonthPnL");
                    sql.append(column.getTypeString());
                    sql.append(" THEN ");
                    if (column.getBalanceDC() == BalanceDirectionEnum.DEBIT) {
                        sql.append(" FYearPnL");
                        sql.append(column.getTypeString());
                        sql.append(" - FMonthPnL");
                        sql.append(column.getTypeString());
                        sql.append(" ELSE 0 END ");
                    } else {
                        sql.append(" 0 ELSE ");
                        sql.append(" FMonthPnL");
                        sql.append(column.getTypeString());
                        sql.append(" - FYearPnL");
                        sql.append(column.getTypeString());
                        sql.append(" END ");
                    }
                } else {
                    sql.append(" FEndBalance");
                    sql.append(column.getTypeString());
                    sql.append(" - FYearDebit");
                    sql.append(column.getTypeString());
                    sql.append(" + FYearCredit");
                    sql.append(column.getTypeString());
                    sql.append(" + FYearPnL");
                    sql.append(column.getTypeString());
                    sql.append(" - FMonthPnL");
                    sql.append(column.getTypeString());
                }
            } else if (column.getAccountId() == null) {
                dCString = column.getBalanceDC() == BalanceDirectionEnum.DEBIT ? TITLE_DEBIT : TITLE_CREDIT;
                sql.append(" TB.FYear");
                sql.append(dCString);
                sql.append(column.getTypeString());
                sql.append(" - ");
                sql.append(" TB.F");
                sql.append(dCString);
                sql.append(column.getTypeString());
            } else {
                sql.append("TB.FBegin");
                if (!TYPE_QTY.equals(column.getTypeString())) {
                    sql.append(TITLE_BALANCE);
                }
                sql.append(column.getTypeString());
            }
            sql.append(" ELSE 0 END) ");
            sql.append(column.getColumnName());
            sql.append("B,\r\n");
            sql.append("\tSUM(CASE WHEN ");
            if (column.getAccountId() != null) {
                sql.append("TB.FAccountId = '");
                sql.append(column.getAccountId());
                sql.append("'");
            }
            if (column.getCurrencyId() != null) {
                if (column.getAccountId() != null) {
                    sql.append(" AND ");
                }
                sql.append(" TB.FCurrencyId = '");
                sql.append(column.getCurrencyId());
                sql.append("'");
            }
            sql.append(" THEN ");
            if (column.isPLAccount() && !TYPE_QTY.equals(column.getTypeString())) {
                if (column.getAccountId() == null) {
                    sql.append(" CASE WHEN FYearPnL");
                    sql.append(column.getTypeString());
                    sql.append(" > FMonthPnL");
                    sql.append(column.getTypeString());
                    sql.append(" THEN ");
                    if (column.getBalanceDC() == BalanceDirectionEnum.DEBIT) {
                        sql.append(" FYearPnL");
                        sql.append(column.getTypeString());
                        sql.append(" - FMonthPnL");
                        sql.append(column.getTypeString());
                        sql.append(" ELSE 0 END ");
                    } else {
                        sql.append(" 0 ELSE ");
                        sql.append(" FYearPnL");
                        sql.append(column.getTypeString());
                        sql.append(" - FMonthPnL");
                        sql.append(column.getTypeString());
                        sql.append(" END ");
                    }
                } else {
                    sql.append(" FYearPnL");
                    sql.append(column.getTypeString());
                    sql.append(" - FMonthPnL");
                    sql.append(column.getTypeString());
                }
            } else if (column.getAccountId() == null) {
                dCString = column.getBalanceDC() == BalanceDirectionEnum.DEBIT ? TITLE_DEBIT : TITLE_CREDIT;
                sql.append(" TB.FYear");
                sql.append(dCString);
                sql.append(column.getTypeString());
                sql.append(" - ");
                sql.append(" TB.F");
                sql.append(dCString);
                sql.append(column.getTypeString());
            } else {
                sql.append(" TB.FYearDebit");
                sql.append(column.getTypeString());
                sql.append(" - TB.FDebit");
                sql.append(column.getTypeString());
                sql.append(" - TB.FYearCredit");
                sql.append(column.getTypeString());
                sql.append(" + TB.FCredit");
                sql.append(column.getTypeString());
            }
            sql.append(" ELSE 0 END) ");
            sql.append(column.getColumnName());
            sql.append("Y ");
        }
        sql.append(" \r\n ");
        sql.append("FROM T_BD_Period TP \r\n");
        ReportConditionColumnarJournal condition = (ReportConditionColumnarJournal)partner.getFixCondition();
        int balType = condition.getOptionPosting() ? 1 : 5;
        sql.append("\tINNER JOIN " + GLBalanceUtils.getAccountBalanceTable(balType, null) + " TB \r\n");
        sql.append("\tON TB.FPeriod = TP.FNumber \r\n");
        sql.append("\tAND TB.FOrgUnitID = ?  \r\n");
        sql.append("\tAND TB.FAccountID in (  \r\n");
        sql.append(this.getAccountIdsFromScheme(partner));
        sql.append(") \r\n");
        sql.append("\tAND TB.FCurrencyID in (  \r\n");
        sql.append(this.getCurrencyIdsFromScheme(partner));
        sql.append(") \r\n");
        sql.append("WHERE  \r\n");
        sql.append("\tTP.FTypeID = ? AND \r\n");
        sql.append("\tTB.FPeriod = ? AND \r\n");
        sql.append("GROUP BY TP.FID,TP.FBeginDate,TP.FPeriodYear,TP.FPeriodNumber");
        SqlParameter2 parameters = new SqlParameter2();
        parameters.addValueChar(partner.getCompanyId());
        parameters.addValueId((CoreBaseInfo)partner.getCompany().getAccountPeriodType());
        parameters.addValue(new Integer(condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart()));
        HashMap<String, Comparable<Date>> map = new HashMap<String, Comparable<Date>>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = partner.getConnection().prepareStatement(sql.toString());
            parameters.putToStatement(stmt);
            rs = stmt.executeQuery();
            if (rs.next()) {
                map.put("FBeginDate", rs.getTimestamp("FBeginDate"));
                map.put("FPeriodYear", new Integer(rs.getInt("FPeriodYear")));
                map.put("FPeriodNumber", new Integer(rs.getInt("FPeriodNumber")));
                for (GLReportColumnarJournalColumnInfo column : this.getBigDecimalColumns(partner)) {
                    BigDecimal value = null;
                    value = rs.getBigDecimal(column.getColumnName() + "B");
                    map.put(column.getColumnName() + "B", value == null ? ZERO : value);
                    value = rs.getBigDecimal(column.getColumnName() + "Y");
                    map.put(column.getColumnName() + "Y", value == null ? ZERO : value);
                }
            }
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return map;
    }

    protected BigDecimal[] getStartBalanceForReadData(ReportPartner partner) throws BOSException, EASBizException {
        BigDecimal[] balances = new BigDecimal[]{ZERO, ZERO, ZERO, ZERO};
        ReportConditionColumnarJournal condition = (ReportConditionColumnarJournal)partner.getFixCondition();
        int balType = condition.getOptionPosting() ? 1 : 5;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT \r\n");
        sql.append("\tSUM(TB.FBeginQty) FBeginQty,\r\n ");
        sql.append("\tSUM(TB.FBeginBalanceFor) FBeginBalanceFor,\r\n ");
        sql.append("\tSUM(TB.FBeginBalanceLocal) FBeginBalanceLocal,\r\n ");
        sql.append("\tSUM(TB.FBeginBalanceRpt) FBeginBalanceRpt \r\n ");
        sql.append("FROM T_BD_Period TP \r\n");
        sql.append("\tINNER JOIN " + GLBalanceUtils.getAssistBalanceTable(balType, null) + " TB \r\n");
        sql.append("\tON TB.FPeriod = TP.FNumber \r\n");
        sql.append("\tAND TB.FOrgUnitID = ?  \r\n");
        sql.append("\tAND TB.FAccountID in ( ? ) \r\n");
        sql.append("\tAND TB.FCurrencyID in ( ? ) \r\n");
        sql.append("WHERE  \r\n");
        sql.append("\tTP.FTypeID = ? AND \r\n");
        sql.append("\tTB.FPeriod = ? AND \r\n");
        SqlParameter2 parameters = new SqlParameter2();
        parameters.addValueChar(partner.getCompanyId());
        parameters.addValueChar(this.getAccountIdsFromScheme(partner));
        parameters.addValueChar(this.getCurrencyIdsFromScheme(partner));
        parameters.addValueId((CoreBaseInfo)partner.getCompany().getAccountPeriodType());
        parameters.addValue(new Integer(condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart()));
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = partner.getConnection().prepareStatement(sql.toString());
            parameters.putToStatement(stmt);
            rs = stmt.executeQuery();
            if (rs.next()) {
                balances[0] = rs.getBigDecimal("FBeginQty");
                balances[1] = rs.getBigDecimal("FBeginBalanceFor");
                balances[2] = rs.getBigDecimal("FBeginBalanceLocal");
                balances[3] = rs.getBigDecimal("FBeginBalanceRpt");
            }
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        for (int i = 0; i < balances.length; ++i) {
            if (balances[i] != null) continue;
            balances[i] = ZERO;
        }
        return balances;
    }

    protected HashMap getStartBalanceFromPeriod(ReportPartner partner) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT \r\n");
        sql.append("\tTP.FBeginDate,TP.FPeriodYear,TP.FPeriodNumber \r\n");
        sql.append("FROM T_BD_Period TP \r\n");
        sql.append("WHERE  \r\n");
        sql.append("\tTP.FTypeID = ? AND \r\n");
        sql.append("\tTP.FPeriodYear = ? AND \r\n");
        sql.append("\tTP.FPeriodNumber = ? \r\n");
        SqlParameter2 parameters = new SqlParameter2();
        ReportConditionColumnarJournal condition = (ReportConditionColumnarJournal)partner.getFixCondition();
        parameters.addValueId((CoreBaseInfo)partner.getCompany().getAccountPeriodType());
        parameters.addValue(new Integer(condition.getPeriodYearStart()));
        parameters.addValue(new Integer(condition.getPeriodNumberStart()));
        HashMap<String, Comparable<Date>> map = new HashMap<String, Comparable<Date>>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = partner.getConnection().prepareStatement(sql.toString());
            parameters.putToStatement(stmt);
            rs = stmt.executeQuery();
            if (rs.next()) {
                map.put("FBeginDate", rs.getTimestamp("FBeginDate"));
                map.put("FPeriodYear", new Integer(rs.getInt("FPeriodYear")));
                map.put("FPeriodNumber", new Integer(rs.getInt("FPeriodNumber")));
            }
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return map;
    }

    protected String getTempTableStruct(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionColumnarJournal condition = (ReportConditionColumnarJournal)partner.getFixCondition();
        if (condition == null) {
            throw new ReportException(ReportException.CONDITION_EMPTY);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("( \r\n");
        sql.append("\tFDate DateTime, \r\n");
        sql.append("\tFVoucherNumber NVarchar(640), \r\n");
        sql.append("\tFDescription NVarchar(320), \r\n");
        for (GLReportColumnarJournalColumnInfo column : this.getBigDecimalColumns(partner)) {
            sql.append(column.getColumnName());
            sql.append(" Decimal(28,10), \r\n");
        }
        sql.append("\tFLineType Int, \r\n");
        sql.append("\tFVoucherID varChar(44), \r\n");
        sql.append("\tFPeriodYear Int, \r\n");
        sql.append("\tFPeriodNumber Int  \r\n )");
        return sql.toString();
    }

    @Override
    protected void insertDataIntoTempTable(ReportPartner partner) throws BOSException, EASBizException {
        partner.setTempTableName(partner.createTempTableAsynchronism("GLCJ", this.getTempTableStruct(partner)));
        HashMap map = this.getStartBalance(partner);
        if (map == null || map.size() == 0) {
            map = this.getStartBalanceFromPeriod(partner);
        }
        this.insertStartBalance(map, partner);
        this.insertVoucher(partner);
        this.insertPeriodSum(partner);
        this.insertYearSum(map, partner);
    }

    protected boolean insertPeriodSum(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionColumnarJournal condition = (ReportConditionColumnarJournal)partner.getFixCondition();
        if (condition == null) {
            throw new ReportException(ReportException.CONDITION_EMPTY);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append("\t(FDate, \r\n");
        for (GLReportColumnarJournalColumnInfo column : this.getBigDecimalColumns(partner)) {
            sql.append(column.getColumnName());
            sql.append(" , \r\n");
        }
        sql.append("\tFLineType,FPeriodYear, FPeriodNumber) \r\n");
        sql.append("SELECT TBP.FEndDate FDate, \r\n");
        for (GLReportColumnarJournalColumnInfo column : this.getBigDecimalColumns(partner)) {
            sql.append("\tSUM(");
            sql.append(column.getColumnName());
            sql.append(" ) ");
            sql.append(column.getColumnName());
            sql.append(" , \r\n");
        }
        sql.append("\t3 FLineType,TBP.FPeriodYear, TBP.FPeriodNumber \r\n");
        sql.append("FROM T_BD_PERIOD TBP \r\n");
        sql.append("\tLEFT OUTER JOIN  ");
        sql.append(partner.getTempTableName());
        sql.append(" TP \r\n");
        sql.append("\tON TP.FPeriodYear = TBP.FPeriodYear \r\n");
        sql.append("\t\tAND TP.FPeriodNumber = TBP.FPeriodNumber \r\n");
        sql.append("\t\tAND TP.FLineType = 0 \r\n");
        sql.append("WHERE TBP.FTypeID = ? \r\n");
        sql.append("\t\tAND (TBP.FPeriodYear>? or(TBP.FPeriodYear=? and TBP.FPeriodNumber >= ?)) \r\n");
        sql.append("\t\tAND (TBP.FPeriodYear<? or(TBP.FPeriodYear=? and TBP.FPeriodNumber <= ?)) \r\n");
        sql.append("GROUP BY TBP.FPeriodYear,TBP.FPeriodNumber,TBP.FEndDate \r\n");
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValueId((CoreBaseInfo)partner.getCompany().getAccountPeriodType());
        parameter.addValue(new Integer(partner.getFixCondition().getPeriodYearStart()));
        parameter.addValue(new Integer(partner.getFixCondition().getPeriodYearStart()));
        parameter.addValue(new Integer(partner.getFixCondition().getPeriodNumberStart()));
        parameter.addValue(new Integer(partner.getFixCondition().getPeriodYearEnd()));
        parameter.addValue(new Integer(partner.getFixCondition().getPeriodYearEnd()));
        parameter.addValue(new Integer(partner.getFixCondition().getPeriodNumberEnd()));
        return partner.executeSql(sql.toString(), parameter);
    }

    protected boolean insertStartBalance(Map startBalance, ReportPartner partner) throws BOSException, EASBizException {
        ArrayList columnList = this.getBigDecimalColumns(partner);
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append("\t(FDate,");
        for (GLReportColumnarJournalColumnInfo column : columnList) {
            sql.append(column.getColumnName());
            sql.append(",");
        }
        sql.append("\r\n");
        sql.append("\t FLineType,FPeriodYear,FPeriodNumber) \r\n");
        sql.append("VALUES (?,");
        for (int i = 0; i < columnList.size(); ++i) {
            sql.append("?,");
        }
        sql.append("?,?,?) \r\n");
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValue(startBalance.get("FBeginDate"));
        for (GLReportColumnarJournalColumnInfo column : columnList) {
            BigDecimal value = (BigDecimal)startBalance.get(column.getColumnName() + "B");
            if (value == null) {
                value = ZERO;
            }
            parameter.addValue(value);
        }
        Integer periodNumber = (Integer)startBalance.get("FPeriodNumber");
        parameter.addValue(new Integer(periodNumber == 1 ? -3 : -2));
        parameter.addValue(startBalance.get("FPeriodYear"));
        parameter.addValue(startBalance.get("FPeriodNumber"));
        return partner.executeSql(sql.toString(), parameter);
    }

    protected boolean insertVoucher(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionColumnarJournal condition = (ReportConditionColumnarJournal)partner.getFixCondition();
        ArrayList columnList = this.getBigDecimalColumns(partner);
        if (condition == null) {
            throw new ReportException(ReportException.CONDITION_EMPTY);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append("\t(FDate, FVoucherNumber, FDescription,  \r\n");
        for (GLReportColumnarJournalColumnInfo column : columnList) {
            sql.append(column.getColumnName());
            sql.append(",");
        }
        sql.append("\tFLineType,FVoucherID, FPeriodYear, FPeriodNumber) \r\n");
        sql.append("SELECT TV.FBookedDate,TVT.FName");
        sql.append(partner.getFieldNameExtend());
        sql.append("||' - '|| ISNULL(TV.FNumber,'') FNumber,TVE.FDescription, \r\n");
        for (GLReportColumnarJournalColumnInfo column : columnList) {
            String voucherColumnName = this.getVoucherColumnName(column.getTypeString());
            sql.append("\t(CASE WHEN ");
            if (column.getAccountId() != null) {
                if (column.isAccountLeaf()) {
                    sql.append("TVE.FAccountID = '");
                    sql.append(column.getAccountId());
                    sql.append("' ");
                } else {
                    sql.append(" (");
                    ArrayList childs = column.getChildAccount();
                    for (int i = 0; i < childs.size(); ++i) {
                        if (i > 0) {
                            sql.append(" OR ");
                        }
                        sql.append("TVE.FAccountID = '");
                        sql.append(childs.get(i));
                        sql.append("'");
                    }
                    sql.append(")");
                }
            }
            if (column.getCurrencyId() != null) {
                if (column.getAccountId() != null) {
                    sql.append(" AND ");
                }
                sql.append(" TVE.FCurrencyID = '");
                sql.append(column.getCurrencyId());
                sql.append("' ");
            }
            sql.append(" THEN ");
            if (column.getAccountId() == null) {
                sql.append(" (CASE WHEN TVE.FEntryDC=");
                sql.append(1);
                sql.append(" THEN ");
                if (column.getBalanceDC() == BalanceDirectionEnum.DEBIT) {
                    sql.append(voucherColumnName);
                    sql.append(" ELSE ");
                    sql.append(" 0 ");
                } else {
                    sql.append(" 0 ");
                    sql.append(" ELSE ");
                    sql.append(voucherColumnName);
                }
                sql.append("  END) ");
            } else {
                sql.append(" (CASE WHEN TVE.FEntryDC=");
                sql.append(1);
                sql.append(" THEN ");
                sql.append(voucherColumnName);
                sql.append(" ELSE ");
                sql.append(" -1 * ");
                sql.append(voucherColumnName);
                sql.append("  END) ");
            }
            sql.append(" ELSE 0 END) ");
            sql.append(column.getColumnName());
            sql.append(" ,\r\n");
        }
        sql.append("\t0 FLineType,TV.FID FVoucherID, \r\n");
        sql.append("\tTP.FPeriodYear  FPeriodYear,TP.FPeriodNumber FPeriodNumber \r\n");
        sql.append("FROM T_GL_Voucher TV \r\n");
        sql.append("\tINNER JOIN T_BD_VoucherTypes TVT \r\n ");
        sql.append("\tON TV.FVoucherTypeID = TVT.FID \r\n");
        sql.append("\tINNER JOIN T_GL_VoucherEntry TVE \r\n");
        sql.append("\tON TV.FID = TVE.FBillID \r\n");
        sql.append("\tINNER JOIN T_BD_Period TP \r\n");
        sql.append("\tON TV.FPeriodID = TP.FID \r\n");
        sql.append("WHERE TV.FCompanyID = ? AND \r\n");
        sql.append("    (TV.FBizStatus =   ");
        sql.append(5);
        sql.append("  \r\n");
        if (condition.getOptionPosting()) {
            sql.append("    OR TV.FBizStatus =   ");
            sql.append(1);
            sql.append(" \r\n");
            sql.append("    OR TV.FBizStatus =   ");
            sql.append(3);
            sql.append("  \r\n");
        }
        sql.append(") AND \r\n");
        sql.append("\tTVE.FAccountID IN (");
        sql.append(this.getChildAccountIdsFromScheme(partner));
        sql.append(") AND \r\n");
        sql.append("\tTVE.FCurrencyID IN (");
        sql.append(this.getCurrencyIdsFromScheme(partner));
        sql.append(") AND \r\n");
        sql.append("\t(TP.FPeriodYear>? or (TP.FPeriodYear=? and TP.FPeriodNumber >= ?) ) AND \r\n");
        sql.append("\t(TP.FPeriodYear<? or (TP.FPeriodYear=? and TP.FPeriodNumber <= ?) ) AND \r\n");
        sql.append("\tTP.FTypeID = ? \r\n");
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValueChar(partner.getCompanyId());
        parameter.addValue(new Integer(condition.getPeriodYearStart()));
        parameter.addValue(new Integer(condition.getPeriodYearStart()));
        parameter.addValue(new Integer(condition.getPeriodNumberStart()));
        parameter.addValue(new Integer(condition.getPeriodYearEnd()));
        parameter.addValue(new Integer(condition.getPeriodYearEnd()));
        parameter.addValue(new Integer(condition.getPeriodNumberEnd()));
        parameter.addValueId((CoreBaseInfo)partner.getCompany().getAccountPeriodType());
        return partner.executeSql(parameter.getSqlWithParameters(sql.toString()), null);
    }

    private String getVoucherColumnName(String typeString) throws BOSException, EASBizException {
        if (TYPE_LOCAL.equals(typeString)) {
            return "FLocalAmount";
        }
        if (TYPE_RPT.equals(typeString)) {
            return "FReportingAmount";
        }
        if (TYPE_FOR.equals(typeString)) {
            return "FOriginalAmount";
        }
        if (TYPE_QTY.equals(typeString)) {
            return "FStandardQuantity";
        }
        throw new ReportException(ReportException.FUNCTION_USE_WRONG);
    }

    protected boolean insertYearStart(Connection cn, String tempTableName, ReportPartner partner) throws BOSException, EASBizException {
        throw new ReportException(ReportException.TODO);
    }

    protected boolean insertYearSum(Map startBalance, ReportPartner partner) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append("\t(FDate,  \r\n");
        for (GLReportColumnarJournalColumnInfo column : this.getBigDecimalColumns(partner)) {
            sql.append(column.getColumnName());
            sql.append(" , \r\n");
        }
        sql.append("\tFLineType,FPeriodYear, FPeriodNumber) \r\n");
        sql.append("SELECT MAX(TP1.FDate) FDate, \r\n");
        for (GLReportColumnarJournalColumnInfo column : this.getBigDecimalColumns(partner)) {
            sql.append("\tSUM(ISNULL(TP2.");
            sql.append(column.getColumnName());
            sql.append(",0) ) +CASE WHEN TP1.FPeriodYear=? THEN ? ELSE 0 END ");
            sql.append(column.getColumnName());
            sql.append(" , \r\n");
        }
        sql.append("\t4 FLineType,TP1.FPeriodYear, TP1.FPeriodNumber \r\n");
        sql.append("FROM ");
        sql.append(partner.getTempTableName());
        sql.append(" TP1 \r\n");
        sql.append("\tINNER JOIN ");
        sql.append(partner.getTempTableName());
        sql.append(" TP2  \r\n");
        sql.append("\tON TP1.FPeriodYear = TP2.FPeriodYear \r\n");
        sql.append("\tAND TP1.FLineType = TP2.FLineType \r\n");
        sql.append("WHERE TP1.FLineType = 3 AND \r\n");
        sql.append("\tTP1.FPeriodNumber >= TP2.FPeriodNumber \r\n");
        sql.append("GROUP BY TP1.FPeriodYear,TP1.FPeriodNumber \r\n");
        SqlParameter2 parameter = new SqlParameter2();
        Integer periodYear = (Integer)startBalance.get("FPeriodYear");
        for (GLReportColumnarJournalColumnInfo column : this.getBigDecimalColumns(partner)) {
            parameter.addValue(periodYear);
            BigDecimal value = (BigDecimal)startBalance.get(column.getColumnName() + "Y");
            if (value == null) {
                value = ZERO;
            }
            parameter.addValue(value);
        }
        return partner.executeSql(parameter.getSqlWithParameters(sql.toString()), null);
    }

    private BigDecimal getBigDecimalForDC(BigDecimal value, BalanceDirectionEnum dc) {
        if (value == null) {
            return null;
        }
        return dc == BalanceDirectionEnum.DEBIT ? value : value.negate();
    }

    protected CompanyOrgUnitInfo getInitCompany(ReportPartner partner) throws BOSException, EASBizException {
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        return partner.getCompany();
    }
}

