/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BalanceOrientionTag;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionGeneralLedgerAssist;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.RptTreeNodeInfo;
import com.kingdee.eas.fi.gl.app.AbstractGLReportGeneralLedgerAssistControllerBean;
import com.kingdee.eas.fi.gl.app.ReportPartner;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.common.SqlParameter2;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLReportGeneralLedgerAssistControllerBean
extends AbstractGLReportGeneralLedgerAssistControllerBean {
    private static final long serialVersionUID = -1883018508521081985L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLReportGeneralLedgerAssistControllerBean");

    @Override
    protected Object[] getLineObjects(ReportPartner partner, ResultSet rs) throws SQLException, BOSException, EASBizException {
        BigDecimal endBalanceRpt;
        BigDecimal endBalanceLocal;
        BigDecimal beginBalanceRpt;
        String maxChar = GlUtils.getMaxChar(partner.getContext());
        ReportConditionGeneralLedgerAssist condition = (ReportConditionGeneralLedgerAssist)partner.getFixCondition();
        String strAssistItemId = condition.getAssistItemId();
        String asstItemId = rs.getString("FAsstItemId");
        String asstItemName = rs.getString("FAsstItemName");
        String strNumber = asstItemId;
        String strName = asstItemName;
        if (strAssistItemId.indexOf("','") >= 0) {
            if (asstItemId.equals(maxChar)) {
                strNumber = "";
                strName = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"Total", (Locale)partner.getContext().getLocale());
            }
        } else if (strAssistItemId.length() == 44 || strAssistItemId.length() == 28 || strAssistItemId.length() == 16) {
            IObjectValue iObjectValue = this.getItemDetail(partner);
            if (partner.getAsstActTypeInfo().isUseLongNumber() || iObjectValue instanceof GeneralAsstActTypeInfo) {
                strNumber = partner.isRptShowLongNumberFromGeneral() && iObjectValue.get("longNumber") != null ? ((String)iObjectValue.get("longNumber")).replaceAll("!", ".") : (String)iObjectValue.get("number");
                strName = partner.isRptShowLongNameFromGeneral() && iObjectValue instanceof TreeBaseInfo && ((TreeBaseInfo)iObjectValue).getDisplayName() != null ? ((TreeBaseInfo)iObjectValue).getDisplayName() : (String)iObjectValue.get("name");
            } else {
                strNumber = (String)iObjectValue.get("number");
                strName = (String)iObjectValue.get("name");
            }
        }
        boolean bEndBalanceOri = partner.isParmBalanceDirSamAsAccount();
        int scaleFor = rs.getInt("FCurrencyPre");
        int scaleLocal = this.getScale(partner, CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString());
        int scaleRpt = this.getScale(partner, CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString());
        int iScaleQuantity = partner.getParmQtyScale();
        int iScalePrice = partner.getParmPriceScale();
        int index = 0;
        BigDecimal ZERO = new BigDecimal("0.0");
        Object[] row = new Object[36];
        row[index++] = strNumber;
        row[index++] = strName;
        row[index++] = rs.getString("FCurrencyID");
        row[index++] = rs.getString("FCurrencyName");
        row[index++] = new Integer(scaleFor);
        String strPeriodNumber = rs.getString("FPeriodNumber");
        String strPeriodYear = rs.getString("FPeriodYear");
        row[index++] = condition.getPeriodYearStart() == condition.getPeriodYearEnd() ? strPeriodNumber.trim() : strPeriodYear.trim() + "." + strPeriodNumber.trim();
        BigDecimal beginBalanceFor = rs.getBigDecimal("FBeginBalanceFor");
        int iDC = rs.getInt("FDC");
        BigDecimal beginBalanceLocal = rs.getBigDecimal("FBeginBalanceLocal");
        BalanceOrientionTag beginBalanceTag = new BalanceOrientionTag();
        beginBalanceTag.setOriention(1);
        String strBeginDC = this.getBalanceDC(partner, beginBalanceFor == null ? beginBalanceLocal : beginBalanceFor, beginBalanceTag, bEndBalanceOri, iDC);
        BigDecimal oriBegin = new BigDecimal(String.valueOf(beginBalanceTag.getOriention()));
        BigDecimal beginQty = rs.getBigDecimal("FBeginQty");
        if (beginQty != null) {
            beginQty = beginQty.multiply(oriBegin);
            beginQty = beginQty.setScale(iScaleQuantity, 4);
        }
        if (beginBalanceFor != null) {
            beginBalanceFor = beginBalanceFor.multiply(oriBegin);
            beginBalanceFor = beginBalanceFor.setScale(scaleFor, 4);
        }
        if (beginBalanceLocal != null) {
            beginBalanceLocal = beginBalanceLocal.multiply(oriBegin);
            beginBalanceLocal = beginBalanceLocal.setScale(scaleLocal, 4);
        }
        if ((beginBalanceRpt = rs.getBigDecimal("FBeginBalanceRpt")) != null) {
            beginBalanceRpt = beginBalanceRpt.multiply(oriBegin);
            beginBalanceRpt = beginBalanceRpt.setScale(scaleRpt, 4);
        }
        BigDecimal beginPrice = null;
        if (beginQty != null && beginBalanceFor != null && beginQty.compareTo(ZERO) != 0) {
            beginPrice = beginBalanceFor.divide(beginQty, 4, 6);
            beginPrice = beginPrice.setScale(iScalePrice, 4).abs();
        }
        row[index++] = beginQty;
        row[index++] = beginPrice;
        row[index++] = strBeginDC;
        row[index++] = beginBalanceFor;
        row[index++] = beginBalanceLocal;
        row[index++] = beginBalanceRpt;
        BigDecimal debitQty = rs.getBigDecimal("FDebitQty");
        if (debitQty != null) {
            debitQty = debitQty.setScale(iScaleQuantity, 4);
        }
        row[index++] = debitQty;
        BigDecimal debitFor = rs.getBigDecimal("FDebitFor");
        if (debitFor != null) {
            debitFor = debitFor.setScale(scaleFor, 4);
        }
        row[index++] = debitFor;
        BigDecimal debitLocal = rs.getBigDecimal("FDebitLocal");
        if (debitLocal != null) {
            debitLocal = debitLocal.setScale(scaleLocal, 4);
        }
        row[index++] = debitLocal;
        BigDecimal debitRpt = rs.getBigDecimal("FDebitRpt");
        if (debitRpt != null) {
            debitRpt = debitRpt.setScale(scaleRpt, 4);
        }
        row[index++] = debitRpt;
        BigDecimal creditQty = rs.getBigDecimal("FCreditQty");
        if (creditQty != null) {
            creditQty = creditQty.setScale(iScaleQuantity, 4);
        }
        row[index++] = creditQty;
        BigDecimal creditFor = rs.getBigDecimal("FCreditFor");
        if (creditFor != null) {
            creditFor = creditFor.setScale(scaleFor, 4);
        }
        row[index++] = creditFor;
        BigDecimal creditLocal = rs.getBigDecimal("FCreditLocal");
        if (creditFor != null) {
            creditLocal = creditLocal.setScale(scaleLocal, 4);
        }
        row[index++] = creditLocal;
        BigDecimal creditRpt = rs.getBigDecimal("FCreditRpt");
        if (creditRpt != null) {
            creditRpt = creditRpt.setScale(scaleRpt, 4);
        }
        row[index++] = creditRpt;
        BigDecimal yearDebitQty = rs.getBigDecimal("FYearDebitQty");
        if (yearDebitQty != null) {
            yearDebitQty = yearDebitQty.setScale(iScaleQuantity, 4);
        }
        row[index++] = yearDebitQty;
        BigDecimal yearDebitFor = rs.getBigDecimal("FYearDebitFor");
        if (yearDebitFor != null) {
            yearDebitFor = yearDebitFor.setScale(scaleFor, 4);
        }
        row[index++] = yearDebitFor;
        BigDecimal yearDebitLocal = rs.getBigDecimal("FYearDebitLocal");
        if (yearDebitLocal != null) {
            yearDebitLocal = yearDebitLocal.setScale(scaleLocal, 4);
        }
        row[index++] = yearDebitLocal;
        BigDecimal yearDebitRpt = rs.getBigDecimal("FYearDebitRpt");
        if (yearDebitRpt != null) {
            yearDebitRpt = yearDebitRpt.setScale(scaleRpt, 4);
        }
        row[index++] = yearDebitRpt;
        BigDecimal yearCreditQty = rs.getBigDecimal("FYearCreditQty");
        if (yearCreditQty != null) {
            yearCreditQty = yearCreditQty.setScale(iScaleQuantity, 4);
        }
        row[index++] = yearCreditQty;
        BigDecimal yearCreditFor = rs.getBigDecimal("FYearCreditFor");
        if (yearCreditFor != null) {
            yearCreditFor = yearCreditFor.setScale(scaleFor, 4);
        }
        row[index++] = yearCreditFor;
        BigDecimal yearCreditLocal = rs.getBigDecimal("FYearCreditLocal");
        if (yearCreditLocal != null) {
            yearCreditLocal = yearCreditLocal.setScale(scaleLocal, 4);
        }
        row[index++] = yearCreditLocal;
        BigDecimal yearCreditRpt = rs.getBigDecimal("FYearCreditRpt");
        if (yearCreditRpt != null) {
            yearCreditRpt = yearCreditRpt.setScale(scaleRpt, 4);
        }
        row[index++] = yearCreditRpt;
        BigDecimal endBalanceFor = rs.getBigDecimal("FEndBalanceFor");
        BalanceOrientionTag endBalanceTag = new BalanceOrientionTag();
        beginBalanceTag.setOriention(1);
        String strEndDC = this.getBalanceDC(partner, endBalanceFor, endBalanceTag, bEndBalanceOri, iDC);
        BigDecimal oriEnd = new BigDecimal(String.valueOf(endBalanceTag.getOriention()));
        BigDecimal endQty = rs.getBigDecimal("FEndQty");
        if (endQty != null) {
            endQty = endQty.multiply(oriEnd);
            endQty = endQty.setScale(iScaleQuantity, 4);
        }
        if (endBalanceFor != null) {
            endBalanceFor = endBalanceFor.multiply(oriEnd);
            endBalanceFor = endBalanceFor.setScale(scaleFor, 4);
        }
        if ((endBalanceLocal = rs.getBigDecimal("FEndBalanceLocal")) != null) {
            endBalanceLocal = endBalanceLocal.multiply(oriEnd);
            endBalanceLocal = endBalanceLocal.setScale(scaleLocal, 4);
        }
        if ((endBalanceRpt = rs.getBigDecimal("FEndBalanceRpt")) != null) {
            endBalanceRpt = endBalanceRpt.multiply(oriEnd);
            endBalanceRpt = endBalanceRpt.setScale(scaleRpt, 4);
        }
        BigDecimal endPrice = null;
        if (endQty != null && endBalanceFor != null && endQty.compareTo(ZERO) != 0) {
            endPrice = endBalanceFor.divide(endQty, 4, 6);
            endPrice = endPrice.setScale(iScalePrice, 4).abs();
        }
        row[index++] = endQty;
        row[index++] = endPrice;
        row[index++] = strEndDC;
        row[index++] = endBalanceFor;
        row[index++] = endBalanceLocal;
        row[index++] = endBalanceRpt;
        row[index++] = strAssistItemId.indexOf("','") >= 0 && asstItemId.equals(maxChar) ? ReportResultInfo.LINE_TOTAL : ReportResultInfo.LINE_NORMAL;
        row[index++] = rs.getString("FAccountID");
        return row;
    }

    private IObjectValue getItemDetail(ReportPartner partner) throws BOSException {
        Context ctx = partner.getContext();
        ReportConditionGeneralLedgerAssist condition = (ReportConditionGeneralLedgerAssist)partner.getFixCondition();
        String strAsstItemid = condition.getAssistItemId();
        BOSUuid id = BOSUuid.read((String)strAsstItemid);
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectValue iObjectValue = iDynamicObject.getValue(id.getType(), (IObjectPK)new ObjectUuidPK(id));
        return iObjectValue;
    }

    @Override
    protected Collection executeSqlForData(Context ctx, ReportPartner partner) throws BOSException, EASBizException {
        String sqlSelect;
        String sqlFromAndWhere = this.getSqlForDataFromAndWhere(partner);
        if (sqlFromAndWhere == null) {
            return new ArrayList();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Select ");
        String dbTypeName = (String)ctx.get((Object)"dbType");
        int dbType = DbType.getValue((String)dbTypeName);
        if (this.useVirtualMode() && !this.useDialect() && partner.getLineCount() > 0) {
            sql.append("Top ");
            sql.append(partner.getStartIndex() + partner.getLineCount());
            sql.append(" \r\n");
        }
        if ((sqlSelect = this.getSqlForDataSelect(partner)) == null || sqlSelect.length() == 0) {
            throw new ReportException(ReportException.SQL_SELECT_EMPTY);
        }
        sql.append(sqlSelect);
        sql.append("\r\n");
        sql.append(sqlFromAndWhere);
        sql.append("\r\n");
        ReportConditionGeneralLedgerAssist condition = (ReportConditionGeneralLedgerAssist)partner.getFixCondition();
        if (partner.getCurrency() == null && condition.isShowTotal()) {
            sql.append(" union all ");
            String toDecimal = "NULL";
            if (dbType == 1) {
                toDecimal = "to_decimal(null)";
            }
            sql.append(" select FAsstItemLongId, FAsstItemId,FAsstItemName,T_Main.FAccountID  FAccountID,\r\n");
            sql.append(" TA.FDC FDC, \r\n");
            sql.append(" TA.FNumber  FNumber,\r\n");
            sql.append(" TA.FName").append(partner.getFieldNameExtend()).append(" FName, \r\n");
            sql.append("'', '").append(GlUtils.getMaxChar(partner.getContext())).append("' FCurrencyNumber, ");
            sql.append("  N'").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"subtotal", (Locale)partner.getContext().getLocale())).append("' FCurrencyName,\r\n");
            sql.append("  0 FCurrencyPre, ");
            sql.append(" T_Main.FPeriodYear FPeriodYear, \r\n");
            sql.append(" T_Main.FPeriodNumber FPeriodNumber,\r\n");
            sql.append(" T_Main.FBeginQty FBeginQty,\r\n");
            sql.append(toDecimal + "  FBeginBalanceFor,\r\n");
            sql.append(" T_Main.FBeginBalanceLocal FBeginBalanceLocal,\r\n");
            sql.append(" T_Main.FBeginBalanceRpt FBeginBalanceRpt,\r\n");
            sql.append(" T_Main.FDebitQty FDebitQty, \r\n");
            sql.append(toDecimal + "   FDebitFor, \r\n");
            sql.append(" T_Main.FDebitLocal FDebitLocal, \r\n");
            sql.append(" T_Main.FDebitRpt FDebitRpt, \r\n");
            sql.append(" T_Main.FCreditQty FCreditQty,\r\n");
            sql.append(toDecimal + "   FCreditFor,\r\n");
            sql.append(" T_Main.FCreditLocal FCreditLocal,\r\n");
            sql.append(" T_Main.FCreditRpt FCreditRpt,\r\n");
            sql.append(" T_Main.FYearDebitQty FYearDebitQty, \r\n");
            sql.append(toDecimal + "   FYearDebitFor, \r\n");
            sql.append(" T_Main.FYearDebitLocal FYearDebitLocal, \r\n");
            sql.append(" T_Main.FYearDebitRpt FYearDebitRpt, \r\n");
            sql.append(" T_Main.FYearCreditQty FYearCreditQty, \r\n");
            sql.append(toDecimal + "   FYearCreditFor, \r\n");
            sql.append(" T_Main.FYearCreditLocal FYearCreditLocal, \r\n");
            sql.append(" T_Main.FYearCreditRpt FYearCreditRpt, \r\n");
            sql.append(" T_Main.FEndQty FEndQty,\r\n");
            sql.append(toDecimal + "   FEndBalanceFor,\r\n");
            sql.append(" T_Main.FEndBalanceLocal FEndBalanceLocal,\r\n");
            sql.append(" T_Main.FEndBalanceRpt FEndBalanceRpt \r\n");
            String maxChar = GlUtils.getMaxChar(partner.getContext());
            String strAssistItemId = condition.getAssistItemId();
            StringBuffer sqlFrom = new StringBuffer();
            sqlFrom.append("  FROM \r\n");
            sqlFrom.append(" (SELECT '").append(maxChar).append("'  FAsstItemLongId,'");
            sqlFrom.append(maxChar).append("'  FAsstItemId,'").append(maxChar).append("' FAsstItemName,");
            sqlFrom.append("     T1.FAccountID  FAccountID,\r\n");
            sqlFrom.append("     T1.FPeriodYear FPeriodYear, \r\n");
            sqlFrom.append("     T1.FPeriodNumber FPeriodNumber,\r\n");
            sqlFrom.append("     SUM(T1.FBeginQty) FBeginQty,\r\n");
            sqlFrom.append("     SUM(T1.FBeginBalanceLocal) FBeginBalanceLocal,\r\n");
            sqlFrom.append("     SUM(T1.FBeginBalanceRpt) FBeginBalanceRpt,\r\n");
            sqlFrom.append("     SUM(T1.FDebitQty) FDebitQty, \r\n");
            sqlFrom.append("     SUM(T1.FDebitLocal) FDebitLocal, \r\n");
            sqlFrom.append("     SUM(T1.FDebitRpt) FDebitRpt, \r\n");
            sqlFrom.append("     SUM(T1.FCreditQty) FCreditQty,\r\n");
            sqlFrom.append("     SUM(T1.FCreditLocal) FCreditLocal,\r\n");
            sqlFrom.append("     SUM(T1.FCreditRpt) FCreditRpt,\r\n");
            sqlFrom.append("     SUM(T1.FYearDebitQty) FYearDebitQty, \r\n");
            sqlFrom.append("     SUM(T1.FYearDebitLocal) FYearDebitLocal, \r\n");
            sqlFrom.append("     SUM(T1.FYearDebitRpt) FYearDebitRpt, \r\n");
            sqlFrom.append("     SUM(T1.FYearCreditQty) FYearCreditQty, \r\n");
            sqlFrom.append("     SUM(T1.FYearCreditLocal) FYearCreditLocal, \r\n");
            sqlFrom.append("     SUM(T1.FYearCreditRpt) FYearCreditRpt, \r\n");
            sqlFrom.append("     SUM(T1.FEndQty) FEndQty,\r\n");
            sqlFrom.append("     SUM(T1.FEndBalanceLocal) FEndBalanceLocal,\r\n");
            sqlFrom.append("     SUM(T1.FEndBalanceRpt) FEndBalanceRpt \r\n");
            sqlFrom.append("  FROM ");
            sqlFrom.append(partner.getTempTableName());
            sqlFrom.append("     T1 \r\n");
            sqlFrom.append("  GROUP BY FAccountID,FPeriodYear,FPeriodNumber \r\n");
            if (strAssistItemId.split(",").length > 1) {
                Map map = condition.getAssistItem();
                for (RptTreeNodeInfo treeNodeInfo : map.keySet()) {
                    sqlFrom.append(" union all SELECT '" + treeNodeInfo.getLongNumber() + "' FAsstItemLongId,'");
                    sqlFrom.append(treeNodeInfo.getNumber() + "' FAsstItemId,'");
                    sqlFrom.append(treeNodeInfo.getName());
                    sqlFrom.append("' FAsstItemName,\r\n");
                    sqlFrom.append("     FAccountID,\r\n");
                    sqlFrom.append("     FPeriodYear, \r\n");
                    sqlFrom.append("     FPeriodNumber,\r\n");
                    sqlFrom.append("     SUM(FBeginQty) FBeginQty,\r\n");
                    sqlFrom.append("     SUM(FBeginBalanceLocal) FBeginBalanceLocal,\r\n");
                    sqlFrom.append("     SUM(FBeginBalanceRpt) FBeginBalanceRpt,\r\n");
                    sqlFrom.append("     SUM(FDebitQty) FDebitQty, \r\n");
                    sqlFrom.append("     SUM(FDebitLocal) FDebitLocal, \r\n");
                    sqlFrom.append("     SUM(FDebitRpt) FDebitRpt, \r\n");
                    sqlFrom.append("     SUM(FCreditQty) FCreditQty,\r\n");
                    sqlFrom.append("     SUM(FCreditLocal) FCreditLocal,\r\n");
                    sqlFrom.append("     SUM(FCreditRpt) FCreditRpt,\r\n");
                    sqlFrom.append("     SUM(FYearDebitQty) FYearDebitQty, \r\n");
                    sqlFrom.append("     SUM(FYearDebitLocal) FYearDebitLocal, \r\n");
                    sqlFrom.append("     SUM(FYearDebitRpt) FYearDebitRpt, \r\n");
                    sqlFrom.append("     SUM(FYearCreditQty) FYearCreditQty, \r\n");
                    sqlFrom.append("     SUM(FYearCreditLocal) FYearCreditLocal, \r\n");
                    sqlFrom.append("     SUM(FYearCreditRpt) FYearCreditRpt, \r\n");
                    sqlFrom.append("     SUM(FEndQty) FEndQty,\r\n");
                    sqlFrom.append("     SUM(FEndBalanceLocal) FEndBalanceLocal,\r\n");
                    sqlFrom.append("     SUM(FEndBalanceRpt) FEndBalanceRpt \r\n");
                    sqlFrom.append(" FROM ");
                    sqlFrom.append(partner.getTempTableName());
                    sqlFrom.append(" where FAsstItemId in ('");
                    sqlFrom.append(map.get(treeNodeInfo));
                    sqlFrom.append("') \r\n");
                    sqlFrom.append("\tGROUP BY FAccountID ,FPeriodYear,FPeriodNumber\r\n");
                }
            }
            sqlFrom.append("    ) T_Main \r\n");
            sqlFrom.append("  INNER JOIN T_BD_AccountView TA ON T_Main.FAccountId = TA.FID \r\n");
            this.joinAuthoritySql(partner, sqlFrom);
            sql.append(sqlFrom);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.useDialect() && dbType != 2 ? "/*dialect*/" : "").append("select * from (").append(sql).append(") t ");
        String order = this.getSqlForDataOrder(partner);
        if (order != null && order.length() > 0) {
            sb.append(order);
        }
        return this.getDataFormSQL(ctx, partner, sb.toString());
    }

    @Override
    protected String getSqlForDataSelect(ReportPartner partner) throws BOSException, EASBizException {
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append(" FAsstItemLongId,FAsstItemId,FAsstItemName,T_Main.FAccountID  FAccountID,\r\n");
        sqlSelect.append(" TA.FDC FDC, \r\n");
        sqlSelect.append(" TA.FNumber  FNumber,\r\n");
        sqlSelect.append(" TA.FName").append(partner.getFieldNameExtend()).append(" FName, \r\n");
        sqlSelect.append(" CY.FID  FCurrencyID, \r\n");
        sqlSelect.append(" CY.FNumber  FCurrencyNumber, \r\n");
        sqlSelect.append(" CY.FName").append(partner.getFieldNameExtend()).append(" FCurrencyName, \r\n");
        sqlSelect.append(" CY.FPrecision  FCurrencyPre, \r\n");
        sqlSelect.append(" T_Main.FPeriodYear FPeriodYear, \r\n");
        sqlSelect.append(" T_Main.FPeriodNumber FPeriodNumber,\r\n");
        sqlSelect.append(" T_Main.FBeginQty FBeginQty,\r\n");
        sqlSelect.append(" T_Main.FBeginBalanceFor FBeginBalanceFor,\r\n");
        sqlSelect.append(" T_Main.FBeginBalanceLocal FBeginBalanceLocal,\r\n");
        sqlSelect.append(" T_Main.FBeginBalanceRpt FBeginBalanceRpt,\r\n");
        sqlSelect.append(" T_Main.FDebitQty FDebitQty, \r\n");
        sqlSelect.append(" T_Main.FDebitFor FDebitFor, \r\n");
        sqlSelect.append(" T_Main.FDebitLocal FDebitLocal, \r\n");
        sqlSelect.append(" T_Main.FDebitRpt FDebitRpt, \r\n");
        sqlSelect.append(" T_Main.FCreditQty FCreditQty,\r\n");
        sqlSelect.append(" T_Main.FCreditFor FCreditFor,\r\n");
        sqlSelect.append(" T_Main.FCreditLocal FCreditLocal,\r\n");
        sqlSelect.append(" T_Main.FCreditRpt FCreditRpt,\r\n");
        sqlSelect.append(" T_Main.FYearDebitQty FYearDebitQty, \r\n");
        sqlSelect.append(" T_Main.FYearDebitFor FYearDebitFor, \r\n");
        sqlSelect.append(" T_Main.FYearDebitLocal FYearDebitLocal, \r\n");
        sqlSelect.append(" T_Main.FYearDebitRpt FYearDebitRpt, \r\n");
        sqlSelect.append(" T_Main.FYearCreditQty FYearCreditQty, \r\n");
        sqlSelect.append(" T_Main.FYearCreditFor FYearCreditFor, \r\n");
        sqlSelect.append(" T_Main.FYearCreditLocal FYearCreditLocal, \r\n");
        sqlSelect.append(" T_Main.FYearCreditRpt FYearCreditRpt, \r\n");
        sqlSelect.append(" T_Main.FEndQty FEndQty,\r\n");
        sqlSelect.append(" T_Main.FEndBalanceFor FEndBalanceFor,\r\n");
        sqlSelect.append(" T_Main.FEndBalanceLocal FEndBalanceLocal,\r\n");
        sqlSelect.append(" T_Main.FEndBalanceRpt FEndBalanceRpt \r\n");
        return sqlSelect.toString();
    }

    @Override
    protected String getSqlForDataFrom(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionGeneralLedgerAssist condition = (ReportConditionGeneralLedgerAssist)partner.getFixCondition();
        String maxChar = GlUtils.getMaxChar(partner.getContext());
        String strAssistItemId = condition.getAssistItemId();
        StringBuffer sqlFrom = new StringBuffer();
        sqlFrom.append("  FROM \r\n");
        sqlFrom.append(" (SELECT '").append(maxChar).append("'  FAsstItemLongId,'").append(maxChar);
        sqlFrom.append("'  FAsstItemId,'").append(maxChar).append("' FAsstItemName,");
        sqlFrom.append("     T1.FAccountID  FAccountID,\r\n");
        sqlFrom.append("     T1.FCurrencyID  FCurrencyID, \r\n");
        sqlFrom.append("     T1.FPeriodYear FPeriodYear, \r\n");
        sqlFrom.append("     T1.FPeriodNumber FPeriodNumber,\r\n");
        sqlFrom.append("     SUM(T1.FBeginQty) FBeginQty,\r\n");
        sqlFrom.append("     SUM(T1.FBeginBalanceFor) FBeginBalanceFor,\r\n");
        sqlFrom.append("     SUM(T1.FBeginBalanceLocal) FBeginBalanceLocal,\r\n");
        sqlFrom.append("     SUM(T1.FBeginBalanceRpt) FBeginBalanceRpt,\r\n");
        sqlFrom.append("     SUM(T1.FDebitQty) FDebitQty, \r\n");
        sqlFrom.append("     SUM(T1.FDebitFor) FDebitFor, \r\n");
        sqlFrom.append("     SUM(T1.FDebitLocal) FDebitLocal, \r\n");
        sqlFrom.append("     SUM(T1.FDebitRpt) FDebitRpt, \r\n");
        sqlFrom.append("     SUM(T1.FCreditQty) FCreditQty,\r\n");
        sqlFrom.append("     SUM(T1.FCreditFor) FCreditFor,\r\n");
        sqlFrom.append("     SUM(T1.FCreditLocal) FCreditLocal,\r\n");
        sqlFrom.append("     SUM(T1.FCreditRpt) FCreditRpt,\r\n");
        sqlFrom.append("     SUM(T1.FYearDebitQty) FYearDebitQty, \r\n");
        sqlFrom.append("     SUM(T1.FYearDebitFor) FYearDebitFor, \r\n");
        sqlFrom.append("     SUM(T1.FYearDebitLocal) FYearDebitLocal, \r\n");
        sqlFrom.append("     SUM(T1.FYearDebitRpt) FYearDebitRpt, \r\n");
        sqlFrom.append("     SUM(T1.FYearCreditQty) FYearCreditQty, \r\n");
        sqlFrom.append("     SUM(T1.FYearCreditFor) FYearCreditFor, \r\n");
        sqlFrom.append("     SUM(T1.FYearCreditLocal) FYearCreditLocal, \r\n");
        sqlFrom.append("     SUM(T1.FYearCreditRpt) FYearCreditRpt, \r\n");
        sqlFrom.append("     SUM(T1.FEndQty) FEndQty,\r\n");
        sqlFrom.append("     SUM(T1.FEndBalanceFor) FEndBalanceFor,\r\n");
        sqlFrom.append("     SUM(T1.FEndBalanceLocal) FEndBalanceLocal,\r\n");
        sqlFrom.append("     SUM(T1.FEndBalanceRpt) FEndBalanceRpt \r\n");
        sqlFrom.append("  FROM ");
        sqlFrom.append(partner.getTempTableName());
        sqlFrom.append("   T1 \r\n");
        sqlFrom.append("  GROUP BY FAccountID,FCurrencyID,FPeriodYear,FPeriodNumber \r\n");
        if (strAssistItemId.split(",").length > 1) {
            Map map = condition.getAssistItem();
            Iterator iterator = map.keySet().iterator();
            String treeNodeName = "";
            while (iterator.hasNext()) {
                RptTreeNodeInfo treeNodeInfo = (RptTreeNodeInfo)iterator.next();
                sqlFrom.append(" union all SELECT '" + treeNodeInfo.getLongNumber() + "' FAsstItemLongId,'");
                sqlFrom.append(treeNodeInfo.getNumber() + "' FAsstItemId,'");
                treeNodeName = treeNodeInfo.getName();
                if (treeNodeName.indexOf("'") != -1) {
                    treeNodeName = GLReportGeneralLedgerAssistControllerBean.getTreeNodeNameWithESC(treeNodeName);
                }
                sqlFrom.append(treeNodeName);
                sqlFrom.append("' FAsstItemName,\r\n");
                sqlFrom.append("     FAccountID,\r\n");
                sqlFrom.append("     FCurrencyID, \r\n");
                sqlFrom.append("     FPeriodYear, \r\n");
                sqlFrom.append("     FPeriodNumber,\r\n");
                sqlFrom.append("     SUM(FBeginQty) FBeginQty,\r\n");
                sqlFrom.append("     SUM(FBeginBalanceFor) FBeginBalanceFor,\r\n");
                sqlFrom.append("     SUM(FBeginBalanceLocal) FBeginBalanceLocal,\r\n");
                sqlFrom.append("     SUM(FBeginBalanceRpt) FBeginBalanceRpt,\r\n");
                sqlFrom.append("     SUM(FDebitQty) FDebitQty, \r\n");
                sqlFrom.append("     SUM(FDebitFor) FDebitFor, \r\n");
                sqlFrom.append("     SUM(FDebitLocal) FDebitLocal, \r\n");
                sqlFrom.append("     SUM(FDebitRpt) FDebitRpt, \r\n");
                sqlFrom.append("     SUM(FCreditQty) FCreditQty,\r\n");
                sqlFrom.append("     SUM(FCreditFor) FCreditFor,\r\n");
                sqlFrom.append("     SUM(FCreditLocal) FCreditLocal,\r\n");
                sqlFrom.append("     SUM(FCreditRpt) FCreditRpt,\r\n");
                sqlFrom.append("     SUM(FYearDebitQty) FYearDebitQty, \r\n");
                sqlFrom.append("     SUM(FYearDebitFor) FYearDebitFor, \r\n");
                sqlFrom.append("     SUM(FYearDebitLocal) FYearDebitLocal, \r\n");
                sqlFrom.append("     SUM(FYearDebitRpt) FYearDebitRpt, \r\n");
                sqlFrom.append("     SUM(FYearCreditQty) FYearCreditQty, \r\n");
                sqlFrom.append("     SUM(FYearCreditFor) FYearCreditFor, \r\n");
                sqlFrom.append("     SUM(FYearCreditLocal) FYearCreditLocal, \r\n");
                sqlFrom.append("     SUM(FYearCreditRpt) FYearCreditRpt, \r\n");
                sqlFrom.append("     SUM(FEndQty) FEndQty,\r\n");
                sqlFrom.append("     SUM(FEndBalanceFor) FEndBalanceFor,\r\n");
                sqlFrom.append("     SUM(FEndBalanceLocal) FEndBalanceLocal,\r\n");
                sqlFrom.append("     SUM(FEndBalanceRpt) FEndBalanceRpt \r\n");
                sqlFrom.append(" FROM ");
                sqlFrom.append(partner.getTempTableName());
                sqlFrom.append(" where FAsstItemId in ('");
                sqlFrom.append(map.get(treeNodeInfo));
                sqlFrom.append("') \r\n");
                sqlFrom.append("\tGROUP BY FAccountID ,FCurrencyID ,FPeriodYear,FPeriodNumber\r\n");
            }
        }
        sqlFrom.append("    ) T_Main \r\n");
        sqlFrom.append("  INNER JOIN T_BD_AccountView TA ON T_Main.FAccountId = TA.FID \r\n");
        sqlFrom.append("  INNER JOIN T_BD_Currency CY ON T_Main.FCurrencyID = CY.FID \r\n");
        return sqlFrom.toString();
    }

    private static String getTreeNodeNameWithESC(String treeNodeName) {
        String[] splits = treeNodeName.split("'");
        StringBuffer sb = new StringBuffer();
        int splitsLength = splits.length;
        for (int i = 0; i < splitsLength; ++i) {
            sb.append(splits[i]);
            if (i == splitsLength - 1) continue;
            sb.append("''");
        }
        return sb.toString();
    }

    @Override
    protected String getSqlForDataWhere(ReportPartner partner) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String getSqlForDataOrder(ReportPartner partner) throws BOSException, EASBizException {
        return "Order By FAsstItemLongId,FNumber,FPeriodYear,FPeriodNumber,FCurrencyNumber";
    }

    @Override
    protected String getReportName() {
        return "GLGeneralLedgerAssist";
    }

    @Override
    protected String getAuthorityName() {
        return "GLGeneralLedgerAssist";
    }

    protected String getQueryName() {
        return "com.kingdee.eas.fi.gl.app.GLReportGeneralLedgerQuery";
    }

    @Override
    protected ReportTableHeadInfo getDefalutTableHeadInfo(ReportPartner partner) throws BOSException, EASBizException {
        ReportTableHeadInfo head = new ReportTableHeadInfo();
        String[] columnNames = new String[]{"FNumber", "FName", "FCurrencyID", "FCurrencyName", "FCurrencyPre", "FPeriodName", "FBeginQuantity", "FBeginPrice", "FBeginOriention", "FBeginBalanceFor", "FBeginBalanceLocal", "FBeginBalanceRpt", "FDebitQuantity", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQuantity", "FCreditFor", "FCreditLocal", "FCreditRpt", "FYearDebitQuantity", "FYearDebitFor", "FYearDebitLocal", "FYearDebitRpt", "FYearCreditQuantity", "FYearCreditFor", "FYearCreditLocal", "FYearCreditRpt", "FEndBalanceQuantity", "FEndBalancePrice", "FEndBalanceOriention", "FEndBalanceFor", "FEndBalanceLocal", "FEndBalanceRpt"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AsstAcctNumber", "AsstAcctName", "CurrencyName", "CurrencyName", "CurrencyName", "PeriodName", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "Debit", "Debit", "Debit", "Debit", "Credit", "Credit", "Credit", "Credit", "YearDebit", "YearDebit", "YearDebit", "YearDebit", "YearCredit", "YearCredit", "YearCredit", "YearCredit", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd"}, {"AsstAcctNumber", "AsstAcctName", "CurrencyName", "CurrencyName", "CurrencyName", "PeriodName", "Quantity", "Price", "Oriention", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "Price", "Oriention", "LabelFor", "LabelLocal", "LabelRpt"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = null;
        widths = new int[]{80, 80, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, 0, 0, 30, 80, 0, 0, 0, 80, 0, 0, 0, 80, 0, 0, 0, 80, 0, 0, 0, 80, 0, 0, 0, 0, 30, 110, 0, 0};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        head.setAlignments(alignments);
        return head;
    }

    @Override
    protected void doSomethingBeforeReturn(ReportPartner partner, ReportResultInfo result) throws BOSException, EASBizException {
        super.doSomethingBeforeReturn(partner, result);
        if (partner.getStartIndex() == 0) {
            result.getExtendData().put("Account", partner.getAccountViewInfo());
            result.getExtendData().put("AccountShowLongName", partner.isParmAccountShowLongName());
        }
    }

    @Override
    protected void doSomethingBeforeQuery(ReportPartner partner) throws EASBizException, BOSException {
        ReportConditionGeneralLedgerAssist condition = (ReportConditionGeneralLedgerAssist)partner.getFixCondition();
        String strCurrencyInfo = condition.getCurrencyID();
        String strBaseCurrencyInfo = partner.getCompany().getBaseCurrency().getId().toString();
        if (!condition.isAllCurrencyColumnar() && strCurrencyInfo != null) {
            boolean isForCurSelfHelp = partner.isParmForeignCurrencySu();
            boolean isUseReportingCurrency = partner.isParmUseReportCurrency();
            if (!isForCurSelfHelp) {
                if (strCurrencyInfo.trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || strCurrencyInfo.trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString()) || strCurrencyInfo.trim().equals(strBaseCurrencyInfo)) {
                    if (!condition.isOptionShowQuantity()) {
                        this.setBaseReportHead(partner);
                    } else {
                        this.setBaseReportHeadQuantity(partner);
                    }
                } else if (!isUseReportingCurrency) {
                    if (!condition.isOptionShowQuantity()) {
                        this.setForeignHeadExtraGenLocal(partner);
                    } else {
                        this.setForeignHeadExtraGenLocalQuantity(partner);
                    }
                } else if (!condition.isOptionShowQuantity()) {
                    this.setForeignHeadExtraGenLocalReport(partner);
                } else {
                    this.setForeignHeadExtraGenLocalReportQuantity(partner);
                }
            } else if (!condition.isOptionShowQuantity()) {
                this.setBaseReportHead(partner);
            } else {
                this.setBaseReportHeadQuantity(partner);
            }
        }
    }

    private void setForeignHeadExtraGenLocalReportQuantity(ReportPartner partner) throws BOSException, EASBizException {
        ReportTableHeadInfo head = partner.getTableHeadInfo();
        String[] columnNames = new String[]{"FNumber", "FName", "FCurrencyID", "FCurrencyName", "FCurrencyPre", "FPeriodName", "FBeginQuantity", "FBeginPrice", "FBeginOriention", "FBeginBalanceFor", "FBeginBalanceLocal", "FBeginBalanceRpt", "FDebitQuantity", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQuantity", "FCreditFor", "FCreditLocal", "FCreditRpt", "FYearDebitQuantity", "FYearDebitFor", "FYearDebitLocal", "FYearDebitRpt", "FYearCreditQuantity", "FYearCreditFor", "FYearCreditLocal", "FYearCreditRpt", "FEndBalanceQuantity", "FEndBalancePrice", "FEndBalanceOriention", "FEndBalanceFor", "FEndBalanceLocal", "FEndBalanceRpt"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AsstAcctNumber", "AsstAcctName", "CurrencyName", "CurrencyName", "CurrencyName", "PeriodName", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "Debit", "Debit", "Debit", "Debit", "Credit", "Credit", "Credit", "Credit", "YearDebit", "YearDebit", "YearDebit", "YearDebit", "YearCredit", "YearCredit", "YearCredit", "YearCredit", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd"}, {"AsstAcctNumber", "AsstAcctName", "CurrencyName", "CurrencyName", "CurrencyName", "PeriodName", "Quantity", "Price", "Oriention", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "Price", "Oriention", "LabelFor", "LabelLocal", "LabelRpt"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = null;
        widths = new int[]{80, 80, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, 80, 80, 30, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 30, 110, 110, 110};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        head.setAlignments(alignments);
        int[] numberStyleTypes = new int[]{0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, false, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true};
        head.setNeedKilobits(needKilobits);
        int scaleFor = partner.getScaleFor();
        int scaleLocal = partner.getScaleLocal();
        int scaleRpt = partner.getScaleRpt();
        int scaleQty = partner.getParmQtyScale();
        int scalePrice = partner.getParmPriceScale();
        int[] numberScales = new int[]{0, 0, 0, 0, 0, 0, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt};
        head.setNumberScales(numberScales);
    }

    private void setForeignHeadExtraGenLocalReport(ReportPartner partner) throws BOSException, EASBizException {
        ReportTableHeadInfo head = partner.getTableHeadInfo();
        String[] columnNames = new String[]{"FNumber", "FName", "FCurrencyID", "FCurrencyName", "FCurrencyPre", "FPeriodName", "FBeginQuantity", "FBeginPrice", "FBeginOriention", "FBeginBalanceFor", "FBeginBalanceLocal", "FBeginBalanceRpt", "FDebitQuantity", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQuantity", "FCreditFor", "FCreditLocal", "FCreditRpt", "FYearDebitQuantity", "FYearDebitFor", "FYearDebitLocal", "FYearDebitRpt", "FYearCreditQuantity", "FYearCreditFor", "FYearCreditLocal", "FYearCreditRpt", "FEndBalanceQuantity", "FEndBalancePrice", "FEndBalanceOriention", "FEndBalanceFor", "FEndBalanceLocal", "FEndBalanceRpt"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AsstAcctNumber", "AsstAcctName", "CurrencyName", "CurrencyName", "CurrencyName", "PeriodName", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "Debit", "Debit", "Debit", "Debit", "Credit", "Credit", "Credit", "Credit", "YearDebit", "YearDebit", "YearDebit", "YearDebit", "YearCredit", "YearCredit", "YearCredit", "YearCredit", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd"}, {"AsstAcctNumber", "AsstAcctName", "CurrencyName", "CurrencyName", "CurrencyName", "PeriodName", "Quantity", "Price", "Oriention", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "Price", "Oriention", "LabelFor", "LabelLocal", "LabelRpt"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = null;
        widths = new int[]{80, 80, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, -1, -1, 30, 80, 80, 80, -1, 80, 80, 80, -1, 80, 80, 80, -1, 80, 80, 80, -1, 80, 80, 80, -1, -1, 30, 110, 110, 110};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        head.setAlignments(alignments);
        int[] numberStyleTypes = new int[]{0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, false, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true};
        head.setNeedKilobits(needKilobits);
        int scaleFor = partner.getScaleFor();
        int scaleLocal = partner.getScaleLocal();
        int scaleRpt = partner.getScaleRpt();
        int scaleQty = partner.getParmQtyScale();
        int scalePrice = partner.getParmPriceScale();
        int[] numberScales = new int[]{0, 0, 0, 0, 0, 0, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt};
        head.setNumberScales(numberScales);
    }

    private void setForeignHeadExtraGenLocalQuantity(ReportPartner partner) throws BOSException, EASBizException {
        ReportTableHeadInfo head = partner.getTableHeadInfo();
        String[] columnNames = new String[]{"FNumber", "FName", "FCurrencyID", "FCurrencyName", "FCurrencyPre", "FPeriodName", "FBeginQuantity", "FBeginPrice", "FBeginOriention", "FBeginBalanceFor", "FBeginBalanceLocal", "FBeginBalanceRpt", "FDebitQuantity", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQuantity", "FCreditFor", "FCreditLocal", "FCreditRpt", "FYearDebitQuantity", "FYearDebitFor", "FYearDebitLocal", "FYearDebitRpt", "FYearCreditQuantity", "FYearCreditFor", "FYearCreditLocal", "FYearCreditRpt", "FEndBalanceQuantity", "FEndBalancePrice", "FEndBalanceOriention", "FEndBalanceFor", "FEndBalanceLocal", "FEndBalanceRpt"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AsstAcctNumber", "AsstAcctName", "CurrencyName", "CurrencyName", "CurrencyName", "PeriodName", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "Debit", "Debit", "Debit", "Debit", "Credit", "Credit", "Credit", "Credit", "YearDebit", "YearDebit", "YearDebit", "YearDebit", "YearCredit", "YearCredit", "YearCredit", "YearCredit", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd", "CurrencyName", "CurrencyName", "CurrencyName", "BalanceEnd", "BalanceEnd"}, {"AsstAcctNumber", "AsstAcctName", "CurrencyName", "CurrencyName", "CurrencyName", "PeriodName", "Quantity", "Price", "Oriention", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "Price", "Oriention", "LabelFor", "LabelLocal", "LabelRpt"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = null;
        widths = new int[]{80, 80, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, 80, 80, 30, 80, 80, -1, 80, 80, 80, -1, 80, 80, 80, -1, 80, 80, 80, -1, 80, 80, 80, -1, 80, 80, 30, 110, 110, -1};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        head.setAlignments(alignments);
        int[] numberStyleTypes = new int[]{0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, false, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true};
        head.setNeedKilobits(needKilobits);
        int scaleFor = partner.getScaleFor();
        int scaleLocal = partner.getScaleLocal();
        int scaleRpt = partner.getScaleRpt();
        int scaleQty = partner.getParmQtyScale();
        int scalePrice = partner.getParmPriceScale();
        int[] numberScales = new int[]{0, 0, 0, 0, 0, 0, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt};
        head.setNumberScales(numberScales);
    }

    private void setForeignHeadExtraGenLocal(ReportPartner partner) throws BOSException, EASBizException {
        ReportTableHeadInfo head = partner.getTableHeadInfo();
        String[] columnNames = new String[]{"FNumber", "FName", "FCurrencyID", "FCurrencyName", "FCurrencyPre", "FPeriodName", "FBeginQuantity", "FBeginPrice", "FBeginOriention", "FBeginBalanceFor", "FBeginBalanceLocal", "FBeginBalanceRpt", "FDebitQuantity", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQuantity", "FCreditFor", "FCreditLocal", "FCreditRpt", "FYearDebitQuantity", "FYearDebitFor", "FYearDebitLocal", "FYearDebitRpt", "FYearCreditQuantity", "FYearCreditFor", "FYearCreditLocal", "FYearCreditRpt", "FEndBalanceQuantity", "FEndBalancePrice", "FEndBalanceOriention", "FEndBalanceFor", "FEndBalanceLocal", "FEndBalanceRpt"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AsstAcctNumber", "AsstAcctName", "CurrencyName", "CurrencyName", "CurrencyName", "PeriodName", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "Debit", "Debit", "Debit", "Debit", "Credit", "Credit", "Credit", "Credit", "YearDebit", "YearDebit", "YearDebit", "YearDebit", "YearCredit", "YearCredit", "YearCredit", "YearCredit", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd"}, {"AsstAcctNumber", "AsstAcctName", "CurrencyName", "CurrencyName", "CurrencyName", "PeriodName", "Quantity", "Price", "Oriention", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "Price", "Oriention", "LabelFor", "LabelLocal", "LabelRpt"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = null;
        widths = new int[]{80, 80, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, -1, -1, 30, 80, 80, -1, -1, 80, 80, -1, -1, 80, 80, -1, -1, 80, 80, -1, -1, 80, 80, -1, -1, -1, 30, 110, 110, -1};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        head.setAlignments(alignments);
        int[] numberStyleTypes = new int[]{0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, false, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true};
        head.setNeedKilobits(needKilobits);
        int scaleFor = partner.getScaleFor();
        int scaleLocal = partner.getScaleLocal();
        int scaleRpt = partner.getScaleRpt();
        int scaleQty = partner.getParmQtyScale();
        int scalePrice = partner.getParmPriceScale();
        int[] numberScales = new int[]{0, 0, 0, 0, 0, 0, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt};
        head.setNumberScales(numberScales);
    }

    private void setBaseReportHeadQuantity(ReportPartner partner) throws BOSException, EASBizException {
        ReportTableHeadInfo head = partner.getTableHeadInfo();
        String[] columnNames = new String[]{"FNumber", "FName", "FCurrencyID", "FCurrencyName", "FCurrencyPre", "FPeriodName", "FBeginQuantity", "FBeginPrice", "FBeginOriention", "FBeginBalanceFor", "FBeginBalanceLocal", "FBeginBalanceRpt", "FDebitQuantity", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQuantity", "FCreditFor", "FCreditLocal", "FCreditRpt", "FYearDebitQuantity", "FYearDebitFor", "FYearDebitLocal", "FYearDebitRpt", "FYearCreditQuantity", "FYearCreditFor", "FYearCreditLocal", "FYearCreditRpt", "FEndBalanceQuantity", "FEndBalancePrice", "FEndBalanceOriention", "FEndBalanceFor", "FEndBalanceLocal", "FEndBalanceRpt"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AsstAcctNumber", "AsstAcctName", "CurrencyName", "CurrencyName", "CurrencyName", "PeriodName", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "Debit", "Debit", "Debit", "Debit", "Credit", "Credit", "Credit", "Credit", "YearDebit", "YearDebit", "YearDebit", "YearDebit", "YearCredit", "YearCredit", "YearCredit", "YearCredit", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd"}, {"AsstAcctNumber", "AsstAcctName", "CurrencyName", "CurrencyName", "CurrencyName", "PeriodName", "Quantity", "Price", "Oriention", "LabelFor", "LabelAmount", "LabelRpt", "Quantity", "LabelFor", "LabelAmount", "LabelRpt", "Quantity", "LabelFor", "LabelAmount", "LabelRpt", "Quantity", "LabelFor", "LabelAmount", "LabelRpt", "Quantity", "LabelFor", "LabelAmount", "LabelRpt", "Quantity", "Price", "Oriention", "LabelFor", "LabelAmount", "LabelRpt"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = null;
        widths = new int[]{80, 80, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, 80, 80, 30, -1, 80, -1, 80, -1, 80, -1, 80, -1, 80, -1, 80, -1, 80, -1, 80, -1, 80, -1, 80, 80, 30, -1, 110, -1};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        head.setAlignments(alignments);
        int[] numberStyleTypes = new int[]{0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, false, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true};
        head.setNeedKilobits(needKilobits);
        int scaleFor = partner.getScaleFor();
        int scaleLocal = partner.getScaleLocal();
        int scaleRpt = partner.getScaleRpt();
        int scaleQty = partner.getParmQtyScale();
        int scalePrice = partner.getParmPriceScale();
        int[] numberScales = new int[]{0, 0, 0, 0, 0, 0, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt};
        head.setNumberScales(numberScales);
    }

    private void setBaseReportHead(ReportPartner partner) throws BOSException, EASBizException {
        ReportTableHeadInfo head = partner.getTableHeadInfo();
        String[] columnNames = new String[]{"FNumber", "FName", "FCurrencyID", "FCurrencyName", "FCurrencyPre", "FPeriodName", "FBeginQuantity", "FBeginPrice", "FBeginOriention", "FBeginBalanceFor", "FBeginBalanceLocal", "FBeginBalanceRpt", "FDebitQuantity", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQuantity", "FCreditFor", "FCreditLocal", "FCreditRpt", "FYearDebitQuantity", "FYearDebitFor", "FYearDebitLocal", "FYearDebitRpt", "FYearCreditQuantity", "FYearCreditFor", "FYearCreditLocal", "FYearCreditRpt", "FEndBalanceQuantity", "FEndBalancePrice", "FEndBalanceOriention", "FEndBalanceFor", "FEndBalanceLocal", "FEndBalanceRpt"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AsstAcctNumber", "AsstAcctName", "CurrencyName", "CurrencyName", "CurrencyName", "PeriodName", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "BalanceBegin", "Debit", "Debit", "Debit", "Debit", "Credit", "Credit", "Credit", "Credit", "YearDebit", "YearDebit", "YearDebit", "YearDebit", "YearCredit", "YearCredit", "YearCredit", "YearCredit", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd", "BalanceEnd"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = null;
        widths = new int[]{80, 80, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, -1, -1, 20, 80, -1, -1, -1, 80, -1, -1, -1, 80, -1, -1, -1, 80, -1, -1, -1, 80, -1, -1, -1, -1, 20, 110, -1, -1};
        head.setWidths(widths);
        boolean[] visible = new boolean[]{true, true, false, false, false, true, false, false, true, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, true, false, false, false, false, true, true, false, false};
        head.setVisibles(visible);
        int[] alignments = new int[]{0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        head.setAlignments(alignments);
        int[] numberStyleTypes = new int[]{0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, false, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true};
        head.setNeedKilobits(needKilobits);
        int scaleFor = partner.getScaleFor();
        int scaleLocal = partner.getScaleLocal();
        int scaleRpt = partner.getScaleRpt();
        int scaleQty = partner.getParmQtyScale();
        int scalePrice = partner.getParmPriceScale();
        int[] numberScales = new int[]{0, 0, 0, 0, 0, 0, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt};
        head.setNumberScales(numberScales);
    }

    @Override
    protected void insertDataIntoTempTable(ReportPartner partner) throws BOSException, EASBizException {
        String strStructure = this.getTempTableStructure();
        String strTempTable = partner.createTempTableAsynchronism("GLGLASST", strStructure);
        partner.setTempTableName(strTempTable);
        this.insertData(partner, strTempTable);
    }

    private String getTempTableStructure() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" (FAsstItemId VARCHAR(44),FAccountId VARCHAR(44),FAssistGrpID VARCHAR(44), ");
        strBuffer.append("  FCurrencyID VARCHAR(44),FPeriodYear INT, FPeriodNumber INT, \r\n");
        strBuffer.append("  FBeginBalanceFor DECIMAL(28, 10),FDebitFor DECIMAL(28, 10),\r\n");
        strBuffer.append("  FCreditFor DECIMAL(28, 10),FYearDebitFor DECIMAL(28, 10),\r\n");
        strBuffer.append("  FYearCreditFor DECIMAL(28, 10), FEndBalanceFor DECIMAL(28, 10),\r\n");
        strBuffer.append("  FBeginBalanceLocal DECIMAL(28, 10),FDebitLocal DECIMAL(28, 10),\r\n");
        strBuffer.append("  FCreditLocal DECIMAL(28, 10),FYearDebitLocal DECIMAL(28, 10),\r\n");
        strBuffer.append("  FYearCreditLocal DECIMAL(28, 10),\r\n");
        strBuffer.append("  FEndBalanceLocal DECIMAL(28, 10),\r\n");
        strBuffer.append("  FBeginBalanceRpt DECIMAL(28, 10),FDebitRpt DECIMAL(28, 10),\r\n");
        strBuffer.append("  FCreditRpt DECIMAL(28, 10),FYearDebitRpt DECIMAL(28, 10),\r\n");
        strBuffer.append("  FYearCreditRpt DECIMAL(28, 10),FEndBalanceRpt DECIMAL(28,10),\r\n ");
        strBuffer.append("  FBeginQty DECIMAL(28, 10),FDebitQty DECIMAL(28, 10),\r\n");
        strBuffer.append("  FCreditQty DECIMAL(28, 10),FYearDebitQty DECIMAL(28, 10),\r\n");
        strBuffer.append("  FYearCreditQty DECIMAL(28, 10),FEndQty DECIMAL(28,10))\r\n ");
        return strBuffer.toString();
    }

    private void insertData(ReportPartner partner, String strTempTable) throws BOSException, EASBizException {
        ReportConditionGeneralLedgerAssist condition = (ReportConditionGeneralLedgerAssist)partner.getFixCondition();
        String companyId = partner.getCompanyId();
        String accountId = condition.getAccountId();
        String asstAccountId = condition.getAsstAccountId();
        String asstActTypeInfoFieldName = partner.getAsstActTypeInfo().getMappingFieldName();
        int baltype = condition.getOptionPosting() ? 1 : 5;
        String currencyId = null;
        if (partner.getCurrency() != null) {
            currencyId = condition.getCurrencyID();
        }
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        int[] periodRange = new int[]{condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart(), condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd()};
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" SELECT ");
        strBuffer.append(" T_Main.FAsstItemId,");
        if (partner.getAccountViewInfo().isIsLeaf()) {
            strBuffer.append(" T_Main.FAccountID");
        } else {
            strBuffer.append("'").append(accountId).append("' FAccountID");
        }
        strBuffer.append(", T_Main.FAssistGrpID FAssistGrpID,\r\n");
        if (isForCurrency) {
            strBuffer.append("    T_Main.FCurrencyID AS FCurrencyID ,\r\n");
        } else {
            strBuffer.append("    '" + currencyId + "' AS FCurrencyID ,\r\n");
        }
        strBuffer.append("    TB.FPeriodYear FPeriodYear,TB.FPeriodNumber FPeriodNumber,\r\n");
        if (isForCurrency) {
            strBuffer.append("    isnull(T_Main.FBeginBalanceFor,0) AS FBeginBalanceFor, \r\n");
            strBuffer.append("    isnull(T_Main.FDebitFor,0) AS FDebitFor,\r\n ");
            strBuffer.append("    isnull(T_Main.FCreditFor,0) AS FCreditFor,\r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitFor,0)  AS FYearDebitFor,\r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditFor,0) AS FYearCreditFor,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceFor,0) AS FEndBalanceFor,\r\n");
            strBuffer.append("    isnull(T_Main.FBeginBalanceLocal,0) AS FBeginBalanceLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FDebitLocal,0) AS FDebitLocal,\r\n");
            strBuffer.append("\t  isnull(T_Main.FCreditLocal,0) AS FCreditLocal, \r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitLocal,0) as FYearDebitLocal, \r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditLocal,0)  AS FYearCreditLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceLocal,0) AS FEndBalanceLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FBeginBalanceRpt,0) AS FBeginBalanceRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FDebitRpt,0) AS FDebitRpt, \r\n");
            strBuffer.append("    isnull(T_Main.FCreditRpt,0) AS FCreditRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitRpt,0) AS FYearDebitRpt, \r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditRpt,0) AS FYearCreditRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceRpt,0) AS FEndBalanceRpt, \r\n");
        } else if (isLocalCurrency) {
            strBuffer.append("    isnull(T_Main.FBeginBalanceLocal,0) AS FBeginBalanceFor, \r\n");
            strBuffer.append("    isnull(T_Main.FDebitLocal,0) AS FDebitFor,\r\n ");
            strBuffer.append("    isnull(T_Main.FCreditLocal,0) AS FCreditFor,\r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitLocal,0)  AS FYearDebitFor,\r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditLocal,0) AS FYearCreditFor,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceLocal,0) AS FEndBalanceFor,\r\n");
            strBuffer.append("    isnull(T_Main.FBeginBalanceLocal,0) AS FBeginBalanceLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FDebitLocal,0) AS FDebitLocal,\r\n");
            strBuffer.append("\t  isnull(T_Main.FCreditLocal,0) AS FCreditLocal, \r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitLocal,0) as FYearDebitLocal, \r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditLocal,0)  AS FYearCreditLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceLocal,0) AS FEndBalanceLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FBeginBalanceLocal,0) AS FBeginBalanceRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FDebitLocal,0) AS FDebitRpt, \r\n");
            strBuffer.append("    isnull(T_Main.FCreditLocal,0) AS FCreditRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitLocal,0) AS FYearDebitRpt, \r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditLocal,0) AS FYearCreditRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceLocal,0) AS FEndBalanceRpt, \r\n");
        } else if (isRptCurrency) {
            strBuffer.append("    isnull(T_Main.FBeginBalanceRpt,0) AS FBeginBalanceFor, \r\n");
            strBuffer.append("    isnull(T_Main.FDebitRpt,0) AS FDebitFor,\r\n ");
            strBuffer.append("    isnull(T_Main.FCreditRpt,0) AS FCreditFor,\r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitRpt,0)  AS FYearDebitFor,\r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditRpt,0) AS FYearCreditFor,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceRpt,0) AS FEndBalanceFor,\r\n");
            strBuffer.append("    isnull(T_Main.FBeginBalanceRpt,0) AS FBeginBalanceLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FDebitRpt,0) AS FDebitLocal,\r\n");
            strBuffer.append("\t  isnull(T_Main.FCreditRpt,0) AS FCreditLocal, \r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitRpt,0) as FYearDebitLocal, \r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditRpt,0)  AS FYearCreditLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceRpt,0) AS FEndBalanceLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FBeginBalanceRpt,0) AS FBeginBalanceRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FDebitRpt,0) AS FDebitRpt, \r\n");
            strBuffer.append("    isnull(T_Main.FCreditRpt,0) AS FCreditRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitRpt,0) AS FYearDebitRpt, \r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditRpt,0) AS FYearCreditRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceRpt,0) AS FEndBalanceRpt, \r\n");
        }
        strBuffer.append("    isnull(T_Main.FBeginQty,0) AS FBeginQty,\r\n");
        strBuffer.append("    isnull(T_Main.FDebitQty,0) AS FDebitQty, \r\n");
        strBuffer.append("    isnull(T_Main.FCreditQty,0) AS FCreditQty,\r\n");
        strBuffer.append("    isnull(T_Main.FYearDebitQty,0) AS FYearDebitQty, \r\n");
        strBuffer.append("    isnull(T_Main.FYearCreditQty,0) AS FYearCreditQty,\r\n");
        strBuffer.append("    isnull(T_Main.FEndQty,0) AS FEndQty \r\n");
        strBuffer.append(" FROM  T_BD_Period TB \r\n");
        strBuffer.append(" INNER JOIN T_ORG_Company TC on TC.faccountperiodid = TB.ftypeid \r\n");
        strBuffer.append(" left join ( \r\n");
        strBuffer.append("   select hg." + asstActTypeInfoFieldName + " AS FAsstItemId, b.* \r\n");
        strBuffer.append("   from " + GLBalanceUtils.getAssistBalanceTable(baltype, currencyId) + " b \r\n");
        strBuffer.append("   join T_BD_AssistantHG hg on hg.FID = b.FAssistGrpID \r\n");
        strBuffer.append("   where b.FOrgUnitID = '").append(companyId).append("' \r\n");
        if (partner.getAccountViewInfo().isIsLeaf()) {
            strBuffer.append("     and b.FAccountID = '").append(accountId).append("' \r\n");
        } else {
            strBuffer.append("\tand b.FAccountID IN ");
            strBuffer.append(GLRptDaoUtil.set2String(condition.getAccountIdSet()));
            strBuffer.append(" \r\n");
        }
        if (isForCurrency && partner.getCurrency() != null) {
            strBuffer.append("     AND b.FCurrencyID = '").append(currencyId).append("' \r\n");
        }
        strBuffer.append("     AND hg.");
        strBuffer.append(asstActTypeInfoFieldName);
        strBuffer.append(" in ('" + condition.getAssistItemId() + "') \r\n");
        if (asstAccountId != null) {
            strBuffer.append("     and hg.FAsstAccountID = '").append(asstAccountId).append("' \r\n");
        }
        strBuffer.append("     AND ");
        strBuffer.append(SQLUtil.getPeriodCondition("b.FPeriod", periodRange));
        strBuffer.append(" ) T_Main  ON T_Main.FPeriod = TB.FNumber \r\n");
        strBuffer.append(" WHERE TC.FID = '").append(companyId).append("' \r\n");
        strBuffer.append(" AND ");
        strBuffer.append(SQLUtil.getPeriodCondition("TB.FNumber", periodRange));
        String strInsertTable = " insert into " + strTempTable + strBuffer.toString();
        this.execute(partner.getContext(), strInsertTable);
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String delSql;
            cn = partner.getConnection();
            if (condition.isOptionNOTDisplayIfNoAmount()) {
                delSql = "delete from " + strTempTable + " where not exists(select top 1 * from " + strTempTable + " as T_Main  where (fDebitFor<>0 or fDebitLocal<>0 or fDebitRpt<>0 or fCreditFor<>0 or fCreditLocal<>0 or fCreditRpt<>0))";
                DbUtil.execute((Context)partner.getContext(), (String)delSql);
            } else if (condition.isOptionNOTDisplayIfZeroNoAmount()) {
                delSql = "delete from " + strTempTable + " where not exists(select top 1 * from " + strTempTable + " as T_Main  where (fDebitFor<>0 or fDebitLocal<>0 or fDebitRpt<>0 or fCreditFor<>0 or fCreditLocal<>0 or fCreditRpt<>0) or ((fDebitFor=0 and fDebitLocal=0 and fDebitRpt=0 and fCreditFor=0 and fCreditLocal=0 and fCreditRpt=0) and (fEndBalanceFor<>0 or fEndBalanceLocal<>0 or fEndBalanceRpt<>0)))";
                DbUtil.execute((Context)partner.getContext(), (String)delSql);
            }
            strBuffer = new StringBuffer("update ").append(strTempTable).append(" set FAccountID=? , FCurrencyID=? where FAccountID is null");
            stmt = cn.prepareStatement(strBuffer.toString());
            stmt.setString(1, condition.getAccountId());
            stmt.setString(2, condition.getCurrencyID() == null ? partner.getCompany().getBaseCurrency().getId().toString() : condition.getCurrencyID());
            stmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)sqle);
                sqle.setNextException(new SQLException("The query sql is:" + strInsertTable));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)stmt);
        if (!GlUtils.isCompanyUnion(partner.getCompany())) {
            Context ctx = partner.getContext();
            PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)partner.getCompany(), (Context)ctx);
            final int curPeriodOrder = pe.getCurrentYear() * 100 + pe.getCurrentPeriod();
            if (condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd() > curPeriodOrder) {
                SqlParameter2 parameter;
                StringBuffer updateBalance = new StringBuffer();
                updateBalance.append(" update  ").append(strTempTable).append(" set   ");
                class MyInnerClass {
                    private String tempTableName = null;

                    MyInnerClass(String tempTable) {
                        this.tempTableName = tempTable;
                    }

                    private void setYearUpdt(StringBuffer sql, String yearcolumn, String column) {
                        sql.append("\n ").append(yearcolumn).append(" = ").append(" to_decimal(0.0,19,4)   ");
                        sql.append("\n + (select sum(").append(column).append(") from ").append(this.tempTableName).append(" ta where ta.fperiodyear*100+ta.fperiodnumber <= ").append(this.tempTableName).append(".fperiodyear*100+").append(this.tempTableName).append(".fperiodnumber ").append(" and fperiodyear*100+fperiodnumber >").append(curPeriodOrder).append(" and ta.faccountid = ").append(this.tempTableName).append(".faccountid and ta.fasstitemid = ").append(this.tempTableName).append(".fasstitemid and ta.fassistgrpid = ").append(this.tempTableName).append(".fassistgrpid and ta.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid ");
                        sql.append(" )");
                        sql.append("\n      +  case when (select ").append(yearcolumn).append(" from ").append(this.tempTableName).append(" tb ").append(" where tb.fperiodyear*100+tb.fperiodnumber = ").append(curPeriodOrder).append(" and tb.faccountid = ").append(this.tempTableName).append(".faccountid and tb.fasstitemid = ").append(this.tempTableName).append(".fasstitemid and tb.fassistgrpid = ").append(this.tempTableName).append(".fassistgrpid and tb.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid ");
                        sql.append(" ) is null then to_decimal(0.0,19,4) ");
                        sql.append(" else (select ").append(yearcolumn).append(" from ").append(this.tempTableName).append(" tb ").append(" where tb.fperiodyear*100+tb.fperiodnumber = ").append(curPeriodOrder).append(" and tb.faccountid = ").append(this.tempTableName).append(".faccountid and tb.fasstitemid = ").append(this.tempTableName).append(".fasstitemid and tb.fassistgrpid = ").append(this.tempTableName).append(".fassistgrpid and tb.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid ");
                        sql.append(" ) end ,");
                    }

                    private void setEndUpdt(StringBuffer sql, String yearcolumn, String endcolumn) {
                        sql.append("\n ").append(endcolumn).append(" = ").append(" to_decimal(0.0,19,4)   ");
                        sql.append(" + ").append(yearcolumn);
                        sql.append("\n      - ISNULL((select ").append(yearcolumn).append(" from ").append(this.tempTableName).append(" tb ").append(" where tb.fperiodyear*100+tb.fperiodnumber = ").append(curPeriodOrder).append(" and tb.faccountid = ").append(this.tempTableName).append(".faccountid and tb.fasstitemid = ").append(this.tempTableName).append(".fasstitemid and tb.fassistgrpid = ").append(this.tempTableName).append(".fassistgrpid and tb.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid ");
                        sql.append(" ),0.0000)");
                        sql.append(" \n     + ISNULL((select ").append(endcolumn).append(" from ").append(this.tempTableName).append(" tc ").append(" where tc.fperiodyear*100+tc.fperiodnumber = ").append(curPeriodOrder).append(" and tc.faccountid = ").append(this.tempTableName).append(".faccountid and tc.fasstitemid = ").append(this.tempTableName).append(".fasstitemid and tc.fassistgrpid = ").append(this.tempTableName).append(".fassistgrpid and tc.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid ");
                        sql.append(" ),0.0000),");
                    }

                    private void setBeginUpdt(StringBuffer sql, String begincolumn, String endcolumn, String column) {
                        sql.append("\n ").append(begincolumn).append(" = ").append(" to_decimal(0.0,19,4)   ");
                        sql.append(" + ").append(endcolumn).append(" - ").append(column);
                        sql.append(",");
                    }
                }
                MyInnerClass myInner = new MyInnerClass(strTempTable);
                myInner.setYearUpdt(updateBalance, "FYEARDEBITFor", "FDEBITFor");
                myInner.setYearUpdt(updateBalance, "FYearCreditFor", "FCreditFor");
                myInner.setYearUpdt(updateBalance, "FYEARDEBITLOCAL", "FDEBITLOCAL");
                myInner.setYearUpdt(updateBalance, "FYearCreditLOCAL", "FCreditLOCAL");
                myInner.setYearUpdt(updateBalance, "FYEARDEBITRpt", "FDEBITRpt");
                myInner.setYearUpdt(updateBalance, "FYearCreditRpt", "FCreditRpt");
                myInner.setYearUpdt(updateBalance, "FYEARDEBITQty", "FDEBITQty");
                myInner.setYearUpdt(updateBalance, "FYearCreditQty", "FCreditQty");
                updateBalance.deleteCharAt(updateBalance.length() - 1);
                updateBalance.append("\n   where fperiodyear*100+fperiodnumber > ").append(curPeriodOrder);
                try {
                    cn = partner.getConnection();
                    stmt = cn.prepareStatement(updateBalance.toString());
                    parameter = new SqlParameter2();
                    parameter.putToStatement(stmt);
                    stmt.executeUpdate();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                    sqle.setNextException(new SQLException("The query sql is:" + updateBalance));
                    throw new SQLDataException(sqle);
                }
                finally {
                    SQLUtils.cleanup(rs, (Statement)stmt);
                }
                updateBalance.setLength(0);
                updateBalance.append(" update  ").append(strTempTable).append(" set   ");
                myInner.setEndUpdt(updateBalance, "(FYEARDEBITFor - FYEARCreditFor)", "FENDBALANCEFor");
                myInner.setEndUpdt(updateBalance, "(FYEARDEBITLOCAL - FYEARCreditLOCAL)", "FENDBALANCELOCAL");
                myInner.setEndUpdt(updateBalance, "(FYEARDEBITRpt - FYEARCreditRpt)", "FENDBALANCERpt");
                myInner.setEndUpdt(updateBalance, "(FYEARDEBITQty - FYEARCreditQty)", "FENDQty");
                updateBalance.deleteCharAt(updateBalance.length() - 1);
                updateBalance.append("\n   where fperiodyear*100+fperiodnumber > ").append(curPeriodOrder);
                try {
                    cn = partner.getConnection();
                    stmt = cn.prepareStatement(updateBalance.toString());
                    parameter = new SqlParameter2();
                    parameter.putToStatement(stmt);
                    stmt.executeUpdate();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                    sqle.setNextException(new SQLException("The query sql is:" + updateBalance));
                    throw new SQLDataException(sqle);
                }
                finally {
                    SQLUtils.cleanup(rs, (Statement)stmt);
                }
                updateBalance.setLength(0);
                updateBalance.append(" update  ").append(strTempTable).append(" set   ");
                myInner.setBeginUpdt(updateBalance, "FBEGINBALANCEFor", "FENDBALANCEFor", "(FDEBITFor - FCreditFor)");
                myInner.setBeginUpdt(updateBalance, "FBEGINBALANCELOCAL", "FENDBALANCELOCAL", "(FDEBITLOCAL - FCreditLOCAL)");
                myInner.setBeginUpdt(updateBalance, "FBEGINBALANCERpt", "FENDBALANCERpt", "(FDEBITRpt - FCreditRpt)");
                myInner.setBeginUpdt(updateBalance, "FBEGINQty", "FENDQty", "(FDEBITQty - FCreditQty)");
                updateBalance.deleteCharAt(updateBalance.length() - 1);
                updateBalance.append("\n   where fperiodyear*100+fperiodnumber > ").append(curPeriodOrder);
                try {
                    cn = partner.getConnection();
                    stmt = cn.prepareStatement(updateBalance.toString());
                    parameter = new SqlParameter2();
                    parameter.putToStatement(stmt);
                    stmt.executeUpdate();
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                    sqle.setNextException(new SQLException("The query sql is:" + updateBalance));
                    throw new SQLDataException(sqle);
                }
                finally {
                    SQLUtils.cleanup(rs, (Statement)stmt);
                }
            }
        }
    }

    private String getBalanceDC(ReportPartner partner, BigDecimal curBalance, BalanceOrientionTag opposite, boolean bEndBalDCFormat, int iDC) throws BOSException {
        String strDc = null;
        int iOpposite = 0;
        boolean autoBalance = !bEndBalDCFormat;
        BigDecimal zero = new BigDecimal("0.0");
        if (curBalance == null) {
            curBalance = new BigDecimal("0.0");
        }
        if (autoBalance) {
            if (curBalance.compareTo(zero) > 0) {
                strDc = partner.TITLE_DEBIT;
                iOpposite = 1;
            }
            if (curBalance.compareTo(zero) < 0) {
                strDc = partner.TITLE_CREDIT;
                iOpposite = -1;
            }
            if (curBalance.compareTo(zero) == 0) {
                strDc = partner.TITLE_BALANCE;
                iOpposite = 1;
            }
        } else if (curBalance.compareTo(zero) == 0) {
            strDc = partner.TITLE_BALANCE;
            iOpposite = 1;
        } else {
            if (iDC == 1) {
                strDc = partner.TITLE_DEBIT;
                iOpposite = 1;
            }
            if (iDC == -1) {
                strDc = partner.TITLE_CREDIT;
                iOpposite = -1;
            }
        }
        opposite.setOriention(iOpposite);
        return strDc;
    }

    private int getScale(ReportPartner partner, String strCurrencyId) throws EASBizException, BOSException {
        int iScale = 0;
        String strFind = strCurrencyId;
        if (strFind.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
            CurrencyInfo baseCurrencyInfo = partner.getCompany().getBaseCurrency();
            return baseCurrencyInfo == null ? 0 : baseCurrencyInfo.getPrecision();
        }
        if (strFind.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
            CurrencyInfo reportCurrencyInfo = partner.getCompany().getReportCurrency();
            return reportCurrencyInfo == null ? 0 : reportCurrencyInfo.getPrecision();
        }
        CurrencyCollection currencys = partner.getAllCurrency();
        boolean bFind = false;
        if (currencys != null && currencys.size() != 0) {
            for (int i = 0; i < currencys.size() && !bFind; ++i) {
                CurrencyInfo tmpCurrencyInfo = currencys.get(i);
                if (!strFind.equals(tmpCurrencyInfo.getId().toString())) continue;
                iScale = tmpCurrencyInfo.getPrecision();
                bFind = true;
            }
        }
        return iScale;
    }

    @Override
    protected boolean useDialect() {
        return true;
    }
}

