/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.ReportConditionGeneralLedger;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportLineKey;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.app.AbstractGLReportGeneralLedgerControllerBean;
import com.kingdee.eas.fi.gl.app.GLTempTableUtil;
import com.kingdee.eas.fi.gl.app.ReportPartner;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.common.SqlParameter2;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class GLReportGeneralLedgerControllerBean
extends AbstractGLReportGeneralLedgerControllerBean {
    private static final long serialVersionUID = 5221469562523927610L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLReportGeneralLedgerControllerBean");
    private String plVoucherTempTable;
    private boolean isUseGL053 = false;
    private String companyIdsWithGL053 = "";

    @Override
    protected CurrencyCollection getAllCurrency(ReportPartner partner) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("isoCode"));
        sic.add(new SelectorItemInfo("sign"));
        sic.add(new SelectorItemInfo("BaseUnit"));
        ICurrency currency = CurrencyFactory.getLocalInstance((Context)partner.getContext());
        CurrencyCollection currencyCollection = null;
        if (!GlUtils.isCompanyUnion(partner.getCompany()) && partner.isParmForeignCurrencySu()) {
            currencyCollection = currency.getCurrencyCollection(view, false);
        } else {
            FilterInfo filter = new FilterInfo();
            if (!partner.isParmUseReportCurrency()) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString(), CompareType.NOTEQUALS));
            }
            view.setFilter(filter);
            currencyCollection = currency.getCurrencyCollection(view, false);
        }
        return currencyCollection;
    }

    @Override
    protected Object[] getLineObjects(ReportPartner partner, ResultSet rs) throws SQLException, EASBizException, BOSException {
        ReportConditionGeneralLedger condition = (ReportConditionGeneralLedger)partner.getFixCondition();
        boolean isParmBalanceDirSamAsAccount = partner.isParmBalanceDirSamAsAccount();
        boolean showQty = condition.isOptionShowQuantity();
        int qtyScale = partner.getParmQtyScale();
        String strCurrencyId = rs.getString("FCurrencyID");
        String expandAccount = (String)partner.getFixCondition().getExpandInfo().get("AccountID");
        int index = 0;
        Object[] row = new Object[24];
        int iSortNumber = rs.getInt("FPeriodSortNumber");
        String strAccountNumber = rs.getString("FAccountNumber");
        String strAccountName = rs.getString("FAccountName");
        String strAccountID = rs.getString("FAccountID");
        if (GlUtils.isCompanyUnion(partner.getCompany()) && condition.getVirtureCompany() != null && !condition.getVirtureCompany().getCompanyId().equals(rs.getString("FCompanyID"))) {
            row[index++] = "";
            row[index++] = "";
        } else if (iSortNumber == 0 && expandAccount == null || !GlUtils.isCompanyUnion(partner.getCompany()) && 0 == iSortNumber) {
            row[index++] = strAccountNumber;
            row[index++] = strAccountName;
        } else {
            row[index++] = "";
            row[index++] = "";
        }
        this.processGetLineObjects(0, row, index, partner, rs);
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            String companyId = rs.getString("FCompanyID");
            SimpleCompanyUserObject companyUserObject = partner.getCompanyUserObjectById(companyId);
            if (condition.getExpandCompanyLevel() > 0 && companyUserObject.getLevel() < condition.getExpandCompanyLevel() - 1) {
                companyUserObject.setExpanded(true);
                companyUserObject.setHasExpanded(true);
            }
            row[index++] = companyUserObject.clone();
        } else {
            row[index++] = "";
        }
        row[index++] = rs.getString("FCurrencyID");
        row[index++] = rs.getString("FCurrencyName");
        row[index++] = new Integer(rs.getInt("FCurrencyPre"));
        int iPeriod = rs.getInt("FPeriod");
        String strPeriodNumber = String.valueOf(iPeriod % 100);
        String strPeriodYear = String.valueOf(iPeriod / 100);
        String strYearBeginBalance = partner.TITLE_YEAR_START;
        String strPeriodBeginBalance = partner.TITLE_PERIOD_START;
        String strPeriodSum = partner.TITLE_PERIOD_SUM;
        String strYearSum = partner.TITLE_YEAR_SUM;
        row[index++] = condition.getPeriodYearStart() == condition.getPeriodYearEnd() ? strPeriodNumber.trim() : strPeriodYear.trim() + "." + strPeriodNumber.trim();
        if (iSortNumber == 0) {
            row[index++] = strPeriodNumber != null && strPeriodNumber.trim().equals("1") ? strYearBeginBalance : strPeriodBeginBalance;
        }
        this.processGetLineObjects(1, row, index, partner, rs);
        if (iSortNumber == 1) {
            row[index++] = strPeriodSum;
        }
        if (iSortNumber == 2) {
            row[index++] = strYearSum;
        }
        boolean isRptTransferMeasureUnit = partner.isRptTransferMeasureUnit();
        BigDecimal coefficient = new BigDecimal("1.00");
        String caa = rs.getString("FAccountFCAA");
        if (showQty && caa == null && isRptTransferMeasureUnit && rs.getBigDecimal("FCoefficient") != null) {
            coefficient = rs.getBigDecimal("FCoefficient");
        }
        BigDecimal FDebitQty = rs.getBigDecimal("FDebitQty");
        if (showQty && FDebitQty != null) {
            FDebitQty = FDebitQty.divide(coefficient, qtyScale, 4);
        }
        row[index++] = FDebitQty;
        BigDecimal debitFor = rs.getBigDecimal("FDebitFor");
        row[index++] = debitFor;
        BigDecimal debitLocal = rs.getBigDecimal("FDebitLocal");
        row[index++] = debitLocal;
        BigDecimal debitRpt = rs.getBigDecimal("FDebitRpt");
        row[index++] = debitRpt;
        BigDecimal FCreditQty = rs.getBigDecimal("FCreditQty");
        if (showQty && FCreditQty != null) {
            FCreditQty = FCreditQty.divide(coefficient, qtyScale, 4);
        }
        row[index++] = FCreditQty;
        BigDecimal creditFor = rs.getBigDecimal("FCreditFor");
        row[index++] = creditFor;
        BigDecimal creditLocal = rs.getBigDecimal("FCreditLocal");
        row[index++] = creditLocal;
        BigDecimal creditRpt = rs.getBigDecimal("FCreditRpt");
        row[index++] = creditRpt;
        int accountDC = rs.getInt("FBalanceOriention");
        BigDecimal endQty = rs.getBigDecimal("FEndQty");
        if (showQty && endQty != null) {
            endQty = endQty.divide(coefficient, qtyScale, 4);
        }
        BigDecimal balanceFor = rs.getBigDecimal("FEndBalanceFor");
        BigDecimal balanceLocal = rs.getBigDecimal("FEndBalanceLocal");
        BigDecimal balanceRpt = rs.getBigDecimal("FEndBalanceRpt");
        String strDC = this.getBalanceDC(partner, balanceFor == null ? balanceLocal : balanceFor, isParmBalanceDirSamAsAccount, accountDC);
        BigDecimal balanceFor2 = balanceFor;
        BigDecimal balanceLocal2 = balanceLocal;
        BigDecimal balanceRpt2 = balanceRpt;
        balanceFor = this.getBalanceForDC(balanceFor, isParmBalanceDirSamAsAccount, accountDC);
        balanceLocal = this.getBalanceForDC(balanceLocal, isParmBalanceDirSamAsAccount, accountDC);
        balanceRpt = this.getBalanceForDC(balanceRpt, isParmBalanceDirSamAsAccount, accountDC);
        if ((balanceFor2 != null && !balanceFor2.equals(balanceFor) || balanceLocal2 != null && !balanceLocal2.equals(balanceLocal) || balanceRpt2 != null && !balanceRpt2.equals(balanceRpt)) && endQty != null) {
            endQty = endQty.negate();
        }
        row[index++] = endQty;
        row[index] = null;
        boolean isShowLocalCurrency = !partner.isParmForeignCurrencySu() && partner.getCurrencyType() == 0 && partner.isBaseCurrency() && !GlUtils.isCompanyUnion(partner.getCompany());
        boolean isShowReportCurrency = !partner.isParmForeignCurrencySu() && partner.isParmUseReportCurrency() && partner.getCurrencyType() != 0 && !partner.isReportingCurrency() && !GlUtils.isCompanyUnion(partner.getCompany());
        BigDecimal balance = balanceFor;
        if (isShowLocalCurrency) {
            balance = balanceLocal;
        }
        if (isShowReportCurrency && !isShowLocalCurrency) {
            balance = balanceRpt;
        }
        if (partner.getCurrencyType() == 1) {
            balance = balanceLocal;
        }
        if (endQty != null && balance != null && endQty.compareTo(new BigDecimal("0.0")) != 0) {
            BigDecimal price = balance.divide(endQty, partner.getParmPriceScale(), 4);
            row[index] = price.abs();
        }
        int n = ++index;
        row[n] = strDC;
        int n2 = ++index;
        row[n2] = balanceFor;
        int n3 = ++index;
        row[n3] = balanceLocal;
        int n4 = ++index;
        row[n4] = balanceRpt;
        row[++index] = ReportResultInfo.LINE_NORMAL;
        if (iSortNumber == 1) {
            row[index] = ReportResultInfo.LINE_PERIOD_TOTAL;
        }
        if (iSortNumber == 2) {
            row[index] = ReportResultInfo.LINE_YEAR_TOTAL;
        }
        ++index;
        ReportLineKey lineKey = new ReportLineKey();
        lineKey.setStrAccountID(strAccountID);
        lineKey.setStrAccountNumber(strAccountNumber);
        lineKey.setStrCurrencyId(strCurrencyId);
        lineKey.setAccountHasAssist(rs.getString("FAccountFCAA") != null);
        lineKey.setAccountLeaf(rs.getInt("FAccountIsLeaf") == 1);
        lineKey.setSortNumber(iSortNumber);
        lineKey.setPeriodYear(Integer.valueOf(strPeriodYear));
        lineKey.setPeriodNumber(Integer.valueOf(strPeriodNumber));
        lineKey.setAccountIsQty(rs.getBoolean("accountIsQty"));
        row[index++] = lineKey;
        this.processGetLineObjects(2, row, index, partner, rs);
        return row;
    }

    @Override
    protected String getSqlForDataSelect(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionGeneralLedger condition = (ReportConditionGeneralLedger)partner.getFixCondition();
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append(" T_Main.FAccountID  FAccountID,\r\n");
        sqlSelect.append(" T_Main.FAccountNumber  FAccountNumber,\r\n");
        sqlSelect.append(this.getAccountName(partner));
        sqlSelect.append(partner.getFieldNameExtend());
        sqlSelect.append(" FAccountName, \r\n");
        if (condition.isOptionShowQuantity() && partner.isRptTransferMeasureUnit()) {
            sqlSelect.append("  MU.FCoefficient FCoefficient, \r\n ");
        }
        sqlSelect.append(" T_Main.FCompanyID FCompanyID, \r\n");
        sqlSelect.append(" T_Main.FCurrencyId FCurrencyID,");
        sqlSelect.append(" T_Main.FCurrencyNumber FCurrencyNumber,");
        sqlSelect.append(" T_Main.FCurrencyName FCurrencyName,");
        sqlSelect.append(" T_Main.FCurrencyPre FCurrencyPre,");
        sqlSelect.append(" T_Main.FPeriod FPeriod, \r\n");
        sqlSelect.append(" T_Main.FPeriodSortNumber FPeriodSortNumber, \r\n");
        sqlSelect.append(" T_Main.FDebitQty FDebitQty, \r\n");
        sqlSelect.append(" T_Main.FDebitFor FDebitFor, \r\n");
        sqlSelect.append(" T_Main.FDebitLocal FDebitLocal, \r\n");
        sqlSelect.append(" T_Main.FDebitRpt FDebitRpt, \r\n");
        sqlSelect.append(" T_Main.FCreditQty FCreditQty, \r\n");
        sqlSelect.append(" T_Main.FCreditFor FCreditFor, \r\n");
        sqlSelect.append(" T_Main.FCreditLocal FCreditLocal, \r\n");
        sqlSelect.append(" T_Main.FCreditRpt FCreditRpt, \r\n");
        sqlSelect.append(" T_Main.FEndQty FEndQty, \r\n");
        sqlSelect.append(" T_Main.FBalanceOriention FBalanceOriention, \r\n");
        sqlSelect.append(" T_Main.FEndBalanceFor FEndBalanceFor, \r\n");
        sqlSelect.append(" T_Main.FEndBalanceLocal FEndBalanceLocal, \r\n");
        sqlSelect.append(" T_Main.FEndBalanceRpt FEndBalanceRpt, \r\n");
        sqlSelect.append(" ta.FIsLeaf FAccountIsLeaf, ta.FCAA FAccountFCAA ,ta.fisqty accountIsQty");
        return sqlSelect.toString();
    }

    protected String getAccountName(ReportPartner partner) throws BOSException, EASBizException {
        HashMap<String, String> paramKeyMap = new HashMap<String, String>();
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)partner.getContext());
        boolean isAccountShowLongName = false;
        paramKeyMap.put("GL_012", partner.getCompany().getId().toString());
        String strAccountShowLongName = (String)iParamControl.getParamHashMap(paramKeyMap).get("GL_012");
        if (strAccountShowLongName != null && strAccountShowLongName.trim().length() > 0) {
            isAccountShowLongName = Boolean.valueOf(strAccountShowLongName.trim());
        }
        return isAccountShowLongName ? "    ta.FLongName" : "    ta.FName";
    }

    @Override
    protected String getSqlForDataFrom(ReportPartner partner) throws BOSException, ReportException {
        ReportConditionGeneralLedger condition = (ReportConditionGeneralLedger)partner.getFixCondition();
        StringBuffer sqlFrom = new StringBuffer();
        sqlFrom.append("  FROM \r\n");
        sqlFrom.append(partner.getTempTableName());
        sqlFrom.append("  AS T_Main \r\n");
        sqlFrom.append("  INNER JOIN T_BD_AccountView ta ON T_Main.FAccountID = ta.FID ");
        try {
            if (condition.isOptionShowQuantity() && partner.isRptTransferMeasureUnit()) {
                sqlFrom.append(" LEFT OUTER JOIN T_BD_MEASUREUNIT MU on MU.FID = TA.FMeasureUnitID ");
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return sqlFrom.toString();
    }

    @Override
    protected String getSqlForDataOrder(ReportPartner partner) throws BOSException, ReportException {
        ReportConditionGeneralLedger condition = (ReportConditionGeneralLedger)partner.getFixCondition();
        return "Order By T_Main.FAccountNumber,T_Main.FPeriod," + (condition.getCurrencyID() == null ? "T_Main.FCurrencyNumber, T_Main.FPeriodSortNumber,T_Main.flevelnumber" : "T_Main.FPeriodSortNumber, T_Main.flevelnumber");
    }

    @Override
    protected String getReportName() {
        return "GLGeneralLedger";
    }

    @Override
    protected String getAuthorityName() {
        return "GLGeneralLedger";
    }

    protected String getQueryName() {
        return "com.kingdee.eas.fi.gl.app.GLReportGeneralLedgerQuery";
    }

    @Override
    protected String getQuerySql(ReportPartner partner) throws BOSException, EASBizException {
        EntityViewInfo evi = partner.getCondition();
        ReportConditionBase customCondition = (ReportConditionBase)evi.get("GLFixCondition");
        String expandAccountNumber = (String)customCondition.getExpandInfo().get("AccountNumber");
        Integer sortNumber = (Integer)customCondition.getExpandInfo().get("SortNumber");
        Integer periodYear = (Integer)customCondition.getExpandInfo().get("PeriodYear");
        Integer periodNumber = (Integer)customCondition.getExpandInfo().get("PeriodNumber");
        List userObjects = (List)evi.get("Companys");
        StringBuffer inCompany = new StringBuffer("(");
        for (int i = 0; i < userObjects.size(); ++i) {
            SimpleCompanyUserObject virtureCompany = (SimpleCompanyUserObject)userObjects.get(i);
            inCompany.append("'").append(virtureCompany.getCompanyId()).append("',");
        }
        if (inCompany.length() > 1) {
            inCompany.replace(inCompany.length() - 1, inCompany.length(), ")");
        } else {
            inCompany.append(")");
        }
        String sqlSelect = this.getSqlForDataSelect(partner);
        String sqlFrom = this.getSqlForDataFrom(partner);
        String sqlWhere = this.getSqlForDataWhere(partner);
        String sqlOrder = this.getSqlForDataOrder(partner);
        if (sqlWhere == null) {
            sqlWhere = "where 1=1   ";
        }
        sqlWhere = sqlWhere + " and T_Main.FCompanyID in " + inCompany.toString();
        if (expandAccountNumber != null) {
            sqlWhere = sqlWhere + "  and T_Main.FAccountNumber='" + expandAccountNumber + "' and T_Main.FPeriodSortNumber=" + sortNumber + " and T_Main.FPeriod=" + (periodYear * 100 + periodNumber);
        }
        return "select " + sqlSelect + sqlFrom + sqlWhere + sqlOrder;
    }

    @Override
    protected ReportTableHeadInfo getDefalutTableHeadInfo(ReportPartner partner) throws ReportException {
        ReportTableHeadInfo head = new ReportTableHeadInfo();
        String[] columnNames = new String[]{"FAccountNumber", "FAccountName", "FCompany", "FPeriod", "FDescOfVoucher", "FDebitQty", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQty", "FCreditFor", "FCreditLocal", "FCreditRpt", "FQty", "FPrice", "FBalanceOritention", "FBalanceAmountFor", "FBalanceAmountLocal", "FBalanceAmountRpt"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AccountCode", "AccountName", "Company", "Period", "DescOfVoucher", "Debit", "Debit", "Debit", "Debit", "Credit", "Credit", "Credit", "Credit", "Balance", "Balance", "Balance", "Balance", "Balance", "Balance"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = new int[]{80, 160, 160, 80, 80, 0, 0, 80, 0, 0, 0, 80, 0, 0, 0, 30, 0, 110, 0};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        head.setAlignments(alignments);
        boolean[] merges = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setMerges(merges);
        boolean[] freezes = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setFreezes(freezes);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
        return head;
    }

    @Override
    protected void insertDataIntoTempTable(ReportPartner partner) throws BOSException, EASBizException {
        StringBuffer sql;
        ReportConditionGeneralLedger condition = (ReportConditionGeneralLedger)partner.getFixCondition();
        EntityViewInfo evi = partner.getCondition();
        ReportConditionBase customCondition = (ReportConditionBase)evi.get("GLFixCondition");
        try {
            CompanyOrgUnitInfo company = partner.getCompany();
            String accountTableId = company.getAccountTable().getId().toString();
            AccountRefContrastInfo ar = AccountRefContrastFactory.getLocalInstance((Context)partner.getContext()).getLastAcctInfo(company.getId().toString(), accountTableId, customCondition.getPeriodYearEnd(), customCondition.getPeriodNumberEnd());
            AccountTableInfo accountTable = null;
            if (ar != null) {
                AccountTableInfo newAccountTable;
                AccountTableInfo accountTableInfo = newAccountTable = ar.getEnabledPeriod() != null && ar.getEnabledPeriod().getNumber() == customCondition.getPeriodYearEnd() * 100 + customCondition.getPeriodNumberEnd() ? ar.getDisabledAcctTable() : ar.getEnabledAcctTable();
                if (newAccountTable != null && !newAccountTable.getId().toString().equals(accountTableId)) {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("name"));
                    selector.add(new SelectorItemInfo("number"));
                    accountTable = AccountTableFactory.getLocalInstance((Context)partner.getContext()).getAccountTableInfo((IObjectPK)new ObjectUuidPK(newAccountTable.getId()), selector);
                }
            }
            if (accountTable != null) {
                company.setAccountTable(accountTable);
                partner.setCompany(company);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        String strStructure = this.getSecondTempTableStructure(partner);
        String strTempTable = partner.createTempTableAsynchronism("GLGL", strStructure);
        partner.setTempTableName(strTempTable);
        strStructure = this.getFirstTempTableStructure();
        String strFirstTempTableName = partner.createTempTableAsynchronism("GLGL01", strStructure, true);
        if (condition.isNotIncludePLVoucher()) {
            this.createPLVoucherTempTable(partner);
        }
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            this.insertFirstDataForVirtual(partner, strFirstTempTableName);
            this.insertFirstDataVirtualForUpdate(partner, strFirstTempTableName);
            this.insertNotUseAccountForVirtual(partner, strFirstTempTableName);
            this.insertAccountLevelSumData(partner, strFirstTempTableName);
            this.insertSecondDataForVirtual(partner, strFirstTempTableName, strTempTable);
            if (condition.isOptionNOTDisplayIfNoAmount() || condition.isOptionNOTDisplayIfZeroNoAmount()) {
                sql = new StringBuffer();
                sql.append("delete from ").append(strTempTable).append(" where faccountnumber not in(select faccountnumber from ").append(strTempTable);
                sql.append(" where ((fDebitFor<>0 or fDebitLocal<>0 or fDebitRpt<>0 or fCreditFor<>0 or fCreditLocal<>0 or fCreditRpt<>0) and fperiodSortNumber=1)");
                if (condition.isOptionNOTDisplayIfZeroNoAmount()) {
                    sql.append(" or (fEndBalanceFor<>0 or fEndBalanceLocal<>0 or fEndBalanceRpt<>0");
                    sql.append(" or (fperiodSortNumber = 2 and (fDebitFor<>0 or fDebitLocal<>0 or fDebitRpt<>0 or fCreditFor<>0 or fCreditLocal<>0 or fCreditRpt<>0)))");
                }
                sql.append(")");
                DbUtil.execute((Context)partner.getContext(), (String)sql.toString());
            }
        } else {
            this.insertFirstData(partner, strFirstTempTableName);
            this.insertFirstDataForUpdate(partner, strFirstTempTableName);
            if (!condition.isOptionNOTDisplayIfNoAmount() && !condition.isOptionNOTDisplayIfZeroNoAmount()) {
                this.insertNotUseAccount(partner, strFirstTempTableName);
            }
            this.insertAccountLevelSumData(partner, strFirstTempTableName);
            this.insertSecondData(partner, strFirstTempTableName, strTempTable);
            if (condition.isOptionNOTDisplayIfNoAmount() || condition.isOptionNOTDisplayIfZeroNoAmount()) {
                sql = new StringBuffer();
                sql.append("delete from ").append(strTempTable).append(" where faccountnumber not in(select faccountnumber from ").append(strTempTable);
                sql.append(" where ((fDebitFor<>0 or fDebitLocal<>0 or fDebitRpt<>0 or fCreditFor<>0 or fCreditLocal<>0 or fCreditRpt<>0) and fperiodSortNumber=1)");
                if (condition.isOptionNOTDisplayIfZeroNoAmount()) {
                    sql.append(" or (fEndBalanceFor<>0 or fEndBalanceLocal<>0 or fEndBalanceRpt<>0");
                    sql.append(" or (fperiodSortNumber = 2 and (fDebitFor<>0 or fDebitLocal<>0 or fDebitRpt<>0 or fCreditFor<>0 or fCreditLocal<>0 or fCreditRpt<>0)))");
                }
                sql.append(")");
                DbUtil.execute((Context)partner.getContext(), (String)sql.toString());
            }
        }
        partner.dropTempTable(strFirstTempTableName);
    }

    @Override
    protected void insertTempTableForVirtual(ReportPartner partner, SimpleCompanyUserObject simpleCompanyUserObject) throws BOSException, EASBizException {
        String companyId = simpleCompanyUserObject.getCompanyId();
        String companyIdInClause = partner.getPhysicalCompanyIdByParent(simpleCompanyUserObject);
        String levelNumber = simpleCompanyUserObject.getLongNumber();
        EntityViewInfo evi = partner.getCondition();
        ReportConditionGeneralLedger customCondition = (ReportConditionGeneralLedger)evi.get("GLFixCondition");
        String expandAccountNumber = (String)customCondition.getExpandInfo().get("AccountNumber");
        Integer sortNumber = (Integer)customCondition.getExpandInfo().get("SortNumber");
        Integer periodYear = (Integer)customCondition.getExpandInfo().get("PeriodYear");
        Integer periodNumber = (Integer)customCondition.getExpandInfo().get("PeriodNumber");
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append(" (FAccountID ,FAccountNumber ,FAccountName ,FCompanyID , \r\n");
        sql.append("  FCurrencyID ,FCurrencyNumber ,FCurrencyName , FCurrencyPre, \r\n");
        sql.append("  FPeriod , FPeriodSortNumber , flevelnumber, \r\n");
        sql.append("  FDebitQty ,  FDebitFor , \r\n");
        sql.append("  FDebitLocal ,  FDebitRpt ,\r\n");
        sql.append("  FCreditQty ,  FCreditFor , \r\n");
        sql.append("  FCreditLocal , FCreditRpt , \r\n");
        sql.append("  FEndQty ,  FBalanceOriention , \r\n");
        sql.append("  FEndBalanceFor ,  FEndBalanceLocal , \r\n");
        sql.append("  FEndBalanceRpt )");
        sql.append(" SELECT case when PAV.FID is null then max(tb.FID) else PAV.FID end FAccountID,");
        sql.append(" tb.FNumber, tb.FName_").append(partner.getContext().getLocale().toString()).append(",");
        sql.append(" to_char('").append(companyId).append("'),");
        sql.append(" T1.FCurrencyID ,T1.FCurrencyNumber ,T1.FCurrencyName , T1.FCurrencyPre, \r\n");
        sql.append(" T1.FPeriod,T1.FPeriodSortNumber,\r\n");
        sql.append("  to_char('").append(levelNumber).append("'), ");
        sql.append("        SUM(T1.FDebitQty) AS FDebitQty, \r\n");
        sql.append("        SUM(T1.FDebitFor) AS FDebitFor, \r\n");
        sql.append("        SUM(T1.FDebitLocal) AS FDebitLocal, \r\n");
        sql.append("        SUM(T1.FDebitRpt) AS FDebitRpt, \r\n");
        sql.append("        SUM(T1.FCreditQty) AS FCreditQty ,\r\n");
        sql.append("        SUM(T1.FCreditFor) AS FCreditFor ,\r\n");
        sql.append("        SUM(T1.FCreditLocal) AS FCreditLocal,\r\n");
        sql.append("        SUM(T1.FCreditRpt) AS FCreditRpt ,\r\n");
        sql.append("        SUM(T1.FEndQty) AS FEndQty,\r\n");
        sql.append("        FBalanceOriention, \r\n");
        sql.append("        SUM(T1.FEndBalanceFor) AS FEndBalanceFor , \r\n");
        sql.append("        SUM(T1.FEndBalanceLocal) AS FEndBalanceLocal,\r\n");
        sql.append("        SUM(T1.FEndBalanceRpt) AS FEndBalanceRpt\r\n");
        sql.append(" from ").append(partner.getTempTableName()).append(" as T1");
        sql.append(" inner join t_bd_accountview tb ON tb.fid=t1.faccountid \r\n");
        sql.append(" and tb.FcompanyID in ").append(companyIdInClause);
        sql.append(" and tb.fisProfitCenter <> 1 ");
        sql.append(" and tb.FAccountTableId='").append(partner.getAccountTableId()).append("' \r\n");
        sql.append(" left join t_bd_accountview pav on tb.FNumber = PAV.FNumber \r\n");
        sql.append(" and tb.FAccountTableID = PAV.FAccountTableID ");
        sql.append(" and PAV.FCompanyID = '").append(companyId).append("'");
        sql.append(" where T1.fcompanyid in ").append(companyIdInClause);
        if (expandAccountNumber != null) {
            sql.append(" and T1.FAccountNumber='").append(expandAccountNumber).append("'");
        }
        if (sortNumber != null) {
            sql.append(" and T1.FPeriodSortNumber=").append(sortNumber);
        }
        if (periodYear != null && periodNumber != null) {
            sql.append(" and T1.FPeriod=").append(periodYear * 100 + periodNumber);
        }
        sql.append(" group by PAV.FID,tb.FNumber ,tb.FName_").append(partner.getContext().getLocale().toString()).append(",T1.FBalanceOriention,T1.FCurrencyID ,T1.FCurrencyNumber ,T1.FCurrencyName ,T1.FCurrencyPre,T1.FPeriod,T1.FPeriodSortNumber");
        DbUtil.execute((Context)partner.getContext(), (String)sql.toString());
        ReportConditionGeneralLedger condition = (ReportConditionGeneralLedger)partner.getFixCondition();
    }

    protected void insertNotUseAccount(ReportPartner partner, String strFirstTempTableName) throws EASBizException, BOSException {
        ReportConditionGeneralLedger condition = (ReportConditionGeneralLedger)partner.getFixCondition();
        Context ctx = partner.getContext();
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(strFirstTempTableName);
        sql.append(" \r\n");
        sql.append("SELECT T_Main.FAccountID,'' FCompanyID, T_Main.FCurrencyID , \r\n");
        sql.append("   T_Main.FPeriod FPeriod, \r\n");
        sql.append("   0.0 AS FBeginBalanceFor,0.0 AS FDebitFor,0.0 AS FCreditFor, \r\n");
        sql.append("   0.0 AS FYearDebitFor,0.0 AS FYearCreditFor, 0.0 AS FEndBalanceFor, \r\n");
        sql.append("   0.0 AS FBeginBalanceLocal,0.0 AS FDebitLocal,0.0 AS FCreditLocal,  \r\n");
        sql.append("   0.0 AS FYearDebitLocal, 0.0 AS FYearCreditLocal,0.0 AS FEndBalanceLocal, \r\n");
        sql.append("   0.0 AS FBeginBalanceRpt, 0.0 AS FDebitRpt, 0.0 AS FCreditRpt, \r\n");
        sql.append("   0.0 AS FYearDebitRpt, 0.0 AS FYearCreditRpt, 0.0 AS FEndBalanceRpt,  \r\n");
        sql.append("   0.0 AS FBeginQty, 0.0 AS FDebitQty, 0.0 AS FCreditQty, \r\n");
        sql.append("   0.0 AS FYearDebitQty, 0.0 AS FYearCreditQty, 0.0 AS FEndQty  \r\n");
        sql.append("\tFROM \r\n");
        sql.append("   (SELECT TA.FID AS FAccountID,TB.FPeriod, TA.FCurrencyID \r\n");
        sql.append("\tFROM  \r\n");
        sql.append("   (SELECT TACC.FID FID, TACC.FCurrencyID FROM T_BD_AccountView TACC \r\n");
        sql.append(RptServerUtil.innerJoinAccountPermissionSql("TACC", userID, companyID, ctx));
        sql.append("\tWHERE TACC.fcompanyid = ? AND TACC.FAccountTableId = ? \r\n ");
        sql.append("    AND TACC.fisProfitCenter <> 1 \r\n");
        sql.append("    AND TACC.FISLEAF = 1 \r\n");
        if (partner.getCurrencyType() == 0) {
            if (condition.getCurrencyID() == null) {
                sql.append(" AND ((TACC.FCurrencyID != '").append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID).append("'");
                sql.append(" AND TACC.FCurrencyID != '").append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID).append("'");
                sql.append(" ) OR TACC.FCurrencyID IS NULL) ");
            } else {
                sql.append(" AND (TACC.FCurrencyID = ? OR TACC.FCurrencyID IS NULL) \r\n");
            }
        }
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            sql.append(" AND TACC.FNumber >= ? \r\n");
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            sql.append(" AND TACC.FNumber <= ? \r\n");
        }
        sql.append(") TA, \r\n");
        sql.append("   (SELECT FNumber FPeriod \r\n");
        sql.append("\tFROM T_BD_Period  \r\n");
        sql.append("\tWHERE FTypeID = ? ");
        sql.append("    AND FNumber >= ? \r\n");
        sql.append("    AND FNumber <= ?\r\n");
        sql.append(") AS TB \r\n");
        sql.append("\t) AS T_Main  \r\n");
        sql.append("\tLEFT OUTER JOIN ").append(strFirstTempTableName).append(" AS T ON T_Main.FAccountID = T.FAccountID \r\n");
        sql.append("   AND T_Main.FPeriod = T.FPeriod \r\n");
        sql.append("   AND T_Main.FCurrencyID = T.FCurrencyID \r\n");
        sql.append("WHERE T.FAccountID is null \r\n");
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValueChar(partner.getCompany().getId().toString());
        parameter.addValueChar(partner.getAccountTableId());
        if (partner.getCurrencyType() == 0 && partner.getFixCondition().getCurrencyID() != null) {
            parameter.addValueChar(partner.getFixCondition().getCurrencyID());
        }
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            parameter.addValueVarchar(condition.getAccountCodeStart());
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            parameter.addValueVarchar(condition.getAccountCodeEnd() + "zz");
        }
        parameter.addValueId((CoreBaseInfo)partner.getCompany().getAccountPeriodType());
        parameter.addValue(new Integer(condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart()));
        parameter.addValue(new Integer(condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd()));
        DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(sql.toString()));
    }

    protected void insertNotUseAccountForVirtual(ReportPartner partner, String strFirstTempTableName) throws EASBizException, BOSException {
        ReportConditionGeneralLedger condition = (ReportConditionGeneralLedger)partner.getFixCondition();
        Context ctx = partner.getContext();
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(strFirstTempTableName);
        sql.append(" \r\n");
        sql.append("SELECT T_Main.FAccountID,T_Main.FCompanyID FCompanyID, T_Main.FCurrencyID , \r\n");
        sql.append("   T_Main.FPeriod, \r\n");
        sql.append("   0.0 AS FBeginBalanceFor,0.0 AS FDebitFor,0.0 AS FCreditFor, \r\n");
        sql.append("   0.0 AS FYearDebitFor,0.0 AS FYearCreditFor, 0.0 AS FEndBalanceFor, \r\n");
        sql.append("   0.0 AS FBeginBalanceLocal,0.0 AS FDebitLocal,0.0 AS FCreditLocal,  \r\n");
        sql.append("   0.0 AS FYearDebitLocal, 0.0 AS FYearCreditLocal,0.0 AS FEndBalanceLocal, \r\n");
        sql.append("   0.0 AS FBeginBalanceRpt, 0.0 AS FDebitRpt, 0.0 AS FCreditRpt, \r\n");
        sql.append("   0.0 AS FYearDebitRpt, 0.0 AS FYearCreditRpt, 0.0 AS FEndBalanceRpt,  \r\n");
        sql.append("   0.0 AS FBeginQty, 0.0 AS FDebitQty, 0.0 AS FCreditQty, \r\n");
        sql.append("   0.0 AS FYearDebitQty, 0.0 AS FYearCreditQty, 0.0 AS FEndQty  \r\n");
        sql.append("FROM \r\n");
        sql.append("   (SELECT distinct TA.FNumber,TA.FID AS FAccountID,tcompany.FID as FCompanyID, TB.FPeriod,'");
        if (condition.getCurrencyID() != null) {
            sql.append(condition.getCurrencyID());
        }
        sql.append("' FCurrencyID \r\n");
        sql.append("\tFROM  \r\n");
        sql.append("   (SELECT A.FID,A.FNumber,A.FCompanyID \r\n");
        sql.append("\tFROM T_BD_AccountView A \r\n");
        sql.append(RptServerUtil.innerJoinAccountPermissionSql("A", userID, companyID, ctx));
        sql.append("\tWHERE A.FAccountTableId = ? and a.fisProfitCenter <> 1 \r\n");
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            sql.append(" AND A.FNumber >= ? \r\n");
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            sql.append(" AND A.FNumber <= ? \r\n");
        }
        sql.append(") TA \r\n");
        sql.append("join t_org_company tcompany on TA.FCOMPANYID=tcompany.Fid and tcompany.fid in ");
        sql.append(partner.getPhysicalCompanyId(false));
        sql.append(", \r\n");
        sql.append("   (SELECT FNumber FPeriod \r\n");
        sql.append("\tFROM T_BD_Period  \r\n");
        sql.append("\tWHERE FTypeID = ? ");
        sql.append("    AND FNumber>=? \r\n");
        sql.append("    AND FNumber<=? \r\n");
        sql.append(") TB \r\n");
        sql.append("\t) T_Main \r\n");
        sql.append("\tLEFT OUTER JOIN \n( select B.FNumber,A.* from ");
        sql.append(strFirstTempTableName);
        sql.append(" A inner join t_bd_accountView B on B.FID=A.FAccountID ) T \r\n");
        sql.append("\tON T_Main.FNumber = T.FNumber \r\n");
        sql.append("   AND T_Main.FPeriod = T.FPeriod \r\n");
        sql.append("   AND T_Main.FCurrencyID = T.FCurrencyID \r\n");
        sql.append("   AND T_Main.FCompanyID = T.FCompanyID \r\n");
        sql.append("   WHERE T.FAccountID is null ");
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValueChar(partner.getAccountTableId());
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            parameter.addValueVarchar(condition.getAccountCodeStart());
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            parameter.addValueVarchar(condition.getAccountCodeEnd() + "zz");
        }
        parameter.addValueId((CoreBaseInfo)partner.getCompany().getAccountPeriodType());
        parameter.addValue(new Integer(condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart()));
        parameter.addValue(new Integer(condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd()));
        DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(sql.toString()));
    }

    protected void insertSecondData(ReportPartner partner, String strFirstTableName, String strTempTable) throws EASBizException, BOSException {
        SqlParameter2 parameter;
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" SELECT  TA.FID FAccountID,TA.FNumber  FAccountNumber,\r\n");
        strBuffer.append("    TA.FName");
        strBuffer.append(partner.getFieldNameExtend());
        strBuffer.append("    FAccountName ,\r\n");
        strBuffer.append("   '', M.FCurrencyID FCurrencyID, TC.FNumber FCurrencyNumber, TC.FName");
        strBuffer.append(partner.getFieldNameExtend());
        strBuffer.append("    FCurrencyName, TC.FPrecision FCurrencyPre, \r\n");
        strBuffer.append("    M.FPeriod FPeriod,\r\n");
        strBuffer.append("    0 FPeriodSortNumber,'' flevelnumber , 0.0 FDebitQty ,\r\n");
        strBuffer.append("    0.0 FDebitFor, 0.0 FDebitLocal,  0.0 FDebitRpt, \r\n");
        strBuffer.append("    0.0 FCreditQty, 0.0 FCreditFor,  0.0 FCreditLocal, \r\n");
        strBuffer.append("    0.0 FCreditRpt, \r\n");
        strBuffer.append("    M.FBeginQty FEndQty, TA.FDC FBalanceOriention,\r\n");
        strBuffer.append("    M.FBeginBalanceFor FEndBalanceFor, \r\n");
        strBuffer.append("    M.FBeginBalanceLocal FEndBalanceLocal, \r\n");
        strBuffer.append("    M.FBeginBalanceRpt FEndBalanceRpt \r\n");
        this.processInsertSecondData(0, strBuffer, partner, strFirstTableName, strTempTable);
        strBuffer.append(" FROM \t\r\n");
        strBuffer.append("   (SELECT T1.FAccountID ,T1.FCurrencyID ,T1.FPeriod,\r\n");
        strBuffer.append("        SUM(T1.FBeginBalanceFor) FBeginBalanceFor ,\r\n");
        strBuffer.append("        SUM(T1.FDebitFor) FDebitFor, \r\n");
        strBuffer.append("        SUM(T1.FCreditFor) FCreditFor ,\r\n");
        strBuffer.append("        SUM(T1.FYearDebitFor) FYearDebitFor ,\r\n");
        strBuffer.append("        SUM(T1.FYearCreditFor) FYearCreditFor ,\r\n");
        strBuffer.append("        SUM(T1.FEndBalanceFor) FEndBalanceFor , \r\n");
        strBuffer.append("        SUM(T1.FBeginBalanceLocal) FBeginBalanceLocal ,\r\n");
        strBuffer.append("        SUM(T1.FDebitLocal) FDebitLocal, \r\n");
        strBuffer.append("        SUM(T1.FCreditLocal) FCreditLocal,\r\n");
        strBuffer.append("        SUM(T1.FYearDebitLocal) FYearDebitLocal ,\r\n");
        strBuffer.append("        SUM(T1.FYearCreditLocal) FYearCreditLocal,\r\n");
        strBuffer.append("        SUM(T1.FEndBalanceLocal) FEndBalanceLocal,\r\n");
        strBuffer.append("        SUM(T1.FBeginBalanceRpt) FBeginBalanceRpt,\r\n");
        strBuffer.append("        SUM(T1.FDebitRpt) FDebitRpt, \r\n");
        strBuffer.append("        SUM(T1.FCreditRpt) FCreditRpt ,\r\n");
        strBuffer.append("        SUM(T1.FYearDebitRpt) FYearDebitRpt , \r\n");
        strBuffer.append("        SUM(T1.FYearCreditRpt) FYearCreditRpt ,\r\n");
        strBuffer.append("        SUM(T1.FEndBalanceRpt) FEndBalanceRpt,\r\n");
        strBuffer.append("        SUM(T1.FBeginQty) FBeginQty,\r\n");
        strBuffer.append("        SUM(T1.FDebitQty) FDebitQty, \r\n");
        strBuffer.append("        SUM(T1.FCreditQty) FCreditQty ,\r\n");
        strBuffer.append("        SUM(T1.FYearDebitQty) FYearDebitQty , \r\n");
        strBuffer.append("        SUM(T1.FYearCreditQty) FYearCreditQty,\r\n");
        strBuffer.append("        SUM(T1.FEndQty) FEndQty\r\n");
        strBuffer.append("\t  FROM ");
        strBuffer.append(strFirstTableName);
        strBuffer.append("  T1 INNER JOIN \r\n");
        strBuffer.append("  (SELECT distinct FAccountID FAccountID, min(FPeriod) FYearNumber from \r\n ");
        strBuffer.append(strFirstTableName);
        strBuffer.append(" GROUP BY FAccountid) T2 ON T1.FaccountId = T2.FaccountID AND (T1.FPeriod) = T2.FYearNumber \r\n");
        strBuffer.append(" GROUP BY T1.FAccountID ,T1.FCurrencyID,T1.FPeriod ) M \r\n");
        strBuffer.append(" INNER JOIN T_BD_AccountView TA ON M.FAccountID = TA.FID \r\n");
        strBuffer.append(" LEFT JOIN t_BD_CURRENCY TC ON M.FCurrencyID = TC.FID \r\n");
        strBuffer.append(" WHERE TA.FAccountTableID = ?  \r\n");
        strBuffer.append(" AND TA.fisProfitCenter <> 1  \r\n");
        strBuffer.append(" AND TA.FLevel >= ? \r\n");
        strBuffer.append(" AND TA.FLevel <= ? \r\n");
        ReportConditionGeneralLedger condition = (ReportConditionGeneralLedger)partner.getFixCondition();
        String strInsert = "insert into " + strTempTable + strBuffer.toString();
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            cn = partner.getConnection();
            stmt = cn.prepareStatement(strInsert);
            parameter = new SqlParameter2();
            parameter.addValueChar(partner.getAccountTableId());
            parameter.addValue(condition.getAccountLevelStart());
            parameter.addValue(condition.getAccountLevelEnd());
            DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(strInsert));
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)sqle);
                sqle.setNextException(new SQLException("The query sql is:" + strInsert));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)stmt);
        strBuffer = new StringBuffer();
        strBuffer.append(" SELECT TA.FID FAccountID,TA.FNumber  FAccountNumber,\r\n");
        strBuffer.append("    TA.FName");
        strBuffer.append(partner.getFieldNameExtend());
        strBuffer.append(" FAccountName ,\r\n");
        strBuffer.append(" '',   M.FCurrencyID FCurrencyID, TC.FNumber FCurrencyNumber, TC.FName");
        strBuffer.append(partner.getFieldNameExtend());
        strBuffer.append("    FCurrencyName, TC.FPrecision FCurrencyPre, \r\n");
        strBuffer.append("    M.FPeriod FPeriodY, \r\n");
        strBuffer.append("    1 FPeriodSortNumber,'' flevelnumber ,\r\n ");
        strBuffer.append("    M.FDebitQty FDebitQty , M.FDebitFor FDebitFor, \r\n");
        strBuffer.append("    M.FDebitLocal FDebitLocal, M.FDebitRpt FDebitRpt, \r\n");
        strBuffer.append("    M.FCreditQty FCreditQty,  M.FCreditFor FCreditFor, \r\n");
        strBuffer.append("    M.FCreditLocal FCreditLocal, M.FCreditRpt FCreditRpt, \r\n");
        strBuffer.append("    M.FEndQty FEndQty,  TA.FDC FBalanceOriention,\r\n");
        strBuffer.append("    M.FEndBalanceFor FEndBalanceFor,  M.FEndBalanceLocal FEndBalanceLocal, \r\n");
        strBuffer.append("    M.FEndBalanceRpt FEndBalanceRpt \r\n");
        this.processInsertSecondData(1, strBuffer, partner, strFirstTableName, strTempTable);
        strBuffer.append(" FROM  \r\n");
        strBuffer.append("    (SELECT FAccountID ,FCurrencyID ,FPeriod,\r\n");
        strBuffer.append("        SUM(FBeginBalanceFor) FBeginBalanceFor ,\r\n");
        strBuffer.append("        SUM(FDebitFor) FDebitFor, SUM(FCreditFor) FCreditFor ,\r\n");
        strBuffer.append("        SUM(FYearDebitFor) FYearDebitFor ,\r\n");
        strBuffer.append("        SUM(FYearCreditFor) FYearCreditFor ,\r\n");
        strBuffer.append("        SUM(FEndBalanceFor) FEndBalanceFor , \r\n");
        strBuffer.append("        SUM(FBeginBalanceLocal) FBeginBalanceLocal ,\r\n");
        strBuffer.append("        SUM(FDebitLocal) FDebitLocal,\r\n");
        strBuffer.append("        SUM(FCreditLocal) FCreditLocal,\r\n");
        strBuffer.append("        SUM(FYearDebitLocal) FYearDebitLocal ,\r\n");
        strBuffer.append("        SUM(FYearCreditLocal) FYearCreditLocal,\r\n");
        strBuffer.append("        SUM(FEndBalanceLocal) FEndBalanceLocal,\r\n");
        strBuffer.append("        SUM(FBeginBalanceRpt) FBeginBalanceRpt,\r\n");
        strBuffer.append("        SUM(FDebitRpt) FDebitRpt, \r\n");
        strBuffer.append("        SUM(FCreditRpt) FCreditRpt ,\r\n");
        strBuffer.append("        SUM(FYearDebitRpt) FYearDebitRpt , \r\n");
        strBuffer.append("        SUM(FYearCreditRpt) FYearCreditRpt ,\r\n");
        strBuffer.append("        SUM(FEndBalanceRpt) FEndBalanceRpt,\r\n");
        strBuffer.append("        SUM(FBeginQty) FBeginQty,\r\n");
        strBuffer.append("        SUM(FDebitQty) FDebitQty, \r\n");
        strBuffer.append("        SUM(FCreditQty) FCreditQty ,\r\n");
        strBuffer.append("        SUM(FYearDebitQty) FYearDebitQty , \r\n");
        strBuffer.append("        SUM(FYearCreditQty) FYearCreditQty,\r\n");
        strBuffer.append("        SUM(FEndQty) FEndQty\r\n");
        strBuffer.append("\t   FROM ");
        strBuffer.append(strFirstTableName);
        strBuffer.append("  \r\n");
        strBuffer.append("\t   GROUP BY FAccountID ,FCurrencyID,FPeriod ) M \r\n");
        strBuffer.append("     INNER JOIN T_BD_AccountView TA ON M.FAccountID = TA.FID \r\n");
        strBuffer.append("     LEFT JOIN t_BD_CURRENCY TC ON M.FCurrencyID = TC.FID \r\n");
        strBuffer.append("     WHERE \r\n");
        strBuffer.append("\t      TA.FAccountTableID = ?  \r\n");
        strBuffer.append("        AND TA.fisProfitCenter <> 1  \r\n");
        strBuffer.append("        AND TA.FLevel >= ? \r\n");
        strBuffer.append("        AND TA.FLevel <= ? \r\n");
        if (condition.isOptionNoDisplayZeroTotal()) {
            strBuffer.append(" AND (M.FDebitLocal<>0 OR M.FCreditLocal<>0 OR M.FDebitFor<>0 OR M.FCreditFor<>0)");
        }
        strInsert = "insert into " + strTempTable + strBuffer.toString();
        try {
            cn = partner.getConnection();
            stmt = cn.prepareStatement(strInsert);
            parameter = new SqlParameter2();
            parameter.addValueChar(partner.getAccountTableId());
            parameter.addValue(condition.getAccountLevelStart());
            parameter.addValue(condition.getAccountLevelEnd());
            DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(strInsert));
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            sqle.setNextException(new SQLException("The query sql is:" + strInsert));
            throw new SQLDataException(sqle);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
        strBuffer = new StringBuffer();
        strBuffer.append(" SELECT  TA.FID FAccountID,TA.FNumber  FAccountNumber,\r\n");
        strBuffer.append("   TA.FName");
        strBuffer.append(partner.getFieldNameExtend());
        strBuffer.append("   FAccountName ,\r\n");
        strBuffer.append("  '',  M.FCurrencyID FCurrencyID, TC.FNumber FCurrencyNumber, TC.FName");
        strBuffer.append(partner.getFieldNameExtend());
        strBuffer.append("    FCurrencyName, TC.FPrecision FCurrencyPre, \r\n");
        strBuffer.append("    M.FPeriod,\r\n");
        strBuffer.append("    2 FPeriodSortNumber,'' flevelnumber ,\r\n ");
        strBuffer.append("    FYearDebitQty  FDebitQty, M.FYearDebitFor FDebitFor, \r\n");
        strBuffer.append("    M.FYearDebitLocal FDebitLocal, M.FYearDebitRpt FDebitRpt, \r\n");
        strBuffer.append("    M.FYearCreditQty FCreditQty, M.FYearCreditFor FCreditFor, \r\n");
        strBuffer.append("    M.FYearCreditLocal FCreditLocal, M.FYearCreditRpt FCreditRpt, \r\n");
        strBuffer.append("    M.FEndQty FEndQty,  TA.FDC FBalanceOriention,\r\n");
        strBuffer.append("    M.FEndBalanceFor FEndBalanceFor, M.FEndBalanceLocal FEndBalanceLocal, \r\n");
        strBuffer.append("    M.FEndBalanceRpt FEndBalanceRpt \r\n");
        this.processInsertSecondData(2, strBuffer, partner, strFirstTableName, strTempTable);
        strBuffer.append(" FROM  \r\n");
        strBuffer.append("\t  (SELECT FAccountID ,FCurrencyID ,FPeriod,\r\n");
        strBuffer.append("        SUM(FBeginBalanceFor) FBeginBalanceFor ,\r\n");
        strBuffer.append("        SUM(FDebitFor) FDebitFor, SUM(FCreditFor) FCreditFor ,\r\n");
        strBuffer.append("        SUM(FYearDebitFor) FYearDebitFor ,SUM(FYearCreditFor) FYearCreditFor ,\r\n");
        strBuffer.append("        SUM(FEndBalanceFor) FEndBalanceFor , \r\n");
        strBuffer.append("        SUM(FBeginBalanceLocal) FBeginBalanceLocal ,\r\n");
        strBuffer.append("        SUM(FDebitLocal) FDebitLocal,SUM(FCreditLocal) FCreditLocal,\r\n");
        strBuffer.append("        SUM(FYearDebitLocal) FYearDebitLocal ,\r\n");
        strBuffer.append("        SUM(FYearCreditLocal) FYearCreditLocal,\r\n");
        strBuffer.append("        SUM(FEndBalanceLocal) FEndBalanceLocal,\r\n");
        strBuffer.append("        SUM(FBeginBalanceRpt) FBeginBalanceRpt,\r\n");
        strBuffer.append("        SUM(FDebitRpt) FDebitRpt, SUM(FCreditRpt) FCreditRpt ,\r\n");
        strBuffer.append("        SUM(FYearDebitRpt) FYearDebitRpt , SUM(FYearCreditRpt) FYearCreditRpt ,\r\n");
        strBuffer.append("        SUM(FEndBalanceRpt) FEndBalanceRpt,\r\n");
        strBuffer.append("        SUM(FBeginQty) FBeginQty,\r\n");
        strBuffer.append("        SUM(FDebitQty) FDebitQty, SUM(FCreditQty) FCreditQty ,\r\n");
        strBuffer.append("        SUM(FYearDebitQty) FYearDebitQty , SUM(FYearCreditQty) FYearCreditQty,\r\n");
        strBuffer.append("        SUM(FEndQty) FEndQty\r\n");
        strBuffer.append("\t   FROM  \r\n");
        strBuffer.append(strFirstTableName);
        strBuffer.append("   \r\n");
        strBuffer.append("\t   GROUP BY FAccountID ,FCurrencyID,FPeriod ) M \r\n");
        strBuffer.append("     INNER JOIN T_BD_AccountView TA ON M.FAccountID = TA.FID \r\n");
        strBuffer.append("     LEFT JOIN t_BD_CURRENCY TC ON M.FCurrencyID = TC.FID \r\n");
        strBuffer.append(" WHERE \r\n");
        strBuffer.append("\t   TA.FAccountTableID = ?  \r\n");
        strBuffer.append("     AND TA.fisProfitCenter <> 1  \r\n");
        strBuffer.append("     AND TA.FLevel >= ? \r\n");
        strBuffer.append("     AND TA.FLevel <= ? \r\n");
        if (condition.isOptionNoDisplayZeroTotal()) {
            strBuffer.append(" AND (M.FDebitLocal<>0 OR M.FCreditLocal<>0 OR M.FDebitFor<>0 OR M.FCreditFor<>0)");
        }
        strInsert = "insert into " + strTempTable + strBuffer.toString();
        try {
            cn = partner.getConnection();
            stmt = cn.prepareStatement(strInsert);
            parameter = new SqlParameter2();
            parameter.addValueChar(partner.getAccountTableId());
            parameter.addValue(condition.getAccountLevelStart());
            parameter.addValue(condition.getAccountLevelEnd());
            DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(strInsert));
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            sqle.setNextException(new SQLException("The query sql is:" + strInsert));
            throw new SQLDataException(sqle);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
        if (condition.getCurrencyID() == null && condition.isShowTotal()) {
            strBuffer = new StringBuffer();
            strBuffer.append(" SELECT  FAccountID,FAccountNumber,FAccountName ,\r\n");
            strBuffer.append("  '',  'xiaojiID', N'").append(GlUtils.getMaxChar()).append("' FCurrencyNumber, ");
            strBuffer.append("  N'").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"subtotal", (Locale)partner.getContext().getLocale())).append("' FCurrencyName,\r\n");
            strBuffer.append("  0 FCurrencyPre, ");
            strBuffer.append("    FPeriod,\r\n");
            strBuffer.append("    FPeriodSortNumber,\r\n ");
            strBuffer.append("    flevelnumber,\r\n ");
            strBuffer.append("    sum(FDebitQty)  FDebitQty, to_decimal(null) FDebitFor, \r\n");
            strBuffer.append("    sum(FDebitLocal) FDebitLocal, sum(FDebitRpt) FDebitRpt, \r\n");
            strBuffer.append("    sum(FCreditQty) FCreditQty, to_decimal(null) FCreditFor, \r\n");
            strBuffer.append("    sum(FCreditLocal) FCreditLocal, sum(FCreditRpt) FCreditRpt, \r\n");
            strBuffer.append("    sum(FEndQty) FEndQty,  FBalanceOriention,\r\n");
            strBuffer.append("    to_decimal(null) FEndBalanceFor, sum(FEndBalanceLocal) FEndBalanceLocal, \r\n");
            strBuffer.append("    sum(FEndBalanceRpt) FEndBalanceRpt \r\n");
            strBuffer.append("\t   FROM  \r\n");
            strBuffer.append(strTempTable).append(" \r\n");
            strBuffer.append("\t   GROUP BY FAccountID,FAccountNumber,FAccountName,FBalanceOriention,FPeriod,FPeriodSortNumber,flevelnumber \r\n");
            strInsert = "insert into " + strTempTable + strBuffer.toString();
            DbUtil.execute((Context)partner.getContext(), (String)strInsert);
        }
        if (!GlUtils.isCompanyUnion(partner.getCompany())) {
            stmt = this.doAfterCurrPeriodData(partner, strTempTable, condition);
        }
        strBuffer = new StringBuffer();
        strBuffer.append("\tdelete  \r\n");
        strBuffer.append(strTempTable);
        strBuffer.append("  where fcurrencynumber is null  \r\n");
        strBuffer.append("\tand exists (select 1 from ( \r\n");
        strBuffer.append("  select  \r\n");
        strBuffer.append("     fcurrencyid as fcurrencyid2 , \r\n");
        strBuffer.append("     faccountnumber as faccountnumber2, \r\n");
        strBuffer.append("     FPeriod as FPeriod2, FPeriodSortNumber as FPeriodSortNumber2, \r\n");
        strBuffer.append("\t   fDebitFor as fDebitFor2, fDebitLocal as fDebitLocal2, \r\n");
        strBuffer.append("     fDebitRpt as fDebitRpt2, fCreditFor as fCreditFor2, \r\n");
        strBuffer.append("     fCreditLocal as fCreditLocal2, fCreditRpt as fCreditRpt2, \r\n");
        strBuffer.append("     FEndBalanceFor as FEndBalanceFor2, FEndBalanceLocal as FEndBalanceLocal2, \r\n");
        strBuffer.append("     FEndBalanceRpt as FEndBalanceRpt2 from  \r\n");
        strBuffer.append(strTempTable);
        strBuffer.append("     ) b where faccountnumber = b.faccountnumber2 and \r\n");
        strBuffer.append("     FPeriod = b.FPeriod2 \r\n");
        strBuffer.append("     and FPeriodSortNumber = b.FPeriodSortNumber2 and  \r\n");
        strBuffer.append("     (fDebitFor2<>0 or fDebitLocal2<>0 or fDebitRpt2<>0 or fCreditFor2<>0 or fCreditLocal2<>0 or  \r\n");
        strBuffer.append("     fCreditRpt2<>0 or FEndBalanceFor2<>0 or FEndBalanceLocal2<>0 or FEndBalanceRpt2<>0 or fcurrencyid2 is not null) \r\n");
        strBuffer.append("     ) \r\n");
        try {
            cn = partner.getConnection();
            stmt = cn.prepareStatement(strBuffer.toString());
            parameter = new SqlParameter2();
            DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(strBuffer.toString()));
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            sqle.setNextException(new SQLException("The query sql is:" + strBuffer));
            throw new SQLDataException(sqle);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
    }

    private PreparedStatement doAfterCurrPeriodData(ReportPartner partner, String strTempTable, ReportConditionGeneralLedger condition) throws BOSException, EASBizException, SQLDataException {
        Connection cn;
        StringBuffer updateBalance;
        int queryBeginPeriodOrder;
        int curPeriodOrder;
        int toYear;
        int curYear;
        ResultSet rs;
        PreparedStatement stmt;
        block33: {
            SqlParameter2 parameter;
            stmt = null;
            rs = null;
            Context ctx = partner.getContext();
            PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)partner.getCompany(), (Context)ctx);
            curYear = pe.getCurrentYear();
            toYear = condition.getPeriodYearEnd();
            curPeriodOrder = pe.getCurrentYear() * 100 + pe.getCurrentPeriod();
            queryBeginPeriodOrder = condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart();
            if (!condition.isNotIncludePLVoucher()) break block33;
            updateBalance = new StringBuffer();
            updateBalance.append(" update  ").append(strTempTable).append(" set ");
            this.updatePeriodEndBalanceBeforeCur(updateBalance, strTempTable, "For", queryBeginPeriodOrder);
            this.updatePeriodEndBalanceBeforeCur(updateBalance, strTempTable, "Local", queryBeginPeriodOrder);
            this.updatePeriodEndBalanceBeforeCur(updateBalance, strTempTable, "Rpt", queryBeginPeriodOrder);
            this.updatePeriodEndBalanceBeforeCur(updateBalance, strTempTable, "Qty", queryBeginPeriodOrder);
            updateBalance.deleteCharAt(updateBalance.length() - 1);
            updateBalance.append(" where fperiod >").append(queryBeginPeriodOrder);
            updateBalance.append(" and fperiod <= ").append(curPeriodOrder);
            updateBalance.append(" and fperiodsortnumber = 1");
            try {
                cn = partner.getConnection();
                stmt = cn.prepareStatement(updateBalance.toString());
                parameter = new SqlParameter2();
                DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(updateBalance.toString()));
            }
            catch (SQLException sqle) {
                try {
                    logger.error((Object)sqle);
                    sqle.setNextException(new SQLException("The query sql is:" + updateBalance));
                    throw new SQLDataException(sqle);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup(rs, (Statement)stmt);
            updateBalance.setLength(0);
            updateBalance.append(" update  ").append(strTempTable).append(" set ");
            this.updateYearEndBalanceBeforeCur(updateBalance, strTempTable, "For");
            this.updateYearEndBalanceBeforeCur(updateBalance, strTempTable, "Local");
            this.updateYearEndBalanceBeforeCur(updateBalance, strTempTable, "Rpt");
            this.updateYearEndBalanceBeforeCur(updateBalance, strTempTable, "Qty");
            updateBalance.deleteCharAt(updateBalance.length() - 1);
            updateBalance.append(" where fperiod >").append(queryBeginPeriodOrder);
            updateBalance.append(" and fperiod <= ").append(curPeriodOrder);
            updateBalance.append(" and fperiodsortnumber = 2");
            try {
                cn = partner.getConnection();
                stmt = cn.prepareStatement(updateBalance.toString());
                parameter = new SqlParameter2();
                DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(updateBalance.toString()));
            }
            catch (SQLException sqle) {
                logger.error((Object)sqle);
                sqle.setNextException(new SQLException("The query sql is:" + updateBalance));
                throw new SQLDataException(sqle);
            }
            finally {
                SQLUtils.cleanup(rs, (Statement)stmt);
            }
        }
        if (condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd() > curPeriodOrder) {
            SqlParameter2 parameter;
            updateBalance = new StringBuffer();
            updateBalance.append(" update  ").append(strTempTable).append(" set   ");
            class MyInnerClass {
                private String tempTableName = null;

                MyInnerClass(String tempTable) {
                    this.tempTableName = tempTable;
                }

                private void setYearUpdt(StringBuffer sql, String yearcolumn, String column) {
                    sql.append("\n ").append(yearcolumn).append(" = ").append(" to_decimal(0.0,19,4)   ");
                    sql.append("\n + (select sum(").append(column).append(") from ").append(this.tempTableName);
                    sql.append(" ta where ta.fperiod <= ").append(this.tempTableName);
                    sql.append(".fperiod ");
                    sql.append(" and fperiod >").append(curPeriodOrder).append(" and ta.faccountid = ");
                    sql.append(this.tempTableName).append(".faccountid and ta.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid and fperiodsortnumber = 1 ").append(" )");
                    sql.append("\n      +  case when (select ").append(yearcolumn).append(" from ").append(this.tempTableName).append(" tb ");
                    sql.append(" where tb.fperiod = ").append(curPeriodOrder).append(" and tb.faccountid = ");
                    sql.append(this.tempTableName).append(".faccountid and tb.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid and tb.fperiodsortnumber = 2 ");
                    sql.append(" ) is null then to_decimal(0.0,19,4) ").append(" else (select ").append(yearcolumn);
                    sql.append(" from ").append(this.tempTableName).append(" tb ").append(" where tb.fperiod = ");
                    sql.append(curPeriodOrder).append(" and tb.faccountid = ").append(this.tempTableName).append(".faccountid and tb.fcurrencyid = ");
                    sql.append(this.tempTableName).append(".fcurrencyid and tb.fperiodsortnumber = 2 ").append(" ) end ,");
                }

                private void setEndUpdt(StringBuffer sql, String yearcolumn, String endcolumn) {
                    sql.append("\n ").append(endcolumn).append(" = ").append(" case when fperiodsortnumber = 2 then(to_decimal(0.0,19,4)   ");
                    sql.append(" + ").append(yearcolumn);
                    sql.append("\n      - ISNULL((select ").append(yearcolumn).append(" from ").append(this.tempTableName).append(" tb ").append(" where tb.fperiod = ").append(curPeriodOrder).append(" and tb.faccountid = ").append(this.tempTableName).append(".faccountid and tb.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid and tb.fperiodsortnumber = 2");
                    sql.append(" ),0.0000)");
                    sql.append(" \n     + ISNULL((select ").append(endcolumn).append(" from ").append(this.tempTableName).append(" tc ").append(" where tc.fperiod = ").append(curPeriodOrder).append(" and tc.faccountid = ").append(this.tempTableName).append(".faccountid and tc.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid and  tc.fperiodsortnumber = 1");
                    sql.append(" ),0.0000)) ");
                    sql.append(" \n  else  ISNULL((select ").append(endcolumn).append(" from ").append(this.tempTableName).append(" tc ").append(" where tc.fperiod = ").append(queryBeginPeriodOrder).append(" and tc.faccountid = ").append(this.tempTableName).append(".faccountid and tc.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid and  tc.fperiodsortnumber = 1");
                    sql.append(" ),0.0000)");
                    sql.append("\n + ISNULL((select sum(").append(yearcolumn).append(") from ").append(this.tempTableName).append(" ta where ta.fperiod <= ").append(this.tempTableName).append(".fperiod ").append(" and fperiod >").append(queryBeginPeriodOrder).append(" and ta.faccountid = ").append(this.tempTableName).append(".faccountid and ta.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid and fperiodsortnumber = 1 ");
                    sql.append(" ),0.0000) end,");
                }
            }
            MyInnerClass myInner = new MyInnerClass(strTempTable);
            myInner.setYearUpdt(updateBalance, "Fdebitqty", "Fdebitqty");
            myInner.setYearUpdt(updateBalance, "Fdebitfor", "Fdebitfor");
            myInner.setYearUpdt(updateBalance, "Fdebitlocal", "Fdebitlocal");
            myInner.setYearUpdt(updateBalance, "Fdebitrpt", "Fdebitrpt");
            myInner.setYearUpdt(updateBalance, "Fcreditqty", "Fcreditqty");
            myInner.setYearUpdt(updateBalance, "Fcreditfor", "Fcreditfor");
            myInner.setYearUpdt(updateBalance, "Fcreditlocal", "Fcreditlocal");
            myInner.setYearUpdt(updateBalance, "Fcreditrpt", "Fcreditrpt");
            updateBalance.deleteCharAt(updateBalance.length() - 1);
            updateBalance.append("\r\nwhere fperiod >").append(curPeriodOrder);
            if (curYear < toYear) {
                updateBalance.append(" and fperiod < ").append((curYear + 1) * 100);
            }
            updateBalance.append(" and fperiodsortnumber = 2 ");
            try {
                cn = partner.getConnection();
                stmt = cn.prepareStatement(updateBalance.toString());
                parameter = new SqlParameter2();
                DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(updateBalance.toString()));
            }
            catch (SQLException sqle) {
                logger.error((Object)sqle);
                sqle.setNextException(new SQLException("The query sql is:" + updateBalance));
                throw new SQLDataException(sqle);
            }
            finally {
                SQLUtils.cleanup(rs, (Statement)stmt);
            }
            updateBalance.setLength(0);
            updateBalance.append(" update  ").append(strTempTable).append(" set   ");
            myInner.setEndUpdt(updateBalance, "Fdebitfor - Fcreditfor", "FEndBalanceFor");
            myInner.setEndUpdt(updateBalance, "FdebitLocal - FcreditLocal", "FEndBalanceLocal");
            myInner.setEndUpdt(updateBalance, "FdebitRpt - FcreditRpt", "FEndBalanceRpt");
            myInner.setEndUpdt(updateBalance, "Fdebitqty - Fcreditqty", "FEndqty");
            updateBalance.deleteCharAt(updateBalance.length() - 1);
            updateBalance.append("\r\nwhere fperiod >").append(curPeriodOrder);
            if (curYear < toYear) {
                updateBalance.append(" and fperiod < ").append((curYear + 1) * 100);
            }
            updateBalance.append(" and (fperiodsortnumber =1 or fperiodsortnumber =2 )");
            try {
                cn = partner.getConnection();
                stmt = cn.prepareStatement(updateBalance.toString());
                parameter = new SqlParameter2();
                DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(updateBalance.toString()));
            }
            catch (SQLException sqle) {
                logger.error((Object)sqle);
                sqle.setNextException(new SQLException("The query sql is:" + updateBalance));
                throw new SQLDataException(sqle);
            }
            finally {
                SQLUtils.cleanup(rs, (Statement)stmt);
            }
            if (curYear < toYear) {
                SqlParameter2 parameter2;
                class MyInnerClass0 {
                    private String tempTableName = null;

                    MyInnerClass0(String tempTable) {
                        this.tempTableName = tempTable;
                    }

                    private void setYearUpdt(StringBuffer sql, String yearcolumn, String column) {
                        sql.append("\n ").append(yearcolumn).append(" = ").append(" to_decimal(0.0,19,4)   ");
                        sql.append("\n + (select sum(").append(column).append(") from ").append(this.tempTableName);
                        sql.append(" ta where ta.fperiod <= ").append(this.tempTableName);
                        sql.append(".fperiod ");
                        sql.append(" and fperiod >= ").append((curYear + 1) * 100).append(" and ta.faccountid = ");
                        sql.append(this.tempTableName).append(".faccountid and ta.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid and fperiodsortnumber = 1 ");
                        sql.append(" )  ,");
                    }

                    private void setEndUpdt(StringBuffer sql, String yearcolumn, String endcolumn) {
                        sql.append("\n ").append(endcolumn).append(" = ").append(" case when fperiodsortnumber = 2 then(to_decimal(0.0,19,4)   ");
                        sql.append(" + ").append(yearcolumn);
                        sql.append("\n + ISNULL((select sum(").append(yearcolumn).append(") from ").append(this.tempTableName).append(" td where ( ");
                        sql.append("  td.fperiod < ").append((curYear + 1) * 100).append(")");
                        sql.append(" and fperiod >").append(curPeriodOrder).append(" and td.faccountid = ").append(this.tempTableName).append(".faccountid and td.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid and fperiodsortnumber = 1 ");
                        sql.append(" ),0.0000)");
                        sql.append(" \n     + ISNULL((select ").append(endcolumn).append(" from ").append(this.tempTableName).append(" tc ").append(" where tc.fperiod = ").append(curPeriodOrder).append(" and tc.faccountid = ").append(this.tempTableName).append(".faccountid and tc.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid and  tc.fperiodsortnumber = 1");
                        sql.append(" ),0.0000)) ");
                        sql.append(" \n  else  ISNULL((select ").append(endcolumn).append(" from ").append(this.tempTableName).append(" tc ").append(" where tc.fperiod = ").append(queryBeginPeriodOrder).append(" and tc.faccountid = ").append(this.tempTableName).append(".faccountid and tc.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid and  tc.fperiodsortnumber = 1");
                        sql.append(" ),0.0000)");
                        sql.append("\n + ISNULL((select sum(").append(yearcolumn).append(") from ").append(this.tempTableName).append(" ta where ta.fperiod <= ").append(this.tempTableName).append(".fperiod ").append(" and fperiod >").append(queryBeginPeriodOrder).append(" and ta.faccountid = ").append(this.tempTableName).append(".faccountid and ta.fcurrencyid = ").append(this.tempTableName).append(".fcurrencyid and fperiodsortnumber = 1 ");
                        sql.append(" ),0.0000) end,");
                    }
                }
                MyInnerClass0 myInner0 = new MyInnerClass0(strTempTable);
                updateBalance.setLength(0);
                updateBalance.append(" update  ").append(strTempTable).append(" set   ");
                myInner0.setYearUpdt(updateBalance, "Fdebitqty", "Fdebitqty");
                myInner0.setYearUpdt(updateBalance, "Fdebitfor", "Fdebitfor");
                myInner0.setYearUpdt(updateBalance, "Fdebitlocal", "Fdebitlocal");
                myInner0.setYearUpdt(updateBalance, "Fdebitrpt", "Fdebitrpt");
                myInner0.setYearUpdt(updateBalance, "Fcreditqty", "Fcreditqty");
                myInner0.setYearUpdt(updateBalance, "Fcreditfor", "Fcreditfor");
                myInner0.setYearUpdt(updateBalance, "Fcreditlocal", "Fcreditlocal");
                myInner0.setYearUpdt(updateBalance, "Fcreditrpt", "Fcreditrpt");
                updateBalance.deleteCharAt(updateBalance.length() - 1);
                updateBalance.append("\r\nwhere fperiod >= ").append((curYear + 1) * 100);
                updateBalance.append(" and fperiodsortnumber = 2 ");
                try {
                    cn = partner.getConnection();
                    stmt = cn.prepareStatement(updateBalance.toString());
                    parameter2 = new SqlParameter2();
                    DbUtil.execute((Context)partner.getContext(), (String)parameter2.getSqlWithParameters(updateBalance.toString()));
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                    sqle.setNextException(new SQLException("The query sql is:" + updateBalance));
                    throw new SQLDataException(sqle);
                }
                finally {
                    SQLUtils.cleanup(rs, (Statement)stmt);
                }
                updateBalance.setLength(0);
                updateBalance.append(" update  ").append(strTempTable).append(" set   ");
                myInner0.setEndUpdt(updateBalance, "Fdebitfor - Fcreditfor", "FEndBalanceFor");
                myInner0.setEndUpdt(updateBalance, "FdebitLocal - FcreditLocal", "FEndBalanceLocal");
                myInner0.setEndUpdt(updateBalance, "FdebitRpt - FcreditRpt", "FEndBalanceRpt");
                myInner0.setEndUpdt(updateBalance, "Fdebitqty - Fcreditqty", "FEndqty");
                updateBalance.deleteCharAt(updateBalance.length() - 1);
                updateBalance.append("\r\nwhere fperiod >= ").append((curYear + 1) * 100);
                updateBalance.append(" and (fperiodsortnumber =1 or fperiodsortnumber =2 )");
                try {
                    cn = partner.getConnection();
                    stmt = cn.prepareStatement(updateBalance.toString());
                    parameter2 = new SqlParameter2();
                    DbUtil.execute((Context)partner.getContext(), (String)parameter2.getSqlWithParameters(updateBalance.toString()));
                }
                catch (SQLException sqle) {
                    logger.error((Object)sqle);
                    sqle.setNextException(new SQLException("The query sql is:" + updateBalance));
                    throw new SQLDataException(sqle);
                }
                finally {
                    SQLUtils.cleanup(rs, (Statement)stmt);
                }
            }
        }
        return stmt;
    }

    private void updatePeriodEndBalanceBeforeCur(StringBuffer sql, String tempTableName, String suffix, int queryBeginPeriodOrder) {
        String endFiledName = ("Qty".equals(suffix) ? "FEnd" : "FEndBalance") + suffix;
        sql.append(endFiledName).append(" = ").append(" ISNULL((select ").append(endFiledName).append(" from ").append(tempTableName).append(" tc ").append(" where tc.fperiod = ").append(queryBeginPeriodOrder);
        sql.append(" and tc.faccountid = ").append(tempTableName).append(".faccountid and tc.fcurrencyid = ").append(tempTableName).append(".fcurrencyid and  tc.fperiodsortnumber = 1");
        sql.append(" ),0.0000)");
        sql.append(" \n + ISNULL((select sum(").append("Fdebit").append(suffix).append(" - Fcredit").append(suffix).append(") from ").append(tempTableName);
        sql.append(" ta where ta.fperiod <= ").append(tempTableName).append(".fperiod ").append(" and fperiod >").append(queryBeginPeriodOrder);
        sql.append(" and ta.faccountid = ").append(tempTableName).append(".faccountid and ta.fcurrencyid = ").append(tempTableName).append(".fcurrencyid and fperiodsortnumber = 1 ");
        sql.append(" ),0.0000),");
    }

    private void updateYearEndBalanceBeforeCur(StringBuffer sql, String tempTableName, String suffix) {
        String endFiledName = ("Qty".equals(suffix) ? "FEnd" : "FEndBalance") + suffix;
        sql.append(endFiledName).append(" = ").append(" (ISNULL((select ").append(endFiledName).append(" from ").append(tempTableName).append(" tc ");
        sql.append(" where tc.fperiod = ").append(tempTableName).append(".fperiod and tc.faccountid = ").append(tempTableName).append(".faccountid and tc.fcurrencyid = ").append(tempTableName).append(".fcurrencyid and tc.fperiodsortnumber = 1");
        sql.append(" ),0.0000)),");
    }

    protected void insertSecondDataForVirtual(ReportPartner partner, String strFirstTableName, String strTempTable) throws EASBizException, BOSException {
        SqlParameter2 parameter;
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" SELECT  TA.FID FAccountID,TA.FNumber  FAccountNumber,\r\n");
        strBuffer.append("    TA.FName");
        strBuffer.append(partner.getFieldNameExtend());
        strBuffer.append("    FAccountName ,\r\n");
        strBuffer.append("    M.FCompanyID FCompanyID,M.FCurrencyID FCurrencyID, TC.FNumber FCurrencyNumber, TC.FName");
        strBuffer.append(partner.getFieldNameExtend());
        strBuffer.append("    FCurrencyName,TC.FPrecision FCurrencyPre, \r\n");
        strBuffer.append("    M.FPeriod,\r\n");
        strBuffer.append("    0 FPeriodSortNumber,CP.FLongNumber flevelnumber, 0.0 FDebitQty ,\r\n");
        strBuffer.append("    0.0 FDebitFor, 0.0 FDebitLocal,  0.0 FDebitRpt, \r\n");
        strBuffer.append("    0.0 FCreditQty, 0.0 FCreditFor,  0.0 FCreditLocal, \r\n");
        strBuffer.append("    0.0 FCreditRpt, \r\n");
        strBuffer.append("    M.FBeginQty FEndQty, TA.FDC FBalanceOriention,\r\n");
        strBuffer.append("    M.FBeginBalanceFor FEndBalanceFor, \r\n");
        strBuffer.append("    M.FBeginBalanceLocal FEndBalanceLocal, \r\n");
        strBuffer.append("    M.FBeginBalanceRpt FEndBalanceRpt \r\n");
        strBuffer.append(" FROM \t\r\n");
        strBuffer.append("   (SELECT T1.FAccountID ,T1.FCurrencyID,T1.FCompanyID FCompanyID ,T1.FPeriod,\r\n");
        strBuffer.append("        SUM(T1.FBeginBalanceFor) FBeginBalanceFor ,\r\n");
        strBuffer.append("        SUM(T1.FDebitFor) FDebitFor, \r\n");
        strBuffer.append("        SUM(T1.FCreditFor) FCreditFor ,\r\n");
        strBuffer.append("        SUM(T1.FYearDebitFor) FYearDebitFor ,\r\n");
        strBuffer.append("        SUM(T1.FYearCreditFor) FYearCreditFor ,\r\n");
        strBuffer.append("        SUM(T1.FEndBalanceFor) FEndBalanceFor , \r\n");
        strBuffer.append("        SUM(T1.FBeginBalanceLocal) FBeginBalanceLocal ,\r\n");
        strBuffer.append("        SUM(T1.FDebitLocal) FDebitLocal, \r\n");
        strBuffer.append("        SUM(T1.FCreditLocal) FCreditLocal,\r\n");
        strBuffer.append("        SUM(T1.FYearDebitLocal) FYearDebitLocal ,\r\n");
        strBuffer.append("        SUM(T1.FYearCreditLocal) FYearCreditLocal,\r\n");
        strBuffer.append("        SUM(T1.FEndBalanceLocal) FEndBalanceLocal,\r\n");
        strBuffer.append("        SUM(T1.FBeginBalanceRpt) FBeginBalanceRpt,\r\n");
        strBuffer.append("        SUM(T1.FDebitRpt) FDebitRpt, \r\n");
        strBuffer.append("        SUM(T1.FCreditRpt) FCreditRpt ,\r\n");
        strBuffer.append("        SUM(T1.FYearDebitRpt) FYearDebitRpt , \r\n");
        strBuffer.append("        SUM(T1.FYearCreditRpt) FYearCreditRpt ,\r\n");
        strBuffer.append("        SUM(T1.FEndBalanceRpt) FEndBalanceRpt,\r\n");
        strBuffer.append("        SUM(T1.FBeginQty) FBeginQty,\r\n");
        strBuffer.append("        SUM(T1.FDebitQty) FDebitQty, \r\n");
        strBuffer.append("        SUM(T1.FCreditQty) FCreditQty ,\r\n");
        strBuffer.append("        SUM(T1.FYearDebitQty) FYearDebitQty , \r\n");
        strBuffer.append("        SUM(T1.FYearCreditQty) FYearCreditQty,\r\n");
        strBuffer.append("        SUM(T1.FEndQty) FEndQty\r\n");
        strBuffer.append("\t  FROM ");
        strBuffer.append(strFirstTableName);
        strBuffer.append("  T1 INNER JOIN \r\n");
        strBuffer.append("       (SELECT distinct FAccountID FAccountID,FCompanyID FCompanyID, \r\n");
        strBuffer.append("           min(FPeriod) FYearNumber from \r\n ");
        strBuffer.append(strFirstTableName);
        strBuffer.append("        GROUP BY FAccountid,FCompanyID) T2 \r\n");
        strBuffer.append("       ON T1.FaccountId = T2.FaccountID and T1.FCompanyId=T2.FCompanyID \r\n");
        strBuffer.append("          AND T1.FPeriod = T2.FYearNumber \r\n");
        strBuffer.append("\t     GROUP BY T1.FAccountID ,T1.FCurrencyID,T1.FCompanyID,T1.FPeriod ) M \r\n");
        strBuffer.append("       INNER JOIN T_BD_AccountView TA ON M.FAccountID = TA.FID \r\n");
        strBuffer.append("       LEFT JOIN t_BD_CURRENCY TC ON M.FCurrencyID = TC.FID \r\n");
        strBuffer.append("       INNER JOIN t_ORG_COMPANY CP ON M.FCompanyID = CP.FID \r\n");
        strBuffer.append(" WHERE \r\n");
        strBuffer.append(" TA.FAccountTableID = ? \r\n");
        strBuffer.append(" AND TA.FLevel >= ? \r\n");
        strBuffer.append(" AND TA.FLevel <= ? \r\n");
        ReportConditionGeneralLedger condition = (ReportConditionGeneralLedger)partner.getFixCondition();
        String strInsert = "insert into " + strTempTable + strBuffer;
        if (condition.isOptionNoDisplayZeroTotal()) {
            strBuffer.append(" AND (M.FDebitLocal<>0 OR M.FCreditLocal<>0 OR M.FDebitFor<>0 OR M.FCreditFor<>0)");
        }
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            cn = partner.getConnection();
            stmt = cn.prepareStatement(strInsert);
            parameter = new SqlParameter2();
            parameter.addValueChar(partner.getAccountTableId());
            parameter.addValue(condition.getAccountLevelStart());
            parameter.addValue(condition.getAccountLevelEnd());
            DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(strInsert));
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)sqle);
                sqle.setNextException(new SQLException("The query sql is:" + strInsert));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)stmt);
        strBuffer = new StringBuffer();
        strBuffer.append(" SELECT TA.FID FAccountID,TA.FNumber  FAccountNumber,\r\n");
        strBuffer.append("    TA.FName");
        strBuffer.append(partner.getFieldNameExtend());
        strBuffer.append(" FAccountName ,\r\n");
        strBuffer.append(" M.FCompanyID FCompanyID, M.FCurrencyID FCurrencyID, TC.FNumber FCurrencyNumber, TC.FName");
        strBuffer.append(partner.getFieldNameExtend());
        strBuffer.append(" FCurrencyName,TC.FPrecision FCurrencyPre,\r\n");
        strBuffer.append("    M.FPeriod,\r\n");
        strBuffer.append("    1 FPeriodSortNumber, CP.FLongNumber Flevelnumber, \r\n ");
        strBuffer.append("    M.FDebitQty FDebitQty , M.FDebitFor FDebitFor, \r\n");
        strBuffer.append("    M.FDebitLocal FDebitLocal, M.FDebitRpt FDebitRpt, \r\n");
        strBuffer.append("    M.FCreditQty FCreditQty,  M.FCreditFor FCreditFor, \r\n");
        strBuffer.append("    M.FCreditLocal FCreditLocal, M.FCreditRpt FCreditRpt, \r\n");
        strBuffer.append("    M.FEndQty FEndQty,  TA.FDC FBalanceOriention,\r\n");
        strBuffer.append("    M.FEndBalanceFor FEndBalanceFor,  M.FEndBalanceLocal FEndBalanceLocal, \r\n");
        strBuffer.append("    M.FEndBalanceRpt FEndBalanceRpt \r\n");
        strBuffer.append(" FROM  \r\n");
        strBuffer.append("    (SELECT FAccountID ,FCurrencyID ,FCompanyID,FPeriod,\r\n");
        strBuffer.append("        SUM(FBeginBalanceFor) AS FBeginBalanceFor ,\r\n");
        strBuffer.append("        SUM(FDebitFor) AS FDebitFor, SUM(FCreditFor) AS FCreditFor ,\r\n");
        strBuffer.append("        SUM(FYearDebitFor) AS FYearDebitFor ,\r\n");
        strBuffer.append("        SUM(FYearCreditFor) AS FYearCreditFor ,\r\n");
        strBuffer.append("        SUM(FEndBalanceFor) AS FEndBalanceFor , \r\n");
        strBuffer.append("        SUM(FBeginBalanceLocal) AS FBeginBalanceLocal ,\r\n");
        strBuffer.append("        SUM(FDebitLocal) AS FDebitLocal,\r\n");
        strBuffer.append("        SUM(FCreditLocal) AS FCreditLocal,\r\n");
        strBuffer.append("        SUM(FYearDebitLocal) AS FYearDebitLocal ,\r\n");
        strBuffer.append("        SUM(FYearCreditLocal) AS FYearCreditLocal,\r\n");
        strBuffer.append("        SUM(FEndBalanceLocal) AS FEndBalanceLocal,\r\n");
        strBuffer.append("        SUM(FBeginBalanceRpt) AS FBeginBalanceRpt,\r\n");
        strBuffer.append("        SUM(FDebitRpt) AS FDebitRpt, \r\n");
        strBuffer.append("        SUM(FCreditRpt) AS FCreditRpt ,\r\n");
        strBuffer.append("        SUM(FYearDebitRpt) AS FYearDebitRpt , \r\n");
        strBuffer.append("        SUM(FYearCreditRpt) AS FYearCreditRpt ,\r\n");
        strBuffer.append("        SUM(FEndBalanceRpt) AS FEndBalanceRpt,\r\n");
        strBuffer.append("        SUM(FBeginQty) AS FBeginQty,\r\n");
        strBuffer.append("        SUM(FDebitQty) AS FDebitQty, \r\n");
        strBuffer.append("        SUM(FCreditQty) AS FCreditQty ,\r\n");
        strBuffer.append("        SUM(FYearDebitQty) AS FYearDebitQty , \r\n");
        strBuffer.append("        SUM(FYearCreditQty) AS FYearCreditQty,\r\n");
        strBuffer.append("        SUM(FEndQty) AS FEndQty\r\n");
        strBuffer.append("\t   FROM ");
        strBuffer.append(strFirstTableName);
        strBuffer.append("  \r\n");
        strBuffer.append("\t   GROUP BY FAccountID ,FCurrencyID,FCompanyID,FPeriod ) AS M \r\n");
        strBuffer.append("        INNER JOIN T_BD_AccountView TA \r\n");
        strBuffer.append("\t         ON M.FAccountID = TA.FID \r\n");
        strBuffer.append("        LEFT JOIN T_BD_CURRENCY TC \r\n");
        strBuffer.append("           ON M.FCurrencyID = TC.FID \r\n");
        strBuffer.append("       INNER JOIN t_ORG_COMPANY CP ON M.FCompanyID = CP.FID \r\n");
        strBuffer.append("     WHERE \r\n");
        strBuffer.append("\t      TA.FAccountTableID = ?  \r\n");
        strBuffer.append("        AND TA.FLevel >= ? \r\n");
        strBuffer.append("        AND TA.FLevel <= ? \r\n");
        if (condition.isOptionNoDisplayZeroTotal()) {
            strBuffer.append(" AND (M.FDebitLocal<>0 OR M.FCreditLocal<>0 OR M.FDebitFor<>0 OR M.FCreditFor<>0)");
        }
        strInsert = "insert into " + strTempTable + strBuffer;
        try {
            cn = partner.getConnection();
            stmt = cn.prepareStatement(strInsert);
            parameter = new SqlParameter2();
            parameter.addValueChar(partner.getAccountTableId());
            parameter.addValue(condition.getAccountLevelStart());
            parameter.addValue(condition.getAccountLevelEnd());
            DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(strInsert));
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            sqle.setNextException(new SQLException("The query sql is:" + strInsert));
            throw new SQLDataException(sqle);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
        strBuffer = new StringBuffer();
        strBuffer.append(" SELECT  TA.FID FAccountID,TA.FNumber  FAccountNumber,\r\n");
        strBuffer.append("   TA.FName");
        strBuffer.append(partner.getFieldNameExtend());
        strBuffer.append("   FAccountName ,\r\n");
        strBuffer.append("    M.FCompanyID FCompanyID,M.FCurrencyID FCurrencyID, TC.FNumber FCurrencyNumber, TC.FName");
        strBuffer.append(partner.getFieldNameExtend());
        strBuffer.append("    FCurrencyName,TC.FPrecision FCurrencyPre, \r\n");
        strBuffer.append("    M.FPeriod,\r\n");
        strBuffer.append("    2 FPeriodSortNumber, CP.FLongNumber flevelnumber, \r\n ");
        strBuffer.append("    FYearDebitQty  FDebitQty, M.FYearDebitFor FDebitFor, \r\n");
        strBuffer.append("    M.FYearDebitLocal FDebitLocal, M.FYearDebitRpt FDebitRpt, \r\n");
        strBuffer.append("    M.FYearCreditQty FCreditQty, M.FYearCreditFor FCreditFor, \r\n");
        strBuffer.append("    M.FYearCreditLocal FCreditLocal, M.FYearCreditRpt FCreditRpt, \r\n");
        strBuffer.append("    M.FEndQty FEndQty,  TA.FDC FBalanceOriention,\r\n");
        strBuffer.append("    M.FEndBalanceFor FEndBalanceFor, M.FEndBalanceLocal FEndBalanceLocal, \r\n");
        strBuffer.append("    M.FEndBalanceRpt FEndBalanceRpt \r\n");
        strBuffer.append(" FROM  \r\n");
        strBuffer.append("\t  (SELECT FAccountID ,FCompanyID,FCurrencyID ,FPeriod,\r\n");
        strBuffer.append("        SUM(FBeginBalanceFor) AS FBeginBalanceFor ,\r\n");
        strBuffer.append("        SUM(FDebitFor) AS FDebitFor, SUM(FCreditFor) AS FCreditFor ,\r\n");
        strBuffer.append("        SUM(FYearDebitFor) AS FYearDebitFor ,SUM(FYearCreditFor) AS FYearCreditFor ,\r\n");
        strBuffer.append("        SUM(FEndBalanceFor) AS FEndBalanceFor , \r\n");
        strBuffer.append("        SUM(FBeginBalanceLocal) AS FBeginBalanceLocal ,\r\n");
        strBuffer.append("        SUM(FDebitLocal) AS FDebitLocal,SUM(FCreditLocal) AS FCreditLocal,\r\n");
        strBuffer.append("        SUM(FYearDebitLocal) AS FYearDebitLocal ,\r\n");
        strBuffer.append("        SUM(FYearCreditLocal) AS FYearCreditLocal,\r\n");
        strBuffer.append("        SUM(FEndBalanceLocal) AS FEndBalanceLocal,\r\n");
        strBuffer.append("        SUM(FBeginBalanceRpt) AS FBeginBalanceRpt,\r\n");
        strBuffer.append("        SUM(FDebitRpt) AS FDebitRpt, SUM(FCreditRpt) AS FCreditRpt ,\r\n");
        strBuffer.append("        SUM(FYearDebitRpt) AS FYearDebitRpt , SUM(FYearCreditRpt) AS FYearCreditRpt ,\r\n");
        strBuffer.append("        SUM(FEndBalanceRpt) AS FEndBalanceRpt,\r\n");
        strBuffer.append("        SUM(FBeginQty) AS FBeginQty,\r\n");
        strBuffer.append("        SUM(FDebitQty) AS FDebitQty, SUM(FCreditQty) AS FCreditQty ,\r\n");
        strBuffer.append("        SUM(FYearDebitQty) AS FYearDebitQty , SUM(FYearCreditQty) AS FYearCreditQty,\r\n");
        strBuffer.append("        SUM(FEndQty) AS FEndQty\r\n");
        strBuffer.append("\t   FROM \r\n");
        strBuffer.append(strFirstTableName);
        strBuffer.append("   \r\n");
        strBuffer.append("\t   GROUP BY FAccountID ,FCompanyID,FCurrencyID,FPeriod ) AS M \r\n");
        strBuffer.append("     INNER JOIN T_BD_AccountView TA \r\n");
        strBuffer.append("\t      ON M.FAccountID = TA.FID \r\n");
        strBuffer.append("     LEFT JOIN T_BD_CURRENCY TC \r\n");
        strBuffer.append("        ON M.FCurrencyID = TC.FID \r\n");
        strBuffer.append("       INNER JOIN t_ORG_COMPANY CP ON M.FCompanyID = CP.FID \r\n");
        strBuffer.append(" WHERE \r\n");
        strBuffer.append("\t   TA.FAccountTableID = ?  \r\n");
        strBuffer.append("     AND TA.FLevel >= ? \r\n");
        strBuffer.append("     AND TA.FLevel <= ? \r\n");
        if (condition.isOptionNoDisplayZeroTotal()) {
            strBuffer.append(" AND (M.FDebitLocal<>0 OR M.FCreditLocal<>0 OR M.FDebitFor<>0 OR M.FCreditFor<>0)");
        }
        strInsert = "insert into " + strTempTable + strBuffer;
        try {
            cn = partner.getConnection();
            stmt = cn.prepareStatement(strInsert);
            parameter = new SqlParameter2();
            parameter.addValueChar(partner.getAccountTableId());
            parameter.addValue(condition.getAccountLevelStart());
            parameter.addValue(condition.getAccountLevelEnd());
            DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(strInsert));
            stmt = this.doAfterCurrPeriodData(partner, strTempTable, condition);
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            sqle.setNextException(new SQLException("The query sql is:" + strInsert));
            throw new SQLDataException(sqle);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
        strBuffer = new StringBuffer();
        strBuffer.append("\tdelete  \r\n");
        strBuffer.append(strTempTable);
        strBuffer.append("  where fcurrencynumber is null  \r\n");
        strBuffer.append("\tand exists (select 1 from ( \r\n");
        strBuffer.append("  select  \r\n");
        strBuffer.append("     fcompanyid as fcompanyid2, \r\n");
        strBuffer.append("     fcurrencyid as fcurrencyid2, \r\n");
        strBuffer.append("     faccountnumber as faccountnumber2, \r\n");
        strBuffer.append("     FPeriod as FPeriod2, FPeriodSortNumber as FPeriodSortNumber2, \r\n");
        strBuffer.append("\t   fDebitFor as fDebitFor2, fDebitLocal as fDebitLocal2, \r\n");
        strBuffer.append("     fDebitRpt as fDebitRpt2, fCreditFor as fCreditFor2, \r\n");
        strBuffer.append("     fCreditLocal as fCreditLocal2, fCreditRpt as fCreditRpt2, \r\n");
        strBuffer.append("     FEndBalanceFor as FEndBalanceFor2, FEndBalanceLocal as FEndBalanceLocal2, \r\n");
        strBuffer.append("     FEndBalanceRpt as FEndBalanceRpt2 from  \r\n");
        strBuffer.append(strTempTable);
        strBuffer.append("     ) b where fcompanyid = fcompanyid2 and faccountnumber = b.faccountnumber2 and \r\n");
        strBuffer.append("     FPeriod = b.FPeriod2 \r\n");
        strBuffer.append("     and FPeriodSortNumber = b.FPeriodSortNumber2 and  \r\n");
        strBuffer.append("     (fDebitFor2<>0 or fDebitLocal2<>0 or fDebitRpt2<>0 or fCreditFor2<>0 or fCreditLocal2<>0 or  \r\n");
        strBuffer.append("     fCreditRpt2<>0 or FEndBalanceFor2<>0 or FEndBalanceLocal2<>0 or FEndBalanceRpt2<>0 or fcurrencyid2 is not null) \r\n");
        strBuffer.append("     ) \r\n");
        try {
            cn = partner.getConnection();
            stmt = cn.prepareStatement(strBuffer.toString());
            parameter = new SqlParameter2();
            DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(strBuffer.toString()));
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            sqle.setNextException(new SQLException("The query sql is:" + strBuffer));
            throw new SQLDataException(sqle);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
    }

    protected void insertFirstData(ReportPartner partner, String strTempTable) throws EASBizException, BOSException {
        boolean isFilter;
        boolean isUseCurrency;
        ReportConditionGeneralLedger condition = (ReportConditionGeneralLedger)partner.getFixCondition();
        Context ctx = partner.getContext();
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String currencyId = condition.getCurrencyID();
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" SELECT T_Main.FAccountID,'' FCompanyID,  \r\n");
        if (isForCurrency) {
            strBuffer.append("    T_Main.FCurrencyID AS FCurrencyID ,\r\n");
        } else {
            strBuffer.append("    '" + currencyId + "' AS FCurrencyID ,\r\n");
        }
        strBuffer.append("    T_Main.FPeriod FPeriod,\r\n");
        if (isForCurrency) {
            strBuffer.append("    isnull(T_Main.FBeginBalanceFor,0) AS FBeginBalanceFor, \r\n");
            strBuffer.append("    isnull(T_Main.FDebitFor,0) AS FDebitFor,\r\n");
            strBuffer.append("    isnull(T_Main.FCreditFor,0) AS FCreditFor,\r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitFor,0)  AS FYearDebitFor,\r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditFor,0) AS FYearCreditFor,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceFor,0) AS FEndBalanceFor,\r\n");
            strBuffer.append("    isnull(T_Main.FBeginBalanceLocal,0) AS FBeginBalanceLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FDebitLocal,0) AS FDebitLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FCreditLocal,0) AS FCreditLocal, \r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitLocal,0) as FYearDebitLocal, \r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditLocal,0)  AS FYearCreditLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceLocal,0) AS FEndBalanceLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FBeginBalanceRpt,0) AS FBeginBalanceRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FDebitRpt,0) AS FDebitRpt, \r\n");
            strBuffer.append("    isnull(T_Main.FCreditRpt,0) AS FCreditRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitRpt,0) AS FYearDebitRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditRpt,0) AS FYearCreditRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceRpt,0) AS FEndBalanceRpt, \r\n");
        } else if (isLocalCurrency) {
            strBuffer.append("    isnull(T_Main.FBeginBalanceLocal,0) AS FBeginBalanceFor, \r\n");
            strBuffer.append("    isnull(T_Main.FDebitLocal,0) AS FDebitFor,\r\n");
            strBuffer.append("    isnull(T_Main.FCreditLocal,0) AS FCreditFor,\r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitLocal,0)  AS FYearDebitFor,\r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditLocal,0) AS FYearCreditFor,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceLocal,0) AS FEndBalanceFor,\r\n");
            strBuffer.append("    isnull(T_Main.FBeginBalanceLocal,0) AS FBeginBalanceLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FDebitLocal,0) AS FDebitLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FCreditLocal,0) AS FCreditLocal, \r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitLocal,0) as FYearDebitLocal, \r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditLocal,0)  AS FYearCreditLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceLocal,0) AS FEndBalanceLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FBeginBalanceLocal,0) AS FBeginBalanceRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FDebitLocal,0) AS FDebitRpt, \r\n");
            strBuffer.append("    isnull(T_Main.FCreditLocal,0) AS FCreditRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitLocal,0) AS FYearDebitRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditLocal,0) AS FYearCreditRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceLocal,0) AS FEndBalanceRpt, \r\n");
        } else if (isRptCurrency) {
            strBuffer.append("    isnull(T_Main.FBeginBalanceRpt,0) AS FBeginBalanceFor, \r\n");
            strBuffer.append("    isnull(T_Main.FDebitRpt,0) AS FDebitFor,\r\n");
            strBuffer.append("    isnull(T_Main.FCreditRpt,0) AS FCreditFor,\r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitRpt,0)  AS FYearDebitFor,\r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditRpt,0) AS FYearCreditFor,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceRpt,0) AS FEndBalanceFor,\r\n");
            strBuffer.append("    isnull(T_Main.FBeginBalanceRpt,0) AS FBeginBalanceLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FDebitRpt,0) AS FDebitLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FCreditRpt,0) AS FCreditLocal, \r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitRpt,0) as FYearDebitLocal, \r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditRpt,0)  AS FYearCreditLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceRpt,0) AS FEndBalanceLocal,\r\n");
            strBuffer.append("    isnull(T_Main.FBeginBalanceRpt,0) AS FBeginBalanceRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FDebitRpt,0) AS FDebitRpt, \r\n");
            strBuffer.append("    isnull(T_Main.FCreditRpt,0) AS FCreditRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FYearDebitRpt,0) AS FYearDebitRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FYearCreditRpt,0) AS FYearCreditRpt,\r\n");
            strBuffer.append("    isnull(T_Main.FEndBalanceRpt,0) AS FEndBalanceRpt, \r\n");
        }
        strBuffer.append("    CASE TA.FIsQty WHEN 0 THEN 0 ELSE T_Main.FBeginQty * 1.0000 / ISNULL(MU.FCoefficient, 1) END AS FBeginQty,\r\n");
        strBuffer.append("    CASE TA.FIsQty WHEN 0 THEN 0 ELSE T_Main.FDebitQty * 1.0000 / ISNULL(MU.FCoefficient, 1) END AS FDebitQty, \r\n");
        strBuffer.append("    CASE TA.FIsQty WHEN 0 THEN 0 ELSE T_Main.FCreditQty * 1.0000 / ISNULL(MU.FCoefficient, 1) END AS FCreditQty,\r\n");
        strBuffer.append("    CASE TA.FIsQty WHEN 0 THEN 0 ELSE T_Main.FYearDebitQty * 1.0000 / ISNULL(MU.FCoefficient, 1) END AS FYearDebitQty,\r\n");
        strBuffer.append("    CASE TA.FIsQty WHEN 0 THEN 0 ELSE T_Main.FYearCreditQty * 1.0000 / ISNULL(MU.FCoefficient, 1) END AS FYearCreditQty,\r\n");
        strBuffer.append("    CASE TA.FIsQty WHEN 0 THEN 0 ELSE T_Main.FEndQty * 1.0000 / ISNULL(MU.FCoefficient, 1) END AS FEndQty \r\n");
        strBuffer.append(" FROM \r\n");
        strBuffer.append(this.getGeneralLedgerTableName(partner));
        strBuffer.append("  as T_Main \r\n");
        strBuffer.append("  INNER JOIN T_BD_AccountView TA ON T_Main.FOrgUnitID = TA.FCompanyID AND T_Main.FAccountID = TA.FID \r\n ");
        strBuffer.append("  LEFT OUTER JOIN T_BD_MEASUREUNIT MU ON MU.FID = TA.FMeasureUnitID\t   \r\n ");
        if (isForCurrency) {
            strBuffer.append("  INNER JOIN T_BD_Currency currency ON T_Main.FCurrencyID = currency.Fid \r\n ");
        }
        strBuffer.append(RptServerUtil.innerJoinAccountPermissionSql("TA", userID, companyID, ctx));
        strBuffer.append(" WHERE T_Main.FOrgUnitID = ? \r\n");
        boolean bl = isUseCurrency = currencyId != null && currencyId.trim().length() != 0 && !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId);
        if (isUseCurrency) {
            strBuffer.append(" and T_Main.FCurrencyID = ? \r\n");
        }
        strBuffer.append(" AND T_Main.FPeriod in " + SQLUtil.buildPeriodNumbersInSql(condition.getPeriodYearStart(), condition.getPeriodNumberStart(), condition.getPeriodYearEnd(), condition.getPeriodNumberEnd()));
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            strBuffer.append("\tAND TA.FNumber >= ? \r\n");
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            strBuffer.append(" AND TA.FNumber <= ? \r\n");
        }
        strBuffer.append(" AND ta.faccounttableid = ? \r\n");
        strBuffer.append(" AND ta.fisleaf = 1 \r\n");
        StringBuffer sql = new StringBuffer();
        boolean bl2 = isFilter = condition.isOptionNOTDisplayIfNoAmount() || condition.isOptionNOTDisplayIfZeroNoAmount();
        if (condition.isNotIncludePLVoucher()) {
            if (isFilter) {
                sql.append(" select t.FAccountID, t.FCompanyID, t.FCurrencyID, t.FPeriod,");
                sql.append(" t.FBeginBalanceFor, t.FDebitFor, t.FCreditFor, t.FYearDebitFor, t.FYearCreditFor, t.FEndBalanceFor,");
                sql.append(" t.FBeginBalanceLocal, t.FDebitLocal, t.FCreditLocal, t.FYearDebitLocal, t.FYearCreditLocal, t.FEndBalanceLocal,");
                sql.append(" t.FBeginBalanceRpt, t.FDebitRpt, t.FCreditRpt, t.FYearDebitRpt, t.FYearCreditRpt, t.FEndBalanceRpt,");
                sql.append(" t.FBeginQty, t.FDebitQty, t.FCreditQty, t.FYearDebitQty, t.FYearCreditQty, t.FEndQty");
                sql.append(" from (");
                sql.append(this.getNotIncludePLVoucherSQL(partner, strBuffer.toString(), this.plVoucherTempTable));
                sql.append(" ) t where 1 = 1");
            } else {
                sql.append(this.getNotIncludePLVoucherSQL(partner, strBuffer.toString(), this.plVoucherTempTable));
            }
        } else {
            sql.append(strBuffer);
        }
        String strInsertTable = " insert into " + strTempTable + sql;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = partner.getConnection().prepareStatement(strInsertTable);
            SqlParameter2 parameter = new SqlParameter2();
            parameter.addValueChar(partner.getCompanyId());
            if (isUseCurrency) {
                parameter.addValueChar(currencyId);
            }
            if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
                parameter.addValueVarchar(condition.getAccountCodeStart());
            }
            if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
                parameter.addValueVarchar(condition.getAccountCodeEnd() + "zz");
            }
            parameter.addValue(partner.getAccountTableId());
            DbUtil.execute((Context)ctx, (String)parameter.getSqlWithParameters(strInsertTable));
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            sqle.setNextException(new SQLException("The query sql is:" + strInsertTable));
            throw new SQLDataException(sqle);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
    }

    private void insertFirstDataForUpdate(ReportPartner partner, String strFirstTempTableName) throws EASBizException, BOSException {
        ReportConditionGeneralLedger condition = (ReportConditionGeneralLedger)partner.getFixCondition();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(strFirstTempTableName);
        sql.append(" \r\n");
        sql.append("SELECT T_Main.FAccountID,'' FCompanyID, T_Main.FCurrencyID , \r\n");
        sql.append("   T_Main.FPeriod FPeriod, \r\n");
        sql.append("   0.0 AS FBeginBalanceFor,0.0 AS FDebitFor,0.0 AS FCreditFor, \r\n");
        sql.append("   0.0 AS FYearDebitFor,0.0 AS FYearCreditFor, 0.0 AS FEndBalanceFor, \r\n");
        sql.append("   0.0 AS FBeginBalanceLocal,0.0 AS FDebitLocal,0.0 AS FCreditLocal,  \r\n");
        sql.append("   0.0 AS FYearDebitLocal, 0.0 AS FYearCreditLocal,0.0 AS FEndBalanceLocal, \r\n");
        sql.append("   0.0 AS FBeginBalanceRpt, 0.0 AS FDebitRpt, 0.0 AS FCreditRpt, \r\n");
        sql.append("   0.0 AS FYearDebitRpt, 0.0 AS FYearCreditRpt, 0.0 AS FEndBalanceRpt,  \r\n");
        sql.append("   0.0 AS FBeginQty, 0.0 AS FDebitQty, 0.0 AS FCreditQty, \r\n");
        sql.append("   0.0 AS FYearDebitQty, 0.0 AS FYearCreditQty, 0.0 AS FEndQty  \r\n");
        sql.append("\tFROM \r\n");
        sql.append("   (SELECT TC.FAccountID,TB.FPeriod,TC.FCurrencyid \r\n");
        sql.append("\tFROM  \r\n");
        sql.append(" (select distinct FAccountID,FCurrencyID from \r\n");
        sql.append(strFirstTempTableName).append(")as TC,");
        sql.append("   (SELECT FNumber FPeriod \r\n");
        sql.append("\tFROM T_BD_Period  \r\n");
        sql.append("\tWHERE FTypeID = ? ");
        sql.append("    AND FNumber >= ? \r\n");
        sql.append("    AND FNumber <= ? \r\n");
        sql.append(") AS TB \r\n");
        sql.append("\t) AS T_Main  \r\n");
        sql.append("\tLEFT OUTER JOIN ").append(strFirstTempTableName).append(" AS T ON T_Main.FAccountID = T.FAccountID \r\n");
        sql.append("   AND T_Main.FPeriod = T.FPeriod \r\n");
        sql.append("   AND T_Main.FCurrencyID = T.FCurrencyID \r\n");
        sql.append("WHERE T.FAccountID is null \r\n");
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValueId((CoreBaseInfo)partner.getCompany().getAccountPeriodType());
        parameter.addValue(new Integer(condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart()));
        parameter.addValue(new Integer(condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd()));
        DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(sql.toString()));
    }

    protected void insertFirstDataForVirtual(ReportPartner partner, String strTempTable) throws EASBizException, BOSException {
        Context ctx = partner.getContext();
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ReportConditionGeneralLedger condition = (ReportConditionGeneralLedger)partner.getFixCondition();
        StringBuffer strBuffer = new StringBuffer();
        String currencyID = condition.getCurrencyID();
        boolean isUseCurrency = !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyID) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyID);
        strBuffer.append(" SELECT TAV.FID FAccountID, T_Main.FOrgUnitID FCompanyID, \r\n");
        if (isUseCurrency) {
            strBuffer.append("    T_Main.FCurrencyID AS FCurrencyID ,\r\n");
        } else {
            strBuffer.append(" '").append(currencyID);
            strBuffer.append("' AS FCurrencyID ,\r\n");
        }
        String forSuffix = "For";
        String localSuffix = "Local";
        String rptSuffix = "Rpt";
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyID)) {
            forSuffix = "Local";
            rptSuffix = "Local";
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyID)) {
            forSuffix = "Rpt";
            localSuffix = "Rpt";
        }
        strBuffer.append("    T_Main.FPeriod,\r\n");
        strBuffer.append("    isnull(T_Main.FBeginBalance").append(forSuffix).append(",0) AS FBeginBalanceFor, \r\n");
        strBuffer.append("    isnull(T_Main.FDebit").append(forSuffix).append(",0) AS FDebitFor,\r\n");
        strBuffer.append("    isnull(T_Main.FCredit").append(forSuffix).append(",0) AS FCreditFor,\r\n");
        strBuffer.append("    isnull(T_Main.FYearDebit").append(forSuffix).append(",0)  AS FYearDebitFor,\r\n");
        strBuffer.append("    isnull(T_Main.FYearCredit").append(forSuffix).append(",0) AS FYearCreditFor,\r\n");
        strBuffer.append("    isnull(T_Main.FEndBalance").append(forSuffix).append(",0) AS FEndBalanceFor,\r\n");
        strBuffer.append("    isnull(T_Main.FBeginBalance").append(localSuffix).append(",0) AS FBeginBalanceLocal,\r\n");
        strBuffer.append("    isnull(T_Main.FDebit").append(localSuffix).append(",0) AS FDebitLocal,\r\n");
        strBuffer.append("    isnull(T_Main.FCredit").append(localSuffix).append(",0) AS FCreditLocal, \r\n");
        strBuffer.append("    isnull(T_Main.FYearDebit").append(localSuffix).append(",0) as FYearDebitLocal, \r\n");
        strBuffer.append("    isnull(T_Main.FYearCredit").append(localSuffix).append(",0)  AS FYearCreditLocal,\r\n");
        strBuffer.append("    isnull(T_Main.FEndBalance").append(localSuffix).append(",0) AS FEndBalanceLocal,\r\n");
        strBuffer.append("    isnull(T_Main.FBeginBalance").append(rptSuffix).append(",0) AS FBeginBalanceRpt,\r\n");
        strBuffer.append("    isnull(T_Main.FDebit").append(rptSuffix).append(",0) AS FDebitRpt, \r\n");
        strBuffer.append("    isnull(T_Main.FCredit").append(rptSuffix).append(",0) AS FCreditRpt,\r\n");
        strBuffer.append("    isnull(T_Main.FYearDebit").append(rptSuffix).append(",0) AS FYearDebitRpt,\r\n");
        strBuffer.append("    isnull(T_Main.FYearCredit").append(rptSuffix).append(",0) AS FYearCreditRpt,\r\n");
        strBuffer.append("    isnull(T_Main.FEndBalance").append(rptSuffix).append(",0) AS FEndBalanceRpt, \r\n");
        strBuffer.append("    CASE tav.FIsQty WHEN 0 THEN 0 ELSE T_Main.FBeginQty END AS FBeginQty,\r\n");
        strBuffer.append("    CASE tav.FIsQty WHEN 0 THEN 0 ELSE T_Main.FDebitQty END AS FDebitQty, \r\n");
        strBuffer.append("    CASE tav.FIsQty WHEN 0 THEN 0 ELSE T_Main.FCreditQty END AS FCreditQty,\r\n");
        strBuffer.append("    CASE tav.FIsQty WHEN 0 THEN 0 ELSE T_Main.FYearDebitQty END AS FYearDebitQty,\r\n");
        strBuffer.append("    CASE tav.FIsQty WHEN 0 THEN 0 ELSE T_Main.FYearCreditQty END AS FYearCreditQty,\r\n");
        strBuffer.append("    CASE tav.FIsQty WHEN 0 THEN 0 ELSE T_Main.FEndQty END AS FEndQty \r\n");
        strBuffer.append(" FROM \r\n");
        strBuffer.append(this.getGeneralLedgerTableName(partner));
        strBuffer.append("  as T_Main \r\n");
        strBuffer.append("\tINNER JOIN t_bd_SystemStatusCtrol sysctrl ON sysctrl.FCompanyID = T_Main.FOrgUnitID\t\r\n");
        strBuffer.append("\tINNER JOIN t_bd_period strprd ON sysctrl.FStartPeriodID = strprd.FID\t\t\t\t\r\n");
        strBuffer.append("\tinner join t_bd_systemstatus tsst on sysctrl.FSystemStatusID=tsst.fid and tsst.fname=?\t\r\n");
        strBuffer.append(" inner join T_BD_AccountView tav on tav.fid=T_Main.FAccountID \r\n");
        strBuffer.append(RptServerUtil.innerJoinAccountPermissionSql("tav", userID, companyID, ctx));
        strBuffer.append(" where T_Main.FOrgUnitID in ").append(partner.getPhysicalCompanyId(false)).append("\n");
        strBuffer.append(" AND tav.fisProfitCenter <> 1 \r\n");
        strBuffer.append(" AND TAV.FGLevel >= TAV.FLevel ");
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            strBuffer.append("\t     AND TAV.FNumber >= ? \r\n");
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            strBuffer.append("\t     AND TAV.FNumber <= ? \r\n");
        }
        if (isUseCurrency && currencyID != null) {
            strBuffer.append(" and T_Main.FCurrencyID = ? \r\n");
        }
        strBuffer.append("\t\t\tAND (strprd.FPeriodYear < ? or (strprd.FPeriodYear = ? and strprd.FPeriodNumber <= ?))\t\r\n");
        strBuffer.append(" AND T_Main.FPeriod in " + SQLUtil.buildPeriodNumbersInSql(condition.getPeriodYearStart(), condition.getPeriodNumberStart(), condition.getPeriodYearEnd(), condition.getPeriodNumberEnd()));
        strBuffer.append(" AND tav.faccounttableid = ? \r\n");
        strBuffer.append(" AND tav.fisleaf = 1 \r\n");
        String sql = strBuffer.toString();
        if (condition.isNotIncludePLVoucher()) {
            sql = this.getNotIncludePLVoucherSQL(partner, sql, this.plVoucherTempTable);
        }
        String strInsertTable = " insert into " + strTempTable + "\n" + sql;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = partner.getConnection().prepareStatement(strInsertTable);
            SqlParameter2 parameter = new SqlParameter2();
            parameter.addValue(6);
            if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
                parameter.addValueVarchar(condition.getAccountCodeStart());
            }
            if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
                parameter.addValueVarchar(condition.getAccountCodeEnd() + "zz");
            }
            if (isUseCurrency && currencyID != null) {
                parameter.addValueChar(currencyID);
            }
            parameter.addValue(condition.getPeriodYearEnd());
            parameter.addValue(condition.getPeriodYearEnd());
            parameter.addValue(condition.getPeriodNumberEnd());
            parameter.addValueChar(partner.getAccountTableId());
            DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(strInsertTable));
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            sqle.setNextException(new SQLException("The query sql is:" + strInsertTable));
            throw new SQLDataException(sqle);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
    }

    private void insertFirstDataVirtualForUpdate(ReportPartner partner, String strFirstTempTableName) throws EASBizException, BOSException {
        ReportConditionGeneralLedger condition = (ReportConditionGeneralLedger)partner.getFixCondition();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(strFirstTempTableName);
        sql.append(" \r\n");
        sql.append("SELECT T_Main.FAccountID, T_Main.FCompanyID, T_Main.FCurrencyID , \r\n");
        sql.append("   T_Main.FPeriod FPeriod, \r\n");
        sql.append("   0.0 AS FBeginBalanceFor,0.0 AS FDebitFor,0.0 AS FCreditFor, \r\n");
        sql.append("   0.0 AS FYearDebitFor,0.0 AS FYearCreditFor, 0.0 AS FEndBalanceFor, \r\n");
        sql.append("   0.0 AS FBeginBalanceLocal,0.0 AS FDebitLocal,0.0 AS FCreditLocal,  \r\n");
        sql.append("   0.0 AS FYearDebitLocal, 0.0 AS FYearCreditLocal,0.0 AS FEndBalanceLocal, \r\n");
        sql.append("   0.0 AS FBeginBalanceRpt, 0.0 AS FDebitRpt, 0.0 AS FCreditRpt, \r\n");
        sql.append("   0.0 AS FYearDebitRpt, 0.0 AS FYearCreditRpt, 0.0 AS FEndBalanceRpt,  \r\n");
        sql.append("   0.0 AS FBeginQty, 0.0 AS FDebitQty, 0.0 AS FCreditQty, \r\n");
        sql.append("   0.0 AS FYearDebitQty, 0.0 AS FYearCreditQty, 0.0 AS FEndQty  \r\n");
        sql.append("\tFROM \r\n");
        sql.append("   (SELECT TC.FAccountID,TB.FPeriod,TC.FCompanyID, TC.FCurrencyid \r\n");
        sql.append("\tFROM  \r\n");
        sql.append(" (select distinct FAccountID,FCompanyID,FCurrencyID from \r\n");
        sql.append(strFirstTempTableName).append(")as TC,");
        sql.append("   (SELECT FNumber FPeriod \r\n");
        sql.append("\tFROM T_BD_Period  \r\n");
        sql.append("\tWHERE FTypeID = ? ");
        sql.append("    AND FNumber >= ? \r\n");
        sql.append("    AND FNumber <= ? \r\n");
        sql.append(") AS TB \r\n");
        sql.append("\t) AS T_Main  \r\n");
        sql.append("\tLEFT OUTER JOIN ").append(strFirstTempTableName).append(" AS T ON T_Main.FAccountID = T.FAccountID \r\n");
        sql.append("   AND T_Main.FPeriod = T.FPeriod \r\n");
        sql.append("   AND T_Main.FCurrencyID = T.FCurrencyID \r\n");
        sql.append("   AND T_Main.FCompanyID = T.FCompanyID \r\n");
        sql.append("WHERE T.FAccountID is null \r\n");
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValueId((CoreBaseInfo)partner.getCompany().getAccountPeriodType());
        parameter.addValue(new Integer(condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart()));
        parameter.addValue(new Integer(condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd()));
        DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(sql.toString()));
    }

    protected String getGeneralLedgerTableName(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionGeneralLedger condition = (ReportConditionGeneralLedger)partner.getFixCondition();
        String currencyId = condition.getCurrencyID();
        int baltype = condition.getOptionPosting() ? 1 : 5;
        return GLBalanceUtils.getAccountBalanceTable(baltype, currencyId);
    }

    protected String getFirstTempTableStructure() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" (FAccountID VARCHAR(44),FCompanyID Varchar(44), FCurrencyID VARCHAR(44), \r\n");
        strBuffer.append("  FPeriod INT, FBeginBalanceFor DECIMAL(28,10),\r\n");
        strBuffer.append("  FDebitFor DECIMAL(28,10), FCreditFor DECIMAL(28,10),\r\n");
        strBuffer.append("  FYearDebitFor DECIMAL(28,10),  FYearCreditFor DECIMAL(28,10),\r\n");
        strBuffer.append("  FEndBalanceFor DECIMAL(28,10), FBeginBalanceLocal DECIMAL(28,10),\r\n");
        strBuffer.append("  FDebitLocal DECIMAL(28,10),  FCreditLocal DECIMAL(28,10),\r\n");
        strBuffer.append("  FYearDebitLocal DECIMAL(28,10),  FYearCreditLocal DECIMAL(28,10),\r\n");
        strBuffer.append("  FEndBalanceLocal DECIMAL(28,10),  FBeginBalanceRpt DECIMAL(28,10),\r\n");
        strBuffer.append("  FDebitRpt DECIMAL(28,10),  FCreditRpt DECIMAL(28,10),\r\n");
        strBuffer.append("  FYearDebitRpt DECIMAL(28,10),  FYearCreditRpt DECIMAL(28,10),\r\n");
        strBuffer.append("  FEndBalanceRpt DECIMAL(28,10) ,  FBeginQty DECIMAL(28,10),\r\n");
        strBuffer.append("  FDebitQty DECIMAL(28,10), FCreditQty DECIMAL(28,10),\r\n");
        strBuffer.append("  FYearDebitQty DECIMAL(28,10), FYearCreditQty DECIMAL(28,10),\r\n");
        strBuffer.append("  FEndQty DECIMAL(28,10))");
        return strBuffer.toString();
    }

    protected String getSecondTempTableStructure(ReportPartner partner) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" (FAccountID VARCHAR(44),FAccountNumber VARCHAR(80),FAccountName VARCHAR(500),FCompanyID varchar(44), \r\n");
        strBuffer.append("  FCurrencyID VARCHAR(44),FCurrencyNumber VARCHAR(80),FCurrencyName VARCHAR(80), FCurrencyPre int, \r\n");
        strBuffer.append("  FPeriod INT, FPeriodSortNumber INT, flevelnumber varchar(500),  \r\n");
        strBuffer.append("  FDebitQty  DECIMAL(28,10),  FDebitFor DECIMAL(28,10), \r\n");
        strBuffer.append("  FDebitLocal DECIMAL(28,10),  FDebitRpt DECIMAL(28,10),\r\n");
        strBuffer.append("  FCreditQty DECIMAL(28,10),  FCreditFor DECIMAL(28,10), \r\n");
        strBuffer.append("  FCreditLocal DECIMAL(28,10), FCreditRpt DECIMAL(28,10), \r\n");
        strBuffer.append("  FEndQty DECIMAL(28,10),  FBalanceOriention DECIMAL(28,10), \r\n");
        strBuffer.append("  FEndBalanceFor DECIMAL(28,10),  FEndBalanceLocal DECIMAL(28,10), \r\n");
        strBuffer.append("  FEndBalanceRpt DECIMAL(28,10))");
        return strBuffer.toString();
    }

    @Override
    protected void doSomethingBeforeQuery(ReportPartner partner) throws EASBizException, BOSException {
        boolean isShowReportCurrency;
        ReportConditionGeneralLedger condition = (ReportConditionGeneralLedger)partner.getFixCondition();
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)condition.getTreeModelOfCompany();
            Object companyIds = condition.getExpandInfo().get("companyIds");
            if (node == null && companyIds instanceof Set) {
                DefaultKingdeeTreeNode root = GLRptDaoUtil.getTreeModeOfCompany(partner.getContext(), ContextUtil.getCurrentFIUnit((Context)partner.getContext()), (Set)companyIds);
                condition.setTreeModelOfCompany(root);
            }
        } else {
            PeriodInfo currentPeriod = partner.getCurrentPeriod();
            if (currentPeriod != null && condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart() > currentPeriod.getNumber()) {
                throw new ReportException(ReportException.RPT_GL_GENERALLEDGER_NOT_SUPPORT_FUTURE);
            }
        }
        if (condition.getAccountId() != null && condition.getAccountId().length() > 0) {
            AccountViewInfo accountViewInfo = partner.getAccountViewInfo();
            condition.setAccountCodeStart(accountViewInfo.getNumber());
            condition.setAccountCodeEnd(accountViewInfo.getNumber());
            condition.setAccountLevelStart(accountViewInfo.getLevel());
            condition.setAccountLevelEnd(accountViewInfo.getLevel());
        }
        if (condition.isAllCurrencyColumnar()) {
            throw new ReportException(ReportException.TODO);
        }
        boolean isShowLocalCurrency = !partner.isParmForeignCurrencySu() && partner.getCurrencyType() == 0 && !partner.isBaseCurrency() && !GlUtils.isCompanyUnion(partner.getCompany());
        boolean bl = isShowReportCurrency = !partner.isParmForeignCurrencySu() && partner.isParmUseReportCurrency() && partner.getCurrencyType() == 0 && !partner.isReportingCurrency() && partner.getCompany().getReportCurrency() != null && !GlUtils.isCompanyUnion(partner.getCompany());
        if (condition.isOptionShowQuantity()) {
            if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(partner.getFixCondition().getCurrencyID())) {
                this.setOneReportHeadQuantity(partner, 1);
            } else if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(partner.getFixCondition().getCurrencyID())) {
                this.setOneReportHeadQuantity(partner, 2);
            } else if (isShowLocalCurrency) {
                if (isShowReportCurrency) {
                    this.setForeignHeadExtraGenLocalReportQuantity(partner);
                } else {
                    this.setForeignHeadExtraGenLocalQuantity(partner);
                }
            } else if (isShowReportCurrency) {
                this.setForeignHeadExtraReportQuantity(partner);
            } else {
                this.setOneReportHeadQuantity(partner, 0);
            }
        } else if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(partner.getFixCondition().getCurrencyID())) {
            this.setOneReportHead(partner, 1);
        } else if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(partner.getFixCondition().getCurrencyID())) {
            this.setOneReportHead(partner, 2);
        } else if (isShowLocalCurrency) {
            if (isShowReportCurrency) {
                this.setForeignHeadExtraGenLocalReport(partner);
            } else {
                this.setForeignHeadExtraGenLocal(partner);
            }
        } else if (isShowReportCurrency) {
            this.setForeignHeadExtraReport(partner);
        } else {
            this.setOneReportHead(partner, 0);
        }
    }

    protected void setOneReportHead(ReportPartner partner, int type) throws EASBizException, BOSException {
        ReportTableHeadInfo head = partner.getTableHeadInfo();
        String[] columnNames = new String[]{"FAccountNumber", "FAccountName", "FCompany", "FCurrencyID", "FCurrencyName", "FCurrencyPre", "FPeriod", "FDescOfVoucher", "FDebitQty", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQty", "FCreditFor", "FCreditLocal", "FCreditRpt", "FQty", "FPrice", "FBalanceOritention", "FBalanceAmountFor", "FBalanceAmountLocal", "FBalanceAmountRpt"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AccountCode", "AccountName", "Company", "CurrencyName", "CurrencyName", "CurrencyName", "Period", "DescOfVoucher", "Debit", "Debit", "Debit", "Debit", "Credit", "Credit", "Credit", "Credit", "Balance", "Balance", "Balance", "Balance", "Balance", "Balance"}, {"AccountCode", "AccountName", "Company", "CurrencyName", "CurrencyName", "CurrencyName", "Period", "DescOfVoucher", "Debit", "Debit", "Debit", "Debit", "Credit", "Credit", "Credit", "Credit", "Quantity", "Price", "Oriention", "Amount", "LabelLocal", "LabelRpt"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = null;
        if (type == 0) {
            widths = new int[]{80, 160, 160, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, 80, 0, 80, 0, 0, 0, 80, 0, 0, 0, 0, 30, 110, 0, 0};
        } else if (type == 1) {
            widths = new int[]{80, 160, 160, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, 80, 0, 0, 80, 0, 0, 0, 80, 0, 0, 0, 30, 0, 110, 0};
        } else if (type == 2) {
            widths = new int[]{80, 160, 160, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, 80, 0, 0, 0, 80, 0, 0, 0, 80, 0, 0, 30, 0, 0, 110};
        }
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2};
        head.setAlignments(alignments);
        boolean[] merges = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setMerges(merges);
        boolean[] freezes = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setFreezes(freezes);
        int[] numberStyleTypes = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, true, true, true};
        head.setNeedKilobits(needKilobits);
        int scaleFor = partner.getScaleFor();
        int scaleLocal = partner.getScaleLocal();
        int scaleRpt = partner.getScaleRpt();
        int scaleQty = partner.getParmQtyScale();
        int scalePrice = partner.getParmPriceScale();
        int[] numberScales = new int[]{0, 0, 0, 0, 0, 0, 0, 0, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt};
        head.setNumberScales(numberScales);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
    }

    @Override
    protected String getSqlForDataWhere(ReportPartner partner) throws EASBizException, BOSException {
        return null;
    }

    private void setForeignHeadExtraGenLocal(ReportPartner partner) throws EASBizException, BOSException {
        ReportTableHeadInfo head = partner.getTableHeadInfo();
        String[] columnNames = new String[]{"FAccountNumber", "FAccountName", "FCompany", "FCurrencyID", "FCurrencyName", "FCurrencyPre", "FPeriod", "FDescOfVoucher", "FDebitQty", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQty", "FCreditFor", "FCreditLocal", "FCreditRpt", "FQty", "FPrice", "FBalanceOritention", "FBalanceAmountFor", "FBalanceAmountLocal", "FBalanceAmountRpt"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AccountCode", "AccountName", "Company", "CurrencyName", "CurrencyName", "CurrencyName", "Period", "DescOfVoucher", "Debit", "Debit", "Debit", "Debit", "Credit", "Credit", "Credit", "Credit", "Balance", "Balance", "Balance", "Balance", "Balance", "Balance"}, {"AccountCode", "AccountName", "Company", "CurrencyName", "CurrencyName", "CurrencyName", "Period", "DescOfVoucher", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "Price", "Oriention", "LabelFor", "LabelLocal", "LabelRpt"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = new int[]{80, 160, 160, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, 80, 0, 80, 80, 0, 0, 80, 80, 0, 0, 0, 30, 110, 110, 0};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2};
        head.setAlignments(alignments);
        boolean[] merges = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setMerges(merges);
        boolean[] freezes = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setFreezes(freezes);
        int[] numberStyleTypes = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, true, true, true};
        head.setNeedKilobits(needKilobits);
        int scaleFor = partner.getScaleFor();
        int scaleLocal = partner.getScaleLocal();
        int scaleRpt = partner.getScaleRpt();
        int scaleQty = partner.getParmQtyScale();
        int scalePrice = partner.getParmPriceScale();
        int[] numberScales = new int[]{0, 0, 0, 0, 0, 0, 0, 0, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt};
        head.setNumberScales(numberScales);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
    }

    private void setForeignHeadExtraGenLocalQuantity(ReportPartner partner) throws EASBizException, BOSException {
        ReportTableHeadInfo head = partner.getTableHeadInfo();
        String[] columnNames = new String[]{"FAccountNumber", "FAccountName", "FCompany", "FCurrencyID", "FCurrencyName", "FCurrencyPre", "FPeriod", "FDescOfVoucher", "FDebitQty", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQty", "FCreditFor", "FCreditLocal", "FCreditRpt", "FQty", "FPrice", "FBalanceOritention", "FBalanceAmountFor", "FBalanceAmountLocal", "FBalanceAmountRpt"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AccountCode", "AccountName", "Company", "CurrencyName", "CurrencyName", "CurrencyName", "Period", "DescOfVoucher", "Debit", "Debit", "Debit", "Debit", "Credit", "Credit", "Credit", "Credit", "Balance", "Balance", "Balance", "Balance", "Balance", "Balance"}, {"AccountCode", "AccountName", "Company", "CurrencyName", "CurrencyName", "CurrencyName", "Period", "DescOfVoucher", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "Price", "Oriention", "LabelFor", "LabelLocal", "LabelRpt"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = new int[]{80, 160, 160, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, 80, 80, 80, 80, 0, 80, 80, 80, 0, 80, 80, 30, 110, 110, 0};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2};
        head.setAlignments(alignments);
        boolean[] merges = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setMerges(merges);
        boolean[] freezes = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setFreezes(freezes);
        int[] numberStyleTypes = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, true, true, true};
        head.setNeedKilobits(needKilobits);
        int scaleFor = partner.getScaleFor();
        int scaleLocal = partner.getScaleLocal();
        int scaleRpt = partner.getScaleRpt();
        int scaleQty = partner.getParmQtyScale();
        int scalePrice = partner.getParmPriceScale();
        int[] numberScales = new int[]{0, 0, 0, 0, 0, 0, 0, 0, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt};
        head.setNumberScales(numberScales);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
    }

    private void setForeignHeadExtraGenLocalReport(ReportPartner partner) throws EASBizException, BOSException {
        ReportTableHeadInfo head = partner.getTableHeadInfo();
        String[] columnNames = new String[]{"FAccountNumber", "FAccountName", "FCompany", "FCurrencyID", "FCurrencyName", "FCurrencyPre", "FPeriod", "FDescOfVoucher", "FDebitQty", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQty", "FCreditFor", "FCreditLocal", "FCreditRpt", "FQty", "FPrice", "FBalanceOritention", "FBalanceAmountFor", "FBalanceAmountLocal", "FBalanceAmountRpt"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AccountCode", "AccountName", "Company", "CurrencyName", "CurrencyName", "CurrencyName", "Period", "DescOfVoucher", "Debit", "Debit", "Debit", "Debit", "Credit", "Credit", "Credit", "Credit", "Balance", "Balance", "Balance", "Balance", "Balance", "Balance"}, {"AccountCode", "AccountName", "Company", "CurrencyName", "CurrencyName", "CurrencyName", "Period", "DescOfVoucher", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "Price", "Oriention", "LabelFor", "LabelLocal", "LabelRpt"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = new int[]{80, 160, 160, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, 80, 0, 80, 80, 80, 0, 80, 80, 80, 0, 0, 30, 110, 110, 110};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2};
        head.setAlignments(alignments);
        boolean[] merges = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setMerges(merges);
        boolean[] freezes = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setFreezes(freezes);
        int[] numberStyleTypes = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, true, true, true};
        head.setNeedKilobits(needKilobits);
        int scaleFor = partner.getScaleFor();
        int scaleLocal = partner.getScaleLocal();
        int scaleRpt = partner.getScaleRpt();
        int scaleQty = partner.getParmQtyScale();
        int scalePrice = partner.getParmPriceScale();
        int[] numberScales = new int[]{0, 0, 0, 0, 0, 0, 0, 0, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt};
        head.setNumberScales(numberScales);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
    }

    private void setForeignHeadExtraGenLocalReportQuantity(ReportPartner partner) throws EASBizException, BOSException {
        ReportTableHeadInfo head = partner.getTableHeadInfo();
        String[] columnNames = new String[]{"FAccountNumber", "FAccountName", "FCompany", "FCurrencyID", "FCurrencyName", "FCurrencyPre", "FPeriod", "FDescOfVoucher", "FDebitQty", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQty", "FCreditFor", "FCreditLocal", "FCreditRpt", "FQty", "FPrice", "FBalanceOritention", "FBalanceAmountFor", "FBalanceAmountLocal", "FBalanceAmountRpt"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AccountCode", "AccountName", "Company", "CurrencyName", "CurrencyName", "CurrencyName", "Period", "DescOfVoucher", "Debit", "Debit", "Debit", "Debit", "Credit", "Credit", "Credit", "Credit", "Balance", "Balance", "Balance", "Balance", "Balance", "Balance"}, {"AccountCode", "AccountName", "Company", "CurrencyName", "CurrencyName", "CurrencyName", "Period", "DescOfVoucher", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "Price", "Oriention", "LabelFor", "LabelLocal", "LabelRpt"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = new int[]{80, 160, 160, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 30, 110, 110, 110};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2};
        head.setAlignments(alignments);
        boolean[] merges = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setMerges(merges);
        boolean[] freezes = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setFreezes(freezes);
        int[] numberStyleTypes = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, true, true, true};
        head.setNeedKilobits(needKilobits);
        int scaleFor = partner.getScaleFor();
        int scaleLocal = partner.getScaleLocal();
        int scaleRpt = partner.getScaleRpt();
        int scaleQty = partner.getParmQtyScale();
        int scalePrice = partner.getParmPriceScale();
        int[] numberScales = new int[]{0, 0, 0, 0, 0, 0, 0, 0, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt};
        head.setNumberScales(numberScales);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
    }

    private void setForeignHeadExtraReport(ReportPartner partner) throws EASBizException, BOSException {
        ReportTableHeadInfo head = partner.getTableHeadInfo();
        String[] columnNames = new String[]{"FAccountNumber", "FAccountName", "FCompany", "FCurrencyID", "FCurrencyName", "FCurrencyPre", "FPeriod", "FDescOfVoucher", "FDebitQty", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQty", "FCreditFor", "FCreditLocal", "FCreditRpt", "FQty", "FPrice", "FBalanceOritention", "FBalanceAmountFor", "FBalanceAmountLocal", "FBalanceAmountRpt"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AccountCode", "AccountName", "Company", "CurrencyName", "CurrencyName", "CurrencyName", "Period", "DescOfVoucher", "Debit", "Debit", "Debit", "Debit", "Credit", "Credit", "Credit", "Credit", "Balance", "Balance", "Balance", "Balance", "Balance", "Balance"}, {"AccountCode", "AccountName", "Company", "CurrencyName", "CurrencyName", "CurrencyName", "Period", "DescOfVoucher", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "Price", "Oriention", "LabelFor", "LabelLocal", "LabelRpt"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = new int[]{80, 160, 160, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, 80, 0, 80, 0, 80, 0, 80, 0, 80, 0, 0, 30, 110, 0, 110};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2};
        head.setAlignments(alignments);
        boolean[] merges = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setMerges(merges);
        boolean[] freezes = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setFreezes(freezes);
        int[] numberStyleTypes = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, true, true, true};
        head.setNeedKilobits(needKilobits);
        int scaleFor = partner.getScaleFor();
        int scaleLocal = partner.getScaleLocal();
        int scaleRpt = partner.getScaleRpt();
        int scaleQty = partner.getParmQtyScale();
        int scalePrice = partner.getParmPriceScale();
        int[] numberScales = new int[]{0, 0, 0, 0, 0, 0, 0, 0, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt};
        head.setNumberScales(numberScales);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
    }

    private void setOneReportHeadQuantity(ReportPartner partner, int type) throws EASBizException, BOSException {
        ReportTableHeadInfo head = partner.getTableHeadInfo();
        String[] columnNames = new String[]{"FAccountNumber", "FAccountName", "FCompany", "FCurrencyID", "FCurrencyName", "FCurrencyPre", "FPeriod", "FDescOfVoucher", "FDebitQty", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQty", "FCreditFor", "FCreditLocal", "FCreditRpt", "FQty", "FPrice", "FBalanceOritention", "FBalanceAmountFor", "FBalanceAmountLocal", "FBalanceAmountRpt"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AccountCode", "AccountName", "Company", "CurrencyName", "CurrencyName", "CurrencyName", "Period", "DescOfVoucher", "Debit", "Debit", "Debit", "Debit", "Credit", "Credit", "Credit", "Credit", "Balance", "Balance", "Balance", "Balance", "Balance", "Balance"}, {"AccountCode", "AccountName", "Company", "CurrencyName", "CurrencyName", "CurrencyName", "Period", "DescOfVoucher", "Quantity", "LabelFor", "Amount", "LabelRpt", "Quantity", "LabelFor", "Amount", "LabelRpt", "Quantity", "Price", "Oriention", "LabelFor", "Amount", "LabelRpt"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = null;
        if (type == 0) {
            widths = new int[]{80, 160, 160, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, 80, 80, 80, 0, 0, 80, 80, 0, 0, 80, 80, 30, 110, 0, 0};
        } else if (type == 1) {
            widths = new int[]{80, 160, 160, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, 80, 80, 0, 80, 0, 80, 0, 80, 0, 80, 80, 30, 0, 110, 0};
        } else if (type == 2) {
            widths = new int[]{80, 160, 160, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, 80, 80, 0, 0, 80, 80, 0, 0, 80, 80, 80, 30, 0, 0, 110};
        }
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2};
        head.setAlignments(alignments);
        boolean[] merges = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setMerges(merges);
        boolean[] freezes = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setFreezes(freezes);
        int[] numberStyleTypes = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, true, true, true};
        head.setNeedKilobits(needKilobits);
        int scaleFor = partner.getScaleFor();
        int scaleLocal = partner.getScaleLocal();
        int scaleRpt = partner.getScaleRpt();
        int scaleQty = partner.getParmQtyScale();
        int scalePrice = partner.getParmPriceScale();
        int[] numberScales = new int[]{0, 0, 0, 0, 0, 0, 0, 0, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt};
        head.setNumberScales(numberScales);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
    }

    private void setForeignHeadExtraReportQuantity(ReportPartner partner) throws EASBizException, BOSException {
        ReportTableHeadInfo head = partner.getTableHeadInfo();
        String[] columnNames = new String[]{"FAccountNumber", "FAccountName", "FCompany", "FCurrencyID", "FCurrencyName", "FCurrencyPre", "FPeriod", "FDescOfVoucher", "FDebitQty", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQty", "FCreditFor", "FCreditLocal", "FCreditRpt", "FQty", "FPrice", "FBalanceOritention", "FBalanceAmountFor", "FBalanceAmountLocal", "FBalanceAmountRpt"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AccountCode", "AccountName", "Company", "CurrencyName", "CurrencyName", "CurrencyName", "Period", "DescOfVoucher", "Debit", "Debit", "Debit", "Debit", "Credit", "Credit", "Credit", "Credit", "Balance", "Balance", "Balance", "Balance", "Balance", "Balance"}, {"AccountCode", "AccountName", "Company", "CurrencyName", "CurrencyName", "CurrencyName", "Period", "DescOfVoucher", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "LabelFor", "LabelLocal", "LabelRpt", "Quantity", "Price", "Oriention", "LabelFor", "LabelLocal", "LabelRpt"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = new int[]{80, 160, 160, -1, partner.getCurrency() == null ? 60 : -1, -1, 80, 80, 80, 80, 0, 80, 80, 80, 0, 80, 80, 80, 30, 110, 0, 110};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2};
        head.setAlignments(alignments);
        boolean[] merges = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setMerges(merges);
        boolean[] freezes = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        head.setFreezes(freezes);
        int[] numberStyleTypes = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1};
        head.setNumberStyleTypes(numberStyleTypes);
        boolean[] needKilobits = new boolean[]{false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, true, true, true};
        head.setNeedKilobits(needKilobits);
        int scaleFor = partner.getScaleFor();
        int scaleLocal = partner.getScaleLocal();
        int scaleRpt = partner.getScaleRpt();
        int scaleQty = partner.getParmQtyScale();
        int scalePrice = partner.getParmPriceScale();
        int[] numberScales = new int[]{0, 0, 0, 0, 0, 0, 0, 0, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scaleFor, scaleLocal, scaleRpt, scaleQty, scalePrice, 0, scaleFor, scaleLocal, scaleRpt};
        head.setNumberScales(numberScales);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
    }

    public BigDecimal getBalanceForDC(BigDecimal balance, boolean isParmBalanceDirSamAsAccount, int accountDC) throws BOSException, EASBizException {
        if (balance == null) {
            return balance;
        }
        int dc = balance.compareTo(ZERO);
        if (dc == 0) {
            return balance;
        }
        if (isParmBalanceDirSamAsAccount) {
            return accountDC == 1 ? balance : balance.negate();
        }
        return balance.abs();
    }

    protected String getBalanceDC(ReportPartner partner, BigDecimal curBalance, boolean bEndBalDCFormat, int iDC) throws BOSException {
        if (curBalance == null) {
            return partner.TITLE_BALANCE;
        }
        String strDc = null;
        boolean autoBalance = !bEndBalDCFormat;
        if (curBalance == null) {
            curBalance = GlUtils.zero;
        }
        if (autoBalance) {
            if (curBalance.compareTo(GlUtils.zero) > 0) {
                strDc = partner.TITLE_DEBIT;
            }
            if (curBalance.compareTo(GlUtils.zero) < 0) {
                strDc = partner.TITLE_CREDIT;
            }
            if (curBalance.compareTo(GlUtils.zero) == 0) {
                strDc = partner.TITLE_BALANCE;
            }
        } else if (curBalance.compareTo(GlUtils.zero) == 0) {
            strDc = partner.TITLE_BALANCE;
        } else {
            if (iDC == 1) {
                strDc = partner.TITLE_DEBIT;
            }
            if (iDC == -1) {
                strDc = partner.TITLE_CREDIT;
            }
        }
        return strDc;
    }

    @Override
    protected boolean isSupportVirtual() {
        return true;
    }

    protected void processGetLineObjects(int part, Object[] row, int index, ReportPartner partner, ResultSet rs) throws SQLException, EASBizException, BOSException {
    }

    protected void processInsertSecondData(int part, StringBuffer strBuffer, ReportPartner partner, String strFirstTableName, String strTempTable) throws EASBizException, BOSException {
    }

    @Override
    protected ReportPartner getReportPartner(Context ctx) {
        ReportPartner partner = super.getReportPartner(ctx);
        return partner;
    }

    protected void createPLVoucherTempTable(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionGeneralLedger condition = (ReportConditionGeneralLedger)partner.getFixCondition();
        StringBuffer struct = new StringBuffer();
        boolean isVirtualCompany = GlUtils.isCompanyUnion(partner.getCompany());
        GlParam param = GlParam.getGlParams((Context)partner.getContext(), (String[])new String[]{"GL_118", "GL_053"}, (String)partner.getCompany().getId().toString());
        boolean bl = this.isUseGL053 = param.getBoolean("GL_053") && isVirtualCompany;
        if (this.isUseGL053 && StringUtils.isEmpty((Object)this.companyIdsWithGL053)) {
            Set companyIds = this.getCompanyIdsWithGL053(partner);
            this.companyIdsWithGL053 = this.genCompanyIdsStr(companyIds);
        }
        String currencyId = condition.getCurrencyID();
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else {
            boolean bl2 = isForCurrency = !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId);
        }
        if (isVirtualCompany) {
            struct.append("companyid varchar(44),");
        }
        struct.append("accountid varchar(44)");
        struct.append(",period int");
        struct.append(",currencyid varchar(44)");
        struct.append(",debitfor NUMERIC(28,10)");
        struct.append(",creditfor NUMERIC(28,10)");
        struct.append(",yeardebitfor NUMERIC(28,10)");
        struct.append(",yearcreditfor NUMERIC(28,10)");
        struct.append(",debitlocal NUMERIC(28,10)");
        struct.append(",creditlocal NUMERIC(28,10)");
        struct.append(",yeardebitlocal NUMERIC(28,10)");
        struct.append(",yearcreditlocal NUMERIC(28,10)");
        struct.append(",debitrpt NUMERIC(28,10)");
        struct.append(",creditrpt NUMERIC(28,10)");
        struct.append(",yeardebitrpt NUMERIC(28,10)");
        struct.append(",yearcreditrpt NUMERIC(28,10)");
        struct.append(",debitqty NUMERIC(28,10)");
        struct.append(",creditqty NUMERIC(28,10)");
        struct.append(",yeardebitqty NUMERIC(28,10)");
        struct.append(",yearcreditqty NUMERIC(28,10)");
        StringBuffer indexStr = new StringBuffer();
        if (isVirtualCompany) {
            indexStr.append(" companyid,");
        }
        indexStr.append("accountid");
        if (isForCurrency) {
            indexStr.append(",currencyid");
        }
        this.plVoucherTempTable = GLTempTableUtil.createDBSysTempTable(partner.getContext(), struct.toString(), indexStr.toString());
        int startPeriod = condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart();
        int endPeriod = condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd();
        StringBuffer sql = new StringBuffer("select ");
        if (isVirtualCompany) {
            sql.append("v.fcompanyid companyid,");
        }
        sql.append("ve.faccountid accountid");
        sql.append(", pd.fnumber period");
        if (isForCurrency) {
            sql.append(", ve.fcurrencyid currencyid");
        } else {
            sql.append(", '").append(currencyId).append("' as currencyid");
        }
        if (isForCurrency) {
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FOriginalAmount else 0 end)").append(" debitfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FOriginalAmount else 0 end)").append(" creditfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" then ve.FOriginalAmount else 0 end) yeardebitfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" then ve.FOriginalAmount else 0 end) yearcreditfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FLocalAmount else 0 end) debitlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FLocalAmount else 0 end) creditlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" then ve.FLocalAmount else 0 end) yeardebitlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" then ve.FLocalAmount else 0 end) yearcreditlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FReportingAmount else 0 end) debitrpt ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FReportingAmount else 0 end) creditrpt ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" then ve.FReportingAmount else 0 end) yeardebitrpt ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" then ve.FReportingAmount else 0 end) yearcreditrpt ");
        } else if (isLocalCurrency) {
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FLocalAmount else 0 end)").append(" debitfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FLocalAmount else 0 end)").append(" creditfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" then ve.FLocalAmount else 0 end) yeardebitfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" then ve.FLocalAmount else 0 end) yearcreditfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FLocalAmount else 0 end) debitlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FLocalAmount else 0 end) creditlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" then ve.FLocalAmount else 0 end) yeardebitlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" then ve.FLocalAmount else 0 end) yearcreditlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FLocalAmount else 0 end) debitrpt ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FLocalAmount else 0 end) creditrpt ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" then ve.FLocalAmount else 0 end) yeardebitrpt ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" then ve.FLocalAmount else 0 end) yearcreditrpt ");
        } else {
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FReportingAmount else 0 end)").append(" debitfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FReportingAmount else 0 end)").append(" creditfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" then ve.FReportingAmount else 0 end) yeardebitfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" then ve.FReportingAmount else 0 end) yearcreditfor ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FReportingAmount else 0 end) debitlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FReportingAmount else 0 end) creditlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" then ve.FReportingAmount else 0 end) yeardebitlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" then ve.FReportingAmount else 0 end) yearcreditlocal ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FReportingAmount else 0 end) debitrpt ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FReportingAmount else 0 end) creditrpt ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" then ve.FReportingAmount else 0 end) yeardebitrpt ");
            sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" then ve.FReportingAmount else 0 end) yearcreditrpt ");
        }
        sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FStandardQuantity else 0 end) debitqty ");
        sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" and pd.fnumber >= ").append(startPeriod).append(" then ve.FStandardQuantity else 0 end) creditqty ");
        sql.append(" ,sum(case when ve.FEntryDC =").append(1).append(" then ve.FStandardQuantity else 0 end) yeardebitqty ");
        sql.append(" ,sum(case when ve.FEntryDC =").append(0).append(" then ve.FStandardQuantity else 0 end) yearcreditqty ");
        sql.append(" from t_gl_voucher v ");
        sql.append(" inner join t_gl_voucherentry ve on ve.fbillid = v.fid ");
        sql.append(" inner join t_bd_accountview av on av.fid = ve.faccountid and av.fcompanyid = v.fcompanyid ");
        ArrayList<Object> sp = new ArrayList<Object>();
        sql.append(" inner join t_bd_period pd on pd.fid = v.fperiodid ");
        sql.append(" where v.fbizstatus ").append(condition.getOptionPosting() ? " in (1,3,5)" : "=5");
        sql.append(" and fsourcetype = ").append(1);
        if (isVirtualCompany) {
            sql.append(" and v.fcompanyid in ").append(this.isUseGL053 ? this.companyIdsWithGL053 : partner.getPhysicalCompanyId(false));
        } else {
            sql.append(" and v.fcompanyid = ?");
            sp.add(partner.getCompany().getId().toString());
        }
        sql.append(" and av.faccounttableid = ? ");
        sp.add(partner.getAccountTableId());
        if (isVirtualCompany) {
            sql.append(" and av.fcompanyid in ").append(this.isUseGL053 ? this.companyIdsWithGL053 : partner.getPhysicalCompanyId(false));
        }
        if (condition.isInputCodeStart()) {
            sql.append(" and ").append("av.fnumber >= ?");
            sp.add(condition.getAccountCodeStart());
        }
        if (condition.isInputCodeEnd()) {
            sql.append(" and ").append("av.fnumber < ?");
            sp.add(condition.getAccountCodeEnd() + "zz");
        }
        sql.append(" and pd.fnumber >= ?").append(" and pd.fnumber <=?");
        sp.add(condition.getPeriodYearStart() * 100 + 1);
        sp.add(endPeriod);
        if (!StringUtils.isEmpty((Object)currencyId) && isForCurrency) {
            sql.append(" and ve.fcurrencyid = ?");
            sp.add(currencyId);
        }
        sql.append(" group by ");
        if (isVirtualCompany) {
            sql.append("v.fcompanyid,");
        }
        sql.append(" ve.faccountid");
        sql.append(", pd.fnumber");
        if (isForCurrency) {
            sql.append(", ve.fcurrencyid");
        }
        try {
            List keyValues;
            String[] keys;
            BigDecimal amount;
            DbUtil.execute((Context)partner.getContext(), (String)("insert into " + this.plVoucherTempTable + " " + sql), (Object[])sp.toArray());
            sql.setLength(0);
            sql.append(" select accountid, currencyid, period, yeardebitfor, yearcreditfor, yeardebitlocal, yearcreditlocal, yeardebitrpt, yearcreditrpt, yeardebitqty, yearcreditqty");
            if (isVirtualCompany) {
                sql.append(", companyid");
            }
            sql.append(" from ").append(this.plVoucherTempTable);
            sql.append(" order by");
            if (isVirtualCompany) {
                sql.append(" companyid,");
            }
            sql.append(" accountid, currencyid, period");
            IRowSet rs = DbUtil.executeQuery((Context)partner.getContext(), (String)sql.toString());
            LinkedHashMap plBalance = new LinkedHashMap();
            while (rs.next()) {
                String companyId = "";
                ArrayList<BigDecimal> balance = new ArrayList<BigDecimal>();
                String accountId = rs.getString(1);
                String currency = rs.getString(2);
                int period = rs.getInt(3);
                for (int i = 4; i < 12; ++i) {
                    amount = rs.getBigDecimal(i);
                    balance.add(amount == null || BigDecimal.ZERO.compareTo(amount) == 0 ? BigDecimal.ZERO : amount);
                }
                if (isVirtualCompany) {
                    companyId = rs.getString("companyid");
                }
                String key = companyId + ";" + accountId + ";" + currency + ";" + period;
                plBalance.put(key, balance);
            }
            HashMap<String, List> preInsertSql = new HashMap<String, List>();
            StringBuilder periodSql = new StringBuilder();
            ArrayList<String> sqlList = new ArrayList<String>();
            String[] amountColNames = new String[]{"yeardebitfor", "yearcreditfor", "yeardebitlocal", "yearcreditlocal", "yeardebitrpt", "yearcreditrpt", "yeardebitqty", "yearcreditqty"};
            String[] lastKey = null;
            for (String key : plBalance.keySet()) {
                keys = key.split(";");
                if (lastKey != null && lastKey[0].equals(keys[0]) && lastKey[1].equals(keys[1]) && lastKey[2].equals(keys[2]) && Integer.parseInt(lastKey[3]) / 100 == Integer.parseInt(keys[3]) / 100) {
                    keyValues = (List)plBalance.get(key);
                    List lastKeyValues = (List)plBalance.get(lastKey[0] + ";" + lastKey[1] + ";" + lastKey[2] + ";" + lastKey[3]);
                    periodSql.setLength(0);
                    periodSql.append("update ").append(this.plVoucherTempTable).append(" set ");
                    ArrayList<BigDecimal> newValues = new ArrayList<BigDecimal>();
                    for (int i = 0; i < keyValues.size(); ++i) {
                        amount = ((BigDecimal)keyValues.get(i)).add((BigDecimal)lastKeyValues.get(i));
                        newValues.add(amount);
                        periodSql.append(amountColNames[i]).append("=").append(amount);
                        if (i == keyValues.size() - 1) continue;
                        periodSql.append(", ");
                    }
                    periodSql.append(" where");
                    if (isVirtualCompany) {
                        periodSql.append(" companyid = '").append(keys[0]).append("' and");
                    }
                    periodSql.append(" accountid = '").append(keys[1]).append("' and");
                    periodSql.append(" currencyid = '").append(keys[2]).append("' and");
                    periodSql.append(" period = ").append(keys[3]);
                    sqlList.add(periodSql.toString());
                    plBalance.put(key, newValues);
                }
                lastKey = keys;
            }
            List<Integer> periodNumbers = this.getPeriodByCondition(partner, isVirtualCompany, startPeriod, endPeriod);
            for (String key : plBalance.keySet()) {
                keys = key.split(";");
                keyValues = (List)plBalance.get(key);
                for (int periodNumber : periodNumbers) {
                    String newKey;
                    int plPeriodNumber = Integer.parseInt(keys[3]);
                    if (plPeriodNumber >= periodNumber || periodNumber / 100 != plPeriodNumber / 100 || plBalance.containsKey(newKey = keys[0] + ";" + keys[1] + ";" + keys[2] + ";" + periodNumber)) continue;
                    preInsertSql.put(newKey, keyValues);
                }
            }
            for (String key : preInsertSql.keySet()) {
                keys = key.split(";");
                keyValues = (List)preInsertSql.get(key);
                periodSql.setLength(0);
                periodSql.append("insert into ").append(this.plVoucherTempTable).append("(");
                if (isVirtualCompany) {
                    periodSql.append(" companyid,");
                }
                periodSql.append(" accountid, currencyid, period, yeardebitfor, yearcreditfor, yeardebitlocal, yearcreditlocal, yeardebitrpt, yearcreditrpt, yeardebitqty, yearcreditqty");
                periodSql.append(") values");
                periodSql.append(" (");
                if (isVirtualCompany) {
                    periodSql.append("'").append(keys[0]).append("',");
                }
                periodSql.append("'").append(keys[1]).append("',");
                periodSql.append("'").append(keys[2]).append("',");
                periodSql.append(keys[3]);
                for (int j = 0; j < keyValues.size(); ++j) {
                    periodSql.append(", ").append(keyValues.get(j));
                }
                periodSql.append(")");
                sqlList.add(periodSql.toString());
            }
            RptServerUtil.executeBatch(partner.getContext(), sqlList);
            this.insertPLAccountSum(partner.getContext(), this.plVoucherTempTable, isVirtualCompany);
        }
        catch (Exception e) {
            logger.error((Object)"Execute sql error:", (Throwable)e);
            throw new BOSException("Error sql", (Throwable)e);
        }
    }

    public Set getCompanyIdsWithGL053(ReportPartner partner) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)partner.getFixCondition().getTreeModelOfCompany();
        Enumeration<TreeNode> e = node.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.isLeaf()) continue;
            SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
            idSet.add(userObject.getCompanyId());
        }
        IOrgRange orgRange = OrgRangeFactory.getLocalInstance((Context)partner.getContext());
        BOSUuid currentUserID = ContextUtil.getCurrentUserInfo((Context)partner.getContext()).getId();
        String compId = ContextUtil.getCurrentFIUnit((Context)partner.getContext()).getId().toString();
        List compIdList = orgRange.getOrgIdByUserAndType((IObjectPK)new ObjectUuidPK(currentUserID), OrgRangeType.BIZ_ORG_TYPE);
        HashSet compIdSet = new HashSet(compIdList);
        idSet.retainAll(compIdSet);
        if (idSet.size() == 0) {
            idSet.add(compId);
        }
        return idSet;
    }

    private String genCompanyIdsStr(Set companyIds) {
        StringBuilder ids = new StringBuilder();
        Iterator it = companyIds.iterator();
        ids.append("('").append(it.next()).append("'");
        while (it.hasNext()) {
            ids.append(",'").append(it.next()).append("'");
        }
        ids.append(")");
        return ids.toString();
    }

    protected String getNotIncludePLVoucherSQL(ReportPartner partner, String sql, String plVoucherTempTable) throws BOSException, EASBizException {
        boolean isVirtualCompany = GlUtils.isCompanyUnion(partner.getCompany());
        StringBuilder tempSql = new StringBuilder();
        tempSql.append(" SELECT balTable.FAccountID, balTable.FCompanyID");
        tempSql.append(", balTable.FCurrencyID");
        tempSql.append(", balTable.FPeriod FPeriod ");
        tempSql.append(", balTable.FBeginBalanceFor\t");
        tempSql.append(", balTable.FDebitFor - isnull(plBalTable.DebitFor,0) FDebitFor");
        tempSql.append(", balTable.FCreditFor - isnull(plBalTable.CreditFor,0) FCreditFor");
        tempSql.append(", balTable.FYearDebitFor - isnull(plBalTable.YearDebitFor,0) FYearDebitFor");
        tempSql.append(", balTable.FYearCreditFor - isnull(plBalTable.YearCreditFor,0) FYearCreditFor");
        tempSql.append(", balTable.FEndBalanceFor + isnull(plBalTable.creditFor,0) - isnull(plBalTable.debitFor,0) FEndBalanceFor");
        tempSql.append(", balTable.FBeginBalanceLocal");
        tempSql.append(", balTable.FDebitLocal - isnull(plBalTable.DebitLocal,0) FDebitLocal");
        tempSql.append(", balTable.FCreditLocal - isnull(plBalTable.CreditLocal,0) FCreditLocal");
        tempSql.append(", balTable.FYearDebitLocal - isnull(plBalTable.YearDebitLocal,0) FYearDebitLocal");
        tempSql.append(", balTable.FYearCreditLocal - isnull(plBalTable.YearCreditLocal,0) FYearCreditLocal");
        tempSql.append(", balTable.FEndBalanceLocal + isnull(plBalTable.creditLocal,0) - isnull(plBalTable.debitLocal,0) FEndBalanceLocal");
        tempSql.append(", balTable.FBeginBalanceRpt\t");
        tempSql.append(", balTable.FDebitRpt - isnull(plBalTable.DebitRpt,0) FDebitRpt");
        tempSql.append(", balTable.FCreditRpt - isnull(plBalTable.CreditRpt,0) FCreditRpt");
        tempSql.append(", balTable.FYearDebitRpt - isnull(plBalTable.YearDebitRpt,0) FYearDebitRpt");
        tempSql.append(", balTable.FYearCreditRpt - isnull(plBalTable.YearCreditRpt,0) FYearCreditRpt");
        tempSql.append(", balTable.FEndBalanceRpt + isnull(plBalTable.creditRpt,0) - isnull(plBalTable.debitRpt,0) FEndBalanceRpt");
        tempSql.append(", balTable.FBeginQty ");
        tempSql.append(", balTable.FDebitQty - isnull(plBalTable.DebitQty,0) FDebitQty");
        tempSql.append(", balTable.FCreditQty - isnull(plBalTable.CreditQty,0) FCreditQty");
        tempSql.append(", balTable.FYearDebitQty - isnull(plBalTable.YearDebitQty,0) FYearDebitQty");
        tempSql.append(", balTable.FYearCreditQty - isnull(plBalTable.YearCreditQty,0) FYearCreditQty ");
        tempSql.append(", balTable.FEndQty + isnull(plBalTable.creditQty,0) - isnull(plBalTable.debitQty, 0) FEndQty");
        tempSql.append(" from (").append(sql).append(") balTable");
        tempSql.append(" left outer join ").append(plVoucherTempTable).append(" plBalTable on balTable.FAccountID = plBalTable.accountID");
        if (isVirtualCompany) {
            tempSql.append(" and balTable.FCompanyID = plBalTable.companyid");
        }
        tempSql.append(" and balTable.FPeriod = plBalTable.period ");
        tempSql.append(" and balTable.fcurrencyid = plBalTable.currencyid ");
        return tempSql.toString();
    }

    private List<Integer> getPeriodByCondition(ReportPartner partner, boolean isVirtualCompany, int startPeriod, int endPeriod) throws BOSException, EASBizException {
        PeriodCollection periodCollection = GLRptDaoUtil.getPeriodCollection(partner.getContext(), partner.getCompany().getAccountPeriodType().getId().toString(), startPeriod, endPeriod);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < periodCollection.size(); ++i) {
            result.add(periodCollection.get(i).getNumber());
        }
        return result;
    }

    private int getMaxPLAccountLevel(Context ctx, String plBalanceTable, boolean isVirtualCompany) throws BOSException, SQLException, EASBizException {
        int maxLevel = 0;
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(av.flevel) maxLevel from ").append(plBalanceTable).append(" temp ");
        sql.append(" inner join t_bd_accountview av on av.fid = temp.accountid ");
        if (isVirtualCompany) {
            sql.append(" and av.fcompanyid = temp.companyid ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            maxLevel = rs.getInt("maxLevel");
        }
        return maxLevel;
    }

    private void insertPLAccountSum(Context ctx, String plTempTable, boolean isVirtualCompany) throws BOSException, EASBizException, SQLException {
        for (int maxLevel = this.getMaxPLAccountLevel(ctx, plTempTable, isVirtualCompany); maxLevel > 1; --maxLevel) {
            StringBuffer accountSum = new StringBuffer(" select ");
            if (isVirtualCompany) {
                accountSum.append("t.companyid companyid,");
            }
            accountSum.append(" av.fid accountid ");
            accountSum.append(" ,t.period ");
            accountSum.append(" ,t.currencyid currencyid ");
            accountSum.append(" ,sum(debitfor) debitfor ");
            accountSum.append(" ,sum(creditfor) creditfor ");
            accountSum.append(" ,sum(yeardebitfor) yeardebitfor ");
            accountSum.append(" ,sum(yearcreditfor) yearcreditfor ");
            accountSum.append(" ,sum(debitlocal) debitlocal ");
            accountSum.append(" ,sum(creditlocal) creditlocal ");
            accountSum.append(" ,sum(yeardebitlocal) yeardebitlocal ");
            accountSum.append(" ,sum(yearcreditlocal) yearcreditlocal ");
            accountSum.append(" ,sum(debitrpt) debitrpt ");
            accountSum.append(" ,sum(creditrpt) creditrpt ");
            accountSum.append(" ,sum(yeardebitrpt) yeardebitrpt ");
            accountSum.append(" ,sum(yearcreditrpt) yearcreditrpt ");
            accountSum.append(" ,sum(debitqty) debitqty ");
            accountSum.append(" ,sum(creditqty) creditqty ");
            accountSum.append(" ,sum(yeardebitqty) yeardebitqty ");
            accountSum.append(" ,sum(yearcreditqty) yearcreditqty ");
            accountSum.append(" from ").append(plTempTable).append(" t ");
            accountSum.append(" inner join t_bd_accountview lav on lav.fid = t.accountid ");
            accountSum.append(" inner join t_bd_accountview av on av.fid = lav.fparentid ");
            accountSum.append(" where lav.flevel = ").append(maxLevel);
            accountSum.append(" group by ");
            if (isVirtualCompany) {
                accountSum.append("t.companyid,");
            }
            accountSum.append("av.fid");
            accountSum.append(", t.period");
            accountSum.append(", t.currencyid ");
            DbUtil.execute((Context)ctx, (String)("insert into " + plTempTable + accountSum));
        }
    }

    protected void insertAccountLevelSumData(ReportPartner partner, String strFirstTableName) throws BOSException {
        int maxLevel = this.getMaxLevel(partner.getContext(), strFirstTableName);
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(strFirstTableName);
        sql.append(" \r\n");
        sql.append(" SELECT av.fparentid, t.FCompanyID, t.FCurrencyID, t.FPeriod FPeriod, \r\n");
        sql.append(" sum(t.FBeginBalanceFor), sum(t.FDebitFor), sum(t.FCreditFor), \r\n");
        sql.append(" sum(t.FYearDebitFor), sum(t.FYearCreditFor), sum(t.FEndBalanceFor), \r\n");
        sql.append(" sum(t.FBeginBalanceLocal), sum(t.FDebitLocal), sum(t.FCreditLocal),  \r\n");
        sql.append(" sum(t.FYearDebitLocal), sum(t.FYearCreditLocal), sum(t.FEndBalanceLocal), \r\n");
        sql.append(" sum(t.FBeginBalanceRpt), sum(t.FDebitRpt), sum(t.FCreditRpt), \r\n");
        sql.append(" sum(t.FYearDebitRpt), sum(t.FYearCreditRpt), sum(t.FEndBalanceRpt),  \r\n");
        sql.append(" sum(t.FBeginQty), sum(t.FDebitQty), sum(t.FCreditQty), \r\n");
        sql.append(" sum(t.FYearDebitQty), sum(t.FYearCreditQty), sum(t.FEndQty)  \r\n");
        sql.append(" from ").append(strFirstTableName).append(" t");
        sql.append(" left join t_bd_accountview AV on av.fid = t.faccountid");
        sql.append(" where av.flevel = ? ");
        sql.append(" group by av.fparentid, t.FCompanyID, t.FCurrencyID, t.FPeriod ");
        int topLevel = partner.getFixCondition().getAccountLevelStart();
        for (int i = maxLevel; i > topLevel; --i) {
            DbUtil.execute((Context)partner.getContext(), (String)sql.toString(), (Object[])new Object[]{i});
        }
    }

    protected int getMaxLevel(Context ctx, String table) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(flevel) maxLevel from t_bd_accountview ");
        sql.append(" where fid in (select FAccountID from ").append(table).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int maxLevel = 0;
        try {
            if (rs.next()) {
                maxLevel = rs.getInt("maxLevel");
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL error!", (Throwable)e);
        }
        return maxLevel;
    }
}

