/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.ReportConditionJournal;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportJournalException;
import com.kingdee.eas.fi.gl.ReportLineKey;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadItemInfo;
import com.kingdee.eas.fi.gl.app.AbstractGLReportJournalFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.GLRptHelper;
import com.kingdee.eas.fi.gl.app.ReportPartner;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.common.SqlParameter2;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class GLReportJournalFacadeControllerBean
extends AbstractGLReportJournalFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.GLReportJournalFacadeControllerBean");
    private static final String MAX_ASSTITEM_COUNT = "MaxAsstItemCount";
    protected String strCompanyIds = null;
    private Map<String, Integer> actTypeMap;

    @Override
    protected Object[] getLineObjects(ReportPartner partner, ResultSet rs) throws SQLException, EASBizException, BOSException {
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        String strCurrencyId = condition.getCurrencyID();
        if (strCurrencyId == null) {
            throw new ReportException(ReportException.TODO_UNTYPE);
        }
        boolean isShowForCurrency = this.isShowForCurrency(partner);
        boolean isShowLocalCurrency = this.isShowLocalCurrency(partner);
        boolean isShowReportCurrency = this.isShowReportCurrency(partner);
        int asstCount = 0;
        Object obj = partner.getVariable(MAX_ASSTITEM_COUNT);
        if (obj != null && (Integer)obj > 0) {
            asstCount = (Integer)obj;
        }
        int index = 0;
        int currencyLie = 0;
        int tag = 0;
        tag = rs.getInt("FTag");
        if (partner.getFixCondition().isAllCurrency()) {
            currencyLie = 1;
        }
        int companyLie = 0;
        if (!partner.getCompany().isIsBizUnit()) {
            companyLie = 1;
        }
        int rowSize = 18 + asstCount + currencyLie + companyLie + 2 - (isShowForCurrency ? 0 : 4) - (isShowLocalCurrency ? 0 : 4) - (isShowReportCurrency ? 0 : 4);
        Object[] row = new Object[rowSize];
        String hgId = rs.getString("FAsstHgID");
        String faccountNumber = rs.getString("FAccountNumber");
        String faccountName = rs.getString("FAccountName");
        String expandAccount = (String)condition.getExpandInfo().get("AccountID");
        String companyId = rs.getString("FCompanyID");
        if (StringUtils.isEmpty((String)hgId)) {
            boolean isShow = partner.getCompanyId().equals(companyId);
            row[index++] = condition.isFillInfo() || expandAccount == null && isShow ? faccountNumber : "";
            row[index++] = tag == 2 && (isShow || condition.isFillInfo()) ? partner.TITLE_TOTAL : (condition.isFillInfo() || expandAccount == null && isShow ? faccountName : "");
        } else if (condition.isFillInfo()) {
            row[index++] = faccountNumber;
            row[index++] = faccountName;
        } else {
            row[index++] = null;
            row[index++] = null;
        }
        int curPre = partner.getScaleFor();
        if (partner.getFixCondition().isAllCurrency()) {
            if (tag == -1 || tag == 0) {
                row[index++] = rs.getString("FCurrencyName");
                if (rs.getString("FCurrencyID") != null) {
                    curPre = partner.getAmountScale(rs.getString("FCurrencyID"));
                }
            } else if (tag == 1) {
                row[index++] = partner.TITLE_SUB_TOTAL;
            } else if (tag == 2) {
                String currencyName = rs.getString("FCurrencyName");
                if (currencyName != null) {
                    row[index++] = rs.getString("FCurrencyName");
                    if (rs.getString("FCurrencyID") != null) {
                        curPre = partner.getAmountScale(rs.getString("FCurrencyID"));
                    }
                } else {
                    row[index++] = partner.TITLE_SUB_TOTAL;
                }
            }
        }
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            SimpleCompanyUserObject companyUserObject = partner.getCompanyUserObjectById(companyId);
            if (condition.getExpandCompanyLevel() > 0 && companyUserObject.getLevel() < condition.getExpandCompanyLevel() - 1) {
                companyUserObject.setExpanded(true);
                companyUserObject.setHasExpanded(true);
            }
            if (companyUserObject.isLeaf()) {
                ReportConditionJournal conditionNew = (ReportConditionJournal)partner.getFixCondition();
                if (conditionNew.isOptionShowAsstItem()) {
                    boolean isAccLeafNull;
                    SimpleCompanyUserObject cloned = (SimpleCompanyUserObject)companyUserObject.clone();
                    boolean bl = isAccLeafNull = conditionNew.getExpandInfo().get("AccountIsLeaf") != null && (Boolean)conditionNew.getExpandInfo().get("AccountIsLeaf") != false;
                    if (rs.getString("FAsstHgID") == null || " ".endsWith(rs.getString("FAsstHgID"))) {
                        if (!isAccLeafNull) {
                            cloned.setLeaf(true);
                            row[index++] = cloned;
                        } else {
                            cloned.setLeaf(false);
                            row[index++] = cloned;
                        }
                    } else {
                        cloned.setLeaf(true);
                        cloned.setLevel(cloned.getLevel() + 1);
                        if (!condition.isFillInfo()) {
                            cloned.setName("");
                            row[index++] = null;
                        } else {
                            row[index++] = cloned;
                        }
                    }
                } else {
                    row[index++] = companyUserObject.clone();
                }
            } else {
                row[index++] = companyUserObject.clone();
            }
        }
        String asstNameL = rs.getString("FAsstName");
        String asstNameD = rs.getString("FdisplaynameGroup");
        String asstNameN = rs.getString("FNumberGroup");
        if (StringUtils.isEmpty((String)asstNameL)) {
            for (int i = 0; i < asstCount; ++i) {
                row[index++] = null;
            }
        } else {
            String[] strAsstNameL = asstNameL.trim().split(";");
            String[] strAsstNameD = asstNameD.trim().split(";");
            String[] strAsstNameN = asstNameN.trim().split(";");
            int splitLen = strAsstNameL.length;
            String number = null;
            int acctTypeFlag = 0;
            if (this.actTypeMap == null) {
                this.actTypeMap = GLRptHelper.initAcctTypeMap(partner.getContext());
            }
            for (int i = 0; i < asstCount; ++i) {
                if (i < splitLen) {
                    strAsstNameL[i] = strAsstNameL[i] == null ? null : VoucherUtil.decodeSplitFlag(strAsstNameL[i]);
                    strAsstNameD[i] = strAsstNameD[i] == null ? null : VoucherUtil.decodeSplitFlag(strAsstNameD[i]);
                    String string = strAsstNameN[i] = strAsstNameN[i] == null ? null : VoucherUtil.decodeSplitFlag(strAsstNameN[i]);
                    if (number == null && this.actTypeMap.get(number = strAsstNameN[i].substring(0, strAsstNameN[i].indexOf("_!"))) != null) {
                        acctTypeFlag = this.actTypeMap.get(number);
                    }
                    row[index++] = GLRptHelper.getAssDisplayName4Jour(partner.isParmAssitemShowNumber(), partner.isRptShowLongNameFromGeneral(), partner.isRptShowLongNumberFromGeneral(), acctTypeFlag, strAsstNameL[i], strAsstNameD[i], strAsstNameN[i]);
                    continue;
                }
                row[index++] = null;
            }
        }
        int iDC = rs.getInt("FDC");
        BigDecimal beginBalanceFor = new BigDecimal("0");
        if (isShowForCurrency) {
            beginBalanceFor = rs.getBigDecimal("FBeginBalanceFor");
        }
        BigDecimal beginBalanceLocal = new BigDecimal("0");
        if (isShowLocalCurrency) {
            beginBalanceLocal = rs.getBigDecimal("FBeginBalanceLocal");
        }
        BigDecimal beginBalanceRpt = new BigDecimal("0");
        if (isShowReportCurrency) {
            beginBalanceRpt = rs.getBigDecimal("FBeginBalancerpt");
        }
        if (tag == 2) {
            row[index++] = null;
            if (isShowForCurrency) {
                row[index++] = this.getBigDecimalForScale(beginBalanceFor, curPre);
            }
            if (isShowLocalCurrency) {
                row[index++] = this.getBigDecimalForScale(beginBalanceLocal, partner.getScaleLocal());
            }
            if (isShowReportCurrency) {
                row[index++] = this.getBigDecimalForScale(beginBalanceRpt, partner.getScaleRpt());
            }
        } else {
            if (tag == 1) {
                row[index++] = partner.getDCStringWithParm(isShowForCurrency && beginBalanceFor.compareTo(new BigDecimal("0")) != 0 ? beginBalanceFor : (isShowLocalCurrency && beginBalanceLocal.compareTo(new BigDecimal("0")) != 0 ? beginBalanceLocal : beginBalanceRpt), iDC);
            } else {
                row[index++] = partner.getDCStringWithParm(isShowForCurrency ? beginBalanceFor : (isShowLocalCurrency ? beginBalanceLocal : beginBalanceRpt), iDC);
            }
            if (isShowForCurrency) {
                row[index++] = this.getBigDecimalForScale(partner.getBalanceForDCWithParm(beginBalanceFor, iDC), curPre);
            }
            if (isShowLocalCurrency) {
                row[index++] = this.getBigDecimalForScale(partner.getBalanceForDCWithParm(beginBalanceLocal, iDC), partner.getScaleLocal());
            }
            if (isShowReportCurrency) {
                row[index++] = this.getBigDecimalForScale(partner.getBalanceForDCWithParm(beginBalanceRpt, iDC), partner.getScaleRpt());
            }
        }
        if (isShowForCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FDebitFor"), curPre);
        }
        if (isShowLocalCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FDebitLocal"), partner.getScaleLocal());
        }
        if (isShowReportCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FDebitRpt"), partner.getScaleRpt());
        }
        if (isShowForCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FCreditFor"), curPre);
        }
        if (isShowLocalCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FCreditLocal"), partner.getScaleLocal());
        }
        if (isShowReportCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FCreditRpt"), partner.getScaleRpt());
        }
        BigDecimal endBalanceFor = new BigDecimal("0");
        if (isShowForCurrency) {
            endBalanceFor = rs.getBigDecimal("FEndBalanceFor");
        }
        BigDecimal endBalanceLocal = new BigDecimal("0");
        if (isShowLocalCurrency) {
            endBalanceLocal = rs.getBigDecimal("FEndBalanceLocal");
        }
        BigDecimal endBalanceRpt = new BigDecimal("0");
        if (isShowReportCurrency) {
            endBalanceRpt = rs.getBigDecimal("FEndBalanceRpt");
        }
        if (tag == 2) {
            row[index++] = null;
            if (isShowForCurrency) {
                row[index++] = this.getBigDecimalForScale(endBalanceFor, curPre);
            }
            if (isShowLocalCurrency) {
                row[index++] = this.getBigDecimalForScale(endBalanceLocal, partner.getScaleLocal());
            }
            if (isShowReportCurrency) {
                row[index++] = this.getBigDecimalForScale(endBalanceRpt, partner.getScaleRpt());
            }
        } else {
            if (tag == 1) {
                row[index++] = partner.getDCStringWithParm(isShowForCurrency && endBalanceFor.compareTo(new BigDecimal("0")) != 0 ? endBalanceFor : (isShowLocalCurrency && endBalanceLocal.compareTo(new BigDecimal("0")) != 0 ? endBalanceLocal : endBalanceRpt), iDC);
            } else {
                row[index++] = partner.getDCStringWithParm(isShowForCurrency ? endBalanceFor : (isShowLocalCurrency ? endBalanceLocal : endBalanceRpt), iDC);
            }
            if (isShowForCurrency) {
                row[index++] = this.getBigDecimalForScale(partner.getBalanceForDCWithParm(endBalanceFor, iDC), curPre);
            }
            if (isShowLocalCurrency) {
                row[index++] = this.getBigDecimalForScale(partner.getBalanceForDCWithParm(endBalanceLocal, iDC), partner.getScaleLocal());
            }
            if (isShowReportCurrency) {
                row[index++] = this.getBigDecimalForScale(partner.getBalanceForDCWithParm(endBalanceRpt, iDC), partner.getScaleRpt());
            }
        }
        int debitCount = rs.getInt("FDebitCount");
        int creditCount = rs.getInt("FCredtiCount");
        row[index++] = debitCount > 0 ? new Integer(debitCount) : null;
        row[index++] = creditCount > 0 ? new Integer(creditCount) : null;
        row[index++] = tag == 1 ? ReportResultInfo.LINE_YEAR_TOTAL : (tag == 2 ? ReportResultInfo.LINE_TOTAL : ReportResultInfo.LINE_NORMAL);
        ReportLineKey lineKey = new ReportLineKey();
        lineKey.setCompanyID(rs.getString("FCompanyID"));
        lineKey.setStrAccountID(rs.getString("FAccountID"));
        lineKey.setStrAccountNumber(faccountNumber);
        lineKey.setStrAccountName(faccountName);
        lineKey.setAccountLeaf(rs.getInt("FAccountIsLeaf") == 1);
        if (condition.isOptionShowAsstItem()) {
            lineKey.setAssistghId(hgId);
        }
        if (condition.isAllCurrency()) {
            if (tag == 2 && " ".equals(rs.getString("fcurrencyid"))) {
                lineKey.setStrCurrencyId("AllCurrency");
                lineKey.setStrCurrencyName(GLResUtil.getRes("all_currency"));
            } else if (tag == 1 && " ".equals(rs.getString("fcurrencyid"))) {
                lineKey.setStrCurrencyId("AllCurrency");
            } else {
                lineKey.setStrCurrencyId(rs.getString("fcurrencyid"));
                lineKey.setStrCurrencyName(rs.getString("fcurrencyname"));
            }
        }
        row[index++] = lineKey;
        return row;
    }

    protected Object[] getTotalLineObjects(ReportPartner partner, ResultSet rs) throws SQLException, EASBizException, BOSException {
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        String strCurrencyId = condition.getCurrencyID();
        if (strCurrencyId == null) {
            throw new ReportException(ReportException.TODO_UNTYPE);
        }
        boolean isShowForCurrency = this.isShowForCurrency(partner);
        boolean isShowLocalCurrency = this.isShowLocalCurrency(partner);
        boolean isShowReportCurrency = this.isShowReportCurrency(partner);
        int asstCount = 0;
        Object obj = partner.getVariable(MAX_ASSTITEM_COUNT);
        if (obj != null && (Integer)obj > 0) {
            asstCount = (Integer)obj;
        }
        int index = 0;
        int rowSize = 18 + asstCount + 2 - (isShowForCurrency ? 0 : 4) - (isShowLocalCurrency ? 0 : 4) - (isShowReportCurrency ? 0 : 4);
        Object[] row = new Object[rowSize];
        row[index++] = null;
        row[index++] = null;
        for (int i = 0; i < asstCount; ++i) {
            row[index++] = null;
        }
        row[index++] = null;
        if (isShowForCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FBeginBalanceFor"), partner.getScaleFor());
        }
        if (isShowLocalCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FBeginBalanceLocal"), partner.getScaleLocal());
        }
        if (isShowReportCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FBeginBalancerpt"), partner.getScaleRpt());
        }
        if (isShowForCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FDebitFor"), partner.getScaleFor());
        }
        if (isShowLocalCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FDebitLocal"), partner.getScaleLocal());
        }
        if (isShowReportCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FDebitRpt"), partner.getScaleRpt());
        }
        if (isShowForCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FCreditFor"), partner.getScaleFor());
        }
        if (isShowLocalCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FCreditLocal"), partner.getScaleLocal());
        }
        if (isShowReportCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FCreditRpt"), partner.getScaleRpt());
        }
        row[index++] = null;
        if (isShowForCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FEndBalanceFor"), partner.getScaleFor());
        }
        if (isShowLocalCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FEndBalanceLocal"), partner.getScaleLocal());
        }
        if (isShowReportCurrency) {
            row[index++] = this.getBigDecimalForScale(rs.getBigDecimal("FEndBalanceRpt"), partner.getScaleRpt());
        }
        int debitCount = rs.getInt("FDebitCount");
        int creditCount = rs.getInt("FCredtiCount");
        row[index++] = debitCount > 0 ? new Integer(debitCount) : null;
        row[index++] = creditCount > 0 ? new Integer(creditCount) : null;
        row[index++] = ReportResultInfo.LINE_TOTAL;
        row[index++] = null;
        return row;
    }

    @Override
    protected String getSqlForDataSelect(ReportPartner partner) throws BOSException, EASBizException, ReportException {
        String currencyId = partner.getFixCondition().getCurrencyID();
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append(" T_Main.FAccountID AS FAccountID, \r\n");
        sqlSelect.append(" TA.FDC AS FDC, \r\n");
        sqlSelect.append(" TA.FIsLeaf AS FIsLeaf, \r\n");
        sqlSelect.append(" TA.FNumber AS FAccountNumber,\r\n");
        sqlSelect.append(this.getAccountName(partner));
        sqlSelect.append(partner.getFieldNameExtend());
        sqlSelect.append(" FAccountName, \r\n");
        sqlSelect.append(" TA.FLevel AS FLevel , \r\n");
        sqlSelect.append(" T_Main.FAsstHgID as FAsstHgID,\r\n");
        sqlSelect.append(" case when HG.FNumberGroup").append(partner.getFieldNameExtend());
        sqlSelect.append(" is null then N' ' else HG.FNumberGroup").append(partner.getFieldNameExtend());
        sqlSelect.append(" end as FAsstNumberGroup, \r\n");
        boolean showLongNameFromGeneral = partner.isRptShowLongNameFromGeneral();
        boolean parmAssitemShowNumber = partner.isParmAssitemShowNumber();
        sqlSelect.append(" HG.FdisplaynameGroup").append(partner.getFieldNameExtend()).append(" as  FdisplaynameGroup,\r\n");
        sqlSelect.append(" HG.FNumberGroup").append(partner.getFieldNameExtend()).append(" as  FNumberGroup,\r\n");
        sqlSelect.append(" HG.flongnamegroup").append(partner.getFieldNameExtend()).append(" as  FAsstName,\r\n");
        if (partner.getFixCondition().isAllCurrency()) {
            sqlSelect.append(" currency.fname_l2 AS FCurrencyName,  \r\n");
            sqlSelect.append(" T_Main.FCurrencyID AS FCurrencyID,  \r\n");
        }
        sqlSelect.append(" T_Main.FCompanyID FCompanyID, \r\n");
        if (isForCurrency) {
            sqlSelect.append(" T_Main.FBeginBalanceFor AS FBeginBalanceFor,  \r\n");
            sqlSelect.append(" T_Main.FDebitFor AS FDebitFor, \r\n");
            sqlSelect.append(" T_Main.FCreditFor AS FCreditFor, \r\n");
            sqlSelect.append(" T_Main.FEndBalanceFor AS FEndBalanceFor, \r\n");
        }
        if (isLocaCurrency || isForCurrency) {
            sqlSelect.append(" T_Main.FBeginBalanceLocal AS FBeginBalanceLocal, \r\n");
            sqlSelect.append(" T_Main.FDebitLocal AS FDebitLocal, \r\n");
            sqlSelect.append(" T_Main.FCreditLocal AS FCreditLocal, \r\n");
            sqlSelect.append(" T_Main.FEndBalanceLocal AS FEndBalanceLocal,\r\n");
        }
        if (isRptCurrency || isForCurrency) {
            sqlSelect.append(" T_Main.FBeginBalanceRpt AS FBeginBalanceRpt, \r\n");
            sqlSelect.append(" T_Main.FDebitRpt AS FDebitRpt, \r\n");
            sqlSelect.append(" T_Main.FCreditRpt AS FCreditRpt,\r\n");
            sqlSelect.append(" T_Main.FEndBalanceRpt AS FEndBalanceRpt, \r\n");
        }
        sqlSelect.append(" T_Main.FDebitCount AS FDebitCount, \r\n");
        sqlSelect.append(" T_Main.FCredtiCount AS FCredtiCount \r\n");
        sqlSelect.append(" ,T_Main.FTag AS FTag \r\n");
        sqlSelect.append(" ,T_Main.FLineType AS FLineType \r\n");
        sqlSelect.append(" ,TA.FIsLeaf FAccountIsLeaf \r\n");
        return sqlSelect.toString();
    }

    private String getAccountName(ReportPartner partner) throws BOSException, EASBizException {
        HashMap<String, String> paramKeyMap = new HashMap<String, String>();
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)partner.getContext());
        boolean isAccountShowLongName = false;
        paramKeyMap.put("GL_012", partner.getCompany().getId().toString());
        String strAccountShowLongName = (String)iParamControl.getParamHashMap(paramKeyMap).get("GL_012");
        if (strAccountShowLongName != null && strAccountShowLongName.trim().length() > 0) {
            isAccountShowLongName = Boolean.valueOf(strAccountShowLongName.trim());
        }
        return isAccountShowLongName ? " TA.FLongName" : " TA.FName";
    }

    @Override
    protected String getSqlForDataFrom(ReportPartner partner) throws BOSException, EASBizException {
        StringBuffer sqlFrom = new StringBuffer();
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        String currencyId = partner.getFixCondition().getCurrencyID();
        boolean isForCurrency = !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId);
        boolean isNeedAccountID = (Boolean)condition.getExpandInfo().get("isNeedAccountID");
        sqlFrom.append(" from ").append(partner.getTempTableName()).append(" AS T_Main \r\n");
        sqlFrom.append(" left JOIN T_BD_AccountView AS TA ON T_Main.FAccountID = TA.FID \r\n");
        String expandCurrency = (String)condition.getExpandInfo().get("CurrencyIDa");
        if (expandCurrency != null && expandCurrency.trim().length() > 0 && !expandCurrency.equals("AllCurrency") && isNeedAccountID) {
            sqlFrom.append(" INNER JOIN t_BD_CURRENCY currency ON T_Main.FCurrencyID = currency.FID \r\n");
            sqlFrom.append(" and currency.FID = '").append(expandCurrency).append("' ");
        } else if (isForCurrency) {
            sqlFrom.append(" LEFT JOIN T_BD_Currency AS currency ON T_Main.FCurrencyID = currency.FID \r\n");
        }
        sqlFrom.append(" LEFT JOIN T_BD_AssistantHG AS HG ON T_Main.FAsstHgID = HG.FID \r\n");
        sqlFrom.append(" LEFT JOIN T_org_company com ON T_Main.Fcompanyid = com.FID \r\n");
        EntityViewInfo evi = partner.getCondition();
        ReportConditionBase customCondition = (ReportConditionBase)evi.get("GLFixCondition");
        String expandAccount = (String)customCondition.getExpandInfo().get("AccountID");
        if (expandAccount != null && expandAccount.trim().length() != 0 && isNeedAccountID) {
            sqlFrom.append(" inner join t_bd_accountview D on D.fnumber=TA.fnumber and D.fid='").append(expandAccount).append("' \r\n");
        }
        return sqlFrom.toString();
    }

    @Override
    protected String getSqlForDataWhere(ReportPartner partner) throws EASBizException, BOSException {
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        StringBuffer sqlFrom = new StringBuffer();
        sqlFrom.append(" WHERE (TA.FAccountTableID = ? AND ");
        sqlFrom.append("TA.FLevel >=? AND TA.FLevel <= ? \r\n");
        if (condition.isAllCurrency() || GlUtils.isCompanyUnion(partner.getCompany()) && condition.isOptionShowTotal()) {
            sqlFrom.append(" or TA.fid is null \r\n");
        }
        sqlFrom.append(")");
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValueChar(partner.getAccountTableId());
        parameter.addValue(new Integer(condition.getAccountLevelStart()));
        parameter.addValue(new Integer(condition.getAccountLevelEnd()));
        this.setParameters(partner, parameter);
        return sqlFrom.toString();
    }

    @Override
    protected String getSqlForDataOrder(ReportPartner partner) throws BOSException, ReportException {
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            if (partner.getFixCondition().isAllCurrency()) {
                return " Order By T_Main.FLineType,TA.FLongNumber, case when currency.fnumber is null then 'zzzzzz' else currency.fnumber end,com.flongnumber,FAsstNumberGroup,T_Main.FTag ASC";
            }
            return " Order By T_Main.FLineType,TA.FLongNumber,com.flongnumber,FAsstNumberGroup ASC";
        }
        if (partner.getFixCondition().isAllCurrency()) {
            return " Order By T_Main.FLineType,TA.FLongNumber, case when currency.fnumber is null then 'zzzzzz' else currency.fnumber end, FAsstNumberGroup, T_Main.FTag ASC";
        }
        return " Order By T_Main.FLineType,TA.FLongNumber,FAsstNumberGroup ASC";
    }

    @Override
    protected String getReportName() {
        return "GLReportJournal";
    }

    @Override
    protected String getAuthorityName() {
        return "GLReportJournal";
    }

    protected String getQueryName() {
        return "com.kingdee.eas.fi.gl.app.GLReportJournalQuery";
    }

    @Override
    protected ReportTableHeadInfo getDefalutTableHeadInfo(ReportPartner partner) throws ReportException {
        ArrayList<ReportTableHeadItemInfo> items = new ArrayList<ReportTableHeadItemInfo>();
        items.add(this.addHeadItemInfo("FAccountNumber", 80, 0, true, true, true, new String[]{"AccountCode", "AccountCode"}, 0, 0, false));
        items.add(this.addHeadItemInfo("FAccountName", 160, 0, true, true, true, new String[]{"AccountName", "AccountName"}, 0, 0, false));
        items.add(this.addHeadItemInfo("FCurrencyName", 80, 0, true, false, false, new String[]{"CurrencyName", "CurrencyName"}, 0, 0, false));
        items.add(this.addHeadItemInfo("FCompany", 200, 0, true, false, true, new String[]{"FCompany", "FCompany"}, 0, 0, false));
        items.add(this.addHeadItemInfo("FBalBeginOritention", 30, 1, false, false, true, new String[]{"BalanceBegin", "Oriention"}, 0, 0, false));
        items.add(this.addHeadItemInfo("FBalanceBeginFor", 110, 2, false, false, true, new String[]{"BalanceBegin", "Amount"}, 1, 0, true));
        items.add(this.addHeadItemInfo("FBalanceBeginLocal", 0, 2, false, false, false, new String[]{"BalanceBegin", "Amount"}, 1, 0, true));
        items.add(this.addHeadItemInfo("FBalanceBeginRpt", 0, 2, false, false, false, new String[]{"BalanceBegin", "Amount"}, 1, 0, true));
        items.add(this.addHeadItemInfo("FDebitFor", 110, 2, false, false, true, new String[]{"Debit", "Debit"}, 1, 0, true));
        items.add(this.addHeadItemInfo("FDebitLocal", 0, 2, false, false, false, new String[]{"Debit", "Debit"}, 1, 0, true));
        items.add(this.addHeadItemInfo("FDebitRpt", 0, 2, false, false, false, new String[]{"Debit", "Debit"}, 1, 0, true));
        items.add(this.addHeadItemInfo("FCreditFor", 110, 2, false, false, true, new String[]{"Credit", "Credit"}, 1, 0, true));
        items.add(this.addHeadItemInfo("FCreditLocal", 0, 2, false, false, false, new String[]{"Credit", "Credit"}, 1, 0, true));
        items.add(this.addHeadItemInfo("FCreditRpt", 0, 2, false, false, false, new String[]{"Credit", "Credit"}, 1, 0, true));
        items.add(this.addHeadItemInfo("FBalEndOritention", 30, 1, false, false, true, new String[]{"BalanceEnd", "Oriention"}, 0, 0, false));
        items.add(this.addHeadItemInfo("FBalanceEndFor", 110, 2, false, false, true, new String[]{"BalanceEnd", "Amount"}, 1, 0, true));
        items.add(this.addHeadItemInfo("FBalanceEndLocal", 0, 2, false, false, false, new String[]{"BalanceEnd", "Amount"}, 1, 0, true));
        items.add(this.addHeadItemInfo("FBalanceEndRpt", 0, 2, false, false, false, new String[]{"BalanceEnd", "Amount"}, 1, 0, true));
        items.add(this.addHeadItemInfo("FDebitNumber", 90, 2, false, false, true, new String[]{"DebitNumber", "DebitNumber"}, 0, 0, false));
        items.add(this.addHeadItemInfo("FCreditNumber", 90, 2, false, false, true, new String[]{"CreditNumber", "CreditNumber"}, 0, 0, false));
        ReportTableHeadItemInfo[] columns = new ReportTableHeadItemInfo[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            columns[i] = (ReportTableHeadItemInfo)items.get(i);
        }
        ReportTableHeadInfo head = new ReportTableHeadInfo(columns);
        head.setHeadMerge(true);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
        return head;
    }

    @Override
    protected void insertDataIntoTempTable(ReportPartner partner) throws EASBizException, BOSException {
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        PeriodInfo theNearPeriod = this.getNearPeriod(partner);
        String strStructure = this.getTempTableStructure(partner);
        String strTempTable = partner.createTempTableAsynchronism("GLJUR", strStructure);
        partner.setTempTableName(strTempTable);
        String leafAccBalanceTemp = partner.createTempTable("GLJOUR", strStructure);
        this.insertTempDataAcct(partner, leafAccBalanceTemp, theNearPeriod);
        if (condition.isOptionShowAsstItem()) {
            this.insertTempDataAsst(partner, leafAccBalanceTemp, theNearPeriod);
        }
        this.insertNotUseAccount(partner, leafAccBalanceTemp);
        this.insertLeafAccountSumData(partner, leafAccBalanceTemp, strTempTable);
        this.insertAccountLevelSumData(partner, strTempTable);
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            if (partner.getFixCondition().isAllCurrency()) {
                this.insertSumAccountCurrencyUnion(partner);
            } else if (condition.isOptionShowTotal()) {
                this.insertSumAccountGroupByCurrencyUnion(partner);
            }
        } else if (partner.getFixCondition().isAllCurrency()) {
            this.insertSumAccountCurrency(partner);
        }
    }

    private PeriodInfo getNearPeriod(ReportPartner partner) throws EASBizException, BOSException, ReportJournalException, ReportException {
        PeriodInfo period;
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        PeriodInfo theNearPeriod = this.getTheNearPeriod(partner, condition.getDateBegin());
        if (theNearPeriod == null) {
            throw new ReportJournalException(ReportJournalException.JOURNAL_PERIOD_NOTEXSITING);
        }
        PeriodInfo currentPeriod = null;
        currentPeriod = GlUtils.isCompanyUnion(partner.getCompany()) ? this.getVirturePeriod(partner) : partner.getCurrentPeriod();
        if (currentPeriod == null) {
            throw new ReportException(ReportException.CURRENCY_PERIOD_ERROR);
        }
        if (currentPeriod.getNumber() < theNearPeriod.getNumber() && currentPeriod.getNumber() != 0) {
            theNearPeriod = currentPeriod;
        }
        for (int i = 0; i < 2 && theNearPeriod.isIsAdjustPeriod() && (period = PeriodUtils.getPrePeriodInfo((Context)partner.getContext(), (PeriodInfo)theNearPeriod)) != null; ++i) {
            theNearPeriod = period;
        }
        return theNearPeriod;
    }

    private void insertNotUseAccount(ReportPartner partner, String strFirstTempTableName) throws EASBizException, BOSException {
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        if (condition.isOptionNOTDisplayIfBalanceZero() || condition.isOptionNOTDisplayIfNoAmount()) {
            return;
        }
        String currencyId = partner.getFixCondition().getCurrencyID();
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO ").append(strFirstTempTableName).append(" \r\n");
        sql.append(" SELECT FID FAccountID, \r\n");
        if (isForCurrency) {
            sql.append("'");
            sql.append(currencyId == null ? " " : currencyId);
            sql.append("' FCurrencyID, \r\n");
        }
        sql.append("TA.FCompanyID,null FAsstHgID, \r\n");
        if (isForCurrency) {
            sql.append(" 0.0 FBeginBalanceFor, \r\n");
            sql.append(" 0.0 FDebitFor, \r\n");
            sql.append(" 0.0 FCreditFor, \r\n");
            sql.append(" 0.0 FEndBalanceFor, \r\n");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append(" 0.0 FBeginBalanceLocal, \r\n");
            sql.append(" 0.0 FDebitLocal , \r\n");
            sql.append(" 0.0 FCreditLocal, \r\n");
            sql.append(" 0.0 FEndBalanceLocal, \r\n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" 0.0 FBeginBalanceRpt, \r\n");
            sql.append(" 0.0 FDebitRpt, \r\n");
            sql.append(" 0.0 FCreditRpt, \r\n");
            sql.append(" 0.0 FEndBalanceRpt, \r\n");
        }
        sql.append(" 0 FDebitCount, \r\n");
        sql.append(" 0 FCredtiCount, \r\n");
        sql.append(" -1 FTag, \r\n");
        sql.append(" 0 FLineType \r\n");
        if (GlUtils.isCompanyUnion(partner.getCompany()) && condition.isOptionShowAsstItem()) {
            sql.append(" ,2 AS FAccountOrAssist \r\n");
        }
        sql.append(" FROM T_BD_AccountView TA \r\n");
        sql.append(" WHERE ");
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            sql.append(" TA.FCompanyId in ").append(this.getStrCompanyIds(partner)).append(" \r\n");
        } else {
            sql.append(" TA.FCompanyId = ? \r\n");
        }
        sql.append(" AND TA.FIsLeaf = 1");
        sql.append(" AND TA.FAccountTableId = ? \r\n");
        sql.append(" AND (TA.FLevel >=?) AND (TA.FLevel <= ?) \r\n");
        if (partner.getCurrencyType() == 0 && !condition.isAllCurrency()) {
            sql.append(" AND (TA.FCurrencyID = ? OR TA.FCurrencyID IS NULL) \r\n");
        } else if (condition.isAllCurrency()) {
            sql.append(" AND TA.FCurrencyID IS NOT NULL \r\n");
        }
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            sql.append(" AND (TA.FNumber >= ?) \r\n");
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            sql.append(" AND (TA.FNumber <= ?) \r\n");
        }
        sql.append(" and not exists (select faccountid from ").append(strFirstTempTableName).append(" temp \r\n");
        sql.append(" where temp.faccountid = ta.fid)");
        SqlParameter2 parameter = new SqlParameter2();
        if (!GlUtils.isCompanyUnion(partner.getCompany())) {
            parameter.addValueChar(partner.getCompanyId());
        }
        parameter.addValueChar(partner.getAccountTableId());
        parameter.addValue(new Integer(condition.getAccountLevelStart()));
        parameter.addValue(new Integer(condition.getAccountLevelEnd()));
        if (partner.getCurrencyType() == 0 && !condition.isAllCurrency()) {
            parameter.addValueChar(partner.getFixCondition().getCurrencyID());
        }
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            parameter.addValueVarchar(condition.getAccountCodeStart());
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            parameter.addValueVarchar(condition.getAccountCodeEnd() + "zz");
        }
        DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(sql.toString()));
    }

    private void insertTempDataAcct(ReportPartner partner, String strFirstTempTableName, PeriodInfo theNearPeriod) throws EASBizException, BOSException {
        if (theNearPeriod == null) {
            return;
        }
        this.insertTempDataAcctBalance(partner, strFirstTempTableName, theNearPeriod);
        this.insertTempDataAcctVoucher(partner, strFirstTempTableName, theNearPeriod);
    }

    private void insertTempDataAcctBalance(ReportPartner partner, String strFirstTempTableName, PeriodInfo theNearPeriod) throws EASBizException, BOSException {
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        String table = GLBalanceUtils.getAccountBalanceTable(condition.getOptionPosting() ? 1 : 5, condition.getCurrencyID());
        String currencyId = condition.getCurrencyID();
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer strBuffer = new StringBuffer();
        StringBuffer selectSql = new StringBuffer();
        strBuffer.append(" SELECT tb.FAccountID AS FAccountID, \r\n");
        selectSql.append(" select av.fid as faccountid,");
        if (isForCurrency) {
            strBuffer.append(" tb.FCurrencyID as FCurrencyID, \r\n");
            if (condition.isAllCurrency()) {
                selectSql.append(" isnull(t.FCurrencyID,'").append(partner.getCompany().getBaseCurrency().getId().toString()).append("') FCurrencyID,");
            } else {
                selectSql.append("'" + currencyId + "' FCurrencyID,");
            }
        }
        strBuffer.append(" tb.forgunitID as FCompanyID , null as FAsstHgID, \r\n");
        selectSql.append(" av.FCompanyID , t.FAsstHgID, \r\n");
        if (isForCurrency) {
            strBuffer.append(" tb.FBeginBalanceFor AS FBeginBalanceFor,\r\n");
            strBuffer.append(" 0.0 AS FDebitFor, \r\n");
            strBuffer.append(" 0.0 AS FCreditFor, \r\n");
            strBuffer.append(" tb.FBeginBalanceFor AS FEndBalanceFor, \r\n");
            selectSql.append(" isnull(t.FBeginBalanceFor, 0), 0.0 as FDebitFor, 0.0 AS FCreditFor, isnull(t.FEndBalanceFor, 0), ");
        }
        if (isLocaCurrency || isForCurrency) {
            strBuffer.append(" tb.FBeginBalanceLocal AS FBeginBalanceLocal,\r\n");
            strBuffer.append(" 0.0 AS FDebitLocal, \r\n");
            strBuffer.append(" 0.0 AS FCreditLocal, \r\n");
            strBuffer.append(" tb.FBeginBalanceLocal AS FEndBalanceLocal, \r\n");
            selectSql.append(" isnull(t.FBeginBalanceLocal, 0), 0.0 AS FDebitLocal, 0.0 AS FCreditLocal, isnull(t.FEndBalanceLocal, 0),");
        }
        if (isRptCurrency || isForCurrency) {
            strBuffer.append(" tb.FBeginBalanceRpt AS FBeginBalanceRpt,\r\n");
            strBuffer.append(" 0.0 AS FDebitRpt, \r\n");
            strBuffer.append(" 0.0 AS FCreditRpt, \r\n");
            strBuffer.append(" tb.FBeginBalanceRpt AS FEndBalanceRpt, \r\n");
            selectSql.append(" isnull(t.FBeginBalanceRpt, 0), 0.0 AS FDebitRpt, 0.0 AS FCreditRpt, isnull(t.FEndBalanceRpt, 0),");
        }
        strBuffer.append(" 0 AS FDebitCount, \r\n");
        strBuffer.append(" 0 AS FCredtiCount, \r\n");
        strBuffer.append(" -1 FTag , \r\n");
        strBuffer.append(" 0 FLineType \r\n");
        selectSql.append(" 0, 0, -1, 0");
        if (GlUtils.isCompanyUnion(partner.getCompany()) && condition.isOptionShowAsstItem()) {
            strBuffer.append(" ,2 AS FAccountOrAssist  \r\n");
            selectSql.append(" ,2");
        }
        strBuffer.append(" FROM " + table + " as tb \r\n");
        strBuffer.append(" INNER JOIN T_BD_AccountView as ta ON tb.fAccountID = ta.fid \r\n");
        strBuffer.append(" WHERE ");
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            strBuffer.append("(( tb.FOrgUnitID in ").append(this.getStrCompanyIds(partner)).append(" AND tb.FPeriod = ? ");
            strBuffer.append(" and tb.forgunitid not in (select sysctrl.FCompanyID from T_BD_SYSTEMSTATUSCTROL sysctrl \r\n");
            strBuffer.append(" INNER JOIN T_BD_SYSTEMSTATUS tsst ON sysctrl.FSystemStatusID=tsst.FID \r\n");
            strBuffer.append(" inner join t_bd_period p on sysctrl.FStartPeriodID = p.fid \r\n");
            strBuffer.append(" where tsst.FName=6 AND sysctrl.FISSTART=1 and sysctrl.FCompanyID in ").append(this.getStrCompanyIds(partner));
            strBuffer.append(" and p.fnumber > ? )) \r\n");
            strBuffer.append(" or exists (select 1 from T_BD_SYSTEMSTATUSCTROL sysctrl \r\n");
            strBuffer.append(" INNER JOIN T_BD_SYSTEMSTATUS tsst ON sysctrl.FSystemStatusID=tsst.FID \r\n");
            strBuffer.append(" inner join t_bd_period p on sysctrl.FStartPeriodID = p.fid \r\n");
            strBuffer.append(" where tsst.FName=6 AND sysctrl.FISSTART=1 and sysctrl.FCompanyID in ").append(this.getStrCompanyIds(partner));
            strBuffer.append(" and p.fnumber > ? and tb.FOrgUnitID=sysctrl.FCompanyID and tb.FPeriod=p.FNumber)");
            strBuffer.append(" )\r\n");
        } else {
            strBuffer.append(" tb.FOrgUnitID = ? AND tb.FPeriod = ? \r\n");
        }
        if (!(StringUtils.isEmpty((String)currencyId) || condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
            strBuffer.append(" AND tb.FCurrencyID = ?  \r\n");
        }
        if (!StringUtils.isEmpty((String)condition.getAccountCodeStart())) {
            strBuffer.append(" AND (TA.FNumber >= ?)  \r\n");
        }
        if (!StringUtils.isEmpty((String)condition.getAccountCodeEnd())) {
            strBuffer.append(" AND (TA.FNumber <= ?)  \r\n");
        }
        strBuffer.append(" and ta.fisleaf = 1 AND TA.FACCOUNTTABLEID = ? ");
        SqlParameter2 parameter = new SqlParameter2();
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            parameter.addValue(theNearPeriod.getNumber());
            parameter.addValue(theNearPeriod.getNumber());
            parameter.addValue(theNearPeriod.getNumber());
        } else {
            parameter.addValueChar(partner.getCompanyId());
            parameter.addValue(theNearPeriod.getNumber());
        }
        if (!(StringUtils.isEmpty((String)currencyId) || condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
            parameter.addValueChar(condition.getCurrencyID());
        }
        if (!StringUtils.isEmpty((String)condition.getAccountCodeStart())) {
            parameter.addValue(condition.getAccountCodeStart());
        }
        if (!StringUtils.isEmpty((String)condition.getAccountCodeEnd())) {
            parameter.addValue(condition.getAccountCodeEnd() + "zz");
        }
        parameter.addValue(partner.getAccountTableId());
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            cn = partner.getConnection();
            selectSql.append(" from t_bd_accountview av ");
            if (condition.isOptionNOTDisplayIfBalanceZero() || condition.isOptionNOTDisplayIfNoAmount()) {
                selectSql.append(" inner join");
            } else {
                selectSql.append(" left join");
            }
            selectSql.append(" (").append(strBuffer).append(") t on t.faccountid = av.fid");
            selectSql.append(" where av.fisleaf = 1");
            if (!StringUtils.isEmpty((String)condition.getAccountCodeStart())) {
                selectSql.append(" AND av.FNumber >= ? ");
                parameter.addValue(condition.getAccountCodeStart());
            }
            if (!StringUtils.isEmpty((String)condition.getAccountCodeEnd())) {
                selectSql.append(" AND av.FNumber <= ? ");
                parameter.addValue(condition.getAccountCodeEnd() + "zz");
            }
            if (GlUtils.isCompanyUnion(partner.getCompany())) {
                selectSql.append(" and av.fcompanyid in ").append(this.getStrCompanyIds(partner));
            } else {
                selectSql.append(" and av.fcompanyid = ?");
                parameter.addValueChar(partner.getCompanyId());
            }
            selectSql.append(" AND av.FACCOUNTTABLEID = ? ");
            parameter.addValue(partner.getAccountTableId());
            String sql = parameter.getSqlWithParameters(" insert into " + strFirstTempTableName + selectSql);
            stmt = cn.prepareStatement(sql);
            stmt.close();
            DbUtil.execute((Context)partner.getContext(), (String)sql);
        }
        catch (SQLException e) {
            try {
                e.setNextException(new SQLException("The query sql is: insert into " + strFirstTempTableName + selectSql));
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
    }

    private void insertTempDataAcctVoucher(ReportPartner partner, String strFirstTempTableName, PeriodInfo theNearPeriod) throws EASBizException, BOSException {
        java.util.Date dateStart = theNearPeriod.getBeginDate();
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        java.util.Date dateEnd = condition.getDateBegin();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateEnd);
        calendar.add(5, -1);
        dateEnd = calendar.getTime();
        String currencyId = condition.getCurrencyID();
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        String strTableVoucherToBegin = this.getVoucherTableForJournal(partner, dateStart, dateEnd);
        StringBuffer sqlToBegin = new StringBuffer();
        sqlToBegin.append(" SELECT FAccountID , \r\n");
        if (isForCurrency) {
            sqlToBegin.append(" FCurrencyID, \r\n");
        }
        sqlToBegin.append(" FCompanyID,null as FAsstHgID, \r\n");
        if (isForCurrency) {
            sqlToBegin.append(" FDebitFor - FCreditFor AS FBeginBalanceFor, \r\n");
            sqlToBegin.append(" 0.0 AS FDebitFor, \r\n");
            sqlToBegin.append(" 0.0 AS FCreditFor, \r\n");
            sqlToBegin.append(" FDebitFor - FCreditFor AS FEndBalanceFor, \r\n");
        }
        if (isLocaCurrency || isForCurrency) {
            sqlToBegin.append(" FDebitLocal - FCreditLocal AS FBeginBalanceLocal, \r\n");
            sqlToBegin.append(" 0.0 AS FDebitLocal, \r\n");
            sqlToBegin.append(" 0.0 AS FCreditLocal, \r\n");
            sqlToBegin.append(" FDebitLocal - FCreditLocal AS FEndBalanceLocal, \r\n");
        }
        if (isRptCurrency || isForCurrency) {
            sqlToBegin.append(" FDebitRpt - FCreditRpt AS FBeginBalanceRpt, \r\n");
            sqlToBegin.append(" 0.0 AS FDebitRpt, \r\n");
            sqlToBegin.append(" 0.0 AS FCreditRpt, \r\n");
            sqlToBegin.append(" FDebitRpt - FCreditRpt AS FEndBalanceRpt, \r\n");
        }
        sqlToBegin.append(" 0 AS FDebitCount, \r\n");
        sqlToBegin.append(" 0 AS FCredtiCount, \r\n");
        sqlToBegin.append(" -1 as ftag, \r\n");
        sqlToBegin.append(" 0 as FLineType \r\n");
        if (GlUtils.isCompanyUnion(partner.getCompany()) && condition.isOptionShowAsstItem()) {
            sqlToBegin.append(" ,2 as FAccountOrAssist");
        }
        sqlToBegin.append(" FROM " + strTableVoucherToBegin);
        dateStart = condition.getDateBegin();
        dateEnd = condition.getDateEnd();
        String strTableVoucherToEnd = this.getVoucherTableForJournal(partner, dateStart, dateEnd);
        StringBuffer sqlToEnd = new StringBuffer();
        sqlToEnd.append(" SELECT FAccountID , \r\n");
        if (isForCurrency) {
            sqlToEnd.append(" FCurrencyID, \r\n");
        }
        sqlToEnd.append(" FCompanyID,null as FAsstHgID, \r\n");
        if (isForCurrency) {
            sqlToEnd.append(" 0.0 AS FBeginBalanceFor, \r\n");
            sqlToEnd.append(" FDebitFor AS FDebitFor, \r\n");
            sqlToEnd.append(" FCreditFor AS FCreditFor, \r\n");
            sqlToEnd.append(" FDebitFor - FCreditFor AS FEndBalanceFor, \r\n");
        }
        if (isLocaCurrency || isForCurrency) {
            sqlToEnd.append(" 0.0 AS FBeginBalanceLocal , \r\n");
            sqlToEnd.append(" FDebitLocal AS FDebitLocal , \r\n");
            sqlToEnd.append(" FCreditLocal AS FCreditLocal, \r\n");
            sqlToEnd.append(" FDebitLocal - FCreditLocal AS FEndBalanceLocal,\r\n");
        }
        if (isRptCurrency || isForCurrency) {
            sqlToEnd.append(" 0.0 AS FBeginBalanceRpt, \r\n");
            sqlToEnd.append(" FDebitRpt AS FDebitRpt, \r\n");
            sqlToEnd.append(" FCreditRpt AS FCreditRpt,\r\n");
            sqlToEnd.append(" FDebitRpt - FCreditRpt AS FEndBalanceRpt,  \r\n");
        }
        sqlToEnd.append(" FDebitCount AS FDebitCount,\r\n");
        sqlToEnd.append(" FCreditCount AS FCredtiCount, \r\n");
        sqlToEnd.append(" -1 as ftag, \r\n");
        sqlToEnd.append(" 0 as FLineType \r\n");
        if (GlUtils.isCompanyUnion(partner.getCompany()) && condition.isOptionShowAsstItem()) {
            sqlToEnd.append(" ,2 as FAccountOrAssist");
        }
        sqlToEnd.append(" FROM " + strTableVoucherToEnd);
        Connection cn = null;
        PreparedStatement stmtToBegin = null;
        PreparedStatement stmtToEnd = null;
        try {
            cn = partner.getConnection();
            stmtToBegin = cn.prepareStatement(" insert into " + strFirstTempTableName + sqlToBegin.toString());
            DbUtil.execute((Context)partner.getContext(), (String)(" insert into " + strFirstTempTableName + sqlToBegin.toString()));
            stmtToBegin.close();
            DbUtil.execute((Context)partner.getContext(), (String)(" insert into " + strFirstTempTableName + sqlToEnd.toString()));
            stmtToEnd = cn.prepareStatement(" insert into " + strFirstTempTableName + sqlToEnd.toString());
            stmtToEnd.close();
        }
        catch (SQLException e) {
            try {
                e.setNextException(new SQLException("The query sql is: insert into " + strFirstTempTableName + sqlToEnd.toString()));
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtToBegin);
                SQLUtils.cleanup(stmtToEnd);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtToBegin);
        SQLUtils.cleanup((Statement)stmtToEnd);
    }

    private String getVoucherTableForJournal(ReportPartner partner, java.util.Date dateStart, java.util.Date dateEnd) throws EASBizException, BOSException {
        String strTempTable = null;
        String voucherTableCreateSql = this.getVoucherTableCreateSql();
        String strFirstTempTable = partner.createTempTableAsynchronism("GLJUT1", voucherTableCreateSql, true);
        StringBuffer strBuffer = new StringBuffer();
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        String strCurrencyID = condition.getCurrencyID();
        strBuffer.append(" SELECT D.FAccountID AS FAccountID,\r\n");
        if (strCurrencyID != null && (strCurrencyID.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || strCurrencyID.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) && !condition.isAllCurrency()) {
            strBuffer.append("'" + strCurrencyID + "'").append(" AS FCurrencyID,\r\n");
        } else {
            strBuffer.append(" D.FCurrencyID AS FCurrencyID,\r\n");
        }
        strBuffer.append(" M.FCompanyID AS FCompanyID,null as FAsstHgID, \r\n");
        if (strCurrencyID != null && strCurrencyID.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
            strBuffer.append(" (CASE D.FEntryDC WHEN ").append(1);
            strBuffer.append(" THEN D.FLocalAmount ELSE 0 END) AS FDebitFor, \r\n");
            strBuffer.append(" (CASE D.FEntryDC WHEN ").append(0);
            strBuffer.append(" THEN D.FLocalAmount ELSE 0 END) AS FCreditFor, \r\n");
        } else if (strCurrencyID != null && strCurrencyID.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
            strBuffer.append(" (CASE D.FEntryDC WHEN ").append(1);
            strBuffer.append(" THEN D.FReportingAmount ELSE 0 END) AS FDebitFor, \r\n");
            strBuffer.append(" (CASE D.FEntryDC WHEN ").append(0);
            strBuffer.append(" THEN D.FReportingAmount ELSE 0 END) AS FCreditFor, \r\n");
        } else {
            strBuffer.append(" (CASE D.FEntryDC WHEN ").append(1);
            strBuffer.append(" THEN D.FOriginalAmount ELSE 0 END) AS FDebitFor, \r\n");
            strBuffer.append(" (CASE D.FEntryDC WHEN ").append(0);
            strBuffer.append(" THEN D.FOriginalAmount ELSE 0 END) AS FCreditFor, \r\n");
        }
        strBuffer.append(" (CASE D.FEntryDC WHEN ").append(1);
        strBuffer.append(" THEN D.FLocalAmount ELSE 0 END) AS FDebitLocal, \r\n");
        strBuffer.append(" (CASE D.FEntryDC WHEN ").append(0);
        strBuffer.append(" THEN D.FLocalAmount ELSE 0 END) AS FCreditLocal, \r\n");
        strBuffer.append(" (CASE D.FEntryDC WHEN ").append(1);
        strBuffer.append(" THEN D.FReportingAmount ELSE 0 END) AS FDebitRpt, \r\n");
        strBuffer.append(" (CASE D.FEntryDC WHEN ").append(0);
        strBuffer.append(" THEN D.FReportingAmount ELSE 0 END) AS FCreditRpt, \r\n");
        strBuffer.append(" (CASE D.FEntryDC WHEN ").append(1);
        strBuffer.append(" THEN 1 ELSE 0 END) AS FDebitCount, \r\n");
        strBuffer.append("(CASE D.FEntryDC WHEN ").append(0);
        strBuffer.append(" THEN 1 ELSE 0 END) AS FCreditCount \r\n");
        strBuffer.append(" FROM T_GL_Voucher AS M  \r\n");
        strBuffer.append(" INNER JOIN T_GL_VoucherEntry AS D ON M.FID = D.FBillID \r\n");
        strBuffer.append(" inner join t_bd_accountview ta on ta.fid = D.faccountid");
        strBuffer.append(" WHERE (M.FBizStatus = ? \r\n");
        if (condition.getOptionPosting()) {
            strBuffer.append(" OR M.FBizStatus = ? \r\n");
            strBuffer.append(" OR M.FBizStatus = ? \r\n");
        }
        strBuffer.append(")  \r\n");
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            strBuffer.append("\tAND M.FCompanyID in ").append(this.getStrCompanyIds(partner)).append(" \r\n");
        } else {
            strBuffer.append("\tAND M.FCompanyID = ? \r\n");
        }
        strBuffer.append(" AND TA.FACCOUNTTABLEID = ?");
        if (!(strCurrencyID == null || strCurrencyID.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || strCurrencyID.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString()) || condition.isAllCurrency())) {
            strBuffer.append(" AND D.FCurrencyID = ? \r\n");
        }
        strBuffer.append(" AND M.FBookedDate >= ? AND M.FBookedDate <= ? \r\n");
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            strBuffer.append(" AND (TA.FNumber >= ?) \r\n");
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            strBuffer.append(" AND (TA.FNumber <= ?) \r\n");
        }
        Connection cn = null;
        PreparedStatement stmt = null;
        String strInsert = "Insert into " + strFirstTempTable + " " + strBuffer.toString();
        try {
            cn = partner.getConnection();
            stmt = cn.prepareStatement(strInsert);
            SqlParameter2 parameter = new SqlParameter2();
            parameter.addValue(5);
            if (condition.getOptionPosting()) {
                parameter.addValue(1);
                parameter.addValue(3);
            }
            if (!GlUtils.isCompanyUnion(partner.getCompany())) {
                parameter.addValueChar(partner.getCompanyId());
            }
            parameter.addValueChar(partner.getAccountTableId());
            if (!(strCurrencyID == null || strCurrencyID.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || strCurrencyID.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString()) || condition.isAllCurrency())) {
                parameter.addValueChar(condition.getCurrencyID());
            }
            parameter.addValue(new Date(dateStart.getTime()));
            parameter.addValue(new Date(dateEnd.getTime()));
            if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
                parameter.addValueChar(condition.getAccountCodeStart());
            }
            if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
                parameter.addValueChar(condition.getAccountCodeEnd() + "zz");
            }
            parameter.putToStatement(stmt);
            DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(strInsert));
            stmt.close();
            strTempTable = partner.createTempTableAsynchronism("GLJUT2", voucherTableCreateSql, true);
            strInsert = "Insert into " + strTempTable + " select * from " + strFirstTempTable;
            stmt = cn.prepareStatement(strInsert);
            parameter.clear();
            parameter.putToStatement(stmt);
            DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(strInsert));
            stmt.close();
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)sqle);
                sqle.setNextException(new SQLException("The query sql is:" + strInsert));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        partner.dropTempTable(strFirstTempTable);
        return strTempTable;
    }

    private String getVoucherTableCreateSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("(");
        sql.append(" FAccountID varchar(44), \r\n");
        sql.append(" FCurrencyID varchar(44), \r\n");
        sql.append(" FCompanyID VARCHAR(44), \r\n");
        sql.append(" FAsstHgID varchar(44), \r\n");
        sql.append(" FDebitFor DECIMAL(28,10), \r\n");
        sql.append(" FCreditFor DECIMAL(28,10), \r\n");
        sql.append(" FDebitLocal DECIMAL(28,10), \r\n");
        sql.append(" FCreditLocal DECIMAL(28,10), \r\n");
        sql.append(" FDebitRpt DECIMAL(28,10), \r\n");
        sql.append(" FCreditRpt DECIMAL(28,10), \r\n");
        sql.append(" FDebitCount INT, \r\n");
        sql.append(" FCreditCount INT ");
        sql.append(" )");
        return sql.toString();
    }

    private PeriodInfo getTheNearPeriod(ReportPartner partner, java.util.Date date) throws EASBizException, BOSException {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date newDate = null;
        try {
            newDate = f.parse(f.format(date));
        }
        catch (ParseException e) {
            throw new ReportException(ReportException.TODO_UNTYPE, e);
        }
        IPeriod periodCtrl = PeriodFactory.getLocalInstance((Context)partner.getContext());
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("periodYear"));
        sic.add(new SelectorItemInfo("periodQuarter"));
        sic.add(new SelectorItemInfo("periodNumber"));
        sic.add(new SelectorItemInfo("beginDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("Number"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("beginDate", (Object)newDate, CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("endDate", (Object)newDate, CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("periodType", (Object)partner.getCompany().getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString(" ( #0 ) and ( #1 ) and ( #2 ) ");
        SorterItemCollection sorter = view.getSorter();
        SorterItemInfo sort = new SorterItemInfo("periodNumber");
        sort.setSortType(SortType.ASCEND);
        sorter.add(sort);
        PeriodCollection allFiscalTerms = periodCtrl.getPeriodCollection(view);
        if (allFiscalTerms == null || allFiscalTerms.size() == 0) {
            return null;
        }
        return allFiscalTerms.get(0);
    }

    private String getTempTableStructure(ReportPartner partner) {
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        String currencyId = condition.getCurrencyID();
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" ( ");
        sql.append(" FAccountID VARCHAR(44), \r\n");
        if (isForCurrency) {
            sql.append(" FCurrencyID VARCHAR(44), \r\n");
        }
        sql.append(" FCompanyID VARCHAR(44), \r\n");
        sql.append(" FAsstHgID VARCHAR(44), \r\n");
        if (isForCurrency) {
            sql.append(" FBeginBalanceFor DECIMAL(28,10), \r\n");
            sql.append(" FDebitFor DECIMAL(28,10), \r\n");
            sql.append(" FCreditFor DECIMAL(28,10), \r\n");
            sql.append(" FEndBalanceFor DECIMAL(28,10), \r\n");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append(" FBeginBalanceLocal DECIMAL(28,10), \r\n");
            sql.append(" FDebitLocal DECIMAL(28,10),  \r\n");
            sql.append(" FCreditLocal DECIMAL(28,10), \r\n");
            sql.append(" FEndBalanceLocal DECIMAL(28,10), \r\n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" FBeginBalanceRpt DECIMAL(28,10), \r\n");
            sql.append(" FDebitRpt DECIMAL(28,10), \r\n");
            sql.append(" FCreditRpt DECIMAL(28,10), \r\n");
            sql.append(" FEndBalanceRpt DECIMAL(28,10), \r\n");
        }
        sql.append(" FDebitCount INT, \r\n");
        sql.append(" FCredtiCount INT, \r\n");
        sql.append(" FTag INT, \r\n");
        sql.append(" FLineType INT  \r\n ");
        if (GlUtils.isCompanyUnion(partner.getCompany()) && condition.isOptionShowAsstItem()) {
            sql.append("  ,FAccountOrAssist Int \r\n");
        }
        sql.append(")");
        return sql.toString();
    }

    @Override
    protected void doSomethingBeforeQuery(ReportPartner partner) throws EASBizException, BOSException {
        ReportConditionJournal fixCondition = (ReportConditionJournal)partner.getFixCondition();
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        if (fixCondition.getCurrencyID() == null && !GlUtils.isCompanyUnion(partner.getCompany())) {
            fixCondition.setCurrencyID("AllCurrency");
        }
        try {
            fixCondition.setDateBegin(f.parse(f.format(fixCondition.getDateBegin())));
            fixCondition.setDateEnd(f.parse(f.format(fixCondition.getDateEnd())));
        }
        catch (ParseException e) {
            throw new ReportException(ReportException.TODO_UNTYPE, e);
        }
    }

    @Override
    protected void doSomethingBeforeExecuteSql(ReportPartner partner) throws BOSException, EASBizException {
        String strCurrencyId;
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        condition.getExpandInfo().put("isNeedAccountID", new Boolean(true));
        if (condition.isOptionShowAsstItem()) {
            condition.getExpandInfo().put("isNeedAccountID", new Boolean(false));
            StringBuffer sqlMax = new StringBuffer();
            sqlMax.append("Select max(hg.fcount) as fcount");
            sqlMax.append("\r\n");
            sqlMax.append(this.getSqlForDataFrom(partner));
            sqlMax.append("\r\n");
            sqlMax.append(this.getSqlForDataWhere(partner));
            sqlMax.append("\r\n");
            condition.getExpandInfo().put("isNeedAccountID", new Boolean(true));
            Statement stmt = null;
            IRowSet result = null;
            try {
                SqlParameter2 params = (SqlParameter2)partner.getVariable("SQL_PARAMETERS");
                result = params != null ? DbUtil.executeQuery((Context)partner.getContext(), (String)params.getSqlWithParameters(sqlMax.toString())) : DbUtil.executeQuery((Context)partner.getContext(), (String)sqlMax.toString());
                result.next();
                int maxCount = result.getInt("FCount");
                partner.setVariable(MAX_ASSTITEM_COUNT, new Integer(maxCount));
            }
            catch (SQLException sqle) {
                try {
                    sqle.setNextException(new SQLException("The query sql is:" + sqlMax));
                    throw new SQLDataException(sqle);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(result, stmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)result, stmt);
        }
        if ((strCurrencyId = condition.getCurrencyID()) == null) {
            throw new ReportException(ReportException.TODO_UNTYPE);
        }
        this.setHeader(partner);
    }

    private void setHeader(ReportPartner partner) throws EASBizException, BOSException {
        ArrayList<ReportTableHeadItemInfo> items = new ArrayList<ReportTableHeadItemInfo>();
        items.add(this.addHeadItemInfo("FAccountNumber", 80, 0, true, true, true, new String[]{"AccountCode", "AccountCode"}, 0, 0, false));
        items.add(this.addHeadItemInfo("FAccountName", 160, 0, true, true, true, new String[]{"AccountName", "AccountName"}, 0, 0, false));
        if (partner.getFixCondition().isAllCurrency()) {
            items.add(this.addHeadItemInfo("FCurrencyName", 160, 0, true, true, true, new String[]{"Currency", "Currency"}, 0, 0, false));
        }
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            items.add(this.addHeadItemInfo("FCompany", 200, 0, true, false, true, new String[]{"FCompany", "FCompany"}, 0, 0, false));
        }
        int asstCount = 0;
        Object obj = partner.getVariable(MAX_ASSTITEM_COUNT);
        if (obj != null && (Integer)obj > 0) {
            asstCount = (Integer)obj;
        }
        for (int i = 0; i < asstCount; ++i) {
            items.add(this.addHeadItemInfo("FAsstItem" + i, 160, 0, false, false, true, new String[]{"AssistActName", "AssistActName"}, 0, 0, false));
        }
        int scaleFor = partner.getScaleFor();
        int scaleLocal = partner.getScaleLocal();
        int scaleRpt = partner.getScaleRpt();
        boolean isShowForCurrency = this.isShowForCurrency(partner);
        boolean isShowLocalCurrency = this.isShowLocalCurrency(partner);
        boolean isShowReportCurrency = this.isShowReportCurrency(partner);
        boolean isSingleCurrency = (isShowForCurrency ? 1 : 0) + (isShowLocalCurrency ? 1 : 0) + (isShowReportCurrency ? 1 : 0) == 1;
        items.add(this.addHeadItemInfo("FBalBeginOritention", 30, 1, false, false, true, new String[]{"BalanceBegin", "Oriention"}, 0, 0, false));
        if (isShowForCurrency) {
            items.add(this.addHeadItemInfo("FBalanceBeginFor", 110, 2, false, false, true, new String[]{"BalanceBegin", isSingleCurrency ? "Amount" : "LabelFor"}, 2, scaleFor, true));
        }
        if (isShowLocalCurrency) {
            items.add(this.addHeadItemInfo("FBalanceBeginLocal", 110, 2, false, false, true, new String[]{"BalanceBegin", isSingleCurrency ? "Amount" : "LabelLocal"}, 1, scaleLocal, true));
        }
        if (isShowReportCurrency) {
            items.add(this.addHeadItemInfo("FBalanceBeginRpt", 110, 2, false, false, true, new String[]{"BalanceBegin", isSingleCurrency ? "Amount" : "LabelRpt"}, 1, scaleRpt, true));
        }
        if (isShowForCurrency) {
            items.add(this.addHeadItemInfo("FDebitFor", 110, 2, false, false, true, new String[]{"Debit", isSingleCurrency ? "Debit" : "LabelFor"}, 2, scaleFor, true));
        }
        if (isShowLocalCurrency) {
            items.add(this.addHeadItemInfo("FDebitLocal", 110, 2, false, false, true, new String[]{"Debit", isSingleCurrency ? "Debit" : "LabelLocal"}, 1, scaleLocal, true));
        }
        if (isShowReportCurrency) {
            items.add(this.addHeadItemInfo("FDebitRpt", 110, 2, false, false, true, new String[]{"Debit", isSingleCurrency ? "Debit" : "LabelRpt"}, 1, scaleRpt, true));
        }
        if (isShowForCurrency) {
            items.add(this.addHeadItemInfo("FCreditFor", 110, 2, false, false, true, new String[]{"Credit", isSingleCurrency ? "Credit" : "LabelFor"}, 2, scaleFor, true));
        }
        if (isShowLocalCurrency) {
            items.add(this.addHeadItemInfo("FCreditLocal", 110, 2, false, false, true, new String[]{"Credit", isSingleCurrency ? "Credit" : "LabelLocal"}, 1, scaleLocal, true));
        }
        if (isShowReportCurrency) {
            items.add(this.addHeadItemInfo("FCreditRpt", 110, 2, false, false, true, new String[]{"Credit", isSingleCurrency ? "Credit" : "LabelRpt"}, 1, scaleRpt, true));
        }
        items.add(this.addHeadItemInfo("FBalEndOritention", 30, 1, false, false, true, new String[]{"BalanceEnd", "Oriention"}, 0, 0, false));
        if (isShowForCurrency) {
            items.add(this.addHeadItemInfo("FBalanceEndFor", 110, 2, false, false, true, new String[]{"BalanceEnd", isSingleCurrency ? "Amount" : "LabelFor"}, 2, scaleFor, true));
        }
        if (isShowLocalCurrency) {
            items.add(this.addHeadItemInfo("FBalanceEndLocal", 110, 2, false, false, true, new String[]{"BalanceEnd", isSingleCurrency ? "Amount" : "LabelLocal"}, 1, scaleLocal, true));
        }
        if (isShowReportCurrency) {
            items.add(this.addHeadItemInfo("FBalanceEndRpt", 110, 2, false, false, true, new String[]{"BalanceEnd", isSingleCurrency ? "Amount" : "LabelRpt"}, 1, scaleRpt, true));
        }
        items.add(this.addHeadItemInfo("FDebitNumber", 90, 2, false, false, true, new String[]{"DebitNumber", "DebitNumber"}, 0, 0, false));
        items.add(this.addHeadItemInfo("FCreditNumber", 90, 2, false, false, true, new String[]{"CreditNumber", "CreditNumber"}, 0, 0, false));
        ReportTableHeadInfo head = new ReportTableHeadInfo(items.toArray(new ReportTableHeadItemInfo[0]));
        head.setHeadMerge(true);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
        partner.setTableHeadInfo(head);
    }

    @Override
    protected Object[] getTotalLine(ReportPartner partner) throws SQLException, EASBizException, BOSException {
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        Object[] totalLineObj = null;
        StringBuffer strBuffer = new StringBuffer();
        boolean isShowForCurrency = this.isShowForCurrency(partner);
        boolean isShowLocalCurrency = this.isShowLocalCurrency(partner);
        boolean isShowReportCurrency = this.isShowReportCurrency(partner);
        strBuffer.append(" SELECT ");
        if (isShowForCurrency) {
            strBuffer.append(" SUM(TS.FBeginBalanceFor) AS FBeginBalanceFor, \r\n");
        }
        if (isShowLocalCurrency) {
            strBuffer.append(" SUM(TS.FBeginBalanceLocal) AS FBeginBalanceLocal, \r\n");
        }
        if (isShowReportCurrency) {
            strBuffer.append(" SUM(TS.FBeginBalanceRpt) AS FBeginBalanceRpt, \r\n");
        }
        if (isShowForCurrency) {
            strBuffer.append(" SUM(TS.FDebitFor) AS FDebitFor, \r\n");
        }
        if (isShowLocalCurrency) {
            strBuffer.append(" SUM(TS.FDebitLocal) AS FDebitLocal, \r\n");
        }
        if (isShowReportCurrency) {
            strBuffer.append(" SUM(TS.FDebitRpt) AS FDebitRpt, \r\n");
        }
        if (isShowForCurrency) {
            strBuffer.append(" SUM(TS.FCreditFor) AS FCreditFor, \r\n");
        }
        if (isShowLocalCurrency) {
            strBuffer.append(" SUM(TS.FCreditLocal) AS FCreditLocal, \r\n");
        }
        if (isShowReportCurrency) {
            strBuffer.append(" SUM(TS.FCreditRpt) AS FCreditRpt,\r\n");
        }
        if (isShowForCurrency) {
            strBuffer.append(" SUM(TS.FEndBalanceFor) AS FEndBalanceFor, \r\n");
        }
        if (isShowLocalCurrency) {
            strBuffer.append(" SUM(TS.FEndBalanceLocal) AS FEndBalanceLocal,\r\n");
        }
        if (isShowReportCurrency) {
            strBuffer.append(" SUM(TS.FEndBalanceRpt) AS FEndBalanceRpt, \r\n");
        }
        strBuffer.append(" SUM(TS.FDebitCount) AS FDebitCount, \r\n");
        strBuffer.append(" SUM(TS.FCredtiCount) AS FCredtiCount \r\n");
        strBuffer.append(" from \r\n");
        strBuffer.append(" (SELECT FAccountID AS FAccountID, \r\n");
        strBuffer.append(" FAsstHgID as FAsstHgID, \r\n");
        if (isShowForCurrency) {
            strBuffer.append(" SUM(FBeginBalanceFor) AS FBeginBalanceFor,\r\n");
        }
        if (isShowLocalCurrency) {
            strBuffer.append(" SUM(FBeginBalanceLocal) AS FBeginBalanceLocal,\r\n");
        }
        if (isShowReportCurrency) {
            strBuffer.append(" SUM(FBeginBalanceRpt) AS FBeginBalanceRpt,\r\n");
        }
        if (isShowForCurrency) {
            strBuffer.append(" SUM(FDebitFor) AS FDebitFor, \r\n");
        }
        if (isShowLocalCurrency) {
            strBuffer.append(" SUM(FDebitLocal) AS FDebitLocal, \r\n");
        }
        if (isShowReportCurrency) {
            strBuffer.append(" SUM(FDebitRpt) AS FDebitRpt,\r\n");
        }
        if (isShowForCurrency) {
            strBuffer.append(" SUM(FCreditFor) AS FCreditFor, \r\n");
        }
        if (isShowLocalCurrency) {
            strBuffer.append(" SUM(FCreditLocal) AS FCreditLocal,\r\n");
        }
        if (isShowReportCurrency) {
            strBuffer.append(" SUM(FCreditRpt) AS FCreditRpt,\r\n");
        }
        if (isShowForCurrency) {
            strBuffer.append(" SUM(FEndBalanceFor) AS FEndBalanceFor, \r\n");
        }
        if (isShowLocalCurrency) {
            strBuffer.append(" SUM(FEndBalanceLocal) AS FEndBalanceLocal, \r\n");
        }
        if (isShowReportCurrency) {
            strBuffer.append(" SUM(FEndBalanceRpt) AS FEndBalanceRpt,\r\n");
        }
        strBuffer.append(" SUM(FDebitCount) AS FDebitCount, \r\n");
        strBuffer.append(" SUM(FCredtiCount) AS FCredtiCount\r\n");
        strBuffer.append(" FROM  \r\n");
        strBuffer.append(partner.getTempTableName());
        strBuffer.append(" WHERE FAsstHgID is null \r\n");
        strBuffer.append(" GROUP BY FAccountID,FAsstHgID) AS TS \r\n");
        strBuffer.append(" INNER JOIN T_BD_AccountView AS TA \r\n");
        strBuffer.append(" ON TS.FAccountID = TA.FID \r\n");
        strBuffer.append(" WHERE \r\n");
        strBuffer.append(" (TA.FAccountTableID = ?)\r\n");
        strBuffer.append(" AND TA.FLevel = ?");
        Connection cn = null;
        PreparedStatement stmt = null;
        IRowSet rs = null;
        try {
            cn = partner.getConnection();
            stmt = cn.prepareStatement(strBuffer.toString());
            SqlParameter2 parameter = new SqlParameter2();
            parameter.addValueChar(partner.getAccountTableId());
            parameter.addValue(partner.getFixCondition().getAccountLevelStart());
            parameter.putToStatement(stmt);
            rs = DbUtil.executeQuery((Context)partner.getContext(), (String)parameter.getSqlWithParameters(strBuffer.toString()));
            if (rs.next()) {
                totalLineObj = this.getTotalLineObjects(partner, (ResultSet)rs);
            }
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + strBuffer.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        if (totalLineObj != null) {
            totalLineObj[1] = partner.TITLE_TOTAL;
            totalLineObj[totalLineObj.length - 2] = ReportResultInfo.LINE_TOTAL;
        }
        return totalLineObj;
    }

    @Override
    protected boolean isAddTotalLine(ReportPartner partner) {
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        boolean bReturn = false;
        if (condition != null) {
            bReturn = condition.isOptionShowTotal();
        }
        return bReturn;
    }

    protected CompanyOrgUnitInfo getInitCompany(ReportPartner partner) throws BOSException, EASBizException {
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        return partner.getCompany();
    }

    private void insertTempDataAsst(ReportPartner partner, String strFirstTempTableName, PeriodInfo theNearPeriod) throws EASBizException, BOSException {
        if (theNearPeriod == null) {
            return;
        }
        this.insertTempDataAsstBalance(partner, strFirstTempTableName, theNearPeriod);
        this.insertTempDataAsstVoucher(partner, strFirstTempTableName, theNearPeriod);
    }

    private void insertTempDataAsstBalance(ReportPartner partner, String strFirstTempTableName, PeriodInfo theNearPeriod) throws EASBizException, BOSException {
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        String table = GLBalanceUtils.getAssistBalanceTable(condition.getOptionPosting() ? 1 : 5, condition.getCurrencyID());
        String currencyId = partner.getFixCondition().getCurrencyID();
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT tb.FAccountID AS FAccountID, \r\n");
        if (isForCurrency) {
            sql.append(" tb.FCurrencyID as FCurrencyID, \r\n");
        }
        sql.append(" tb.FOrgunitID AS FCompanyID, \r\n");
        sql.append(" case when tb.FAssistGrpID is null then 'DefaultAssGrpID' else tb.FAssistGrpID end as FAsstHgID, \r\n");
        if (isForCurrency) {
            sql.append(" tb.FBeginBalanceFor AS FBeginBalanceFor, \r\n");
            sql.append(" 0.0 AS FDebitFor, \r\n");
            sql.append(" 0.0 AS FCreditFor, \r\n");
            sql.append(" tb.FBeginBalanceFor AS FEndBalanceFor, \r\n");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append(" tb.FBeginBalanceLocal AS FBeginBalanceLocal, \r\n");
            sql.append(" 0.0 AS FDebitLocal, \r\n");
            sql.append(" 0.0 AS FCreditLocal, \r\n");
            sql.append(" tb.FBeginBalanceLocal AS FEndBalanceLocal, \r\n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" tb.FBeginBalanceRpt AS FBeginBalanceRpt, \r\n");
            sql.append(" 0.0 AS FDebitRpt, \r\n");
            sql.append(" 0.0 AS FCreditRpt, \r\n");
            sql.append(" tb.FBeginBalanceRpt AS FEndBalanceRpt, \r\n");
        }
        sql.append(" 0 AS FDebitCount, \r\n");
        sql.append(" 0 AS FCredtiCount, \r\n");
        sql.append(" 0 as FTag, \r\n");
        sql.append(" 0 as FLineType ");
        if (GlUtils.isCompanyUnion(partner.getCompany()) && condition.isOptionShowAsstItem()) {
            sql.append(" ,1 AS FAccountOrAssist \r\n");
        }
        sql.append(" FROM " + table + " as tb \r\n");
        sql.append(" INNER JOIN T_BD_AccountView as tv ON tb.fAccountID = tv.fid \r\n");
        sql.append(" WHERE ");
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            sql.append("(( tb.FOrgUnitID in ").append(this.getStrCompanyIds(partner)).append(" AND tb.FPeriod = ? \r\n");
            sql.append(" and tb.forgunitid not in (select sysctrl.FCompanyID from T_BD_SYSTEMSTATUSCTROL sysctrl \r\n");
            sql.append(" INNER JOIN T_BD_SYSTEMSTATUS tsst ON sysctrl.FSystemStatusID=tsst.FID \r\n");
            sql.append(" inner join t_bd_period p on sysctrl.FStartPeriodID = p.fid \r\n");
            sql.append(" where tsst.FName=6 AND sysctrl.FISSTART=1 and sysctrl.FCompanyID in ").append(this.getStrCompanyIds(partner));
            sql.append(" and p.fnumber > ? )) \r\n");
            sql.append(" or exists (select 1 from T_BD_SYSTEMSTATUSCTROL sysctrl INNER JOIN T_BD_SYSTEMSTATUS tsst ON sysctrl.FSystemStatusID=tsst.FID \r\n");
            sql.append(" inner join t_bd_period p on sysctrl.FStartPeriodID = p.fid \r\n");
            sql.append(" where tsst.FName=6 AND sysctrl.FISSTART=1 and sysctrl.FCompanyID in ").append(this.getStrCompanyIds(partner));
            sql.append(" and p.fnumber > ? and tb.FOrgUnitID=sysctrl.FCompanyID and tb.FPeriod=p.FNumber)");
            sql.append(" )\r\n");
        } else {
            sql.append(" tb.FOrgUnitID = ? AND tb.FPeriod = ? \r\n");
        }
        if (!(currencyId == null || currencyId.trim().length() == 0 || condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
            sql.append(" AND tb.FCurrencyID = ?  \r\n");
        }
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            sql.append(" AND (TV.FNumber >= ?) \r\n");
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            sql.append(" AND (TV.FNumber <= ?) \r\n");
        }
        SqlParameter2 parameter = new SqlParameter2();
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            parameter.addValue(theNearPeriod.getNumber());
            parameter.addValue(theNearPeriod.getNumber());
            parameter.addValue(theNearPeriod.getNumber());
        } else {
            parameter.addValueChar(partner.getCompanyId());
            parameter.addValue(theNearPeriod.getNumber());
        }
        if (!(currencyId == null || currencyId.trim().length() == 0 || condition.isAllCurrency() || "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId))) {
            parameter.addValueChar(condition.getCurrencyID());
        }
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            parameter.addValue(condition.getAccountCodeStart());
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            parameter.addValue(condition.getAccountCodeEnd() + "zz");
        }
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            cn = partner.getConnection();
            stmt = cn.prepareStatement(" insert into " + strFirstTempTableName + sql.toString());
            parameter.putToStatement(stmt);
            DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(" insert into " + strFirstTempTableName + sql.toString()));
            stmt.close();
        }
        catch (SQLException e) {
            try {
                e.setNextException(new SQLException("The query sql is: insert into " + strFirstTempTableName + sql.toString()));
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
    }

    private void insertTempDataAsstVoucher(ReportPartner partner, String strFirstTempTableName, PeriodInfo theNearPeriod) throws EASBizException, BOSException {
        this.insertTempDataAsstVoucherBeginToStart(partner, strFirstTempTableName, theNearPeriod);
        this.insertTempDataAsstVoucherStartToEnd(partner, strFirstTempTableName);
    }

    private void insertTempDataAsstVoucherBeginToStart(ReportPartner partner, String strFirstTempTableName, PeriodInfo theNearPeriod) throws EASBizException, BOSException {
        java.util.Date dateStart = theNearPeriod.getBeginDate();
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        String currencyId = partner.getFixCondition().getCurrencyID();
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        java.util.Date dateEnd = condition.getDateBegin();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateEnd);
        calendar.add(5, -1);
        dateEnd = calendar.getTime();
        String asstTableNameBegin = this.getVoucherAssistSQLForJournal(partner, dateStart, dateEnd);
        StringBuffer sqlToBegin = new StringBuffer();
        sqlToBegin.append(" SELECT FAccountID, \r\n");
        if (isForCurrency) {
            sqlToBegin.append(" FCurrencyID as FCurrencyID, \r\n");
        }
        sqlToBegin.append(" FCompanyID, \r\n");
        sqlToBegin.append(" case when FAsstHgID is null then 'DefaultAssGrpID' else FAsstHgID end as FAsstHgID, \r\n");
        if (isForCurrency) {
            sqlToBegin.append(" FDebitFor - FCreditFor AS FBeginBalanceFor, \r\n");
            sqlToBegin.append(" 0.0 AS FDebitFor, \r\n");
            sqlToBegin.append(" 0.0 AS FCreditFor, \r\n");
            sqlToBegin.append(" FDebitFor - FCreditFor AS FEndBalanceFor, \r\n");
        }
        if (isLocaCurrency || isForCurrency) {
            sqlToBegin.append(" FDebitLocal - FCreditLocal AS FBeginBalanceLocal ,\r\n");
            sqlToBegin.append(" 0.0 AS FDebitLocal, \r\n");
            sqlToBegin.append(" 0.0 AS FCreditLocal, \r\n");
            sqlToBegin.append(" FDebitLocal - FCreditLocal AS FEndBalanceLocal, \r\n");
        }
        if (isRptCurrency || isForCurrency) {
            sqlToBegin.append(" FDebitRpt - FCreditRpt AS FBeginBalanceRpt,\r\n");
            sqlToBegin.append(" 0.0 AS FDebitRpt, \r\n");
            sqlToBegin.append(" 0.0 AS FCreditRpt, \r\n");
            sqlToBegin.append(" FDebitRpt - FCreditRpt AS FEndBalanceRpt, \r\n");
        }
        sqlToBegin.append(" 0 AS FDebitCount, \r\n");
        sqlToBegin.append(" 0 AS FCredtiCount, \r\n");
        sqlToBegin.append(" 0 as FTag, \r\n");
        sqlToBegin.append(" 0 as FLineType \r\n");
        if (GlUtils.isCompanyUnion(partner.getCompany()) && condition.isOptionShowAsstItem()) {
            sqlToBegin.append(" ,1 AS FAccountOrAssist \r\n");
        }
        sqlToBegin.append(" FROM (" + asstTableNameBegin).append(") tmp ");
        String strCurrencyID = condition.getCurrencyID();
        SqlParameter2 parameterBegin = new SqlParameter2();
        parameterBegin.addValue(5);
        if (condition.getOptionPosting()) {
            parameterBegin.addValue(1);
            parameterBegin.addValue(3);
        }
        if (!GlUtils.isCompanyUnion(partner.getCompany())) {
            parameterBegin.addValueChar(partner.getCompanyId());
        }
        parameterBegin.addValueChar(partner.getAccountTableId());
        if (!(strCurrencyID.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || strCurrencyID.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString()) || condition.isAllCurrency())) {
            parameterBegin.addValueChar(condition.getCurrencyID());
        }
        parameterBegin.addValue(new Date(dateStart.getTime()));
        parameterBegin.addValue(new Date(dateEnd.getTime()));
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            parameterBegin.addValueChar(condition.getAccountCodeStart());
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            parameterBegin.addValueChar(condition.getAccountCodeEnd() + "zz");
        }
        Connection cn = null;
        cn = partner.getConnection();
        PreparedStatement stmtToBegin = null;
        try {
            stmtToBegin = cn.prepareStatement(" insert into " + strFirstTempTableName + sqlToBegin.toString());
            DbUtil.execute((Context)partner.getContext(), (String)parameterBegin.getSqlWithParameters(" insert into " + strFirstTempTableName + sqlToBegin.toString()));
        }
        catch (SQLException e) {
            try {
                e.setNextException(new SQLException("The query sql is: insert into " + strFirstTempTableName + sqlToBegin.toString()));
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtToBegin);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtToBegin);
    }

    private void insertTempDataAsstVoucherStartToEnd(ReportPartner partner, String strFirstTempTableName) throws EASBizException, BOSException {
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        String currencyId = partner.getFixCondition().getCurrencyID();
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        String strCurrencyID = condition.getCurrencyID();
        java.util.Date dateStart = condition.getDateBegin();
        java.util.Date dateEnd = condition.getDateEnd();
        String asstTableNameEnd = this.getVoucherAssistSQLForJournal(partner, dateStart, dateEnd);
        StringBuffer sqlToEnd = new StringBuffer();
        sqlToEnd.append(" SELECT FAccountID, \r\n");
        if (isForCurrency) {
            sqlToEnd.append(" FCurrencyID, \r\n");
        }
        sqlToEnd.append(" FCompanyID, \r\n");
        sqlToEnd.append(" case when FAsstHgID is null then 'DefaultAssGrpID' else FAsstHgID end as FAsstHgID, \r\n");
        if (isForCurrency) {
            sqlToEnd.append(" 0.0 AS FBeginBalanceFor, \r\n");
            sqlToEnd.append(" FDebitFor AS FDebitFor, \r\n");
            sqlToEnd.append(" FCreditFor AS FCreditFor, \r\n");
            sqlToEnd.append(" FDebitFor - FCreditFor AS FEndBalanceFor, \r\n");
        }
        if (isLocaCurrency || isForCurrency) {
            sqlToEnd.append(" 0.0 AS FBeginBalanceLocal , \r\n");
            sqlToEnd.append(" FDebitLocal AS FDebitLocal,\r\n");
            sqlToEnd.append(" FCreditLocal AS FCreditLocal, \r\n");
            sqlToEnd.append(" FDebitLocal - FCreditLocal AS FEndBalanceLocal,\r\n");
        }
        if (isRptCurrency || isForCurrency) {
            sqlToEnd.append(" 0.0 AS FBeginBalanceRpt, \r\n");
            sqlToEnd.append(" FDebitRpt AS FDebitRpt,\r\n");
            sqlToEnd.append(" FCreditRpt AS FCreditRpt,\r\n");
            sqlToEnd.append(" FDebitRpt - FCreditRpt AS FEndBalanceRpt, \r\n");
        }
        sqlToEnd.append(" FDebitCount AS FDebitCount,\r\n");
        sqlToEnd.append(" FCreditCount AS FCredtiCount, \r\n");
        sqlToEnd.append(" 0 as FTag, \r\n");
        sqlToEnd.append(" 0 as FLineType \r\n");
        if (GlUtils.isCompanyUnion(partner.getCompany()) && condition.isOptionShowAsstItem()) {
            sqlToEnd.append(" ,1 AS FAccountOrAssist \r\n");
        }
        sqlToEnd.append(" FROM (" + asstTableNameEnd).append(") tmp ");
        SqlParameter2 parameterEnd = new SqlParameter2();
        parameterEnd.addValue(5);
        if (condition.getOptionPosting()) {
            parameterEnd.addValue(1);
            parameterEnd.addValue(3);
        }
        if (!GlUtils.isCompanyUnion(partner.getCompany())) {
            parameterEnd.addValueChar(partner.getCompanyId());
        }
        parameterEnd.addValueChar(partner.getAccountTableId());
        if (!(strCurrencyID.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || strCurrencyID.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString()) || condition.isAllCurrency())) {
            parameterEnd.addValueChar(condition.getCurrencyID());
        }
        parameterEnd.addValue(new Date(dateStart.getTime()));
        parameterEnd.addValue(new Date(dateEnd.getTime()));
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            parameterEnd.addValueChar(condition.getAccountCodeStart());
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            parameterEnd.addValueChar(condition.getAccountCodeEnd() + "zz");
        }
        Connection cn1 = null;
        cn1 = partner.getConnection();
        PreparedStatement stmtToEnd = null;
        try {
            stmtToEnd = cn1.prepareStatement(" insert into " + strFirstTempTableName + sqlToEnd.toString());
            parameterEnd.putToStatement(stmtToEnd);
            DbUtil.execute((Context)partner.getContext(), (String)parameterEnd.getSqlWithParameters(" insert into " + strFirstTempTableName + sqlToEnd.toString()));
            stmtToEnd.close();
        }
        catch (SQLException e) {
            try {
                e.setNextException(new SQLException("The query sql is: insert into " + strFirstTempTableName + sqlToEnd.toString()));
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtToEnd);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtToEnd);
    }

    private String getVoucherAssistSQLForJournal(ReportPartner partner, java.util.Date dateStart, java.util.Date dateEnd) throws EASBizException, BOSException {
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        String strCurrencyID = condition.getCurrencyID();
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(" SELECT D.FAccountID AS FAccountID,\r\n");
        if (strCurrencyID != null && (strCurrencyID.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || strCurrencyID.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) && !condition.isAllCurrency()) {
            strBuffer.append("'" + strCurrencyID + "'").append(" AS FCurrencyID,\r\n");
        } else {
            strBuffer.append(" D.FCurrencyID AS FCurrencyID,\r\n");
        }
        strBuffer.append(" M.FCompanyID,ASST.FAssGrpID AS FAsstHgID, \r\n");
        if (strCurrencyID.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
            strBuffer.append(" (CASE D.FEntryDC WHEN ").append(1);
            strBuffer.append(" THEN ASST.FLocalAmount ELSE 0 END) AS FDebitFor, \r\n");
            strBuffer.append(" (CASE D.FEntryDC WHEN ").append(0);
            strBuffer.append(" THEN ASST.FLocalAmount ELSE 0 END) AS FCreditFor, \r\n");
        } else if (strCurrencyID.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
            strBuffer.append(" (CASE D.FEntryDC WHEN ").append(1);
            strBuffer.append(" THEN ASST.FReportingAmount ELSE 0 END) AS FDebitFor, \r\n");
            strBuffer.append(" (CASE D.FEntryDC WHEN ").append(0);
            strBuffer.append(" THEN ASST.FReportingAmount ELSE 0 END) AS FCreditFor, \r\n");
        } else {
            strBuffer.append(" (CASE D.FEntryDC WHEN ").append(1);
            strBuffer.append(" THEN ASST.FOriginalAmount ELSE 0 END) AS FDebitFor, \r\n");
            strBuffer.append(" (CASE D.FEntryDC WHEN ").append(0);
            strBuffer.append(" THEN ASST.FOriginalAmount ELSE 0 END) AS FCreditFor, \r\n");
        }
        strBuffer.append(" (CASE D.FEntryDC WHEN ").append(1);
        strBuffer.append(" THEN ASST.FLocalAmount ELSE 0 END) AS FDebitLocal, \r\n");
        strBuffer.append(" (CASE D.FEntryDC WHEN ").append(0);
        strBuffer.append(" THEN ASST.FLocalAmount ELSE 0 END) AS FCreditLocal, \r\n");
        strBuffer.append(" (CASE D.FEntryDC WHEN ").append(1);
        strBuffer.append(" THEN ASST.FReportingAmount ELSE 0 END) AS FDebitRpt, \r\n");
        strBuffer.append(" (CASE D.FEntryDC WHEN ").append(0);
        strBuffer.append(" THEN ASST.FReportingAmount ELSE 0 END) AS FCreditRpt, \r\n");
        strBuffer.append(" (CASE D.FEntryDC WHEN ").append(1);
        strBuffer.append(" THEN 1 ELSE 0 END) AS FDebitCount, \r\n");
        strBuffer.append(" (CASE D.FEntryDC WHEN ").append(0);
        strBuffer.append(" THEN 1 ELSE 0 END) AS FCreditCount \r\n");
        strBuffer.append(" FROM T_GL_VoucherAssistRecord AS ASST  \r\n");
        strBuffer.append(" INNER JOIN T_GL_VoucherEntry AS D ON ASST.FEntryID = D.FID \r\n");
        strBuffer.append(" INNER JOIN T_GL_Voucher AS M ON M.FID = D.FBillID \r\n");
        strBuffer.append(" inner join t_bd_accountview ta on ta.fid = D.faccountid \r\n");
        strBuffer.append(" WHERE (M.FBizStatus = ? \r\n");
        if (condition.getOptionPosting()) {
            strBuffer.append(" OR M.FBizStatus = ? \r\n");
            strBuffer.append(" OR M.FBizStatus = ? \r\n");
        }
        strBuffer.append(")  \r\n");
        if (GlUtils.isCompanyUnion(partner.getCompany())) {
            strBuffer.append("\tAND M.FCompanyID in ").append(this.getStrCompanyIds(partner)).append(" \r\n");
        } else {
            strBuffer.append(" AND M.FCompanyID = ? \r\n");
        }
        strBuffer.append(" AND TA.FACCOUNTTABLEID = ?");
        if (!(strCurrencyID.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || strCurrencyID.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString()) || condition.isAllCurrency())) {
            strBuffer.append("\tAND\tD.FCurrencyID = ?  \r\n");
        }
        strBuffer.append(" AND M.FBookedDate >= ? AND M.FBookedDate <= ?  \r\n");
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            strBuffer.append(" AND (TA.FNumber >= ?)  \r\n");
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            strBuffer.append(" AND (TA.FNumber <= ?)  \r\n");
        }
        strBuffer.append(" AND ASST.FAssGrpID is not null  \r\n");
        return strBuffer.toString();
    }

    private ReportTableHeadItemInfo addHeadItemInfo(String colName, int width, int alignment, boolean isFreeze, boolean isMerge, boolean isVisible, String[] titles, int numberStyleType, int numberScale, boolean needKilobit) {
        ReportTableHeadItemInfo item = new ReportTableHeadItemInfo();
        item.setColumnName(colName);
        item.setWidth(width);
        item.setAlignment(alignment);
        item.setFreeze(isFreeze);
        item.setMerge(isMerge);
        item.setVisible(isVisible);
        item.setTitles(titles);
        item.setNumberStyleType(numberStyleType);
        item.setNumberScale(numberScale);
        item.setNeedKilobit(needKilobit);
        return item;
    }

    private void insertSumAccountCurrency(ReportPartner partner) throws EASBizException, BOSException {
        this.insertSumCurrencyGroupByAccount(partner);
        this.insertSumAccountGroupByCurrency(partner);
    }

    private void insertSumCurrencyGroupByAccount(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append(" (FAccountID, FCurrencyID, \r\n");
        sql.append(" FCompanyID, \r\n");
        sql.append(" FBeginBalanceFor, \r\n");
        sql.append(" FBeginBalanceLocal, \r\n");
        sql.append(" FBeginBalanceRpt, \r\n");
        sql.append(" FDebitFor, \r\n");
        sql.append(" FDebitLocal, \r\n");
        sql.append(" FDebitRpt, \r\n");
        sql.append(" FCreditFor, \r\n");
        sql.append(" FCreditLocal, \r\n");
        sql.append(" FCreditRpt, \r\n");
        sql.append(" FEndBalanceFor, \r\n");
        sql.append(" FEndBalanceLocal, \r\n");
        sql.append(" FEndBalanceRpt, \r\n");
        sql.append(" FDebitCount, \r\n");
        sql.append(" FCredtiCount, \r\n");
        sql.append(" FTag, \r\n");
        sql.append(" FLineType \r\n");
        if (condition.isOptionShowAsstItem()) {
            sql.append(" ,FAsstHgID \r\n");
        }
        sql.append(")");
        sql.append(" SELECT TP.FAccountID , ' ' FCurrencyID, TP.FCompanyID, \r\n");
        sql.append(" 0.00 FBeginBalanceFor, \r\n");
        sql.append(" SUM(ISNULL(FBeginBalanceLocal,0)) FBeginBalanceLocal, \r\n");
        sql.append(" SUM(ISNULL(FBeginBalanceRpt,0)) FBeginBalanceRpt, \r\n");
        sql.append(" 0.00 FDebitFor, \r\n");
        sql.append(" SUM(ISNULL(tp.FDebitLocal,0)) FDebitLocal, \r\n");
        sql.append(" SUM(ISNULL(FDebitRpt,0)) FDebitRpt, \r\n");
        sql.append(" 0.00 FCreditFor, \r\n");
        sql.append(" SUM(ISNULL(tp.FCreditLocal,0)) FCreditLocal, \r\n");
        sql.append(" SUM(ISNULL(FCreditRpt,0)) FCreditRpt, \r\n");
        sql.append(" 0.00 FEndBalanceFor, \r\n");
        sql.append(" SUM(ISNULL(tp.FEndBalanceLocal,0)) FEndBalanceLocal, \r\n");
        sql.append(" SUM(ISNULL(FEndBalanceRpt,0)) FEndBalanceRpt, \r\n");
        sql.append(" SUM(ISNULL(FDebitCount,0)) FDebitCount, \r\n");
        sql.append(" SUM(ISNULL(FCredtiCount,0)) FCredtiCount, \r\n");
        sql.append(" 1 FTag , \r\n");
        sql.append(" 0 FLineType \r\n");
        if (condition.isOptionShowAsstItem()) {
            sql.append(" , null FAsstHgID \r\n");
        }
        sql.append(" FROM ").append(partner.getTempTableName()).append(" TP \r\n");
        sql.append(" INNER JOIN T_BD_AccountView TA ON TP.FAccountID = TA.FID \r\n");
        sql.append(" WHERE \r\n");
        sql.append(" ftag = -1 \r\n");
        sql.append(" group by TP.FAccountID ,TP.FCompanyID ");
        DbUtil.execute((Context)partner.getContext(), (String)sql.toString());
    }

    private void insertSumAccountGroupByCurrency(ReportPartner partner) throws BOSException, EASBizException {
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append(" (FAccountID, FCurrencyID,FCompanyID, \r\n");
        sql.append(" FBeginBalanceFor, \r\n");
        sql.append(" FBeginBalanceLocal, \r\n");
        sql.append(" FBeginBalanceRpt, \r\n");
        sql.append(" FDebitFor, \r\n");
        sql.append(" FDebitLocal, \r\n");
        sql.append(" FDebitRpt, \r\n");
        sql.append(" FCreditFor, \r\n");
        sql.append(" FCreditLocal, \r\n");
        sql.append(" FCreditRpt, \r\n");
        sql.append(" FEndBalanceFor, \r\n");
        sql.append(" FEndBalanceLocal, \r\n");
        sql.append(" FEndBalanceRpt, \r\n");
        sql.append(" FDebitCount, \r\n");
        sql.append(" FCredtiCount, \r\n");
        sql.append(" FTag,FLineType\t\r\n");
        if (condition.isOptionShowAsstItem()) {
            sql.append(" ,FAsstHgID \r\n");
        }
        sql.append(")");
        sql.append("SELECT ' ' FAccountID, Temp.FCurrencyID, Temp.FCompanyID, \r\n");
        sql.append(" SUM(ISNULL(Temp.FBeginBalanceFor,0)) FBeginBalanceFor, \r\n");
        sql.append(" SUM(ISNULL(Temp.FBeginBalanceLocal,0)) FBeginBalanceLocal, \r\n");
        sql.append(" SUM(ISNULL(Temp.FBeginBalanceRpt,0)) FBeginBalanceRpt, \r\n");
        sql.append(" SUM(ISNULL(Temp.FDebitFor,0)) FDebitFor, \r\n");
        sql.append(" SUM(ISNULL(Temp.FDebitLocal,0)) FDebitLocal, \r\n");
        sql.append(" SUM(ISNULL(Temp.FDebitRpt,0)) FDebitRpt, \r\n");
        sql.append(" SUM(ISNULL(Temp.FCreditFor,0)) FCreditFor, \r\n");
        sql.append(" SUM(ISNULL(Temp.FCreditLocal,0)) FCreditLocal, \r\n");
        sql.append(" SUM(ISNULL(Temp.FCreditRpt,0)) FCreditRpt, \r\n");
        sql.append(" SUM(ISNULL(Temp.FEndBalanceFor,0)) FEndBalanceFor, \r\n");
        sql.append(" SUM(ISNULL(Temp.FEndBalanceLocal,0)) FEndBalanceLocal, \r\n");
        sql.append(" SUM(ISNULL(Temp.FEndBalanceRpt,0)) FEndBalanceRpt, \r\n");
        sql.append(" SUM(ISNULL(Temp.FDebitCount,0)) FDebitCount, \r\n");
        sql.append(" SUM(ISNULL(Temp.FCredtiCount,0)) FCredtiCount, \r\n");
        sql.append(" 2 FTag, \r\n");
        sql.append(" case when Temp.FCurrencyID is null or Temp.FCurrencyID = ' ' then 2 else 1 end  FLineType \r\n");
        if (condition.isOptionShowAsstItem()) {
            sql.append(" , null FAssistGrpID \r\n");
        }
        sql.append(" FROM ");
        sql.append(" (SELECT tp.FAccountID, TP.FCurrencyID, TP.FCompanyID, \r\n");
        sql.append(" SUM(ISNULL(FBeginBalanceFor,0)) FBeginBalanceFor, \r\n");
        sql.append(" SUM(ISNULL(FBeginBalanceLocal,0)) FBeginBalanceLocal, \r\n");
        sql.append(" SUM(ISNULL(FBeginBalanceRpt,0)) FBeginBalanceRpt, \r\n");
        sql.append(" SUM(ISNULL(tp.FDebitFor,0)) FDebitFor, \r\n");
        sql.append(" SUM(ISNULL(tp.FDebitLocal,0)) FDebitLocal, \r\n");
        sql.append(" SUM(ISNULL(FDebitRpt,0)) FDebitRpt, \r\n");
        sql.append(" SUM(ISNULL(tp.FCreditFor,0)) FCreditFor, \r\n");
        sql.append(" SUM(ISNULL(tp.FCreditLocal,0)) FCreditLocal, \r\n");
        sql.append(" SUM(ISNULL(FCreditRpt,0)) FCreditRpt, \r\n");
        sql.append(" SUM(ISNULL(tp.FEndBalanceFor,0)) FEndBalanceFor, \r\n");
        sql.append(" SUM(ISNULL(tp.FEndBalanceLocal,0)) FEndBalanceLocal, \r\n");
        sql.append(" SUM(ISNULL(FEndBalanceRpt,0)) FEndBalanceRpt, \r\n");
        sql.append(" SUM(ISNULL(FDebitCount,0)) FDebitCount, \r\n");
        sql.append(" SUM(ISNULL(FCredtiCount,0)) FCredtiCount,");
        sql.append(" tp.ftag  from ").append(partner.getTempTableName()).append(" Tp \r\n");
        sql.append(" INNER JOIN T_BD_AccountView TA ON TP.FAccountID = TA.FID \r\n");
        sql.append(" where \r\n");
        sql.append(" ftag<>0 and ta.flevel>=? and ta.flevel<=? and (ta.fisleaf = 1 or ta.flevel=?) \r\n");
        sql.append(" group by tp.faccountid,tp.fcurrencyid,tp.fcompanyid,ftag) temp \r\n");
        sql.append(" group by Temp.Fcurrencyid,Temp.FCompanyID\r\n");
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValue(partner.getFixCondition().getAccountLevelStart());
        parameter.addValue(partner.getFixCondition().getAccountLevelEnd());
        parameter.addValue(partner.getFixCondition().getAccountLevelEnd());
        DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(sql.toString()));
    }

    private void insertSumAccountCurrencyUnion(ReportPartner partner) throws EASBizException, BOSException {
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        boolean isSameCurrencyLocal = true;
        StringBuffer str = new StringBuffer();
        str.append(" SELECT DISTINCT FBASECURRENCYID FROM T_ORG_COMPANY WHERE FID IN ");
        str.append(partner.getPhysicalCompanyId(false));
        IRowSet rs = DbUtil.executeQuery((Context)partner.getContext(), (String)str.toString());
        if (rs.size() > 1) {
            isSameCurrencyLocal = false;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append(" (FAccountID, FCurrencyID, \t\t\t\r\n");
        sql.append("  FCompanyID,\t\r\n");
        sql.append("  FBeginBalanceFor,  \r\n");
        sql.append("  FBeginBalanceLocal, \r\n");
        sql.append("  FBeginBalanceRpt, \r\n");
        sql.append("  FDebitFor,  FDebitLocal,  FDebitRpt, \r\n");
        sql.append("  FCreditFor, FCreditLocal, FCreditRpt, \r\n");
        sql.append("  FEndBalanceFor, FEndBalanceLocal, FEndBalanceRpt, \r\n");
        sql.append("  FDebitCount,   FCredtiCount, \r\n");
        sql.append("  FTag,  FLineType \t\r\n");
        if (condition.isOptionShowAsstItem()) {
            sql.append("  ,FAsstHgID \t\t\t\t\t\t\r\n");
            sql.append(" \t  ,  FAccountOrAssist  \r\n");
        }
        sql.append(")");
        sql.append("SELECT TP.FAccountID , ' ' FCurrencyID, TP.FCompanyID FCompanyID,\t\t\t\t\r\n");
        sql.append("\t0.00 FBeginBalanceFor, \t\r\n");
        sql.append("\tSUM(ISNULL(TP.FBeginBalanceLocal,0)) FBeginBalanceLocal, \r\n");
        sql.append("\tSUM(ISNULL(TP.FBeginBalanceRpt,0)) FBeginBalanceRpt, \t\t\t\r\n");
        sql.append("\t0.00 FDebitFor, \t\t\t\r\n");
        sql.append("\tSUM(ISNULL(tp.FDebitLocal,0)) FDebitLocal, \t\t\r\n");
        sql.append("\tSUM(ISNULL(TP.FDebitRpt,0)) FDebitRpt, \t\r\n");
        sql.append("\t0.00 FCreditFor, \t\r\n");
        sql.append("\tSUM(ISNULL(tp.FCreditLocal,0)) FCreditLocal, \t\t\r\n");
        sql.append("\tSUM(ISNULL(TP.FCreditRpt,0)) FCreditRpt, \t\t\t\t\r\n");
        sql.append("\t0.00 FEndBalanceFor, \t\t\r\n");
        sql.append("\tSUM(ISNULL(tp.FEndBalanceLocal,0)) FEndBalanceLocal, \t\t\r\n");
        sql.append("\tSUM(ISNULL(TP.FEndBalanceRpt,0)) FEndBalanceRpt, \t\t\t\r\n");
        sql.append("\tSUM(ISNULL(FDebitCount,0)) FDebitCount, \t\t\t\r\n");
        sql.append("\tSUM(ISNULL(FCredtiCount,0)) FCredtiCount, \t\t\r\n");
        sql.append("   1 FTag  ,0 FLineType                                     \r\n");
        if (condition.isOptionShowAsstItem()) {
            sql.append("\t, null FAsstHgID \t\t\t\t\t\t\t\t\r\n");
            sql.append(" \t  ,2  FAccountOrAssist  \r\n");
        }
        sql.append(" FROM ");
        sql.append(partner.getTempTableName());
        sql.append(" TP \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_BD_AccountView TA ON TP.FAccountID = TA.FID \t\t\t\r\n");
        sql.append(" WHERE ftag = -1 \r\n");
        if (condition.isOptionShowAsstItem()) {
            sql.append("  and tp.FAccountOrAssist = 2 ");
        }
        sql.append(" group by TP.FAccountID ,TP.FCompanyID ");
        SqlParameter2 parameter = new SqlParameter2();
        DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(sql.toString()));
        sql.setLength(0);
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        sql.append(" (FAccountID, FCurrencyID, \tFCompanyID,\t\t\r\n");
        sql.append("  FBeginBalanceFor,  \r\n");
        sql.append("  FBeginBalanceLocal, \r\n");
        sql.append("  FBeginBalanceRpt, \r\n");
        sql.append("  FDebitFor,  FDebitLocal,  FDebitRpt, \r\n");
        sql.append("  FCreditFor, FCreditLocal, FCreditRpt, \r\n");
        sql.append("  FEndBalanceFor, FEndBalanceLocal, FEndBalanceRpt, \r\n");
        sql.append("  FDebitCount,   FCredtiCount, \r\n");
        sql.append("  FTag,FLineType\t\r\n");
        if (condition.isOptionShowAsstItem()) {
            sql.append(" \t,  FAccountOrAssist");
            sql.append("  ,FAsstHgID \t\t\t\t\t\r\n");
        }
        sql.append(")");
        sql.append("SELECT ' ' FAccountID , Temp.FCurrencyID, \tTemp.FCompanyID FCompanyID,\t\t\t\r\n");
        sql.append("\tsum(isnull(temp.fbeginbalancefor,0)) FBeginBalanceFor, \t\r\n");
        sql.append("\tSUM(ISNULL(temp.FBeginBalanceLocal,0)) FBeginBalanceLocal, \r\n");
        sql.append("\tSUM(ISNULL(temp.FBeginBalanceRpt,0)) FBeginBalanceRpt, \t\t\t\r\n");
        sql.append("\tsum(isnull(temp.fdebitfor,0)) FDebitFor, \t\t\t\r\n");
        sql.append("\tSUM(ISNULL(temp.FDebitLocal,0)) FDebitLocal, \t\t\r\n");
        sql.append("\tSUM(ISNULL(temp.FDebitRpt,0)) FDebitRpt, \t\r\n");
        sql.append("\tsum(isnull(temp.fcreditfor,0)) FCreditFor, \t\r\n");
        sql.append("\tSUM(ISNULL(temp.FCreditLocal,0)) FCreditLocal, \t\t\r\n");
        sql.append("\tSUM(ISNULL(temp.FCreditRpt,0)) FCreditRpt, \t\t\t\t\r\n");
        sql.append("\tsum(isnull(temp.fendbalancefor,0)) FEndBalanceFor, \t\t\r\n");
        sql.append("\tSUM(ISNULL(temp.FEndBalanceLocal,0)) FEndBalanceLocal, \t\t\r\n");
        sql.append("\tSUM(ISNULL(temp.FEndBalanceRpt,0)) FEndBalanceRpt, \t\t\t\r\n");
        sql.append("\tSUM(ISNULL(Temp.FDebitCount,0)) FDebitCount, \t\t\t\r\n");
        sql.append("\tSUM(ISNULL(Temp.FCredtiCount,0)) FCredtiCount, \t\r\n");
        sql.append("   \t2 FTag   ,case when Temp.FCurrencyID is null or Temp.FCurrencyID = ' ' then 2 else 1 end  FLineType        \r\n");
        if (condition.isOptionShowAsstItem()) {
            sql.append(" \t, 3  FAccountOrAssist");
            sql.append("\t, null FAssistGrpID \t\t\t\t\t\t\t\t\r\n");
        }
        sql.append("\tFrom (");
        sql.append("SELECT tp.FAccountID , TP.FCurrencyID, \tTb.FCompanyID FCompanyID,\t\t\t\r\n");
        sql.append("\tsum(isnull(tp.fbeginbalancefor,0)) FBeginBalanceFor, \t\r\n");
        sql.append("\tSUM(ISNULL(TP.FBeginBalanceLocal,0)) FBeginBalanceLocal, \r\n");
        sql.append("\tSUM(ISNULL(TP.FBeginBalanceRpt,0)) FBeginBalanceRpt, \t\t\t\r\n");
        sql.append("\tsum(isnull(tp.fdebitfor,0)) FDebitFor, \t\t\t\r\n");
        sql.append("\tSUM(ISNULL(tp.FDebitLocal,0)) FDebitLocal, \t\t\r\n");
        sql.append("\tSUM(ISNULL(TP.FDebitRpt,0)) FDebitRpt, \t\r\n");
        sql.append("\tsum(isnull(tp.fcreditfor,0)) FCreditFor, \t\r\n");
        sql.append("\tSUM(ISNULL(tp.FCreditLocal,0)) FCreditLocal, \t\t\r\n");
        sql.append("\tSUM(ISNULL(TP.FCreditRpt,0)) FCreditRpt, \t\t\t\t\r\n");
        sql.append("\tsum(isnull(tp.fendbalancefor,0)) FEndBalanceFor, \t\t\r\n");
        sql.append("\tSUM(ISNULL(tp.FEndBalanceLocal,0)) FEndBalanceLocal, \t\t\r\n");
        sql.append("\tSUM(ISNULL(TP.FEndBalanceRpt,0)) FEndBalanceRpt, \t\t\t\r\n");
        sql.append("\tSUM(ISNULL(TP.FDebitCount,0)) FDebitCount, \t\t\t\r\n");
        sql.append("\tSUM(ISNULL(TP.FCredtiCount,0)) FCredtiCount \t\t\r\n");
        sql.append("FROM ");
        sql.append(partner.getTempTableName());
        sql.append(" TP \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_BD_AccountView TA ON TP.FAccountID = TA.FID \t\t\t\r\n");
        sql.append("  inner join T_BD_AccountView TB on TA.FNumber=TB.FNumber and TA.FAccountTableId=TB.FAccountTableId \r\n");
        sql.append("    and (TB.FCompanyId=TP.FCompanyId or TB.FCompanyId='").append(partner.getCompanyId()).append("')\r\n");
        sql.append(" WHERE  ftag<>0\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" and ( ta.flevel>=? and ta.flevel<=? and (ta.fisleaf = 1 or ta.flevel=?)  ) \t\t\t\t\t\r\n");
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            sql.append("   AND (TA.FNumber >= ?)  \r\n");
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            sql.append(" AND (TA.FNumber <= ?)  \r\n");
        }
        if (condition.isOptionShowAsstItem()) {
            sql.append("  and tp.FAccountOrAssist = 2 ");
        }
        sql.append(" group by tp.faccountid,TP.Fcurrencyid,TB.FCompanyID ) temp ");
        sql.append(" group by temp.fcurrencyid,temp.fcompanyid");
        parameter = new SqlParameter2();
        parameter.addValue(partner.getFixCondition().getAccountLevelStart());
        parameter.addValue(partner.getFixCondition().getAccountLevelEnd());
        parameter.addValue(partner.getFixCondition().getAccountLevelEnd());
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            parameter.addValueVarchar(condition.getAccountCodeStart());
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            parameter.addValueVarchar(condition.getAccountCodeEnd() + "zz");
        }
        DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(sql.toString()));
        if (!isSameCurrencyLocal) {
            partner.executeSql("update " + partner.getTempTableName() + " set FBeginBalanceLocal=0,FEndBalanceLocal=0,FDebitLocal=0,FCreditLocal=0 where ftag=2 and fcompanyid not in" + partner.getPhysicalCompanyId(false), null);
            DbUtil.execute((Context)partner.getContext(), (String)("update " + partner.getTempTableName() + " set FBeginBalanceLocal=0,FEndBalanceLocal=0,FDebitLocal=0,FCreditLocal=0 where ftag=2 and fcompanyid not in" + partner.getPhysicalCompanyId(false)));
        }
    }

    private void insertSumAccountGroupByCurrencyUnion(ReportPartner partner) throws EASBizException, BOSException {
        DefaultMutableTreeNode companyTree;
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        boolean isSameCurrencyLocal = true;
        StringBuffer str = new StringBuffer();
        str.append(" SELECT DISTINCT FBASECURRENCYID FROM T_ORG_COMPANY WHERE FID IN ");
        str.append(partner.getPhysicalCompanyId(false));
        IRowSet rs = DbUtil.executeQuery((Context)partner.getContext(), (String)str.toString());
        if (rs.size() > 1) {
            isSameCurrencyLocal = false;
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("INSERT ");
        sql.append(partner.getTempTableName());
        sql.append(" \r\n");
        boolean isShowForCurrency = this.isShowForCurrency(partner);
        boolean isShowLocalCurrency = this.isShowLocalCurrency(partner);
        boolean isShowReportCurrency = this.isShowReportCurrency(partner);
        sql.append(" (  FAccountID, \r\n");
        if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(condition.getCurrencyID()) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(condition.getCurrencyID())) {
            sql.append("   FCurrencyID, \t\r\n");
        }
        sql.append("  \tFCompanyID,\t\t\r\n");
        if (isShowForCurrency) {
            sql.append("  FBeginBalanceFor,  \r\n");
        }
        if (isShowLocalCurrency) {
            sql.append("  FBeginBalanceLocal, \r\n");
        }
        if (isShowReportCurrency) {
            sql.append("  FBeginBalanceRpt, \r\n");
        }
        if (isShowForCurrency) {
            sql.append("  FDebitFor, \r\n");
        }
        if (isShowLocalCurrency) {
            sql.append("  FDebitLocal, \r\n");
        }
        if (isShowReportCurrency) {
            sql.append("  FDebitRpt, \r\n");
        }
        if (isShowForCurrency) {
            sql.append("  FCreditFor, \r\n");
        }
        if (isShowLocalCurrency) {
            sql.append("  FCreditLocal, \r\n");
        }
        if (isShowReportCurrency) {
            sql.append("  FCreditRpt, \r\n");
        }
        if (isShowForCurrency) {
            sql.append("  FEndBalanceFor, \r\n");
        }
        if (isShowLocalCurrency) {
            sql.append("  FEndBalanceLocal, \r\n");
        }
        if (isShowReportCurrency) {
            sql.append("  FEndBalanceRpt, \r\n");
        }
        sql.append("  FDebitCount,   FCredtiCount, \r\n");
        sql.append("  FTag,FLineType\t\r\n");
        if (condition.isOptionShowAsstItem()) {
            sql.append(" \t,  FAccountOrAssist");
            sql.append("  ,FAsstHgID \t\t\t\t\t\r\n");
        }
        sql.append(")");
        sql.append("SELECT ' ' FAccountID , \r\n");
        if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(condition.getCurrencyID()) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(condition.getCurrencyID())) {
            sql.append(" Temp.FCurrencyID, \t\r\n");
        }
        sql.append("  Temp.FCompanyID FCompanyID,\t\t\t\r\n");
        if (isShowForCurrency) {
            sql.append("\tsum(isnull(temp.fbeginbalancefor,0)) FBeginBalanceFor, \t\r\n");
        }
        if (isShowLocalCurrency) {
            sql.append("\tSUM(ISNULL(temp.FBeginBalanceLocal,0)) FBeginBalanceLocal, \r\n");
        }
        if (isShowReportCurrency) {
            sql.append("\tSUM(ISNULL(temp.FBeginBalanceRpt,0)) FBeginBalanceRpt, \t\t\t\r\n");
        }
        if (isShowForCurrency) {
            sql.append("\tsum(isnull(temp.fdebitfor,0)) FDebitFor, \t\t\t\r\n");
        }
        if (isShowLocalCurrency) {
            sql.append("\tSUM(ISNULL(temp.FDebitLocal,0)) FDebitLocal, \t\t\r\n");
        }
        if (isShowReportCurrency) {
            sql.append("\tSUM(ISNULL(temp.FDebitRpt,0)) FDebitRpt, \t\r\n");
        }
        if (isShowForCurrency) {
            sql.append("\tsum(isnull(temp.fcreditfor,0)) FCreditFor, \t\r\n");
        }
        if (isShowLocalCurrency) {
            sql.append("\tSUM(ISNULL(temp.FCreditLocal,0)) FCreditLocal, \t\t\r\n");
        }
        if (isShowReportCurrency) {
            sql.append("\tSUM(ISNULL(temp.FCreditRpt,0)) FCreditRpt, \t\t\t\t\r\n");
        }
        if (isShowForCurrency) {
            sql.append("\tsum(isnull(temp.fendbalancefor,0)) FEndBalanceFor, \t\t\r\n");
        }
        if (isShowLocalCurrency) {
            sql.append("\tSUM(ISNULL(temp.FEndBalanceLocal,0)) FEndBalanceLocal, \t\t\r\n");
        }
        if (isShowReportCurrency) {
            sql.append("\tSUM(ISNULL(temp.FEndBalanceRpt,0)) FEndBalanceRpt, \t\t\t\r\n");
        }
        sql.append("\tSUM(ISNULL(Temp.FDebitCount,0)) FDebitCount, \t\t\t\r\n");
        sql.append("\tSUM(ISNULL(Temp.FCredtiCount,0)) FCredtiCount, \t\r\n");
        if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(condition.getCurrencyID()) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(condition.getCurrencyID())) {
            sql.append("   \t2 FTag   ,case when Temp.FCurrencyID is null or Temp.FCurrencyID = ' ' then 2 else 1 end  FLineType        \r\n");
        } else {
            sql.append("   \t2 FTag   , 1   FLineType        \r\n");
        }
        if (condition.isOptionShowAsstItem()) {
            sql.append(" \t, 3  FAccountOrAssist");
            sql.append("\t, null FAssistGrpID \t\t\t\t\t\t\t\t\r\n");
        }
        sql.append("\tFrom (");
        sql.append("SELECT tp.FAccountID , \t\r\n");
        if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(condition.getCurrencyID()) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(condition.getCurrencyID())) {
            sql.append("TP.FCurrencyID, \t\r\n");
        }
        sql.append("Tb.FCompanyID FCompanyID,\t\t\t\r\n");
        if (isShowForCurrency) {
            sql.append("\tsum(isnull(tp.fbeginbalancefor,0)) FBeginBalanceFor, \t\r\n");
        }
        if (isShowLocalCurrency) {
            sql.append("\tSUM(ISNULL(TP.FBeginBalanceLocal,0)) FBeginBalanceLocal, \r\n");
        }
        if (isShowReportCurrency) {
            sql.append("\tSUM(ISNULL(TP.FBeginBalanceRpt,0)) FBeginBalanceRpt, \t\t\t\r\n");
        }
        if (isShowForCurrency) {
            sql.append("\tsum(isnull(tp.fdebitfor,0)) FDebitFor, \t\t\t\r\n");
        }
        if (isShowLocalCurrency) {
            sql.append("\tSUM(ISNULL(tp.FDebitLocal,0)) FDebitLocal, \t\t\r\n");
        }
        if (isShowReportCurrency) {
            sql.append("\tSUM(ISNULL(TP.FDebitRpt,0)) FDebitRpt, \t\r\n");
        }
        if (isShowForCurrency) {
            sql.append("\tsum(isnull(tp.fcreditfor,0)) FCreditFor, \t\r\n");
        }
        if (isShowLocalCurrency) {
            sql.append("\tSUM(ISNULL(tp.FCreditLocal,0)) FCreditLocal, \t\t\r\n");
        }
        if (isShowReportCurrency) {
            sql.append("\tSUM(ISNULL(TP.FCreditRpt,0)) FCreditRpt, \t\t\t\t\r\n");
        }
        if (isShowForCurrency) {
            sql.append("\tsum(isnull(tp.fendbalancefor,0)) FEndBalanceFor, \t\t\r\n");
        }
        if (isShowLocalCurrency) {
            sql.append("\tSUM(ISNULL(tp.FEndBalanceLocal,0)) FEndBalanceLocal, \t\t\r\n");
        }
        if (isShowReportCurrency) {
            sql.append("\tSUM(ISNULL(TP.FEndBalanceRpt,0)) FEndBalanceRpt, \t\t\t\r\n");
        }
        sql.append("\tSUM(ISNULL(TP.FDebitCount,0)) FDebitCount, \t\t\t\r\n");
        sql.append("\tSUM(ISNULL(TP.FCredtiCount,0)) FCredtiCount \t\t\r\n");
        sql.append("FROM ");
        sql.append(partner.getTempTableName());
        sql.append(" TP \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_BD_AccountView TA ON TP.FAccountID = TA.FID \t\t\t\r\n");
        sql.append("  inner join T_BD_AccountView TB on TA.FNumber=TB.FNumber and TA.FAccountTableId=TB.FAccountTableId \r\n");
        sql.append("    and TB.FCompanyId=TP.FCompanyId  \r\n");
        sql.append(" WHERE  ftag<>0\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" and ( ta.flevel>=? and ta.flevel<=? and (ta.fisleaf = 1 or ta.flevel=?)  ) \t\t\t\t\t\r\n");
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            sql.append("   AND (TA.FNumber >= ?)  \r\n");
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            sql.append(" AND (TA.FNumber <= ?)  \r\n");
        }
        if (condition.isOptionShowAsstItem()) {
            sql.append("  and tp.FAccountOrAssist = 2 ");
        }
        sql.append(" group by tp.faccountid, ");
        if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(condition.getCurrencyID()) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(condition.getCurrencyID())) {
            sql.append(" TP.Fcurrencyid, ");
        }
        sql.append(" TB.FCompanyID ) temp ");
        sql.append(" group by ");
        if (!"11111111-1111-1111-1111-111111111111DEB58FDC".equals(condition.getCurrencyID()) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(condition.getCurrencyID())) {
            sql.append(" temp.fcurrencyid, ");
        }
        sql.append(" temp.fcompanyid");
        SqlParameter2 parameter = new SqlParameter2();
        parameter.addValue(partner.getFixCondition().getAccountLevelStart());
        parameter.addValue(partner.getFixCondition().getAccountLevelEnd());
        parameter.addValue(partner.getFixCondition().getAccountLevelEnd());
        if (condition.getAccountCodeStart() != null && condition.getAccountCodeStart().trim().length() != 0) {
            parameter.addValueVarchar(condition.getAccountCodeStart());
        }
        if (condition.getAccountCodeEnd() != null && condition.getAccountCodeEnd().trim().length() != 0) {
            parameter.addValueVarchar(condition.getAccountCodeEnd() + "zz");
        }
        DbUtil.execute((Context)partner.getContext(), (String)parameter.getSqlWithParameters(sql.toString()));
        if (!isSameCurrencyLocal && isShowLocalCurrency) {
            DbUtil.execute((Context)partner.getContext(), (String)("update " + partner.getTempTableName() + " set FBeginBalanceLocal=0,FEndBalanceLocal=0,FDebitLocal=0,FCreditLocal=0 where ftag=2 and fcompanyid not in" + partner.getPhysicalCompanyId(false)));
        }
        if ((companyTree = (DefaultMutableTreeNode)condition.getTreeModelOfCompany()) != null) {
            Enumeration<TreeNode> enumer = companyTree.breadthFirstEnumeration();
            Object accountId = condition.getExpandInfo().get("AccountID");
            condition.getExpandInfo().put("AccountID", " ");
            while (enumer.hasMoreElements()) {
                companyTree = (DefaultMutableTreeNode)enumer.nextElement();
                SimpleCompanyUserObject company = (SimpleCompanyUserObject)companyTree.getUserObject();
                if (company == null || company.isLeaf()) continue;
                this.insertTempTableForVirtual(partner, company);
            }
            condition.getExpandInfo().put("AccountID", accountId);
        }
    }

    @Override
    protected boolean isSupportVirtual() {
        return true;
    }

    @Override
    protected void insertTempTableForVirtual(ReportPartner partner, SimpleCompanyUserObject simpleCompanyUserObject) throws BOSException, EASBizException {
        String companyId = simpleCompanyUserObject.getCompanyId();
        String companyIdInClause = partner.getPhysicalCompanyIdByParent(simpleCompanyUserObject);
        EntityViewInfo evi = partner.getCondition();
        ReportConditionJournal customCondition = (ReportConditionJournal)evi.get("GLFixCondition");
        String expandAccount = (String)customCondition.getExpandInfo().get("AccountID");
        String expandCurrency = customCondition.getExpandInfo().get("CurrencyIDa") == null ? null : (String)customCondition.getExpandInfo().get("CurrencyIDa");
        String currencyId = partner.getFixCondition().getCurrencyID();
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        boolean isSameCurrencyLocal = true;
        StringBuffer str = new StringBuffer();
        str.append(" \tSELECT DISTINCT FBASECURRENCYID FROM T_ORG_COMPANY WHERE FID IN \r\n");
        str.append(" \t( select distinct com2.fid from t_org_company com1 \r\n");
        str.append("\tinner join t_org_company com2 on charindex(com1.flongnumber,com2.flongnumber)=1 \r\n ");
        str.append("\twhere com1.fid='").append(companyId).append("' ");
        str.append("\tand com2.fid in \r\n");
        str.append(partner.getPhysicalCompanyId(false));
        str.append(" )");
        IRowSet rs = DbUtil.executeQuery((Context)partner.getContext(), (String)str.toString());
        if (rs.size() > 1) {
            isSameCurrencyLocal = false;
        }
        StringBuffer sql = new StringBuffer();
        if (expandAccount == null || expandAccount.trim().length() > 0) {
            sql.append("INSERT ");
            sql.append(partner.getTempTableName());
            sql.append(" \r\n");
            sql.append("\t(FACCOUNTID, \r\n");
            if (isForCurrency) {
                sql.append("\tFCURRENCYID, \r\n");
            }
            sql.append("\tFCOMPANYID,FASSTHGID, \r\n");
            if (isForCurrency) {
                sql.append("    FBEGINBALANCEFOR, FDEBITFOR, FCREDITFOR, FENDBALANCEFOR, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append("\tFBEGINBALANCELOCAL, FDEBITLOCAL, FCREDITLOCAL, FENDBALANCELOCAL, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("\tFBEGINBALANCERPT, FDEBITRPT, FCREDITRPT, FENDBALANCERPT, \r\n");
            }
            sql.append("\tFDEBITCOUNT,FCREDTICOUNT,FTAG,FLINETYPE      \r\n");
            if (GlUtils.isCompanyUnion(partner.getCompany()) && customCondition.isOptionShowAsstItem()) {
                sql.append(" \t,FAccountOrAssist");
            }
            sql.append("\t)");
            if (isSameCurrencyLocal) {
                sql.append("    SELECT TEMP.FACCOUNTID AS FACCOUNTID,");
                if (isForCurrency) {
                    sql.append("    TEMP.FCURRENCYID AS FCURRENCYID, ");
                }
                sql.append("    \r\n").append("'" + companyId + "'");
                sql.append("\tAS FCOMPANYID,NULL AS FASSTHGID,  \r\n");
                if (isForCurrency) {
                    sql.append("    SUM(TEMP.FBEGINBALANCEFOR), SUM(TEMP.FDEBITFOR), SUM(TEMP.FCREDITFOR), SUM(TEMP.FENDBALANCEFOR), \r\n");
                }
                if (isLocaCurrency || isForCurrency) {
                    sql.append("\tSUM(TEMP.FBEGINBALANCELOCAL), SUM(TEMP.FDEBITLOCAL), SUM(TEMP.FCREDITLOCAL), SUM(TEMP.FENDBALANCELOCAL),    \r\n");
                }
                if (isRptCurrency || isForCurrency) {
                    sql.append("\tSUM(TEMP.FBEGINBALANCERPT), SUM(TEMP.FDEBITRPT), SUM(TEMP.FCREDITRPT), \r\n ");
                }
            } else {
                sql.append("    SELECT TEMP.FACCOUNTID AS FACCOUNTID,");
                if (isForCurrency) {
                    sql.append("    TEMP.FCURRENCYID AS FCURRENCYID,");
                }
                sql.append("     \r\n").append("'" + companyId + "'");
                sql.append("\tAS FCOMPANYID,NULL AS FASSTHGID,    \r\n");
                if (isForCurrency) {
                    sql.append("    SUM(TEMP.FBEGINBALANCEFOR), SUM(TEMP.FDEBITFOR), SUM(TEMP.FCREDITFOR), SUM(TEMP.FENDBALANCEFOR), \r\n");
                }
                if (isLocaCurrency || isForCurrency) {
                    sql.append("\tSUM(TEMP.FBEGINBALANCELOCAL), SUM(TEMP.FDEBITLOCAL), SUM(TEMP.FCREDITLOCAL), SUM(TEMP.FENDBALANCELOCAL),    \r\n");
                }
                if (isRptCurrency || isForCurrency) {
                    sql.append("\tSUM(TEMP.FBEGINBALANCERPT), SUM(TEMP.FDEBITRPT), SUM(TEMP.FCREDITRPT), \r\n ");
                }
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("\tSUM(TEMP.FENDBALANCERPT),  \r\n");
            }
            sql.append("\tSUM(TEMP.FDEBITCOUNT),SUM(TEMP.FCREDTICOUNT),      \r\n");
            sql.append("\tFTag,FLineType\t \r\n");
            if (GlUtils.isCompanyUnion(partner.getCompany()) && customCondition.isOptionShowAsstItem()) {
                sql.append(" \t, 2 FAccountOrAssist");
            }
            sql.append("\tFROM  (\r\n");
            sql.append("    SELECT  (case when TB.FID is null then ta.fid else tb.fid end) AS FACCOUNTID, \r\n");
            if (isForCurrency) {
                sql.append("\tT.FCURRENCYID AS FCURRENCYID, \r\n");
            }
            sql.append("\tT.FCOMPANYID AS FCOMPANYID,\r\n");
            if (isForCurrency) {
                sql.append("\tSUM(FBEGINBALANCEFOR) FBEGINBALANCEFOR, SUM(FDEBITFOR) FDEBITFOR, SUM(FCREDITFOR) FCREDITFOR, SUM(FENDBALANCEFOR) FENDBALANCEFOR,   \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append("\tSUM(FBEGINBALANCELOCAL) FBEGINBALANCELOCAL, SUM(FDEBITLOCAL) FDEBITLOCAL, SUM(FCREDITLOCAL) FCREDITLOCAL, SUM(FENDBALANCELOCAL) FENDBALANCELOCAL,      \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("\tSUM(FBEGINBALANCERPT) FBEGINBALANCERPT, SUM(FDEBITRPT) FDEBITRPT, SUM(FCREDITRPT) FCREDITRPT, SUM(FENDBALANCERPT) FENDBALANCERPT, \r\n");
            }
            sql.append("\tSUM(FDEBITCOUNT) FDEBITCOUNT,SUM(FCREDTICOUNT) FCREDTICOUNT,      \r\n");
            sql.append("\tFTag,FLineType\t \r\n");
            sql.append("\tFROM \t\r\n");
            sql.append(partner.getTempTableName());
            sql.append("\tT INNER JOIN T_BD_ACCOUNTVIEW TA ON TA.FID= T.FACCOUNTID      \r\n");
            sql.append("\tleft JOIN T_BD_ACCOUNTVIEW TB ON TA.FNUMBER=TB.FNUMBER AND ");
            sql.append(" \tTB.FCOMPANYID = '").append(companyId).append("'");
            sql.append("\tAND TB.FACCOUNTTABLEID='").append(partner.getAccountTableId()).append("' \r\n");
            if (expandAccount != null) {
                sql.append("INNER JOIN T_BD_ACCOUNTVIEW TD ON TD.FNUMBER=TA.FNUMBER AND TD.FID='").append(expandAccount);
                sql.append("'");
            }
            sql.append("\tWHERE T.FCOMPANYID IN      \r\n");
            sql.append(companyIdInClause);
            if (expandCurrency != null && expandCurrency.trim().length() > 0) {
                if (expandCurrency.equals("AllCurrency")) {
                    sql.append(" and T.fcurrencyid = ' ' ");
                } else {
                    sql.append(" and T.fcurrencyid = '").append(expandCurrency).append("' ");
                }
            }
            if (GlUtils.isCompanyUnion(partner.getCompany()) && customCondition.isOptionShowAsstItem()) {
                sql.append(" \tAND T.FAccountOrAssist=2");
            }
            sql.append("\tGROUP BY T.FCOMPANYID, case when TB.FID is null then ta.fid else tb.fid end,");
            if (isForCurrency) {
                sql.append("\tT.FCURRENCYID,");
            }
            sql.append("\tT.FTAG,T.FLINETYPE");
            sql.append("\t) TEMP ");
            sql.append("\tGROUP BY Temp.FAccountid,");
            if (isForCurrency) {
                sql.append("\tTemp.FCURRENCYID,");
            }
            sql.append("\tTemp.FTAG,Temp.FLINETYPE");
        } else {
            sql.setLength(0);
            sql.append("INSERT ");
            sql.append(partner.getTempTableName());
            sql.append(" \r\n");
            sql.append("\t(FACCOUNTID,");
            if (isForCurrency) {
                sql.append("FCURRENCYID,");
            }
            sql.append("FCOMPANYID,FASSTHGID,      \r\n");
            if (isForCurrency) {
                sql.append("    FBEGINBALANCEFOR, FDEBITFOR, FCREDITFOR, FENDBALANCEFOR, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append("\tFBEGINBALANCELOCAL, FDEBITLOCAL, FCREDITLOCAL, FENDBALANCELOCAL, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("\tFBEGINBALANCERPT, FDEBITRPT, FCREDITRPT, FENDBALANCERPT, \r\n");
            }
            sql.append("\tFDEBITCOUNT,FCREDTICOUNT,FTAG,FLINETYPE      \r\n");
            if (GlUtils.isCompanyUnion(partner.getCompany()) && customCondition.isOptionShowAsstItem()) {
                sql.append(" \t,FAccountOrAssist");
            }
            sql.append("\t)");
            if (isSameCurrencyLocal) {
                sql.append("    SELECT T.FACCOUNTID AS FACCOUNTID,");
                if (isForCurrency) {
                    sql.append("    T.FCURRENCYID AS FCURRENCYID,");
                }
                sql.append("    \r\n").append("'" + companyId + "'");
                sql.append("\tAS FCOMPANYID,NULL AS FASSTHGID,  \r\n");
                if (isForCurrency) {
                    sql.append("\tSUM(FBEGINBALANCEFOR) FBEGINBALANCEFOR, SUM(FDEBITFOR) FDEBITFOR, SUM(FCREDITFOR) FCREDITFOR, SUM(FENDBALANCEFOR) FENDBALANCEFOR,   \r\n");
                }
                if (isLocaCurrency || isForCurrency) {
                    sql.append("\tSUM(FBEGINBALANCELOCAL) FBEGINBALANCELOCAL, SUM(FDEBITLOCAL) FDEBITLOCAL, SUM(FCREDITLOCAL) FCREDITLOCAL, SUM(FENDBALANCELOCAL) FENDBALANCELOCAL,      \r\n");
                }
                if (isRptCurrency || isForCurrency) {
                    sql.append("\tSUM(FBEGINBALANCERPT) FBEGINBALANCERPT, SUM(FDEBITRPT) FDEBITRPT, SUM(FCREDITRPT) FCREDITRPT, SUM(FENDBALANCERPT) FENDBALANCERPT, \r\n");
                }
                sql.append("\tSUM(FDEBITCOUNT) FDEBITCOUNT,SUM(FCREDTICOUNT) FCREDTICOUNT,      \r\n");
                sql.append("\tFTag,FLineType\t \r\n");
            } else {
                sql.append("    SELECT T.FACCOUNTID AS FACCOUNTID,");
                if (isForCurrency) {
                    sql.append("    T.FCURRENCYID AS FCURRENCYID,");
                }
                sql.append("    \r\n").append("'" + companyId + "'");
                sql.append("\tAS FCOMPANYID,NULL AS FASSTHGID,  \r\n");
                if (isForCurrency) {
                    sql.append("\tSUM(FBEGINBALANCEFOR) FBEGINBALANCEFOR, SUM(FDEBITFOR) FDEBITFOR, SUM(FCREDITFOR) FCREDITFOR, SUM(FENDBALANCEFOR) FENDBALANCEFOR,   \r\n");
                }
                if (isLocaCurrency || isForCurrency) {
                    sql.append("\t0.0 FBEGINBALANCELOCAL, 0.0 FDEBITLOCAL, 0.0 FCREDITLOCAL, 0.0 FENDBALANCELOCAL,      \r\n");
                }
                if (isRptCurrency || isForCurrency) {
                    sql.append("\tSUM(FBEGINBALANCERPT) FBEGINBALANCERPT, SUM(FDEBITRPT) FDEBITRPT, SUM(FCREDITRPT) FCREDITRPT, SUM(FENDBALANCERPT) FENDBALANCERPT, \r\n");
                }
                sql.append("\tSUM(FDEBITCOUNT) FDEBITCOUNT,SUM(FCREDTICOUNT) FCREDTICOUNT,      \r\n");
                sql.append("\tFTag,FLineType\t \r\n");
            }
            if (GlUtils.isCompanyUnion(partner.getCompany()) && customCondition.isOptionShowAsstItem()) {
                sql.append(" \t, 2 FAccountOrAssist");
            }
            sql.append("\tFROM \t\r\n");
            sql.append(partner.getTempTableName());
            sql.append("\tT WHERE T.FCOMPANYID IN      \r\n");
            sql.append(companyIdInClause);
            if (expandCurrency != null && expandCurrency.trim().length() > 0) {
                if (expandCurrency.equals("AllCurrency")) {
                    sql.append(" and T.fcurrencyid = ' ' ");
                } else {
                    sql.append(" and T.fcurrencyid = '").append(expandCurrency).append("' ");
                }
            }
            sql.append(" AND T.FTAG = 2 ");
            sql.append("\tGROUP BY T.FACCOUNTID,");
            if (isForCurrency) {
                sql.append("T.FCURRENCYID,");
            }
            sql.append("T.FTAG,T.FLINETYPE");
        }
        DbUtil.execute((Context)partner.getContext(), (String)sql.toString());
    }

    @Override
    protected String getQuerySql(ReportPartner partner) throws BOSException, EASBizException {
        Object selectedCompanyObj;
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        EntityViewInfo evi = partner.getCondition();
        ReportConditionBase customCondition = (ReportConditionBase)evi.get("GLFixCondition");
        String expandAccount = (String)customCondition.getExpandInfo().get("AccountID");
        String expandCurrency = customCondition.getExpandInfo().get("CurrencyIDa") == null ? null : (String)customCondition.getExpandInfo().get("CurrencyIDa");
        SimpleCompanyUserObject virtureCompany = new SimpleCompanyUserObject();
        List userObjects = (List)evi.get("Companys");
        StringBuffer inCompany = new StringBuffer("(");
        for (int i = 0; i < userObjects.size(); ++i) {
            virtureCompany = (SimpleCompanyUserObject)userObjects.get(i);
            inCompany.append("'").append(virtureCompany.getCompanyId()).append("',");
        }
        if (inCompany.length() > 1) {
            inCompany.replace(inCompany.length() - 1, inCompany.length(), ")");
        } else {
            inCompany.append(")");
        }
        String sqlSelect = this.getSqlForDataSelect(partner);
        String sqlFrom = this.getSqlForDataFrom(partner);
        String sqlWhere = this.getSqlForDataWhere(partner);
        String sqlOrder = this.getSqlForDataOrder(partner);
        sqlWhere = sqlWhere + " and T_Main.FCompanyID in " + inCompany.toString();
        if (expandAccount != null && expandAccount.trim().length() == 0) {
            sqlWhere = sqlWhere + " and FTag=2";
            if (expandCurrency != null && expandCurrency.equals("AllCurrency") && partner.getFixCondition().isAllCurrency()) {
                sqlWhere = sqlWhere + " and T_Main.FCurrencyID =' '";
            }
        } else if (expandAccount != null && expandAccount.trim().length() > 0 && expandCurrency != null && expandCurrency.equals("AllCurrency")) {
            sqlWhere = sqlWhere + " and T_Main.FCurrencyID = ' '";
        }
        if ((selectedCompanyObj = partner.getCondition().get("SelectedCompany")) instanceof SimpleCompanyUserObject) {
            CompanyOrgUnitInfo selectCompany = CompanyOrgUnitFactory.getLocalInstance((Context)partner.getContext()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(((SimpleCompanyUserObject)selectedCompanyObj).getCompanyId()));
            if (condition.isOptionShowAsstItem() && !partner.isNewQuery()) {
                sqlWhere = GlUtils.isCompanyUnion(selectCompany) ? sqlWhere + " and T_Main.FAsstHgID is null " : sqlWhere + " and T_Main.FAsstHgID is not null ";
            }
        }
        return "select " + sqlSelect + sqlFrom + sqlWhere + sqlOrder;
    }

    private String getStrCompanyIds(ReportPartner partner) {
        if (this.strCompanyIds == null) {
            ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
            StringBuffer result = new StringBuffer("(");
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)condition.getTreeModelOfCompany();
            Enumeration<TreeNode> e = node.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                node = (DefaultMutableTreeNode)e.nextElement();
                if (!node.isLeaf()) continue;
                SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
                result.append("'").append(userObject.getCompanyId()).append("',");
            }
            if (result.length() > 1) {
                result.replace(result.length() - 1, result.length(), ")");
            } else {
                result.append(")");
            }
            this.strCompanyIds = result.toString();
        }
        return this.strCompanyIds;
    }

    private PeriodInfo getVirturePeriod(ReportPartner partner) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT top 1 p.fid FPeriodID,p.FPeriodYear FPeriodYear,p.FPeriodQuarter FPeriodQuarter,p.FBeginDate FBeginDate,p.FendDate FendDate,p.FPeriodNumber FPeriodNumber,p.FNumber FNumber \r\n");
        sql.append(" FROM T_ORG_COMPANY com \r\n");
        sql.append(" INNER JOIN T_BD_SYSTEMSTATUSCTROL sysctrl ON sysctrl.FCompanyID = com.FID \r\n");
        sql.append(" INNER JOIN T_BD_SYSTEMSTATUS tsst ON sysctrl.FSystemStatusID=tsst.FID and tsst.FName=6 \r\n");
        sql.append(" INNER JOIN T_BD_PERIOD p ON p.fid = sysctrl.FCurrentPeriodID AND sysctrl.FISSTART = 1 \r\n");
        sql.append(" WHERE com.FID IN ").append(this.getStrCompanyIds(partner)).append(" \r\n");
        sql.append(" order by p.fnumber asc ");
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        PeriodInfo theCurrentPeriod = new PeriodInfo();
        try {
            cn = partner.getConnection();
            stmt = cn.prepareStatement(sql.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                theCurrentPeriod.setId(BOSUuid.read((String)rs.getString("FPeriodID").toString()));
                theCurrentPeriod.setPeriodYear(rs.getInt("FPeriodYear"));
                theCurrentPeriod.setPeriodQuarter(rs.getInt("FPeriodQuarter"));
                theCurrentPeriod.setBeginDate((java.util.Date)rs.getDate("FBeginDate"));
                theCurrentPeriod.setEndDate(rs.getTimestamp("FendDate"));
                theCurrentPeriod.setPeriodNumber(rs.getInt("FPeriodNumber"));
                theCurrentPeriod.setNumber(rs.getInt("FNumber"));
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        return theCurrentPeriod;
    }

    private boolean isShowForCurrency(ReportPartner partner) throws EASBizException, BOSException {
        return partner.getCurrencyType() != 1 && partner.getCurrencyType() != 2;
    }

    private boolean isShowLocalCurrency(ReportPartner partner) throws EASBizException, BOSException {
        return !partner.isParmForeignCurrencySu() && (partner.getCurrencyType() == 1 || !partner.isBaseCurrency() && partner.getCurrencyType() != 2);
    }

    private boolean isShowReportCurrency(ReportPartner partner) throws EASBizException, BOSException {
        return !partner.isParmForeignCurrencySu() && partner.isParmUseReportCurrency() && (partner.getCurrencyType() == 2 || !partner.isReportingCurrency() && partner.getCurrencyType() != 1);
    }

    protected void insertLeafAccountSumData(ReportPartner partner, String leafAccBalanceTemp, String strFirstTableName) throws BOSException {
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        String currencyId = condition.getCurrencyID();
        boolean isForCurrency = false;
        boolean isLocalCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocalCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(strFirstTableName);
        sql.append(" SELECT t.* from (");
        sql.append(" SELECT FAccountID,");
        if (isForCurrency) {
            sql.append(" FCurrencyID,");
        }
        sql.append(" FCompanyID, FAsstHgID,");
        if (isForCurrency) {
            sql.append(" sum(FBeginBalanceFor) AS FBeginBalanceFor,\r\n");
            sql.append(" sum(FDebitFor) FDebitFor, \r\n");
            sql.append(" sum(FCreditFor) FCreditFor, \r\n");
            sql.append(" sum(FEndBalanceFor) AS FEndBalanceFor, \r\n");
        }
        if (isLocalCurrency || isForCurrency) {
            sql.append(" sum(FBeginBalanceLocal) AS FBeginBalanceLocal,\r\n");
            sql.append(" sum(FDebitLocal) FDebitLocal, \r\n");
            sql.append(" sum(FCreditLocal) FCreditLocal, \r\n");
            sql.append(" sum(FEndBalanceLocal) AS FEndBalanceLocal, \r\n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" sum(FBeginBalanceRpt) AS FBeginBalanceRpt,\r\n");
            sql.append(" sum(FDebitRpt) FDebitRpt, \r\n");
            sql.append(" sum(FCreditRpt) FCreditRpt, \r\n");
            sql.append(" sum(FEndBalanceRpt) AS FEndBalanceRpt, \r\n");
        }
        sql.append(" sum(FDebitCount) as FDebitCount, \r\n");
        sql.append(" sum(FCredtiCount) as FCreditCount, \r\n");
        sql.append(" FTag , \r\n");
        sql.append(" FLineType \r\n");
        if (GlUtils.isCompanyUnion(partner.getCompany()) && condition.isOptionShowAsstItem()) {
            sql.append(", FAccountOrAssist  \r\n");
        }
        sql.append(" from ").append(leafAccBalanceTemp);
        sql.append(" GROUP BY FAccountID");
        if (isForCurrency) {
            sql.append(" ,FCurrencyID");
        }
        sql.append(", FCompanyID, FAsstHgID, FTag, FLineType ");
        if (GlUtils.isCompanyUnion(partner.getCompany()) && condition.isOptionShowAsstItem()) {
            sql.append(", FAccountOrAssist ");
        }
        sql.append(") t where 1 = 1 ");
        if (condition.isOptionNOTDisplayIfBalanceZero()) {
            sql.append(" and (1=0 ").append(isForCurrency ? " or (t.FEndBalanceFor <> 0)" : "").append(isLocalCurrency ? " or (t.FEndBalanceLocal <> 0)" : "").append(isRptCurrency ? " or (t.FEndBalanceRpt <> 0)" : "").append(") \r\n");
        }
        if (condition.isOptionNOTDisplayIfNoAmount()) {
            sql.append(" and (t.FDebitCount <> 0 or t.FCreditCount <> 0").append(isForCurrency ? " or (t.FDebitFor <> 0) OR (t.FCreditFor <> 0)" : "").append(isLocalCurrency ? " or (t.FDebitLocal <> 0) OR (t.FCreditLocal <> 0)" : "").append(isRptCurrency ? " or (t.FDebitRpt <> 0) OR (t.FCreditRpt <> 0)" : "").append(") \r\n");
        }
        DbUtil.execute((Context)partner.getContext(), (String)sql.toString());
        if (leafAccBalanceTemp != null) {
            TempTablePool.getInstance((Context)partner.getContext()).releaseTable(leafAccBalanceTemp);
        }
    }

    protected void insertAccountLevelSumData(ReportPartner partner, String strFirstTableName) throws BOSException {
        ReportConditionJournal condition = (ReportConditionJournal)partner.getFixCondition();
        String currencyId = condition.getCurrencyID();
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer accLevelSumSQL = new StringBuffer();
        accLevelSumSQL.append(" insert into ").append(strFirstTableName);
        accLevelSumSQL.append(" SELECT av.fparentid AS FAccountID, \r\n");
        if (isForCurrency) {
            accLevelSumSQL.append(" t.FCurrencyID as FCurrencyID, \r\n");
        }
        accLevelSumSQL.append(" t.FCompanyID, null as FAsstHgID, \r\n");
        if (isForCurrency) {
            accLevelSumSQL.append(" sum(t.FBeginBalanceFor) AS FBeginBalanceFor,\r\n");
            accLevelSumSQL.append(" sum(t.FDebitFor) FDebitFor, \r\n");
            accLevelSumSQL.append(" sum(t.FCreditFor) FCreditFor, \r\n");
            accLevelSumSQL.append(" sum(t.FEndBalanceFor) AS FEndBalanceFor, \r\n");
        }
        if (isLocaCurrency || isForCurrency) {
            accLevelSumSQL.append(" sum(t.FBeginBalanceLocal) AS FBeginBalanceLocal,\r\n");
            accLevelSumSQL.append(" sum(t.FDebitLocal) FDebitLocal, \r\n");
            accLevelSumSQL.append(" sum(t.FCreditLocal) FCreditLocal, \r\n");
            accLevelSumSQL.append(" sum(t.FEndBalanceLocal) AS FEndBalanceLocal, \r\n");
        }
        if (isRptCurrency || isForCurrency) {
            accLevelSumSQL.append(" sum(t.FBeginBalanceRpt) AS FBeginBalanceRpt,\r\n");
            accLevelSumSQL.append(" sum(t.FDebitRpt) FDebitRpt, \r\n");
            accLevelSumSQL.append(" sum(t.FCreditRpt) FCreditRpt, \r\n");
            accLevelSumSQL.append(" sum(t.FEndBalanceRpt) AS FEndBalanceRpt, \r\n");
        }
        accLevelSumSQL.append(" sum(t.FDebitCount), \r\n");
        accLevelSumSQL.append(" sum(t.FCredtiCount), \r\n");
        accLevelSumSQL.append(" -1 FTag , \r\n");
        accLevelSumSQL.append(" 0 FLineType \r\n");
        if (GlUtils.isCompanyUnion(partner.getCompany()) && condition.isOptionShowAsstItem()) {
            accLevelSumSQL.append(" ,2 AS FAccountOrAssist  \r\n");
        }
        accLevelSumSQL.append(" from ").append(strFirstTableName).append(" t \r\n");
        accLevelSumSQL.append(" inner join t_bd_accountview av on av.fid = t.faccountid \r\n");
        accLevelSumSQL.append(" where t.FAsstHgID is null and av.flevel = ? \r\n");
        accLevelSumSQL.append(" group by av.fparentid, t.FCompanyID ");
        if (isForCurrency) {
            accLevelSumSQL.append(", t.FCurrencyID");
        }
        for (int maxLevel = this.getMaxLevel(partner.getContext(), strFirstTableName); maxLevel > condition.getAccountLevelStart(); --maxLevel) {
            DbUtil.execute((Context)partner.getContext(), (String)accLevelSumSQL.toString(), (Object[])new Object[]{maxLevel});
        }
    }

    protected int getMaxLevel(Context ctx, String table) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(flevel) maxLevel from t_bd_accountview ");
        sql.append(" where fid in (select FAccountID from ").append(table).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int maxLevel = 0;
        try {
            if (rs.next()) {
                maxLevel = rs.getInt("maxLevel");
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL error!", (Throwable)e);
        }
        return maxLevel;
    }
}

